# description= loan calculation program simulating two options for payment and borrowing:
#:
:disp "You have identified the car you would like to buy, which costs $8,000."
:disp "You can afford payments of $250 per month. You can either borrow the"
:disp "money at 10% annual interest (compounded monthly) and buy the car now,"
:disp "or invest the payments at 6% and pay cash for the car later."
:disp "How long will it take to pay for the car each way?"
:disp " "
:
:$i = .06 / 12
:$j = .10 / 12
:$m = "250((1 + $i)^x - 1) / $i"
:$n = "8000 - 250(1 - (1 + $j)^-x) / $j"
:
:$x = graph solve($m - 8000, x, 36)
:$y = graph solve($n, x, 36)
:
:disp "months required to invest to pay cash: ",$x
:disp "months required to pay of the loan: ",$y
:$z = 250 * $y
:disp "how much you would pay in total if you got a loan: $",$z
:end
:stop
:
