#ifndef CALCHELPMSG_H
#define CALCHELPMSG_H

// Documented special cases for FunctionValidityChecker: Start
/*
DERIV: Derivative function

 syntax: DERIV(expr, varname, value) or
 DERIV(expr, varname, value, prec)
 
ignore: expr, varname
----------------------------------------------------------------------------------------------------
DERIV2: Second Derivative function

 syntax: DERIV2(expr, varname, value) or
 DERIV2(expr, varname, value, prec)
 
ignore: expr, varname
----------------------------------------------------------------------------------------------------
INTEG: Integral function

 syntax: INTEG(expr, varname, lower, upper) or
 INTEG(expr, varname, lower, upper, prec)
 
ignore: expr, varname
----------------------------------------------------------------------------------------------------
SOLVE: Root solve

 syntax: SOLVE(expr, varname, guess) or
 SOLVE(expr, varname, guess, lower, upper)
 
ignore: expr, varname
----------------------------------------------------------------------------------------------------
INTERSECT: Find intersections

 syntax: INTERSECT(expr, varname, lower, upper) or
 INTERSECT(expr1, expr2, varname, lower, upper)
 
ignore: expr, varname
ignore: expr1, expr2, varname
----------------------------------------------------------------------------------------------------
FMIN: Function minimum

 syntax: FMIN(expr, varname, lower, upper) or
 FMIN(expr, varname, lower, upper, exclopt, prec)
 
ignore: expr, varname, exclopt
----------------------------------------------------------------------------------------------------
FMAX: Function maximum

 syntax: FMAX(expr, varname, lower, upper) or
 FMAX(expr, varname, lower, upper, exclopt, prec)
 
ignore: expr, varname, exclopt
----------------------------------------------------------------------------------------------------
FRAC: Fraction arithmetic

 syntax: FRAC({Add|Subtract|Multiply|Divide|+|-|*|/}, frac 1, frac 2, frac 3 ...)
 
ignore: {Add|Subtract|Multiply|Divide|+|-|*|/}
----------------------------------------------------------------------------------------------------
GRAPH : Displays a two dimensional cartesian graph of the results of a function
        performed on an expression (not available in text mode).

 syntax:
 GRAPH(expr, varname) or
 GRAPH FMIN(...) or
 GRAPH FMAX(...) or
 GRAPH DERIV(...) or
 GRAPH INTEG(...) or
 GRAPH INTERSECT(...) or
 GRAPH SOLVE(...)
 
ignore: expr, varname
----------------------------------------------------------------------------------------------------
SET: Create a set of positive integers

 syntax: SET(letter) or
 SET(letter, {integer 1, integer 2, integer 3 ...} )
 SET(letter1, letter2) or
 SET(letter, <filename>) or
 SET(letter, size, integer 1, integer 2, integer 3 ...)
 
Examples:
  set(a,4,1,2,3,5);
  set(b,4,3,5,6,7);
  set(c,a);
  set(d);
  set(e,{ 10,11,12,13 });
  set(f,sampleset1.cin);
  set(g,sampleset2.cin);
  
ignore: letter, <filename>, {...}
----------------------------------------------------------------------------------------------------
SETUNI: Perform a set union operation on two positive integer sets
 SETUNI(A,B,C), will assign to set A: B u C,
 u: denotes set union

 syntax: SETUNI(target_letter, set_letter1, set_letter2)
 
Example:
  setuni(i,d,a);
  
ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETINT: Perform a set intersection operation on two positive integer sets
 SETINT(A,B,C), will assign to set A: B n C,
 n: denotes set intersection

 syntax: SETINT(target_letter, set_letter1, set_letter2)
 
Example:
  setint(c,b,d);
  
ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETDIF: Perform a set difference operation on two positive integer sets
 SETDIF(A,B,C), will assign to set A: B - C

 syntax: SETDIF(target_letter, set_letter1, set_letter2)

Examples: 
  setdif(c,f,g);
  setdif(i,b,a);
  setdif(a,d,f);
  setdif(b,g,d);
  
ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETXDIF: Perform a symmetric set difference operation on two positive integer
 sets. SETXDIF(A,B,C), will assign to set A: (B u C) - (B n C),
 u: denotes set union,
 n: denotes set intersection

 syntax: SETXDIF(target_letter, set_letter1, set_letter2)
 
Example:
  setxdif(h,f,g); 
  
ignore: all function parameters
----------------------------------------------------------------------------------------------------
ITEMCOMB: Combinations of unique dataset items

 syntax: ITEMCOMB(sel, item 1, item 2, item 3 ...)
 
ignore: item 1, item 2, item 3 ...
----------------------------------------------------------------------------------------------------
ITEMPERM: Permutations of dataset items

 syntax: ITEMPERM(sel, item 1, item 2, item 3 ...)
 
ignore: item 1, item 2, item 3 ...
----------------------------------------------------------------------------------------------------
ITEMCOMBREP: Combinations with repetition of dataset items

 syntax: ITEMCOMBREP(sel, item 1, item 2, item 3 ...)
 
ignore: item 1, item 2, item 3 ....
----------------------------------------------------------------------------------------------------
ITEMPERMREP: Permutations with repetition of dataset items

 syntax: ITEMPERMREP(sel, item 1, item 2, item 3 ...)
 
ignore: item 1, item 2, item 3 ....
----------------------------------------------------------------------------------------------------
EVAL: Evaluation of the contents of string variables

 syntax: EVAL(x)
 
ignore: all function parameters
----------------------------------------------------------------------------------------------------
SHOW: Show the contents of string variables including any variables
 nested within them

 syntax: SHOW(x)
 
ignore: all function parameters
----------------------------------------------------------------------------------------------------
SHOWSET: Show the contents of a string variable containing a set of
 positive integers in standard set notation.

 syntax: SHOWSET(x)
 
Examples:
  showset($h);
  showset($c);
  showset($x);
  
ignore: all function parameters
----------------------------------------------------------------------------------------------------
EXEC: Executes a pre-written calculator program saved in a file.
      All calculator program files must have the extension ".prg"
      The name of the program passed to the EXEC command is simply
      the file name excluding the extension, so if you want to execute
      the program in the file "sample.prg" for example,
      you enter "EXEC sample" into the calculator

 syntax: EXEC name OR
 EXEC name.in OR
 EXEC name.in,pause OR
 EXEC name.in,nopause
 
ignore: all strings
----------------------------------------------------------------------------------------------------
E: Scientific notation of number
syntax: x E n
Returns x * 10^n, number x multiplied by 10 raised to the power of n 

ignore: notation E
----------------------------------------------------------------------------------------------------

Max special cases = 25

cases:
  Special functions
  Special constants
  Special notation
  Special program name
  Special predefined calculator variable
  Special function variable
  Special permutation item: "Item 1", "Item 2", "Item 3" ...
  Special Expression
  Special exclopt
  Special Frac ops: Add|Subtract|Multiply|Divide
  Special <filename>
  Special set letter: A, B, C ...
  Special set braces { ... }
  Special all function parameters
  Special constants: PI, E
  Special multiple decimal points ..
  Special scientific notation indicator: 10E+3
 
special key words:
  ITEMPERMREP
  ITEMCOMBREP
  INTERSECT
  ITEMPERM
  ITEMCOMB
  SETXDIF
  SHOWSET
  DERIV2
  SETUNI
  SETINT
  SETDIF
  DERIV
  INTEG
  SOLVE
  GRAPH
  FMIN
  FMAX
  FRAC
  EVAL
  SHOW
  EXEC
  SET
*/  
// Documented special cases for FunctionValidityChecker: End

#define HELPMSG1 "\
Multi-function, multi-memory, programmable scientific calculator.\n\
\n\
SYNTAX:  mcalc [math expression] | [-i <input filename>][-o <output filename>]\n\
- [math expression] is any valid mathematical expression containing numeric\n\
  values, arithmetic operators, brackets, function calls, commands, program\n\
  execution calls, variable names, constant names or string literals.\n\
  brackets:  {, }, [, ], (, )\n\
  function calls: Sin, Tan, Cos, Arcsin, Arctan, Arccos, Sinh, Cosh, Tanh,\n\
                  Sqr, Sqrt, Cube, Cubert, Exp, Log, Log10, Ceil, Floor, Abs,\n\
                  FracPart, IntPart, Rnd, Comb, Perm, CombRep, PermRep,\n\
                  ItemPerm, ItemComb, ItemPermRep, ItemCombRep, Min, Max,\n\
                  Deriv, Deriv2, Integ, Rand, Inv, Solve, Intersect, Fmin,\n\
                  Fmax, MatSolve, Round, Frac, ToHex, ToOct, ToBin, ToCmp2Bin,\n\
                  FromHex, FromOct, FromBin, FromCmp2Bin, PolToRecX, PolToRecY,\n\
                  RecToPolR, RecToPolA, Sum, Prod, AvgMean, AvgMed, AvgMode,\n\
                  StdDev, Set, SetUni, SetInt, SetDif, SetXDif\n\
  arithmetic operators: =, +=, -=, *=, /=, @=, Not, And, Or, Xor, <, >,\n\
                        <=, >=, ==, !=, +, -, *, /, @, ^, %, Fact, E\n\
  commands: Show, Eval, Precision, GetPrecision, Mode, DumpVars, GraphAllPts,\n\
            SetRecur, GraphPrec, Help, Version, History, Stdio, Conio\n\
  program execution calls: exec <program name>\n\
  variable names: $A ... $Z, ANS, ANSSTR, FRACANS\n\
  constant names: PI, E\n\
  string literals: \"hello\", \"world\"\n\
  numeric values: 10, -3, 450.231, 4.52e3, 4527.5e-3 (e for scientific notation)\n\n"

#define HELPMSG2 "\
Variables from $A through $Z can also be used to store results from math\n\
operations. The information stored in these variables can be later used in\n\
place of numeric values in a math expression, in which case the value currently\n\
stored in the variable location will be substituted into the math expression\n\
before the evaluation of the expression takes place.\n\n\
In addition to numeric values these variables can also store string values such\n\
as \"hello world\" or \"$B^2\". Concatenation of strings can be performed using\n\
the append operator +=, so if $A currently contains \"x^2 + 2*x\",\n\
$A += \" + 4\" would set $A to contain \"x^2 + 2*x + 4\". String comparisons\n\
between different string variables can be performed using the comparison\n\
operators ==, !=, <=, >=, <, >.  Literal strings like \"hello\" must first be\n\
put into string variables before the string comparison operators can be used.\n\
The contents stored within string variables can be evaluated as a mathematical\n\
expression by using the EVAL command. For example: the variable $A can contain\n\
the string \"$B^2\" and the command EVAL($A) would give the result of the\n\
contents currently stored in the variable $B squared.\n\n\
Note: to avoid infinite recursion which will stall the program, evaluation of\n\
variables names within string variables will by default be evaluated up to 26\n\
levels deep. This means that you can nest variable names such as $B within\n\
another variable like $A and continue on with another variable name nested\n\
within $B and so on, up to 26 levels deep of nesting. The program will simply\n\
refuse to process expressions that nest variables more than the set recursion\n\
limit and display an error message. To increase or decrease the recursion\n\
limit, use the command \"Set Recur=\" with the desired limit placed after the\n\
equal sign.\n\n\
Note: hexadecimal and octal based arithmetic can also be performed. All\n\
hexadecimal and octal input values must be integers only. Note when entering\n\
hexadecimal values a \"0x\" prefix must be entered before the actual hex\n\
digits. When entering octal values a \"0\" prefix must be entered before the\n\
actual octal digits. To avoid confusion and unnecessary complexity when\n\
processing math expressions, hexadecimal and octal values are only valid for\n\
the following functions, variables, constants and operators:\n\
\tNOT, AND, OR, XOR, <, >, <=, >=, ==, !=, +, -, *, /, @, FROMHEX, TOHEX,\n\
\tFROMOCT, TOOCT, FROMBIN, TOBIN, FROMCMP2BIN, TOCMP2BIN, MIN MAX,\n\
\tITEMPERM, ITEMCOMB, ITEMPERMREP, ITEMCOMBREP, =, |=, &=, +=, -=, *=, /=, @=,\n\
\t^, %, FACT, (, ), [, ], {, }, $A...$Z, ANS, ANSSTR\n\n"

#define HELPMSG3a "\
The purpose of each operator or function are as follows:\n\
\t= : assignment into any one of 26 variables: $A to $Z.\n\
\t+= : add results of math operation to specified variable and store results\n\
\t     into variable, or in the case of string variables append another string\n\
\t     to what is currently stored.\n\
\t-= : subtract results of math operation from specified variable and store\n\
\t     results into variable.\n\
\t*= : multiply results of math operation to specified variable and store\n\
\t     results into variable.\n\
\t/= : divide results of math operation from specified variable and store\n\
\t     results into variable.\n\
\t@= : modulus results of math operation from specified variable and store\n\
\t     results into variable.\n\
\t&= : \"AND\" results of math operation from specified variable and store\n\
\t     results into variable. Does bitwise \"AND\" of octal and hexadecimal\n\
\t     values.\n\
\t|= : \"OR\" results of math operation from specified variable and store\n\
\t     results into variable. Does bitwise \"OR\" of octal and hexadecimal\n\
\t     values.\n\
\t% : percent of number or divide number by 100.\n\
\tToHex: Conversion from decimal (base 10) to hexadecimal (base 16) form.\n\
\tToOct: Conversion from decimal (base 10) to octal (base 8) form.\n\
\tToBin: Conversion from decimal (base 10) to binary (base 2) form.\n\
\tToCmp2Bin : Conversion from decimal (base 10) to two\'s complement binary\n\
\t            (base 2) form.\n\
\tFromHex: Conversion from hexadecimal (base 16) to decimal (base 10) form.\n\
\tFromOct: Conversion from octal (base 8) to decimal (base 10) form.\n\
\tFromBin: Conversion from binary (base 2) to decimal (base 10) form.\n\
\tFromCmp2Bin : Conversion from two\'s complement binary (base 2) to decimal\n\
\t              (base 10) form.\n"

#define HELPMSG3b "\
\t+ : Add\n\
\t- : Subtract\n\
\t* : Multiply\n\
\t/ : Divide\n\
\t@ : Modulus\n\
\t^ : To the power of\n\
\t< : Less than (in either numeric or alphabetical order).\n\
\t> : Greater than (in either numeric or alphabetical order).\n\
\t<= : Less than or equal (in either numeric or alphabetical order).\n\
\t>= : Greater than or equal (in either numeric or alphabetical order).\n\
\t== : Equal (in either numeric or alphabetical order).\n\
\t!= : Not equal (in either numeric or alphabetical order).\n"

#define HELPMSG3c "\
\tNot : Logical not (bitwise not for octal and hexadecimal values).\n\
\tAnd : Logical and (bitwise and for octal and hexadecimal values).\n\
\tOr : Logical or (bitwise or for octal and hexadecimal values).\n\
\tXor : Logical exclusive or (bitwise exclusive or for octal and hexadecimal\n\
\t      values).\n\
\tSin : Sine\n\
\tTan : Tangent\n\
\tCos : Cosine\n\
\tArcSin : ArcSine or Reverse Sine\n\
\tArcTan : ArcTangent or Reverse Tangent\n\
\tArcCos : ArcCosine or Reverse Cosine\n\
\tSinh : Hyperbolic Sine\n\
\tCosh : Hyperbolic Cosine\n\
\tTanh : Hyperbolic Tangent\n"

#define HELPMSG3d "\
\tRecToPolr : Rectangular to Polar Return Radius\n\
\tRecToPola : Rectangular to Polar Return Angle\n\
\tPolToRecx : Polar to Rectangular Return X\n\
\tPolToRecy : Polar To Rectangular Return Y\n\
\tE : Scientific notation\n\
\tMin : Minimum of two numbers or a range of numbers\n\
\tMax : Maximum of two numbers or a range of numbers\n\
\tDeriv : Derivative\n\
\tDeriv2 : Second Derivative\n\
\tInteg : Integral\n\
\tSolve : Root Solving\n\
\tIntersect : Find points of intersection\n\
\tFmin : Function Minimum\n\
\tFmax : Function Maximum\n\
\tMatSolve : Solve system of linear equations put in matrix-vector form\n"

#define HELPMSG3e "\
\tSqr : Square\n\
\tSqrt : Square root\n\
\tCube : Cube\n\
\tCubert : Cube root\n\
\tExp : Exponent of E\n\
\tLog : Natural logarithm\n\
\tLog10 : Logarithm of 10\n\
\tCeil : Ceiling\n\
\tFloor : Floor\n\
\tRand : Random Number\n\
\tInv : Multiplicative Inverse\n\
\tFrac : Fraction arithmetic\n"

#define HELPMSG3f "\
\tSum : Cumulative sum of a series of numbers, file name input accepted\n\
\tProd : Cumulative product of a series of numbers, file name input accepted\n\
\tAvgMean : Mean average of a series of numbers, file name input accepted\n\
\tAvgMed : Median average of a series of numbers\n\
\tAvgMode : Mode average of a series of numbers\n\
\tStdDev : Standard deviation of a series of numbers, file name input accepted\n\
\tGraph : Plot graph of expression (not available in text mode)\n\
\tGraph fmin(...) : Plot graph of minimum of an expression\n\
\t                  (not available in text mode)\n\
\tGraph fmax(...) : Plot graph of maximum of an expression\n\
\t                  (not available in text mode)\n\
\tGraph deriv(...) : Plot graph of derivative of an expression\n\
\t                   (not available in text mode)\n\
\tGraph integ(...) : Plot graph of integral of an expression\n\
\t                   (not available in text mode)\n\
\tGraph solve(...) : Plot graph of a root of an expression\n\
\t                   (not available in text mode)\n\
\tGraph intersect(...) : Plot graph of points of intersection of expression(s)\n\
\t                       (not available in text mode)\n"

#define HELPMSG3g "\
\tRound : Round to the specified exponent\n\
\tRnd : Round to nearest integer\n\
\tAbs : Absolute value\n\
\tFracPart : Fractional part of number\n\
\tIntPart : Integer part of number\n\
\tFact : Factorial\n\
\tComb : Combination\n\
\tPerm : Permutation\n\
\tCombRep : Combination with repetition\n\
\tPermRep : Permutation with repetition\n\
\tSet: Create a set of positive integers\n\
\tSetUni: Perform a set union operation on two positive integer sets\n\
\tSetInt: Perform a set intersection operation on two positive integer sets\n\
\tSetDif: Perform a set difference operation on two positive integer sets\n\
\tSetXDif: Perform a symmetric set difference operation on two positive\n\
\t         integer sets\n\
\tItemComb : List combinations of items\n\
\tItemPerm : List permutations of items\n\
\tItemCombRep : List combinations with repetition of items\n\
\tItemPermRep : List permutations with repetition of items\n\
\tEval: Evaluation of the contents of string variables\n\
\tShow: Show the contents of string variables including the contents of any\n\
\t      variables nested within them\n\
\tShowSet: Show the contents of a string variable containing a set of\n\
           positive integers in standard set notation.\n\
\tMode=: Set the angle unit to either radians or degrees\n\
\tPrecision=: Set the unit precision to float, double, long double or longnum\n\
\tGetPrecision: Show the unit precision details\n\
\tDumpVars: Display the contents of all variables: $A-$Z, ans, ansstr, fracans\n\
\tGraphAllPts: Sets calculator to graph all points even for those points\n\
               approaching -inf and +inf in plot mode when this is set to\n\
               true. If set to false the calculator will show small red points\n\
               as -inf or +inf for points approaching infinity.\n\
\tSetRecur=: Set the variable nesting limit when using the Eval or Show\n\
\t           commands\n\
\tGraphPrec=: Set the default graphing interval precision for graphing\n\
\t            functions which defaults to .0001 if not explicitly set.\n\
\tHelp: Show this help screen or detailed help by function name\n\
\tExec: Execution of pre-written calculator program files\n\
\t      enter \"help exec\" for more information on writing\n\
\t      and running calculator programs\n\
\tVersion: Shows the current software version number.\n\
\tHistory: Shows command history list (1 to 50 stored commands).\n\
\tStdio: Set standard input/output mode\n\
\tConio: Set console input/output mode\n\n"

#define HELPMSG3h "\
The following constants and answer variables are also available:\n\
\tPI: Pi constant set to the precision of the current precision unit\n\
\tE: E natural exponent set to the precision of the current precision unit\n\
\tANS: Decimal answer to the evaluated expression\n\
\tANSSTR: Literal, octal or hexadecimal answer to the evaluated expression\n\
\tFRACANS: Fraction answer to the evaluated expression\n\n"

#define HELPMSG4a "\
Entering \"quit\" from the interactive prompt will stop the program\n\n\
This help message will be displayed by entering \"help\" on the program\'s\n\
interactive prompt or by specifying --help as an argument on the shell command\n\
line.\n\n\
Function specific help will be displayed by entering \"help\" <name of function>\n\
on the shell command line. For example: \"help deriv\" will display a help screen\n\
specific to the derivative command. Functions that do not have specific help\n\
screens are simple and self explanatory from the general help screen.\n\n\
different angle units can be specified by entering: mode=radian or mode=degree\n\
different precision units can be specified by entering: precision=float,\n\
\tprecision=double, precision=longdouble or precision=longnum\n\n\
with each unit having a digit precision of:\n\
\tFloat (7-digit precision)\n\
\tDouble (15-digit precision)\n\
\tLong Double (19-digit precision)\n\
\tLong Number (arbitrary precision)\n\
\n\
Each precision unit: float, double, long double, long number is actually an\n\
individual calculator and each calculator has its own set of 26 letter\n\
variables for DECIMAL value storage, excluding string variables which are\n\
shared globally. By default all variables of a calculator are transferred over\n\
to the new calculator after a precision unit change.\n\
Alternatively you can choose not to do this and have each calculator preserve\n\
its own set of decimal variables by specifying \",keepvars\" after the precision\n\
unit name in the precision command. example: precision=longnum,keepvars\n\
which will skip tranferring variables from the previous calculator to the long\n\
number calculator.\n\
\n\
* Warning: when you use base conversion commands:\n\
\tToHex, ToOct, ToBin, ToCmp2Bin, FromHex, FromOct, FromBin, FromCmp2Bin\n\
\n\
any assignment to variables: $A...$Z will assign to the long number calculator\n\
variables as well as the variables in the currently used calculator\n"

#define HELPMSG4b "\
* Note: because the Long Number unit is custom designed and developed and not\n\
  an inherent part of the programming language used to developed this\n\
  application, calculations involving Long Number units depending on the\n\
  complexity of the operations or functions may take a significantly longer\n\
  time to complete than those involving Floats, Doubles, or Long Doubles.\n\n\
* Note: because of performance and speed issues Long Number operations and\n\
  functions involving matrices, statistics, trigonometry, roots, natural\n\
  logarithms and exponents will be using long double precision\n\
  (19-digit precision) instead of arbitrary precision.\n\n\
The full unit name and precision information as shown in the format above\n\
can be retrieved by entering the \"get precision\" command at the command line\n\n\
On the program\'s interactive prompt the current settings for angle units and\n\
the unit\'s digit precision are displayed as MCALC:<prec>:<angle>\n\
where <prec> can be any one of: \"flt\": specifying float,\n\
                                \"dbl\": specifying double,\n\
                                \"ldbl\": specifying long double,\n\
                                \"lnum\": specifying long number\n\
where <angle> can be any one of: \"rad\": specifying radian\n\
                                 \"deg\": specifying degree\n\n"

#define HELPMSG5 "\
The arguments to the program can be entered directly from the command line\n\
or from an input file. Alternatively mcalc can be run interactively by typing\n\
mcalc on the command line without any arguments. While in interactive mode\n\
command line continuation for long commands which spans more than one line can\n\
be accomplished by entering the back slash character \"\\\" at the end of a\n\
line. The continuation character is not required in graphics mode and commands\n\
may span multiple lines with the &quot;Enter&quot; key pressed to indicate the\n\
end of a command. Pre-written calculator program files can also be loaded and\n\
executed either interactively or from an input file enter \"help exec\" for\n\
more information on writing and running calculator programs.\n\n"

#define HELPMSG6 "\
When entering from an input file enter the name of the input file after the\n\
program name and \"-i\". Each line of the input file should contain the same\n\
arguments that you would normally type from the command line to perform the\n\
calculation.\n\
NOTE: all expressions within input files must indicate termination by entering\n\
a semi-colon \";\". Comments in input files can be specified by starting a line\n\
with a hash mark \"#\". Comment lines or blocks of comment lines must also\n\
indicate termination with a semi-colon.\n\
\n\
Optionally, a short one line description of the input file can be written at\n\
the beginning of the input file to provide a short description in the table of\n\
available calculator programs shown in the GUI version of the calculator.\n\
The description line must start with \"# description=\" before the actual\n\
description phrase in order for the program to recognize it as a description\n\
line.\n\
\n\
Qmcalc will reserve the following characters to use in calculator script files\n\
for special purposes: : ; # = & \n\
So in comment lines that are indicated with the \"#\" character at the start\n\
of the line, some specific characters must be replaced with their associated\n\
escape sequences for Qmcalc to recognize and process them correctly:\n\
\n\
To display these characters while reading from a calculator script file \".prg\"\n\
or input data file \".in\", the following escape sequences must be used instead:\n\
\n\
  &amp; or &#38;   for the ampersand character: &\n\
  &sc; or &#59;    for the semicolon character: ;\n\
  &hash; or &#35;  for the number sign or hash character: #\n\
  &col; or &#58;   for the colon character: :\n\
  &eq; or &#61;    for the equal character: =\n\
\n\n"

#define HELPMSG7 "\
Metric to English unit conversions\n\
----------------------------------\n\
Metric to/from English unit conversions can be accomplished by executing the\n\
following programs using the EXEC command:\n\
Length unit conversions      : lencon.prg\n\
Area unit conversions        : areacon.prg\n\
Volume unit conversions      : volcon.prg\n\
Weight unit conversions      : wgtcon.prg\n\
Power unit conversions       : powcon.prg\n\
Energy unit conversions      : energycon.prg\n\
Angle unit conversions       : anglecon.prg\n\
Temperature unit conversions : tempcon.prg\n\
\n\
Area and volume of common shapes\n\
--------------------------------\n\
Two programs are provided to determine the area and volume of common shapes\n\
To determine the area of common plane figures execute             : area.prg\n\
To determine the surface area and volume of common shapes execute : volume.prg\n\
\n\
Calculator test programs and input files\n\
----------------------------------------\n\
The following program and data input files are provided for testing the\n\
calculator:\n\
sample.prg : program for testing general calculator operations.\n\
sample2.prg : test program file called from within sample.prg.\n\
dice.prg : program for playing a simple game of dice.\n\
pyth.prg : program to determine the length of the hypotenuse of a right\n\
           angle triangle using the Pythagorean theorem.\n\
loan.prg : sample loan calculation program with function graph output.\n\
           graphics output can only be shown on GUI mode calculator.\n\
calcinteg.prg : program to calculate an approximation of an integral\n\
                by using Taylor polynomials.\n\
errcond.in : test deliberate input errors for detection of error conditions.\n\
graphtest.in : test program for calculator graph plotting operations.\n\
matsolve.in : matrix solving test file.\n\
quicktest.in : Short quick test file for qmcalc excluding lengthy calculations\n\
               and program calls.\n\
testcalc.in : Calculator test data input file for testing all operations\n\
              of the calculator.\n\
testexec.in : calculator script programs execution tests.\n\
testset.in : test program for calculator set operatons.\n\
\n\
Program Options \n\
--------------- \n\
-i <filename> : specify an input file (Default: standard display input) \n\
-o <filename> : specify an output file (Default: standard display output) \n\
-consoleio : specify console mode input/output instead of standard I/O\n\
mcalc with no arguments to run interactively\n\
qmcalc with no arguments to run in GUI mode\n\
\n\
Option to run input data files in GUI mode:\n\
-------------------------------------------\n\
starting with version 2.7 the option to run input test files from the GUI\n\
version of the calculator is available. Clicking on the \"EXEC\" button on the\n\
calculator form will bring up a table listing all available programs for the\n\
calculator to run.\n\
\n\
Optionally, a short one line description of the input file can be written at\n\
the beginning of the input file to provide a short description in the table\n\
of available calculator programs shown in the GUI version of the calculator.\n\
The description line must start with \"# description=\" before the actual\n\
description phrase in order for the program to recognize it as the description.\n\n"

#define MCALC_VERSION_INFO "\
Mcalc Graphical Scientific Calculator\n\
Mcalc Version: 2.8.2\n\n"

#define QMCALC_VERSION_INFO "\
Qmcalc Graphical Scientific Calculator\n\
Qmcalc Version: 2.8.2\n\n"

#define HELPMSG_VERSION "\
VERSION: Shows the current software version number.\n\
\n\
syntax: VERSION\n\
\n\
Displays:\n\
Mcalc Graphical Scientific Calculator\n\
Mcalc Version: x.x\n\n"

#define HELPMSG_HISTORY "\
HISTORY: Show interactive command history list (In Console I/O mode only)\n\
\n\
syntax: HISTORY\n\
\n\
Shows an interactive command history list which allows the user to pick from\n\
1 to 50 of the most recently executed valid calculator commands.\n\
Each entry of the command history list shown will be appended with a prompt\n\
asking the user whether or not to execute the command shown in the entry,\n\
skip to the next command stored in the history list or quit the interactive\n\
command history list. NOTE: The entries in the command history list is\n\
displayable only in console Input/Output mode and will temporarily switch to\n\
that mode when displaying the selected history list entry if the calculator\n\
is not already in that display mode.\n\
\n\
Execute: {command to execute} [(x of tt)|Enter=(N)o/(Y)es/(Q)uit]: _\n\
\n\
Where {command to execute} is the command stored in the command history list\n\
entry which is currently shown to the user. Pressing or clicking the Enter\n\
key or entering \"no\" or n will skip to the next command in the history list.\n\
Entering \"yes\" or y will show the selected command on the calculator\n\
interactive command line prompt allowing the user to execute the command or\n\
modify it before execution. Entering \"quit\" or q will quit the command\n\
history list. The numerical order of the entry shown will also be displayed\n\
with (x of tt) showing the current entry order number x out of the total\n\
number of entries tt (maximum of 50) stored in the command history list.\n\
\n\
NOTE: Text mode in place editing of selected command history list entries\n\
      is only available for windows. In Linux the selected entry from the\n\
      command history list is executed as is when in text mode and cannot\n\
      be modified before execution since direct console I/O is not\n\
      implemented for the Linux version of the Mcalc calculator.\n\n"

#define HELPMSG_STDIO "\
STDIO: Set standard input/output mode for the calculator\n\
\n\
syntax: STDIO\n\
\n\
Set the input/output mode of the calculator to standard text mode I/O.\n\
The calculator can be in either one of two modes. Console I/O which can be\n\
turned on using the -consoleio option when executing mcalc in text mode or\n\
Standard I/O which is the default I/O mode when executing mcalc without any\n\
options specified. Entering the Stdio command on the command line prompt will\n\
set standard input/output mode for the calculator if it is not already in\n\
that display mode.\n\n"

#define HELPMSG_CONIO "\
CONIO: Set console input/output mode for the calculator\n\
\n\
syntax: CONIO\n\
\n\
Set the input/output mode of the calculator to direct console mode I/O.\n\
The calculator can be in either one of two modes. Console I/O which can be\n\
turned on using the -consoleio option when executing mcalc in text mode or\n\
Standard I/O which is the default I/O mode when executing mcalc without any\n\
options specified. Entering the Conio command on the command line prompt will\n\
set direct console input/output mode for the calculator if it is not already\n\
in that display mode.\n\n"

#define HELPMSG_CONST_PI "\
PI: Pi constant\n\
\n\
syntax: PI\n\
\n\
Gives the value of Pi up to the limit of the current precision unit,\n\
so if for example the current precision unit is long double then Pi\n\
is given up to 19 digit places of precision. The Pi constant name\n\
can be placed anywhere within the given expression. The actual value\n\
up to the specified precision will be substituted in during evaluation\n\n"

#define HELPMSG_CONST_E "\
E: Natural exponent constant\n\
\n\
syntax: E\n\
\n\
Gives the value of E up to the limit of the current precision unit,\n\
so if for example the current precision unit is long double then E\n\
is given up to 19 digit places of precision. The E constant name\n\
can be placed anywhere within the given expression (except between two\n\
decimal numbers which would specify scientific notation). The actual value\n\
up to the specified precision will be substituted in during evaluation\n\n"

#define HELPMSG_FNC_ANS "\
ANS: Decimal answer variable\n\
\n\
syntax: ANS\n\
\n\
Gives the decimal answer to the evaluated expression if applicable.\n\
If a decimal answer does not apply for the evaluated expression,\n\
the contents of this variable is usually the result of previous operations\n\
except for when the EVAL command is executed. This variable also contains the\n\
converted decimal answer for fraction, octal and hexadecimal operations\n\n"

#define HELPMSG_FNC_FRACANS "\
FRACANS: Fraction answer variable\n\
\n\
syntax: FRACANS\n\
\n\
Gives the fraction answer to the evaluated expression if applicable.\n\
If a fraction answer does not apply for the evaluated expression,\n\
the contents of this variable is usually the result of previous operations\n\
except for when the EVAL command is executed. Note: as a result of fraction\n\
operations the ANS variable will simultaneously contain the equivalent decimal\n\
value of the fraction result.\n\n"

#define HELPMSG_FNC_ANSSTR "\
ANSSTR: Literal, octal or hexadecimal answer variable\n\
\n\
syntax: ANSSTR\n\
\n\
Gives the literal, octal or hex answer to the evaluated expression if\n\
applicable. If a literal answer does not apply for the evaluated expression,\n\
the contents of this variable is usually the result of previous operations\n\
except for when the EVAL command is executed. Note: as a result of hex or\n\
octal operations the ANS variable will simultaneously contain the equivalent\n\
decimal value of the hex or octal result.\n\n"

#define HELPMSG_FNC_MIN "\
MIN: Minimum function\n\
\n\
syntax: MIN(x, y)                or\n\
        MIN(n, x1, x2, ...xn)    or\n\
        MIN(<filename>)\n\
\n\
returns the minimum of the two values: x, y\n\
or a range of numbers specified by n and starts from x1 to xn\n\
or a single argument specifying the name of the plain text file containing\n\
the series of numbers with each element in the file seperated by spaces or\n\
starting at a new line.\n\n"

#define HELPMSG_FNC_MAX "\
MAX: Maximum function\n\
\n\
syntax: MAX(x, y)                or\n\
        MAX(n, x1, x2, ...xn)    or\n\
        MAX(<filename>)\n\
\n\
returns the maximum of the two values: x, y\n\
or a range of numbers specified by n and starts from x1 to xn\n\
or a single argument specifying the name of the plain text file containing\n\
the series of numbers with each element in the file seperated by spaces or\n\
starting at a new line.\n\n"

#define HELPMSG_FNC_DERIV "\
DERIV: Derivative function\n\
\n\
syntax: DERIV(expr, varname, value)         or\n\
        DERIV(expr, varname, value, prec)\n\
\n\
returns the approximate derivative of <expr> with respect\n\
to variable <varname> given the <value> at which to calculate\n\
the derivative and the (optional) precision <prec> to calculate up to.\n\
As <prec> gets smaller, the approximation usually gets more accurate\n\
The central difference formula is used for this function\n\n"

#define HELPMSG_FNC_DERIV2 "\
DERIV2: Second Derivative function\n\
\n\
syntax: DERIV2(expr, varname, value)         or\n\
        DERIV2(expr, varname, value, prec)\n\
\n\
returns the approximate second derivative of <expr> with respect\n\
to variable <varname> given the <value> at which to calculate\n\
the second derivative and the (optional) precision <prec> to calculate up to.\n\
As <prec> gets smaller, the approximation usually gets more accurate\n\
The central difference formula method is used for this function\n\n"

#define HELPMSG_FNC_INTEG "\
INTEG: Integral function\n\
\n\
syntax: INTEG(expr, varname, lower, upper)         or\n\
        INTEG(expr, varname, lower, upper, prec)\n\
\n\
returns the approximate numerical integral of <expr> with respect\n\
to variable <varname> given the <upper> and <lower> bounds at which\n\
to calculate the integral and the precision <prec> to calculate up to\n\
As <prec> gets smaller, the approximation usually gets more accurate\n\
The trapezoid rule is used for this function\n\n"

#define HELPMSG_FNC_FMIN "\
FMIN: Function minimum\n\
\n\
syntax: FMIN(expr, varname, lower, upper)         or\n\
        FMIN(expr, varname, lower, upper, exclopt, prec)\n\
\n\
returns the value at which the minimum value for expression with\n\
respect to variable <varname> occurs, between <lower> and <upper>\n\
values for <varname>. <lower> must be less than <upper>.\n\
The precision of the calculation can be specified with the\n\
(optional) variable <prec> which if not explicitly specified is 1E-5.\n\
The optional exclopt argument can either be: INCLUDE ENDS or EXCLUDE ENDS\n\
If EXCLUDE ENDS is specified then the lower and upper function endpoint\n\
values are not included when determining the minimum function value.\n\
By default INCLUDE ENDS is specified.\n\n"

#define HELPMSG_FNC_FMAX "\
FMAX: Function maximum\n\
\n\
syntax: FMAX(expr, varname, lower, upper)         or\n\
        FMAX(expr, varname, lower, upper, exclopt, prec)\n\
\n\
returns the value at which the maximum value for expression with\n\
respect to variable <varname> occurs, between <lower> and <upper>\n\
values for <varname>. <lower> must be less than <upper>.\n\
The precision of the calculation can be specified with the\n\
(optional) variable <prec> which if not explicitly specified is 1E-5.\n\
The optional exclopt argument can either be: INCLUDE ENDS or EXCLUDE ENDS\n\
If EXCLUDE ENDS is specified then the lower and upper function endpoint\n\
values are not included when determining the maximum function value.\n\
By default INCLUDE ENDS is specified.\n\n"

#define HELPMSG_FNC_MATSOLVE "\
MATSOLVE: Solve system of linear equations put in matrix-vector form\n\
\n\
syntax: MATSOLVE\n\
        ( \n\
          (a11, a12, a13, ... | b1)   \n\
          (a21, a22, a23, ... | b2)   \n\
          (a31, a32, a33, ... | b3)   \n\
          ...                         \n\
          (aN1, aN2, aN3, ... | bN)   \n\
        ) \n\
\n\
returns the solution as: x1 = value1, x2 = value2, ... xN = valueN\n\
for each variable x1...xN in the system of equations. a11...aN3 denotes the\n\
coefficients for each variable. b1...bN denotes to right-side value of each\n\
equation. The number of rows in the matrix must be equal to the number of\n\
columns (not including the right-side value column), otherwise the function\n\
will halt with an error message.\n\n"

#define HELPMSG_FNC_SOLVE "\
SOLVE: Root solve\n\
\n\
syntax: SOLVE(expr, varname, guess)                 or\n\
        SOLVE(expr, varname, guess, lower, upper)\n\
\n\
returns a solution (root) of <expr> for <varname>, given the initial\n\
<guess>, optionally a lower and upper bound within which a solution is\n\
sought can be specified. <expr> is assumed equal to zero.\n\n"

#define HELPMSG_FNC_INTERSECT "\
INTERSECT: Find intersections\n\
\n\
syntax: INTERSECT(expr, varname, lower, upper)           or\n\
        INTERSECT(expr1, expr2, varname, lower, upper)\n\
\n\
find points of intersection between two functions of variable <varname>\n\
<expr1> and <expr2>, optionally a lower and upper bound within which the\n\
points of intersection is sought after can be specified. If the second\n\
function is omitted then points of intersection between the single function\n\
specified <expr> and the x = 0 line (x axis) is sought after, that is the\n\
function <expr> is equated to zero. The function returns the number of\n\
intersection points found. The coordinates of the intersection points\n\
themselves are stored in the file: mcalc_graph<session#>z where <session #>\n\
is substituted with the current session number for the calculator or 0 if not\n\
in asynchronous mode.\n\n"

#define HELPMSG_FNC_PERMREP "\
PERMREP: Number of permutations with repetition\n\
\n\
syntax: PERMREP(size, sel)\n\
\n\
returns the number of permutations (orderings) with repetition of data set\n\
members allowed given the <size> of the dataset and the size of the selection\n\
<sel> for the resultant set.\n\n"

#define HELPMSG_FNC_COMBREP "\
COMBREP: Number of combinations with repetition\n\
\n\
syntax: COMBREP(size, sel)\n\
\n\
returns the number of combinations with repetition of data set members allowed\n\
given the <size> of the dataset and the size of the selection <sel> for the\n\
resultant set.\n\n"

#define HELPMSG_FNC_COMB "\
COMB: Number of combinations\n\
\n\
syntax: COMB(size, sel)\n\
\n\
returns the number of combinations of unique data set members\n\
(repetition not allowed) given the <size> of the dataset and the size of the\n\
selection for the resultant set.\n\n"

#define HELPMSG_FNC_PERM "\
PERM: Number of permutations\n\
\n\
syntax: PERM(size, sel)\n\
\n\
returns the number of permutations (orderings) of unique data set members\n\
given the <size> of the dataset and the size of the selection for the resultant\n\
set.\n\n"

#define HELPMSG_FNC_ITEMCOMBREP "\
ITEMCOMBREP: Combinations with repetition of dataset items\n\
\n\
syntax: ITEMCOMBREP(sel, item 1, item 2, item 3 ...)\n\
\n\
returns each combination of the dataset comprising of items: item 1 ... item n\n\
with the resultant set limited to <sel> selection of items from the original\n\
dataset. Repetition of dataset items is allowed.\n\n"

#define HELPMSG_FNC_ITEMPERMREP "\
ITEMPERMREP: Permutations with repetition of dataset items\n\
\n\
syntax: ITEMPERMREP(sel, item 1, item 2, item 3 ...)\n\
\n\
returns each permutation (orderings) of the dataset comprising of items:\n\
item 1 ... item n. with the resultant set limited to <sel> selection of\n\
items from the original dataset. Repetition of dataset items is allowed.\n\n"

#define HELPMSG_FNC_ITEMCOMB "\
ITEMCOMB: Combinations of unique dataset items\n\
\n\
syntax: ITEMCOMB(sel, item 1, item 2, item 3 ...)\n\
\n\
returns each combination of the dataset comprising of items: item 1 ... item n\n\
with the resultant set limited to <sel> selection of unique items from the\n\
original dataset. Repetition of dataset items is not allowed.\n\n"

#define HELPMSG_FNC_ITEMPERM "\
ITEMPERM: Permutations of dataset items\n\
\n\
syntax: ITEMPERM(sel, item 1, item 2, item 3 ...)\n\
\n\
returns each permutation (orderings) of the dataset comprising of items:\n\
item 1 ... item n. with the resultant set limited to <sel> selection of\n\
items from the original dataset.\n\n"

#define HELPMSG_FNC_SET "\
SET: Create a set of positive integers\n\
\n\
syntax: SET(letter)                                              or\n\
        SET(letter1, letter2)                                    or\n\
        SET(letter, filename)                                    or\n\
        SET(letter, size, integer 1, integer 2, integer 3 ...)\n\
\n\
Creates a null set or a set containing a specified number of positive\n\
integers. <letter> is the letter variable ($A...$Z) containing the set.\n\
<size> is the size of the set as the number of positive integers it contains.\n\
Specifying only the set letter without other arguments creates a null set.\n\
Specifying a set letter followed by another set letter assigns the 2nd\n\
letter set <letter2> to the first letter set <letter1>.\n\
Specifying the set letter and a file name as the 2nd argument opens the file,\n\
reads the file contents and assigns the contents of the file into the set\n\
as set elements\n\n"

#define HELPMSG_FNC_SETUNI "\
SETUNI: Perform a set union operation on two positive integer sets\n\
        SETUNI(A,B,C), will assign to set A: B u C,\n\
        u: denotes set union\n\
\n\
syntax: SETUNI(target_letter, set_letter1, set_letter2)\n\
\n\
Performs a set union operation on the sets with the letter variable\n\
<set_letter1> and <set_letter2> which refers to letter variable ($A...$Z)\n\
then puts the results from the set union operation into <target_letter> set.\n\n"

#define HELPMSG_FNC_SETINT "\
SETINT: Perform a set intersection operation on two positive integer sets\n\
        SETINT(A,B,C), will assign to set A: B n C,\n\
        n: denotes set intersection\n\
\n\
syntax: SETINT(target_letter, set_letter1, set_letter2)\n\
\n\
Performs a set intersection operation on the sets with the letter variable\n\
<set_letter1> and <set_letter2> which refers to letter variable ($A...$Z)\n\
then puts the results from the set intersection operation into\n\
<target_letter> set.\n\n"

#define HELPMSG_FNC_SETDIF "\
SETDIF: Perform a set difference operation on two positive integer sets\n\
        SETDIF(A,B,C), will assign to set A: B - C\n\
\n\
syntax: SETDIF(target_letter, set_letter1, set_letter2)\n\
\n\
Performs a set difference operation on the sets with the letter variable\n\
<set_letter1> and <set_letter2> which refers to letter variable ($A...$Z)\n\
then puts the results from the set difference operation into <target_letter>\n\
set.\n\n"

#define HELPMSG_FNC_SETXDIF "\
SETXDIF: Perform a symmetric set difference operation on two positive integer\n\
         sets. SETXDIF(A,B,C), will assign to set A: (B u C) - (B n C),\n\
         u: denotes set union,\n\
         n: denotes set intersection\n\
\n\
syntax: SETXDIF(target_letter, set_letter1, set_letter2)\n\
\n\
Performs a symmetric set difference operation on the sets with the letter\n\
variable <set_letter1> and <set_letter2> which refers to letter variable\n\
($A...$Z) then puts the results from the symmetric set difference operation\n\
into <target_letter> set.\n\n"

#define HELPMSG_FNC_FRAC "\
FRAC: Fraction arithmetic\n\
\n\
syntax: FRAC({Add|Subtract|Multiply|Divide|+|-|*|/}, frac 1, frac 2, frac 3 ...)\n\
\n\
The first argument to the function is the name of the arithmetic operation to\n\
be performed which can be either the literal word name as in Add, Subtract,\n\
Multiply or Divide or the arithmetic symbol for the operation such as +,-,*,/.\n\
The operation specified will be performed on all following fractions entered\n\
into this function\n\
\n\
Add fractions frac 1 + ... + frac n and returns the result as a fraction or\n\
Subtract fractions frac 1 - ... - frac n and returns the result as a fraction or\n\
Multiply fractions frac 1 * ... * frac n and returns the result as a fraction or\n\
Divide fractions frac 1 / ... / frac n and returns the result as a fraction\n\n"

#define HELPMSG_FNC_RECTOPOLR "\
RECTOPOLR: Rectangular to polar coordinates, return radius component\n\
\n\
syntax: RECTOPOLR(x, y)\n\
\n\
Rectangular to polar coordinates conversion function, returns the radius\n\
component of the corresponding polar coordinate\n\n"

#define HELPMSG_FNC_RECTOPOLA "\
RECTOPOLA: Rectangular to polar coordinates, return angle component\n\
\n\
syntax: RECTOPOLA(x, y)\n\
\n\
Rectangular to polar coordinates conversion function, returns the angle\n\
component of the corresponding polar coordinate\n\n"

#define HELPMSG_FNC_POLTORECX "\
POLTORECX: Polar to rectangular coordinates, return x component\n\
\n\
syntax: POLTORECX(R, A)\n\
\n\
Polar to rectangular coordinates conversion function, returns the x\n\
component of the corresponding rectangular coordinate\n\n"

#define HELPMSG_FNC_POLTORECY "\
POLTORECY: Polar to rectangular coordinates, return y component\n\
\n\
syntax: POLTORECY(R, A)\n\
\n\
Polar to rectangular coordinates conversion function, returns the y\n\
component of the corresponding rectangular coordinate\n\n"

#define HELPMSG_FNC_RAND "\
RAND: Random number generator\n\
\n\
syntax: RAND(n)\n\
\n\
Returns a random integer in the range: 1 to n-1\n\n"

#define HELPMSG_FNC_INV "\
INV: Multiplicative inverse\n\
\n\
syntax: INV(n)\n\
\n\
Returns value equal to 1/n\n\n"

#define HELPMSG_FNC_ROUND "\
ROUND: Round value to specific exponent\n\
\n\
syntax: ROUND(n, x)\n\
\n\
Returns value n rounded to the specified exponent x\n\n"

#define HELPMSG_FNC_CEIL "\
CEIL: Ceiling value of number\n\
\n\
syntax: CEIL(n)\n\
\n\
Returns the closest integer value greater than n if n is a floating point\n\
value between two integers or n if n is an integer\n\n"

#define HELPMSG_FNC_FLOOR "\
FLOOR: Floor value of number\n\
\n\
syntax: FLOOR(n)\n\
\n\
Returns the closest integer value lower than n if n is a floating point\n\
value between two integers or n if n is an integer\n\n"

#define HELPMSG_FNC_SCINOTE "\
E: Scientific notation of number\n\
\n\
syntax: x E n\n\
\n\
Returns x * 10^n, number x multiplied by 10 raised to the power of n\n\n"

#define HELPMSG_FNC_TOHEX "\
TOHEX: Decimal to hexadecimal conversion function\n\
\n\
syntax: TOHEX(x)\n\
\n\
Returns the equivalent hexadecimal value from the given decimal value x\n\n"

#define HELPMSG_FNC_TOOCT "\
TOOCT: Decimal to octal conversion function\n\
\n\
syntax: TOOCT(x)\n\
\n\
Returns the equivalent octal value from the given decimal value x\n\n"

#define HELPMSG_FNC_TOBIN "\
TOBIN: Decimal to binary conversion function\n\
\n\
syntax: TOBIN(x)\n\
\n\
Returns the equivalent binary value from the given decimal value x\n\n"

#define HELPMSG_FNC_TOCMP2BIN "\
TOCMP2BIN: Decimal to two\'s complement binary conversion function\n\
\n\
syntax: TOCMP2BIN(x)             or\n\
        TOCMP2BIN(x, Bytes)        \n\
\n\
Returns the equivalent two\'s complement binary value from the given\n\
decimal value x. The output will automatically adjust to the minimum\n\
number of bytes necessary to express the resulting binary value in\n\
two\'s complement form. Optionally, the number of bytes for the result\n\
can be explicitly stated.\n\n"

#define HELPMSG_FNC_FROMHEX "\
FROMHEX: Hexadecimal to decimal conversion function\n\
\n\
syntax: FROMHEX(x)\n\
\n\
Returns the equivalent decimal value from the given hexadecimal value x\n\n"

#define HELPMSG_FNC_FROMOCT "\
FROMOCT: Octal to decimal conversion function\n\
\n\
syntax: FROMOCT(x)\n\
\n\
Returns the equivalent decimal value from the given octal value x\n\n"

#define HELPMSG_FNC_FROMBIN "\
FROMBIN: Binary to decimal conversion function\n\
\n\
syntax: FROMBIN(x)\n\
\n\
Returns the equivalent decimal value from the given binary value x\n\n"

#define HELPMSG_FNC_FROMCMP2BIN "\
FROMCMP2BIN: Two\'s complement binary to decimal conversion function\n\
\n\
syntax: FROMCMP2BIN(x)\n\
\n\
Returns the equivalent decimal value from the given binary value\n\
in two\'s complement form x.\n\n"

#define HELPMSG_FNC_AVGMEAN "\
AVGMEAN: Mean average of a series of numbers\n\
\n\
syntax: AVGMEAN(n, x1, x2, x3, ...)       or\n\
        AVGMEAN(<filename>)                 \n\
\n\
Returns the mean average of a series of numbers. Input can either be a \n\
series of numbers with the first argument specifying the number of elements\n\
in the series or a single argument specifying the name of the plain text file\n\
containing the series of numbers with each element in the file seperated by\n\
spaces or starting at a new line.\n\n"

#define HELPMSG_FNC_AVGMEDIAN "\
AVGMED: Median average of a series of numbers\n\
\n\
syntax: AVGMED(n, x1, x2, x3, ...)        or\n\
        AVGMED(<filename>)                  \n\
\n\
Returns the median average of a series of numbers. Input consists of a series\n\
of numbers with the first argument specifying the number of elements in the\n\
series or a single argument specifying the name of the plain text file\n\
containing the series of numbers with each element in the file seperated by\n\
spaces or starting at a new line.\n\n"

#define HELPMSG_FNC_AVGMODE "\
AVGMODE: Mode average of a series of numbers\n\
\n\
syntax: AVGMODE(n, x1, x2, x3, ...)       or\n\
        AVGMODE(<filename>)                 \n\
\n\
Returns the mode (frequency) average of a series of numbers. Input consists of\n\
a series of numbers with the first argument specifying the number of elements\n\
in the series or a single argument specifying the name of the plain text file\n\
containing the series of numbers with each element in the file seperated by\n\
spaces or starting at a new line. Note: no attempt is made to return more than\n\
one element even though more than one element in the series can have the same\n\
highest occurence frequency.\n\n"

#define HELPMSG_FNC_STDDEV "\
STDDEV: Standard deviation of a series of numbers\n\
\n\
syntax: STDDEV(n, x1, x2, x3, ...)       or\n\
        STDDEV(<filename>)                 \n\
\n\
Returns the standard deviation of a series of numbers. Input can either\n\
be a series of numbers with the first argument specifying the number of\n\
elements in the series or a single argument specifying the name of the plain\n\
text file containing the series of numbers with each element in the file\n\
seperated by spaces or starting at a new line.\n\n"

#define HELPMSG_FNC_SUM "\
SUM: Cumulative sum of a series of numbers\n\
\n\
syntax: SUM(n, x1, x2, x3, ...)       or\n\
        SUM(<filename>)                 \n\
\n\
Returns the cumulative sum of a series of numbers. Input can either be a\n\
series of numbers with the first argument specifying the number of elements\n\
in the series or a single argument specifying the name of the plain text file\n\
containing the series of numbers with each element in the file seperated\n\
by spaces or starting at a new line.\n\n"

#define HELPMSG_FNC_PRODUCT "\
PROD: Cumulative product of a series of numbers\n\
\n\
syntax: PROD(n, x1, x2, x3, ...)       or\n\
        PROD(<filename>)                 \n\
\n\
Returns the cumulative product of a series of numbers. Input can either be a\n\
series of numbers with the first argument specifying the number of elements\n\
in the series or a single argument specifying the name of the plain text file\n\
containing the series of numbers with each element in the file seperated by\n\
spaces or starting at a new line.\n\n"

#define HELPMSG_FNC_GRAPH "\
GRAPH: Displays a two dimensional cartesian graph of an expression\n\
\n\
syntax: GRAPH(expr, varname)                 or\n\
        GRAPH(expr, varname, value)          or\n\
        GRAPH(expr, varname, value, radius)    \n\
\n\
Plot function input/output values for expression <expr> centered at a\n\
specified value <value> or 0 if not specified. If the graph centering value\n\
is specified then an optional radius value +/- from the center from which\n\
to start and end the plotting of the graph can also be specified.\n\
Input/output value pairs as a result of plotting the function is sent to an\n\
output file named: mcalc_graph<session#> where <session #> is substituted\n\
with the current session number for the calculator or 0 if not in asynchronous\n\
mode.\n\n"

#define HELPMSG_FNC_EVAL "\
EVAL: Evaluation of the contents of string variables\n\
\n\
syntax: EVAL(x)\n\
\n\
Where x can be any valid math expression or any combination of string variables\n\
For example: the variable $A can contain the string \"$B^2\" and the command\n\
EVAL($A) would give the result of the contents currently stored in the\n\
variable $B squared.\n\n"

#define HELPMSG_FNC_SHOW "\
SHOW: Show the contents of string variables including any variables\n\
      nested within them\n\
\n\
syntax: SHOW(x)\n\
\n\
Where x can be any valid math expression or any combination of string variables\n\
For example: the variable $A can contain the string \"deriv($B, x, -3)\" and\n\
the command SHOW($A) would show the contents of the variable $B within the\n\
expression. For example if $B currently contains \"-x^2 + 10\" then SHOW($A)\n\
would display \"deriv(-x^2 + 10, x, -3)\".\n\n"

#define HELPMSG_FNC_SHOWSET "\
SHOWSET: Show the contents of a string variable containing a set of\n\
         positive integers in standard set notation.\n\
\n\
syntax: SHOWSET(x)\n\
\n\
Where x refers to the letter variables $A...$Z. If the letter variable\n\
contains a set of positive integer then the contents of the set contained in\n\
that variable will be shown in standard set notation: { 1, 2, 3 ...}\n\
If the set is a null set then it will be displayed as: { null }, otherwise if\n\
the letter variable does not contain a set then a *** Not A Set *** message\n\
will be displayed notifying the user that the variable does not contain a set.\n\n"

#define HELPMSG_FNC_MODE "\
MODE: Command to set the calculator\'s angle unit\n\
\n\
syntax: MODE=degree     OR\n\
        MODE=radian\n\
\n\
The mode command sets the angle unit of the calculator to either degrees\n\
or radians. No calculations are done, variables are not affected.\n\n"

#define HELPMSG_FNC_PRECISION "\
PRECISION: Command to set the precision unit\n\
\n\
syntax: PRECISION=float                 OR\n\
        PRECISION=float,keepvars        OR\n\
        PRECISION=double                OR\n\
        PRECISION=double,keepvars       OR\n\
        PRECISION=longdouble            OR\n\
        PRECISION=longdouble,keepvars   OR\n\
        PRECISION=longnum               OR\n\
        PRECISION=longnum,keepvars\n\
\n\
The precision command sets the precision unit. Each precision unit: float,\n\
double, long double, long number is actually an individual calculator and each\n\
calculator has its own set of 26 letter variables for DECIMAL value storage,\n\
excluding string variables which are shared globally. By default all variables\n\
of a calculator are transferred over to the new calculator after a precision\n\
unit change. Alternatively you can choose not to do this and have each\n\
calculator preserve its own set of decimal variables by specifying \",keepvars\"\n\
after the precision unit name in the precision command.\n\
example: precision=longnum,keepvars\n\
which will skip tranferring variables from the previous calculator to the long\n\
number calculator.\n\
\n\
* Warning: when you use base conversion commands:\n\
\tToHex, ToOct, ToBin, ToCmp2Bin,FromHex, FromOct, FromBin, FromCmp2Bin\n\
\n\
any assignment to variables: $A...$Z will assign to the long number calculator\n\
variables as well as the variables in the currently used calculator\n\n"

#define HELPMSG_FNC_GETPRECISION "\
GETPRECISION: Command to show the precision unit details\n\
\n\
syntax: GETPRECISION\n\
\n\
The get precision command will display the details for the currently used\n\
precision unit. Depending on the currently used precision unit the following\n\
will be displayed:\n\
\n\
\tFloat (7-digit precision)\n\
\tDouble (15-digit precision)\n\
\tLong Double (19-digit precision)\n\
\tLong Number (arbitrary precision)\n\n"

#define HELPMSG_FNC_DUMPVARS "\
DUMPVARS: Command to display the contents of all variables:\n\
          $A-$Z, ans, ansstr, fracans\n\
\n\
syntax: DUMPVARS\n\
\n\
The contents of all variables: memory variables $A through $Z and results\n\
variables ans, ansstr and fracans is displayed. Variables that are currently\n\
empty will be displayed with nothing beside it.\n\n"

#define HELPMSG_FNC_GRAPHALLPTS "\
GRAPHALLPTS: Command to set the calculator to plot all function points or not.\n\
\n\
syntax: GRAPHALLPTS\n\
\n\
If graphallpts is set to true then the calculator will graph all points even\n\
for those points approaching -inf and +inf in plot mode. If set to false the\n\
calculator will show small red points as -inf or +inf for points approaching\n\
infinity when in plot mode. for example tan(pi/2) or approximate values\n\
(+/- .002) will result in +inf and n/0 with any value n divided by zero or\n\
(+/- .002) will result in +inf/-inf. Small red terminating points indicating\n\
discontinuity at negative or positive infinite values.\n\n"

#define HELPMSG_FNC_GRAPHPREC "\
GRAPHPREC: Command to set the default graphing interval precision for\n\
graphing functions which defaults to .0001 if not explicitly set.\n\
\n\
syntax: GRAPHPREC=.fv,  where .fv is a floating point value less than .02\n\
\n\
Command to adjust the graphing interval precision value in cases where the\n\
user wants to decrease the interval precsion to a lower value to speed up the\n\
graphing function by increasing the precision between graph intervals as a\n\
trade off or in cases where the user wants to increase the interval precsion\n\
to a higher value to get a more detailed graph of an equation by performing\n\
more and longer graphing calculations. This value cannot be adjusted greater\n\
than or equal to .02 otherwise it is ignored.\n\
NOTE: algorithm for finding the graphing interval may adjust to a larger and\n\
less precise interval value if overflow conditions are encountered.\n\n"

#define HELPMSG_FNC_SETRECUR "\
SETRECUR: Command to set the recursion limit for the evaluation of nested\n\
variables within string variables.\n\
\n\
syntax: SETRECUR=x,  where x is a positive number for the recursion limit\n\
\n\
To avoid infinite recursion which will stall the program, evaluation of\n\
variables names within string variables will by default be evaluated up to 26\n\
levels deep. This means that you can nest variable names such as $B within\n\
another variable like $A and continue on with another variable name nested\n\
within $B and so on, up to 26 levels deep of nesting. The program will simply\n\
refuse to process expressions that nest variables more than the set recursion\n\
limit and display an error message. To increase or decrease the recursion\n\
limit, use the command \"Set Recur=\" with the desired limit placed after the\n\
equal sign.\n\n"

#define HELPMSG_FNC_EXEC "\
EXEC: Executes a pre-written calculator program saved in a file.\n\
      All calculator program files must have the extension \".prg\"\n\
      The name of the program passed to the EXEC command is simply the file\n\
      name excluding the extension, so if you want to execute the program in\n\
      the file \"sample.prg\" for example, you enter \"EXEC sample\" into the\n\
      calculator\n\
\n\
syntax: EXEC name              OR\n\
        EXEC name.in           OR\n\
        EXEC name.in,pause     OR\n\
        EXEC name.in,nopause   OR\n\
\n\
Each command of the calculator program must be preceded by a colon \":\" before\n\
anything else is entered. Note, unlike calculator input files, line termination\n\
with a semi-colon \";\" is not necessary for program files.\n\
\n\
Optionally, a short one line description of the input or program file can be\n\
written at the beginning of the input or program file to provide a short\n\
description line in the table of available calculator programs shown in the\n\
GUI version of the calculator. The description line must start with\n\
\"# description=\" before the actual description phrase in order for the\n\
program to recognize it as a description line.\n\
\n\
If the executed file is an input data file rather than a calculator program\n\
file then the entire file name including the \".in\" extension must be\n\
specified.\n\
\n\
Qmcalc will reserve the following characters to use in calculator script files\n\
for special purposes: : ; # = & \n\
So in comment lines that are indicated with the \"#\" character at the start\n\
of the line, some specific characters must be replaced with their associated\n\
escape sequences for Qmcalc to recognize and process them correctly:\n\
\n\
To display these characters while reading from a calculator script file \".prg\"\n\
or input data file \".in\", the following escape sequences must be used instead:\n\
\n\
  &amp; or &#38;   for the ampersand character: &\n\
  &sc; or &#59;    for the semicolon character: ;\n\
  &hash; or &#35;  for the number sign or hash character: #\n\
  &col; or &#58;   for the colon character: :\n\
  &eq; or &#61;    for the equal character: =\n\
\n\
When executing input data files you have the option of either pausing the\n\
calculator after each line completed or executing all lines without pause or\n\
interruption through to the end of the file. The default setting is to pause\n\
after each line completed. To specify no pause in execution until the\n\
completion of the input data file, you need to specify the \"nopause\" option\n\
after entering a comma after the file name\n\
\n\
Valid commands recognized by the calculator includes any normally entered\n\
functions, operators, values and variables as well as the following additional\n\
program control and program input/output instructions:\n\n"

#define HELPMSG_PROGRAM_COMMAND_LIST1 "\
Program Control Instructions:\n\
\tIF : conditional execution of a single command.\n\
\tIF-THEN : Conditional execution of program segment.\n\
\tIF-THEN-ELSE : Conditional execution of a two-branch program segment.\n\
\tFOR : Repeated execution at a specified number of iterations of a program\n\
\t      segment.\n\
\tWHILE : Repeated execution of a program segment while a specified condition\n\
\t        is true. Testing of condition is done prior to the execution of the\n\
\t        program segment.\n\
\tREPEAT : Repeated execution of a program segment until a specified condition\n\
\t         becomes true. Testing of condition is done after the execution of\n\
\t         the program segment.\n\
\tEND : Identifies the end of a group of commands.\n\
\tPAUSE : Suspends execution of the program so you can see answers or program\n\
\t        output.\n\
\tLBL : Label used by goto command.\n\
\tGOTO : Go to a specified location in the program indicated by a LBL label tag.\n\
\tIS> : Increment and skip command. See command specific help for more details.\n\
\tDS< : Decrement and skip command. See command specific help for more details.\n\
\tMENU : Displays menu with choices shown as multiple branches to different\n\
\t       locations\n\
\t       within the program.\n\
\tPRGM : The PRGM command is used to execute other programs from the currently\n\
\t       running\n\
\t       program as subroutines. Syntax and accepted input is same as the EXEC\n\
\t       command.\n\
\tRETURN : Quits the subroutine and returns to the calling program.\n\
\tSTOP : Stops execution of currently running program including from within any\n\
\t       subroutines and returns to calculator display.\n\
\t       The message \"<program ended>\" will also be displayed when the\n\
\t       calculator is in interactive text or GUI mode. This message can be\n\
\t       customized by supplying the STOP command with an argument string.\n\n"

#define HELPMSG_PROGRAM_COMMAND_LIST2 "\
Program Input/Output Instructions:\n\
\tPROMPT : Displays each variable one at a time and prompts user to enter data\n\
\t         for each one with a \"=?\" prompt.\n\
\tINPUT : Prompts user to input into a variable with a \"?\" prompt without any\n\
\t        preceeding text or displays some preceeding text followed by the \"?\"\n\
\t        prompt.\n\
\tDISP : Displays one or more strings or variables. Expression arguments are\n\
\t       evaluated and the results displayed.\n\
\tDISP_PARTS : Displays one or more strings or variables in parts. Expression\n\
\t             arguments are evaluated and the results displayed. The output\n\
\t             file is not closed and the GUI client program of the calculator\n\
\t             is not notified of the newly entered contents until the\n\
\t             END_DISPLAY program command is executed. This is useful when\n\
\t             displaying large amounts of text data all at once rather than\n\
\t             one piece at a time.\n\
\tEND_DISP : End displaying of text content parts by closing output file and\n\
\t           notifying GUI client program of the new contents contained in the\n\
\t           output file.\n\
\tGRAPH : Displays a two dimensional cartesian graph of an expression or the\n\
\t        results of a function performed on an expression\n\
\t        (not available in text mode).\n\
\n\
Enter: help <name of program instruction>, for more detailed help on each\n\
individual program instruction.\n\n"

#define HELPMSG_PRGFNC_IF "\
IF: Conditional execution of a single command.\n\
\n\
syntax:\n\
\t:IF condition\n\
\t:command if true\n\
\t:command\n\
\n\
IF is used for testing and branching. If condition is false (zero), then the\n\
command immediately following it is skipped. If condition is true (nonzero),\n\
that command is executed. If instructions can be nested.\n\n"

#define HELPMSG_PRGFNC_IF_THEN "\
IF-THEN: Conditional execution of program segment.\n\
\n\
syntax:\n\
\t:IF condition\n\
\t:THEN\n\
\t:command if true\n\
\t:command if true\n\
\t:END\n\
\t:command\n\
\n\
IF-THEN is used for testing and branching. IF-THEN executes a group of commands\n\
if condition is true (nonzero). If condition is false (zero), then the group of\n\
commands is skipped. END identifies the end of the group.\n\n"

#define HELPMSG_PRGFNC_IF_THEN_ELSE "\
IF-THEN-ELSE: Conditional execution of a two-branch program segment.\n\
\n\
syntax:\n\
\t:IF condition\n\
\t:THEN\n\
\t:command if true\n\
\t:command if true\n\
\t:ELSE\n\
\t:command if false\n\
\t:command if false\n\
\t:END\n\
\t:command\n\
\n\
IF-THEN-ELSE is used for testing and branching for a two-branch program\n\
segment. If condition is true (nonzero), then the group of commands in between\n\
THEN and ELSE is executed. If condition is false (zero), then the group of\n\
commands in between THEN and ELSE is skipped and the group of commands in\n\
between ELSE and END is executed. END identifies the end of the two-branch\n\
program segment.\n\n"

#define HELPMSG_PRGFNC_FOR "\
FOR: Repeated execution at a specified number of iterations of a program\n\
     segment.\n\
\n\
syntax:\n\
\t:FOR (variable,begin,end,increment)\n\
\t:command while end not exceeded\n\
\t:command while end not exceeded\n\
\t:END\n\
\t:command\n\
\n\
FOR is used for looping and incrementing. It increments <variable> from <begin>\n\
to <end>, by <increment>. <increment> is optional (if not specified, 1 is used)\n\
and can be negative (end < begin). <end> is a maximum or minimum value not to\n\
be exceeded. END identifies the end of the loop. FOR loops can be nested\n\n"

#define HELPMSG_PRGFNC_WHILE "\
WHILE: Repeated execution of a program segment while a specified condition is\n\
       true. Testing of condition is done prior to the execution of the program\n\
       segment.\n\
\n\
syntax:\n\
\t:WHILE condition\n\
\t:command while condition is true\n\
\t:command while condition is true\n\
\t:END\n\
\t:command\n\
\n\
WHILE performs a group of commands while condition is true. condition is tested\n\
when WHILE is encountered. If condition is true (nonzero), the program executes\n\
a group of commands. END signifies the end of the group. If condition is false\n\
(zero), the program executes the commands following END. WHILE instructions can\n\
be nested.\n\n"

#define HELPMSG_PRGFNC_REPEAT "\
REPEAT : Repeated execution of a program segment until a specified condition\n\
         becomes true. Testing of condition is done after the execution of the\n\
         program segment.\n\
\n\
syntax:\n\
\t:REPEAT condition\n\
\t:command until condition is true\n\
\t:command until condition is true\n\
\t:END\n\
\t:command\n\
\n\
REPEAT repeats a group of commands until condition is true (nonzero). It is\n\
similar to WHILE, but condition is tested when END is encountered; therefore,\n\
the group of commands will always be executed at least once. REPEAT\n\
instructions can be nested\n\n"

#define HELPMSG_PRGFNC_END "\
END : Identifies the end of a group of commands.\n\
\n\
syntax: END\n\
\n\
END identifies the end of a group of commands. Each FOR, WHILE, REPEAT,\n\
IF-THEN, or IF-THEN-ELSE instruction must have an END at the \"bottom\" of the\n\
group of commands\n\n"

#define HELPMSG_PRGFNC_PAUSE "\
PAUSE : Suspends execution of the program so you can see answers or program\n\
        output.\n\
\n\
syntax: PAUSE or\n\
        PAUSE <value>\n\
\n\
PAUSE suspends execution of the program so you can see answers. PAUSE with no\n\
value temporarily pauses the program while \"<paused>\" is displayed. PAUSE\n\
<value> displays the value indicated by <value> during the pause. The <value>\n\
argument is optional\n\n"

#define HELPMSG_PRGFNC_LBL "\
LBL : Label used by goto command.\n\
\n\
syntax: LBL <label>\n\
\n\
LBL (label) and GOTO (go to) are used together for branching. LBL specifies the\n\
<label> of a location within the program that is used by GOTO or MENU\n\
instructions to jumped to that particular program location.\n\n"

#define HELPMSG_PRGFNC_GOTO "\
GOTO : Go to a specified location in the program indicated by a LBL label tag.\n\
\n\
syntax: GOTO <label>\n\
\n\
GOTO causes the program to jump to the program location specified by <label>\n\
when the GOTO instruction is encountered.\n\n"

#define HELPMSG_PRGFNC_INCSKIP "\
IS> : Increment and skip command. See command specific help for more details.\n\
\n\
syntax: IS> (variable, value)\n\
\n\
IS> adds 1 to variable, if the answer is greater than value\n\
(which can be an expression), the next command is skipped.\n\n"

#define HELPMSG_PRGFNC_DECSKIP "\
DS< : Decrement and skip command. See command specific help for more details.\n\
\n\
syntax: DS< (variable, value)\n\
\n\
DS< subtracts 1 from variable, if the answer is less than value\n\
(which can be an expression), the next command is skipped.\n\n"

#define HELPMSG_PRGFNC_MENU "\
MENU : Displays menu with choices shown as multiple branches to different\n\
       locations within the program.\n\
\n\
syntax: MENU(\"<title>\", \"<text1>\", <label1>, \"<text2>\", <label2>, ...)\n\
\n\
MENU sets up branching within a program. If MENU is encountered during\n\
execution, the menu screen is displayed with the specified menu items, and\n\
execution pauses until a menu selection is made. The menu <title> is enclosed\n\
in quotes \" as well as the text description for each <label>.\n\n"

#define HELPMSG_PRGFNC_PRGM "\
PRGM : The PRGM command is used to execute other programs from the currently\n\
       running program as subroutines. Syntax and accepted input is same as the\n\
       EXEC command.\n\
\n\
syntax: PRGM <program name>\n\
\n\
PRGM is used to execute other calculator programs as subroutines.\n\
All calculator program files must have the extension \".prg\"\n\
The name of the program passed to the PRGM command is simply the file name\n\
excluding the extension, so if you want to execute the program in the file\n\
\"sample.prg\" as a subroutine in your main program for example, you enter\n\
\"PRGM sample\" as the instruction in your main program file.\n\n"

#define HELPMSG_PRGFNC_RETURN "\
RETURN : Quits the subroutine and returns to the calling program.\n\
\n\
syntax: RETURN\n\
\n\
RETURN quits the subroutine and returns to the calling program, even if\n\
encountered within nested loops. There is an implied RETURN at the end of any\n\
program called as a subroutine. A RETURN instruction encountered in the main\n\
program will stop the execution of the program and return to the calculator\n\
display\n\n"

#define HELPMSG_PRGFNC_STOP "\
STOP : Stops execution of currently running program including from within any\n\
       subroutines and returns to calculator display.\n\
       Show program termination message when in interactive text or GUI mode.\n\
\n\
syntax: STOP               OR\n\
        STOP \"<string>\"\n\
\n\
STOP stops execution of a program and returns you to the main calculator\n\
display. The message \"<program ended>\" will also be displayed when the\n\
calculator is in interactive text or GUI mode. This message can be\n\
customized by supplying the STOP command with an argument string.\n\n"

#define HELPMSG_PRGFNC_PROMPT "\
PROMPT : Displays each variable one at a time and prompts user to enter data\n\
         for each one with a \"=?\" prompt.\n\
\n\
syntax: PROMPT <variable1>, <variable2>, ...\n\
\n\
During execution PROMPT displays each variable, one at a time, followed by\n\
a \"=?\". Enter a value and then press or click [Enter] for each variable.\n\
The values are stored, and the program resumes execution.\n\n"

#define HELPMSG_PRGFNC_INPUT "\
INPUT : Prompts user to input into a variable with a \"?\" prompt without any\n\
        preceeding text or displays some preceeding text followed by\n\
        the \"?\" prompt.\n\
\n\
syntax: INPUT <variable> or\n\
        INPUT \"<string>\",<variable>\n\
\n\
INPUT with <variable> prompts \"?\" during execution. Enter a value\n\
(which can be an expression) and press or click [enter]. The value is evaluated\n\
and stored to <variable>, and the program resumes execution. You can display a\n\
preceeding string as a prompt in which case the preceeding string is displayed\n\
before the \"?\" prompt. Enter a value and press [Enter]. The value is stored\n\
to <variable>, and the program resumes execution.\n\n"

#define HELPMSG_PRGFNC_DISP "\
DISP : Displays one or more strings or variables. Expression arguments are\n\
       evaluated and the results displayed.\n\
\n\
syntax: disp <value>, <value>...\n\
        with valid values being one of: \"<string>\" OR <variable> OR\n\
        <expression>\n\
\n\
If <value> is an expression, it is evaluated and then displayed. If <value> is\n\
text enclosed within quotes, it is displayed as it is entered. For example,\n\n\
\tDISP \"THE ANSWER IS: \",5/2\n\n\
\tdisplays: THE ANSWER IS: 2.5\n\n"

#define HELPMSG_PRGFNC_DISP_PARTS "\
DISP_PARTS : Displays one or more strings or variables in parts. Expression\n\
             arguments are evaluated and the results displayed.\n\
             Displaying contents in parts, so output file not closed at the\n\
             completion of the command and GUI client program is not notified\n\
             of newly entered data\n\
\n\
syntax: disp_parts <value>, <value>...\n\
        with valid values being one of: \"<string>\" OR <variable> OR\n\
        <expression>\n\
\n\
If <value> is an expression, it is evaluated and then displayed. If <value> is\n\
text enclosed within quotes, it is displayed as it is entered. For example,\n\n\
\tDISP_PARTS \"THE ANSWER IS: \",5/2\n\n\
\tdisplays: THE ANSWER IS: 2.5\n\
\n\
The output file is not closed and the GUI client program of the calculator is\n\
not notified of the newly entered contents until the END_DISPLAY program\n\
command is executed. This is useful when displaying large amounts of text data\n\
all at once rather than one piece at a time.\n\n"

#define HELPMSG_PRGFNC_END_DISP "\
END_DISP : End displaying of text content parts by closing output file and\n\
           notifying GUI client program of the new contents contained in the\n\
           output file.\n\
\n\
syntax: end_disp\n\
\n\
End displaying of text content parts by closing output file and notifying GUI\n\
client program of the new contents contained in the output file. This command\n\
follows at the end of a series of DISP_PARTS commands for displaying large\n\
amounts of text data to the output file in parts before notifying the GUI\n\
calculator client to display the contents of the output file all at once after\n\
the END_DISP command is executed.\n\n"

#define HELPMSG_PRGFNC_GRAPH "\
GRAPH : Displays a two dimensional cartesian graph of an expression or the\n\
results of a function performed on an expression (not available in text mode).\n\
\n\
syntax:\n\
\t:graph(expr, varname)   or\n\
\t:graph fmin(...)        or\n\
\t:graph fmax(...)        or\n\
\t:graph deriv(...)       or\n\
\t:graph integ(...)       or\n\
\t:graph solve(...)       or\n\
\t:graph intersect(...)\n\
\n\
GRAPH(expr, varname) will graph the expression with standard x,y axis limits\n\
and zoom settings\n\
GRAPH fmin(...) and GRAPH fmax(...) will graph the expression as well as mark\n\
on the graph, locations of the minimum and maximum values of the expression.\n\
GRAPH deriv(...) will graph the expression as well as graph the tangent line to\n\
the point on the graph of the expression where the derivative is to be found\n\
GRAPH integ(...) will graph the expression as well as the area under the graph\n\
which represents the integral of the expression\n\
GRAPH solve(...) will graph the expression as well as mark on the graph, roots\n\
of the expression (points on the graph where it crosses the x axis).\n\
GRAPH intersect(...) will graph the expression(s) as well as mark on the graph,\n\
points of intersection between the expression(s) or the x = 0 line (x axis).\n\n"

#endif
