#ifndef CALCLIB_CPP
#define CALCLIB_CPP
#ifndef CALCLIB_H
  #include "calclib.h"
#endif

// function names
char** CalculatorBase::FUNCTION_NAMES = NULL;
int CalculatorBase::_NumFncNames = 0;
int CalculatorBase::_ShortestFncName = -1;

// Class instances counter
int CalculatorBase::_Instances = 0;

/* Program Constants */
const int CalculatorBase::MAXVALUES = MAXOPERANDS+2;      /* Maximum number of integer values including the result of the calculation */
const int CalculatorBase::RESULTINDEX = MAXOPERANDS;      /* index position in the operands array which contains the structure for storing the result of the calculation */

/* Program Options */
const int CalculatorBase::SHOWPOS = 0;       /* flag to show positive sign if value is positive */

/* Operator symbols */
const Uchar CalculatorBase::POW_OP         = '^';
const Uchar CalculatorBase::SIGN_OP        = 174;
const Uchar CalculatorBase::SIN_OP         = 175;
const Uchar CalculatorBase::COS_OP         = 176;
const Uchar CalculatorBase::TAN_OP         = 177;
const Uchar CalculatorBase::ASIN_OP        = 178;
const Uchar CalculatorBase::ACOS_OP        = 179;
const Uchar CalculatorBase::ATAN_OP        = 180;
const Uchar CalculatorBase::SINH_OP        = 181;
const Uchar CalculatorBase::COSH_OP        = 182;
const Uchar CalculatorBase::TANH_OP        = 183;
const Uchar CalculatorBase::EXP_OP         = 184;
const Uchar CalculatorBase::LOG_OP         = 185;
const Uchar CalculatorBase::LOG10_OP       = 186;
const Uchar CalculatorBase::CEILING_OP     = 187;
const Uchar CalculatorBase::FLOOR_OP       = 188;
const Uchar CalculatorBase::ABS_OP         = 189;
const Uchar CalculatorBase::FRACPART_OP    = 190;
const Uchar CalculatorBase::INTPART_OP     = 191;
const Uchar CalculatorBase::SQR_OP         = 192;
const Uchar CalculatorBase::SQRT_OP        = 193;
const Uchar CalculatorBase::CUBE_OP        = 194;
const Uchar CalculatorBase::CUBERT_OP      = 195;
const Uchar CalculatorBase::MINUS_OP       = 196;
const Uchar CalculatorBase::AND_OP         = 197;
const Uchar CalculatorBase::RND_OP         = 198;
const Uchar CalculatorBase::NOT_OP         = 199;
const Uchar CalculatorBase::COMB_OP        = 200;
const Uchar CalculatorBase::PERM_OP        = 201;
const Uchar CalculatorBase::COMBREP_OP     = 202;
const Uchar CalculatorBase::LSTHANOREQ_OP  = 205;
const Uchar CalculatorBase::GRTHANOREQ_OP  = 206;
const Uchar CalculatorBase::EQUAL_OP       = 207;
const Uchar CalculatorBase::NOTEQUAL_OP    = 208;
const Uchar CalculatorBase::RAND_OP        = 209;
const Uchar CalculatorBase::XOR_OP         = 210;
const Uchar CalculatorBase::INV_OP         = 211;
const Uchar CalculatorBase::SCI_OP         = 212;
const Uchar CalculatorBase::OR_OP          = 213;
const Uchar CalculatorBase::FACTORIAL_OP   = 214;
const Uchar CalculatorBase::PERMREP_OP     = 215;

/* Predefined constant symbols */
const Uchar CalculatorBase::PI_CONST       = 220;
const Uchar CalculatorBase::E_CONST        = 221;
const Uchar CalculatorBase::ANS_CONST      = 222;
const Uchar CalculatorBase::ANSSTR_CONST   = 223;
const Uchar CalculatorBase::FRACANS_CONST  = 224;
const Uchar CalculatorBase::NAN_CONST      = 225;
const Uchar CalculatorBase::INF_CONST      = 226;

// Indexes for variables, numbers, prefixes and function calls
const Uchar CalculatorBase::VARIABLE_INDEX  = 230;
const Uchar CalculatorBase::NUMBER_INDEX    = 231;
const Uchar CalculatorBase::HEXPREFIX_INDEX = 232;
const Uchar CalculatorBase::FUNCTION_INDEX  = 233;
const Uchar CalculatorBase::BINARYOPS_INDEX = 234;
const Uchar CalculatorBase::UNARYOPS_INDEX  = 235;
const Uchar CalculatorBase::POSTOPS_INDEX   = 236;

// File pointers
FILE** CalculatorBase::files = NULL;
FILE* CalculatorBase::infile = NULL;
FILE* CalculatorBase::outfile = NULL;
FILE* CalculatorBase::logfile = NULL;
FILE* CalculatorBase::spawnargfile = NULL;
FILE* CalculatorBase::currenterrorfile = NULL;
FILE* CalculatorBase::userinputfile = NULL;
FILE* CalculatorBase::userpromptfile = NULL;
FILE* CalculatorBase::programoutputfile = NULL;
FILE* CalculatorBase::commandhistoryfile = NULL;
FILE* CalculatorBase::iostatefile = NULL;
FILE* CalculatorBase::curgraphfile = NULL;
FILE* CalculatorBase::progressfile = NULL;
FILE* CalculatorBase::elapsedtimefile = NULL;
FILE* CalculatorBase::graphprogressfile = NULL;
FILE* CalculatorBase::graphoperationfile = NULL;
FILE* CalculatorBase::pollstatefile = NULL;
FILE* CalculatorBase::clientalivefile = NULL;
FILE* CalculatorBase::serveralivefile = NULL;

int CalculatorBase::pollstatemode = 0;
int CalculatorBase::clientalivemode = 0;
int CalculatorBase::serveralivemode = 0;

// Elapsed time timer static data members
CalcElapsedTimer* CalculatorBase::_ElapsedTimer = NULL;

// Calculator program termination
int CalculatorBase::_ShouldQuit = 0;
int CalculatorBase::_ExitOnFileOpenFail = 0;

// Global execution count for input data files
int CalculatorBase::_ExecInputFileDataCnt = 0;

// number of executable lines (excluding comments) found in input data file
int CalculatorBase::_InputFileLineSize = 0;

// Graph plotting
int CalculatorBase::_GraphingOp = 0;
int CalculatorBase::_GraphType = 0;
int CalculatorBase::_GraphSubtype = 0;
int* CalculatorBase::_GraphTypeList = NULL;
int CalculatorBase::_GraphTypeListSize = 0;
int CalculatorBase::_GraphTypeListIndex = 0;
CalcGraphPlotter* CalculatorBase::_Plotter = NULL;

// Global calculator IO state handler
CalcIoStateHandler* CalculatorBase::_IoStatePtr = NULL;

// global expression string stack
bool CalculatorBase::_OwnsStrStack = false;
ExprStringStack* CalculatorBase::_StringStack = NULL;

// File operation flags
int CalculatorBase::_StreamSet = 0;
int CalculatorBase::_ArgListSize = 0;

// Asynchronous mode flags
int CalculatorBase::filestatus[];
int CalculatorBase::_UseSessionCnt = 0;
int CalculatorBase::_SessionNum = 0;
int CalculatorBase::_SessionOption = 0;
int CalculatorBase::_SessionOptionOverride = 0;
int CalculatorBase::_InputExists = 0;
int CalculatorBase::_OutputExists = 0;
int CalculatorBase::_UserInputMode = 0;
int CalculatorBase::_McalcSpawned = 0;
int CalculatorBase::_ExecMcalcOk = 0;
int CalculatorBase::_AsyncMode = 0;
int CalculatorBase::_PrevSetState = Mcalc_IOState::IDLE_STATE;
int CalculatorBase::_IoState = Mcalc_IOState::IDLE_STATE;
int CalculatorBase::_IoStateToSend = Mcalc_IOState::IDLE_STATE;
int CalculatorBase::_IoStateForced = 0;
int CalculatorBase::_TimeoutState = Mcalc_ElapsedTime::RESET;
int CalculatorBase::_WaitForResponse = 0;
int CalculatorBase::_WaitForeverForSignal = 0;
int CalculatorBase::_ResendLastSignal = 0;
int CalculatorBase::_StdInput = 0;
int CalculatorBase::_StdOutput = 0;
int CalculatorBase::_StartAsStdInput = 0;
int CalculatorBase::_StartAsStdOutput = 0;

// Batch file ended signal sent from loaded program
int CalculatorBase::_BatchFileEndedSignalConfirmed = 0;

// Zero length (empty) argument string read from user input
int CalculatorBase::_ZeroLenArgStr = 0;

// Variable index method
int CalculatorBase::_VarIndexFound = 0;

// Error message has been recorded into the calculator's log file
int CalculatorBase::_LoggedError = 0;

// Valid op codes confirmed to be found in opcode queue
int CalculatorBase::_ConfirmedValidOps = 0;

// Recursion limit flag
int CalculatorBase::_RecursionLimitReached = 0;

// Batch input or program file execution level
int CalculatorBase::_BatchExecLevel = 0;
int CalculatorBase::_WriteToFileBatchLevel = 0;
int CalculatorBase::_InSpawnedCalc = 0;

ClientPollingMgr* CalculatorBase::_PollClientMgr = NULL;
bool CalculatorBase::_ClientProgramAlive = true;

#if CALCLIB_TESTMOCKCLIENT
  ServerPollingMgr* CalculatorBase::_PollServerMgr = NULL;
  bool CalculatorBase::_ServerProgramAlive = true;
#endif

// Convergence test upper limit
double CalculatorBase::UPPER_LIMIT = 1.0e+20;

// File names and suffix
char* CalculatorBase::LOG_FILE = NULL;
char* CalculatorBase::SPAWNARG_FILE = NULL;
char* CalculatorBase::CURRENTERROR_FILE = NULL;
char* CalculatorBase::USER_INPUT_FILE = NULL;
char* CalculatorBase::USER_PROMPT_FILE = NULL;
char* CalculatorBase::PROG_OUTPUT_FILE = NULL;
char* CalculatorBase::DATA_INPUT_FILE = NULL;
char* CalculatorBase::DATA_OUTPUT_FILE = NULL;
char* CalculatorBase::PROG_IOSTATE_FILE = NULL;
char* CalculatorBase::CURRENTGRAPH_FILE = NULL;
char* CalculatorBase::GRAPH_OPERATION_FILE = NULL;
char* CalculatorBase::GRAPH_PROGRESS_FILE = NULL;
char* CalculatorBase::CMDHISTORY_FILE = NULL;
char* CalculatorBase::SERVERALIVE_FILE = NULL;
char* CalculatorBase::CLIENTALIVE_FILE = NULL;
char* CalculatorBase::PROGRESS_FILE = NULL;
char* CalculatorBase::ELAPSEDTIME_FILE = NULL;
char* CalculatorBase::POLLSTATE_FILE = NULL;
char* CalculatorBase::FILE_SESNUM_SUFFIX = NULL;

// Pointer to default input/output functions
int(*CalculatorBase::_OutFnc)(const char*) = NULL;
char*(*CalculatorBase::_InFnc)(char*, int) = NULL;

// Pointer to default memory allocation/deletion functions
void*(*CalculatorBase::_AllocFnc)(size_t, size_t) = NULL;
void*(*CalculatorBase::_DelFnc)(size_t, void*) = NULL;

// character array filters used for string utility functions
char* CalculatorBase::_PrintCharSet = NULL;
char* CalculatorBase::_FuncNamesCharSet = NULL;

// name of current graph plotting data output file
char* CalculatorBase::_CurrentGraphFname = NULL;

// Odd root special case
Uchar* CalculatorBase::_QLookAhead = NULL;
int CalculatorBase::_OddRoot = 0;

// Plotting data file letter suffix
char CalculatorBase::_PlotFileSuffix = 'a';

// Previous calculator type for math functions/operators checked for roundoff errors
int CalculatorBase::_PrevCalcType = 0;

// Use microsecond scale delay instead of millisecond scale
int CalculatorBase::_MicroSecDelay = 0;

// command line argument count and argument vector
int CalculatorBase::_CalcArgc = 0;
char** CalculatorBase::_CalcArgv = NULL;
Mcalc_CmdLineOptions* CalculatorBase::_CmdLineOptions = NULL;

// Graph plotting operation options
Mcalc_GraphOperationOptions* CalculatorBase::_GraphOpOptions = NULL;

// Error messages
char** CalculatorBase::_ErrorMessageArray = NULL;
int* CalculatorBase::_ErrorMessageArgCnt = NULL;
char* CalculatorBase::_CurrentFunctionName = NULL;
int CalculatorBase::_ErrorStatePending = 0;

// Calculator object memory valid/invalid
int* CalculatorBase::_CalculatorCreated = NULL;
int* CalculatorBase::_CalculatorDestroyed = NULL;

// Break from all running calculator programs and exit from program mode
int CalculatorBase::_BreakFromProgram = 0;
int CalculatorBase::_SetBreakResponse = 0;
int CalculatorBase::_PostBreakResponseSent = 0;

// Return value from execution of FunctionValidityChecker method: ChkIfMathLineValid
int CalculatorBase::_ErrorCheckReturnValue = 0;

// Calculator polling of client program is activated
int CalculatorBase::_CalcPollingInactive = 0;
int CalculatorBase::_SuspendPolling = 0;
int CalculatorBase::_ResumePolling = 0;

// Specified output data types and math expression line evaluation state
int CalculatorBase::_OutputDataCondition = 0;
int CalculatorBase::_OutputDataType = 0;
int CalculatorBase::_OutputDataError = 0;
int CalculatorBase::_OutputDataIndex = 0;
int CalculatorBase::_OutputDataIndexSet = 0;
int CalculatorBase::_NoOutputReturned = 0;

// Batch data input processing
int CalculatorBase::_BatchDataInput = 0;
int CalculatorBase::_WasInBatchDataInput = 0;
int CalculatorBase::_GraphOutputSent = 0;
int CalculatorBase::_GraphOutputWasSent = 0;
int CalculatorBase::_GraphOpStage = 0;

// Reset/Continue graph plotting operations
int CalculatorBase::_GraphFilePause = 0;
int CalculatorBase::_InAllGraphsFile = 0;

// Calculator/client signal response and acknowledgement state flags
int CalculatorBase::_ResponseWasCompleted = 0;
int CalculatorBase::_ClientAckedDoneToGraphOutput = 0;
int CalculatorBase::_CalcProgressWasSent = 0;
int CalculatorBase::_ClientAckedDoneToCalcProgress = 0;
int CalculatorBase::_OutputResetRequired = 0;
int CalculatorBase::_CalcResponseSent = 0;
int CalculatorBase::_InputPromptWarning = 0;
int CalculatorBase::_OutputTiedToSignal = 0;
int CalculatorBase::_AllowEmptyResponse = 0;

// Read user attempt loop guard for async. file input
// Loop guard limit to count down from for user input read attempts
Ushort CalculatorBase::_ReadUserAttemptLoopGuard = 0;
Ushort CalculatorBase::_ReadUserAttemptLoopGuardLimit = 0;

// Non-output calculator directive
char* CalculatorBase::_Directive = NULL;

// Answer string displayed to output files
ChrString* CalculatorBase::_AnsStrShown = NULL;

// Name of program to execute or NULL if none
ExecutingProgramName* CalculatorBase::_ExecuteProgram = NULL;

// Mock client console IO class (for testing GUI IO)
MockClientConIO* CalculatorBase::_Mockcio = NULL;

// CalculatorBase debugging data
#if CALCLIB_DEBUGGING
size_t CalculatorBase::_errline = 0;
size_t CalculatorBase::_errcol = 0;
int CalculatorBase::_errcode = 0;
Debugging<CalculatorBase>* CalculatorBase::_dbgptr = NULL;
#endif

// test asynchronous operation mode
// test quit graph plotting in pause mode
#if CALCLIB_TESTASYNCMODE1
  int CalculatorBase::_GraphWaitIterNum = 0;
#endif

// Calculator program universal ID value counter
long CalcProgram::_CalcProgramIDval = 0;

// Function Validity Checker static data members
int FunctionValidityChecker::_Instances = 0;
int FunctionValidityChecker::_Debugging = 0;
int FunctionValidityChecker::_FncPrecChk = 0;

// Graph command processed flag for SubExpression class
int SubExpression::_GraphCmdProcessed = 0;

// Exec command processed flag for SubExpression class
int SubExpression::_ExecCmdProcessed = 0;

char** FunctionValidityChecker::_ErrorMessageList = NULL;
char** FunctionValidityChecker::_SingleArgFncList = NULL;
char** FunctionValidityChecker::_DoubleArgFncList = NULL;
char** FunctionValidityChecker::_TripleArgFncList = NULL;
char** FunctionValidityChecker::_FourArgFncList = NULL;
char** FunctionValidityChecker::_FiveArgFncList = NULL;
char** FunctionValidityChecker::_SixArgFncList = NULL;
char** FunctionValidityChecker::_VaryArgFncList = NULL;
char** FunctionValidityChecker::_MultiArgFncList = NULL;
char** FunctionValidityChecker::_FracOpList = NULL;
char** FunctionValidityChecker::_UnaryOpList = NULL;
char** FunctionValidityChecker::_BinaryOpList = NULL;
char** FunctionValidityChecker::_ConstsAndVars = NULL;
char** FunctionValidityChecker::_ExcludedFncList = NULL;
char** FunctionValidityChecker::_AlmostFncList = NULL;
char** FunctionValidityChecker::_SpecialCaseList = NULL;
char** FunctionValidityChecker::_VarxFncList = NULL;
char** FunctionValidityChecker::_ChkFncPrecList = NULL;
int** FunctionValidityChecker::_MultiArgChkList = NULL;

char** FunctionValidityChecker::_NumberStrs = NULL;
int FunctionValidityChecker::_NumNumbers = 0;
int FunctionValidityChecker::_NumberListSize = 0;

int FunctionValidityChecker::_MaxWholeDigits = 0;
int FunctionValidityChecker::_MaxSigDigits = 0;
int FunctionValidityChecker::_MaxDecDigits = 0;
int FunctionValidityChecker::_LargestNumIndex = 0;
bool FunctionValidityChecker::_DecPtFound = 0;

// Discontinuity Detector base class static members
#if DISCONTDETECT_USE_CALCBASE_CLASS
   CalculatorBase* DiscontinuityDetectorBase::_BasePtr = NULL;
#else
  char* DiscontinuityDetectorBase::_BasePtr = NULL;
#endif // DISCONTDETECT_USE_CALCBASE_CLASS

int DiscontinuityDetectorBase::_UsingCalcType = 0;
ofstream* DiscontinuityDetectorBase::_Fout = NULL;
bool DiscontinuityDetectorBase::_HasFout = false;
char* DiscontinuityDetectorBase::_Filename = NULL;

#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
size_t DiscontinuityDetectorBase::_errline = 0;
size_t DiscontinuityDetectorBase::_errcol = 0;
int DiscontinuityDetectorBase::_errcode = 0;
Debugging<DiscontinuityDetectorBase>* DiscontinuityDetectorBase::_dbgptr = NULL;
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
Debugging<CalculatorBase>* DiscontinuityDetectorBase::_dbgptr = NULL;
#endif

/****************************************************************************/
// equality operators for SimpleList object compared with char* string
/****************************************************************************/
int operator == (SimpleList<int>& x, const char* s)
{
  int i = 0;
  int y = 0;
  const char* ptr = s;

  SimpleListIterator<int> Iter_(&x);
  if (s)
    for (ptr = s; *ptr && !isdigit(*ptr); ptr++);

  for (i = y = 0; y < x.Size(); ++i, ++y)
  {
    while (ptr[i] && (isspace(ptr[i]) || ptr[i] == ','))
      ++i;

    if (ptr[i] == '}')
      break;

    if (*Iter_.IndexNode(y)->_Object != atoi(ptr+i))
      return 0;
  }

  return (y == x.Size());
}

/****************************************************************************/
int operator == (const char* s, SimpleList<int>& x)
{
  int i = 0;
  int y = 0;
  const char* ptr = s;

  SimpleListIterator<int> Iter_(&x);
  if (s)
    for (ptr = s; *ptr && !isdigit(*ptr); ptr++);

  for (i = y = 0; y < x.Size(); ++i, ++y)
  {
    while (ptr[i] && (isspace(ptr[i]) || ptr[i] == ','))
      ++i;

    if (ptr[i] == '}')
      break;

    if (*Iter_.IndexNode(y)->_Object != atoi(ptr+i))
      return 0;
  }

  return (y == x.Size());
}

/****************************************************************************/
// default functions assigned to function pointers in CalculatorBase class
/****************************************************************************/
char* Mcalc_DefaultInFnc(char* Buffer_, int Size_)
{
  ChrString TempStr_;
  char* Retstr_ = NULL;
  int Index_ = 0;

  do
  {
    do Retstr_ = fgets(&Buffer_[Index_], Size_, stdin);
    while (Retstr_ && CalculatorBase::IsThisChar(Retstr_, 0, CALCCOMMENTLINE_STARTCHAR, 1));

    TempStr_ = Buffer_;
    TempStr_.RemovePadding(" \t\n\r");

    if (TempStr_.strlen() && TempStr_[TempStr_.strlen() - 1] == '\\')
    {
      TempStr_[TempStr_.strlen() - 1] = '\n';
      strcpy(Buffer_, TempStr_.c_str());
      Index_ = TempStr_.strlen();
    }
    else
    {
      Retstr_ = Buffer_;
      Index_ = 0;
    }
  }
  while (Index_ != 0);

  return Retstr_;
}

/****************************************************************************/
int Mcalc_DefaultOutFnc(const char* Buffer_)
{
  return fputs(Buffer_, stdout);
}

/****************************************************************************/
// Set element equality function
//   returns 0 if ival1 == ival2
//   returns !0 if ival1 != ival2
//
int Mcalc_DefaultSetElementEqualFnc(const int& ival1, const int& ival2)
{
  return (ival1 - ival2);
}

/****************************************************************************/
void* Mcalc_DefaultAllocFnc(size_t len, size_t sz)
{
  return MemMatrix::Matrix().Callocate(len * sz);
}

/****************************************************************************/
void* Mcalc_DefaultDelFnc(size_t len, void* ptr)
{
  if (MemMatrix::Matrix().Deallocate(ptr))
    return NULL;
  return ptr;
}

/****************************************************************************/
/****************************************************************************/
Mcalc_CmdLineOptions::Mcalc_CmdLineOptions():
inputexists(0),
outputexists(0),
sesnumexists(0),

ifindex(0),
ofindex(0),
snindex(0),

ifoffset(0),
ofoffset(0),
snoffset(0),

numfiles(0),
argcount(0),
cmdline(0),
sesnumber(0),

argvector(NULL)
{}

/****************************************************************************/
void Mcalc_CmdLineOptions::ShowData(Debugging<CalculatorBase>* DbgPtr_,
                                    bool ShowToStdout_)
{
  int x;
  char buf[64];
  bool prev_ = false;

  if (DbgPtr_)
  {
    if (ShowToStdout_)
    {
      prev_ = DbgPtr_->RepeatInStdout();
      DbgPtr_->SetRepeatInStdout(true);
    }

    DbgPtr_->ShowInt(inputexists, "CmdLineOptions::inputexists");
    DbgPtr_->ShowInt(outputexists, "CmdLineOptions::outputexists");
    DbgPtr_->ShowInt(sesnumexists, "CmdLineOptions::sesnumexists");

    DbgPtr_->ShowInt(ifindex, "CmdLineOptions::ifindex");
    DbgPtr_->ShowInt(ofindex, "CmdLineOptions::ofindex");
    DbgPtr_->ShowInt(snindex, "CmdLineOptions::snindex");

    DbgPtr_->ShowInt(ifoffset, "CmdLineOptions::ifoffset");
    DbgPtr_->ShowInt(ofoffset, "CmdLineOptions::ofoffset");
    DbgPtr_->ShowInt(snoffset, "CmdLineOptions::snoffset");

    DbgPtr_->ShowInt(numfiles, "CmdLineOptions::numfiles");
    DbgPtr_->ShowInt(argcount, "CmdLineOptions::argcount");
    DbgPtr_->ShowInt(cmdline, "CmdLineOptions::cmdline");

    DbgPtr_->ShowInt(sesnumber, "CmdLineOptions::sesnumber");

    if (argvector)
    {
      for (x = 0; x < argcount; x++)
        if (argvector[x])
        {
          sprintf(buf, "CmdLineOptions::argvector[%d]", x);
          DbgPtr_->ShowStr(argvector[x], buf);
        }
    }

    if (ShowToStdout_)
      DbgPtr_->SetRepeatInStdout(prev_);
  }
}

/****************************************************************************/
Mcalc_GraphOperationOptions::Mcalc_GraphOperationOptions():
_GraphOptionsSet(0),
_OperationType(0),
_GraphType(0),
_GraphSubtype(0),
_AllowBatchQuit(0)
{}

/****************************************************************************/
bool Mcalc_GraphOperationOptions::InBatchFile(bool QuitAllowed_) const
{
  return (_GraphOptionsSet &&
          _OperationType == Mcalc_GraphPlotOpType::BATCH_GRAPH_PLOT &&
          _GraphType != Mcalc_GraphPlotOpType::NO_GRAPH &&
          (!QuitAllowed_ || _AllowBatchQuit));
}

/****************************************************************************/
bool Mcalc_GraphOperationOptions::InGraphOperation(bool InBatch_) const
{
  return (InBatch_ ? InBatchFile(false):
                     (_GraphOptionsSet &&
                      _GraphType != Mcalc_GraphPlotOpType::NO_GRAPH &&
                      (_OperationType == Mcalc_GraphPlotOpType::FUNCTION_PLOT ||
                       _OperationType == Mcalc_GraphPlotOpType::APPLIED_FNCGRAPH)));
}

/****************************************************************************/
bool Mcalc_GraphOperationOptions::InAppliedFunctionGraph() const
{
  return (_GraphOptionsSet &&
          _OperationType == Mcalc_GraphPlotOpType::APPLIED_FNCGRAPH &&
          _GraphType != Mcalc_GraphPlotOpType::NO_GRAPH);
}

/****************************************************************************/
bool Mcalc_GraphOperationOptions::InFunctionPlot() const
{
  return (_GraphOptionsSet &&
          _OperationType == Mcalc_GraphPlotOpType::FUNCTION_PLOT &&
          _GraphType != Mcalc_GraphPlotOpType::NO_GRAPH);
}

/****************************************************************************/
bool Mcalc_GraphOperationOptions::NotInGraphOperation() const
{
  return (!_GraphOptionsSet ||
          _OperationType == Mcalc_GraphPlotOpType::NO_GRAPH ||
          _GraphType == Mcalc_GraphPlotOpType::NO_GRAPH);
}

/****************************************************************************/
AssignmentParsingData::AssignmentParsingData():
_FirstAlpha(FALSE),
_LastDollar(FALSE),
_AnsStrConstFound(FALSE),
_FracAnsConstFound(FALSE),
_VarLetter(0),
_FirstQuotePos(0),
_LastQuotePos(0)
{}

/****************************************************************************/
// DiscontinuityDetectorBase class definitions
/****************************************************************************/
#if ((CALCLIB_DEBUGGING)&(DISCONTDETECT_USE_CALCBASE_CLASS))
DiscontinuityDetectorBase::DiscontinuityDetectorBase(Debugging<CalculatorBase>* dbgptr_):
#else
DiscontinuityDetectorBase::DiscontinuityDetectorBase():
#endif // DISCONTDETECT_USE_CALCBASE_CLASS
_PtBufferSize(CALC_DISCONTINUITY_STRIKES*2+1),
_RdBufferSize(CALC_DISCONTINUITY_STRIKES+2),
_StrikeLimit(CALC_DISCONTINUITY_STRIKES),
_PtGapLimit(CALC_DISCONTINUITY_PTGAP),
_InfPtsDisplaceMargin(CALC_INFPTSDISPLACEMARGIN)
{
  #if ((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))
    #if DISCONTDETECT_USE_CALCBASE_CLASS
      _dbgptr = dbgptr_;
    #else
      _dbgptr = new Debugging<DiscontinuityDetectorBase>(this);

      _dbgptr->SetFilename("calclib-dbg.txt");
      _dbgptr->SetBrkPtFilename("calclib-brkpt.txt");

      _dbgptr->SetBasePtr(this);
      _dbgptr->StartTrackingAll();

      Debugging<DiscontinuityDetectorBase>::SetCurrentDebugger(_dbgptr);

      #if DISCONTDETECT_DEBUG1
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("Debugging Ptr Setup Done:\n\n");
      #endif
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS
  #endif // DISCONTDETECT_DEBUGGING
}

/****************************************************************************/
DiscontinuityDetectorBase::~DiscontinuityDetectorBase()
{
  #if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
    if (_dbgptr && Debugging<DiscontinuityDetectorBase>::CurrentDebugger(false))
    {
      Debugging<DiscontinuityDetectorBase>::SetCurrentDebugger(NULL);
      _dbgptr->SetBasePtr(NULL);
      delete _dbgptr;
      _dbgptr = NULL;
    }

	delete _Fout;
	::EraseString(_Filename);
    ::EraseString(_BasePtr);
	
    _BasePtr = NULL;
	_Filename = NULL;
  #endif
}

/****************************************************************************/
void DiscontinuityDetectorBase::SetOutputFile(const char* Filename_)
{
  _HasFout = Filename_ != NULL;

  if (_HasFout)
  {
	::EraseString(_Filename);
    _Filename = ::NewString(Filename_);

	if (!_Fout)
	  _Fout = new ofstream;

	_Fout->open(_Filename, ios::out);
	_HasFout = _Fout->good();
  }
  else if (_Filename)
  {
	::EraseString(_Filename);
	_Filename = NULL;

	if (_Fout)
	  _Fout->close();
  }
}

/****************************************************************************/
ofstream* DiscontinuityDetectorBase::GiveOutputFile(bool* HasFout_)
{
  if (HasFout_)
	*HasFout_ = _HasFout;

  return _Fout;
}

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
size_t DiscontinuityDetectorBase::GetErrline()
{
  return _errline;
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
size_t DiscontinuityDetectorBase::GetErrline()
{
  return (_BasePtr ? _BasePtr->GetErrline():0);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
size_t DiscontinuityDetectorBase::GetErrcol()
{
  return _errcol;
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
size_t DiscontinuityDetectorBase::GetErrcol()
{
  return (_BasePtr ? _BasePtr->GetErrcol():0);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
int DiscontinuityDetectorBase::GetErrcode()
{
  return _errcode;
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
int DiscontinuityDetectorBase::GetErrcode()
{
  return (_BasePtr ? _BasePtr->GetErrcode():0);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
void DiscontinuityDetectorBase::SetErrorData(int errcode_, const char* file_,
                                             size_t line_, size_t col_, bool terminate_)
{
  _errline = line_;
  _errcol = col_;
  _errcode = errcode_;
  char* buffer_ = NULL;
  char* fmtstr_;

  if (file_)
  {
    buffer_ = ::strcpy(new char[strlen(file_) + 100], file_);
    strcat(buffer_, ": ");
    strcat(buffer_, ERRMSG_ERROR_IN_LINE);
  }
  else
  {
    buffer_ = new char[100];
    strcpy(buffer_, ERRMSG_ERROR_IN_LINE);
  }

  FILE* fp = fopen("discontdetect_errorout.txt", "w");

  fmtstr_ = strdup(buffer_);
  sprintf(buffer_, fmtstr_, _errline, _errcol, _errcode);
  fputs(buffer_, fp);
  fflush(fp);
  fclose(fp);
  free(fmtstr_);
  delete[] buffer_;

  if (terminate_)
    exit(_errcode);
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
void DiscontinuityDetectorBase::SetErrorData(int errcode_, const char* file_,
                                             size_t line_, size_t col_, bool terminate_)
{
  if (_BasePtr)
    _BasePtr->SetErrorData(errcode_, file_, line_, col_, terminate_);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
void DiscontinuityDetectorBase::Terminate(bool setcode_, int errcode_)
{
  if (setcode_)
    _errcode = errcode_;

  exit(_errcode);
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
void DiscontinuityDetectorBase::Terminate(bool setcode_, int errcode_)
{
  if (_BasePtr)
    _BasePtr->Terminate(setcode_, errcode_);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
void DiscontinuityDetectorBase::SetCurrentDebugger(Debugging<DiscontinuityDetectorBase>* ptr)
{
  Debugging<DiscontinuityDetectorBase>::SetCurrentDebugger(ptr);
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
void DiscontinuityDetectorBase::SetCurrentDebugger(Debugging<CalculatorBase>* ptr)
{
  if (_BasePtr)
    _BasePtr->SetCurrentDebugger(ptr);
}
#endif

/****************************************************************************/
#if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
Debugging<DiscontinuityDetectorBase>* DiscontinuityDetectorBase::DbgPtr(bool Deref_)
{
  Debugging<DiscontinuityDetectorBase>* ptr =
    Debugging<DiscontinuityDetectorBase>::CurrentDebugger(Deref_);

  if (Deref_ && !ptr)
    SetErrorData(1);

  return ptr;
}
#elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
Debugging<CalculatorBase>* DiscontinuityDetectorBase::DbgPtr(bool Deref_)
{
  return (_BasePtr ? _BasePtr->DbgPtr(Deref_):NULL);
}
#endif

/****************************************************************************/
#if DISCONTDETECT_USE_CALCBASE_CLASS
bool DiscontinuityDetectorBase::SetCalculatorPtr(CalculatorBase* BasePtr_)
{
  if (BasePtr_)
  {
    _BasePtr = BasePtr_;

    if (_BasePtr)
      _UsingCalcType = _BasePtr->GetCalcIndex();
  }

  return (_BasePtr != NULL && _UsingCalcType != CalculatorBase::NO_CALC);
}

/****************************************************************************/
CalculatorBase* DiscontinuityDetectorBase::GetCalculatorPtr()
{
  return _BasePtr;
}

/****************************************************************************/
#else
bool DiscontinuityDetectorBase::SetCalculatorPtr(const char* BasePtr_)
{
  if (BasePtr_)
  {
    _BasePtr = ::NewString(BasePtr_);

    _UsingCalcType = strcmp(_BasePtr, "FLOAT") == 0 ? FLOAT:
                     strcmp(_BasePtr, "DOUBLE") == 0 ? DOUBLE:
                     strcmp(_BasePtr, "LONGDOUBLE") == 0 ? LONGDOUBLE:
                     strcmp(_BasePtr, "LONGNUM") == 0 ? LONGNUM:
                                                        NO_CALC;
  }

  return (_BasePtr != NULL && _UsingCalcType != NO_CALC);
}
/****************************************************************************/
const char* DiscontinuityDetectorBase::GetCalculatorPtr()
{
  return _BasePtr;
}

#endif // DISCONTDETECT_USE_CALCBASE_CLASS

MEMORYOPS_DEFN(DiscontinuityDetectorBase)
/****************************************************************************/
// StrVarData class definitions
/****************************************************************************/
StrVarData::StrVarData():
_SetResult(0)
{
  int i;
  for (i = 0; i < CalculatorBase::MAXVARS; i++)
  {
    _IsStringVar[i] = 0;
    _IsSetVar[i] = 0;
    _strvars[i] = NULL;
  }
}

/****************************************************************************/
StrVarData::~StrVarData()
{
  int i;
  for (i = 0; i < CalculatorBase::MAXVARS; i++)
  {
    if (MemMatrix::Matrix().HasThis(_strvars[i]))
      delete _strvars[i];

    _strvars[i] = NULL;
  }
}

/****************************************************************************/
void StrVarData::SetSetElements(int Index_, const ChrString& Str_, int Null_)
{
  if (Index_ >= 0)
  {
    if (!_strvars[Index_])
      _strvars[Index_] = new ChrString();

    *(_strvars[Index_]) = Str_;
    _IsSetVar[Index_] = Null_ ? 2:1;
  }
}

/****************************************************************************/
void StrVarData::SetString(int Index_, const ChrString& Str_)
{
  if (Index_ >= 0)
  {
    if (!_strvars[Index_])
      _strvars[Index_] = new ChrString();

    *(_strvars[Index_]) = Str_;
    _IsSetVar[Index_] = 0;
  }
}

/****************************************************************************/
const ChrString& StrVarData::GetVariable(int Index_) const
{
  static ChrString Dummy_;
  return ((Index_ >= 0 && _strvars[Index_]) ? *(_strvars[Index_]):Dummy_);
}

/****************************************************************************/
const ChrString& StrVarData::GetSetVariable(int Index_) const
{
  static ChrString Dummy_;
  static ChrString NullStr_("null");

  return
  (
    (Index_ >= 0 && _strvars[Index_]) ?
        ((_IsSetVar[Index_] == 1) ? *(_strvars[Index_]):NullStr_):
        Dummy_
  );
}

/****************************************************************************/
const ChrString& StrVarData::GetResult() const
{
  return _StrResult;
}

/****************************************************************************/
const ChrString& StrVarData::GetSetResult() const
{
  static ChrString NullStr_("null");
  return ((_SetResult == 1) ? _StrResult:NullStr_);
}

/****************************************************************************/
void StrVarData::SetResult(const char* Str_)
{
  if (Str_)
    _StrResult = Str_;
}

/****************************************************************************/
void StrVarData::SetSetResult(const char* Str_, bool Null_)
{
  if (Str_)
  {
    _StrResult = Str_;
    _SetResult = Null_ ? 2:1;
  }
}

/****************************************************************************/
size_t StrVarData::GetVarLen(int Index_) const
{
  return ((Index_ >= 0 && _strvars[Index_]) ? _strvars[Index_]->strlen():0);
}

/****************************************************************************/
void StrVarData::SetStringVar(int Index_, Boolean Flag_)
{
  if (Index_ >= 0)
  {
    _IsStringVar[Index_] = Flag_;
    _IsSetVar[Index_] = 0;
  }
}

/****************************************************************************/
Boolean StrVarData::IsStringVar(int Index_) const
{
  return ((Index_ >= 0) ? _IsStringVar[Index_]:FALSE);
}

/****************************************************************************/
void StrVarData::SetSetVar(int Index_, int Flag_)
{
  if (Index_ >= 0)
  {
    _IsStringVar[Index_] = Flag_;
    _IsSetVar[Index_] = Flag_;
  }
}

/****************************************************************************/
int StrVarData::IsSetVar(int Index_) const
{
  return ((Index_ >= 0) ? _IsSetVar[Index_]:FALSE);
}

/****************************************************************************/
int StrVarData::IsNullSet(int Index_) const
{
  return ((Index_ >= 0) ? (_IsSetVar[Index_] == 2):FALSE);
}

/****************************************************************************/
ChrString& StrVarData::CopyStrVar(ChrString& DestStr_, int Index_)
{
  if (Index_ >= 0 && _strvars[Index_] && _strvars[Index_]->strlen())
    DestStr_ = *(_strvars[Index_]);

  return DestStr_;
}

/****************************************************************************/
char* StrVarData::CopyStrVar(char* DestStr_, int Index_)
{
  if (Index_ >= 0 && _strvars[Index_] && _strvars[Index_]->strlen())
    strcpy(DestStr_, _strvars[Index_]->c_str());

  return DestStr_;
}

/****************************************************************************/
// CalcGlobalSwitch class definitions
/****************************************************************************/
CalcGlobalSwitch::CalcGlobalSwitch():
_MathExprLine(NULL),
_SwitchStr(NULL),
_GlobalSwitchFlag(NULL),

_NextSwitchStrIndex(0),
_SwWordMult(0),
_NoSwitchPosShift(0),
_SearchStrIndex(0),

_LeftBrk(false),
_SwitchChkDone(false),
_SwitchCmdFound(false),
_SwitchCmdIgnored(false),
_SearchResetDone(true),

_SwitchStart(NULL),
_SwitchExt(NULL),
_LeftBrkStart(NULL),
_EndBrkStart(NULL),
_PostSwitchStart(NULL)
{}

/****************************************************************************/
CalcGlobalSwitch::~CalcGlobalSwitch()
{
  ::RawDeleteArray(_SwitchStr);
  _SwitchStr = NULL;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::ResetSwitchCheckData()
{
  _MathExprLine = NULL;

  _NextSwitchStrIndex = 0;
  _SwWordMult = 0;
  _NoSwitchPosShift = 0;
  _SearchStrIndex = 0;

  _LeftBrk = false;
  _SwitchChkDone = false;
  _SwitchCmdFound = false;
  _SwitchCmdIgnored = false;
  _SearchResetDone = true;

  _SwitchStart = NULL;
  _SwitchExt = NULL;
  _LeftBrkStart = NULL;
  _EndBrkStart = NULL;
  _PostSwitchStart = NULL;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::ResetSwitchCheckDone()
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _SwitchChkDone = false;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetExprLineIndex(int v)
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _SearchStrIndex = v;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitch(const char* SwitchStr_)
{
  ::RawDeleteArray(_SwitchStr);
  _SwitchStr = ::NewString(SwitchStr_);
  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetMathExprLine(char* Line_)
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _MathExprLine = Line_;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitchAddress(int* addr)
{
  _GlobalSwitchFlag = addr;
  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitchProcessed(int v)
{
  if (_GlobalSwitchFlag)
  {
    *_GlobalSwitchFlag = v;
    _SearchResetDone = !v && !_SwitchCmdIgnored && !_SwitchCmdFound;
  }

  return this;
}

/****************************************************************************/
void CalcGlobalSwitch::SetSwitchCmdFound(bool v)
{
  _SwitchCmdFound = v;
  _SearchResetDone = !v && !_SwitchCmdIgnored &&
                     (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag));
}

/****************************************************************************/
void CalcGlobalSwitch::SetSwitchCmdIgnored(bool v)
{
  _SwitchCmdIgnored = v;
  _SearchResetDone = !v && !_SwitchCmdFound &&
                     (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag));
}

/****************************************************************************/
int CalcGlobalSwitch::PosShiftToNoSwitchStr(bool DecLoopIndex_) const
{
  return ((DecLoopIndex_ && _NoSwitchPosShift) ? (_NoSwitchPosShift - 1):_NoSwitchPosShift);
}

/****************************************************************************/
char* CalcGlobalSwitch::FindEndBrk(bool LbFound_, char* str)
{
  if (!LbFound_ || !str)
    return NULL;

  int brkbal = 1;
  int cbpos = 0;
  int max = ::SafeStrLen(str);
  int x = 0;

  for (++x; x < max && brkbal; x++)
  {
    if (str[x] == '(')
      brkbal++;
    else if (str[x] == ')')
    {
      brkbal--;
      cbpos = !brkbal ? x:0;
    }
  }

  if (cbpos)
    return &str[cbpos];

  return NULL;
}

/****************************************************************************/
char* CalcGlobalSwitch::FindPostSwitchStart(char* str)
{
  if (!str)
    return NULL;

  if (*str)
  for (++str; *str && (isspace(*str) || *str == ';'); str++);

  return str;
}

/****************************************************************************/
bool CalcGlobalSwitch::CheckForSwitch(bool SwitchFound_)
{
  if (_GlobalSwitchFlag && *_GlobalSwitchFlag)
    return false;

  int x;
  int slen;
  int swptindex_;
  int SwStrLen_ = 0;
  int ListLen_ = 0;

  char* oldswpt;
  char* list = _MathExprLine;
  char* listpt;
  char* CharSet_ = CalculatorBase::GiveFuncNamesCharSet();

  bool StrMatch_ = false;
  bool HasNextSwitchStr_ = false;

  if (list)
  {
    if (_SearchStrIndex > 0)
      list += _SearchStrIndex;

    SwStrLen_ = strlen(_SwitchStr);
    ListLen_ = strlen(list);

    if (ListLen_ <= SwStrLen_)
    {
      _SwitchChkDone = true;
      return false;
    }
  }
  else
  {
    _SwitchChkDone = true;
    return false;
  }

  if (!_SwitchChkDone)
  {
    _SwitchChkDone = true;
    StrMatch_ = CalculatorBase::icasestrcompn(list, _SwitchStr, SwStrLen_);
    HasNextSwitchStr_ = StrMatch_ && isspace(list[SwStrLen_]);
    _NextSwitchStrIndex = HasNextSwitchStr_ ? ::StrHasChar(&list[SwStrLen_], CharSet_):
                          (StrMatch_ &&
                           CalculatorBase::IsLeftBrkSymbols(list[SwStrLen_])) ? 0:-1;
    HasNextSwitchStr_ = _NextSwitchStrIndex != -1;
    _LeftBrk = _NextSwitchStrIndex == 0 && list[SwStrLen_] == '(';
    _SwWordMult = HasNextSwitchStr_ ? 1:0;

    oldswpt = list;
    swptindex_ = 0;
    _NextSwitchStrIndex += SwStrLen_;
    _NoSwitchPosShift = HasNextSwitchStr_ ? _NextSwitchStrIndex:0;

    if (!_LeftBrk && HasNextSwitchStr_)
    {
      listpt = &list[_NextSwitchStrIndex];
      slen = strlen(listpt);
      for (x = 0; x < slen && isspace(*listpt); listpt++, x++);

      while (*listpt && CalculatorBase::icasestrcompn(listpt, _SwitchStr, SwStrLen_))
      {
        _SwWordMult++;
        oldswpt = listpt;
        swptindex_ = _NextSwitchStrIndex + x;
        listpt += SwStrLen_;
        for (x += SwStrLen_; x < slen && isspace(*listpt); listpt++, x++);
      }

      _LeftBrk = CalculatorBase::IsLeftBrkSymbols(*listpt);

      if (_LeftBrk || InCharSet(*listpt, CharSet_))
        _NextSwitchStrIndex += x;

      if (x > 0 && _SwWordMult > 1)
        _NoSwitchPosShift = _NextSwitchStrIndex;
    }

    if (HasNextSwitchStr_)
    {
      SwitchFound_ =
      _SwitchCmdFound = true;
      _SwitchCmdIgnored = false;

      _LeftBrk = CalculatorBase::IsLeftBrkSymbols(list[_NextSwitchStrIndex]);
      _SwitchStart = oldswpt;
      _SwitchExt = !_LeftBrk ? &list[_NextSwitchStrIndex]:NULL;
      _LeftBrkStart = _LeftBrk ? &list[_NextSwitchStrIndex]:NULL;
      _EndBrkStart = FindEndBrk(_LeftBrk, _LeftBrkStart);
      _PostSwitchStart = FindPostSwitchStart(_EndBrkStart);

      _NextSwitchStrIndex = swptindex_;
      _NextSwitchStrIndex += _SearchStrIndex;
      _NoSwitchPosShift += _SearchStrIndex;
    }
  }

  return SwitchFound_;
}

/****************************************************************************/
void CalcGlobalSwitch::PrintAllData(ostream& os)
{
    if (_SwitchStr)
      os <<"GlobalSwitch: " <<_SwitchStr <<endl;

    if (_MathExprLine)
    {
      os <<"MathExprLine: " <<_MathExprLine <<endl;

      if (_SearchStrIndex >= 0)
        os <<"&MathExprLine[SearchStrIndex]: "
           <<&_MathExprLine[_SearchStrIndex] <<endl;
    }

    os <<endl;
    os <<"SwitchCheckDone(): "       <<SwitchCheckDone()       <<endl;
    os <<"SwitchCmdFound(): "        <<SwitchCmdFound()        <<endl;
    os <<"SwitchCmdIgnored(): "      <<SwitchCmdIgnored()      <<endl;
    os <<"HasLeftBrk(): "            <<HasLeftBrk()            <<endl <<endl;

    os <<"SwitchWordMultiples(): "   <<SwitchWordMultiples()        <<endl;
    os <<"LastSwitchStrIndex(): "    <<LastSwitchStrIndex()         <<endl;
    os <<"PosShiftToNoSwitchStr(): " <<PosShiftToNoSwitchStr(false) <<endl <<endl;

    if (GetSwitchStart())
      os <<"GetSwitchStart(): "  <<GetSwitchStart() <<endl;

    if (GetSwitchExt())
      os <<"GetSwitchExt(): "    <<GetSwitchExt() <<endl;

    if (GetLeftBrkStart())
      os <<"GetLeftBrkStart(): " <<GetLeftBrkStart() <<endl;

    if (GetEndBrkStart())
      os <<"GetEndBrkStart(): "  <<GetEndBrkStart() <<endl;

    if (GetPostSwitchStart())
      os <<"GetPostSwitchStart(): "  <<GetPostSwitchStart() <<endl <<endl;
}

/****************************************************************************/
// ExpressionGraphStack class definitions
/****************************************************************************/
ExpressionGraphStack::ExpressionGraphStack(SubExpression* Parent_,
                                           CalcGraphPlotter* CalcPlot_,
                                           ExprStringStack* Stack_,
                                           bool OwnsStk_):
_Parent(Parent_),
_Stack(Stack_),
_Plotter(CalcPlot_),
_CalcPtr(Parent_ ? Parent_->GetCalculator():NULL),

_OwnsStack(OwnsStk_)
{
  if (_OwnsStack && _Stack)
  {
    CalculatorBase::ResetStringStack();
    _Stack->SetOwnsStack(false);
  }
}

/****************************************************************************/
ExpressionGraphStack::~ExpressionGraphStack()
{
  if (_OwnsStack)
  {
    CalcGraphPlotter* GraphPlot_ = _Parent ? _Parent->GetGraphPlotter():NULL;
    SetGraphPlotter(GraphPlot_);

    if (_Stack && _Stack->GetStkSz() && _Parent &&
        _Plotter && _Plotter->IsParent(_Parent) &&
        (_Parent->NotGraphOp() || _Parent->IsPlotCompleted()))
      ClearExpressionStack();
    else if (_Stack && _Stack->GetStkSz() &&
             _Plotter && _Plotter->IsParent(_Parent))
      DestroyExpressionStack(true);

    delete _Stack;
    _Stack = NULL;
  }
}

/****************************************************************************/
void ExpressionGraphStack::SetCalculator(CalculatorBase* CalcPtr_)
{
  _CalcPtr = CalcPtr_;
}

/****************************************************************************/
ExpressionGraphStack* ExpressionGraphStack::CreateExpressionStack(int Size_)
{
  const char* ExprStr_ = _Parent ? _Parent->GetExprToGraph():NULL;

  if (ExprStr_ && _Stack)
    _Stack->CreateStack(Size_);

  return this;
}

/****************************************************************************/
ExpressionGraphStack* ExpressionGraphStack::GrowExpressionStack(int Size_)
{
  CalcGraphPlotter* GraphPlot_ = _Parent ? _Parent->GetGraphPlotter():NULL;

  if (_Stack && _Stack->GetStkSz() &&
      (!_Plotter ||
       (GraphPlot_ && GraphPlot_->IsParent(_Parent)) ||
       (!GraphPlot_ && !_Plotter->HasParent())))
  {
    _Stack->GrowStack(Size_);

    if (_Plotter && _Plotter->HasNextExpression())
      _Plotter->SetNextExpression(this);
  }

  return this;
}

/****************************************************************************/
void ExpressionGraphStack::DestroyExpressionStack(bool IsParent_)
{
  if (_Stack && _Stack->GetStkSz() && IsParent_)
  {
    if (_Parent && !_Parent->FunctionSearchInProgress())
    {
      _Parent->ResetCalcStateVars();
      _Parent->SetGraphPlotter(NULL);
    }

    if (_Plotter)
    {
      _Plotter->SetNextExpression(NULL);
      _Plotter->SetExprToReplace(NULL);
    }

    if (_Stack->GetStkPtr() && _OwnsStack)
      _Stack->DestroyStack();
  }
}

/****************************************************************************/
ExpressionGraphStack* ExpressionGraphStack::ClearExpressionStack(CalculatorBase* Calcp_)
{
  if (_Stack && _Stack->GetStkSz() && _Parent &&
      _Plotter && _Plotter->IsParent(_Parent) &&
      (_Parent->NotGraphOp() || _Parent->IsPlotCompleted()))
  {
    while (_Parent->GetGraphPlotter() && _Stack->HasAnyExpr() &&
           _Parent->GetGraphPlotter()->HasNextExpression())
      if (!PopGraphExpression(Calcp_))
        break;

    if (_OwnsStack && _Stack && _Stack->GetStkSz())
      DestroyExpressionStack(true);
  }

  return this;
}

/****************************************************************************/
bool ExpressionGraphStack::HasAnyExpr() const
{
  return (_Stack && _Stack->HasAnyExpr());
}

/****************************************************************************/
bool ExpressionGraphStack::HasExpression(const char* Ptr_, int* Index_)
{
  if (_Stack && _Stack->GetStkSz())
    return _Stack->HasExprStr(Ptr_, Index_);

  return false;
}

/****************************************************************************/
const char* ExpressionGraphStack::PopGraphExpression(CalculatorBase* Calcp_)
{
  int Index_;
  char* PoppedStr_ = NULL;

  CalculatorBase* CalcPtr_ = (_Parent && _Parent->GetCalculator()) ?
                                        _Parent->GetCalculator():
                             _CalcPtr ? _CalcPtr:
                                        Calcp_;
  CalcGraphPlotter* GraphPlot_ = _Parent ? _Parent->GetGraphPlotter():NULL;

  if (_Stack && _Stack->GetStkSz() && _Parent &&
      GraphPlot_ && GraphPlot_->HasNextExpression() &&
      GraphPlot_->IsParent(_Parent) && _Parent->IsPlotCompleted())
  {
    Index_ = GraphPlot_->GetNextExpressionIndex();

    if (Index_ >= 0 && !_Parent->FunctionSearchInProgress())
    {
      PoppedStr_ = _Stack->PopString(Index_);

      _Parent->ResetCalcStateVars();
      _Parent->AssignExpression(PoppedStr_, true);
    }

    if (GraphPlot_)
    {
      if (CalcPtr_ && !_Stack->HasAnyExpr() &&
          CalculatorBase::GraphOperation())
      {
        CalcPtr_->SetPlotGraph(true, 0, true, 0);
        SetGraphPlotter(CalculatorBase::GetGraphPlotter());
        _Parent->SetGraphPlotter(NULL);
      }
      else if (GraphPlot_->IsExprToReplace(PoppedStr_))
      {
        GraphPlot_->SetExprToReplace(NULL);
        _Parent->SetGraphPlotter(NULL);
      }
    }
  }

  return PoppedStr_;
}

/****************************************************************************/
const char* ExpressionGraphStack::PushGraphExpression()
{
  if (!_Plotter)
    return NULL;

  DelayedMemoryDeleter* MemDel_;
  CalcGraphPlotter* GraphPlot_ = _Parent ? _Parent->GetGraphPlotter():NULL;

  const char* ExprRep_ = _Parent ? _Parent->GetExprToReplace():NULL;
  const char* ExprGraph_ = _Parent ? _Parent->GetExprToGraph():NULL;

  char* ExprStr_ = NULL;
  char* NextSub_ = NULL;

  if (_Stack && _Parent &&
      ExprGraph_ && ExprRep_ && !GraphPlot_ &&
      _Plotter && !_Plotter->HasNextExpression())
  {
    NextSub_ = _Parent->AllocateNewString(NULL, NULL, strlen(ExprGraph_), false, true);
    ::SafeStrCpy(NextSub_, ExprGraph_);

    if (NextSub_)
    {
      _Parent->AssignExpression(&ExprStr_);
      _Stack->PushString(ExprStr_, false);

      _Parent->AssignExpression(NextSub_, false);
      _Parent->SetGraphPlotter(_Plotter);

      if (_Plotter)
      {
        _Plotter->SetNextExpression(this);
        _Plotter->SetExprToReplace(ExprRep_);
      }
    }
  }

  return NextSub_;
}

/****************************************************************************/
void ExpressionGraphStack::SetStringStack(ExprStringStack* Stack_, bool OwnsStk_)
{
  _Stack = Stack_;
  _OwnsStack = OwnsStk_;

  if (_OwnsStack)
  {
    CalculatorBase::ResetStringStack();
    _Stack->SetOwnsStack(false);
  }
}

/****************************************************************************/
void ExpressionGraphStack::SetGraphPlotter(CalcGraphPlotter* CalcPlot_)
{
  _Plotter = CalcPlot_;
}

/****************************************************************************/
SubExpression* ExpressionGraphStack::GiveParent()
{
  return _Parent;
}

/****************************************************************************/
// SubExpression class definitions
/****************************************************************************/
SubExpression::SubExpression():
_CalcPtr(NULL),
_PrevCalc(NULL),
_Parent(NULL),
_GraphPlotter(NULL),
_GlobalGraphSwitch(NULL),
_GlobalExecSwitch(NULL),
_GpExprStack(NULL),

_CalcNumber(0),
_Level(0),
_FunctionNames(CalculatorBase::FUNCTION_NAMES),
_Expression(NULL),
_AnswerStr(NULL),
_OriginalStr(NULL),
_ProgramName(NULL),
_FncCalls(NULL),
_AnswerMode(0),
_NumFncNames(CalculatorBase::NumFncNames()),
_NumFncCalls(0),
_ArrayLimit(0),
_ShortestName(CalculatorBase::ShortestFncName()),

_IsParam(FALSE),
_NoReturns(FALSE),
_HasAnswer(FALSE),
_ShowAnswer(FALSE),
_SingleFncCall(FALSE),
_ShowFunction(FALSE),
_ShowSetFunction(FALSE),
_ExecCmdWasFound(FALSE),
_GraphCmdWasFound(FALSE),
_FunctionSearchInProgress(FALSE),
_FunctionValidityChkNeeded(FALSE),
_FunctionValidityChkDone(FALSE),
_MemDel(new DelayedMemoryDeleter)
{
  _ArrayLimit = 10;
  _FncCalls = (FunctionCall**)MemMatrix::Matrix().Callocate(_ArrayLimit * sizeof(FunctionCall*));

  _GlobalGraphSwitch = new CalcGlobalSwitch();
  _GlobalGraphSwitch->SetGlobalSwitch("GRAPH");
  _GlobalGraphSwitch->SetGlobalSwitchAddress(&_GraphCmdProcessed);

  _GlobalExecSwitch = new CalcGlobalSwitch();
  _GlobalExecSwitch->SetGlobalSwitch("EXEC");
  _GlobalExecSwitch->SetGlobalSwitchAddress(&_ExecCmdProcessed);

  int x;
  for (x = 0; x < _ArrayLimit; x++)
    _FncCalls[x] = NULL;
}

/****************************************************************************/
SubExpression::SubExpression(SubExpression* Parent_, int Level_, const char* Expr_):
_CalcPtr(NULL),
_PrevCalc(NULL),
_Parent(Parent_),
_GraphPlotter(NULL),
_GlobalGraphSwitch(NULL),
_GlobalExecSwitch(NULL),
_GpExprStack(NULL),

_CalcNumber(0),
_Level(Level_),
_FunctionNames(CalculatorBase::FUNCTION_NAMES),
_Expression(NULL),
_AnswerStr(NULL),
_OriginalStr(NULL),
_ProgramName(NULL),
_FncCalls(NULL),
_AnswerMode(0),
_NumFncNames(CalculatorBase::NumFncNames()),
_NumFncCalls(0),
_ArrayLimit(0),
_ShortestName(CalculatorBase::ShortestFncName()),

_IsParam(FALSE),
_NoReturns(FALSE),
_HasAnswer(FALSE),
_ShowAnswer(FALSE),
_SingleFncCall(FALSE),
_ShowFunction(FALSE),
_ShowSetFunction(FALSE),
_ExecCmdWasFound(FALSE),
_GraphCmdWasFound(FALSE),
_FunctionSearchInProgress(FALSE),
_FunctionValidityChkNeeded(FALSE),
_FunctionValidityChkDone(FALSE),
_MemDel(new DelayedMemoryDeleter)
{
  _Expression = (char*)MemMatrix::Matrix().Callocate(::SafeStrLen(Expr_) + 1);
  ::SafeStrCpy(_Expression, Expr_);

  _GlobalGraphSwitch = new CalcGlobalSwitch();
  _GlobalGraphSwitch->SetGlobalSwitch("GRAPH");
  _GlobalGraphSwitch->SetGlobalSwitchAddress(&_GraphCmdProcessed);

  _GlobalExecSwitch = new CalcGlobalSwitch();
  _GlobalExecSwitch->SetGlobalSwitch("EXEC");
  _GlobalExecSwitch->SetGlobalSwitchAddress(&_ExecCmdProcessed);

  if (!_Parent)
  {
    ChrString ExprStr_ = Expr_;
    ExprStr_.RemovePadding(" \n\t\r");
    _OriginalStr = (char*)MemMatrix::Matrix().Callocate(::SafeStrLen(ExprStr_.c_str()) + 1);
    ::SafeStrCpy(_OriginalStr, ExprStr_.c_str());
  }

  _ArrayLimit = 10;
  _FncCalls = (FunctionCall**)MemMatrix::Matrix().Callocate(_ArrayLimit * sizeof(FunctionCall*));

  int x;
  for (x = 0; x < _ArrayLimit; x++)
    _FncCalls[x] = NULL;
}

/****************************************************************************/
SubExpression::SubExpression(const SubExpression& Obj_):
_CalcPtr(Obj_._CalcPtr),
_PrevCalc(Obj_._PrevCalc),
_Parent(Obj_._Parent),
_GraphPlotter(NULL),
_GlobalGraphSwitch(NULL),
_GlobalExecSwitch(NULL),
_GpExprStack(NULL),

_CalcNumber(Obj_._CalcPtr ? Obj_._CalcPtr->ClassNumber():0),
_Level(Obj_._Level),
_FunctionNames(CalculatorBase::FUNCTION_NAMES),
_Expression(NULL),
_AnswerStr(NULL),
_OriginalStr(NULL),
_ProgramName(NULL),
_FncCalls(NULL),
_AnswerMode(0),
_NumFncNames(CalculatorBase::NumFncNames()),
_NumFncCalls(0),
_ArrayLimit(0),
_ShortestName(CalculatorBase::ShortestFncName()),

_IsParam(FALSE),
_NoReturns(FALSE),
_HasAnswer(FALSE),
_ShowAnswer(FALSE),
_SingleFncCall(FALSE),
_ShowFunction(FALSE),
_ShowSetFunction(FALSE),
_ExecCmdWasFound(FALSE),
_GraphCmdWasFound(FALSE),
_FunctionSearchInProgress(FALSE),
_FunctionValidityChkNeeded(FALSE),
_FunctionValidityChkDone(FALSE),
_MemDel(new DelayedMemoryDeleter)
{
  _GlobalGraphSwitch = new CalcGlobalSwitch();
  _GlobalGraphSwitch->SetGlobalSwitch("GRAPH");
  _GlobalGraphSwitch->SetGlobalSwitchAddress(&_GraphCmdProcessed);

  _GlobalExecSwitch = new CalcGlobalSwitch();
  _GlobalExecSwitch->SetGlobalSwitch("EXEC");
  _GlobalExecSwitch->SetGlobalSwitchAddress(&_ExecCmdProcessed);

  CalculatorBase* CalcPtr_ = _CalcPtr;
  CalcPtr_ = CalcPtr_ ? CalcPtr_->GetCalcType():NULL;
  if (!CalcPtr_) CalcPtr_ = _CalcPtr;

  _CalcNumber = CalcPtr_ ? CalcPtr_->ClassNumber():0;
  _ArrayLimit = 10;
  _FncCalls = (FunctionCall**)MemMatrix::Matrix().Callocate(_ArrayLimit * sizeof(FunctionCall*));

  SetExpression(Obj_._Expression);
  SetAnswer(Obj_._AnswerStr);

  int x;
  for (x = 0; x < _ArrayLimit; x++)
    _FncCalls[x] = NULL;
}

/****************************************************************************/
SubExpression::~SubExpression()
{
  if (!_CalcPtr)
    _CalcPtr = _PrevCalc;

  Clear();

  delete _GlobalGraphSwitch;
  _GlobalGraphSwitch = NULL;

  delete _GlobalExecSwitch;
  _GlobalExecSwitch = NULL;

  if (_GpExprStack)
  {
    delete _GpExprStack;
    _GpExprStack = NULL;
  }

  MemMatrix::Matrix().Deallocate(_FncCalls);
  _FncCalls = NULL;
  _FunctionNames = NULL;

  delete _MemDel;
  _MemDel = NULL;

  _PrevCalc = _CalcPtr = NULL;
}

/****************************************************************************/
void SubExpression::Clear()
{
  CalculatorBase* CalcPtr_ = _CalcPtr ? _CalcPtr:_PrevCalc;

  if (_GpExprStack && !_CalcPtr)
    _GpExprStack->SetCalculator(CalcPtr_);

  if (CalcPtr_ && CalculatorBase::CalculatorExists(_CalcNumber) &&
      CalcPtr_->SubExprStackIndex() <= 1)
  {
    CalcPtr_->ResetAnswerMode();
    CalcPtr_->RestoreCalcType();
  }

  if (!_FunctionSearchInProgress &&
      ((NotGraphOp() && NotInGraphOp()) || IsPlotCompleted()))
  {
    if (_GraphPlotter && _GraphPlotter->IsParent(this))
      EndGraphPlotting(true);
    else if (!_GraphPlotter)
      ResetCalcStateVars();
  }

  MemMatrix::Matrix().Deallocate(_Expression);
  MemMatrix::Matrix().Deallocate(_AnswerStr);
  MemMatrix::Matrix().Deallocate(_OriginalStr);

  _Expression = _AnswerStr = _OriginalStr = NULL;
  _FunctionValidityChkNeeded = FALSE;
  _FunctionValidityChkDone = FALSE;

  int x;
  for (x = 0; x < _NumFncCalls; x++)
  {
    if (MemMatrix::Matrix().HasThis(_FncCalls[x]))
      delete _FncCalls[x];
    _FncCalls[x] = NULL;
  }

  _NumFncCalls = 0;
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& SubExpression::GetOriginalChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetOriginalStr = _OriginalStr;
    return _RetOriginalStr;
  #else
    ChrString Dummy_ = _OriginalStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& SubExpression::GetExpressionChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetExpression = _Expression;
    return _RetExpression;
  #else
    ChrString Dummy_ = _Expression;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& SubExpression::GetAnswerChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr = _AnswerStr;
    return _RetAnswerStr;
  #else
    ChrString Dummy_ = _AnswerStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& SubExpression::GetProgramNameChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetProgramName = _ProgramName;
    return _RetProgramName;
  #else
    ChrString Dummy_ = _ProgramName;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
const char* SubExpression::GetOriginal(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetOriginalStr = _OriginalStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetOriginalStr;
    return (ret ? ret->c_str():_RetOriginalStr.c_str());
  #else
    return _OriginalStr;
  #endif
}

/****************************************************************************/
const char* SubExpression::GetExpression(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetExpression = _Expression;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetExpression;
    return (ret ? ret->c_str():_RetExpression.c_str());
  #else
    return _Expression;
  #endif
}

/****************************************************************************/
const char* SubExpression::GetAnswer(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr = _AnswerStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetAnswerStr;
    return (ret ? ret->c_str():_RetAnswerStr.c_str());
  #else
    return _AnswerStr;
  #endif
}

/****************************************************************************/
const char* SubExpression::GetProgramName(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetProgramName = _ProgramName;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetProgramName;
    return (ret ? ret->c_str():_RetProgramName.c_str());
  #else
    return _ProgramName;
  #endif
}

/****************************************************************************/
void SubExpression::SetGraphPlotter(CalcGraphPlotter* Plot_)
{
  _GraphPlotter = Plot_;
}

/****************************************************************************/
CalcGraphPlotter* SubExpression::GetGraphPlotter()
{
  return _GraphPlotter;
}

/****************************************************************************/
void SubExpression::ResizeArray()
{
  int x;
  int OldLim_ = _ArrayLimit;
  FunctionCall** OldArray_ = _FncCalls;

  _ArrayLimit += 10;
  _FncCalls = (FunctionCall**)MemMatrix::Matrix().Callocate(_ArrayLimit * sizeof(FunctionCall*));

  for (x = 0; x < OldLim_; x++)
    _FncCalls[x] = OldArray_[x];

  for (;x < _ArrayLimit; x++)
    _FncCalls[x] = NULL;

  MemMatrix::Matrix().Deallocate(OldArray_);
  OldArray_ = NULL;
}

/****************************************************************************/
void SubExpression::SetCalculator(CalculatorBase* CalcPtr_)
{
  CalculatorBase* PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_ ? CalcPtr_->GetCalcType():NULL;

  if (!CalcPtr_)
  {
    if (!_PrevCalc && _CalcPtr)
      _PrevCalc = _CalcPtr;

    CalcPtr_ = PrevCalc_ ? PrevCalc_:_CalcPtr;
  }
  else
    _PrevCalc = NULL;

  if (_CalcPtr != CalcPtr_)
    _CalcNumber = CalcPtr_ ? CalcPtr_->ClassNumber():0;

  _CalcPtr = PrevCalc_;

  if (_CalcPtr)
    _CalcPtr->SetDisplayOption(CalculatorBase::DISPLAY_TO_STRING);
}

/****************************************************************************/
CalculatorBase* SubExpression::GetCalculator()
{
  return _CalcPtr;
}

/****************************************************************************/
int SubExpression::GetCalculatorNumber() const
{
  return _CalcNumber;
}

/****************************************************************************/
void SubExpression::AssignExpression(char** TrgStr_)
{
  if (TrgStr_)
    *TrgStr_ = _Expression;
}

/****************************************************************************/
void SubExpression::AssignExpression(char* Expr_, bool MemErase_)
{
  if (MemErase_ && _Expression != Expr_)
    _MemDel->DelayedDeleteCstr(_Expression, STOREMEM);

  _Expression = Expr_;
}

/****************************************************************************/
void SubExpression::SetProgramName(const char* Name_)
{
  ChrString NameStr_;
  if (Name_)
  {
    NameStr_ = Name_;
    NameStr_.RemovePadding(" \n\t\r");
  }
  else
    NameStr_.SetEmpty();

  if (::SafeStrLen(Name_))
  {
    _ProgramName =  AllocateNewString(_MemDel, _ProgramName, strlen(Name_), true, true);
    ::SafeStrCpy(_ProgramName, NameStr_.c_str());
  }
  else
  {
    _ProgramName =  AllocateNewString(_MemDel, _ProgramName, 5, true, true);
    _ProgramName[0] = 0;
  }
}

/****************************************************************************/
void SubExpression::SetOriginal(const char* Expr_)
{
  ChrString ExprStr_;
  if (Expr_)
  {
    ExprStr_ = Expr_;
    ExprStr_.RemovePadding(" \n\t\r");
  }
  else
    ExprStr_.SetEmpty();

  if (::SafeStrLen(Expr_))
  {
    _OriginalStr =  AllocateNewString(_MemDel, _OriginalStr, strlen(Expr_), true, true);
    ::SafeStrCpy(_OriginalStr, ExprStr_.c_str());
  }
  else
  {
    _OriginalStr =  AllocateNewString(_MemDel, _OriginalStr, 5, true, true);
    _OriginalStr[0] = 0;
  }
}

/****************************************************************************/
void SubExpression::SetAnswer(const char* Ans_)
{
  ChrString AnsStr_;
  if (Ans_)
  {
    AnsStr_ = Ans_;
    AnsStr_.RemovePadding(" \n\t\r");
  }
  else
    AnsStr_.SetEmpty();

  if (::SafeStrLen(Ans_))
  {
    _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, strlen(Ans_), true, true);
    ::SafeStrCpy(_AnswerStr, AnsStr_.c_str());
  }
  else
  {
    _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, 5, true, true);
    _AnswerStr[0] = 0;
  }
}

/****************************************************************************/
Boolean SubExpression::SetExpression(const char* Expr_, int ChkValid_)
{
  ChrString ExprStr_;

  if (Expr_)
  {
    ExprStr_ = Expr_;
    ExprStr_.RemovePadding(" \n\t\r");
  }
  else
    ExprStr_.SetEmpty();

  if (::SafeStrLen(Expr_))
  {
    if (!_FunctionSearchInProgress &&
        ((NotGraphOp() && NotInGraphOp()) || IsPlotCompleted()))
    {
      if (_GraphPlotter && _GraphPlotter->IsParent(this))
        EndGraphPlotting();
      else if (!_GraphPlotter)
        ResetCalcStateVars();
    }

    _Expression = AllocateNewString(_MemDel, _Expression, strlen(Expr_), true, true);
    ::SafeStrCpy(_Expression, ExprStr_.c_str());

    SetExecCmdWasFound(false);
    SetGraphCmdWasFound(false);

    _FunctionValidityChkNeeded = !_Parent;
    _FunctionValidityChkDone = FALSE;
  }
  else
  {
    if (!_FunctionSearchInProgress &&
        ((NotGraphOp() && NotInGraphOp()) || IsPlotCompleted()))
    {
      if (_GraphPlotter && _GraphPlotter->IsParent(this))
        EndGraphPlotting();
      else if (!_GraphPlotter)
        ResetCalcStateVars();
    }

    _Expression = AllocateNewString(_MemDel, _Expression, 5, true, true);
    _Expression[0] = 0;

    SetExecCmdWasFound(false);
    SetGraphCmdWasFound(false);

    _FunctionValidityChkNeeded = FALSE;
    _FunctionValidityChkDone = FALSE;
  }

  if (!_Parent)
  {
    if (::SafeStrLen(Expr_))
    {
      _OriginalStr = AllocateNewString(_MemDel, _OriginalStr, strlen(Expr_), true, true);
      ::SafeStrCpy(_OriginalStr, ExprStr_.c_str());
    }
    else
    {
      _OriginalStr =  AllocateNewString(_MemDel, _OriginalStr, 5, true, true);
      _OriginalStr[0] = 0;
    }
  }

  if (!_FunctionSearchInProgress &&
      ChkValid_ && _Expression && strlen(_Expression) && _CalcPtr)
    return CheckIfValidExpression();

  return TRUE;
}

/****************************************************************************/
Boolean SubExpression::CheckIfValidExpression()
{
  Boolean retval_ = FALSE;

  if (_CalcPtr && !_FunctionValidityChkDone && ::SafeStrLen(_Expression))
  {
    _CalcPtr->SetRecursionLimitReached(FALSE);
    _FunctionValidityChkDone = true;
    retval_ = _CalcPtr->ChkIfMathLineValid(_Expression);
  }

  return retval_;
}

/****************************************************************************/
Boolean SubExpression::MathLineConfirmedValid() const
{
  return (_FunctionValidityChkNeeded &&
          _FunctionValidityChkDone &&
          _CalcPtr->MathLineValid() &&
          !_CalcPtr->HasInvalidTokens());
}

/****************************************************************************/
bool SubExpression::IsSubstTokenStr(const char* sublist, int len)
{
  if (!sublist || len < 3)
    return false;

  int x = 0;
  bool valid_ = sublist[x] == '#';

  if (valid_)
  {
    for (++x; x < len && isdigit(sublist[x]); x++);
    valid_ = x < len && sublist[x] == 's';

    if (valid_)
      valid_ = (x+1 == len) && sublist[len] == 0;
  }

  return valid_;
}

/****************************************************************************/
// - Add _MemDel as 1st arg for delayed memory delete rather than immediate
// - Add NULL as 1st arg for immediate memory deletion
// - true for DelOld_ argument for always deleting old memory buffer rather
//   than as a result of string length comparison
//   (if length of buffer string is shorter than the specified NewLen_)
// - true for AlwaysNew_ if allocation of new memory for the buffer must
//   always be done regardless of the state of the buffer
//
char* SubExpression::AllocateNewString(DelayedMemoryDeleter* MemDel_, char* Buffer_,
                                       size_t NewLen_, bool DelOld_, bool AlwaysNew_)
{
  if (!Buffer_ || AlwaysNew_ || ::SafeStrLen(Buffer_) < NewLen_)
  {
    if (DelOld_ && Buffer_)
      if (MemDel_)
        MemDel_->DelayedDeleteCstr(Buffer_, STOREMEM);
      else
        MemMatrix::Matrix().Deallocate(Buffer_);

    Buffer_ = (char*)MemMatrix::Matrix().Callocate(NewLen_ + 1);
  }

  return Buffer_;
}

/****************************************************************************/
void SubExpression::AddFunctionCall(char* FncCall_, int* DelimArray_)
{
  if (!DelimArray_)
    return;

  int x;
  size_t len = DelimArray_[DelimArray_[0]] + 1;
  char* ExprStart_ = NULL;
  char* OldExpr_ = NULL;
  char* Buffer_ = NULL;
  int EvalFnc_ = 0;
  int ShowFnc_ = 0;
  int IntFnc0_ = 0;
  int IntFnc2_ = 0;
  int SingleArgFncs_ = 0;
  int QuadIntFnc_ = 0;
  int PentIntFnc_ = 0;
  int ShowSetFnc_ = 0;

  int NumParams_ = DelimArray_[0] - 1;
  Buffer_ = (char*)MemMatrix::Matrix().Callocate(len + 1);
  ::SafeStrnCpy(Buffer_, FncCall_, len);
  Buffer_[len] = 0;
  SingleArgFncs_ = (NumParams_ == 1);
  QuadIntFnc_ = (NumParams_ == 4) || (NumParams_ == 2);
  PentIntFnc_ = (NumParams_ == 5) || (NumParams_ == 3);
  EvalFnc_ = _CalcPtr->icasestrcompn(Buffer_, "EVAL", 4) && SingleArgFncs_;
  ShowFnc_ = _CalcPtr->icasestrcompn(Buffer_, "SHOW", 4) && SingleArgFncs_;
  ShowSetFnc_ = _CalcPtr->icasestrcompn(Buffer_, "SHOWSET", 7) && SingleArgFncs_;
  IntFnc0_ = _CalcPtr->icasestrcompn(Buffer_, "INTERSECT", 9) && QuadIntFnc_;
  IntFnc2_ = _CalcPtr->icasestrcompn(Buffer_, "INTERSECT", 9) && PentIntFnc_;

  ExprStart_ = (_Expression && Buffer_) ? strstr(_Expression, Buffer_):NULL;
  ChrString NumStr_;
  NumStr_.IntToStr(_NumFncCalls);
  ChrString Token_("#");
  Token_ += NumStr_;
  Token_ += ChrString("s");
  ChrString SavedToken_ = Token_;
  len = ::SafeStrLen(_Expression);
  size_t newlen;
  newlen = len - ::SafeStrLen(Buffer_) + Token_.strlen();
  OldExpr_ = _Expression;
  *ExprStart_ = 0;

  if (len < newlen)
  {
    len = newlen;
    _Expression = (char*)MemMatrix::Matrix().Callocate(len + 1);
    strcpy(_Expression, OldExpr_);
  }
  else
    OldExpr_ = NULL;

  ::SafeStrCat(_Expression, Token_.c_str());
  Token_ = &ExprStart_[::SafeStrLen(Buffer_)];
  Token_.RemovePadding(" \t\n\r");

  if (Token_.strlen())
    strcat(_Expression, Token_.c_str());

  // Setting original string to have a substitution tag since
  // evaluation would mean the display string will be different
  if (EvalFnc_ && !_Parent)
  {
    _MemDel->DelayedDeleteCstr(OldExpr_, STOREMEM);
    OldExpr_ = _OriginalStr;
    len = ::SafeStrLen(_OriginalStr);
    ExprStart_ = (_OriginalStr && Buffer_) ? strstr(_OriginalStr, Buffer_):NULL;

    Token_ = SavedToken_;
    SavedToken_ = Buffer_;
    char* ExprPtr_ = ExprStart_ + DelimArray_[DelimArray_[0]];
    *ExprPtr_ = 0;
    ExprPtr_ = ExprStart_ + DelimArray_[1] + 1;
    ::SafeStrCpy(Buffer_, ExprPtr_);
    newlen = len - ::SafeStrLen(Buffer_) + Token_.strlen();
    ExprPtr_ = ExprStart_ + DelimArray_[1] + 1;
    *ExprPtr_ = 0;
    ::SafeStrCpy(Buffer_, SavedToken_.c_str());

    if (len < newlen)
    {
      len = newlen;
      _OriginalStr = (char*)MemMatrix::Matrix().Callocate(len + 1);
      strcpy(_OriginalStr, OldExpr_);
    }
    else
      OldExpr_ = NULL;

    ::SafeStrCat(_OriginalStr, Token_.c_str());
    ExprPtr_ = ExprStart_ + DelimArray_[DelimArray_[0]];
    *ExprPtr_ = ')';
    Token_ = ExprPtr_;
    Token_.RemovePadding(" \t\n\r");

    if (Token_.strlen())
      strcat(_OriginalStr, Token_.c_str());
  }

  for (x = 1; x <= DelimArray_[0]; x++)
    Buffer_[DelimArray_[x]] = 0;

  if (_NumFncCalls == _ArrayLimit)
    ResizeArray();

  int ItemFncs_ = 0;
  int CalcFncs_ = 0;
  int FracFnc_ = 0;
  int MakeSetFnc_ = 0;
  int SetOpFncs_ = 0;
  int FuncExtrFncs_ = 0;
  int EndEval_ = 0;
  int OptionFncs_ = 0;
  int MatSolveFnc_ = 0;
  int GraphFnc_ = 0;
  AssignmentParsingData ParseData_;

  GraphFnc_ = _CalcPtr->icasestrcompn(Buffer_, "GRAPH", 5);
  ItemFncs_ =
      _CalcPtr->icasestrcompn(Buffer_, "ITEMPERM", 8)         ||
      _CalcPtr->icasestrcompn(Buffer_, "ITEMCOMB", 8)         ||
      _CalcPtr->icasestrcompn(Buffer_, "ITEMPERMREP", 11)     ||
      _CalcPtr->icasestrcompn(Buffer_, "ITEMCOMBREP", 11);
  FuncExtrFncs_ =
      _CalcPtr->icasestrcompn(Buffer_, "FMIN", 4)       ||
      _CalcPtr->icasestrcompn(Buffer_, "FMAX", 4);
  CalcFncs_ =
      _CalcPtr->icasestrcompn(Buffer_, "FMIN", 4)         ||
      _CalcPtr->icasestrcompn(Buffer_, "FMAX", 4)         ||
      _CalcPtr->icasestrcompn(Buffer_, "DERIV", 5)        ||
      _CalcPtr->icasestrcompn(Buffer_, "INTEG", 5)        ||
      _CalcPtr->icasestrcompn(Buffer_, "SOLVE", 5)        ||
      _CalcPtr->icasestrcompn(Buffer_, "DERIV2", 6);
  SetOpFncs_ = _CalcPtr->icasestrcompn(Buffer_, "SETUNI", 6) ||
               _CalcPtr->icasestrcompn(Buffer_, "SETINT", 6) ||
               _CalcPtr->icasestrcompn(Buffer_, "SETDIF", 6) ||
               _CalcPtr->icasestrcompn(Buffer_, "SETXDIF", 7);
  MakeSetFnc_ = _CalcPtr->icasestrcompn(Buffer_, "SET", 3) && !SetOpFncs_;
  ShowSetFnc_ = _CalcPtr->icasestrcompn(Buffer_, "SHOWSET", 7) && !SetOpFncs_;
  FracFnc_ = _CalcPtr->icasestrcompn(Buffer_, "FRAC", 4);
  MatSolveFnc_ = _CalcPtr->icasestrcompn(Buffer_, "MATSOLVE", 8);
  OptionFncs_ = SingleArgFncs_ &&
                   (_CalcPtr->icasestrcompn(Buffer_, "AVGMEAN", 7)        ||
                    _CalcPtr->icasestrcompn(Buffer_, "AVGMED", 6)         ||
                    _CalcPtr->icasestrcompn(Buffer_, "AVGMODE", 7)        ||
                    _CalcPtr->icasestrcompn(Buffer_, "SUM", 3)            ||
                    _CalcPtr->icasestrcompn(Buffer_, "PROD", 4)           ||
                    _CalcPtr->icasestrcompn(Buffer_, "STDDEV", 4)         ||
                    _CalcPtr->icasestrcompn(Buffer_, "MIN", 3)            ||
                    _CalcPtr->icasestrcompn(Buffer_, "MAX", 3)            ||
                    (_CalcPtr->icasestrcompn(Buffer_, "SET", 3) &&
                     !SetOpFncs_)                                         ||
                    _CalcPtr->icasestrcompn(Buffer_, "FRAC", 4)           ||
                    _CalcPtr->icasestrcompn(Buffer_, "ITEMPERM", 8)       ||
                    _CalcPtr->icasestrcompn(Buffer_, "ITEMCOMB", 8)       ||
                    _CalcPtr->icasestrcompn(Buffer_, "ITEMPERMREP", 11)   ||
                    _CalcPtr->icasestrcompn(Buffer_, "ITEMCOMBREP", 11));

  _FncCalls[_NumFncCalls] = new FunctionCall(this, Buffer_);

  if (_FncCalls[_NumFncCalls])
  {
    if (ItemFncs_)
      _FncCalls[_NumFncCalls]->SetNumParams(NumParams_ + 1);
    else
      _FncCalls[_NumFncCalls]->SetNumParams(NumParams_);

    for (x = 1; x < DelimArray_[0]; x++)
    {
      EndEval_ =
      (
        (x < 3 && IntFnc0_) ||
        (x < 3 && CalcFncs_) ||
        (x < 3 && SetOpFncs_) ||
        (x < 3 && GraphFnc_) ||
        (x < 4 && IntFnc2_) ||
        (x == 1 && FracFnc_) ||
        (x == 5 && FuncExtrFncs_) ||
        (x != 1 && ItemFncs_) ||
        (x != 1 && MakeSetFnc_) ||
        EvalFnc_ || ShowFnc_ || ShowSetFnc_ ||
        OptionFncs_ || MatSolveFnc_
      );

      _FncCalls[_NumFncCalls]->AddParameter(&Buffer_[DelimArray_[x]+1], !EndEval_, EndEval_);
    }
  }

  if (ItemFncs_ && _FncCalls[_NumFncCalls])
  {
    len = ::SafeStrLen(_Expression);
    int StrAssign_, StrLength_, Error_;
    int EqFound_ = _CalcPtr->FindAssignments(_Expression, _CalcPtr, len - 1, Error_, 0, StrAssign_, StrLength_, FALSE, ParseData_);
    int StdStreams_ = _CalcPtr->StdInput() && _CalcPtr->StdOutput();
    int ReturnAnswer_ = _CalcPtr->SessionOption() ||
                        _CalcPtr->NoPauseFileInput() || EqFound_;

    if ((_CalcPtr->InAsyncMode() || StdStreams_) && !ReturnAnswer_)
      _FncCalls[_NumFncCalls]->SetShowAnswer(FALSE);

    ChrString HasIndex_ = EqFound_ ? "1":"0";
    _FncCalls[_NumFncCalls]->AddParameter(HasIndex_.c_str(), !EndEval_, EndEval_);
  }

  if ((GraphFnc_ || ItemFncs_ || MatSolveFnc_) && _FncCalls[_NumFncCalls])
  {
    SetNoReturns(TRUE);

    if (GraphFnc_ &&
        ((_CalcPtr->InAsyncMode() || _CalcPtr->NoPauseFileInput()) ||
         (_CalcPtr->StdInput() && _CalcPtr->StdOutput())))
      _FncCalls[_NumFncCalls]->SetShowAnswer(FALSE);
  }

  _NumFncCalls++;
  _MemDel->DelayedDeleteCstr(OldExpr_, STOREMEM);
  _MemDel->DelayedDeleteCstr(Buffer_, STOREMEM);

  OldExpr_ = NULL;
  Buffer_ = NULL;
}

/*****************************************************************************/
void SubExpression::FindFunctionCalls()
{
  if (!_CalcPtr->MathLineValid())
    return;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->EnterLevel("FindFunctionCalls");
  #endif

  char* list = NULL;
  char* sublist = NULL;
  char* Original_ = ::NewString(_Expression);

  int i, x, y, z;
  int len = 0;
  int incr = 0;
  int fnclen = 0;
  int Valid_ = 1;
  int InQuote_ = 0;
  int NumFncs_ = 0;
  int IoState_ = 0;
  int ChkIter_ = 0;
  int* DelimArray_ = (int*)MemMatrix::Matrix().Callocate(sizeof(int) * CalculatorBase::DELIM_ARRAY_SIZE);

  bool FirstFind_ = false;
  bool ExecFound_ = false;
  bool GraphFound_ = false;
  bool LeftBrk_ = false;
  bool AllDone_ = false;
  bool BreakAll_ = false;
  bool DoHalt_ = false;
  bool fminsel_, fmaxsel_;
  bool deriv1sel_, deriv2sel_;
  bool cond_[5] = { false, false, false, false, false };

  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();
  bool PlotCompleted_ = IsPlotCompleted();

  incr = 1;
  list = _Expression;
  len = ::SafeStrLen(list);

  SetNoReturns(FALSE);
  _GlobalExecSwitch->ResetSwitchCheckData();
  _GlobalExecSwitch->SetGlobalSwitchProcessed(false);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  _FunctionSearchInProgress = TRUE;

  if (_FunctionValidityChkNeeded &&
      !_FunctionValidityChkDone)
    CheckIfValidExpression();

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    if (_CalcPtr->DbgPtr())
    {
      _CalcPtr->DbgPtr()->ShowStr(list, "list");
      _CalcPtr->DbgPtr()->ShowInt(len, "len");
      _CalcPtr->DbgPtr()->ShowInt(_ShortestName, "_ShortestName");
      _CalcPtr->DbgPtr()->ShowInt(_FunctionValidityChkNeeded,
                                  "_FunctionValidityChkNeeded");
      _CalcPtr->DbgPtr()->ShowInt(_FunctionValidityChkDone,
                                  "_FunctionValidityChkDone");
      _CalcPtr->DbgPtr()->ShowInt(MathLineConfirmedValid(),
                                  "MathLineConfirmedValid()");
    }
  #endif

  for (i = 0; i < len && !BreakAll_ && !ExecFound_; i++)
  {
    if ((len - i) < _ShortestName)
      break;

    if (!ExecFound_)
      _GlobalExecSwitch->ResetSwitchCheckDone();

    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (list[i] == '\"')
      InQuote_ = !InQuote_;

    if (!InQuote_ && isalpha(list[i]) && InRange('A', list[i], 'z'))
    {
      for (x = 0; x < _NumFncNames; x++)
      {
        ChkIter_ += incr;
        fnclen = ::SafeStrLen(_FunctionNames[x]);

        if (!_GlobalExecSwitch->SwitchCheckDone())
        {
          _GlobalExecSwitch->SetExprLineIndex(i);
          _GlobalExecSwitch->SetMathExprLine(list);
          ExecFound_ = _GlobalExecSwitch->CheckForSwitch(ExecFound_);

          if (ExecFound_)
          {
            #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
              if (_CalcPtr->DbgPtr())
                _CalcPtr->DbgPtr()->ShowMessage("ExecFound_: breaking\n");
            #endif

            break;
          }
        }

        if (!_GlobalGraphSwitch->SwitchCheckDone())
        {
          _GlobalGraphSwitch->SetExprLineIndex(i);
          _GlobalGraphSwitch->SetMathExprLine(list);
          GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

          if (incr == 1)
          {
            FirstFind_ = GraphFound_ && ChkIter_ == 1;
            ChkIter_ = incr = 0;
          }

          if (GraphFound_)
          {
            LeftBrk_ = _GlobalGraphSwitch->HasLeftBrk();
            _GlobalGraphSwitch->SetSwitchCmdIgnored(true);

            if (LeftBrk_)
              i = _GlobalGraphSwitch->LastSwitchStrIndex();
            else
              i = _GlobalGraphSwitch->PosShiftToNoSwitchStr(true);

            if (!LeftBrk_)
            {
              #if CALCLIB_DEBUG11a
                if (_CalcPtr->DbgPtr())
                  _CalcPtr->DbgPtr()->ShowMessage("!LeftBrk_: breaking\n");
              #endif

              break;
            }
          }
        }

        if ((len - i) < fnclen || toupper(_FunctionNames[x][0]) != toupper(list[i]))
          continue;

        if (CalculatorBase::icasestrcompn(list+i, _FunctionNames[x], fnclen) &&
            _CalcPtr->WholeWord(list, len, fnclen, i, CalculatorBase::FUNCTION_INDEX) &&
            _CalcPtr->FindFncDelim(list+i, ::SafeStrLen(list+i), &DelimArray_, CalculatorBase::DELIM_ARRAY_SIZE))
        {
          int SetOpFncs_ =
            (CalculatorBase::icasestrcompn(_FunctionNames[x], "SETUNI", fnclen) && fnclen == 6) ||
            (CalculatorBase::icasestrcompn(_FunctionNames[x], "SETINT", fnclen) && fnclen == 6) ||
            (CalculatorBase::icasestrcompn(_FunctionNames[x], "SETDIF", fnclen) && fnclen == 6) ||
            (CalculatorBase::icasestrcompn(_FunctionNames[x], "SETXDIF", fnclen) && fnclen == 7);

          int OptionFnc_ = ((CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMEAN", fnclen)     ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMED", fnclen)      ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMODE", fnclen)     ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "STDDEV", fnclen)      ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "SUM", fnclen)         ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "PROD", fnclen)        ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "MIN", fnclen)         ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "MAX", fnclen)         ||
                             (CalculatorBase::icasestrcompn(_FunctionNames[x], "SET", fnclen) &&
                              fnclen == 3 && !SetOpFncs_)                                            ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "FRAC", fnclen)        ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMPERM", fnclen)    ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMCOMB", fnclen)    ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMPERMREP", fnclen) ||
                             CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMCOMBREP", fnclen)) &&
                            DelimArray_[0] >= 3) ||
                           (CalculatorBase::icasestrcompn(_FunctionNames[x], "TOCMP2BIN", fnclen) &&
                            DelimArray_[0] == 3);

          int SingleArgFncs_ =
              (CalculatorBase::icasestrcompn(_FunctionNames[x], "SET", fnclen) && !SetOpFncs_) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "FRAC", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "SHOWSET", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMPERM", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMCOMB", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMPERMREP", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "ITEMCOMBREP", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "EVAL", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "SHOW", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "FROMHEX", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "FROMOCT", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "FROMBIN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "FROMCMP2BIN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "TOHEX", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "TOOCT", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "TOBIN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "TOCMP2BIN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMEAN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMED", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "AVGMODE", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "STDDEV", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "SUM", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "MIN", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "MAX", fnclen) ||
              CalculatorBase::icasestrcompn(_FunctionNames[x], "PROD", fnclen);

          int GraphFnc_ =
              CalculatorBase::icasestrcompn(_FunctionNames[x], "GRAPH", fnclen);

          fminsel_ = CalculatorBase::icasestrcompn(_FunctionNames[x], "FMIN", fnclen);
          fmaxsel_ = CalculatorBase::icasestrcompn(_FunctionNames[x], "FMAX", fnclen);
          int ExtrFncs_ = fminsel_ || fmaxsel_;

          deriv1sel_ = CalculatorBase::icasestrcompn(_FunctionNames[x], "DERIV", fnclen);
          deriv2sel_ = CalculatorBase::icasestrcompn(_FunctionNames[x], "DERIV2", fnclen);
          int DerivFncs_ = deriv1sel_ || deriv2sel_;

          int IntegFnc_ =
              CalculatorBase::icasestrcompn(_FunctionNames[x], "INTEG", fnclen);

          int SolveFnc_ =
              CalculatorBase::icasestrcompn(_FunctionNames[x], "SOLVE", fnclen);

          int IntersectFnc_ =
              CalculatorBase::icasestrcompn(_FunctionNames[x], "INTERSECT", fnclen);

          int CalcFncs_ = ExtrFncs_ || DerivFncs_ ||
                          IntegFnc_ || SolveFnc_ || IntersectFnc_;
          int SingleArgValid_ = SingleArgFncs_ && DelimArray_[0] == 2;

          #if CALCLIB_DEBUG11a
            if (_CalcPtr->DbgPtr())
            {
              _CalcPtr->DbgPtr()->ShowInt(GraphFound_, "GraphFound_");
              _CalcPtr->DbgPtr()->ShowInt(LeftBrk_, "LeftBrk_");
              _CalcPtr->DbgPtr()->ShowInt(CalcFncs_, "CalcFncs_");
              _CalcPtr->DbgPtr()->ShowInt(GraphFnc_, "GraphFnc_");
              _CalcPtr->DbgPtr()->ShowInt(_GraphCmdProcessed, "_GraphCmdProcessed");
              _CalcPtr->DbgPtr()->ShowMessage("/*****************************************************************************/\n");
            }
          #endif

          if (GraphFound_)
          {
            if (_FunctionValidityChkNeeded &&
                !_FunctionValidityChkDone)
              CheckIfValidExpression();

            if (_FunctionValidityChkDone)
              GraphFound_ = MathLineConfirmedValid();

            #if CALCLIB_DEBUG11a
              _CalcPtr->DbgPtr()->EnterLevel("if (GraphFound_) ...");
                _CalcPtr->DbgPtr()->ShowInt(_FunctionValidityChkNeeded,
                                            "_FunctionValidityChkNeeded");
                _CalcPtr->DbgPtr()->ShowInt(_FunctionValidityChkDone,
                                            "_FunctionValidityChkDone");
                _CalcPtr->DbgPtr()->ShowInt(GraphFound_, "GraphFound_");
              _CalcPtr->DbgPtr()->LeaveLevel();
            #endif
          }

          if (GraphFound_ && !LeftBrk_ && CalcFncs_)
          {
            #if CALCLIB_DEBUG11a
              if (_CalcPtr->DbgPtr())
              {
                _CalcPtr->DbgPtr()->ShowMessage("GraphFound_ && !LeftBrk_ && CalcFncs_\n");
                _CalcPtr->DbgPtr()->ShowInt(FirstFind_, "FirstFind_");
                _CalcPtr->DbgPtr()->ShowInt(_GraphCmdProcessed, "_GraphCmdProcessed");
              }
            #endif

            if (FirstFind_ && !_GraphCmdProcessed)
            {
              _CalcPtr->SetPlotGraph(true, 1, true, 1, 1);
              CalcPlot_ = CalculatorBase::GetGraphPlotter();

              if (CalcPlot_)
              {
                CalcPlot_->SetExprString(list);
                CalcPlot_->SetGraphExprStart(_GlobalGraphSwitch->GetSwitchStart());
                CalcPlot_->SetGraphExprExtension(_GlobalGraphSwitch->GetSwitchExt());
                CalcPlot_->SetGraphLeftBrkStart(NULL);
                CalcPlot_->SetGraphKeyWordMult(_GlobalGraphSwitch->SwitchWordMultiples());
                _GlobalGraphSwitch->SetSwitchCmdIgnored(false);
                _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
              }
              else
              {
                _GlobalGraphSwitch->SetSwitchCmdIgnored(true);
                _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
                strcpy(_Expression, _GlobalGraphSwitch->GetSwitchExt());
              }

              GraphFound_ = false;

              if (ExtrFncs_)
                CalculatorBase::SetGraphType(Mcalc_GraphType::EXTREMA, (fminsel_ ? Mcalc_GraphType::MIN_EXTREMA:
                                                                        fmaxsel_ ? Mcalc_GraphType::MAX_EXTREMA:0));
              else if (DerivFncs_)
                CalculatorBase::SetGraphType(Mcalc_GraphType::DERIVATIVE, (deriv1sel_ ? Mcalc_GraphType::FIRST_DERIV:
                                                                           deriv2sel_ ? Mcalc_GraphType::SECOND_DERIV:0));
              else if (IntegFnc_)
                CalculatorBase::SetGraphType(Mcalc_GraphType::INTEGRAL);
              else if (SolveFnc_)
                CalculatorBase::SetGraphType(Mcalc_GraphType::ROOTSOLVE);
              else if (IntersectFnc_)
                CalculatorBase::SetGraphType(Mcalc_GraphType::INTERSECT1);

              // Executing graph plotting delay loop in the case where GRAPH function is detected
              if (_CalcPtr->InAsyncMode() && CalcPlot_)
              {
                #if CALCLIB_DEBUG11a
                  if (_CalcPtr->DbgPtr())
                  {
                    _CalcPtr->DbgPtr()->ShowMessage("UpdateGraphOperationsFile(...)\n");
                    _CalcPtr->Exec_ShowQuitGraphFlags();
                  }
                #endif

                SetGraphCmdWasFound(GraphCmdFound());

                if (_CalcPtr->Exec_ResetGraphCond() ||
                    _CalcPtr->Exec_ResetGraphIsDone())
                {
                  _CalcPtr->Exec_SetQuitGraph(true);
                  _CalcPtr->Exec_SetBatchFileDonePending(true);
                }

                if (!_CalcPtr->QuitGraph())
                {
                  cond_[0] = _CalcPtr->BatchFileEndedSignalPending();
                  cond_[1] = _CalcPtr->BatchFileEndedSignalSent();
                  cond_[2] = _CalcPtr->BatchFileEndedSignalAcked();
                  cond_[3] = _CalcPtr->ClientAckedDoneToGraphOutput();
                  cond_[4] = _CalcPtr->ResponseWasCompleted();

                  _CalcPtr->SetBatchFileEndedSignalPending(false);
                  _CalcPtr->SetBatchFileEndedSignalSent(false);
                  _CalcPtr->SetBatchFileEndedSignalAcked(false);
                  _CalcPtr->SetClientAckedDoneToGraphOutput(false);
                  _CalcPtr->SetResponseWasCompleted(false);

                  _CalcPtr->SetGraphOperFileSent(false);
                  _CalcPtr->SetGraphOperFileUpdateDone(0, 0);
                  _CalcPtr->UpdateGraphOperationsFile(true, &AllDone_, &BreakAll_, &DoHalt_);
                }

                if (_CalcPtr->QuitGraph())
                {
                  #if CALCLIB_DEBUG11a
                    if (_CalcPtr->DbgPtr())
                      _CalcPtr->DbgPtr()->EnterLevel("FindFunctionCalls:-QuitGraph()");
                  #endif

                  _CalcPtr->SetBatchFileEndedSignalPending(cond_[0]);
                  _CalcPtr->SetBatchFileEndedSignalSent(cond_[1]);
                  _CalcPtr->SetBatchFileEndedSignalAcked(cond_[2]);

                  _CalcPtr->SetClientAckedDoneToGraphOutput(cond_[3]);
                  _CalcPtr->SetResponseWasCompleted(cond_[4]);
                  _CalcPtr->SetGraphOpStage(0);

                  ResetCalcStateVars();
                  _CalcPtr->SetPlotGraph(true, 0, true, 0);
                  SetExpression("");

                  BreakAll_ = _CalcPtr->QuitGraph();
                  GraphFound_ = false;
                  SetGraphCmdWasFound(false);
                  CalcPlot_ = NULL;

                  #if CALCLIB_DEBUG11a
                    if (_CalcPtr->DbgPtr())
                      _CalcPtr->DbgPtr()->LeaveLevel();
                  #endif
                }
                else
                {
                  SetGraphCmdWasFound(GraphCmdFound());
                  _CalcPtr->SetGraphOutputWasSent(FALSE);
                  _CalcPtr->SetGraphPlotShown(false);
                  _CalcPtr->SetGraphOperFileResetDone(0, 0);
                }

                if (BreakAll_ || DoHalt_)
                  break;
              }
              else
              {
                #if CALCLIB_DEBUG11a
                  if (_CalcPtr->DbgPtr())
                  {
                    _CalcPtr->DbgPtr()->ShowMessage("UpdateGraphOperationsFile NOT called\n");
                    _CalcPtr->DbgPtr()->ShowInt(_CalcPtr->InAsyncMode(), "InAsyncMode()");
                    _CalcPtr->DbgPtr()->ShowInt(CalcPlot_ != NULL, "CalcPlot_");
                  }
                #endif

                if (!CalcPlot_)
                  SetGraphCmdWasFound(false);
                else if (!_CalcPtr->InAsyncMode())
                  SetGraphCmdWasFound(GraphCmdFound());
              }
            }
            else
            {
              GraphFound_ = false;
              SetGraphCmdWasFound(false);
              _GlobalGraphSwitch->SetSwitchCmdIgnored(true);
              _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
              strcpy(_Expression, _GlobalGraphSwitch->GetSwitchExt());

              #if CALCLIB_DEBUG11a
                if (_CalcPtr->DbgPtr())
                  _CalcPtr->DbgPtr()->ShowMessage("GraphFound_ == false\n");
              #endif
            }
          }
          else if (GraphFound_ && LeftBrk_ && GraphFnc_)
          {
            #if CALCLIB_DEBUG11a
              if (_CalcPtr->DbgPtr())
              {
                _CalcPtr->DbgPtr()->ShowMessage("GraphFound_ && LeftBrk_ && GraphFnc_\n");
                _CalcPtr->DbgPtr()->ShowInt(FirstFind_, "FirstFind_");
                _CalcPtr->DbgPtr()->ShowInt(_GraphCmdProcessed, "_GraphCmdProcessed");
              }
            #endif

            if (FirstFind_ && !_GraphCmdProcessed)
            {
              strcpy(_Expression, _GlobalGraphSwitch->GetSwitchStart());

              _CalcPtr->SetPlotGraph(true, 1, true, 1, 1);
              CalcPlot_ = CalculatorBase::GetGraphPlotter();

              if (CalcPlot_)
              {
                CalcPlot_->SetExprString(list);
                CalcPlot_->SetGraphExprStart(_GlobalGraphSwitch->GetSwitchStart());
                CalcPlot_->SetGraphExprExtension(NULL);
                CalcPlot_->SetGraphLeftBrkStart(_GlobalGraphSwitch->GetLeftBrkStart());
                CalcPlot_->SetGraphKeyWordMult(_GlobalGraphSwitch->SwitchWordMultiples());
                _GlobalGraphSwitch->SetSwitchCmdIgnored(false);
                _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
              }
              else
              {
                _GlobalGraphSwitch->SetSwitchCmdIgnored(true);
                _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
                strcpy(_Expression, _GlobalGraphSwitch->GetPostSwitchStart());
              }

              GraphFound_ = false;
              CalculatorBase::SetGraphType(Mcalc_GraphType::FUNCTION);

              // (Handled by GUI) code commented out
              // Executing graph plotting delay loop in the case where GRAPH function is detected
              if (_CalcPtr->InAsyncMode() && CalcPlot_)
              {
                #if CALCLIB_DEBUG11a
                  if (_CalcPtr->DbgPtr())
                  {
                    _CalcPtr->DbgPtr()->ShowMessage("UpdateGraphOperationsFile(...)\n");
                    _CalcPtr->Exec_ShowQuitGraphFlags();
                  }
                #endif

                SetGraphCmdWasFound(GraphCmdFound());

                if (_CalcPtr->Exec_ResetGraphCond() ||
                    _CalcPtr->Exec_ResetGraphIsDone())
                {
                  _CalcPtr->Exec_SetQuitGraph(true);
                  _CalcPtr->Exec_SetBatchFileDonePending(true);
                }

                if (!_CalcPtr->QuitGraph())
                {
                  cond_[0] = _CalcPtr->BatchFileEndedSignalPending();
                  cond_[1] = _CalcPtr->BatchFileEndedSignalSent();
                  cond_[2] = _CalcPtr->BatchFileEndedSignalAcked();
                  cond_[3] = _CalcPtr->ClientAckedDoneToGraphOutput();
                  cond_[4] = _CalcPtr->ResponseWasCompleted();

                  _CalcPtr->SetBatchFileEndedSignalPending(false);
                  _CalcPtr->SetBatchFileEndedSignalSent(false);
                  _CalcPtr->SetBatchFileEndedSignalAcked(false);
                  _CalcPtr->SetClientAckedDoneToGraphOutput(false);
                  _CalcPtr->SetResponseWasCompleted(false);

                  _CalcPtr->SetGraphOperFileSent(false);
                  _CalcPtr->SetGraphOperFileUpdateDone(0, 0);
                  _CalcPtr->UpdateGraphOperationsFile(true, &AllDone_, &BreakAll_, &DoHalt_);
                }

                if (_CalcPtr->QuitGraph())
                {
                  #if CALCLIB_DEBUG11a
                    if (_CalcPtr->DbgPtr())
                      _CalcPtr->DbgPtr()->EnterLevel("FindFunctionCalls:-QuitGraph()");
                  #endif

                  _CalcPtr->SetBatchFileEndedSignalPending(cond_[0]);
                  _CalcPtr->SetBatchFileEndedSignalSent(cond_[1]);
                  _CalcPtr->SetBatchFileEndedSignalAcked(cond_[2]);

                  _CalcPtr->SetClientAckedDoneToGraphOutput(cond_[3]);
                  _CalcPtr->SetResponseWasCompleted(cond_[4]);
                  _CalcPtr->SetGraphOpStage(0);

                  ResetCalcStateVars();
                  _CalcPtr->SetPlotGraph(true, 0, true, 0);
                  SetExpression("");

                  BreakAll_ = _CalcPtr->QuitGraph();
                  GraphFound_ = false;
                  SetGraphCmdWasFound(false);
                  CalcPlot_ = NULL;

                  #if CALCLIB_DEBUG11a
                    if (_CalcPtr->DbgPtr())
                      _CalcPtr->DbgPtr()->LeaveLevel();
                  #endif
                }
                else
                {
                  SetGraphCmdWasFound(GraphCmdFound());
                  _CalcPtr->SetGraphOutputWasSent(FALSE);
                  _CalcPtr->SetGraphPlotShown(false);
                  _CalcPtr->SetGraphOperFileResetDone(0, 0);
                }

                if (BreakAll_ || DoHalt_)
                  break;
              }
              else
              {
                #if CALCLIB_DEBUG11a
                  if (_CalcPtr->DbgPtr())
                  {
                    _CalcPtr->DbgPtr()->ShowMessage("UpdateGraphOperationsFile NOT called\n");
                    _CalcPtr->DbgPtr()->ShowInt(_CalcPtr->InAsyncMode(), "InAsyncMode()");
                    _CalcPtr->DbgPtr()->ShowInt(CalcPlot_ != NULL, "CalcPlot_");
                  }
                #endif

                if (!CalcPlot_)
                  SetGraphCmdWasFound(false);
                else if (!_CalcPtr->InAsyncMode())
                  SetGraphCmdWasFound(GraphCmdFound());
              }
            }
            else
            {
              GraphFound_ = false;
              SetGraphCmdWasFound(false);
              _GlobalGraphSwitch->SetSwitchCmdIgnored(true);
              _GlobalGraphSwitch->SetGlobalSwitchProcessed(true);
              strcpy(_Expression, _GlobalGraphSwitch->GetPostSwitchStart());

              #if CALCLIB_DEBUG11a
                if (_CalcPtr->DbgPtr())
                  _CalcPtr->DbgPtr()->ShowMessage("GraphFound_ == false\n");
              #endif
            }
          }
          else if (!GraphFound_ && CalcFncs_ && IsGraphOp())
          {
            if (ExtrFncs_)
              CalculatorBase::AddGraphType(Mcalc_GraphType::EXTREMA, (fminsel_ ? Mcalc_GraphType::MIN_EXTREMA:
                                                                      fmaxsel_ ? Mcalc_GraphType::MAX_EXTREMA:0));
            else if (DerivFncs_)
              CalculatorBase::AddGraphType(Mcalc_GraphType::DERIVATIVE, (deriv1sel_ ? Mcalc_GraphType::FIRST_DERIV:
                                                                         deriv2sel_ ? Mcalc_GraphType::SECOND_DERIV:0));
            else if (IntegFnc_)
              CalculatorBase::AddGraphType(Mcalc_GraphType::INTEGRAL);
            else if (SolveFnc_)
              CalculatorBase::AddGraphType(Mcalc_GraphType::ROOTSOLVE);
            else if (IntersectFnc_)
              CalculatorBase::AddGraphType(Mcalc_GraphType::INTERSECT1);
          }
          else if (PlotCompleted_)
            GraphFound_ = false;

          if (SingleArgFncs_ && !SingleArgValid_ && !OptionFnc_)
          {
            _CalcPtr->DisplayErrorMessage(_CalcPtr->GetOutputFile(false, false, !_CalcPtr->NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_NUMARGS,
                                          ERRMSG_INVALID_NUMARGS, _FunctionNames[x]);
            _CalcPtr->CloseGuiOutputFile();

            _MemDel->DelayedDeleteCstr((char*)DelimArray_, STOREMEM);
            return;
          }
          else if (((!SingleArgValid_ && DelimArray_[0] >= 3) ||
                    (SetOpFncs_ && DelimArray_[0] == 3) ||
                    (OptionFnc_ && SingleArgFncs_)) || SingleArgValid_)
          {
            NumFncs_++;
            sublist = list + i;
            AddFunctionCall(sublist, DelimArray_);
            list = _Expression;
            len = strlen(sublist);

            if (len && IsSubstTokenStr(sublist, len))
              i += len - 1;

            len = ::SafeStrLen(list);
            break;
          }
        }
      } // end for (inner loop)
    }
  } // end for (outer loop)

  if (BreakAll_ || DoHalt_)
  {
    _MemDel->DelayedDeleteCstr(Original_, STOREMEM);
    _MemDel->DelayedDeleteCstr((char*)DelimArray_, STOREMEM);
    _GlobalExecSwitch->SetGlobalSwitchProcessed(ExecFound_);
    SetExecCmdWasFound(ExecCmdFound());

    if (_CalcPtr)
      _CalcPtr->ReceiveBreakOrQuit(IoState_);

    #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
      if (_CalcPtr->DbgPtr())
      {
        _CalcPtr->DbgPtr()->ShowMessage("if (BreakAll_ || DoHalt_) ...\n");
        _CalcPtr->DbgPtr()->LeaveLevel();
      }
    #endif

    return;
  }

  if (DelimArray_[0] && NumFncs_ == 1 && Original_ && !ExecFound_)
  {
    len = strlen(Original_);
    for (z = strlen(Original_) - 1; z && isspace(Original_[z]); z--);
    for (i = z; i && Original_[i] != '='; i--);
    for (;i < len && isspace(Original_[i]); i++);
    for (y = i; y < len && !CalculatorBase::isleftbracket(Original_[y]); y++);
    len = y - i;
    x = DelimArray_[0];

    if (DelimArray_[x] == z &&
        DelimArray_[1] == y &&
        DelimArray_[1] - len == i)
    {
      _SingleFncCall = TRUE;
      for (;y && isspace(Original_[y-1]); y--, len--);
      _ShowFunction = CalculatorBase::icasestrcompn(&Original_[i], "SHOW", len);
      _ShowSetFunction = CalculatorBase::icasestrcompn(&Original_[i], "SHOWSET", len);
    }
    else
    {
      _ShowFunction =
      _ShowSetFunction =
      _SingleFncCall = FALSE;
    }
  }
  else
  {
    _ShowFunction =
    _ShowSetFunction =
    _SingleFncCall = FALSE;
  }

  _MemDel->DelayedDeleteCstr(Original_, STOREMEM);
  _MemDel->DelayedDeleteCstr((char*)DelimArray_, STOREMEM);
  _GlobalExecSwitch->SetGlobalSwitchProcessed(ExecFound_);
  SetExecCmdWasFound(ExecCmdFound());
  _FunctionSearchInProgress = FALSE;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    if (_CalcPtr->DbgPtr())
    {
      _CalcPtr->DbgPtr()->ShowMessage("FindFunctionCalls() -- Normal Exit\n");
      _CalcPtr->DbgPtr()->LeaveLevel();
    }
  #endif
}

/****************************************************************************/
char* SubExpression::SubExpressionTag(int FncIndex_, char* SrcExpr_, const char* AnswerStr_)
{
  ChrString NumStr_;
  NumStr_.IntToStr(FncIndex_);
  ChrString Token_("#");
  Token_ += NumStr_;
  Token_ += ChrString("s");

  const char* cstr_ = Token_.c_str();
  char* start_ = (SrcExpr_ && cstr_) ? strstr(SrcExpr_, cstr_):NULL;
  *start_ = 0;
  char* OldExpr_ = SrcExpr_;
  size_t len = ::SafeStrLen(SrcExpr_) + ::SafeStrLen(AnswerStr_) + ::SafeStrLen(&start_[::SafeStrLen(cstr_)]);
  SrcExpr_ = (char*)MemMatrix::Matrix().Callocate(len + 1);

  ::SafeStrCpy(SrcExpr_, OldExpr_);
  ::SafeStrCat(SrcExpr_, AnswerStr_);
  ::SafeStrCat(SrcExpr_, &start_[::SafeStrLen(cstr_)]);

  _MemDel->DelayedDeleteCstr(OldExpr_, STOREMEM);

  return SrcExpr_;
}

/****************************************************************************/
void SubExpression::SubstFncAnswer(int FncIndex_)
{
  if (_FncCalls[FncIndex_] && _FncCalls[FncIndex_]->OutputMode() != CalculatorBase::FLOATINGPOINT_MODE)
  {
    if (_ShowFunction && _Level == 0)
    {
      ChrString TempStr_ = ChrString("\"") +
                           ChrString(_FncCalls[FncIndex_]->GetLiteralAnswer()) +
                           ChrString("\"");
      _Expression = SubExpressionTag(FncIndex_, _Expression, TempStr_.c_str());
    }
    else if (_ShowSetFunction && _Level == 0)
    {
      int IsSet_ = 0;
      ChrString NewStr_ = ChrString(_FncCalls[FncIndex_]->GetLiteralAnswer());
      NewStr_.RemoveChar(" \t\n\r");
      Subscript x = NewStr_.strlen();
      ChrString TempStr_ = (NewStr_[0] == '{') ? NewStr_(1):NewStr_(0);

      if (NewStr_[0] == '{' && x > 2 && TempStr_[x-2] == '}')
      {
        TempStr_[x-2] = 0;
        TempStr_ = ChrString("{ ") + TempStr_ + ChrString(" }");
        IsSet_ = NewStr_[0] == '{';
      }

      if (!CalculatorBase::InSetNotation(TempStr_.c_str()))
      {
        TempStr_ = ChrString("{ ") +
                   ChrString(_FncCalls[FncIndex_]->GetLiteralAnswer()) +
                   ChrString(" }");

        if (CalculatorBase::InSetNotation(TempStr_.c_str()))
        {
          TempStr_ = ChrString("\"") + TempStr_ + ChrString("\"");
          _Expression = SubExpressionTag(FncIndex_, _Expression, TempStr_.c_str());
        }
        else
        {
          TempStr_ = ChrString(ERRMSG_NOT_A_SET);
          _Expression = SubExpressionTag(FncIndex_, _Expression, TempStr_.c_str());
        }
      }
      else if (IsSet_)
      {
        TempStr_ = ChrString("\"") + TempStr_ + ChrString("\"");
        _Expression = SubExpressionTag(FncIndex_, _Expression, TempStr_.c_str());
      }
      else
      {
        TempStr_ = ChrString(ERRMSG_NOT_A_SET);
        _Expression = SubExpressionTag(FncIndex_, _Expression, TempStr_.c_str());
      }
    }
    else
      _Expression = SubExpressionTag(FncIndex_, _Expression, _FncCalls[FncIndex_]->GetLiteralAnswer());
  }
  else if (_FncCalls[FncIndex_])
    _Expression = SubExpressionTag(FncIndex_, _Expression, _FncCalls[FncIndex_]->GetAnswer());
}

/****************************************************************************/
void SubExpression::SubstFncOriginal(int FncIndex_)
{
  if (_FncCalls[FncIndex_])
    _OriginalStr = SubExpressionTag(FncIndex_, _OriginalStr, _FncCalls[FncIndex_]->GetOriginal());
}

/****************************************************************************/
bool SubExpression::NotInGraphOp() const
{
  CalculatorBase* CalcPtr_ = _CalcPtr ? _CalcPtr:_PrevCalc;

  bool NotInGraphOp_ = !_GraphCmdProcessed ||
                       (CalcPtr_ &&
                        (!CalcPtr_->GraphOperation() ||
                         (!CalcPtr_->PlottingGraph() &&
                          CalcPtr_->PlottingDone() &&
                          CalcPtr_->GraphCompleted())));
  return NotInGraphOp_;
}

/****************************************************************************/
bool SubExpression::NotGraphOp() const
{
  bool NotGraphOp_ = !CalculatorBase::GraphOperation() ||
                     !_GlobalGraphSwitch ||
                     (!_GraphCmdProcessed &&
                      !_GlobalGraphSwitch->SwitchCmdFound() &&
                      !_GlobalGraphSwitch->SwitchCmdIgnored());
  return NotGraphOp_;
}

/****************************************************************************/
bool SubExpression::InGraphOp() const
{
  CalculatorBase* CalcPtr_ = _CalcPtr ? _CalcPtr:_PrevCalc;

  bool InGraphOp_ = _GraphCmdProcessed &&
                    (CalcPtr_ &&
                     CalcPtr_->GraphOperation() &&
                     CalcPtr_->PlottingGraph() &&
                     !CalcPtr_->PlottingDone() &&
                     !CalcPtr_->GraphCompleted());
  return InGraphOp_;
}

/****************************************************************************/
bool SubExpression::IsGraphOp() const
{
  bool GraphOp_ = GraphCmdFound() &&
                  CalculatorBase::GraphOperation();
  return GraphOp_;
}

/****************************************************************************/
bool SubExpression::ExecCmdFound() const
{
  bool ExecFound_ = _ExecCmdProcessed && _GlobalExecSwitch &&
                    _GlobalExecSwitch->SwitchCmdFound() &&
                    !_GlobalExecSwitch->SwitchCmdIgnored();
  return ExecFound_;
}

/****************************************************************************/
bool SubExpression::ExecCmdWasFound() const
{
  return _ExecCmdWasFound;
}

/****************************************************************************/
void SubExpression::SetExecCmdWasFound(bool flag_)
{
  _ExecCmdWasFound = flag_;
}

/****************************************************************************/
bool SubExpression::GraphCmdFound() const
{
  bool GraphFound_ = _GraphCmdProcessed && _GlobalGraphSwitch &&
                     _GlobalGraphSwitch->SwitchCmdFound() &&
                     !_GlobalGraphSwitch->SwitchCmdIgnored();
  return GraphFound_;
}

/****************************************************************************/
bool SubExpression::GraphCmdWasFound() const
{
  return _GraphCmdWasFound;
}

/****************************************************************************/
void SubExpression::SetGraphCmdWasFound(bool flag_)
{
  _GraphCmdWasFound = flag_;
}

/****************************************************************************/
bool SubExpression::IsPlotCompleted() const
{
  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();
  CalculatorBase* CalcPtr_ = _CalcPtr ? _CalcPtr:_PrevCalc;

  bool HasPlotterCond_ =
    CalcPtr_ && CalcPlot_ &&
    CalcPtr_->GraphOperation() && !CalcPtr_->DoPlotGraph() &&
    !CalcPtr_->PlottingGraph() && CalcPtr_->PlottingDone() &&
    CalcPtr_->GraphCompleted();
  bool NoPlotterCond_ = !CalcPlot_ && !CalcPtr_->GraphOperation();

  return (HasPlotterCond_ || NoPlotterCond_);
}

/****************************************************************************/
void SubExpression::ResetCalcStateVars()
{
  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->EnterLevel("ResetCalcStateVars");
  #endif

  CalculatorBase* CalcPtr_ = _CalcPtr ? _CalcPtr:_PrevCalc;

  int ResetOps_ = 0;
  int OpsMask_ = (1|2);

  bool PlotCompleted_ = IsPlotCompleted();
  bool BatchSigSent_ = CalcPtr_->BatchFileEndedSignalSent() ||
                       CalcPtr_->BatchFileEndedSignalAcked();

  if (_GraphCmdProcessed ||
      !_GlobalGraphSwitch->SearchResetDone())
    ResetGraphVars();

  if (!CalcPtr_->StateVarsResetDone())
    CalcPtr_->ResetStateVars();

  #if CALCLIB_DEBUG11a
    _CalcPtr->DbgPtr()->ShowInt(CalcPtr_->InAsyncMode(), "InAsyncMode()");
    _CalcPtr->DbgPtr()->ShowInt(GraphCmdWasFound(), "GraphCmdWasFound()");
    _CalcPtr->DbgPtr()->ShowInt(PlotCompleted_, "IsPlotCompleted()");
    _CalcPtr->DbgPtr()->ShowInt(CalcPtr_->QuitGraph(), "QuitGraph()");
  #endif

  if (CalcPtr_->InAsyncMode() && GraphCmdWasFound() &&
      (PlotCompleted_ || CalcPtr_->QuitGraph()))
  {
    #if CALCLIB_DEBUG11a
      _CalcPtr->DbgPtr()->ShowMessage("ResetGraphOperationsFile(false);\n");
      _CalcPtr->DbgPtr()->ShowMessage("ResetGraphProgressFile(100, false);\n");
      _CalcPtr->DbgPtr()->ShowInt(CalcPtr_->Exec_ResetGraphIsDone(), "ResetGraphIsDone()");
    #endif

    if (BatchSigSent_ || !CalcPtr_->ReCheckEndBatchSignal(true, &ResetOps_))
    {
      if ((ResetOps_ & 1) == 0)
      {
        CalcPtr_->ResetGraphOperationsFile(false, true);

        if ((CalcPtr_->InAllGraphsFile() &&
             CalcPtr_->GraphOperFileResetDone(CalculatorBase::BOTHSET)) ||
            (!CalcPtr_->InAllGraphsFile() &&
             CalcPtr_->GraphOperFileResetDone(1)))
          ResetOps_ |= 1;
      }

      if ((ResetOps_ & 2) == 0)
      {
        CalcPtr_->ResetGraphProgressFile(100, false, true);

        if (CalcPtr_->GraphProgFileResetPending() || _CalcPtr->QuitGraph())
          ResetOps_ |= 2;

        if (_CalcPtr->QuitGraph() && _CalcPtr->Exec_BatchFileDonePending())
        {
          CalcPtr_->ResetGraphOperationsFile(false, true);
          ResetOps_ |= 1;
        }
      }

      BatchSigSent_ = CalcPtr_->BatchFileEndedSignalSent() ||
                      CalcPtr_->BatchFileEndedSignalAcked();

      if ((ResetOps_ & OpsMask_) == OpsMask_ &&
          (BatchSigSent_ || !CalcPtr_->InAllGraphsFile()))
      {
        SetGraphCmdWasFound(false);

        if (BatchSigSent_)
        {
          CalcPtr_->SetInAllGraphsFile(false);
          CalcPtr_->ResetGraphOpOptions();
          CalcPtr_->SetGraphOpStage(0);
        }
      }
    }
    else if (!BatchSigSent_ && (ResetOps_ & OpsMask_) == OpsMask_)
    {
      SetGraphCmdWasFound(false);
      CalcPtr_->SetInAllGraphsFile(false);
      CalcPtr_->ResetGraphOpOptions();
      CalcPtr_->SetGraphOpStage(0);
    }
  }

  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void SubExpression::ResetGraphVars()
{
  _GlobalGraphSwitch->SetSwitchCmdIgnored(false);
  _GlobalGraphSwitch->SetSwitchCmdFound(false);
  _GlobalGraphSwitch->SetGlobalSwitchProcessed(false);
}

/****************************************************************************/
const char* SubExpression::GetExprToReplace() const
{
  bool GraphOp_ = IsGraphOp();
  return (GraphOp_ ? _GlobalGraphSwitch->GetMathExprLine():NULL);
}

/****************************************************************************/
const char* SubExpression::GetExprToGraph() const
{
  bool PlotGraph_ = CalculatorBase::DoPlotGraph();
  bool PlotCompleted_ = IsPlotCompleted();
  bool GraphOp_ = IsGraphOp();

  const char* ExprStr_ = NULL;

  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();

  ExprStr_ = (GraphOp_ && CalcPlot_ && PlotGraph_ && !PlotCompleted_) ?
                 (CalcPlot_->HasLeftBrk() ? NULL:
                                            CalcPlot_->GraphExprExtension()):
                 _Expression;

  return ((ExprStr_ && ExprStr_ != _Expression) ? ExprStr_:NULL);
}

/****************************************************************************/
void SubExpression::StartGraphPlotting()
{
  ExprStringStack* StrStack_ = NULL;
  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();
  const char* ExprToGraph_ = GetExprToGraph();

  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->EnterLevel("StartGraphPlotting");
  #endif

  if (!_GraphPlotter && ExprToGraph_ && _CalcPtr &&
      (CalcPlot_ && !CalcPlot_->HasNextExpression()))
  {
    if (!_GpExprStack)
    {
      _GpExprStack = new ExpressionGraphStack(this);

      // Create a new ExprStringStack object to be owned by the
      // _GpExprStack object. Future software versions that could include
      // multiple Global calculator switches will have a ExprStringStack
      // object shared among multiple Global calculator switch objects.
      //   Use: CalculatorBase::GiveStringStack()      instead of
      //        CalculatorBase::MakeStringStack(bool)
      StrStack_ = _CalcPtr->MakeStringStack();
    }

    if (_GpExprStack)
    {
      // ExprStringStack object passed to _GpExprStack is owned by the
      // _GpExprStack object and will be erased upon object destruction
      // For a shared ExprStringStack object used by _GpExprStack object:
      //   Use: SetStringStack(StrStack_, false);
      if (StrStack_)
        _GpExprStack->SetStringStack(StrStack_, true);

      _GpExprStack->SetGraphPlotter(CalcPlot_);
      _GpExprStack->PushGraphExpression();

      // Pause Calc Polling
      #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
        if (StrStack_ && _CalcPtr->SuspendPolling())
        {
          _CalcPtr->PauseCalcPolling();
          _CalcPtr->SetSuspendPolling(false);
          _CalcPtr->SetResumePolling(true);
        }
      #endif
    }
  }

  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void SubExpression::EndGraphPlotting(bool Destruct_)
{
  CalculatorBase* CalcPtr_ = (!_CalcPtr && _PrevCalc) ? _PrevCalc:_CalcPtr;
  bool PlotCompleted_ = IsPlotCompleted();
  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();
  bool HasAnyExpr_ = CalcPlot_ ? CalcPlot_->HasAnyExpr():false;
  bool BatchSigSent_ = false;

  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->EnterLevel("EndGraphPlotting");
  #endif

  if (_GpExprStack && HasAnyExpr_ &&
      _GraphPlotter && _GraphPlotter->HasNextExpression())
  {
    _GpExprStack->SetGraphPlotter(CalcPlot_);

    if (_CalcPtr || (Destruct_ && _PrevCalc))
    {
      _GpExprStack->SetCalculator(CalcPtr_);
      _GpExprStack->PopGraphExpression();

      if (Destruct_)
      {
        // Destroy ExprStringStack object here, otherwise null pointer error
        // occurs if graph plotter object removed when _GpExprStack is being
        // deleted in destructor method.
        delete _GpExprStack;
        _GpExprStack = NULL;
      }
    }
  }
  else if (NotGraphOp() || PlotCompleted_)
  {
    if (!_CalcPtr->QuitGraph())
    {
      ResetCalcStateVars();
      BatchSigSent_ = CalcPtr_->BatchFileEndedSignalSent() ||
                      CalcPtr_->BatchFileEndedSignalAcked();
    }

    if (Destruct_)
    {
      // Destroy ExprStringStack object here, otherwise null pointer error
      // occurs if graph plotter object removed when _GpExprStack is being
      // deleted in destructor method.
      _GpExprStack->SetCalculator(CalcPtr_);
      delete _GpExprStack;
      _GpExprStack = NULL;

      if (!BatchSigSent_)
        CalcPtr_->ReCheckEndBatchSignal();

      CalcPtr_->SetPlotGraph(true, 0, true, 0);

      // Resume Calc Polling
      #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
        if (PlotCompleted_ && CalcPtr_->ResumePolling())
        {
          CalcPtr_->ResumeCalcPolling();
          CalcPtr_->SetResumePolling(false);
        }
      #endif
    }
    else if (_CalcPtr)
    {
      if (!BatchSigSent_)
        CalcPtr_->ReCheckEndBatchSignal();

      CalcPtr_->SetPlotGraph(true, 0, true, 0);

      // Resume Calc Polling
      #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
        if (PlotCompleted_ && CalcPtr_->ResumePolling())
        {
          CalcPtr_->ResumeCalcPolling();
          CalcPtr_->SetResumePolling(false);
        }
      #endif
    }
  }

  #if CALCLIB_DEBUG11a
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
const char* SubExpression::Evaluate()
{
  #if CALCLIB_DEBUG12
    if (_CalcPtr->DbgPtr())
    {
      _CalcPtr->DbgPtr()->EnterLevel("Evaluate");
      _CalcPtr->DbgPtr()->ShowInt(_CalcPtr!=NULL, "_CalcPtr!=NULL");
      _CalcPtr->DbgPtr()->ShowInt(CalculatorBase::CalculatorExists(_CalcNumber),
                                  "CalculatorBase::CalculatorExists(_CalcNumber)");
      _CalcPtr->DbgPtr()->ShowStr(_Expression, "_Expression");
    }
  #endif

  if (!_CalcPtr || !CalculatorBase::CalculatorExists(_CalcNumber) || !_Expression)
  {
    #if CALCLIB_DEBUG12
      if (_CalcPtr->DbgPtr())
        _CalcPtr->DbgPtr()->LeaveLevel();
    #endif
    return NULL;
  }

  _MemDel->CheckIfEraseStoredTrash(STOREMEM);

  int i, Error_;
  int ReEval_ = 0;
  int ExprValid_ = _NumFncCalls ? 0:
                       (_Parent && !_CalcPtr->HasErrors() &&
                                   !_CalcPtr->QuitGraph() &&
                                    _CalcPtr->IsValidNum(_Expression));
  int EvalFnc_ = 0;
  int ShowFnc_ = 0;
  int NumBase_ = 0;

  int ExprStkSz_ = 0;
  int ExprStkIndex_ = 0;
  char** ExprStk_ = NULL;
  char* Backup_ = NULL;

  ChrString FnameMsg_ = GetOriginal();
  CalcGraphPlotter* CalcPlot_ = CalculatorBase::GetGraphPlotter();

  bool HexNum_ = false;
  bool DecNum_ = false;
  bool OctNum_ = false;
  bool Confirmed_ = false;

  bool PlotGraph_ = CalculatorBase::DoPlotGraph();
  bool PlotCompleted_ = IsPlotCompleted();
  bool GraphOp_ = IsGraphOp();
  bool InGraphOp_ = InGraphOp();
  bool NotGraphOp_ = NotGraphOp();
  bool DoShowMsg_ = GraphOp_ && !CalculatorBase::InAsyncMode() &&
                    !_CalcPtr->SessionOption();

  _HasErrors = _CalcPtr->HasErrors();
  _QuitGraph - _CalcPtr->QuitGraph();
  _MathLineValid = _CalcPtr->MathLineValid();

  if (!_CalcPtr->HasErrors() &&
      !_CalcPtr->QuitGraph() && _CalcPtr->MathLineValid())
  {
    if (CalcPlot_ && (GraphOp_ || InGraphOp_) && !PlotCompleted_)
    {
      _CalcPtr->SetPlotGraph(true, !InGraphOp_ && GraphOp_);

      if (!_GraphPlotter && GraphOp_)
        StartGraphPlotting();
    }
    else if (!_FunctionSearchInProgress && !_CalcPtr->QuitGraph() &&
             ((NotGraphOp_ && NotInGraphOp()) || PlotCompleted_))
    {
      if (_GraphPlotter && _GraphPlotter->IsParent(this))
        EndGraphPlotting();
      else if (!_GraphPlotter)
        ResetCalcStateVars();

      _CalcPtr->SetPlotGraph(true, 0, true, 0);
    }
  }
  else if (_CalcPtr->QuitGraph())
  {
    if (_CalcPtr->PostExecResetProcessDone() &&
        _CalcPtr->InputDataFileExecLock() == CalculatorBase::EXECFILE_UNLOCKED)
      _CalcPtr->ReCheckEndBatchSignal();
  }
  else if (GraphCmdWasFound() && !_CalcPtr->InAllGraphsFile())
  {
    if (_CalcPtr->GraphOperationOptions()->InAppliedFunctionGraph())
      _CalcPtr->SetHasCommandOutput(true, Mcalc_IOState::CALC_RESPONSE);
  }

  if (!_CalcPtr->HasErrors() &&
      !_CalcPtr->QuitGraph() && _CalcPtr->MathLineValid() &&
      _NumFncCalls && _FncCalls[0])
  {
    ShowFnc_ = CalculatorBase::icasestrcompn(_FncCalls[0]->GetFncName(), "SHOW", 4);
    EvalFnc_ = CalculatorBase::icasestrcompn(_FncCalls[0]->GetFncName(), "EVAL", 4);

    _CalcPtr->ResetAnswerMode();
    _CalcPtr->SetNoOutputReturned(NULL, NoReturns() || ::SafeStrLen(GetProgramName()));
    _CalcPtr->SetExecutingExpression(this);

    for (i = 0; i < _NumFncCalls &&
                !_CalcPtr->HasErrors() &&
                !_CalcPtr->QuitGraph() && _FncCalls[i]; i++)
    {
      _FncCalls[i]->Evaluate();

      if (!_CalcPtr->HasErrors() && !_CalcPtr->QuitGraph())
      {
        SubstFncAnswer(i);
        if (!_Parent && CalculatorBase::icasestrcompn(_FncCalls[i]->GetFncName(), "EVAL", 4))
          SubstFncOriginal(i);

        ExprValid_ = _Parent && _CalcPtr->IsValidNum(_Expression);

        if (!ExprValid_ && i >= _NumFncCalls - 1 && ((!_ShowFunction && !_ShowSetFunction) || _Level == 0))
        {
          _CalcPtr->SetProcessVariables(_Parent != NULL);

          if (_Level)
            _CalcPtr->PushActiveExpression(this);

          _CalcPtr->TransferData(_Expression, _CalcPtr);

          // using Pop instead of PopDelete since all stored subexpressions are owned
          // by _SubExprStack and are destroyed with call to DestroySubExprStack method
          if (_Level)
            _CalcPtr->PopActiveExpression(false);
        }
      }
    }

    _CalcPtr->SetExecutingExpression(NULL);

    if (_NumFncCalls && IsPlotCompleted() &&
        DoShowMsg_ && !_CalcPtr->QuitGraph() && !_CalcPtr->HasErrors())
    {
      FnameMsg_ += MSG_WRITTEN_TO_FILE;
      FnameMsg_ += CalculatorBase::CurrentGraphFname();
      FnameMsg_ += "\n";

      _CalcPtr->TieOutputToSignal(Mcalc_IOState::OUTPUT_READY)
              ->DisplayMessage(stdout, FnameMsg_.c_str());
    }
  }

  _HasErrors = _CalcPtr->HasErrors();
  _QuitGraph - _CalcPtr->QuitGraph();
  _MathLineValid = _CalcPtr->MathLineValid();

  if (_NumFncCalls && !_FunctionSearchInProgress &&
      (_CalcPtr->HasErrors() ||
       _CalcPtr->QuitGraph() || !_CalcPtr->MathLineValid()))
  {
    if (_GpExprStack)
    {
      _GpExprStack->SetGraphPlotter(CalculatorBase::GetGraphPlotter());
      _GpExprStack->ClearExpressionStack(_PrevCalc);
    }

    if (!_CalcPtr->QuitGraph())
    {
      ResetCalcStateVars();
      _CalcPtr->SetPlotGraph(true, 0, true, 0);
    }

    SetGraphPlotter(NULL);

    #if CALCLIB_DEBUG12
      if (_CalcPtr->DbgPtr())
        _CalcPtr->DbgPtr()->LeaveLevel();
    #endif
    return NULL;
  }

  if (ExprValid_)
  {
    _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, ::SafeStrLen(_Expression), true, true);
    ::SafeStrCpy(_AnswerStr, _Expression);

    if (!_Parent)
    {
      _OriginalStr = AllocateNewString(_MemDel, _OriginalStr, ::SafeStrLen(_Expression), true, true);
      ::SafeStrCpy(_OriginalStr, _Expression);

      Backup_ = ::NewString(_OriginalStr);
      _CalcPtr->ReplaceTokens(&_OriginalStr, _CalcPtr, FALSE, Error_, ReEval_, FALSE, FALSE);

      if ((!_OriginalStr || _CalcPtr->RecursionLimitReached()) && Backup_)
      {
        if (_OriginalStr)
        {
          _MemDel->DelayedDeleteCstr(_OriginalStr, STOREMEM);
          _OriginalStr = NULL;
        }

        _OriginalStr = Backup_;
        _OriginalStr[0] = 0;
        Backup_ = NULL;
      }
      else if (_OriginalStr && Backup_)
      {
        MemMatrix::Matrix().Deallocate(Backup_);
        Backup_ = NULL;
      }

      NumBase_ = _CalcPtr->NumberBase();

      HexNum_ = ::IsIntHex(_AnswerStr);
      DecNum_ = ::IsNumber(_AnswerStr,1,1,1,10);

      Confirmed_ = _CalcPtr->SubExprStackIndex() == 1 &&
                   !_CalcPtr->ActiveExpression() &&
                   GetLevel() == 0;

      if (Confirmed_ && !_Parent &&
          !_CalcPtr->IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString) &&
          !_CalcPtr->IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump) &&
          !_CalcPtr->IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay) &&
          !_CalcPtr->IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDump) &&
          !_CalcPtr->IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDisplay))
      {
        if (DecNum_ && !HexNum_ &&
            NumBase_ != 16 && NumBase_ != 8)
        {
          _CalcPtr->ResetAnswerMode();
          _CalcPtr->SetAnswerMode(_CalcPtr->FLOATINGPOINT_MODE, Confirmed_);
          _CalcPtr->AppendOutputDataType(NULL, Mcalc_OutputDataType::Out_FloatAnswer);
          _CalcPtr->SetResultsPending(true);
        }
        else
        {
          OctNum_ = ::IsIntOct(_AnswerStr);

          _CalcPtr->ResetAnswerMode();
          _CalcPtr->SetResultsPending(true);

          if ((HexNum_ || OctNum_) && NumBase_ != 10)
          {
            _CalcPtr->SetAnswerMode(_CalcPtr->ALTBASE_MODE, Confirmed_);
            _CalcPtr->AppendOutputDataType(NULL, Mcalc_OutputDataType::Out_AnswerString |
                                                 Mcalc_OutputDataType::Out_LiteralAnswer);
          }
          else
          {
            _CalcPtr->SetAnswerMode(_CalcPtr->FLOATINGPOINT_MODE, Confirmed_);
            _CalcPtr->AppendOutputDataType(NULL, Mcalc_OutputDataType::Out_FloatAnswer);
          }
        }
      }
    }

    #if CALCLIB_DEBUG12
      if (_CalcPtr->DbgPtr())
        _CalcPtr->DbgPtr()->LeaveLevel();
    #endif
    return _AnswerStr;
  }
  else
  {
    if (!_NumFncCalls)
    {
      _CalcPtr->ResetAnswerMode();
      _CalcPtr->SetNoOutputReturned(NULL, NoReturns() || ::SafeStrLen(GetProgramName()));
      _CalcPtr->SetExecutingExpression(this);
      _CalcPtr->SetProcessVariables(_Parent != NULL);

      if (_Level)
        _CalcPtr->PushActiveExpression(this);

      _CalcPtr->TransferData(_Expression, _CalcPtr);

      // using Pop instead of PopDelete since all stored subexpressions are owned
      // by _SubExprStack and are destroyed with call to DestroySubExprStack method
      if (_Level)
        _CalcPtr->PopActiveExpression(false);
      _CalcPtr->SetExecutingExpression(NULL);

      _HasErrors = _CalcPtr->HasErrors();
      _QuitGraph - _CalcPtr->QuitGraph();
      _MathLineValid = _CalcPtr->MathLineValid();

      if (!_FunctionSearchInProgress &&
          (_CalcPtr->HasErrors() ||
           _CalcPtr->QuitGraph() || !_CalcPtr->MathLineValid()))
      {
        if (_GpExprStack)
        {
          _GpExprStack->SetGraphPlotter(CalculatorBase::GetGraphPlotter());
          _GpExprStack->ClearExpressionStack(_PrevCalc);
        }

        if (!_CalcPtr->QuitGraph())
        {
          ResetCalcStateVars();
          _CalcPtr->SetPlotGraph(true, 0, true, 0);
        }

        #if CALCLIB_DEBUG12
          if (_CalcPtr->DbgPtr())
            _CalcPtr->DbgPtr()->LeaveLevel();
        #endif
        SetGraphPlotter(NULL);
        return NULL;
      }
    }

    if (HasAnswer())
    {
      int Mode_ = _CalcPtr->AnswerMode();
      const char* ansp_ = _CalcPtr->AnswerStr();
      ChrString Answer_ = ansp_ ? ansp_:"";

      if (ansp_ && Answer_.strlen())
      {
        _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, ::SafeStrLen(Answer_.c_str()), true, true);
        ::SafeStrCpy(_AnswerStr, Answer_.c_str());

        if (_Parent)
        {
          _Expression = AllocateNewString(_MemDel, _Expression, ::SafeStrLen(_AnswerStr), true, true);
          ::SafeStrCpy(_Expression, _AnswerStr);
          _AnswerMode = Mode_;
        }
        else
        {
          int SkipEval_ = (ShowFnc_ || EvalFnc_) && _SingleFncCall;

          if (!SkipEval_)
          {
            Backup_ = ::NewString(_OriginalStr);
            _CalcPtr->ReplaceTokens(&_OriginalStr, _CalcPtr, FALSE, Error_, ReEval_, FALSE, FALSE);

            if ((!_OriginalStr || _CalcPtr->RecursionLimitReached()) && Backup_)
            {
              if (_OriginalStr)
              {
                _MemDel->DelayedDeleteCstr(_OriginalStr, STOREMEM);
                _OriginalStr = NULL;
              }

              _OriginalStr = Backup_;
              _OriginalStr[0] = 0;
              Backup_ = NULL;
            }
            else if (_OriginalStr && Backup_)
            {
              MemMatrix::Matrix().Deallocate(Backup_);
              Backup_ = NULL;
            }
          }

          _CalcPtr->SetOriginalStr(_OriginalStr);
          _AnswerMode = _CalcPtr->AnswerMode();
        }

        #if CALCLIB_DEBUG12
          if (_CalcPtr->DbgPtr())
            _CalcPtr->DbgPtr()->LeaveLevel();
        #endif
        return _AnswerStr;
      }
      else
      {
        _AnswerMode = 0;
        _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, 5, true, true);
        ::SafeStrCpy(_AnswerStr, "");
      }
    }
    else
    {
      _AnswerMode = 0;
      _AnswerStr =  AllocateNewString(_MemDel, _AnswerStr, 5, true, true);
      ::SafeStrCpy(_AnswerStr, "");
    }
  }

  #if CALCLIB_DEBUG12
    if (_CalcPtr->DbgPtr())
      _CalcPtr->DbgPtr()->LeaveLevel();
  #endif

  _HasErrors = _CalcPtr->HasErrors();
  _QuitGraph - _CalcPtr->QuitGraph();
  _MathLineValid = _CalcPtr->MathLineValid();

  return NULL;
}

/****************************************************************************/
int SubExpression::InProgramMode(bool InclPrompter_, bool InclInfile_) const
{
  return (_CalcPtr ? _CalcPtr->InProgramMode(InclPrompter_, InclInfile_):0);
}

/****************************************************************************/
int SubExpression::ExecInputFileData() const
{
  return (_CalcPtr ? _CalcPtr->ExecInputFileData():0);
}

/****************************************************************************/
Boolean SubExpression::HasCommandOutput() const
{
  int Show_ = HasAnswer() && ShowAnswer();
  int i;

  if (Show_)
    for (i = 0; i < _NumFncCalls && _FncCalls[i]; i++)
      if (!_FncCalls[i]->ShowAnswer())
      {
        Show_ = FALSE;
        break;
      }

  return (_CalcPtr && CalculatorBase::CalculatorExists(_CalcNumber) &&
          Show_ && !_CalcPtr->StoreResults());
}

/****************************************************************************/
void SubExpression::ShowResults()
{
  if (!_CalcPtr || !CalculatorBase::CalculatorExists(_CalcNumber))
    return;

  bool InBatch_ = false;
  bool BatchSigSent_ = false;
  bool AccessCond_ = false;
  bool IoAccess_ = false;
  bool FileNotEmpty_ = false;
  bool HasOutput_ = false;
  bool OutReady_ = false;
  bool HasErr_ = false;
  bool HasDir_ = false;
  bool QuitGraph_ = false;

  int Override_ = false;
  int IoState_ = _CalcPtr->Bare_GetIoState(0);
  int Show_ = ShowAnswer();
  int i;

  if (Show_)
    for (i = 0; i < _NumFncCalls && _FncCalls[i]; i++)
      if (!_FncCalls[i]->ShowAnswer())
      {
        Show_ = FALSE;
        break;
      }

  if (Show_ && !_CalcPtr->StoreResults() &&
               !_CalcPtr->HasDirective())
  {
    _CalcPtr->SetDisplayOption(CalculatorBase::DISPLAY_TO_STREAM);
    _CalcPtr->DisplayAnswerString();
    _CalcPtr->SetResultsShown(true);
    _CalcPtr->SetDisplayOption(CalculatorBase::DISPLAY_TO_STRING);
  }
  else if (_CalcPtr->InAsyncMode())
  {
    InBatch_ = _CalcPtr->InBatchFile(true);
    BatchSigSent_ = _CalcPtr->BatchFileEndedSignalSent() ||
                    _CalcPtr->BatchFileEndedSignalAcked();
    AccessCond_ = _CalcPtr->GiveIoAccessCondition(_CalcPtr, CalculatorBase::PLOTDONE_CHKSHOWN);
    IoAccess_ = _CalcPtr->GiveIoAccessCondition(_CalcPtr, CalculatorBase::IOACCESS);

    if ((!_CalcPtr->NoPauseFileInput() && !_CalcPtr->SessionOption()) ||
        (InBatch_ && _CalcPtr->GraphFilePause()))
    {
      if (CalculatorBase::PostBreakResponseSent())
        CalculatorBase::ResetPostBreakResponse();
      else if (!CalculatorBase::ShouldBreakFromProgram(_CalcPtr))
      {
        if (AccessCond_)
        {
          _CalcPtr->SetGraphPlotShown(true);

          if (InBatch_)
            _CalcPtr->SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
          else
          {
            HasErr_ = _HasErrors = _CalcPtr->HasErrors();
            QuitGraph_ = _QuitGraph = _CalcPtr->QuitGraph();
            _MathLineValid = _CalcPtr->MathLineValid();
            HasDir_ = _CalcPtr->HasDirective();

            if (!HasErr_ && !HasDir_ && !QuitGraph_)
            {
              FileNotEmpty_ = _CalcPtr->IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
              OutReady_ = _CalcPtr->HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
            }

            if (!HasErr_ && !HasDir_ && !QuitGraph_ &&
                !OutReady_ && HasOutput_ && FileNotEmpty_)
            {
              _CalcPtr->SetResultsShown(true);
              _CalcPtr->SendIoState((Mcalc_IOState::GRAPH_OUTPUT |
                                     Mcalc_IOState::CALC_RESPONSE), true);
            }
          }
        }
        else if (IoAccess_)
        {
          HasErr_ = _HasErrors = _CalcPtr->HasErrors();
          QuitGraph_ = _QuitGraph = _CalcPtr->QuitGraph();
          _MathLineValid = _CalcPtr->MathLineValid();

          if (!HasErr_ && !QuitGraph_)
          {
            FileNotEmpty_ = _CalcPtr->IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
            OutReady_ = _CalcPtr->HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
          }

          _CalcPtr->SetResultsShown(!HasErr_ && !QuitGraph_ &&
                                    !OutReady_ && HasOutput_ && FileNotEmpty_);

          _CalcPtr
            ->AllowEmptyResponse()
            ->SendCalcResponseSignal(0);
        }
      }
    }
    else if (AccessCond_)
    {
      _CalcPtr->SetGraphPlotShown(true);
      _CalcPtr->SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
    }
  }
}

/****************************************************************************/
// FunctionCall class definitions
/****************************************************************************/
FunctionCall::FunctionCall():
_Parent(NULL),
_FncName(NULL),
_NumParams(0),
_MaxParams(0),
_ParamArray(NULL),
_AnswerStr(NULL),
_LiteralAnsStr(NULL),
_OutputMode(CalculatorBase::FLOATINGPOINT_MODE),
_ShouldShow(TRUE),
_MemDel(new DelayedMemoryDeleter)
{}

/****************************************************************************/
FunctionCall::FunctionCall(SubExpression* Parent_, char* Name_):
_Parent(Parent_),
_FncName(NULL),
_NumParams(0),
_MaxParams(0),
_ParamArray(NULL),
_AnswerStr(NULL),
_LiteralAnsStr(NULL),
_OutputMode(CalculatorBase::FLOATINGPOINT_MODE),
_ShouldShow(TRUE),
_MemDel(new DelayedMemoryDeleter)
{
  ChrString NameStr_ = Name_;
  NameStr_.RemovePadding(" \t\n\r");

  _FncName = (char*)MemMatrix::Matrix().Callocate(NameStr_.strlen() + 1);
  ::SafeStrCpy(_FncName, NameStr_.c_str());
}

/****************************************************************************/
FunctionCall::~FunctionCall()
{
  Clear();

  delete _MemDel;
  _MemDel = NULL;
}

/****************************************************************************/
int FunctionCall::InProgramMode(bool InclPrompter_, bool InclInfile_) const
{
  return (_Parent ? _Parent->InProgramMode(InclPrompter_, InclInfile_):0);
}

/****************************************************************************/
int FunctionCall::ExecInputFileData() const
{
  return (_Parent ? _Parent->ExecInputFileData():0);
}

/****************************************************************************/
void FunctionCall::SetShowAnswer(int Value_)
{
  _ShouldShow = Value_;
}

/****************************************************************************/
void FunctionCall::SetNumParams(int Params_)
{
  _MemDel->DelayedDeleteCstr((char*)_ParamArray, STOREMEM);

  _ParamArray = (FncParameter**)MemMatrix::Matrix().Callocate(Params_ * sizeof(FncParameter*));

  int x;
  for (x = 0; x < Params_; x++)
    _ParamArray[x] = NULL;

  _MaxParams = Params_;
}

/****************************************************************************/
void FunctionCall::AddParameter(const char* Expr_, int FindCalls_, int ReplExpr_)
{
  if (_NumParams >= _MaxParams)
  {
    _Parent->GetCalculator()->DisplayErrorMessage(
        _Parent->GetCalculator()->GetOutputFile(),
        Mcalc_Error::ERRVAL_ARRAYBOUNDS, "%s", ERRMSG_ARRAYBOUNDS);
    exit(1);
  }
  else
  {
    ChrString ExprStr_ = Expr_ ? Expr_:"";
    ExprStr_.RemovePadding(" \t\n\r");
    CalculatorBase* CalcPtr_ = _Parent->GetCalculator();

    _ParamArray[_NumParams] = new FncParameter;

    if (_ParamArray[_NumParams])
    {
      _ParamArray[_NumParams]->_Param = new SubExpression(_Parent, _Parent->GetLevel()+1, ExprStr_.c_str());
      _ParamArray[_NumParams]->_Param->SetCalculator(CalcPtr_);
      _ParamArray[_NumParams]->_Param->SetIsParam(TRUE);
      _ParamArray[_NumParams]->_ShouldEval = FindCalls_;
      _ParamArray[_NumParams]->_ShouldReplace = ReplExpr_;

      ++_NumParams;
      if (!_Parent->GetCalculator()->IsValidNum(ExprStr_.c_str()))
        _ParamArray[_NumParams - 1]->_Param->FindFunctionCalls();
    }
  }
}

/****************************************************************************/
void FunctionCall::ReplaceParameter(int Index_, CalculatorBase* CalcPtr_,
                                    int& Error_, int& ReEvaluate_, int ReFormat_, int ChangeModes_)
{
  if (_ParamArray[Index_] && _ParamArray[Index_]->_Param)
  {
    if (_ParamArray[Index_]->_Param->_ShowFunction ||
        _ParamArray[Index_]->_Param->_ShowSetFunction)
      _ParamArray[Index_]->_Param->Evaluate() != NULL;
    else
    {
      char* Backup_ = _ParamArray[Index_]->_Param->_Expression ?
                         ::NewString(_ParamArray[Index_]->_Param->_Expression):
                         NULL;

      CalcPtr_->ReplaceTokens(&(_ParamArray[Index_]->_Param->_Expression), CalcPtr_, TRUE, Error_,
                              ReEvaluate_, ReFormat_, FALSE);

      if ((!_ParamArray[Index_]->_Param->_Expression ||
           CalcPtr_->RecursionLimitReached()) && Backup_)
      {
        if (_ParamArray[Index_]->_Param->_Expression)
        {
          _MemDel->DelayedDeleteCstr(_ParamArray[Index_]->_Param->_Expression, STOREMEM);
          _ParamArray[Index_]->_Param->_Expression = NULL;
        }

        _ParamArray[Index_]->_Param->_Expression = Backup_;
        _ParamArray[Index_]->_Param->_Expression[0] = 0;
        Backup_ = NULL;
      }
      else if (_ParamArray[Index_]->_Param->_Expression && Backup_)
      {
        MemMatrix::Matrix().Deallocate(Backup_);
        Backup_ = NULL;
      }
    }
  }
}

/****************************************************************************/
void FunctionCall::Evaluate()
{
  _MemDel->CheckIfEraseStoredTrash(STOREMEM);

  int i;
  int AnsMode_ = 0;
  int Error_ = 0;
  int EvalOk_ = TRUE;
  int SetVar_ = 0;
  int SetCnt_ = 0;
  int SetName_ = 0;
  int SetFile_ = 0;
  int SetQuote_ = 0;
  int ReEvaluate_ = 0;
  int SingleArgFncs_ = _NumParams == 1;
  int ConvFncs_ =
      CalculatorBase::icasestrcompn(_FncName, "TOHEX", 5) ||
      CalculatorBase::icasestrcompn(_FncName, "TOOCT", 5) ||
      CalculatorBase::icasestrcompn(_FncName, "TOBIN", 5) ||
      CalculatorBase::icasestrcompn(_FncName, "TOCMP2BIN", 9);
  int SetOpFncs_ =
      !SingleArgFncs_ &&
      (CalculatorBase::icasestrcompn(_FncName, "SETUNI", 6)     ||
       CalculatorBase::icasestrcompn(_FncName, "SETINT", 6)     ||
       CalculatorBase::icasestrcompn(_FncName, "SETDIF", 6)     ||
       CalculatorBase::icasestrcompn(_FncName, "SETXDIF", 7));
  int MakeSetFnc_ =
      CalculatorBase::icasestrcompn(_FncName, "SET", 3) && !SetOpFncs_;
  int ItemFncs_ =
      !SingleArgFncs_ &&
      (CalculatorBase::icasestrcompn(_FncName, "ITEMPERM", 8)         ||
       CalculatorBase::icasestrcompn(_FncName, "ITEMCOMB", 8)         ||
       CalculatorBase::icasestrcompn(_FncName, "ITEMPERMREP", 11)     ||
       CalculatorBase::icasestrcompn(_FncName, "ITEMCOMBREP", 11));
  int FracFnc_ = !SingleArgFncs_ && CalculatorBase::icasestrcompn(_FncName, "FRAC", 4);
  int EvalFnc_ = CalculatorBase::icasestrcompn(_FncName, "EVAL", 4);
  int ShowFnc_ = CalculatorBase::icasestrcompn(_FncName, "SHOW", 4);
  int ShowSetFnc_ = CalculatorBase::icasestrcompn(_FncName, "SHOWSET", 7);
  int ReFormat_ = FALSE;
  int PreCheckInvalid_ = TRUE;
  char* NewOriginal_ = NULL;
  char* Backup_;
  CalculatorBase* CalcPtr_ = _Parent->GetCalculator();
  CalculatorBase* PrevCalc_ = CalcPtr_;

  #if CALCLIB_DEBUG12
    if (CalcPtr_->DbgPtr())
      CalcPtr_->DbgPtr()->EnterLevel("FunctionCall::Evaluate");
  #endif

  if (ShowFnc_ || ShowSetFnc_)
    CalcPtr_->SetEvalStrings(TRUE);
  else if (EvalFnc_ && _ParamArray[0])
  {
    CalcPtr_->SetEvalStrings(TRUE);
    NewOriginal_ = ::NewString(_ParamArray[0]->_Param->_Expression);

    Backup_ = ::NewString(NewOriginal_);
    CalcPtr_->ReplaceTokens(&NewOriginal_, CalcPtr_, FALSE, Error_,
                            ReEvaluate_, FALSE, FALSE);

    if ((!NewOriginal_ || CalcPtr_->RecursionLimitReached()) && Backup_)
    {
      if (NewOriginal_)
      {
        _MemDel->DelayedDeleteCstr(NewOriginal_, STOREMEM);
        NewOriginal_ = NULL;
      }

      NewOriginal_ = Backup_;
      NewOriginal_[0] = 0;
      Backup_ = NULL;
    }
    else if (NewOriginal_ && Backup_)
    {
      MemMatrix::Matrix().Deallocate(Backup_);
      Backup_ = NULL;
    }

    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;
    CalcPtr_->SetEvalStrings(TRUE);
    ReFormat_ = TRUE;
  }
  else if (MakeSetFnc_)
  {
    char* VarStr_ = (SingleArgFncs_ ||
                     !_ParamArray[1] || !_ParamArray[1]->_Param) ? NULL:_ParamArray[1]->_Param->_Expression;
    SetCnt_ = SingleArgFncs_ ?
                0:(_NumParams > 2 && VarStr_ && IsNumber(VarStr_, 0, 0, 0, 10));
    SetVar_ = SingleArgFncs_ ?
                0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) == 1 && isalpha(VarStr_[0]));
    SetName_ = (!_ParamArray[0] || !_ParamArray[0]->_Param) ?
                   0:(_ParamArray[0]->_Param->_Expression &&
                      ::isalpha(_ParamArray[0]->_Param->_Expression[0]));
    SetFile_ = SingleArgFncs_ ?
                 0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && isalpha(VarStr_[0]));
    SetQuote_ = SingleArgFncs_ ?
                  0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && CalculatorBase::InSetNotation(VarStr_));

    PreCheckInvalid_ = (!SingleArgFncs_ &&
                        !(SetCnt_ || SetVar_ || SetFile_ || SetQuote_)) || !SetName_;

    if (PreCheckInvalid_)
    {
      if ((_NumParams > 2 && VarStr_ && !SetCnt_) ||
          (_NumParams == 2 && VarStr_ && strlen(VarStr_) == 1 && isalpha(VarStr_[0]) && !SetVar_) ||
          (_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && isalpha(VarStr_[0]) && !SetFile_) ||
          (_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && !isalpha(VarStr_[0]) && !SetQuote_))
        ReplaceParameter(1, CalcPtr_, Error_, ReEvaluate_, TRUE);

      if (!SetName_)
        ReplaceParameter(0, CalcPtr_, Error_, ReEvaluate_, TRUE);

      VarStr_ = (SingleArgFncs_ ||
                 !_ParamArray[1] || !_ParamArray[1]->_Param) ? NULL:_ParamArray[1]->_Param->_Expression;
      SetCnt_ = SingleArgFncs_ ?
                  0:(_NumParams > 2 && VarStr_ && IsNumber(VarStr_, 0, 0, 0, 10));
      SetVar_ = SingleArgFncs_ ?
                  0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) == 1 && isalpha(VarStr_[0]));
      SetName_ = (!_ParamArray[0] || !_ParamArray[0]->_Param) ?
                     0:(_ParamArray[0]->_Param->_Expression &&
                        ::isalpha(_ParamArray[0]->_Param->_Expression[0]));
      SetFile_ = SingleArgFncs_ ?
                   0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && isalpha(VarStr_[0]));
      SetQuote_ = SingleArgFncs_ ?
                    0:(_NumParams == 2 && VarStr_ && strlen(VarStr_) > 1 && CalculatorBase::InSetNotation(VarStr_));

      PreCheckInvalid_ = (!SingleArgFncs_ &&
                          !(SetCnt_ || SetVar_ || SetFile_ || SetQuote_)) || !SetName_;
    }
  }
  else if (ItemFncs_ && _ParamArray[0] && _ParamArray[0]->_Param)
  {
    PreCheckInvalid_ = _ParamArray[0]->_Param->_Expression &&
                          !IsNumber(_ParamArray[0]->_Param->_Expression, 0, 0, 0, 10);

    if (PreCheckInvalid_)
    {
      ReplaceParameter(0, CalcPtr_, Error_, ReEvaluate_, TRUE);
      PreCheckInvalid_ = _ParamArray[0]->_Param->_Expression &&
                            !IsNumber(_ParamArray[0]->_Param->_Expression, 0, 0, 0, 10);
    }
  }
  else if (SetOpFncs_)
  {
    SetName_ = (_NumParams == 3 && CalculatorBase::CheckNoNullParams(3, _ParamArray)) &&
               _ParamArray[0]->_Param->_Expression &&
               ::isalpha(_ParamArray[0]->_Param->_Expression[0]) &&
               _ParamArray[1]->_Param->_Expression &&
               ::isalpha(_ParamArray[1]->_Param->_Expression[0]) &&
               _ParamArray[2]->_Param->_Expression &&
               ::isalpha(_ParamArray[2]->_Param->_Expression[0]);
    PreCheckInvalid_ = !SetName_;

    if (PreCheckInvalid_ && _NumParams == 3)
    {
      ReplaceParameter(0, CalcPtr_, Error_, ReEvaluate_, TRUE);
      ReplaceParameter(1, CalcPtr_, Error_, ReEvaluate_, TRUE);
      ReplaceParameter(2, CalcPtr_, Error_, ReEvaluate_, TRUE);

      SetName_ = (_NumParams == 3 && CalculatorBase::CheckNoNullParams(3, _ParamArray)) &&
                 _ParamArray[0]->_Param->_Expression &&
                 ::isalpha(_ParamArray[0]->_Param->_Expression[0]) &&
                 _ParamArray[1]->_Param->_Expression &&
                 ::isalpha(_ParamArray[1]->_Param->_Expression[0]) &&
                 _ParamArray[2]->_Param->_Expression &&
                 ::isalpha(_ParamArray[2]->_Param->_Expression[0]);
      PreCheckInvalid_ = !SetName_;
    }
  }

  if (FracFnc_)
  {
    for (i = 0; i < _NumParams && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray, i); i++)
    {
      if (_ParamArray[i]->_ShouldEval)
      {
        if (_ParamArray[i]->_Param->_Expression &&
              (CalcPtr_->IsFraction(_ParamArray[i]->_Param->_Expression) ||
                 ::IsNumber(_ParamArray[i]->_Param->_Expression, 1, 1, 1, 10)))
          EvalOk_ = TRUE;
        else
        {
          ReplaceParameter(i, CalcPtr_, Error_, ReEvaluate_, TRUE);

          if (_ParamArray[i]->_Param->_Expression &&
                (CalcPtr_->IsFraction(_ParamArray[i]->_Param->_Expression) ||
                   ::IsNumber(_ParamArray[i]->_Param->_Expression, 1, 1, 1, 10)))
            EvalOk_ = TRUE;
          else
          {
            EvalOk_ = _ParamArray[i]->_Param->Evaluate() != NULL;
            if (!EvalOk_)
              break;
          }
        }
      }
      else if (_ParamArray[i]->_ShouldReplace)
        ReplaceParameter(i, CalcPtr_, Error_, ReEvaluate_, FALSE);
    }
  }
  else
  {
    for (i = 0; i < _NumParams && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray, i); i++)
    {
      if (_ParamArray[i]->_ShouldEval && PreCheckInvalid_)
      {
        EvalOk_ = _ParamArray[i]->_Param->Evaluate() != NULL;
        if (!EvalOk_)
          break;
      }
      else if (_ParamArray[i]->_ShouldReplace)
        ReplaceParameter(i, CalcPtr_, Error_, ReEvaluate_, ReFormat_, ReFormat_);
    }
  }

  ChrString FncResult_;
  ChrString AnsString_;

  if (EvalFnc_ && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray, 0))
  {
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;
    CalcPtr_->SetEvalStrings(FALSE);
    CalcPtr_->SetReEvalStrings(TRUE);

    _ParamArray[0]->_Param->SetOriginal(NewOriginal_);
    _MemDel->DelayedDeleteCstr(NewOriginal_, STOREMEM);
    NewOriginal_ = NULL;

    if (ReEvaluate_)
    {
      ChrString ExprStr_ = _ParamArray[0]->_Param->_Expression;
      AnsString_ = CalcPtr_->ReEvaluate(ExprStr_);
    }
    else
    {
      const char* Ans_ = _ParamArray[0]->_Param->Evaluate();
      if (Ans_)
        AnsString_ = Ans_;
    }

    if (AnsString_.strlen())
      FncResult_ = AnsString_;

    CalcPtr_->SetReEvalStrings(FALSE);
    _OutputMode = CalcPtr_->AnswerMode();
  }
  else if (ShowFnc_ && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray, 0))
  {
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;
    CalcPtr_->SetEvalStrings(FALSE);
    AnsString_ = _ParamArray[0]->_Param->_Expression;

    if (AnsString_.strlen())
    {
      FncResult_ = AnsString_;
      CalcPtr_->SetAnswerMode(CalculatorBase::LITERAL_MODE);
      CalcPtr_->SetLiteralStr(FncResult_.c_str());
    }
    _OutputMode = CalcPtr_->AnswerMode();
  }
  else if (ShowSetFnc_ && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray, 0))
  {
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;
    CalcPtr_->SetEvalStrings(FALSE);
    AnsString_ = _ParamArray[0]->_Param->_Expression;

    if (AnsString_.strlen())
    {
      FncResult_ = AnsString_;
      CalcPtr_->SetAnswerMode(CalculatorBase::LITERAL_MODE);
      CalcPtr_->SetLiteralStr(FncResult_.c_str());
    }
    _OutputMode = CalcPtr_->AnswerMode();
  }
  else if (EvalOk_ && CalculatorBase::CheckNoNullParams(_NumParams, _ParamArray))
  {
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;

    if (FracFnc_ || ConvFncs_)
    {
      AnsMode_ = FracFnc_ ? CalculatorBase::FRACTION_MODE:
                            CalculatorBase::ALTBASE_MODE;

      if (CalcPtr_)
        CalcPtr_->SetAnswerMode(AnsMode_);

      if (_Parent)
        _Parent->SetAnswerMode(AnsMode_);
    }

    if (CalcPtr_)
    {
      FncResult_ = CalcPtr_->EvaluateFunction(_FncName, _NumParams, _ParamArray);
      _OutputMode = CalcPtr_->AnswerMode();
    }

    // Relocated to InfixToRpn method:
    // if (SetOperation())
    //   SetSetOperation(FALSE);
  }

  if (_OutputMode != CalculatorBase::FLOATINGPOINT_MODE)
  {
    const char* LiteralStr_ = (_OutputMode == CalculatorBase::LITERAL_MODE ||
                               _OutputMode == CalculatorBase::ALTBASE_MODE) ?
                                   CalcPtr_->LiteralStr():
                              _OutputMode == CalculatorBase::FRACTION_MODE ?
                                   CalcPtr_->FractionStr():
                                   CalcPtr_->FloatStr();

    _LiteralAnsStr = SubExpression::AllocateNewString(_MemDel, _LiteralAnsStr, ::SafeStrLen(LiteralStr_), true, true);
    ::SafeStrCpy(_LiteralAnsStr, LiteralStr_);
  }

  _AnswerStr = SubExpression::AllocateNewString(_MemDel, _AnswerStr, FncResult_.strlen(), true, true);
  ::SafeStrCpy(_AnswerStr, FncResult_.c_str());

  #if CALCLIB_DEBUG12
    if (CalcPtr_->DbgPtr())
      CalcPtr_->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& FunctionCall::GetOriginalChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    if (_ParamArray[0] && _ParamArray[0]->_Param)
      _RetOriginalStr = _ParamArray[0]->_Param->_OriginalStr;

    return _RetOriginalStr;
  #else
    ChrString Dummy_;
    if (_ParamArray[0] && _ParamArray[0]->_Param)
      Dummy_ = _ParamArray[0]->_Param->_OriginalStr;

    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& FunctionCall::GetFncNameChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFncName = _FncName;
    return _RetFncName;
  #else
    ChrString Dummy_ = _FncName;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& FunctionCall::GetAnswerChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr = _AnswerStr;
    return _RetAnswerStr;
  #else
    ChrString Dummy_ = _AnswerStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
ChrString& FunctionCall::GetLiteralAnswerChrStr() const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetLiteralAnsStr = _LiteralAnsStr;
    return _RetLiteralAnsStr;
  #else
    ChrString Dummy_ = _LiteralAnsStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
const char* FunctionCall::GetOriginal(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    if (_ParamArray[0] && _ParamArray[0]->_Param)
      _RetOriginalStr = _ParamArray[0]->_Param->_OriginalStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetOriginalStr;
    return (ret ? ret->c_str():_RetOriginalStr.c_str());
  #else
    if (_ParamArray[0] && _ParamArray[0]->_Param)
      return _ParamArray[0]->_Param->_OriginalStr;
    return NULL;
  #endif
}

/****************************************************************************/
const char* FunctionCall::GetFncName(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFncName = _FncName;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetFncName;
    return (ret ? ret->c_str():_RetFncName.c_str());
  #else
    return _FncName;
  #endif
}

/****************************************************************************/
const char* FunctionCall::GetAnswer(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr = _AnswerStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetAnswerStr;
    return (ret ? ret->c_str():_RetAnswerStr.c_str());
  #else
    return _AnswerStr;
  #endif
}

/****************************************************************************/
const char* FunctionCall::GetLiteralAnswer(ChrString* ret) const
{
  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetLiteralAnsStr = _LiteralAnsStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetLiteralAnsStr;
    return (ret ? ret->c_str():_RetLiteralAnsStr.c_str());
  #else
    return _LiteralAnsStr;
  #endif
}

/****************************************************************************/
void FunctionCall::Clear()
{
  int x;
  for (x = 0; x < _NumParams; x++)
    if (MemMatrix::Matrix().HasThis(_ParamArray[x]))
      delete _ParamArray[x];

  MemMatrix::Matrix().Deallocate(_FncName);
  MemMatrix::Matrix().Deallocate(_AnswerStr);
  MemMatrix::Matrix().Deallocate(_LiteralAnsStr);

  _NumParams = 0;
  MemMatrix::Matrix().Deallocate(_ParamArray);   // removed, will delete later

  _FncName = _AnswerStr = NULL;
  _ParamArray = NULL;
}

/****************************************************************************/
// FncParameter class definitions
/****************************************************************************/
FncParameter::FncParameter():
_Param(NULL),
_ShouldEval(0)
{}

/****************************************************************************/
FncParameter::FncParameter(const FncParameter& Obj_):
_Param(Obj_._Param ? (new SubExpression(*Obj_._Param)):NULL),
_ShouldEval(Obj_._ShouldEval)
{}

/****************************************************************************/
FncParameter::~FncParameter()
{
  if (MemMatrix::Matrix().HasThis(_Param))
    delete _Param;
  _Param = NULL;
}

/****************************************************************************/
// CalcGraphPlotter class definitions
/****************************************************************************/
CalcGraphPlotter::CalcGraphPlotter(CalculatorBase* CalcPtr_):
_CalcPtr(CalcPtr_),
_IoStatePtr(CalcPtr_ ? CalcPtr_->GetIoStateHandler():NULL),

_Parent(NULL),
_ExprStk(NULL),
_ExprToReplace(NULL),

_NewStr(NULL),
_ReadOnly(false),

_ExprString(NULL),
_GraphExprStart(NULL),
_GraphExprExtension(NULL),
_LeftBrkStart(NULL),

_KeyWordMult(0),
_LeftBrk(false),
_ExprToGraphDiff(0),
_GraphToExtDiff(0),
_GraphToBrkDiff(0),

_GraphCompleted(false),
_PlotGraph(false),
_PlottingGraph(false),
_PlottingDone(false),
_PlotAllPoints(false)
{}

/****************************************************************************/
CalcGraphPlotter::CalcGraphPlotter(const CalcGraphPlotter& Obj_):
_CalcPtr(Obj_._CalcPtr),
_IoStatePtr(Obj_._CalcPtr ? Obj_._CalcPtr->GetIoStateHandler():NULL),

_Parent(Obj_._Parent),
_ExprStk(Obj_._ExprStk),
_ExprToReplace(Obj_._ExprToReplace),

_NewStr(Obj_._NewStr),
_ReadOnly(true),

_KeyWordMult(Obj_._KeyWordMult),
_ExprString(Obj_._ExprString),
_GraphExprStart(Obj_._GraphExprStart),
_GraphExprExtension(Obj_._GraphExprExtension),
_LeftBrkStart(Obj_._LeftBrkStart),

_LeftBrk(Obj_._LeftBrk),
_ExprToGraphDiff(Obj_._ExprToGraphDiff),
_GraphToExtDiff(Obj_._GraphToExtDiff),
_GraphToBrkDiff(Obj_._GraphToBrkDiff),

_GraphCompleted(Obj_._GraphCompleted),
_PlotGraph(Obj_._PlotGraph),
_PlottingGraph(Obj_._PlottingGraph),
_PlottingDone(Obj_._PlottingDone),
_PlotAllPoints(Obj_._PlotAllPoints)
{}

/****************************************************************************/
CalcGraphPlotter::~CalcGraphPlotter()
{
  if (_NewStr && !_ReadOnly)
  {
    ::RawDeleteArray(_NewStr);
    _NewStr = NULL;
  }
}

/****************************************************************************/
CalcGraphPlotter& CalcGraphPlotter::operator = (const CalcGraphPlotter& Obj_)
{
  if (this != &Obj_)
  {
    if (_NewStr && !_ReadOnly)
    {
      ::RawDeleteArray(_NewStr);
      _NewStr = NULL;
    }

    _CalcPtr = Obj_._CalcPtr;
    _IoStatePtr = _CalcPtr ? _CalcPtr->GetIoStateHandler():NULL;

    _Parent = Obj_._Parent;
    _ExprStk = Obj_._ExprStk;
    _ExprToReplace = Obj_._ExprToReplace;

    _NewStr = Obj_._NewStr;
    _ReadOnly = true;

    _KeyWordMult = Obj_._KeyWordMult;
    _ExprString = Obj_._ExprString;
    _GraphExprStart = Obj_._GraphExprStart;
    _GraphExprExtension = Obj_._GraphExprExtension;
    _LeftBrkStart = Obj_._LeftBrkStart;

    _LeftBrk = Obj_._LeftBrk;
    _ExprToGraphDiff = Obj_._ExprToGraphDiff;
    _GraphToExtDiff = Obj_._GraphToExtDiff;
    _GraphToBrkDiff = Obj_._GraphToBrkDiff;

    _GraphCompleted = Obj_._GraphCompleted;
    _PlotGraph = Obj_._PlotGraph;
    _PlottingGraph = Obj_._PlottingGraph;
    _PlottingDone = Obj_._PlottingDone;
    _PlotAllPoints = Obj_._PlotAllPoints;
  }
}

/****************************************************************************/
void CalcGraphPlotter::SetParent(CalculatorBase* Parent_)
{
  if (Parent_)
    _CalcPtr = Parent_;
}

/****************************************************************************/
void CalcGraphPlotter::Reset()
{
  if (_NewStr && !_ReadOnly)
  {
    ::RawDeleteArray(_NewStr);
    _NewStr = NULL;
  }

  _KeyWordMult = 0;
  _ExprString = NULL;
  _GraphExprStart = NULL;
  _GraphExprExtension = NULL;
  _LeftBrkStart = NULL;

  _LeftBrk = false;
  _ExprToGraphDiff = 0;
  _GraphToExtDiff = 0;
  _GraphToBrkDiff = 0;

  if (!_IoStatePtr && _CalcPtr)
    _IoStatePtr = _CalcPtr->GetIoStateHandler();

  _IoStatePtr->ResetGraphState();

  _GraphCompleted = false;
  _PlotGraph = false;
  _PlottingGraph = false;
  _PlottingDone = false;
  _PlotAllPoints = false;
}

/****************************************************************************/
void CalcGraphPlotter::SetNextExpression(ExpressionGraphStack* ExprStk_)
{
  _ExprStk = ExprStk_;
  _Parent = _ExprStk ? _ExprStk->GiveParent():NULL;
}

/****************************************************************************/
void CalcGraphPlotter::SetExprToReplace(const char* ExprRep_)
{
  _ExprToReplace = ExprRep_;
}

/****************************************************************************/
bool CalcGraphPlotter::IsExprToReplace(const char* ExprRep_)
{
  return (_ExprToReplace == ExprRep_);
}

/****************************************************************************/
bool CalcGraphPlotter::HasParent() const
{
  return (_Parent != NULL);
}

/****************************************************************************/
bool CalcGraphPlotter::IsParent(SubExpression* Parent_) const
{
  return (_Parent != NULL && _Parent == Parent_);
}

/****************************************************************************/
const ExpressionGraphStack* CalcGraphPlotter::GetNextExpression() const
{
  return (HasNextExpression() ? _ExprStk:NULL);
}

/****************************************************************************/
ExpressionGraphStack* CalcGraphPlotter::GetNextExpression()
{
  return (HasNextExpression() ? _ExprStk:NULL);
}

/****************************************************************************/
bool CalcGraphPlotter::FindNextExpr(int* Index_) const
{
  bool Found_ = false;

  if (_ExprStk && _ExprToReplace)
    Found_ = _ExprStk->HasExpression(_ExprToReplace, Index_);

  return Found_;
}

/****************************************************************************/
int CalcGraphPlotter::GetNextExpressionIndex() const
{
  int Index_ = -1;

  if (_ExprStk)
    FindNextExpr(&Index_);

  return Index_;
}

/****************************************************************************/
bool CalcGraphPlotter::HasNextExpression() const
{
  return (_ExprStk && FindNextExpr(NULL));
}

/****************************************************************************/
bool CalcGraphPlotter::HasAnyExpr() const
{
  return (_ExprStk && _ExprStk->HasAnyExpr());
}

/****************************************************************************/
bool CalcGraphPlotter::UsingWsStrippedStr() const
{
  return (_NewStr != NULL);
}

/****************************************************************************/
char* CalcGraphPlotter::AllocateNewString(DelayedMemoryDeleter* MemDel_, char* Buffer_,
                                          size_t NewLen_, bool DelOld_, bool AlwaysNew_)
{
  if (!Buffer_ || AlwaysNew_ || ::SafeStrLen(Buffer_) < NewLen_)
  {
    if (DelOld_ && Buffer_)
      if (MemDel_)
        MemDel_->DelayedDeleteCstr(Buffer_, STOREMEM);
      else
        MemMatrix::Matrix().Deallocate(Buffer_);

    Buffer_ = (char*)MemMatrix::Matrix().Callocate(NewLen_ + 1);
  }

  return Buffer_;
}

/****************************************************************************/
char* CalcGraphPlotter::RevertToOriginal()
{
  _GraphExprStart = &_ExprString[_ExprToGraphDiff];
  char* pt = &_GraphExprStart[_KeyWordMult*5];

  if (_LeftBrk)
  {
    _LeftBrkStart = &pt[_GraphToBrkDiff];
    _GraphExprExtension = NULL;
  }
  else
  {
    _GraphExprExtension = &pt[_GraphToExtDiff];
    _LeftBrkStart = NULL;
  }

  if (_NewStr && !_ReadOnly)
  {
    ::RawDeleteArray(_NewStr);
    _NewStr = NULL;
  }

  return _GraphExprStart;
}

/****************************************************************************/
char* CalcGraphPlotter::StripWs()
{
  if (_ReadOnly || !_ExprString)
    return _GraphExprStart;
  else if (_NewStr)
  {
    _GraphExprStart = _NewStr;

    if (_LeftBrk)
    {
      _LeftBrkStart = &_NewStr[_KeyWordMult*5];
      _GraphExprExtension = NULL;
    }
    else
    {
      _GraphExprExtension = &_NewStr[_KeyWordMult*5];
      _LeftBrkStart = NULL;
    }

    return _GraphExprStart;
  }

  char* pt = NULL;

  if (!_ReadOnly && _ExprString)
    _NewStr = strcpy(AllocateNewString(NULL, _NewStr, strlen(_ExprString)+1, true, true), _ExprString);

  _CalcPtr->stripws(_NewStr);

  if (_ExprString != _GraphExprStart)
    _ExprToGraphDiff = _GraphExprStart - _ExprString;
  else
    _ExprToGraphDiff = 0;

  _GraphExprStart = _NewStr;

  if (_LeftBrk)
  {
    if (_LeftBrkStart != &_GraphExprStart[_KeyWordMult*5] && isspace(_GraphExprStart[_KeyWordMult*5]))
    {
      pt = &_GraphExprStart[_KeyWordMult*5];
      _GraphToBrkDiff = pt - _LeftBrkStart;
      _GraphToExtDiff = 0;
    }
    else
      _GraphToBrkDiff =
      _GraphToExtDiff = 0;

    _LeftBrkStart = &_NewStr[_KeyWordMult*5];
    _GraphExprExtension = NULL;
  }
  else
  {
    if (_GraphExprExtension != &_GraphExprStart[_KeyWordMult*5] && isspace(_GraphExprStart[_KeyWordMult*5]))
    {
      pt = &_GraphExprStart[_KeyWordMult*5];
      _GraphToExtDiff = pt - _GraphExprExtension;
      _GraphToBrkDiff = 0;
    }
    else
      _GraphToExtDiff =
      _GraphToBrkDiff = 0;

    _GraphExprExtension = &_NewStr[_KeyWordMult*5];
    _LeftBrkStart = NULL;
  }

  return _GraphExprStart;
}

/****************************************************************************/
int CalcGraphPlotter::SendGraphWaitSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  int IoState_ = _CalcPtr ? _CalcPtr->GetIoState(0):0;

  if (_CalcPtr && _CalcPtr->InAsyncMode())
    IoState_ = _CalcPtr->SendGraphWaitSignal(Delay_, BreakAll_, DoHalt_);

  return IoState_;
}

/****************************************************************************/
int CalcGraphPlotter::SendGraphProgressSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  int IoState_ = _CalcPtr ? _CalcPtr->GetIoState(0):0;

  if (_CalcPtr && _CalcPtr->InAsyncMode())
    IoState_ = _CalcPtr->SendGraphProgressSignal(Delay_, BreakAll_, DoHalt_);

  return IoState_;
}

/****************************************************************************/
int CalcGraphPlotter::SendGraphOutputSignal(int Delay_, bool InBatch_,
                                            bool* BreakAll_, bool* DoHalt_, bool Retrying_)
{
  int IoState_ = _CalcPtr ? _CalcPtr->GetIoState(0):0;

  if (_CalcPtr && _CalcPtr->InAsyncMode() || _CalcPtr->SessionOption())
    IoState_ = _CalcPtr->SendGraphOutputSignal(Delay_, InBatch_, BreakAll_, DoHalt_, Retrying_);

  return IoState_;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphKeyWordMult(int Mult_)
{
  _KeyWordMult = Mult_;
}

/****************************************************************************/
void CalcGraphPlotter::SetExprString(char* pt)
{
  _ExprString = pt;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphExprStart(char* pt)
{
  _GraphExprStart = pt;
  _ExprToGraphDiff = 0;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphExprExtension(char* pt)
{
  _GraphExprExtension = pt;

  if (pt)
  {
    _LeftBrkStart = NULL;
    _GraphToBrkDiff = 0;
    _LeftBrk = false;
  }
  else if (_LeftBrkStart)
    _LeftBrk = true;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphLeftBrkStart(char* pt)
{
  _LeftBrkStart = pt;

  if (pt)
  {
    _GraphExprExtension = NULL;
    _GraphToExtDiff = 0;
    _LeftBrk = true;
  }
  else if (!_LeftBrkStart)
    _LeftBrk = false;
}

/****************************************************************************/
bool CalcGraphPlotter::IsGraphGlobalSwitch() const
{
  return
  (
    !_LeftBrk &&
    !_LeftBrkStart &&
    _GraphExprExtension != NULL &&
    _GraphExprStart != NULL
  );
}

/****************************************************************************/
int CalcGraphPlotter::GraphKeyWordMult() const
{
  return _KeyWordMult;
}

/****************************************************************************/
const char* CalcGraphPlotter::ExprString() const
{
  return _ExprString;
}

/****************************************************************************/
const char* CalcGraphPlotter::GraphExprStart() const
{
  return _GraphExprStart;
}

/****************************************************************************/
const char* CalcGraphPlotter::GraphExprExtension() const
{
  return _GraphExprExtension;
}

/****************************************************************************/
const char* CalcGraphPlotter::GraphLeftBrkStart() const
{
  return _LeftBrkStart;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphCompleted(bool flag_)
{
  _GraphCompleted = flag_;
}

/****************************************************************************/
bool CalcGraphPlotter::GraphCompleted() const
{
  return _GraphCompleted;
}

/****************************************************************************/
void CalcGraphPlotter::SetPlotGraph(bool flag_)
{
  _PlotGraph = flag_;
}

/****************************************************************************/
bool CalcGraphPlotter::DoPlotGraph() const
{
  return _PlotGraph;
}

/****************************************************************************/
void CalcGraphPlotter::SetGraphType(int Type_, int Subtype_)
{
  if (_CalcPtr)
    _CalcPtr->SetGraphType(Type_, Subtype_);
}

/****************************************************************************/
void CalcGraphPlotter::ReplaceGraphType(int Type_, int Subtype_)
{
  if (_CalcPtr)
    _CalcPtr->ReplaceGraphType(Type_, Subtype_);
}

/****************************************************************************/
const int* CalcGraphPlotter::GraphTypeVect() const
{
  return (_CalcPtr ? _CalcPtr->GraphTypeVect():NULL);
}

/****************************************************************************/
int CalcGraphPlotter::TotalGraphTypes() const
{
  return (_CalcPtr ? _CalcPtr->TotalGraphTypes():0);
}

/****************************************************************************/
void CalcGraphPlotter::AddGraphType(int Type_, int Subtype_)
{
  if (_CalcPtr)
    _CalcPtr->AddGraphType(Type_, Subtype_);
}

/****************************************************************************/
const int* CalcGraphPlotter::NextGraphTypeVect(int& Index_, bool IncrNext_) const
{
  return (_CalcPtr ? _CalcPtr->NextGraphTypeVect(Index_, IncrNext_):NULL);
}

/****************************************************************************/
bool CalcGraphPlotter::HasGraphType(int Type_, int Subtype_, bool Skip1st_) const
{
  return (_CalcPtr ? _CalcPtr->HasGraphType(Type_, Subtype_, Skip1st_):false);
}

/****************************************************************************/
int CalcGraphPlotter::GraphType() const
{
  return (_CalcPtr ? _CalcPtr->GraphType():0);
}

/****************************************************************************/
int CalcGraphPlotter::GraphSubtype() const
{
  return (_CalcPtr ? _CalcPtr->GraphSubtype():0);
}

/****************************************************************************/
void CalcGraphPlotter::SetPlottingGraph(bool flag_)
{
  _PlottingGraph = flag_;
}

/****************************************************************************/
bool CalcGraphPlotter::PlottingGraph() const
{
  return _PlottingGraph;
}

/****************************************************************************/
void CalcGraphPlotter::SetPlottingDone(bool flag_)
{
  _PlottingDone = flag_;
}

/****************************************************************************/
bool CalcGraphPlotter::PlottingDone() const
{
  return _PlottingDone;
}

/****************************************************************************/
void CalcGraphPlotter::SetPlotAllPoints(bool flag_)
{
  _PlotAllPoints = flag_;
}

/****************************************************************************/
bool CalcGraphPlotter::PlotAllPoints() const
{
  return _PlotAllPoints;
}

/****************************************************************************/
// FunctionValidityChecker class definitions
/****************************************************************************/
FunctionValidityChecker::FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                                                 int* delimpts_, int* absstrpospts_):
_Parent(Parent_),
_Next(NULL),
_Caller(Caller_),

_SavedSnapshot(NULL),
_SnapshotOwner(NULL),

_Adjacent(NULL),
_Sibling(NULL),
_HasSibling(delimpts_ != NULL && delimpts_[0]),
_SiblingIndexes(delimpts_),
_SiblingIndexSize(!delimpts_ ? 0:
                  Caller_ ? Caller_->_commaindexsize:0),

_LineRemaining(NULL),
_LineToProcess(NULL),
_OriginalLine(NULL),
_OperandRequired(false),
_NextOperandRequired(false),

_TokenType(0),
_TokenSubtype(0),
_Levels(Caller_ ? (Caller_->_Levels + 1):0),
_Valid(false),
_Checked(0),
_MaxToCheck(FNCVALID_MAXTOCHECK),
_LineNumber(0),
_StopOnNumber(0),

_commaindexes(NULL),
_commaindexsize(10),

_startpt(Caller_ ? (Caller_->_openbrkpt+1):NULL),
_openbrkpt(NULL),
_closebrkpt(NULL),
_endpt(Caller_ ? ((delimpts_ != NULL && delimpts_[0]) ?
                    (Caller_->_startpt+delimpts_[0]-1):
                    (Caller_->_closebrkpt-1)):NULL),
_ChkStrOmitTxtStr(NULL),
_OriginalStr(NULL),

_openbrkcnt(Caller_ ? (Caller_->_openbrkcnt):0),
_closebrkcnt(Caller_ ? (Caller_->_closebrkcnt):0),

_SingleArgFnc(false),
_DoubleArgFnc(false),
_TripleArgFnc(false),
_FourArgFnc(false),
_FiveArgFnc(false),
_SixArgFnc(false),
_VaryArgFnc(false),
_FncPrecForSingleArgFncs(false),
_FncPrecForVaryArgFncs(false),

_IgnoredCmd(Caller_ ? Caller_->_IgnoredCmd:false),
_IsOperand(false),
_IsConstVal(false),
_IsOperandVal(false),
_IsUnaryExpr(false),
_IsBinaryExpr(false),
_BracketedExpr(false),
_OperandNeeded(false),
_FunctionMatched(false),
_FracOpFound(false),
_VarxAllowed(Caller_ ? (Caller_->_VarxAllowed):false),

_ErrorCode(0),
_ChkFrac(false),

_ChkStrCase(NULL),
_ChkStrOmit(Caller_ ? NULL:(new BitVector(10))),
_ChkStrCasePtr(Caller_ ? (Caller_->_ChkStrCase ? Caller_->_ChkStrCase:
                                                 Caller_->_ChkStrCasePtr):NULL),
_ChkStrOmitPtr(Caller_ ? (Caller_->_ChkStrOmit ? Caller_->_ChkStrOmit:
                                                 Caller_->_ChkStrOmitPtr):NULL),
_AbsChkStrIndex(Caller_ ? (absstrpospts_ ? absstrpospts_[0]:
                                           Caller_->_AbsChkStrIndex):0),
_SavedChkStrIndex(0),
_RelChkStrIndex(0),
_LastChkStrIndex(0),
_ChkStrSize(Caller_ ? Caller_->_ChkStrSize:10),
_SpecialCaseIndex(NOT_SPECIALCASE),
_SpecialCaseLen(0),
_ExcludedCaseIndex(NOT_EXCLUDEDCASE),
_ExcludedCaseLen(0),
_LastChkStrIndexSaved(false),

_AbsStrPosIndexes(NULL),
_AbsStrPosIndexSize(10),
_SiblingAbsStrPosIndexes(absstrpospts_),
_SiblingAbsStrPosIndexSize(Caller_ ? Caller_->_AbsStrPosIndexSize:0),

_MemDel(new DelayedMemoryDeleter)
{
  ++_Instances;
  CreateStaticMembers(_Parent);

  if (_Parent)
  {
    _commaindexes = (int*)(_Parent->allocmem(_commaindexsize, sizeof(int), _commaindexes));
    ::memset(_commaindexes, 0, sizeof(int) * _commaindexsize);

    _AbsStrPosIndexes = (int*)(_Parent->allocmem(_AbsStrPosIndexSize, sizeof(int), _AbsStrPosIndexes));
    ::memset(_AbsStrPosIndexes, 0, sizeof(int) * _AbsStrPosIndexSize);

    if (!Caller_ && _ChkStrOmit && _ChkStrSize && !_ChkStrCasePtr)
    {
      _ChkStrCase = (short*)(_Parent->allocmem(_ChkStrSize, sizeof(short), _ChkStrCase));
      ::memset(_ChkStrCase, 0, sizeof(short) * _ChkStrSize);
    }
  }

  _HasSibling = HasSibling(Caller_);
  _SiblingIndexSize = FindSiblingIndexSize();

  if (_HasSibling)
    SetSibling(MakeSibling(_Parent, _Caller, this,
			   (delimpts_ != NULL && delimpts_[1]) ? &delimpts_[1]:NULL,
			   (absstrpospts_ != NULL && absstrpospts_[1]) ? &absstrpospts_[1]:NULL), delimpts_, absstrpospts_);
  else
    SetSibling(NULL, NULL, NULL);
}

/****************************************************************************/
FunctionValidityChecker::FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                                                 FunctionValidityChecker* Adjacent_, int* delimpts_, int* absstrpospts_):
_Parent(Parent_),
_Next(NULL),
_Caller(Caller_),

_SavedSnapshot(NULL),
_SnapshotOwner(NULL),

_Adjacent(Adjacent_),
_Sibling(NULL),
_HasSibling(delimpts_ != NULL && delimpts_[0]),
_SiblingIndexes(delimpts_),
_SiblingIndexSize(!delimpts_ ? 0:
                  Adjacent_ ? (Adjacent_->SiblingIndexSize() - 1):
                  Caller_ ? Caller_->_commaindexsize:0),

_LineRemaining(NULL),
_LineToProcess(NULL),
_OriginalLine(NULL),
_OperandRequired(false),
_NextOperandRequired(false),

_TokenType(0),
_TokenSubtype(0),
_Levels(Adjacent_ ? Adjacent_->_Levels:0),
_Valid(false),
_Checked(0),
_MaxToCheck(FNCVALID_MAXTOCHECK),
_LineNumber(0),
_StopOnNumber(0),

_commaindexes(NULL),
_commaindexsize(10),

_startpt((Adjacent_ && Adjacent_->HasSibling(Caller_)) ? (Adjacent_->_endpt+2):NULL),
_openbrkpt(NULL),
_closebrkpt(NULL),
_endpt(Caller_ ? ((delimpts_ != NULL && delimpts_[0]) ?
                    (Caller_->_startpt+delimpts_[0]-1):
                    (Caller_->_closebrkpt-1)):NULL),
_ChkStrOmitTxtStr(NULL),
_OriginalStr(NULL),

_openbrkcnt(Caller_ ? (Caller_->_openbrkcnt):0),
_closebrkcnt(Caller_ ? (Caller_->_closebrkcnt):0),

_SingleArgFnc(false),
_DoubleArgFnc(false),
_TripleArgFnc(false),
_FourArgFnc(false),
_FiveArgFnc(false),
_SixArgFnc(false),
_VaryArgFnc(false),
_FncPrecForSingleArgFncs(false),
_FncPrecForVaryArgFncs(false),

_IgnoredCmd(Caller_ ? Caller_->_IgnoredCmd:false),
_IsOperand(false),
_IsConstVal(false),
_IsOperandVal(false),
_IsUnaryExpr(false),
_IsBinaryExpr(false),
_BracketedExpr(false),
_OperandNeeded(false),
_FunctionMatched(false),
_FracOpFound(false),
_VarxAllowed(Caller_ ? (Caller_->_VarxAllowed):false),

_ErrorCode(0),
_ChkFrac(false),

_ChkStrCase(NULL),
_ChkStrOmit(Caller_ ? NULL:(new BitVector(10))),
_ChkStrCasePtr(Caller_ ? (Caller_->_ChkStrCase ? Caller_->_ChkStrCase:
                                                 Caller_->_ChkStrCasePtr):NULL),
_ChkStrOmitPtr(Caller_ ? (Caller_->_ChkStrOmit ? Caller_->_ChkStrOmit:
                                                 Caller_->_ChkStrOmitPtr):NULL),
_AbsChkStrIndex(Caller_ ? (absstrpospts_ ? absstrpospts_[0]:
                                           Caller_->_AbsChkStrIndex):0),
_SavedChkStrIndex(0),
_RelChkStrIndex(0),
_LastChkStrIndex(0),
_ChkStrSize(Caller_ ? Caller_->_ChkStrSize:10),
_SpecialCaseIndex(NOT_SPECIALCASE),
_SpecialCaseLen(0),
_ExcludedCaseIndex(NOT_EXCLUDEDCASE),
_ExcludedCaseLen(0),
_LastChkStrIndexSaved(false),

_AbsStrPosIndexes(NULL),
_AbsStrPosIndexSize(10),
_SiblingAbsStrPosIndexes(absstrpospts_),
_SiblingAbsStrPosIndexSize(Adjacent_ ? (Adjacent_->SiblingAbsStrPosIndexSize() - 1):0),

_MemDel(new DelayedMemoryDeleter)
{
  ++_Instances;
  CreateStaticMembers(_Parent);

  if (_Parent)
  {
    _commaindexes = (int*)(_Parent->allocmem(_commaindexsize, sizeof(int), _commaindexes));
    ::memset(_commaindexes, 0, sizeof(int) * _commaindexsize);

    _AbsStrPosIndexes = (int*)(_Parent->allocmem(_AbsStrPosIndexSize, sizeof(int), _AbsStrPosIndexes));
    ::memset(_AbsStrPosIndexes, 0, sizeof(int) * _AbsStrPosIndexSize);

    if (!Caller_ && _ChkStrOmit && _ChkStrSize && !_ChkStrCasePtr)
    {
      _ChkStrCase = (short*)(_Parent->allocmem(_ChkStrSize, sizeof(short), _ChkStrCase));
      ::memset(_ChkStrCase, 0, sizeof(short) * _ChkStrSize);
    }
  }

  _HasSibling = HasSibling(Caller_);
  _SiblingIndexSize = FindSiblingIndexSize();

  if (_HasSibling)
    SetSibling(MakeSibling(_Parent, _Caller, this,
			   (delimpts_ != NULL && delimpts_[1]) ? &delimpts_[1]:NULL,
			   (absstrpospts_ != NULL && absstrpospts_[1]) ? &absstrpospts_[1]:NULL), delimpts_, absstrpospts_);
  else
    SetSibling(NULL, NULL, NULL);
}

/****************************************************************************/
FunctionValidityChecker::FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker& Obj_):
_Parent(Parent_),
_Next(Obj_._Next),
_Caller(Obj_._Caller),

_SavedSnapshot(NULL),
_SnapshotOwner(&Obj_),

_Adjacent(Obj_._Adjacent),
_Sibling(Obj_._Sibling),
_HasSibling(Obj_._HasSibling),
_SiblingIndexes(Obj_._SiblingIndexes),
_SiblingIndexSize(Obj_._SiblingIndexSize),

_LineRemaining(Obj_._LineRemaining),
_LineToProcess(Obj_._LineToProcess),
_OriginalLine(Obj_._OriginalLine),
_OperandRequired(Obj_._OperandRequired),
_NextOperandRequired(Obj_._NextOperandRequired),

_TokenType(Obj_._TokenType),
_TokenSubtype(Obj_._TokenSubtype),
_Levels(Obj_._Levels),
_Valid(false),
_Checked(Obj_._Checked),
_MaxToCheck(Obj_._MaxToCheck),
_LineNumber(Obj_._LineNumber),
_StopOnNumber(Obj_._StopOnNumber),

_commaindexes(Obj_._commaindexes),
_commaindexsize(Obj_._commaindexsize),

_startpt(Obj_._startpt),
_openbrkpt(Obj_._openbrkpt),
_closebrkpt(Obj_._closebrkpt),
_endpt(Obj_._endpt),
_ChkStrOmitTxtStr(NULL),
_OriginalStr(NULL),

_openbrkcnt(Obj_._openbrkcnt),
_closebrkcnt(Obj_._closebrkcnt),

_SingleArgFnc(Obj_._SingleArgFnc),
_DoubleArgFnc(Obj_._DoubleArgFnc),
_TripleArgFnc(Obj_._TripleArgFnc),
_FourArgFnc(Obj_._FourArgFnc),
_FiveArgFnc(Obj_._FiveArgFnc),
_SixArgFnc(Obj_._SixArgFnc),
_VaryArgFnc(Obj_._VaryArgFnc),
_FncPrecForSingleArgFncs(Obj_._FncPrecForSingleArgFncs),
_FncPrecForVaryArgFncs(Obj_._FncPrecForVaryArgFncs),

_IgnoredCmd(Obj_._IgnoredCmd),
_IsOperand(Obj_._IsOperand),
_IsConstVal(Obj_._IsConstVal),
_IsOperandVal(Obj_._IsOperandVal),
_IsUnaryExpr(Obj_._IsUnaryExpr),
_IsBinaryExpr(Obj_._IsBinaryExpr),
_BracketedExpr(Obj_._BracketedExpr),
_OperandNeeded(Obj_._OperandNeeded),
_FunctionMatched(Obj_._FunctionMatched),
_FracOpFound(Obj_._FracOpFound),
_VarxAllowed(Obj_._VarxAllowed),

_ErrorCode(0),
_ChkFrac(Obj_._ChkFrac),

_ChkStrCase(Obj_._ChkStrCase),
_ChkStrOmit(Obj_._ChkStrOmit),
_ChkStrCasePtr(Obj_._ChkStrCasePtr),
_ChkStrOmitPtr(Obj_._ChkStrOmitPtr),
_AbsChkStrIndex(Obj_._AbsChkStrIndex),
_SavedChkStrIndex(Obj_._SavedChkStrIndex),
_RelChkStrIndex(Obj_._RelChkStrIndex),
_LastChkStrIndex(Obj_._LastChkStrIndex),
_ChkStrSize(Obj_._ChkStrSize),
_SpecialCaseIndex(Obj_._SpecialCaseIndex),
_SpecialCaseLen(Obj_._SpecialCaseLen),
_ExcludedCaseIndex(Obj_._ExcludedCaseIndex),
_ExcludedCaseLen(Obj_._ExcludedCaseLen),
_LastChkStrIndexSaved(Obj_._LastChkStrIndexSaved),

_AbsStrPosIndexes(Obj_._AbsStrPosIndexes),
_AbsStrPosIndexSize(Obj_._AbsStrPosIndexSize),
_SiblingAbsStrPosIndexes(Obj_._SiblingAbsStrPosIndexes),
_SiblingAbsStrPosIndexSize(Obj_._SiblingAbsStrPosIndexSize),

_MemDel(new DelayedMemoryDeleter)
{
  ++_Instances;
  CreateStaticMembers(_Parent);

  if (_Parent)
  {
    if (_commaindexsize && Obj_._commaindexes)
    {
      _commaindexes = (int*)(_Parent->allocmem(_commaindexsize, sizeof(int), _commaindexes));
      ::memmove(_commaindexes, Obj_._commaindexes, sizeof(int) * _commaindexsize);
    }
    else
      _commaindexes = NULL;

    if (_AbsStrPosIndexSize && Obj_._AbsStrPosIndexes)
    {
      _AbsStrPosIndexes = (int*)(_Parent->allocmem(_AbsStrPosIndexSize, sizeof(int), _AbsStrPosIndexes));
      ::memmove(_AbsStrPosIndexes, Obj_._AbsStrPosIndexes, sizeof(int) * _AbsStrPosIndexSize);
    }
    else
      _AbsStrPosIndexes = NULL;

    if (!_Caller && _ChkStrOmit && _ChkStrSize && !_ChkStrCasePtr && Obj_._ChkStrCase)
    {
      _ChkStrCase = (short*)(_Parent->allocmem(_ChkStrSize, sizeof(short), _ChkStrCase));
      ::memmove(_ChkStrCase, Obj_._ChkStrCase, sizeof(short) * _ChkStrSize);
    }
    else
      _ChkStrCase = NULL;
  }

  _HasSibling = HasSibling(_Caller);
  _SiblingIndexSize = FindSiblingIndexSize();

  if (_HasSibling)
    _Sibling = Obj_._Sibling;
  else
    _Sibling = NULL;
}

/****************************************************************************/
FunctionValidityChecker::FunctionValidityChecker(CalculatorBase* Parent_):
_Parent(Parent_),
_Next(NULL),
_Caller(NULL),

_SavedSnapshot(NULL),
_SnapshotOwner(NULL),

_Adjacent(NULL),
_Sibling(NULL),
_HasSibling(false),
_SiblingIndexes(NULL),
_SiblingIndexSize(0),

_LineRemaining(NULL),
_LineToProcess(NULL),
_OriginalLine(NULL),
_OperandRequired(false),
_NextOperandRequired(false),

_TokenType(0),
_TokenSubtype(0),
_Levels(0),
_Valid(false),
_Checked(0),
_MaxToCheck(FNCVALID_MAXTOCHECK),
_LineNumber(0),
_StopOnNumber(0),

_commaindexes(NULL),
_commaindexsize(10),

_startpt(NULL),
_openbrkpt(NULL),
_closebrkpt(NULL),
_endpt(NULL),
_ChkStrOmitTxtStr(NULL),
_OriginalStr(NULL),

_openbrkcnt(0),
_closebrkcnt(0),

_SingleArgFnc(false),
_DoubleArgFnc(false),
_TripleArgFnc(false),
_FourArgFnc(false),
_FiveArgFnc(false),
_SixArgFnc(false),
_VaryArgFnc(false),
_FncPrecForSingleArgFncs(false),
_FncPrecForVaryArgFncs(false),

_IgnoredCmd(false),
_IsOperand(false),
_IsConstVal(false),
_IsOperandVal(false),
_IsUnaryExpr(false),
_IsBinaryExpr(false),
_BracketedExpr(false),
_OperandNeeded(false),
_FunctionMatched(false),
_FracOpFound(false),
_VarxAllowed(false),

_ErrorCode(0),
_ChkFrac(false),

_ChkStrCase(NULL),
_ChkStrOmit(new BitVector(10)),
_ChkStrCasePtr(NULL),
_ChkStrOmitPtr(NULL),
_AbsChkStrIndex(0),
_SavedChkStrIndex(0),
_RelChkStrIndex(0),
_LastChkStrIndex(0),
_ChkStrSize(10),
_SpecialCaseIndex(NOT_SPECIALCASE),
_SpecialCaseLen(0),
_ExcludedCaseIndex(NOT_EXCLUDEDCASE),
_ExcludedCaseLen(0),
_LastChkStrIndexSaved(false),

_AbsStrPosIndexes(NULL),
_AbsStrPosIndexSize(10),
_SiblingAbsStrPosIndexes(NULL),
_SiblingAbsStrPosIndexSize(0),

_MemDel(new DelayedMemoryDeleter)
{
  ++_Instances;
  CreateStaticMembers(_Parent);

  if (_Parent)
  {
    _commaindexes = (int*)(_Parent->allocmem(_commaindexsize, sizeof(int), _commaindexes));
    ::memset(_commaindexes, 0, sizeof(int) * _commaindexsize);

    _AbsStrPosIndexes = (int*)(_Parent->allocmem(_AbsStrPosIndexSize, sizeof(int), _AbsStrPosIndexes));
    ::memset(_AbsStrPosIndexes, 0, sizeof(int) * _AbsStrPosIndexSize);

    if (_ChkStrOmit && _ChkStrSize)
    {
      _ChkStrCase = (short*)(_Parent->allocmem(_ChkStrSize, sizeof(short), _ChkStrCase));
      ::memset(_ChkStrCase, 0, sizeof(short) * _ChkStrSize);
    }
  }
}

/****************************************************************************/
FunctionValidityChecker::~FunctionValidityChecker()
{
  --_Instances;
  if (!_SnapshotOwner)
    DestroyStaticMembers(_Parent);

  if (!_SnapshotOwner)
  {
    if (_commaindexes && _commaindexsize)
    {
      MemMatrix::Matrix().Deallocate(_commaindexes);
      _commaindexes = NULL;
      _commaindexsize = 0;
    }

    if (_AbsStrPosIndexes && _AbsStrPosIndexSize)
    {
      MemMatrix::Matrix().Deallocate(_AbsStrPosIndexes);
      _AbsStrPosIndexes = NULL;
      _AbsStrPosIndexSize = 0;
    }

    SetNext(NULL);
    SetSibling(NULL, NULL, NULL);

    if (!_ChkStrCasePtr && _ChkStrCase && _ChkStrSize)
    {
      MemMatrix::Matrix().Deallocate(_ChkStrCase);
      _ChkStrCase = NULL;
    }

    if (!_ChkStrOmitPtr && _ChkStrOmit)
    {
      delete _ChkStrOmit;
      _ChkStrOmit = NULL;
    }

    if (_SavedSnapshot)
    {
      delete _SavedSnapshot;
      _SavedSnapshot = NULL;
    }

    _ChkStrOmitPtr = NULL;
  }
  else
  {
    if (_commaindexes && _commaindexsize)
    {
      MemMatrix::Matrix().Deallocate(_commaindexes);
      _commaindexes = NULL;
      _commaindexsize = 0;
    }

    if (_AbsStrPosIndexes && _AbsStrPosIndexSize)
    {
      MemMatrix::Matrix().Deallocate(_AbsStrPosIndexes);
      _AbsStrPosIndexes = NULL;
      _AbsStrPosIndexSize = 0;
    }

    _Next = NULL;
    _Sibling = NULL;

    if (!_ChkStrCasePtr && _ChkStrCase && _ChkStrSize)
    {
      MemMatrix::Matrix().Deallocate(_ChkStrCase);
      _ChkStrCase = NULL;
    }

    _ChkStrOmit = NULL;
    _ChkStrOmitPtr = NULL;

    _SavedSnapshot = NULL;
    _ChkStrOmitPtr = NULL;
  }

  if (_ChkStrOmitTxtStr)
  {
    MemMatrix::Matrix().Deallocate(_ChkStrOmitTxtStr);
    _ChkStrOmitTxtStr = NULL;
  }

  if (_OriginalStr)
  {
    MemMatrix::Matrix().Deallocate(_OriginalStr);
    _OriginalStr = NULL;
  }

  delete _MemDel;
  _MemDel = NULL;
}

/****************************************************************************/
bool FunctionValidityChecker::CreateStaticMembers(CalculatorBase* Parent_)
{
  if (Parent_ && _Instances == 1)
  {
    int* iPtr = NULL;
    _ErrorMessageList = (char**)(Parent_->allocmem(MAX_ERROR_CODES+1, sizeof(char*), _ErrorMessageList));
    _SingleArgFncList = (char**)(Parent_->allocmem(MAX_SINGLEARG_FNCS+1, sizeof(char*), _SingleArgFncList));
    _DoubleArgFncList = (char**)(Parent_->allocmem(MAX_DOUBLEARG_FNCS+1, sizeof(char*), _DoubleArgFncList));
    _TripleArgFncList = (char**)(Parent_->allocmem(MAX_TRIPLEARG_FNCS+1, sizeof(char*), _TripleArgFncList));
    _FourArgFncList = (char**)(Parent_->allocmem(MAX_FOURARG_FNCS+1, sizeof(char*), _FourArgFncList));
    _FiveArgFncList = (char**)(Parent_->allocmem(MAX_FIVEARG_FNCS+1, sizeof(char*), _FiveArgFncList));
    _SixArgFncList = (char**)(Parent_->allocmem(MAX_SIXARG_FNCS+1, sizeof(char*), _SixArgFncList));
    _VaryArgFncList = (char**)(Parent_->allocmem(MAX_VARYARG_FNCS+1, sizeof(char*), _VaryArgFncList));
    _MultiArgFncList = (char**)(Parent_->allocmem(MAX_MULTIARG_FNCS+1, sizeof(char*), _MultiArgFncList));
    _UnaryOpList = (char**)(Parent_->allocmem(MAX_UNARY_OPS+1, sizeof(char*), _UnaryOpList));
    _BinaryOpList = (char**)(Parent_->allocmem(MAX_BINARY_OPS+1, sizeof(char*), _BinaryOpList));
    _ConstsAndVars = (char**)(Parent_->allocmem(MAX_CONSTANTS+1, sizeof(char*), _ConstsAndVars));
    _FracOpList = (char**)(Parent_->allocmem(MAX_FRAC_OPS+1, sizeof(char*), _FracOpList));
    _ExcludedFncList = (char**)(Parent_->allocmem(MAX_EXCLUDED_FNCS+1, sizeof(char*), _ExcludedFncList));
    _MultiArgChkList = (int**)(Parent_->allocmem(MAX_MULTIARG_FNCS+1, sizeof(int*), _MultiArgChkList));
    _AlmostFncList = (char**)(Parent_->allocmem(MAX_ALMOST_FNCS+1, sizeof(char*), _AlmostFncList));
    _SpecialCaseList = (char**)(Parent_->allocmem(MAX_SPECIAL_CASES+1, sizeof(char*), _SpecialCaseList));
    _VarxFncList = (char**)(Parent_->allocmem(MAX_VARX_FNCS+1, sizeof(char*), _VarxFncList));
    _ChkFncPrecList = (char**)(Parent_->allocmem(MAX_CHKFNCPREC_FNCS+1, sizeof(char*), _ChkFncPrecList));

    _NumberStrs = (char**)(Parent_->allocmem(LISTINCR, sizeof(char*), _NumberStrs));
    _NumberListSize = LISTINCR;
    _NumNumbers = 0;

    int x = 0;
    for (x = 0; x < _NumberListSize; x++)
      _NumberStrs[x] = NULL;

    x = 0;
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_INVALID_FUNCTIONS);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_INVALID_VARIABLES);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_MISSING_RIGHT_BRACKET);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_MISSING_LEFT_BRACKET);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_FRACTION_OP_EXPECTED);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_MISSING_RIGHT_BRACE);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_MISSING_CLOSING_QUOTE);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_MISSING_REQUIRED_OPERAND);
    _ErrorMessageList[x++] = ::NewString(FVC_ERRMSG_INVALID_EXPRESSION);
    _ErrorMessageList[x] = NULL;

    x = 0;
    _SingleArgFncList[x++] = ::NewString("FROMCMP2BIN");
    _SingleArgFncList[x++] = ::NewString("TOCMP2BIN");
    _SingleArgFncList[x++] = ::NewString("FROMHEX");
    _SingleArgFncList[x++] = ::NewString("FROMOCT");
    _SingleArgFncList[x++] = ::NewString("FROMBIN");
    _SingleArgFncList[x++] = ::NewString("AVGMEAN");
    _SingleArgFncList[x++] = ::NewString("AVGMODE");
    _SingleArgFncList[x++] = ::NewString("SHOWSET");
    _SingleArgFncList[x++] = ::NewString("AVGMED");
    _SingleArgFncList[x++] = ::NewString("STDDEV");
    _SingleArgFncList[x++] = ::NewString("FLOOR");
    _SingleArgFncList[x++] = ::NewString("TOHEX");
    _SingleArgFncList[x++] = ::NewString("TOOCT");
    _SingleArgFncList[x++] = ::NewString("TOBIN");
    _SingleArgFncList[x++] = ::NewString("CEIL");
    _SingleArgFncList[x++] = ::NewString("RAND");
    _SingleArgFncList[x++] = ::NewString("PROD");
    _SingleArgFncList[x++] = ::NewString("EVAL");
    _SingleArgFncList[x++] = ::NewString("SHOW"); // almost: SHOWSET
    _SingleArgFncList[x++] = ::NewString("INV");
    _SingleArgFncList[x++] = ::NewString("SUM");
    _SingleArgFncList[x++] = ::NewString("SET");  // almost: SETINT, SETUNI, SETDIF, SETXDIF
    _SingleArgFncList[x++] = ::NewString("MIN");
    _SingleArgFncList[x++] = ::NewString("MAX");
    _SingleArgFncList[x] = NULL;

    x = 0;
    _DoubleArgFncList[x++] = ::NewString("TOCMP2BIN");
    _DoubleArgFncList[x++] = ::NewString("RECTOPOLR");
    _DoubleArgFncList[x++] = ::NewString("RECTOPOLA");
    _DoubleArgFncList[x++] = ::NewString("POLTORECX");
    _DoubleArgFncList[x++] = ::NewString("POLTORECY");
    _DoubleArgFncList[x++] = ::NewString("COMBREP");
    _DoubleArgFncList[x++] = ::NewString("PERMREP");
    _DoubleArgFncList[x++] = ::NewString("GRAPH");
    _DoubleArgFncList[x++] = ::NewString("ROUND");
    _DoubleArgFncList[x++] = ::NewString("COMB");  // almost: COMBREP
    _DoubleArgFncList[x++] = ::NewString("PERM");  // almost: PERMRET
    _DoubleArgFncList[x++] = ::NewString("MIN");
    _DoubleArgFncList[x++] = ::NewString("MAX");
    _DoubleArgFncList[x++] = ::NewString("SET");
    _DoubleArgFncList[x] = NULL;

    x = 0;
    _TripleArgFncList[x++] = ::NewString("SETXDIF");
    _TripleArgFncList[x++] = ::NewString("DERIV2");
    _TripleArgFncList[x++] = ::NewString("SETUNI");
    _TripleArgFncList[x++] = ::NewString("SETINT");
    _TripleArgFncList[x++] = ::NewString("SETDIF");
    _TripleArgFncList[x++] = ::NewString("DERIV");  // almost: DERIV2
    _TripleArgFncList[x++] = ::NewString("SOLVE");
    _TripleArgFncList[x] = NULL;

    x = 0;
    _FourArgFncList[x++] = ::NewString("INTERSECT");
    _FourArgFncList[x++] = ::NewString("DERIV2");
    _FourArgFncList[x++] = ::NewString("INTEG");
    _FourArgFncList[x++] = ::NewString("DERIV");
    _FourArgFncList[x++] = ::NewString("FMIN");
    _FourArgFncList[x++] = ::NewString("FMAX");
    _FourArgFncList[x] = NULL;

    x = 0;
    _FiveArgFncList[x++] = ::NewString("INTERSECT");
    _FiveArgFncList[x++] = ::NewString("INTEG");
    _FiveArgFncList[x++] = ::NewString("SOLVE");
    _FiveArgFncList[x++] = ::NewString("FMIN");
    _FiveArgFncList[x++] = ::NewString("FMAX");
    _FiveArgFncList[x] = NULL;

    x = 0;
    _SixArgFncList[x++] = ::NewString("FMIN");
    _SixArgFncList[x++] = ::NewString("FMAX");
    _SixArgFncList[x] = NULL;

    x = 0;
    _VaryArgFncList[x++] = ::NewString("ITEMCOMBREP");
    _VaryArgFncList[x++] = ::NewString("ITEMPERMREP");
    _VaryArgFncList[x++] = ::NewString("ITEMCOMB");  // almost: ITEMCOMBREP
    _VaryArgFncList[x++] = ::NewString("ITEMPERM");  // almost: ITEMPERMREP
    _VaryArgFncList[x++] = ::NewString("MATSOLVE");
    _VaryArgFncList[x++] = ::NewString("AVGMEAN");
    _VaryArgFncList[x++] = ::NewString("AVGMODE");
    _VaryArgFncList[x++] = ::NewString("AVGMED");
    _VaryArgFncList[x++] = ::NewString("STDDEV");
    _VaryArgFncList[x++] = ::NewString("GRAPH");
    _VaryArgFncList[x++] = ::NewString("FRAC");      // almost: FRACANS, FRACPART
    _VaryArgFncList[x++] = ::NewString("PROD");
    _VaryArgFncList[x++] = ::NewString("SUM");
    _VaryArgFncList[x++] = ::NewString("SET");
    _VaryArgFncList[x++] = ::NewString("MIN");
    _VaryArgFncList[x++] = ::NewString("MAX");
    _VaryArgFncList[x] = NULL;

    x = 0;
    _MultiArgFncList[x++] = ::NewString("TOCMP2BIN");
    _MultiArgFncList[x++] = ::NewString("INTERSECT");
    _MultiArgFncList[x++] = ::NewString("DERIV2");
    _MultiArgFncList[x++] = ::NewString("DERIV");
    _MultiArgFncList[x++] = ::NewString("INTEG");
    _MultiArgFncList[x++] = ::NewString("SOLVE");
    _MultiArgFncList[x++] = ::NewString("FMIN");
    _MultiArgFncList[x++] = ::NewString("FMAX");
    _MultiArgFncList[x] = NULL;

    for (x = 0; x < MAX_MULTIARG_FNCS; x++)
    {
      iPtr = _MultiArgChkList[x];
      _MultiArgChkList[x] = (int*)(Parent_->allocmem(MAX_MULTIARG_CHKS+1, sizeof(int), iPtr));
    }

    _MultiArgChkList[x] = NULL;
    ResetMultiArgChks();

    x = 0;
    _FracOpList[x++] = ::NewString("MULTIPLY");
    _FracOpList[x++] = ::NewString("SUBTRACT");
    _FracOpList[x++] = ::NewString("DIVIDE");
    _FracOpList[x++] = ::NewString("ADD");
    _FracOpList[x++] = ::NewString("+");
    _FracOpList[x++] = ::NewString("-");
    _FracOpList[x++] = ::NewString("*");
    _FracOpList[x++] = ::NewString("/");
    _FracOpList[x] = NULL;

    x = 0;
    _UnaryOpList[x++] = ::NewString("FRACPART");
    _UnaryOpList[x++] = ::NewString("INTPART");
    _UnaryOpList[x++] = ::NewString("CUBERT");
    _UnaryOpList[x++] = ::NewString("ARCSIN");
    _UnaryOpList[x++] = ::NewString("ARCCOS");
    _UnaryOpList[x++] = ::NewString("ARCTAN");
    _UnaryOpList[x++] = ::NewString("FLOOR");
    _UnaryOpList[x++] = ::NewString("LOG10");
    _UnaryOpList[x++] = ::NewString("ASIN");
    _UnaryOpList[x++] = ::NewString("ACOS");
    _UnaryOpList[x++] = ::NewString("ATAN");
    _UnaryOpList[x++] = ::NewString("SINH");
    _UnaryOpList[x++] = ::NewString("COSH");
    _UnaryOpList[x++] = ::NewString("TANH");
    _UnaryOpList[x++] = ::NewString("CEIL");
    _UnaryOpList[x++] = ::NewString("SQRT");
    _UnaryOpList[x++] = ::NewString("CUBE");  // almost CUBERT
    _UnaryOpList[x++] = ::NewString("RAND");
    _UnaryOpList[x++] = ::NewString("FACT");
    _UnaryOpList[x++] = ::NewString("SIN");   // almost SINH
    _UnaryOpList[x++] = ::NewString("COS");   // almost COSH
    _UnaryOpList[x++] = ::NewString("TAN");   // almost TANH
    _UnaryOpList[x++] = ::NewString("RND");
    _UnaryOpList[x++] = ::NewString("EXP");
    _UnaryOpList[x++] = ::NewString("LOG");   // almost LOG10
    _UnaryOpList[x++] = ::NewString("ABS");
    _UnaryOpList[x++] = ::NewString("SQR");   // almost SQRT
    _UnaryOpList[x++] = ::NewString("INV");
    _UnaryOpList[x++] = ::NewString("GRAPH");  // no brk required
    _UnaryOpList[x++] = ::NewString("NOT");    // no brk required
    _UnaryOpList[x++] = ::NewString("-");      // no brk operators...
    _UnaryOpList[x++] = ::NewString("+");
    _UnaryOpList[x] = NULL;

    x = 0;
    _BinaryOpList[x++] = ::NewString("COMBREP");
    _BinaryOpList[x++] = ::NewString("PERMREP");
    _BinaryOpList[x++] = ::NewString("COMB");
    _BinaryOpList[x++] = ::NewString("PERM");
    _BinaryOpList[x++] = ::NewString("XOR");   // no brk required
    _BinaryOpList[x++] = ::NewString("AND");   // no brk required
    _BinaryOpList[x++] = ::NewString("OR");    // no brk required
    _BinaryOpList[x++] = ::NewString("E");     // no brk required
    _BinaryOpList[x++] = ::NewString("<=");    // no brk operators...
    _BinaryOpList[x++] = ::NewString(">=");
    _BinaryOpList[x++] = ::NewString("==");
    _BinaryOpList[x++] = ::NewString("!=");
    _BinaryOpList[x++] = ::NewString("-=");
    _BinaryOpList[x++] = ::NewString("+=");
    _BinaryOpList[x++] = ::NewString("*=");
    _BinaryOpList[x++] = ::NewString("/=");
    _BinaryOpList[x++] = ::NewString("@=");
    _BinaryOpList[x++] = ::NewString("&=");
    _BinaryOpList[x++] = ::NewString("|=");
    _BinaryOpList[x++] = ::NewString("=");
    _BinaryOpList[x++] = ::NewString("-");
    _BinaryOpList[x++] = ::NewString("+");
    _BinaryOpList[x++] = ::NewString("*");
    _BinaryOpList[x++] = ::NewString("/");
    _BinaryOpList[x++] = ::NewString("@");
    _BinaryOpList[x++] = ::NewString("^");
    _BinaryOpList[x++] = ::NewString("<");
    _BinaryOpList[x++] = ::NewString(">");
    _BinaryOpList[x] = NULL;

    x = 0;
    _ConstsAndVars[x++] = ::NewString("EXCLUDEENDS");
    _ConstsAndVars[x++] = ::NewString("FRACANS");
    _ConstsAndVars[x++] = ::NewString("ANSSTR");
    _ConstsAndVars[x++] = ::NewString("ANS");  // almost: ANSSTR
    _ConstsAndVars[x++] = ::NewString("+inf");
    _ConstsAndVars[x++] = ::NewString("-inf");
    _ConstsAndVars[x++] = ::NewString("nan");
    _ConstsAndVars[x++] = ::NewString("PI");
    _ConstsAndVars[x++] = ::NewString("e");   // almost: EVAL,EXP,EXEC,EXCLUDEENDS
    _ConstsAndVars[x++] = ::NewString("x");   // almost: XOR
    _ConstsAndVars[x++] = ::NewString("$A");
    _ConstsAndVars[x++] = ::NewString("$B");
    _ConstsAndVars[x++] = ::NewString("$C");
    _ConstsAndVars[x++] = ::NewString("$D");
    _ConstsAndVars[x++] = ::NewString("$E");
    _ConstsAndVars[x++] = ::NewString("$F");
    _ConstsAndVars[x++] = ::NewString("$G");
    _ConstsAndVars[x++] = ::NewString("$H");
    _ConstsAndVars[x++] = ::NewString("$I");
    _ConstsAndVars[x++] = ::NewString("$J");
    _ConstsAndVars[x++] = ::NewString("$K");
    _ConstsAndVars[x++] = ::NewString("$L");
    _ConstsAndVars[x++] = ::NewString("$M");
    _ConstsAndVars[x++] = ::NewString("$N");
    _ConstsAndVars[x++] = ::NewString("$O");
    _ConstsAndVars[x++] = ::NewString("$P");
    _ConstsAndVars[x++] = ::NewString("$Q");
    _ConstsAndVars[x++] = ::NewString("$R");
    _ConstsAndVars[x++] = ::NewString("$S");
    _ConstsAndVars[x++] = ::NewString("$T");
    _ConstsAndVars[x++] = ::NewString("$U");
    _ConstsAndVars[x++] = ::NewString("$V");
    _ConstsAndVars[x++] = ::NewString("$W");
    _ConstsAndVars[x++] = ::NewString("$X");
    _ConstsAndVars[x++] = ::NewString("$Y");
    _ConstsAndVars[x++] = ::NewString("$Z");
    _ConstsAndVars[x++] = ::NewString("1");
    _ConstsAndVars[x++] = ::NewString("2");
    _ConstsAndVars[x++] = ::NewString("3");
    _ConstsAndVars[x++] = ::NewString("4");
    _ConstsAndVars[x++] = ::NewString("5");
    _ConstsAndVars[x++] = ::NewString("6");
    _ConstsAndVars[x++] = ::NewString("7");
    _ConstsAndVars[x++] = ::NewString("8");
    _ConstsAndVars[x++] = ::NewString("9");
    _ConstsAndVars[x++] = ::NewString("0");
    _ConstsAndVars[x++] = ::NewString(".1");
    _ConstsAndVars[x++] = ::NewString(".2");
    _ConstsAndVars[x++] = ::NewString(".3");
    _ConstsAndVars[x++] = ::NewString(".4");
    _ConstsAndVars[x++] = ::NewString(".5");
    _ConstsAndVars[x++] = ::NewString(".6");
    _ConstsAndVars[x++] = ::NewString(".7");
    _ConstsAndVars[x++] = ::NewString(".8");
    _ConstsAndVars[x++] = ::NewString(".9");
    _ConstsAndVars[x++] = ::NewString(".0");
    _ConstsAndVars[x] = NULL;

    x = 0;
    _ExcludedFncList[x++] = ::NewString("GETPRECISION");  // no brk required
    _ExcludedFncList[x++] = ::NewString("ITEMPERMREP");
    _ExcludedFncList[x++] = ::NewString("ITEMCOMBREP");
    _ExcludedFncList[x++] = ::NewString("PRECISION");     // no brk required
    _ExcludedFncList[x++] = ::NewString("ITEMPERM");
    _ExcludedFncList[x++] = ::NewString("ITEMCOMB");
    _ExcludedFncList[x++] = ::NewString("MATSOLVE");
    _ExcludedFncList[x++] = ::NewString("SETXDIF");
    _ExcludedFncList[x++] = ::NewString("SETDIF");
    _ExcludedFncList[x++] = ::NewString("SETUNI");
    _ExcludedFncList[x++] = ::NewString("SETINT");
    _ExcludedFncList[x++] = ::NewString("GRAPH");         // no brk required
    _ExcludedFncList[x++] = ::NewString("EXEC");          // no brk required
    _ExcludedFncList[x++] = ::NewString("SET");
    _ExcludedFncList[x] = NULL;

    x = 0;
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("SHOW");     // almost: SHOWSET
    _AlmostFncList[x++] = ::NewString("SHOWSET");
    _AlmostFncList[x++] = ::NewString("5");
    _AlmostFncList[x++] = ::NewString("SET");      // almost: SETINT, SETUNI, SETDIF, SETXDIF
    _AlmostFncList[x++] = ::NewString("SETINT");
    _AlmostFncList[x++] = ::NewString("SETUNI");
    _AlmostFncList[x++] = ::NewString("SETDIF");
    _AlmostFncList[x++] = ::NewString("SETXDIF");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("COMB");     // almost: COMBREP
    _AlmostFncList[x++] = ::NewString("COMBREP");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("PERM");     // almost: PERMREP
    _AlmostFncList[x++] = ::NewString("PERMREP");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("DERIV");    // almost: DERIV2
    _AlmostFncList[x++] = ::NewString("DERIV2");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("ITEMCOMB"); // almost: ITEMCOMBREP
    _AlmostFncList[x++] = ::NewString("ITEMCOMBREP");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("ITEMPERM"); // almost: ITEMPERMREP
    _AlmostFncList[x++] = ::NewString("ITEMPERMREP");
    _AlmostFncList[x++] = ::NewString("3");
    _AlmostFncList[x++] = ::NewString("FRAC");     // almost: FRACANS, FRACPART
    _AlmostFncList[x++] = ::NewString("FRACANS");
    _AlmostFncList[x++] = ::NewString("FRACPART");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("CUBE");     // almost: CUBERT
    _AlmostFncList[x++] = ::NewString("CUBERT");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("SQR");      // almost: SQRT
    _AlmostFncList[x++] = ::NewString("SQRT");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("SIN");      // almost: SINH
    _AlmostFncList[x++] = ::NewString("SINH");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("COS");      // almost: COSH
    _AlmostFncList[x++] = ::NewString("COSH");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("TAN");      // almost: TANH
    _AlmostFncList[x++] = ::NewString("TANH");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("LOG");      // almost: LOG10
    _AlmostFncList[x++] = ::NewString("LOG10");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("ANS");      // almost: ANSSTR
    _AlmostFncList[x++] = ::NewString("ANSSTR");
    _AlmostFncList[x++] = ::NewString("5");
    _AlmostFncList[x++] = ::NewString("E");        // almost: EVAL,EXP,EXEC,EXCLUDEENDS
    _AlmostFncList[x++] = ::NewString("EXP");
    _AlmostFncList[x++] = ::NewString("EXEC");
    _AlmostFncList[x++] = ::NewString("EVAL");
    _AlmostFncList[x++] = ::NewString("EXCLUDEENDS");
    _AlmostFncList[x++] = ::NewString("2");
    _AlmostFncList[x++] = ::NewString("X");        // almost: XOR
    _AlmostFncList[x++] = ::NewString("XOR");
    _AlmostFncList[x] = NULL;

    x = 0;
    _SpecialCaseList[x++] = ::NewString("ITEMPERMREP");
    _SpecialCaseList[x++] = ::NewString("ITEMCOMBREP");
    _SpecialCaseList[x++] = ::NewString("INTERSECT");
    _SpecialCaseList[x++] = ::NewString("ITEMPERM");
    _SpecialCaseList[x++] = ::NewString("ITEMCOMB");
    _SpecialCaseList[x++] = ::NewString("EXCLUDE");
    _SpecialCaseList[x++] = ::NewString("SETXDIF");
    _SpecialCaseList[x++] = ::NewString("SHOWSET");
    _SpecialCaseList[x++] = ::NewString("DERIV2");
    _SpecialCaseList[x++] = ::NewString("SETUNI");
    _SpecialCaseList[x++] = ::NewString("SETINT");
    _SpecialCaseList[x++] = ::NewString("SETDIF");
    _SpecialCaseList[x++] = ::NewString("DERIV");
    _SpecialCaseList[x++] = ::NewString("INTEG");
    _SpecialCaseList[x++] = ::NewString("SOLVE");
    _SpecialCaseList[x++] = ::NewString("GRAPH");
    _SpecialCaseList[x++] = ::NewString("FMIN");
    _SpecialCaseList[x++] = ::NewString("FMAX");
    _SpecialCaseList[x++] = ::NewString("FRAC");
    _SpecialCaseList[x++] = ::NewString("EVAL");
    _SpecialCaseList[x++] = ::NewString("SHOW");
    _SpecialCaseList[x++] = ::NewString("EXEC");
    _SpecialCaseList[x++] = ::NewString("SET");
    _SpecialCaseList[x] = NULL;

    x = 0;
    _VarxFncList[x++] = ::NewString("INTERSECT"); // args: 4, 5
    _VarxFncList[x++] = ::NewString("DERIV2");    // args: 3, 4
    _VarxFncList[x++] = ::NewString("DERIV");     // args: 3, 4
    _VarxFncList[x++] = ::NewString("GRAPH");     // args: 2
    _VarxFncList[x++] = ::NewString("INTEG");     // args: 4, 5
    _VarxFncList[x++] = ::NewString("SOLVE");     // args: 3, 5
    _VarxFncList[x++] = ::NewString("FMIN");      // args: 4, 5, 6
    _VarxFncList[x++] = ::NewString("FMAX");      // args: 4, 5, 6
    _VarxFncList[x] = NULL;

    x = 0;
    _ChkFncPrecList[x++] = ::NewString("FACT");
    _ChkFncPrecList[x++] = ::NewString("PROD");   // args: 1, vary
    _ChkFncPrecList[x++] = ::NewString("CUBE");
    _ChkFncPrecList[x++] = ::NewString("SUM");    // args: 1, vary
    _ChkFncPrecList[x++] = ::NewString("SQR");
    _ChkFncPrecList[x++] = ::NewString("/=");
    _ChkFncPrecList[x++] = ::NewString("*=");
    _ChkFncPrecList[x++] = ::NewString("-=");
    _ChkFncPrecList[x++] = ::NewString("+=");
    _ChkFncPrecList[x++] = ::NewString("@=");
    _ChkFncPrecList[x++] = ::NewString("/");
    _ChkFncPrecList[x++] = ::NewString("*");
    _ChkFncPrecList[x++] = ::NewString("-");
    _ChkFncPrecList[x++] = ::NewString("+");
    _ChkFncPrecList[x++] = ::NewString("@");
    _ChkFncPrecList[x++] = ::NewString("%");
    _ChkFncPrecList[x] = NULL;

    return true;
  }

  return false;
}

/****************************************************************************/
bool FunctionValidityChecker::DestroyStaticMembers(CalculatorBase* Parent_)
{
  if (Parent_ && _Instances == 0)
  {
    int x;

    ClearNumberStrList(Parent_);
    MemMatrix::Matrix().Deallocate(_NumberStrs);

    _NumNumbers =
    _NumberListSize = 0;
    _NumberStrs = NULL;

    for (x = 0; _ErrorMessageList[x]; x++)
      MemMatrix::Matrix().Deallocate(_ErrorMessageList[x]);
    MemMatrix::Matrix().Deallocate(_ErrorMessageList);

    for (x = 0; _SingleArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_SingleArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_SingleArgFncList);

    for (x = 0; _DoubleArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_DoubleArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_DoubleArgFncList);

    for (x = 0; _TripleArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_TripleArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_TripleArgFncList);

    for (x = 0; _FourArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_FourArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_FourArgFncList);

    for (x = 0; _FiveArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_FiveArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_FiveArgFncList);

    for (x = 0; _SixArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_SixArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_SixArgFncList);

    for (x = 0; _VaryArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_VaryArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_VaryArgFncList);

    for (x = 0; _UnaryOpList[x]; x++)
      MemMatrix::Matrix().Deallocate(_UnaryOpList[x]);
    MemMatrix::Matrix().Deallocate(_UnaryOpList);

    for (x = 0; _BinaryOpList[x]; x++)
      MemMatrix::Matrix().Deallocate(_BinaryOpList[x]);
    MemMatrix::Matrix().Deallocate(_BinaryOpList);

    for (x = 0; _ConstsAndVars[x]; x++)
      MemMatrix::Matrix().Deallocate(_ConstsAndVars[x]);
    MemMatrix::Matrix().Deallocate(_ConstsAndVars);

    for (x = 0; _FracOpList[x]; x++)
      MemMatrix::Matrix().Deallocate(_FracOpList[x]);
    MemMatrix::Matrix().Deallocate(_FracOpList);

    for (x = 0; _ExcludedFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_ExcludedFncList[x]);
    MemMatrix::Matrix().Deallocate(_ExcludedFncList);

    for (x = 0; _MultiArgFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_MultiArgFncList[x]);
    MemMatrix::Matrix().Deallocate(_MultiArgFncList);

    for (x = 0; _MultiArgChkList[x]; x++)
      MemMatrix::Matrix().Deallocate(_MultiArgChkList[x]);
    MemMatrix::Matrix().Deallocate(_MultiArgChkList);

    for (x = 0; _AlmostFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_AlmostFncList[x]);
    MemMatrix::Matrix().Deallocate(_AlmostFncList);

    for (x = 0; _SpecialCaseList[x]; x++)
      MemMatrix::Matrix().Deallocate(_SpecialCaseList[x]);
    MemMatrix::Matrix().Deallocate(_SpecialCaseList);

    for (x = 0; _VarxFncList[x]; x++)
      MemMatrix::Matrix().Deallocate(_VarxFncList[x]);
    MemMatrix::Matrix().Deallocate(_VarxFncList);

    for (x = 0; _ChkFncPrecList[x]; x++)
      MemMatrix::Matrix().Deallocate(_ChkFncPrecList[x]);
    MemMatrix::Matrix().Deallocate(_ChkFncPrecList);

    return true;
  }

  return false;
}

/****************************************************************************/
int FunctionValidityChecker::GrowNumberStrList(CalculatorBase* Parent_)
{
  char** oldls = _NumberStrs;
  int oldsz = _NumberListSize;
  int x;

  _NumberListSize += LISTINCR;
  _NumberStrs = (char**)(Parent_->allocmem(_NumberListSize, sizeof(char*), _NumberStrs));

  for (x = 0; x < oldsz; x++)
    _NumberStrs[x] = oldls[x];

  for (;x < _NumberListSize; x++)
    _NumberStrs[x] = NULL;

  MemMatrix::Matrix().Deallocate(oldls);
  return _NumberListSize;
}

/****************************************************************************/
void FunctionValidityChecker::ClearNumberStrList(CalculatorBase* Parent_)
{
  int x;
  for (x = 0; x < _NumNumbers; x++)
  {
    MemMatrix::Matrix().Deallocate(_NumberStrs[x]);
    _NumberStrs[x] = NULL;
  }

  _NumNumbers =
  _MaxWholeDigits =
  _MaxSigDigits =
  _MaxDecDigits =
  _LargestNumIndex = 0;
  _DecPtFound = false;
}

/****************************************************************************/
char* FunctionValidityChecker::AddNumberStr(CalculatorBase* Parent_, const char* str)
{
  int len = ::SafeStrLen(str);
  char* ptr = NULL;

  if (len && _NumberListSize)
  {
    ptr = _NumberStrs[_NumNumbers];
    ptr = (char*)(Parent_->allocmem(len+1, sizeof(char), ptr));
    _NumberStrs[_NumNumbers++] = strcpy(ptr, str);

    if (_NumNumbers == _NumberListSize)
      GrowNumberStrList(Parent_);

    return ptr;
  }

  return NULL;
}

/****************************************************************************/
void FunctionValidityChecker::PrintNumberStrList(CalculatorBase* Parent_,
                                                 bool All_, int index_, char Delim_)
{
  int x;
  int len;
  char Delims_[2];

  Delims_[0] = Delim_;
  Delims_[1] = 0;
  len = strlen(Delims_);

  if (All_)
  {
    for (x = 0; x < _NumNumbers; x++)
      if (_NumberStrs[x])
      {
        Parent_->UseDefaultOutputFnc(_NumberStrs[x]);
        if (len)
          Parent_->UseDefaultOutputFnc(Delims_);
      }
  }
  else if (_NumberListSize && index_ < _NumNumbers)
  {
    Parent_->UseDefaultOutputFnc(_NumberStrs[index_]);
    if (len)
      Parent_->UseDefaultOutputFnc(Delims_);
  }
}

/****************************************************************************/
int FunctionValidityChecker::FindLargestNum(const char* str)
{
  int x;
  int slen = 0;
  int sslen = 0;
  const char* sdecpt = NULL;
  const char* sendpt = NULL;

  int tlen = 0;
  int ttlen = 0;
  const char* tdecpt = NULL;
  const char* tendpt = NULL;

  int smwd_ = 0;
  int smdd_ = 0;
  int smsd_ = 0;
  int slni_ = 0;

  int tmwd_ = 0;
  int tmdd_ = 0;
  int tmsd_ = 0;
  int tlni_ = 0;

  if (::SafeStrLen(str))
  {
    slen =
    sslen = strlen(str);
    sdecpt = strchr(str, '.');
    sendpt = &str[slen];

    if (_NumNumbers == 0 ||
        (_NumNumbers == 1 && strcmp(_NumberStrs[0], str) == 0))
    {
      if (sdecpt) _DecPtFound = true;
      _MaxWholeDigits = sdecpt ? (sdecpt - str):slen;
      _MaxDecDigits = sdecpt ? (sendpt - sdecpt - 1):0;
      _MaxSigDigits = _MaxWholeDigits + _MaxDecDigits;
      _LargestNumIndex = 0;
    }
    else
    {
      if (sdecpt) _DecPtFound = true;
      smwd_ = sdecpt ? (sdecpt - str):slen;
      smdd_ = sdecpt ? (sendpt - sdecpt - 1):0;
      smsd_ = smwd_ + smdd_;
      slni_ = -1;

      for (x = 0; x < _NumNumbers; x++)
      {
        tlen =
        ttlen = strlen(_NumberStrs[x]);
        tdecpt = strchr(_NumberStrs[x], '.');
        tendpt = &_NumberStrs[x][tlen];

        if (tdecpt) _DecPtFound = true;
        tmwd_ = tdecpt ? (tdecpt - _NumberStrs[x]):tlen;
        tmdd_ = tdecpt ? (tendpt - tdecpt - 1):0;
        tmsd_ = tmwd_ + tmdd_;
        tlni_ = x;

        if (smwd_ < tmwd_)
          smwd_ = tmwd_;

        if (smdd_ < tmdd_)
          smdd_ = tmdd_;

        if (smsd_ < tmsd_)
          smsd_ = tmsd_;

        if (sslen < ttlen)
        {
          sslen = ttlen;
          slni_ = tlni_;
        }
      }

      if (_MaxWholeDigits < smwd_)
        _MaxWholeDigits = smwd_;

      if (_MaxDecDigits < smdd_)
        _MaxDecDigits = smdd_;

      if (_MaxSigDigits < smsd_)
        _MaxSigDigits = smsd_;

      if (slni_ >= 0 && _LargestNumIndex != slni_)
        _LargestNumIndex = slni_;
    }
  }

  return _LargestNumIndex;
}

/****************************************************************************/
const char* FunctionValidityChecker::GetNumberStr(int index_)
{
  return ((_NumberListSize && index_ < _NumNumbers) ? _NumberStrs[index_]:NULL);
}

/****************************************************************************/
int FunctionValidityChecker::NumNumbers()
{
  return _NumNumbers;
}

/****************************************************************************/
int FunctionValidityChecker::MaxWholeDigits()
{
  return _MaxWholeDigits;
}

/****************************************************************************/
int FunctionValidityChecker::MaxSigDigits()
{
  return _MaxSigDigits;
}

/****************************************************************************/
int FunctionValidityChecker::MaxDecDigits()
{
  return _MaxDecDigits;
}

/****************************************************************************/
int FunctionValidityChecker::LargestNumIndex()
{
  return _LargestNumIndex;
}

/****************************************************************************/
bool FunctionValidityChecker::DecPtFound()
{
  return _DecPtFound;
}

/****************************************************************************/
void FunctionValidityChecker::ShowDebugInfo()
{
  char* result_ = NULL;
  cout <<"HasSibling = " <<_HasSibling <<endl;
  cout <<"SiblingIndexSize = " <<_SiblingIndexSize <<endl;
  result_ = _SiblingIndexes ? IntArrayToStr(_SiblingIndexes, _SiblingIndexSize):NewString("{null}");
  cout <<"SiblingIndexes = " <<result_ <<endl;

  cout <<"startpt = " <<_startpt <<endl;
  cout <<"endpt = " <<_endpt <<endl;
  cout <<"openbrkcnt = " <<_openbrkcnt <<endl;
  cout <<"closebrkcnt = " <<_closebrkcnt <<endl;

  _MemDel->DelayedDeleteCstr(result_, STOREMEM);
}

/****************************************************************************/
void FunctionValidityChecker::ResetMultiArgChks()
{
  int x;
  for (x = 0; x < FunctionValidityChecker::MAX_MULTIARG_FNCS; x++)
    ::memset(_MultiArgChkList[x], 0, (FunctionValidityChecker::MAX_MULTIARG_CHKS+1) * sizeof(int));

  _MultiArgChkList[0][1] =
  _MultiArgChkList[0][2] = 1;
  _MultiArgChkList[1][4] =
  _MultiArgChkList[1][5] = 1;
  _MultiArgChkList[2][3] =
  _MultiArgChkList[2][4] = 1;
  _MultiArgChkList[3][3] =
  _MultiArgChkList[3][4] = 1;
  _MultiArgChkList[4][4] =
  _MultiArgChkList[4][5] = 1;
  _MultiArgChkList[5][3] =
  _MultiArgChkList[5][5] = 1;
  _MultiArgChkList[6][4] =
  _MultiArgChkList[6][5] =
  _MultiArgChkList[6][6] = 1;
  _MultiArgChkList[7][4] =
  _MultiArgChkList[7][5] =
  _MultiArgChkList[7][6] = 1;
}

/****************************************************************************/
const char* FunctionValidityChecker::ChkStrOmitToTxtStr()
{
  if ((!_ChkStrOmit && !_ChkStrOmitPtr) ||
      (_ChkStrOmitPtr && !_ChkStrOmitPtr->GetLength()) ||
      (_ChkStrOmit && !_ChkStrOmit->GetLength()))
    return "(null)";

  if (_ChkStrOmitTxtStr)
  {
    _MemDel->DelayedDeleteCstr(_ChkStrOmitTxtStr, STOREMEM);
    _ChkStrOmitTxtStr = NULL;
  }

  Ulong x;
  Ulong i = 0;
  Ulong len = _ChkStrOmit ? _ChkStrOmit->GetLength():
              _ChkStrOmitPtr ? _ChkStrOmitPtr->GetLength():0;
  int v;

  _ChkStrOmitTxtStr = new_char_array(len+5, NULL);

  for (x = 0; x < len; x++)
  {
    v = GetChkStrOmit(x);
    _ChkStrOmitTxtStr[i++] = v ? 'x':'_';
  }

  _ChkStrOmitTxtStr[i] = 0;
  return _ChkStrOmitTxtStr;
}

/****************************************************************************/
const char* FunctionValidityChecker::GiveErrorMessage() const
{
  if (!_ErrorCode)
    return NULL;

  int x;
  int max = MAX_ERROR_CODES;
  int i = 1;

  for (x = 0; x < max; x++)
    if (i & _ErrorCode)
      break;
    else
      i *= 2;

  return ((x < max) ? _ErrorMessageList[x]:NULL);
}

/****************************************************************************/
void FunctionValidityChecker::SetErrorCode(int Code_)
{
  _ErrorCode |= Code_;
}

/****************************************************************************/
void FunctionValidityChecker::ResetErrors()
{
  _ErrorCode = 0;
  _ChkFrac = false;
}

/****************************************************************************/
void FunctionValidityChecker::ResetAllVars()
{
  _OperandRequired = false;
  _NextOperandRequired = false;
  _Levels = 0;
  _Valid = false;

  _TokenType = 0;
  _TokenSubtype = 0;
  _Checked = 0;

  _startpt = NULL;
  _openbrkpt = NULL;
  _closebrkpt = NULL;
  _endpt = NULL;

  if (_ChkStrOmit)
    _ChkStrOmit->UnSetAllBits();

  _openbrkcnt = 0;
  _closebrkcnt = 0;

  _SingleArgFnc = false;
  _DoubleArgFnc = false;
  _TripleArgFnc = false;
  _FourArgFnc = false;
  _FiveArgFnc = false;
  _SixArgFnc = false;
  _VaryArgFnc = false;
  _FncPrecForSingleArgFncs = false;
  _FncPrecForVaryArgFncs = false;

  _IgnoredCmd = false;
  _IsOperand = false;
  _IsConstVal = false;
  _IsOperandVal = false;
  _IsUnaryExpr = false;
  _IsBinaryExpr = false;
  _BracketedExpr = false;
  _OperandNeeded = false;
  _FunctionMatched = false;
  _FracOpFound = false;
  _LastChkStrIndexSaved = false;

  _ErrorCode = 0;
  _ChkFrac = false;

  ::memset(_commaindexes, 0, sizeof(int) * _commaindexsize);
  ::memset(_AbsStrPosIndexes, 0, sizeof(int) * _AbsStrPosIndexSize);
  ::memset(_ChkStrCase, 0, sizeof(short) * _ChkStrSize);

  _ChkStrCasePtr = NULL;
  _ChkStrOmitPtr = NULL;

  _AbsChkStrIndex = 0;
  _LastChkStrIndex = 0;
  _SavedChkStrIndex = 0;
  _RelChkStrIndex = 0;

  _SpecialCaseIndex = NOT_SPECIALCASE;
  _SpecialCaseLen = 0;
  _ExcludedCaseIndex = NOT_EXCLUDEDCASE;
  _ExcludedCaseLen = 0;

  ClearNumberStrList(_Parent);

  SetNext(NULL);
  SetSibling(NULL, NULL, NULL);
}

/****************************************************************************/
void FunctionValidityChecker::ResetCheckVars(bool resetchk_)
{
  bool atstart_ = _LineToProcess == _LineRemaining &&
                  _LineToProcess == _OriginalLine;

  if (resetchk_)
    _Checked = 0;

  if (_Adjacent)
  {
    _HasSibling = _SiblingIndexes != NULL && _SiblingIndexes[0];
    _SiblingIndexSize = !_SiblingIndexes ? 0:
                        _Adjacent ? (_Adjacent->SiblingIndexSize() - 1):
                        _Caller ? _Caller->_commaindexsize:0;
    _Levels = _Adjacent ? _Adjacent->_Levels:0;

    _startpt = (_Adjacent && _Adjacent->HasSibling(_Caller)) ? (_Adjacent->_endpt+2):NULL;
    _openbrkpt = NULL;
    _closebrkpt = NULL;
    _endpt = _Caller ? ((_SiblingIndexes != NULL && _SiblingIndexes[0]) ?
                        (_Caller->_startpt+_SiblingIndexes[0]-1):
                        (_Caller->_closebrkpt-1)):NULL;

    _openbrkcnt = _Caller ? (_Caller->_openbrkcnt):0;
    _closebrkcnt = _Caller ? (_Caller->_closebrkcnt):0;

    _ChkStrCasePtr = _Caller ? (_Caller->_ChkStrCase ? _Caller->_ChkStrCase:
                                                       _Caller->_ChkStrCasePtr):NULL;
    _ChkStrOmitPtr = _Caller ? (_Caller->_ChkStrOmit ? _Caller->_ChkStrOmit:
                                                       _Caller->_ChkStrOmitPtr):NULL;
  }
  else if (_Caller)
  {
    _HasSibling = _SiblingIndexes != NULL && _SiblingIndexes[0];
    _SiblingIndexSize = !_SiblingIndexes ? 0:
                        _Caller ? _Caller->_commaindexsize:0;
    _Levels = _Caller ? (_Caller->_Levels + 1):0;

    _startpt = _Caller ? (_Caller->_openbrkpt+1):NULL;
    _openbrkpt = NULL;
    _closebrkpt = NULL;
    _endpt = _Caller ? ((_SiblingIndexes != NULL && _SiblingIndexes[0]) ?
                        (_Caller->_startpt+_SiblingIndexes[0]-1):
                        (_Caller->_closebrkpt-1)):NULL;

    _openbrkcnt = _Caller ? (_Caller->_openbrkcnt):0;
    _closebrkcnt = _Caller ? (_Caller->_closebrkcnt):0;

    _ChkStrCasePtr = _Caller ? (_Caller->_ChkStrCase ? _Caller->_ChkStrCase:
                                                       _Caller->_ChkStrCasePtr):NULL;
    _ChkStrOmitPtr = _Caller ? (_Caller->_ChkStrOmit ? _Caller->_ChkStrOmit:
                                                       _Caller->_ChkStrOmitPtr):NULL;
  }
  else
  {
    _startpt = NULL;
    _openbrkpt = NULL;
    _closebrkpt = NULL;
    _endpt = NULL;

    if (atstart_)
    {
      _openbrkcnt = 0;
      _closebrkcnt = 0;
    }
  }

  _SingleArgFnc = false;
  _DoubleArgFnc = false;
  _TripleArgFnc = false;
  _FourArgFnc = false;
  _FiveArgFnc = false;
  _SixArgFnc = false;
  _VaryArgFnc = false;
  _FncPrecForSingleArgFncs = false;
  _FncPrecForVaryArgFncs = false;
}

/****************************************************************************/
void FunctionValidityChecker::SaveSnapshot()
{
  if (_SavedSnapshot)
    delete _SavedSnapshot;

  _SavedSnapshot = new FunctionValidityChecker(_Parent, *this);
}

/****************************************************************************/
void FunctionValidityChecker::RestoreSnapshot()
{
  if (_SavedSnapshot)
  {
    _Parent = _SavedSnapshot->_Parent;
    _Next = _SavedSnapshot->_Next;
    _Caller = _SavedSnapshot->_Caller;

    _Adjacent = _SavedSnapshot->_Adjacent;
    _Sibling = _SavedSnapshot->_Sibling;
    _HasSibling = _SavedSnapshot->_HasSibling;
    _SiblingIndexes = _SavedSnapshot->_SiblingIndexes;
    _SiblingIndexSize = _SavedSnapshot->_SiblingIndexSize;

    _LineRemaining = _SavedSnapshot->_LineRemaining;
    _LineToProcess = _SavedSnapshot->_LineToProcess;
    _OriginalLine = _SavedSnapshot->_OriginalLine;
    _OperandRequired = _SavedSnapshot->_OperandRequired;
    _NextOperandRequired = _SavedSnapshot->_NextOperandRequired;

    _TokenType = _SavedSnapshot->_TokenType;
    _TokenSubtype = _SavedSnapshot->_TokenSubtype;
    _Levels = _SavedSnapshot->_Levels;
    _Valid = _SavedSnapshot->_Valid;
    _Checked = _SavedSnapshot->_Checked;
    _MaxToCheck = _SavedSnapshot->_MaxToCheck;
    _LineNumber = _SavedSnapshot->_LineNumber;
    _StopOnNumber = _SavedSnapshot->_StopOnNumber;

    _commaindexsize = _SavedSnapshot->_commaindexsize;

    _startpt = _SavedSnapshot->_startpt;
    _openbrkpt = _SavedSnapshot->_openbrkpt;
    _closebrkpt = _SavedSnapshot->_closebrkpt;
    _endpt = _SavedSnapshot->_endpt;

    _openbrkcnt = _SavedSnapshot->_openbrkcnt;
    _closebrkcnt = _SavedSnapshot->_closebrkcnt;

    _SingleArgFnc = _SavedSnapshot->_SingleArgFnc;
    _DoubleArgFnc = _SavedSnapshot->_DoubleArgFnc;
    _TripleArgFnc = _SavedSnapshot->_TripleArgFnc;
    _FourArgFnc = _SavedSnapshot->_FourArgFnc;
    _FiveArgFnc = _SavedSnapshot->_FiveArgFnc;
    _SixArgFnc = _SavedSnapshot->_SixArgFnc;
    _VaryArgFnc = _SavedSnapshot->_VaryArgFnc;
    _FncPrecForSingleArgFncs = _SavedSnapshot->_FncPrecForSingleArgFncs;
    _FncPrecForVaryArgFncs = _SavedSnapshot->_FncPrecForVaryArgFncs;

    _IgnoredCmd = _SavedSnapshot->_IgnoredCmd;
    _IsOperand = _SavedSnapshot->_IsOperand;
    _IsConstVal = _SavedSnapshot->_IsConstVal;
    _IsOperandVal = _SavedSnapshot->_IsOperandVal;
    _IsUnaryExpr = _SavedSnapshot->_IsUnaryExpr;
    _IsBinaryExpr = _SavedSnapshot->_IsBinaryExpr;
    _BracketedExpr = _SavedSnapshot->_BracketedExpr;
    _OperandNeeded = _SavedSnapshot->_OperandNeeded;
    _FunctionMatched = _SavedSnapshot->_FunctionMatched;
    _FracOpFound = _SavedSnapshot->_FracOpFound;

    _ChkFrac = _SavedSnapshot->_ChkFrac;

    _ChkStrOmit = _SavedSnapshot->_ChkStrOmit;
    _ChkStrCasePtr = _SavedSnapshot->_ChkStrCasePtr;
    _ChkStrOmitPtr = _SavedSnapshot->_ChkStrOmitPtr;
    _AbsChkStrIndex = _SavedSnapshot->_AbsChkStrIndex;
    _SavedChkStrIndex = _SavedSnapshot->_SavedChkStrIndex;
    _RelChkStrIndex = _SavedSnapshot->_RelChkStrIndex;
    _LastChkStrIndex = _SavedSnapshot->_LastChkStrIndex;
    _ChkStrSize = _SavedSnapshot->_ChkStrSize;
    _SpecialCaseIndex = _SavedSnapshot->_SpecialCaseIndex;
    _SpecialCaseLen = _SavedSnapshot->_SpecialCaseLen;
    _ExcludedCaseIndex = _SavedSnapshot->_ExcludedCaseIndex;
    _ExcludedCaseLen = _SavedSnapshot->_ExcludedCaseLen;
    _LastChkStrIndexSaved = _SavedSnapshot->_LastChkStrIndexSaved;

    _AbsStrPosIndexSize = _SavedSnapshot->_AbsStrPosIndexSize;
    _SiblingAbsStrPosIndexes = _SavedSnapshot->_SiblingAbsStrPosIndexes;
    _SiblingAbsStrPosIndexSize = _SavedSnapshot->_SiblingAbsStrPosIndexSize;

    if (_Parent)
    {
      if (_commaindexsize && _SavedSnapshot->_commaindexes)
        ::memmove(_commaindexes, _SavedSnapshot->_commaindexes, sizeof(int) * _commaindexsize);
      else
        _commaindexes = NULL;

      if (_AbsStrPosIndexSize && _SavedSnapshot->_AbsStrPosIndexes)
        ::memmove(_AbsStrPosIndexes, _SavedSnapshot->_AbsStrPosIndexes, sizeof(int) * _AbsStrPosIndexSize);
      else
        _AbsStrPosIndexes = NULL;

      if (!_Caller && _ChkStrOmit && _ChkStrSize && _SavedSnapshot->_ChkStrCase)
        ::memmove(_ChkStrCase, _SavedSnapshot->_ChkStrCase, sizeof(short) * _ChkStrSize);
      else
        _ChkStrCase = NULL;
    }

    _HasSibling = _SavedSnapshot->_HasSibling;
    _SiblingIndexSize = _SavedSnapshot->_SiblingIndexSize;

    if (_HasSibling)
      _Sibling = _SavedSnapshot->_Sibling;
    else
      _Sibling = NULL;
  }
}

/****************************************************************************/
bool FunctionValidityChecker::IsAssignOps(const char* str, int& tlen_)
{
  int x;
  int len;
  int max = ASSIGNOP_START + MAXASSIGNOPS;
  bool match = false;

  for (x = ASSIGNOP_START; x < max && !match; x++)
  {
    len = strlen(_BinaryOpList[x]);
    match = _Parent->icasestrcompn(str, _BinaryOpList[x], len);

    if (match)
      tlen_ = len;
  }

  return match;
}

/****************************************************************************/
bool FunctionValidityChecker::StrFits(const char* str, int len)
{
  if (!str)
    return false;

  int sz = ::SafeStrLen(_OriginalLine);
  int offset_ = str - _OriginalLine; // assuming str is within Original Line

  if (offset_ < sz)
  {
    len += offset_;
    bool Fits_ = !MemPool::IsManagedMemoryConstp(_OriginalLine) ||
                 MemPool::MemFitConstp(_OriginalLine, len);

    return Fits_;
  }

  return false;
}

/****************************************************************************/
bool FunctionValidityChecker::NextAssignOps(const char* str, int& pos, int& tlen_, bool SkipOnlyWs_)
{
  bool Fit_ = StrFits(str, pos);
  if (!Fit_)
    return false;

  bool match = false;
  for (;str[pos] && !(match=IsAssignOps(&str[pos],tlen_)) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  return (str[pos] && match);
}

/****************************************************************************/
bool FunctionValidityChecker::ChkNextToken(int TokType_, int TokSubtype_, int ExprType_, int OpIndex_, int OpType_)
{
  bool atstart_ = _LineToProcess == _LineRemaining && _LineToProcess == _OriginalLine;
  bool cond1 = false;
  bool cond2 = false;
  bool cond3 = false;

  if (TokType_ == FUNCTION_TOKEN &&
      (ExprType_ == SINGLEARGFNC ||
       ExprType_ == DOUBLEARGFNC || ExprType_ == TRIPLEARGFNC ||
       ExprType_ == FOURARGFNC   || ExprType_ == FIVEARGFNC   ||
       ExprType_ == SIXARGFNC    || ExprType_ == VARYARGFNC))
  {
    // previous bracketed expression or operator required
    // before function call in processed math statement
    cond1 = atstart_ || _IgnoredCmd ||
      ((_BracketedExpr && _IsOperand && !_OperandNeeded) ||
       ((_IsUnaryExpr || _IsBinaryExpr) && _OperandNeeded));

    return cond1;
  }
  else if ((ExprType_ == OPERANDVAL || ExprType_ == CONSTVAL) &&
           ((TokType_ == OPERATOR_TOKEN && TokSubtype_ == POSTFIX_OPERATOR) ||
            TokType_ == GROUP_TOKEN || TokType_ == VALUE_TOKEN ||
            TokType_ == VARIABLE_TOKEN || TokType_ == CONSTANT_TOKEN))
  {
    cond1 = atstart_ || _IgnoredCmd ||
      (((_IsConstVal || _BracketedExpr) && _IsOperand && !_OperandNeeded) ||
       ((_IsUnaryExpr || _IsBinaryExpr) && _OperandNeeded));

    cond2 = (TokType_ == GROUP_TOKEN) && cond1;

    cond1 = atstart_ || _IgnoredCmd ||
      ((_BracketedExpr && _IsOperand && !_OperandNeeded) ||
       ((_IsUnaryExpr || _IsBinaryExpr) && _OperandNeeded));

    cond3 = !cond2 && cond1 &&
            ((TokType_ == OPERATOR_TOKEN && TokSubtype_ == POSTFIX_OPERATOR) ||
             TokType_ == VALUE_TOKEN || TokType_ == VARIABLE_TOKEN ||
             TokType_ == CONSTANT_TOKEN);

    return (cond2 || cond3);
  }
  else if (ExprType_ == UNARYEXPR)
  {
    cond1 = atstart_ || _IgnoredCmd ||
      ((_IsUnaryExpr || _IsBinaryExpr) && _OperandNeeded);

    if (OpIndex_ >= 0 && OpType_)
      cond2 = (OpType_ == UNARY_OPERATOR) ? OpIndex_ >= UNARYOPS_START:
              (OpType_ == UNARY_FUNCTION) ? OpIndex_ < UNARYOPS_START:0;
    else
      cond2 = true;

    cond3 = ((TokType_ == FUNCTION_TOKEN && TokSubtype_ == UNARY_FUNCTION) ||
             (TokType_ == OPERATOR_TOKEN && TokSubtype_ == UNARY_OPERATOR)) &&
            cond1 && cond2;

    return cond3;
  }
  else if (ExprType_ == BINARYEXPR)
  {
    cond1 = atstart_ || _IgnoredCmd ||
      (_TokenType == FUNCTION_TOKEN ||
       ((_IsConstVal || _IsOperandVal || _BracketedExpr) && _IsOperand && !_OperandNeeded));

    if (OpIndex_ >= 0 && OpType_)
      cond2 = (OpType_ == BINARY_OPERATOR) ? OpIndex_ >= BINARYOPS_START:
              (OpType_ == BINARY_FUNCTION) ? OpIndex_ < BINARYOPS_START:0;
    else
      cond2 = true;

    cond3 = ((TokType_ == FUNCTION_TOKEN && TokSubtype_ == BINARY_FUNCTION) ||
             (TokType_ == OPERATOR_TOKEN && TokSubtype_ == BINARY_OPERATOR)) &&
            cond1 && cond2;

    return cond3;
  }
  else if (ExprType_ == BRACKETEDEXPR && TokType_ == GROUP_TOKEN)
  {
    cond1 = atstart_ || _IgnoredCmd ||
      (((_IsConstVal || _IsOperandVal || _BracketedExpr) && _IsOperand && !_OperandNeeded) ||
       ((_IsUnaryExpr || _IsBinaryExpr) && _OperandNeeded));

    if (OpIndex_ >= 0 && OpType_)
      cond2 = (OpType_ == BINARY_OPERATOR) ? OpIndex_ >= BINARYOPS_START:
              (OpType_ == UNARY_OPERATOR)  ? OpIndex_ >= UNARYOPS_START:0;
    else
      cond2 = true;

    cond3 = (TokType_ == GROUP_TOKEN) && cond1 && cond2;

    return cond3;
  }

  return false;
}

/****************************************************************************/
void FunctionValidityChecker::SetTokenType(int TokType_, int TokSubtype_, int ExprType_, bool ChkOpNeeded_, bool OpNeeded_)
{
  _TokenType = TokType_;
  _TokenSubtype = TokSubtype_;

  if (ExprType_ == SINGLEARGFNC)
  {
    _SingleArgFnc = true;

    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == DOUBLEARGFNC)
  {
    _DoubleArgFnc = true;

    _SingleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == TRIPLEARGFNC)
  {
    _TripleArgFnc = true;

    _SingleArgFnc =
    _DoubleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == FOURARGFNC)
  {
    _FourArgFnc = true;

    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == FIVEARGFNC)
  {
    _FiveArgFnc = true;

    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == SIXARGFNC)
  {
    _SixArgFnc = true;

    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == VARYARGFNC)
  {
    _VaryArgFnc = true;

    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == OPERANDVAL)
  {
    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsOperandVal = true;
    _IsConstVal = false;
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == CONSTVAL)
  {
    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsOperandVal = false;
    _IsConstVal = true;
    _IsUnaryExpr =
    _IsBinaryExpr =
    _BracketedExpr =
    _OperandNeeded = false;
  }
  else if (ExprType_ == UNARYEXPR)
  {
    _SingleArgFnc = (_TokenSubtype == UNARY_FUNCTION &&
                     _openbrkpt && _closebrkpt);
    _DoubleArgFnc = false;
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = (_TokenSubtype == UNARY_FUNCTION &&
                  _openbrkpt && _closebrkpt);
    _IsConstVal = false;
    _IsUnaryExpr = true;
    _IsBinaryExpr = false;
    _BracketedExpr = false;

    if (ChkOpNeeded_)
    {
      _OperandNeeded = !_IsOperand && _TokenSubtype == UNARY_OPERATOR;
      _OperandRequired = _OperandNeeded;

      if (_OperandNeeded)
        _TokenType = OPERATOR_TOKEN;
      else
        _TokenType = FUNCTION_TOKEN;
    }
    else
    {
      _OperandNeeded = !_IsOperand && OpNeeded_;
      _OperandRequired = _OperandNeeded;

      if (_TokenSubtype == UNARY_OPERATOR)
        _TokenType = OPERATOR_TOKEN;
      else
        _TokenType = FUNCTION_TOKEN;
    }

    if (_IsOperand)
      ResetOperandRequired();
  }
  else if (ExprType_ == BINARYEXPR)
  {
    _SingleArgFnc = false;
    _DoubleArgFnc = (_TokenSubtype == BINARY_FUNCTION &&
                     _openbrkpt && _closebrkpt);
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = (_TokenSubtype == BINARY_FUNCTION &&
                  _openbrkpt && _closebrkpt);
    _IsConstVal = false;
    _IsUnaryExpr = false;
    _IsBinaryExpr = true;
    _BracketedExpr = false;

    if (ChkOpNeeded_)
    {
      _OperandNeeded = !_IsOperand && _TokenSubtype == BINARY_OPERATOR;
      _NextOperandRequired = _OperandNeeded;

      if (_OperandNeeded)
        _TokenType = OPERATOR_TOKEN;
      else
        _TokenType = FUNCTION_TOKEN;
    }
    else
    {
      _OperandNeeded = !_IsOperand && OpNeeded_;
      _NextOperandRequired = _OperandNeeded;

      if (_TokenSubtype == BINARY_OPERATOR)
        _TokenType = OPERATOR_TOKEN;
      else
        _TokenType = FUNCTION_TOKEN;
    }

    if (_IsOperand)
      ResetOperandRequired();
  }
  else if (ExprType_ == BRACKETEDEXPR)
  {
    _SingleArgFnc =
    _DoubleArgFnc =
    _TripleArgFnc =
    _FourArgFnc =
    _FiveArgFnc =
    _SixArgFnc =
    _VaryArgFnc = false;

    _IsOperand = true;
    _IsConstVal =
    _IsUnaryExpr =
    _IsBinaryExpr = false;
    _BracketedExpr = true;
    _OperandNeeded = false;
  }

  if (ExprType_ != OPERANDVAL && ExprType_ != CONSTVAL)
    _IsOperandVal = _IsConstVal = false;
}

/****************************************************************************/
void FunctionValidityChecker::ResetOperandRequired()
{
  if (_IsOperand)
  {
    _NextOperandRequired = false;
    _OperandRequired = false;
    _OperandNeeded = false;
  }
}

/****************************************************************************/
FunctionValidityChecker* FunctionValidityChecker::MakeNextLevel(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                                                                int* delimpts_, int* absstrpospts_)
{
  FunctionValidityChecker* ptr = NULL;

  if (Parent_ && Caller_)
    ptr = new FunctionValidityChecker(Parent_, Caller_, delimpts_, absstrpospts_);

  return ptr;
}

/****************************************************************************/
FunctionValidityChecker* FunctionValidityChecker::MakeSibling(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                                                              FunctionValidityChecker* Adjacent_, int* delimpts_, int* absstrpospts_)
{
  FunctionValidityChecker* ptr = NULL;

  if (Parent_ && Caller_)
    ptr = new FunctionValidityChecker(Parent_, Caller_, Adjacent_, delimpts_, absstrpospts_);

  return ptr;
}

/****************************************************************************/
void FunctionValidityChecker::SetLineRemaining(const char* str)
{
  _LineRemaining = str;
}

/****************************************************************************/
void FunctionValidityChecker::SetLineToProcess(const char* str, bool Reset_)
{
  _LineToProcess = str;

  if (Reset_)
  {
    ResetOperandRequired();
    _OriginalLine = _LineRemaining = str;
  }
}

/****************************************************************************/
char* FunctionValidityChecker::ExtractNumStr(const char* str, int& ptrdiff_)
{
  return (strchr(str, '.') ? ::ExtractFloat(str, ptrdiff_):
                             ::ExtractUnsignedNum(str, ptrdiff_));
}

/****************************************************************************/
void FunctionValidityChecker::ResizeCommaIndexes()
{
  if (!_Parent)
    return;

  int x;
  int oldsz = _commaindexsize;
  int* oldarray_ = _commaindexes;

  _commaindexsize += 10;
  _commaindexes = (int*)(_Parent->allocmem(_commaindexsize, sizeof(int), _commaindexes));

  for (x = 0; x < oldsz; x++)
    _commaindexes[x] = oldarray_[x];

  for (;x < _commaindexsize; x++)
    _commaindexes[x] = 0;

  _MemDel->DelayedDeleteVoidp(oldarray_, STOREMEM);
}

/****************************************************************************/
void FunctionValidityChecker::ResizeAbsStrPosIndexes()
{
  if (!_Parent)
    return;

  int x;
  int oldsz = _AbsStrPosIndexSize;
  int* oldarray_ = _AbsStrPosIndexes;

#if ADD_CHKSTROMIT
  _AbsStrPosIndexSize += 10;
  _AbsStrPosIndexes = (int*)(_Parent->allocmem(_AbsStrPosIndexSize, sizeof(int), _AbsStrPosIndexes));

  for (x = 0; x < oldsz; x++)
    _AbsStrPosIndexes[x] = oldarray_[x];

  for (;x < _AbsStrPosIndexSize; x++)
    _AbsStrPosIndexes[x] = 0;

  _MemDel->DelayedDeleteVoidp(oldarray_, STOREMEM);
#endif
}

/****************************************************************************/
bool FunctionValidityChecker::NextOperator(const char* str, int OpType_, int& pos,
                                           int& tlen_, bool SkipOnlyWs_, int* Index_)
{
  bool Fit_ = StrFits(str, pos);
  if (!Fit_)
    return 0;

  bool match = false;
  bool isfnc_ = false;
  int x;
  int fnx = -1;
  int toklen_ = 0;

  tlen_ = 1;

  if (OpType_ == BINARY_OPERATOR)
  {
    for (;str[pos] && !(match=_Parent->IsBinaryFunctions(str,pos,tlen_,isfnc_)) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
    match = match && !isfnc_;

    if (match)
      for (x = 0; _BinaryOpList[x] && fnx < 0; x++)
      {
        toklen_ = strlen(_BinaryOpList[x]);

        if (tlen_ == toklen_ && CheckForMatch(&str[pos], _BinaryOpList[x], toklen_))
          fnx = x;
      }

    if (Index_)
      *Index_ = fnx;
  }
  else if (OpType_ == BINARY_FUNCTION)
  {
    for (;str[pos] && !(match=_Parent->IsBinaryFunctions(str,pos,tlen_,isfnc_)) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
    match = match && isfnc_;

    if (match)
      for (x = 0; _BinaryOpList[x] && fnx < 0; x++)
      {
        toklen_ = strlen(_BinaryOpList[x]);

        if (tlen_ == toklen_ && CheckForMatch(&str[pos], _BinaryOpList[x], toklen_))
          fnx = x;
      }

    if (Index_)
      *Index_ = fnx;
  }
  else if (OpType_ == UNARY_OPERATOR)
  {
    for (;str[pos] && !(match=_Parent->IsUnaryFunctions(str,pos,tlen_,isfnc_)) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
    match = match && !isfnc_;

    if (match)
      for (x = 0; _UnaryOpList[x] && fnx < 0; x++)
      {
        toklen_ = strlen(_UnaryOpList[x]);

        if (tlen_ == toklen_ && CheckForMatch(&str[pos], _UnaryOpList[x], toklen_))
          fnx = x;
      }

    if (Index_)
      *Index_ = fnx;
  }
  else if (OpType_ == POSTFIX_OPERATOR)
    for (;str[pos] && !(match=_Parent->IsPostfixOperators(str[pos])) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == LEFT_BRACKETS)
    for (;str[pos] && !(match=_Parent->IsLeftBrkSymbols(str[pos])) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == RIGHT_BRACKETS)
    for (;str[pos] && !(match=_Parent->IsRightBrkSymbols(str[pos])) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == LEFT_BRACE)
    for (;str[pos] && !(match=(str[pos]=='{')) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == RIGHT_BRACE)
    for (;str[pos] && !(match=(str[pos]=='}')) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == QUOTE_CHAR)
    for (;str[pos] && !(match=(str[pos]=='\"')) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  else if (OpType_ == WHITESPACE_CHARS)
    for (;str[pos] && !(match=isspace(str[pos])) && isprint(str[pos]); pos++);

  return (str[pos] && match);
}

/****************************************************************************/
bool FunctionValidityChecker::NextOpenBrk(const char* str, int& pos, bool SkipOnlyWs_)
{
  bool Fit_ = StrFits(str, pos);
  if (!Fit_)
    return 0;

  bool match = false;
  for (;str[pos] && !(match=_Parent->IsLeftBrkSymbols(str[pos])) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  return (str[pos] && match);
}

/****************************************************************************/
bool FunctionValidityChecker::NextCloseBrk(const char* str, int& pos, bool SkipOnlyWs_)
{
  bool Fit_ = StrFits(str, pos);
  if (!Fit_)
    return 0;

  bool match = false;
  for (;str[pos] && !(match=_Parent->IsRightBrkSymbols(str[pos])) && ((!SkipOnlyWs_ && isprint(str[pos])) || isspace(str[pos])); pos++);
  return (str[pos] && match);
}

/****************************************************************************/
void FunctionValidityChecker::ConfirmAsValid()
{
  _Checked = _MaxToCheck;
  _Valid = true;
}

/****************************************************************************/
void FunctionValidityChecker::ConfirmAsInvalid()
{
  _Checked = _MaxToCheck;
  _Valid = false;
}

/****************************************************************************/
void FunctionValidityChecker::ConfirmAsMatched()
{
  _Checked = _MaxToCheck;
  _FunctionMatched = true;
}

/****************************************************************************/
void FunctionValidityChecker::SetNext(FunctionValidityChecker* ptr)
{
  if (_Next)
    _Next->SetCaller(NULL);

  delete _Next;
  _Next = ptr;

  if (_Next)
    _Next->SetCaller(this);
}

/****************************************************************************/
int FunctionValidityChecker::FindSiblingIndexSize()
{
  int x;
  int max = _SiblingIndexSize;

  if (!_SiblingIndexes || !_SiblingIndexes[0])
    max = 0;

  for (x = 0; x < max && _SiblingIndexes[x]; x++);
  return x;
}

/****************************************************************************/
void FunctionValidityChecker::SetSibling(FunctionValidityChecker* ptr, int* delimpts_, int* absstrpospts_)
{
  if (_Sibling)
    _Sibling->SetAdjacent(NULL, NULL, NULL);

  delete _Sibling;
  _Sibling = ptr;

  _SiblingIndexes = delimpts_;
  _SiblingAbsStrPosIndexes = absstrpospts_;

  if (!delimpts_)
    _SiblingIndexSize = 0;
  else if (_Adjacent)
    _SiblingIndexSize = _Adjacent->SiblingIndexSize() - 1;
  else
    _SiblingIndexSize = _Caller ? (_Caller->_commaindexsize - 1):0;

  if (!absstrpospts_)
    _SiblingAbsStrPosIndexSize = 0;
  else if (_Adjacent)
    _SiblingAbsStrPosIndexSize = _Adjacent->SiblingAbsStrPosIndexSize() - 1;
  else
    _SiblingAbsStrPosIndexSize = _Caller ? (_Caller->_AbsStrPosIndexSize - 1):0;

  HasSibling(_Caller);
  _SiblingIndexSize = FindSiblingIndexSize();

  if (_Sibling)
  {
    _Sibling->SetCaller(_Caller);
    _Sibling->SetAdjacent(this,
                          (delimpts_ != NULL && delimpts_[1]) ? &delimpts_[1]:NULL,
                          (absstrpospts_ != NULL && absstrpospts_[1]) ? &absstrpospts_[1]:NULL);
  }
}

/****************************************************************************/
void FunctionValidityChecker::SetAdjacent(FunctionValidityChecker* ptr, int* delimpts_, int* absstrpospts_)
{
  _Adjacent = ptr;

  _SiblingIndexes = delimpts_;
  _SiblingAbsStrPosIndexes = absstrpospts_;

  if (!delimpts_)
    _SiblingIndexSize = 0;
  else if (_Adjacent)
    _SiblingIndexSize = _Adjacent->SiblingIndexSize() - 1;
  else
    _SiblingIndexSize = _Caller ? (_Caller->_commaindexsize - 1):0;

  if (!absstrpospts_)
    _SiblingAbsStrPosIndexSize = 0;
  else if (_Adjacent)
    _SiblingAbsStrPosIndexSize = _Adjacent->SiblingAbsStrPosIndexSize() - 1;
  else
    _SiblingAbsStrPosIndexSize = _Caller ? (_Caller->_AbsStrPosIndexSize - 1):0;

  HasSibling(_Caller);
  _SiblingIndexSize = FindSiblingIndexSize();
}

/****************************************************************************/
bool FunctionValidityChecker::CheckForMatch(const char* trg, const char* src, int max)
{
  int x, y;
  int len;
  int brkpos;
  int slen;
  int tlen = max;
  int maxlen = ::SafeStrLen(trg);
  int minlen = max;

  bool Match_ = false;

  if (CalculatorBase::icasestrcompn(trg, src, max))
  {
    Match_ = true;

    for (x = y = 0; x < MAX_ALMOST_FNCS && _AlmostFncList[x] && Match_; x = y)
    {
      len = atoi(_AlmostFncList[x]);
      max = y + len;

      for (y = x+1; y <= max && Match_; y++)
      {
        brkpos =
        slen = ::SafeStrLen(_AlmostFncList[y]);

        if (slen == tlen && CalculatorBase::icasestrcompn(src, _AlmostFncList[y], slen))
          continue;
        else
        {
          Match_ = !(minlen <= slen && slen <= maxlen) ||
                   !CalculatorBase::icasestrcompn(trg, _AlmostFncList[y], slen);

          if (!Match_)
          {
            Match_ = !NextOpenBrk(trg, brkpos, true);

            if (Match_)
              Match_ = !(CalculatorBase::icasestrcompn("FRACPART", _AlmostFncList[y], 8) ||
                         CalculatorBase::icasestrcompn("FRACANS", _AlmostFncList[y], 7) ||
                         CalculatorBase::icasestrcompn("ANSSTR", _AlmostFncList[y], 6) ||
                         CalculatorBase::icasestrcompn("COMB", _AlmostFncList[y], 4) ||
                         CalculatorBase::icasestrcompn("PERM", _AlmostFncList[y], 4) ||
                         CalculatorBase::icasestrcompn("CUBE", _AlmostFncList[y], 4) ||
                         CalculatorBase::icasestrcompn("SIN", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("COS", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("TAN", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("LOG", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("ANS", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("XOR", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("EXP", _AlmostFncList[y], 3) ||
                         CalculatorBase::icasestrcompn("SQR", _AlmostFncList[y], 3));
          }
        }
      }
    }
  }

  return Match_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfFunctionValid(const char* str, bool Reset_, int len)
{
  bool BinChkDone_ = false;
  bool ret = false;

  if (Reset_)
  {
    Reset(true);
    ResetMultiArgChks();
  }

  if (str)
  {
    ret = ChkIfExcludedFncs(str, len);

    if (!ret)
    {
      ret = ChkIfSingleArgFncs(str, len);

      if (!ret)
      {
        ret = ChkIfDoubleArgFncs(str, len);

        if (!ret)
        {
          ret = ChkIfTripleArgFncs(str, len);

          if (!ret)
          {
            ret = ChkIfFourArgFncs(str, len);

            if (!ret)
            {
              ret = ChkIfFiveArgFncs(str, len);

              if (!ret)
              {
                ret = ChkIfSixArgFncs(str, len);

                if (!ret)
                {
                  ret = ChkIfVaryArgFncs(str, len);

                  if (!ret)
                  {
                    ret = ChkIfInQuotes(str, len);

                    if (!ret)
                    {
                      ret = ChkIfBracedExpr(str, len);

                      if (!ret)
                      {
                        ret = ChkIfBracketedExpr(str, len);

                        if (!ret)
                        {
                          if ((_IsOperandVal || _IsConstVal) && !_NextOperandRequired)
                          {
                            ret = ChkIfBinaryExpr(str, _OperandNeeded, len);
                            BinChkDone_ = true;

                            if (!ret)
                              ret = ChkIfOperand(str, len);
                          }
                          else
                            ret = ChkIfOperand(str, len);

                          if (!ret)
                          {
                            ret = ChkIfFracOp(str, len);

                            if (!ret)
                            {
                              ret = ChkIfUnaryExpr(str, _OperandNeeded, len);

                              if (!ret && (!_NextOperandRequired || BinChkDone_))
                              {
                                if (!BinChkDone_ && !_NextOperandRequired)
                                  ret = ChkIfBinaryExpr(str, _OperandNeeded, len);

                                if (!ret)
                                {
                                  ret = ChkIfInvalidFncs(str, len);

                                  if (!ret)
                                  {
                                    ret = ChkIfInvalidVars(str, len);

                                    if (ret)
                                      SetErrorCode(ERRCODE_INVALID_VARIABLES_FOUND);
                                  }
                                  else
                                    SetErrorCode(ERRCODE_INVALID_FUNCTIONS_FOUND);
                                }
                              }
                              else if (!ret)
                              {
                                ret = ChkIfInvalidFncs(str, len);

                                if (!ret)
                                {
                                  ret = ChkIfInvalidVars(str, len);

                                  if (ret)
                                    SetErrorCode(ERRCODE_INVALID_VARIABLES_FOUND);
                                }
                                else
                                  SetErrorCode(ERRCODE_INVALID_FUNCTIONS_FOUND);
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (ChkIfGraphSpecialCase(str, len))
    {
      _LineRemaining = _startpt;
      ret = ChkIfDoubleArgFncs(str, len);

      if (ret)
        ret = ConfirmedValid();

      if (!ret && ConfirmedMatched())
      {
        ResetErrors();
        ret = ChkFollowGraphFncs(str, len);
      }
    }
  }

  if (ret && _SpecialCaseIndex != NOT_SPECIALCASE && _SpecialCaseLen != 0)
  {
    ChkStrOmitToTxtStr();

    if (strcmp(_SpecialCaseList[_SpecialCaseIndex], "SET") == 0)
      ret = CheckSpecialCase_Set(str, len);
    else if ((strcmp(_SpecialCaseList[_SpecialCaseIndex], "ITEMPERM") == 0)    ||
             (strcmp(_SpecialCaseList[_SpecialCaseIndex], "ITEMCOMB") == 0)    ||
             (strcmp(_SpecialCaseList[_SpecialCaseIndex], "ITEMPERMREP") == 0) ||
             (strcmp(_SpecialCaseList[_SpecialCaseIndex], "ITEMCOMBREP") == 0))
      ret = CheckSpecialCase_ItemFncs(str, len);
  }
  else if (ret && _ExcludedCaseIndex != NOT_EXCLUDEDCASE && _ExcludedCaseLen != 0)
  {
    ChkStrOmitToTxtStr();

    if (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "SET") == 0)
      ret = CheckSpecialCase_Set(str, len);
    else if (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "PRECISION") == 0)
      ret = CheckExcludedCase_Precision(str, len);
    else if (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "MATSOLVE") == 0)
      ret = CheckExcludedCase_MatSolve(str, len);
    else if ((strcmp(_ExcludedFncList[_ExcludedCaseIndex], "ITEMPERM") == 0)    ||
             (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "ITEMCOMB") == 0)    ||
             (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "ITEMPERMREP") == 0) ||
             (strcmp(_ExcludedFncList[_ExcludedCaseIndex], "ITEMCOMBREP") == 0))
      ret = CheckSpecialCase_ItemFncs(str, len);
  }

  if (!ret)
    SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);
  else if (_Levels == 0 && !_Caller && ConfirmedValid())
    ResetErrors();

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::CheckSpecialCase_Set(const char* str, int len)
{
// set(a,4,1,2,3,5) : form 1
// set(c,a) : form 2
// set(d) : form 3
// set(e,{10,11,12,13}) : form 4
// set(f,sampleset1.cin) : form 5

  if (!str)
    return false;

  bool valid = false;
  bool formvalid_ = false;

  if (CalculatorBase::icasestrcompn(str, "SET", 3))
  {
    char* newstr_ = ::NewString(str);
    char* tok = NULL;
    char* p = newstr_ ? strchr(newstr_, '('):NULL;

    int x = 0;
    int tlen = 0;
    int form = 0;

    if (p && p[1] && ::SafeStrLen(newstr_))
    {
      ++p;
      tok = strtok(p, ",");

      for (x = 0; tok != NULL; x++)
      {
        tok = RemoveChar(tok, " \t\r\n");

        if (x == 0)
          valid = *tok && isalpha(*tok);
        else if (x >= 1)
        {
          if (*tok && x == 1 && strlen(tok) > 1 && ChkIfFileName(tok) && form == 0)
          {
            valid = true;
            form = 5;
          }
          else if (*tok && x == 1 && isalpha(*tok) && form == 0)
          {
            valid = true;
            form = 2;
          }
          else if (*tok && isdigit(*tok) && ((x == 1 && form == 0) || (x > 1 && form == 1)))
          {
            tlen = strlen(tok);
            valid = IsUnsignedNum(tok, 10);

            if (valid && form == 0)
            {
              tlen = 0;
              form = 1;
            }
            else if (!valid && form == 1)
            {
              if (tlen > 0)
              while (--tlen && !valid)
                if (!isspace(tok[tlen]))
                {
                  valid = tok[tlen] == ')';
                  break;
                }
                else if (isdigit(tok[tlen]))
                  break;

              if (valid)
              {
                tok[tlen] = 0;
                valid = IsUnsignedNum(tok, 10);
              }
            }
          }
          else if (*tok && ((*tok == '{' && isdigit(tok[1]) && x == 1 && form == 0) ||
                            (isdigit(*tok) && x > 1 && form == 4)))
          {
            tlen = strlen(tok);
            valid = (form == 0) ? (tlen > 1 && IsUnsignedNum(&tok[1], 10)):
                                  IsUnsignedNum(tok, 10);

            if (valid && form == 0)
            {
              tlen = 0;
              form = 4;
            }
            else if (!valid && form == 4)
            {
              if (tlen > 0)
              while (--tlen && !valid)
                if (!isspace(tok[tlen]) && tok[tlen] != ')')
                {
                  valid = tok[tlen] == '}';
                  break;
                }
                else if (isdigit(tok[tlen]))
                  break;

              if (valid)
              {
                tok[tlen] = 0;
                valid = IsUnsignedNum(tok, 10);
              }
            }
          }
        }

        tok = strtok(NULL, ",");

        if (!tok)
        {
          if (x == 0 && valid && form == 0)
          {
            form = 3;
            formvalid_ = true;
          }
          else if (x == 1 && form == 2)
          {
            formvalid_ = true;
            break;
          }
          else if ((x >= 1 && form == 1) ||
                   (x >= 1 && form == 4))
          {
            formvalid_ = true;
            break;
          }
          else if (x == 1 && form == 5)
          {
            formvalid_ = true;
            break;
          }
        }
      }
    }

    if (valid && formvalid_)
      SetChkStrOmitFromStart(1);
    else
      formvalid_ = false;

    _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);
  }

  return formvalid_;
}

/****************************************************************************/
bool FunctionValidityChecker::CheckSpecialCase_ItemFncs(const char* str, int len)
{
// itemperm(4,apple,orange,banana,watermelon)
// itempermrep(3,apple,orange,banana)
// itemcomb(2,apple,orange,banana,watermelon)
// itemcombrep(3,apple,orange,banana)
//
// first parameter is always a number

  if (!str)
    return false;

  bool valid_ = false;

  if (CalculatorBase::icasestrcompn(str, "ITEMPERM", 8)     ||
      CalculatorBase::icasestrcompn(str, "ITEMCOMB", 8)     ||
      CalculatorBase::icasestrcompn(str, "ITEMPERMREP", 11) ||
      CalculatorBase::icasestrcompn(str, "ITEMCOMBREP", 11))
  {
    char* newstr_ = ::NewString(str);
    char* tok = NULL;
    char* p = newstr_ ? strchr(newstr_, '('):NULL;

    int x = 0;
    int tlen = 0;

    if (p && p[1] && ::SafeStrLen(newstr_))
    {
      ++p;
      tok = strtok(p, ",");

      if (tok != NULL)
      {
        tok = RemoveChar(tok, " \t\r\n");
        tlen = strlen(tok);
        valid_ = *tok && tlen && isdigit(*tok);

        for (x = 1; x < tlen && valid_; x++)
          valid_ = isdigit(tok[x]);
      }
    }

    if (valid_)
      SetChkStrOmitFromStart(1);

    _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);
  }

  return valid_;
}

/****************************************************************************/
bool FunctionValidityChecker::CheckExcludedCase_Precision(const char* str, int len)
{
// precision=float
// precision=double
// precision=longdouble
// precision=longnum
//
// valid arguments for precision : {float, double, longdouble, longnum}

  if (!str)
    return false;

  bool valid_ = false;

  if (CalculatorBase::icasestrcompn(str, "PRECISION", 9))
  {
    char* newstr_ = ::NewString(str);
    char* tok = NULL;
    char* p = newstr_ ? strchr(newstr_, '='):NULL;
    int tlen = 0;

    if (p && p[1] && ::SafeStrLen(newstr_))
    {
      ++p;
      tok = RemoveChar(p, " \t\r\n");

      tlen = strlen(tok);
      valid_ = *tok && tlen &&
               (CalculatorBase::icasestrcompn(tok, "float", 5) ||
                CalculatorBase::icasestrcompn(tok, "double", 6) ||
                CalculatorBase::icasestrcompn(tok, "longdouble", 10) ||
                CalculatorBase::icasestrcompn(tok, "longnum", 7));
    }

    if (valid_)
      SetChkStrOmitFromStart(1);

    _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);
  }

  return valid_;
}

/****************************************************************************/
bool FunctionValidityChecker::CheckExcludedCase_MatSolve(const char* str, int len)
{
// matsolve((1,2,3|1),(2,6,10|0),(3,14,28|-8))
//
// all parameters withing inner brackets and "|" are integers

  if (!str)
    return false;

  bool valid_ = false;

  if (CalculatorBase::icasestrcompn(str, "MATSOLVE", 8))
  {
    char* newstr_ = ::NewString(str);
    char* tok = NULL;
    char* p = newstr_ ? strchr(newstr_, '('):NULL;
    char* bpt = NULL;
    bool signed_ = false;

    int x = 0;
    int y = 0;
    int tlen = 0;

    while (p && (p[1] || y) && ::SafeStrLen(newstr_))
    {
      if (y == 0)
      {
        ++p;
        p = strchr(p, '(');
      }

      bpt = NULL;

      if (p && (p[1] || y))
      {
        for (p = y ? NULL:&p[1]; !bpt && (tok = strtok(p, ",|"));)
        {
          tok = RemoveChar(tok, " \t\r\n");
          tlen = strlen(tok);
          bpt = strchr(tok, ')');
          signed_ = *tok && tlen > 1 && (*tok == '+' || *tok == '-');
          valid_ = *tok && tlen &&
                   (isdigit(tok[0]) || (signed_ && isdigit(tok[1])));

          if (y > 0 && tlen > 0 &&
              !valid_ && !bpt && *tok == '(')
          {
            ++tok;
            tlen = strlen(tok);
            signed_ = *tok && tlen > 1 && (*tok == '+' || *tok == '-');
            valid_ = *tok && tlen &&
                     (isdigit(tok[0]) || (signed_ && isdigit(tok[1])));
          }

          if (valid_ && bpt)
          {
            *bpt = 0;
            tlen = strlen(tok);
          }

          for (x = (signed_ && valid_) ? 2:1; x < tlen && valid_; x++)
            valid_ = isdigit(tok[x]);

          p = NULL;
        }

        y++;
        p = bpt;
        if (bpt && *bpt == 0)
          *bpt = ')';
      }
    }

    if (valid_)
      SetChkStrOmitFromStart(1);

    _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);
  }

  return valid_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfFileName(const char* str, int len)
{
  // Exclude file names: isprint, no quotes, no spaces,
  //                     no operators, no brackets
  // ---------------------------------------------------------------

  int x;
  int slen = ::SafeStrLen(str);
  int tlen_ = 0;

  bool unfnc_ = false;
  bool binfnc_ = false;
  bool isfnc_ = false;
  bool valid_ = true;
  bool formvalid_ = false;

  for (x = 0; valid_ && x < slen; x++)
  {
    valid_ = isprint(str[x]) && !_Parent->IsBrkSymbols(str[x]) &&
             !isspace(str[x]) && str[x] != '\'' && str[x] != '\"';

    if (valid_)
    {
      binfnc_ = _Parent->IsBinaryFunctions(str, x, tlen_, isfnc_);

      if (binfnc_)
        valid_ = isfnc_ && str[tlen_] &&
                 !(isspace(str[tlen_]) ||
                   _Parent->IsLeftBrkSymbols(str[tlen_]));

      if (valid_)
      {
        unfnc_ = _Parent->IsUnaryOperators(str[x]);

        if (unfnc_)
          valid_ = false;
        else
          valid_ = !_Parent->IsPostfixOperators(str[x]);
      }
    }
  }

  if (valid_)
  {
    formvalid_ = valid_;

    for (x = 0; x < slen && valid_; x++)
    {
      valid_ = isprint(str[x]) && !_Parent->IsBrkSymbols(str[x]) &&
               !isspace(str[x]) && str[x] != '\'' && str[x] != '\"';

      if (valid_)
        SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
    }
  }

  return formvalid_;
}

/****************************************************************************/
int FunctionValidityChecker::SetChkStrOmitFromStart(int v)
{
  if (_RelChkStrIndex == 0)
    return v;

  int x;
  int saved_ = _RelChkStrIndex;

  _RelChkStrIndex = 0;
  _AbsChkStrIndex -= saved_;

  for (x = 0; x < saved_; x++)
    SetChkStrOmit(IncrSpecialCaseIndexes(), v);

  return v;
}

/****************************************************************************/
int FunctionValidityChecker::SetChkStrOmit(int x, int v)
{
#if ADD_CHKSTROMIT
  if (0 <= x && x < _ChkStrSize)
  {
    if (_ChkStrOmitPtr)
      (*_ChkStrOmitPtr)[x] = v;
    else if (_ChkStrOmit)
      (*_ChkStrOmit)[x] = v;
  }
#endif

  return v;
}

/****************************************************************************/
int FunctionValidityChecker::GetChkStrOmit(int x) const
{
  int v = 0;
  if (0 <= x && x < _ChkStrSize)
  {
    if (_ChkStrOmitPtr)
      v = (*_ChkStrOmitPtr)[x];
    else if (_ChkStrOmit)
      v = (*_ChkStrOmit)[x];
  }

  return v;
}

/****************************************************************************/
bool FunctionValidityChecker::CompareLastSpecialIndexPos(int cprocessed_, bool Adjust_, bool Report_, int Stream_)
{
  if (!_LastChkStrIndexSaved)
    return true;

  int x;
  int diff_ = _AbsChkStrIndex - _LastChkStrIndex;
  int incr_ = diff_;

#if ADD_CHKSTROMIT
  if (diff_ == cprocessed_)
    return true;
  else
    diff_ = cprocessed_ - incr_;

  if (diff_ > 0)
  {
    if (Adjust_)
    {
      for (x = 0; x < diff_; x++)
        SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

      return true;
    }
    else if (Report_)
    {
      if ((Stream_ & 1) != 0)
        cout <<ERRMSG_CHKSTROMIT_VALUE_MISMATCHED <<cprocessed_
             <<MSG_ACTUAL_PTR_INCR <<incr_ <<endl;

      if ((Stream_ & 2) != 0)
        cerr <<ERRMSG_CHKSTROMIT_VALUE_MISMATCHED <<cprocessed_
             <<MSG_ACTUAL_PTR_INCR <<incr_ <<endl;
    }

    return false;
  }
#endif

  return (diff_ == 0);
}

/****************************************************************************/
bool FunctionValidityChecker::SaveLastSpecialIndexPos()
{
  if (_LastChkStrIndexSaved)
    return false;

  _LastChkStrIndex = _AbsChkStrIndex;
  _LastChkStrIndexSaved = true;
  return true;
}

/****************************************************************************/
bool FunctionValidityChecker::RestoreLastSpecialIndexPos()
{
  if (!_LastChkStrIndexSaved)
    return false;

  _LastChkStrIndex = 0;
  _LastChkStrIndexSaved = false;
  return true;
}

/****************************************************************************/
bool FunctionValidityChecker::SaveSpecialCaseIndexes()
{
  bool Saved_ = _SavedChkStrIndex == 0 &&
                _AbsStrPosIndexes && _AbsStrPosIndexes[0];

  _SavedChkStrIndex = _AbsChkStrIndex;
  _AbsChkStrIndex = _AbsStrPosIndexes[0];

  return Saved_;
}

/****************************************************************************/
bool FunctionValidityChecker::RestoreSpecialCaseIndexes()
{
  bool Restored_ = _SavedChkStrIndex != 0;
  _AbsChkStrIndex = _SavedChkStrIndex;
  _SavedChkStrIndex = 0;

  return Restored_;
}

/****************************************************************************/
int FunctionValidityChecker::IncrSpecialCaseIndexes()
{
  int x = _AbsChkStrIndex;
  _AbsChkStrIndex++;
  _RelChkStrIndex++;

  return x;
}

/****************************************************************************/
int FunctionValidityChecker::DecrSpecialCaseIndexes()
{
  --_AbsChkStrIndex;
  --_RelChkStrIndex;
  return _AbsChkStrIndex;
}

/****************************************************************************/
void FunctionValidityChecker::SetAbsPosIndex(int x, bool setomit_, int v)
{
  int diff = x - _AbsChkStrIndex;
  int old = _AbsChkStrIndex;
  int i;

  _AbsChkStrIndex += diff;
  _RelChkStrIndex += diff;

#if ADD_CHKSTROMIT
  if (setomit_)
    for (i = 0; i < diff; i++, old++)
      SetChkStrOmit(old, v);
#endif
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfSpecialCase(char** FncList_, int x, int len, int sch, int ech)
{
  int i;
  int slen;
  int index = x;
  bool endspec_ = sch && ech;
  char* str = !endspec_ ? FncList_[index]:FncList_[0];

#if ADD_CHKSTROMIT
  if (!str)
    return false;
  else if (endspec_)
  {
    if (sch == QUOTE_CHAR && ech == QUOTE_CHAR && str && str[x] == '\"' && len >= 2)
    {
      _SpecialCaseIndex = INQUOTES_SPECIALCASE;
      _SpecialCaseLen = 0;
      return true;
    }
    else if (sch == '{' && ech == '}' && str && str[x] == '{' && len >= 2)
    {
      _SpecialCaseIndex = INBRACES_SPECIALCASE;
      _SpecialCaseLen = 0;
      return true;
    }
    else if (len >= 2 && str &&
             ((sch == '[' && ech == ']' && str[x] == '[') ||
              (sch == '(' && ech == ')' && str[x] == '(')))
    {
      _SpecialCaseIndex = INBRACKETS_SPECIALCASE;
      _SpecialCaseLen = 0;
      return true;
    }
    else if (FncList_ == _ConstsAndVars ||
             FncList_ == _UnaryOpList ||
             FncList_ == _BinaryOpList)
    {
      _SpecialCaseIndex = (FncList_ == _UnaryOpList) ? UNARYOPLIST_SPECIALCASE:
                          (FncList_ == _BinaryOpList) ? BINARYOPLIST_SPECIALCASE:
                                                        CONSTANDVARS_SPECIALCASE;
      _SpecialCaseLen = 0;
      return true;
    }
  }

  for (x = 0; _SpecialCaseList[x]; x++)
  {
    slen = strlen(_SpecialCaseList[x]);

    if (len == slen && CalculatorBase::icasestrcompn(str, _SpecialCaseList[x], slen))
    {
      for (i = 0; i < slen; i++)
        SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

      _SpecialCaseIndex = x;
      _SpecialCaseLen = slen;
      return true;
    }
  }

  if (str && len)
    for (i = 0; i < len; i++)
      SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
#endif

  _SpecialCaseIndex = NOT_SPECIALCASE;
  _SpecialCaseLen = 0;
  return false;
}

/****************************************************************************/
int* FunctionValidityChecker::OmitSpecialCases(int numargs_)
{
  if (_SpecialCaseIndex == NOT_SPECIALCASE)
    return NULL;

  int slen = _SpecialCaseLen;
  int* ParamArray_ = NULL;

#if ADD_CHKSTROMIT
  if (slen == 0 &&
      (_SpecialCaseIndex == CONSTANDVARS_SPECIALCASE ||
       _SpecialCaseIndex == UNARYOPLIST_SPECIALCASE ||
       _SpecialCaseIndex == BINARYOPLIST_SPECIALCASE))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_NONE;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 0 &&
           (_SpecialCaseIndex == INQUOTES_SPECIALCASE || _SpecialCaseIndex == INBRACES_SPECIALCASE || _SpecialCaseIndex == INBRACKETS_SPECIALCASE))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_ALLSTRINGS;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 11 && CalculatorBase::icasestrcompn("ITEMPERMREP", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 0;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_ALL;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 11 && CalculatorBase::icasestrcompn("ITEMCOMBREP", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 0;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_ALL;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 9 && CalculatorBase::icasestrcompn("INTERSECT", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    if (numargs_ == 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 4);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = PARAM_CONTINUE_NONE;
      ParamArray_[3] = PARAM_END;
    }
    else if (numargs_ > 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(5, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 5);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = 1;
      ParamArray_[3] = PARAM_CONTINUE_NONE;
      ParamArray_[4] = PARAM_END;
    }
  }
  else if (slen == 8 && CalculatorBase::icasestrcompn("ITEMPERM", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 0;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_ALL;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 8 && CalculatorBase::icasestrcompn("ITEMCOMB", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 0;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_ALL;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 7 && CalculatorBase::icasestrcompn("SETXDIF", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 7 && CalculatorBase::icasestrcompn("SHOWSET", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 6 && CalculatorBase::icasestrcompn("DERIV2", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 1;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_NONE;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 6 && CalculatorBase::icasestrcompn("SETUNI", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 6 && CalculatorBase::icasestrcompn("SETINT", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 6 && CalculatorBase::icasestrcompn("SETDIF", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 5 && CalculatorBase::icasestrcompn("DERIV", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 1;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_NONE;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 5 && CalculatorBase::icasestrcompn("INTEG", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 1;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_NONE;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 5 && CalculatorBase::icasestrcompn("SOLVE", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 4);

    ParamArray_[0] = 1;
    ParamArray_[1] = 1;
    ParamArray_[2] = PARAM_CONTINUE_NONE;
    ParamArray_[3] = PARAM_END;
  }
  else if (slen == 5 && CalculatorBase::icasestrcompn("GRAPH", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    if (numargs_ == 2)
    {
      ParamArray_ = (int*)(_Parent->allocmem(3, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 3);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = PARAM_END;
    }
    else if (numargs_ == 0)
    {
      ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 2);

      ParamArray_[0] = PARAM_ALLSTRINGS;
      ParamArray_[1] = PARAM_END;
    }
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("FMIN", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    if (numargs_ == 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 4);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = PARAM_CONTINUE_NONE;
      ParamArray_[3] = PARAM_END;
    }
    else if (numargs_ > 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(7, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 7);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = 0;
      ParamArray_[3] = 0;
      ParamArray_[4] = 1;
      ParamArray_[5] = PARAM_CONTINUE_NONE;
      ParamArray_[6] = PARAM_END;
    }
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("FMAX", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    if (numargs_ == 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(4, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 4);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = PARAM_CONTINUE_NONE;
      ParamArray_[3] = PARAM_END;
    }
    else if (numargs_ > 4)
    {
      ParamArray_ = (int*)(_Parent->allocmem(7, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 7);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = 0;
      ParamArray_[3] = 0;
      ParamArray_[4] = 1;
      ParamArray_[5] = PARAM_CONTINUE_NONE;
      ParamArray_[6] = PARAM_END;
    }
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("FRAC", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(3, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 3);

    ParamArray_[0] = 1;
    ParamArray_[1] = PARAM_CONTINUE_NONE;
    ParamArray_[2] = PARAM_END;
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("EVAL", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("SHOW", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_CONTINUE_ALL;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 4 && CalculatorBase::icasestrcompn("EXEC", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
    ::memset(ParamArray_, 0, sizeof(int) * 2);

    ParamArray_[0] = PARAM_ALLSTRINGS;
    ParamArray_[1] = PARAM_END;
  }
  else if (slen == 3 && CalculatorBase::icasestrcompn("SET", _SpecialCaseList[_SpecialCaseIndex], slen))
  {
    if (numargs_ == 1)
    {
      ParamArray_ = (int*)(_Parent->allocmem(2, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 2);

      ParamArray_[0] = 1;
      ParamArray_[1] = PARAM_END;
    }
    else if (numargs_ == 2)
    {
      ParamArray_ = (int*)(_Parent->allocmem(3, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 3);

      ParamArray_[0] = 1;
      ParamArray_[1] = 1;
      ParamArray_[2] = PARAM_END;
    }
    else if (numargs_ > 2)
    {
      ParamArray_ = (int*)(_Parent->allocmem(3, sizeof(int), ParamArray_));
      ::memset(ParamArray_, 0, sizeof(int) * 3);

      ParamArray_[0] = 1;
      ParamArray_[1] = PARAM_CONTINUE_NONE;
      ParamArray_[2] = PARAM_END;
    }
  }
#endif

  return ParamArray_;
}

/****************************************************************************/
bool FunctionValidityChecker::OmitSpecialParams(int* ParamArray_, int brkbal, int& p, char c)
{
#if ADD_CHKSTROMIT
  if (brkbal != 1 || !ParamArray_ || ParamArray_[p] == NO_PARAMS)
  {
    if (c == ',' && brkbal == 1 && !ParamArray_)
      SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
    else
      IncrSpecialCaseIndexes();

    return false;
  }

  if (c == ',' &&
      !(ParamArray_[p] == PARAM_END || (ParamArray_[p] >= 0 && ParamArray_[p+1] == PARAM_END)))
  {
    SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

    if (ParamArray_[p] >= 0)
      ++p;
  }
  else
  {
    if (ParamArray_[p] == PARAM_END || ParamArray_[p] == PARAM_CONTINUE_NONE || ParamArray_[p] == 0)
    {
      if (c && isspace(c))
        SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      else
        IncrSpecialCaseIndexes();

      if (ParamArray_[p] == 0)
        ++p;

      return false;
    }
    else if (ParamArray_[p] == PARAM_ALLSTRINGS || ParamArray_[p] == PARAM_CONTINUE_ALL || ParamArray_[p] == 1)
    {
      SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

      if (ParamArray_[p] == 1)
        ++p;

      return true;
    }
  }
#endif

  return false;
}

/****************************************************************************/
void FunctionValidityChecker::ResizeChkStrOmit(int max)
{
  if (_ChkStrOmit)
  {
    _ChkStrOmit->Resize(max);

    if (_ChkStrSize && max > _ChkStrSize)
    {
      short* oldvect = _ChkStrCase;
      int oldsz = _ChkStrSize;
      int x;

      _ChkStrSize = max;
      _ChkStrCase = (short*)(_Parent->allocmem(_ChkStrSize, sizeof(short), _ChkStrCase));
      ::memset(_ChkStrCase, 0, sizeof(short) * _ChkStrSize);

      for (x = 0; x < oldsz; x++)
        _ChkStrCase[x] = oldvect[x];

      _MemDel->DelayedDeleteVoidp(oldvect, STOREMEM);
    }
  }
}

/****************************************************************************/
char* FunctionValidityChecker::RemoveAndOpStr(const char* str, int& AndIndex_, bool& AndFound_)
{
  if (!str)
    return NULL;

  char* newstr_ = ::NewString(str);
  char* p = NULL;

  int x;
  int len = strlen(newstr_);
  AndFound_ = false;

  for (x = 0; x < len; x++)
  {
    p = strchr(newstr_, 'a');
    if (!p)
      p = strchr(newstr_, 'A');

    if (p &&
        p[1] && toupper(p[1]) == 'N' &&
        p[2] && toupper(p[2]) == 'D')
    {
      AndIndex_ = p - newstr_;
      AndFound_ = true;
      p[0] = p[1] = p[2] = ' ';

      p = newstr_;
      break;
    }
  }

  if (!AndFound_)
    _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);

  return p;
}

/****************************************************************************/
void FunctionValidityChecker::SetChkFncPrec(bool v, bool Reset_)
{
  if (Reset_)
    FunctionValidityChecker::_FncPrecChk = CHKFNCPREC_INIT;
  else
    FunctionValidityChecker::_FncPrecChk = v ? CHKFNCPREC_YES:CHKFNCPREC_NO;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkYesFncPrec()
{
  return (FunctionValidityChecker::_FncPrecChk == CHKFNCPREC_YES);
}

/****************************************************************************/
bool FunctionValidityChecker::ChkNoFncPrec()
{
  return (FunctionValidityChecker::_FncPrecChk == CHKFNCPREC_NO);
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfChkFncPrecFncs(const char* str)
{
  if (_FncPrecChk == CHKFNCPREC_NO || !str || strlen(str) == 0)
    return false;

  int x;
  int slen = strlen(str);
  int toklen;

  for (x = 0; _ChkFncPrecList[x]; x++)
  {
    toklen = strlen(_ChkFncPrecList[x]);

    if (toklen == slen && CalculatorBase::icasestrcompn(str, _ChkFncPrecList[x], toklen))
    {
      _FncPrecChk = CHKFNCPREC_YES;
      return true;
    }
  }

  _FncPrecChk = CHKFNCPREC_NO;
  return false;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfGraphSpecialCase(const char* str, int len)
{
  int x;
  int slen = ::SafeStrLen(str);
  int wlen = 5;
  bool match = false;

  const char* grpt;
  const char* nxpt;
  const char* word = "GRAPH";

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);

    grpt = strchr(str, 'g');
    if (!grpt)
      grpt = strchr(str, 'G');

    if (grpt)
    {
      for (x = 1; x < wlen && grpt[x]; x++)
      {
        match = toupper(grpt[x]) == word[x];
        if (!match)
          break;
      }

      if (match && grpt[x] && grpt + wlen < _endpt)
      {
        grpt += wlen;
        match = *grpt && (nxpt=strchr(grpt, '('));

        if (match && nxpt)
        {
          grpt = nxpt;
          match = *grpt && strchr(grpt, ')');
        }
      }
    }
  }

  return match;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkFollowGraphFncs(const char* str, int len)
{
  int x;
  int slen = ::SafeStrLen(str);
  int wlen = 5;
  bool match = false;

  const char* grpt;
  const char* nxpt;
  const char* word = "GRAPH";

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);

    grpt = strchr(str, 'g');
    if (!grpt)
      grpt = strchr(str, 'G');

    if (grpt)
    {
      for (x = 1; x < wlen && grpt[x]; x++)
      {
        match = toupper(grpt[x]) == word[x];
        if (!match)
          break;
      }

      if (match && grpt[x] && grpt + wlen < _endpt)
      {
        grpt += wlen;
        match = *grpt && (isspace(*grpt) || isalpha(*grpt));

        if (match)
        {
          _IgnoredCmd = true;
          while (*grpt && isspace(*grpt))
            ++grpt;

          match = *grpt && isalpha(*grpt);

          if (match)
          {
            wlen = grpt - _startpt;
            _LineRemaining = _startpt + wlen;

            slen = strlen(_LineRemaining);
            return ChkIfFunctionValid(_LineRemaining, false, slen);
          }
        }
      }
    }
  }

  return match;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfExcludedFncs(const char* str, int len)
{
  // set(e,{ 10,11,12,13 });
  // setxdif(h,f,g);
  // setdif(c,f,g);
  // setuni(i,d,a);
  // setint(c,b,d);
  //
  // precision=longdouble;  // no brk required
  // getprecision;          // no brk required
  // exec trigtestnp;       // no brk required
  //
  // itemperm(4,apple,orange,banana,watermelon);
  // itemcomb(2,apple,orange,banana,watermelon);
  // itemcombrep(3,apple,orange,banana);
  // itempermrep(3,apple,orange,banana);
  //
  // matsolve((1, 2,  3  | 1),
  //          (2, 6,  10 | 0),
  //          (3, 14, 28 | -8));
  //

  int x;
  int i;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int FncSel_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;
  const char* orgstr = _OriginalStr;

  bool spcreqfnc_ = false;
  bool nobrkfnc_ = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool NoArgCmd_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    _ExcludedCaseLen = 0;
    _ExcludedCaseIndex = NOT_EXCLUDEDCASE;

    for (x = 0; _ExcludedFncList[x]; x++)
    {
      toklen = slen = strlen(_ExcludedFncList[x]);
      spcreqfnc_ = (slen == 5 && CalculatorBase::icasestrcompn("GRAPH", _ExcludedFncList[x], slen)) ||
                   (slen == 4 && CalculatorBase::icasestrcompn("EXEC", _ExcludedFncList[x], slen));
      nobrkfnc_ = (slen == 12 && CalculatorBase::icasestrcompn("GETPRECISION", _ExcludedFncList[x], slen)) ||
                  (slen == 9 && CalculatorBase::icasestrcompn("PRECISION", _ExcludedFncList[x], slen)) ||
                  spcreqfnc_;

      if (CheckForMatch(str, _ExcludedFncList[x], toklen) &&
          ((nobrkfnc_ && (!spcreqfnc_ || isspace(orgstr[toklen]))) ||
           NextOpenBrk(str, slen, true)))
      {
        _ExcludedCaseLen = toklen;
        _ExcludedCaseIndex = x;

        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_ExcludedFncList, x, toklen);

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        FncSel_ = x;
        x = slen;
        obrkfound_= true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = nobrkfnc_ ? 0:1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(0);
        }

        if (!nobrkfnc_)
        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            commacnt++;
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        cbrkfound_ = !nobrkfnc_ &&
                     brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, VARYARGFNC, VARYARGFNC))
        {
          _closebrkpt = &str[x-1];
          SetTokenType(FUNCTION_TOKEN, VARYARGFNC, VARYARGFNC);
        }
        else if (!cbrkfound_)
        {
          NoArgCmd_ =
            CalculatorBase::icasestrcompn("GETPRECISION", _ExcludedFncList[FncSel_], 12) ||
            CalculatorBase::icasestrcompn("PRECISION", _ExcludedFncList[FncSel_], 9) ||
            CalculatorBase::icasestrcompn("GRAPH", _ExcludedFncList[FncSel_], 5) ||
            CalculatorBase::icasestrcompn("EXEC", _ExcludedFncList[FncSel_], 4);
        }

        if (!_closebrkpt && !NoArgCmd_)
        {
          VarArgName_ = HasVarArgFncName(str, 0, len);
          if (!VarArgName_)
            ConfirmAsInvalid();
        }

        break;
      }
    }

    if (!ConfirmedInvalid() && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = NoArgCmd_ ? (str + slen):
                       (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if ((cbrkfound_ && _closebrkpt) || NoArgCmd_)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        RestoreLastSpecialIndexPos();
        SavedLastPos_ = false;

        // No need to check next level.
        // Assume brace contents valid and treat as constant operand
        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
          {
            _LineRemaining++;
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          }

        if (!HasLineRemaining())
          ConfirmAsValid();
        else
          _IgnoredCmd = true;
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfVarxFncs(const char* str)
{
  int x;
  int slen = ::SafeStrLen(str);
  int toklen;
  bool FncMatch_ = false;

  if (str && slen)
    for (x = 0; _VarxFncList[x] && !FncMatch_; x++)
    {
      toklen = slen = strlen(_VarxFncList[x]);
      FncMatch_ = CheckForMatch(str, _VarxFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
        FncMatch_ = true;
      else
        FncMatch_ = false;
    }

  return FncMatch_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfSingleArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int fnx = 0;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool nofncprec_ = ChkNoFncPrec();
  bool yesfncprec_ = ChkYesFncPrec();
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _SingleArgFncList[x]; x++)
    {
      toklen = slen = strlen(_SingleArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _SingleArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        fnx = x;
        if (nofncprec_)
          SetChkFncPrec(false, true);

        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_SingleArgFncList, x, toklen);

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_= true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(1);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);

            commacnt++;
            commaerror_ = true;
            break;
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"1afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, SINGLEARGFNC, SINGLEARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, SINGLEARGFNC, SINGLEARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 1, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"1afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 0 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        ConfirmAsMatched();
        if (!yesfncprec_ && !ChkYesFncPrec())
          ChkIfChkFncPrecFncs(_SingleArgFncList[fnx]);
        ResetOperandRequired();
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, NULL, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (nofncprec_ && !ChkYesFncPrec())
  {
    SetFncPrecForSingleArgFncsDone(true);

    if (!VarArgName_ || ChkFncPrecForVaryArgFncsDone())
      SetChkFncPrec(false);
    else
      SetChkFncPrec(false, true);
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"1afcv:" <<ChkStrOmitToTxtStr() <<endl;

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfDoubleArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _DoubleArgFncList[x]; x++)
    {
      toklen = slen = strlen(_DoubleArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _DoubleArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_DoubleArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(2);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;

            if (commacnt > 1)
            {
              commaerror_ = true;
              break;
            }
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"2afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, DOUBLEARGFNC, DOUBLEARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, DOUBLEARGFNC, DOUBLEARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 2, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"2afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 1 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"2afcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfTripleArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _TripleArgFncList[x]; x++)
    {
      toklen = slen = strlen(_TripleArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _TripleArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_TripleArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(3);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;

            if (commacnt > 2)
            {
              commaerror_ = true;
              break;
            }
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"3afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, TRIPLEARGFNC, TRIPLEARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, TRIPLEARGFNC, TRIPLEARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 3, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"3afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 2 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"3afcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfFourArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _FourArgFncList[x]; x++)
    {
      toklen = slen = strlen(_FourArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _FourArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_FourArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(4);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;

            if (commacnt > 3)
            {
              commaerror_ = true;
              break;
            }
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"4afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, FOURARGFNC, FOURARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, FOURARGFNC, FOURARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 4, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"4afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 3 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"4afcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfFiveArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _FiveArgFncList[x]; x++)
    {
      toklen = slen = strlen(_FiveArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _FiveArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_FiveArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(5);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;

            if (commacnt > 4)
            {
              commaerror_ = true;
              break;
            }
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"5afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, FIVEARGFNC, FIVEARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, FIVEARGFNC, FIVEARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 5, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"5afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 4 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"5afcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfSixArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;
  bool FncMatch_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _SixArgFncList[x]; x++)
    {
      toklen = slen = strlen(_SixArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _SixArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_SixArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(6);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;

            if (commacnt > 5)
            {
              commaerror_ = true;
              break;
            }
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"6afbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, SIXARGFNC, SIXARGFNC))
        {
          _closebrkpt = &str[x-1];
          if (!commaerror_)
            SetTokenType(FUNCTION_TOKEN, SIXARGFNC, SIXARGFNC);
        }

        if (!_closebrkpt || commaerror_)
        {
          VarArgName_ = HasVarArgFncName(str, 6, len);

          if (!VarArgName_)
          {
            if (!_closebrkpt)
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
            else
              SetErrorCode(ERRCODE_MISPLACED_COMMA);

            ConfirmAsInvalid();

            if (obrkfound_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > saved_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
          else
          {
            RestoreSnapshot();
            Reset(false);
          }
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"6afdb:" <<ChkStrOmitToTxtStr() <<endl;
        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt == 5 && !VarArgName_)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"6afcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfVaryArgFncs(const char* str, int len)
{
  int i;
  int x;
  int p;
  int fnx = 0;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int saved_ = 0;
  int savedat_ = 0;
  int toklen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int FncSel_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool nofncprec_ = ChkNoFncPrec();
  bool yesfncprec_ = ChkYesFncPrec();
  bool ret = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool FncMatch_ = false;
  bool DoChkFrac_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _VaryArgFncList[x]; x++)
    {
      toklen = slen = strlen(_VaryArgFncList[x]);
      FncMatch_ = CheckForMatch(str, _VaryArgFncList[x], toklen);

      if (FncMatch_ && NextOpenBrk(str, slen, true))
      {
        fnx = x;
        if (nofncprec_)
          SetChkFncPrec(false, true);

        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_VaryArgFncList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        for (i = toklen ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

        saved_ = _AbsChkStrIndex - 1;
        savedat_ = (toklen <= slen) ? 1:0;

        if (saved_ < 0)
        {
          saved_ = 0;
          savedat_ *= -1;
        }

        FncSel_ = x;
        x = slen;
        obrkfound_ = true;
        _openbrkpt = &str[x];
        _openbrkcnt++;

        brkbal = 1;
        slen = ::SafeStrLen(str);
        max = _endpt ? GetStrLen():slen;
        _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(-1);
        }

        for (++x; x < max && brkbal; x++)
        {
          if (str[x] == '(')
          {
            brkbal++;
            _openbrkcnt++;
            IncrSpecialCaseIndexes();
          }
          else if (str[x] == ')')
          {
            brkbal--;
            _closebrkcnt++;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
          else if (str[x] == ',' && brkbal == 1)
          {
            if (commacnt >= _commaindexsize)
              ResizeCommaIndexes();

            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            _commaindexes[commacnt++] = x;
          }
          else
            OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        }

        if (_Debugging)
          cout <<"str:" <<str <<endl
               <<"vafbrk:" <<ChkStrOmitToTxtStr() <<endl;

        cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

        if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, VARYARGFNC, VARYARGFNC))
        {
          _closebrkpt = &str[x-1];
          SetTokenType(FUNCTION_TOKEN, VARYARGFNC, VARYARGFNC);
          DoChkFrac_ = CalculatorBase::icasestrcompn(_VaryArgFncList[FncSel_], "FRAC", 4);
        }

        if (!_closebrkpt)
        {
          if (!_closebrkpt)
            SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
          else
            SetErrorCode(ERRCODE_MISPLACED_COMMA);

          ConfirmAsInvalid();

          if (obrkfound_)
          {
            if (argcnt > 0)
              _AbsStrPosIndexes[--argcnt] = 0;

            if (saved_ >= 0 && _AbsChkStrIndex >= saved_ && savedat_ != 0)
            {
              if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                SetChkStrOmit(AbsPosIndex(), 0);

              while (_AbsChkStrIndex > saved_)
                SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
            }
          }
        }

        break;
      }
      else if (FncMatch_)
      {
        SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
        ConfirmAsInvalid();
      }
    }

    if (!ConfirmedInvalid() && commacnt >= 2)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt)
      {
        ConfirmAsMatched();
        if (!yesfncprec_ && !ChkYesFncPrec())
          ChkIfChkFncPrecFncs(_VaryArgFncList[fnx]);
        ResetOperandRequired();
        _VarxAllowed = varxfnc_;
        SpecialCase_ = SaveSpecialCaseIndexes();
        SetNext(MakeNextLevel(_Parent, this, _commaindexes, _AbsStrPosIndexes));

        if (_Next && DoChkFrac_)
          _Next->SetChkFrac(true);

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (nofncprec_ && !ChkYesFncPrec())
  {
    SetFncPrecForVaryArgFncsDone(true);

    if (ChkFncPrecForSingleArgFncsDone())
      SetChkFncPrec(false);
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"vafcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfInQuotes(const char* str, int len)
{
  int i;
  int x;
  int p;
  int v;
  int max = 0;
  int tlen;
  int slen = ::SafeStrLen(str);
  int savedindex_ = 0;
  int abschkv_ = 0;
  int savedat_ = 0;
  int toklen;
  int saved_ = slen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int cbrkpt_ = 0;
  int obrkpt_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  char* ncstr_ = (char*)str;
  const char* prevline_ = NULL;

  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    if (_endpt && _endpt > str)
    {
      x = 0;
      obrkfound_ = NextOperator(str, QUOTE_CHAR, x, tlen, false);

      if (obrkfound_)
        obrkpt_ = x;
    }

    if (obrkfound_ && obrkpt_ >= 0)
    {
      x = obrkpt_+1;
      cbrkfound_ = NextOperator(str, QUOTE_CHAR, x, tlen, false);
      cbrkfound_ = cbrkfound_ && obrkpt_ < x;

      if (cbrkfound_)
      {
        cbrkpt_ = x;

        x = 0;
        obrkfound_ = NextOperator(str, QUOTE_CHAR, x, tlen, true);

        if (obrkfound_)
          obrkpt_ = x;
        else
          obrkpt_ = 0;
      }
    }

    if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_)
    {
      x = obrkpt_;
      _openbrkpt = &str[x];

      toklen = cbrkpt_ - obrkpt_ + 1;
      SavedLastPos_ = SaveLastSpecialIndexPos();
      SpecialCase_ = ChkIfSpecialCase(&ncstr_, x, toklen, QUOTE_CHAR, QUOTE_CHAR);

      brkbal = 1;
      slen = ::SafeStrLen(str);
      max = _endpt ? GetStrLen():slen;

      if (SpecialCase_)
      {
        p = 0;
        SpecialParams_ = OmitSpecialCases(0);

        abschkv_ = AbsPosIndex();
        v = GetChkStrOmit(abschkv_);
        OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        savedat_ = (GetChkStrOmit(abschkv_) != v && abschkv_ < AbsPosIndex()) ? 1:0;
        slen = _openbrkpt - _startpt;

        if (1 <= slen)
        {
          savedat_ = 1;
          for (i = 1 ; i <= slen; i++)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }
      }
      else
      {
        slen = _openbrkpt - _startpt;
        savedat_ = (0 <= slen) ? 1:0;

        for (i = 0 ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      savedindex_ = _AbsChkStrIndex - 1;

      if (savedindex_ < 0)
      {
        savedindex_ = 0;
        savedat_ *= -1;
      }

      for (++x; x < max && brkbal; x++)
      {
        if (str[x] == '\"')
        {
          if (brkbal % 2 == 0)
          {
            brkbal++;
            IncrSpecialCaseIndexes();
          }
          else if (brkbal % 2 == 1)
          {
            brkbal--;
            cbpos = !brkbal ? x:0;

            if (!brkbal)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            else
              IncrSpecialCaseIndexes();
          }
        }
        else
          OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
      }

      if (_Debugging)
        cout <<"str:" <<str <<endl
             <<"iqbrk:" <<ChkStrOmitToTxtStr() <<endl;

      cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

      if (cbrkfound_)
      {
        // treat quoted contents as bracketed expression
        _closebrkpt = &str[x-1];
        SetTokenType(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR);

        if (!LastChkStrIndexSaved())
          SavedLastPos_ = SaveLastSpecialIndexPos();

        toklen = (_closebrkpt - _startpt) + 1;
        cprocessed_ = _AbsChkStrIndex - _LastChkStrIndex;

        if (toklen > cprocessed_)
          toklen -= cprocessed_;
        else
          toklen = 0;

        for (x = 0 ; x < toklen; x++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      if (!_closebrkpt)
      {
        SetErrorCode(ERRCODE_MISSING_CLOSING_QUOTE);
        ConfirmAsInvalid();

        if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_ &&
            savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
        {
          if (savedat_ < 0 && _AbsChkStrIndex == saved_)
            SetChkStrOmit(AbsPosIndex(), 0);

          while (_AbsChkStrIndex > savedindex_)
            SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
        }
      }
    }
    else if (obrkfound_ && !cbrkfound_)
    {
      SetErrorCode(ERRCODE_MISSING_CLOSING_QUOTE);
      ConfirmAsInvalid();
    }

    if (!ConfirmedInvalid() && commacnt == 0)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ?
                           (_closebrkpt + 1):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt && _BracketedExpr)
      {
        ConfirmAsMatched();
        ResetOperandRequired();
        RestoreLastSpecialIndexPos();
        SavedLastPos_ = false;

        // No need to check next level.
        // Assume brace contents valid and treat as constant operand
        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
          {
            _LineRemaining++;
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          }

        if (!HasLineRemaining())
          ConfirmAsValid();
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"iqcv:" <<ChkStrOmitToTxtStr() <<endl;

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfBracedExpr(const char* str, int len)
{
  int i;
  int x;
  int p;
  int v;
  int max = 0;
  int tlen;
  int slen = ::SafeStrLen(str);
  int savedindex_ = 0;
  int abschkv_ = 0;
  int savedat_ = 0;
  int toklen;
  int saved_ = slen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int cbrkpt_ = 0;
  int obrkpt_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  char* ncstr_ = (char*)str;
  const char* prevline_ = NULL;

  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    if (_endpt && _endpt > str)
    {
      x = 0;
      cbrkfound_ = NextOperator(str, RIGHT_BRACE, x, tlen, false);

      if (cbrkfound_)
        cbrkpt_ = x;
    }

    if (cbrkfound_ && cbrkpt_ > 0)
    {
      x = 0;
      obrkfound_ = NextOperator(str, LEFT_BRACE, x, tlen, true);

      if (obrkfound_)
        obrkpt_ = x;
    }

    if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_)
    {
      x = obrkpt_;
      _openbrkpt = &str[x];

      toklen = cbrkpt_ - obrkpt_ + 1;
      SavedLastPos_ = SaveLastSpecialIndexPos();
      SpecialCase_ = ChkIfSpecialCase(&ncstr_, x, toklen, '{', '}');

      brkbal = 1;
      slen = ::SafeStrLen(str);
      max = _endpt ? GetStrLen():slen;

      if (SpecialCase_)
      {
        p = 0;
        SpecialParams_ = OmitSpecialCases(0);

        abschkv_ = AbsPosIndex();
        v = GetChkStrOmit(abschkv_);
        OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        savedat_ = (GetChkStrOmit(abschkv_) != v && abschkv_ < AbsPosIndex()) ? 1:0;
        slen = _openbrkpt - _startpt;

        if (1 <= slen)
        {
          savedat_ = 1;
          for (i = 1 ; i <= slen; i++)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }
      }
      else
      {
        slen = _openbrkpt - _startpt;
        savedat_ = (0 <= slen) ? 1:0;

        for (i = 0 ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      savedindex_ = _AbsChkStrIndex - 1;

      if (savedindex_ < 0)
      {
        savedindex_ = 0;
        savedat_ *= -1;
      }

      for (++x; x < max && brkbal; x++)
      {
        if (str[x] == '{')
        {
          brkbal++;
          IncrSpecialCaseIndexes();
        }
        else if (str[x] == '}')
        {
          brkbal--;
          cbpos = !brkbal ? x:0;

          if (!brkbal)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          else
            IncrSpecialCaseIndexes();
        }
        else
          OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
      }

      if (_Debugging)
        cout <<"str:" <<str <<endl
             <<"{ebrk:" <<ChkStrOmitToTxtStr() <<endl;

      cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

      if (cbrkfound_)
      {
        // treat braced contents as bracketed expression
        _closebrkpt = &str[x-1];
        SetTokenType(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR);

        if (!LastChkStrIndexSaved())
          SavedLastPos_ = SaveLastSpecialIndexPos();

        toklen = (_closebrkpt - _startpt) + 1;
        cprocessed_ = _AbsChkStrIndex - _LastChkStrIndex;

        if (toklen > cprocessed_)
          toklen -= cprocessed_;
        else
          toklen = 0;

        for (x = 0 ; x < toklen; x++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      if (!_closebrkpt)
      {
        SetErrorCode(ERRCODE_MISSING_RIGHT_BRACE);
        ConfirmAsInvalid();

        if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_ &&
            savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
        {
          if (savedat_ < 0 && _AbsChkStrIndex == saved_)
            SetChkStrOmit(AbsPosIndex(), 0);

          while (_AbsChkStrIndex > savedindex_)
            SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
        }
      }
    }
    else if (obrkfound_ && !cbrkfound_)
    {
      SetErrorCode(ERRCODE_MISSING_RIGHT_BRACE);
      ConfirmAsInvalid();
    }

    if (!ConfirmedInvalid() && commacnt == 0)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ?
                           (_closebrkpt + 1):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt && _BracketedExpr)
      {
        ConfirmAsMatched();
        ResetOperandRequired();
        RestoreLastSpecialIndexPos();
        SavedLastPos_ = false;

        // No need to check next level.
        // Assume brace contents valid and treat as constant operand
        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
          {
            _LineRemaining++;
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          }

        if (!HasLineRemaining())
          ConfirmAsValid();
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"{ecv:" <<ChkStrOmitToTxtStr() <<endl;

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfBracketedExpr(const char* str, int len)
{
  int i;
  int x;
  int p;
  int v;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int savedindex_ = 0;
  int savedat_ = 0;
  int abschkv_ = 0;
  int toklen;
  int saved_ = slen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int cbrkpt_ = 0;
  int obrkpt_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  char* ncstr_ = (char*)str;
  const char* prevline_ = NULL;

  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool commaerror_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    if (_endpt && _endpt > str)
    {
      x = 0;
      cbrkfound_ = NextCloseBrk(str, x, false);

      if (cbrkfound_)
        cbrkpt_ = x;
    }

    if (cbrkfound_ && cbrkpt_ > 0)
    {
      x = 0;
      obrkfound_ = NextOpenBrk(str, x, true);

      if (obrkfound_)
        obrkpt_ = x;
    }

    if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_)
    {
      x = obrkpt_;
      _openbrkpt = &str[x];
      _openbrkcnt++;

      toklen = cbrkpt_ - obrkpt_ + 1;
      SavedLastPos_ = SaveLastSpecialIndexPos();
      SpecialCase_ = ChkIfSpecialCase(&ncstr_, x, toklen, str[obrkpt_], str[cbrkpt_]);

      brkbal = 1;
      slen = ::SafeStrLen(str);
      max = _endpt ? GetStrLen():slen;

      if (SpecialCase_)
      {
        p = 0;
        SpecialParams_ = OmitSpecialCases(0);

        abschkv_ = AbsPosIndex();
        v = GetChkStrOmit(abschkv_);
        OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
        savedat_ = (GetChkStrOmit(abschkv_) != v && abschkv_ < AbsPosIndex()) ? 1:0;
        slen = _openbrkpt - _startpt;

        if (1 <= slen)
        {
          savedat_ = 1;
          for (i = 1 ; i <= slen; i++)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }
      }
      else
      {
        slen = _openbrkpt - _startpt;
        savedat_ = (0 <= slen) ? 1:0;

        for (i = 0 ; i <= slen; i++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      savedindex_ = _AbsChkStrIndex - 1;
      _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

      if (savedindex_ < 0)
      {
        savedindex_ = 0;
        savedat_ *= -1;
      }

      for (++x; x < max && brkbal; x++)
      {
        if (str[x] == '(' || str[x] == '[')
        {
          brkbal++;
          _openbrkcnt++;
          IncrSpecialCaseIndexes();
        }
        else if (str[x] == ')' || str[x] == ']')
        {
          brkbal--;
          _closebrkcnt++;
          cbpos = !brkbal ? x:0;

          if (!brkbal)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          else
            IncrSpecialCaseIndexes();
        }
        else if (str[x] == ',' && brkbal == 1)
        {
          commacnt++;
          commaerror_ = true;
          break;
        }
        else
          OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
      }

      if (_Debugging)
        cout <<"str:" <<str <<endl
             <<"[ebrk:" <<ChkStrOmitToTxtStr() <<endl;

      cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

      if (cbrkfound_ && ChkNextToken(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR, -1))
      {
        _closebrkpt = &str[x-1];
        if (!commaerror_)
          SetTokenType(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR);

        if (!LastChkStrIndexSaved())
          SavedLastPos_ = SaveLastSpecialIndexPos();

        toklen = (_closebrkpt - _startpt) + 1;
        cprocessed_ = _AbsChkStrIndex - _LastChkStrIndex;

        if (toklen > cprocessed_)
          toklen -= cprocessed_;
        else
          toklen = 0;

        for (x = 0 ; x < toklen; x++)
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
      }

      if (!_closebrkpt || commaerror_)
      {
        if (!_closebrkpt)
          SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
        else
          SetErrorCode(ERRCODE_MISPLACED_COMMA);

        ConfirmAsInvalid();

        if (obrkfound_ && cbrkfound_ && obrkpt_ < cbrkpt_)
        {
          if (argcnt > 0)
            _AbsStrPosIndexes[--argcnt] = 0;

          if (savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
          {
            if (savedat_ < 0 && _AbsChkStrIndex == saved_)
              SetChkStrOmit(AbsPosIndex(), 0);

            while (_AbsChkStrIndex > savedindex_)
              SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
          }
        }
      }
    }
    else if (obrkfound_ && !cbrkfound_)
    {
      SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
      ConfirmAsInvalid();
    }

    if (!ConfirmedInvalid() && commacnt == 0)
    {
      prevline_ = _LineRemaining;
      _LineRemaining = (cbrkfound_ && _closebrkpt) ?
                           (_closebrkpt + 1):_startpt;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt && _BracketedExpr)
      {
        if (_closebrkpt - _openbrkpt > 1)
        {
          ConfirmAsMatched();
          ResetOperandRequired();
          SpecialCase_ = SaveSpecialCaseIndexes();
          SetNext(MakeNextLevel(_Parent, this, NULL, _AbsStrPosIndexes));

          if (_Next && SpecialCase_ &&
              _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
          {
            RestoreSpecialCaseIndexes();
            RestoreLastSpecialIndexPos();
            SavedLastPos_ = false;

            if (_LineRemaining)
              while (*_LineRemaining && isspace(*_LineRemaining))
              {
                _LineRemaining++;
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              }

            if (!HasLineRemaining())
              ConfirmAsValid();
          }
        }
        else
        {
          ConfirmAsMatched();
          ResetOperandRequired();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          // No need to check next level.
          // Assume brace contents valid and treat as constant operand
          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
    }
  }

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"[ecv:" <<ChkStrOmitToTxtStr() <<endl;

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfOperand(const char* str, int len)
{
  int i;
  int v,x;
  int y = 0;
  int p;
  int max = 0;
  int fnx = -1;
  int tlen;
  int slen = ::SafeStrLen(str);
  int toklen;
  int spos = 0;
  int saved_ = slen;
  int savedindex_ = 0;
  int savedat_ = 0;
  int abschkv_ = 0;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int obrkpt_ = 0;
  int ConstSel_ = -1;
  int TokType_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  const char* tokenpt_ = NULL;
  char* teststr_ = NULL;
  char* extrstr_ = NULL;
  char* newstr_ = NULL;

  bool ret = false;
  bool isconst_ = false;
  bool nextop_ = false;
  bool testpostfix_ = true;
  bool NumberExtracted_ = false;
  bool PostFixFound_ = false;
  bool ConstValOk_ = false;
  int AndIndex_ = 0;
  int tokenlen_ = 0;
  int suboptype_ = 0;
  int optype_ = 0;
  int exprspec_ = 0;
  int brkspec_ = 0;
  int fnamelen_ = 0;
  int testlen_ = 0;

  bool nofncprec_ = ChkNoFncPrec();
  bool yesfncprec_ = ChkYesFncPrec();
  bool binopfnctype_ = false;
  bool AndFound_ = false;
  bool Adjust_ = false;
  bool excendfound_ = false;
  bool exclfound_ = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool tokenfound_ = false;
  bool ValidCond_ = false;
  bool ChkNextOk_ = false;
  bool VarArgName_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool revert_ = false;
  bool testnofncops_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;
  bool atstart_ = _LineToProcess == _LineRemaining && _LineToProcess == _OriginalLine;

  // CONSTANT_TOKEN       = 1,   // constant operand (PI, e)
  // VALUE_TOKEN          = 2,   // value operand (1,2,3...)
  // VARIABLE_TOKEN       = 4,   // variable operand ($A...$Z,ans,fracans,ansstr)
  // FUNCTION_TOKEN       = 8,   // function name (MIN,MAX,CUBE...)
  // OPERATOR_TOKEN       = 16,  // operator (+,-,*,/)
  // GROUP_TOKEN          = 32   // grouping bracket (), [], {}
  //
  // BINARY_OPERATOR      = 64,    // binary operator (+,-,*,/,@,^,<,>)
  // BINARY_FUNCTION      = 128,   // binary function (COMBREP,PERMREP,COMB,PERM,XOR,AND,<=,>=,==,!=,OR,E)
  // UNARY_OPERATOR       = 256,   // unary operator (+,-)
  // UNARY_FUNCTION       = 512,   // unary function (SIN,COS,TAN,SQRT,FACT...)
  // POSTFIX_OPERATOR     = 1024,  // postfix operator : %
  // LEFT_BRACKETS        = 2048,  // left brackets : (, [, {
  // RIGHT_BRACKETS       = 4096,  // right brackets : ), ], }
  // WHITESPACE_CHARS     = 8192   // white space characters : " \t\r\n"
  //
  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _ConstsAndVars[x]; x++)
    {
      slen = strlen(_ConstsAndVars[x]);
      if (slen == 1 && toupper(_ConstsAndVars[x][0]) == 'X')
      {
        if (!_VarxAllowed)
          continue;
        else
          testnofncops_ = true;
      }

      saved_ = slen;
      exclfound_ = CalculatorBase::icasestrcompn(_ConstsAndVars[x], "EXCLUDE", 7);

      if (exclfound_ && CheckForMatch(str, _ConstsAndVars[x], 7))
      {
        if (str[7])
          for (y = 7; isspace(str[y]); y++);

        excendfound_ = CalculatorBase::icasestrcompn(&str[y], "ENDS", 4);

        if (excendfound_)
        {
          toklen = slen = saved_ = y + 4;
          excendfound_ = strlen(_ConstsAndVars[x]) == slen;
        }
      }

      if (excendfound_ || CheckForMatch(str, _ConstsAndVars[x], slen))
      {
        ConstSel_ = x;

        if (ConstSel_ >= CONSTVALUE_START)
        {
          if (ChkIfValidNumber(str, testlen_, &teststr_))
          {
            extrstr_ = ExtractNumStr(str, slen);
            if (testlen_ != slen || strcmp(extrstr_, teststr_) != 0)
              SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);

            _MemDel->DelayedDeleteCstr(extrstr_, STOREMEM);
          }
          else
            SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);

          _MemDel->DelayedDeleteCstr(teststr_, STOREMEM);
          toklen = saved_ = slen;

          if (GiveErrorCode() == 0)
          {
            revert_ = false;
            newstr_ = RemoveAndOpStr(str, AndIndex_, AndFound_);

            if (newstr_ && AndFound_)
            {
              if (ChkIfValidNumber(newstr_, testlen_, &teststr_))
              {
                extrstr_ = ExtractNumStr(newstr_, slen);
                if (testlen_ != slen || strcmp(extrstr_, teststr_) != 0)
                  revert_ = true;

                _MemDel->DelayedDeleteCstr(extrstr_, STOREMEM);
              }
              else
                revert_ = true;

              _MemDel->DelayedDeleteCstr(teststr_, STOREMEM);
              _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);

              if (revert_)
                slen = toklen = saved_;
              else
                toklen = saved_ = slen;
            }
          }
        }
        else
          toklen = slen;

        if (GiveErrorCode() == 0)
        {
          SaveSnapshot();
          SavedLastPos_ = SaveLastSpecialIndexPos();
          SpecialCase_ = ChkIfSpecialCase(_ConstsAndVars, x, toklen);

          if (excendfound_ || (ConstSel_ >= 0 && ConstSel_ < CONSTVALUE_START))
            for (i = 0 ; i < toklen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

          if (SpecialCase_)
          {
            p = 0;
            SpecialParams_ = OmitSpecialCases(0);
          }
        }

CHK_OPS:
        if (!_NextOperandRequired && !_OperandRequired)
        {
          slen = spos = saved_;
          nextop_ = !testnofncops_ &&
                    ChkNextToken(OPERATOR_TOKEN, BINARY_OPERATOR, BINARYEXPR, ConstSel_, BINARY_OPERATOR) &&
                    NextOperator(str, BINARY_OPERATOR, spos, slen, false, &fnx);

          if (nextop_ && fnx >= 0 && nofncprec_)
            SetChkFncPrec(false, true);
        }

        if (!nextop_)
        {
          if (!_NextOperandRequired && !_OperandRequired)
          {
            slen = spos = saved_;
            nextop_ = !testnofncops_ &&
                      ChkNextToken(FUNCTION_TOKEN, BINARY_FUNCTION, BINARYEXPR, ConstSel_, BINARY_FUNCTION) &&
                      NextOperator(str, BINARY_FUNCTION, spos, slen, false, &fnx);

            if (nextop_ && fnx >= 0 && nofncprec_)
              SetChkFncPrec(false, true);
          }

          if (!nextop_)
          {
            if (testpostfix_)
            {
              slen = spos = saved_;
              nextop_ = ChkNextToken(OPERATOR_TOKEN, POSTFIX_OPERATOR, CONSTVAL) &&
                        NextOperator(str, POSTFIX_OPERATOR, spos, slen, false);
            }

            if (!nextop_)
            {
              if (_endpt && _endpt > str)
              {
                slen = spos = saved_;
                brkspec_ = LEFT_BRACKETS;
                obrkfound_ = nextop_ = NextOpenBrk(str, spos, true);

                if (obrkfound_)
                {
                  obrkpt_ = spos;
                  abschkv_ = AbsPosIndex();
                  v = GetChkStrOmit(abschkv_);

                  SetAbsPosIndex(obrkpt_, true, 1);
                  SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
                  savedat_ = (GetChkStrOmit(abschkv_) != v && abschkv_ < AbsPosIndex()) ? 1:0;

                  savedindex_ = _AbsChkStrIndex - 1;
                  _AbsStrPosIndexes[argcnt++] = AbsPosIndex();

                  if (savedindex_ < 0)
                  {
                    savedindex_ = 0;
                    savedat_ *= -1;
                  }
                }
              }

              TokType_ =
                  (ConstSel_ >= CONSTVALUE_START) ? VALUE_TOKEN:
                  (ConstSel_ < DEFCONSTS_START ||
                   ConstSel_ >= VARNAME_START) ? VARIABLE_TOKEN:
                                                 CONSTANT_TOKEN;

              suboptype_ = OPERAND;
              exprspec_ = (TokType_ == VARIABLE_TOKEN) ? OPERANDVAL:CONSTVAL;

              if (ChkNextToken(TokType_, suboptype_, exprspec_) ||
                  (PostFixFound_ && ConstValOk_))
              {
                if (obrkfound_)
                {
                  brkbal++;
                  _openbrkcnt++;

                  x = obrkpt_;
                  _openbrkpt = &str[x];
                  slen = saved_;
                }
                else
                {
                  slen = saved_;
                  optype_ = 0;
                  isconst_ = true;
                  PostFixFound_ = PostFixFound_ && ConstValOk_;

                  if (PostFixFound_)
                  {
                    suboptype_ = POSTFIX_OPERATOR;
                    tlen = (tokenpt_ - &str[slen]) + tokenlen_;
                    slen += tlen;

                    for (i = 0 ; i < tlen; i++)
                      SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
                  }
                }

                SetTokenType(TokType_, suboptype_, exprspec_);
                if (isconst_ && !optype_)
                  ResetOperandRequired();

                ChkNextOk_ = true;
              }
              else
              {
                TokType_ = 0;
                suboptype_ = 0;
                exprspec_ = 0;
              }
            }
            else
            {
              x = spos;
              tokenpt_ = &str[x];
              tokenlen_ = slen;
              tokenfound_ = true;
              testpostfix_ = false;

              TokType_ = VALUE_TOKEN;
              suboptype_ = OPERAND;
              exprspec_ = CONSTVAL;
              PostFixFound_ = true;
              ConstValOk_ = ChkNextToken(TokType_, suboptype_, exprspec_);

              optype_= OPERATOR_TOKEN;
              suboptype_ = POSTFIX_OPERATOR;
              exprspec_ = CONSTVAL;
              SetTokenType(optype_, suboptype_, exprspec_);

              ResetOperandRequired();
              goto CHK_OPS;
            }
          }
          else
          {
            x = spos;
            tokenpt_ = &str[x];
            tokenlen_ = slen;
            tokenfound_ = true;

            slen = spos = saved_;
            obrkfound_ = NextOpenBrk(str, spos, true);
            ChkNextOk_ = true;

            optype_= FUNCTION_TOKEN;
            suboptype_ = (ConstSel_ < BINARYOPS_START)  ? BINARY_FUNCTION:
                         (ConstSel_ >= BINARYOPS_START) ? BINARY_OPERATOR:0;
            exprspec_ = BINARYEXPR;

            slen = saved_;
            tlen = (tokenpt_ - &str[slen]) + tokenlen_;
            slen += tlen;

            if (!_Caller && !varxfnc_)
            {
              varxfnc_ = ChkIfVarxFncs(str);
              if (varxfnc_)
                varxfncset_ = true;
            }

            for (i = 0 ; i < tlen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

            if (obrkfound_)
            {
              SetTokenType(optype_, suboptype_, exprspec_, true);
              obrkpt_ = spos;
            }
            else
              SetTokenType(optype_, suboptype_, exprspec_, false, true);
          }
        }
        else
        {
          x = spos;
          tokenpt_ = &str[x];
          tokenlen_ = slen;
          tokenfound_ = true;

          optype_= OPERATOR_TOKEN;
          suboptype_ = (ConstSel_ < BINARYOPS_START)  ? BINARY_FUNCTION:
                       (ConstSel_ >= BINARYOPS_START) ? BINARY_OPERATOR:0;
          exprspec_ = BINARYEXPR;

          slen = saved_;
          tlen = (tokenpt_ - &str[slen]) + tokenlen_;
          slen += tlen;

          if (!_Caller && !varxfnc_)
          {
            varxfnc_ = ChkIfVarxFncs(str);
            if (varxfnc_)
              varxfncset_ = true;
          }

          for (i = 0 ; i < tlen; i++)
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

          SetTokenType(optype_, suboptype_, exprspec_, true);
          ChkNextOk_ = true;
        }

        if (brkspec_ == LEFT_BRACKETS && obrkfound_)
        {
          slen = ::SafeStrLen(str);
          max = _endpt ? GetStrLen():slen;

          for (++x; x < max && brkbal; x++)
          {
            if (str[x] == '(' || str[x] == '[')
            {
              brkbal++;
              _openbrkcnt++;
              IncrSpecialCaseIndexes();
            }
            else if (str[x] == ')' || str[x] == ']')
            {
              brkbal--;
              _closebrkcnt++;
              cbpos = !brkbal ? x:0;

              if (!brkbal)
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              else
                IncrSpecialCaseIndexes();
            }
            else if (str[x] == ',' && brkbal == 1)
            {
              if (commacnt >= _commaindexsize)
                ResizeCommaIndexes();

              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
              _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
              _commaindexes[commacnt++] = x;
            }
            else
              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
          }

          if (_Debugging)
            cout <<"str:" <<str <<endl
                 <<"opbrk:" <<ChkStrOmitToTxtStr() <<endl;

          cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

          if (cbrkfound_ && ChkNextToken(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR, -1))
          {
            tokenpt_ =
            _closebrkpt = &str[x-1];
            tokenlen_ = -1;

            optype_= GROUP_TOKEN;
            suboptype_ = BRACKETEDEXPR;
            exprspec_ = BRACKETEDEXPR;
            brkspec_ = LEFT_BRACKETS;

            SetTokenType(optype_, suboptype_, exprspec_);
            ResetOperandRequired();
            ChkNextOk_ = true;
          }

          if (!_closebrkpt && suboptype_ == BINARY_FUNCTION)
          {
            VarArgName_ = HasVarArgFncName(str, 9, len);

            if (!VarArgName_)
            {
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
              ConfirmAsInvalid();
            }
            else
            {
              RestoreSnapshot();
              Reset(false);
            }

            if (obrkfound_ && _endpt)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == saved_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > savedindex_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }
            }
          }
        }
        else if (!optype_ && isconst_)
          ConfirmAsValid();
        else if (suboptype_ == BINARY_FUNCTION && !obrkfound_)
        {
          SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
          ConfirmAsInvalid();
        }

        break;
      }
    }

    binopfnctype_ = (suboptype_ == BINARY_OPERATOR && nextop_) ||
                    (suboptype_ == BINARY_FUNCTION && nextop_);

    if (((brkspec_ == LEFT_BRACKETS &&
          nextop_ && _openbrkpt && _closebrkpt) || binopfnctype_) &&
        !VarArgName_ && !ConfirmedInvalid() && !brkbal && !isconst_)
    {
      ValidCond_ = atstart_ || ChkNextOk_;
      prevline_ = _LineRemaining;
      _LineRemaining = (tokenfound_ && tokenpt_)   ?
                          ((tokenlen_ > 0) ?
                              (tokenpt_ + tokenlen_):
                              (tokenpt_ + 1)):
                       (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      Adjust_ = true;
      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, Adjust_, true, FNCVALID_DEBUG_STRM);

      if (cbrkfound_ && _closebrkpt && ValidCond_)
      {
        if (binopfnctype_)
        {
          if (fnx >= 0 && !yesfncprec_ && !ChkYesFncPrec())
            ChkIfChkFncPrecFncs(_BinaryOpList[fnx]);
        }

        ConfirmAsMatched();
        SpecialCase_ = SaveSpecialCaseIndexes();
        _VarxAllowed = varxfnc_;
        SetNext(MakeNextLevel(_Parent, this, NULL, _AbsStrPosIndexes));

        if (_Next && SpecialCase_ &&
            _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
        {
          RestoreSpecialCaseIndexes();
          RestoreLastSpecialIndexPos();
          SavedLastPos_ = false;

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
            ConfirmAsValid();
        }
      }
      else if (tokenfound_ && tokenpt_)
      {
        if (binopfnctype_)
        {
          _OperandNeeded = true;
          _NextOperandRequired = true;

          if (fnx >= 0 && !yesfncprec_ && !ChkYesFncPrec())
            ChkIfChkFncPrecFncs(_BinaryOpList[fnx]);

          _VarxAllowed = varxfnc_;
          ConfirmAsMatched();

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
          {
            if (_LineRemaining[0] == MATHSTATEMENT_TERMCHAR)
              ConfirmAsValid();
            else
            {
              SetErrorCode(ERRCODE_REQUIRED_OPERAND_MISSING);
              ConfirmAsInvalid();
            }
          }
        }
      }
    }
    else if (isconst_ && ConstSel_ >= 0 && _IsOperand && !VarArgName_)
    {
      if (!PostFixFound_)
      {
        if (_TokenType == VALUE_TOKEN)
        {
          NumberExtracted_ = false;
          revert_ = false;

          if (ChkIfValidNumber(str, testlen_, &teststr_))
          {
            extrstr_ = ExtractNumStr(str, slen);
            if (testlen_ != slen || strcmp(extrstr_, teststr_) != 0)
              SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);

            NumberExtracted_ = true;
          }
          else
          {
            extrstr_ = NULL;
            SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);
          }

          _MemDel->DelayedDeleteCstr(teststr_, STOREMEM);
          saved_ = slen;

          if (GiveErrorCode() == 0)
          {
            revert_ = false;
            newstr_ = RemoveAndOpStr(str, AndIndex_, AndFound_);

            if (newstr_ && AndFound_)
            {
              if (ChkIfValidNumber(newstr_, testlen_, &teststr_))
              {
                if (NumberExtracted_)
                {
                  _MemDel->DelayedDeleteCstr(extrstr_, STOREMEM);
                  NumberExtracted_ = false;
                }

                extrstr_ = ExtractNumStr(newstr_, slen);

                if (testlen_ != slen || strcmp(extrstr_, teststr_) != 0)
                  revert_ = true;
                else
                  NumberExtracted_ = true;
              }
              else
              {
                if (NumberExtracted_)
                {
                  _MemDel->DelayedDeleteCstr(extrstr_, STOREMEM);
                  NumberExtracted_ = false;
                }

                extrstr_ = NULL;
                revert_ = true;
              }

              _MemDel->DelayedDeleteCstr(teststr_, STOREMEM);
              _MemDel->DelayedDeleteCstr(newstr_, STOREMEM);

              if (revert_)
                slen = saved_;
              else
                saved_ = slen;
            }

            // extrstr contains number string from expression
            if (!revert_ && extrstr_ && NumberExtracted_)
            {
              if (_NumberStrs)
              {
                AddNumberStr(_Parent, extrstr_);
                FindLargestNum(extrstr_);
              }

              _MemDel->DelayedDeleteCstr(extrstr_, STOREMEM);
            }
          }
        }
        else if (_TokenType == VARIABLE_TOKEN ||
                 _TokenType == CONSTANT_TOKEN)
          slen = strlen(_ConstsAndVars[ConstSel_]);
      }
      else if (suboptype_ == POSTFIX_OPERATOR)
      {
        if (!yesfncprec_ && !ChkYesFncPrec())
          SetChkFncPrec(true);
      }

      prevline_ = _LineRemaining;
      tlen = strlen(str);
      _LineRemaining = StrFits(str, slen) ?
                           (str + slen):(str + tlen);

      Adjust_ = true;
      _VarxAllowed = varxfnc_;
      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, Adjust_, true, FNCVALID_DEBUG_STRM);

      ConfirmAsMatched();
      RestoreLastSpecialIndexPos();
      SavedLastPos_ = false;

      if (_LineRemaining)
        while (*_LineRemaining && isspace(*_LineRemaining))
        {
          _LineRemaining++;
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }

      if (!HasLineRemaining())
        if (_Levels > 0 || _LineRemaining[0] == MATHSTATEMENT_TERMCHAR)
          ConfirmAsValid();
    }
    else if (!ConfirmedInvalid() && !brkbal && !isconst_ && !VarArgName_)
    {
      if (tokenfound_ && tokenpt_)
      {
        if (binopfnctype_)
        {
          _OperandNeeded = true;
          _NextOperandRequired = true;

          if (fnx >= 0 && !yesfncprec_ && !ChkYesFncPrec())
            ChkIfChkFncPrecFncs(_BinaryOpList[fnx]);

          _VarxAllowed = varxfnc_;
          ConfirmAsMatched();

          if (_LineRemaining)
            while (*_LineRemaining && isspace(*_LineRemaining))
            {
              _LineRemaining++;
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            }

          if (!HasLineRemaining())
          {
            if (_LineRemaining[0] == MATHSTATEMENT_TERMCHAR)
              ConfirmAsValid();
            else
            {
              SetErrorCode(ERRCODE_REQUIRED_OPERAND_MISSING);
              ConfirmAsInvalid();
            }
          }
        }
      }
      else if (ConstSel_ == -1 && !excendfound_ &&
               _Levels > 0 && ChkIfFileName(str, len))
      {
        fnamelen_ = ::SafeStrLen(str);
        prevline_ = _LineRemaining;
        tlen = strlen(str);
        _LineRemaining = StrFits(str, fnamelen_) ?
                             (str + fnamelen_):(str + tlen);

        Adjust_ = true;
        _VarxAllowed = varxfnc_;
        cprocessed_ = _LineRemaining - prevline_;
        CompareLastSpecialIndexPos(cprocessed_, Adjust_, true, FNCVALID_DEBUG_STRM);

        ConfirmAsMatched();
        RestoreLastSpecialIndexPos();
        SavedLastPos_ = false;

        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
          {
            _LineRemaining++;
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          }

        if (!HasLineRemaining())
          if (_Levels > 0 || _LineRemaining[0] == MATHSTATEMENT_TERMCHAR)
            ConfirmAsValid();
      }
    }
  }

  if (nofncprec_ && !ChkYesFncPrec())
    SetChkFncPrec(false);

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"opcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfValidNumber(const char* str, int& testlen_, char** teststr_)
{
  if (!str)
    return false;

  int ptrdiff_ = 0;
  int alloc_ = teststr_ !=  NULL;
  bool valid_ = false;
  bool ptfnd_ = strchr(str, '.');
  char* resultstr_ = NULL;

  resultstr_ = ptfnd_ ? ::FindFloatLikePart(str, ptrdiff_, alloc_):
                        ::FindUnsignedLikeNumPart(str, ptrdiff_, alloc_);

  testlen_ = ptrdiff_;
  if (alloc_)
    *teststr_ = resultstr_ ? resultstr_:NULL;

  valid_ = ptrdiff_ != 0;

  if (valid_ && alloc_)
    valid_ = ptfnd_ ? ::IsFloat(resultstr_):
                      ::IsUnsignedNum(resultstr_);

  return valid_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfFracOp(const char* str, int len)
{
  if (!_ChkFrac)
  {
    _Checked++;
    return false;
  }

  int x;
  int tlen;
  int slen = ::SafeStrLen(str);
  int OpSel_ = -1;
  int cprocessed_ = 0;

  const char* prevline_ = NULL;
  bool yesfncprec_ = ChkYesFncPrec();
  bool FracOpFound_ = false;
  bool ValidCond_ = false;
  bool Adjust_ = false;
  int optype_ = 0;
  int suboptype_ = 0;
  bool atstart_ = _LineToProcess == _LineRemaining && _LineToProcess == _OriginalLine;

  // CONSTANT_TOKEN       = 1,   // constant operand (PI, e)
  // VALUE_TOKEN          = 2,   // value operand (1,2,3...)
  // VARIABLE_TOKEN       = 4,   // variable operand ($A...$Z,ans,fracans,ansstr)
  // FUNCTION_TOKEN       = 8,   // function name (MIN,MAX,CUBE...)
  // OPERATOR_TOKEN       = 16,  // operator (+,-,*,/)
  // GROUP_TOKEN          = 32   // grouping bracket (), [], {}
  //
  // BINARY_OPERATOR      = 64,    // binary operator (+,-,*,/,@,^,<,>)
  // BINARY_FUNCTION      = 128,   // binary function (COMBREP,PERMREP,COMB,PERM,XOR,AND,<=,>=,==,!=,OR,E)
  // UNARY_OPERATOR       = 256,   // unary operator (+,-)
  // UNARY_FUNCTION       = 512,   // unary function (SIN,COS,TAN,SQRT,FACT...)
  // POSTFIX_OPERATOR     = 1024,  // postfix operator : %
  // LEFT_BRACKETS        = 2048,  // left brackets : (, [, {
  // RIGHT_BRACKETS       = 4096,  // right brackets : ), ], }
  // WHITESPACE_CHARS     = 8192   // white space characters : " \t\r\n"
  //
  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _FracOpList[x]; x++)
    {
      slen = strlen(_FracOpList[x]);

      if (CheckForMatch(str, _FracOpList[x], slen))
      {
        OpSel_ = x;
        optype_ = 0;
        suboptype_ = UNARY_OPERATOR;
        FracOpFound_ = true;

        break;
      }
    }

    if (FracOpFound_ && !optype_ && suboptype_ == UNARY_OPERATOR)
    {
      _ChkFrac = false;
      slen = strlen(_FracOpList[OpSel_]);
      ValidCond_ = atstart_;

      if (ValidCond_)
      {
        prevline_ = _LineRemaining;
        tlen = strlen(str);
        _LineRemaining = StrFits(str, slen) ?
                             (str + slen):(str + tlen);

        Adjust_ = true;
        cprocessed_ = _LineRemaining - prevline_;
        CompareLastSpecialIndexPos(cprocessed_, Adjust_, true, FNCVALID_DEBUG_STRM);

        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
          {
            _LineRemaining++;
            SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
          }

        // Fraction operator found, delayed valid match confirmation.
        // Confirmed match, but not confirmed valid yet.
        if (*_LineRemaining == 0 || !HasLineRemaining())
        {
          SetFracOpFound(true);
          ConfirmAsMatched();

          if (!yesfncprec_ && !ChkYesFncPrec())
            SetChkFncPrec(true);
        }
      }
    }
    else
      SetErrorCode(ERRCODE_FRACTION_OPERATOR_EXPECTED);
  }

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfUnaryExpr(const char* str, bool& OperandNeeded_, int len)
{
  int x;
  int p;
  int i;
  int fnx = 0;
  int max = 0;
  int tlen;
  int slen = ::SafeStrLen(str);
  int savedindex_ = 0;
  int toklen;
  int spos = 0;
  int saved_ = slen;
  int savedat_ = 0;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int obrkpt_ = 0;
  int OpSel_ = -1;

  bool ret = false;
  bool nextop_ = false;
  int optype_ = 0;
  int suboptype_ = 0;
  int brkspec_ = 0;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool nofncprec_ = ChkNoFncPrec();
  bool yesfncprec_ = ChkYesFncPrec();
  bool ArgSpec_ = false;
  bool SpecSrch_ = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool brkvalid_ = false;
  bool ValidCond_ = false;
  bool ChkNextOk_ = false;
  bool VarArgName_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;
  bool atstart_ = _LineToProcess == _LineRemaining && _LineToProcess == _OriginalLine;

  // CONSTANT_TOKEN       = 1,   // constant operand (PI, e)
  // VALUE_TOKEN          = 2,   // value operand (1,2,3...)
  // VARIABLE_TOKEN       = 4,   // variable operand ($A...$Z,ans,fracans,ansstr)
  // FUNCTION_TOKEN       = 8,   // function name (MIN,MAX,CUBE...)
  // OPERATOR_TOKEN       = 16,  // operator (+,-,*,/)
  // GROUP_TOKEN          = 32   // grouping bracket (), [], {}
  //
  // BINARY_OPERATOR      = 64,    // binary operator (+,-,*,/,@,^,<,>)
  // BINARY_FUNCTION      = 128,   // binary function (COMBREP,PERMREP,COMB,PERM,XOR,AND,<=,>=,==,!=,OR,E)
  // UNARY_OPERATOR       = 256,   // unary operator (+,-)
  // UNARY_FUNCTION       = 512,   // unary function (SIN,COS,TAN,SQRT,FACT...)
  // POSTFIX_OPERATOR     = 1024,  // postfix operator : %
  // LEFT_BRACKETS        = 2048,  // left brackets : (, [, {
  // RIGHT_BRACKETS       = 4096,  // right brackets : ), ], }
  // WHITESPACE_CHARS     = 8192   // white space characters : " \t\r\n"
  //
  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _UnaryOpList[x]; x++)
    {
      toklen = slen = strlen(_UnaryOpList[x]);
      saved_ = slen;

      if (CheckForMatch(str, _UnaryOpList[x], toklen))
      {
        fnx =
        OpSel_ = x;
        if (nofncprec_)
          SetChkFncPrec(false, true);

        optype_ = OPERATOR_TOKEN;
        SpecSrch_ = true;
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_UnaryOpList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(0);
        }

        if (_endpt && _endpt > str)
        {
          slen = spos = saved_;
          brkspec_ = LEFT_BRACKETS;
          nextop_ = obrkfound_ = NextOpenBrk(str, spos, true);

          if (obrkfound_)
            obrkpt_ = spos;
          else
            suboptype_ = UNARY_OPERATOR;
        }
        else
          suboptype_ = UNARY_OPERATOR;

        if (obrkfound_)
        {
          brkbal++;
          _openbrkcnt++;

          x = obrkpt_;
          _openbrkpt = &str[x];
          slen = spos = saved_;

          if (!SpecSrch_)
          {
            for (i = 0 ; i < toklen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            SpecSrch_ = true;
          }

          if (brkspec_ == LEFT_BRACKETS && obrkfound_)
          {
            for (i = toklen ; i <= obrkpt_; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

            savedindex_ = _AbsChkStrIndex - 1;
            savedat_ = (toklen <= obrkpt_) ? 1:0;

            if (savedindex_ < 0)
            {
              savedindex_ = 0;
              savedat_ *= -1;
            }

            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            ArgSpec_ = true;
          }
        }
        else if (ChkNextToken(optype_, suboptype_, UNARYEXPR, OpSel_, suboptype_))
        {
          if (OpSel_ >= UNARYOPS_START)
          {
            slen = spos = saved_;
            optype_ = 0;
            suboptype_ = UNARY_OPERATOR;

            SetTokenType(OPERATOR_TOKEN, UNARY_OPERATOR, UNARYEXPR, true);
            ChkNextOk_ = true;
          }
          else if (OpSel_ >= 0)
          {
            slen = spos = saved_;
            optype_ = 0;
            suboptype_ = UNARY_FUNCTION;

            SetTokenType(FUNCTION_TOKEN, UNARY_FUNCTION, UNARYEXPR, false, true);
            ChkNextOk_ = true;
          }

          if (!SpecSrch_)
          {
            for (i = 0 ; i < toklen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            SpecSrch_ = true;
          }

          if (brkspec_ == LEFT_BRACKETS && suboptype_ == UNARY_FUNCTION && obrkfound_)
          {
            for (i = toklen ; i <= obrkpt_; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

            savedindex_ = _AbsChkStrIndex - 1;
            savedat_ = (toklen <= obrkpt_) ? 1:0;

            if (savedindex_ < 0)
            {
              savedindex_ = 0;
              savedat_ *= -1;
            }

            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            ArgSpec_ = true;
          }
        }

        if (brkspec_ == LEFT_BRACKETS && obrkfound_)
        {
          slen = ::SafeStrLen(str);
          max = _endpt ? GetStrLen():slen;

          for (++x; x < max && brkbal; x++)
          {
            if (str[x] == '(' || str[x] == '[')
            {
              brkbal++;
              _openbrkcnt++;
              IncrSpecialCaseIndexes();
            }
            else if (str[x] == ')' || str[x] == ']')
            {
              brkbal--;
              _closebrkcnt++;
              cbpos = !brkbal ? x:0;

              if (!brkbal)
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              else
                IncrSpecialCaseIndexes();
            }
            else if (str[x] == ',' && brkbal == 1)
            {
              if (commacnt >= _commaindexsize)
                ResizeCommaIndexes();

              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
              _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
              _commaindexes[commacnt++] = x;
            }
            else
              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
          }

          if (_Debugging)
            cout <<"str:" <<str <<endl
                 <<"uexbrk:" <<ChkStrOmitToTxtStr() <<endl;

          cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

          if (cbrkfound_)
          {
            brkvalid_ = (OpSel_ >= UNARYOPS_START) ?
                            ChkNextToken(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR, OpSel_, UNARY_OPERATOR):
                            ChkNextToken(FUNCTION_TOKEN, UNARY_FUNCTION, UNARYEXPR, OpSel_, UNARY_FUNCTION);

            if (brkvalid_)
            {
              _closebrkpt = &str[x-1];
              ChkNextOk_ = true;

              if (OpSel_ >= UNARYOPS_START)
              {
                SetTokenType(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR);
                brkspec_ = LEFT_BRACKETS;
                optype_ = GROUP_TOKEN;
              }
              else if (OpSel_ >= 0)
              {
                SetTokenType(FUNCTION_TOKEN, UNARY_FUNCTION, UNARYEXPR, true);
                suboptype_ = UNARY_FUNCTION;
                optype_ = 0;
              }
            }
            else if ((suboptype_ == UNARY_OPERATOR || OpSel_ >= UNARYOPS_START) && !ChkNextOk_)
            {
              _openbrkpt = _closebrkpt = NULL;
              slen = spos = saved_;
              optype_ = 0;
              suboptype_ = UNARY_OPERATOR;

              SetTokenType(OPERATOR_TOKEN, UNARY_OPERATOR, UNARYEXPR, true);
              ChkNextOk_ = true;

              if (ArgSpec_)
              {
                if (argcnt > 0)
                  _AbsStrPosIndexes[--argcnt] = 0;

                if (brkspec_ == LEFT_BRACKETS && obrkfound_ &&
                    savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
                {
                  if (savedat_ < 0 && _AbsChkStrIndex == savedindex_)
                    SetChkStrOmit(AbsPosIndex(), 0);

                  while (_AbsChkStrIndex > savedindex_)
                    SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
                }

                ArgSpec_ = false;
              }
            }
          }

          if (!_closebrkpt && suboptype_ == UNARY_FUNCTION)
          {
            VarArgName_ = HasVarArgFncName(str, 8, len);

            if (!VarArgName_)
            {
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
              ConfirmAsInvalid();
            }
            else
            {
              RestoreSnapshot();
              Reset(false);
            }

            if (ArgSpec_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (brkspec_ == LEFT_BRACKETS && obrkfound_ &&
                  savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == savedindex_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > savedindex_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }

              ArgSpec_ = false;
            }

            if (_Debugging)
              cout <<"str:" <<str <<endl
                   <<"uexdb:" <<ChkStrOmitToTxtStr() <<endl;
          }
        }
        else if (suboptype_ == UNARY_FUNCTION && !obrkfound_)
        {
          SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
          ConfirmAsInvalid();
        }

        break;
      }
    }

    if (!ConfirmedInvalid() &&
        brkspec_ == LEFT_BRACKETS && !VarArgName_ && nextop_ && !brkbal &&
        (optype_ == GROUP_TOKEN || (!optype_ && suboptype_ == UNARY_FUNCTION)))
    {
      ConfirmAsMatched();
      if (!yesfncprec_ && !ChkYesFncPrec())
        ChkIfChkFncPrecFncs(_UnaryOpList[fnx]);
      ValidCond_ = atstart_ || ChkNextOk_;

      if (_openbrkpt && _closebrkpt && !OperandNeeded_ && ValidCond_)
      {
        prevline_ = _LineRemaining;
        _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                         (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

        cprocessed_ = _LineRemaining - prevline_;
        CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

        if (cbrkfound_ && _closebrkpt)
        {
          SpecialCase_ = SaveSpecialCaseIndexes();
          _VarxAllowed = varxfnc_;
          SetNext(MakeNextLevel(_Parent, this, NULL, _AbsStrPosIndexes));

          if (_Next && SpecialCase_ &&
              _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
          {
            RestoreSpecialCaseIndexes();
            RestoreLastSpecialIndexPos();
            SavedLastPos_ = false;

            if (_LineRemaining)
              while (*_LineRemaining && isspace(*_LineRemaining))
              {
                _LineRemaining++;
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              }

            if (!HasLineRemaining())
              ConfirmAsValid();
          }
        }
      }
    }
    else if (!optype_ && _IsUnaryExpr && OpSel_ >= 0 && !VarArgName_ &&
             ((_TokenType == FUNCTION_TOKEN && suboptype_ == UNARY_FUNCTION) ||
              (_TokenType == OPERATOR_TOKEN && suboptype_ == UNARY_OPERATOR)))
    {
      tlen = strlen(str);
      slen = strlen(_UnaryOpList[OpSel_]);
      prevline_ = _LineRemaining;
      _LineRemaining = StrFits(str, slen) ? (str + slen):(str + tlen);
      _VarxAllowed = varxfnc_;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      ConfirmAsMatched();
      if (!yesfncprec_ && !ChkYesFncPrec())
        ChkIfChkFncPrecFncs(_UnaryOpList[fnx]);
      RestoreLastSpecialIndexPos();
      SavedLastPos_ = false;

      if (_LineRemaining)
        while (*_LineRemaining && isspace(*_LineRemaining))
        {
          _LineRemaining++;
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }

      if (!HasLineRemaining() && _OperandRequired)
      {
        SetErrorCode(ERRCODE_REQUIRED_OPERAND_MISSING);
        ConfirmAsInvalid();
      }
    }
  }

  if (nofncprec_ && !ChkYesFncPrec())
    SetChkFncPrec(false);

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"uexcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfBinaryExpr(const char* str, bool& OperandNeeded_, int len)
{
  int x;
  int p;
  int i;
  int fnx = 0;
  int max = 0;
  int tlen;
  int slen = ::SafeStrLen(str);
  int savedindex_ = 0;
  int savedat_ = 0;
  int toklen;
  int spos = 0;
  int saved_ = slen;
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;
  int argcnt = 0;
  int obrkpt_ = 0;
  int OpSel_ = -1;
  int cprocessed_ = 0;
  int* SpecialParams_ = NULL;
  const char* prevline_ = NULL;

  bool nextop_ = false;
  int optype_ = 0;
  int suboptype_ = 0;
  int brkspec_ = 0;

  bool nofncprec_ = ChkNoFncPrec();
  bool yesfncprec_ = ChkYesFncPrec();
  bool ret = false;
  bool ArgSpec_ = false;
  bool SpecSrch_ = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool brkvalid_ = false;
  bool ValidCond_ = false;
  bool ChkNextOk_ = false;
  bool VarArgName_ = false;
  bool SpecialCase_ = false;
  bool SavedLastPos_ = false;
  bool prevvarx_ = _VarxAllowed;
  bool varxfncset_ = false;
  bool varxfnc_ = _VarxAllowed;
  bool atstart_ = _LineToProcess == _LineRemaining && _LineToProcess == _OriginalLine;

  // CONSTANT_TOKEN       = 1,   // constant operand (PI, e)
  // VALUE_TOKEN          = 2,   // value operand (1,2,3...)
  // VARIABLE_TOKEN       = 4,   // variable operand ($A...$Z,ans,fracans,ansstr)
  // FUNCTION_TOKEN       = 8,   // function name (MIN,MAX,CUBE...)
  // OPERATOR_TOKEN       = 16,  // operator (+,-,*,/)
  // GROUP_TOKEN          = 32   // grouping bracket (), [], {}
  //
  // BINARY_OPERATOR      = 64,    // binary operator (+,-,*,/,@,^,<,>)
  // BINARY_FUNCTION      = 128,   // binary function (COMBREP,PERMREP,COMB,PERM,XOR,AND,<=,>=,==,!=,OR,E)
  // UNARY_OPERATOR       = 256,   // unary operator (+,-)
  // UNARY_FUNCTION       = 512,   // unary function (SIN,COS,TAN,SQRT,FACT...)
  // POSTFIX_OPERATOR     = 1024,  // postfix operator : %
  // LEFT_BRACKETS        = 2048,  // left brackets : (, [, {
  // RIGHT_BRACKETS       = 4096,  // right brackets : ), ], }
  // WHITESPACE_CHARS     = 8192   // white space characters : " \t\r\n"
  //
  if (str && slen && (!_NextOperandRequired && !_OperandRequired))
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    for (x = 0; _BinaryOpList[x]; x++)
    {
      toklen = slen = strlen(_BinaryOpList[x]);
      saved_ = slen;

      if (CheckForMatch(str, _BinaryOpList[x], toklen))
      {
        fnx =
        OpSel_ = x;
        if (nofncprec_)
          SetChkFncPrec(false, true);

        optype_ = OPERATOR_TOKEN;
        SpecSrch_ = true;
        SaveSnapshot();
        SavedLastPos_ = SaveLastSpecialIndexPos();
        SpecialCase_ = ChkIfSpecialCase(_BinaryOpList, x, toklen);

        if (!_Caller && !varxfnc_)
        {
          varxfnc_ = ChkIfVarxFncs(str);
          if (varxfnc_)
            varxfncset_ = true;
        }

        if (SpecialCase_)
        {
          p = 0;
          SpecialParams_ = OmitSpecialCases(0);
        }

        if (_endpt && _endpt > str)
        {
          slen = spos = saved_;
          brkspec_ = LEFT_BRACKETS;
          nextop_ = obrkfound_ = NextOpenBrk(str, spos, true);

          if (obrkfound_)
            obrkpt_ = spos;
          else
            suboptype_ = BINARY_OPERATOR;
        }
        else
          suboptype_ = BINARY_OPERATOR;

        if (obrkfound_)
        {
          brkbal++;
          _openbrkcnt++;

          x = obrkpt_;
          _openbrkpt = &str[x];
          slen = spos = saved_;

          if (!SpecSrch_)
          {
            for (i = 0 ; i < toklen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            SpecSrch_ = true;
          }

          if (brkspec_ == LEFT_BRACKETS && obrkfound_)
          {
            for (i = toklen ; i <= obrkpt_; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

            savedindex_ = _AbsChkStrIndex - 1;
            savedat_ = (toklen <= obrkpt_) ? 1:0;

            if (savedindex_ < 0)
            {
              savedindex_ = 0;
              savedat_ *= -1;
            }

            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            ArgSpec_ = true;
          }
        }
        else if (ChkNextToken(optype_, suboptype_, BINARYEXPR, OpSel_, suboptype_))
        {
          if (OpSel_ >= BINARYOPS_START)
          {
            slen = spos = saved_;
            optype_ = 0;
            suboptype_ = BINARY_OPERATOR;

            SetTokenType(OPERATOR_TOKEN, BINARY_OPERATOR, BINARYEXPR, true);
            ChkNextOk_ = true;
          }
          else if (OpSel_ >= 0)
          {
            slen = spos = saved_;
            optype_ = 0;
            suboptype_ = BINARY_FUNCTION;

            SetTokenType(FUNCTION_TOKEN, BINARY_FUNCTION, BINARYEXPR, false, true);
            ChkNextOk_ = true;
          }

          if (!SpecSrch_)
          {
            for (i = 0 ; i < toklen; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
            SpecSrch_ = true;
          }

          if (brkspec_ == LEFT_BRACKETS && suboptype_ == BINARY_FUNCTION && obrkfound_)
          {
            for (i = toklen ; i <= obrkpt_; i++)
              SetChkStrOmit(IncrSpecialCaseIndexes(), 1);

            savedindex_ = _AbsChkStrIndex - 1;
            savedat_ = (toklen <= obrkpt_) ? 1:0;

            if (savedindex_ < 0)
            {
              savedindex_ = 0;
              savedat_ *= -1;
            }

            _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
            ArgSpec_ = true;
          }
        }

        if (brkspec_ == LEFT_BRACKETS && obrkfound_)
        {
          slen = ::SafeStrLen(str);
          max = _endpt ? GetStrLen():slen;

          for (++x; x < max && brkbal; x++)
          {
            if (str[x] == '(' || str[x] == '[')
            {
              brkbal++;
              _openbrkcnt++;
              IncrSpecialCaseIndexes();
            }
            else if (str[x] == ')' || str[x] == ']')
            {
              brkbal--;
              _closebrkcnt++;
              cbpos = !brkbal ? x:0;

              if (!brkbal)
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              else
                IncrSpecialCaseIndexes();
            }
            else if (str[x] == ',' && brkbal == 1)
            {
              if (commacnt >= _commaindexsize)
                ResizeCommaIndexes();

              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
              _AbsStrPosIndexes[argcnt++] = AbsPosIndex();
              _commaindexes[commacnt++] = x;
            }
            else
              OmitSpecialParams(SpecialParams_, brkbal, p, str[x]);
          }

          if (_Debugging)
            cout <<"str:" <<str <<endl
                 <<"bexbrk:" <<ChkStrOmitToTxtStr() <<endl;

          cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

          if (cbrkfound_)
          {
            brkvalid_ = (OpSel_ >= BINARYOPS_START) ?
                            ChkNextToken(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR, OpSel_, BINARY_OPERATOR):
                            ChkNextToken(FUNCTION_TOKEN, BINARY_FUNCTION, BINARYEXPR, OpSel_, BINARY_FUNCTION);

            if (brkvalid_)
            {
              _closebrkpt = &str[x-1];
              ChkNextOk_ = true;

              if (OpSel_ >= BINARYOPS_START)
              {
                SetTokenType(GROUP_TOKEN, BRACKETEDEXPR, BRACKETEDEXPR);
                brkspec_ = LEFT_BRACKETS;
                optype_ = GROUP_TOKEN;
              }
              else
              {
                SetTokenType(FUNCTION_TOKEN, BINARY_FUNCTION, BINARYEXPR, true);
                optype_ = 0;
                suboptype_ = BINARY_FUNCTION;
              }
            }
            else if ((suboptype_ == BINARY_OPERATOR || OpSel_ >= BINARYOPS_START) && !ChkNextOk_)
            {
              _openbrkpt = _closebrkpt = NULL;
              slen = spos = saved_;
              optype_ = 0;
              suboptype_ = BINARY_OPERATOR;

              SetTokenType(OPERATOR_TOKEN, BINARY_OPERATOR, BINARYEXPR, true);
              ChkNextOk_ = true;

              if (ArgSpec_)
              {
                if (argcnt > 0)
                  _AbsStrPosIndexes[--argcnt] = 0;

                if (brkspec_ == LEFT_BRACKETS && obrkfound_ &&
                    savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
                {
                  if (savedat_ < 0 && _AbsChkStrIndex == savedindex_)
                    SetChkStrOmit(AbsPosIndex(), 0);

                  while (_AbsChkStrIndex > savedindex_)
                    SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
                }

                ArgSpec_ = false;
              }
            }
          }

          if (!_closebrkpt && suboptype_ == BINARY_FUNCTION)
          {
            VarArgName_ = HasVarArgFncName(str, 9, len);

            if (!VarArgName_)
            {
              SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
              ConfirmAsInvalid();
            }
            else
            {
              RestoreSnapshot();
              Reset(false);
            }

            if (ArgSpec_)
            {
              if (argcnt > 0)
                _AbsStrPosIndexes[--argcnt] = 0;

              if (brkspec_ == LEFT_BRACKETS && obrkfound_ &&
                  savedindex_ >= 0 && _AbsChkStrIndex >= savedindex_ && savedat_ != 0)
              {
                if (savedat_ < 0 && _AbsChkStrIndex == savedindex_)
                  SetChkStrOmit(AbsPosIndex(), 0);

                while (_AbsChkStrIndex > savedindex_)
                  SetChkStrOmit(DecrSpecialCaseIndexes(), 0);
              }

              ArgSpec_ = false;
            }

            if (_Debugging && ConfirmedValid())
              cout <<"str:" <<str <<endl
                   <<"bexdb:" <<ChkStrOmitToTxtStr() <<endl;
          }
        }
        else if (suboptype_ == BINARY_FUNCTION && !obrkfound_)
        {
          SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
          ConfirmAsInvalid();
        }

        break;
      }
    }

    if (!ConfirmedInvalid() &&
        brkspec_ == LEFT_BRACKETS && !VarArgName_ && nextop_ && !brkbal &&
        (optype_ == GROUP_TOKEN || (!optype_ && suboptype_ == BINARY_FUNCTION)))
    {
      ConfirmAsMatched();
      if (!yesfncprec_ && !ChkYesFncPrec())
        ChkIfChkFncPrecFncs(_BinaryOpList[fnx]);
      ValidCond_ = atstart_ || ChkNextOk_;

      if (_openbrkpt && _closebrkpt && !OperandNeeded_ && ValidCond_)
      {
        prevline_ = _LineRemaining;
        _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                         (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

        cprocessed_ = _LineRemaining - prevline_;
        CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

        if (cbrkfound_ && _closebrkpt)
        {
          SpecialCase_ = SaveSpecialCaseIndexes();
          _VarxAllowed = varxfnc_;
          SetNext(MakeNextLevel(_Parent, this, NULL, _AbsStrPosIndexes));

          if (_Next && SpecialCase_ &&
              _Next->ChkIfMathLineValid(_Next->GetStartPt(), false, _Next->GetStrLen()))
          {
            RestoreSpecialCaseIndexes();
            RestoreLastSpecialIndexPos();
            SavedLastPos_ = false;

            if (_LineRemaining)
              while (*_LineRemaining && isspace(*_LineRemaining))
              {
                _LineRemaining++;
                SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
              }

            if (!HasLineRemaining())
              ConfirmAsValid();
          }
        }
      }
    }
    else if (!optype_ && _IsBinaryExpr && OpSel_ >= 0 && !VarArgName_ &&
             ((_TokenType == FUNCTION_TOKEN && suboptype_ == BINARY_FUNCTION) ||
              (_TokenType == OPERATOR_TOKEN && suboptype_ == BINARY_OPERATOR)))
    {
      tlen = strlen(str);
      slen = strlen(_BinaryOpList[OpSel_]);
      prevline_ = _LineRemaining;
      _LineRemaining = StrFits(str, slen) ? (str + slen):(str + tlen);
      _VarxAllowed = varxfnc_;

      cprocessed_ = _LineRemaining - prevline_;
      CompareLastSpecialIndexPos(cprocessed_, false, true, FNCVALID_DEBUG_STRM);

      ConfirmAsMatched();
      if (!yesfncprec_ && !ChkYesFncPrec())
        ChkIfChkFncPrecFncs(_BinaryOpList[fnx]);
      RestoreLastSpecialIndexPos();
      SavedLastPos_ = false;

      if (_LineRemaining)
        while (*_LineRemaining && isspace(*_LineRemaining))
        {
          _LineRemaining++;
          SetChkStrOmit(IncrSpecialCaseIndexes(), 1);
        }

      if (!HasLineRemaining() && _NextOperandRequired)
      {
        SetErrorCode(ERRCODE_REQUIRED_OPERAND_MISSING);
        ConfirmAsInvalid();
      }
    }
  }

  if (nofncprec_ && !ChkYesFncPrec())
    SetChkFncPrec(false);

  if (SpecialParams_)
    _MemDel->DelayedDeleteVoidp(SpecialParams_, STOREMEM);

  if (SavedLastPos_)
    RestoreLastSpecialIndexPos();

  if (_Debugging && ConfirmedValid())
    cout <<"str:" <<str <<endl
         <<"bexcv:" <<ChkStrOmitToTxtStr() <<endl;

  ret = (ConfirmedValid() || ConfirmedMatched());

  if ((ret || FracOpFound()) && varxfncset_)
    _VarxAllowed = prevvarx_;

  return ret;
}

/****************************************************************************/
char* FunctionValidityChecker::MakeStrSegment(char* NewLine_, int PrevLen_)
{
  int nlen_ = GetStrLen();

  if (nlen_ && _startpt)
  {
    if (nlen_ > PrevLen_)
    {
      _MemDel->DelayedDeleteCstr(NewLine_, STOREMEM);
      NewLine_ = (char*)(_Parent->allocmem(nlen_+1, sizeof(char), NewLine_));
    }

    strncpy(NewLine_, _startpt, nlen_);
    NewLine_[nlen_] = 0;
  }

  return NewLine_;
}

/****************************************************************************/
bool FunctionValidityChecker::HasInvalidTokens() const
{
  return (_ErrorCode != 0);
}

/****************************************************************************/
bool FunctionValidityChecker::HasVarArgFncName(const char* str, int numargs_, int len)
{
  int x, y;
  int slen = ::SafeStrLen(str);

  bool Checked_ = false;
  bool MatchFound_ = false;

  const char* startpt_;
  const char* endpt_;

  if (str && slen)
  {
    startpt_ = str;
    endpt_ = (len < 0 || len > slen) ? (startpt_ + slen):(startpt_ + len);

    for (x = 0; _VaryArgFncList[x] && !MatchFound_; x++)
    {
      slen = strlen(_VaryArgFncList[x]);

      if (CheckForMatch(str, _VaryArgFncList[x], slen) && NextOpenBrk(str, slen, true))
      {
        MatchFound_ = true;
        break;
      }
    }

    if (!MatchFound_ && numargs_)
    {
      for (x = 0; _MultiArgFncList[x] && !MatchFound_; x++)
      {
        slen = strlen(_MultiArgFncList[x]);

        if (CheckForMatch(str, _MultiArgFncList[x], slen) && NextOpenBrk(str, slen, true))
        {
          MatchFound_ = true;
          break;
        }
      }

      if (MatchFound_ && _MultiArgChkList[x][0] == 0)
      {
        if (_MultiArgChkList[x][numargs_])
          _MultiArgChkList[x][numargs_] = 0;

        for (y = 1; y <= MAX_MULTIARG_CHKS && !Checked_; y++)
          if (_MultiArgChkList[x][y])
            Checked_ = true;

        MatchFound_ = Checked_;

        if (!MatchFound_)
          _MultiArgChkList[x][0] = 1;
      }
      else
        MatchFound_ = false;
    }
  }

  return MatchFound_;
}

/****************************************************************************/
bool FunctionValidityChecker::IsUndefinedFncCall(const char* str, int& tlen_)
{
  if (!str)
    return false;

  bool valid_ = true;
  bool brkfound_ = true;

  int slen = strlen(str);
  int x;

  for (x = 0; valid_ && x < slen; x++)
  {
    valid_ = (isalpha(str[x]) || isdigit(str[x]));

    if (!valid_)
    {
      if (str[x] == '(')
      {
        brkfound_ = true;
        valid_ = true;
        tlen_ = x;
      }

      break;
    }
  }

  return (x && brkfound_ && valid_);
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfBalancedBrk(const char* str, int len)
{
  int x;
  int slen = ::SafeStrLen(str);
  int max = _endpt ? GetStrLen():slen;
  int brkbal = 0;
  bool inquote_ = false;

  for (x = 0; x < max; x++)
  {
    if (str[x] == '\"')
      inquote_ = !inquote_;

    if (inquote_)
      continue;

    if (str[x] == '(' || str[x] == '[')
      brkbal++;
    else if (str[x] == ')' || str[x] == ']')
      brkbal--;
  }

  if (brkbal > 0)
    SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);

  if (brkbal < 0)
    SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);

  return (x == max && brkbal == 0);
}

/****************************************************************************/
bool FunctionValidityChecker::FindBackChar(const char* str, int x, char ch,
                                           bool csense_, bool brkonnonspc_)
{
  if (x < 0)
    return false;

  bool fnd = false;
  for (;x >= 0 && !fnd; x--)
  {
    fnd = csense_ ? (str[x] == ch):
                    (toupper(str[x]) == toupper(ch));

    if (!isspace(str[x]) && brkonnonspc_)
      break;
  }

  return fnd;
}

/****************************************************************************/
bool FunctionValidityChecker::FindForwardChar(const char* str, int x, char ch,
                                              bool csense_, bool brkonnonspc_)
{
  if (!str[x])
    return false;

  bool fnd = false;
  for (;str[x] && !fnd; x++)
  {
    fnd = csense_ ? (str[x] == ch):
                    (toupper(str[x]) == toupper(ch));

    if (!isspace(str[x]) && brkonnonspc_)
      break;
  }

  return fnd;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfInvalidChars(const char* str, int len)
{
  if (!str)
    return false;

  bool valid_ = true;
  bool invalid_ = false;
  bool xorfnd_ = false;
  bool commafnd_ = false;
  bool isfnc_ = false;
  bool isbrk_ = false;
  bool isunfnc_ = false;
  bool islbinfnc_ = false;
  bool isrbinfnc_ = false;
  bool isexecfnc_ = false;
  bool isgraphfnc_ = false;

  int tlen_ = 0;
  int slen = (len < 0) ? strlen(str):len;
  int x;

  if (toupper(*str) == 'G' &&
      CalculatorBase::icasestrcompn(str, "GRAPH", 5))
    isgraphfnc_ = true;

  if (toupper(*str) == 'E' &&
      CalculatorBase::icasestrcompn(str, "EXEC", 4))
    isexecfnc_ = true;

  if (slen > 0 && !isgraphfnc_ && !isexecfnc_)
    for (x = 0; valid_ && str[x] && x < slen; x++)
    {
      if ((toupper(str[x]) != 'X' && str[x] != '.' && GetChkStrOmit(x)) ||
          (!isspace(str[x]) && (FindBackChar(str, x-1, '\"', true, false) &&
                                FindForwardChar(str, x+1, '\"', true, false))))
        continue;

      if ((toupper(str[x]) == 'X' && FindForwardChar(str, x+1, '(', true, true)) ||
          (x >= 1 && CalculatorBase::icasestrcompn(&str[x-1], "EXEC", 4)) ||
          (x >= 1 && CalculatorBase::icasestrcompn(&str[x-1], "EXP", 3)) ||
          (x >= 1 && CalculatorBase::icasestrcompn(&str[x-1], "EXCLUDEENDS", 11)) ||
          (x >= 3 && CalculatorBase::icasestrcompn(&str[x-3], "SETXDIF", 7)))
        continue;

      xorfnd_ = false;
      commafnd_ = false;

      if (str[x] == '.')
        invalid_ = str[x-1] == '.' || str[x+1] == '.';
      else if (toupper(str[x]) == 'X')
      {
        xorfnd_ = x+1 < slen && toupper(str[x+1]) == 'O' && toupper(str[x+2]) == 'R';
        commafnd_ = FindBackChar(str, x-1, ',', true, true);
        invalid_ = !commafnd_ && !xorfnd_ && str[x-1] != '0';
      }
      else if (toupper(str[x-1]) == 'X')
        invalid_ = isspace(str[x]) && x == 1;

      if (!invalid_)
      {
        if ((toupper(str[x]) == 'X' && str[x-1] == '$') ||
            CalculatorBase::icasestrcompn(&str[x-1], "EXCLUDEENDS", 11))
          invalid_ = false;
        else if (toupper(str[x]) == 'X' && str[x-1] != '$' && !commafnd_ && !xorfnd_)
          invalid_ = str[x-1] != '0' || !(isdigit(str[x+1]) || ('A' <= toupper(str[x+1]) && toupper(str[x+1]) <= 'F'));
        else if (isalpha(str[x]) && !xorfnd_ && (toupper(str[x]) != 'X' || !commafnd_))
          invalid_ = !CalculatorBase::icasestrcompn(str, "EXCLUDEENDS", 11) &&
                     str[x-1] != '$' && (toupper(str[x]) > 'F' || !FindBackChar(str, x-1, 'X', false, false));
      }
      else if (isalpha(str[x]) && !xorfnd_)
      {
        if ((toupper(str[x]) == 'X' && str[x-1] == '$') ||
            CalculatorBase::icasestrcompn(&str[x-1], "EXCLUDEENDS", 11))
          invalid_ = false;
        else if (toupper(str[x]) == 'X' && str[x-1] != '$')
        {
          isbrk_ = (str[x-1] == '(' && str[x+1] == ')') ||
                   (str[x-1] == '[' && str[x+1] == ']') ||
                   (str[x-1] == ',' && str[x+1] == ',');

          if (isbrk_)
          {
            islbinfnc_ =
            isrbinfnc_ = false;
          }
          else
          {
            isunfnc_ = CalculatorBase::IsUnaryFunctions(str, x-1, tlen_, isfnc_);
            if (isunfnc_)
              isunfnc_ = !isfnc_;

            islbinfnc_ = CalculatorBase::IsBinaryFunctions(str, x-1, tlen_, isfnc_);
            if (islbinfnc_)
              islbinfnc_ = !isfnc_;
            else
              islbinfnc_ = isunfnc_;

            isrbinfnc_ = CalculatorBase::IsBinaryFunctions(str, x+1, tlen_, isfnc_);
            if (isrbinfnc_)
              isrbinfnc_ = !isfnc_;
            else
              isrbinfnc_ = str[x+1] == '%';
          }

          invalid_ = !isbrk_ && !((islbinfnc_ && isrbinfnc_) ||
                                  (islbinfnc_ && (str[x+1] == ',' || str[x+1] == ')' || str[x+1] == ']')) ||
                                  ((str[x+1] == ',' || str[x-1] == '(' || str[x-1] == '[') && isrbinfnc_));
        }
        else if (toupper(str[x]) != 'X' || !commafnd_)
          invalid_ = !CalculatorBase::icasestrcompn(str, "EXCLUDEENDS", 11) &&
                     str[x-1] != '$' && (toupper(str[x]) > 'F' || !FindBackChar(str, x-1, 'X', false, false));
      }

      valid_ = !invalid_;
    }

  if (isgraphfnc_ || isexecfnc_)
    invalid_ = false;

  if (invalid_)
    ResetOperandRequired();

  return invalid_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfInvalidVars(const char* str, int len)
{
  if (!str || str[0] != '$')
    return false;

  bool valid_ = true;
  bool invalid_ = false;

  int slen = (len < 0) ? strlen(str):len;
  int x = 0;

  if (slen > 0)
  {
    _Checked++;

    for (x = 1; valid_ && str[x] && x < slen; x++)
    {
      valid_ = isalpha(str[x]);

      if (!valid_)
      {
        valid_ = x == 2 && isspace(str[x]);
        break;
      }
      else if (x > 1)
      {
        valid_ = false;
        break;
      }
    }
  }

  invalid_ = !(x == 2 && valid_);

  if (invalid_)
  {
    ConfirmAsMatched();
    SetErrorCode(ERRCODE_INVALID_VARIABLES_FOUND);
    ResetOperandRequired();
  }

  return invalid_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfInvalidFncs(const char* str, int len)
{
  int x;
  int max = 0;
  int slen = ::SafeStrLen(str);
  int cbpos = 0;
  int brkbal = 0;
  int commacnt = 0;

  bool undeffnc_ = false;
  bool cbrkfound_ = false;
  bool obrkfound_ = false;
  bool VarArgName_ = false;

  if (str && slen)
  {
    _startpt = str;
    _endpt = (len < 0 || len > slen) ? (_startpt + slen):(_startpt + len);
    _Checked++;

    undeffnc_ = IsUndefinedFncCall(str, slen);

    if (undeffnc_ && NextOpenBrk(str, slen, true))
    {
      x = slen;
      obrkfound_= true;
      _openbrkpt = &str[x];
      _openbrkcnt++;

      brkbal = 1;
      slen = ::SafeStrLen(str);
      max = _endpt ? GetStrLen():slen;

      for (++x; x < max && brkbal; x++)
        if (str[x] == '(')
        {
          brkbal++;
          _openbrkcnt++;
        }
        else if (str[x] == ')')
        {
          brkbal--;
          _closebrkcnt++;
          cbpos = !brkbal ? x:0;
        }
        else if (str[x] == ',' && brkbal == 1)
          commacnt++;

      cbrkfound_ = brkbal == 0 && (x < max || (cbpos && x == max));

      if (cbrkfound_ && ChkNextToken(FUNCTION_TOKEN, SINGLEARGFNC, SINGLEARGFNC))
        _closebrkpt = &str[x-1];

      if (!_closebrkpt)
      {
        VarArgName_ = HasVarArgFncName(str, 0, len);

        if (!VarArgName_)
        {
          SetErrorCode(ERRCODE_MISSING_RIGHT_BRACKET);
          ConfirmAsInvalid();
        }
      }
    }
    else if (undeffnc_)
    {
      SetErrorCode(ERRCODE_MISSING_LEFT_BRACKET);
      ConfirmAsInvalid();
    }

    if (!ConfirmedInvalid() && !VarArgName_)
    {
      _LineRemaining = (cbrkfound_ && _closebrkpt) ? (_closebrkpt + 1):
                       (obrkfound_ && _openbrkpt && StrFits(str, max)) ? (str + max):_startpt;

      if (cbrkfound_ && _closebrkpt)
      {
        if (!ChkYesFncPrec())
          SetChkFncPrec(false);

        ConfirmAsMatched();
        SetErrorCode(ERRCODE_INVALID_FUNCTIONS_FOUND);
        ResetOperandRequired();

        // No need to check next level.
        // Assume brace contents valid and treat as constant operand
        if (_LineRemaining)
          while (*_LineRemaining && isspace(*_LineRemaining))
            _LineRemaining++;

        if (!HasLineRemaining())
          ConfirmAsValid();
      }
    }
  }

  return (ConfirmedValid() || ConfirmedMatched());
}

/****************************************************************************/
bool FunctionValidityChecker::IsNullSet(const char* str)
{
  if (!str)
    return false;

  int x;
  int max = strlen(str);

  for (x = 0; x < max && isspace(str[x]); x++);

  if (str[x] == '{')
  {
    for (++x; x < max && isspace(str[x]); x++);

    if (CalculatorBase::icasestrcompn(&str[x], "null", 4))
    {
      for (x += 4; x < max && isspace(str[x]); x++);

      if (str[x] == '}')
      {
        for (++x; x < max && isspace(str[x]); x++);
        return (x == max);
      }
    }
  }

  return false;
}

/****************************************************************************/
void FunctionValidityChecker::SetDebugging(bool flag_)
{
  _Debugging = flag_;
}

/****************************************************************************/
int FunctionValidityChecker::TranslateErrorCode(int ErrCode_) const
{
  // Mcalc_Error::ERRVAL_INVALID_FUNCTIONS_FOUND    == 25
  // Mcalc_Error::ERRVAL_INVALID_VARIABLES_FOUND    == 26
  // Mcalc_Error::ERRVAL_MISSRIGHT_BRACKET          == 3
  // Mcalc_Error::ERRVAL_MISSLEFT_BRACKET           == 2
  // Mcalc_Error::ERRVAL_INVALID_EXPR_FOUND         == 1
  // Mcalc_Error::ERRVAL_FRACTION_OPERATOR_EXPECTED == 27
  // Mcalc_Error::ERRVAL_MISSING_RIGHT_BRACE        == 28
  // Mcalc_Error::ERRVAL_MISSING_CLOSING_QUOTE      == 29
  // Mcalc_Error::ERRVAL_REQUIRED_OPERAND_MISSING   == 30
  // Mcalc_Error::ERRVAL_MISPLACED_COMMA            == 38

  int x;
  int i = 1;
  int max = MAX_ERROR_CODES;

  int retcode_ =
  (
    (ErrCode_ == ERRCODE_INVALID_FUNCTIONS_FOUND)     ? Mcalc_Error::ERRVAL_INVALID_FUNCTIONS_FOUND:
    (ErrCode_ == ERRCODE_INVALID_VARIABLES_FOUND)     ? Mcalc_Error::ERRVAL_INVALID_VARIABLES_FOUND:
    (ErrCode_ == ERRCODE_MISSING_RIGHT_BRACKET)       ? Mcalc_Error::ERRVAL_MISSRIGHT_BRACKET:
    (ErrCode_ == ERRCODE_MISSING_LEFT_BRACKET)        ? Mcalc_Error::ERRVAL_MISSLEFT_BRACKET:
    (ErrCode_ == ERRCODE_INVALID_EXPR_FOUND)          ? Mcalc_Error::ERRVAL_INVALID_EXPR:
    (ErrCode_ == ERRCODE_FRACTION_OPERATOR_EXPECTED)  ? Mcalc_Error::ERRVAL_FRACTION_OPERATOR_EXPECTED:
    (ErrCode_ == ERRCODE_MISSING_RIGHT_BRACE)         ? Mcalc_Error::ERRVAL_MISSING_RIGHT_BRACE:
    (ErrCode_ == ERRCODE_MISSING_CLOSING_QUOTE)       ? Mcalc_Error::ERRVAL_MISSING_CLOSING_QUOTE:
    (ErrCode_ == ERRCODE_REQUIRED_OPERAND_MISSING)    ? Mcalc_Error::ERRVAL_REQUIRED_OPERAND_MISSING:
    (ErrCode_ == ERRCODE_MISPLACED_COMMA)             ? Mcalc_Error::ERRVAL_MISPLACED_COMMA:0
  );

  if (!retcode_)
  {
    for (x = 0; x < max; x++)
      if (i & _ErrorCode)
        break;
      else
        i *= 2;

    if (x < max)
      ErrCode_ = retcode_ = i;
  }

  if (retcode_)
    retcode_ =
    (
      (ErrCode_ == ERRCODE_INVALID_FUNCTIONS_FOUND)     ? Mcalc_Error::ERRVAL_INVALID_FUNCTIONS_FOUND:
      (ErrCode_ == ERRCODE_INVALID_VARIABLES_FOUND)     ? Mcalc_Error::ERRVAL_INVALID_VARIABLES_FOUND:
      (ErrCode_ == ERRCODE_MISSING_RIGHT_BRACKET)       ? Mcalc_Error::ERRVAL_MISSRIGHT_BRACKET:
      (ErrCode_ == ERRCODE_MISSING_LEFT_BRACKET)        ? Mcalc_Error::ERRVAL_MISSLEFT_BRACKET:
      (ErrCode_ == ERRCODE_INVALID_EXPR_FOUND)          ? Mcalc_Error::ERRVAL_INVALID_EXPR:
      (ErrCode_ == ERRCODE_FRACTION_OPERATOR_EXPECTED)  ? Mcalc_Error::ERRVAL_FRACTION_OPERATOR_EXPECTED:
      (ErrCode_ == ERRCODE_MISSING_RIGHT_BRACE)         ? Mcalc_Error::ERRVAL_MISSING_RIGHT_BRACE:
      (ErrCode_ == ERRCODE_MISSING_CLOSING_QUOTE)       ? Mcalc_Error::ERRVAL_MISSING_CLOSING_QUOTE:
      (ErrCode_ == ERRCODE_REQUIRED_OPERAND_MISSING)    ? Mcalc_Error::ERRVAL_REQUIRED_OPERAND_MISSING:
      (ErrCode_ == ERRCODE_MISPLACED_COMMA)             ? Mcalc_Error::ERRVAL_MISPLACED_COMMA:0
    );

  return retcode_;
}

/****************************************************************************/
void FunctionValidityChecker::SetLineNumber(int line_, int stopon_, bool debug_)
{
  _LineNumber = line_;
  _StopOnNumber = stopon_;

  if (_LineNumber == _StopOnNumber && debug_)
    cerr <<"stop on number: " <<line_;
}

/****************************************************************************/
bool FunctionValidityChecker::ChkIfMathLineValid(const char* str, bool Reset_, int len_, bool debug_)
{
  _MemDel->CheckIfEraseStoredTrash(STOREMEM);

  bool SiblingValid_ = true;
  bool DoProcess_ = false;
  bool InvalidCharChkDone_ = false;
  char* MathLine_ = NULL;
  int slen = 0;
  int max = 0;

  if (str)
  {
    MathLine_ = ::NewString(str);
    _OriginalStr = ::NewString(str);
    slen = strlen(str);

    if (0 < len_ && len_ < slen)
    {
      strncpy(MathLine_, str, len_);
      MathLine_[len_] = 0;
    }

    RemovePadding(_OriginalStr, " \t\r\n");
    RemoveChar(MathLine_, " \t\r\n");
    SetLineToProcess(MathLine_, true);

    if (Reset_)
    {
      max = ::strlen(MathLine_);
      ResizeChkStrOmit(max);

      SetChkFncPrec(false, true);
      ResetAllVars();
      ResetErrors();
      Reset_ = false;
    }
  }

  if (_LineToProcess)
  {
    DoProcess_ = (!Confirmed() || ConfirmedMatched()) &&
                 HasLineRemaining() && !HasInvalidTokens();

    if (DoProcess_)
      DoProcess_ = ChkIfBalancedBrk(_LineToProcess);

    while (DoProcess_ && _LineToProcess)
    {
      ChkIfFunctionValid(_LineToProcess, Reset_);
      DoProcess_ = (!Confirmed() || ConfirmedMatched()) &&
                   HasLineRemaining() && !HasInvalidTokens();

      if (DoProcess_)
      {
        SetLineToProcess(_LineRemaining, false);
        Reset_ = true;
      }
    }

    if (_Sibling && MathLine_ && (!ConfirmedInvalid() || ConfirmedMatched() || FracOpFound()))
    {
      MathLine_ = _Sibling->MakeStrSegment(MathLine_, slen);
      if (debug_)
        _Sibling->ShowDebugInfo();

      SiblingValid_ = _Sibling->ChkIfMathLineValid(MathLine_, false, _Sibling->GetStrLen());

      // Confirm delayed matched symbols
      if (FracOpFound() && SiblingValid_)
      {
        SetFracOpFound(false);
        ConfirmAsValid();
      }
    }
    else if (GiveErrorCode() == 0 && _Levels == 0 &&
             MathLine_ && ChkIfInvalidChars(MathLine_))
    {
      SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);
      InvalidCharChkDone_ = true;
    }
  }

  if (MathLine_)
    _MemDel->DelayedDeleteVoidp(MathLine_, STOREMEM);

  if (GiveErrorCode() != 0 && _Levels == 0 &&
      MathLine_ && !InvalidCharChkDone_)
    if (ChkIfInvalidChars(MathLine_))
      SetErrorCode(ERRCODE_INVALID_EXPR_FOUND);

  return (SiblingValid_ && ConfirmedValid() && !HasInvalidTokens());
}

/****************************************************************************/
MEMORYOPS_DEFN(StrVarData)
MEMORYOPS_DEFN(CalcGlobalSwitch)
MEMORYOPS_DEFN(ExprStringStack)
MEMORYOPS_DEFN(ExpressionGraphStack)
MEMORYOPS_DEFN(SubExpression)
MEMORYOPS_DEFN(FunctionCall)
MEMORYOPS_DEFN(FncParameter)
MEMORYOPS_DEFN(CalcGraphPlotter)
MEMORYOPS_DEFN(FunctionValidityChecker)

/****************************************************************************/
// CalcIoStateHandler class definitions
/****************************************************************************/
// expected valid IOState sequence
// 1. Client-->Calc : PROCESS, calculator input data sent
// non-graph output:
// 1.1 Calc-->Client : CALC_RESPONSE, Answer as calculated output returned to client         OR
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.2 Calc-->Client : INPUT_REQUIRED, Additional input data requested                       OR
//        Client-->Calc : INPUT_RECEIVED, Additional data sent by client
//           Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.3 Calc-->Client : OUTPUT_READY, Answer as non-calculated text string                    OR
//        Client-->Calc : OUTPUT_FETCHED, Non-calculated text string fetched
//           Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.4 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.5 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
//        Client : Fetch output from error log file and set state to: CALC_ERROR
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// graphing output:                                                                          OR
// 1.6a Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
//                                  graph operation data sent to client.
//        Client-->Calc : GRAPH_WAIT_ACK, Graph plotting operation type and data fetched
// 1.6b Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
//                                  graph operation data sent to client.
//        Client-->Calc : INPUT_RECEIVED, quit graph plotting signal sent by client
//
// 1.7 Calc-->Client : GRAPH_PROGRESS, Function graph plotting progress data sent            OR
//       Client-->Calc : GRAPH_PROGRESS_ACK, Function graph plotting progress data fetched
// 1.8a Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed                       OR
//         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
//            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.8b Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed
//         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
//            Calc-->Client : BATCHFILE_ENDED, Batch data file for Graph plotting ended
//               Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
//                  Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 1.9 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.10 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
//         Client : Fetch output from error log file and set state to: CALC_ERROR
//         Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 2. Client-->Calc : BREAK_PROGRAM, request calculator to break out from program mode
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 3. Client-->Calc : CALC_HALT, tell calculator to halt execution and quit
//        Calc->Client : IDLE_STATE, Calculator set to idle state before program termination
//
// 4. Calc-->Client : PROGRESS_READY, Send progress status of input data file processing
//        Client-->Calc : INFILE_PROGRESS_ACK, Non-calculated progress status text fetched
//           Calc-->Client : BATCHFILE_ENDED, Batch data file for math expressions ended
//              Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
//                 Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 5. Calc-->Client : SPAWN_NEW_MCALC, notify client to spawn another mcalc process
//        Client-->Calc : MCALC_SPAWNED, request to spawn mcalc process acknowledged and done
//
// 6. Client-->Calc : PROCESS, process signal sent by client to process non-output calc. directive
//       Calc-->Client : PROCESS_DONE, send acknowledgement signal to client of directive execution
//          Client-->Calc : PROCESS_DONE_ACK, server directive execution acknowledgement from client
//            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 7. Calc-->Client : CALC_HALT, calculator has self terminated and CALC_HALT signal is sent
//        Client : IDLE_STATE, Client sets calculator state file to idle state before quitting
//
/****************************************************************************/
//
//  PROCESS         = 1,     // - send process input data request from client program to calculator
//  OUTPUT_READY    = 2,     // - sent by calculator to indicate output data ready
//                           //     used to indicate text messages sent that are not meant as calculated answers
//                           //     examples: error messages, status messages, executed disp program commands...
//  CALC_HALT       = 4,     // - sent by client program to tell calculator to halt execution and quit
//  CALC_RESPONSE   = 8,     // - sent by calculator to indicate post processing response
//  INPUT_REQUIRED  = 16,    // - sent by calculator in script program or interactive text mode to
//                           //   indicate prompt from stdio/console input for additional required input data
//  OUTPUT_FETCHED  = 32,    // - sent by client program to indicate literal text string or graph plotting data fetched
//  INPUT_RECEIVED  = 64,    // - sent by client program to indicate required input data sent to calculator
//  BREAK_PROGRAM   = 128,   // - sent by client program to tell calculator to break program and exit program mode
//                           //   execution of program script if it is in program mode
//  IDLE_STATE      = 256,   // - calculator is in idle or initial starting state, set after CALC_HALT received
//  GRAPH_OUTPUT    = 512,   // - function graphing output is completed and ready to be read
//  GRAPH_WAIT      = 1024,  // - Function graphing is in process. Data points being plotted.
//  CALC_ERROR      = 2048,  // - sent by calculator to indicate calculator error from invalid input or other conditions
//  PROGRESS_READY  = 4096,  // - input data file -- calculation progress is ready and sent to gui client
//  ERROR_FETCH     = 8192,  // - set by calculator to indicate calculator error. Fetch output from error log file.
//  GRAPH_PROGRESS  = 16384, // - plotted data points -- graph plotting progress is ready and sent to gui client
//
//  INFILE_PROGRESS_ACK = 32768,  // - Input file processing progress acknowledged/fetched by client
//  GRAPH_PROGRESS_ACK  = 65536,  // - Graph plotting processing progress acknowledged/fetched by client
//  GRAPH_WAIT_ACK      = 131072, // - Graph wait signal acknowledged, graph plot operation data fetched
//
//  SPAWN_NEW_MCALC = 262144, // - sent by calculator to notify client to spawn another mcalc process
//  MCALC_SPAWNED   = 524288, // - sent by client program to indicate request to spawn mcalc process acknowledged and done
//
//  BATCHFILE_ENDED     = 1048576, // sent by calculator to indicate end of batch data input file processing
//  BATCHFILE_ENDED_ACK = 2097152, // sent by client to acknowledge and of batch data file signal
//  PROCESS_DONE        = 4194304, // sent by calculator to indicate process acknowledgement of non-output directives
//  PROCESS_DONE_ACK    = 8388608, // sent by client to acknowledge server directive execution
//
//  RESENDLASTSIG       = 16777216, // Resend last signal sent by server
//  CLIENTPING          = 33554432, // Server ping signal to client
//  CLIENTPING_ACK      = 67108864, // Client acknowledgement of client ping signal
//
/****************************************************************************/
CalcIoStateHandler::CalcIoStateHandler(CalculatorBase* Parent_, int* IoStateAddr_):
_Parent(Parent_),
_Plotter(Parent_ ? Parent_->GetGraphPlotter():NULL),

_IterIndex(0),
_PrevProgressDone(0),

_GraphAltProc(0),
_ProcMatch(false),
_ForceState(false),
_QuitGraph(false),
_SessionOptionOverride(Parent_ ? Parent_->SessionOptionOverride():false),

_CurrProcState(0),
_PrevIoState(0),
_IoStatep(IoStateAddr_)
{
  ::memset(_ProcessStates, 0, sizeof(int) * MAX_PROCESSES);
  ::memset(_UnAckStates, 0, sizeof(int) * MAX_PROCESSES);

  ::memset(_UnAckTransition, 0, sizeof(int) * MAX_PROCESSES);
  ::memset(_ProcessTransition, 0, sizeof(int) * MAX_PROCESSES);
}

/****************************************************************************/
CalcIoStateHandler::CalcIoStateHandler(const CalcIoStateHandler& Obj_):
_Parent(Obj_._Parent),
_Plotter(Obj_._Plotter),

_IterIndex(Obj_._IterIndex),
_PrevProgressDone(Obj_._PrevProgressDone),

_GraphAltProc(Obj_._GraphAltProc),
_ProcMatch(Obj_._ProcMatch),
_ForceState(Obj_._ForceState),
_QuitGraph(Obj_._QuitGraph),
_SessionOptionOverride(Obj_._SessionOptionOverride),

_CurrProcState(Obj_._CurrProcState),
_PrevIoState(Obj_._PrevIoState),
_IoStatep(Obj_._IoStatep)
{
  ::memmove(_ProcessStates, Obj_._ProcessStates, sizeof(int) * MAX_PROCESSES);
  ::memmove(_UnAckStates, Obj_._UnAckStates, sizeof(int) * MAX_PROCESSES);

  ::memmove(_UnAckTransition, Obj_._UnAckTransition, sizeof(int) * MAX_PROCESSES);
  ::memmove(_ProcessTransition, Obj_._ProcessTransition, sizeof(int) * MAX_PROCESSES);
}

/****************************************************************************/
CalcIoStateHandler& CalcIoStateHandler::operator = (const CalcIoStateHandler& Obj_)
{
  if (this != &Obj_)
  {
    _Parent = Obj_._Parent;
    _Plotter = Obj_._Plotter;

    ::memmove(_ProcessStates, Obj_._ProcessStates, sizeof(int) * MAX_PROCESSES);
    ::memmove(_UnAckStates, Obj_._UnAckStates, sizeof(int) * MAX_PROCESSES);

    ::memmove(_UnAckTransition, Obj_._UnAckTransition, sizeof(int) * MAX_PROCESSES);
    ::memmove(_ProcessTransition, Obj_._ProcessTransition, sizeof(int) * MAX_PROCESSES);

    _CurrProcState = Obj_._CurrProcState;
    _PrevIoState = Obj_._PrevIoState;
    _IoStatep = Obj_._IoStatep;
  }

  return *this;
}

/****************************************************************************/
void CalcIoStateHandler::Clear()
{
  ::memset(_ProcessStates, 0, sizeof(int) * MAX_PROCESSES);
  ::memset(_UnAckStates, 0, sizeof(int) * MAX_PROCESSES);

  ::memset(_UnAckTransition, 0, sizeof(int) * MAX_PROCESSES);
  ::memset(_ProcessTransition, 0, sizeof(int) * MAX_PROCESSES);

  _CurrProcState = 0;
  _PrevIoState = 0;
}

/****************************************************************************/
void CalcIoStateHandler::SetInErrorProcess(bool flag_)
{
  if (flag_)
    (_CurrProcState |= IN_ERROR_PROCESS);
  else
    ClearInErrorProcess();
}

/****************************************************************************/
void CalcIoStateHandler::SetInOutputProcess(bool flag_)
{
  if (flag_)
    (_CurrProcState |= IN_OUTPUT_PROCESS);
  else
    ClearInOutputProcess();
}

/****************************************************************************/
void CalcIoStateHandler::SetInCalcProgressProcess(bool flag_)
{
  if (flag_)
    (_CurrProcState |= IN_CALCPROGRESS_PROCESS);
  else
    ClearInCalcProgressProcess();
}

/****************************************************************************/
void CalcIoStateHandler::SetInCalcSpawnProcess(bool flag_)
{
  if (flag_)
    (_CurrProcState |= IN_CALCSPAWN_PROCESS);
  else
    ClearInCalcSpawnProcess();
}

/****************************************************************************/
void CalcIoStateHandler::SetInGraphProcess(bool flag_)
{
  if (flag_)
    (_CurrProcState |= IN_GRAPH_PROCESS);
  else
    ClearInGraphProcess();
}

/****************************************************************************/
void CalcIoStateHandler::SetIoStateAddr(int* IoStateAddr_)
{
  _IoStatep = IoStateAddr_;
}

/****************************************************************************/
int CalcIoStateHandler::CurrentIoState() const
{
  return (_IoStatep ? *_IoStatep:0);
}

/****************************************************************************/
int CalcIoStateHandler::GetIoState(int Sleep_)
{
  int RetIoState_ = _Parent->SetNoPolling(false)
                           ->Bare_GetIoState(Sleep_);

  if (_Parent->InAsyncMode() || _Parent->SessionOption())
    if (!ResetAtEndOfProcess(RetIoState_))  // step 2
      SetIoStateAck(RetIoState_);  // step 3

  return (_IoStatep ? *_IoStatep:RetIoState_);
}

/****************************************************************************/
CalcIoStateHandler* CalcIoStateHandler::SetSessionOptionOverride(bool flag_)
{
  _SessionOptionOverride = flag_;
  _Parent->SetSessionOptionOverride(flag_);

  return this;
}

/****************************************************************************/
void CalcIoStateHandler::SetIoState(int State_, bool NoDup_,
                                    int Delay_, bool WaitForAck_)
{
  bool ErrStates_ = State_ == Mcalc_IOState::CALC_ERROR ||
                    State_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = State_ == Mcalc_IOState::CALC_HALT ||
                     State_ == Mcalc_IOState::IDLE_STATE;

  if (!SessionOptionOverride() && !CritStates_ &&
      (!_Parent->InAsyncMode() ||
       !_Parent->GetProgramIostateFilename() || _Parent->SessionOption()))
    return;

  int CurState_ = 0;

  bool BreakAll_ = false;
  bool DoHalt_ = false;
  bool FetchLimitReached_ = false;

  if (!ResetAtEndOfProcess(State_))  // step 2
    SetIoStateAck(State_);  // step 3

  if (WaitForAck_ && IsIoStateUnAck(State_))  // step 4
    CurState_ = WaitForIoStateAck(&BreakAll_, &DoHalt_, &FetchLimitReached_);

  if (BreakAll_ || DoHalt_)
    _Parent->ReceiveBreakOrQuit(CurState_);
  else
  {
    _Parent->SetNoPolling(false)
           ->Bare_SetIoState(State_, NoDup_, Delay_);
    UpdateIoState(State_);  // step 1
  }

  if (_Parent->SessionOption() && !CritStates_ && !ErrStates_)
    _Parent->SetSessionOptionOverride(false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfProcess(int State_)
{
  bool ready1_ = GraphProcessDone(NULL, NULL, true);
  bool ready2_ = CalcOutputProcessDone(NULL, NULL, true);
  bool ready3_ = CalcProgressProcessDone(NULL, NULL, true);
  bool ready4_ = SpawnCalcProcessDone(NULL, NULL, true);

  if (!ready1_ && !ready2_ && !ready3_ && !ready4_)
    return false;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfProcess");

    _Parent->DbgPtr()->ShowInt(State_, "State_");
    _Parent->DbgPtr()->ShowInt(ready1_, "ready1_");
    _Parent->DbgPtr()->ShowInt(ready2_, "ready2_");
    _Parent->DbgPtr()->ShowInt(ready3_, "ready3_");
    _Parent->DbgPtr()->ShowInt(ready4_, "ready4_");
  #endif

  ClearGraphAltProc();

  bool ResetDone100_ = false;
  bool ResetDone200_ = false;
  bool ResetDone300_ = false;
  bool ResetDone400_ = false;

  bool retval101_ = false;
  bool retval201_ = false;
  bool retval301_ = false;
  bool retval401_ = false;
  bool Done_ = false;

  if (_Parent->GraphOperation() && _Parent->GetGraphPlotter())
  {
    retval101_ = ready1_ ? ResetAtEndOfGraphProcess(State_, true, &ResetDone100_):false;
    Done_ = retval101_ && ResetDone100_;
  }

  retval201_ = Done_ ? false:
               ready2_ ? ResetAtEndOfCalcOutputProcess(State_, true, &ResetDone200_):false;
  Done_ = Done_ || (retval201_ && ResetDone200_);

  if (_Parent->SessionOption())
  {
    retval301_ = Done_ ? false:
                 ready3_ ? ResetAtEndOfCalcProgressProcess(State_, true, &ResetDone300_):false;
    Done_ = Done_ || (retval301_ && ResetDone300_);
  }

  retval401_ = Done_ ? false:
               ready4_ ? ResetAtEndOfSpawnCalcProcess(State_, true, &ResetDone400_):false;
  Done_ = Done_ || (retval401_ && ResetDone400_);

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->ShowInt(Done_, "Done_");
    _Parent->DbgPtr()->ShowInt(retval101_, "retval101_");
    _Parent->DbgPtr()->ShowInt(retval201_, "retval201_");
    _Parent->DbgPtr()->ShowInt(retval301_, "retval301_");
    _Parent->DbgPtr()->ShowInt(retval401_, "retval401_");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return Done_;
}

/****************************************************************************/
bool CalcIoStateHandler::SetIoStateAck(int State_)
{
  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("SetIoStateAck");
    ChrString StateStr_;
  #endif

  ClearGraphAltProc();

  bool AckSet100_ = false;
  bool AckSet200_ = false;
  bool AckSet300_ = false;
  bool AckSet400_ = false;

  bool retval101_ = false;
  bool retval102_ = false;
  bool retval103_ = false;
  bool retval201_ = false;
  bool retval301_ = false;
  bool retval401_ = false;
  bool SentDone_ = false;
  bool Ack_ = false;

  Ack_ = ClientAckToGraphWait(true, true);
  retval101_ = Ack_ ? true:
               ForceState() ?
                  GraphWaitAck(Mcalc_IOState::GRAPH_WAIT_ACK, true, &AckSet100_):
                  GraphWaitAck(State_, true, &AckSet100_);
  retval101_ = Ack_ || (!Ack_ && retval101_ && AckSet100_);

  if (QuitGraph() && InGraphProcess())
  {
    #if CALCLIB_DEBUG11a
      _Parent->DbgPtr()->ShowMessage("SetQuitGraph(true);\n");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    _Parent->Exec_SetQuitGraph(true);
    _Parent->Exec_SetBatchFileDonePending(true);

    if (!ResponsePendingDone())
      _CurrProcState &= ~IN_GRAPH_PROCESS;

    return false;
  }
  else if (_Parent->GraphOperation() && _Parent->GetGraphPlotter())
  {
    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_ACK) ||
        ClientAckGraphWaitTransition())
    {
      SentDone_ = GraphProgressSentDone();
      Ack_ = ClientAckToGraphProgress(true, true);
      AckSet100_ = false;

      if (Ack_ || SentDone_)
        retval101_ = false;

      retval102_ = !SentDone_ ? false:
                   Ack_ ? true:
                   ForceState() ?
                      GraphProgressAck(Mcalc_IOState::GRAPH_PROGRESS_ACK, true, &AckSet100_):
                      GraphProgressAck(State_, true, &AckSet100_);
      retval102_ = Ack_ || (!Ack_ && retval102_ && AckSet100_);

      if (retval102_)
        retval101_ = false;
    }

    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_OUTPUT_ACK) ||
        ClientAckGraphProgressTransition())
    {
      Ack_ = ClientAckToGraphOutput(false);
      AckSet100_ = false;

      if (Ack_ || ResponseCompletedDone())
        retval101_ =
        retval102_ = false;

      retval103_ = Ack_ ? true:
                   ForceState() ?
                      GraphOutputAck(Mcalc_IOState::OUTPUT_FETCHED, true, &AckSet100_):
                      GraphOutputAck(State_, true, &AckSet100_);
      retval103_ = Ack_ || (!Ack_ && retval103_ && AckSet100_);

      if (retval103_)
        retval101_ =
        retval102_ = false;

      if (!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_ACK &&
          (State_ != Mcalc_IOState::GRAPH_PROGRESS ||
           !InitialProgressStepNotDone(State_)))
      {
        SentDone_ = GraphProgressSentDone();
        Ack_ = ClientAckToGraphProgress(true, true);
        AckSet100_ = false;

        if (Ack_ || SentDone_)
          retval101_ = false;

        if (State_ == Mcalc_IOState::GRAPH_PROGRESS)
          GraphProgressUpdate(State_, true);

        #if CALCLIB_DEBUG11a
          _Parent->DbgPtr()->ShowMessage("if (GraphAltProc() == pvGRAPH_PROGRESS_ACK) ...\n");
          _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
          _Parent->DbgPtr()->ShowInt(SentDone_, "SentDone_");
          _Parent->DbgPtr()->ShowInt(ForceState(), "ForceState()");
        #endif

        retval102_ = !SentDone_ ? false:
                     ForceState() ?
                        GraphProgressAck(Mcalc_IOState::GRAPH_PROGRESS_ACK, true, &AckSet100_):
                        GraphProgressAck(State_, true, &AckSet100_);
        retval102_ = retval102_ && AckSet100_;

        if (retval102_)
          retval101_ =
          retval103_ = false;
      }
      #if CALCLIB_DEBUG11a
        else
        {
          StateStr_ = _Parent->GiveIoStateStr(State_);
          _Parent->DbgPtr()->ShowInt(ProcMatch(), "ProcMatch()");
          _Parent->DbgPtr()->ShowInt(GraphAltProc() == pvGRAPH_PROGRESS_ACK,
                                     "GraphAltProc() == pvGRAPH_PROGRESS_ACK");
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
          _Parent->DbgPtr()->ShowInt(InitialProgressStepNotDone(State_),
                                     "InitialProgressStepNotDone(State_)");
        }
      #endif
    }
  }

  bool GraphDone_ = retval101_ || retval102_ || retval103_;
  bool Done_ = GraphDone_;
  bool InProc_ = InGraphProcess();

  if (Done_ && InProc_)
    retval201_ = false;
  else
  {
    Ack_ = ClientAckToCalcOutput(false);
    retval201_ = Ack_ ? true:CalcOutputAck(State_, true, &AckSet200_);
    retval201_ = Ack_ || (!Ack_ && retval201_ && AckSet200_);
  }

  Done_ = Done_ || retval201_;
  InProc_ = InProc_ || InOutputProcess();

  if (Done_ && InProc_)
    retval301_ = false;
  else if (_Parent->SessionOption())
  {
    Ack_ = ClientAckToCalcProgress(false);
    retval301_ = Ack_ ? true:CalcProgressAck(State_, true, &AckSet300_);
    retval301_ = Ack_ || (!Ack_ && retval301_ && AckSet300_);
  }

  Done_ = Done_ || retval301_;
  InProc_ = InProc_ || InCalcProgressProcess();

  if (Done_ && InProc_)
    retval401_ = false;
  else
  {
    Ack_ = ClientAckToSpawnCalc(false);
    retval401_ = Ack_ ? true:SpawnCalcAck(State_, true, &AckSet400_);
    retval401_ = Ack_ || (!Ack_ && retval401_ && AckSet400_);
  }

  Done_ = Done_ || retval401_;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(GraphDone_, "GraphDone_");
    _Parent->DbgPtr()->ShowInt(retval201_, "retval201_");
    _Parent->DbgPtr()->ShowInt(retval301_, "retval301_");
    _Parent->DbgPtr()->ShowInt(retval401_, "retval401_");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return Done_;
}

/****************************************************************************/
int CalcIoStateHandler::WaitForOutputStateAck(int CurState_, bool* FetchLimitReached_)
{
  if (CurState_ == Mcalc_IOState::OUTPUT_READY)
    CurState_ = _Parent->WaitForClientOutputStates(CurState_, FetchLimitReached_);
  else if (CurState_ == Mcalc_IOState::CALC_RESPONSE)
    CurState_ = _Parent->WaitForClientProcessStates(CurState_, FetchLimitReached_);
  else if (CurState_ == Mcalc_IOState::PROCESS_DONE)
    CurState_ = _Parent->WaitForClientProcessStates(CurState_, FetchLimitReached_);
  else if (CurState_ == Mcalc_IOState::INPUT_REQUIRED)
    CurState_ = _Parent->WaitForClientOutputExtStates(CurState_, FetchLimitReached_);

  return CurState_;
}

/****************************************************************************/
int CalcIoStateHandler::WaitForIoStateAck(bool* BreakAll_, bool* DoHalt_,
                                          bool* FetchLimitReached_)
{
  #if CALCLIB_DEBUG12b
    _Parent->DbgPtr()->EnterLevel("WaitForIoStateAck");
    ChrString StateStr_;
  #endif

  #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    if (_Parent->_PollClientMgr)
    {
      _Parent->_PollClientMgr->ResetRetryRead();
      _Parent->_PollClientMgr->SetExitAtRetryMax(true);
    }
  #endif

  if (QuitGraph() && InGraphProcess())
  {
    #if CALCLIB_DEBUG11a
      _Parent->DbgPtr()->ShowMessage("SetQuitGraph(true);\n");
    #endif

    _Parent->Exec_SetQuitGraph(true);
    _Parent->Exec_SetBatchFileDonePending(true);

    if (!ResponsePendingDone())
      _CurrProcState &= ~IN_GRAPH_PROCESS;
  }

  int CurState_ = _Parent->SetNoPolling(false)
                         ->Bare_GetIoState(0);

  if (_UnAckStates[CALC_OUTPUT] == UNACKNOWLEDGED)
    CurState_ = WaitForOutputStateAck(CurState_, FetchLimitReached_);
  else if (_UnAckStates[CALC_PROGRESS] == UNACKNOWLEDGED)
    CurState_ = _Parent->WaitForClientInFileProgressStates(CurState_, FetchLimitReached_);
  else if (_UnAckStates[SPAWN_CALC] == UNACKNOWLEDGED)
    CurState_ = _Parent->WaitForClientSpawnCalcStates(CurState_, FetchLimitReached_);
  else if (_UnAckStates[GRAPH_PENDING] == UNACKNOWLEDGED)
    CurState_ = _Parent->WaitForClientGraphWaitStates(CurState_, FetchLimitReached_);
  else if (_UnAckStates[GRAPH_PROGRESS] == UNACKNOWLEDGED)
    CurState_ = _Parent->WaitForClientGraphProgressStates(CurState_, FetchLimitReached_);
  else if (_UnAckStates[GRAPH_OUTPUT] == UNACKNOWLEDGED)
    CurState_ = _Parent->WaitForClientOutputStates(CurState_, FetchLimitReached_);

  if (DoHalt_)
    *DoHalt_ = CurState_ == Mcalc_IOState::CALC_HALT;

  if (_Parent->InProgramMode(true) && BreakAll_)
    *BreakAll_ = CurState_ == Mcalc_IOState::CALC_HALT ||
                 CurState_ == Mcalc_IOState::BREAK_PROGRAM;

  #if CALCLIB_DEBUG12b
    StateStr_ = _Parent->GiveIoStateStr(CurState_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return CurState_;
}

/****************************************************************************/
bool CalcIoStateHandler::IsIoStateUnAck(int State_)
{
  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("IsIoStateUnAck");
    ChrString StateStr_;
  #endif

  ClearGraphAltProc();

  bool retval101_ = false;
  bool retval102_ = false;
  bool retval103_ = false;
  bool retval201_ = false;
  bool retval301_ = false;
  bool retval401_ = false;
  bool UnAcked_ = false;
  bool SentDone_ = false;

  SentDone_ = ResponsePendingDone();
  retval101_ = SentDone_ ? GraphResponsePending(State_):false;
  retval101_ = SentDone_ && retval101_;

  if (QuitGraph() && InGraphProcess())
  {
    #if CALCLIB_DEBUG11a
      _Parent->DbgPtr()->ShowMessage("SetQuitGraph(true);\n");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    _Parent->Exec_SetQuitGraph(true);
    _Parent->Exec_SetBatchFileDonePending(true);

    if (!ResponsePendingDone())
      _CurrProcState &= ~IN_GRAPH_PROCESS;

    return false;
  }
  else if (_Parent->GraphOperation() && _Parent->GetGraphPlotter())
  {
    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_SENT) ||
        GraphWaitSentTransition())
    {
      SentDone_ = GraphProgressSentDone();
      UnAcked_ = _UnAckStates[GRAPH_PROGRESS] == UNACKNOWLEDGED;

      if (UnAcked_ || SentDone_)
        retval101_ = false;

      retval102_ = UnAcked_ ? true:
                   SentDone_ ? GraphProgressSentUnAcked(State_):false;
      retval102_ = SentDone_ && retval102_;

      if (retval102_)
        retval101_ = false;
    }

    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_RESPONSE_COMPLETED) ||
        GraphProgressSentTransition())
    {
      SentDone_ = ResponseCompletedDone();
      UnAcked_ = _UnAckStates[GRAPH_OUTPUT] == UNACKNOWLEDGED;

      if (UnAcked_ || SentDone_)
        retval101_ =
        retval102_ = false;

      retval103_ = UnAcked_ ? true:
                   SentDone_ ? GraphResponseCompleted(State_):false;
      retval103_ = SentDone_ && retval103_;

      if (retval103_)
        retval101_ =
        retval102_ = false;

      if (!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_SENT &&
          (State_ != Mcalc_IOState::GRAPH_PROGRESS ||
           !InitialProgressStepNotDone(State_)))
      {
        SentDone_ = GraphProgressSentDone();
        UnAcked_ = _UnAckStates[GRAPH_PROGRESS] == UNACKNOWLEDGED;

        if (UnAcked_ || SentDone_)
          retval101_ = false;

        if (State_ == Mcalc_IOState::GRAPH_PROGRESS)
          GraphProgressUpdate(State_, true);

        #if CALCLIB_DEBUG11a
          _Parent->DbgPtr()->ShowMessage("if (GraphAltProc() == pvGRAPH_PROGRESS_SENT) ...\n");
          _Parent->DbgPtr()->ShowInt(SentDone_, "SentDone_");
          _Parent->DbgPtr()->ShowInt(UnAcked_, "UnAcked_");
        #endif

        retval102_ = UnAcked_ ? true:
                     SentDone_ ? GraphProgressSentUnAcked(State_):false;
        retval102_ = SentDone_ && retval102_;

        if (retval102_)
          retval101_ =
          retval103_ = false;
      }
      #if CALCLIB_DEBUG11a
        else
        {
          StateStr_ = _Parent->GiveIoStateStr(State_);
          _Parent->DbgPtr()->ShowInt(ProcMatch(), "ProcMatch()");
          _Parent->DbgPtr()->ShowInt(GraphAltProc() == pvGRAPH_PROGRESS_SENT,
                                     "GraphAltProc() == pvGRAPH_PROGRESS_SENT");
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
          _Parent->DbgPtr()->ShowInt(InitialProgressStepNotDone(State_),
                                     "InitialProgressStepNotDone(State_)");
        }
      #endif
    }
  }

  bool GraphDone_ = retval101_ || retval102_ || retval103_;
  bool Done_ = GraphDone_;
  bool InProc_ = InGraphProcess();

  if (Done_ && InProc_)
    retval201_ = false;
  else
  {
    SentDone_ = CalcOutputSentDone();
    retval201_ = SentDone_ ? CalcOutputSentUnAcked(State_):false;
    retval201_ = SentDone_ && retval201_;
  }

  Done_ = Done_ || retval201_;
  InProc_ = InProc_ || InOutputProcess();

  if (Done_ && InProc_)
    retval301_ = false;
  else if (_Parent->SessionOption())
  {
    SentDone_ = CalcProgressSentDone();
    retval301_ = SentDone_ ? CalcProgressSentUnAcked(State_):false;
    retval301_ = SentDone_ && retval301_;
  }

  Done_ = Done_ || retval301_;
  InProc_ = InProc_ || InCalcProgressProcess();

  if (Done_ && InProc_)
    retval401_ = false;
  else
  {
    SentDone_ = SpawnCalcSentDone();
    retval401_ = SentDone_ ? SpawnCalcSentUnAcked(State_):false;
    retval401_ = SentDone_ && retval401_;
  }

  Done_ = Done_ || retval401_;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(GraphDone_, "GraphDone_");
    _Parent->DbgPtr()->ShowInt(retval201_, "retval201_");
    _Parent->DbgPtr()->ShowInt(retval301_, "retval301_");
    _Parent->DbgPtr()->ShowInt(retval401_, "retval401_");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return Done_;
}

/****************************************************************************/
bool CalcIoStateHandler::UpdateIoState(int State_)
{
  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("UpdateIoState");
    ChrString StateStr_;
  #endif

  ClearGraphAltProc();

  bool Updated100_ = false;
  bool Updated200_ = false;
  bool Updated300_ = false;
  bool Updated400_ = false;

  bool retval101_ = false;
  bool retval102_ = false;
  bool retval103_ = false;
  bool retval201_ = false;
  bool retval301_ = false;
  bool retval401_ = false;
  bool reentryval_ = false;
  bool UpdateDone_ = false;

  UpdateDone_ = ResponsePendingDone();
  retval101_ = UpdateDone_ ? true:GraphWaitUpdate(State_, true, &Updated100_);
  retval101_ = UpdateDone_ || (!UpdateDone_ && retval101_ && Updated100_);

  if (QuitGraph() && InGraphProcess())
  {
    #if CALCLIB_DEBUG11a
      _Parent->DbgPtr()->ShowMessage("SetQuitGraph(true);\n");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    _Parent->Exec_SetQuitGraph(true);
    _Parent->Exec_SetBatchFileDonePending(true);

    if (!ResponsePendingDone())
      _CurrProcState &= ~IN_GRAPH_PROCESS;

    return false;
  }
  else if (_Parent->GraphOperation() && _Parent->GetGraphPlotter())
  {
    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_UPDATE) ||
        GraphWaitUpdateTransition())
    {
      UpdateDone_ = GraphProgressSentDone();
      Updated100_ = false;

      if (UpdateDone_)
        retval101_ = false;

      retval102_ = UpdateDone_ ? true:GraphProgressUpdate(State_, true, &Updated100_);
      retval102_ = UpdateDone_ || (!UpdateDone_ && retval102_ && Updated100_);

      if (retval102_)
        retval101_ = false;
    }

    if ((!ProcMatch() && GraphAltProc() == pvGRAPH_OUTPUT_UPDATE) ||
        GraphProgressUpdateTransition())
    {
      UpdateDone_ = ResponseCompletedDone();
      Updated100_ = false;

      if (UpdateDone_)
        retval101_ =
        retval102_ = false;

      retval103_ = UpdateDone_ ? true:GraphOutputUpdate(State_, true, &Updated100_);
      retval103_ = UpdateDone_ || (!UpdateDone_ && retval103_ && Updated100_);

      if (retval103_)
        retval101_ =
        retval102_ = false;

      if (!ProcMatch() && GraphAltProc() == pvGRAPH_PROGRESS_UPDATE)
      {
        UpdateDone_ = GraphProgressSentDone();
        Updated100_ = false;

        if (UpdateDone_)
          retval101_ = false;

        #if CALCLIB_DEBUG11a
          _Parent->DbgPtr()->ShowMessage("if (GraphAltProc() == pvGRAPH_PROGRESS_UPDATE) ...\n");
          _Parent->DbgPtr()->ShowInt(UpdateDone_, "UpdateDone_");
        #endif

        retval102_ = GraphProgressUpdate(State_, true, &Updated100_);
        retval102_ = retval102_ && Updated100_;

        if (retval102_)
          retval101_ =
          retval103_ = false;
      }
    }
  }

  bool GraphDone_ = retval101_ || retval102_ || retval103_;
  bool Done_ = GraphDone_;
  bool InProc_ = InGraphProcess();

  if (Done_ && InProc_)
    retval201_ = false;
  else
  {
    UpdateDone_ = CalcOutputSentDone();
    retval201_ = UpdateDone_ ? true:CalcOutputUpdate(State_, true, &Updated200_);
    retval201_ = UpdateDone_ || (!UpdateDone_ && retval201_ && Updated200_);
  }

  Done_ = Done_ || retval201_;
  InProc_ = InProc_ || InOutputProcess();

  if (Done_ && InProc_)
    retval301_ = false;
  else if (_Parent->SessionOption())
  {
    UpdateDone_ = CalcProgressSentDone();
    retval301_ = UpdateDone_ ? true:CalcProgressUpdate(State_, true, &Updated300_);
    retval301_ = UpdateDone_ || (!UpdateDone_ && retval301_ && Updated300_);
  }

  Done_ = Done_ || retval301_;
  InProc_ = InProc_ || InCalcProgressProcess();

  if (Done_ && InProc_)
    retval401_ = false;
  else
  {
    UpdateDone_ = SpawnCalcSentDone();
    retval401_ = UpdateDone_ ? true:SpawnCalcUpdate(State_, true, &Updated400_);
    retval401_ = UpdateDone_ || (!UpdateDone_ && retval401_ && Updated400_);
  }

  Done_ = Done_ || retval401_;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b))
    StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(GraphDone_, "GraphDone_");
    _Parent->DbgPtr()->ShowInt(retval201_, "retval201_");
    _Parent->DbgPtr()->ShowInt(retval301_, "retval301_");
    _Parent->DbgPtr()->ShowInt(retval401_, "retval401_");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return Done_;
}

/****************************************************************************/
void CalcIoStateHandler::ResetStateWhenProcessDone(int* Totalp_, int* Donep_)
{
  int Total_ = 0;
  int Done_ = 0;

  int SubTotal_ = 0;
  int SubDone_ = 0;

  if ((!_Parent->InAsyncMode() && !_Parent->SessionOption()) ||
      !_Parent->GetProgramIostateFilename())
  {
    if (Totalp_)
      *Totalp_ = Total_;

    if (Donep_)
      *Donep_ = Done_;

    return;
  }

  if (CalcOutputProcessDone(&SubTotal_, &SubDone_))
    ResetCalcOutputState();

  Total_ += SubTotal_;
  Done_ += SubDone_;
  SubTotal_ = 0;
  SubDone_ = 0;

  if (_Parent->SessionOption())
  {
    if (CalcProgressProcessDone(&SubTotal_, &SubDone_))
      ResetCalcProgressState();

    Total_ += SubTotal_;
    Done_ += SubDone_;
    SubTotal_ = 0;
    SubDone_ = 0;
  }

  if (SpawnCalcProcessDone(&SubTotal_, &SubDone_))
    ResetSpawnCalcState();

  Total_ += SubTotal_;
  Done_ += SubDone_;
  SubTotal_ = 0;
  SubDone_ = 0;

  if (_Parent->GraphOperation() && _Parent->GetGraphPlotter())
  {
    if (GraphProcessDone(&SubTotal_, &SubDone_))
      ResetGraphState();

    Total_ += SubTotal_;
    Done_ += SubDone_;

    if (Totalp_)
      *Totalp_ = Total_;

    if (Donep_)
      *Donep_ = Done_;
  }
}

/****************************************************************************/
bool CalcIoStateHandler::NotInErrorStates(int State_, bool Fetch_, bool SetByClient_) const
{
  int InProgMode_ = _Parent->InProgramMode(false) ?
                        State_ != Mcalc_IOState::BREAK_PROGRAM:1;

  bool InState_ = false;

  if (!Fetch_ && !SetByClient_)
    InState_ = (InProgMode_ &&
                State_ != Mcalc_IOState::PROCESS &&
                State_ != Mcalc_IOState::CALC_HALT);
  else
    InState_ = (InProgMode_ &&
                (!Fetch_ ||
                 (!SetByClient_ && State_ != Mcalc_IOState::PROCESS &&
                                   State_ != Mcalc_IOState::CALC_ERROR)) &&
                (Fetch_ ||
                 (SetByClient_ && State_ != Mcalc_IOState::ERROR_FETCH)) &&
                State_ != Mcalc_IOState::CALC_HALT);

  return InState_;
}

/****************************************************************************/
bool CalcIoStateHandler::NotInProcessStates(int State_, bool Inverse_) const
{
  int InProgMode_ = 0;
  bool InState_ = false;

  if (Inverse_)
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ == Mcalc_IOState::BREAK_PROGRAM:0;
    InState_ = (InProgMode_ ||
                State_ == Mcalc_IOState::PROCESS ||
                State_ == Mcalc_IOState::CALC_HALT);
  }
  else
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ != Mcalc_IOState::BREAK_PROGRAM:1;
    InState_ = (InProgMode_ &&
                State_ != Mcalc_IOState::PROCESS &&
                State_ != Mcalc_IOState::CALC_HALT);
  }

  return InState_;
}

/****************************************************************************/
bool CalcIoStateHandler::NotInOutputStates(int State_, bool Inverse_) const
{
  int InProgMode_ = 0;
  bool InState_ = false;

  if (Inverse_)
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ == Mcalc_IOState::BREAK_PROGRAM:0;
    InState_ = (InProgMode_ ||
                State_ == Mcalc_IOState::PROCESS ||
                State_ == Mcalc_IOState::PROCESS_DONE ||
                State_ == Mcalc_IOState::PROCESS_DONE_ACK ||
                State_ == Mcalc_IOState::OUTPUT_FETCHED ||
                State_ == Mcalc_IOState::CALC_HALT);
  }
  else
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ != Mcalc_IOState::BREAK_PROGRAM:1;
    InState_ = (InProgMode_ &&
                State_ != Mcalc_IOState::PROCESS &&
                State_ != Mcalc_IOState::PROCESS_DONE &&
                State_ != Mcalc_IOState::PROCESS_DONE_ACK &&
                State_ != Mcalc_IOState::OUTPUT_FETCHED &&
                State_ != Mcalc_IOState::CALC_HALT);
  }

  return InState_;
}

/****************************************************************************/
bool CalcIoStateHandler::NotInOutputExtStates(int State_, bool Inverse_) const
{
  int InProgMode_ = 0;
  bool InState_ = false;

  if (Inverse_)
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ == Mcalc_IOState::BREAK_PROGRAM:0;
    InState_ = (InProgMode_ ||
                State_ == Mcalc_IOState::PROCESS ||
                State_ == Mcalc_IOState::PROCESS_DONE ||
                State_ == Mcalc_IOState::INPUT_RECEIVED ||
                State_ == Mcalc_IOState::PROCESS_DONE_ACK ||
                State_ == Mcalc_IOState::OUTPUT_FETCHED ||
                State_ == Mcalc_IOState::CALC_HALT);
  }
  else
  {
    InProgMode_ = _Parent->InProgramMode(false) ?
                      State_ != Mcalc_IOState::BREAK_PROGRAM:1;
    InState_ = (InProgMode_ &&
                State_ != Mcalc_IOState::PROCESS &&
                State_ != Mcalc_IOState::PROCESS_DONE &&
                State_ != Mcalc_IOState::INPUT_RECEIVED &&
                State_ != Mcalc_IOState::PROCESS_DONE_ACK &&
                State_ != Mcalc_IOState::OUTPUT_FETCHED &&
                State_ != Mcalc_IOState::CALC_HALT);
  }

  return InState_;
}

/****************************************************************************/
bool CalcIoStateHandler::NotInEqvOutStates(int CalcState_, int State_) const
{
  return ((CalcState_ == Mcalc_IOState::OUTPUT_READY) ? NotInOutputStates(State_):
          (CalcState_ == Mcalc_IOState::PROCESS_DONE) ? NotInOutputStates(State_):
          (CalcState_ == Mcalc_IOState::CALC_RESPONSE) ? NotInProcessStates(State_):
          (CalcState_ == Mcalc_IOState::INPUT_REQUIRED) ? NotInOutputExtStates(State_):
                                                          false);
}

/****************************************************************************/
bool CalcIoStateHandler::InEqvOutStates(int CalcState_, int State_) const
{
  return ((CalcState_ == Mcalc_IOState::OUTPUT_READY) ? NotInOutputStates(State_, true):
          (CalcState_ == Mcalc_IOState::PROCESS_DONE) ? NotInOutputStates(State_, true):
          (CalcState_ == Mcalc_IOState::CALC_RESPONSE) ? NotInProcessStates(State_, true):
          (CalcState_ == Mcalc_IOState::INPUT_REQUIRED) ? NotInOutputExtStates(State_, true):
                                                          false);
}

/****************************************************************************/
void CalcIoStateHandler::SetPrevIoState(int State_)
{
  _PrevIoState = State_;
}

/****************************************************************************/
// Methods for: Calc output process steps
/****************************************************************************/
bool CalcIoStateHandler::CalcOutputProcessDone(int* Totalp_, int* Donep_, bool ChkOnly_) const
{
  #if CALCLIB_DEBUG8c
    if (!ChkOnly_)
      _Parent->DbgPtr()->EnterLevel("CalcOutputProcessDone");
  #endif

  bool step1_ = CalcOutputSentDone();
  bool step2_ = (ChkOnly_ && !step1_) ? false:ClientAckToCalcOutput(false);

  if (Totalp_)
    *Totalp_ = 2;

  if (Donep_)
    *Donep_ = (step1_ && step2_) ? 2:
              (step1_ || step2_) ? 1:0;

  if (ChkOnly_)
    return (step1_ && step2_);

  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->ShowInt(step1_, "step1_");
    _Parent->DbgPtr()->ShowInt(step2_, "step2_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (step1_ && step2_);
}

/****************************************************************************/
void CalcIoStateHandler::ResetCalcOutputState()
{
  _ProcessStates[CALC_OUTPUT] = 0;
  _UnAckStates[CALC_OUTPUT] = 0;

  _ProcessTransition[CALC_OUTPUT] = 0;
  _UnAckTransition[CALC_OUTPUT] = 0;

  _PrevIoState = 0;
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneCalcOutputState()
{
  if (!CalcOutputProcessDone())
  {
    _CurrProcState |= IN_OUTPUT_PROCESS;
    SetCalcOutputSent(true);                                    // step 1

    if (CalcOutputSentDone() && !ClientAckToCalcOutput(true))
    {
      _UnAckStates[CALC_OUTPUT] = ACKNOWLEDGED;
      SetClientAckToCalcOutput(true);                           // step 2
      _CurrProcState &= ~IN_OUTPUT_PROCESS;
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputSentUnAcked(int State_, bool Ack_) const
{
  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->EnterLevel("CalcOutputSentUnAcked");
    ChrString StateStr_;
  #endif

  if (_Parent && _UnAckStates[CALC_OUTPUT] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);

    bool cond1_ = (CalcState_ == Mcalc_IOState::OUTPUT_READY ||
                   CalcState_ == Mcalc_IOState::CALC_RESPONSE ||
                   CalcState_ == Mcalc_IOState::PROCESS_DONE ||
                   CalcState_ == Mcalc_IOState::INPUT_REQUIRED) &&
                  (!State_ || NotInEqvOutStates(CalcState_, State_));
    bool cond2_ = (State_ == Mcalc_IOState::OUTPUT_READY ||
                   State_ == Mcalc_IOState::CALC_RESPONSE ||
                   State_ == Mcalc_IOState::PROCESS_DONE ||
                   State_ == Mcalc_IOState::INPUT_REQUIRED) &&
                  (!CalcState_ || NotInEqvOutStates(State_, CalcState_));

    int retval =
           (InOutputProcess() && (cond1_ || cond2_) &&
            (CalcOutputSentDone() && (Ack_ == ClientAckToCalcOutput(true))));

    _UnAckStates[CALC_OUTPUT] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if CALCLIB_DEBUG8c
      _Parent->DbgPtr()->EnterLevel("CalcOutputSentUnAcked...If(...)");
      _Parent->DbgPtr()->ShowInt(InOutputProcess(), "InOutputProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
      _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(CalcOutputSentDone(), "CalcOutputSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToCalcOutput(true), "ClientAckToCalcOutput(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_OUTPUT],
                                 "_UnAckStates[CALC_OUTPUT]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_OUTPUT],
                               "_UnAckStates[CALC_OUTPUT]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ ? (_UnAckStates[CALC_OUTPUT] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfCalcOutputProcess(int State_,
                                                       bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfCalcOutputProcess");
  #endif

  bool retval = false;

  if (_Parent)
  {
    bool InProc_ = InOutputProcess();
    bool Updated_ = false;
    bool EndProc_ = OutputProcessEnded();
    bool ResetCond_ = InEqvOutStates(_PrevIoState, State_) ||
                      ((State_ == Mcalc_IOState::OUTPUT_READY ||
                        State_ == Mcalc_IOState::CALC_RESPONSE ||
                        State_ == Mcalc_IOState::PROCESS_DONE ||
                        State_ == Mcalc_IOState::INPUT_REQUIRED) &&
                       (_PrevIoState != State_ &&
                        InEqvOutStates(State_, _PrevIoState)));

    #if CALCLIB_DEBUG8c
      _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
      _Parent->DbgPtr()->ShowInt(InProc_, "InOutputProcess()");
      _Parent->DbgPtr()->ShowInt(EndProc_, "OutputProcessEnded()");
    #endif

    if (!InProc_)
    {
      if (ResetCond_ && EndProc_)
      {
        ResetCalcOutputState();
        CalcOutputUpdate(State_, true, &Updated_);

        if (AckSet_)
          *AckSet_ = false;
      }
      else if (!InProc_ && !EndProc_ && CalcOutputSentDone())
      {
        SetInOutputProcess();
        Updated_ = true;
      }

      if (Updated_ && Ack_ && CalcOutputSentDone())
        retval = CalcOutputAck(State_, Ack_, AckSet_);
      else
        retval = false;
    }
  }

  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputAck(int State_, bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->EnterLevel("CalcOutputAck");
    ChrString StateStr_;
  #endif

  bool InProc_ = false;

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);

    bool cond1_ = ((CalcState_ == Mcalc_IOState::OUTPUT_READY ||
                    CalcState_ == Mcalc_IOState::PROCESS_DONE ||
                    CalcState_ == Mcalc_IOState::CALC_RESPONSE ||
                    CalcState_ == Mcalc_IOState::INPUT_REQUIRED) &&
                   InEqvOutStates(CalcState_, State_)) ||
                  ((State_ == Mcalc_IOState::PROCESS ||
                    State_ == Mcalc_IOState::INPUT_RECEIVED ||
                    State_ == Mcalc_IOState::PROCESS_DONE_ACK ||
                    State_ == Mcalc_IOState::OUTPUT_FETCHED) &&
                   (CalcState_ == State_ ||
                    (CalcState_ == Mcalc_IOState::PROCESS_DONE &&
                     State_ == Mcalc_IOState::PROCESS_DONE_ACK)));
    bool cond2_ = ((State_ == Mcalc_IOState::OUTPUT_READY ||
                    State_ == Mcalc_IOState::PROCESS_DONE ||
                    State_ == Mcalc_IOState::CALC_RESPONSE ||
                    State_ == Mcalc_IOState::PROCESS_DONE ||
                    State_ == Mcalc_IOState::INPUT_REQUIRED) &&
                   InEqvOutStates(State_, CalcState_)) ||
                  ((CalcState_ == Mcalc_IOState::PROCESS ||
                    CalcState_ == Mcalc_IOState::INPUT_RECEIVED ||
                    CalcState_ == Mcalc_IOState::PROCESS_DONE_ACK ||
                    CalcState_ == Mcalc_IOState::OUTPUT_FETCHED) &&
                   (CalcState_ == State_ ||
                    (State_ == Mcalc_IOState::PROCESS_DONE &&
                     CalcState_ == Mcalc_IOState::PROCESS_DONE_ACK)));
    InProc_ = InOutputProcess();

    #if CALCLIB_DEBUG8c
      _Parent->DbgPtr()->ShowInt(InProc_, "InOutputProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
      _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(CalcOutputSentDone(), "CalcOutputSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToCalcOutput(true), "ClientAckToCalcOutput(true)");
    #endif

    if (InProc_ && (cond1_ || cond2_) &&
        CalcOutputSentDone() && (Ack_ == !ClientAckToCalcOutput(true)))
    {
      _UnAckStates[CALC_OUTPUT] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToCalcOutput(Ack_);
      _CurrProcState &= ~IN_OUTPUT_PROCESS;
      InProc_ = false;

      if (AckSet_)
        *AckSet_ = true;

      #if CALCLIB_DEBUG8c
        _Parent->DbgPtr()->EnterLevel("CalcOutputAck...If(!ClientAckToCalcOutput())");
        _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
        _Parent->DbgPtr()->LeaveLevel();
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_OUTPUT],
                               "_UnAckStates[CALC_OUTPUT]");
    _Parent->DbgPtr()->ShowInt(_ProcessStates[CALC_OUTPUT],
                               "_ProcessStates[CALC_OUTPUT]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ == ClientAckToCalcOutput(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->EnterLevel("CalcOutputUpdate");
  #endif

  #if CALCLIB_DEBUG8c
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(CalcOutputSentDone(), "CalcOutputSentDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = (State_ == Mcalc_IOState::OUTPUT_READY ||
                 State_ == Mcalc_IOState::CALC_RESPONSE ||
                 State_ == Mcalc_IOState::PROCESS_DONE ||
                 State_ == Mcalc_IOState::INPUT_REQUIRED);
  bool cond2_ = (CalcState_ == Mcalc_IOState::OUTPUT_READY ||
                 CalcState_ == Mcalc_IOState::CALC_RESPONSE ||
                 CalcState_ == Mcalc_IOState::PROCESS_DONE ||
                 CalcState_ == Mcalc_IOState::INPUT_REQUIRED);

  if (!InOutputProcess() &&
      !OutputProcessEnded() && (cond1_ || cond2_) &&
      (Init_ == !CalcOutputSentDone()))
  {
    _CurrProcState |= IN_OUTPUT_PROCESS;
    SetCalcOutputSent(Init_);

    #if CALCLIB_DEBUG8c
      _Parent->DbgPtr()->ShowMessage("_CurrProcState |= IN_OUTPUT_PROCESS;\n");
      _Parent->DbgPtr()->ShowMessage("SetCalcOutputSent(true);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG8c
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return CalcOutputSentDone();
}

/****************************************************************************/
void CalcIoStateHandler::SetCalcOutputSent(bool flag_)
{
  if (InOutputProcess())
  {
    int Marked_ = (_ProcessStates[CALC_OUTPUT] & CALC_OUTPUT_SENT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_OUTPUT] |= CALC_OUTPUT_SENT;
        _ProcessTransition[CALC_OUTPUT] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_OUTPUT] &= ~CALC_OUTPUT_SENT;
        _ProcessTransition[CALC_OUTPUT] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputSentDone() const
{
  return (_ProcessStates[CALC_OUTPUT] & CALC_OUTPUT_SENT);
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToCalcOutput(bool flag_)
{
  if (InOutputProcess())
  {
    int Marked_ = (_ProcessStates[CALC_OUTPUT] & CLIENTACK_OUTPUT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_OUTPUT] |= CLIENTACK_OUTPUT;
        _UnAckTransition[CALC_OUTPUT] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_OUTPUT] &= ~CLIENTACK_OUTPUT;
        _UnAckTransition[CALC_OUTPUT] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToCalcOutput(bool InProc_) const
{
  return ((InProc_ == InOutputProcess()) &&
          _UnAckStates[CALC_OUTPUT] == ACKNOWLEDGED &&
          (_ProcessStates[CALC_OUTPUT] & CLIENTACK_OUTPUT));
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputSentTransition(bool Inverse_) const
{
  return (_UnAckStates[CALC_OUTPUT] == UNACKNOWLEDGED &&
          CalcOutputUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckCalcOutputTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[CALC_OUTPUT] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[CALC_OUTPUT] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::CalcOutputUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[CALC_OUTPUT] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[CALC_OUTPUT] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
// Methods for: Calc progress process steps
/****************************************************************************/
bool CalcIoStateHandler::CalcProgressProcessDone(int* Totalp_, int* Donep_, bool ChkOnly_) const
{
  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    if (!ChkOnly_)
      _Parent->DbgPtr()->EnterLevel("CalcProgressProcessDone");
  #endif

  bool step1_ = CalcProgressSentDone();
  bool step2_ = (ChkOnly_ && !step1_) ? false:ClientAckToCalcProgress(false);

  if (Totalp_)
    *Totalp_ = 2;

  if (Donep_)
    *Donep_ = (step1_ && step2_) ? 2:
              (step1_ || step2_) ? 1:0;

  if (ChkOnly_)
    return (step1_ && step2_);

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->ShowInt(step1_, "step1_");
    _Parent->DbgPtr()->ShowInt(step2_, "step2_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (step1_ && step2_);
}

/****************************************************************************/
void CalcIoStateHandler::ResetCalcProgressState()
{
  _ProcessStates[CALC_PROGRESS] = 0;
  _UnAckStates[CALC_PROGRESS] = 0;

  _ProcessTransition[CALC_PROGRESS] = 0;
  _UnAckTransition[CALC_PROGRESS] = 0;

  _PrevIoState = 0;
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneCalcProgressState()
{
  if (!CalcProgressProcessDone())
  {
    _CurrProcState |= IN_CALCPROGRESS_PROCESS;
    SetCalcProgressSent(true);                                  // step 1

    if (CalcProgressSentDone() && !ClientAckToCalcProgress(true))
    {
      _UnAckStates[CALC_PROGRESS] = ACKNOWLEDGED;
      SetClientAckToCalcProgress(true);                         // step 2
      _CurrProcState &= ~IN_CALCPROGRESS_PROCESS;
    }
  }
}

/****************************************************************************/
void CalcIoStateHandler::ResetProgressStates(int State_)
{
  bool cond1_ = State_ == Mcalc_IOState::PROGRESS_READY;
  bool precond_ = ProgressProcessEnded() && cond1_;

  if (precond_ &&
      CalcProgressSentDone() && ClientAckToCalcProgress(false))
  {
    SetCalcProgressSent(false);
    SetClientAckToCalcProgress(false);

    _UnAckStates[CALC_PROGRESS] = 0;
    _IterIndex++;
  }
  else if (!CalcProgressSentDone())
  {
    SetClientAckToCalcProgress(false);

    _UnAckStates[GRAPH_PROGRESS] = 0;
    _IterIndex = 0;
  }
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressSentUnAcked(int State_, bool Ack_) const
{
  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("CalcProgressSentUnAcked");
    ChrString StateStr_;
  #endif

  if (_Parent && _UnAckStates[CALC_PROGRESS] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = CalcState_ == Mcalc_IOState::PROGRESS_READY &&
                  (!State_ || State_ != Mcalc_IOState::INFILE_PROGRESS_ACK);
    bool cond2_ = State_ == Mcalc_IOState::PROGRESS_READY &&
                  (!CalcState_ || CalcState_ != Mcalc_IOState::INFILE_PROGRESS_ACK);

    int retval =
           (InCalcProgressProcess() && (cond1_ || cond2_) &&
            (CalcProgressSentDone() && (Ack_ == ClientAckToCalcProgress(true))));

    _UnAckStates[CALC_PROGRESS] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
      _Parent->DbgPtr()->EnterLevel("CalcProgressSentUnAcked...If(...)");
      _Parent->DbgPtr()->ShowInt(InCalcProgressProcess(), "InCalcProgressProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(CalcProgressSentDone(), "CalcProgressSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToCalcProgress(true), "ClientAckToCalcProgress(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_PROGRESS],
                                 "_UnAckStates[CALC_PROGRESS]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_PROGRESS],
                               "_UnAckStates[CALC_PROGRESS]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ ? (_UnAckStates[CALC_PROGRESS] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfCalcProgressProcess(int State_,
                                                         bool Ack_, bool* AckSet_)
{
  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfCalcProgressProcess");
  #endif

  bool retval = false;

  if (_Parent)
  {
    bool InProc_ = InCalcProgressProcess();
    bool Updated_ = false;
    bool EndProc_ = ProgressProcessEnded();
    bool ResetCond_ = State_ == Mcalc_IOState::INFILE_PROGRESS_ACK ||
                      (State_ == Mcalc_IOState::PROGRESS_READY &&
                       (_PrevIoState != State_ &&
                        _PrevIoState == Mcalc_IOState::INFILE_PROGRESS_ACK));

    #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
      _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
      _Parent->DbgPtr()->ShowInt(InProc_, "InCalcProgressProcess()");
      _Parent->DbgPtr()->ShowInt(EndProc_, "ProgressProcessEnded()");
    #endif

    if (!InProc_)
    {
      if (ResetCond_ && EndProc_)
      {
        ResetCalcProgressState();
        CalcProgressUpdate(State_, true, &Updated_);

        if (AckSet_)
          *AckSet_ = false;
      }
      else if (!InProc_ && !EndProc_ && CalcProgressSentDone())
      {
        SetInCalcProgressProcess();
        Updated_ = true;
      }

      if (Updated_ && Ack_ && CalcProgressSentDone())
        retval = CalcProgressAck(State_, Ack_, AckSet_);
      else
        retval = false;
    }
  }

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressAck(int State_, bool Ack_, bool* AckSet_)
{
  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("CalcProgressAck");
    ChrString StateStr_;
  #endif

  bool InProc_ = false;

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::PROGRESS_READY &&
                   State_ == Mcalc_IOState::INFILE_PROGRESS_ACK) ||
                  (State_ == Mcalc_IOState::INFILE_PROGRESS_ACK &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::PROGRESS_READY &&
                   CalcState_ == Mcalc_IOState::INFILE_PROGRESS_ACK) ||
                  (CalcState_ == Mcalc_IOState::INFILE_PROGRESS_ACK &&
                   CalcState_ == State_);
    InProc_ = InCalcProgressProcess();

    #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
      _Parent->DbgPtr()->ShowInt(InProc_, "InCalcProgressProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
      _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(CalcProgressSentDone(), "CalcProgressSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToCalcProgress(true), "ClientAckToCalcProgress(true)");
    #endif

    if (InProc_ && (cond1_ || cond2_) &&
        CalcProgressSentDone() && (Ack_ == !ClientAckToCalcProgress(true)))
    {
      _UnAckStates[CALC_PROGRESS] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToCalcProgress(Ack_);
      _CurrProcState &= ~IN_CALCPROGRESS_PROCESS;
      InProc_ = false;

      if (AckSet_)
        *AckSet_ = true;

      #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
        _Parent->DbgPtr()->EnterLevel("CalcProgressAck...If(!ClientAckToCalcProgress())");
        _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
        _Parent->DbgPtr()->LeaveLevel();
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->ShowInt(_UnAckStates[CALC_PROGRESS],
                               "_UnAckStates[CALC_PROGRESS]");
    _Parent->DbgPtr()->ShowInt(_ProcessStates[CALC_PROGRESS],
                               "_ProcessStates[CALC_PROGRESS]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ == ClientAckToCalcProgress(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressUpdate(int State_, bool Init_, bool* Updated_)
{
  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->EnterLevel("CalcProgressUpdate");
  #endif

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(CalcProgressSentDone(), "CalcProgressSentDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::PROGRESS_READY;
  bool cond2_ = CalcState_ == Mcalc_IOState::PROGRESS_READY;

  if (!InCalcProgressProcess() &&
      !ProgressProcessEnded() && (cond1_ || cond2_) &&
      (Init_ == !CalcProgressSentDone()))
  {
    _CurrProcState |= IN_CALCPROGRESS_PROCESS;
    SetCalcProgressSent(Init_);

    #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
      _Parent->DbgPtr()->ShowMessage("_CurrProcState |= IN_CALCPROGRESS_PROCESS;\n");
      _Parent->DbgPtr()->ShowMessage("SetCalcProgressSent(true);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG12b))
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return CalcProgressSentDone();
}

/****************************************************************************/
void CalcIoStateHandler::SetCalcProgressSent(bool flag_)
{
  if (InCalcProgressProcess())
  {
    int Marked_ = (_ProcessStates[CALC_PROGRESS] & CALC_PROGRESS_SENT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_PROGRESS] |= CALC_PROGRESS_SENT;
        _ProcessTransition[CALC_PROGRESS] = PROC_SIGNAL_SENT;

        _Parent->SetCalcProgressWasSent(true);
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_PROGRESS] &= ~CALC_PROGRESS_SENT;
        _ProcessTransition[CALC_PROGRESS] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressSentDone() const
{
  return (_ProcessStates[CALC_PROGRESS] & CALC_PROGRESS_SENT);
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToCalcProgress(bool flag_)
{
  if (InCalcProgressProcess())
  {
    int Marked_ = (_ProcessStates[CALC_PROGRESS] & CLIENTACK_CALCPROGRESS);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_PROGRESS] |= CLIENTACK_CALCPROGRESS;
        _UnAckTransition[CALC_PROGRESS] = ACK_SIGNAL_SENT;

        _Parent->SetClientAckedDoneToCalcProgress(true);
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_PROGRESS] &= ~CLIENTACK_CALCPROGRESS;
        _UnAckTransition[CALC_PROGRESS] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToCalcProgress(bool InProc_) const
{
  return ((InProc_ == InCalcProgressProcess()) &&
          _UnAckStates[CALC_PROGRESS] == ACKNOWLEDGED &&
          (_ProcessStates[CALC_PROGRESS] & CLIENTACK_CALCPROGRESS));
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressSentTransition(bool Inverse_) const
{
  return (_UnAckStates[CALC_PROGRESS] == UNACKNOWLEDGED &&
          CalcProgressUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckCalcProgressTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[CALC_PROGRESS] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[CALC_PROGRESS] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::CalcProgressUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[CALC_PROGRESS] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[CALC_PROGRESS] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
// Methods for: Calc spawn process steps
/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcProcessDone(int* Totalp_, int* Donep_, bool ChkOnly_) const
{
  #if CALCLIB_DEBUG8
    if (!ChkOnly_)
      _Parent->DbgPtr()->EnterLevel("SpawnCalcProcessDone");
  #endif

  bool step1_ = SpawnCalcSentDone();
  bool step2_ = (ChkOnly_ && !step1_) ? false:ClientAckToSpawnCalc(false);

  if (Totalp_)
    *Totalp_ = 2;

  if (Donep_)
    *Donep_ = (step1_ && step2_) ? 2:
              (step1_ || step2_) ? 1:0;

  if (ChkOnly_)
    return (step1_ && step2_);

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(step1_, "step1_");
    _Parent->DbgPtr()->ShowInt(step2_, "step2_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (step1_ && step2_);
}

/****************************************************************************/
void CalcIoStateHandler::ResetSpawnCalcState()
{
  _ProcessStates[SPAWN_CALC] = 0;
  _UnAckStates[SPAWN_CALC] = 0;

  _ProcessTransition[SPAWN_CALC] = 0;
  _UnAckTransition[SPAWN_CALC] = 0;

  _PrevIoState = 0;
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneSpawnCalcState()
{
  if (!SpawnCalcProcessDone())
  {
    _CurrProcState |= IN_CALCSPAWN_PROCESS;                     // step 1
    SetSpawnCalcSent(true);

    if (SpawnCalcSentDone() && !ClientAckToSpawnCalc(true))
    {
      _UnAckStates[SPAWN_CALC] = ACKNOWLEDGED;
      SetClientAckToSpawnCalc(true);                            // step 2
      _CurrProcState &= ~IN_CALCSPAWN_PROCESS;
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcSentUnAcked(int State_, bool Ack_) const
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("SpawnCalcSentUnAcked");
    ChrString StateStr_;
  #endif

  if (_Parent && _UnAckStates[SPAWN_CALC] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = CalcState_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
                  (!State_ || State_ != Mcalc_IOState::MCALC_SPAWNED);
    bool cond2_ = State_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
                  (!CalcState_ || CalcState_ != Mcalc_IOState::MCALC_SPAWNED);

    int retval =
           (InCalcSpawnProcess() && (cond1_ || cond2_) &&
            (SpawnCalcSentDone() && (Ack_ == ClientAckToSpawnCalc(true))));

    _UnAckStates[SPAWN_CALC] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if CALCLIB_DEBUG8
      _Parent->DbgPtr()->EnterLevel("SpawnCalcSentUnAcked...If(...)");
      _Parent->DbgPtr()->ShowInt(InCalcSpawnProcess(), "InCalcSpawnProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(SpawnCalcSentDone(), "SpawnCalcSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToSpawnCalc(true), "ClientAckToSpawnCalc(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[SPAWN_CALC],
                                 "_UnAckStates[SPAWN_CALC]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(_UnAckStates[SPAWN_CALC],
                               "_UnAckStates[SPAWN_CALC]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ ? (_UnAckStates[SPAWN_CALC] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfSpawnCalcProcess(int State_,
                                                      bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfSpawnCalcProcess");
  #endif

  bool retval = false;

  if (_Parent)
  {
    bool InProc_ = InCalcSpawnProcess();
    bool Updated_ = false;
    bool EndProc_ = SpawnCalcProcessEnded();
    bool ResetCond_ = State_ == Mcalc_IOState::MCALC_SPAWNED ||
                      (State_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
                       (_PrevIoState != State_ &&
                        _PrevIoState == Mcalc_IOState::MCALC_SPAWNED));

    #if CALCLIB_DEBUG8
      _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
      _Parent->DbgPtr()->ShowInt(InProc_, "InCalcSpawnProcess()");
      _Parent->DbgPtr()->ShowInt(EndProc_, "SpawnCalcProcessEnded()");
    #endif

    if (!InProc_)
    {
      if (ResetCond_ && EndProc_)
      {
        ResetSpawnCalcState();
        SpawnCalcUpdate(State_, true, &Updated_);

        if (AckSet_)
          *AckSet_ = false;
      }
      else if (!InProc_ && !EndProc_ && SpawnCalcSentDone())
      {
        SetInCalcSpawnProcess();
        Updated_ = true;
      }

      if (Updated_ && Ack_ && SpawnCalcSentDone())
        retval = SpawnCalcAck(State_, Ack_, AckSet_);
      else
        retval = false;
    }
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcAck(int State_, bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("SpawnCalcAck");
    ChrString StateStr_;
  #endif

  bool InProc_ = false;

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
                   State_ == Mcalc_IOState::MCALC_SPAWNED) ||
                  (State_ == Mcalc_IOState::MCALC_SPAWNED &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
                   CalcState_ == Mcalc_IOState::MCALC_SPAWNED) ||
                  (CalcState_ == Mcalc_IOState::MCALC_SPAWNED &&
                   CalcState_ == State_);
    InProc_ = InCalcSpawnProcess();

    #if CALCLIB_DEBUG8
      _Parent->DbgPtr()->ShowInt(InProc_, "InCalcSpawnProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
      _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(SpawnCalcSentDone(), "SpawnCalcSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToSpawnCalc(true), "ClientAckToSpawnCalc(true)");
    #endif

    if (InProc_ && (cond1_ || cond2_) &&
        SpawnCalcSentDone() && (Ack_ == !ClientAckToSpawnCalc(true)))
    {
      _UnAckStates[SPAWN_CALC] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToSpawnCalc(Ack_);
      _CurrProcState &= ~IN_CALCSPAWN_PROCESS;
      InProc_ = false;

      if (AckSet_)
        *AckSet_ = true;

      #if CALCLIB_DEBUG8
        _Parent->DbgPtr()->EnterLevel("SpawnCalcAck...If(!ClientAckToSpawnCalc())");
        _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
        _Parent->DbgPtr()->LeaveLevel();
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(_UnAckStates[SPAWN_CALC],
                               "_UnAckStates[SPAWN_CALC]");
    _Parent->DbgPtr()->ShowInt(_ProcessStates[SPAWN_CALC],
                               "_ProcessStates[SPAWN_CALC]");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Ack_ == ClientAckToSpawnCalc(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("SpawnCalcUpdate");
  #endif

  #if CALCLIB_DEBUG8
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(SpawnCalcSentDone(), "SpawnCalcSentDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::SPAWN_NEW_MCALC;
  bool cond2_ = CalcState_ == Mcalc_IOState::SPAWN_NEW_MCALC;

  if (!InCalcSpawnProcess() &&
      !SpawnCalcProcessEnded() && (cond1_ || cond2_) &&
      (Init_ == !SpawnCalcSentDone()))
  {
    _CurrProcState |= IN_CALCSPAWN_PROCESS;
    SetSpawnCalcSent(Init_);

    #if CALCLIB_DEBUG8
      _Parent->DbgPtr()->ShowMessage("_CurrProcState |= IN_CALCSPAWN_PROCESS;\n");
      _Parent->DbgPtr()->ShowMessage("SetSpawnCalcSent(true);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return SpawnCalcSentDone();
}

/****************************************************************************/
void CalcIoStateHandler::SetSpawnCalcSent(bool flag_)
{
  if (InCalcSpawnProcess())
  {
    int Marked_ = (_ProcessStates[SPAWN_CALC] & SPAWN_CALC_SENT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[SPAWN_CALC] |= SPAWN_CALC_SENT;
        _ProcessTransition[SPAWN_CALC] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[SPAWN_CALC] &= ~SPAWN_CALC_SENT;
        _ProcessTransition[SPAWN_CALC] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcSentDone() const
{
  return (_ProcessStates[SPAWN_CALC] & SPAWN_CALC_SENT);
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToSpawnCalc(bool flag_)
{
  if (InCalcSpawnProcess())
  {
    int Marked_ = (_ProcessStates[SPAWN_CALC] & CLIENTACK_SPAWN_CALC);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[SPAWN_CALC] |= CLIENTACK_SPAWN_CALC;
        _UnAckTransition[SPAWN_CALC] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[SPAWN_CALC] &= ~CLIENTACK_SPAWN_CALC;
        _UnAckTransition[SPAWN_CALC] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToSpawnCalc(bool InProc_) const
{
  return ((InProc_ == InCalcSpawnProcess()) &&
          _UnAckStates[SPAWN_CALC] == ACKNOWLEDGED &&
          (_ProcessStates[SPAWN_CALC] & CLIENTACK_SPAWN_CALC));
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcSentTransition(bool Inverse_) const
{
  return (_UnAckStates[SPAWN_CALC] == UNACKNOWLEDGED &&
          SpawnCalcUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckSpawnCalcTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[SPAWN_CALC] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[SPAWN_CALC] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::SpawnCalcUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[SPAWN_CALC] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[SPAWN_CALC] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
// Methods for: Calc error process steps
/****************************************************************************/
bool CalcIoStateHandler::ErrorProcessDone(int* Totalp_, int* Donep_, bool ChkOnly_) const
{
  bool step1_ = false;
  bool step2_ = false;
  bool step3_ = false;

  bool step1a_ = false;
  bool step2a_ = false;

  int Ending1_ = false;
  int Ending2_ = false;
  int Ending3_ = false;

  step1_ = FetchErrorsSentDone();
  step2_ = ClientAckToFetchErrors(true, false, false);
  step3_ = (ChkOnly_ && (!step1_ || !step2_)) ?
               false:ClientAckToCalcError(false);

  Ending1_ = (step1_ && step2_ && step3_);

  if (!Ending1_ && !step2_)
  {
    step1a_ = step1_ = FetchErrorsSentDone();
    step2a_ =
    step2_ = (ChkOnly_ && !step1_) ? false:ClientAckToCalcError(false);

    Ending2_ = (step1_ && step2_);

    if (Ending2_)
    {
      if (Totalp_)
        *Totalp_ = 2;

      if (Donep_)
        *Donep_ = 2;
    }
  }
  else
  {
    if (Totalp_)
      *Totalp_ = 3;

    if (Donep_)
    {
      *Donep_ = 0;

      if (step1_)
        (*Donep_)++;

      if (step2_)
        (*Donep_)++;

      if (step3_)
        (*Donep_)++;
    }
  }

  if (!Ending1_ && !Ending2_)
  {
    step1_ = CalcErrorSentDone(false);
    step2_ = (ChkOnly_ && !step1_) ? false:ClientAckToCalcError(false);

    Ending3_ = (step1_ && step2_);

    if (!Ending3_ && step1a_)
    {
      if (Totalp_)
        *Totalp_ = 2;

      if (Donep_)
        *Donep_ = (step1a_ && step2a_) ? 2:
                  (step1a_ || step2a_) ? 1:0;
    }
    else
    {
      if (Totalp_)
        *Totalp_ = 2;

      if (Donep_)
        *Donep_ = (step1_ && step2_) ? 2:
                  (step1_ || step2_) ? 1:0;
    }
  }

  return (Ending1_ || Ending2_ || Ending3_);
}

/****************************************************************************/
void CalcIoStateHandler::ResetErrorState()
{
  _ProcessStates[CALC_ERROR] = 0;
  _UnAckStates[CALC_ERROR] = 0;

  _ProcessTransition[CALC_ERROR] = 0;
  _UnAckTransition[CALC_ERROR] = 0;

  _PrevIoState = 0;
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcFetchErrorsSent_Helper(int State_, bool Ack_, Ushort Iter_) const
{
  if (_Parent && _UnAckStates[CALC_ERROR] != ACKNOWLEDGED)
  {
    bool SetByClient_ = Iter_ > 0;
    int ReqState_ = SetByClient_ ? Mcalc_IOState::CALC_ERROR:
                                   Mcalc_IOState::ERROR_FETCH;
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    int retval = 0;
    bool cond1_ = false;
    bool cond2_ = false;

    if (SetByClient_)
    {
      cond1_ = CalcState_ == ReqState_ &&
               (!State_ || NotInErrorStates(State_, !SetByClient_, SetByClient_));
      cond2_ = State_ == ReqState_ &&
               (!CalcState_ || NotInErrorStates(CalcState_, !SetByClient_, SetByClient_));

      retval = (InErrorProcess() && (cond1_ || cond2_) &&
                (CalcErrorSentDone(SetByClient_) && (Ack_ == ClientAckToCalcError(true))));
    }
    else
    {
      cond1_ = CalcState_ == ReqState_ &&
               (!State_ || NotInErrorStates(State_, !SetByClient_, SetByClient_));
      cond2_ = State_ == ReqState_ &&
               (!CalcState_ || NotInErrorStates(CalcState_, !SetByClient_, SetByClient_));

      retval = (InErrorProcess() && (cond1_ || cond2_) &&
                (FetchErrorsSentDone() && (Ack_ == ClientAckToFetchErrors(true, false, true))));
    }

    _UnAckStates[CALC_ERROR] = retval ? UNACKNOWLEDGED:NOT_SET;
    return retval;
  }

  return (Ack_ ? (_UnAckStates[CALC_ERROR] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcFirstFetchErrorsSentUnAcked(int State_, bool Ack_) const
{
  if (_Parent)
    return ErrProcFetchErrorsSent_Helper(State_, Ack_, 0);

  return false;
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcNextFetchErrorsSentUnAcked(int State_, bool Ack_) const
{
  if (_Parent)
    return ErrProcFetchErrorsSent_Helper(State_, Ack_, 1);

  return false;
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcCalcErrorSentUnAcked(int State_, bool Ack_) const
{
  if (_Parent && _UnAckStates[CALC_ERROR] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = CalcState_ == Mcalc_IOState::CALC_ERROR &&
                  (!State_ || NotInErrorStates(State_, false, false));
    bool cond2_ = State_ == Mcalc_IOState::CALC_ERROR &&
                  (!CalcState_ || NotInErrorStates(CalcState_, false, false));

    int retval = (InErrorProcess() && (cond1_ || cond2_) &&
                  (CalcErrorSentDone(false) && (Ack_ == ClientAckToCalcError(true))));

    _UnAckStates[CALC_ERROR] = retval ? UNACKNOWLEDGED:NOT_SET;
    return retval;
  }

  return (Ack_ ? (_UnAckStates[CALC_ERROR] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfErrorProcess(int State_,
                                                  bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfErrorProcess");
  #endif

  bool retval = false;

  if (_Parent)
  {
    bool InProc_ = InErrorProcess();
    bool Updated_ = false;
    bool EndProc_ = ErrorProcessEnded();
    bool ResetCond_ = State_ == Mcalc_IOState::PROCESS ||
                      (State_ == Mcalc_IOState::CALC_ERROR &&
                       (_PrevIoState != State_ &&
                        _PrevIoState == Mcalc_IOState::PROCESS));

    #if CALCLIB_DEBUG8
      _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
      _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(EndProc_, "GraphProcessEnded()");
    #endif

    if (!InProc_)
    {
      if (ResetCond_ && EndProc_)
      {
        ResetErrorState();
        ErrProcCalcErrorUpdate(State_, true, &Updated_);

        if (AckSet_)
          *AckSet_ = false;
      }
      else if (!InProc_ && !EndProc_ && CalcErrorSentDone(false))
      {
        SetInErrorProcess();
        Updated_ = true;
      }

      if (Updated_ && Ack_ && CalcErrorSentDone(false))
        retval = ErrProcCalcErrorAck(State_, Ack_, AckSet_);
      else
        retval = false;
    }
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcFetchErrorsAck(int State_, bool Ack_, bool* AckSet_)
{
  bool SetByClient_ = false;
  bool InProc_ = false;

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::ERROR_FETCH &&
                   (State_ == Mcalc_IOState::PROCESS ||
                    State_ == Mcalc_IOState::CALC_ERROR)) ||
                  ((State_ == Mcalc_IOState::PROCESS ||
                    State_ == Mcalc_IOState::CALC_ERROR) &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::ERROR_FETCH &&
                   (CalcState_ == Mcalc_IOState::PROCESS ||
                    CalcState_ == Mcalc_IOState::CALC_ERROR)) ||
                  ((CalcState_ == Mcalc_IOState::PROCESS ||
                    CalcState_ == Mcalc_IOState::CALC_ERROR) &&
                   CalcState_ == State_);
    InProc_ = InErrorProcess();

    if (InProc_ && (cond1_ || cond2_) &&
        FetchErrorsSentDone() && (Ack_ == !ClientAckToFetchErrors(true, true, true)))
    {
      _UnAckStates[CALC_ERROR] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetByClient_ = State_ == Mcalc_IOState::CALC_ERROR;
      SetClientAckToFetchErrors(Ack_, SetByClient_);

      if (!SetByClient_)
      {
        _CurrProcState &= ~IN_ERROR_PROCESS;
        InProc_ = false;
      }

      if (AckSet_)
        *AckSet_ = true;
    }
  }

  return (Ack_ == ClientAckToFetchErrors(true, true, InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcCalcErrorAck(int State_, bool Ack_, bool* AckSet_)
{
  bool InProc_ = false;

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::CALC_ERROR &&
                   State_ == Mcalc_IOState::PROCESS) ||
                  (State_ == Mcalc_IOState::PROCESS &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::CALC_ERROR &&
                   CalcState_ == Mcalc_IOState::PROCESS) ||
                  (CalcState_ == Mcalc_IOState::PROCESS &&
                   CalcState_ == State_);
    InProc_ = InErrorProcess();

    if (InProc_ && (cond1_ || cond2_) &&
        CalcErrorSentDone(false) && (Ack_ == !ClientAckToCalcError(true)))
    {
      _UnAckStates[CALC_ERROR] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToCalcError(Ack_);
      _CurrProcState &= ~IN_ERROR_PROCESS;
      InProc_ = false;

      if (AckSet_)
        *AckSet_ = true;
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  return (Ack_ == ClientAckToCalcError(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcFetchErrorsUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("ErrProcFetchErrorsUpdate");
  #endif

  #if CALCLIB_DEBUG8
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(FetchErrorsSentDone(), "FetchErrorsSentDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::ERROR_FETCH;
  bool cond2_ = CalcState_ == Mcalc_IOState::ERROR_FETCH;

  if ((cond1_ || cond2_) &&
      (Init_ == !FetchErrorsSentDone()))
  {
    _CurrProcState |= IN_ERROR_PROCESS;
    SetFetchErrorsSent(Init_);

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return FetchErrorsSentDone();
}

/****************************************************************************/
bool CalcIoStateHandler::ErrProcCalcErrorUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->EnterLevel("ErrProcCalcErrorUpdate");
  #endif

  #if CALCLIB_DEBUG8
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(CalcErrorSentDone(false), "CalcErrorSentDone(false)");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::CALC_ERROR;
  bool cond2_ = CalcState_ == Mcalc_IOState::CALC_ERROR;

  if (!InErrorProcess() &&
      !ErrorProcessEnded() && (cond1_ || cond2_) &&
      (Init_ == !CalcErrorSentDone(false)))
  {
    _CurrProcState |= IN_ERROR_PROCESS;
    SetCalcErrorSent(Init_, false);

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG8
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return FetchErrorsSentDone();
}

/****************************************************************************/
void CalcIoStateHandler::SetCalcErrorSent(bool flag_, bool SetByClient_)
{
  int SwitchValue_ = SetByClient_ ? CALC_ERROR_SETBYCLIENT:
                                    CALC_ERROR_SETBYCALC;

  if (InErrorProcess())
  {
    int Marked_ = (_ProcessStates[CALC_ERROR] & SwitchValue_);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_ERROR] |= SwitchValue_;
        _ProcessTransition[CALC_ERROR] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_ERROR] &= ~SwitchValue_;
        _ProcessTransition[CALC_ERROR] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::CalcErrorSentDone(bool SetByClient_) const
{
  int SwitchValue_ = SetByClient_ ? CALC_ERROR_SETBYCLIENT:
                                    CALC_ERROR_SETBYCALC;

  return (SetByClient_ ?
             (_ProcessStates[CALC_ERROR] & SwitchValue_):
             (_ProcessStates[CALC_ERROR] & SwitchValue_));
}

/****************************************************************************/
void CalcIoStateHandler::SetFetchErrorsSent(bool flag_)
{
  if (InErrorProcess())
  {
    int Marked_ = (_ProcessStates[CALC_ERROR] & FETCH_ERRORS_SENT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_ERROR] |= FETCH_ERRORS_SENT;
        _ProcessTransition[CALC_ERROR] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_ERROR] &= ~FETCH_ERRORS_SENT;
        _ProcessTransition[CALC_ERROR] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::FetchErrorsSentDone() const
{
  return (_ProcessStates[CALC_ERROR] & FETCH_ERRORS_SENT);
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToFetchErrors(bool flag_, bool SetByClient_)
{
  int SwitchValue_ = SetByClient_ ? CALC_ERROR_SETBYCLIENT:
                                    CLIENTACK_ERROR;

  if (InErrorProcess())
  {
    int Marked_ = (_ProcessStates[CALC_ERROR] & SwitchValue_);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_ERROR] |= SwitchValue_;
        _UnAckTransition[CALC_ERROR] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_ERROR] &= ~SwitchValue_;
        _UnAckTransition[CALC_ERROR] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToFetchErrors(bool SetByClient_,
                                                bool TestAltVal_, bool InProc_) const
{
  int SwitchValue_ = SetByClient_ ? CALC_ERROR_SETBYCLIENT:
                                    CLIENTACK_ERROR;
  int AltValue_ = SetByClient_ ? CLIENTACK_ERROR:
                                 CALC_ERROR_SETBYCLIENT;

  return ((InProc_ == InErrorProcess()) &&
          ((_ProcessStates[CALC_ERROR] & SwitchValue_) ||
           (TestAltVal_ && (_ProcessStates[CALC_ERROR] & AltValue_))));
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToCalcError(bool flag_)
{
  if (InErrorProcess())
  {
    int Marked_ = (_ProcessStates[CALC_ERROR] & CLIENTACK_ERROR);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[CALC_ERROR] |= CLIENTACK_ERROR;
        _UnAckTransition[CALC_ERROR] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[CALC_ERROR] &= ~CLIENTACK_ERROR;
        _UnAckTransition[CALC_ERROR] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToCalcError(bool InProc_) const
{
  return ((InProc_ == InErrorProcess()) &&
          _UnAckStates[CALC_ERROR] == ACKNOWLEDGED &&
          (_ProcessStates[CALC_ERROR] & CLIENTACK_ERROR));
}

/****************************************************************************/
bool CalcIoStateHandler::CalcErrorSentTransition(bool Inverse_) const
{
  return (_UnAckStates[CALC_ERROR] == UNACKNOWLEDGED &&
          CalcOutputUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckCalcErrorTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[CALC_ERROR] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[CALC_ERROR] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::CalcErrorUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[CALC_ERROR] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[CALC_ERROR] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
// Methods for: Graph process steps
/****************************************************************************/
bool CalcIoStateHandler::GraphBatchFileDone(bool* BatchFileEnded_,
                                            bool* BatchEndedAck_) const
{
  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->EnterLevel("GraphBatchFileDone");
  #endif

  bool Step1_ = _Parent->BatchFileEndedSignalSent();
  bool Step2_ = _Parent->BatchFileEndedSignalAcked();

  if (BatchFileEnded_)
    *BatchFileEnded_ = Step1_;

  if (BatchEndedAck_)
    *BatchEndedAck_ = Step2_;

  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (Step1_ && Step2_);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProcessDone_Main(int* Totalp_, int* Donep_,
                                               bool ChkOnly_, int Parts_) const
{
  #if CALCLIB_DEBUG11b
    if (!ChkOnly_)
      _Parent->DbgPtr()->EnterLevel("GraphProcessDone");
  #endif

  bool ResetCond_ = QuitGraph() &&
                    _Parent->QuitGraph() &&
                    _Parent->Exec_ResetGraphCond() &&
                    !_Parent->Exec_ResetGraphIsDone();

  int x;
  int max = Parts_;
  int done = 0;

  bool AllDone_ = false;
  static bool Steps_[] = { false, false, false,
                           false, false, false };

  ::memset(Steps_, 0, sizeof(bool) * max);

  if (Parts_ > 0)
  {
    Steps_[0] = ResponsePendingDone();
    Steps_[1] = (ChkOnly_ && !Steps_[0]) ?
                    false:ClientAckToGraphWait(true, true);

    if (Parts_ > 2)
    {
      Steps_[2] = (ChkOnly_ && (!Steps_[0] || !Steps_[1])) ?
                      false:GraphProgressSentDone();
      Steps_[3] = (ChkOnly_ && (!Steps_[0] ||
                                !Steps_[1] || !Steps_[2])) ?
                      false:ClientAckToGraphProgress(true, true);

      if (Parts_ > 4)
      {
        Steps_[4] = (ChkOnly_ && (!Steps_[0] || !Steps_[1])) ?
                        false:ResponseCompletedDone();
        Steps_[5] = (ChkOnly_ && (!Steps_[0] ||
                                  !Steps_[1] || !Steps_[4])) ?
                        false:ClientAckToGraphOutput(false);
      }
    }
  }

  #if CALCLIB_DEBUG11b
    if (ChkOnly_)
    {
      for (x = 0; x < max && (AllDone_=Steps_[x]); x++);
      done = x;
    }
    else
    {
      char buf[32];
      AllDone_ = max > 0;

      for (x = 0; x < max; x++)
      {
        AllDone_ = AllDone_ && Steps_[x];
        sprintf(buf, "Steps_[%d]", x);
        _Parent->DbgPtr()->ShowInt(Steps_[x], buf);

        if (Steps_[x])
          done++;
      }
    }
  #else
    for (x = 0; x < max && (AllDone_=Steps_[x]); x++);
    done = x;
  #endif

  if (Totalp_)
    *Totalp_ = max;

  if (Donep_)
    *Donep_ = done;

  #if CALCLIB_DEBUG11b
    if (!ChkOnly_)
      _Parent->DbgPtr()->LeaveLevel();
  #endif

  return (AllDone_ || ResetCond_);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProcessDone(int* Totalp_,
                                          int* Donep_, bool ChkOnly_) const
{
  return GraphProcessDone_Main(Totalp_, Donep_, ChkOnly_, 6);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphWaitProcessDone(int* Totalp_,
                                             int* Donep_, bool ChkOnly_) const
{
  return GraphProcessDone_Main(Totalp_, Donep_, ChkOnly_, 2);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressProcessDone(int* Totalp_,
                                                  int* Donep_, bool ChkOnly_) const
{
  return GraphProcessDone_Main(Totalp_, Donep_, ChkOnly_, 4);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphOutputProcessDone(int* Totalp_,
                                                int* Donep_, bool ChkOnly_) const
{
  return GraphProcessDone_Main(Totalp_, Donep_, ChkOnly_, 6);
}

/****************************************************************************/
void CalcIoStateHandler::ResetGraphState()
{
  bool InBatch_ = _Parent->InBatchFile(true);
  bool condquit_ = InBatch_ &&
                   _Parent->GraphFilePause() &&
                   _Parent->InputDataFileExecLock() != CalculatorBase::EXECFILE_LOCKED &&
                   (!_Parent->ExecInputFileData() || _Parent->AckPostExecInputFileData());

  _ProcessStates[GRAPH_PENDING] = 0;
  _ProcessStates[GRAPH_PROGRESS] = 0;
  _ProcessStates[GRAPH_OUTPUT] = 0;

  _UnAckStates[GRAPH_PENDING] = 0;
  _UnAckStates[GRAPH_PROGRESS] = 0;
  _UnAckStates[GRAPH_OUTPUT] = 0;

  _ProcessTransition[GRAPH_PENDING] = 0;
  _ProcessTransition[GRAPH_PROGRESS] = 0;
  _ProcessTransition[GRAPH_OUTPUT] = 0;

  _UnAckTransition[GRAPH_PENDING] = 0;
  _UnAckTransition[GRAPH_PROGRESS] = 0;
  _UnAckTransition[GRAPH_OUTPUT] = 0;

  _PrevIoState = 0;

  if (condquit_)
  {
    _Parent->Exec_ConfirmResetGraphDone();
    _QuitGraph = 0;
  }
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneGraphWaitState()
{
  if (!GraphWaitProcessDone() && _Plotter)
  {
    _CurrProcState |= IN_GRAPH_PROCESS;
    SetResponsePending(true);                                   // step 1

    if (ResponsePendingDone() && !ClientAckToGraphWait(true))
    {
      _UnAckStates[GRAPH_PENDING] = ACKNOWLEDGED;
      SetClientAckToGraphWait(true);                            // step 2
    }
  }
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneGraphProgressState()
{
  if (!GraphProgressProcessDone() && _Plotter)
  {
    _CurrProcState |= IN_GRAPH_PROCESS;
    SetResponsePending(true);                                   // step 1

    if (ResponsePendingDone() && !ClientAckToGraphWait(true))
    {
      _UnAckStates[GRAPH_PENDING] = ACKNOWLEDGED;
      SetClientAckToGraphWait(true);                            // step 2
    }

    if (!GraphProcessEnded() && InGraphProcess())
      SetGraphProgressSent(true);                               // step 3

    if (GraphProgressSentDone() && !ClientAckToGraphProgress(true))
    {
      _UnAckStates[GRAPH_PROGRESS] = ACKNOWLEDGED;
      SetClientAckToGraphProgress(true);                        // step 4
    }
  }
}

/****************************************************************************/
void CalcIoStateHandler::SetAllDoneGraphOutputState()
{
  if (!GraphOutputProcessDone() && _Plotter)
  {
    _CurrProcState |= IN_GRAPH_PROCESS;
    SetResponsePending(true);                                   // step 1

    if (ResponsePendingDone() && !ClientAckToGraphWait(true))
    {
      _UnAckStates[GRAPH_PENDING] = ACKNOWLEDGED;
      SetClientAckToGraphWait(true);                            // step 2
    }

    if (!GraphProcessEnded() && InGraphProcess())
      SetGraphProgressSent(true);                               // step 3

    if (GraphProgressSentDone() && !ClientAckToGraphProgress(true))
    {
      _UnAckStates[GRAPH_PROGRESS] = ACKNOWLEDGED;
      SetClientAckToGraphProgress(true);                        // step 4
    }

    if (!GraphProcessEnded() && InGraphProcess())
      SetResponseCompleted(true);                               // step 5

    if (ResponseCompletedDone() && !ClientAckToGraphOutput(true))
    {
      _UnAckStates[GRAPH_OUTPUT] = ACKNOWLEDGED;
      SetClientAckToGraphOutput(true);                          // step 6
      _CurrProcState &= ~IN_GRAPH_PROCESS;
    }
  }
}

/****************************************************************************/
void CalcIoStateHandler::SetGraphAltProc(int ProcName_,
                                         bool ProcMatch_, bool ForceState_) const
{
  _GraphAltProc = ProcName_;
  _ProcMatch = ProcMatch_;
  _ForceState = ProcMatch_ ? false:ForceState_;
  _QuitGraph = (!_ProcMatch && _GraphAltProc == pvGRAPH_QUIT);

  if (_QuitGraph && ResponsePendingDone() &&
      _ProcessStates[GRAPH_PENDING] == RESPONSE_PENDING)
    _ProcessStates[GRAPH_PENDING] = 0;
}

/****************************************************************************/
void CalcIoStateHandler::ClearGraphAltProc() const
{
  _GraphAltProc = 0;
  _ProcMatch = false;
  _ForceState = false;
}

/****************************************************************************/
void CalcIoStateHandler::RestoreGraphProgressStates()
{
  if (_PrevProgressDone)
  {
    SetGraphProgressSent(true);
    SetClientAckToGraphProgress(true);

    _PrevProgressDone = false;
    _IterIndex = 0;
  }
}

/****************************************************************************/
bool CalcIoStateHandler::InitialProgressStepNotDone(int State_) const
{
  return (State_ == Mcalc_IOState::GRAPH_PROGRESS &&
          !GraphProgressSentDone());
}

/****************************************************************************/
void CalcIoStateHandler::ResetGraphProgressStates(int State_, bool SavePrevState_)
{
  _Plotter = _Parent ? _Parent->GetGraphPlotter():NULL;

  bool cond1_ = State_ == Mcalc_IOState::GRAPH_PROGRESS;
  bool precond_ = (!GraphProcessEnded() || !SavePrevState_) &&
                  _Plotter && InGraphProcess() && cond1_;

  if (precond_ && !_Parent->GraphPlotShown() &&
      GraphProgressSentDone() && ClientAckToGraphProgress(true))
  {
    if (SavePrevState_)
      _PrevProgressDone = true;
    else
      _PrevProgressDone = false;

    SetGraphProgressSent(false);
    SetClientAckToGraphProgress(false);

    _UnAckStates[GRAPH_PROGRESS] = 0;
    _IterIndex++;
  }
  else if (_Parent->GraphPlotShown() || !GraphProgressSentDone())
  {
    SetClientAckToGraphProgress(false);

    _UnAckStates[GRAPH_PROGRESS] = 0;
    _PrevProgressDone = false;
    _IterIndex = 0;
  }
}

/****************************************************************************/
bool CalcIoStateHandler::GraphResponsePending(int State_, bool Ack_) const
{
  #if CALCLIB_DEBUG11b
    bool respnotdone_ = false;
    ChrString StateStr_;

    if (!ResponsePendingDone())
    {
      _Parent->DbgPtr()->EnterLevel("GraphResponsePending");
      respnotdone_ = true;
    }
  #endif

  if (_Parent && _UnAckStates[GRAPH_PENDING] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);

    bool InBatch_ = _Parent->InBatchFile(true);
    bool condquit_ = InBatch_ && _Parent->GraphFilePause() &&
                     (!_QuitGraph && !_Parent->Exec_ResetGraphIsDone()) &&
                     ((CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                       State_ == Mcalc_IOState::INPUT_RECEIVED) ||
                      (State_ == Mcalc_IOState::INPUT_RECEIVED &&
                       State_ == CalcState_));

    bool cond1_ = !condquit_ &&
                  CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                  (!State_ || State_ != Mcalc_IOState::GRAPH_WAIT_ACK);
    bool cond2_ = !condquit_ &&
                  State_ == Mcalc_IOState::GRAPH_WAIT &&
                  (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_WAIT_ACK);

    bool cond1gp_ = !condquit_ &&
                    CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                    (!State_ || State_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);
    bool cond2gp_ = !condquit_ &&
                    State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);

    bool cond1go_ = !condquit_ &&
                    CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                    (!State_ || State_ != Mcalc_IOState::OUTPUT_FETCHED);
    bool cond2go_ = !condquit_ &&
                    State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::OUTPUT_FETCHED);

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_RESPONSE_PENDING, true);
    else if (condquit_)
    {
      SetGraphAltProc(pvGRAPH_QUIT, false);
      #if CALCLIB_DEBUG11b
        if (respnotdone_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_QUIT...\n");
          _Parent->DbgPtr()->ShowInt(condquit_, "condquit_");
          StateStr_ = _Parent->GiveIoStateStr(CalcState_);
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
          StateStr_ = _Parent->GiveIoStateStr(State_);
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1gp_ || cond2gp_)
    {
      SetGraphAltProc(pvGRAPH_PROGRESS_SENT, false, cond1gp_);
      #if CALCLIB_DEBUG11b
        if (respnotdone_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_PROGRESS_SENT...\n");
          _Parent->DbgPtr()->ShowInt(cond1gp_, "cond1gp_");
          _Parent->DbgPtr()->ShowInt(cond2gp_, "cond2gp_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1go_ || cond2go_)
    {
      SetGraphAltProc(pvGRAPH_RESPONSE_COMPLETED, false, cond1go_);
      #if CALCLIB_DEBUG11b
        if (respnotdone_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_RESPONSE_COMPLETED...\n");
          _Parent->DbgPtr()->ShowInt(cond1go_, "cond1go_");
          _Parent->DbgPtr()->ShowInt(cond2go_, "cond2go_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }

    #if CALCLIB_DEBUG11b
      if (!respnotdone_)
        _Parent->DbgPtr()->EnterLevel("GraphResponsePending");
    #endif

    int retval =
           (_Parent->GetGraphPlotter() &&
            InGraphProcess() && (cond1_ || cond2_) &&
            (ResponsePendingDone() && (Ack_ == ClientAckToGraphWait(true))));

    _UnAckStates[GRAPH_PENDING] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->EnterLevel("GraphResponsePending...If(...)");
      _Parent->DbgPtr()->ShowInt(InBatch_, "InBatch_");
      _Parent->DbgPtr()->ShowInt(_Parent->WasInBatchDataInput(), "WasInBatchDataInput()");
      _Parent->DbgPtr()->ShowInt(_Parent->GraphFilePause(), "GraphFilePause()");

      _Parent->DbgPtr()->ShowInt(InGraphProcess(), "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(ResponsePendingDone(), "ResponsePendingDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphWait(true), "ClientAckToGraphWait(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PENDING],
                                 "_UnAckStates[GRAPH_PENDING]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG11b
    if (respnotdone_)
    {
      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PENDING],
                                 "_UnAckStates[GRAPH_PENDING]");
      _Parent->DbgPtr()->LeaveLevel();
    }
  #endif

  return (Ack_ ? (_UnAckStates[GRAPH_PENDING] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressSentUnAcked(int State_, bool Ack_) const
{
  #if CALCLIB_DEBUG11c
    bool prognotsent_ = false;
    ChrString StateStr_;

    if ((_IterIndex + 1) % 5 == 0)
    {
      _Parent->DbgPtr()->EnterLevel("GraphProgressSentUnAcked");
      prognotsent_ = true;
    }
  #endif

  if (_Parent && _UnAckStates[GRAPH_PROGRESS] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                  (!State_ || State_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);
    bool cond2_ = State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                  (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);

    bool cond1gw_ = CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                    (!State_ || State_ != Mcalc_IOState::GRAPH_WAIT_ACK);
    bool cond2gw_ = State_ == Mcalc_IOState::GRAPH_WAIT &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_WAIT_ACK);

    bool cond1go_ = CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                    (!State_ || State_ != Mcalc_IOState::OUTPUT_FETCHED);
    bool cond2go_ = State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::OUTPUT_FETCHED);

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_PROGRESS_SENT, true);
    else if (cond1gw_ || cond2gw_)
    {
      SetGraphAltProc(pvGRAPH_RESPONSE_PENDING, false, cond1gw_);
      #if CALCLIB_DEBUG11c
        if (prognotsent_ &&
            (_IterIndex + 1) % 5 == 0)
          _Parent->DbgPtr()->LeaveLevel();
      #endif
      return false;
    }
    else if (cond1go_ || cond2go_)
    {
      SetGraphAltProc(pvGRAPH_RESPONSE_COMPLETED, false, cond1go_);
      #if CALCLIB_DEBUG11c
        if (prognotsent_ &&
            (_IterIndex + 1) % 5 == 0)
          _Parent->DbgPtr()->LeaveLevel();
      #endif
      return false;
    }

    #if CALCLIB_DEBUG11b
      if (!prognotsent_ &&
          (_IterIndex + 1) % 5 == 0)
        _Parent->DbgPtr()->EnterLevel("GraphProgressSentUnAcked");
    #endif

    int retval =
           (_Parent->GetGraphPlotter() &&
            InGraphProcess() && (cond1_ || cond2_) &&
            (GraphProgressSentDone() && (Ack_ == ClientAckToGraphProgress(true))));

    _UnAckStates[GRAPH_PROGRESS] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if CALCLIB_DEBUG11c
      _Parent->DbgPtr()->EnterLevel("GraphProgressSentUnAcked...If(...)");
      _Parent->DbgPtr()->ShowInt(InGraphProcess(), "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(GraphProgressSentDone(), "GraphProgressSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphProgress(true), "ClientAckToGraphProgress(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PROGRESS],
                                 "_UnAckStates[GRAPH_PROGRESS]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG11c
    if (prognotsent_ &&
        (_IterIndex + 1) % 5 == 0)
    {
      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PROGRESS],
                                 "_UnAckStates[GRAPH_PROGRESS]");
      _Parent->DbgPtr()->LeaveLevel();
    }
  #endif

  return (Ack_ ? (_UnAckStates[GRAPH_PROGRESS] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphResponseCompleted(int State_, bool Ack_) const
{
  #if CALCLIB_DEBUG11b
    bool graphnotcomp_ = false;
    ChrString StateStr_;

    if (!ResponseCompletedDone())
    {
      _Parent->DbgPtr()->EnterLevel("GraphResponseCompleted");
      graphnotcomp_ = true;
    }
  #endif

  if (_Parent && _UnAckStates[GRAPH_OUTPUT] != ACKNOWLEDGED)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                  (!State_ || State_ != Mcalc_IOState::OUTPUT_FETCHED);
    bool cond2_ = State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                  (!CalcState_ || CalcState_ != Mcalc_IOState::OUTPUT_FETCHED);

    bool cond1gp_ = CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                    (!State_ || State_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);
    bool cond2gp_ = State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_PROGRESS_ACK);

    bool cond1gw_ = CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                    (!State_ || State_ != Mcalc_IOState::GRAPH_WAIT_ACK);
    bool cond2gw_ = State_ == Mcalc_IOState::GRAPH_WAIT &&
                    (!CalcState_ || CalcState_ != Mcalc_IOState::GRAPH_WAIT_ACK);

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_RESPONSE_COMPLETED, true);
    else if (cond1gw_ || cond2gw_)
    {
      SetGraphAltProc(pvGRAPH_RESPONSE_PENDING, false, cond1gw_);
      #if CALCLIB_DEBUG11b
        if (graphnotcomp_)
          _Parent->DbgPtr()->LeaveLevel();
      #endif
      return false;
    }
    else if (cond1gp_ || cond2gp_)
    {
      SetGraphAltProc(pvGRAPH_PROGRESS_SENT, false, cond1gp_);
      #if CALCLIB_DEBUG11b
        if (graphnotcomp_)
          _Parent->DbgPtr()->LeaveLevel();
      #endif
      return false;
    }

    #if CALCLIB_DEBUG11b
      if (!graphnotcomp_)
        _Parent->DbgPtr()->EnterLevel("GraphResponseCompleted");
    #endif

    int retval =
           (_Parent->GetGraphPlotter() &&
            InGraphProcess() && (cond1_ || cond2_) &&
            (ResponseCompletedDone() && (Ack_ == ClientAckToGraphOutput(true))));

    _UnAckStates[GRAPH_OUTPUT] = retval ? UNACKNOWLEDGED:NOT_SET;

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->EnterLevel("GraphResponseCompleted...If(...)");
      _Parent->DbgPtr()->ShowInt(InGraphProcess(), "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(ResponseCompletedDone(), "ResponseCompletedDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphOutput(true), "ClientAckToGraphOutput(true)");

      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_OUTPUT],
                                 "_UnAckStates[GRAPH_OUTPUT]");
      _Parent->DbgPtr()->LeaveLevel();
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG11b
    if (graphnotcomp_)
    {
      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_OUTPUT],
                                 "_UnAckStates[GRAPH_OUTPUT]");
      _Parent->DbgPtr()->LeaveLevel();
    }
  #endif

  return (Ack_ ? (_UnAckStates[GRAPH_OUTPUT] == ACKNOWLEDGED):false);
}

/****************************************************************************/
bool CalcIoStateHandler::ResetAtEndOfGraphProcess(int State_,
                                                  bool Ack_, bool* AckSet_)
{
  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->EnterLevel("ResetAtEndOfGraphProcess");
  #endif

  bool retval = false;

  if (_Parent)
  {
    bool InProc_ = InGraphProcess();
    bool Updated_ = false;
    bool EndProc_ = GraphProcessEnded();
    bool ResetCond_ = State_ == Mcalc_IOState::OUTPUT_FETCHED ||
                      (State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                       (_PrevIoState != State_ &&
                        _PrevIoState == Mcalc_IOState::OUTPUT_FETCHED));
    bool ResetCond2_ = QuitGraph() &&
                       _Parent->QuitGraph() &&
                       _Parent->Exec_ResetGraphCond() &&
                       !_Parent->Exec_ResetGraphIsDone();

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
      _Parent->DbgPtr()->ShowInt(ResetCond2_, "ResetCond2_");
      _Parent->DbgPtr()->ShowInt(_Parent->QuitGraph(), "QuitGraph()");
      _Parent->DbgPtr()->ShowInt(_Parent->Exec_ResetGraphCond(), "ResetGraphCond()");
      _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(EndProc_, "GraphProcessEnded()");
    #endif

    if (!InProc_)
    {
      if ((ResetCond_ || ResetCond2_) && EndProc_)
      {
        ResetGraphState();
        GraphWaitUpdate(State_, true, &Updated_);

        if (AckSet_)
          *AckSet_ = false;
      }
      else if (!InProc_ && !EndProc_ && ResponsePendingDone())
      {
        SetInGraphProcess();
        Updated_ = true;
      }

      if (Updated_ && Ack_ && ResponsePendingDone())
        retval = GraphWaitAck(State_, Ack_, AckSet_);
      else
        retval = false;
    }
  }

  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->ShowInt(_Parent->Exec_ResetGraphIsDone(), "ResetGraphIsDone()");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalcIoStateHandler::GraphWaitAck(int State_, bool Ack_, bool* AckSet_)
{
  bool InProc_ = false;

  #if CALCLIB_DEBUG11b
    bool lvlvl_ = false;
    bool dbgset_ = false;
    ChrString StateStr_;

    if (!ClientAckToGraphWait(InProc_))
    {
      _Parent->DbgPtr()->EnterLevel("GraphWaitAck");
      lvlvl_= true;
    }
  #endif

  if (_Parent)
  {
    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);

    bool InBatch_ = _Parent->InBatchFile(true);
    bool condquit_ = InBatch_ && _Parent->GraphFilePause() &&
                     (!_QuitGraph && !_Parent->Exec_ResetGraphIsDone()) &&
                     ((CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                       State_ == Mcalc_IOState::INPUT_RECEIVED) ||
                      (State_ == Mcalc_IOState::INPUT_RECEIVED &&
                       State_ == CalcState_));

    bool cond1_ = !condquit_ &&
                  ((CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                    State_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                   (State_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                    CalcState_ == State_));
    bool cond2_ = !condquit_ &&
                  ((State_ == Mcalc_IOState::GRAPH_WAIT &&
                    CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                   (CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                    CalcState_ == State_));

    bool cond1gp_ = !condquit_ &&
                    ((CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                      State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                     (State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                      CalcState_ == State_));

    bool cond2gp1a_ = !condquit_ &&
                      (CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                       (CalcState_ == State_ ||
                        State_ == Mcalc_IOState::GRAPH_OUTPUT));
    bool cond2gp_ = !condquit_ &&
                    ((State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                      CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                     cond2gp1a_);

    bool cond1go_ = !condquit_ &&
                    ((CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                      State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                     (State_ == Mcalc_IOState::OUTPUT_FETCHED &&
                      CalcState_ == State_));

    bool cond2go1a_ = !condquit_ &&
                      (CalcState_ == Mcalc_IOState::OUTPUT_FETCHED &&
                       (CalcState_ == State_ ||
                        CalculatorBase::IsServerStates(State_)));
    bool cond2go_ = !condquit_ &&
                    ((State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                      CalcState_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                     cond2go1a_);

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_WAIT_ACK, true);
    else if (condquit_)
    {
      SetGraphAltProc(pvGRAPH_QUIT, false);
      #if CALCLIB_DEBUG11b
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_QUIT...\n");
          _Parent->DbgPtr()->ShowInt(condquit_, "condquit_");
          StateStr_ = _Parent->GiveIoStateStr(CalcState_);
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
          StateStr_ = _Parent->GiveIoStateStr(State_);
          _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1gp_ || cond2gp_)
    {
      SetGraphAltProc(pvGRAPH_PROGRESS_ACK, false, cond2gp1a_);
      #if CALCLIB_DEBUG11b
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_PROGRESS_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1gp_, "cond1gp_");
          _Parent->DbgPtr()->ShowInt(cond2gp_, "cond2gp_");
          _Parent->DbgPtr()->ShowInt(cond2gp1a_, "cond2gp1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1go_ || cond2go_)
    {
      SetGraphAltProc(pvGRAPH_OUTPUT_ACK, false, cond2go1a_);
      #if CALCLIB_DEBUG11b
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_OUTPUT_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1go_, "cond1go_");
          _Parent->DbgPtr()->ShowInt(cond2go_, "cond2go_");
          _Parent->DbgPtr()->ShowInt(cond2go1a_, "cond2go1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }

    InProc_ = InGraphProcess();
    _Plotter = _Parent->GetGraphPlotter();

    #if CALCLIB_DEBUG11b
      if (!ClientAckToGraphWait(InProc_))
      {
        _Parent->DbgPtr()->ShowInt(InBatch_, "InBatch_");
        _Parent->DbgPtr()->ShowInt(_Parent->WasInBatchDataInput(), "WasInBatchDataInput()");
        _Parent->DbgPtr()->ShowInt(_Parent->GraphFilePause(), "GraphFilePause()");

        _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
        _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
        _Parent->DbgPtr()->ShowInt(_Plotter != NULL, "_Plotter != NULL");
        _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
        _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");

        StateStr_ = _Parent->GiveIoStateStr(CalcState_);
        _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
        StateStr_ = _Parent->GiveIoStateStr(State_);
        _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
        _Parent->DbgPtr()->ShowInt(ResponsePendingDone(), "ResponsePendingDone()");
        _Parent->DbgPtr()->ShowInt(ClientAckToGraphWait(true), "ClientAckToGraphWait(true)");
      }
    #endif

    if (_Plotter && InProc_ && (cond1_ || cond2_) &&
        ResponsePendingDone() && (Ack_ == !ClientAckToGraphWait(true)))
    {
      _UnAckStates[GRAPH_PENDING] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToGraphWait(Ack_);
      InProc_ = true;

      if (AckSet_)
        *AckSet_ = true;

      #if CALCLIB_DEBUG11b
        if (ClientAckToGraphWait(InProc_) && !dbgset_)
        {
          dbgset_ = true;
          _Parent->DbgPtr()->EnterLevel("GraphWaitAck...If(!ClientAckToGraphWait())");
          _Parent->DbgPtr()->ShowMessage("SetClientAckToGraphWait(Ack_);\n");
          _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
          _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PENDING], "_UnAckStates[GRAPH_PENDING]");
          _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if CALCLIB_DEBUG11b
    if (!ClientAckToGraphWait(InProc_) || dbgset_)
    {
      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PENDING],
                                 "_UnAckStates[GRAPH_PENDING]");
      _Parent->DbgPtr()->ShowInt(_ProcessStates[GRAPH_PENDING],
                                 "_ProcessStates[GRAPH_PENDING]");
      _Parent->DbgPtr()->ShowInt(InProc_, "InProc_");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphWait(InProc_),
                                 "ClientAckToGraphWait(InProc_)");
      _Parent->DbgPtr()->LeaveLevel();
    }
  #endif

  return (Ack_ == ClientAckToGraphWait(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressAck(int State_, bool Ack_, bool* AckSet_)
{
  bool InProc_ = InGraphProcess();

  #if CALCLIB_DEBUG11c
    bool dbgset_ = false;
    bool lvlvl_ = false;
    ChrString StateStr_;

    if (!ClientAckToGraphProgress(InProc_))
    {
      _Parent->DbgPtr()->EnterLevel("GraphProgressAck");
      lvlvl_ = true;
    }
  #endif

  InProc_ = false;

  if (_Parent)
  {
    InProc_ = InGraphProcess();
    bool retval = false;

    #if CALCLIB_DEBUG11c
    if (!ClientAckToGraphProgress(InProc_))
      _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
    #endif

    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                   State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                  (State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                   CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                  (CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                   CalcState_ == State_);

    bool cond1gw_ = (CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                     State_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                    (State_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                     CalcState_ == State_);

    bool cond2gw1a_ = (CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                       (CalcState_ == State_ ||
                        State_ == Mcalc_IOState::GRAPH_PROGRESS));
    bool cond2gw_ = (State_ == Mcalc_IOState::GRAPH_WAIT &&
                     CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                    cond2gw1a_;

    bool cond1go_ = (CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                     State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                    (State_ == Mcalc_IOState::OUTPUT_FETCHED &&
                     CalcState_ == State_);

    bool cond2go1a_ = (CalcState_ == Mcalc_IOState::OUTPUT_FETCHED &&
                       (CalcState_ == State_ ||
                        CalculatorBase::IsServerStates(State_)));
    bool cond2go_ = (State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                     CalcState_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                    cond2go1a_;

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_PROGRESS_ACK, true);
    else if (cond1gw_ || cond2gw_)
    {
      SetGraphAltProc(pvGRAPH_WAIT_ACK, false, cond2gw1a_);
      #if CALCLIB_DEBUG11c
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_WAIT_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1gw_, "cond1gw_");
          _Parent->DbgPtr()->ShowInt(cond2gw_, "cond2gw_");
          _Parent->DbgPtr()->ShowInt(cond2gw1a_, "cond2gw1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1go_ || cond2go_)
    {
      SetGraphAltProc(pvGRAPH_OUTPUT_ACK, false, cond2go1a_);
      #if CALCLIB_DEBUG11c
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_OUTPUT_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1go_, "cond1go_");
          _Parent->DbgPtr()->ShowInt(cond2go_, "cond2go_");
          _Parent->DbgPtr()->ShowInt(cond2go1a_, "cond2go1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }

    InProc_ = InGraphProcess();
    _Plotter = _Parent->GetGraphPlotter();

    #if CALCLIB_DEBUG11c
    if (!ClientAckToGraphProgress(InProc_))
    {
      _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
      _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
      _Parent->DbgPtr()->ShowInt(_Plotter != NULL, "_Plotter != NULL");
      _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
      _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");

      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->ShowInt(GraphProgressSentDone(), "GraphProgressSentDone()");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphProgress(true), "ClientAckToGraphProgress(true)");
    }
    #endif

    if (_Plotter && InProc_ && (cond1_ || cond2_) &&
        GraphProgressSentDone() && (Ack_ == !ClientAckToGraphProgress(true)))
    {
      _UnAckStates[GRAPH_PROGRESS] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToGraphProgress(Ack_);
      InProc_ = true;

      if (AckSet_)
        *AckSet_ = true;

      #if CALCLIB_DEBUG11c
      if (ClientAckToGraphProgress(InProc_) && !dbgset_)
      {
        dbgset_ = true;
        _Parent->DbgPtr()->EnterLevel("GraphProgressAck...If(!ClientAckToGraphProgress())");
        _Parent->DbgPtr()->ShowMessage("SetClientAckToGraphProgress(Ack_);\n");
        _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
        _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PROGRESS], "_UnAckStates[GRAPH_PROGRESS]");
        _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState");
        _Parent->DbgPtr()->LeaveLevel();
      }
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if CALCLIB_DEBUG11c
  if (!ClientAckToGraphProgress(InProc_) || dbgset_)
  {
    _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_PROGRESS],
                               "_UnAckStates[GRAPH_PROGRESS]");
    _Parent->DbgPtr()->ShowInt(_ProcessStates[GRAPH_PROGRESS],
                               "_ProcessStates[GRAPH_PROGRESS]");
    _Parent->DbgPtr()->ShowInt(InProc_, "InProc_");
    _Parent->DbgPtr()->ShowInt(ClientAckToGraphProgress(InProc_),
                               "ClientAckToGraphProgress(InProc_)");
    _Parent->DbgPtr()->LeaveLevel();
  }
  #endif

  return (Ack_ == ClientAckToGraphProgress(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphOutputAck(int State_, bool Ack_, bool* AckSet_)
{
  bool InProc_ = InGraphProcess();

  #if CALCLIB_DEBUG11b
    bool dbgset_ = false;
    bool lvlvl_ = false;
    ChrString StateStr_;

    if (!ClientAckToGraphOutput(InProc_))
    {
      _Parent->DbgPtr()->EnterLevel("GraphOutputAck");
      lvlvl_ = true;
    }
  #endif

  InProc_ = false;

  if (_Parent)
  {
    InProc_ = InGraphProcess();
    bool retval = false;

    #if CALCLIB_DEBUG11b
      if (!ClientAckToGraphOutput(InProc_))
        _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
    #endif

    int CalcState_ = _Parent->SetNoPolling(false)
                            ->Bare_GetIoState(0);
    bool cond1_ = (CalcState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                   State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                  (State_ == Mcalc_IOState::OUTPUT_FETCHED &&
                   CalcState_ == State_);
    bool cond2_ = (State_ == Mcalc_IOState::GRAPH_OUTPUT &&
                   CalcState_ == Mcalc_IOState::OUTPUT_FETCHED) ||
                  (CalcState_ == Mcalc_IOState::OUTPUT_FETCHED &&
                   CalcState_ == State_);

    bool cond1gp_ = (CalcState_ == Mcalc_IOState::GRAPH_PROGRESS &&
                     State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                    (State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                     CalcState_ == State_);

    bool cond2gp1a_ = (CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK &&
                       (CalcState_ == State_ ||
                        State_ == Mcalc_IOState::GRAPH_OUTPUT));
    bool cond2gp_ = (State_ == Mcalc_IOState::GRAPH_PROGRESS &&
                     CalcState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||
                    cond2gp1a_;

    bool cond1gw_ = (CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                     State_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                    (State_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                     CalcState_ == State_);

    bool cond2gw1a_ = (CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK &&
                       (CalcState_ == State_ ||
                        State_ == Mcalc_IOState::GRAPH_PROGRESS));
    bool cond2gw_ = (State_ == Mcalc_IOState::GRAPH_WAIT &&
                     CalcState_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
                    cond2gw1a_;

    if (cond1_ || cond2_)
      SetGraphAltProc(pvGRAPH_OUTPUT_ACK, true);
    else if (cond1gp_ || cond2gp_)
    {
      SetGraphAltProc(pvGRAPH_PROGRESS_ACK, false, cond2gp1a_);
      #if CALCLIB_DEBUG11b
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_PROGRESS_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1gp_, "cond1gp_");
          _Parent->DbgPtr()->ShowInt(cond2gp_, "cond2gp_");
          _Parent->DbgPtr()->ShowInt(cond2gp1a_, "cond2gp1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }
    else if (cond1gw_ || cond2gw_)
    {
      SetGraphAltProc(pvGRAPH_WAIT_ACK, false, cond2gw1a_);
      #if CALCLIB_DEBUG11b
        if (lvlvl_)
        {
          _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_WAIT_ACK...\n");
          _Parent->DbgPtr()->ShowInt(cond1gw_, "cond1gw_");
          _Parent->DbgPtr()->ShowInt(cond2gw_, "cond2gw_");
          _Parent->DbgPtr()->ShowInt(cond2gw1a_, "cond2gw1a_");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
      return false;
    }

    InProc_ = InGraphProcess();
    _Plotter = _Parent->GetGraphPlotter();

    #if CALCLIB_DEBUG11b
      if (!ClientAckToGraphOutput(InProc_))
      {
        _Parent->DbgPtr()->ShowInt(InProc_, "InGraphProcess()");
        _Parent->DbgPtr()->ShowInt(Ack_, "Ack_");
        _Parent->DbgPtr()->ShowInt(_Plotter != NULL, "_Plotter != NULL");
        _Parent->DbgPtr()->ShowInt(cond1_, "cond1_");
        _Parent->DbgPtr()->ShowInt(cond2_, "cond2_");

        StateStr_ = _Parent->GiveIoStateStr(CalcState_);
        _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
        StateStr_ = _Parent->GiveIoStateStr(State_);
        _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
        _Parent->DbgPtr()->ShowInt(ResponseCompletedDone(), "ResponseCompletedDone()");
        _Parent->DbgPtr()->ShowInt(ClientAckToGraphOutput(true), "ClientAckToGraphOutput(true)");
      }
    #endif

    if (_Plotter && InProc_ && (cond1_ || cond2_) && !GraphProcessEnded() &&
        ResponseCompletedDone() && (Ack_ == !ClientAckToGraphOutput(true)))
    {
      _UnAckStates[GRAPH_OUTPUT] = Ack_ ? ACKNOWLEDGED:UNACKNOWLEDGED;
      SetClientAckToGraphOutput(Ack_);
      _CurrProcState &= ~IN_GRAPH_PROCESS;
      InProc_ = false;

      if (AckSet_)
        *AckSet_ = true;

      #if CALCLIB_DEBUG11b
        if (ClientAckToGraphOutput(InProc_) && !dbgset_)
        {
          dbgset_ = true;
          _Parent->DbgPtr()->EnterLevel("GraphOutputAck...If(!ClientAckToGraphOutput())");
          _Parent->DbgPtr()->ShowMessage("SetClientAckToGraphOutput(Ack_);\n");
          _Parent->DbgPtr()->ShowInt(AckSet_ != NULL, "AckSet_");
          _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_OUTPUT], "_UnAckStates[GRAPH_OUTPUT]");
          _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState");
          _Parent->DbgPtr()->LeaveLevel();
        }
      #endif
    }

    if (_PrevIoState != CalcState_)
      SetPrevIoState(CalcState_);
  }

  #if CALCLIB_DEBUG11b
    if (!ClientAckToGraphOutput(InProc_) || dbgset_)
    {
      _Parent->DbgPtr()->ShowInt(_UnAckStates[GRAPH_OUTPUT],
                                 "_UnAckStates[GRAPH_OUTPUT]");
      _Parent->DbgPtr()->ShowInt(_ProcessStates[GRAPH_OUTPUT],
                                 "_ProcessStates[GRAPH_OUTPUT]");
      _Parent->DbgPtr()->ShowInt(InProc_, "InProc_");
      _Parent->DbgPtr()->ShowInt(ClientAckToGraphOutput(InProc_),
                                 "ClientAckToGraphOutput(InProc_)");
      _Parent->DbgPtr()->LeaveLevel();
    }
  #endif

  return (Ack_ == ClientAckToGraphOutput(InProc_));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphWaitUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->EnterLevel("GraphWaitUpdate");
  #endif

  #if CALCLIB_DEBUG11b
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(ResponsePendingDone(), "ResponsePendingDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  _Plotter = _Parent ? _Parent->GetGraphPlotter():NULL;

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool InBatch_ = _Parent->InBatchFile(true);
  bool condquit_ = InBatch_ && _Parent->GraphFilePause() &&
                   (!_QuitGraph && !_Parent->Exec_ResetGraphIsDone()) &&
                   ((CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                     State_ == Mcalc_IOState::INPUT_RECEIVED) ||
                    (State_ == Mcalc_IOState::INPUT_RECEIVED &&
                     State_ == CalcState_));

  bool condreset_ = InBatch_ && _Parent->GraphFilePause() &&
                    _Parent->Exec_ResetGraphIsDone() &&
                    (_CurrProcState & IN_GRAPH_PROCESS) &&
                    ((CalcState_ == Mcalc_IOState::GRAPH_WAIT &&
                      State_ == Mcalc_IOState::INPUT_RECEIVED) ||
                    (State_ == Mcalc_IOState::INPUT_RECEIVED &&
                     State_ == CalcState_));

  bool cond1_ = State_ == Mcalc_IOState::GRAPH_WAIT;
  bool cond2_ = CalcState_ == Mcalc_IOState::GRAPH_WAIT;

  bool cond1gp_ = State_ == Mcalc_IOState::GRAPH_PROGRESS;
  bool cond2gp_ = CalcState_ == Mcalc_IOState::GRAPH_PROGRESS;

  bool cond1go_ = State_ == Mcalc_IOState::GRAPH_OUTPUT;
  bool cond2go_ = CalcState_ == Mcalc_IOState::GRAPH_OUTPUT;

  if (cond1_ || cond2_)
    SetGraphAltProc(pvGRAPH_WAIT_UPDATE, true);
  else if (condquit_)
  {
    SetGraphAltProc(pvGRAPH_QUIT, false);
    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->ShowMessage("SetGraphAltProc(pvGRAPH_QUIT...\n");
      _Parent->DbgPtr()->ShowInt(condquit_, "condquit_");
      StateStr_ = _Parent->GiveIoStateStr(CalcState_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "CalcState_");
      StateStr_ = _Parent->GiveIoStateStr(State_);
      _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }
  else if (cond1gp_ || cond2gp_)
  {
    SetGraphAltProc(pvGRAPH_PROGRESS_UPDATE, false);
    #if CALCLIB_DEBUG11b
      if (!ResponsePendingDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }
  else if (cond1go_ || cond2go_)
  {
    SetGraphAltProc(pvGRAPH_OUTPUT_UPDATE, false);
    #if CALCLIB_DEBUG11b
      if (!ResponsePendingDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }

  if (_Plotter && !GraphProcessEnded() &&
      !condquit_ && !condreset_ &&
      !InGraphProcess() && (cond1_ || cond2_) &&
      (Init_ == !ResponsePendingDone()))
  {
    _CurrProcState |= IN_GRAPH_PROCESS;
    SetResponsePending(Init_);

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->ShowMessage("_CurrProcState |= IN_GRAPH_PROCESS;\n");
      _Parent->DbgPtr()->ShowMessage("SetResponsePending(true);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }
  else if (_Plotter && condreset_)
  {
    _CurrProcState &= ~IN_GRAPH_PROCESS;

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->ShowMessage("_CurrProcState &= ~IN_GRAPH_PROCESS;\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->ShowInt(ResponsePendingDone(), "ResponsePendingDone()(2)");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return ResponsePendingDone();
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG11c
    _Parent->DbgPtr()->EnterLevel("GraphProgressUpdate");
  #endif

  #if CALCLIB_DEBUG11c
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(GraphProgressSentDone(), "GraphProgressSentDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  _Plotter = _Parent ? _Parent->GetGraphPlotter():NULL;

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::GRAPH_PROGRESS;
  bool cond2_ = CalcState_ == Mcalc_IOState::GRAPH_PROGRESS;

  bool cond1gw_ = State_ == Mcalc_IOState::GRAPH_WAIT;
  bool cond2gw_ = CalcState_ == Mcalc_IOState::GRAPH_WAIT;

  bool cond1go_ = State_ == Mcalc_IOState::GRAPH_OUTPUT;
  bool cond2go_ = CalcState_ == Mcalc_IOState::GRAPH_OUTPUT;

  if (cond1_ || cond2_)
    SetGraphAltProc(pvGRAPH_PROGRESS_UPDATE, true);
  else if (cond1gw_ || cond2gw_)
  {
    SetGraphAltProc(pvGRAPH_WAIT_UPDATE, false);
    #if CALCLIB_DEBUG11c
      if (!GraphProgressSentDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }
  else if (cond1go_ || cond2go_)
  {
    SetGraphAltProc(pvGRAPH_OUTPUT_UPDATE, false);
    #if CALCLIB_DEBUG11c
      if (!GraphProgressSentDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }

  bool precond_ = _Plotter && !GraphProcessEnded() &&
                  InGraphProcess() && (cond1_ || cond2_);

  if (precond_ && (Init_ == !GraphProgressSentDone()))
  {
    SetGraphProgressSent(Init_);

    #if CALCLIB_DEBUG11c
      _Parent->DbgPtr()->ShowMessage("SetGraphProgressSent(Init_);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG11c
    _Parent->DbgPtr()->ShowInt(GraphProgressSentDone(), "GraphProgressSentDone()(2)");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return GraphProgressSentDone();
}

/****************************************************************************/
bool CalcIoStateHandler::GraphOutputUpdate(int State_, bool Init_, bool* Updated_)
{
  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->EnterLevel("GraphOutputUpdate");
  #endif

  #if CALCLIB_DEBUG11b
    ChrString StateStr_ = _Parent->GiveIoStateStr(State_);
    _Parent->DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    _Parent->DbgPtr()->ShowInt(Init_, "Init_");
    _Parent->DbgPtr()->ShowInt(ResponseCompletedDone(), "ResponseCompletedDone()");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(1)");
  #endif

  _Plotter = _Parent ? _Parent->GetGraphPlotter():NULL;

  int CalcState_ = _Parent->SetNoPolling(false)
                          ->Bare_GetIoState(0);

  bool cond1_ = State_ == Mcalc_IOState::GRAPH_OUTPUT;
  bool cond2_ = CalcState_ == Mcalc_IOState::GRAPH_OUTPUT;

  bool cond1gp_ = State_ == Mcalc_IOState::GRAPH_PROGRESS;
  bool cond2gp_ = CalcState_ == Mcalc_IOState::GRAPH_PROGRESS;

  bool cond1gw_ = State_ == Mcalc_IOState::GRAPH_WAIT;
  bool cond2gw_ = CalcState_ == Mcalc_IOState::GRAPH_WAIT;

  if (cond1_ || cond2_)
    SetGraphAltProc(pvGRAPH_OUTPUT_UPDATE, true);
  else if (cond1gp_ || cond2gp_)
  {
    SetGraphAltProc(pvGRAPH_PROGRESS_UPDATE, false);
    #if CALCLIB_DEBUG11b
      if (!ResponseCompletedDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }
  else if (cond1gw_ || cond2gw_)
  {
    SetGraphAltProc(pvGRAPH_WAIT_UPDATE, false);
    #if CALCLIB_DEBUG11b
      if (!ResponseCompletedDone())
        _Parent->DbgPtr()->LeaveLevel();
    #endif
    return false;
  }

  if (_Plotter && !GraphProcessEnded() &&
      InGraphProcess() && (cond1_ || cond2_) &&
      (Init_ == !ResponseCompletedDone()))
  {
    SetResponseCompleted(Init_);

    #if CALCLIB_DEBUG11b
      _Parent->DbgPtr()->ShowMessage("SetResponseCompleted(Init_);\n");
    #endif

    if (Updated_)
      *Updated_ = true;
  }

  #if CALCLIB_DEBUG11b
    _Parent->DbgPtr()->ShowInt(ResponseCompletedDone(), "ResponseCompletedDone()(2)");
    _Parent->DbgPtr()->ShowInt(_CurrProcState, "_CurrProcState(2)");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  if (_PrevIoState != CalcState_)
    SetPrevIoState(CalcState_);

  return ResponseCompletedDone();
}

/****************************************************************************/
void CalcIoStateHandler::SetResponsePending(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_PENDING] & RESPONSE_PENDING);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_PENDING] |= RESPONSE_PENDING;
        _ProcessTransition[GRAPH_PENDING] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_PENDING] &= ~RESPONSE_PENDING;
        _ProcessTransition[GRAPH_PENDING] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ResponsePendingDone() const
{
  return (_ProcessStates[GRAPH_PENDING] & RESPONSE_PENDING);
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToGraphWait(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_PENDING] & CLIENTACK_GRAPHWAIT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_PENDING] |= CLIENTACK_GRAPHWAIT;
        _UnAckTransition[GRAPH_PENDING] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_PENDING] &= ~CLIENTACK_GRAPHWAIT;
        _UnAckTransition[GRAPH_PENDING] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToGraphWait(bool InProc_, bool AllCases_) const
{
  if (AllCases_)
    InProc_ = true;

  bool precond_ = (InProc_ && !ClientAckToGraphOutput(false)) || !InProc_;
  bool retval = (precond_ && (InProc_ == InGraphProcess()) &&
                 _UnAckStates[GRAPH_PENDING] == ACKNOWLEDGED &&
                 (_ProcessStates[GRAPH_PENDING] & CLIENTACK_GRAPHWAIT));

  if (!retval && InProc_ && AllCases_)
    return ClientAckToGraphWait(false, false);

  return retval;
}

/****************************************************************************/
void CalcIoStateHandler::SetGraphProgressSent(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_PROGRESS] & GRAPH_PROGRESS_SENT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_PROGRESS] |= GRAPH_PROGRESS_SENT;
        _ProcessTransition[GRAPH_PROGRESS] = PROC_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_PROGRESS] &= ~GRAPH_PROGRESS_SENT;
        _ProcessTransition[GRAPH_PROGRESS] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressSentDone() const
{
  return ((InGraphProcess() || ClientAckToGraphOutput(false)) &&
          (_ProcessStates[GRAPH_PROGRESS] & GRAPH_PROGRESS_SENT));
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToGraphProgress(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_PROGRESS] & CLIENTACK_GRAPHPROGRESS);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_PROGRESS] |= CLIENTACK_GRAPHPROGRESS;
        _UnAckTransition[GRAPH_PROGRESS] = ACK_SIGNAL_SENT;
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_PROGRESS] &= ~CLIENTACK_GRAPHPROGRESS;
        _UnAckTransition[GRAPH_PROGRESS] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToGraphProgress(bool InProc_, bool AllCases_) const
{
  if (AllCases_)
    InProc_ = true;

  bool precond_ = (InProc_ && !ClientAckToGraphOutput(false)) || !InProc_;
  bool retval = (precond_ && (InProc_ == InGraphProcess()) &&
                 _UnAckStates[GRAPH_PROGRESS] == ACKNOWLEDGED &&
                 (_ProcessStates[GRAPH_PROGRESS] & CLIENTACK_GRAPHPROGRESS));

  if (!retval && InProc_ && AllCases_)
    return ClientAckToGraphProgress(false, false);

  return retval;
}

/****************************************************************************/
void CalcIoStateHandler::SetResponseCompleted(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_OUTPUT] & RESPONSE_COMPLETED);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_OUTPUT] |= RESPONSE_COMPLETED;
        _ProcessTransition[GRAPH_OUTPUT] = PROC_SIGNAL_SENT;

        _Parent->SetResponseWasCompleted(true);
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_OUTPUT] &= ~RESPONSE_COMPLETED;
        _ProcessTransition[GRAPH_OUTPUT] = PROC_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ResponseCompletedDone() const
{
  return ((InGraphProcess() || ClientAckToGraphOutput(false)) &&
          (_ProcessStates[GRAPH_OUTPUT] & RESPONSE_COMPLETED));
}

/****************************************************************************/
void CalcIoStateHandler::SetClientAckToGraphOutput(bool flag_)
{
  if (InGraphProcess())
  {
    int Marked_ = (_ProcessStates[GRAPH_OUTPUT] & CLIENTACK_GRAPHOUTPUT);

    if (flag_)
    {
      if (!Marked_)
      {
        _ProcessStates[GRAPH_OUTPUT] |= CLIENTACK_GRAPHOUTPUT;
        _UnAckTransition[GRAPH_OUTPUT] = ACK_SIGNAL_SENT;

        _Parent->SetClientAckedDoneToGraphOutput(true);
      }
    }
    else
    {
      if (Marked_)
      {
        _ProcessStates[GRAPH_OUTPUT] &= ~CLIENTACK_GRAPHOUTPUT;
        _UnAckTransition[GRAPH_OUTPUT] = ACK_SIGNAL_REMOVED;
      }
    }
  }
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckToGraphOutput(bool InProc_) const
{
  return ((InProc_ == InGraphProcess()) &&
          _UnAckStates[GRAPH_OUTPUT] == ACKNOWLEDGED &&
          (_ProcessStates[GRAPH_OUTPUT] & CLIENTACK_GRAPHOUTPUT));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphWaitSentTransition(bool Inverse_) const
{
  return (_UnAckStates[GRAPH_PENDING] == UNACKNOWLEDGED &&
          GraphWaitUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressSentTransition(bool Inverse_) const
{
  return (_UnAckStates[GRAPH_PROGRESS] == UNACKNOWLEDGED &&
          GraphProgressUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::GraphOutputSentTransition(bool Inverse_) const
{
  return (_UnAckStates[GRAPH_OUTPUT] == UNACKNOWLEDGED &&
          GraphOutputUpdateTransition(Inverse_));
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckGraphWaitTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[GRAPH_PENDING] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[GRAPH_PENDING] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckGraphProgressTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[GRAPH_PROGRESS] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[GRAPH_PROGRESS] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::ClientAckGraphOutputTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_UnAckTransition[GRAPH_OUTPUT] == ACK_SIGNAL_REMOVED);
  else
    return (_UnAckTransition[GRAPH_OUTPUT] == ACK_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphWaitUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[GRAPH_PENDING] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[GRAPH_PENDING] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphProgressUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[GRAPH_PROGRESS] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[GRAPH_PROGRESS] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
bool CalcIoStateHandler::GraphOutputUpdateTransition(bool Inverse_) const
{
  if (Inverse_)
    return (_ProcessTransition[GRAPH_OUTPUT] == PROC_SIGNAL_REMOVED);
  else
    return (_ProcessTransition[GRAPH_OUTPUT] == PROC_SIGNAL_SENT);
}

/****************************************************************************/
// Mock up test ServerPollingMgr class
//
#if CALCLIB_TESTMOCKCLIENT
  #include "mockclient.cpp"
#endif

/****************************************************************************/
// async mode server/client polling scheme:
//
// 0. inital file states
//
//    client alive file: IDLE
//    poll state file: IDLE
//    server alive file: IDLE
//
// 1. server-to-client
//
// 1a. i: check for server states in iostate file.
//     ii: check poll state file for IDLE state.
//     iii: check client alive file for IDLE state.
//     proceeed if conditions at i, ii and iii is true.
//     send polling signal to client
//
// 1b. client alive file:  IDLE
//     poll state file: SERVER_TO_CLIENT\n (cycle number)
//     server alive file: POLL_CLIENTALIVE\n (cycle number)
//
// 2. client receives server poll signal
//
// 2a. check for server states in iostate file, proceed if server states confirmed:
//     send back client alive signal
//
// 2b. client alive file: CLIENT_ALIVE\n (cycle number from server)
//     poll state file: CLIENT_RESPONSE
//     server alive file: POLL_CLIENTALIVE
//
// 3. server receives client alive signal and sends back acknowledgement
//    send back server acknowledged signal
//
// 3a. client alive file: CLIENT_ALIVE
//     poll state file: SERVER_TO_CLIENT
//     server alive file: SERVER_ACKNOWLEDGED\n (cycle number)
//
// 4. client receives server acknowledgement and sends reset polling timer signal
//    send back polling timer reset signal
//
// 4a. client resets own no-activity polling timer
//
// 4b. client alive file: RESET_POLLING\n (cycle number)
//     poll state file: CLIENT_RESPONSE
//     server alive file: SERVER_ACKNOWLEDGED
//
// 5. server receives reset polling timer signal and resets all polling timers (if timers exist)
//    Sets poll state file to IDLE state. Sets server alive file to IDLE state.
//
// 5a. server resets polling timer, server resets no-activity timer (if timers exist)
//
// 5b. client alive file: RESET_POLLING
//     poll state file: IDLE
//     server alive file: IDLE
//
// 6. client-to-server
//
// 6a. i: check for client states in iostate file.
//     ii: check poll state file for IDLE state.
//     iii: check server alive file for IDLE state.
//     proceeed if conditions at i, ii and iii is true.
//     send polling signal to server
//
// 6b. client alive file:  POLL_SERVERALIVE\n (cycle number)
//     poll state file: CLIENT_TO_SERVER\n (cycle number)
//     server alive file: IDLE
//
// 7. server receives client poll signal
//
// 7a. check for client states in iostate file, proceed if client states confirmed:
//     send back server alive signal
//
// 7b. client alive file: POLL_SERVERALIVE
//     poll state file: SERVER_RESPONSE
//     server alive file: SERVER_ALIVE\n (cycle number from client)
//
// 8. client receives server alive signal and sends back acknowledgement
//    send back client acknowledged signal
//
// 8a. client alive file: CLIENT_ACKNOWLEDGED\n (cycle number)
//     poll state file: CLIENT_TO_SERVER
//     server alive file: SERVER_ALIVE
//
// 9. server receives client acknowledgement and sends reset polling timer signal
//    send back polling timer reset signal
//
// 9a. server resets own no-activity polling timer (if timer exists)
//
// 9b. client alive file: CLIENT_ACKNOWLEDGED
//     poll state file: SERVER_RESPONSE
//     server alive file: RESET_POLLING\n (cycle number)
//
// 10. client receives reset polling timer signal and resets all polling timers
//     Sets poll state file to IDLE state. Sets client alive file to IDLE state.
//
// 10a. client resets polling timer, client resets no-activity timer
//
// 10b. client alive file: IDLE
//      poll state file: IDLE
//      server alive file: RESET_POLLING
//
/****************************************************************************/
// ClientPollingMgr class definitions
/****************************************************************************/
ClientPollingMgr::ClientPollingMgr(CalculatorBase* Parent_, bool CreateBackup_):
_Parent(Parent_),
_StrBuffer(::new_char_array(BUFSIZE, NULL)),

_CycleNum(0),
_CycleActive(false),
_RetrievedCycle(0),

_ClientPollProcess(0),
_ServerPollProcess(0),
_PrevClientProcess(0),
_PrevServerProcess(0),

_RetryReadCount(0),
_RetryPollCount(0),
_PollState(0),
_ServerState(0),
_ClientState(0),
_RdServerPoll(true),

_AllowPollClient(false),
_SleepWaiting(false),
_ResetStatesOnDone(false),
_BreakOnPollError(false),
_KeepAlivePollError(false),
_ConfirmedClientAlive(true),
_ConfirmedServerAlive(true),
_ClientAliveConfSent(false),

_AsyncMode(Parent_ ? (Parent_->InAsyncMode() ||
                      Parent_->SessionOption()):false),
_ExitAtRetryMax(false),
_StopTracking(false),
_WaitUntilResponse(false),
_PausePollResults(false),
_ResetWhenNotReq(false),
_ForceReset(false),

#if CALCLIB_DEBUG9
  _Backup(CreateBackup_ ? (new ClientPollingMgr(Parent_, false)):NULL)
#else
  _Backup(NULL)
#endif
{}

/****************************************************************************/
ClientPollingMgr::~ClientPollingMgr()
{
  _Parent->ClosePollStateFile();
  _Parent->CloseClientAliveFile();
  _Parent->CloseServerAliveFile();

  ::RawDeleteArray(_StrBuffer);
  _StrBuffer = NULL;

  if (_Backup)
  {
    delete _Backup;
    _Backup = NULL;
  }
}

/****************************************************************************/
ClientPollingMgr& ClientPollingMgr::operator = (const ClientPollingMgr& Obj_)
{
  if (&Obj_ != this)
  {
    strcpy(_StrBuffer, Obj_._StrBuffer);

    _CycleNum = Obj_._CycleNum;
    _CycleActive = Obj_._CycleActive;
    _RetrievedCycle = Obj_._RetrievedCycle;

    _ClientPollProcess = Obj_._ClientPollProcess;
    _ServerPollProcess = Obj_._ServerPollProcess;
    _PrevClientProcess = Obj_._PrevClientProcess;
    _PrevServerProcess = Obj_._PrevServerProcess;

    _RetryReadCount = Obj_._RetryReadCount;
    _RetryPollCount = Obj_._RetryPollCount;
    _PollState = Obj_._PollState;
    _ServerState = Obj_._ServerState;
    _ClientState = Obj_._ClientState;

    _AllowPollClient = Obj_._AllowPollClient;
    _SleepWaiting = Obj_._SleepWaiting;
    _ResetStatesOnDone = Obj_._ResetStatesOnDone;
    _BreakOnPollError = Obj_._BreakOnPollError;
    _KeepAlivePollError = Obj_._KeepAlivePollError;
    _ConfirmedClientAlive = Obj_._ConfirmedClientAlive;
    _ConfirmedServerAlive = Obj_._ConfirmedServerAlive;
    _ClientAliveConfSent = Obj_._ClientAliveConfSent;

    _AsyncMode = Obj_._AsyncMode;
    _ExitAtRetryMax = Obj_._ExitAtRetryMax;
    _StopTracking = Obj_._StopTracking;
    _WaitUntilResponse = Obj_._WaitUntilResponse;
    _PausePollResults = Obj_._PausePollResults;

    _ResetWhenNotReq = Obj_._ResetWhenNotReq;
    _ForceReset = Obj_._ForceReset;
  }

  return *this;
}

/****************************************************************************/
const char* ClientPollingMgr::KeepAliveStateToStr(int State_)
{
  return
  (
    (State_ == Mcalc_KeepAliveState::IDLE)                ? "IDLE":
    (State_ == Mcalc_KeepAliveState::RESET_POLLING)       ? "RESET_POLLING":

    (State_ == Mcalc_KeepAliveState::POLL_SERVERALIVE)    ? "POLL_SERVERALIVE":
    (State_ == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED) ? "CLIENT_ACKNOWLEDGED":
    (State_ == Mcalc_KeepAliveState::CLIENT_ALIVE)        ? "CLIENT_ALIVE":

    (State_ == Mcalc_KeepAliveState::POLL_CLIENTALIVE)    ? "POLL_CLIENTALIVE":
    (State_ == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED) ? "SERVER_ACKNOWLEDGED":
    (State_ == Mcalc_KeepAliveState::SERVER_ALIVE)        ? "SERVER_ALIVE":""
  );
}

/****************************************************************************/
const char* ClientPollingMgr::PollStateToStr(int State_)
{
  return
  (
    (State_ == Mcalc_PollState::IDLE)             ? "IDLE":
    (State_ == Mcalc_PollState::SERVER_TO_CLIENT) ? "SERVER_TO_CLIENT":
    (State_ == Mcalc_PollState::CLIENT_RESPONSE)  ? "CLIENT_RESPONSE":
    (State_ == Mcalc_PollState::CLIENT_TO_SERVER) ? "CLIENT_TO_SERVER":
    (State_ == Mcalc_PollState::SERVER_RESPONSE)  ? "SERVER_RESPONSE":""
  );
}

/****************************************************************************/
void ClientPollingMgr::ResetPollResults(bool& PollingClient_,
                                        bool& PollError_,
                                        bool& PollAnswered_)
{
  PollingClient_ = false;
  PollAnswered_ = false;
  PollError_ = false;
}

/****************************************************************************/
void ClientPollingMgr::ShowPollResults(bool PollingClient_,
                                       bool PollError_,
                                       bool PollAnswered_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ShowPollResults");
  #endif

  #if CALCLIB_DEBUG9
    #if CALCLIB_ERROR_SHOWTEXT
      cerr <<"Polling Client: " <<PollingClient_ <<endl
           <<"Poll Answered: " <<PollAnswered_ <<endl
           <<"Poll Error: " <<PollError_ <<endl;

      if (_PausePollResults)
        cin.get();
    #else
      _Parent->DbgPtr()->ShowInt(PollingClient_, "PollingClient_");
      _Parent->DbgPtr()->ShowInt(PollAnswered_, "PollAnswered_");
      _Parent->DbgPtr()->ShowInt(PollError_, "PollError_");
    #endif

    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void ClientPollingMgr::GivePollResults(bool& PollingClient_,
                                       bool& PollError_,
                                       bool& PollAnswered_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("GivePollResults");
  #endif

  if (!PollError_)
    PollingClient_ = ServerIsPolling() && PollClientInProcess();

  if (!PollingClient_)
    PollAnswered_ = _ConfirmedClientAlive &&
                    (PollClientInProcess() || PollClientCompleted(false));

  if (!PollingClient_ && !PollAnswered_)
    PollError_ = _KeepAlivePollError && _RetryPollCount > 0 &&
                 PollClientInProcess();

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(PollingClient_, "PollingClient_");
    _Parent->DbgPtr()->ShowInt(PollAnswered_, "PollAnswered_");
    _Parent->DbgPtr()->ShowInt(PollError_, "PollError_");

    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetSleepWaiting(bool flag_)
{
  _SleepWaiting = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetResetStatesOnDone(bool flag_)
{
  _ResetStatesOnDone = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetAllowClientPolling(bool flag_)
{
  _AllowPollClient = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetBreakOnPollError(bool flag_)
{
  _BreakOnPollError = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetExitAtRetryMax(bool flag_)
{
  _ExitAtRetryMax = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetWaitUntilResponse(bool flag_)
{
  _WaitUntilResponse = flag_;
  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetStopTracking(bool flag_)
{
  _StopTracking = flag_;

  #if CALCLIB_DEBUGGING
    if (_Parent && _Parent->DbgPtr())
    {
      _Parent->DbgPtr()->SetStopTracking(CalculatorBase::CLIENTPOLLINGMGR, flag_);

      if (flag_)
        _Parent->DbgPtr()->SetTrackType(CalculatorBase::CLIENTPOLLINGMGR);
      else
        _Parent->DbgPtr()->SetTrackType(0);
    }
  #endif

  if (_Backup)
    _Backup->SetStopTracking(flag_);

  return this;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::SetPausePollResults(bool flag_)
{
  _PausePollResults = flag_;
  return this;
}

/****************************************************************************/
bool ClientPollingMgr::PausePollResults() const
{
  return _PausePollResults;
}

/****************************************************************************/
bool ClientPollingMgr::StopTracking() const
{
  return _StopTracking;
}

/****************************************************************************/
bool ClientPollingMgr::ClientIsPolling() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ClientIsPolling");
    bool retval = ((_PollState == Mcalc_PollState::CLIENT_TO_SERVER ||
                    _PollState == Mcalc_PollState::SERVER_RESPONSE) &&
                   _ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE);

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return ((_PollState == Mcalc_PollState::CLIENT_TO_SERVER ||
             _PollState == Mcalc_PollState::SERVER_RESPONSE) &&
            _ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ServerIsAlive() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ServerIsAlive");
    bool ClientAcked_ = ClientAcked();
    bool retval = ((_PollState == Mcalc_PollState::SERVER_RESPONSE ||
                   ClientAcked_) &&
                   _ServerState == Mcalc_KeepAliveState::SERVER_ALIVE &&
                   _RetrievedCycle == _CycleNum);

    retval = retval || ClientAcked_;
    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();

    return retval;
  #else
    bool ClientAcked_ = ClientAcked();
    bool retval = ((_PollState == Mcalc_PollState::SERVER_RESPONSE ||
                   ClientAcked_) &&
                   _ServerState == Mcalc_KeepAliveState::SERVER_ALIVE &&
                   _RetrievedCycle == _CycleNum);

    retval = retval || ClientAcked_;
    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ClientAcked() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ClientAcked");
    bool cond1 = ((_PollState == Mcalc_PollState::CLIENT_TO_SERVER ||
                   _PollState == Mcalc_PollState::SERVER_RESPONSE) &&
                  _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED &&
                  _RetrievedCycle == _CycleNum);
    bool cond2 = ((_PollState == Mcalc_PollState::SERVER_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE) &&
                  _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED &&
                  _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool retval = cond1 || cond2;

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    bool cond1 = ((_PollState == Mcalc_PollState::CLIENT_TO_SERVER ||
                   _PollState == Mcalc_PollState::SERVER_RESPONSE) &&
                  _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED &&
                  _RetrievedCycle == _CycleNum);
    bool cond2 = ((_PollState == Mcalc_PollState::SERVER_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE) &&
                  _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED &&
                  _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool retval = cond1 || cond2;

    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ResetSignalSent()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetSignalSent");
    bool ServerResponse_ = _PollState == Mcalc_PollState::SERVER_RESPONSE &&
                           ServerReceiveCompleted(false);
    bool retval = ((ServerResponse_ || PollingResetByClient()) &&
                   _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
                   _RetrievedCycle == _CycleNum);

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    bool ServerResponse_ = _PollState == Mcalc_PollState::SERVER_RESPONSE &&
                           ServerReceiveCompleted(false);
    return ((ServerResponse_ || PollingResetByClient()) &&
            _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
            _RetrievedCycle == _CycleNum);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::PollingResetByClient()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("PollingResetByClient");
    bool retval = (ServerReceiveCompleted(false) &&
                   _PollState == Mcalc_KeepAliveState::IDLE &&
                   _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
                   _ClientState == Mcalc_KeepAliveState::IDLE);

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return (ServerReceiveCompleted(false) &&
            _PollState == Mcalc_KeepAliveState::IDLE &&
            _ServerState == Mcalc_KeepAliveState::RESET_POLLING &&
            _ClientState == Mcalc_KeepAliveState::IDLE);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::AtInitialState()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("AtInitialState");
    int IoState_ = _Parent->SetNoPolling(true)
                          ->Bare_GetIoState(0);
    bool PollClientDone_ = _ClientPollProcess == REQUIRED;
    bool PollServerDone_ = ServerReceiveCompleted(false) ||
                           _ServerPollProcess == INITIALSTATE;
    bool retval =
           (_Parent->IsServerStates(IoState_) &&
            PollClientDone_ && PollServerDone_ &&
            (_ClientState == Mcalc_KeepAliveState::IDLE ||
             _ClientState == Mcalc_KeepAliveState::RESET_POLLING) &&
            _PollState == Mcalc_KeepAliveState::IDLE &&
            (_ServerState == Mcalc_KeepAliveState::IDLE ||
             _ServerState == Mcalc_KeepAliveState::RESET_POLLING));

    _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
    _Parent->DbgPtr()->ShowInt(PollClientDone_, "PollClientDone_");
    _Parent->DbgPtr()->ShowInt(PollServerDone_, "PollServerDone_");
    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    int IoState_ = _Parent->SetNoPolling(true)
                          ->Bare_GetIoState(0);
    bool PollClientDone_ = _ClientPollProcess == REQUIRED;
    bool PollServerDone_ = ServerReceiveCompleted(false) ||
                           _ServerPollProcess == INITIALSTATE;

    return (_Parent->IsServerStates(IoState_) &&
            PollClientDone_ && PollServerDone_ &&
            (_ClientState == Mcalc_KeepAliveState::IDLE ||
             _ClientState == Mcalc_KeepAliveState::RESET_POLLING) &&
            _PollState == Mcalc_KeepAliveState::IDLE &&
            (_ServerState == Mcalc_KeepAliveState::IDLE ||
             _ServerState == Mcalc_KeepAliveState::RESET_POLLING));
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ServerIsPolling() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ServerIsPolling");
    bool retval = ((_PollState == Mcalc_PollState::SERVER_TO_CLIENT ||
                    _PollState == Mcalc_PollState::CLIENT_RESPONSE) &&
                   _ServerState == Mcalc_KeepAliveState::POLL_CLIENTALIVE);

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return ((_PollState == Mcalc_PollState::SERVER_TO_CLIENT ||
             _PollState == Mcalc_PollState::CLIENT_RESPONSE) &&
            _ServerState == Mcalc_KeepAliveState::POLL_CLIENTALIVE);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ClientIsAlive() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ClientIsAlive");
    bool ServerAcked_ = ServerAcked();
    bool retval = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                    ServerAcked_) &&
                   _ClientState == Mcalc_KeepAliveState::CLIENT_ALIVE &&
                   _RetrievedCycle == _CycleNum);

    retval = retval || ServerAcked_;
    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();

    return retval;
  #else
    bool ServerAcked_ = ServerAcked();
    bool retval = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                    ServerAcked_) &&
                   _ClientState == Mcalc_KeepAliveState::CLIENT_ALIVE &&
                   _RetrievedCycle == _CycleNum);

    retval = retval || ServerAcked_;
    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ServerAcked() const
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ServerAcked");
    bool cond1 = ((_PollState == Mcalc_PollState::SERVER_TO_CLIENT ||
                   _PollState == Mcalc_PollState::CLIENT_RESPONSE) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _RetrievedCycle == _CycleNum);
    bool cond2 = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool cond3 = (_PollState == Mcalc_PollState::IDLE &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::IDLE &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));

    bool retval = cond1 || cond2 || cond3;

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    bool cond1 = ((_PollState == Mcalc_PollState::SERVER_TO_CLIENT ||
                   _PollState == Mcalc_PollState::CLIENT_RESPONSE) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _RetrievedCycle == _CycleNum);
    bool cond2 = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool cond3 = (_PollState == Mcalc_PollState::IDLE &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::IDLE &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));

    return (cond1 || cond2 || cond3);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ResetRequested()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetRequested");
    bool PollingReset_ = PollingReset();
    bool cond1 = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE || PollingReset_) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool cond2 = (_PollState == Mcalc_PollState::IDLE &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::IDLE &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));

    bool retval = cond1 || cond2 || PollingReset_;
    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();

    return retval;
  #else
    bool PollingReset_ = PollingReset();
    bool cond1 = ((_PollState == Mcalc_PollState::CLIENT_RESPONSE ||
                   _PollState == Mcalc_PollState::IDLE || PollingReset_) &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::RESET_POLLING &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));
    bool cond2 = (_PollState == Mcalc_PollState::IDLE &&
                  _ServerState == Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED &&
                  _ClientState == Mcalc_KeepAliveState::IDLE &&
                  (_RetrievedCycle == _CycleNum || _RetrievedCycle == 0));

    bool retval = cond1 || cond2 || PollingReset_;
    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::PollingReset()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("PollingReset");
    bool retval = (PollClientCompleted(false) &&
                   _PollState == Mcalc_KeepAliveState::IDLE &&
                   _ServerState == Mcalc_KeepAliveState::IDLE &&
                   _ClientState == Mcalc_KeepAliveState::RESET_POLLING);

    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return (PollClientCompleted(false) &&
            _PollState == Mcalc_KeepAliveState::IDLE &&
            _ServerState == Mcalc_KeepAliveState::IDLE &&
            _ClientState == Mcalc_KeepAliveState::RESET_POLLING);
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::WaitingForClientResponse(bool* FromSvr_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("WaitingForClientResponse");

    bool FromServer_ = SHOWMETHOD(_Parent, PollClientInProcess());
    bool FromClient_ = SHOWMETHOD(_Parent, ServerReceiveInProcess());

    _Parent->DbgPtr()->ShowInt(FromServer_, "FromServer_");
    _Parent->DbgPtr()->ShowInt(FromClient_, "FromClient_");
  #else
    bool FromServer_ = PollClientInProcess();
    bool FromClient_ = ServerReceiveInProcess();
  #endif

  if (FromSvr_)
    *FromSvr_ = FromServer_;

  bool retval = (FromServer_ ? (ServerIsPolling() || ServerAcked()):
                 FromClient_ ? (ServerIsAlive() || ResetSignalSent()):
                               false);

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(retval, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool ClientPollingMgr::ResponseRequired(int PrevPollState_,
                                        int& LoopGuard_, int LoopLimit_)
{
  LoopGuard_++;
  return (_WaitUntilResponse && LoopGuard_ < LoopLimit_ &&
          ((PrevPollState_ == Mcalc_PollState::SERVER_TO_CLIENT &&
            _PollState != Mcalc_PollState::CLIENT_RESPONSE) ||
           (PrevPollState_ == Mcalc_PollState::SERVER_RESPONSE &&
            _PollState != Mcalc_PollState::CLIENT_TO_SERVER &&
            _PollState != Mcalc_PollState::IDLE)));
}

/****************************************************************************/
bool ClientPollingMgr::ClientSetPollInProcess(bool* PollStateOk_) const
{
  int ResetState_ = _ClientState == Mcalc_KeepAliveState::RESET_POLLING ?
                       Mcalc_PollState::IDLE:-1;
  int NewState_ = (_ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE ||
                   _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED) ?
                       Mcalc_PollState::CLIENT_TO_SERVER:-1;

  bool PollStateMatch_ = _PollState == NewState_ ||
                         _PollState == ResetState_;
  if (PollStateOk_)
    *PollStateOk_ = PollStateMatch_;

  return (_ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE ||
          _ClientState == Mcalc_KeepAliveState::CLIENT_ACKNOWLEDGED ||
          _ClientState == Mcalc_KeepAliveState::RESET_POLLING);
}

/****************************************************************************/
bool ClientPollingMgr::ServerSetPollReset(bool* PollStateOk_) const
{
  int ResetState_ = _ServerState == Mcalc_KeepAliveState::RESET_POLLING ?
                       Mcalc_PollState::IDLE:-1;
  int NewState_ = (_ServerState == Mcalc_KeepAliveState::RESET_POLLING ||
                   _ServerState == Mcalc_KeepAliveState::SERVER_ALIVE) ?
                       Mcalc_PollState::SERVER_RESPONSE:-1;

  bool PollStateMatch_ = _PollState == NewState_ ||
                         _PollState == ResetState_;
  if (PollStateOk_)
    *PollStateOk_ = PollStateMatch_;

  return (_ServerState == Mcalc_KeepAliveState::RESET_POLLING ||
          _ServerState == Mcalc_KeepAliveState::SERVER_ALIVE);
}

/****************************************************************************/
int ClientPollingMgr::ReadServerPollProcess(bool RefreshStates_)
{
  bool Reset_ = false;
  bool PsOk_ = false;
  _RdServerPoll = false;

  if (RefreshStates_)
  {
    ReadClientState(0);
    ReadServerState(false);
  }

  if (ServerSetPollReset(&PsOk_))
  {
    if (!PsOk_)
    {
      _PollState = Mcalc_PollState::SERVER_RESPONSE;
      PsOk_ = SetPollState(_PollState);
    }

    Reset_ = _ServerState == Mcalc_KeepAliveState::RESET_POLLING;

    if (Reset_)
    {
      _ServerPollProcess = COMPLETED;
      _PollState = Mcalc_PollState::IDLE;
    }
    else
      _ServerPollProcess = INPROCESS;
  }
  else if (ClientSetPollInProcess(&PsOk_))
  {
    if (!PsOk_)
    {
      Reset_ = _ClientState == Mcalc_KeepAliveState::RESET_POLLING;
      _PollState = Reset_ ? Mcalc_PollState::IDLE:
                            Mcalc_PollState::CLIENT_TO_SERVER;

      PsOk_ = SetPollState(_PollState);
    }

    Reset_ = _ClientState == Mcalc_KeepAliveState::RESET_POLLING;

    if (Reset_)
    {
      _ServerPollProcess = COMPLETED;
      _PollState = Mcalc_PollState::IDLE;
    }
    else
      _ServerPollProcess = INPROCESS;
  }

  _RdServerPoll = true;
  return PsOk_;
}

/****************************************************************************/
int ClientPollingMgr::ReadPollState(int Sleep_)
{
  int mult_ = 0;
  int PrevPollState_ = _PollState;
  int LoopGuard_ = 0;
  int LoopMax_ = LOOP_GUARD_LIMIT;

  int x;
  char* testp = NULL;

  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
  #endif

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ReadPollState");
    FILE* Pfptr_ = SHOWPARENTMETHOD(_Parent, GetPollStateFile(READ, true));
  #else
    FILE* Pfptr_ = _Parent->GetPollStateFile(READ, true);
  #endif

  if (Pfptr_ && feof(Pfptr_))
    rewind(Pfptr_);

  if (Pfptr_ && !feof(Pfptr_))
  {
    mult_ = (Sleep_ > 1) ? Sleep_:1;

    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(mult_ * DelayLen_);
    #else
      ::usleep(mult_ * DelayLen_);
    #endif
  }

  do
  {
    if (Pfptr_ && feof(Pfptr_))
      rewind(Pfptr_);

    if (Pfptr_ && !feof(Pfptr_))
    {
      ::memset(_StrBuffer, 0, BUFSIZE);
      testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);

      for (x = 0; !testp && x < LoopMax_; x++)
      {
        #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
          Sleep(DelayLen_);
        #else
          ::usleep(DelayLen_);
        #endif

        Pfptr_ = _Parent->GetPollStateFile(READ, true);

        if (Pfptr_ && feof(Pfptr_))
          rewind(Pfptr_);

        if (Pfptr_ && !feof(Pfptr_))
          testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);
      }

      if (testp)
        _PollState = atoi(testp);
    }
  }
  while (ResponseRequired(PrevPollState_, LoopGuard_, LoopMax_));

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return _PollState;
}

/****************************************************************************/
int ClientPollingMgr::ReadClientState(int Sleep_)
{
  int mult_ = 0;
  int PrevPollState_ = _PollState;
  int LoopGuard_ = 0;
  int LoopMax_ = LOOP_GUARD_LIMIT;
  bool SleepDone_ = false;

  int x;
  char* testp = NULL;

  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
  #endif

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ReadClientState");

    FILE* Pfptr_ = SHOWPARENTMETHOD(_Parent, GetPollStateFile(READ, true));
    FILE* Cfptr_ = SHOWPARENTMETHOD(_Parent, GetClientAliveFile(READ, true));
  #else
    FILE* Pfptr_ = _Parent->GetPollStateFile(READ, true);
    FILE* Cfptr_ = _Parent->GetClientAliveFile(READ, true);
  #endif

  if (Pfptr_ && feof(Pfptr_))
    rewind(Pfptr_);

  if (Pfptr_ && !feof(Pfptr_))
  {
    mult_ = (Sleep_ > 1) ? Sleep_:1;
    SleepDone_ = true;

    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(mult_ * DelayLen_);
    #else
      ::usleep(mult_ * DelayLen_);
    #endif
  }

  do
  {
    if (Pfptr_ && feof(Pfptr_))
      rewind(Pfptr_);

    if (Pfptr_ && !feof(Pfptr_))
    {
      ::memset(_StrBuffer, 0, BUFSIZE);
      testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);

      for (x = 0; !testp && x < LoopMax_; x++)
      {
        #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
          Sleep(DelayLen_);
        #else
          ::usleep(DelayLen_);
        #endif

        SleepDone_ = true;
        Pfptr_ = _Parent->GetPollStateFile(READ, true);

        if (Pfptr_ && feof(Pfptr_))
          rewind(Pfptr_);

        if (Pfptr_ && !feof(Pfptr_))
          testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);
      }

      if (testp)
        _PollState = atoi(testp);
    }

    // Wait some time before getting client state
    if (!SleepDone_ &&
        Sleep_ && (!_SleepWaiting || WaitingForClientResponse()))
    {
      mult_ = (Sleep_ > 1) ? Sleep_:1;
      SleepDone_ = true;

      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(mult_ * DelayLen_);
      #else
        ::usleep(mult_ * DelayLen_);
      #endif

      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowMessage("WaitingForClientResponse == 1\n");
        _Parent->DbgPtr()->ShowInt(_SleepWaiting, "_SleepWaiting");
        _Parent->DbgPtr()->ShowInt(Sleep_, "Sleep_");
      #endif
    }

    SleepDone_ = false;
  }
  while (ResponseRequired(PrevPollState_, LoopGuard_, LoopMax_));

  if (Cfptr_ && feof(Cfptr_))
    rewind(Cfptr_);

  if (Cfptr_ && !feof(Cfptr_))
  {
    ::memset(_StrBuffer, 0, BUFSIZE);
    testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);

    for (x = 0; !testp && x < LoopMax_; x++)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif

      Cfptr_ = _Parent->GetClientAliveFile(READ, true);

      if (Cfptr_ && feof(Cfptr_))
        rewind(Cfptr_);

      if (Cfptr_ && !feof(Cfptr_))
        testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);
    }

    if (testp)
      _ClientState = atoi(testp);

    if (Cfptr_ && !feof(Cfptr_))
    {
      testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);
      _RetrievedCycle = testp ? atoi(testp):0;
    }
    else
      _RetrievedCycle = 0;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ClientState), "_ClientState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_RetrievedCycle), "_RetrievedCycle");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return _ClientState;
}

/****************************************************************************/
int ClientPollingMgr::ReadServerState(bool RdPoll_)
{
  int LoopMax_ = LOOP_GUARD_LIMIT;
  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
  #endif

  int x;
  char* testp = NULL;

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ReadServerState");

    FILE* Pfptr_ = SHOWPARENTMETHOD(_Parent, GetPollStateFile(READ, true));
    FILE* Sfptr_ = SHOWPARENTMETHOD(_Parent, GetServerAliveFile(READ, true));
  #else
    FILE* Pfptr_ = _Parent->GetPollStateFile(READ, true);
    FILE* Sfptr_ = _Parent->GetServerAliveFile(READ, true);
  #endif

  if (Pfptr_ && feof(Pfptr_) && RdPoll_)
    rewind(Pfptr_);

  if (Pfptr_ && !feof(Pfptr_) && RdPoll_)
  {
    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(DelayLen_);
    #else
      ::usleep(DelayLen_);
    #endif
  }

  if (Pfptr_ && !feof(Pfptr_) && RdPoll_)
  {
    ::memset(_StrBuffer, 0, BUFSIZE);
    testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);

    for (x = 0; !testp && x < LoopMax_; x++)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif

      Pfptr_ = _Parent->GetPollStateFile(READ, true);

      if (Pfptr_ && feof(Pfptr_))
        rewind(Pfptr_);

      if (Pfptr_ && !feof(Pfptr_))
        testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);
    }

    if (testp)
      _PollState = atoi(testp);
  }

  if (Sfptr_ && feof(Sfptr_))
    rewind(Sfptr_);

  if (Sfptr_ && !feof(Sfptr_))
  {
    ::memset(_StrBuffer, 0, BUFSIZE);
    testp = fgets(_StrBuffer, BUFSIZE, Sfptr_);

    for (x = 0; !testp && x < LoopMax_; x++)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif

      Sfptr_ = _Parent->GetServerAliveFile(READ, true);

      if (Sfptr_ && feof(Sfptr_))
        rewind(Sfptr_);

      if (Sfptr_ && !feof(Sfptr_))
        testp = fgets(_StrBuffer, BUFSIZE, Sfptr_);
    }

    if (testp)
      _ServerState = atoi(testp);
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_RetrievedCycle), "_RetrievedCycle");

    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return _ServerState;
}

/****************************************************************************/
int ClientPollingMgr::ReadServerState()
{
  return ReadServerState(true);
}

/****************************************************************************/
void ClientPollingMgr::ReadAllStates(int Sleep_)
{
  int mult_ = 0;
  int PrevPollState_ = _PollState;
  int LoopGuard_ = 0;
  int LoopMax_ = LOOP_GUARD_LIMIT;
  bool SleepDone_ = false;

  int x;
  char* testp = NULL;

  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
  #endif

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ReadAllStates");

    SHOWMETHOD(_Parent, ReadServerState(false));
    FILE* Pfptr_ = SHOWPARENTMETHOD(_Parent, GetPollStateFile(READ, true));
    FILE* Cfptr_ = SHOWPARENTMETHOD(_Parent, GetClientAliveFile(READ, true));
  #else
    ReadServerState(false);
    FILE* Pfptr_ = _Parent->GetPollStateFile(READ, true);
    FILE* Cfptr_ = _Parent->GetClientAliveFile(READ, true);
  #endif

  if (Pfptr_ && feof(Pfptr_))
    rewind(Pfptr_);

  if (Pfptr_ && !feof(Pfptr_))
  {
    mult_ = (Sleep_ > 1) ? Sleep_:1;
    SleepDone_ = true;

    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(mult_ * DelayLen_);
    #else
      ::usleep(mult_ * DelayLen_);
    #endif
  }

  do
  {
    if (Pfptr_ && feof(Pfptr_))
      rewind(Pfptr_);

    if (Pfptr_ && !feof(Pfptr_))
    {
      ::memset(_StrBuffer, 0, BUFSIZE);
      testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);

      for (x = 0; !testp && x < LoopMax_; x++)
      {
        #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
          Sleep(DelayLen_);
        #else
          ::usleep(DelayLen_);
        #endif

        SleepDone_ = true;
        Pfptr_ = _Parent->GetPollStateFile(READ, true);

        if (Pfptr_ && feof(Pfptr_))
          rewind(Pfptr_);

        if (Pfptr_ && !feof(Pfptr_))
          testp = fgets(_StrBuffer, BUFSIZE, Pfptr_);
      }

      if (testp)
        _PollState = atoi(testp);
    }

    // Wait some time before getting server state
    if (!SleepDone_ &&
        Sleep_ && (!_SleepWaiting || WaitingForClientResponse()))
    {
      mult_ = (Sleep_ > 1) ? Sleep_:1;
      SleepDone_ = true;

      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(mult_ * DelayLen_);
      #else
        ::usleep(mult_ * DelayLen_);
      #endif

      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowMessage("WaitingForClientResponse == 1\n");
        _Parent->DbgPtr()->ShowInt(_SleepWaiting, "_SleepWaiting");
        _Parent->DbgPtr()->ShowInt(Sleep_, "Sleep_");
      #endif
    }

    SleepDone_ = false;
  }
  while (ResponseRequired(PrevPollState_, LoopGuard_, LoopMax_));

  if (Cfptr_ && feof(Cfptr_))
    rewind(Cfptr_);

  if (Cfptr_ && !feof(Cfptr_))
  {
    ::memset(_StrBuffer, 0, BUFSIZE);
    testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);

    for (x = 0; !testp && x < LoopMax_; x++)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif

      Cfptr_ = _Parent->GetClientAliveFile(READ, true);

      if (Cfptr_ && feof(Cfptr_))
        rewind(Cfptr_);

      if (Cfptr_ && !feof(Cfptr_))
        testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);
    }

    if (testp)
      _ClientState = atoi(testp);

    if (Cfptr_ && !feof(Cfptr_))
    {
      testp = fgets(_StrBuffer, BUFSIZE, Cfptr_);
      _RetrievedCycle = testp ? atoi(testp):0;
    }
    else
      _RetrievedCycle = 0;
  }

  if (_RdServerPoll)
    ReadServerPollProcess(false);

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ClientState), "_ClientState");
    _Parent->DbgPtr()->ShowInt(_RetrievedCycle, "_RetrievedCycle");

    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::SetPollState(int State_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SetPollState");
    FILE* Fptr_ = SHOWPARENTMETHOD(_Parent, GetPollStateFile(WRITE));
  #else
    FILE* Fptr_ = _Parent->GetPollStateFile(WRITE);
  #endif

  if (Fptr_)
  {
    fprintf(Fptr_, "%d\n%d", State_, IncCycleNum());
    _Parent->ClosePollStateFile();

    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(State_, "State_");
      _Parent->DbgPtr()->ShowInt(true, "retval");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return true;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::SetServerState(int State_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SetServerState");
    FILE* Fptr_ = SHOWPARENTMETHOD(_Parent, GetServerAliveFile(WRITE));
  #else
    FILE* Fptr_ = _Parent->GetServerAliveFile(WRITE);
  #endif

  if (Fptr_)
  {
    fprintf(Fptr_, "%d\n%d", State_, IncCycleNum());
    _Parent->CloseServerAliveFile();

    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(State_, "State_");
      _Parent->DbgPtr()->ShowInt(true, "retval");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return true;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::SetClientState(int State_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SetClientState");
    FILE* Fptr_ = SHOWPARENTMETHOD(_Parent, GetClientAliveFile(WRITE));
  #else
    FILE* Fptr_ = _Parent->GetClientAliveFile(WRITE);
  #endif

  if (Fptr_)
  {
    fprintf(Fptr_, "%d\n%d", State_, IncCycleNum());
    _Parent->CloseClientAliveFile();

    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(State_, "State_");
      _Parent->DbgPtr()->ShowInt(true, "retval");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return true;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
void ClientPollingMgr::ResetPollingVars()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetPollingVars");
    SHOWMETHOD(_Parent, ResetPollCount());
  #else
    ResetPollCount();
  #endif

  _KeepAlivePollError = false;
  _ConfirmedClientAlive = false;

  if (_ClientAliveConfSent)
  {
    #if CALCLIB_DEBUG9
      SHOWPARENTMETHOD(_Parent, SendClientAlive(false));
    #else
      _Parent->SendClientAlive(false);
    #endif

    _ClientAliveConfSent = false;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void ClientPollingMgr::AcceptPollCycle()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("AcceptPollCycle");
  #endif

  _CycleActive = true;
  _CycleNum = _RetrievedCycle;

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(_CycleActive, "_CycleActive");
    _Parent->DbgPtr()->ShowInt(_CycleNum, "_CycleNum");
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void ClientPollingMgr::ResetPollCycle()
{
  _CycleActive = false;
}

/****************************************************************************/
void ClientPollingMgr::SetNewPollCycle()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SetNewPollCycle");
  #endif

  if (!_CycleActive)
  {
    _CycleActive = true;
    _CycleNum++;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(_CycleActive, "_CycleActive");
    _Parent->DbgPtr()->ShowInt(_CycleNum, "_CycleNum");
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
int ClientPollingMgr::IncCycleNum()
{
  if (!_CycleActive)
    return 0;

  return _CycleNum;
}

/****************************************************************************/
bool ClientPollingMgr::IsClientAliveStates(int State_)
{
  return
  (
    State_ == Mcalc_KeepAliveState::POLL_SERVERALIVE ||
    State_ == Mcalc_KeepAliveState::CLIENT_ALIVE
  );
}

/****************************************************************************/
bool ClientPollingMgr::IsServerAliveStates(int State_)
{
  return
  (
    State_ == Mcalc_KeepAliveState::SERVER_ALIVE ||
    State_ == Mcalc_KeepAliveState::POLL_CLIENTALIVE
  );
}

/****************************************************************************/
bool ClientPollingMgr::SendPollClientSignal()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SendPollClientSignal");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool Required_ = _ClientPollProcess == REQUIRED;
  bool DoPollClient_ = !_Parent->IsClientStates(IoState_) &&
                       AtInitialState() && Required_;

  if (DoPollClient_ && _Parent->GetServerAliveFile(WRITE))
  {
    ResetPollingVars();

    _ServerState = Mcalc_KeepAliveState::POLL_CLIENTALIVE;
    _ClientPollProcess = INPROCESS;

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange();
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_PollState::SERVER_TO_CLIENT;
      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(Required_, "Required_");
        _Parent->DbgPtr()->ShowInt(DoPollClient_, "DoPollClient_");
        _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
        _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
        _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess");
        _Parent->DbgPtr()->LeaveLevel();
        _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
      #endif

      return SetPollState(_PollState);
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(Required_, "Required_");
    _Parent->DbgPtr()->ShowInt(DoPollClient_, "DoPollClient_");
    _Parent->DbgPtr()->LeaveLevel();
    _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
  #endif
  return false;
}

/****************************************************************************/
void ClientPollingMgr::ConfirmClientAlive(bool ServerReceive_)
{
  _RetryPollCount = 0;
  _KeepAlivePollError = false;
  _ConfirmedClientAlive = ServerReceive_ ? ClientAcked():ClientIsAlive();
}

/****************************************************************************/
bool ClientPollingMgr::SendServerAckClientSignal()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SendServerAckClientSignal");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool DoAck_ = !_Parent->IsClientStates(IoState_) && ClientIsAlive() &&
                PollClientInProcess() && _ConfirmedClientAlive;

  if (DoAck_ && _Parent->GetServerAliveFile(WRITE))
  {
    _ServerState = Mcalc_KeepAliveState::SERVER_ACKNOWLEDGED;
    _ClientPollProcess = INPROCESS;

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange();
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_PollState::SERVER_TO_CLIENT;
      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
        _Parent->DbgPtr()->ShowInt(DoAck_, "DoAck_");
        _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
        _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
        _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess");
        _Parent->DbgPtr()->LeaveLevel();
        _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
      #endif

      return SetPollState(_PollState);
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
    _Parent->DbgPtr()->ShowInt(DoAck_, "DoAck_");
    _Parent->DbgPtr()->LeaveLevel();
    _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
  #endif
  return false;
}

/****************************************************************************/
bool ClientPollingMgr::ResetPolling()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetPolling");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool DoReset_ = !_Parent->IsClientStates(IoState_) && ResetRequested() &&
                  PollClientInProcess() && _ConfirmedClientAlive;

  if (DoReset_ && _Parent->GetServerAliveFile(WRITE))
  {
    ResetPollCycle();
    _KeepAlivePollError = false;

    _ServerState = Mcalc_KeepAliveState::IDLE;
    _ClientPollProcess = COMPLETED;

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange();
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_KeepAliveState::IDLE;
      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
        _Parent->DbgPtr()->ShowInt(DoReset_, "DoReset_");
        _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
        _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
        _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
        _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess");
        _Parent->DbgPtr()->LeaveLevel();
        _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
      #endif

      bool retval = SetPollState(_PollState);
      bool Alive_ = _ConfirmedClientAlive && _ConfirmedServerAlive;

      // Reset server side no-activity timer
      if (!_ClientAliveConfSent)
      {
        #if CALCLIB_DEBUG9
          SHOWPARENTMETHOD(_Parent, SendClientAlive(Alive_));
        #else
          _Parent->SendClientAlive(Alive_);
        #endif

        _ClientAliveConfSent = true;
      }

      return retval;
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
    _Parent->DbgPtr()->ShowInt(DoReset_, "DoReset_");
    _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
    _Parent->DbgPtr()->LeaveLevel();
    _Parent->DbgPtr()->LeaveLevel();  // from PollClientIfAlive()
  #endif
  return false;
}

/****************************************************************************/
bool ClientPollingMgr::SendServerAliveSignal()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SendServerAliveSignal");
  #endif

  if (_RdServerPoll)
    ReadServerPollProcess();

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool Required_ = _ServerPollProcess == REQUIRED ||
                   ClientSetPollInProcess();
  bool DoSendAlive_ = _Parent->IsClientStates(IoState_) &&
                      ClientIsPolling() && Required_;

  if (DoSendAlive_ && _Parent->GetServerAliveFile(WRITE))
  {
    _KeepAlivePollError = false;
    _ServerState = Mcalc_KeepAliveState::SERVER_ALIVE;
    _ServerPollProcess = INPROCESS;

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange();
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_PollState::SERVER_RESPONSE;
      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
        _Parent->DbgPtr()->ShowInt(Required_, "Required_");
        _Parent->DbgPtr()->ShowInt(DoSendAlive_, "DoSendAlive_");
        _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
        _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
        _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
        _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess");
        _Parent->DbgPtr()->LeaveLevel();
        _Parent->DbgPtr()->LeaveLevel();  // from ReceiveKeepAlivePoll()
      #endif

      return SetPollState(_PollState);
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
    _Parent->DbgPtr()->ShowInt(Required_, "Required_");
    _Parent->DbgPtr()->ShowInt(DoSendAlive_, "DoSendAlive_");
    _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
    _Parent->DbgPtr()->LeaveLevel();
    _Parent->DbgPtr()->LeaveLevel();  // from ReceiveKeepAlivePoll()
  #endif
  return false;
}

/****************************************************************************/
void ClientPollingMgr::ConfirmServerAlive(bool PollClient_)
{
  _KeepAlivePollError = false;
  _ConfirmedServerAlive = PollClient_ ? ClientIsAlive():ServerIsAlive();
}

/****************************************************************************/
bool ClientPollingMgr::SendResetPollingSignal()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("SendResetPollingSignal");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool DoReset_ = _Parent->IsClientStates(IoState_) && ClientAcked() &&
                  ServerReceiveInProcess() && _ConfirmedServerAlive;

  if (DoReset_ && _Parent->GetServerAliveFile(WRITE))
  {
    ResetPollCycle();
    _KeepAlivePollError = false;

    _ServerState = Mcalc_KeepAliveState::RESET_POLLING;
    _ServerPollProcess = COMPLETED;

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange();
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_PollState::SERVER_RESPONSE;
      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
        _Parent->DbgPtr()->ShowInt(DoReset_, "DoReset_");
        _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
        _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
        _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
        _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess");
        _Parent->DbgPtr()->LeaveLevel();
        _Parent->DbgPtr()->LeaveLevel();  // from ReceiveKeepAlivePoll()
      #endif

      bool retval = SetPollState(_PollState);
      bool Alive_ = _ConfirmedClientAlive && _ConfirmedServerAlive;

      // Reset server side no-activity timer
      if (!_ClientAliveConfSent)
      {
        #if CALCLIB_DEBUG9
          SHOWPARENTMETHOD(_Parent, SendClientAlive(Alive_));
        #else
          _Parent->SendClientAlive(Alive_);
        #endif

        _ClientAliveConfSent = true;
      }

      return retval;
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(IoState_, "IoState_");
    _Parent->DbgPtr()->ShowInt(DoReset_, "DoReset_");
    _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError");
    _Parent->DbgPtr()->LeaveLevel();
    _Parent->DbgPtr()->LeaveLevel();  // from ReceiveKeepAlivePoll()
  #endif
  return false;
}

/****************************************************************************/
ClientPollingMgr* ClientPollingMgr::ResetWhenNotRequired(bool Forced_)
{
  _ResetWhenNotReq = true;
  _ForceReset = Forced_;

  #if CALCLIB_DEBUG10
    SetStopTracking(true);
  #endif

  return this;
}

/****************************************************************************/
bool ClientPollingMgr::PollClientRequired(int Sleep_, bool ResponseOnly_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("PollClientRequired");
    _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess(1)");
  #endif

  ReadAllStates(Sleep_);

  int CurState_ = _Parent->CurrentIoState();
  _Parent->ReceiveBreakOrQuit(CurState_);
  bool BreakOrQuit_ = _Parent->ShouldQuit() || _Parent->ShouldBreakFromProgram(NULL);

  bool ClientResponse_ = _PollState == Mcalc_PollState::CLIENT_RESPONSE;
  bool ResetReq_ = BreakOrQuit_ || ResetRequested();
  bool Required_ = ((_AllowPollClient && !ResponseOnly_) ||
                    ClientResponse_ || ResetReq_ || _KeepAlivePollError);

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess(2)");
    _Parent->DbgPtr()->ShowInt(_ResetWhenNotReq, "_ResetWhenNotReq(1)");

    _Parent->DbgPtr()->ShowInt(_AllowPollClient, "_AllowPollClient(1)");
    _Parent->DbgPtr()->ShowInt(ResponseOnly_, "ResponseOnly_(1)");
    _Parent->DbgPtr()->ShowInt(ClientResponse_, "ClientResponse_(1)");
    _Parent->DbgPtr()->ShowInt(ResetReq_, "ResetReq_(1)");
    _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError(1)");
    _Parent->DbgPtr()->ShowInt(Required_, "Required_(1)");
  #endif

  if (_ClientPollProcess == INITIALSTATE ||
      _ClientPollProcess == COMPLETED)
    _ClientPollProcess = _KeepAlivePollError ? NOTREQUIRED:
                         ResetReq_           ? COMPLETED:
                         Required_           ? REQUIRED:NOTREQUIRED;
  else if (_KeepAlivePollError)
    _ClientPollProcess = NOTREQUIRED;
  else if (ResetReq_)
    _ClientPollProcess = COMPLETED;

  bool retval = (_ClientPollProcess == REQUIRED ||
                 (_ClientPollProcess == INPROCESS && !_KeepAlivePollError));

  #if CALCLIB_DEBUG10
    if (!retval)
      SetTrackingOnStateChange();
  #endif

  #if CALCLIB_DEBUG9
    if (_ResetWhenNotReq && _ClientPollProcess == NOTREQUIRED)
    {
      _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess(3)");
      #if CALCLIB_DEBUG10
        SHOWMETHOD(_Parent, SetStopTracking(true));
      #endif
      SHOWMETHOD(_Parent, ResetClientPolling(_ForceReset));
      _ResetWhenNotReq = false;
    }

    _Parent->DbgPtr()->ShowInt(_ResetWhenNotReq, "_ResetWhenNotReq(2)");
    _Parent->DbgPtr()->ShowInt(_AllowPollClient, "_AllowPollClient(2)");
    _Parent->DbgPtr()->ShowInt(ResponseOnly_, "ResponseOnly_(2)");
    _Parent->DbgPtr()->ShowInt(ClientResponse_, "ClientResponse_(2)");
    _Parent->DbgPtr()->ShowInt(ResetReq_, "ResetReq_(2)");
    _Parent->DbgPtr()->ShowInt(_KeepAlivePollError, "_KeepAlivePollError(2)");
    _Parent->DbgPtr()->ShowInt(Required_, "Required_(2)");

    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ClientState), "_ClientState");
    _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess(4)");
    _Parent->DbgPtr()->ShowInt(retval, "retval");

    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    if (_ResetWhenNotReq && _ClientPollProcess == NOTREQUIRED)
    {
      #if CALCLIB_DEBUG10
        SetStopTracking(true);
      #endif
      ResetClientPolling(_ForceReset);
      _ResetWhenNotReq = false;
    }

    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::PollClientNotRequired(bool InclAtInitial_)
{
  if (_RdServerPoll)
    ReadServerPollProcess(false);

  return ((_ClientPollProcess == NOTREQUIRED ||
           (_ClientPollProcess == INITIALSTATE && InclAtInitial_)) && !_KeepAlivePollError);
}

/****************************************************************************/
bool ClientPollingMgr::PollClientInProcess()
{
  if (_RdServerPoll)
    ReadServerPollProcess(false);

  return (_ClientPollProcess == INPROCESS && !_KeepAlivePollError);
}

/****************************************************************************/
bool ClientPollingMgr::PollClientCompleted_IMPL(bool InclNotReq_, bool InclPrev_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("PollClientCompleted_IMPL");
  #endif

  bool ResetCond_ = false;
  bool CurrCond_ = false;
  bool PrevCond_ = false;

  int CurState_ = _Parent->CurrentIoState();
  _Parent->ReceiveBreakOrQuit(CurState_);
  bool BreakOrQuit_ = _Parent->ShouldQuit() || _Parent->ShouldBreakFromProgram(NULL);

  if (_RdServerPoll)
    ReadServerPollProcess(false);

  if (_ResetStatesOnDone && InclPrev_)
  {
    ResetCond_ = _ClientPollProcess == INITIALSTATE;
    PrevCond_ = ((_PrevClientProcess == COMPLETED ||
                  (_PrevClientProcess == NOTREQUIRED && InclNotReq_)) && !_KeepAlivePollError);
  }
  else if (BreakOrQuit_)
    _ClientPollProcess = COMPLETED;

  CurrCond_ = ((_ClientPollProcess == COMPLETED ||
                (_ClientPollProcess == NOTREQUIRED && InclNotReq_)) && !_KeepAlivePollError);

  #if CALCLIB_DEBUG9
    bool retval = (CurrCond_ || (_ResetStatesOnDone && ResetCond_ && PrevCond_));
    _Parent->DbgPtr()->ShowInt(_ResetStatesOnDone, "_ResetStatesOnDone");
    _Parent->DbgPtr()->ShowInt(InclPrev_, "InclPrev_");
    _Parent->DbgPtr()->ShowInt(InclNotReq_, "InclNotReq_");
    _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
    _Parent->DbgPtr()->ShowInt(PrevCond_, "PrevCond_");
    _Parent->DbgPtr()->ShowInt(CurrCond_, "CurrCond_");
    _Parent->DbgPtr()->ShowInt(retval, "retval");

    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return (CurrCond_ || (_ResetStatesOnDone && ResetCond_ && PrevCond_));
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::PollClientCompleted(bool InclNotReq_)
{
  return PollClientCompleted_IMPL(InclNotReq_, true);
}

/****************************************************************************/
bool ClientPollingMgr::ServerReceiveRequired(int Sleep_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ServerReceiveRequired");
    _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess(1)");
  #endif

  ReadAllStates(Sleep_);

  int CurState_ = _Parent->CurrentIoState();
  _Parent->ReceiveBreakOrQuit(CurState_);
  bool BreakOrQuit_ = _Parent->ShouldQuit() || _Parent->ShouldBreakFromProgram(NULL);

  bool ClientToServer_ = _PollState == Mcalc_PollState::CLIENT_TO_SERVER;
  bool ClientPolling_ = _ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE;
  bool Required_ = ClientToServer_ || ClientPolling_;
  bool Completed_ = BreakOrQuit_ ||
                    (!_PollState && !_ClientState &&
                     (!_ServerState ||
                      _ServerState == Mcalc_KeepAliveState::RESET_POLLING));

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess(2)");
    _Parent->DbgPtr()->ShowInt(_ResetWhenNotReq, "_ResetWhenNotReq(1)");

    _Parent->DbgPtr()->ShowInt(ClientToServer_, "ClientToServer_(1)");
    _Parent->DbgPtr()->ShowInt(ClientPolling_, "ClientPolling_(1)");
    _Parent->DbgPtr()->ShowInt(Required_, "Required_(1)");
  #endif

  if (_ServerPollProcess == INITIALSTATE ||
      _ServerPollProcess == COMPLETED ||
      ClientSetPollInProcess())
    _ServerPollProcess = Completed_ ? COMPLETED:
                         Required_  ? REQUIRED:NOTREQUIRED;
  else if (Completed_)
    _ServerPollProcess = COMPLETED;

  bool retval = _ServerPollProcess != COMPLETED &&
                (_ServerPollProcess == REQUIRED || ClientSetPollInProcess() ||
                 (_ServerPollProcess == INPROCESS && !_KeepAlivePollError));

  #if CALCLIB_DEBUG10
    if (!retval)
      SetTrackingOnStateChange();
  #endif

  #if CALCLIB_DEBUG9
    if (_ResetWhenNotReq && _ServerPollProcess == NOTREQUIRED)
    {
      _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess(3)");
      #if CALCLIB_DEBUG10
        SHOWMETHOD(_Parent, SetStopTracking(true));
      #endif
      SHOWMETHOD(_Parent, ResetReceivePoll(_ForceReset));
      _ResetWhenNotReq = false;
    }

    _Parent->DbgPtr()->ShowInt(_ResetWhenNotReq, "_ResetWhenNotReq(2)");
    _Parent->DbgPtr()->ShowInt(ClientToServer_, "ClientToServer_(2)");
    _Parent->DbgPtr()->ShowInt(ClientPolling_, "ClientPolling_(2)");
    _Parent->DbgPtr()->ShowInt(Required_, "Required_(2)");

    _Parent->DbgPtr()->ShowStr(PollStateToStr(_PollState), "_PollState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ServerState), "_ServerState");
    _Parent->DbgPtr()->ShowStr(KeepAliveStateToStr(_ClientState), "_ClientState");
    _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess(4)");
    _Parent->DbgPtr()->ShowInt(retval, "retval");

    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    if (_ResetWhenNotReq && _ServerPollProcess == NOTREQUIRED)
    {
      #if CALCLIB_DEBUG10
        SetStopTracking(true);
      #endif
      ResetReceivePoll(_ForceReset);
      _ResetWhenNotReq = false;
    }

    return retval;
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ServerReceiveNotRequired(bool InclAtInitial_)
{
  if (_RdServerPoll)
    ReadServerPollProcess(false);

  return ((_ServerPollProcess == NOTREQUIRED ||
           (_ServerPollProcess == INITIALSTATE && InclAtInitial_)) && !_KeepAlivePollError);
}

/****************************************************************************/
bool ClientPollingMgr::ServerReceiveInProcess()
{
  if (_RdServerPoll)
    ReadServerPollProcess(false);

  return (_ServerPollProcess == INPROCESS && !_KeepAlivePollError);
}

/****************************************************************************/
bool ClientPollingMgr::ServerReceiveCompleted_IMPL(bool InclNotReq_, bool InclPrev_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ServerReceiveCompleted_IMPL");
  #endif

  bool ResetCond_ = false;
  bool CurrCond_ = false;
  bool PrevCond_ = false;

  int CurState_ = _Parent->CurrentIoState();
  _Parent->ReceiveBreakOrQuit(CurState_);
  bool BreakOrQuit_ = _Parent->ShouldQuit() || _Parent->ShouldBreakFromProgram(NULL);

  if (_RdServerPoll)
    ReadServerPollProcess(false);

  if (_ResetStatesOnDone && InclPrev_)
  {
    ResetCond_ = _ServerPollProcess == INITIALSTATE;
    PrevCond_ = ((_PrevServerProcess == COMPLETED ||
                  (_PrevServerProcess == NOTREQUIRED && InclNotReq_)) && !_KeepAlivePollError);
  }
  else if (BreakOrQuit_)
    _ServerPollProcess = COMPLETED;

  CurrCond_ = ((_ServerPollProcess == COMPLETED ||
                (_ServerPollProcess == NOTREQUIRED && InclNotReq_)) && !_KeepAlivePollError);

  #if CALCLIB_DEBUG9
    bool retval = (CurrCond_ || (_ResetStatesOnDone && ResetCond_ && PrevCond_));
    _Parent->DbgPtr()->ShowInt(_ResetStatesOnDone, "_ResetStatesOnDone");
    _Parent->DbgPtr()->ShowInt(InclPrev_, "InclPrev_");
    _Parent->DbgPtr()->ShowInt(InclNotReq_, "InclNotReq_");
    _Parent->DbgPtr()->ShowInt(ResetCond_, "ResetCond_");
    _Parent->DbgPtr()->ShowInt(PrevCond_, "PrevCond_");
    _Parent->DbgPtr()->ShowInt(CurrCond_, "CurrCond_");
    _Parent->DbgPtr()->ShowInt(retval, "retval");

    _Parent->DbgPtr()->LeaveLevel();
    return retval;
  #else
    return (CurrCond_ || (_ResetStatesOnDone && ResetCond_ && PrevCond_));
  #endif
}

/****************************************************************************/
bool ClientPollingMgr::ServerReceiveCompleted(bool InclNotReq_)
{
  return ServerReceiveCompleted_IMPL(InclNotReq_, true);
}

/****************************************************************************/
void ClientPollingMgr::SetTrackingOnStateChange(bool Reset_)
{
  bool PollTestRetVal_ = false;

  if (_RdServerPoll)
    ReadServerPollProcess();

  if (_Backup)
  {
    bool ChangeFound_ = false;

    if (_Backup->_ClientPollProcess != _ClientPollProcess)
    {
      if (Reset_ && _ClientPollProcess == NOTREQUIRED)
      {
        ResetWhenNotRequired(true);
        #if CALCLIB_DEBUG10
          SetStopTracking(true);
        #endif

        #if CALCLIB_DEBUG9
          SHOWMETHOD(_Parent, ResetClientPolling(_ForceReset));
        #else
          ResetClientPolling(_ForceReset);
        #endif
      }
      else if (!_ResetWhenNotReq || _ClientPollProcess != NOTREQUIRED)
        SetStopTracking(false);

      _Backup->_ClientPollProcess = _ClientPollProcess;
      ChangeFound_ = true;
    }
    else if (!ChangeFound_ &&
             _Backup->_ClientPollProcess == _ClientPollProcess)
    {
      PollTestRetVal_ = (_ClientPollProcess == REQUIRED ||
                         (_ClientPollProcess == INPROCESS && !_KeepAlivePollError));

      #if CALCLIB_DEBUG10
        if (!PollTestRetVal_)
          SetStopTracking(true);
      #endif

      if (Reset_ && _ClientPollProcess == NOTREQUIRED)
      {
        ResetWhenNotRequired(true);

        #if CALCLIB_DEBUG9
          SHOWMETHOD(_Parent, ResetClientPolling(_ForceReset));
        #else
          ResetClientPolling(_ForceReset);
        #endif
      }
    }

    if (_Backup->_ServerPollProcess != _ServerPollProcess)
    {
      if (Reset_ && _ServerPollProcess == NOTREQUIRED)
      {
        ResetWhenNotRequired(true);
        #if CALCLIB_DEBUG10
          SetStopTracking(true);
        #endif

        #if CALCLIB_DEBUG9
          SHOWMETHOD(_Parent, ResetReceivePoll(_ForceReset));
        #else
          ResetReceivePoll(_ForceReset);
        #endif
      }
      else if (!_ResetWhenNotReq || _ClientPollProcess != NOTREQUIRED)
        SetStopTracking(false);

      _Backup->_ServerPollProcess = _ServerPollProcess;
      ChangeFound_ = true;
    }
    else if (!ChangeFound_ &&
             _Backup->_ServerPollProcess == _ServerPollProcess)
    {
      PollTestRetVal_ = (_ServerPollProcess == REQUIRED || ClientSetPollInProcess() ||
                         (_ServerPollProcess == INPROCESS && !_KeepAlivePollError));

      #if CALCLIB_DEBUG10
        if (!PollTestRetVal_)
          SetStopTracking(true);
      #endif

      if (Reset_ && _ServerPollProcess == NOTREQUIRED)
      {
        ResetWhenNotRequired(true);

        #if CALCLIB_DEBUG9
          SHOWMETHOD(_Parent, ResetReceivePoll(_ForceReset));
        #else
          ResetReceivePoll(_ForceReset);
        #endif
      }
    }
  }
}

/****************************************************************************/
bool ClientPollingMgr::ResetClientPolling(bool ForceReset_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetClientPolling");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool NotInClientState_ = !_Parent->IsClientStates(IoState_) &&
                           !IsClientAliveStates(_ClientState);
  bool PollComplete_ = NotInClientState_ && PollClientCompleted_IMPL(true, false);
  bool retval = false;
  ForceReset_ = NotInClientState_ && ForceReset_;

  if ((ForceReset_ || PollComplete_) &&
      _Parent->GetServerAliveFile(WRITE))
  {
    #if CALCLIB_DEBUG9
      SHOWMETHOD(_Parent, ResetPollCycle());
    #else
      ResetPollCycle();
    #endif
    _KeepAlivePollError = false;

    _ServerState = Mcalc_KeepAliveState::IDLE;
    _PrevClientProcess = _ClientPollProcess;
    _ClientPollProcess = INITIALSTATE;

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_KeepAliveState::IDLE;
      retval = SetPollState(_PollState);

      #if CALCLIB_DEBUG9
        _Parent->DbgPtr()->ShowInt(_ClientState, "_ClientState");
        _Parent->DbgPtr()->ShowInt(_ServerState, "_ServerState");
        _Parent->DbgPtr()->ShowInt(_PrevClientProcess, "_PrevClientProcess");
        _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess");
        _Parent->DbgPtr()->ShowInt(retval, "retval");
        _Parent->DbgPtr()->LeaveLevel();
      #endif

      return retval;
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::ResetReceivePoll(bool ForceReset_)
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ResetReceivePoll");
  #endif

  bool retval = true;
  bool ReceiveComplete_ = ServerReceiveCompleted_IMPL(true, false);

  if (ForceReset_ || ReceiveComplete_)
  {
    _ClientState = Mcalc_KeepAliveState::IDLE;

    _PrevServerProcess = _ServerPollProcess;
    _ServerPollProcess = INITIALSTATE;

    if (!_PollState && !_ClientState &&
        _ServerState == Mcalc_KeepAliveState::RESET_POLLING)
    {
      _ServerState = Mcalc_KeepAliveState::IDLE;
      retval = SetServerState(_ServerState);
    }
    else
      _ServerState = Mcalc_KeepAliveState::IDLE;

    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(_ClientState, "_ClientState");
      _Parent->DbgPtr()->ShowInt(_PrevServerProcess, "_PrevServerProcess");
      _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess");
      _Parent->DbgPtr()->ShowInt(true, "retval");

      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return retval;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::ForceResetAllPolling()
{
  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ForceResetAllPolling");
  #endif

  int IoState_ = _Parent->SetNoPolling(true)
                        ->Bare_GetIoState(0);
  bool ForceReset_ = !_Parent->IsClientStates(IoState_) &&
                     !IsClientAliveStates(_ClientState);

  if (ForceReset_ && _Parent->GetServerAliveFile(WRITE))
  {
    ResetPollCycle();
    _KeepAlivePollError = false;

    _ServerState = Mcalc_KeepAliveState::IDLE;
    _PrevClientProcess = _ClientPollProcess;
    _ClientPollProcess = INITIALSTATE;

    _ClientState = Mcalc_KeepAliveState::IDLE;
    _PrevServerProcess = _ServerPollProcess;
    _ServerPollProcess = INITIALSTATE;

    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(_ServerState, "_ServerState");
      _Parent->DbgPtr()->ShowInt(_PrevClientProcess, "_PrevClientProcess");
      _Parent->DbgPtr()->ShowInt(_ClientPollProcess, "_ClientPollProcess");

      _Parent->DbgPtr()->ShowInt(_ClientState, "_ClientState");
      _Parent->DbgPtr()->ShowInt(_PrevServerProcess, "_PrevServerProcess");
      _Parent->DbgPtr()->ShowInt(_ServerPollProcess, "_ServerPollProcess");
    #endif

    if (SetServerState(_ServerState))
    {
      _PollState = Mcalc_KeepAliveState::IDLE;
      #if CALCLIB_DEBUG9
        bool retval = SetPollState(_PollState);
        _Parent->DbgPtr()->ShowInt(retval, "retval");

        _Parent->DbgPtr()->LeaveLevel();
        return retval;
      #else
        return SetPollState(_PollState);
      #endif
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(false, "retval");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::PollClientIfAlive_IMPL(int Sleep_, bool ResponseOnly_)
{
  _AsyncMode = _Parent ? (_Parent->InAsyncMode() ||
                          _Parent->SessionOption()):false;

  #if CALCLIB_DEBUG9
    SetStopTracking(false);
    _Parent->DbgPtr()->EnterLevel("PollClientIfAlive_IMPL");
    _Parent->DbgPtr()->ShowInt(_AsyncMode, "_AsyncMode");
    _Parent->DbgPtr()->ShowMessage(_Parent->GetPollStateFilename());
    _Parent->DbgPtr()->ShowMessage("\n");
  #endif

  if (!_AsyncMode || !_Parent->GetPollStateFilename())
  {
    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return false;
  }

  // poll to check if calculator client is alive here
  if (PollClientRequired(Sleep_, ResponseOnly_))
  {
    bool RetryPoll_ = false;
    bool ClientResponse_ = _PollState == Mcalc_PollState::CLIENT_RESPONSE;
    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(ClientResponse_, "ClientResponse_");
    #endif

    if (AtInitialState())
    {
      SetNewPollCycle();
      return SendPollClientSignal();
    }
    else if (ClientResponse_ && !ServerAcked())
    {
      if (ClientIsAlive())
      {
        #if CALCLIB_DEBUG9
          if (_Backup && _Backup->_RetryPollCount+1 == _RetryPollCount &&
              _Parent->DbgPtr() && _Parent->DbgPtr()->StopTracking())
          {
            SetStopTracking(false);
            _Parent->DbgPtr()->EnterLevel("PollClientIfAlive_IMPL");
            _Parent->DbgPtr()->ShowInt(ClientResponse_, "ClientResponse_");
            ClientIsAlive();
          }
        #endif

        ConfirmClientAlive();
        ConfirmServerAlive(true);
        return SendServerAckClientSignal();
      }
      else
      {
        _KeepAlivePollError = true;
        RetryPoll_ = ReAttemptPolling();
        #if CALCLIB_DEBUG9
          _Parent->DbgPtr()->LeaveLevel();
        #endif

        #if CALCLIB_DEBUG10
          if (_Backup)
            SetStopTracking(true);
        #endif

        if (!RetryPoll_ && _ExitAtRetryMax)
          _Parent->ShowClientPollFailed(true);
        else
          return RetryPoll_;
      }
    }
    else if (ResetRequested() && ServerAcked())
    {
      #if CALCLIB_DEBUG9
        if (_Backup && _Parent->DbgPtr() &&
            _Parent->DbgPtr()->StopTracking())
        {
          SetStopTracking(false);
          _Parent->DbgPtr()->EnterLevel("PollClientIfAlive_IMPL");
          _Parent->DbgPtr()->ShowInt(ClientResponse_, "ClientResponse_");
          ResetRequested();
          ServerAcked();
        }
      #endif

      return ResetPolling();
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  #if CALCLIB_DEBUG10
    if (_Backup)
      SetStopTracking(true);
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::ReceiveKeepAlivePoll_IMPL(int Sleep_)
{
  _AsyncMode = _Parent ? (_Parent->InAsyncMode() ||
                          _Parent->SessionOption()):false;

  #if CALCLIB_DEBUG9
    SetStopTracking(false);
    _Parent->DbgPtr()->EnterLevel("ReceiveKeepAlivePoll_IMPL");
    _Parent->DbgPtr()->ShowInt(_AsyncMode, "_AsyncMode");
    _Parent->DbgPtr()->ShowMessage(_Parent->GetPollStateFilename());
    _Parent->DbgPtr()->ShowMessage("\n");
  #endif

  if (!_AsyncMode || !_Parent->GetPollStateFilename())
  {
    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return false;
  }

  // receive check alive poll from calculator client here
  if (ServerReceiveRequired(Sleep_))
  {
    bool ClientPolling_ = _ClientState == Mcalc_KeepAliveState::POLL_SERVERALIVE;
    #if CALCLIB_DEBUG9
      _Parent->DbgPtr()->ShowInt(ClientPolling_, "ClientPolling_");
    #endif

    if (ClientAcked())
    {
      #if CALCLIB_DEBUG9
        if (_Backup && _Parent->DbgPtr() &&
            _Parent->DbgPtr()->StopTracking())
        {
          SetStopTracking(false);
          _Parent->DbgPtr()->EnterLevel("ReceiveKeepAlivePoll_IMPL");
          _Parent->DbgPtr()->ShowInt(ClientPolling_, "ClientPolling_");
          ClientAcked();
        }
      #endif

      ConfirmClientAlive(true);
      ConfirmServerAlive();
      return SendResetPollingSignal();
    }
    else if (ClientPolling_)
    {
      if (!ServerIsAlive())
      {
        AcceptPollCycle();
        return SendServerAliveSignal();
      }
      else
      {
        #if CALCLIB_DEBUG10
          if (_Backup)
            SetStopTracking(true);
        #endif

        #if CALCLIB_DEBUG9
          _Parent->DbgPtr()->LeaveLevel();
        #endif
        return true;
      }
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  #if CALCLIB_DEBUG10
    if (_Backup)
      SetStopTracking(true);
  #endif

  return false;
}

/****************************************************************************/
bool ClientPollingMgr::PollClientIfAlive(int Sleep_,
                                         bool UntilEnd_, bool ResponseOnly_)
{
  if (_Backup)
  {
    SetStopTracking(!UntilEnd_ || ResponseOnly_);
    *_Backup = *this;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("PollClientIfAlive");
  #endif

  bool PollOk_ = true;
  long LoopGuard_ = 0;
  long Max = LOOP_GUARD_LIMIT;

  int mult_ = 0;
  int PrevAttempt_;

  bool PollingClient_ = false;
  bool PollAnswered_ = false;
  bool PollError_ = false;
  bool PollRetVal_ = false;
  bool InProcess_ = PollClientInProcess();
  bool ResetOnNotReq_ = _ResetWhenNotReq;

  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
  #endif

  ResetClientPolling(UntilEnd_ || !InProcess_);

  for (LoopGuard_ = UntilEnd_ ? Max:1;
       LoopGuard_ && PollOk_ && PollClientRequired(0, ResponseOnly_);
       LoopGuard_--)
  {
    PrevAttempt_ = _RetryPollCount;
    PollOk_ = PollClientIfAlive_IMPL(Sleep_, ResponseOnly_);
    #if CALCLIB_TESTMOCKCLIENT
      if (!PollClientCompleted(true))
        _Parent->NotifyParent(PollOk_, true);
    #endif
    GivePollResults(PollingClient_, PollError_, PollAnswered_);
    ResponseOnly_ = true;

    if (PollOk_ && PollError_)
    {
      if (_BreakOnPollError)
      {
        SetStopTracking(true);
        break;
      }
      else if (Sleep_)
      {
        mult_ = (Sleep_ > 1) ? Sleep_:1;

        #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
          Sleep(mult_ * DelayLen_);
        #else
          ::usleep(mult_ * DelayLen_);
        #endif
      }
      else if (_RetryPollCount != PrevAttempt_ && _KeepAlivePollError)
      {
        Sleep_ = 1;
        SetStopTracking(true);

        if (_Backup)
        {
          *_Backup = *this;
          _Backup->_RetryPollCount = PrevAttempt_;
        }
      }
    }
    else
    {
      #if CALCLIB_DEBUG10
        SetTrackingOnStateChange(ResetOnNotReq_);
      #endif

      if (PollClientCompleted(false))
        break;
    }
  }

  PollRetVal_ = PollOk_ && PollClientCompleted(true);

  if (_ResetStatesOnDone || _KeepAlivePollError)
  {
    if (PollClientNotRequired(false))
    {
      SetStopTracking(true);
      ResetClientPolling(UntilEnd_);
    }
    else if (PollRetVal_)
    {
      SetStopTracking(true);
      ResetClientPolling(false);
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(PollRetVal_, "PollRetVal_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return PollRetVal_;
}

/****************************************************************************/
bool ClientPollingMgr::ReceiveKeepAlivePoll(int Sleep_, bool UntilEnd_)
{
  if (_Backup)
  {
    SetStopTracking(!UntilEnd_);
    *_Backup = *this;
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->EnterLevel("ReceiveKeepAlivePoll");
  #endif

  bool PollOk_ = true;
  bool PollRetVal_ = false;
  bool InProcess_ = ServerReceiveInProcess();
  bool ResetOnNotReq_ = _ResetWhenNotReq;

  long LoopGuard_ = 0;
  long Max = LOOP_GUARD_LIMIT;

  ResetReceivePoll(UntilEnd_ || !InProcess_);

  for (LoopGuard_ = UntilEnd_ ? Max:1;
       LoopGuard_ && PollOk_ && ServerReceiveRequired();
       LoopGuard_--)
  {
    PollOk_ = ReceiveKeepAlivePoll_IMPL(Sleep_);
    #if CALCLIB_TESTMOCKCLIENT
      if (!ServerReceiveCompleted(true))
        _Parent->NotifyParent(PollOk_, false);
    #endif

    #if CALCLIB_DEBUG10
      SetTrackingOnStateChange(ResetOnNotReq_);
    #endif

    if (ServerReceiveCompleted(false))
      break;
  }

  PollRetVal_ = PollOk_ && ServerReceiveCompleted(true);

  if (_ResetStatesOnDone || _KeepAlivePollError)
  {
    if (ServerReceiveNotRequired(false))
    {
      SetStopTracking(true);
      ResetReceivePoll(UntilEnd_);
    }
    else if (PollRetVal_)
    {
      SetStopTracking(true);
      ResetReceivePoll(false);
    }
  }

  #if CALCLIB_DEBUG9
    _Parent->DbgPtr()->ShowInt(PollRetVal_, "PollRetVal_");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return PollRetVal_;
}

/****************************************************************************/
void ClientPollingMgr::ResetRetryRead()
{
  _RetryReadCount = 0;
}

/****************************************************************************/
bool ClientPollingMgr::AtMaxReadAttempts() const
{
  return (_RetryReadCount >= RETRY_READ_MAX);
}

/****************************************************************************/
bool ClientPollingMgr::ReAttemptFileRead()
{
  if (_RetryReadCount < RETRY_READ_MAX)
    _RetryReadCount++;
  else if (_RetryReadCount == RETRY_READ_MAX)
    return false;

  return true;
}

/****************************************************************************/
void ClientPollingMgr::ResetPollCount()
{
  _RetryPollCount = 0;
}

/****************************************************************************/
bool ClientPollingMgr::AtMaxPollAttempts() const
{
  return (_RetryPollCount >= RETRY_READ_MAX);
}

/****************************************************************************/
bool ClientPollingMgr::ReAttemptPolling()
{
  if (_KeepAlivePollError && _RetryPollCount < RETRY_READ_MAX)
  {
    _RetryPollCount++;
    return (_RetryPollCount < RETRY_READ_MAX);
  }
  else if (_RetryPollCount >= RETRY_READ_MAX)
    return false;

  return true;
}

/****************************************************************************/
bool ClientPollingMgr::ClientPollingAllowed() const
{
  return _AllowPollClient;
}

/****************************************************************************/
bool ClientPollingMgr::ConfirmedClientAlive() const
{
  return _ConfirmedClientAlive;
}

/****************************************************************************/
bool ClientPollingMgr::ConfirmedServerAlive() const
{
  return _ConfirmedServerAlive;
}

/****************************************************************************/
bool ClientPollingMgr::ClientAliveConfirmedSent() const
{
  return _ClientAliveConfSent;
}

/****************************************************************************/
bool ClientPollingMgr::ExitAtRetryMax() const
{
  return _ExitAtRetryMax;
}

/****************************************************************************/
bool ClientPollingMgr::SleepWaiting() const
{
  return _SleepWaiting;
}

/****************************************************************************/
bool ClientPollingMgr::WaitUntilResponse() const
{
  return _WaitUntilResponse;
}

/****************************************************************************/
MEMORYOPS_DEFN(CalcIoStateHandler)
MEMORYOPS_DEFN(ClientPollingMgr)

/****************************************************************************/
// MockClientConIO class definitions
/****************************************************************************/
MockClientConIO::MockClientConIO(CalculatorBase* Basep_):
_Basep(Basep_),
_InputFile(NULL),
_IoState(_Basep->CurrentIoState()),
_PrevSetState(0),
_RetToClientCount(0),
_ResetOutputFetchCnt(0),
_ResetProcessDoneCnt(0),
_ResetInputOptionalCnt(0),
_ResetProcessRequiredCnt(0),
_Halted(_Basep->CurrentIoState() == Mcalc_IOState::CALC_HALT),
_ZeroLenInputStr(true),
_PrevStateSetDone(false),
_NewDataWritten(false),
_InBatchFile(false),
_ProcessRequired(false),
_InputOptional(false),
_InBatchInput(false),
_OutputFetched(false),
_ProcessDone(false),
_HasPrompt(false),
_OutputShown(false),
_StateChanged(false),
_WriteToFileDone(false),
_EmptyLineWritten(false),
_SignalSent(false),
_OutputWasShown(false),
_InitialInput(false),
_Buffer((char*)::RawCallocateWith(MEMMATRIX, 1024))
{
  _Basep->GetUserInputFile(true, true);
  _InputFile = _Basep->GiveFileStatus(Mcalc_IOType::UserInput);
}

/****************************************************************************/
MockClientConIO::~MockClientConIO()
{
  ::RawDeleteArray(_Buffer);
  _Buffer = NULL;
}

/*****************************************************************************/
bool MockClientConIO::ProcessingRequired(int CurrState_, int* CondBranch_)
{
  // IDLE_STATE          --> PROCESS
  // CALC_RESPONSE       --> PROCESS
  //   CALC_RESPONSE     --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // INPUT_RECEIVED      --> PROCESS
  // OUTPUT_FETCHED      --> PROCESS
  // CALC_ERROR          --> PROCESS
  //   CALC_ERROR        --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // ERROR_FETCH         --> PROCESS
  //   ERROR_FETCH       --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // BREAK_PROGRAM       --> PROCESS
  // BATCHFILE_ENDED_ACK --> PROCESS
  // PROCESS_DONE        --> PROCESS_DONE_ACK

  // if In Batch File:
  //   INPUT_RECEIVED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   OUTPUT_FETCHED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BREAK_PROGRAM       --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BATCHFILE_ENDED_ACK --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE

  // INPUT_REQUIRED      --> INPUT_RECEIVED (Empty Response Optional)
  // GRAPH_WAIT          --> INPUT_RECEIVED (Empty Response Optional)

  // OUTPUT_READY        --> OUTPUT_FETCHED
  // GRAPH_OUTPUT        --> OUTPUT_FETCHED

  // PROCESS_DONE        --> PROCESS_DONE_ACK
  // PROCESS_DONE_ACK    --> INPUT_REQUIRED|OUPTUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE

  bool Required_ = false;
  bool InInput_ = false;
  bool Optional_ = false;
  bool Fetched_ = false;
  bool ProcDone_ = false;
  bool Matched_ = false;

  _InBatchFile = _Basep->InBatchFile();

  if (CurrState_ == Mcalc_IOState::CALC_HALT ||
      CurrState_ == Mcalc_IOState::ERROR_FETCH ||
      CurrState_ == Mcalc_IOState::CLIENTPING ||
      CurrState_ == Mcalc_IOState::OUTPUT_READY ||
      CurrState_ == Mcalc_IOState::PROCESS_DONE ||
      CurrState_ == Mcalc_IOState::BATCHFILE_ENDED ||
      CurrState_ == Mcalc_IOState::SPAWN_NEW_MCALC ||
      CurrState_ == Mcalc_IOState::GRAPH_WAIT ||
      CurrState_ == Mcalc_IOState::GRAPH_WAIT_ACK ||
      CurrState_ == Mcalc_IOState::GRAPH_PROGRESS ||
      CurrState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK ||
      CurrState_ == Mcalc_IOState::GRAPH_OUTPUT ||
      CurrState_ == Mcalc_IOState::PROGRESS_READY ||
      CurrState_ == Mcalc_IOState::INFILE_PROGRESS_ACK ||
      CurrState_ == Mcalc_IOState::INPUT_REQUIRED)
  {
    Required_ = false;
    InInput_ = false;
    Optional_ = CurrState_ == Mcalc_IOState::GRAPH_WAIT ||
                CurrState_ == Mcalc_IOState::INPUT_REQUIRED;
    Fetched_ =  CurrState_ == Mcalc_IOState::OUTPUT_READY ||
                CurrState_ == Mcalc_IOState::GRAPH_OUTPUT;
    ProcDone_ = CurrState_ == Mcalc_IOState::PROCESS_DONE;

    if (!_PrevStateSetDone)
    {
      _PrevSetState = CurrState_;
      _PrevStateSetDone = true;
    }

    if (CondBranch_)
      *CondBranch_ = 1;
  }
  else if (CurrState_ == Mcalc_IOState::IDLE_STATE ||
           CurrState_ == Mcalc_IOState::CALC_RESPONSE ||
           CurrState_ == Mcalc_IOState::INPUT_RECEIVED ||
           CurrState_ == Mcalc_IOState::OUTPUT_FETCHED ||
           CurrState_ == Mcalc_IOState::CALC_ERROR ||
           CurrState_ == Mcalc_IOState::ERROR_FETCH ||
           CurrState_ == Mcalc_IOState::BREAK_PROGRAM ||
           CurrState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
           CurrState_ == Mcalc_IOState::MCALC_SPAWNED ||
           CurrState_ == Mcalc_IOState::PROCESS_DONE_ACK ||
           CurrState_ == Mcalc_IOState::PROCESS)
  {
    // Mcalc_IOState::PROCESS will be set
    // Empty Input Disallowed
    if (CondBranch_)
      *CondBranch_ = 2;

    InInput_ = _InBatchFile &&
               (CurrState_ == Mcalc_IOState::CALC_RESPONSE ||
                CurrState_ == Mcalc_IOState::CALC_ERROR ||
                CurrState_ == Mcalc_IOState::ERROR_FETCH ||
                CurrState_ == Mcalc_IOState::PROCESS);
    Matched_ = _Basep->IsMatchingStates(_InBatchFile, _PrevSetState, CurrState_);

    Required_ = !_InBatchFile || (!InInput_ && !Matched_);
    Optional_ = false;
    Fetched_ = false;

    if (!_PrevStateSetDone)
    {
      _PrevSetState = CurrState_;
      _PrevStateSetDone = true;
    }
  }

  _InBatchInput = InInput_;
  _ProcessRequired = Required_;
  _InputOptional = Optional_;
  _OutputFetched = Fetched_;
  _ProcessDone = ProcDone_;

  return _ProcessRequired;
}

/*****************************************************************************/
bool MockClientConIO::WriteToInput(int CurrState_, bool ReOpenFiles_)
{
  bool done = false;
  bool InBatchFile_ = false;

  int FileOk_ = 0;
  int CondBranch_ = 0;

  _InBatchInput = false;
  _ProcessRequired = false;

  if (!_InputFile || _Basep->UserInputMode() == CalculatorBase::READ)
  {
    _Basep->GetUserInputFile(true, true);
    _InputFile = _Basep->GiveFileStatus(Mcalc_IOType::UserInput, &FileOk_);

    if (!FileOk_)
    {
      _InputFile = NULL;
      _Basep->CloseUserInputFile(true);
      return false;
    }
  }

  if (_InputFile)
  {
    if (CalculatorBase::icasestrcomp(_InputEntered.c_str(), "break", true) ||
        CalculatorBase::icasestrcomp(_InputEntered.c_str(), "quit", true))
    {
      // Empty Input Allowed
      _ProcessRequired = false;
      _InBatchInput = false;
      _NewDataWritten = !_InputStrWritten.IsEmpty() &&
                        _InputStrWritten != _InputEntered;

      done = true;
      fputs(_InputEntered.c_str(), _InputFile);
      fputc(MATHSTATEMENT_TERMCHAR, _InputFile);
      fflush(_InputFile);

      _WriteToFileDone = true;
      _InputStrWritten = _InputEntered;
      _EmptyLineWritten = _InputStrWritten.IsEmpty();
      _ZeroLenInputStr = _EmptyLineWritten;
    }
    else
    {
      ProcessingRequired(CurrState_, &CondBranch_);

      if (CondBranch_ == 1)
      {
        // Empty Input Allowed
        _NewDataWritten = !_InputStrWritten.IsEmpty() &&
                          _InputStrWritten != _InputEntered;

        done = true;
        fputs(_InputEntered.c_str(), _InputFile);
        fputc(MATHSTATEMENT_TERMCHAR, _InputFile);
        fflush(_InputFile);

        _WriteToFileDone = true;
        _InputStrWritten = _InputEntered;
        _EmptyLineWritten = _InputStrWritten.IsEmpty();
        _ZeroLenInputStr = _EmptyLineWritten;
      }
      else if (CondBranch_ == 2)
      {
        // Mcalc_IOState::PROCESS will be set
        // Empty Input Disallowed
        _NewDataWritten = !_InputStrWritten.IsEmpty() &&
                          _InputStrWritten != _InputEntered;

        done = !_ProcessRequired || !_InputEntered.IsEmpty();
        _WriteToFileDone = done && !_InBatchInput;

        if (_WriteToFileDone)
        {
          fputs(_InputEntered.c_str(), _InputFile);
          fputc(MATHSTATEMENT_TERMCHAR, _InputFile);
          fflush(_InputFile);

          _InputStrWritten = _InputEntered;
          _EmptyLineWritten = _InputStrWritten.IsEmpty();
          _ZeroLenInputStr = _EmptyLineWritten;
        }
      }
    }

    _Basep->CloseUserInputFile(true);
    _InputFile = NULL;
    InBatchFile_ = _Basep->ExecInputFileData() &&
                   !_Basep->AckPostExecInputFileData() && _Basep->ExecInputFileDataCnt();

    if (ReOpenFiles_ && !InBatchFile_)
      _Basep->GetUserInputFile(true, false);
  }

  if (!_PrevStateSetDone)
  {
    _PrevSetState = CurrState_;
    _PrevStateSetDone = true;
  }

  return done;
}

/****************************************************************************/
void MockClientConIO::SetCurrState(int NewState_, bool CheckNew_)
{
  int PrevState_ = _IoState;
  bool ResponseOk_ = !CheckNew_ ||
                     (_PrevSetState != NewState_ || PrevState_ != NewState_);
  _StateChanged = _PrevSetState == 0 ||
                  _PrevSetState != PrevState_;

  if (CheckNew_ &&
      PrevState_ != NewState_ &&
      _StateChanged && ResponseOk_)
    _PrevStateSetDone = false;
  else if (!CheckNew_ && NewState_)
  {
    _IoState = NewState_;
    _StateChanged = PrevState_ != NewState_;

    if (_StateChanged)
      _PrevStateSetDone = false;
  }

  if (!_PrevStateSetDone && _StateChanged && ResponseOk_)
  {
    _PrevSetState = PrevState_;
    _IoState = NewState_;
    _PrevStateSetDone = true;
  }
}

/****************************************************************************/
void MockClientConIO::CheckVars(bool GetState_, int CurrState_)
{
  if (GetState_)
    SetCurrState(_Basep->Bare_GetIoState(0), false);
  else
    SetCurrState(CurrState_, false);

  _Halted = _IoState == Mcalc_IOState::CALC_HALT ||
            _IoState == Mcalc_IOState::BREAK_PROGRAM;

  _InBatchFile = false;
  _ProcessRequired = false;
  _InBatchInput = false;
  _HasPrompt = false;

  ShowNewState();
}

/****************************************************************************/
bool MockClientConIO::GetInitialClientInput()
{
  int CurrState_ = _Basep ? _Basep->CurrentIoState():
                            Mcalc_IOState::IDLE_STATE;
  bool ValidState_ = CurrState_ != 0;

  CheckVars(!ValidState_, CurrState_);

  strcpy(_Buffer, MOCKCIOPROMPT_INITIAL);
  ProcessingRequired(_IoState);
  _InputPrompt = _Buffer;
  _Basep->UseDefaultOutputFnc(_Buffer);

  do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
  while (!strlen(_Buffer) || _Buffer[0] == '\n');

  _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
  _InputEntered = _Buffer;
  _Basep->DisplayToLog(_InputEntered.c_str());
  _Basep->DisplayToLog("\n");
  _InitialInput = true;

  return WriteToInput(_IoState, true);
}

/****************************************************************************/
void MockClientConIO::ShowNewState()
{
  if (_StateChanged)
  {
    sprintf(_Buffer, MOCKCIOPROMPT_NOINPUT,
            _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

    _Basep->UseDefaultOutputFnc(_Buffer);
    _Basep->DisplayToLog(_Buffer);
    _StateChanged = false;
  }
}

/****************************************************************************/
bool MockClientConIO::UpdateClientIoState(int CurrState_)
{
  if (SignalSent())
  {
    SetCurrState(CurrState_, false);
    _Halted = _IoState == Mcalc_IOState::CALC_HALT ||
              _IoState == Mcalc_IOState::BREAK_PROGRAM;
    ShowNewState();

    return _PrevStateSetDone;
  }

  return false;
}

/****************************************************************************/
bool MockClientConIO::ProcessClientIoState(int CurrState_, bool& SignalSent_,
                                           int ExpectedState_, int ResponseState_)
{
  bool ValidState_ = CurrState_ != 0;
  bool InputDone_ = false;
  bool InputNeeded_ = false;
  bool DoExit_ = false;

  _SignalSent =
  SignalSent_ = false;
  CheckVars(!ValidState_, CurrState_);

  if (_IoState == Mcalc_IOState::PROCESS ||
      _IoState == Mcalc_IOState::BREAK_PROGRAM ||
      _IoState == Mcalc_IOState::CALC_HALT)
  {
    DoExit_ = (!_Basep->ZeroLenInput() && !_ZeroLenInputStr) || _Halted;
    InputNeeded_ = _InputEntered.IsEmpty() || _RetToClientCount ||
                   _InputEntered != _InputStrWritten;

    if (!DoExit_ || !_Basep->ReadUserInputAttemptLoopGuardTicked())
    {
      _HasPrompt = true;
      _OutputShown = false;

      sprintf(_Buffer, MOCKCIOPROMPT_NOINPUT,
              _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

      _Basep->UseDefaultOutputFnc(_Buffer);
      _Basep->DisplayToLog(_Buffer);
      _InputPrompt = _Buffer;
    }

    if (DoExit_)
    {
      ProcessingRequired(_IoState);

      if (InputNeeded_)
      {
        if (_RetToClientCount || (!_InBatchInput && ProcessRequired() &&
            !_Halted && !_Basep->ReadUserInputAttemptLoopGuardTicked()))
        {
          _InputPrompt = _Buffer;
          _Basep->UseDefaultOutputFnc(_Buffer);

          do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
          while (!strlen(_Buffer) || _Buffer[0] == '\n');

          _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
          _InputEntered = _Buffer;
          _Basep->DisplayToLog(_InputEntered.c_str());
          _Basep->DisplayToLog("\n");
          _RetToClientCount = 0;
          _InitialInput = false;
        }

        if (!_InputEntered.IsEmpty())
          InputDone_ = WriteToInput(_IoState, true);
      }
      else
      {
        if (!_PrevStateSetDone)
        {
          _PrevSetState = _IoState;
          _PrevStateSetDone = true;
        }

        if (_InputEntered == _InputStrWritten)
          ++_RetToClientCount;

        InputNeeded_ = _RetToClientCount &&
                       (_InputEntered.IsEmpty() ||
                        _InputEntered != _InputStrWritten);

        if (_ResetProcessRequiredCnt && InputNeeded_)
          return ProcessClientIoState(CurrState_, SignalSent_,
                                      ExpectedState_, ResponseState_);
        else
          return ValidState_;
      }
    }
  }

  if (_IoState == ExpectedState_)
  {
    if (ResponseState_)
    {
      _Basep->Bare_SetIoState(ResponseState_, true);
      SetCurrState(_Basep->GetIoState(0), true);
      ShowNewState();
    }

    _SignalSent =
    SignalSent_ = true;
  }

  if (_IoState == Mcalc_IOState::BREAK_PROGRAM)
  {
    strcpy(_Buffer, "break");
    _InputEntered = _Buffer;

    if (!_PrevStateSetDone)
    {
      _PrevSetState = _IoState;
      _PrevStateSetDone = true;
    }

    return true;
  }
  else if (_IoState == Mcalc_IOState::CALC_HALT)
  {
    strcpy(_Buffer, "quit");
    _InputEntered = _Buffer;

    if (!_PrevStateSetDone)
    {
      _PrevSetState = _IoState;
      _PrevStateSetDone = true;
    }

    return true;
  }
  else if (!InputDone_ && SignalSent_)
  {
    _HasPrompt = true;
    _OutputShown = false;

    sprintf(_Buffer, MOCKCIOPROMPT,
            _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

    _InputPrompt = _Buffer;
    ProcessingRequired(_IoState);

    if (!_InBatchInput && (ProcessRequired() || InputOptional()))
    {
      _Basep->UseDefaultOutputFnc(_Buffer);
      _Basep->DisplayToLog(_Buffer);
      _Basep->DisplayToLog("\n");

      if (InputOptional())
        _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE);
      else
      {
        do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
        while (!strlen(_Buffer) || _Buffer[0] == '\n');
      }

      _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
      _InputEntered = _Buffer;
      _Basep->DisplayToLog(_InputEntered.c_str());
      _Basep->DisplayToLog("\n");
      _InitialInput = false;
    }
    else if (ProcessAckReceived())
      DisplayOriginalStr();

    if (!_InputEntered.IsEmpty())
      InputDone_ = WriteToInput(_IoState, true);
    else if (SignalSent_)
      InputDone_ = true;
  }

  if (!_PrevStateSetDone)
  {
    _PrevSetState = _IoState;
    _PrevStateSetDone = true;
  }

  return InputDone_;
}

/****************************************************************************/
bool MockClientConIO::ProcessClientOutputStates(int CurrState_, bool& SignalSent_,
                                                int ExpectedState_, int ResponseState_)
{
  bool ValidState_ = CurrState_ != 0;
  bool InputDone_ = false;

  _SignalSent =
  SignalSent_ = false;
  CheckVars(!ValidState_, CurrState_);

  if (_IoState == ExpectedState_)
  {
    if (ResponseState_)
    {
      _Basep->Bare_SetIoState(ResponseState_, true);
      SetCurrState(_Basep->GetIoState(0), true);
      ShowNewState();
    }

    _SignalSent =
    SignalSent_ = true;
  }

  if (SignalSent_)
  {
    _HasPrompt = true;
    _OutputShown = false;

    sprintf(_Buffer, MOCKCIOPROMPT,
            _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

    _InputPrompt = _Buffer;
    ProcessingRequired(_IoState);

    if (!InBatchInput() && (ProcessRequired() || InputOptional()))
    {
      _Basep->UseDefaultOutputFnc(_Buffer);
      _Basep->DisplayToLog(_Buffer);
      _Basep->DisplayToLog("\n");

      if (InputOptional())
        _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE);
      else
      {
        do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
        while (!strlen(_Buffer) || _Buffer[0] == '\n');
      }

      _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
      _InputEntered = _Buffer;
      _Basep->DisplayToLog(_InputEntered.c_str());
      _Basep->DisplayToLog("\n");
      _InitialInput = false;
    }
    else if (ProcessAckReceived())
      DisplayOriginalStr();

    if (!_InputEntered.IsEmpty())
      InputDone_ = WriteToInput(_IoState, true);
    else if (SignalSent_)
      InputDone_ = true;
  }

  if (!_PrevStateSetDone)
  {
    _PrevSetState = _IoState;
    _PrevStateSetDone = true;
  }

  return InputDone_;
}

/****************************************************************************/
bool MockClientConIO::ProcessClientOutputExtStates(int CurrState_, bool& SignalSent_,
                                                   int ExpectedState_, int ResponseState_)
{
  bool ValidState_ = CurrState_ != 0;
  bool InputDone_ = false;
  bool InputAnswered_ = false;

  _SignalSent =
  SignalSent_ = false;
  CheckVars(!ValidState_, CurrState_);

  if (_IoState == ExpectedState_)
  {
    if (ResponseState_)
    {
      _Basep->Bare_SetIoState(ResponseState_, true);
      SetCurrState(_Basep->GetIoState(0), true);
      ShowNewState();
    }

    _SignalSent =
    SignalSent_ = true;
  }

  if (SignalSent_)
  {
    _HasPrompt = true;
    _OutputShown = false;

    sprintf(_Buffer, MOCKCIOPROMPT,
            _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

    _InputPrompt = _Buffer;
    ProcessingRequired(_IoState);

    if (ProcessRequired() || InputOptional())
    {
      _SignalSent =
      SignalSent_ = false;

      _Basep->UseDefaultOutputFnc(_Buffer);
      _Basep->DisplayToLog(_Buffer);
      _Basep->DisplayToLog("\n");

      if (InputOptional() || InBatchFile())
        _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE);
      else
      {
        do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
        while (!strlen(_Buffer) || _Buffer[0] == '\n');
      }

      _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
      _InputEntered = _Buffer;
      _Basep->DisplayToLog(_InputEntered.c_str());
      _Basep->DisplayToLog("\n");
      _InitialInput = false;
    }
    else if (ProcessAckReceived())
      DisplayOriginalStr();

    if (!_InputEntered.IsEmpty())
    {
      InputDone_ = WriteToInput(_IoState, true);

      if (InputDone_)
        _SignalSent =
        SignalSent_ = true;
    }

    if (!InputDone_)
    {
      if (OutputFetched() || ProcessDone() || InputOptional())
        SignalSent_ = true;

      if (InputOptional())
      {
        _Basep->Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
        InputAnswered_ = true;
      }
      else if (OutputFetched())
        _Basep->Bare_SetIoState(Mcalc_IOState::OUTPUT_FETCHED, true);
      else if (ProcessDone())
      {
        _Basep->Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
        InputAnswered_ = true;
      }

      SetCurrState(_Basep->GetIoState(0), false);
      ShowNewState();

      if (SignalSent_)
        _SignalSent = true;
    }

    if (!(InputDone_ || InputAnswered_) && SignalSent_)
    {
      _HasPrompt = true;
      _OutputShown = false;

      sprintf(_Buffer, MOCKCIOPROMPT,
              _Basep->IoStateToStr(_PrevSetState), _Basep->IoStateToStr(_IoState));

      _InputPrompt = _Buffer;
      ProcessingRequired(_IoState);

      if (!InBatchInput() && (ProcessRequired() || InputOptional()))
      {
        _SignalSent =
        SignalSent_ = false;

        _Basep->UseDefaultOutputFnc(_Buffer);
        _Basep->DisplayToLog(_Buffer);
        _Basep->DisplayToLog("\n");

        if (InputOptional())
          _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE);
        else
        {
          do { _Buffer = _Basep->UseDefaultInputFnc(_Buffer, INPUT_BUFFER_SIZE); }
          while (!strlen(_Buffer) || _Buffer[0] == '\n');
        }

        _Buffer = ::RemovePadding(_Buffer, " \n\r\t");
        _InputEntered = _Buffer;
        _Basep->DisplayToLog(_InputEntered.c_str());
        _Basep->DisplayToLog("\n");
        _InitialInput = false;

        if (!_InputEntered.IsEmpty() &&
            !InputAnswered_ && !InputDone_)
        {
          InputDone_ = WriteToInput(_IoState, true);

          if (InputDone_)
            _SignalSent =
            SignalSent_ = true;

          return InputDone_;
        }
      }
      else if (ProcessAckReceived())
        DisplayOriginalStr();

      if (!_InputEntered.IsEmpty() &&
          !InputAnswered_ && !InputDone_)
        return WriteToInput(_IoState, true);
      else if (InputDone_ || SignalSent_)
        InputAnswered_ = true;
    }
  }

  if (!_PrevStateSetDone)
  {
    _PrevSetState = _IoState;
    _PrevStateSetDone = true;
  }

  return (InputDone_ || InputAnswered_);
}

/****************************************************************************/
void MockClientConIO::DisplayStr(const char* Str_, const char* Prefix_)
{
  if (HasPrompt() && !(Str_ && strlen(Str_) && (!OutputShown() || Prefix_)))
    return;

  char* buffer = NULL;
  char* FormatStr_ = NULL;
  const char* DispStr_ = (Str_ && strlen(Str_)) ? Str_:NULL;
  int slen = 0;
  size_t FmtStrSz_ = 128;

  buffer = (char*)_Basep->allocmem(INPUT_BUFFER_SIZE, sizeof(char), buffer);
  FormatStr_ = (char*)_Basep->allocmem(FmtStrSz_, sizeof(char), FormatStr_);

  if (HasPrompt())
    strcpy(FormatStr_, GivePrompt().c_str());
  else
    strcpy(FormatStr_, "output>> ");

  slen = strlen(FormatStr_);
  FormatStr_[slen-1] = DispStr_ ? ' ':'\n';

  if (DispStr_)
  {
    if (Prefix_)
      strcat(FormatStr_, Prefix_);

    strcat(FormatStr_, "%s\n");
  }

  if (DispStr_)
    sprintf(buffer, FormatStr_, DispStr_);
  else
    strcpy(buffer, FormatStr_);

  if (!HasPrompt() || (DispStr_ && (!OutputShown() || Prefix_)))
  {
    _Basep->UseDefaultOutputFnc(buffer);
    _Basep->DisplayToLog(buffer);

    _OutputStrShown = DispStr_ ? DispStr_:"";
    ResetOutputWasShown();

    if (HasPrompt() && ::SafeStrLen(DispStr_))
      SetOutputShown(true);
  }

  ::RawDeleteArray(FormatStr_);
  ::RawDeleteArray(buffer);
}

/****************************************************************************/
void MockClientConIO::DisplayOriginalStr()
{
  if (_Basep)
    DisplayStr(_Basep->OriginalStr(), "Original:");
}

/****************************************************************************/
void MockClientConIO::ShowCalcTimeoutState(FILE* Fptr_,
                                           const char* From_, int State_, double Msecs_)
{
  int Iostate_ = _Basep->CurrentIoState();

  #if CALCLIB_DEBUG13c
    if (Fptr_)
      sprintf(_Buffer, CALCGUIPROMPT_ELAPSEDTIME,
              From_, _Basep->IoStateToStr(Iostate_),
              _Basep->TimeoutStateToStr(State_), Msecs_);
    else
      sprintf(_Buffer, CALCGUIPROMPT_NULLFILEPTR);

    _Basep->DisplayToLog(_Buffer);
  #else
    if (Fptr_)
      sprintf(_Buffer, CALCGUIPROMPT_ELAPSEDTIME,
              From_, _Basep->IoStateToStr(Iostate_),
              _Basep->TimeoutStateToStr(State_), Msecs_);
    else
      sprintf(_Buffer, CALCGUIPROMPT_NULLFILEPTR);

    _Basep->UseDefaultOutputFnc(_Buffer);
  #endif
}

/****************************************************************************/
void MockClientConIO::DisplayAnswerStr()
{
  if (_Basep)
    DisplayStr(_Basep->AnswerStr());
}

/****************************************************************************/
void MockClientConIO::ShowOutputStr(bool ShowOnce_)
{
  if (_Basep && _OutputStrShown.strlen() && !_OutputWasShown)
  {
    _Basep->UseDefaultOutputFnc(_OutputStrShown.c_str());

    if (ShowOnce_)
      _OutputWasShown = true;
  }
}

/****************************************************************************/
void MockClientConIO::ResetClientIo()
{
  _HasPrompt = !_InputPrompt.IsEmpty();
  _OutputShown = false;
}

/****************************************************************************/
void MockClientConIO::ResetFlags()
{
  if (!_InitialInput)
  {
    if (OutputFetched())
      ResetOutputFetched();
    else if (ProcessDone())
      ResetProcessDone();
    else if (InBatchInput() || InputOptional())
      ResetInputOptional();
    else if (ProcessRequired())
      ResetProcessRequired();
    else
      ClearResetCounts();
  }
}

/****************************************************************************/
void MockClientConIO::ClearResetCounts()
{
  _ResetOutputFetchCnt =
  _ResetProcessDoneCnt =
  _ResetInputOptionalCnt =
  _ResetProcessRequiredCnt = 0;
}

/****************************************************************************/
// Calculator Elapsed Timer class definitions
/****************************************************************************/
// Calculator Elapsed Timer class constructor
//
CalcElapsedTimer::CalcElapsedTimer(CalculatorBase* Parent_, int SendAt_):
_Parent(Parent_),
_ElapsedTimeFlag(0),
_TimingStarted(false),
_TimingStopped(false),
_ElapsedTimeReset(true),
_ElapsedTimeSent(false),
_ElapsedTimeAck(false),
_TimerActive(true),

_Begin(0),
_End(0),
_SendAt(SendAt_),
_TimerLock(0),
_ElapsedSecs(0)
{}

/****************************************************************************/
void CalcElapsedTimer::SetTimerActive(bool Flag_)
{
  _TimerActive = Flag_;

  if (!Flag_)
  {
    _TimingStarted = false;
    _TimingStopped = false;
  }
}

/****************************************************************************/
void CalcElapsedTimer::StartTimer()
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::StartTimer()");
  #endif

  if (_ElapsedTimeSent)
    ClientAck();
  else
    _TimingStopped = false;

  if (TimerActive() && TimerReset())
  {
    #if CALCLIB_DEBUG12d
      _Parent->DbgPtr()->ShowInt(1, "TimerActive()");
      _Parent->DbgPtr()->ShowInt(1, "TimerReset()");
    #endif

    _ElapsedTimeFlag = 0;
    _TimingStarted = true;
    _TimingStopped = false;

    _ElapsedTimeReset = true;
    _ElapsedTimeSent = false;
    _ElapsedTimeAck = false;

    _Begin = clock();
    _End = _Begin;
    _ElapsedSecs = 0;
    _TimerLock = 1;
  }
  else if (_TimerLock)
    _TimerLock++;

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(_TimerLock, "_TimerLock");
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void CalcElapsedTimer::EndTimer()
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::EndTimer()");
  #endif

  if (TimerActive() && _TimingStarted)
  {
    _End = clock();
    _ElapsedSecs = double(_End - _Begin) / CLOCKS_PER_SEC;
    _TimingStopped = true;
  }

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(TimerActive(), "TimerActive()");
    _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
    _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
    _Parent->DbgPtr()->ShowFloat(_End, "_End");
    _Parent->DbgPtr()->ShowFloat(_ElapsedSecs, "_ElapsedSecs");
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void CalcElapsedTimer::ResetTimer(bool ForceReset_)
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::ResetTimer()");
  #endif

  bool ElapsedFlagReset_ = false;

  if (_ElapsedTimeSent)
    ClientAck();
  else
  {
    if (_TimerLock)
      _TimerLock--;

    if (TimerActive() && !_TimerLock)
    {
      _TimingStarted = false;
      _TimingStopped = false;
      _ElapsedTimeReset = true;
    }
  }

  if ((TimerActive() && TimerReset()) || ForceReset_)
  {
    #if CALCLIB_DEBUG12d
      _Parent->DbgPtr()->ShowInt(1, "TimerReset()");
    #endif

    ElapsedFlagReset_ = _ElapsedTimeFlag == Mcalc_ElapsedTime::RESET;

    _ElapsedTimeFlag = 0;
    _TimingStarted = false;
    _TimingStopped = false;

    _ElapsedTimeReset = true;
    _ElapsedTimeSent = false;
    _ElapsedTimeAck = false;

    _Begin = 0;
    _End = 0;
    _ElapsedSecs = 0;
    _TimerLock = 0;

    if (ForceReset_)
    {
      _TimingStarted = false;
      _TimingStopped = false;

      _TimerLock = 0;
      _TimerActive = true;

      if (!ElapsedFlagReset_)
        _Parent->SetCalcTimeoutState(Mcalc_ElapsedTime::RESET,
                                     "CalcElapsedTimer::ResetTimer(true)");
    }
  }

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(TimerActive(), "TimerActive()");
    _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
    _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
    _Parent->DbgPtr()->ShowInt(_TimerLock, "_TimerLock");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeSent, "_ElapsedTimeSent");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeReset, "_ElapsedTimeReset");
    _Parent->DbgPtr()->ShowFloat(_ElapsedSecs, "_ElapsedSecs");
    _Parent->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
bool CalcElapsedTimer::SendTimeout(bool* Sending_)
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::SendTimeout()");
  #endif

  if (_Parent && TimerActive() && _TimingStopped &&
      !_ElapsedTimeSent && _ElapsedSecs >= _SendAt)
  {
    _ElapsedTimeSent = true;
    _ElapsedTimeReset = false;
    _ElapsedTimeAck = false;
    _TimingStarted = false;

    if (Sending_)
      *Sending_ = true;

    _ElapsedTimeFlag = Mcalc_ElapsedTime::SENT;
    _Parent->SendElapsedTimeSignal(0);

    #if CALCLIB_DEBUG12d
      _Parent->DbgPtr()->ShowMessage("SendElapsedTimeSignal(0);\n");
    #endif
  }
  else if (TimerActive() && _TimingStopped && _ElapsedTimeSent && Sending_)
    *Sending_ = false;

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(TimerActive(), "TimerActive()");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeFlag, "_ElapsedTimeFlag");
    _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
    _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
    _Parent->DbgPtr()->ShowInt(_TimerLock, "_TimerLock");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeSent, "_ElapsedTimeSent");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeReset, "_ElapsedTimeReset");
    _Parent->DbgPtr()->ShowFloat(_ElapsedSecs, "_ElapsedSecs");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return _ElapsedTimeSent;
}

/****************************************************************************/
bool CalcElapsedTimer::ClientAck()
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::ClientAck()");
  #endif

  if (_Parent && _TimingStopped && _ElapsedTimeSent && !_ElapsedTimeAck &&
      _Parent->CurrentTimeoutState() == Mcalc_ElapsedTime::ACKNOWLEDGED)
  {
    _ElapsedTimeAck = true;
    _ElapsedTimeFlag = _Parent->CurrentTimeoutState();
  }

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(TimerActive(), "TimerActive()");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeFlag, "_ElapsedTimeFlag");
    _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
    _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
    _Parent->DbgPtr()->ShowInt(_TimerLock, "_TimerLock");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeAck, "_ElapsedTimeAck");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeSent, "_ElapsedTimeSent");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeReset, "_ElapsedTimeReset");
    _Parent->DbgPtr()->ShowInt(_Parent->CurrentTimeoutState(), "CurrentTimeoutState()");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return _ElapsedTimeAck;
}

/****************************************************************************/
bool CalcElapsedTimer::TimerReset()
{
  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->EnterLevel("CalcElapsedTimer::TimerReset()");
  #endif

  if ( _Parent && !_TimingStarted &&
      (_ElapsedTimeReset || (_TimingStopped && _ElapsedTimeSent && _ElapsedTimeAck)))
  {
    if (_TimingStopped && _ElapsedTimeSent && _ElapsedTimeAck)
    {
      _TimingStopped = false;
      _ElapsedTimeSent = false;
      _ElapsedTimeAck = false;
      _ElapsedTimeReset = true;
    }

    _ElapsedTimeFlag = Mcalc_ElapsedTime::RESET;
    _Parent->SetCalcTimeoutState(_ElapsedTimeFlag, "CalcElapsedTimer::TimerReset()");

    #if CALCLIB_DEBUG12d
      _Parent->DbgPtr()->ShowMessage("SetCalcTimeoutState(Mcalc_ElapsedTime::RESET);\n");
      _Parent->DbgPtr()->ShowInt(_ElapsedTimeFlag, "_ElapsedTimeFlag");
      _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
      _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
      _Parent->DbgPtr()->ShowInt(_ElapsedTimeAck, "_ElapsedTimeAck");
      _Parent->DbgPtr()->ShowInt(_ElapsedTimeSent, "_ElapsedTimeSent");
      _Parent->DbgPtr()->ShowInt(_ElapsedTimeReset, "_ElapsedTimeReset");
      _Parent->DbgPtr()->ShowInt(_Parent->CurrentTimeoutState(), "CurrentTimeoutState()");
      _Parent->DbgPtr()->ShowMessage("CalcElapsedTimer::TimerReset() == true\n");
      _Parent->DbgPtr()->LeaveLevel();
    #endif

    return true;
  }

  #if CALCLIB_DEBUG12d
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeFlag, "_ElapsedTimeFlag");
    _Parent->DbgPtr()->ShowInt(_TimingStarted, "_TimingStarted");
    _Parent->DbgPtr()->ShowInt(_TimingStopped, "_TimingStopped");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeAck, "_ElapsedTimeAck");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeSent, "_ElapsedTimeSent");
    _Parent->DbgPtr()->ShowInt(_ElapsedTimeReset, "_ElapsedTimeReset");
    _Parent->DbgPtr()->ShowInt(_Parent->CurrentTimeoutState(), "CurrentTimeoutState()");
    _Parent->DbgPtr()->ShowMessage("CalcElapsedTimer::TimerReset() == false\n");
    _Parent->DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
// CalculatorBase class definitions
/****************************************************************************/
// CalculatorBase base class constructor
//
CalculatorBase::CalculatorBase(int argc, char** argv):
_AnswerStr(NULL),
_OriginalStr(NULL),
_FractionStr(NULL),
_LiteralStr(NULL),
_ProgramStr(NULL),
_PromptBuffer(NULL),
_DisplayOption(DISPLAY_TO_STREAM),
_AnswerMode(FLOATINGPOINT_MODE),
_ModeFinalized(0),
_InitialMode(TRUE),
_ProcessVars(0),
_ErrorValue(0),
_MultiErrorVector(0),
_MultiErrorMaxSel(NULL),
_MultiErrorErrVals(NULL),
_MultiErrorMaxSize(0),
_SkipEvaluation(0),
_NumberBase(10),
_RecursionLimit(RECURSION_LIMIT),
_GraphPrecision(DEFAULT_PRECVAL_GRAPH),
_SuppressOutput(0),
_InputDataFileExecLock(EXECFILE_UNLOCKED),
_ExecInputFileData(0),
_AckPostExecInputFileData(0),
_InputDataFileLinePause(TRUE),
_NoPauseFileInput(FALSE),
_previnputfile(NULL),
_previnputfileset(0),
_prevoutputfile(NULL),
_prevoutputfileset(0),
_FncAttribs(NULL),
_OutputBuffer(NULL),
_ErrorArgStr(NULL),
_UsingErrorArgStr(FALSE),
_NoPolling(TRUE),
_ParentDestroyed(FALSE),

_GraphOperationsSent(false),
_GraphOperationsResetDone1(0),
_GraphOperationsResetDone2(0),
_GraphOperationsUpdateDone1(0),
_GraphOperationsUpdateDone2(0),
_GraphProgressSent(false),
_GraphProgressResetDone(false),
_GraphProgressResetPending(false),
_GraphProgressUpdateDone(false),
_GraphProgressUpdatePending(false),
_InFileProgressSent(false),
_InFileProgressResetDone(false),
_InFileProgressResetPending(false),
_InFileProgressUpdateDone(false),
_InFileProgressUpdatePending(false),
_GraphPlotShown(false),
_ResultsShown(false),
_ResultsPending(false),
_ShownToPrompt(false),
_BatchFileEndedSignalSent(false),
_BatchFileEndedSignalAcked(false),
_BatchFileEndedSignalPending(false),
_ProcessAckSignalSent(false),
_ProcessAckSignalDone(false),
_ProcessAckSignalPending(false),
_ProcessAckTransition(0),
_AckSignalReceived(0),

_GraphProgressAmt(0),
_GraphSizeAmt(0),
_InFileProgressAmt(0),
_InFileSizeAmt(0),
_StateVarsReset(0),
_NumGraphFunctions(0),
_CurrentTotalSteps(0),
_CurrentTotalGraphSteps(0),

// Data members required for Subexpression methods and Calc. Program methods
_ExprStackIndex(0),
_ExprStackLimit(20),
_ProgramStackIndex(0),
_ProgramStackLimit(20),
_ProgramID(0),
_NewProgramID(0),
_PrevProgramID(0),
_ExecProgramActive(NULL),

// Calculator command history list methods
_HistoryListMode(0),
_CmdHistoryList(NULL),
_CmdHistoryPrompt(NULL),
_CmdHistoryEntry(NULL),
_CmdHistoryIndex(-1),
_CmdHistoryLength(0),
_HistoryFileEnded(false),
_SavedXpos(CONIO_XPOS_DEFAULT),
_DummyStr(new ChrString),
_QuitGraph(false),
_ResetGraph(false),
_GraphResetDone(false),
_BatchFileDonePending(false),

_FncCheck(NULL),
_MemDel(new DelayedMemoryDeleter)
{
  #if CALCLIB_DEBUG2
    logfile = FileOpen(MCALC_LOG_FILE, "w");
    fputs("Entering: CalculatorBase constructor\n", logfile);
  #endif

  ++_Instances;
  _FncCheck = new FunctionValidityChecker(this);

  if (_Instances == 1)
  {
    if (_CalculatorDestroyed == NULL)
    {
      _CalculatorDestroyed = (int*)allocmem(MAXCALC, sizeof(int), _CalculatorDestroyed);
      ::memset(_CalculatorDestroyed, 0, sizeof(int) * MAXCALC);
    }

    if (_CalculatorCreated == NULL)
    {
      _CalculatorCreated = (int*)allocmem(MAXCALC, sizeof(int), _CalculatorCreated);
      ::memset(_CalculatorCreated, 0, sizeof(int) * MAXCALC);

      if (argc > 0 && _CmdLineOptions == NULL)
      {
        #if CALCLIB_TESTASYNCMODE2c
          _CalcArgc = 3;
          _CalcArgv = (char**)allocmem(argc, sizeof(char*), _CalcArgv);

          _CalcArgv[0] = argv[0] ? ::NewString(argv[0]):NULL;
          _CalcArgv[1] = ::NewString("-i");
          _CalcArgv[2] = ::NewString("mcalc_userinput1.dat");

          if (_Mockcio == NULL)
            _Mockcio = new MockClientConIO(this);
        #else
          _CalcArgc = argc;
          _CalcArgv = (char**)allocmem(argc, sizeof(char*), _CalcArgv);

          int x;
          for (x = 0; x < argc; x++)
            _CalcArgv[x] = argv[x] ? ::NewString(argv[x]):NULL;

          #if CALCLIB_DEBUG13c
            _PromptBuffer = (char*)allocmem(INPUT_BUFFER_SIZE, sizeof(char), _PromptBuffer);
          #endif
        #endif

        // creating command line options data structure
        _CmdLineOptions = new Mcalc_CmdLineOptions();

        #if CALCLIB_TESTASYNCMODE2c
          FindCmdLineOptions(_CalcArgc, _CalcArgv, _CmdLineOptions);
          _CmdLineOptions->argvector = CloneArgVector(_CalcArgc, _CalcArgv);
        #else
          FindCmdLineOptions(argc, argv, _CmdLineOptions);
          _CmdLineOptions->argvector = CloneArgVector(argc, argv);
        #endif
      }
      else
      {
        if (_CmdLineOptions == NULL)
        {
          _CmdLineOptions = NULL;
          _CalcArgc = 0;
          _CalcArgv = NULL;
        }
        else if (_CmdLineOptions->sesnumexists &&
                 _CmdLineOptions->sesnumber)
        {
          SetSessionOption(TRUE);
          SetSessionNum(_CmdLineOptions->sesnumber);
        }
      }

      if (_AnsStrShown == NULL)
        _AnsStrShown = new ChrString();

      // creating graph plotting operation options data structure
      if (_GraphOpOptions == NULL)
        _GraphOpOptions = new Mcalc_GraphOperationOptions();

      // creating calculator elapsed time timer object
      if (_ElapsedTimer == NULL)
        _ElapsedTimer = new CalcElapsedTimer(this, CALC_TIMEOUT_WARNING);
    }

    #if CALCLIB_DEBUGGING
      _dbgptr = new Debugging<CalculatorBase>(this);
      #if CALCLIB_DEBUG9
        _dbgptr->SetFilename("serversig-dbg.txt");
      #else
        if (_CmdLineOptions && _CmdLineOptions->sesnumber &&
                               _CmdLineOptions->sesnumexists)
        {
          _dbgptr->SetFilename("calcexec-dbg.txt");
          _dbgptr->SetBrkPtFilename("calcexec-brkpt.txt");
        }
        else
        {
          _dbgptr->SetFilename("calclib-dbg.txt");
          _dbgptr->SetBrkPtFilename("calclib-brkpt.txt");
        }
      #endif
      _dbgptr->SetBasePtr(this);

      #if CALCLIB_TESTASYNCMODE
        _dbgptr->StartTrackingAll();
      #elif ((CALCLIB_DEBUG8)|(CALCLIB_DEBUG8a)|(CALCLIB_DEBUG8b))
        _dbgptr->StartTrackingAll();
      #elif ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG11b)|(CALCLIB_DEBUG11c))
        _dbgptr->StartTrackingAll();
      #elif ((CALCLIB_DEBUG12)|(CALCLIB_DEBUG12b))
        _dbgptr->StartTrackingAll();
      #else
        _dbgptr->SetStopTracking(CLIENTPOLLINGMGR, true)
               ->SetTrackType(CLIENTPOLLINGMGR);
      #endif

      Debugging<CalculatorBase>::SetCurrentDebugger(_dbgptr);

      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("Debugging Ptr Setup Done:\n\n");
      #endif
    #endif

    _ExitOnFileOpenFail = true;
    ResetInputFnc();
    ResetOutputFnc();

    _IoStatePtr = new CalcIoStateHandler(this, &_IoState);

    _CurrentFunctionName = (char*)allocmem(256, sizeof(char), _CurrentFunctionName);
    _CurrentFunctionName[0] = 0;
    _ErrorMessageArray = (char**)allocmem(Mcalc_Error::MAX_ERRORS, sizeof(char*), _ErrorMessageArray);
    _ErrorMessageArray[0] = NULL;
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_EXPR] = ::NewString(ERRMSG_INVALID_EXPR);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MISPLACED_COMMA] = ::NewString(ERRMSG_MISPLACED_COMMA);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MISSLEFT_BRACKET] = ::NewString(ERRMSG_MISSLEFT_BRACKET);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MISSRIGHT_BRACKET] = ::NewString(ERRMSG_MISSRIGHT_BRACKET);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_SYMBOLS] = ::NewString(ERRMSG_INVALID_SYMBOLS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_ASSIGNMENT] = ::NewString(ERRMSG_INVALID_ASSIGNMENT);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_NUMARGS] = ::NewString(ERRMSG_INVALID_NUMARGS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MULLERS_METHOD_FAILED] = ::NewString(ERRMSG_MULLERS_METHOD_FAILED);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_DIVISION_BY_ZERO] = ::NewString(ERRMSG_DIVISION_BY_ZERO);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_OPENSTATEFILE] = ::NewString(ERRMSG_OPENSTATEFILE);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MEMORY_FAIL] = ::NewString(ERRMSG_MEMORY_FAIL);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_FILE_ERROR] = ::NewString(ERRMSG_FILE_ERROR);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_CLIENTNOTFOUND] = ::NewString(ERRMSG_CLIENTNOTFOUND);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_ARRAYBOUNDS] = ::NewString(ERRMSG_ARRAYBOUNDS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_TYPEARGS] = ::NewString(ERRMSG_INVALID_TYPEARGS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_EMPTY_DATASET] = ::NewString(ERRMSG_EMPTY_DATASET);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_RECURSION_LIMIT] = ::NewString(ERRMSG_RECURSION_LIMIT);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_ARGLIST_SIZE] = ::NewString(ERRMSG_ARGLIST_SIZE);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_UNSOLVABLE_MATRIX] = ::NewString(ERRMSG_UNSOLVABLE_MATRIX);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_MATRIX_COLS] = ::NewString(ERRMSG_INVALID_MATRIX_COLS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_EMPTYROW_MATRIX] = ::NewString(ERRMSG_EMPTYROW_MATRIX);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_NO_RESULT_COL_MATRIX] = ::NewString(ERRMSG_NO_RESULT_COL_MATRIX);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_GRAPHVARNAME] = ::NewString(ERRMSG_INVALID_GRAPHVARNAME);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_EXECSWITCH] = ::NewString(ERRMSG_INVALID_EXECSWITCH);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_REENTRANT_INPUT_FILES] = ::NewString(ERRMSG_REENTRANT_INPUT_FILES);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_FUNCTIONS_FOUND] = ::NewString(ERRMSG_INVALID_FUNCTIONS_FOUND);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_VARIABLES_FOUND] = ::NewString(ERRMSG_INVALID_VARIABLES_FOUND);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_FRACTION_OPERATOR_EXPECTED] = ::NewString(ERRMSG_FRACTION_OPERATOR_EXPECTED);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MISSING_RIGHT_BRACE] = ::NewString(ERRMSG_MISSING_RIGHT_BRACE);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MISSING_CLOSING_QUOTE] = ::NewString(ERRMSG_MISSING_CLOSING_QUOTE);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_REQUIRED_OPERAND_MISSING] = ::NewString(ERRMSG_REQUIRED_OPERAND_MISSING);

    _ErrorMessageArray[Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS] = ::NewString(ERRMSG_OUTPUTDATA_ERRORS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_EXPRESSION_FORMAT] = ::NewString(ERRMSG_EXPRESSION_FORMAT);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_NULLCALCPTR] = ::NewString(ERRMSG_NULLCALCPTR);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INFIX_CONVERSION] = ::NewString(ERRMSG_INFIX_CONVERSION);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_INVALID_PRG_SWITCH] = ::NewString(ERRMSG_INVALID_PRG_SWITCH);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_PROGRAM_LOADING] = ::NewString(ERRMSG_PROGRAM_LOADING);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_MUTUAL_EXCL_OPTIONS] = ::NewString(ERRMSG_MUTUAL_EXCL_OPTIONS);
    _ErrorMessageArray[Mcalc_Error::ERRVAL_SERVERNOTFOUND] = ::NewString(ERRMSG_SERVERNOTFOUND);

    _ErrorMessageArgCnt = (int*)allocmem(Mcalc_Error::MAX_ERRORS, sizeof(int), _ErrorMessageArgCnt);
    _ErrorMessageArgCnt[0] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_EXPR] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MISPLACED_COMMA] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MISSLEFT_BRACKET] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MISSRIGHT_BRACKET] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_SYMBOLS] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_ASSIGNMENT] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_NUMARGS] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MULLERS_METHOD_FAILED] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_DIVISION_BY_ZERO] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_OPENSTATEFILE] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MEMORY_FAIL] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_FILE_ERROR] = 2;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_CLIENTNOTFOUND] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_ARRAYBOUNDS] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_TYPEARGS] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_EMPTY_DATASET] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_RECURSION_LIMIT] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_ARGLIST_SIZE] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_UNSOLVABLE_MATRIX] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_MATRIX_COLS] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_EMPTYROW_MATRIX] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_NO_RESULT_COL_MATRIX] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_GRAPHVARNAME] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_EXECSWITCH] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_REENTRANT_INPUT_FILES] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_FUNCTIONS_FOUND] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_VARIABLES_FOUND] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_FRACTION_OPERATOR_EXPECTED] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MISSING_RIGHT_BRACE] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MISSING_CLOSING_QUOTE] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_REQUIRED_OPERAND_MISSING] = 1;

    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_EXPRESSION_FORMAT] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_NULLCALCPTR] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INFIX_CONVERSION] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_INVALID_PRG_SWITCH] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_PROGRAM_LOADING] = 1;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_MUTUAL_EXCL_OPTIONS] = 0;
    _ErrorMessageArgCnt[Mcalc_Error::ERRVAL_SERVERNOTFOUND] = 0;

    if (!FUNCTION_NAMES)
    {
      FUNCTION_NAMES = (char**)allocmem(MAXFUNCTIONS, sizeof(char*), FUNCTION_NAMES);
      AddFunctionName("MIN");
      AddFunctionName("MAX");
      AddFunctionName("DERIV");
      AddFunctionName("DERIV2");
      AddFunctionName("INTEG");
      AddFunctionName("FMIN");
      AddFunctionName("FMAX");
      AddFunctionName("ROUND");
      AddFunctionName("SOLVE");
      AddFunctionName("INTERSECT");
      AddFunctionName("PERMREP");
      AddFunctionName("COMBREP");
      AddFunctionName("COMB");
      AddFunctionName("PERM");
      AddFunctionName("ITEMPERMREP");
      AddFunctionName("ITEMCOMBREP");
      AddFunctionName("ITEMCOMB");
      AddFunctionName("ITEMPERM");
      AddFunctionName("SETUNI");
      AddFunctionName("SETINT");
      AddFunctionName("SETDIF");
      AddFunctionName("SETXDIF");
      AddFunctionName("FRAC");
      AddFunctionName("SET");
      AddFunctionName("SUM");
      AddFunctionName("PROD");
      AddFunctionName("STDDEV");
      AddFunctionName("AVGMODE");
      AddFunctionName("AVGMEAN");
      AddFunctionName("AVGMED");
      AddFunctionName("RECTOPOLR");
      AddFunctionName("RECTOPOLA");
      AddFunctionName("POLTORECX");
      AddFunctionName("POLTORECY");
      AddFunctionName("EVAL");
      AddFunctionName("SHOW");
      AddFunctionName("SHOWSET");
      AddFunctionName("FROMHEX");
      AddFunctionName("FROMOCT");
      AddFunctionName("FROMBIN");
      AddFunctionName("FROMCMP2BIN");
      AddFunctionName("TOHEX");
      AddFunctionName("TOOCT");
      AddFunctionName("TOBIN");
      AddFunctionName("TOCMP2BIN");
      AddFunctionName("MATSOLVE");
      AddFunctionName("GRAPH");
    }

    int x;
    if (!files)
    {
      files = (FILE**)allocmem(MAXFILES, sizeof(FILE*), files);
      for (x = 0; x < MAXFILES; x++)
        files[x] = NULL;
    }

    for (x = 0; x < MAXFILES; x++)
      filestatus[x] = 0;

    _PollClientMgr = new ClientPollingMgr(this);
    if (_PollClientMgr)
      _PollClientMgr->SetExitAtRetryMax(true)
                    ->SetSleepWaiting(true)
                    ->SetAllowClientPolling(true)
                    ->SetBreakOnPollError(false)
                    ->SetResetStatesOnDone(true);

    #if CALCLIB_TESTMOCKCLIENT
      _PollServerMgr = new ServerPollingMgr(this);
      if (_PollServerMgr)
        _PollServerMgr->SetExitAtRetryMax(true)
                      ->SetSleepWaiting(true)
                      ->SetAllowServerPolling(true)
                      ->SetBreakOnPollError(false)
                      ->SetResetStatesOnDone(true);

      _NoPolling = _PollServerMgr == NULL ||
                   _PollClientMgr == NULL;
    #else
      _NoPolling = _PollClientMgr == NULL;
    #endif

    #if IMPLEMENT_KEEP_ALIVE
      ResumeCalcPolling();
    #elif IDLE_RESPONSE_ONLY_POLL
      PauseCalcPolling();
    #endif
  }

  int x;
  _FncAttribs = (Uchar*)allocmem(256, sizeof(Uchar), _FncAttribs);
  for (x = 0; x < 256; x++)
    _FncAttribs[x] = 0;

  SetAsUnary(RND_OP);
  SetAsUnary(SIN_OP);
  SetAsUnary(COS_OP);
  SetAsUnary(TAN_OP);
  SetAsUnary(ASIN_OP);
  SetAsUnary(ACOS_OP);
  SetAsUnary(ATAN_OP);
  SetAsUnary(SINH_OP);
  SetAsUnary(COSH_OP);
  SetAsUnary(TANH_OP);
  SetAsUnary(EXP_OP);
  SetAsUnary(LOG_OP);
  SetAsUnary(LOG10_OP);
  SetAsUnary(CEILING_OP);
  SetAsUnary(FLOOR_OP);
  SetAsUnary(ABS_OP);
  SetAsUnary(FRACPART_OP);
  SetAsUnary(INTPART_OP);
  SetAsUnary(SQR_OP);
  SetAsUnary(SQRT_OP);
  SetAsUnary(CUBE_OP);
  SetAsUnary(CUBERT_OP);
  SetAsUnary(RAND_OP);
  SetAsUnary(INV_OP);
  SetAsUnary(NOT_OP, 1);

  SetAsBinary(COMB_OP);
  SetAsBinary(PERM_OP);
  SetAsBinary(COMBREP_OP);
  SetAsBinary(PERMREP_OP);
  SetAsBinary(SCI_OP);
  SetAsBinary(LSTHANOREQ_OP, 1);
  SetAsBinary(GRTHANOREQ_OP, 1);
  SetAsBinary(EQUAL_OP, 1);
  SetAsBinary(NOTEQUAL_OP, 1);
  SetAsBinary(XOR_OP, 1);
  SetAsBinary(AND_OP, 1);
  SetAsBinary(OR_OP, 1);

  SetAsConstant(FRACANS_CONST);
  SetAsConstant(ANS_CONST, 1);
  SetAsConstant(ANSSTR_CONST, 1);
  SetAsConstant(PI_CONST);
  SetAsConstant(E_CONST);
  SetAsConstant(NAN_CONST);
  SetAsConstant(INF_CONST);

  SetAsVariable(VARIABLE_INDEX);
  SetAsPrefix(HEXPREFIX_INDEX, 1);
  SetAsConstant(FUNCTION_INDEX, 1);
  SetAsBinary(BINARYOPS_INDEX, 1);
  SetAsUnary(UNARYOPS_INDEX, 1);
  SetAsPostfix(POSTOPS_INDEX, 1);
  Set<int>::SetComparisonFunction(Mcalc_DefaultSetElementEqualFnc);

  #if CALCLIB_DEBUG2
    fputs("Leaving: CalculatorBase constructor\n", logfile);
  #endif
}

/****************************************************************************/
CalculatorBase::~CalculatorBase()
{
  MemMatrix::Matrix().Deallocate(_LiteralStr);
  MemMatrix::Matrix().Deallocate(_FractionStr);
  MemMatrix::Matrix().Deallocate(_AnswerStr);
  MemMatrix::Matrix().Deallocate(_OriginalStr);

  _LiteralStr =
  _FractionStr =
  _AnswerStr =
  _OriginalStr = NULL;

  delete _ExecuteProgram;
  _ExecuteProgram = NULL;

  _MultiErrorMaxSel =
  _MultiErrorErrVals = NULL;

  --_Instances;

  if (!_Instances)
  {
    // Removing cumulative calculator error log file
    _ExitOnFileOpenFail = false;
    GetLogFile();

    if (filestatus[Mcalc_IOType::ErrorLog] && logfile)
    {
      long Size_ = FileSize(logfile);
      CloseLogFile();

      if (!Size_ && !_LoggedError)
      {
        if (LOG_FILE)
          unlink(LOG_FILE);
        else
          unlink(MCALC_LOG_FILE);
      }
      else
        CloseLogFile();
    }

    GetSpawnArgFile();

    if (filestatus[Mcalc_IOType::SpawnArg] && spawnargfile)
    {
      long Size_ = FileSize(spawnargfile);
      CloseSpawnArgFile();

      if (SPAWNARG_FILE)
        unlink(SPAWNARG_FILE);
      else
        unlink(MCALC_SPAWNARG_FILE);
    }

    // Remove calculator command history files
    _ExitOnFileOpenFail = false;
    GetCommandHistoryFile();

    if (filestatus[Mcalc_IOType::CommandHistory] && commandhistoryfile)
    {
      long Size_ = FileSize(commandhistoryfile);
      CloseCommandHistoryFile();

      if (!Size_)
        if (CMDHISTORY_FILE)
          unlink(CMDHISTORY_FILE);
        else
          unlink(MCALC_CMDHISTORY_FILE);
    }

    // Remove current error message file
    _ExitOnFileOpenFail = false;
    GetCurrentErrorFile(false);

    if (filestatus[Mcalc_IOType::CurrentError] && currenterrorfile)
    {
      long Size_ = FileSize(currenterrorfile);
      CloseCurrentErrorFile();

      if (!Size_)
        if (CURRENTERROR_FILE)
          unlink(CURRENTERROR_FILE);
        else
          unlink(MCALC_CURRENT_ERROR_FILE);
    }

    closefiles();

    // session graph files
    char Fname_[32];
    char suf;

    for (suf = 'a'; suf <= 'z'; suf++)
    {
      sprintf(Fname_, "mcalc_graph%d%c.out", _SessionNum, suf);
      unlink(Fname_);
    }

    if (CURRENTGRAPH_FILE)
    {
      if (CalculatorBase::FileExists(CURRENTGRAPH_FILE))
        unlink(CURRENTGRAPH_FILE);

      MemMatrix::Matrix().Deallocate(CURRENTGRAPH_FILE);
      CURRENTGRAPH_FILE = NULL;
    }

    if (_CurrentGraphFname)
    {
      MemMatrix::Matrix().Deallocate(_CurrentGraphFname);
      _CurrentGraphFname = NULL;
    }

    if (GRAPH_OPERATION_FILE)
    {
      if (CalculatorBase::FileExists(MCALC_GRAPH_OPERATION_FILE))
        unlink(MCALC_GRAPH_OPERATION_FILE);
      if (CalculatorBase::FileExists(GRAPH_OPERATION_FILE))
        unlink(GRAPH_OPERATION_FILE);

      MemMatrix::Matrix().Deallocate(GRAPH_OPERATION_FILE);
      GRAPH_OPERATION_FILE = NULL;
    }

    if (GRAPH_PROGRESS_FILE)
    {
      if (CalculatorBase::FileExists(MCALC_GRAPH_PROGRESS_FILE))
        unlink(MCALC_GRAPH_PROGRESS_FILE);
      if (CalculatorBase::FileExists(GRAPH_PROGRESS_FILE))
        unlink(GRAPH_PROGRESS_FILE);

      MemMatrix::Matrix().Deallocate(GRAPH_PROGRESS_FILE);
      GRAPH_PROGRESS_FILE = NULL;
    }

    int x;
    if (FUNCTION_NAMES)
    {
      for (x = 0; x < MAXFUNCTIONS; x++)
        MemMatrix::Matrix().Deallocate(FUNCTION_NAMES[x]);

      MemMatrix::Matrix().Deallocate(FUNCTION_NAMES);
      FUNCTION_NAMES = NULL;
      _ShortestFncName = -1;
      _NumFncNames = 0;
    }

    if (_CurrentFunctionName)
    {
      MemMatrix::Matrix().Deallocate(_CurrentFunctionName);
      _CurrentFunctionName = NULL;
    }

    if (_ErrorMessageArray)
    {
      for (x = 0; x < Mcalc_Error::MAX_ERRORS; x++)
        MemMatrix::Matrix().Deallocate(_ErrorMessageArray[x]);

      MemMatrix::Matrix().Deallocate(_ErrorMessageArray);
      _ErrorMessageArray = NULL;
    }

    if (_ErrorMessageArgCnt)
    {
      MemMatrix::Matrix().Deallocate(_ErrorMessageArgCnt);
      _ErrorMessageArgCnt = NULL;
    }

    if (_MultiErrorMaxSel)
    {
      MemMatrix::Matrix().Deallocate(_MultiErrorMaxSel);
      _MultiErrorMaxSel = NULL;
    }

    if (_MultiErrorErrVals)
    {
      MemMatrix::Matrix().Deallocate(_MultiErrorErrVals);
      _MultiErrorErrVals = NULL;
    }

    // static calculator object existence flag array not destroyed,
    // contains useful information for other running objects
    //
    // if (_CalculatorDestroyed)
    // {
    //   MemMatrix::Matrix().Deallocate(_CalculatorDestroyed);
    //   _CalculatorDestroyed = NULL;
    // }

    // static calculator object existence flag array not destroyed,
    // contains useful information for other running objects
    //
    // if (_CalculatorCreated)
    // {
    //   MemMatrix::Matrix().Deallocate(_CalculatorCreated);
    //   _CalculatorCreated = NULL;
    // }

    // character array filters used for string utility functions
    MemMatrix::Matrix().Deallocate(_PrintCharSet);
    _PrintCharSet = NULL;

    MemMatrix::Matrix().Deallocate(_FuncNamesCharSet);
    _FuncNamesCharSet = NULL;

    // deleting calculator graph plotting object
    DestroyGraphPlotter();

    // deleting graph type list array
    DestroyGraphTypeList();

    // destroying global expression string stack
    DestroyStringStack();

    // destroying client polling manager object
    delete _PollClientMgr;
    _PollClientMgr = NULL;

    #if CALCLIB_TESTMOCKCLIENT
      delete _PollServerMgr;
      _PollServerMgr = NULL;
    #endif

    // destroying argument vector
    if (_CmdLineOptions)
    {
      for (x = 0; x < _CalcArgc; x++)
        if (_CalcArgv[x])
        {
          MemMatrix::Matrix().Deallocate(_CalcArgv[x]);
          _CalcArgv[x] = NULL;
        }

      MemMatrix::Matrix().Deallocate(_CalcArgv);
      _CalcArgv = NULL;
      _CalcArgc = 0;

      // destroying command line options data structure
      if (_CmdLineOptions->argvector)
        _CmdLineOptions->argvector =
            DestroyArgVector(_CmdLineOptions->argcount,
                             _CmdLineOptions->argvector);

      delete _CmdLineOptions;
      _CmdLineOptions = NULL;
    }

    if (_AnsStrShown)
    {
      delete _AnsStrShown;
      _AnsStrShown = NULL;
    }

    #if CALCLIB_TESTASYNCMODE2c
      if (_Mockcio)
      {
        delete _Mockcio;
        _Mockcio = NULL;
      }
    #elif CALCLIB_DEBUG13c
      MemMatrix::Matrix().Deallocate(_PromptBuffer);
      _PromptBuffer = NULL;
    #endif

    // destroying calculator elapsed time timer object
    if (_ElapsedTimer)
    {
      delete _ElapsedTimer;
      _ElapsedTimer = NULL;
    }

    // destroying graph plotting operation options data structure
    if (_GraphOpOptions)
    {
      delete _GraphOpOptions;
      _GraphOpOptions = NULL;
    }

    // destroying calculator IO state handler object
    delete _IoStatePtr;
    _IoStatePtr = NULL;

    MemMatrix::Matrix().Deallocate(LOG_FILE);
    MemMatrix::Matrix().Deallocate(SPAWNARG_FILE);
    MemMatrix::Matrix().Deallocate(CURRENTERROR_FILE);
    MemMatrix::Matrix().Deallocate(USER_INPUT_FILE);
    MemMatrix::Matrix().Deallocate(USER_PROMPT_FILE);
    MemMatrix::Matrix().Deallocate(PROG_OUTPUT_FILE);
    MemMatrix::Matrix().Deallocate(CMDHISTORY_FILE);
    MemMatrix::Matrix().Deallocate(DATA_INPUT_FILE);
    MemMatrix::Matrix().Deallocate(DATA_OUTPUT_FILE);
    MemMatrix::Matrix().Deallocate(PROG_IOSTATE_FILE);
    MemMatrix::Matrix().Deallocate(SERVERALIVE_FILE);
    MemMatrix::Matrix().Deallocate(CLIENTALIVE_FILE);
    MemMatrix::Matrix().Deallocate(PROGRESS_FILE);
    MemMatrix::Matrix().Deallocate(ELAPSEDTIME_FILE);
    MemMatrix::Matrix().Deallocate(POLLSTATE_FILE);
    MemMatrix::Matrix().Deallocate(FILE_SESNUM_SUFFIX);

    LOG_FILE =
    SPAWNARG_FILE =
    CURRENTERROR_FILE =
    USER_INPUT_FILE =
    USER_PROMPT_FILE =
    PROG_OUTPUT_FILE =
    CMDHISTORY_FILE =
    DATA_INPUT_FILE =
    DATA_OUTPUT_FILE =
    PROG_IOSTATE_FILE =
    SERVERALIVE_FILE =
    CLIENTALIVE_FILE =
    PROGRESS_FILE =
    ELAPSEDTIME_FILE =
    POLLSTATE_FILE =
    FILE_SESNUM_SUFFIX = NULL;

    delete _DummyStr;
    _DummyStr = NULL;

    #if CALCLIB_DEBUGGING
      if (_dbgptr && Debugging<CalculatorBase>::CurrentDebugger(false))
      {
        Debugging<CalculatorBase>::SetCurrentDebugger(NULL);
        _dbgptr->SetBasePtr(NULL);
        delete _dbgptr;
        _dbgptr = NULL;
      }
    #endif
  }

  delete _FncCheck;
  _FncCheck = NULL;

  delete _MemDel;
  _MemDel = NULL;
}

/****************************************************************************/
#if CALCLIB_DEBUGGING
void CalculatorBase::SetErrorData(int errcode_, const char* file_,
                                  size_t line_, size_t col_, bool terminate_)
{
  _errline = line_;
  _errcol = col_;
  _errcode = errcode_;
  char* buffer_ = NULL;
  char* fmtstr_;

  if (file_)
  {
    buffer_ = ::strcpy(new char[strlen(file_) + 100], file_);
    strcat(buffer_, ": ");
    strcat(buffer_, ERRMSG_ERROR_IN_LINE);
  }
  else
  {
    buffer_ = new char[100];
    strcpy(buffer_, ERRMSG_ERROR_IN_LINE);
  }

  FILE* fp = fopen("calclib_errorout.txt", "w");

  fmtstr_ = strdup(buffer_);
  sprintf(buffer_, fmtstr_, _errline, _errcol, _errcode);
  fputs(buffer_, fp);
  fflush(fp);
  fclose(fp);
  free(fmtstr_);
  delete[] buffer_;

  if (terminate_)
    exit(_errcode);
}
#endif

/****************************************************************************/
#if CALCLIB_DEBUGGING
void CalculatorBase::Terminate(bool setcode_, int errcode_)
{
  if (setcode_)
    _errcode = errcode_;

  exit(_errcode);
}
#endif

/****************************************************************************/
#if CALCLIB_DEBUGGING
void CalculatorBase::SetCurrentDebugger(Debugging<CalculatorBase>* ptr)
{
  Debugging<CalculatorBase>::SetCurrentDebugger(ptr);
}
#endif

/****************************************************************************/
#if CALCLIB_DEBUGGING
Debugging<CalculatorBase>* CalculatorBase::DbgPtr(bool Deref_)
{
  Debugging<CalculatorBase>* ptr =
    Debugging<CalculatorBase>::CurrentDebugger(Deref_);

  if (Deref_ && !ptr)
    SetErrorData(1);

  return ptr;
}
#endif

/****************************************************************************/
int CalculatorBase::CheckNoNullParams(int NumParams_, FncParameter** ParamArray_, int Index_)
{
  int x = (0 <= Index_ && (Index_ < NumParams_ || NumParams_ == -1)) ? Index_:-1;

  if (x >= 0)
    return (ParamArray_[x] && ParamArray_[x]->_Param);

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return FALSE;

  return TRUE;
}

/****************************************************************************/
int CalculatorBase::SpawnExternalMcalc(int argc, char** argv)
{
  _McalcSpawned = TRUE;
  int x, n;
  int retval_ = 0;
  const char* ptr = NULL;
  char* vars = NULL;

  #if CALCLIB_WIN64VER
    wchar_t* envstr_;
    wchar_t* envval_;

    // LPCWSTR pwenvstr_;
    // LPCWSTR pwenvval_;
    LPCSTR penvstr_;
    LPCSTR penvval_;
  #endif

  #if CALCLIB_DEBUG11b
    DbgPtr()->EnterLevel("CalculatorBase::SpawnExternalMcalc");
  #endif

  #if (defined(__DJGPP__))
    char* envr[] =
    {
      SPAWN_MCALC_DJGPP_PATHSTR,
      SPAWN_MCALC_DJGPP_DJGPPENVSTR, 0
    };

    #if CALCLIB_WIN64VER
      n = 0;
      vars = ::NewString(envr[n]);
      ptr = strchr(vars, '=');

      if (ptr)
      {
        x = ptr - vars;
        vars[x++] = 0;

        // mbstowcs(envstr_, vars, strlen(vars));
        // mbstowcs(envval_, &vars[x], strlen(&vars[x]));
        // pwenvstr_ = envstr_;
        // pwenvval_ = envval_;
        penvstr_ = vars;
        penvval_ = &vars[x];
        SetEnvironmentVariable(penvstr_, penvval_);

        // setenv(vars, &vars[x], 1);
        vars[x-1] = '=';
      }

      MemMatrix::Matrix().Deallocate(vars);
      n = 1;
      vars = ::NewString(envr[n]);
      ptr = strchr(vars, '=');

      if (ptr)
      {
        x = ptr - vars;
        vars[x++] = 0;

        // mbstowcs(envstr_, vars, strlen(vars));
        // mbstowcs(envval_, &vars[x], strlen(&vars[x]));
        // pwenvstr_ = envstr_;
        // pwenvval_ = envval_;
        penvstr_ = vars;
        penvval_ = &vars[x];
        SetEnvironmentVariable(penvstr_, penvval_);

        // setenv(vars, &vars[x], 1);
        vars[x-1] = '=';
      }

      MemMatrix::Matrix().Deallocate(vars);
    #endif
  #elif (defined(__linux__) | defined(__unix__))
    char* envr[] =
    {
      SPAWN_MCALC_LINUX_PATHSTR, 0
    };

    #if CALCLIB_WIN64VER
      n = 0;
      vars = ::NewString(envr[n]);
      ptr = strchr(vars, '=');

      if (ptr)
      {
        x = ptr - vars;
        vars[x++] = 0;
        setenv(vars, &vars[x], 1);
        vars[x-1] = '=';
      }

      MemMatrix::Matrix().Deallocate(vars);
    #endif
  #else
    char* envr[] =
    {
      SPAWN_MCALC_LINUX_PATHSTR, 0
    };

    #if CALCLIB_WIN64VER
      n = 0;
      vars = ::NewString(envr[n]);
      ptr = strchr(vars, '=');

      if (ptr)
      {
        x = ptr - vars;
        vars[x++] = 0;
        setenv(vars, &vars[x], 1);
        vars[x-1] = '=';
      }

      MemMatrix::Matrix().Deallocate(vars);
    #endif
  #endif

  #if CALCLIB_WIN64VER
    #if CALCLIB_DEBUGGING
      DbgPtr()->ShowMessage("Calling Method: SendSpawnCalcSignal()\n");
      DbgPtr()->ShowInt(InAsyncMode(), "InAsyncMode()");
      DbgPtr()->ShowInt(SessionOptionOverride(), "SessionOptionOverride()");
    #endif

    retval_ = SendSpawnCalcSignal(0, argc, argv, envr);
    if (retval_ != Mcalc_IOState::MCALC_SPAWNED)
      retval_ = 0;
  #else
    #if CALCLIB_DEBUGGING
      DbgPtr()->ShowMessage("Calling Method: SpawnVPE()\n");
      DbgPtr()->ShowInt(InAsyncMode(), "InAsyncMode()");
      DbgPtr()->ShowInt(SessionOptionOverride(), "SessionOptionOverride()");
    #endif

    retval_ = SpawnVPE(P_WAIT, "mcalc", argv, envr);
  #endif

  #if CALCLIB_DEBUG11b
    DbgPtr()->LeaveLevel();
  #endif
  return retval_;
}

/****************************************************************************/
void CalculatorBase::InitializeFiles()
{
  FILE* Fout_;

  Fout_ = fopen(USER_INPUT_FILE, "w");
  fprintf(Fout_, " ");
  fclose(Fout_);

  Fout_ = fopen(PROG_IOSTATE_FILE, "w");
  fprintf(Fout_, "%d", Mcalc_IOState::IDLE_STATE);
  fclose(Fout_);
  _IoState = Mcalc_IOState::IDLE_STATE;

  Fout_ = fopen(SERVERALIVE_FILE, "w");
  fprintf(Fout_, "%d\n", Mcalc_KeepAliveState::IDLE);
  fclose(Fout_);

  Fout_ = fopen(CLIENTALIVE_FILE, "w");
  fprintf(Fout_, "%d\n", Mcalc_KeepAliveState::IDLE);
  fclose(Fout_);

  Fout_ = fopen(POLLSTATE_FILE, "w");
  fprintf(Fout_, "%d", Mcalc_PollState::IDLE);
  fclose(Fout_);

  Fout_ = fopen(ELAPSEDTIME_FILE, "w");
  fprintf(Fout_, "%d\n", Mcalc_KeepAliveState::IDLE);
  fclose(Fout_);

  // If the session number command line option was chosen then...
  //   -we only need the two files for program output and session state
  //   -create a progress file for nicer output sent to GUI form
  if (SessionOption())
  {
    Fout_ = fopen(PROGRESS_FILE, "w");
    fprintf(Fout_, "%d\n", Mcalc_KeepAliveState::IDLE);
    fclose(Fout_);
  }
}

/****************************************************************************/
void CalculatorBase::CreateDefaultFileNames(const Integer& SesNum_)
{
  ChrString TempStr_;
  Subscript Pos_;

  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    TempStr_ = SesNum_.ToString();
    FILE_SESNUM_SUFFIX = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_PROG_OUTPUT_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    PROG_OUTPUT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_IOSTATE_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    PROG_IOSTATE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_LOG_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    LOG_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_SPAWNARG_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    SPAWNARG_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CURRENT_ERROR_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    CURRENTERROR_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CURRENTGRAPH_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (CURRENTGRAPH_FILE)
      ::RawDeleteArray(CURRENTGRAPH_FILE);
    CURRENTGRAPH_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_GRAPH_OPERATION_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (GRAPH_OPERATION_FILE)
      ::RawDeleteArray(GRAPH_OPERATION_FILE);
    GRAPH_OPERATION_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_GRAPH_PROGRESS_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (GRAPH_PROGRESS_FILE)
      ::RawDeleteArray(GRAPH_PROGRESS_FILE);
    GRAPH_PROGRESS_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_ELAPSEDTIME_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (ELAPSEDTIME_FILE)
      ::RawDeleteArray(ELAPSEDTIME_FILE);
    ELAPSEDTIME_FILE = ::NewString(TempStr_.c_str());

    // If the session number command line option was chosen then...
    //   -we only need the two files for program output and session state
    //   -create a progress file for nicer output sent to GUI form
    if (SessionOption())
    {
      TempStr_ = MCALC_PROGRESS_FILE;
      Pos_ = (Subscript&)TempStr_.find('.');
      TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
      PROGRESS_FILE = ::NewString(TempStr_.c_str());

      return;
    }

    TempStr_ = MCALC_USER_INPUT_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    USER_INPUT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_USER_PROMPT_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    USER_PROMPT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CMDHISTORY_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    CMDHISTORY_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_SERVERALIVE_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    SERVERALIVE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CLIENTALIVE_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    CLIENTALIVE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_POLLSTATE_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    POLLSTATE_FILE = ::NewString(TempStr_.c_str());
  #else
    TempStr_ = SesNum_.ToString();
    FILE_SESNUM_SUFFIX = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_PROG_OUTPUT_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    PROG_OUTPUT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_IOSTATE_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    PROG_IOSTATE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_LOG_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, SesNum_.ToString());
    LOG_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_SPAWNARG_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, SesNum_.ToString());
    SPAWNARG_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CURRENT_ERROR_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, SesNum_.ToString());
    CURRENTERROR_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CURRENTGRAPH_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (CURRENTGRAPH_FILE)
      ::RawDeleteArray(CURRENTGRAPH_FILE);
    CURRENTGRAPH_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_GRAPH_OPERATION_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (GRAPH_OPERATION_FILE)
      ::RawDeleteArray(GRAPH_OPERATION_FILE);
    GRAPH_OPERATION_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_GRAPH_PROGRESS_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (GRAPH_PROGRESS_FILE)
      ::RawDeleteArray(GRAPH_PROGRESS_FILE);
    GRAPH_PROGRESS_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_ELAPSEDTIME_FILE;
    Pos_ = (Subscript&)TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    if (ELAPSEDTIME_FILE)
      ::RawDeleteArray(ELAPSEDTIME_FILE);
    ELAPSEDTIME_FILE = ::NewString(TempStr_.c_str());

    // If the session number command line option was chosen then...
    //   -we only need the two files for program output and session state
    //   -create a progress file for nicer output sent to GUI form
    if (SessionOption())
    {
      TempStr_ = MCALC_PROGRESS_FILE;
      Pos_ = (Subscript&)TempStr_.find('.');
      TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
      PROGRESS_FILE = ::NewString(TempStr_.c_str());

      return;
    }

    TempStr_ = MCALC_USER_INPUT_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    USER_INPUT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_USER_PROMPT_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    USER_PROMPT_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CMDHISTORY_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    CMDHISTORY_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_SERVERALIVE_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    SERVERALIVE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_CLIENTALIVE_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    CLIENTALIVE_FILE = ::NewString(TempStr_.c_str());

    TempStr_ = MCALC_POLLSTATE_FILE;
    Pos_ = TempStr_.find('.');
    TempStr_.Insert(Pos_, FILE_SESNUM_SUFFIX);
    POLLSTATE_FILE = ::NewString(TempStr_.c_str());
  #endif

  InitializeFiles();
}

/****************************************************************************/
int CalculatorBase::CalculatorExists(int ClassNumber_)
{
  if (_CalculatorDestroyed && _CalculatorCreated &&
      0 <= ClassNumber_ && ClassNumber_ < MAXCALC)
  {
    int CalcDestroyed_ = _CalculatorDestroyed[ClassNumber_];
    int CalcCreated_ = _CalculatorCreated[ClassNumber_];
    return (CalcDestroyed_ == 0 && CalcCreated_ == 1);
  }

  return 0;
}

/****************************************************************************/
void CalculatorBase::SetCalculatorCreated(int ClassNumber_)
{
  if (_CalculatorDestroyed && _CalculatorCreated &&
      0 <= ClassNumber_ && ClassNumber_ < MAXCALC)
    _CalculatorCreated[ClassNumber_] = 1;
}

/****************************************************************************/
void CalculatorBase::SetCalculatorDestroyed(int ClassNumber_)
{
  if (_CalculatorDestroyed && _CalculatorCreated &&
      0 <= ClassNumber_ && ClassNumber_ < MAXCALC)
    _CalculatorDestroyed[ClassNumber_] = 1;
}

/****************************************************************************/
CalcIoStateHandler* CalculatorBase::GetIoStateHandler()
{
  return _IoStatePtr;
}

/****************************************************************************/
const char* CalculatorBase::IoStateToStr(int State_)
{
  return
  (
    (State_ == Mcalc_IOState::PROCESS)        ? "PROCESS":
    (State_ == Mcalc_IOState::OUTPUT_READY)   ? "OUTPUT_READY":
    (State_ == Mcalc_IOState::CALC_HALT)      ? "CALC_HALT":
    (State_ == Mcalc_IOState::CALC_RESPONSE)  ? "CALC_RESPONSE":
    (State_ == Mcalc_IOState::INPUT_REQUIRED) ? "INPUT_REQUIRED":
    (State_ == Mcalc_IOState::OUTPUT_FETCHED) ? "OUTPUT_FETCHED":
    (State_ == Mcalc_IOState::INPUT_RECEIVED) ? "INPUT_RECEIVED":
    (State_ == Mcalc_IOState::BREAK_PROGRAM)  ? "BREAK_PROGRAM":
    (State_ == Mcalc_IOState::IDLE_STATE)     ? "IDLE_STATE":
    (State_ == Mcalc_IOState::GRAPH_OUTPUT)   ? "GRAPH_OUTPUT":
    (State_ == Mcalc_IOState::GRAPH_WAIT)     ? "GRAPH_WAIT":
    (State_ == Mcalc_IOState::CALC_ERROR)     ? "CALC_ERROR":
    (State_ == Mcalc_IOState::PROGRESS_READY) ? "PROGRESS_READY":
    (State_ == Mcalc_IOState::ERROR_FETCH)    ? "ERROR_FETCH":
    (State_ == Mcalc_IOState::GRAPH_PROGRESS) ? "GRAPH_PROGRESS":

    (State_ == Mcalc_IOState::INFILE_PROGRESS_ACK) ? "INFILE_PROGRESS_ACK":
    (State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK)  ? "GRAPH_PROGRESS_ACK":
    (State_ == Mcalc_IOState::GRAPH_WAIT_ACK)      ? "GRAPH_WAIT_ACK":

    (State_ == Mcalc_IOState::SPAWN_NEW_MCALC) ? "SPAWN_NEW_MCALC":
    (State_ == Mcalc_IOState::MCALC_SPAWNED)   ? "MCALC_SPAWNED":

    (State_ == Mcalc_IOState::BATCHFILE_ENDED)     ? "BATCHFILE_ENDED":
    (State_ == Mcalc_IOState::BATCHFILE_ENDED_ACK) ? "BATCHFILE_ENDED_ACK":
    (State_ == Mcalc_IOState::PROCESS_DONE)        ? "PROCESS_DONE":
    (State_ == Mcalc_IOState::PROCESS_DONE_ACK)    ? "PROCESS_DONE_ACK":"0"
  );
}

/****************************************************************************/
const char* CalculatorBase::TimeoutStateToStr(int State_)
{
  return
  (
    (State_ == Mcalc_ElapsedTime::RESET)        ? "RESET":
    (State_ == Mcalc_ElapsedTime::SENT)         ? "SENT":
    (State_ == Mcalc_ElapsedTime::ACKNOWLEDGED) ? "ACKNOWLEDGED":"0"
  );
}

/****************************************************************************/
ChrString CalculatorBase::GiveIoStateStr(int State_)
{
  int x;
  int max = Mcalc_IOState::IOSTATE_ENDVAL;
  ChrString StateStr_;
  char sbuf[80];
  char* sptr;

  for (x = Mcalc_IOState::IOSTATE_STARTVAL; x <= max; x *= 2)
    if (State_ & x)
    {
      if (!StateStr_.IsEmpty())
        StateStr_ += "|";

      StateStr_ += IoStateToStr(x);
    }

  if (StateStr_.IsEmpty())
  {
    sptr = ::IntToStr(State_, sbuf);
    StateStr_ = sptr;
  }

  return StateStr_;
}

/****************************************************************************/
ChrString CalculatorBase::GiveTimeoutStateStr(int State_)
{
  ChrString StateStr_;
  char sbuf[80];

  if (State_ == Mcalc_ElapsedTime::RESET)
    strcpy(sbuf, "RESET");
  else if (State_ == Mcalc_ElapsedTime::SENT)
    strcpy(sbuf, "SENT");
  else if (State_ == Mcalc_ElapsedTime::ACKNOWLEDGED)
    strcpy(sbuf, "ACKNOWLEDGED");
  else
    sbuf[0] = 0;

  StateStr_ = sbuf;
  return StateStr_;
}

/****************************************************************************/
// Output Conditions methods
/****************************************************************************/
int* CalculatorBase::MakeOutputErrorsMaxSel()
{
  int* Array_ = (int*)MemMatrix::Matrix().Callocate(Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS * sizeof(int));
  Array_[0] = Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  Array_[1] = Mcalc_OutputDataCondition::Cond_NullCalcPtr;
  Array_[2] = Mcalc_OutputDataCondition::Cond_ConversionError;
  Array_[3] = Mcalc_OutputDataCondition::Cond_FormatInvalid;
  Array_[4] = Mcalc_OutputDataCondition::Cond_InvalidSwitch;
  Array_[5] = Mcalc_OutputDataCondition::Cond_PrgLoadError;

  return Array_;
}

/****************************************************************************/
int* CalculatorBase::MakeOutputErrorsErrVals()
{
  int* Array_ = (int*)MemMatrix::Matrix().Callocate(Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS * sizeof(int));
  Array_[0] = Mcalc_Error::ERRVAL_MUTUAL_EXCL_OPTIONS;
  Array_[1] = Mcalc_Error::ERRVAL_NULLCALCPTR;
  Array_[2] = Mcalc_Error::ERRVAL_INFIX_CONVERSION;
  Array_[3] = Mcalc_Error::ERRVAL_EXPRESSION_FORMAT;
  Array_[4] = Mcalc_Error::ERRVAL_INVALID_PRG_SWITCH;
  Array_[5] = Mcalc_Error::ERRVAL_PROGRAM_LOADING;

  return Array_;
}

/****************************************************************************/
int CalculatorBase::HasNullCalcPtrError()
{
  int NullCalcPtrError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_NullCalcPtr);

  if (NullCalcPtrError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_NullCalcPtr;

  return NullCalcPtrError_;
}

/****************************************************************************/
int CalculatorBase::HasMutualExclOptError()
{
  int MutualExclOptError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_MutualExclOpt);

  if (MutualExclOptError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;

  return MutualExclOptError_;
}

/****************************************************************************/
int CalculatorBase::HasConversionError()
{
  int ConversionError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_ConversionError);

  if (ConversionError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_ConversionError;

  return ConversionError_;
}

/****************************************************************************/
int CalculatorBase::HasFormatError()
{
  int FormatError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_FormatInvalid);

  if (FormatError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_FormatInvalid;

  return FormatError_;
}

/****************************************************************************/
int CalculatorBase::HasInvalidProgramSwitchError()
{
  int InvalidPrgSwitchError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected) &&
                               (!(_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgLoadError) &&
                                (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_InvalidSwitch));

  if (InvalidPrgSwitchError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_InvalidSwitch;

  return InvalidPrgSwitchError_;
}

/****************************************************************************/
int CalculatorBase::HasProgramLoadError()
{
  int PrgLoadError_ =  (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected) &&
                       (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgLoadError);

  if (PrgLoadError_)
    _OutputDataError |= Mcalc_OutputDataCondition::Cond_PrgLoadError;

  return PrgLoadError_;
}

/****************************************************************************/
int CalculatorBase::IsProgramSelected()
{
  return (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected);
}

/****************************************************************************/
int CalculatorBase::HasErrorCondition()
{
  // Cond_FormatValid     = 0x0004,   // Math expression line format verified as valid
  // Cond_ConversionError = 0x0008,   // InfixToRpn conversion error detected
  // Cond_PrgLoadError    = 0x0010,   // Program loading encountered problems
  // Cond_InvalidSwitch   = 0x0040,   // Invalid switch specified for executing input data files
  // Cond_MutualExclOpt   = 0x0080,   // Error detected, mutually exclusive options selected
  // Cond_PrgSelected     = 0x2000,   // Calculator program selected to be executed
  // Cond_NullCalcPtr     = 0x4000    // Unexpected null calculator pointer, processing cannot continue

  int FormatError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_FormatInvalid);
  int ConversionError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_ConversionError);
  int MutualExclOptError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_MutualExclOpt);
  int NullCalcPtrError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_NullCalcPtr);
  int PrgLoadError_ =  (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected) &&
                       (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgLoadError);
  int InvalidPrgSwitchError_ = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected) &&
                               (!(_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgLoadError) &&
                                (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_InvalidSwitch));
  int HasErrors_ = FormatError_ || ConversionError_ || MutualExclOptError_ ||
                   NullCalcPtrError_ || PrgLoadError_ || InvalidPrgSwitchError_;

  if (HasErrors_)
  {
    _OutputDataError = 0;
    if (MutualExclOptError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
    if (NullCalcPtrError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_NullCalcPtr;
    if (ConversionError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_ConversionError;
    if (FormatError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_FormatInvalid;
    if (InvalidPrgSwitchError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_InvalidSwitch;
    if (PrgLoadError_) _OutputDataError |= Mcalc_OutputDataCondition::Cond_PrgLoadError;
  }
  else
    _OutputDataError = 0;

  return (_OutputDataError != 0);
}

/****************************************************************************/
void CalculatorBase::ClearCalcPrgConditions()
{
  int PrgMask_ = Mcalc_OutputDataCondition::Cond_PrgLoadError |
                 Mcalc_OutputDataCondition::Cond_PauseSwitch |
                 Mcalc_OutputDataCondition::Cond_InvalidSwitch;

  if (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected)
    _OutputDataCondition &= ~PrgMask_;
}

/****************************************************************************/
void CalculatorBase::ClearOutputCondition(CalculatorBase* CalcPtr_, bool PreservePrgCond_)
{
  if (PreservePrgCond_ && CalcPtr_ && CalcPtr_->InProgramMode(true) &&
      (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_PrgSelected))
  {
    int PrgMask_ = Mcalc_OutputDataCondition::Cond_PrgLoadError |
                   Mcalc_OutputDataCondition::Cond_PauseSwitch |
                   Mcalc_OutputDataCondition::Cond_InvalidSwitch |
                   Mcalc_OutputDataCondition::Cond_PrgSelected;

    _OutputDataCondition &= PrgMask_;
    _OutputDataError &= PrgMask_;
  }
  else
  {
    _OutputDataCondition = 0;
    _OutputDataError = 0;
  }
}

/****************************************************************************/
void CalculatorBase::ClearOutputDataErrorCode(int Code_)
{
  if (Code_)
    _OutputDataError &= ~Code_;
  else
    _OutputDataError = 0;
}

/****************************************************************************/
int CalculatorBase::FindAndSetOutputDataErrors(CalculatorBase* CalcPtr_)
{
  if (!CalcPtr_)
    SetOutputCondition(Mcalc_OutputDataCondition::Cond_NullCalcPtr);

  if (HasErrorCondition())
    CalcPtr_->SetError(Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS);

  return _OutputDataError;
}

/****************************************************************************/
int CalculatorBase::OutputDataErrorCode()
{
  return _OutputDataError;
}

/****************************************************************************/
int CalculatorBase::NoOutputReturned()
{
  return _NoOutputReturned;
}

/****************************************************************************/
void CalculatorBase::SetNoOutputReturned(CalculatorBase* CalcPtr_, int flag_)
{
  SubExpression* SubExpr_ = CalcPtr_ ? CalcPtr_->TopSubExprStack():NULL;
  bool Confirmed_ = SubExpr_ ?
                      ((CalcPtr_->SubExprStackIndex() == 1 ||
                        CalcPtr_->InRunningProgram(true, true, false, false)) &&
                       !CalcPtr_->ActiveExpression() &&
                       (!SubExpr_ || SubExpr_->GetLevel() == 0)):true;

  if (Confirmed_)
    _NoOutputReturned = flag_;
}

/****************************************************************************/
void CalculatorBase::SetOutputConditionOnDataType()
{
  if (DataOutputted())
  {
    if (IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay))
      SetOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDisplay);
    else if (IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump))
      SetOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDump);
    else if (IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString))
      SetOutputCondition(Mcalc_OutputDataCondition::Cond_AnswerDisp);
    else if (IsOutputDataType(Mcalc_OutputDataType::Out_MessageString))
      SetOutputCondition(Mcalc_OutputDataCondition::Cond_MessageDisp);
    else if (IsOutputDataType(Mcalc_OutputDataType::Out_ProgressData))
      SetOutputCondition(Mcalc_OutputDataCondition::Cond_ProgressDisp);
  }
}

/****************************************************************************/
void CalculatorBase::SetOutputCondition(int Cond_)
{
  // Cond_LineEvalDone    = 0x0001,   // Expression line evaluation completed
  // Cond_VariableEval    = 0x0002,   // Variable contents evaluation completed
  // Cond_FormatInvalid   = 0x0004,   // Math expression line format is invalid
  // Cond_ConversionError = 0x0008,   // InfixToRpn conversion error detected
  // Cond_PrgLoadError    = 0x0010,   // Program loading encountered problems
  // Cond_PauseSwitch     = 0x0020,   // Pause option selected for executing input data files
  // Cond_InvalidSwitch   = 0x0040,   // Invalid switch specified for executing input data files
  // Cond_MutualExclOpt   = 0x0080,   // Error detected, mutually exclusive options selected
  // Cond_NullCalcPtr     = 0x4000,   // Unexpected null calculator pointer, processing cannot continue
  //
  // Cond_VariableDisplay = 0x0100,   // Variable display completed
  // Cond_MessageDisp     = 0x0200,   // Text message display completed
  // Cond_AnswerDisp      = 0x0400,   // Calculated answer display completed: (float, literal, fraction)
  // Cond_VariableDump    = 0x0800,   // Output dump of all letter variables and answer variables completed
  // Cond_ProgressDisp    = 0x1000,   // Progress data display completed
  // Cond_PrgSelected     = 0x2000    // Calculator program selected to be executed
  //

  int AllDispOptions_ = (Mcalc_OutputDataCondition::Cond_MessageDisp |
                         Mcalc_OutputDataCondition::Cond_AnswerDisp |
                         Mcalc_OutputDataCondition::Cond_VariableDisplay |
                         Mcalc_OutputDataCondition::Cond_VariableDump |
                         Mcalc_OutputDataCondition::Cond_ProgressDisp);

  int ProgressOnly_ = (Mcalc_OutputDataCondition::Cond_MessageDisp |
                       Mcalc_OutputDataCondition::Cond_AnswerDisp |
                       Mcalc_OutputDataCondition::Cond_VariableDisplay |
                       Mcalc_OutputDataCondition::Cond_VariableDump);

  int VarDumpOnly_ = (Mcalc_OutputDataCondition::Cond_MessageDisp |
                      Mcalc_OutputDataCondition::Cond_VariableDisplay |
                      Mcalc_OutputDataCondition::Cond_AnswerDisp |
                      Mcalc_OutputDataCondition::Cond_ProgressDisp);

  int VarDispOnly_ = (Mcalc_OutputDataCondition::Cond_MessageDisp |
                      Mcalc_OutputDataCondition::Cond_VariableDump |
                      Mcalc_OutputDataCondition::Cond_AnswerDisp |
                      Mcalc_OutputDataCondition::Cond_ProgressDisp);

  int AnsOnly_ = (Mcalc_OutputDataCondition::Cond_MessageDisp |
                  Mcalc_OutputDataCondition::Cond_VariableDisplay |
                  Mcalc_OutputDataCondition::Cond_VariableDump |
                  Mcalc_OutputDataCondition::Cond_ProgressDisp);

  int MsgOnly_ = (Mcalc_OutputDataCondition::Cond_AnswerDisp |
                  Mcalc_OutputDataCondition::Cond_VariableDisplay |
                  Mcalc_OutputDataCondition::Cond_VariableDump |
                  Mcalc_OutputDataCondition::Cond_ProgressDisp);

  if ((Cond_ & Mcalc_OutputDataCondition::Cond_VariableDisplay) &&
      (Cond_ & VarDispOnly_) == 0)
  {
    // Variable display completed overrides any variable evaluations
    // If variable display completed then variable evaluations cannot be done
    _OutputDataCondition |= Cond_;
    _OutputDataCondition &= ~Mcalc_OutputDataCondition::Cond_VariableEval;

    // check for selection of mutually exclusive options, error if found
    if (_OutputDataCondition & VarDispOnly_)
      _OutputDataCondition |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  }
  else if ((Cond_ & Mcalc_OutputDataCondition::Cond_VariableDump) &&
           (Cond_ & VarDumpOnly_) == 0)
  {
    _OutputDataCondition |= Cond_;

    // check for selection of mutually exclusive options, error if found
    if (_OutputDataCondition & VarDumpOnly_)
      _OutputDataCondition |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  }
  else if ((Cond_ & Mcalc_OutputDataCondition::Cond_MessageDisp) &&
           (Cond_ & MsgOnly_) == 0)
  {
    _OutputDataCondition |= Cond_;

    // check for selection of mutually exclusive options, error if found
    if (_OutputDataCondition & MsgOnly_)
      _OutputDataCondition |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  }
  else if ((Cond_ & Mcalc_OutputDataCondition::Cond_AnswerDisp) &&
           (Cond_ & AnsOnly_) == 0)
  {
    _OutputDataCondition |= Cond_;

    // check for selection of mutually exclusive options, error if found
    if (_OutputDataCondition & AnsOnly_)
      _OutputDataCondition |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  }
  else if ((Cond_ & Mcalc_OutputDataCondition::Cond_ProgressDisp) &&
           (Cond_ & ProgressOnly_) == 0)
  {
    _OutputDataCondition |= Cond_;

    // check for selection of mutually exclusive options, error if found
    if (_OutputDataCondition & ProgressOnly_)
      _OutputDataCondition |= Mcalc_OutputDataCondition::Cond_MutualExclOpt;
  }
  else if ((Cond_ & AllDispOptions_) == 0)
  {
    // Variable display completed overrides any variable evaluations
    // If variable display completed then variable evaluations cannot be done
    if (Cond_ != Mcalc_OutputDataCondition::Cond_VariableEval ||
        (Cond_ & Mcalc_OutputDataCondition::Cond_VariableDisplay) == 0)
      _OutputDataCondition |= Cond_;
  }
}

/****************************************************************************/
// Output Data Type methods
/****************************************************************************/
int CalculatorBase::ProgressOutputted()
{
  return ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_ProgressDisp) &&
          (_OutputDataType & Mcalc_OutputDataType::Out_ProgressData));
}

/****************************************************************************/
int CalculatorBase::VariablesDumped()
{
  return ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDump) &&
          (_OutputDataType & Mcalc_OutputDataType::Out_VariableDump));
}

/****************************************************************************/
int CalculatorBase::VariableDisplayed(int Type_)
{
  int ret = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDisplay) &&
            (_OutputDataType & Mcalc_OutputDataType::Out_VariableDisplay);
  return (ret && (!Type_ || (_OutputDataType & Type_)));
}

/****************************************************************************/
int CalculatorBase::AnswerOutputted(int Type_)
{
  int ret = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_AnswerDisp) &&
            (_OutputDataType & Mcalc_OutputDataType::Out_AnswerString);
  return (ret && (!Type_ || (_OutputDataType & Type_)));
}

/****************************************************************************/
int CalculatorBase::MessageOutputted(int Type_)
{
  int ret = (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_MessageDisp) &&
            (_OutputDataType & Mcalc_OutputDataType::Out_MessageString);
  return (ret && (!Type_ || (_OutputDataType & Type_)));
}

/****************************************************************************/
int CalculatorBase::DataOutputted(int Type_)
{
  if (Type_)
    return
    (
      (Type_ == Mcalc_OutputDataType::Out_VariableDisplay) ? (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDisplay):
      (Type_ == Mcalc_OutputDataType::Out_AnswerString) ? (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_AnswerDisp):
      (Type_ == Mcalc_OutputDataType::Out_MessageString) ? (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_MessageDisp):
      (Type_ == Mcalc_OutputDataType::Out_VariableDump) ? (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDump):
      (Type_ == Mcalc_OutputDataType::Out_ProgressData) ? (_OutputDataCondition & Mcalc_OutputDataCondition::Cond_ProgressDisp):0
    );

  return
  (
    ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDisplay) &&
     (_OutputDataType & Mcalc_OutputDataType::Out_VariableDisplay)) ||

    ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_AnswerDisp) &&
     (_OutputDataType & Mcalc_OutputDataType::Out_AnswerString)) ||

    ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_MessageDisp) &&
     (_OutputDataType & Mcalc_OutputDataType::Out_MessageString)) ||

    ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_VariableDump) &&
     (_OutputDataType & Mcalc_OutputDataType::Out_VariableDump)) ||

    ((_OutputDataCondition & Mcalc_OutputDataCondition::Cond_ProgressDisp) &&
     (_OutputDataType & Mcalc_OutputDataType::Out_ProgressData))
  );
}

/****************************************************************************/
void CalculatorBase::ClearOutputDataType(CalculatorBase* CalcPtr_)
{
  SubExpression* SubExpr_ = CalcPtr_ ? CalcPtr_->TopSubExprStack():NULL;
  bool Confirmed_ = SubExpr_ ?
                      ((CalcPtr_->SubExprStackIndex() == 1 ||
                        CalcPtr_->InRunningProgram(true, true, false, false)) &&
                       !CalcPtr_->ActiveExpression() &&
                       (!SubExpr_ || SubExpr_->GetLevel() == 0)):true;

  if (Confirmed_)
  {
    _OutputDataType = 0;
    _OutputDataIndex = 0;
    _OutputDataIndexSet = false;
  }
}

/****************************************************************************/
int CalculatorBase::IsOutputCondition(int Cond_)
{
  return (_OutputDataCondition & Cond_);
}

/****************************************************************************/
int CalculatorBase::IsOutputDataType(int Type_)
{
  return (_OutputDataType & Type_);
}

/****************************************************************************/
void CalculatorBase::SetOutputDataIndex(CalculatorBase* CalcPtr_, int Index_)
{
  SubExpression* SubExpr_ = CalcPtr_ ? CalcPtr_->TopSubExprStack():NULL;
  bool Confirmed_ = SubExpr_ ?
                      ((CalcPtr_->SubExprStackIndex() == 1 ||
                        CalcPtr_->InRunningProgram(true, true, false, false)) &&
                       !CalcPtr_->ActiveExpression() &&
                       (!SubExpr_ || SubExpr_->GetLevel() == 0)):true;

  if (Confirmed_)
  {
    _OutputDataIndex = Index_;
    _OutputDataIndexSet = true;
  }
}

/****************************************************************************/
int CalculatorBase::IsOutputDataIndexSet()
{
  return _OutputDataIndexSet;
}

/****************************************************************************/
int CalculatorBase::GiveOutputDataIndex(bool& IndexSet_)
{
  IndexSet_ = _OutputDataIndexSet;
  return _OutputDataIndex;
}

/****************************************************************************/
void CalculatorBase::AppendOutputDataType(CalculatorBase* CalcPtr_, int Type_)
{
  SubExpression* SubExpr_ = CalcPtr_ ? CalcPtr_->TopSubExprStack():NULL;
  bool Confirmed_ = SubExpr_ ?
                      ((CalcPtr_->SubExprStackIndex() == 1 ||
                        CalcPtr_->InRunningProgram(true, true, false, false)) &&
                       !CalcPtr_->ActiveExpression() &&
                       (!SubExpr_ || SubExpr_->GetLevel() == 0)):true;

  int Mask_ = 0;
  int VarDumpOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                      Mcalc_OutputDataType::Out_VariableDisplay |
                      Mcalc_OutputDataType::Out_ProgressData);

  int VarDispOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                      Mcalc_OutputDataType::Out_VariableDump |
                      Mcalc_OutputDataType::Out_ProgressData);

  int AnsOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                  Mcalc_OutputDataType::Out_VariableDisplay |
                  Mcalc_OutputDataType::Out_VariableDump |
                  Mcalc_OutputDataType::Out_ProgressData);

  if ((Type_ & Mcalc_OutputDataType::Out_VariableDump) &&
      (Type_ & Mcalc_OutputDataType::Out_VariableMask) &&
      (Type_ & VarDumpOnly_) == 0)
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_VariableMask);

    if (InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_VariableDump);
      _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_VariableMask) | Type_);
    }
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_VariableDisplay) &&
           (Type_ & Mcalc_OutputDataType::Out_VariableMask) &&
           (Type_ & VarDispOnly_) == 0)
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_VariableMask);

    if (Confirmed_ &&
        InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_VariableDisplay);
      _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_VariableMask) | Type_);
    }
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_AnswerString) &&
           (Type_ & Mcalc_OutputDataType::Out_AnswerMask) &&
           ((Confirmed_ && (Type_ & AnsOnly_) == 0) ||
            (Confirmed_ && (Type_ & VarDispOnly_) == 0) ||
            (Type_ & VarDumpOnly_) == 0))
  {
    if ((Type_ & Mcalc_OutputDataType::Out_VariableDump))
    {
      Mask_ = Mcalc_OutputDataType::Out_VariableDump;
      Type_ = (Type_ & (Mcalc_OutputDataType::Out_AnswerMask|Mask_));
    }
    else if ((Type_ & Mcalc_OutputDataType::Out_VariableDisplay))
    {
      Mask_ = Mcalc_OutputDataType::Out_VariableDisplay;
      Type_ = (Type_ & (Mcalc_OutputDataType::Out_AnswerMask|Mask_));
    }

    if (InRange(Mcalc_OutputDataType::Out_LiteralAnswer, Type_, Mcalc_OutputDataType::Out_FloatAnswer))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_AnswerString);
      _OutputDataType = ((_OutputDataType & ~(Mcalc_OutputDataType::Out_AnswerMask|Mask_)) | Type_);
    }
  }
  else if (Confirmed_ &&
           InRange(Mcalc_OutputDataType::Out_LiteralAnswer, Type_, Mcalc_OutputDataType::Out_FloatAnswer))
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_AnswerMask);
    _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_AnswerMask) | Type_);
  }
  else if (Confirmed_ &&
           InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
  {
    Mask_ = Mcalc_OutputDataType::Out_AnswerMask;
    _OutputDataType = ((_OutputDataType & ~(Mcalc_OutputDataType::Out_VariableMask|Mask_)) | Type_);

    if (!(_OutputDataType & Mcalc_OutputDataType::Out_VariableDisplay))
      _OutputDataType |= Mcalc_OutputDataType::Out_VariableDisplay;
  }
}

/****************************************************************************/
void CalculatorBase::SetOutputDataType(CalculatorBase* CalcPtr_, int Type_, bool Clear_)
{
  // Out_AnsVar           = 0x0001,   // Calculator answer number variable outputted
  // Out_AnsStrVar        = 0x0002,   // Calculator answer string variable outputted
  // Out_FracAnsVar       = 0x0004,   // Calculator fraction answer variable outputted
  // Out_LetterVar        = 0x0008,   // User accessible letter variable outputted
  // Out_VariableMask     = 0x000F,   // Variable data type bit mask
  //
  // Out_ErrorMessage     = 0x0010,   // Error message outputted
  // Out_HelpMessage      = 0x0020,   // Help message outputted
  // Out_TextMessage      = 0x0040,   // Text message outputted
  // Out_MessageMask      = 0x0070,   // Message data type bit mask
  // Out_MessageString    = 0x0080,   // Message string category of output data sent
  //
  // Out_LiteralAnswer    = 0x0100,   // Literal answer outputted
  // Out_FractionAnswer   = 0x0200,   // Fraction answer outputted
  // Out_FloatAnswer      = 0x0400,   // Float answer outputted
  // Out_AnswerMask       = 0x0700,   // Answer data type bit mask
  // Out_AnswerString     = 0x0800,   // Answer string category of output data sent
  //
  // Out_VariableDisplay  = 0x1000,   // Single letter variable or calculator answer variable is displayed
  // Out_VariableDump     = 0x2000,   // All letter Variables and calculator answer variables output dumped
  // Out_ProgressData     = 0x4000    // Progress data outputted
  //

  SubExpression* SubExpr_ = CalcPtr_ ? CalcPtr_->TopSubExprStack():NULL;
  bool Confirmed_ = SubExpr_ ?
                      ((CalcPtr_->SubExprStackIndex() == 1 ||
                        CalcPtr_->InRunningProgram(true, true, false, false)) &&
                       !CalcPtr_->ActiveExpression() &&
                       (!SubExpr_ || SubExpr_->GetLevel() == 0)):true;

  int Mask_ = 0;
  int ProgressOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                       Mcalc_OutputDataType::Out_AnswerString |
                       Mcalc_OutputDataType::Out_VariableDisplay |
                       Mcalc_OutputDataType::Out_VariableDump);

  int VarDumpOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                      Mcalc_OutputDataType::Out_VariableDisplay |
                      Mcalc_OutputDataType::Out_ProgressData);

  int VarDispOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                      Mcalc_OutputDataType::Out_VariableDump |
                      Mcalc_OutputDataType::Out_ProgressData);

  int AnsOnly_ = (Mcalc_OutputDataType::Out_MessageString |
                  Mcalc_OutputDataType::Out_VariableDisplay |
                  Mcalc_OutputDataType::Out_VariableDump |
                  Mcalc_OutputDataType::Out_ProgressData);

  int MsgOnly_ = (Mcalc_OutputDataType::Out_AnswerString |
                  Mcalc_OutputDataType::Out_VariableDisplay |
                  Mcalc_OutputDataType::Out_VariableDump |
                  Mcalc_OutputDataType::Out_ProgressData);

  if (((Type_ & Mcalc_OutputDataType::Out_VariableDump) && (Type_ & VarDumpOnly_) == 0) ||
      (Confirmed_ &&
       (Type_ & Mcalc_OutputDataType::Out_VariableDisplay) && (Type_ & VarDispOnly_) == 0) ||
      ((Type_ & Mcalc_OutputDataType::Out_ProgressData) && (Type_ & ProgressOnly_) == 0))
  {
    _OutputDataType = Type_;
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_AnswerString) &&
           (Type_ & Mcalc_OutputDataType::Out_AnswerMask) &&
           ((Confirmed_ && (Type_ & AnsOnly_) == 0) ||
            (!Clear_ && Confirmed_ && (Type_ & VarDispOnly_) == 0) ||
            (!Clear_ && (Type_ & VarDumpOnly_) == 0)))
  {
    if ((Type_ & Mcalc_OutputDataType::Out_VariableDump))
    {
      Mask_ = Clear_ ? 0:Mcalc_OutputDataType::Out_VariableDump;
      Type_ = (Type_ & (Mcalc_OutputDataType::Out_AnswerMask|Mask_));
    }
    else if ((Type_ & Mcalc_OutputDataType::Out_VariableDisplay))
    {
      Mask_ = Clear_ ? 0:Mcalc_OutputDataType::Out_VariableDisplay;
      Type_ = (Type_ & (Mcalc_OutputDataType::Out_AnswerMask|Mask_));
    }

    if (InRange(Mcalc_OutputDataType::Out_LiteralAnswer, Type_, Mcalc_OutputDataType::Out_FloatAnswer))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_AnswerString);
      _OutputDataType = ((_OutputDataType & ~(Mcalc_OutputDataType::Out_AnswerMask|Mask_)) | Type_);
    }
  }
  else if (Confirmed_ &&
           InRange(Mcalc_OutputDataType::Out_LiteralAnswer, Type_, Mcalc_OutputDataType::Out_FloatAnswer))
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_AnswerMask);
    _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_AnswerMask) | Type_);
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_MessageString) &&
           (Type_ & Mcalc_OutputDataType::Out_MessageMask) &&
           (Type_ & MsgOnly_) == 0)
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_MessageMask);

    if (InRange(Mcalc_OutputDataType::Out_ErrorMessage, Type_, Mcalc_OutputDataType::Out_TextMessage))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_MessageString);
      _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_MessageMask) | Type_);
    }
  }
  else if (InRange(Mcalc_OutputDataType::Out_ErrorMessage, Type_, Mcalc_OutputDataType::Out_TextMessage))
  {
    _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_MessageMask) | Type_);

    if (!(_OutputDataType & Mcalc_OutputDataType::Out_MessageString))
      _OutputDataType |= Mcalc_OutputDataType::Out_MessageString;
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_VariableDisplay) &&
           (Type_ & Mcalc_OutputDataType::Out_VariableMask) &&
           (Type_ & VarDispOnly_) == 0)
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_VariableMask);

    if (Confirmed_ &&
        InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_VariableDisplay);
      _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_VariableMask) | Type_);
    }
  }
  else if ((Type_ & Mcalc_OutputDataType::Out_VariableDump) &&
           (Type_ & Mcalc_OutputDataType::Out_VariableMask) &&
           (Type_ & VarDumpOnly_) == 0)
  {
    Type_ = (Type_ & Mcalc_OutputDataType::Out_VariableMask);

    if (InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
    {
      Type_ = (Type_ | Mcalc_OutputDataType::Out_VariableDump);
      _OutputDataType = ((_OutputDataType & ~Mcalc_OutputDataType::Out_VariableMask) | Type_);
    }
  }
  else if (Confirmed_ &&
           InRange(Mcalc_OutputDataType::Out_AnsVar, Type_, Mcalc_OutputDataType::Out_LetterVar))
  {
    Mask_ = Clear_ ? 0:Mcalc_OutputDataType::Out_AnswerMask;
    _OutputDataType = ((_OutputDataType & ~(Mcalc_OutputDataType::Out_VariableMask|Mask_)) | Type_);

    if (!(_OutputDataType & Mcalc_OutputDataType::Out_VariableDisplay))
      _OutputDataType |= Mcalc_OutputDataType::Out_VariableDisplay;
  }
}

/****************************************************************************/
// BREAK calculator command processing methods
/****************************************************************************/
void CalculatorBase::ResetPostBreakResponse()
{
  _SetBreakResponse = FALSE;
  _PostBreakResponseSent = FALSE;
}

/****************************************************************************/
int CalculatorBase::PostBreakResponseSent()
{
  return _PostBreakResponseSent;
}

/****************************************************************************/
void CalculatorBase::SetBreakFromProgram(int flag_)
{
  _BreakFromProgram = flag_;

  if (flag_)
  {
    _SetBreakResponse = TRUE;
    _PostBreakResponseSent = FALSE;
  }
}

/****************************************************************************/
int CalculatorBase::ShouldBreakFromProgram(CalculatorBase* CalcPtr_)
{
  if (CalcPtr_ && !CalcPtr_->ActiveProgram())
  {
    SetBreakFromProgram(FALSE);

    if (_SetBreakResponse)
    {
      bool IoAccess_ = CalcPtr_->GiveIoAccessCondition(CalcPtr_, IOACCESS);
      _SetBreakResponse = FALSE;
      _PostBreakResponseSent = TRUE;

      if (IoAccess_)
        CalcPtr_->SetIoState(Mcalc_IOState::CALC_RESPONSE);
      else
        CalcPtr_->SetIoState(Mcalc_IOState::BREAK_PROGRAM);
    }
  }

  if (_SetBreakResponse && CalcPtr_ && CalcPtr_->ActiveProgram())
  {
    _BreakFromProgram = TRUE;
    CalcPtr_->SetIoState(Mcalc_IOState::BREAK_PROGRAM);
  }

  return _BreakFromProgram;
}

/****************************************************************************/
/****************************************************************************/
void CalculatorBase::ShowTheList(SimpleList<int>& x)
{
  if (!x.Size())
  {
    cout <<"{ null }" <<endl;
    return;
  }

  SimpleListIterator<int> Iter_(&x);
  cout <<"{ ";

  for (int i = 0; i < x.Size(); ++i)
    if (Iter_.IndexNode(i) && Iter_.IndexNode(i)->_Object)
    {
      cout <<(*Iter_.IndexNode(i)->_Object);
      if (i < x.Size() - 1)
        cout <<",";
    }

  cout <<" }";
  cout <<endl;
}

/****************************************************************************/
ChrString CalculatorBase::MakeTheList(SimpleList<int>& x)
{
  ChrString Result_;

  if (!x.Size())
  {
    Result_ = ChrString("{ null }");
    return Result_;
  }

  char Buffer_[32];
  SimpleListIterator<int> Iter_(&x);
  Result_ = "{ ";

  for (int i = 0; i < x.Size(); ++i)
    if (Iter_.IndexNode(i) && Iter_.IndexNode(i)->_Object)
    {
      IntToStr(*Iter_.IndexNode(i)->_Object, Buffer_);
      Result_ += ChrString(Buffer_);
      if (i < x.Size() - 1)
        Result_ += ChrString(",");
    }

  Result_ += ChrString(" }");
  return Result_;
}

/****************************************************************************/
int CalculatorBase::InSetNotation(const char* Str_)
{
  char* Res_ = ::NewString(Str_);
  char* ptr;
  char* tok;
  char* nptr;

  RemovePadding(Res_, " \t\n\r");
  size_t len = ::SafeStrLen(Res_);
  size_t plen;
  int i = 0;
  int ok = 0;
  int nextnum = 0;

  if (!len)
  {
    ::RawDeleteArray(Res_);
    Res_ = NULL;
    return 0;
  }

  if (Res_[i] == '{' && Res_[i+1] == ' ')
  {
    nextnum = 1;
    nptr = Res_ + 2;
    ptr = nptr ? strchr(nptr, ','):NULL;

    if (ptr)
    {
      *ptr = 0;
      tok = nptr;
      nptr = ptr+1;
    }
    else
    {
      tok = nptr;
      nptr = NULL;
    }

    plen = ::SafeStrLen(tok);

    if (!plen)
    {
      ::RawDeleteArray(Res_);
      Res_ = NULL;
      return ok;
    }
    else
      i = tok - Res_;

    while (i < len)
    {
      if (nextnum)
      {
        if (tok[plen-1] == '}')
        {
          tok[plen-2] = 0;
          i = len;
        }

        if (IsInt(tok))
          nextnum = 0;
        else if (tok)
        {
          ok = strcmp(tok, "null") == 0;
          ::RawDeleteArray(Res_);
          Res_ = NULL;
          return ok;
        }
      }
      else if (i < len)
      {
        nextnum = 1;
        ptr = nptr ? strchr(nptr, ','):NULL;

        if (ptr)
        {
          *ptr = 0;
          tok = nptr;
          nptr = ptr+1;
        }
        else
        {
          tok = nptr;
          nptr = NULL;
        }

        plen = ::SafeStrLen(tok);

        if (!plen)
        {
          ::RawDeleteArray(Res_);
          Res_ = NULL;
          return ok;
        }
        else
          i = tok - Res_;
      }
    }
  }

  ::RawDeleteArray(Res_);
  Res_ = NULL;

  return (i == len);
}

/****************************************************************************/
char* CalculatorBase::RemoveDuplicateSetItems(char* SetStr_)
{
  size_t len = ::SafeStrLen(SetStr_);
  if (!len)
    return SetStr_;

  size_t x = 0;
  size_t y = 0;
  size_t v = 0;
  size_t c = 0;
  size_t nv = 0;
  size_t br = 0;

  bool vset = false;
  bool cset = false;
  bool nvset = false;
  bool brset = false;

  for (x = 0; x < len; x++)
    if (isdigit(SetStr_[x]))
    {
      if (vset)
      {
        for (y = x; y < len; y++)
          if (isdigit(SetStr_[y]))
          {
            nv = atoi(&SetStr_[y]);

            if (v == nv)
            {
              nvset = true;

              while (y < len && isdigit(SetStr_[y]))
                SetStr_[y++] = ' ';

              if (y < len && SetStr_[y] == ',')
              {
                SetStr_[y] = ' ';
                cset = false;
              }
            }
            else
            {
              for (;y < len &&
                    (isdigit(SetStr_[y]) || isspace(SetStr_[y])); y++);

              if (y < len && SetStr_[y] == ',')
              {
                c = y;
                cset = true;
                nvset = false;
              }
              else
                --y;
            }
          }
          else if (y < len && SetStr_[y] == ',')
          {
            c = y;
            cset = true;
            nvset = false;
          }
          else if (y < len && SetStr_[y] == '}')
          {
            br = y;
            brset = true;

            if (cset && nvset)
            {
              SetStr_[c] = ' ';
              cset = false;
            }
          }

        vset = false;
      }
      else
      {
        v = atoi(&SetStr_[x]);
        vset = true;
      }

      if (!vset)
      {
        for (;x < len; x++)
          if (isdigit(SetStr_[x]))
          {
            v = atoi(&SetStr_[x]);
            vset = true;
            break;
          }
          else if (x < len && SetStr_[x] == ',')
          {
            c = x;
            cset = true;
            nvset = false;
          }
      }

      for (;x < len &&
            (isdigit(SetStr_[x]) || isspace(SetStr_[x])); x++);

      if (x < len && SetStr_[x] == ',')
      {
        c = x;
        cset = true;
        nvset = false;
      }
      else
        --x;
    }
    else if (x < len && SetStr_[x] == ',')
    {
      c = x;
      cset = true;
      nvset = false;
    }

  if (brset)
  {
    for (x = br; x; x--)
      if (SetStr_[x] == ',')
        SetStr_[x] = ' ';
      else if (SetStr_[x] != '}' && !isspace(SetStr_[x]))
        break;
  }

  return SetStr_;
}

/****************************************************************************/
Set<int>* CalculatorBase::MakeIntSet(const char* Str_, int Iter_)
{
  Set<int>* Set_ = new Set<int>;

  char* Res_ = ::NewString(Str_);
  char* ptr;
  char* tok;
  char* nptr;

  RemovePadding(Res_, " \t\n\r");
  size_t len = ::SafeStrLen(Res_);
  size_t plen;
  int i = 0;
  int x = 0;
  int ok = 0;
  int val;
  int nextnum = 0;

  bool Spc_ = false;
  bool InDigit_ = false;
  bool InvalidSet_ = false;

  if (!len)
  {
    ::RawDeleteArray(Res_);
    Res_ = NULL;
    return Set_;
  }

  if (Res_[i] == '{' && Res_[i+1] == ' ' &&
      (strcmp(Str_, Res_) != 0 ||
       strcmp(Str_, "{ null }") != 0))
  {
    Res_ = RemoveDuplicateSetItems(Res_);
    RemovePadding(Res_, " \t\n\r");
    len = ::SafeStrLen(Res_);

    if (!len)
    {
      ::RawDeleteArray(Res_);
      Res_ = NULL;
      return Set_;
    }

    i = strspn(&Res_[i+1], " \t\n\r");

    if (Res_[i+1])
    {
      ++i;

      if (Res_[i] == '}')
      {
        if (!Res_[i+1])
        {
          if (Iter_ == 0 &&
              (strlen(Str_) != len ||
               strcmp(Str_, Res_) != 0 ||
               strcmp(Str_, "{ null }") != 0))
            return MakeIntSet("{ null }", Iter_+1);
        }
        else
          InvalidSet_ = true;
      }
      else if (isdigit(Res_[i]))
      {
        InDigit_ = true;

        for (x = i; Res_[x]; x++)
          if (InDigit_)
          {
            if (Res_[x] == ',')
            {
              InDigit_ = false;
              Spc_ = false;
            }
            else if (isspace(Res_[x]))
              Spc_ = true;
            else if (!Spc_ && isdigit(Res_[x]))
              continue;
            else
              break;
          }
          else if (!InDigit_)
          {
            if (isdigit(Res_[x]))
            {
              InDigit_ = true;
              Spc_ = false;
            }
            else if (isspace(Res_[x]))
            {
              Spc_ = true;
              continue;
            }
            else
              break;
          }

        if (InDigit_ && Spc_ && Res_[x] == '}')
        {
          if (!Res_[x+1])
            i = 0;
          else
            InvalidSet_ = true;
        }
      }
      else if (toupper(Res_[i]) == 'N' &&
               strcmp(&Res_[i], "null }") == 0 && !Res_[i+6])
      {
        if (Iter_ == 0 &&
            (strlen(Str_) != len ||
             strcmp(Str_, Res_) != 0 ||
             strcmp(Str_, "{ null }") != 0))
          return MakeIntSet("{ null }", Iter_+1);
      }
      else
        InvalidSet_ = true;
    }
    else
      InvalidSet_ = true;

    if (InvalidSet_)
    {
      ::RawDeleteArray(Res_);
      Res_ = NULL;
      return Set_;
    }
  }

  if (Res_[i] == '{' && Res_[i+1] == ' ')
  {
    nextnum = 1;
    nptr = Res_ + 2;
    ptr = nptr ? strchr(nptr, ','):NULL;

    if (ptr)
    {
      *ptr = 0;
      tok = nptr;
      nptr = ptr+1;
    }
    else
    {
      tok = nptr;
      nptr = NULL;
    }

    plen = ::SafeStrLen(tok);

    if (!plen)
    {
      ::RawDeleteArray(Res_);
      Res_ = NULL;
      return Set_;
    }
    else
      i = tok - Res_;

    while (i < len)
    {
      if (nextnum)
      {
        if (tok[plen-1] == '}')
        {
          tok[plen-2] = 0;
          i = len;
        }

        if (tok && strcmp(tok, "null") == 0)
        {
          ::RawDeleteArray(Res_);
          Res_ = NULL;
          return Set_;
        }
        else
        {
          val = atoi(tok);
          *Set_ |= &val;
          nextnum = 0;
        }
      }
      else if (i < len)
      {
        nextnum = 1;
        ptr = nptr ? strchr(nptr, ','):NULL;

        if (ptr)
        {
          *ptr = 0;
          tok = nptr;
          nptr = ptr+1;
        }
        else
        {
          tok = nptr;
          nptr = NULL;
        }

        plen = ::SafeStrLen(tok);

        if (!plen)
        {
          ::RawDeleteArray(Res_);
          Res_ = NULL;
          return Set_;
        }
        else
          i = tok - Res_;
      }
    }
  }

  ::RawDeleteArray(Res_);
  Res_ = NULL;
  return Set_;
}

/*****************************************************************************/
int CalculatorBase::InSetNotation(const char* list, int& NewStart_, int& LiteralLen_, int Start_, int len)
{
  if (!list)
    return FALSE;

  int InSet_ = 0;
  int z1, z2, x;

  for (z1 = Start_; isspace(list[z1]) && z1 < len; z1++);
  if (list[z1] == '{')
  {
    for (z2 = len - 1; isspace(list[z2]) && z2 >= 0; z2--);
    if (list[z2] == '}')
    {
      z1++;
      x = z2 - z1;
      NewStart_ = z1;
      LiteralLen_ = x;
      InSet_ = (x >= 0) ? InSetNotation(list+z1):0;
      return InSet_;
    }
  }

  LiteralLen_ = 0;
  return FALSE;
}

/*****************************************************************************/
int CalculatorBase::IsNullSetStr(const char* Str_)
{
  if (!Str_)
    return 0;

  ChrString Res_ = Str_;
  Res_.RemovePadding(" \t\n\r");
  int Match_ = FunctionValidityChecker::IsNullSet(Res_.c_str());
  return Match_;
}

/*****************************************************************************/
void CalculatorBase::SetPlotGraph(bool SetPlot_, int PlotFlag_,
                                  bool SetGrOp_, int GrOpFlag_, int Reset_)
{
  if (SetGrOp_)
    _GraphingOp = GrOpFlag_;

  if (SetGrOp_ && _GraphingOp)
    MakeGraphPlotter(Reset_);
  else if (SetGrOp_ && !_GraphingOp)
  {
    DestroyGraphPlotter();
    ClearGraphTypeList();
  }

  if (SetPlot_ && _Plotter)
    _Plotter->SetPlotGraph(PlotFlag_);
}

/*****************************************************************************/
int CalculatorBase::GraphOperation()
{
  return _GraphingOp;
}

/*****************************************************************************/
bool CalculatorBase::DoPlotGraph()
{
  return (_Plotter ? _Plotter->DoPlotGraph():false);
}

/*****************************************************************************/
void CalculatorBase::SetPlotAllPoints(bool Flag_)
{
  if (_Plotter)
    _Plotter->SetPlotAllPoints(Flag_);
}

/*****************************************************************************/
bool CalculatorBase::PlotAllPoints()
{
  return (_Plotter ? _Plotter->PlotAllPoints():false);
}

/****************************************************************************/
int* CalculatorBase::GrowGraphTypeList(int incr)
{
  if (_GraphTypeListSize && _GraphTypeList)
  {
    int x;
    int* oldls = _GraphTypeList;
    int oldsz = _GraphTypeListSize;

    _GraphTypeListSize += incr ? (incr * 3):(LISTINCR * 3);
    _GraphTypeList = (int*)MemMatrix::Matrix().Callocate(_GraphTypeListSize * sizeof(int));

    for (x = 0; x < oldsz; x++)
      _GraphTypeList[x] = oldls[x];

    for (;x < _GraphTypeListSize; x++)
      _GraphTypeList[x] = 0;

    RawDeleteArray(oldls);
  }
  else
  {
    _GraphTypeListIndex = 0;
    _GraphTypeListSize = incr ? (incr * 3):(LISTINCR * 3);
    _GraphTypeList = (int*)MemMatrix::Matrix().Callocate(_GraphTypeListSize * sizeof(int));

    _GraphTypeList =
    (int*)::memset(_GraphTypeList, 0, sizeof(int) * _GraphTypeListSize);
  }

  return _GraphTypeList;
}

/****************************************************************************/
int* CalculatorBase::DestroyGraphTypeList()
{
  if (_GraphTypeListSize && _GraphTypeList)
  {
    RawDeleteArray(_GraphTypeList);
    _GraphTypeList = NULL;

    _GraphType =
    _GraphSubtype =
    _GraphTypeListSize =
    _GraphTypeListIndex = 0;
  }

  return _GraphTypeList;
}

/****************************************************************************/
int* CalculatorBase::ClearGraphTypeList()
{
  if (_GraphTypeListSize && _GraphTypeList &&
      (_GraphType || _GraphSubtype || _GraphTypeListIndex || *_GraphTypeList))
  {
    _GraphTypeList =
    (int*)::memset(_GraphTypeList, 0, sizeof(int) * _GraphTypeListSize);

    _GraphType =
    _GraphSubtype =
    _GraphTypeListIndex = 0;
  }
}

/****************************************************************************/
int CalculatorBase::TotalGraphTypes()
{
  return (_GraphTypeListIndex / 3);
}

/*****************************************************************************/
void CalculatorBase::SetGraphType(int Type_,  int Subtype_)
{
  ClearGraphTypeList();

  _GraphType = Type_;
  _GraphSubtype = Subtype_;

  if (_GraphType == 0)
    _GraphSubtype = 0;
  else
    AddGraphType(Type_, Subtype_, 0);
}

/*****************************************************************************/
void CalculatorBase::ReplaceGraphType(int Type_,  int Subtype_)
{
  if (Type_ == 0)
    SetGraphType(Type_, Subtype_);
  else
  {
    _GraphType = Type_;
    _GraphSubtype = Subtype_;

    AddGraphType(Type_, Subtype_, 0);
  }
}

/*****************************************************************************/
const int* CalculatorBase::GraphTypeVect()
{
  return ((_GraphType && TotalGraphTypes() > 0) ? _GraphTypeList:NULL);
}

/****************************************************************************/
void CalculatorBase::AddGraphType(int Type_, int Subtype_, int Index_)
{
  int x = Index_;
  bool FreshLs_ = !_GraphTypeListSize || !_GraphTypeList;

  if (FreshLs_ || _GraphTypeListSize == _GraphTypeListIndex)
    GrowGraphTypeList();

  if (FreshLs_)
    x = Index_ = _GraphTypeListIndex = 0;

  _GraphTypeList[x++] = Type_;
  _GraphTypeList[x++] = Subtype_;
  _GraphTypeList[x++] = 0;

  if (Index_ == _GraphTypeListIndex)
    _GraphTypeListIndex = x;
}

/****************************************************************************/
void CalculatorBase::AddGraphType(int Type_, int Subtype_)
{
  if (!HasGraphType(Type_, Subtype_, true))
    AddGraphType(Type_, Subtype_, _GraphTypeListIndex);
}

/****************************************************************************/
const int* CalculatorBase::NextGraphTypeVect(int& Index_, bool IncrNext_)
{
  int x;
  const int* retp = NULL;

  if (0 < Index_ && Index_ < TotalGraphTypes())
  {
    x = Index_ * 3;
    retp = _GraphTypeList + x;

    if (IncrNext_)
      ++Index_;
  }

  return retp;
}

/****************************************************************************/
bool CalculatorBase::HasGraphType(int Type_, int Subtype_, bool Skip1st_)
{
  int minsubtype_ = Mcalc_GraphType::MIN_EXTREMA;
  int sgptype_ = (Subtype_ && (Subtype_ >= minsubtype_)) ? Subtype_:
                 (Type_ && (Type_ >= minsubtype_))       ? Type_:0;
  int mgptype_ = (Type_ && (Type_ < minsubtype_))        ? Type_:
                 (Subtype_ && (Subtype_ < minsubtype_))  ? Subtype_:0;
  int mg2type_ = mgptype_ ?
                 ((mgptype_ == Type_ && (Subtype_ < minsubtype_)) ? Subtype_:
                  (mgptype_ == Subtype_ && (Type_ < minsubtype_)) ? Type_:0):0;

  if (!mgptype_ ||
      mgptype_ < 0 || mg2type_ < 0 || sgptype_ < 0)
    return false;

  int x, i;
  int max = TotalGraphTypes();
  int* retp = NULL;

  for (x = Skip1st_ ? 1:0; x < max; x++)
  {
    i = x * 3;
    retp = _GraphTypeList+i;

    if ((mgptype_ && retp[0] == mgptype_) ||
        (mg2type_ && retp[0] == mg2type_))
      return (!sgptype_ || retp[1] == sgptype_);
  }

  return false;
}

/*****************************************************************************/
const char* CalculatorBase::GraphPlotOpTypeToStr(int PlotOpType_)
{
  return
  (
    (PlotOpType_ == Mcalc_GraphPlotOpType::NO_GRAPH)         ? "NO_GRAPH":
    (PlotOpType_ == Mcalc_GraphPlotOpType::FUNCTION_PLOT)    ? "FUNCTION_PLOT":
    (PlotOpType_ == Mcalc_GraphPlotOpType::APPLIED_FNCGRAPH) ? "APPLIED_FNCGRAPH":
    (PlotOpType_ == Mcalc_GraphPlotOpType::BATCH_GRAPH_PLOT) ? "BATCH_GRAPH_PLOT":""
  );
}

/*****************************************************************************/
const char* CalculatorBase::GraphTypeToStr(int GraphType_)
{
  return
  (
    (GraphType_ == Mcalc_GraphType::NO_GRAPH)     ? "NO_GRAPH":

    (GraphType_ == Mcalc_GraphType::FUNCTION)     ? "FUNCTION":
    (GraphType_ == Mcalc_GraphType::EXTREMA)      ? "EXTREMA":
    (GraphType_ == Mcalc_GraphType::DERIVATIVE)   ? "DERIVATIVE":
    (GraphType_ == Mcalc_GraphType::INTEGRAL)     ? "INTEGRAL":
    (GraphType_ == Mcalc_GraphType::ROOTSOLVE)    ? "ROOTSOLVE":
    (GraphType_ == Mcalc_GraphType::INTERSECT1)   ? "INTERSECT1":
    (GraphType_ == Mcalc_GraphType::INTERSECT2)   ? "INTERSECT2":

    (GraphType_ == Mcalc_GraphType::MIN_EXTREMA)  ? "MIN_EXTREMA":
    (GraphType_ == Mcalc_GraphType::MAX_EXTREMA)  ? "MAX_EXTREMA":

    (GraphType_ == Mcalc_GraphType::FIRST_DERIV)  ? "FIRST_DERIV":
    (GraphType_ == Mcalc_GraphType::SECOND_DERIV) ? "SECOND_DERIV":""
  );
}

/*****************************************************************************/
int CalculatorBase::GraphType()
{
  return ((_GraphTypeListSize && TotalGraphTypes() > 0) ? _GraphType:0);
}

/*****************************************************************************/
int CalculatorBase::GraphSubtype()
{
  return ((_GraphTypeListSize && TotalGraphTypes() > 0) ? _GraphSubtype:0);
}

/*****************************************************************************/
void CalculatorBase::SetPlottingGraph(bool flag_)
{
  if (_Plotter)
    _Plotter->SetPlottingGraph(flag_);
}

/*****************************************************************************/
bool CalculatorBase::PlottingGraph()
{
  return (_Plotter ? _Plotter->PlottingGraph():false);
}

/*****************************************************************************/
void CalculatorBase::SetPlottingDone(bool flag_)
{
  if (_Plotter)
    _Plotter->SetPlottingDone(flag_);
}

/*****************************************************************************/
bool CalculatorBase::PlottingDone()
{
  return (_Plotter ? _Plotter->PlottingDone():true);
}

/*****************************************************************************/
void CalculatorBase::SetGraphCompleted(bool flag_)
{
  if (_Plotter)
    _Plotter->SetGraphCompleted(flag_);
}

/*****************************************************************************/
bool CalculatorBase::GraphCompleted()
{
  return (_Plotter ? _Plotter->GraphCompleted():true);
}

/****************************************************************************/
void CalculatorBase::SetResponsePending(bool flag_)
{
  _IoStatePtr->SetResponsePending(flag_);
}

/****************************************************************************/
bool CalculatorBase::ResponsePending()
{
  return _IoStatePtr->ResponsePendingDone();
}

/****************************************************************************/
void CalculatorBase::SetClientAckToGraphWait(bool flag_)
{
  _IoStatePtr->SetClientAckToGraphWait(flag_);
}

/****************************************************************************/
bool CalculatorBase::ClientAckToGraphWait(bool InProc_)
{
  return _IoStatePtr->ClientAckToGraphWait(InProc_);
}

/****************************************************************************/
void CalculatorBase::SetGraphProgressSent(bool flag_)
{
  _IoStatePtr->SetGraphProgressSent(flag_);
}

/****************************************************************************/
bool CalculatorBase::GraphProgressSent()
{
  return _IoStatePtr->GraphProgressSentDone();
}

/****************************************************************************/
void CalculatorBase::SetClientAckToGraphProgress(bool flag_)
{
  _IoStatePtr->SetClientAckToGraphProgress(flag_);
}

/****************************************************************************/
bool CalculatorBase::ClientAckToGraphProgress(bool InProc_)
{
  return _IoStatePtr->ClientAckToGraphProgress(InProc_);
}

/****************************************************************************/
void CalculatorBase::SetResponseCompleted(bool flag_)
{
  _IoStatePtr->SetResponseCompleted(flag_);
}

/****************************************************************************/
bool CalculatorBase::ResponseCompleted()
{
  return _IoStatePtr->ResponseCompletedDone();
}

/****************************************************************************/
void CalculatorBase::SetResponseWasCompleted(bool flag_)
{
  _ResponseWasCompleted = flag_;
}

/****************************************************************************/
bool CalculatorBase::ResponseWasCompleted()
{
  return _ResponseWasCompleted;
}

/****************************************************************************/
void CalculatorBase::SetClientAckToGraphOutput(bool flag_)
{
  _IoStatePtr->SetClientAckToGraphOutput(flag_);
}

/****************************************************************************/
bool CalculatorBase::ClientAckToGraphOutput(bool InProc_)
{
  return _IoStatePtr->ClientAckToGraphOutput(InProc_);
}

/****************************************************************************/
void CalculatorBase::SetClientAckedDoneToGraphOutput(bool flag_)
{
  _ClientAckedDoneToGraphOutput = flag_;
}

/****************************************************************************/
bool CalculatorBase::ClientAckedDoneToGraphOutput()
{
  return _ClientAckedDoneToGraphOutput;
}

/*****************************************************************************/
void CalculatorBase::SetCalcProgressSent(bool flag_)
{
  _IoStatePtr->SetCalcProgressSent(flag_);
}

/*****************************************************************************/
bool CalculatorBase::CalcProgressSent()
{
  return _IoStatePtr->CalcProgressSentDone();
}

/*****************************************************************************/
void CalculatorBase::SetCalcProgressWasSent(bool flag_)
{
  _CalcProgressWasSent = flag_;
}

/*****************************************************************************/
bool CalculatorBase::CalcProgressWasSent()
{
  return _CalcProgressWasSent;
}

/*****************************************************************************/
void CalculatorBase::SetClientAckToCalcProgress(bool flag_)
{
  _IoStatePtr->SetClientAckToCalcProgress(flag_);
}

/*****************************************************************************/
bool CalculatorBase::ClientAckToCalcProgress(bool InProc_)
{
  return _IoStatePtr->ClientAckToCalcProgress(InProc_);
}

/*****************************************************************************/
void CalculatorBase::SetClientAckedDoneToCalcProgress(bool flag_)
{
  _ClientAckedDoneToCalcProgress = flag_;
}

/*****************************************************************************/
bool CalculatorBase::ClientAckedDoneToCalcProgress()
{
  return _ClientAckedDoneToCalcProgress;
}

/*****************************************************************************/
CalcGraphPlotter* CalculatorBase::MakeGraphPlotter(int Reset_)
{
  if (_Plotter)
  {
    if (Reset_)
    {
      _Plotter->Reset();
      ClearGraphTypeList();
    }

    _Plotter->SetParent(this);
  }
  else
    _Plotter = new CalcGraphPlotter(this);
}

/*****************************************************************************/
CalcGraphPlotter* CalculatorBase::GetGraphPlotter()
{
  return _Plotter;
}

/*****************************************************************************/
void CalculatorBase::DestroyGraphPlotter()
{
  if (_Plotter)
  {
    delete _Plotter;
    _Plotter = NULL;
  }
}

/*****************************************************************************/
void CalculatorBase::SetOwnsStringStack(bool flag_)
{
  if (_StringStack)
    _OwnsStrStack = flag_;
}

/*****************************************************************************/
bool CalculatorBase::OwnsStringStack()
{
  return _OwnsStrStack;
}

/*****************************************************************************/
bool CalculatorBase::HasStringStack()
{
  return (_StringStack != NULL);
}

/*****************************************************************************/
void CalculatorBase::ResetStringStack()
{
  _StringStack = NULL;
  _OwnsStrStack = false;
}

/*****************************************************************************/
ExprStringStack* CalculatorBase::MakeStringStack()
{
  _StringStack = new ExprStringStack();

  if (_StringStack)
  {
    _StringStack->SetAllocFnc(Mcalc_DefaultAllocFnc);
    _StringStack->SetDelFnc(Mcalc_DefaultDelFnc);
  }

  _OwnsStrStack = true;
  return _StringStack;
}

/*****************************************************************************/
ExprStringStack* CalculatorBase::DestroyStringStack()
{
  if (_OwnsStrStack && _StringStack)
  {
    delete _StringStack;
    _StringStack = NULL;
    _OwnsStrStack = false;
  }

  return _StringStack;
}

/*****************************************************************************/
ExprStringStack* CalculatorBase::GiveStringStack(bool MakeIfNull_)
{
  return ((MakeIfNull_ && !_StringStack) ? MakeStringStack():_StringStack);
}

/*****************************************************************************/
int CalculatorBase::IsFraction(const char* Str_)
{
    if (!Str_)
      return FALSE;

    const char* Ptr_ = strchr(Str_, '/');

    if (!Ptr_)
      return FALSE;

    ChrString Str1_ = &Ptr_[1];
    ChrString Str2_ = ChrString(Str_, Ptr_ - Str_);
    Str1_.RemovePadding(" \t\n\r");
    Str2_.RemovePadding(" \t\n\r");

    int ValidNum1_ = IsNumber(Str1_.c_str(), 1, 0, 0, 10) ||
                     IsFloat(Str1_.c_str()) ||
                     LongNumber::IsInSciNote(Str1_);
    int ValidNum2_ = IsNumber(Str2_.c_str(), 1, 0, 0, 10) ||
                     IsFloat(Str2_.c_str()) ||
                     LongNumber::IsInSciNote(Str2_);

    if (!ValidNum1_ || !ValidNum2_)
      return FALSE;

    return TRUE;
}

/*****************************************************************************
Procedure to check if symbol in expression is valid
*/
int CalculatorBase::HasOperandSymbols(char symbol, int HexOk_)
{
  return
  (
    symbol=='.' ||
    ((Uchar)symbol) == NAN_CONST ||
    ((Uchar)symbol) == INF_CONST ||
    ((Uchar)symbol) == PI_CONST ||
    ((Uchar)symbol) == E_CONST ||
    (HexOk_ ? IsHexc(symbol):IsDecc(symbol))
  );
}

/*****************************************************************************/
int CalculatorBase::HasOperandSymbols(char symbol)
{
  return HasOperandSymbols(symbol, GetCalcIndex() == CalculatorBase::LONGNUM);
}

/*****************************************************************************/
int CalculatorBase::IsConstSymbols(char symbol)
{
  return
  (
    ((Uchar)symbol) == E_CONST       ||
    ((Uchar)symbol) == PI_CONST      ||
    ((Uchar)symbol) == ANS_CONST     ||
    ((Uchar)symbol) == ANSSTR_CONST  ||
    ((Uchar)symbol) == NAN_CONST     ||
    ((Uchar)symbol) == INF_CONST     ||
    ((Uchar)symbol) == FRACANS_CONST
  );
}

/*****************************************************************************/
int CalculatorBase::IsConstString(const char* Str_, int Index_)
{
  if (!Str_)
    return 0;

  const char* Ptr_ = &Str_[Index_];
  return
  (
    (icasestrcompn(Ptr_, "FRACANS", 7)  ||
     icasestrcompn(Ptr_, "ANSSTR", 6)   ||
     icasestrcompn(Ptr_, "ANS", 3)      ||
     icasestrcompn(Ptr_, "INF", 3)      ||
     icasestrcompn(Ptr_, "NAN", 3)      ||
     icasestrcompn(Ptr_, "PI", 2))      ||
        (icasestrcompn(Ptr_, "E", 1)    &&
         !HasHexPrefix(Str_, Index_))
  );
}

/*****************************************************************************/
int CalculatorBase::IsConstString(const char* Str_, int Index_, int& tlen_)
{
  if (!Str_)
    return 0;

  const char* Ptr_ = &Str_[Index_];
  bool isconst_ = false;
  bool sl[5];
  ::memset(sl, 0, 5 * sizeof(bool));

  isconst_ = (
    (sl[4]=icasestrcompn(Ptr_, "FRACANS", 7))  ||
    (sl[3]=icasestrcompn(Ptr_, "ANSSTR", 6))   ||
    (sl[2]=icasestrcompn(Ptr_, "ANS", 3))      ||
    (sl[2]=icasestrcompn(Ptr_, "INF", 3))      ||
    (sl[2]=icasestrcompn(Ptr_, "NAN", 3))      ||
    (sl[1]=icasestrcompn(Ptr_, "PI", 2))       ||
        ((sl[0]=icasestrcompn(Ptr_, "E", 1))   &&
         !HasHexPrefix(Str_, Index_))
  );

  if (isconst_)
  {
    tlen_ = sl[4] ? 7:
            sl[3] ? 6:
            sl[2] ? 3:
            sl[1] ? 2:1;
  }

  return isconst_;
}

/*****************************************************************************/
int CalculatorBase::HasValidOpCodes(char symbol, int Base_)
{
  Uchar uch_ = (Uchar)symbol;

  if (Base_ != 10)
  {
    int ValidCodes_ =
    (
      uch_ == NOT_OP        ||
      uch_ == XOR_OP        ||
      uch_ == AND_OP        ||
      uch_ == LSTHANOREQ_OP ||
      uch_ == GRTHANOREQ_OP ||
      uch_ == EQUAL_OP      ||
      uch_ == NOTEQUAL_OP   ||
      uch_ == OR_OP         ||
      uch_ == ANS_CONST     ||
      uch_ == ANSSTR_CONST
    );

    if (ValidCodes_)
      return TRUE;
  }

  int AllCodes_ =
  (
    IsConstSymbols(symbol) ||
    IsBinaryOpCodes(symbol) ||
    IsUnaryOpCodes(symbol)
  );

  return ((Base_ != 10) ? !AllCodes_:AllCodes_);
}

/*****************************************************************************/
int CalculatorBase::IsBinaryOpCodes(char ch_)
{
  Uchar uch_ = (Uchar)ch_;
  return
  (
    uch_ == PERMREP_OP    ||
    uch_ == COMBREP_OP    ||
    uch_ == COMB_OP       ||
    uch_ == PERM_OP       ||
    uch_ == XOR_OP        ||
    uch_ == AND_OP        ||
    uch_ == LSTHANOREQ_OP ||
    uch_ == GRTHANOREQ_OP ||
    uch_ == EQUAL_OP      ||
    uch_ == NOTEQUAL_OP   ||
    uch_ == OR_OP         ||
    uch_ == SCI_OP
  );
}

/*****************************************************************************/
int CalculatorBase::IsBinaryFunctions(const char* Str_, int Index_)
{
  if (!Str_)
    return 0;

  const char* Ptr_ = &Str_[Index_];
  return
  (
    (icasestrcompn(Ptr_, "COMBREP", 7)  ||
     icasestrcompn(Ptr_, "PERMREP", 7)  ||
     icasestrcompn(Ptr_, "COMB", 4)     ||
     icasestrcompn(Ptr_, "PERM", 4)     ||
     icasestrcompn(Ptr_, "XOR", 3)      ||
     icasestrcompn(Ptr_, "AND", 3)      ||
     icasestrcompn(Ptr_, "<=", 2)       ||
     icasestrcompn(Ptr_, ">=", 2)       ||
     icasestrcompn(Ptr_, "==", 2)       ||
     icasestrcompn(Ptr_, "!=", 2)       ||
     icasestrcompn(Ptr_, "OR", 2))      ||
        (icasestrcompn(Ptr_, "E", 1)    &&
         !HasHexPrefix(Str_, Index_))
  );
}

/*****************************************************************************/
int CalculatorBase::IsBinaryFunctions(const char* Str_, int Index_, int& tlen_, bool& isfnc_)
{
  if (!Str_)
    return 0;

  const char* Ptr_ = &Str_[Index_];
  bool isop_ = false;
  bool sl[5];
  ::memset(sl, 0, 5 * sizeof(bool));

  isfnc_ = (
    (sl[4]=icasestrcompn(Ptr_, "COMBREP", 7))  ||
    (sl[4]=icasestrcompn(Ptr_, "PERMREP", 7))  ||
    (sl[3]=icasestrcompn(Ptr_, "COMB", 4))     ||
    (sl[3]=icasestrcompn(Ptr_, "PERM", 4))
  );

  if (isfnc_)
  {
    tlen_ = sl[4] ? 7:
            sl[3] ? 4:1;
  }
  else
  {
    isop_ = (
      (sl[2]=icasestrcompn(Ptr_, "XOR", 3))    ||
      (sl[2]=icasestrcompn(Ptr_, "AND", 3))    ||

      (sl[1]=icasestrcompn(Ptr_, "OR", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "<=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, ">=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "==", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "!=", 2))     ||

      (sl[1]=icasestrcompn(Ptr_, "-=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "+=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "*=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "/=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "@=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "&=", 2))     ||
      (sl[1]=icasestrcompn(Ptr_, "|=", 2))     ||

      (toupper(*Ptr_) == 'E') ||
      (*Ptr_ == '=')  ||
      (*Ptr_ == '-')  ||
      (*Ptr_ == '+')  ||
      (*Ptr_ == '*')  ||
      (*Ptr_ == '/')  ||
      (*Ptr_ == '@')  ||
      (*Ptr_ == '^')  ||
      (*Ptr_ == '<')  ||
      (*Ptr_ == '>')
    );

    if (isop_)
      tlen_ = sl[2] ? 3:
              sl[1] ? 2:1;
  }

  return (isfnc_ || isop_);
}

/*****************************************************************************/
int CalculatorBase::IsUnaryOpCodes(char ch_)
{
  Uchar uch_ = (Uchar)ch_;
  return
  (
    uch_ == FRACPART_OP ||
    uch_ == INTPART_OP  ||
    uch_ == CUBERT_OP   ||
    uch_ == FLOOR_OP    ||
    uch_ == LOG10_OP    ||
    uch_ == ASIN_OP     ||
    uch_ == ACOS_OP     ||
    uch_ == ATAN_OP     ||
    uch_ == COSH_OP     ||
    uch_ == TANH_OP     ||
    uch_ == CEILING_OP  ||
    uch_ == SQRT_OP     ||
    uch_ == CUBE_OP     ||
    uch_ == RAND_OP     ||
    uch_ == SIN_OP      ||
    uch_ == COS_OP      ||
    uch_ == TAN_OP      ||
    uch_ == RND_OP      ||
    uch_ == EXP_OP      ||
    uch_ == LOG_OP      ||
    uch_ == ABS_OP      ||
    uch_ == SQR_OP      ||
    uch_ == INV_OP      ||
    uch_ == NOT_OP      ||
    uch_ == FACTORIAL_OP
  );
}

/*****************************************************************************/
int CalculatorBase::IsUnaryFunctions(const char* Str_)
{
  if (!Str_)
    return 0;

  return
  (
    icasestrcompn(Str_, "FRACPART", 8) ||
    icasestrcompn(Str_, "INTPART", 7)  ||
    icasestrcompn(Str_, "CUBERT", 6)   ||
    icasestrcompn(Str_, "FLOOR", 5)    ||
    icasestrcompn(Str_, "LOG10", 5)    ||
    icasestrcompn(Str_, "ASIN", 4)     ||
    icasestrcompn(Str_, "ACOS", 4)     ||
    icasestrcompn(Str_, "ATAN", 4)     ||
    icasestrcompn(Str_, "SINH", 4)     ||
    icasestrcompn(Str_, "COSH", 4)     ||
    icasestrcompn(Str_, "TANH", 4)     ||
    icasestrcompn(Str_, "CEIL", 4)     ||
    icasestrcompn(Str_, "SQRT", 4)     ||
    icasestrcompn(Str_, "CUBE", 4)     ||
    icasestrcompn(Str_, "RAND", 4)     ||
    icasestrcompn(Str_, "SIN", 3)      ||
    icasestrcompn(Str_, "COS", 3)      ||
    icasestrcompn(Str_, "TAN", 3)      ||
    icasestrcompn(Str_, "RND", 3)      ||
    icasestrcompn(Str_, "EXP", 3)      ||
    icasestrcompn(Str_, "LOG", 3)      ||
    icasestrcompn(Str_, "ABS", 3)      ||
    icasestrcompn(Str_, "SQR", 3)      ||
    icasestrcompn(Str_, "INV", 3)      ||
    icasestrcompn(Str_, "NOT", 3)
  );
}

/*****************************************************************************/
int CalculatorBase::IsUnaryFunctions(const char* Str_, int Index_, int& tlen_, bool& isfnc_)
{
  if (!Str_)
    return 0;

  const char* Ptr_ = &Str_[Index_];
  bool isop_ = false;
  bool sl[6];
  ::memset(sl, 0, 6 * sizeof(bool));

  isfnc_ = (
    (sl[5]=icasestrcompn(Ptr_, "FRACPART", 8)) ||
    (sl[4]=icasestrcompn(Ptr_, "INTPART", 7))  ||
    (sl[3]=icasestrcompn(Ptr_, "CUBERT", 6))   ||
    (sl[3]=icasestrcompn(Ptr_, "ARCSIN", 6))   ||
    (sl[3]=icasestrcompn(Ptr_, "ARCCOS", 6))   ||
    (sl[3]=icasestrcompn(Ptr_, "ARCTAN", 6))   ||
    (sl[2]=icasestrcompn(Ptr_, "FLOOR", 5))    ||
    (sl[2]=icasestrcompn(Ptr_, "LOG10", 5))    ||
    (sl[1]=icasestrcompn(Ptr_, "ASIN", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "ACOS", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "ATAN", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "SINH", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "COSH", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "TANH", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "CEIL", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "SQRT", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "CUBE", 4))     ||
    (sl[1]=icasestrcompn(Ptr_, "RAND", 4))     ||
    (sl[0]=icasestrcompn(Ptr_, "SIN", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "COS", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "TAN", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "RND", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "EXP", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "LOG", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "ABS", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "SQR", 3))      ||
    (sl[0]=icasestrcompn(Ptr_, "INV", 3))
  );

  if (isfnc_)
  {
    tlen_ = sl[5] ? 8:
            sl[4] ? 7:
            sl[3] ? 6:
            sl[2] ? 5:
            sl[1] ? 4:3;
  }
  else
  {
    isop_ = (
      (sl[0]=icasestrcompn(Ptr_, "NOT", 3)) ||
      (*Ptr_ == '-')  ||
      (*Ptr_ == '+')
    );

    if (isop_)
      tlen_ = sl[0] ? 3:1;
  }

  return (isfnc_ || isop_);
}

/*****************************************************************************/
int CalculatorBase::IsCalledFunctions(const char* Str_)
{
  if (!Str_)
    return 0;

  int SetOpFncs_ =
    icasestrcompn(Str_, "SETUNI", 6)         ||
    icasestrcompn(Str_, "SETINT", 6)         ||
    icasestrcompn(Str_, "SETDIF", 6)         ||
    icasestrcompn(Str_, "SETXDIF", 7);

  return
  (
    icasestrcompn(Str_, "MIN", 3)            ||
    icasestrcompn(Str_, "MAX", 3)            ||
    icasestrcompn(Str_, "DERIV", 5)          ||
    icasestrcompn(Str_, "DERIV2", 6)         ||
    icasestrcompn(Str_, "INTEG", 5)          ||
    icasestrcompn(Str_, "FMIN", 4)           ||
    icasestrcompn(Str_, "FMAX", 4)           ||
    icasestrcompn(Str_, "ROUND", 5)          ||
    icasestrcompn(Str_, "SOLVE", 5)          ||
    icasestrcompn(Str_, "INTERSECT", 9)      ||
    icasestrcompn(Str_, "COMBREP", 7)        ||
    icasestrcompn(Str_, "PERMREP", 7)        ||
    icasestrcompn(Str_, "COMB", 4)           ||
    icasestrcompn(Str_, "PERM", 4)           ||
    icasestrcompn(Str_, "ITEMCOMBREP", 11)   ||
    icasestrcompn(Str_, "ITEMPERMREP", 11)   ||
    icasestrcompn(Str_, "ITEMCOMB", 8)       ||
    icasestrcompn(Str_, "ITEMPERM", 8)       ||
    icasestrcompn(Str_, "FRAC", 4)           ||
    SetOpFncs_                               ||
    (icasestrcompn(Str_, "SET", 3) &&
     !SetOpFncs_)                            ||
    icasestrcompn(Str_, "SUM", 3)            ||
    icasestrcompn(Str_, "PROD", 4)           ||
    icasestrcompn(Str_, "STDDEV", 6)         ||
    icasestrcompn(Str_, "AVGMODE", 7)        ||
    icasestrcompn(Str_, "AVGMEAN", 7)        ||
    icasestrcompn(Str_, "AVGMED", 6)         ||
    icasestrcompn(Str_, "RECTOPOLR", 9)      ||
    icasestrcompn(Str_, "RECTOPOLA", 9)      ||
    icasestrcompn(Str_, "POLTORECX", 9)      ||
    icasestrcompn(Str_, "POLTORECY", 9)      ||
    icasestrcompn(Str_, "EVAL", 4)           ||
    icasestrcompn(Str_, "SHOW", 4)           ||
    icasestrcompn(Str_, "SHOWSET", 7)        ||
    icasestrcompn(Str_, "FROMHEX", 7)        ||
    icasestrcompn(Str_, "FROMOCT", 7)        ||
    icasestrcompn(Str_, "FROMBIN", 7)        ||
    icasestrcompn(Str_, "FROMCMP2BIN", 11)   ||
    icasestrcompn(Str_, "TOHEX", 5)          ||
    icasestrcompn(Str_, "TOOCT", 5)          ||
    icasestrcompn(Str_, "TOBIN", 5)          ||
    icasestrcompn(Str_, "TOCMP2BIN", 9)
  );
}

/*****************************************************************************/
int CalculatorBase::IsBinaryOperators(char symbol)
{
  return
  (
    symbol=='-' ||
    symbol=='+' ||
    symbol=='*' ||
    symbol=='/' ||
    symbol=='@' ||
    symbol=='^' ||
    symbol=='<' ||
    symbol=='>'
  );
}

/*****************************************************************************/
int CalculatorBase::IsUnaryOperators(char symbol)
{
  return
  (
    symbol=='-' ||
    symbol=='+'
  );
}

/*****************************************************************************/
int CalculatorBase::IsPostfixOperators(char symbol)
{
  return (symbol=='%');
}

/*****************************************************************************/
int CalculatorBase::IsLeftBrkSymbols(char symbol)
{
  return
  (
    symbol=='(' ||
    symbol=='[' ||
    symbol=='{'
  );
}

/*****************************************************************************/
int CalculatorBase::IsRightBrkSymbols(char symbol)
{
  return
  (
    symbol==')' ||
    symbol==']' ||
    symbol=='}'
  );
}

/*****************************************************************************/
int CalculatorBase::IsBrkSymbols(char symbol)
{
  return
  (
    symbol=='(' ||
    symbol==')' ||
    symbol=='[' ||
    symbol==']' ||
    symbol=='{' ||
    symbol=='}'
  );
}

/*****************************************************************************/
int CalculatorBase::IsUnprocessedSymbols(char symbol)
{
  return
  (
    symbol=='(' ||
    symbol==')' ||
    symbol=='[' ||
    symbol==']' ||
    symbol=='{' ||
    symbol=='}' ||
    symbol==',' ||
    isspace(symbol)
  );
}

/****************************************************************************/
const char* CalculatorBase::GetSpawnArgFilename()
{
  return SPAWNARG_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetLogFilename()
{
  return LOG_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetCurrentErrorFilename()
{
  return CURRENTERROR_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetProgressFilename()
{
  return PROGRESS_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetElapsedTimeFilename()
{
  return ELAPSEDTIME_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetUserInputFilename()
{
  return USER_INPUT_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetUserPromptFilename()
{
  return USER_PROMPT_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetProgramOutputFilename()
{
  return PROG_OUTPUT_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetCommandHistoryFilename()
{
  return CMDHISTORY_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetDataInputFilename()
{
  return DATA_INPUT_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetDataOutputFilename()
{
  return DATA_OUTPUT_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetProgramIostateFilename()
{
  return PROG_IOSTATE_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetCurrentGraphFilename()
{
  return CURRENTGRAPH_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetGraphOperationFilename()
{
  return GRAPH_OPERATION_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetGraphProgressFilename()
{
  return GRAPH_PROGRESS_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetPollStateFilename()
{
  return POLLSTATE_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetClientAliveFilename()
{
  return CLIENTALIVE_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetServerAliveFilename()
{
  return SERVERALIVE_FILE;
}

/****************************************************************************/
const char* CalculatorBase::GetFileSessionNumberSuffix()
{
  return FILE_SESNUM_SUFFIX;
}

/****************************************************************************/
CalculatorBase* CalculatorBase::SetNoPolling(bool flag_)
{
  _NoPolling = flag_;
  return this;
}

/****************************************************************************/
int CalculatorBase::NoPolling() const
{
  return _NoPolling;
}

/****************************************************************************/
void CalculatorBase::SetInputPromptWarning(bool Flag_)
{
  _InputPromptWarning = Flag_;
}

/****************************************************************************/
bool CalculatorBase::InputPromptWarning()
{
  return _InputPromptWarning;
}

/****************************************************************************/
bool CalculatorBase::IsOutputFileEmpty_Main(int IoState_, bool Reverse_,
                                            bool WarnOnInput_)
{
  #if CALCLIB_DEBUG8c
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::IsOutputFileEmpty_Main");
  #endif

  bool retval = Reverse_ ?
   ((IoState_ == Mcalc_IOState::CALC_RESPONSE ||
     IoState_ == Mcalc_IOState::OUTPUT_READY) ?
       (FileSize(GetGuiOutputFile(true, false)) != 0):
    (IoState_ == Mcalc_IOState::INPUT_REQUIRED) ?
       (!SessionOption() &&
        FileSize(GetUserPromptFile(true, false)) != 0):
       false):
   ((IoState_ == Mcalc_IOState::CALC_RESPONSE ||
     IoState_ == Mcalc_IOState::OUTPUT_READY) ?
       (FileSize(GetGuiOutputFile(true, false)) == 0):
    (IoState_ == Mcalc_IOState::INPUT_REQUIRED) ?
       (!SessionOption() &&
        FileSize(GetUserPromptFile(true, false)) == 0):
       false);

  if (!SessionOption() &&
      IoState_ == Mcalc_IOState::INPUT_REQUIRED)
    CloseUserPromptFile(true, true);
  else if (IoState_ == Mcalc_IOState::CALC_RESPONSE ||
           IoState_ == Mcalc_IOState::OUTPUT_READY)
    CloseGuiOutputFile(true, true);

  if (WarnOnInput_ && !SessionOption() &&
      IoState_ == Mcalc_IOState::INPUT_REQUIRED &&
      ((!retval && Reverse_) || (retval && !Reverse_)))
  {
    SetInputPromptWarning(true);
    retval = true;
  }

  #if CALCLIB_DEBUG8c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
bool CalculatorBase::GiveIoAccessCondition(CalculatorBase* CalcPtr_,
                                           int AccessFlag_, bool SesOptOverride_)
{
  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::GiveIoAccessCondition");
  #endif

  bool InBatch_ = false;
  bool NpBatch_ = false;
  bool PgBatch_ = false;
  bool GraphWaiting_ = false;
  bool BatchSigSent_ = false;
  bool ChkPlotShown_ = AccessFlag_ == PLOTDONE_CHKSHOWN;
  bool FileNotEmpty_ = false;
  bool HasOutput_ = false;
  bool OutReady_ = false;
  bool retval = false;

  CalcGraphPlotter* Plotter_ = NULL;
  SesOptOverride_ = SesOptOverride_ ||
                    (CalcPtr_ ? CalcPtr_->SessionOptionOverride():
                                SessionOptionOverride());

  GiveBatchDataStateVars(CalcPtr_ ? CalcPtr_:this, InBatch_, NpBatch_,
                         PgBatch_, GraphWaiting_, BatchSigSent_);

  // InBatch_ = WasInBatchDataInput() &&
  //            InAllGraphsFile() &&
  //            InputDataFilePauseOption();
  // NpBatch_ = InBatch_ && !GraphFilePause();
  // PgBatch_ = InBatch_ && GraphFilePause();
  // GraphWaiting_ = PgBatch_ && !QuitGraph();
  // BatchSigSent_ = BatchFileEndedSignalSent() ||
  //                 BatchFileEndedSignalAcked();
  //
  if (AccessFlag_ == IOACCESS)
  {
    // 1. IO access, _CalcPtr parameter
    FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);

    if (CalcPtr_)
    {
      OutReady_ = CalcPtr_->HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
      retval = ((CalcPtr_->EmptyResponseAllowed() ||
                 (!OutReady_ && HasOutput_ && FileNotEmpty_)) &&
                !CalcPtr_->HasErrors() && !CalcPtr_->QuitGraph() &&
                !CalcPtr_->ProcessAckSignalSent() &&
                !CalcPtr_->ProcessAckSignalPending() &&
                !CalcPtr_->ProcessAckSignalDone() &&
                (!CalcPtr_->GraphOperation() || !InBatch_ ||
                 !CalcPtr_->InAllGraphsFile()) &&
                (!CalcPtr_->SessionOption() || SesOptOverride_));
    }
    else
    {
      OutReady_ = HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
      retval = ((EmptyResponseAllowed() ||
                 (!OutReady_ && HasOutput_ && FileNotEmpty_)) &&
                !HasErrors() && !QuitGraph() &&
                !ProcessAckSignalSent() &&
                !ProcessAckSignalPending() &&
                !ProcessAckSignalDone() &&
                (!GraphOperation() || !InBatch_ ||
                 !InAllGraphsFile()) &&
                (!SessionOption() || SesOptOverride_));
    }

    #if CALCLIB_DEBUG12c
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("AccessFlag_ == IOACCESS\n");
        DbgPtr()->ShowInt(EmptyResponseAllowed(), "EmptyResponseAllowed()");
        DbgPtr()->ShowInt(OutReady_, "OutReady_");
        DbgPtr()->ShowInt(HasOutput_, "HasOutput_");
        DbgPtr()->ShowInt(FileNotEmpty_, "FileNotEmpty_");
        DbgPtr()->ShowInt(HasErrors(), "HasErrors()");
        DbgPtr()->ShowInt(QuitGraph(), "QuitGraph()");
        DbgPtr()->ShowInt(ProcessAckSignalSent(), "ProcessAckSignalSent()");
        DbgPtr()->ShowInt(ProcessAckSignalPending(), "ProcessAckSignalPending()");
        DbgPtr()->ShowInt(ProcessAckSignalDone(), "ProcessAckSignalDone()");
        DbgPtr()->ShowInt(GraphOperation(), "GraphOperation()");
        DbgPtr()->ShowInt(InBatch_, "InBatch_");
        DbgPtr()->ShowInt(InAllGraphsFile(), "InAllGraphsFile()");
        DbgPtr()->ShowInt(SessionOption(), "SessionOption()");
        DbgPtr()->ShowInt(SesOptOverride_, "SesOptOverride_");
        DbgPtr()->ShowInt(retval, "retval");
      }
    #endif
  }
  else if (AccessFlag_ == PLOTDONE_NOSHOWCHK ||
           AccessFlag_ == PLOTDONE_CHKSHOWN)
  {
    // 2. Plot done, GraphPlotShown_ parameter, _CalcPtr parameter
    if (CalcPtr_)
    {
      Plotter_ = CalcPtr_->GetGraphPlotter();
      retval = (CalcPtr_->GraphOperation() && Plotter_ &&
                (CalcPtr_->InAsyncMode() || SesOptOverride_) &&
                !QuitGraph() && Plotter_->GraphCompleted() &&
                !BatchSigSent_ && !CalcPtr_->ResponseCompleted() &&
                (!ChkPlotShown_ || !CalcPtr_->GraphPlotShown()));
    }
    else
    {
      Plotter_ = _Plotter;
      retval = (GraphOperation() && Plotter_ &&
                (InAsyncMode() || SesOptOverride_) &&
                !QuitGraph() && Plotter_->GraphCompleted() &&
                !BatchSigSent_ && !ResponseCompleted() &&
                (!ChkPlotShown_ || !GraphPlotShown()));
    }

    #if CALCLIB_DEBUG12c
      if (DbgPtr(false))
      {
        if (AccessFlag_ == PLOTDONE_NOSHOWCHK)
          DbgPtr()->ShowMessage("AccessFlag_ == PLOTDONE_NOSHOWCHK\n");
        else
          DbgPtr()->ShowMessage("AccessFlag_ == PLOTDONE_CHKSHOWN\n");

        DbgPtr()->ShowInt(GraphOperation(), "GraphOperation()");
        DbgPtr()->ShowInt(Plotter_!=NULL, "Plotter_!=NULL");
        DbgPtr()->ShowInt(InAsyncMode(), "InAsyncMode()");
        DbgPtr()->ShowInt(SesOptOverride_, "SesOptOverride_");
        DbgPtr()->ShowInt(QuitGraph(), "QuitGraph()");
        if (Plotter_)
          DbgPtr()->ShowInt(Plotter_->GraphCompleted(), "GraphCompleted()");
        else
          DbgPtr()->ShowInt(0, "GraphCompleted()");
        DbgPtr()->ShowInt(BatchSigSent_, "BatchSigSent_");
        DbgPtr()->ShowInt(ResponseCompleted(), "ResponseCompleted()");
        DbgPtr()->ShowInt(ChkPlotShown_, "ChkPlotShown_");
        DbgPtr()->ShowInt(GraphPlotShown(), "GraphPlotShown()");
        DbgPtr()->ShowInt(retval, "retval");
      }
    #endif
  }
  else if (AccessFlag_ == WAITFORPLOT)
  {
    // 3. Graph waiting, GraphWaiting_ parameter, _CalcPtr parameter
    if (CalcPtr_)
      retval = ((!CalcPtr_->GraphOperation() ||
                 (!BatchSigSent_ && (!NpBatch_ || GraphWaiting_)) ||
                 (InBatch_ && !CalcPtr_->InAllGraphsFile())) &&
                (!CalcPtr_->SessionOption() || SesOptOverride_));
    else
      retval = ((!GraphOperation() ||
                 (!BatchSigSent_ && (!NpBatch_ || GraphWaiting_)) ||
                 (InBatch_ && !InAllGraphsFile())) &&
                (!SessionOption() || SesOptOverride_));

    #if CALCLIB_DEBUG12c
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("AccessFlag_ == WAITFORPLOT\n");
        DbgPtr()->ShowInt(GraphOperation(), "GraphOperation()");
        DbgPtr()->ShowInt(BatchSigSent_, "BatchSigSent_");
        DbgPtr()->ShowInt(NpBatch_, "NpBatch_");
        DbgPtr()->ShowInt(GraphWaiting_, "graphWaiting_");
        DbgPtr()->ShowInt(InBatch_, "InBatch_");
        DbgPtr()->ShowInt(InAllGraphsFile(), "InAllGraphsFile()");
        DbgPtr()->ShowInt(SessionOption(), "SessionOption()");
        DbgPtr()->ShowInt(SesOptOverride_, "SesOptOverride_");
        DbgPtr()->ShowInt(retval, "retval");
      }
    #endif
  }
  else if (AccessFlag_ == INREQALLOWED)
  {
    // 4. INPUT_REQUIRED signal allowed
    if (CalcPtr_)
      retval = (!CalcPtr_->InAllGraphsFile() &&
                !CalcPtr_->NoPauseFileInput() && !CalcPtr_->SessionOption());
    else
      retval = (!InAllGraphsFile() &&
                !NoPauseFileInput() && !SessionOption());

    #if CALCLIB_DEBUG12c
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("AccessFlag_ == INREQALLOWED\n");
        DbgPtr()->ShowInt(InAllGraphsFile(), "InAllGraphsFile()");
        DbgPtr()->ShowInt(NoPauseFileInput(), "NoPauseFileInput()");
        DbgPtr()->ShowInt(SessionOption(), "SessionOption()");
        DbgPtr()->ShowInt(retval, "retval");
      }
    #endif
  }

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return retval;
}

/****************************************************************************/
int CalculatorBase::NotifyParent(bool ResponseSent_, bool Polling_)
{
  #if CALCLIB_DEBUG9
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("NotifyParent");
  #endif

  #if CALCLIB_TESTMOCKCLIENT
    int Sleep_ = 0;
    ResponseSent_ = ResponseSent_ && IsServerStates(_IoState);

    if (ResponseSent_ && !_NoPolling && Polling_ &&
        _PollServerMgr && _PollServerMgr->ResetWhenNotRequired(true)
                                        ->ClientReceiveRequired())
    {
      Sleep_ = _PollServerMgr->WaitingForServerResponse() ? 1:0;
      _PollServerMgr->SetStopTracking(false);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("_PollServerMgr->ReceiveKeepAlivePoll(mult_, true);\n"
                                "-Called From WaitForOutput\n");
      #endif
      _PollServerMgr->ResetReceivePoll(false);
      _PollServerMgr->ReceiveKeepAlivePoll(Sleep_, false);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif
      return 1;
    }
    else if (!ResponseSent_ && !_NoPolling && !Polling_ &&
             _PollServerMgr && _PollServerMgr->ResetWhenNotRequired(true)
                                             ->PollServerRequired(0, true))
    {
      Sleep_ = _PollServerMgr->WaitingForServerResponse() ? 1:0;
      _PollServerMgr->SetStopTracking(false);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("_PollServerMgr->PollServerIfAlive(mult_, true, true);\n"
                                "-Called From: WaitForOutput\n");
      #endif
      _PollServerMgr->ResetServerPolling(false);
      _PollServerMgr->PollServerIfAlive(Sleep_, false, true);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif
      return 1;
    }
  #endif

  #if CALCLIB_DEBUG9
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif
  return 0;
}

/****************************************************************************/
int CalculatorBase::MockClientAck(bool ResponseSent_)
{
  #if CALCLIB_DEBUG9
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("NotifyParent");
  #endif

  #if ((CALCLIB_TESTMOCKCLIENT)&(IMPLEMENT_KEEP_ALIVE))
  if (CalcPollingActive())
  {
    int Sleep_ = 0;

    if (!ResponseSent_ && !_NoPolling &&
        _PollServerMgr && _PollServerMgr->ResetWhenNotRequired(true)
                                        ->PollServerRequired(0, true))
    {
      Sleep_ = _PollServerMgr->WaitingForServerResponse() ? 1:0;
      _PollServerMgr->SetStopTracking(false);
      _PollServerMgr->ResetServerPolling(false);
      _PollServerMgr->PollServerIfAlive(Sleep_, false, true);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif
      return 1;
    }
  }
  #endif

  #if CALCLIB_DEBUG9
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif
  return 0;
}

/****************************************************************************/
int CalculatorBase::SimulatePolling()
{
  int LoopGuard_ = 20;
  int IoState_;

  bool PollingClient_ = false;
  bool PollError_ = false;
  bool PollAnswered_ = false;
  bool PollingAllowed_ = false;

  #if IMPLEMENT_KEEP_ALIVE
  if (CalcPollingActive())
  {
    if (_PollClientMgr)
    {
      PollingAllowed_ = _PollClientMgr->ClientPollingAllowed();
      _PollClientMgr->ResetPollCount();
      _PollClientMgr->ResetPollResults(PollingClient_, PollError_, PollAnswered_);
      _PollClientMgr->SetWaitUntilResponse(true)
                    ->SetAllowClientPolling(true)
                    ->SetSleepWaiting(true)
                    ->SetResetStatesOnDone(true)
                    ->SetBreakOnPollError(false)
                    ->SetStopTracking(false);
    }

    #if CALCLIB_DEBUG9
      if (DbgPtr(false))
        DbgPtr()->EnterLevel("SimulatePolling");
    #endif

    if (_PollClientMgr)
    for (LoopGuard_ = RETRY_READ_MAX;
         !_PollClientMgr->AtMaxPollAttempts() && LoopGuard_;
         LoopGuard_--)
    {
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("SimulatePolling: _PollClientMgr->PollClientIfAlive(1, true, false);\n");
      #endif
      SetNoPolling(false);
      _PollClientMgr->ResetWhenNotRequired(true)
                    ->PollClientIfAlive(1, true, false); // Initiate Polling

      #if CALCLIB_DEBUG10
        _PollClientMgr->SetStopTracking(false);
      #endif

      _PollClientMgr->GivePollResults(PollingClient_, PollError_, PollAnswered_);

      if (PollAnswered_ || PollError_)
      {
        _PollClientMgr->SetAllowClientPolling(PollingAllowed_);
        if (PollError_)
          _PollClientMgr->ResetClientPolling(true);

        break;
      }
      else
        _PollClientMgr->ResetClientPolling(true);
    }

    if (_PollClientMgr)
      _PollClientMgr->SetWaitUntilResponse(false);
  }
  #endif

  #if CALCLIB_DEBUG9
    if (DbgPtr(false))
    {
      DbgPtr()->LeaveLevel();
      DbgPtr()->ResetLevels();
    }
  #endif

  _PollClientMgr->SetAllowClientPolling(false);
  SetNoPolling(true);
  IoState_ = Bare_GetIoState(0);
  SetNoPolling(false);
  return IoState_;
}

/*****************************************************************************/
bool CalculatorBase::EmptyResponseAllowed()
{
  return _AllowEmptyResponse;
}

/*****************************************************************************/
CalculatorBase* CalculatorBase::AllowEmptyResponse(bool flag_)
{
  _AllowEmptyResponse = flag_;
  return this;
}

/****************************************************************************/
bool CalculatorBase::SessionOptionOverride() const
{
  return _SessionOptionOverride;
}

/****************************************************************************/
CalculatorBase* CalculatorBase::SetSessionOptionOverride(bool flag_)
{
  _SessionOptionOverride = flag_;
  return this;
}

/****************************************************************************/
int CalculatorBase::UsingMicroSecDelay(int* DelayLenp_, bool Override_)
{
  if ((_MicroSecDelay || Override_) && DelayLenp_)
  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    if (*DelayLenp_ >= 100)
      *DelayLenp_ /= 100;
  #else
    // microsec sleep
    if (*DelayLenp_ >= 100000)
      *DelayLenp_ /= 100000;
  #endif

  return _MicroSecDelay;
}

/****************************************************************************/
int CalculatorBase::SetCalcTimeoutState(int State_, const char* From_)
{
  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SetCalcTimeoutState");
  #endif

  #if CALCLIB_DEBUG12d
    DbgPtr()->ShowMessage("opening ");
    DbgPtr()->ShowMessage(PROG_IOSTATE_FILE);
    DbgPtr()->ShowMessage(" iostate file for writing 1st attempt, server side\n");
  #endif

  #if CALCLIB_DEBUG12d
    ChrString StateStr_;
  #endif

  if (!(InAsyncMode() || SessionOption() || _InputExists) || !GetElapsedTimeFilename())
  {
    _NoPolling = false;

    #if CALCLIB_DEBUG12d
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("Exiting on InAsyncMode fail\n");
        DbgPtr()->ShowInt(InAsyncMode(), "InAsyncMode()");
        DbgPtr()->ShowInt(SessionOption(), "SessionOption()");
        DbgPtr()->ShowInt(_InputExists, "_InputExists");
        DbgPtr()->LeaveLevel();
      }
    #endif
    return 0;
  }

  if (!elapsedtimefile || !filestatus[Mcalc_IOType::ElapsedTime])
  {
    filestatus[Mcalc_IOType::ElapsedTime] = openfile(&files[Mcalc_IOType::ElapsedTime],ELAPSEDTIME_FILE,"w",TRUE,FALSE);

    if (!filestatus[Mcalc_IOType::ElapsedTime])
    {
      #if CALCLIB_DEBUG12d
        printf("Error: opening %s for writing, server side\n", ELAPSEDTIME_FILE);
      #endif

      filestatus[Mcalc_IOType::ElapsedTime] = openfile(&files[Mcalc_IOType::ElapsedTime],ELAPSEDTIME_FILE,"w");
    }

    elapsedtimefile = files[Mcalc_IOType::ElapsedTime];
  }

  #if CALCLIB_DEBUG12d
    DbgPtr()->ShowMessage("opening ");
    DbgPtr()->ShowMessage(ELAPSEDTIME_FILE);
    DbgPtr()->ShowMessage(" for writing successful, server side\n");
  #endif

  #if ((CALCLIB_TESTASYNCMODE2c)|(CALCLIB_DEBUG13c))
    _Mockcio->ShowCalcTimeoutState(elapsedtimefile, From_ ? From_:"SetCalcTimeoutState",
                                   State_, _ElapsedTimer->ElapsedSecs());
  #endif

  if (State_ >= 0 && elapsedtimefile)
  {
    fprintf(elapsedtimefile, "%d", State_);

    if (State_ == Mcalc_ElapsedTime::SENT)
      fprintf(elapsedtimefile, "\n%lg", _ElapsedTimer->ElapsedSecs());
  }

  fclose(elapsedtimefile);
  elapsedtimefile = NULL;
  filestatus[Mcalc_IOType::ElapsedTime] = 0;

  if (State_ >= 0)
    _TimeoutState = State_;

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
    {
      StateStr_ = GiveTimeoutStateStr(_TimeoutState);
      DbgPtr()->ShowStr(StateStr_.c_str(), "_TimeoutState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return _TimeoutState;
}

/****************************************************************************/
void CalculatorBase::Bare_SetIoState(int State_, bool NoDup_, int Delay_)
{
  #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::Bare_SetIoState");
  #endif

  int mult_ = (Delay_ > 1) ? Delay_:1;
  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
    UsingMicroSecDelay(&DelayLen_);
    DelayLen_ *= mult_;
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
    UsingMicroSecDelay(&DelayLen_);
    DelayLen_ *= mult_;
  #endif

  #if IOSTATE_PRE_SET_DELAY
    if (Delay_)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif
    }
  #endif

  #if CALCLIB_DEBUG1
    printf("opening %s for writing 1st attempt, server side\n", PROG_IOSTATE_FILE);
  #elif CALCLIB_DEBUG8c
    DbgPtr()->ShowMessage("opening ");
    DbgPtr()->ShowMessage(PROG_IOSTATE_FILE);
    DbgPtr()->ShowMessage(" iostate file for writing 1st attempt, server side\n");
  #endif

  #if ((CALCLIB_DEBUG8b)|(CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
    ChrString StateStr_;
  #endif

  if (!SessionOptionOverride() &&
      (!InAsyncMode() ||
       !GetProgramIostateFilename() || SessionOption()))
  {
    _NoPolling = false;
    #if ((CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("Exiting on SessionOverride fail\n");
        DbgPtr()->ShowInt(SessionOption(), "SessionOption()");
        DbgPtr()->ShowInt(SessionOptionOverride(), "SessionOptionOverride()");
        DbgPtr()->LeaveLevel();
      }
    #endif
    return;
  }

  if (State_ == Mcalc_IOState::OUTPUT_READY &&
      IsOutputFileEmpty(Mcalc_IOState::OUTPUT_READY))
  {
    #if ((CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
      if (DbgPtr(false))
      {
        DbgPtr()->ShowMessage("Exiting on OutputFileEmpty fail\n");
        DbgPtr()->LeaveLevel();
      }
    #endif
    return;
  }

  bool ArgMatchFileData_ = false;
  bool WriteDone_ = false;

  if (NoDup_)
  {
    UseMicroSecDelay(true);
    int IoState_ = Bare_GetIoState(Delay_);
    ArgMatchFileData_ = IoState_ == State_;

    if (ArgMatchFileData_ && _IoState == State_)
    {
      _NoPolling = false;
      #if ((CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif
      return;
    }
  }

  if (!iostatefile || !filestatus[Mcalc_IOType::IoState])
  {
    filestatus[Mcalc_IOType::IoState] = openfile(&files[Mcalc_IOType::IoState],PROG_IOSTATE_FILE,"w",TRUE,FALSE);

    if (!filestatus[Mcalc_IOType::IoState])
    {
      #if CALCLIB_DEBUG1
        printf("Error: opening %s for writing, server side\n", PROG_IOSTATE_FILE);
      #endif

      filestatus[Mcalc_IOType::IoState] = openfile(&files[Mcalc_IOType::IoState],PROG_IOSTATE_FILE,"w");
    }

    iostatefile = files[Mcalc_IOType::IoState];
  }

  #if (CALCLIB_DEBUG1 | CALCLIB_DEBUG3)
    printf("opening %s for writing successful, server side\n", PROG_IOSTATE_FILE);
  #elif CALCLIB_DEBUG8c
    DbgPtr()->ShowMessage("opening ");
    DbgPtr()->ShowMessage(PROG_IOSTATE_FILE);
    DbgPtr()->ShowMessage(" for writing successful, server side\n");
  #endif

  if (!ArgMatchFileData_)
  {
    if (State_ && iostatefile)
    {
      fprintf(iostatefile, "%d", State_);
      WriteDone_ = true;
    }

    if (WriteToFileBatchLevel() && WriteDone_ &&
        (State_ == Mcalc_IOState::RESENDLASTSIG ||
         State_ == Mcalc_IOState::BATCHFILE_ENDED ||
         State_ == Mcalc_IOState::BATCHFILE_ENDED_ACK))
    {
      fprintf(iostatefile, "\n%d", _BatchExecLevel);
      SetWriteToFileBatchLevel(false);
    }

    fclose(iostatefile);
    iostatefile = NULL;
    filestatus[Mcalc_IOType::IoState] = 0;
  }

  if (State_)
  {
    _IoState = State_;

    if (WriteDone_ && State_ == Mcalc_IOState::CALC_RESPONSE)
      _CalcResponseSent = true;
  }

  bool ResponseReceived_ = IsClientStates(State_);

  #if CALCLIB_DEBUG9p
    if (_PollClientMgr)
    {
      _PollClientMgr->ResetPollCount();
      _PollClientMgr->SetWaitUntilResponse(true)
                    ->SetAllowClientPolling(true)
                    ->SetSleepWaiting(true)
                    ->SetResetStatesOnDone(true)
                    ->SetBreakOnPollError(false)
                    ->SetStopTracking(false);
    }

    if (!ResponseReceived_ && !_NoPolling && _PollClientMgr &&
        _PollClientMgr->ResetWhenNotRequired(true)
                      ->PollClientRequired(0, false))
      SimulatePolling();
  #else
    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    if (CalcPollingActive())
    {
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
        {
          _PollClientMgr->SetStopTracking(false);
          DbgPtr()->ShowInt(ResponseReceived_, "ResponseReceived_");
          DbgPtr()->ShowInt(_NoPolling, "_NoPolling");
        }
      #endif

      if (!ResponseReceived_ && !_NoPolling && _PollClientMgr &&
          _PollClientMgr->ResetWhenNotRequired(true)
                        ->PollClientRequired(0, true))
      {
        mult_ = (!Delay_ && _PollClientMgr->WaitingForClientResponse()) ? 1:0;
        _PollClientMgr->SetStopTracking(false);
        _PollClientMgr->ResetClientPolling(false);
        _PollClientMgr->PollClientIfAlive(mult_, false, true); // Response Only
      }
    }
    #endif
  #endif

  #if CALCLIB_DEBUG8b
    if (_IoState == Mcalc_IOState::CALC_ERROR ||
        _IoState == Mcalc_IOState::ERROR_FETCH)
    {
      if (DbgPtr(false))
        DbgPtr()->EnterLevel("CalculatorBase::Bare_SetIoState");

      if (DbgPtr(false))
      {
        StateStr_ = GiveIoStateStr(_IoState);
        DbgPtr()->ShowStr(StateStr_.c_str(), "_IoState");
        DbgPtr()->ShowInt(NoDup_, "NoDup_");
        DbgPtr()->ShowInt(Delay_, "Delay_");
        DbgPtr()->LeaveLevel();
      }
    }
  #endif

  if (_IoState != Mcalc_IOState::CALC_HALT &&
      _IoState != Mcalc_IOState::BREAK_PROGRAM &&
      _IoState != Mcalc_IOState::CALC_ERROR &&
      _IoState != Mcalc_IOState::ERROR_FETCH &&
      _IoState != Mcalc_IOState::CALC_RESPONSE)
    CalculatorBase::ShouldBreakFromProgram(this);

  #if IOSTATE_POST_SET_DELAY
    if (Delay_)
    {
      #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
        Sleep(DelayLen_);
      #else
        ::usleep(DelayLen_);
      #endif
    }
  #endif

  #if ((CALCLIB_DEBUG9)|(CALCLIB_DEBUG8c))
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(_IoState);
      DbgPtr()->ShowStr(StateStr_.c_str(), "_IoState");
      DbgPtr()->ShowInt(NoDup_, "NoDup_");
      DbgPtr()->ShowInt(Delay_, "Delay_");
      DbgPtr()->LeaveLevel();
    }
  #endif
}

/****************************************************************************/
void CalculatorBase::SetIoState(int State_, bool NoDup_,
                                int Delay_, bool WaitForAck_)
{
  #if CALCLIB_DEBUG8c
    DbgPtr()->EnterLevel("SetIoState");
    ChrString StateStr_ = GiveIoStateStr(State_);
    DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
    DbgPtr()->ShowInt(NoDup_, "NoDup_");
    DbgPtr()->ShowInt(Delay_, "Delay_");
    DbgPtr()->ShowInt(WaitForAck_, "WaitForAck_");
  #endif

  bool ErrStates_ = State_ == Mcalc_IOState::CALC_ERROR ||
                    State_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = State_ == Mcalc_IOState::CALC_HALT ||
                     State_ == Mcalc_IOState::IDLE_STATE;

  if (!SessionOptionOverride() && !CritStates_ &&
      (!InAsyncMode() ||
       !GetProgramIostateFilename() || SessionOption()))
    return;

  int CurState_ = 0;

  bool BreakAll_ = false;
  bool DoHalt_ = false;
  bool FetchLimitReached_ = false;

  if (!_IoStatePtr->ResetAtEndOfProcess(State_))  // step 2
    _IoStatePtr->SetIoStateAck(State_);  // step 3

  if (WaitForAck_ && _IoStatePtr->IsIoStateUnAck(State_))  // step 4
    CurState_ = _IoStatePtr->WaitForIoStateAck(&BreakAll_, &DoHalt_, &FetchLimitReached_);

  if (BreakAll_ || DoHalt_)
    ReceiveBreakOrQuit(CurState_);
  else
  {
    _NoPolling = false;
    Bare_SetIoState(State_, NoDup_, Delay_);
    _IoStatePtr->UpdateIoState(State_);  // step 1
  }

  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);

  #if CALCLIB_DEBUG8c
    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
bool CalculatorBase::InIoStatePendingMode(bool InclAllCases_) const
{
  bool InAsync_ = InAsyncMode() || SessionOption();
  bool Case1_ = InAsync_ && InProgramMode(false);
  bool Case2_ = InAsync_ && (ExecInputFileData() && !AckPostExecInputFileData() &&
                             InputDataFileExecLock() == EXECFILE_LOCKED);
  bool InMode_ = (Case1_ || (InclAllCases_ && Case2_));

  return InMode_;
}

/****************************************************************************/
bool CalculatorBase::SetIoStateInMode(int State_, bool NoDup_, int Delay_)
{
  if ((!InAsyncMode() && !SessionOption()) || !PROG_IOSTATE_FILE)
    return false;

  #if ((CALCLIB_DEBUG8a)|(CALCLIB_DEBUG8b))
    ChrString StateStr_;

    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SetIoStateInMode");
  #endif

  int set_ = true;
  bool IoAccess_ = false;
  bool OutReady_ = false;
  bool NotOutput_ = false;

  if (State_ == Mcalc_IOState::CALC_ERROR)
  {
    if (InIoStatePendingMode(true) && !SessionOption())
    {
      #if CALCLIB_DEBUG8b
        StateStr_ = GiveIoStateStr(State_);
        DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
        DbgPtr()->ShowInt(_ErrorStatePending, "_ErrorStatePending");
      #endif

      _ErrorStatePending = TRUE;
      set_ = false;
    }
    else
    {
      #if CALCLIB_DEBUG8b
        StateStr_ = GiveIoStateStr(State_);
        DbgPtr()->ShowStr(StateStr_.c_str(),
                          "if (InIoStatePendingMode(true)) else...");
        DbgPtr()->ShowInt(_ErrorStatePending, "_ErrorStatePending");
      #endif

      SetIoState(State_, NoDup_, Delay_);
    }
  }
  else
  {
    if (State_ == Mcalc_IOState::CALC_RESPONSE && !SessionOption())
      IoAccess_ = GiveIoAccessCondition(NULL, IOACCESS);
    else if (State_ == Mcalc_IOState::OUTPUT_READY &&
             IsOutputFileNotEmpty(State_))
      IoAccess_ = GiveIoAccessCondition(NULL, WAITFORPLOT);
    else if (!SessionOption() &&
             State_ == Mcalc_IOState::INPUT_REQUIRED &&
             IsOutputFileNotEmpty(State_, true))
      IoAccess_ = GiveIoAccessCondition(NULL, INREQALLOWED);
    else if (!SessionOption())
    {
      IoAccess_ = true;
      NotOutput_ = true;
    }

    if (IoAccess_)
    {
      if (!NotOutput_)
        TieOutputToSignal(State_);

      SetIoState(State_, NoDup_, Delay_);

      if (State_ == Mcalc_IOState::INPUT_REQUIRED ||
          State_ == Mcalc_IOState::OUTPUT_READY)
      {
        OutReady_ = State_ == Mcalc_IOState::OUTPUT_READY;
        UseMicroSecDelay(true);
        State_ = GetIoState(1);

        // clear output file after display
        if ((OutReady_ && State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
            (!OutReady_ && State_ == Mcalc_IOState::INPUT_RECEIVED))
          ResetOutputFiles(!OutReady_);
      }
    }
  }

  #if ((CALCLIB_DEBUG8a)|(CALCLIB_DEBUG8b))
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(State_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      DbgPtr()->ShowInt(NoDup_, "NoDup_");
      DbgPtr()->ShowInt(Delay_, "Delay_");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return set_;
}

/****************************************************************************/
bool CalculatorBase::ClearPendingErrors(bool IgnoreMode_)
{
  if (IgnoreMode_ || InIoStatePendingMode(true))
  {
    _ErrorStatePending = FALSE;
    return true;
  }

  return false;
}

/****************************************************************************/
void CalculatorBase::ReceiveBreakOrQuit(int State_)
{
  int IoState_ = State_ ? State_:GetIoState(0);

  bool OutFetched_ = false;
  bool BreakAll_ = false;
  bool DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true))
    BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  if (BreakAll_)
    SetBreakFromProgram(TRUE);

  if (DoHalt_)
    SetShouldQuit(TRUE);

  if (State_ == Mcalc_IOState::INPUT_RECEIVED ||
      State_ == Mcalc_IOState::OUTPUT_FETCHED)
  {
    OutFetched_ = State_ == Mcalc_IOState::OUTPUT_FETCHED;
    UseMicroSecDelay(true);
    State_ = GetIoState(1);

    // clear output file after display
    if ((OutFetched_ && State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
        (!OutFetched_ && State_ == Mcalc_IOState::INPUT_RECEIVED))
      ResetOutputFiles(!OutFetched_);
  }
}

/****************************************************************************/
void CalculatorBase::SendIoState(int State_, bool NoDup_, int Delay_)
{
  if ((!InAsyncMode() && !SessionOption()) || !PROG_IOSTATE_FILE)
    return;

  #if CALCLIB_DEBUG8a
    ChrString StateStr_;

    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendIoState");
  #endif

  bool BreakAll_ = false;
  bool DoHalt_ = false;
  bool WaitSig_ = false;
  bool IoAccess_ = false;
  bool OutReady_ = false;
  bool FileNotEmpty_ = false;
  bool NotOutput_ = false;
  bool InBatch_ = InBatchFile(true);
  bool BatchSigSent_ = BatchFileEndedSignalSent() ||
                       BatchFileEndedSignalAcked();

  // Make sure non-graph signals are sent either before or after
  // graph signals. For the GRAPH_WAIT signal then non-graph signals
  // are sent before the GRAPH_WAIT signal. For the GRAPH_OUTPUT signal
  // then non-graph signals are sent after the GRAPH_OUTPUT signal.
  //
  int ComboState1_ = (Mcalc_IOState::GRAPH_OUTPUT |
                      Mcalc_IOState::OUTPUT_READY);
  int ComboState2_ = ((Mcalc_IOState::GRAPH_OUTPUT |
                       Mcalc_IOState::CALC_RESPONSE)) &&
                     !SessionOption();
  int ComboState3_ = ((Mcalc_IOState::GRAPH_OUTPUT |
                       Mcalc_IOState::INPUT_REQUIRED)) &&
                     !SessionOption();

  int ComboState1w_ = ((Mcalc_IOState::GRAPH_WAIT |
                        Mcalc_IOState::OUTPUT_READY)) &&
                      !SessionOption();
  int ComboState2w_ = ((Mcalc_IOState::GRAPH_WAIT |
                        Mcalc_IOState::CALC_RESPONSE)) &&
                      !SessionOption();
  int ComboState3w_ = ((Mcalc_IOState::GRAPH_WAIT |
                        Mcalc_IOState::INPUT_REQUIRED)) &&
                      !SessionOption();

  if (State_ == Mcalc_IOState::CALC_ERROR && !SessionOption())
    SetIoStateInMode(State_, NoDup_, Delay_);
  else if ((State_ == ComboState1_) || (State_ == ComboState1w_))
  {
    Delay_ = 1;
    WaitSig_ = (State_ == ComboState1w_);

    // Make sure non-graph signals are sent either before or after
    // graph signals. For the GRAPH_WAIT signal then non-graph signals
    // are sent before the GRAPH_WAIT signal. For the GRAPH_OUTPUT signal
    // then non-graph signals are sent after the GRAPH_OUTPUT signal.
    //
    if (WaitSig_)
    {
      FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::OUTPUT_READY);
      if (FileNotEmpty_)
        State_ = SendOutputReadySignal(Delay_, &BreakAll_, &DoHalt_);

      if (FileNotEmpty_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                    (InAsyncMode() || SessionOptionOverride());

        if (IoAccess_)
        {
          State_ = SendGraphWaitSignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
    else
    {
      IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                  (InAsyncMode() || SessionOptionOverride()) &&
                  (!InBatch_ ||
                   (!BatchSigSent_ && InAllGraphsFile() &&
                    WasInBatchDataInput() && !GraphOutputWasSent()));

      if (IoAccess_)
        State_ = SendGraphOutputSignal(Delay_, InBatch_, &BreakAll_, &DoHalt_);

      if (IoAccess_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::OUTPUT_READY);

        if (FileNotEmpty_)
        {
          State_ = SendOutputReadySignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
  }
  else if ((State_ == ComboState2_) || (State_ == ComboState2w_))
  {
    Delay_ = 1;
    WaitSig_ = (State_ == ComboState2w_);

    if (WaitSig_)
    {
      FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
      if (FileNotEmpty_)
        State_ = SendCalcResponseSignal(Delay_, &BreakAll_, &DoHalt_);

      if (FileNotEmpty_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                    (InAsyncMode() || SessionOptionOverride());

        if (IoAccess_)
        {
          State_ = SendGraphWaitSignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
    else
    {
      IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                  (InAsyncMode() || SessionOptionOverride()) &&
                  (!InBatch_ ||
                   (!BatchSigSent_ && InAllGraphsFile() &&
                    WasInBatchDataInput() && !GraphOutputWasSent()));

      if (IoAccess_)
        State_ = SendGraphOutputSignal(Delay_, InBatch_, &BreakAll_, &DoHalt_);

      if (IoAccess_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);

        if (FileNotEmpty_)
        {
          State_ = SendCalcResponseSignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
  }
  else if ((State_ == ComboState3_) || (State_ == ComboState3w_))
  {
    Delay_ = 1;
    WaitSig_ = (State_ == ComboState3w_);

    if (WaitSig_)
    {
      FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::INPUT_REQUIRED, true);
      if (FileNotEmpty_)
        State_ = SendInputRequiredSignal(Delay_, &BreakAll_, &DoHalt_);

      if (FileNotEmpty_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                    (InAsyncMode() || SessionOptionOverride());

        if (IoAccess_)
        {
          State_ = SendGraphWaitSignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
    else
    {
      IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                  (InAsyncMode() || SessionOptionOverride()) &&
                  (!InBatch_ ||
                   (!BatchSigSent_ && InAllGraphsFile() &&
                    WasInBatchDataInput() && !GraphOutputWasSent()));

      if (IoAccess_)
        State_ = SendGraphOutputSignal(Delay_, InBatch_, &BreakAll_, &DoHalt_);

      if (IoAccess_ && (BreakAll_ || DoHalt_))
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
      else
      {
        FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::INPUT_REQUIRED, true);

        if (FileNotEmpty_)
        {
          State_ = SendInputRequiredSignal(Delay_, &BreakAll_, &DoHalt_);

          if (BreakAll_ || DoHalt_)
            ReceiveBreakOrQuit(State_ ? State_:_IoState);
        }
      }
    }
  }
  else if (State_ == Mcalc_IOState::GRAPH_WAIT)
  {
    IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                (InAsyncMode() || SessionOptionOverride());

    if (IoAccess_)
    {
      State_ = SendGraphWaitSignal(Delay_, &BreakAll_, &DoHalt_);

      if (BreakAll_ || DoHalt_)
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
    }
  }
  else if (State_ == Mcalc_IOState::GRAPH_OUTPUT)
  {
    IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                (InAsyncMode() || SessionOptionOverride()) &&
                (!InBatch_ ||
                 (!BatchSigSent_ && InAllGraphsFile() &&
                  WasInBatchDataInput() && !GraphOutputWasSent()));

    if (IoAccess_)
    {
      State_ = SendGraphOutputSignal(Delay_, InBatch_, &BreakAll_, &DoHalt_);

      if (BreakAll_ || DoHalt_)
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
    }
  }
  else if (State_ == Mcalc_IOState::OUTPUT_READY)
  {
    FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::OUTPUT_READY);

    if (FileNotEmpty_)
    {
      State_ = SendOutputReadySignal(Delay_, &BreakAll_, &DoHalt_);

      if (BreakAll_ || DoHalt_)
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
    }
  }
  else if (State_ == Mcalc_IOState::CALC_RESPONSE && !SessionOption())
  {
    FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);

    if (FileNotEmpty_)
    {
      State_ = SendCalcResponseSignal(Delay_, &BreakAll_, &DoHalt_);

      if (BreakAll_ || DoHalt_)
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
    }
  }
  else if (State_ == Mcalc_IOState::INPUT_REQUIRED && !SessionOption())
  {
    FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::INPUT_REQUIRED, true);

    if (FileNotEmpty_)
    {
      State_ = SendInputRequiredSignal(Delay_, &BreakAll_, &DoHalt_);

      if (BreakAll_ || DoHalt_)
        ReceiveBreakOrQuit(State_ ? State_:_IoState);
    }
  }
  else
  {
    if (State_ == Mcalc_IOState::CALC_RESPONSE && !SessionOption())
      IoAccess_ = GiveIoAccessCondition(NULL, IOACCESS);
    else if (State_ == Mcalc_IOState::OUTPUT_READY &&
             IsOutputFileNotEmpty(State_))
      IoAccess_ = GiveIoAccessCondition(NULL, WAITFORPLOT);
    else if (!SessionOption() &&
             State_ == Mcalc_IOState::INPUT_REQUIRED &&
             IsOutputFileNotEmpty(State_, true))
      IoAccess_ = GiveIoAccessCondition(NULL, INREQALLOWED);
    else if (!SessionOption())
    {
      IoAccess_ = true;
      NotOutput_ = true;
    }

    if (IoAccess_)
    {
      if (!NotOutput_)
        TieOutputToSignal(State_);

      SetIoState(State_, NoDup_, Delay_);

      if (State_ == Mcalc_IOState::INPUT_REQUIRED ||
          State_ == Mcalc_IOState::OUTPUT_READY)
      {
        OutReady_ = State_ == Mcalc_IOState::OUTPUT_READY;
        UseMicroSecDelay(true);
        State_ = GetIoState(1);

        // clear output file after display
        if ((OutReady_ && State_ == Mcalc_IOState::OUTPUT_FETCHED) ||
            (!OutReady_ && State_ == Mcalc_IOState::INPUT_RECEIVED))
          ResetOutputFiles(!OutReady_);
      }
    }
    else
    {
      if (State_ == Mcalc_IOState::GRAPH_WAIT)
        IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                    (InAsyncMode() || SessionOptionOverride());
      else if (State_ == Mcalc_IOState::GRAPH_OUTPUT)
        IoAccess_ = GraphOperation() && GetGraphPlotter() &&
                    (InAsyncMode() || SessionOptionOverride()) &&
                    (!InBatch_ ||
                     (!BatchSigSent_ && InAllGraphsFile() &&
                      WasInBatchDataInput() && !GraphOutputWasSent()));

      if (IoAccess_)
        SetIoState(State_, NoDup_, Delay_);
    }
  }

  #if CALCLIB_DEBUG8a
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(State_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "State_");
      DbgPtr()->ShowInt(NoDup_, "NoDup_");
      DbgPtr()->ShowInt(Delay_, "Delay_");
      DbgPtr()->LeaveLevel();
    }
  #endif
}

/****************************************************************************/
bool CalculatorBase::ErrorStatePending()
{
  return _ErrorStatePending;
}

/*****************************************************************************/
bool CalculatorBase::IsMatchingStates(bool InBatchFile_, int PrevState_, int CurrState_)
{
  // IDLE_STATE          --> PROCESS
  // CALC_RESPONSE       --> PROCESS
  // INPUT_RECEIVED      --> PROCESS
  // OUTPUT_FETCHED      --> PROCESS
  // PROCESS_DONE_ACK    --> PROCESS
  // CALC_ERROR          --> PROCESS
  // ERROR_FETCH         --> PROCESS
  // BREAK_PROGRAM       --> PROCESS
  // BATCHFILE_ENDED_ACK --> PROCESS
  // PROCESS_DONE        --> PROCESS_DONE_ACK

  // Input Data Batch File Mode:
  // ---------------------------
  // If calculator is executing a batch file or program,
  // the following special cases apply:
  //
  //   INPUT_RECEIVED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   OUTPUT_FETCHED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BREAK_PROGRAM       --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BATCHFILE_ENDED_ACK --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //
  //   CALC_RESPONSE       --> INPUT_RECEIVED
  //   CALC_ERROR          --> INPUT_RECEIVED
  //   ERROR_FETCH         --> INPUT_RECEIVED
  //
  //   PROCESS_DONE        --> PROCESS_DONE_ACK
  //   PROCESS_DONE_ACK    --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE

  // INPUT_REQUIRED      --> INPUT_RECEIVED (Empty Response Optional)
  // GRAPH_WAIT          --> INPUT_RECEIVED (Empty Response Optional)

  // OUTPUT_READY        --> OUTPUT_FETCHED --> PROCESS
  // GRAPH_OUTPUT        --> OUTPUT_FETCHED --> PROCESS

  // PROCESS_DONE        --> PROCESS_DONE_ACK --> PROCESS
  // SPAWN_NEW_MCALC     --> MCALC_SPAWNED --> PROCESS

  bool ErrorFlip_ = (PrevState_ == Mcalc_IOState::CALC_ERROR &&
                     CurrState_ == Mcalc_IOState::ERROR_FETCH) ||
                    (CurrState_ == Mcalc_IOState::CALC_ERROR &&
                     PrevState_ == Mcalc_IOState::ERROR_FETCH);

  bool CalcResponseSignals_ = CurrState_ == Mcalc_IOState::INPUT_REQUIRED ||
                              CurrState_ == Mcalc_IOState::OUTPUT_READY ||
                              CurrState_ == Mcalc_IOState::CALC_RESPONSE ||
                              CurrState_ == Mcalc_IOState::PROCESS_DONE;

  bool InBatchCond_ =
        (ErrorFlip_ ||
         (InBatchFile_ &&
          (((PrevState_ == Mcalc_IOState::INPUT_RECEIVED ||
             PrevState_ == Mcalc_IOState::OUTPUT_FETCHED) &&
            CalcResponseSignals_) ||

           ((PrevState_ == Mcalc_IOState::BREAK_PROGRAM ||
             PrevState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK) &&
            (CalcResponseSignals_ ||
             CurrState_ == Mcalc_IOState::PROCESS)) ||

           (((PrevState_ == Mcalc_IOState::INPUT_REQUIRED ||
              PrevState_ == Mcalc_IOState::GRAPH_WAIT) ||
             (PrevState_ == Mcalc_IOState::CALC_RESPONSE ||
              PrevState_ == Mcalc_IOState::CALC_ERROR ||
              PrevState_ == Mcalc_IOState::ERROR_FETCH)) &&
            CurrState_ == Mcalc_IOState::INPUT_RECEIVED) ||

           (PrevState_ == Mcalc_IOState::GRAPH_WAIT &&
            CurrState_ == Mcalc_IOState::INPUT_RECEIVED) ||
           (PrevState_ == Mcalc_IOState::GRAPH_WAIT &&
            CurrState_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
           (PrevState_ == Mcalc_IOState::GRAPH_PROGRESS &&
            CurrState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||

           (PrevState_ == Mcalc_IOState::PROGRESS_READY &&
            CurrState_ == Mcalc_IOState::INFILE_PROGRESS_ACK) ||

           (PrevState_ == Mcalc_IOState::PROCESS_DONE &&
            CurrState_ == Mcalc_IOState::PROCESS_DONE_ACK) ||

           (PrevState_ == Mcalc_IOState::PROCESS_DONE_ACK &&
            CurrState_ == Mcalc_IOState::PROCESS_DONE) ||

           ((PrevState_ == Mcalc_IOState::OUTPUT_READY ||
             PrevState_ == Mcalc_IOState::GRAPH_OUTPUT) &&
            (CurrState_ == Mcalc_IOState::OUTPUT_FETCHED ||
             CurrState_ == Mcalc_IOState::PROCESS)) ||

           (PrevState_ == Mcalc_IOState::PROCESS &&
            CurrState_ == Mcalc_IOState::PROCESS_DONE) ||

           (PrevState_ == Mcalc_IOState::BATCHFILE_ENDED &&
            (CurrState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
             CurrState_ == Mcalc_IOState::PROCESS)) ||

           (PrevState_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
            (CurrState_ == Mcalc_IOState::MCALC_SPAWNED ||
             CurrState_ == Mcalc_IOState::PROCESS)) ||

           CurrState_ == Mcalc_IOState::BREAK_PROGRAM)));

  bool WaitForServerSend_ = WaitingForServerSend(CurrState_);
  bool NoBatchCond_ =
           (ErrorFlip_ ||
            (!InBatchFile_ && WaitForServerSend_ &&
            ((PrevState_ == Mcalc_IOState::OUTPUT_READY &&
              (CurrState_ == Mcalc_IOState::OUTPUT_FETCHED ||
               CurrState_ == Mcalc_IOState::PROCESS)) ||

             (PrevState_ == Mcalc_IOState::GRAPH_OUTPUT &&
              (CurrState_ == Mcalc_IOState::OUTPUT_FETCHED ||
               CurrState_ == Mcalc_IOState::PROCESS)) ||

             (PrevState_ == Mcalc_IOState::INPUT_REQUIRED &&
              CurrState_ == Mcalc_IOState::INPUT_RECEIVED) ||

             (PrevState_ == Mcalc_IOState::GRAPH_WAIT &&
              CurrState_ == Mcalc_IOState::INPUT_RECEIVED) ||
             (PrevState_ == Mcalc_IOState::GRAPH_WAIT &&
              CurrState_ == Mcalc_IOState::GRAPH_WAIT_ACK) ||
             (PrevState_ == Mcalc_IOState::GRAPH_PROGRESS &&
              CurrState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK) ||

             (PrevState_ == Mcalc_IOState::PROGRESS_READY &&
              CurrState_ == Mcalc_IOState::INFILE_PROGRESS_ACK) ||

             (PrevState_ == Mcalc_IOState::PROCESS_DONE &&
              CurrState_ == Mcalc_IOState::PROCESS_DONE_ACK) ||

             (PrevState_ == Mcalc_IOState::PROCESS_DONE_ACK &&
              CurrState_ == Mcalc_IOState::PROCESS_DONE) ||

             (PrevState_ == Mcalc_IOState::PROCESS &&
              CurrState_ == Mcalc_IOState::PROCESS_DONE) ||

             (PrevState_ == Mcalc_IOState::BATCHFILE_ENDED &&
              (CurrState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
               CurrState_ == Mcalc_IOState::PROCESS)) ||

             (PrevState_ == Mcalc_IOState::SPAWN_NEW_MCALC &&
              (CurrState_ == Mcalc_IOState::MCALC_SPAWNED ||
               CurrState_ == Mcalc_IOState::PROCESS)))));

  return (InBatchCond_ || NoBatchCond_);
}

/****************************************************************************/
bool CalculatorBase::IsClientStates(int State_)
{
  return
  (
    State_ == Mcalc_IOState::CALC_HALT ||
    State_ == Mcalc_IOState::PROCESS ||
    State_ == Mcalc_IOState::OUTPUT_FETCHED ||
    State_ == Mcalc_IOState::PROCESS_DONE_ACK ||
    State_ == Mcalc_IOState::INPUT_RECEIVED ||
    State_ == Mcalc_IOState::BREAK_PROGRAM ||
    State_ == Mcalc_IOState::INFILE_PROGRESS_ACK ||
    State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK ||
    State_ == Mcalc_IOState::GRAPH_WAIT_ACK ||
    State_ == Mcalc_IOState::MCALC_SPAWNED ||
    State_ == Mcalc_IOState::BATCHFILE_ENDED_ACK
  );
}

/****************************************************************************/
bool CalculatorBase::IsServerStates(int State_)
{
  return
  (
    State_ == Mcalc_IOState::OUTPUT_READY ||
    State_ == Mcalc_IOState::CALC_RESPONSE ||
    State_ == Mcalc_IOState::INPUT_REQUIRED ||
    State_ == Mcalc_IOState::IDLE_STATE ||
    State_ == Mcalc_IOState::GRAPH_OUTPUT ||
    State_ == Mcalc_IOState::GRAPH_WAIT ||
    State_ == Mcalc_IOState::CALC_ERROR ||
    State_ == Mcalc_IOState::PROGRESS_READY ||
    State_ == Mcalc_IOState::ERROR_FETCH ||
    State_ == Mcalc_IOState::GRAPH_PROGRESS ||
    State_ == Mcalc_IOState::SPAWN_NEW_MCALC ||
    State_ == Mcalc_IOState::BATCHFILE_ENDED ||
    State_ == Mcalc_IOState::PROCESS_DONE
  );
}

/****************************************************************************/
bool CalculatorBase::WaitingForServerSend(int State_)
{
  return
  (
    State_ == Mcalc_IOState::PROCESS             ||
    State_ == Mcalc_IOState::INPUT_RECEIVED      ||
    State_ == Mcalc_IOState::OUTPUT_FETCHED      ||
    State_ == Mcalc_IOState::PROCESS_DONE_ACK    ||
    State_ == Mcalc_IOState::GRAPH_WAIT_ACK      ||
    State_ == Mcalc_IOState::GRAPH_PROGRESS_ACK  ||
    State_ == Mcalc_IOState::INFILE_PROGRESS_ACK ||
    State_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
    State_ == Mcalc_IOState::MCALC_SPAWNED
  );
}

/****************************************************************************/
int CalculatorBase::GetCalcTimeoutState(int Sleep_, const char* From_)
{
  if (!InAsyncMode() && !SessionOption())
    return Mcalc_IOState::IDLE_STATE;

  #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::GetCalcTimeoutState");
  #endif

  int mult_ = 0;
  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
    UsingMicroSecDelay(&DelayLen_);
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
    UsingMicroSecDelay(&DelayLen_);
  #endif

  if (Sleep_)
  {
    mult_ = (Sleep_ > 1) ? Sleep_:1;

    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(mult_ * DelayLen_);
    #else
      ::usleep(mult_ * DelayLen_);
    #endif

    #if CALCLIB_DEBUG1
      printf("Error: opening %s for reading, server side\n", ELAPSEDTIME_FILE);
    #endif
  }
  else
  {
    #if CALCLIB_DEBUG1
      printf("opening %s for reading 1st attempt, server side\n", ELAPSEDTIME_FILE);
    #endif
  }

  int Eof_;
  char buffer[20];
  ChrString StateStr_;

  int State_ = Mcalc_ElapsedTime::RESET;
  filestatus[Mcalc_IOType::ElapsedTime] = 0;
  iostatefile = NULL;

  files[Mcalc_IOType::ElapsedTime] = FileOpen(ELAPSEDTIME_FILE, "r");
  int ErrCond_ = files[Mcalc_IOType::ElapsedTime] == NULL ||
                 (Eof_ = feof(files[Mcalc_IOType::ElapsedTime])) ||
                 ferror(files[Mcalc_IOType::ElapsedTime]);

  if (ErrCond_ || !FileSize(files[Mcalc_IOType::ElapsedTime]))
  {
    if (ErrCond_)
    {
      if (files[Mcalc_IOType::ElapsedTime])
      {
        clearerr(files[Mcalc_IOType::ElapsedTime]);
        if (Eof_)
          fclose(files[Mcalc_IOType::ElapsedTime]);

        files[Mcalc_IOType::ElapsedTime] = NULL;
      }
    }
    else if (files[Mcalc_IOType::ElapsedTime])
      fclose(files[Mcalc_IOType::ElapsedTime]);

    #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return 0;
  }
  else if (files[Mcalc_IOType::ElapsedTime])
  {
    State_ = atoi(fgets(buffer, 20, files[Mcalc_IOType::ElapsedTime]));
    fclose(files[Mcalc_IOType::ElapsedTime]);
  }

  if (State_ >= 0)
    _TimeoutState = State_;

  #if CALCLIB_TESTASYNCMODE2c
    _Mockcio->ShowCalcTimeoutState(files[Mcalc_IOType::ElapsedTime],
                                   From_ ? From_:"GetCalcTimeoutState",
                                   State_, _ElapsedTimer->ElapsedSecs());
  #endif

  #if ((CALCLIB_DEBUG2)||(CALCLIB_DEBUG9))
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return State_;
}

/****************************************************************************/
int CalculatorBase::Bare_GetIoState(int Sleep_, int retry_)
{
  if (!InAsyncMode() && !SessionOption())
  {
    _NoPolling = false;
    return Mcalc_IOState::IDLE_STATE;
  }

  #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::Bare_GetIoState");
  #endif

  int mult_ = 0;
  #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
    // millisec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MILLI_DELAY_MULT;
    bool UsingMicros_ = UsingMicroSecDelay(&DelayLen_);
  #else
    // microsec sleep
    int DelayLen_ = IOSTATE_DELAY_LENGTH * MICRO_DELAY_MULT;
    bool UsingMicros_ = UsingMicroSecDelay(&DelayLen_);
  #endif

  bool ReadDone_ = false;
  bool PollingActive_ = false;
  bool PollingAllowed_ = _PollClientMgr ?
                             _PollClientMgr->ClientPollingAllowed():
                             false;

  if (Sleep_)
  {
    mult_ = (Sleep_ > 1) ? Sleep_:1;

    #if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
      Sleep(mult_ * DelayLen_);
    #else
      ::usleep(mult_ * DelayLen_);
    #endif

    #if CALCLIB_DEBUG1
      printf("Error: opening %s for reading, server side\n", PROG_IOSTATE_FILE);
    #endif
  }
  else
  {
    #if CALCLIB_DEBUG1
      printf("opening %s for reading 1st attempt, server side\n", PROG_IOSTATE_FILE);
    #endif
  }

  int Eof_;
  int retval;
  char buffer[20];
  ChrString StateStr_;

  int State_ = Mcalc_IOState::IDLE_STATE;
  filestatus[Mcalc_IOType::IoState] = 0;
  iostatefile = NULL;

  files[Mcalc_IOType::IoState] = FileOpen(PROG_IOSTATE_FILE, "r");
  int ErrCond_ = files[Mcalc_IOType::IoState] == NULL ||
                 (Eof_ = feof(files[Mcalc_IOType::IoState])) ||
                 ferror(files[Mcalc_IOType::IoState]);

  if (ErrCond_ || !FileSize(files[Mcalc_IOType::IoState]))
  {
    if (ErrCond_)
    {
      if (files[Mcalc_IOType::IoState])
      {
        clearerr(files[Mcalc_IOType::IoState]);
        if (Eof_)
          fclose(files[Mcalc_IOType::IoState]);

        files[Mcalc_IOType::IoState] = NULL;
      }
    }
    else if (files[Mcalc_IOType::IoState])
      fclose(files[Mcalc_IOType::IoState]);

    #if LIMIT_READ_RETRIES
      if (!_NoPolling && _PollClientMgr &&
          !_PollClientMgr->ReAttemptFileRead())
        ShowOpenStateFileFailed(true);
    #endif

    if (retry_ > RETRY_ATTEMPTS / 10)
      retry_ = 1;

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    if (_PollClientMgr)
    {
      _PollClientMgr->SetStopTracking(false);
      _PollClientMgr->SetExitAtRetryMax(true)
                    ->SetSleepWaiting(true)
                    ->SetAllowClientPolling(true)
                    ->SetBreakOnPollError(true);
    }
    #endif

    #if CALCLIB_DEBUG9
      if (DbgPtr(false))
      {
        _PollClientMgr->SetStopTracking(false);
        DbgPtr()->ShowMessage("ErrCond_ || !FileSize(files[Mcalc_IOType::IoState])\n"
                              "_PollClientMgr->PollClientRequired(0, false)\n");
        DbgPtr()->ShowInt(_NoPolling, "_NoPolling");
      }
    #endif

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    if (!_NoPolling && _PollClientMgr && retry_ > 0 &&
        _PollClientMgr->ResetWhenNotRequired(true)
                      ->SetAllowClientPolling(true)
                      ->PollClientRequired(0, false))
    {
      PollingActive_ = CalcPollingActive();
      ResumeCalcPolling();

      mult_ = (!Sleep_ && _PollClientMgr->WaitingForClientResponse()) ? 1:0;
      _PollClientMgr->ResetClientPolling(true);
      _PollClientMgr->SetAllowClientPolling(true);
      _PollClientMgr->PollClientIfAlive(mult_, true, false); // Initiate Polling
      #if CALCLIB_TESTMOCKCLIENT
        MockClientAck(IsServerStates(State_));
      #endif

      UseMicroSecDelay(true);
      retval = Bare_GetIoState(1, 0);

      if (!PollingActive_)
        PauseCalcPolling();

      return retval;
    }
    else if (CalcPollingActive() &&
             !_NoPolling && _PollClientMgr && retry_ == 0 &&
             _PollClientMgr->ResetWhenNotRequired(true)
                           ->PollClientRequired(0, true))
    {
      mult_ = _PollClientMgr->WaitingForClientResponse() ? 1:0;
      _PollClientMgr->SetStopTracking(false);
      _PollClientMgr->ResetClientPolling(false);
      _PollClientMgr->PollClientIfAlive(mult_, false, true); // Response Only
      #if CALCLIB_TESTMOCKCLIENT
        MockClientAck(IsServerStates(State_));
      #endif

      UseMicroSecDelay(true);
      return Bare_GetIoState(1, -1);
    }
    #endif

    #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    _NoPolling = false;
    _PollClientMgr->SetAllowClientPolling(PollingAllowed_);

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
      UseMicroSecDelay(true);
      return ((CalcPollingActive() && retry_ > 0) ?
                   Bare_GetIoState(1, retry_-1):0);
    #else
      return 0;
    #endif
  }
  else if (files[Mcalc_IOType::IoState])
  {
    State_ = atoi(fgets(buffer, 20, files[Mcalc_IOType::IoState]));
    fclose(files[Mcalc_IOType::IoState]);
    ReadDone_ = true;

    if (_PollClientMgr)
      _PollClientMgr->SetAllowClientPolling(PollingAllowed_)
                    ->ResetRetryRead();
  }

  if (retry_ < 0)
    retry_ = 0;

  if (State_)
  {
    _IoState = State_;

    if (_CalcResponseSent && ReadDone_ &&
        State_ == Mcalc_IOState::PROCESS)
    {
      _OutputResetRequired = true;
      _CalcResponseSent = false;
    }
  }

  bool ResponseReceived_ = IsClientStates(State_);

  #if CALCLIB_DEBUG8b
    if (_IoState == Mcalc_IOState::CALC_ERROR ||
        _IoState == Mcalc_IOState::ERROR_FETCH)
    {
      if (DbgPtr(false))
        DbgPtr()->EnterLevel("CalculatorBase::Bare_GetIoState");

      if (DbgPtr(false))
      {
        StateStr_ = GiveIoStateStr(_IoState);
        DbgPtr()->ShowStr(StateStr_.c_str(), "_IoState");
        DbgPtr()->ShowInt(Sleep_, "Sleep_");
        DbgPtr()->ShowInt(retry_, "retry_");
        DbgPtr()->LeaveLevel();
      }
    }
  #endif

  #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    #if CALCLIB_DEBUG9
      if (DbgPtr(false))
      {
        _PollClientMgr->SetStopTracking(false);
        DbgPtr()->ShowStr(buffer, "buffer");
        DbgPtr()->ShowInt(ResponseReceived_, "ResponseReceived_");

        DbgPtr()->ShowInt(_NoPolling, "_NoPolling");
        DbgPtr()->ShowInt(_IoState, "_IoState");
      }
    #endif

    // if (CalcPollingActive() &&   // new added to idle_response_only_poll
    if (ResponseReceived_ && !_NoPolling && _PollClientMgr &&
        _PollClientMgr->ResetWhenNotRequired(true)
                      ->ServerReceiveRequired())
    {
      mult_ = (!Sleep_ && _PollClientMgr->WaitingForClientResponse()) ? 1:0;
      _PollClientMgr->SetStopTracking(false);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("_PollClientMgr->ReceiveKeepAlivePoll(mult_, false);\n"
                                "-Called From: Bare_GetIoState\n");
      #endif
      _PollClientMgr->ResetReceivePoll(false);
      _PollClientMgr->ReceiveKeepAlivePoll(mult_, false);
      #if CALCLIB_TESTMOCKCLIENT
        MockClientAck(IsServerStates(_IoState));
      #endif
      #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif

      return State_;
    }
    else if (CalcPollingActive() &&
             !ResponseReceived_ && !_NoPolling && _PollClientMgr &&
             _PollClientMgr->ResetWhenNotRequired(true)
                           ->PollClientRequired(0, true))
    {
      mult_ = (!Sleep_ && _PollClientMgr->WaitingForClientResponse()) ? 1:0;
      _PollClientMgr->SetStopTracking(false);
      #if CALCLIB_DEBUG9
        if (DbgPtr(false))
          DbgPtr()->ShowMessage("_PollClientMgr->PollClientIfAlive(mult_, false, true);\n"
                                "-Called From: Bare_GetIoState\n");
      #endif
      _PollClientMgr->ResetClientPolling(false);
      _PollClientMgr->PollClientIfAlive(mult_, false, true); // Response Only
      #if CALCLIB_TESTMOCKCLIENT
        MockClientAck(IsServerStates(_IoState));
      #endif
      #if ((CALCLIB_DEBUG2)|(CALCLIB_DEBUG9))
        if (DbgPtr(false))
          DbgPtr()->LeaveLevel();
      #endif

      if (!ResponseReceived_ && retry_ > 0)
      {
        UseMicroSecDelay(true);
        retval = Bare_GetIoState(1, retry_-1);
      }
      else
        retval = State_;

      return retval;
    }
  #endif

  if (!ResponseReceived_ && retry_ > 0)
  {
    UseMicroSecDelay(UsingMicros_);
    retval = Bare_GetIoState(1, retry_-1);
  }
  else
    retval = State_;

  #if ((CALCLIB_DEBUG2)||(CALCLIB_DEBUG9))
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  _NoPolling = false;
  _PollClientMgr->SetAllowClientPolling(PollingAllowed_);

  return retval;
}

/****************************************************************************/
int CalculatorBase::GetIoState(int Sleep_)
{
  #if CALCLIB_DEBUG8c
    DbgPtr()->EnterLevel("GetIoState");
    DbgPtr()->ShowInt(Sleep_, "Sleep_");

    if (!InAsyncMode() && !SessionOption())
      DbgPtr()->LeaveLevel();
  #endif

  if (!InAsyncMode() && !SessionOption())
    return Mcalc_IOState::IDLE_STATE;

  _NoPolling = false;
  int State_ = Bare_GetIoState(Sleep_);

  if (InAsyncMode() || SessionOption())
    if (!_IoStatePtr->ResetAtEndOfProcess(State_))  // step 2
      _IoStatePtr->SetIoStateAck(State_);  // step 3

  #if CALCLIB_DEBUG8c
    DbgPtr()->LeaveLevel();
  #endif

  return State_;
}

/****************************************************************************/
int CalculatorBase::CurrentIoState() const
{
  return _IoState;
}

/****************************************************************************/
int CalculatorBase::CurrentTimeoutState() const
{
  return _TimeoutState;
}

/****************************************************************************/
void CalculatorBase::ShowArgVector(int argc, char** argv, FILE* fp,
                                   const char* argcntname_, const char* argvectname_)
{
  int x;
  const char* argcnts_ = argcntname_ ? argcntname_:"argc";
  const char* argvects_ = argvectname_ ? argvectname_:"argv";

  fprintf(fp, "%s == %d\n", argcnts_, argc);
  if (argc)
  {
    for (x = 0; x < argc; x++)
      fprintf(fp, "\t%s[%d] == %s\n", argvects_, x, (argv[x] ? argv[x]:"NULL"));
  }
  else
    fputs("\n", fp);

  fflush(fp);
}

/****************************************************************************/
char** CalculatorBase::CloneArgVector(int argc, char** argv)
{
  int x;
  char** arglist = NULL;
  arglist = (char**)allocmem(argc, sizeof(char*), arglist);

  for (x = 0; x < argc; x++)
  {
    arglist[x] = argv[x] ? (char*)allocmem(strlen(argv[x])+1, sizeof(char), arglist[x]):NULL;
    if (arglist[x])
      strcpy(arglist[x], argv[x]);
  }

  return arglist;
}

/****************************************************************************/
char** CalculatorBase::DestroyArgVector(int argc, char** argv)
{
  int x;
  if (!argv)
    return argv;

  for (x = 0; x < argc; x++)
    _MemDel->DelayedDeleteCstr(argv[x], STOREMEM);

  _MemDel->DelayedDeleteVoidp((void*)argv, STOREMEM);

  argv = NULL;
  return argv;
}

/****************************************************************************/
long CalculatorBase::FileSize(FILE* Fptr_)
{
  if (Fptr_)
  {
    fseek(Fptr_, 0, SEEK_END);
    long Pos_ = ftell(Fptr_);
    rewind(Fptr_);
    return Pos_;
  }

  return 0;
}

/****************************************************************************/
void CalculatorBase::RemoveSessionFiles(int SesNum_)
{
  // Async. mode data files
  if (USER_INPUT_FILE)
    unlink(USER_INPUT_FILE);

  if (USER_PROMPT_FILE)
    unlink(USER_PROMPT_FILE);

  if (PROG_OUTPUT_FILE)
    unlink(PROG_OUTPUT_FILE);

  if (CMDHISTORY_FILE)
    unlink(CMDHISTORY_FILE);

  if (PROG_IOSTATE_FILE)
    unlink(PROG_IOSTATE_FILE);

  // session graph files
  char Fname_[32];
  char suf;

  for (suf = 'a'; suf <= 'z'; suf++)
  {
    sprintf(Fname_, "mcalc_graph%d%c.out", SesNum_, suf);
    unlink(Fname_);
  }

  if (CURRENTGRAPH_FILE)
  {
    if (CalculatorBase::FileExists(CURRENTGRAPH_FILE))
      unlink(CURRENTGRAPH_FILE);

    MemMatrix::Matrix().Deallocate(CURRENTGRAPH_FILE);
    CURRENTGRAPH_FILE = NULL;
  }

  if (_CurrentGraphFname)
  {
    MemMatrix::Matrix().Deallocate(_CurrentGraphFname);
    _CurrentGraphFname = NULL;
  }

  if (GRAPH_OPERATION_FILE)
  {
    if (CalculatorBase::FileExists(MCALC_GRAPH_OPERATION_FILE))
      unlink(MCALC_GRAPH_OPERATION_FILE);
    if (CalculatorBase::FileExists(GRAPH_OPERATION_FILE))
      unlink(GRAPH_OPERATION_FILE);

    MemMatrix::Matrix().Deallocate(GRAPH_OPERATION_FILE);
    GRAPH_OPERATION_FILE = NULL;
  }

  if (GRAPH_PROGRESS_FILE)
  {
    if (CalculatorBase::FileExists(MCALC_GRAPH_PROGRESS_FILE))
      unlink(MCALC_GRAPH_PROGRESS_FILE);
    if (CalculatorBase::FileExists(GRAPH_PROGRESS_FILE))
      unlink(GRAPH_PROGRESS_FILE);

    MemMatrix::Matrix().Deallocate(GRAPH_PROGRESS_FILE);
    GRAPH_PROGRESS_FILE = NULL;
  }

  // server/client polling files
  if (SERVERALIVE_FILE)
    unlink(SERVERALIVE_FILE);

  if (CLIENTALIVE_FILE)
    unlink(CLIENTALIVE_FILE);

  if (POLLSTATE_FILE)
    unlink(POLLSTATE_FILE);

  if (PROGRESS_FILE)
    unlink(PROGRESS_FILE);

  if (ELAPSEDTIME_FILE)
    unlink(ELAPSEDTIME_FILE);
}

/****************************************************************************/
void CalculatorBase::AddFunctionName(const char* FncName_)
{
  if (_NumFncNames >= MAXFUNCTIONS)
  {
    DisplayErrorMessage(GetOutputFile(), Mcalc_Error::ERRVAL_ARRAYBOUNDS, "%s", ERRMSG_ARRAYBOUNDS);
    exit(1);
  }
  else
  {
    FUNCTION_NAMES[_NumFncNames] = ::NewString(FncName_);

    if (_ShortestFncName < 0)
      _ShortestFncName = ::SafeStrLen(FUNCTION_NAMES[_NumFncNames]);
    else
    {
      int len = ::SafeStrLen(FUNCTION_NAMES[_NumFncNames]);
      if (len < _ShortestFncName)
        _ShortestFncName = len;
    }

    _NumFncNames++;
  }
}

/****************************************************************************/
int CalculatorBase::UsesSessionNum()
{
  return _UseSessionCnt;
}

/****************************************************************************/
int CalculatorBase::SessionOption()
{
  return _SessionOption;
}

/****************************************************************************/
int CalculatorBase::SessionNum()
{
  return _SessionNum;
}

/****************************************************************************/
int CalculatorBase::VariableIndexFound()
{
  return _VarIndexFound;
}

/****************************************************************************/
void CalculatorBase::ResetVarIndexFound()
{
  _VarIndexFound = 0;
}

/****************************************************************************/
Mcalc_CmdLineOptions* CalculatorBase::CmdLineOptions()
{
  return _CmdLineOptions;
}

/****************************************************************************/
Mcalc_GraphOperationOptions* CalculatorBase::GraphOperationOptions()
{
  return _GraphOpOptions;
}

/****************************************************************************/
int CalculatorBase::InAsyncMode()
{
  #if CALCLIB_TESTASYNCMODE
    return TRUE;
  #else
    return _AsyncMode;
  #endif
}

/****************************************************************************/
int CalculatorBase::WaitForResponse() const
{
  return _WaitForResponse;
}

/****************************************************************************/
const char* CalculatorBase::GetDirective() const
{
  return _Directive;
}

/****************************************************************************/
void CalculatorBase::SetDirective(const char* DirStr_)
{
  if (::SafeStrLen(DirStr_))
    _Directive = ::NewString(DirStr_);
}

/****************************************************************************/
void CalculatorBase::ClearDirective()
{
  if (_Directive || ProcessAckSignalDone())
  {
    ::RawDeleteArray(_Directive);
    _Directive = NULL;

    SetProcessAckSignalPending(false);
    SetProcessAckSignalSent(false);
    SetProcessAckSignalDone(false);
    SetProcessAckForSignalReceived(0);
  }
}

/****************************************************************************/
bool CalculatorBase::HasDirective() const
{
  return
  (
    ::SafeStrLen(_Directive) != 0 &&
    (ProcessAckSignalPending() ||
     ProcessAckSignalSent() ||
     ProcessAckSignalDone())
  );
}

/****************************************************************************/
bool CalculatorBase::IsSameDirective(const char* DirStr_) const
{
  return
  (
    (HasDirective() && ::SafeStrLen(DirStr_)) ?
      icasestrcomp(_Directive, DirStr_, true):
      false
  );
}

/****************************************************************************/
void CalculatorBase::SetBatchFileEndedSignalConfirmed(int flag_)
{
  _BatchFileEndedSignalConfirmed = flag_;
}

/****************************************************************************/
int CalculatorBase::BatchFileEndedSignalConfirmed(int sent_)
{
  return (_BatchFileEndedSignalConfirmed && sent_);
}

/****************************************************************************/
int CalculatorBase::EndOfBatchFileProcessing()
{
  int IoState_;
  bool InRunningProg_;
  bool Sent_ = false;

  // For running a batch input file within a .prg program file
  //   BatchFile_ == false
  //   InProgram_ == true
  //   PrevProgram_ == false
  //   AndOptions_ == NA
  if (InRunningProgram(false, true, false))
  {
    IoState_ = Bare_GetIoState(0);
    if (!UsesSessionNum() ||
        IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
      PromptAsyncUser(MSG_INPUT_FILE_ENDED, PROMPT_STOP_MSG);

    IoState_ = Bare_GetIoState(0);
    InRunningProg_ = true;
  }
  else
  {
    IoState_ = SendBatchFileEndedSignal(0);

    if (Exec_BatchFileDonePending())
      Exec_SetBatchFileDonePending(false);
  }

  Sent_ = BatchFileEndedSignalSent();

  if (!IoState_)
    IoState_ = _IoState;
  else if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
           (InRunningProg_ && IoState_ == Mcalc_IOState::INPUT_RECEIVED))
  {
    if (InRunningProg_ && !BatchFileEndedSignalConfirmed(Sent_) &&
        IoState_ == Mcalc_IOState::INPUT_RECEIVED)
    {
      SetBatchFileEndedSignalConfirmed(false);
      IoState_ = SendBatchFileEndedSignal(0);

      if (Exec_BatchFileDonePending())
        Exec_SetBatchFileDonePending(false);
    }
    else if (BatchFileEndedSignalConfirmed(Sent_))
    {
      SetBatchFileEndedSignalConfirmed(false);

      if (IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
      {
        SetWriteToFileBatchLevel(true);
        Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true);
      }
    }

    if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      SetBatchFileEndedSignalPending(false);
      SetClientAckedDoneToGraphOutput(false);
      SetWasInBatchDataInput(FALSE);
    }
  }
  else if (BatchFileEndedSignalConfirmed(Sent_))
  {
    SetBatchFileEndedSignalConfirmed(false);

    if (IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      SetWriteToFileBatchLevel(true);
      Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true);
    }
  }

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::HandleForcedIoStateSignals()
{
  int IoState_ = CurrentIoState();

  if ((_PrevSetState == Mcalc_IOState::PROGRESS_READY ||
       _PrevSetState == Mcalc_IOState::INFILE_PROGRESS_ACK) &&
      (IoStateForced() ||
       InFileProgressAmount() < InFileSizeAmount()))
  {
    IoState_ = _PrevSetState;

    UpdateProgressFile(_InputFileLineSize, _InputFileLineSize, SessionOption());
    IoState_ = CurrentIoState();
    SetIoStateForced(false);
  }
  else if ((_PrevSetState == Mcalc_IOState::GRAPH_OUTPUT ||
            _PrevSetState == Mcalc_IOState::OUTPUT_FETCHED) &&
           IoStateForced())
  {
    IoState_ = _PrevSetState;
    IoState_ = WaitForClientOutputStates(IoState_, NULL, IoStateForced());
    SetIoStateForced(false);
  }
  else if (BatchFileEndedSignalSent() && IoStateForced())
  {
    IoState_ = _PrevSetState;
    IoState_ = WaitForBatchFileEndedAck(IoState_, NULL, IoStateForced());
    SetIoStateForced(false);
  }

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendProcessAckSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  #if CALCLIB_DEBUG12c
    DbgPtr()->ShowInt(InAsyncMode(), "InAsyncMode()");
    DbgPtr()->ShowInt(NoPauseFileInput(), "NoPauseFileInput()");
    DbgPtr()->ShowInt(ProcessAckSignalSent(), "ProcessAckSignalSent()");
    DbgPtr()->ShowInt(ProcessAckSignalDone(), "ProcessAckSignalDone()");
    DbgPtr()->ShowInt(ProcessAckSignalPending(), "ProcessAckSignalPending()");
  #endif

  if (!InAsyncMode() || NoPauseFileInput() ||
      ProcessAckSignalSent() ||
      ProcessAckSignalDone() ||
      !ProcessAckSignalPending())
    return 0;

  int IoState_ = Bare_GetIoState(0);
  int AckSigReceived_ = ProcessAckForSignalReceived();
  bool SesOptOverride_ = SessionOptionOverride();
  bool InInputFile_ = ExecInputFileData() && !AckPostExecInputFileData() &&
                      InputDataFileExecLock() == EXECFILE_LOCKED;
  bool ReturnAnswer_ = SessionOption() || NoPauseFileInput();

  // assume ack response signal sent if wait period is too long
  // or wait forever if processing input data file
  bool WaitForever_ = InBatchFile() || ReturnAnswer_;
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  // Handle forced I/O State values
  HandleForcedIoStateSignals();

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
    {
      DbgPtr()->EnterLevel("CalculatorBase::SendProcessAckSignal");
      DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
      DbgPtr()->ShowInt(InInputFile_, "InInputFile_");
    }
  #endif

  if (InInputFile_ ||
      AckSigReceived_ == IoState_)
  {
    _IoStateToSend = Mcalc_IOState::PROCESS_DONE;
    Bare_SetIoState(Mcalc_IOState::PROCESS_DONE, true, 0);
    _PrevSetState = _IoState;

    #if CALCLIB_DEBUG12c
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SendProcessAckSignal -- Signal Sent\n");
    #endif

    SetProcessAckSignalPending(false);
    SetProcessAckSignalSent(true);
    SetProcessAckTransition(_IoState, false);

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    SetWaitForeverForSignal(WaitForever_);
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    // wait for PROCESS_DONE_ACK signal from client
    SetSessionOptionOverride(SesOptOverride_);
    _ResendLastSignal = FALSE;
    IoState_ = WaitForProcessAckReceived(_IoState);
    _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if (InProgramMode(true) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendOutputReadySignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  if ((!InAsyncMode() && !SessionOptionOverride()) ||
      IsOutputFileEmpty(Mcalc_IOState::OUTPUT_READY) ||
      !IsOutputTiedToSignal(Mcalc_IOState::OUTPUT_READY))
    return 0;

  #if ((CALCLIB_DEBUG12c)|(CALCLIB_DEBUG12b))
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendOutputReadySignal");
  #endif

  int IoState_ = 0;
  bool SesOptOverride_ = SessionOptionOverride();
  bool ReturnAnswer_ = SessionOption() || NoPauseFileInput();

  // assume ack response signal sent if wait period is too long
  // or wait forever if processing input data file
  bool WaitForever_ = InBatchFile() || ReturnAnswer_;
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  // Handle forced I/O State values
  HandleForcedIoStateSignals();

  _StateVarsReset = false;
  _IoStateToSend = Mcalc_IOState::OUTPUT_READY;
  SetIoState(Mcalc_IOState::OUTPUT_READY, true, Delay_);
  _PrevSetState = _IoState;

  if (_PollClientMgr)
    _PollClientMgr->ResetRetryRead();

  SetWaitForeverForSignal(WaitForever_);
  SetSessionOptionOverride(SesOptOverride_);
  IoState_ = Bare_GetIoState(0);

  // wait for OUTPUT_FETCHED signal from client
  SetSessionOptionOverride(SesOptOverride_);
  _ResendLastSignal = FALSE;
  IoState_ = WaitForClientOutputStates(IoState_);
  _IoStateToSend = 0;

  // clear output file after display
  if (IoState_ == Mcalc_IOState::OUTPUT_FETCHED)
    ResetOutputFiles(false);

  bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                    IoState_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                     IoState_ == Mcalc_IOState::IDLE_STATE;

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  ResetStateVars();
  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);

  #if ((CALCLIB_DEBUG12c)|(CALCLIB_DEBUG12b))
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendCalcResponseSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  if ((!InAsyncMode() && !SessionOptionOverride()) ||
      !GiveIoAccessCondition(NULL, IOACCESS))
    return 0;

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendCalcResponseSignal");
  #endif

  int IoState_ = 0;
  bool OverrideTrue_ = true;
  bool SesOptOverride_ = SessionOptionOverride();
  bool ReturnAnswer_ = SessionOption() || NoPauseFileInput();

  // No need to wait if running batch file and not in interactive mode
  bool NoWait_ = InNonPausedBatchFile() && ReturnAnswer_;
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  // Handle forced I/O State values
  HandleForcedIoStateSignals();

  _StateVarsReset = false;
  _IoStateToSend = Mcalc_IOState::CALC_RESPONSE;
  SetIoState(Mcalc_IOState::CALC_RESPONSE, true, Delay_);
  _PrevSetState = _IoState;

  if (_PollClientMgr)
    _PollClientMgr->ResetRetryRead();

  SetWaitForeverForSignal(!NoWait_);
  SetSessionOptionOverride(SesOptOverride_);
  IoState_ = Bare_GetIoState(0);

  // Skip attempt to receive response if no wait
  if (!NoWait_ &&
      (EmptyResponseAllowed() || !OutputResetRequired()))
  {
    // wait for INPUT_RECEIVED or PROCESS signal from client
    OverrideTrue_ = true;
    SetSessionOptionOverride(OverrideTrue_);

    _ResendLastSignal = FALSE;
    IoState_ = WaitForClientProcessStates(IoState_);
    _IoStateToSend = 0;
  }
  else
    _IoStateToSend = 0;

  // clear output file after display
  if (!EmptyResponseAllowed() &&
      OutputResetRequired() &&
      IoState_ == Mcalc_IOState::PROCESS)
    ResetOutputFiles(false);
  else if (EmptyResponseAllowed())
    AllowEmptyResponse(false);

  bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                    IoState_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                     IoState_ == Mcalc_IOState::IDLE_STATE;

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  ResetStateVars();
  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);
  else if (OverrideTrue_)
    SetSessionOptionOverride(SesOptOverride_);

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendSpawnCalcSignal(int Delay_, int argc, char** argv, char** envr,
                                        bool* BreakAll_, bool* DoHalt_)
{
  if (!InAsyncMode() && !SessionOptionOverride())
    return 0;

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendSpawnCalcSignal");
  #endif

  int x;
  int n = 1;
  int IoState_ = 0;

  bool OverrideTrue_ = true;
  bool SesOptOverride_ = SessionOptionOverride();
  bool NoWait_ = false;  // wait for spawn calc. response
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  char msgbuf_[256];

  if (envr)
    for (x = 0; x >= 0 && envr[x]; x++)
      n++;

  sprintf(msgbuf_, "%d\n%d:", n, argc);
  --n;

  if (argv)
    for (x = 0; x < argc && argv[x]; x++)
    {
      strcat(msgbuf_, argv[x]);
      strcat(msgbuf_, " ");
    }

  for (x = 0; n > 0; x++)
  {
    strcat(msgbuf_, "\n");
    strcat(msgbuf_, envr[x]);
    --n;
  }

  SetSessionOptionOverride(true);
  DisplayToSpawnArgFile(msgbuf_);
  CloseSpawnArgFile();
  SetHasAnswer(FALSE);

  _StateVarsReset = false;
  _IoStateToSend = Mcalc_IOState::SPAWN_NEW_MCALC;
  SetIoState(Mcalc_IOState::SPAWN_NEW_MCALC, true, Delay_);
  _PrevSetState = _IoState;

  if (_PollClientMgr)
    _PollClientMgr->ResetRetryRead();

  SetWaitForeverForSignal(!NoWait_);
  SetSessionOptionOverride(SesOptOverride_);
  IoState_ = Bare_GetIoState(0);

  // Skip attempt to receive response if no wait
  if (!NoWait_)
  {
    OverrideTrue_ = true;
    SetSessionOptionOverride(OverrideTrue_);

    // No signal resending attempts for SPAWN_NEW_MCALC signals
    _ResendLastSignal = FALSE;
    IoState_ = WaitForClientSpawnCalcStates(IoState_);
  }

  _ResendLastSignal = FALSE;
  _IoStateToSend = 0;

  bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                    IoState_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                     IoState_ == Mcalc_IOState::IDLE_STATE;

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  ResetStateVars();
  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);
  else if (OverrideTrue_)
    SetSessionOptionOverride(SesOptOverride_);

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendInputRequiredSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  if (!InAsyncMode() && !SessionOptionOverride())
    return 0;

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendInputRequiredSignal");
  #endif

  int IoState_ = 0;
  bool SesOptOverride_ = SessionOptionOverride();
  bool ReturnAnswer_ = SessionOption() || NoPauseFileInput();

  // No need to wait if running batch file and not in interactive mode
  bool NoWait_ = InNonPausedBatchFile() && ReturnAnswer_;
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  // Handle forced I/O State values
  HandleForcedIoStateSignals();

  // return from method early if in non-paused batch file
  // we're not waiting for user interaction to send a response
  if (NoWait_)
    return Bare_GetIoState(0);

  _StateVarsReset = false;
  _IoStateToSend = Mcalc_IOState::INPUT_REQUIRED;
  SetIoState(Mcalc_IOState::INPUT_REQUIRED, true, Delay_);
  _PrevSetState = _IoState;

  if (_PollClientMgr)
    _PollClientMgr->ResetRetryRead();

  SetWaitForeverForSignal(!NoWait_);
  SetSessionOptionOverride(SesOptOverride_);
  IoState_ = Bare_GetIoState(0);

  // wait for INPUT_RECEIVED signal from client
  SetSessionOptionOverride(SesOptOverride_);
  _ResendLastSignal = FALSE;
  IoState_ = WaitForClientOutputExtStates(IoState_);
  _IoStateToSend = 0;

  // clear output file after display
  if (IoState_ == Mcalc_IOState::INPUT_RECEIVED)
    ResetOutputFiles(true);

  bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                    IoState_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                     IoState_ == Mcalc_IOState::IDLE_STATE;

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  ResetStateVars();
  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendInFileProgressSignal(int Delay_, bool* BreakAll_,
                                             bool* DoHalt_, bool Retrying_)
{
  if (!((InAsyncMode() || SessionOptionOverride()) || _InputExists))
    return 0;

  #if CALCLIB_DEBUG12b
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendInFileProgressSignal");
  #endif

  int IoState_ = 0;
  bool SesOptOverride_ = SessionOptionOverride();

  // assume ack response signal sent if wait period is too long
  bool WaitForever_ = false;
  int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
  int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

  _StateVarsReset = false;
  _IoStateToSend = Mcalc_IOState::PROGRESS_READY;
  SetIoState(Mcalc_IOState::PROGRESS_READY, true, Delay_);
  _PrevSetState = _IoState;

  if (_PollClientMgr)
    _PollClientMgr->ResetRetryRead();

  #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    SetWaitForeverForSignal(false);
  #else
    SetWaitForeverForSignal(WaitForever_);
  #endif

  SetSessionOptionOverride(SesOptOverride_);
  IoState_ = Bare_GetIoState(0);

  // wait for INFILE_PROGRESS_ACK signal from client
  SetSessionOptionOverride(SesOptOverride_);
  _ResendLastSignal = FALSE;
  IoState_ = WaitForClientInFileProgressStates(IoState_, NULL, Retrying_);
  _IoStateToSend = 0;

  bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                    IoState_ == Mcalc_IOState::ERROR_FETCH;
  bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                     IoState_ == Mcalc_IOState::IDLE_STATE;

  if (DoHalt_)
    *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

  if (InProgramMode(true) && BreakAll_)
    *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                 IoState_ == Mcalc_IOState::BREAK_PROGRAM;

  ResetStateVars();
  if (SessionOption() && !CritStates_ && !ErrStates_)
    SetSessionOptionOverride(false);

  #if CALCLIB_DEBUG12b
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::SendElapsedTimeSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  if (!((InAsyncMode() || SessionOptionOverride()) || _InputExists))
    return 0;

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("CalculatorBase::SendElapsedTimeSignal");
  #endif

  bool FetchLimitReached_ = false;
  bool OverDuration_ = false;

  int State_ = SetCalcTimeoutState(Mcalc_ElapsedTime::SENT, "CalculatorBase::SendElapsedTimeSignal");
  int TimeoutAck_ = WaitForClientElapsedTimeAck(State_, &FetchLimitReached_, &OverDuration_);

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return TimeoutAck_;
}

/****************************************************************************/
int CalculatorBase::SendGraphWaitSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("SendGraphWaitSignal");
  #endif

  if (GraphOperation() && _Plotter &&
      (InAsyncMode() || SessionOptionOverride()))
  {
    int IoState_ = 0;
    bool OverrideTrue_ = true;
    bool SesOptOverride_ = SessionOptionOverride();
    bool ExecInfile_ = ExecInputFileDataCnt() &&
                       _ExecuteProgram && _ExecuteProgram->Name();

    // assume ack response signal sent if wait period is too long
    bool WaitForever_ = false;
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

    // Handle forced I/O State values
    HandleForcedIoStateSignals();

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SetIoState(Mcalc_IOState::GRAPH_WAIT...\n");
    #endif

    SetGraphOpStage(Mcalc_IOState::GRAPH_WAIT);
    _IoStateToSend = Mcalc_IOState::GRAPH_WAIT;
    SetIoState(Mcalc_IOState::GRAPH_WAIT, true, Delay_);
    _PrevSetState = _IoState;

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    WaitForever_ = ExecInputFileData() && !AckPostExecInputFileData() &&
                   InputDataFileExecLock() == EXECFILE_LOCKED &&
                   GraphFilePause() && InputDataFilePauseOption();

    // Wait forever for user response if GraphFilePause option is selected
    SetWaitForeverForSignal(WaitForever_);
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    // wait for GRAPH_WAIT_ACK or INPUT_RECEIVED signal from client
    SetSessionOptionOverride(SesOptOverride_);

    do
    {
      _ResendLastSignal = FALSE;
      IoState_ = WaitForClientGraphWaitStates(IoState_);

      if (IoState_ == Mcalc_IOState::GRAPH_WAIT_ACK ||
          IoState_ == Mcalc_IOState::INPUT_RECEIVED ||
          (IoState_ & ExitModes_))
        _ResendLastSignal = FALSE;
      else if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;

      if (_ResendLastSignal)
      {
        OverrideTrue_ = true;
        SetSessionOptionOverride(OverrideTrue_);

        SetIoState(Mcalc_IOState::GRAPH_WAIT, true, Delay_);
        _PrevSetState = _IoState;
        IoState_ = Bare_GetIoState(0);
        SetSessionOptionOverride(OverrideTrue_);
      }
    }
    while (_ResendLastSignal);

    if (IoState_ == Mcalc_IOState::GRAPH_WAIT_ACK ||
        IoState_ == Mcalc_IOState::INPUT_RECEIVED ||
        (IoState_ & ExitModes_))
      _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if ((ExecInfile_ || InProgramMode(true)) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    if (IoState_ == Mcalc_IOState::INPUT_RECEIVED)
    {
      _StateVarsReset = false;
      ResetStateVars();
    }

    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);
    else if (OverrideTrue_)
      SetSessionOptionOverride(SesOptOverride_);

    return IoState_;
  }
  else
    return 0;

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return _IoState;
}

/****************************************************************************/
int CalculatorBase::SendGraphProgressSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  #if CALCLIB_DEBUG11c
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("SendGraphProgressSignal");
  #endif

  if (GraphOperation() && _Plotter &&
      (InAsyncMode() || SessionOptionOverride()))
  {
    int IoState_ = 0;
    bool OverrideTrue_ = false;
    bool SesOptOverride_ = SessionOptionOverride();
    bool ExecInfile_ = ExecInputFileDataCnt() &&
                       _ExecuteProgram && _ExecuteProgram->Name();

    // assume ack response signal sent if wait period is too long
    bool WaitForever_ = false;
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

    #if CALCLIB_DEBUG11c
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SetIoState(Mcalc_IOState::GRAPH_PROGRESS...\n");
    #endif

    // Handle forced I/O State values
    HandleForcedIoStateSignals();

    SetGraphOpStage(Mcalc_IOState::GRAPH_PROGRESS);
    _IoStateToSend = Mcalc_IOState::GRAPH_PROGRESS;
    SetIoState(Mcalc_IOState::GRAPH_PROGRESS, true, Delay_);
    _PrevSetState = _IoState;

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    SetWaitForeverForSignal(WaitForever_);
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    // wait for GRAPH_PROGRESS_ACK signal from client
    SetSessionOptionOverride(SesOptOverride_);

    do
    {
      _ResendLastSignal = FALSE;
      IoState_ = WaitForClientGraphProgressStates(IoState_);

      if (IoState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK ||
          (IoState_ & ExitModes_))
        _ResendLastSignal = FALSE;
      else if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;

      if (_ResendLastSignal)
      {
        OverrideTrue_ = true;
        SetSessionOptionOverride(OverrideTrue_);

        SetIoState(Mcalc_IOState::GRAPH_PROGRESS, true, Delay_);
        _PrevSetState = _IoState;
        IoState_ = Bare_GetIoState(0);
        SetSessionOptionOverride(OverrideTrue_);
      }
    }
    while (_ResendLastSignal);

    if (IoState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK ||
        (IoState_ & ExitModes_))
      _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if ((ExecInfile_ || InProgramMode(true)) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);
    else if (OverrideTrue_)
      SetSessionOptionOverride(SesOptOverride_);

    #if CALCLIB_DEBUG11c
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }
  else
    return 0;

  #if CALCLIB_DEBUG11c
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return _IoState;
}

/****************************************************************************/
int CalculatorBase::SendGraphOutputSignal(int Delay_, bool InBatch_,
                                          bool* BreakAll_, bool* DoHalt_, bool Retrying_)
{
  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("SendGraphOutputSignal");
  #endif

  bool BatchSigSent_ = BatchFileEndedSignalSent() ||
                       BatchFileEndedSignalAcked();

  if (GraphOperation() && _Plotter &&
      (InAsyncMode() || SessionOptionOverride()) &&
      (!InBatch_ ||
       (!BatchSigSent_ && InAllGraphsFile() &&
        WasInBatchDataInput() && !GraphOutputWasSent())))
  {
    int IoState_ = 0;
    bool OverrideTrue_ = false;
    bool SesOptOverride_ = SessionOptionOverride();
    bool ExecInfile_ = ExecInputFileDataCnt() &&
                       _ExecuteProgram && _ExecuteProgram->Name();

    // Assume graph plotting operation takes indefinite amount of time
    #if CALCLIB_TESTASYNCNOWAIT
      bool WaitForever_ = false;
    #else
      bool WaitForever_ = true;
    #endif
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

    _StateVarsReset = false;

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SetIoState(Mcalc_IOState::GRAPH_OUTPUT...\n");
    #endif

    if (_IoStatePtr)
      _IoStatePtr->RestoreGraphProgressStates();

    SetGraphOpStage(Mcalc_IOState::GRAPH_OUTPUT);
    _IoStateToSend = Mcalc_IOState::GRAPH_OUTPUT;
    SetIoState(Mcalc_IOState::GRAPH_OUTPUT, true, Delay_);
    _PrevSetState = _IoState;

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
      SetWaitForeverForSignal(false);
    #else
      SetWaitForeverForSignal(WaitForever_);
    #endif

    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    if (_BatchDataInput)
      _GraphOutputSent = IoState_ == Mcalc_IOState::GRAPH_OUTPUT;

    // wait for OUTPUT_FETCHED signal from client
    SetSessionOptionOverride(SesOptOverride_);

    do
    {
      _ResendLastSignal = FALSE;
      IoState_ = WaitForClientOutputStates(IoState_, NULL, Retrying_);

      if (IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
          (IoState_ & ExitModes_))
        _ResendLastSignal = FALSE;
      else if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;

      if (_ResendLastSignal)
      {
        OverrideTrue_ = true;
        SetSessionOptionOverride(OverrideTrue_);

        SetIoState(Mcalc_IOState::GRAPH_OUTPUT, true, Delay_);
        _PrevSetState = _IoState;
        IoState_ = Bare_GetIoState(0);
        SetSessionOptionOverride(OverrideTrue_);
      }
    }
    while (_ResendLastSignal);

    if (IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
        (IoState_ & ExitModes_))
      _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if ((ExecInfile_ || InProgramMode(true)) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    ResetStateVars();
    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);
    else if (OverrideTrue_)
      SetSessionOptionOverride(SesOptOverride_);

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }
  else
    return 0;

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return _IoState;
}

/****************************************************************************/
int CalculatorBase::SendBatchFileEndedSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("SendBatchFileEndedSignal");
  #endif

  if (InAsyncMode() || SessionOptionOverride())
  {
    int IoState_ = 0;
    bool OverrideTrue_ = false;
    bool SesOptOverride_ = SessionOptionOverride();
    bool ExecInfile_ = ExecInputFileDataCnt() &&
                       _ExecuteProgram && _ExecuteProgram->Name();
    bool Acked_ = false;

    // Assume batchfile ended ack signal takes indefinite amount of time
    #if CALCLIB_TESTASYNCNOWAIT
      bool WaitForever_ = false;
    #else
      bool WaitForever_ = true;
    #endif
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

    // Handle forced I/O State values
    HandleForcedIoStateSignals();

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SetIoState(Mcalc_IOState::BATCHFILE_ENDED...\n");
    #endif

    SetBatchFileEndedSignalSent(true);
    Exec_SetBatchFileDonePending(false);

    SetWriteToFileBatchLevel(true);
    _IoStateToSend = Mcalc_IOState::BATCHFILE_ENDED;
    SetIoState(Mcalc_IOState::BATCHFILE_ENDED, true, Delay_);
    _PrevSetState = _IoState;

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    SetWaitForeverForSignal(WaitForever_);
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    // wait for BATCHFILE_ENDED_ACK signal from client
    SetSessionOptionOverride(SesOptOverride_);

    do
    {
      _ResendLastSignal = FALSE;
      IoState_ = WaitForBatchFileEndedAck(IoState_);

      if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
          (IoState_ & ExitModes_))
        _ResendLastSignal = FALSE;
      else if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;

      if (_ResendLastSignal)
      {
        OverrideTrue_ = true;
        SetSessionOptionOverride(OverrideTrue_);

        SetWriteToFileBatchLevel(true);
        SetIoState(Mcalc_IOState::BATCHFILE_ENDED, true, Delay_);
        _PrevSetState = _IoState;
        IoState_ = Bare_GetIoState(0);
        SetSessionOptionOverride(OverrideTrue_);
      }
    }
    while (_ResendLastSignal);

    Acked_ = IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK;
    SetBatchFileEndedSignalAcked(Acked_);

    if (Acked_ || (IoState_ & ExitModes_))
      _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if ((ExecInfile_ || InProgramMode(true)) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);
    else if (OverrideTrue_)
      SetSessionOptionOverride(SesOptOverride_);

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }
  else
    return 0;

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return _IoState;
}

/****************************************************************************/
int CalculatorBase::SendClientPingSignal(int Delay_, bool* BreakAll_, bool* DoHalt_)
{
  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("SendClientPingSignal");
  #endif

  if ((InAsyncMode() || SessionOptionOverride()) || _InputExists)
  {
    int IoState_ = 0;
    bool SesOptOverride_ = SessionOptionOverride();
    bool ExecInfile_ = ExecInputFileDataCnt() &&
                       _ExecuteProgram && _ExecuteProgram->Name();
    bool Acked_ = false;

    // assume client program is inactive or dead if wait period is too long
    bool WaitForever_ = false;
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int ExitModes_ = InProgMode_ | Mcalc_IOState::CALC_HALT;

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->ShowMessage("SetIoState(Mcalc_IOState::CLIENTPING...\n");
    #endif

    SetClientPingSignalSent(true);
    _IoStateToSend = Mcalc_IOState::CLIENTPING;
    SetIoState(Mcalc_IOState::CLIENTPING, true, Delay_);
    _PrevSetState = _IoState;

    if (_PollClientMgr)
      _PollClientMgr->ResetRetryRead();

    SetWaitForeverForSignal(WaitForever_);
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = Bare_GetIoState(0);

    SetSessionOptionOverride(SesOptOverride_);

    // No signal resending attempts for CLIENTPING control signals
    _ResendLastSignal = FALSE;
    IoState_ = WaitForClientPingAck(IoState_);

    Acked_ = !ClientIsDead() &&
             IoState_ == Mcalc_IOState::CLIENTPING_ACK;
    SetClientPingSignalAcked(Acked_);

    _ResendLastSignal = FALSE;
    _IoStateToSend = 0;

    bool ErrStates_ = IoState_ == Mcalc_IOState::CALC_ERROR ||
                      IoState_ == Mcalc_IOState::ERROR_FETCH;
    bool CritStates_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                       IoState_ == Mcalc_IOState::IDLE_STATE;

    if (DoHalt_)
      *DoHalt_ = IoState_ == Mcalc_IOState::CALC_HALT;

    if ((ExecInfile_ || InProgramMode(true)) && BreakAll_)
      *BreakAll_ = IoState_ == Mcalc_IOState::CALC_HALT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM;

    if (SessionOption() && !CritStates_ && !ErrStates_)
      SetSessionOptionOverride(false);

    #if CALCLIB_DEBUG11a
      if (DbgPtr(false))
        DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }
  else
    return 0;

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif

  return _IoState;
}

/*****************************************************************************/
void CalculatorBase::SetReadUserInputAttemptLoopGuard(int LoopGuard_, int LoopGuardLimit_)
{
  _ReadUserAttemptLoopGuard = LoopGuard_;
  _ReadUserAttemptLoopGuardLimit = LoopGuardLimit_;
}

/*****************************************************************************/
void CalculatorBase::ResetReadUserInputAttemptLoopGuard()
{
  _ZeroLenArgStr = false;

  #if CALCLIB_TESTASYNCMODE2c
    if (_Mockcio)
      _Mockcio->ResetUserInputLength();
  #endif

  _ReadUserAttemptLoopGuard = _ReadUserAttemptLoopGuardLimit;
}

/*****************************************************************************/
void CalculatorBase::TickReadUserInputAttemptLoopGuard(Ushort Ticks_, int Dir_)
{
  int Diff_ = 0;

  if (Dir_ > 0 && _ReadUserAttemptLoopGuard < _ReadUserAttemptLoopGuardLimit)
  {
    Diff_ = _ReadUserAttemptLoopGuardLimit - Ticks_;

    if (Ticks_ > _ReadUserAttemptLoopGuardLimit ||
        _ReadUserAttemptLoopGuard >= Diff_)
      _ReadUserAttemptLoopGuard = _ReadUserAttemptLoopGuardLimit;
    else
      _ReadUserAttemptLoopGuard += Ticks_;
  }
  else if (Dir_ < 0 && _ReadUserAttemptLoopGuard > 0)
  {
    if (Ticks_ >= _ReadUserAttemptLoopGuard)
      _ReadUserAttemptLoopGuard = 0;
    else
      _ReadUserAttemptLoopGuard -= Ticks_;
  }
}

/****************************************************************************/
bool CalculatorBase::CheckForResendCond(int IoState_)
{
  bool ResendGraphOutput_ = false;
  bool ResendGraphProgress_ = false;
  bool ResendBatchFileEnded_ = false;

  ResendGraphOutput_ = (_IoStateToSend == Mcalc_IOState::GRAPH_OUTPUT &&
                        IoState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK);

  if (ResendGraphOutput_)
  {
    _ResendLastSignal = TRUE;
    return true;
  }

  ResendGraphProgress_ = (_IoStateToSend == Mcalc_IOState::GRAPH_PROGRESS &&
                          (IoState_ == Mcalc_IOState::GRAPH_WAIT_ACK ||
                           IoState_ == Mcalc_IOState::INPUT_RECEIVED));

  if (ResendGraphProgress_)
  {
    _ResendLastSignal = TRUE;
    return true;
  }

  ResendBatchFileEnded_ = (_IoStateToSend == Mcalc_IOState::BATCHFILE_ENDED &&
                           (IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
                            IoState_ == Mcalc_IOState::INFILE_PROGRESS_ACK));

  if (ResendBatchFileEnded_)
  {
    _ResendLastSignal = TRUE;
    return true;
  }

  return false;
}

/****************************************************************************/
int CalculatorBase::WaitForClientIoState(int CurState_, int IoStates_,
                                         bool SetMaxRetries_, int MaxRetries_, bool* FetchLimitReached_)
{
  if (!InAsyncMode() && !SessionOptionOverride())
    return 0;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientIoState");
  #endif

  int x;
  int ReadIter_ = 0;
  int IoState_ = 0;
  int PrevState_ = 0;
  int FetchAttempts_ = 0;
  int FetchLimit_ =
         SetMaxRetries_ ?
            ((WaitForeverForSignal() && MaxRetries_ > RETRY_READ_MAX) ?
                 RETRY_READ_MAX:MaxRetries_):0;

  int MAXBEFORECHECK = 100;
  int PollingActive_ = 0;
  int WaitCycle_ = 1;
  int InitState_ = Bare_GetIoState(0, 0);

  bool PollingClient_ = false;
  bool PollError_ = false;
  bool PollAnswered_ = false;
  bool MaxReached_ = false;
  bool SingleSel_ = false;
  bool PollingAllowed_ = false;
  bool SesOptOverride_ = SessionOptionOverride();

  FetchAttempts_ = 0;
  IoState_ = CurState_;
  _NoPolling = false;

  // _IoStateToSend == Mcalc_IOState::BATCHFILE_ENDED;
  //    resend if: previous == OUTPUT_FETCHED || INFILE_PROGRESS_ACK
  //    completed if: iostate == Mcalc_IOState::BATCHFILE_ENDED_ACK;
  // _IoStateToSend == Mcalc_IOState::GRAPH_PROGRESS;
  //    resend if: previous == GRAPH_WAIT_ACK || INPUT_RECEIVED
  //    completed if: iostate == Mcalc_IOState::GRAPH_PROGRESS_ACK;
  // _IoStateToSend = Mcalc_IOState::GRAPH_OUTPUT;
  //    resend if: previous = GRAPH_PROGRESS_ACK
  //    completed if: iostate == Mcalc_IOState::OUTPUT_FETCHED

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
    ChrString IoStatesStr_;

    for (x = Mcalc_IOState::IOSTATE_STARTVAL;
         x <= Mcalc_IOState::IOSTATE_ENDVAL; x *= 2)
      if ((x & IoStates_) != 0)
      {
        if (!IoStatesStr_.IsEmpty())
          IoStatesStr_ += "|";

        IoStatesStr_ += IoStateToStr(x);
      }

    DbgPtr()->ShowStr(IoStatesStr_.c_str(), "IoStates_");
  #endif

  #if CALCLIB_TESTASYNCMODE2c
    bool SignalSent_ = false;

    _Mockcio->ResetFlags();

    if (((Mcalc_IOState::PROCESS & IoStates_) != 0 ||
         (Mcalc_IOState::OUTPUT_FETCHED & IoStates_) != 0 ||
         (Mcalc_IOState::PROCESS_DONE_ACK & IoStates_) != 0 ||
         (Mcalc_IOState::INPUT_RECEIVED & IoStates_) != 0) &&
        (Mcalc_IOState::BREAK_PROGRAM & IoStates_) != 0 &&
        (Mcalc_IOState::CALC_HALT & IoStates_) != 0)
    {
      if (_Mockcio->ProcessClientIoState(CurState_, SignalSent_, CurrentIoState(), 0))
      {
        if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
          Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
        else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
          Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
        else
        {
          if ((Mcalc_IOState::INPUT_RECEIVED & IoStates_) != 0)
            Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
          else if ((Mcalc_IOState::OUTPUT_FETCHED & IoStates_) != 0 ||
                   _Mockcio->OutputFetched())
            Bare_SetIoState(Mcalc_IOState::OUTPUT_FETCHED, true);
          else if ((Mcalc_IOState::PROCESS_DONE_ACK & IoStates_) != 0 ||
                   _Mockcio->ProcessDone())
            Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
          else if ((_Mockcio->InBatchInput() || _Mockcio->InputOptional()) &&
                   ((Mcalc_IOState::INPUT_RECEIVED & IoStates_) != 0))
            Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
          else if (_Mockcio->ProcessRequired() &&
                   ((Mcalc_IOState::PROCESS & IoStates_) != 0))
            Bare_SetIoState(Mcalc_IOState::PROCESS, true);
        }
      }

      if (SignalSent_)
      {
        IoState_ = Bare_GetIoState(0);
        _Mockcio->UpdateClientIoState(IoState_);
      }

      // Set new iostate value if not set and update calc. state
      SetIoState(IoState_, true, 0, false);
      SetSessionOptionOverride(SesOptOverride_);
    }
  #elif CALCLIB_TESTASYNCMODE
    if ((Mcalc_IOState::PROCESS & IoStates_) != 0)
      Bare_SetIoState(Mcalc_IOState::PROCESS, true);
    else if ((Mcalc_IOState::BREAK_PROGRAM & IoStates_) != 0)
      Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
    else if ((Mcalc_IOState::CALC_HALT & IoStates_) != 0)
      Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
  #endif

  do
  {
    while ((!SetMaxRetries_ || FetchAttempts_ < FetchLimit_) &&
           (IoState_ & IoStates_) == 0)
    {
      UseMicroSecDelay(false);
      IoState_ = Bare_GetIoState(WaitCycle_++);
      FetchAttempts_++;

      if (WaitCycle_ > 3)
        WaitCycle_ = 1;

      if (IoState_ == Mcalc_IOState::RESENDLASTSIG)
      {
        #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
          DbgPtr()->ShowMessage("IoState_ == Mcalc_IOState::RESENDLASTSIG\n");
          DbgPtr()->ShowStr(IoStateToStr(_PrevSetState), "_PrevSetState");
          DbgPtr()->ShowMessage("Bare_SetIoState(_PrevSetState)\n");
        #endif

        if (_PrevSetState && _PrevSetState != Mcalc_IOState::IDLE_STATE)
        {
          SetWriteToFileBatchLevel(true);
          Bare_SetIoState(_PrevSetState);
          _IoState = _PrevSetState;
          _ResendLastSignal = TRUE;
        }

        if (SetMaxRetries_ && FetchAttempts_ >= RETRY_READ_MAX)
          FetchAttempts_ -= RETRY_READ_MAX;
      }
      else if (!_ResendLastSignal)
      {
        if (CheckForResendCond(IoState_))
          break;
      }
    }

    if (_ResendLastSignal)
      break;

    #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
      DbgPtr()->ShowInt(_ResendLastSignal, "_ResendLastSignal");
      DbgPtr()->ShowInt(SetMaxRetries_, "SetMaxRetries_");
      DbgPtr()->ShowInt(WaitForeverForSignal(), "WaitForeverForSignal()");
      DbgPtr()->ShowInt(FetchLimit_, "FetchLimit_");
      DbgPtr()->ShowInt(FetchAttempts_, "FetchAttempts_");
      DbgPtr()->ShowStr(IoStateToStr(_IoState), "_IoState");
    #endif

    // Maximum loop iteration reached?
    MaxReached_ = SetMaxRetries_ ? (FetchAttempts_ >= FetchLimit_):false;

    // Ensure single IO state enumerated value is returned
    if (!MaxReached_ && (IoState_ & IoStates_) != 0)
      for (x = Mcalc_IOState::IOSTATE_STARTVAL;
           !SingleSel_ && x <= Mcalc_IOState::IOSTATE_ENDVAL; x *= 2)
        SingleSel_ = IoState_ == x;

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
    PollingActive_ = CalcPollingActive();
    ResumeCalcPolling();

    if (CalcPollingActive())
    {
      if (!SetMaxRetries_ && _PollClientMgr &&
          !SingleSel_ && FetchAttempts_ &&
          FetchAttempts_ % MAXBEFORECHECK == 0)
      {
        PollingAllowed_ = _PollClientMgr->ClientPollingAllowed();
        _PollClientMgr->ResetPollCount();
        _PollClientMgr->ResetPollResults(PollingClient_, PollError_, PollAnswered_);

        _PollClientMgr->SetWaitUntilResponse(true)
                      ->SetAllowClientPolling(true)
                      ->SetResetStatesOnDone(true)
                      ->SetBreakOnPollError(false)
                      ->SetExitAtRetryMax(true)
                      ->SetStopTracking(true);

        MaxReached_ = true;
        ReadIter_ = 0;
        PrevState_ = IoState_;

        while (ReadIter_ < RETRY_READ_MAX &&
               !_PollClientMgr->AtMaxPollAttempts())
        {
          UseMicroSecDelay(false);
          IoState_ = Bare_GetIoState(WaitCycle_++);
          if (WaitCycle_ > 3)
            WaitCycle_ = 1;

          if (IoState_ == Mcalc_IOState::RESENDLASTSIG &&
              _PrevSetState && _PrevSetState != Mcalc_IOState::IDLE_STATE)
          {
            SetWriteToFileBatchLevel(true);
            Bare_SetIoState(_PrevSetState);
            _IoState = _PrevSetState;
            ReadIter_ = 0;
          }

          #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
            DbgPtr()->ShowInt(ReadIter_, "ReadIter_");
            DbgPtr()->ShowStr(IoStateToStr(_IoState), "_IoState");
            DbgPtr()->ShowMessage("Bare_SetIoState(_PrevSetState)\n");
          #endif

          if ((IoState_ & IoStates_) == 0 || PrevState_ == IoState_)
          {
            SetNoPolling(false);
            _PollClientMgr->ResetClientPolling(true);
            _PollClientMgr->ResetWhenNotRequired(true)
                          ->PollClientIfAlive(1, true, false); // Initiate Polling
            _PollClientMgr->GivePollResults(PollingClient_, PollError_, PollAnswered_);
          }
          else
          {
            SingleSel_ = false;
            for (x = Mcalc_IOState::IOSTATE_STARTVAL;
                 !SingleSel_ && x <= Mcalc_IOState::IOSTATE_ENDVAL; x *= 2)
              SingleSel_ = IoState_ == x;

            if (!SingleSel_)
            {
              ReadIter_++;
              PrevState_ = IoState_;
            }
          }

          if (SingleSel_ || PollAnswered_)
          {
            FetchAttempts_ = 0;
            MaxReached_ = false;
            _PollClientMgr->SetAllowClientPolling(PollingAllowed_);

            break;
          }
        }
      }
    }

    if (!PollingActive_)
      PauseCalcPolling();
    #endif

    if (!SingleSel_ && MaxReached_ && WaitForeverForSignal())
    {
      FetchAttempts_ = 0;
      MaxReached_ = false;

      UseMicroSecDelay(false);
      IoState_ = Bare_GetIoState(3);
      FetchAttempts_++;
      WaitCycle_ = 1;

      if (IoState_ == Mcalc_IOState::RESENDLASTSIG)
      {
        #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
          DbgPtr()->ShowMessage("IoState_ == Mcalc_IOState::RESENDLASTSIG\n");
          DbgPtr()->ShowStr(IoStateToStr(_PrevSetState), "_PrevSetState");
          DbgPtr()->ShowMessage("Bare_SetIoState(_PrevSetState)\n");
        #endif

        if (_PrevSetState && _PrevSetState != Mcalc_IOState::IDLE_STATE)
        {
          SetWriteToFileBatchLevel(true);
          Bare_SetIoState(_PrevSetState);
          _IoState = _PrevSetState;
          _ResendLastSignal = TRUE;
        }
      }
      else if (!_ResendLastSignal)
      {
        if (CheckForResendCond(IoState_))
          break;
      }
    }
    else if (!_ResendLastSignal)
    {
      if (CheckForResendCond(IoState_))
        break;
    }
  }
  while (!SingleSel_ && !MaxReached_ && !_ResendLastSignal);

  if (SingleSel_)
    SetIoStateForced(false);

  if (_ResendLastSignal)
  {
    #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
      DbgPtr()->ShowMessage("_ResendLastSignal == TRUE\n");
      DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
      DbgPtr()->LeaveLevel();
    #endif

    return IoState_;
  }

  #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
  PollingActive_ = CalcPollingActive();
  ResumeCalcPolling();

  if (CalcPollingActive())
  {
    if (SetMaxRetries_ && !SingleSel_ &&
        _PollClientMgr && MaxRetries_ && MaxReached_)
    {
      PollingAllowed_ = _PollClientMgr->ClientPollingAllowed();
      _PollClientMgr->ResetPollCount();
      _PollClientMgr->ResetPollResults(PollingClient_, PollError_, PollAnswered_);
      _PollClientMgr->SetWaitUntilResponse(true)
                    ->SetAllowClientPolling(true)
                    ->SetResetStatesOnDone(true)
                    ->SetBreakOnPollError(false)
                    ->SetStopTracking(true);

      ReadIter_ = 0;
      PrevState_ = IoState_;

      while (ReadIter_ < RETRY_READ_MAX &&
             !_PollClientMgr->AtMaxPollAttempts())
      {
        UseMicroSecDelay(false);
        IoState_ = Bare_GetIoState(WaitCycle_++);
        if (WaitCycle_ > 3)
          WaitCycle_ = 1;

        if (IoState_ == Mcalc_IOState::RESENDLASTSIG &&
            _PrevSetState && _PrevSetState != Mcalc_IOState::IDLE_STATE)
        {
          SetWriteToFileBatchLevel(true);
          Bare_SetIoState(_PrevSetState);
          _IoState = _PrevSetState;
          ReadIter_ = 0;
        }

        #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
          DbgPtr()->ShowInt(ReadIter_, "ReadIter_");
          DbgPtr()->ShowStr(IoStateToStr(_IoState), "_IoState");
          DbgPtr()->ShowMessage("Bare_SetIoState(_PrevSetState)\n");
        #endif

        if ((IoState_ & IoStates_) == 0 || PrevState_ == IoState_)
        {
          SetNoPolling(false);
          _PollClientMgr->ResetClientPolling(true);
          _PollClientMgr->ResetWhenNotRequired(true)
                        ->PollClientIfAlive(1, true, false); // Initiate Polling
          _PollClientMgr->GivePollResults(PollingClient_, PollError_, PollAnswered_);
        }
        else
        {
          SingleSel_ = false;
          for (x = Mcalc_IOState::IOSTATE_STARTVAL;
               !SingleSel_ && x <= Mcalc_IOState::IOSTATE_ENDVAL; x *= 2)
            SingleSel_ = IoState_ == x;

          if (!SingleSel_)
          {
            ReadIter_++;
            PrevState_ = IoState_;
          }
        }

        if (SingleSel_ || PollAnswered_ || PollError_)
        {
          MaxReached_ = PollError_;
          _PollClientMgr->SetAllowClientPolling(PollingAllowed_);

          break;
        }
      }
    }
  }

  if (!PollingActive_)
    PauseCalcPolling();
  #endif

  if (FetchLimitReached_)
    *FetchLimitReached_ = MaxReached_;

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
    DbgPtr()->ShowInt(_IoStatePtr!=NULL, "_IoStatePtr!=NULL");
    DbgPtr()->ShowInt(MaxReached_, "MaxReached_");
    DbgPtr()->ShowStr(IoStateToStr(_IoState), "_IoState");
  #endif

  if (!_ResendLastSignal)
    IoState_ = Bare_GetIoState(0);

  if (IoState_ == Mcalc_IOState::RESENDLASTSIG)
  {
    #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
      DbgPtr()->ShowMessage("IoState_ == Mcalc_IOState::RESENDLASTSIG\n");
      DbgPtr()->ShowStr(IoStateToStr(_PrevSetState), "_PrevSetState");

      DbgPtr()->ShowMessage("_ResendLastSignal == TRUE\n");
      DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
      if (!_ResendLastSignal)
        DbgPtr()->ShowMessage("Bare_GetIoState(0)\n");
      DbgPtr()->ShowMessage("Bare_SetIoState(_PrevSetState)\n");
      DbgPtr()->LeaveLevel();
    #endif

    if (_PrevSetState && _PrevSetState != Mcalc_IOState::IDLE_STATE)
    {
      SetWriteToFileBatchLevel(true);
      Bare_SetIoState(_PrevSetState);
      _IoState = _PrevSetState;
      _ResendLastSignal = TRUE;
    }

    return IoState_;
  }
  else
  {
    if (!_ResendLastSignal)
      CheckForResendCond(IoState_);

    if (_ResendLastSignal)
    {
      #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
        DbgPtr()->ShowMessage("_ResendLastSignal == TRUE\n");
        DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
        if (!_ResendLastSignal)
          DbgPtr()->ShowMessage("Bare_GetIoState(0)\n");
        DbgPtr()->LeaveLevel();
      #endif

      return IoState_;
    }
  }

  if (WaitForeverForSignal())
    SetWaitForeverForSignal(false);

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
    DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
    DbgPtr()->ShowStr(IoStateToStr(InitState_), "InitState_");
    DbgPtr()->ShowInt(IoState_!=InitState_, "IoState_ != InitState_");
    if (IoState_ != InitState_)
      DbgPtr()->ShowMessage("SetIoState(IoState_, true, 0, false)\n");
    DbgPtr()->ShowMessage("IoState_ = GetIoState(0)\n");
  #endif

  // Set new iostate value if not set and update calc. state
  if (IoState_ != InitState_)
  {
    SetSessionOptionOverride(SesOptOverride_);
    SetIoState(IoState_, true, 0, false);
    IoState_ = Bare_GetIoState(0);
  }
  else
  {
    SetSessionOptionOverride(SesOptOverride_);
    IoState_ = GetIoState(0);
  }

  if ((InitState_ == IoState_ &&
       (InitState_ == Mcalc_IOState::INPUT_RECEIVED ||
        InitState_ == Mcalc_IOState::OUTPUT_FETCHED ||
        InitState_ == Mcalc_IOState::PROCESS_DONE_ACK ||
        InitState_ == Mcalc_IOState::PROCESS)) ||
      (InitState_ == Mcalc_IOState::INPUT_REQUIRED &&
       IoState_ == Mcalc_IOState::INPUT_RECEIVED) ||
      (InitState_ == Mcalc_IOState::OUTPUT_READY &&
       IoState_ == Mcalc_IOState::OUTPUT_FETCHED) ||
      (InitState_ == Mcalc_IOState::OUTPUT_FETCHED &&
       IoState_ == Mcalc_IOState::OUTPUT_READY) ||
      (InitState_ == Mcalc_IOState::CALC_RESPONSE &&
       IoState_ == Mcalc_IOState::PROCESS) ||
      (InitState_ == Mcalc_IOState::PROCESS &&
       IoState_ == Mcalc_IOState::PROCESS_DONE) ||
      (InitState_ == Mcalc_IOState::PROCESS_DONE &&
       IoState_ == Mcalc_IOState::PROCESS_DONE_ACK) ||
      (InitState_ == Mcalc_IOState::PROCESS_DONE_ACK &&
       IoState_ == Mcalc_IOState::PROCESS_DONE))
    ClearOutputToSignal();

  #if ((!(CALCLIB_TESTASYNCMODE2c))&&(CALCLIB_DEBUG13c))
    sprintf(_PromptBuffer, CALCGUIPROMPT_NOINPUT,
            IoStateToStr(_PrevSetState), IoStateToStr(_IoState));
    DisplayToLog(_PromptBuffer);
  #endif

  #if ((CALCLIB_DEBUG11a)|(CALCLIB_DEBUG12b)|(CALCLIB_DEBUG12c))
    if (DbgPtr(false))
    {
      #if CALCLIB_TESTASYNCMODE2c
        DbgPtr()->ShowStr(_Mockcio->InputStrWritten().c_str(), "InputStrWritten");
      #endif

      DbgPtr()->ShowStr(IoStateToStr(IoState_), "IoState_");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientTimeoutAck(int CurState_,
                                            bool* FetchLimitReached_, bool* OverDuration_)
{
  if (!InAsyncMode() && !SessionOptionOverride())
    return 0;

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientTimeoutAck");
  #endif

  int TimeoutState_ = 0;
  int AckState_ = Mcalc_ElapsedTime::ACKNOWLEDGED;
  int FetchAttempts_ = 0;
  int FetchLimit_ = RETRY_READ_MAX;
  int InitState_ = GetCalcTimeoutState(0, "CalculatorBase::WaitForClientTimeoutAck");

  bool MaxReached_ = false;
  bool SingleSel_ = false;

  clock_t Begin_;
  clock_t End_;
  double ElapsedSecs_ = 0;
  double ElapsedOverLimit_ = CALC_TIMEOUT_DURATION + 1;

  FetchAttempts_ = 0;
  TimeoutState_ = CurState_;

  #if CALCLIB_DEBUG12d
    ChrString TimeoutStateStr_ = "Mcalc_ElapsedTime::ACKNOWLEDGED";
    DbgPtr()->ShowStr(TimeoutStateStr_.c_str(), "AckState_");
  #endif

  #if ((CALCLIB_TESTASYNCMODE2c)|(CALCLIB_TESTASYNCMODE))
    if (AckState_ != Mcalc_ElapsedTime::ACKNOWLEDGED)
      SetCalcTimeoutState(Mcalc_ElapsedTime::ACKNOWLEDGED,
                          "CalculatorBase::WaitForClientTimeoutAck");
  #endif

  Begin_ = clock();

  do
  {
    while ((FetchAttempts_ < FetchLimit_ ||
            ElapsedSecs_ < ElapsedOverLimit_) &&
           TimeoutState_ != AckState_)
    {
      TimeoutState_ = GetCalcTimeoutState(0, "CalculatorBase::WaitForClientTimeoutAck");
      FetchAttempts_++;

      End_ = clock();
      ElapsedSecs_ = double(End_ - Begin_) / CLOCKS_PER_SEC;
    }

    #if CALCLIB_DEBUG12d
      DbgPtr()->ShowInt(FetchLimit_, "FetchLimit_");
      DbgPtr()->ShowInt(FetchAttempts_, "FetchAttempts_");
      DbgPtr()->ShowFloat(ElapsedSecs_, "ElapsedSecs_");
      DbgPtr()->ShowStr(TimeoutStateToStr(_TimeoutState), "_TimeoutState");
    #endif

    // Maximum loop iteration reached?
    MaxReached_ = FetchAttempts_ >= FetchLimit_ &&
                  ElapsedSecs_ >= ElapsedOverLimit_;

    if (!MaxReached_)
      SingleSel_ = TimeoutState_ == AckState_;
  }
  while (!SingleSel_ && !MaxReached_);

  if (FetchLimitReached_)
    *FetchLimitReached_ = MaxReached_ && FetchAttempts_ >= FetchLimit_;

  if (OverDuration_)
    *OverDuration_ = MaxReached_ && ElapsedSecs_ >= ElapsedOverLimit_;

  TimeoutState_ = GetCalcTimeoutState(0, "CalculatorBase::WaitForClientTimeoutAck");

  #if CALCLIB_DEBUG12d
    DbgPtr()->ShowInt(MaxReached_, "MaxReached_");
    DbgPtr()->ShowStr(TimeoutStateToStr(TimeoutState_), "TimeoutState_");
    DbgPtr()->ShowStr(IoStateToStr(InitState_), "InitState_");
    DbgPtr()->ShowInt(TimeoutState_!=InitState_, "TimeoutState_ != InitState_");
    if (TimeoutState_ != InitState_)
      DbgPtr()->ShowMessage("SetCalcTimeoutState(TimeoutState_)\n");
    DbgPtr()->ShowMessage("TimeoutState_ = GetCalcTimeoutState(0)\n");
  #endif

  // Set new iostate value if not set and update calc. state
  if (TimeoutState_ != InitState_)
  {
    SetCalcTimeoutState(TimeoutState_,
                        "CalculatorBase::WaitForClientTimeoutAck");
    TimeoutState_ = GetCalcTimeoutState(0, "CalculatorBase::WaitForClientTimeoutAck");
  }
  else
    TimeoutState_ = GetCalcTimeoutState(0, "CalculatorBase::WaitForClientTimeoutAck");

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
    {
      DbgPtr()->ShowStr(TimeoutStateToStr(TimeoutState_), "TimeoutState_");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return TimeoutState_;
}

/****************************************************************************/
void CalculatorBase::SendClientAlive(bool flag_)
{
  _ClientProgramAlive = flag_;
}

/****************************************************************************/
void CalculatorBase::SendServerAlive(bool flag_)
{
  #if CALCLIB_TESTMOCKCLIENT
    if (DbgPtr(false))
    {
      DbgPtr()->ShowMessage("CalculatorBase::SendServerAlive()\n");
      DbgPtr()->ShowInt(flag_, "SendServerAlive() == ");
    }
  #endif
}

/****************************************************************************/
int CalculatorBase::WaitForClientStates(int CurState_, int ExtStates_, bool* FetchLimitReached_)
{
  #if ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b)|(CALCLIB_TESTASYNCMODE2c))
    bool SesOptOverride_ = SessionOptionOverride();
    Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
    int IoState_ = GetIoState(0);

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #else
    int InProgMode_ = InProgramMode(false) ? Mcalc_IOState::BREAK_PROGRAM:0;
    int IoState_ = WaitForClientIoState(CurState_,
                                        (ExtStates_ | InProgMode_ |
                                         Mcalc_IOState::CALC_HALT),
                                        true, OUTPUT_FETCH_ATTEMPT_LIMIT,
                                        FetchLimitReached_);
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientSpawnCalcStates(int CurState_, bool* FetchLimitReached_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG12c
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientSpawnCalcStates");
  #endif

  #if CALCLIB_TESTASYNCMODE2c
    bool SignalSent_ = false;
    int IoState_ = CurrentIoState();

    _Mockcio->ResetFlags();

    if (_Mockcio->ProcessClientOutputStates(CurState_, SignalSent_,
                                            Mcalc_IOState::SPAWN_NEW_MCALC,
                                            Mcalc_IOState::MCALC_SPAWNED))
    {
      if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
        Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
      else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
        Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
    }

    if (SignalSent_)
    {
      IoState_ = GetIoState(0);
      _Mockcio->UpdateClientIoState(IoState_);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #elif ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b))
    int IoState_ = GetIoState(0);

    if (IoState_ == Mcalc_IOState::SPAWN_NEW_MCALC)
    {
      Bare_SetIoState(Mcalc_IOState::MCALC_SPAWNED, true);
      IoState_ = GetIoState(0);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #else
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::MCALC_SPAWNED,
                                       FetchLimitReached_);

    if (!WaitForeverForSignal() &&
        IoState_ != Mcalc_IOState::MCALC_SPAWNED)
    {
      // Assume acknowledgement sent after too long wait period
      SetIoState(Mcalc_IOState::MCALC_SPAWNED, true, 0);
      IoState_ = Mcalc_IOState::MCALC_SPAWNED;
      SetSessionOptionOverride(SesOptOverride_);

      // Causes program freeze-up
      // if (_IoStatePtr)
      //   _IoStatePtr->SetAllDoneSpawnCalcState();
    }
  #endif

  #if CALCLIB_DEBUG12c
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForProcessAckReceived(int CurState_, bool* FetchLimitReached_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG11a
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForProcessAckReceived");
  #endif

  #if CALCLIB_TESTASYNCMODE2c
    bool SignalSent_ = false;
    int IoState_ = CurrentIoState();

    _Mockcio->ResetFlags();

    if (_Mockcio->ProcessClientOutputStates(CurState_, SignalSent_,
                                            Mcalc_IOState::PROCESS_DONE,
                                            Mcalc_IOState::PROCESS_DONE_ACK))
    {
      if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
        Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
      else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
        Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
    }

    if (SignalSent_)
    {
      IoState_ = GetIoState(0);
      _Mockcio->UpdateClientIoState(IoState_);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #elif ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b))
    int IoState_ = GetIoState(0);

    if (IoState_ == Mcalc_IOState::PROCESS_DONE)
    {
      Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      IoState_ = GetIoState(0);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #else
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::PROCESS_DONE_ACK,
                                       FetchLimitReached_);

    if (IoState_ != Mcalc_IOState::PROCESS_DONE_ACK)
    {
      // Assume acknowledgement sent after too long wait period
      SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true, 0);
      IoState_ = Mcalc_IOState::PROCESS_DONE_ACK;
      SetSessionOptionOverride(SesOptOverride_);
    }
  #endif

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForBatchFileEndedAck(int CurState_,
                                             bool* FetchLimitReached_, bool Retrying_)
{
  bool SesOptOverride_ = SessionOptionOverride();
  bool BatchLevelChanged_ = false;

  #if CALCLIB_DEBUG11a
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForBatchFileEndedAck");
  #endif

  #if CALCLIB_TESTASYNCMODE2c
    bool SignalSent_ = false;
    int IoState_ = CurrentIoState();

    _Mockcio->ResetFlags();

    if (_Mockcio->ProcessClientOutputStates(CurState_, SignalSent_,
                                            Mcalc_IOState::BATCHFILE_ENDED,
                                            Mcalc_IOState::BATCHFILE_ENDED_ACK))
    {
      if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
        Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
      else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
        Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
    }

    if (SignalSent_)
    {
      IoState_ = GetIoState(0);
      _Mockcio->UpdateClientIoState(IoState_);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);

    if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      if (_InSpawnedCalc && _BatchExecLevel > 0 && !_ResendLastSignal)
      {
        _BatchExecLevel--;
        BatchLevelChanged_ = true;
        _InSpawnedCalc = false;

        if (_BatchExecLevel &&
            !_ExecuteProgram && !ActiveProgram(NULL, 0))
          _BatchExecLevel = 0;
      }

      if (BatchLevelChanged_)
      {
        BatchLevelChanged_ = false;
        SetWriteToFileBatchLevel(true);
        Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, false);
      }
    }
  #elif ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b))
    int IoState_ = GetIoState(0);

    if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED)
    {
      SetWriteToFileBatchLevel(true);
      Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true);
      IoState_ = GetIoState(0);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);

    if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      if (_InSpawnedCalc && _BatchExecLevel > 0 && !_ResendLastSignal)
      {
        _BatchExecLevel--;
        BatchLevelChanged_ = true;
        _InSpawnedCalc = false;

        if (_BatchExecLevel &&
            !_ExecuteProgram && !ActiveProgram(NULL, 0))
          _BatchExecLevel = 0;
      }

      if (BatchLevelChanged_)
      {
        BatchLevelChanged_ = false;
        SetWriteToFileBatchLevel(true);
        Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, false);
      }
    }
  #else
    CalcProgram* ProgramPtr_;
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::BATCHFILE_ENDED_ACK,
                                       FetchLimitReached_);

    if (IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;
      else
      {
        if (_InSpawnedCalc && _BatchExecLevel > 0 && !_ResendLastSignal)
        {
          _BatchExecLevel--;
          BatchLevelChanged_ = true;
          _InSpawnedCalc = false;

          if (_BatchExecLevel &&
              !_ExecuteProgram && !ActiveProgram(NULL, 0))
            _BatchExecLevel = 0;
        }

        // Assume acknowledgement sent after too long wait period
        SetIoStateForced(!Retrying_ &&
                         BatchFileEndedSignalSent() &&
                         CurState_ == Mcalc_IOState::BATCHFILE_ENDED);

        SetWriteToFileBatchLevel(true);
        SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true, 0);
        IoState_ = Mcalc_IOState::BATCHFILE_ENDED_ACK;
        SetSessionOptionOverride(SesOptOverride_);
      }
    }
    else
    {
      if (_InSpawnedCalc && _BatchExecLevel > 0 && !_ResendLastSignal)
      {
        _BatchExecLevel--;
        BatchLevelChanged_ = true;
        _InSpawnedCalc = false;

        if (_BatchExecLevel &&
            !_ExecuteProgram && !ActiveProgram(NULL, 0))
          _BatchExecLevel = 0;
      }

      if (BatchLevelChanged_)
      {
        BatchLevelChanged_ = false;
        SetWriteToFileBatchLevel(true);
        Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, false);
      }
    }
  #endif

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientPingAck(int CurState_, bool* FetchLimitReached_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG11a
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientPingAck");
  #endif

  #if CALCLIB_TESTASYNCMODE2c
    bool SignalSent_ = false;
    int IoState_ = CurrentIoState();

    _Mockcio->ResetFlags();

    if (_Mockcio->ProcessClientOutputStates(CurState_, SignalSent_,
                                            Mcalc_IOState::CLIENTPING,
                                            Mcalc_IOState::CLIENTPING_ACK))
    {
      if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
        Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
      else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
        Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
    }

    if (SignalSent_)
    {
      IoState_ = GetIoState(0);
      _Mockcio->UpdateClientIoState(IoState_);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #elif ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b))
    int IoState_ = GetIoState(0);

    if (IoState_ == Mcalc_IOState::CLIENTPING)
    {
      Bare_SetIoState(Mcalc_IOState::CLIENTPING_ACK, true);
      IoState_ = GetIoState(0);
    }

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #else
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::CLIENTPING_ACK,
                                       FetchLimitReached_);

    if (!WaitForeverForSignal() &&
        IoState_ != Mcalc_IOState::CLIENTPING_ACK)
    {
      // assume client program is inactive or dead if wait period is too long
      SetClientIsDead(true);
      SetSessionOptionOverride(SesOptOverride_);
    }
  #endif

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientGraphWaitStates(int CurState_, bool* FetchLimitReached_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG11a
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientGraphWaitStates");
  #endif

  #if ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b)|(CALCLIB_TESTASYNCMODE2c))
    #if CALCLIB_TESTASYNCMODE1
      int IoState_ = GetIoState(0);

      if (IoState_ == Mcalc_IOState::IDLE_STATE ||
          IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
          IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
      {
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
        IoState_ = GetIoState(0);
      }
      else if (IoState_ == Mcalc_IOState::GRAPH_WAIT)
      {
        if (_GraphWaitIterNum)
        {
          Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
          IoState_ = GetIoState(0);
          _GraphWaitIterNum = 0;
        }
        else
        {
          Bare_SetIoState(Mcalc_IOState::GRAPH_WAIT_ACK, true);
          IoState_ = GetIoState(0);

          #if CALCLIB_TESTASYNCMODE1a
            _GraphWaitIterNum++;
          #elif CALCLIB_TESTASYNCMODE1b
            _GraphWaitIterNum = 0;
          #endif
        }
      }
    #else
      int IoState_ = GetIoState(0);

      if (IoState_ == Mcalc_IOState::IDLE_STATE ||
          IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
          IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
      {
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);
        IoState_ = GetIoState(0);
      }
      else if (IoState_ == Mcalc_IOState::GRAPH_WAIT)
      {
        Bare_SetIoState(Mcalc_IOState::GRAPH_WAIT_ACK, true);
        IoState_ = GetIoState(0);
      }
    #endif

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);

    if (IoState_ == Mcalc_IOState::GRAPH_WAIT_ACK)
      SetGraphOpStage(Mcalc_IOState::GRAPH_WAIT_ACK);
  #else
    int WaitForSig_ = WaitForeverForSignal() ?
                          (Mcalc_IOState::GRAPH_WAIT_ACK |
                           Mcalc_IOState::INPUT_RECEIVED):
                          Mcalc_IOState::GRAPH_WAIT_ACK;

    int IoState_ = WaitForClientStates(CurState_,
                                       WaitForSig_,
                                       FetchLimitReached_);

    if (IoState_ != Mcalc_IOState::GRAPH_WAIT_ACK &&
        IoState_ != Mcalc_IOState::INPUT_RECEIVED)
    {
      if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;
      else
      {
        // Assume acknowledgement sent after too long wait period
        if (InPausedBatchFile(true) && QuitGraph())
        {
          SetIoState(Mcalc_IOState::INPUT_RECEIVED, true, 0);
          IoState_ = Mcalc_IOState::INPUT_RECEIVED;
        }
        else
        {
          SetIoState(Mcalc_IOState::GRAPH_WAIT_ACK, true, 0);
          IoState_ = Mcalc_IOState::GRAPH_WAIT_ACK;
        }

        SetSessionOptionOverride(SesOptOverride_);

        // Causes program freeze-up
        // if (_IoStatePtr)
        //   _IoStatePtr->SetAllDoneGraphWaitState();
      }
    }

    if (!QuitGraph() &&
        IoState_ == Mcalc_IOState::GRAPH_WAIT_ACK)
      SetGraphOpStage(Mcalc_IOState::GRAPH_WAIT_ACK);
    else if (QuitGraph() && !_ResendLastSignal)
      SetGraphOpStage(0);
  #endif

  #if CALCLIB_DEBUG11a
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientGraphProgressStates(int CurState_, bool* FetchLimitReached_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG11c
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientGraphProgressStates");
  #endif

  #if ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b)|(CALCLIB_TESTASYNCMODE2c))
    Bare_SetIoState(Mcalc_IOState::GRAPH_PROGRESS_ACK, true);
    int IoState_ = GetIoState(0);

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);

    if (IoState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK)
      SetGraphOpStage(Mcalc_IOState::GRAPH_PROGRESS_ACK);
  #else
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::GRAPH_PROGRESS_ACK,
                                       FetchLimitReached_);

    if (IoState_ != Mcalc_IOState::GRAPH_PROGRESS_ACK)
    {
      if (WaitForeverForSignal())
        _ResendLastSignal = TRUE;
      else
      {
        // Assume acknowledgement sent after too long wait period
        SetIoState(Mcalc_IOState::GRAPH_PROGRESS_ACK, true, 0);
        IoState_ = Mcalc_IOState::GRAPH_PROGRESS_ACK;
        SetSessionOptionOverride(SesOptOverride_);

        if (GraphSizeAmount())
        {
          SetGraphProgFileSent(false);

          if (GraphProgressAmount())
          {
            SetGraphProgFileUpdatePending(false);
            SetGraphProgFileUpdateDone(false);
          }
          else
          {
            SetGraphProgFileResetPending(false);
            SetGraphProgFileResetDone(false);
          }

          // Causes program freeze-up
          // if (_IoStatePtr)
          //   _IoStatePtr->SetAllDoneGraphProgressState();
        }
      }
    }

    if (!QuitGraph() &&
        IoState_ == Mcalc_IOState::GRAPH_PROGRESS_ACK)
      SetGraphOpStage(Mcalc_IOState::GRAPH_PROGRESS_ACK);
    else if (QuitGraph() && !_ResendLastSignal)
      SetGraphOpStage(0);
  #endif

  #if CALCLIB_DEBUG11c
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientInFileProgressStates(int CurState_,
                                                      bool* FetchLimitReached_, bool Retrying_)
{
  bool SesOptOverride_ = SessionOptionOverride();

  #if CALCLIB_DEBUG12b
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientInFileProgressStates");
  #endif

  #if ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b)|(CALCLIB_TESTASYNCMODE2c))
    Bare_SetIoState(Mcalc_IOState::INFILE_PROGRESS_ACK, true);
    int IoState_ = GetIoState(0);

    // Set new iostate value if not set and update calc. state
    SetIoState(IoState_, true, 0, false);
    SetSessionOptionOverride(SesOptOverride_);
  #else
    int IoState_ = WaitForClientStates(CurState_,
                                       Mcalc_IOState::PROCESS |
                                       Mcalc_IOState::INFILE_PROGRESS_ACK,
                                       FetchLimitReached_);

    if (IoState_ != Mcalc_IOState::PROCESS &&
        IoState_ != Mcalc_IOState::INFILE_PROGRESS_ACK)
    {
      // Assume acknowledgement sent after too long wait period
      SetIoStateForced(!Retrying_ &&
                       CurState_ == Mcalc_IOState::PROGRESS_READY);

      SetIoState(Mcalc_IOState::INFILE_PROGRESS_ACK, true, 0);
      IoState_ = Mcalc_IOState::INFILE_PROGRESS_ACK;
      SetSessionOptionOverride(SesOptOverride_);

      if (InFileSizeAmount())
      {
        SetCalcProgFileSent(false);

        if (InFileProgressAmount())
        {
          SetCalcProgFileUpdatePending(false);
          SetCalcProgFileUpdateDone(false);
        }
        else
        {
          SetCalcProgFileResetPending(false);
          SetCalcProgFileResetDone(false);
        }

        // Causes program freeze-up
        // if (_IoStatePtr)
        //   _IoStatePtr->SetAllDoneCalcProgressState();
      }
    }
  #endif

  #if CALCLIB_DEBUG12b
    if (DbgPtr(false))
    {
      StateStr_ = GiveIoStateStr(IoState_);
      DbgPtr()->ShowStr(StateStr_.c_str(), "IoState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return IoState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientElapsedTimeAck(int CurState_,
                                                bool* FetchLimitReached_, bool* OverDuration_)
{
  int TimeoutState_ = 0;

  #if CALCLIB_DEBUG12d
    ChrString StateStr_;
    if (DbgPtr(false))
      DbgPtr()->EnterLevel("WaitForClientElapsedTimeAck");
  #endif

  #if ((CALCLIB_TESTASYNCMODE)|(CALCLIB_TESTASYNCMODE2b)|(CALCLIB_TESTASYNCMODE2c))
    SetCalcTimeoutState(Mcalc_ElapsedTime::ACKNOWLEDGED,
                        "CalculatorBase::WaitForClientElapsedTimeAck");
  #else
    TimeoutState_ = WaitForClientTimeoutAck(CurState_,
                                            FetchLimitReached_, OverDuration_);

    // Assume acknowledgement sent after too long wait period
    if (TimeoutState_ != Mcalc_ElapsedTime::ACKNOWLEDGED &&
        ((FetchLimitReached_ && *FetchLimitReached_) ||
         (OverDuration_ && *OverDuration_)))
      SetCalcTimeoutState(Mcalc_ElapsedTime::ACKNOWLEDGED,
                          "CalculatorBase::WaitForClientElapsedTimeAck");
  #endif

  #if CALCLIB_DEBUG12d
    if (DbgPtr(false))
    {
      StateStr_ = GiveTimeoutStateStr(_TimeoutState);
      DbgPtr()->ShowStr(StateStr_.c_str(), "TimeoutState");
      DbgPtr()->LeaveLevel();
    }
  #endif

  return TimeoutState_;
}

/****************************************************************************/
int CalculatorBase::WaitForClientProcessStates(int CurState_, bool* FetchLimitReached_)
{
  // IDLE_STATE          --> PROCESS
  // CALC_RESPONSE       --> PROCESS
  //   CALC_RESPONSE     --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // INPUT_RECEIVED      --> PROCESS
  // OUTPUT_FETCHED      --> PROCESS
  // CALC_ERROR          --> PROCESS
  //   CALC_ERROR        --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // ERROR_FETCH         --> PROCESS
  //   ERROR_FETCH       --> INPUT_RECEIVED|PROCESS (if In Batch File)
  // BREAK_PROGRAM       --> PROCESS
  // BATCHFILE_ENDED_ACK --> PROCESS
  // PROCESS_DONE        --> PROCESS_DONE_ACK

  // if In Batch File:
  //   INPUT_RECEIVED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   OUTPUT_FETCHED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE