#ifndef CALCLIB_H
#define CALCLIB_H
/****************************************************************************/
/* standard libraries */
#ifndef INCL_STDIO_H
  #include <stdio.h>
  #define INCL_STDIO_H
#endif
#ifndef INCL_STRING_H
  #include <string.h>
  #define INCL_STRING_H
#endif
#ifndef INCL_CTYPE_H
  #include <ctype.h>
  #define INCL_CTYPE_H
#endif
#ifndef INCL_ASSERT_H
  #include <assert.h>
  #define INCL_ASSERT_H
#endif
#ifndef INCL_STDLIB_H
  #include <stdlib.h>
  #define INCL_STDLIB_H
#endif
#ifndef INCL_MATH_H
  #include <math.h>
  #define INCL_MATH_H
#endif
#ifndef INCL_ERRNO_H
  #include <errno.h>
  #define INCL_ERRNO_H
#endif
#ifndef INCL_TIME_H
  #include <time.h>
  #define INCL_TIME_H
#endif
#if defined(__DJGPP__) | defined(__GNUC__)
  #ifndef INCL_UNISTD_H
    #include <unistd.h>
    #define INCL_UNISTD_H
  #endif
#endif
#if (!defined(__DJGPP__) & !defined(__linux__) & !defined(__unix__) & !defined(__GNUC__))
  #include <Windows.h>
#endif

/* Custom libraries */
// ../cppds-4.2/source/
#ifndef TYPEDEFS_H
  #include "typedefs.h"
#endif
#ifndef CHRSTRING_H
  #include "chrstring.h"
#endif
#ifndef LONGNUM_H
  #include "longnum.h"
#endif
#ifndef DISCRETE_CPP
  #include "discrete.cpp"
#endif
#ifndef RANDOMIZER_H
  #include "randomizer.h"
#endif
#ifndef BITSTR_H
  #include "bitstr.h"
#endif
#ifndef CALCHELPMSG_H
  #include "calchelpmsg.h"
#endif
#ifndef SET_CPP
  #include "set.cpp"
#endif
#ifndef STATARRAY_CPP
  #include "statarray.cpp"
#endif
#ifndef GAUSS_H
  #include "gauss.h"
#endif
#ifndef FILEREADER_H
  #include "filereader.h"
#endif
#ifndef POINTERSTACK_H
  #include "pointerstack.h"
#endif
#ifndef SPAWN_H
  #include "spawn.h"
#endif
#ifndef BITVECTOR_H
  #include "bitvect.h"
#endif
#ifndef EXECPRGNAME_H
  #include "execprgname.h"
#endif
#ifndef EXPRSTRINGSTACK_H
  #include "exprstringstack.h"
#endif

#define CALCLIB_WINVER     0
#define CALCLIB_LINUXVER   1
#define CALCLIB_WIN64VER   0
#define CALCLIB_WIN64TEST  0
#if ((CALCLIB_WIN64VER)&(!(CALCLIB_WIN64TEST)))
  #define __DJGPP__
  #include <windows.h>
#endif

#define DISCONTDETECT_DEBUGGING      0
#define DISCONTDETECT_DEBUG1         0
#define DISCONTDETECT_ARRAYMOVE      1
#define DISCONTDETECT_SHOWDEBUGINFO  0
#define DISCONTDETECT_SHOWDEBUGINFO2 0

#define DISCONTDETECT_TESTNOTIFIERS      1
#define DISCONTDETECT_USE_CALCBASE_CLASS 0

#define CALC_DISCONTINUITY_PTGAP      80   // Size limit of discontinuity between points on a graph before it
                                           // is considered a discontinuity between infinite points.
#define CALC_DISCONTINUITY_STRIKES    4    // Limit to point strikes after an infinite point following a trend
                                           // before it could be considered an infinite point between a discontinuity
#define CALC_INFPTSDISPLACEMARGIN     6    // displacement difference margin between + and - infinity points

// Process input data files internally without spawning external mcalc process
#define PROCESS_INPUTFILES_INTERNALLY       0

// use newly created subexpression entry on subexpression stack for loaded programs
#define USE_NEW_SUBEXPR_FOR_PROGRAMS        1
#define USE_EVALPRGEXPR_FOR_PROGRAMS        0

// use delayed memory deletion memory manager instead of deleting char* data immediately
#define USE_DELAYED_MEM_DELETE              1
#define USE_DELAYED_MEM_INPROGRAMS          0

// use temporary data storage members when giving out char* string data instead
// of returning the actual char* pointer data member to the calling method.
#define DECLARE_MUTABLE_TEMPORARY_MEMBERS   1
#define USE_MUTABLE_TEMPORARY_MEMBERS       1

#define CALCLIB_DEBUG1     0
#define CALCLIB_DEBUG2     0
#define CALCLIB_DEBUG3     0
#define CALCLIB_DEBUG5     0
#define CALCLIB_DEBUG6     0
#define CALCLIB_DEBUG7     0
#define CALCLIB_DEBUG8     0
#define CALCLIB_DEBUG8a    0
#define CALCLIB_DEBUG8b    0    // Error state tracking
#define CALCLIB_DEBUG8c    0    // Calculator output states tracking
#define CALCLIB_DEBUG9     0    // test client/server polling
#define CALCLIB_DEBUG9p    0    // do client/server simulation polling
#define CALCLIB_DEBUGGING  0

#define CALCLIB_DEBUG10         0  // allow conditional stoppage of method
                                   // tracking in ClientPollingMgr class
#define CALCLIB_DEBUG11a        0  // Graph trace graph operation execution
#define CALCLIB_DEBUG11b        0  // Graph signal sending/receiving tracking
#define CALCLIB_DEBUG11c        0  // Graph progress signal sending/receiving
#define CALCLIB_DEBUG11d        0  // trace graph quit calc. state variables
#define CALCLIB_DEBUG12         0  // trace execution for input batch file methods
#define CALCLIB_DEBUG12b        0  // trace execution of calc progress states
#define CALCLIB_DEBUG12c        0  // trace execution of other calc. signals
#define CALCLIB_DEBUG12d        0  // trace execution of elapsed timer signals

#define CALCLIB_TESTASYNCNOWAIT 0  // No waiting for return client signals
#define CALCLIB_TESTASYNCMODE   0  // test asynchronous operation mode
                                   // by setting mock i/o states
#define CALCLIB_TESTASYNCMODE1  0  // test quit graph plotting in pause mode
#define CALCLIB_TESTASYNCMODE1a 0  // set 2nd iteration of graph plotting to quit
#define CALCLIB_TESTASYNCMODE1b 0  // set 2nd iteration of graph plotting to continue
#define CALCLIB_TESTASYNCMODE2  0  // test spawn calc by simulating new argline input
#define CALCLIB_TESTASYNCMODE2b 0  // simulate signal response for calc. argline input mode
#define CALCLIB_TESTASYNCMODE2c 0  // Simulate file input processing while in command line
                                   // mode by calling FileInput in the ProcessCmdLine method
#define CALCLIB_DEBUG13c        0  // Record calc. signals in log file while in GUI mode
                                   // Same as CALCLIB_TESTASNYNMODE2c, but in real GUI not MockClientConIO

#define CALCLIB_TESTMOCKCLIENT  0  // test mock client class
#define CALCLIB_ERROR_SHOWTEXT  0  // output text in std streams for errors

#ifndef DEBUGUTILS_H
  #include "debugutils.h"
#endif

#if CALCLIB_TESTMOCKCLIENT
  #ifndef MOCKCLIENT_H
    #include "mockclient.h"
  #endif
#endif

#if CALCLIB_DEBUGGING
  #undef IN_DEBUGGING_MODE
  #define IN_DEBUGGING_MODE    1
  #include "debugmacros.h"
#else
  #undef IN_DEBUGGING_MODE
  #define IN_DEBUGGING_MODE    0
#endif

/* Some useful constants.  */
#define M_E_STRING              "2.7182818284590452354"     // e
#define M_LOG2E_STRING          "1.4426950408889634074"     // log_2 e
#define M_LOG10E_STRING         "0.43429448190325182765"    // log_10 e
#define M_LN2_STRING            "0.69314718055994530942"    // log_e 2
#define M_LN10_STRING           "2.30258509299404568402"    // log_e 10
#define M_PI_STRING             "3.14159265358979323846"    // pi
#define M_PI_2_STRING           "1.57079632679489661923"    // pi/2
#define M_PI_4_STRING           "0.78539816339744830962"    // pi/4
#define M_1_PI_STRING           "0.31830988618379067154"    // 1/pi
#define M_2_PI_STRING           "0.63661977236758134308"    // 2/pi
#define M_2_SQRTPI_STRING       "1.12837916709551257390"    // 2/sqrt(pi)
#define M_SQRT2_STRING          "1.41421356237309504880"    // sqrt(2)
#define M_SQRT1_2_STRING        "0.70710678118654752440"    // 1/sqrt(2)

/* The above constants are not adequate for computation using `long double's.
   Therefore we provide as an extension constants with similar names as a
   GNU extension.  Provide enough digits for the 128-bit IEEE quad.  */
#define M_El_STRING             "2.7182818284590452353602874713526625"  // e
#define M_LOG2El_STRING         "1.4426950408889634073599246810018922"  // log_2 e
#define M_LOG10El_STRING        "0.4342944819032518276511289189166051"  // log_10 e
#define M_LN2l_STRING           "0.6931471805599453094172321214581766"  // log_e 2
#define M_LN10l_STRING          "2.3025850929940456840179914546843642"  // log_e 10
#define M_PIl_STRING            "3.1415926535897932384626433832795029"  // pi
#define M_PI_2l_STRING          "1.5707963267948966192313216916397514"  // pi/2
#define M_PI_4l_STRING          "0.7853981633974483096156608458198757"  // pi/4
#define M_1_PIl_STRING          "0.3183098861837906715377675267450287"  // 1/pi
#define M_2_PIl_STRING          "0.6366197723675813430755350534900574"  // 2/pi
#define M_2_SQRTPIl_STRING      "1.1283791670955125738961589031215452"  // 2/sqrt(pi)
#define M_SQRT2l_STRING         "1.4142135623730950488016887242096981"  // sqrt(2)
#define M_SQRT1_2l_STRING       "0.7071067811865475244008443621048490"  // 1/sqrt(2)

/* Program Constants */
#define MAXARGS     4     // maximum number of arguments allowable
#define MAXFILES    18    // maximum number of files allowable
#define MAXOPERANDS 2     // maximum number of operands allowable
#define MAXLINE     256   // maximum number of characters per line
#define MAXHISTORY  51    // maximum number of command history list entries

#if USE_DELAYED_MEM_DELETE
  #if USE_DELAYED_MEM_INPROGRAMS
    #define STOREMEM InProgramMode() && !ExecInputFileData()
  #else
    #define STOREMEM true
  #endif
#else
  #define STOREMEM false
#endif

#if CALCLIB_WINVER
  #define USE_STDIO_ONLY          0   // use standard IO functions only
  #define USE_OLDVERSION_WINLINE  0   // use old version of winline class
#elif CALCLIB_LINUXVER
  #define USE_STDIO_ONLY          1   // use standard IO functions only
  #define USE_OLDVERSION_WINLINE  1   // use old version of winline class
#elif CALCLIB_WIN64VER
  #define USE_STDIO_ONLY          1   // use standard IO functions only
  #define USE_OLDVERSION_WINLINE  1   // use old version of winline class
#endif

#define AMPERSAND_CHR             '&'
#define AMPERSAND_SCHR            "&amp;"
#define AMPERSAND_NCHR            "&#38;"
#define SEMICOLON_CHR             ';'
#define SEMICOLON_SCHR            "&sc;"
#define SEMICOLON_NCHR            "&#59;"
#define NUMBERSIGN_CHR            '#'
#define NUMBERSIGN_SCHR           "&hash;"
#define NUMBERSIGN_NCHR           "&#35;"
#define COLON_CHR                 ':'
#define COLON_SCHR                "&col;"
#define COLON_NCHR                "&#58;"
#define EQUAL_CHR                 '='
#define EQUAL_SCHR                "&eq;"
#define EQUAL_NCHR                "&#61;"

#define SPECCHARS_STARTCHAR       '&'  // special escaped characters starting char
#define SPECCHARS_TERMCHAR        ';'  // special escaped characters terminator char
#define CMDHISTENTRY_SEPCHAR      ':'  // command history entry indexvalue/statement separator char
#define MATHSTATEMENT_TERMCHAR    ';'  // math statement termination char for text file data input
#define CALCPROGRAMCMD_TERMCHAR   ':'  // calculator program command terminator char
#define CALCCOMMENTLINE_STARTCHAR '#'  // calculator comment line start char
#define SPECCHARS_NUMFORMSTART    '#'  // special escaped characters number format startng char

#define CONIO_XPOS_DEFAULT 18 // default xpos of prompt box in console IO
#define CONIO_INPUT_LENGTH 60 // prompt box character length in console IO
#define CONIO_WIN_MAX_XLEN 80 // maximum text window length in console IO
#define CONIO_WIN_MAX_YLEN 2  // maximum text window height in console IO

#define LIMIT_READ_RETRIES            0    // limit file read retry attempts of the I/O state file (5 is good)
#define IMPLEMENT_KEEP_ALIVE          0    // implement client polling for keep alive state
#define IDLE_RESPONSE_ONLY_POLL       0    // implement client polling for only idle time client response
#define SENDPROGESS_TOGUIOUTPUT       0    // send progress data to gui output file
#define RETRY_READ_MAX                5    // retry attempts to contact server/client before giving up
#define IOSTATE_PRE_SET_DELAY         0    // delay before setting I/O state value into IoState file
#define IOSTATE_POST_SET_DELAY        0    // delay after setting I/O state value into IoState file
#define IOSTATE_DELAY_LENGTH          200  // delay length in milliseconds or /100 if using MicroSec delay
#define MILLI_DELAY_MULT              1    // delay length multiplier for millisec sleep
#define MICRO_DELAY_MULT              1000 // delay length multiplier for microsec sleep
#define CALC_TIMEOUT_WARNING          20   // send calculator timeout warning at x seconds
#define CALC_TIMEOUT_DURATION         3    // calc. timeout warning message duration at x seconds

#define OUTPUTFILE_SWITCH             "-o"  // input file switch for specifying an input file
#define INPUTFILE_SWITCH              "-i"  // output file switch for specifying an output file
#define SESSIONNUM_SWITCH             "-sn" // session number switch for specifying session number file suffix

/* External Mcalc Spawn environment string */
#define SPAWN_MCALC_DJGPP_PATHSTR \
        "PATH=$PATH;.;\"c:\\program files\\Cybernadian\\Qmcalc\";c:\\djgpp\\bin;c:\\windows\\system32"
#define SPAWN_MCALC_DJGPP_DJGPPENVSTR \
        "DJGPP=c:\\djgpp\\djgpp.env"
#define SPAWN_MCALC_LINUX_PATHSTR \
        "PATH=${PATH}:.:/usr/local/bin/qmcalc-2"

/* Function Validity Checker: error string constants */
#define FVC_ERRMSG_INVALID_FUNCTIONS        "Error: Invalid Functions Found"
#define FVC_ERRMSG_INVALID_VARIABLES        "Error: Invalid Variables Found"
#define FVC_ERRMSG_MISSING_RIGHT_BRACKET    "Error: Missing Right Bracket"
#define FVC_ERRMSG_MISSING_LEFT_BRACKET     "Error: Missing Left Bracket"
#define FVC_ERRMSG_FRACTION_OP_EXPECTED     "Error: Fraction Operator Expected"
#define FVC_ERRMSG_MISSING_RIGHT_BRACE      "Error: Missing Right Brace"
#define FVC_ERRMSG_MISSING_CLOSING_QUOTE    "Error: Missing Closing Quote"
#define FVC_ERRMSG_MISSING_REQUIRED_OPERAND "Error: Required Operand Missing"
#define FVC_ERRMSG_INVALID_EXPRESSION       "Error: Invalid Expression Found"

/* Message Constants */
#define ERRMSG_MULLERS_METHOD_FAILED       "ERROR: Root solving algorithm failed to converge for solution to: %s\n"
#define ERRMSG_ARGLIST_SIZE                "INVALID: Incorrect value for argument list size specifier in function: %s\n"
#define ERRMSG_INVALID_NUMARGS             "INVALID: invalid number of arguments for function: %s\n"
#define ERRMSG_INVALID_TYPEARGS            "INVALID: invalid type of arguments for function: %s\n"
#define ERRMSG_MISSLEFT_BRACKET            "INVALID: missing left bracket: %s\n"
#define ERRMSG_MISSRIGHT_BRACKET           "INVALID: missing right bracket: %s\n"
#define ERRMSG_INVALID_SYMBOLS             "INVALID: unrecognized math symbols: %s\n"
#define ERRMSG_INVALID_ASSIGNMENT          "INVALID: invalid assignment operation: %s\n" \
                                           "use $A to $Z storage variables for assignments.\n" \
                                           "If you want to test for equality use the" \
                                           " \'==\' symbol instead.\n"
#define ERRMSG_INVALID_EXPR                "INVALID: invalid expression: %s\n"
#define ERRMSG_MISPLACED_COMMA             "INVALID: misplaced comma: %s\n"
#define ERRMSG_MEMORY_FAIL                 "ERROR: memory allocation error\n"
#define ERRMSG_DIVISION_BY_ZERO            "INVALID: division by zero: %s\n"
#define ERRMSG_FILE_ERROR                  "ERROR: could not open file \"%s\" for %s\n"
#define ERRMSG_OPENSTATEFILE               "ERROR: Cannot open I/O state file: %s, calculator server\n"
#define ERRMSG_CLIENTNOTFOUND              "ERROR: Client program for calculator not responding\n"
#define ERRMSG_SERVERNOTFOUND              "ERROR: Server program for calculator not responding\n"
#define ERRMSG_ARRAYBOUNDS                 "ERROR: Exceeded array bounds in function: %s\n"
#define ERRMSG_EMPTY_DATASET               "ERROR: Empty data set for statistics operation: %s\n"
#define ERRMSG_RECURSION_LIMIT             "ERROR: Recursion limit reached: %s\n"
#define ERRMSG_UNSOLVABLE_MATRIX           "INVALID: Number of columns in matrix must be equal to the number of rows\n"
#define ERRMSG_INVALID_MATRIX_COLS         "INVALID: Number of columns in matrix must be the same for all matrix rows\n"
#define ERRMSG_EMPTYROW_MATRIX             "INVALID: Empty row in matrix found"
#define ERRMSG_NO_RESULT_COL_MATRIX        "INVALID: Result column missing for this row of the matrix: %s\n"
#define ERRMSG_INVALID_GRAPHVARNAME        "INVALID: Variable name does not match expression to be plotted: %s\n"
#define ERRMSG_INVALID_EXECSWITCH          "INVALID: unrecognized option switch supplied to EXEC command: %s\n"
#define ERRMSG_REENTRANT_INPUT_FILES       "ERROR: Re-entrant input data files not permitted: %s\n"
#define ERRMSG_INVALID_FUNCTIONS_FOUND     "INVALID: unrecognized functions found: %s\n"
#define ERRMSG_INVALID_VARIABLES_FOUND     "INVALID: unrecognized variables found: %s\n"
#define ERRMSG_FRACTION_OPERATOR_EXPECTED  "INVALID: fraction operator expected: %s\n"
#define ERRMSG_MISSING_RIGHT_BRACE         "INVALID: missing right brace: %s\n"
#define ERRMSG_MISSING_CLOSING_QUOTE       "INVALID: missing closing quote: %s\n"
#define ERRMSG_REQUIRED_OPERAND_MISSING    "INVALID: required operand missing: %s\n"
#define ERRMSG_OUTPUTDATA_ERRORS           "ERROR: Math expression conversion or output data errors encountered\n"
#define ERRMSG_EXPRESSION_FORMAT           "ERROR: Math expression is in unrecognized or invalid format\n"
#define ERRMSG_NULLCALCPTR                 "ERROR: Unexpected null calculator pointer, processing cannot continue\n"
#define ERRMSG_INFIX_CONVERSION            "ERROR: Infix order to RPN order conversion error detected\n"
#define ERRMSG_INVALID_PRG_SWITCH          "ERROR: unrecognized or invalid calculator program option switch: %s\n"
#define ERRMSG_PROGRAM_LOADING             "ERROR: Error encountered loading calculator program: %s\n"
#define ERRMSG_MUTUAL_EXCL_OPTIONS         "ERROR: mutually exclusive calculator output options detected\n"
#define ERRMSG_INVALID_DIRECTIVE           "ERROR: unrecognized or invalid calculator directive: %s\n"

/* non-enumerated error and status message strings */
#define ERRMSG_NOT_A_SET                   "\"*** Not A Set ***\""
#define ERRMSG_CALC_ERROR                  "CALC ERROR"
#define ERRMSG_INVALID_PRECISION           "Error: Invalid Precision"
#define ERRMSG_CHKSTROMIT_VALUE_MISMATCHED "ChkStrOmit value mismatched: expected ptr incr: "
#define ERRMSG_ERROR_IN_LINE               "error in line: %d, col: %d, code: %d\n"
#define ERRMSG_CLOSEINPUTFILE_NOTALLOWED   "ERROR: Coding error, closing input files in batch mode session disallowed\n"
#define ERRMSG_CLOSEOUTPUTFILE_NOTALLOWED  "ERROR: Coding error, closing output files in batch mode session disallowed\n"

#define MSG_ACTUAL_PTR_INCR                ", actual ptr incr: "
#define MSG_FILEREAD                       "reading"
#define MSG_FILEWRITE                      "writing"
#define MSG_WRITTEN_TO_FILE                ": is written to file: "
#define MSG_ENTER_TO_QUIT                  "Enter \"q\" to quit"
#define MSG_ENTER_TO_QUIT_NL               "Enter \"q\" to quit:\n"
#define MSG_PROCESSING_INPUT_FILE          "Processing Input Data File: %s"
#define MSG_PROCESSING_IN_PROGRESS         "In Progress....."
#define MSG_PLOTTING_NUM_FUNCTIONS         "Plotting %d Functions From Data File %s"
#define MSG_COMMAND_HISTORY_CLEARED        "Command History List Cleared\n"
#define MSG_EXEC_COMMAND_HISTORY_ENTRY     "Execute: %s [(%d of %d)|Enter=(N)o/(Y)es/(Q)uit]: "
#define MSG_INPUT_FILE_PROCESSED           "\nInput Data File: %s -- Processed and Outputted to: %s\n"
#define MSG_COMMAND_HISTORY_NO_ENTRIES     "No Entries In Command History\n"
#define MSG_COMMAND_HISTORY_MISMATCHED     "Selected History Command Is Mismatched\n"
#define MSG_COMMAND_HISTORY_CLEARED        "Command History List Cleared\n"
#define MSG_PROGRAM_PAUSED                 "<paused>"
#define MSG_PROGRAM_ENDED                  "<Program Ended>"
#define MSG_INPUT_FILE_ENDED               "<Input File Ended>"

#define COMMAND_HISTORY_EOF_MARKER         "<EndOfFile NumEntries=%d>\n"
#define YES_STR                            "yes"
#define NO_STR                             "no"
#define QUIT_STR                           "quit"
#define BREAK_STR                          "break"

#define FLOAT_PRECISION_MSGSTR             "Float (7-digit precision)"
#define DOUBLE_PRECISION_MSGSTR            "Double (15-digit precision)"
#define LONGDOUBLE_PRECISION_MSGSTR        "Long Double (19-digit precision)"
#define LONGNUM_PRECISION_MSGSTR           "Long Number (arbitrary precision)"

#define RADIAN_MODE_PROMPT                 "rad"
#define DEGREE_MODE_PROMPT                 "deg"
#define FLOAT_PREC_PROMPT                  "flt"
#define DOUBLE_PREC_PROMPT                 "dbl"
#define LONGDOUBLE_PREC_PROMPT             "ldbl"
#define LONGNUMBER_PREC_PROMPT             "lnum"
#define PREC_ERROR_PROMPT                  "err"

// Default precision values
#define DEFAULT_PRECSTR_APPROXZERO      ".05"    // default precision to use for approx. zero solving
                                                 // old = ".05" debug
#define DEFAULT_PRECSTR_FTEST           ".01"    // default precision to use for min/max solving
#define DEFAULT_PRECSTR_SOLVE           ".00001" // default precision to use for root solving,
                                                 //   set to .00001 as smallest otherwise overflow
#define DEFAULT_PRECSTR_INTEG           ".00001" // default precision to use for integration,
                                                 //   set to .00001 as smallest otherwise overflow
#define DEFAULT_PRECSTR_DERIV           ".001"   // default precision to use for differentiation
#define DEFAULT_PRECSTR_NEWTCRIT        ".2"     // default precision to use for finding value for newton's method

// Changed from .002 to .02 and .0005 to .005 for ver. 2.8.1
#define DEFAULT_PRECSTR_GRAPH           ".002"   // default tolerance to use for graphing
#define DEFAULT_PRECSTR_MAXINTERVAL     .0005    // default precision to use for graph plotting intervals

#define DEFAULT_PRECVAL_APPROXZERO      .05      // default precision to use for approx. zero solving
                                                 // old = .05 debug
#define DEFAULT_PRECVAL_FTEST           .01      // default precision to use for min/max solving
#define DEFAULT_PRECVAL_SOLVE           .00001   // default precision to use for root solving,
                                                 //   set to .00001 as smallest otherwise overflow
#define DEFAULT_PRECVAL_INTEG           .00001   // default precision to use for integration,
                                                 //   set to .00001 as smallest otherwise overflow
#define DEFAULT_PRECVAL_DERIV           .001     // default precision to use for differentiation
#define DEFAULT_PRECVAL_NEWTCRIT        .2       // default precision to use for finding value for newton's method

// Changed from .002 to .02 and .0005 to .005 for ver. 2.8.1
#define DEFAULT_PRECVAL_GRAPH           .002     // default tolerance to use for graphing
#define DEFAULT_PRECVAL_MAXINTERVAL     .0005    // default precision to use for graph plotting intervals

#define MAXSIGFIG_EXP                   50       // Specified maximum significant figures
#define DEFAULT_SIGFIG_SOLVE            -5       // Negative of significant figures for root solving
#define DEFAULT_SIGFIG_INTEG            -5       // Negative of significant figures for integration
#define DEFAULT_SIGFIG_DERIV            -3       // Negative of significant figures for differentiation

// value pair output format strings
#define DEFAULT_LONGNUM_FORMAT          "%s %s\n"
#define DEFAULT_FLOAT_FORMAT            "%.7f %.7f\n"
#define DEFAULT_DOUBLE_FORMAT           "%.14f %.14f\n"
#define DEFAULT_LONGDOUBLE_FORMAT       "%.19Lf %.19Lf\n"
#define DEFAULT_FLOATNAN_FORMAT         "%.7f %s\n"
#define DEFAULT_DOUBLENAN_FORMAT        "%.14f %s\n"
#define DEFAULT_LONGDOUBLENAN_FORMAT    "%.19Lf %s\n"

// default significant digits cutoff for float types
#define DEFAULT_FLOAT_EPSILON           0.0001999         // add trailing 9 to trigger rounding up?
#define DEFAULT_DOUBLE_EPSILON          0.00000001999
#define DEFAULT_LONGDOUBLE_EPSILON      0.000000000001999
#define DEFAULT_LONGNUM_EPSILON        "0.0000000000000000000000000000000000000000000000001999"

#define DEFAULT_FLOAT_SIGDIGITS         5
#define DEFAULT_DOUBLE_SIGDIGITS        9
#define DEFAULT_LONGDOUBLE_SIGDIGITS    13
#define DEFAULT_LONGNUM_SIGDIGITS       50

// Default file names
#define MCALC_CONFIG_FILE               "mcalc_fileio.cfg"        // configuration file for using file input/output
#define MCALC_SESSION_COUNT_FILE        "mcalc_sescnt.dat"        // main session counter file
#define MCALC_SESSION_FILE              "mcalc_session.dat"       // main session file
#define MCALC_SPAWNARG_FILE             "mcalc_spawnargs.log"     // spawn calculator arguments file
#define MCALC_LOG_FILE                  "mcalc_errors.log"        // error log file
#define MCALC_USER_PROMPT_FILE          "mcalc_userprompt.dat"    // user prompt file
#define MCALC_USER_INPUT_FILE           "mcalc_userinput.dat"     // user input file
#define MCALC_PROG_OUTPUT_FILE          "mcalc_programout.dat"    // program output file
#define MCALC_IOSTATE_FILE              "mcalc_iostate.dat"       // program I/O state file
#define MCALC_SERVERALIVE_FILE          "mcalc_serveralive.dat"   // server keep alive state file
#define MCALC_CLIENTALIVE_FILE          "mcalc_clientalive.dat"   // client keep alive state file
#define MCALC_CURRENTGRAPH_FILE         "mcalc_curgraph.dat"      // current graph suffix file
#define MCALC_GRAPH_OPERATION_FILE      "mcalc_graphoper.dat"     // graph operation type file
#define MCALC_GRAPH_PROGRESS_FILE       "mcalc_graphprogress.dat" // graph plotting progress file
#define MCALC_CMDHISTORY_FILE           "mcalc_cmdhistory.dat"    // command history file
#define MCALC_PROGRESS_FILE             "mcalc_progress.dat"      // completion progress of input data file processing
#define MCALC_ELAPSEDTIME_FILE          "mcalc_elapsedtime.dat"   // elapsed time file used for calc. server timeout notifications
#define MCALC_POLLSTATE_FILE            "mcalc_pollstate.dat"     // current keep alive poll state file
#define MCALC_CURRENT_ERROR_FILE        "mcalc_currenterr.log"    // current error message output file

// FunctionValidityChecker definitions
#define ADD_CHKSTROMIT       1
#define FNCVALID_DEBUG_STRM  0    // 1:Console Run, 2: IDE Run

#if (!(USE_STDIO_ONLY))
  #if USE_OLDVERSION_WINLINE
    #ifndef OVWINLINE_H
      #include "ovwinline.h"
    #endif
  #else
    #ifndef WINLINE_H
      #include "winline.h"
    #endif
  #endif
#endif

// namespace declaration
using namespace std;

/************************ Constants, Typedefs, Globals **********************/
// Type Definitions
// enumerated sign type definition
class Mcalc_SignType
{
  public:
  enum
  {
    Plus,
    Minus
  };
};

class Mcalc_SessionStates
{
  public:
  enum
  {
    InUse  = 1,
    UnUsed = 2
  };
};

class Mcalc_ClassID
{
  public:
    enum
    {
      NO_CALC = 0,
      FLOAT = 1,
      DOUBLE = 2,
      LONGDOUBLE = 3,
      LONGNUM = 4,
      MAXCALC = 5
    };
};

// input / output enumerated type
class Mcalc_IOType
{
  public:
  enum
  {
    Input          = 0,
    Output         = 1,
    ErrorLog       = 2,
    UserInput      = 3,
    UserPrompt     = 4,
    ProgramOutput  = 5,
    IoState        = 6,
    ServerAlive    = 7,
    ClientAlive    = 8,
    PollState      = 9,
    CurrentGraph   = 10,
    GraphOperation = 11,
    GraphProgress  = 12,
    CommandHistory = 13,
    Progress       = 14,
    CurrentError   = 15,
    SpawnArg       = 16,
    ElapsedTime    = 17
  };
};

class Mcalc_IOState
{
  public:
  enum
  {
    IOSTATE_STARTVAL = 1,   // IO state starting value to mark beginning of iostate enumerated list

    PROCESS         = 1,     // - send process input data request from client program to calculator
    OUTPUT_READY    = 2,     // - sent by calculator to indicate output data ready
                             //     used to indicate text messages sent that are not meant as calculated answers
                             //     examples: error messages, status messages, executed disp program commands...
    CALC_HALT       = 4,     // - sent by client program to tell calculator to halt execution and quit
    CALC_RESPONSE   = 8,     // - sent by calculator to indicate post processing response
    INPUT_REQUIRED  = 16,    // - sent by calculator in script program or interactive text mode to
                             //   indicate prompt from stdio/console input for additional required input data
    OUTPUT_FETCHED  = 32,    // - sent by client program to indicate literal text string or graph plotting data fetched
    INPUT_RECEIVED  = 64,    // - sent by client program to indicate required input data sent to calculator
    BREAK_PROGRAM   = 128,   // - sent by client program to tell calculator to break program and exit program mode
                             //   execution of program script if it is in program mode
    IDLE_STATE      = 256,   // - calculator is in idle or initial starting state, set after CALC_HALT received
    GRAPH_OUTPUT    = 512,   // - function graphing output is completed and ready to be read
    GRAPH_WAIT      = 1024,  // - Function graphing is in process. Data points being plotted.
    CALC_ERROR      = 2048,  // - sent by calculator to indicate calculator error from invalid input or other conditions
    PROGRESS_READY  = 4096,  // - input data file -- calculation progress is ready and sent to gui client
    ERROR_FETCH     = 8192,  // - set by calculator to indicate calculator error. Fetch output from error log file.
    GRAPH_PROGRESS  = 16384, // - plotted data points -- graph plotting progress is ready and sent to gui client

    INFILE_PROGRESS_ACK = 32768,  // - Input file processing progress acknowledged/fetched by client
    GRAPH_PROGRESS_ACK  = 65536,  // - Graph plotting processing progress acknowledged/fetched by client
    GRAPH_WAIT_ACK      = 131072, // - Graph wait signal acknowledged, graph plot operation data fetched

    SPAWN_NEW_MCALC = 262144, // - sent by calculator to notify client to spawn another mcalc process
    MCALC_SPAWNED   = 524288, // - sent by client program to indicate request to spawn mcalc process acknowledged and done

    BATCHFILE_ENDED     = 1048576, // sent by calculator to indicate end of batch data input file processing
    BATCHFILE_ENDED_ACK = 2097152, // sent by client to acknowledge and of batch data file signal
    PROCESS_DONE        = 4194304, // sent by calculator to indicate process acknowledgement of non-output directives
    PROCESS_DONE_ACK    = 8388608, // sent by client to acknowledge server directive execution

    RESENDLASTSIG       = 16777216, // Resend last signal sent by server
    CLIENTPING          = 33554432, // Server ping signal to client
    CLIENTPING_ACK      = 67108864, // Client acknowledgement of client ping signal

    IOSTATE_ENDVAL      = 67108864  // IO state ending value to mark end of iostate enumerated list
  };

  // expected valid IOState sequence
  // 1. Client-->Calc : PROCESS, calculator input data sent
  // non-graph output:
  // 1.1 Calc-->Client : CALC_RESPONSE, Answer as calculated output returned to client         OR
  //        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.2a Calc-->Client : INPUT_REQUIRED, Additional input data requested                      OR
  //         Client-->Calc : INPUT_RECEIVED, Additional data sent by client
  //            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.2b Calc-->Client : INPUT_REQUIRED, Additional input data requested                      OR
  //         Client-->Calc : INPUT_RECEIVED, Additional data sent by client
  //            Calc-->Client : INPUT_REQUIRED, Additional input data requested
  // 1.3a Calc-->Client : OUTPUT_READY, Answer as non-calculated text string                    OR
  //         Client-->Calc : OUTPUT_FETCHED, Non-calculated text string fetched
  //            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.3b Calc-->Client : OUTPUT_READY, Answer as non-calculated text string                    OR
  //         Client-->Calc : OUTPUT_FETCHED, Non-calculated text string fetched
  //            Client-->Calc : OUTPUT_READY, Additional non-calculated text string output
  // 1.4 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
  //        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.5 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
  //        Client : Fetch output from error log file and set state to: CALC_ERROR
  //        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // graphing output:                                                                          OR
  // 1.6a Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
  //                                  graph operation data sent to client.
  //         Client-->Calc : GRAPH_WAIT_ACK, Graph plotting operation type and data fetched
  // 1.6b Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
  //                                  graph operation data sent to client.
  //         Client-->Calc : INPUT_RECEIVED, quit graph plotting signal sent by client
  //
  // 1.7 Calc-->Client : GRAPH_PROGRESS, Function graph plotting progress data sent
  //        Client-->Calc : GRAPH_PROGRESS_ACK, Function graph plotting progress data fetched
  // 1.8a Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed                       OR
  //         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
  //            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.8b Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed
  //         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
  //            Calc-->Client : BATCHFILE_ENDED, Batch data file for Graph plotting ended
  //               Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
  //                  Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  //
  // 1.9 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
  //        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 1.10 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
  //         Client : Fetch output from error log file and set state to: CALC_ERROR
  //         Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  //
  // 2. Client-->Calc : BREAK_PROGRAM, request calculator to break out from program mode
  //       Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  //
  // 3. Client-->Calc : CALC_HALT, tell calculator to halt execution and quit
  //       Calc->Client : IDLE_STATE, Calculator set to idle state before program termination
  //
  // 4. Calc-->Client : PROGRESS_READY, Send progress status of input data file processing
  //       Client-->Calc : INFILE_PROGRESS_ACK, Non-calculated progress status text fetched
  //          Calc-->Client : BATCHFILE_ENDED, Batch data file for math expressions ended
  //             Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
  //                Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  //
  // 5. Calc-->Client : SPAWN_NEW_MCALC, notify client to spawn another mcalc process
  //       Client-->Calc : MCALC_SPAWNED, request to spawn mcalc process acknowledged and done
  //
  // 6a. Client-->Calc : PROCESS, process signal sent by client to process non-output calc. directive
  //        Calc-->Client : PROCESS_DONE, send acknowledgement signal to client of directive execution
  //           Client-->Calc : PROCESS_DONE_ACK, sent by client to acknowledge server directive execution
  //              Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
  // 6b. Client-->Calc : PROCESS, process signal sent by client to process non-output calc. directive
  //        Calc-->Client : PROCESS_DONE, send acknowledgement signal to client of directive execution
  //           Client-->Calc : PROCESS_DONE_ACK, sent by client to acknowledge server directive execution
  //              Client-->Calc : PROCESS_DONE, send additional acknowledgement signals to client of directive execution
  //
  // 7. Calc-->Client : CALC_HALT, calculator has self terminated and CALC_HALT signal is sent
  //       Client : IDLE_STATE, Client sets calculator state file to idle state before quitting
  //
  // Input Data Batch File Mode:
  // ---------------------------
  // If calculator is executing a batch file or program,
  // the following special cases apply:
  //
  //   INPUT_RECEIVED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   OUTPUT_FETCHED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BREAK_PROGRAM       --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //   BATCHFILE_ENDED_ACK --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //
  //   CALC_RESPONSE       --> INPUT_RECEIVED
  //   CALC_ERROR          --> INPUT_RECEIVED
  //   ERROR_FETCH         --> INPUT_RECEIVED
  //
  //   PROCESS_DONE        --> PROCESS_DONE_ACK
  //   PROCESS_DONE_ACK    --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
  //
  // Control Signals Only (Not Saved As IO State):
  // ---------------------------------------------
  // 8. Client-->Calc : RESENDLASTSIG, sent by client to request resending of latest sent IO signal
  //       Calc-->Client : Resending of last sent IO signal, (RESENDLASTSIG not saved)
  //                       BatchExecLevel value sent in next line
  //
  // 9. Calc-->Client : CLIENTPING, sent by calculator to verify if client program is still active
  //       Client-->Calc : CLIENTPING_ACK, response sent by client to verify that it is still active
  //                       Calculator reverts back to previous IO state prior to sending CLIENTPING.
  //                       Calculator waits for PROCESS, BREAK_PROGRAM or CALC_HALT signal from client.
  //
};

class Mcalc_ElapsedTime
{
  public:
  enum
  {
    RESET = 0,
    SENT = 1,
    ACKNOWLEDGED = 2
  };
};

class Mcalc_KeepAliveState
{
  public:
  enum
  {
    IDLE                = 0,  // idle state
    RESET_POLLING       = 1,  // reset polling timer when received

    POLL_SERVERALIVE    = 2,  // poll signal sent to server to check if process is alive
    CLIENT_ACKNOWLEDGED = 4,  // reply to server, client acknowledged server alive signal
    CLIENT_ALIVE        = 8,  // sent from client to confirm that process is alive

    POLL_CLIENTALIVE    = 16, // poll signal sent to client to check if process is alive
    SERVER_ACKNOWLEDGED = 32, // reply to client, server acknowledged client alive signal
    SERVER_ALIVE        = 64  // sent from server to confirm that proces is alive
  };
};

class Mcalc_PollState
{
  public:
  enum
  {
    IDLE                = 0,
    SERVER_TO_CLIENT    = 1,
    CLIENT_RESPONSE     = 2,
    CLIENT_TO_SERVER    = 4,
    SERVER_RESPONSE     = 8,
    POLLING_PAUSED      = 16
  };

// async mode server/client polling scheme:
//
// 0. inital file states
//
//    client alive file: IDLE
//    poll state file: IDLE
//    server alive file: IDLE
//
// 1. server-to-client
//
// 1a. i: check for server states in iostate file.
//     ii: check poll state file for IDLE state.
//     iii: check client alive file for IDLE state.
//     proceeed if conditions at i, ii and iii is true.
//     send polling signal to client
//
// 1b. client alive file:  IDLE
//     poll state file: SERVER_TO_CLIENT\n (cycle number)
//     server alive file: POLL_CLIENTALIVE\n (cycle number)
//
// 2. client receives server poll signal
//
// 2a. check for server states in iostate file, proceed if server states confirmed:
//     send back client alive signal
//
// 2b. client alive file: CLIENT_ALIVE\n (cycle number from server)
//     poll state file: CLIENT_RESPONSE
//     server alive file: POLL_CLIENTALIVE
//
// 3. server receives client alive signal and sends back acknowledgement
//    send back server acknowledged signal
//
// 3a. client alive file: CLIENT_ALIVE
//     poll state file: SERVER_TO_CLIENT
//     server alive file: SERVER_ACKNOWLEDGED\n (cycle number)
//
// 4. client receives server acknowledgement and sends reset polling timer signal
//    send back polling timer reset signal
//
// 4a. client resets own no-activity polling timer
//
// 4b. client alive file: RESET_POLLING\n (cycle number)
//     poll state file: CLIENT_RESPONSE
//     server alive file: SERVER_ACKNOWLEDGED
//
// 5. server receives reset polling timer signal and resets all polling timers (if timers exist)
//    Sets poll state file to IDLE state. Sets server alive file to IDLE state.
//
// 5a. server resets polling timer, server resets no-activity timer (if timers exist)
//
// 5b. client alive file: RESET_POLLING
//     poll state file: IDLE
//     server alive file: IDLE
//
// 6. client-to-server
//
// 6a. i: check for client states in iostate file.
//     ii: check poll state file for IDLE state.
//     iii: check server alive file for IDLE state.
//     proceeed if conditions at i, ii and iii is true.
//     send polling signal to server
//
// 6b. client alive file:  POLL_SERVERALIVE\n (cycle number)
//     poll state file: CLIENT_TO_SERVER\n (cycle number)
//     server alive file: IDLE
//
// 7. server receives client poll signal
//
// 7a. check for client states in iostate file, proceed if client states confirmed:
//     send back server alive signal
//
// 7b. client alive file: POLL_SERVERALIVE
//     poll state file: SERVER_RESPONSE
//     server alive file: SERVER_ALIVE\n (cycle number from client)
//
// 8. client receives server alive signal and sends back acknowledgement
//    send back client acknowledged signal
//
// 8a. client alive file: CLIENT_ACKNOWLEDGED\n (cycle number)
//     poll state file: CLIENT_TO_SERVER
//     server alive file: SERVER_ALIVE
//
// 9. server receives client acknowledgement and sends reset polling timer signal
//    send back polling timer reset signal
//
// 9a. server resets own no-activity polling timer (if timer exists)
//
// 9b. client alive file: CLIENT_ACKNOWLEDGED
//     poll state file: SERVER_RESPONSE
//     server alive file: RESET_POLLING\n (cycle number)
//
// 10. client receives reset polling timer signal and resets all polling timers
//     Sets poll state file to IDLE state. Sets client alive file to IDLE state.
//
// 10a. client resets polling timer, client resets no-activity timer
//
// 10b. client alive file: IDLE
//      poll state file: IDLE
//      server alive file: RESET_POLLING
};

struct Mcalc_GraphPlotOpType
{
  enum
  {
    NO_GRAPH          = 0,  // No graph operations specified
    FUNCTION_PLOT     = 1,  // straight function plot of math expression
    APPLIED_FNCGRAPH  = 2,  // extra applied functions: deriv, integ, etc...
    BATCH_GRAPH_PLOT  = 3   // batch input of graph operations
  };
};

struct Mcalc_GraphType
{
  enum
  {
    NO_GRAPH   = 0,

    FUNCTION   = 1,
    EXTREMA    = 2,
    DERIVATIVE = 3,
    INTEGRAL   = 4,
    ROOTSOLVE  = 5,
    INTERSECT1 = 6,
    INTERSECT2 = 7,

    MIN_EXTREMA  = 101,
    MAX_EXTREMA  = 102,

    FIRST_DERIV  = 201,
    SECOND_DERIV = 202
  };
};

struct Mcalc_Error
{
  enum
  {
    ERRVAL_INVALID_EXPR               = 1,
    ERRVAL_MISSLEFT_BRACKET           = 2,
    ERRVAL_MISSRIGHT_BRACKET          = 3,
    ERRVAL_INVALID_SYMBOLS            = 4,
    ERRVAL_INVALID_ASSIGNMENT         = 5,
    ERRVAL_INVALID_NUMARGS            = 6,
    ERRVAL_MULLERS_METHOD_FAILED      = 7,
    ERRVAL_DIVISION_BY_ZERO           = 8,
    ERRVAL_OPENSTATEFILE              = 9,
    ERRVAL_MEMORY_FAIL                = 10,
    ERRVAL_FILE_ERROR                 = 11,
    ERRVAL_CLIENTNOTFOUND             = 12,
    ERRVAL_ARRAYBOUNDS                = 13,
    ERRVAL_INVALID_TYPEARGS           = 14,
    ERRVAL_EMPTY_DATASET              = 15,
    ERRVAL_RECURSION_LIMIT            = 16,
    ERRVAL_ARGLIST_SIZE               = 17,
    ERRVAL_UNSOLVABLE_MATRIX          = 18,
    ERRVAL_INVALID_MATRIX_COLS        = 19,
    ERRVAL_EMPTYROW_MATRIX            = 20,
    ERRVAL_NO_RESULT_COL_MATRIX       = 21,
    ERRVAL_INVALID_GRAPHVARNAME       = 22,
    ERRVAL_INVALID_EXECSWITCH         = 23,
    ERRVAL_REENTRANT_INPUT_FILES      = 24,
    ERRVAL_INVALID_FUNCTIONS_FOUND    = 25,
    ERRVAL_INVALID_VARIABLES_FOUND    = 26,
    ERRVAL_FRACTION_OPERATOR_EXPECTED = 27,
    ERRVAL_MISSING_RIGHT_BRACE        = 28,
    ERRVAL_MISSING_CLOSING_QUOTE      = 29,
    ERRVAL_REQUIRED_OPERAND_MISSING   = 30,
    ERRVAL_OUTPUTDATA_ERRORS          = 31,
    ERRVAL_EXPRESSION_FORMAT          = 32,
    ERRVAL_NULLCALCPTR                = 33,
    ERRVAL_INFIX_CONVERSION           = 34,
    ERRVAL_INVALID_PRG_SWITCH         = 35,
    ERRVAL_PROGRAM_LOADING            = 36,
    ERRVAL_MUTUAL_EXCL_OPTIONS        = 37,
    ERRVAL_MISPLACED_COMMA            = 38,
    ERRVAL_SERVERNOTFOUND             = 39,
    MAX_ERRORS                        = 40
  };
};

// operand structure type definition
typedef struct
{
  char* value;
  int size;
  int sign;
} Mcalc_LongValue;

typedef Mcalc_LongValue Mcalc_Operand;

// enumerated operator type definition
class Mcalc_OperatorType
{
  public:
  enum
  {
    Assignment,
    Modulus,
    Logical_Not,
    Logical_And,
    Logical_Or,
    Exclusive_Or,
    Multiply,
    Divide,
    Add,
    Subtract,
    Exponent,
    Square,
    SquareRoot,
    Cube,
    CubeRoot,
    Sine,
    Cosine,
    Tangent,
    ArcSine,
    ArcCosine,
    ArcTangent,
    HyperSine,
    HyperCosine,
    HyperTangent,
    NaturalExp,
    NaturalLog,
    Log10,
    Ceiling,
    Floor,
    AbsoluteValue,
    FractionPart,
    IntegerPart,
    Percent,
    LessThan,
    GreaterThan,
    Round,
    Factorial,
    Combination,
    Permutation,
    CombineWithRep,
    PermuteWithRep,
    LessOrEqual,
    GreaterOrEqual,
    Equal,
    NotEqual,
    Minimum,
    Maximum,
    Derivative,
    Derivative2,
    Integral,
    Random,
    Inverse,
    RootSolve,
    Intersect,
    FunctionMinimum,
    FunctionMaximum,
    RoundEx,
    ItemPermutation,
    ItemCombination,
    ItemPermuteWithRep,
    ItemCombineWithRep,
    MakeSet,
    ShowSet,
    SetUnion,
    SetIntersection,
    SetDifference,
    SetExclusion,
    FractionArithmetic,
    PolarToRectX,
    PolarToRectY,
    RectToPolarRadius,
    RectToPolarAngle,
    ScientificNotation,
    FromHex,
    FromOct,
    FromBin,
    FromCmp2Bin,
    ToHex,
    ToOct,
    ToBin,
    ToCmp2Bin,
    Sum,
    Product,
    AvgMean,
    AvgMedian,
    AvgMode,
    StdDev,
    MatrixSolve,
    PlotGraph,
    UNDEF
  };
};

// enumerated operator type definition
class Mcalc_OutputDataType
{
  public:
  enum
  {
    Out_AnsVar           = 0x0001,   // Calculator answer number variable outputted
    Out_AnsStrVar        = 0x0002,   // Calculator answer string variable outputted
    Out_FracAnsVar       = 0x0004,   // Calculator fraction answer variable outputted
    Out_LetterVar        = 0x0008,   // User accessible letter variable outputted
    Out_VariableMask     = 0x000F,   // Variable data type bit mask

    Out_ErrorMessage     = 0x0010,   // Error message outputted
    Out_HelpMessage      = 0x0020,   // Help message outputted
    Out_TextMessage      = 0x0040,   // Text message outputted
    Out_MessageMask      = 0x0070,   // Message data type bit mask
    Out_MessageString    = 0x0080,   // Message string category of output data sent

    Out_LiteralAnswer    = 0x0100,   // Literal answer outputted
    Out_FractionAnswer   = 0x0200,   // Fraction answer outputted
    Out_FloatAnswer      = 0x0400,   // Float answer outputted
    Out_AnswerMask       = 0x0700,   // Answer data type bit mask
    Out_AnswerString     = 0x0800,   // Answer string category of output data sent

    Out_VariableDisplay  = 0x1000,   // Single letter variable or calculator answer variable is displayed
    Out_VariableDump     = 0x2000,   // All letter Variables and calculator answer variables output dumped
    Out_ProgressData     = 0x4000    // Progress data outputted
  };
};

// enumerated operator type definition
class Mcalc_OutputDataCondition
{
  public:
  enum
  {
    Cond_LineEvalDone    = 0x0001,   // Expression line evaluation completed
    Cond_VariableEval    = 0x0002,   // Variable contents evaluation completed
    Cond_FormatInvalid   = 0x0004,   // Math expression line format is invalid
    Cond_ConversionError = 0x0008,   // InfixToRpn conversion error detected
    Cond_PrgLoadError    = 0x0010,   // Program loading encountered problems
    Cond_PauseSwitch     = 0x0020,   // Pause option selected for executing input data files
    Cond_InvalidSwitch   = 0x0040,   // Invalid switch specified for executing input data files
    Cond_MutualExclOpt   = 0x0080,   // Error detected, mutually exclusive options selected

    Cond_VariableDisplay = 0x0100,   // matches with: Out_VariableDisplay | Variable display completed
    Cond_MessageDisp     = 0x0200,   // matches with: Out_MessageString   | Text message display completed
    Cond_AnswerDisp      = 0x0400,   // matches with: Out_AnswerString    | Calculated answer display completed: (float, literal, fraction)
    Cond_VariableDump    = 0x0800,   // matches with: Out_VariableDump    | Output dump of all letter variables and answer variables completed
    Cond_ProgressDisp    = 0x1000,   // matches with: Out_ProgressData    | Progress data display completed

    Cond_PrgSelected     = 0x2000,   // Calculator program selected to be executed
    Cond_NullCalcPtr     = 0x4000,   // Unexpected null calculator pointer, processing cannot continue

    MAX_OUTPUTDATA_ERRORS = 6        // Maximum number of error conditions to test for related to output data errors
  };
};

class CalculatorBase;

typedef Uchar* Mcalc_StackData;
typedef Uchar* Mcalc_QueueData;

typedef struct _Mcalc_Stack
{
  Mcalc_StackData data;
  struct _Mcalc_Stack* next;
} Mcalc_Stack;

typedef Mcalc_Stack Mcalc_Queue;

struct Mcalc_CmdLineOptions
{
  int inputexists;
  int outputexists;
  int sesnumexists;

  int ifindex;         // input file string array index
  int ofindex;         // output file string array index
  int snindex;         // session number string array index

  int ifoffset;        // input file string array index -- offset from 0 base position
  int ofoffset;        // output file string array index -- offset from 0 base position
  int snoffset;        // session number string array index -- offset from 0 base position

  int numfiles;        // number of files
  int argcount;        // same as argc parameter: gives argument count
  int cmdline;         // runs on command line (no input files)
  int sesnumber;       // session number

  char** argvector;    // same as argv parameter: gives argument vector

  Mcalc_CmdLineOptions();

  void ShowData(Debugging<CalculatorBase>* DbgPtr_, bool ShowToStdout_);
};

struct Mcalc_GraphOperationOptions
{
  int _GraphOptionsSet;
  int _OperationType;
  int _GraphType;
  int _GraphSubtype;
  int _AllowBatchQuit;

  Mcalc_GraphOperationOptions();
  bool InBatchFile(bool QuitAllowed_) const;
  bool InGraphOperation(bool InBatch_) const;
  bool InAppliedFunctionGraph() const;
  bool InFunctionPlot() const;
  bool NotInGraphOperation() const;
};

// standalone function declarations
int operator == (SimpleList<int>& x, const char* s);
int operator == (const char* s, SimpleList<int>& x);

char* Mcalc_DefaultInFnc(char*, int);
int Mcalc_DefaultOutFnc(const char*);
int Mcalc_DefaultSetElementEqualFnc(const int& ival1, const int& ival2);
void* Mcalc_DefaultAllocFnc(size_t, size_t);
void* Mcalc_DefaultDelFnc(size_t, void*);

class FunctionCall;

/****************************************************************************/
class DiscontinuityDetectorBase
{
  public:
    #if (!(DISCONTDETECT_USE_CALCBASE_CLASS))
      enum
      {
        NO_CALC = 0,
        FLOAT = 1,
        DOUBLE = 2,
        LONGDOUBLE = 3,
        LONGNUM = 4,
        MAXCALC = 5
      };
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

    enum
    {
      NO_POINTGAP_FOUND = 0,
      DISCONTINUITY_FOUND = 1,
      INFINITYPOINT_FOUND = 2
    };

  protected:
    #if DISCONTDETECT_USE_CALCBASE_CLASS
      static CalculatorBase* _BasePtr;
    #else
      static char* _BasePtr;     // testing with char* instead of CalculatorBase*
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

    static int _UsingCalcType;         // One of: FLOAT, DOUBLE, LONGDOUBLE
	static ofstream* _Fout;            // File output stream
	static bool _HasFout;              // Has file output
	static char* _Filename;            // Output file name

    const int _PtBufferSize;           // Size of buffer for storing graph points.
                                       // == CALC_DISCONTINUITY_STRIKES * 2 + 1
    const int _RdBufferSize;           // Size of the read ahead buffer for storing graph points
                                       // == CALC_DISCONTINUITY_STRIKES + 1
    const int _StrikeLimit;            // == CALC_DISCONTINUITY_STRIKES
    const int _PtGapLimit;             // == CALC_DISCONTINUITY_PTGAP

    const int _InfPtsDisplaceMargin;   // == CALC_INFPTSDISPLACEMARGIN

    #if ((DISCONTDETECT_DEBUGGING) & (!(DISCONTDETECT_USE_CALCBASE_CLASS)))
      static size_t _errline;
      static size_t _errcol;
      static int _errcode;
      static Debugging<DiscontinuityDetectorBase>* _dbgptr;
    #elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
      static Debugging<CalculatorBase>* _dbgptr;
    #endif

    #if ((CALCLIB_DEBUGGING)&(DISCONTDETECT_USE_CALCBASE_CLASS))
      DiscontinuityDetectorBase(Debugging<CalculatorBase>* dbgptr_);
    #else
      DiscontinuityDetectorBase();
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

  public:
    ~DiscontinuityDetectorBase();

    #if DISCONTDETECT_USE_CALCBASE_CLASS
      static bool SetCalculatorPtr(CalculatorBase* BasePtr_);
      static CalculatorBase* GetCalculatorPtr();
    #else
      static bool SetCalculatorPtr(const char* BasePtr_);    // testing with char* instead of CalculatorBase*
      static const char* GetCalculatorPtr();
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

    #if (((DISCONTDETECT_DEBUGGING)&(!(DISCONTDETECT_USE_CALCBASE_CLASS))) | \
         (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS)))
      static size_t GetErrline();
      static size_t GetErrcol();
      static int GetErrcode();
      #if ((DISCONTDETECT_DEBUGGING)&(!(DISCONTDETECT_USE_CALCBASE_CLASS)))
        static void SetCurrentDebugger(Debugging<DiscontinuityDetectorBase>* ptr);
        static Debugging<DiscontinuityDetectorBase>* DbgPtr(bool Deref_=true);
      #elif (((DISCONTDETECT_DEBUGGING)|(CALCLIB_DEBUGGING))&(DISCONTDETECT_USE_CALCBASE_CLASS))
        static void SetCurrentDebugger(Debugging<CalculatorBase>* ptr);
        static Debugging<CalculatorBase>* DbgPtr(bool Deref_=true);
      #endif
      static void SetErrorData(int errcode_, const char* file_=__FILE__,
                               size_t line_=__LINE__, size_t col_=0, bool terminate_=false);
      static void Terminate(bool setcode_=false, int errcode_=0);
    #endif

	static void SetOutputFile(const char* Filename_);
	static ofstream* GiveOutputFile(bool* HasFout_=NULL);

    int PointsBufferSize() const
        { return _PtBufferSize; }
    int ReadAheadBufferSize() const
        { return _RdBufferSize; }
    int StrikeLimit() const
        { return _StrikeLimit; }
    int PtGapLimit() const
        { return _PtGapLimit; }
    int InfPtsDisplaceMargin() const
        { return _InfPtsDisplaceMargin; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
template <class PRIM>
class GraphPointsDoneArray
{
  private:
    PRIM* _ProcessedPts;
    int _MaxSize;
    int _Limit;

    bool _PtsNotified;
    bool _HasOverFlow;
    bool _PointsBufferFlushed;
    int _OverFlowedPoints;

  public:
    GraphPointsDoneArray(int Max_);
    ~GraphPointsDoneArray();

    bool CopyFromThisArray(PRIM* source_, int Limit_);
    bool AppendFromThisArray(PRIM* source_, int Limit_);
    bool IsNonOverflowedPt(size_t x) const;
    bool SetLimit(int Limit_);
    void SetParameters(bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_);
    void ShowPoints(const char* DelimStr_=",");
	void ShowPoints(ofstream* Fout_);
    void SetPtsNotified(bool Flag_=true);
    void ClearPtsNotified();
    void Clear();

    PRIM operator [] (size_t x) const;
    const PRIM* ProcessedPts() const
        { return _ProcessedPts;}

    bool HasPoints() const
        { return (_Limit > 0); }
    int MaxSize() const
        { return _MaxSize; }
    int RemainingSpace() const
        { return (_MaxSize - _Limit); }
    int Limit() const
        { return _Limit; }
    int NonOverflowedLimit() const
        { return (_Limit - _OverFlowedPoints); }

    bool PtsNotified() const
        { return _PtsNotified; }
    bool HasOverFlow() const
        { return _HasOverFlow; }
    bool PointsBufferFlushed() const
        { return _PointsBufferFlushed; }
    int OverFlowedPoints() const
        { return _OverFlowedPoints; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
template <class PRIM>
class PointsDoneNotifier
{
  protected:
    bool _HasOverFlow;
    bool _PointsBufferFlushed;
    int _OverFlowedPoints;

    GraphPointsDoneArray<PRIM>* _PointsDone;
	DiscontinuityDetectorBase* _Detector;

  public:
    PointsDoneNotifier();
    virtual ~PointsDoneNotifier();

    virtual const char* ClassName() const;

    void SetPtsNotified(bool Flag_=true)
        { if (_PointsDone) _PointsDone->SetPtsNotified(Flag_); }
    void ClearPtsNotified()
        { if (_PointsDone) _PointsDone->ClearPtsNotified(); }

    GraphPointsDoneArray<PRIM>* PointsDone()
        { return _PointsDone; }
    PRIM PointsDone(size_t x) const
        { return (_PointsDone ? (*_PointsDone)[x]:0); }

    bool HasOverFlow() const
        { return _HasOverFlow; }
    bool PointsBufferFlushed() const
        { return _PointsBufferFlushed; }
    int OverFlowedPoints() const
        { return _OverFlowedPoints; }

    virtual void SetParameters();
    virtual void Notify_ShowPoints(GraphPointsDoneArray<PRIM>* DataPts_,
                                   bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_);
    virtual void Notify(GraphPointsDoneArray<PRIM>* DataPts_,
                        bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_);
    virtual void SetBasePointer(void* Base_);
	virtual void SetDetectorPointer(DiscontinuityDetectorBase* Detect_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

#if DISCONTDETECT_TESTNOTIFIERS
template <class PRIM>
class CalcPointsDoneNotifier : public PointsDoneNotifier<PRIM>
{
  protected:
    #if DISCONTDETECT_USE_CALCBASE_CLASS
      CalculatorBase* _BasePtr;
    #else
      const char* _BasePtr;
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

    void ProcessedPtsNotify();

  public:
    CalcPointsDoneNotifier();
    virtual ~CalcPointsDoneNotifier();

    virtual const char* ClassName() const;

    virtual void Notify(GraphPointsDoneArray<PRIM>* DataPts_,
                        bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_);

    virtual void SetBasePointer(void* Base_);
    #if DISCONTDETECT_USE_CALCBASE_CLASS
      virtual void SetCalcBasePointer(CalculatorBase* Base_);
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};
#endif // DISCONTDETECT_TESTNOTIFIERS

/****************************************************************************/
template <class PRIM>
class ArrayResetNotifier
{
  protected:
    PRIM* _ExtArray;       // external data array for refilling data points
    PRIM* _Rdarr;          // external points storage buffer
    PRIM* _Endp;           // end point of external points storage buffer

    int _RunTotal;        // running total of consumed points
    int _PtsArrMax;       // max size of external points storage buffer (also size of _ExtArray)
    int _PtsAvailable;    // Graph points available for refill in external data array
    int _ExtIndex;        // Index to ExtArray data array

    bool _PtsArrInit;      // Points array initialized
    bool _RefillAvailable; // External refill points available

    void TransferFromExtArray();
    void ResetExtArray();

  public:
    ArrayResetNotifier();
    virtual ~ArrayResetNotifier();

    virtual void Reset();
    virtual void Initialize(PRIM* ExtArray_, PRIM* RdArray_, PRIM* Endp_, int PtsArrMax_);
    virtual void Notify(PRIM* ExtArray_, PRIM* RdArray_, PRIM* Endp_, int PtsArrMax_, int RunTotal_);

    int RefillExtArray(int BufSz_, PRIM* Buffer_, bool FillToBufSz_);
    int RefillExtArray(PRIM Val_);

    int UnfilledExtArrayPts() const;
    bool ExtArrayFilled() const;
    void SetRefillAvailable(bool Refill_);

    bool Initialized() const
        { return (_ExtArray && _Rdarr && _Endp && _PtsArrMax); }
    bool RefillAvailable() const
        { return _RefillAvailable; }
    int PointsAvailable() const
        { return _PtsAvailable; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
template <class WRAP, class PRIM>
class GraphDiscontinuityDetector : public DiscontinuityDetectorBase
{
  protected:
    PRIM* _BackPts;
    PRIM* _FrontPts;
    PRIM* _InfinityPt;
    PRIM* _GraphPtsBuffer;
    PRIM* _GraphPtsPtr;
    PRIM* _ReadAheadBuffer;
    PRIM* _ReadAheadPtr;

    ArrayResetNotifier<PRIM>* _ResetNotifier;
    PointsDoneNotifier<PRIM>* _PtsDoneNotifier;
    GraphPointsDoneArray<PRIM>* _DonePtsArray;

    int _BackDiscontinuityIndex;
    int _FrontDiscontinuityIndex;
    WRAP* _Wrapper;

    int _ReadMorePts;             // Extra points to read to fill front/back array pts.
    int _BackStrikes;             // matching trend back points backward from discontinuity
    int _FrontStrikes;            // matching trend front points forward from discontinuity

    int _GraphPtsIndex;           // Index for array points buffer. Limit to valid read point.
    int _RdAheadIndex;            // Index for read ahead buffer. Limit to valid read point.
    int _TransferPts;             // Number of graph points transferred from read ahead buffer
    int _TerminatedPts;           // Number of repeated ending points padded to the read ahead buffer
    int _DataPtsRead;             // Number of non-terminated data points read
    int _OverFlowedPts;           // Number of overflowed points read past the end of the data buffer
    int _ScanNumber;              // Scanning iteration of the points on the graph
    int _DiscontinuityCond;       // Discontinuity condition enumerated value

    bool _TransferDone;           // switch to indicate transfer from Read Ahead Buffer done
    bool _AtGraphEdge;            // points to be scanned are at the edges of the graph
    bool _AtGraphStart;           // points to be scanned are at the beginning (left edge) of the graph
    bool _AtGraphEnd;             // points to be scanned are at the end (right edge) of the graph
    bool _FrontPtsShifted;        // Front pts array shifted from original start position
    bool _GraphPtsNotRead;        // points in main array buffer not read, need input from calculator
    bool _RdAheadPtsNotRead;      // points in read ahead buffer not read, need input from calculator
    bool _ScanningDiscontinuity;  // scanning for discontinuity
    bool _PtGapReached;           // point gap indicating discontinuity found on graph
    bool _DiscontinuityNotFound;  // point gap not reached or no matching front/back points found
    bool _DiscontinuityFound;     // point gap reached and matching front points and back points found
    bool _InfinityPtFound;        // infinity pt. of graph expression found
    bool _OverFlowedPtsMoved;     // Overflowed points moved from read ahead buffer to frontpts buffer
    bool _SingleDiscAtEdge;       // Single discontinuity point found at edge of graph

    bool _ScanningNegToPosInfinity;    // scanning for negative infinity condition, discontinuity found
    bool _ScanningPosToNegInfinity;    // scanning for positive infinity condition, discontinuity found
    bool _ScanProcessDone;             // Scan process for discontinuity completed
    bool _LastScanPending;             // Last scan of data points pending
    bool _LastScanDone;                // Last scan done, ResetScan(true) needs to be called to continue

    bool _NegToPosInfinityFound;       // negative infinity before discontinuity pt. found
    bool _PosToNegInfinityFound;       // positive infinity before discontinuity pt. found
    bool _ReadNextPts;                 // Read next points of PtBufferSize in length
    bool _EOFreached;                  // End of file for the points on the graph reached.
    bool _DataRetrieved;               // Discontinuity data retrieved by calculator, referring _BasePtr.
    bool _DebugInfoShown;              // Debug info shown
    bool _ProcessedPointsShown;        // Processed points shown
    bool _ProcessedPointsCopied;       // Points copied to processed points buffer
    bool _PointsBufferFlushed;         // Points buffer flushed after processing of entire buffer finished

    GraphDiscontinuityDetector(PointsDoneNotifier<PRIM>* PtsDoneNotifier_,
                               ArrayResetNotifier<PRIM>* ResetNotifier_);

    void ShowPoints(const char* DelimStr_=",");
    int ShiftArrayPts(int PtsShifted_, int DiscPt_, bool& ReadAheadMoved_, bool ShowDonePts_=false);
    void FlushPointsBuffer();
    void FindTrendsToInfinity();
    void SetDiscontinuityNotFound();
    void TransferFromReadAheadBuffer(int shiftlen_, bool ShowDonePts_=false);

    bool ConfirmDiscontinuity(bool PosToNegDiscPtsFound_, bool NegToPosDiscPtsFound_,
                              bool SingleDiscOptional_, bool* SingleDisc_);
    int FindGreatestDiscontinuity(int discpt_, PRIM ptgapval_,
                                  int signchange_, int& direction_,
                                  int& incval_, int& flatval_, int& decval_);
    bool DetermineGraphEdges(int PendingPtsShift_);
    bool CheckIfFalling(int Index_, int& PtStrikes_);
    bool CheckIfRising(int Index_, int& PtStrikes_);
    bool ReadAheadBufferFilled();
    bool GraphPtsBufferFilled();

  public:
    class DataArrayStruct
    {
      private:
        GraphDiscontinuityDetector<WRAP, PRIM>* _Gdiscp;
        ArrayResetNotifier<PRIM>* _ResetNotifier;

        bool _ExtArrayCreated;
        bool _ExtArrayAvailable;

        PRIM* _ExtArray;       // external data array for refilling data points
        PRIM* _ArrStart;       // external array starting point
        PRIM* _Rdarr;          // external points storage buffer
        PRIM* _Endp;           // end point of external points storage buffer

        int _PtsInDataFile;    // total number of points in data file
        int _PtsArrMax;        // max size of external points storage buffer
        int _PtsConsumed;      // points consumed in current detector scan iteration
        int _TotalPtsConsumed; // points from external array consumed by discontinuity detector
        int _RemainingPts;     // number of points remaining in data file to be read

        bool _AutoReset;       // Auto reset detector scan and total points read after reading halfway point.
        bool _HalfBufferRead;  // Half of the points stored in the external points buffer is read.
        bool _IncrRdarrPtr;    // increment read ahead buffer pointer instead of moving points to buffer start
        bool _InitReadDone;    // Initial reading of points from the external points buffer done
        bool _NeedTerm;        // termination of read ahead buffer needed
        bool _NeedReset;       // reset of graph discontinuity detected object needed
        bool _Terminated;      // read ahead buffer padded with termination points
        bool _TermAck;         // array termination acknowledged
        bool _ResetDone;       // reset of total points read and detector done
        bool _ResetAck;        // points reset done acknowledged
        bool _Suspended;       // processing suspended for points refill of external array

        int _rdcnt;             // current points read
        int _nextrd;            // additional points read
        int _totalrd;           // grand total points read
        int _runtotal;          // running total that could be reset upon reaching a set limit

        int _gamax;             // graph points buffer max size, _Gdiscp base class pointer
        int _rdmax;             // read ahead buffer max size, _Gdiscp base class pointer

        bool InitialReadDone();
        bool CheckForFileEnd(int prevrd);

        DataArrayStruct(GraphDiscontinuityDetector<WRAP, PRIM>* Gdiscp_, PRIM* Extarr_, PRIM* Rdarr_,
                        int PtsInDataFile_, int PtsArrMax_, bool IncrRdarr_, int _gamax_, int _rdmax_);

      public:
        ~DataArrayStruct();

        static GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct*
          Make(GraphDiscontinuityDetector<WRAP, PRIM>* Gdiscp_, PRIM* Extarr_, PRIM* Rdarr_,
               int PtsInDataFile_, int PtsArrMax_, bool IncrRdarr_, int _gamax_, int _rdmax_)
          { return new GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct(Gdiscp_, Extarr_, Rdarr_, PtsInDataFile_,
                                                                               PtsArrMax_, IncrRdarr_, _gamax_, _rdmax_); }

        void SetExtArray(PRIM* Extarr_, bool RefillAvail_, int* Index_=NULL);
        void ResetData(bool HasExtarr_, PRIM* Rdarr_, bool IncrRdarr_, int PtsInDataFile_, int PtsArrMax_);

        bool ScanForDiscontinuity(bool* DiscFound_=NULL);
        bool UpdateDataArray();
        bool EndRefillExtArray();

        void InitialDataRead();
        void ResetTotalPointsRead(bool AckReset_);
        void TerminateReadAheadBuffer(bool AckTerm_);
        void ShowDebugInfo(bool ResetShown_=true);
        void ShowProcessedPoints(bool ResetShown_=true, const char* DelimStr_=",");
        void NotifyProcessedPoints();
		void SetOutputFile(const char* Filename_);
		ofstream* GiveOutputFile(bool* HasFout_=NULL);
        void ResetDebugInfoShown();
        void ResetProcessedPointsShown();
        void ArrayTerminationAck(bool ForceReset_=false);
        void ResetDoneAck(bool ForceReset_=false);

        bool DebugInfoShown() const;
        bool ProcessedPointsShown() const;
        bool HasProcessedPoints() const;
        bool LastScanPending() const;
        bool LastScanDone() const;
        bool ReadAheadBufferTerminated() const;
        bool DiscontinuityFound() const;
        bool DiscontinuityNotFound() const;

        int RefillExtArray(int BufSz_, PRIM* Buffer_, bool FillToBufSz_, int* BufIndex_=NULL);
        int RefillExtArray(PRIM Val_, int* BufIndex_=NULL);
        int ReadMorePoints() const;
        int TerminatedPts() const;
        int OverFlowedPoints() const;

        GraphPointsDoneArray<PRIM>* GiveProcessedPts();

        PRIM operator [] (size_t x) const;

        int UnfilledExtArrayPts() const
            { return (_ResetNotifier ? _ResetNotifier->UnfilledExtArrayPts():0); }
        bool ExtArrayFilled() const
            { return (_ResetNotifier ? _ResetNotifier->ExtArrayFilled():false); }

        void SetRefillAvailable(bool Refill_)
            { if (_ResetNotifier) _ResetNotifier->SetRefillAvailable(Refill_); }

        bool RefillAvailable() const
            { return (_ResetNotifier ? _ResetNotifier->RefillAvailable():false); }
        int PointsAvailable() const
            { return (_ResetNotifier ? _ResetNotifier->PointsAvailable():0); }

        void SuspendForPtsRefill(bool flag_=true)
            { _Suspended = flag_; }
        void SetAutoReset(bool Reset_)
            { _AutoReset = Reset_; }

        PRIM* GiveExtArray()
            { return _ExtArray; }
        PRIM* GiveReadArray()
            { return _Rdarr; }

        int PtsInDataFile() const
            { return _PtsInDataFile; }
        int ReadArrayMax() const
            { return _PtsArrMax; }
        int TotalPointsConsumed() const
            { return _TotalPtsConsumed; }
        int RemainingPoints() const
            { return _RemainingPts; }
        int PointsConsumed() const
            { return _PtsConsumed; }
        int GraphPtsBufferMax() const
            { return _gamax; }
        int ReadAheadBufferMax() const
            { return _rdmax; }

        bool SuspendedForPtsRefill() const
            { return _Suspended; }
        bool ShouldIncrementReadArrayPtr() const
            { return _IncrRdarrPtr; }
        bool ReadArrayTerminated() const
            { return (_Terminated && !_TermAck); }
        bool HalfBufferRead() const
            { return _HalfBufferRead; }
        bool AutoReset() const
            { return _AutoReset; }
        bool ResetDone() const
            { return (_ResetDone && !_ResetAck); }
    };

    ~GraphDiscontinuityDetector();

    #if DISCONTDETECT_USE_CALCBASE_CLASS
      static GraphDiscontinuityDetector<WRAP, PRIM>* Make(CalculatorBase* BasePtr_,
                                                          PointsDoneNotifier<PRIM>* PtsDoneNotifier_=NULL,
                                                          ArrayResetNotifier<PRIM>* ResetNotifier_=NULL);
    #else
      // testing with const char* instead of CalculatorBase*
      static GraphDiscontinuityDetector<WRAP, PRIM>* Make(const char* BasePtr_,
                                                          PointsDoneNotifier<PRIM>* PtsDoneNotifier_=NULL,
                                                          ArrayResetNotifier<PRIM>* ResetNotifier_=NULL);
    #endif // DISCONTDETECT_USE_CALCBASE_CLASS

    GraphDiscontinuityDetector<WRAP, PRIM>& SetEOFreached(bool reached_);
    GraphDiscontinuityDetector<WRAP, PRIM>& SetDataRetrieved(bool done_);

    void ShowDebugInfo(bool ResetShown_=true);
    void ShowProcessedPoints(bool ResetShown_=true, const char* DelimStr_=",");
    void NotifyProcessedPoints();

    bool ResetScan(bool ResetEOF_=false);
    bool DoScan();
    bool MarkDiscontinuityPoints(bool Retr_);

    bool ReadyForScan();
    bool ScanProcessDone();
    bool DiscontinuityFound();
    bool DiscontinuityNotFound();
    bool ShouldReadNextPoints();
    bool ReadBufferFull();
    bool NegToPosInfinityFound();
    bool PosToNegInfinityFound();

    PRIM* GiveBackPts(bool* Exists_=NULL);
    PRIM* GiveFrontPts(bool* Exists_=NULL);
    PRIM* GiveGraphPts()
        { return _GraphPtsBuffer; }

    PRIM operator [] (size_t x) const;

    void SetPointsDoneNotifier(PointsDoneNotifier<PRIM>* Notifier_);
    void SetArrayResetNotifier(ArrayResetNotifier<PRIM>* Notifier_);

    ArrayResetNotifier<PRIM>* GiveArrayResetNotifier()
        { return _ResetNotifier; }
    PointsDoneNotifier<PRIM>* GivePointsDoneNotifier()
        { return _PtsDoneNotifier; }
    GraphPointsDoneArray<PRIM>* GiveProcessedPts()
        { return _DonePtsArray; }

    PRIM GiveBackDiscontinuityPt(bool* Exists_=NULL);
    PRIM GiveFrontDiscontinuityPt(bool* Exists_=NULL);
    PRIM GiveInfinityPt(bool* Exists_=NULL);

    bool StoreNextPoints(int numpts_, PRIM* fptv_, int* ptsread_=NULL);
    bool AppendReadAheadBuffer(int numpts_, PRIM* fptv_, int* ptsread_=NULL);
    bool TerminateReadAheadBuffer(int* ptsterm_=NULL);

    void ResetDebugInfoShown()
        { _DebugInfoShown = false; }
    void ResetProcessedPointsShown()
        { _ProcessedPointsShown = false; }
    int BackDiscontinuityIndex() const
        { return _BackDiscontinuityIndex; }
    int FrontDiscontinuityIndex() const
        { return _FrontDiscontinuityIndex; }
    int OverFlowedPoints() const
        { return _OverFlowedPts; }
    int DiscontinuityCondition() const
        { return _DiscontinuityCond; }

    int ReadMorePoints() const
        { return _ReadMorePts; }
    int TerminatedPts() const
        { return _TerminatedPts; }
    bool ReadNextPoints() const
        { return _ReadNextPts; }
    bool DiscontinuityDetected() const
        { return (_InfinityPtFound || _SingleDiscAtEdge); }
    bool InfinityPtFound() const
        { return _InfinityPtFound; }
    bool TransferDone() const
        { return (_TransferDone && _TransferPts); }
    bool ScanningDiscontinuity() const
        { return _ScanningDiscontinuity; }
    bool EOFreached() const
        { return _EOFreached; }
    bool DataRetrieved() const
        { return _DataRetrieved; }
    bool ReadAheadBufferTerminated() const
        { return (_TerminatedPts > 0); }
    bool DebugInfoShown() const
        { return _DebugInfoShown; }
    bool ProcessedPointsShown() const
        { return _ProcessedPointsShown; }
    bool ProcessedPointsCopied() const
        { return _ProcessedPointsCopied; }
    bool PointsBufferFlushed() const
        { return _PointsBufferFlushed; }
    bool LastScanPending() const
        { return _LastScanPending; }
    bool LastScanDone() const
        { return _LastScanDone; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct AssignmentParsingData
{
  Boolean _FirstAlpha;
  Boolean _LastDollar;
  Boolean _AnsStrConstFound;
  Boolean _FracAnsConstFound;
  char _VarLetter;
  int _FirstQuotePos;
  int _LastQuotePos;

  AssignmentParsingData();
};

/****************************************************************************/
// Documented special cases for FunctionValidityChecker: Start
/*
DERIV: Derivative function

 syntax: DERIV(expr, varname, value) or
 DERIV(expr, varname, value, prec)

ignore: expr, varname
----------------------------------------------------------------------------------------------------
DERIV2: Second Derivative function

 syntax: DERIV2(expr, varname, value) or
 DERIV2(expr, varname, value, prec)

ignore: expr, varname
----------------------------------------------------------------------------------------------------
INTEG: Integral function

 syntax: INTEG(expr, varname, lower, upper) or
 INTEG(expr, varname, lower, upper, prec)

ignore: expr, varname
----------------------------------------------------------------------------------------------------
SOLVE: Root solve

 syntax: SOLVE(expr, varname, guess) or
 SOLVE(expr, varname, guess, lower, upper)

ignore: expr, varname
----------------------------------------------------------------------------------------------------
INTERSECT: Find intersections

 syntax: INTERSECT(expr, varname, lower, upper) or
 INTERSECT(expr1, expr2, varname, lower, upper)

ignore: expr, varname
ignore: expr1, expr2, varname
----------------------------------------------------------------------------------------------------
FMIN: Function minimum

 syntax: FMIN(expr, varname, lower, upper) or
 FMIN(expr, varname, lower, upper, exclopt, prec)

ignore: expr, varname, exclopt
----------------------------------------------------------------------------------------------------
FMAX: Function maximum

 syntax: FMAX(expr, varname, lower, upper) or
 FMAX(expr, varname, lower, upper, exclopt, prec)

ignore: expr, varname, exclopt
----------------------------------------------------------------------------------------------------
FRAC: Fraction arithmetic

 syntax: FRAC({Add|Subtract|Multiply|Divide|+|-|*|/}, frac 1, frac 2, frac 3 ...)

ignore: {Add|Subtract|Multiply|Divide|+|-|*|/}
----------------------------------------------------------------------------------------------------
GRAPH : Displays a two dimensional cartesian graph of the results of a function performed on an expression (not available in text mode).

 syntax:
 GRAPH(expr, varname) or
 GRAPH FMIN(...) or
 GRAPH FMAX(...) or
 GRAPH DERIV(...) or
 GRAPH INTEG(...) or
 GRAPH INTERSECT(...) or
 GRAPH SOLVE(...)

ignore: expr, varname
----------------------------------------------------------------------------------------------------
SET: Create a set of positive integers

 syntax: SET(letter) or
 SET(letter, {integer 1, integer 2, integer 3 ...} )
 SET(letter1, letter2) or
 SET(letter, <filename>) or
 SET(letter, size, integer 1, integer 2, integer 3 ...)

Examples:
  set(a,4,1,2,3,5);
  set(b,4,3,5,6,7);
  set(c,a);
  set(d);
  set(e,{ 10,11,12,13 });
  set(f,sampleset1.cin);
  set(g,sampleset2.cin);

ignore: letter, <filename>, {...}
----------------------------------------------------------------------------------------------------
SETUNI: Perform a set union operation on two positive integer sets
 SETUNI(A,B,C), will assign to set A: B u C,
 u: denotes set union

 syntax: SETUNI(target_letter, set_letter1, set_letter2)

Example:
  setuni(i,d,a);

ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETINT: Perform a set intersection operation on two positive integer sets
 SETINT(A,B,C), will assign to set A: B n C,
 n: denotes set intersection

 syntax: SETINT(target_letter, set_letter1, set_letter2)

Example:
  setint(c,b,d);

ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETDIF: Perform a set difference operation on two positive integer sets
 SETDIF(A,B,C), will assign to set A: B - C

 syntax: SETDIF(target_letter, set_letter1, set_letter2)

Examples:
  setdif(c,f,g);
  setdif(i,b,a);
  setdif(a,d,f);
  setdif(b,g,d);

ignore: all function parameters
----------------------------------------------------------------------------------------------------
SETXDIF: Perform a symmetric set difference operation on two positive integer
 sets. SETXDIF(A,B,C), will assign to set A: (B u C) - (B n C),
 u: denotes set union,
 n: denotes set intersection

 syntax: SETXDIF(target_letter, set_letter1, set_letter2)

Example:
  setxdif(h,f,g);

ignore: all function parameters
----------------------------------------------------------------------------------------------------
ITEMCOMB: Combinations of unique dataset items

 syntax: ITEMCOMB(sel, item 1, item 2, item 3 ...)

ignore: item 1, item 2, item 3 ...
----------------------------------------------------------------------------------------------------
ITEMPERM: Permutations of dataset items

 syntax: ITEMPERM(sel, item 1, item 2, item 3 ...)

ignore: item 1, item 2, item 3 ...
----------------------------------------------------------------------------------------------------
ITEMCOMBREP: Combinations with repetition of dataset items

 syntax: ITEMCOMBREP(sel, item 1, item 2, item 3 ...)

ignore: item 1, item 2, item 3 ....
----------------------------------------------------------------------------------------------------
ITEMPERMREP: Permutations with repetition of dataset items

 syntax: ITEMPERMREP(sel, item 1, item 2, item 3 ...)

ignore: item 1, item 2, item 3 ....
----------------------------------------------------------------------------------------------------
EVAL: Evaluation of the contents of string variables

 syntax: EVAL(x)

ignore: all function parameters
----------------------------------------------------------------------------------------------------
SHOW: Show the contents of string variables including any variables
 nested within them

 syntax: SHOW(x)

ignore: all function parameters
----------------------------------------------------------------------------------------------------
SHOWSET: Show the contents of a string variable containing a set of
 positive integers in standard set notation.

 syntax: SHOWSET(x)

Examples:
  showset($h);
  showset($c);
  showset($x);

ignore: all function parameters
----------------------------------------------------------------------------------------------------
EXEC: Executes a pre-written calculator program saved in a file. All calculator program files must
      have the extension ".prg" The name of the program passed to the EXEC command is simply the
      file name excluding the extension, so if you want to execute the program in the file
      "sample.prg" for example, you enter "EXEC sample" into the calculator

 syntax: EXEC name OR
 EXEC name.in OR
 EXEC name.in,pause OR
 EXEC name.in,nopause

ignore: all strings
----------------------------------------------------------------------------------------------------
E: Scientific notation of number
syntax: x E n
Returns x * 10^n, number x multiplied by 10 raised to the power of n

ignore: notation E
----------------------------------------------------------------------------------------------------

Max special cases = 25

cases:
  Special functions
  Special constants
  Special notation
  Special program name
  Special predefined calculator variable
  Special function variable
  Special permutation item: "Item 1", "Item 2", "Item 3" ...
  Special Expression
  Special exclopt
  Special Frac ops: Add|Subtract|Multiply|Divide
  Special <filename>
  Special set letter: A, B, C ...
  Special set braces { ... }
  Special all function parameters
  Special constants: PI, E
  Special multiple decimal points ..
  Special scientific notation indicator: 10E+3

special key words:
  ITEMPERMREP
  ITEMCOMBREP
  INTERSECT
  ITEMPERM
  ITEMCOMB
  SETXDIF
  SHOWSET
  DERIV2
  SETUNI
  SETINT
  SETDIF
  DERIV
  INTEG
  SOLVE
  GRAPH
  FMIN
  FMAX
  FRAC
  EVAL
  SHOW
  EXEC
  SET
*/
// Documented special cases for FunctionValidityChecker: End

class FunctionValidityChecker
{
  protected:
    enum
    {
      MAX_EXCLUDED_FNCS    = 14,
      MAX_SINGLEARG_FNCS   = 24,
      MAX_DOUBLEARG_FNCS   = 14,
      MAX_TRIPLEARG_FNCS   = 7,
      MAX_FOURARG_FNCS     = 6,
      MAX_FIVEARG_FNCS     = 5,
      MAX_SIXARG_FNCS      = 2,
      MAX_VARYARG_FNCS     = 16,
      MAX_MULTIARG_FNCS    = 8,
      MAX_MULTIARG_CHKS    = 9,
      MAX_UNARY_OPS        = 32,
      MAX_BINARY_OPS       = 28,
      MAX_FRAC_OPS         = 8,
      MAX_CONSTANTS        = 56,
      MAX_ALMOST_FNCS      = 58,
      MAX_SPECIAL_CASES    = 23,
      MAX_VARX_FNCS        = 8,
      MAX_CHKFNCPREC_FNCS  = 16,
      FNCVALID_MAXTOCHECK  = 17,

      DEFCONSTS_START      = 4,     // Defined constants: (PI, e, inf, nan)
      MAXDEFCONSTS         = 6,     // Maximum number of defined constants
      VARNAME_START        = 10,    // Start index of: ($A...$Z)
      CONSTVALUE_START     = 36,    // MAX_CONSTANT - 20
      ASSIGNOP_START       = 12,    // Assignment operators: (-=,+=,*=,/=...)
      MAXASSIGNOPS         = 8,     // Maximum number of assignment operators

      BINARYOPS_START      = 4,     // Binary operators start: (XOR,AND,OR,E,<=,>=,==,!=,...)
      UNARYOPS_START       = 28,    // Unary operators start: (GRAPH,NOT,+,-)
    };

    enum
    {
      // Default list size increment
      LISTINCR             = 10,

      // Token typs
      CONSTANT_TOKEN       = 1,     // constant operand (PI, e)
      VALUE_TOKEN          = 2,     // value operand (1,2,3...)
      VARIABLE_TOKEN       = 4,     // variable operand ($A...$Z,ans,fracans,ansstr)
      FUNCTION_TOKEN       = 8,     // function name (MIN,MAX,CUBE...)
      OPERATOR_TOKEN       = 16,    // operator (+,-,*,/)
      GROUP_TOKEN          = 32,    // grouping bracket (), [], {}

      // Expression specifiers
      OPERANDVAL           = 128,   // non-const operand
      CONSTVAL             = 256,   // const operand
      UNARYEXPR            = 512,
      BINARYEXPR           = 1024,

      // bracket specifiers
      LEFT_BRACKETS        = 2048,  // left brackets : (, [, {
      RIGHT_BRACKETS       = 4096,  // right brackets : ), ], }
      LEFT_BRACE           = 8193,  // {
      RIGHT_BRACE          = 8194,  // }
      QUOTE_CHAR           = 16385, // "

      // Function precision check, special condition
      CHKFNCPREC_INIT      = 0,
      CHKFNCPREC_YES       = 1,
      CHKFNCPREC_NO        = 2,

      // String check special cases:
      SPC_FUNCTIONS             = 1,
      SPC_CONSTANTS		= 2,
      SPC_NOTATION		= 4,
      SPC_IDENTIFIER		= 8,
      SPC_EXPRESSION		= 16,

      SPC_PROGRAMNAME		= 32,
      SPC_PREDEFINEDVARS	= 64,
      SPC_FUNCTIONVARS		= 128,
      SPC_ITEMFUNCTION_ITEMVARS = 256,
      SPC_FILENAME		= 512,
      SPC_SETLETTER		= 1024,

      SPC_EXCLOPT		= 2048,
      SPC_FRACOPS		= 4096,
      SPC_SETBRACES		= 8192,
      SPC_ALLFUNCTIONPARAMS	= 16384,
      SPC_MULTDECIMALPTS	= 32768,

      NO_PARAMS                 = -5,
      PARAM_ALLSTRINGS          = -4,
      PARAM_CONTINUE_ALL        = -3,
      PARAM_CONTINUE_NONE       = -2,
      PARAM_END                 = -1,

      NOT_EXCLUDEDCASE          = -1,
      NOT_SPECIALCASE           = -1,
      INQUOTES_SPECIALCASE      = -2,
      INBRACES_SPECIALCASE      = -3,
      INBRACKETS_SPECIALCASE    = -4,
      CONSTANDVARS_SPECIALCASE  = -5,
      UNARYOPLIST_SPECIALCASE   = -6,
      BINARYOPLIST_SPECIALCASE  = -7,

      // Token subtype
      SINGLEARGFNC         = 1,
      DOUBLEARGFNC         = 2,
      TRIPLEARGFNC         = 4,
      FOURARGFNC           = 8,
      FIVEARGFNC           = 16,
      SIXARGFNC            = 32,
      VARYARGFNC           = 64,
      BINARY_OPERATOR      = 128,   // binary operator (+,-,*,/,@,^,<,>)
      BINARY_FUNCTION      = 256,   // binary function (COMBREP,PERMREP,COMB,PERM,XOR,AND,<=,>=,==,!=,OR,E)
      UNARY_OPERATOR       = 512,   // unary operator (+,-)
      UNARY_FUNCTION       = 1024,  // unary function (SIN,COS,TAN,SQRT,FACT...)
      POSTFIX_OPERATOR     = 2048,  // postfix operator : %
      BRACKETEDEXPR        = 4096,  // matching left-right bracket pair : (,)
      OPERAND              = 8192,  // standard operand

      WHITESPACE_CHARS     = 16384  // white space characters : " \t\r\n"
    };

    static int _Debugging;
    static int _Instances;
    static int _FncPrecChk;

    CalculatorBase* _Parent;
    FunctionValidityChecker* _Next;
    FunctionValidityChecker* _Caller;

    FunctionValidityChecker* _SavedSnapshot;
    FunctionValidityChecker* _SnapshotOwner;

    FunctionValidityChecker* _Adjacent;
    FunctionValidityChecker* _Sibling;
    bool _HasSibling;
    int* _SiblingIndexes;
    int _SiblingIndexSize;

    const char* _LineRemaining;
    const char* _LineToProcess;
    const char* _OriginalLine;
    bool _OperandRequired;
    bool _NextOperandRequired;

    int _TokenType;
    int _TokenSubtype;
    int _Levels;
    bool _Valid;
    int _Checked;
    int _MaxToCheck;
    int _LineNumber;
    int _StopOnNumber;

    int* _commaindexes;
    int _commaindexsize;

    const char* _startpt;
    const char* _openbrkpt;
    const char* _closebrkpt;
    const char* _endpt;
    char* _ChkStrOmitTxtStr;
    char* _OriginalStr;

    int _openbrkcnt;
    int _closebrkcnt;

    static char** _ErrorMessageList;
    static char** _SingleArgFncList;
    static char** _DoubleArgFncList;
    static char** _TripleArgFncList;
    static char** _FourArgFncList;
    static char** _FiveArgFncList;
    static char** _SixArgFncList;
    static char** _VaryArgFncList;
    static char** _MultiArgFncList;
    static char** _AlmostFncList;
    static char** _FracOpList;
    static char** _UnaryOpList;
    static char** _BinaryOpList;
    static char** _ConstsAndVars;
    static char** _ExcludedFncList;
    static char** _SpecialCaseList;
    static char** _VarxFncList;
    static char** _ChkFncPrecList;
    static int** _MultiArgChkList;

    static char** _NumberStrs;
    static int _NumberListSize;
    static int _NumNumbers;

    static int _MaxWholeDigits;
    static int _MaxSigDigits;
    static int _MaxDecDigits;
    static int _LargestNumIndex;
    static bool _DecPtFound;

    bool _SingleArgFnc;
    bool _DoubleArgFnc;
    bool _TripleArgFnc;
    bool _FourArgFnc;
    bool _FiveArgFnc;
    bool _SixArgFnc;
    bool _VaryArgFnc;
    bool _FncPrecForSingleArgFncs;
    bool _FncPrecForVaryArgFncs;

    bool _IgnoredCmd;
    bool _IsOperand;
    bool _IsConstVal;
    bool _IsOperandVal;
    bool _IsUnaryExpr;
    bool _IsBinaryExpr;
    bool _BracketedExpr;
    bool _OperandNeeded;
    bool _FunctionMatched;
    bool _FracOpFound;
    bool _VarxAllowed;

    int _ErrorCode;
    bool _ChkFrac;

    short* _ChkStrCase;
    BitVector* _ChkStrOmit;
    short* _ChkStrCasePtr;
    BitVector* _ChkStrOmitPtr;
    int _AbsChkStrIndex;
    int _SavedChkStrIndex;
    int _RelChkStrIndex;
    int _LastChkStrIndex;
    int _ChkStrSize;
    int _SpecialCaseIndex;
    int _SpecialCaseLen;
    int _ExcludedCaseIndex;
    int _ExcludedCaseLen;
    bool _LastChkStrIndexSaved;

    int* _AbsStrPosIndexes;
    int _AbsStrPosIndexSize;
    int* _SiblingAbsStrPosIndexes;
    int _SiblingAbsStrPosIndexSize;

    // delayed memory deleter
    DelayedMemoryDeleter* _MemDel;

    static int GrowNumberStrList(CalculatorBase* Parent_);
    static void ClearNumberStrList(CalculatorBase* Parent_);
    static char* AddNumberStr(CalculatorBase* Parent_, const char* str);
    static int FindLargestNum(const char* str);

    static bool CreateStaticMembers(CalculatorBase* Parent_);
    static bool DestroyStaticMembers(CalculatorBase* Parent_);
    static void SetChkFncPrec(bool v, bool Reset_=false);
    static void ResetMultiArgChks();

    FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker& Obj_);
    FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker* Caller_, int* delimpts_, int* absstrpospts_);
    FunctionValidityChecker(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                            FunctionValidityChecker* Adjacent_, int* delimpts_, int* absstrpospts_);

    FunctionValidityChecker* MakeNextLevel(CalculatorBase* Parent_, FunctionValidityChecker* Caller_, int* delimpts_, int* absstrpospts_);
    FunctionValidityChecker* MakeSibling(CalculatorBase* Parent_, FunctionValidityChecker* Caller_,
                                         FunctionValidityChecker* Adjacent_, int* delimpts_, int* absstrpospts_);

    inline bool HasSibling(FunctionValidityChecker* Caller_) const
        { return (_SiblingIndexes &&
                  _SiblingIndexes[0] &&
                  _endpt && _endpt != Caller_->_closebrkpt-1); }
    inline int IsFunction(int TokType_, int TokSubtype_) const
        { return (TokType_ == FUNCTION_TOKEN ||
                  (TokSubtype_ == UNARY_FUNCTION ||
                   TokSubtype_ == BINARY_FUNCTION)); }
    inline int IsOperator(int TokType_, int TokSubtype_) const
        { return (TokType_ == OPERATOR_TOKEN ||
                  (TokSubtype_ == UNARY_OPERATOR ||
                   TokSubtype_ == BINARY_OPERATOR)); }

    inline int AbsPosIndex() const
        { return _AbsChkStrIndex; }
    inline int RelPosIndex() const
        { return _RelChkStrIndex; }

    inline int* CommaIndexes()
        { return _commaindexes; }
    inline int* AbsStrPosIndexes() const
        { return _AbsStrPosIndexes; }
    inline int* SiblingAbsStrPosIndexes() const
        { return _SiblingAbsStrPosIndexes; }

    inline int CommaIndexSize() const
        { return _commaindexsize; }
    inline int AbsStrPosIndexSize() const
        { return _AbsStrPosIndexSize; }
    inline int SiblingAbsStrPosIndexSize() const
        { return _SiblingAbsStrPosIndexSize; }

    inline void SetFracOpFound(bool flag_)
        { _FracOpFound = flag_; }
    inline bool FracOpFound() const
        { return _FracOpFound; }
    inline void SetChkFrac(bool flag_)
        { _ChkFrac = flag_; }
    inline int SiblingIndexSize() const
        { return _SiblingIndexSize; }
    inline void SetCaller(FunctionValidityChecker* ptr)
        { _Caller = ptr; }
    inline const char* GetStartPt() const
        { return _startpt; }
    inline const char* GetEndPt() const
        { return _endpt; }
    inline int GetStrLen() const
        { return (_startpt ? (_endpt ? (_endpt - _startpt + 1):strlen(_startpt)):0); }
    inline bool LastChkStrIndexSaved() const
        { return _LastChkStrIndexSaved; }
    inline bool ChkFncPrecForSingleArgFncsDone() const
        { return _FncPrecForSingleArgFncs; }
    inline void SetFncPrecForSingleArgFncsDone(bool flag_)
        { _FncPrecForSingleArgFncs = flag_; }
    inline bool ChkFncPrecForVaryArgFncsDone() const
        { return _FncPrecForVaryArgFncs; }
    inline void SetFncPrecForVaryArgFncsDone(bool flag_)
        { _FncPrecForVaryArgFncs = flag_; }

    bool CheckSpecialCase_Set(const char* str, int len=-1);
    bool CheckSpecialCase_ItemFncs(const char* str, int len=-1);

    bool CheckExcludedCase_Precision(const char* str, int len=-1);
    bool CheckExcludedCase_MatSolve(const char* str, int len=-1);

    char* RemoveAndOpStr(const char* str, int& AndIndex_, bool& AndFound_);

    void SaveSnapshot();
    void RestoreSnapshot();
    bool SaveLastSpecialIndexPos();
    bool RestoreLastSpecialIndexPos();
    int IncrSpecialCaseIndexes();
    int DecrSpecialCaseIndexes();
    void SetAbsPosIndex(int x, bool setomit_, int v);
    bool SaveSpecialCaseIndexes();
    bool RestoreSpecialCaseIndexes();
    int* OmitSpecialCases(int numargs_);
    bool OmitSpecialParams(int* ParamArray_, int brkbal, int& p, char c=0);
    int SetChkStrOmit(int x, int v);
    int SetChkStrOmitFromStart(int v);
    int GetChkStrOmit(int x) const;
    bool CompareLastSpecialIndexPos(int cprocessed_, bool Adjust_,
                                    bool Report_, int Stream_=2);

    void ResizeCommaIndexes();
    void ResizeAbsStrPosIndexes();
    void ResizeChkStrOmit(int max);

    bool StrFits(const char* str, int len);
    int FindSiblingIndexSize();
    void SetTokenType(int TokType_, int TokSubtype_, int ExprType_,
                      bool ChkOpNeeded_=false, bool OpNeeded_=false);
    bool ChkNextToken(int TokType_, int TokSubtype_, int ExprType_,
                      int OpIndex_=-1, int OpType_=0);
    void SetNext(FunctionValidityChecker* ptr);
    void SetSibling(FunctionValidityChecker* ptr, int* delimpts_, int* absstrpospts_);
    void SetAdjacent(FunctionValidityChecker* ptr, int* delimpts_, int* absstrpospts_);
    bool IsUndefinedFncCall(const char* str, int& tlen_);
    bool IsAssignOps(const char* str, int& tlen_);
    bool NextOperator(const char* str, int OpType_, int& pos,
                      int& tlen_, bool SkipOnlyWs_, int* Index_=NULL);
    bool NextOpenBrk(const char* str, int& pos, bool SkipOnlyWs_);
    bool NextCloseBrk(const char* str, int& pos, bool SkipOnlyWs_);
    bool NextAssignOps(const char* str, int& pos, int& tlen_, bool SkipOnlyWs_);
    bool CheckForMatch(const char* trg, const char* src, int max);
    bool FindForwardChar(const char* str, int x, char ch,
                         bool csense_=true, bool brkonnonspc_=true);
    bool FindBackChar(const char* str, int x, char ch,
                      bool csense_=true, bool brkonnonspc_=true);
    void ConfirmAsValid();
    void ConfirmAsInvalid();
    void ConfirmAsMatched();

    void ResetErrors();
    void ResetAllVars();
    void ResetCheckVars(bool resetchk_);
    void ResetOperandRequired();
    void SetErrorCode(int Code_);
    void SetLineRemaining(const char* str);
    void SetLineToProcess(const char* str, bool Reset_);
    char* ExtractNumStr(const char* str, int& ptrdiff_);
    char* MakeStrSegment(char* NewLine_, int PrevLen_);
    void ShowDebugInfo();

    bool HasVarArgFncName(const char* str, int numargs_, int len=-1);
    bool ChkIfBalancedBrk(const char* str, int len=-1);
    bool ChkIfInQuotes(const char* str, int len=-1);
    bool ChkIfFileName(const char* str, int len=-1);
    bool ChkIfExcludedFncs(const char* str, int len=-1);
    bool ChkIfBracedExpr(const char* str, int len=-1);
    bool ChkIfInvalidFncs(const char* str, int len=-1);
    bool ChkIfInvalidVars(const char* str, int len=-1);
    bool ChkIfInvalidChars(const char* str, int len=-1);
    bool ChkIfValidNumber(const char* str, int& testlen_, char** teststr_=NULL);

    bool ChkIfVarxFncs(const char* str);
    bool ChkIfChkFncPrecFncs(const char* str);
    bool ChkIfBracketedExpr(const char* str, int len=-1);
    bool ChkIfSingleArgFncs(const char* str, int len=-1);
    bool ChkIfDoubleArgFncs(const char* str, int len=-1);
    bool ChkIfTripleArgFncs(const char* str, int len=-1);
    bool ChkIfFourArgFncs(const char* str, int len=-1);
    bool ChkIfFiveArgFncs(const char* str, int len=-1);
    bool ChkIfSixArgFncs(const char* str, int len=-1);
    bool ChkIfVaryArgFncs(const char* str, int len=-1);
    bool ChkIfGraphSpecialCase(const char* str, int len=-1);
    bool ChkFollowGraphFncs(const char* str, int len=-1);

    bool ChkIfOperand(const char* str, int len=-1);
    bool ChkIfFracOp(const char* str, int len=-1);
    bool ChkIfUnaryExpr(const char* str, bool& OperandNeeded_, int len=-1);
    bool ChkIfBinaryExpr(const char* str, bool& OperandNeeded_, int len=-1);
    bool ChkIfFunctionValid(const char* str, bool Reset_=true, int len=-1);
    bool ChkIfSpecialCase(char** FncList_, int x, int len, int sch=0, int ech=0);

  public:
    enum
    {
      // Error codes
      ERRCODE_INVALID_FUNCTIONS_FOUND    = 1,
      ERRCODE_INVALID_VARIABLES_FOUND    = 2,
      ERRCODE_MISSING_RIGHT_BRACKET      = 4,
      ERRCODE_MISSING_LEFT_BRACKET       = 8,
      ERRCODE_FRACTION_OPERATOR_EXPECTED = 16,
      ERRCODE_MISSING_RIGHT_BRACE        = 32,
      ERRCODE_MISSING_CLOSING_QUOTE      = 64,
      ERRCODE_REQUIRED_OPERAND_MISSING   = 128,
      ERRCODE_INVALID_EXPR_FOUND         = 256,
      ERRCODE_MISPLACED_COMMA            = 512,

      MAX_ERROR_CODES = 10
    };

    FunctionValidityChecker(CalculatorBase* Parent_);
    ~FunctionValidityChecker();

    static bool IsNullSet(const char* str);
    static void SetDebugging(bool flag_);
    static bool ChkNoFncPrec();
    static bool ChkYesFncPrec();

    static const char* GetNumberStr(int index_);
    static void PrintNumberStrList(CalculatorBase* Parent_,
                                   bool All_, int index_, char Delim_='\n');

    static int NumNumbers();
    static int MaxWholeDigits();
    static int MaxSigDigits();
    static int MaxDecDigits();
    static int LargestNumIndex();
    static bool DecPtFound();

    int TranslateErrorCode(int ErrCode_) const;
    bool ChkIfMathLineValid(const char* str=NULL, bool Reset_=true, int len=-1, bool debug_=false);
    bool HasInvalidTokens() const;
    const char* GiveErrorMessage() const;
    const char* ChkStrOmitToTxtStr();
    void SetLineNumber(int line_, int stopon_=0, bool debug_=false);

    inline void Reset(bool resetchk_)
        { ResetCheckVars(resetchk_); }
    inline bool Confirmed() const
        { return (_Checked == _MaxToCheck); }
    inline bool ConfirmedValid() const
        { return (_Valid && _Checked == _MaxToCheck); }
    inline bool ConfirmedInvalid() const
        { return (!_Valid && _Checked == _MaxToCheck); }
    inline bool ConfirmedMatched() const
        { return (_FunctionMatched && _Checked == _MaxToCheck); }
    inline bool HasLineRemaining() const
        { return (_LineRemaining && _LineRemaining[0] &&
                  _LineToProcess <= _LineRemaining &&
                  _LineRemaining[0] != MATHSTATEMENT_TERMCHAR); }

    inline int GiveErrorCode() const
        { return _ErrorCode; }
    inline bool InvalidFncsFound() const
        { return (_ErrorCode & ERRCODE_INVALID_FUNCTIONS_FOUND); }
    inline bool InvalidVarsFound() const
        { return (_ErrorCode & ERRCODE_INVALID_VARIABLES_FOUND); }
    inline bool MissingRightBrk() const
        { return (_ErrorCode & ERRCODE_MISSING_RIGHT_BRACKET); }
    inline bool MissingLeftBrk() const
        { return (_ErrorCode & ERRCODE_MISSING_LEFT_BRACKET); }
    inline bool MissingBrkError() const
        { return ((_ErrorCode & ERRCODE_MISSING_RIGHT_BRACKET) ||
	          (_ErrorCode & ERRCODE_MISSING_LEFT_BRACKET)); }
    inline bool FracOpExpected() const
        { return (_ErrorCode & ERRCODE_FRACTION_OPERATOR_EXPECTED); }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class CalcGraphPlotter;
class SubExpression;

class CalcGlobalSwitch
{
  protected:
    char* _MathExprLine;
    char* _SwitchStr;
    int* _GlobalSwitchFlag;

    int _NextSwitchStrIndex;
    int _SwWordMult;
    int _NoSwitchPosShift;
    int _SearchStrIndex;

    bool _LeftBrk;
    bool _SwitchChkDone;
    bool _SwitchCmdFound;
    bool _SwitchCmdIgnored;
    bool _SearchResetDone;

    char* _SwitchStart;
    char* _SwitchExt;
    char* _LeftBrkStart;
    char* _EndBrkStart;
    char* _PostSwitchStart;

    char* FindEndBrk(bool LbFound_, char* str);
    char* FindPostSwitchStart(char* str);

  public:
    CalcGlobalSwitch();
    ~CalcGlobalSwitch();

    CalcGlobalSwitch* SetGlobalSwitchAddress(int* addr);
    CalcGlobalSwitch* SetGlobalSwitchProcessed(int v);
    CalcGlobalSwitch* ResetSwitchCheckDone();
    CalcGlobalSwitch* ResetSwitchCheckData();
    CalcGlobalSwitch* SetGlobalSwitch(const char* SwitchStr_);
    CalcGlobalSwitch* SetMathExprLine(char* Line_);
    CalcGlobalSwitch* SetExprLineIndex(int v);

    bool CheckForSwitch(bool SwitchFound_);
    void PrintAllData(ostream& os);

    void SetSwitchCmdFound(bool v);
    void SetSwitchCmdIgnored(bool v);

    inline bool SwitchCheckDone() const
        { return _SwitchChkDone; }
    inline bool SwitchCmdFound() const
        { return _SwitchCmdFound; }
    inline bool SwitchCmdIgnored() const
        { return _SwitchCmdIgnored; }
    inline bool HasLeftBrk() const
        { return _LeftBrk; }
    inline bool SearchResetDone() const
        { return _SearchResetDone; }

    inline int SwitchWordMultiples() const
        { return _SwWordMult; }
    inline int LastSwitchStrIndex() const
        { return ((_SwitchChkDone && _SwitchCmdFound) ? _NextSwitchStrIndex:0); }
    int PosShiftToNoSwitchStr(bool DecLoopIndex_) const;

    inline const char* GetMathExprLine() const
        { return _MathExprLine; }

    inline char* GetSwitchStart()
        { return _SwitchStart; }
    inline char* GetSwitchExt()
        { return _SwitchExt; }
    inline char* GetLeftBrkStart()
        { return _LeftBrkStart; }
    inline char* GetEndBrkStart()
        { return _EndBrkStart; }
    inline char* GetPostSwitchStart()
        { return _PostSwitchStart; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class ExpressionGraphStack
{
  protected:
    SubExpression* _Parent;
    ExprStringStack* _Stack;
    CalcGraphPlotter* _Plotter;
    CalculatorBase* _CalcPtr;

    bool _OwnsStack;

    void DestroyExpressionStack(bool IsParent_);

  public:
    ExpressionGraphStack(SubExpression* Parent_,
                         CalcGraphPlotter* CalcPlot_=NULL,
                         ExprStringStack* Stack_=NULL,
                         bool OwnsStk_=false);
    ~ExpressionGraphStack();

    void SetCalculator(CalculatorBase* CalcPtr_);
    void SetStringStack(ExprStringStack* Stack_, bool OwnsStk_);
    void SetGraphPlotter(CalcGraphPlotter* CalcPlot_);
    bool HasExpression(const char* Ptr_, int* Index_);
    bool HasAnyExpr() const;

    ExpressionGraphStack* CreateExpressionStack(int Size_=0);
    ExpressionGraphStack* GrowExpressionStack(int Size_=0);
    ExpressionGraphStack* ClearExpressionStack(CalculatorBase* Calcp_=NULL);
    SubExpression* GiveParent();

    const char* PushGraphExpression();
    const char* PopGraphExpression(CalculatorBase* Calcp_=NULL);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class SubExpression
{
  friend class FunctionCall;
  friend class CalcGlobalSwitch;
  friend class ExpressionGraphStack;

  protected:
    CalculatorBase* _CalcPtr;
    CalculatorBase* _PrevCalc;
    SubExpression* _Parent;
    CalcGraphPlotter* _GraphPlotter;
    CalcGlobalSwitch* _GlobalGraphSwitch;
    CalcGlobalSwitch* _GlobalExecSwitch;
    ExpressionGraphStack* _GpExprStack;

    int _CalcNumber;
    int _Level;
    char** _FunctionNames;
    char* _Expression;
    char* _AnswerStr;
    char* _OriginalStr;
    char* _ProgramName;
    FunctionCall** _FncCalls;
    int _AnswerMode;
    int _NumFncNames;
    int _NumFncCalls;
    int _ArrayLimit;
    int _ShortestName;

    Boolean _HasErrors;      // new
    Boolean _QuitGraph;      // new
    Boolean _MathLineValid;  // new
    Boolean _IsParam;
    Boolean _NoReturns;
    Boolean _HasAnswer;
    Boolean _ShowAnswer;
    Boolean _SingleFncCall;
    Boolean _ShowFunction;
    Boolean _ShowSetFunction;
    Boolean _ExecCmdWasFound;
    Boolean _GraphCmdWasFound;
    Boolean _FunctionSearchInProgress;
    Boolean _FunctionValidityChkNeeded;
    Boolean _FunctionValidityChkDone;

    static int _ExecCmdProcessed;
    static int _GraphCmdProcessed;

    // delayed memory deleter
    DelayedMemoryDeleter* _MemDel;

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      mutable ChrString _RetExpression;
      mutable ChrString _RetAnswerStr;
      mutable ChrString _RetOriginalStr;
      mutable ChrString _RetProgramName;
    #endif

    void ResetGraphVars();
    void ResetCalcStateVars();
    void SetGraphCmdWasFound(bool flag_);
    void SetExecCmdWasFound(bool flag_);

    bool GraphCmdFound() const;
    bool ExecCmdFound() const;

    bool IsPlotCompleted() const;
    bool NotGraphOp() const;
    bool IsGraphOp() const;
    bool NotInGraphOp() const;
    bool InGraphOp() const;
    bool IsSubstTokenStr(const char* sublist, int len);
    const char* GetExprToGraph() const;
    const char* GetExprToReplace() const;
    CalcGraphPlotter* GetGraphPlotter();
    void SetGraphPlotter(CalcGraphPlotter* Plot_);
    void AssignExpression(char** TrgStr_);
    void AssignExpression(char* Expr_, bool MemErase_);
    void StartGraphPlotting();
    void EndGraphPlotting(bool Destruct_=false);

    void ResizeArray();
    void AddFunctionCall(char* FncCall_, int* DelimArray_);
    char* SubExpressionTag(int FncIndex_, char* SrcExpr_, const char* AnswerStr_);
    void SubstFncAnswer(int FncIndex_);
    void SubstFncOriginal(int FncIndex_);
    static char* AllocateNewString(DelayedMemoryDeleter* MemDel_, char* Buffer_,
                                   size_t NewLen_, bool DelOld_, bool AlwaysNew_);

  public:
    SubExpression();
    SubExpression(SubExpression* Parent_, int Level_, const char* Expr_);
    SubExpression(const SubExpression& Obj_);
    ~SubExpression();

    void SetCalculator(CalculatorBase* CalcPtr_);
    CalculatorBase* GetCalculator();
    int GetCalculatorNumber() const;

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      ChrString& GetOriginalChrStr() const;
      ChrString& GetExpressionChrStr() const;
      ChrString& GetAnswerChrStr() const;
      ChrString& GetProgramNameChrStr() const;
    #endif

    const char* GetOriginal(ChrString* ret=NULL) const;
    const char* GetExpression(ChrString* ret=NULL) const;
    const char* GetAnswer(ChrString* ret=NULL) const;
    const char* GetProgramName(ChrString* ret=NULL) const;

    const SubExpression* ParentExpression() const
        { return _Parent; }
    SubExpression* ParentExpression()
        { return _Parent; }

    Boolean HasErrors() const        // new
        { return _HasErrors; }
    Boolean QuitGraph() const        // new
        { return _QuitGraph; }
    Boolean MathLineValid() const    // new
        { return _MathLineValid; }
    Boolean Destroyed() const
        { return (_MemDel ? _MemDel->Destroyed():TRUE); }
    Boolean ShowAnswer() const
        { return _ShowAnswer; }
    Boolean IsParam() const
        { return _IsParam; }
    Boolean HasAnswer() const
        { return _HasAnswer; }
    Boolean NoReturns() const
        { return _NoReturns; }
    Boolean FunctionSearchInProgress() const
        { return _FunctionSearchInProgress; }
    int GetLevel() const
        { return _Level; }
    int GetAnswerMode() const
        { return _AnswerMode; }
    void SetHasAnswer(Boolean HasAnswer_)
        { _HasAnswer = HasAnswer_; }
    void SetShowAnswer(Boolean ShowAns_)
        { _ShowAnswer = ShowAns_; }
    void SetIsParam(Boolean flag_)
        { _IsParam = flag_; }
    void SetLevel(int Level_)
        { _Level = Level_; }
    void SetNoReturns(Boolean flag_)
        { _NoReturns = flag_; }
    void SetAnswerMode(int Mode_)
        { _AnswerMode = Mode_; }

    int InProgramMode(bool InclPrompter_,
                      bool InclInfile_=false) const;

    bool GraphCmdWasFound() const;
    bool ExecCmdWasFound() const;

    int ExecInputFileData() const;
    Boolean MathLineConfirmedValid() const;
    Boolean HasCommandOutput() const;
    Boolean CheckIfValidExpression();
    void SetAnswer(const char* Ans_);
    Boolean SetExpression(const char* Expr_, int ChkValid_=false);
    void SetOriginal(const char* Expr_);
    void SetProgramName(const char* Name_);
    void FindFunctionCalls();
    void ShowResults();
    const char* Evaluate();
    void Clear();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct FncParameter
{
  SubExpression* _Param;
  int _ShouldEval;
  int _ShouldReplace;

  FncParameter();
  FncParameter(const FncParameter& Obj_);
  ~FncParameter();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class FunctionCall
{
  protected:
    SubExpression* _Parent;
    char* _FncName;
    int _NumParams;
    int _MaxParams;
    FncParameter** _ParamArray;
    char* _AnswerStr;
    char* _LiteralAnsStr;
    int _OutputMode;
    int _ShouldShow;

    // delayed memory deleter
    DelayedMemoryDeleter* _MemDel;

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      mutable ChrString _RetOriginalStr;
      mutable ChrString _RetFncName;
      mutable ChrString _RetAnswerStr;
      mutable ChrString _RetLiteralAnsStr;
    #endif

  public:
    FunctionCall();
    FunctionCall(SubExpression* Parent_, char* Name_);
    ~FunctionCall();

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      ChrString& GetOriginalChrStr() const;
      ChrString& GetFncNameChrStr() const;
      ChrString& GetAnswerChrStr() const;
      ChrString& GetLiteralAnswerChrStr() const;
    #endif

    const char* GetOriginal(ChrString* ret=NULL) const;
    const char* GetFncName(ChrString* ret=NULL) const;
    const char* GetAnswer(ChrString* ret=NULL) const;
    const char* GetLiteralAnswer(ChrString* ret=NULL) const;

    Boolean Destroyed() const
        { return (_MemDel ? _MemDel->Destroyed():TRUE); }
    int ShowAnswer() const
        { return _ShouldShow; }
    int OutputMode() const
        { return _OutputMode; }

    void ReplaceParameter(int Index_, CalculatorBase* CalcPtr_,
                          int& Error_, int& ReEvaluate_, int ReFormat_, int ChangeModes_=FALSE);

    int InProgramMode(bool InclPrompter_,
                      bool InclInfile_=false) const;
    int ExecInputFileData() const;
    void SetShowAnswer(int Value_);
    void AddParameter(const char* Expr_, int FindCalls_, int ReplExpr_);
    void SetNumParams(int Params_);
    void Evaluate();
    void Clear();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct LoopParams
{
  char* _Variable;
  long _Begin;
  long _End;
  long _Step;

  char* _BeginStr;
  char* _EndStr;
  char* _StepStr;

  LoopParams();
  LoopParams(const char* Variable_, long Beg_, long End_, long Step_);
  ~LoopParams();

  void SetVariable(const char* Var_);
  void SetBegin(long Begin_);
  void SetEnd(long End_);
  void SetStep(long Step_);

  void SetBegin(const char* Begin_);
  void SetEnd(const char* End_);
  void SetStep(const char* Step_);

  char* SetVarToBegin(char* Buffer_);
  char* CheckVarEqualEnd(char* Buffer_);
  char* IncrVarWithStep(char* Buffer_);
  char* CheckVarGreaterThanEnd(char* Buffer_);
  char* CheckVarLessThanEnd(char* Buffer_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct MenuItem
{
  char* _Text;
  char* _Label;
  MenuItem* _Next;

  MenuItem();
  MenuItem(const char* Text_, const char* Label_);
  ~MenuItem();

  void SetText(const char* Text_);
  void SetLabel(const char* Label_);
  void SetNext(MenuItem* Next_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct Menu
{
  char* _Title;
  MenuItem* _Item;

  Menu();
  Menu(const char* Title_);
  ~Menu();

  void SetTitle(const char* Title_);
  void AddMenuItem(MenuItem* Item_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct CommandType
{
  enum
  {
    NO_TYPE       = 0,
    IF_THEN       = 1,
    IF_THEN_ELSE  = 2,
    FOR           = 3,
    WHILE         = 4,
    REPEAT        = 5,
    LABEL         = 6,
    GOTO          = 7,
    INCSKIP       = 8,
    DECSKIP       = 9,
    RETURN        = 10,
    STOP          = 11,
    DISPLAY       = 12,
    GRAPH_EXPR    = 13,
    GRAPH_FMIN    = 14,
    GRAPH_FMAX    = 15,
    GRAPH_DERIV   = 16,
    GRAPH_INTEG   = 17,
    GRAPH_ROOT    = 18,
    PROMPT        = 19,
    INPUT         = 20,
    INPUT_PROMPT  = 21,
    PAUSE         = 22,
    PAUSE_VALUE   = 23,
    MENU          = 24,
    CONDITION     = 25,
    PROGRAM       = 26,
    COMMAND       = 27,
    END           = 28,
    ELSE          = 29,
    IF            = 30,
    CALCINPUT     = 31,
    STOP_VALUE    = 32,
    DISPLAY_PARTS = 33,
    END_DISPLAY   = 34,
    NOOP          = 255
  };
};

/****************************************************************************/
struct IoArguments
{
  enum { ARRAYINCR = 20 };

  size_t _MaxArgs;
  size_t _NumArgs;
  char** _Arguments;

  IoArguments();
  ~IoArguments();

  void Resize();
  void AddArgument(const char* Name_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct EndToken
{
  int _Type;
  size_t _Startline;
  size_t _Endline;
  size_t _Depth;
  EndToken* _Next;

  EndToken();
  EndToken(EndToken* Token_);

  int Encloses(EndToken* Token_);
  int IsEnclosedBy(EndToken* Token_);
  int Matches(EndToken* Token_);
  void SetData(EndToken* Token_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
struct CtrlExecData
{
  int _Executed;
  size_t _LineNo;
};

/****************************************************************************/
class CalcProgram;

class ProgramLine
{
  protected:
    char* _Line;
    int _Type;
    int _Key;
    size_t _BlockSize;
    size_t _AltBlockSize;
    int _ClearInput;
    FILE* _Fout;
    CalcProgram* _Parent;

    union
    {
      Menu* _Menu;
      EndToken* _End;
      LoopParams* _Loop;
      IoArguments* _IoFncArgs;
      char* _Condition;
      char* _Label;
      char* _Name;
    };

  public:
    ProgramLine();
    ProgramLine(const char* Line_, CalcProgram* Ptr_);
    ~ProgramLine();

    void SetLine(const char* Line_);
    void SetType(int Type_);
    void SetBlockSize(size_t Size_);
    void SetAltBlockSize(size_t Size_);

    void SetMenu(Menu* Menu_);
    void SetEndToken(EndToken* End_);
    void SetLoopParams(LoopParams* Loop_);
    void SetIoArguments(IoArguments* Args_);
    void SetCondition(const char* Cond_);
    void SetLabel(const char* Label_);
    void SetName(const char* Name_);
    void SetParent(CalcProgram* Ptr_);

    void WriteCondition();
    void WriteCommand();
    void SetVarToBegin();
    void CheckVarEqualEnd();
    void IncrVarWithStep();
    void CheckVarGreaterThanEnd();
    void CheckVarLessThanEnd();

    int GetType()
        { return _Type; }
    const char* GetLine()
        { return _Line; }
    const char* GetCondition()
        { return ((_Key == CommandType::CONDITION) ? _Condition:NULL); }
    const char* GetLabel()
        { return ((_Key == CommandType::LABEL) ? _Label:NULL); }
    const char* GetName()
        { return ((_Key == CommandType::PROGRAM) ? _Name:NULL); }
    Menu* GetMenu()
        { return ((_Key == CommandType::MENU) ? _Menu:NULL); }
    EndToken* GetEndToken()
        { return ((_Key == CommandType::END) ? _End:NULL); }
    LoopParams* GetLoopParams()
        { return ((_Key == CommandType::FOR) ? _Loop:NULL); }
    IoArguments* GetIoArguments()
        { return ((_Key == CommandType::PROMPT) ? _IoFncArgs:NULL); }
    size_t GetBlockSize()
        { return _BlockSize; }
    size_t GetAltBlockSize()
        { return _AltBlockSize; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class CalcProgram
{
  friend class ProgramLine;

  protected:
    enum { LINEINCR = 20 };
    static long _CalcProgramIDval;

    char* _Name;
    long _ProgramID;
    long _CalcClassID;
    size_t _NumLines;
    size_t _NumSrcLines;
    size_t _MaxLines;
    ProgramLine** _Lines;
    char** _SourceLines;
    size_t _OutputBufferSize;
    char* _OutputBuffer;
    bool _DoQuit;
    bool _QuitAll;
    CalcProgram* _NextProg;
    int _IostateFileReadError;
    int _ProgramLoaded;
    int _LoadFromFile;
    EndToken* _Stack;
    size_t _NumNodes;
    size_t _Executed;
    CalculatorBase* _CalcPtr;
    CalculatorBase* _PrevCalc;
    int _CalcNumber;
    bool _QuitCalculator;
    bool _InputReceived;
    bool _EndReached;
    bool _ClearFilesOnDestroy;
    bool _OverrideClearFiles;
    int _SavedState;
    bool _SavedNoDup;
    int _SavedDelay;
    bool _SavedClear;
    int _DefaultMaxRetries;
    int _MaxRetries;
    bool _DisplayingParts;
    bool _SetBreakResponse;
    bool _BreakPrgSet;
    bool _Destroyed;
    bool _DoPopFromStack;
    bool _ConfirmBatchEndedSignal;
    #if USE_NEW_SUBEXPR_FOR_PROGRAMS
      bool _SubExprCreated;
    #endif

    // default file names
    char* LOG_FILE;                             // Error log file name
    char* SPAWNARG_FILE;                        // Spawn calc. arguments file
    char* CURRENTERROR_FILE;                    // Current error message output file
    char* PROGRESS_FILE;                        // completion progress of input data file processing
    char* ELAPSEDTIME_FILE;                     // Elapsed time file name
    char* USER_INPUT_FILE;                      // User input file
    char* USER_PROMPT_FILE;                     // User prompt file
    char* PROG_OUTPUT_FILE;                     // Program output file
    char* CMDHISTORY_FILE;                      // Command history file
    char* PROG_IOSTATE_FILE;                    // Program I/O state file
    char* SERVERALIVE_FILE;                     // Server keep alive file for async. mode
    char* CLIENTALIVE_FILE;                     // Client keep alive file for async. mode
    char* CURRENTGRAPH_FILE;                    // Current graph file
    char* GRAPH_OPERATION_FILE;                 // graph operation type file
    char* GRAPH_PROGRESS_FILE;                  // graph plotting progress file
    char* POLLSTATE_FILE;                       // Current keep alive polling state
    char* FILE_SESNUM_SUFFIX;                   // Appended session number suffix for each data file

    void ResizeOutputBuffer();

    void Push(int Type_, size_t Start_, size_t End_);
    void Push(EndToken* End_);
    EndToken* Pop();

    int FreadString(char** buffer, size_t& MaxSize_, char terminator, FILE* Finput_,
                    bool SpecChrs_, bool KeepNewLine_=false);
    void SetFilenames(const char* LogFile_, const char* InputFile_,
                      const char* PromptFile_, const char* ProgOutFile_,
                      const char* IostateFile_, const char* CurrentGraphFile_,
                      const char* GraphOperFile_, const char* GraphProgressFile_,
                      const char* CmdHistoryFile_, const char* ServerAliveFile_,
                      const char* ClientAliveFile_, const char* CurrentError_,
                      const char* PollStateFile_, const char* SpawnArgFile_,
                      const char* ProgressFile_, const char* ElapsedTimeFile_,
                      const char* SessionSuffix_);
    void SetFilenames(CalculatorBase* CalcPtr_);
    long FileSize(FILE* Fptr_);

    void Resize();
    void AddLine(ProgramLine* Line_);
    int FindEnd(size_t Start_, size_t& LineNo_);
    int FindElse(size_t Start_, size_t& LineNo_);
    char* FindArguments(char* Source_, char* Buffer_);
    void Execute_Command(const char* Str_);

    CtrlExecData Execute_If_Then(size_t x);
    CtrlExecData Execute_If_Then_Else(size_t x);
    CtrlExecData Execute_For(size_t x);
    CtrlExecData Execute_While(size_t x);
    CtrlExecData Execute_Repeat(size_t x);
    size_t Execute_If(size_t x);
    size_t Execute_Else(size_t x);
    size_t Execute_Goto(size_t x);
    size_t Execute_IncSkip(size_t x);
    size_t Execute_DecSkip(size_t x);
    size_t Execute_Menu(size_t x);
    void Execute_Prompt(size_t x);
    void Execute_Input(size_t x);
    void Execute_Pause(size_t x);
    void Execute_Stop(size_t x);
    void Execute_Stop();
    void Execute_Prgm(size_t x);
    void Execute_Display(size_t x);
    void Execute_Display_Parts(size_t x);
    void Execute_End_Display();
    void Execute_Command(size_t x);
    void Execute_CalcInput(size_t x);
    size_t FindNextBlock(size_t x);
    size_t Execute_Block(size_t Start_, size_t End_);
    size_t CheckTerminateNested(size_t x, CtrlExecData ExecData_, int& DoBreak_);
    int CheckTerminate(size_t x);

    int CheckCondition();
    const char* ReadFromOutput();
    const char* ReadFromUserInputFile();
    int WaitForGuiResponse(int Max_=0);
    void SendIoState(int Clear_, int State_, bool NoDup_=false, int Delay_=0);

    bool CreateNewSubExpr();
    bool CreateNewSubExpr(SubExpression* Parent_, int Level_, const char* Expr_);
    bool DestroySubExpr();
    int EvalExpression(char* argstr);
    void ReceiveResponse(int Response_);
    void CheckDefaultInputIfQuit();

  public:
    enum { MAXRETRIES = 200 };

    CalcProgram();
    CalcProgram(CalculatorBase* CalcPtr_, const char* Name_);
    ~CalcProgram();

    void SetCalculator(CalculatorBase* CalcPtr_);
    void SetPopFromStack(bool flag_);
    CalculatorBase* GetCalculator();
    int GetCalculatorNumber() const;
    static long NewIDval();

    // File name retrieval
    const char* GetSpawnArgFilename() const;
    const char* GetLogFilename() const;
    const char* GetCurrentErrorFilename() const;
    const char* GetUserInputFilename() const;
    const char* GetUserPromptFilename() const;
    const char* GetProgramOutputFilename() const;
    const char* GetCommandHistoryFilename() const;
    const char* GetProgramIostateFilename() const;
    const char* GetCurrentGraphFilename() const;
    const char* GetGraphOperationFilename() const;
    const char* GetGraphProgressFilename() const;
    const char* GetProgressFilename() const;
    const char* GetElapsedTimeFilename() const;

    bool QuitCalc() const
        { return _QuitCalculator; }
    bool QuitAll() const
        { return _QuitAll; }
    int ProgramLoaded() const
        { return _ProgramLoaded; }
    int LoadFromFile() const
        { return _LoadFromFile; }
    int FileLoadError() const
        { return (_LoadFromFile && !_ProgramLoaded); }
    bool ShouldClearOutputFiles() const
        { return _ClearFilesOnDestroy; }
    const char* ProgramName() const
        { return _Name; }
    long GiveCalcClassID() const
        { return _CalcClassID; }
    int MaxRetries() const
        { return _MaxRetries; }
    bool DisplayingParts() const
        { return _DisplayingParts; }
    bool PopFromStack() const
        { return _DoPopFromStack; }
    bool Destroyed() const
        { return _Destroyed; }
    bool ConfirmBatchEndedSignal() const
        { return _ConfirmBatchEndedSignal; }

    int GuiHasResponded();
    int RetrySendAndReceiveResponse();
    int HasErrors() const;
    int LoadFile(const char* FileName_);
    int LoadBuffer(char* ArrayBuf_);
    void SetMaxRetries(int Max_);
    void SetClearOutputFiles(bool Override_, bool flag_);
    void SetConfirmBatchEndedSignal(bool flag_);
    void AddSourceLine(const char* Name_);
    long CreateProgramID();
    long SetProgramID(long ClassNum_, long IDval_);
    void SetName(const char* Name_);
    void UnloadProgram();
    void RunProgram();
    void Compile();
    void Execute();

    int ExecProgramPopped() const;
    void SetExecProgramPopped(long flag_);
    void ResetExecProgramPopped();
    CalcProgram* FindProgramFromID(long IdVal_, bool CheckActive_);
    long GiveProgramID() const;

    #if CALCLIB_DEBUGGING
      static size_t GetErrline();
      static size_t GetErrcol();
      static int GetErrcode();
      static void SetCurrentDebugger(Debugging<CalculatorBase>* ptr);
      static Debugging<CalculatorBase>* DbgPtr(bool Deref_=true);
      void SetErrorData(int errcode_, const char* file_=__FILE__,
                        size_t line_=__LINE__, size_t col_=0, bool terminate_=false);
      void Terminate(bool setcode_=false, int errcode_=0);
    #endif

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class CalcIoStateHandler;

class CalcGraphPlotter
{
  friend class ExpressionGraphStack;
  friend class SubExpression;
  friend class CalcGlobalSwitch;

  protected:
    CalculatorBase* _CalcPtr;
    CalcIoStateHandler* _IoStatePtr;

    SubExpression* _Parent;
    ExpressionGraphStack* _ExprStk;
    const char* _ExprToReplace;

    char* _NewStr;
    bool _ReadOnly;

    char* _ExprString;
    char* _GraphExprStart;
    char* _GraphExprExtension;
    char* _LeftBrkStart;

    int _KeyWordMult;
    bool _LeftBrk;
    ptrdiff_t _ExprToGraphDiff;
    ptrdiff_t _GraphToExtDiff;
    ptrdiff_t _GraphToBrkDiff;

    bool _GraphCompleted;
    bool _PlotGraph;                             // Plot function output values to file
    bool _PlottingGraph;                         // Indicates program in PlotFunction method
    bool _PlottingDone;                          // Indicate all plot methods for specified math function executed and done
    bool _PlotAllPoints;                         // Plot all points regardless if approaching +inf/-inf

    static char* AllocateNewString(DelayedMemoryDeleter* MemDel_, char* Buffer_,
                                   size_t NewLen_, bool DelOld_, bool AlwaysNew_);

    void SetNextExpression(ExpressionGraphStack* ExprStk_);
    void SetExprToReplace(const char* ExprRep_);

    bool FindNextExpr(int* Index_) const;
    bool IsExprToReplace(const char* ExprRep_);
    bool IsParent(SubExpression* Parent_) const;
    bool HasParent() const;

    int GetNextExpressionIndex() const;
    const ExpressionGraphStack* GetNextExpression() const;
    ExpressionGraphStack* GetNextExpression();
    bool HasNextExpression() const;
    bool HasAnyExpr() const;

  public:
    CalcGraphPlotter(CalculatorBase* CalcPtr_);
    CalcGraphPlotter(const CalcGraphPlotter& Obj_);
    ~CalcGraphPlotter();

    CalcGraphPlotter& operator = (const CalcGraphPlotter& Obj_);

    void Reset();
    void SetParent(CalculatorBase* Parent_);

    bool UsingWsStrippedStr() const;
    char* RevertToOriginal();
    char* StripWs();

    inline ptrdiff_t ExprToGraphDiff() const
        { return _ExprToGraphDiff; }
    inline ptrdiff_t GraphToExtDiff() const
        { return _GraphToExtDiff; }
    inline ptrdiff_t GraphToBrkDiff() const
        { return _GraphToBrkDiff; }
    inline bool HasLeftBrk() const
        { return _LeftBrk; }

    int SendGraphWaitSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendGraphProgressSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendGraphOutputSignal(int Delay_, bool InBatch_,
                              bool* BreakAll_=NULL, bool* DoHalt_=NULL, bool Retrying_=false);

    void SetGraphKeyWordMult(int Mult_);
    void SetExprString(char* pt);
    void SetGraphExprStart(char* pt);
    void SetGraphExprExtension(char* pt);
    void SetGraphLeftBrkStart(char* pt);

    int GraphKeyWordMult() const;
    bool IsGraphGlobalSwitch() const;

    const char* ExprString() const;
    const char* GraphExprStart() const;
    const char* GraphExprExtension() const;
    const char* GraphLeftBrkStart() const;

    void SetGraphCompleted(bool flag_);
    bool GraphCompleted() const;
    void SetPlotGraph(bool flag_);
    bool DoPlotGraph() const;

    int TotalGraphTypes() const;
    void SetGraphType(int Type_, int Subtype_=0);
    void ReplaceGraphType(int Type_, int Subtype_=0);
    const int* GraphTypeVect() const;
    void AddGraphType(int Type_, int Subtype_=0);
    const int* NextGraphTypeVect(int& Index_, bool IncrNext_) const;
    bool HasGraphType(int Type_, int Subtype_=0, bool Skip1st_=false) const;
    int GraphType() const;
    int GraphSubtype() const;

    void SetPlottingGraph(bool flag_);
    bool PlottingGraph() const;
    void SetPlottingDone(bool flag_);
    bool PlottingDone() const;
    void SetPlotAllPoints(bool flag_);
    bool PlotAllPoints() const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class CalcIoStateHandler
{
  protected:
    enum
    {
      CALC_OUTPUT             = 0,
      CALC_PROGRESS           = 1,
      SPAWN_CALC              = 2,
      CALC_ERROR              = 3,
      GRAPH_PENDING           = 4,
      GRAPH_PROGRESS          = 5,
      GRAPH_OUTPUT            = 6,
      MAX_PROCESSES           = 7,

      NOT_SET                 = 0,
      UNACKNOWLEDGED          = 1,
      ACKNOWLEDGED            = 2,

      pvGRAPH_RESPONSE_PENDING   = 1,
      pvGRAPH_PROGRESS_SENT      = 2,
      pvGRAPH_RESPONSE_COMPLETED = 3,

      pvGRAPH_WAIT_ACK           = 4,
      pvGRAPH_PROGRESS_ACK       = 5,
      pvGRAPH_OUTPUT_ACK         = 6,

      pvGRAPH_WAIT_UPDATE        = 7,
      pvGRAPH_PROGRESS_UPDATE    = 8,
      pvGRAPH_OUTPUT_UPDATE      = 9,

      pvGRAPH_QUIT               = 10,

      PROC_SIGNAL_SENT           = 1,
      PROC_SIGNAL_REMOVED        = 2,
      ACK_SIGNAL_SENT            = 3,
      ACK_SIGNAL_REMOVED         = 4,

      IN_GRAPH_PROCESS        = 0x0001,
      IN_ERROR_PROCESS        = 0x0002,
      IN_OUTPUT_PROCESS       = 0x0004,
      IN_CALCPROGRESS_PROCESS = 0x0008,
      IN_CALCSPAWN_PROCESS    = 0x0010,

      RESPONSE_PENDING        = 0x0001,
      CLIENTACK_GRAPHWAIT     = 0x0002,
      GRAPH_PROGRESS_SENT     = 0x0004,
      CLIENTACK_GRAPHPROGRESS = 0x0008,
      RESPONSE_COMPLETED      = 0x0010,
      CLIENTACK_GRAPHOUTPUT   = 0x0020,

      FETCH_ERRORS_SENT       = 0x0040,
      CALC_ERROR_SETBYCALC    = 0x0080,
      CALC_ERROR_SETBYCLIENT  = 0x0100,
      CLIENTACK_ERROR         = 0x0200,

      CALC_OUTPUT_SENT        = 0x0400,
      CLIENTACK_OUTPUT        = 0x0800,

      CALC_PROGRESS_SENT      = 0x1000,
      CLIENTACK_CALCPROGRESS  = 0x2000,

      SPAWN_CALC_SENT         = 0x4000,
      CLIENTACK_SPAWN_CALC    = 0x8000
    };

  protected:
    CalculatorBase* _Parent;
    CalcGraphPlotter* _Plotter;

    mutable int _UnAckStates[MAX_PROCESSES];
    mutable int _ProcessStates[MAX_PROCESSES];

    mutable int _UnAckTransition[MAX_PROCESSES];
    mutable int _ProcessTransition[MAX_PROCESSES];

    int _IterIndex;
    bool _PrevProgressDone;

    mutable int _GraphAltProc;
    mutable bool _ProcMatch;
    mutable bool _ForceState;
    mutable bool _QuitGraph;
    mutable bool _SessionOptionOverride;

    int _CurrProcState;
    int _PrevIoState;
    int* _IoStatep;

    bool NotInOutputStates(int State_, bool Inverse_=false) const;
    bool NotInProcessStates(int State_, bool Inverse_=false) const;
    bool NotInOutputExtStates(int State_, bool Inverse_=false) const;
    bool NotInErrorStates(int State_, bool Fetch_, bool SetByClient_) const;

    bool InEqvOutStates(int CalcState_, int State_) const;
    bool NotInEqvOutStates(int CalcState_, int State_) const;

    bool ErrProcFetchErrorsSent_Helper(int State_, bool Ack_, Ushort Iter_) const;
    int WaitForOutputStateAck(int CurState_, bool* FetchLimitReached_=NULL);
    void SetPrevIoState(int State_);

    void SetGraphAltProc(int ProcName_,
                         bool ProcMatch_, bool ForceState_=false) const;
    void ClearGraphAltProc() const;
    bool InitialProgressStepNotDone(int State_) const;

    inline bool ProcMatch() const
        { return _ProcMatch; }
    inline bool ForceState() const
        { return _ForceState; }
    inline bool QuitGraph() const
        { return _QuitGraph; }
    inline int GraphAltProc() const
        { return _GraphAltProc; }
    inline bool SessionOptionOverride() const
        { return _SessionOptionOverride; }

  public:
    CalcIoStateHandler(CalculatorBase* Parent_, int* IoStateAddr_);
    CalcIoStateHandler(const CalcIoStateHandler& Obj_);

    CalcIoStateHandler& operator = (const CalcIoStateHandler& Obj_);
    void Clear();

    void SetIoStateAddr(int* IoStateAddr_);

    bool ResetAtEndOfProcess(int State_);
    bool SetIoStateAck(int State_);
    bool IsIoStateUnAck(int State_=0);
    bool UpdateIoState(int State_);
    void ResetStateWhenProcessDone(int* Totalp_=NULL,
                                   int* Donep_=NULL);
    int WaitForIoStateAck(bool* BreakAll_=NULL, bool* DoHalt_=NULL,
                          bool* FetchLimitReached_=NULL);

    CalcIoStateHandler* SetSessionOptionOverride(bool flag_);
    void SetIoState(int State_, bool NoDup_=false,
                    int Delay_=0, bool WaitForAck_=true);
    int GetIoState(int Sleep_);
    int CurrentIoState() const;

    void SetInErrorProcess(bool flag_=true);
    void SetInOutputProcess(bool flag_=true);
    void SetInCalcProgressProcess(bool flag_=true);
    void SetInCalcSpawnProcess(bool flag_=true);
    void SetInGraphProcess(bool flag_=true);

    inline void ClearInErrorProcess()
        { (_CurrProcState &= ~IN_ERROR_PROCESS); }
    inline void ClearInOutputProcess()
        { (_CurrProcState &= ~IN_OUTPUT_PROCESS); }
    inline void ClearInCalcProgressProcess()
        { (_CurrProcState &= ~IN_CALCPROGRESS_PROCESS); }
    inline void ClearInCalcSpawnProcess()
        { (_CurrProcState &= ~IN_CALCSPAWN_PROCESS); }
    inline void ClearInGraphProcess()
        { (_CurrProcState &= ~IN_GRAPH_PROCESS); }

    inline bool InErrorProcess() const
        { return (_CurrProcState & IN_ERROR_PROCESS); }
    inline bool InOutputProcess() const
        { return (_CurrProcState & IN_OUTPUT_PROCESS); }
    inline bool InCalcProgressProcess() const
        { return (_CurrProcState & IN_CALCPROGRESS_PROCESS); }
    inline bool InCalcSpawnProcess() const
        { return (_CurrProcState & IN_CALCSPAWN_PROCESS); }
    inline bool InGraphProcess() const
        { return (_CurrProcState & IN_GRAPH_PROCESS); }

    inline bool OutputProcessEnded() const
        { return (!InOutputProcess() &&
                  CalcOutputProcessDone(NULL, NULL)); }
    inline bool ProgressProcessEnded() const
        { return (!InCalcProgressProcess() &&
                  CalcProgressProcessDone(NULL, NULL)); }
    inline bool SpawnCalcProcessEnded() const
        { return (!InCalcSpawnProcess() &&
                  SpawnCalcProcessDone(NULL, NULL)); }
    inline bool ErrorProcessEnded() const
        { return (!InErrorProcess() &&
                  ErrorProcessDone(NULL, NULL)); }
    inline bool GraphProcessEnded() const
        { return (QuitGraph() ||
                  (!InGraphProcess() &&
                   GraphProcessDone(NULL, NULL))); }

    // Calc output process steps
    bool CalcOutputProcessDone(int* Totalp_=NULL,
                               int* Donep_=NULL, bool ChkOnly_=false) const;
    bool ResetAtEndOfCalcOutputProcess(int State_,
                                       bool Ack_=true, bool* AckSet_=NULL);
    void SetAllDoneCalcOutputState();
    void ResetCalcOutputState();

    bool CalcOutputSentUnAcked(int State_=0, bool Ack_=false) const;
    bool CalcOutputAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool CalcOutputUpdate(int State_, bool Init_=true, bool* Updated_=NULL);

    void SetCalcOutputSent(bool flag_);           // step 1
    bool CalcOutputSentDone() const;
    void SetClientAckToCalcOutput(bool flag_);    // step 2
    bool ClientAckToCalcOutput(bool InProc_) const;

    bool CalcOutputSentTransition(bool Inverse_=false) const;
    bool ClientAckCalcOutputTransition(bool Inverse_=false) const;
    bool CalcOutputUpdateTransition(bool Inverse_=false) const;

    // Calc progress process steps
    // Steps only valid if calculator is in input batch file
    bool CalcProgressProcessDone(int* Totalp_=NULL,
                                 int* Donep_=NULL, bool ChkOnly_=false) const;
    bool ResetAtEndOfCalcProgressProcess(int State_,
                                         bool Ack_=true, bool* AckSet_=NULL);
    void ResetCalcProgressState();
    void SetAllDoneCalcProgressState();
    void ResetProgressStates(int State_);

    bool CalcProgressSentUnAcked(int State_=0, bool Ack_=false) const;
    bool CalcProgressAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool CalcProgressUpdate(int State_, bool Init_=true, bool* Updated_=NULL);

    void SetCalcProgressSent(bool flag_);         // step 1
    bool CalcProgressSentDone() const;
    void SetClientAckToCalcProgress(bool flag_);  // step 2
    bool ClientAckToCalcProgress(bool InProc_) const;

    bool CalcProgressSentTransition(bool Inverse_=false) const;
    bool ClientAckCalcProgressTransition(bool Inverse_=false) const;
    bool CalcProgressUpdateTransition(bool Inverse_=false) const;

    // Calc spawn process steps
    // Steps only valid if calculator is spawning a new mcalc instance
    bool SpawnCalcProcessDone(int* Totalp_=NULL,
                              int* Donep_=NULL, bool ChkOnly_=false) const;
    bool ResetAtEndOfSpawnCalcProcess(int State_,
                                      bool Ack_=true, bool* AckSet_=NULL);
    void ResetSpawnCalcState();
    void SetAllDoneSpawnCalcState();

    bool SpawnCalcSentUnAcked(int State_=0, bool Ack_=false) const;
    bool SpawnCalcAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool SpawnCalcUpdate(int State_, bool Init_=true, bool* Updated_=NULL);

    void SetSpawnCalcSent(bool flag_);            // step 1
    bool SpawnCalcSentDone() const;
    void SetClientAckToSpawnCalc(bool flag_);     // step 2
    bool ClientAckToSpawnCalc(bool InProc_) const;

    bool SpawnCalcSentTransition(bool Inverse_=false) const;
    bool ClientAckSpawnCalcTransition(bool Inverse_=false) const;
    bool SpawnCalcUpdateTransition(bool Inverse_=false) const;

    // Calc error process steps
    // Steps only valid if calculator is in error states
    bool ErrorProcessDone(int* Totalp_=NULL,
                          int* Donep_=NULL, bool ChkOnly_=false) const;
    bool ResetAtEndOfErrorProcess(int State_,
                                  bool Ack_=true, bool* AckSet_=NULL);
    void ResetErrorState();

    bool ErrProcFirstFetchErrorsSentUnAcked(int State_=0, bool Ack_=false) const;
    bool ErrProcNextFetchErrorsSentUnAcked(int State_=0, bool Ack_=false) const;
    bool ErrProcCalcErrorSentUnAcked(int State_=0, bool Ack_=false) const;

    bool ErrProcFetchErrorsAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool ErrProcCalcErrorAck(int State_, bool Ack_=true, bool* AckSet_=NULL);

    bool ErrProcFetchErrorsUpdate(int State_, bool Init_=true, bool* Updated_=NULL);
    bool ErrProcCalcErrorUpdate(int State_, bool Init_=true, bool* Updated_=NULL);

    void SetCalcErrorSent(bool flag_,
                          bool SetByClient_);             // step 1a
    bool CalcErrorSentDone(bool SetByClient_) const;
    void SetFetchErrorsSent(bool flag_);                  // step 1b
    bool FetchErrorsSentDone() const;
    void SetClientAckToFetchErrors(bool flag_,
                                   bool SetByClient_);    // step 2b
    bool ClientAckToFetchErrors(bool SetByClient_,
                                bool TestAltVal_, bool InProc_) const;
    void SetClientAckToCalcError(bool flag_);             // step 3
    bool ClientAckToCalcError(bool InProc_) const;

    bool CalcErrorSentTransition(bool Inverse_=false) const;
    bool ClientAckCalcErrorTransition(bool Inverse_=false) const;
    bool CalcErrorUpdateTransition(bool Inverse_=false) const;

    // Graph process steps
    // Steps only valid if calculator is in graph operations
    bool GraphProcessDone_Main(int* Totalp_=NULL, int* Donep_=NULL,
                               bool ChkOnly_=false, int Parts_=6) const;

    bool GraphProcessDone(int* Totalp_=NULL,
                          int* Donep_=NULL, bool ChkOnly_=false) const;
    bool GraphWaitProcessDone(int* Totalp_=NULL,
                              int* Donep_=NULL, bool ChkOnly_=false) const;
    bool GraphProgressProcessDone(int* Totalp_=NULL,
                                  int* Donep_=NULL, bool ChkOnly_=false) const;
    bool GraphOutputProcessDone(int* Totalp_=NULL,
                                int* Donep_=NULL, bool ChkOnly_=false) const;

    bool GraphBatchFileDone(bool* BatchFileEnded_=NULL,
                            bool* BatchEndedAck_=NULL) const;
    bool ResetAtEndOfGraphProcess(int State_,
                                  bool Ack_=true, bool* AckSet_=NULL);
    void ResetGraphState();

    void SetAllDoneGraphWaitState();
    void SetAllDoneGraphProgressState();
    void SetAllDoneGraphOutputState();

    void ResetGraphProgressStates(int State_, bool SavePrevState_);
    void RestoreGraphProgressStates();

    bool GraphResponsePending(int State_=0, bool Ack_=false) const;
    bool GraphProgressSentUnAcked(int State_=0, bool Ack_=false) const;
    bool GraphResponseCompleted(int State_=0, bool Ack_=false) const;

    bool GraphWaitAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool GraphProgressAck(int State_, bool Ack_=true, bool* AckSet_=NULL);
    bool GraphOutputAck(int State_, bool Ack_=true, bool* AckSet_=NULL);

    bool GraphWaitUpdate(int State_, bool Init_=true, bool* Updated_=NULL);
    bool GraphProgressUpdate(int State_, bool Init_=true, bool* Updated_=NULL);
    bool GraphOutputUpdate(int State_, bool Init_=true, bool* Updated_=NULL);

    void SetResponsePending(bool flag_);           // step 1
    bool ResponsePendingDone() const;
    void SetClientAckToGraphWait(bool flag_);      // step 2
    bool ClientAckToGraphWait(bool InProc_,
                              bool AllCases_=false) const;

    void SetGraphProgressSent(bool flag_);         // step 3
    bool GraphProgressSentDone() const;
    void SetClientAckToGraphProgress(bool flag_);  // step 4
    bool ClientAckToGraphProgress(bool InProc_,
                                  bool AllCases_=false) const;

    void SetResponseCompleted(bool flag_);         // step 5
    bool ResponseCompletedDone() const;
    void SetClientAckToGraphOutput(bool flag_);    // step 6
    bool ClientAckToGraphOutput(bool InProc_) const;

    bool GraphWaitSentTransition(bool Inverse_=false) const;
    bool GraphProgressSentTransition(bool Inverse_=false) const;
    bool GraphOutputSentTransition(bool Inverse_=false) const;

    bool ClientAckGraphWaitTransition(bool Inverse_=false) const;
    bool ClientAckGraphProgressTransition(bool Inverse_=false) const;
    bool ClientAckGraphOutputTransition(bool Inverse_=false) const;

    bool GraphWaitUpdateTransition(bool Inverse_=false) const;
    bool GraphProgressUpdateTransition(bool Inverse_=false) const;
    bool GraphOutputUpdateTransition(bool Inverse_=false) const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class ClientPollingMgr
{
  protected:
    enum
    {
      READ    = 0,
      WRITE   = 1,
      BUFSIZE = 64,
      LOOP_GUARD_LIMIT = 200,

      INITIALSTATE = 0,
      NOTREQUIRED  = 1,
      REQUIRED     = 2,
      INPROCESS    = 4,
      COMPLETED    = 8
    };

    CalculatorBase* _Parent;    // Parent calculator object
    char* _StrBuffer;           // string buffer for state file date reading

    int _CycleNum;              // Poll process cycle number
    bool _CycleActive;          // Poll process cycle in active state
    int _RetrievedCycle;        // Retrieved process cycle number from client

    int _ClientPollProcess;     // Client polling process steps
    int _ServerPollProcess;     // Server polling process steps
    int _PrevClientProcess;     // Saved previous client polling process value
    int _PrevServerProcess;     // Saved previous receive from client poll process value

    int _RetryReadCount;        // Counter for retry attempts to read I/O state file
    int _RetryPollCount;        // Retry attempts counter for client program "keep alive" polling
    int _PollState;             // Client polling state
    int _ServerState;           // Server keep alive state
    int _ClientState;           // client keep alive state

    bool _RdServerPoll;         // Read Server Poll info allowed
    bool _AllowPollClient;      // Allow polling of client program
    bool _SleepWaiting;         // Sleep only when waiting for client response to server signal
    bool _ResetStatesOnDone;    // Reset poll process state after poll process completed
    bool _BreakOnPollError;     // Break out of polling loop on encounter of polling error
    bool _KeepAlivePollError;   // Error indicator for client program "keep alive" polling
    bool _ConfirmedClientAlive; // Confirmed client program is alive after polling client
    bool _ConfirmedServerAlive; // Confirmed server program is alive after client polled server
    bool _ClientAliveConfSent;  // Client alive confirmation sent to calculator object

    bool _AsyncMode;
    bool _ExitAtRetryMax;
    bool _StopTracking;         // debug mode method and data tracking
    bool _WaitUntilResponse;    // Wait indefinitely until client response
    bool _PausePollResults;     // Pause after showing poll results
    bool _ResetWhenNotReq;      // Reset polling/receiving when condition not required
    bool _ForceReset;           // Force reset polling/receiving on condition

    ClientPollingMgr* _Backup;  // backup version to compare differences in polling results data

    // client-polling-server process steps
    bool ClientIsPolling() const;
    bool ServerIsAlive() const;
    bool ClientAcked() const;
    bool ResetSignalSent();
    bool PollingResetByClient();

    // server-polling-client process steps
    bool AtInitialState();
    bool ServerIsPolling() const;
    bool ClientIsAlive() const;
    bool ServerAcked() const;
    bool ResetRequested();
    bool PollingReset();

    // polling variables and poll cycle number
    void ResetPollingVars();
    void ResetPollCycle();
    void SetNewPollCycle();
    void AcceptPollCycle();
    int IncCycleNum();

    // methods for polling client in order (top to bottom)
    bool PollClientIfAlive_IMPL(int Sleep_, bool ResponseOnly_);
    bool SendPollClientSignal();
    void ConfirmClientAlive(bool ServerReceive_=false);
    bool SendServerAckClientSignal();
    bool ResetPolling();

    // method for receiving server poll in order (top to bottom)
    bool ReceiveKeepAlivePoll_IMPL(int Sleep_);
    bool SendServerAliveSignal();
    void ConfirmServerAlive(bool PollClient_=false);
    bool SendResetPollingSignal();

    bool PollClientCompleted_IMPL(bool InclNotReq_, bool InclPrev_);
    bool ServerReceiveCompleted_IMPL(bool InclNotReq_, bool InclPrev_);
    int ReadServerState(bool RdPoll_);
    int ReadServerPollProcess(bool RefreshStates_=true);
    bool ClientSetPollInProcess(bool* PollStateOk_=NULL) const;
    bool ServerSetPollReset(bool* PollStateOk_=NULL) const;
    bool ResponseRequired(int PrevPollState_,
                          int& LoopGuard_, int LoopLimit_);
    void SetTrackingOnStateChange(bool Reset_=false);

    bool SetPollState(int State_);
    bool SetServerState(int State_);
    bool SetClientState(int State_);

  public:
    ClientPollingMgr(CalculatorBase* Parent_, bool CreateBackup_=true);
    ~ClientPollingMgr();

    static bool IsClientAliveStates(int State_);
    static bool IsServerAliveStates(int State_);

    ClientPollingMgr& operator = (const ClientPollingMgr& Obj_);

    void ReadAllStates(int Sleep_);
    int ReadPollState(int Sleep_);
    int ReadClientState(int Sleep_);
    int ReadServerState();

    void ResetPollResults(bool& PollingClient_,
                          bool& PollError_,
                          bool& PollAnswered_);
    void GivePollResults(bool& PollingClient_,
                         bool& PollError_,
                         bool& PollAnswered_);
    void ShowPollResults(bool PollingClient_,
                         bool PollError_,
                         bool PollAnswered_);

    ClientPollingMgr* SetAllowClientPolling(bool flag_);
    ClientPollingMgr* SetSleepWaiting(bool flag_);
    ClientPollingMgr* SetResetStatesOnDone(bool flag_);
    ClientPollingMgr* SetBreakOnPollError(bool flag_);
    ClientPollingMgr* SetExitAtRetryMax(bool flag_);
    ClientPollingMgr* SetWaitUntilResponse(bool flag_);
    ClientPollingMgr* SetStopTracking(bool flag_);
    ClientPollingMgr* SetPausePollResults(bool flag_);
    ClientPollingMgr* ResetWhenNotRequired(bool Forced_);

    bool WaitingForClientResponse(bool* FromSvr_=NULL);
    bool PollClientIfAlive(int Sleep_=0,
                           bool UntilEnd_=false, bool ResponseOnly_=true);
    bool ReceiveKeepAlivePoll(int Sleep_=0, bool UntilEnd_=false);

    bool ResetClientPolling(bool ForceReset_=false);
    bool ResetReceivePoll(bool ForceReset_=false);
    bool ForceResetAllPolling();

    bool PollClientRequired(int Sleep_=0, bool ResponseOnly_=true);
    bool PollClientNotRequired(bool InclAtInitial_);
    bool PollClientInProcess();
    bool PollClientCompleted(bool InclNotReq_);

    bool ServerReceiveRequired(int Sleep_=0);
    bool ServerReceiveNotRequired(bool InclAtInitial_);
    bool ServerReceiveInProcess();
    bool ServerReceiveCompleted(bool InclNotReq_);

    bool ClientPollingAllowed() const;
    bool ConfirmedClientAlive() const;
    bool ConfirmedServerAlive() const;
    bool ClientAliveConfirmedSent() const;
    bool ExitAtRetryMax() const;
    bool SleepWaiting() const;
    bool WaitUntilResponse() const;
    bool StopTracking() const;
    bool PausePollResults() const;

    void ResetRetryRead();
    bool AtMaxReadAttempts() const;
    bool ReAttemptFileRead();

    void ResetPollCount();
    bool AtMaxPollAttempts() const;
    bool ReAttemptPolling();

    const char* KeepAliveStateToStr(int State_);
    const char* PollStateToStr(int State_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
// String defines for mock client console IO
#define MOCKCIOPROMPT_INITIAL      "MCALC:newinput>> "
#define MOCKCIOPROMPT_NOINPUT      "MCALC:pio==%s,ios==%s>>\n"
#define MOCKCIOPROMPT              "MCALC:pio==%s,ios==%s>> "
#define MOCKCIOPROMPT_ELAPSEDTIME  "MCALC_ELAPSED:called:%s,ios==%s,ets==%s,msec==%lg>>\n"
#define MOCKCIOPROMPT_NULLFILEPTR  "MCALC: <null file ptr>\n"

#define CALCGUIPROMPT_INITIAL      "QMCALC:newinput>> "
#define CALCGUIPROMPT_NOINPUT      "QMCALC:pio==%s,ios==%s>>\n"
#define CALCGUIPROMPT              "QMCALC:pio==%s,ios==%s>> "
#define CALCGUIPROMPT_ELAPSEDTIME  "QMCALC_ELAPSED:called:%s,ios==%s,ets==%s,msec==%lg>>\n"
#define CALCGUIPROMPT_NULLFILEPTR  "QMCALC: <null file ptr>\n"

class MockClientConIO
{
  private:
    enum { INPUT_BUFFER_SIZE = 1024 };

    CalculatorBase* _Basep;
    FILE* _InputFile;

    int _IoState;
    int _PrevSetState;
    int _RetToClientCount;
    int _ResetOutputFetchCnt;
    int _ResetProcessDoneCnt;
    int _ResetInputOptionalCnt;
    int _ResetProcessRequiredCnt;

    bool _Halted;
    bool _ZeroLenInputStr;
    bool _PrevStateSetDone;
    bool _NewDataWritten;

    bool _InBatchFile;
    bool _ProcessRequired;
    bool _InputOptional;
    bool _InBatchInput;
    bool _OutputFetched;
    bool _ProcessDone;
    bool _HasPrompt;
    bool _OutputShown;
    bool _StateChanged;
    bool _WriteToFileDone;
    bool _EmptyLineWritten;
    bool _SignalSent;
    bool _OutputWasShown;
    bool _InitialInput;

    char* _Buffer;

    // Test mock input string written to user input buffer
    ChrString _InputStrWritten;
    ChrString _InputEntered;
    ChrString _InputPrompt;
    ChrString _OutputStrShown;

    void ClearResetCounts();
    void ShowNewState();
    void CheckVars(bool GetState_, int CurrState_);
    void SetCurrState(int NewState_, bool CheckNew_);

    bool MatchingPreviousState(int CurrState_);
    bool ProcessingRequired(int CurrState_, int* CondBranch_=NULL);
    bool WriteToInput(int CurrState_, bool ReOpenFiles_);

  public:
    MockClientConIO(CalculatorBase* Basep_);
    ~MockClientConIO();

    void ResetFlags();
    void ResetClientIo();
    void DisplayStr(const char* Str_, const char* Prefix_=NULL);
    void DisplayOriginalStr();
    void DisplayAnswerStr();
    void ShowOutputStr(bool ShowOnce_);
    void ShowCalcTimeoutState(FILE* Fptr_,
                              const char* From_, int State_, double Msecs_);

    bool GetInitialClientInput();
    bool UpdateClientIoState(int CurrState_);
    bool ProcessClientIoState(int CurrState_, bool& SignalSent_,
                              int ExpectedState_, int ResponseState_);
    bool ProcessClientOutputStates(int CurrState_, bool& SignalSent_,
                                   int ExpectedState_, int ResponseState_);
    bool ProcessClientOutputExtStates(int CurrState_, bool& SignalSent_,
                                      int ExpectedState_, int ResponseState_);

    inline void ResetUserInputLength()
        { _ZeroLenInputStr = false; }
    inline void ResetHalted()
        { _Halted = false; }
    inline void SetOutputShown(bool flag_)
        { _OutputShown = flag_; }

    inline void WriteToInput()
        { WriteToInput(_IoState, true); }
    inline void ResetOutputWasShown()
        { _OutputWasShown = false; }
    inline bool HasOutputStr() const
        { return !_OutputStrShown.IsEmpty(); }
    inline bool OutputWasShown() const
        { return _OutputWasShown; }
    inline bool SignalSent() const
        { return _SignalSent; }
    inline bool HasPrompt() const
        { return _HasPrompt; }
    inline bool OutputShown() const
        { return _OutputShown; }
    inline bool InBatchFile() const
        { return _InBatchFile; }
    inline bool InBatchInput() const
        { return _InBatchInput; }

    inline bool ProcessRequired() const
        { return _ProcessRequired; }
    inline bool InputOptional() const
        { return _InputOptional; }
    inline bool OutputFetched() const
        { return _OutputFetched; }
    inline bool ProcessDone() const
        { return _ProcessDone; }

    inline void ResetProcessRequired()
        { _ProcessRequired = false;
          _ResetProcessRequiredCnt++; }
    inline void ResetInputOptional()
        { _InputOptional = false;
          _ResetInputOptionalCnt++; }
    inline void ResetOutputFetched()
        { _OutputFetched = false;
          _ResetOutputFetchCnt++; }
    inline void ResetProcessDone()
        { _ProcessDone = false;
          _ResetProcessDoneCnt++; }

    inline bool WriteToFileDone() const
        { return _WriteToFileDone; }
    inline bool EmptyLineWritten() const
        { return _EmptyLineWritten; }
    inline bool StateChanged() const
        { return _StateChanged; }
    inline bool ProcessAckReceived() const
        { return (_PrevSetState == Mcalc_IOState::PROCESS_DONE &&
                  _IoState == Mcalc_IOState::PROCESS_DONE_ACK); }

    inline const ChrString& GivePrompt() const
        { return _InputPrompt; }
    inline const ChrString& InputStrWritten() const
        { return _InputStrWritten; }
    inline const ChrString& InputEntered() const
        { return _InputEntered; }
    inline const ChrString& OutputStr() const
        { return _OutputStrShown; }
};

/******************************* Prototypes *********************************/
class CalcElapsedTimer
{
  protected:
    CalculatorBase* _Parent;

    int _ElapsedTimeFlag;    // Elapsed time timer flag value: (reset==0, sent==1, ack==2)
    bool _TimingStarted;     // Timer has started counting elapsed time
    bool _TimingStopped;     // Timer has stopped counting elapsed time
    bool _ElapsedTimeReset;  // Elapsed time timer reset flag
    bool _ElapsedTimeSent;   // Elapsed time timer timeout event sent to client
    bool _ElapsedTimeAck;    // Elapsed time timer timeout event acknowledged by client
    bool _TimerActive;       // Timer active switch to toggle timer operations

    clock_t _Begin;
    clock_t _End;

    int _SendAt;
    int _TimerLock;

    double _ElapsedSecs;

    bool TimerReset();

    // State transitions | Reset | Sent | Ack | Reset
    // ----------------------------------------------
    // _ElapsedTimeFlag  |   0   |  1   |  2  |   0
    // _TimingStarted    |   1*  |  0   |  0  |   1*
    // _TimingStopped    |   0   |  1   |  1  |   0
    // _ElapsedTimeReset |   1   |  0   |  0  |   1
    // _ElapsedTimeSent  |   0   |  1   |  1  |   0
    // _ElapsedTimeAck   |   0   |  0   |  1  |   0
    //
    // * After reset flag set true and StartTimer() called

  public:
    CalcElapsedTimer(CalculatorBase* Parent_, int SendAt_);

    void SetTimerActive(bool Flag_);
    void StartTimer();
    void EndTimer();
    void ResetTimer(bool ForceReset_=false);

    bool SendTimeout(bool* Sending_=NULL);
    bool ClientAck();

    inline void BeginTimer()
        { StartTimer(); }
    inline void StopTimer()
        { EndTimer(); }

    inline int ElapsedTimeFlag() const
        { return _ElapsedTimeFlag; }
    inline double ElapsedSecs() const
        { return _ElapsedSecs; }
    inline bool TimingStarted() const
        { return _TimingStarted; }
    inline bool TimingStopped() const
        { return _TimingStopped; }
    inline bool TimerActive() const
        { return _TimerActive; }
};

/******************************* Prototypes *********************************/
class CalculatorBase
{
  #if CALCLIB_TESTMOCKCLIENT
    friend class ServerPollingMgr;
  #endif

  friend class MockClientConIO;
  friend class ClientPollingMgr;
  friend class FunctionValidityChecker;
  friend class CalcIoStateHandler;
  friend class CalcGraphPlotter;
  friend class SubExpression;
  friend class CalcGlobalSwitch;
  friend class FunctionCall;
  friend class CalcProgram;

  friend class FloatCalculator;
  friend class DoubleCalculator;
  friend class LongDoubleCalculator;
  friend class LongNumberCalculator;

  friend char* Mcalc_DefaultInFnc(char*, int);
  friend int Mcalc_DefaultOutFnc(const char*);

  public:
    enum
    {
      MAX_INT_COORDS = 3,

      CALCULATORBASE   = 1,
      CLIENTPOLLINGMGR = 2,
      SERVERPOLLINGMGR = 4
    };

    enum
    {
      PROCESSED = 0,
      READ = 1,
      WRITE = 2
    };

    typedef const char* CONSTPTR;
    typedef const CONSTPTR* CONSTARRAY;

  protected:
    /* Program Constants */
    static const int MAXVALUES;      /* Maximum number of integer values including the result of the calculation */
    static const int RESULTINDEX;    /* index position in the operands array which contains the structure for storing the result of the calculation */

    /* Program Options */
    static const int SHOWPOS;        /* flag to show positive sign if value is positive */

    /* Operator symbols */
    static const Uchar POW_OP;
    static const Uchar SIGN_OP;
    static const Uchar SIN_OP;
    static const Uchar COS_OP;
    static const Uchar TAN_OP;
    static const Uchar ASIN_OP;
    static const Uchar ACOS_OP;
    static const Uchar ATAN_OP;
    static const Uchar SINH_OP;
    static const Uchar COSH_OP;
    static const Uchar TANH_OP;
    static const Uchar EXP_OP;
    static const Uchar LOG_OP;
    static const Uchar LOG10_OP;
    static const Uchar CEILING_OP;
    static const Uchar FLOOR_OP;
    static const Uchar ABS_OP;
    static const Uchar FRACPART_OP;
    static const Uchar INTPART_OP;
    static const Uchar SQR_OP;
    static const Uchar SQRT_OP;
    static const Uchar CUBE_OP;
    static const Uchar CUBERT_OP;
    static const Uchar MINUS_OP;
    static const Uchar RND_OP;
    static const Uchar COMB_OP;
    static const Uchar PERM_OP;
    static const Uchar COMBREP_OP;
    static const Uchar PERMREP_OP;
    static const Uchar LSTHANOREQ_OP;
    static const Uchar GRTHANOREQ_OP;
    static const Uchar EQUAL_OP;
    static const Uchar NOTEQUAL_OP;
    static const Uchar RAND_OP;
    static const Uchar XOR_OP;
    static const Uchar NOT_OP;
    static const Uchar AND_OP;
    static const Uchar OR_OP;
    static const Uchar INV_OP;
    static const Uchar SCI_OP;
    static const Uchar FACTORIAL_OP;

    /* Predefined constant symbols */
    static const Uchar PI_CONST;
    static const Uchar E_CONST;
    static const Uchar NAN_CONST;
    static const Uchar INF_CONST;
    static const Uchar ANS_CONST;
    static const Uchar ANSSTR_CONST;
    static const Uchar FRACANS_CONST;

    // Variable and number indexes
    static const Uchar VARIABLE_INDEX;
    static const Uchar NUMBER_INDEX;
    static const Uchar HEXPREFIX_INDEX;
    static const Uchar FUNCTION_INDEX;
    static const Uchar BINARYOPS_INDEX;
    static const Uchar UNARYOPS_INDEX;
    static const Uchar POSTOPS_INDEX;

    enum
    {
      CMDHISTORY_VALID  = 0,
      CMDHISTORY_LENGTH = 1,
      CMDHISTORY_STRING = 2,

      LISTINCR          = 10,

      FILE_PATH_SIZE     = 512,
      DELIM_ARRAY_SIZE   = 512,
      CONSOLE_INPUT_SIZE = 1024,
      INPUT_BUFFER_SIZE  = 1024,

      RETRY_ATTEMPTS     = 200,
      LOOP_GUARD_LIMIT   = 50000
    };

    enum
    {
      LINE_EVAL_DONE = 0,
      VAR_EVAL_DONE  = 1,
      VAR_DISPLAYED  = 2,
      VALID_FORMAT   = 3,
      ERROR_TYPE     = 4,
      PRG_LOAD_OK    = 5,
      PAUSE_SWITCH   = 6,
      INVALID_SWITCH = 7,
      PRG_SELECTED   = 8,
      MAX_INFIX_COND = 9
    };

  protected:
    char* _AnswerStr;                           // Answer string
    char* _OriginalStr;                         // Original expression string
    char* _FractionStr;                         // Fractional answer result
    char* _LiteralStr;                          // Literal string answer result
    char* _ProgramStr;                          // Program response string
    char* _PromptBuffer;                        // Prompt input buffer for calc. signal testing
    int _DisplayOption;                         // display option
    int _AnswerMode;                            // Calculator answer format mode
    int _ModeFinalized;                         // format mode has been finalized, no changes allowed
    int _InitialMode;                           // Mode in initial state or after reset
    int _ProcessVars;                           // Process variables instead of displaying them
    int _ErrorValue;                            // zero indicates no errors
    int _MultiErrorVector;                      // bit vector used for storing and displaying multiple error values
    int* _MultiErrorMaxSel;                     // maximum bit pattern selection array used for finding multi errors
    int* _MultiErrorErrVals;                    // corresponding error value array to match bit pattern equivalent.
    int _MultiErrorMaxSize;                     // maximum size of the bit pattern array used for finding mult errors
    int _SkipEvaluation;                        // Flag set to skip evaluation of expression
    int _NumberBase;                            // Number base 8 for octal, 10 for decimal, 16 for hex
    int _RecursionLimit;                        // Recursion limit when evaluating the contents of string variables
    double _GraphPrecision;                     // Graphing interval precision for graphing function
    int _SuppressOutput;                        // Suppress message display for error conditions
    int _HasCommandOut;                         // Has output for the current executed command
    CalcProgram* _InputPrompter;                // User prompter program for interactive processing of input data files
    int _InputDataFileExecLock;                 // Input data file execution lock (no repeated/recursive calls to execute data files)
    int _ExecInputFileData;                     // EXEC command to execute statements from input file type: *.in
    int _AckPostExecInputFileData;              // Acknowledge post processing of input file data
    int _PostExecResetProcessDone;              // Input data file post processing calc. state reset process completed
    int _InputDataFileLinePause;                // Pause calculator after each line from the data input file completes it's execution.
    int _NoPauseFileInput;                      // No pause data file input option for processing data input files while in GUI mode.
    FILE* _previnputfile;                       // previously saved input file
    int _previnputfileset;                      // previous output file is confirmed set
    FILE* _prevoutputfile;                      // previously saved output file
    int _prevoutputfileset;                     // previous input file is confirmed set
    Uchar* _FncAttribs;                         // Function attribute array
    ChrString* _OutputBuffer;                   // Output buffer for storing string data in program mode not written to file yet
    ChrString* _ErrorArgStr;                    // Error argument string for storing string arguments to error messages
    int _UsingErrorArgStr;                      // Error argument string in use
    int _NoPolling;                             // No client program polling switch
    int _ParentDestroyed;                       // Parent object of this object has been destroyed and removed from memory
    bool _GraphOperationsSent;                  // Graph operations data file sent to client
    int _GraphOperationsResetDone1;             // Graph operations data reset completed
    int _GraphOperationsResetDone2;             // Graph operations data reset completed
    int _GraphOperationsUpdateDone1;            // Graph operations data updated completed
    int _GraphOperationsUpdateDone2;            // Graph operations data updated completed
    bool _GraphProgressSent;                    // Graph progress data file sent to client
    bool _GraphProgressResetDone;               // Graph progress data reset completed
    bool _GraphProgressResetPending;            // Graph progress data reset pending
    bool _GraphProgressUpdateDone;              // Graph progress data updated completed
    bool _GraphProgressUpdatePending;           // Graph progress data updated pending
    bool _InFileProgressSent;                   // Input file progress data file sent to client
    bool _InFileProgressResetDone;              // Input file progress data reset completed
    bool _InFileProgressResetPending;           // Input file progress data reset pending
    bool _InFileProgressUpdateDone;             // Input file progress data updated completed
    bool _InFileProgressUpdatePending;          // Input file progress data updated pending
    bool _GraphPlotShown;                       // Plotted graph shown (GRAPH_OUTPUT signal sent)
    bool _ResultsShown;                         // Math expression results shown (CALC_RESPONSE signal sent)
    bool _ResultsPending;                       // Math expression results confirmed valid and display pending
    bool _ShownToPrompt;                        // Text message or math expression/results shown to user prompt
    bool _BatchFileEndedSignalSent;             // Batch file ended signal sent to client program
    bool _BatchFileEndedSignalAcked;            // Batch file ended signal acknowledged by client program
    bool _BatchFileEndedSignalPending;          // Batch file ended signal send to client action is pending
    bool _ClientPingSignalSent;                 // Client ping signal sent to client program
    bool _ClientPingSignalAcked;                // Client ping signal acknowledged by client program
    bool _ClientIsDead;                         // Client program unresponsive and assumed dead
    bool _ProcessAckSignalSent;                 // Process acknowledgement signal sent to client
    bool _ProcessAckSignalDone;                 // Process acknowledgement signal completed
    bool _ProcessAckSignalPending;              // Process acknowledgement signal pending
    int _ProcessAckTransition;                  // State transition validity flag for PROCESS_DONE to PROCESS transition
    int _AckSignalReceived;                     // Send acknowledgement of what signal that was received?

    int _GraphProgressAmt;                      // Graph plotting progress amount
    int _GraphSizeAmt;                          // Graph plotting total size amount
    int _InFileProgressAmt;                     // Input file processing progress amount
    int _InFileSizeAmt;                         // Input file processing total size amount
    int _StateVarsReset;                        // Calculator IO state vars has been reset
    int _NumGraphFunctions;                     // Number of graph functions found in input batch file
    int _CurrentTotalSteps;                     // Current number of total steps used in calculator progress file
    int _CurrentTotalGraphSteps;                // Current number of total steps used in graph progress file

    // Data members required for Subexpression methods and Calc. Program methods
    long _ExprStackIndex;                       // index to math subexpression stack
    long _ExprStackLimit;                       // math subexpression stack limit
    long _ProgramStackIndex;                    // index to calc. program active/inactive status stack
    long _ProgramStackLimit;                    // Calc. program active/inactive status stack limit
    long _ProgramID;                            // Program ID of CalcProgram object most recently pushed onto CalcProgram stack
    long _NewProgramID;                         // Program ID of newly created CalcProgram object
    long _PrevProgramID;                        // Program ID of previously running program
    long* _ExecProgramActive;                   // Calc. program active/inactive status stack

    // Calculator command history list method data members
    int _HistoryListMode;
    mutable char** _CmdHistoryList;
    char* _CmdHistoryPrompt;
    char* _CmdHistoryEntry;
    int _CmdHistoryIndex;
    int _CmdHistoryLength;
    bool _HistoryFileEnded;
    int _SavedXpos;
    ChrString* _DummyStr;

    // Quitting graph plotting in batch input data file
    bool _QuitGraph;            // Quit graph plotting in batch data input mode
    bool _ResetGraph;           // Reset graph plotting state after end of batch input file
    bool _GraphResetDone;       // Reset of graph plotting state done
    bool _BatchFileDonePending; // Pending the sending of BATCHFILE_ENDED signal

    // Function validity checker
    FunctionValidityChecker* _FncCheck;

    // delayed memory deleter
    DelayedMemoryDeleter* _MemDel;

    // For file and asynchronous mode operation
    static int filestatus[MAXFILES];                   // array of file status flags
    static FILE** files;                               // array of file pointers
    static FILE* infile;                               // pointer to the input file
    static FILE* outfile;                              // pointer to the output file
    static FILE* currenterrorfile;                     // current error message output file
    static FILE* logfile;                              // error log file pointer
    static FILE* spawnargfile;                         // spawn arguments file pointer
    static FILE* userinputfile;                        // user input file for async. mode execution
    static FILE* userpromptfile;                       // user prompt file for async. mode execution
    static FILE* programoutputfile;                    // program output file for async. mode execution
    static FILE* commandhistoryfile;                   // command history file
    static FILE* iostatefile;                          // program I/O state file for async. mode execution
    static FILE* curgraphfile;                         // current graph suffix file
    static FILE* graphoperationfile;                   // graph operation type data file
    static FILE* graphprogressfile;                    // graph plotting progress file
    static FILE* progressfile;                         // completion progress file for input data file processing
    static FILE* elapsedtimefile;                      // elapsed time file for lengthy math operations

    static FILE* pollstatefile;                        // current server/client alive poll state file
    static FILE* clientalivefile;                      // client alive status file
    static FILE* serveralivefile;                      // server alive status file
    static int pollstatemode;                          // current server/client alive poll state file open mode
    static int clientalivemode;                        // client alive status file open mode
    static int serveralivemode;                        // server alive status file open mode

    static int _StreamSet;                             // input and output stream is set
    static int _ArgListSize;                           // size of argument list
    static int _UseSessionCnt;                         // Use session counter value
    static int _SessionNum;                            // Session number if specified to be used
    static int _SessionOption;                         // Session number is specified as command line argument to program
    static int _SessionOptionOverride;                 // Override for IoState operations while in SessionOption mode
    static int _InputExists;                           // Input data file is specified as command line argument to program
    static int _OutputExists;                          // Output data file is specified as command line argument to program
    static int _UserInputMode;                         // File mode User Input File was opened with (READ or WRITE)
    static int _McalcSpawned;                          // child process to run Mcalc spawned successfully
    static int _ExecMcalcOk;                           // Executing child process to run Mcalc exited normally
    static int _AsyncMode;                             // Indicates in asynchronous mode or not
    static int _PrevSetState;                          // Previously Set I/O state
    static int _IoState;                               // I/O state value set internally
    static int _IoStateToSend;                         // I/O state value to send to client
    static int _IoStateForced;                         // I/O state was not received from client but forced set by calculator server
    static int _TimeoutState;                          // Calculator time out state for elapsed time timer object
    static int _WaitForResponse;                       // Indicates if program should poll for response from client
    static int _WaitForeverForSignal;                  // Wait forever for client response signal
    static int _ResendLastSignal;                      // Resend previously sent I/O signal to client
    static int _StdInput;                              // input is standard stream input
    static int _StdOutput;                             // output is standard stream output
    static int _StartAsStdInput;                       // starting condition of program is input as standard stream input
    static int _StartAsStdOutput;                      // starting condition of program is output as standard stream output
    static int _ShouldQuit;                            // Quit calculator flag
    static int _ExitOnFileOpenFail;                    // Terminate program with exit command upon file open failure
    static int _ExecInputFileDataCnt;                  // global execution count for input data files
    static int _InputFileLineSize;                     // number of executable lines (excluding comments) found in input data file
    static char** _ErrorMessageArray;                  // Error messages
    static int* _ErrorMessageArgCnt;                   // Error messages argument counts
    static char* _CurrentFunctionName;                 // Current calculator function name
    static int _BreakFromProgram;                      // Break command entered, break from all programs and exit program mode.
    static int _SetBreakResponse;                      // Prepare to send response to break program signal upon all programs terminated.
    static int _PostBreakResponseSent;                 // Post break program signal sent as response from calculator
    static int _OutputDataCondition;                   // math expression line evaluation state for specified output data type
    static int _OutputDataType;                        // Specified output data types
    static int _OutputDataError;                       // Error detected for specified output condition or output data type
    static int _OutputDataIndex;                       // Index value of variable position that is displayed
    static int _OutputDataIndexSet;                    // variable index position is set
    static int _NoOutputReturned;                      // No expected output returned that needs to be stored in the outputbuffer
    static int _ErrorStatePending;                     // Pending set error state while in program mode or input data file mode
    static int* _CalculatorCreated;                    // Calculator object created, memory is currently valid.
    static int* _CalculatorDestroyed;                  // Calculator object destroyed, no longer memory valid.
    static char* _PrintCharSet;                        // character array filters used for string utility functions
    static char* _FuncNamesCharSet;                    // character array filters used for string utility functions
    static char* _CurrentGraphFname;                   // Current graph plotting data output file name
    static int _ErrorCheckReturnValue;                 // Return value from execution of FunctionValidityChecker method: ChkIfMathLineValid
    static int _CalcPollingInactive;                   // Calculator polling of client program is deactivated
    static int _SuspendPolling;                        // Temporarily suspend polling operations
    static int _ResumePolling;                         // Resume polling operations that was temporarily suspended
    static int _BatchDataInput;                        // Batch data input file is being processed
    static int _WasInBatchDataInput;                   // Batch data input file was processed
    static int _GraphOutputSent;                       // Graph output signal sent to client
    static int _GraphOutputWasSent;                    // Graph output signal was sent to client
    static int _GraphFilePause;                        // Graph batch input data file pause option confirmed
    static int _GraphOpStage;                          // Stage in graph plotting operation
    static int _InAllGraphsFile;                       // In data input file containing all graph commands
    static int _RecursionLimitReached;                 // Recursion limit reached
    static int _BatchExecLevel;                        // Batch input or program file execution level
    static int _WriteToFileBatchLevel;                 // Write BatchExecLevel value to iostate file on next line after iostate value
    static int _InSpawnedCalc;                         // Running a new spawned copy of the calculator
    static Ushort _ReadUserAttemptLoopGuard;           // Read user attempt loop guard for async. file input
    static Ushort _ReadUserAttemptLoopGuardLimit;      // Loop guard limit to count down from for user input read attempt

    static int _BatchFileEndedSignalConfirmed;         // Batch file ended signal sent from loaded program
    static int _ZeroLenArgStr;                         // Zero length (empty) argument string read from user input
    static int _ResponseWasCompleted;                  // Graph plotting response was sent
    static int _ClientAckedDoneToGraphOutput;          // Client acknowledgement to graph plotting response sent
    static int _CalcProgressWasSent;                   // Calculator progress state was sent
    static int _ClientAckedDoneToCalcProgress;         // Client acknowledgement to calc. progress state response sent
    static int _OutputResetRequired;                   // Reset of client data output files required
    static int _CalcResponseSent;                      // Calculator response to client PROCESS signal was sent
    static int _InputPromptWarning;                    // User input prompt string empty warning
    static int _OutputTiedToSignal;                    // Output sent to output data file is tied to a specific signal
    static int _AllowEmptyResponse;                    // Allow the sending of CALC_RESPONSE signal with empty program output
    static int _VarIndexFound;                         // Index found while searching for variable assignments ($A...$Z)
    static int _LoggedError;                           // Error message has been recorded into the calculator's log file
    static int _ConfirmedValidOps;                     // Valid op codes confirmed to be found in opcode queue
    static char* _Directive;                           // Currently set non-output calc. directive
    static ChrString* _AnsStrShown;                    // Answer string displayed to output files

    // Elapsed time timer object for timing lengthy math operations
    static CalcElapsedTimer* _ElapsedTimer;

    // Name of program to execute or NULL if none
    static ExecutingProgramName* _ExecuteProgram;

    // Mock client console IO class (for testing GUI IO)
    static MockClientConIO* _Mockcio;

    // Client polling manager class
    static ClientPollingMgr* _PollClientMgr;
    static bool _ClientProgramAlive;

    #if CALCLIB_TESTMOCKCLIENT
      static ServerPollingMgr* _PollServerMgr;
      static bool _ServerProgramAlive;
    #endif

    #if CALCLIB_TESTASYNCMODE1
      static int _GraphWaitIterNum;
    #endif

    static int(*_OutFnc)(const char*);                 // pointer to default output function
    static char*(*_InFnc)(char*, int);                 // pointer to default input function
    static void*(*_AllocFnc)(size_t, size_t);          // pointer to default memory allocation function
    static void*(*_DelFnc)(size_t, void*);             // pointer to default memory deletion function

    // graph plotting static data members
    static int _GraphingOp;                            // Indicate graphing operation
    static int _GraphType;                             // Indicate type of graph
    static int _GraphSubtype;                          // Indicate subtype from main type
    static int* _GraphTypeList;                        // Graph type list for storing additional graph types
    static int _GraphTypeListSize;                     // Size of graph type list
    static int _GraphTypeListIndex;                    // Index of graph type list

    static CalcGraphPlotter* _Plotter;                 // Global graph plotter object for all calculators

    // global Calculator IO state handler
    static CalcIoStateHandler* _IoStatePtr;

    // global expression string stack
    static bool _OwnsStrStack;                         // Global string stack pointer ownership flag
    static ExprStringStack* _StringStack;              // Global string stack for storing saved math expressions

    // Common static members for all calculators
    static double UPPER_LIMIT;                         // Upper limit for convergence test in root solving formulas
    static Uchar* _QLookAhead;                         // Queue look ahead variable for operators
    static int _OddRoot;                               // Indicates special case of odd root for negative numbers
    static char _PlotFileSuffix;                       // Letter suffix for graph data file for storing multiple graphs
    static int _PrevCalcType;                          // Previous calculator type for math functions/operators checked for roundoff errors
    static int _MicroSecDelay;                         // Micro second length delay

    // Calculator command line options
    static int _CalcArgc;                              // command line argument count
    static char** _CalcArgv;                           // command line argument vector
    static Mcalc_CmdLineOptions* _CmdLineOptions;      // command line options data structure

    // Graph plotting operation options
    static Mcalc_GraphOperationOptions* _GraphOpOptions;

    // Object instances and function names
    static int _Instances;                             // Instances of this class
    static int _NumFncNames;                           // Number of function names
    static int _ShortestFncName;                       // Shortest function name

    // default file names and suffix
    static char* LOG_FILE;                             // Error log file name
    static char* SPAWNARG_FILE;                        // Spawn calculator file name
    static char* CURRENTERROR_FILE;                    // Current error message output file
    static char* USER_INPUT_FILE;                      // User input file
    static char* USER_PROMPT_FILE;                     // User prompt file
    static char* PROG_OUTPUT_FILE;                     // Program output file
    static char* CMDHISTORY_FILE;                      // Command history file
    static char* DATA_INPUT_FILE;                      // Data input file
    static char* DATA_OUTPUT_FILE;                     // Data output file
    static char* PROG_IOSTATE_FILE;                    // Program I/O state file
    static char* CURRENTGRAPH_FILE;                    // Current graph file
    static char* GRAPH_OPERATION_FILE;                 // graph operation type file
    static char* GRAPH_PROGRESS_FILE;                  // graph plotting progress file
    static char* SERVERALIVE_FILE;                     // Server keep alive state for use in async. mode
    static char* CLIENTALIVE_FILE;                     // Client keep alive state for use in async. mode
    static char* PROGRESS_FILE;                        // completion progress of input data file processing
    static char* ELAPSEDTIME_FILE;                     // elapsed time file for lengthy math operations
    static char* POLLSTATE_FILE;                       // Current keep alive polling state
    static char* FILE_SESNUM_SUFFIX;                   // Appended session number suffix for each data file

    #if CALCLIB_DEBUGGING
      static size_t _errline;
      static size_t _errcol;
      static int _errcode;
      static Debugging<CalculatorBase>* _dbgptr;
    #endif

    // Function attribute methods
    inline void SetAsUnary(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = UNARYFNC_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsBinary(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = BINARYFNC_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsConstant(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = CONSTANT_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsVariable(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = VARIABLE_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsNumber(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = NUMBER_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsPrefix(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = PREFIX_CODE | (HexOk_ ? HEXOK:0); }
    inline void SetAsPostfix(Uchar Index_, int HexOk_=0) const
         { _FncAttribs[Index_] = POSTFIXFNC_CODE | (HexOk_ ? HEXOK:0); }

    inline int IsPostfix(Uchar Index_) const
         { return (_FncAttribs[Index_] & POSTFIX); }
    inline int IsBinary(Uchar Index_) const
         { return (_FncAttribs[Index_] & BINARY); }
    inline int IsUnary(Uchar Index_) const
         { return (_FncAttribs[Index_] & UNARY); }
    inline int IsHexOk(Uchar Index_) const
         { return (_FncAttribs[Index_] & HEXOK); }
    inline int IsNum(Uchar Index_) const
         { return (_FncAttribs[Index_] & ISNUM); }
    inline int IsOp(Uchar Index_) const
         { return (_FncAttribs[Index_] & ISOP); }
    inline int IsRval(Uchar Index_) const
         { return (_FncAttribs[Index_] & RVAL); }
    inline int IsLval(Uchar Index_) const
         { return (_FncAttribs[Index_] & LVAL); }
    inline int StateVarsResetDone() const
         { return _StateVarsReset; }

    // Stage in graph plotting operation
    static void SetGraphOpStage(int val_)
         { _GraphOpStage = val_; }
    static int GraphOpStage()
         { return _GraphOpStage; }

    // Calculator/client signal response and acknowledgement methods
    static int OutputResetRequired()
        { return _OutputResetRequired; }
    static int CalcResponseSent()
        { return _CalcResponseSent; }
    static int UserInputMode()
        { return _UserInputMode; }
    static void UseMicroSecDelay(bool Flag_)
        { _MicroSecDelay = Flag_; }
    static int UsingMicroSecDelay(int* DelayLenp_=NULL, bool Override_=false);

    // Nested batch input file or program file execution level
    static void SetWriteToFileBatchLevel(int flag_)
        { _WriteToFileBatchLevel = flag_; }
    static int WriteToFileBatchLevel()
        { return _WriteToFileBatchLevel; }
    static int BatchExecLevel()
        { return _BatchExecLevel; }
    static int InSpawnedCalc()
        { return _InSpawnedCalc; }

    // Give the file status of the specified IO type
    static void SetFileStatus(int IoType_, int Status_);
    static FILE* GiveFileStatus(int IoType_, int* FileOk_=NULL);

    // Suspend/Resume polling
    bool SetPollState(int State_);
    static void SetSuspendPolling(bool flag_);
    static void SetResumePolling(bool flag_);

    // User input read attempt loop methods
    static void SetReadUserInputAttemptLoopGuard(int LoopGuard_, int LoopGuardLimit_);
    static void TickReadUserInputAttemptLoopGuard(Ushort Ticks_, int Dir_=-1);
    static void ResetReadUserInputAttemptLoopGuard();

    static void SetZeroReadUserInputAttemptLoopGuard()
        { _ReadUserAttemptLoopGuard = 0; }
    static bool ReadUserInputAttemptLoopGuardAtZero()
        { return (_ReadUserAttemptLoopGuard == 0); }
    static Ushort ReadUserInputAttemptLoopGuardLimit()
        { return _ReadUserAttemptLoopGuardLimit; }
    static Ushort ReadUserInputAttemptLoopGuard()
        { return _ReadUserAttemptLoopGuard; }
    static bool ReadUserInputAttemptLoopGuardTicked()
        { return (_ReadUserAttemptLoopGuard < _ReadUserAttemptLoopGuardLimit); }

    /* argument checking procedures */
    static int CheckNoNullParams(int NumParams_, FncParameter** ParamArray_, int Index_=-1);
    int CheckForVarDisplay(CalculatorBase* CalcPtr_, char** list, char* original,
                           int CheckLetterVars_, int* CondArray);

    static const char* ProgramName(char* Name_);
    static const char* IsExecCmd(char* Str_);

    int IsValidNum(const char* value);
    int IsValidOperator(Uchar* token);
    int IsAssignmentOp(Uchar* token, int Index_, int Dir_);
    static int HasOperandSymbols(char symbol, int HexOk_);
    int HasOperandSymbols(char symbol);
    static int HasHexPrefix(const char* Str_, int Index_);
    static int IsWsFreeStrEqual(const char* srcstr_, const char* deststr_);
    static int IsValidProcessedChar(char* Str_, int Index_, int IsOp_, int IsBinary_,
                                    int IsNum_, int IsPrefix_, int HexOk_);
    static int IsCalledFunctions(const char* Str_);
    static int IsValidInputChar(char* Str_, int Index_, int IsOp_, int IsPost_, int IsNum_, int HexOk_);
    int IsValidInputChar(char* Str_, int Index_, int IsOp_, int IsPost_, int IsNum_);
    static int IsThisChar(const char* Str_, int Index_, char Target_, int Dir_);
    static int IsFirstTrailingChar(char* list, int i, int len, int ch);
    static int IsLastLeadingChar(char* list, int i, int ch);
    static int IsFirstTrailingChar(char* list, int i, int len, int(*iscsetfn)(int));
    static int IsLastLeadingChar(char* list, int i, int(*iscsetfn)(int));
    static int IsVariable(char* Str_, int IsOp_, int IsBinary_, int IsNum_, int IsVar_, int Index_, int Dir_);
    static int IsGraphCmd(char* Str_, int Index_, int IsOp_, int IsNum_, int Lval_, int Rval_);
    static int IsNumberPrefix(char* Str_, int Index_, int IsOp_, int IsNum_, int IsPrefix_, int HexOk_, int Dir_);
    static int IsValidAssignment(char* list, int len, int cmplen, int index, int HexOk_);
    static int IsStringLiteral(const char* list, int& NewStart_, int& LiteralLen_, int Start_, int len, int InSetStr_);
    static int IsGraphableFunction(char* list, int len, int cmplen, int index, Uchar OpCode_);
    static int WholeWord(char* list, int len, int cmplen, int index,
                         int Lval_, int Rval_, int IsOp_, int IsNum_,
                         int HexOk_, int IsUnary_, int IsBinary_, int IsPost_,
                         int IsGraphable_);
    int WholeWord(char* list, int len, int cmplen, int index, Uchar OpCode_);

    int HasValidOpCodes(char symbol, int Base_);
    int HasUnresolvedNames(const char* Str_);
    static int IsStringComparisonOpType(int Optype_);
    static int IsConstSymbols(char symbol);
    static int IsFraction(const char* Str_);
    static int IsConstString(const char* Str_, int Index_, int& tlen_);
    static int IsConstString(const char* Str_, int Index_);
    static int IsBinaryFunctions(const char* Str_, int Index_);
    static int IsBinaryFunctions(const char* Str_, int Index_, int& tlen_, bool& isfnc_);
    static int IsBinaryOperators(char symbol);
    static int IsBinaryOpCodes(char ch_);
    static int IsUnaryFunctions(const char* Str_);
    static int IsUnaryFunctions(const char* Str_, int Index_, int& tlen_, bool& isfnc_);
    static int IsUnaryOperators(char symbol);
    static int IsPostfixOperators(char symbol);
    static int IsUnaryOpCodes(char ch_);
    static int IsUnprocessedSymbols(char symbol);
    static int IsLeftBrkSymbols(char symbol);
    static int IsRightBrkSymbols(char symbol);
    static int IsBrkSymbols(char symbol);
    static int IsRightsideValue(const char* Str_, int Index_, int HexOk_);

    // Answer string displayed to output files
    static void SetAnsStrShown(const char* Str_);
    static void SetAnsStrShown(const ChrString& Str_);
    static const ChrString& AnsStrShown(bool* Shown_=NULL);

    /* Recursion limit flag */
    static void SetRecursionLimitReached(int flag_);
    static int RecursionLimitReached();

    /* integer set procedures */
    static void ShowTheList(SimpleList<int>& x);
    static ChrString MakeTheList(SimpleList<int>& x);
    static int InSetNotation(const char* Str_);
    static int InSetNotation(const char* list, int& NewStart_, int& LiteralLen_, int Start_, int len);
    static Set<int>* MakeIntSet(const char* Str_, int Iter_=0);
    static char* RemoveDuplicateSetItems(char* SetStr_);
    static int IsNullSetStr(const char* Str_);

    /* Batch data input files */
    static int WasInBatchDataInput();
    static void SetWasInBatchDataInput(int flag_);
    static int GraphOutputWasSent();
    static void SetGraphOutputWasSent(int flag_);
    static int WaitForeverForSignal();
    static void SetWaitForeverForSignal(bool flag_);

    // graph type list operations
    static void AddGraphType(int Type_, int Subtype_, int Index_);
    static int* GrowGraphTypeList(int incr=0);
    static int* DestroyGraphTypeList();
    static int* ClearGraphTypeList();

    // Quit/Continue graph plotting flags
    static bool GraphFilePause();
    static void SetGraphFilePause(bool flag_);
    static bool InAllGraphsFile();
    static void SetInAllGraphsFile(bool flag_);

    /* External process spawning method */
    int SpawnExternalMcalc(int argc, char** argv);

    /* string manipulation procedures */
    int InQuotes(const char* str, int& Equal_, int& FirstQuote_, int& LastQuote_);
    Uchar* ToUchar(Uchar*, char);
    Uchar* ToUchar(Uchar*, const char*);
    int stringtoken(char*);
    void stripstring(int, char*, char**);
    char* clearleadingspaces(char**);
    void reversestr(char* str, int len);
    void stripws(char*);
    void BlankOut(char* Str_, int Start_, int End_);
    char* ConcatArglist(int argc, char** list, Boolean LeaveSpace_=FALSE);
    const char* GetFncNameFromOpcode(int Opcode_);

    /* file I/O procedures */
    static int IsAtEof(FILE* Finput_);
    static int FileExists(const char* Fname_);
    static FILE* FileOpen(const char* Fname_, const char* Mode_);
    static int FileStreamOpen(ifstream& Fin_, const char* Fname_);
    static const char* SetCurrentGraphFname(const char* Fname_);

    int openfile(FILE** file, const char* name, const char* mode,
                 int Retry_=FALSE, int ExitOnFail_=TRUE,
                 int MaxRetries_=RETRY_READ_MAX);
    int freadstring(char**, char, FILE* Finput_,
                    bool SpecChrs_, bool KeepNewLine_=false);
    int InputDataFileLineSize(const char* Fname_);

    /* stack operation procedures */
    void push(Mcalc_Stack**, Mcalc_StackData);
    void enqueue(Mcalc_Queue**, Mcalc_StackData);
    Mcalc_StackData peek(Mcalc_Stack*);
    Mcalc_StackData pop(Mcalc_Stack**);

    /* expression parsing procedures */
    int priority(Uchar* op);
    void pushop(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, Mcalc_StackData op);

    // token detection procedures
    int isoperand(char* str);
    static int isleftbracket(Uchar tok);
    static int isrightbracket(Uchar tok);
    static int isvalidsymbol(Uchar symbol, int HexOk_);
    int isvalidsymbol(Uchar symbol);
    int isdelimiter(Uchar symbol);

    // token extraction procedures
    int getleftbracket(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, Uchar* token);
    int getrightbracket(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, Uchar* token, int& BalancedBrk_);
    int getoperator(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, Uchar* token);
    int getoperand(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, Uchar* token, char* buffer, int* index);

    // Math expression evaluation procedures
    int FindFncDelim(char* list, size_t len, int** DelimArrayPtr_, size_t ArraySize_);
    int LookAhead(const char* list);
    int FindAssignments(char* list, CalculatorBase* CalcPtr_, int Length_,
                        int& Error_, int RecLevel_, int& StrAssign_, int& StrLength_,
                        int SetIndexes_, AssignmentParsingData& ParseData_);
    int ReplaceTokens(char** list, CalculatorBase* CalcPtr_, int FindAssign_,
                      int& Error_, int& ReEvaluate_, int ReFormat_, int ChangeModes_,
                      int Level_=0);

    int formatlist(char** list, CalculatorBase* CalcPtr_);
	
    // memory management procedures
    void freeoperand(Mcalc_Operand**);
    Mcalc_Operand* allocateoperand(Mcalc_Operand**, int);
    Mcalc_Operand* clearvalue(Mcalc_Operand*);
    Mcalc_Operand* allocatevalue(Mcalc_Operand*, int);
    Mcalc_Operand* reallocatevalue(Mcalc_Operand*, int);

    // string manipulation procedures
    ChrString FindFncParamStr(ChrString& FncStr_, int ParamIndex_);
    static int icasestrcompn(const char* s1, const char* s2, size_t max, bool Skipws_=false);
    static int icasestrcomp(const char* s1, const char* s2, bool SkipWs_=false);

    // initialization, deallocation procedures
    void initarrays(Mcalc_Operand***, char***);
    void freememory(Mcalc_Operand***);
    void freearglist(char***, int);
    void freeargs(char***);
    void freelist(char***);

    // display procedures
    void DumpVariables(CalculatorBase* CalcPtr_);
    void DisplayToString(Mcalc_Operand**, char*);
    bool DisplayAnswerStringHelper(FILE* Fptr_);
    void DisplayAnswerString(bool OverrideClear_=false, bool DoClear_=false);
    void DisplayToProgramOutput(const char* Str_, bool OverrideClear_=false, bool DoClear_=false);
    bool DisplayToUserPrompt(const char* Str_);
    void DisplayMessage(FILE* Fptr_, const char* FormatStr_, const char* Str_, bool Override_=false);
    void DisplayMessage(FILE* Fptr_, const char* Str_, bool Override_=false);
    void DisplayErrorMessage(FILE* Fptr_, int ErrVal_, const char* FormatStr_, const char* Str_);
    void DisplayErrorMessage(FILE* Fptr_, int ErrVal_, const char* Str_);
    void DisplayErrorMessageForCode(FILE* Fptr_, int ErrVal_);
    void DisplayToSpawnArgFile(const char* FormatStr_, const char* Str_, bool AddNewline_=true);
    void DisplayToSpawnArgFile(const char* Str_, bool AddNewline_=true);
    void DisplayToLog(const char* FormatStr_, const char* Str_, bool AddNewline_=true);
    void DisplayToLog(const char* Str_, bool AddNewline_=true);

    void ResetStateVars();
    void ResetGraphOpOptions();
    bool ReCheckEndBatchSignal(bool ResetProg_=false, int* ResetOpsDone_=NULL);
    bool GiveBatchDataStateVars(CalculatorBase* CalcPtr_,
                                bool& InBatch_, bool& NpBatch_, bool& PgBatch_,
                                bool& GraphWaiting_, bool& BatchSigSent_);
    int ResetProgressFile(int size_, bool SendToClient_, bool Reset_,
                          bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);
    int UpdateProgressFile(int size_, int done_, bool SendToClient_,
                           bool* AllDone_=NULL, bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);

    int ResetGraphProgressFile(int size_, bool SendToClient_, bool Reset_,
                               bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);
    int UpdateGraphProgressFile(int size_, int done_, bool SendToClient_,
                                bool* AllDone_=NULL, bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);
    int ResetGraphOperationsFile(bool SendToClient_, bool Reset_,
                                 bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);
    int UpdateGraphOperationsFile(bool SendToClient_, bool* AllDone_=NULL,
                                  bool* BreakAllp_=NULL, bool* DoHaltp_=NULL);

    ChrString DisplayVariable(CalculatorBase* CalcPtr_, char* Original_, int Index_,
                              Boolean SetIoState_=TRUE, Boolean WriteToFile_=FALSE);
    ChrString ShowFracDivZero(const LongNumber& TotalNumer_, const LongNumber& TotalDenom_);

    // help procedure
    void help(int argc, char* argv[]);
    void helpmessage(FILE* fp, const char* msg_);

    // Error checking methods
    void GivePollClientResults(bool& PollingClient_,
                               bool& PollError_, bool& PollAnswered_);
    void SetAllowClientPolling(bool flag_);
    bool ClientPollingAllowed() const;
    bool ConfirmedClientAlive() const;
    void PollClientIfAlive();
    void ReceiveKeepAlivePoll();

    // stack operation procedures
    void delstack(Mcalc_Stack**);
    void delqueue(Mcalc_Queue**);

    // expression parsing procedures
    void pushresult(Mcalc_Operand** operands, Mcalc_Stack** rpnstack, int optype);

    // argument vector list methods
    char** CloneArgVector(int argc, char** argv);
    char** DestroyArgVector(int argc, char** argv);
    void ShowArgVector(int argc, char** argv, FILE* fp, const char* argcntname_=NULL, const char* argvectname_=NULL);

    // Math expression evaluation procedures
    bool HasInvalidTokens() const;
    bool ChkIfMathLineValid(const char* str);
    void SetUnknownDirOrConfirmResults(CalculatorBase* CalcPtr_,
                                       SubExpression* CurrExpr_, bool HasOutput_);
    int ExecDirectives(char** list, char** original, CalculatorBase* CalcPtr_,
                       int* CondArray, bool& GraphCmdFound_, bool& ExecCmdFound_);
    int InfixToRpn(int argc, char** list, Mcalc_Queue** rpnqueue, Mcalc_Stack** opstack,
                   char** original, CalculatorBase* CalcPtr_, int* CondArray, int& CurState_);

    int evaluateRPN(Mcalc_Queue** rpnq, Mcalc_Stack** rpnstack, char** list, int* optype);
    void PushStringCompareTokens(Mcalc_Queue** rpnq, Mcalc_Stack** opstk, const char* buffer, int Start_, int End_, int Optype_);
    int TestForStringComparison(const char* buffer, int& Start_, int& End_, int& Optype_);
    int FindComparisonEndPts(const char* buffer, int& Start_, int& End_);
    int CompareStrings(const char* String1_, const char* String2_, int Optype_);
    int HasVariables(const char* Buffer_);

    static char* ActiveData(CstringStack* ActiveStr_, bool* HasData_=NULL);
    static const char* ActiveData(const CstringStack* ActiveStr_, bool* HasData_=NULL);
    static const char* ActiveConstData(const CstringStack* ActiveStr_, bool* HasData_=NULL);
    static void* ActiveVoidData(CstringStack* ActiveStr_, bool* HasData_=NULL);
    static const void* ActiveVoidData(const CstringStack* ActiveStr_, bool* HasData_=NULL);
    static const void* ActiveConstVoidData(const CstringStack* ActiveStr_, bool* HasData_=NULL);
    static CstringStack* PushActiveData(CstringStack* ActiveStr_, char* Ptr_);
    static CstringStack* PopActiveData(CstringStack* ActiveStr_, int PopAndDelete_);

	// merge or copy graph files
	bool MergeGraphFiles(const char* FinName_, const char* FoutName_, const char* FinalName_, bool KeepOriginals_);
	bool CopyGraphFiles(const char* FinName_, const char* FinalName_, bool KeepOriginal_);

    // virtual math methods implemented in derived classes
    virtual ChrString FindIntersections(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindApproxZero(int NumParams_, FncParameter** ParamArray_, Boolean& ZeroFound_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString EvaluateFunction(const char* FncName_, int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindDerivative(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindDerivative2(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindNewtonsCriteria(int NumParams_, FncParameter** ParamArray_, int& Converge_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString NewtonsMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindRoot(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindMinimum(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString FindMaximum(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString RectToPolar(int NumParams_, FncParameter** ParamArray_, int Retarg_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString PolarToRect(int NumParams_, FncParameter** ParamArray_, int Retarg_) { return _DummyStr ? (*_DummyStr):ChrString(); };

    // File size method
    bool IsOutputFileEmpty_Main(int IoState_,
                                bool Reverse_, bool WarnOnInput_);

    // math helper methods
    Ulong FindIntervalMultiplier(Ulong NumInt_, Ulong IntervalExp_);
    long FindNumIntervals(int NumParams_, FncParameter** ParamArray_);

    // Adding function names method
    void AddFunctionName(const char* FncName_);

    // Asynchronous mode file I/O and IO state procedures
    int SimulatePolling();
    static void SendClientAlive(bool flag_);
    static void SendServerAlive(bool flag_);
    int WaitForClientStates(int CurState_, int ExtStates_, bool* FetchLimitReached_);
    CalculatorBase* SetNoPolling(bool flag_);
    int NoPolling() const;

    int MockClientAck(bool ResponseSent_);
    int NotifyParent(bool ResponseSent_, bool Polling_);

    static bool IsMatchingStates(bool InBatchFile_, int PrevState_, int CurrState_);
    static bool WaitingForServerSend(int State_);

    static bool IsClientStates(int State_);
    static bool IsServerStates(int State_);
    static bool CheckForResendCond(int IoState_);

  public:
    enum
    {
      NO_CALC = 0,
      FLOAT = 1,
      DOUBLE = 2,
      LONGDOUBLE = 3,
      LONGNUM = 4,
      MAXCALC = 5,
      MAXVARS = 26,
      STACKSIZE = 100,
      MAXFUNCTIONS = 100,
      RECURSION_LIMIT = 26,
      FETCH_ERROR_ATTEMPT_LIMIT = 200,

    #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
      OUTPUT_FETCH_ATTEMPT_LIMIT = 200
    #else
      OUTPUT_FETCH_ATTEMPT_LIMIT = 240
    #endif
    };

    enum
    {
      NO_ASSIGN         = 0,
      ASSIGN_ONLY       = 1,
      ASSIGN_PLUS       = 2,
      ASSIGN_MINUS      = 3,
      ASSIGN_MULT       = 4,
      ASSIGN_DIV        = 5,
      ASSIGN_MOD        = 6,
      ASSIGN_AND        = 7,
      ASSIGN_OR         = 8,
      STRING_ASSIGN     = 9,
      STRING_CONCAT     = 10,

      SET_ASSIGN        = 11,
      SET_UNION         = 12,
      SET_INTERSECTION  = 13,
      SET_NEGATION      = 14,
      SET_EXCLUSION     = 15
    };

    enum
    {
      DEGREE,
      RADIAN
    };

    enum
    {
      DISPLAY_TO_STRING,
      DISPLAY_TO_STREAM
    };

    enum
    {
      STRING_ASSIGNMENT = 1,
      STRING_COMPARISON = 2,
      SET_ASSIGNMENT    = 3,
      SET_OPERATION     = 4
    };

    enum
    {
      FLOATINGPOINT_MODE = 101,
      LITERAL_MODE       = 102,
      FRACTION_MODE      = 103,
      ALTBASE_MODE       = 104
    };

    enum
    {
      VARIABLE_CODE      = 0x60,
      UNARYFNC_CODE      = 0x32,
      NUMBER_CODE        = 0x2C,
      PREFIX_CODE        = 0x2A,
      CONSTANT_CODE      = 0x20,
      BINARYFNC_CODE     = 0x11,
      POSTFIXFNC_CODE    = 0x94,
      BINARY             = 0x01,
      UNARY              = 0x02,
      HEXOK              = 0x04,
      ISNUM              = 0x08,
      ISOP               = 0x10,
      RVAL               = 0x20,
      LVAL               = 0x40,
      POSTFIX            = 0x80,
      PREFIX             = 0x8F
    };

    enum
    {
      CMDENTRY_INVALID   = 2,
      CMDENTRY_VALID     = 8
    };

    enum
    {
      PROMPT_DISPLAY_PARTS = 1,
      PROMPT_DISPLAY       = 2,
      PROMPT_END_DISPLAY   = 4,
      PROMPT_INPUT         = 8,
      PROMPT_STOP          = 16,
      PROMPT_STOP_MSG      = 32,
      PROMPT_PAUSE         = 64,
      PROMPT_PAUSE_MSG     = 128
    };

    enum
    {
      EXECFILE_UNLOCKED    = 0,
      EXECFILE_KEY_SET     = 1,
      EXECFILE_LOCKED      = 2
    };

    enum
    {
      IOACCESS           = 1,
      PLOTDONE_NOSHOWCHK = 2,
      PLOTDONE_CHKSHOWN  = 3,
      WAITFORPLOT        = 4,
      INREQALLOWED       = 5
    };

    enum
    {
      UNCHANGED     = -99,
      UNSETFLAG     = 0,
      SETFLAG       = 1,
      UNUSEDFLAG    = 3,

      ATLEASTONESET = 0,
      FIRSTFLAG     = 1,
      SECONDFLAG    = 2,
      SETORUNUSED   = 3,
      BOTHSET       = 4
    };

    typedef int(*InputFncType)(const char*, const char*);
    typedef char*(*OutputFncType)(char*, int);

    static char** FUNCTION_NAMES;
    static int NumFncNames();
    static int ShortestFncName();

    #if CALCLIB_DEBUGGING
      static size_t GetErrline() { return _errline; }
      static size_t GetErrcol() { return _errcol; }
      static int GetErrcode() { return _errcode; }
      static void SetCurrentDebugger(Debugging<CalculatorBase>* ptr);
      static Debugging<CalculatorBase>* DbgPtr(bool Deref_=true);
      static void SetErrorData(int errcode_, const char* file_=__FILE__,
                               size_t line_=__LINE__, size_t col_=0, bool terminate_=false);
      static void Terminate(bool setcode_=false, int errcode_=0);
    #endif

    CalculatorBase(int argc=0, char** argv=NULL);
    virtual ~CalculatorBase();

    // memory management procedures
    void* allocmem(unsigned, unsigned, void*);
    void* reallocmem(unsigned, unsigned, void*);
    char* FlexResizeBuffer(char* Buffer_, size_t& oldsize_, size_t newsize_);
    static char* AllocateNewString(DelayedMemoryDeleter* MemDel_, char* Buffer_,
                                   size_t NewLen_, bool DelOld_, bool AlwaysNew_);

    // File name creation and retrieval
    static void CreateDefaultFileNames(const Integer& SesNum_);
    static const char* GetSpawnArgFilename();
    static const char* GetLogFilename();
    static const char* GetCurrentErrorFilename();
    static const char* GetUserInputFilename();
    static const char* GetUserPromptFilename();
    static const char* GetProgramOutputFilename();
    static const char* GetCommandHistoryFilename();
    static const char* GetDataInputFilename();
    static const char* GetDataOutputFilename();
    static const char* GetProgramIostateFilename();
    static const char* GetCurrentGraphFilename();
    static const char* GetGraphOperationFilename();
    static const char* GetGraphProgressFilename();
    static const char* GetServerAliveFilename();
    static const char* GetClientAliveFilename();
    static const char* GetPollStateFilename();
    static const char* GetProgressFilename();
    static const char* GetElapsedTimeFilename();
    static const char* GetFileSessionNumberSuffix();
    static const char* CurrentGraphFname();

    // printable characters for string utility functions
    static char* GivePrintCharSet();

    // valid characters in function names for string utility functions
    static char* GiveFuncNamesCharSet();

    // return error check return value: true if math expression is valid, false otherwise
    static bool MathLineValid();

    // Zero length input string read
    static bool ZeroLenInput();

    // Graph plotting
    CalcGraphPlotter* MakeGraphPlotter(int Reset_);
    void SetPlotGraph(bool SetPlot_, int PlotFlag_,
                      bool SetGrOp_=false, int GrOpFlag_=0, int Reset_=0);

    static int GraphOperation();
    static bool DoPlotGraph();

    static int TotalGraphTypes();
    static void SetGraphType(int Type_, int Subtype_=0);
    static void ReplaceGraphType(int Type_, int Subtype_=0);
    static const int* GraphTypeVect();
    static void AddGraphType(int Type_, int Subtype_=0);
    static const int* NextGraphTypeVect(int& Index_, bool IncrNext_);
    static bool HasGraphType(int Type_, int Subtype_=0, bool Skip1st_=false);
    static int GraphType();
    static int GraphSubtype();

    static const char* GraphPlotOpTypeToStr(int PlotOpType_);
    static const char* GraphTypeToStr(int GraphType_);

    static void SetPlottingGraph(bool flag_);
    static bool PlottingGraph();
    static void SetPlottingDone(bool flag_);
    static bool PlottingDone();
    static void SetGraphCompleted(bool flag_);
    static bool GraphCompleted();
    static void SetPlotAllPoints(bool Flag_);
    static bool PlotAllPoints();
    static CalcGraphPlotter* GetGraphPlotter();
    static void DestroyGraphPlotter();

    // global expression string stack methods
    ExprStringStack* MakeStringStack();
    ExprStringStack* GiveStringStack(bool MakeIfNull_);

    static void SetOwnsStringStack(bool flag_);
    static void ResetStringStack();
    static bool OwnsStringStack();
    static bool HasStringStack();
    static ExprStringStack* DestroyStringStack();

    // Session management methods
    static int UsesSessionNum();
    static int SessionNum();
    static int SessionOption();
    static int InAsyncMode();

    // Calculator object memory valid/invalid methods
    static int CalculatorExists(int ClassNumber_);
    static void SetCalculatorCreated(int ClassNumber_);
    static void SetCalculatorDestroyed(int ClassNumber_);
    virtual int ClassNumber() const { return 0; }

    // Exit from program mode because BREAK signal sent
    static void SetBreakFromProgram(int flag_);
    static int ShouldBreakFromProgram(CalculatorBase* CalcPtr_=NULL);
    static void ResetPostBreakResponse();
    static int PostBreakResponseSent();

    // Variable index methods
    static int VariableIndexFound();
    static void ResetVarIndexFound();

    // command line options data structure
    static Mcalc_CmdLineOptions* CmdLineOptions();

    // Graph plotting operation options
    static Mcalc_GraphOperationOptions* GraphOperationOptions();

    // file I/O procedures
    long FileSize(FILE* Fptr_);
    inline bool IsOutputFileEmpty(int IoState_, bool WarnOnInput_=false)
        { return IsOutputFileEmpty_Main(IoState_, false, WarnOnInput_); }
    inline bool IsOutputFileNotEmpty(int IoState_, bool WarnOnInput_=false)
        { return IsOutputFileEmpty_Main(IoState_, true, WarnOnInput_); }
    static void SetInputPromptWarning(bool Flag_);
    static bool InputPromptWarning();
    void restorefiles();
    void getfiles(int* argc, char** argv, int* cmdline);
    int readfile(int*, char**, char***, int);
    int readuserinput(int*, char***);
    int ReadUserInputExtended(int* argc, char* argv[], char*** list, int cmdline);
    int ReadFromCurrentError(ChrString& Output_);

    void FetchAndShowCurrentError(ChrString& QuestionStr_);
    void FindCmdLineOptions(int argc, char** argv,
                            Mcalc_CmdLineOptions* Options_);
    void closefiles(void);
    void closeIOfiles(void);

    void ShowClientPollFailed(bool Exit_);
    void ShowServerPollFailed(bool Exit_);
    void ShowOpenStateFileFailed(bool Exit_);

    FILE* GetInputFile();
    FILE* GetUserInputFile(bool TestMode_=false,
                           bool InputWrite_=false);
    FILE* GetLogFile();
    FILE* GetSpawnArgFile();  // new
    FILE* GetCurrentErrorFile(bool OpenForWrite_);
    FILE* GetClientAliveFile(int Write_, bool Rewind_=false);
    FILE* GetServerAliveFile(int Write_, bool Rewind_=false);
    FILE* GetPollStateFile(int Write_, bool Rewind_=false);
    FILE* GetCommandHistoryFile();
    FILE* GetProgressFile(bool OverrideClear_=false,
                          bool DoClear_=false, bool ReOpen_=false);
    FILE* GetElapsedTimeFile(bool OverrideClear_=false,
                             bool DoClear_=false, bool ReOpen_=false);
    FILE* GetGraphProgressFile(bool OverrideClear_=false,
                               bool DoClear_=false, bool ReOpen_=false);
    FILE* GetGraphOperationFile(bool OverrideClear_=false,
                                bool DoClear_=false, bool ReOpen_=false);
    FILE* GetGuiOutputFile(bool OverrideClear_=false,
                           bool DoClear_=false, bool ReOpen_=false);
    FILE* GetOutputFile(bool OverrideClear_=false,
                        bool DoClear_=false, bool ReOpen_=false);
    FILE* GetUserPromptFile(bool OverrideClear_=false,
                            bool DoClear_=false, bool ReOpen_=false);

    void CloseLogFile();
    void CloseSpawnArgFile();  // new
    void CloseCurrentErrorFile();
    void CloseCommandHistoryFile();
    void CloseClientAliveFile();
    void CloseServerAliveFile();
    void ClosePollStateFile();
    void CloseInputFile(bool ClearInputFile_=false);
    void CloseUserInputFile(bool TestMode_, bool ClearInputFile_=false);
    void CloseProgressFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseElapsedTimeFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseGraphProgressFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseGraphOperationFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseGuiOutputFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseOutputFile(bool OverrideClose_=false, bool DoClose_=false);
    void CloseUserPromptFile(bool OverrideClose_=false, bool DoClose_=false);

    void ResetOutputFiles(bool ClearPrompt_);
    void ClearOutputFile(bool OverrideClear_=false,
                         bool DoClear_=false, bool DoClose_=true);
    void ClearGuiOutputFile(bool OverrideClear_=false,
                            bool DoClear_=false, bool DoClose_=true);
    void ClearCommandHistoryFile();
    void ClearUserPromptFile();
    Ldouble* StatFileToArray(ifstream& Fin_, size_t& sz);

    CalculatorBase* TieOutputToSignal(int Signal_);
    CalculatorBase* ClearOutputToSignal();
    static int IsOutputTiedToSignal(int Signal_)
        { return ((Signal_ & _OutputTiedToSignal)); }
    static int OutputTiedToSignal()
        { return _OutputTiedToSignal; }

    // Calculator session procedures
    static void InitializeFiles();
    void SetUsesSessionNum(int Num_);
    static void SetSessionNum(int Num_);
    static void SetSessionOption(int flag_);
    void SetAsyncMode(int Flag_);
    void RemoveSessionFiles(int SesNum_);

    // Asynchronous mode file I/O and IO state procedures
    static CalcIoStateHandler* GetIoStateHandler();
    static bool ErrorStatePending();
    static const char* IoStateToStr(int State_);
    static const char* TimeoutStateToStr(int State_);
    static ChrString GiveIoStateStr(int State_);
    static ChrString GiveTimeoutStateStr(int State_);
    bool InIoStatePendingMode(bool InclAllCases_) const;
    bool ClearPendingErrors(bool IgnoreMode_=false);
    bool SetIoStateInMode(int State_, bool NoDup_=false, int Delay_=0);
    void Bare_SetIoState(int State_, bool NoDup_=false, int Delay_=0);

    int AtConfirmedModeAndLevel(SubExpression* SubExpr_,
                                int Mode_, bool OrZero_);
    int CheckInAltAnswerMode(char* arglist, bool HasMoreOps_, bool& Confirmed_,
                             bool& IsFrac_, bool& IsLiteral_, bool& IsAltBase_);
    bool GiveIoAccessCondition(CalculatorBase* CalcPtr_,
                               int AccessFlag_, bool SesOptOverride_=false);

    void SetIoState(int State_, bool NoDup_=false,
                    int Delay_=0, bool WaitForAck_=true);
    int Bare_GetIoState(int Sleep_, int retry_=1);
    int GetIoState(int Sleep_);
    int CurrentIoState() const;
    void SetWaitForResponse(int Flag_);
    int WaitForResponse() const;

    // Calc. Elapsed time timer methods
    int SetCalcTimeoutState(int State_, const char* From_=NULL);
    int GetCalcTimeoutState(int Sleep_, const char* From_=NULL);
    int CurrentTimeoutState() const;

    void ClearDirective();
    bool HasDirective() const;
    bool IsSameDirective(const char* DirStr_) const;
    void SetDirective(const char* DirStr_);
    const char* GetDirective() const;
    void ReceiveBreakOrQuit(int State_);

    //////////////////////////////////////////////////////////////////
    // Calling map of I/O signal sending methods for:
    // CalculatorBase and CalcProgram classes
    //
    // SendGraphWaitSignal:
    //   CalculatorBase::ResetGraphOperationsFile
    //   CalculatorBase::UpdateGraphOperationsFile
    //
    //   CalculatorBase::SendIoState
    //
    //   CalcProgram::SendIoState
    //
    // SendGraphProgressSignal:
    //   CalculatorBase::ResetGraphProgressFile
    //   CalculatorBase::UpdateGraphProgressFile
    //
    //   CalculatorBase::SendIoState
    //
    //   CalcProgram::SendIoState
    //
    // SendGraphOutputSignal:
    //   CalculatorBase::ResetGraphOperationsFile
    //   CalculatorBase::UpdateGraphOperationsFile
    //   CalculatorBase::InfixToRpn
    //
    //   CalculatorBase::SendIoState
    //     SubExpression::ShowResults
    //     CalculatorBase::DisplayAnswerStringHelper
    //     CalculatorBase::DisplayAnswerString
    //     CalculatorBase::DisplayToProgramOutput
    //
    //   CalcProgram::SendIoState
    //
    //   LineCalculator<T>::FileInput
    //
    // SendCalcResponseSignal:
    //   SubExpression::ShowResults
    //
    //   CalculatorBase::SendIoState
    //     SubExpression::ShowResults
    //     LineCalculator<T>::FileInput
    //     CalculatorBase::DisplayAnswerStringHelper
    //     CalculatorBase::DisplayAnswerString
    //     CalculatorBase::DisplayToProgramOutput
    //     void CalcProgram::ReceiveResponse(int Response_)
    //
    //   CalculatorBase::DisplayAnswerString
    //     SubExpression::ShowResults
    //
    //   CalculatorBase::DisplayToProgramOutput
    //     CalculatorBase::DisplayVariable
    //     CalculatorBase::DisplayMessage
    //     CalculatorBase::DisplayMessage
    //     CalculatorBase::DumpVariables
    //
    //   CalcProgram::SendIoState
    //     CalcProgram::ReceiveResponse
    //
    //   LineCalculator<T>::FileInput
    //
    // SendOutputReadySignal:
    //   CalculatorBase::SendIoState
    //     SubExpression::ShowResults
    //     LineCalculator<T>::FileInput
    //     CalculatorBase::DisplayAnswerStringHelper
    //     CalculatorBase::DisplayAnswerString
    //     CalculatorBase::DisplayToProgramOutput
    //
    //   CalculatorBase::ExecDirectives
    //     LineCalculator<T>::FileInput
    //
    //   CalcProgram::SendIoState
    //     CalcProgram::Execute_Command
    //     CalcProgram::Execute_Command
    //     CalcProgram::Execute_End_Display
    //     CalcProgram::Execute_Display
    //
    //     CalculatorBase::PromptAsyncUser
    //       LineCalculator<T>::FindPermutations
    //       LineCalculator<T>::FindCombinations
    //       LineCalculator<T>::FindPermutationsWithRep
    //       LineCalculator<T>::FindCombinationsWithRep
    //       LineCalculator<T>::FileInput
    //       CalculatorBase::InfixToRpn
    //
    //   LineCalculator<T>::ExecInputDataFile
    //     CalculatorBase::InfixToRpn
    //
    //   LineCalculator<T>::FileInput
    //
    // SendInputRequiredSignal:
    //   CalculatorBase::SendIoState
    //
    //   CalcProgram::SendIoState
    //     CalcProgram::Execute_Prompt
    //     CalcProgram::Execute_Input
    //     CalcProgram::Execute_CalcInput
    //     CalcProgram::Execute_Pause
    //     CalcProgram::Execute_Stop
    //     CalcProgram::Execute_Stop
    //     CalcProgram::Execute_Menu
    //
    //     CalculatorBase::PromptAsyncUser
    //       LineCalculator<T>::FindPermutations
    //       LineCalculator<T>::FindCombinations
    //       LineCalculator<T>::FindPermutationsWithRep
    //       LineCalculator<T>::FindCombinationsWithRep
    //       LineCalculator<T>::FileInput
    //       CalculatorBase::InfixToRpn
    //
    //////////////////////////////////////////////////////////////////

    // I/O Signal sending methods
    static void SetBatchFileEndedSignalConfirmed(int flag_);
    static int BatchFileEndedSignalConfirmed(int sent_=true);

    int SendClientPingSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendBatchFileEndedSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendGraphWaitSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendGraphProgressSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendInFileProgressSignal(int Delay_, bool* BreakAll_=NULL,
                                 bool* DoHalt_=NULL, bool Retrying_=false);
    int SendElapsedTimeSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendGraphOutputSignal(int Delay_, bool InBatch_,
                              bool* BreakAll_=NULL, bool* DoHalt_=NULL, bool Retrying_=false);
    int SendOutputReadySignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendCalcResponseSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendProcessAckSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendInputRequiredSignal(int Delay_, bool* BreakAll_=NULL, bool* DoHalt_=NULL);
    int SendSpawnCalcSignal(int Delay_, int argc, char** argv, char** envr,
                            bool* BreakAll_=NULL, bool* DoHalt_=NULL);

    void SendIoState(int State_, bool NoDup_=false, int Delay_=0);

    // I/O Signal response receiving methods
    int WaitForClientPingAck(int CurState_, bool* FetchLimitReached_=NULL);
    int WaitForProcessAckReceived(int CurState_, bool* FetchLimitReached_=NULL);
    int WaitForBatchFileEndedAck(int CurState_,
                                 bool* FetchLimitReached_=NULL, bool Retrying_=false);
    int WaitForClientGraphWaitStates(int CurState_, bool* FetchLimitReached_=NULL);
    int WaitForClientGraphProgressStates(int CurState_, bool* FetchLimitReached_=NULL);
    int WaitForClientInFileProgressStates(int CurState_,
                                          bool* FetchLimitReached_=NULL, bool Retrying_=false);
    int WaitForClientElapsedTimeAck(int CurState_,
                                    bool* FetchLimitReached_=NULL, bool* OverDuration_=NULL);
    int WaitForClientSpawnCalcStates(int CurState_, bool* FetchLimitReached_=NULL);  // new
    int WaitForClientProcessStates(int CurState_, bool* FetchLimitReached_=NULL);
    int WaitForClientOutputStates(int CurState_,
                                  bool* FetchLimitReached_=NULL, bool Retrying_=false);
    int WaitForClientOutputExtStates(int CurState_,
                                     bool* FetchLimitReached_=NULL, bool Retrying_=false);

    int WaitForClientTimeoutAck(int CurState_,
                                bool* FetchLimitReached_=NULL, bool* OverDuration_=NULL);
    int WaitForClientIoState(int CurState_, int IoStates_,
                             bool SetMaxRetries_, int MaxRetries_=0, bool* FetchLimitReached_=NULL);

    // virtual math methods implemented in derived classes
    static char PlotFileSuffix();
    static void SaveCurrentGraphName(const char Suffix_);
    virtual bool PlotFunctionSub(char* PlotFileSuffix_,
                                 int NumParams_, FncParameter** ParamArray_,
                                 const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL) { return false; }
    virtual ChrString PlotFunction(int NumParams_, FncParameter** ParamArray_,
                                   const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL) { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual ChrString FindIntegral(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString MullersMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_) { return _DummyStr ? (*_DummyStr):ChrString(); };
    virtual ChrString SolveMatrix(int NumParams_, FncParameter** ParamArray_) { return _DummyStr ? (*_DummyStr):ChrString(); };

    // methods for creating and transferring Data Stacks and other shared data to child calc.
    virtual void CreateDataStacks() = 0;        // also creates Calc. program data stack
    virtual void TransferToAllChildCalcs() = 0; // transfer shallow copies to all child calc. objects

    // Allow empty response for CALC_RESPONSE signal
    bool EmptyResponseAllowed();
    CalculatorBase* AllowEmptyResponse(bool flag_=true);

    // Override for IoState operations while in SessionOption mode
    int HandleForcedIoStateSignals();
    bool SessionOptionOverride() const;
    CalculatorBase* SetSessionOptionOverride(bool flag_);
    virtual CalculatorBase* SetIoStateForced(bool flag_) = 0;
    virtual bool IoStateForced() const = 0;

    // program mode output buffer methods
    virtual void DestroyOutputBuffer() = 0;
    virtual int TransferOutputBuffer(CalculatorBase* ptr) { return 0; }
    virtual void AssignToNullOutputBuffer() = 0;
    virtual int OutputBufferExists() const { return 0; }
    virtual int ErrorArgStrExists() const { return 0; }
    virtual int SendToOutputBuffer(const char* str, bool Reset_) { return 0; }
    virtual int SendToErrorArgStr(const char* str, bool Reset_) { return 0; }
    virtual int SendToOutputBuffer(const char* str) { return 0; }
    virtual int SendToErrorArgStr(const char* str) { return 0; }
    virtual int ResetOutputBuffer() { return 0; }
    virtual int ResetErrorArgStr() { return 0; }
    virtual int AppendToOutputBuffer(const char* str) { return 0; }
    virtual ChrString GiveOutputBuffer() const { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual ChrString GiveErrorArgStr() const { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual void SetUseErrorArgStr(bool DoUse_, const char* str=NULL) = 0;
    virtual bool UsingErrorArgStr() const { return false; }

    static int* MakeOutputErrorsMaxSel();
    static int* MakeOutputErrorsErrVals();

    static void SetNoOutputReturned(CalculatorBase* CalcPtr_, int flag_);
    static void SetOutputCondition(int Cond_);
    static void SetOutputConditionOnDataType();
    static void ClearOutputCondition(CalculatorBase* CalcPtr_, bool PreservePrgCond_=true);
    static void ClearOutputDataErrorCode(int Code_=0);
    static void ClearCalcPrgConditions();
    static int OutputDataErrorCode();
    static int HasErrorCondition();
    static int FindAndSetOutputDataErrors(CalculatorBase* CalcPtr_);
    static int IsProgramSelected();
    static int HasProgramLoadError();
    static int HasInvalidProgramSwitchError();
    static int HasFormatError();
    static int HasConversionError();
    static int HasMutualExclOptError();
    static int HasNullCalcPtrError();
    static int NoOutputReturned();

    // Steps only valid if calculator is in graph operations
    static void SetResponsePending(bool flag_);           // step 1
    static bool ResponsePending();
    static void SetClientAckToGraphWait(bool flag_);      // step 2
    static bool ClientAckToGraphWait(bool InProc_=true);

    static void SetGraphProgressSent(bool flag_);         // step 3
    static bool GraphProgressSent();
    static void SetClientAckToGraphProgress(bool flag_);  // step 4
    static bool ClientAckToGraphProgress(bool InProc_=true);

    static void SetResponseCompleted(bool flag_);         // step 5
    static bool ResponseCompleted();
    static void SetResponseWasCompleted(bool flag_);      // step 5b
    static bool ResponseWasCompleted();

    static void SetClientAckToGraphOutput(bool flag_);         // step 6
    static bool ClientAckToGraphOutput(bool InProc_=false);
    static void SetClientAckedDoneToGraphOutput(bool flag_);   // step 6b
    static bool ClientAckedDoneToGraphOutput();

    // Steps only valid if calculator is in input batch file
    static void SetCalcProgressSent(bool flag_);          // step 1
    static bool CalcProgressSent();
    static void SetCalcProgressWasSent(bool flag_);       // step 1b
    static bool CalcProgressWasSent();

    static void SetClientAckToCalcProgress(bool flag_);        // step 2
    static bool ClientAckToCalcProgress(bool InProc_);
    static void SetClientAckedDoneToCalcProgress(bool flag_);  // step 2b
    static bool ClientAckedDoneToCalcProgress();

    static void AppendOutputDataType(CalculatorBase* CalcPtr_, int Type_);
    static void SetOutputDataType(CalculatorBase* CalcPtr_, int Type_, bool Clear_=true);
    static void SetOutputDataIndex(CalculatorBase* CalcPtr_, int Index_);
    static int IsOutputCondition(int Cond_);
    static int IsOutputDataType(int Type_);
    static int IsOutputDataIndexSet();
    static int GiveOutputDataIndex(bool& IndexSet_);
    static void ClearOutputDataType(CalculatorBase* CalcPtr_=NULL);
    static int DataOutputted(int Type_=0);
    static int ProgressOutputted();
    static int VariablesDumped();
    static int VariableDisplayed(int Type_);
    static int AnswerOutputted(int Type_);
    static int MessageOutputted(int Type_);

    // Subexpression methods
    // -- SubExpression** matrix methods
    virtual void CreateNewSubExpr() = 0;
    virtual void CreateNewSubExpr(SubExpression* Parent_, int Level_, const char* Expr_) = 0;
    virtual void DestroySubExprStack(int PopAndDelete_=0) = 0;
    virtual int SubExprStackExists() const { return 0; }
    virtual int FindInSubExprStack(SubExpression* ptr, long* index_=NULL) { return 0; }
    virtual int PopSubExprStack(int PopAndDelete_=0) { return 0; }
    virtual SubExpression* TopSubExprStack(bool GiveExecExpr_=false) { return NULL; }
    virtual void ResizeExprStack() = 0;
    virtual long SubExprStackSize() const { return 0; }
    virtual long SubExprStackIndex() const { return 0; }
    virtual int AtLowestExprLevel(int Level_) { return 0; }
    virtual ChrString EvalFncWithValue(const ChrString& ExprStr_, const ChrString& VarName_,
                                       const ChrString& Value_, bool PlotOff_=false, bool* Error_=NULL) { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual ChrString ReEvaluate(const ChrString& ExprStr_, bool* Error_=NULL) { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual int TransferVarsForSubExpr(CalculatorBase* ptr) { return 0; }
    virtual void AssignToNullVarsForSubExpr() = 0;

    // -- PointerStack<SubExpression> methods
    virtual SubExpression* ActiveExpression(bool* HasData_=NULL) { return NULL; }
    virtual const SubExpression* ActiveExpression(bool* HasData_=NULL) const { return NULL; }
    virtual const SubExpression* ActiveConstExpression(bool* HasData_=NULL) const { return NULL; }
    virtual int PushActiveExpression(SubExpression* Ptr_) { return 0; }
    virtual int PopActiveExpression(int PopAndDelete_=0) { return 0; }

    // Currently active and executing SubExpression object
    virtual SubExpression* ExecutingExpression() = 0;
    virtual void SetExecutingExpression(SubExpression* SubExpr_) = 0;

    // Calc. Program methods
    // -- CalcProgram** matrix methods
    virtual CalcProgram* CreateNewProgram(const char* PrgName_,
                                          bool SetExecLevel_=false) { return NULL; }
    virtual CalcProgram* GiveNewProgramPtr() { return NULL; }
    virtual int InsertProgramToStack(CalcProgram* Program_) { return 0; }
    virtual CalcProgram* FindProgramFromIndex(long Index_) { return NULL; }
    virtual const CalcProgram* FindProgramFromIndex(long Index_) const { return NULL; }
    virtual void DestroyProgramStack(int PopAndDelete_=0) = 0;
    virtual int ProgramStackExists() const { return 0; }
    virtual int FindInProgramStack(CalcProgram* ptr, long* index_=NULL) { return 0; }
    virtual int PopProgramStack(int PopAndDelete_=0, int DecrIndex_=0) { return 0; }
    virtual CalcProgram* TopProgramStack() { return NULL; }
    virtual void ResizeProgramStack() = 0;
    virtual long ProgramStackSize() const { return 0; }
    virtual long ProgramStackIndex() const { return 0; }
    virtual int AtLowestProgramLevel(int Level_) { return 0; }
    virtual int TransferVarsForProgram(CalculatorBase* ptr) { return 0; }
    virtual void AssignToNullVarsForProgram() = 0;
    virtual bool ResetProgramID(bool ResetPrevID_) = 0;

    // -- PointerStack<CalcProgram> methods
    virtual CalcProgram* ActiveProgram(bool* HasData_=NULL, int segno=0) { return NULL; }
    virtual const CalcProgram* ActiveProgram(bool* HasData_=NULL, int seqno=0) const { return NULL; }
    virtual const CalcProgram* ActiveConstProgram(bool* HasData_=NULL, int seqno=0) const { return NULL; }

    virtual int PushActiveProgram(CalcProgram* Ptr_) { return 0; }
    virtual int PopActiveProgram(int PopAndDelete_=0,
                                 bool SetExecLevel_=false) { return 0; }

    // -- long* program ID and program active/inactive status methods
    virtual int ExecProgramPopped(long IdVal_=0) const { return 0; }
    virtual int SetExecProgramPopped(long flag_, long IdVal_=0) { return 0; }
    virtual int ResetExecProgramPopped(long IdVal_=0) { return 0; }
    virtual CalcProgram* FindProgramFromID(long IdVal_, bool CheckActive_) { return NULL; }
    virtual const CalcProgram* FindProgramFromID(long IdVal_, bool CheckActive_) const { return NULL; }
    virtual long GiveProgramID() const { return 0; }
    virtual long GivePrevProgramID() const { return 0; }

    // Error reporting and handling
    virtual int GetErrorVal() const { return 0; }
    virtual int HasErrors() const { return 0; }
    virtual void ClearError() = 0;
    virtual void SetError(int ErrVal_, bool ClearErr_=false) = 0;
    virtual int HasMultiErrors() const = 0;
    virtual int FindMultiErrors(int& ErrorCnt_, int& ErrorVal_) { return 0; }
    virtual void SetMultiErrorVector(int Vect_, int* MaxSel_, int* ErrVals_, int size_) = 0;
    virtual void SetSuppressOutput(int Flag_, int ShowSuppressedErrors_=TRUE) = 0;
    virtual int SuppressOutput() const { return 0; }

    virtual int AssignCalcData(CalculatorBase* CalcPtr_, int CalcType_) { return 0; }
    virtual ChrString ToString(int Index_) { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_) { return 0; }
    virtual size_t GetVariableLength(int Index_) const { return 0; }
    virtual int GiveType() const { return 0; }
    virtual void SubstToken(char* ArgStr_, int& StrIndex_, int VarIndex_) = 0;
    virtual size_t LongestCmdEntry() const { return 0; }
    virtual char* MakeCmdHistoryPrompt(size_t sz) { return NULL; }
    virtual int ShowCmdHistoryEntry(Boolean RepeatEntry_=FALSE) { return 0; }
    virtual void ResetIndexes() = 0;
    virtual void SetIndex(int Pos_, int Val_) = 0;
    virtual void GetIndex(int& Pos_, int& Val_) = 0;
    virtual int HasIndex() { return 0; }
    virtual void PopIndex() = 0;
    virtual int StoreResults() { return 0; }
    virtual void SetAngleUnit(int Unit_) = 0;
    virtual int GetAngleUnit() const { return 0; }
    virtual CalculatorBase* SetupCalculators(int CalcType_) { return NULL; }

    virtual int ProcessCmdLine(int argc, char** argv) { return 0; }
    virtual void EvaluateLine(int argc, CalculatorBase* CalcPtr_, Mcalc_Operand** operands, char** arglist) = 0;
    virtual int FileInput(int argc, char** argv, CalculatorBase* CalcPtr_) { return 0; }
    virtual void ProgramProc(int argc, char** argv, CalculatorBase* CalcPtr_) = 0;
    virtual int TransferData(char* argstr, CalculatorBase* CalcPtr_) { return 0; }
    virtual int EvalExpression(char* argstr, CalculatorBase* CalcPtr_) { return 0; }
    virtual int EvalPrgExpression(char* argstr, CalculatorBase* CalcPtr_) { return 0; }
    virtual int ExecInputDataFile(const char* Fname_, int LinePause_, const char* OutFname_=NULL) { return 0; }
    virtual void SetHasCommandOutput(int Flag_, int TiedSignal_=0, SubExpression* SubExpr_=NULL) = 0;
    virtual Boolean HasCommandOutput(int TiedSignal_=0, bool* HasOut_=NULL) const { return 0; }
    virtual void SetCalcIndexes(int Prev_, int New_) = 0;
    virtual int TransferVariable(int DestIndex_, int SrceIndex_) { return 0; }
    virtual void SwitchCalcType(int CalcType_) = 0;
    virtual void SetCalcType(int CalcType_) = 0;
    virtual void TransferCalcType(int CalcType_) = 0;
    virtual int TransferIntsAndExtrema(int CalcType_, int PrevCalc_) { return 0; }
    virtual int RestoreCalcType() { return 0; }
    virtual const char* GetPrecision() { return NULL; }
    virtual void SetParentDestroyed(bool flag_) = 0;
    virtual bool ParentDestroyed() const { return false; }
    virtual void SetParent(CalculatorBase* Ptr_) = 0;
    virtual void SetChild(CalculatorBase* Ptr_) = 0;
    virtual const CalculatorBase* Parent() const { return NULL; }
    virtual CalculatorBase* Parent() { return NULL; }
    virtual const CalculatorBase* Child() const { return NULL; }
    virtual CalculatorBase* Child() { return NULL; }
    virtual CalculatorBase* GetCalcType() { return NULL; }
    virtual CalculatorBase* GetPrevCalcType() { return NULL; }
    virtual int GetCalcIndex() const { return 0; }
    virtual int GetPrevCalcIndex() const { return 0; }
    virtual void ProcessExpr(Mcalc_Operand**, char**, int, CalculatorBase*) = 0;
    virtual void SetProcessVariables(int Value_) = 0;
    virtual int ProcessVariables() const { return 0; }
    virtual int InInputDataFileMode() const { return 0; }
    virtual int InProgramMode(bool InclPrompter_,
                              bool InclInfile_=false) const { return 0; }
    virtual void SetNumberBase(int Base_) = 0;
    virtual void RestoreNumberBase() = 0;
    virtual int NumberBase() const { return 0; }
    virtual int RecursionLimit() const { return 0; }
    virtual void SetRecursionLimit(int Limit_) = 0;
    virtual double GraphPrecision() const { return 0; }
    virtual void SetGraphPrecision(double Prec_) = 0;
    virtual double DetermineGraphPrecision() { return 0; }

    static void ClearGraphs();
    static bool SuspendPolling();
    static bool ResumePolling();

    int EndOfBatchFileProcessing();
    void PauseCalcPolling();
    void ResumeCalcPolling();
    bool CalcPollingActive();

    virtual void SetSavedXpos(int xpos_) = 0;
    virtual int SavedXpos() const { return 0; }
    virtual void DisplayCommandHistoryList() = 0;
    virtual void WriteCommandHistoryEntry(FILE* Fptr_, int index_) = 0;
    virtual void EndCommandHistoryList() = 0;
    virtual void SetHistoryListEnded(int flag_) = 0;
    virtual int CommandHistoryListEnded() const { return 0; }
    virtual void SetHistoryListMode(int flag_) = 0;
    virtual int CommandHistoryMode() const { return 0; }
    virtual void SetHistoryListIndex(int val_) = 0;
    virtual int IncHistoryListIndex(int val_=1, int IncOrder_=CalculatorBase::PREFIX) { return 0; }
    virtual int DecHistoryListIndex(int val_=1, int DecOrder_=CalculatorBase::PREFIX) { return 0; }
    virtual int CommandHistoryIndex() const { return 0; }
    virtual void SetHistoryListLength(int val_) = 0;
    virtual int IncHistoryListLength(int val_=1, int IncOrder_=CalculatorBase::PREFIX) { return 0; }
    virtual int DecHistoryListLength(int val_=1, int DecOrder_=CalculatorBase::PREFIX) { return 0; }
    virtual int CommandHistoryLength() const { return 0; }
    virtual char* AllocateHistoryListEntry(int size_) { return NULL; }
    virtual char* DeallocateHistoryListEntry() { return NULL; }
    virtual void SetHistoryListEntry(char* str, int strcopy_, const char* conststr_=NULL) = 0;
    virtual const char* CommandHistoryEntry() const { return NULL; }
    virtual char* CommandHistoryEntry() { return NULL; }
    virtual char* AllocateHistoryListPrompt(int size_) { return NULL; }
    virtual char* DeallocateHistoryListPrompt() { return NULL; }
    virtual void SetHistoryListPrompt(char* str, int strcopy_, const char* conststr_=NULL) = 0;
    virtual const char* CommandHistoryPrompt() const { return NULL; }
    virtual char* CommandHistoryPrompt() { return NULL; }
    virtual char** AllocateHistoryList(int size_) { return NULL; }
    virtual char** GiveHistoryList() { return NULL; }
    virtual char* AllocateHistoryListElement(int index, int size_) { return NULL; }
    virtual char* AllocateHistoryListElement(int index, int size_) const { return NULL; }
    virtual void DeallocateHistoryListAll() = 0;
    virtual char** DeallocateHistoryList() { return NULL; }
    virtual char* DeallocateHistoryListElement(int index) { return NULL; }
    virtual void SetHistoryListElementStr(int index, const char* str) = 0;
    virtual void SetHistoryListElementValid(int index, int valid_) = 0;
    virtual void SetHistoryListElementSize(int index, Ushort size_) = 0;
    virtual char** HistoryListBase(int offset=0) { return NULL; }
    virtual CalculatorBase::CONSTARRAY HistoryListBase(int offset=0) const { return NULL; }
    virtual char* HistoryListElementBase(int index, int offset=0) { return NULL; }
    virtual const char* HistoryListElementBase(int index, int offset=0) const { return NULL; }
    virtual const char* HistoryListElementStr(int index) const { return NULL; }
    virtual int HistoryListElementValid(int index) const { return 0; }
    virtual Ushort HistoryListElementSize(int index) const { return 0; }

    // I/O function pointers
    virtual int UsesConsoleIO() const { return 0; }
    virtual int UsesConsoleInput() const { return 0; }
    virtual int UsesConsoleOutput() const { return 0; }
    virtual char* UseConsoleInputFnc(char* Buffer_, int Size_) { return NULL; }
    virtual int UseConsoleOutputFnc(const char* Buffer_) { return 0; }

    // Graph plotting operation flags
    virtual int GraphProgressAmount() const = 0;
    virtual int GraphSizeAmount() const = 0;
    virtual void SetGraphProgressAmount(int amt) = 0;
    virtual void SetGraphSizeAmount(int amt) = 0;
    virtual int InFileProgressAmount() const = 0;
    virtual int InFileSizeAmount() const = 0;
    virtual void SetInFileProgressAmount(int amt) = 0;
    virtual void SetInFileSizeAmount(int amt) = 0;

    virtual bool ShownToPrompt() const = 0;
    virtual bool ResultsPending() const = 0;
    virtual bool ResultsShown() const = 0;
    virtual bool GraphPlotShown() const = 0;
    virtual bool GraphOperFileSent() const = 0;
    virtual bool GraphOperFileResetDone(int FlagNum_=0, bool Unused_=false) const = 0;
    virtual bool GraphOperFileUpdateDone(int FlagNum_=0, bool Unused_=false) const = 0;
    virtual bool GraphProgFileSent() const = 0;
    virtual bool GraphProgFileResetDone() const = 0;
    virtual bool GraphProgFileResetPending() const = 0;
    virtual bool GraphProgFileUpdateDone() const = 0;
    virtual bool GraphProgFileUpdatePending() const = 0;
    virtual bool CalcProgFileSent() const = 0;
    virtual bool CalcProgFileResetDone() const = 0;
    virtual bool CalcProgFileResetPending() const = 0;
    virtual bool CalcProgFileUpdateDone() const = 0;
    virtual bool CalcProgFileUpdatePending() const = 0;
    virtual bool BatchFileEndedSignalSent() const = 0;
    virtual bool BatchFileEndedSignalAcked() const = 0;
    virtual bool BatchFileEndedSignalPending() const = 0;
    virtual bool ClientPingSignalSent() const = 0;
    virtual bool ClientPingSignalAcked() const = 0;
    virtual bool ClientIsDead() const = 0;
    virtual bool ProcessAckSignalSent() const = 0;
    virtual bool ProcessAckSignalDone() const = 0;
    virtual bool ProcessAckSignalPending() const = 0;
    virtual int ProcessAckForSignalReceived() const = 0;
    virtual bool ProcessAckTransitioned() const = 0;

    virtual void SetShownToPrompt(bool flag_) = 0;
    virtual void SetResultsPending(bool flag_) = 0;
    virtual void SetResultsShown(bool flag_) = 0;
    virtual void SetGraphPlotShown(bool flag_) = 0;
    virtual void SetGraphOperFileSent(bool flag_) = 0;
    virtual void SetGraphOperFileResetDone(int flag1_, int flag2_) = 0;
    virtual void SetGraphOperFileUpdateDone(int flag1_, int flag2_) = 0;
    virtual void SetGraphProgFileSent(bool flag_) = 0;
    virtual void SetGraphProgFileResetDone(bool flag_) = 0;
    virtual void SetGraphProgFileResetPending(bool flag_) = 0;
    virtual void SetGraphProgFileUpdateDone(bool flag_) = 0;
    virtual void SetGraphProgFileUpdatePending(bool flag_) = 0;
    virtual void SetCalcProgFileSent(bool flag_) = 0;
    virtual void SetCalcProgFileResetDone(bool flag_) = 0;
    virtual void SetCalcProgFileResetPending(bool flag_) = 0;
    virtual void SetCalcProgFileUpdateDone(bool flag_) = 0;
    virtual void SetCalcProgFileUpdatePending(bool flag_) = 0;
    virtual void SetBatchFileEndedSignalSent(bool flag_) = 0;
    virtual void SetBatchFileEndedSignalAcked(bool flag_) = 0;
    virtual void SetBatchFileEndedSignalPending(bool flag_) = 0;
    virtual void SetClientPingSignalSent(bool flag_) = 0;
    virtual void SetClientPingSignalAcked(bool flag_) = 0;
    virtual void SetClientIsDead(bool flag_) = 0;
    virtual void SetProcessAckSignalSent(bool flag_) = 0;
    virtual void SetProcessAckSignalDone(bool flag_) = 0;
    virtual void SetProcessAckSignalPending(bool flag_) = 0;
    virtual void SetProcessAckForSignalReceived(int Signal_) = 0;
    virtual void SetProcessAckTransition(int state_, bool reset_) = 0;

    // Quit/Continue graph plotting flags
    bool VerifyAllGraphCmds(const char* Fname_, int& GrFncFound_);

    #if CALCLIB_DEBUG11d
      void Exec_ShowQuitGraphFlags() const;
      void Exec_ResetQuitGraphFlags(bool Force_=false);
      bool Exec_QuitGraph() const;
      void Exec_SetQuitGraph(bool flag_);
      bool Exec_ResetGraphCond() const;
      void Exec_SetGraphCondReset(bool flag_);
      bool Exec_BatchFileDonePending() const;
      void Exec_SetBatchFileDonePending(bool flag_);
      bool Exec_ResetGraphIsDone() const;
      void Exec_ConfirmResetGraphDone();
    #else
      #define Exec_ShowQuitGraphFlags() \
                   ShowQuitGraphFlags()
      #define Exec_ResetQuitGraphFlags(f) \
                   ResetQuitGraphFlags(f)
      #define Exec_QuitGraph() \
                   QuitGraph()
      #define Exec_SetQuitGraph(f) \
                   SetQuitGraph(f)
      #define Exec_ResetGraphCond() \
                   ResetGraphCond()
      #define Exec_SetGraphCondReset(f) \
                   SetGraphCondReset(f)
      #define Exec_BatchFileDonePending() \
                   BatchFileDonePending()
      #define Exec_SetBatchFileDonePending(f) \
                   SetBatchFileDonePending(f)
      #define Exec_ResetGraphIsDone() \
                   ResetGraphIsDone()
      #define Exec_ConfirmResetGraphDone() \
                   ConfirmResetGraphDone()
    #endif

    virtual void ShowQuitGraphFlags() const = 0;
    virtual void ResetQuitGraphFlags(bool Force_=false) = 0;
    virtual bool QuitGraph() const = 0;
    virtual void SetQuitGraph(bool flag_) = 0;
    virtual bool ResetGraphCond() const = 0;
    virtual void SetGraphCondReset(bool flag_) = 0;
    virtual bool BatchFileDonePending() const = 0;
    virtual void SetBatchFileDonePending(bool flag_) = 0;
    virtual bool ResetGraphIsDone() const = 0;
    virtual void ConfirmResetGraphDone() = 0;

    inline Boolean Destroyed() const
        { return (_MemDel ? _MemDel->Destroyed():TRUE); }
    inline char* UseDefaultInputFnc(char* Buffer_, int Size_)
        { return (*_InFnc)(Buffer_, Size_); }
    inline int UseDefaultOutputFnc(const char* Buffer_)
        { return (*_OutFnc)(Buffer_); }
    inline void SetInputFnc(char*(*FuncPtr_)(char*, int))
        { _InFnc = FuncPtr_; }
    inline void ResetInputFnc()
        { _InFnc = Mcalc_DefaultInFnc; }
    inline void SetOutputFnc(int(*FuncPtr_)(const char*))
        { _OutFnc = FuncPtr_; }
    inline void ResetOutputFnc()
        { _OutFnc = Mcalc_DefaultOutFnc; }
    inline int StdInput() const
        { return _StdInput; }
    inline int StdOutput() const
        { return _StdOutput; }
    inline int StartAsStdInput() const
        { return _StartAsStdInput; }
    inline int StartAsStdOutput() const
        { return _StartAsStdOutput; }

    static int ExecInputFileDataCnt(int incr_=0)
        { return (!incr_ ? _ExecInputFileDataCnt:(_ExecInputFileDataCnt += incr_)); }

    // Calculator program termination
    inline void SetShouldQuit(int Flag_)
         { _ShouldQuit = Flag_; }
    inline int ShouldQuit() const
         { return _ShouldQuit; }

    virtual void SetDisplayOption(int Option_) = 0;
    virtual int GetDisplayOption() { return 0; }
    virtual int GiveRandom(int Num_) { return 0; }

    virtual void SetHasAnswer(Boolean Flag_) = 0;
    virtual void SetShowAnswer(Boolean Flag_) = 0;
    virtual void ResetAnswerMode() = 0;
    virtual void SetAnswerMode(int Mode_, int Final_=FALSE) = 0;
    virtual void SetSkipEval(int Flag_) = 0;
    virtual int ModeFinalized() const { return 0; }
    virtual int InitialMode() const { return 0; }
    virtual int AnswerMode() const { return 0; }
    virtual int SkipEval() const { return 0; }
    virtual int HasAnswer() const { return 0; }
    virtual int ShowAnswer() const { return 0; }

    virtual void SetStringAssignment(int Flag_, const char* Str_=NULL) = 0;
    virtual int StringAssignment() const { return 0; }
    virtual void SetStringComparison(int Flag_) = 0;
    virtual int StringComparison() const { return 0; }
    virtual void SetStringVar(int Index_, Boolean Flag_) = 0;
    virtual Boolean IsStringVar(int Index_) const { return 0; }

    virtual void SetSetAssignment(int Flag_, const char* Str_, int Null_) = 0;
    virtual int SetAssignment() const { return 0; }
    virtual void SetSetOperation(int Flag_) = 0;
    virtual int SetOperation() const { return 0; }
    virtual void SetSetVar(int Index_, int Flag_) = 0;
    virtual int IsSetVar(int Index_) const { return 0; }
    virtual int IsNullSet(int Index_) const { return 0; }

    virtual void SetEvalStrings(int Flag_) = 0;
    virtual void SetReEvalStrings(int Flag_) = 0;
    virtual int EvalStrings() const { return 0; }
    virtual int ReEvalStrings() const { return 0; }
    virtual void SetStrVariable(int x, const ChrString& Str_) = 0;
    virtual void SetSetVariable(int x, const ChrString& Str_, int Null_) = 0;
    virtual const ChrString& GetStrVariable(int Index_) const;
    virtual void SetStrResult(const char* Str_) = 0;
    virtual const ChrString& GetStrResult() const;
    virtual const ChrString& GetSetVariable(int Index_) const;
    virtual void SetSetResult(const char* Str_, int Null_) = 0;
    virtual const ChrString& GetSetResult() const;

    virtual size_t GetStrVarLen(int Index_) const { return 0; }
    virtual char* CopyStrVar(char* DestStr_, int Index_) { return NULL; };
    virtual ChrString& CopyStrVar(ChrString& DestStr_, int Index_) = 0;
    virtual Boolean IsHexVar(int Index_) const { return 0; }
    virtual Boolean IsOctVar(int Index_) const { return 0; }

    virtual void EraseAllAnswerStr() = 0;
    virtual void ClearAnswerStr(bool BlankAns_=false, int Mode_=0) = 0;
    virtual void ClearOriginalStr() = 0;
    virtual void ClearResultsShown() = 0;

    virtual const char* AnswerStr(ChrString* ret=NULL) { return NULL; }
    virtual void SetLiteralStr(const char* Literal_) = 0;
    virtual void AppendLiteralStr(const char* Literal_) = 0;
    virtual const char* LiteralStr(ChrString* ret=NULL) const  { return NULL; }
    virtual void SetFractionStr(const char* Frac_) = 0;
    virtual const char* FractionStr(ChrString* ret=NULL) const  { return NULL; }
    virtual void SetFloatStr(const char* TStr_) = 0;
    virtual const char* FloatStr(ChrString* ret=NULL) const  { return NULL; }
    virtual void SetOriginalStr(const char* TStr_) = 0;
    virtual const char* OriginalStr(ChrString* ret=NULL) const  { return NULL; }
    virtual void SetProgramStr(const char* TStr_) = 0;
    virtual const char* ProgramStr(ChrString* ret=NULL) const  { return NULL; }

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      virtual ChrString& AnswerChrStr() const = 0;
      virtual ChrString& LiteralChrStr() const = 0;
      virtual ChrString& FractionChrStr() const = 0;
      virtual ChrString& FloatChrStr() const = 0;
      virtual ChrString& OriginalChrStr() const = 0;
      virtual ChrString& ProgramChrStr() const = 0;
    #endif

    // statistics methods
    virtual Ldouble MinimumValue(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble MaximumValue(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble CumSum(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble CumProduct(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble AverageMean(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble AverageMedian(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble AverageMode(int NumParams_, FncParameter** ParamArray_);
    virtual Ldouble StandardDeviation(int NumParams_, FncParameter** ParamArray_);

    // input data file processing procedures
    virtual bool InRunningProgram(bool BatchFile_, bool InProgram_,
                                  bool PrevProgram_, bool AndOptions_=true) = 0;
    virtual int InBatchFile(bool GraphOnly_=false) const { return 0; }
    virtual int InPausedBatchFile(bool GraphOnly_=false) const { return 0; }
    virtual int InNonPausedBatchFile(bool GraphOnly_=false) const { return 0; }
    virtual int NoPauseFileInput() const { return 0; }
    virtual void SetNoPauseFileInput(int flag_) = 0;
    virtual int InputDataFilePauseOption() const { return 0; }
    virtual void SetInputDataFilePauseOption(int flag_) = 0;
    virtual int AckPostExecInputFileData() const { return 0; }
    virtual void SetAckPostExecInputFileData(int flag_) = 0;
    virtual void ResetAckPostExecInputFileData() = 0;
    virtual int PostExecResetProcessDone() const { return 0; }
    virtual void SetPostExecResetProcessDone(int flag_) = 0;
    virtual void ResetPostExecResetProcessDone() = 0;
    virtual int ExecInputFileData() const  { return 0; }
    virtual void SetExecInputFileData(int flag_) = 0;
    virtual void ResetExecInputFileData() = 0;
    virtual int InputDataFileExecLock() const { return 0; }
    virtual void SetInputDataFileExecLock(int val_) = 0;
    virtual bool IsUserPrompterProgram(const CalcProgram* ptr) const { return false; }
    virtual void SetUserPrompterProgram(CalcProgram* ptr) = 0;

    // method for handling previously saved FILE pointers
    virtual FILE* PrevInputFile() { return NULL; };
    virtual int PrevInputFileSet() { return 0; };
    virtual int SetPrevInputFile(FILE* ptr, int ConfirmSet_=TRUE) { return 0; };
    virtual FILE* PrevOutputFile() { return NULL; };
    virtual int PrevOutputFileSet() { return 0; };
    virtual int SetPrevOutputFile(FILE* ptr, int ConfirmSet_=TRUE) { return 0; };

    // user selected console IO/stanadard IO methods
    virtual char* GetFromSelectedInput(char* buffer_, int bufsz_) { return NULL; };
    virtual void SendToSelectedOutput(char* buffer_) = 0;

    // asynchronous IO user prompt method
    virtual void PromptAsyncUser(const char* TStr_, int PromptType_);

    // internal calculator data assignment method
    virtual ChrString* GiveIntExpression() { return NULL; }
    virtual int* GiveIntsFound() { return NULL; }
    virtual int* GiveExtremaEnd() { return NULL; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

// Implement storage of quoted literal strings into letter vars: $a - $z
//
struct StrVarData
{
  StrVarData();
  ~StrVarData();

  void SetSetElements(int Index_, const ChrString& Str_, int Null_);
  void SetString(int Index_, const ChrString& Str_);
  const ChrString& GetVariable(int Index_) const;
  const ChrString& GetResult() const;
  const ChrString& GetSetVariable(int Index_) const;
  const ChrString& GetSetResult() const;
  void SetResult(const char* Str_);
  void SetSetResult(const char* Str_, bool Null_);

  size_t GetVarLen(int Index_) const;
  char* CopyStrVar(char* DestStr_, int Index_);
  ChrString& CopyStrVar(ChrString& DestStr_, int Index_);

  void SetStringVar(int Index_, Boolean Flag_);
  Boolean IsStringVar(int Index_) const;
  void SetSetVar(int Index_, int Flag_);
  int IsSetVar(int Index_) const;
  int IsNullSet(int Index_) const;

  int _SetResult;
  int _IsSetVar[CalculatorBase::MAXVARS];
  Boolean _IsStringVar[CalculatorBase::MAXVARS];
  ChrString* _strvars[CalculatorBase::MAXVARS];  // for string literal assignments into variables
  ChrString _StrResult;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

typedef PointerStack<SubExpression> ExpressionStack;
typedef PointerStack<CalcProgram> ProgramStack;

template <class T>
struct IntCoords
{
  T X;
  T Y;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

template <class T>
class LineCalculator : public CalculatorBase
{
  private:
    int _CmdArgc;
    char** _CmdArgv;

  protected:
    StrVarData* _StrVarData;
    int _StringOperation;     // Indicates string literal assignments to variables
    int _SetOperation;        // Indicates set contents assignment to variables
    int _EvalStrings;         // Evaluate contents of string variables if set true
    int _ReEvalStrings;       // ReEvaluate contents of string variables if set true

    int _AngleUnit;
    char* _AssignmentOrder;
    int _StackSize;
    int _CalcIndex;
    int _PrevCalcIndex;
    CalculatorBase* _CalcPtrArray[MAXCALC];
    Randomizer<float> _Random;
    LongNumber _TransferValue1;
    LongNumber _TransferValue2;

    SubExpression** _SubExprStack;      // Pointer stack of SubExpression objects
    SubExpression* _Expression;         // Pointer into SubExpression object stack
    SubExpression* _ExecutingExpr;      // Currently active and executing SubExpression object
    ExpressionStack* _ActiveExpression; // Pointer to the top of ExpressionStack
    // long _ExprStackIndex;            // declared in root base class CalculatorBase
    // long _ExprStackLimit;            // declared in root base class CalculatorBase

    CalcProgram** _ProgramStack;        // Pointer stack of CalcProgram objects
    CalcProgram* _Program;              // Pointer into CalcProgram object stack
    CalcProgram* _NewProgram;           // newly created pointer to CalcProgram object
    ProgramStack* _ActiveProgram;       // Pointer to the top of ProgramStack
    // long _ProgramStackIndex;         // declared in root base class CalculatorBase
    // long _ProgramStackLimit;         // declared in root base class CalculatorBase
    // long _ProgramID;                 // declared in root base class CalculatorBase
    // long _NewProgramID;              // declared in root base calss CalculatorBase
    // long _PrevProgramID;             // declared in root base class CalculatorBase
    // long* _ExecProgramActive;        // declared in root base class CalculatorBase

    bool _ConsoleInput;
    bool _ConsoleOutput;
    bool _SkipPause;
    int _SavedConIO;

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      mutable ChrString _RetAnswerStr;
      mutable ChrString _RetLiteralStr;
      mutable ChrString _RetFractionStr;
      mutable ChrString _RetFloatStr;
      mutable ChrString _RetOriginalStr;
      mutable ChrString _RetProgramStr;
    #endif

    // WinlineLineBuffer and WindowLine objects are need only for text mode console I/O version
    #if (!(USE_STDIO_ONLY))
      WindowLineBuffer* _pbox;
      WindowLine* _pwin;
    #endif

    union
    {
      CalculatorBase* _ParentPtr;
      const CalculatorBase* _ConstParentPtr;
    };

    union
    {
      CalculatorBase* _ChildPtr;
      const CalculatorBase* _ConstChildPtr;
    };

    LineCalculator(int argc=0, char** argv=NULL);

    // math helper methods
    char* ConvertFloatToFraction(char* Float_);
    char* ConvertIntegerToFraction(char* Int_);

    // Set math methods
    ChrString CreateSet(int NumParams_, FncParameter** ParamArray_);
    ChrString FindSetUnion(int NumParams_, FncParameter** ParamArray_);
    ChrString FindSetIntersection(int NumParams_, FncParameter** ParamArray_);
    ChrString FindSetDifference(int NumParams_, FncParameter** ParamArray_);
    ChrString FindSetExclusion(int NumParams_, FncParameter** ParamArray_);

    // Discrete math methods
    ChrString FindPermutations(int NumParams_, FncParameter** ParamArray_);
    ChrString FindCombinations(int NumParams_, FncParameter** ParamArray_);
    ChrString FindPermutationsWithRep(int NumParams_, FncParameter** ParamArray_);
    ChrString FindCombinationsWithRep(int NumParams_, FncParameter** ParamArray_);
    ChrString FindFractionArithmetic(int NumParams_, FncParameter** ParamArray_);

    // Base conversion methods
    ChrString ConvertFromHex(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertFromOct(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertFromBin(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertFromCmp2Bin(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertToHex(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertToOct(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertToBin(int NumParams_, FncParameter** ParamArray_);
    ChrString ConvertToCmp2Bin(int NumParams_, FncParameter** ParamArray_);

    // Bitwise operations
    ChrString BitwiseOps(const LongNumber& value1, const LongNumber& value2, int optype);

  public:
    virtual ~LineCalculator();

    virtual ChrString ToString(int Index_) { return _DummyStr ? (*_DummyStr):ChrString(); }
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_) { return 0; }
    virtual const T& DirectProcess(Mcalc_Operand**, char**, int) = 0;
    virtual const T& GetResult() const = 0;

    virtual const T& GetVariable(int Index_) const = 0;
    virtual void SetVariable(int Index_, const T& Value_, int Transfer_=0) = 0;
    virtual const IntCoords<T>& GetIntCoord(int Index_, bool* ok=NULL) const = 0;
    virtual bool SetIntCoord(int Index_, const T& Valx_,
                                         const T& Valy_, int Transfer_=0) = 0;

    // methods for creating and transferring Data Stacks to child calc. objects: SubExprStack, ProgramStack
    virtual void CreateDataStacks();             // also creates Calc. program data stack
    virtual void TransferToAllChildCalcs();      // transfer shallow copies to all child calc. objects

    // Override for IoState operations while in SessionOption mode
    virtual CalculatorBase* SetIoStateForced(bool flag_);
    virtual bool IoStateForced() const;

    // output buffer transfer method
    virtual void DestroyOutputBuffer();
    virtual int TransferOutputBuffer(CalculatorBase* ptr);
    virtual void AssignToNullOutputBuffer();
    virtual int OutputBufferExists() const;
    virtual int ErrorArgStrExists() const;
    virtual int SendToOutputBuffer(const char* str, bool Reset_);
    virtual int SendToErrorArgStr(const char* str, bool Reset_);
    virtual int SendToOutputBuffer(const char* str);
    virtual int SendToErrorArgStr(const char* str);
    virtual int ResetOutputBuffer();
    virtual int ResetErrorArgStr();
    virtual int AppendToOutputBuffer(const char* str);
    virtual ChrString GiveOutputBuffer() const;
    virtual ChrString GiveErrorArgStr() const;
    virtual void SetUseErrorArgStr(bool DoUse_, const char* str=NULL);
    virtual bool UsingErrorArgStr() const;

    // Subexpression methods
    // -- SubExpression** matrix methods
    virtual void CreateNewSubExpr();
    virtual void CreateNewSubExpr(SubExpression* Parent_, int Level_, const char* Expr_);
    virtual void DestroySubExprStack(int PopAndDelete_=0);
    virtual int SubExprStackExists() const;
    virtual int FindInSubExprStack(SubExpression* ptr, long* index_=NULL);
    virtual int PopSubExprStack(int PopAndDelete_=0);
    virtual SubExpression* TopSubExprStack(bool GiveExecExpr_=false);
    virtual void ResizeExprStack();
    virtual long SubExprStackSize() const;
    virtual long SubExprStackIndex() const;
    virtual int AtLowestExprLevel(int Level_);
    virtual ChrString EvalFncWithValue(const ChrString& ExprStr_, const ChrString& VarName_,
                                       const ChrString& Value_, bool PlotOff_=false, bool* Error_=NULL);
    virtual ChrString ReEvaluate(const ChrString& ExprStr_, bool* Error_=NULL);
    virtual int TransferVarsForSubExpr(CalculatorBase* ptr);
    virtual void AssignToNullVarsForSubExpr();

    // -- PointerStack<SubExpression> methods
    virtual SubExpression* ActiveExpression(bool* HasData_=NULL);
    virtual const SubExpression* ActiveExpression(bool* HasData_=NULL) const;
    virtual const SubExpression* ActiveConstExpression(bool* HasData_=NULL) const;
    virtual int PushActiveExpression(SubExpression* Ptr_);
    virtual int PopActiveExpression(int PopAndDelete_=0);

    // Currently active and executing SubExpression object
    virtual SubExpression* ExecutingExpression();
    virtual void SetExecutingExpression(SubExpression* SubExpr_);

    // Calc. Program methods
    // -- CalcProgram** matrix methods
    virtual CalcProgram* CreateNewProgram(const char* PrgName_,
                                          bool SetExecLevel_=false);
    virtual CalcProgram* GiveNewProgramPtr();
    virtual int InsertProgramToStack(CalcProgram* Program_);
    virtual CalcProgram* FindProgramFromIndex(long Index_);
    virtual const CalcProgram* FindProgramFromIndex(long Index_) const;
    virtual void DestroyProgramStack(int PopAndDelete_=0);
    virtual int ProgramStackExists() const;
    virtual int FindInProgramStack(CalcProgram* ptr, long* index_=NULL);
    virtual int PopProgramStack(int PopAndDelete_=0, int DecrIndex_=0);
    virtual CalcProgram* TopProgramStack();
    virtual void ResizeProgramStack();
    virtual long ProgramStackSize() const;
    virtual long ProgramStackIndex() const;
    virtual int AtLowestProgramLevel(int Level_);
    virtual int TransferVarsForProgram(CalculatorBase* ptr);
    virtual void AssignToNullVarsForProgram();
    virtual bool ResetProgramID(bool ResetPrevID_);

    // -- PointerStack<CalcProgram> methods
    virtual CalcProgram* ActiveProgram(bool* HasData_=NULL, int seqno=0);
    virtual const CalcProgram* ActiveProgram(bool* HasData_=NULL, int seqno=0) const;
    virtual const CalcProgram* ActiveConstProgram(bool* HasData_=NULL, int seqno=0) const;

    virtual int PushActiveProgram(CalcProgram* Ptr_);
    virtual int PopActiveProgram(int PopAndDelete_=0,
                                 bool SetExecLevel_=false);

    // -- long* program ID and program active/inactive status methods
    virtual int ExecProgramPopped(long IdVal_=0) const;
    virtual int SetExecProgramPopped(long flag_, long IdVal_=0);
    virtual int ResetExecProgramPopped(long IdVal_=0);
    virtual CalcProgram* FindProgramFromID(long IdVal_, bool CheckActive_);
    virtual const CalcProgram* FindProgramFromID(long IdVal_, bool CheckActive_) const;
    virtual long GiveProgramID() const;
    virtual long GivePrevProgramID() const;

    virtual CalculatorBase* SetupCalculators(int CalcType_);
    virtual size_t LongestCmdEntry() const;
    virtual char* MakeCmdHistoryPrompt(size_t sz);
    virtual int ShowCmdHistoryEntry(Boolean RepeatEntry_=FALSE);
    virtual void ResetIndexes();
    virtual void SetIndex(int Pos_, int Val_);
    virtual void GetIndex(int& Pos_, int& Val_);
    virtual int HasIndex();
    virtual void PopIndex();
    virtual int StoreResults();
    virtual void SetAngleUnit(int Unit_);
    virtual int GetAngleUnit() const;

    virtual int ProcessCmdLine(int argc, char** argv);
    virtual void EvaluateLine(int argc, CalculatorBase* CalcPtr_, Mcalc_Operand** operands, char** arglist);
    virtual int FileInput(int argc, char** argv, CalculatorBase* CalcPtr_);
    virtual void ProgramProc(int argc, char** argv, CalculatorBase* CalcPtr_);
    virtual int TransferData(char* argstr, CalculatorBase* CalcPtr_);
    virtual int EvalExpression(char* argstr, CalculatorBase* CalcPtr_);
    virtual int EvalPrgExpression(char* argstr, CalculatorBase* CalcPtr_);
    virtual int ExecInputDataFile(const char* Fname_, int LinePause_, const char* OutFname_=NULL);
    virtual void SetHasCommandOutput(int Flag_, int TiedSignal_=0, SubExpression* SubExpr_=NULL);
    virtual Boolean HasCommandOutput(int TiedSignal_=0, bool* HasOut_=NULL) const;
    virtual void SetCalcIndexes(int Prev_, int New_);
    virtual int TransferVariable(int DestIndex_, int SrceIndex_);
    virtual void SwitchCalcType(int CalcType_);
    virtual void SetCalcType(int CalcType_);
    virtual void TransferCalcType(int CalcType_);
    virtual int TransferIntsAndExtrema(int CalcType_, int PrevCalc_);
    virtual int RestoreCalcType();
    virtual const char* GetPrecision();
    virtual void SetParentDestroyed(bool flag_);
    virtual bool ParentDestroyed() const;
    virtual void SetParent(CalculatorBase* Ptr_);
    virtual void SetChild(CalculatorBase* Ptr_);
    virtual const CalculatorBase* Parent() const;
    virtual CalculatorBase* Parent();
    virtual const CalculatorBase* Child() const;
    virtual CalculatorBase* Child();
    virtual CalculatorBase* GetCalcType();
    virtual CalculatorBase* GetPrevCalcType();
    virtual int GetCalcIndex() const;
    virtual int GetPrevCalcIndex() const;
    virtual void ProcessExpr(Mcalc_Operand**, char**, int, CalculatorBase*);
    virtual void SetProcessVariables(int Value_);
    virtual int ProcessVariables() const;
    virtual int InInputDataFileMode() const;
    virtual int InProgramMode(bool InclPrompter_,
                              bool InclInfile_=false) const;
    virtual void SetNumberBase(int Base_);
    virtual void RestoreNumberBase();
    virtual int NumberBase() const;
    virtual int RecursionLimit() const;
    virtual void SetRecursionLimit(int Limit_);
    virtual double GraphPrecision() const;
    virtual void SetGraphPrecision(double Prec_);
    virtual double DetermineGraphPrecision();

    virtual void SetSavedXpos(int xpos_);
    virtual int SavedXpos() const;
    virtual void DisplayCommandHistoryList();
    virtual void WriteCommandHistoryEntry(FILE* Fptr_, int index_);
    virtual void EndCommandHistoryList();
    virtual void SetHistoryListEnded(int flag_);
    virtual int CommandHistoryListEnded() const;
    virtual void SetHistoryListMode(int flag_);
    virtual int CommandHistoryMode() const;
    virtual void SetHistoryListIndex(int val_);
    virtual int IncHistoryListIndex(int val_=1, int IncOrder_=CalculatorBase::PREFIX);
    virtual int DecHistoryListIndex(int val_=1, int DecOrder_=CalculatorBase::PREFIX);
    virtual int CommandHistoryIndex() const;
    virtual void SetHistoryListLength(int val_);
    virtual int IncHistoryListLength(int val_=1, int IncOrder_=CalculatorBase::PREFIX);
    virtual int DecHistoryListLength(int val_=1, int DecOrder_=CalculatorBase::PREFIX);
    virtual int CommandHistoryLength() const;
    virtual char* AllocateHistoryListEntry(int size_);
    virtual char* DeallocateHistoryListEntry();
    virtual void SetHistoryListEntry(char* str, int strcopy_, const char* conststr_=NULL);
    virtual const char* CommandHistoryEntry() const;
    virtual char* CommandHistoryEntry();
    virtual char* AllocateHistoryListPrompt(int size_);
    virtual char* DeallocateHistoryListPrompt();
    virtual void SetHistoryListPrompt(char* str, int strcopy_, const char* conststr_=NULL);
    virtual const char* CommandHistoryPrompt() const;
    virtual char* CommandHistoryPrompt();
    virtual char** AllocateHistoryList(int size_);
    virtual char** GiveHistoryList();
    virtual char* AllocateHistoryListElement(int index, int size_);
    virtual char* AllocateHistoryListElement(int index, int size_) const;
    virtual void DeallocateHistoryListAll();
    virtual char** DeallocateHistoryList();
    virtual char* DeallocateHistoryListElement(int index);
    virtual void SetHistoryListElementStr(int index, const char* str);
    virtual void SetHistoryListElementValid(int index, int valid_);
    virtual void SetHistoryListElementSize(int index, Ushort size_);
    virtual char** HistoryListBase(int offset=0);
    virtual CalculatorBase::CONSTARRAY HistoryListBase(int offset=0) const;
    virtual char* HistoryListElementBase(int index, int offset=0);
    virtual const char* HistoryListElementBase(int index, int offset=0) const;
    virtual const char* HistoryListElementStr(int index) const;
    virtual int HistoryListElementValid(int index) const;
    virtual Ushort HistoryListElementSize(int index) const;

    // I/O function pointers
    virtual int UsesConsoleIO() const;
    virtual int UsesConsoleInput() const;
    virtual int UsesConsoleOutput() const;
    virtual char* UseConsoleInputFnc(char* Buffer_, int Size_);
    virtual int UseConsoleOutputFnc(const char* Buffer_);

    // Graph plotting operation flags
    virtual int GraphProgressAmount() const;
    virtual int GraphSizeAmount() const;
    virtual void SetGraphProgressAmount(int amt);
    virtual void SetGraphSizeAmount(int amt);
    virtual int InFileProgressAmount() const;
    virtual int InFileSizeAmount() const;
    virtual void SetInFileProgressAmount(int amt);
    virtual void SetInFileSizeAmount(int amt);

    virtual bool ShownToPrompt() const;
    virtual bool ResultsPending() const;
    virtual bool ResultsShown() const;
    virtual bool GraphPlotShown() const;
    virtual bool GraphOperFileSent() const;
    virtual bool GraphOperFileResetDone(int FlagNum_=0, bool Unused_=false) const;
    virtual bool GraphOperFileUpdateDone(int FlagNum_=0, bool Unused_=false) const;
    virtual bool GraphProgFileSent() const;
    virtual bool GraphProgFileResetDone() const;
    virtual bool GraphProgFileResetPending() const;
    virtual bool GraphProgFileUpdateDone() const;
    virtual bool GraphProgFileUpdatePending() const;
    virtual bool CalcProgFileSent() const;
    virtual bool CalcProgFileResetDone() const;
    virtual bool CalcProgFileResetPending() const;
    virtual bool CalcProgFileUpdateDone() const;
    virtual bool CalcProgFileUpdatePending() const;
    virtual bool BatchFileEndedSignalSent() const;
    virtual bool BatchFileEndedSignalAcked() const;
    virtual bool BatchFileEndedSignalPending() const;
    virtual bool ClientPingSignalSent() const;
    virtual bool ClientPingSignalAcked() const;
    virtual bool ClientIsDead() const;
    virtual bool ProcessAckSignalSent() const;
    virtual bool ProcessAckSignalDone() const;
    virtual bool ProcessAckSignalPending() const;
    virtual int ProcessAckForSignalReceived() const;
    virtual bool ProcessAckTransitioned() const;

    virtual void SetShownToPrompt(bool flag_);
    virtual void SetResultsPending(bool flag_);
    virtual void SetResultsShown(bool flag_);
    virtual void SetGraphPlotShown(bool flag_);
    virtual void SetGraphOperFileSent(bool flag_);
    virtual void SetGraphOperFileResetDone(int flag1_, int flag2_);
    virtual void SetGraphOperFileUpdateDone(int flag1_, int flag2_);
    virtual void SetGraphProgFileSent(bool flag_);
    virtual void SetGraphProgFileResetDone(bool flag_);
    virtual void SetGraphProgFileResetPending(bool flag_);
    virtual void SetGraphProgFileUpdateDone(bool flag_);
    virtual void SetGraphProgFileUpdatePending(bool flag_);
    virtual void SetCalcProgFileSent(bool flag_);
    virtual void SetCalcProgFileResetDone(bool flag_);
    virtual void SetCalcProgFileResetPending(bool flag_);
    virtual void SetCalcProgFileUpdateDone(bool flag_);
    virtual void SetCalcProgFileUpdatePending(bool flag_);
    virtual void SetBatchFileEndedSignalSent(bool flag_);
    virtual void SetBatchFileEndedSignalAcked(bool flag_);
    virtual void SetBatchFileEndedSignalPending(bool flag_);
    virtual void SetClientPingSignalSent(bool flag_);
    virtual void SetClientPingSignalAcked(bool flag_);
    virtual void SetClientIsDead(bool flag_);
    virtual void SetProcessAckSignalSent(bool flag_);
    virtual void SetProcessAckSignalDone(bool flag_);
    virtual void SetProcessAckSignalPending(bool flag_);
    virtual void SetProcessAckForSignalReceived(int Signal_);
    virtual void SetProcessAckTransition(int state_, bool reset_);

    // Quit/Continue graph plotting flags
    virtual void ShowQuitGraphFlags() const;
    virtual void ResetQuitGraphFlags(bool Force_=false);
    virtual bool QuitGraph() const;
    virtual void SetQuitGraph(bool flag_);
    virtual bool ResetGraphCond() const;
    virtual void SetGraphCondReset(bool flag_);
    virtual bool BatchFileDonePending() const;
    virtual void SetBatchFileDonePending(bool flag_);
    virtual bool ResetGraphIsDone() const;
    virtual void ConfirmResetGraphDone();

    virtual void SetDisplayOption(int Option_);
    virtual int GetDisplayOption();
    virtual int GiveRandom(int Num_);

    // Error reporting and handling
    virtual int GetErrorVal() const;
    virtual int HasErrors() const;
    virtual void ClearError();
    virtual void SetError(int ErrVal_, bool ClearErr_=false);
    virtual int HasMultiErrors() const;
    virtual int FindMultiErrors(int& ErrorCnt_, int& ErrorVal_);
    virtual void SetMultiErrorVector(int Vect_, int* MaxSel_, int* ErrVals_, int size_);
    virtual void SetSuppressOutput(int Flag_, int ShowSuppressedErrors_=TRUE);
    virtual int SuppressOutput() const;

    virtual void SetHasAnswer(Boolean Flag_);
    virtual void SetShowAnswer(Boolean Flag_);
    virtual void ResetAnswerMode();
    virtual void SetAnswerMode(int Mode_, int Final_=FALSE);
    virtual void SetSkipEval(int Flag_);
    virtual int InitialMode() const;
    virtual int ModeFinalized() const;
    virtual int AnswerMode() const;
    virtual int SkipEval() const;
    virtual int HasAnswer() const;
    virtual int ShowAnswer() const;

    virtual void SetStringAssignment(int Flag_, const char* Str_=NULL);
    virtual int StringAssignment() const;
    virtual void SetStringComparison(int Flag_);
    virtual int StringComparison() const;
    virtual void SetStringVar(int Index_, Boolean Flag_);
    virtual Boolean IsStringVar(int Index_) const;

    virtual void SetSetAssignment(int Flag_, const char* Str_, int Null_);
    virtual int SetAssignment() const;
    virtual void SetSetOperation(int Flag_);
    virtual int SetOperation() const;
    virtual void SetSetVar(int Index_, int Flag_);
    virtual int IsSetVar(int Index_) const;
    virtual int IsNullSet(int Index_) const;

    virtual void SetEvalStrings(int Flag_);
    virtual void SetReEvalStrings(int Flag_);
    virtual int EvalStrings() const;
    virtual int ReEvalStrings() const;
    virtual void SetStrVariable(int x, const ChrString& Str_);
    virtual void SetSetVariable(int x, const ChrString& Str_, int Null_);
    virtual const ChrString& GetStrVariable(int Index_) const;
    virtual void SetStrResult(const char* Str_);
    virtual const ChrString& GetStrResult() const;
    virtual const ChrString& GetSetVariable(int Index_) const;
    virtual void SetSetResult(const char* Str_, int Null_);
    virtual const ChrString& GetSetResult() const;

    virtual size_t GetStrVarLen(int Index_) const;
    virtual char* CopyStrVar(char* DestStr_, int Index_);
    virtual ChrString& CopyStrVar(ChrString& DestStr_, int Index_);
    virtual Boolean IsHexVar(int Index_) const;
    virtual Boolean IsOctVar(int Index_) const;

    virtual void EraseAllAnswerStr();
    virtual void ClearAnswerStr(bool BlankAns_=false, int Mode_=0);
    virtual void ClearOriginalStr();
    virtual void ClearResultsShown();

    virtual const char* AnswerStr(ChrString* ret=NULL);
    virtual void SetLiteralStr(const char* Literal_);
    virtual void AppendLiteralStr(const char* Literal_);
    virtual const char* LiteralStr(ChrString* ret=NULL) const;
    virtual void SetFractionStr(const char* Frac_);
    virtual const char* FractionStr(ChrString* ret=NULL) const;
    virtual void SetFloatStr(const char* TStr_);
    virtual const char* FloatStr(ChrString* ret=NULL) const;
    virtual void SetOriginalStr(const char* TStr_);
    virtual const char* OriginalStr(ChrString* ret=NULL) const;
    virtual void SetProgramStr(const char* TStr_);
    virtual const char* ProgramStr(ChrString* ret=NULL) const;

    #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
      virtual ChrString& AnswerChrStr() const;
      virtual ChrString& LiteralChrStr() const;
      virtual ChrString& FractionChrStr() const;
      virtual ChrString& FloatChrStr() const;
      virtual ChrString& OriginalChrStr() const;
      virtual ChrString& ProgramChrStr() const;
    #endif

    // input data file processing procedures
    virtual bool InRunningProgram(bool BatchFile_, bool InProgram_,
                                  bool PrevProgram_, bool AndOptions_=true);
    virtual int InBatchFile(bool GraphOnly_=false) const;
    virtual int InPausedBatchFile(bool GraphOnly_=false) const;
    virtual int InNonPausedBatchFile(bool GraphOnly_=false) const;
    virtual int NoPauseFileInput() const;
    virtual void SetNoPauseFileInput(int flag_);
    virtual int InputDataFilePauseOption() const;
    virtual void SetInputDataFilePauseOption(int flag_);
    virtual int AckPostExecInputFileData() const;
    virtual void SetAckPostExecInputFileData(int flag_);
    virtual void ResetAckPostExecInputFileData();
    virtual int PostExecResetProcessDone() const;
    virtual void SetPostExecResetProcessDone(int flag_);
    virtual void ResetPostExecResetProcessDone();
    virtual int ExecInputFileData() const;
    virtual void SetExecInputFileData(int flag_);
    virtual void ResetExecInputFileData();
    virtual int InputDataFileExecLock() const;
    virtual void SetInputDataFileExecLock(int val_);
    virtual bool IsUserPrompterProgram(const CalcProgram* ptr) const;
    virtual void SetUserPrompterProgram(CalcProgram* ptr);

    // method for handling previously saved FILE pointers
    virtual FILE* PrevInputFile();
    virtual int PrevInputFileSet();
    virtual int SetPrevInputFile(FILE* ptr, int ConfirmSet_=TRUE);
    virtual FILE* PrevOutputFile();
    virtual int PrevOutputFileSet();
    virtual int SetPrevOutputFile(FILE* ptr, int ConfirmSet_=TRUE);

    // user selected console IO/stanadard IO methods
    virtual char* GetFromSelectedInput(char* buffer_, int bufsz_);
    virtual void SendToSelectedOutput(char* buffer_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class FloatCalculator : public LineCalculator<float>
{
  protected:
    float resultvalue;
    float _vars[MAXVARS];
    float _Epsilon;

    ChrString _IntExpr;                    // Intersect expression for plot file.
    IntCoords<float>** _IntCoords;         // Intersection coordinates for graph intersection function
    int _IntsFound;                        // Number of points of intersection found, 0 to 3
    int _ExtremaEnd;                       // Indicate whether finding min. or max. extrema

    static bool FindCommonAngles(float value_, float shift_, float Tol_, float Eps_, float& mult_, double& intp_);
    static size_t FindPrecision(const float& Val_, size_t Prec_);
    static void PrintInfNanValues(FILE* Fout_, const Float& Answer_, float fval);
    virtual ChrString FindIntersections(int NumParams, FncParameter** ParamArray_);
    virtual ChrString FindApproxZero(int NumParams_, FncParameter** ParamArray_, Boolean& ZeroFound_);
    virtual ChrString EvaluateFunction(const char* FncName_, int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative2(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindNewtonsCriteria(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString NewtonsMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString FindRoot(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMinimum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMaximum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString RectToPolar(int NumParams_, FncParameter** ParamArray_, int Retarg_);
    virtual ChrString PolarToRect(int NumParams_, FncParameter** ParamArray_, int Retarg_);

    static float IntPow(float Value_, long Exp_);
    float RoundOffResult(float resval_);

  public:
    FloatCalculator(int argc=0, char** argv=NULL);
    virtual ~FloatCalculator();

    // virtual math methods implemented in derived classes
    virtual int ClassNumber() const;
    virtual bool PlotFunctionSub(char* PlotFileSuffix_,
                                 int NumParams_, FncParameter** ParamArray_,
                                 const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString PlotFunction(int NumParams_, FncParameter** ParamArray_,
                                   const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString FindIntegral(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString MullersMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString SolveMatrix(int NumParams_, FncParameter** ParamArray_);

    virtual ChrString ToString(int Index_);
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_);
    virtual const float& DirectProcess(Mcalc_Operand**, char**, int);
    virtual const float& GetResult() const;
    virtual size_t GetVariableLength(int Index_) const;
    virtual int GiveType() const;
    virtual void SubstToken(char* ArgStr_, int& StrIndex_, int VarIndex_);
    virtual void SetParent(CalculatorBase* Ptr_);
    virtual int AssignCalcData(CalculatorBase* CalcPtr_, int CalcType_);

    virtual const float& GetVariable(int Index_) const;
    virtual void SetVariable(int Index_, const float& Value1_, int Transfer_=0);
    virtual const IntCoords<float>& GetIntCoord(int Index_, bool* ok=NULL) const;
    virtual bool SetIntCoord(int Index_, const float& Valx_,
                                         const float& Valy_, int Transfer_=0);

    // internal calculator data assignment method
    virtual ChrString* GiveIntExpression();
    virtual int* GiveIntsFound();
    virtual int* GiveExtremaEnd();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class DoubleCalculator : public LineCalculator<double>
{
  protected:
    double resultvalue;
    double _vars[MAXVARS];
    double _Epsilon;

    ChrString _IntExpr;                    // Intersect expression for plot file.
    IntCoords<double>** _IntCoords;        // Intersection coordinates for graph intersection function
    int _IntsFound;                        // Number of points of intersection found, 0 to 3
    int _ExtremaEnd;                       // Indicate whether finding min. or max. extrema

    static bool FindCommonAngles(double value_, double shift_, double Tol_, double Eps_, double& mult_, double& intp_);
    static size_t FindPrecision(const double& Val_, size_t Prec_);
    static void PrintInfNanValues(FILE* Fout_, const Double& Answer_, double fval);
    virtual ChrString FindIntersections(int NumParams, FncParameter** ParamArray_);
    virtual ChrString FindApproxZero(int NumParams_, FncParameter** ParamArray_, Boolean& ZeroFound_);
    virtual ChrString EvaluateFunction(const char* FncName_, int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative2(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindNewtonsCriteria(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString NewtonsMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString FindRoot(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMinimum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMaximum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString RectToPolar(int NumParams_, FncParameter** ParamArray_, int Retarg_);
    virtual ChrString PolarToRect(int NumParams_, FncParameter** ParamArray_, int Retarg_);

    static double IntPow(double Value_, long Exp_);
    double RoundOffResult(double resval_);

  public:
    DoubleCalculator(int argc=0, char** argv=NULL);
    virtual ~DoubleCalculator();

    // virtual math methods implemented in derived classes
    virtual int ClassNumber() const;
    virtual bool PlotFunctionSub(char* PlotFileSuffix_,
                                 int NumParams_, FncParameter** ParamArray_,
                                 const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString PlotFunction(int NumParams_, FncParameter** ParamArray_,
                                   const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString FindIntegral(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString MullersMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString SolveMatrix(int NumParams_, FncParameter** ParamArray_);

    virtual ChrString ToString(int Index_);
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_);
    virtual const double& DirectProcess(Mcalc_Operand**, char**, int);
    virtual const double& GetResult() const;
    virtual size_t GetVariableLength(int Index_) const;
    virtual int GiveType() const;
    virtual void SubstToken(char* ArgStr_, int& StrIndex_, int VarIndex_);
    virtual void SetParent(CalculatorBase* Ptr_);
    virtual int AssignCalcData(CalculatorBase* CalcPtr_, int CalcType_);

    virtual const double& GetVariable(int Index_) const;
    virtual void SetVariable(int Index_, const double& Value1_, int Transfer_=0);
    virtual const IntCoords<double>& GetIntCoord(int Index_, bool* ok=NULL) const;
    virtual bool SetIntCoord(int Index_, const double& Valx_,
                                         const double& Valy_, int Transfer_=0);

    // internal calculator data assignment method
    virtual ChrString* GiveIntExpression();
    virtual int* GiveIntsFound();
    virtual int* GiveExtremaEnd();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class LongDoubleCalculator : public LineCalculator<Ldouble>
{
  friend class LongNumCalculator;

  protected:
    Ldouble resultvalue;
    Ldouble _vars[MAXVARS];
    Ldouble _Epsilon;

    ChrString _IntExpr;                    // Intersect expression for plot file.
    IntCoords<Ldouble>** _IntCoords;       // Intersection coordinates for graph intersection function
    int _IntsFound;                        // Number of points of intersection found, 0 to 3
    int _ExtremaEnd;                       // Indicate whether finding min. or max. extrema

    #if HAS_LONGDOUBLE_STDFNCS
      static bool FindCommonAngles(Ldouble value_, Ldouble shift_, Ldouble Tol_, Ldouble Eps_, Ldouble& mult_, Ldouble& intp_);
    #else
      static bool FindCommonAngles(Ldouble value_, Ldouble shift_, Ldouble Tol_, Ldouble Eps_, Ldouble& mult_, double& intp_);
    #endif
    static size_t FindPrecision(const Ldouble& Val_, size_t Prec_);
    static void PrintInfNanValues(FILE* Fout_, const LongDouble& Answer_, Ldouble fval);
    virtual ChrString FindIntersections(int NumParams, FncParameter** ParamArray_);
    virtual ChrString FindApproxZero(int NumParams_, FncParameter** ParamArray_, Boolean& ZeroFound_);
    virtual ChrString EvaluateFunction(const char* FncName_, int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative2(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindNewtonsCriteria(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString NewtonsMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString FindRoot(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMinimum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMaximum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString RectToPolar(int NumParams_, FncParameter** ParamArray_, int Retarg_);
    virtual ChrString PolarToRect(int NumParams_, FncParameter** ParamArray_, int Retarg_);

    static Ldouble IntPow(Ldouble Value_, long Exp_);
    Ldouble RoundOffResult(Ldouble resval_);

  public:
    LongDoubleCalculator(int argc=0, char** argv=NULL);
    virtual ~LongDoubleCalculator();

    // virtual math methods implemented in derived classes
    virtual int ClassNumber() const;
    virtual bool PlotFunctionSub(char* PlotFileSuffix_,
                                 int NumParams_, FncParameter** ParamArray_,
                                 const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString PlotFunction(int NumParams_, FncParameter** ParamArray_,
                                   const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString FindIntegral(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString MullersMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString SolveMatrix(int NumParams_, FncParameter** ParamArray_);

    virtual ChrString ToString(int Index_);
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_);
    virtual const Ldouble& DirectProcess(Mcalc_Operand**, char**, int);
    virtual const Ldouble& GetResult() const;
    virtual size_t GetVariableLength(int Index_) const;
    virtual int GiveType() const;
    virtual void SubstToken(char* ArgStr_, int& StrIndex_, int VarIndex_);
    virtual void SetParent(CalculatorBase* Ptr_);
    virtual int AssignCalcData(CalculatorBase* CalcPtr_, int CalcType_);

    virtual const Ldouble& GetVariable(int Index_) const;
    virtual void SetVariable(int Index_, const Ldouble& Value1_, int Transfer_=0);
    virtual const IntCoords<Ldouble>& GetIntCoord(int Index_, bool* ok=NULL) const;
    virtual bool SetIntCoord(int Index_, const Ldouble& Valx_,
                                         const Ldouble& Valy_, int Transfer_=0);

    // internal calculator data assignment method
    virtual ChrString* GiveIntExpression();
    virtual int* GiveIntsFound();
    virtual int* GiveExtremaEnd();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class LongNumCalculator : public LineCalculator<LongNumber>
{
  protected:
    LongNumber resultvalue;
    LongNumber* _vars[MAXVARS];
    LongNumber _Epsilon;
    int _SectionSwitch;                    // Section guard of calculator switching
    int _SubstCalc;                        // Substituted calculator index value

    ChrString _IntExpr;                    // Intersect expression for plot file.
    IntCoords<LongNumber>** _IntCoords;    // Intersection coordinates for graph intersection function
    int _IntsFound;                        // Number of points of intersection found, 0 to 3
    int _ExtremaEnd;                       // Indicate whether finding min. or max. extrema

    virtual ChrString FindIntersections(int NumParams, FncParameter** ParamArray_);
    virtual ChrString FindApproxZero(int NumParams_, FncParameter** ParamArray_, Boolean& ZeroFound_);
    virtual ChrString EvaluateFunction(const char* FncName_, int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindDerivative2(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindNewtonsCriteria(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString NewtonsMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString FindRoot(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMinimum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString FindMaximum(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString RectToPolar(int NumParams_, FncParameter** ParamArray_, int Retarg_);
    virtual ChrString PolarToRect(int NumParams_, FncParameter** ParamArray_, int Retarg_);

  public:
    LongNumCalculator(int argc=0, char** argv=NULL);
    virtual ~LongNumCalculator();

    // virtual math methods implemented in derived classes
    virtual int ClassNumber() const;
    virtual ChrString PlotFunction(int NumParams_, FncParameter** ParamArray_,
                                   const ChrString& MidPtStr_, ChrString Radius_="5", ChrString* Solution_=NULL);
    virtual ChrString FindIntegral(int NumParams_, FncParameter** ParamArray_);
    virtual ChrString MullersMethod(int NumParams_, FncParameter** ParamArray_, int& Converge_);
    virtual ChrString SolveMatrix(int NumParams_, FncParameter** ParamArray_);

    virtual ChrString ToString(int Index_);
    virtual bool IntCoordToString(int Index_, ChrString& Strx_, ChrString& Stry_);
    virtual const LongNumber& DirectProcess(Mcalc_Operand**, char**, int);
    virtual const LongNumber& GetResult() const;
    virtual size_t GetVariableLength(int Index_) const;
    virtual int GiveType() const;
    virtual void SubstToken(char* ArgStr_, int& StrIndex_, int VarIndex_);
    virtual void SetParent(CalculatorBase* Ptr_);
    virtual int AssignCalcData(CalculatorBase* CalcPtr_, int CalcType_);

    virtual const LongNumber& GetVariable(int Index_) const;
    virtual void SetVariable(int Index_, const LongNumber& Value1_, int Transfer_=0);
    virtual const IntCoords<LongNumber>& GetIntCoord(int Index_, bool* ok=NULL) const;
    virtual bool SetIntCoord(int Index_, const LongNumber& Valx_,
                                         const LongNumber& Valy_, int Transfer_=0);

    // internal calculator data assignment method
    virtual ChrString* GiveIntExpression();
    virtual int* GiveIntsFound();
    virtual int* GiveExtremaEnd();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

MEMORYOPS_TEMPLATE_DEFN(IntCoords)
MEMORYOPS_TEMPLATE_DEFN(LineCalculator)

/****************************************************************************/
// Graph Points Done Array class definitions
/****************************************************************************/
template <class PRIM>
GraphPointsDoneArray<PRIM>::GraphPointsDoneArray(int Max_):
_ProcessedPts(new PRIM[Max_]),
_MaxSize(Max_),
_Limit(0),
_HasOverFlow(false),
_PointsBufferFlushed(false),
_OverFlowedPoints(0)
{
  ::memset(_ProcessedPts, 0, sizeof(PRIM)*Max_);
}

/****************************************************************************/
template <class PRIM>
GraphPointsDoneArray<PRIM>::~GraphPointsDoneArray()
{
  delete[] _ProcessedPts;
  _ProcessedPts = NULL;
}

/****************************************************************************/
template <class PRIM>
PRIM GraphPointsDoneArray<PRIM>::operator [] (size_t x) const
{
  if (!_ProcessedPts || x >= _Limit)
    return 0;

  return _ProcessedPts[x];
}

/****************************************************************************/
template <class PRIM>
bool GraphPointsDoneArray<PRIM>::IsNonOverflowedPt(size_t x) const
{
  int valptsmax_ = _Limit - _OverFlowedPoints;
  return (_ProcessedPts &&
          (0 <= x && x < valptsmax_));
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::SetPtsNotified(bool Flag_)
{
  _PtsNotified = Flag_;
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::ClearPtsNotified()
{
  _PtsNotified = false;
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::SetParameters(bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_)
{
  _HasOverFlow = HasOverFlow_;
  _PointsBufferFlushed = PointsBufferFlushed_;
  _OverFlowedPoints = OverFlowPts_;
}

/****************************************************************************/
template <class PRIM>
bool GraphPointsDoneArray<PRIM>::CopyFromThisArray(PRIM* source_, int Limit_)
{
  if (Limit_ > _MaxSize || !_ProcessedPts)
    return false;

  int x;
  for (x = 0; x < Limit_; x++)
    _ProcessedPts[x] = source_[x];

  for (;x < _MaxSize; x++)
    _ProcessedPts[x] = 0;

  _Limit = Limit_;
  return true;
}

/****************************************************************************/
template <class PRIM>
bool GraphPointsDoneArray<PRIM>::AppendFromThisArray(PRIM* source_, int Limit_)
{
  if (_Limit + Limit_ > _MaxSize || !_ProcessedPts)
    return false;

  int x;
  int si = 0;

  for (x = _Limit; x < _MaxSize && si < Limit_; x++)
    _ProcessedPts[x] = source_[si++];

  _Limit = x;
  return true;
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::ShowPoints(const char* DelimStr_)
{
  int x;
  int max = _Limit-1;
  int valptsmax_ = _Limit - _OverFlowedPoints;
  int loopmax_ = (valptsmax_ > max) ? max:valptsmax_;

  if (_ProcessedPts && _Limit)
  {
    for (x = 0; x < loopmax_; x++)
      cout <<_ProcessedPts[x] <<DelimStr_;

    while (x < max)
      cout <<_ProcessedPts[x++] <<"*" <<DelimStr_;

    cout <<_ProcessedPts[x];
    if (valptsmax_ <= max)
      cout <<"*";
  }
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::ShowPoints(ofstream* Fout_)
{
  int x;
  int max = _Limit-1;
  int valptsmax_ = _Limit - _OverFlowedPoints;
  int loopmax_ = (valptsmax_ > max) ? max:valptsmax_;

  if (Fout_ && _ProcessedPts && _Limit)
  {
    for (x = 0; x < loopmax_; x++)
      *Fout_ <<_ProcessedPts[x] <<endl;

    while (x < max)
      x++;

    if (valptsmax_ > max)
      *Fout_ <<_ProcessedPts[x] <<endl;
  }
}

/****************************************************************************/
template <class PRIM>
bool GraphPointsDoneArray<PRIM>::SetLimit(int Limit_)
{
  if (Limit_ > _MaxSize || !_ProcessedPts)
    return false;

  _Limit = Limit_;
  return true;
}

/****************************************************************************/
template <class PRIM>
void GraphPointsDoneArray<PRIM>::Clear()
{
  _Limit = 0;
  ::memset(_ProcessedPts, 0, sizeof(PRIM)*_MaxSize);
}

/****************************************************************************/
// ArrayResetNotifier class definitions
/****************************************************************************/
template <class PRIM>
ArrayResetNotifier<PRIM>::ArrayResetNotifier():
_ExtArray(NULL),
_Rdarr(NULL),
_Endp(NULL),
_RunTotal(0),
_PtsArrMax(0),
_PtsAvailable(0),
_ExtIndex(0),
_PtsArrInit(false),
_RefillAvailable(false)
{}

/****************************************************************************/
template <class PRIM>
ArrayResetNotifier<PRIM>::~ArrayResetNotifier()
{
  _ExtArray = NULL;
  _Rdarr = NULL;
  _Endp = NULL;
  _RunTotal = 0;
  _PtsArrMax = 0;
  _PtsAvailable = 0;
  _ExtIndex = 0;
  _PtsArrInit = false;
  _RefillAvailable = false;
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::TransferFromExtArray()
{
  int Remaining_ = (_Endp && _Rdarr) ? (_Endp - (_Rdarr + _RunTotal)):0;
  int RunVal_ = _RunTotal;

  #if DISCONTDETECT_SHOWDEBUGINFO2
    GraphPointsDoneArray<PRIM>* RfpValArr_ = NULL;
    GraphPointsDoneArray<PRIM>* RemValArr_ = NULL;

    int RemVal_ = Remaining_;
    int Transferred_ = 0;
    bool TransferDone_ = false;

    if (_ExtIndex < _PtsAvailable && _PtsAvailable && _RunTotal)
    {
      RfpValArr_ = new GraphPointsDoneArray<PRIM>(_PtsArrMax);
      RfpValArr_->CopyFromThisArray(_ExtArray, _RunTotal);
      cout <<"Run Total (copied): " <<_RunTotal <<endl;
    }
    else
      cout <<"Run Total: " <<_RunTotal <<endl;

    if (_ExtIndex < _PtsAvailable && _PtsAvailable && Remaining_)
    {
      RemValArr_ = new GraphPointsDoneArray<PRIM>(_PtsArrMax);
      RemValArr_->CopyFromThisArray(_Rdarr, Remaining_);
      cout <<"Remaining (copied): " <<Remaining_ <<endl;
      cout <<"ExtIndex/PtsAvailable: " <<_ExtIndex <<"/" <<_PtsAvailable <<endl;
    }
    else
      cout <<"Remaining: " <<Remaining_ <<endl;
  #endif // DISCONTDETECT_SHOWDEBUGINFO2

  if (_RunTotal > 0)
  {
    _RunTotal = Remaining_;
    Remaining_ = RunVal_;

    if (Remaining_ && _ExtIndex < _PtsAvailable && _PtsAvailable)
    {
      _PtsArrInit = false;
      #if DISCONTDETECT_SHOWDEBUGINFO2
        TransferDone_ = true;
      #endif // DISCONTDETECT_SHOWDEBUGINFO2

      while (Remaining_ && _ExtIndex < _PtsAvailable)
      {
        _Rdarr[_RunTotal++] = _ExtArray[_ExtIndex++];
        --Remaining_;

        #if DISCONTDETECT_SHOWDEBUGINFO2
          ++Transferred_;
        #endif // DISCONTDETECT_SHOWDEBUGINFO2
      }
    }
  }

  #if DISCONTDETECT_SHOWDEBUGINFO2
    if ((RemVal_ && TransferDone_) &&
        (RemValArr_ && RemValArr_->HasPoints()))
    {
      cout <<"Remaining Array Points: { ";
      RemValArr_->ShowPoints(",");
      cout <<" }" <<endl;
    }

    if ((RunVal_ && TransferDone_) &&
        (RfpValArr_ && RfpValArr_->HasPoints()))
    {
      cout <<"Refilled Array Points: { ";
      RfpValArr_->SetLimit(Transferred_);
      RfpValArr_->ShowPoints(",");
      cout <<" }" <<endl;
    }

    delete RemValArr_;
    delete RfpValArr_;
  #endif // DISCONTDETECT_SHOWDEBUGINFO2
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::Reset()
{
  _ExtArray = NULL;
  _Rdarr = NULL;
  _Endp = NULL;
  _RunTotal = 0;
  _PtsArrMax = 0;
  _PtsAvailable = 0;
  _ExtIndex = 0;
  _PtsArrInit = false;
  _RefillAvailable = false;
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::Initialize(PRIM* ExtArray_, PRIM* RdArray_, PRIM* Endp_, int PtsArrMax_)
{
  bool Same_ = _ExtArray == ExtArray_;

  _ExtArray = ExtArray_;
  _Rdarr = RdArray_;
  _Endp = Endp_;
  _PtsArrMax = PtsArrMax_;

  if (ExtArray_)
  {
    if (!Same_ || (_PtsArrInit && _PtsAvailable == 0))
    {
      _PtsAvailable = _PtsArrMax;
      _PtsArrInit = true;
    }
  }
  else
    _PtsAvailable = _ExtIndex = 0;
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::Notify(PRIM* ExtArray_, PRIM* RdArray_, PRIM* Endp_, int PtsArrMax_, int RunTotal_)
{
  bool Same_ = _ExtArray == ExtArray_;

  _ExtArray = ExtArray_;
  _Rdarr = RdArray_;
  _Endp = Endp_;

  _PtsArrMax = PtsArrMax_;
  _RunTotal = RunTotal_;

  if (ExtArray_)
  {
    if (!Same_ || (_PtsArrInit && _PtsAvailable == 0))
    {
      _PtsAvailable = _PtsArrMax;
      _PtsArrInit = true;
    }
  }
  else
    _PtsAvailable = _ExtIndex = 0;

  if (_PtsArrMax)
  {
    TransferFromExtArray();

    if (_ExtIndex)
      ResetExtArray();
  }

  // _BasePtr->Notify();  // in derived class
  // SetRefillAvailable(true/false);
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::ResetExtArray()
{
  // reset contents of the external array back to zero array index position
  PRIM* ExtEnd_ = &_ExtArray[_PtsArrMax];
  int blksz = ExtEnd_ - (_ExtArray + _ExtIndex);
  int rdincr = blksz;

  ::memmove(_ExtArray, &_ExtArray[_ExtIndex], blksz*sizeof(PRIM));
  blksz = ExtEnd_ - (_ExtArray + rdincr);

  if (blksz > 0 && rdincr > 0)
    ::memset(_ExtArray+rdincr, 0, sizeof(PRIM)*blksz);

  if (_ExtIndex > 0)
  {
    if (_RefillAvailable)
      _PtsArrInit = true;

    if (_ExtIndex <= _PtsAvailable)
      _PtsAvailable -= _ExtIndex;
    else
      _PtsAvailable = 0;
  }

  _ExtIndex = 0;
  _RunTotal = 0;
}

/****************************************************************************/
template <class PRIM>
int ArrayResetNotifier<PRIM>::RefillExtArray(int BufSz_, PRIM* Buffer_, bool FillToBufSz_)
{
  int x = 0;
  int Remaining_ = _PtsArrMax - _PtsAvailable;

  _RefillAvailable = true;

  if (Remaining_ > 0 && (BufSz_ <= Remaining_ || !FillToBufSz_))
  {
    while (Remaining_ && x < BufSz_)
    {
      _ExtArray[_PtsAvailable++] = Buffer_[x++];
      --Remaining_;
    }

    if (_PtsAvailable && _ExtArray)
      _PtsArrInit = true;

    if (x == BufSz_ || !FillToBufSz_)
      return x;
    else
      return ((FillToBufSz_ && x == BufSz_) ? x:0);
  }

  if (_PtsAvailable && _ExtArray)
    _PtsArrInit = true;

  return 0;
}

/****************************************************************************/
template <class PRIM>
int ArrayResetNotifier<PRIM>::RefillExtArray(PRIM Val_)
{
  int Remaining_ = _PtsArrMax - _PtsAvailable;

  _RefillAvailable = true;

  if (Remaining_ > 0)
  {
    _ExtArray[_PtsAvailable++] = Val_;

    if (_PtsAvailable && _ExtArray)
      _PtsArrInit = true;

    return 1;
  }

  if (_PtsAvailable && _ExtArray)
    _PtsArrInit = true;

  return 0;
}

/****************************************************************************/
template <class PRIM>
void ArrayResetNotifier<PRIM>::SetRefillAvailable(bool Refill_)
{
  _RefillAvailable = Refill_;

  if (!_RefillAvailable)
    _PtsArrInit = false;
  else if (_PtsAvailable && _ExtArray)
    _PtsArrInit = true;
}

/****************************************************************************/
template <class PRIM>
int ArrayResetNotifier<PRIM>::UnfilledExtArrayPts() const
{
  return (_ExtArray ? (_PtsArrMax - _PtsAvailable):0);
}

/****************************************************************************/
template <class PRIM>
bool ArrayResetNotifier<PRIM>::ExtArrayFilled() const
{
  return (_ExtArray && _PtsArrMax == _PtsAvailable);
}

/****************************************************************************/
// PointsDoneNotifier class definitions
/****************************************************************************/
template <class PRIM>
PointsDoneNotifier<PRIM>::PointsDoneNotifier():
_HasOverFlow(false),
_PointsBufferFlushed(false),
_OverFlowedPoints(0),
_PointsDone(NULL),
_Detector(NULL)
{}

/****************************************************************************/
template <class PRIM>
PointsDoneNotifier<PRIM>::~PointsDoneNotifier()
{
  _HasOverFlow = false;
  _PointsBufferFlushed = false;
  _OverFlowedPoints = 0;
  _PointsDone = NULL;
  _Detector = NULL;
}

/****************************************************************************/
template <class PRIM>
void PointsDoneNotifier<PRIM>::SetParameters()
{
  if (_PointsDone)
    _PointsDone->SetParameters(_HasOverFlow, _OverFlowedPoints, _PointsBufferFlushed);
}

/****************************************************************************/
template <class PRIM>
void PointsDoneNotifier<PRIM>::Notify(GraphPointsDoneArray<PRIM>* DataPts_,
                                      bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_)
{
  _HasOverFlow = HasOverFlow_;
  _OverFlowedPoints = OverFlowPts_;
  _PointsBufferFlushed = PointsBufferFlushed_;

  _PointsDone = DataPts_;
  SetParameters();
    // _BasePtr->ProcessedPtsNotify(_PointsDone); // in derived class
}

/****************************************************************************/
template <class PRIM>
void PointsDoneNotifier<PRIM>::Notify_ShowPoints(GraphPointsDoneArray<PRIM>* DataPts_,
                                                 bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_)
{
  _HasOverFlow = HasOverFlow_;
  _OverFlowedPoints = OverFlowPts_;
  _PointsBufferFlushed = PointsBufferFlushed_;

  _PointsDone = DataPts_;
  SetParameters();
}

/****************************************************************************/
template <class PRIM>
const char* PointsDoneNotifier<PRIM>::ClassName() const
{
  return "PointsDoneNotifier";
}

/****************************************************************************/
template <class PRIM>
void PointsDoneNotifier<PRIM>::SetBasePointer(void* Base_)
{
  // _BasePtr = Base_;  // in derived class
}

/****************************************************************************/
template <class PRIM>
void PointsDoneNotifier<PRIM>::SetDetectorPointer(DiscontinuityDetectorBase* Detect_)
{
  _Detector = Detect_;
}

#if DISCONTDETECT_TESTNOTIFIERS
/****************************************************************************/
// PointsDoneNotifier class definitions
/****************************************************************************/
template <class PRIM>
CalcPointsDoneNotifier<PRIM>::CalcPointsDoneNotifier():
_BasePtr(NULL)
{}

/****************************************************************************/
template <class PRIM>
CalcPointsDoneNotifier<PRIM>::~CalcPointsDoneNotifier()
{
  _BasePtr = NULL;
}

/****************************************************************************/
template <class PRIM>
void CalcPointsDoneNotifier<PRIM>::Notify(GraphPointsDoneArray<PRIM>* DataPts_,
                                          bool HasOverFlow_, int OverFlowPts_, bool PointsBufferFlushed_)
{
  PointsDoneNotifier<PRIM>::Notify(DataPts_, HasOverFlow_, OverFlowPts_, PointsBufferFlushed_);
  PointsDoneNotifier<PRIM>::SetPtsNotified();

  #if DISCONTDETECT_USE_CALCBASE_CLASS
    _BasePtr->ProcessedPtsNotify(PointsDoneNotifier<PRIM>::PointsDone());
  #else
    ProcessedPtsNotify();
  #endif // DISCONTDETECT_USE_CALCBASE_CLASS

  PointsDoneNotifier<PRIM>::ClearPtsNotified();
}

/****************************************************************************/
template <class PRIM>
void CalcPointsDoneNotifier<PRIM>::ProcessedPtsNotify()
{
  // Source Code for: class CalculatorBase::ProcessedPtsNotify(GraphPointsDoneArray<PRIM>*)
  //
  // if (HasErrors() || Error_)
  // {
  //   if (GetErrorVal() == Mcalc_Error::ERRVAL_DIVISION_BY_ZERO)
  //   {
  //     if (Answer_.IsInfinite() || Answer_.IsNan())
  //       DoubleCalculator::PrintInfNanValues(Fout_, Answer_, fval);     // new
  //
  //     DivByZero_ = true;
  //     ClearError();
  //   }
  //   else
  //     DivByZero_ = false;
  // }
  // else
  // {
  //   DoubleCalculator::PrintInfNanValues(Fout_, Answer_, fval);
  //   NoErr_ = true;
  // }

  if (!PointsDoneNotifier<PRIM>::PointsDone() ||
      !PointsDoneNotifier<PRIM>::PointsDone()->PtsNotified())
    return;

  int x;
  int Limit_ = PointsDoneNotifier<PRIM>::PointsDone()->Limit();
  int max = Limit_ - 1;
  int valptsmax_ = PointsDoneNotifier<PRIM>::PointsDone()->NonOverflowedLimit();
  int loopmax_ = (valptsmax_ > max) ? max:valptsmax_;

  const char* DelimStr_ = ",";
  bool HasFout_;
  ofstream* Fout_ = PointsDoneNotifier<PRIM>::_Detector->GiveOutputFile(&HasFout_);

  if (Limit_)
  {
	if (!HasFout_)
	{
      cout <<"ProcessedPtsNotify(): { ";

      for (x = 0; x < loopmax_; x++)
        cout <<PointsDoneNotifier<PRIM>::PointsDone(x) <<DelimStr_;

      while (x < max)
        cout <<PointsDoneNotifier<PRIM>::PointsDone(x++) <<"*" <<DelimStr_;

      cout <<PointsDoneNotifier<PRIM>::PointsDone(x);
      if (valptsmax_ <= max)
        cout <<"*";

      cout <<" }" <<endl;
	}
	else if (Fout_)
	{
      for (x = 0; x < loopmax_; x++)
        *Fout_ <<PointsDoneNotifier<PRIM>::PointsDone(x) <<endl;

	  while (x < max)
		x++;
	  
	  if (valptsmax_ > max)
		*Fout_ <<PointsDoneNotifier<PRIM>::PointsDone(x) <<endl;
	}

    if (!HasFout_ && PointsDoneNotifier<PRIM>::PointsBufferFlushed())
    {
      if (PointsDoneNotifier<PRIM>::OverFlowedPoints())
        cout <<"Overflowed Points: " <<PointsDoneNotifier<PRIM>::OverFlowedPoints() <<endl;
      else
        cout <<"No Overflowed Points" <<endl;
    }
  }
}

/****************************************************************************/
template <class PRIM>
const char* CalcPointsDoneNotifier<PRIM>::ClassName() const
{
  return "CalcPointsDoneNotifier";
}

/****************************************************************************/
template <class PRIM>
void CalcPointsDoneNotifier<PRIM>::SetBasePointer(void* Base_)
{
  #if DISCONTDETECT_USE_CALCBASE_CLASS
    _BasePtr = (CalculatorBase*)Base_;
  #else
    _BasePtr = (const char*)Base_;
  #endif // DISCONTDETECT_USE_CALCBASE_CLASS
}

/****************************************************************************/
#if DISCONTDETECT_USE_CALCBASE_CLASS
template <class PRIM>
void CalcPointsDoneNotifier<PRIM>::SetCalcBasePointer(CalculatorBase* Base_)
{
  _BasePtr = Base_;
}
#endif // DISCONTDETECT_USE_CALCBASE_CLASS
#endif // DISCONTDETECT_TESTNOTIFIERS

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(GraphPointsDoneArray)
MEMORYOPS_TEMPLATE_DEFN(PointsDoneNotifier)
MEMORYOPS_TEMPLATE_DEFN(ArrayResetNotifier)
#if DISCONTDETECT_TESTNOTIFIERS
  MEMORYOPS_TEMPLATE_DEFN(CalcPointsDoneNotifier)
#endif // DISCONTDETECT_TESTNOTIFIERS

/****************************************************************************/
// Data Array class definitions
/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::DataArrayStruct(GraphDiscontinuityDetector<WRAP, PRIM>* Gdiscp_, PRIM* Extarr_, PRIM* Rdarr_,
                                                                         int PtsInDataFile_, int PtsArrMax_, bool IncrRdarr_, int _gamax_, int _rdmax_):
_Gdiscp(Gdiscp_),
_ResetNotifier(Gdiscp_ ? Gdiscp_->GiveArrayResetNotifier():NULL),
_ExtArrayCreated(Extarr_ ? false:PtsArrMax_),
_ExtArrayAvailable(Extarr_!=NULL),
_ExtArray(Extarr_ ? Extarr_:(PtsArrMax_ ? (new PRIM[PtsArrMax_]):NULL)),
_ArrStart(Rdarr_),
_Rdarr(Rdarr_),
_Endp(Rdarr_),
_PtsInDataFile(PtsInDataFile_),
_PtsArrMax(PtsArrMax_),
_PtsConsumed(0),
_TotalPtsConsumed(0),
_RemainingPts(0),
_AutoReset(true),
_HalfBufferRead(false),
_IncrRdarrPtr(IncrRdarr_),
_InitReadDone(false),
_NeedTerm(false),
_NeedReset(false),
_Terminated(false),
_TermAck(false),
_ResetDone(false),
_ResetAck(false),
_Suspended(!Extarr_ && PtsArrMax_),
_rdcnt(0),
_nextrd(0),
_totalrd(0),
_runtotal(0),
_gamax(_gamax_),
_rdmax(_rdmax_)
{
  if (!Extarr_ && PtsArrMax_)
    ::memset(_ExtArray, 0, sizeof(PRIM)*_PtsArrMax);
}

/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::~DataArrayStruct()
{
  delete _Gdiscp;
  _Gdiscp = NULL;

  if (_ExtArrayCreated)
  {
    delete[] _ExtArray;
    _ExtArray = NULL;
  }
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::SetExtArray(PRIM* Extarr_,
                                                                          bool RefillAvail_, int* Index_)
{
  PRIM* PrevArray_ = _ExtArray;

  if (_ExtArray && Extarr_ && _ExtArrayCreated)
  {
    ::memmove(_ExtArray, Extarr_, _PtsArrMax*sizeof(PRIM));
    _ExtArrayAvailable = true;
  }
  else if (Extarr_ && !_ExtArrayCreated)
  {
    _ExtArray = Extarr_;
    _ExtArrayAvailable = true;
  }
  else if (!Extarr_)
  {
    _ExtArray = Extarr_;
    _ExtArrayAvailable = false;

    if (_ExtArrayCreated && PrevArray_ && PrevArray_ != _ExtArray)
    {
      delete[] PrevArray_;
      PrevArray_ = NULL;
      _ExtArrayCreated = false;
    }
  }

  if (Index_)
    *Index_ += _PtsArrMax;

  SuspendForPtsRefill(false);
  _ResetNotifier->SetRefillAvailable(Extarr_ && RefillAvail_);

  if (InitialReadDone() && !_ResetNotifier->Initialized() && _ExtArray && _ExtArrayAvailable)
    _ResetNotifier->Initialize(_ExtArray, _Rdarr, _Endp, _PtsArrMax);
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetData(bool HasExtarr_, PRIM* Rdarr_, bool IncrRdarr_, int PtsInDataFile_, int PtsArrMax_)
{
  _Gdiscp->SetDataRetrieved(true);
  _Gdiscp->ResetScan(true);
  _ResetNotifier->Reset();
  SuspendForPtsRefill(false);

  PRIM* PrevArray_ = _ExtArray;
  _ExtArray = (HasExtarr_ && PtsArrMax_) ? (new PRIM[PtsArrMax_]):NULL;

  _ArrStart = Rdarr_;
  _Rdarr = Rdarr_;
  _Endp = Rdarr_;
  _PtsInDataFile = PtsInDataFile_;
  _PtsArrMax = PtsArrMax_;

  _InitReadDone = false;
  _PtsConsumed = 0;
  _TotalPtsConsumed = 0;
  _RemainingPts = 0;

  _HalfBufferRead = false;
  _IncrRdarrPtr = IncrRdarr_;
  _NeedTerm = false;
  _NeedReset = false;
  _Terminated = false;
  _TermAck = false;
  _ResetDone = false;
  _ResetAck = false;
  _rdcnt = 0;
  _nextrd = 0;
  _totalrd = 0;
  _runtotal = 0;

  if (HasExtarr_ && PtsArrMax_ && _ExtArray)
  {
    if (_ExtArrayCreated && PrevArray_ && PrevArray_ != _ExtArray)
    {
      delete[] PrevArray_;
      PrevArray_ = NULL;
    }

    ::memset(_ExtArray, 0, sizeof(PRIM)*_PtsArrMax);
    _ExtArrayCreated = true;
    _ExtArrayAvailable = false;
  }
  else if (!HasExtarr_ || !PtsArrMax_)
  {
    delete[] PrevArray_;
    PrevArray_ = NULL;

    _ExtArrayAvailable = false;
    _ExtArrayCreated = false;
  }
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::CheckForFileEnd(int prevrd)
{
  int blksz;
  int rdincr;

  #if DISCONTDETECT_SHOWDEBUGINFO2
    GraphPointsDoneArray<PRIM>* RdptsArr_ = (!_IncrRdarrPtr && prevrd) ?
                                                  (new GraphPointsDoneArray<PRIM>(_PtsArrMax)):NULL;
  #endif // DISCONTDETECT_SHOWDEBUGINFO2

  if (!_IncrRdarrPtr && prevrd)
  {
    _rdcnt -= prevrd;  // need to subtract previously read amount
    blksz = _Endp - (_Rdarr + prevrd);

    #if DISCONTDETECT_SHOWDEBUGINFO2
      if (prevrd > 0 && blksz > 0)
      {
        RdptsArr_->CopyFromThisArray(_Rdarr, prevrd);
        cout <<"Read Points: { ";
        RdptsArr_->ShowPoints(",");
        cout <<" }" <<endl;
      }

      if (blksz > 0)
      {
        RdptsArr_->CopyFromThisArray(_Rdarr+prevrd, blksz);
        cout <<"Moved Points: { ";
        RdptsArr_->ShowPoints(",");
        cout <<" }" <<endl;
      }

      cout <<"runtotal: " <<_runtotal <<endl;
      delete RdptsArr_;
    #endif // DISCONTDETECT_SHOWDEBUGINFO2

    if (blksz > 0)
      memmove(_Rdarr, _Rdarr+prevrd, sizeof(PRIM)*blksz);

    rdincr = blksz;
    blksz = _PtsConsumed = _Endp - (_Rdarr + rdincr);

    if (blksz > 0 && rdincr > 0)
      memset(_Rdarr+rdincr, 0, sizeof(PRIM)*blksz);

    _TotalPtsConsumed += _PtsConsumed;
    _NeedTerm = _TotalPtsConsumed >= _PtsInDataFile;

    if (_NeedTerm)
    {
      _RemainingPts = 0;
      _TotalPtsConsumed = _PtsInDataFile;
      return true;
    }
    else
    {
      _RemainingPts = _PtsInDataFile - _TotalPtsConsumed;

      if (_rdcnt > _RemainingPts)
        _rdcnt = _RemainingPts;
    }
  }
  else if (_IncrRdarrPtr && prevrd)
  {
    _PtsConsumed = prevrd;
    _TotalPtsConsumed += _PtsConsumed;
    _NeedTerm = _TotalPtsConsumed >= _PtsInDataFile;

    if (_NeedTerm)
    {
      _RemainingPts = 0;
      _TotalPtsConsumed = _PtsInDataFile;
      return true;
    }
    else
    {
      _RemainingPts = _PtsInDataFile - _TotalPtsConsumed;

      if (_rdcnt > _RemainingPts)
        _rdcnt = _RemainingPts;
    }
  }

  return false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::UpdateDataArray()
{
  int x;
  int max = (LastScanPending() || LastScanDone()) ? 0:10;
  int ptstoread_ = 0;
  int ptsread_ = 0;
  int rdincr = 0;
  int prevrd = 0;
  int breakcond_ = 0;
  int halfbuf_ = (_PtsArrMax - _gamax) / 2;
  bool ScanResetNeeded_ = false;

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->EnterLevel("GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::UpdateDataArray()");
  #endif

  _Gdiscp->SetDataRetrieved(true);

  if (_Gdiscp->TransferDone() && max)
    ScanResetNeeded_ = true;
  else
    _Gdiscp->ResetScan();

  for(x = 0; x < max; x++)
  {
    if (_Gdiscp->ShouldReadNextPoints())
    {
      ptstoread_ = (_rdmax-2 < _Gdiscp->ReadMorePoints() &&
                    _Gdiscp->ReadMorePoints() <= _rdmax) ? _Gdiscp->ReadMorePoints():
                   (_Gdiscp->ReadMorePoints() <= _rdmax-2) ? _rdmax-2:0;

      if (ptstoread_ > 0)
      {
        if (_IncrRdarrPtr)
          _Rdarr += (_rdcnt + _nextrd);
        else if (!_runtotal && _ResetAck)
          ResetDoneAck(true);

        prevrd = _rdcnt + _nextrd;
        _rdcnt = _IncrRdarrPtr ? _Endp - _Rdarr:
                                 _Endp - (_Rdarr + _runtotal);
        _runtotal += prevrd;
        _totalrd += prevrd;
        _NeedTerm = _IncrRdarrPtr && _rdcnt <= 0;
        breakcond_ = CheckForFileEnd(prevrd) ? 1:0;

        if (breakcond_ == 1)
          break;
        else
          breakcond_ = (_rdcnt <= 0) ? 2:
                       _NeedTerm ? 3:0;

        if (_rdcnt > ptstoread_)
          _rdcnt = ptstoread_;
        else if (breakcond_ == 2 || breakcond_ == 3)
          break;

        if (ScanResetNeeded_)
          _Gdiscp->AppendReadAheadBuffer(_rdcnt, _Rdarr, &ptsread_);
        else
          _Gdiscp->StoreNextPoints(_rdcnt, _Rdarr, &ptsread_);

        _rdcnt = ptsread_;
        rdincr = _IncrRdarrPtr ?  (_Endp - (_Rdarr+_rdcnt)):
                                  (_Endp - (_Rdarr+_runtotal+_rdcnt));
        _nextrd = _Gdiscp->ReadMorePoints();
        breakcond_ = (rdincr < 0) ? 4:0;

        if (breakcond_ == 4)
          break;
        else if (rdincr < _nextrd)
          _nextrd = rdincr;

        if (_Gdiscp->ReadMorePoints() && rdincr)
        {
          _Gdiscp->AppendReadAheadBuffer(_nextrd, _Rdarr+_rdcnt, &ptsread_);
          _nextrd = ptsread_;
        }

        _HalfBufferRead = _runtotal >= halfbuf_;
        _NeedReset = _HalfBufferRead && _AutoReset && _totalrd;

        if (_AutoReset && _NeedReset)
          ResetTotalPointsRead(false);
      }
      else if (_rdcnt || _nextrd)
      {
        if (_IncrRdarrPtr)
          _Rdarr += (_rdcnt + _nextrd);
        else if (!_runtotal && _ResetAck)
          ResetDoneAck(true);

        prevrd = _rdcnt + _nextrd;
        _rdcnt = _IncrRdarrPtr ? _Endp - _Rdarr:
                                 _Endp - (_Rdarr + _runtotal);
        _runtotal += prevrd;
        _totalrd += prevrd;
        _NeedTerm = _IncrRdarrPtr && _rdcnt <= 0;

        CheckForFileEnd(prevrd);

        _rdcnt = _nextrd = 0;
        _HalfBufferRead = _runtotal >= halfbuf_;
        _NeedReset = _HalfBufferRead && _AutoReset && _totalrd;
        breakcond_ = (_rdcnt <= 0) ? 2:
                     _NeedTerm ? 3:0;

        if (_AutoReset && _NeedReset)
          ResetTotalPointsRead(false);

        if (breakcond_ == 2 || breakcond_ == 3)
          break;
      }

    #if DISCONTDETECT_DEBUG1
      _Gdiscp->DbgPtr()->ShowInt(ScanResetNeeded_, "ScanResetNeeded_");
      _Gdiscp->DbgPtr()->ShowInt(ptstoread_, "ptstoread_");
      _Gdiscp->DbgPtr()->ShowInt(_runtotal, "_runtotal");
      _Gdiscp->DbgPtr()->ShowInt(prevrd, "prevrd");
      _Gdiscp->DbgPtr()->ShowInt(_rdcnt, "_rdcnt");
      _Gdiscp->DbgPtr()->ShowInt(rdincr, "rdincr");
      _Gdiscp->DbgPtr()->ShowInt(_nextrd, "_nextrd");
      _Gdiscp->DbgPtr()->ShowInt(_totalrd, "_totalrd");
      _Gdiscp->DbgPtr()->ShowInt(_HalfBufferRead, "_HalfBufferRead");
      _Gdiscp->DbgPtr()->ShowInt(_PtsConsumed, "_PtsConsumed");
      _Gdiscp->DbgPtr()->ShowInt(_TotalPtsConsumed, "_TotalPtsConsumed");
    #endif
    }

    if (!_NeedTerm)
      _NeedTerm = (_TotalPtsConsumed >= _PtsInDataFile) ||
                  (_IncrRdarrPtr && ((_Endp - _Rdarr <= 0) ||
                                     (_totalrd >= _PtsInDataFile)));

    if (ScanResetNeeded_)
    {
      _Gdiscp->ResetScan();
      ScanResetNeeded_ = false;

      if (!_Gdiscp->ReadMorePoints() || _NeedTerm)
        break;
    }
    else if (!_Gdiscp->ReadMorePoints() || _NeedTerm)
      break;
  }

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->ShowInt(breakcond_, "breakcond_");
    _Gdiscp->DbgPtr()->ShowInt(_AutoReset, "_AutoReset");
    _Gdiscp->DbgPtr()->ShowInt(_IncrRdarrPtr, "_IncrRdarrPtr");
    _Gdiscp->DbgPtr()->ShowInt(_NeedTerm, "_NeedTerm");
    _Gdiscp->DbgPtr()->ShowInt(_NeedReset, "_NeedReset");
  #endif // DISCONTDETECT_DEBUG1

  if (_NeedTerm && ptstoread_ && breakcond_)
    ArrayTerminationAck(true);
  else
    breakcond_ = 0;

  if (_NeedTerm && (!_Terminated && (!_Gdiscp->ReadAheadBufferTerminated() || breakcond_)))
  {
    #if DISCONTDETECT_DEBUG1
      _Gdiscp->DbgPtr()->ShowMessage("Called: TerminateReadAheadBuffer();\n");
    #endif // DISCONTDETECT_DEBUG1

    TerminateReadAheadBuffer(false);
  }
  else if (LastScanPending() || LastScanDone() || _Gdiscp->ReadAheadBufferTerminated())
  {
    _NeedTerm = false;
    _Terminated = true;
  }

  if (_AutoReset && _NeedReset)
  {
    #if DISCONTDETECT_DEBUG1
      _Gdiscp->DbgPtr()->ShowMessage("Called: ResetTotalPointsRead(false);\n");
    #endif // DISCONTDETECT_DEBUG1

    ResetTotalPointsRead(false);
  }

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->LeaveLevel();
  #endif

  return (_Terminated || _ResetDone);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ScanForDiscontinuity(bool* DiscFound_)
{
  bool Done_ = false;
  bool HasFout_ = false;
  GiveOutputFile(&HasFout_);

  if (_Gdiscp->ReadBufferFull() && _Gdiscp->ReadyForScan())
  {
    _Gdiscp->DoScan();

    if (_Gdiscp->ScanProcessDone())
    {
      if (_Gdiscp->DiscontinuityFound())
      {
		if (DiscFound_)
		  *DiscFound_ = true;
		
        _Gdiscp->MarkDiscontinuityPoints(true);
		
        #if DISCONTDETECT_SHOWDEBUGINFO
		  if (!HasFout_)
            ShowDebugInfo(false);
        #endif // DISCONTDETECT_SHOWDEBUGINFO
      }
	  else if (DiscFound_)
		*DiscFound_ = false;
    }
  }

  UpdateDataArray();
  if (DebugInfoShown())
    ResetDebugInfoShown();

  Done_ = (!SuspendedForPtsRefill() && !_Gdiscp->ReadyForScan() && !_Gdiscp->ReadMorePoints()) ||
          _Gdiscp->LastScanDone();
  return Done_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::TerminateReadAheadBuffer(bool AckTerm_)
{
  int halfbuf_ = (_PtsArrMax - _gamax) / 2;

  _NeedTerm = false;
  _TermAck = AckTerm_;

  if (!AckTerm_)
    _Terminated = true;

  _Gdiscp->TerminateReadAheadBuffer();

  _HalfBufferRead = _runtotal > halfbuf_;
  _NeedReset = _HalfBufferRead && _AutoReset && _totalrd;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetTotalPointsRead(bool AckReset_)
{
  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->EnterLevel("GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetTotalPointsRead(bool AckReset_)");
  #endif

  _HalfBufferRead = false;
  _NeedReset = false;
  _ResetAck = AckReset_;

  if (!AckReset_)
    _ResetDone = true;

  if (!_IncrRdarrPtr && _ResetNotifier && _ExtArrayAvailable)
  {
    _ResetNotifier->Notify(_ExtArray, _Rdarr, _Endp, _PtsArrMax, _runtotal);

    if (_ResetNotifier->RefillAvailable())
      SuspendForPtsRefill();
  }

  _runtotal = 0;

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->ShowInt(_totalrd, "_totalrd");
    _Gdiscp->DbgPtr()->ShowInt(_runtotal, "_runtotal");
    _Gdiscp->DbgPtr()->ShowInt(_TotalPtsConsumed, "_TotalPtsConsumed");
    _Gdiscp->DbgPtr()->ShowInt(AckReset_, "AckReset_");
    _Gdiscp->DbgPtr()->ShowInt(_ResetDone, "_ResetDone");

    _Gdiscp->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::EndRefillExtArray()
{
  SuspendForPtsRefill(false);
  _ExtArrayAvailable = _ExtArray != NULL && PointsAvailable();

  return _ExtArrayAvailable;
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::RefillExtArray(int BufSz_, PRIM* Buffer_,
                                                                            bool FillToBufSz_, int* BufIndex_)
{
  int PtsFilled_ = 0;
  bool ArrayFilled_ = _ResetNotifier->ExtArrayFilled();

  if (InitialReadDone() && !_ResetNotifier->Initialized() && _ExtArray && _ExtArrayAvailable)
  {
    SuspendForPtsRefill(true);
    _ResetNotifier->Initialize(_ExtArray, _Rdarr, _Endp, _PtsArrMax);
    _ResetNotifier->SetRefillAvailable(true);
  }

  if (SuspendedForPtsRefill() &&
      _ResetNotifier->RefillAvailable() && !_ResetNotifier->ExtArrayFilled())
  {
    PtsFilled_ = _ResetNotifier->RefillExtArray(BufSz_, Buffer_, FillToBufSz_);
    _ExtArrayAvailable = PtsFilled_ != 0;
  }
  else if (!_ResetNotifier->RefillAvailable() || _ResetNotifier->ExtArrayFilled())
  {
    SuspendForPtsRefill(false);
    _ExtArrayAvailable = _ExtArray != NULL && PointsAvailable();
  }

  if (BufIndex_ && !ArrayFilled_ && _ExtArrayAvailable)
    *BufIndex_ += PtsFilled_;

  return PtsFilled_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::RefillExtArray(PRIM Val_, int* BufIndex_)
{
  int PtsFilled_ = 0;
  bool ArrayFilled_ = _ResetNotifier->ExtArrayFilled();

  if (InitialReadDone() && !_ResetNotifier->Initialized() && _ExtArray && _ExtArrayAvailable)
  {
    SuspendForPtsRefill(true);
    _ResetNotifier->Initialize(_ExtArray, _Rdarr, _Endp, _PtsArrMax);
    _ResetNotifier->SetRefillAvailable(true);
  }

  if (SuspendedForPtsRefill() &&
      _ResetNotifier->RefillAvailable() && !_ResetNotifier->ExtArrayFilled())
  {
    PtsFilled_ = _ResetNotifier->RefillExtArray(Val_);
    _ExtArrayAvailable = PtsFilled_ != 0;
  }
  else if (!_ResetNotifier->RefillAvailable() || _ResetNotifier->ExtArrayFilled())
  {
    SuspendForPtsRefill(false);
    _ExtArrayAvailable = _ExtArray != NULL && PointsAvailable();
  }

  if (BufIndex_ && !ArrayFilled_ && _ExtArrayAvailable)
    *BufIndex_ += PtsFilled_;

  return PtsFilled_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ArrayTerminationAck(bool ForceReset_)
{
  _TermAck = true;

  if (_Gdiscp->ReadAheadBufferTerminated() && !ForceReset_)
    return;

  _Terminated = false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetDoneAck(bool ForceReset_)
{
  _ResetAck = true;

  if (_runtotal == 0 && !ForceReset_)
    return;

  _ResetDone = false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::InitialReadDone()
{
  _InitReadDone = _Endp == &_ArrStart[_PtsArrMax] &&
                  ((!_IncrRdarrPtr && _Rdarr == &_ArrStart[_gamax]) ||
                   (_IncrRdarrPtr && _Rdarr >= &_ArrStart[_gamax])) &&
                  _PtsConsumed > 0 &&
                  _TotalPtsConsumed > 0;

  return _InitReadDone;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::InitialDataRead()
{
    int ptsread_ = 0;
    int initread_ = 0;

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->EnterLevel("GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::InitialDataRead()");
  #endif

    _Endp = &_ArrStart[_PtsArrMax];
    _Gdiscp->StoreNextPoints(_gamax, _ArrStart, &initread_);
    _Rdarr = &_ArrStart[_gamax];
    _PtsConsumed = initread_;
    _TotalPtsConsumed += _PtsConsumed;
    InitialReadDone();

    if (_InitReadDone && _Gdiscp->ShouldReadNextPoints())
    {
      _Gdiscp->StoreNextPoints(_rdmax, _Rdarr, &ptsread_);
      _rdcnt = ptsread_;
    }

    if (_InitReadDone && !_ResetNotifier->Initialized() && _ExtArray && _ExtArrayAvailable)
      _ResetNotifier->Initialize(_ExtArray, _Rdarr, _Endp, _PtsArrMax);

  #if DISCONTDETECT_DEBUG1
    _Gdiscp->DbgPtr()->ShowInt(initread_, "initread_");
    _Gdiscp->DbgPtr()->ShowInt(ptsread_, "ptsread_");
    _Gdiscp->DbgPtr()->ShowInt(_gamax, "_gamax");
    _Gdiscp->DbgPtr()->ShowInt(_rdcnt, "_rdcnt");
    _Gdiscp->DbgPtr()->ShowInt(_TotalPtsConsumed, "_TotalPtsConsumed");
    _Gdiscp->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::HasProcessedPoints() const
{
  GraphPointsDoneArray<PRIM>* DonePts_ = (_Gdiscp ? _Gdiscp->GiveProcessedPts():NULL);
  return (DonePts_ ? DonePts_->HasPoints():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
GraphPointsDoneArray<PRIM>* GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::GiveProcessedPts()
{
  return (HasProcessedPoints() ? _Gdiscp->GiveProcessedPts():NULL);
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::operator [] (size_t x) const
{
  if (!_Gdiscp || x >= _Gdiscp->PointsBufferSize())
    return 0;

  return (*_Gdiscp)[x];
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ShowDebugInfo(bool ResetShown_)
{
  if (_Gdiscp)
    _Gdiscp->ShowDebugInfo(ResetShown_);
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ShowProcessedPoints(bool ResetShown_, const char* DelimStr_)
{
  if (_Gdiscp)
    _Gdiscp->ShowProcessedPoints(ResetShown_, DelimStr_);
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::NotifyProcessedPoints()
{
  if (_Gdiscp)
    _Gdiscp->NotifyProcessedPoints();
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::SetOutputFile(const char* Filename_)
{
  if (_Gdiscp)
	_Gdiscp->SetOutputFile(Filename_);
}

/****************************************************************************/
template <class WRAP, class PRIM>
ofstream* GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::GiveOutputFile(bool* HasFout_)
{
  return (_Gdiscp ? _Gdiscp->GiveOutputFile(HasFout_):NULL);
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetDebugInfoShown()
{
  if (_Gdiscp)
    _Gdiscp->ResetDebugInfoShown();
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ResetProcessedPointsShown()
{
  if (_Gdiscp)
    _Gdiscp->ResetProcessedPointsShown();
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::DebugInfoShown() const
{
  return (_Gdiscp ? _Gdiscp->DebugInfoShown():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ProcessedPointsShown() const
{
  return (_Gdiscp ? _Gdiscp->ProcessedPointsShown():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::LastScanPending() const
{
  return (_Gdiscp ? _Gdiscp->LastScanPending():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::LastScanDone() const
{
  return (_Gdiscp ? _Gdiscp->LastScanDone():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ReadAheadBufferTerminated() const
{
  return (_Gdiscp ? _Gdiscp->ReadAheadBufferTerminated():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::DiscontinuityFound() const
{
  return (_Gdiscp ? _Gdiscp->DiscontinuityFound():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::DiscontinuityNotFound() const
{
  return (_Gdiscp ? _Gdiscp->DiscontinuityNotFound():false);
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::ReadMorePoints() const
{
  return (_Gdiscp ? _Gdiscp->ReadMorePoints():0);
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::TerminatedPts() const
{
  return (_Gdiscp ? _Gdiscp->TerminatedPts():0);
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::DataArrayStruct::OverFlowedPoints() const
{
  return (_Gdiscp ? _Gdiscp->OverFlowedPoints():0);
}

/****************************************************************************/
// Graph Discontinuity Detector class definitions
/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>::GraphDiscontinuityDetector(PointsDoneNotifier<PRIM>* PtsDoneNotifier_,
                                                                   ArrayResetNotifier<PRIM>* ResetNotifier_):
#if ((CALCLIB_DEBUGGING)&(DISCONTDETECT_USE_CALCBASE_CLASS))
DiscontinuityDetectorBase(DiscontinuityDetectorBase::GetCalculatorPtr()->DbgPtr()),
#endif
_BackPts(NULL),
_FrontPts(NULL),
_InfinityPt(NULL),
_GraphPtsBuffer(new PRIM[(CALC_DISCONTINUITY_STRIKES*2)+1]),
_GraphPtsPtr(NULL),
_ReadAheadBuffer(new PRIM[CALC_DISCONTINUITY_STRIKES+2]),
_ReadAheadPtr(NULL),
_ResetNotifier(ResetNotifier_ ? ResetNotifier_:(new ArrayResetNotifier<PRIM>)),
_PtsDoneNotifier(PtsDoneNotifier_ ? PtsDoneNotifier_:(new PointsDoneNotifier<PRIM>)),
_DonePtsArray(new GraphPointsDoneArray<PRIM>((CALC_DISCONTINUITY_STRIKES*2)+1)),
_BackDiscontinuityIndex(0),
_FrontDiscontinuityIndex(0),
_Wrapper(new WRAP),
_ReadMorePts(0),
_BackStrikes(0),
_FrontStrikes(0),
_GraphPtsIndex(0),
_RdAheadIndex(0),
_TransferPts(0),
_TerminatedPts(0),
_DataPtsRead(0),
_OverFlowedPts(0),
_ScanNumber(0),
_DiscontinuityCond(0),
_TransferDone(false),
_AtGraphEdge(false),
_AtGraphStart(false),
_AtGraphEnd(false),
_FrontPtsShifted(false),
_GraphPtsNotRead(true),
_RdAheadPtsNotRead(true),
_ScanningDiscontinuity(false),
_PtGapReached(false),
_DiscontinuityNotFound(true),
_DiscontinuityFound(false),
_InfinityPtFound(false),
_OverFlowedPtsMoved(false),
_SingleDiscAtEdge(false),
_ScanningNegToPosInfinity(false),
_ScanningPosToNegInfinity(false),
_ScanProcessDone(false),
_LastScanPending(false),
_LastScanDone(false),
_NegToPosInfinityFound(false),
_PosToNegInfinityFound(false),
_ReadNextPts(false),
_EOFreached(false),
_DataRetrieved(false),
_DebugInfoShown(false),
_ProcessedPointsShown(false),
_ProcessedPointsCopied(false),
_PointsBufferFlushed(false)
{
  int RemainToRead_ = 0;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("GraphDiscontinuityDetector<WRAP, PRIM>::GraphDiscontinuityDetector()");
  #endif

  if (_GraphPtsBuffer)
  {
    memset(_GraphPtsBuffer, 0, sizeof(PRIM)*_PtBufferSize);
    _GraphPtsNotRead = true;

    _BackPts = _GraphPtsBuffer;
    _FrontPts = &_GraphPtsBuffer[_StrikeLimit];
    _InfinityPt = _FrontPts;
    _GraphPtsPtr = _GraphPtsBuffer;
    _FrontPtsShifted = false;

    RemainToRead_ += _PtBufferSize - 1;
    _GraphPtsIndex = 0;
  }

  if (_ReadAheadBuffer)
  {
    memset(_ReadAheadBuffer, 0, sizeof(PRIM)*_RdBufferSize);
    _RdAheadPtsNotRead = true;

    _ReadAheadPtr = _ReadAheadBuffer;

    RemainToRead_ += _RdBufferSize;
    _RdAheadIndex = 0;
  }

  _ReadNextPts = !_EOFreached && RemainToRead_ > 0;
  _ReadMorePts = _ReadNextPts ? RemainToRead_:0;
	
  #if (DISCONTDETECT_USE_CALCBASE_CLASS)
    if (strcmp("PointsDoneNotifier", _PtsDoneNotifier->ClassName()) == 0)
      _PtsDoneNotifier->SetBasePointer(NULL);
    else if (strcmp("CalcPointsDoneNotifier", _PtsDoneNotifier->ClassName()) == 0)
      ((CalcPointsDoneNotifier<PRIM>*)_PtsDoneNotifier)->SetCalcBasePointer(GetCalculatorPtr());
  #endif
 
  _PtsDoneNotifier->SetDetectorPointer(this);

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
    DbgPtr()->ShowInt(RemainToRead_, "RemainToRead_");

    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>::~GraphDiscontinuityDetector()
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("GraphDiscontinuityDetector<WRAP, PRIM>::~GraphDiscontinuityDetector()");
  #endif

  _DataRetrieved = false;
  _ReadNextPts = false;
  _ReadMorePts = 0;

  delete[] _GraphPtsBuffer;
  delete[] _ReadAheadBuffer;

  delete _Wrapper;
  delete _ResetNotifier;
  delete _PtsDoneNotifier;
  delete _DonePtsArray;

  _GraphPtsBuffer = NULL;
  _ReadAheadBuffer = NULL;
  _ReadAheadPtr = NULL;

  _Wrapper = NULL;
  _ResetNotifier = NULL;
  _PtsDoneNotifier = NULL;
  _DonePtsArray = NULL;

  _BackPts = NULL;
  _FrontPts = NULL;
  _GraphPtsBuffer = NULL;
  _GraphPtsPtr = NULL;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
#if DISCONTDETECT_USE_CALCBASE_CLASS
GraphDiscontinuityDetector<WRAP, PRIM>* GraphDiscontinuityDetector<WRAP, PRIM>::Make(CalculatorBase* BasePtr_,
                                                                                     PointsDoneNotifier<PRIM>* PtsDoneNotifier_,
                                                                                     ArrayResetNotifier<PRIM>* ResetNotifier_)
#else
// testing with const char* instead of CalculatorBase*
GraphDiscontinuityDetector<WRAP, PRIM>* GraphDiscontinuityDetector<WRAP, PRIM>::Make(const char* BasePtr_,
                                                                                     PointsDoneNotifier<PRIM>* PtsDoneNotifier_,
                                                                                     ArrayResetNotifier<PRIM>* ResetNotifier_)
#endif // DISCONTDETECT_USE_CALCBASE_CLASS
{
  if (BasePtr_)
    SetCalculatorPtr(BasePtr_);

  if (_BasePtr && _UsingCalcType)
  {
/*
    return (
      (_UsingCalcType == CalculatorBase::FLOAT) ? (new GraphDiscontinuityDetector<Float, float>()):
      (_UsingCalcType == CalculatorBase::DOUBLE) ? (new GraphDiscontinuityDetector<Double, double>()):
      (_UsingCalcType == CalculatorBase::LONGDOUBLE) ? (new GraphDiscontinuityDetector<LongDouble, Ldouble>()):
      (_UsingCalcType == CalculatorBase::LONGNUM) ? (new GraphDiscontinuityDetector<LongDouble, Ldouble>()):
      NULL
    );
*/

    return (new GraphDiscontinuityDetector<WRAP, PRIM>(PtsDoneNotifier_, ResetNotifier_));
  }

  return NULL;
}

/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>& GraphDiscontinuityDetector<WRAP, PRIM>::SetEOFreached(bool reached_)
{
  _EOFreached = reached_;
  return *this;
}

/****************************************************************************/
template <class WRAP, class PRIM>
GraphDiscontinuityDetector<WRAP, PRIM>& GraphDiscontinuityDetector<WRAP, PRIM>::SetDataRetrieved(bool done_)
{
  _DataRetrieved = done_;
  return *this;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ReadAheadBufferFilled()
{
  bool cond1_ = _RdAheadIndex == _RdBufferSize || (_TransferPts && _TransferDone);
  bool cond2_ = _ReadAheadPtr == _ReadAheadBuffer;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ReadAheadBufferFilled()");

    DbgPtr()->ShowInt(cond1_, "_RdAheadIndex == _RdBufferSize");
    DbgPtr()->ShowInt(cond2_, "_ReadAheadPtr == _ReadAheadBuffer");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
  #endif

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif

  return (cond1_ && (cond2_ || !_RdAheadPtsNotRead));
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::GraphPtsBufferFilled()
{
  bool cond1_ = _GraphPtsIndex == _PtBufferSize - 1;
  bool cond2_ = _GraphPtsPtr == _GraphPtsBuffer;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("GraphPtsBufferFilled()");

    DbgPtr()->ShowInt(cond1_, "_GraphPtsIndex == _PtBufferSize - 1");
    DbgPtr()->ShowInt(cond2_, "_GraphPtsPtr == _GraphPtsBuffer");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_GraphPtsNotRead");
  #endif

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif

  return (cond1_ && (cond2_ || !_GraphPtsNotRead));
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::ShowProcessedPoints(bool ResetShown_, const char* DelimStr_)
{
  int HasPoints_ = _DonePtsArray ? _DonePtsArray->HasPoints():false;
  int tempv = HasPoints_;
  HasPoints_ = HasPoints_ && _PointsBufferFlushed && _OverFlowedPts;
  int OverFlow_ = HasPoints_ ? _OverFlowedPts:0;
  HasPoints_ = tempv;

  if (!HasPoints_)
    _ProcessedPointsShown = false;

  if (_ProcessedPointsShown || !HasPoints_)
    return;

  if (_PtsDoneNotifier)
    _PtsDoneNotifier->Notify_ShowPoints(_DonePtsArray, HasPoints_, OverFlow_, _PointsBufferFlushed);

  bool HasFout_;
  ofstream* Fout_ = GiveOutputFile(&HasFout_);

  if (!HasFout_)
  {
    cout <<"Processed Array Points: { ";
    _DonePtsArray->ShowPoints(DelimStr_);
    cout <<" }" <<endl;

    if (_PointsBufferFlushed)
    {
      if (OverFlowedPoints())
        cout <<"Overflowed Points: " <<OverFlowedPoints() <<endl;
      else
        cout <<"No Overflowed Points" <<endl;
    }
  }
  else
	_DonePtsArray->ShowPoints(Fout_);

  _ProcessedPointsShown = !ResetShown_;

  if (ResetShown_)
    _ProcessedPointsCopied = false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::NotifyProcessedPoints()
{
  int HasPoints_ = _DonePtsArray ? _DonePtsArray->HasPoints():false;
  int tempv = HasPoints_;

  if (!HasPoints_)
    _ProcessedPointsShown = false;

  if (_ProcessedPointsShown || !HasPoints_)
    return;

  HasPoints_ = HasPoints_ && _PointsBufferFlushed && _OverFlowedPts;
  int OverFlow_ = HasPoints_ ? _OverFlowedPts:0;
  HasPoints_ = tempv;

  if (_PtsDoneNotifier)
    _PtsDoneNotifier->Notify(_DonePtsArray, HasPoints_, OverFlow_, _PointsBufferFlushed);

  _ProcessedPointsShown = false;
  _ProcessedPointsCopied = false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::FindGreatestDiscontinuity(int discpt_, PRIM ptgapval_,
                                                                      int signchange_, int& direction_,
                                                                      int& incval_, int& flatval_, int& decval_)
{
  if (direction_ == 0)
    return discpt_;

  int x;
  int max = _PtBufferSize - 1;
  int maxstrikes_ = _StrikeLimit-1;

  int maxpt_ = discpt_;
  int testpt_ = discpt_;
  bool noincr_ = false;

  PRIM maxval_ = ptgapval_;
  PRIM prevval_ = ptgapval_;
  PRIM testval_ = 0;

  incval_ = 1;
  flatval_ = 0;
  decval_ = 0;

  for (x = discpt_+1; x < max && !decval_ && !flatval_ && !noincr_; x++)
  {
    testval_ = ::fabs(_GraphPtsBuffer[x] - _GraphPtsBuffer[testpt_]);

    if (direction_ > 0)
    {
      if (!decval_ && !flatval_ && testval_ && testval_ > maxval_)
      {
        if (_GraphPtsBuffer[x] > _GraphPtsBuffer[testpt_])
        {
          maxpt_ = x;
          maxval_ = testval_;

          ++incval_;
          ++direction_;
        }
        else if (_GraphPtsBuffer[x] < _GraphPtsBuffer[testpt_])
        {
          if (::labs(direction_) >= maxstrikes_)
          {
            maxpt_ = x;
            maxval_ = testval_;
          }

          ++decval_;
        }
      }
      else if (!signchange_ && testval_ && testval_ == prevval_)
      {
        testpt_ = x;
        prevval_ = testval_;
      }
      else
      {
        if (testval_ == 0)
          ++flatval_;
        else if (_GraphPtsBuffer[x] < _GraphPtsBuffer[testpt_])
          ++decval_;
        else
          noincr_ = true;
      }
    }
    else if (direction_ < 0)
    {
      if (!decval_ && !flatval_ && testval_ && testval_ > maxval_)
      {
        if (_GraphPtsBuffer[x] < _GraphPtsBuffer[testpt_])
        {
          maxpt_ = x;
          maxval_ = testval_;

          ++incval_;
          --direction_;
        }
        else if (_GraphPtsBuffer[x] > _GraphPtsBuffer[testpt_])
        {
          if (::labs(direction_) >= maxstrikes_)
          {
            maxpt_ = x;
            maxval_ = testval_;
          }

          ++decval_;
        }
      }
      else if (!signchange_ && testval_ && testval_ == prevval_)
      {
        testpt_ = x;
        prevval_ = testval_;
      }
      else
      {
        if (testval_ == 0)
          ++flatval_;
        else if (_GraphPtsBuffer[x] > _GraphPtsBuffer[testpt_])
          ++decval_;
        else
          noincr_ = true;
      }
    }
  }

  return maxpt_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DetermineGraphEdges(int PendingPtsShift_)
{
  int GraphMidPt_ = _StrikeLimit - 1;
  int DataCeiling_ = _RdBufferSize - _TerminatedPts;
  bool NoDiscFound_ = _DiscontinuityCond == NO_POINTGAP_FOUND;

  _AtGraphStart = _ScanNumber == 1 && (NoDiscFound_ || _BackDiscontinuityIndex < GraphMidPt_);
  _AtGraphEnd = ((_TerminatedPts || _EOFreached) && _RdAheadIndex > 0) ?
                      (_LastScanPending || (_StrikeLimit + PendingPtsShift_ >= DataCeiling_)):0;
  _AtGraphEdge = _AtGraphStart || _AtGraphEnd;

  return _AtGraphEdge;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::ShowDebugInfo(bool ResetShown_)
{
    if (_DebugInfoShown)
      return;

    PRIM* Graphbuff_ = NULL;
    PRIM* Frontbuff_ = NULL;
    PRIM* Backbuff_ = NULL;

    PRIM InfPt_ = 0;
    PRIM FrontDisc_ = 0;
    PRIM BackDisc_ = 0;

    int x;
    int outmax = CALC_DISCONTINUITY_STRIKES;
    int FrontIndex_ = 0;
    int BackIndex_ = 0;

    Graphbuff_ = GiveGraphPts();
    Backbuff_ = GiveBackPts();
    Frontbuff_ = GiveFrontPts();
    BackDisc_ = GiveBackDiscontinuityPt();
    FrontDisc_ = GiveFrontDiscontinuityPt();
    BackIndex_ = BackDiscontinuityIndex();
    FrontIndex_ = FrontDiscontinuityIndex();
    InfPt_ = GiveInfinityPt();
    _DebugInfoShown = !ResetShown_;

    cout <<"********************* Discontinuity Detector Debug Info ********************* " <<endl;
    ShowProcessedPoints(true);
    cout <<"DiscontinuityFound() == " <<DiscontinuityFound() <<endl;

    for (x = 0; x < outmax; x++)
      cout <<"Backbuff[" <<x <<"] = " <<Backbuff_[x] <<endl;

    for (x = 0; x < outmax; x++)
      cout <<"Frontbuff[" <<x <<"] = " <<Frontbuff_[x] <<endl;

    if (BackDisc_ == Graphbuff_[BackIndex_])
      cout <<"BackDisc_ == " <<BackDisc_ <<endl;
    else
      cout <<"BackDisc_ != Graphbuff_[BackIndex_]" <<endl;

    if (FrontDisc_ == Graphbuff_[FrontIndex_])
      cout <<"FrontDisc_ == " <<FrontDisc_ <<endl;
    else
      cout <<"FrontDisc_ != Graphbuff_[FrontIndex_]" <<endl;

    cout <<"FrontIndex_ == " <<FrontIndex_ <<endl;
    cout <<"BackIndex_ == " <<BackIndex_ <<endl;
    cout <<"InfinityPt_ == " <<InfPt_ <<endl;
    cout <<"******************************* Debug Info End ****************************** " <<endl;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::TransferFromReadAheadBuffer(int shiftlen_, bool ShowDonePts_)
{
  if (_TransferDone)
    return;

  int max;
  int offset;
  int remain;
  int DataCeiling_ = _RdBufferSize - _TerminatedPts;

  // pt. shift anticipating calling method: ShiftArrayPts(0, discpt_...); from method DoScan()
  int PendingPtsShift_ = _InfinityPtFound ? 1:0;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("TransferFromReadAheadBuffer(int shiftlen_, bool ShowDonePts_)");
  #endif

  // moving back most points in the Graph points buffer to the Done Points Array
  max = _PtBufferSize - 1;
  _DonePtsArray->CopyFromThisArray(_GraphPtsBuffer, shiftlen_);
  _ProcessedPointsCopied = true;

  if (_ProcessedPointsCopied)
  {
    if (ShowDonePts_)
      ShowProcessedPoints();
    else
      NotifyProcessedPoints();
  }

  // moving from read ahead buffer to array points buffer
  memmove(_GraphPtsBuffer, &_GraphPtsBuffer[shiftlen_], sizeof(PRIM)*(max-shiftlen_));
  memmove(&_GraphPtsBuffer[max-shiftlen_], _ReadAheadPtr, sizeof(PRIM)*shiftlen_);

  // completing move by shifting contents of read ahead buffer to the
  // start of the buffer
  max = _RdBufferSize;
  _ReadAheadPtr += shiftlen_;
  offset = _ReadAheadPtr - _ReadAheadBuffer;
  memmove(_ReadAheadBuffer, _ReadAheadPtr, sizeof(PRIM)*(max-offset));
  _ReadAheadPtr = &_ReadAheadBuffer[max-offset];
  remain = &_ReadAheadBuffer[max] - _ReadAheadPtr;
  memset(_ReadAheadPtr, 0, sizeof(PRIM)*remain);
  _RdAheadIndex = _ReadAheadPtr - _ReadAheadBuffer;
  _ReadAheadPtr = _ReadAheadBuffer;

  _TransferPts = remain;
  _TransferDone = true;

  if (_TransferPts)
  {
    _OverFlowedPts = _TransferPts - DataCeiling_;
    _OverFlowedPtsMoved = _OverFlowedPts > 0;

    if (_OverFlowedPts >= _StrikeLimit)
      _OverFlowedPts = _StrikeLimit - 1;
    else if (!_OverFlowedPtsMoved)
      _OverFlowedPts = 0;
  }

  // pt. shift anticipating calling method: ShiftArrayPts(1, _StrikeLimit...); from ResetScan()
  PendingPtsShift_ += ((_TerminatedPts || _EOFreached) && _RdAheadIndex > 0) ? (_OverFlowedPts+1):0;
  DetermineGraphEdges(PendingPtsShift_);

  if ((PendingPtsShift_ && _AtGraphEnd && (_TerminatedPts || _EOFreached)) &&
      (_DiscontinuityCond == INFINITYPOINT_FOUND ||
       _DiscontinuityCond == DISCONTINUITY_FOUND))
    _LastScanPending = (_TerminatedPts || _EOFreached) && (_StrikeLimit + PendingPtsShift_) >= DataCeiling_;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(max, "max");
    DbgPtr()->ShowInt(shiftlen_, "shiftlen_");
    DbgPtr()->ShowInt(offset, "offset");
    DbgPtr()->ShowInt(remain, "remain");
    DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");

    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::FlushPointsBuffer()
{
  if (_PointsBufferFlushed || !_LastScanDone)
    return;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("FlushPointsBuffer()");
  #endif

  int newoffset = 0;
  int DataCeiling_ = 0;

  bool ReadAheadMoved_ = false;
  bool FrontPastInfinity_ = false;
  bool FrontBehindInfinity_ = false;
  bool InfinityAtGraphEnd_ = false;

  #if ((DISCONTDETECT_SHOWDEBUGINFO) & (!(DISCONTDETECT_TESTNOTIFIERS)))
    bool ShowDonePts_ = true;
  #else
    bool ShowDonePts_ = false;
  #endif // DISCONTDETECT_SHOWDEBUGINFO

  if (_ReadAheadBuffer)
  {
    newoffset = ShiftArrayPts(1, _StrikeLimit, ReadAheadMoved_, ShowDonePts_);
    DataCeiling_ = _RdBufferSize - _TerminatedPts;

    _DonePtsArray->CopyFromThisArray(_BackPts, _StrikeLimit);
    _PointsBufferFlushed = true;

    if ((_PtGapReached && _AtGraphEnd && (_TerminatedPts || _EOFreached)) &&
        (_DiscontinuityCond == INFINITYPOINT_FOUND ||
         _DiscontinuityCond == DISCONTINUITY_FOUND))
    {
      _OverFlowedPts = _TransferDone ? _TransferPts:0;
      _OverFlowedPts += (_StrikeLimit + newoffset) - DataCeiling_;
      _OverFlowedPtsMoved = _OverFlowedPts > 0;

      if (_OverFlowedPts >= _StrikeLimit)
      {
        FrontPastInfinity_ = _InfinityPtFound && _FrontPts == _InfinityPt + 1;
        FrontBehindInfinity_ = _AtGraphEnd && _SingleDiscAtEdge;
        InfinityAtGraphEnd_ = _InfinityPt == &_GraphPtsBuffer[_StrikeLimit] &&
                              (_FrontPts == _InfinityPt || FrontPastInfinity_ || FrontBehindInfinity_) &&
                              _TerminatedPts >= _StrikeLimit - 1;

        _OverFlowedPts = _StrikeLimit - 1;
        if (InfinityAtGraphEnd_)
          ++_OverFlowedPts;
      }
      else if (!_OverFlowedPtsMoved)
        _OverFlowedPts = 0;
    }

    if (ShowDonePts_)
      ShowProcessedPoints();
    else
      NotifyProcessedPoints();
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
int GraphDiscontinuityDetector<WRAP, PRIM>::ShiftArrayPts(int PtsShifted_, int DiscPt_, bool& ReadAheadMoved_, bool ShowDonePts_)
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ShiftArrayPts(int PtsShifted_)");
  #endif

  int x;
  int offset = _ReadAheadPtr - _ReadAheadBuffer;
  int newoffset = 0;
  int maxshift_ = 0;

  bool PtsCopied_ = false;
  PRIM TermVal_ = _ReadAheadBuffer[_RdAheadIndex-1];

  if (_RdAheadIndex > 0 && _InfinityPtFound && PtsShifted_ <= 0)
  {
    if (PtsShifted_ == 0 && DiscPt_ == _StrikeLimit &&
        _InfinityPt == &_GraphPtsBuffer[_StrikeLimit] &&
        _ReadAheadPtr == _ReadAheadBuffer &&
        (!_AtGraphEdge || (_AtGraphEnd && (_TerminatedPts || _EOFreached))))
    {
      _FrontPts = _InfinityPt + 1;  // Infinity pt. at mid graph and start of front pts is 1 past inf. pt.
      _FrontPts[_StrikeLimit-1] = *_ReadAheadPtr;

      _ReadAheadPtr++;
      _FrontPtsShifted =
      ReadAheadMoved_ = true;
      newoffset = _ReadAheadPtr - _ReadAheadBuffer;
    }
    else if (PtsShifted_ == -1)
    {
      if (ReadAheadMoved_ && _ReadAheadPtr > _ReadAheadBuffer)
      {
        _FrontPts[_StrikeLimit-1] = 0;
        _ReadAheadPtr--;
        _FrontPtsShifted =
        ReadAheadMoved_ = false;
      }

      _FrontDiscontinuityIndex = DiscPt_;
      _InfinityPt = &_GraphPtsBuffer[DiscPt_];
      _FrontPts = _InfinityPt;
      _InfinityPtFound = false;
    }
  }
  else if (PtsShifted_ == 1 && _DonePtsArray)
  {
    if (_PtGapReached && (!_AtGraphEdge || (_AtGraphEnd && (_TerminatedPts || _EOFreached))))
    {
      // assuming discontinuity pt. is located at mid. graph
      if (_LastScanDone && _SingleDiscAtEdge && _DiscontinuityFound &&
          _FrontDiscontinuityIndex == _BackDiscontinuityIndex &&
          _InfinityPt == &_GraphPtsBuffer[_BackDiscontinuityIndex])
      {
        maxshift_ = _BackDiscontinuityIndex + 1;
        _DonePtsArray->CopyFromThisArray(_BackPts, maxshift_);
        PtsCopied_ = true;
        maxshift_ -= _StrikeLimit;

        // start of front pts array is located at 2nd discontinuity pt. so shift pts array forward 1 pt.
        // and append pt, from read ahead buffer onto end of front pts, array
        memmove(_FrontPts, &_FrontPts[maxshift_], sizeof(PRIM)*(_StrikeLimit-maxshift_));

        for (x = _StrikeLimit - maxshift_; x < _StrikeLimit; x++)
        {
          if (_ReadAheadPtr - _ReadAheadBuffer < _RdBufferSize)
          {
            _FrontPts[x] = *_ReadAheadPtr;
            _ReadAheadPtr++;
          }
          else
            _FrontPts[x] = TermVal_;
        }

        ReadAheadMoved_ = true;
      }
      else
      {
        if (offset == 1 && _InfinityPtFound)  // Front pts array already shifted 1 pt. forward
        {
          // copy discontinuity pts. and infinity pt. to points done array
          _DonePtsArray->CopyFromThisArray(_BackPts, _StrikeLimit+2);
          PtsCopied_ = true;
        }
        else if (offset == 0)                 // Front pts array not shifted. Infinity pt. not found
        {
          // copy discontinuity pts. to points done array
          _DonePtsArray->CopyFromThisArray(_BackPts, _StrikeLimit+1);
          PtsCopied_ = true;
        }

        // start of front pts array is located at 2nd discontinuity pt. so shift pts array forward 1 pt.
        // and append pt, from read ahead buffer onto end of front pts, array
        memmove(_FrontPts, &_FrontPts[1], sizeof(PRIM)*(_StrikeLimit-1));
        _FrontPts[_StrikeLimit-1] = *_ReadAheadPtr;
        _ReadAheadPtr++;
        ReadAheadMoved_ = true;
      }
    }
    else
    {
      // either discontinuity not found or it is located within back pts array so no need to copy
      // past the length of the back pts array to the points done array
      _DonePtsArray->CopyFromThisArray(_BackPts, _StrikeLimit);
      PtsCopied_ = true;
    }

    // transfer all points in front pts array to back pts array
    // and reset location of infinity pt. to mid graph
    memmove(_BackPts, _FrontPts, sizeof(PRIM)*_StrikeLimit);
    _InfinityPt = &_GraphPtsBuffer[_StrikeLimit];
    _FrontPts = _InfinityPt;
    _ProcessedPointsCopied = PtsCopied_;
    newoffset = _ReadAheadPtr - _ReadAheadBuffer;
    _FrontPtsShifted = false;

    if (PtsCopied_)
    {
      if (ShowDonePts_)
        ShowProcessedPoints();
      else
        NotifyProcessedPoints();
    }
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(offset, "offset");
    DbgPtr()->ShowInt(PtsShifted_, "PtsShifted_");
    DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");
    DbgPtr()->ShowInt(_InfinityPtFound, "_InfinityPtFound");
    DbgPtr()->ShowInt(newoffset, "newoffset");

    DbgPtr()->LeaveLevel();
  #endif

  return newoffset;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ResetScan(bool ResetEOF_)
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ResetScan(bool)");
  #endif

  #if ((DISCONTDETECT_SHOWDEBUGINFO) & (!(DISCONTDETECT_TESTNOTIFIERS)))
    bool ShowDonePts_ = true;
  #else
    bool ShowDonePts_ = false;
  #endif // DISCONTDETECT_SHOWDEBUGINFO

  bool IndexNotAtMax_ = _RdAheadIndex < _RdBufferSize;

  if (!(_EOFreached || ResetEOF_) &&
      (!_DataRetrieved || _LastScanPending || _LastScanDone ||
       (IndexNotAtMax_ && (_TransferPts && _TransferDone))))
  {
    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_EOFreached, "_EOFreached");
      DbgPtr()->ShowInt(ResetEOF_, "ResetEOF_");
      DbgPtr()->ShowInt(_DataRetrieved, "_DataRetrieved");
      DbgPtr()->ShowInt(_LastScanPending, "_LastScanPending");
      DbgPtr()->ShowInt(_LastScanDone, "_LastScanDone");
      DbgPtr()->ShowInt(IndexNotAtMax_, "IndexNotAtMax_");
      DbgPtr()->ShowInt(_TransferPts, "_TransferPts");
      DbgPtr()->LeaveLevel();
    #endif

    if (_LastScanDone && !_PointsBufferFlushed)
      FlushPointsBuffer();

    return false;
  }

  int RemainToRead_ = 0;           // Remaining points needed to be read from calculator
  int offset = 0;
  int newoffset = 0;
  int DataCeiling_ = 0;
  bool ReadAheadMoved_ = false;
  bool FrontPtsShifted_ = false;   // Front Points buffer shifted to back points buffer

  _DataRetrieved = false;

  if (_EOFreached || ResetEOF_)
  {
    delete[] _ReadAheadBuffer;
    _ReadAheadBuffer = NULL;
    _ReadAheadPtr = NULL;
    _InfinityPt =
    _FrontPts =
    _BackPts = NULL;
    _RdAheadIndex = 0;
    _RdAheadPtsNotRead = true;

    delete[] _GraphPtsBuffer;
    _GraphPtsBuffer = NULL;
    _GraphPtsPtr = NULL;
    _GraphPtsIndex = 0;
    _GraphPtsNotRead = true;

    _PtGapReached = false;
    _InfinityPtFound = false;
    _LastScanPending = false;
    _LastScanDone = false;
    _TransferDone = false;
    _PointsBufferFlushed = false;
    _FrontPtsShifted = false;
    _AtGraphEdge = false;
    _AtGraphStart = false;
    _AtGraphEnd = false;
    _OverFlowedPtsMoved = false;

    _ScanNumber = 0;
    _OverFlowedPts = 0;
    _TransferPts = 0;
    _TerminatedPts = 0;
    _DataPtsRead = 0;
    _DiscontinuityCond = NO_POINTGAP_FOUND;

    _DonePtsArray->Clear();

    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_EOFreached, "_EOFreached");
      DbgPtr()->ShowInt(ResetEOF_, "ResetEOF_");
    #endif
  }
  else if (_ReadAheadBuffer)
  {
    offset = _ReadAheadPtr - _ReadAheadBuffer;
    newoffset = ShiftArrayPts(1, _StrikeLimit, ReadAheadMoved_, ShowDonePts_);

    if (_PtGapReached && (!_AtGraphEdge || (_AtGraphEnd && (_TerminatedPts || _EOFreached))))
    {
      if (_InfinityPtFound && offset == 1 && newoffset == 2)
      {
        memmove(_FrontPts, _ReadAheadPtr, sizeof(PRIM)*_StrikeLimit);
        _ReadAheadPtr = _ReadAheadBuffer;
        _RdAheadIndex = 0;
        _DataPtsRead = _StrikeLimit;

        if ((_TerminatedPts || _EOFreached) && !_LastScanPending)
        {
          DataCeiling_ = _RdBufferSize - _TerminatedPts;
          _LastScanPending = (_TerminatedPts || _EOFreached) && (_DataPtsRead + newoffset) >= DataCeiling_;

          if (_LastScanPending)
          {
            _OverFlowedPts = _TransferDone ? _TransferPts:0;
            _OverFlowedPts += (_DataPtsRead + newoffset) - DataCeiling_;
            _OverFlowedPtsMoved = _OverFlowedPts > 0;

            if (_OverFlowedPts >= _StrikeLimit)
              _OverFlowedPts = _StrikeLimit - 1;
            else if (!_OverFlowedPtsMoved)
              _OverFlowedPts = 0;
          }
        }
      }
      else if (offset == 0 && newoffset == 1)
      {
        memmove(_FrontPts, _ReadAheadPtr, sizeof(PRIM)*_StrikeLimit);
        _ReadAheadBuffer[0] = _ReadAheadBuffer[_StrikeLimit+1];
        _ReadAheadPtr = &_ReadAheadBuffer[1];
        _RdAheadIndex = 1;
        _DataPtsRead = _StrikeLimit;

        if ((_TerminatedPts || _EOFreached) && !_LastScanPending)
        {
          DataCeiling_ = _RdBufferSize - _TerminatedPts;
          _LastScanPending = (_TerminatedPts || _EOFreached) && (_DataPtsRead + newoffset) >= DataCeiling_;

          if (_LastScanPending)
          {
            _OverFlowedPts = _TransferDone ? _TransferPts:0;
            _OverFlowedPts = (_DataPtsRead + newoffset) - DataCeiling_;
            _OverFlowedPtsMoved = _OverFlowedPts > 0;

            if (_OverFlowedPts >= _StrikeLimit)
              _OverFlowedPts = _StrikeLimit - 1;
            else if (!_OverFlowedPtsMoved)
              _OverFlowedPts = 0;
          }
        }
      }
    }
    else
    {
      // transfer points from read ahead buffer to the front pts array
      // move remaining untransferred pts in the read ahead buffer to the start of the buffer
      memmove(_FrontPts, _ReadAheadBuffer, sizeof(PRIM)*_StrikeLimit);
      _ReadAheadBuffer[0] = _ReadAheadBuffer[_StrikeLimit];
      _ReadAheadBuffer[1] = _ReadAheadBuffer[_StrikeLimit+1];
      _ReadAheadPtr = &_ReadAheadBuffer[2];
      _RdAheadIndex = 2;
      _DataPtsRead = _StrikeLimit;

      if ((_TerminatedPts || _EOFreached) && !_LastScanPending)
      {
        DataCeiling_ = _RdBufferSize - _TerminatedPts;
        _LastScanPending = (_TerminatedPts || _EOFreached) && (_DataPtsRead + newoffset) >= DataCeiling_;

        if (_LastScanPending)
        {
          _OverFlowedPts = _TransferDone ? _TransferPts:0;
          _OverFlowedPts = (_DataPtsRead + newoffset) - DataCeiling_;
          _OverFlowedPtsMoved = _OverFlowedPts > 0;

          if (_OverFlowedPts >= _StrikeLimit)
            _OverFlowedPts = _StrikeLimit - 1;
          else if (!_OverFlowedPtsMoved)
            _OverFlowedPts = 0;
        }
      }
    }

    FrontPtsShifted_ = true;
    _FrontPts[_StrikeLimit] = 0;

    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(offset, "offset");
      DbgPtr()->ShowInt(FrontPtsShifted_, "FrontPtsShifted_");
      DbgPtr()->ShowInt(_StrikeLimit, "_StrikeLimit");
      DbgPtr()->ShowInt(_RdBufferSize, "_RdBufferSize");
      DbgPtr()->ShowInt(_InfinityPtFound, "_InfinityPtFound");
      DbgPtr()->ShowFloat(*_InfinityPt, "*_InfinityPt");
      DbgPtr()->ShowInt(_OverFlowedPts, "_OverflowedPts");
    #endif
  }

  if (!IndexNotAtMax_)
  {
    _TransferDone = false;
    _TransferPts = 0;
  }

  _BackDiscontinuityIndex = 0;
  _FrontDiscontinuityIndex = 0;

  _BackStrikes = 0;
  _FrontStrikes = 0;

  _ScanningDiscontinuity = false;
  _DiscontinuityNotFound = true;
  _DiscontinuityFound = false;
  _SingleDiscAtEdge = false;

  _ScanningNegToPosInfinity = false;
  _ScanningPosToNegInfinity = false;
  _ScanProcessDone = false;

  _NegToPosInfinityFound = false;
  _PosToNegInfinityFound = false;

  if (ResetEOF_)
    _EOFreached = false;

  if (!_GraphPtsBuffer)
  {
    _GraphPtsBuffer = new PRIM[_PtBufferSize];
    memset(_GraphPtsBuffer, 0, sizeof(PRIM)*_PtBufferSize);
    _GraphPtsNotRead = true;

    _BackPts = _GraphPtsBuffer;
    _FrontPts = &_GraphPtsBuffer[_StrikeLimit];
    _InfinityPt = _FrontPts;
    _GraphPtsPtr = _GraphPtsBuffer;
    _FrontPtsShifted = false;

    RemainToRead_ += _PtBufferSize - 1;
    _GraphPtsIndex = 0;
  }
  else
    _GraphPtsNotRead = false;

  if (!_ReadAheadBuffer)
  {
    _ReadAheadBuffer = new PRIM[_RdBufferSize];
    memset(_ReadAheadBuffer, 0, sizeof(PRIM)*_RdBufferSize);
    _RdAheadPtsNotRead = true;

    _ReadAheadPtr = _ReadAheadBuffer;

    RemainToRead_ += _RdBufferSize;
    _RdAheadIndex = 0;
  }
  else if (FrontPtsShifted_)
  {
    if (_PtGapReached && (!_AtGraphEdge || (_AtGraphEnd && (_TerminatedPts || _EOFreached))))
    {
      if (_InfinityPtFound && _ReadAheadPtr == _ReadAheadBuffer && offset == 1 && newoffset == 2)
      {
        memset(_ReadAheadPtr, 0, sizeof(PRIM)*_RdBufferSize);
        _RdAheadIndex = 0;
        _RdAheadPtsNotRead = true;
        RemainToRead_ += _RdBufferSize;
      }
      else if (_ReadAheadPtr == &_ReadAheadBuffer[1] && offset == 0 && newoffset == 1)
      {
        memset(_ReadAheadPtr, 0, sizeof(PRIM)*(_RdBufferSize-1));
        _RdAheadIndex = 1;
        _RdAheadPtsNotRead = true;
        RemainToRead_ += _StrikeLimit+1;
      }
    }
    else if (_ReadAheadPtr == &_ReadAheadBuffer[2])
    {
      memset(_ReadAheadPtr, 0, sizeof(PRIM)*(_RdBufferSize-2));
      _RdAheadIndex = 2;
      _RdAheadPtsNotRead = true;
      RemainToRead_ += _StrikeLimit;
    }
  }
  else
    _RdAheadPtsNotRead = false;

  _PtGapReached = false;
  _InfinityPtFound = false;
  _DiscontinuityCond = NO_POINTGAP_FOUND;
  _ReadNextPts = !_EOFreached && RemainToRead_ > 0;
  _ReadMorePts = _ReadNextPts ? RemainToRead_:0;

  if (_LastScanPending && _ReadMorePts)
    TerminateReadAheadBuffer();

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
    DbgPtr()->ShowInt(_GraphPtsIndex, "_GraphPtsIndex");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
    DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");
    DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
    DbgPtr()->ShowInt(RemainToRead_, "RemainToRead_");

    DbgPtr()->LeaveLevel();
  #endif

  return true;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DoScan()
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("DoScan()");
  #endif

  if (_LastScanDone)
  {
    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_DataRetrieved, "_DataRetrieved");
      DbgPtr()->ShowInt(_LastScanPending, "_LastScanPending");
      DbgPtr()->ShowInt(_LastScanDone, "_LastScanDone");
      DbgPtr()->LeaveLevel();
    #endif
    return false;
  }

  PRIM ptgapval_ = 0;

  int x;
  int discpt_ = 0;
  int newdiscpt_ = 0;
  int max = _PtBufferSize - 1;
  int ovflmax = 0;
  int GraphMidPt_ = _StrikeLimit - 1;
  int PtStrikes_ = 0;
  int direction_ = 0;
  int prevdir_ = 0;
  int flatval_ = 0;
  int incval_ = 0;
  int decval_ = 0;
  int ptgapabsival_ = 0;
  int nextgapabsival_ = 0;
  int ptgapmargin_ = 0;

  // pt. shift anticipating calling method: ShiftArrayPts(0, discpt_...); from method DoScan()
  int PendingPtsShift_ = _InfinityPtFound ? 1:0;

  bool done_ = false;
  bool signchange_ = false;
  bool discptfound_ = false;
  bool FindTrendPts_ = false;
  bool PosToNegDiscPtsFound_ = false;
  bool NegToPosDiscPtsFound_ = false;
  bool ReadAheadMoved_ = false;
  bool DiscConfirmed_ = false;
  bool SingleDisc_ = false;

  #if ((DISCONTDETECT_SHOWDEBUGINFO) & (!(DISCONTDETECT_TESTNOTIFIERS)))
    bool ShowDonePts_ = true;
  #else
    bool ShowDonePts_ = false;
  #endif // DISCONTDETECT_SHOWDEBUGINFO

  _FrontPtsShifted = ReadAheadMoved_;
  _DiscontinuityCond = NO_POINTGAP_FOUND;

  if (ReadyForScan())
  {
    _ScanNumber++;

    // pt. shift anticipating calling method: ShiftArrayPts(1, _StrikeLimit...); from ResetScan()
    PendingPtsShift_ += ((_TerminatedPts || _EOFreached) && _RdAheadIndex > 0) ? 1:0;

    for (x = 1; x < max; x++)
    {
      ptgapval_ = ::fabs(_GraphPtsBuffer[x] - _GraphPtsBuffer[x-1]);
      prevdir_ = direction_;
      direction_ = (_GraphPtsBuffer[x] > _GraphPtsBuffer[x-1]) ? 1:
                   (_GraphPtsBuffer[x] < _GraphPtsBuffer[x-1]) ? -1:0;
      signchange_ = (prevdir_ < 0 && direction_ > 0) ||
                    (prevdir_ > 0 && direction_ < 0);

      if (signchange_)
        prevdir_ = 0;
      else
        direction_ += prevdir_;

      if (ptgapval_ > _PtGapLimit)
      {
        ptgapabsival_ = ::floor(ptgapval_);

        discpt_ = x;
        discptfound_ = true;
        break;
      }
    }

    if (discptfound_)
    {
      DetermineGraphEdges(PendingPtsShift_);
      newdiscpt_ = FindGreatestDiscontinuity(discpt_, ptgapval_,
                                             signchange_, direction_, incval_, flatval_, decval_);

      if (discpt_ != newdiscpt_ && (!(_AtGraphEnd && _TerminatedPts) || decval_))
      {
        x = discpt_ = newdiscpt_;
        ptgapval_ = ::fabs(_GraphPtsBuffer[x] - _GraphPtsBuffer[x-1]);
        ptgapabsival_ = ::floor(ptgapval_);
      }

      if (!_SingleDiscAtEdge &&
          (_AtGraphStart || _EOFreached ||
           (_LastScanPending && discpt_ <= GraphMidPt_+1) ||
           (_AtGraphEnd && _TerminatedPts && _TransferDone)) &&
          (CheckIfRising(discpt_-1, PtStrikes_) || CheckIfFalling(discpt_-1, PtStrikes_)))
        _SingleDiscAtEdge = true;

      _ScanningDiscontinuity = true;
      _BackDiscontinuityIndex = discpt_ - 1;
      _FrontDiscontinuityIndex = discpt_;
      max = _PtBufferSize - 1;
      _DiscontinuityCond = DISCONTINUITY_FOUND;
      x = discpt_;

      if (!_SingleDiscAtEdge && !_InfinityPtFound && (_EOFreached || discpt_ <= GraphMidPt_+1))
      {
        ptgapval_ = ::fabs(_GraphPtsBuffer[x+1] - _GraphPtsBuffer[x]);
        nextgapabsival_ = ::floor(ptgapval_);
        ptgapmargin_ = ptgapabsival_ - nextgapabsival_;
        _InfinityPtFound = x+1 < max &&
                           ptgapval_ > _PtGapLimit &&
                           (ptgapabsival_ == nextgapabsival_ ||
                            ::labs(ptgapmargin_) <= _InfPtsDisplaceMargin) &&
                           ((_GraphPtsBuffer[x-1] > _GraphPtsBuffer[x] && _GraphPtsBuffer[x] > _GraphPtsBuffer[x+1]) ||
                            (_GraphPtsBuffer[x-1] < _GraphPtsBuffer[x] && _GraphPtsBuffer[x] < _GraphPtsBuffer[x+1]));

        // pt. shift anticipating calling method: ShiftArrayPts(0, discpt_...); from method DoScan()
        PendingPtsShift_ += _InfinityPtFound ? 1:0;
      }

      DetermineGraphEdges(PendingPtsShift_);

      if (_InfinityPtFound)
      {
        _InfinityPt = &_GraphPtsBuffer[discpt_];
        _FrontDiscontinuityIndex = discpt_ + 1;
        _DiscontinuityCond = INFINITYPOINT_FOUND;

        if (!_AtGraphEdge || (_AtGraphEnd && (_TerminatedPts || _EOFreached)))
        {
          _FrontPts = _InfinityPt + 1;
          ShiftArrayPts(0, discpt_, ReadAheadMoved_, false);
        }
      }

      #if DISCONTDETECT_DEBUG1
        DbgPtr()->ShowInt(discpt_, "discpt_");
        DbgPtr()->ShowInt(_BackDiscontinuityIndex, "_BackDiscontinuityIndex");
        DbgPtr()->ShowInt(_FrontDiscontinuityIndex, "_FrontDiscontinuityIndex");
        DbgPtr()->ShowInt(_InfinityPtFound, "_InfinityPtFound");
      #endif

      if (_InfinityPtFound)
      {
        _ReadMorePts = 0;
        _PtGapReached = true;
        FindTrendPts_ = false;
        _ScanningDiscontinuity = false;

        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("_InfinityPtFound == true\n");
        #endif
      }

      if (_BackDiscontinuityIndex <= GraphMidPt_)
      {
        _ReadMorePts = 0;
        _PtGapReached = true;
        FindTrendPts_ = !_AtGraphEdge && _BackDiscontinuityIndex == GraphMidPt_ &&
                        _InfinityPt == &_GraphPtsBuffer[_StrikeLimit] && _RdAheadIndex > 0;
        _ScanningDiscontinuity = FindTrendPts_;

        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("_BackDiscontinuityIndex <= GraphMidPt_\n");
          DbgPtr()->ShowInt(FindTrendPts_, "FindTrendPts_");
        #endif
      }
      else if (_BackDiscontinuityIndex > GraphMidPt_)
      {
        _ReadMorePts = (_EOFreached ||
                        (_AtGraphEnd && _TerminatedPts == 0)) ? 0:(_BackDiscontinuityIndex - GraphMidPt_);
        _ScanningDiscontinuity = false;
        FindTrendPts_ = false;

        if (!_ReadMorePts && (_EOFreached || (_AtGraphEnd && _TerminatedPts == 0)))
          _PtGapReached = true;

        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("_BackDiscontinuityIndex > GraphMidPt_\n");
          DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
          DbgPtr()->ShowInt(_PtGapReached, "_PtGapReached");
        #endif
      }

      if (_ReadMorePts && _RdAheadIndex >= _ReadMorePts &&
          !_TransferDone && GraphPtsBufferFilled() && ReadAheadBufferFilled())
      {
        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("Called: TransferFromReadAheadBuffer(_ReadMorePts, ShowDonePts_);\n");
          DbgPtr()->ShowMessage("return DoScan();\n");
        #endif

        if (_InfinityPtFound)
          ShiftArrayPts(-1, discpt_, ReadAheadMoved_, false);

        TransferFromReadAheadBuffer(_ReadMorePts, ShowDonePts_);

        _ReadNextPts = false;
        _ReadMorePts = 0;
        _PtGapReached = false;

        return DoScan();
      }
      else if (FindTrendPts_)
      {
        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("Called: FindTrendsToInfinity();\n");
        #endif

        FindTrendsToInfinity();
        done_ = true;
      }
      else if (_PtGapReached)
      {
        // Finding trend points not possible
        _BackStrikes = 0;
        _FrontStrikes = 0;
        done_ = true;

        PosToNegDiscPtsFound_ = _AtGraphEdge &&
                                _GraphPtsBuffer[_BackDiscontinuityIndex] > _GraphPtsBuffer[_FrontDiscontinuityIndex] &&
                                _GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[_FrontDiscontinuityIndex] > _PtGapLimit;
        NegToPosDiscPtsFound_ = _AtGraphEdge &&
                                _GraphPtsBuffer[_FrontDiscontinuityIndex] > _GraphPtsBuffer[_BackDiscontinuityIndex] &&
                                _GraphPtsBuffer[_FrontDiscontinuityIndex] - _GraphPtsBuffer[_BackDiscontinuityIndex] > _PtGapLimit;

        #if DISCONTDETECT_DEBUG1
          DbgPtr()->ShowMessage("_PtGapReached == true\n");
          DbgPtr()->ShowInt(_PosToNegInfinityFound, "_PosToNegInfinityFound");
          DbgPtr()->ShowInt(_NegToPosInfinityFound, "_NegToPosInfinityFound");
        #endif

        if (PosToNegDiscPtsFound_)
        {
          DiscConfirmed_ = ConfirmDiscontinuity(PosToNegDiscPtsFound_, false, true, &SingleDisc_);

          if (SingleDisc_)
          {
            if (_AtGraphEnd && (_TerminatedPts || _EOFreached))
            {
              if (_InfinityPtFound)
                ShiftArrayPts(-1, discpt_, ReadAheadMoved_, false);

              max = _PtBufferSize-1;
              ovflmax = max - _OverFlowedPts;
              _FrontDiscontinuityIndex = _BackDiscontinuityIndex = --ovflmax;
              _InfinityPt = &_GraphPtsBuffer[ovflmax];
              _FrontStrikes = PtStrikes_;
            }
            else if (_AtGraphStart)
            {
              _FrontDiscontinuityIndex = _BackDiscontinuityIndex;
              _InfinityPt = &_GraphPtsBuffer[_BackDiscontinuityIndex];
              _BackStrikes = PtStrikes_;
            }

            _PosToNegInfinityFound =
            _DiscontinuityFound = true;
            _DiscontinuityNotFound = !_DiscontinuityFound;
            _SingleDiscAtEdge = true;
            _ScanProcessDone = true;
            _ScanningNegToPosInfinity = false;
            _ScanningPosToNegInfinity = false;
          }
          else if (DiscConfirmed_)
          {
            _PosToNegInfinityFound =
            _DiscontinuityFound = true;
            _DiscontinuityNotFound = !_DiscontinuityFound;
            _SingleDiscAtEdge = false;
            _ScanProcessDone = true;
            _ScanningNegToPosInfinity = false;
            _ScanningPosToNegInfinity = false;
          }
          else
            SetDiscontinuityNotFound();
        }
        else if (NegToPosDiscPtsFound_)
        {
          DiscConfirmed_ = ConfirmDiscontinuity(false, NegToPosDiscPtsFound_, true, &SingleDisc_);

          if (SingleDisc_)
          {
            if (_AtGraphEnd && (_TerminatedPts || _EOFreached))
            {
              if (_InfinityPtFound)
                ShiftArrayPts(-1, discpt_, ReadAheadMoved_, false);

              max = _PtBufferSize-1;
              ovflmax = max - _OverFlowedPts;
              _FrontDiscontinuityIndex = _BackDiscontinuityIndex = --ovflmax;
              _InfinityPt = &_GraphPtsBuffer[ovflmax];
              _FrontStrikes = PtStrikes_;
            }
            else if (_AtGraphStart)
            {
              _FrontDiscontinuityIndex = _BackDiscontinuityIndex;
              _InfinityPt = &_GraphPtsBuffer[_BackDiscontinuityIndex];
              _BackStrikes = PtStrikes_;
            }

            _NegToPosInfinityFound =
            _DiscontinuityFound = true;
            _DiscontinuityNotFound = !_DiscontinuityFound;
            _SingleDiscAtEdge = true;
            _ScanProcessDone = true;
            _ScanningNegToPosInfinity = false;
            _ScanningPosToNegInfinity = false;
          }
          else if (DiscConfirmed_)
          {
            _NegToPosInfinityFound =
            _DiscontinuityFound = true;
            _DiscontinuityNotFound = !_DiscontinuityFound;
            _SingleDiscAtEdge = false;
            _ScanProcessDone = true;
            _ScanningNegToPosInfinity = false;
            _ScanningPosToNegInfinity = false;
          }
          else
            SetDiscontinuityNotFound();
        }
      }
      else
      {
        SetDiscontinuityNotFound();
        done_ = true;
      }
    }
    else
    {
      SetDiscontinuityNotFound();
      done_ = true;
    }
  }

  if (_LastScanPending && done_)
    _LastScanDone = true;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowMessage("/****************************************************************************/\n");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
    DbgPtr()->ShowInt(_PtGapReached, "_PtGapReached");
    DbgPtr()->ShowInt(FindTrendPts_, "FindTrendPts_");
    DbgPtr()->ShowInt(_PosToNegInfinityFound, "_PosToNegInfinityFound");
    DbgPtr()->ShowInt(_NegToPosInfinityFound, "_NegToPosInfinityFound");
    DbgPtr()->ShowInt(_DiscontinuityFound, "_DiscontinuityFound");
    DbgPtr()->ShowInt(_DiscontinuityNotFound, "_DiscontinuityNotFound");
    DbgPtr()->ShowInt(_ScanProcessDone, "_ScanProcessDone");
    DbgPtr()->ShowInt(_ScanningDiscontinuity, "_ScanningDiscontinuity");
    DbgPtr()->ShowInt(_ScanningNegToPosInfinity, "_ScanningNegToPosInfinity");
    DbgPtr()->ShowInt(_ScanningPosToNegInfinity, "_ScanningPosToNegInfinity");
    DbgPtr()->ShowInt(_DataRetrieved, "_DataRetrieved");
    DbgPtr()->ShowInt(_LastScanPending, "_LastScanPending");
    DbgPtr()->ShowInt(_LastScanDone, "_LastScanDone");

    DbgPtr()->LeaveLevel();
  #endif

  return done_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::FindTrendsToInfinity()
{
  if (!_PtGapReached || _AtGraphEdge)
    return;

  int x;
  int max = _StrikeLimit;

  bool PosToNegDiscPtsFound_ = false;
  bool NegToPosDiscPtsFound_ = false;
  bool gapdone_ = false;
  bool fail_ = false;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("FindTrendsToInfinity()");
  #endif

  // testing neg. to pos. infinity
  _ScanningNegToPosInfinity = true;
  _BackStrikes = 0;
  _FrontStrikes = 0;

  gapdone_ = _BackPts[max-1] < _FrontPts[0];
  NegToPosDiscPtsFound_ = gapdone_ && _FrontPts[0] - _BackPts[max-1] > _PtGapLimit;

  if (gapdone_)
  {
    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowMessage("_ScanningNegToPosInfinity == true\n");
      DbgPtr()->ShowMessage("gapdone_ == true\n");
    #endif

     for (x = 1; x < max; x++)
       if (_BackPts[x-1] > _BackPts[x])
         _BackStrikes++;
       else
         fail_ = true;
  }

  if (!fail_ && gapdone_)
  {
    _BackStrikes++;

    for (x = 1; x < max; x++)
      if (_FrontPts[x-1] > _FrontPts[x])
        _FrontStrikes++;
      else
        fail_ = true;
  }
  else
    fail_ = true;

  if (fail_)
  {
    // testing pos. to neg. infinity
    _ScanningNegToPosInfinity = false;
    _ScanningPosToNegInfinity = true;
    _BackStrikes = 0;
    _FrontStrikes = 0;
    fail_ = false;

    gapdone_ = _BackPts[max-1] > _FrontPts[0];
    PosToNegDiscPtsFound_ = gapdone_ && _BackPts[max-1] - _FrontPts[0] > _PtGapLimit;

    if (!fail_ && gapdone_)
    {
      #if DISCONTDETECT_DEBUG1
        DbgPtr()->ShowMessage("_ScanningPosToNegInfinity == true\n");
        DbgPtr()->ShowMessage("gapdone_ == true\n");
      #endif

      for (x = 1; x < max; x++)
        if (_BackPts[x-1] < _BackPts[x])
          _BackStrikes++;
        else
          fail_ = true;
    }
    else
      fail_ = true;

    if (!fail_ && gapdone_)
    {
      _BackStrikes++;

      for (x = 1; x < max; x++)
        if (_FrontPts[x-1] < _FrontPts[x])
          _FrontStrikes++;
        else
          fail_ = true;
    }
    else
      fail_ = true;

    if (!fail_)
    {
      _FrontStrikes++;
      _PosToNegInfinityFound =
      _DiscontinuityFound =  PosToNegDiscPtsFound_ &&
                             _BackStrikes == _StrikeLimit && _FrontStrikes == _StrikeLimit;
      _DiscontinuityNotFound = !_DiscontinuityFound;
      _ScanProcessDone = true;
      _ScanningPosToNegInfinity = false;

      if (_PosToNegInfinityFound &&
          !ConfirmDiscontinuity(_PosToNegInfinityFound, false, _AtGraphEdge, &_SingleDiscAtEdge))
        SetDiscontinuityNotFound();
    }
    else
    {
      _NegToPosInfinityFound =
      _PosToNegInfinityFound =
      _DiscontinuityFound = false;
      _DiscontinuityNotFound = true;
      _ScanProcessDone = true;
      _ScanningPosToNegInfinity = false;
    }
  }
  else
  {
    _FrontStrikes++;
    _NegToPosInfinityFound =
    _DiscontinuityFound = NegToPosDiscPtsFound_ &&
                          _BackStrikes == _StrikeLimit && _FrontStrikes == _StrikeLimit;
    _DiscontinuityNotFound = !_DiscontinuityFound;
    _ScanProcessDone = true;
    _ScanningNegToPosInfinity = false;

    if (_NegToPosInfinityFound &&
        !ConfirmDiscontinuity(false, _NegToPosInfinityFound, _AtGraphEdge, &_SingleDiscAtEdge))
      SetDiscontinuityNotFound();
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(NegToPosDiscPtsFound_, "NegToPosDiscPtsFound_");
    DbgPtr()->ShowInt(PosToNegDiscPtsFound_, "PosToNegDiscPtsFound_");
    DbgPtr()->ShowInt(_DiscontinuityFound, "_DiscontinuityFound");
    DbgPtr()->ShowInt(_DiscontinuityNotFound, "_DiscontinuityNotFound");
    DbgPtr()->ShowInt(_BackStrikes, "_BackStrikes");
    DbgPtr()->ShowInt(_FrontStrikes, "_FrontStrikes");

    DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::CheckIfFalling(int Index_, int& PtStrikes_)
{
  int ptdiff_ = _GraphPtsBuffer[Index_] - _GraphPtsBuffer[Index_+1];
  int ptcnt_ = (ptdiff_ > _PtGapLimit) ? 1:0;

  int x;
  int max = (_InfinityPtFound && _FrontPtsShifted) ? _PtBufferSize:(_PtBufferSize-1);
  int ovflmax = max - _OverFlowedPts;
  int dist_ = ptdiff_;
  int nextdist_ = 0;

  bool PtValid_ = ptdiff_ && ptcnt_ && Index_+1 < max;
  bool PastOverFlow_ = false;

  if (PtValid_)
  {
    --max;
    --ovflmax;
    PtStrikes_ = 1;

    if (_AtGraphStart)
    {
      // sloping downward, concave up coming from +inf pt.
      for (x = Index_+1; x < max && PtStrikes_ < _StrikeLimit; x++)
      {
        nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
        PtValid_ = dist_ > nextdist_ ||
                   (PastOverFlow_ = (_OverFlowedPtsMoved ? (x >= ovflmax && nextdist_ == 0):false));

        if (PtValid_)
        {
          ++PtStrikes_;

          if (!PastOverFlow_)
            dist_ = nextdist_;
        }
        else
          break;
      }
    }
    else if (_AtGraphEnd)
    {
      // sloping downward, concave down going to -inf pt.
      for (x = Index_+1; x < max && PtStrikes_ < _StrikeLimit; x++)
      {
        nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
        PtValid_ = dist_ < nextdist_ ||
                   (PastOverFlow_ = (_OverFlowedPtsMoved ? (x >= ovflmax && nextdist_ == 0):false));

        if (PtValid_)
        {
          ++PtStrikes_;

          if (!PastOverFlow_)
            dist_ = nextdist_;
        }
        else
          break;
      }
    }
  }

  return PtValid_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::CheckIfRising(int Index_, int& PtStrikes_)
{
  int ptdiff_ = _GraphPtsBuffer[Index_+1] - _GraphPtsBuffer[Index_];
  int ptcnt_ = (ptdiff_ > _PtGapLimit) ? 1:0;

  int x;
  int max = (_InfinityPtFound && _FrontPtsShifted) ? _PtBufferSize:(_PtBufferSize-1);
  int ovflmax = max - _OverFlowedPts;
  int dist_ = ptdiff_;
  int nextdist_ = 0;

  bool PtValid_ = ptdiff_ && ptcnt_ && Index_+1 < max;
  bool PastOverFlow_ = false;

  if (PtValid_)
  {
    --max;
    --ovflmax;
    PtStrikes_ = 1;

    if (_AtGraphStart)
    {
      // sloping upward, concave down coming from -inf pt.
      for (x = Index_+1; x < max && PtStrikes_ < _StrikeLimit; x++)
      {
        nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
        PtValid_ = dist_ > nextdist_ ||
                   (PastOverFlow_ = (_OverFlowedPtsMoved ? (x >= ovflmax && nextdist_ == 0):false));

        if (PtValid_)
        {
          ++PtStrikes_;

          if (!PastOverFlow_)
            dist_ = nextdist_;
        }
        else
          break;
      }
    }
    else if (_AtGraphEnd)
    {
      // sloping upward, concave up going to +inf pt.
      for (x = Index_+1; x < max && PtStrikes_ < _StrikeLimit; x++)
      {
        nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
        PtValid_ = dist_ < nextdist_ ||
                   (PastOverFlow_ = (_OverFlowedPtsMoved ? (x >= ovflmax && nextdist_ == 0):false));

        if (PtValid_)
        {
          ++PtStrikes_;

          if (!PastOverFlow_)
            dist_ = nextdist_;
        }
        else
          break;
      }
    }
  }

  return PtValid_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ConfirmDiscontinuity(bool PosToNegDiscPtsFound_, bool NegToPosDiscPtsFound_,
                                                                  bool SingleDiscOptional_, bool* SingleDisc_)
{
  int frontindex_ = _InfinityPtFound ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
  int ptdiff_ = PosToNegDiscPtsFound_ ? (_GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[frontindex_]):
                NegToPosDiscPtsFound_ ? (_GraphPtsBuffer[frontindex_] - _GraphPtsBuffer[_BackDiscontinuityIndex]):0;
  int ptcnt_ = (ptdiff_ > _PtGapLimit) ? 1:0;
  int dist_ = 0;
  int nextdist_ = 0;
  int max = 0;
  int cntmax = 0;
  int cntovflmax = 0;
  int cnt = 0;
  int x;

  // are the graph points increasing or decreasing to +/- infinity or are the points on the same line?
  bool PtValid_ = false;
  bool DiscFound_ = false;
  bool PtShifted_ = _InfinityPtFound && _FrontPtsShifted &&
                    _FrontPts == _InfinityPt + 1;

  if (ptdiff_ && ptcnt_)
  {
    if (_AtGraphStart)
    {
      if (PosToNegDiscPtsFound_)
      {
        // sloping downward, concave up coming from +inf pt.: \_
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be lesser in displacement
        // _GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[_FrontDiscontinuityIndex] >
        //     _GraphPtsBuffer[_FrontDiscontinuityIndex] - _GraphPtsBuffer[_FrontDiscontinuityIndex+1]
        //
        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = frontindex_+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[frontindex_];
        PtValid_ = frontindex_ < max;

        for (x = frontindex_; x < max; x++)
        {
          nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
          PtValid_ = dist_ > nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else
            break;
        }

        DiscFound_ = SingleDiscOptional_ ? (ptdiff_ && ptcnt_):PtValid_;

        if (PtValid_ && SingleDisc_)
          *SingleDisc_ = true;
      }
      else if (NegToPosDiscPtsFound_)
      {
        // sloping upward, concave down coming from -inf pt.: /-
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be lesser in displacement
        // _GraphPtsBuffer[_FrontDiscontinuityIndex] - _GraphPtsBuffer[_BackDiscontinuityIndex] >
        //     _GraphPtsBuffer[_FrontDiscontinuityIndex+1] - _GraphPtsBuffer[_FrontDiscontinuityIndex]
        //
        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = frontindex_+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[frontindex_] - _GraphPtsBuffer[_BackDiscontinuityIndex];
        PtValid_ = frontindex_ < max;

        for (x = frontindex_; x < max; x++)
        {
          nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
          PtValid_ = dist_ > nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else
            break;
        }

        DiscFound_ = SingleDiscOptional_ ? (ptdiff_ && ptcnt_):PtValid_;

        if (PtValid_ && SingleDisc_)
          *SingleDisc_ = true;
      }
    }
    else if (_AtGraphEnd)
    {
      if (NegToPosDiscPtsFound_)
      {
        // sloping upward, concave up going to +inf pt.: _/
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be greater in displacement
        // _GraphPtsBuffer[_FrontDiscontinuityIndex] - _GraphPtsBuffer[_BackDiscontinuityIndex] <
        //     _GraphPtsBuffer[_FrontDiscontinuityIndex+1] - _GraphPtsBuffer[_FrontDiscontinuityIndex]
        //
        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = frontindex_+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[frontindex_] - _GraphPtsBuffer[_BackDiscontinuityIndex];
        PtValid_ = frontindex_ < max;

        cnt = 0;
        cntmax = _StrikeLimit-1;
        cntovflmax = (_OverFlowedPts && _OverFlowedPtsMoved) ? (_StrikeLimit-_OverFlowedPts-1):0;

        if (cntovflmax < 0)
          cntovflmax = 0;

        for (x = frontindex_; x < max; x++, cnt++)
        {
          nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
          PtValid_ = dist_ < nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else if (cntovflmax && (&_GraphPtsBuffer[x] == &_FrontPts[cnt]))
          {
            PtValid_ = nextdist_ == 0 && (cntovflmax <= cnt && cnt < cntmax);

            if (PtValid_)
              dist_ = nextdist_;
            else
              break;
          }
          else
            break;
        }

        DiscFound_ = SingleDiscOptional_ ? (ptdiff_ && ptcnt_):PtValid_;

        if (PtValid_ && SingleDisc_)
          *SingleDisc_ = true;
      }
      else if (PosToNegDiscPtsFound_)
      {
        // sloping downward, concave down going to -inf pt.: -\
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be greater in displacement
        // _GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[_FrontDiscontinuityIndex] <
        //     _GraphPtsBuffer[_FrontDiscontinuityIndex] - _GraphPtsBuffer[_FrontDiscontinuityIndex+1]
        //
        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = frontindex_+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[_BackDiscontinuityIndex] - _GraphPtsBuffer[frontindex_];
        PtValid_ = frontindex_ < max;

        cnt = 0;
        cntmax = _StrikeLimit-1;
        cntovflmax = (_OverFlowedPts && _OverFlowedPtsMoved) ? (_StrikeLimit-_OverFlowedPts-1):0;

        if (cntovflmax < 0)
          cntovflmax = 0;

        for (x = frontindex_; x < max; x++, cnt++)
        {
          nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
          PtValid_ = dist_ < nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else if (cntovflmax && (&_GraphPtsBuffer[x] == &_FrontPts[cnt]))
          {
            PtValid_ = nextdist_ == 0 && (cntovflmax <= cnt && cnt < cntmax);

            if (PtValid_)
              dist_ = nextdist_;
            else
              break;
          }
          else
            break;
        }

        DiscFound_ = SingleDiscOptional_ ? (ptdiff_ && ptcnt_):PtValid_;

        if (PtValid_ && SingleDisc_)
          *SingleDisc_ = true;
      }
    }
    else if (!_AtGraphEdge)
    {
      if (PosToNegDiscPtsFound_)
      {
        // _GraphPtsBuffer[0 ... _BackDiscontinuityIndex]
        // each successive pt. from _GraphPtsBuffer[0] will be greater in displacement
        //     sloping upward, concave up going to +inf pt.: _/
        // if _InfinityPtFound then _GraphPtsBuffer[_BackDiscontinuityIndex] - *_InfinityPt > 0
        // _GraphPtsBuffer[_FrontDiscontinuityIndex ... _FrontDiscontinuityIndex+_StrikeLimit-1]
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be lesser in displacement
        //     sloping upward, concave down coming from -inf pt.: /-
        // if _InfinityPtFound then *_InfinityPt - _GraphPtsBuffer[_FrontDiscontinuityIndex] > 0
        //
        max = _BackDiscontinuityIndex;
        dist_ = _GraphPtsBuffer[1] - _GraphPtsBuffer[0];
        PtValid_ = 1 < max;

        for (x = 1; x < max; x++)
        {
          nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
          PtValid_ = dist_ < nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else
            break;
        }

        DiscFound_ = (_InfinityPtFound && _InfinityPt) ?
                           (PtValid_ && _GraphPtsBuffer[_BackDiscontinuityIndex] - *_InfinityPt > 0):
                           PtValid_;

        if (!DiscFound_)
        {
          if (SingleDisc_)
            *SingleDisc_ = false;
          return false;
        }

        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = _FrontDiscontinuityIndex+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[frontindex_] - _GraphPtsBuffer[frontindex_+1];
        PtValid_ = (PtShifted_ && _InfinityPt) ?
                         (dist_ > 0 && frontindex_+2 < max):
                         (frontindex_+1 < max);

        if (PtShifted_)
          ++frontindex_;

        cnt = 0;
        cntmax = _StrikeLimit-1;
        cntovflmax = (_OverFlowedPts && _OverFlowedPtsMoved) ? (_StrikeLimit-_OverFlowedPts-1):0;
        dist_ = _GraphPtsBuffer[frontindex_+1] - _GraphPtsBuffer[frontindex_];

        for (x = frontindex_+1; x < max; x++, cnt++)
        {
          nextdist_ = _GraphPtsBuffer[x+1] - _GraphPtsBuffer[x];
          PtValid_ = dist_ > nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else if (cntovflmax && (&_GraphPtsBuffer[x] == &_FrontPts[cnt]))
          {
            PtValid_ = nextdist_ == 0 && (cntovflmax <= cnt && cnt < cntmax);

            if (PtValid_)
              dist_ = nextdist_;
            else
              break;
          }
          else
            break;
        }

        DiscFound_ = PtValid_;

        if (SingleDisc_)
          *SingleDisc_ = false;
      }
      else if (NegToPosDiscPtsFound_)
      {
        // _GraphPtsBuffer[0 ... _BackDiscontinuityIndex]
        // each successive pt. from _GraphPtsBuffer[0] will be greater in displacement
        //     sloping downward, concave down going to -inf pt.: -\
        // if _InfinityPtFound then *_InfinityPt - _GraphPtsBuffer[_BackDiscontinuityIndex] > 0
        // _GraphPtsBuffer[_FrontDiscontinuityIndex ... _FrontDiscontinuityIndex+_StrikeLimit-1]
        // each successive pt. from _GraphPtsBuffer[_FrontDiscontinuityIndex] will be lesser in displacement
        //     sloping downward, concave up coming from +inf pt.: \_
        // if _InfinityPtFound then _GraphPtsBuffer[_FrontDiscontinuityIndex] - *_InfinityPt > 0
        //
        max = _BackDiscontinuityIndex;
        dist_ = _GraphPtsBuffer[0] - _GraphPtsBuffer[1];
        PtValid_ = 1 < max;

        for (x = 1; x < max; x++)
        {
          nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
          PtValid_ = dist_ < nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else
            break;
        }

        DiscFound_ = (_InfinityPtFound && _InfinityPt) ?
                           (PtValid_ && *_InfinityPt - _GraphPtsBuffer[_BackDiscontinuityIndex] > 0):
                           PtValid_;

        if (!DiscFound_)
        {
          if (SingleDisc_)
            *SingleDisc_ = false;
          return false;
        }

        frontindex_ = PtShifted_ ? (_FrontDiscontinuityIndex-1):_FrontDiscontinuityIndex;
        max = _FrontDiscontinuityIndex+_StrikeLimit-1;

        dist_ = _GraphPtsBuffer[frontindex_+1] - _GraphPtsBuffer[frontindex_];
        PtValid_ = (PtShifted_ && _InfinityPt) ?
                         (dist_ > 0 && frontindex_+2 < max):
                         (frontindex_+1 < max);

        if (PtShifted_)
          ++frontindex_;

        cnt = 0;
        cntmax = _StrikeLimit-1;
        cntovflmax = (_OverFlowedPts && _OverFlowedPtsMoved) ? (_StrikeLimit-_OverFlowedPts-1):0;
        dist_ = _GraphPtsBuffer[frontindex_] - _GraphPtsBuffer[frontindex_+1];

        for (x = frontindex_+1; x < max; x++, cnt++)
        {
          nextdist_ = _GraphPtsBuffer[x] - _GraphPtsBuffer[x+1];
          PtValid_ = dist_ > nextdist_;

          if (PtValid_)
            dist_ = nextdist_;
          else if (cntovflmax && (&_GraphPtsBuffer[x] == &_FrontPts[cnt]))
          {
            PtValid_ = nextdist_ == 0 && (cntovflmax <= cnt && cnt < cntmax);

            if (PtValid_)
              dist_ = nextdist_;
            else
              break;
          }
          else
            break;
        }

        DiscFound_ = PtValid_;

        if (SingleDisc_)
          *SingleDisc_ = false;
      }
    }
  }

  return DiscFound_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::SetDiscontinuityNotFound()
{
  _PosToNegInfinityFound =
  _NegToPosInfinityFound = false;
  _DiscontinuityFound = false;
  _DiscontinuityNotFound = true;
  _SingleDiscAtEdge = false;
  _ScanProcessDone = true;
  _ScanningNegToPosInfinity = false;
  _ScanningPosToNegInfinity = false;

  _AtGraphStart = false;
  _AtGraphEnd = false;
  _AtGraphEdge = false;

  if (_PtGapReached && _GraphPtsBuffer)
  {
    _DataRetrieved = true;

    if (_DataRetrieved && _TransferDone && _TransferPts)
    {
      _ReadMorePts = _RdBufferSize - _RdAheadIndex;
      _ReadNextPts = !_EOFreached && _ReadMorePts > 0;
      _RdAheadPtsNotRead = _ReadMorePts != 0;
      _ScanProcessDone = !_RdAheadPtsNotRead;
    }
  }
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::MarkDiscontinuityPoints(bool Retr_)
{
  PRIM Fval_ = 0;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("MarkDiscontinuityPoints()");
  #endif

  if (_ScanProcessDone && _DiscontinuityFound && _GraphPtsBuffer && _Wrapper)
  {
    Fval_ = _Wrapper->vINFINITY;

    if (_PosToNegInfinityFound)
    {
      if (_SingleDiscAtEdge)
      {
        if (_AtGraphStart)
          _GraphPtsBuffer[_BackDiscontinuityIndex] = Fval_;
        else if (_AtGraphEnd)
          _GraphPtsBuffer[_FrontDiscontinuityIndex] = -Fval_;
      }
      else
      {
        _GraphPtsBuffer[_BackDiscontinuityIndex] = Fval_;
        _GraphPtsBuffer[_FrontDiscontinuityIndex] = -Fval_;
      }
    }
    else if (_NegToPosInfinityFound)
    {
      if (_SingleDiscAtEdge)
      {
        if (_AtGraphStart)
          _GraphPtsBuffer[_BackDiscontinuityIndex] = -Fval_;
        else if (_AtGraphEnd)
          _GraphPtsBuffer[_FrontDiscontinuityIndex] = Fval_;
      }
      else
      {
        _GraphPtsBuffer[_BackDiscontinuityIndex] = -Fval_;
        _GraphPtsBuffer[_FrontDiscontinuityIndex] = Fval_;
      }
    }

    if (_InfinityPtFound && !_SingleDiscAtEdge)
      *_InfinityPt = _Wrapper->vNAN;

    _DataRetrieved = Retr_;

    if (_DataRetrieved && _TransferDone && _TransferPts)
    {
      _ReadMorePts = _RdBufferSize - _RdAheadIndex;
      _ReadNextPts = !_EOFreached && _ReadMorePts > 0;
      _RdAheadPtsNotRead = _ReadMorePts != 0;
      _ScanProcessDone = !_RdAheadPtsNotRead;
    }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(_NegToPosInfinityFound, "_NegToPosInfinityFound");
    DbgPtr()->ShowInt(_PosToNegInfinityFound, "_PosToNegInfinityFound");
    DbgPtr()->ShowInt(_InfinityPtFound, "_InfinityPtFound");
    DbgPtr()->ShowFloat(Fval_, "Fval_");

    DbgPtr()->ShowInt(_DiscontinuityFound, "_DiscontinuityFound");
    DbgPtr()->ShowInt(_ScanProcessDone, "_ScanProcessDone");
    DbgPtr()->ShowInt(_GraphPtsBuffer != NULL, "_GraphPtsBuffer != NULL");
    DbgPtr()->ShowInt(_Wrapper != NULL, "_Wrapper != NULL");

    DbgPtr()->LeaveLevel();
  #endif

    return true;
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(_DiscontinuityFound, "_DiscontinuityFound");
    DbgPtr()->ShowInt(_ScanProcessDone, "_ScanProcessDone");
    DbgPtr()->ShowInt(_GraphPtsBuffer != NULL, "_GraphPtsBuffer != NULL");
    DbgPtr()->ShowInt(_Wrapper != NULL, "_Wrapper != NULL");

    DbgPtr()->LeaveLevel();
  #endif

  return false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ReadyForScan()
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ReadyForScan()");

    DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
    DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
    DbgPtr()->ShowInt(_ScanProcessDone, "_ScanProcessDone");
    DbgPtr()->ShowInt(_ScanningDiscontinuity, "_ScanningDiscontinuity");
    DbgPtr()->ShowInt(_LastScanPending, "_LastScanPending");
    DbgPtr()->ShowInt(_LastScanDone, "_LastScanDone");
    DbgPtr()->ShowInt(_PtGapReached, "_PtGapReached");
    DbgPtr()->ShowInt(_EOFreached, "_EOFreached");

    DbgPtr()->LeaveLevel();
  #endif

  return (
    !_ReadNextPts && _ReadMorePts == 0 &&
    !_GraphPtsNotRead && !_RdAheadPtsNotRead &&
    !_LastScanDone && !_ScanProcessDone &&
    !_ScanningDiscontinuity &&
    !_PtGapReached && !_EOFreached &&
    GraphPtsBufferFilled() && ReadAheadBufferFilled()
  );
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ScanProcessDone()
{
  return _ScanProcessDone;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DiscontinuityFound()
{
  return _DiscontinuityFound;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::DiscontinuityNotFound()
{
  return _DiscontinuityNotFound;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ShouldReadNextPoints()
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ShouldReadNextPoints()");

    DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
    DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
    DbgPtr()->ShowInt(_ScanProcessDone, "_ScanProcessDone");
    DbgPtr()->ShowInt(_EOFreached, "_EOFreached");

    DbgPtr()->LeaveLevel();
  #endif

  return (
    _ReadMorePts && _ReadNextPts &&
    (_GraphPtsNotRead || _RdAheadPtsNotRead) &&
    !_ScanProcessDone && !_EOFreached
  );
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::ReadBufferFull()
{
  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("ReadBufferFull()");

    DbgPtr()->ShowInt(_BackPts != NULL, "_BackPts != NULL");
    DbgPtr()->ShowInt(_FrontPts != NULL, "_FrontPts != NULL");
    DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
    DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
    DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");
    DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");

    DbgPtr()->LeaveLevel();
  #endif

  return (
    _BackPts && _FrontPts &&
    !_GraphPtsNotRead && !_RdAheadPtsNotRead &&
    !_ReadNextPts && _ReadMorePts == 0 &&
    GraphPtsBufferFilled()
  );
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::NegToPosInfinityFound()
{
  return _NegToPosInfinityFound;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::PosToNegInfinityFound()
{
  return _PosToNegInfinityFound;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::SetPointsDoneNotifier(PointsDoneNotifier<PRIM>* Notifier_)
{
  delete _PtsDoneNotifier;
  _PtsDoneNotifier = Notifier_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::SetArrayResetNotifier(ArrayResetNotifier<PRIM>* Notifier_)
{
  delete _ResetNotifier;
  _ResetNotifier = Notifier_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM* GraphDiscontinuityDetector<WRAP, PRIM>::GiveBackPts(bool* Exists_)
{
  if (Exists_)
    *Exists_ = _PtGapReached && _ScanningDiscontinuity &&
               _ScanProcessDone && _DiscontinuityFound;

  return _BackPts;
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM* GraphDiscontinuityDetector<WRAP, PRIM>::GiveFrontPts(bool* Exists_)
{
  if (Exists_)
    *Exists_ = _PtGapReached && _ScanningDiscontinuity &&
               _ScanProcessDone && _DiscontinuityFound;

  return _FrontPts;
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM GraphDiscontinuityDetector<WRAP, PRIM>::GiveBackDiscontinuityPt(bool* Exists_)
{
  if (Exists_)
    *Exists_ = _PtGapReached &&
               _ScanProcessDone && _DiscontinuityFound;

  return (_GraphPtsBuffer ? _GraphPtsBuffer[_BackDiscontinuityIndex]:0);
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM GraphDiscontinuityDetector<WRAP, PRIM>::operator [] (size_t x) const
{
  if (!_GraphPtsBuffer || x >= PointsBufferSize())
    return 0;

  return _GraphPtsBuffer[x];
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM GraphDiscontinuityDetector<WRAP, PRIM>::GiveFrontDiscontinuityPt(bool* Exists_)
{
  if (Exists_)
    *Exists_ = _PtGapReached &&
               _ScanProcessDone && _DiscontinuityFound;

  return (_GraphPtsBuffer ? _GraphPtsBuffer[_FrontDiscontinuityIndex]:0);
}

/****************************************************************************/
template <class WRAP, class PRIM>
PRIM GraphDiscontinuityDetector<WRAP, PRIM>::GiveInfinityPt(bool* Exists_)
{
  if (Exists_)
    *Exists_ = _PtGapReached &&
               _ScanProcessDone && _DiscontinuityFound;

  return ((_GraphPtsBuffer && _InfinityPt) ? *_InfinityPt:0);
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::StoreNextPoints(int numpts_, PRIM* fptv_, int* ptsread_)
{
  int x = 0;
  int PtBufMax_ = _PtBufferSize - 1;
  bool IndexNotAtMax_ = _RdAheadIndex < _RdBufferSize;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("StoreNextPoints(int, PRIM*)");
  #endif

  if (_ReadNextPts && _ReadMorePts > 0)
  {
    if (_GraphPtsBuffer && _GraphPtsNotRead && !GraphPtsBufferFilled() &&
        (_GraphPtsPtr - _GraphPtsBuffer) == _GraphPtsIndex && _ReadMorePts)
    {
      while (x < numpts_ && _GraphPtsIndex < PtBufMax_ && _ReadMorePts)
      {
        _GraphPtsBuffer[_GraphPtsIndex++] = fptv_[x++];
        _GraphPtsPtr++;
        _ReadMorePts--;
      }

      if (_ReadMorePts == 0)
        _ReadNextPts = false;

      if (_GraphPtsIndex == PtBufMax_)
      {
        _GraphPtsNotRead = false;
        _GraphPtsPtr = _GraphPtsBuffer;
      }

      #if DISCONTDETECT_DEBUG1
        DbgPtr()->ShowInt(_GraphPtsBuffer != NULL, "_GraphPtsBuffer != NULL");
        DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
        DbgPtr()->ShowInt(_GraphPtsIndex, "_GraphPtsIndex");
        DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
        DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");

        DbgPtr()->ShowInt(numpts_, "numpts_");
        DbgPtr()->ShowInt(_GraphPtsIndex == PtBufMax_, "_GraphPtsIndex == PtBufMax_");
        DbgPtr()->ShowInt(_GraphPtsPtr == _GraphPtsBuffer, "_GraphPtsPtr == _GraphPtsBuffer");
      #endif

      if (x == numpts_ || _ReadMorePts == 0)
      {
        #if DISCONTDETECT_DEBUG1
          DbgPtr()->LeaveLevel();
        #endif

        if (ptsread_)
          *ptsread_ = x;

        return true;
      }
    }

    if (_ReadAheadBuffer && _RdAheadPtsNotRead && !ReadAheadBufferFilled() &&
        (_ReadAheadPtr - _ReadAheadBuffer) == _RdAheadIndex && _ReadMorePts)
    {
      while (x < numpts_ && _RdAheadIndex < _RdBufferSize && _ReadMorePts)
      {
        _ReadAheadBuffer[_RdAheadIndex++] = fptv_[x++];
        _ReadAheadPtr++;
        _ReadMorePts--;
      }

      if (_ReadMorePts == 0)
        _ReadNextPts = false;

      if (_RdAheadIndex == _RdBufferSize)
      {
        _RdAheadPtsNotRead = false;
        _ReadAheadPtr = _ReadAheadBuffer;

        if (IndexNotAtMax_ && _TransferPts && _TransferDone)
        {
          _TransferDone = false;
          _TransferPts = 0;
        }
      }

      #if DISCONTDETECT_DEBUG1
        DbgPtr()->ShowInt(_ReadAheadBuffer != NULL, "_ReadAheadBuffer != NULL");
        DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
        DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");
        DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
        DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");

        DbgPtr()->ShowInt(numpts_, "numpts_");
        DbgPtr()->ShowInt(_RdAheadIndex == _RdBufferSize, "_RdAheadIndex == _RdBufferSize");
        DbgPtr()->ShowInt(_ReadAheadPtr == _ReadAheadBuffer, "_ReadAheadPtr == _ReadAheadBuffer");
      #endif

      if (x == numpts_ || _ReadMorePts == 0)
      {
        #if DISCONTDETECT_DEBUG1
          DbgPtr()->LeaveLevel();
        #endif

        if (ptsread_)
          *ptsread_ = x;

        return true;
      }
    }
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif

  if (ptsread_)
    *ptsread_ = x;

  return false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::AppendReadAheadBuffer(int numpts_, PRIM* fptv_, int* ptsread_)
{
  int x = 0;
  bool IndexNotAtMax_ = _RdAheadIndex < _RdBufferSize;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("AppendReadAheadBuffer(int, PRIM*)");
  #endif

  if (_TransferDone && _TransferPts > 0)
  {
    _ReadAheadPtr = &_ReadAheadBuffer[_RdAheadIndex];
    _RdAheadPtsNotRead = true;

    _ReadMorePts = _TransferPts;
    _ReadNextPts = _ReadMorePts > 0;

    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_TransferPts, "_TransferPts");
      DbgPtr()->ShowInt(_TransferDone, "_TransferDone");
    #endif

    if (_ReadAheadBuffer && _RdAheadPtsNotRead && !ReadAheadBufferFilled() &&
        (_ReadAheadPtr - _ReadAheadBuffer) == _RdAheadIndex && _ReadMorePts)
    {
      while (x < numpts_ && _RdAheadIndex < _RdBufferSize && _ReadMorePts)
      {
        _ReadAheadBuffer[_RdAheadIndex++] = fptv_[x++];
        _ReadAheadPtr++;
        _ReadMorePts--;
      }

      if (_ReadMorePts == 0)
        _ReadNextPts = false;

      if (_RdAheadIndex == _RdBufferSize)
      {
        _RdAheadPtsNotRead = false;
        _ReadAheadPtr = (_InfinityPtFound && _FrontPtsShifted &&
                         _FrontPts[_StrikeLimit-1] == _ReadAheadBuffer[0]) ? &_ReadAheadBuffer[1]:_ReadAheadBuffer;

        if (IndexNotAtMax_ && _TransferPts && _TransferDone)
        {
          _TransferDone = false;
          _TransferPts = 0;
        }
      }

      #if DISCONTDETECT_DEBUG1
        DbgPtr()->ShowInt(_ReadAheadBuffer != NULL, "_ReadAheadBuffer != NULL");
        DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
        DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");
        DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
        DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");

        DbgPtr()->ShowInt(numpts_, "numpts_");
        DbgPtr()->ShowInt(_RdAheadIndex == _RdBufferSize, "_RdAheadIndex == _RdBufferSize");
        DbgPtr()->ShowInt(_ReadAheadPtr == _ReadAheadBuffer, "_ReadAheadPtr == _ReadAheadBuffer");
      #endif

      if (x == numpts_ || _ReadMorePts == 0)
      {
        #if DISCONTDETECT_DEBUG1
          DbgPtr()->LeaveLevel();
        #endif

        if (ptsread_)
          *ptsread_ = x;

        return true;
      }
    }
  }

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->LeaveLevel();
  #endif

  if (ptsread_)
    *ptsread_ = x;

  return false;
}

/****************************************************************************/
template <class WRAP, class PRIM>
bool GraphDiscontinuityDetector<WRAP, PRIM>::TerminateReadAheadBuffer(int* ptsterm_)
{
  int PtBufMax_ = _PtBufferSize - 1;
  bool UnderfilledBuffer_ = _GraphPtsIndex < PtBufMax_;
  bool IndexNotAtMax_ = _RdAheadIndex < _RdBufferSize;
  bool BufferTerminated_ = false;

  if ((!UnderfilledBuffer_ && (_RdAheadIndex >= _RdBufferSize || !_RdAheadPtsNotRead)) ||
      (UnderfilledBuffer_ && (!_GraphPtsNotRead || !_RdAheadPtsNotRead)))
    return false;

  if (_RdAheadIndex == 0)
  {
    _ReadAheadBuffer[0] = (UnderfilledBuffer_ || !(_InfinityPtFound && _FrontPtsShifted)) ?
                                        _GraphPtsBuffer[_GraphPtsIndex-1]:
                                        _FrontPts[_StrikeLimit-1];

    _RdAheadIndex = 1;
    _ReadAheadPtr = &_ReadAheadBuffer[1];
  }

  PRIM TermVal_ = _ReadAheadBuffer[_RdAheadIndex-1];

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->EnterLevel("TerminateReadAheadBuffer()");
  #endif

  if (UnderfilledBuffer_ &&
      _GraphPtsBuffer && _GraphPtsNotRead && !GraphPtsBufferFilled() &&
      (_GraphPtsPtr - _GraphPtsBuffer) == _GraphPtsIndex)
  {
    while (_GraphPtsIndex < PtBufMax_)
    {
      _GraphPtsBuffer[_GraphPtsIndex++] = TermVal_;
      _GraphPtsPtr++;
      _TerminatedPts++;
    }

    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_GraphPtsBuffer != NULL, "_GraphPtsBuffer != NULL");
      DbgPtr()->ShowInt(_GraphPtsNotRead, "_GraphPtsNotRead");
      DbgPtr()->ShowInt(_GraphPtsIndex, "_GraphPtsIndex");
      DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
      DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");

      DbgPtr()->ShowInt(_GraphPtsIndex == PtBufMax_, "_GraphPtsIndex == PtBufMax_");
      DbgPtr()->ShowInt(_GraphPtsPtr == _GraphPtsBuffer, "_GraphPtsPtr == _GraphPtsBuffer");
    #endif

    if (_GraphPtsIndex == PtBufMax_)
    {
      BufferTerminated_ = true;

      _GraphPtsNotRead = false;
      _GraphPtsPtr = _GraphPtsBuffer;

      _ReadMorePts = 0;
      _ReadNextPts = false;

      if (IndexNotAtMax_ && _TransferPts && _TransferDone)
      {
        _TransferDone = false;
        _TransferPts = 0;
      }
    }
  }

  if (_ReadAheadBuffer && _RdAheadPtsNotRead && !ReadAheadBufferFilled() &&
      (_ReadAheadPtr - _ReadAheadBuffer) == _RdAheadIndex)
  {
    while (_RdAheadIndex < _RdBufferSize)
    {
      _ReadAheadBuffer[_RdAheadIndex++] = TermVal_;
      _ReadAheadPtr++;
      _TerminatedPts++;
    }

    #if DISCONTDETECT_DEBUG1
      DbgPtr()->ShowInt(_ReadAheadBuffer != NULL, "_ReadAheadBuffer != NULL");
      DbgPtr()->ShowInt(_RdAheadPtsNotRead, "_RdAheadPtsNotRead");
      DbgPtr()->ShowInt(_RdAheadIndex, "_RdAheadIndex");
      DbgPtr()->ShowInt(_ReadMorePts, "_ReadMorePts");
      DbgPtr()->ShowInt(_ReadNextPts, "_ReadNextPts");

      DbgPtr()->ShowInt(_RdAheadIndex == _RdBufferSize, "_RdAheadIndex == _RdBufferSize");
      DbgPtr()->ShowInt(_ReadAheadPtr == _ReadAheadBuffer, "_ReadAheadPtr == _ReadAheadBuffer");
    #endif

    if (_RdAheadIndex == _RdBufferSize)
    {
      BufferTerminated_ = true;

      _RdAheadPtsNotRead = false;
      _ReadAheadPtr = _ReadAheadBuffer;

      _ReadMorePts = 0;
      _ReadNextPts = false;

      if (IndexNotAtMax_ && _TransferPts && _TransferDone)
      {
        _TransferDone = false;
        _TransferPts = 0;
      }
    }
  }

  if (ptsterm_)
    *ptsterm_ = _TerminatedPts;

  #if DISCONTDETECT_DEBUG1
    DbgPtr()->ShowInt(_TerminatedPts, "_TerminatedPts");
    DbgPtr()->LeaveLevel();
  #endif

  return BufferTerminated_;
}

/****************************************************************************/
template <class WRAP, class PRIM>
void* GraphDiscontinuityDetector<WRAP, PRIM>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class WRAP, class PRIM>
void GraphDiscontinuityDetector<WRAP, PRIM>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
// Line Calculator class definitions
/****************************************************************************/
template <class T>
LineCalculator<T>::LineCalculator(int argc, char** argv):
CalculatorBase(argc, argv),
_CmdArgc(argc),
_CmdArgv(argv),

_StrVarData(NULL),
_StringOperation(0),
_EvalStrings(0),
_ReEvalStrings(0),
_AngleUnit(RADIAN),
_StackSize(STACKSIZE),
_PrevCalcIndex(0),
_AssignmentOrder(NULL),
_TransferValue1(0),

_SubExprStack(NULL),
_Expression(NULL),
_ExecutingExpr(NULL),
_ActiveExpression(NULL),

_ProgramStack(NULL),
_Program(NULL),
_NewProgram(NULL),
_ActiveProgram(NULL),

_ConsoleInput(false),
_ConsoleOutput(false),
_SkipPause(false),

// WinlineLineBuffer and WindowLine objects are need only for text mode console I/O version
#if (!(USE_STDIO_ONLY))
  _SavedConIO(0),
  _pbox(NULL),
  _pwin(NULL),
#else
  _SavedConIO(0),
#endif

_ParentPtr(this),
_ChildPtr(NULL)
{
  #if CALCLIB_DEBUG2
    fputs("Entering: LineCalculator constructor\n", logfile);
  #endif

  _Random.RANDOMIZE();

  int i;
  for (i = 0; i < MAXCALC; i++)
    _CalcPtrArray[i] = NULL;

#if (!(USE_STDIO_ONLY))
  #if USE_OLDVERSION_WINLINE
    _pwin = new WindowLine(1, 1, 1, 1, CONIO_WIN_MAX_XLEN, CONIO_WIN_MAX_YLEN);

    if (_pwin)
    {
      _pwin->SetWinLineProperties(false);
      _pwin->SetWinBlockProperties(false, true);

      _pbox = WindowLineBuffer::Make(NULL, NULL, CONSOLE_INPUT_SIZE);

      if (_pbox)
      {
        _pbox->SetEndBrksActive(true);
        _pbox->SetInputLength(CONIO_INPUT_LENGTH, true);

        _pbox->SetTrimWs(false);
        _pbox->SetXpos(1);
        _pbox->SetYpos(1);

        _pwin->SetWindowLineNum(1);
        _pwin->SetInputLength(CONIO_INPUT_LENGTH);
        (*_pwin)[0] = _pbox;
      }
    }
  #else
    _pwin = new WindowLine(0, CONIO_INPUT_LENGTH, CONSOLE_INPUT_SIZE,
                           WinCoordsData::Make(1, 1, CONIO_WIN_MAX_XLEN, CONIO_WIN_MAX_YLEN));

    if (_pwin)
    {
      _pwin->SetWinLineProperties(false);
      _pwin->SetWinBlockProperties(false, true);

      _pbox = (*_pwin)[0];
      _pbox->SetTrimWs(false);
    }
  #endif
#endif

  #if CALCLIB_DEBUG2
    fputs("Leaving: LineCalculator constructor\n", logfile);
  #endif
}

/****************************************************************************/
template <class T>
LineCalculator<T>::~LineCalculator()
{
  if (!Parent() && !ParentDestroyed())
  {
    // Deallocate data stacks
    if (ProgramStackExists())
    {
      DestroyProgramStack(TRUE);
      AssignToNullVarsForProgram();
    }

    if (SubExprStackExists())
    {
      DestroySubExprStack(FALSE);
      AssignToNullVarsForSubExpr();
    }

    // Deallocate and transfer outputbuffer
    DestroyOutputBuffer();
    AssignToNullOutputBuffer();

    // Deallocate memory for command history list data members
    DeallocateHistoryListAll();
    SetHistoryListIndex(-1);
    SetHistoryListLength(0);
    SetHistoryListMode(FALSE);
    SetHistoryListEnded(FALSE);

    // To avoid double deletion of root parent calculator object
    if (_CalcPtrArray[CalculatorBase::FLOAT] == this)
      _CalcPtrArray[CalculatorBase::FLOAT] =  NULL;

    if (_CalcPtrArray[CalculatorBase::DOUBLE] == this)
      _CalcPtrArray[CalculatorBase::DOUBLE] = NULL;

    if (_CalcPtrArray[CalculatorBase::LONGDOUBLE] == this)
      _CalcPtrArray[CalculatorBase::LONGDOUBLE] = NULL;

    if (_CalcPtrArray[CalculatorBase::LONGNUM] == this)
      _CalcPtrArray[CalculatorBase::LONGNUM] = NULL;

    if (MemMatrix::Matrix().HasThis(_StrVarData))
      delete _StrVarData;
    _StrVarData = NULL;

    MemMatrix::Matrix().Deallocate(_AssignmentOrder);
    _AssignmentOrder = NULL;

    EraseAllAnswerStr();

#if (!(USE_STDIO_ONLY))
    if (MemMatrix::Matrix().HasThis(_pwin))
    {
      delete _pwin;
      _pwin = NULL;
    }
#endif

    int i;
    for (i = 1; i < MAXCALC; i++)
    {
      if (MemMatrix::Matrix().HasThis(_CalcPtrArray[i]) &&
          CalculatorBase::CalculatorExists(_CalcPtrArray[i]->ClassNumber()))
      {
        _CalcPtrArray[i]->AssignToNullVarsForProgram();
        _CalcPtrArray[i]->AssignToNullVarsForSubExpr();
        _CalcPtrArray[i]->AssignToNullOutputBuffer();

        if (_CalcPtrArray[i]->Parent())
          _CalcPtrArray[i]->SetParentDestroyed(true);

        delete _CalcPtrArray[i];
      }

      _CalcPtrArray[i] = NULL;
    }
  }
  else if (Parent())
    SetParentDestroyed(true);
}

/*****************************************************************************/
/*****************************************************************************/
// Data stacks creation and transfer methods
// Creates: SubExpression stack, CalcProgram stack and outputbuffer
/****************************************************************************/
template <class T>
void LineCalculator<T>::CreateDataStacks()
{
  int x;

  if (!_SubExprStack)
  {
    _SubExprStack = (SubExpression**)CalculatorBase::allocmem(_ExprStackLimit, sizeof(SubExpression*), _SubExprStack);
    _ExprStackIndex = 0;

    for (x = 0; x < _ExprStackLimit; x++)
      _SubExprStack[x] = NULL;
  }

  if (!_ProgramStack)
  {
    _ProgramStack = (CalcProgram**)CalculatorBase::allocmem(_ProgramStackLimit, sizeof(CalcProgram*), _ProgramStack);
    _ProgramStackIndex = 0;

    for (x = 0; x < _ProgramStackLimit; x++)
      _ProgramStack[x] = NULL;
  }

  _ProgramID =
  _NewProgramID =
  _PrevProgramID = 0;

  // Create calc. program active/inactive status stack and initialize to entries to zero
  _ExecProgramActive = (long*)allocmem((2 * _ProgramStackLimit), sizeof(long), _ExecProgramActive);
  ::memset(_ExecProgramActive, 0, (2 * _ProgramStackLimit) * sizeof(long));

  // Create output buffer. Not part of data stacks, but don't want to write
  // another new method just for the one line creation of a ChrString object
  _OutputBuffer = new ChrString;
  _OutputBuffer->SetEmpty();
  _ErrorArgStr = new ChrString;
  _ErrorArgStr->SetEmpty();
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::TransferToAllChildCalcs()
{
  if (!Parent())
  {
    if (_CalcPtrArray[CalculatorBase::FLOAT] &&
        _CalcPtrArray[CalculatorBase::FLOAT] != this &&
        _CalcPtrArray[CalculatorBase::FLOAT]->Parent() == this)
    {
      _CalcPtrArray[CalculatorBase::FLOAT]->TransferVarsForSubExpr(this);
      _CalcPtrArray[CalculatorBase::FLOAT]->TransferVarsForProgram(this);
      _CalcPtrArray[CalculatorBase::FLOAT]->TransferOutputBuffer(this);
    }

    if (_CalcPtrArray[CalculatorBase::DOUBLE] &&
        _CalcPtrArray[CalculatorBase::DOUBLE] != this &&
        _CalcPtrArray[CalculatorBase::DOUBLE]->Parent() == this)
    {
      _CalcPtrArray[CalculatorBase::DOUBLE]->TransferVarsForSubExpr(this);
      _CalcPtrArray[CalculatorBase::DOUBLE]->TransferVarsForProgram(this);
      _CalcPtrArray[CalculatorBase::DOUBLE]->TransferOutputBuffer(this);
    }

    if (_CalcPtrArray[CalculatorBase::LONGDOUBLE] &&
        _CalcPtrArray[CalculatorBase::LONGDOUBLE] != this &&
        _CalcPtrArray[CalculatorBase::LONGDOUBLE]->Parent() == this)
    {
      _CalcPtrArray[CalculatorBase::LONGDOUBLE]->TransferVarsForSubExpr(this);
      _CalcPtrArray[CalculatorBase::LONGDOUBLE]->TransferVarsForProgram(this);
      _CalcPtrArray[CalculatorBase::LONGDOUBLE]->TransferOutputBuffer(this);
    }

    if (_CalcPtrArray[CalculatorBase::LONGNUM] &&
        _CalcPtrArray[CalculatorBase::LONGNUM] != this &&
        _CalcPtrArray[CalculatorBase::LONGNUM]->Parent() == this)
    {
      _CalcPtrArray[CalculatorBase::LONGNUM]->TransferVarsForSubExpr(this);
      _CalcPtrArray[CalculatorBase::LONGNUM]->TransferVarsForProgram(this);
      _CalcPtrArray[CalculatorBase::LONGNUM]->TransferOutputBuffer(this);
    }
  }
}

/****************************************************************************/
// Output buffer methods
/****************************************************************************/
template <class T>
void LineCalculator<T>::DestroyOutputBuffer()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->DestroyOutputBuffer();
  }
  else
  {
    if (MemMatrix::Matrix().HasThis(_OutputBuffer))
    {
      delete _OutputBuffer;
      _OutputBuffer = NULL;
    }

    if (MemMatrix::Matrix().HasThis(_ErrorArgStr))
    {
      delete _ErrorArgStr;
      _ErrorArgStr = NULL;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferOutputBuffer(this);
      _ChildPtr = NULL;
    }
  }
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::TransferOutputBuffer(CalculatorBase* ptr)
{
  // ChrString* _OutputBuffer; // Pointer to Program Mode output buffer
  //
  LineCalculator<T>* dptr = ptr ? ((LineCalculator<T>*)ptr):NULL;
  LineCalculator<T>* hptr = ((LineCalculator<T>*)this);

  if (dptr && _ParentPtr && dptr != hptr && _ParentPtr != hptr)
  {
    _OutputBuffer = dptr->_OutputBuffer;
    _ErrorArgStr = dptr->_ErrorArgStr;
    _UsingErrorArgStr = dptr->_UsingErrorArgStr;

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ErrorArgStrExists() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ErrorArgStrExists();

  return (_ErrorArgStr != NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::OutputBufferExists() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->OutputBufferExists();

  return (_OutputBuffer != NULL);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::AssignToNullOutputBuffer()
{
  _OutputBuffer = NULL;
  _ErrorArgStr = NULL;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SendToErrorArgStr(const char* str, bool Reset_)
{
  bool ret = false;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    ret = _ParentPtr->SendToErrorArgStr(str, Reset_);
  }
  else
  {
    if (_ErrorArgStr)
    {
      if (str || Reset_)
      {
        if (Reset_)
          _ErrorArgStr->SetEmpty();
        else
          *_ErrorArgStr = str;
        ret = true;
      }
    }
    else
    {
      _ErrorArgStr = new ChrString;

      if (_ErrorArgStr && (str || Reset_))
      {
        if (Reset_)
          _ErrorArgStr->SetEmpty();
        else
          *_ErrorArgStr = str;
        ret = true;
      }
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferOutputBuffer(this);
      _ChildPtr = NULL;
    }
  }

  return ret;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SendToErrorArgStr(const char* str)
{
  return SendToErrorArgStr(str, false);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ResetErrorArgStr()
{
  return SendToErrorArgStr(NULL, true);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SendToOutputBuffer(const char* str, bool Reset_)
{
  bool ret = false;
  long ProgID_ = GiveProgramID();
  CalcProgram* Program_ = (InProgramMode(true) && ProgID_) ?
                                FindProgramFromID(ProgID_, true):
                                NULL;
  CalculatorBase* ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;
  CalculatorBase* CalcPtr_ = GetCalcType();

  if (ProgCalc_ != CalcPtr_ && Program_ && CalcPtr_)
  {
    Program_->SetCalculator(CalcPtr_);
    ProgCalc_ = CalcPtr_;
  }

  bool StringVar_ = false;
  bool FloatVar_ = false;
  bool IndexSet_ = false;
  bool HasRetAns_ = false;

  int Index_ = 0;
  int NumBase_ = 0;
  int Mode_ = AnswerMode();

  bool DispVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay);
  bool DumpVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump);

  bool DispVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDisplay);
  bool DumpVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDump);

  bool AnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsVar);
  bool AnsStrVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsStrVar);
  bool FracAnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_FracAnsVar);

  bool FloatAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_FloatAnswer);
  bool LiteralAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                      Mcalc_OutputDataType::Out_LiteralAnswer);
  bool FractionAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                       Mcalc_OutputDataType::Out_FractionAnswer);

  SubExpression* SubExpr_ = TopSubExprStack();
  bool Confirmed_ = (SubExprStackIndex() == 1 ||
                     InRunningProgram(true, true, false, false)) &&
                    !ActiveExpression() &&
                    (!SubExpr_ || SubExpr_->GetLevel() == 0);

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    ret = _ParentPtr->SendToOutputBuffer(str, Reset_);
  }
  else
  {
    if (_OutputBuffer)
    {
      if (str || Reset_)
      {
        if (Reset_)
          _OutputBuffer->SetEmpty();
        else
          *_OutputBuffer = str;
        ret = true;
      }
    }
    else
    {
      _OutputBuffer = new ChrString;

      if (_OutputBuffer && (str || Reset_))
      {
        if (Reset_)
          _OutputBuffer->SetEmpty();
        else
          *_OutputBuffer = str;
        ret = true;
      }
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferOutputBuffer(this);
      _ChildPtr = NULL;
    }
  }

  if (!Reset_ && ret && DumpVarsType_)
  {
    if (InProgramMode(false) && !DumpVarsCond_)
    {
      SetResultsPending(true);
      HasRetAns_ = true;
      SetAnswerMode(LITERAL_MODE, true);
    }
    else if (DumpVarsCond_)
    {
      SetResultsShown(true);
      HasRetAns_ = true;
    }

    ret = HasRetAns_;
  }
  else if (!Reset_ && ret && DispVarsType_)
  {
    if (InProgramMode(false))
    {
      NumBase_ = CalcPtr_->NumberBase();

      if (!AnsVarSet_ && !AnsStrVarSet_ && !FracAnsVarSet_)
      {
        Index_ = GiveOutputDataIndex(IndexSet_);

        if (IndexSet_)
        {
          SetResultsPending(true);
          HasRetAns_ = true;

          if (FloatAns_)
            SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
          else if (NumBase_ == 8 || NumBase_ == 16)
            SetAnswerMode(ALTBASE_MODE, Confirmed_);
          else if (LiteralAns_ || FractionAns_)
            SetAnswerMode(LITERAL_MODE, Confirmed_);
        }
      }
      else
      {
        SetResultsPending(true);
        HasRetAns_ = true;

        if (AnsVarSet_)
          SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
        else if (NumBase_ == 8 || NumBase_ == 16)
          SetAnswerMode(ALTBASE_MODE, Confirmed_);
        else if (AnsStrVarSet_ || FracAnsVarSet_)
          SetAnswerMode(LITERAL_MODE, Confirmed_);
      }
    }
    else if (DispVarsCond_)
    {
      SetResultsShown(true);
      HasRetAns_ = true;
    }

    ret = HasRetAns_;
  }

  return ret;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SendToOutputBuffer(const char* str)
{
  return SendToOutputBuffer(str, false);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ResetOutputBuffer()
{
  return SendToOutputBuffer(NULL, true);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::AppendToOutputBuffer(const char* str)
{
  bool ret = false;
  long ProgID_ = GiveProgramID();
  CalcProgram* Program_ = (InProgramMode(true) && ProgID_) ?
                                FindProgramFromID(ProgID_, true):
                                NULL;
  CalculatorBase* ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;
  CalculatorBase* CalcPtr_ = GetCalcType();

  if (ProgCalc_ != CalcPtr_ && Program_ && CalcPtr_)
  {
    Program_->SetCalculator(CalcPtr_);
    ProgCalc_ = CalcPtr_;
  }

  bool StringVar_ = false;
  bool FloatVar_ = false;
  bool IndexSet_ = false;
  bool HasRetAns_ = false;

  int Index_ = 0;
  int NumBase_ = 0;
  int Mode_ = AnswerMode();

  bool DispVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay);
  bool DumpVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump);

  bool DispVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDisplay);
  bool DumpVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDump);

  bool AnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsVar);
  bool AnsStrVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsStrVar);
  bool FracAnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_FracAnsVar);

  bool FloatAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_FloatAnswer);
  bool LiteralAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                      Mcalc_OutputDataType::Out_LiteralAnswer);
  bool FractionAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                       Mcalc_OutputDataType::Out_FractionAnswer);

  SubExpression* SubExpr_ = TopSubExprStack();
  bool Confirmed_ = (SubExprStackIndex() == 1 ||
                     InRunningProgram(true, true, false, false)) &&
                    !ActiveExpression() &&
                    (!SubExpr_ || SubExpr_->GetLevel() == 0);

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    ret = _ParentPtr->AppendToOutputBuffer(str);
  }
  else
  {
    if (_OutputBuffer)
    {
      if (str)
      {
        *_OutputBuffer += str;
        ret = true;
      }
    }
    else
    {
      _OutputBuffer = new ChrString;

      if (_OutputBuffer && str)
      {
        *_OutputBuffer += str;
        ret = true;
      }
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferOutputBuffer(this);
      _ChildPtr = NULL;
    }
  }

  if (ret && DumpVarsType_)
  {
    if (InProgramMode(false) && !DumpVarsCond_)
    {
      SetResultsPending(true);
      HasRetAns_ = true;
      SetAnswerMode(LITERAL_MODE, true);
    }
    else if (DumpVarsCond_)
    {
      SetResultsShown(true);
      HasRetAns_ = true;
    }

    ret = HasRetAns_;
  }
  else if (ret && DispVarsType_)
  {
    if (InProgramMode(false))
    {
      NumBase_ = CalcPtr_->NumberBase();

      if (!AnsVarSet_ && !AnsStrVarSet_ && !FracAnsVarSet_)
      {
        Index_ = GiveOutputDataIndex(IndexSet_);

        if (IndexSet_)
        {
          SetResultsPending(true);
          HasRetAns_ = true;

          if (FloatAns_)
            SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
          else if (NumBase_ == 8 || NumBase_ == 16)
            SetAnswerMode(ALTBASE_MODE, Confirmed_);
          else if (LiteralAns_ || FractionAns_)
            SetAnswerMode(LITERAL_MODE, Confirmed_);
        }
      }
      else
      {
        SetResultsPending(true);
        HasRetAns_ = true;

        if (AnsVarSet_)
          SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
        else if (NumBase_ == 8 || NumBase_ == 16)
          SetAnswerMode(ALTBASE_MODE, Confirmed_);
        else if (AnsStrVarSet_ || FracAnsVarSet_)
          SetAnswerMode(LITERAL_MODE, Confirmed_);
      }
    }
    else if (DispVarsCond_)
    {
      SetResultsShown(true);
      HasRetAns_ = true;
    }

    ret = HasRetAns_;
  }

  return ret;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::GiveErrorArgStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GiveErrorArgStr();

  ChrString Dummy_;
  return (_ErrorArgStr ? *_ErrorArgStr:Dummy_);
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::GiveOutputBuffer() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GiveOutputBuffer();

  ChrString Dummy_;
  return (_OutputBuffer ? *_OutputBuffer:Dummy_);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetUseErrorArgStr(bool DoUse_, const char* str)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _UsingErrorArgStr = DoUse_;
    _ParentPtr->SetUseErrorArgStr(DoUse_, str);
  }
  else if (_ErrorArgStr)
  {
    _UsingErrorArgStr = DoUse_;

    if (DoUse_ && str)
      SendToErrorArgStr(str);
    else if (!DoUse_)
      ResetErrorArgStr();
  }
}

/*****************************************************************************/
template <class T>
bool LineCalculator<T>::UsingErrorArgStr() const
{
  return _UsingErrorArgStr;
}

/****************************************************************************/
/*****************************************************************************/
// Subexpression stack methods
// -- SubExpression** matrix methods
/****************************************************************************/
template <class T>
void LineCalculator<T>::CreateNewSubExpr()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->CreateNewSubExpr();
  }
  else
  {
    while (_ExprStackIndex >= _ExprStackLimit)
      ResizeExprStack();

    CalculatorBase* CalcPtr_ = this;
    _Expression = new SubExpression();

    if (_Expression)
    {
      _Expression->SetCalculator(CalcPtr_);
      _SubExprStack[_ExprStackIndex] = _Expression;
      _ExprStackIndex++;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::CreateNewSubExpr(SubExpression* Parent_, int Level_, const char* Expr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->CreateNewSubExpr(Parent_, Level_, Expr_);
  }
  else
  {
    while (_ExprStackIndex >= _ExprStackLimit)
      ResizeExprStack();

    CalculatorBase* CalcPtr_ = this;
    _Expression = new SubExpression(Parent_, Level_, Expr_);

    if (_Expression)
    {
      _Expression->SetCalculator(CalcPtr_);
      _SubExprStack[_ExprStackIndex] = _Expression;
      _ExprStackIndex++;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
long LineCalculator<T>::SubExprStackSize() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SubExprStackSize();

  return _ExprStackLimit;
}

/****************************************************************************/
template <class T>
long LineCalculator<T>::SubExprStackIndex() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SubExprStackIndex();

  return _ExprStackIndex;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ResizeExprStack()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->ResizeExprStack();
  }
  else
  {
    SubExpression** OldStack_ = _SubExprStack;
    long OldLimit_ = _ExprStackLimit;

    _ExprStackLimit += 20;
    _SubExprStack = (SubExpression**)CalculatorBase::allocmem(_ExprStackLimit, sizeof(SubExpression*), _SubExprStack);

    long x;
    for (x = 0; x < OldLimit_; x++)
      _SubExprStack[x] = OldStack_[x];

    for (;x < _ExprStackLimit; x++)
      _SubExprStack[x] = NULL;

    MemMatrix::Matrix().Deallocate(OldStack_);
    OldStack_ = NULL;

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/****************************************************************************/
template <class T>
SubExpression* LineCalculator<T>::TopSubExprStack(bool GiveExecExpr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->TopSubExprStack(GiveExecExpr_);
  }

  if (_ExprStackIndex)
  {
    _Expression = GiveExecExpr_ ? ExecutingExpression():
                                  _SubExprStack[_ExprStackIndex - 1];

    if (GiveExecExpr_ && !_Expression)
      _Expression = _SubExprStack[_ExprStackIndex - 1];
  }
  else
    _Expression = GiveExecExpr_ ? ExecutingExpression():NULL;

  if (_ChildPtr)
  {
    _ChildPtr->TransferVarsForSubExpr(this);
    _ChildPtr = NULL;
  }

  return _Expression;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::PopSubExprStack(int PopAndDelete_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->PopSubExprStack(PopAndDelete_);
  }
  else if (_ExprStackIndex > 0)
  {
    _ExprStackIndex--;

    if (PopAndDelete_ && MemMatrix::Matrix().HasThis(_SubExprStack[_ExprStackIndex]))
    {
      _SubExprStack[_ExprStackIndex]->Clear();
      _SubExprStack[_ExprStackIndex]->SetCalculator(NULL);
      delete _SubExprStack[_ExprStackIndex];
    }

    _SubExprStack[_ExprStackIndex] = NULL;
    TopSubExprStack();

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::DestroySubExprStack(int PopAndDelete_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->DestroySubExprStack(PopAndDelete_);
  }
  else
  {
    long index_ = 0;
    _Expression = NULL;

    if (!PopAndDelete_)
    {
      while (_ExprStackIndex > 0)
      {
        _ExprStackIndex--;

        if (_SubExprStack[_ExprStackIndex])
        {
          _SubExprStack[_ExprStackIndex]->Clear();
          _SubExprStack[_ExprStackIndex]->SetCalculator(NULL);

          if (MemMatrix::Matrix().HasThis(_SubExprStack[_ExprStackIndex]))
            delete _SubExprStack[_ExprStackIndex];

          _SubExprStack[_ExprStackIndex] = NULL;
        }
      }

      MemMatrix::Matrix().Deallocate(_SubExprStack);
      _SubExprStack = NULL;
    }
    else
      _ExprStackIndex = 0;

    while (_ActiveExpression)
    {
      ExpressionStack* Top_ = _ActiveExpression;

      if (_ActiveExpression)
        _ActiveExpression = _ActiveExpression->Next();
      else
        break;

      if (Top_)
      {
        if (PopAndDelete_ && FindInSubExprStack(Top_->GiveData(), &index_))
        {
          if (_SubExprStack[_ExprStackIndex])
          {
            _SubExprStack[_ExprStackIndex]->Clear();
            _SubExprStack[_ExprStackIndex]->SetCalculator(NULL);
            _SubExprStack[_ExprStackIndex] = NULL;
          }

          if (_SubExprStack[index_])
          {
            _SubExprStack[index_]->Clear();
            _SubExprStack[index_]->SetCalculator(NULL);
            _SubExprStack[index_] = NULL;
          }

          _ExprStackIndex = index_;
          Top_->PopDelete();
        }
        else
        {
          Top_->Set(NULL);
          Top_->Pop();
        }

        if (MemMatrix::Matrix().HasThis(Top_))
          delete Top_;
      }
    }

    if (PopAndDelete_)
    {
      MemMatrix::Matrix().Deallocate(_SubExprStack);
      _SubExprStack = NULL;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SubExprStackExists() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SubExprStackExists();

  return (_SubExprStack != NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::FindInSubExprStack(SubExpression* ptr, long* index_)
{
  if (!ptr)
    return FALSE;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FindInSubExprStack(ptr, index_);

  long x;
  for (x = 0; x < _ExprStackIndex; x++)
    if (_SubExprStack[x] == ptr)
    {
      if (index_)
        *index_ = x;

      return TRUE;
    }

  return FALSE;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::AtLowestExprLevel(int Level_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->AtLowestExprLevel(Level_);

  return
  (
    Level_ == 0 &&
    (_ExprStackIndex == 1 ||
     InRunningProgram(true, true, false, false)) &&
    !_ActiveExpression
  );
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::EvalFncWithValue(const ChrString& ExprStr_, const ChrString& VarName_,
                                              const ChrString& Value_, bool PlotOff_, bool* Error_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->EvalFncWithValue(ExprStr_, VarName_, Value_, PlotOff_, Error_);
  }

  const char* retstr_ = NULL;     // new
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;
  ChrString FncValue_ = Value_;
  ChrString Answer_;

  if (!IsThisChar(Value_.c_str(), 0, '(', 1) ||
      !IsThisChar(Value_.c_str(), Value_.strlen() - 1, ')', 0))
    FncValue_ = ChrString("(") + Value_ + ChrString(")");

  if (_Expression)
  {
    if (GraphOperation() && PlotOff_)
      SetPlotGraph(true, 0);

    ChrString NewExprStr_ = ExprStr_;
    NewExprStr_.Replace(0, VarName_, FncValue_);
    _Expression->SetExpression(NewExprStr_.c_str());
    _Expression->SetCalculator(CalcPtr_);
    _Expression->CheckIfValidExpression();
    _Expression->FindFunctionCalls();
    _Expression->ExecCmdWasFound();
    _Expression->Evaluate();

    retstr_ = _Expression->GetAnswer();
    Answer_ = retstr_;

    if (Error_ || !retstr_)
      *Error_ = !retstr_ ||
                _Expression->HasErrors() || !_Expression->MathLineValid();

    _Expression->Clear();
    ResetAnswerMode();
  }

  RestoreCalcType();

  if (_ChildPtr)
  {
    _ChildPtr->TransferVarsForSubExpr(this);
    _ChildPtr = NULL;
  }

  return Answer_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ReEvaluate(const ChrString& ExprStr_, bool* Error_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->ReEvaluate(ExprStr_);
  }

  CreateNewSubExpr();

  const char* retstr_ = NULL;
  ChrString Answer_;
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;

  if (_Expression)
  {
    _Expression->SetExpression(ExprStr_.c_str());
    _Expression->SetCalculator(CalcPtr_);
    _Expression->CheckIfValidExpression();
    _Expression->FindFunctionCalls();
    _Expression->ExecCmdWasFound();
    _Expression->Evaluate();

    retstr_ = _Expression->GetAnswer();
    Answer_ = retstr_;

    if (Error_ || !retstr_)
      *Error_ = !retstr_ ||
                _Expression->HasErrors() || !_Expression->MathLineValid();

    _Expression->Clear();
  }

  PopSubExprStack(TRUE);

  if (_ChildPtr)
  {
    _ChildPtr->TransferVarsForSubExpr(this);
    _ChildPtr = NULL;
  }

  return Answer_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::TransferVarsForSubExpr(CalculatorBase* ptr)
{
  // long _ExprStackIndex;               // index to math subexpression stack
  // long _ExprStackLimit;               // math subexpression stack limit
  // SubExpression** _SubExprStack;      // Pointer stack of SubExpression objects
  // SubExpression* _Expression;         // Pointer into SubExpression object stack
  // ExpressionStack* _ActiveExpression; // Pointer to the top of ExpressionStack
  //
  LineCalculator<T>* dptr = ptr ? ((LineCalculator<T>*)ptr):NULL;
  LineCalculator<T>* hptr = ((LineCalculator<T>*)this);

  if (dptr && _ParentPtr && dptr != hptr && _ParentPtr != hptr)
  {
    _Expression = dptr->_Expression;
    _ExprStackLimit = dptr->_ExprStackLimit;
    _SubExprStack = dptr->_SubExprStack;
    _Expression = dptr->_Expression;
    _ActiveExpression = dptr->_ActiveExpression;

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::AssignToNullVarsForSubExpr()
{
  _Expression = NULL;
  _ExprStackLimit = 0;
  _SubExprStack = NULL;
  _Expression = NULL;
  _ActiveExpression = NULL;
}

/*****************************************************************************/
// Subexpression stack: -- PointerStack<SubExpression> methods
/*****************************************************************************/
template <class T>
SubExpression* LineCalculator<T>::ActiveExpression(bool* HasData_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveExpression(HasData_);

  return ExpressionStack::ActiveData(_ActiveExpression, HasData_);
}

/*****************************************************************************/
template <class T>
const SubExpression* LineCalculator<T>::ActiveExpression(bool* HasData_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveExpression(HasData_);

  return ExpressionStack::ActiveData(_ActiveExpression, HasData_);
}

/*****************************************************************************/
template <class T>
const SubExpression* LineCalculator<T>::ActiveConstExpression(bool* HasData_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveConstExpression(HasData_);

  return ExpressionStack::ActiveConstData(_ActiveExpression, HasData_);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PushActiveExpression(SubExpression* Ptr_)
{
  if (Ptr_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      _ParentPtr->SetChild(this);
      return _ParentPtr->PushActiveExpression(Ptr_);
    }
    else
    {
      ExpressionStack* New_ = new ExpressionStack;

      if (New_)
      {
        New_->Push(_ActiveExpression);
        New_->Set(Ptr_);
        _ActiveExpression = New_;

        if (_ChildPtr)
        {
          _ChildPtr->TransferVarsForSubExpr(this);
          _ChildPtr = NULL;
        }

        return TRUE;
      }
    }
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PopActiveExpression(int PopAndDelete_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->PopActiveExpression(PopAndDelete_);
  }
  else if (_ActiveExpression)
  {
    SubExpression* SubExpr_ = ExpressionStack::ActiveData(_ActiveExpression);
    ExpressionStack* Top_ = _ActiveExpression;
    CalculatorBase* CalcPtr_ = SubExpr_ ? SubExpr_->GetCalculator():NULL;

    if (_ActiveExpression)
      _ActiveExpression = _ActiveExpression->Next();

    if (Top_)
    {
      if (PopAndDelete_)
      {
        SubExpr_ = Top_->GiveData();

        if (SubExpr_)
        {
          SubExpr_->Clear();
          SubExpr_->SetCalculator(NULL);
        }

        Top_->PopDelete();
      }
      else
      {
        Top_->Set(NULL);
        Top_->Pop();

        if (SubExpr_ && !SubExpr_->Destroyed())
          if (TopSubExprStack() == SubExpr_ && CalcPtr_)
            CalcPtr_->PopSubExprStack(FALSE);
      }

      if (MemMatrix::Matrix().HasThis(Top_))
        delete Top_;

      if (_ChildPtr)
      {
        _ChildPtr->TransferVarsForSubExpr(this);
        _ChildPtr = NULL;
      }

      return TRUE;
    }
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
SubExpression* LineCalculator<T>::ExecutingExpression()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->ExecutingExpression();
  }

  return _ExecutingExpr;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetExecutingExpression(SubExpression* SubExpr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->SetExecutingExpression(SubExpr_);
  }
  else
    _ExecutingExpr = SubExpr_;
}

/*****************************************************************************/
/*****************************************************************************/
// Calc. Program stack methods
// -- CalcProgram** matrix methods
/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::CreateNewProgram(const char* PrgName_, bool SetExecLevel_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->CreateNewProgram(PrgName_);
  }

  while (_ProgramStackIndex >= _ProgramStackLimit)
    ResizeProgramStack();

  size_t len = 0;
  bool Fullname_ = false;
  ChrString Temps_;
  char* sPrgName_ = ::SafeStrLen(PrgName_) ? ::NewString(PrgName_):NULL;
  CalcProgram* Program_ = !PrgName_ ? (new CalcProgram):NULL;

  CalculatorBase* CalcPtr_ = this;
  CalculatorBase* PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = PrevCalc_;

  if (sPrgName_)
  {
    Temps_ = PrgName_;
    Temps_.RemovePadding(" \n\r\t");
    strcpy(sPrgName_, Temps_.c_str());
    len = strlen(sPrgName_);
    Fullname_ = (len > 4) && icasestrcomp(&sPrgName_[len-4], ".prg");

    if (len && (Fullname_ || !strchr(sPrgName_, '.')))
    {
      if (Fullname_)
        sPrgName_[len-4] = 0;

      if (::SafeStrLen(sPrgName_))
        Program_ = new CalcProgram(CalcPtr_, sPrgName_);
    }
  }
  else if (Program_)
    Program_->SetCalculator(CalcPtr_);

  if (Program_)
  {
    Program_->SetPopFromStack(true);
    _NewProgramID = Program_->CreateProgramID();
    _NewProgram = Program_;
    _ProgramStack[_ProgramStackIndex] = NULL;

    if (SetExecLevel_)
      _BatchExecLevel++;
  }

  if (sPrgName_)
    _MemDel->DelayedDeleteCstr(sPrgName_, STOREMEM);

  if (_ChildPtr)
  {
    _ChildPtr->TransferVarsForProgram(this);
    _ChildPtr = NULL;
  }

  return Program_;
}

/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::GiveNewProgramPtr()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GiveNewProgramPtr();

  return _NewProgram;
}

/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::FindProgramFromIndex(long Index_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FindProgramFromIndex(Index_);

  if (_ProgramStack &&
      Index_ < _ProgramStackLimit && Index_ < _ProgramStackIndex)
    return _ProgramStack[Index_];

  return NULL;
}

/*****************************************************************************/
template <class T>
const CalcProgram* LineCalculator<T>::FindProgramFromIndex(long Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FindProgramFromIndex(Index_);

  if (_ProgramStack &&
      Index_ < _ProgramStackLimit && Index_ < _ProgramStackIndex)
    return _ProgramStack[Index_];

  return NULL;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InsertProgramToStack(CalcProgram* Program_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->InsertProgramToStack(Program_);
  }

  if (Program_ && _ProgramStackIndex < _ProgramStackLimit && !_ProgramStack[_ProgramStackIndex])
    if (_NewProgramID && Program_->GiveProgramID() == _NewProgramID &&
        _NewProgram && Program_ == _NewProgram)
    {
      _PrevProgramID = _ProgramID;
      _ProgramID = _NewProgramID;
      _NewProgramID = 0;

      _ProgramStack[_ProgramStackIndex] = _NewProgram;
      _NewProgram = NULL;

      #if CALCLIB_TESTASYNCMODE2c
        ChrString ProgIDstr_("\nLineCalculator<T>::InsertProgramToStack");
        ProgIDstr_ += ChrString("\n\tPrevProgID:");
        ProgIDstr_ += LongInt::ToString(LongInt(_PrevProgramID));
        ProgIDstr_ += ChrString("\n\tProgID:");
        ProgIDstr_ += LongInt::ToString(LongInt(_ProgramID));
        ProgIDstr_ += ChrString("\n");

        DisplayToLog(ProgIDstr_.c_str());
      #endif

      if (_ChildPtr)
      {
        _ChildPtr->TransferVarsForProgram(this);
        _ChildPtr = NULL;
      }

      return TRUE;
    }

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::DestroyProgramStack(int PopAndDelete_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->DestroyProgramStack(PopAndDelete_);
  }
  else
  {
    long index_ = 0;
    _Program = NULL;

    if (!PopAndDelete_)
    {
      while (_ProgramStackIndex > 0)
      {
        _ProgramStackIndex--;

        if (_ProgramStack[_ProgramStackIndex])
        {
          _ProgramStack[_ProgramStackIndex]->SetCalculator(this);
          _ProgramStack[_ProgramStackIndex]->SetPopFromStack(false);

          if (MemMatrix::Matrix().HasThis(_ProgramStack[_ProgramStackIndex]))
            delete _ProgramStack[_ProgramStackIndex];
          _ProgramStack[_ProgramStackIndex] = NULL;
        }
      }

      MemMatrix::Matrix().Deallocate(_ProgramStack);
      _ProgramStack = NULL;
    }
    else
      _ProgramStackIndex = 0;

    while (_ActiveProgram)
    {
      ProgramStack* Top_ = _ActiveProgram;

      if (_ActiveProgram)
        _ActiveProgram = _ActiveProgram->Next();
      else
        break;

      if (Top_)
      {
        if (PopAndDelete_ && FindInProgramStack(Top_->GiveData(), &index_))
        {
          if (_ProgramStack[index_])
          {
            _ProgramStack[index_]->SetCalculator(this);
            _ProgramStack[index_]->SetPopFromStack(false);
          }

          _ProgramStack[index_] = NULL;
          _ProgramStackIndex = index_;
          Top_->PopDelete();
        }
        else
        {
          Top_->Set(NULL);
          Top_->Pop();
        }

        if (MemMatrix::Matrix().HasThis(Top_))
          delete Top_;
      }
    }

    if (PopAndDelete_)
    {
      MemMatrix::Matrix().Deallocate(_ProgramStack);
      _ProgramStack = NULL;
    }

    // Destroy calc. program active/inactive status stack
    if (_ExecProgramActive)
    {
      MemMatrix::Matrix().Deallocate(_ExecProgramActive);
      _ExecProgramActive = NULL;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForProgram(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ProgramStackExists() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProgramStackExists();

  return (_ProgramStack != NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::FindInProgramStack(CalcProgram* ptr, long* index_)
{
  if (!ptr)
    return FALSE;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FindInProgramStack(ptr, index_);

  long x;
  for (x = 0; x < _ProgramStackIndex; x++)
    if (_ProgramStack[x] == ptr)
    {
      if (index_)
        *index_ = x;

      return TRUE;
    }

  return FALSE;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PopProgramStack(int PopAndDelete_, int DecrIndex_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->PopProgramStack(PopAndDelete_, DecrIndex_);
  }
  else if (_ProgramStackIndex > 0)
  {
    if (PopAndDelete_ && MemMatrix::Matrix().HasThis(_ProgramStack[_ProgramStackIndex-1]))
    {
      _ProgramStackIndex--;
      _ProgramStack[_ProgramStackIndex]->SetCalculator(this);
      _ProgramStack[_ProgramStackIndex]->SetPopFromStack(false);

      delete _ProgramStack[_ProgramStackIndex];
      _ProgramStack[_ProgramStackIndex] = NULL;

      TopProgramStack();
    }
    else
    {
      _ProgramStack[_ProgramStackIndex-1] = NULL;

      // decrementing of _ProgramStackIndex deferred to SetExecProgramPopped method and
      // not done for a non-deletion option unless DecrIndex_ specifically set to true
      if (DecrIndex_ || PopAndDelete_)
      {
        _ProgramStackIndex--;
        TopProgramStack();
      }
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForProgram(this);
      _ChildPtr = NULL;
    }

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::TopProgramStack()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->TopProgramStack();
  }

  if (_ProgramStackIndex)
  {
    _Program = _ProgramStack[_ProgramStackIndex - 1];

    if (!_Program && _ProgramStackIndex > 1 && _ProgramStack[_ProgramStackIndex - 2])
    {
      _Program = _ProgramStack[_ProgramStackIndex - 2];
      _ProgramStackIndex--;
    }

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForProgram(this);
      _ChildPtr = NULL;
    }
  }
  else
    _Program = NULL;

  return _Program;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::ResizeProgramStack()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->ResizeProgramStack();
  }
  else
  {
    // Resizing CalcProgram** pointer matrix
    CalcProgram** OldStack_ = _ProgramStack;
    long OldLimit_ = _ProgramStackLimit;

    _ProgramStackLimit += 20;
    _ProgramStack = (CalcProgram**)CalculatorBase::allocmem(_ProgramStackLimit, sizeof(CalcProgram*), _ProgramStack);

    long x;
    for (x = 0; x < OldLimit_; x++)
      _ProgramStack[x] = OldStack_[x];

    for (;x < _ProgramStackLimit; x++)
      _ProgramStack[x] = NULL;

    MemMatrix::Matrix().Deallocate(OldStack_);
    OldStack_ = NULL;

    // Resizing long* _ExecProgramActive: calc. program active/inactive status stack
    long* OldStatStk_ = _ExecProgramActive;
    _ExecProgramActive = (long*)CalculatorBase::allocmem((2 * _ProgramStackLimit), sizeof(long), _ExecProgramActive);
    OldLimit_ *= 2;

    ::memset(_ExecProgramActive, 0, (2 * _ProgramStackLimit) * sizeof(long));
    ::memmove(_ExecProgramActive, OldStatStk_, OldLimit_ * sizeof(long));

    MemMatrix::Matrix().Deallocate(OldStatStk_);
    OldStatStk_ = NULL;

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForProgram(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
long LineCalculator<T>::ProgramStackSize() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProgramStackSize();

  return _ProgramStackLimit;
}

/*****************************************************************************/
template <class T>
long LineCalculator<T>::ProgramStackIndex() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProgramStackIndex();

  return _ProgramStackIndex;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::AtLowestProgramLevel(int Level_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->AtLowestProgramLevel(Level_);

  return
  (
    Level_ == 0 &&
    _ProgramStackIndex == 0 &&
    !_ActiveProgram
  );
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::TransferVarsForProgram(CalculatorBase* ptr)
{
  // long _ProgramStackIndex;            // index to calc. program active/inactive status stack
  // long _ProgramStackLimit;            // Calc. program active/inactive status stack limit
  // long _ProgramID;                    // Program ID of CalcProgram object most recently pushed onto CalcProgram stack
  // long _NewProgramID;                 // Program ID of newly created CalcProgram object
  // long* _ExecProgramActive;           // Calc. program active/inactive status stack
  // CalcProgram** _ProgramStack;        // Pointer stack of CalcProgram objects
  // CalcProgram* _Program;              // Pointer into CalcProgram object stack
  // CalcProgram* _NewProgram;           // newly created pointer to CalcProgram object
  // ProgramStack* _ActiveProgram;       // Pointer to the top of ProgramStack
  //
  LineCalculator<T>* dptr = ptr ? ((LineCalculator<T>*)ptr):NULL;
  LineCalculator<T>* hptr = ((LineCalculator<T>*)this);

  if (dptr && _ParentPtr && dptr != hptr && _ParentPtr != hptr)
  {
    _ProgramStackIndex = dptr->_ProgramStackIndex;
    _ProgramStackLimit = dptr->_ProgramStackLimit;
    _ProgramID = dptr->_ProgramID;
    _NewProgramID = dptr->_NewProgramID;
    _PrevProgramID = dptr->_PrevProgramID;
    _ExecProgramActive = dptr->_ExecProgramActive;
    _ProgramStack = dptr->_ProgramStack;
    _Program = dptr->_Program;
    _NewProgram = dptr->_NewProgram;
    _ActiveProgram = dptr->_ActiveProgram;

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::AssignToNullVarsForProgram()
{
  _ProgramStackIndex = 0;
  _ProgramStackLimit = 0;
  _ProgramID =
  _NewProgramID =
  _PrevProgramID = 0;
  _ExecProgramActive = NULL;
  _ProgramStack = NULL;
  _Program = NULL;
  _NewProgram = NULL;
  _ActiveProgram = NULL;
}

/*****************************************************************************/
template <class T>
bool LineCalculator<T>::ResetProgramID(bool ResetPrevID_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (_ParentPtr->ResetProgramID(ResetPrevID_))
    {
      _ProgramID = 0;
      if (ResetPrevID_)
        _PrevProgramID = 0;

      return true;
    }
  }
  else if (_ProgramStackIndex == 0)
  {
    _ProgramID = 0;
    if (ResetPrevID_)
      _PrevProgramID = 0;

    return true;
  }

  return false;
}

/*****************************************************************************/
// Calc. Program stack: -- PointerStack<CalcProgram> methods
/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::ActiveProgram(bool* HasData_, int seqno)
{
  ProgramStack* PrevProgram_ = NULL;
  CalcProgram* ProgPtr_ = NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveProgram(HasData_, seqno);

  PrevProgram_ = _ActiveProgram;

  while (seqno < 0 && PrevProgram_)
  {
    PrevProgram_ = PrevProgram_->Next();
    ProgPtr_ = ProgramStack::ActiveData(PrevProgram_);

    if (ProgPtr_ && PrevProgram_)
      ++seqno;
    else
      break;
  }

  return ((seqno == 0) ?
             ProgramStack::ActiveData(PrevProgram_, HasData_):NULL);
}

/*****************************************************************************/
template <class T>
const CalcProgram* LineCalculator<T>::ActiveProgram(bool* HasData_, int seqno) const
{
  const ProgramStack* PrevProgram_ = NULL;
  const CalcProgram* ProgPtr_ = NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveProgram(HasData_, seqno);

  PrevProgram_ = _ActiveProgram;

  while (seqno < 0 && PrevProgram_)
  {
    PrevProgram_ = PrevProgram_->Next();
    ProgPtr_ = ProgramStack::ActiveData(PrevProgram_);

    if (ProgPtr_ && PrevProgram_)
      ++seqno;
    else
      break;
  }

  return ((seqno == 0) ?
             ProgramStack::ActiveData(PrevProgram_, HasData_):NULL);
}

/*****************************************************************************/
template <class T>
const CalcProgram* LineCalculator<T>::ActiveConstProgram(bool* HasData_, int seqno) const
{
  const ProgramStack* PrevProgram_ = NULL;
  const CalcProgram* ProgPtr_ = NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ActiveConstProgram(HasData_, seqno);

  PrevProgram_ = _ActiveProgram;

  while (seqno < 0 && PrevProgram_)
  {
    PrevProgram_ = PrevProgram_->Next();
    ProgPtr_ = ProgramStack::ActiveConstData(PrevProgram_);

    if (ProgPtr_ && PrevProgram_)
      ++seqno;
    else
      break;
  }

  return ((seqno == 0) ?
             ProgramStack::ActiveConstData(PrevProgram_, HasData_):NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PushActiveProgram(CalcProgram* Ptr_)
{
  if (Ptr_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      _ParentPtr->SetChild(this);
      return _ParentPtr->PushActiveProgram(Ptr_);
    }
    else
    {
      ProgramStack* New_ = new ProgramStack;
      CalculatorBase* CalcPtr_ = Ptr_->GetCalculator();

      if (New_ && CalcPtr_)
      {
        New_->Push(_ActiveProgram);
        New_->Set(Ptr_);
        _ActiveProgram = New_;

        if (CalcPtr_ != ((CalculatorBase*)this))
          CalcPtr_->TransferVarsForProgram(this);

        Ptr_->SetExecProgramPopped(FALSE);

        if (_ChildPtr)
        {
          _ChildPtr->TransferVarsForProgram(this);
          _ChildPtr = NULL;
        }

        return TRUE;
      }
    }
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PopActiveProgram(int PopAndDelete_, bool SetExecLevel_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    return _ParentPtr->PopActiveProgram(PopAndDelete_);
  }
  else if (_ActiveProgram)
  {
    CalcProgram* ProgPtr_ = ProgramStack::ActiveData(_ActiveProgram);
    ProgramStack* Top_ = _ActiveProgram;
    CalculatorBase* CalcPtr_ = ProgPtr_ ? ProgPtr_->GetCalculator():NULL;

    if (_ActiveProgram)
      _ActiveProgram = _ActiveProgram->Next();

    if (Top_)
    {
      if (PopAndDelete_)
      {
        ProgPtr_ = Top_->GiveData();
        if (ProgPtr_)
          ProgPtr_->SetPopFromStack(true);

        if (CalcPtr_ && CalcPtr_ != ((CalculatorBase*)this))
          CalcPtr_->TransferVarsForProgram(this);

        Top_->PopDelete();

        if (SetExecLevel_)
        {
          _BatchExecLevel--;

          if (_BatchExecLevel &&
              !_ExecuteProgram && !ActiveProgram(NULL, 0))
            _BatchExecLevel = 0;
        }
      }
      else
      {
        Top_->Set(NULL);
        Top_->Pop();

        if (ProgPtr_ && !ProgPtr_->Destroyed())
        {
          if (CalcPtr_)
          {
            if (TopProgramStack() == ProgPtr_)
              CalcPtr_->PopProgramStack(FALSE);

            if (CalcPtr_ != ((CalculatorBase*)this))
              CalcPtr_->TransferVarsForProgram(this);
          }

          ProgPtr_->SetExecProgramPopped(TRUE);
        }

        if (SetExecLevel_)
        {
          _BatchExecLevel--;

          if (_BatchExecLevel &&
              !_ExecuteProgram && !ActiveProgram(NULL, 0))
            _BatchExecLevel = 0;
        }
      }

      if (_ChildPtr)
      {
        _ChildPtr->TransferVarsForProgram(this);
        _ChildPtr = NULL;
      }

      if (MemMatrix::Matrix().HasThis(Top_))
        delete Top_;

      return TRUE;
    }
  }

  return FALSE;
}

/*****************************************************************************/
// Calc. Program stack: -- long* program ID and program active/inactive status methods
/*****************************************************************************/
template <class T>
int LineCalculator<T>::ExecProgramPopped(long IdVal_) const
{
  const CalcProgram* Program_ = InProgramMode(true) ? ActiveProgram():NULL;
  long IDvalx_ = (!IdVal_ && Program_) ? Program_->GiveProgramID():IdVal_;
  long index_;
  long max;

  if (IDvalx_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      return _ParentPtr->ExecProgramPopped(IdVal_);
    else
    {
      max = 2 * _ProgramStackLimit - 2;
      index_ = 2 * _ProgramStackIndex;

      if (InRange(0L, index_, max)  && _ExecProgramActive[index_] == IDvalx_)
        return (!_ExecProgramActive[index_+1]);
      else if (InRange(2L, index_, max) && _ExecProgramActive[index_-2] == IDvalx_)
        return (!_ExecProgramActive[index_-1]);
      else
        return TRUE;   // Entry not found. Assumed to be popped.
    }
  }

  return FALSE;   // return FALSE for zero value ID
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SetExecProgramPopped(long flag_, long IdVal_)
{
  CalcProgram* Program_ = InProgramMode(true) ? ActiveProgram():NULL;
  long IDvalx_ = (!flag_ && !IdVal_ && Program_) ? Program_->GiveProgramID():IdVal_;
  long index_;
  long prvindex_;
  long max;
  int ret = FALSE;

  #if CALCLIB_TESTASYNCMODE2c
    ChrString ProgIDstr_("\nLineCalculator<T>::SetExecProgramPopped");
  #endif

  if (IDvalx_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      _ParentPtr->SetChild(this);
      return _ParentPtr->SetExecProgramPopped(flag_, IdVal_);
    }
    else
    {
      max = 2 * _ProgramStackLimit - 2;
      index_ = 2 * _ProgramStackIndex;

      if (flag_ && InRange(0L, index_, max) && _ExecProgramActive[index_] == IDvalx_)
      {
        _ExecProgramActive[index_+1] = !flag_;
        _ProgramID = (index_ >= 2) ? _ExecProgramActive[index_-2]:0;

        if (index_ > 2)
        {
          prvindex_ = 2 * (_ProgramStackIndex-1);

          if (InRange(0L, prvindex_, max))
            _PrevProgramID = (prvindex_ >= 2) ? _ExecProgramActive[prvindex_-2]:0;
        }
        else if (_ProgramStackIndex == 0)
          _PrevProgramID = 0;

        #if CALCLIB_TESTASYNCMODE2c
          ProgIDstr_ += ChrString("\n\tPrevProgID:");
          ProgIDstr_ += LongInt::ToString(LongInt(_PrevProgramID));
          ProgIDstr_ += ChrString("\n\tProgID:");
          ProgIDstr_ += LongInt::ToString(LongInt(_ProgramID));
          ProgIDstr_ += ChrString("\n");

          DisplayToLog(ProgIDstr_.c_str());
        #endif

        ret = TRUE;
      }
      else if (flag_ && InRange(2L, index_, max) && _ExecProgramActive[index_-2] == IDvalx_)
      {
        --_ProgramStackIndex;
        _ExecProgramActive[index_-1] = !flag_;
        _ProgramID = (index_ >= 2) ? _ExecProgramActive[index_-2]:0;
        TopProgramStack();

        if (index_ > 2)
        {
          prvindex_ = 2 * _ProgramStackIndex;

          if (InRange(0L, prvindex_, max))
            _PrevProgramID = (prvindex_ >= 2) ? _ExecProgramActive[prvindex_-2]:0;
        }
        else if (_ProgramStackIndex == 0)
          _PrevProgramID = 0;

        #if CALCLIB_TESTASYNCMODE2c
          ProgIDstr_ += ChrString("\n\tPrevProgID:");
          ProgIDstr_ += LongInt::ToString(LongInt(_PrevProgramID));
          ProgIDstr_ += ChrString("\n\tProgID:");
          ProgIDstr_ += LongInt::ToString(LongInt(_ProgramID));
          ProgIDstr_ += ChrString("\n");

          DisplayToLog(ProgIDstr_.c_str());
        #endif

        ret = TRUE;
      }
      else if (!flag_ && InRange(0L, index_, max))
      {
        _ExecProgramActive[index_] = IDvalx_;
        _ExecProgramActive[index_+1] = !flag_;
        ++_ProgramStackIndex;
        TopProgramStack();

        if (_ProgramID && Program_ && Program_->GiveProgramID() != IDvalx_)
        {
          _NewProgramID = _ProgramID;
          _ProgramID = 0;
        }

        ret = TRUE;
      }

      if (_ChildPtr && ret)
      {
        _ChildPtr->TransferVarsForProgram(this);
        _ChildPtr = NULL;
      }
    }
  }

  return ret;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ResetExecProgramPopped(long IdVal_)
{
  CalcProgram* Program_ = InProgramMode(true) ? ActiveProgram():NULL;
  long IDvalx_ = (!IdVal_ && Program_) ? Program_->GiveProgramID():IdVal_;
  long index_;
  long max;
  int ret = FALSE;

  if (IDvalx_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      _ParentPtr->SetChild(this);
      return _ParentPtr->ResetExecProgramPopped(IdVal_);
    }
    else
    {
      max = 2 * _ProgramStackLimit - 2;
      index_ = 2 * _ProgramStackIndex;

      if (InRange(0L, index_, max) && _ExecProgramActive[index_] == IDvalx_)
        if (!_ExecProgramActive[index_+1])
        {
          _ExecProgramActive[index_] = 0;
          ret = TRUE;
        }

      if (_ChildPtr && ret)
      {
        _ChildPtr->TransferVarsForProgram(this);
        _ChildPtr = NULL;
      }
    }
  }

  return ret;
}

/*****************************************************************************/
template <class T>
CalcProgram* LineCalculator<T>::FindProgramFromID(long IdVal_, bool CheckActive_)
{
  CalcProgram* Program_ = InProgramMode(true) ? ActiveProgram():NULL;
  long IDvalx_ = (!IdVal_ && Program_) ? Program_->GiveProgramID():IdVal_;
  long Limit_ = 2 * _ProgramStackLimit;
  long max = 2 * _ProgramStackIndex;
  long x;

  if (IDvalx_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      return _ParentPtr->FindProgramFromID(IdVal_, CheckActive_);
    else
    {
      if (max >= Limit_)
        max = Limit_ - 2;

      for (x = 0; x <= max; x+=2)
        if (_ExecProgramActive[x] == IDvalx_ &&
            (_ExecProgramActive[x+1] || !CheckActive_))
          return FindProgramFromIndex(x/2);
    }
  }

  return NULL;
}

/*****************************************************************************/
template <class T>
const CalcProgram* LineCalculator<T>::FindProgramFromID(long IdVal_, bool CheckActive_) const
{
  const CalcProgram* Program_ = InProgramMode(true) ? ActiveProgram():NULL;
  long IDvalx_ = (!IdVal_ && Program_) ? Program_->GiveProgramID():IdVal_;
  long Limit_ = 2 * _ProgramStackLimit;
  long max = 2 * _ProgramStackIndex;
  long x;

  if (IDvalx_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      return _ParentPtr->FindProgramFromID(IdVal_, CheckActive_);
    else
    {
      if (max >= Limit_)
        max = Limit_ - 2;

      for (x = 0; x <= max; x+=2)
        if (_ExecProgramActive[x] == IDvalx_ &&
            (_ExecProgramActive[x+1] || !CheckActive_))
          return FindProgramFromIndex(x/2);
    }
  }

  return NULL;
}

/*****************************************************************************/
template <class T>
long LineCalculator<T>::GiveProgramID() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GiveProgramID();

  return _ProgramID;
}

/*****************************************************************************/
template <class T>
long LineCalculator<T>::GivePrevProgramID() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GivePrevProgramID();

  return _PrevProgramID;
}

/*****************************************************************************/
/*****************************************************************************/
template <class T>
char* LineCalculator<T>::ConvertFloatToFraction(char* Float_)
{
  LongNumber Frac_;
  LongNumber Int_;
  LongNumber FltNum_ = ChrString(Float_);
  Frac_ = FltNum_.modf(Int_);

  LongNumber Tens_(10L);
  Tens_ = LongNumber::IntPow(Tens_, Frac_.TotalDigits());
  FltNum_ *= Tens_;
  ChrString RetStr_ = FltNum_.ToString();
  RetStr_ += "/";
  RetStr_ += Tens_.ToString();

  char* FractStr_ = NULL;
  FractStr_ = (char*)allocmem(RetStr_.strlen() + 1, sizeof(char), FractStr_);
  ::SafeStrCpy(FractStr_, RetStr_.c_str());
  _MemDel->DelayedDeleteCstr(Float_, STOREMEM);
  return FractStr_;
}

/*****************************************************************************/
template <class T>
char* LineCalculator<T>::ConvertIntegerToFraction(char* Int_)
{
  char* FractStr_ = NULL;
  FractStr_ = (char*)allocmem(::SafeStrLen(Int_) + 3, sizeof(char), FractStr_);
  ::SafeStrCpy(FractStr_, Int_);
  strcat(FractStr_, "/1");
  _MemDel->DelayedDeleteCstr(Int_, STOREMEM);
  return FractStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindFractionArithmetic(int NumParams_, FncParameter** ParamArray_)
{
  char* Ptr_;
  char* Temp_;
  char** Data_ = NULL;
  LongNumber** Denom_;
  LongNumber** Numer_;
  LongNumber Lcm_;
  LongNumber Gcd_;
  LongNumber Mult_;
  LongNumber FirstNumer_;
  LongNumber FirstDenom_;
  LongNumber TotalNumer_;
  LongNumber TotalDenom_;
  ChrString Frac_;
  ChrString Str1_;
  ChrString Str2_;
  int Optype_;
  int NumOperands_ = NumParams_ - 1;
  int x, y;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Frac_;

  Data_ = (char**)allocmem(NumParams_, sizeof(char*), Data_);
  Denom_ = (LongNumber**)allocmem(NumParams_, sizeof(LongNumber*), Data_);
  Numer_ = (LongNumber**)allocmem(NumParams_, sizeof(LongNumber*), Data_);
  const char* OptypeStr_ = ParamArray_[0]->_Param->GetExpression();
  if (OptypeStr_)
  {
    Optype_ = (icasestrcomp(OptypeStr_, "Add")      || icasestrcomp(OptypeStr_, "+")) ? Mcalc_OperatorType::Add:
              (icasestrcomp(OptypeStr_, "Subtract") || icasestrcomp(OptypeStr_, "-")) ? Mcalc_OperatorType::Subtract:
              (icasestrcomp(OptypeStr_, "Multiply") || icasestrcomp(OptypeStr_, "*")) ? Mcalc_OperatorType::Multiply:
              (icasestrcomp(OptypeStr_, "Divide")   || icasestrcomp(OptypeStr_, "/")) ? Mcalc_OperatorType::Divide:0;
  }
  else
    Optype_ = 0;

  if (!Optype_ || NumParams_ == 1)
    if (strchr(OptypeStr_, ','))
    {
      if (NumParams_ == 1)
      {
        MemMatrix::Matrix().Deallocate(Denom_);
        MemMatrix::Matrix().Deallocate(Numer_);

        ChrString ArgStr_ = ChrString("FRAC(") + ChrString(OptypeStr_) + ChrString(")");
        ChrString AnswerStr_ = ReEvaluate(ArgStr_);
        ResetAnswerMode();
        SetAnswerMode(CalculatorBase::FRACTION_MODE);

        Data_[0] = ::NewString(AnswerStr_.c_str());
        Ptr_ = strchr(Data_[0], '/');

        if (Ptr_)
        {
          Str1_ = &Ptr_[1];
          Str2_ = ChrString(Data_[0], Ptr_ - Data_[0]);
          Str1_.RemovePadding(" \t\n\r");
          Str2_.RemovePadding(" \t\n\r");

          int ValidNum1_ = IsNumber(Str1_.c_str(), 1, 0, 0, 10);
          int ValidNum2_ = IsNumber(Str2_.c_str(), 1, 0, 0, 10);

          if (ValidNum1_ && ValidNum2_)
          {
            TotalNumer_ = Str2_;
            TotalDenom_ = Str1_;

            if (!TotalDenom_.AtZero())
            {
              TotalNumer_ /= TotalDenom_;

              if (TotalNumer_.AtZero())
                SetFractionStr("0");
              else
                SetFractionStr(AnswerStr_.c_str());

              AnswerStr_ = TotalNumer_.ToString();
            }
            else
              AnswerStr_ = ShowFracDivZero(TotalNumer_, TotalDenom_);
          }
        }

        MemMatrix::Matrix().Deallocate(Data_[0]);
        MemMatrix::Matrix().Deallocate(Data_);
        return AnswerStr_;
      }

    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "FRAC");
    CloseGuiOutputFile();
    return Frac_;
  }

  for (x = 1; x < NumParams_; x++)
  {
    y = x - 1;
    Data_[y] = ::NewString(ParamArray_[x]->_Param->GetExpression());
    Denom_[y] = new LongNumber();
    Numer_[y] = new LongNumber();
  }

  for (x = 0; x < NumOperands_; x++)
  {
    Ptr_ = strchr(Data_[x], '/');

    if (!Ptr_)
    {
      Mult_ = Data_[x];
      if (IsFloat(Data_[x]))
      {
        Data_[x] = ConvertFloatToFraction(Data_[x]);
        Ptr_ = strchr(Data_[x], '/');
      }
      else if (LongNumber::IsInSciNote(Mult_))
      {
        Temp_ = Data_[x];
        Mult_.SetSciNotation(FALSE);
        Str1_ = Mult_.ToString();
        Data_[x] = ::NewString(Str1_.c_str());
        MemMatrix::Matrix().Deallocate(Temp_);

        if (IsFloat(Data_[x]))
        {
          Data_[x] = ConvertFloatToFraction(Data_[x]);
          Ptr_ = strchr(Data_[x], '/');
        }
        else if (::IsNumber(Data_[x], 1, 0, 0, 10))
        {
          Data_[x] = ConvertIntegerToFraction(Data_[x]);
          Ptr_ = strchr(Data_[x], '/');
        }
      }
      else if (::IsNumber(Data_[x], 1, 0, 0, 10))
      {
        Data_[x] = ConvertIntegerToFraction(Data_[x]);
        Ptr_ = strchr(Data_[x], '/');
      }
    }

    if (!Ptr_)
    {
      DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                          ERRMSG_INVALID_TYPEARGS, "FRAC");
      CloseGuiOutputFile();
      return Frac_;
    }

    Str1_ = &Ptr_[1];
    Str2_ = ChrString(Data_[x], Ptr_ - Data_[x]);
    Str1_.RemovePadding(" \t\n\r");
    Str2_.RemovePadding(" \t\n\r");

    int ValidNum1_ = IsNumber(Str1_.c_str(), 1, 0, 0, 10);
    int ValidNum2_ = IsNumber(Str2_.c_str(), 1, 0, 0, 10);

    if (!ValidNum1_ || !ValidNum2_)
    {
      for (;;)
        if (IsFloat(Str1_.c_str()))
        {
          Temp_ = ::NewString(Str1_.c_str());
          Temp_= ConvertFloatToFraction(Temp_);
          Str1_ = Temp_;
          MemMatrix::Matrix().Deallocate(Temp_);
          ValidNum1_ = IsNumber(Str1_.c_str(), 1, 0, 0, 10);
          break;
        }
        else if (LongNumber::IsInSciNote(Str1_.c_str()))
        {
          Mult_ = Str1_;
          Mult_.SetSciNotation(FALSE);
          Str1_ = Mult_.ToString();
          ValidNum1_ = IsNumber(Str1_.c_str(), 1, 0, 0, 10);
          if (ValidNum1_)
            break;
        }
        else
          break;

      for (;;)
        if (IsFloat(Str2_.c_str()))
        {
          Temp_ = ::NewString(Str2_.c_str());
          Temp_= ConvertFloatToFraction(Temp_);
          Str2_ = Temp_;
          MemMatrix::Matrix().Deallocate(Temp_);
          ValidNum2_ = IsNumber(Str2_.c_str(), 1, 0, 0, 10);
          break;
        }
        else if (LongNumber::IsInSciNote(Str2_.c_str()))
        {
          Mult_ = Str2_;
          Mult_.SetSciNotation(FALSE);
          Str2_ = Mult_.ToString();
          ValidNum2_ = IsNumber(Str2_.c_str(), 1, 0, 0, 10);
          if (ValidNum2_)
            break;
        }
        else
          break;

      if (!ValidNum1_ || !ValidNum2_)
      {
        DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                            ERRMSG_INVALID_TYPEARGS, "FRAC");
        CloseGuiOutputFile();
        return Frac_;
      }
    }

    Str1_.RemovePadding(" \t\n\r");
    Str2_.RemovePadding(" \t\n\r");

    *Numer_[x] = Str2_;
    *Denom_[x] = Str1_;

    if (Denom_[x]->AtZero())
    {
      DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_DIVISION_BY_ZERO,
                          ERRMSG_DIVISION_BY_ZERO, "FRAC");
      CloseGuiOutputFile();
      return Frac_;
    }

    if (Optype_ == Mcalc_OperatorType::Add ||
        Optype_ == Mcalc_OperatorType::Subtract)
    {
      if (x)
        if (x > 1)
          Lcm_ = Discrete<LongNumber>::LCM(Lcm_, *Denom_[x]);
        else
          Lcm_ = Discrete<LongNumber>::LCM(*Denom_[0], *Denom_[1]);
    }
  }

  if (Optype_ == Mcalc_OperatorType::Add ||
      Optype_ == Mcalc_OperatorType::Subtract)
  {
    if (Optype_ == Mcalc_OperatorType::Subtract)
    {
      x = 1;
      Mult_ = Lcm_ / *Denom_[0];
      *Numer_[0] *= Mult_;
      FirstNumer_ = *Numer_[0];
    }
    else
      x = 0;

    for (;x < NumOperands_; x++)
    {
      Mult_ = Lcm_ / *Denom_[x];
      *Numer_[x] *= Mult_;

      if (Optype_ == Mcalc_OperatorType::Add)
        TotalNumer_ += *Numer_[x];
      else
        TotalNumer_ += -(*Numer_[x]);
    }

    if (Optype_ == Mcalc_OperatorType::Subtract)
      TotalNumer_ += FirstNumer_;

    // Reducing
    bool valid_ = true;
    if (TotalNumer_.AtZero())
      Frac_ = "0";
    else
    {
      valid_ = false;
      Gcd_ = Discrete<LongNumber>::GCD(TotalNumer_, Lcm_);

      if (!Gcd_.AtZero())
      {
        TotalNumer_ /= Gcd_;
        Lcm_ /= Gcd_;

        Frac_ = TotalNumer_.ToString();
        Frac_ += "/";
        Frac_ += Lcm_.ToString();

        if (!Lcm_.AtZero())
        {
          TotalNumer_ /= Lcm_;
          valid_ = true;
        }
        else
          TotalDenom_ = Lcm_;
      }
      else
        TotalDenom_ = Gcd_;
    }

    if (!valid_)
      TotalNumer_ = ShowFracDivZero(TotalNumer_, TotalDenom_);
    else
      SetFractionStr(Frac_.c_str());
  }
  else
  {
    if (Optype_ == Mcalc_OperatorType::Divide)
    {
      x = 1;
      FirstNumer_ = *Numer_[0];
      FirstDenom_ = *Denom_[0];
    }
    else
      x = 0;

    TotalNumer_ = 1L;
    TotalDenom_ = 1L;

    for (;x < NumOperands_; x++)
    {
      TotalNumer_ *= *Numer_[x];
      TotalDenom_ *= *Denom_[x];
    }

    if (Optype_ == Mcalc_OperatorType::Divide)
    {
      TotalDenom_ *= FirstNumer_;
      TotalNumer_ *= FirstDenom_;
      Mult_ = TotalNumer_;
      TotalNumer_ = TotalDenom_;
      TotalDenom_ = Mult_;

      if (TotalDenom_.AtZero())
      {
        DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_DIVISION_BY_ZERO,
                            ERRMSG_DIVISION_BY_ZERO, "FRAC");
        CloseGuiOutputFile();
        return Frac_;
      }
    }

    // Reducing
    bool valid_ = true;
    if (TotalNumer_.AtZero())
      Frac_ = "0";
    else
    {
      valid_ = false;
      Gcd_ = Discrete<LongNumber>::GCD(TotalNumer_, TotalDenom_);

      if (!Gcd_.AtZero())
      {
        TotalNumer_ /= Gcd_;
        TotalDenom_ /= Gcd_;

        Frac_ = TotalNumer_.ToString();
        Frac_ += "/";
        Frac_ += TotalDenom_.ToString();

        if (!TotalDenom_.AtZero())
        {
          TotalNumer_ /= TotalDenom_;
          valid_ = true;
        }
      }
      else
        TotalDenom_ = Gcd_;
    }

    if (!valid_)
      TotalNumer_ = ShowFracDivZero(TotalNumer_, TotalDenom_);
    else
      SetFractionStr(Frac_.c_str());
  }

  for (x = 0; x < NumOperands_; x++)
  {
    MemMatrix::Matrix().Deallocate(Data_[x]);

    if (MemMatrix::Matrix().HasThis(Denom_[x]))
      delete Denom_[x];

    if (MemMatrix::Matrix().HasThis(Numer_[x]))
      delete Numer_[x];
  }

  MemMatrix::Matrix().Deallocate(Data_);
  MemMatrix::Matrix().Deallocate(Denom_);
  MemMatrix::Matrix().Deallocate(Numer_);

  return TotalNumer_.ToString();
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::CreateSet(int NumParams_, FncParameter** ParamArray_)
{
  int x;
  ChrString Result_;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Result_;

  const char* Buffer_ = ParamArray_[0]->_Param->GetExpression();
  ChrString FirstArg_ = Buffer_;
  FirstArg_.RemovePadding(" \t\n\r");
  SetHasAnswer(FALSE);

  ChrString ArgStr_;
  ChrString AnswerStr_;
  ChrString AssignStr_('$');
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;
  int IsNull_ = 0;

  if (NumParams_ == 1 || !IsNumber(ParamArray_[1]->_Param->GetExpression(), 0, 0, 0, 10))
  {
    if ((NumParams_ == 1 && isalpha(Buffer_[0]) && FirstArg_.strlen() == 1) || strchr(Buffer_, ','))
    {
      if (isalpha(Buffer_[0]) && FirstArg_.strlen() == 1)
      {
        AnswerStr_ = ChrString("{ null }");
        IsNull_ = 1;
      }
      else
      {
        ArgStr_ = ChrString("SET(") + ChrString(Buffer_) + ChrString(")");
        AnswerStr_ = ReEvaluate(ArgStr_);
      }

      AssignStr_ += ChrString(Buffer_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      return AnswerStr_;
    }
    else if (InSetNotation(ParamArray_[1]->_Param->GetExpression()) &&
             isalpha(Buffer_[0]) && FirstArg_.strlen() == 1)
    {
      Set<int>* Set_ = MakeIntSet(ParamArray_[1]->_Param->GetExpression());
      if (Set_)
        AnswerStr_ = MakeTheList(Set_->GiveSetData());

      if (MemMatrix::Matrix().HasThis(Set_))
        delete Set_;

      AssignStr_ += ChrString(Buffer_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      return AnswerStr_;
    }
    else if (isalpha(Buffer_[0]) && FirstArg_.strlen() == 1)
    {
      ChrString Expr_ = ParamArray_[1]->_Param->GetExpression();
      Expr_.RemovePadding(" \t\n\r");

      if (Expr_.strlen() == 1 && isalpha(Expr_[0]))
      {
        AnswerStr_ = CalcPtr_->GetStrVariable(tolower(Expr_[0]) - 'a');
        AssignStr_ += ChrString(Buffer_[0]);
        AssignStr_ += ChrString('=');
        SetHasAnswer(AnswerStr_.strlen());

        if (AnswerStr_.strlen())
        {
          IsNull_ = IsNullSetStr(AnswerStr_.c_str());
          AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
          Result_ = AssignStr_ + AnswerStr_;
          SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
          ReEvaluate(Result_.c_str());

          SetAnswerMode(LITERAL_MODE, TRUE);
          SetLiteralStr(AnswerStr_.c_str());
        }

        return AnswerStr_;
      }
      else
      {
        ifstream Fin_;

        if (FileReader::Fexists(Expr_.c_str()) && FileStreamOpen(Fin_, Expr_.c_str()))
        {
          Set<int>* Set_;
          Boolean Error_;

          Set_ = new Set<int>(Fin_, Error_);
          Fin_.close();

          if (Error_)
          {
            if (Set_)
              Set_->Flush();

            SetAnswerMode(LITERAL_MODE, TRUE);
            SetLiteralStr("");
            SetHasAnswer(FALSE);

            if (MemMatrix::Matrix().HasThis(Set_))
              delete Set_;

            DisplayErrorMessage(GetOutputFile(), Mcalc_Error::ERRVAL_EMPTY_DATASET,
                                ERRMSG_EMPTY_DATASET, "SET");
            return AnswerStr_;
          }

          if (Set_)
            AnswerStr_ = MakeTheList(Set_->GiveSetData());

          if (MemMatrix::Matrix().HasThis(Set_))
            delete Set_;

          AssignStr_ += ChrString(Buffer_[0]);
          AssignStr_ += ChrString('=');
          SetHasAnswer(AnswerStr_.strlen());

          if (AnswerStr_.strlen())
          {
            IsNull_ = IsNullSetStr(AnswerStr_.c_str());
            AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
            Result_ = AssignStr_ + AnswerStr_;
            SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
            ReEvaluate(Result_.c_str());

            SetAnswerMode(LITERAL_MODE, TRUE);
            SetLiteralStr(AnswerStr_.c_str());
          }

          return AnswerStr_;
        }
        else
        {
          SetAnswerMode(LITERAL_MODE, TRUE);
          SetLiteralStr("");
          SetHasAnswer(FALSE);
        }
      }
    }
  }
  else if (isalpha(Buffer_[0]) && FirstArg_.strlen() == 1)
  {
    int Size_ = atoi(ParamArray_[1]->_Param->GetExpression());

    if (Size_ <= 0 || NumParams_ <= 2 || Size_ != NumParams_ - 2)
    {
      DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_ARGLIST_SIZE,
                          ERRMSG_ARGLIST_SIZE, "SET");
      CloseGuiOutputFile();

      SetAnswerMode(LITERAL_MODE, TRUE);
      SetLiteralStr("");
      SetHasAnswer(FALSE);
      return AnswerStr_;
    }

    if (Size_ && NumParams_)
    {
      Set<int>* Set_ = new Set<int>;

      size_t i;
      for (i = 2; (i-1) <= Size_; i++)
      {
        ArgStr_ = ParamArray_[i]->_Param->GetExpression();
        ArgStr_.RemovePadding(" \t\n\r");

        if (IsInt(ArgStr_.c_str()))
        {
          int Data_ = atoi(ArgStr_.c_str());
          *Set_ |= &Data_;
        }
      }

      if (Set_)
        AnswerStr_ = MakeTheList(Set_->GiveSetData());

      if (MemMatrix::Matrix().HasThis(Set_))
        delete Set_;

      AssignStr_ += ChrString(Buffer_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      return AnswerStr_;
    }
  }

  AnswerStr_[0] = 0;
  return AnswerStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindSetUnion(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Result_;
  SetHasAnswer(FALSE);
  int x;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Result_;

  if (NumParams_ != 3)
    return Result_;

  ChrString Expr0_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Expr1_ = ParamArray_[1]->_Param->GetExpression();
  ChrString Expr2_ = ParamArray_[2]->_Param->GetExpression();
  ChrString AssignStr_('$');
  ChrString AnswerStr_;

  int IsNull_;
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;

  Expr0_.RemovePadding(" \t\n\r");
  Expr1_.RemovePadding(" \t\n\r");
  Expr2_.RemovePadding(" \t\n\r");

  if (Expr0_.strlen() == 1 && isalpha(Expr0_[0]) &&
      Expr1_.strlen() == 1 && isalpha(Expr1_[0]) &&
      Expr2_.strlen() == 1 && isalpha(Expr2_[0]))
  {
    ChrString TrgSetStr_ = CalcPtr_->GetStrVariable(tolower(Expr0_[0]) - 'a');
    ChrString Set1Str_ = CalcPtr_->GetStrVariable(tolower(Expr1_[0]) - 'a');
    ChrString Set2Str_ = CalcPtr_->GetStrVariable(tolower(Expr2_[0]) - 'a');

    if (InSetNotation(Set1Str_.c_str()) &&
        InSetNotation(Set2Str_.c_str()))
    {
      Set<int>* TrgSet_ = new Set<int>;
      Set<int>* Set1_ = MakeIntSet(Set1Str_.c_str());
      Set<int>* Set2_ = MakeIntSet(Set2Str_.c_str());

      *TrgSet_ = *Set1_;
      *TrgSet_ |= *Set2_;

      if (TrgSet_)
        AnswerStr_ = MakeTheList(TrgSet_->GiveSetData());

      AssignStr_ += ChrString(Expr0_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      if (MemMatrix::Matrix().HasThis(TrgSet_))
        delete TrgSet_;

      if (MemMatrix::Matrix().HasThis(Set1_))
        delete Set1_;

      if (MemMatrix::Matrix().HasThis(Set2_))
        delete Set2_;
    }
  }

  return AnswerStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindSetIntersection(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Result_;
  SetHasAnswer(FALSE);
  int x;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Result_;

  if (NumParams_ != 3)
    return Result_;

  ChrString Expr0_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Expr1_ = ParamArray_[1]->_Param->GetExpression();
  ChrString Expr2_ = ParamArray_[2]->_Param->GetExpression();
  ChrString AssignStr_('$');
  ChrString AnswerStr_;

  int IsNull_;
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;

  Expr0_.RemovePadding(" \t\n\r");
  Expr1_.RemovePadding(" \t\n\r");
  Expr2_.RemovePadding(" \t\n\r");

  if (Expr0_.strlen() == 1 && isalpha(Expr0_[0]) &&
      Expr1_.strlen() == 1 && isalpha(Expr1_[0]) &&
      Expr2_.strlen() == 1 && isalpha(Expr2_[0]))
  {
    ChrString TrgSetStr_ = CalcPtr_->GetStrVariable(tolower(Expr0_[0]) - 'a');
    ChrString Set1Str_ = CalcPtr_->GetStrVariable(tolower(Expr1_[0]) - 'a');
    ChrString Set2Str_ = CalcPtr_->GetStrVariable(tolower(Expr2_[0]) - 'a');

    if (InSetNotation(Set1Str_.c_str()) &&
        InSetNotation(Set2Str_.c_str()))
    {
      Set<int>* TrgSet_ = new Set<int>;
      Set<int>* Set1_ = MakeIntSet(Set1Str_.c_str());
      Set<int>* Set2_ = MakeIntSet(Set2Str_.c_str());

      *TrgSet_ = *Set1_;
      *TrgSet_ &= *Set2_;

      if (TrgSet_)
        AnswerStr_ = MakeTheList(TrgSet_->GiveSetData());

      AssignStr_ += ChrString(Expr0_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      if (MemMatrix::Matrix().HasThis(TrgSet_))
        delete TrgSet_;

      if (MemMatrix::Matrix().HasThis(Set1_))
        delete Set1_;

      if (MemMatrix::Matrix().HasThis(Set2_))
        delete Set2_;
    }
  }

  return AnswerStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindSetDifference(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Result_;
  SetHasAnswer(FALSE);
  int x;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Result_;

  if (NumParams_ != 3)
    return Result_;

  ChrString Expr0_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Expr1_ = ParamArray_[1]->_Param->GetExpression();
  ChrString Expr2_ = ParamArray_[2]->_Param->GetExpression();
  ChrString AssignStr_('$');
  ChrString AnswerStr_;

  int IsNull_;
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;

  Expr0_.RemovePadding(" \t\n\r");
  Expr1_.RemovePadding(" \t\n\r");
  Expr2_.RemovePadding(" \t\n\r");

  if (Expr0_.strlen() == 1 && isalpha(Expr0_[0]) &&
      Expr1_.strlen() == 1 && isalpha(Expr1_[0]) &&
      Expr2_.strlen() == 1 && isalpha(Expr2_[0]))
  {
    ChrString TrgSetStr_ = CalcPtr_->GetStrVariable(tolower(Expr0_[0]) - 'a');
    ChrString Set1Str_ = CalcPtr_->GetStrVariable(tolower(Expr1_[0]) - 'a');
    ChrString Set2Str_ = CalcPtr_->GetStrVariable(tolower(Expr2_[0]) - 'a');

    if (InSetNotation(Set1Str_.c_str()) &&
        InSetNotation(Set2Str_.c_str()))
    {
      Set<int>* TrgSet_ = new Set<int>;
      Set<int>* Set1_ = MakeIntSet(Set1Str_.c_str());
      Set<int>* Set2_ = MakeIntSet(Set2Str_.c_str());

      *TrgSet_ = *Set1_;
      *TrgSet_ -= *Set2_;

      if (TrgSet_)
        AnswerStr_ = MakeTheList(TrgSet_->GiveSetData());

      AssignStr_ += ChrString(Expr0_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      if (MemMatrix::Matrix().HasThis(TrgSet_))
        delete TrgSet_;

      if (MemMatrix::Matrix().HasThis(Set1_))
        delete Set1_;

      if (MemMatrix::Matrix().HasThis(Set2_))
        delete Set2_;
    }
  }

  return AnswerStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindSetExclusion(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Result_;
  SetHasAnswer(FALSE);
  int x;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Result_;

  if (NumParams_ != 3)
    return Result_;

  ChrString Expr0_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Expr1_ = ParamArray_[1]->_Param->GetExpression();
  ChrString Expr2_ = ParamArray_[2]->_Param->GetExpression();
  ChrString AssignStr_('$');
  ChrString AnswerStr_;

  int IsNull_;
  CalculatorBase* CalcPtr_ = this;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = this;

  Expr0_.RemovePadding(" \t\n\r");
  Expr1_.RemovePadding(" \t\n\r");
  Expr2_.RemovePadding(" \t\n\r");

  if (Expr0_.strlen() == 1 && isalpha(Expr0_[0]) &&
      Expr1_.strlen() == 1 && isalpha(Expr1_[0]) &&
      Expr2_.strlen() == 1 && isalpha(Expr2_[0]))
  {
    ChrString TrgSetStr_ = CalcPtr_->GetStrVariable(tolower(Expr0_[0]) - 'a');
    ChrString Set1Str_ = CalcPtr_->GetStrVariable(tolower(Expr1_[0]) - 'a');
    ChrString Set2Str_ = CalcPtr_->GetStrVariable(tolower(Expr2_[0]) - 'a');

    if (InSetNotation(Set1Str_.c_str()) &&
        InSetNotation(Set2Str_.c_str()))
    {
      Set<int>* TrgSet_ = new Set<int>;
      Set<int>* NewSet_ = new Set<int>;
      Set<int>* Set1_ = MakeIntSet(Set1Str_.c_str());
      Set<int>* Set2_ = MakeIntSet(Set2Str_.c_str());

      *TrgSet_ = *Set1_;
      *TrgSet_ |= *Set2_;
      *NewSet_ = *Set1_;
      *NewSet_ &= *Set2_;
      *TrgSet_ -= *NewSet_;

      if (TrgSet_)
        AnswerStr_ = MakeTheList(TrgSet_->GiveSetData());

      AssignStr_ += ChrString(Expr0_[0]);
      AssignStr_ += ChrString('=');
      SetHasAnswer(AnswerStr_.strlen());

      if (AnswerStr_.strlen())
      {
        IsNull_ = IsNullSetStr(AnswerStr_.c_str());
        AnswerStr_ = ChrString("\"") + AnswerStr_ + ChrString("\"");
        Result_ = AssignStr_ + AnswerStr_;
        SetSetAssignment(TRUE, AnswerStr_.c_str(), IsNull_);
        ReEvaluate(Result_.c_str());

        SetAnswerMode(LITERAL_MODE, TRUE);
        SetLiteralStr(AnswerStr_.c_str());
      }

      if (MemMatrix::Matrix().HasThis(TrgSet_))
        delete TrgSet_;

      if (MemMatrix::Matrix().HasThis(NewSet_))
        delete NewSet_;

      if (MemMatrix::Matrix().HasThis(Set1_))
        delete Set1_;

      if (MemMatrix::Matrix().HasThis(Set2_))
        delete Set2_;
    }
  }

  return AnswerStr_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindPermutations(int NumParams_, FncParameter** ParamArray_)
{
  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->EnterLevel("LineCalculator<T>::FindPermutations");
  #endif

  int x;
  ChrString Answer_;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Answer_;

  if (!IsNumber(ParamArray_[0]->_Param->GetExpression(), 0, 0, 0, 10) || NumParams_ == 1)
  {
    const char* Buffer_ = ParamArray_[0]->_Param->GetExpression();
    if (strchr(Buffer_, ','))
    {
      if (NumParams_ == 1)
      {
        ChrString ArgStr_ = ChrString("ITEMPERM(") + ChrString(Buffer_) + ChrString(")");
        ChrString AnswerStr_ = ReEvaluate(ArgStr_);
        SetAnswerMode(LITERAL_MODE, TRUE);
        return AnswerStr_;
      }
    }

    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "ITEMPERM");
    CloseGuiOutputFile();
    return Answer_;
  }

  CalculatorBase* CalcPtr_ = this;
  int ProgramPopped_ = TRUE;
  int Sel_ = atoi(ParamArray_[0]->_Param->GetExpression());
  int Size_ = NumParams_ - 2;
  int HasIndex_ = atoi(ParamArray_[Size_ + 1]->_Param->GetExpression());
  int InAsync_ = InAsyncMode();
  int Interactive_ = 0;
  int ReturnAnswer_ = 0;
  int HasAnswer_ = 0;
  char Buffer_[8];
  ChrString TempStr_;

  int FileOk_ = 0;
  FILE* UserInput_ = NULL;
  DiscreteSet<int> Disc_(0);
  int* Data_ = NULL;
  int* RetData_;
  Data_ = (int*)allocmem(Size_, sizeof(int), Data_);

  for (x = 0; x < Size_; x++)
    Data_[x] = x + 1;

  if (Sel_ <= Size_)
  {
    int IntroDone_ = 0;
    int StdStreams_ = StdInput() && StdOutput();
    Interactive_ = (StdStreams_ || InAsync_) &&
                   !SessionOption() && !NoPauseFileInput() && !HasIndex_;
    ReturnAnswer_ = SessionOption() || NoPauseFileInput() || HasIndex_;
    CalcProgram* Program_;

    if (Interactive_ && InAsync_)
    {
      Program_ = new CalcProgram;

      if (Program_)
      {
        Program_->SetCalculator(CalcPtr_);
        PushActiveProgram(Program_);
        ProgramPopped_ = FALSE;
      }
    }

    const char* RetStr_;
    Disc_.Permute(Data_, Size_, Sel_);

    for (;;)
    {
      RetData_ = Disc_.NextPermutation();
      if (RetData_)
      {
        if (Interactive_ && !IntroDone_)
        {
          if (InAsync_)
            PromptAsyncUser(MSG_ENTER_TO_QUIT, PROMPT_DISPLAY);
          else
            fprintf(GetOutputFile(), MSG_ENTER_TO_QUIT_NL);
          IntroDone_ = 1;
        }

        TempStr_ = "";
        for (x = 0; x < Sel_; x++)
        {
          RetStr_ = ParamArray_[RetData_[x]]->_Param->GetExpression();
          if (Interactive_)
          {
            if (InAsync_)
            {
              TempStr_ += RetStr_;
              if (x == Sel_ - 1)
              {
		GetUserInputFile(true, true);
		UserInput_ = GiveFileStatus(Mcalc_IOType::UserInput, &FileOk_);
		if (FileOk_)
		{
		  fputs("x", UserInput_);
		  CloseUserInputFile(true);
		}

		TempStr_ += "\t";
                PromptAsyncUser(TempStr_.c_str(), PROMPT_INPUT);
              }
              else
                TempStr_ += ",";
            }
            else
            {
              fprintf(GetOutputFile(), "%s", RetStr_);
              if (x == Sel_ - 1)
                fprintf(GetOutputFile(), "\t");
              else
                fprintf(GetOutputFile(), ",", RetStr_);
            }
          }

          Answer_ += RetStr_;
          if (x == Sel_ - 1)
            Answer_ += "\n";
          else
            Answer_ += ",";
        }

        if (Interactive_)
        {
          if (InAsync_)
          {
            RetStr_ = ProgramStr();
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
            {
              ProgramPopped_ = TRUE;
              PopActiveProgram(true);
              break;
            }
          }
          else
          {
            RetStr_ = fgets(Buffer_, 8, stdin);
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
              break;
          }
        }
      }
      else
        break;
    }
  }

  HasAnswer_ = ReturnAnswer_ && Answer_.strlen();
  MemMatrix::Matrix().Deallocate(Data_);
  SetHasAnswer(HasAnswer_);

  if (HasAnswer_)
  {
    Answer_ = ChrString("\"") + Answer_ + ChrString("\"");
    SetAnswerMode(LITERAL_MODE, TRUE);
    SetLiteralStr(Answer_.c_str());
  }
  else if (!ReturnAnswer_)
  {
    Answer_.SetEmpty();
    SetHasAnswer(false);
  }

  if (!ProgramPopped_)
    PopActiveProgram(true);

  if (InAsync_ && Interactive_)
  {
    ClearGuiOutputFile();
    ClearUserPromptFile();
    ClearDirective();
    SetProcessAckTransition(0, true);

    SetProcessAckSignalPending(true);
    SetProcessAckForSignalReceived(Mcalc_IOState::INPUT_RECEIVED);
    SendProcessAckSignal(0);

    if (ProcessAckSignalSent())
    {
      SetProcessAckSignalDone(true);

      if (ProcessAckSignalDone())
      {
        ClearDirective();
        SetProcessAckTransition(0, true);
      }
    }
  }

  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->LeaveLevel();
  #endif

  return Answer_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindCombinations(int NumParams_, FncParameter** ParamArray_)
{
  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->EnterLevel("LineCalculator<T>::FindCombinations");
  #endif

  int x;
  ChrString Answer_;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Answer_;

  if (!IsNumber(ParamArray_[0]->_Param->GetExpression(), 0, 0, 0, 10) || NumParams_ == 1)
  {
    const char* Buffer_ = ParamArray_[0]->_Param->GetExpression();
    if (strchr(Buffer_, ','))
    {
      if (NumParams_ == 1)
      {
        ChrString ArgStr_ = ChrString("ITEMCOMB(") + ChrString(Buffer_) + ChrString(")");
        ChrString AnswerStr_ = ReEvaluate(ArgStr_);
        SetAnswerMode(LITERAL_MODE, TRUE);
        return AnswerStr_;
      }
    }

    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "ITEMCOMB");
    CloseGuiOutputFile();
    return Answer_;
  }

  CalculatorBase* CalcPtr_ = this;
  int ProgramPopped_ = TRUE;
  int Sel_ = atoi(ParamArray_[0]->_Param->GetExpression());
  int Size_ = NumParams_ - 2;
  int HasIndex_ = atoi(ParamArray_[Size_ + 1]->_Param->GetExpression());
  int InAsync_ = InAsyncMode();
  int Interactive_ = 0;
  int ReturnAnswer_ = 0;
  int HasAnswer_ = 0;
  char Buffer_[8];
  ChrString TempStr_;

  int FileOk_ = 0;
  FILE* UserInput_ = NULL;
  DiscreteSet<int> Disc_(0);
  int* Data_ = NULL;
  int* RetData_;
  Data_ = (int*)allocmem(Size_, sizeof(int), Data_);

  for (x = 0; x < Size_; x++)
    Data_[x] = x + 1;

  if (Sel_ <= Size_)
  {
    int IntroDone_ = 0;
    int StdStreams_ = StdInput() && StdOutput();
    Interactive_ = (StdStreams_ || InAsync_) &&
                   !SessionOption() && !NoPauseFileInput() && !HasIndex_;
    ReturnAnswer_ = SessionOption() || NoPauseFileInput() || HasIndex_;
    CalcProgram* Program_;

    if (Interactive_ && InAsync_)
    {
      Program_ = new CalcProgram;

      if (Program_)
      {
        Program_->SetCalculator(CalcPtr_);
        PushActiveProgram(Program_);
        ProgramPopped_ = FALSE;
      }
    }

    const char* RetStr_;
    Disc_.Combine(Data_, Size_, Sel_);

    for (;;)
    {
      RetData_ = Disc_.NextCombination();
      if (RetData_)
      {
        if (Interactive_ && !IntroDone_)
        {
          if (InAsync_)
            PromptAsyncUser(MSG_ENTER_TO_QUIT, PROMPT_DISPLAY);
          else
            fprintf(GetOutputFile(), MSG_ENTER_TO_QUIT_NL);
          IntroDone_ = 1;
        }

        TempStr_ = "";
        for (x = 0; x < Sel_; x++)
        {
          RetStr_ = ParamArray_[RetData_[x]]->_Param->GetExpression();
          if (Interactive_)
          {
            if (InAsync_)
            {
              TempStr_ += RetStr_;
              if (x == Sel_ - 1)
              {
		GetUserInputFile(true, true);
		UserInput_ = GiveFileStatus(Mcalc_IOType::UserInput, &FileOk_);
		if (FileOk_)
		{
		  fputs("x", UserInput_);
		  CloseUserInputFile(true);
		}

                TempStr_ += "\t";
                PromptAsyncUser(TempStr_.c_str(), PROMPT_INPUT);
              }
              else
                TempStr_ += ",";
            }
            else
            {
              fprintf(GetOutputFile(), "%s", RetStr_);
              if (x == Sel_ - 1)
                fprintf(GetOutputFile(), "\t");
              else
                fprintf(GetOutputFile(), ",", RetStr_);
            }
          }

          Answer_ += RetStr_;
          if (x == Sel_ - 1)
            Answer_ += "\n";
          else
            Answer_ += ",";
        }

        if (Interactive_)
        {
          if (InAsync_)
          {
            RetStr_ = ProgramStr();
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
            {
              ProgramPopped_ = TRUE;
              PopActiveProgram(true);
              break;
            }
          }
          else
          {
            RetStr_ = fgets(Buffer_, 8, stdin);
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
              break;
          }
        }
      }
      else
        break;
    }
  }

  HasAnswer_ = ReturnAnswer_ && Answer_.strlen();
  MemMatrix::Matrix().Deallocate(Data_);
  SetHasAnswer(HasAnswer_);

  if (HasAnswer_)
  {
    Answer_ = ChrString("\"") + Answer_ + ChrString("\"");
    SetAnswerMode(LITERAL_MODE, TRUE);
    SetLiteralStr(Answer_.c_str());
  }
  else if (!ReturnAnswer_)
  {
    Answer_.SetEmpty();
    SetHasAnswer(false);
  }

  if (!ProgramPopped_)
    PopActiveProgram(true);

  if (InAsync_ && Interactive_)
  {
    ClearGuiOutputFile();
    ClearUserPromptFile();
    ClearDirective();
    SetProcessAckTransition(0, true);

    SetProcessAckSignalPending(true);
    SetProcessAckForSignalReceived(Mcalc_IOState::INPUT_RECEIVED);
    SendProcessAckSignal(0);

    if (ProcessAckSignalSent())
    {
      SetProcessAckSignalDone(true);

      if (ProcessAckSignalDone())
      {
        ClearDirective();
        SetProcessAckTransition(0, true);
      }
    }
  }

  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->LeaveLevel();
  #endif

  return Answer_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindPermutationsWithRep(int NumParams_, FncParameter** ParamArray_)
{
  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->EnterLevel("LineCalculator<T>::FindPermutationsWithRep");
  #endif

  int x;
  ChrString Answer_;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Answer_;

  if (!IsNumber(ParamArray_[0]->_Param->GetExpression(), 0, 0, 0, 10) || NumParams_ == 1)
  {
    const char* Buffer_ = ParamArray_[0]->_Param->GetExpression();
    if (strchr(Buffer_, ','))
    {
      if (NumParams_ == 1)
      {
        ChrString ArgStr_ = ChrString("ITEMPERMREP(") + ChrString(Buffer_) + ChrString(")");
        ChrString AnswerStr_ = ReEvaluate(ArgStr_);
        SetAnswerMode(LITERAL_MODE, TRUE);
        return AnswerStr_;
      }
    }

    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "ITEMPERMREP");
    CloseGuiOutputFile();
    return Answer_;
  }

  CalculatorBase* CalcPtr_ = this;
  int ProgramPopped_ = TRUE;
  int Sel_ = atoi(ParamArray_[0]->_Param->GetExpression());
  int Size_ = NumParams_ - 2;
  int HasIndex_ = atoi(ParamArray_[Size_ + 1]->_Param->GetExpression());
  int InAsync_ = InAsyncMode();
  int Interactive_ = 0;
  int ReturnAnswer_ = 0;
  int HasAnswer_ = 0;
  char Buffer_[8];
  ChrString TempStr_;

  int FileOk_ = 0;
  FILE* UserInput_ = NULL;
  DiscreteSet<int> Disc_(0);
  int* Data_ = NULL;
  int* RetData_;
  Data_ = (int*)allocmem(Size_, sizeof(int), Data_);

  for (x = 0; x < Size_; x++)
    Data_[x] = x + 1;

  if (Sel_ <= Size_)
  {
    int IntroDone_ = 0;
    int StdStreams_ = StdInput() && StdOutput();
    Interactive_ = (StdStreams_ || InAsync_) &&
                   !SessionOption() && !NoPauseFileInput() && !HasIndex_;
    ReturnAnswer_ = SessionOption() || NoPauseFileInput() || HasIndex_;
    CalcProgram* Program_;

    if (Interactive_ && InAsync_)
    {
      Program_ = new CalcProgram;

      if (Program_)
      {
        Program_->SetCalculator(CalcPtr_);
        PushActiveProgram(Program_);
        ProgramPopped_ = FALSE;
      }
    }

    const char* RetStr_;
    Disc_.PermuteWithRep(Data_, Size_, Sel_);

    for (;;)
    {
      RetData_ = Disc_.NextPermutationWithRep();
      if (RetData_)
      {
        if (Interactive_ && !IntroDone_)
        {
          if (InAsync_)
            PromptAsyncUser(MSG_ENTER_TO_QUIT, PROMPT_DISPLAY);
          else
            fprintf(GetOutputFile(), MSG_ENTER_TO_QUIT_NL);
          IntroDone_ = 1;
        }

        TempStr_ = "";
        for (x = 0; x < Sel_; x++)
        {
          RetStr_ = ParamArray_[RetData_[x]]->_Param->GetExpression();
          if (Interactive_)
          {
            if (InAsync_)
            {
              TempStr_ += RetStr_;
              if (x == Sel_ - 1)
              {
		GetUserInputFile(true, true);
		UserInput_ = GiveFileStatus(Mcalc_IOType::UserInput, &FileOk_);
		if (FileOk_)
		{
		  fputs("x", UserInput_);
		  CloseUserInputFile(true);
		}

                TempStr_ += "\t";
                PromptAsyncUser(TempStr_.c_str(), PROMPT_INPUT);
              }
              else
                TempStr_ += ",";
            }
            else
            {
              fprintf(GetOutputFile(), "%s", RetStr_);
              if (x == Sel_ - 1)
                fprintf(GetOutputFile(), "\t");
              else
                fprintf(GetOutputFile(), ",", RetStr_);
            }
          }

          Answer_ += RetStr_;
          if (x == Sel_ - 1)
            Answer_ += "\n";
          else
            Answer_ += ",";
        }

        if (Interactive_)
        {
          if (InAsync_)
          {
            RetStr_ = ProgramStr();
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
            {
              ProgramPopped_ = TRUE;
              PopActiveProgram(true);
              break;
            }
          }
          else
          {
            RetStr_ = fgets(Buffer_, 8, stdin);
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
              break;
          }
        }
      }
      else
        break;
    }
  }

  HasAnswer_ = ReturnAnswer_ && Answer_.strlen();
  MemMatrix::Matrix().Deallocate(Data_);
  SetHasAnswer(HasAnswer_);

  if (HasAnswer_)
  {
    Answer_ = ChrString("\"") + Answer_ + ChrString("\"");
    SetAnswerMode(LITERAL_MODE, TRUE);
    SetLiteralStr(Answer_.c_str());
  }
  else if (!ReturnAnswer_)
  {
    Answer_.SetEmpty();
    SetHasAnswer(false);
  }

  if (!ProgramPopped_)
    PopActiveProgram(true);

  if (InAsync_ && Interactive_)
  {
    ClearGuiOutputFile();
    ClearUserPromptFile();
    ClearDirective();
    SetProcessAckTransition(0, true);

    SetProcessAckSignalPending(true);
    SetProcessAckForSignalReceived(Mcalc_IOState::INPUT_RECEIVED);
    SendProcessAckSignal(0);

    if (ProcessAckSignalSent())
    {
      SetProcessAckSignalDone(true);

      if (ProcessAckSignalDone())
      {
        ClearDirective();
        SetProcessAckTransition(0, true);
      }
    }
  }

  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->LeaveLevel();
  #endif

  return Answer_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::FindCombinationsWithRep(int NumParams_, FncParameter** ParamArray_)
{
  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->EnterLevel("LineCalculator<T>::FindCombinationsWithRep");
  #endif

  int x;
  ChrString Answer_;

  for (x = 0; x < NumParams_; x++)
    if (!ParamArray_[x] || !ParamArray_[x]->_Param)
      return Answer_;

  if (!IsNumber(ParamArray_[0]->_Param->GetExpression(), 0, 0, 0, 10) || NumParams_ == 1)
  {
    const char* Buffer_ = ParamArray_[0]->_Param->GetExpression();
    if (strchr(Buffer_, ','))
    {
      if (NumParams_ == 1)
      {
        ChrString ArgStr_ = ChrString("ITEMCOMBREP(") + ChrString(Buffer_) + ChrString(")");
        ChrString AnswerStr_ = ReEvaluate(ArgStr_);
        SetAnswerMode(LITERAL_MODE, TRUE);
        return AnswerStr_;
      }
    }

    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "ITEMCOMBREP");
    CloseGuiOutputFile();
    return Answer_;
  }

  CalculatorBase* CalcPtr_ = this;
  int ProgramPopped_ = TRUE;
  int Sel_ = atoi(ParamArray_[0]->_Param->GetExpression());
  int Size_ = NumParams_ - 2;
  int HasIndex_ = atoi(ParamArray_[Size_ + 1]->_Param->GetExpression());
  int InAsync_ = InAsyncMode();
  int Interactive_ = 0;
  int ReturnAnswer_ = 0;
  int HasAnswer_ = 0;
  char Buffer_[8];
  ChrString TempStr_;

  int FileOk_ = 0;
  FILE* UserInput_ = NULL;
  DiscreteSet<int> Disc_(0);
  int* Data_ = NULL;
  int* RetData_;
  Data_ = (int*)allocmem(Size_, sizeof(int), Data_);

  for (x = 0; x < Size_; x++)
    Data_[x] = x + 1;

  if (Sel_ <= Size_)
  {
    int IntroDone_ = 0;
    int StdStreams_ = StdInput() && StdOutput();
    Interactive_ = (StdStreams_ || InAsync_) &&
                   !SessionOption() && !NoPauseFileInput() && !HasIndex_;
    ReturnAnswer_ = SessionOption() || NoPauseFileInput() || HasIndex_;
    CalcProgram* Program_;

    if (Interactive_ && InAsync_)
    {
      Program_ = new CalcProgram;

      if (Program_)
      {
        Program_->SetCalculator(CalcPtr_);
        PushActiveProgram(Program_);
        ProgramPopped_ = FALSE;
      }
    }

    const char* RetStr_;
    Disc_.CombineWithRep(Data_, Size_, Sel_);

    for (;;)
    {
      RetData_ = Disc_.NextCombinationWithRep();
      if (RetData_)
      {
        if (Interactive_ && !IntroDone_)
        {
          if (InAsync_)
            PromptAsyncUser(MSG_ENTER_TO_QUIT, PROMPT_DISPLAY);
          else
            fprintf(GetOutputFile(), MSG_ENTER_TO_QUIT_NL);
          IntroDone_ = 1;
        }

        TempStr_ = "";
        for (x = 0; x < Sel_; x++)
        {
          RetStr_ = ParamArray_[RetData_[x]]->_Param->GetExpression();
          if (Interactive_)
          {
            if (InAsync_)
            {
              TempStr_ += RetStr_;
              if (x == Sel_ - 1)
              {
		GetUserInputFile(true, true);
		UserInput_ = GiveFileStatus(Mcalc_IOType::UserInput, &FileOk_);
		if (FileOk_)
		{
		  fputs("x", UserInput_);
		  CloseUserInputFile(true);
		}

                TempStr_ += "\t";
                PromptAsyncUser(TempStr_.c_str(), PROMPT_INPUT);
              }
              else
                TempStr_ += ",";
            }
            else
            {
              fprintf(GetOutputFile(), "%s", RetStr_);
              if (x == Sel_ - 1)
                fprintf(GetOutputFile(), "\t");
              else
                fprintf(GetOutputFile(), ",", RetStr_);
            }
          }

          Answer_ += RetStr_;
          if (x == Sel_ - 1)
            Answer_ += "\n";
          else
            Answer_ += ",";
        }

        if (Interactive_)
        {
          if (InAsync_)
          {
            RetStr_ = ProgramStr();
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
            {
              ProgramPopped_ = TRUE;
              PopActiveProgram(true);
              break;
            }
          }
          else
          {
            RetStr_ = fgets(Buffer_, 8, stdin);
            if (RetStr_ && toupper(RetStr_[0]) == 'Q')
              break;
          }
        }
      }
      else
        break;
    }
  }

  HasAnswer_ = ReturnAnswer_ && Answer_.strlen();
  MemMatrix::Matrix().Deallocate(Data_);
  SetHasAnswer(HasAnswer_);

  if (HasAnswer_)
  {
    Answer_ = ChrString("\"") + Answer_ + ChrString("\"");
    SetAnswerMode(LITERAL_MODE, TRUE);
    SetLiteralStr(Answer_.c_str());
  }
  else if (!ReturnAnswer_)
  {
    Answer_.SetEmpty();
    SetHasAnswer(false);
  }

  if (!ProgramPopped_)
    PopActiveProgram(true);

  if (InAsync_ && Interactive_)
  {
    ClearGuiOutputFile();
    ClearUserPromptFile();
    ClearDirective();
    SetProcessAckTransition(0, true);

    SetProcessAckSignalPending(true);
    SetProcessAckForSignalReceived(Mcalc_IOState::INPUT_RECEIVED);
    SendProcessAckSignal(0);

    if (ProcessAckSignalSent())
    {
      SetProcessAckSignalDone(true);

      if (ProcessAckSignalDone())
      {
        ClearDirective();
        SetProcessAckTransition(0, true);
      }
    }
  }

  #if CALCLIB_DEBUG12
    if (DbgPtr())
      DbgPtr()->LeaveLevel();
  #endif

  return Answer_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::BitwiseOps(const LongNumber& value1, const LongNumber& value2, int optype)
{
  ChrString Binval1_ = value1.ToString(2);
  ChrString Binval2_ = value2.ToString(2);
  long Diff_;
  Subscript len_;

  if (optype == Mcalc_OperatorType::Logical_Not)
  {
    Subscript DigitLen_ =
        (value2.ConvertedFromBase() == 16) ? 4:
        (value2.ConvertedFromBase() == 8)  ? 3:0;

    if (DigitLen_)
    {
      len_ = Binval2_.strlen();
      len_ = len_ % DigitLen_;

      if (len_)
      {
        len_ = 4 - len_;
        ChrString Fill_('0', len_);
        Binval2_ = Fill_ + Binval2_;
      }
    }

    BitString Bitstr_(Binval2_);
    Bitstr_.Toggle();
    Binval2_ = Bitstr_.To_String();
    Binval2_.BinToHex();
    return Binval2_;
  }

  if (Binval1_.strlen() < Binval2_.strlen())
  {
    Diff_ = Binval2_.strlen() - Binval1_.strlen();
    Binval1_.Insert(0, ChrString('0', Diff_));
  }
  else if (Binval2_.strlen() < Binval1_.strlen())
  {
    Diff_ = Binval1_.strlen() - Binval2_.strlen();
    Binval2_.Insert(0, ChrString('0', Diff_));
  }

  BitString Bitstr1_(Binval1_);
  BitString Bitstr2_(Binval2_);

  switch (optype)
  {
    case Mcalc_OperatorType::Exclusive_Or:
      Bitstr1_ ^= Bitstr2_;
      break;

    case Mcalc_OperatorType::Logical_And:
      Bitstr1_ &= Bitstr2_;
      break;

    case Mcalc_OperatorType::Logical_Or:
      Bitstr1_ |= Bitstr2_;
      break;
  }

  Binval1_ = Bitstr1_.To_String();
  Binval1_.BinToHex();
  return Binval1_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertFromHex(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Temp_ = ParamArray_[0]->_Param->GetExpression();
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntHex())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "FROMHEX");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  SetHasAnswer(TRUE);
  LongNumber Num_(Temp_);
  return Num_.ToString();
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertFromOct(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Temp_ = ParamArray_[0]->_Param->GetExpression();
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntOct())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "FROMOCT");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  SetHasAnswer(TRUE);
  LongNumber Num_(Temp_);
  return Num_.ToString();
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertFromBin(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Temp_ = ParamArray_[0]->_Param->GetExpression();
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntBin() || !Temp_.BinToHex())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "FROMBIN");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  SetHasAnswer(TRUE);
  LongNumber Num_ = Temp_;
  return Num_.ToString();
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertFromCmp2Bin(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Temp_ = ParamArray_[0]->_Param->GetExpression();
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntBin() || !Temp_.Cmp2BinToBin() || !Temp_.BinToHex())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "FROMCMP2BIN");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  SetHasAnswer(TRUE);
  LongNumber Num_ = Temp_;
  return Num_.ToString();
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertToHex(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Old_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Temp_ = Old_;
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntDec())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "TOHEX");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  LongNumber Num_ = Temp_;
  Temp_ = Num_.ToString(16);
  SetLiteralStr(Temp_.c_str());
  return Old_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertToOct(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Old_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Temp_ = Old_;
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntDec())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "TOOCT");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  LongNumber Num_ = Temp_;
  Temp_ = Num_.ToString(8);
  SetLiteralStr(Temp_.c_str());
  return Old_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertToBin(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Dummy_;
  if (!ParamArray_[0] || !ParamArray_[0]->_Param)
    return Dummy_;

  ChrString Old_ = ParamArray_[0]->_Param->GetExpression();
  ChrString Temp_ = Old_;
  Temp_.RemovePadding(" \n\t\r");

  if (!Temp_.IsIntDec())
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "TOBIN");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  LongNumber Num_ = Temp_;
  Temp_ = Num_.ToString(2);
  SetLiteralStr(Temp_.c_str());
  return Old_;
}

/*****************************************************************************/
template <class T>
ChrString LineCalculator<T>::ConvertToCmp2Bin(int NumParams_, FncParameter** ParamArray_)
{
  ChrString Old_ = ConvertToBin(NumParams_, ParamArray_);
  ChrString Result_ = LiteralStr();
  ChrString Dummy_;

  if (HasErrors())
    return Result_;

  int BytesRequested_ = 0;
  if (NumParams_ >= 2)
    if (!ParamArray_[1] || !ParamArray_[1]->_Param)
    {
      DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_NUMARGS,
                          ERRMSG_INVALID_NUMARGS, "TOCMP2BIN");
      CloseGuiOutputFile();
      SetHasAnswer(FALSE);

      return Dummy_;
    }
    else
      BytesRequested_ = atoi(ParamArray_[1]->_Param->GetAnswer());

  if (!Result_.BinToCmp2Bin(BytesRequested_))
  {
    DisplayErrorMessage(GetOutputFile(false, false, !NoPauseFileInput()), Mcalc_Error::ERRVAL_INVALID_TYPEARGS,
                        ERRMSG_INVALID_TYPEARGS, "TOCMP2BIN");
    CloseGuiOutputFile();
    SetHasAnswer(FALSE);

    return Dummy_;
  }

  SetLiteralStr(Result_.c_str());
  return Old_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::GiveRandom(int Num_)
{
  return _Random.GiveRandom(Num_);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GetCalcIndex() const
{
  return _CalcIndex;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GetPrevCalcIndex() const
{
  return _PrevCalcIndex;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHasCommandOutput(int Flag_, int TiedSignal_,
                                            SubExpression* SubExpr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _HasCommandOut = Flag_;
    _ParentPtr->SetHasCommandOutput(Flag_, TiedSignal_, SubExpr_);
  }
  else
  {
    _HasCommandOut = Flag_;

    if (!Flag_ && _Expression && ShowAnswer())
      _Expression->SetHasAnswer(false);

    if (TiedSignal_ && Flag_)
      TieOutputToSignal(TiedSignal_);
    else
      ClearOutputToSignal();
  }
}

/****************************************************************************/
template <class T>
Boolean LineCalculator<T>::HasCommandOutput(int TiedSignal_, bool* HasOut_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HasCommandOutput(TiedSignal_, HasOut_);
  else if (HasOut_)
    *HasOut_ = _HasCommandOut;

  return (TiedSignal_ ? (_HasCommandOut &&
                         (TiedSignal_ & _OutputTiedToSignal)):
                        _HasCommandOut);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::UsesConsoleIO() const
{
  return (_ConsoleInput && _ConsoleOutput);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::UsesConsoleInput() const
{
  return _ConsoleInput;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::UsesConsoleOutput() const
{
  return _ConsoleOutput;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::UseConsoleOutputFnc(const char* Buffer_)
{
  char* RetStr_ = NULL;
  ChrString temps_;

  if (!Buffer_)
    return 0;
  else
  {
    temps_ = Buffer_;
    temps_.RemovePadding(" \n\r\t");
  }

  #if (!(USE_STDIO_ONLY))
    if (_pbox && _pwin)
    {
      _pbox->SetXpos(1);
      _pbox->SetYpos(WHEREY());
      _pbox->SetMessage(temps_.c_str());
      _pbox->Erase();

      _pwin->UseColor();
      _pwin->Show();
      _pwin->UseColor(FALSE);
      SetSavedXpos(1);

      if (!_SkipPause)
      {
        GETCH();
        GOTOXY(1, WHEREY()+1);
      }
    }
  #endif

  return ::SafeStrLen(Buffer_);
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::UseConsoleInputFnc(char* Buffer_, int Size_)
{
  ChrString RetStr_;

  #if (!(USE_STDIO_ONLY))
    if (_pbox && _pwin)
    {
      _pbox->SetXpos(SavedXpos());
      _pbox->SetYpos(WHEREY());
      _pbox->SetInputString(CommandHistoryEntry());

      _pwin->ResetLine();
      _pwin->UseColor();
      _pwin->Show();

      _pwin->Prompt();
      GOTOXY(1, WHEREY()+1);
      SetSavedXpos(CONIO_XPOS_DEFAULT);

      _pwin->UseColor(FALSE);
      _pwin->Hide();

      RetStr_ = _pbox->StrRetrieve();
      RetStr_.RemovePadding(" \n\r\t");
    }
  #endif

  if (RetStr_.c_str() && RetStr_.strlen() < Size_)
    strcpy(Buffer_, RetStr_.c_str());

  return Buffer_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GraphProgressAmount() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgressAmount();

  return _GraphProgressAmt;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GraphSizeAmount() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphSizeAmount();

  return _GraphSizeAmt;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgressAmount(int amt)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressAmt = amt;
    _ParentPtr->SetGraphProgressAmount(amt);
  }
  else
    _GraphProgressAmt = amt;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphSizeAmount(int amt)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphSizeAmt = amt;
    _ParentPtr->SetGraphSizeAmount(amt);
  }
  else
    _GraphSizeAmt = amt;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::InFileProgressAmount() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InFileProgressAmount();

  return _InFileProgressAmt;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::InFileSizeAmount() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InFileSizeAmount();

  return _InFileSizeAmt;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetInFileProgressAmount(int amt)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressAmt = amt;
    _ParentPtr->SetInFileProgressAmount(amt);
  }
  else
    _InFileProgressAmt = amt;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetInFileSizeAmount(int amt)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileSizeAmt = amt;
    _ParentPtr->SetInFileSizeAmount(amt);
  }
  else
    _InFileSizeAmt = amt;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
bool LineCalculator<T>::IoStateForced() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->IoStateForced();

  return _IoStateForced;
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::SetIoStateForced(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SetIoStateForced(flag_);

  _IoStateForced = flag_;
  return this;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ShownToPrompt() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ShownToPrompt();

  return _ShownToPrompt;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ResultsPending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ResultsPending();

  return _ResultsPending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ResultsShown() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ResultsShown();

  return _ResultsShown;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphPlotShown() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphPlotShown();

  return _GraphPlotShown;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphOperFileSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphOperFileSent();

  return _GraphOperationsSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphOperFileResetDone(int FlagNum_, bool Unused_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphOperFileResetDone();

  bool x1 = _GraphOperationsResetDone1 == UNUSEDFLAG;
  bool x2 = _GraphOperationsResetDone2 == UNUSEDFLAG;

  // 0 : ATLEASTONESET
  // 1 : FIRSTFLAG
  // 2 : SECONDFLAG
  // 3 : SETORUNUSED
  // 4 : BOTHSET
  return ((FlagNum_ == 0) ? ((_GraphOperationsResetDone1 && !x1) ||
                             (_GraphOperationsResetDone2 && !x2)):
          (FlagNum_ == 1) ? ((!Unused_ && _GraphOperationsResetDone1 == 1) ||
                             (Unused_ && _GraphOperationsResetDone1 == UNUSEDFLAG)):
          (FlagNum_ == 2) ? ((!Unused_ && _GraphOperationsResetDone2 == 1) ||
                             (Unused_ && _GraphOperationsResetDone2 == UNUSEDFLAG)):
          (FlagNum_ == 3) ? ((_GraphOperationsResetDone1 == 1 || x1) &&
                             (_GraphOperationsResetDone2 == 1 || x2)):
          (FlagNum_ == 4) ? (((!Unused_ && _GraphOperationsResetDone1 == 1) ||
                              (Unused_ && _GraphOperationsResetDone1 == UNUSEDFLAG)) &&
                             ((!Unused_ && _GraphOperationsResetDone2 == 1) ||
                              (Unused_ && _GraphOperationsResetDone2 == UNUSEDFLAG))):
                            false);
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphOperFileUpdateDone(int FlagNum_, bool Unused_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphOperFileUpdateDone();

  bool x1 = _GraphOperationsUpdateDone1 == UNUSEDFLAG;
  bool x2 = _GraphOperationsUpdateDone2 == UNUSEDFLAG;

  // 0 : ATLEASTONESET
  // 1 : FIRSTFLAG
  // 2 : SECONDFLAG
  // 3 : SETORUNUSED
  // 4 : BOTHSET
  return ((FlagNum_ == 0) ? ((_GraphOperationsUpdateDone1 && !x1) ||
                             (_GraphOperationsUpdateDone2 && !x2)):
          (FlagNum_ == 1) ? ((!Unused_ && _GraphOperationsUpdateDone1 == 1) ||
                             (Unused_ && _GraphOperationsUpdateDone1 == UNUSEDFLAG)):
          (FlagNum_ == 2) ? ((!Unused_ && _GraphOperationsUpdateDone2 == 1) ||
                             (Unused_ && _GraphOperationsUpdateDone2 == UNUSEDFLAG)):
          (FlagNum_ == 3) ? ((_GraphOperationsUpdateDone1 == 1 || x1) &&
                             (_GraphOperationsUpdateDone2 == 1 || x2)):
          (FlagNum_ == 4) ? (((!Unused_ && _GraphOperationsUpdateDone1 == 1) ||
                              (Unused_ && _GraphOperationsUpdateDone1 == UNUSEDFLAG)) &&
                             ((!Unused_ && _GraphOperationsUpdateDone2 == 1) ||
                              (Unused_ && _GraphOperationsUpdateDone2 == UNUSEDFLAG))):
                            false);
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphProgFileSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgFileSent();

  return _GraphProgressSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphProgFileResetDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgFileResetDone();

  return _GraphProgressResetDone;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphProgFileResetPending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgFileResetPending();

  return _GraphProgressResetPending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphProgFileUpdateDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgFileUpdateDone();

  return _GraphProgressUpdateDone;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::GraphProgFileUpdatePending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphProgFileUpdatePending();

  return _GraphProgressUpdatePending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::CalcProgFileSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CalcProgFileSent();

  return _InFileProgressSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::CalcProgFileResetDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CalcProgFileResetDone();

  return _InFileProgressResetDone;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::CalcProgFileResetPending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CalcProgFileResetPending();

  return _InFileProgressResetPending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::CalcProgFileUpdateDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CalcProgFileUpdateDone();

  return _InFileProgressUpdateDone;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::CalcProgFileUpdatePending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CalcProgFileUpdatePending();

  return _InFileProgressUpdatePending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::BatchFileEndedSignalSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->BatchFileEndedSignalSent();

  return _BatchFileEndedSignalSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::BatchFileEndedSignalAcked() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->BatchFileEndedSignalAcked();

  return _BatchFileEndedSignalAcked;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::BatchFileEndedSignalPending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->BatchFileEndedSignalPending();

  return _BatchFileEndedSignalPending;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ClientPingSignalSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ClientPingSignalSent();

  return _ClientPingSignalSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ClientPingSignalAcked() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ClientPingSignalAcked();

  return _ClientPingSignalAcked;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ClientIsDead() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ClientIsDead();

  return _ClientIsDead;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ProcessAckSignalSent() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessAckSignalSent();

  return _ProcessAckSignalSent;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ProcessAckSignalDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessAckSignalDone();

  return _ProcessAckSignalDone;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ProcessAckSignalPending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessAckSignalPending();

  return _ProcessAckSignalPending;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::ProcessAckForSignalReceived() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessAckForSignalReceived();

  return _AckSignalReceived;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ProcessAckTransitioned() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessAckTransitioned();

  int ValidTransition_ = Mcalc_IOState::PROCESS_DONE_ACK - Mcalc_IOState::PROCESS_DONE;
  return (_ProcessAckTransition == ValidTransition_);
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetShownToPrompt(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ShownToPrompt = flag_;
    _ParentPtr->SetShownToPrompt(flag_);
  }
  else
    _ShownToPrompt = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetResultsPending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ResultsPending = flag_;
    _ParentPtr->SetResultsPending(flag_);
  }
  else
    _ResultsPending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetResultsShown(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ResultsShown = flag_;
    _ParentPtr->SetResultsShown(flag_);
  }
  else
  {
    _ResultsShown = flag_;

    if (flag_)
      SetHasAnswer(true);
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphPlotShown(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphPlotShown = flag_;
    _ParentPtr->SetGraphPlotShown(flag_);
  }
  else
    _GraphPlotShown = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphOperFileSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphOperationsSent = flag_;
    _ParentPtr->SetGraphOperFileSent(flag_);
  }
  else
    _GraphOperationsSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphOperFileResetDone(int flag1_, int flag2_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (flag1_ < 0)
    {
      if (_GraphOperationsResetDone1 + flag1_ == 0)
        _GraphOperationsResetDone1 = 0;
    }
    else
      _GraphOperationsResetDone1 = flag1_;

    if (flag2_ < 0)
    {
      if (_GraphOperationsResetDone2 + flag2_ == 0)
        _GraphOperationsResetDone2 = 0;
    }
    else
      _GraphOperationsResetDone2 = flag2_;

    _ParentPtr->SetGraphOperFileResetDone(flag1_, flag2_);
  }
  else
  {
    if (flag1_ < 0)
    {
      if (_GraphOperationsResetDone1 + flag1_ == 0)
        _GraphOperationsResetDone1 = 0;
    }
    else
      _GraphOperationsResetDone1 = flag1_;

    if (flag2_ < 0)
    {
      if (_GraphOperationsResetDone2 + flag2_ == 0)
        _GraphOperationsResetDone2 = 0;
    }
    else
      _GraphOperationsResetDone2 = flag2_;
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphOperFileUpdateDone(int flag1_, int flag2_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (flag1_ < 0)
    {
      if (_GraphOperationsUpdateDone1 + flag1_ == 0)
        _GraphOperationsUpdateDone1 = 0;
    }
    else
      _GraphOperationsUpdateDone1 = flag1_;

    if (flag2_ < 0)
    {
      if (_GraphOperationsUpdateDone2 + flag2_ == 0)
        _GraphOperationsUpdateDone2 = 0;
    }
    else
      _GraphOperationsUpdateDone2 = flag2_;

    _ParentPtr->SetGraphOperFileUpdateDone(flag1_, flag2_);
  }
  else
  {
    if (flag1_ < 0)
    {
      if (_GraphOperationsUpdateDone1 + flag1_ == 0)
        _GraphOperationsUpdateDone1 = 0;
    }
    else
      _GraphOperationsUpdateDone1 = flag1_;

    if (flag2_ < 0)
    {
      if (_GraphOperationsUpdateDone2 + flag2_ == 0)
        _GraphOperationsUpdateDone2 = 0;
    }
    else
      _GraphOperationsUpdateDone2 = flag2_;
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgFileSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressSent = flag_;
    _ParentPtr->SetGraphProgFileSent(flag_);
  }
  else
    _GraphProgressSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgFileResetDone(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressResetDone = flag_;
    _ParentPtr->SetGraphProgFileResetDone(flag_);
  }
  else
    _GraphProgressResetDone = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgFileResetPending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressResetPending = flag_;
    _ParentPtr->SetGraphProgFileResetPending(flag_);
  }
  else
    _GraphProgressResetPending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgFileUpdateDone(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressUpdateDone = flag_;
    _ParentPtr->SetGraphProgFileUpdateDone(flag_);
  }
  else
    _GraphProgressUpdateDone = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphProgFileUpdatePending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _GraphProgressUpdatePending = flag_;
    _ParentPtr->SetGraphProgFileUpdatePending(flag_);
  }
  else
    _GraphProgressUpdatePending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcProgFileSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressSent = flag_;
    _ParentPtr->SetCalcProgFileSent(flag_);
  }
  else
    _InFileProgressSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcProgFileResetDone(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressResetDone = flag_;
    _ParentPtr->SetCalcProgFileResetDone(flag_);
  }
  else
    _InFileProgressResetDone = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcProgFileResetPending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressResetPending = flag_;
    _ParentPtr->SetCalcProgFileResetPending(flag_);
  }
  else
    _InFileProgressResetPending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcProgFileUpdateDone(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressUpdateDone = flag_;
    _ParentPtr->SetCalcProgFileUpdateDone(flag_);
  }
  else
    _InFileProgressUpdateDone = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcProgFileUpdatePending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InFileProgressUpdatePending = flag_;
    _ParentPtr->SetCalcProgFileUpdatePending(flag_);
  }
  else
    _InFileProgressUpdatePending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetBatchFileEndedSignalSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _BatchFileEndedSignalSent = flag_;
    _ParentPtr->SetBatchFileEndedSignalSent(flag_);
  }
  else
    _BatchFileEndedSignalSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetBatchFileEndedSignalAcked(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _BatchFileEndedSignalAcked = flag_;
    _ParentPtr->SetBatchFileEndedSignalAcked(flag_);
  }
  else
    _BatchFileEndedSignalAcked = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetBatchFileEndedSignalPending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _BatchFileEndedSignalPending = flag_;
    _ParentPtr->SetBatchFileEndedSignalPending(flag_);
  }
  else
    _BatchFileEndedSignalPending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetClientPingSignalSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ClientPingSignalSent = flag_;
    _ParentPtr->SetClientPingSignalSent(flag_);
  }
  else
    _ClientPingSignalSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetClientPingSignalAcked(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ClientPingSignalAcked = flag_;
    _ParentPtr->SetClientPingSignalAcked(flag_);
  }
  else
    _ClientPingSignalAcked = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetClientIsDead(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ClientIsDead = flag_;
    _ParentPtr->SetClientIsDead(flag_);
  }
  else
    _ClientIsDead = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessAckSignalSent(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ProcessAckSignalSent = flag_;
    _ParentPtr->SetProcessAckSignalSent(flag_);
  }
  else
    _ProcessAckSignalSent = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessAckSignalDone(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ProcessAckSignalDone = flag_;
    _ParentPtr->SetProcessAckSignalDone(flag_);
  }
  else
    _ProcessAckSignalDone = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessAckSignalPending(bool flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ProcessAckSignalPending = flag_;
    _ParentPtr->SetProcessAckSignalPending(flag_);
  }
  else
    _ProcessAckSignalPending = flag_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessAckForSignalReceived(int Signal_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _AckSignalReceived = Signal_;
    _ParentPtr->SetProcessAckForSignalReceived(Signal_);
  }
  else
    _AckSignalReceived = Signal_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessAckTransition(int state_, bool reset_)
{
  if (state_ > 0 && !reset_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      if (_ProcessAckTransition < 0 &&
          (_ProcessAckTransition == -Mcalc_IOState::PROCESS_DONE_ACK ||
           _ProcessAckTransition == -Mcalc_IOState::PROCESS_DONE))
      {
        _ProcessAckTransition += state_;
        if (_ProcessAckTransition ==
            Mcalc_IOState::PROCESS_DONE_ACK - Mcalc_IOState::PROCESS_DONE)
          SetProcessAckSignalDone(true);

        _ParentPtr->SetProcessAckTransition(state_, reset_);
      }
      else if (_ProcessAckTransition == 0)
      {
        _ProcessAckTransition = -state_;
        _ParentPtr->SetProcessAckTransition(state_, reset_);
      }
    }
    else
    {
      if (_ProcessAckTransition < 0 &&
          (_ProcessAckTransition == -Mcalc_IOState::PROCESS_DONE_ACK ||
           _ProcessAckTransition == -Mcalc_IOState::PROCESS_DONE))
      {
        _ProcessAckTransition += state_;

        if (_ProcessAckTransition ==
            Mcalc_IOState::PROCESS_DONE_ACK - Mcalc_IOState::PROCESS_DONE)
          SetProcessAckSignalDone(true);
      }
      else if (_ProcessAckTransition == 0)
        _ProcessAckTransition = -state_;
    }
  }
  else
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      if (state_ == 0 && reset_)
      {
        _ProcessAckTransition = 0;
        _ParentPtr->SetProcessAckTransition(state_, reset_);
      }
    }
    else
    {
      if (state_ == 0 && reset_)
        _ProcessAckTransition = 0;
    }
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ShowQuitGraphFlags() const
{
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  #if CALCLIB_DEBUG11a
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->EnterLevel("FindFunctionCalls");
  #endif

  if (NestCond_)
    _ParentPtr->ShowQuitGraphFlags();
  #if CALCLIB_DEBUG11a
    else
    {
      DbgPtr()->ShowInt(_QuitGraph, "QuitGraph()");
      DbgPtr()->ShowInt(_ResetGraph, "ResetGraphCond()");
      DbgPtr()->ShowInt(_GraphResetDone, "ResetGraphIsDone()");
      DbgPtr()->ShowInt(_GraphFilePause, "GraphFilePause()");
      DbgPtr()->ShowInt(_InAllGraphsFile, "InAllGraphsFile()");
      DbgPtr()->ShowInt(_BatchFileDonePending, "BatchFileDonePending()");
    }
  #endif

  #if CALCLIB_DEBUG11a
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ResetQuitGraphFlags(bool Force_)
{
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  if (ResetGraphIsDone() || Force_)
  {
    if (NestCond_)
    {
      _QuitGraph = false;
      _ResetGraph = false;
      _GraphResetDone = false;
      _GraphFilePause = false;
      _InAllGraphsFile = false;
      // _BatchFileDonePending = false;

      _ParentPtr->ResetQuitGraphFlags(Force_);
    }
    else
    {
      _QuitGraph = false;
      _ResetGraph = false;
      _GraphResetDone = false;
      _GraphFilePause = false;
      _InAllGraphsFile = false;
      // _BatchFileDonePending = false;
    }
  }
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::QuitGraph() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->QuitGraph();

  return _QuitGraph;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetQuitGraph(bool flag_)
{
  int IoState_ = 0;
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  #if CALCLIB_DEBUG11b
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->EnterLevel("SetQuitGraph");
  #endif

  bool InBatch_ = InBatchFile(true);
  bool DoReset_ = GraphFilePause() && !_GraphResetDone;

  if (InBatch_ && !flag_)
  {
    if (NestCond_)
    {
      if (DoReset_)
        _ResetGraph = true;
      else
        _QuitGraph = false;

      _ParentPtr->SetQuitGraph(flag_);
    }
    else
    {
      if (DoReset_)
        _ResetGraph = true;
      else
        _QuitGraph = false;
    }
  }
  else if (InBatch_ && GraphFilePause() && flag_)
  {
    if (NestCond_)
    {
      _QuitGraph = true;
      _ResetGraph = false;

      _ParentPtr->SetQuitGraph(flag_);
    }
    else
    {
      _QuitGraph = true;
      _ResetGraph = false;

      IoState_ = Bare_GetIoState(0);

      if (IoState_ != Mcalc_IOState::INPUT_RECEIVED)
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
    }
  }

  #if CALCLIB_DEBUG11b
    if (!NestCond_ && DbgPtr(false))
    {
      DbgPtr()->ShowInt(InBatch_, "InBatch_");
      DbgPtr()->ShowInt(DoReset_, "DoReset_");
      DbgPtr()->ShowInt(flag_, "flag_");
      DbgPtr()->ShowInt(GraphFilePause(), "GraphFilePause()");
      DbgPtr()->ShowInt(WasInBatchDataInput(), "WasInBatchDataInput()");
      DbgPtr()->ShowInt(InputDataFilePauseOption(), "InputDataFilePauseOption()");

      DbgPtr()->ShowInt(_QuitGraph, "_QuitGraph");
      DbgPtr()->ShowInt(_GraphResetDone, "_GraphResetDone");
      DbgPtr()->ShowInt(InputDataFileExecLock(), "InputDataFileExecLock()");
      DbgPtr()->ShowInt(ExecInputFileData(), "ExecInputFileData()");
      DbgPtr()->ShowInt(AckPostExecInputFileData(), "AckPostExecInputFileData()");
      DbgPtr()->ShowInt(_ResetGraph, "_ResetGraph");
      DbgPtr()->ShowInt(_BatchFileDonePending, "BatchFileDonePending()");

      DbgPtr()->LeaveLevel();
    }
  #endif
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ResetGraphCond() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ResetGraphCond();

  return _ResetGraph;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::BatchFileDonePending() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->BatchFileDonePending();

  return _BatchFileDonePending;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetBatchFileDonePending(bool flag_)
{
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  #if CALCLIB_DEBUG11b
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->EnterLevel("SetBatchFileDonePending");
  #endif

  if (NestCond_)
  {
    _BatchFileDonePending = true;
    _ParentPtr->SetBatchFileDonePending(flag_);
  }
  else
    _BatchFileDonePending = true;

  #if CALCLIB_DEBUG11a
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphCondReset(bool flag_)
{
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  bool InBatch_ = InBatchFile(true);
  bool DoReset_ = GraphFilePause() && !_GraphResetDone;

  if (flag_ && InBatch_ && DoReset_)
    SetQuitGraph(false);
  else if (InBatch_ && GraphFilePause())
  {
    if (NestCond_)
    {
      _ResetGraph = false;
      _ParentPtr->SetGraphCondReset(flag_);
    }
    else
      _ResetGraph = false;
  }
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ResetGraphIsDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ResetGraphIsDone();

  return _GraphResetDone;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ConfirmResetGraphDone()
{
  bool NestCond_ = !ParentDestroyed() && _ParentPtr &&
                   _ParentPtr != ((CalculatorBase*)this);

  #if CALCLIB_DEBUG11b
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->EnterLevel("ConfirmResetGraphDone");
  #endif

  if (NestCond_)
  {
    _ResetGraph = false;
    _GraphResetDone = true;

    _ParentPtr->ConfirmResetGraphDone();
  }
  else
  {
    _ResetGraph = false;
    _GraphResetDone = true;
  }

  #if CALCLIB_DEBUG11a
    if (!NestCond_ && DbgPtr(false))
      DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetDisplayOption(int Option_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _DisplayOption = Option_;
    _ParentPtr->SetDisplayOption(Option_);
  }
  else
    _DisplayOption = Option_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GetDisplayOption()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetDisplayOption();

  return _DisplayOption;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetProcessVariables(int Value_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ProcessVars = Value_;
    _ParentPtr->SetProcessVariables(Value_);
  }
  else
    _ProcessVars = Value_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ProcessVariables() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProcessVariables();

  return _ProcessVars;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::InInputDataFileMode() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InInputDataFileMode();

  const CalcProgram* ActivePrg_ = ActiveProgram();
  return (ActivePrg_ != NULL && IsUserPrompterProgram(ActivePrg_));
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::InProgramMode(bool InclPrompter_, bool InclInfile_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InProgramMode(InclPrompter_, InclInfile_);

  const CalcProgram* ActivePrg_ = ActiveProgram();
  bool retval = (ActivePrg_ != NULL &&
                 (InclPrompter_ || !IsUserPrompterProgram(ActivePrg_)));

  retval = retval || (InclInfile_ && ExecInputFileData());
  return retval;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::RecursionLimit() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->RecursionLimit();

  return _RecursionLimit;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetRecursionLimit(int Limit_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (Limit_ >= 0)
      _RecursionLimit = Limit_;
    _ParentPtr->SetRecursionLimit(Limit_);
  }
  else
  {
    if (Limit_ >= 0)
      _RecursionLimit = Limit_;
  }
}

/****************************************************************************/
template <class T>
double LineCalculator<T>::GraphPrecision() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GraphPrecision();

  return _GraphPrecision;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetGraphPrecision(double Prec_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (Prec_ >= 0)
      _GraphPrecision = Prec_;
    _ParentPtr->SetGraphPrecision(Prec_);
  }
  else
  {
    if (Prec_ >= 0)
      _GraphPrecision = Prec_;
  }
}

/****************************************************************************/
template <class T>
double LineCalculator<T>::DetermineGraphPrecision()
{
  int Gtype_ = CalculatorBase::GraphType();
  double Prec_ = DEFAULT_PRECVAL_GRAPH;

  switch (Gtype_)
  {
    case Mcalc_GraphType::FUNCTION:
      Prec_ = DEFAULT_PRECVAL_GRAPH;
      break;

    case Mcalc_GraphType::EXTREMA:
      Prec_ = DEFAULT_PRECVAL_GRAPH;
      break;

    case Mcalc_GraphType::DERIVATIVE:
      Prec_ = DEFAULT_PRECVAL_GRAPH;
      break;

    case Mcalc_GraphType::INTEGRAL:
      Prec_ = DEFAULT_PRECVAL_MAXINTERVAL;
      break;

    case Mcalc_GraphType::ROOTSOLVE:
      Prec_ = DEFAULT_PRECVAL_MAXINTERVAL;
      break;

    case Mcalc_GraphType::INTERSECT1:
    case Mcalc_GraphType::INTERSECT2:
      Prec_ = DEFAULT_PRECVAL_MAXINTERVAL;
  }

  SetGraphPrecision(Prec_);
  return GraphPrecision();
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetSavedXpos(int xpos_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _SavedXpos = xpos_;
    _ParentPtr->SetSavedXpos(xpos_);
  }
  else
    _SavedXpos = xpos_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::SavedXpos() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SavedXpos();

  return _SavedXpos;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListMode(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _HistoryListMode = flag_;
    _ParentPtr->SetHistoryListMode(flag_);
  }
  else
    _HistoryListMode = flag_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::CommandHistoryMode() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryMode();

  return _HistoryListMode;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListEnded(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _HistoryFileEnded = flag_;
    _ParentPtr->SetHistoryListEnded(flag_);
  }
  else
    _HistoryFileEnded = flag_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::CommandHistoryListEnded() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryListEnded();

  return _HistoryFileEnded;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListIndex(int val_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _CmdHistoryIndex = val_;
    _ParentPtr->SetHistoryListIndex(val_);
  }
  else
    _CmdHistoryIndex = val_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::IncHistoryListIndex(int val_, int IncOrder_)
{
  int prev_ = 0;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    prev_ = _ParentPtr->IncHistoryListIndex(val_);

    if (IncOrder_ == CalculatorBase::POSTFIX)
      _CmdHistoryIndex = prev_ + val_;
    else if (IncOrder_ == CalculatorBase::PREFIX)
      _CmdHistoryIndex = prev_;
  }
  else
  {
    prev_ = _CmdHistoryIndex;
    _CmdHistoryIndex += val_;
  }

  return ((IncOrder_ == CalculatorBase::PREFIX) ? _CmdHistoryIndex:
          (IncOrder_ == CalculatorBase::POSTFIX) ? prev_:0);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::DecHistoryListIndex(int val_, int DecOrder_)
{
  int prev_ = 0;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    prev_ = _ParentPtr->DecHistoryListIndex(val_);

    if (DecOrder_ == CalculatorBase::POSTFIX)
      _CmdHistoryIndex = prev_ - val_;
    else if (DecOrder_ == CalculatorBase::PREFIX)
      _CmdHistoryIndex = prev_;
  }
  else
  {
    prev_ = _CmdHistoryIndex;
    _CmdHistoryIndex -= val_;
  }

  return ((DecOrder_ == CalculatorBase::PREFIX) ? _CmdHistoryIndex:
          (DecOrder_ == CalculatorBase::POSTFIX) ? prev_:0);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::CommandHistoryIndex() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryIndex();

  return _CmdHistoryIndex;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListLength(int val_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _CmdHistoryLength = val_;
    _ParentPtr->SetHistoryListLength(val_);
  }
  else
    _CmdHistoryLength = val_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::IncHistoryListLength(int val_, int IncOrder_)
{
  int prev_ = 0;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    prev_ = _ParentPtr->IncHistoryListLength(val_);

    if (IncOrder_ == CalculatorBase::POSTFIX)
      _CmdHistoryLength = prev_ + val_;
    else if (IncOrder_ == CalculatorBase::PREFIX)
      _CmdHistoryLength = prev_;
  }
  else
  {
    prev_ = _CmdHistoryLength;
    _CmdHistoryLength += val_;
  }

  return ((IncOrder_ == CalculatorBase::PREFIX) ? _CmdHistoryLength:
          (IncOrder_ == CalculatorBase::POSTFIX) ? prev_:0);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::DecHistoryListLength(int val_, int DecOrder_)
{
  int prev_ = 0;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    prev_ = _ParentPtr->DecHistoryListLength(val_);

    if (DecOrder_ == CalculatorBase::POSTFIX)
      _CmdHistoryLength = prev_ - val_;
    else if (DecOrder_ == CalculatorBase::PREFIX)
      _CmdHistoryLength = prev_;
  }
  else
  {
    prev_ = _CmdHistoryLength;
    _CmdHistoryLength -= val_;
  }

  return ((DecOrder_ == CalculatorBase::PREFIX) ? _CmdHistoryLength:
          (DecOrder_ == CalculatorBase::POSTFIX) ? prev_:0);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::CommandHistoryLength() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryLength();

  return _CmdHistoryLength;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::AllocateHistoryListEntry(int size_)
{
  if (size_ <= 0)
    return NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryEntry = _ParentPtr->AllocateHistoryListEntry(size_);
  else
    _CmdHistoryEntry = (char*)MemMatrix::Matrix().Callocate(size_ * sizeof(char));

  return _CmdHistoryEntry;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::DeallocateHistoryListEntry()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryEntry = _ParentPtr->DeallocateHistoryListEntry();
  else
  {
    MemMatrix::Matrix().Deallocate(_CmdHistoryEntry);
    _CmdHistoryEntry = NULL;
  }

  return _CmdHistoryEntry;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListEntry(char* str, int strcopy_, const char* conststr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (strcopy_ && (str || conststr_))
      ::strcpy(_CmdHistoryEntry, (str ? str:conststr_));
    else
      _CmdHistoryEntry = str;

    _ParentPtr->SetHistoryListEntry(str, strcopy_, conststr_);
  }
  else
  {
    if (strcopy_ && (str || conststr_))
      ::strcpy(_CmdHistoryEntry, (str ? str:conststr_));
    else
      _CmdHistoryEntry = str;
  }
}

/****************************************************************************/
template <class T>
const char* LineCalculator<T>::CommandHistoryEntry() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryEntry();

  return _CmdHistoryEntry;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::CommandHistoryEntry()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryEntry();

  return _CmdHistoryEntry;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::AllocateHistoryListPrompt(int size_)
{
  if (size_ <= 0)
    return NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryPrompt = _ParentPtr->AllocateHistoryListPrompt(size_);
  else
    _CmdHistoryPrompt = (char*)MemMatrix::Matrix().Callocate(size_ * sizeof(char));

  return _CmdHistoryPrompt;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::DeallocateHistoryListPrompt()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryPrompt = _ParentPtr->DeallocateHistoryListPrompt();
  else
  {
    MemMatrix::Matrix().Deallocate(_CmdHistoryPrompt);
    _CmdHistoryPrompt = NULL;
  }

  return _CmdHistoryPrompt;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetHistoryListPrompt(char* str, int strcopy_, const char* conststr_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (strcopy_ && (str || conststr_))
      ::strcpy(_CmdHistoryPrompt, (str ? str:conststr_));
    else
      _CmdHistoryPrompt = str;

    _ParentPtr->SetHistoryListPrompt(str, strcopy_, conststr_);
  }
  else
  {
    if (strcopy_ && (str || conststr_))
      ::strcpy(_CmdHistoryPrompt, (str ? str:conststr_));
    else
      _CmdHistoryPrompt = str;
  }
}

/****************************************************************************/
template <class T>
const char* LineCalculator<T>::CommandHistoryPrompt() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryPrompt();

  return _CmdHistoryPrompt;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::CommandHistoryPrompt()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CommandHistoryPrompt();

  return _CmdHistoryPrompt;
}

/****************************************************************************/
template <class T>
char** LineCalculator<T>::AllocateHistoryList(int size_)
{
  if (size_ <= 0)
    return NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryList = _ParentPtr->AllocateHistoryList(size_);
  else
    _CmdHistoryList = (char**)MemMatrix::Matrix().Callocate(size_ * sizeof(char*));

  return _CmdHistoryList;
}

/****************************************************************************/
template <class T>
char** LineCalculator<T>::GiveHistoryList()
{
  char** retptr = NULL;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    retptr =
    _CmdHistoryList = _ParentPtr->GiveHistoryList();
  else
    return _CmdHistoryList;

  return retptr;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::AllocateHistoryListElement(int index, int size_)
{
  char* retptr = NULL;

  if (size_ <= 0)
    return retptr;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    retptr = _ParentPtr->AllocateHistoryListElement(index, size_);

    if (!_CmdHistoryList)
      _CmdHistoryList = _ParentPtr->GiveHistoryList();

    _CmdHistoryList[index] = retptr;
  }
  else
  {
    if (!_CmdHistoryList && index < MAXHISTORY)
    {
      AllocateHistoryList(MAXHISTORY);
      SetHistoryListIndex(index);
      SetHistoryListLength(index+1);
      SetHistoryListMode(FALSE);
      SetHistoryListEnded(FALSE);
    }

    retptr =
    _CmdHistoryList[index] = (char*)MemMatrix::Matrix().Callocate(size_ * sizeof(char));
  }

  return retptr;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::AllocateHistoryListElement(int index, int size_) const
{
  char* retptr = NULL;

  if (size_ <= 0)
    return retptr;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    retptr = _ParentPtr->AllocateHistoryListElement(index, size_);

    if (!_CmdHistoryList)
      _CmdHistoryList = _ParentPtr->GiveHistoryList();

    if (_CmdHistoryList)
      _CmdHistoryList[index] = retptr;
  }
  else
  {
    retptr =
    _CmdHistoryList[index] = (char*)MemMatrix::Matrix().Callocate(size_ * sizeof(char));
  }

  return retptr;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::DeallocateHistoryListAll()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->DeallocateHistoryListAll();
    _CmdHistoryList = NULL;
    _CmdHistoryEntry = NULL;
    _CmdHistoryPrompt = NULL;
  }
  else
  {
    int x;
    int max = CommandHistoryLength();

    for (x = 0; x < max; x++)
    {
      MemMatrix::Matrix().Deallocate(_CmdHistoryList[x]);
      _CmdHistoryList[x] = NULL;
    }

    MemMatrix::Matrix().Deallocate(_CmdHistoryList);
    _CmdHistoryList = NULL;

    MemMatrix::Matrix().Deallocate(_CmdHistoryEntry);
    _CmdHistoryEntry = NULL;

    MemMatrix::Matrix().Deallocate(_CmdHistoryPrompt);
    _CmdHistoryPrompt = NULL;
  }
}

/****************************************************************************/
template <class T>
char** LineCalculator<T>::DeallocateHistoryList()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _CmdHistoryList = _ParentPtr->DeallocateHistoryList();
  else
  {
    int x;
    int max = CommandHistoryLength();

    for (x = 0; x < max; x++)
    {
      MemMatrix::Matrix().Deallocate(_CmdHistoryList[x]);
      _CmdHistoryList[x] = NULL;
    }

    MemMatrix::Matrix().Deallocate(_CmdHistoryList);
    _CmdHistoryList = NULL;
  }

  return _CmdHistoryList;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::DeallocateHistoryListElement(int index)
{
  char* retptr = NULL;

  if (0 <= index && index < CommandHistoryLength())
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    {
      retptr = _ParentPtr->DeallocateHistoryListElement(index);

      if (!_CmdHistoryList)
	_CmdHistoryList = _ParentPtr->GiveHistoryList();

      _CmdHistoryList[index] = retptr;
    }
    else
    {
      if (!_CmdHistoryList && index < MAXHISTORY)
      {
        AllocateHistoryList(MAXHISTORY);
        SetHistoryListIndex(index);
        SetHistoryListLength(index+1);
        SetHistoryListMode(FALSE);
        SetHistoryListEnded(FALSE);
      }
      else
        MemMatrix::Matrix().Deallocate(_CmdHistoryList[index]);

      retptr =
      _CmdHistoryList[index] = NULL;
    }
  }

  return retptr;
}

/****************************************************************************/
// format of command history list:
//   [1byte  : command validity=1st byte]
//   [2byte  : string length=2nd byte]
//   [                      =3rd byte]
//   [nbytes : command string startpt=4th byte]
//
//   [Validity (1 byte)][String Length (2 bytes)][Command String]
//
template <class T>
void LineCalculator<T>::SetHistoryListElementStr(int index, const char* str)
{
  if (str)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetHistoryListElementStr(index, str);
    else
    {
      if (!_CmdHistoryList[index])
	AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

      ::memmove(_CmdHistoryList[index]+3, str, (strlen(str) + 1) * sizeof(char));
    }
  }
}

/****************************************************************************/
// format of command history list:
//   [1byte  : command validity=1st byte]
//   [2byte  : string length=2nd byte]
//   [                      =3rd byte]
//   [nbytes : command string startpt=4th byte]
//
//   [Validity (1 byte)][String Length (2 bytes)][Command String]
//
template <class T>
void LineCalculator<T>::SetHistoryListElementValid(int index, int valid_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetHistoryListElementValid(index, valid_);
  else
  {
    if (!_CmdHistoryList[index])
      AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

    _CmdHistoryList[index][0] = valid_;
  }
}

/****************************************************************************/
// format of command history list:
//   [1byte  : command validity=1st byte]
//   [2byte  : string length=2nd byte]
//   [                      =3rd byte]
//   [nbytes : command string startpt=4th byte]
//
//   [Validity (1 byte)][String Length (2 bytes)][Command String]
//
template <class T>
void LineCalculator<T>::SetHistoryListElementSize(int index, Ushort size_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetHistoryListElementSize(index, size_);
  else
  {
    if (!_CmdHistoryList[index])
      AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

    ::memmove(_CmdHistoryList[index]+1, &size_, 2 * sizeof(char));
  }
}

/****************************************************************************/
template <class T>
char** LineCalculator<T>::HistoryListBase(int offset)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HistoryListBase(offset);

  return (_CmdHistoryList+offset);
}

/****************************************************************************/
template <class T>
CalculatorBase::CONSTARRAY LineCalculator<T>::HistoryListBase(int offset) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ConstParentPtr->HistoryListBase(offset);

  return (_CmdHistoryList+offset);
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::HistoryListElementBase(int index, int offset)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HistoryListElementBase(index, offset);
  else if (!_CmdHistoryList[index])
    AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

  return (_CmdHistoryList[index]+offset);
}

/****************************************************************************/
template <class T>
const char* LineCalculator<T>::HistoryListElementBase(int index, int offset) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HistoryListElementBase(index, offset);
  else if (!_CmdHistoryList[index])
    AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

  return (_CmdHistoryList[index]+offset);
}

/****************************************************************************/
template <class T>
const char* LineCalculator<T>::HistoryListElementStr(int index) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HistoryListElementStr(index);
  else if (!_CmdHistoryList[index])
    AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

  return (_CmdHistoryList[index]+3);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::HistoryListElementValid(int index) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HistoryListElementValid(index);
  else if (!_CmdHistoryList[index])
    AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

  return _CmdHistoryList[index][0];
}

/****************************************************************************/
template <class T>
Ushort LineCalculator<T>::HistoryListElementSize(int index) const
{
  Ushort size_ = 0;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    size_ = _ParentPtr->HistoryListElementSize(index);
  else
  {
    if (!_CmdHistoryList[index])
      AllocateHistoryListElement(index, ::SafeStrLen(_Expression->GetExpression()) + 5);

    ::memmove(&size_, _CmdHistoryList[index]+1, 2 * sizeof(char));
  }

  return size_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::EndCommandHistoryList()
{
  if (!InProgramMode(true))
  {
    fprintf(GetCommandHistoryFile(), COMMAND_HISTORY_EOF_MARKER, CommandHistoryLength());
    SetHistoryListEnded(true);
    CloseCommandHistoryFile();
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::DisplayCommandHistoryList()
{
  if (InProgramMode(true))
    return;

  int x;
  int max = CommandHistoryLength();
  ClearCommandHistoryFile();

  for (x = 0; x < max; x++)
    WriteCommandHistoryEntry(GetCommandHistoryFile(), x);
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetNumberBase(int Base_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _NumberBase = Base_;
    _ParentPtr->SetNumberBase(Base_);
  }
  else
    _NumberBase = Base_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetAngleUnit(int Unit_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _AngleUnit = Unit_;
    _ParentPtr->SetAngleUnit(Unit_);
  }
  else
    _AngleUnit = Unit_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GetAngleUnit() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetAngleUnit();

  return _AngleUnit;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SkipEval() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SkipEval();

  return _SkipEvaluation;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSkipEval(int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _SkipEvaluation = Flag_;
    _ParentPtr->SetSkipEval(Flag_);
  }
  else
    _SkipEvaluation = Flag_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::TransferVariable(int DestIndex_, int SrceIndex_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (_PrevCalcIndex && _PrevCalcIndex != _CalcIndex)
      _ParentPtr->TransferVariable(DestIndex_, SrceIndex_);
  }
  else if (_CalcPtrArray[_CalcIndex])
  {
    bool AltBase_ = StringAssignment() && AnswerMode() == ALTBASE_MODE;
    ChrString SrceStr_ = _CalcPtrArray[_CalcIndex]->ToString(SrceIndex_);
    _TransferValue1 = SrceStr_;

    if (AltBase_)
      SrceStr_ = _TransferValue1.ToString(10);

    if (_PrevCalcIndex && _PrevCalcIndex != _CalcIndex && !IsStringVar(SrceIndex_) || AltBase_)
    {
      if (_PrevCalcIndex == CalculatorBase::FLOAT)
        ((FloatCalculator*)(_CalcPtrArray[_PrevCalcIndex]))->SetVariable(DestIndex_, Float(SrceStr_).GetData(), TRUE);
      else if (_PrevCalcIndex == CalculatorBase::DOUBLE)
        ((DoubleCalculator*)(_CalcPtrArray[_PrevCalcIndex]))->SetVariable(DestIndex_, Double(SrceStr_).GetData(), TRUE);
      else if (_PrevCalcIndex == CalculatorBase::LONGDOUBLE)
        ((LongDoubleCalculator*)(_CalcPtrArray[_PrevCalcIndex]))->SetVariable(DestIndex_, LongDouble(SrceStr_).GetData(), TRUE);
      else if (_PrevCalcIndex == CalculatorBase::LONGNUM)
        ((LongNumCalculator*)(_CalcPtrArray[_PrevCalcIndex]))->SetVariable(DestIndex_, _TransferValue1, TRUE);

      return TRUE;
    }
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::TransferIntsAndExtrema(int CalcType_, int PrevCalc_)
{
  int vx;
  int Index_ = CalcType_;
  bool ConvOk_ = false;

  ChrString SrceIntx_;
  ChrString SrceInty_;

  if (Index_ != PrevCalc_ &&
      _CalcPtrArray[Index_] && _CalcPtrArray[PrevCalc_])
  {
    for (vx = 0; vx < MAX_INT_COORDS; vx++)
    {
      ConvOk_ =
      _CalcPtrArray[PrevCalc_]->IntCoordToString(vx, SrceIntx_, SrceInty_);

      if (ConvOk_)
      {
        _TransferValue1 = SrceIntx_;
        _TransferValue2 = SrceInty_;

        if (Index_ == CalculatorBase::LONGNUM)
          ((LongNumCalculator*)(_CalcPtrArray[Index_]))->SetIntCoord(vx, _TransferValue1,
                                                                         _TransferValue2, TRUE);
        else if (Index_ == CalculatorBase::FLOAT)
          ((FloatCalculator*)(_CalcPtrArray[Index_]))->SetIntCoord(vx, Float(SrceIntx_).GetData(),
                                                                       Float(SrceInty_).GetData(), TRUE);
        else if (Index_ == CalculatorBase::DOUBLE)
          ((DoubleCalculator*)(_CalcPtrArray[Index_]))->SetIntCoord(vx, Double(SrceIntx_).GetData(),
                                                                        Double(SrceInty_).GetData(), TRUE);
        else if (Index_ == CalculatorBase::LONGDOUBLE)
          ((LongDoubleCalculator*)(_CalcPtrArray[Index_]))->SetIntCoord(vx, LongDouble(SrceIntx_).GetData(),
                                                                            LongDouble(SrceInty_).GetData(), TRUE);
      }
    }

    _CalcPtrArray[PrevCalc_]->AssignCalcData(_CalcPtrArray[Index_], Index_);
    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::RestoreCalcType()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (_PrevCalcIndex)
    {
      _ParentPtr->SetAngleUnit(_AngleUnit);
      return _ParentPtr->RestoreCalcType();
    }
  }
  else
  {
    if (_PrevCalcIndex)
    {
      SetCalcType(_PrevCalcIndex);
      return TRUE;
    }
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SwitchCalcType(int CalcType_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      _ParentPtr->SetAngleUnit(_AngleUnit);
      _ParentPtr->SwitchCalcType(CalcType_);
    }
  }
  else
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      int PrevCalcIndex_ = _CalcIndex;
      int Index_ = CalcType_;
      int VarIndex_;
      int x;

      if (_CalcPtrArray[PrevCalcIndex_] && _CalcPtrArray[Index_])
      {
        for (VarIndex_ = -1; VarIndex_ < MAXVARS; VarIndex_++)
          if (!IsStringVar(VarIndex_))
          {
            ChrString SrceStr_ = _CalcPtrArray[PrevCalcIndex_]->ToString(VarIndex_);
            _TransferValue1 = SrceStr_;

            if (Index_ == CalculatorBase::LONGNUM)
              ((LongNumCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, _TransferValue1, TRUE);
            else if (Index_ == CalculatorBase::FLOAT)
              ((FloatCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Float(SrceStr_).GetData(), TRUE);
            else if (Index_ == CalculatorBase::DOUBLE)
              ((DoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Double(SrceStr_).GetData(), TRUE);
            else if (Index_ == CalculatorBase::LONGDOUBLE)
              ((LongDoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, LongDouble(SrceStr_).GetData(), TRUE);
          }

        for (x = 1; x < MAXCALC && _CalcPtrArray[x]; x++)
          _CalcPtrArray[x]->SetCalcIndexes(PrevCalcIndex_, CalcType_);

        TransferIntsAndExtrema(CalcType_, PrevCalcIndex_);
      }
    }
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcType(int CalcType_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      _ParentPtr->SetAngleUnit(_AngleUnit);
      _ParentPtr->SetCalcType(CalcType_);
    }
  }
  else
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      int PrevCalcIndex_ = _CalcIndex;
      int Index_ = CalcType_;
      int VarIndex_ = -1;
      int x;

      if (_CalcPtrArray[PrevCalcIndex_] && _CalcPtrArray[Index_])
      {
        ChrString SrceStr_ = _CalcPtrArray[PrevCalcIndex_]->ToString(VarIndex_);
        _TransferValue1 = SrceStr_;

        // note: only result value is transferred, VarIndex_ == -1
        //       all other calculator variables are left in their original state
        if (Index_ == CalculatorBase::LONGNUM)
          ((LongNumCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, _TransferValue1, TRUE);
        else if (Index_ == CalculatorBase::FLOAT)
          ((FloatCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Float(SrceStr_).GetData(), TRUE);
        else if (Index_ == CalculatorBase::DOUBLE)
          ((DoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Double(SrceStr_).GetData(), TRUE);
        else if (Index_ == CalculatorBase::LONGDOUBLE)
          ((LongDoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, LongDouble(SrceStr_).GetData(), TRUE);

        for (x = 1; x < MAXCALC && _CalcPtrArray[x]; x++)
          _CalcPtrArray[x]->SetCalcIndexes(0, CalcType_);
      }
    }
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::TransferCalcType(int CalcType_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      _ParentPtr->SetAngleUnit(_AngleUnit);
      _ParentPtr->TransferCalcType(CalcType_);
    }
  }
  else
  {
    if (CalcType_ && _CalcIndex != CalcType_)
    {
      int PrevCalcIndex_ = _CalcIndex;
      int Index_ = CalcType_;
      int VarIndex_;
      int x;

      if (_CalcPtrArray[PrevCalcIndex_] && _CalcPtrArray[Index_])
      {
        for (VarIndex_ = -1; VarIndex_ < MAXVARS; VarIndex_++)
          if (!IsStringVar(VarIndex_))
          {
            ChrString SrceStr_ = _CalcPtrArray[PrevCalcIndex_]->ToString(VarIndex_);
            _TransferValue1 = SrceStr_;

            if (Index_ == CalculatorBase::LONGNUM)
              ((LongNumCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, _TransferValue1, TRUE);
            else if (Index_ == CalculatorBase::FLOAT)
              ((FloatCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Float(SrceStr_).GetData(), TRUE);
            else if (Index_ == CalculatorBase::DOUBLE)
              ((DoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, Double(SrceStr_).GetData(), TRUE);
            else if (Index_ == CalculatorBase::LONGDOUBLE)
              ((LongDoubleCalculator*)(_CalcPtrArray[Index_]))->SetVariable(VarIndex_, LongDouble(SrceStr_).GetData(), TRUE);
          }

        for (x = 1; x < MAXCALC && _CalcPtrArray[x]; x++)
          _CalcPtrArray[x]->SetCalcIndexes(0, CalcType_);

        TransferIntsAndExtrema(CalcType_, PrevCalcIndex_);
      }
    }
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetCalcIndexes(int Prev_, int New_)
{
   _PrevCalcIndex = Prev_;
   _CalcIndex = New_;
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::GetCalcType()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetCalcType();

  return _CalcPtrArray[_CalcIndex];
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::GetPrevCalcType()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetPrevCalcType();

  if (_PrevCalcIndex)
    return _CalcPtrArray[_PrevCalcIndex];

  return NULL;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetSuppressOutput(int Flag_, int ShowSuppressedErrors_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _SuppressOutput = Flag_;
    _ParentPtr->SetSuppressOutput(Flag_, ShowSuppressedErrors_);
  }
  else
  {
    _SuppressOutput = Flag_;
    if (!Flag_ && HasErrors() && ShowSuppressedErrors_)
      DisplayErrorMessageForCode(GetOutputFile(), GetErrorVal());
  }
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::SuppressOutput() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SuppressOutput();

  return (_SuppressOutput != 0);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::GetErrorVal() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetErrorVal();

  return _ErrorValue;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::HasErrors() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HasErrors();

  return (_ErrorValue != 0);
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetError(int ErrVal_, bool ClearErr_)
{
  // ClearErr_ flag is needed to insure only one error code is set
  // at any one time and cannot be replaced with another error code
  // until explictly cleared to zero first.
  //
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (!_ErrorValue || ClearErr_)
      _ErrorValue = ErrVal_;

    _ParentPtr->SetError(ErrVal_, ClearErr_);
  }
  else
  {
    if (!_ErrorValue || ClearErr_)
      _ErrorValue = ErrVal_;
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetMultiErrorVector(int Vect_, int* MaxSel_, int* ErrVals_, int size_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _MultiErrorVector = Vect_;
    _MultiErrorMaxSel = MaxSel_;
    _MultiErrorErrVals = ErrVals_;
    _MultiErrorMaxSize = size_;

    _ParentPtr->SetMultiErrorVector(Vect_, MaxSel_, ErrVals_, size_);
  }
  else
  {
    if (_MultiErrorMaxSel != MaxSel_ && _MultiErrorErrVals != ErrVals_)
    {
      _MemDel->DelayedDeleteVoidp(_MultiErrorMaxSel, STOREMEM);
      _MemDel->DelayedDeleteVoidp(_MultiErrorErrVals, STOREMEM);

      _MultiErrorMaxSel = MaxSel_;
      _MultiErrorErrVals = ErrVals_;
    }

    _MultiErrorVector = Vect_;
    _MultiErrorMaxSize = size_;
  }
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::HasMultiErrors() const
{
  return (_MultiErrorMaxSel && _MultiErrorErrVals &&
          _MultiErrorVector && _MultiErrorMaxSize);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::FindMultiErrors(int& ErrorCnt_, int& ErrorVal_)
{
  if (!_MultiErrorMaxSel || !_MultiErrorErrVals ||
      !_MultiErrorVector || !_MultiErrorMaxSize)
    return 0;

  int x;
  int max = _MultiErrorMaxSize;
  int* CondArray = _MultiErrorMaxSel;
  int* ErrValArray = _MultiErrorErrVals;

  if (ErrorCnt_ > 0 && ErrorVal_ != 0)
  {
    --ErrorCnt_;

    for (x = 0; x < max; x++)
      if (ErrorVal_ & CondArray[x])
        break;

    ErrorVal_ &= ~CondArray[x];
    _MultiErrorVector &= ~CondArray[x];

    return ErrValArray[x];
  }
  else if (ErrorCnt_ < 0)
  {
    ErrorCnt_ = 0;
    ErrorVal_ = _MultiErrorVector;

    for (x = 0; x < max; x++)
      if (ErrorVal_ & CondArray[x])
        ++ErrorCnt_;

    if (ErrorCnt_)
      return FindMultiErrors(ErrorCnt_, ErrorVal_);
  }

  return 0;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ClearError()
{
  SetError(0, true);
}

/*****************************************************************************/
template <class T>
bool LineCalculator<T>::InRunningProgram(bool BatchFile_, bool InProgram_,
                                         bool PrevProgram_, bool AndOptions_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InRunningProgram(BatchFile_, InProgram_,
                                        PrevProgram_, AndOptions_);

  bool InBatch_ = false;
  bool InBatchRet_ = false;
  bool InProgramRet_ = false;

  long ProgID_ = 0;
  CalcProgram* ProgramPtr_ = NULL;
  CalcProgram* Program_ = NULL;

  InBatch_ = _BatchExecLevel &&
             _ExecuteProgram && _ExecuteProgram->Name() &&
             ExecInputFileData() && !_InSpawnedCalc &&
             ExecInputFileData() == ExecInputFileDataCnt();

  InBatchRet_ = InBatch_ && !AckPostExecInputFileData() &&
                InputDataFileExecLock() == EXECFILE_LOCKED;

  ProgramPtr_ = (InProgramMode(false) && _BatchExecLevel) ?
                    ActiveProgram(NULL, PrevProgram_ ? -1:0):NULL;

  ProgID_ = PrevProgram_ ? GivePrevProgramID():
                           GiveProgramID();

  Program_ = ProgID_ ? FindProgramFromID(ProgID_, !PrevProgram_):NULL;

  InProgramRet_ = (ProgramPtr_ && Program_ && ProgID_) ?
                       !IsUserPrompterProgram(Program_):false;

  return
  (
    (BatchFile_ && !InProgram_) ? (InBatchRet_ && !InProgramRet_):
    (!BatchFile_ && InProgram_) ? (!InBatchRet_ && InProgramRet_):
    (BatchFile_ && InProgram_) ?
         (AndOptions_ ? (InBatchRet_ && InProgramRet_):
                        (InBatchRet_ || InProgramRet_)):
         (!InBatchRet_ && !InProgramRet_)
  );
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InBatchFile(bool GraphOnly_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InBatchFile(GraphOnly_);

  if (GraphOnly_)
    return (WasInBatchDataInput() &&
            InAllGraphsFile() &&
            InputDataFilePauseOption());
  else if (StartAsStdInput())
    return ((InputDataFileExecLock() == EXECFILE_KEY_SET ||
             InputDataFileExecLock() == EXECFILE_LOCKED) &&
            WasInBatchDataInput() &&
            !NoPauseFileInput() &&
            !AckPostExecInputFileData() &&
            !PostExecResetProcessDone());

  const CalcProgram* Program_ = NULL;
  long ProgID_ = 0;
  bool WasInBatchFile_ = false;
  bool TestPausedBatch_ = false;

  if (StartAsStdInput() || SessionOption() || NoPauseFileInput())
  {
    WasInBatchFile_ = _InputExists &&
                      _InputFileLineSize &&
                      WasInBatchDataInput();
    TestPausedBatch_ = false;
  }
  else if (InputDataFilePauseOption())
  {
    ProgID_ = GiveProgramID();
    Program_ = ProgID_ ? FindProgramFromID(ProgID_, true):NULL;
    WasInBatchFile_ = Program_ && ProgID_;
    TestPausedBatch_ = true;
  }

  bool InPausedBatch_ = !InAllGraphsFile() &&
                        InputDataFilePauseOption() &&
                        TestPausedBatch_ && WasInBatchFile_;

  bool FileInput_ = !InAllGraphsFile() && _CmdLineOptions &&
                    _CmdLineOptions->inputexists &&
                    !TestPausedBatch_ && WasInBatchFile_;

  bool NoPause_ = NoPauseFileInput() &&
                  (SessionOption() || FileInput_ ||
                   (InputDataFileExecLock() != EXECFILE_KEY_SET &&
                    InputDataFileExecLock() != EXECFILE_LOCKED));

  return ((NoPause_ ||
           (!NoPauseFileInput() &&
            (InAllGraphsFile() || InPausedBatch_ ||
             InputDataFileExecLock() == EXECFILE_KEY_SET ||
             InputDataFileExecLock() == EXECFILE_LOCKED))) &&
          (BatchExecLevel() > 1 ||
           (!AckPostExecInputFileData() &&
            !PostExecResetProcessDone())));
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InPausedBatchFile(bool GraphOnly_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InPausedBatchFile(GraphOnly_);

  if (GraphOnly_)
    return (WasInBatchDataInput() &&
            InAllGraphsFile() &&
            InputDataFilePauseOption() &&
            GraphFilePause());
  else if (StartAsStdInput())
    return ((InputDataFileExecLock() == EXECFILE_KEY_SET ||
             InputDataFileExecLock() == EXECFILE_LOCKED) &&
            WasInBatchDataInput() &&
            !NoPauseFileInput() &&
            InputDataFilePauseOption() &&
            !AckPostExecInputFileData() &&
            !PostExecResetProcessDone());

  const CalcProgram* Program_ = NULL;
  long ProgID_ = 0;
  bool WasInBatchFile_ = false;
  bool TestPausedBatch_ = false;

  if (StartAsStdInput() || SessionOption() || NoPauseFileInput())
  {
    WasInBatchFile_ = _InputExists &&
                      _InputFileLineSize &&
                      WasInBatchDataInput();
    TestPausedBatch_ = false;
  }
  else if (InputDataFilePauseOption())
  {
    ProgID_ = GiveProgramID();
    Program_ = ProgID_ ? FindProgramFromID(ProgID_, true):NULL;
    WasInBatchFile_ = Program_ && ProgID_;
    TestPausedBatch_ = true;
  }

  bool InPausedBatch_ = !InAllGraphsFile() &&
                        InputDataFilePauseOption() &&
                        TestPausedBatch_ && WasInBatchFile_;

  bool FileInput_ = !InAllGraphsFile() && _CmdLineOptions &&
                    _CmdLineOptions->inputexists &&
                    !TestPausedBatch_ && WasInBatchFile_;

  bool NoPause_ = NoPauseFileInput() &&
                  (SessionOption() || FileInput_ ||
                   (InputDataFileExecLock() != EXECFILE_KEY_SET &&
                    InputDataFileExecLock() != EXECFILE_LOCKED));

  return (!NoPause_ &&
          ((!InAllGraphsFile() && !NoPause_ && InPausedBatch_) ||
           (InAllGraphsFile() && !NoPause_ && GraphFilePause())) &&
          (BatchExecLevel() > 1 ||
           (!AckPostExecInputFileData() &&
            !PostExecResetProcessDone())));
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InNonPausedBatchFile(bool GraphOnly_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InNonPausedBatchFile(GraphOnly_);

  if (GraphOnly_)
    return (WasInBatchDataInput() &&
            InAllGraphsFile() &&
            InputDataFilePauseOption() &&
            !GraphFilePause());
  else if (StartAsStdInput())
    return ((InputDataFileExecLock() == EXECFILE_KEY_SET ||
             InputDataFileExecLock() == EXECFILE_LOCKED) &&
            WasInBatchDataInput() &&
            !NoPauseFileInput() &&
            !InputDataFilePauseOption() &&
            !AckPostExecInputFileData() &&
            !PostExecResetProcessDone());

  const CalcProgram* Program_ = NULL;
  long ProgID_ = 0;
  bool WasInBatchFile_ = false;
  bool TestPausedBatch_ = false;

  if (StartAsStdInput() || SessionOption() || NoPauseFileInput())
  {
    WasInBatchFile_ = _InputExists &&
                      _InputFileLineSize &&
                      WasInBatchDataInput();
    TestPausedBatch_ = false;
  }
  else if (InputDataFilePauseOption())
  {
    ProgID_ = GiveProgramID();
    Program_ = ProgID_ ? FindProgramFromID(ProgID_, true):NULL;
    WasInBatchFile_ = Program_ && ProgID_;
    TestPausedBatch_ = true;
  }

  bool InPausedBatch_ = !InAllGraphsFile() &&
                        InputDataFilePauseOption() &&
                        TestPausedBatch_ && WasInBatchFile_;

  bool FileInput_ = !InAllGraphsFile() && _CmdLineOptions &&
                    _CmdLineOptions->inputexists &&
                    !TestPausedBatch_ && WasInBatchFile_;

  bool NoPause_ = NoPauseFileInput() &&
                  (SessionOption() || FileInput_ ||
                   (InputDataFileExecLock() != EXECFILE_KEY_SET &&
                    InputDataFileExecLock() != EXECFILE_LOCKED));

  return ((NoPause_ ||
           (!InAllGraphsFile() && NoPause_ && !InPausedBatch_) ||
           (InAllGraphsFile() && NoPause_ && !GraphFilePause())) &&
          (BatchExecLevel() > 1 ||
           (!AckPostExecInputFileData() &&
            !PostExecResetProcessDone())));
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::NoPauseFileInput() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->NoPauseFileInput();

  return _NoPauseFileInput;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetNoPauseFileInput(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _NoPauseFileInput = flag_;
    _ParentPtr->SetNoPauseFileInput(flag_);
  }
  else
    _NoPauseFileInput = flag_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InputDataFilePauseOption() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InputDataFilePauseOption();

  return _InputDataFileLinePause;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetInputDataFilePauseOption(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InputDataFileLinePause = flag_;
    _ParentPtr->SetInputDataFilePauseOption(flag_);
  }
  else
    _InputDataFileLinePause = flag_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::AckPostExecInputFileData() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->AckPostExecInputFileData();

  return _AckPostExecInputFileData;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetAckPostExecInputFileData(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _AckPostExecInputFileData = flag_;
    _ParentPtr->SetAckPostExecInputFileData(flag_);
  }
  else
    _AckPostExecInputFileData = flag_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::ResetAckPostExecInputFileData()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _AckPostExecInputFileData = 0;
    _ParentPtr->ResetAckPostExecInputFileData();
  }
  else
    _AckPostExecInputFileData = 0;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PostExecResetProcessDone() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->PostExecResetProcessDone();

  return _PostExecResetProcessDone;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetPostExecResetProcessDone(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _PostExecResetProcessDone = flag_;
    _ParentPtr->SetPostExecResetProcessDone(flag_);
  }
  else
    _PostExecResetProcessDone = flag_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::ResetPostExecResetProcessDone()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _PostExecResetProcessDone = 0;
    _ParentPtr->ResetPostExecResetProcessDone();
  }
  else
    _PostExecResetProcessDone = 0;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ExecInputFileData() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ExecInputFileData();

  return _ExecInputFileData;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetExecInputFileData(int flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ExecInputFileData = flag_;
    _ParentPtr->SetExecInputFileData(flag_);
  }
  else
    _ExecInputFileData = flag_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::ResetExecInputFileData()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ExecInputFileData = 0;
    _ParentPtr->ResetExecInputFileData();
  }
  else
    _ExecInputFileData = 0;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InputDataFileExecLock() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InputDataFileExecLock();

  return _InputDataFileExecLock;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetInputDataFileExecLock(int val_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InputDataFileExecLock = val_;
    _ParentPtr->SetInputDataFileExecLock(val_);
  }
  else
    _InputDataFileExecLock = val_;
}

/*****************************************************************************/
template <class T>
bool LineCalculator<T>::IsUserPrompterProgram(const CalcProgram* ptr) const
{
  if (!ptr)
    return false;

  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->IsUserPrompterProgram(ptr);

  return (_InputPrompter && _InputPrompter == ptr);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetUserPrompterProgram(CalcProgram* ptr)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InputPrompter = ptr;
    _ParentPtr->SetUserPrompterProgram(ptr);
  }
  else
    _InputPrompter = ptr;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PrevInputFileSet()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->PrevInputFileSet();

  return _previnputfileset;
}

/*****************************************************************************/
template <class T>
FILE* LineCalculator<T>::PrevInputFile()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->PrevInputFile();

  return (_previnputfileset ? _previnputfile:NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SetPrevInputFile(FILE* ptr, int ConfirmSet_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _previnputfileset = ConfirmSet_;
    _previnputfile = ptr;
    _ParentPtr->SetPrevInputFile(ptr, ConfirmSet_);
  }
  else
  {
    _previnputfileset = ConfirmSet_;
    _previnputfile = ptr;
  }

  return ConfirmSet_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::PrevOutputFileSet()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->PrevOutputFileSet();

  return _prevoutputfileset;
}

/*****************************************************************************/
template <class T>
FILE* LineCalculator<T>::PrevOutputFile()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->PrevOutputFile();

  return (_prevoutputfileset ? _prevoutputfile:NULL);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SetPrevOutputFile(FILE* ptr, int ConfirmSet_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _prevoutputfileset = ConfirmSet_;
    _prevoutputfile = ptr;
    _ParentPtr->SetPrevOutputFile(ptr, ConfirmSet_);
  }
  else
  {
    _prevoutputfileset = ConfirmSet_;
    _prevoutputfile = ptr;
  }

  return ConfirmSet_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetHasAnswer(Boolean Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->SetHasAnswer(Flag_);
  }
  else
  {
    if (_ActiveExpression && _ActiveExpression->GiveData())
      _ActiveExpression->GiveData()->SetHasAnswer(Flag_);
    else if (_Expression)
      _Expression->SetHasAnswer(Flag_);
    else if (_SubExprStack && _ExprStackIndex && _SubExprStack[_ExprStackIndex - 1])
      _SubExprStack[_ExprStackIndex - 1]->SetHasAnswer(Flag_);

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::HasAnswer() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HasAnswer();

  if (_ActiveExpression && _ActiveExpression->GiveData())
    return _ActiveExpression->GiveData()->HasAnswer();

  if (_Expression)
    return _Expression->HasAnswer();

  if (_ExprStackIndex && _SubExprStack[_ExprStackIndex - 1])
    return _SubExprStack[_ExprStackIndex - 1]->HasAnswer();

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetShowAnswer(Boolean Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ParentPtr->SetChild(this);
    _ParentPtr->SetShowAnswer(Flag_);
  }
  else
  {
    if (_ActiveExpression && _ActiveExpression->GiveData())
      _ActiveExpression->GiveData()->SetShowAnswer(Flag_);
    else if (_Expression)
      _Expression->SetShowAnswer(Flag_);
    else if (_ExprStackIndex && _SubExprStack[_ExprStackIndex - 1])
      _SubExprStack[_ExprStackIndex - 1]->SetShowAnswer(Flag_);

    if (_ChildPtr)
    {
      _ChildPtr->TransferVarsForSubExpr(this);
      _ChildPtr = NULL;
    }
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ShowAnswer() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ShowAnswer();

  if (_ActiveExpression && _ActiveExpression->GiveData())
    return _ActiveExpression->GiveData()->ShowAnswer();

  if (_Expression)
    return _Expression->ShowAnswer();

  if (_ExprStackIndex && _SubExprStack[_ExprStackIndex - 1])
    return _SubExprStack[_ExprStackIndex - 1]->ShowAnswer();

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::ResetAnswerMode()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ModeFinalized = FALSE;
    _InitialMode = TRUE;

    _ParentPtr->ResetAnswerMode();
  }
  else
  {
    _ModeFinalized = FALSE;
    _InitialMode = TRUE;
  }
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetAnswerMode(int Mode_, int Final_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _InitialMode = FALSE;

    if (!_ModeFinalized)
    {
      _AnswerMode = Mode_;
      _ModeFinalized = Final_;
    }

    _ParentPtr->SetAnswerMode(Mode_, Final_);
  }
  else
  {
    _InitialMode = FALSE;

    if (!_ModeFinalized)
    {
      _AnswerMode = Mode_;
      _ModeFinalized = Final_;
    }
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::AnswerMode() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->AnswerMode();

  return _AnswerMode;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::InitialMode() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->InitialMode();

  return _InitialMode;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ModeFinalized() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ModeFinalized();

  return _ModeFinalized;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetEvalStrings(int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _EvalStrings = Flag_;
    _ParentPtr->SetEvalStrings(Flag_);
  }
  else
    _EvalStrings = Flag_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetReEvalStrings(int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _ReEvalStrings = Flag_;
    _ParentPtr->SetReEvalStrings(Flag_);
  }
  else
    _ReEvalStrings = Flag_;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::EvalStrings() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->EvalStrings();

  return _EvalStrings;
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::ReEvalStrings() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ReEvalStrings();

  return _ReEvalStrings;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSetAssignment(int Flag_, const char* Str_, int Null_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetSetAssignment(Flag_, Str_, Null_);
  else
  {
    if (Flag_)
    {
      _SetOperation |= SET_ASSIGNMENT;
      _StringOperation = STRING_ASSIGNMENT;
    }
    else
    {
      _SetOperation &= ~SET_ASSIGNMENT;
      _StringOperation = 0;
    }

    if (Str_)
      SetSetResult(Str_, Null_);
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SetAssignment() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SetAssignment();

  return (_SetOperation & SET_ASSIGNMENT);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSetOperation(int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetSetOperation(Flag_);
  else
  {
    if (Flag_)
      _SetOperation |= SET_OPERATION;
    else
      // setting _SetOperation to false will zero out all operations
      _SetOperation = 0;
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::SetOperation() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->SetOperation();

  return (_SetOperation & SET_OPERATION);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::IsNullSet(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->IsNullSet(Index_);

  return (_StrVarData ? _StrVarData->IsNullSet(Index_):0);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetStringAssignment(int Flag_, const char* Str_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetStringAssignment(Flag_, Str_);
  else
  {
    if (Flag_)
      _StringOperation = STRING_ASSIGNMENT;
    else
      _StringOperation = 0;

    if (Str_)
      SetStrResult(Str_);
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::StringAssignment() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->StringAssignment();

  return (_StringOperation == STRING_ASSIGNMENT);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetStringComparison(int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetStringComparison(Flag_);
  else
  {
    if (Flag_)
      _StringOperation = STRING_COMPARISON;
    else
      _StringOperation = 0;
  }
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::StringComparison() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->StringComparison();

  return (_StringOperation == STRING_COMPARISON);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSetVariable(int x, const ChrString& Str_, int Null_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetSetVariable(x, Str_, Null_);
  else if (_StrVarData)
    _StrVarData->SetSetElements(x, Str_, Null_);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetStrVariable(int x, const ChrString& Str_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetStrVariable(x, Str_);
  else if (_StrVarData)
    _StrVarData->SetString(x, Str_);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetStrResult(const char* Str_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetStrResult(Str_);
  else if (_StrVarData)
    _StrVarData->SetResult(Str_);
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSetResult(const char* Str_, int Null_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetSetResult(Str_, Null_);
  else if (_StrVarData)
    _StrVarData->SetSetResult(Str_, Null_);
}

/*****************************************************************************/
template <class T>
const ChrString& LineCalculator<T>::GetStrResult() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetStrResult();

  ChrString Dummy_;
  return (_StrVarData ? _StrVarData->GetResult():Dummy_);
}

/*****************************************************************************/
template <class T>
const ChrString& LineCalculator<T>::GetStrVariable(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetStrVariable(Index_);

  ChrString Dummy_;
  return (_StrVarData ? _StrVarData->GetVariable(Index_):Dummy_);
}

/*****************************************************************************/
template <class T>
const ChrString& LineCalculator<T>::GetSetResult() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetSetResult();

  ChrString Dummy_;
  return (_StrVarData ? _StrVarData->GetSetResult():Dummy_);
}

/*****************************************************************************/
template <class T>
const ChrString& LineCalculator<T>::GetSetVariable(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetSetVariable(Index_);

  ChrString Dummy_;
  return (_StrVarData ? _StrVarData->GetSetVariable(Index_):Dummy_);
}

/*****************************************************************************/
template <class T>
size_t LineCalculator<T>::GetStrVarLen(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->GetStrVarLen(Index_);

  if (Index_ == CalculatorBase::LITERAL_MODE ||
      Index_ == CalculatorBase::ALTBASE_MODE ||
      Index_ == CalculatorBase::FRACTION_MODE)
    if (Index_ == CalculatorBase::FRACTION_MODE)
    {
      const char* Fraction_ = FractionStr();
      return ::SafeStrLen(Fraction_);
    }
    else
    {
      const char* Literal_ = LiteralStr();
      return ::SafeStrLen(Literal_);
    }

  if (Index_ < MAXVARS && _StrVarData)
    return _StrVarData->GetVarLen(Index_);

  return 0;
}

/*****************************************************************************/
template <class T>
char* LineCalculator<T>::CopyStrVar(char* DestStr_, int Index_)
{
  static char* Dummy_ = NULL;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CopyStrVar(DestStr_, Index_);

  if (Index_ == CalculatorBase::LITERAL_MODE ||
      Index_ == CalculatorBase::ALTBASE_MODE ||
      Index_ == CalculatorBase::FRACTION_MODE)
    if (Index_ == CalculatorBase::FRACTION_MODE)
    {
      const char* Fraction_ = FractionStr();
      if (Fraction_ && DestStr_)
        strcpy(DestStr_, Fraction_);
      return DestStr_;
    }
    else
    {
      const char* Literal_ = LiteralStr();
      if (Literal_ && DestStr_)
        strcpy(DestStr_, Literal_);
      return DestStr_;
    }

  if (Index_ < MAXVARS && _StrVarData)
    return _StrVarData->CopyStrVar(DestStr_, Index_);

  return Dummy_;
}

/*****************************************************************************/
template <class T>
ChrString& LineCalculator<T>::CopyStrVar(ChrString& DestStr_, int Index_)
{
  static ChrString Dummy_;
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->CopyStrVar(DestStr_, Index_);

  if (Index_ == CalculatorBase::LITERAL_MODE ||
      Index_ == CalculatorBase::ALTBASE_MODE ||
      Index_ == CalculatorBase::FRACTION_MODE)
    if (Index_ == CalculatorBase::FRACTION_MODE)
    {
      const char* Fraction_ = FractionStr();
      if (Fraction_)
        DestStr_ = Fraction_;
      return DestStr_;
    }
    else
    {
      const char* Literal_ = LiteralStr();
      if (Literal_)
        DestStr_ = Literal_;
      return DestStr_;
    }

  if (Index_ < MAXVARS && _StrVarData)
    return _StrVarData->CopyStrVar(DestStr_, Index_);

  return Dummy_;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetStringVar(int Index_, Boolean Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetStringVar(Index_, Flag_);
  else if (_StrVarData)
    _StrVarData->SetStringVar(Index_, Flag_);
}

/*****************************************************************************/
template <class T>
Boolean LineCalculator<T>::IsStringVar(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->IsStringVar(Index_);

  if (Index_ == CalculatorBase::LITERAL_MODE ||
      Index_ == CalculatorBase::ALTBASE_MODE ||
      Index_ == CalculatorBase::FRACTION_MODE)
    return TRUE;

  if (Index_ < MAXVARS && _StrVarData)
    return _StrVarData->IsStringVar(Index_);

  return FALSE;
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetSetVar(int Index_, int Flag_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetSetVar(Index_, Flag_);
  else if (_StrVarData)
    _StrVarData->SetSetVar(Index_, Flag_);
}

/*****************************************************************************/
template <class T>
int LineCalculator<T>::IsSetVar(int Index_) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->IsSetVar(Index_);

  if (Index_ == CalculatorBase::LITERAL_MODE ||
      Index_ == CalculatorBase::ALTBASE_MODE ||
      Index_ == CalculatorBase::FRACTION_MODE)
    return TRUE;

  if (Index_ < MAXVARS && _StrVarData)
    return _StrVarData->IsSetVar(Index_);

  return FALSE;
}

/*****************************************************************************/
template <class T>
Boolean LineCalculator<T>::IsHexVar(int Index_) const
{
  if (IsStringVar(Index_))
  {
    ChrString VarStr_ = GetStrVariable(Index_);
    return IsIntHex(VarStr_.c_str());
  }

  return FALSE;
}

/*****************************************************************************/
template <class T>
Boolean LineCalculator<T>::IsOctVar(int Index_) const
{
  if (IsStringVar(Index_))
  {
    ChrString VarStr_ = GetStrVariable(Index_);
    return IsIntOct(VarStr_.c_str());
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ClearOriginalStr()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->ClearOriginalStr();
  else
  {
    if (_OriginalStr)
      _OriginalStr[0] = 0;
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ClearAnswerStr(bool BlankAns_, int Mode_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->ClearAnswerStr();
  else
  {
    int OldMode_ = AnswerMode();
    int CurrMode_ = Mode_ ? Mode_:OldMode_;

    if (BlankAns_ && CurrMode_)
    {
      if (CurrMode_ == FLOATINGPOINT_MODE && _AnswerStr)
        _AnswerStr[0] = 0;
      else if (CurrMode_ == LITERAL_MODE && _LiteralStr)
        _LiteralStr[0] = 0;
      else if (CurrMode_ == FRACTION_MODE && _FractionStr)
        _FractionStr[0] = 0;
    }

    SetHasAnswer(FALSE);
    ClearResultsShown();
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ClearResultsShown()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->ClearResultsShown();
  else
  {
    _ResultsShown = false;
    _ResultsPending = false;
    _ShownToPrompt = false;
    SetAnsStrShown("");
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::EraseAllAnswerStr()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    if (_AnswerStr)
    {
      _MemDel->DelayedDeleteCstr(_AnswerStr, STOREMEM);
      _AnswerStr = NULL;
    }

    if (_LiteralStr)
    {
      _MemDel->DelayedDeleteCstr(_LiteralStr, STOREMEM);
      _LiteralStr = NULL;
    }

    if (_FractionStr)
    {
      _MemDel->DelayedDeleteCstr(_FractionStr, STOREMEM);
      _FractionStr = NULL;
    }

    SetHasAnswer(FALSE);
    _ParentPtr->EraseAllAnswerStr();
  }
  else
  {
    if (_AnswerStr)
    {
      _MemDel->DelayedDeleteCstr(_AnswerStr, STOREMEM);
      _AnswerStr = NULL;
    }

    if (_LiteralStr)
    {
      _MemDel->DelayedDeleteCstr(_LiteralStr, STOREMEM);
      _LiteralStr = NULL;
    }

    if (_FractionStr)
    {
      _MemDel->DelayedDeleteCstr(_FractionStr, STOREMEM);
      _FractionStr = NULL;
    }

    SetHasAnswer(FALSE);
  }
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::AnswerChrStr() const
{
  int Mode_ = AnswerMode();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr =
    (
      (Mode_ == CalculatorBase::FRACTION_MODE) ? FractionStr():
      (Mode_ == CalculatorBase::LITERAL_MODE ||
       Mode_ == CalculatorBase::ALTBASE_MODE) ? LiteralStr():FloatStr()
    );

    return _RetAnswerStr;
  #else
    ChrString Dummy_ =
    (
      (Mode_ == CalculatorBase::FRACTION_MODE) ? FractionStr():
      (Mode_ == CalculatorBase::LITERAL_MODE ||
       Mode_ == CalculatorBase::ALTBASE_MODE) ? LiteralStr():FloatStr()
    );

    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
template <class T>
const char* LineCalculator<T>::AnswerStr(ChrString* ret)
{
  // Cond_LineEvalDone    = 0x0001,   // Expression line evaluation completed
  // Cond_VariableEval    = 0x0002,   // Variable contents evaluation completed
  // Cond_FormatInvalid   = 0x0004,   // Math expression line format is invalid
  // Cond_ConversionError = 0x0008,   // InfixToRpn conversion error detected
  // Cond_PrgLoadError    = 0x0010,   // Program loading encountered problems
  // Cond_PauseSwitch     = 0x0020,   // Pause option selected for executing input data files
  // Cond_InvalidSwitch   = 0x0040,   // Invalid switch specified for executing input data files
  // Cond_MutualExclOpt   = 0x0080,   // Error detected, mutually exclusive options selected
  // Cond_NullCalcPtr     = 0x4000,   // Unexpected null calculator pointer, processing cannot continue
  //
  // Cond_VariableDisplay = 0x0100,   // Variable display completed
  // Cond_MessageDisp     = 0x0200,   // Text message display completed
  // Cond_AnswerDisp      = 0x0400,   // Calculated answer display completed: (float, literal, fraction)
  // Cond_VariableDump    = 0x0800,   // Output dump of all letter variables and answer variables completed
  // Cond_ProgressDisp    = 0x1000,   // Progress data display completed
  // Cond_PrgSelected     = 0x2000    // Calculator program selected to be executed
  //
  // Out_AnsVar           = 0x0001,   // Calculator answer number variable outputted
  // Out_AnsStrVar        = 0x0002,   // Calculator answer string variable outputted
  // Out_FracAnsVar       = 0x0004,   // Calculator fraction answer variable outputted
  // Out_LetterVar        = 0x0008,   // User accessible letter variable outputted
  // Out_VariableMask     = 0x000F,   // Variable data type bit mask
  //
  // Out_ErrorMessage     = 0x0010,   // Error message outputted
  // Out_HelpMessage      = 0x0020,   // Help message outputted
  // Out_TextMessage      = 0x0040,   // Text message outputted
  // Out_MessageMask      = 0x0070,   // Message data type bit mask
  // Out_MessageString    = 0x0080,   // Message string category of output data sent
  //
  // Out_LiteralAnswer    = 0x0100,   // Literal answer outputted
  // Out_FractionAnswer   = 0x0200,   // Fraction answer outputted
  // Out_FloatAnswer      = 0x0400,   // Float answer outputted
  // Out_AnswerMask       = 0x0700,   // Answer data type bit mask
  // Out_AnswerString     = 0x0800,   // Answer string category of output data sent
  //
  // Out_VariableDisplay  = 0x1000,   // Single letter variable or calculator answer variable is displayed
  // Out_VariableDump     = 0x2000,   // All letter Variables and calculator answer variables output dumped
  // Out_ProgressData     = 0x4000    // Progress data outputted
  //

  long ProgID_ = GiveProgramID();
  CalcProgram* Program_ = (InProgramMode(true) && ProgID_) ?
                                FindProgramFromID(ProgID_, true):
                                NULL;
  CalculatorBase* ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;
  CalculatorBase* CalcPtr_ = GetCalcType();

  if (ProgCalc_ != CalcPtr_ && Program_ && CalcPtr_)
  {
    Program_->SetCalculator(CalcPtr_);
    ProgCalc_ = CalcPtr_;
  }

  ChrString Str_;
  ChrString RetAnsStr_;

  bool GetAnsStrShown_ = false;
  bool StringVar_ = false;
  bool FloatVar_ = false;
  bool IndexSet_ = false;
  bool HasRetAns_ = false;

  int Index_ = 0;
  int NumBase_ = 0;
  int Mode_ = AnswerMode();

  bool DispVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay);
  bool DumpVarsType_ =
    IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump);

  bool DispVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDisplay);
  bool DumpVarsCond_ =
    IsOutputCondition(Mcalc_OutputDataCondition::Cond_VariableDump);

  bool AnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsVar);
  bool AnsStrVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnsStrVar);
  bool FracAnsVarSet_ = IsOutputDataType(Mcalc_OutputDataType::Out_FracAnsVar);

  bool FloatAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_FloatAnswer);
  bool LiteralAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                      Mcalc_OutputDataType::Out_LiteralAnswer);
  bool FractionAns_ = IsOutputDataType(Mcalc_OutputDataType::Out_AnswerString|
                                       Mcalc_OutputDataType::Out_FractionAnswer);

  SubExpression* SubExpr_ = TopSubExprStack();
  bool Confirmed_;

  if (SubExpr_->GetLevel() > 0 && SubExpr_->IsParam())
    Confirmed_ = (SubExprStackIndex() == 1 ||
                  InRunningProgram(true, true, false, false)) &&
                 (!Mode_ || SubExpr_->GetAnswerMode() == Mode_);
  else
    Confirmed_ = (SubExprStackIndex() == 1 ||
                  InRunningProgram(true, true, false, false)) &&
                 !ActiveExpression() &&
                 (!SubExpr_ || SubExpr_->GetLevel() == 0);

  if (DumpVarsType_)
  {
    if (InProgramMode(false) && !DumpVarsCond_)
    {
      SetResultsPending(true);
      RetAnsStr_ = LiteralStr();
      HasRetAns_ = true;

      SetAnswerMode(LITERAL_MODE, true);
    }
    else if (DumpVarsCond_)
    {
      SetResultsShown(true);
      GetAnsStrShown_ = true;
    }
  }
  else if (DispVarsType_)
  {
    if (InProgramMode(false))
    {
      NumBase_ = CalcPtr_->NumberBase();
      RetAnsStr_ = AnsVarSet_ ? FloatStr():
                   AnsStrVarSet_ ? LiteralStr():
                   FracAnsVarSet_ ? FractionStr():"";

      if (!AnsVarSet_ && !AnsStrVarSet_ && !FracAnsVarSet_)
      {
        Index_ = GiveOutputDataIndex(IndexSet_);

        if (IndexSet_)
        {
          RetAnsStr_ = CalcPtr_->ToString(Index_);
          SetResultsPending(true);
          HasRetAns_ = true;

          if (FloatAns_)
            SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
          else if (NumBase_ == 8 || NumBase_ == 16)
            SetAnswerMode(ALTBASE_MODE, Confirmed_);
          else if (LiteralAns_ || FractionAns_)
            SetAnswerMode(LITERAL_MODE, Confirmed_);
        }
      }
      else
      {
        SetResultsPending(true);
        HasRetAns_ = true;

        if (AnsVarSet_)
          SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);
        else if (NumBase_ == 8 || NumBase_ == 16)
          SetAnswerMode(ALTBASE_MODE, Confirmed_);
        else if (AnsStrVarSet_ || FracAnsVarSet_)
          SetAnswerMode(LITERAL_MODE, Confirmed_);
      }
    }
    else if (DispVarsCond_)
    {
      SetResultsShown(true);
      GetAnsStrShown_ = true;
    }
  }

  const char* ChrRetStr_ = (Mode_ == CalculatorBase::FRACTION_MODE) ? FractionStr():
                           (Mode_ == CalculatorBase::LITERAL_MODE ||
                            Mode_ == CalculatorBase::ALTBASE_MODE) ? LiteralStr():FloatStr();

  if (!GetAnsStrShown_ &&
      !HasRetAns_ && ::SafeStrLen(ChrRetStr_))
    SetResultsPending(true);

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetAnswerStr = HasRetAns_ ? RetAnsStr_:
                    GetAnsStrShown_ ? AnsStrShown():ChrRetStr_;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetAnswerStr;
    return (ret ? ret->c_str():_RetAnswerStr.c_str());
  #else
    return
    (
      HasRetAns_ ? RetAnsStr_:
      GetAnsStrShown_ ? AnsStrShown():ChrRetStr_
    );
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetFloatStr(const char* TStr_)
{
  if (TStr_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetFloatStr(TStr_);
    else
    {
      ChrString Str_ = TStr_;
      if (_AnswerStr && Str_.strlen() > ::SafeStrLen(_AnswerStr))
      {
        _AnswerStr = _MemDel->DelayedDeleteCstr(_AnswerStr, STOREMEM);

        if (_AnswerStr)
        {
          // delayed memory deleter failed, deleting memory normally
          MemMatrix::Matrix().Deallocate(_AnswerStr);
          _AnswerStr = NULL;
        }

        _AnswerStr = strcpy(AllocateNewString(_MemDel, _AnswerStr, Str_.strlen() + 1, false, true), Str_.c_str());
      }
      else
      {
        if (!_AnswerStr)
          _AnswerStr = (char*)MemMatrix::Matrix().Allocate(Str_.strlen() + 5);

        if (Str_.strlen())
          strcpy(_AnswerStr, Str_.c_str());
        else
          _AnswerStr[0] = 0;
      }

      SetHasAnswer(::SafeStrLen(_AnswerStr));
    }
  }
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::FloatChrStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FloatChrStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFloatStr = _AnswerStr;
    return _RetFloatStr;
  #else
    ChrString Dummy_ = _AnswerMode;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
template <class T>
const char* LineCalculator<T>::FloatStr(ChrString* ret) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FloatStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFloatStr = _AnswerStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetFloatStr;
    return (ret ? ret->c_str():_RetFloatStr.c_str());
  #else
    return _AnswerStr;
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetOriginalStr(const char* TStr_)
{
  if (TStr_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetOriginalStr(TStr_);
    else
    {
      ChrString Str_ = TStr_;
      if (_OriginalStr && Str_.strlen() > ::SafeStrLen(_OriginalStr))
      {
        _OriginalStr = _MemDel->DelayedDeleteCstr(_OriginalStr, STOREMEM);

        if (_OriginalStr)
        {
          // delayed memory deleter failed, deleting memory normally
          MemMatrix::Matrix().Deallocate(_OriginalStr);
          _OriginalStr = NULL;
        }

        _OriginalStr = strcpy(AllocateNewString(_MemDel, _OriginalStr, Str_.strlen() + 1, false, true), Str_.c_str());
      }
      else
      {
        if (!_OriginalStr)
          _OriginalStr = (char*)MemMatrix::Matrix().Allocate(Str_.strlen() + 5);

        if (Str_.strlen())
          strcpy(_OriginalStr, Str_.c_str());
        else
          _OriginalStr[0] = 0;
      }
    }
  }
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::OriginalChrStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->OriginalChrStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetOriginalStr = _OriginalStr;
    return _RetOriginalStr;
  #else
    ChrString Dummy_ = _OriginalStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
template <class T>
const char* LineCalculator<T>::OriginalStr(ChrString* ret) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->OriginalStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetOriginalStr = _OriginalStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetOriginalStr;
    return (ret ? ret->c_str():_RetOriginalStr.c_str());
  #else
    return _OriginalStr;
  #endif
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetFractionStr(const char* Frac_)
{
  if (Frac_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetFractionStr(Frac_);
    else
    {
      ChrString FracStr_ = Frac_;
      if (_FractionStr && FracStr_.strlen() > ::SafeStrLen(_FractionStr))
      {
        _FractionStr = _MemDel->DelayedDeleteCstr(_FractionStr, STOREMEM);

        if (_FractionStr)
        {
          // delayed memory deleter failed, deleting memory normally
          MemMatrix::Matrix().Deallocate(_FractionStr);
          _FractionStr = NULL;
        }

        _FractionStr = strcpy(AllocateNewString(_MemDel, _FractionStr, FracStr_.strlen() + 1, false, true), FracStr_.c_str());
      }
      else
      {
        if (!_FractionStr)
          _FractionStr = (char*)MemMatrix::Matrix().Allocate(FracStr_.strlen() + 5);

        if (FracStr_.strlen())
          strcpy(_FractionStr, FracStr_.c_str());
        else
          _FractionStr[0] = 0;
      }

      SetHasAnswer(::SafeStrLen(_FractionStr));
    }
  }
}

/*****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::FractionChrStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FractionChrStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFractionStr = _FractionStr;
    return _RetFractionStr;
  #else
    ChrString Dummy_ = _FractionStr;
    return Dummy_;
  #endif
}
#endif
/*****************************************************************************/
template <class T>
const char* LineCalculator<T>::FractionStr(ChrString* ret) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->FractionStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetFractionStr = _FractionStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetFractionStr;
    return (ret ? ret->c_str():_RetFractionStr.c_str());
  #else
    return _FractionStr;
  #endif
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::SetLiteralStr(const char* Literal_)
{
  if (Literal_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetLiteralStr(Literal_);
    else
    {
      ChrString LitStr_ = Literal_;

      if (_LiteralStr && Literal_ && LitStr_.strlen() > ::SafeStrLen(_LiteralStr))
      {
        _LiteralStr = _MemDel->DelayedDeleteCstr(_LiteralStr, STOREMEM);

        if (_LiteralStr)
        {
          // delayed memory deleter failed, deleting memory normally
          MemMatrix::Matrix().Deallocate(_LiteralStr);
          _LiteralStr = NULL;
        }

        _LiteralStr = strcpy(AllocateNewString(_MemDel, _LiteralStr, LitStr_.strlen() + 1, false, true), LitStr_.c_str());
      }
      else
      {
        if (!_LiteralStr)
          _LiteralStr = (char*)MemMatrix::Matrix().Allocate(LitStr_.strlen() + 5);

        if (LitStr_.strlen())
          strcpy(_LiteralStr, LitStr_.c_str());
        else
          _LiteralStr[0] = 0;
      }

      SetHasAnswer(::SafeStrLen(_LiteralStr));
    }
  }
}

/*****************************************************************************/
template <class T>
void LineCalculator<T>::AppendLiteralStr(const char* Literal_)
{
  if (Literal_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->AppendLiteralStr(Literal_);
    else
    {
      size_t slen = ::SafeStrLen(_LiteralStr);
      ChrString LitStr_ = Literal_;

      if (_LiteralStr && slen && Literal_ && LitStr_.strlen())
      {
        MemMatrix::Matrix().Reallocate(_LiteralStr, slen + LitStr_.strlen() + 5);
        _LiteralStr[slen] = 0;
        strcat(_LiteralStr, LitStr_.c_str());
      }
      else
      {
        _LiteralStr = (char*)MemMatrix::Matrix().Allocate(LitStr_.strlen() + 5);

        if (LitStr_.strlen())
          strcpy(_LiteralStr, LitStr_.c_str());
        else
          _LiteralStr[0] = 0;
      }

      SetHasAnswer(::SafeStrLen(_LiteralStr));
    }
  }
}

/*****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::LiteralChrStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->LiteralChrStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetLiteralStr = _LiteralStr;
    return _RetLiteralStr;
  #else
    ChrString Dummy_ = _LiteralStr;
    return Dummy_;
  #endif
}
#endif
/*****************************************************************************/
template <class T>
const char* LineCalculator<T>::LiteralStr(ChrString* ret) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->LiteralStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetLiteralStr = _LiteralStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetLiteralStr;
    return (ret ? ret->c_str():_RetLiteralStr.c_str());
  #else
    return _LiteralStr;
  #endif
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetProgramStr(const char* TStr_)
{
  if (TStr_)
  {
    if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
      _ParentPtr->SetProgramStr(TStr_);
    else
    {
      ChrString Str_ = TStr_;
      if (_ProgramStr && Str_.strlen() > ::SafeStrLen(_ProgramStr))
      {
        _ProgramStr = _MemDel->DelayedDeleteCstr(_ProgramStr, STOREMEM);

        if (_ProgramStr)
        {
          // delayed memory deleter failed, deleting memory normally
          MemMatrix::Matrix().Deallocate(_ProgramStr);
          _ProgramStr = NULL;
        }

        _ProgramStr = strcpy(AllocateNewString(_MemDel, _ProgramStr, Str_.strlen() + 1, false, true), Str_.c_str());
      }
      else
      {
        if (!_ProgramStr)
          _ProgramStr = (char*)MemMatrix::Matrix().Allocate(Str_.strlen() + 5);

        if (Str_.strlen())
          strcpy(_ProgramStr, Str_.c_str());
        else
          _ProgramStr[0] = 0;
      }
    }
  }
}

/****************************************************************************/
#if DECLARE_MUTABLE_TEMPORARY_MEMBERS
template <class T>
ChrString& LineCalculator<T>::ProgramChrStr() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProgramChrStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetProgramStr = _ProgramStr;
    return _RetProgramStr;
  #else
    ChrString Dummy_ = _ProgramStr;
    return Dummy_;
  #endif
}
#endif
/****************************************************************************/
template <class T>
const char* LineCalculator<T>::ProgramStr(ChrString* ret) const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->ProgramStr();

  #if DECLARE_MUTABLE_TEMPORARY_MEMBERS
    _RetProgramStr = _ProgramStr;
  #endif

  #if USE_MUTABLE_TEMPORARY_MEMBERS
    if (ret)
      *ret = _RetProgramStr;
    return (ret ? ret->c_str():_RetProgramStr.c_str());
  #else
    return _ProgramStr;
  #endif
}

/****************************************************************************/
template <class T>
const char* LineCalculator<T>::GetPrecision()
{
  return
  (
    (_CalcIndex == CalculatorBase::FLOAT)      ? FLOAT_PRECISION_MSGSTR:
    (_CalcIndex == CalculatorBase::DOUBLE)     ? DOUBLE_PRECISION_MSGSTR:
    (_CalcIndex == CalculatorBase::LONGDOUBLE) ? LONGDOUBLE_PRECISION_MSGSTR:
    (_CalcIndex == CalculatorBase::LONGNUM)    ? LONGNUM_PRECISION_MSGSTR:
                                                 ERRMSG_INVALID_PRECISION
  );
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetParentDestroyed(bool flag_)
{
  _ParentDestroyed = flag_;
}

/****************************************************************************/
template <class T>
bool LineCalculator<T>::ParentDestroyed() const
{
  return _ParentDestroyed;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetParent(CalculatorBase* Ptr_)
{
  _ParentPtr = Ptr_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetChild(CalculatorBase* Ptr_)
{
  if (!_ParentPtr || _ParentPtr == this && Ptr_ != this)
    _ChildPtr = Ptr_;
}

/****************************************************************************/
template <class T>
const CalculatorBase* LineCalculator<T>::Parent() const
{
  return _ConstParentPtr;
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::Parent()
{
  return _ParentPtr;
}

/****************************************************************************/
template <class T>
const CalculatorBase* LineCalculator<T>::Child() const
{
  return _ConstChildPtr;
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::Child()
{
  return _ChildPtr;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ProcessExpr(Mcalc_Operand** operands, char** arglist, int optype, CalculatorBase* CalcPtr_)
{
  int Confirmed_ = (_ExprStackIndex == 1 ||
                    InRunningProgram(true, true, false, false)) && !_ActiveExpression;
  CalculatorBase* PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = PrevCalc_;

  if (Confirmed_ && AnswerMode() != LITERAL_MODE &&
                    AnswerMode() != FRACTION_MODE)
    CalcPtr_->ResetAnswerMode();
  else
    Confirmed_ = false;

  CalcPtr_->SetAnswerMode(FLOATINGPOINT_MODE, Confirmed_);

  if (CalcPtr_ && CalcPtr_->GetCalcIndex() == CalculatorBase::FLOAT)
    ((FloatCalculator*)CalcPtr_)->DirectProcess(operands, arglist, optype);
  else if (CalcPtr_ && CalcPtr_->GetCalcIndex() == CalculatorBase::DOUBLE)
    ((DoubleCalculator*)CalcPtr_)->DirectProcess(operands, arglist, optype);
  else if (CalcPtr_ && CalcPtr_->GetCalcIndex() == CalculatorBase::LONGDOUBLE)
    ((LongDoubleCalculator*)CalcPtr_)->DirectProcess(operands, arglist, optype);
  else if (CalcPtr_ && CalcPtr_->GetCalcIndex() == CalculatorBase::LONGNUM)
    ((LongNumCalculator*)CalcPtr_)->DirectProcess(operands, arglist, optype);

  if (StringComparison() && IsStringComparisonOpType(optype))
    SetStringComparison(FALSE);
}

/****************************************************************************/
template <class T>
CalculatorBase* LineCalculator<T>::SetupCalculators(int CalcType_)
{
  #if CALCLIB_DEBUG2
    fputs("Entering: SetupCalculators\n", logfile);
  #endif

  if (!_ParentPtr)
    return this;

  _ParentPtr = NULL;
  _StrVarData = new StrVarData();
  _AssignmentOrder = (char*)MemMatrix::Matrix().Allocate(_StackSize + 1);
  _AssignmentOrder[0] = 0;
  ResetIndexes();

  if (CalcType_ == CalculatorBase::FLOAT)
  {
    _CalcPtrArray[CalculatorBase::FLOAT] = this;
    CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::FLOAT);
  }
  else
  {
    _CalcPtrArray[CalculatorBase::FLOAT] = new FloatCalculator(_CmdArgc, _CmdArgv);

    if (_CalcPtrArray[CalculatorBase::FLOAT])
    {
      _CalcPtrArray[CalculatorBase::FLOAT]->SetParent(this);
      _CalcPtrArray[CalculatorBase::FLOAT]->ResetIndexes();
      CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::FLOAT);
    }
  }

  if (CalcType_ == CalculatorBase::DOUBLE)
  {
    _CalcPtrArray[CalculatorBase::DOUBLE] = this;
    CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::DOUBLE);
  }
  else
  {
    _CalcPtrArray[CalculatorBase::DOUBLE] = new DoubleCalculator(_CmdArgc, _CmdArgv);

    if (_CalcPtrArray[CalculatorBase::DOUBLE])
    {
      _CalcPtrArray[CalculatorBase::DOUBLE]->SetParent(this);
      _CalcPtrArray[CalculatorBase::DOUBLE]->ResetIndexes();
      CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::DOUBLE);
    }
  }

  if (CalcType_ == CalculatorBase::LONGDOUBLE)
  {
    _CalcPtrArray[CalculatorBase::LONGDOUBLE] = this;
    CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::LONGDOUBLE);
  }
  else
  {
    _CalcPtrArray[CalculatorBase::LONGDOUBLE] = new LongDoubleCalculator(_CmdArgc, _CmdArgv);

    if (_CalcPtrArray[CalculatorBase::LONGDOUBLE])
    {
      _CalcPtrArray[CalculatorBase::LONGDOUBLE]->SetParent(this);
      _CalcPtrArray[CalculatorBase::LONGDOUBLE]->ResetIndexes();
      CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::LONGDOUBLE);
    }
  }

  if (CalcType_ == CalculatorBase::LONGNUM)
  {
    _CalcPtrArray[CalculatorBase::LONGNUM] = this;
    CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::LONGNUM);
  }
  else
  {
    _CalcPtrArray[CalculatorBase::LONGNUM] = new LongNumCalculator(_CmdArgc, _CmdArgv);

    if (_CalcPtrArray[CalculatorBase::LONGNUM])
    {
      _CalcPtrArray[CalculatorBase::LONGNUM]->SetParent(this);
      _CalcPtrArray[CalculatorBase::LONGNUM]->ResetIndexes();
      CalculatorBase::SetCalculatorCreated(Mcalc_ClassID::LONGNUM);
    }
  }

  // format of command history list:
  //   [1byte  : command validity=1st byte]
  //   [2byte  : string length=2nd byte]
  //   [                      =3rd byte]
  //   [nbytes : command string startpt=4th byte]
  //
  //   [Validity (1 byte)][String Length (2 bytes)][Command String]
  //
  if (!Parent())
  {
    CreateDataStacks();
    CreateNewSubExpr();
    TransferToAllChildCalcs();

    AllocateHistoryList(MAXHISTORY);
    SetSavedXpos(CONIO_XPOS_DEFAULT);
    SetHistoryListIndex(-1);
    SetHistoryListLength(0);
    SetHistoryListMode(FALSE);
    SetHistoryListEnded(FALSE);
  }

  _CalcIndex = (CalcType_ == CalculatorBase::FLOAT)      ? CalculatorBase::FLOAT:
               (CalcType_ == CalculatorBase::DOUBLE)     ? CalculatorBase::DOUBLE:
               (CalcType_ == CalculatorBase::LONGDOUBLE) ? CalculatorBase::LONGDOUBLE:
                                                           CalculatorBase::LONGNUM;
  #if CALCLIB_DEBUG2
    fputs("Leaving: SetupCalculators\n", logfile);
  #endif

  return this;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::GetIndex(int& Pos_, int& Val_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->GetIndex(Pos_, Val_);
  else
  {
    char* Ptr_ = _AssignmentOrder;

    if (::SafeStrLen(Ptr_))
    {
      Pos_ = *Ptr_ - '0';
      Ptr_++;

      if (::SafeStrLen(Ptr_))
        Val_ = *Ptr_ - '0';
      else
        Val_ = 0;
    }
    else
      Pos_ = Val_ = 0;
  }
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::HasIndex()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->HasIndex();

  return ::SafeStrLen(_AssignmentOrder);
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::PopIndex()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->PopIndex();
  else
  {
    int len = ::SafeStrLen(_AssignmentOrder);
    if (len && len - 2 && _AssignmentOrder && (&_AssignmentOrder[2]))
      _AssignmentOrder = (char*)memmove(_AssignmentOrder, &_AssignmentOrder[2], len - 1);
    else
      _AssignmentOrder[0] = 0;
  }
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SetIndex(int Pos_, int Val_)
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->SetIndex(Pos_, Val_);
  else
  {
    char Buffer_[3];
    int len = ::SafeStrLen(_AssignmentOrder);
    int Mode_ = AnswerMode();

    if (!IsStringVar(Pos_) && Val_ == STRING_CONCAT)
      Val_ = STRING_ASSIGN;

    if (!IsSetVar(Pos_) && Val_ == SET_ASSIGN)
      Val_ = SET_ASSIGN;

    if (len >= _StackSize)
    {
      char* Temp_ = _AssignmentOrder;
      _StackSize += STACKSIZE;
      _AssignmentOrder = (char*)MemMatrix::Matrix().Allocate(_StackSize + 1);
      ::SafeStrCpy(_AssignmentOrder, Temp_);
      len = ::SafeStrLen(_AssignmentOrder);
      MemMatrix::Matrix().Deallocate(Temp_);
      Temp_ = NULL;
    }

    Buffer_[0] = Pos_ + '0';
    Buffer_[1] = Val_ + '0';
    Buffer_[2] = 0;
    ::SafeStrCpy(&_AssignmentOrder[len], Buffer_);

    SetSetVar(Pos_, Val_ == SET_ASSIGN || Val_ == SET_UNION ||
                    Val_ == SET_INTERSECTION || Val_ == SET_NEGATION ||
                    Val_ == SET_EXCLUSION);
    SetStringVar(Pos_, (Val_ == STRING_ASSIGN || Val_ == STRING_CONCAT ||
                       (Mode_ == ALTBASE_MODE && (Val_ == ASSIGN_AND || Val_ == ASSIGN_OR))));
  }
}

/****************************************************************************/
template <class T>
size_t LineCalculator<T>::LongestCmdEntry() const
{
  size_t len = 0;
  Ushort sz = 0;
  int x;
  int max = CommandHistoryLength();

  for (x = 0; x < max; x++)
    if (HistoryListElementValid(x) == CMDENTRY_VALID && HistoryListElementSize(x))
    {
      sz = HistoryListElementSize(x);
      if (len < size_t(sz))
        len = size_t(sz);
    }

  return len;
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::MakeCmdHistoryPrompt(size_t sz)
{
  if (sz)
  {
    if (CommandHistoryPrompt())
      DeallocateHistoryListPrompt();

    AllocateHistoryListPrompt(50UL+sz);
  }

  return CommandHistoryPrompt();
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::WriteCommandHistoryEntry(FILE* Fptr_, int index_)
{
  if (CommandHistoryLength() && !InProgramMode(true))
  {
    // format of command history list:
    //   [1byte  : command validity=1st byte]
    //   [2byte  : string length=2nd byte]
    //   [                      =3rd byte]
    //   [nbytes : command string startpt=4th byte]
    //
    //   [Validity (1 byte)][String Length (2 bytes)][Command String]
    //
    int Valid_ = HistoryListElementValid(index_);
    int Length_ = HistoryListElementSize(index_);
    const char* CmdStr_ = HistoryListElementStr(index_);

    fprintf(Fptr_, "CmdHist[%d][VALID] = %d\n", index_, Valid_);
    fprintf(Fptr_, "CmdHist[%d][LENGTH] = %d\n", index_, Length_);

    if (Valid_ == CMDENTRY_VALID && Length_ && ::SafeStrLen(CmdStr_))
      fprintf(Fptr_, "CmdHist[%d] = %s\n", index_, CmdStr_);
    else
      fprintf(Fptr_, "CmdHist[%d] = NULL\n", index_, CmdStr_);
  }
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::ShowCmdHistoryEntry(Boolean RepeatEntry_)
{
  if (InProgramMode(true))
    return 0;

  int hlindex_ = CommandHistoryIndex();
  int hllength_ = CommandHistoryLength();
  int InEntries_ = 0;
  int RevOrderNum_ = 0;
  size_t sz = 0;
  #if CALCLIB_DEBUG7
    bool Debug_ = true;
  #else
    bool Debug_ = false;
  #endif

  if (hlindex_ >= 0)
  {
    if (!RepeatEntry_)
      DecHistoryListIndex();

    InEntries_ = CommandHistoryIndex() >= 0;
  }
  else
  {
    IncHistoryListIndex(hllength_);
    sz = LongestCmdEntry();

    if ((Debug_ || InAsyncMode()) &&
        sz && CommandHistoryIndex() >= 0)
    {
      SetHistoryListMode(TRUE);
      EndCommandHistoryList();
      return 1;
    }
  }

  hlindex_ = CommandHistoryIndex();
  hllength_ = CommandHistoryLength();

  if ((sz || InEntries_) && hlindex_ >= 0)
  {
    while (hlindex_ >= 0 &&
            (!HistoryListElementBase(hlindex_) ||
             HistoryListElementValid(hlindex_) != CMDENTRY_VALID))
    {
      DecHistoryListIndex();
      hlindex_ = CommandHistoryIndex();
    }

    if (hlindex_ >= 0 &&
        HistoryListElementBase(hlindex_) &&
        HistoryListElementValid(hlindex_) == CMDENTRY_VALID)
    {
      if (!InAsyncMode() && _ConsoleInput)
      {
        if (_SavedConIO == 0)
          _SavedConIO = -1;           // conio --> stdio
        _ConsoleInput = _ConsoleOutput = false;
      }

      if (!InEntries_)
        MakeCmdHistoryPrompt(sz);

      hlindex_ = CommandHistoryIndex();
      hllength_ = CommandHistoryLength();
      RevOrderNum_ = hllength_ - hlindex_;
      sprintf(CommandHistoryPrompt(), MSG_EXEC_COMMAND_HISTORY_ENTRY,
              HistoryListElementStr(hlindex_),
              RevOrderNum_, hllength_);

      SetHistoryListMode(TRUE);
      SendToSelectedOutput(CommandHistoryPrompt());
      return 1;
    }
    else if (hlindex_ < 0)
    {
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);
      return 0;
    }
  }
  else
  {
    SetHistoryListMode(FALSE);
    SetHistoryListIndex(-1);
    return 0;
  }

  return 0;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ResetIndexes()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    _ParentPtr->ResetIndexes();
  else
    _AssignmentOrder[0] = 0;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::NumberBase() const
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
    return _ParentPtr->NumberBase();

  return _NumberBase;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::RestoreNumberBase()
{
  if (!ParentDestroyed() && _ParentPtr && _ParentPtr != ((CalculatorBase*)this))
  {
    _NumberBase = 10;
    _ParentPtr->RestoreNumberBase();
  }
  else
  {
    if (!HasErrors())
      if (AnswerMode() == FLOATINGPOINT_MODE && GetCalcIndex() == CalculatorBase::LONGNUM)
      {
        int Confirmed_ = (_ExprStackIndex == 1 ||
                          InRunningProgram(true, true, false, false)) && !_ActiveExpression;

        if (_NumberBase == 16 && _CalcPtrArray[_CalcIndex])
        {
          LongNumber Result_ = ((LongNumCalculator*)(_CalcPtrArray[_CalcIndex]))->GetResult();
          ChrString ResStr_ = Result_.ToString(16);
          if (Confirmed_)
            ResetAnswerMode();
          SetAnswerMode(ALTBASE_MODE, Confirmed_);
          SetLiteralStr(ResStr_.c_str());
        }
        else if (_NumberBase == 8 && _CalcPtrArray[_CalcIndex])
        {
          LongNumber Result_ = ((LongNumCalculator*)(_CalcPtrArray[_CalcIndex]))->GetResult();
          ChrString ResStr_ = Result_.ToString(8);
          if (Confirmed_)
            ResetAnswerMode();
          SetAnswerMode(ALTBASE_MODE, Confirmed_);
          SetLiteralStr(ResStr_.c_str());
        }
      }

    _NumberBase = 10;
  }
}

/****************************************************************************/
template <class T>
char* LineCalculator<T>::GetFromSelectedInput(char* buffer_, int bufsz_)
{
  if (UsesConsoleInput())
  {
    #if USE_STDIO_ONLY
      buffer_ = UseDefaultInputFnc(buffer_, bufsz_);
    #else
      buffer_ = UseConsoleInputFnc(buffer_, bufsz_);
    #endif
  }
  else
    buffer_ = UseDefaultInputFnc(buffer_, bufsz_);

  return buffer_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::SendToSelectedOutput(char* buffer_)
{
  if (UsesConsoleOutput())
  {
    #if USE_STDIO_ONLY
      UseDefaultOutputFnc(buffer_);
    #else
      UseConsoleOutputFnc(buffer_);
    #endif
  }
  else
    UseDefaultOutputFnc(buffer_);
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::ProcessCmdLine(int argc, char** argv)
{
  #if CALCLIB_DEBUG2
    fputs("Entering: ProcessCmdLine\n", logfile);
  #endif

  Subscript Pos_;
  ChrString TempStr_;
  Integer SesNum_;
  CalculatorBase* CalcPtr_ = this;
  CalculatorBase* PrevCalc_;
  char** argline = NULL;
  char* buffer = NULL;
  char* RetStr_ = NULL;
  const char* ModeStr_;
  const char* CalcStr_;
  int Index_;
  int UsesSesNum_ = argc == 3 && icasestrcomp(argv[1], "-x") && IsUint(argv[2]);
  int NoPrompt_ = argc == 2 && icasestrcomp(argv[1], "-np");

  int ConInput_ = argc == 2 && icasestrcomp(argv[1], "-consoleio");
  int ConOutput_ = ConInput_;
  int StdInput_ = argc == 1 && !ConInput_;
  int StdOutput_ = StdInput_;

#if CALCLIB_TESTASYNCMODE2c
  bool ExecFileInput_ = true;
  if (!ExecFileInput_)
#else
  if (argc == 1 || UsesSesNum_ || NoPrompt_ || ConInput_ || StdInput_)
#endif
  {
    SetUsesSessionNum(UsesSesNum_);

    int HasInputFile_ = 0;
    int HasOutputFile_ = 0;
    int ParamCnt_ = 0;
    int SessionNum_ = 0;

    if (UsesSesNum_)
    {
      argline = (char**)CalculatorBase::allocmem(2, sizeof(char*), argline);
      argline[ParamCnt_++] = NULL;
      argline[ParamCnt_++] = ::NewString("-x");

      SessionNum_ = atoi(argv[2]);
      SetSessionNum(SessionNum_);
      SesNum_ = SessionNum();

      CreateDefaultFileNames(SesNum_);

      if (_CmdLineOptions && !ExecInputFileData())
      {
        if (_CmdLineOptions->argvector)
          _CmdLineOptions->argvector =
              DestroyArgVector(_CmdLineOptions->argcount,
                               _CmdLineOptions->argvector);

        FindCmdLineOptions(ParamCnt_, argline, _CmdLineOptions);
        _CmdLineOptions->argvector = CloneArgVector(ParamCnt_, argline);
      }

      ProcessCmdLine(ParamCnt_, argline);
      _MemDel->DelayedDeleteCstr(argline[1], STOREMEM);
      _MemDel->DelayedDeleteVoidp((void*)argline, STOREMEM);
      argline = NULL;
      RemoveSessionFiles(SessionNum_);

      #if CALCLIB_DEBUG2
        fputs("Leaving: ProcessCmdLine\n", logfile);
      #endif
      return 0;
    }
    else
    {
      CURRENTGRAPH_FILE = ::NewString(MCALC_CURRENTGRAPH_FILE);
      GRAPH_OPERATION_FILE = ::NewString(MCALC_GRAPH_OPERATION_FILE);
      GRAPH_PROGRESS_FILE = ::NewString(MCALC_GRAPH_PROGRESS_FILE);

      buffer = (char*)CalculatorBase::allocmem(INPUT_BUFFER_SIZE, sizeof(char), buffer);
      FILE* Fptr_ = FileOpen(MCALC_CONFIG_FILE, "r");

      if (Fptr_)
      {
        RetStr_ = fgets(buffer, INPUT_BUFFER_SIZE, Fptr_);
        HasInputFile_ = atoi(RetStr_);
        RetStr_ = fgets(buffer, INPUT_BUFFER_SIZE, Fptr_);
        HasOutputFile_ = atoi(RetStr_);

        argline = (char**)CalculatorBase::allocmem(5, sizeof(char*), argline);
        argline[ParamCnt_++] = NULL;

        if (HasInputFile_)
        {
          argline[ParamCnt_++] = ::NewString(INPUTFILE_SWITCH);
          RetStr_ = fgets(buffer, INPUT_BUFFER_SIZE, Fptr_);
          RetStr_ = RemovePadding(RetStr_, " \t\n\r");
          DATA_INPUT_FILE = ::NewString(RetStr_);
          argline[ParamCnt_++] = DATA_INPUT_FILE;
        }

        if (HasOutputFile_)
        {
          argline[ParamCnt_++] = ::NewString(OUTPUTFILE_SWITCH);
          RetStr_ = fgets(buffer, INPUT_BUFFER_SIZE, Fptr_);
          RetStr_ = RemovePadding(RetStr_, " \t\n\r");
          DATA_OUTPUT_FILE = ::NewString(RetStr_);
          argline[ParamCnt_++] = DATA_OUTPUT_FILE;
        }

        if (HasInputFile_ || HasOutputFile_)
        {
          if (_CmdLineOptions && !ExecInputFileData())
          {
            if (_CmdLineOptions->argvector)
              _CmdLineOptions->argvector =
                  DestroyArgVector(_CmdLineOptions->argcount,
                                   _CmdLineOptions->argvector);

            FindCmdLineOptions(ParamCnt_, argline, _CmdLineOptions);
            _CmdLineOptions->argvector = CloneArgVector(ParamCnt_, argline);
          }

          ProcessCmdLine(ParamCnt_, argline);
        }

        for (Index_ = 1; Index_ < ParamCnt_; Index_++)
          if (argline[Index_] != DATA_OUTPUT_FILE &&
              argline[Index_] != DATA_INPUT_FILE)
            _MemDel->DelayedDeleteCstr(argline[Index_], STOREMEM);

        _MemDel->DelayedDeleteVoidp((void*)argline, STOREMEM);
        argline = NULL;
        fclose(Fptr_);

        if (HasInputFile_ || HasOutputFile_)
        {
          _MemDel->DelayedDeleteCstr(buffer, STOREMEM);
          buffer = NULL;

          #if CALCLIB_DEBUG2
            fputs("Leaving: ProcessCmdLine\n", logfile);
          #endif
          return 0;
        }
      }
      else
      {
        DATA_INPUT_FILE = NULL;
        DATA_OUTPUT_FILE = NULL;
      }
    }

    _StartAsStdInput = _StdInput = TRUE;
    _StartAsStdOutput = _StdOutput = TRUE;

    _ConsoleInput = !StdInput_ && ConInput_;
    _ConsoleOutput = !StdOutput_ && ConOutput_;

    // Remove old progress file from previous program run
    if (CalculatorBase::FileExists(MCALC_PROGRESS_FILE))
      unlink(MCALC_PROGRESS_FILE);

    // Remove elapsed time file from previous program run
    if (CalculatorBase::FileExists(MCALC_ELAPSEDTIME_FILE))
      unlink(MCALC_ELAPSEDTIME_FILE);

    #if CALCLIB_TESTASYNCMODE
      SetUsesSessionNum(true);
      SetSessionNum(1);
      SesNum_ = SessionNum();
      CreateDefaultFileNames(SesNum_);
    #endif

    do
    {
      PrevCalc_ = CalcPtr_;
      CalcPtr_ = CalcPtr_->GetCalcType();
      if (!CalcPtr_) CalcPtr_ = PrevCalc_;
      ModeStr_ = (CalcPtr_->GetAngleUnit() == RADIAN) ? RADIAN_MODE_PROMPT:
                                                        DEGREE_MODE_PROMPT;
      Index_ = CalcPtr_->GetCalcIndex();
      CalcStr_ = (Index_ == CalculatorBase::FLOAT)      ? FLOAT_PREC_PROMPT:
                 (Index_ == CalculatorBase::DOUBLE)     ? DOUBLE_PREC_PROMPT:
                 (Index_ == CalculatorBase::LONGDOUBLE) ? LONGDOUBLE_PREC_PROMPT:
                 (Index_ == CalculatorBase::LONGNUM)    ? LONGNUMBER_PREC_PROMPT:
                                                          PREC_ERROR_PROMPT;

      if (!NoPrompt_ && !CommandHistoryMode())
      {
        if (UsesConsoleOutput() || _SavedConIO)
        {
          #if (!(USE_STDIO_ONLY))
            CLRSCR();
          #endif

          sprintf(buffer, "MCALC:%s:%s>> ", CalcStr_, ModeStr_);
          #if USE_STDIO_ONLY
            if (CommandHistoryEntry())
            {
              ::SafeStrCat(buffer, CommandHistoryEntry());
              strcat(buffer, "\n");
            }
          #endif

          _SkipPause = true;
          #if USE_STDIO_ONLY
            UseDefaultOutputFnc(buffer);
          #else
            UseConsoleOutputFnc(buffer);
          #endif
        }
        else
        {
          #if (!(USE_STDIO_ONLY))
            if (UsesConsoleInput())
              CLRSCR();
          #endif

          sprintf(buffer, "MCALC:%s:%s>> ", CalcStr_, ModeStr_);
          #if USE_STDIO_ONLY
            if (CommandHistoryEntry())
            {
              ::SafeStrCat(buffer, CommandHistoryEntry());
              strcat(buffer, "\n");
            }
          #endif

          UseDefaultOutputFnc(buffer);
        }
      }
      else if (CommandHistoryListEnded())
      {
        #if (!(USE_STDIO_ONLY))
          if (UsesConsoleInput())
            CLRSCR();
        #endif

        strcpy(buffer, "MCALC:cmddebug>> ");
        UseDefaultOutputFnc(buffer);
      }

      if (UsesConsoleInput())
      {
        #if USE_STDIO_ONLY
          if (CommandHistoryEntry())
            ::SafeStrCpy(buffer, CommandHistoryEntry());
          else
            buffer = UseDefaultInputFnc(buffer, INPUT_BUFFER_SIZE);
        #else
          buffer = UseConsoleInputFnc(buffer, INPUT_BUFFER_SIZE);
        #endif

        _SkipPause = false;
      }
      else
      {
        #if USE_STDIO_ONLY
          if (CommandHistoryEntry())
            ::SafeStrCpy(buffer, CommandHistoryEntry());
          else
            buffer = UseDefaultInputFnc(buffer, INPUT_BUFFER_SIZE);
        #else
          buffer = UseDefaultInputFnc(buffer, INPUT_BUFFER_SIZE);
        #endif
      }
    }
    while (buffer && CalcPtr_->EvalExpression(buffer, CalcPtr_));

    _MemDel->DelayedDeleteCstr(buffer, STOREMEM);
    buffer = NULL;
  }
  else
  {
    #if CALCLIB_TESTASYNCMODE
      SetUsesSessionNum(true);
      SetSessionNum(1);
      SesNum_ = SessionNum();
      CreateDefaultFileNames(SesNum_);
    #endif

    _StartAsStdInput = _StdInput = FALSE;
    _StartAsStdOutput = _StdOutput = FALSE;

    PrevCalc_ = CalcPtr_;
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;
    FileInput(argc, argv, CalcPtr_);
  }

  return 0;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::ExecInputDataFile(const char* Fname_, int LinePause_,
                                         const char* OutFname_)
{
  if (InputDataFileExecLock() != EXECFILE_UNLOCKED)
    return FALSE;

  #if CALCLIB_DEBUG11b
    DbgPtr()->EnterLevel("CalculatorBase::ExecInputDataFile");
  #endif

  CalculatorBase* CalcPtr_ = this;
  CalculatorBase* PrevCalc_;
  CalcProgram* Program_ = NULL;

  bool BatchLevelChanged_ = false;
  bool ProgramRan_ = false;
  bool InAsync_ = InAsyncMode();
  bool ClearOut_ = true;
  bool NoPause_ = false;
  bool SavedNoPause_ = false;
  bool GraphPausable_ = false;
  bool PrgAlloc_ = false;
  bool ProgInsDone_ = false;
  bool ValidInputMode_ = InAsync_ || StartAsStdInput();
  int HasInputFile_ = ::SafeStrLen(Fname_) && FileExists(Fname_);
  int ParamCnt_ = 0;
  long ProgID_ = 0;
  char msgbuf[256];
  char** argline = NULL;
  ExecutingProgramName* OldNode_;

  if (HasInputFile_ && ValidInputMode_)
  {
    argline = (char**)CalculatorBase::allocmem(10, sizeof(char*), argline);
    if (!argline)
      return FALSE;

    _NumGraphFunctions = 0;
    ::memset(argline, 0, 5 * sizeof(char*));

    if (InAsync_)
    {
      GraphPausable_ = VerifyAllGraphCmds(Fname_, _NumGraphFunctions);
      SetInAllGraphsFile(GraphPausable_);

      argline[ParamCnt_++] = NULL;

      argline[ParamCnt_++] = ::NewString(INPUTFILE_SWITCH);
      DATA_INPUT_FILE = ::NewString(Fname_);
      argline[ParamCnt_++] = DATA_INPUT_FILE;
      argline[ParamCnt_] = NULL;

      if (OutFname_ && !LinePause_ && !GraphPausable_)
      {
        argline[ParamCnt_++] = ::NewString(OUTPUTFILE_SWITCH);
        DATA_OUTPUT_FILE = ::NewString(OutFname_);
        argline[ParamCnt_++] = DATA_OUTPUT_FILE;
        argline[ParamCnt_] = NULL;
      }
      else
        argline[ParamCnt_] = NULL;

      NoPause_ =
      SavedNoPause_ = !LinePause_ &&
                      ((OutFname_ && DATA_OUTPUT_FILE) || GraphPausable_);

      if (!GraphPausable_ &&
          InputDataFileExecLock() != EXECFILE_LOCKED)
        CalcPtr_->Exec_ResetQuitGraphFlags(true);

      if (GraphPausable_)
      {
        NoPause_ = FALSE;
        LinePause_ = TRUE;

        SetBatchFileEndedSignalSent(false);
        SetBatchFileEndedSignalAcked(false);
        SetBatchFileEndedSignalPending(false);
        SetClientAckedDoneToGraphOutput(false);
        SetResponseWasCompleted(false);
      }

      if (NoPause_)
      {
        argline[0] = ::NewString("mcalc");
        argline[ParamCnt_++] = ::NewString(SESSIONNUM_SWITCH);
        argline[ParamCnt_++] = ::NewString(FILE_SESNUM_SUFFIX);
        argline[ParamCnt_] = NULL;
      }
      else
        argline[ParamCnt_] = NULL;
    }
    else if (StartAsStdInput())
    {
      GraphPausable_ = VerifyAllGraphCmds(Fname_, _NumGraphFunctions);
      SetInAllGraphsFile(GraphPausable_);

      DATA_INPUT_FILE = ::NewString(Fname_);
      argline[ParamCnt_++] = DATA_INPUT_FILE;
      argline[ParamCnt_] = NULL;

      NoPause_ =
      SavedNoPause_ = FALSE;

      if (!GraphPausable_ &&
          InputDataFileExecLock() != EXECFILE_LOCKED)
        CalcPtr_->Exec_ResetQuitGraphFlags(true);

      if (GraphPausable_)
      {
        NoPause_ = FALSE;
        LinePause_ = TRUE;

        SetBatchFileEndedSignalSent(false);
        SetBatchFileEndedSignalAcked(false);
        SetBatchFileEndedSignalPending(false);
        SetClientAckedDoneToGraphOutput(false);
        SetResponseWasCompleted(false);
      }
    }

    PrevCalc_ = CalcPtr_;
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;

    #if CALCLIB_DEBUG11b
      DbgPtr()->ShowInt(InAsync_, "InAsync_");
      DbgPtr()->ShowInt(NoPause_, "NoPause_");
      DbgPtr()->ShowInt(LinePause_, "LinePause_");
      DbgPtr()->ShowInt(GraphPausable_, "GraphPausable_");
      DbgPtr()->ShowInt(Program_!=NULL, "Program_!=NULL");
      DbgPtr()->ShowInt(CalcPtr_!=NULL, "CalcPtr_!=NULL");
    #endif

    if (InAsync_)
    {
      Program_ = NoPause_ ? NULL:CreateNewProgram(NULL);

      if (((NoPause_ && !GraphPausable_) || Program_) && CalcPtr_)
      {
        if (!NoPause_ && Program_)
        {
          ProgInsDone_ = PushActiveProgram(Program_);
          ProgID_ = GiveProgramID();

          if (ProgID_ && ProgInsDone_)
          {
            ClearOut_ = Program_->ShouldClearOutputFiles();
            SetUserPrompterProgram(Program_);
          }
        }
        else if ((NoPause_ && !GraphPausable_) && !_McalcSpawned)
        {
          sprintf(msgbuf, MSG_PROCESSING_INPUT_FILE, DATA_INPUT_FILE);
          strcat(msgbuf, " ");
          strcat(msgbuf, MSG_PROCESSING_IN_PROGRESS);
          SetSessionOptionOverride(true);
          TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
          DisplayMessage(GetGuiOutputFile(), msgbuf);
          CloseGuiOutputFile(true, true);

          SetSessionOptionOverride(true);
          SendOutputReadySignal(0);
          SetHasAnswer(FALSE);
        }

        if (!_ExecuteProgram || !_ExecuteProgram->IsMatchingPrgExec())
        {
          if (!_ExecuteProgram)
            _ExecuteProgram = new ExecutingProgramName(Fname_);
          else if (!_ExecuteProgram->Name() ||
                   !_ExecuteProgram->MatchName(Fname_))
            _ExecuteProgram->SetNewProgramName(Fname_);

          _ExecuteProgram->SetPrgExecuted(_ExecuteProgram->Name());
          PrgAlloc_ = true;
        }

        if (NoPause_ && !GraphPausable_)
        {
          SetNoPauseFileInput(TRUE);
          SetHasAnswer(FALSE);

          if (!_McalcSpawned)
          {
            _BatchExecLevel++;
            BatchLevelChanged_ = false;
            _InSpawnedCalc = true;

            #if PROCESS_INPUTFILES_INTERNALLY
              _McalcSpawned = TRUE;
              ProgramRan_ = FileInput(ParamCnt_, argline, CalcPtr_);
              SetHasAnswer(FALSE);
            #elif CALCLIB_TESTASYNCMODE2
              ProcessCmdLine(ParamCnt_, argline);
            #else
              _ExecMcalcOk = SpawnExternalMcalc(ParamCnt_, argline) == 0;
              SetHasAnswer(FALSE);
            #endif
          }
        }
        else if (Program_ && ProgID_ && ProgInsDone_)
        {
          Program_ = FindProgramFromID(ProgID_, true);

          if (Program_)
          {
            Exec_ResetQuitGraphFlags();
            SetGraphFilePause(GraphPausable_ && !SavedNoPause_);

            SetInputDataFileExecLock(EXECFILE_KEY_SET);
            SetInputDataFilePauseOption(LinePause_);
            SetNoPauseFileInput(FALSE);
            SetPostExecResetProcessDone(FALSE);

            _BatchExecLevel++;
            BatchLevelChanged_ = false;
            _InSpawnedCalc = false;

            ClearOut_ = Program_->ShouldClearOutputFiles();
            ProgramRan_ = FileInput(ParamCnt_, argline, CalcPtr_);
          }
        }

        if ((Program_ && ProgID_ && ProgInsDone_) ||
            (NoPause_ && !GraphPausable_))
        {
          // _BatchExecLevel data member decremented here
          // before call to EndOfBatchFileProcessing method
          // so Mcalc_IoState data file is written with the
          // most recent _BatchExecLevel value
          //
          if (PrgAlloc_ && _ExecuteProgram)
          {
            _ExecuteProgram = _ExecuteProgram->PopLevel(OldNode_);

            if (OldNode_)
              delete OldNode_;
            else
            {
              delete _ExecuteProgram;
              _ExecuteProgram = NULL;
              ResetProgramID(true);
            }
          }

          if (!NoPause_ || GraphFilePause() || QuitGraph())
          {
            _BatchExecLevel--;
            BatchLevelChanged_ = true;
            _InSpawnedCalc = false;

            if (_BatchExecLevel &&
                !_ExecuteProgram && !ActiveProgram(NULL, 0))
              _BatchExecLevel = 0;
          }
          else if (NoPause_ && !GraphPausable_)
          {
            if (_InSpawnedCalc && _BatchExecLevel > 0 && !_ResendLastSignal)
            {
              _BatchExecLevel--;
              BatchLevelChanged_ = true;
              _InSpawnedCalc = false;

              if (_BatchExecLevel &&
                  !_ExecuteProgram && !ActiveProgram(NULL, 0))
                _BatchExecLevel = 0;
            }
          }

          if (_IoState != Mcalc_IOState::BATCHFILE_ENDED_ACK)
            EndOfBatchFileProcessing();
          else if (BatchLevelChanged_)
          {
            BatchLevelChanged_ = false;
            Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, false);
          }

          if (!NoPause_ || GraphFilePause() || QuitGraph())
          {
            if (Program_ && ProgramRan_ && ProgID_ && ProgInsDone_)
            {
              Program_ = FindProgramFromID(ProgID_, true);
              if (Program_)
                ClearOut_ = Program_->ShouldClearOutputFiles();

              if (ExecProgramPopped(ProgID_))
                ResetExecProgramPopped(ProgID_);
              else
              {
                PopActiveProgram(true);
                ResetExecProgramPopped(ProgID_);
              }
            }

            SetUserPrompterProgram(NULL);
            SetAckPostExecInputFileData(1);
          }
          else if (NoPause_ && !GraphPausable_)
          {
            ClearOut_ = FALSE;
            SetNoPauseFileInput(FALSE);
          }
        }

        if (ClearOut_)
        {
          ClearGuiOutputFile();
          ClearUserPromptFile();

          GetOutputFile();
          GetGuiOutputFile();
        }
      }
    }
    else if (StartAsStdInput())
    {
      Exec_ResetQuitGraphFlags();
      SetGraphFilePause(FALSE);

      SetInputDataFileExecLock(EXECFILE_KEY_SET);
      SetInputDataFilePauseOption(LinePause_);
      SetNoPauseFileInput(FALSE);
      SetWasInBatchDataInput(TRUE);
      SetPostExecResetProcessDone(FALSE);

      _BatchExecLevel++;
      EvalExpression(argline[0], CalcPtr_);
      _BatchExecLevel--;
    }

    if (ValidInputMode_)
    {
      _MemDel->DelayedDeleteCstr(DATA_INPUT_FILE, STOREMEM);
      DATA_INPUT_FILE = NULL;
      if (!NoPause_)
        argline[0] = NULL;
    }

    if (InAsync_)
    {
      _MemDel->DelayedDeleteCstr(argline[1], STOREMEM);
      argline[1] = argline[2] = NULL;

      if (OutFname_ && !LinePause_ && !GraphPausable_ && DATA_OUTPUT_FILE)
      {
        _MemDel->DelayedDeleteCstr(DATA_OUTPUT_FILE, STOREMEM);
        DATA_OUTPUT_FILE = NULL;

        _MemDel->DelayedDeleteCstr(argline[3], STOREMEM);
        argline[3] = argline[4] = NULL;
      }

      if (NoPause_ && !GraphPausable_)
      {
        _MemDel->DelayedDeleteCstr(argline[0], STOREMEM);
        argline[0] = NULL;

        _MemDel->DelayedDeleteCstr(argline[5], STOREMEM);
        argline[5] = NULL;
        _MemDel->DelayedDeleteCstr(argline[6], STOREMEM);
        argline[6] = NULL;

        _McalcSpawned = FALSE;
        _ExecMcalcOk = FALSE;
      }
    }

    _MemDel->DelayedDeleteVoidp(argline, STOREMEM);
    argline = NULL;

    #if CALCLIB_DEBUG11b
      DbgPtr()->LeaveLevel();
    #endif
    return TRUE;
  }

  #if CALCLIB_DEBUG11b
    DbgPtr()->LeaveLevel();
  #endif
  return FALSE;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::FileInput(int argc, char** argv, CalculatorBase* CalcPtr_)
{
  // IF In asynchronous mode file input using session numbers THEN the argument variable values should be:
  //   argc == 2
  //   argv[0] == NULL
  //   argv[1] == "-x"
  //
  // IF In asynchronous mode file input and executing input file data THEN the argument variable values should be:
  //   argc == 3
  //   argv[0] == NULL
  //   argv[1] == "-i"
  //   argv[2] == <input file name>
  //
  // IF In asynchronous mode file input and reading/writing directly to data file(s) THEN the argument variable values should be:
  //   argc == 3 (if only 1 data file used, either input or output) or
  //   argc == 5 (if both input and output data files is specified)
  //   argc == 7 (if both input and output data files specified as well as session number option)
  //   argv[0] == NULL
  //   OPTIONAL:
  //     argv[1] == "-i"
  //     argv[2] == <input file name>
  //   OPTIONAL:
  //     argv[3] == "-o"
  //     argv[4] == <output file name>
  //   OPTIONAL:
  //     argv[5] == "-sn"
  //     argv[6] == <session number>
  //     NOTE: used only for executing input data files after selecting no-pause option
  //
  #if CALCLIB_DEBUG2
    fputs("Entering: FileInput\n", logfile);
  #endif

  if (InputDataFileExecLock() == EXECFILE_LOCKED)
    return FALSE;

  #if CALCLIB_DEBUG12c
    ChrString TempStr_;
  #endif

  Mcalc_Operand** operands;      /* operands array */
  char** arglist = NULL;         /* substitute argument list */
  int cmdline;                   /* command line argument flag */

  // I/O state for async. mode operation
  int IoState_ = CalcPtr_ ? CalcPtr_->CurrentIoState():
                            Mcalc_IOState::IDLE_STATE;
  int PrevState_;           // Previously retrieved I/O state

  long ProgID_ = GiveProgramID();
  CalcProgram* Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;
  int ClearOut_ = Program_ ? Program_->ShouldClearOutputFiles():TRUE;
  CalculatorBase* ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;
  CalculatorBase* PrevCalc_;

  Boolean InputFileProcessing_ = FALSE;
  Boolean ProgramRan_ = FALSE;
  Boolean HasAnswer_ = FALSE;
  Boolean HistoryCmd_ = FALSE;
  Boolean EntryMade_ = FALSE;
  Boolean HasExprAns_ = FALSE;
  Boolean Valid_ = FALSE;
  Boolean Halted_ = FALSE;
  Boolean IntroDone_ = FALSE;
  Boolean CmdHistEntrySelected_ = FALSE;
  Boolean CmdHistChoiceEntered_ = FALSE;
  Boolean CmdHistoryConfirmed_ = FALSE;
  Boolean CmdHistoryCancelled_ = FALSE;
  Boolean ArgStrNonZeroLen_ = FALSE;
  Boolean DoBreakPrg_ = FALSE;
  Boolean ExprCleared_ = FALSE;
  Boolean Do2ndBreak_ = FALSE;
  Boolean SetIdle_ = FALSE;
  ChrString Answer_;
  ChrString QuestionStr_;
  ChrString AnswerStr_;

  // variables for using alternative calculator output buffer
  Boolean VariableDisplayReq_ = FALSE;
  Boolean VariablesDumpedReq_ = FALSE;
  Boolean MessageStringReq_ = FALSE;
  int Sleep_ = 0;
  int RetOutLen_ = 0;
  int ErrorCnt_ = -1;
  int ErrorVal_ = 0;
  int ErrMsgCode_ = 0;
  int OldMode_ = 0;
  int AnswerMode_ = FLOATINGPOINT_MODE;
  int PrevAnswerMode_ = FLOATINGPOINT_MODE;
  bool FetchLimitReached_ = false;
  bool GraphCompleted_ = false;
  bool GraphOutSigSent_ = false;
  bool GraphReady_ = false;
  bool AllLinesCompleted_ = false;
  bool QuitSetByUser_ = false;
  bool ResetGraphDone_ = false;
  bool InBatch_ = false;
  bool NpBatch_ = false;
  bool PgBatch_ = false;
  bool BatchSigSent_ = false;
  bool AccessCond_ = false;
  bool GraphWaiting_ = false;
  bool IoAccess_ = false;
  bool InputReq_ = false;
  bool ErrorsFound_ = false;
  bool GraphCmdFound_ = false;
  bool ExecCmdFound_ = false;
  bool FileNotEmpty_ = false;
  bool HasOutput_ = false;
  bool GraphOutput_ = false;
  bool OutReady_ = false;
  bool InProgram_ = false;
  bool InRunningProg_ = false;
  bool ZeroLenArgStr_ = false;
  bool InBatchInput_ = false;
  bool ProcReq_ = false;
  bool AnsModeChanged_ = false;
  bool GraphOpStageDone_ = false;
  bool PromptDone_ = false;
  bool Sent_ = false;

  int buflen = 0;
  int hlindex_ = 0;
  int hllength_ = 0;
  int linesdone_ = 0;
  int EntryIndex_ = 0;
  char Choice_ = 0;
  size_t sz;
  size_t len16 = strlen("cmdhistoryentry(");
  size_t len23 = strlen("cmdhistoryentry(cancel)");
  const char* PrgExecName_ = NULL;
  const char* CmdHistEndPt_ = NULL;
  const char* CmdHistDelimPt_ = NULL;
  const char* ResultStr_ = NULL;
  const char* RetStr_;
  char* temps_ = NULL;
  char* start_ = NULL;
  char* buffer = NULL;
  char* ansbuf = NULL;
  char* oldargptr = NULL;
  char msgbuf[256];

  char** savedargv = ExecInputFileData() ? NULL:
                                           _CmdLineOptions->argvector;
  int savedargc = (savedargv != NULL) ? _CmdLineOptions->argcount:0;

  if (!ExecInputFileData() || AckPostExecInputFileData())
    help(argc, argv);

  if (ExecInputFileData() &&
      ExecInputFileData() == ExecInputFileDataCnt() &&
      InputDataFileExecLock() == EXECFILE_KEY_SET)
    SetInputDataFileExecLock(EXECFILE_LOCKED);

  #if CALCLIB_TESTASYNCMODE2c
  else
  {
    if (_Mockcio->GetInitialClientInput())
    {
      if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "break", true))
        Bare_SetIoState(Mcalc_IOState::BREAK_PROGRAM, true);
      else if (CalculatorBase::icasestrcomp(_Mockcio->InputEntered().c_str(), "quit", true))
        Bare_SetIoState(Mcalc_IOState::CALC_HALT, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);

      if (_Mockcio->SignalSent())
      {
        IoState_ = CalcPtr_->Bare_GetIoState(0);
        _Mockcio->UpdateClientIoState(IoState_);
      }
    }
    else
    {
      if (_Mockcio->OutputFetched())
        Bare_SetIoState(Mcalc_IOState::OUTPUT_FETCHED, true);
      else if (_Mockcio->ProcessDone())
        Bare_SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
      else if (_Mockcio->InBatchInput() || _Mockcio->InputOptional())
        Bare_SetIoState(Mcalc_IOState::INPUT_RECEIVED, true);
      else if (_Mockcio->ProcessRequired())
        Bare_SetIoState(Mcalc_IOState::PROCESS, true);

      if (_Mockcio->SignalSent())
      {
        IoState_ = CalcPtr_->Bare_GetIoState(0);
        _Mockcio->UpdateClientIoState(IoState_);
      }
    }
  }
  #endif

  getfiles(&argc, argv, &cmdline);   // get files for the program
  initarrays(&operands, &arglist);   // initialize variables
  SetAsyncMode(UsesSessionNum());    // Set asynchronous mode

  if (ExecInputFileData() &&
      ExecInputFileData() == ExecInputFileDataCnt() &&
      InputDataFileExecLock() == EXECFILE_LOCKED &&
      _InputFileLineSize == 0)
    return FALSE;

  if (InAsyncMode() && !NoPauseFileInput())
  {
    // LOOP_GUARD_LIMIT == RETRY_READ_MAX * 10
    SetReadUserInputAttemptLoopGuard(RETRY_READ_MAX * 10,
                                     RETRY_READ_MAX * 10);

    while (ReadUserInputAttemptLoopGuard())  // outer while loop: start
    {
      if (oldargptr && CmdHistoryCancelled_ && !InProgramMode(true))
      {
        arglist[0] = oldargptr;
        oldargptr = NULL;
        CmdHistoryCancelled_ = FALSE;
      }

      if (QuitGraph() && !ResetGraphDone_)
      {
        Exec_SetGraphCondReset(true);
        ResetGraphDone_ = true;

        if (QuitSetByUser_ && Halted_)
          break;
      }

      Halted_ = FALSE;
      HasAnswer_ = FALSE;
      HistoryCmd_ = FALSE;
      EntryMade_ = FALSE;
      CmdHistEntrySelected_ = FALSE;
      CmdHistChoiceEntered_ = FALSE;
      CmdHistoryConfirmed_ = FALSE;
      CmdHistoryCancelled_ = FALSE;
      ArgStrNonZeroLen_ = FALSE;

      PrevState_ = 0;
      EntryIndex_ = 0;
      Choice_ = 0;
      temps_ =
      start_ =
      buffer = NULL;

      #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
        if (_PollClientMgr)
        {
          _PollClientMgr->ResetRetryRead();
          _PollClientMgr->SetExitAtRetryMax(false);
        }
      #endif

      if (PostBreakResponseSent())
        ResetPostBreakResponse();

      Sleep_ = ReadUserInputAttemptLoopGuardTicked() ? 1:0;
      PrevState_ = IoState_;
      if (Sleep_)
        UseMicroSecDelay(true);

      IoState_ = Bare_GetIoState(Sleep_);
      IoState_ = WaitForClientIoState(IoState_,
                                      (Mcalc_IOState::PROCESS |
                                       Mcalc_IOState::BREAK_PROGRAM |
                                       Mcalc_IOState::CALC_HALT), false);

      #if (CALCLIB_DEBUG1 | CALCLIB_DEBUG3)
        printf("opening %s for reading successful, server side\n", PROG_IOSTATE_FILE);
      #endif

      if (IoState_ == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit() || SetIdle_)
      {
        #if CALCLIB_DEBUG2
          fputs("FileInput: Breaking I/O Loop\n", logfile);
        #endif

        if (IoState_ == Mcalc_IOState::CALC_HALT)
          SetIdle_ = TRUE;
        else
          SetIoState(Mcalc_IOState::CALC_HALT);

        break;
      }
      else
        ExprCleared_ = FALSE;

      if (IoState_ == Mcalc_IOState::PROCESS ||
          IoState_ == Mcalc_IOState::BREAK_PROGRAM)
      {
        while (!Halted_ && ReadUserInputExtended(&argc, argv, &arglist, cmdline))  // 2nd while loop: start
        {
          InputFileProcessing_ = TRUE;
          ExprCleared_ = FALSE;
          PrevState_ = IoState_;
          IoState_ = CalcPtr_->Bare_GetIoState(0);
          DoBreakPrg_ = IoState_ == Mcalc_IOState::BREAK_PROGRAM || PostBreakResponseSent();
          _Expression = CalcPtr_->TopSubExprStack();
          GraphCmdFound_ = false;
          ExecCmdFound_ = false;
          PromptDone_ = false;

          // Reset to original calculator and floating point answer mode
          RestoreCalcType();
          ResetAnswerMode();
          SetHasCommandOutput(false, 0, _Expression);
          SetInputPromptWarning(false);

          if (AnswerMode_ == ALTBASE_MODE ||
              AnswerMode_ == LITERAL_MODE ||
              NumberBase() != 10)
            RestoreNumberBase();

          if (DoBreakPrg_)
          {
            if (_Expression && !ExprCleared_)
            {
              ExprCleared_ = TRUE;
              _Expression->Clear();
              GraphOutSigSent_ = false;
            }

            if (start_)
            {
              _MemDel->DelayedDeleteCstr(start_, STOREMEM);
              start_ = temps_ = NULL;
            }

            SetHasCommandOutput(false, 0, _Expression);

            if (!ExecProgramPopped(ProgID_))
              PopActiveProgram(true);

            // clear previously detected errors and output data types
            ClearOutputCondition(CalcPtr_);
            ClearOutputDataType();
            ClearOutputDataErrorCode();
            CalcPtr_->ClearError();

            if (ResultsShown())
            {
              AnsModeChanged_ = AnsModeChanged_ &&
                                OldMode_ != AnswerMode() && ModeFinalized();

              // ClearAnswerStr(AnsModeChanged_, OldMode_);
              ClearAnswerStr(false, OldMode_);
            }
            else
              ClearResultsShown();

            if (AnsModeChanged_)
            {
              PrevAnswerMode_ = AnswerMode_;
              AnsModeChanged_ = false;
            }

            Halted_ = TRUE;
            break;
          }

          if (IoState_ == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit() || SetIdle_)
          {
            #if CALCLIB_DEBUG2
              fputs("FileInput: Breaking I/O Loop\n", logfile);
            #endif

            Do2ndBreak_ = true;  // need to perform 2nd break for halt after escaping while loop

            if (IoState_ == Mcalc_IOState::CALC_HALT)
              SetIdle_ = TRUE;
            else
              SetIoState(Mcalc_IOState::CALC_HALT);

            break;
          }

          #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
          if (!_NoPolling && _PollClientMgr &&
              _PollClientMgr->ResetWhenNotRequired(true)
                            ->ServerReceiveRequired())
          {
            Sleep_ = _PollClientMgr->WaitingForClientResponse() ? 1:0;
            _PollClientMgr->ReceiveKeepAlivePoll(Sleep_);
            #if CALCLIB_TESTMOCKCLIENT
              MockClientAck(IsServerStates(_IoState));
            #endif
            continue;
          }
          #endif

          ConcatArglist(argc, arglist, true);
          if (IsThisChar(arglist[0], 0, CALCCOMMENTLINE_STARTCHAR, 1) ||
              FunctionValidityChecker::IsNullSet(arglist[0]))
            continue;

          Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;
          ClearOut_ = Program_ ? Program_->ShouldClearOutputFiles():TRUE;
          ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;

          if (ClearOut_)
          {
            InputReq_ = PrevState_ == Mcalc_IOState::INPUT_REQUIRED;

            if (!Program_)
              ResetOutputFiles(InputReq_);
            else
              ClearGuiOutputFile();
          }

          PrevCalc_ = CalcPtr_;
          CalcPtr_ = CalcPtr_->GetCalcType();
          if (!CalcPtr_) CalcPtr_ = PrevCalc_;

          // clear previously detected errors and output data types
          ZeroLenArgStr_ = false;
          ClearOutputCondition(CalcPtr_);
          ClearOutputDataType();
          ClearOutputDataErrorCode();
          CalcPtr_->ClearError();

          if (ResultsShown())
          {
            AnsModeChanged_ = AnsModeChanged_ &&
                              OldMode_ != AnswerMode() && ModeFinalized();

            // ClearAnswerStr(AnsModeChanged_, OldMode_);
            ClearAnswerStr(false, OldMode_);
          }
          else
            ClearResultsShown();

          if (AnsModeChanged_)
          {
            PrevAnswerMode_ = AnswerMode_;
            AnsModeChanged_ = false;
          }

          GiveBatchDataStateVars(CalcPtr_, InBatch_, NpBatch_,
                                 PgBatch_, GraphWaiting_, BatchSigSent_);

          if (Program_ && ProgCalc_ != CalcPtr_)
          {
            Program_->SetCalculator(CalcPtr_);
            ProgCalc_ = CalcPtr_;
          }

          if (::SafeStrLen(arglist[0]))
          {
            start_ = temps_ = (char*)allocmem(::SafeStrLen(arglist[0]) + 1, sizeof(char), temps_);
            ::SafeStrCpy(temps_, arglist[0]);
            RemovePadding(temps_, " \t\n\r");
            ArgStrNonZeroLen_ = ::SafeStrLen(temps_) != 0;

            if (!ArgStrNonZeroLen_)
              ZeroLenArgStr_ = true;
          }
          else
            ZeroLenArgStr_ = true;

          _ZeroLenArgStr = ZeroLenArgStr_;

          if (ZeroLenArgStr_)
          {
            AccessCond_ = GiveIoAccessCondition(NULL, PLOTDONE_CHKSHOWN);
            IoAccess_ = GiveIoAccessCondition(NULL, IOACCESS);

            if (AccessCond_ && !GraphOutSigSent_)
            {
              GraphOutSigSent_ = true;
              SetGraphPlotShown(true);

              if (InBatch_)
                SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
              else
              {
                if (!HasErrors() && !HasDirective() && !QuitGraph())
                {
                  FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
                  OutReady_ = HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
                }

                if (!HasErrors() && !HasDirective() && !QuitGraph() &&
                    !OutReady_ && HasOutput_ && FileNotEmpty_)
                {
                  SetResultsShown(true);
                  SendIoState((Mcalc_IOState::CALC_RESPONSE |
                               Mcalc_IOState::GRAPH_OUTPUT), true);
                }
              }
            }
            else if (IoAccess_)
            {
              if (!HasErrors() && !QuitGraph())
              {
                FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
                OutReady_ = HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
              }

              SetResultsShown(!HasErrors() && !QuitGraph() &&
                              !OutReady_ && HasOutput_ && FileNotEmpty_);

              AllowEmptyResponse()
                ->SendCalcResponseSignal(0);
            }
            else
            {
              // empty line read from user input and now answer pending
              // so wait until PROCESS, BREAK or HALT signal is received
              // or wait 1 millisecond before retrieving user input
              if (IoState_ != Mcalc_IOState::PROCESS)
              {
                PrevState_ = IoState_;
                IoState_ = WaitForClientIoState(IoState_,
                                    (Mcalc_IOState::PROCESS |
                                     Mcalc_IOState::BREAK_PROGRAM |
                                     Mcalc_IOState::CALC_HALT), false);
              }
              else
              {
                PrevState_ = IoState_;
                UseMicroSecDelay(true);
                IoState_ = Bare_GetIoState(1);
              }
            }

            if (temps_)
              _MemDel->DelayedDeleteCstr(start_, STOREMEM);

            ArgStrNonZeroLen_ = FALSE;
            start_ = temps_ = NULL;
            ZeroLenArgStr_ = false;
            GraphOutSigSent_ = false;
            continue;
          }
          else if (InAsyncMode() && !NoPauseFileInput() &&
                   (HasDirective() || ProcessAckSignalDone()))
          {
            SetProcessAckTransition(_IoState, false);

            if (!ProcessAckSignalDone())
            {
              if (ProcessAckSignalPending() &&
                  !ProcessAckSignalSent())
              {
                DisplayToLog(ERRMSG_INVALID_DIRECTIVE, GetDirective());
                _LoggedError = true;
              }

              ClearDirective();
              SetProcessAckTransition(0, true);
            }
            else
            {
              ClearDirective();
              SetProcessAckTransition(0, true);
            }
          }

          if (ExecInputFileData() && !AckPostExecInputFileData() &&
              InputDataFileExecLock() == EXECFILE_LOCKED && ::SafeStrLen(temps_) != 0)  // Matches with 2nd while loop
          {
            if (!IntroDone_ && Program_)
            {
              Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;

              if (InputDataFilePauseOption())
              {
                if (!InAllGraphsFile() || GraphFilePause())
                  PromptAsyncUser(MSG_ENTER_TO_QUIT, PROMPT_DISPLAY);
                else
                {
                  PrgExecName_ = _ExecuteProgram ? _ExecuteProgram->Name():
                                                   DATA_INPUT_FILE;
                  sprintf(msgbuf, MSG_PLOTTING_NUM_FUNCTIONS,
                          _NumGraphFunctions, PrgExecName_);
                  PromptAsyncUser(msgbuf, PROMPT_DISPLAY);
                  PrgExecName_ = NULL;
                }

                IntroDone_ = TRUE;

                ClearOutputCondition(CalcPtr_);
                ClearOutputDataType();

                if (Program_ && IsUserPrompterProgram(Program_))
                  Program_->SetMaxRetries(0);
              }
              else
              {
                IntroDone_ = TRUE;

                if (Program_ && IsUserPrompterProgram(Program_))
                {
                  Program_->SetClearOutputFiles(true, false);
                  Program_->SetMaxRetries(CalcProgram::MAXRETRIES);
                }
              }
            }

            AnswerStr_ += temps_;
            AnswerStr_ += "\n>> ";
            QuestionStr_ = AnswerStr_;
            PrgExecName_ = NULL;

            PrevState_ = IoState_;
            IoState_ = CalcPtr_->Bare_GetIoState(0);

            if (strlen(temps_) && IoState_ != Mcalc_IOState::CALC_HALT &&
                                  IoState_ != Mcalc_IOState::BREAK_PROGRAM &&
                                  IoState_ != Mcalc_IOState::PROCESS)
              CalcPtr_->SetIoState(Mcalc_IOState::PROCESS);

            DoBreakPrg_ = IoState_ == Mcalc_IOState::BREAK_PROGRAM ||
                                      (!PostBreakResponseSent() && CalculatorBase::ShouldBreakFromProgram(CalcPtr_));
            _Expression = CalcPtr_->TopSubExprStack();

            if (DoBreakPrg_ || QuitGraph() ||
                _IoState == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit() || SetIdle_)
            {
              if (!DoBreakPrg_ && !QuitGraph())
                CalcPtr_->SetShouldQuit(1);
              else
              {
                SetHasCommandOutput(false, 0, _Expression);

                if (!QuitGraph() && !ExecProgramPopped(ProgID_))
                  PopActiveProgram(true);
              }

              Halted_ = TRUE;
              GraphCmdFound_ = false;
              ExecCmdFound_ = false;
              continue;
            }
            else if (_Expression)
            {
              GraphOutSigSent_ = false;
              _Expression->SetExpression(temps_);
              _Expression->SetCalculator(CalcPtr_);
              _Expression->CheckIfValidExpression();
              _Expression->FindFunctionCalls();
              GraphCmdFound_ = _Expression->GraphCmdWasFound();
              ExecCmdFound_ = _Expression->ExecCmdWasFound();
              RetStr_ = _Expression->Evaluate();
              PrgExecName_ = _Expression->GetProgramName();
              AnswerMode_ = _Expression->GetAnswerMode();
              AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;
              QuitSetByUser_ = QuitGraph();

              if (AnsModeChanged_)
                OldMode_ = PrevAnswerMode_;
              else
                PrevAnswerMode_ = AnswerMode_;

              DoBreakPrg_ = IoState_ == Mcalc_IOState::BREAK_PROGRAM ||
                            (!PostBreakResponseSent() && CalculatorBase::ShouldBreakFromProgram(CalcPtr_));
            }
            else
            {
              GraphCmdFound_ = false;
              ExecCmdFound_ = false;
            }

            if (DoBreakPrg_ || QuitGraph() ||
                _IoState == Mcalc_IOState::CALC_HALT ||
                CalcPtr_->ShouldQuit() || SetIdle_)
            {
              if (!DoBreakPrg_ && !QuitGraph())
                CalcPtr_->SetShouldQuit(1);
              else
              {
                SetHasCommandOutput(false, 0, _Expression);

                if (!QuitGraph() && !ExecProgramPopped(ProgID_))
                  PopActiveProgram(true);
              }

              Halted_ = TRUE;
              continue;
            }

            #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
            if (!_NoPolling && _PollClientMgr &&
                _PollClientMgr->ResetWhenNotRequired(true)
                              ->ServerReceiveRequired())
            {
              Sleep_ = _PollClientMgr->WaitingForClientResponse() ? 1:0;
              _PollClientMgr->ReceiveKeepAlivePoll(Sleep_);
              #if CALCLIB_TESTMOCKCLIENT
                MockClientAck(IsServerStates(_IoState));
              #endif
              continue;
            }
            #endif

            DoBreakPrg_ = FALSE;
            ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
            GraphOutput_ = GraphCmdFound_ && !ErrorsFound_;
                           GraphOperationOptions()->InAppliedFunctionGraph();
            GraphCompleted_ = CalculatorBase::GetGraphPlotter() &&
                              CalculatorBase::GetGraphPlotter()->GraphCompleted();

            if (GraphOutput_)
              SetHasAnswer(true);

            HasOutput_ = !ErrorsFound_ &&
                         (_Expression && (_Expression->HasCommandOutput() ||
                          _Expression->HasAnswer()) ||
                          GraphOutput_);
            SetHasCommandOutput(HasOutput_, 0, _Expression);
            RetOutLen_ = SafeStrLen(RetStr_);

            VariableDisplayReq_ = IsOutputDataType(Mcalc_OutputDataType::Out_VariableDisplay) &&
                                  !DataOutputted(Mcalc_OutputDataType::Out_VariableDisplay);
            VariablesDumpedReq_ = IsOutputDataType(Mcalc_OutputDataType::Out_VariableDump) &&
                                  !DataOutputted(Mcalc_OutputDataType::Out_VariableDump);
            MessageStringReq_ = IsOutputDataType(Mcalc_OutputDataType::Out_MessageString) &&
                                !DataOutputted(Mcalc_OutputDataType::Out_MessageString);

            if (VariableDisplayReq_ || VariablesDumpedReq_ || MessageStringReq_)
              Answer_ = GiveOutputBuffer();
            else
              Answer_.SetEmpty();

            if (!CalcPtr_->HasErrors() &&
                ((RetOutLen_ && (HasOutput_ || GraphCompleted_) && !VariablesDumpedReq_) ||
                 (Answer_.strlen() && !NoOutputReturned() && ::SafeStrLen(PrgExecName_) == 0 &&
                  (VariableDisplayReq_ || VariablesDumpedReq_ || MessageStringReq_))))
            {
              PgBatch_ = (RetOutLen_ && HasOutput_ && !VariablesDumpedReq_);
              NpBatch_ = (Answer_.strlen() && !NoOutputReturned() && ::SafeStrLen(PrgExecName_) == 0 &&
                          (VariableDisplayReq_ || VariablesDumpedReq_ || MessageStringReq_));

              if (PgBatch_ || NpBatch_)
              {
                #if CALCLIB_DEBUG12c
                  DbgPtr()->EnterLevel("CalculatorBase::FileInput -- PromptAsyncUser");
                #endif

                ++linesdone_;

                if (PgBatch_)
                {
                  AnswerStr_ += RetStr_;
                  if (InputDataFilePauseOption())
                    AnswerStr_ += "\t";
                }
                else if (NpBatch_)
                {
                  SetOutputConditionOnDataType();
                  ResetOutputBuffer();

                  AnswerStr_ += Answer_;
                  if (InputDataFilePauseOption())
                    AnswerStr_ += "\t";
                }

                InputReq_ = InputDataFilePauseOption() && ProgCalc_;

                if (InputReq_ || !InputDataFilePauseOption())
                {
                  if (_Plotter && _Plotter->GraphCompleted() &&
                      !GraphOutSigSent_ && !ResponseCompleted())
                  {
                    GraphOpStageDone_ = GraphOpStage() == Mcalc_IOState::OUTPUT_FETCHED ||
                                        GraphOpStage() == Mcalc_IOState::GRAPH_OUTPUT;

                    if ((_BatchDataInput && !_GraphOutputSent && !GraphOpStageDone_) ||
                        (!_BatchDataInput && !GraphOpStageDone_))
                    {
                      _Plotter->SendGraphOutputSignal(1, InBatchFile(true));
                      GraphOutSigSent_ = true;
                    }
                  }

                  ProgramRan_ = TRUE;

                  if (!ProcessAckSignalSent() &&
                      !InputReq_ && (!GraphOutSigSent_ || !_Plotter))
                  {
                    buflen = (!AnswerStr_.IsEmpty() && AnswerStr_.c_str()) ?
                                  AnswerStr_.strlen():0;
                    buflen += 10;
                    ansbuf = (char*)CalculatorBase::allocmem(buflen, sizeof(char), ansbuf);

                    if (buflen > 10)
                      strcpy(ansbuf, AnswerStr_.c_str());
                    else
                      strcpy(ansbuf, "");

                    #if CALCLIB_DEBUG12
                      if (DbgPtr())
                        DbgPtr()->ShowStr(ansbuf, "CalculatorBase::FileInput -- ansbuf");
                    #endif

                    PromptAsyncUser(ansbuf, PROMPT_DISPLAY_PARTS);
                    _MemDel->DelayedDeleteCstr(ansbuf, STOREMEM);
                    // GetIoState(1);  // IOstate delay 1 millisecond after displaying in parts
                    // PromptAsyncUser(AnswerStr_.c_str(), PROMPT_DISPLAY);  // Removed (not working)

                    #if CALCLIB_DEBUG12c
                      TempStr_ = AnswerStr_;
                      TempStr_.RemovePadding(" \t\n\r");
                      DbgPtr()->ShowMessage("PromptAsyncUser(AnswerStr_.c_str(), PROMPT_DISPLAY_PARTS);\n");

                      if (TempStr_.strlen() < 256)
                        DbgPtr()->ShowStr(TempStr_.c_str(), "AnswerStr_");
                    #endif
                  }
                  else if (!ProcessAckSignalSent() && InputReq_)
                  {
                    InputReq_ = GiveIoAccessCondition(NULL, INREQALLOWED);

                    if ((!GraphOutSigSent_ || !_Plotter) && InputReq_)
                    {
                      ProgCalc_->SetWaitForResponse(Mcalc_IOState::INPUT_REQUIRED);

                      buflen = (!AnswerStr_.IsEmpty() && AnswerStr_.c_str()) ?
                                    AnswerStr_.strlen():0;
                      buflen += 10;
                      ansbuf = (char*)CalculatorBase::allocmem(buflen, sizeof(char), ansbuf);

                      if (buflen > 10)
                        strcpy(ansbuf, AnswerStr_.c_str());
                      else
                        strcpy(ansbuf, "");

                      #if CALCLIB_DEBUG12
                        if (DbgPtr())
                          DbgPtr()->ShowStr(ansbuf, "CalculatorBase::FileInput -- ansbuf");
                      #endif

                      PromptAsyncUser(ansbuf, PROMPT_INPUT);
                      _MemDel->DelayedDeleteCstr(ansbuf, STOREMEM);
                      // INPUT_REQUIRED --> INPUT_RECEIVED

                      #if CALCLIB_DEBUG12c
                        TempStr_ = AnswerStr_;
                        TempStr_.RemovePadding(" \t\n\r");
                        DbgPtr()->ShowMessage("PromptAsyncUser(AnswerStr_.c_str(), PROMPT_INPUT);\n");

                        if (TempStr_.strlen() < 256)
                          DbgPtr()->ShowStr(TempStr_.c_str(), "AnswerStr_");
                      #endif
                    }
                  }
                }

                #if CALCLIB_DEBUG12c
                  DbgPtr()->ShowInt(InputReq_, "InputReq_");
                  DbgPtr()->LeaveLevel();
                #endif
              }
            }
            else
            {
              if (CalcPtr_->HasErrors())
              {
                if (_Expression)
                {
                  _Expression->SetProgramName(NULL);
                  PrgExecName_ = NULL;
                }

                if (CalcPtr_->GetErrorVal() == Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS)
                {
                  ErrorCnt_ = -1;
                  ErrorVal_ = 0;
                  ErrMsgCode_ = 0;

                  SetMultiErrorVector(OutputDataErrorCode(), MakeOutputErrorsMaxSel(),
                                      MakeOutputErrorsErrVals(), Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS);

                  while (ErrMsgCode_ = FindMultiErrors(ErrorCnt_, ErrorVal_))
                  {
                    SetError(ErrMsgCode_, true);
                    DisplayErrorMessageForCode(GetOutputFile(), GetErrorVal());

                    FetchAndShowCurrentError(QuestionStr_);
                    CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

                    if (InputDataFilePauseOption())
                    {
                      PrevState_ = IoState_;
                      IoState_ = Bare_GetIoState(0);
                      IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
                      UseMicroSecDelay(!FetchLimitReached_ ||
                                       CurrentIoState() == Mcalc_IOState::CALC_ERROR);

                      if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
                      {
                        CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
                        IoState_ = Mcalc_IOState::CALC_ERROR;
                      }
                      else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
                        IoState_ = Mcalc_IOState::CALC_ERROR;
                    }

                    ClearError();

                    if (PostBreakResponseSent())
                    {
                      DoBreakPrg_ = TRUE;
                      break;
                    }
                    else
                      CalculatorBase::ShouldBreakFromProgram(CalcPtr_);
                  }

                  if (ErrorStatePending())
                    ClearPendingErrors();

                  if (DoBreakPrg_)
                  {
                    // clear previously detected errors and output data types
                    ClearOutputCondition(CalcPtr_);
                    ClearOutputDataType();
                    ClearOutputDataErrorCode();
                    continue;
                  }
                }
                else
                {
                  FetchAndShowCurrentError(QuestionStr_);
                  CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

                  if (InputDataFilePauseOption())
                  {
                    PrevState_ = IoState_;
                    IoState_ = Bare_GetIoState(0);
                    IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
                    UseMicroSecDelay(!FetchLimitReached_ ||
                                     CurrentIoState() == Mcalc_IOState::CALC_ERROR);

                    if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
                    {
                      CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
                      IoState_ = Mcalc_IOState::CALC_ERROR;
                    }
                    else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
                      IoState_ = Mcalc_IOState::CALC_ERROR;
                  }

                  if (PostBreakResponseSent())
                    DoBreakPrg_ = TRUE;
                  else
                    CalculatorBase::ShouldBreakFromProgram(CalcPtr_);

                  if (ErrorStatePending())
                    ClearPendingErrors();

                  if (DoBreakPrg_)
                    continue;
                }
              }
              else
              {
                RetOutLen_ = SafeStrLen(RetStr_);
                ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
                GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                               GraphOperationOptions()->InAppliedFunctionGraph();
                HasOutput_ = !ErrorsFound_ &&
                             ((_Expression && (_Expression->HasCommandOutput() ||
                               _Expression->HasAnswer()) && RetOutLen_) ||
                              GraphOutput_);

                SetHasCommandOutput(HasOutput_, 0, _Expression);
                if (GraphOutput_)
                  SetHasAnswer(true);
              }
            }

            SetUnknownDirOrConfirmResults(CalcPtr_, _Expression, HasOutput_);

            if (_Expression)
            {
              _Expression->SetProgramName(NULL);
              PrgExecName_ = NULL;

              if (!ExprCleared_)
              {
                ExprCleared_ = TRUE;
                _Expression->Clear();
                GraphOutSigSent_ = false;
              }
            }

            _MemDel->DelayedDeleteCstr(start_, STOREMEM);
            start_ = temps_ = NULL;
            AnswerStr_ = "\n";

            // clear previously detected errors and output data types
            ClearOutputCondition(CalcPtr_);
            ClearOutputDataType();
            ClearOutputDataErrorCode();
            CalcPtr_->ClearError();

            PrevState_ = IoState_;
            IoState_ = CalcPtr_->Bare_GetIoState(0);
            RetStr_ = ProgramStr();

            if ((IoState_ == Mcalc_IOState::BREAK_PROGRAM ||
                 (!CalculatorBase::PostBreakResponseSent() &&
                  CalculatorBase::ShouldBreakFromProgram(CalcPtr_))) ||
                ((RetStr_ && toupper(RetStr_[0]) == 'Q') || QuitGraph()) ||
                (CalcPtr_->ShouldQuit() || IoState_ == Mcalc_IOState::CALC_HALT || SetIdle_))
            {
              if (!ExecProgramPopped(ProgID_))
                PopActiveProgram(true);

              if (CalcPtr_->ShouldQuit() || IoState_ == Mcalc_IOState::CALC_HALT || SetIdle_)
              {
                Do2ndBreak_ = true;  // need to perform 2nd break for halt after escaping while loop
                if (IoState_ == Mcalc_IOState::CALC_HALT)
                  SetIdle_ = TRUE;
                else
                  SetIoState(Mcalc_IOState::CALC_HALT);
              }

              Halted_ = TRUE;
            }

            ProgramRan_ = TRUE;
            continue;  // return back to top of 2nd while loop
          }  // if (_ExecInputFileData ...) : 2nd while loop, logical end

          // 2nd while loop break logic for 2nd while loop
          if (ExecInputFileData() && !AckPostExecInputFileData() &&
              (Halted_ || CalcPtr_->ShouldQuit() || IoState_ == Mcalc_IOState::CALC_HALT || SetIdle_))
          {
            #if CALCLIB_DEBUG2
              fputs("FileInput: Breaking I/O Loop\n", logfile);
            #endif

            if (CalcPtr_->ShouldQuit() || IoState_ == Mcalc_IOState::CALC_HALT || SetIdle_)
            {
              Do2ndBreak_ = true;  // need to perform 2nd break for halt after escaping while loop
              if (IoState_ == Mcalc_IOState::CALC_HALT)
                SetIdle_ = TRUE;
              else
                SetIoState(Mcalc_IOState::CALC_HALT);
            }

            SetHasAnswer(FALSE);
            break;
          }

          // Inspect command prompt entered input for any index specified command
          // history list entry that is selected by the user and extract relevant
          // data from the history command
          //
          if (CommandHistoryMode() && !InProgramMode(true) && ArgStrNonZeroLen_)
          {
            CmdHistChoiceEntered_ = icasestrcompn(temps_, "cmdhistoryentry(", len16);
            CmdHistEndPt_ = strchr(temps_, ')');

            if (CmdHistEndPt_)
            {
              sz = CmdHistEndPt_ - temps_;
              CmdHistDelimPt_ = strchr(&temps_[sz], CMDHISTENTRY_SEPCHAR);
              CmdHistoryConfirmed_ = TRUE;
              DisplayCommandHistoryList();
            }
            else
            {
              CmdHistDelimPt_ = NULL;
              CmdHistoryConfirmed_ = FALSE;
            }

            if (!CmdHistChoiceEntered_ || !CmdHistEndPt_ || !CmdHistDelimPt_)
            {
              SetHistoryListMode(FALSE);
              SetHistoryListIndex(-1);
            }
          }
          else if (!InProgramMode(true) && ArgStrNonZeroLen_)
          {
            CmdHistChoiceEntered_ = icasestrcompn(temps_, "cmdhistoryentry(", len16);
            CmdHistEndPt_ = strchr(temps_, ')');

            if (CmdHistEndPt_)
            {
              sz = CmdHistEndPt_ - temps_;
              CmdHistDelimPt_ = strchr(&temps_[sz], CMDHISTENTRY_SEPCHAR);
            }
            else
              CmdHistDelimPt_ = NULL;

            if (!CmdHistDelimPt_)
            {
              CmdHistoryConfirmed_ = FALSE;
              CmdHistoryCancelled_ = FALSE;
              CmdHistChoiceEntered_ = FALSE;
              CmdHistEndPt_ = CmdHistDelimPt_ = NULL;
              SetHistoryListMode(FALSE);
              SetHistoryListIndex(-1);
            }
          }

          if (!InProgramMode(true) && ArgStrNonZeroLen_ && icasestrcompn(temps_, "cmdhistoryentry(cancel)", len23) &&
              CmdHistChoiceEntered_ && CmdHistEndPt_ && CmdHistDelimPt_ &&
              temps_ && (CmdHistDelimPt_+1))
          {
            ::memmove(temps_, CmdHistDelimPt_+1, ::SafeStrLen(CmdHistDelimPt_));
            start_ = temps_;
            CmdHistEndPt_ = strchr(arglist[0], ')');

            if (CmdHistEndPt_)
            {
              sz = CmdHistEndPt_ - arglist[0];
              oldargptr = arglist[0];
              arglist[0] = strchr(arglist[0]+sz, CMDHISTENTRY_SEPCHAR);

              if (arglist[0])
                arglist[0]++;
              else
              {
                arglist[0] = oldargptr;
                oldargptr = NULL;
              }
            }
            else
              oldargptr = NULL;

            _ZeroLenArgStr =
            ZeroLenArgStr_ = false;
            SetHistoryListMode(FALSE);
            SetHistoryListIndex(-1);
            CmdHistChoiceEntered_ = FALSE;
            CmdHistoryConfirmed_ = FALSE;
            CmdHistoryCancelled_ = CmdHistEndPt_ != NULL &&
                                   oldargptr != NULL;

            CmdHistEndPt_ =
            CmdHistDelimPt_ = NULL;

            if (::SafeStrLen(arglist[0]))
            {
              RemovePadding(temps_, " \t\n\r");
              ArgStrNonZeroLen_ = ::SafeStrLen(temps_) != 0;

              if (!ArgStrNonZeroLen_)
                ZeroLenArgStr_ = true;
            }
            else
            {
              ArgStrNonZeroLen_ = FALSE;
              ZeroLenArgStr_ = true;
            }

            _ZeroLenArgStr = ZeroLenArgStr_;

            if (ZeroLenArgStr_)
            {
              // empty line after cmdhistoryentry(cancel): command means
              // cancel the entire math command that was selected from the
              // pop-up history form (or command prompt menu in text mode)
              // so send CALC_RESPONSE signal to cancel command
              //
              if (!InBatchFile())
              {
                PrevState_ = IoState_;
                SetResultsShown(false);
                AllowEmptyResponse()
                  ->SendCalcResponseSignal(0);
              }

              ZeroLenArgStr_ = false;
              break; // continue outer while loop
            }
          }
          else if (!InProgramMode(true) && !CmdHistoryConfirmed_ && CmdHistDelimPt_)
          {
            CmdHistoryConfirmed_ = FALSE;
            CmdHistoryCancelled_ = FALSE;
            CmdHistChoiceEntered_ = FALSE;
            CmdHistEndPt_ = CmdHistDelimPt_ = NULL;
            SetHistoryListMode(FALSE);
            SetHistoryListIndex(-1);
            ArgStrNonZeroLen_ = ::SafeStrLen(temps_) != 0;

            if (!ArgStrNonZeroLen_)
            {
              // An entry from command history table is selected to be executed
              // User command entered determined as: "cmdhistoryentry(...): "
              //
              if (!InBatchFile())
              {
                PrevState_ = IoState_;
                SetResultsShown(false);
                AllowEmptyResponse()
                  ->SendCalcResponseSignal(0);
              }

              break; // continue outer while loop
            }
          }

          if (ArgStrNonZeroLen_ && icasestrcomp(temps_, "clearhistory") &&
              !InProgramMode(true) && !CommandHistoryMode())
          {
            // Clear command history list and erase command history file
            //
            if (CommandHistoryLength() || CommandHistoryIndex() >= 0)
              ClearCommandHistoryFile();

            SetHistoryListMode(FALSE);
            SetHistoryListIndex(-1);
            SetHistoryListLength(0);

            if (InAsyncMode() && !NoPauseFileInput())
            {
              TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
              DisplayMessage(GetGuiOutputFile(false, false, !NoPauseFileInput()), MSG_COMMAND_HISTORY_CLEARED);
            }
            else
              DisplayMessage(GetOutputFile(false, false, !NoPauseFileInput()), MSG_COMMAND_HISTORY_CLEARED);

            if (!NoPauseFileInput())
              CloseGuiOutputFile();

            _MemDel->DelayedDeleteCstr(start_, STOREMEM);
            SendOutputReadySignal(0);
            SetHasAnswer(FALSE);
            ArgStrNonZeroLen_ = FALSE;

            break; // continue outer while loop
          }
          else if (ArgStrNonZeroLen_ &&
                   icasestrcomp(temps_, "history") && !InProgramMode(true))
          {
            // Show command history list entries to user
            //
            if (CommandHistoryLength())
            {
              DisplayCommandHistoryList();
              EndCommandHistoryList();
              SetHistoryListMode(TRUE);
            }

            _MemDel->DelayedDeleteCstr(start_, STOREMEM);
            ArgStrNonZeroLen_ = FALSE;

            if (!InBatchFile())
            {
              PrevState_ = IoState_;
              SetResultsShown(false);
              AllowEmptyResponse()
                ->SendCalcResponseSignal(0);
            }

            break; // continue outer while loop
          }

          // Inspect input from data file for command history list related
          // commands and extract relevant data from the history command
          //
          else if (!InProgramMode(true) &&
                   CmdHistoryConfirmed_ && !CmdHistoryCancelled_ &&
                   CmdHistChoiceEntered_ && CmdHistEndPt_ && CmdHistDelimPt_)
          {
            // Process index specified command history list entry that is
            // selected by the user in asynchronous input/output mode
            //
            sz = CmdHistEndPt_ - temps_;
            temps_[sz] = 0;
            EntryIndex_ = atoi(&temps_[len16]);
            temps_[sz] = ')';
            EntryIndex_ = CommandHistoryLength() - EntryIndex_ - 1;
            HistoryCmd_ = TRUE;

            if (0 <= EntryIndex_ && EntryIndex_ < CommandHistoryLength())
            {
              SetHistoryListIndex(EntryIndex_);
              hlindex_ = CommandHistoryIndex();

              Valid_ = HistoryListElementValid(hlindex_) == CMDENTRY_VALID;
              sz = size_t(HistoryListElementSize(hlindex_));

              if (Valid_ && sz && ::SafeStrLen(HistoryListElementStr(hlindex_)))
              {
                buffer = (char*)CalculatorBase::allocmem(::SafeStrLen(temps_), sizeof(char), buffer);
                sz = CmdHistDelimPt_ - temps_;

                ::SafeStrCpy(buffer, &temps_[sz+1]);
                RemovePadding(buffer, " \t\n\r");
                SetHistoryListEntry(buffer, FALSE);
                HasAnswer_ = TRUE;

                CmdHistEntrySelected_ = TRUE;
                Choice_ = 'Y';
              }
            }

            if (!buffer || Choice_ != 'Y')
            {
              SetHistoryListMode(FALSE);
              SetHistoryListIndex(-1);
            }
          }

          // Command history list entry selected in user prompt with "yes" or
          // Entered math statement stored in command history list as new entry
          //
          if (buffer && Choice_ == 'Y' && !InProgramMode(true))
          {
            if (CmdHistEntrySelected_)
              temps_ = buffer;

            sz = ::SafeStrLen(temps_);
            hllength_ = CommandHistoryLength();
            AllocateHistoryListElement(hllength_, sz + 5);
            SetHistoryListElementValid(hllength_, CMDENTRY_INVALID);
            SetHistoryListElementSize(hllength_, Ushort(sz));
            SetHistoryListElementStr(hllength_, temps_);

            if (CmdHistEntrySelected_)
            {
              _MemDel->DelayedDeleteCstr(start_, STOREMEM);
              start_ = buffer;
              buffer = NULL;

              SetHistoryListEnded(FALSE);
              SetHistoryListMode(FALSE);
              SetHistoryListIndex(-1);
            }
          }
          else if (arglist[0])
          {
            if (ArgStrNonZeroLen_)
            {
              _MemDel->DelayedDeleteCstr(start_, STOREMEM);
              ArgStrNonZeroLen_ = FALSE;
            }

            start_ = temps_ = (char*)allocmem(::SafeStrLen(arglist[0]) + 1, sizeof(char), temps_);
            ::SafeStrCpy(start_, arglist[0]);
            temps_ = start_;
            RemovePadding(temps_, " \t\r\n");
            sz = ::SafeStrLen(temps_);
            ArgStrNonZeroLen_ = sz > 0;

            if (!InProgramMode(true))
            {
              hllength_ = CommandHistoryLength();
              AllocateHistoryListElement(hllength_, sz + 5);
              SetHistoryListElementValid(hllength_, CMDENTRY_INVALID);
              SetHistoryListElementSize(hllength_, Ushort(sz));
              SetHistoryListElementStr(hllength_, temps_);
            }

            EntryMade_ = TRUE;
            HistoryCmd_ = FALSE;
            CmdHistEntrySelected_ = FALSE;
          }

          // Process command history list related command or
          // process entered math statement from data input file
          //
          if (HistoryCmd_ && CmdHistEntrySelected_ && HasAnswer_ && !InProgramMode(true) &&
              arglist[0] && ::SafeStrLen(CommandHistoryEntry()))
          {
            _Expression = CalcPtr_->TopSubExprStack();

            if (_Expression)
            {
              _Expression->SetExpression(CommandHistoryEntry());
              _Expression->SetCalculator(CalcPtr_);
              _Expression->CheckIfValidExpression();
              _Expression->FindFunctionCalls();
              GraphCmdFound_ = _Expression->GraphCmdWasFound();
              ExecCmdFound_ = _Expression->ExecCmdWasFound();
              ResultStr_ = _Expression->Evaluate();
              AnswerMode_ = _Expression->GetAnswerMode();
              AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;
              QuitSetByUser_ = QuitGraph();

              if (AnsModeChanged_)
                OldMode_ = PrevAnswerMode_;
              else
                PrevAnswerMode_ = AnswerMode_;
            }
            else
            {
              GraphCmdFound_ = false;
              ExecCmdFound_ = false;
            }

            if (AckPostExecInputFileData() && !PostExecResetProcessDone())
            {
              Sleep_ = (!InputDataFilePauseOption() ||
                        NoPauseFileInput()) ? 1:0;

              UseMicroSecDelay(true);
              PrevState_ = IoState_;
              IoState_ = Bare_GetIoState(Sleep_);  // IOstate delay 1 millisecond after end of input file execution

              if (NoPauseFileInput())
              {
                if (IoState_ == Mcalc_IOState::OUTPUT_READY ||
                    IoState_ == Mcalc_IOState::GRAPH_OUTPUT)
                {
                  PrevState_ = IoState_;
                  IoState_ = WaitForClientOutputStates(IoState_, &FetchLimitReached_);

                  if (FetchLimitReached_)
                  {
                    PrevState_ = IoState_;
                    UseMicroSecDelay(CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                                     CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                                     CurrentIoState() == Mcalc_IOState::PROCESS_DONE);
                    IoState_ = Bare_GetIoState(1);

                    if (IoState_ == Mcalc_IOState::OUTPUT_READY ||
                        IoState_ == Mcalc_IOState::GRAPH_OUTPUT)
                    {
                      CalcPtr_->SetIoStateForced(IoState_ == Mcalc_IOState::GRAPH_OUTPUT);
                      CalcPtr_->SetIoState(Mcalc_IOState::OUTPUT_FETCHED, true);
                      IoState_ = Mcalc_IOState::OUTPUT_FETCHED;
                    }
                    else if (IoState_ == Mcalc_IOState::PROCESS_DONE)
                    {
                      CalcPtr_->SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
                      IoState_ = Mcalc_IOState::PROCESS_DONE_ACK;
                    }
                    else if (CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                             CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                             CurrentIoState() == Mcalc_IOState::PROCESS_DONE)
                      IoState_ = CurrentIoState();
                  }
                  else if (CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                           CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                           CurrentIoState() == Mcalc_IOState::PROCESS_DONE)
                    IoState_ = CurrentIoState();
                }

                CloseGuiOutputFile();
                GetGuiOutputFile(true, true);
              }

              SetHasAnswer(FALSE);
              closeIOfiles();
              savedargc = (savedargv != NULL) ? _CmdLineOptions->argcount:0;
              getfiles(&savedargc, savedargv, NULL);

              SetHasAnswer(FALSE);
              SetNoPauseFileInput(FALSE);
              SetInputDataFilePauseOption(TRUE);
              ResetAckPostExecInputFileData();
              ResetExecInputFileData();
              SetInputDataFileExecLock(EXECFILE_UNLOCKED);

              _IoStatePtr->ResetAtEndOfProcess(IoState_);
              SetPostExecResetProcessDone(TRUE);

              if (BatchFileEndedSignalPending())
                ReCheckEndBatchSignal();

              if (QuitGraph())
              {
                CalcPtr_->SetBatchFileEndedSignalPending(false);
                CalcPtr_->SetBatchFileEndedSignalSent(false);
                CalcPtr_->SetBatchFileEndedSignalAcked(false);
                CalcPtr_->SetClientAckedDoneToGraphOutput(false);
                CalcPtr_->SetResponseWasCompleted(false);
                CalcPtr_->SetGraphOutputWasSent(FALSE);
                CalcPtr_->SetWasInBatchDataInput(FALSE);
              }

              Exec_ResetQuitGraphFlags();
              SetInputDataFilePauseOption(TRUE);  // default is true
            }
          }
          else if (!HistoryCmd_ && !CmdHistEntrySelected_ && ::SafeStrLen(temps_))
          {
            _Expression = CalcPtr_->TopSubExprStack();

            if (_Expression)
            {
              _Expression->SetExpression(temps_);
              _Expression->SetCalculator(CalcPtr_);
              _Expression->CheckIfValidExpression();
              _Expression->FindFunctionCalls();
              GraphCmdFound_ = _Expression->GraphCmdWasFound();
              ExecCmdFound_ = _Expression->ExecCmdWasFound();
              ResultStr_ = _Expression->Evaluate();
              AnswerMode_ = _Expression->GetAnswerMode();
              AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;
              QuitSetByUser_ = QuitGraph();

              if (AnsModeChanged_)
                OldMode_ = PrevAnswerMode_;
              else
                PrevAnswerMode_ = AnswerMode_;
            }
            else
            {
              GraphCmdFound_ = false;
              ExecCmdFound_ = false;
            }

            if (AckPostExecInputFileData() && !PostExecResetProcessDone())
            {
              Sleep_ = (!InputDataFilePauseOption() ||
                        NoPauseFileInput()) ? 1:0;

              UseMicroSecDelay(true);
              PrevState_ = IoState_;
              IoState_ = Bare_GetIoState(Sleep_);  // IOstate delay 1 millisecond after end of input file execution

              if (NoPauseFileInput())
              {
                if (IoState_ == Mcalc_IOState::OUTPUT_READY ||
                    IoState_ == Mcalc_IOState::GRAPH_OUTPUT)
                {
                  PrevState_ = IoState_;
                  IoState_ = WaitForClientOutputStates(IoState_, &FetchLimitReached_);

                  if (FetchLimitReached_)
                  {
                    PrevState_ = IoState_;
                    UseMicroSecDelay(CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                                     CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                                     CurrentIoState() == Mcalc_IOState::PROCESS_DONE);
                    IoState_ = Bare_GetIoState(1);

                    if (IoState_ == Mcalc_IOState::OUTPUT_READY ||
                        IoState_ == Mcalc_IOState::GRAPH_OUTPUT)
                    {
                      CalcPtr_->SetIoStateForced(IoState_ == Mcalc_IOState::GRAPH_OUTPUT);
                      CalcPtr_->SetIoState(Mcalc_IOState::OUTPUT_FETCHED, true);
                      IoState_ = Mcalc_IOState::OUTPUT_FETCHED;
                    }
                    else if (IoState_ == Mcalc_IOState::PROCESS_DONE)
                    {
                      CalcPtr_->SetIoState(Mcalc_IOState::PROCESS_DONE_ACK, true);
                      IoState_ = Mcalc_IOState::PROCESS_DONE_ACK;
                    }
                    else if (CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                             CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                             CurrentIoState() == Mcalc_IOState::PROCESS_DONE)
                      IoState_ = CurrentIoState();
                  }
                  else if (CurrentIoState() == Mcalc_IOState::OUTPUT_READY ||
                           CurrentIoState() == Mcalc_IOState::GRAPH_OUTPUT ||
                           CurrentIoState() == Mcalc_IOState::PROCESS_DONE)
                    IoState_ = CurrentIoState();
                }

                CloseGuiOutputFile();
                GetGuiOutputFile(true, true);
              }

              SetHasAnswer(FALSE);
              closeIOfiles();
              savedargc = (savedargv != NULL) ? _CmdLineOptions->argcount:0;
              getfiles(&savedargc, savedargv, NULL);

              SetHasAnswer(FALSE);
              SetNoPauseFileInput(FALSE);
              SetInputDataFilePauseOption(TRUE);
              ResetAckPostExecInputFileData();
              ResetExecInputFileData();
              SetInputDataFileExecLock(EXECFILE_UNLOCKED);

              _IoStatePtr->ResetAtEndOfProcess(IoState_);
              SetPostExecResetProcessDone(TRUE);

              if (BatchFileEndedSignalPending())
                ReCheckEndBatchSignal();

              if (QuitGraph())
              {
                CalcPtr_->SetBatchFileEndedSignalPending(false);
                CalcPtr_->SetBatchFileEndedSignalSent(false);
                CalcPtr_->SetBatchFileEndedSignalAcked(false);
                CalcPtr_->SetClientAckedDoneToGraphOutput(false);
                CalcPtr_->SetResponseWasCompleted(false);
                CalcPtr_->SetGraphOutputWasSent(FALSE);
                CalcPtr_->SetWasInBatchDataInput(FALSE);
              }

              Exec_ResetQuitGraphFlags();
              SetInputDataFilePauseOption(TRUE);  // default is true
            }
          }

          if (_IoState == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit() || SetIdle_)
          {
            CalcPtr_->SetShouldQuit(1);

            if (_Expression && !ExprCleared_)
            {
              ExprCleared_ = TRUE;
              _Expression->Clear();
              GraphOutSigSent_ = false;
            }

            if (IoState_ == Mcalc_IOState::CALC_HALT)
              SetIdle_ = TRUE;
            else
              SetIoState(Mcalc_IOState::CALC_HALT);

            // need to perform 2nd for loop break for halting program after
            // breaking from processing input data file in 2nd while loop
            if (InputFileProcessing_ &&
                ((!ExecInputFileData() || AckPostExecInputFileData()) ||
                 (!CalcPtr_->ExecInputFileData() || CalcPtr_->AckPostExecInputFileData())))
              Do2ndBreak_ = true;

            if (!InProgramMode(true))
            {
              SetHistoryListMode(FALSE);
              SetHistoryListIndex(-1);
            }

            if (EntryMade_ && !InProgramMode(true))
            {
              hllength_ = CommandHistoryLength();
              DeallocateHistoryListElement(hllength_);
            }
          }

          else if (ResultStr_ && !InProgramMode(true) && (EntryMade_ || CommandHistoryEntry()))
          {
            EntryIndex_ = CommandHistoryLength();
            SetHistoryListElementValid(IncHistoryListLength(1, POSTFIX), CMDENTRY_VALID);
            WriteCommandHistoryEntry(GetCommandHistoryFile(), EntryIndex_);

            if (CommandHistoryEntry() && !CmdHistEntrySelected_)
              DeallocateHistoryListEntry();
          }

          if (CmdHistEntrySelected_ && !InProgramMode(true))
            SetHistoryListEntry(NULL, FALSE);

          if (!InProgramMode(true) && CommandHistoryLength() == MAXHISTORY-1)
          {
            DeallocateHistoryListElement(0);

            DecHistoryListLength();
            ::SafeMemMove(HistoryListBase(),
                          HistoryListBase(1),
                          sizeof(char*) * (MAXHISTORY-1));

            DisplayCommandHistoryList();
          }

          _MemDel->DelayedDeleteCstr(start_, STOREMEM);
          _MemDel->DelayedDeleteCstr(buffer, STOREMEM);

          if (CalcPtr_->ShouldQuit() || IoState_ == Mcalc_IOState::CALC_HALT || SetIdle_)
          {
            if (!InProgramMode(true))
              EndCommandHistoryList();

            if (IoState_ == Mcalc_IOState::CALC_HALT)
              SetIdle_ = TRUE;
            else
              SetIoState(Mcalc_IOState::CALC_HALT);

            // need to perform 2nd for loop break for halting program after
            // breaking from processing input data file in 2nd while loop
            if (InputFileProcessing_ &&
                ((!ExecInputFileData() || AckPostExecInputFileData()) ||
                 (!CalcPtr_->ExecInputFileData() || CalcPtr_->AckPostExecInputFileData())))
              Do2ndBreak_ = true;

            break;
          }

          ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
          GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                         GraphOperationOptions()->InAppliedFunctionGraph();
          RetOutLen_ = SafeStrLen(ResultStr_);
          HasExprAns_ = !ErrorsFound_ &&
                        ((_Expression &&
                          _Expression->HasAnswer() && RetOutLen_) ||
                         GraphOutput_);
          HasOutput_ = !ErrorsFound_ &&
                       ((_Expression && _Expression->HasCommandOutput()) ||
                        GraphOutput_);

          SetUnknownDirOrConfirmResults(CalcPtr_, _Expression, HasOutput_);

          if (!InProgramMode(true))
          {
            if (!CalcPtr_->HasErrors() && HasExprAns_)
            {
              SetHasCommandOutput(HasOutput_ || HasExprAns_, 0, _Expression);
              if (GraphOutput_)
                SetHasAnswer(true);

              _Expression->ShowResults();
            }
            else
            {
              if (PostBreakResponseSent())
                ResetPostBreakResponse();
              else
              {
                if (CalcPtr_->HasErrors())
                {
                  if (CalcPtr_->GetErrorVal() == Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS)
                  {
                    ErrorCnt_ = -1;
                    ErrorVal_ = 0;
                    ErrMsgCode_ = 0;

                    SetMultiErrorVector(OutputDataErrorCode(), MakeOutputErrorsMaxSel(),
                                        MakeOutputErrorsErrVals(), Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS);

                    while (ErrMsgCode_ = FindMultiErrors(ErrorCnt_, ErrorVal_))
                    {
                      SetError(ErrMsgCode_, true);
                      DisplayErrorMessageForCode(GetOutputFile(), GetErrorVal());

                      FetchAndShowCurrentError(QuestionStr_);
                      CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

                      if (InputDataFilePauseOption())
                      {
                        PrevState_ = IoState_;
                        IoState_ = Bare_GetIoState(0);
                        IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
                        UseMicroSecDelay(!FetchLimitReached_ ||
                                         CurrentIoState() == Mcalc_IOState::CALC_ERROR);

                        if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
                        {
                          CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
                          IoState_ = Mcalc_IOState::CALC_ERROR;
                        }
                        else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
                          IoState_ = Mcalc_IOState::CALC_ERROR;
                      }

                      ClearError();

                      if (PostBreakResponseSent())
                      {
                        // clear previously detected errors and output data types
                        ClearOutputCondition(CalcPtr_);
                        ClearOutputDataType();
                        ClearOutputDataErrorCode();
                        ResetPostBreakResponse();
                        break;
                      }
                      else
                        CalculatorBase::ShouldBreakFromProgram(CalcPtr_);
                    }

                    if (IoState_ == Mcalc_IOState::CALC_HALT)
                      SetIdle_ = TRUE;
                    else if (CalcPtr_->ShouldQuit())
                      SetIoState(Mcalc_IOState::CALC_HALT);

                    // need to perform 2nd for loop break for halting program after
                    // breaking from processing input data file in 2nd while loop
                    if (InputFileProcessing_ &&
                        (IoState_ == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit() || SetIdle_) &&
                        ((!ExecInputFileData() || AckPostExecInputFileData()) ||
                         (!CalcPtr_->ExecInputFileData() || CalcPtr_->AckPostExecInputFileData())))
                    {
                      Do2ndBreak_ = true;
                      break;
                    }
                  }
                  else
                    CalcPtr_->SetIoStateInMode(Mcalc_IOState::CALC_ERROR, true);

                  if (!InIoStatePendingMode(false) && ErrorStatePending())
                    ClearPendingErrors();
                }
                else if (!CalculatorBase::ShouldBreakFromProgram(CalcPtr_))
                {
                  SetHasCommandOutput(HasOutput_, 0, _Expression);
                  AccessCond_ = GiveIoAccessCondition(NULL, PLOTDONE_CHKSHOWN);
                  IoAccess_ = GiveIoAccessCondition(NULL, IOACCESS);
                  GiveBatchDataStateVars(CalcPtr_, InBatch_, NpBatch_,
                                         PgBatch_, GraphWaiting_, BatchSigSent_);

                  if (AccessCond_)
                  {
                    SetGraphPlotShown(true);

                    if (InBatch_)
                      CalcPtr_->SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
                    else
                    {
                      if (!HasErrors() && !HasDirective() && !QuitGraph())
                      {
                        FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
                        OutReady_ = HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
                      }

                      if (!HasErrors() && !HasDirective() && !QuitGraph() &&
                          !OutReady_ && HasOutput_ && FileNotEmpty_)
                      {
                        SetResultsShown(true);
                        CalcPtr_->SendIoState((Mcalc_IOState::GRAPH_OUTPUT |
                                               Mcalc_IOState::CALC_RESPONSE), true);
                      }
                    }
                  }
                  else if (IoAccess_)
                  {
                    if (!HasErrors() && !QuitGraph())
                    {
                      FileNotEmpty_ = IsOutputFileNotEmpty(Mcalc_IOState::CALC_RESPONSE);
                      OutReady_ = HasCommandOutput(Mcalc_IOState::OUTPUT_READY, &HasOutput_);
                    }

                    SetResultsShown(!HasErrors() && !QuitGraph() &&
                                    !OutReady_ && HasOutput_ && FileNotEmpty_);

                    AllowEmptyResponse()
                      ->SendCalcResponseSignal(0);
                  }
                }
              }
            }
          }
          else
            SetHasCommandOutput(HasOutput_, 0, _Expression);

          if (_Expression && !ExprCleared_)
          {
            ExprCleared_ = TRUE;
            _Expression->Clear();
            GraphOutSigSent_ = false;
          }

          // break 2nd while loop because we are not executing input file data
          if ((!ExecInputFileData() || AckPostExecInputFileData()) ||
              (!CalcPtr_->ExecInputFileData() || CalcPtr_->AckPostExecInputFileData()))
            break;

        }  // 2nd while loop: end
      }
      else
      {
        TickReadUserInputAttemptLoopGuard(1);

        while (!ReadUserInputAttemptLoopGuard())
        {
          PrevState_ = IoState_;
          SendClientPingSignal(0);

          if (!ClientIsDead())
          {
            IoState_ = WaitForClientIoState(IoState_,
                                            (Mcalc_IOState::PROCESS |
                                             Mcalc_IOState::BREAK_PROGRAM |
                                             Mcalc_IOState::CALC_HALT), false);

            if (IoState_ == Mcalc_IOState::PROCESS ||
                IoState_ == Mcalc_IOState::CALC_HALT ||
                IoState_ == Mcalc_IOState::BREAK_PROGRAM)
              ResetReadUserInputAttemptLoopGuard();
            else
              SetZeroReadUserInputAttemptLoopGuard();
          }
          else
          {
            if (CalcPtr_)
              CalcPtr_->SetShouldQuit(true);

            SetIoState(Mcalc_IOState::CALC_HALT);
            SetZeroReadUserInputAttemptLoopGuard();
            break;
          }
        }
      }

      // outer while loop break logic for 2nd while loop
      if (ExecInputFileData() && !AckPostExecInputFileData())
      {
        if (linesdone_ && Program_ && ProgCalc_)
        {
          Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;
          ProgCalc_ = Program_ ? Program_->GetCalculator():NULL;
          InputReq_ = GiveIoAccessCondition(NULL, INREQALLOWED);

          if (InputReq_ && InputDataFilePauseOption())
          {
            if (Program_ && IsUserPrompterProgram(Program_))
              Program_->SetMaxRetries(0);

            if (ProgCalc_)
              ProgCalc_->SetWaitForResponse(Mcalc_IOState::INPUT_REQUIRED);

            // For running a batch input file or program within a .in batch file
            //   BatchFile_ == true
            //   InProgram_ == true
            //   PrevProgram_ == false
            //   AndOptions_ == false
            if (InRunningProgram(true, true, false, false))
            {
              IoState_ = CalcPtr_->Bare_GetIoState(0);

              if (Program_ && !IsUserPrompterProgram(Program_))
              {
                if (!UsesSessionNum() ||
                    IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
                {
                  PromptAsyncUser(MSG_PROGRAM_ENDED, PROMPT_STOP_MSG);
                  PromptDone_ = true;
                }
              }
              else
              {
                if (!UsesSessionNum() ||
                    IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
                {
                  PromptAsyncUser(MSG_INPUT_FILE_ENDED, PROMPT_STOP_MSG);
                  PromptDone_ = true;
                }
              }

              IoState_ = CalcPtr_->Bare_GetIoState(0);
              Sent_ = BatchFileEndedSignalSent();

              if (IoState_ == Mcalc_IOState::INPUT_RECEIVED)
                if (!_InSpawnedCalc || _BatchExecLevel > 1)
                {
                  if (!BatchFileEndedSignalConfirmed(Sent_))
                  {
                    SetBatchFileEndedSignalConfirmed(false);
                    SendBatchFileEndedSignal(0);
                  }
                  else if (PromptDone_)
                  {
                    PromptDone_ = false;
                    SetBatchFileEndedSignalConfirmed(false);

                    if (IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
                    {
                      SetWriteToFileBatchLevel(true);
                      Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true);
                    }
                  }

                  if (Exec_BatchFileDonePending())
                    Exec_SetBatchFileDonePending(false);
                }

              if (PromptDone_ && BatchFileEndedSignalConfirmed(Sent_))
              {
                PromptDone_ = false;
                SetBatchFileEndedSignalConfirmed(false);

                if (IoState_ != Mcalc_IOState::BATCHFILE_ENDED_ACK)
                {
                  SetWriteToFileBatchLevel(true);
                  Bare_SetIoState(Mcalc_IOState::BATCHFILE_ENDED_ACK, true);
                }
              }

              if (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK)
                SetBatchFileEndedSignalPending(false);
            }
          }
          else if (!InAllGraphsFile() &&
                   !InputDataFilePauseOption() &&
                   Program_ && Program_->DisplayingParts())
          {
            if (Program_ && IsUserPrompterProgram(Program_))
            {
              Program_->SetClearOutputFiles(false, true);
              Program_->SetMaxRetries(0);
            }

            if (ProgCalc_)
            {
              AccessCond_ = GiveIoAccessCondition(NULL, PLOTDONE_NOSHOWCHK);
              GraphWaiting_ = GiveIoAccessCondition(NULL, WAITFORPLOT);

              if (AccessCond_)
              {
                ProgCalc_->SetWaitForResponse(Mcalc_IOState::GRAPH_OUTPUT |
                                              Mcalc_IOState::OUTPUT_READY);
                TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
              }
              else if (GraphWaiting_)
              {
                ProgCalc_->SetWaitForResponse(Mcalc_IOState::OUTPUT_READY);
                TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
              }
            }

            PromptAsyncUser(NULL, PROMPT_END_DISPLAY);
          }
        }

        if (QuitGraph() && !ResetGraphDone_)
        {
          Exec_SetGraphCondReset(true);
          ResetGraphDone_ = true;
          Halted_ = TRUE;
        }

        IoState_ = CalcPtr_->Bare_GetIoState(0);

        if (IoState_ == Mcalc_IOState::CALC_HALT)
          SetIdle_ = TRUE;
        else if (CalcPtr_->ShouldQuit())
          SetIoState(Mcalc_IOState::CALC_HALT);

        SetHasAnswer(FALSE);
        break;
      }

      if (Do2ndBreak_ || SetIdle_)
        break;
    }  // outer while loop: end

    if (SetIdle_)
    {
      SetIoState(Mcalc_IOState::IDLE_STATE);
      _PrevSetState = Mcalc_IOState::IDLE_STATE;
    }
  }
  else if (_InputExists && _InputFileLineSize)
  {
    if (SessionOption())
    {
      Integer SesNum_ = SessionNum();
      CreateDefaultFileNames(SesNum_);
      SetBatchFileEndedSignalSent(false);
      SetBatchFileEndedSignalAcked(false);
      SetBatchFileEndedSignalPending(false);

      linesdone_ = 0;
      GraphOutSigSent_ = false;
      AllLinesCompleted_ = FALSE;

      SetInputDataFilePauseOption(FALSE);
      SetNoPauseFileInput(TRUE);
      SetHasAnswer(FALSE);
      SetWasInBatchDataInput(TRUE);
      ResetProgressFile(_InputFileLineSize, true, true);
    }
    else
    {
      linesdone_ = 0;
      GraphOutSigSent_ = false;
      AllLinesCompleted_ = FALSE;
      PROGRESS_FILE = ::NewString(MCALC_PROGRESS_FILE);
      ELAPSEDTIME_FILE = ::NewString(MCALC_ELAPSEDTIME_FILE);

      SetInputDataFilePauseOption(FALSE);
      SetNoPauseFileInput(TRUE);
      SetHasAnswer(FALSE);
      SetWasInBatchDataInput(TRUE);
      ResetProgressFile(_InputFileLineSize, false, true);
    }

    while (readfile(&argc, argv, &arglist, cmdline))
    {
      if (Halted_ || _IoState == Mcalc_IOState::CALC_HALT)
      {
        if (_IoState == Mcalc_IOState::CALC_HALT)
        {
          SetSessionOptionOverride(true)
            ->SetIoState(Mcalc_IOState::IDLE_STATE);
          _PrevSetState = Mcalc_IOState::IDLE_STATE;
        }

        break;
      }
      else
        ExprCleared_ = FALSE;

      ConcatArglist(argc, arglist, true);
      sz = ::SafeStrLen(arglist[0]);
      temps_ = sz ? ::NewString(arglist[0]):NULL;
      temps_ = ::RemoveChar(temps_, " \n\r\t");

      if (sz == 0 || !strlen(temps_) || temps_[0] == EOF ||
          IsThisChar(arglist[0], 0, CALCCOMMENTLINE_STARTCHAR, 1) ||
          FunctionValidityChecker::IsNullSet(arglist[0]))
      {
        if (IsAtEof(GetInputFile()))
        {
          CalcPtr_->SetShouldQuit(1);
          Halted_ = TRUE;
        }

        ::RawDeleteArray(temps_);
        temps_ = NULL;
        continue;
      }

      PrevCalc_ = CalcPtr_;
      CalcPtr_ = CalcPtr_->GetCalcType();
      if (!CalcPtr_) CalcPtr_ = PrevCalc_;

      if (AnswerMode_ == ALTBASE_MODE ||
          AnswerMode_ == LITERAL_MODE ||
          NumberBase() != 10)
        RestoreNumberBase();

      // clear previously detected errors and output data types
      ClearOutputCondition(CalcPtr_);
      ClearOutputDataType();
      ClearOutputDataErrorCode();
      CalcPtr_->ClearError();
      ::RawDeleteArray(temps_);

      _Expression = CalcPtr_->TopSubExprStack();
      GraphCmdFound_ = false;

      if (ResultsShown())
      {
        AnsModeChanged_ = AnsModeChanged_ &&
                          OldMode_ != AnswerMode() && ModeFinalized();

        // ClearAnswerStr(AnsModeChanged_, OldMode_);
        ClearAnswerStr(false, OldMode_);
      }
      else
        ClearResultsShown();

      if (AnsModeChanged_)
      {
        PrevAnswerMode_ = AnswerMode_;
        AnsModeChanged_ = false;
      }

      if (_Expression)
      {
        _Expression->SetExpression(arglist[0]);
        _Expression->SetCalculator(CalcPtr_);
        _Expression->CheckIfValidExpression();
        _Expression->FindFunctionCalls();

        GraphCmdFound_ = _Expression->GraphCmdWasFound();
        ExecCmdFound_ = _Expression->ExecCmdWasFound();
        QuitSetByUser_ = QuitGraph();
      }
      else
      {
        GraphCmdFound_ = false;
        ExecCmdFound_ = false;
      }

      if (_IoState == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit())
      {
        CalcPtr_->SetShouldQuit(1);
        ResultStr_ = "";
        Halted_ = TRUE;
      }
      else if (_Expression)
      {
        ResultStr_ = _Expression->Evaluate();
        PrgExecName_ = _Expression->GetProgramName();
        AnswerMode_ = _Expression->GetAnswerMode();
        AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;

        if (AnsModeChanged_)
          OldMode_ = PrevAnswerMode_;
        else
          PrevAnswerMode_ = AnswerMode_;
      }

      RetOutLen_ = SafeStrLen(ResultStr_);
      AccessCond_ = GiveIoAccessCondition(CalcPtr_, PLOTDONE_NOSHOWCHK, true);
      GraphReady_ = SessionOption() && !CalcPtr_->HasErrors() && AccessCond_;

      if (!InProgramMode(true))
      {
        if (GraphReady_ && !GraphOutSigSent_)
        {
          SetHasAnswer(TRUE);
          SetSessionOptionOverride(true)
            ->SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
          GraphOutSigSent_ = true;
          SetGraphPlotShown(true);
        }
        else
        {
          ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
          GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                         GraphOperationOptions()->InAppliedFunctionGraph();
          HasOutput_ = !ErrorsFound_ &&
                       (_Expression && _Expression->HasAnswer());

          if (GraphOutput_ && !HasOutput_)
            SetHasAnswer(true);

          if (HasOutput_ || GraphOutput_)
          {
            SetHasCommandOutput(HasOutput_ || GraphOutput_, 0, _Expression);
            _Expression->ShowResults();
          }
        }
      }
      else
      {
        if (GraphReady_ && !GraphOutSigSent_)
        {
          SetHasCommandOutput(true);
          SetSessionOptionOverride(true)
            ->SendIoState(Mcalc_IOState::GRAPH_OUTPUT, true);
          GraphOutSigSent_ = true;
          SetGraphPlotShown(true);
        }
        else
        {
          ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
          GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                         GraphOperationOptions()->InAppliedFunctionGraph();
          HasOutput_ = !ErrorsFound_ &&
                       (_Expression && _Expression->HasCommandOutput() &&
                        RetOutLen_);

          if (GraphOutput_ && !HasOutput_)
            SetHasAnswer(true);

          SetHasCommandOutput(HasOutput_ || GraphOutput_, 0, _Expression);
        }
      }

      if (_Expression && !ExprCleared_)
      {
        ExprCleared_ = TRUE;
        _Expression->Clear();
        GraphOutSigSent_ = true;
      }

      if (!AllLinesCompleted_)
      {
        ++linesdone_;
        UpdateProgressFile(_InputFileLineSize, linesdone_,
                           SessionOption(), &AllLinesCompleted_);
      }
    }

    if (SessionOption())
    {
      IoState_ = SetSessionOptionOverride(true)
                   ->Bare_GetIoState(0);

      if (IoState_ == Mcalc_IOState::PROGRESS_READY)
      {
        IoState_ = WaitForClientInFileProgressStates(IoState_, &FetchLimitReached_, IoStateForced());
        SetSessionOptionOverride(true);
        UseMicroSecDelay(!FetchLimitReached_ ||
                         CurrentIoState() == Mcalc_IOState::INFILE_PROGRESS_ACK);

        if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::PROGRESS_READY)
        {
          CalcPtr_
            ->SetSessionOptionOverride(true)
            ->SetIoStateForced(true)
            ->SetIoState(Mcalc_IOState::INFILE_PROGRESS_ACK, true);
          IoState_ = Mcalc_IOState::INFILE_PROGRESS_ACK;
        }
        else if (CurrentIoState() == Mcalc_IOState::INFILE_PROGRESS_ACK)
          IoState_ = Mcalc_IOState::INFILE_PROGRESS_ACK;
      }

      sprintf(msgbuf, MSG_INPUT_FILE_PROCESSED, DATA_INPUT_FILE, DATA_OUTPUT_FILE);
      SetSessionOptionOverride(true);
      TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
      DisplayMessage(GetGuiOutputFile(), msgbuf);
      CloseGuiOutputFile(true, true);

      SetSessionOptionOverride(true);
      SendOutputReadySignal(0);
      SetHasAnswer(FALSE);
      ProgramRan_ = TRUE;
      IoState_ = SetSessionOptionOverride(true)
                   ->Bare_GetIoState(0);

      #if ((IMPLEMENT_KEEP_ALIVE)|(IDLE_RESPONSE_ONLY_POLL))
      if (!_NoPolling && _PollClientMgr &&
          _PollClientMgr->ResetWhenNotRequired(true)
                        ->ServerReceiveRequired())
      {
        Sleep_ = _PollClientMgr->WaitingForClientResponse() ? 1:0;
        _PollClientMgr->ReceiveKeepAlivePoll(Sleep_);
        #if CALCLIB_TESTMOCKCLIENT
          MockClientAck(IsServerStates(_IoState));
        #endif
        IoState_ = SetSessionOptionOverride(true)
                     ->Bare_GetIoState(!Sleep_);
      }
      #endif

      if (IoState_ == Mcalc_IOState::PROGRESS_READY)
      {
        IoState_ = WaitForClientInFileProgressStates(IoState_, &FetchLimitReached_, IoStateForced());
        SetSessionOptionOverride(true);
        UseMicroSecDelay(!FetchLimitReached_ ||
                         CurrentIoState() == Mcalc_IOState::INFILE_PROGRESS_ACK);

        if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::PROGRESS_READY)
        {
          CalcPtr_
            ->SetSessionOptionOverride(true)
            ->SetIoStateForced(true)
            ->SetIoState(Mcalc_IOState::INFILE_PROGRESS_ACK, true);
          IoState_ = Mcalc_IOState::INFILE_PROGRESS_ACK;
        }
        else if (CurrentIoState() == Mcalc_IOState::INFILE_PROGRESS_ACK)
          IoState_ = Mcalc_IOState::INFILE_PROGRESS_ACK;
      }

      if (IoState_ == Mcalc_IOState::OUTPUT_FETCHED ||
          IoState_ == Mcalc_IOState::INFILE_PROGRESS_ACK)
        EndOfBatchFileProcessing();
    }
    else
      SetWasInBatchDataInput(FALSE);
  }

  if (QuitGraph() && !ResetGraphDone_)
  {
    Exec_SetGraphCondReset(true);
    ResetGraphDone_ = true;
  }

  if (oldargptr && CmdHistoryCancelled_ && !InProgramMode(true))
  {
    arglist[0] = oldargptr;
    oldargptr = NULL;
    CmdHistoryCancelled_ = FALSE;
  }

  freearglist(&arglist, argc); // freeing argument list used for file input
  freememory(&operands);       // freeing operands list

  if (!ExecInputFileData() || AckPostExecInputFileData())
    closefiles();
  else
    closeIOfiles();

  #if CALCLIB_DEBUG2
    fputs("Leaving: FileInput\n", logfile);
  #endif

  return ProgramRan_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::EvalPrgExpression(char* argstr, CalculatorBase* CalcPtr_)
{
  CalculatorBase* PrevCalc_;
  bool HasCmdOut_ = false;
  bool HasGraphOut_ = false;
  bool ErrorsFound_ = false;
  bool NullMode_ = false;
  int IoState_ = 0;
  int ErrorCnt_ = 0;
  int ErrorVal_ = 0;
  int ErrMsgCode_ = 0;
  int OldMode_ = 0;
  int AnswerMode_ = FLOATINGPOINT_MODE;
  int PrevAnswerMode_ = FLOATINGPOINT_MODE;
  bool GraphCmdFound_ = false;
  bool FetchLimitReached_ = false;
  bool AnsModeChanged_ = false;
  ChrString QuestionStr_;
  ChrString Answer_;
  char* temps_ = NULL;
  temps_ = (char*)allocmem(::SafeStrLen(argstr) + 1, sizeof(char), temps_);
  char* start_ = temps_;

  ::SafeStrCpy(temps_, argstr);
  RemovePadding(temps_, " \t\n\r");

  if (!::SafeStrLen(temps_))
  {
    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 1;
  }
  else if (!CommandHistoryMode() && icasestrcomp(temps_, QUIT_STR))
  {
    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 0;
  }

  CreateNewSubExpr();

  if (::SafeStrLen(temps_))
  {
    PrevCalc_ = CalcPtr_;
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;

    if (AnswerMode_ == ALTBASE_MODE ||
        AnswerMode_ == LITERAL_MODE ||
        NumberBase() != 10)
      RestoreNumberBase();

    // clear previously detected errors and output data types
    ClearOutputCondition(CalcPtr_);
    ClearOutputDataType();
    ClearOutputDataErrorCode();
    CalcPtr_->ClearError();

    SetPlotGraph(true, 0);

    _Expression = CalcPtr_->TopSubExprStack();
    CalcPtr_->ClearOutputToSignal();
    CalcPtr_->SetInputPromptWarning(false);
    GraphCmdFound_ = false;

    if (ResultsShown())
    {
      AnsModeChanged_ = AnsModeChanged_ &&
                        OldMode_ != AnswerMode() && ModeFinalized();

      // ClearAnswerStr(AnsModeChanged_, OldMode_);
      ClearAnswerStr(false, OldMode_);
    }
    else
      ClearResultsShown();

    if (AnsModeChanged_)
    {
      PrevAnswerMode_ = AnswerMode_;
      AnsModeChanged_ = false;
    }

    if (_Expression)
    {
      QuestionStr_ = temps_;
      QuestionStr_ += "\n>> ";

      _Expression->SetExpression(temps_);
      _Expression->SetCalculator(CalcPtr_);
      _Expression->CheckIfValidExpression();
      _Expression->FindFunctionCalls();
      GraphCmdFound_ = _Expression->GraphCmdWasFound();

      _Expression->Evaluate();

      AnswerMode_ = _Expression->GetAnswerMode();
      AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;

      if (AnsModeChanged_)
        OldMode_ = PrevAnswerMode_;
      else
        PrevAnswerMode_ = AnswerMode_;
    }

    if (_IoState == Mcalc_IOState::CALC_HALT ||
        CalcPtr_->ShouldQuit())
      CalcPtr_->SetShouldQuit(1);

    ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
    HasGraphOut_ = GraphCmdFound_ && !ErrorsFound_ &&
                   GraphOperationOptions()->InAppliedFunctionGraph();
    HasCmdOut_ = !ErrorsFound_ &&
                 ((_Expression && (_Expression->HasCommandOutput() ||
                   _Expression->HasAnswer())) || HasGraphOut_);

    SetHasCommandOutput(HasCmdOut_, 0, _Expression);
    if (HasGraphOut_)
      SetHasAnswer(true);

    if (_Expression)
    {
      AnswerMode_ = _Expression->GetAnswerMode();
      Answer_ =
        (AnswerMode_ == CalculatorBase::FRACTION_MODE) ? FractionStr():
        (AnswerMode_ == CalculatorBase::LITERAL_MODE ||
         AnswerMode_ == CalculatorBase::ALTBASE_MODE) ? LiteralStr():FloatStr();

      if (!Answer_.strlen())
      {
        Answer_ = _Expression->GetAnswer();
        NullMode_ = true;
      }

      _Expression->Clear();
      PopSubExprStack(TRUE);

      if (AnswerMode_ && Answer_.strlen())
      {
        SetAnswerMode(AnswerMode_);

        if (NullMode_)
          SetLiteralStr(Answer_.c_str());
        else if (AnswerMode_ == CalculatorBase::FRACTION_MODE)
          SetFractionStr(Answer_.c_str());
        else if (AnswerMode_ == CalculatorBase::LITERAL_MODE ||
                 AnswerMode_ == CalculatorBase::ALTBASE_MODE)
          SetLiteralStr(Answer_.c_str());
        else
          SetFloatStr(Answer_.c_str());
      }

      if (!InIoStatePendingMode(false) && InAsyncMode())
      {
        if (CalcPtr_->HasErrors() && ErrorStatePending() && Bare_GetIoState(0) != Mcalc_IOState::CALC_ERROR)
          SetIoState(Mcalc_IOState::CALC_ERROR, true);

        ClearPendingErrors();
      }

      if (_Expression && CalcPtr_->HasErrors() && InIoStatePendingMode(false))
      {
        if (CalcPtr_->GetErrorVal() == Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS)
        {
          ErrorCnt_ = -1;
          ErrorVal_ = 0;
          ErrMsgCode_ = 0;

          SetMultiErrorVector(OutputDataErrorCode(), MakeOutputErrorsMaxSel(),
                              MakeOutputErrorsErrVals(), Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS);

          while (ErrMsgCode_ = FindMultiErrors(ErrorCnt_, ErrorVal_))
          {
            SetError(ErrMsgCode_, true);
            DisplayErrorMessageForCode(GetOutputFile(), GetErrorVal());

            FetchAndShowCurrentError(QuestionStr_);
            CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

            if (InputDataFilePauseOption() && InAsyncMode())
            {
              IoState_ = Bare_GetIoState(0);
              IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
              UseMicroSecDelay(!FetchLimitReached_ ||
                               CurrentIoState() == Mcalc_IOState::CALC_ERROR);

              if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
              {
                CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
                IoState_ = Mcalc_IOState::CALC_ERROR;
              }
              else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
                IoState_ = Mcalc_IOState::CALC_ERROR;
            }

            ClearError();

            if (PostBreakResponseSent())
            {
              // clear previously detected errors and output data types
              ClearOutputCondition(CalcPtr_);
              ClearOutputDataType();
              ClearOutputDataErrorCode();
              break;
            }
            else
              CalculatorBase::ShouldBreakFromProgram(CalcPtr_);
          }

          if (ErrorStatePending())
            ClearPendingErrors();
        }
        else
        {
          FetchAndShowCurrentError(QuestionStr_);
          CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

          if (InputDataFilePauseOption() && InAsyncMode())
          {
            IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
            UseMicroSecDelay(!FetchLimitReached_ ||
                             CurrentIoState() == Mcalc_IOState::CALC_ERROR);

            if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
            {
              CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
              IoState_ = Mcalc_IOState::CALC_ERROR;
            }
            else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
              IoState_ = Mcalc_IOState::CALC_ERROR;
          }

          if (PostBreakResponseSent())
            ResetPostBreakResponse();
          else
            CalculatorBase::ShouldBreakFromProgram(CalcPtr_);

          if (ErrorStatePending())
            ClearPendingErrors();
        }
      }
    }
  }

  _MemDel->DelayedDeleteCstr(start_, STOREMEM);
  int ShouldQuit_ = CalcPtr_ ? CalcPtr_->ShouldQuit():0;

  return !ShouldQuit_;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::EvalExpression(char* argstr, CalculatorBase* CalcPtr_)
{
  Boolean AtTopExec_ = FALSE;
  Boolean EntryMade_ = FALSE;
  Boolean Repeat_ = FALSE;
  Boolean Valid_ = FALSE;
  Boolean Halted_ = FALSE;
  Boolean HasOutput_ = FALSE;
  Boolean HasExprAns_ = FALSE;
  Boolean GraphOutput_ = FALSE;
  Boolean ErrorsFound_ = FALSE;
  Boolean IntroDone_ = FALSE;
  Boolean CmdHistEntrySelected_ = FALSE;
  Boolean CmdHistChoiceEntered_ = FALSE;
  Boolean CmdHistoryConfirmed_ = FALSE;
  Boolean CmdHistoryCancelled_ = FALSE;
  Boolean ShouldQuit_ = FALSE;
  Boolean ExprCleared_ = FALSE;
  Boolean RunExec_ = !InAsyncMode() && ExecInputFileData() &&
                     !AckPostExecInputFileData() &&
                     InputDataFileExecLock() != EXECFILE_LOCKED;
  CalculatorBase* PrevCalc_;

  long ProgID_ = GiveProgramID();
  CalcProgram* Program_ = InProgramMode(true) ?
                             ((RunExec_ && ProgID_) ?
                                FindProgramFromID(ProgID_, true):
                                ActiveProgram()):NULL;

  int ClearOut_ = Program_ ? Program_->ShouldClearOutputFiles():TRUE;
  int hlindex_;
  int hllength_;
  int EntryIndex_ = 0;
  int IoState_ = 0;
  int ErrorCnt_ = 0;
  int ErrorVal_ = 0;
  int ErrMsgCode_ = 0;
  int RetOutLen_ = 0;
  int OldMode_ = 0;
  int AnswerMode_ = FLOATINGPOINT_MODE;
  int PrevAnswerMode_ = FLOATINGPOINT_MODE;
  int Sleep_ = 0;
  bool GraphCmdFound_ = false;
  bool FetchLimitReached_ = 0;
  bool AckPostCond_ = false;
  bool AsyncStartCond_ = false;
  bool AnsModeChanged_ = false;
  bool ModeChangesProcessed_ = false;
  char Choice_ = 0;
  size_t sz;
  size_t len16 = strlen("cmdhistoryentry(");
  size_t len23 = strlen("cmdhistoryentry(cancel)");
  const char* PrgExecName_ = NULL;
  const char* CmdHistEndPt_ = NULL;
  const char* CmdHistDelimPt_ = NULL;
  const char* ResultStr_ = NULL;
  char* temps_ = NULL;
  temps_ = (char*)allocmem(::SafeStrLen(argstr) + 1, sizeof(char), temps_);
  char* start_ = temps_;
  char* buffer = NULL;
  char* oldargptr = NULL;
  char* exprterm_ = NULL;
  ChrString QuestionStr_;

  #if CALCLIB_DEBUG7
    bool Debug_ = true;
  #else
    bool Debug_ = false;
  #endif

  PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = PrevCalc_;

  ::SafeStrCpy(temps_, argstr);
  RemovePadding(temps_, " \t\n\r");

  if (!InAsyncMode() && _SavedConIO != 0)
  {
    #if USE_STDIO_ONLY
      _StdInput = _StdOutput = TRUE;
      _ConsoleInput = _ConsoleOutput = false;
    #else
      if (_SavedConIO == 1)          // stdio --> conio
        _ConsoleInput = _ConsoleOutput = false;
      else if (_SavedConIO == -1)    // conio --> stdio
        _ConsoleInput = _ConsoleOutput = true;
    #endif

    _SavedConIO = 0;
  }

  if (RunExec_ && ::SafeStrLen(temps_))
  {
    Mcalc_Operand** operands;

    char tempbuf[8];
    char msgbuf[256];

    char** argv;
    char** arglist;
    int argc = 0;
    int cmdline;
    int linesdone_ = 0;

    argv = (char**)CalculatorBase::allocmem(5, sizeof(char*), argv);
    ::memset(argv, 0, 5 * sizeof(char*));

    argv[argc++] = NULL;
    argv[argc++] = ::NewString(INPUTFILE_SWITCH);
    argv[argc++] = ::NewString(temps_);

    if (InputDataFileExecLock() == EXECFILE_KEY_SET)
      SetInputDataFileExecLock(EXECFILE_LOCKED);

    getfiles(&argc, argv, &cmdline);   // get files for the program
    initarrays(&operands, &arglist);   // initialize variables

    if (InputDataFileExecLock() == EXECFILE_LOCKED)
    while (!Halted_ && readfile(&argc, argv, &arglist, cmdline))
    {
      ConcatArglist(argc, arglist, true);
      if (IsThisChar(arglist[0], 0, CALCCOMMENTLINE_STARTCHAR, 1) ||
          FunctionValidityChecker::IsNullSet(arglist[0]))
        continue;

      PrevCalc_ = CalcPtr_;
      CalcPtr_ = CalcPtr_->GetCalcType();
      if (!CalcPtr_) CalcPtr_ = PrevCalc_;

      if (AnswerMode_ == ALTBASE_MODE ||
          AnswerMode_ == LITERAL_MODE ||
          NumberBase() != 10)
        RestoreNumberBase();

      // clear previously detected errors and output data types
      ClearOutputCondition(CalcPtr_);
      ClearOutputDataType();
      ClearOutputDataErrorCode();
      CalcPtr_->ClearError();

      if (ResultsShown())
      {
        AnsModeChanged_ = AnsModeChanged_ &&
                          OldMode_ != AnswerMode() && ModeFinalized();

        // ClearAnswerStr(AnsModeChanged_, OldMode_);
        ClearAnswerStr(false, OldMode_);
      }
      else
        ClearResultsShown();

      if (AnsModeChanged_)
        PrevAnswerMode_ = AnswerMode_;

      if (!::SafeStrLen(arglist[0]))
        continue;

      if (!IntroDone_ && Program_)
      {
        Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;

        if (InputDataFilePauseOption())
        {
          if (!InAllGraphsFile() || GraphFilePause())
            SendToSelectedOutput(MSG_ENTER_TO_QUIT);
          else
          {
            PrgExecName_ = _ExecuteProgram ? _ExecuteProgram->Name():
                                             DATA_INPUT_FILE;
            sprintf(msgbuf, MSG_PLOTTING_NUM_FUNCTIONS,
                    _NumGraphFunctions, PrgExecName_);
            SendToSelectedOutput(msgbuf);
            PrgExecName_ = NULL;
          }

          IntroDone_ = TRUE;

          if (Program_ && IsUserPrompterProgram(Program_))
            Program_->SetMaxRetries(0);
        }
        else
        {
          IntroDone_ = TRUE;

          if (Program_ && IsUserPrompterProgram(Program_))
          {
            Program_->SetClearOutputFiles(true, false);
            Program_->SetMaxRetries(CalcProgram::MAXRETRIES);
          }
        }
      }

      _Expression = CalcPtr_->TopSubExprStack();
      CalcPtr_->ClearOutputToSignal();
      CalcPtr_->SetInputPromptWarning(false);
      GraphCmdFound_ = false;

      if (_Expression)
      {
        _Expression->SetExpression(arglist[0]);
        _Expression->SetCalculator(CalcPtr_);
        _Expression->CheckIfValidExpression();
        _Expression->FindFunctionCalls();
        GraphCmdFound_ = _Expression->GraphCmdWasFound();
      }

      if (_IoState == Mcalc_IOState::CALC_HALT || CalcPtr_->ShouldQuit())
      {
        CalcPtr_->SetShouldQuit(1);
        ResultStr_ = "";
        Halted_ = TRUE;
      }
      else if (_Expression)
      {
        ExprCleared_ = FALSE;
        ResultStr_ = _Expression->Evaluate();

        PrgExecName_ = _Expression->GetProgramName();
        AnswerMode_ = _Expression->GetAnswerMode();
        AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;

        if (AnsModeChanged_)
          OldMode_ = PrevAnswerMode_;
        else
          PrevAnswerMode_ = AnswerMode_;
      }

      if (!InProgramMode(true))
      {
        ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
        RetOutLen_ = SafeStrLen(ResultStr_);
        GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                       GraphOperationOptions()->InAppliedFunctionGraph();
        HasExprAns_ = !ErrorsFound_ &&
                      ((_Expression && _Expression->HasAnswer()) ||
                       GraphOutput_);

        if (HasExprAns_)
        {
          HasOutput_ = !ErrorsFound_ &&
                       (_Expression && (_Expression->HasCommandOutput() ||
                        _Expression->HasAnswer()) && RetOutLen_);

          SetHasCommandOutput(HasOutput_ || GraphOutput_, 0, _Expression);
          if (GraphOutput_)
            SetHasAnswer(true);

          _Expression->ShowResults();
          ++linesdone_;

          if (InputDataFilePauseOption() && _Expression->HasCommandOutput() &&
              (CalcPtr_->StdInput() || CalcPtr_->UsesConsoleInput()))
          {
            GetFromSelectedInput(tempbuf, 8);
            Halted_ = tempbuf[0] && toupper(tempbuf[0]) == 'Q';
          }
        }
      }
      else
      {
        ++linesdone_;

        ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
        RetOutLen_ = SafeStrLen(ResultStr_);
        GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                       GraphOperationOptions()->InAppliedFunctionGraph();
        HasOutput_ = !ErrorsFound_ &&
                     (_Expression && (_Expression->HasCommandOutput() ||
                      _Expression->HasAnswer()) && RetOutLen_);

        SetHasCommandOutput(HasOutput_ || GraphOutput_, 0, _Expression);
        if (GraphOutput_)
          SetHasAnswer(true);
      }

      if (_Expression && !ExprCleared_)
      {
        ExprCleared_ = TRUE;
        _Expression->Clear();
      }
    }

    _MemDel->DelayedDeleteCstr(argv[2], STOREMEM);
    argv[2] = NULL;

    _MemDel->DelayedDeleteCstr(argv[1], STOREMEM);
    argv[1] = NULL;

    _MemDel->DelayedDeleteVoidp((void*)argv, STOREMEM);
    argv = NULL;

    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    start_ = NULL;

    freearglist(&arglist, argc); // freeing argument list used for file input
    freememory(&operands);       // freeing operands list
    closeIOfiles();
    restorefiles();

    if (linesdone_ && Program_)
    {
      Program_ = (InProgramMode(true) && ProgID_) ? FindProgramFromID(ProgID_, true):NULL;

      if (InputDataFilePauseOption())
      {
        SetInputDataFilePauseOption(TRUE);

        if (Program_ && IsUserPrompterProgram(Program_))
          Program_->SetMaxRetries(0);

        if (CalcPtr_->StdInput() || CalcPtr_->UsesConsoleInput())
        {
          SendToSelectedOutput(MSG_INPUT_FILE_ENDED);
          GetFromSelectedInput(tempbuf, 8);
        }
      }
      else
      {
        SetInputDataFilePauseOption(TRUE);

        if (Program_ && IsUserPrompterProgram(Program_))
        {
          Program_->SetClearOutputFiles(false, true);
          Program_->SetMaxRetries(0);
        }
      }
    }

    #if CALCLIB_TESTASYNCMODE
      AckPostCond_ = AckPostExecInputFileData();
    #else
      AckPostCond_ = StdInput() && AckPostExecInputFileData();
    #endif

    if (AckPostCond_ && !PostExecResetProcessDone())
    {
      UseMicroSecDelay(true);
      Sleep_ = (!InputDataFilePauseOption() ||
                NoPauseFileInput()) ? 1:0;
      IoState_ = Bare_GetIoState(Sleep_);  // IOstate delay 1 millisecond after end of input file execution

      SetNoPauseFileInput(FALSE);
      SetInputDataFilePauseOption(TRUE);

      ResetAckPostExecInputFileData();
      ResetExecInputFileData();
      SetInputDataFileExecLock(EXECFILE_UNLOCKED);

      _IoStatePtr->ResetAtEndOfProcess(IoState_);
      SetPostExecResetProcessDone(TRUE);

      if (BatchFileEndedSignalPending())
        ReCheckEndBatchSignal();

      if (QuitGraph())
      {
        CalcPtr_->SetBatchFileEndedSignalPending(false);
        CalcPtr_->SetBatchFileEndedSignalSent(false);
        CalcPtr_->SetBatchFileEndedSignalAcked(false);
        CalcPtr_->SetClientAckedDoneToGraphOutput(false);
        CalcPtr_->SetResponseWasCompleted(false);
        CalcPtr_->SetGraphOutputWasSent(FALSE);
        CalcPtr_->SetWasInBatchDataInput(FALSE);
      }

      Exec_ResetQuitGraphFlags();
      SetInputDataFilePauseOption(TRUE);  // default is true
      SetWasInBatchDataInput(FALSE);
    }

    ShouldQuit_ = CalcPtr_->ShouldQuit();
    return !ShouldQuit_;
  }

  // Inspect command prompt entered input for any index specified command
  // history list entry that is selected by the user and extract relevant
  // data from the history command
  //
  if (CommandHistoryMode() && !InProgramMode(true) && Debug_ && ::SafeStrLen(temps_))
  {
    CmdHistChoiceEntered_ = icasestrcompn(temps_, "cmdhistoryentry(", len16);
    CmdHistEndPt_ = strchr(temps_, ')');

    if (CmdHistEndPt_)
    {
      sz = CmdHistEndPt_ - temps_;
      CmdHistDelimPt_ = strchr(&temps_[sz], CMDHISTENTRY_SEPCHAR);
      CmdHistoryConfirmed_ = TRUE;
      DisplayCommandHistoryList();
    }
    else
    {
      CmdHistDelimPt_ = NULL;
      CmdHistoryConfirmed_ = FALSE;
    }

    if (!CmdHistChoiceEntered_ || !CmdHistEndPt_ || !CmdHistDelimPt_)
    {
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);
    }
  }
  else if (!InProgramMode(true) && ::SafeStrLen(temps_))
  {
    CmdHistChoiceEntered_ = icasestrcompn(temps_, "cmdhistoryentry(", len16);
    CmdHistEndPt_ = strchr(temps_, ')');

    if (CmdHistEndPt_)
    {
      sz = CmdHistEndPt_ - temps_;
      CmdHistDelimPt_ = strchr(&temps_[sz], CMDHISTENTRY_SEPCHAR);
    }
    else
      CmdHistDelimPt_ = NULL;

    if (!CmdHistDelimPt_)
    {
      CmdHistoryConfirmed_ = FALSE;
      CmdHistoryCancelled_ = FALSE;
      CmdHistChoiceEntered_ = FALSE;
      CmdHistEndPt_ = CmdHistDelimPt_ = NULL;

      if (!StdOutput() && !StdInput())
      {
        SetHistoryListMode(FALSE);
        SetHistoryListIndex(-1);
      }
    }
  }

  if (!InProgramMode(true) && ::SafeStrLen(temps_) && icasestrcompn(temps_, "cmdhistoryentry(cancel)", len23) &&
      CmdHistChoiceEntered_ && CmdHistEndPt_ && CmdHistDelimPt_ &&
      temps_ && (CmdHistDelimPt_+1))
  {
    ::memmove(temps_, CmdHistDelimPt_+1, ::SafeStrLen(CmdHistDelimPt_));
    start_ = temps_;
    CmdHistEndPt_ = strchr(argstr, ')');

    if (CmdHistEndPt_)
    {
      sz = CmdHistEndPt_ - argstr;
      oldargptr = argstr;
      argstr = strchr(&argstr[sz], CMDHISTENTRY_SEPCHAR);

      if (argstr)
        argstr++;
      else
      {
        argstr = oldargptr;
        oldargptr = NULL;
      }
    }
    else
      oldargptr = NULL;

    if ((CommandHistoryMode() && Debug_) || (!StdOutput() && !StdInput()))
    {
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);
    }

    CmdHistChoiceEntered_ = FALSE;
    CmdHistoryConfirmed_ = FALSE;
    CmdHistoryCancelled_ = CmdHistEndPt_ != NULL &&
                           oldargptr != NULL;

    CmdHistEndPt_ =
    CmdHistDelimPt_ = NULL;

    if (::SafeStrLen(argstr))
      RemovePadding(temps_, " \t\n\r");
  }
  else if (!InProgramMode(true) && !CmdHistoryConfirmed_ && CmdHistDelimPt_)
  {
    CmdHistoryConfirmed_ = FALSE;
    CmdHistoryCancelled_ = FALSE;
    CmdHistChoiceEntered_ = FALSE;
    CmdHistEndPt_ = CmdHistDelimPt_ = NULL;

    if ((CommandHistoryMode() && Debug_) || (!StdOutput() && !StdInput()))
    {
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);
    }
  }

  // Inspect command prompt entered input for command history list related
  // commands and extract relevant data from the history command
  //
  if (!InProgramMode(true) && StdOutput() && icasestrcomp(temps_, "stdio"))
  {
    // switch to standard input/output mode
    #if USE_STDIO_ONLY
      _StdInput = _StdOutput = TRUE;
      _ConsoleInput = _ConsoleOutput = false;
    #else
      _ConsoleInput = _ConsoleOutput = true;
    #endif

    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 1;
  }
  else if (!InProgramMode(true) && StdOutput() && icasestrcomp(temps_, "conio"))
  {
    // switch to direct console input/output mode
    #if USE_STDIO_ONLY
      _StdInput = _StdOutput = TRUE;
      _ConsoleInput = _ConsoleOutput = false;
    #else
      _ConsoleInput = _ConsoleOutput = true;
    #endif

    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 1;
  }
  else if (IsWsFreeStrEqual(temps_, "clearhistory") && !InProgramMode(true) && !CommandHistoryMode())
  {
    // Clear command history list and erase command history file
    //
    if (CommandHistoryLength() || CommandHistoryIndex() >= 0)
      ClearCommandHistoryFile();

    SetHistoryListMode(FALSE);
    SetHistoryListIndex(-1);
    SetHistoryListLength(0);

    TieOutputToSignal(Mcalc_IOState::OUTPUT_READY);
    DisplayMessage(GetOutputFile(false, false, !NoPauseFileInput()), MSG_COMMAND_HISTORY_CLEARED);
    CloseGuiOutputFile();

    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 1;
  }
  else if (icasestrcomp(temps_, "history") && !InProgramMode(true))
  {
    // Show command history list entries to user
    //
    if (!CommandHistoryLength() || !ShowCmdHistoryEntry())
      SendToSelectedOutput(MSG_COMMAND_HISTORY_NO_ENTRIES);

    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    return 1;
  }
  else if (!InProgramMode(true) &&
           CmdHistoryConfirmed_ && !CmdHistoryCancelled_ &&
           CmdHistChoiceEntered_ && CmdHistEndPt_ && CmdHistDelimPt_)
  {
    // Process index specified command history list entry that is
    // selected by the user in asynchronous input/output mode
    //
    sz = CmdHistEndPt_ - temps_;
    temps_[sz] = 0;
    EntryIndex_ = atoi(&temps_[len16]);
    temps_[sz] = ')';
    EntryIndex_ = CommandHistoryLength() - EntryIndex_ - 1;

    if (0 <= EntryIndex_ && EntryIndex_ < CommandHistoryLength())
    {
      SetHistoryListIndex(EntryIndex_);
      hlindex_ = CommandHistoryIndex();

      Valid_ = HistoryListElementValid(hlindex_) == CMDENTRY_VALID;
      sz = size_t(HistoryListElementSize(hlindex_));

      if (Valid_ && sz && ::SafeStrLen(HistoryListElementStr(hlindex_)))
      {
        buffer = (char*)CalculatorBase::allocmem(::SafeStrLen(temps_), sizeof(char), buffer);
        sz = CmdHistDelimPt_ - temps_;

        ::SafeStrCpy(buffer, &temps_[sz+1]);
        RemovePadding(buffer, " \t\n\r");
        SetHistoryListEntry(buffer, FALSE);

        CmdHistEntrySelected_ = TRUE;
        Choice_ = 'Y';

        if (Debug_ && !icasestrcomp(HistoryListElementStr(hlindex_), buffer))
          SendToSelectedOutput(MSG_COMMAND_HISTORY_MISMATCHED);
      }
    }

    if (!buffer || Choice_ != 'Y')
    {
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);

      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      return 1;
    }
  }
  else if (!::SafeStrLen(temps_))
  {
    if (!CommandHistoryMode())
    {
      // return to user command prompt if no entered data detected
      //
      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      return 1;
    }
    else if (StdOutput() && !InProgramMode(true) && CommandHistoryIndex() >= 0)
    {
      // Show next command history list entry if in history list mode
      // and command history list index value is non-negative
      //
      ShowCmdHistoryEntry();
      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      return 1;
    }
  }
  else if (!CommandHistoryMode() && icasestrcomp(temps_, QUIT_STR))
  {
    // return and quit user command prompt if "quit" command is entered
    //
    _MemDel->DelayedDeleteCstr(start_, STOREMEM);

    if (!InProgramMode(true))
      EndCommandHistoryList();

    return 0;
  }
  else if (StdOutput() && CommandHistoryMode() && !InProgramMode(true) && ::SafeStrLen(temps_))
  {
    if (icasestrcomp(temps_, YES_STR) ||
        (!temps_[1] && toupper(temps_[0]) == 'Y'))
    {
      // Process sequentially displayed command history list entry that is
      // selected by the user in interactive user command prompt mode
      //
      hlindex_ = CommandHistoryIndex();
      Valid_ = HistoryListElementValid(hlindex_) == CMDENTRY_VALID;
      sz = size_t(HistoryListElementSize(hlindex_));

      if (Valid_ && sz &&
          ::SafeStrLen(HistoryListElementStr(hlindex_)))
      {
        _MemDel->DelayedDeleteCstr(start_, STOREMEM);

        temps_ = (char*)allocmem(sz + 1, sizeof(char), temps_);
        ::SafeStrCpy(temps_, HistoryListElementStr(hlindex_));
        start_ = temps_;
        RemovePadding(temps_, " \t\r\n");

        buffer = (char*)CalculatorBase::allocmem(INPUT_BUFFER_SIZE, sizeof(char), buffer);
        ::SafeStrCpy(buffer, temps_);
        SetHistoryListEntry(buffer, FALSE);

        Choice_ = 'Y';
        SetHistoryListMode(FALSE);
        SetHistoryListIndex(-1);
      }
    }
    else if (icasestrcomp(temps_, QUIT_STR) ||
             (!temps_[1] && toupper(temps_[0]) == 'Q'))
    {
      // Choice_ = 'Q';
      // Quit displaying of command history list entries if quit command
      // is entered while in history list mode
      //
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);

      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      return 1;
    }
    else
    {
      // if "no" command is entered while in history list mode then
      // increment to the next entry in the command history list and
      // display it otherwise if command is unrecognized then repeat
      // the display of the current command history list entry
      //
      Repeat_ = !icasestrcomp(temps_, NO_STR) &&
                !(!temps_[1] && toupper(temps_[0]) == 'N');

      // Choice_ = 'N';
      ShowCmdHistoryEntry(Repeat_);

      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      return 1;
    }
  }

  // Command history list entry selected in user prompt with "yes" or
  // Entered math statement stored in command history list as new entry
  //
  if (buffer && Choice_ == 'Y' && !InProgramMode(true))
  {
    if (!InAsyncMode() && !_ConsoleInput && !CmdHistEntrySelected_)
    {
      #if USE_STDIO_ONLY
        _StdInput = _StdOutput = TRUE;
        _ConsoleInput = _ConsoleOutput = false;
      #else
        if (_SavedConIO == 0)
          _SavedConIO = 1;           // stdio --> conio
        _ConsoleInput = _ConsoleOutput = true;
      #endif
    }

    if (CmdHistEntrySelected_)
      temps_ = buffer;

    sz = ::SafeStrLen(temps_);
    hllength_ = CommandHistoryLength();
    AllocateHistoryListElement(hllength_, sz+5);
    SetHistoryListElementValid(hllength_, CMDENTRY_INVALID);
    SetHistoryListElementSize(hllength_, Ushort(sz));
    SetHistoryListElementStr(hllength_, temps_);

    if (CmdHistEntrySelected_)
    {
      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      start_ = buffer;
      buffer = NULL;

      SetHistoryListEnded(FALSE);
      SetHistoryListMode(FALSE);
      SetHistoryListIndex(-1);
    }
    else
    {
      _MemDel->DelayedDeleteCstr(start_, STOREMEM);
      buffer = start_ = NULL;

      return 1;
    }
  }
  else if (argstr)
  {
    ::SafeStrCpy(start_, argstr);
    temps_ = start_;
    RemovePadding(temps_, " \t\r\n");
    sz = ::SafeStrLen(temps_);

    if (!InProgramMode(true))
    {
      hllength_ = CommandHistoryLength();
      AllocateHistoryListElement(hllength_, sz+5);
      SetHistoryListElementValid(hllength_, CMDENTRY_INVALID);
      SetHistoryListElementSize(hllength_, Ushort(sz));
      SetHistoryListElementStr(hllength_, temps_);
    }

    EntryMade_ = TRUE;
  }

  if ((!CmdHistEntrySelected_ && !CommandHistoryMode() && ::SafeStrLen(temps_)) ||
      (CmdHistEntrySelected_ && !InProgramMode(true) && argstr && ::SafeStrLen(CommandHistoryEntry())))
  {
    if (!_StreamSet)
      outfile = stdout;

    if (ClearOut_)
      ClearGuiOutputFile();

    PrevCalc_ = CalcPtr_;
    CalcPtr_ = CalcPtr_->GetCalcType();
    if (!CalcPtr_) CalcPtr_ = PrevCalc_;

    if (AnswerMode_ == ALTBASE_MODE ||
        AnswerMode_ == LITERAL_MODE ||
        NumberBase() != 10)
      RestoreNumberBase();

    // clear previously detected errors and output data types
    ClearOutputCondition(CalcPtr_);
    ClearOutputDataType();
    ClearOutputDataErrorCode();
    CalcPtr_->ClearError();

    SetPlotGraph(true, 0);
    _Expression = CalcPtr_->TopSubExprStack();
    CalcPtr_->ClearOutputToSignal();
    CalcPtr_->SetInputPromptWarning(false);
    GraphCmdFound_ = false;
    ModeChangesProcessed_ = false;

    if (ResultsShown())
    {
      AnsModeChanged_ = AnsModeChanged_ &&
                        OldMode_ != AnswerMode() && ModeFinalized();

      // ClearAnswerStr(AnsModeChanged_, OldMode_);
      ClearAnswerStr(false, OldMode_);
    }
    else
      ClearResultsShown();

    if (AnsModeChanged_)
    {
      PrevAnswerMode_ = AnswerMode_;
      AnsModeChanged_ = false;
    }

    if (_Expression)
    {
      exprterm_ = (CmdHistEntrySelected_ && !InProgramMode(true)) ? CommandHistoryEntry():temps_;
      QuestionStr_ = exprterm_;
      QuestionStr_ += "\n>> ";

      _Expression->SetExpression(exprterm_);
      _Expression->SetCalculator(CalcPtr_);
      _Expression->CheckIfValidExpression();
      _Expression->FindFunctionCalls();
      GraphCmdFound_ = _Expression->GraphCmdWasFound();
    }

    if (_IoState == Mcalc_IOState::CALC_HALT ||
        CalcPtr_->ShouldQuit())
    {
      CalcPtr_->SetShouldQuit(1);

      if (!InProgramMode(true))
      {
        SetHistoryListMode(FALSE);
        SetHistoryListIndex(-1);
      }

      if (EntryMade_ && !InProgramMode(true))
      {
        hllength_ = CommandHistoryLength();
        DeallocateHistoryListElement(hllength_);
      }
    }
    else if (_Expression && _Expression->Evaluate() && !InProgramMode(true) && (EntryMade_ || CommandHistoryEntry()))
    {
      #if CALCLIB_TESTASYNCMODE
        AckPostCond_ = AckPostExecInputFileData();
        AsyncStartCond_ = _StartAsStdInput && InAsyncMode();
      #else
        AckPostCond_ = StdInput() && AckPostExecInputFileData();
        AsyncStartCond_ = false;
      #endif

      if (!ModeChangesProcessed_)
      {
        PrgExecName_ = _Expression->GetProgramName();
        AnswerMode_ = _Expression->GetAnswerMode();
        AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;
        ModeChangesProcessed_ = true;

        if (AnsModeChanged_)
          OldMode_ = PrevAnswerMode_;
        else
          PrevAnswerMode_ = AnswerMode_;
      }

      if (AckPostCond_ && !PostExecResetProcessDone())
      {
        #if CALCLIB_DEBUG11b
          DbgPtr()->EnterLevel("EvalExpression...If(AckPostCond_)");
          DbgPtr()->ShowInt(AckPostCond_, "AckPostCond_");
          DbgPtr()->ShowInt(PostExecResetProcessDone(), "PostExecResetProcessDone()");
        #endif

        closeIOfiles();
        restorefiles();

        if (InputDataFileExecLock() != EXECFILE_LOCKED || AsyncStartCond_)
        {
          #if CALCLIB_DEBUG11b
            DbgPtr()->EnterLevel("EvalExpression...If(InputDataFileExecLock() != EXECFILE_LOCKED)");
            DbgPtr()->ShowInt(InputDataFileExecLock(), "InputDataFileExecLock()");
            DbgPtr()->ShowInt(AsyncStartCond_, "AsyncStartCond_");
          #endif

          if (AsyncStartCond_)
          {
            UseMicroSecDelay(true);
            Sleep_ = (!InputDataFilePauseOption() ||
                      NoPauseFileInput()) ? 1:0;
            IoState_ = Bare_GetIoState(Sleep_);  // IOstate delay 1 millisecond after end of input file execution

            SetNoPauseFileInput(FALSE);
            SetInputDataFilePauseOption(TRUE);
          }

          ResetAckPostExecInputFileData();
          ResetExecInputFileData();
          SetInputDataFileExecLock(EXECFILE_UNLOCKED);

          if (AsyncStartCond_)
            _IoStatePtr->ResetAtEndOfProcess(IoState_);

          SetPostExecResetProcessDone(TRUE);

          if (BatchFileEndedSignalPending())
            ReCheckEndBatchSignal();

          if (QuitGraph() && AsyncStartCond_)
          {
            CalcPtr_->SetBatchFileEndedSignalPending(false);
            CalcPtr_->SetBatchFileEndedSignalSent(false);
            CalcPtr_->SetBatchFileEndedSignalAcked(false);
            CalcPtr_->SetClientAckedDoneToGraphOutput(false);
            CalcPtr_->SetResponseWasCompleted(false);
            CalcPtr_->SetGraphOutputWasSent(FALSE);
            CalcPtr_->SetWasInBatchDataInput(FALSE);
          }

          Exec_ResetQuitGraphFlags();
          SetInputDataFilePauseOption(TRUE);  // default is true

          #if CALCLIB_DEBUG11b
            DbgPtr()->LeaveLevel();
          #endif
        }

        #if CALCLIB_DEBUG11b
          DbgPtr()->LeaveLevel();
        #endif
      }

      EntryIndex_ = CommandHistoryLength();
      SetHistoryListElementValid(IncHistoryListLength(1, POSTFIX), CMDENTRY_VALID);
      WriteCommandHistoryEntry(GetCommandHistoryFile(), EntryIndex_);

      if (CommandHistoryEntry() && !CmdHistEntrySelected_)
        DeallocateHistoryListEntry();
    }

    if (!ModeChangesProcessed_)
    {
      PrgExecName_ = _Expression->GetProgramName();
      AnswerMode_ = _Expression->GetAnswerMode();
      AnsModeChanged_ = PrevAnswerMode_ != AnswerMode_;
      ModeChangesProcessed_ = true;

      if (AnsModeChanged_)
        OldMode_ = PrevAnswerMode_;
      else
        PrevAnswerMode_ = AnswerMode_;
    }

    #if CALCLIB_TESTASYNCMODE
      AckPostCond_ = AckPostExecInputFileData();
      AsyncStartCond_ = _StartAsStdInput && InAsyncMode();
    #else
      AckPostCond_ = StdInput() && AckPostExecInputFileData();
      AsyncStartCond_ = false;
    #endif

    if (AckPostCond_ && !PostExecResetProcessDone())
    {
      #if CALCLIB_DEBUG11b
        DbgPtr()->EnterLevel("EvalExpression...If(AckPostCond_)");
        DbgPtr()->ShowInt(AckPostCond_, "AckPostCond_");
        DbgPtr()->ShowInt(PostExecResetProcessDone(), "PostExecResetProcessDone()");
      #endif

      closeIOfiles();
      restorefiles();

      if (InputDataFileExecLock() != EXECFILE_LOCKED || AsyncStartCond_)
      {
        #if CALCLIB_DEBUG11b
          DbgPtr()->EnterLevel("EvalExpression...If(InputDataFileExecLock() != EXECFILE_LOCKED)");
          DbgPtr()->ShowInt(InputDataFileExecLock(), "InputDataFileExecLock()");
          DbgPtr()->ShowInt(AsyncStartCond_, "AsyncStartCond_");
        #endif

        if (AsyncStartCond_)
        {
          UseMicroSecDelay(true);
          Sleep_ = (!InputDataFilePauseOption() ||
                    NoPauseFileInput()) ? 1:0;
          IoState_ = Bare_GetIoState(Sleep_);  // IOstate delay 1 millisecond after end of input file execution

          SetNoPauseFileInput(FALSE);
          SetInputDataFilePauseOption(TRUE);
        }

        ResetAckPostExecInputFileData();
        ResetExecInputFileData();
        SetInputDataFileExecLock(EXECFILE_UNLOCKED);

        if (AsyncStartCond_)
          _IoStatePtr->ResetAtEndOfProcess(IoState_);

        SetPostExecResetProcessDone(TRUE);

        if (BatchFileEndedSignalPending())
          ReCheckEndBatchSignal();

        if (QuitGraph() && AsyncStartCond_)
        {
          CalcPtr_->SetBatchFileEndedSignalPending(false);
          CalcPtr_->SetBatchFileEndedSignalSent(false);
          CalcPtr_->SetBatchFileEndedSignalAcked(false);
          CalcPtr_->SetClientAckedDoneToGraphOutput(false);
          CalcPtr_->SetResponseWasCompleted(false);
          CalcPtr_->SetGraphOutputWasSent(FALSE);
          CalcPtr_->SetWasInBatchDataInput(FALSE);
        }

        Exec_ResetQuitGraphFlags();
        SetInputDataFilePauseOption(TRUE);  // default is true

        #if CALCLIB_DEBUG11b
          DbgPtr()->LeaveLevel();
        #endif
      }

      #if CALCLIB_DEBUG11b
        DbgPtr()->LeaveLevel();
      #endif
    }

    if (CmdHistEntrySelected_ && !InProgramMode(true))
      SetHistoryListEntry(NULL, FALSE);

    if (!InProgramMode(true) && CommandHistoryLength() == MAXHISTORY-1)
    {
      DeallocateHistoryListElement(0);

      DecHistoryListLength();
      ::SafeMemMove(HistoryListBase(),
                    HistoryListBase(1),
                    sizeof(char*) * (MAXHISTORY-1));

      DisplayCommandHistoryList();
    }

    if (_IoState == Mcalc_IOState::CALC_HALT ||
        CalcPtr_->ShouldQuit())
      CalcPtr_->SetShouldQuit(1);

    Program_ = InProgramMode(true) ? ActiveProgram():NULL;
    AtTopExec_ = ExecInputFileData() && !AckPostExecInputFileData() && InputDataFileExecLock() == EXECFILE_LOCKED &&
                 IsUserPrompterProgram(Program_);

    if (!InProgramMode(true) || AtTopExec_)
    {
      if (AtTopExec_)
      {
        if ((_Expression && _Expression->HasAnswer()) || _Expression->HasCommandOutput())
          SetHasCommandOutput(!CalcPtr_->HasErrors() && !CalcPtr_->QuitGraph(), 0, _Expression);
        else
          SetHasCommandOutput(false, 0, _Expression);
      }
      else
      {
        ErrorsFound_ = CalcPtr_->HasErrors() || CalcPtr_->QuitGraph();
        GraphOutput_ = GraphCmdFound_ && !ErrorsFound_ &&
                       GraphOperationOptions()->InAppliedFunctionGraph();
        HasOutput_ = _Expression && _Expression->HasAnswer() &&
                     !ErrorsFound_;
        HasExprAns_ = HasOutput_ || GraphOutput_;

        if (HasExprAns_)
        {
          SetHasCommandOutput(true, 0, _Expression);
          _Expression->ShowResults();
        }
      }
    }
    else if (InProgramMode(true))
      SetHasCommandOutput(!CalcPtr_->HasErrors() && !CalcPtr_->QuitGraph() &&
                          _Expression && _Expression->HasCommandOutput(), 0, _Expression);

    if (_Expression)
      _Expression->Clear();

    if (!InIoStatePendingMode(false) && InAsyncMode())
    {
      if (CalcPtr_->HasErrors() && ErrorStatePending() && Bare_GetIoState(0) != Mcalc_IOState::CALC_ERROR)
        SetIoState(Mcalc_IOState::CALC_ERROR, true);

      ClearPendingErrors();
    }

    if (_Expression && CalcPtr_->HasErrors() && InIoStatePendingMode(false))
    {
      if (CalcPtr_->GetErrorVal() == Mcalc_Error::ERRVAL_OUTPUTDATA_ERRORS)
      {
        ErrorCnt_ = -1;
        ErrorVal_ = 0;
        ErrMsgCode_ = 0;

        SetMultiErrorVector(OutputDataErrorCode(), MakeOutputErrorsMaxSel(),
                            MakeOutputErrorsErrVals(), Mcalc_OutputDataCondition::MAX_OUTPUTDATA_ERRORS);

        while (ErrMsgCode_ = FindMultiErrors(ErrorCnt_, ErrorVal_))
        {
          SetError(ErrMsgCode_, true);
          DisplayErrorMessageForCode(GetOutputFile(), GetErrorVal());

          FetchAndShowCurrentError(QuestionStr_);
          CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

          if (InputDataFilePauseOption() && InAsyncMode())
          {
            IoState_ = Bare_GetIoState(0);
            IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
            UseMicroSecDelay(!FetchLimitReached_ ||
                             CurrentIoState() == Mcalc_IOState::CALC_ERROR);

            if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
            {
              CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
              IoState_ = Mcalc_IOState::CALC_ERROR;
            }
            else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
              IoState_ = Mcalc_IOState::CALC_ERROR;
          }

          ClearError();

          if (PostBreakResponseSent())
          {
            // clear previously detected errors and output data types
            ClearOutputCondition(CalcPtr_);
            ClearOutputDataType();
            ClearOutputDataErrorCode();
            break;
          }
          else
            CalculatorBase::ShouldBreakFromProgram(CalcPtr_);
        }

        if (ErrorStatePending())
          ClearPendingErrors();
      }
      else
      {
        FetchAndShowCurrentError(QuestionStr_);
        CalcPtr_->SetIoState(Mcalc_IOState::ERROR_FETCH, true, 1);

        if (InputDataFilePauseOption() && InAsyncMode())
        {
          IoState_ = Bare_GetIoState(0);
          IoState_ = WaitForClientOutputExtStates(IoState_, &FetchLimitReached_);
          UseMicroSecDelay(!FetchLimitReached_ ||
                           CurrentIoState() == Mcalc_IOState::CALC_ERROR);

          if (FetchLimitReached_ && Bare_GetIoState(1) == Mcalc_IOState::ERROR_FETCH)
          {
            CalcPtr_->SetIoState(Mcalc_IOState::CALC_ERROR, true);
            IoState_ = Mcalc_IOState::CALC_ERROR;
          }
          else if (CurrentIoState() == Mcalc_IOState::CALC_ERROR)
            IoState_ = Mcalc_IOState::CALC_ERROR;
        }

        if (PostBreakResponseSent())
          ResetPostBreakResponse();
        else
          CalculatorBase::ShouldBreakFromProgram(CalcPtr_);

        if (ErrorStatePending())
          ClearPendingErrors();
      }
    }
  }

  _MemDel->DelayedDeleteCstr(start_, STOREMEM);
  if (!InProgramMode(true))
    _MemDel->DelayedDeleteCstr(buffer, STOREMEM);

  ShouldQuit_ = CalcPtr_->ShouldQuit();

  if (ShouldQuit_ && !InProgramMode(true))
    EndCommandHistoryList();

  if (oldargptr && CmdHistoryCancelled_ && !InProgramMode(true))
  {
    argstr = oldargptr;
    oldargptr = NULL;
    CmdHistoryCancelled_ = FALSE;
  }

  return !ShouldQuit_;
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::EvaluateLine(int argc, CalculatorBase* CalcPtr_, Mcalc_Operand** operands, char** arglist)
{
  _MemDel->CheckIfEraseStoredTrash(STOREMEM);

  int* CondArray = NULL;
  int LineEvalDone_ = 0;
  int VarEvalDone_ = 0;
  int VarDisplayed_ = 0;
  int ValidFormat_ = 0;

  int optype;
  int Mode_ = 0;
  int CurState_ = 0;

  bool IsFrac_ = false;
  bool IsLiteral_ = false;
  bool IsAltBase_ = false;
  bool HasOps_ = false;
  bool Confirmed_ = false;
  bool InInputFile_;
  char* original;
  Mcalc_Queue* rpnqueue = NULL;
  Mcalc_Stack* rpnstack = NULL;

  ResetVarIndexFound();
  SetResultsShown(false);
  SetUseErrorArgStr(false);
  CondArray = (int*)allocmem(MAX_INFIX_COND, sizeof(int), CondArray);
  ::memset(CondArray, 0, MAX_INFIX_COND * sizeof(int));
  SubExpression* SubExpr_ = CalcPtr_->TopSubExprStack();

  if (SubExpr_)
    SubExpr_->SetProgramName(NULL);

  int ConversionOk_ = InfixToRpn(argc, arglist, &rpnqueue, &rpnstack,
                                 &original, CalcPtr_, CondArray, CurState_);

  CalculatorBase* PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = PrevCalc_;

  if (ConversionOk_ && CalcPtr_)
  {
    HasOps_ = !HasErrors() && !QuitGraph() && peek(rpnqueue);
    CalcPtr_->CheckInAltAnswerMode(arglist[0], HasOps_, Confirmed_,
                                   IsFrac_, IsLiteral_, IsAltBase_);

    if (HasOps_)
    {
      _ConfirmedValidOps = false;

      if (!CalcPtr_->StringAssignment() &&
          !CalcPtr_->SetAssignment() &&
          !SkipEval() && HasOps_ && arglist[0])
        while (!HasErrors() && !QuitGraph() &&
               evaluateRPN(&rpnqueue,&rpnstack,arglist,&optype))
        {
          ProcessExpr(operands,arglist,optype, CalcPtr_);
          pushresult(operands,&rpnstack,optype);
          freeargs(&arglist);
        }

      if (!_ConfirmedValidOps &&
          (Confirmed_ || IsFrac_ || IsLiteral_ || IsAltBase_))
      {
        Mode_ = IsFrac_ ? CalculatorBase::FRACTION_MODE:
                IsLiteral_ ? CalculatorBase::LITERAL_MODE:
                IsAltBase_ ? CalculatorBase::ALTBASE_MODE:
                             AnswerMode();

        SetAnswerMode(Mode_, Confirmed_);
      }
    }

    RestoreNumberBase();
    CalcPtr_->StoreResults();
    DisplayToString(operands,original);

    if (VariableIndexFound() && !GraphOperation())
    {
      InInputFile_ = ExecInputFileData() && !AckPostExecInputFileData() &&
                     InputDataFileExecLock() == EXECFILE_LOCKED;

      if (!ProcessAckSignalSent() &&
          !ProcessAckSignalDone() &&
          !ProcessAckSignalPending() &&
          InAsyncMode() && !NoPauseFileInput() &&
          !HasErrors() && !QuitGraph() &&
          (InInputFile_ ||
           CurState_ == Mcalc_IOState::PROCESS))
      {
        #if CALCLIB_DEBUG12c
          DbgPtr()->EnterLevel("EvaluateLine -- SendProcessAck");
        #endif

        SetDirective(arglist[0]);
        SetProcessAckSignalPending(true);
        SetProcessAckForSignalReceived(Mcalc_IOState::PROCESS);
        CurState_ = SendProcessAckSignal(0);

        #if CALCLIB_DEBUG12c
          DbgPtr()->LeaveLevel();
        #endif
      }

      if (CalcPtr_->ShowAnswer())
        CalcPtr_->SetHasAnswer(FALSE);
    }
  }
  else
  {
    if (CondArray[LINE_EVAL_DONE])
    {
      if (!InProgramMode(true))
        // Previous non-math related options are selected and output is immediately displayed in
        // non-program mode, so set calculator to NO resulting answer.
        SetHasAnswer(FALSE);
      else
        // display variables if in program mode and line is in correct format
        SetHasAnswer(CondArray[VALID_FORMAT] && !CondArray[VAR_EVAL_DONE] && CondArray[VAR_DISPLAYED]);
    }
    else
      SetHasAnswer(FALSE);

    // Reset to no variable assignments
    ResetIndexes();
  }

  FindAndSetOutputDataErrors(CalcPtr_);
  SetSkipEval(FALSE);
  _MemDel->DelayedDeleteCstr(original, STOREMEM);
  _MemDel->DelayedDeleteCstr((char*)CondArray, STOREMEM);
  original = NULL;
  delstack(&rpnstack);
  delqueue(&rpnqueue);
}

/****************************************************************************/
template <class T>
void LineCalculator<T>::ProgramProc(int argc, char** argv, CalculatorBase* CalcPtr_)
{
  CalculatorBase* PrevCalc_;
  Mcalc_Operand** operands;        // operands array
  char** arglist = NULL;           // substitute argument list
  int i;

  initarrays(&operands,&arglist);  // initialize variables
  if (!_StreamSet)
    outfile = stdout;

  for (i = 0; i < argc; i++)
    arglist[i] = argv[i];

  for (;i < MAXARGS; i++)
    arglist[i] = NULL;

  PrevCalc_ = CalcPtr_;
  CalcPtr_ = CalcPtr_->GetCalcType();
  if (!CalcPtr_) CalcPtr_ = PrevCalc_;
  EvaluateLine(argc, CalcPtr_, operands, arglist);
  freememory(&operands); // free operands list
  freelist(&arglist);    // free argument list passed from expression evaluation
}

/****************************************************************************/
// method called from SubExpression::Evaluate() to transfer math expression
// string after function evaluation has been performed and completed: argstr
//
template <class T>
int LineCalculator<T>::TransferData(char* argstr, CalculatorBase* CalcPtr_)
{
  char* argvector[2];
  char* temps_ = NULL;
  temps_ = (char*)allocmem(::SafeStrLen(argstr) + 1, sizeof(char), temps_);
  char* start_ = temps_;

  ::SafeStrCpy(temps_, argstr);
  RemovePadding(temps_, " \t\n\r");

  if (!::SafeStrLen(temps_))
  {
    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    SetHasAnswer(FALSE);
    return 1;
  }
  else if (icasestrcomp(temps_, QUIT_STR))
  {
    _MemDel->DelayedDeleteCstr(start_, STOREMEM);
    SetHasAnswer(FALSE);
    return 0;
  }

  argvector[0] = NULL;    // reserved for concatenated (combined) argument list
  argvector[1] = start_;  // save function evaluated expression string here
  ::SafeStrCpy(argvector[1], argstr);

  if (argstr && strlen(argstr))
    ProgramProc(2, argvector, CalcPtr_);
  else
    SetHasAnswer(FALSE);

  _MemDel->DelayedDeleteCstr(start_, STOREMEM);
  return 1;
}

/****************************************************************************/
template <class T>
int LineCalculator<T>::StoreResults()
{
  int x;
  int AssignType_;
  int Found_ = HasIndex();
  ChrString TempStr_;
  int Errors_ = HasErrors() || QuitGraph();
  bool SesOptOverride_ = SessionOptionOverride();
  bool InGraphOp_ = false;

  while (HasIndex())
  {
    GetIndex(x, AssignType_);
    Boolean SetOps_ = AssignType_ == SET_ASSIGN ||
                      AssignType_ == SET_UNION ||
                      AssignType_ == SET_INTERSECTION ||
                      AssignType_ == SET_NEGATION ||
                      AssignType_ == SET_EXCLUSION;

    if (AssignType_ && !Errors_)
    {
      if (AssignType_ == STRING_ASSIGN || SetOps_)
      {
        int Mode_ = AnswerMode();
        if (Mode_ == LITERAL_MODE || Mode_ == ALTBASE_MODE)
        {
          TempStr_ = LiteralStr();

          if (AssignType_ == STRING_ASSIGN)
          {
            SetStringAssignment(TRUE, TempStr_.c_str());
            SetStrVariable(x, TempStr_);
          }
          else if (SetOps_)
          {
            int IsNull_ = IsNullSetStr(TempStr_.c_str());
            SetSetAssignment(TRUE, TempStr_.c_str(), IsNull_);
            SetSetVariable(x, TempStr_, IsNull_);
          }

          if (Mode_ == ALTBASE_MODE && StringAssignment())
          {
            SetVariable(x, GetResult());
            TransferVariable(x, x);
          }
        }
        else if (Mode_ == FRACTION_MODE)
        {
          TempStr_ = FractionStr();
          SetStringAssignment(TRUE, TempStr_.c_str());
          SetStrVariable(x, TempStr_);
        }
        else
        {
          if (SetOps_)
          {
            TempStr_ = GetSetResult();
            int IsNull_ = IsNullSetStr(TempStr_.c_str());
            SetSetVariable(x, TempStr_, IsNull_);
          }
          else
            SetStrVariable(x, GetStrResult());
        }
      }
      else if (AssignType_ == STRING_CONCAT)
      {
        int Mode_ = AnswerMode();
        if (Mode_ == LITERAL_MODE || Mode_ == ALTBASE_MODE)
        {
          CopyStrVar(TempStr_, x);
          TempStr_ += LiteralStr();
          SetStringAssignment(TRUE, TempStr_.c_str());
          SetStrVariable(x, TempStr_);
        }
        else if (Mode_ == FRACTION_MODE)
        {
          CopyStrVar(TempStr_, x);
          TempStr_ += FractionStr();
          SetStringAssignment(TRUE, TempStr_.c_str());
          SetStrVariable(x, TempStr_);
        }
        else
        {
          CopyStrVar(TempStr_, x);
          TempStr_ += GetStrResult();
          SetStrVariable(x, TempStr_);
        }
      }
      else
      {
        SetVariable(x, GetResult());
        TransferVariable(x, x);
      }
    }

    PopIndex();
  }

  if (StringAssignment())
    SetStringAssignment(FALSE);

  if (SetAssignment())
    SetSetAssignment(FALSE, NULL, FALSE);

  _VarIndexFound = Found_;
  InGraphOp_ = GraphOperation() && InAsyncMode() && !NoPauseFileInput();

  ResetIndexes();
  SetShowAnswer((!Found_ || InGraphOp_) && !Errors_);

  if (!Found_ && !Errors_)
    TransferVariable(-1, -1);

  return Found_;
}

/****************************************************************************/
#endif




