#ifndef CHECKBOX_CPP
#define CHECKBOX_CPP
#ifndef CHECKBOX_H
  #include "checkbox.h"
#endif

const char *const CheckBox::CHECK_BOX_MARKER	= "X";

/****************************************************************************/
/****************************************************************************/
CheckInputBox::CheckInputBox(char* msg, PromptBox* next_, int Size_):
PromptBox(msg, next_, Size_)
{}

/****************************************************************************/
CheckInputBox::CheckInputBox(PromptBox& pb, int Size_):
PromptBox(pb, Size_)
{}

/****************************************************************************/
#if !defined(__TURBOC__) & !defined(__BORLANDC__)
CheckInputBox::CheckInputBox(char* msg, CheckInputBox* next_, int Size_):
PromptBox(msg, next_, Size_)
{}
#endif

/****************************************************************************/
#if !defined(__TURBOC__) & !defined(__BORLANDC__)
CheckInputBox::CheckInputBox(CheckInputBox& pb, int Size_):
PromptBox(pb, Size_)
{}
#endif

/****************************************************************************/
CheckInputBox* CheckInputBox::Make(char* msg, PromptBox* next_, int Size_)
{
  CheckInputBox* bb;
  bb = new CheckInputBox(msg, next_, Size_);
  return bb;
}

/****************************************************************************/
CheckInputBox* CheckInputBox::Make(PromptBox& pbox, int Size_)
{
  CheckInputBox* bb;
  bb = new CheckInputBox(pbox, Size_);
  return bb;
}

/****************************************************************************/
PromptBox& CheckInputBox::operator = (PromptBox& pb)
{
  if (this != &pb)
    PromptBox::operator = (pb);

  return *this;
}

/****************************************************************************/
CheckInputBox& CheckInputBox::operator = (CheckInputBox& pb)
{
  if (this != &pb)
    PromptBox::operator = (pb);

  return *this;
}

/****************************************************************************/
/****************************************************************************/
CheckBox::CheckBox(char* Msg_, Boolean Checked_):
_PromptBox(CheckInputBox::Make(Msg_, NULL, 1)),
_CbCtrlFilter(NULL),
_Selected(Checked_),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_selected_monitor(NULL),
_toggled_monitor(NULL),

// Handles to external objects, used by data monitors
_selected_handle(NULL),
_toggled_handle(NULL)
{
  strcpy(_Marker, CHECK_BOX_MARKER);
  _PromptBox->SetInputLength(1);
  _PromptBox->SetSquareBrackets();
  _PromptBox->SetFilter(" ");
  _PromptBox->SetSelectable(TRUE);

  SetCheck(Checked_);
  InitCtrlFilter();
}

/****************************************************************************/
CheckBox::CheckBox(CheckBox& cbox_):
_PromptBox(CheckInputBox::Make(*cbox_._PromptBox, 1)),
_CbCtrlFilter(NULL),
_Selected(cbox_.IsSelected()),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_selected_monitor(NULL),
_toggled_monitor(NULL),

// Handles to external objects, used by data monitors
_selected_handle(NULL),
_toggled_handle(NULL)
{
  strcpy(_Marker, CHECK_BOX_MARKER);
  _PromptBox->SetInputLength(1);
  _PromptBox->SetSquareBrackets();
  _PromptBox->SetFilter(" ");
  _PromptBox->SetSelectable(TRUE);

  SetCheck(cbox_.IsSelected());
  InitCtrlFilter();
}

/****************************************************************************/
CheckBox::~CheckBox()
{
  delete _PromptBox;
  _PromptBox = NULL;
}

/****************************************************************************/
int CheckBox::GetHotKeyType() const
{
  return _PromptBox->GetHotKeyType();
}

/****************************************************************************/
int CheckBox::GetHotKey() const
{
  return _PromptBox->GetHotKey();
}

/****************************************************************************/
int CheckBox::GetShortCut() const
{
  return _PromptBox->GetShortCut();
}

/****************************************************************************/
void CheckBox::SetSelectable(Boolean Flag_)
{
  _PromptBox->SetSelectable(Flag_);
}

/****************************************************************************/
void CheckBox::InitCtrlFilter()
{
  _CbCtrlFilter = new KeyNode*[MAX_CHECKBOX_KEYS];

  // Allowable user response to button dialog prompt
  _CbCtrlFilter[0] = &TextControl::GetKeyMap()[TextControl::UP];
  _CbCtrlFilter[1] = &TextControl::GetKeyMap()[TextControl::DOWN];
  _CbCtrlFilter[2] = &TextControl::GetKeyMap()[TextControl::NEXT];
  _CbCtrlFilter[3] = &TextControl::GetKeyMap()[TextControl::ESCAPE];
  _CbCtrlFilter[4] = &TextControl::GetKeyMap()[TextControl::ENTER];
}

/****************************************************************************/
const int* CheckBox::Monitor(const int*(*monptr_)(void*, CheckBox*, const int*), void* This_, const int* ptr_)
{
  if (monptr_ != NULL)
  {
    SaveCursorPosition();
    const int* RetVal_ = (*monptr_)(This_, this, ptr_);
    RestoreCursorPosition();

    return RetVal_;
  }

  return ptr_;
}

/****************************************************************************/
void CheckBox::SaveCursorPosition()
{
  _SavedCursX = WHEREX();
  _SavedCursY = WHEREY();
}

/****************************************************************************/
void CheckBox::RestoreCursorPosition()
{
  GOTOXY(_SavedCursX, _SavedCursY);
}

/****************************************************************************/
const int* CheckBox::MonitorKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorKey(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorExtendedKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorExtendedKey(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorEscapedStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorEscapedStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorHiddenStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorActiveStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorInFocusStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* CheckBox::MonitorSelectedStatus(void* This_, const int*(*FnPtr_)(void*, CheckBox*, const int*))
{
  _selected_handle = This_;
  _selected_monitor = FnPtr_;
  return &_Selected;
}

/****************************************************************************/
const int* CheckBox::MonitorToggledStatus(void* This_, const int*(*FnPtr_)(void*, CheckBox*, const int*))
{
  _toggled_handle = This_;
  _toggled_monitor = FnPtr_;
  return &_Toggled;
}

/****************************************************************************/
Boolean CheckBox::Toggled()
{
  return _Toggled;
}

/****************************************************************************/
CheckBox& CheckBox::operator = (CheckBox& cbox_)
{
  *_PromptBox = *cbox_._PromptBox;
  return *this;
}

/****************************************************************************/
CheckBox* CheckBox::Make(char* Msg_, Boolean Checked_)
{
  CheckBox* cb;
  cb = new CheckBox(Msg_, Checked_);
  return cb;
}

/****************************************************************************/
CheckBox* CheckBox::Make(CheckBox& cbox_)
{
  CheckBox* cb;
  cb = new CheckBox(cbox_);
  return cb;
}

/****************************************************************************/
int CheckBox::Prompt(int status_)
{
  int Index_;
  int ReturnVal_ = 0;

  if (!IsActive())
    return 1;

  Monitor(_selected_monitor, _selected_handle, &_Selected);

  if (status_)
    _Toggled = TRUE;
  else
  {
    // Restrict user response to allowable keys by setting key filter
    // include key filter even for control keys: Enter, Tab, Esc...
    for (Index_ = 0; Index_ < MAX_CHECKBOX_KEYS; ++Index_)
      _PromptBox->AddCtrlFilter(*_CbCtrlFilter[Index_]);

    ReturnVal_ = _PromptBox->Prompt(1);

    // Remove key filter after user response is retrieved
    for (Index_ = 0; Index_ < MAX_CHECKBOX_KEYS; ++Index_)
      _PromptBox->RemoveCtrlFilter(*_CbCtrlFilter[Index_]);

    SetToggled();
  }

  if (Toggled())
  {
    ToggleCheck();
    ReturnVal_ = 0;
  }

  ShowInput();

  return ReturnVal_;
}

/****************************************************************************/
void CheckBox::Show()
{
  _PromptBox->Show();
}

/****************************************************************************/
void CheckBox::ShowInput()
{
  _PromptBox->ShowInput();
}

/****************************************************************************/
void CheckBox::Hide()
{
  _PromptBox->Hide();
}
/****************************************************************************/
void CheckBox::Erase()
{
  _PromptBox->Erase();
}

/****************************************************************************/
void CheckBox::SetToggled()
{
  _Toggled = (_PromptBox->IsSelected() && *_PromptBox->Retrieve() != *_Marker);
  Monitor(_toggled_monitor, _toggled_handle, &_Toggled);
}

/****************************************************************************/
void CheckBox::SetCheck(int Checked_)
{
  if (Checked_)
  {
    _PromptBox->SetFilter(_Marker);
    _PromptBox->SetInputString(_Marker);
  }
  else
    _PromptBox->SetInputString("");

  _PromptBox->SetFilter(" ");

  _Selected = Checked_;
  Monitor(_selected_monitor, _selected_handle, &_Selected);
}

/****************************************************************************/
void CheckBox::ToggleCheck()
{
  _Selected = !_Selected;
  SetCheck(_Selected);
}

/****************************************************************************/
void CheckBox::ResetInputState(int status_)
{
  _PromptBox->ResetInputState(status_);
}

/****************************************************************************/
Boolean CheckBox::IsOwner(ControlWindow* Cwin_) const
{
  return _PromptBox->IsOwner(Cwin_);
}

/****************************************************************************/
void CheckBox::SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_)
{
  _PromptBox->SetOwner(Cwin_, TxtCtrl_);
}

/****************************************************************************/
void CheckBox::Select()
{
  SetCheck(TRUE);
}

/****************************************************************************/
void CheckBox::Deselect()
{
  SetCheck(FALSE);
}

/****************************************************************************/
Boolean CheckBox::IsEnterable() const
{
  return _PromptBox->IsEnterable();
}

/****************************************************************************/
Boolean CheckBox::IsSelectable() const
{
  return _PromptBox->IsSelectable();
}

/****************************************************************************/
Boolean CheckBox::IsSelected() const
{
  return _PromptBox->IsSelected();
}

/****************************************************************************/
Boolean CheckBox::IsEmpty() const
{
  return _PromptBox->IsEmpty();
}

/****************************************************************************/
Boolean CheckBox::IsEscaped() const
{
  return _PromptBox->IsEscaped();
}

/****************************************************************************/
Boolean CheckBox::IsValid() const
{
  return _PromptBox->IsValid();
}

/****************************************************************************/
Boolean CheckBox::IsActive() const
{
  return _PromptBox->IsActive();
}

/****************************************************************************/
Boolean CheckBox::IsInFocus() const
{
  return _PromptBox->IsInFocus();
}

/****************************************************************************/
void CheckBox::Activate()
{
  _PromptBox->Activate();
}

/****************************************************************************/
void CheckBox::Deactivate()
{
  _PromptBox->Deactivate();
}

/****************************************************************************/
void CheckBox::SetupColors(int Mode_)
{
  _PromptBox->SetupColors(Mode_);
}

/****************************************************************************/
void CheckBox::UseColor(Boolean Flag_)
{
  _PromptBox->UseColor(Flag_);
}

/****************************************************************************/
void CheckBox::SetNormalColors(int FgCol_, int BgCol_)
{
  _PromptBox->SetNormalColors(FgCol_, BgCol_);
}

/****************************************************************************/
void CheckBox::SetHighLightColors(int FgCol_, int BgCol_)
{
  _PromptBox->SetHighLightColors(FgCol_, BgCol_);
}

/****************************************************************************/
void CheckBox::SetHotKeyColor(int Col_)
{
  _PromptBox->SetHotKeyColor(Col_);
}

/****************************************************************************/
void CheckBox::SetBackGroundColor(int Col_)
{
  _PromptBox->SetBackGroundColor(Col_);
}

/****************************************************************************/
void CheckBox::UseDefaultColors()
{
  _PromptBox->UseDefaultColors();
}

/****************************************************************************/
Boolean CheckBox::UsesColor() const
{
  return _PromptBox->UsesColor();
}

/****************************************************************************/
int* CheckBox::NormalColors() const
{
  return _PromptBox->NormalColors();
}

/****************************************************************************/
int* CheckBox::HighLightColors() const
{
  return _PromptBox->HighLightColors();
}

/****************************************************************************/
int CheckBox::HotKeyColor() const
{
  return _PromptBox->HotKeyColor();
}

/****************************************************************************/
int CheckBox::BackGroundColor() const
{
  return _PromptBox->BackGroundColor();
}

/****************************************************************************/
/****************************************************************************/
CheckWindow::CheckWindow(int Max_):
PromptWindow(Max_)
{}

/****************************************************************************/
CheckWindow::CheckWindow(CheckWindow& cw):
PromptWindow(cw)
{}

/****************************************************************************/
// PURPOSE:
//   Method to Grow the size of the array by some number passed as an
//   argument to the method. The array contents are preserved.
//
// PRE:
//   The old size of the Prompt box array and its contents
//
// POST:
//   The array size is Grown by the extra size given and the original
//   contents of the array are preserved in the new array.
//
void CheckWindow::Grow(int extra)
{
  int index;
  int newlen = _maxbox + extra;

  TextControl** newp = new TextControl*[newlen];
  ControlInfo* newi = new ControlInfo(newlen);

  for (index = 0; index < _maxbox; index++)
  {
    newp[index] = CheckBox::Make(*((CheckBox*)_pbox[index]));
    SetControlData(newp, newi, index);
  }

  for (;index < newlen; index++)
    RemoveControlData(newp, newi, index);

  Clear();

  _maxbox = newlen;
  _pbox = newp;
  _Info = newi;
}

/****************************************************************************/
// PURPOSE:
//   Cycle through the entire Prompt box array and Prompt the user with
//   each one.
//
// POST:
//   The Prompt box array is cycled through and each Prompt box element
//   within the array is used to Prompt the user.
//
int CheckWindow::Prompt(int StartIndex_)
{
  int index = (StartIndex_ >= _maxbox) ? 0:
	      (StartIndex_ < 0)        ? (_maxbox - 1):
					 StartIndex_;
  int status_;
  int placemark_ = 0;

  if (AnyActive())
    for (;;)
    {
      if (_pbox[index] && _pbox[index]->IsActive())
      {
	if (placemark_)
	  (*this)[index].ResetInputState(0);

	status_ = _pbox[index]->Prompt(placemark_);
	Boolean hkeypressed_ = _Info->HotKeyPressed();

	if (hkeypressed_)
	{
	  if (status_ != 0)
	    index = _Info->GetIndex();

	  placemark_ = (hkeypressed_ == TextControl::SHORTCUT);
	  _Info->ResetHotKeys();
	}

	if (!hkeypressed_ || !status_)
	{
	  if (_pbox[index]->IsEscaped())
	    break;

	  index += status_;
	  placemark_ = 0;
	}
      }
      else
	++index;

      index = (index >= _maxbox) ? 0:
	      (index < 0) 	 ? (_maxbox - 1):
				   index;
    }

  return index;
}

/****************************************************************************/
// PURPOSE:
//   Prompt box Index operator. To index individual Prompt boxes from the
//   Prompt window given the position of the Prompt box within the array.
//
// PRE:
//   int index : the index position of the Prompt box in the array
//
// POST:
//   Go into the specified index position in the Prompt box array and
//   Retrieve its element.
//
CheckWindowRef CheckWindow::operator [] (int index)
{
  ASSERT((index >= 0 && index < _maxbox), USER_Message_t::ERRMSG_INDEXRANGE);

  CheckWindowRef CboxRef(this, index);
  return CboxRef;
}

/****************************************************************************/
CheckBox* CheckWindow::NextSelected(int& Start_)
{
  Boolean Found_ = FALSE;

  for (;Start_ < _maxbox; Start_++)
    if (Found_ = _pbox[Start_] != NULL && _pbox[Start_]->IsSelected())
      break;

  if (Found_)
  {
    ++Start_;
    return (*this)[Start_ - 1];
  }

  return NULL;
}

/****************************************************************************/
/****************************************************************************/
CheckWindowRef::CheckWindowRef(CheckWindow* Boss_, int Index_):
_BossPtr(Boss_),
_Index(Index_)
{}

/****************************************************************************/
CheckWindowRef& CheckWindowRef::operator = (CheckBox* Pbox_)
{
  _BossPtr->Control(_Index, Pbox_);
  return *this;
}

/****************************************************************************/
CheckWindowRef::operator CheckBox* ()
{
  return CastToCheckBox(_BossPtr->Control(_Index));
}

/****************************************************************************/
CheckBox* CheckWindowRef::operator -> ()
{
  return CastToCheckBox(_BossPtr->Control(_Index));
}

/****************************************************************************/
Boolean CheckWindowRef::Toggled()
{
  return CastToCheckBox(_BossPtr->Control(_Index))->Toggled();
}

/****************************************************************************/
void CheckWindowRef::ResetInputState(int status_)
{
  CastToCheckBox(_BossPtr->Control(_Index))->ResetInputState(status_);
}

/****************************************************************************/
/****************************************************************************/
#if CHECKBOX_DEBUG
int main()
{
  CLRSCR();

  CheckBox* pb;
  CheckWindow pw;

  pw.MaxControl(1);

  pb = CheckBox::Make("C&heckbox 1 : ");
  pb->SetXpos(3);
  pb->SetYpos(2);
  pw[0] = pb;

  pw.Grow(3);

  pb = CheckBox::Make("Ch&eckbox 2 : ");
  pb->SetXpos(3);
  pb->SetYpos(4);
  pw[1] = pb;

  pb = CheckBox::Make("Chec&kbox 3 : ");
  pb->SetXpos(3);
  pb->SetYpos(6);
  pw[2] = pb;

  pb = CheckBox::Make("Check&box 4 : ");
  pb->SetXpos(3);
  pb->SetYpos(8);
  pw[3] = pb;

  pw.UseColor();
  pw.Show();
  pw.Prompt();
  pw.UseColor(FALSE);
  pw.Hide();

  GOTOXY(1, 1);
  int index;
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  pw.UseColor();
  pw.Show();
  pw.Prompt();
  pw.UseColor(FALSE);
  pw.Hide();

  GOTOXY(1, 1);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  return 0;
}
#endif
/****************************************************************************/
#endif

