#ifndef CHECKBOX_H
#define CHECKBOX_H
#ifndef PROMPTBOX_H
  #include "promptbox.h"
#endif

#define CHECKBOX_DEBUG		0

/****************************************************************************/
class CheckBox;

class CheckInputBox : public PromptBox
{
  friend class CheckBox;
  private:
    // promptbox constructors
    CheckInputBox(char* msg, PromptBox* next_, int Size_);
    CheckInputBox(PromptBox& pb, int Size_);

#if !defined(__TURBOC__) & !defined(__BORLANDC__)
    CheckInputBox(char* msg, CheckInputBox* next_, int Size_);
    CheckInputBox(CheckInputBox& pb, int Size_);
#endif

    static CheckInputBox* Make(char* msg=NULL, PromptBox* next_=NULL, int Size_=0);
    static CheckInputBox* Make(PromptBox& pbox, int Size_=0);

    // Text color methods
    void SetupColors(int Mode_)
	{ PromptBox::SetupColors(Mode_); }

    // console input retrieval methods
    void ResetInputState(int status_)
	{ PromptBox::ResetInputState(status_); }
    void SetSelectable(Boolean Flag_)
	{ PromptBox::SetSelectable(Flag_); }

  public:
    virtual PromptBox& operator = (PromptBox& pb);
    virtual CheckInputBox& operator = (CheckInputBox& pb);
};

/****************************************************************************/
class CheckWindowRef;
class CheckWindow;

class CheckBox : public TextControl
{
  friend class CheckWindowRef;
  friend class CheckWindow;

  protected:
    enum { MAX_CHECKBOX_KEYS = 5 };

    CheckInputBox* _PromptBox;
    KeyNode** _CbCtrlFilter;

    int _Selected;
    int _Toggled;
    char _Marker[2];

    int _SavedCursX;			// Saved cursor x position
    int _SavedCursY;			// Saved cursor y position

    static const char *const CHECK_BOX_MARKER;

    // Miscellaneous methods
    void InitCtrlFilter();
    void ToggleCheck();
    PromptBox& GetPromptBox()
	{ return *_PromptBox; }

    // prompt box properties mutators
    virtual void SetCheck(int Checked_);
    virtual void SetToggled();

    // Internal data monitoring function pointers
    const int*(*_selected_monitor)(void*, CheckBox*, const int*);
    const int*(*_toggled_monitor)(void*, CheckBox*, const int*);

    // Handles to external objects, used by data monitors
    void* _selected_handle;
    void* _toggled_handle;

    // Monitor functions execution and management methods
    const int* Monitor(const int*(*monptr_)(void*, CheckBox*, const int*), void* This_, const int* ptr_);
    void SaveCursorPosition();
    void RestoreCursorPosition();
    void ResetInputState(int status_);

    // Box Toggle flag accessor
    virtual Boolean Toggled();

    // Text color methods
    void SetupColors(int Mode_);

    // promptbox constructors
    CheckBox(char* Msg_, Boolean Checked_);
    CheckBox(CheckBox& cbox_);

  public:
    virtual ~CheckBox();

    // promptbox assignment operator
    virtual CheckBox& operator = (CheckBox& cbox_);
    static CheckBox* Make(char* Msg_=NULL, Boolean Checked_=FALSE);
    static CheckBox* Make(CheckBox& cbox_);

    inline void SetMessage(char* str)
	{ _PromptBox->SetMessage(str); }
    inline void SetXYpos(int x, int y)
	{ _PromptBox->SetXYpos(x, y); }
    inline void SetXpos(int x)
	{ _PromptBox->SetXpos(x); }
    inline void SetYpos(int y)
	{ _PromptBox->SetYpos(y); }

    // prompt box manipulators
    virtual void Show();
    virtual void ShowInput();
    virtual void Hide();
    virtual int Prompt(int status_);
    virtual void Erase();

    // text control selection/deselection mutators
    virtual void SetSelectable(Boolean Flag_);
    virtual void Select();
    virtual void Deselect();

    // Empty, valid, escaped and selected test
    virtual Boolean IsEnterable() const;
    virtual Boolean IsSelectable() const;
    virtual Boolean IsSelected() const;
    virtual Boolean IsEmpty() const;
    virtual Boolean IsEscaped() const;
    virtual Boolean IsValid() const;
    virtual Boolean IsActive() const;
    virtual Boolean IsInFocus() const;

    // Activation/Deactivation for this text widget
    virtual void Activate();
    virtual void Deactivate();

    // Accelerator key methods
    virtual int GetHotKeyType() const;
    virtual int GetHotKey() const;
    virtual int GetShortCut() const;

    // Control Ownership methods
    virtual void SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_);
    virtual Boolean IsOwner(ControlWindow* Cwin_) const;

    // Text color methods
    virtual void UseColor(Boolean Flag_);
    virtual void SetNormalColors(int FgCol_, int BgCol_);
    virtual void SetHighLightColors(int FgCol_, int BgCol_);
    virtual void SetHotKeyColor(int Col_);
    virtual void SetBackGroundColor(int Col_);
    virtual void UseDefaultColors();

    virtual Boolean UsesColor() const;
    virtual int* NormalColors() const;
    virtual int* HighLightColors() const;
    virtual int HotKeyColor() const;
    virtual int BackGroundColor() const;

    // Internal data monitoring methods
    const int* MonitorKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorExtendedKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorEscapedStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorSelectedStatus(void* This_, const int*(*FnPtr_)(void*, CheckBox*, const int*));
    const int* MonitorToggledStatus(void* This_, const int*(*FnPtr_)(void*, CheckBox*, const int*));
};

/****************************************************************************/
/****************************************************************************/
class CheckWindow : public PromptWindow
{
  friend class CheckWindowRef;
  public:
    // prompt window constructors
    CheckWindow(int Max_=0);
    CheckWindow(CheckWindow& cw);
    ~CheckWindow()
	{ Clear(); }

    // grow array method
    virtual void Grow(int extra);

    // prompt window manipulators
    virtual int Prompt(int StartIndex_=0);

    // Check box control access method
    CheckWindowRef operator [] (int index);
    CheckBox* NextSelected(int& Start_);
};

/****************************************************************************/
class CheckWindowRef
{
  friend class CheckWindow;
  private:
    CheckWindow* _BossPtr;
    int _Index;

    CheckWindowRef(CheckWindow* Boss_, int Index_);

    Boolean Toggled();
    void ResetInputState(int status_);
    static CheckBox* CastToCheckBox(TextControl* TxtCtrl_)
	{ return ((CheckBox*)TxtCtrl_); }

  public:
    CheckWindowRef& operator = (CheckBox* Pbox_);
    operator CheckBox* ();
    CheckBox* operator -> ();
};

/****************************************************************************/
#endif

