#include <stdio.h>
#include <string.h>

#define MAXLINES 5000
char* lineptr[MAXLINES];

int readlines(char* lineptr[], int nlines);
void writelines(char* lineptr[], int nlines);

int bsearch(void* lineptr[], int left, int right, void* data,
            int(*comp)(void*, void*));
void ssort(void* lineptr[], int left, int right,
           int(*comp)(void*, void*));
void qsort(void* lineptr[], int left, int right,
           int(*comp)(void*, void*));
int numcmp(const char*, const char*);

/****************************************************************************/
// sort input lines
int main(int argc, char* argv[])
{
  int nlines;         // number of input lines read
  int numeric = 0;    // 1 if numeric sort

  if (argc > 1 && strcmp(argv[1], "-n") == 0)
    numeric = 1;

  if ((nlines = readlines(lineptr, MAXLINES)) >= 0)
  {
    qsort((void**) lineptr, 0, nlines-1,
          (int(*)(void*,void*))(numeric ? numcmp:strcmp));
    writelines(lineptr, nlines);
    return 0;
  }
  else
  {
    printf("input too big to sort\n");
    return 1;
  }
}

/****************************************************************************/
int numcmp(const char* s1, const char* s2)
{
  double v1, v2;

  v1 = atof(s1);
  v2 = atof(s2);

  if (v1 < v2)
    return -1;
  else if (v1 > v2)
    return 1;
  else
    return 0;
}

/****************************************************************************/
void swap(void* v[], int i, int j)
{
  void* temp;

  temp = v[i];
  v[i] = v[j];
  v[j] = temp;
}

/****************************************************************************/
// ssort: select sort v[left] ... v[right] into increasing order
//
void ssort(void* v[], int left, int right,
           int(*comp)(void*, void*))
{
  int x, y;
  int max = right - 1;

  for (x = left; x < max; x++)
    for (y = x + 1; y < right; y++)
      if ((*comp)(v[y], v[x]) < 0)
        swap(v, x, y);
}

/****************************************************************************/
// qsort: quick sort v[left] ... v[right] into increasing order
//
void qsort(void* v[], int left, int right,
           int(*comp)(void*, void*))
{
  int i, last;
  void swap(void* v[], int, int);

  if (left >= right)
    return;

  swap(v, left, (left + right) / 2);
  last = left;

  for (i = left+1; i <= right; i++)
    if ((*comp)(v[i], v[left]) < 0)
      swap(v, ++last, i);

  swap(v, left, last);
  qsort(v, left, last-1, comp);
  qsort(v, last+1, right, comp);
}

/****************************************************************************/
// bsearch: search v[left] ... v[right] for data, returns -1 if not found
// return index number into v where data is found otherwise.
//
int bsearch(void* v[], int left, int right, void* data,
            int(*comp)(void*, void*))
{
  int i, mid;

  if (left > right)
    return -1;

  mid = (left + right) / 2;
  if ((*comp)(data, v[mid]) < 0)
    return ((left < mid) ? bsearch(v, left, mid, data, comp):-1);
  else if ((*comp)(data, v[mid]) > 0)
    return ((mid < right) ? bsearch(v, mid, right, data, comp):-1);

  return mid;
}

/****************************************************************************/

