#ifndef CTRLDEFS_CPP
#define CTRLDEFS_CPP
#ifndef CTRLDEFS_H
  #include "ctrldefs.h"
#endif

/****************************************************************************/
ColorInfo::ColorInfo():
_UseColor(NULL),
_NormalColors(NULL),
_HighLightColors(NULL),
_HkColor(NULL),
_BackGroundColor(NULL)
{
}

/****************************************************************************/
ColorInfo::~ColorInfo()
{
  UseColor(FALSE);
  ClearAll();
}

/****************************************************************************/
void ColorInfo::ClearColors()
{
  delete[] _NormalColors;
  delete[] _HighLightColors;
  delete _HkColor;
  delete _BackGroundColor;

  _NormalColors =
  _HighLightColors =
  _HkColor =
  _BackGroundColor = NULL;
}

/****************************************************************************/
void ColorInfo::ClearAll()
{
  delete _UseColor;
  _UseColor = NULL;
  
  ClearColors();
}

/****************************************************************************/
void ColorInfo::UseColor(Boolean Flag_)
{
  if (_UseColor)
    *_UseColor = Flag_;
  else
    _UseColor = new Boolean(Flag_);

  if (!Flag_)
  {
#if (defined(__TURBOC__) | defined(__BORLANDC__) | defined(__DJGPP__))
    textcolor(LIGHTGRAY);
    textbackground(BLACK);    
#elif (defined(__linux__) | defined(__unix__))
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
#endif
  }
}

/****************************************************************************/
void ColorInfo::SetNormalColors(int FgCol_, int BgCol_)
{
  if (_NormalColors)
  {
    _NormalColors[0] = FgCol_;
    _NormalColors[1] = BgCol_;
  }
  else
  {
    _NormalColors = new int[2];
    SetNormalColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void ColorInfo::SetHighLightColors(int FgCol_, int BgCol_)
{
  if (_HighLightColors)
  {
    _HighLightColors[0] = FgCol_;
    _HighLightColors[1] = BgCol_;
  }
  else
  {
    _HighLightColors = new int[2];
    SetHighLightColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void ColorInfo::SetHotKeyColor(int Col_)
{
  if (_HkColor)
    *_HkColor = Col_;
  else
    _HkColor = new int(Col_);
}

/****************************************************************************/
void ColorInfo::SetBackGroundColor(int Col_)
{
  if (_BackGroundColor)
    *_BackGroundColor = Col_;
  else
    _BackGroundColor = new int(Col_);
}

/****************************************************************************/
Boolean ColorInfo::UsesColor() const
{
  return (_UseColor ? *_UseColor:FALSE);
}

/****************************************************************************/
int* ColorInfo::NormalColors() const
{
  return _NormalColors;
}

/****************************************************************************/
int* ColorInfo::HighLightColors() const
{
  return _HighLightColors;
}

/****************************************************************************/
int ColorInfo::HotKeyColor() const
{
  return (_HkColor ? *_HkColor:0);
}

/****************************************************************************/
int ColorInfo::BackGroundColor() const
{
  return (_BackGroundColor ? *_BackGroundColor:0);
}

/****************************************************************************/
void ColorInfo::SetupColors(int Fg_, int Bg_)
{
  if (_UseColor && *_UseColor)
  {
    textcolor(Fg_);
    textbackground(Bg_);
  }
}

/****************************************************************************/
Boolean ColorInfo::SetupColors(int Mode_)
{
  if (_UseColor && *_UseColor)
  {
    if (Mode_ == NORMAL_COLORS && _NormalColors)
    {
      SetupColors(_NormalColors[0], _NormalColors[1]);
      return TRUE;
    }
    else if (Mode_ == HIGHLIGHT_COLORS && _HighLightColors)
    {
      SetupColors(_HighLightColors[0], _HighLightColors[1]);
      return TRUE;
    }
    else if (Mode_ == BACKGROUND_COLOR && _BackGroundColor)
    {
      SetupColors(*_BackGroundColor, *_BackGroundColor);
      return TRUE;
    }
  }

  return FALSE;
}

/****************************************************************************/
/****************************************************************************/
TextControl::TextControl()
{
  GetKeyMap();
}

/****************************************************************************/
KeyMapArray& TextControl::GetKeyMap()
{
  static int KeyMapInitialized_ = 0;
  static KeyMapArray KeyMap_(TextControl::TOTAL_ACTIONS);

  if (!KeyMapInitialized_)
  {
    KeyMap_[ESCAPE].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::ESC).ASCII, FALSE);
    KeyMap_[ENTER].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::ENTER).ASCII, FALSE);
    KeyMap_[NEXT].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::TAB).ASCII, FALSE);
    KeyMap_[BACK].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::BACKSPACE).ASCII, FALSE);
    KeyMap_[DOWN].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::DOWNARROW).SCAN, TRUE);
    KeyMap_[UP].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::UPARROW).SCAN, TRUE);
    KeyMap_[RIGHT].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::RIGHTARROW).SCAN, TRUE);
    KeyMap_[LEFT].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::LEFTARROW).SCAN, TRUE);
    KeyMap_[INSERT].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::INSERT).SCAN, TRUE);
    KeyMap_[DELETE].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::DELETE).SCAN, TRUE);
    KeyMap_[HOME].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::HOME).SCAN, TRUE);
    KeyMap_[END].Assign(KeyboardCodes::CODETABLE(KeyboardCodes::END).SCAN, TRUE);

    KeyMapInitialized_ = 1;
  }

  return KeyMap_;
}

/****************************************************************************/
// PURPOSE:
//   Set Prompt message method
//
// PRE:
//   The original value of the message data member
//
// POST:
//   The message data member is assigned new memory copied from the argument
//   string.
//
char* TextControl::SetMessage_Method(const char* str, int& ShortCut_, int& HotKey_, int& HotIndex_)
{
  char* msg_ = str ? strcpy(new char[strlen(str)+1], str):NULL;
  char* Ptr_ = msg_;

  int HotFound_ = 0;
  ShortCut_ = HotKey_ = HotIndex_ = 0;

  if (msg_)
    while (Ptr_ && *Ptr_)
    {
      Ptr_ = strchr(Ptr_, '&');

      if (Ptr_)
      {
	char* Start_ = Ptr_;
	int AmpCnt_;

	for (AmpCnt_ = 0; *Ptr_ == '&'; ++Ptr_)
	  ++AmpCnt_;

	int disp_ = (Ptr_ - Start_) / 2;
	Ptr_ -= disp_;
	memmove(Start_, Ptr_, strlen(Ptr_) + 1);

	if (AmpCnt_ % 2 != 0)
	{
	  --Ptr_;

	  if (!HotFound_ && isalpha(*Ptr_))
	  {
	    ShortCut_ = KeyboardCodes::CtrlAlphaTable()[toupper(*Ptr_)];
	    HotKey_ = KeyboardCodes::AltAlphaTable()[toupper(*Ptr_)];
	    HotFound_ = TRUE;

	    Start_ = msg_;
	    for (HotIndex_ = 0; Start_ != Ptr_; ++HotIndex_)
	      ++Start_;
	  }
	}
      }
    }

  return msg_;
}

/****************************************************************************/
ColorInfo& TextControl::GetDefaultColorInfo()
{
  static ColorInfo Info_;
  static Boolean Init_ = FALSE;

  if (!Init_)
  {
    int Normals_[2] = { YELLOW, BLUE };
    int HighLights_[2] = { WHITE, BLUE };

    Info_._UseColor = new Boolean(FALSE);
    Info_._NormalColors = (int*)memmove(new int[2], Normals_, sizeof(int) * 2);
    Info_._HighLightColors = (int*)memmove(new int[2], HighLights_, sizeof(int) * 2);
#if (defined(__TURBOC__) | defined(__BORLANDC__) | defined(__DJGPP__))
    Info_._HkColor = new int(LIGHTMAGENTA);
#elif (defined(__linux__) | defined(__unix__))
    Info_._HkColor = new int(PINK);
#endif
    Info_._BackGroundColor = new int(BLUE);

    Init_ = TRUE;
  }

  return Info_;
}

/****************************************************************************/
int TextControl::VirtualBufferOffset(int* EndReached_,
                                     int* NonWsLen_,
                                     int* NonNullLen_) const
{
  if (EndReached_)
    *EndReached_ = 0;

  if (NonWsLen_)
    *NonWsLen_ = 0;

  if (NonNullLen_)
    *NonNullLen_ = 0;

  return 0;
}

/****************************************************************************/
int TextControl::VirtualBufferMax() const
{
  return 0;
}

/****************************************************************************/
int TextControl::IsChainable(bool HasChars_) const
{
  return 0;
}

/****************************************************************************/
int TextControl::ThisLength() const
{
  return 0;
}

/****************************************************************************/
int TextControl::NextLength() const
{
  return 0;
}

/****************************************************************************/
int TextControl::TakeNextLastChar(bool Peek_)
{
  return 0;
}

/****************************************************************************/
int TextControl::IsDummyLine() const
{
  return 0;
}

/****************************************************************************/
int TextControl::IsWindowLineBuffer() const
{
  return 0;
}

/****************************************************************************/
int TextControl::ChainPosition() const
{
  return 0;
}

/****************************************************************************/
int TextControl::BufferChainPosition() const
{
  return 0;
}

/****************************************************************************/
/****************************************************************************/
ControlInfo::ControlInfo(int Max_):
_HotKeys(Max_ ? new int[Max_]:NULL),
_ShortCuts(Max_ ? new int[Max_]:NULL),
_Max(Max_),
_Index(0),
_HotKeyPressed(TextControl::NONE)
{}

/****************************************************************************/
ControlInfo::~ControlInfo()
{
  delete[] _HotKeys;
  delete[] _ShortCuts;
}

/****************************************************************************/
int* ControlInfo::GrowArray(int* Array_, int Sz_)
{
  int* Olds_ = Array_;
  int NewSz_ = Sz_ += 10;

  Array_ = new int[NewSz_];
  if (Array_)
  {
    int i;
    for (i = 0; i < Sz_; ++i)
      Array_[i] = Olds_[i];

    while (i < NewSz_)
    {
      Array_[i] = 0;
      ++i;
    }
  }

  delete[] Olds_;
  return Array_;
}

/****************************************************************************/
void ControlInfo::Grow()
{
  _HotKeys = GrowArray(_HotKeys, _Max);
  _ShortCuts = GrowArray(_ShortCuts, _Max);
  _Max += 10;
}

/****************************************************************************/
void ControlInfo::ResetHotKeys()
{
  _Index = 0;
  _HotKeyPressed = TextControl::NONE;
}

/****************************************************************************/
void ControlInfo::SetHotKeys(int Index_, TextControl* TxtCtrl_)
{
  if (Index_ < 0)
    return;

  if (Index_ >= _Max)
    Grow();

  if (TxtCtrl_)
  {
    _HotKeys[Index_] = TxtCtrl_->GetHotKey();
    _ShortCuts[Index_] = TxtCtrl_->GetShortCut();
  }
  else
    _HotKeys[Index_] = _ShortCuts[Index_] = 0;
}

/****************************************************************************/
int ControlInfo::TestHotKey(int Key_)
{
  int i;
  for (i = 0; i < _Max; ++i)
    if (Key_ == _HotKeys[i])
    {
      _HotKeyPressed = TextControl::HOTKEY;
      break;
    }
    else if (Key_ == _ShortCuts[i])
    {
      _HotKeyPressed = TextControl::SHORTCUT;
      break;
    }

  if (i < _Max)
  {
    _Index = i;
    return (_Index + 1);
  }
  else
    _HotKeyPressed = TextControl::NONE;

  return 0;
}

/****************************************************************************/
void ControlWindow::ReplaceControl(TextControl* TxtCtrl_)
{}

/****************************************************************************/
#endif

