#ifndef ERRORFILE_CPP
#define ERRORFILE_CPP
#ifndef ERRORFILE_H
  #include "errorfile.h"
#endif

/****************************************************************************/
ErrorStream::ErrorStream():
_Fp(NULL),
_Fname(NULL),
_LastMessage(NULL),
_ExitMessage(NewString("Exit Code: xxxxxxxxxx")),
_WhiteSpace(MakeCset(isspace)),
_Selected(0),
_OpenDone(0),
_SharedStream(0),
_Sharing(0),
_KeepMessage(0),
_Exitted(0),
_ExitCode(0),
_AppendExitCode(0),
_QerrValue(0),
_QerrString(NULL),
_Strm(NULL)
{}

/****************************************************************************/
ErrorStream::ErrorStream(const ErrorStream& Obj_):
_Fp(NULL),
_Fname(Obj_._Fname ? NewString(Obj_._Fname):NULL),
_LastMessage(Obj_._LastMessage ? NewString(Obj_._LastMessage):NULL),
_ExitMessage(Obj_._LastMessage ? NewString(Obj_._ExitMessage):NULL),
_WhiteSpace(Obj_._WhiteSpace ? NewString(Obj_._WhiteSpace):NULL),
_Selected(Obj_._Selected),
_OpenDone(Obj_._OpenDone),
_SharedStream(0),
_Sharing((Obj_._Sharing == CLIENT_SHARE_ALL) ? CLIENT_SHARE_ALL:0),
_KeepMessage(Obj_._KeepMessage),
_Exitted(Obj_._Exitted),
_ExitCode(Obj_._ExitCode),
_AppendExitCode(Obj_._AppendExitCode),
_QerrValue(Obj_._QerrValue),
_QerrString(Obj_._QerrString ? NewString(Obj_._QerrString):NULL),
_Strm((Obj_._Sharing == CLIENT_SHARE_ALL) ? Obj_._Strm:NULL)
{
  int Done_ = _OpenDone;
  _OpenDone = 0;

  if ((_Fname && Done_) || (Obj_.ShareAll() && Obj_.ErrorStreamSelected() == FERR))
    ShareStream(Obj_._Fp);
  else
  {
    if (_Selected == CERR)
      _Cerr = Obj_._Cerr;
    else if (_Selected == QERR)
      _Qerr = Obj_._Qerr;
  }
}

/****************************************************************************/
ErrorStream::ErrorStream(const char* Fname_):
_Fp(NULL),
_Fname(Fname_ ? NewString(Fname_):NULL),
_LastMessage(NULL),
_ExitMessage(NewString("Exit Code: xxxxxxxxxx")),
_WhiteSpace(MakeCset(isspace)),
_Selected(0),
_OpenDone(0),
_SharedStream(0),
_Sharing(0),
_KeepMessage(0),
_Exitted(0),
_ExitCode(0),
_AppendExitCode(0),
_QerrValue(0),
_QerrString(NULL),
_Strm(NULL)
{
  if (_Fname)
    OpenErrorFile();
}

/****************************************************************************/
ErrorStream::~ErrorStream()
{
  RawDeleteArray(_Fname);
  RawDeleteArray(_LastMessage);
  RawDeleteArray(_ExitMessage);
  RawDeleteArray(_WhiteSpace);
  RawDeleteArray(_QerrString);
  
  if (_Fp && !_SharedStream && !ClientShareAll())
  {
    CloseErrorFile();
    delete _Fp;
  }
}

/****************************************************************************/
ErrorStream& ErrorStream::SetErrorStreamShareType(int Flag_)
{
  int SharedClient_ = _Sharing == CLIENT_SHARE_ALL;
  _Sharing = (Flag_ > 0) ?
               ((Flag_ == SHARE_STREAM) ? SHARE_STREAM:
                (Flag_ >= SHARE_ALL)    ? SHARE_ALL:0):0;

  if (SharedClient_)
    ShareErrorObject(NULL);

  if (_Sharing < SHARE_ALL)
    _Sharing = _SharedStream ? SHARE_STREAM:0;
    
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::ShareErrorObject(ErrorStream* Ptr_)
{
  if (Ptr_)
  {
    if (Ptr_->ShareAll())
    {
      _Sharing = CLIENT_SHARE_ALL;
      _Strm = Ptr_;
    }
  }
  else
  {
    _Sharing = NONE;
    _Strm = NULL;
  }
  
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetErrorOutputFile(const char* Fname_, int OpenFile_)
{
  if (ClientShareAll())
  {
    _Strm->SetErrorOutputFile(Fname_, OpenFile_);
    if (_Strm->ErrorStreamSelected() == FERR)
      ShareStream(_Strm->_Fp);
      
    return *this;
  }

  if (Fname_)
  {
    AssignTrgToSrcStr(_Fname, Fname_);

    if (OpenFile_)
      OpenErrorFile();
  }

  return *this;
}

/****************************************************************************/
void ErrorStream::ShareStream(ofstream* Fp_)
{
  if (Fp_)
  {
    if (_Fp && !_SharedStream && !ClientShareAll())
    {
      CloseErrorFile();
      delete _Fp;
    }
      
    _Fp = Fp_;
    _OpenDone = _Fp->good();
    
    _SharedStream = 1;
    if (_Sharing != SHARE_ALL && _Sharing != CLIENT_SHARE_ALL)
      _Sharing = SHARE_STREAM;
  }
}

/****************************************************************************/
int ErrorStream::OpenErrorFile()
{
  if (_Fname && strlen(_Fname))
  {
    if (!_Fp)
      _Fp = new ofstream;
    else
    {
      if (!_SharedStream && !ClientShareAll())
        CloseErrorFile();
      else
        _Fp = new ofstream;
    }
    
    _Fp->clear(ios::goodbit);
    _Fp->open(_Fname, ios::out);
    _OpenDone = _Fp->good();

    _SharedStream = 0;
    if (_Sharing != SHARE_ALL && _Sharing != CLIENT_SHARE_ALL)
      _Sharing = NONE;

    if (_OpenDone)
    {
      _Selected = FERR;
      _Ferr = _Fp;
    }
    else
      _Fp->close();

    return _OpenDone;
  }

  return 0;
}

/****************************************************************************/
int ErrorStream::CloseErrorFile()
{
  if (_Fp && !_SharedStream && !ClientShareAll())
  {
    _Fp->close();
    _OpenDone = 0;
    return _Fp->good();
  }

  return 0;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetCerrStream()
{
  if (ClientShareAll())
  {
    _Strm->SetCerrStream();
    return *this;
  }

  _Selected = CERR;
  _Cerr = &cerr;
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetQerrStream(void* Strm_)
{
  if (ClientShareAll())
  {
    _Strm->SetQerrStream(Strm_);
    return *this;
  }

  _Selected = QERR;
  _Qerr = Strm_;
  return *this;
}

/****************************************************************************/
int ErrorStream::UnExit(int Code_)
{
  if (ClientShareAll())
  {
    _Strm->UnExit(Code_);
    return Code_;
  }

  _ExitCode = Code_;
  _Exitted = 0;
  return _ExitCode;
}

/****************************************************************************/
int ErrorStream::DeferredExit(int Code_)
{
  if (ClientShareAll())
  {
    _Strm->DeferredExit(Code_);
    return Code_;
  }

  _ExitCode = Code_;
  _Exitted = 1;
  return _ExitCode;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetErrorStreamKeepMessage(int Flag_)
{
  if (ClientShareAll())
  {
    _Strm->SetErrorStreamKeepMessage(Flag_);
    return *this;
  }

  int old = _KeepMessage;
  _KeepMessage = Flag_;
  
  if (!old && Flag_)
  {
    RawDeleteArray(_LastMessage);
    _LastMessage = NULL;

    if (_AppendExitCode == 2)
      _AppendExitCode = 1;
  }
  else if (old && !Flag_ && _AppendExitCode == 1)
  {
    AppendTrgToSrcStr(_LastMessage, "\n\n");
    AppendTrgToSrcStr(_LastMessage, ErrorStreamExitMessage());
    _AppendExitCode = 2;
  }
  
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetErrorStreamAppendExitCode(int Flag_)
{
  if (ClientShareAll())
  {
    _Strm->SetErrorStreamAppendExitCode(Flag_);
    return *this;
  }

  _AppendExitCode = (Flag_ > 0) ? 1:0;
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SendToQerr(const char* String_)
{
  ReplaceString(_QerrString, String_);
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SendToQerr(int Value_)
{
  _QerrValue = Value_;
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::operator = (const ErrorStream& Obj_)
{
  if (this != &Obj_)
  {
    RawDeleteArray(_Fname);
    _Fname = Obj_._Fname ? NewString(Obj_._Fname):NULL;

    if (!_LastMessage ||
         (Obj_._LastMessage && strcmp(_LastMessage, Obj_._LastMessage) != 0))
      _LastMessage = Obj_._LastMessage ? NewString(Obj_._LastMessage):NULL;

    if (!_ExitMessage ||
         (Obj_._ExitMessage && strcmp(_ExitMessage, Obj_._ExitMessage) != 0))
      _ExitMessage = Obj_._ExitMessage ? NewString(Obj_._ExitMessage):NULL;

    if (!_WhiteSpace ||
         (Obj_._WhiteSpace && strcmp(_WhiteSpace, Obj_._WhiteSpace) != 0))
      _WhiteSpace = Obj_._WhiteSpace ? NewString(Obj_._WhiteSpace):NULL;
    
    _Selected = Obj_._Selected;
    _OpenDone = Obj_._OpenDone;
    _KeepMessage = Obj_._KeepMessage;
    _Exitted = Obj_._Exitted;
    _ExitCode = Obj_._ExitCode;
    _AppendExitCode = Obj_._AppendExitCode;
    _QerrValue = Obj_._QerrValue;

    if (!_QerrString ||
         (Obj_._QerrString && strcmp(_QerrString, Obj_._QerrString) != 0))
      _QerrString = Obj_._QerrString ? NewString(Obj_._QerrString):NULL;

    if (Obj_._Sharing == CLIENT_SHARE_ALL)
    {
      _Sharing = CLIENT_SHARE_ALL;
      _Strm = Obj_._Strm;      
    }

    int Done_ = _OpenDone;
    _OpenDone = 0;

    if ((_Fname && Done_) || (Obj_.ShareAll() && Obj_.ErrorStreamSelected() == FERR))
      ShareStream(Obj_._Fp);
    else
    {
      if (_Selected == CERR)
        _Cerr = Obj_._Cerr;
      else if (_Selected == QERR)
        _Qerr = Obj_._Qerr;
    }  
  }

  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SendToErrorStream(const char* String_)
{
  if (ClientShareAll())
  {
    _Strm->SendToErrorStream(String_);
    return *this;
  }
  
  if (_Selected == FERR && strspn(String_, _WhiteSpace) < strlen(String_))
    if (_KeepMessage)
      AppendTrgToSrcStr(_LastMessage, String_);
    else
      AssignTrgToSrcStr(_LastMessage, String_);

  if (_Selected == CERR)
    *_Cerr <<String_;
  else if (_Selected == FERR)
    *_Ferr <<String_;
  else if (_Selected == QERR)
    SendToQerr(String_);

  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SendToErrorStream(double Value_, int Prec_)
{
  if (ClientShareAll())
  {
    _Strm->SendToErrorStream(Value_, Prec_);
    return *this;
  }

  char* String_ = FloatToStr(Value_, NULL, 0, Prec_);
  if (_Selected == FERR)
    if (_KeepMessage)
      AppendTrgToSrcStr(_LastMessage, String_);
    else
      AssignTrgToSrcStr(_LastMessage, String_);

  if (_Selected == CERR)
    *_Cerr <<String_;
  else if (_Selected == FERR)
    *_Ferr <<String_;
  else if (_Selected == QERR)
    SendToQerr(String_);

  ::DeleteArray(String_);
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SendToErrorStream(int Value_)
{
  if (ClientShareAll())
  {
    _Strm->SendToErrorStream(Value_);
    return *this;
  }

  char* String_ = IntToStr(Value_, NULL);
  if (_Selected == FERR)
    if (_KeepMessage)
      AppendTrgToSrcStr(_LastMessage, String_);
    else
      AssignTrgToSrcStr(_LastMessage, String_);

  if (_Selected == CERR)
    *_Cerr <<Value_;
  else if (_Selected == FERR)
    *_Ferr <<Value_;
  else if (_Selected == QERR)
    SendToQerr(Value_);

  ::DeleteArray(String_);
  return *this;
}

/****************************************************************************/
ErrorStream& ErrorStream::SetErrorStream(int Code_, const char* Fname_, void* Qstream_)
{
  if (ClientShareAll())
  {
    _Strm->SetErrorStream(Code_, Fname_, Qstream_);
    return *this;
  }

  if (Code_ == CERR)
    SetCerrStream();
  else if (Code_ == FERR)
    SetErrorOutputFile(Fname_, TRUE);
  else if (Code_ == QERR)
    SetQerrStream(Qstream_);

  return *this;
}

/****************************************************************************/
int ErrorStream::ErrorStreamKeepMessage() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamKeepMessage():_KeepMessage);
}

/****************************************************************************/
int ErrorStream::ErrorStreamAppendExitCode() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamAppendExitCode():_AppendExitCode);
}

/****************************************************************************/
int ErrorStream::ErrorStreamSelected() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamSelected():_Selected);
}

/****************************************************************************/
int ErrorStream::ErrorStreamOpened() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamOpened():_OpenDone);
}

/****************************************************************************/
int ErrorStream::ErrorStreamExitCode() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamExitCode():_ExitCode);
}

/****************************************************************************/
int ErrorStream::ErrorStreamExitted() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamExitted():_Exitted);
}

/****************************************************************************/
const char* ErrorStream::ErrorStreamExitMessage() const
{
  if (ClientShareAll())
    return _Strm->ErrorStreamExitMessage();

  IntToStr(_ExitCode, _ExitMessage+EXIT_CODESTR_START);
  return _ExitMessage;
}

/****************************************************************************/
const char* ErrorStream::ErrorStreamLastMessage() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamLastMessage():_LastMessage);
}

/****************************************************************************/
const char* ErrorStream::ErrorStreamQerrString() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamQerrString():_QerrString);
}

/****************************************************************************/
int ErrorStream::ErrorStreamQerrValue() const
{
  return (ClientShareAll() ? _Strm->ErrorStreamQerrValue():_QerrValue);
}

/****************************************************************************/
#if ERRORFILE_DEBUG
int main()
{
  int Sent_ = 5;
  int BSent_ = 5;
  int Received_ = 11;
  int BReceived_ = 11;
  const char* Fname_ = "errors.out";
  
  ErrorStream st;
  ErrorStream st2;
  st.SetErrorStream(ErrorStream::CERR);
  st.SetErrorStreamShareType(ErrorStream::SHARE_ALL);

  st.SendToErrorStream("ERROR: cards received does not match cards sent\n");
  st.SendToErrorStream("cards received=");
  st.SendToErrorStream(Received_ + BReceived_);
  st.SendToErrorStream(" sent=");
  st.SendToErrorStream(Sent_ + BSent_);
  st.SendToErrorStream("\n");

  st.SetErrorStream(ErrorStream::FERR, Fname_);
  st2.ShareErrorObject(&st);

  st2.SetErrorStreamAppendExitCode(1);
  st2.SetErrorStreamKeepMessage(1);
  st2.SendToErrorStream("ERROR: cards received does not match cards sent\n");
  st2.SendToErrorStream("cards received=");
  st2.SendToErrorStream(Received_ + BReceived_);
  st2.SendToErrorStream(" sent=");
  st2.SendToErrorStream(Sent_ + BSent_);
  st2.SendToErrorStream("\n");
  st2.DeferredExit(-3);
  st2.SetErrorStreamKeepMessage(0);

  cout <<st2.ErrorStreamLastMessage() <<endl;
  cout <<st2.ErrorStreamExitMessage() <<endl;
  
  return 0;
}
#endif
/****************************************************************************/
#endif
