#ifndef ERRORFILE_H
#define ERRORFILE_H
#ifndef STRFILE_H
  #include "strfile.h"
#endif

#define ERRORFILE_DEBUG         0

/****************************************************************************/
//class ostream;
using std::cerr;
using std::ostream;
using std::ofstream;

class ErrorStream
{
  protected:
    char* _Fname;
    char* _LastMessage;
    char* _ExitMessage;
    char* _WhiteSpace;
    ofstream* _Fp;
    int _Selected;
    int _OpenDone;
    int _SharedStream;
    int _Sharing;
    int _KeepMessage;

    int _Exitted;
    int _ExitCode;
    int _AppendExitCode;

    int _QerrValue;
    char* _QerrString;
    ErrorStream* _Strm;    
  
    union
    {
      ostream* _Cerr;
      ofstream* _Ferr;
      void* _Qerr;
    };

    void ShareStream(ofstream* Fp_);
  
  public:
    enum
    {
      NONE = 0,
    
      CERR,
      FERR,
      QERR
    };

    enum
    {
      SHARE_STREAM     = 1,
      SHARE_ALL        = 2,
      CLIENT_SHARE_ALL = 4,

      EXIT_CODESTR_START = 11
    };

    ErrorStream();
    ErrorStream(const ErrorStream& Obj_);
    ErrorStream(const char* Fname_);
    virtual ~ErrorStream();

    ErrorStream& SetCerrStream();
    ErrorStream& SetErrorStreamShareType(int Flag_);
    ErrorStream& SetErrorStreamKeepMessage(int Flag_);
    ErrorStream& SetErrorStreamAppendExitCode(int Flag_);
    ErrorStream& ShareErrorObject(ErrorStream* Ptr_);
    ErrorStream& SetErrorOutputFile(const char* Fname_, int OpenFile_);
    int OpenErrorFile();
    int CloseErrorFile();

    virtual ErrorStream& SetQerrStream(void* Strm_);
    virtual ErrorStream& SendToQerr(const char* String_);
    virtual ErrorStream& SendToQerr(int Value_);
    virtual ErrorStream& SendToErrorStream(const char* String_);
    virtual ErrorStream& SendToErrorStream(double Value_, int Prec_=6);
    virtual ErrorStream& SendToErrorStream(int Value_);

    virtual ErrorStream& operator = (const ErrorStream& Obj_);
    virtual ErrorStream& SetErrorStream(int Code_,
                                        const char* Fname_=NULL,
                                        void* Qstream_=NULL);

    virtual const char* ErrorStreamQerrString() const;
    virtual int ErrorStreamQerrValue() const;

    int DeferredExit(int Code_);
    int UnExit(int Code_=0);
    
    int ErrorStreamSelected() const;
    int ErrorStreamOpened() const;
    int ErrorStreamExitCode() const;
    int ErrorStreamExitted() const;
    int ErrorStreamKeepMessage() const;
    int ErrorStreamAppendExitCode() const;
    const char* ErrorStreamLastMessage() const;
    const char* ErrorStreamExitMessage() const;    
    
    int ErrorStreamShareType() const
        { return _Sharing; }
    int ClientShareAll() const
        { return (_Sharing == 4); }
    int ShareAll() const
        { return (_Sharing == 2); }
    ErrorStream* SharedErrorObject()
        { return _Strm; }
};

/****************************************************************************/
#endif
