#ifndef FULLDATE_CPP
#define FULLDATE_CPP
#ifndef FULLDATE_H
  #include "fulldate.h"
#endif

int FullDate::_Century = 0;
bool FullDate::_AssumeTimet = true;

/****************************************************************************/
FullDate::FullDate():
_DayText(NULL),
_MonthText(NULL)
{
  MakeDayText();
  MakeMonthText();
  
  DateStuff::Today(_Year, _Month, _Day);
  
  if (!_Century)
    _Century = _Year / 100;
}

/****************************************************************************/
FullDate::FullDate(const FullDate& Obj_):
_DayText(NULL),
_MonthText(NULL)
{
  MakeDayText();
  MakeMonthText();

  _Year = Obj_.GetYear();
  _Month = Obj_.GetMonth();
  _Day = Obj_.GetDay();
  
  if (!_Century)
    _Century = _Year / 100;

  assert(IsValid());  
}

/****************************************************************************/
FullDate::FullDate(const Date& Obj_):
_DayText(NULL),
_MonthText(NULL)
{
  MakeDayText();
  MakeMonthText();

  _Year = Obj_.GetYear();
  _Month = Obj_.GetMonth();
  _Day = Obj_.GetDay();
  
  if (!_Century)
    _Century = _Year / 100;

  assert(IsValid());
}

/****************************************************************************/
FullDate::FullDate(const ChrString& s):
_DayText(NULL),
_MonthText(NULL)
{
  MakeDayText();
  MakeMonthText();
  
  DateStuff::FromString(s, _Year, _Month, _Day);
  
  if (!_Century)
    _Century = _Year / 100;
  
  if (!IsEmpty() && !IsValidYMDay())
    xDateError();    
}

/****************************************************************************/
FullDate::FullDate(int year, int month, int day):
_DayText(NULL),
_MonthText(NULL)
{
  MakeDayText();
  MakeMonthText();
  
  _Year = year;
  _Month = month;
  _Day = day;

  if (!_Century)
    _Century = _Year / 100;

  if (!IsEmpty() && !IsValidYMDay())
    xDateError();
}

/****************************************************************************/
FullDate::~FullDate()
{
  int x;
  for (x = 0; x < 14; x++)
    ::DeleteArray(_DayText[x]);

  for (x = 0; x < 24; x++)
    ::DeleteArray(_MonthText[x]);

  ::DeleteArray(_DayText);
  ::DeleteArray(_MonthText);
}

/****************************************************************************/
void FullDate::SetCentury(int Year_)
{
  _Century = Year_;
  _Century /= 100;
}

/****************************************************************************/
void FullDate::SetCentury(const char* Year_)
{
  _Century = atoi(Year_);
  _Century /= 100;
}

/****************************************************************************/
void FullDate::MakeMonthText()
{
  _MonthText = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * 25);
  
  _MonthText[0] = new_char_string("January");
  _MonthText[1] = new_char_string("February");
  _MonthText[2] = new_char_string("March");
  _MonthText[3] = new_char_string("April");
  _MonthText[4] = new_char_string("May");
  _MonthText[5] = new_char_string("June");
  _MonthText[6] = new_char_string("July");
  _MonthText[7] = new_char_string("August");
  _MonthText[8] = new_char_string("September");
  _MonthText[9] = new_char_string("October");
  _MonthText[10] = new_char_string("November");
  _MonthText[11] = new_char_string("December");

  _MonthText[12] = new_char_string("Jan");
  _MonthText[13] = new_char_string("Feb");
  _MonthText[14] = new_char_string("Mar");
  _MonthText[15] = new_char_string("Apr");
  _MonthText[16] = new_char_string("May");
  _MonthText[17] = new_char_string("Jun");
  _MonthText[18] = new_char_string("Jul");
  _MonthText[19] = new_char_string("Aug");
  _MonthText[20] = new_char_string("Sep");
  _MonthText[21] = new_char_string("Oct");
  _MonthText[22] = new_char_string("Nov");
  _MonthText[23] = new_char_string("Dec");
  
  _MonthText[24] = NULL;
}

/****************************************************************************/
void FullDate::MakeDayText()
{
  _DayText = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * 15);
  
  _DayText[0] = new_char_string("Monday");
  _DayText[1] = new_char_string("Tuesday");
  _DayText[2] = new_char_string("Wednesday");
  _DayText[3] = new_char_string("Thursday");
  _DayText[4] = new_char_string("Friday");
  _DayText[5] = new_char_string("Saturday");
  _DayText[6] = new_char_string("Sunday");

  _DayText[7] = new_char_string("Mon");
  _DayText[8] = new_char_string("Tue");
  _DayText[9] = new_char_string("Wed");
  _DayText[10] = new_char_string("Thu");
  _DayText[11] = new_char_string("Fri");
  _DayText[12] = new_char_string("Sat");
  _DayText[13] = new_char_string("Sun");
  
  _DayText[14] = NULL;
}

/****************************************************************************/
const char* FullDate::GiveMonthNumStr(const char* Month_)
{
  char Buf_[32];
  strncpy(Buf_, Month_, 31);
  Buf_[31] = 0;
  RemovePadding(Buf_, " \t");
  
  return
  (
    (StriComp(Buf_, "January") == 0 ||
     StriComp(Buf_, "Jan") == 0)         ? "01":
    (StriComp(Buf_, "February") == 0 ||
     StriComp(Buf_, "Feb") == 0)         ? "02":
    (StriComp(Buf_, "March") == 0 ||
     StriComp(Buf_, "Mar") == 0)         ? "03":
    (StriComp(Buf_, "April") == 0 ||
     StriComp(Buf_, "Apr") == 0)         ? "04":
    StriComp(Buf_, "May") == 0           ? "05":
    (StriComp(Buf_, "June") == 0 ||
     StriComp(Buf_, "Jun") == 0)         ? "06":
    (StriComp(Buf_, "July") == 0 ||
     StriComp(Buf_, "Jul") == 0)         ? "07":
    (StriComp(Buf_, "August") == 0 ||
     StriComp(Buf_, "Aug") == 0)         ? "08":
    (StriComp(Buf_, "September") == 0 ||
     StriComp(Buf_, "Sep") == 0)         ? "09":
    (StriComp(Buf_, "October") == 0 ||
     StriComp(Buf_, "Oct") == 0)         ? "10":
    (StriComp(Buf_, "November") == 0 ||
     StriComp(Buf_, "Nov") == 0)         ? "11":
    (StriComp(Buf_, "December") == 0 ||
     StriComp(Buf_, "Dec") == 0)         ? "12":NULL
  );
}

/****************************************************************************/
const char* FullDate::GiveDayNumStr(const char* Day_)
{
  char Buf_[32];
  strncpy(Buf_, Day_, 31);
  Buf_[31] = 0;
  RemovePadding(Buf_, " \t");

  if (strlen(Day_) < 2)
  {
    return
    (
      (*Day_ == '1') ? "01":
      (*Day_ == '2') ? "02":
      (*Day_ == '3') ? "03":
      (*Day_ == '4') ? "04":
      (*Day_ == '5') ? "05":
      (*Day_ == '6') ? "06":
      (*Day_ == '7') ? "07":
      (*Day_ == '8') ? "08":
      (*Day_ == '9') ? "09":NULL
    );    
  }

  return Day_;
}

/****************************************************************************/
char* FullDate::TransformDate(char* DateString_, char* NewStr_, int Century_, bool AssumeTimet_)
{
  char* tok;
  int x, off, len;
  int yr2;
  int daydone = 0;
  int yrdone = 0;
  const char* temps_;
  char Buffer_[64];
  char Day_[8];
  char Month_[8];
  char Year_[8];
  char Str_[8];
  char saved_;
  
  strncpy(Buffer_, DateString_, 63);
  Buffer_[63] = 0;
  len = strlen(Buffer_);

  if (!Century_)
  {
    Century_ = _Century;
    AssumeTimet_ = _AssumeTimet;
  }

  if (!len)
  {
    if (NewStr_)
      NewStr_[0] = 0;
      
    return NewStr_;
  }

  // 29Jul11
  // 29July11
  // 29July2011
  // Jul2911
  // July2911
  // July292011
  // 11Jul29
  // 11July29
  // 2011July29

  // Date Form: July 19, 2011
  // Date Form: 19 July, 2011
  // Date Form: 2011, July 19
  if (strchr(Buffer_, ',') || strchr(Buffer_, ' '))
  {
    for (x = 0, (tok=strtok(Buffer_, " ,")); tok && x < 3; (tok=strtok(0, " ,")), x++)
    {
      if (x == 0)
      {
        if (isdigit(*tok))
        {
          if (strlen(tok) <= 2)
          {
            daydone = 1;
            temps_ = GiveDayNumStr(tok);
            strcpy(Day_, temps_);
          }
          else
          {
            yrdone = 1;
            temps_ = RemovePadding(tok, " \t");
            strcpy(Year_, temps_);

            if (strlen(Year_) == 2)
            {
              yr2 = atoi(Year_);
              memmove(Year_ + 2, Year_, 3);

              // century = 21st if year before 70th, else 20th century
              if (AssumeTimet_)
              {
                if (yr2 < 70)
                {
                  if (Century_ >= 20)
                    IntToStr(Century_, Str_);
                  else
                    IntToStr(20, Str_);

                  memcpy(Year_, Str_, 2);
                }
                else
                  memcpy(Year_, "19", 2);
              }
              else
              {
                IntToStr(Century_, Str_);
                memcpy(Year_, Str_, 2);
              }
            }
          }
        }
        else
        {
          temps_ = GiveMonthNumStr(tok);
          strcpy(Month_, temps_);
        }
      }
      else if (x == 1)
      {
        if (isalpha(*tok))
        {
          temps_ = GiveMonthNumStr(tok);
          strcpy(Month_, temps_);        
        }
        else
        {
          if (strlen(tok) <= 2 && !daydone)
          {        
            daydone = 1;
            temps_ = GiveDayNumStr(tok);
            strcpy(Day_, temps_);
          }
          else if (!yrdone)
          {
            yrdone = 1;
            temps_ = RemovePadding(tok, " \t");
            strcpy(Year_, temps_);

            if (strlen(Year_) == 2)
            {
              yr2 = atoi(Year_);
              memmove(Year_ + 2, Year_, 3);

              // century = 21st if year before 70th, else 20th century
              if (AssumeTimet_)
              {              
                if (yr2 < 70)
                {
                  if (Century_ >= 20)
                    IntToStr(Century_, Str_);
                  else
                    IntToStr(20, Str_);

                  memcpy(Year_, Str_, 2);
                }
                else
                  memcpy(Year_, "19", 2);
              }
              else
              {
                IntToStr(Century_, Str_);
                memcpy(Year_, Str_, 2);
              }
            }
          }
        }
      }
      else if (x == 2 && !yrdone)
      {
        yrdone = 1;
        temps_ = RemovePadding(tok, " \t");
        strcpy(Year_, temps_);

        if (strlen(Year_) == 2)
        {
          yr2 = atoi(Year_);        
          memmove(Year_ + 2, Year_, 3);

          // century = 21st if year before 70th, else 20th century
          if (AssumeTimet_)
          {
            if (yr2 < 70)
            {
              if (Century_ >= 20)
                IntToStr(Century_, Str_);
              else
                IntToStr(20, Str_);
                
              memcpy(Year_, Str_, 2);
            }            
            else
              memcpy(Year_, "19", 2);
          }
          else
          {
            IntToStr(Century_, Str_);
            memcpy(Year_, Str_, 2);
          }
        }
      }
    }
  }
  else if (isdigit(*Buffer_))
  {
    x = len - 1;

    if (isdigit(Buffer_[x]))    
      if (isdigit(Buffer_[3]))
      {
        // Date Form: 2011July29
        strncpy(Year_, Buffer_, 4);
        Buffer_[4] = 0;
        tok = Buffer_ + x - 1;
        saved_ = *tok;
        *tok = 0;
        strcpy(Month_, Buffer_ + 4);
        *tok = saved_;
        temps_ = GiveMonthNumStr(Month_);
        strcpy(Month_, temps_);
        strcpy(Day_, tok);
        x = 3;        
      }
      else
      {
        if (isdigit(Buffer_[x-3]))
          off = 3;    // Date Form: 29July2011
        else if (isdigit(Buffer_[x-1]))
          off = 1;    // Date Form: 29July11

        len = isdigit(Buffer_[1]) ? 2:1;
        strncpy(Day_, Buffer_, len);
        Day_[len] = 0;        
        tok = Buffer_ + x - off;
        saved_ = *tok;
        *tok = 0;
        strcpy(Month_, Buffer_ + len);
        *tok = saved_;
        temps_ = GiveMonthNumStr(Month_);
        strcpy(Month_, temps_);
        strcpy(Year_, tok);

        if (off == 1)
        {
          yr2 = atoi(Year_);
          memmove(Year_ + 2, Year_, 3);

          // century = 21st if year before 70th, else 20th century
          if (AssumeTimet_)
          {
            if (yr2 < 70)
            {
              if (Century_ >= 20)
                IntToStr(Century_, Str_);
              else
                IntToStr(20, Str_);
                
              memcpy(Year_, Str_, 2);
            }
            else
              memcpy(Year_, "19", 2);
          }
          else
          {
            IntToStr(Century_, Str_);
            memcpy(Year_, Str_, 2);          
          }
        }
        x = 3;
      }
  }
  else if (isalpha(*Buffer_))
  {
    x = len - 1;
  
    if (isdigit(Buffer_[x]))
    {
      if (isdigit(Buffer_[x-5]))      
        off = 5;      // Date Form: July292011
      else if (isdigit(Buffer_[x-4]))
        off = 4;      // Date Form: July22011        
      else if (isdigit(Buffer_[x-3]))
        off = 3;      // Date Form: July2911
      else if (isdigit(Buffer_[x-2]))
        off = 2;      // Date Form: July211

      len = (off == 5 || off == 3) ? 2:1;
      tok = Buffer_ + x - off;
      saved_ = *tok;
      *tok = 0;
      strcpy(Month_, Buffer_);
      *tok = saved_;
      temps_ = GiveMonthNumStr(Month_);
      strcpy(Month_, temps_);
      strncpy(Day_, tok, len);
      Day_[len] = 0;
      tok += len;
      strcpy(Year_, tok);

      if (off == 3 || off == 2)
      {
        yr2 = atoi(Year_);
        memmove(Year_ + 2, Year_, 3);

        // century = 21st if year before 70th, else 20th century
        if (AssumeTimet_)
        {
          if (yr2 < 70)
          {
            if (Century_ >= 20)
              IntToStr(Century_, Str_);
            else
              IntToStr(20, Str_);
                
            memcpy(Year_, Str_, 2);
          }
          else
            memcpy(Year_, "19", 2);
        }
        else
        {
          IntToStr(Century_, Str_);
          memcpy(Year_, Str_, 2);
        }
      }      
      x = 3;
    }
  }
  
  if (x == 3)
  {
    if (!NewStr_)
      NewStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 20);
      
    strcpy(NewStr_, Year_);
    strcat(NewStr_, Month_);
    strcat(NewStr_, Day_);
  }

  return NewStr_;
}

/****************************************************************************/
const char* FullDate::GiveDayText(int Dow_)
{
  if (0 <= Dow_ && Dow_ <= 6)
    return _DayText[Dow_];

  return NULL;
}

/****************************************************************************/
const char* FullDate::GiveBriefDayText(int Dow_)
{
  if (0 <= Dow_ && Dow_ <= 6)
    return _DayText[MAX_DAYS_OF_WEEK+Dow_];

  return NULL;
}

/****************************************************************************/
const char* FullDate::GiveMonthText(int Moy_)
{
  if (0 <= Moy_ && Moy_ <= 11)
    return _MonthText[Moy_];

  return NULL;
}

/****************************************************************************/
const char* FullDate::GiveBriefMonthText(int Moy_)
{
  if (0 <= Moy_ && Moy_ <= 11)
    return _MonthText[MAX_MONTH_OF_YEAR+Moy_];

  return NULL;
}

/****************************************************************************/
FullDate& FullDate::operator = (const FullDate& Obj_)
{
  if (this != &Obj_)
  {
    Date::operator = (Obj_);

    if (!_Century)
      _Century = _Year / 100;
  }

  return *this;
}

/****************************************************************************/
#endif




