#ifndef FULLDATE_H
#define FULLDATE_H
#ifndef DATE_H
  #include "date.h"
#endif

/****************************************************************************/
class FullDate : public Date
{
  protected:
    static int _Century;
    static bool _AssumeTimet;
    
    char** _DayText;
    char** _MonthText;

    static const char* GiveDayNumStr(const char* Day_);
    static const char* GiveMonthNumStr(const char* Month_);
      
  public:
    enum
    {
      MAX_DAYS_OF_WEEK = 7,
      MAX_MONTH_OF_YEAR = 12,
      
      MIN_MONTH_DAYS = 28,
      MAX_MONTH_DAYS = 31,
      MIN_YEAR_DAYS = 365,
      MAX_YEAR_DAYS = 366
    };
  
    FullDate();
    FullDate(const FullDate& Obj_);
    FullDate(const Date& Obj_);
    FullDate(const ChrString& s);
    FullDate(int y, int m, int d);
    ~FullDate();

    FullDate& operator = (const FullDate& Obj_);

    const char* GiveDayText(int Dow_);
    const char* GiveBriefDayText(int Dow_);

    const char* GiveMonthText(int Moy_);
    const char* GiveBriefMonthText(int Moy_);

    void MakeDayText();
    void MakeMonthText();
    
    static void SetCentury(int Year_);
    static void SetCentury(const char* Year_);
    static char* TransformDate(char* DateString_, char* NewStr_, int Century_=0, bool AssumeTimet=true);
    
    Boolean IsValid() const
        { return (IsEmpty() || DateStuff::IsValidYMDay(_Year, _Month, _Day)); }
    long ToJul() const
        { return DateStuff::GregToJul(_Year, _Month, _Day); }
};

/****************************************************************************/
#endif




