#include "globalswitch.h"

char* CalcGlobalSwitch::_PrintChSet = NULL;

/****************************************************************************/
// CalcGlobalSwitch class definitions
/****************************************************************************/
CalcGlobalSwitch::CalcGlobalSwitch():
_MathExprLine(NULL),
_SwitchStr(NULL),
_GlobalSwitchFlag(NULL),

_NextSwitchStrIndex(0),
_SwWordMult(0),
_NoSwitchPosShift(0),
_SearchStrIndex(0),

_LeftBrk(false),
_SwitchChkDone(false),
_SwitchCmdFound(false),
_SwitchCmdIgnored(false),
_SearchResetDone(true),

_SwitchStart(NULL),
_SwitchExt(NULL),
_LeftBrkStart(NULL),
_EndBrkStart(NULL),
_PostSwitchStart(NULL)
{
  if (!_PrintChSet)
    _PrintChSet = MakeCharSet(isprint);
}

/****************************************************************************/
CalcGlobalSwitch::~CalcGlobalSwitch()
{
  ::RawDeleteArray(_SwitchStr);
  _SwitchStr = NULL;

  if (_PrintChSet)
  {
    ::RawDeleteArray(_PrintChSet);
    _PrintChSet = NULL;
  }
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::ResetSwitchCheckData()
{
  _MathExprLine = NULL;
  
  _NextSwitchStrIndex = 0;
  _SwWordMult = 0;
  _NoSwitchPosShift = 0;
  _SearchStrIndex = 0;
  
  _LeftBrk = false;
  _SwitchChkDone = false;
  _SwitchCmdFound = false;
  _SwitchCmdIgnored = false;
  _SearchResetDone = true;
  
  _SwitchStart = NULL;
  _SwitchExt = NULL;
  _LeftBrkStart = NULL;
  _EndBrkStart = NULL;
  _PostSwitchStart = NULL;
  
  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::ResetSwitchCheckDone()
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _SwitchChkDone = false;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetExprLineIndex(int v)
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _SearchStrIndex = v;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitch(const char* SwitchStr_)
{
  ::RawDeleteArray(_SwitchStr);
  _SwitchStr = ::NewString(SwitchStr_);
  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetMathExprLine(char* Line_)
{
  if (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag))
    _MathExprLine = Line_;

  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitchAddress(int* addr)
{
  _GlobalSwitchFlag = addr;
  return this;
}

/****************************************************************************/
CalcGlobalSwitch* CalcGlobalSwitch::SetGlobalSwitchProcessed(int v)
{
  if (_GlobalSwitchFlag)
  {
    *_GlobalSwitchFlag = v;
    _SearchResetDone = !v && !_SwitchCmdIgnored && !_SwitchCmdFound;
  }
  
  return this;
}

/****************************************************************************/
void CalcGlobalSwitch::SetSwitchCmdFound(bool v)
{
  _SwitchCmdFound = v;
  _SearchResetDone = !v && !_SwitchCmdIgnored &&
                     (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag));
}

/****************************************************************************/
void CalcGlobalSwitch::SetSwitchCmdIgnored(bool v)
{
  _SwitchCmdIgnored = v;
  _SearchResetDone = !v && !_SwitchCmdFound &&
                     (!_GlobalSwitchFlag || !(*_GlobalSwitchFlag));
}

/****************************************************************************/
int CalcGlobalSwitch::PosShiftToNoSwitchStr(bool DecLoopIndex_) const
{
  return ((DecLoopIndex_ && _NoSwitchPosShift) ? (_NoSwitchPosShift - 1):_NoSwitchPosShift);
}

/*****************************************************************************/
int CalcGlobalSwitch::IsLeftBrkSymbols(char symbol)
{
  return
  (
    symbol=='(' ||
    symbol=='[' ||
    symbol=='{'
  );
}

/****************************************************************************/
char* CalcGlobalSwitch::FindEndBrk(bool LbFound_, char* str)
{
  if (!LbFound_ || !str)
    return NULL;
  
  int brkbal = 1;
  int cbpos = 0;
  int max = ::SafeStrLen(str);
  int x = 0;

  for (++x; x < max && brkbal; x++)
  {
    if (str[x] == '(')
      brkbal++;
    else if (str[x] == ')')
    {
      brkbal--;
      cbpos = !brkbal ? x:0;
    }
  }
  
  if (cbpos)
    return &str[cbpos];
  
  return NULL;
}

/****************************************************************************/
char* CalcGlobalSwitch::FindPostSwitchStart(char* str)
{
  if (!str)
    return NULL;
  
  if (*str)
  for (++str; *str && (isspace(*str) || *str == ';'); str++);
  
  return str;
}

/****************************************************************************/
bool CalcGlobalSwitch::CheckForSwitch(bool SwitchFound_)
{
  if (_GlobalSwitchFlag && *_GlobalSwitchFlag)
    return false;

  int x;
  int slen;
  int swptindex_;
  int SwStrLen_ = 0;
  int ListLen_ = 0;
  
  char* oldswpt;
  char* list = _MathExprLine;
  char* listpt;
  char* CharSet_ = _PrintChSet;

  bool StrMatch_ = false;
  bool HasNextSwitchStr_ = false;

  if (list)
  {
    if (_SearchStrIndex > 0)
      list += _SearchStrIndex;
  
    SwStrLen_ = strlen(_SwitchStr);
    ListLen_ = strlen(list);

    if (ListLen_ <= SwStrLen_)
    {
      _SwitchChkDone = true;
      return false;
    }
  }
  else
  {
    _SwitchChkDone = true;
    return false;
  }
  
  if (!_SwitchChkDone)
  {
    _SwitchChkDone = true;
    StrMatch_ = StrniComp(list, _SwitchStr, SwStrLen_) == 0 && isspace(list[SwStrLen_]);
    HasNextSwitchStr_ = StrMatch_ && isspace(list[SwStrLen_]);
    _NextSwitchStrIndex = HasNextSwitchStr_ ? ::StrHasChar(&list[SwStrLen_], CharSet_):
                          (StrMatch_ &&
                           IsLeftBrkSymbols(list[SwStrLen_])) ? 0:-1;
    HasNextSwitchStr_ = _NextSwitchStrIndex != -1;
    _LeftBrk = _NextSwitchStrIndex == 0 && list[SwStrLen_] == '(';
    _SwWordMult = HasNextSwitchStr_ ? 1:0;
    
    oldswpt = list;
    swptindex_ = 0;
    _NextSwitchStrIndex += SwStrLen_;
    _NoSwitchPosShift = HasNextSwitchStr_ ? _NextSwitchStrIndex:0;
  
    if (!_LeftBrk && HasNextSwitchStr_)
    {
      listpt = &list[_NextSwitchStrIndex];
      slen = strlen(listpt);
      for (x = 0; x < slen && isspace(*listpt); listpt++, x++);

      while (*listpt && StrniComp(listpt, _SwitchStr, SwStrLen_) == 0)
      {
        _SwWordMult++;
        oldswpt = listpt;
        swptindex_ = _NextSwitchStrIndex + x;
        listpt += SwStrLen_;
        for (x += SwStrLen_; x < slen && isspace(*listpt); listpt++, x++);
      }

      _LeftBrk = IsLeftBrkSymbols(*listpt);

      if (_LeftBrk || InCharSet(*listpt, CharSet_))
        _NextSwitchStrIndex += x;
    
      if (x > 0 && _SwWordMult > 1)
        _NoSwitchPosShift = _NextSwitchStrIndex;
    }
          
    if (HasNextSwitchStr_)
    {            
      SwitchFound_ =
      _SwitchCmdFound = true;
      _SwitchCmdIgnored = false;

      _LeftBrk = IsLeftBrkSymbols(list[_NextSwitchStrIndex]);
      _SwitchStart = oldswpt;
      _SwitchExt = !_LeftBrk ? &list[_NextSwitchStrIndex]:NULL;
      _LeftBrkStart = _LeftBrk ? &list[_NextSwitchStrIndex]:NULL;
      _EndBrkStart = FindEndBrk(_LeftBrk, _LeftBrkStart);
      _PostSwitchStart = FindPostSwitchStart(_EndBrkStart);
      
      _NextSwitchStrIndex = swptindex_;
      _NextSwitchStrIndex += _SearchStrIndex;
      _NoSwitchPosShift += _SearchStrIndex;
    }
  }
  
  return SwitchFound_;
}

/****************************************************************************/
void CalcGlobalSwitch::PrintAllData(ostream& os)
{
    if (_SwitchStr)
      os <<"GlobalSwitch: " <<_SwitchStr <<endl;
    
    if (_MathExprLine)
    {
      os <<"MathExprLine: " <<_MathExprLine <<endl;

      if (_SearchStrIndex >= 0)
        os <<"&MathExprLine[SearchStrIndex]: "
           <<&_MathExprLine[_SearchStrIndex] <<endl;
    }

    os <<endl;
    os <<"SwitchCheckDone(): "       <<SwitchCheckDone()       <<endl;
    os <<"SwitchCmdFound(): "        <<SwitchCmdFound()        <<endl;
    os <<"SwitchCmdIgnored(): "      <<SwitchCmdIgnored()      <<endl;
    os <<"HasLeftBrk(): "            <<HasLeftBrk()            <<endl <<endl;

    os <<"SwitchWordMultiples(): "   <<SwitchWordMultiples()        <<endl;    
    os <<"LastSwitchStrIndex(): "    <<LastSwitchStrIndex()         <<endl;
    os <<"PosShiftToNoSwitchStr(): " <<PosShiftToNoSwitchStr(false) <<endl <<endl;

    if (GetSwitchStart())
      os <<"GetSwitchStart(): "  <<GetSwitchStart() <<endl;
    
    if (GetSwitchExt())
      os <<"GetSwitchExt(): "    <<GetSwitchExt() <<endl;
    
    if (GetLeftBrkStart())
      os <<"GetLeftBrkStart(): " <<GetLeftBrkStart() <<endl;
    
    if (GetEndBrkStart())
      os <<"GetEndBrkStart(): "  <<GetEndBrkStart() <<endl;
    
    if (GetPostSwitchStart())
      os <<"GetPostSwitchStart(): "  <<GetPostSwitchStart() <<endl <<endl;
}

/****************************************************************************/
int main()
{
  int i;
  int len; 
  bool GraphFound_ = false;
  bool LeftBrk_ = false;
  char* list;
  
  CalcGlobalSwitch* _GlobalGraphSwitch = new CalcGlobalSwitch();
  _GlobalGraphSwitch->SetGlobalSwitch("GRAPH");
  
  list = ::NewString("GRAPH(-(x^2) + 4, x);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("GRAPH GRAPH GRAPH(x^(4/3) * sqr(x+2), x);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph solve(cube(x)-3*sqr(x)+4/3,x,0);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph deriv((3-2*x-sqr(x))/(sqr(x)-1),x,2);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph deriv2((3-2*x-sqr(x))/(sqr(x)-1),x,2);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph integ(-sqr(x)+2*x+3,x,-1,3);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph Fmin(cube(x)-3*sqr(x)+x+3,x,-1,3);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph Fmax(cube(x)-3*sqr(x)+x+3,x,-1,3,EXCLUDE ENDS);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  cout <<"-----------------------------------------------------------" <<endl;
  list = ::NewString("graph intersect(3-sqr(x),sqr(x)-3,x,-3,3);");
  len = strlen(list);
  _GlobalGraphSwitch->ResetSwitchCheckData();
  
  for (i = 0; i < len; i++)
  {
    if (!GraphFound_)
      _GlobalGraphSwitch->ResetSwitchCheckDone();

    if (isalpha(list[i]) && InRange('A', list[i], 'z'))    
      if (!_GlobalGraphSwitch->SwitchCheckDone())
      {
        _GlobalGraphSwitch->SetExprLineIndex(i)
                          ->SetMathExprLine(&list[i]);
        GraphFound_ = _GlobalGraphSwitch->CheckForSwitch(GraphFound_);

        if (GraphFound_)
          break;
      }
  }
  
  if (GraphFound_)
    _GlobalGraphSwitch->PrintAllData(cout);
  else
    cout <<"Graph Not Found" <<endl;
  
  ::RawDeleteArray(list);
  
  return 0;
}
