#ifndef STRUTIL_H
  #include "strutil.h"
#endif

class CalcGlobalSwitch
{
  protected:
    char* _MathExprLine;
    char* _SwitchStr;
    int* _GlobalSwitchFlag;

    int _NextSwitchStrIndex;
    int _SwWordMult;
    int _NoSwitchPosShift;
    int _SearchStrIndex;

    bool _LeftBrk;
    bool _SwitchChkDone;
    bool _SwitchCmdFound;
    bool _SwitchCmdIgnored;
    bool _SearchResetDone;

    char* _SwitchStart;
    char* _SwitchExt;
    char* _LeftBrkStart;
    char* _EndBrkStart;
    char* _PostSwitchStart;

    static char* _PrintChSet;

    char* FindEndBrk(bool LbFound_, char* str);
    char* FindPostSwitchStart(char* str);

    int IsLeftBrkSymbols(char symbol);

  public:
    CalcGlobalSwitch();
    ~CalcGlobalSwitch();

    CalcGlobalSwitch* SetGlobalSwitchAddress(int* addr);
    CalcGlobalSwitch* SetGlobalSwitchProcessed(int v);    
    CalcGlobalSwitch* ResetSwitchCheckDone();
    CalcGlobalSwitch* ResetSwitchCheckData();
    CalcGlobalSwitch* SetGlobalSwitch(const char* SwitchStr_);
    CalcGlobalSwitch* SetMathExprLine(char* Line_);
    CalcGlobalSwitch* SetExprLineIndex(int v);

    bool CheckForSwitch(bool SwitchFound_);
    void PrintAllData(ostream& os);

    void SetSwitchCmdFound(bool v);
    void SetSwitchCmdIgnored(bool v);
    
    inline bool SwitchCheckDone() const
        { return _SwitchChkDone; }    
    inline bool SwitchCmdFound() const
        { return _SwitchCmdFound; }
    inline bool SwitchCmdIgnored() const
        { return _SwitchCmdIgnored; }
    inline bool HasLeftBrk() const
        { return _LeftBrk; }
    inline bool SearchResetDone() const
        { return _SearchResetDone; }

    inline int SwitchWordMultiples() const
        { return _SwWordMult; }
    inline int LastSwitchStrIndex() const
        { return ((_SwitchChkDone && _SwitchCmdFound) ? _NextSwitchStrIndex:0); }
    int PosShiftToNoSwitchStr(bool DecLoopIndex_) const;

    inline const char* GetMathExprLine() const
        { return _MathExprLine; }
    
    inline char* GetSwitchStart()
        { return _SwitchStart; }
    inline char* GetSwitchExt()
        { return _SwitchExt; }
    inline char* GetLeftBrkStart()
        { return _LeftBrkStart; }
    inline char* GetEndBrkStart()
        { return _EndBrkStart; }
    inline char* GetPostSwitchStart()
        { return _PostSwitchStart; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
