#ifndef KEYMAP_CPP
#define KEYMAP_CPP
#ifndef KEYMAP_H
  #include "keymap.h"
#endif

/****************************************************************************/
// Limited to 65534 codes for 16 bits
KeyNode::KeyNode():
_Limit(1),
_Size(0),
_Codes(new int)
{}

/****************************************************************************/
KeyNode::KeyNode(const KeyNode& Obj_):
_Limit(Obj_._Limit),
_Size(Obj_._Size),
_Codes((int*)memmove(new int[Obj_._Limit], Obj_._Codes, Obj_._Size * sizeof(int)))
{}

/****************************************************************************/
KeyNode::KeyNode(int Sz_):
_Limit(Sz_),
_Size(0),
_Codes(new int[Sz_])
{}

/****************************************************************************/
KeyNode::~KeyNode()
{
  delete[] _Codes;
  _Codes = NULL;
}

/****************************************************************************/
int KeyNode::MatchCode(int Code_, int Extend_) const
{
  int i;

  if (Extend_)
  {
    for (i = 0; i < _Size; ++i)
      if (_Codes[i] == Code_ + 256)
	return (i + 1);
  }
  else
  {
    for (i = 0; i < _Size; ++i)
      if (_Codes[i] == Code_)
	return (i + 1);
  }

  return 0;
}

/****************************************************************************/
KeyNode& KeyNode::Assign(int Code_, int Ext_)
{
  _Size = 1;
  *_Codes = Code_ + (Ext_ ? 256:0);
  return *this;
}

/****************************************************************************/
KeyNode& KeyNode::Add(int Code_, int Ext_)
{
  int i;

  for (i = 0; i < _Size; ++i)
    if (!_Codes[i])
    {
      _Codes[i] = Code_ + (Ext_ ? 256:0);
      break;
    }

  if (i == _Size)
  {
    if (_Size >= _Limit)
    {
      int NewLimit_ = _Limit *= 2;
      int* OldArr_ = _Codes;

      _Codes = new int[NewLimit_];
      for (i = 0; i < _Size; ++i)
	_Codes[i] = OldArr_[i];

      _Limit = NewLimit_;
    }

    _Codes[_Size] = Code_ + (Ext_ ? 256:0);
    ++_Size;
  }

  return *this;
}

/****************************************************************************/
KeyNode& KeyNode::Remove(int Code_, int Ext_)
{
  int Index_;
  if (Index_ = MatchCode(Code_, Ext_))
    _Codes[--Index_] = 0;

  return *this;
}

/****************************************************************************/
KeyNode& KeyNode::operator = (const KeyNode& Obj_)
{
  delete[] _Codes;
  _Size = Obj_._Size;
  _Limit = Obj_._Limit;
  _Codes = (int*)memmove(new int[_Limit], Obj_._Codes, _Size * sizeof(int));

  return *this;
}

/****************************************************************************/
/****************************************************************************/
KeyMapArray::KeyMapArray():
_Array(NULL),
_Max(0)
{}

/****************************************************************************/
KeyMapArray::KeyMapArray(const KeyMapArray& Obj_):
_Array(new KeyNode[Obj_._Max]),
_Max(Obj_._Max)
{
  int i;
  for (i = 0; i < _Max; ++i)
    _Array[i] = Obj_._Array[i];
}

/****************************************************************************/
KeyMapArray::KeyMapArray(int Size_):
_Array(new KeyNode[Size_]),
_Max(Size_)
{}

/****************************************************************************/
KeyMapArray::~KeyMapArray()
{
  delete[] _Array;
}

/****************************************************************************/
void KeyMapArray::SetSize(int Size_)
{
  delete[] _Array;

  _Array = new KeyNode[Size_];
  _Max = Size_;
}

/****************************************************************************/
int KeyMapArray::KeyMatch(int Key_, int Index_, int Ext_) const
{
  if (Index_ >= 0 && Index_ < _Max)
    return _Array[Index_].MatchCode(Key_, Ext_);

  return 0;
}

/****************************************************************************/
KeyMapArray& KeyMapArray::operator = (const KeyMapArray& Obj_)
{
  _Max = Obj_._Max;
  _Array = new KeyNode[_Max];

  int i;
  for (i = 0; i < _Max; ++i)
    _Array[i] = Obj_._Array[i];

  return *this;
}

/****************************************************************************/
#endif

