#ifndef KEYMAP_H
#define KEYMAP_H
#ifndef __STRING_H
  #include <string.h>
  #define __STRING_H
#endif
#ifndef __STDLIB_H
  #include <stdlib.h>
  #define __STDLIB_H
#endif

/****************************************************************************/
class KeyNode
{
  protected:
    int _Size;
    int _Limit;
    int* _Codes;

  public:
    KeyNode();
    KeyNode(const KeyNode& Obj_);
    KeyNode(int Sz_);
    ~KeyNode();

    int MatchCode(int Code_, int Ext_) const;
    KeyNode& Assign(int Code_, int Ext_);
    KeyNode& Add(int Code_, int Ext_);
    KeyNode& Remove(int Code_, int Ext_);
    inline const int* GetCodes() const
	{ return _Codes; }
    inline int Size() const
	{ return _Size; }

    KeyNode& operator = (const KeyNode& Obj_);
};

class KeyMapArray
{
  protected:
    int _Max;
    KeyNode* _Array;

  public:
    KeyMapArray();
    KeyMapArray(const KeyMapArray& Obj_);
    KeyMapArray(int Size_);
    ~KeyMapArray();

    void SetSize(int Size_);
    int KeyMatch(int Key_, int Index_, int Ext_ = 0) const;

    inline int Size() const
	{ return _Max; }
    inline KeyNode& operator [] (int Index_)
	{ return _Array[Index_]; }

    KeyMapArray& operator = (const KeyMapArray& Obj_);
};

/****************************************************************************/
#endif

