#ifndef LISTDEFN_CPP
#define LISTDEFN_CPP
#ifndef LISTDEFN_H
  #include "listdefn.h"
#endif

/****************************************************************************/
/****************************************************************************/
ListOperation* ListOperation::MakeListOpsImpl(ListOperation* This_)
{
  return
  (
    This_->IsLinkedList()   ? (new ListOperationImpl):
    This_->IsStack()        ? (new StackOperationImpl):
    This_->IsQueue()        ? (new QueueOperationImpl):
    This_->IsDeque()        ? (new DequeOperationImpl):
                              (ListOperation*)NULL
  );
}

/****************************************************************************/
ListOperation* ListOperation::MakeListOpsImpl(ListOperation* This_, const ListOperation& Copy_)
{
  return
  (
    This_->IsLinkedList()   ? (new ListOperationImpl(Copy_)):
    This_->IsStack()        ? (new StackOperationImpl(Copy_)):
    This_->IsQueue()        ? (new QueueOperationImpl(Copy_)):
    This_->IsDeque()        ? (new DequeOperationImpl(Copy_)):
                              (ListOperation*)NULL
  );
}

/****************************************************************************/
char ListOperation::OpToChar(int op)
{
  return
  (
    (op == PUSH)      ? 'P':
    (op == POP)       ? 'X':
    (op == ENQUEUE)   ? 'E':
    (op == DEQUEUE)   ? 'D':
    (op == INSERT)    ? 'I':
    (op == DETACH)    ? 'T':'0'
  );
}

/****************************************************************************/
void ListOperation::DumpListData(int(*dispfn)(const void*, int), ostream* osp_)
{}

/****************************************************************************/
void ListOperation::ReNumberList()
{}

/****************************************************************************/
bool ListOperation::IsLinkedList() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsNumbered() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsStack() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsQueue() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsDeque() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsPopped() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsPushed() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsEnqueued() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsDequeued() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsInserted() const
{ return false; }

/****************************************************************************/
bool ListOperation::IsDetached() const
{ return false; }

/****************************************************************************/
size_t ListOperation::TimesPopped() const
{ return 0; }

/****************************************************************************/
size_t ListOperation::TimesPushed() const
{ return 0; }

/****************************************************************************/
size_t ListOperation::TimesEnqueued() const
{ return 0; }

/****************************************************************************/
size_t ListOperation::TimesDequeued() const
{ return 0; }

/****************************************************************************/
size_t ListOperation::TimesInserted() const
{ return 0; }

/****************************************************************************/
size_t ListOperation::TimesDetached() const
{ return 0; }

/****************************************************************************/
MEMORYOPS_DEFN(ListOperation)

/****************************************************************************/
/****************************************************************************/
ListOperationImpl::ListOperationImpl(bool Numbered_):
_OpVectIndex(0),
_OpVectLimit(VECTSIZE_INCR),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * VECTSIZE_INCR)),
_NumVect(Numbered_ ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * VECTSIZE_INCR):NULL),
_TimesDetached(0),
_TimesInserted(0),
_CurrentOp(NULL)
{
  _CurrentOp = &_TimesDetached;
}

/****************************************************************************/
ListOperationImpl::ListOperationImpl(const ListOperation& Obj_):
_OpVectIndex(Obj_.OpsListIndex()),
_OpVectLimit(Obj_.OpsListLimit()),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * Obj_.OpsListLimit())),
_NumVect(Obj_.IsNumbered() ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * Obj_.OpsListLimit()):NULL),
_TimesDetached(Obj_.TimesDetached()),
_TimesInserted(Obj_.TimesInserted()),
_CurrentOp(NULL)
{
  _CurrentOp = Obj_.IsDetached() ? &_TimesDetached:&_TimesInserted;
}

/****************************************************************************/
ListOperationImpl::~ListOperationImpl()
{
  ::RawDeleteArray(_OpVect);
  _OpVect = NULL;

  if (_NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void ListOperationImpl::GrowOpsList()
{
  size_t x;
  char* OldList_ = _OpVect;
  size_t* OldNumList_ = _NumVect;
  size_t OldSz_ = _OpVectLimit;

  _OpVectLimit += VECTSIZE_INCR;
  _OpVect = (char*)MemMatrix::Matrix().Callocate(sizeof(char) * _OpVectLimit);
  if (OldNumList_)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);

  for (x = 0; x < OldSz_; x++)
  {
    _OpVect[x] = OldList_[x];

    if (OldNumList_)
      _NumVect[x] = OldNumList_[x];
  }

  while (x < _OpVectLimit)
  {
    _OpVect[x] = 0;

    if (OldNumList_)
      _NumVect[x] = 0;
      
    ++x;
  }

  ::RawDeleteArray(OldList_);
  if (OldNumList_)
    ::RawDeleteArray(OldNumList_);
}

/****************************************************************************/
size_t ListOperationImpl::OpsListLimit() const
{
  return _OpVectLimit;
}

/****************************************************************************/
size_t ListOperationImpl::OpsListIndex() const
{
  return _OpVectIndex;
}

/****************************************************************************/
size_t ListOperationImpl::Size() const
{
  return (_Container ? _Container->Size():0);
}

/****************************************************************************/
void ListOperationImpl::SetNumberedList(bool Flag_)
{
  if (Flag_ && !_NumVect)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);
  else if (!Flag_ && _NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void ListOperationImpl::DumpVectorData(ostream* osp_)
{
  if (osp_)
  {
    size_t x;
    size_t max = 0;
    bool ovdone = false;
    bool nvdone = false;
    bool dispovdone = false;
    bool dispnvdone = false;

    cout <<"operation:";
    for (x = 0; x <= _OpVectIndex; x++)
    {      
      if (_OpVect[x])
      {
        if (x && dispovdone)
          *osp_ <<",";
          
        *osp_ <<OpToChar(_OpVect[x]);
        dispovdone = true;
        max = x;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          ovdone = true;
        }
      }
      else if (!ovdone && dispovdone)
      {
        *osp_ <<endl;
        ovdone = true;
      }
    }

    if (!ovdone)
      cout <<endl;

    cout <<"node num:";
    for (x = 0; x <= max; x++)
    {    
      if (_NumVect[x] || x == 0 || dispnvdone)
      {
        if (x && dispnvdone)
          *osp_ <<",";

        *osp_ <<_NumVect[x];
        dispnvdone = true;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          nvdone = true;
        }
      }
      else if (!nvdone && dispnvdone)
      {
        *osp_ <<endl;
        nvdone = true;
      }
    }

    if (!nvdone)
      cout <<endl;
  }
}

/****************************************************************************/
void ListOperationImpl::StoreOpToList(int OpType_, size_t NodeNum_)
{
  char op = (char)OpType_;

  if (op == ListOperationEnums::DETACH ||
      op == ListOperationEnums::INSERT)
  {
    if (!_OpVect[_OpVectIndex])
    {
      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }
    else
    {
      ++_OpVectIndex;
      if (_OpVectIndex >= _OpVectLimit)
        GrowOpsList();

      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }

    if (_OpVect[_OpVectIndex])
    {
      if (_OpVect[_OpVectIndex] == ListOperationEnums::DETACH)
      {
        _TimesDetached++;
        _CurrentOp = &_TimesDetached;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::INSERT)
      {
        _TimesInserted++;
        _CurrentOp = &_TimesInserted;
      }
    }
  }
}

/****************************************************************************/
int ListOperationImpl::LastOp() const
{
  return _OpVect[_OpVectIndex];
}

/****************************************************************************/
int ListOperationImpl::FirstOp() const
{
  return _OpVect[0];
}

/****************************************************************************/
int ListOperationImpl::OpAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _OpVect[Index_]:0);
}

/****************************************************************************/
int ListOperationImpl::LastNodeNum() const
{
  return _NumVect[_OpVectIndex];
}

/****************************************************************************/
int ListOperationImpl::FirstNodeNum() const
{
  return _NumVect[0];
}

/****************************************************************************/
int ListOperationImpl::NodeNumAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _NumVect[Index_]:0);
}

/****************************************************************************/
size_t ListOperationImpl::TotalOps() const
{
  return (_OpVect[_OpVectIndex] ? (_OpVectIndex+1):_OpVectIndex);
}

/****************************************************************************/
void ListOperationImpl::DeleteAll()
{
  int x;
  size_t max = _OpVectLimit;
  _OpVectIndex = 0;
  
  for (x = 0; x < max; x++)
  {
    _OpVect[x] = 0;

    if (_NumVect)
      _NumVect[x] = 0;
  }
}

/****************************************************************************/
bool ListOperationImpl::IsNumbered() const
{
  return (_NumVect != NULL);
}

/****************************************************************************/
bool ListOperationImpl::IsLinkedList() const
{
  return true;
}

/****************************************************************************/
bool ListOperationImpl::IsDetached() const
{
  return (_Container->Size() == 0 || (_CurrentOp == &_TimesDetached));
}

/****************************************************************************/
bool ListOperationImpl::IsInserted() const
{
  return (_Container->Size() > 0 && (_CurrentOp == &_TimesInserted));
}

/****************************************************************************/
size_t ListOperationImpl::TimesDetached() const
{
  return _TimesDetached;
}

/****************************************************************************/
size_t ListOperationImpl::TimesInserted() const
{
  return _TimesInserted;
}

/****************************************************************************/
MEMORYOPS_DEFN(ListOperationImpl)

/****************************************************************************/
/****************************************************************************/
StackOperationImpl::StackOperationImpl(bool Numbered_):
_OpVectIndex(0),
_OpVectLimit(VECTSIZE_INCR),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * VECTSIZE_INCR)),
_NumVect(Numbered_ ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * VECTSIZE_INCR):NULL),
_TimesPopped(0),
_TimesPushed(0),
_CurrentOp(NULL)
{
  _CurrentOp = &_TimesPopped;
}

/****************************************************************************/
StackOperationImpl::StackOperationImpl(const ListOperation& Obj_):
_OpVectIndex(Obj_.OpsListIndex()),
_OpVectLimit(Obj_.OpsListLimit()),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * Obj_.OpsListLimit())),
_NumVect(Obj_.IsNumbered() ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * Obj_.OpsListLimit()):NULL),
_TimesPopped(Obj_.TimesPopped()),
_TimesPushed(Obj_.TimesPushed()),
_CurrentOp(NULL)
{
  _CurrentOp = Obj_.IsPopped() ? &_TimesPopped:&_TimesPushed;
}

/****************************************************************************/
StackOperationImpl::~StackOperationImpl()
{
  ::RawDeleteArray(_OpVect);
  _OpVect = NULL;

  if (_NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void StackOperationImpl::GrowOpsList()
{
  size_t x;
  char* OldList_ = _OpVect;
  size_t* OldNumList_ = _NumVect;
  size_t OldSz_ = _OpVectLimit;

  _OpVectLimit += VECTSIZE_INCR;
  _OpVect = (char*)MemMatrix::Matrix().Callocate(sizeof(char) * _OpVectLimit);
  if (OldNumList_)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);

  for (x = 0; x < OldSz_; x++)
  {
    _OpVect[x] = OldList_[x];

    if (OldNumList_)
      _NumVect[x] = OldNumList_[x];
  }

  while (x < _OpVectLimit)
  {
    _OpVect[x] = 0;

    if (OldNumList_)
      _NumVect[x] = 0;
      
    ++x;
  }

  ::RawDeleteArray(OldList_);
  if (OldNumList_)
    ::RawDeleteArray(OldNumList_);
}

/****************************************************************************/
size_t StackOperationImpl::OpsListLimit() const
{
  return _OpVectLimit;
}

/****************************************************************************/
size_t StackOperationImpl::OpsListIndex() const
{
  return _OpVectIndex;
}

/****************************************************************************/
size_t StackOperationImpl::Size() const
{
  return (_Container ? _Container->Size():0);
}

/****************************************************************************/
bool StackOperationImpl::IsNumbered() const
{
  return (_NumVect != NULL);
}

/****************************************************************************/
void StackOperationImpl::SetNumberedList(bool Flag_)
{
  if (Flag_ && !_NumVect)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);
  else if (!Flag_ && _NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void StackOperationImpl::DumpVectorData(ostream* osp_)
{
  if (osp_)
  {
    size_t x;
    size_t max = 0;
    bool ovdone = false;
    bool nvdone = false;
    bool dispovdone = false;
    bool dispnvdone = false;

    cout <<"operation:";
    for (x = 0; x <= _OpVectIndex; x++)
    {
      if (_OpVect[x])
      {
        if (x && dispovdone)
          *osp_ <<",";
          
        *osp_ <<OpToChar(_OpVect[x]);
        dispovdone = true;
        max = x;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          ovdone = true;
        }
      }
      else if (!ovdone && dispovdone)
      {
        *osp_ <<endl;
        ovdone = true;
      }
    }

    if (!ovdone)
      cout <<endl;

    cout <<"num node:";
    for (x = 0; x <= max; x++)
    {
      if (_NumVect[x] || x == 0 || dispnvdone)
      {
        if (x && dispnvdone)
          *osp_ <<",";

        *osp_ <<_NumVect[x];
        dispnvdone = true;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          nvdone = true;
        }
      }
      else if (!nvdone && dispnvdone)
      {
        *osp_ <<endl;
        nvdone = true;
      }
    }

    if (!nvdone)
      cout <<endl;
  }
}

/****************************************************************************/
void StackOperationImpl::StoreOpToList(int OpType_, size_t NodeNum_)
{
  char op = (char)OpType_;

  if (op == ListOperationEnums::POP ||
      op == ListOperationEnums::PUSH)
  {
    if (!_OpVect[_OpVectIndex])
    {
      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }
    else
    {
      ++_OpVectIndex;
      if (_OpVectIndex >= _OpVectLimit)
        GrowOpsList();

      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }

    if (_OpVect[_OpVectIndex])
    {
      if (_OpVect[_OpVectIndex] == ListOperationEnums::POP)
      {
        _TimesPopped++;
        _CurrentOp = &_TimesPopped;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::PUSH)
      {
        _TimesPushed++;
        _CurrentOp = &_TimesPushed;
      }
    }
  }
}

/****************************************************************************/
int StackOperationImpl::LastOp() const
{
  return _OpVect[_OpVectIndex];
}

/****************************************************************************/
int StackOperationImpl::FirstOp() const
{
  return _OpVect[0];
}

/****************************************************************************/
int StackOperationImpl::OpAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _OpVect[Index_]:0);
}

/****************************************************************************/
int StackOperationImpl::LastNodeNum() const
{
  return _NumVect[_OpVectIndex];
}

/****************************************************************************/
int StackOperationImpl::FirstNodeNum() const
{
  return _NumVect[0];
}

/****************************************************************************/
int StackOperationImpl::NodeNumAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _NumVect[Index_]:0);
}

/****************************************************************************/
size_t StackOperationImpl::TotalOps() const
{
  return (_OpVect[_OpVectIndex] ? (_OpVectIndex+1):_OpVectIndex);
}

/****************************************************************************/
void StackOperationImpl::DeleteAll()
{
  int x;
  size_t max = _OpVectLimit;
  _OpVectIndex = 0;
  
  for (x = 0; x < max; x++)
  {
    _OpVect[x] = 0;

    if (_NumVect)
      _NumVect[x] = 0;
  }
}

/****************************************************************************/
bool StackOperationImpl::IsStack() const
{
  return true;
}

/****************************************************************************/
bool StackOperationImpl::IsPopped() const
{
  return (_Container->Size() == 0 || (_CurrentOp == &_TimesPopped));
}

/****************************************************************************/
bool StackOperationImpl::IsPushed() const
{
  return (_Container->Size() > 0 && (_CurrentOp == &_TimesPushed));
}

/****************************************************************************/
size_t StackOperationImpl::TimesPopped() const
{
  return _TimesPopped;
}

/****************************************************************************/
size_t StackOperationImpl::TimesPushed() const
{
  return _TimesPushed;
}

/****************************************************************************/
MEMORYOPS_DEFN(StackOperationImpl)

/****************************************************************************/
/****************************************************************************/
QueueOperationImpl::QueueOperationImpl(bool Numbered_):
_OpVectIndex(0),
_OpVectLimit(VECTSIZE_INCR),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * VECTSIZE_INCR)),
_NumVect(Numbered_ ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * VECTSIZE_INCR):NULL),
_TimesDequeued(0),
_TimesEnqueued(0),
_CurrentOp(NULL)
{
  _CurrentOp = &_TimesDequeued;
}

/****************************************************************************/
QueueOperationImpl::QueueOperationImpl(const ListOperation& Obj_):
_OpVectIndex(Obj_.OpsListIndex()),
_OpVectLimit(Obj_.OpsListLimit()),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * Obj_.OpsListLimit())),
_NumVect(Obj_.IsNumbered() ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * Obj_.OpsListLimit()):NULL),
_TimesDequeued(Obj_.TimesDequeued()),
_TimesEnqueued(Obj_.TimesEnqueued()),
_CurrentOp(NULL)
{
  _CurrentOp = Obj_.IsDequeued() ? &_TimesDequeued:&_TimesEnqueued;
}

/****************************************************************************/
QueueOperationImpl::~QueueOperationImpl()
{
  ::RawDeleteArray(_OpVect);
  _OpVect = NULL;

  if (_NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void QueueOperationImpl::GrowOpsList()
{
  size_t x;
  char* OldList_ = _OpVect;
  size_t* OldNumList_ = _NumVect;
  size_t OldSz_ = _OpVectLimit;

  _OpVectLimit += VECTSIZE_INCR;
  _OpVect = (char*)MemMatrix::Matrix().Callocate(sizeof(char) * _OpVectLimit);
  if (OldNumList_)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);

  for (x = 0; x < OldSz_; x++)
  {
    _OpVect[x] = OldList_[x];

    if (OldNumList_)
      _NumVect[x] = OldNumList_[x];
  }

  while (x < _OpVectLimit)
  {
    _OpVect[x] = 0;

    if (OldNumList_)
      _NumVect[x] = 0;
      
    ++x;
  }

  ::RawDeleteArray(OldList_);
  if (OldNumList_)
    ::RawDeleteArray(OldNumList_);
}

/****************************************************************************/
size_t QueueOperationImpl::OpsListLimit() const
{
  return _OpVectLimit;
}

/****************************************************************************/
size_t QueueOperationImpl::OpsListIndex() const
{
  return _OpVectIndex;
}

/****************************************************************************/
size_t QueueOperationImpl::Size() const
{
  return (_Container ? _Container->Size():0);
}

/****************************************************************************/
bool QueueOperationImpl::IsNumbered() const
{
  return (_NumVect != NULL);
}

/****************************************************************************/
void QueueOperationImpl::SetNumberedList(bool Flag_)
{
  if (Flag_ && !_NumVect)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);
  else if (!Flag_ && _NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void QueueOperationImpl::DumpVectorData(ostream* osp_)
{
  if (osp_)
  {
    size_t x;
    size_t max = 0;
    bool ovdone = false;
    bool nvdone = false;
    bool dispovdone = false;
    bool dispnvdone = false;

    cout <<"operation:";
    for (x = 0; x <= _OpVectIndex; x++)
    {
      if (_OpVect[x])
      {
        if (x && dispovdone)
          *osp_ <<",";
          
        *osp_ <<OpToChar(_OpVect[x]);
        dispovdone = true;
        max = x;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          ovdone = true;
        }
      }
      else if (!ovdone && dispovdone)
      {
        *osp_ <<endl;
        ovdone = true;
      }
    }

    if (!ovdone)
      cout <<endl;

    cout <<"num node:";
    for (x = 0; x <= max; x++)
    {
      if (_NumVect[x] || x == 0 || dispnvdone)
      {
        if (x && dispnvdone)
          *osp_ <<",";

        *osp_ <<_NumVect[x];
        dispnvdone = true;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          nvdone = true;
        }
      }
      else if (!nvdone && dispnvdone)
      {
        *osp_ <<endl;
        nvdone = true;
      }
    }

    if (!nvdone)
      cout <<endl;
  }
}

/****************************************************************************/
void QueueOperationImpl::StoreOpToList(int OpType_, size_t NodeNum_)
{
  char op = (char)OpType_;

  if (op == ListOperationEnums::DEQUEUE ||
      op == ListOperationEnums::ENQUEUE)
  {
    if (!_OpVect[_OpVectIndex])
    {
      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }
    else
    {
      ++_OpVectIndex;
      if (_OpVectIndex >= _OpVectLimit)
        GrowOpsList();

      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }

    if (_OpVect[_OpVectIndex])
    {
      if (_OpVect[_OpVectIndex] == ListOperationEnums::DEQUEUE)
      {
        _TimesDequeued++;
        _CurrentOp = &_TimesDequeued;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::ENQUEUE)
      {
        _TimesEnqueued++;
        _CurrentOp = &_TimesEnqueued;
      }
    }
  }
}

/****************************************************************************/
int QueueOperationImpl::LastOp() const
{
  return _OpVect[_OpVectIndex];
}

/****************************************************************************/
int QueueOperationImpl::FirstOp() const
{
  return _OpVect[0];
}

/****************************************************************************/
int QueueOperationImpl::OpAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _OpVect[Index_]:0);
}

/****************************************************************************/
int QueueOperationImpl::LastNodeNum() const
{
  return _NumVect[_OpVectIndex];
}

/****************************************************************************/
int QueueOperationImpl::FirstNodeNum() const
{
  return _NumVect[0];
}

/****************************************************************************/
int QueueOperationImpl::NodeNumAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _NumVect[Index_]:0);
}

/****************************************************************************/
size_t QueueOperationImpl::TotalOps() const
{
  return (_OpVect[_OpVectIndex] ? (_OpVectIndex+1):_OpVectIndex);
}

/****************************************************************************/
void QueueOperationImpl::DeleteAll()
{
  int x;
  size_t max = _OpVectLimit;
  _OpVectIndex = 0;
  
  for (x = 0; x < max; x++)
  {
    _OpVect[x] = 0;

    if (_NumVect)
      _NumVect[x] = 0;
  }
}

/****************************************************************************/
bool QueueOperationImpl::IsQueue() const
{
  return true;
}

/****************************************************************************/
bool QueueOperationImpl::IsDequeued() const
{
  return (_Container->Size() == 0 || (_CurrentOp == &_TimesDequeued));
}

/****************************************************************************/
bool QueueOperationImpl::IsEnqueued() const
{
  return (_Container->Size() > 0 && (_CurrentOp == &_TimesEnqueued));
}

/****************************************************************************/
size_t QueueOperationImpl::TimesDequeued() const
{
  return _TimesDequeued;
}

/****************************************************************************/
size_t QueueOperationImpl::TimesEnqueued() const
{
  return _TimesEnqueued;
}

/****************************************************************************/
MEMORYOPS_DEFN(QueueOperationImpl)

/****************************************************************************/
/****************************************************************************/
DequeOperationImpl::DequeOperationImpl(bool Numbered_):
_OpVectIndex(0),
_OpVectLimit(VECTSIZE_INCR),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * VECTSIZE_INCR)),
_NumVect(Numbered_ ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * VECTSIZE_INCR):NULL),
_TimesPopped(0),
_TimesPushed(0),
_TimesDequeued(0),
_TimesEnqueued(0),
_CurrentOp(NULL)
{
  _CurrentOp = &_TimesDequeued;
}

/****************************************************************************/
DequeOperationImpl::DequeOperationImpl(const ListOperation& Obj_):
_OpVectIndex(Obj_.OpsListIndex()),
_OpVectLimit(Obj_.OpsListLimit()),
_OpVect((char*)MemMatrix::Matrix().Callocate(sizeof(char) * Obj_.OpsListLimit())),
_NumVect(Obj_.IsNumbered() ? (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * Obj_.OpsListLimit()):NULL),
_TimesPopped(Obj_.TimesPopped()),
_TimesPushed(Obj_.TimesPushed()),
_TimesDequeued(Obj_.TimesDequeued()),
_TimesEnqueued(Obj_.TimesEnqueued()),
_CurrentOp(NULL)
{
  _CurrentOp = Obj_.IsDequeued() ? &_TimesDequeued:
               Obj_.IsPopped()   ? &_TimesPopped:
               Obj_.IsEnqueued() ? &_TimesEnqueued:
                                   &_TimesPushed;
}

/****************************************************************************/
DequeOperationImpl::~DequeOperationImpl()
{
  ::RawDeleteArray(_OpVect);
  _OpVect = NULL;

  if (_NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void DequeOperationImpl::GrowOpsList()
{
  size_t x;
  char* OldList_ = _OpVect;
  size_t* OldNumList_ = _NumVect;
  size_t OldSz_ = _OpVectLimit;

  _OpVectLimit += VECTSIZE_INCR;
  _OpVect = (char*)MemMatrix::Matrix().Callocate(sizeof(char) * _OpVectLimit);
  if (OldNumList_)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);

  for (x = 0; x < OldSz_; x++)
  {
    _OpVect[x] = OldList_[x];

    if (OldNumList_)
      _NumVect[x] = OldNumList_[x];
  }

  while (x < _OpVectLimit)
  {
    _OpVect[x] = 0;

    if (OldNumList_)
      _NumVect[x] = 0;
      
    ++x;
  }

  ::RawDeleteArray(OldList_);
  if (OldNumList_)
    ::RawDeleteArray(OldNumList_);
}

/****************************************************************************/
size_t DequeOperationImpl::OpsListLimit() const
{
  return _OpVectLimit;
}

/****************************************************************************/
size_t DequeOperationImpl::OpsListIndex() const
{
  return _OpVectIndex;
}

/****************************************************************************/
size_t DequeOperationImpl::Size() const
{
  return (_Container ? _Container->Size():0);
}

/****************************************************************************/
bool DequeOperationImpl::IsNumbered() const
{
  return (_NumVect != NULL);
}

/****************************************************************************/
void DequeOperationImpl::SetNumberedList(bool Flag_)
{
  if (Flag_ && !_NumVect)
    _NumVect = (size_t*)MemMatrix::Matrix().Callocate(sizeof(size_t) * _OpVectLimit);
  else if (!Flag_ && _NumVect)
  {
    ::RawDeleteArray(_NumVect);
    _NumVect = NULL;
  }
}

/****************************************************************************/
void DequeOperationImpl::DumpVectorData(ostream* osp_)
{
  if (osp_)
  {
    size_t x;
    size_t max = 0;
    bool ovdone = false;
    bool nvdone = false;
    bool dispovdone = false;
    bool dispnvdone = false;

    cout <<"operation:";
    for (x = 0; x <= _OpVectIndex; x++)
    {
      if (_OpVect[x])
      {
        if (x && dispovdone)
          *osp_ <<",";
          
        *osp_ <<OpToChar(_OpVect[x]);
        dispovdone = true;
        max = x;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          ovdone = true;
        }
      }
      else if (!ovdone && dispovdone)
      {
        *osp_ <<endl;
        ovdone = true;
      }
    }

    if (!ovdone)
      cout <<endl;

    cout <<"num node:";
    for (x = 0; x <= max; x++)
    {
      if (_NumVect[x] || x == 0 || dispnvdone)
      {
        if (x && dispnvdone)
          *osp_ <<",";

        *osp_ <<_NumVect[x];
        dispnvdone = true;

        if (_OpVectIndex == x)
        {
          *osp_ <<endl;
          nvdone = true;
        }
      }
      else if (!nvdone && dispnvdone)
      {
        *osp_ <<endl;
        nvdone = true;
      }
    }

    if (!nvdone)
      cout <<endl;
  }
}

/****************************************************************************/
void DequeOperationImpl::StoreOpToList(int OpType_, size_t NodeNum_)
{
  char op = (char)OpType_;

  if (op == ListOperationEnums::DEQUEUE ||
      op == ListOperationEnums::ENQUEUE ||
      op == ListOperationEnums::POP ||
      op == ListOperationEnums::PUSH)
  {
    if (!_OpVect[_OpVectIndex])
    {
      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }
    else
    {
      ++_OpVectIndex;
      if (_OpVectIndex >= _OpVectLimit)
        GrowOpsList();

      _OpVect[_OpVectIndex] = op;
      if (_NumVect)
        _NumVect[_OpVectIndex] = NodeNum_;
    }

    if (_OpVect[_OpVectIndex])
    {
      if (_OpVect[_OpVectIndex] == ListOperationEnums::DEQUEUE)
      {
        _TimesDequeued++;
        _CurrentOp = &_TimesDequeued;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::ENQUEUE)
      {
        _TimesEnqueued++;
        _CurrentOp = &_TimesEnqueued;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::POP)
      {
        _TimesPopped++;
        _CurrentOp = &_TimesPopped;
      }
      else if (_OpVect[_OpVectIndex] == ListOperationEnums::PUSH)
      {
        _TimesPushed++;
        _CurrentOp = &_TimesPushed;
      }
    }
  }
}

/****************************************************************************/
int DequeOperationImpl::LastOp() const
{
  return _OpVect[_OpVectIndex];
}

/****************************************************************************/
int DequeOperationImpl::FirstOp() const
{
  return _OpVect[0];
}

/****************************************************************************/
int DequeOperationImpl::OpAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _OpVect[Index_]:0);
}

/****************************************************************************/
int DequeOperationImpl::LastNodeNum() const
{
  return _NumVect[_OpVectIndex];
}

/****************************************************************************/
int DequeOperationImpl::FirstNodeNum() const
{
  return _NumVect[0];
}

/****************************************************************************/
int DequeOperationImpl::NodeNumAt(size_t Index_) const
{
  return ((0 <= Index_ && Index_ <= _OpVectIndex) ? _NumVect[Index_]:0);
}

/****************************************************************************/
size_t DequeOperationImpl::TotalOps() const
{
  return (_OpVect[_OpVectIndex] ? (_OpVectIndex+1):_OpVectIndex);
}

/****************************************************************************/
void DequeOperationImpl::DeleteAll()
{
  int x;
  size_t max = _OpVectLimit;
  _OpVectIndex = 0;
  
  for (x = 0; x < max; x++)
  {
    _OpVect[x] = 0;

    if (_NumVect)
      _NumVect[x] = 0;
  }
}

/****************************************************************************/
bool DequeOperationImpl::IsDeque() const
{
  return true;
}

/****************************************************************************/
bool DequeOperationImpl::IsDequeued() const
{
  return (_Container->Size() == 0 || (_CurrentOp == &_TimesDequeued));
}

/****************************************************************************/
bool DequeOperationImpl::IsEnqueued() const
{
  return (_Container->Size() > 0 && (_CurrentOp == &_TimesEnqueued));
}

/****************************************************************************/
bool DequeOperationImpl::IsPopped() const
{
  return (_Container->Size() == 0 || (_CurrentOp == &_TimesPopped));
}

/****************************************************************************/
bool DequeOperationImpl::IsPushed() const
{
  return (_Container->Size() > 0 && (_CurrentOp == &_TimesPushed));
}

/****************************************************************************/
size_t DequeOperationImpl::TimesDequeued() const
{
  return _TimesDequeued;
}

/****************************************************************************/
size_t DequeOperationImpl::TimesEnqueued() const
{
  return _TimesEnqueued;
}

/****************************************************************************/
size_t DequeOperationImpl::TimesPopped() const
{
  return _TimesPopped;
}

/****************************************************************************/
size_t DequeOperationImpl::TimesPushed() const
{
  return _TimesPushed;
}

/****************************************************************************/
MEMORYOPS_DEFN(DequeOperationImpl)

/****************************************************************************/
#endif

