#ifndef LISTDEFN_H
#define LISTDEFN_H
#ifndef BUILTIN_H
  #include "builtin.h"
#endif
#ifndef OBJECTCLONER_H
  #include "objectcloner.h"
#endif

/****************************************************************************/
struct CopyTypeEnums
{
  public:
    enum
    {
      NO_COPY     = 0,
      COPY        = 1,
      DELETE_SAFE = -1,
    };
};

struct ListOperationEnums
{
  public:
    enum
    {
      NONE    = 0,
      PUSH    = 1,
      POP     = 2,
      ENQUEUE = 4,
      DEQUEUE = 8,
      INSERT  = 16,
      DETACH  = 32,

      VECTSIZE_INCR = 8
    };
};

/****************************************************************************/
class ListOperation : public ListOperationEnums, public CopyTypeEnums
{
  public:  
    static ListOperation* MakeListOpsImpl(ListOperation* This_);
    static ListOperation* MakeListOpsImpl(ListOperation* This_, const ListOperation& Copy_);
    static char OpToChar(int op);

    virtual void DumpVectorData(ostream* osp_=NULL) = 0;
    virtual void DumpListData(int(*dispfn)(const void*, int), ostream* osp_=NULL);
    virtual void StoreOpToList(int OpType_, size_t NodeNum_=0) = 0;
    virtual void SetNumberedList(bool Flag_) = 0;
    virtual void DeleteAll() = 0;
    virtual void ReNumberList();
    
    virtual int LastOp() const = 0;
    virtual int FirstOp() const = 0;
    virtual int OpAt(size_t Index_) const = 0;

    virtual int LastNodeNum() const = 0;
    virtual int FirstNodeNum() const = 0;
    virtual int NodeNumAt(size_t Index_) const = 0;
    
    virtual size_t TotalOps() const = 0;
    virtual size_t OpsListLimit() const = 0;
    virtual size_t OpsListIndex() const = 0;
    virtual size_t Size() const = 0;

    virtual bool IsNumbered() const;
    virtual bool IsLinkedList() const;
    virtual bool IsStack() const;
    virtual bool IsQueue() const;
    virtual bool IsDeque() const;

    virtual bool IsPopped() const;
    virtual bool IsPushed() const;
    virtual bool IsEnqueued() const;
    virtual bool IsDequeued() const;
    virtual bool IsInserted() const;
    virtual bool IsDetached() const;
        
    virtual size_t TimesPopped() const;
    virtual size_t TimesPushed() const;
    virtual size_t TimesEnqueued() const;
    virtual size_t TimesDequeued() const;
    virtual size_t TimesInserted() const;
    virtual size_t TimesDetached() const;

  #if OVERLOAD_NEW
      void* operator new (size_t Bytes_);
      void operator delete (void* Space_);

  #if	HAS_ARRAY_NEW
      void* operator new[] (size_t Bytes_);
      void operator delete[] (void* Space_);
  #endif
  #endif
};

/****************************************************************************/
class ListOperationImpl : public ListOperation
{
  protected:
    size_t _OpVectIndex;
    size_t _OpVectLimit;
    char* _OpVect;
    size_t* _NumVect;

    size_t _TimesDetached;
    size_t _TimesInserted;
    size_t* _CurrentOp;
    ListOperation* _Container;

    void GrowOpsList();

  public:
    ListOperationImpl(bool Numbered_=false);
    ListOperationImpl(const ListOperation& Obj_);
    ~ListOperationImpl();

    virtual void DumpVectorData(ostream* osp_=NULL);
    virtual void StoreOpToList(int OpType_, size_t NodeNum_=0);
    virtual void SetNumberedList(bool Flag_);
    virtual void DeleteAll();
    
    virtual int LastOp() const;
    virtual int FirstOp() const;
    virtual int OpAt(size_t Index_) const;

    virtual int LastNodeNum() const;
    virtual int FirstNodeNum() const;
    virtual int NodeNumAt(size_t Index_) const;

    virtual size_t TotalOps() const;
    virtual size_t OpsListLimit() const;
    virtual size_t OpsListIndex() const;
    virtual size_t Size() const;

    virtual bool IsNumbered() const;
    virtual bool IsLinkedList() const;
    virtual bool IsInserted() const;
    virtual bool IsDetached() const;
    
    virtual size_t TimesInserted() const;
    virtual size_t TimesDetached() const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class StackOperationImpl : public ListOperation
{
  protected:
    size_t _OpVectIndex;
    size_t _OpVectLimit;
    char* _OpVect;
    size_t* _NumVect;

    size_t _TimesPopped;
    size_t _TimesPushed;
    size_t* _CurrentOp;
    ListOperation* _Container;

    void GrowOpsList();

  public:
    StackOperationImpl(bool Numbered_=false);
    StackOperationImpl(const ListOperation& Obj_);
    ~StackOperationImpl();

    virtual void DumpVectorData(ostream* osp_=NULL);
    virtual void StoreOpToList(int OpType_, size_t NodeNum_=0);
    virtual void SetNumberedList(bool Flag_);
    virtual void DeleteAll();

    virtual int LastOp() const;
    virtual int FirstOp() const;
    virtual int OpAt(size_t Index_) const;

    virtual int LastNodeNum() const;
    virtual int FirstNodeNum() const;
    virtual int NodeNumAt(size_t Index_) const;

    virtual size_t TotalOps() const;
    virtual size_t OpsListLimit() const;
    virtual size_t OpsListIndex() const;
    virtual size_t Size() const;

    virtual bool IsNumbered() const;
    virtual bool IsStack() const;
    virtual bool IsPopped() const;
    virtual bool IsPushed() const;
        
    virtual size_t TimesPopped() const;
    virtual size_t TimesPushed() const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class QueueOperationImpl : public ListOperation
{
  protected:
    size_t _OpVectIndex;
    size_t _OpVectLimit;
    char* _OpVect;
    size_t* _NumVect;

    size_t _TimesDequeued;
    size_t _TimesEnqueued;
    size_t* _CurrentOp;
    ListOperation* _Container;

    void GrowOpsList();

  public:
    QueueOperationImpl(bool Numbered_=false);
    QueueOperationImpl(const ListOperation& Obj_);
    ~QueueOperationImpl();

    virtual void DumpVectorData(ostream* osp_=NULL);
    virtual void StoreOpToList(int OpType_, size_t NodeNum_=0);
    virtual void SetNumberedList(bool Flag_);
    virtual void DeleteAll();
    
    virtual int LastOp() const;
    virtual int FirstOp() const;
    virtual int OpAt(size_t Index_) const;

    virtual int LastNodeNum() const;
    virtual int FirstNodeNum() const;
    virtual int NodeNumAt(size_t Index_) const;

    virtual size_t TotalOps() const;
    virtual size_t OpsListLimit() const;
    virtual size_t OpsListIndex() const;
    virtual size_t Size() const;

    virtual bool IsNumbered() const;
    virtual bool IsQueue() const;
    virtual bool IsEnqueued() const;
    virtual bool IsDequeued() const;
        
    virtual size_t TimesEnqueued() const;
    virtual size_t TimesDequeued() const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
class DequeOperationImpl : public ListOperation
{
  public:
    size_t _OpVectIndex;
    size_t _OpVectLimit;
    char* _OpVect;
    size_t* _NumVect;

    size_t _TimesPopped;
    size_t _TimesPushed;
    size_t _TimesDequeued;
    size_t _TimesEnqueued;
    size_t* _CurrentOp;
    ListOperation* _Container;

    void GrowOpsList();

  public:
    DequeOperationImpl(bool Numbered_=false);
    DequeOperationImpl(const ListOperation& Obj_);
    ~DequeOperationImpl();

    virtual void DumpVectorData(ostream* osp_=NULL);
    virtual void StoreOpToList(int OpType_, size_t NodeNum_=0);
    virtual void SetNumberedList(bool Flag_);
    virtual void DeleteAll();
    
    virtual int LastOp() const;
    virtual int FirstOp() const;
    virtual int OpAt(size_t Index_) const;

    virtual int LastNodeNum() const;
    virtual int FirstNodeNum() const;
    virtual int NodeNumAt(size_t Index_) const;

    virtual size_t TotalOps() const;
    virtual size_t OpsListLimit() const;
    virtual size_t OpsListIndex() const;
    virtual size_t Size() const;

    virtual bool IsNumbered() const;
    virtual bool IsDeque() const;
    virtual bool IsPopped() const;
    virtual bool IsPushed() const;
    virtual bool IsEnqueued() const;
    virtual bool IsDequeued() const;
        
    virtual size_t TimesPopped() const;
    virtual size_t TimesPushed() const;
    virtual size_t TimesEnqueued() const;
    virtual size_t TimesDequeued() const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
#endif

