#ifndef MATHFNCS_H
#define MATHFNCS_H
#ifndef INCL_MATH_H
  #include <math.h>
  #define INCL_MATH_H
#endif

//****************************************************************************
#ifdef _MSC_VER
#define MIN(x,y)    __min(x,y)
#define MAX(x,y)    __max(x,y)
#else
#define MIN(x,y)    (((x)<(y)) ? (x):(y))
#define MAX(x,y)    (((x)>(y)) ? (x):(y))
#endif

//****************************************************************************
template <class T>
T AbsoluteValue(const T& Obj_, const T& ZeroValue_)
{ return ((Obj_ < ZeroValue_) ? T(-Obj_):T(Obj_)); }

template <class T>
T InvAbsoluteValue(const T& Obj_, const T& ZeroValue_)
{ return ((Obj_ > ZeroValue_) ? T(-Obj_):T(Obj_)); }

template <class T>
T Sqr(const T& x) {return (x*x);}

template <class T>
T Cube(const T& x) {return (x*x*x);}

template <class T>
int Even(const T& x) {return !(x%2);}

template <class T>
int Odd(const T& x) {return (x%2);}

template <class T>
T RoundUp(const T& x, const T& r)
{
  if (r <= T(0))
    return x;

  int y = 1;
  T rv = r;
  T xv = x;

  while (rv < T(1))
  {
    rv *= 10;
    xv *= 10;
    y *= 10;
  }

  y /= 10;
  if (xv >= T(0))
  {
    xv = T(::floor((xv+rv)/10));
    xv /= y;
    return xv;
  }

  xv = T(::ceil((xv-rv)/10));
  xv /= y;
  return xv;
}

//****************************************************************************
#endif




