#ifndef MUTEX_H
#define MUTEX_H

#if defined(__linux__) | defined(__unix__)
  #include "umutex.h"
#else
  #include "wmutex.h"
#endif

#if defined(__linux__) | defined(__unix__)
  #define LOCK_MUTEX(x) \
    pthread_mutex_lock(x)
  #define UNLOCK_MUTEX(x) \
    pthread_mutex_unlock(x)
#else
  #define LOCK_MUTEX(x) \
    EnterCriticalSection(x)
  #define UNLOCK_MUTEX(x) \
    LeaveCriticalSection(x)
#endif

#endif




