#ifndef NESTARRAY_H
#define NESTARRAY_H

#ifndef FILEREADER_H
  #include "filereader.h"
#endif
#ifndef CHRSTRING_H
  #include "chrstring.h"
#endif
#ifndef FULLDATE_H
  #include "fulldate.h"
#endif

#define NESTARRAY_DEBUG                 1
#define NESTARRAY_DEBUG1                0
#define NESTARRAY_DEBUG2                1
#define NESTARRAY_DEBUG3                0
#define NESTARRAY_DEBUG3b               0
#define NESTARRAY_DEBUG3c               0

#define NESTARRAY_ARRLEN3_DEBUG         0
#define NESTARRAY_ARRLEN4_DEBUG         0
#define NESTARRAY_ARRLEN5_DEBUG         1
#define NESTARRAY_ARRLEN6_DEBUG         0
#define NESTARRAY_ARRLEN7_DEBUG         0
#define NESTARRAY_ARRLEN8_DEBUG         0

#define NESTARRAY_REINITIALIZE1         0
#define NESTARRAY_REINITIALIZE2         0

#define SizeOfVector(dim, index, lenv)      \
   ((index == dim - 1) ?                    \
        (lenv[index] + 1):                  \
        ((index < dim - 1) ?                \
             (index + lenv[index] + 1):0))

#define CapacityOfVector(dim, index, vectlv1, cntlv2)               \
   ((index == dim - 1) ?                                            \
        (vectlv1[0]):                                               \
        ((index < dim - 1) ? (cntlv2[0][0]):0))

#define CountOfVector(dim, index, off, vectlv1, cntlv1, cntlv2)     \
   ((index == dim - 1) ?                                            \
        (vectlv1[0]):                                               \
        ((index < dim - 1) ?                                        \
             ((off == index-1) ? cntlv2[1][0]:cntlv1[1]):0))

#define SetCapacityOfVector(dim, index, sz, vectlv1, cntlv2)        \
   ((index == dim - 1) ?                                            \
        (vectlv1[0]=sz):                                            \
        ((index < dim - 1) ? (cntlv2[0][0]=sz):0))

#define IncCountOfVector(dim, index, off, vectlv1, cntlv1, cntlv2)       \
   ((index == dim - 1) ?                                                 \
        (++vectlv1[0]):                                                  \
        ((index < dim - 1) ?                                             \
             ((off == index-1) ? (++cntlv2[1][0]):(++cntlv1[1])):0));    \
   (((index < dim - 1) && (off == index-1)) ?                            \
        ((cntlv2[1][0] > vectlv1[0]) ? (vectlv1[0] = cntlv2[1][0]):0):   \
        ((cntlv1[1] > cntlv1[0]) ? (cntlv1[0] = cntlv1[1]):0))

#define AddCountOfVector(dim, index, off, sz, vectlv1, cntlv1, cntlv2)    \
   ((index == dim - 1) ?                                                  \
        (vectlv1[0]+=sz):                                                 \
        ((index < dim - 1) ?                                              \
             ((off == index-1) ? (cntlv2[1][0]+=sz):(cntlv1[1]+=sz)):0)); \
   (((index < dim - 1) && (off == index-1)) ?                             \
        ((cntlv2[1][0] > vectlv1[0]) ? (vectlv1[0] = cntlv2[1][0]):0):    \
        ((cntlv1[1] > cntlv1[0]) ? (cntlv1[0] = cntlv1[1]):0))             

#define DecCountOfVector(dim, index, off, vectlv1, cntlv1, cntlv2)       \
   ((index == dim - 1) ?                                                 \
        (--vectlv1[0]):                                                  \
        ((index < dim - 1) ?                                             \
             ((off == index-1) ? (--cntlv2[1][0]):(--cntlv1[1])):0))

#define SubCountOfVector(dim, index, off, sz, vectlv1, cntlv1, cntlv2)   \
   ((index == dim - 1) ?                                                 \
        (vectlv1[0]-=sz):                                                \
        ((index < dim - 1) ?                                             \
             ((off == index-1) ? (cntlv2[1][0]-=sz):(cntlv1[1]-=sz)):0))

#define StatusOfVector(dim, index, off, pos, vectlv1, cntlv1)       \
   ((index == dim - 1) ?                                            \
        (vectlv1[0] == 0):                                          \
        ((index < dim - 1) ?                                        \
             (cntlv1[pos]):0))

#define SetStatusOfVector(dim, index, off, pos, stat, cntlv1)       \
   ((index == dim - 1) ?                                            \
        0:((index < dim - 1) ?                                      \
             (cntlv1[pos]=stat):0))

/****************************************************************************/
// Multidimensional matrix helper functions
//
static void RemoveArray(void* Array_, int Dim_, int Off_, int MatrixIndex_, int* LenVect_);
static void* InitMatrix(void* Array_, int Dim_, int Off_, int Index_, int* LenVect_);
static int* SetParentReference(int* Vector_, int Dim_,
                               int ParentIndex_, int MatrixIndex_,
                               int* LenVect_, int* PosVect_, bool& Error_);
static int* GetParentReference(int* ParentRefs_, int Dim_, int Off_, int MatrixIndex_,
                               int* LenVect_, int* PosVect_, void* Array_,
                               bool& Error_);
static void* SetRefArrays(void* Array_, int Dim_, int Off_, int Index_,
                          int* LenVect_, int* PosVect_, bool& Error_, bool TestMem_=false);
static void* SetReferences(int* ParentRefs_, int Dim_, int Off_, int MatrixIndex_,
                               int* LenVect_, int* PosVect_, void* Array_,
                               bool& Error_);
static void* RemoveReferences(void* Array_, void* Container_, int Dim_, int Off_,
                              int MatrixIndex_, int* LenVect_, int* PosVect_,
                              void* Replacement_, bool DeAlloc_, int* Shared_,
                              int* Size_, int* Max_, bool& Error_);
static int DeleteVectorHelper(void* Array_, int Dim_, int Index_, int* LenVect_,
                              int* PosVect_, void* Replacement_, bool Replace_,                              
                              bool DeAlloc_, bool& Error_, bool CheckDealloc_,
                              int* Shared_, int* Size_, int* Max_);
static void* DestroyArrayDataHelper(void* Array_, int Dim_, int Cnt_,
                                    int pos, int* LenVect_);

/****************************************************************************/
// Main multidimensional matrix utility functions
//
static int* LinearToCoords(int Pos_, int* Coords_, int CoordsLen_,
                           int* OffSets_, int OffSetsLen_);
static int CoordsToLinear(int* Coords_, int CoordsLen_,
                          int* OffSets_, int OffSetsLen_);
static int* CalculateOffsets(int* ArraySizes_, int ArrayLen_, int& OffSetsLen_);

static void* ParentReference(void* Array_, int Dim_, int Index_,
                             int* LenVect_, int* PosVect_, int* ParentRefs_,
                             bool& Error_);
static int RealVectorCount(void* Array_, int Dim_, int Index_,
                           int* LenVect_, int* PosVect_, bool& Error_);
static int RealVectorMax(void* Array_, int Dim_, int Index_,
                         int* LenVect_, int* PosVect_, bool& Error_);
                             
static int DeleteVector(void* Array_, int Dim_, int Index_, int* LenVect_,
                        int* PosVect_, bool& Error_, int* Shared_=NULL,
                        int* Size_=NULL, int* Max_=NULL);
static int IsDeallocated(void* Array_, int Dim_, int Index_, int* LenVect_,
                         int* PosVect_, bool& Error_, int* Shared_=NULL,
                         int* Size_=NULL, int* Max_=NULL);
static int ReplaceVector(void* Array_, int Dim_, int Index_, int* LenVect_,
                         int* PosVect_, void* Replacement_, bool Replace_,
                         bool DeAlloc_, bool& Error_, int* Shared_=NULL,
                         int* Size_=NULL, int* Max_=NULL);

static void* RemoveInformationArray(void* Array_, int Dim_);
static void* GiveInformationArray(void* Array_, int Dim_);
static void* DestroyArrayData(void* Array_, int Dim_, int* LenVect_);

static int ReadFromArray(void* Array_, int Dim_, int* LenVect_,
                         int* PosVect_, bool& Error_);
static void* WriteToArray(void* Array_, int Dim_, int* LenVect_,
                          int* PosVect_, int Data_, bool& Error_);

static void* CheckVector(void* Array_, int Dim_, int Index_,
                         int Incr_, int Level_);
static void* InitArrayData(void* Array_, int Dim_, int Index_,
                           int* LenVect_, int* PosVect_, int ReInit_,
                           bool& Error_, int Shift_=0);
static void* InitArrayData2(void* Array_, int Dim_, int Index_,
                            int* LenVect_, int* PosVect_,
                            bool& Error_, int Shift_=0);

/****************************************************************************/
template <class T>
class VectorClass1D
{
  public:
    virtual T ReadFromVector(T pos) const = 0;
    virtual void* WriteToVector(T pos, T Data_) = 0;

    virtual T AtPos(T pos, bool& Found_) = 0;
    virtual const T AtPos(T pos, bool& Found_) const = 0;

    virtual bool Error() const = 0;
    virtual T Shared() const = 0;
    virtual T Size() const = 0;
    virtual T MaxLength() const = 0;
    virtual T Dim() const = 0;
};

class NestedVectorEnums
{
  public:
    enum
    {
      REINIT    = 1,
      RESIZE    = 2,
      INITDATA2 = 4
    };
};

template <class T>
class NestedVector : public NestedVectorEnums, public VectorClass1D<T>
{
  public:
    virtual T DeleteVector(T Index_) = 0;
    virtual T IsDeallocated(T Index_) = 0;
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_) = 0;

    virtual T RealVectorCount(T Index_) const = 0;
    virtual T RealVectorSize(T Index_) const = 0;
    virtual const T* ParentReference(T Index_) = 0;
    virtual T** GiveInfoArray() = 0;

    virtual T* LinearToCoords(T Pos_, T* Coords_) = 0;
    virtual T CoordsToLinear(T* Coords_) = 0;

    virtual T ReadFromArray() const = 0;
    virtual void* WriteToArray(T Data_) = 0;

    virtual NestedVector<T>& SetReInitArrays(int Flag_) = 0;
    virtual NestedVector<T>& SetCoordinates(T* Coords_) = 0;
    virtual NestedVector<T>& SetLengths(T* Coords_) = 0;

    virtual T* NewCoordinatesVector() const = 0;
    virtual T* NewLengthsVector() const = 0;
    virtual T* GetCoordinates(T* Coords_) const = 0;
    virtual T* GetLengths(T* Lengths_) const = 0;
    virtual int ReInitArrays() const = 0;
};

/****************************************************************************/
template <class T>
class IntVector : public VectorClass1D<T>
{
  protected:
    enum { SIZE = 1 };

    // Index argument is assumed to hold the vector length.
    // LenVect argument is assumed to hold deallocated flag and
    // PosVect argument is assumed to hold shallowcopy flag.
    T _Deallocated;
    T _ShallowCopy;
    
    mutable bool _Error;
    mutable T _Shared;
    IntVector* _Owner;

    // _Array[0] holds vector length
    // Corresponds to 1d constituent element vector within data matrix if
    // used as base class in NestedDataStorage class.
    T* _Array;

    void DecrShare()
        { if (_Shared) _Shared--; }
    void IncrShare()
        { if (!_Shared) _Shared++; }

  public:
    IntVector();
    IntVector(T Length_);
    ~IntVector();

    T VectorSize() const;
    void SetVectorSize(T sz);
    IntVector<T>& Assign(const IntVector& Obj_);
    IntVector<T>& ShallowCopy(IntVector& Obj_);

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray2 : public NestedVector<T>
{
  protected:
    enum { SIZE = 2 };

    int MAXLENGTH;
    T** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray2(T* Length_, int MaxLength_=0);
    ~NestedArray2();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray3 : public NestedVector<T>
{
  protected:
    enum { SIZE = 3 };

    int MAXLENGTH;
    T*** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray3(T* Length_, int MaxLength_=0);
    ~NestedArray3();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray4 : public NestedVector<T>
{
  protected:
    enum { SIZE = 4 };

    int MAXLENGTH;
    T**** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;
    
    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray4(T* Length_, int MaxLength_=0);
    ~NestedArray4();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;    
};

/****************************************************************************/
template <class T>
class NestedArray5 : public NestedVector<T>
{
  protected:
    enum { SIZE = 5 };

    int MAXLENGTH;
    T***** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray5(T* Length_, int MaxLength_=0);
    ~NestedArray5();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray6 : public NestedVector<T>
{
  protected:
    enum { SIZE = 6 };

    int MAXLENGTH;
    T****** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray6(T* Length_, int MaxLength_=0);
    ~NestedArray6();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray7 : public NestedVector<T>
{
  protected:
    enum { SIZE = 7 };

    int MAXLENGTH;
    T******* _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray7(T* Length_, int MaxLength_=0);
    ~NestedArray7();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class T>
class NestedArray8 : public NestedVector<T>
{
  protected:
    enum { SIZE = 8 };

    int MAXLENGTH;
    T******** _Array;
    mutable T _MatrixIndex;
    T* _LenVect;
    T* _PosVect;
    T* _ParentRefs;

    mutable int _ReInitArrays;
    mutable bool _Error;
    mutable T _Shared;    
    mutable T _Size;

    T* _OffSets;
    T _OffSetsLen;

    void* InitArrayData(T Index_);

  public:
    NestedArray8(T* Length_, int MaxLength_=0);
    ~NestedArray8();

    virtual T AtPos(T pos, bool& Found_);
    virtual const T AtPos(T pos, bool& Found_) const;

    virtual T ReadFromVector(T pos) const;
    virtual void* WriteToVector(T pos, T Data_);

    virtual T DeleteVector(T Index_);
    virtual T IsDeallocated(T Index_);
    virtual T ReplaceVector(T Index_, void* Replacement_, bool Replace_, bool DeAlloc_);

    virtual T RealVectorCount(T Index_) const;
    virtual T RealVectorSize(T Index_) const;
    virtual const T* ParentReference(T Index_);
    virtual T** GiveInfoArray();

    virtual T* LinearToCoords(T Pos_, T* Coords_);
    virtual T CoordsToLinear(T* Coords_);

    virtual T ReadFromArray() const;
    virtual void* WriteToArray(T Data_);

    virtual NestedVector<T>& SetReInitArrays(int Flag_);
    virtual NestedVector<T>& SetCoordinates(T* Coords_); // set _PosVect
    virtual NestedVector<T>& SetLengths(T* Coords_);     // set _LenVect

    virtual T* NewCoordinatesVector() const;
    virtual T* NewLengthsVector() const;    
    virtual T* GetCoordinates(T* Coords_) const;
    virtual T* GetLengths(T* Lengths_) const;

    virtual int ReInitArrays() const;
    virtual bool Error() const;
    virtual T Shared() const;
    virtual T Size() const;
    virtual T MaxLength() const;
    virtual T Dim() const;
};

/****************************************************************************/
template <class KEY, class VALUE>
class NestedArrayData
{
  public:
    KEY _Index;     // Linear index calculated from CoordsToLinear method
    VALUE* _Data;
};

/****************************************************************************/
template <class KEY, class VALUE>
class NestedDataStorage : private IntVector<KEY>
{
  private:
    enum
    {
      VECTOR1DARRAY,
      NESTED2DARRAY,
      NESTED3DARRAY,
      NESTED4DARRAY,
      NESTED5DARRAY,
      NESTED6DARRAY,
      NESTED7DARRAY,
      NESTED8DARRAY
    };

    int _Type;
    union
    {
      IntVector<KEY>* _N1Arr;
      NestedArray2<KEY>* _N2Arr;
      NestedArray3<KEY>* _N3Arr;
      NestedArray4<KEY>* _N4Arr;
      NestedArray5<KEY>* _N5Arr;
      NestedArray6<KEY>* _N6Arr;
      NestedArray7<KEY>* _N7Arr;
      NestedArray8<KEY>* _N8Arr;
    };
    
    //////////////////////////////////////////////////////////////////////////
    // Offset format:
    //     Offset[0...even] = length of dimensional array
    //     Offset[1...odd]  = dimensional array offset size in number of
    //                        1d vector base elements
    //
    // Data storage process scheme:
    //
    //   1. coords = NestArrayN->NewCoordinatesVector()
    //   2. NestArrayN->SetCoordinates(int* coords)
    //   3. linearpos = NestArrayN->CoordsToLinear(int* coords)
    //   4. DataObject->_Index = linearpos
    //   5. HashTable<int, NestedArrayData> Node[linearpos] = DataObject    
    //        // DataObject is of type NestedArrayData
    //        // HashTable is set to DOUBLEHASH as hash table scheme
    //   5. actualpos = HashStoragePtr->GetIndex()
    //        // HashStoragePtr is a hashable object in HashTable
    //        // Retrieve the actual storage position within the table
    //   6. NestArrayN->WriteToArray(actualpos);
    //   7. Upon retrieving data the linearpos stored in DataObject can be
    //      used to lookup the actual storage position in the hash table as
    //      written to the nested array element that's indexed by int* coords
    //   8. Alternatively the linearpos value can be converted to int* coords
    //      by using NestArrayN->LinearToCoords(int pos, int* coords)
    //
    //////////////////////////////////////////////////////////////////////////

    KEY* _LenVect;     // Length vector, allocated by calling
                       // NewLengthsVector() method of NestedArrayN*
    KEY* _PosVect;     // Coordinate vector, allocated by calling
                       // NewCoordinatesVector() method of NestedArrayN*

    KEY* _OffSets;     // Progressive linear position offsets
    KEY _OffSetsLen;   // Position offsets vector length

    
    KEY _VectorIndex;  // Index to access active leaf element vector
                       // Should be same as MatrixIndex of element vector
    KEY _NestedIndex;  // Hashed index into nested data array given the
                       // linear position index

    // HashTable of NestedArrayData structures
    //   HashTable adjustable to size and dimensions of
    //   contained variable length sparse matrix
    NestedArrayData<KEY,VALUE>** _DataArr;

  public:    
    NestedDataStorage();    
};

/****************************************************************************/
#endif
