#ifndef PARSER_H
#define PARSER_H
#ifndef TOKENS_H
  #include "tokens.h"
#endif

//
// symbol tag format:
// <symbolname:symtype:symattr:optype:scope:scopelevel:brackbal:delimcnt:recnum>
// <symbolname:symtype:symattr:optype:scope>
//
// Internal representation:
// <assignment:Operator_Type:StateSwitch:Free:SequenceScope:0-0-0:0:0:0>
// <double quoted string:BracketedSymbol_Type:LeftBracket:NONE:SequenceScope:0-0-0:0:0:0>
//
// External representation:
// <assignment:Operator_Type:StateSwitch:Free:SequenceScope>
// <double quoted string:BracketedSymbol_Type:LeftBracket:NONE:SequenceScope>
//

class Parser
{
  private:
    static char* TrimSpaces(char* str);
    static char* StripLeadingSpaces(char* str);
    static int StrniComp(const char* s1, const char* s2, size_t max);
    static int StriComp(const char* s1, const char* s2);    
  
  protected:  
    int _ParserNumber;
    static Parser* _ParserObjects[256];
    
    int _NumSymbols;
    int _MaxParseSymbols;
    ParserSymbolType** _ParseSymbols;

    char* _ReadLine;
    char* _WorkLine;
    
    int _ParseError;
    int _LineNumber;
    int _ScopeLevel;

    char* _StartQuote;
    char* _EndQuote;
    char* _Assignment;
    char* _Terminator;

    static const char* HasChar(const char* Str_, const char* Filter_);
    static char* ReplaceChar(char* Str_, const char* Trg_, const char* Rep_);
    static int MaxOf(int Value1_, int Value2_);

    // quick parser methods
    void GrowSymbolTable();
    char* GroupToken(const char* Token_, const char* StartBracket_, const char* EndBracket_);
    static int DetermineTokenType(const char* Char_);
    static char* FindNextBranch(char* Str_);
    static int FindNumBranches(char* Str_);
    static int FindOrBranch(char* Str_, ParserStatus* Status_);
    static char* FindGrouping(char*& Str_, const char* Startb_, const char* Endb_);
    static char* StripGrouping(char* Str_, const char* Startb_, const char* Endb_);
    static ParserResultInfo* ResolveGroup(ParserResultInfo* Results_, int Branches_);
    static ParserResultInfo* ResolveOption(ParserResultInfo* Results_);
    static ParserResultInfo* ResolveFloat(ParserResultInfo* DefnInfo_, ParserResultInfo* SymbolSet_);
    void SetSyntaxSymbols(char* Assignment_, char* Terminator_);
    char* ExtractStrTokenFnc(char*& Text_, char* SyntaxStr_, int Quoted_, char* SymbolType_);
    char* ExtractStrToken(char*& Text_, char* SyntaxStr_, int Quoted_, char* SymbolType_);
    int IsValidIntField(char* Field_, int& IntValue_);
    int IsValidStrField(char* Field_, int Quoted_, char* Type_);
    int NotInQuotes(char* Text_, char* Token_, int Whitespace_);
    void ShowParseState(ParserStatus* Status_, char* Token_, int AtStart_, int AtRoot_, ParserResultInfo* Results_);
    int CheckParseError(ParserResultInfo* Results_, char* Text_, char* SyntaxStr_, ParserStatus* Status_);
    int GrabToken(ParserResultInfo* Results_, char* Text_, char* SyntaxStr_,
                  ParserStatus* Status_, char* Token_, int PrevValid_);
    ParserResultInfo* QuickParse(ParserResultInfo* Results_, char* Text_, char* SyntaxStr_,
                                ParserStatus* Status_, char* Token_, int PrevValid_);

    void ResetVariables();

    static long ParserSupply(int Create_, long Index_, Parser* Ptr_);
    void DeleteParserObject(long MaxParsers_);

    Parser(long ParserNumber_=0);
    ~Parser();

  public:
    enum
    {
      NO_TOKEN,
      LITERAL,
      SYMBOL,
      OPTION,
      GROUP,
      OR_BRANCH,
      REPEATABLE,
      PARSER_OPTION
    };

    void ShowLineData();

    int ParseError() const
        { return _ParseError; }
    int LineNumber() const
        { return _LineNumber; }

    ParserResultInfo* QuickParse_Main(ParserResultInfo* Results_, ParserStatus* Status_, const char* TagName_, char* Text_, char* SyntaxStr_);
    void ShowResults(ParserResultInfo* Results_, int Level_);
    char* GetResultCodeString(ParserResultInfo* Results_, char* Buffer_, int Level_, int SpecLevel_);

    void UseBrackets(Boolean Flag_);    
    void SetStringQuotes(const char* StartQuote_, const char* EndQuote_);
    void SetError(int Code_, int LineNum_=0);

    void CopyParseSymbols(const Parser& Obj_);

    // Token parsing methods
    static int FindTokensHelper(char* str_, SymbolSet* Info_, size_t ArrayLen_, size_t CmpLen_, size_t Index_);
    static int FindTokens(char*& str_, SymbolSet* Info_, size_t ArrayLen_, size_t CmpLen_, int& Nil_);
    
    static int FindToken(char*& str, char* Token_, int RetCode_, int SkipSpaces_, int CaseSensitive_, int Consume_, int TokenWspace_=0);
    static int RepeatFindTokenHelper(char*& str, SymbolSet* Info_, size_t Index_, size_t Len_, int Code_);
    static int RepeatFindToken(char*& str, SymbolSet* Info_, size_t Len_);

    static char* FindWord(char*& str, int& RetVal_, int Code_);                                    // new
    static char* FindField(char*& str, const char* StartDelim_, const char* EndDelim_, int& RetVal_, int Code_, int SkipWs_, int TokenWspace_=0);  // changed
    static int RepeatFindFieldHelper(char*& str, FieldInfo* Array_, size_t Index_, size_t Len_, int Code_);
    static int RepeatFindField(char*& str, FieldInfo* Array_, size_t Len_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif

  public:
    // For external C interface
    static long InitParser();
    static long MakeParser();
    static void DestroyParser(long Index_, Parser* Ptr_);
    static Parser* IndexParser(long Index_);
    static Parser* MakeParserPtr()
        { return Parser::IndexParser(MakeParser()); }    
};


#endif
