/*
**  PRTSTAT.C - Determine printer status
**
**  public domain by Bob Stout
*/

#include <dos.h>

#ifndef PRTSTAT_H
 #include "prtstat.h"
#endif

/*
**  prtstat() - Call with printer number (0 = LPT1, 1 = LPT2, 2 = LPT3)
**
**  Returns status which can be mapped to a PrStatus struct
*/

int prtstat(unsigned int printer_no)
{
      union REGS regs;

      regs.h.ah = 2;
      regs.x.dx = printer_no;
      int86(0x17, &regs, &regs);
      return regs.h.ah;
}

#if PRTSTAT_DEBUG
#include <stdio.h>

#define show(x) printf(#x" is %strue (LPT1)\n", mystat.x ? "" : "not ");

int main()
{
      struct PrStatus mystat;

      *((int *)&mystat) = prtstat(0);
      show(notbusy);
      show(selected);
      show(paperout);
      show(timeout);
      show(IOerror);
      show(ack);
      printf("----------------------------------------\n");

      return 0;
}

#endif
