#ifndef PUSHBUTTON_CPP
#define PUSHBUTTON_CPP
#ifndef PUSHBUTTON_H
  #include "pushbtn.h"
#endif

/****************************************************************************/
/****************************************************************************/
ButtonBox::ButtonBox(char* msg, PromptBox* next_, int Size_):
PromptBox(msg, next_, Size_)
{}

/****************************************************************************/
ButtonBox::ButtonBox(PromptBox& pb, int Size_):
PromptBox(pb, Size_)
{}

/****************************************************************************/
#if !defined(__TURBOC__) & !defined(__BORLANDC__)
ButtonBox::ButtonBox(char* msg, ButtonBox* next_, int Size_):
PromptBox(msg, next_, Size_)
{}
#endif

/****************************************************************************/
#if !defined(__TURBOC__) & !defined(__BORLANDC__)
ButtonBox::ButtonBox(ButtonBox& pb, int Size_):
PromptBox(pb, Size_)
{}
#endif

/****************************************************************************/
void ButtonBox::ShowMessage()
{}

/****************************************************************************/
void ButtonBox::ShowInput(int status_)
{
  if (_len)
  {
    ResetPrompt();

    if (_HotKey && UsesColor())
    {
      text_info txtinfo_;
      gettextinfo(&txtinfo_);
      int OldFg_ = txtinfo_.attribute & 0x0F;

      char* Temps_ = strncpy(new char[_HotIndex + 1], _buffer, _HotIndex);
      Temps_[_HotIndex] = 0;
      CPUTS(Temps_);
      textcolor(HotKeyColor());
      PUTCH(_buffer[_HotIndex]);
      textcolor(OldFg_);
      CPUTS(&_buffer[_HotIndex + 1]);
    }
    else
      CPUTS(_buffer);

    GOTOXY(_xpos + strlen(_msg) + 1, _ypos);

    if (status_ == -1)
      GOTOXY(wherex() + strlen(_buffer), _ypos);
  }
}

/****************************************************************************/
void ButtonBox::ShowInput()
{
  PromptBox::ShowInput();
}

/****************************************************************************/
ButtonBox* ButtonBox::Make(char* msg, PromptBox* next_, int Size_)
{
  ButtonBox* bb;
  bb = new ButtonBox(msg, next_, Size_);
  return bb;
}

/****************************************************************************/
ButtonBox* ButtonBox::Make(PromptBox& pbox, int Size_)
{
  ButtonBox* bb;
  bb = new ButtonBox(pbox, Size_);
  return bb;
}

/****************************************************************************/
PromptBox& ButtonBox::operator = (PromptBox& pb)
{
  if (this != &pb)
    PromptBox::operator = (pb);

  return *this;
}

/****************************************************************************/
ButtonBox& ButtonBox::operator = (ButtonBox& pb)
{
  if (this != &pb)
    PromptBox::operator = (pb);

  return *this;
}

/****************************************************************************/
/****************************************************************************/
PushButton::PushButton(char* Msg_):
_PromptBox(ButtonBox::Make("", NULL, (Msg_ ? (strlen(Msg_) + 3):1))),
_Label(NULL),
_BtnFilter(NULL),
_Selected(FALSE),
_Delay(0),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

_selected_monitor(NULL),
_selected_handle(NULL)
{
  _PromptBox->SetSelectable(TRUE);
  _PromptBox->SetSquareBrackets();

  ResetEndPoints();
  SetLabel(Msg_);
  InitBtnFilter();

  SetHotKeyColor(BUTTONBOX_HKC);
  SetNormalColors(BUTTONBOX_NFG, BUTTONBOX_NBG);
  SetHighLightColors(BUTTONBOX_HFG, BUTTONBOX_HBG);
}

/****************************************************************************/
PushButton::PushButton(PushButton& Pbtn_):
_PromptBox(ButtonBox::Make(*Pbtn_._PromptBox, (Pbtn_._Label ? (strlen(Pbtn_._Label) + 3):1))),
_Label(NULL),
_BtnFilter(NULL),
_Selected(FALSE),
_Delay(0),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

_selected_monitor(NULL),
_selected_handle(NULL)
{
  _PromptBox->SetSelectable(TRUE);
  _PromptBox->SetSquareBrackets();

  ResetEndPoints();
  SetLabel(Pbtn_._Label);
  InitBtnFilter();

  int* NCols_ = Pbtn_.NormalColors();
  int* HCols_ = Pbtn_.HighLightColors();
  int Nfg_, Nbg_, Hfg_, Hbg_;

  if (NCols_)
  {
    Nfg_ = NCols_[0];
    Nbg_ = NCols_[1];
  }
  else
  {
    Nfg_ = BUTTONBOX_NFG;
    Nbg_ = BUTTONBOX_NBG;
  }

  if (HCols_)
  {
    Hfg_ = HCols_[0];
    Hbg_ = HCols_[1];
  }
  else
  {
    Hfg_ = BUTTONBOX_HFG;
    Hbg_ = BUTTONBOX_HBG;
  }

  SetHotKeyColor(Pbtn_.HotKeyColor());
  SetNormalColors(Nfg_, Nbg_);
  SetHighLightColors(Hfg_, Hbg_);
}

/****************************************************************************/
PushButton::~PushButton()
{
  delete[] _Label;
  _Label = NULL;

  delete[] _BtnFilter;
  _BtnFilter = NULL;

  delete _PromptBox;
  _PromptBox = NULL;
}

/****************************************************************************/
int PushButton::GetHotKeyType() const
{
  return _PromptBox->GetHotKeyType();
}

/****************************************************************************/
int PushButton::GetHotKey() const
{
  return _PromptBox->GetHotKey();
}

/****************************************************************************/
int PushButton::GetShortCut() const
{
  return _PromptBox->GetShortCut();
}

/****************************************************************************/
void PushButton::SetSelectable(Boolean Flag_)
{
  _PromptBox->SetSelectable(Flag_);
}

/****************************************************************************/
const int* PushButton::MonitorKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorKey(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorExtendedKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorExtendedKey(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorEscapedStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorEscapedStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorHiddenStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorActiveStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*))
{
  return _PromptBox->MonitorInFocusStatus(This_, FnPtr_);
}

/****************************************************************************/
const int* PushButton::MonitorSelectedStatus(void* This_, const int*(*FnPtr_)(void*, PushButton*, const int*))
{
  _selected_handle = This_;
  _selected_monitor = FnPtr_;
  return &_Selected;
}

/****************************************************************************/
const int* PushButton::Monitor(const int*(*monptr_)(void*, PushButton*, const int*), void* This_, const int* ptr_)
{
  if (monptr_ != NULL)
  {
    SaveCursorPosition();
    const int* RetVal_ = (*monptr_)(This_, this, ptr_);
    RestoreCursorPosition();

    return RetVal_;
  }

  return ptr_;
}

/****************************************************************************/
void PushButton::SaveCursorPosition()
{
  _SavedCursX = WHEREX();
  _SavedCursY = WHEREY();
}

/****************************************************************************/
void PushButton::RestoreCursorPosition()
{
  GOTOXY(_SavedCursX, _SavedCursY);
}

/****************************************************************************/
PushButton& PushButton::operator = (PushButton& Pbtn_)
{
  *_PromptBox = *Pbtn_._PromptBox;
  return *this;
}

/****************************************************************************/
PushButton* PushButton::Make(char* Msg_)
{
  PushButton* cb;
  cb = new PushButton(Msg_);
  return cb;
}

/****************************************************************************/
PushButton* PushButton::Make(PushButton& Pbtn_)
{
  PushButton* cb;
  cb = new PushButton(Pbtn_);
  return cb;
}

/****************************************************************************/
void PushButton::InitBtnFilter()
{
  _BtnFilter = new KeyNode*[MAX_PUSHBUTTON_KEYS];

  // Allowable user response to button dialog prompt
  _BtnFilter[0] = &TextControl::GetKeyMap()[TextControl::ENTER];
  _BtnFilter[1] = &TextControl::GetKeyMap()[TextControl::UP];
  _BtnFilter[2] = &TextControl::GetKeyMap()[TextControl::DOWN];
  _BtnFilter[3] = &TextControl::GetKeyMap()[TextControl::NEXT];
  _BtnFilter[4] = &TextControl::GetKeyMap()[TextControl::ESCAPE];
}

/****************************************************************************/
void PushButton::HighlightEndPoints()
{
  _EndPoints[0] = SIGNAL_RIGHT;
  _EndPoints[1] = SIGNAL_LEFT;
}

/****************************************************************************/
void PushButton::SetLabel(char* Msg_)
{
  if (_Label != Msg_)
  {
    delete[] _Label;
    _Label = Msg_ ? strcpy((new char[strlen(Msg_)+1]), Msg_):
		    strcpy((new char[1]), "");
  }

  if (_Label && strlen(_Label))
  {
    int HkeyPresent_ = strchr(_Label, '&') != NULL;
    char* Buffer_ = new char[strlen(_Label) + 3];
    Buffer_[0] = _EndPoints[0];
    strcpy(&Buffer_[1], _Label);
    Buffer_[strlen(Buffer_) + 1] = 0;
    Buffer_[strlen(Buffer_)] = _EndPoints[1];

    char* FinalLabel_ = HkeyPresent_ ?
	_PromptBox->SetHotKeys(Buffer_):
	Buffer_;

    _PromptBox->SetInputLength(strlen(FinalLabel_));
    _PromptBox->SetInputString(FinalLabel_);

     delete[] Buffer_;
     if (HkeyPresent_)
       delete[] FinalLabel_;
  }
  else
    _PromptBox->RemoveHotKeys();
}

/****************************************************************************/
int PushButton::Prompt(int status_)
{
  int ReturnVal_, Index_;

  if (!IsActive())
    return 1;

  Deselect();

  // Highlight push button dialog for its selected appearance
  SetupColors(ColorInfo::HIGHLIGHT_COLORS);
  HighlightEndPoints();
  SetLabel(_Label);
  ShowInput();

  if (status_)
  {
    Select();
    Monitor(_selected_monitor, _selected_handle, &_Selected);
    ReturnVal_ = 0;
  }
  else
  {
    // Restrict user response to allowable keys by setting key filter
    // include key filter even for control keys: Enter, Tab, Esc...
    for (Index_ = 0; Index_ < MAX_PUSHBUTTON_KEYS; ++Index_)
      _PromptBox->AddCtrlFilter(*_BtnFilter[Index_]);

    // Prompt for user response
    ReturnVal_ = _PromptBox->Prompt(1);

    // Remove key filter after user response is retrieved
    for (Index_ = 0; Index_ < MAX_PUSHBUTTON_KEYS; ++Index_)
      _PromptBox->RemoveCtrlFilter(*_BtnFilter[Index_]);

    // Test if the user selected the push button
    TestIfSelected();
  }

  if (IsSelected() && _Delay)
  {
    textbackground(BUTTONBOX_FBG);
    ShowInput();
    sleep(_Delay);
  }

  // Return push button dialog to its unselected appearance
  SetupColors(ColorInfo::NORMAL_COLORS);
  ResetEndPoints();
  SetLabel(_Label);
  ShowInput();

  return ReturnVal_;
}

/****************************************************************************/
void PushButton::Show()
{
  _PromptBox->Show();
}

/****************************************************************************/
void PushButton::ShowInput()
{
  _PromptBox->ShowInput(1);
}

/****************************************************************************/
void PushButton::Hide()
{
  _PromptBox->Hide();
}

/****************************************************************************/
void PushButton::Erase()
{
  _PromptBox->Erase();
}

/****************************************************************************/
void PushButton::ResetInputState(int status_)
{
  _PromptBox->ResetInputState(status_);
}

/****************************************************************************/
Boolean PushButton::IsOwner(ControlWindow* Cwin_) const
{
  return _PromptBox->IsOwner(Cwin_);
}

/****************************************************************************/
void PushButton::SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_)
{
  _PromptBox->SetOwner(Cwin_, TxtCtrl_);
}

/****************************************************************************/
void PushButton::Select()
{
  _Selected = TRUE;
  Monitor(_selected_monitor, _selected_handle, &_Selected);
}

/****************************************************************************/
void PushButton::Deselect()
{
  _Selected = FALSE;
  Monitor(_selected_monitor, _selected_handle, &_Selected);
}

/****************************************************************************/
void PushButton::TestIfSelected()
{
  _Selected = GetKeyMap().KeyMatch(_PromptBox->LastExtKeyRead(), ENTER);
  Monitor(_selected_monitor, _selected_handle, &_Selected);
}

/****************************************************************************/
Boolean PushButton::IsEnterable() const
{
  return _PromptBox->IsEnterable();
}

/****************************************************************************/
Boolean PushButton::IsSelectable() const
{
  return _PromptBox->IsSelectable();
}

/****************************************************************************/
Boolean PushButton::IsSelected() const
{
  return _Selected;
}

/****************************************************************************/
Boolean PushButton::IsEmpty() const
{
  return _PromptBox->IsEmpty();
}

/****************************************************************************/
Boolean PushButton::IsEscaped() const
{
  return (IsSelected() || _PromptBox->IsEscaped());
}

/****************************************************************************/
Boolean PushButton::IsValid() const
{
  return _PromptBox->IsValid();
}

/****************************************************************************/
Boolean PushButton::IsActive() const
{
  return _PromptBox->IsActive();
}

/****************************************************************************/
Boolean PushButton::IsInFocus() const
{
  return _PromptBox->IsInFocus();
}

/****************************************************************************/
void PushButton::Activate()
{
  _PromptBox->Activate();
}

/****************************************************************************/
void PushButton::Deactivate()
{
  _PromptBox->Deactivate();
}

/****************************************************************************/
void PushButton::UseColor(Boolean Flag_)
{
  _PromptBox->UseColor(Flag_);
}

/****************************************************************************/
void PushButton::SetNormalColors(int FgCol_, int BgCol_)
{
  _PromptBox->SetNormalColors(FgCol_, BgCol_);
}

/****************************************************************************/
void PushButton::SetHighLightColors(int FgCol_, int BgCol_)
{
  _PromptBox->SetHighLightColors(FgCol_, BgCol_);
}

/****************************************************************************/
void PushButton::SetHotKeyColor(int Col_)
{
  _PromptBox->SetHotKeyColor(Col_);
}

/****************************************************************************/
void PushButton::SetBackGroundColor(int Col_)
{
  _PromptBox->SetBackGroundColor(Col_);
}

/****************************************************************************/
void PushButton::UseDefaultColors()
{
  _PromptBox->UseDefaultColors();
}

/****************************************************************************/
void PushButton::SetupColors(int Mode_)
{
  _PromptBox->SetupColors(Mode_);
}

/****************************************************************************/
Boolean PushButton::UsesColor() const
{
  return _PromptBox->UsesColor();
}

/****************************************************************************/
int* PushButton::NormalColors() const
{
  return _PromptBox->NormalColors();
}

/****************************************************************************/
int* PushButton::HighLightColors() const
{
  return _PromptBox->HighLightColors();
}

/****************************************************************************/
int PushButton::HotKeyColor() const
{
  return _PromptBox->HotKeyColor();
}

/****************************************************************************/
int PushButton::BackGroundColor() const
{
  return _PromptBox->BackGroundColor();
}

/****************************************************************************/
void PushButton::SetDelay(unsigned Delay_)
{
  _Delay = Delay_;
}

/****************************************************************************/
void PushButton::NoDelay()
{
  _Delay = 0;
}

/****************************************************************************/
/****************************************************************************/
PushWindow::PushWindow(int Max_):
PromptWindow(Max_)
{}

/****************************************************************************/
PushWindow::PushWindow(PushWindow& cw):
PromptWindow(cw)
{}

/****************************************************************************/
void PushWindow::DeselectAll()
{
  for (int Index_ = 0; Index_ < _maxbox; Index_++)
    if (_pbox[Index_])
      _pbox[Index_]->Deselect();
}

/****************************************************************************/
// PURPOSE:
//   Method to Grow the size of the array by some number passed as an
//   argument to the method. The array contents are preserved.
//
// PRE:
//   The old size of the Prompt box array and its contents
//
// POST:
//   The array size is Grown by the extra size given and the original
//   contents of the array are preserved in the new array.
//
void PushWindow::Grow(int extra)
{
  int index;
  int newlen = _maxbox + extra;

  TextControl** newp = new TextControl*[newlen];
  ControlInfo* newi = new ControlInfo(newlen);

  for (index = 0; index < _maxbox; index++)
  {
    newp[index] = PushButton::Make(*((PushButton*)_pbox[index]));
    SetControlData(newp, newi, index);
  }

  for (;index < newlen; index++)
    RemoveControlData(newp, newi, index);

  Clear();

  _maxbox = newlen;
  _pbox = newp;
  _Info = newi;
}

/****************************************************************************/
// PURPOSE:
//   Cycle through the entire Prompt box array and Prompt the user with
//   each one.
//
// POST:
//   The Prompt box array is cycled through and each Prompt box element
//   within the array is used to Prompt the user.
//
int PushWindow::Prompt(int StartIndex_)
{
  int index = (StartIndex_ >= _maxbox) ? 0:
	      (StartIndex_ < 0)        ? (_maxbox - 1):
					 StartIndex_;
  int status_;
  int placemark_ = 0;

  DeselectAll();

  if (AnyActive())
    for (;;)
    {
      if (_pbox[index] && _pbox[index]->IsActive())
      {
	if (placemark_)
	  ((*this)[index])->ResetInputState(0);

	status_ = _pbox[index]->Prompt(placemark_);
	Boolean hkeypressed_ = _Info->HotKeyPressed();

	if (hkeypressed_)
	{
	  if (status_ != 0)
	    index = _Info->GetIndex();

	  placemark_ = (hkeypressed_ == TextControl::SHORTCUT);
	  _Info->ResetHotKeys();
	}

	if (!hkeypressed_ || !status_)
	{
	  if (_pbox[index]->IsEscaped())
	    break;

	  index += status_;
	  placemark_ = 0;
	}
      }
      else
	++index;

      index = (index >= _maxbox) ? 0:
	      (index < 0) 	 ? (_maxbox - 1):
				   index;
    }

  return index;
}

/****************************************************************************/
void PushWindow::SetDelay(unsigned Delay_)
{
  int index;
  for (index = 0; index < _maxbox; index++)
    if (_pbox[index])
      ((*this)[index])->SetDelay(Delay_);
}

/****************************************************************************/
void PushWindow::NoDelay()
{
  int index;
  for (index = 0; index < _maxbox; index++)
    if (_pbox[index])
      ((*this)[index])->NoDelay();
}

/****************************************************************************/
// PURPOSE:
//   Prompt box Index operator. To index individual Prompt boxes from the
//   Prompt window given the position of the Prompt box within the array.
//
// PRE:
//   int index : the index position of the Prompt box in the array
//
// POST:
//   Go into the specified index position in the Prompt box array and
//   Retrieve its element.
//
PushWindowRef PushWindow::operator [] (int index)
{
  ASSERT((index >= 0 && index < _maxbox), USER_Message_t::ERRMSG_INDEXRANGE);

  PushWindowRef CboxRef(this, index);
  return CboxRef;
}

/****************************************************************************/
PushButton* PushWindow::NextSelected(int& Start_)
{
  Boolean Found_ = FALSE;

  for (;Start_ < _maxbox; Start_++)
    if (Found_ = _pbox[Start_] != NULL && _pbox[Start_]->IsSelected())
      break;

  if (Found_)
  {
    ++Start_;
    return (*this)[Start_ - 1];
  }

  return NULL;
}

/****************************************************************************/
/****************************************************************************/
PushWindowRef::PushWindowRef(PushWindow* Boss_, int Index_):
_BossPtr(Boss_),
_Index(Index_)
{}

/****************************************************************************/
PushWindowRef& PushWindowRef::operator = (PushButton* Pbox_)
{
  _BossPtr->Control(_Index, Pbox_);
  return *this;
}

/****************************************************************************/
PushWindowRef::operator PushButton* ()
{
  return CastToPushButton(_BossPtr->Control(_Index));
}

/****************************************************************************/
PushButton* PushWindowRef::operator -> ()
{
  return CastToPushButton(_BossPtr->Control(_Index));
}

/****************************************************************************/
void PushWindowRef::ResetInputState(int status_)
{
  CastToPushButton(_BossPtr->Control(_Index))->ResetInputState(status_);
}

/****************************************************************************/
void PushWindowRef::SetDelay(unsigned Delay_)
{
  CastToPushButton(_BossPtr->Control(_Index))->SetDelay(Delay_);
}

/****************************************************************************/
void PushWindowRef::NoDelay()
{
  CastToPushButton(_BossPtr->Control(_Index))->NoDelay();
}

/****************************************************************************/
/****************************************************************************/
#if PUSHBUTTON_DEBUG
int main()
{
//  CLRSCR();

  PushButton* pb;
  PushWindow pw;

  pw.MaxControl(1);

  pb = PushButton::Make("&Button 1");
  pb->SetXpos(3);
  pb->SetYpos(2);
  pw[0] = pb;

  pw.Grow(3);

  pb = PushButton::Make("B&utton 2");
  pb->SetXpos(3);
  pb->SetYpos(4);
  pw[1] = pb;

  pb = PushButton::Make("Bu&tton 3");
  pb->SetXpos(3);
  pb->SetYpos(6);
  pw[2] = pb;

  pb = PushButton::Make("Butt&on 4");
  pb->SetXpos(3);
  pb->SetYpos(8);
  pw[3] = pb;

  pw.UseColor();
  pw.SetDelay();
  pw.Show();  
  pw.Prompt();

  int index;

  GOTOXY(1, 15);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  pw.Show();
  pw.Prompt();

  GOTOXY(1, 15);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  pw.UseColor(FALSE);
  pw.Hide();
  return 0;
}
#endif
/****************************************************************************/
#endif

