#ifndef PUSHBUTTON_H
#define PUSHBUTTON_H
#ifndef PROMPTBOX_H
  #include "promptbox.h"
#endif

#define PUSHBUTTON_DEBUG	0

/****************************************************************************/
class PushButton;

class ButtonBox : public PromptBox
{
  friend class PushButton;
  protected:
    // promptbox constructors
    ButtonBox(char* msg, PromptBox* next_, int Size_);
    ButtonBox(PromptBox& pb, int Size_);

#if !defined(__TURBOC__) & !defined(__BORLANDC__)
    ButtonBox(char* msg, ButtonBox* next_, int Size_);
    ButtonBox(ButtonBox& pb, int Size_);
#endif

    static ButtonBox* Make(char* msg=NULL, PromptBox* next_=NULL, int Size_=0);
    static ButtonBox* Make(PromptBox& pbox, int Size_=0);

    // show prompt box methods
    virtual void ShowMessage();
    virtual void ShowInput();
    virtual void ShowInput(int status_);

    // Text color methods
    void SetupColors(int Mode_)
	{ PromptBox::SetupColors(Mode_); }

    // console input retrieval methods
    void ResetInputState(int status_)
	{ PromptBox::ResetInputState(status_); }
    void SetSelectable(Boolean Flag_)
	{ PromptBox::SetSelectable(Flag_); }

  public:
    virtual PromptBox& operator = (PromptBox& pb);
    virtual ButtonBox& operator = (ButtonBox& pb);
};

/****************************************************************************/
class PushWindowRef;
class PushWindow;

class PushButton : public TextControl
{
  friend class PushWindowRef;
  friend class PushWindow;

  public:
    enum { FLASH_DELAY = 1 };

  protected:
    enum { MAX_PUSHBUTTON_KEYS = 5,
	   SIGNAL_RIGHT = 16, SIGNAL_LEFT = 17};
    enum { BUTTONBOX_NFG = BLACK,
	   BUTTONBOX_NBG = LIGHTGRAY,
	   BUTTONBOX_HFG = WHITE,
	   BUTTONBOX_HBG = GREEN,
	   BUTTONBOX_FBG = CYAN,
           BUTTONBOX_HKC = RED};

    ButtonBox* _PromptBox;
    int _Selected;
    KeyNode** _BtnFilter;
    char* _Label;
    char _EndPoints[2];

    int _Delay;
    int _SavedCursX;			// Saved cursor x position
    int _SavedCursY;			// Saved cursor y position

    // Internal data monitoring function pointers
    // Handles to external objects, used by data monitors
    const int*(*_selected_monitor)(void*, PushButton*, const int*);
    void* _selected_handle;

    // Monitor functions execution and management methods
    const int* Monitor(const int*(*monptr_)(void*, PushButton*, const int*), void* This_, const int* ptr_);
    void SaveCursorPosition();
    void RestoreCursorPosition();
    void ResetInputState(int status_);

    // internal prompt box access method
    PromptBox& GetPromptBox()
	{ return *_PromptBox; }

    // Method to reset the endpoints of a push button dialog label
    inline void ResetEndPoints()
	{ _EndPoints[0] = _EndPoints[1] = ' '; }

    // Method to highlight the endpoints of a push button dialog label
    void HighlightEndPoints();

    // Initialize key filter for push button dialogs
    void InitBtnFilter();

    // prompt box properties mutators
    void TestIfSelected();

    // Text color methods
    void SetupColors(int Mode_);

    // promptbox constructors
    PushButton(char* Msg_);
    PushButton(PushButton& Pbtn_);

  public:
    virtual ~PushButton();

    // promptbox assignment operator
    virtual PushButton& operator = (PushButton& Pbtn_);
    static PushButton* Make(char* Msg_=NULL);
    static PushButton* Make(PushButton& Pbtn_);

    void SetLabel(char* Msg_);
    inline void SetXYpos(int x, int y)
	{ _PromptBox->SetXYpos(x, y); }
    inline void SetXpos(int x)
	{ _PromptBox->SetXpos(x); }
    inline void SetYpos(int y)
	{ _PromptBox->SetYpos(y); }

    // prompt box manipulators
    virtual void Show();
    virtual void ShowInput();
    virtual void Hide();
    virtual int Prompt(int status_);
    virtual void Erase();

    // Dialog selection mutators
    virtual void SetSelectable(Boolean Flag_);
    virtual void Select();
    virtual void Deselect();

    // Empty, valid and selected Text Control test
    virtual Boolean IsEnterable() const;
    virtual Boolean IsSelectable() const;
    virtual Boolean IsSelected() const;
    virtual Boolean IsEmpty() const;
    virtual Boolean IsEscaped() const;
    virtual Boolean IsValid() const;
    virtual Boolean IsActive() const;
    virtual Boolean IsInFocus() const;

    // Activation/Deactivation for this text widget
    virtual void Activate();
    virtual void Deactivate();

    // Accelerator key methods
    virtual int GetHotKeyType() const;
    virtual int GetHotKey() const;
    virtual int GetShortCut() const;

    // Control Ownership methods
    virtual void SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_);
    virtual Boolean IsOwner(ControlWindow* Cwin_) const;

    // Text color methods
    virtual void UseColor(Boolean Flag_);
    virtual void SetNormalColors(int FgCol_, int BgCol_);
    virtual void SetHighLightColors(int FgCol_, int BgCol_);
    virtual void SetHotKeyColor(int Col_);
    virtual void SetBackGroundColor(int Col_);
    virtual void UseDefaultColors();

    virtual Boolean UsesColor() const;
    virtual int* NormalColors() const;
    virtual int* HighLightColors() const;
    virtual int HotKeyColor() const;
    virtual int BackGroundColor() const;

    // Flash delay method
    void SetDelay(unsigned Delay_=FLASH_DELAY);
    void NoDelay();

    // Internal data monitoring methods
    const int* MonitorKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorExtendedKey(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorEscapedStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, PromptBox*, const int*));
    const int* MonitorSelectedStatus(void* This_, const int*(*FnPtr_)(void*, PushButton*, const int*));
};

/****************************************************************************/
/****************************************************************************/
class PushWindow : public PromptWindow
{
  friend class PushWindowRef;

  protected:
    void DeselectAll();

  public:
    // prompt window constructors
    PushWindow(int Max_=0);
    PushWindow(PushWindow& cw);
    ~PushWindow()
	{ Clear(); }

    // grow array method
    virtual void Grow(int extra);

    // prompt window manipulators
    virtual int Prompt(int StartIndex_=0);

    // Flash delay method
    void SetDelay(unsigned Delay_=PushButton::FLASH_DELAY);
    void NoDelay();

    // Push box control access method
    PushWindowRef operator [] (int index);
    PushButton* NextSelected(int& Start_);
};

/****************************************************************************/
class PushWindowRef
{
  friend class PushWindow;
  private:
    PushWindow* _BossPtr;
    int _Index;

    PushWindowRef(PushWindow* Boss_, int Index_);

    static PushButton* CastToPushButton(TextControl* TxtCtrl_)
	{ return ((PushButton*)TxtCtrl_); }

    void ResetInputState(int status_);
    void SetDelay(unsigned Delay_=PushButton::FLASH_DELAY);
    void NoDelay();

  public:
    PushWindowRef& operator = (PushButton* Pbox_);
    operator PushButton* ();
    PushButton* operator -> ();
};

/****************************************************************************/
#endif

