#ifndef RADIOBUTTON_CPP
#define RADIOBUTTON_CPP
#ifndef RADIOBUTTON_H
  #include "radiobtn.h"
#endif

const char *const RadioButton::RADIO_BUTTON_MARKER = "*";

/****************************************************************************/
/****************************************************************************/
RadioButton::RadioButton(char* Msg_, Boolean Checked_):
CheckBox(Msg_, Checked_)
{
  strcpy(_Marker, RADIO_BUTTON_MARKER);
  _PromptBox->SetInputLength(1);
  _PromptBox->SetRoundBrackets();
  _PromptBox->SetFilter(" ");

  SetCheck(Checked_);
}

/****************************************************************************/
RadioButton::RadioButton(RadioButton& Rbtn_):
CheckBox(Rbtn_)
{
  strcpy(_Marker, RADIO_BUTTON_MARKER);
  _PromptBox->SetInputLength(1);
  _PromptBox->SetRoundBrackets();
  _PromptBox->SetFilter(" ");

  SetCheck(Rbtn_.IsSelected());
}

/****************************************************************************/
RadioButton* RadioButton::Make(char* Msg_, Boolean Checked_)
{
  RadioButton* rb;
  rb = new RadioButton(Msg_, Checked_);
  return rb;
}

/****************************************************************************/
RadioButton* RadioButton::Make(RadioButton& Rbtn_)
{
  RadioButton* rb;
  rb = new RadioButton(Rbtn_);
  return rb;
}

/****************************************************************************/
void RadioButton::SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_)
{
  GetPromptBox().SetOwner(Cwin_, TxtCtrl_);
}

/****************************************************************************/
/****************************************************************************/
RadioWindow::RadioWindow(int Max_):
PromptWindow(Max_),
_NoEmpty(TRUE)
{}

/****************************************************************************/
RadioWindow::RadioWindow(RadioWindow& cw):
PromptWindow(cw),
_NoEmpty(cw._NoEmpty)
{}

/****************************************************************************/
void RadioWindow::IncludeOnlyThis(int ThisIndex_)
{
  for (int Index_ = 0; Index_ < _maxbox; Index_++)
    if (Index_ != ThisIndex_ && _pbox[Index_])
    {
      _pbox[Index_]->Deselect();
      _pbox[Index_]->ShowInput();
    }

  if (_NoEmpty && !_pbox[ThisIndex_]->IsSelected())
  {
    _pbox[ThisIndex_]->Select();
    _pbox[ThisIndex_]->ShowInput();
  }
}

/****************************************************************************/
void RadioWindow::Control(int Index_, TextControl* TxtCtrl_)
{
  _pbox[Index_] = TxtCtrl_;

  if (_pbox[Index_])
    SetControlData(_pbox, _Info, Index_);

  if (TxtCtrl_->IsSelected())
    IncludeOnlyThis(Index_);
}

/****************************************************************************/
TextControl* RadioWindow::Control(int Index_)
{
  return PromptWindow::Control(Index_);
}

/****************************************************************************/
// PURPOSE:
//   Method to Grow the size of the array by some number passed as an
//   argument to the method. The array contents are preserved.
//
// PRE:
//   The old size of the Prompt box array and its contents
//
// POST:
//   The array size is Grown by the extra size given and the original
//   contents of the array are preserved in the new array.
//
void RadioWindow::Grow(int extra)
{
  int index;
  int newlen = _maxbox + extra;

  TextControl** newp = new TextControl*[newlen];
  ControlInfo* newi = new ControlInfo(newlen);

  for (index = 0; index < _maxbox; index++)
  {
    newp[index] = RadioButton::Make(*((RadioButton*)_pbox[index]));
    SetControlData(newp, newi, index);
  }

  for (;index < newlen; index++)
    RemoveControlData(newp, newi, index);

  Clear();

  _maxbox = newlen;
  _pbox = newp;
  _Info = newi;
}

/****************************************************************************/
// PURPOSE:
//   Cycle through the entire Prompt box array and Prompt the user with
//   each one.
//
// POST:
//   The Prompt box array is cycled through and each Prompt box element
//   within the array is used to Prompt the user.
//
int RadioWindow::Prompt(int StartIndex_)
{
  int index = (StartIndex_ >= _maxbox) ? 0:
	      (StartIndex_ < 0)        ? (_maxbox - 1):
					 StartIndex_;
  int status_;
  int placemark_ = 0;

  if (AnyActive())
    for (;;)
    {
      if (_pbox[index] && _pbox[index]->IsActive())
      {
	if (placemark_)
	  (*this)[index].ResetInputState(0);

	status_ = _pbox[index]->Prompt(placemark_);
	Boolean hkeypressed_ = _Info->HotKeyPressed();

	if (hkeypressed_)
	{
	  if (status_ != 0)
	    index = _Info->GetIndex();

	  placemark_ = (hkeypressed_ == TextControl::SHORTCUT);
	  _Info->ResetHotKeys();
	}

	if (!hkeypressed_ || !status_)
	{
	  if (_pbox[index]->IsEscaped())
	    break;
	  else if ((*this)[index].Toggled())
	    IncludeOnlyThis(index);
	  else
	    index += status_;

	  placemark_ = 0;
	}
      }
      else
	++index;

      index = (index >= _maxbox) ? 0:
	      (index < 0) 	 ? (_maxbox - 1):
				   index;
    }

  return index;
}

/****************************************************************************/
// PURPOSE:
//   Prompt box Index operator. To index individual Prompt boxes from the
//   Prompt window given the position of the Prompt box within the array.
//
// PRE:
//   int index : the index position of the Prompt box in the array
//
// POST:
//   Go into the specified index position in the Prompt box array and
//   Retrieve its element.
//
RadioWindowRef RadioWindow::operator [] (int index)
{
  ASSERT((index >= 0 && index < _maxbox), USER_Message_t::ERRMSG_INDEXRANGE);

  RadioWindowRef RbtnRef(this, index);
  return RbtnRef;
}

/****************************************************************************/
RadioButton* RadioWindow::NextSelected(int& Start_)
{
  Boolean Found_ = FALSE;

  for (;Start_ < _maxbox; Start_++)
    if (Found_ = _pbox[Start_] != NULL && _pbox[Start_]->IsSelected())
      break;

  if (Found_)
  {
    ++Start_;
    return (*this)[Start_ - 1];
  }

  return NULL;
}

/****************************************************************************/
void RadioWindow::SetNoEmpty(int flag)
{
  _NoEmpty = flag;
}

/****************************************************************************/
/****************************************************************************/
RadioWindowRef::RadioWindowRef(RadioWindow* Boss_, int Index_):
_BossPtr(Boss_),
_Index(Index_)
{}

/****************************************************************************/
RadioWindowRef& RadioWindowRef::operator = (RadioButton* Rbtn_)
{
  _BossPtr->Control(_Index, Rbtn_);
  return *this;
}

/****************************************************************************/
RadioWindowRef::operator RadioButton* ()
{
  return CastToRadioButton(_BossPtr->Control(_Index));
}

/****************************************************************************/
RadioButton* RadioWindowRef::operator -> ()
{
  return CastToRadioButton(_BossPtr->Control(_Index));
}

/****************************************************************************/
Boolean RadioWindowRef::Toggled()
{
  return CastToRadioButton(_BossPtr->Control(_Index))->Toggled();
}

/****************************************************************************/
void RadioWindowRef::ResetInputState(int status_)
{
  CastToRadioButton(_BossPtr->Control(_Index))->ResetInputState(status_);
}

/****************************************************************************/
/****************************************************************************/
#if RADIOBUTTON_DEBUG
int main()
{
  CLRSCR();

  RadioButton* pb;
  RadioWindow pw;

  pw.MaxControl(1);

  pb = RadioButton::Make("&Radiobox 1 : ");
  pb->SetXpos(3);
  pb->SetYpos(2);
  pw[0] = pb;

  pw.Grow(3);

  pb = RadioButton::Make("R&adiobox 2 : ");
  pb->SetXpos(3);
  pb->SetYpos(4);
  pw[1] = pb;

  pb = RadioButton::Make("Ra&diobox 3 : ");
  pb->SetXpos(3);
  pb->SetYpos(6);
  pw[2] = pb;

  pb = RadioButton::Make("Radi&obox 4 : ");
  pb->SetXpos(3);
  pb->SetYpos(8);
  pw[3] = pb;

  int index;

  pw.UseColor();
  pw.Show();
  pw.Prompt();
  pw.UseColor(FALSE);
  pw.Hide();

  GOTOXY(1, 1);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  pw.UseColor();
  pw.Show();
  pw.Prompt();
  pw.UseColor(FALSE);
  pw.Hide();

  GOTOXY(1, 1);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }

  pw.SetNoEmpty();
  pw.UseColor();
  pw.Show();
  pw.Prompt();
  pw.UseColor(FALSE);
  pw.Hide();

  GOTOXY(1, 1);
  for (index = 0; index < pw.MaxControl(); index++)
  {
    pb = pw[index];
    cout <<pb->IsSelected() <<endl;
    GETCH();
  }
  
  return 0;
}
#endif
/****************************************************************************/
#endif

