#ifndef RADIOBUTTON_H
#define RADIOBUTTON_H
#ifndef CHECKBOX_H
  #include "checkbox.h"
#endif

#define RADIOBUTTON_DEBUG		0

/****************************************************************************/
class RadioWindowRef;
class RadioWindow;

class RadioButton : public CheckBox
{
  friend class RadioWindowRef;
  friend class RadioWindow;

  protected:
    static const char *const RADIO_BUTTON_MARKER;

    // promptbox constructors
    RadioButton(char* Msg_, Boolean Checked_);
    RadioButton(RadioButton& Rbtn_);

  public:
    // promptbox assignment operator
    static RadioButton* Make(char* Msg_=NULL, Boolean Checked_=FALSE);
    static RadioButton* Make(RadioButton& Rbtn_);

    virtual void SetOwner(ControlWindow* Cwin_, TextControl* TxtCtrl_);
};

/****************************************************************************/
/****************************************************************************/
class RadioWindow : public PromptWindow
{
  friend class RadioWindowRef;

  protected:
    int _NoEmpty;

    void IncludeOnlyThis(int ThisIndex_);

    // Text Control accessor method
    virtual void Control(int Index_, TextControl* TxtCtrl_);
    virtual TextControl* Control(int Index_);

  public:
    // prompt window constructors
    RadioWindow(int Max_=0);
    RadioWindow(RadioWindow& cw);
    ~RadioWindow()
	{ Clear(); }

    // grow array method
    virtual void Grow(int extra);

    // prompt window manipulators
    virtual int Prompt(int StartIndex_=0);

    // Check box control access method
    RadioWindowRef operator [] (int index);
    RadioButton* NextSelected(int& Start_);

    // At least one radio box selected, No empty selections allowed
    void SetNoEmpty(int flag=1);
};

/****************************************************************************/
class RadioWindowRef
{
  friend class RadioWindow;
  private:
    RadioWindow* _BossPtr;
    int _Index;

    RadioWindowRef(RadioWindow* Boss_, int Index_);

    Boolean Toggled();
    void ResetInputState(int status_);
    static RadioButton* CastToRadioButton(TextControl* TxtCtrl_)
	{ return ((RadioButton*)TxtCtrl_); }

  public:
    RadioWindowRef& operator = (RadioButton* Rbtn_);
    operator RadioButton* ();
    RadioButton* operator -> ();
};

/****************************************************************************/
#endif

