#ifndef SIMPLEARRAY_CPP
#define SIMPLEARRAY_CPP
#ifndef SIMPLEARRAY_H
  #include "simplearray.h"
#endif

/****************************************************************************/
// SimpleBaseArray static data memebers
/****************************************************************************/
template <class P, class B>
int(*SimpleBaseArray<P,B>::_CompFunc)(const B&, const B&) = NULL;

/****************************************************************************/
// SimpleArray static data memebers
/****************************************************************************/
template <class T>
SimpleArray<T>* SimpleArray<T>::_StaticClassPtr = NULL;

template <class T>
bool SimpleArray<T>::_StaticIsBuiltIn = true;

template <class T>
size_t SimpleArray<T>::m_ObjectCnt = 0;

template <class T>
bool SimpleArray<T>::m_AutoRelease = false;

template <class T>
bool SimpleArray<T>::m_StaticCreate = false;

template <class T>
bool SimpleArray<T>::m_StaticDestroy = false;

/****************************************************************************/
// SimpleVector static data memebers
/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::_StaticClassPtr = NULL;

template <class T>
bool SimpleVector<T>::_AutoErase = false;

template <class T>
MemAllocMethod SimpleVector<T>::_AllocMethod = STD_NEW;

template <class T>
int* SimpleVector<T>::_StaticTrIndex = NULL;

template <class T>
bool SimpleVector<T>::_StaticIsBuiltIn = true;

template <class T>
size_t SimpleVector<T>::m_ObjectCnt = 0;

template <class T>
bool SimpleVector<T>::m_AutoRelease = false;

template <class T>
bool SimpleVector<T>::m_StaticCreate = false;

template <class T>
bool SimpleVector<T>::m_StaticDestroy = false;

/****************************************************************************/
// SimpleMatrix static data memebers
/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::_StaticClassPtr = NULL;

template <class T>
bool SimpleMatrix<T>::_AutoErase = false;

template <class T>
MemAllocMethod SimpleMatrix<T>::_AllocMethod = MEMMATRIX;

template <class T>
int* SimpleMatrix<T>::_StaticTrIndex = NULL;

template <class T>
bool SimpleMatrix<T>::_StaticIsBuiltIn = false;

template <class T>
size_t SimpleMatrix<T>::m_ObjectCnt = 0;

template <class T>
bool SimpleMatrix<T>::m_AutoRelease = false;

template <class T>
bool SimpleMatrix<T>::m_StaticCreate = false;

template <class T>
bool SimpleMatrix<T>::m_StaticDestroy = false;

/****************************************************************************/
// Simple3DMatrix static data memebers
/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::_StaticClassPtr = NULL;

template <class T>
bool Simple3DMatrix<T>::_AutoErase = false;

template <class T>
MemAllocMethod Simple3DMatrix<T>::_AllocMethod = MEMMATRIX;

template <class T>
int* Simple3DMatrix<T>::_StaticTrIndex = NULL;

template <class T>
bool Simple3DMatrix<T>::_StaticIsBuiltIn = false;

template <class T>
size_t Simple3DMatrix<T>::m_ObjectCnt = 0;

template <class T>
bool Simple3DMatrix<T>::m_AutoRelease = false;

template <class T>
bool Simple3DMatrix<T>::m_StaticCreate = false;

template <class T>
bool Simple3DMatrix<T>::m_StaticDestroy = false;

/****************************************************************************/
// SimpleBaseArray Class Definition
/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray():
_Error(FALSE),
_Size(0),
_Buffer(NULL),
_UseMemMgr(true)
{}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray(size_t n, bool UseMemMgr_):
_Error(FALSE),
_Size(n),
_Buffer(UseMemMgr_ ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*n):
                     (new P[n])),
_UseMemMgr(UseMemMgr_)
{
  ::memset(_Buffer, 0, sizeof(P) * n);
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray(const P* a, size_t n, bool UseMemMgr_):
_Error(FALSE),
_Size(n),
_Buffer(UseMemMgr_ ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*n):
                     (new P[n])),
_UseMemMgr(UseMemMgr_)
{
  size_t x;
  ::memset(_Buffer, 0, sizeof(P) * n);
  
  for (x = 0; x < n; x++)
    _Buffer[x] = a[x];
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray(const SimpleBaseArray<P,B>& Arr_,
                                      size_t start_, size_t end_, bool UseMemMgr_):
_Error(FALSE),
_Size((end_ > start_) ? (end_ - start_ + 1):Arr_._Size),
_Buffer(UseMemMgr_ ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*FindDist(start_, end_, Arr_)):
                     (new P[FindDist(start_, end_, Arr_)])),
_UseMemMgr(UseMemMgr_)
{
  if (_Size)
    ::memset(_Buffer, 0, sizeof(P) * _Size);

  if (end_ > start_ && end_ < Arr_._Size)
  {
    size_t x, y;
    size_t max = end_ - start_;

    for (x = 0, y = start_; x <= max; x++, y++)
      _Buffer[x] = Arr_._Buffer[y];
  }
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray(const SimpleBaseArray<P,B>& Arr_, bool UseMemMgr_):
_Error(FALSE),
_Size(Arr_._Size),
_Buffer(UseMemMgr_ ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*Arr_._Size):
                     (new P[Arr_._Size])),
_UseMemMgr(UseMemMgr_)
{
  size_t x;
  ::memset(_Buffer, 0, sizeof(P) * _Size);
  
  for (x = 0; x < Arr_._Size; x++)
    _Buffer[x] = Arr_._Buffer[x];
}
    
/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::SimpleBaseArray(const SimpleBaseArray<P,B> & a1, const SimpleBaseArray<P,B> & a2,
                                      bool UseMemMgr_):
_Error(FALSE),
_Size(a1._Size + a2._Size),
_Buffer(UseMemMgr_ ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*(a1._Size+a2._Size)):
                     (new P[a1._Size+a2._Size])),
_UseMemMgr(UseMemMgr_)
{
  size_t x, y;
  x = 0;
  ::memset(_Buffer, 0, sizeof(P) * _Size);
  
  for (y = 0; y < a1._Size; x++, y++)
    _Buffer[x] = a1._Buffer[y];

  for (y = 0; y < a2._Size; x++, y++)
    _Buffer[x] = a2._Buffer[y];
}
    
/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::~SimpleBaseArray()
{
  if (_UseMemMgr)
    ::DeleteArray(_Buffer);
  else
    delete _Buffer;
    
  _Buffer = NULL;
}

/****************************************************************************/
template <class P, class B>
size_t SimpleBaseArray<P,B>::FindDist(size_t start_, size_t end_,
                                      const SimpleBaseArray<P,B>& Arr_)
{
  return ((end_ > start_) ? (end_ - start_ + 1):Arr_._Size);
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::GrowArray(size_t Incr_)
{
  size_t x;
  size_t OldSz_ = _Size;
  P* OldBuf_ = _Buffer;

  _Size += Incr_;
  _Buffer = _UseMemMgr ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*_Size):
                         (new P[_Size]);
  ::memset(_Buffer, 0, sizeof(P) * _Size);

  for (x = 0; x < OldSz_; x++)
    _Buffer[x] = OldBuf_[x];

  if (_UseMemMgr)
    ::DeleteArray(_Buffer);
  else
    delete _Buffer;
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::FillFrom(int i, P v)
{
  size_t x = i;
  for (;x < _Size; x++)
    _Buffer[x] = v;
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::FillFrom(const Index& i, P v)
{
  size_t x = size_t(i);
  for (;x < _Size; x++)
    _Buffer[x] = v;
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::Fill(P i)
{
  size_t x;
  for (x = 0; x < _Size; x++)
    _Buffer[x] = i;
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::SetComparisonFunction(int(*CompFunc_)(const B&, const B&))
{
  SimpleBaseArray<P,B>::_CompFunc = CompFunc_;
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>& SimpleBaseArray<P,B>::operator = (const SimpleBaseArray<P,B>& Arr_)
{
  if (this != &Arr_)
  {
    if (_UseMemMgr)
      ::DeleteArray(_Buffer);
    else
      delete _Buffer;
  
    _Error = Arr_._Error;
    _Size = Arr_._Size;
    _Buffer = _UseMemMgr ? (P*)RawAllocateWith(MEMMATRIX, sizeof(P)*Arr_._Size):
                           (new P[Arr_._Size]);
    ::memset(_Buffer, 0, sizeof(P) * _Size);

    size_t x;
    for (x = 0; x < _Size; x++)
      _Buffer[x] = Arr_._Buffer[x];    
  }

  return *this;
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::operator const P* () const
{
  return _Buffer;
}

/****************************************************************************/
template <class P, class B>
SimpleBaseArray<P,B>::operator P* ()
{
  return _Buffer;
}

/****************************************************************************/
template <class P, class B>
size_t SimpleBaseArray<P,B>::GetCount() const
{
  return _Size;
}

/****************************************************************************/
template <class P, class B>
P& SimpleBaseArray<P,B>::operator [] (const Index & i)
{
  static P Dummy_ = P(0);

  int z = 0;
  int v = int(i);
  if (z <= v && v < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class P, class B>
P& SimpleBaseArray<P,B>::operator [] (int i)
{
  static P Dummy_ = P(0);

  int z = 0;
  if (z <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class P, class B>    
const P SimpleBaseArray<P,B>::operator [] (const Index & i) const
{
  static P Dummy_ = P(0);

  int z = 0;
  int v = int(i);
  if (z <= v && v < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class P, class B>    
const P SimpleBaseArray<P,B>::operator [] (int i) const
{
  static P Dummy_ = P(0);

  int z = 0;
  if (z <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;  
}

/****************************************************************************/
template <class P, class B>
const P SimpleBaseArray<P,B>::Read(const Index & i) const
{
  static P Dummy_ = P(0);
  int Num_ = size_t(i);

  if (0 <= Num_ && Num_ < _Size)
    return _Buffer[Num_];

  return Dummy_;
}

/****************************************************************************/
template <class P, class B>    
const P SimpleBaseArray<P,B>::Read(int i) const
{
  static P Dummy_ = P(0);

  if (0 <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
#if OVERLOAD_NEW
template <class P, class B>
void* SimpleBaseArray<P,B>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if HAS_ARRAY_NEW
template <class P, class B>
void* SimpleBaseArray<P,B>::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class P, class B>
void SimpleBaseArray<P,B>::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif

/****************************************************************************/
// SimpleArrayIter Class Definition
/****************************************************************************/
template <class T>
SimpleArrayIter<T>::SimpleArrayIter(SimpleArray<T>& a):
_Target(a),
_ElemFirst(a.Base()),
_ElemLast(a.Base()),
_ElemPtr(a.Base())
{
  if (a.Base() && a.GetCount() > 0)
    _ElemLast = &a.Base()[a.GetCount()-1];
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>::SimpleArrayIter(const SimpleArrayIter<T>& aptr):
_Target(aptr._Target),
_ElemFirst(aptr._ElemFirst),
_ElemLast(aptr._ElemLast),
_ElemPtr(aptr._ElemPtr)
{
  if (_Target.Base() && _Target.GetCount() > 0)
    _ElemLast = &_Target.Base()[_Target.GetCount()-1];
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>& SimpleArrayIter<T>::operator = (const SimpleArrayIter<T> & aptr)
{
  if (this != &aptr)
  {
    _Target = aptr._Target;
    _ElemFirst = aptr._ElemFirst;
    _ElemLast = aptr._ElemLast;
    _ElemPtr = aptr._ElemPtr;

    if (_Target.Base() && _Target.GetCount() > 0)
      _ElemLast = &_Target.Base()[_Target.GetCount()-1];
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>& SimpleArrayIter<T>::operator = (const Index& i)
{
  size_t Num_ = size_t(i);
  size_t zero = 0;
  size_t len = 0;

  if (_ElemFirst)
  {
    len = _Target.RunLength();
    if (zero <= Num_ && (Num_ < len || !len))
      _ElemPtr = &_ElemFirst[Num_];
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>& SimpleArrayIter<T>::operator = (size_t i)
{
  size_t Num_ = i;
  size_t zero = 0;
  size_t len = 0;

  if (_ElemFirst)
  {
    len = _Target.RunLength();
    if (zero <= Num_ && (Num_ < len || !len))
      _ElemPtr = &_ElemFirst[Num_];
  }

  return *this;
}

/****************************************************************************/
template <class T>
bool SimpleArrayIter<T>::IsNull() const
{
  return (_ElemPtr == ((T*)NULL));
}

/****************************************************************************/
template <class T>
T& SimpleArrayIter<T>::operator * ()
{
  static T Dummy_;
  return (_ElemPtr ? *_ElemPtr:Dummy_);
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>& SimpleArrayIter<T>::operator ++ ()
{
  if (_ElemPtr != _ElemLast)
    _ElemPtr++;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T> SimpleArrayIter<T>::operator ++ (int dummy)
{
  SimpleArrayIter result(*this);

  if (_ElemPtr != _ElemLast)
    _ElemPtr++;

  return result;
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T>& SimpleArrayIter<T>::operator -- ()
{
  if (_ElemPtr != _ElemFirst)
    _ElemPtr--;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleArrayIter<T> SimpleArrayIter<T>::operator -- (int dummy)
{
  SimpleArrayIter result(*this);

  if (_ElemPtr != _ElemFirst)
    _ElemPtr--;

  return result;
}

/****************************************************************************/
template <class T>
void SimpleArrayIter<T>::SetFirst()
{
  _ElemPtr = _ElemFirst;
}

/****************************************************************************/
template <class T>
void SimpleArrayIter<T>::SetLast()
{
  _ElemPtr = _ElemLast;
}

/****************************************************************************/
template <class T>
int SimpleArrayIter<T>::IsFirst()
{
  return (_ElemPtr == _ElemFirst);
}

/****************************************************************************/
template <class T>    
int SimpleArrayIter<T>::IsLast()
{
  return (_ElemPtr == _ElemLast);
}

/****************************************************************************/
template <class T>    
int SimpleArrayIter<T>::operator == (const SimpleArrayIter<T>& aptr)
{
  return (_ElemPtr == aptr._ElemPtr);
}

/****************************************************************************/
template <class T>    
int SimpleArrayIter<T>::operator != (const SimpleArrayIter<T>& aptr)
{
  return (_ElemPtr != aptr._ElemPtr);
}

/****************************************************************************/
#if OVERLOAD_NEW
template <class T>
void* SimpleArrayIter<T>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void SimpleArrayIter<T>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if HAS_ARRAY_NEW
template <class T>
void* SimpleArrayIter<T>::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void SimpleArrayIter<T>::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif

/****************************************************************************/
// SimpleArrayIter Class Definition
/****************************************************************************/
template <class T>
SimpleVectorIter<T>::SimpleVectorIter(SimpleVector<T>& a):
_Target(a),
_ElemFirst(a.Base()),
_ElemLast(a.Base()),
_ElemPtr(a.Base())
{
  a.FindVectorRunLength();
  if (a.Base() && a.GetCount() > 0)
    _ElemLast = &a.Base()[a.GetCount()-1];
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>::SimpleVectorIter(const SimpleVectorIter<T>& aptr):
_Target(aptr._Target),
_ElemFirst(aptr._ElemFirst),
_ElemLast(aptr._ElemLast),
_ElemPtr(aptr._ElemPtr)
{
  _Target.FindVectorRunLength();
  if (_Target.Base() && _Target.GetCount() > 0)
    _ElemLast = &_Target.Base()[_Target.GetCount()-1];
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>& SimpleVectorIter<T>::operator = (const SimpleVectorIter<T> & aptr)
{
  if (this != &aptr)
  {
    _Target = aptr._Target;
    _ElemFirst = aptr._ElemFirst;
    _ElemLast = aptr._ElemLast;
    _ElemPtr = aptr._ElemPtr;

    _Target.FindVectorRunLength();
    if (_Target.Base() && _Target.GetCount() > 0)
      _ElemLast = &_Target.Base()[_Target.GetCount()-1];
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>& SimpleVectorIter<T>::operator = (const Index& i)
{
  size_t Num_ = size_t(i);
  size_t zero = 0;
  size_t len = 0;

  if (_ElemFirst)
  {
    len = _Target.RunLength();
    if (zero <= Num_ && (Num_ < len || !len))
      _ElemPtr = &_ElemFirst[Num_];
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>& SimpleVectorIter<T>::operator = (size_t i)
{
  size_t Num_ = i;
  size_t zero = 0;
  size_t len = 0;

  if (_ElemFirst)
  {
    len = _Target.RunLength();
    if (zero <= Num_ && (Num_ < len || !len))
      _ElemPtr = &_ElemFirst[Num_];
  }

  return *this;
}

/****************************************************************************/
template <class T>
bool SimpleVectorIter<T>::IsNull() const
{
  return (_ElemPtr == ((T**)NULL));
}

/****************************************************************************/
template <class T>
T*& SimpleVectorIter<T>::operator * ()
{
  static T* Dummy_ = NULL;
  Dummy_ = NULL;  // ensure runtime initialization of NULL pointer value

  return (_ElemPtr ? *_ElemPtr:Dummy_);
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>& SimpleVectorIter<T>::operator ++ ()
{
  if (_ElemPtr != _ElemLast)
    _ElemPtr++;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T> SimpleVectorIter<T>::operator ++ (int dummy)
{
  SimpleVectorIter result(*this);

  if (_ElemPtr != _ElemLast)
    _ElemPtr++;

  return result;
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T>& SimpleVectorIter<T>::operator -- ()
{
  if (_ElemPtr != _ElemFirst)
    _ElemPtr--;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleVectorIter<T> SimpleVectorIter<T>::operator -- (int dummy)
{
  SimpleVectorIter result(*this);

  if (_ElemPtr != _ElemFirst)
    _ElemPtr--;

  return result;
}

/****************************************************************************/
template <class T>
void SimpleVectorIter<T>::SetFirst()
{
  _ElemPtr = _ElemFirst;
}

/****************************************************************************/
template <class T>
void SimpleVectorIter<T>::SetLast()
{
  _ElemPtr = _ElemLast;
}

/****************************************************************************/
template <class T>
int SimpleVectorIter<T>::IsFirst()
{
  return (_ElemPtr == _ElemFirst);
}

/****************************************************************************/
template <class T>    
int SimpleVectorIter<T>::IsLast()
{
  return (_ElemPtr == _ElemLast);
}

/****************************************************************************/
template <class T>    
int SimpleVectorIter<T>::operator == (const SimpleVectorIter<T>& aptr)
{
  return (_ElemPtr == aptr._ElemPtr);
}

/****************************************************************************/
template <class T>    
int SimpleVectorIter<T>::operator != (const SimpleVectorIter<T>& aptr)
{
  return (_ElemPtr != aptr._ElemPtr);
}

/****************************************************************************/
#if OVERLOAD_NEW
template <class T>
void* SimpleVectorIter<T>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void SimpleVectorIter<T>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if HAS_ARRAY_NEW
template <class T>
void* SimpleVectorIter<T>::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void SimpleVectorIter<T>::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif

/****************************************************************************/
// PointerReturner class definition
/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>::PointerReturner():
_Data(NULL),
_Base(NULL),
_Container(NULL),
_Index(0),
_Size(0),
_TransCode(0)
{}

/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>::PointerReturner(C* Cont_, size_t Index_, size_t Size_,
                                      int Code_, T** Ptr_):
_Data(Cont_ ? Cont_->Data():NULL),
_Base(Ptr_ ? Ptr_:
      Cont_ ? Cont_->Buffer():NULL),
_Container(Cont_),
_Index(Index_),
_Size(Size_),
_TransCode(Code_)
{}

/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>::PointerReturner(const PointerReturner<T,C>& Obj_):
_Data(Obj_._Data),
_Base(Obj_._Base),
_Container(Obj_._Container),
_Index(Obj_._Index),
_Size(Obj_._Size),
_TransCode(Obj_._TransCode)
{}

/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>& PointerReturner<T,C>::operator = (T* Val_)
{
  if (size_t(0) <= _Index && _Index < _Size)
  {    
    if (_Data && _Container &&
          (_TransCode == VectorInfo::STARTSC ||
           _TransCode == VectorInfo::MTOSTRANS))
    {
      if (_Data[_Index])
        _Container->EraseElement(_Data, _Index, _Size);
    
      _Data[_Index] = Val_;
        
      if (_Container)
        _Container->SetDataRefs(_Data, _Index);
    }
  
    if (_Base && _Container &&
          (_TransCode == VectorInfo::STOMTRANS ||
           _TransCode == VectorInfo::STARTMO))
    {
      if (_Base[_Index])
        _Container->EraseElement(_Base, _Index, _Size);
    
      _Base[_Index] = Val_;
      
      if (_Container)
        _Container->SetDataRefs(_Base, _Index);
    }
  }
    
  return *this;
}

/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>& PointerReturner<T,C>::operator = (PointerReturner<T,C>& Obj_)
{
  if (this != &Obj_)
  {
    _Data = Obj_._Data;
    _Base = Obj_._Base;
    _Container  = Obj_._Container;
    _Index = Obj_._Index;
    _Size = Obj_._Size;
    _TransCode = Obj_._TransCode;
  }

  return *this;
}

/****************************************************************************/
template <class T, class C>
PointerReturner<T,C>::operator T* ()
{
  if (size_t(0) <= _Index && _Index < _Size)
  {
    if (_Data &&
        _TransCode == VectorInfo::MTOSTRANS)
      return _Data[_Index];

    if (_Data &&
        _TransCode == VectorInfo::STARTSC)
      return (_Data[_Index] ? _Data[_Index]:
              _Base ? _Base[_Index]:NULL);

    if (_Base &&
        _TransCode == VectorInfo::STOMTRANS)
      return (_Base[_Index] ? _Base[_Index]:
              _Data ? _Data[_Index]:NULL);

    if (_Base &&
        _TransCode == VectorInfo::STARTMO)
      return _Base[_Index];
  }

  return NULL;
}

/****************************************************************************/
// PointerCopyNode class definition
/****************************************************************************/
template <class T>
PointerCopyNode<T>::PointerCopyNode():
_Data(NULL),
_Next(NULL)
{}

/****************************************************************************/
template <class T>
PointerCopyNode<T>::PointerCopyNode(T* Ptr_):
_Data(Ptr_),
_Next(NULL)
{}

/****************************************************************************/
template <class T>
PointerCopyNode<T>::~PointerCopyNode()
{
  _Data = NULL;
  delete _Next;
  _Next = NULL;
}
/****************************************************************************/
template <class T>
bool PointerCopyNode<T>::HasThis(T* Val_, PointerCopyNode<T>::NPTYPE* Node_)
{
  PointerCopyNode<T>* List_ = NULL;
  for (List_ = this; List_ && List_->_Data != Val_; List_ = List_->_Next);
  bool Found_ = List_ && List_->_Data == Val_;
  if (Found_ && Node_)
    *Node_ = List_;
  return Found_;
}

/****************************************************************************/
template <class T>
bool PointerCopyNode<T>::HasThis(T* Val_) const
{
  const PointerCopyNode<T>* List_ = NULL;
  for (List_ = this; List_ && List_->_Data != Val_; List_ = List_->_Next);
  bool Found_ = List_ && List_->_Data == Val_;
  return Found_;
}

/****************************************************************************/
template <class T>
PointerCopyNode<T>* PointerCopyNode<T>::Push(T* Val_)
{
  PointerCopyNode<T>* NewHead_ = new PointerCopyNode<T>(Val_);
  NewHead_->SetNext(this);
  return NewHead_;
}

/****************************************************************************/
template <class T>
PointerCopyNode<T>* PointerCopyNode<T>::Pop(PointerCopyNode<T>*& NewHead_)
{
  NewHead_ = _Next;
  _Next = NULL;
  return this;
}

/****************************************************************************/
template <class T>
PointerCopyNode<T>* PointerCopyNode<T>::Swap(PointerCopyNode<T>* Head_)
{
  T* Temp_ = _Data;
  _Data = Head_->_Data;
  Head_->_Data = Temp_;

  return Head_;
}

/****************************************************************************/
template <class T>
void PointerCopyNode<T>::SetNext(PointerCopyNode<T>* Ptr_)
{
  _Next = Ptr_;
}

/****************************************************************************/
#if OVERLOAD_NEW
template <class T>
void* PointerCopyNode<T>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void PointerCopyNode<T>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if HAS_ARRAY_NEW
template <class T>
void* PointerCopyNode<T>::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T>
void PointerCopyNode<T>::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif

/****************************************************************************/
// PointerCopyTracker class definition
/****************************************************************************/
template <class T, class D>
PointerCopyTracker<T,D>::PointerCopyTracker(T* Parent_):
_Head(NULL),
_Parent(Parent_),
_Master(NULL),
_Data(NULL),
_Size(0),
_SelfErase(false),
_EraseData(false),
_OwnsData(false),
_ShallowCopy(false),
_DataCreated(false),
_Unlinked(false)
{}

/****************************************************************************/
template <class T, class D>
PointerCopyTracker<T,D>::PointerCopyTracker(const PointerCopyTracker<T,D>& Obj_):
_Head(Obj_._Head),
_Parent(Obj_._Parent),
_Master(Obj_._Master),
_Data(Obj_._Data),
_Size(Obj_._Size),
_SelfErase(false),
_EraseData(Obj_._EraseData),
_OwnsData(Obj_._OwnsData),
_ShallowCopy(Obj_._ShallowCopy),
_DataCreated(false),
_Unlinked(false)
{
  bool Shallow_ = Obj_.IsOwnershipAttrib(false, false, true) ||
                  Obj_.IsOwnershipAttrib(true, true, false);
  if (Shallow_)
    _Unlinked = Obj_.IsUnlinked();
}

/****************************************************************************/
template <class T, class D>
PointerCopyTracker<T,D>::~PointerCopyTracker()
{
  EraseData();
  UntrackCopyRefs();

  bool Shallow_ = (_OwnsData && _SelfErase && !_ShallowCopy) ||
                  (!_OwnsData && !_SelfErase && _ShallowCopy);

  if (Shallow_)
  {
    bool NotSameMem_ = _Parent && _Parent->Base() != _Data;
    if (!PtrUnlinked(_Parent) && _Parent != _Master)    
    {
      _Parent->AssignDataArray(NULL, 0);
      _Parent = NULL;
    }

    if (_Data && _DataCreated && NotSameMem_)
    {
      #if SIMPLEARRAY_DEBUG1
        #if SIMPLEARRAY_DEBUG1a
          if (_Parent)
          {
            cout <<"Parent: " <<_Parent->ClassID();
            cout <<":" <<_Parent->ObjectID();
          }
          cout <<" : DeleteArray" <<endl;
        #else
          if (_Parent)
            cout <<"Parent: " <<_Parent->ObjectID();
          cout <<" : DeleteArray" <<endl;
        #endif
      #endif
    
      ::DeleteArray(_Data);
      _Data = NULL;
    }    
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::EraseElement(D** Data_, size_t Index_, size_t sz)
{
  MemAllocMethod Method_ = _Parent ? _Parent->AllocMethod():STD_NEW;
  bool Shallow_ = IsOwnershipAttrib(false, false, true) ||
                  IsOwnershipAttrib(true, true, false);

  if ((Shallow_ && Data_ != _Data) ||
      (!Shallow_ && (!_Parent || Data_ != _Parent->Base())))
    return;

  if ((_OwnsData && _ShallowCopy &&
       HasThis(_Parent) && _Parent->Base()) ||
      (_ShallowCopy && _Data))
    Method_ = MEMMATRIX;

  if (Method_ == MEMMATRIX && !_Parent->IsMultiDimType())
  {
    if (Data_)
      if (Index_ < sz)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            if (_Parent)
            {
              cout <<"Parent: " <<_Parent->ClassID();
              cout <<":" <<_Parent->ObjectID();
            }
            cout <<" : EraseElement(";
          #else
            if (_Parent)
              cout <<"Parent: " <<_Parent->ObjectID();
            cout <<" : EraseElement(";
          #endif

          if (Data_[Index_])
            cout <<*Data_[Index_] <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (_Parent && _Parent->ObjectID() && Data_[Index_])
        {          
          if (MemMatrix::Matrix().HasThis(Data_[Index_]))
            ::RawDelete(Data_[Index_]);
          else
            delete Data_[Index_];
        
          Data_[Index_] = NULL;
          if (!Shallow_)
            _Data[Index_] = NULL;
        }
      }
  }
  else if (Method_ == STD_NEW || _Parent->IsMultiDimType())
  {
    if (Data_)
      if (Index_ < sz)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            if (_Parent)
            {
              cout <<"Parent: " <<_Parent->ClassID();
              cout <<":" <<_Parent->ObjectID();
            }
            cout <<" : EraseElement(";
          #else
            if (_Parent)
              cout <<"Parent: " <<_Parent->ObjectID();
            cout <<" : EraseElement(";
          #endif

          if (Data_[Index_])
            cout <<*Data_[Index_] <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (_Parent && _Parent->ObjectID() && Data_[Index_])
        {
          delete Data_[Index_];
          
          Data_[Index_] = NULL;
          if (!Shallow_)
            _Data[Index_] = NULL;
        }
      }
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::DoErase(MemAllocMethod Method_, D** Data_, size_t sz)
{
  int x;
  
  if (Method_ == MEMMATRIX && !_Parent->IsMultiDimType())
  {
    if (Data_)
      for (x = 0; x < sz; x++)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            if (_Parent)
            {
              cout <<"Parent: " <<_Parent->ClassID();
              cout <<":" <<_Parent->ObjectID();
            }
            cout <<" : DoErase(";
          #else
            if (_Parent)
              cout <<"Parent: " <<_Parent->ObjectID();
            cout <<" : DoErase(";
          #endif

          if (Data_[x])
            cout <<*Data_[x] <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (_Parent && _Parent->ObjectID() && Data_[x])
        {          
          if (MemMatrix::Matrix().HasThis(Data_[x]))
            ::RawDelete(Data_[x]);
          else
            delete Data_[x];
        
          Data_[x] = NULL;
        }
      }
  }
  else if (Method_ == STD_NEW || _Parent->IsMultiDimType())
  {
    if (Data_)
      for (x = 0; x < sz; x++)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            if (_Parent)
            {
              cout <<"Parent: " <<_Parent->ClassID();
              cout <<":" <<_Parent->ObjectID();
            }
            cout <<" : DoErase(";
          #else
            if (_Parent)
              cout <<"Parent: " <<_Parent->ObjectID();
            cout <<" : DoErase(";
          #endif

          if (Data_[x])
            cout <<*Data_[x] <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (_Parent && _Parent->ObjectID() && Data_[x])
        {
          delete Data_[x];
          Data_[x] = NULL;
        }
      }
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::EraseData()
{
  MemAllocMethod Method_ = _Parent ? _Parent->AllocMethod():STD_NEW;
  // SetOwnershipAttrib(bool OwnsData_, bool SelfErase_, bool Shallow_)

    if (_OwnsData)
    {
      if (_ShallowCopy)
      {
        // Shallow copy object to master object
        //   SetOwnershipAttrib(true, false, true);
        //
        if (_Parent && HasThis(_Parent) && _Parent->Base() && !_Unlinked)
        {
          // return calls to all shallow objects to notify destruction
          RetCallToShallow(true, true);
        
          // Deletes _Buffer[x] in destructor
          if (_Parent)
          {
            Method_ = MEMMATRIX;
            
            DoErase(Method_, _Parent->Base(), _Parent->GetCount());
            SetData(_Parent->Base(), _Parent->GetCount(), _Parent->AutoErase());
            _DataCreated = false;
          }
        }
      }
      else
      {
        // Created master object to shallow copy
        //   SetOwnershipAttrib(true, true, false);
        //
        if (_SelfErase)        
        {
          // No more referencing vector nodes in linked list
          if (!_Head)
          {
            // removes _Master->Base() from P* _Buffer;
            bool NotSameMem_ = _Parent && _Parent->Base() != _Data;
            if (!PtrUnlinked(_Parent) && _Parent != _Master)
              _Parent->AssignDataArray(NULL, 0);

            // Deletes _Data[x] in destructor
            if (_Data && NotSameMem_)
            {
              // Erase vector element data?
              if (_EraseData && !PtrUnlinked(_Parent))
                DoErase(Method_, _Data, _Size);
              
              if (_DataCreated)
              {
                ::DeleteArray(_Data);
                _Data = NULL;
              }
            }
          }
        }

        // Initially created master object
        //   SetOwnershipAttrib(true, false, false);
        //
        else
        {
          // Deletes _Buffer[x] in destructor
          if (!_Head && _Parent)
          {
            // Erase vector element data?
            if (_EraseData && _Parent->Base() && !_Unlinked)
            {
              // return calls to all shallow objects to notify destruction
              RetCallToShallow(true, true);

              if (_Parent)
              {
                DoErase(Method_, _Parent->Base(), _Parent->GetCount());
                SetData(_Parent->Base(), _Parent->GetCount(), _Parent->AutoErase());
                _DataCreated = false;
              }
            }
          }
        }
      }
    }

    // Create object as shallow copy
    //   SetOwnershipAttrib(false, false, true);
    //
    else if (_ShallowCopy)
    {
      // removes _Master->Base() from P* _Buffer;
      bool NotSameMem_ =  _Parent && _Parent->Base() != _Data;
      if (!PtrUnlinked(_Parent) && _Parent != _Master)
        _Parent->AssignDataArray(NULL, 0);
    
      // Deletes _Data[x] in destructor
      if (_Data && NotSameMem_)
      {
        Method_ = MEMMATRIX;
        
        DoErase(Method_, _Data, _Size);

        if (_DataCreated)
        {
          ::DeleteArray(_Data);
          _Data = NULL;
        }
      }
    }   
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::PtrUnlinked(T* Ptr_)
{
  return (Ptr_ == NULL || Ptr_->IsUnlinked());
}

/****************************************************************************/
template <class T, class D>
T* PointerCopyTracker<T,D>::MasterPtr()
{
  return ((!PtrUnlinked(_Master) && !_Unlinked) ? _Master:NULL);
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::RetCallToShallow(bool Unlinked_, bool InitCall_)
{
  T* Data_ = NULL;
  bool Shallow_ = IsOwnershipAttrib(false, false, true) ||
                  IsOwnershipAttrib(true, true, false);

  if (Shallow_ || InitCall_)
    _Unlinked = Unlinked_;

  if (_Unlinked)
  {
    PointerCopyNode<T>* List_ = _Head;
    
    while (List_)
    {
      Data_ = List_->Data();
      if (Data_ && Data_ != _Parent)
        Data_->RetCallToShallow(_Unlinked, false);
      
      List_ = List_->Next();
    }
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::RemoveCopyRefs(T* Ptr_)
{
  PointerCopyNode<T>* Node_ = NULL;
  
  if (MasterPtr() && _Master->HasThis(Ptr_, &Node_))
  {
    _Master->Swap(Ptr_, Node_);
    _Master->Pop();
  }
  else if (!_Unlinked && _Parent && _Parent->HasThis(Ptr_, &Node_))
  {
    _Parent->Swap(Ptr_, Node_);
    _Parent->Pop();
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::AppendCopyRefs(T* Ptr_, bool ChainAppend_)
{
  if (!_OwnsData && _ShallowCopy && MasterPtr() && Ptr_)
  {
    if (ChainAppend_ && _Parent)
    {
      Ptr_->Push(_Parent);
      if (_Parent != _Master)
        _Master->Push(Ptr_);
    }
    else if (!ChainAppend_)
      _Master->Push(Ptr_);
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::SetDataRefs(D** Element_, size_t Index_)
{
  if (_Parent && Element_ && _Parent->IsMultiDimType())
    _Parent->SetDataRefs(Element_, Index_);
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::SetMaster(T* Ptr_, bool OwnsData_)
{
  // valid data ownership combinations:
  bool MtoStrans_ = _OwnsData && !_SelfErase && !OwnsData_ && Ptr_ != NULL;
  bool StoMtrans_ = _ShallowCopy && OwnsData_ && Ptr_ == NULL;
  bool StartSc_ = (_SelfErase || !_OwnsData) && !OwnsData_ && Ptr_ != NULL;
  bool StartMo_ = (!_ShallowCopy && !_OwnsData) && OwnsData_ && Ptr_ == NULL;
  bool ParentOk_ = !PtrUnlinked(_Parent);
                
  if (Ptr_ && !Ptr_->IsUnlinked() && ParentOk_)
  {
    // Ptr_ != NULL means shallow copy object
    //
    if (IsValidTrans(VectorInfo::MTOSTRANS, MtoStrans_))
    {
      // Created master object to shallow copy
      // Initial/Master Owner to Shallow Copy:
      //   // Phase 1
      //   _Master = Ptr_;
      //   _Head = Push(this->_Parent), Push(Slave_->_Parent)... // from previous master object pushes;
      //   _Data = _Parent->Base();  // done 1st, former deep array
      //   _EraseData = _Parent->AutoErase();
      //   P* _Buffer = _Parent->AssignDataArray(_Master->Base());  // done 2nd
      //   _SelfErase = true;
      //   _OwnsData = true;
      //   _ShallowCopy = false;
      //   _Parent->ReplaceCopyTracker(this);
      //   Pop(_Parent);
      //   // MemAllocMethod follows _Parent
      //   // new T data goes to _Data
      //   // [] operator always returns _Data[x]
      //   // Deletes _Data[x] in destructor,
      //      removes _Master->Base() from P* _Buffer;
      //   // Self erases and calls destructor upon last node removed in _Head
      //   // if _DataCreated
      //        Deletes _Data array
      //
      //   // Phase 2
      //   _Master = Ptr_;
      //   _Master->Push(this->_Parent);
      //   _Head = NULL;
      //   _Data = NULL;
      //   _EraseData = false;
      //   P* _Buffer = _Parent->AssignDataArray(_Master->Base());
      //   _SelfErase = false;
      //   _OwnsData = false;
      //   _ShallowCopy = true;
      //   // MemAllocMethod = MEMMATRIX
      //   // new T data goes to _Data
      //   // [] operator returns _Buffer[x] if _Data[x] == NULL else _Data[x]
      //   // Deletes _Data[x] in destructor,
      //      removes _Master->Base() from P* _Buffer;
      //   // if _DataCreated
      //        Deletes _Data array

      _Master = Ptr_;  // Pointer to master object
      _Unlinked = false;
      SetData(_Parent->Base(), _Parent->GetCount(), _Parent->AutoErase());
      if (!PtrUnlinked(_Parent) && _Parent != _Master)
        _Parent->AssignDataArray(_Master->Base(), _Master->GetCount());
      SetOwnershipAttrib(true, true, false);
      _Parent->ReplaceCopyTracker(this, Ptr_);      
    }
    else if (IsValidTrans(VectorInfo::STARTSC, StartSc_))
    {
      // Create object as shallow copy
      // Shallow Copy:
      //   _Master = Ptr_;
      //   _Master->Push(this->_Parent);
      //   _Head = NULL;
      //   _Data = NULL;
      //   _EraseData = false;
      //   P* _Buffer = _Parent->AssignDataArray(_Master->Base());
      //   _SelfErase = false;
      //   _OwnsData = false;
      //   _ShallowCopy = true;
      //   // MemAllocMethod = MEMATRIX
      //   // new T data goes to _Data
      //   // [] operator returns _Buffer[x] if _Data[x] == NULL else _Data[x]
      //   // Deletes _Data[x] in destructor
      //      removes _Master->Base() from P* _Buffer;
      //   // if _DataCreated
      //        Deletes _Data array      

      _Master = Ptr_;  // Pointer to master object
      _Master->Push(_Parent);
      if (_Parent != _Master)
        UntrackCopyRefs();
      size_t cnt = _Master->GetCount();
      D** Temp_ = (D**)RawAllocateWith(MEMMATRIX, sizeof(D*) * cnt);
      _Unlinked = false;
      _DataCreated = true;
      SetData(InitDataArray(Temp_, cnt), cnt);
      if (!PtrUnlinked(_Parent) && _Parent != _Master)
        _Parent->AssignDataArray(_Master->Base(), _Master->GetCount());
      SetOwnershipAttrib(false, false, true);
    }
  }
  else if (Ptr_ == NULL && ParentOk_)
  {
    if (IsValidTrans(VectorInfo::STOMTRANS, StoMtrans_))
    {
      // Shallow copy object to master object
      // Shallow Copy to Master Owner:
      //   _Master = NULL;
      //   _Head = Push(this->_Parent), Push(&CopiedVector) ...;
      //   Temp_ = _Parent->Base();                       // done 1st
      //   P* _Buffer = _Parent->AssignDataArray(_Data);  // done 2nd
      //   _Data = Temp_;  // done 3rd, former shallow array
      //   _EraseData = false;
      //   _SelfErase = false;
      //   _OwnsData = true;
      //   _ShallowCopy = true;
      //   // MemAllocMethod = MEMMATRIX
      //   // new T data goes to _Buffer
      //   // [] operator returns _Data[x] if _Buffer[x] == NULL else _Buffer[x]
      //   // Deletes _Buffer[x] in destructor

      _Master = NULL;
      Push(_Parent);
      D** Temp_ = _Parent->Base();
      size_t cnt = _Parent->GetCount();
      _Parent->AssignDataArray(_Data, _Size);
      _Parent->SetAllocationMethod(MEMMATRIX);
      _Unlinked = false;
      SetData(Temp_, cnt, false);
      SetOwnershipAttrib(true, false, true);
    }
    else if (IsValidTrans(VectorInfo::STARTMO, StartMo_))
    {
      // Initially created master object
      // Initial Owner:
      //   _Master = NULL;
      //   _Head = Push(this->_Parent), Push(&CopiedVector) ...;
      //   _Data = _Parent->Base();
      //   _EraseData = _Parent->AutoErase();
      //   P* _Buffer = new T;
      //   _SelfErase = false;
      //   _OwnsData = true;
      //   _ShallowCopy = false;
      //   // MemAllocMethod follows _Parent
      //   // new T data goes to _Buffer;
      //   // [] operator always returns _Buffer[x]
      //   // Deletes _Buffer[x] in destructor

      _Master = NULL;
      Push(_Parent);
      _DataCreated = false;
      _Unlinked = false;
      SetData(_Parent->Base(), _Parent->GetCount(), _Parent->AutoErase());
      SetOwnershipAttrib(true, false, false);
    }
  }
}

/****************************************************************************/
template <class T, class D>
D** PointerCopyTracker<T,D>::InitDataArray(D** Data_, size_t sz)
{
  int x = 0;
  if (sz > 0 && Data_)
    while (x < sz)
      Data_[x++] = NULL;

  return Data_;
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::CheckUnlinked()
{
  if (_Parent)
  {
    bool Shallow_ = _Parent->IsOwnershipAttrib(false, false, true) ||
                    _Parent->IsOwnershipAttrib(true, true, false);
    if (Shallow_)
      _Unlinked = _Parent->IsUnlinked();
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::UntrackCopyRefs()
{
  delete _Head;
  _Head = NULL;
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::SetData(D** Data_, size_t sz, bool AutoErase_)
{
  _Data = Data_;
  _Size = sz;
  _EraseData = AutoErase_;
}

/****************************************************************************/
template <class T, class D>
int PointerCopyTracker<T,D>::IsOwnershipAttribExt(bool OwnsData_, bool SelfErase_, bool Shallow_,
                                                  int TransCode_) const
{
  return (IsOwnershipAttrib(OwnsData_, SelfErase_, Shallow_) ? TransCode_:0);
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::ValidAttribTrans(bool Od_, bool Se_, bool Sc_,
                                               bool NewOd_, bool NewSe_, bool NewSc_,
                                               bool TransOd_, bool TransSe_, bool TransSc_) const
{
  return (_OwnsData == Od_ && _SelfErase == Se_ && _ShallowCopy == Sc_ &&
          NewOd_ == TransOd_ && NewSe_ == TransSe_ && NewSc_ == TransSc_);
}

/****************************************************************************/
template <class T, class D>
int PointerCopyTracker<T,D>::IsTransitionAttrib(int TransCode_) const
{
  return
  (
    (TransCode_ == VectorInfo::MTOSTRANS) ?
        IsOwnershipAttribExt(true, true, false, TransCode_):
    (TransCode_ == VectorInfo::STOMTRANS) ?
        IsOwnershipAttribExt(true, false, true, TransCode_):
    (TransCode_ == VectorInfo::STARTSC) ?
        IsOwnershipAttribExt(false, false, true, TransCode_):
    (TransCode_ == VectorInfo::STARTMO) ?
        IsOwnershipAttribExt(true, false, false, TransCode_):0
  );
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::IsValidTrans(int TransCode_, bool TransCond_) const
{
  if (TransCode_ == VectorInfo::MTOSTRANS)
  {
    return
    (
      ValidAttribTrans(true, false, false, true, true, false,
                       TransCond_, TransCond_, !TransCond_) ||
      ValidAttribTrans(true, false, true, true, true, false,
                       TransCond_, TransCond_, !TransCond_)
    );
  }
  else if (TransCode_ == VectorInfo::STARTSC)
  {
    return
    (
      ValidAttribTrans(true, true, false, false, false, true,
                       !TransCond_, !TransCond_, TransCond_) ||
      ValidAttribTrans(false, false, false, false, false, true,
                       !TransCond_, !TransCond_, TransCond_)
    );
  }
  else if (TransCode_ == VectorInfo::STOMTRANS)
  {
    return
    (
      ValidAttribTrans(false, false, true, true, false, true,
                       TransCond_, !TransCond_, TransCond_)
    );
  }
  else if (TransCode_ == VectorInfo::STARTMO)
  {
    return
    (
      ValidAttribTrans(false, false, false, true, false, false,
                       TransCond_, !TransCond_, !TransCond_)
    );
  }
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::SetOwnershipAttrib(bool OwnsData_, bool SelfErase_, bool Shallow_)
{
  _OwnsData = OwnsData_;
  _SelfErase = SelfErase_;
  _ShallowCopy = Shallow_;
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::HasCopyRefs() const
{
  return (_Head != NULL);
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::HasThis(T* ToFind_, PointerCopyNode<T>::NPTYPE* Node_)
{
  return ((_Head && ToFind_) ? _Head->HasThis(ToFind_, Node_):false);
}

/****************************************************************************/
template <class T, class D>
bool PointerCopyTracker<T,D>::HasThis(T* ToFind_) const
{
  return ((_Head && ToFind_) ? _Head->HasThis(ToFind_):false);
}

/****************************************************************************/
template <class T, class D>
T* PointerCopyTracker<T,D>::Push(T* Val_)
{
  if (!HasThis(Val_))
    if (_Head)
    {
       PointerCopyNode<T>* NewHead_ = _Head->Push(Val_);
      _Head = NewHead_;
    }
    else
      _Head = new PointerCopyNode<T>(Val_);

  return Val_;
}

/****************************************************************************/
template <class T, class D>
T* PointerCopyTracker<T,D>::Swap(T* Head_, PointerCopyNode<T>* Node_)
{
  PointerCopyNode<T>* List_ = NULL;
  if (Node_)
    List_ = Node_;  
  else
  {
    List_ = _Head;
    while (List_ && List_->Data() != Head_)
      List_ = List_->Next();
  }

  if (_Head && List_ && List_ != _Head)
  {
    _Head->Swap(List_);
    return _Head->Data();
  }

  return NULL;
}

/****************************************************************************/
template <class T, class D>
T* PointerCopyTracker<T,D>::Pop()
{
  T* Temp_ = NULL;

  if (_Head)
  {
    Temp_ = _Head->Data();
    PointerCopyNode<T>* NewHead_ = _Head;
    PointerCopyNode<T>* List_ = _Head->Pop(NewHead_);    
    _Head = NewHead_;
    
    delete List_;
    List_ = NULL;

    if (!_Head && _SelfErase)
      delete this;
  }

  return Temp_;
}

/****************************************************************************/
#if OVERLOAD_NEW
template <class T, class D>
void* PointerCopyTracker<T,D>::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if HAS_ARRAY_NEW
template <class T, class D>
void* PointerCopyTracker<T,D>::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
template <class T, class D>
void PointerCopyTracker<T,D>::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif

/****************************************************************************/
// Friend functions for SimpleArray class objects
/****************************************************************************/
template <class T>    
Boolean operator == (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator != (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (!Obj1_.IsEqual(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator > (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (Obj1_.IsGreater(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator < (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (Obj1_.IsLesser(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator >= (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_) || Obj1_.IsGreater(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator <= (const SimpleArray<T>& Obj1_, const SimpleArray<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_) || Obj1_.IsLesser(Obj2_));
}

/****************************************************************************/
template <class T>    
SimpleArray<T> Apply(const SimpleArray<T>& ia, T(*func)(T))
{
  size_t x;
  SimpleArray<T> Result_(ia);

  if (Result_._Buffer)
    for (x = 0; x < ia._Size; x++)
      Result_._Buffer[x] = (*func)(Result_._Buffer[x]);

  return Result_;
}

/****************************************************************************/
template <class T>
SimpleArray<Boolean> SeriesArrayCompare(const SimpleArray<T>& ia1, const SimpleArray<T>& ia2)
{
  if (SimpleArray<T>::_CompFunc && (ia1._Size == ia2._Size) && ia1.Base() && ia2.Base())
  {
    SimpleArray<Boolean> Result_(ia1._Size);
    size_t x;

    if (Result_._Buffer)
      for (x = 0; x < SimpleArray<T>::_Size; x++)
        Result_[x] = (*SimpleArray<T>::_CompFunc)(SimpleArray<T>::_Buffer[x], ia2[x]);

    return Result_;
  }

  SimpleArray<Boolean> Temp_;
  Temp_.SetError();
  return Temp_;
}

/****************************************************************************/
// SimpleArray Class Definition
/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray()
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif  
}

/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray(size_t n):
SimpleBaseArray<T,T>(n)
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray(const T* a, size_t n):
SimpleBaseArray<T,T>(a,n)
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif  
}

/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray(const SimpleArray<T>& Arr_, size_t start_, size_t end_):
SimpleBaseArray<T,T>(Arr_, start_, end_)
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray(const SimpleArray<T>& Arr_):
SimpleBaseArray<T,T>(Arr_)
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif
}
    
/****************************************************************************/
template <class T>
SimpleArray<T>::SimpleArray(const SimpleArray<T> & a1, const SimpleArray<T> & a2):
SimpleBaseArray<T,T>(a1,a2)
{
  if (!m_StaticCreate)
  {
    if (!SimpleArray<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : created" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleArray<T>::~SimpleArray()
{
  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleArray Object "
         <<ObjectID() <<" : destroyed" <<endl;
  #endif
  
  if (!m_StaticDestroy && m_ObjectCnt > 1)
  {
    --m_ObjectCnt;

    if (m_AutoRelease && m_ObjectCnt == 1)
    {
      m_StaticDestroy = true;
      m_AutoRelease = false;
      Release();
    }
  }
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::Init()
{  
  if (!SimpleArray<T>::_StaticClassPtr)
  {
    SimpleArray<T>::_StaticClassPtr = new SimpleArray<T>();
    IsBuiltInTypeData();
  }
}

/****************************************************************************/
template <class T>
SimpleArray<T>* SimpleArray<T>::Instance()
{
  if (!SimpleArray<T>::_StaticClassPtr)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;
  }

  return SimpleArray<T>::_StaticClassPtr;
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && SimpleArray<T>::_StaticClassPtr)
  {
    m_StaticDestroy = true;
    delete SimpleArray<T>::_StaticClassPtr;
    SimpleArray<T>::_StaticClassPtr = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::SetComparisonFunction(int(*CompFunc_)(const T&, const T&))
{
  SimpleArray<T>::_CompFunc = CompFunc_;
}

/****************************************************************************/
template <class T>
bool SimpleArray<T>::IsBuiltInTypeData()
{
  static T obj;
  _StaticIsBuiltIn = IsBuiltInTypeImpl(obj);
  return _StaticIsBuiltIn;
}

/****************************************************************************/
template <class T>
bool SimpleArray<T>::IsClassType(int Type_) const
{
  return (Type_ == VectorInfo::ARRAY);
}

/****************************************************************************/
template <class T>
bool SimpleArray<T>::IsMultiDimType() const
{
  return false;
}

/****************************************************************************/
template <class T>
Boolean SimpleArray<T>::IsCommonClass(int IDvalue_) const
{
  return (IDvalue_ == ClassID());
}

/****************************************************************************/
template <class T>
int SimpleArray<T>::ClassID() const
{
  return TypeInfo::SIMPLEARRAY_TYPE;
}

/****************************************************************************/
template <class T>
const char* SimpleArray<T>::ClassName() const
{
  return NameOf(*this);
}

/****************************************************************************/
template <class T>
size_t SimpleArray<T>::ObjectID() const
{
  return _ObjectID;
}

/****************************************************************************/
template <class T>
SimpleArray<T>::operator const T* () const
{
  return _Buffer;
}

/****************************************************************************/
template <class T>
size_t SimpleArray<T>::RunLength()
{
  return _Size;
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::GrowArray(size_t Incr_)
{
  SimpleBaseArray<T,T>::GrowArray(Incr_);
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::FillFrom(int i, T v)
{
  SimpleBaseArray<T,T>::FillFrom(i, v);
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::FillFrom(const Index& i, T v)
{
  SimpleBaseArray<T,T>::FillFrom(i, v);
}

/****************************************************************************/
template <class T>
void SimpleArray<T>::Fill(T i)
{
  SimpleBaseArray<T,T>::Fill(i);
}

/****************************************************************************/
template <class T>
SimpleArray<T>& SimpleArray<T>::operator = (const SimpleArray<T>& Arr_)
{
  if (this != &Arr_)
    SimpleBaseArray<T,T>::operator = (Arr_);

  return *this;
}

/****************************************************************************/
template <class T>
T& SimpleArray<T>::operator [] (const Index & i)
{
  static T Dummy_;

  int z = 0;
  int v = int(i);
  if (z <= v && v < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>
T& SimpleArray<T>::operator [] (int i)
{
  static T Dummy_;

  int z = 0;
  if (z <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>    
const T& SimpleArray<T>::operator [] (const Index & i) const
{
  static T Dummy_;

  int z = 0;
  int v = int(i);
  if (z <= v && v < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>    
const T& SimpleArray<T>::operator [] (int i) const
{
  static T Dummy_;

  int z = 0;
  if (z <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;  
}

/****************************************************************************/
template <class T>
const T SimpleArray<T>::Read(const Index & i) const
{
  static T Dummy_;
  int Num_ = size_t(i);

  if (0 <= Num_ && Num_ < _Size)
    return _Buffer[Num_];

  return Dummy_;
}

/****************************************************************************/
template <class T>    
const T SimpleArray<T>::Read(int i) const
{
  static T Dummy_;

  if (0 <= i && i < _Size)
    return _Buffer[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>
Boolean SimpleArray<T>::IsEqual(const SimpleArray<T>& ia) const
{
  if (SimpleArray<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if ((*SimpleArray<T>::_CompFunc)(_Buffer[x], ia[x]) != 0)
        return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
Boolean SimpleArray<T>::IsLesser(const SimpleArray<T>& ia) const
{
  if (SimpleArray<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if ((*SimpleArray<T>::_CompFunc)(_Buffer[x], ia[x]) >= 0)
        return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
Boolean SimpleArray<T>::IsGreater(const SimpleArray<T>& ia) const
{
  if (SimpleArray<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if ((*SimpleArray<T>::_CompFunc)(_Buffer[x], ia[x]) <= 0)
        return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
SimpleArray<Boolean> SimpleArray<T>::SeriesArrayCompare(const SimpleArray<T>& ia)
{
  if (SimpleArray<T>::_CompFunc && (_Size == ia._Size) && _Buffer && ia.Base())
  {
    SimpleArray<Boolean> Result_(_Size);
    size_t x;
    
    for (x = 0; x < _Size; x++)
      Result_[x] = (*SimpleArray<T>::_CompFunc)(_Buffer[x], ia[x]);

    return Result_;
  }

  SimpleArray<Boolean> Temp_;
  Temp_.SetError();
  return Temp_;
}

/****************************************************************************/
template <class T>    
SimpleArray<T>& SimpleArray<T>::Apply(T(*func)(T))
{
  size_t x;
  for (x = 0; x < _Size; x++)
    _Buffer[x] = (*func)(_Buffer[x]);

  return *this;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleArray<T>& RootObject(SimpleArray<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
const SimpleArray<T>& RootConstObject(const SimpleArray<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
int _WhatIs(const SimpleArray<T>& Obj_)
{
  return TypeInfo::SIMPLEARRAY_TYPE;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleArray)
CLONEFNCS_TEMPLATE_DEFN(SimpleArray)

/****************************************************************************/
// Friend functions of SimpleVector class objects
/****************************************************************************/
template <class T>
Boolean operator == (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator != (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (!Obj1_.IsEqual(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator > (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (Obj1_.IsGreater(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator < (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (Obj1_.IsLesser(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator >= (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_) || Obj1_.IsGreater(Obj2_));
}

/****************************************************************************/
template <class T>    
Boolean operator <= (const SimpleVector<T>& Obj1_, const SimpleVector<T>& Obj2_)
{
  return (Obj1_.IsEqual(Obj2_) || Obj1_.IsLesser(Obj2_));
}

/****************************************************************************/
template <class T>    
SimpleVector<T> Apply(const SimpleVector<T>& ia, T(*func)(T))
{
  size_t x;
  SimpleVector<T> Result_(ia);

  if (Result_._Buffer)
    for (x = 0; x < ia._Size; x++)
      if (Result_._Buffer[x])
        *Result_._Buffer[x] = (*func)(*Result_._Buffer[x]);

  return Result_;
}

/****************************************************************************/
template <class T>
SimpleVector<Boolean> SeriesArrayCompare(const SimpleVector<T>& ia1, const SimpleVector<T>& ia2)
{
  if (SimpleVector<T>::_CompFunc && (ia1._Size == ia2._Size) && ia1.Base() && ia2.Base())
  {
    SimpleVector<Boolean> Result_(ia1._Size);
    size_t x;

    if (Result_._Buffer)
      for (x = 0; x < SimpleVector<T>::_Size; x++)
        if (Result_._Buffer[x] && ia2[x])
          *Result_[x] = (*SimpleVector<T>::_CompFunc)(*SimpleVector<T>::_Buffer[x], *ia2[x]);

    return Result_;
  }

  SimpleVector<Boolean> Temp_;
  Temp_.SetError();
  return Temp_;
}

/****************************************************************************/
// SimpleVector class definition
/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector():
SimpleBaseArray<T*,T>(DEFAULT_SIZE),
_Length(0),
_Index(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();
  
  SetMaster(NULL, true);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created master" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector(size_t n):
SimpleBaseArray<T*,T>(n),
_Length(0),
_Index(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetMaster(NULL, true);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created master" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector(const T** a, size_t n):
SimpleBaseArray<T*,T>(a,n),
_Length(0),
_Index(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetMaster(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector(const SimpleVector<T>& Arr_, size_t start_, size_t end_):
SimpleBaseArray<T*,T>(Arr_, start_, end_),
_Length(Arr_._Length),
_Index(Arr_._Index),
_CopyTracker(NULL),
_Unlinked(Arr_._Unlinked),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetMaster(this, false);
  AppendConstCopyRefs(&Arr_, true);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector(const SimpleVector<T>& Arr_):
SimpleBaseArray<T*,T>(Arr_),
_Length(Arr_._Length),
_Index(Arr_._Index),
_CopyTracker(NULL),
_Unlinked(Arr_._Unlinked),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetConstMaster(&Arr_, false);
  AppendCopyRefs(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::SimpleVector(const SimpleVector<T> & a1,
                              const SimpleVector<T> & a2):
SimpleBaseArray<T*,T>(a1,a2),
_Length(a1_._Length + a2._Length),
_Index(0),
_CopyTracker(NULL),
_Unlinked(a1._Unlinked || a2._Unlinked),
_CpTrkInit(false)
{
  if (!m_StaticCreate)
  {
    if (!SimpleVector<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetConstMaster(&a1, false);
  AppendConstCopyRefs(&a2, true);
  AppendCopyRefs(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleVector<T>::~SimpleVector()
{
  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleVector Object "
         <<ObjectID() <<" : destroyed ";
    if (_CopyTracker)
      if (_CopyTracker->OwnsData())
        cout <<"master" <<endl;
      else
        cout <<"shallow" <<endl;
  #endif
  
  if (CopyTrackPtr())
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  if (!m_StaticDestroy && m_ObjectCnt > 1)
  {
    --m_ObjectCnt;

    if (m_AutoRelease && m_ObjectCnt == 1 && _StaticTrIndex)
    {
      m_StaticDestroy = true;
      m_AutoRelease = false;
      Release();
    }
  }
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::Init()
{
  if (!SimpleVector<T>::_StaticClassPtr)
  {
    SimpleVector<T>::_StaticClassPtr = new SimpleVector<T>();
    IsBuiltInTypeData();

    _StaticTrIndex = new_int(4);
    _StaticTrIndex[0] = VectorInfo::MTOSTRANS;
    _StaticTrIndex[1] = VectorInfo::STOMTRANS;
    _StaticTrIndex[2] = VectorInfo::STARTSC;
    _StaticTrIndex[3] = VectorInfo::STARTMO;    
  }
}

/****************************************************************************/
template <class T>
int* SimpleVector<T>::Instance()
{
  if (!SimpleVector<T>::_StaticClassPtr)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;

    SimpleArray<T>::Instance();
  }

  return _StaticTrIndex;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && SimpleVector<T>::_StaticClassPtr)
  {
    m_StaticDestroy = true;
    ::RawDeleteArray(_StaticTrIndex);
    _StaticTrIndex = NULL;
    delete SimpleVector<T>::_StaticClassPtr;
    SimpleVector<T>::_StaticClassPtr = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::IsBuiltInTypeData()
{
  static T obj;
  _StaticIsBuiltIn = IsBuiltInTypeImpl(obj);
  return _StaticIsBuiltIn;
}

/****************************************************************************/
template <class T>
int SimpleVector<T>::TrIndex(int i)
{
  if (!_StaticTrIndex)
    Instance();

  return _StaticTrIndex[i];
};

/****************************************************************************/
template <class T>
PointerCopyTracker<SimpleVector<T>::TTYPE,SimpleVector<T>::DTYPE>* SimpleVector<T>::CopyTrackPtr()
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
const PointerCopyTracker<SimpleVector<T>::TTYPE,SimpleVector<T>::DTYPE>* SimpleVector<T>::CopyTrackPtr() const
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetDataRefs(T** Data_, size_t Index_)
{}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetDataReferences(SimpleMatrix<T>* Ptr_, size_t i)
{
  Ptr_->_VectorLengths[i] = &_Length;
  Ptr_->_VectorIndexes[i] = &_Index;
  Ptr_->_VectorSizes[i] = &_Size;
}

/****************************************************************************/
template <class T>
SimpleVector<T>::DTYPE** SimpleVector<T>::AssignDataArray(SimpleVector<T>::DTYPE** Vect_, size_t sz)
{
  if (Vect_ != _Buffer)
  {
    if (_Buffer)
      ::DeleteArray(_Buffer);
    
    _Buffer = Vect_;
    _Size = sz;
  }

  return _Buffer;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::RetCallToShallow(bool Unlinked_, bool InitCall_)
{
  if (CopyTrackPtr())
  {
    bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                    _CopyTracker->IsOwnershipAttrib(true, true, false);

    if (Shallow_ || InitCall_)
      _Unlinked = Unlinked_;

    _CopyTracker->RetCallToShallow(Unlinked_, InitCall_);
  }
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::ReplaceCopyTracker(PointerCopyTracker<SimpleVector<T>::TTYPE,SimpleVector<T>::DTYPE>* Ptr_,
                                         SimpleVector<T>::TTYPE* Master_)
{
  if (Ptr_)
  {
    PointerCopyTracker<TTYPE,DTYPE>* NewPtr_ =
      new PointerCopyTracker<TTYPE,DTYPE>(*Ptr_);
    _CpTrkInit = NewPtr_ != NULL;
    if (_CpTrkInit)
      NewPtr_->CheckUnlinked();

    if (_CopyTracker)
      _CopyTracker->SetSelfErase(true);

    if (NewPtr_)
      NewPtr_->SetSelfErase(true);
    
    if (_CopyTracker && _CopyTracker->Swap(this))
      _CopyTracker->Pop();

    _CopyTracker = NewPtr_;
    SetMaster(Master_, false);
  }
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetMaster(SimpleVector<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster(Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetConstMaster(const SimpleVector<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster((SimpleVector<T>::TTYPE*)Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::AppendCopyRefs(SimpleVector<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs(Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::AppendConstCopyRefs(const SimpleVector<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs((SimpleVector<T>::TTYPE*)Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::IsOwnershipAttrib(bool OwnsData_, bool SelfErase_, bool Shallow_) const
{
  if (CopyTrackPtr())
    _CopyTracker->IsOwnershipAttrib(OwnsData_, SelfErase_, Shallow_);
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::HasThis(SimpleVector<T>::TTYPE* ToFind_, SimpleVector<T>::NTYPE** Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->HasThis(ToFind_, Node_):false);
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::HasThis(SimpleVector<T>::TTYPE* ToFind_) const
{
  return (CopyTrackPtr() ? _CopyTracker->HasThis(ToFind_):false);
}

/****************************************************************************/
template <class T>
SimpleVector<T>::TTYPE* SimpleVector<T>::Push(SimpleVector<T>::TTYPE* Val_)
{
  return (CopyTrackPtr() ? _CopyTracker->Push(Val_):NULL);
}

/****************************************************************************/
template <class T>
SimpleVector<T>::TTYPE* SimpleVector<T>::Swap(SimpleVector<T>::TTYPE* Head_, SimpleVector<T>::NTYPE* Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->Swap(Head_, Node_):NULL);
}

/****************************************************************************/
template <class T>
SimpleVector<T>::TTYPE* SimpleVector<T>::Pop()
{
  return (CopyTrackPtr() ? _CopyTracker->Pop():NULL);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetAllocationMethod(MemAllocMethod Method_)
{
  _AllocMethod = Method_;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetComparisonFunction(int(*CompFunc_)(const T&, const T&))
{
  SimpleVector<T>::_CompFunc = CompFunc_;
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make()
{
  return (new SimpleVector());
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make(size_t n)
{
  return (new SimpleVector(n));
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make(const T** a, size_t n)
{
  return (new SimpleVector(a, n));
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make(const SimpleVector<T>& Arr_, size_t start_, size_t end_)
{
  return (new SimpleVector(Arr_, start_, end_));
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make(const SimpleVector<T>& Arr_)
{
  return (new SimpleVector(Arr_));
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleVector<T>::Make(const SimpleVector<T> & a1, const SimpleVector<T> & a2)
{
  return (new SimpleVector(a1, a2));
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetDataErase(bool f)
{
  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(f);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetAutoErase(bool f, SimpleVector<T>* This_)
{
  _AutoErase = f;
  
  if (This_)
    This_->SetDataErase(_AutoErase);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetAutoErase(bool f)
{
  _AutoErase = f;

  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(_AutoErase);
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::IsClassType(int Type_) const
{
  return (Type_ == VectorInfo::VECTOR);
}

/****************************************************************************/
template <class T>
bool SimpleVector<T>::IsMultiDimType() const
{
  return false;
}

/****************************************************************************/
template <class T>
Boolean SimpleVector<T>::IsCommonClass(int IDvalue_) const
{
  return (IDvalue_ == ClassID());
}

/****************************************************************************/
template <class T>
int SimpleVector<T>::ClassID() const
{
  return TypeInfo::SIMPLEVECTOR_TYPE;
}

/****************************************************************************/
template <class T>
const char* SimpleVector<T>::ClassName() const
{
  return NameOf(*this);
}

/****************************************************************************/
template <class T>
size_t SimpleVector<T>::ObjectID() const
{
  return _ObjectID;
}

/****************************************************************************/
template <class T>
const T* SimpleVector<T>::IndexedElement() const
{
  return (_Buffer ? _Buffer[_Index]:NULL);
}

/****************************************************************************/
template <class T>
T* SimpleVector<T>::IndexedElement()
{
  return (_Buffer ? _Buffer[_Index]:NULL);
}

/****************************************************************************/
template <class T>
T* SimpleVector<T>::AllocData(const T* ptr)
{
  return
  (
    ptr ? ((_AllocMethod == MEMMATRIX) ? (T*)::memmove(RawAllocateWith(MEMMATRIX, sizeof(T)), ptr, sizeof(T)):
                                         (new T(*ptr))):
          ((T*)NULL)
  );
}

/****************************************************************************/
template <class T>
SimpleVector<T>& SimpleVector<T>::operator = (const SimpleVector<T>& Vect_)
{
  if (this != &Vect_)
  {
    size_t z = 0;
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_ == VectorInfo::STARTSC ||
        TransCode_ == VectorInfo::MTOSTRANS)
      return ShallowCopy(Vect_);
    else if (TransCode_ == VectorInfo::STARTMO ||
             TransCode_ == VectorInfo::STOMTRANS)
      return DeepCopy(Vect_);
  }

  return *this;  
}

/****************************************************************************/
template <class T>
SimpleVector<T>& SimpleVector<T>::DeepCopy(const SimpleVector<T>& Vect_)
{
  if (this != &Vect_)
  {
    size_t x;
    T* eptr = NULL;
  
    // Destroy existing objects    
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);
  
      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
       _CopyTracker = NULL;
      }
    }

    if (UseMemMgr())
      ::DeleteArray(_Buffer);
    else
      delete _Buffer;

    _Buffer = NULL;

    // Recreate objects with new assigned vector size
    _Error = FALSE;
    _Size = Vect_.GetCount();
    _Buffer = UseMemMgr() ? (T**)RawAllocateWith(MEMMATRIX, sizeof(T*) * _Size):
                            (new T*[_Size]);
    
    ::memset(_Buffer, 0, sizeof(T*) * _Size);

    // Deep copy vector elements from assigned vector
    for (x = 0; x < _Size; x++)
    {
      eptr = Vect_[x];
      _Buffer[x] = AllocData(eptr);
    }

    _Length = Vect_._Length;
    _Index = Vect_._Index;

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(NULL, true);
  }

  return *this;  
}

/****************************************************************************/
template <class T>
SimpleVector<T>& SimpleVector<T>::ShallowCopy(const SimpleVector<T>& Vect_)
{
  if (this != &Vect_)
  {
    size_t x;
    T* eptr = NULL;
  
    // Destroy existing objects
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);
  
      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
    }

    if (UseMemMgr())
      ::DeleteArray(_Buffer);
    else
      delete _Buffer;

    _Buffer = NULL;

    // Recreate objects with new assigned vector size
    _Error = FALSE;
    _Size = Vect_.GetCount();
    _Buffer = UseMemMgr() ? (T**)RawAllocateWith(MEMMATRIX, sizeof(T*) * _Size):
                            (new T*[_Size]);

    ::memset(_Buffer, 0, sizeof(T*) * _Size);

    // Shallow copy vector elements from assigned vector
    SimpleBaseArray<T*,T>::operator = (Vect_);
    _Length = Vect_._Length;
    _Index = Vect_._Index;

    SimpleVector<T>* vptr = ((SimpleVector<T>*)&Vect_);
    _Unlinked = Vect_._Unlinked;
    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(vptr, false);
    AppendCopyRefs(this, false);
  }

  return *this;
}

/****************************************************************************/
template <class T>
PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
SimpleVector<T>::operator [] (const Index& i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  size_t v = size_t(i);
  if (z <= v && v < _Size && CopyTrackPtr())
  {
    _Index = v;    
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));

    if (TransCode_)
      return PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
                  (_CopyTracker, _Index, _Size, TransCode_);
  }

  return PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
              (NULL, 0, _Size, 0, _Buffer);
}

/****************************************************************************/
template <class T>
PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
SimpleVector<T>::operator [] (int i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  if (z <= i && i < _Size && CopyTrackPtr())
  {
    _Index = i;
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_)
      return PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
                  (_CopyTracker, _Index, _Size, TransCode_);
  }

  return PointerReturner<SimpleVector<T>::DTYPE,SimpleVector<T>::CTYPE>
              (NULL, 0, _Size, 0, _Buffer);
}

/****************************************************************************/
template <class T>
const T* SimpleVector<T>::Read(const Index & i) const
{
  _Index = size_t(i);
  return SimpleBaseArray<T*,T>::Read(i);
}

/****************************************************************************/
template <class T>
const T* SimpleVector<T>::Read(int i) const
{
  _Index = size_t(i);
  return SimpleBaseArray<T*,T>::Read(i);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::GrowVector(size_t Incr_)
{
  size_t oldsz = GetCount();
  GrowArray(Incr_);
  FillFrom(oldsz, (T*)0);
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::FindVectorRunLength()
{
  size_t x = 0;
  if (_Buffer)
  for (x = 0; x < _Size && _Buffer[x]; x++);
  _Length = x;
}

/****************************************************************************/
template <class T>
size_t SimpleVector<T>::RunLength()
{
  FindVectorRunLength();
  return _Length;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::SetIndex(size_t Index_)
{
  _Index = Index_;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::EraseVector(MemAllocMethod Method_)
{
  int x;
  if (!CopyTrackPtr())
    return;

  bool OwnsData_ = _CopyTracker->OwnsData();
  bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                  _CopyTracker->IsOwnershipAttrib(true, true, false);

  // Destroy existing objects
  if (_CopyTracker)
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  // If NOT a shallow copied object
  if (!Shallow_)
  {
    if (Method_ == MEMMATRIX)
    {
      if (_Buffer && OwnsData_)
        for (x = 0; x < _Size; x++)
        {
          #if SIMPLEARRAY_DEBUG1
            #if SIMPLEARRAY_DEBUG1a
              cout <<"Parent: " <<ClassID();
              cout <<":" <<ObjectID()
                   <<" : EraseVector(";
            #else
              cout <<"Parent: " <<ObjectID()
                   <<" : EraseVector(";
            #endif

            if (_Buffer[x])
              cout <<*_Buffer[x] <<")" <<endl;
            else
              cout <<"null)" <<endl;
          #endif

          if (ClassID() && _Buffer[x])
          {
            if (MemMatrix::Matrix().HasThis(_Buffer[x]))
              ::Delete(_Buffer[x]);
            else
              delete _Buffer[x];
        
            _Buffer[x] = NULL;
          }
        }
    }
    else if (Method_ == STD_NEW)
    {
      if (_Buffer && OwnsData_)
        for (x = 0; x < _Size; x++)
        {
          #if SIMPLEARRAY_DEBUG1
            #if SIMPLEARRAY_DEBUG1a
              cout <<"Parent: " <<ClassID();
              cout <<":" <<ObjectID()
                   <<" : EraseVector(";
            #else
              cout <<"Parent: " <<ObjectID()
                   <<" : EraseVector(";
            #endif

            if (_Buffer[x])
              cout <<*_Buffer[x] <<")" <<endl;
            else
              cout <<"null)" <<endl;
          #endif
          
          if (ClassID() && _Buffer[x])
          {
            delete _Buffer[x];
            _Buffer[x] = NULL;
          }
        }
    }

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(NULL, true);
  }  
  else
  {
    if (_Buffer && OwnsData_)
      for (x = 0; x < _Size; x++)
        _Buffer[x] = NULL;

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(this, false);
  }
}

/****************************************************************************/
template <class T>
Boolean SimpleVector<T>::IsEqual(const SimpleVector<T>& ia) const
{
  if (SimpleVector<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if (_Buffer[x] && ia[x])
        if ((*SimpleVector<T>::_CompFunc)(*_Buffer[x], *ia[x]) != 0)
          return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
Boolean SimpleVector<T>::IsLesser(const SimpleVector<T>& ia) const
{
  if (SimpleVector<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if (_Buffer[x] && ia[x])
        if ((*SimpleVector<T>::_CompFunc)(*_Buffer[x], *ia[x]) >= 0)
          return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
Boolean SimpleVector<T>::IsGreater(const SimpleVector<T>& ia) const
{
  if (SimpleVector<T>::_CompFunc && _Buffer && ia.Base())
  {
    size_t x;
    for (x = 0; x < _Size; x++)
      if (_Buffer[x] && ia[x])
        if ((*SimpleVector<T>::_CompFunc)(*_Buffer[x], *ia[x]) <= 0)
          return FALSE;

    return TRUE;
  }

  return FALSE;
}

/****************************************************************************/
template <class T>
SimpleArray<Boolean> SimpleVector<T>::SeriesArrayCompare(const SimpleVector<T>& ia)
{
  if (SimpleVector<T>::_CompFunc && (_Size == ia._Size) && _Buffer && ia.Base())
  {
    SimpleArray<Boolean> Result_(_Size);
    size_t x;
    
    for (x = 0; x < _Size; x++)
      if (_Buffer[x] && ia[x])
        Result_[x] = (*SimpleVector<T>::_CompFunc)(*_Buffer[x], *ia[x]);

    return Result_;
  }

  SimpleArray<Boolean> Temp_;
  Temp_.SetError();
  return Temp_;
}

/****************************************************************************/
template <class T>
SimpleVector<T>& SimpleVector<T>::Apply(T(*func)(T))
{
  size_t x;
  if (_Buffer)
    for (x = 0; x < _Size; x++)
      if (_Buffer[x])
        *_Buffer[x] = (*func)(*_Buffer[x]);

  return *this;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::Fill(T* v)
{
  size_t x;
  for (x = 0; x < _Size; x++)
    (*this)[x] = v;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::FillFrom(int i, T* v)
{
  size_t x = size_t(i);
  for (;x < _Size; x++)
    (*this)[x] = v;
}

/****************************************************************************/
template <class T>
void SimpleVector<T>::FillFrom(const Index& i, T* v)
{
  size_t x = size_t(i);
  for (;x < _Size; x++)
    (*this)[x] = v;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleVector<T>& RootObject(SimpleVector<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
const SimpleVector<T>& RootConstObject(const SimpleVector<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
int _WhatIs(const SimpleVector<T>& Obj_)
{
  return TypeInfo::SIMPLEVECTOR_TYPE;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleVector)
CLONEFNCS_TEMPLATE_DEFN(SimpleVector)

/****************************************************************************/
// SimpleMatrix Class Definition
/****************************************************************************/
template <class T>
SimpleMatrix<T>::SimpleMatrix(size_t msz, size_t vsz):
_Error(FALSE),
_Matrix((SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * msz)),
_VectorSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_VectorLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_VectorIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),

_MatrixSize(msz),
_MatrixLength(0),
_MatrixIndex(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * msz);
  ::memset(_VectorSizes, 0, sizeof(size_t*) * msz);
  ::memset(_VectorLengths, 0, sizeof(size_t*) * msz);
  ::memset(_VectorIndexes, 0, sizeof(size_t*) * msz);
  size_t x;
  bool OwnsData_ = vsz > 0;

  if (!m_StaticCreate)
  {
    if (!SimpleMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (vsz)
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix[x] = new SimpleVector<T>(vsz);
      _Matrix[x]->SetDataReferences(this, x);
    }
  }  
  else
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix[x] = NULL;
      // _Matrix[x] = new SimpleVector<T>;
      // _Matrix[x]->SetDataReferences(this, x);
    }    
  }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
    SetMaster(NULL, true);
  else
    SetMaster(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::SimpleMatrix(size_t msz, const T** a, size_t vsz):
_Error(FALSE),
_Matrix((SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * msz)),
_VectorSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_VectorLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_VectorIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),

_MatrixSize(msz),
_MatrixLength(0),
_MatrixIndex(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * msz);
  ::memset(_VectorSizes, 0, sizeof(size_t*) * msz);
  ::memset(_VectorLengths, 0, sizeof(size_t*) * msz);
  ::memset(_VectorIndexes, 0, sizeof(size_t*) * msz);
  size_t x;
  bool OwnsData_ = vsz > 0;

  if (!m_StaticCreate)
  {
    if (!SimpleMatrix<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (vsz)
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix[x] = new SimpleVector<T>(a, vsz);
      _Matrix[x]->SetDataReferences(this, x);
    }
  }
  else
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix[x] = NULL;
      // _Matrix[x] = new SimpleVector<T>;
      // _Matrix[x]->SetDataReferences(this, x);
    }
  }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
    SetMaster(NULL, true);
  else
    SetMaster(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::SimpleMatrix(const SimpleMatrix<T>& Matr_, size_t start_, size_t end_):
_Error(FALSE),
_Matrix((SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * Matr_._MatrixSize)),
_VectorSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),
_VectorLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),
_VectorIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),

_MatrixSize(Matr_._MatrixSize),
_MatrixLength(Matr_._MatrixLength),
_MatrixIndex(Matr_._MatrixIndex),
_CopyTracker(NULL),
_Unlinked(Matr_._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * _MatrixSize);
  ::memset(_VectorSizes, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorLengths, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorIndexes, 0, sizeof(size_t*) * _MatrixSize);
  size_t x;
  size_t max = _MatrixSize;
  bool OwnsData_ = false;

  if (!m_StaticCreate)
  {
    if (!SimpleMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (Matr_._Matrix)
    for (x = 0; x < max; x++)
      if (Matr_._Matrix[x])
      {
        OwnsData_ = true;
        _Matrix[x] = new SimpleVector<T>(*Matr_._Matrix[x], start_, end_);
        _Matrix[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix[x] = NULL;
        // _Matrix[x] = new SimpleVector<T>;
        // _Matrix[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
  {
    SetMaster(NULL, true);
    _Unlinked = false;
  }
  else
  {
    SetMaster(this, false);
    AppendConstCopyRefs(&Matr_, true);
  }

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::SimpleMatrix(const SimpleMatrix<T>& Matr_):
_Error(FALSE),
_Matrix((SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * Matr_._MatrixSize)),
_VectorSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),
_VectorLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),
_VectorIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._MatrixSize)),

_MatrixSize(Matr_._MatrixSize),
_MatrixLength(Matr_._MatrixLength),
_MatrixIndex(Matr_._MatrixIndex),
_CopyTracker(NULL),
_Unlinked(Matr_._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * _MatrixSize);
  ::memset(_VectorSizes, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorLengths, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorIndexes, 0, sizeof(size_t*) * _MatrixSize);
  size_t x;
  size_t max = _MatrixSize;
  bool OwnsDat_ = false;

  if (!m_StaticCreate)
  {
    if (!SimpleMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (Matr_._Matrix)
    for (x = 0; x < max; x++)    
      if (Matr_._Matrix[x])
      {
        _Matrix[x] = Matr_._Matrix[x];
        _Matrix[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix[x] = NULL;
        // _Matrix[x] = new SimpleVector<T>;
        // _Matrix[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetMaster(&Matr_, false);
  AppendCopyRefs(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif  
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::SimpleMatrix(const SimpleMatrix<T> & a1,
                              const SimpleMatrix<T> & a2):
_Error(FALSE),
_Matrix((SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * (a1._MatrixSize + a2._MatrixSize))),
_VectorSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._MatrixSize + a2._MatrixSize))),
_VectorLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._MatrixSize + a2._MatrixSize))),
_VectorIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._MatrixSize + a2._MatrixSize))),

_MatrixSize((a1._MatrixSize + a2._MatrixSize)),
_MatrixLength((a1._MatrixLength + a2._MatrixLength)),
_MatrixIndex(0),
_CopyTracker(NULL),
_Unlinked(a1._Unlinked || a2._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * _MatrixSize);
  ::memset(_VectorSizes, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorLengths, 0, sizeof(size_t*) * _MatrixSize);
  ::memset(_VectorIndexes, 0, sizeof(size_t*) * _MatrixSize);
  size_t x;
  size_t max = _MatrixSize;
  bool OwnsData_ = false;

  if (!m_StaticCreate)
  {
    if (!SimpleMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (a1._Matrix && a2._Matrix)
    for (x = 0; x < max; x++)
      if (a1._Matrix[x] && a2._Matrix[x])
      {
        OwnsData_ = true;
        _Matrix[x] = new SimpleVector<T>(*a1._Matrix[x], *a2._Matrix[x]);
        _Matrix[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix[x] = NULL;
        // _Matrix[x] = new SimpleVector<T>;
        // _Matrix[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
  {
    SetMaster(NULL, true);
    _Unlinked = false;
  }
  else
  {
    SetMaster(&a1, false);
    AppendConstCopyRefs(&a2, true);
    AppendCopyRefs(this, false);
  }

  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::~SimpleMatrix()
{
  #if SIMPLEARRAY_DEBUG1
    cout <<"SimpleMatrix Object "
         <<ObjectID() <<" : destroyed ";
    if (_CopyTracker)
      if (_CopyTracker->OwnsData())
        cout <<"master" <<endl;
      else
        cout <<"shallow" <<endl;
  #endif

  // Deleting reference copies of locally stored SimpleVector objects
  if (CopyTrackPtr())
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  ::RawDeleteArray(_VectorSizes);
  ::RawDeleteArray(_VectorLengths);
  ::RawDeleteArray(_VectorIndexes);
  _VectorSizes =
  _VectorLengths =
  _VectorIndexes = NULL;  

  // Analogous to deleting _Buffer in parent class of 1d SimpleVector class
  ::DeleteArray(_Matrix);
  _Matrix = NULL;

  if (!m_StaticDestroy && m_ObjectCnt > 1)
  {
    --m_ObjectCnt;

    if (m_AutoRelease && m_ObjectCnt == 1 && _StaticTrIndex)
    {
      m_StaticDestroy = true;
      m_AutoRelease = false;
      Release();
    }
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::Init()
{
  if (!SimpleMatrix<T>::_StaticClassPtr)
  {
    SimpleMatrix<T>::_StaticClassPtr = new SimpleMatrix<T>();
    IsBuiltInTypeData();

    _StaticTrIndex = new_int(4);
    _StaticTrIndex[0] = VectorInfo::MTOSTRANS;
    _StaticTrIndex[1] = VectorInfo::STOMTRANS;
    _StaticTrIndex[2] = VectorInfo::STARTSC;
    _StaticTrIndex[3] = VectorInfo::STARTMO;
  }
}

/****************************************************************************/
template <class T>
int* SimpleMatrix<T>::Instance()
{
  if (!SimpleMatrix<T>::_StaticClassPtr)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;

    SimpleVector<T>::Instance();
  }

  return _StaticTrIndex;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && SimpleMatrix<T>::_StaticClassPtr)
  {
    m_StaticDestroy = true;
    ::RawDeleteArray(_StaticTrIndex);
    _StaticTrIndex = NULL;
    delete SimpleMatrix<T>::_StaticClassPtr;
    SimpleMatrix<T>::_StaticClassPtr = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
template <class T>
bool SimpleMatrix<T>::IsBuiltInTypeData()
{
  _StaticIsBuiltIn = false;
  return _StaticIsBuiltIn;
}

/****************************************************************************/
template <class T>
int SimpleMatrix<T>::TrIndex(int i)
{
  if (!_StaticTrIndex)
    Instance();

  return _StaticTrIndex[i];
};

/****************************************************************************/
template <class T>
PointerCopyTracker<SimpleMatrix<T>::TTYPE,SimpleMatrix<T>::DTYPE>* SimpleMatrix<T>::CopyTrackPtr()
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
const PointerCopyTracker<SimpleMatrix<T>::TTYPE,SimpleMatrix<T>::DTYPE>* SimpleMatrix<T>::CopyTrackPtr() const
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetDataRefs(SimpleVector<T>** Data_, size_t Index_)
{
  if (_Matrix && CopyTrackPtr())
  {
    size_t z;
    int TransCode_ = 0;

    for (z = 0; !TransCode_ && z < VectorInfo::MAXTRANS; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));

    if (TransCode_ == VectorInfo::MTOSTRANS &&
        Data_ && Index_ < _MatrixSize && Data_[Index_])
      Data_[Index_]->SetDataReferences(this, _MatrixIndex);
    else if (TransCode_ == VectorInfo::STOMTRANS)
    {
      if (_Matrix[_MatrixIndex])
        _Matrix[_MatrixIndex]->SetDataReferences(this, _MatrixIndex);
      else if (Data_ && Index_ < _MatrixSize && Data_[Index_])
        Data_[Index_]->SetDataReferences(this, _MatrixIndex);
    }
    else if (TransCode_ == VectorInfo::STARTSC)
    {
      if (Data_ && Index_ < _MatrixSize && Data_[Index_])
        Data_[Index_]->SetDataReferences(this, _MatrixIndex);
      else if (_Matrix[_MatrixIndex])
        _Matrix[_MatrixIndex]->SetDataReferences(this, _MatrixIndex);
    }
    else if (TransCode_ == VectorInfo::STARTMO && _Matrix[_MatrixIndex])
      _Matrix[_MatrixIndex]->SetDataReferences(this, _MatrixIndex);
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetDataReferences(Simple3DMatrix<T>* Ptr_, size_t i)
{
  Ptr_->_MatrixLengths[i] = &_MatrixLength;
  Ptr_->_MatrixIndexes[i] = &_MatrixIndex;
  Ptr_->_MatrixSizes[i] = &_MatrixSize;
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::DTYPE** SimpleMatrix<T>::AssignDataArray(SimpleMatrix<T>::DTYPE** Vect_, size_t sz)
{
  if (Vect_ != _Matrix)
  {
    _Matrix = Vect_;
    _MatrixSize = sz;
  }
    
  return _Matrix;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::RetCallToShallow(bool Unlinked_, bool InitCall_)
{
  if (CopyTrackPtr())
  {
    bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                    _CopyTracker->IsOwnershipAttrib(true, true, false);

    if (Shallow_ || InitCall_)
      _Unlinked = Unlinked_;
  
    _CopyTracker->RetCallToShallow(Unlinked_, InitCall_);
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::ReplaceCopyTracker(PointerCopyTracker<SimpleMatrix<T>::TTYPE,SimpleMatrix<T>::DTYPE>* Ptr_,
                                         SimpleMatrix<T>::TTYPE* Master_)
{
  if (Ptr_)
  {
    PointerCopyTracker<TTYPE,DTYPE>* NewPtr_ =
      new PointerCopyTracker<TTYPE,DTYPE>(*Ptr_);
    _CpTrkInit = NewPtr_ != NULL;
    if (_CpTrkInit)
      NewPtr_->CheckUnlinked();

    if (_CopyTracker)
      _CopyTracker->SetSelfErase(true);

    if (NewPtr_)
      NewPtr_->SetSelfErase(true);

    if (_CopyTracker && _CopyTracker->Swap(this))
      _CopyTracker->Pop();    

    _CopyTracker = NewPtr_;
    SetMaster(Master_, false);
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetMaster(SimpleMatrix<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster(Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetConstMaster(const SimpleMatrix<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster((SimpleMatrix<T>::TTYPE*)Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::AppendCopyRefs(SimpleMatrix<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs(Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::AppendConstCopyRefs(const SimpleMatrix<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs((SimpleMatrix<T>::TTYPE*)Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
bool SimpleMatrix<T>::IsOwnershipAttrib(bool OwnsData_, bool SelfErase_, bool Shallow_) const
{
  if (CopyTrackPtr())
    _CopyTracker->IsOwnershipAttrib(OwnsData_, SelfErase_, Shallow_);
}

/****************************************************************************/
template <class T>
bool SimpleMatrix<T>::HasThis(SimpleMatrix<T>::TTYPE* ToFind_, SimpleMatrix<T>::NTYPE** Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->HasThis(ToFind_, Node_):false);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::TTYPE* SimpleMatrix<T>::Push(SimpleMatrix<T>::TTYPE* Val_)
{
  return (CopyTrackPtr() ? _CopyTracker->Push(Val_):NULL);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::TTYPE* SimpleMatrix<T>::Swap(SimpleMatrix<T>::TTYPE* Head_, SimpleMatrix<T>::NTYPE* Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->Swap(Head_, Node_):NULL);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>::TTYPE* SimpleMatrix<T>::Pop()
{
  return (CopyTrackPtr() ? _CopyTracker->Pop():NULL);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetAllocationMethod(MemAllocMethod Method_)
{
  _AllocMethod = Method_;
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make()
{
  return (new SimpleMatrix<T>);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make(size_t n)
{
  return (new SimpleMatrix<T>(n));
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make(const T** a, size_t n)
{
  return (new SimpleMatrix<T>(a, n));
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make(const SimpleMatrix<T>& Arr_, size_t start_, size_t end_)
{
  return (new SimpleMatrix<T>(Arr_, start_, end_));
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make(const SimpleMatrix<T>& Arr_)
{
  return (new SimpleMatrix<T>(Arr_));
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* SimpleMatrix<T>::Make(const SimpleMatrix<T> & a1, const SimpleMatrix<T> & a2)
{
  return (new SimpleMatrix<T>(a1, a2));
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetDataErase(bool f)
{
  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(f);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetAutoErase(bool f, SimpleMatrix<T>* This_)
{
  _AutoErase = f;

  if (This_)
    This_->SetDataErase(_AutoErase);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetAutoErase(bool f)
{
  _AutoErase = f;

  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(_AutoErase);
}

/****************************************************************************/
template <class T>
bool SimpleMatrix<T>::IsClassType(int Type_) const
{
  return (Type_ == VectorInfo::MATRIX);
}

/****************************************************************************/
template <class T>
bool SimpleMatrix<T>::IsMultiDimType() const
{
  return true;
}

/****************************************************************************/
template <class T>
Boolean SimpleMatrix<T>::IsCommonClass(int IDvalue_) const
{
  return (IDvalue_ == ClassID());
}

/****************************************************************************/
template <class T>
int SimpleMatrix<T>::ClassID() const
{
  return TypeInfo::SIMPLEMATRIX_TYPE;
}

/****************************************************************************/
template <class T>
const char* SimpleMatrix<T>::ClassName() const
{
  return NameOf(*this);
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::ObjectID() const
{
  return _ObjectID;
}

/****************************************************************************/
template <class T>
const SimpleVector<T>* SimpleMatrix<T>::IndexedElement() const
{
  return (_Matrix ? _Matrix[_MatrixIndex]:NULL);
}

/****************************************************************************/
template <class T>
SimpleVector<T>* SimpleMatrix<T>::IndexedElement()
{
  return (_Matrix ? _Matrix[_MatrixIndex]:NULL);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::operator = (const SimpleMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix && Matr_._Matrix)
  {
    size_t z = 0;
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_ == VectorInfo::STARTSC ||
        TransCode_ == VectorInfo::MTOSTRANS)
      return ShallowCopy(Matr_);
    else if (TransCode_ == VectorInfo::STARTMO ||
             TransCode_ == VectorInfo::STOMTRANS)
      return DeepCopy(Matr_);
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::DeepCopy(const SimpleMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix && Matr_._Matrix)
  {  
    size_t x;
    size_t vsz;
    size_t max;
    SimpleMatrix<T>* mptr = ((SimpleMatrix<T>*)&Matr_);
    SimpleVector<T>* vptr;

    // Destroy existing objects
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);
  
      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
    }

    ::RawDeleteArray(_VectorSizes);
    ::RawDeleteArray(_VectorLengths);
    ::RawDeleteArray(_VectorIndexes);
    _VectorSizes =
    _VectorLengths =
    _VectorIndexes = NULL;    

    ::DeleteArray(_Matrix);
    _Matrix = NULL;

    // Recreate objects with new assigned vector size
    max = Matr_._MatrixSize;
    _Matrix = (SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * max);
    _VectorSizes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _VectorLengths = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _VectorIndexes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);

    _MatrixSize = max;
    _MatrixLength = Matr_._MatrixLength;
    _MatrixIndex = Matr_._MatrixIndex;

    ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * max);
    ::memset(_VectorSizes, 0, sizeof(size_t*) * max);
    ::memset(_VectorLengths, 0, sizeof(size_t*) * max);
    ::memset(_VectorIndexes, 0, sizeof(size_t*) * max);
    bool OwnsData_ = false;

    if (Matr_._Matrix)
      for (x = 0; x < max; x++)
        if (Matr_._Matrix[x])
        {
          // Deep copy vector elements from assigned vector
          vsz = mptr->VectorSize(x);
          vptr = (*mptr)[x];
          
          if (vsz && vptr)
          {
            OwnsData_ = true;
            _Matrix[x] = new SimpleVector<T>(vsz);
            *_Matrix[x] = *vptr;
            _Matrix[x]->SetDataReferences(this, x);
          }
          else
          {
            _Matrix[x] = NULL;
            // _Matrix[x] = new SimpleVector<T>;
            // _Matrix[x]->SetDataReferences(this, x);
          }
        }
        else
        {
          _Matrix[x] = NULL;
          // _Matrix[x] = new SimpleVector<T>;
          // _Matrix[x]->SetDataReferences(this, x);
        }

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    if (OwnsData_)
      SetMaster(NULL, true);
    else
    {
      SetConstMaster(&Matr_, false);
      AppendCopyRefs(this, false);
    }
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::ShallowCopy(const SimpleMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix && Matr_._Matrix)
  {
    size_t x;
    size_t vsz;
    size_t max;
    SimpleMatrix<T>* mptr = ((SimpleMatrix<T>*)&Matr_);
    SimpleVector<T>* vptr;

    // Destroy existing objects
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);

      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
    }

    ::RawDeleteArray(_VectorSizes);
    ::RawDeleteArray(_VectorLengths);
    ::RawDeleteArray(_VectorIndexes);
    _VectorSizes =
    _VectorLengths =
    _VectorIndexes = NULL;    

    ::DeleteArray(_Matrix);
    _Matrix = NULL;

    // Recreate objects with new assigned vector size
    max = Matr_._MatrixSize;
    _Matrix = (SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * max);
    _VectorSizes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _VectorLengths = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _VectorIndexes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);

    _MatrixSize = max;
    _MatrixLength = Matr_._MatrixLength;
    _MatrixIndex = Matr_._MatrixIndex;

    ::memset(_Matrix, 0, sizeof(SimpleVector<T>*) * max);
    ::memset(_VectorSizes, 0, sizeof(size_t*) * max);
    ::memset(_VectorLengths, 0, sizeof(size_t*) * max);
    ::memset(_VectorIndexes, 0, sizeof(size_t*) * max);

    if (Matr_._Matrix)
      for (x = 0; x < max; x++)
        if (Matr_._Matrix[x])
        {
          _Matrix[x] = Matr_._Matrix[x];
          _Matrix[x]->SetDataReferences(this, x);
        }
        else
        {
          _Matrix[x] = NULL;
          // _Matrix[x] = new SimpleVector<T>;
          // _Matrix[x]->SetDataReferences(this, x);
        }

    _Unlinked = Matr_._Unlinked;
    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetConstMaster(&Matr_, false);
    AppendCopyRefs(this, false);
  }

  return *this;
}

/****************************************************************************/
template <class T>
PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
SimpleMatrix<T>::operator [] (const Index& i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  size_t v = size_t(i);
  if (z <= v && v < _MatrixSize && CopyTrackPtr())
  {
    _MatrixIndex = v;  
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_)
      return PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
                  (_CopyTracker, _MatrixIndex, _MatrixSize, TransCode_);
  }

  return PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
              (NULL, 0, _MatrixSize, 0, _Matrix);
}

/****************************************************************************/
template <class T>
PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
SimpleMatrix<T>::operator [] (int i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  if (z <= i && i < _MatrixSize && CopyTrackPtr())
  {
    _MatrixIndex = i;
    int TransCode_ = 0;

    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    
    
    if (TransCode_)
      return PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
                  (_CopyTracker, _MatrixIndex, _MatrixSize, TransCode_);
  }

  return PointerReturner<SimpleMatrix<T>::DTYPE,SimpleMatrix<T>::CTYPE>
              (NULL, 0, _MatrixSize, 0, _Matrix);
}

/****************************************************************************/
template <class T>
const SimpleVector<T>* SimpleMatrix<T>::Read(const Index & i) const
{
  SimpleVector<T>* Dummy_ = NULL;

  int z = 0;
  int v = int(i);
  if (z <= v && v < _MatrixSize)
    return _Matrix[v];

  return Dummy_;
}

/****************************************************************************/
template <class T>
const SimpleVector<T>* SimpleMatrix<T>::Read(int i) const
{
  SimpleVector<T>* Dummy_ = NULL;

  int z = 0;
  if (z <= i && i < _MatrixSize)
    return _Matrix[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::GrowMatrix(size_t Incr_)
{
  size_t x;
  size_t OldSz_ = _MatrixSize;
  SimpleVector<T>** OldMatr_ = _Matrix;

  _MatrixSize += Incr_;
  _Matrix = (SimpleVector<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleVector<T>*) * _MatrixSize);

  for (x = 0; x < OldSz_; x++)
    _Matrix[x] = OldMatr_[x];

  for (;x < _MatrixSize; x++)
    _Matrix[x] = NULL;

  ::DeleteArray(OldMatr_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetMatrixIndex(size_t Index_)
{
  if (0 <= Index_ && Index_ < _MatrixSize)
    _MatrixIndex = Index_;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::EraseMatrix(MemAllocMethod Method_)
{
  int x;
  if (!CopyTrackPtr())
    return;    

  bool OwnsData_ = _CopyTracker->OwnsData();
  bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                  _CopyTracker->IsOwnershipAttrib(true, true, false);

  // Destroy existing objects
  if (_CopyTracker)
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  // If NOT a shallow copied object
  if (!Shallow_)
  {
    // Passed delete Method_ argument is only for elements in vector objects
    if (_Matrix)
      for (x = 0; x < _MatrixSize; x++)
        if (_Matrix[x])
          _Matrix[x]->EraseVector(Method_);

    // Always using delete operator for pointers to SimpleVector objects
    if (_Matrix && OwnsData_)
      for (x = 0; x < _MatrixSize; x++)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            cout <<"Parent: " <<ClassID();
            cout <<":" <<ObjectID()
                 <<" : EraseMatrix(";
          #else
            cout <<"Parent: " <<ObjectID()
                 <<" : EraseMatrix(";
          #endif

          if (_Matrix[x])
            cout <<"(" <<x <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (ClassID() && _Matrix[x])
        {
          delete _Matrix[x];
          _Matrix[x] = NULL;
        }
      }

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(NULL, true);
  }
  else
  {
    if (_Matrix)
      for (x = 0; x < _MatrixSize; x++)
        _Matrix[x] = NULL;

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(this, false);
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::FindMatrixRunLength()
{
  size_t x = 0;
  if (_Matrix)
  for (x = 0; x < _MatrixSize && _Matrix[x]; x++);
  _MatrixLength = x;
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::RunLength()
{
  FindMatrixRunLength();
  return _MatrixLength;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::GrowVector(size_t Incr_)
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex])
    _Matrix[_MatrixIndex]->GrowVector(Incr_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::SetVectorIndex(size_t Index_)
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex] && _VectorSizes[_MatrixIndex] &&
      0 <= Index_ && Index_ < *_VectorSizes[_MatrixIndex])
    _Matrix[_MatrixIndex]->SetIndex(Index_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::EraseVector(MemAllocMethod Method_)
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex])
    _Matrix[_MatrixIndex]->EraseVector(Method_);
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::FindVectorRunLength()
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex])
    _Matrix[_MatrixIndex]->FindVectorRunLength();
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::VectorRunLength()
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex])
    return _Matrix[_MatrixIndex]->RunLength();

  return 0;
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::Fill(T* v)
{
  if (0 <= _MatrixIndex && _MatrixIndex < _MatrixSize &&
      _Matrix && _Matrix[_MatrixIndex])
  {
    size_t x;
    size_t max = _Matrix[_MatrixIndex]->GetCount();
  
    for (x = 0; x < max; x++)
      (*_Matrix[_MatrixIndex])[x] = v;
  }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::FillFrom(int ix, int iy, T* v)
{
  size_t x = size_t(ix);
  size_t y = size_t(iy);
  size_t z = 0;

  if (z <= x && x < _MatrixSize &&
      _Matrix && _Matrix[x])
    if (_Matrix[x])
    {
      size_t max = _Matrix[x]->GetCount();
      for (;y < max; y++)
        (*_Matrix[x])[y] = v;
    }
}

/****************************************************************************/
template <class T>
void SimpleMatrix<T>::FillFrom(const Index& ix, const Index& iy, T* v)
{
  size_t x = size_t(ix);
  size_t y = size_t(iy);
  size_t z = 0;
  
  if (z <= x && x < _MatrixSize &&
      _Matrix && _Matrix[x])
    if (_Matrix[x])
    {
      size_t max = _Matrix[x]->GetCount();
      for (;y < max; y++)
        (*_Matrix[x])[y] = v;
    }
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::VectorLength(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _MatrixSize &&
      _Matrix && _Matrix[Index_] && _VectorLengths[Index_])
    return *_VectorLengths[Index_];
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::VectorSize(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _MatrixSize &&
      _Matrix && _Matrix[Index_] && _VectorSizes[Index_])
    return *_VectorSizes[Index_];
}

/****************************************************************************/
template <class T>
size_t SimpleMatrix<T>::VectorIndex(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _MatrixSize &&
      _Matrix && _Matrix[Index_] && _VectorIndexes[Index_])
    return *_VectorIndexes[Index_];
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleMatrix<T>& RootObject(SimpleMatrix<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
const SimpleMatrix<T>& RootConstObject(const SimpleMatrix<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
int _WhatIs(const SimpleMatrix<T>& Obj_)
{
  return TypeInfo::SIMPLEMATRIX_TYPE;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleMatrix)
CLONEFNCS_TEMPLATE_DEFN(SimpleMatrix)

/****************************************************************************/
// Simple3DMatrix Class Definition
/****************************************************************************/
template <class T>
Simple3DMatrix<T>::Simple3DMatrix(size_t msz, size_t vsz):
_Error(FALSE),
_Matrix3D((SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * msz)),
_MatrixSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_MatrixLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_MatrixIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),

_Matrix3DSize(msz),
_Matrix3DLength(0),
_Matrix3DIndex(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * msz);
  ::memset(_MatrixSizes, 0, sizeof(size_t*) * msz);
  ::memset(_MatrixLengths, 0, sizeof(size_t*) * msz);
  ::memset(_MatrixIndexes, 0, sizeof(size_t*) * msz);
  size_t x;
  bool OwnsData_ = vsz > 0;

  if (!m_StaticCreate)
  {
    if (!Simple3DMatrix<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (vsz)
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix3D[x] = new SimpleMatrix<T>(vsz);
      _Matrix3D[x]->SetDataReferences(this, x);
    }
  }  
  else
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix3D[x] = NULL;
      // _Matrix3D[x] = new SimpleMatrix<T>;
      // _Matrix3D[x]->SetDataReferences(this, x);
    }    
  }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
    SetMaster(NULL, true);
  else
    SetMaster(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::Simple3DMatrix(size_t msz, const T** a, size_t vsz):
_Error(FALSE),
_Matrix3D((SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * msz)),
_MatrixSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_MatrixLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),
_MatrixIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * msz)),

_Matrix3DSize(msz),
_Matrix3DLength(0),
_Matrix3DIndex(0),
_CopyTracker(NULL),
_Unlinked(false),
_CpTrkInit(false)
{
  ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * msz);
  ::memset(_MatrixSizes, 0, sizeof(size_t*) * msz);
  ::memset(_MatrixLengths, 0, sizeof(size_t*) * msz);
  ::memset(_MatrixIndexes, 0, sizeof(size_t*) * msz);
  size_t x;
  bool OwnsData_ = vsz > 0;

  if (!m_StaticCreate)
  {
    if (!Simple3DMatrix<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (vsz)
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix3D[x] = new SimpleMatrix<T>(a, vsz);
      _Matrix3D[x]->SetDataReferences(this, x);
    }
  }
  else
  {
    for (x = 0; x < msz; x++)
    {
      _Matrix3D[x] = NULL;
      // _Matrix3D[x] = new SimpleMatrix<T>;
      // _Matrix3D[x]->SetDataReferences(this, x);
    }
  }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
    SetMaster(NULL, true);
  else
    SetMaster(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::Simple3DMatrix(const Simple3DMatrix<T>& Matr_, size_t start_, size_t end_):
_Error(FALSE),
_Matrix3D((SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * Matr_._Matrix3DSize)),
_MatrixSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),
_MatrixLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),
_MatrixIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),

_Matrix3DSize(Matr_._Matrix3DSize),
_Matrix3DLength(Matr_._Matrix3DLength),
_Matrix3DIndex(Matr_._Matrix3DIndex),
_CopyTracker(NULL),
_Unlinked(Matr_._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * _Matrix3DSize);
  ::memset(_MatrixSizes, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixLengths, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixIndexes, 0, sizeof(size_t*) * _Matrix3DSize);
  size_t x;
  size_t max = _Matrix3DSize;
  bool OwnsData_ = false;

  if (!m_StaticCreate)
  {
    if (!Simple3DMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (Matr_._Matrix3D)
    for (x = 0; x < max; x++)
      if (Matr_._Matrix3D[x])
      {
        OwnsData_ = true;
        _Matrix3D[x] = new SimpleMatrix<T>(*Matr_._Matrix3D[x], start_, end_);
        _Matrix3D[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix3D[x] = NULL;
        // _Matrix3D[x] = new SimpleMatrix<T>;
        // _Matrix3D[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
  {
    SetMaster(NULL, true);
    _Unlinked = false;
  }
  else
  {
    SetMaster(this, false);
    AppendConstCopyRefs(&Matr_, true);
  }

  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::Simple3DMatrix(const Simple3DMatrix<T>& Matr_):
_Error(FALSE),
_Matrix3D((SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * Matr_._Matrix3DSize)),
_MatrixSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),
_MatrixLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),
_MatrixIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * Matr_._Matrix3DSize)),

_Matrix3DSize(Matr_._Matrix3DSize),
_Matrix3DLength(Matr_._Matrix3DLength),
_Matrix3DIndex(Matr_._Matrix3DIndex),
_CopyTracker(NULL),
_Unlinked(Matr_._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * _Matrix3DSize);
  ::memset(_MatrixSizes, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixLengths, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixIndexes, 0, sizeof(size_t*) * _Matrix3DSize);
  size_t x;
  size_t max = _Matrix3DSize;
  bool OwnsDat_ = false;

  if (!m_StaticCreate)
  {
    if (!Simple3DMatrix<T>::_StaticClassPtr)
      Instance();
      
    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (Matr_._Matrix3D)
    for (x = 0; x < max; x++)    
      if (Matr_._Matrix3D[x])
      {
        _Matrix3D[x] = Matr_._Matrix3D[x];
        _Matrix3D[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix3D[x] = NULL;
        // _Matrix3D[x] = new SimpleMatrix<T>;
        // _Matrix3D[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  SetMaster(&Matr_, false);
  AppendCopyRefs(this, false);

  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : created shallow" <<endl;
  #endif  
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::Simple3DMatrix(const Simple3DMatrix<T> & a1,
                                  const Simple3DMatrix<T> & a2):
_Error(FALSE),
_Matrix3D((SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * (a1._Matrix3DSize + a2._Matrix3DSize))),
_MatrixSizes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._Matrix3DSize + a2._Matrix3DSize))),
_MatrixLengths((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._Matrix3DSize + a2._Matrix3DSize))),
_MatrixIndexes((size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * (a1._Matrix3DSize + a2._Matrix3DSize))),

_Matrix3DSize((a1._Matrix3DSize + a2._Matrix3DSize)),
_Matrix3DLength((a1._Matrix3DLength + a2._Matrix3DLength)),
_Matrix3DIndex(0),
_CopyTracker(NULL),
_Unlinked(a1._Unlinked || a2._Unlinked),
_CpTrkInit(false)
{
  ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * _Matrix3DSize);
  ::memset(_MatrixSizes, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixLengths, 0, sizeof(size_t*) * _Matrix3DSize);
  ::memset(_MatrixIndexes, 0, sizeof(size_t*) * _Matrix3DSize);
  size_t x;
  size_t max = _Matrix3DSize;
  bool OwnsData_ = false;

  if (!m_StaticCreate)
  {
    if (!Simple3DMatrix<T>::_StaticClassPtr)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (a1._Matrix3D && a2._Matrix3D)
    for (x = 0; x < max; x++)
      if (a1._Matrix3D[x] && a2._Matrix3D[x])
      {
        OwnsData_ = true;
        _Matrix3D[x] = new SimpleMatrix<T>(*a1._Matrix3D[x], *a2._Matrix3D[x]);
        _Matrix3D[x]->SetDataReferences(this, x);
      }
      else
      {
        _Matrix3D[x] = NULL;
        // _Matrix3D[x] = new SimpleMatrix<T>;
        // _Matrix3D[x]->SetDataReferences(this, x);
      }

  _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
  _CpTrkInit = _CopyTracker != NULL;
  if (_CpTrkInit)
    _CopyTracker->CheckUnlinked();

  if (OwnsData_)
  {
    SetMaster(NULL, true);
    _Unlinked = false;
  }
  else
  {
    SetMaster(&a1, false);
    AppendConstCopyRefs(&a2, true);
    AppendCopyRefs(this, false);
  }

  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : created ";
    if (OwnsData_)
      cout <<"master" <<endl;
    else
      cout <<"shallow" <<endl;
  #endif
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::~Simple3DMatrix()
{
  #if SIMPLEARRAY_DEBUG1
    cout <<"Simple3DMatrix Object "
         <<ObjectID() <<" : destroyed ";
    if (_CopyTracker)
      if (_CopyTracker->OwnsData())
        cout <<"master" <<endl;
      else
        cout <<"shallow" <<endl;
  #endif

  // Deleting reference copies of locally stored SimpleMatrix objects
  if (CopyTrackPtr())
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  ::RawDeleteArray(_MatrixSizes);
  ::RawDeleteArray(_MatrixLengths);
  ::RawDeleteArray(_MatrixIndexes);
  _MatrixSizes =
  _MatrixLengths =
  _MatrixIndexes = NULL;  

  // Analogous to deleting _Buffer in parent class of 1d SimpleMatrix class
  ::DeleteArray(_Matrix3D);
  _Matrix3D = NULL;

  if (!m_StaticDestroy && m_ObjectCnt > 1)
  {
    --m_ObjectCnt;

    if (m_AutoRelease && m_ObjectCnt == 1 && _StaticTrIndex)
    {
      m_StaticDestroy = true;
      m_AutoRelease = false;
      Release();
    }
  }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::Init()
{
  if (!Simple3DMatrix<T>::_StaticClassPtr)
  {
    Simple3DMatrix<T>::_StaticClassPtr = new Simple3DMatrix<T>();
    IsBuiltInTypeData();

    _StaticTrIndex = new_int(4);
    _StaticTrIndex[0] = VectorInfo::MTOSTRANS;
    _StaticTrIndex[1] = VectorInfo::STOMTRANS;
    _StaticTrIndex[2] = VectorInfo::STARTSC;
    _StaticTrIndex[3] = VectorInfo::STARTMO;
  }
}

/****************************************************************************/
template <class T>
int* Simple3DMatrix<T>::Instance()
{
  if (!Simple3DMatrix<T>::_StaticClassPtr)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;

    SimpleMatrix<T>::Instance();
  }

  return _StaticTrIndex;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && Simple3DMatrix<T>::_StaticClassPtr)
  {
    m_StaticDestroy = true;
    ::RawDeleteArray(_StaticTrIndex);
    _StaticTrIndex = NULL;
    delete Simple3DMatrix<T>::_StaticClassPtr;
    Simple3DMatrix<T>::_StaticClassPtr = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
template <class T>
bool Simple3DMatrix<T>::IsBuiltInTypeData()
{
  _StaticIsBuiltIn = false;
  return _StaticIsBuiltIn;
}

/****************************************************************************/
template <class T>
int Simple3DMatrix<T>::TrIndex(int i)
{
  if (!_StaticTrIndex)
    Instance();

  return _StaticTrIndex[i];
};

/****************************************************************************/
template <class T>
PointerCopyTracker<Simple3DMatrix<T>::TTYPE,Simple3DMatrix<T>::DTYPE>* Simple3DMatrix<T>::CopyTrackPtr()
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
const PointerCopyTracker<Simple3DMatrix<T>::TTYPE,Simple3DMatrix<T>::DTYPE>* Simple3DMatrix<T>::CopyTrackPtr() const
{
  return ((_CpTrkInit && _CopyTracker) ? _CopyTracker:NULL);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetDataRefs(SimpleMatrix<T>** Data_, size_t Index_)
{
  if (_Matrix3D && CopyTrackPtr())
  {
    size_t z;
    int TransCode_ = 0;

    for (z = 0; !TransCode_ && z < VectorInfo::MAXTRANS; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));

    if (TransCode_ == VectorInfo::MTOSTRANS &&
        Data_ && Index_ < _Matrix3DSize && Data_[Index_])
      Data_[Index_]->SetDataReferences(this, _Matrix3DIndex);
    else if (TransCode_ == VectorInfo::STOMTRANS)
    {
      if (_Matrix3D[_Matrix3DIndex])
        _Matrix3D[_Matrix3DIndex]->SetDataReferences(this, _Matrix3DIndex);
      else if (Data_ && Index_ < _Matrix3DSize && Data_[Index_])
        Data_[Index_]->SetDataReferences(this, _Matrix3DIndex);
    }
    else if (TransCode_ == VectorInfo::STARTSC)
    {
      if (Data_ && Index_ < _Matrix3DSize && Data_[Index_])
        Data_[Index_]->SetDataReferences(this, _Matrix3DIndex);
      else if (_Matrix3D[_Matrix3DIndex])
        _Matrix3D[_Matrix3DIndex]->SetDataReferences(this, _Matrix3DIndex);
    }
    else if (TransCode_ == VectorInfo::STARTMO && _Matrix3D[_Matrix3DIndex])
      _Matrix3D[_Matrix3DIndex]->SetDataReferences(this, _Matrix3DIndex);
  }
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::DTYPE** Simple3DMatrix<T>::AssignDataArray(Simple3DMatrix<T>::DTYPE** Vect_, size_t sz)
{
  if (Vect_ != _Matrix3D)
  {
    _Matrix3D = Vect_;
    _Matrix3DSize = sz;
  }
    
  return _Matrix3D;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::RetCallToShallow(bool Unlinked_, bool InitCall_)
{
  if (CopyTrackPtr())
  {
    bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                    _CopyTracker->IsOwnershipAttrib(true, true, false);

    if (Shallow_ || InitCall_)
      _Unlinked = Unlinked_;
  
    _CopyTracker->RetCallToShallow(Unlinked_, InitCall_);
  }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::ReplaceCopyTracker(PointerCopyTracker<Simple3DMatrix<T>::TTYPE,Simple3DMatrix<T>::DTYPE>* Ptr_,
                                           Simple3DMatrix<T>::TTYPE* Master_)
{
  if (Ptr_)
  {
    PointerCopyTracker<TTYPE,DTYPE>* NewPtr_ =
      new PointerCopyTracker<TTYPE,DTYPE>(*Ptr_);
    _CpTrkInit = NewPtr_ != NULL;
    if (_CpTrkInit)
      NewPtr_->CheckUnlinked();

    if (_CopyTracker)
      _CopyTracker->SetSelfErase(true);

    if (NewPtr_)
      NewPtr_->SetSelfErase(true);

    if (_CopyTracker && _CopyTracker->Swap(this))
      _CopyTracker->Pop();    

    _CopyTracker = NewPtr_;
    SetMaster(Master_, false);
  }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetMaster(Simple3DMatrix<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster(Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetConstMaster(const Simple3DMatrix<T>::TTYPE* Ptr_, bool OwnsData_)
{
  if (CopyTrackPtr())
    _CopyTracker->SetMaster((Simple3DMatrix<T>::TTYPE*)Ptr_, OwnsData_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::AppendCopyRefs(Simple3DMatrix<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs(Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::AppendConstCopyRefs(const Simple3DMatrix<T>::TTYPE* Ptr_, bool ChainAppend_)
{
  if (CopyTrackPtr())
    _CopyTracker->AppendCopyRefs((Simple3DMatrix<T>::TTYPE*)Ptr_, ChainAppend_);
}

/****************************************************************************/
template <class T>
bool Simple3DMatrix<T>::IsOwnershipAttrib(bool OwnsData_, bool SelfErase_, bool Shallow_) const
{
  if (CopyTrackPtr())
    _CopyTracker->IsOwnershipAttrib(OwnsData_, SelfErase_, Shallow_);
}

/****************************************************************************/
template <class T>
bool Simple3DMatrix<T>::HasThis(Simple3DMatrix<T>::TTYPE* ToFind_, Simple3DMatrix<T>::NTYPE** Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->HasThis(ToFind_, Node_):false);
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::TTYPE* Simple3DMatrix<T>::Push(Simple3DMatrix<T>::TTYPE* Val_)
{
  return (CopyTrackPtr() ? _CopyTracker->Push(Val_):NULL);
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::TTYPE* Simple3DMatrix<T>::Swap(Simple3DMatrix<T>::TTYPE* Head_, Simple3DMatrix<T>::NTYPE* Node_)
{
  return (CopyTrackPtr() ? _CopyTracker->Swap(Head_, Node_):NULL);
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>::TTYPE* Simple3DMatrix<T>::Pop()
{
  return (CopyTrackPtr() ? _CopyTracker->Pop():NULL);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetAllocationMethod(MemAllocMethod Method_)
{
  _AllocMethod = Method_;
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make()
{
  return (new Simple3DMatrix<T>);
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make(size_t n)
{
  return (new Simple3DMatrix<T>(n));
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make(const T** a, size_t n)
{
  return (new Simple3DMatrix<T>(a, n));
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make(const Simple3DMatrix<T>& Arr_, size_t start_, size_t end_)
{
  return (new Simple3DMatrix<T>(Arr_, start_, end_));
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make(const Simple3DMatrix<T>& Arr_)
{
  return (new Simple3DMatrix<T>(Arr_));
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>* Simple3DMatrix<T>::Make(const Simple3DMatrix<T> & a1, const Simple3DMatrix<T> & a2)
{
  return (new Simple3DMatrix<T>(a1, a2));
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetDataErase(bool f)
{
  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(f);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetAutoErase(bool f, Simple3DMatrix<T>* This_)
{
  _AutoErase = f;

  if (This_)
    This_->SetDataErase(_AutoErase);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetAutoErase(bool f)
{
  _AutoErase = f;

  if (CopyTrackPtr())
    _CopyTracker->SetEraseData(_AutoErase);
}

/****************************************************************************/
template <class T>
bool Simple3DMatrix<T>::IsClassType(int Type_) const
{
  return (Type_ == VectorInfo::MATRIX3D);
}

/****************************************************************************/
template <class T>
bool Simple3DMatrix<T>::IsMultiDimType() const
{
  return true;
}

/****************************************************************************/
template <class T>
Boolean Simple3DMatrix<T>::IsCommonClass(int IDvalue_) const
{
  return (IDvalue_ == ClassID());
}

/****************************************************************************/
template <class T>
int Simple3DMatrix<T>::ClassID() const
{
  return TypeInfo::SIMPLE3DMATRIX_TYPE;
}

/****************************************************************************/
template <class T>
const char* Simple3DMatrix<T>::ClassName() const
{
  return NameOf(*this);
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::ObjectID() const
{
  return _ObjectID;
}

/****************************************************************************/
template <class T>
const SimpleMatrix<T>* Simple3DMatrix<T>::IndexedElement() const
{
  return (_Matrix3D ? _Matrix3D[_Matrix3DIndex]:NULL);
}

/****************************************************************************/
template <class T>
SimpleMatrix<T>* Simple3DMatrix<T>::IndexedElement()
{
  return (_Matrix3D ? _Matrix3D[_Matrix3DIndex]:NULL);
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>& Simple3DMatrix<T>::operator = (const Simple3DMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix3D && Matr_._Matrix3D)
  {
    size_t z = 0;
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_ == VectorInfo::STARTSC ||
        TransCode_ == VectorInfo::MTOSTRANS)
      return ShallowCopy(Matr_);
    else if (TransCode_ == VectorInfo::STARTMO ||
             TransCode_ == VectorInfo::STOMTRANS)
      return DeepCopy(Matr_);
  }

  return *this;
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>& Simple3DMatrix<T>::DeepCopy(const Simple3DMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix3D && Matr_._Matrix3D)
  {  
    size_t x;
    size_t vsz;
    size_t max;
    Simple3DMatrix<T>* mptr = ((Simple3DMatrix<T>*)&Matr_);
    SimpleMatrix<T>* vptr;

    // Destroy existing objects
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);
  
      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
    }

    ::RawDeleteArray(_MatrixSizes);
    ::RawDeleteArray(_MatrixLengths);
    ::RawDeleteArray(_MatrixIndexes);
    _MatrixSizes =
    _MatrixLengths =
    _MatrixIndexes = NULL;    

    ::DeleteArray(_Matrix3D);
    _Matrix3D = NULL;

    // Recreate objects with new assigned vector size
    max = Matr_._Matrix3DSize;
    _Matrix3D = (SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * max);
    _MatrixSizes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _MatrixLengths = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _MatrixIndexes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);

    _Matrix3DSize = max;
    _Matrix3DLength = Matr_._Matrix3DLength;
    _Matrix3DIndex = Matr_._Matrix3DIndex;

    ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * max);
    ::memset(_MatrixSizes, 0, sizeof(size_t*) * max);
    ::memset(_MatrixLengths, 0, sizeof(size_t*) * max);
    ::memset(_MatrixIndexes, 0, sizeof(size_t*) * max);
    bool OwnsData_ = false;

    if (Matr_._Matrix3D)
      for (x = 0; x < max; x++)
        if (Matr_._Matrix3D[x])
        {
          // Deep copy vector elements from assigned vector
          vsz = mptr->MatrixSize(x);
          vptr = (*mptr)[x];
          
          if (vsz && vptr)
          {
            OwnsData_ = true;
            _Matrix3D[x] = new SimpleMatrix<T>(vsz);
            *_Matrix3D[x] = *vptr;
            _Matrix3D[x]->SetDataReferences(this, x);
          }
          else
          {
            _Matrix3D[x] = NULL;
            // _Matrix3D[x] = new SimpleMatrix<T>;
            // _Matrix3D[x]->SetDataReferences(this, x);
          }
        }
        else
        {
          _Matrix3D[x] = NULL;
          // _Matrix3D[x] = new SimpleMatrix<T>;
          // _Matrix3D[x]->SetDataReferences(this, x);
        }

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    if (OwnsData_)
      SetMaster(NULL, true);
    else
    {
      SetConstMaster(&Matr_, false);
      AppendCopyRefs(this, false);
    }
  }

  return *this;
}

/****************************************************************************/
template <class T>
Simple3DMatrix<T>& Simple3DMatrix<T>::ShallowCopy(const Simple3DMatrix<T>& Matr_)
{
  if (this != &Matr_ && _Matrix3D && Matr_._Matrix3D)
  {
    size_t x;
    size_t vsz;
    size_t max;
    Simple3DMatrix<T>* mptr = ((Simple3DMatrix<T>*)&Matr_);
    SimpleMatrix<T>* vptr;

    // Destroy existing objects
    if (_CopyTracker)
    {
      _CopyTracker->RemoveCopyRefs(this);
  
      if (!_CopyTracker->HasCopyRefs())
      {
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
      else
      {
        SetConstMaster(this, false);
        delete _CopyTracker;
        _CopyTracker = NULL;
      }
    }

    ::RawDeleteArray(_MatrixSizes);
    ::RawDeleteArray(_MatrixLengths);
    ::RawDeleteArray(_MatrixIndexes);
    _MatrixSizes =
    _MatrixLengths =
    _MatrixIndexes = NULL;    

    ::DeleteArray(_Matrix3D);
    _Matrix3D = NULL;

    // Recreate objects with new assigned vector size
    max = Matr_._Matrix3DSize;
    _Matrix3D = (SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * max);
    _MatrixSizes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _MatrixLengths = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);
    _MatrixIndexes = (size_t**)RawAllocateWith(MEMMATRIX, sizeof(size_t*) * max);

    _Matrix3DSize = max;
    _Matrix3DLength = Matr_._Matrix3DLength;
    _Matrix3DIndex = Matr_._Matrix3DIndex;

    ::memset(_Matrix3D, 0, sizeof(SimpleMatrix<T>*) * max);
    ::memset(_MatrixSizes, 0, sizeof(size_t*) * max);
    ::memset(_MatrixLengths, 0, sizeof(size_t*) * max);
    ::memset(_MatrixIndexes, 0, sizeof(size_t*) * max);

    if (Matr_._Matrix3D)
      for (x = 0; x < max; x++)
        if (Matr_._Matrix3D[x])
        {
          _Matrix3D[x] = Matr_._Matrix3D[x];
          _Matrix3D[x]->SetDataReferences(this, x);
        }
        else
        {
          _Matrix3D[x] = NULL;
          // _Matrix3D[x] = new SimpleMatrix<T>;
          // _Matrix3D[x]->SetDataReferences(this, x);
        }

    _Unlinked = Matr_._Unlinked;
    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetConstMaster(&Matr_, false);
    AppendCopyRefs(this, false);
  }

  return *this;
}

/****************************************************************************/
template <class T>
PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
Simple3DMatrix<T>::operator [] (const Index& i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  size_t v = size_t(i);
  if (z <= v && v < _Matrix3DSize && CopyTrackPtr())
  {
    _Matrix3DIndex = v;  
    int TransCode_ = 0;
    
    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    

    if (TransCode_)
      return PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
                  (_CopyTracker, _Matrix3DIndex, _Matrix3DSize, TransCode_);
  }

  return PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
              (NULL, 0, _Matrix3DSize, 0, _Matrix3D);
}

/****************************************************************************/
template <class T>
PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
Simple3DMatrix<T>::operator [] (int i)
{
  // IsTransitionAttrib(bool MtoStrans_, bool StoMtrans_,
  //                    bool StartSc_, bool StartMo_)
  //
  size_t z = 0;
  if (z <= i && i < _Matrix3DSize && CopyTrackPtr())
  {
    _Matrix3DIndex = i;
    int TransCode_ = 0;

    for (z = 0; !TransCode_ && z < 4; z++)
      TransCode_ = _CopyTracker->IsTransitionAttrib(TrIndex(z));    
    
    if (TransCode_)
      return PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
                  (_CopyTracker, _Matrix3DIndex, _Matrix3DSize, TransCode_);
  }

  return PointerReturner<Simple3DMatrix<T>::DTYPE,Simple3DMatrix<T>::CTYPE>
              (NULL, 0, _Matrix3DSize, 0, _Matrix3D);
}

/****************************************************************************/
template <class T>
const SimpleMatrix<T>* Simple3DMatrix<T>::Read(const Index & i) const
{
  SimpleMatrix<T>* Dummy_ = NULL;

  int z = 0;
  int v = int(i);
  if (z <= v && v < _Matrix3DSize)
    return _Matrix3D[v];

  return Dummy_;
}

/****************************************************************************/
template <class T>
const SimpleMatrix<T>* Simple3DMatrix<T>::Read(int i) const
{
  SimpleMatrix<T>* Dummy_ = NULL;

  int z = 0;
  if (z <= i && i < _Matrix3DSize)
    return _Matrix3D[i];

  return Dummy_;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::GrowMatrix3D(size_t Incr_)
{
  size_t x;
  size_t OldSz_ = _Matrix3DSize;
  SimpleMatrix<T>** OldMatr_ = _Matrix3D;

  _Matrix3DSize += Incr_;
  _Matrix3D = (SimpleMatrix<T>**)RawAllocateWith(MEMMATRIX, sizeof(SimpleMatrix<T>*) * _Matrix3DSize);

  for (x = 0; x < OldSz_; x++)
    _Matrix3D[x] = OldMatr_[x];

  for (;x < _Matrix3DSize; x++)
    _Matrix3D[x] = NULL;

  ::DeleteArray(OldMatr_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetMatrix3DIndex(size_t Index_)
{
  if (0 <= Index_ && Index_ < _Matrix3DSize)
    _Matrix3DIndex = Index_;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::EraseMatrix3D(MemAllocMethod Method_)
{
  int x;
  if (!CopyTrackPtr())
    return;    

  bool OwnsData_ = _CopyTracker->OwnsData();
  bool Shallow_ = _CopyTracker->IsOwnershipAttrib(false, false, true) ||
                  _CopyTracker->IsOwnershipAttrib(true, true, false);

  // Destroy existing objects
  if (_CopyTracker)
  {
    _CopyTracker->RemoveCopyRefs(this);
  
    if (!_CopyTracker->HasCopyRefs())
    {
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
    else
    {
      SetConstMaster(this, false);
      delete _CopyTracker;
      _CopyTracker = NULL;
    }
  }

  // If NOT a shallow copied object
  if (!Shallow_)
  {
    // Passed delete Method_ argument is only for elements in vector objects
    if (_Matrix3D)
      for (x = 0; x < _Matrix3DSize; x++)
        if (_Matrix3D[x])
          _Matrix3D[x]->EraseMatrix(Method_);

    // Always using delete operator for pointers to SimpleMatrix objects
    if (_Matrix3D && OwnsData_)
      for (x = 0; x < _Matrix3DSize; x++)
      {
        #if SIMPLEARRAY_DEBUG1
          #if SIMPLEARRAY_DEBUG1a
            cout <<"Parent: " <<ClassID();
            cout <<":" <<ObjectID()
                 <<" : EraseMatrix(";
          #else
            cout <<"Parent: " <<ObjectID()
                 <<" : EraseMatrix(";
          #endif

          if (_Matrix3D[x])
            cout <<"(" <<x <<")" <<endl;
          else
            cout <<"null)" <<endl;
        #endif

        if (ClassID() && _Matrix3D[x])
        {
          delete _Matrix3D[x];
          _Matrix3D[x] = NULL;
        }
      }

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(NULL, true);
  }
  else
  {
    if (_Matrix3D)
      for (x = 0; x < _Matrix3DSize; x++)
        _Matrix3D[x] = NULL;

    _CopyTracker = new PointerCopyTracker<TTYPE,DTYPE>(this);
    _CpTrkInit = _CopyTracker != NULL;
    if (_CpTrkInit)
      _CopyTracker->CheckUnlinked();

    SetMaster(this, false);
  }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::FindMatrix3DRunLength()
{
  size_t x = 0;
  if (_Matrix3D)
  for (x = 0; x < _Matrix3DSize && _Matrix3D[x]; x++);
  _Matrix3DLength = x;
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::RunLength()
{
  FindMatrixRunLength();
  return _Matrix3DLength;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::GrowMatrix(size_t Incr_)
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex])
    _Matrix3D[_Matrix3DIndex]->GrowMatrix(Incr_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::SetMatrixIndex(size_t Index_)
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex] && _MatrixSizes[_Matrix3DIndex] &&
      0 <= Index_ && Index_ < *_MatrixSizes[_Matrix3DIndex])
    _Matrix3D[_Matrix3DIndex]->SetMatrixIndex(Index_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::EraseMatrix(MemAllocMethod Method_)
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex])
    _Matrix3D[_Matrix3DIndex]->EraseMatrix(Method_);
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::FindMatrixRunLength()
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex])
    _Matrix3D[_Matrix3DIndex]->FindMatrixRunLength();
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::MatrixRunLength()
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex])
    return _Matrix3D[_Matrix3DIndex]->RunLength();

  return 0;
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::Fill(T* v)
{
  if (0 <= _Matrix3DIndex && _Matrix3DIndex < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[_Matrix3DIndex])
  {
    size_t x;
    size_t max = _Matrix3D[_Matrix3DIndex]->GetCount();

    for (x = 0; x < max; x++)
      if ((*_Matrix3D[_Matrix3DIndex])[x])
        (*(*_Matrix3D[_Matrix3DIndex])[x]).Fill(v);
  }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::FillFrom(int ix, int iy, int iz, T* v)
{
  size_t x = size_t(ix);
  size_t y = size_t(iy);
  size_t z = size_t(iz);
  size_t n = 0;

  if (n <= x && x < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[x])
    if (_Matrix3D[x])
    {
      size_t maxy = _Matrix3D[x]->GetCount();
      for (;y < maxy; y++)
      {
        if ((*_Matrix3D[x])[y])
        {
          size_t maxz = (*(*_Matrix3D[x])[y]).GetCount();
          for (;z < maxz; z++)
            (*(*_Matrix3D[x])[y])[z] = v;
        }
      }
    }
}

/****************************************************************************/
template <class T>
void Simple3DMatrix<T>::FillFrom(const Index& ix, const Index& iy, const Index& iz, T* v)
{
  size_t x = size_t(ix);
  size_t y = size_t(iy);
  size_t z = size_t(iz);
  size_t n = 0;
  
  if (z <= x && x < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[x])
    if (_Matrix3D[x])
    {
      size_t maxy = _Matrix3D[x]->GetCount();      
      for (;y < maxy; y++)
      {
        if ((*_Matrix3D[x])[y])
        {
          size_t maxz = (*(*_Matrix3D[x])[y]).GetCount();
          for (;z < maxz; z++)
            (*(*_Matrix3D[x])[y])[z] = v;
        }
      }
    }
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::MatrixLength(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[Index_] && _MatrixLengths[Index_])
    return *_MatrixLengths[Index_];
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::MatrixSize(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[Index_] && _MatrixSizes[Index_])
    return *_MatrixSizes[Index_];
}

/****************************************************************************/
template <class T>
size_t Simple3DMatrix<T>::MatrixIndex(size_t Index_) const
{
  if (0 <= Index_ && Index_ < _Matrix3DSize &&
      _Matrix3D && _Matrix3D[Index_] && _MatrixIndexes[Index_])
    return *_MatrixIndexes[Index_];
}

/****************************************************************************/
/****************************************************************************/
template <class T>
Simple3DMatrix<T>& RootObject(Simple3DMatrix<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
const Simple3DMatrix<T>& RootConstObject(const Simple3DMatrix<T>& Obj_)
{
  return Obj_;
}

/****************************************************************************/
template <class T>
int _WhatIs(const Simple3DMatrix<T>& Obj_)
{
  return TypeInfo::SIMPLE3DMATRIX_TYPE;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(Simple3DMatrix)
CLONEFNCS_TEMPLATE_DEFN(Simple3DMatrix)

/****************************************************************************/
/****************************************************************************/
#if SIMPLEARRAY_DEBUG
// template function to display array
template <class T>
ostream & operator << (ostream & buffer, SimpleArray<T> & a)
{
  buffer << "[" <<0 << "," <<a.GetCount() << "] ";

  for (int i = 0; i < a.GetCount(); ++i)
    buffer << a[i] << " ";

  return buffer;
}

template <class T>
ostream & operator << (ostream & buffer, SimpleVector<T> & a)
{
  buffer << "[" <<0 << "," <<a.GetCount() << "] ";

  if (a.Base() && !a.IsUnlinked())
    for (int i = 0; i < a.GetCount(); ++i)
      if (a[i])
        buffer << *a[i] << " ";
      else
        buffer << "null ";

  return buffer;
}

template <class T>
ostream & operator << (ostream & buffer, SimpleMatrix<T> & a)
{
  buffer << "[" <<0 << "," <<a.GetCount() << "] ";

  if (a.Base() && !a.IsUnlinked())
    for (int i = 0; i < a.GetCount(); ++i)
      if (a[i])
        buffer << *a[i] <<"\n";
      else
        buffer <<"null\n";

  return buffer;
}

template <class T>
ostream & operator << (ostream & buffer, Simple3DMatrix<T> & a)
{
  buffer << "[" <<0 << "," <<a.GetCount() << "] ";

  if (a.Base() && !a.IsUnlinked())
    for (int i = 0; i < a.GetCount(); ++i)
      if (a[i])
        buffer << *a[i] <<"\n";
      else
        buffer <<"null\n";

  return buffer;
}

/****************************************************************************/
void ArrayTest1(ostream & buffer)
{
    // banner
    buffer << "\r\nArrays: Basic Tests"
              "\r\n--------------------\r\n";

    // locals
    SimpleArray<int> ia(21);
    int n;

    // fill array with count
    for (n = 1; n <= 20; ++n)
	ia[n] = n;

    // display array
    buffer <<"         Array A = " << ia << "\r\n";

    // duplicate array
    SimpleArray<int> ib(ia);
    buffer <<"<copy>   Array B = " << ib << "\r\n";

    // create a subset
    SimpleArray<int> ic(ia,3,16);
    buffer <<"<subset> Array C = " << ic << "\r\n";
}

/****************************************************************************/
void ArrayTest2(ostream & buffer)
{
    // banner
    buffer << "\r\nArrays: Sorting"
              "\r\n----------------\r\n";

    // constants
    int MaxVal = 1701;

    // locals
    int n;
    SimpleArray<int> a(102);

    // fill array with random values and display it
    for (n = 0; n <= 101; ++n)
	a[n]  = RANDOM(MaxVal);

    // duplicate array for second sort
    SimpleArray<int> a2(a);

    // now sort with new manipulator
    buffer << "With QuickSort:\r\n";
    ItemSorter<int, int> Sorter_;
    Sorter_.SetSortHelper(ObjectSortHelper<int, int>::Make());

    buffer << "   Unsorted Array = " << a << "\r\n";
    Sorter_.QuickSort(a.Base(), 0, 101);
    buffer << "     Sorted Array = " << a << "\r\n";
    Sorter_.SetOrder(SortOrder::DECREASING);
    Sorter_.QuickSort(a2.Base(), 0, 101);
    buffer << "     Reverse Sort = " << a2 << "\r\n";
}

/****************************************************************************/
void ArrayTest8(ostream & buffer)
{
    buffer << "\r\nArrays: String Object Example"
              "\r\n------------------------------\r\n";

    SimpleArray<SimpleStr> sa(10);

    sa[0] = SimpleStr("Zero");
    sa[1] = SimpleStr("One");
    sa[2] = SimpleStr("Two");
    sa[3] = SimpleStr("Three");
    sa[4] = SimpleStr("Four");
    sa[5] = SimpleStr("Five");
    sa[6] = SimpleStr("Six");
    sa[7] = SimpleStr("Seven");
    sa[8] = SimpleStr("Eight");
    sa[9] = SimpleStr("Nine");

    buffer << "String array test = " << sa << "\r\n";
}

/****************************************************************************/
void ArrayTest12(ostream & buffer)
{
    buffer << "\r\nArrays: Iterator Tests"
              "\r\n-----------------------\r\n";

    SimpleArray<double> da(11);
    size_t i;
    
    for (i = 0; i < 11; i++)
      da[i] = i;    

    SimpleArrayIter<double> dptr(da);

    buffer << " forward: ";
    while (1)
    {
        buffer << (*dptr) << " ";
        
        if (dptr.IsLast())
            break;

        ++dptr;
    }

    buffer << "\r\nbackward: ";
    while (1)
    {
        buffer << (*dptr) << " ";
        
        if (dptr.IsFirst())
            break;

        --dptr;
    }

    // dptr.Destroy();
    buffer << "\r\n";
}

/****************************************************************************/
/****************************************************************************/
void VectorTest1(ostream & buffer)
{
  // banner
  buffer << "\r\nVectors: Basic Tests"
            "\r\n---------------------\r\n";

  // locals
  SimpleVector<int> via(21);
  via.SetAutoErase(false, &via);
  int n;

  // fill array with count
  for (n = 0; n <= 20; ++n)
    via[n] = new int(n);

  // display array
  buffer <<"         Vector A = " <<via <<"\r\n";

  // duplicate array
  SimpleVector<int> vib(via);
  buffer <<"<copy>   Vector B = " <<vib <<"\r\n";

  // create a subset
  SimpleVector<int> vic(via,3,16);
  buffer <<"<subset> Vector C = " <<vic <<"\r\n";
  
  via.GrowVector(14);
  int min = 21;
  int max = min + 14;
  int x = 0;
  
  for (n = min; n < max; n++)
    via[n] = new int(*vic[x++]);

  buffer <<"<extend> Vector A = " <<via <<"\r\n";
  via.EraseVector(STD_NEW);
}

/****************************************************************************/
void VectorTest2(ostream & buffer)
{
    // banner
    buffer << "\r\nVectors: Sorting"
              "\r\n-----------------\r\n";

    // constants
    int MaxVal = 1701;

    // locals
    int n;
    SimpleVector<int> vn(102);
    vn.SetAutoErase(true);

    // fill array with random values and display it
    for (n = 0; n <= 101; ++n)
      vn[n]  = new int(RANDOM(MaxVal));

    // duplicate array for second sort
    SimpleVector<int> vn2(vn.GetCount());
    vn2 = vn;

    // now sort with new manipulator
    buffer << "With QuickSort:\r\n";

    ItemSorter<int*, int> Sorter_;
    Sorter_.SetSortHelper(PointerSortHelper<int*, int>::Make());
    buffer << "   Unsorted Array = " << vn2 << "\r\n";
    
    Sorter_.QuickSort(vn2.Base(), 0, 101);
    buffer << "     Sorted Array = " << vn2 << "\r\n";
    // vn2.EraseVector(STD_NEW);
    
    Sorter_.SetOrder(SortOrder::DECREASING);
    Sorter_.QuickSort(vn.Base(), 0, 101);
    buffer << "     Reverse Sort = " << vn << "\r\n";
}

/****************************************************************************/
void VectorTest8(ostream & buffer)
{
    buffer << "\r\nVectors: String Object Example"
              "\r\n-------------------------------\r\n";

    SimpleVector<SimpleStr> sa(10);
    sa.SetAutoErase(true);

    sa[0] = new SimpleStr("Zero");
    sa[1] = new SimpleStr("One");
    sa[2] = new SimpleStr("Two");
    sa[3] = new SimpleStr("Three");
    sa[4] = new SimpleStr("Four");
    sa[5] = new SimpleStr("Five");
    sa[6] = new SimpleStr("Six");
    sa[7] = new SimpleStr("Seven");
    sa[8] = new SimpleStr("Eight");
    sa[9] = new SimpleStr("Nine");

    buffer << "String array test = " << sa << "\r\n";
}

/****************************************************************************/
void VectorTest12(ostream & buffer)
{
    buffer << "\r\nVector: Iterator Tests"
              "\r\n-----------------------\r\n";

    char strbuf[64];
    SimpleVector<double> da(11);
    da.SetAutoErase(true);
    size_t i;
    
    for (i = 0; i < 11; i++)
      da[i] = new double(i);

    SimpleVectorIter<double> dptr(da);

    buffer << " forward: ";
    while (1)
    {
        buffer << (*dptr ? FloatToStr(**dptr, strbuf, 4, 1):"null") << " ";
        if (dptr.IsLast())
            break;

        ++dptr;
    }

    buffer << "\r\nbackward: ";
    while (1)
    {
        buffer << (*dptr ? FloatToStr(**dptr, strbuf, 4, 1):"null") << " ";
        if (dptr.IsFirst())
            break;

        --dptr;
    }

    // dptr.Destroy();
    buffer << "\r\n";
}

/****************************************************************************/
/****************************************************************************/
void MatrixTest1(ostream & buffer)
{
  // banner
  buffer << "\r\nMatrix: Basic Tests"
            "\r\n--------------------\r\n";

  // locals
  SimpleMatrix<int> mia(3, 0);
  mia.SetAutoErase(true, &mia);
  int n;

  // locals
  SimpleVector<int>* vptr = NULL;
  SimpleVector<int>* via = new SimpleVector<int>(21);
  via->SetAutoErase(true);

  // fill array with count
  for (n = 0; n <= 20; ++n)
    (*via)[n] = new int(n);

  // display array
  buffer <<"         Vector A = " <<*via <<"\r\n";

  // duplicate array
  SimpleVector<int>* vib = new SimpleVector<int>(*via);
  buffer <<"<copy>   Vector B = " <<*vib <<"\r\n";

  // create a subset
  SimpleVector<int>* vic = new SimpleVector<int>(*via,3,16);
  buffer <<"<subset> Vector C = " <<*vic <<"\r\n";

  mia[0] = via;
  mia[1] = vib;
  mia[2] = vic;
  
  (*mia[0]).GrowVector(14);
  int min = 21;
  int max = min + 14;
  int x = 0;
    
  for (n = min; n < max; n++)
    (*mia[0])[n] = new int(*(*vic)[x++]);

  // display mia[0] == via
  vptr = mia[0];
  buffer <<"Matrix[0], Vect:A = ";
  if (vptr)
    buffer <<*vptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";

  // display mia[1] == vib
  vptr = mia[1];
  buffer <<"Matrix[1], Vect:B = ";
  if (vptr)
    buffer <<*vptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";

  // display mia[2] == vic
  vptr = mia[2];
  buffer <<"Matrix[2], Vect:C = ";
  if (vptr)
    buffer <<*vptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";
}

/****************************************************************************/
void Matrix3DTest1(ostream & buffer)
{
  // banner
  buffer << "\r\n3DMatrix: Basic Tests"
            "\r\n----------------------\r\n";

  // locals
  Simple3DMatrix<int> cube(3, 0);
  cube.SetAutoErase(true, &cube);

  SimpleMatrix<int>* mptr = NULL;
  SimpleMatrix<int>* mia = new SimpleMatrix<int>(3, 0);
  mia->SetAutoErase(true);
  SimpleMatrix<int>* mib = new SimpleMatrix<int>(3, 0);
  SimpleMatrix<int>* mic = new SimpleMatrix<int>(3, 0);

  SimpleVector<int>* topv1 = new SimpleVector<int>(3);
  topv1->SetAutoErase(true);
  SimpleVector<int>* topv2 = new SimpleVector<int>(3);
  SimpleVector<int>* topv3 = new SimpleVector<int>(3);

  SimpleVector<int>* midv1 = new SimpleVector<int>(3);
  SimpleVector<int>* midv2 = new SimpleVector<int>(3);
  SimpleVector<int>* midv3 = new SimpleVector<int>(3);

  SimpleVector<int>* botv1 = new SimpleVector<int>(3);
  SimpleVector<int>* botv2 = new SimpleVector<int>(3);
  SimpleVector<int>* botv3 = new SimpleVector<int>(3);

  int planemult[3] = {100, 200, 300};
  int linemult[3] = {10, 20, 30};

  int x;
  for (x = 1; x <= 3; x++)
  {
    (*topv1)[x-1] = new int(planemult[0] + linemult[0] + x);
    (*topv2)[x-1] = new int(planemult[0] + linemult[1] + x);
    (*topv3)[x-1] = new int(planemult[0] + linemult[2] + x);

    (*midv1)[x-1] = new int(planemult[1] + linemult[0] + x);
    (*midv2)[x-1] = new int(planemult[1] + linemult[1] + x);
    (*midv3)[x-1] = new int(planemult[1] + linemult[2] + x);

    (*botv1)[x-1] = new int(planemult[2] + linemult[0] + x);
    (*botv2)[x-1] = new int(planemult[2] + linemult[1] + x);
    (*botv3)[x-1] = new int(planemult[2] + linemult[2] + x);
  }  

  (*mia)[0] = topv1;
  (*mia)[1] = topv2;
  (*mia)[2] = topv3;

  (*mib)[0] = midv1;
  (*mib)[1] = midv2;
  (*mib)[2] = midv3;

  (*mic)[0] = botv1;
  (*mic)[1] = botv2;
  (*mic)[2] = botv3;

  cube[0] = mia;
  cube[1] = mib;
  cube[2] = mic;

  mptr = cube[0];
  buffer <<"cube[0] = ";
  if (mptr)
    buffer <<*mptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";

  mptr = cube[1];
  buffer <<"cube[1] = ";
  if (mptr)
    buffer <<*mptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";

  mptr = cube[2];
  buffer <<"cube[2] = ";
  if (mptr)
    buffer <<*mptr <<"\r\n";
  else
    buffer <<"(null)" <<"\r\n";
}

/****************************************************************************/
/****************************************************************************/
int main()
{
  // MemMatrix::SetErrorRecovery(TRUE);
  RANDOMIZE();

  #if SIMPARR_ARRAYTESTS
    ArrayTest1(cout);
    ArrayTest2(cout);
    ArrayTest8(cout);
    #if SIMPARR_ARRITERTESTS
      ArrayTest12(cout);
    #endif
  #endif

  #if SIMPARR_VECTORTESTS
    VectorTest1(cout);
    VectorTest2(cout);
    VectorTest8(cout);
    #if SIMPARR_VECTITERTESTS
      VectorTest12(cout);
    #endif
  #endif

  #if SIMPARR_MATRIXTESTS
    MatrixTest1(cout);
  #endif

  #if SIMPARR_3DMATRIXTESTS
    Matrix3DTest1(cout);
  #endif

  return 0;
}
#endif
/****************************************************************************/
#endif





