#ifndef SIMPLELIST_CPP
#define SIMPLELIST_CPP
#ifndef SIMPLELIST_H
  #include "simplelist.h"
#endif

/****************************************************************************/
template <class T>
ConstListIterator<T>::ConstListIterator(const SimpleList<T>* List_):
_ConstList(List_),
_ConstHere(List_ ? List_->Head():NULL),
_Index(0)
{}

/****************************************************************************/
template <class T>
Boolean ConstListIterator<T>::More() const
{
  return (_ConstHere->Next() != NULL);
}

/****************************************************************************/
template <class T>
Boolean ConstListIterator<T>::Less() const
{
  return ((_ConstList->NodeLinks() == 2) ? (_ConstHere->Prev() != NULL):(_Index > 0));
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* ConstListIterator<T>::Next()
{
  if (!More())
    return NULL;

  _ConstHere = _ConstHere->Next();
  _Index++;
  return _ConstHere;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* ConstListIterator<T>::Prev()
{
  if (!Less() || !_ConstList)
    return NULL;

  if (_ConstList->NodeLinks() == 2)
  {
    _ConstHere = _ConstHere->Prev();    
    _Index--;
    return _ConstHere;
  }

  return IndexNode(_Index - 1);
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* ConstListIterator<T>::operator ++ (int)
{
  const SimpleNode<T>* RetPtr_ = _ConstHere;
  Next();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* ConstListIterator<T>::operator -- (int)
{
  const SimpleNode<T>* RetPtr_ = _ConstHere;
  Prev();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
ConstListIterator<T>& ConstListIterator<T>::Head()
{
  _ConstHere = _ConstList->Head();
  _Index = 0;
  return *this;
}

/****************************************************************************/
template <class T>
ConstListIterator<T>& ConstListIterator<T>::Tail()
{
  _ConstHere = _ConstList->Tail();
  _Index = _ConstList->Size();
  
  if (_Index)
    --_Index;
  
  return *this;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* ConstListIterator<T>::IndexNode(size_t Index_)
{
  if (Index_ < Count())
  {
    Head();
    for (size_t Count_ = 0; _ConstList && Count_ < Index_; Count_++)
      ++(*this);
  }
  else
    return NULL;

  return _ConstHere;
}

/****************************************************************************/
template <class T>
size_t ConstListIterator<T>::Count() const
{
  return _ConstList->Size();
}

/****************************************************************************/
template <class T>
size_t ConstListIterator<T>::Position() const
{
  return _Index;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(ConstListIterator)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleListIterator<T>::SimpleListIterator(SimpleList<T>* List_):
_List(List_),
_Here(List_ ? List_->Head():NULL),
_Index(0)
{}

/****************************************************************************/
template <class T>
Boolean SimpleListIterator<T>::More() const
{
  return (_Here->Next() != NULL);
}

/****************************************************************************/
template <class T>
Boolean SimpleListIterator<T>::Less() const
{
  return ((_List->NodeLinks() == 2) ? (_Here->Prev() != NULL):(_Index > 0));
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::Next()
{
  if (!More())
    return NULL;

  _Here = _Here->Next();
  _Index++;  
  return _Here;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::Prev()
{
  if (!Less() || !_List)
    return NULL;

  if (_List->NodeLinks() == 2)
  {
    _Here = _Here->Prev();
    _Index--;
    return _Here;
  }

  return IndexNode(_Index - 1);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::operator ++ (int)
{
  SimpleNode<T>* RetPtr_ = _Here;
  Next();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::operator -- (int)
{
  SimpleNode<T>* RetPtr_ = _Here;
  Prev();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
SimpleListIterator<T>& SimpleListIterator<T>::Head()
{
  _Here = _List->Head();
  _Index = 0;  
  return *this;
}

/****************************************************************************/
template <class T>
SimpleListIterator<T>& SimpleListIterator<T>::Tail()
{
  _Here = _List->Tail();
  _Index = _List->Size();
  
  if (_Index)
    --_Index;
  
  return *this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::Update(size_t Index_, T* Data_)
{
  if (Index_ < Count())
  {
    Head();
    for (size_t Count_ = 0; _List && Count_ < Index_; Count_++)
      ++(*this);      

    ::Delete(_Here->Value());
    _Here->SetValue(Data_);
  }
  else
    return NULL;
  
  return _Here;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListIterator<T>::IndexNode(size_t Index_)
{
  if (Index_ < Count())
  {
    Head();  
    for (size_t Count_ = 0; _List && Count_ < Index_; Count_++)
      ++(*this);
  }
  else
    return NULL;

  return _Here;
}

/****************************************************************************/
template <class T>
void SimpleListIterator<T>::Remove()
{
  _List->Remove(_Here);
  Head();
}

/****************************************************************************/
template <class T>
size_t SimpleListIterator<T>::Position() const
{
  return _Index;
}

/****************************************************************************/
template <class T>
size_t SimpleListIterator<T>::Count() const
{
  return _List->Size();
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleListIterator)

/****************************************************************************/
/****************************************************************************/
template <class T>
NumberedNode<T>::NumberedNode():
_Number(0),
_Object(NULL)
{}

/****************************************************************************/
template <class T>
NumberedNode<T>::NumberedNode(T* Obj_, size_t Num_):
_Number(Num_),
_Object(Obj_)
{}

/****************************************************************************/
template <class T>
NumberedNode<T>::NumberedNode(const NumberedNode& Obj_):
_Number(Obj_._Number),
_Object(Obj_._Object)
{}

/****************************************************************************/
template <class T>
NumberedNode<T>::~NumberedNode()
{
  ::Delete(_Object);
  _Object = NULL;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(NumberedNode)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleNode<T>::SimpleNode(T* Obj_, SimpleNode<T>* Next_):
_Object(Obj_),
_Next(Next_)
{}

/****************************************************************************/
template <class T>
SimpleNode<T>::SimpleNode(T* Obj_, SimpleNode<T>* Next_, size_t Num_):
_Wrapper(new WRAP(Obj_, Num_)),
_Next(Next_)
{}

/****************************************************************************/
template <class T>
SimpleNode<T>::~SimpleNode()
{
  delete _Next;
  _Next = NULL;

  ::Delete(_Object);
  _Object = NULL;
}

/****************************************************************************/
template <class T>
bool SimpleNode<T>::IsValueDestroyed() const
{
  return true;
}

/****************************************************************************/
template <class T>
bool SimpleNode<T>::IsSinglyLinked() const
{
  return true;
}

/****************************************************************************/
template <class T>
void SimpleNode<T>::Insert(SimpleNode<T>* Node_)
{
  Node_->SetNext(_Next);
  _Next = Node_;
}

/****************************************************************************/
template <class T>
T* SimpleNode<T>::Value()
{
  return _Object;
}

/****************************************************************************/
template <class T>
const T* SimpleNode<T>::Value() const
{
  return _Object;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::SetValue(T* Ptr_)
{
  _Object = Ptr_;
  return this;
}

/****************************************************************************/
template <class T>
size_t SimpleNode<T>::Number() const
{
  return 0;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::SetNumber(size_t Num_)
{
  return this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::SetNext(SimpleNode<T>* Ptr_)
{
  _Next = Ptr_;
  return this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::Next()
{
  return _Next;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleNode<T>::Next() const
{
  return _Next;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::SetPrev(SimpleNode<T>* Ptr_)
{}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::Prev()
{
  return NULL;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleNode<T>::Prev() const
{
  return NULL;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::FindHead(SimpleNode<T>* Ptr_)
{
  SimpleNode<T>* Node_ = Ptr_;
  if (Node_)
    while (Node_->Prev())
      Node_ = Node_->Prev();

  return Node_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNode<T>::FindTail(SimpleNode<T>* Ptr_)
{
  SimpleNode<T>* Node_ = Ptr_;
  if (Node_)
    while (Node_->Next())
      Node_ = Node_->Next();

  return Node_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleNode<T>::FindConstHead(const SimpleNode<T>* Ptr_)
{
  const SimpleNode<T>* Node_ = Ptr_;
  if (Node_)
    while (Node_->Next())
      Node_ = Node_->Next();

  return Node_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleNode<T>::FindConstTail(const SimpleNode<T>* Ptr_)
{
  const SimpleNode<T>* Node_ = Ptr_;
  if (Node_)
    while (Node_->Prev())
      Node_ = Node_->Prev();

  return Node_;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleNumberedNode<T>::SimpleNumberedNode(T* Obj_, size_t Num_, SimpleNode<T>* Next_):
SimpleNode<T>(Obj_, Next_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleNumberedNode<T>::~SimpleNumberedNode()
{
  // make sure value pointer is NULL since we want to keep the value memory
  delete _Wrapper;
  _Wrapper = NULL;
  _Object = NULL;

  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
T* SimpleNumberedNode<T>::Value()
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
const T* SimpleNumberedNode<T>::Value() const
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedNode<T>::SetValue(T* Ptr_)
{
  if (_Wrapper)
    _Wrapper->_Object = Ptr_;
    
  return this;
}

/****************************************************************************/
template <class T>
size_t SimpleNumberedNode<T>::Number() const
{
  return (_Wrapper ? _Wrapper->_Number:0);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedNode<T>::SetNumber(size_t Num_)
{
  if (_Wrapper)
    _Wrapper->_Number = Num_;

  return this;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleKeepNode<T>::SimpleKeepNode(T* Obj_, SimpleNode<T>* Next_, size_t Num_):
SimpleNode<T>(Obj_, Next_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleKeepNode<T>::SimpleKeepNode(T* Obj_, SimpleNode<T>* Next_):
SimpleNode<T>(Obj_, Next_)
{}

/****************************************************************************/
template <class T>
SimpleKeepNode<T>::~SimpleKeepNode()
{
  // make sure value pointer is NULL since we want to keep the value memory
  _Object = NULL;
  
  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
bool SimpleKeepNode<T>::IsValueDestroyed() const
{
  return false;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleNumberedKeepNode<T>::SimpleNumberedKeepNode(T* Obj_, size_t Num_, SimpleNode<T>* Next_):
SimpleKeepNode<T>(Obj_, Next_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleNumberedKeepNode<T>::~SimpleNumberedKeepNode()
{
  // make sure value pointer is NULL since we want to keep the value memory
  _Wrapper->_Object = NULL;
  delete _Wrapper;
  _Wrapper = NULL;
  _Object = NULL;

  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
T* SimpleNumberedKeepNode<T>::Value()
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
const T* SimpleNumberedKeepNode<T>::Value() const
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedKeepNode<T>::SetValue(T* Ptr_)
{
  if (_Wrapper)
    _Wrapper->_Object = Ptr_;
    
  return this;
}

/****************************************************************************/
template <class T>
size_t SimpleNumberedKeepNode<T>::Number() const
{
  return (_Wrapper ? _Wrapper->_Number:0);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedKeepNode<T>::SetNumber(size_t Num_)
{
  if (_Wrapper)
    _Wrapper->_Number = Num_;

  return this;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleKeepNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleNumberedKeepNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleNumberedNode)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleDblNode<T>::SimpleDblNode(T* Obj_, SimpleNode<T>* Next_,
                                SimpleNode<T>* Prev_, size_t Num_):
SimpleNode<T>(Obj_, Next_, Num_),
_Prev(Prev_)

{
  if (Next_)
    Next_->SetPrev((Next_ != this) ? this:NULL);
}

/****************************************************************************/
template <class T>
SimpleDblNode<T>::SimpleDblNode(T* Obj_, SimpleNode<T>* Next_,
                                SimpleNode<T>* Prev_):
SimpleNode<T>(Obj_, Next_),
_Prev(Prev_)
{
  if (Next_)
    Next_->SetPrev((Next_ != this) ? this:NULL);
}

/****************************************************************************/
template <class T>
SimpleDblNode<T>::~SimpleDblNode()
{
  _Prev = NULL;
  delete _Next;
  _Next = NULL;

  ::Delete(_Object);
  _Object = NULL;
}

/****************************************************************************/
template <class T>
bool SimpleDblNode<T>::IsValueDestroyed() const
{
  return true;
}

/****************************************************************************/
template <class T>
bool SimpleDblNode<T>::IsSinglyLinked() const
{
  return false;
}

/****************************************************************************/
template <class T>
void SimpleDblNode<T>::Insert(SimpleNode<T>* Node_)
{
  Node_->SetNext(_Next);
  _Next->SetPrev((_Next != Node_) ? Node_:NULL);
  _Next = Node_;
  Node_->SetPrev((Node_ != this) ? this:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleDblNode<T>::SetNext(SimpleNode<T>* Ptr_)
{
  _Next = Ptr_;
  return this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleDblNode<T>::Next()
{
  return _Next;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleDblNode<T>::Next() const
{
  return _Next;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleDblNode<T>::SetPrev(SimpleNode<T>* Ptr_)
{
  _Prev = Ptr_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleDblNode<T>::Prev()
{
  return _Prev;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleDblNode<T>::Prev() const
{
  return _Prev;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleNumberedDblNode<T>::SimpleNumberedDblNode(T* Obj_, size_t Num_,
                                                SimpleNode<T>* Next_, SimpleNode<T>* Prev_):
SimpleDblNode<T>(Obj_, Next_, Prev_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleNumberedDblNode<T>::~SimpleNumberedDblNode()
{
  delete _Wrapper;
  _Wrapper = NULL;
  _Object = NULL;

  _Prev = NULL;
  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
T* SimpleNumberedDblNode<T>::Value()
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
const T* SimpleNumberedDblNode<T>::Value() const
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedDblNode<T>::SetValue(T* Ptr_)
{
  if (_Wrapper)
    _Wrapper->_Object = Ptr_;
    
  return this;
}

/****************************************************************************/
template <class T>
size_t SimpleNumberedDblNode<T>::Number() const
{
  return (_Wrapper ? _Wrapper->_Number:0);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedDblNode<T>::SetNumber(size_t Num_)
{
  if (_Wrapper)
    _Wrapper->_Number = Num_;

  return this;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleDblKeepNode<T>::SimpleDblKeepNode(T* Obj_, SimpleNode<T>* Next_,
                                        SimpleNode<T>* Prev_, size_t Num_):
SimpleDblNode<T>(Obj_, Next_, Prev_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleDblKeepNode<T>::SimpleDblKeepNode(T* Obj_, SimpleNode<T>* Next_,
                                        SimpleNode<T>* Prev_):
SimpleDblNode<T>(Obj_, Next_, Prev_)
{}

/****************************************************************************/
template <class T>
SimpleDblKeepNode<T>::~SimpleDblKeepNode()
{
  // make sure value pointer is NULL since we want to keep the value memory
  _Object = NULL;

  _Prev = NULL;
  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
bool SimpleDblKeepNode<T>::IsValueDestroyed() const
{
  return false;
}

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleNumberedDblKeepNode<T>::SimpleNumberedDblKeepNode(T* Obj_, size_t Num_,
                                                        SimpleNode<T>* Next_, SimpleNode<T>* Prev_):
SimpleDblKeepNode<T>(Obj_, Next_, Prev_, Num_)
{}

/****************************************************************************/
template <class T>
SimpleNumberedDblKeepNode<T>::~SimpleNumberedDblKeepNode()
{
  _Wrapper->_Object = NULL;
  delete _Wrapper;
  _Wrapper = NULL;
  _Object = NULL;

  _Prev = NULL;
  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
template <class T>
T* SimpleNumberedDblKeepNode<T>::Value()
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
const T* SimpleNumberedDblKeepNode<T>::Value() const
{
  return (_Wrapper ? _Wrapper->_Object:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedDblKeepNode<T>::SetValue(T* Ptr_)
{
  if (_Wrapper)
    _Wrapper->_Object = Ptr_;
    
  return this;
}

/****************************************************************************/
template <class T>
size_t SimpleNumberedDblKeepNode<T>::Number() const
{
  return (_Wrapper ? _Wrapper->_Number:0);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleNumberedDblKeepNode<T>::SetNumber(size_t Num_)
{
  if (_Wrapper)
    _Wrapper->_Number = Num_;

  return this;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleDblKeepNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleDblNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleNumberedDblKeepNode)
MEMORYOPS_TEMPLATE_DEFN(SimpleNumberedDblNode)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleList<T>::SimpleList(ObjectCloner<T>* ClonerPtr_,
                          size_t NodeLinks_, bool KeepValue_,
                          int CopyValue_, bool SaveOps_,
                          bool Numbered_):
_Cloner(ClonerPtr_ ? ClonerPtr_:RealCloner<T>::Make()),
_NodeLinks(NodeLinks_),
_Count(0),
_KeepValue(KeepValue_),
_SaveOps(SaveOps_),
_Numbered(Numbered_),
_CopyValue(CopyValue_),
_ListOps(NULL),
_List(NULL),
_Tail(NULL)
{
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleList<T>::SimpleList(const SimpleNode<T>* NodePtr_, ObjectCloner<T>* ClonerPtr_,
                          size_t NodeLinks_, bool KeepValue_,
                          int CopyValue_, bool SaveOps_,
                          bool Numbered_):
_Cloner(ClonerPtr_ ? ClonerPtr_:RealCloner<T>::Make()),
_NodeLinks(NodeLinks_),
_Count(0),
_KeepValue(KeepValue_),
_SaveOps(SaveOps_),
_Numbered(Numbered_),
_CopyValue(CopyValue_),
_ListOps(NULL),
_ConstList(NodePtr_),
_ConstTail(SimpleNode<T>::FindConstTail(NodePtr_))
{
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleList<T>::SimpleList(const SimpleList<T>& Alist_, bool SaveOps_, bool Numbered_):
_Cloner(Alist_._Cloner->Clone()),
_NodeLinks(Alist_._NodeLinks),
_Count(0),
_KeepValue(Alist_._KeepValue),
_SaveOps(SaveOps_),
_Numbered(Numbered_),
_CopyValue(Alist_._CopyValue),
_ListOps(NULL),
_List(NULL),
_Tail(NULL)
{
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this, Alist_);

  for (SimpleNode<T>* Node_ = Alist_._List; Node_ != NULL; Node_ = Node_->Next())
    if (_CopyValue > 0 || (_CopyValue == -1 && !_KeepValue))
      AppendTail(Node_->Value() ? _Cloner->Duplicate(*Node_->Value()):NULL);
    else
      AppendTail(Node_->Value());
}

/****************************************************************************/
template <class T>
SimpleList<T>::SimpleList(const SimpleList<T>& Alist_):
_Cloner(Alist_._Cloner->Clone()),
_NodeLinks(Alist_._NodeLinks),
_Count(0),
_KeepValue(Alist_._KeepValue),
_SaveOps(Alist_._SaveOps),
_Numbered(Alist_._Numbered),
_CopyValue(Alist_._CopyValue),
_ListOps(NULL),
_List(NULL),
_Tail(NULL)
{
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this, Alist_);

  for (SimpleNode<T>* Node_ = Alist_._List; Node_ != NULL; Node_ = Node_->Next())
    if (_CopyValue > 0 || (_CopyValue == -1 && !_KeepValue))
      AppendTail(Node_->Value() ? _Cloner->Duplicate(*Node_->Value()):NULL);
    else
      AppendTail(Node_->Value());
}

/****************************************************************************/
template <class T>
SimpleList<T>::~SimpleList()
{
  delete _List;
  _Tail = _List = NULL;

  delete _Cloner;
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::SetCloner(ObjectCloner<T>* Cloner_)
{
  delete _Cloner;
  _Cloner = Cloner_;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::SetCopyValue(int Flag_)
{
  _CopyValue = Flag_;
  return *this;
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::SetKeepValue(bool Flag_)
{
  _KeepValue = Flag_;
  return *this;
}

/****************************************************************************/
template <class T>
void SimpleList<T>::SetNumberedList(bool Flag_)
{
  if (_Count == 0)
    _Numbered = Flag_;

  if (_ListOps)
    _ListOps->SetNumberedList(Flag_);
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::operator = (const SimpleList<T>& Alist_)
{
  if (this != &Alist_)
  {  
    delete _List;
    _Tail = _List = NULL;
    _Count = 0;

    for (SimpleNode<T>* Node_ = Alist_._List; Node_ != NULL; Node_ = Node_->Next())
      if (_CopyValue > 0 || (_CopyValue == -1 && !_KeepValue))
        AppendTail(Node_->Value() ? _Cloner->Duplicate(*Node_->Value()):NULL);
      else
        AppendTail(Node_->Value());
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::operator += (const SimpleList<T>& Alist_)
{
  if (this != &Alist_)
    for (SimpleNode<T>* Node_ = Alist_._List; Node_ != NULL; Node_ = Node_->Next())
      if (_CopyValue > 0 || (_CopyValue == -1 && !_KeepValue))
        AppendTail(Node_->Value() ? _Cloner->Duplicate(*Node_->Value()):NULL);
      else
        AppendTail(Node_->Value());

  return *this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleList<T>::Tail()
{
  if (_List)
    if (_Tail)
      return _Tail;
    else
    {
      SimpleNode<T>* Node_ = _List;
      
      if (Node_)
        while (Node_->Next())
          Node_ = Node_->Next();

      _Tail = Node_;
      return Node_;
    }

  return _List;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleList<T>::Tail() const
{
  if (_List)
    if (_Tail)
      return _Tail;
    else
    {
      SimpleNode<T>* Node_ = _List;

      if (Node_)
        while (Node_->Next())
          Node_ = Node_->Next();
        
      _Tail = Node_;
      return Node_;
    }

  return _List;
}

/****************************************************************************/
template <class T>
void SimpleList<T>::ReNumberList()
{
  int x;
  SimpleNode<T>* Node_ = _List;

  if (_Numbered)
    for (x = 0; Node_; x++)
    {
      Node_->SetNumber(x);
      Node_ = Node_->Next();
    }
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleList<T>::FindPrevious(SimpleNode<T>* Ptr_)
{
  SimpleNode<T>* Node_ = _List;

  if (Ptr_ == Node_)
    return NULL;

  if (Ptr_)
  {
    if (Ptr_->IsSinglyLinked())
    {
      while (Node_ && Ptr_ != Node_->Next())
        Node_ = Node_->Next();
    }
    else
      Node_ = Ptr_->Prev();
  }

  return ((Ptr_ && Node_) ? Node_:NULL);
}

/****************************************************************************/
// DeleteValue_ argument valid values:
//   0  : Keep node value pointer memory address (Don't delete)
//   -1 : Delete according to _KeepValue data member
//   1  : Delete node value pointer
//
template <class T>
T* SimpleList<T>::Remove(SimpleNode<T>* Ptr_, int DeleteValue_)
{
  T* ValuePtr_ = NULL;

  if (Ptr_ == _List)
  {
    ValuePtr_ = PopNode();
    
    if ((DeleteValue_ == -1 && !_KeepValue) || DeleteValue_ > 0)
      ::Delete(ValuePtr_);
    else
      return ValuePtr_;
  }
  else if (Ptr_ == _Tail)
  {
    ValuePtr_ = PopTailNode();
    
    if ((DeleteValue_ == -1 && !_KeepValue) || DeleteValue_ > 0)
      ::Delete(ValuePtr_);
    else
      return ValuePtr_;
  }
  else
  {
    size_t NodeNum_ = 0;
    SimpleNode<T>* Node_ = Ptr_ ? FindPrevious(Ptr_):NULL;

    if (Node_ && Ptr_)
    {
      Node_->SetNext(Ptr_->Next());
      Ptr_->SetNext(NULL);

      if (!Ptr_->IsSinglyLinked())
      {
        Ptr_->SetPrev(NULL);
        if (Node_->Next() && Node_->Next() != Node_)
          Node_->Next()->SetPrev(Node_);
      }

      ValuePtr_ = Ptr_->Value();
      if (IsNumbered())
        NodeNum_ = Ptr_->Number();
      
      Ptr_->SetValue(NULL);
      delete Ptr_;
      --_Count;

      if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
      {
        if (_ListOps)
          _ListOps->StoreOpToList(DETACH, NodeNum_);

        if (IsNumbered())
          ReNumberList();
      }
      
      if ((DeleteValue_ == -1 && !_KeepValue) || DeleteValue_ > 0)
        ::Delete(ValuePtr_);
      else
        return ValuePtr_;
    }
  }

  return NULL;
}

/****************************************************************************/
template <class T>
void SimpleList<T>::InsertAfter(SimpleNode<T>* Ptr_, T* NewPtr_)
{
  if (Ptr_)
  {
    SimpleNode<T>* NewNode_;
        
    if (_KeepValue)
    {
      if (_NodeLinks == 2)
      {
        if (_Numbered)
          NewNode_ = new SimpleNumberedDblKeepNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_, _Count);
        else
          NewNode_ = new SimpleDblKeepNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_);
      }
      else
      {
        if (_Numbered)
          NewNode_ = new SimpleNumberedKeepNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_, _Count);
        else
          NewNode_ = new SimpleKeepNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_);
      }
    }
    else
    {
      if (_Numbered)
        NewNode_ =
        ((_NodeLinks == 2) ? (SimpleNode<T>*)(new SimpleNumberedDblNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_, _Count)):
                             (SimpleNode<T>*)(new SimpleNumberedNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_, _Count)));
      else
        NewNode_ =
        ((_NodeLinks == 2) ? (new SimpleDblNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_)):
                             (new SimpleNode<T>((_CopyValue > 0 && NewPtr_) ? _Cloner->Duplicate(*NewPtr_):NewPtr_)));
    }

    if (NewNode_)
    {
      size_t NodeNum_ = _Count;
      Ptr_->Insert(NewNode_);
      ++_Count;

      if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
      {
        if (_ListOps)
          _ListOps->StoreOpToList(INSERT, NodeNum_);

        if (IsNumbered())
          ReNumberList();
      }

      if (_Tail == Ptr_)
        _Tail = NewNode_;
    }
  }
}

/****************************************************************************/
template <class T>
void SimpleList<T>::InsertBefore(SimpleNode<T>* Ptr_, T* NewPtr_)
{
  if (Ptr_ == _List)
    AppendHead(NewPtr_);
  else
  {
    SimpleNode<T>* Node_ = FindPrevious(Ptr_);
    
    if (Node_)
      InsertAfter(Node_, NewPtr_);
    else
      AppendHead(NewPtr_);
  }
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::AppendHead(T* Obj_)
{
  bool NoTail_ = !_Tail || _Tail == _List;

  if (_KeepValue)
  {
    if (_NodeLinks == 2)
    {
      if (_Numbered)
        _List = new SimpleNumberedDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List);
      else
        _List = new SimpleDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List);
    }
    else
    {
      if (_Numbered)
        _List = new SimpleNumberedKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List);
      else
        _List = new SimpleKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List);
    }
  }
  else
  {
    if (_Numbered)
      _List =
      ((_NodeLinks == 2) ? (SimpleNode<T>*)(new SimpleNumberedDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List)):
                           (SimpleNode<T>*)(new SimpleNumberedNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List)));
    else
      _List =
      ((_NodeLinks == 2) ? (new SimpleDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List)):
                           (new SimpleNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List)));
  }

  if (_List)
  {
    size_t NodeNum_ = _Count;
    ++_Count;

    if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
    {
      if (_ListOps)
        _ListOps->StoreOpToList(INSERT, NodeNum_);

      if (IsNumbered())
        ReNumberList();
    }
  }

  if (NoTail_)
    _Tail = (_List->Next()) ? _List->Next():_List;

  return *this;
}

/****************************************************************************/
template <class T>
SimpleList<T>& SimpleList<T>::AppendTail(T* Obj_)
{
  SimpleNode<T>* Node_ = _List;

  if (Obj_)
    if (_List)
    {
      if (!_Tail)
      {
        while (Node_->Next())
          Node_ = Node_->Next();

        _Tail = Node_;
      }

      SimpleNode<T>* Node_;
      
      if (_KeepValue)
      {
        if (_NodeLinks == 2)
        {
          if (_Numbered)
            Node_ = new SimpleNumberedDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _Tail->Next());
          else
            Node_ = new SimpleDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Tail->Next());
        }
        else
        {
          if (_Numbered)
            Node_ = new SimpleNumberedKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _Tail->Next());
          else
            Node_ = new SimpleKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Tail->Next());
        }
      }
      else
      {
        if (_Numbered)
          Node_ =
          ((_NodeLinks == 2) ? (SimpleNode<T>*)(new SimpleNumberedDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _Tail->Next())):
                               (SimpleNode<T>*)(new SimpleNumberedNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _Tail->Next())));
        else
          Node_ =
          ((_NodeLinks == 2) ? (new SimpleDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Tail->Next())):
                               (new SimpleNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Tail->Next())));
      }

      _Tail->SetNext(Node_);
      
      if (_Tail->Next())
      {
        size_t NodeNum_ = _Count;
        ++_Count;

        if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
        {
          if (_ListOps)
            _ListOps->StoreOpToList(INSERT, NodeNum_);

          if (IsNumbered())
            ReNumberList();
        }

        Node_ = _Tail;
        _Tail = _Tail->Next();

        if (_Tail && _NodeLinks == 2)
          _Tail->SetPrev(Node_);
      }
    }
    else
    {
      if (_KeepValue)
      {
        if (_NodeLinks == 2)
        {
          if (_Numbered)
            _List = new SimpleNumberedDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List);
          else
            _List = new SimpleDblKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List);
        }
        else
        {
          if (_Numbered)
            _List = new SimpleNumberedKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List);
          else
            _List = new SimpleKeepNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List);
        }
      }
      else
      {
        if (_Numbered)
          _List =
          ((_NodeLinks == 2) ? (SimpleNode<T>*)(new SimpleNumberedDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List)):
                               (SimpleNode<T>*)(new SimpleNumberedNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _Count, _List)));
        else
          _List =
          ((_NodeLinks == 2) ? (new SimpleDblNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List)):
                               (new SimpleNode<T>((_CopyValue > 0 && Obj_) ? _Cloner->Duplicate(*Obj_):Obj_, _List)));
      }

      if (_List)
      {
        size_t NodeNum_ = _Count;
        ++_Count;

        if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
        {
          if (_ListOps)
            _ListOps->StoreOpToList(INSERT, NodeNum_);

          if (IsNumbered())
            ReNumberList();
        }
        
        _Tail = _List;
      }
    }

  return *this;
}

/****************************************************************************/
template <class T>
T* SimpleList<T>::PopNode()
{
  size_t NodeNum_ = 0;  
  SimpleNode<T>* Node_ = _List;
  bool NoTail_ = !_Tail || _Tail == _List;

  if (Node_ == NULL)
    return NULL;

  T* Object_ = Node_->Value();
  if (IsNumbered() && Object_)
    NodeNum_ = Node_->Number();
  
  Node_->SetValue(NULL);                // So node won't try to delete it
  _List = Node_->Next();
  if (NoTail_)
    _Tail = _List;                      // If no tail or tail == list
  if (_List)
    _List->SetPrev(NULL);               // In cases of doubly linked lists
  Node_->SetNext(NULL);                 // So it won't delete the list

  delete Node_;
  --_Count;

  if (NoTail_)
    _List = _Tail = NULL;

  if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(DETACH, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }

  return Object_;
}

/****************************************************************************/
template <class T>
T* SimpleList<T>::PopTailNode()
{
  size_t NodeNum_ = 0;
  SimpleNode<T>* Node_ = _Tail;
  bool NoTail_ = _Tail == _List;

  if (Node_ == NULL)
    return NULL;

  T* Object_ = Node_->Value();
  if (IsNumbered() && Object_)
    NodeNum_ = Node_->Number();
  
  Node_->SetValue(NULL);                // So node won't try to delete it
  if (!NoTail_)  
    _Tail = FindPrevious(Node_);    
  if (_Tail)
    _Tail->SetNext(NULL);               // In cases of doubly linked lists
  Node_->SetPrev(NULL);                 // So it won't delete the list

  delete Node_;
  --_Count;

  if (NoTail_)
    _List = _Tail = NULL;

  if (IsLinkedList() && !IsStack() && !IsQueue() && !IsDeque())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(DETACH, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }

  return Object_;
}

/****************************************************************************/
template <class T>
void SimpleList<T>::SetSaveOps(bool SaveOps_)
{
  _SaveOps = SaveOps_;

  if (SaveOps_ && !_ListOps)
    _ListOps = new ListOperationImpl;
  else if (!SaveOps_ && _ListOps)
  {
    delete _ListOps;
    _ListOps = NULL;
  }
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::OpsListLimit() const
{
  return (_ListOps ? _ListOps->OpsListLimit():0);
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::OpsListIndex() const
{
  return (_ListOps ? _ListOps->OpsListIndex():0);
}

/****************************************************************************/
template <class T>
void SimpleList<T>::DumpListData(int(*dispfn)(const void*, int), ostream* osp_)
{
  int x;
  size_t num_;
  SimpleNode<T>* Node_ = _List;
  const char* str_ = "value:";
  bool dispovdone = false;
  bool dispnvdone = false;

  if (dispfn)
    (*dispfn)(str_, -1);
  else if (osp_)
    *osp_ <<"value:";
  
  for (x = 0; Node_; x++)
  {
    if (dispfn)
      (*dispfn)(Node_->Value(), x);
    else if (osp_)
    {
      if (Node_->Value())
      {
        if (x && dispovdone)
          *osp_ <<",";

        #if SIMPLELIST_LISTDUMP
          *osp_ <<(*Node_->Value());
        #endif
        dispovdone = true;
      }
      else
      {
        if (x && dispovdone)
          *osp_ <<",";
          
        *osp_ <<"-";
        dispovdone = true;
      }
    }

    Node_ = Node_->Next();
  }

  str_ = "\n";
  if (dispfn)
    (*dispfn)(str_, -1);
  else if (osp_)
    *osp_ <<str_;

  if (IsNumbered())
  {
    Node_ = _List;
    str_ = "number:";

    if (dispfn)
      (*dispfn)(str_, -1);
    else if (osp_)
      *osp_ <<"number:";

    for (x = 0; Node_; x++)
    {
      if (dispfn)
      {
        num_ = Node_->Number();
        (*dispfn)((const void*)&num_, x);
      }
      else if (osp_)
      {
        if (x && dispnvdone)
          *osp_ <<",";

        *osp_ <<Node_->Number();
        dispnvdone = true;
      }

      Node_ = Node_->Next();
    }

    str_ = "\n";
    if (dispfn)
      (*dispfn)(str_, -1);
    else if (osp_)
      *osp_ <<str_;
  }
}

/****************************************************************************/
template <class T>
void SimpleList<T>::DumpVectorData(ostream* osp_)
{
  if (_ListOps)
    _ListOps->DumpVectorData(osp_);
}

/****************************************************************************/
template <class T>
void SimpleList<T>::StoreOpToList(int OpType_, size_t NodeNum_)
{
  if (_ListOps)
    _ListOps->StoreOpToList(OpType_, NodeNum_);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::LastOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::FirstOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::OpAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->OpAt(Index_):0);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::LastNodeNum() const
{
  return (_ListOps ? _ListOps->LastNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::FirstNodeNum() const
{
  return (_ListOps ? _ListOps->FirstNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleList<T>::NodeNumAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->NodeNumAt(Index_):0);
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::TotalOps() const
{
  return (_ListOps ? _ListOps->TotalOps():0);
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::IsDetached() const
{
  return (_ListOps ? _ListOps->IsDetached():false);
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::IsInserted() const
{
  return (_ListOps ? _ListOps->IsInserted():false);
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::TimesDetached() const
{
  return (_ListOps ? _ListOps->TimesDetached():0);
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::TimesInserted() const
{
  return (_ListOps ? _ListOps->TimesInserted():0);
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::IsNumbered() const
{
  return (_ListOps ? _ListOps->IsNumbered():_Numbered);
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::IsLinkedList() const
{
  return true;
}

/****************************************************************************/
template <class T>
void SimpleList<T>::DeleteAll()
{
  delete _List;
  _List = _Tail = NULL;
  _Count = 0;

  if (_ListOps)
    _ListOps->DeleteAll();
}

/****************************************************************************/
template <class T>
void SimpleList<T>::DeleteAllAndData(int DeleteValue_)
{
  if (_KeepValue)
  {
    T* Object_;
    
    while (_Count > 0)
    {
      Object_ = PopNode();
      
      if (DeleteValue_ > 0)
        ::Delete(Object_);
    }
  }
  else
    DeleteAll();
}

/****************************************************************************/
template <class T>
Boolean SimpleList<T>::Empty(void) const
{
  return (_List == NULL);
}

/****************************************************************************/
template <class T>
size_t SimpleList<T>::Size(void) const
{
  return _Count;
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::HasThis(const T* Obj_, PtrCompare<T>* Compare_) const
{
  const SimpleNode<T>* Node_ = _ConstList;

  if (Compare_ && Obj_)
  {
    while (Node_)
    {
      if ((*Compare_)(Obj_, Node_->Value()))
        return true;
      else
        Node_ = Node_->Next();
    }
  }
  else
  {
    while (Node_)
    {
      if (Node_->Value() == Obj_)
        return true;
      else
        Node_ = Node_->Next();
    }
  }

  return false;
}

/****************************************************************************/
template <class T>
bool SimpleList<T>::HasThis(const T* Obj_, PtrCompare<T>* Compare_,
                            SimpleNode<T>** LocPtr_)
{
  SimpleNode<T>* Node_ = _List;

  if (Compare_ && Obj_)
  {
    while (Node_)
    {
      if ((*Compare_)(Obj_, Node_->Value()))
      {
        if (LocPtr_)
          *LocPtr_ = Node_;
          
        return true;
      }
      else
        Node_ = Node_->Next();
    }
  }
  else
  {
    while (Node_)
    {
      if (Node_->Value() == Obj_)
      {
        if (LocPtr_)
          *LocPtr_ = Node_;
        
        return true;
      }
      else
        Node_ = Node_->Next();
    }
  }

  return false;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleList)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleStack<T>::SimpleStack(const SimpleNode<T>* NodePtr_, ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(NodePtr_, ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleStack<T>::SimpleStack(ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleStack<T>::SimpleStack(const SimpleStack<T>& List_):
SimpleList<T>(List_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this, List_);
}

/****************************************************************************/
template <class T>
SimpleStack<T>::~SimpleStack()
{}

/****************************************************************************/
template <class T>
SimpleStack<T>& SimpleStack<T>::operator = (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator = (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
SimpleStack<T>& SimpleStack<T>::operator += (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator += (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
T* SimpleStack<T>::Pop()
{
  size_t NodeNum_ = 0;
  T* Data_ = NULL;
  
  if (Size() > 0)
  {
    SimpleNode<T>* Ptr_ = Head();
    if (IsNumbered() && Ptr_)
      NodeNum_ = Ptr_->Number();

    if (Ptr_)
      Data_ = Remove(Ptr_);

    if (IsStack())
    {
      if (_ListOps)
        _ListOps->StoreOpToList(POP, NodeNum_);

      if (IsNumbered())
        ReNumberList();
    }
  }
  
  return Data_;
}

/****************************************************************************/
template <class T>
SimpleStack<T>& SimpleStack<T>::Push(T* NewPtr_)
{
  size_t NodeNum_ = 0;
  AppendHead(NewPtr_);

  if (IsNumbered())
  {
    SimpleNode<T>* Ptr_ = Head();
    if (Ptr_)
      NodeNum_ = Ptr_->Number();
  }

  if (IsStack())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(PUSH, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }
}

/****************************************************************************/
template <class T>
void SimpleStack<T>::SetSaveOps(bool SaveOps_)
{
  _SaveOps = SaveOps_;

  if (SaveOps_ && !_ListOps)
    _ListOps = new StackOperationImpl;
  else if (!SaveOps_ && _ListOps)
  {
    delete _ListOps;
    _ListOps = NULL;
  }
}

/****************************************************************************/
template <class T>
size_t SimpleStack<T>::OpsListLimit() const
{
  return (_ListOps ? _ListOps->OpsListLimit():0);
}

/****************************************************************************/
template <class T>
size_t SimpleStack<T>::OpsListIndex() const
{
  return (_ListOps ? _ListOps->OpsListIndex():0);
}

/****************************************************************************/
template <class T>
void SimpleStack<T>::StoreOpToList(int OpType_, size_t NodeNum_)
{
  if (_ListOps)
    _ListOps->StoreOpToList(OpType_, NodeNum_);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::LastOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::FirstOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::OpAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->OpAt(Index_):0);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::LastNodeNum() const
{
  return (_ListOps ? _ListOps->LastNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::FirstNodeNum() const
{
  return (_ListOps ? _ListOps->FirstNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleStack<T>::NodeNumAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->NodeNumAt(Index_):0);
}

/****************************************************************************/
template <class T>
size_t SimpleStack<T>::TotalOps() const
{
  return (_ListOps ? _ListOps->TotalOps():0);
}

/****************************************************************************/
template <class T>
bool SimpleStack<T>::IsPopped() const
{
  return (_ListOps ? _ListOps->IsPopped():false);
}

/****************************************************************************/
template <class T>
bool SimpleStack<T>::IsPushed() const
{
  return (_ListOps ? _ListOps->IsPushed():false);
}

/****************************************************************************/
template <class T>
size_t SimpleStack<T>::TimesPopped() const
{
  return (_ListOps ? _ListOps->TimesPopped():0);
}

/****************************************************************************/
template <class T>
size_t SimpleStack<T>::TimesPushed() const
{
  return (_ListOps ? _ListOps->TimesPushed():0);
}

/****************************************************************************/
template <class T>
bool SimpleStack<T>::IsStack() const
{
  return true;
}

/****************************************************************************/
template <class T>
void SimpleStack<T>::DeleteAll()
{
  delete _List;
  _List = _Tail = NULL;
  _Count = 0;

  if (_ListOps)
    _ListOps->DeleteAll();
}

/****************************************************************************/
template <class T>
void SimpleStack<T>::DeleteAllAndData(int DeleteValue_)
{
  if (_KeepValue)
  {
    T* Object_;
    
    while (_Count > 0)
    {
      Object_ = PopNode();
      
      if (DeleteValue_ > 0)
        ::Delete(Object_);
    }
  }
  else
    DeleteAll();
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleStack)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleQueue<T>::SimpleQueue(const SimpleNode<T>* NodePtr_, ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(NodePtr_, ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleQueue<T>::SimpleQueue(ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleQueue<T>::SimpleQueue(const SimpleQueue<T>& List_):
SimpleList<T>(List_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this, List_);
}

/****************************************************************************/
template <class T>
SimpleQueue<T>::~SimpleQueue()
{}

/****************************************************************************/
template <class T>
SimpleQueue<T>& SimpleQueue<T>::operator = (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator = (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
SimpleQueue<T>& SimpleQueue<T>::operator += (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator += (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
T* SimpleQueue<T>::Dequeue()
{
  size_t NodeNum_ = 0;
  T* Data_ = NULL;

  if (Size() > 0)
  {
    SimpleNode<T>* Ptr_ = Tail();
    if (IsNumbered() && Ptr_)
      NodeNum_ = Ptr_->Number();

    if (Ptr_)
      Data_ = Remove(Ptr_);

    if (IsQueue())
    {
      if (_ListOps)
        _ListOps->StoreOpToList(DEQUEUE, NodeNum_);

      if (IsNumbered())
        ReNumberList();
    }
  }
  
  return Data_;
}

/****************************************************************************/
template <class T>
SimpleQueue<T>& SimpleQueue<T>::Enqueue(T* NewPtr_)
{
  size_t NodeNum_ = 0;
  AppendHead(NewPtr_);

  if (IsNumbered())
  {
    SimpleNode<T>* Ptr_ = Head();
    if (Ptr_)
      NodeNum_ = Ptr_->Number();
  }

  if (IsQueue())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(ENQUEUE, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }
}

/****************************************************************************/
template <class T>
void SimpleQueue<T>::SetSaveOps(bool SaveOps_)
{
  _SaveOps = SaveOps_;

  if (SaveOps_ && !_ListOps)
    _ListOps = new QueueOperationImpl;
  else if (!SaveOps_ && _ListOps)
  {
    delete _ListOps;
    _ListOps = NULL;
  }
}

/****************************************************************************/
template <class T>
size_t SimpleQueue<T>::OpsListLimit() const
{
  return (_ListOps ? _ListOps->OpsListLimit():0);
}

/****************************************************************************/
template <class T>
size_t SimpleQueue<T>::OpsListIndex() const
{
  return (_ListOps ? _ListOps->OpsListIndex():0);
}

/****************************************************************************/
template <class T>
void SimpleQueue<T>::StoreOpToList(int OpType_, size_t NodeNum_)
{
  if (_ListOps)
    _ListOps->StoreOpToList(OpType_, NodeNum_);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::LastOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::FirstOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::OpAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->OpAt(Index_):0);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::LastNodeNum() const
{
  return (_ListOps ? _ListOps->LastNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::FirstNodeNum() const
{
  return (_ListOps ? _ListOps->FirstNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleQueue<T>::NodeNumAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->NodeNumAt(Index_):0);
}

/****************************************************************************/
template <class T>
size_t SimpleQueue<T>::TotalOps() const
{
  return (_ListOps ? _ListOps->TotalOps():0);
}

/****************************************************************************/
template <class T>
bool SimpleQueue<T>::IsDequeued() const
{
  return (_ListOps ? _ListOps->IsDequeued():false);
}

/****************************************************************************/
template <class T>
bool SimpleQueue<T>::IsEnqueued() const
{
  return (_ListOps ? _ListOps->IsEnqueued():false);
}

/****************************************************************************/
template <class T>
size_t SimpleQueue<T>::TimesDequeued() const
{
  return (_ListOps ? _ListOps->TimesDequeued():0);
}

/****************************************************************************/
template <class T>
size_t SimpleQueue<T>::TimesEnqueued() const
{
  return (_ListOps ? _ListOps->TimesEnqueued():0);
}

/****************************************************************************/
template <class T>
bool SimpleQueue<T>::IsQueue() const
{
  return true;
}

/****************************************************************************/
template <class T>
void SimpleQueue<T>::DeleteAll()
{
  delete _List;
  _List = _Tail = NULL;
  _Count = 0;

  if (_ListOps)
    _ListOps->DeleteAll();
}

/****************************************************************************/
template <class T>
void SimpleQueue<T>::DeleteAllAndData(int DeleteValue_)
{
  if (_KeepValue)
  {
    T* Object_;
    
    while (_Count > 0)
    {
      Object_ = PopNode();
      
      if (DeleteValue_ > 0)
        ::Delete(Object_);
    }
  }
  else
    DeleteAll();
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleQueue)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleDeque<T>::SimpleDeque(const SimpleNode<T>* NodePtr_, ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(NodePtr_, ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleDeque<T>::SimpleDeque(ObjectCloner<T>* ClonerPtr_,
                            size_t NodeLinks_, bool KeepValue_,
                            int CopyValue_, bool SaveOps_):
SimpleList<T>(ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this);
}

/****************************************************************************/
template <class T>
SimpleDeque<T>::SimpleDeque(const SimpleDeque<T>& List_):
SimpleList<T>(List_, false)
{
  _SaveOps = SaveOps_;
  if (_SaveOps)
    _ListOps = ListOperation::MakeListOpsImpl(this, List_);
}

/****************************************************************************/
template <class T>
SimpleDeque<T>::~SimpleDeque()
{}

/****************************************************************************/
template <class T>
SimpleDeque<T>& SimpleDeque<T>::operator = (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator = (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
SimpleDeque<T>& SimpleDeque<T>::operator += (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator += (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
T* SimpleDeque<T>::Dequeue()
{
  size_t NodeNum_ = 0;
  T* Data_ = NULL;

  if (Size() > 0)
  {
    SimpleNode<T>* Ptr_ = Tail();
    if (IsNumbered() && Ptr_)
      NodeNum_ = Ptr_->Number();

    if (Ptr_)
      Data_ = Remove(Ptr_);

    if (IsDeque())
    {
      if (_ListOps)
        _ListOps->StoreOpToList(DEQUEUE, NodeNum_);

      if (IsNumbered())
        ReNumberList();
    }
  }
  
  return Data_;
}

/****************************************************************************/
template <class T>
SimpleDeque<T>& SimpleDeque<T>::Enqueue(T* NewPtr_)
{
  size_t NodeNum_ = 0;
  AppendHead(NewPtr_);

  if (IsNumbered())
  {
    SimpleNode<T>* Ptr_ = Head();
    if (Ptr_)
      NodeNum_ = Ptr_->Number();
  }

  if (IsDeque())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(ENQUEUE, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }
}

/****************************************************************************/
template <class T>
T* SimpleDeque<T>::Pop()
{
  size_t NodeNum_ = 0;
  T* Data_ = NULL;
  
  if (Size() > 0)
  {
    SimpleNode<T>* Ptr_ = Head();
    if (IsNumbered() && Ptr_)
      NodeNum_ = Ptr_->Number();

    if (Ptr_)
      Data_ = Remove(Ptr_);

    if (IsDeque())
    {
      if (_ListOps)
        _ListOps->StoreOpToList(POP, NodeNum_);

      if (IsNumbered())
        ReNumberList();
    }
  }
  
  return Data_;
}

/****************************************************************************/
template <class T>
SimpleDeque<T>& SimpleDeque<T>::Push(T* NewPtr_)
{
  size_t NodeNum_ = 0;
  AppendHead(NewPtr_);

  if (IsNumbered())
  {
    SimpleNode<T>* Ptr_ = Head();
    if (Ptr_)
      NodeNum_ = Ptr_->Number();
  }

  if (IsDeque())
  {
    if (_ListOps)
      _ListOps->StoreOpToList(PUSH, NodeNum_);

    if (IsNumbered())
      ReNumberList();
  }
}

/****************************************************************************/
template <class T>
void SimpleDeque<T>::SetSaveOps(bool SaveOps_)
{
  _SaveOps = SaveOps_;

  if (SaveOps_ && !_ListOps)
    _ListOps = new DequeOperationImpl;
  else if (!SaveOps_ && _ListOps)
  {
    delete _ListOps;
    _ListOps = NULL;
  }
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::OpsListLimit() const
{
  return (_ListOps ? _ListOps->OpsListLimit():0);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::OpsListIndex() const
{
  return (_ListOps ? _ListOps->OpsListIndex():0);
}

/****************************************************************************/
template <class T>
void SimpleDeque<T>::StoreOpToList(int OpType_, size_t NodeNum_)
{
  if (_ListOps)
    _ListOps->StoreOpToList(OpType_, NodeNum_);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::LastOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::FirstOp() const
{
  return (_ListOps ? _ListOps->LastOp():0);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::OpAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->OpAt(Index_):0);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::LastNodeNum() const
{
  return (_ListOps ? _ListOps->LastNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::FirstNodeNum() const
{
  return (_ListOps ? _ListOps->FirstNodeNum():0);
}

/****************************************************************************/
template <class T>
int SimpleDeque<T>::NodeNumAt(size_t Index_) const
{
  return (_ListOps ? _ListOps->NodeNumAt(Index_):0);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::TotalOps() const
{
  return (_ListOps ? _ListOps->TotalOps():0);
}

/****************************************************************************/
template <class T>
bool SimpleDeque<T>::IsDequeued() const
{
  return (_ListOps ? _ListOps->IsDequeued():false);
}

/****************************************************************************/
template <class T>
bool SimpleDeque<T>::IsEnqueued() const
{
  return (_ListOps ? _ListOps->IsEnqueued():false);
}

/****************************************************************************/
template <class T>
bool SimpleDeque<T>::IsPopped() const
{
  return (_ListOps ? _ListOps->IsPopped():false);
}

/****************************************************************************/
template <class T>
bool SimpleDeque<T>::IsPushed() const
{
  return (_ListOps ? _ListOps->IsPushed():false);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::TimesDequeued() const
{
  return (_ListOps ? _ListOps->TimesDequeued():0);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::TimesEnqueued() const
{
  return (_ListOps ? _ListOps->TimesEnqueued():0);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::TimesPopped() const
{
  return (_ListOps ? _ListOps->TimesPopped():0);
}

/****************************************************************************/
template <class T>
size_t SimpleDeque<T>::TimesPushed() const
{
  return (_ListOps ? _ListOps->TimesPushed():0);
}

/****************************************************************************/
template <class T>
bool SimpleDeque<T>::IsDeque() const
{
  return true;
}

/****************************************************************************/
template <class T>
void SimpleDeque<T>::DeleteAll()
{
  delete _List;
  _List = _Tail = NULL;
  _Count = 0;

  if (_ListOps)
    _ListOps->DeleteAll();
}

/****************************************************************************/
template <class T>
void SimpleDeque<T>::DeleteAllAndData(int DeleteValue_)
{
  if (_KeepValue)
  {
    T* Object_;
    
    while (_Count > 0)
    {
      Object_ = PopNode();
      
      if (DeleteValue_ > 0)
        ::Delete(Object_);
    }
  }
  else
    DeleteAll();
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleDeque)

/****************************************************************************/
/****************************************************************************/
template <class T>
SearchableList<T>::SearchableList(ObjectCloner<T>* ClonerPtr_,
                                  size_t NodeLinks_, bool KeepValue_,
                                  int CopyValue_, bool SaveOps_):
_SearchDir(FORWARD),
SimpleList<T>(ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, SaveOps_)
{}

/****************************************************************************/
template <class T>
SearchableList<T>::SearchableList(const SimpleNode<T>* NodePtr_, ObjectCloner<T>* ClonerPtr_,
                                  size_t NodeLinks_, bool KeepValue_,
                                  int CopyValue_, bool SaveOps_):
_SearchDir(FORWARD),
SimpleList<T>(NodePtr_, ClonerPtr_, NodeLinks_, KeepValue_, CopyValue_, SaveOps_)
{}

/****************************************************************************/
template <class T>
SearchableList<T>::SearchableList(SimpleList<T>* ListPtr_):
_SearchDir(FORWARD),
SimpleList<T>(NULL, 2, true, NO_COPY, false)
{
  if (ListPtr_)
    SimpleList<T>::operator = (*ListPtr_);
}

/****************************************************************************/
template <class T>
SearchableList<T>::SearchableList(const SearchableList<T>& List_):
_SearchDir(List_._SearchDir),
SimpleList<T>(List_)
{}

/****************************************************************************/
template <class T>
SearchableList<T>& SearchableList<T>::operator = (SimpleList<T>* ListPtr_)
{
  SetSaveOps(true);
  SetKeepValue(true);
  SetCopyValue(CopyTypeEnums::NO_COPY);

  if (ListPtr_)
    SimpleList<T>::operator = (*ListPtr_);

  return *this;
}

/****************************************************************************/
template <class T>
SearchableList<T>& SearchableList<T>::operator += (SimpleList<T>* ListPtr_)
{
  SetSaveOps(true);
  SetKeepValue(true);
  SetCopyValue(CopyTypeEnums::NO_COPY);

  if (ListPtr_)
    SimpleList<T>::operator += (*ListPtr_);

  return *this;
}

/****************************************************************************/
template <class T>
SearchableList<T>& SearchableList<T>::operator = (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator = (SimpList_);
  return *this;
}

/****************************************************************************/
template <class T>
SearchableList<T>& SearchableList<T>::operator += (const SimpleList<T>& SimpList_)
{
  SimpleList<T>::operator += (SimpList_);
  return *this;
}

/****************************************************************************/
#if !defined(__TURBOC__) & !defined(__BORLANDC__)
template <class T>
SearchableList<T>& SearchableList<T>::operator = (const SearchableList<T>& SimpList_)
{
  SimpleList<T>::operator = (SimpList_);
  _SearchDir = SimpList_._SearchDir;
  return *this;
}

/****************************************************************************/
template <class T>
SearchableList<T>& SearchableList<T>::operator += (const SearchableList<T>& SimpList_)
{
  SimpleList<T>::operator += (SimpList_);
  _SearchDir = SimpList_._SearchDir;
  return *this;
}
#endif
/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::ForwardFind(T* Obj_, PtrCompare<T>* Compare_)
{
  SimpleNode<T>* Node_ = SimpleList<T>::_List;

  if (Compare_ && Obj_)
  {
    while (Node_ && !(*Compare_)(Obj_, Node_->Value()))
      Node_ = Node_->Next();
  }
  else
  {
    while (Node_ && Obj_ != Node_->Value())
      Node_ = Node_->Next();  
  }

  return ((Obj_ && Node_) ? Node_:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::ForwardFind(T* Obj_)
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  SimpleNode<T>* Res_ = ForwardFind(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::ReverseFind(T* Obj_, PtrCompare<T>* Compare_)
{
  SimpleNode<T>* Node_ = SimpleList<T>::_List;

  if (Compare_ && Obj_)
  {
    while (Node_ && !(*Compare_)(Obj_, Node_->Value()))
      Node_ = Node_->Prev();
  }
  else
  {
    while (Node_ && Obj_ != Node_->Value())
      Node_ = Node_->Prev();  
  }

  return ((Obj_ && Node_) ? Node_:NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::ReverseFind(T* Obj_)
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  SimpleNode<T>* Res_ = ReverseFind(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::Find(T* Obj_, PtrCompare<T>* Compare_)
{
  return ((_SearchDir == FORWARD) ? ForwardFind(Obj_, Compare_):ReverseFind(Obj_, Compare_));
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::Find(T* Obj_)
{
  return ((_SearchDir == FORWARD) ? ForwardFind(Obj_):ReverseFind(Obj_));
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::NextMatch(SimpleNode<T>* Ptr_, PtrCompare<T>* Compare_)
{
  if (Ptr_)
  {
    SimpleNode<T>* Node_ = Ptr_->Next();

    if (Compare_ && Node_)
    {
      while (Node_ && !(*Compare_)(Ptr_->Value(), Node_->Value()))
        Node_ = Node_->Next();
    }
    else
    {
      while (Node_ && Ptr_->Value() != Node_->Value())
        Node_ = Node_->Next();
    }

    return ((Ptr_ && Node_) ? Node_:NULL);
  }

  return NULL;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SearchableList<T>::NextMatch(SimpleNode<T>* Ptr_)
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  SimpleNode<T>* Res_ = NextMatch(Ptr_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>    
SimpleNode<T>* SearchableList<T>::PrevMatch(SimpleNode<T>* Ptr_, PtrCompare<T>* Compare_)
{
  if (Ptr_ && !Ptr_->IsSinglyLinked() && _NodeLinks == 2)
  {
    SimpleNode<T>* Node_ = Ptr_->Prev();

    if (Compare_ && Node_)
    {
      while (Node_ && !(*Compare_)(Ptr_->Value(), Node_->Value()))
        Node_ = Node_->Prev();
    }
    else
    {
      while (Node_ && Ptr_->Value() != Node_->Value())
        Node_ = Node_->Prev();
    }

    return ((Ptr_ && Node_) ? Node_:NULL);
  }

  return NULL;
}

/****************************************************************************/
template <class T>    
SimpleNode<T>* SearchableList<T>::PrevMatch(SimpleNode<T>* Ptr_)
{
  if (Ptr_ && !Ptr_->IsSinglyLinked() && _NodeLinks == 2)
  {
    PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
    SimpleNode<T>* Res_ = PrevMatch(Ptr_, &Comp_);
    return Res_;
  }

  return NULL;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::ForwardFind(const T* Obj_, PtrCompare<T>* Compare_) const
{
  const SimpleNode<T>* Node_ = SimpleList<T>::_List;

  if (Compare_ && Obj_)
  {
    while (Node_ && !(*Compare_)(Obj_, Node_->Value()))
      Node_ = Node_->Next();
  }
  else
  {
    while (Node_ && Obj_ != Node_->Value())
      Node_ = Node_->Next();
  }

  return ((Obj_ && Node_) ? Node_:NULL);
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::ForwardFind(const T* Obj_) const
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  const SimpleNode<T>* Res_ = ForwardFind(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::ReverseFind(const T* Obj_, PtrCompare<T>* Compare_) const
{
  const SimpleNode<T>* Node_ = SimpleList<T>::_List;

  if (Compare_ && Obj_)
  {
    while (Node_ && !(*Compare_)(Obj_, Node_->Value()))
      Node_ = Node_->Prev();
  }
  else
  {
    while (Node_ && Obj_ != Node_->Value())
      Node_ = Node_->Prev();
  }

  return ((Obj_ && Node_) ? Node_:NULL);
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::ReverseFind(const T* Obj_) const
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  const SimpleNode<T>* Res_ = ReverseFind(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::Find(const T* Obj_, PtrCompare<T>* Compare_) const
{
  return ((_SearchDir == FORWARD) ? ForwardFind(Obj_, Compare_):ReverseFind(Obj_, Compare_));
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::Find(const T* Obj_) const
{
  return ((_SearchDir == FORWARD) ? ForwardFind(Obj_):ReverseFind(Obj_));
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::NextMatch(const SimpleNode<T>* Ptr_, PtrCompare<T>* Compare_) const
{
  if (Ptr_)
  {
    const SimpleNode<T>* Node_ = Ptr_->Next();

    if (Compare_ && Node_)
    {
      while (Node_ && !(*Compare_)(Ptr_->Value(), Node_->Value()))
        Node_ = Node_->Next();
    }
    else
    {
      while (Node_ && Ptr_->Value() != Node_->Value())
        Node_ = Node_->Next();
    }

    return ((Ptr_ && Node_) ? Node_:NULL);
  }

  return NULL;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::NextMatch(const SimpleNode<T>* Ptr_) const
{
  PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
  const SimpleNode<T>* Res_ = NextMatch(Ptr_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::PrevMatch(const SimpleNode<T>* Ptr_, PtrCompare<T>* Compare_) const
{
  if (Ptr_ && !Ptr_->IsSinglyLinked() && _NodeLinks == 2)
  {
    const SimpleNode<T>* Node_ = Ptr_->Prev();

    if (Compare_ && Node_)
    {
      while (Node_ && !(*Compare_)(Ptr_->Value(), Node_->Value()))
        Node_ = Node_->Prev();
    }
    else
    {
      while (Node_ && Ptr_->Value() != Node_->Value())
        Node_ = Node_->Prev();
    }

    return ((Ptr_ && Node_) ? Node_:NULL);
  }

  return NULL;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SearchableList<T>::PrevMatch(const SimpleNode<T>* Ptr_) const
{
  if (Ptr_ && !Ptr_->IsSinglyLinked() && _NodeLinks == 2)
  {
    PtrEqual<T> Comp_(SortUsingBuiltInOperators<T>::Trait());
    const SimpleNode<T>* Res_ = PrevMatch(Ptr_, &Comp_);
    return Res_;
  }

  return NULL;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SearchableList)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleListBrowser<T>::SimpleListBrowser(const SearchableList<T>& Alist_):
SearchableList<T>(Alist_.Head(), NULL, 2, true, NO_COPY)
{}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>::SimpleListBrowser(const SimpleNode<T>* Ptr_):
SearchableList<T>(Ptr_, NULL, 2, true, NO_COPY)
{}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>::SimpleListBrowser(SimpleList<T>* ListPtr_):
SearchableList<T>(ListPtr_)
{}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>::~SimpleListBrowser()
{
  SimpleList<T>::_ConstList = NULL;
  SimpleList<T>::_ConstTail = NULL;
}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>& SimpleListBrowser<T>::operator = (const SearchableList<T>& Alist_)
{
  if (this != &Alist_)
  {
    SimpleList<T>::_ConstList = Alist_.Head();
    SimpleList<T>::_ConstTail = SimpleNode<T>::FindConstTail(Alist_.Head());
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>& SimpleListBrowser<T>::operator = (const SimpleNode<T>* Ptr_)
{
  SimpleList<T>::_ConstList = Ptr_;
  SimpleList<T>::_ConstTail = SimpleNode<T>::FindConstTail(Ptr_);
  
  return *this;
}

/****************************************************************************/
template <class T>
SimpleListBrowser<T>& SimpleListBrowser<T>::operator = (SimpleList<T>* ListPtr_)
{
  SetSaveOps(true);
  SetKeepValue(true);
  SetCopyValue(CopyTypeEnums::NO_COPY);
  SearchableList<T>::operator = (ListPtr_);

  return *this;  
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::NextMatch(const T* Obj_, PtrCompare<T>* Compare_) const
{
  if (SimpleList<T>::_ConstList)
  {
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Next();
    SimpleList<T>::_ConstList = ForwardFind(Obj_, Compare_);
  }

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::NextMatch(const T* Obj_) const
{
  PtrEqual<T> Comp_;
  const SimpleNode<T>* Res_ = NextMatch(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::PrevMatch(const T* Obj_, PtrCompare<T>* Compare_) const
{
  if (SimpleList<T>::_ConstList)
  {
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Prev();
    SimpleList<T>::_ConstList = ReverseFind(Obj_, Compare_);
  }

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::PrevMatch(const T* Obj_) const
{
  PtrEqual<T> Comp_;
  const SimpleNode<T>* Res_ = PrevMatch(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::IndexNode(size_t Index_) const
{
  for (size_t Count_ = 0; SimpleList<T>::_ConstList && Count_ < Index_; Count_++)
    ++(*this);

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
Boolean SimpleListBrowser<T>::More() const
{
  return (SimpleList<T>::_ConstList != NULL && SimpleList<T>::_ConstList->Next() != NULL);
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::operator ++ () const
{
  if (SimpleList<T>::_ConstList)
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Next();

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::operator ++ (int) const
{
  const SimpleNode<T>* RetPtr_ = SimpleList<T>::_ConstList;

  if (SimpleList<T>::_ConstList)
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Next();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
Boolean SimpleListBrowser<T>::Less() const
{
  return (SimpleList<T>::_ConstList != NULL && SimpleList<T>::_ConstList->Prev() != NULL);
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::operator -- () const
{
  if (SimpleList<T>::_ConstList)
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Prev();

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
const SimpleNode<T>* SimpleListBrowser<T>::operator -- (int) const
{
  const SimpleNode<T>* RetPtr_ = SimpleList<T>::_ConstList;

  if (SimpleList<T>::_ConstList)
    SimpleList<T>::_ConstList = SimpleList<T>::_ConstList->Prev();

  return RetPtr_;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleListBrowser)

/****************************************************************************/
/****************************************************************************/
template <class T>
SimpleListModifier<T>::SimpleListModifier(SearchableList<T>& Alist_):
SearchableList<T>(Alist_.Head(), NULL, 2, true, NO_COPY)
{}

/****************************************************************************/
template <class T>
SimpleListModifier<T>::SimpleListModifier(SimpleNode<T>* Ptr_):
SearchableList<T>(Ptr_, NULL, 2, true, NO_COPY)
{}

/****************************************************************************/
template <class T>
SimpleListModifier<T>::SimpleListModifier(SimpleList<T>* ListPtr_):
SearchableList<T>(ListPtr_)
{}

/****************************************************************************/
template <class T>
SimpleListModifier<T>::~SimpleListModifier()
{
  SimpleList<T>::_List = NULL;
  SimpleList<T>::_Tail = NULL;
}

/****************************************************************************/
template <class T>
SimpleListModifier<T>& SimpleListModifier<T>::operator = (SearchableList<T>& Alist_)
{
  if (this != &Alist_)
  {
    SimpleList<T>::_List = Alist_.Head();
    SimpleList<T>::_Tail = SimpleNode<T>::FindTail(Alist_.Head());
  }

  return *this;
}

/****************************************************************************/
template <class T>
SimpleListModifier<T>& SimpleListModifier<T>::operator = (SimpleNode<T>* Ptr_)
{
  SimpleList<T>::_List = Ptr_;
  SimpleList<T>::_Tail = SimpleNode<T>::FindTail(Ptr_);
  
  return *this;
}

/****************************************************************************/
template <class T>
SimpleListModifier<T>& SimpleListModifier<T>::operator = (SimpleList<T>* ListPtr_)
{
  SetSaveOps(true);
  SetKeepValue(true);
  SetCopyValue(CopyTypeEnums::NO_COPY);
  SearchableList<T>::operator = (ListPtr_);

  return *this;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::NextMatch(const T* Obj_, PtrCompare<T>* Compare_)
{
  if (SimpleList<T>::_List)
  {
    SimpleList<T>::_List = SimpleList<T>::_List->Next();
    SimpleList<T>::_List = ForwardFind(Obj_, Compare_);
  }

  return SimpleList<T>::_ConstList;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::NextMatch(const T* Obj_)
{
  PtrEqual<T> Comp_;
  SimpleNode<T>* Res_ = NextMatch(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::PrevMatch(const T* Obj_, PtrCompare<T>* Compare_)
{
  if (SimpleList<T>::_List)
  {
    SimpleList<T>::_List = SimpleList<T>::_List->Prev();
    SimpleList<T>::_List = ReverseFind(Obj_, Compare_);
  }

  return SimpleList<T>::_List;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::PrevMatch(const T* Obj_)
{
  PtrEqual<T> Comp_;
  SimpleNode<T>* Res_ = PrevMatch(Obj_, &Comp_);
  return Res_;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::IndexNode(size_t Index_)
{
  for (size_t Count_ = 0; SimpleList<T>::_List && Count_ < Index_; Count_++)
    ++(*this);

  return SimpleList<T>::_List;
}

/****************************************************************************/
template <class T>
Boolean SimpleListModifier<T>::More() const
{
  return (SimpleList<T>::_List != NULL && SimpleList<T>::_List->Next() != NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::operator ++ ()
{
  if (SimpleList<T>::_List)
    SimpleList<T>::_List = SimpleList<T>::_List->Next();

  return SimpleList<T>::_List;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::operator ++ (int)
{
  const SimpleNode<T>* RetPtr_ = SimpleList<T>::_List;

  if (SimpleList<T>::_List)
    SimpleList<T>::_List = SimpleList<T>::_List->Next();

  return RetPtr_;
}

/****************************************************************************/
template <class T>
Boolean SimpleListModifier<T>::Less() const
{
  return (SimpleList<T>::_List != NULL && SimpleList<T>::_List->Prev() != NULL);
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::operator -- ()
{
  if (SimpleList<T>::_List)
    SimpleList<T>::_List = SimpleList<T>::_List->Prev();

  return SimpleList<T>::_List;
}

/****************************************************************************/
template <class T>
SimpleNode<T>* SimpleListModifier<T>::operator -- (int)
{
  SimpleNode<T>* RetPtr_ = SimpleList<T>::_List;

  if (SimpleList<T>::_List)
    SimpleList<T>::_List = SimpleList<T>::_List->Prev();

  return RetPtr_;
}

/****************************************************************************/
MEMORYOPS_TEMPLATE_DEFN(SimpleListModifier)

/****************************************************************************/
#if SIMPLELIST_DEBUG
#if defined(__TURBOC__)
  #ifndef __CONIO_H
    #include <conio.h>
  #endif
#endif

short* Clone(short Obj_)
   { return (new short(Obj_)); }

int main()
{
#if defined(__TURBOC__)
  clrscr();
#endif
  SearchableList<short> Alist_;
  SearchableList<short> Alist2_;
  SimpleStack<short> Astack_;
  SimpleQueue<short> Aqueue_;
  SimpleDeque<short> Adeque_;

  Alist_.SetSaveOps(true);
  Astack_.SetSaveOps(true);
  Aqueue_.SetSaveOps(true);
  Adeque_.SetSaveOps(true);

  Alist_.SetNumberedList(true);
  Astack_.SetNumberedList(true);
  Aqueue_.SetNumberedList(true);
  Adeque_.SetNumberedList(true);
  
  short* Num13_ = new short(13);
  short* Num26_ = new short(26);
  short* Num37_ = new short(37);
  short* Num81_ = new short(81);
  short* Num78_ = new short(78);
  short* Num81b_ = new short(81);
  short* Temp_;

  SimpleNode<short>* Nodep_;
  PtrEqual<short> Comp_(SortUsingBuiltInOperators<short>::Trait());

  system("cls");
  cout <<"Testing Stack" <<endl;  
  Astack_.Push(Num13_);
  Astack_.Push(Num26_);
  Astack_.Push(Num37_);
  Astack_.Push(Num81_);
  Astack_.Push(Num78_);

  Astack_.DumpVectorData(&cout);
  Astack_.DumpListData(NULL, &cout);

  while (!Astack_.Empty())
  {
    Temp_ = Astack_.Pop();
    cout <<(*Temp_) <<" ";
  }
  cout <<endl;
  cout <<"should be: 78, 81, 37, 26, 13" <<endl;

  Astack_.DumpVectorData(&cout);
  Astack_.DumpListData(NULL, &cout);

  #if SIMPLELIST_INTERDEBUG
    cin.get();
  #else
    cout <<endl;
  #endif

  cout <<"Testing Queue" <<endl;
  Aqueue_.Enqueue(Num13_);
  Aqueue_.Enqueue(Num26_);
  Aqueue_.Enqueue(Num37_);
  Aqueue_.Enqueue(Num81_);
  Aqueue_.Enqueue(Num78_);

  Aqueue_.DumpVectorData(&cout);
  Aqueue_.DumpListData(NULL, &cout);

  while (!Aqueue_.Empty())
  {
    Temp_ = Aqueue_.Dequeue();
    cout <<(*Temp_) <<" ";
  }
  cout <<endl;
  cout <<"should be: 13, 26, 37, 81, 78" <<endl;

  Aqueue_.DumpVectorData(&cout);
  Aqueue_.DumpListData(NULL, &cout);

  #if SIMPLELIST_INTERDEBUG
    cin.get();
  #else
    cout <<endl;
  #endif

  cout <<"Testing Deque" <<endl;
  Adeque_.Push(Num13_);
  Adeque_.Push(Num26_);
  Adeque_.Push(Num37_);
  Adeque_.Push(Num81_);
  Adeque_.Push(Num78_);

  Adeque_.Enqueue(Num13_);
  Adeque_.Enqueue(Num26_);
  Adeque_.Enqueue(Num37_);
  Adeque_.Enqueue(Num81_);
  Adeque_.Enqueue(Num78_);

  Adeque_.DumpVectorData(&cout);
  Adeque_.DumpListData(NULL, &cout);

  Adeque_.Pop();
  Adeque_.Dequeue();

  Adeque_.DumpVectorData(&cout);
  Adeque_.DumpListData(NULL, &cout);
  
  Adeque_.Dequeue();
  Adeque_.Pop();

  Adeque_.DumpVectorData(&cout);
  Adeque_.DumpListData(NULL, &cout);

  while (!Adeque_.Empty())
  {
    Temp_ = Adeque_.Dequeue();
    cout <<(*Temp_) <<" ";
  }
  cout <<endl;
  cout <<"should be: 37, 81, 78, 13, 26, 37" <<endl;

  Adeque_.DumpVectorData(&cout);
  Adeque_.DumpListData(NULL, &cout);

  #if SIMPLELIST_INTERDEBUG
    cin.get();
  #else
    cout <<endl;
  #endif

  cout <<"Testing List (numbered)" <<endl;
  Alist_.AppendHead(Num13_);
  Alist_.AppendHead(Num26_);
  Alist_.AppendHead(Num37_);

  for (Nodep_ = Alist_.Head(); Nodep_; Nodep_ = Nodep_->Next())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 37, 26, 13" <<endl;

  Alist_.InsertAfter(Alist_.Find(Num26_, &Comp_), Num81_);
  Alist_.InsertBefore(Alist_.Find(Num26_, &Comp_), Num78_);

  for (Nodep_ = Alist_.Head(); Nodep_; Nodep_ = Nodep_->Next())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 37, 78, 26, 81, 13" <<endl;

  for (Nodep_ = Alist_.Tail(); Nodep_; Nodep_ = Nodep_->Prev())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 13, 81, 26, 78, 37" <<endl;

  Alist_.DumpVectorData(&cout);
  Alist_.DumpListData(NULL, &cout);

  Alist_.Remove(Alist_.Find(Num13_));
  Alist_.Remove(Alist_.Find(Num26_));

  for (Nodep_ = Alist_.Head(); Nodep_; Nodep_ = Nodep_->Next())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 37, 78, 81" <<endl;

  Alist_.DumpVectorData(&cout);
  Alist_.DumpListData(NULL, &cout);

  Alist_.AppendHead(Num81b_);
  Nodep_ = Alist_.Find(Num81b_);
  if (Nodep_)
    cout <<(*Nodep_->Value()) <<" ";
  Nodep_ = Alist_.NextMatch(Nodep_);
  if (Nodep_)
    cout <<(*Nodep_->Value()) <<" ";

  cout <<endl;
  cout <<"should be: 81, 81" <<endl;

  #if SIMPLELIST_INTERDEBUG
    cin.get();
  #else
    cout <<endl;
  #endif

  cout <<"Testing List (unnumbered)" <<endl;
  Alist2_.SetKeepValue(true);
  Alist2_.SetCopyValue(CopyTypeEnums::COPY);
  Alist2_ = Alist_;

  for (Nodep_ = Alist2_.Head(); Nodep_; Nodep_ = Nodep_->Next())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 81, 37, 78, 81" <<endl;

  Alist2_.DumpVectorData(&cout);
  Alist2_.DumpListData(NULL, &cout);

  for (Nodep_ = Alist2_.Tail(); Nodep_; Nodep_ = Nodep_->Prev())
    cout <<(*Nodep_->Value()) <<" ";
  cout <<endl;
  cout <<"should be: 81, 78, 37, 81" <<endl;

  Alist2_.DeleteAllAndData();
  // Alist_.DeleteAllAndData(0);
  
  return 0;
}
#endif
/****************************************************************************/
#endif



