#ifndef SPAWN_CPP
#define SPAWN_CPP
#ifndef SPAWN_H
  #include "spawn.h"
#endif

/****************************************************************************/
// replacement implementation of spawnvp
//
int SpawnVP(int Wait_, const char* progname, char** argv)
{
  #if (defined(__DJGPP__))
    return spawnvp(P_WAIT, "mcalc", argv);
  #elif (defined(__linux__) | defined(__unix__))
    pid_t pid = -1;
    int ret = -1;

    if ((Wait_ == P_OVERLAY) || ((pid = fork()) == 0))
    {
        // child, parent destroyed : Wait_ == P_OVERLAY    OR
        // child : Wait_ == P_NOWAIT || Wait_ == P_WAIT
        //
        ret = execvp(progname, argv);
        if (errno || ret==-1)
          fprintf(stderr, "Failed to invoke execv(); error is %s (%d)\n", strerror(errno), errno);
    }
    else if (pid > 0)
    {
        // parent
        int childExitStatus;
        int ws = 0;

        if (Wait_ == P_WAIT)
        {
          wait(&childExitStatus);
          ws = WEXITSTATUS(childExitStatus);
        }

        return ws;
    }

    return ret;
  #endif
}

/****************************************************************************/
// replacement implementation of spawnvpe
//
int SpawnVPE(int Wait_, const char* progname, char** argv, char** envr)
{
  #if (defined(__DJGPP__))
    return spawnvpe(P_WAIT, "mcalc", argv, envr);
  #elif (defined(__linux__) | defined(__unix__))
    pid_t pid = -1;
    char* key;
    char* val;
    char* args;
    int ret = -1;

    int x;
    for (x = 0; argv[x]; x++)
    {
      args = strdup(argv[x]);

      if (args)
      {
        key = strtok(args, "=");

        if (key)
        {
          val = strtok(NULL, "=");
          if (val)
            setenv(key, val, 1);
        }

        free(args);
        args = NULL;
      }
    }

    if ((Wait_ == P_OVERLAY) || ((pid = fork()) == 0))
    {
        // child, parent destroyed : Wait_ == P_OVERLAY    OR
        // child : Wait_ == P_NOWAIT || Wait_ == P_WAIT
        //
        int y;
        for (y = 0; argv[y]; y++)
        {
          args = strdup(argv[y]);

          if (args)
          {
            key = strtok(args, "=");

            if (key)
            {
              val = strtok(NULL, "=");
              if (val)
                setenv(key, val, 1);
            }

            free(args);
            args = NULL;
          }
        }

        ret = execvp(progname, argv);
        if (errno || ret==-1)
          fprintf(stderr, "Failed to invoke execv(); error is %s (%d)\n", strerror(errno), errno);
    }
    else if (pid > 0)
    {
        // parent
        int childExitStatus;
        int ws = 0;

        if (Wait_ == P_WAIT)
        {
          wait(&childExitStatus);
          ws = WEXITSTATUS(childExitStatus);
        }

        return ws;
    }

    return ret;
  #endif
}

/****************************************************************************/
// replacement implementation of spawnp
//
int SpawnV(int Wait_, const char* progname, char** argv)
{
  #if (defined(__DJGPP__))
    return spawnv(P_WAIT, "mcalc", argv);
  #elif (defined(__linux__) | defined(__unix__))
    pid_t pid = -1;
    int ret = -1;

    if ((Wait_ == P_OVERLAY) || ((pid = fork()) == 0))
    {
        // child, parent destroyed : Wait_ == P_OVERLAY    OR
        // child : Wait_ == P_NOWAIT || Wait_ == P_WAIT
        //
        ret = execv(progname, argv);
        if (errno || ret==-1)
          fprintf(stderr, "Failed to invoke execv(); error is %s (%d)\n", strerror(errno), errno);
    }
    else if (pid > 0)
    {
        // parent
        int childExitStatus;
        int ws = 0;

        if (Wait_ == P_WAIT)
        {
          wait(&childExitStatus);
          ws = WEXITSTATUS(childExitStatus);
        }

        return ws;
    }

    return ret;
  #endif
}

/****************************************************************************/
// replacement implementation of spawnve
//
int SpawnVE(int Wait_, const char* progname, char** argv, char** envr)
{
  #if (defined(__DJGPP__))
    return spawnve(P_WAIT, "mcalc", argv, envr);
  #elif (defined(__linux__) | defined(__unix__))
    pid_t pid = -1;
    int ret = -1;

    if ((Wait_ == P_OVERLAY) || ((pid = fork()) == 0))
    {
        // child, parent destroyed : Wait_ == P_OVERLAY    OR
        // child : Wait_ == P_NOWAIT || Wait_ == P_WAIT
        //
        ret = execve(progname, argv, envr);
        if (errno || ret==-1)
          fprintf(stderr, "Failed to invoke execv(); error is %s (%d)\n", strerror(errno), errno);
    }
    else if (pid > 0)
    {
        // parent
        int childExitStatus;
        int ws = 0;

        if (Wait_ == P_WAIT)
        {
          wait(&childExitStatus);
          ws = WEXITSTATUS(childExitStatus);
        }

        return ws;
    }

    return ret;
  #endif
}

/****************************************************************************/
#endif
