#ifndef SPAWN_H
#define SPAWN_H

// standard libraries
#ifndef INCL_STDIO_H
  #include <stdio.h>
  #define INCL_STDIO_H
#endif
#ifndef INCL_STRING_H
  #include <string.h>
  #define INCL_STRING_H
#endif
#ifndef INCL_STDLIB_H
  #include <stdlib.h>
  #define INCL_STDLIB_H
#endif
#if defined(__DJGPP__) | defined(__GNUC__)
  #ifndef INCL_UNISTD_H
    #include <unistd.h>
    #define INCL_UNISTD_H
  #endif
#endif
#ifndef INCL_ERRNO_H
  #include <errno.h>
  #define INCL_ERRNO_H
#endif
#if defined(__DJGPP__)
  #ifndef INCL_PROCESS_H
    #include <process.h>
    #define INCL_PROCESS_H
  #endif
#endif
#if (defined(__linux__) | defined(__unix__))
  #ifndef INCL_SYS_TYPES_H
    #include <sys/types.h>
    #define INCL_SYS_TYPES_H
  #endif
  #ifndef INCL_SIGNAL_H
    #include <signal.h>
    #define INCL_SIGNAL_H
  #endif
  #ifndef INCL_SYS_WAIT_H
    #include <sys/wait.h>
    #define INCL_SYS_WAIT_H
  #endif
  // #ifndef INCL_SPAWN_H
  //   #include <spawn.h>
  //   #define INCL_SPAWN_H
  // #endif
#endif

#if (!defined(__DJGPP__) & (defined(__linux__) | defined(__unix__)))
  #define P_NOWAIT  0
  #define P_WAIT    1
  #define P_DETACH  2
  #define P_OVERLAY 3
#endif

//
// Replacement spawn functions for systems or C libraries that do not have these functions implemented
//
// replacement implementation of spawnvp
int SpawnVP(int Wait_, const char* progname, char** argv);

// replacement implementation of spawnvpe
int SpawnVPE(int Wait_, const char* progname, char** argv, char** envr);

// replacement implementation of spawnp
int SpawnV(int Wait_, const char* progname, char** argv);

// replacement implementation of spawnve
int SpawnVE(int Wait_, const char* progname, char** argv, char** envr);

#endif
