#ifndef STRFILTER_CPP
#define STRFILTER_CPP

#ifndef STRFILTER_H
  #include "strfilter.h"
#endif

// start: namespace Testing
namespace Testing
{

StringFilter* StringFilter::m_This = NULL;
size_t StringFilter::m_ObjectCnt = 0;
bool StringFilter::m_AutoRelease = false;
bool StringFilter::m_StaticCreate = false;
bool StringFilter::m_StaticDestroy = false;

const char* StringFilter::_DocTypeOpen_Str = NULL;
const char* StringFilter::_DocTypeClose_Str = NULL;
const char* StringFilter::_CommentOpen_Str = NULL;
const char* StringFilter::_CommentClose_Str = NULL;
const char* StringFilter::_NestedComment1Open_Str = NULL;
const char* StringFilter::_NestedComment1Close_Str = NULL;
const char* StringFilter::_NestedComment2Open_Str = NULL;
const char* StringFilter::_NestedComment2Close_Str = NULL;
const char* StringFilter::_StdTagOpen_Str = NULL;
const char* StringFilter::_StdTagClose_Str = NULL;
const char* StringFilter::_EndTagOpen_Str = NULL;
const char* StringFilter::_EndTagClose_Str = NULL;
const char* StringFilter::_EmptyOpen_Str = NULL;
const char* StringFilter::_EmptyClose_Str = NULL;
const char* StringFilter::_ScriptOpen_Str = NULL;
const char* StringFilter::_ScriptClose_Str = NULL;
const char* StringFilter::_COpenCommentBlkOpen_Str = NULL;
const char* StringFilter::_COpenCommentBlkClose_Str = NULL;
const char* StringFilter::_CCloseCommentBlkOpen_Str = NULL;
const char* StringFilter::_CCloseCommentBlkClose_Str = NULL;
const char* StringFilter::_CppCommentLineOpen_Str = NULL;
const char* StringFilter::_CppCommentLineClose_Str = NULL;

/****************************************************************************/
// SFTagElement class definitions
/****************************************************************************/
SFTagElement::SFTagElement(bool Starter_, int ElementIndex_, int* ParentAttr_):
_StartTag(Starter_),
_MatchTag(NULL)
{
  ::memset(_TagAttrib, 0, sizeof(int) * 5);

  if (ParentAttr_)
  {
    _TagAttrib[SFTagEnums::VALIDITY] = ParentAttr_[SFTagEnums::VALIDITY];
    _TagAttrib[SFTagEnums::TAGATTR] = Starter_ ? ParentAttr_[SFTagEnums::TAGATTR]:0;
    _TagAttrib[SFTagEnums::TAGINDEX] = ElementIndex_;

    ParentAttr_[SFTagEnums::TAGELEMENTS]++;
  }
}

/****************************************************************************/
SFTagElement::SFTagElement(const SFTagElement& Obj_):
_TagName(Obj_._TagName),
_TagEnder(Obj_._TagEnder),
_StartTag(Obj_._StartTag),
_MatchTag(Obj_._MatchTag)
{
  ::memmove(_TagAttrib, Obj_._TagAttrib, sizeof(int) * 5);
}

/****************************************************************************/
SFTagElement& SFTagElement::IncrTagAttrib(int Attr_)
{
  _TagAttrib[Attr_]++;
  return *this;
}

/****************************************************************************/
SFTagElement& SFTagElement::SetTagAttrib(int Attr_, int Value_)
{
  _TagAttrib[Attr_] = Value_;
  return *this;
}

/****************************************************************************/
SFTagElement& SFTagElement::SetSFTagElement(const char* Tag_, const char* TagEnder_)
{
  _TagName = Tag_;
  
  if (TagEnder_)
    _TagEnder = TagEnder_;

  return *this;  
}

/****************************************************************************/
SFTagElement& SFTagElement::SetMatchingTag(SFTagElement* MatchTag_, bool Terminate_)
{
  _MatchTag = MatchTag_;
  
  if (_MatchTag && !Terminate_)
    _MatchTag->SetMatchingTag(this, true);
  
  return *this;
}

/****************************************************************************/
int SFTagElement::TagBrkIndex(int BrkType_) const
{
  return ((BrkType_ == SFTagEnums::OPENING) ? _TagAttrib[SFTagEnums::TAGINDEX]:
                                            _TagAttrib[SFTagEnums::TAGINDEX]+1);
}

/****************************************************************************/
SFTagElement& SFTagElement::operator = (const SFTagElement& Obj_)
{
  if (this != &Obj_)
  {
    _StartTag = Obj_._StartTag;
    _MatchTag = Obj_._MatchTag;
    
    ::memmove(_TagAttrib, Obj_._TagAttrib, sizeof(int) * 5);
    _TagName = Obj_._TagName;
    _TagEnder = Obj_._TagEnder;
  }

  return *this;
}

/****************************************************************************/
MEMORYOPS_DEFN(SFTagElement)

/****************************************************************************/
/****************************************************************************/
SFTagCountData::SFTagCountData():
_TagCntIndex(0),
_TagBrkIndex(0),
_TagLstIndex(0),

_DocTypeTagList(new SearchableList<SFTagElement>),
_StdTagList(new SearchableList<SFTagElement>),
_EndTagList(new SearchableList<SFTagElement>),
_EmptyTagList(new SearchableList<SFTagElement>),
_COpenCommentTagList(new SearchableList<SFTagElement>),
_CCloseCommentTagList(new SearchableList<SFTagElement>),
_CppCommentTagList(new SearchableList<SFTagElement>),
_TagCntMatrix((int**)RawAllocateWith(MEMMATRIX, sizeof(int*) * SFTagEnums::TAGLIST_LENGTH)),
_TagBrkMatrix((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * SFTagEnums::TAGLIST_LENGTH)),
_TagMatrix((TAGLISTMATRIX)RawAllocateWith(MEMMATRIX, sizeof(TAGLISTPTR) * TAGLISTMATRIX_SIZE)),
_TagListBrowser(NULL)
{
  int ArrSz_ = sizeof(int*) * SFTagEnums::TAGLIST_LENGTH;
  memset(_TagCntMatrix, 0, ArrSz_);

  ArrSz_ = sizeof(char*) * SFTagEnums::TAGLIST_LENGTH;
  memset(_TagBrkMatrix, 0, ArrSz_);

  ArrSz_ = sizeof(int) * SFTagEnums::MAX_FIELD_DATA;
  memset(_DocTypeOpen_Cnt, 0, ArrSz_);
  memset(_DocTypeClose_Cnt, 0, ArrSz_);
  memset(_CommentOpen_Cnt, 0, ArrSz_);
  memset(_CommentClose_Cnt, 0, ArrSz_);
  memset(_NestedComment1Open_Cnt, 0, ArrSz_);
  memset(_NestedComment1Close_Cnt, 0, ArrSz_);
  memset(_NestedComment2Open_Cnt, 0, ArrSz_);
  memset(_NestedComment2Close_Cnt, 0, ArrSz_);
  memset(_StdTagOpen_Cnt, 0, ArrSz_);
  memset(_StdTagClose_Cnt, 0, ArrSz_);
  memset(_EndTagOpen_Cnt, 0, ArrSz_);
  memset(_EndTagClose_Cnt, 0, ArrSz_);
  memset(_EmptyOpen_Cnt, 0, ArrSz_);
  memset(_EmptyClose_Cnt, 0, ArrSz_);
  memset(_ScriptOpen_Cnt, 0, ArrSz_);
  memset(_ScriptClose_Cnt, 0, ArrSz_);
  memset(_COpenCommentBlkOpen_Cnt, 0, ArrSz_);
  memset(_COpenCommentBlkClose_Cnt, 0, ArrSz_);
  memset(_CCloseCommentBlkOpen_Cnt, 0, ArrSz_);
  memset(_CCloseCommentBlkClose_Cnt, 0, ArrSz_);
  memset(_CppCommentLineOpen_Cnt, 0, ArrSz_);
  memset(_CppCommentLineClose_Cnt, 0, ArrSz_);

  _TagMatrix[0] = _DocTypeTagList;
  _DocTypeOpen_Cnt[LISTINDEX] =
  _DocTypeClose_Cnt[LISTINDEX] = 0;

  _CommentOpen_Cnt[LISTINDEX] =
  _CommentClose_Cnt[LISTINDEX] = -1;

  _NestedComment1Open_Cnt[LISTINDEX] =
  _NestedComment1Close_Cnt[LISTINDEX] = -1;

  _NestedComment2Open_Cnt[LISTINDEX] =
  _NestedComment2Close_Cnt[LISTINDEX] = -1;

  _TagMatrix[1] = _StdTagList;
  _StdTagOpen_Cnt[LISTINDEX] =
  _StdTagClose_Cnt[LISTINDEX] = 1;

  _TagMatrix[2] = _EndTagList;
  _EndTagOpen_Cnt[LISTINDEX] =
  _EndTagClose_Cnt[LISTINDEX] = 2;

  _TagMatrix[3] = _EmptyTagList;
  _EmptyOpen_Cnt[LISTINDEX] =
  _EmptyClose_Cnt[LISTINDEX] = 3;

  _ScriptOpen_Cnt[LISTINDEX] =
  _ScriptClose_Cnt[LISTINDEX] = -1;

  _TagMatrix[4] = _COpenCommentTagList;
  _COpenCommentBlkOpen_Cnt[LISTINDEX] =
  _COpenCommentBlkClose_Cnt[LISTINDEX] = 4;

  _TagMatrix[5] = _CCloseCommentTagList;
  _CCloseCommentBlkOpen_Cnt[LISTINDEX] =
  _CCloseCommentBlkClose_Cnt[LISTINDEX] = 5;

  _TagMatrix[6] = _CppCommentTagList;
  _CppCommentLineOpen_Cnt[LISTINDEX] =
  _CppCommentLineClose_Cnt[LISTINDEX] = 6;

  _TagCntMatrix[_TagCntIndex++] = _DocTypeOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _DocTypeClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CommentOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CommentClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _NestedComment1Open_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _NestedComment1Close_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _NestedComment2Open_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _NestedComment2Close_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _StdTagOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _StdTagClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _EndTagOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _EndTagClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _EmptyOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _EmptyClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _ScriptOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _ScriptClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _COpenCommentBlkOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _COpenCommentBlkClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CCloseCommentBlkOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CCloseCommentBlkClose_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CppCommentLineOpen_Cnt;
  _TagCntMatrix[_TagCntIndex++] = _CppCommentLineClose_Cnt;

  _TagListBrowser = new SimpleListModifier<SFTagElement>(*_StdTagList);
}

/****************************************************************************/
SFTagCountData::~SFTagCountData()
{
  int x;
  for (x = 0; x < SFTagEnums::TAGLIST_LENGTH; x++)
  {
    ::RawDeleteArray(_TagBrkMatrix[x]);
    _TagBrkMatrix[x] = NULL;
  }  

  delete _DocTypeTagList;
  _DocTypeTagList = NULL;
  
  delete _StdTagList;
  _StdTagList = NULL;

  delete _EndTagList;
  _EndTagList = NULL;

  delete _EmptyTagList;
  _EmptyTagList = NULL;

  delete _COpenCommentTagList;
  _COpenCommentTagList = NULL;
  
  delete _CCloseCommentTagList;
  _CCloseCommentTagList = NULL;
  
  delete _CppCommentTagList;
  _CppCommentTagList = NULL;

  delete _TagListBrowser;
  _TagListBrowser = NULL;

  ::RawDeleteArray(_TagCntMatrix);
  ::RawDeleteArray(_TagBrkMatrix);
  ::RawDeleteArray(_TagMatrix);

  _TagCntIndex =
  _TagBrkIndex =
  _TagLstIndex = 0;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::AddTagBrk(const char* Str_)
{
  _TagBrkMatrix[_TagBrkIndex++] = ::NewString(Str_, MEMMATRIX);
  return *this;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::CopyTagCount(const SFTagCountData* TagCnt_)
{
  if (!TagCnt_)
    return *this;

  int x;
  int Max_ = SFTagEnums::MAX_FIELD_DATA;
  
  ChrString Src_;
  ChrString Trg_;
  
  memmove(_DocTypeOpen_Cnt, TagCnt_->_DocTypeOpen_Cnt, sizeof(int) * Max_);
  memmove(_DocTypeClose_Cnt, TagCnt_->_DocTypeClose_Cnt, sizeof(int) * Max_);
  memmove(_CommentOpen_Cnt, TagCnt_->_CommentOpen_Cnt, sizeof(int) * Max_);
  memmove(_CommentClose_Cnt, TagCnt_->_CommentClose_Cnt, sizeof(int) * Max_);
  memmove(_NestedComment1Open_Cnt, TagCnt_->_NestedComment1Open_Cnt, sizeof(int) * Max_);
  memmove(_NestedComment1Close_Cnt, TagCnt_->_NestedComment1Close_Cnt, sizeof(int) * Max_);
  memmove(_NestedComment2Open_Cnt, TagCnt_->_NestedComment2Open_Cnt, sizeof(int) * Max_);
  memmove(_NestedComment2Close_Cnt, TagCnt_->_NestedComment2Close_Cnt, sizeof(int) * Max_);
  memmove(_StdTagOpen_Cnt, TagCnt_->_StdTagOpen_Cnt, sizeof(int) * Max_);
  memmove(_StdTagClose_Cnt, TagCnt_->_StdTagClose_Cnt, sizeof(int) * Max_);
  memmove(_EndTagOpen_Cnt, TagCnt_->_EndTagOpen_Cnt, sizeof(int) * Max_);
  memmove(_EndTagClose_Cnt, TagCnt_->_EndTagClose_Cnt, sizeof(int) * Max_);
  memmove(_EmptyOpen_Cnt, TagCnt_->_EmptyOpen_Cnt, sizeof(int) * Max_);
  memmove(_EmptyClose_Cnt, TagCnt_->_EmptyClose_Cnt, sizeof(int) * Max_);
  memmove(_ScriptOpen_Cnt, TagCnt_->_ScriptOpen_Cnt, sizeof(int) * Max_);
  memmove(_ScriptClose_Cnt, TagCnt_->_ScriptClose_Cnt, sizeof(int) * Max_);  
  memmove(_COpenCommentBlkOpen_Cnt, TagCnt_->_COpenCommentBlkOpen_Cnt, sizeof(int) * Max_);
  memmove(_COpenCommentBlkClose_Cnt, TagCnt_->_COpenCommentBlkClose_Cnt, sizeof(int) * Max_);
  memmove(_CCloseCommentBlkOpen_Cnt, TagCnt_->_CCloseCommentBlkOpen_Cnt, sizeof(int) * Max_);
  memmove(_CCloseCommentBlkClose_Cnt, TagCnt_->_CCloseCommentBlkClose_Cnt, sizeof(int) * Max_);
  memmove(_CppCommentLineOpen_Cnt, TagCnt_->_CppCommentLineOpen_Cnt, sizeof(int) * Max_);
  memmove(_CppCommentLineClose_Cnt, TagCnt_->_CppCommentLineClose_Cnt, sizeof(int) * Max_);
  
  Max_ = SFTagEnums::TAGLIST_MAX_ENTRIES;
  for (x = 0; x < Max_; x++)
    if (TagCnt_->_TagBrkMatrix[x])
      if (_TagBrkMatrix[x])
      {
        Trg_ = _TagBrkMatrix[x];
        Src_ = TagCnt_->_TagBrkMatrix[x];

        if (Src_ != Trg_)
        {
          Trg_ = Src_;
          ::RawDeleteArray(_TagBrkMatrix[x]);
          _TagBrkMatrix[x] = ::NewString(Trg_.c_str());
        }
      }
      else
        _TagBrkMatrix[x] = ::NewString(Src_.c_str());

  Max_ = TAGLISTMATRIX_SIZE;
  for (x = 0; x < Max_; x++)
    if (TagCnt_->_TagMatrix[x] && _TagMatrix[x])
      *_TagMatrix[x] = *TagCnt_->_TagMatrix[x];

  return *this;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::DeleteTagList(int TagIndex_)
{
  int EndListIndex_;
  int ListIndex_ = _TagCntMatrix[TagIndex_][LISTINDEX];
  SFTagElement* ElementNode_;

  if (ListIndex_ >= 0 && _TagMatrix[ListIndex_] &&
      _TagMatrix[ListIndex_]->Size() > 0)
  {
    if (_TagCntMatrix[TagIndex_][TAGELEMENTS])
    {
      ResetTagListIndex(TagIndex_);

      while ((ElementNode_ = GetNextSFTagElement(TagIndex_)))
      {
        ElementNode_ = ElementNode_->GiveMatchingTag();

        if (ElementNode_ && _TagCntMatrix[END_DEX][TAGELEMENTS])
        {
          EndListIndex_ = _TagCntMatrix[END_DEX][LISTINDEX];
          _TagMatrix[EndListIndex_]->Remove(_TagMatrix[EndListIndex_]->Find(ElementNode_, NULL));
          _TagCntMatrix[END_DEX][TAGELEMENTS]--;
        }
      }
    }

    _TagMatrix[ListIndex_]->DeleteAll();
    _TagCntMatrix[TagIndex_][TAGELEMENTS] = 0;
  }

  return *this;
}

/****************************************************************************/
SFTagElement* SFTagCountData::AddToTagList(int TagPos_, const char* Tag_, const char* TagEnder_,
                                       SFTagElement* MatchingTag_, int TagIndex_)
{
  SFTagElement* ElementNode_ = NULL;

  if (TagPos_ && Tag_)
  {
    ElementNode_ = new SFTagElement(true, TagIndex_, _TagCntMatrix[TagIndex_]);
    ElementNode_->SetSFTagElement(Tag_, TagEnder_);
    if (MatchingTag_)
      ElementNode_->SetMatchingTag(MatchingTag_);

    int ListIndex_ = _TagCntMatrix[TagIndex_][LISTINDEX];
    if (ListIndex_ >= 0 && _TagMatrix[ListIndex_])
      _TagMatrix[ListIndex_]->AppendHead(ElementNode_);
  }
  else if (!TagPos_ && Tag_ && MatchingTag_)
  {
    ElementNode_ = new SFTagElement(false, TagIndex_, _TagCntMatrix[TagIndex_]);
    ElementNode_->SetSFTagElement(Tag_, TagEnder_);
    if (MatchingTag_)
      ElementNode_->SetMatchingTag(MatchingTag_);

    int ListIndex_ = _TagCntMatrix[TagIndex_][LISTINDEX];
    if (ListIndex_ >= 0 && _TagMatrix[ListIndex_])
      _TagMatrix[ListIndex_]->AppendHead(ElementNode_);
  }

  return ElementNode_;
}

/****************************************************************************/
SFTagElement* SFTagCountData::GetNextSFTagElement(int TagIndex_)
{
  _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX]--;
  return GetCurrentSFTagElement(TagIndex_);
}

/****************************************************************************/
SFTagElement* SFTagCountData::GetCurrentSFTagElement(int TagIndex_)
{
  int x = _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX];
  int ListIndex_ = _TagCntMatrix[TagIndex_][SFTagEnums::LISTINDEX];

  if (x >= 0 && ListIndex_ >= 0 && _TagMatrix[ListIndex_])
  {
    *_TagListBrowser = *_TagMatrix[ListIndex_];
    SimpleNode<SFTagElement>* ElementNode_ = _TagListBrowser->IndexNode(x);

    if (ElementNode_ && ElementNode_->Value())
      return ElementNode_->Value();
  }

  return NULL;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::ResetTagListIndex(int TagIndex_)
{
  int ListIndex_ = _TagCntMatrix[TagIndex_][SFTagEnums::LISTINDEX];
  _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX] = (ListIndex_ >= 0) ?
      _TagMatrix[ListIndex_]->Size():0;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::SetTagListIndex(int TagIndex_, int ElementIndex_)
{
  int ListIndex_ = _TagCntMatrix[TagIndex_][SFTagEnums::LISTINDEX];
  _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX] = (ListIndex_ >= 0) ?
      ElementIndex_:0;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::InitTagCounts()
{
  int x = 0;
  int Max_ = SFTagEnums::LISTINDEX;

  for (x = 0; x < Max_; x++)
  {
    _DocTypeOpen_Cnt[x] = 0;
    _DocTypeClose_Cnt[x] = 0;
    _CommentOpen_Cnt[x] = 0;
    _CommentClose_Cnt[x] = 0;
    _NestedComment1Open_Cnt[x] = 0;
    _NestedComment1Close_Cnt[x] = 0;
    _NestedComment2Open_Cnt[x] = 0;
    _NestedComment2Close_Cnt[x] = 0;
    _StdTagOpen_Cnt[x] = 0;
    _StdTagClose_Cnt[x] = 0;
    _EndTagOpen_Cnt[x] = 0;
    _EndTagClose_Cnt[x] = 0;
    _EmptyOpen_Cnt[x] = 0;
    _EmptyClose_Cnt[x] = 0;
    _ScriptOpen_Cnt[x] = 0;
    _ScriptClose_Cnt[x] = 0;
    _COpenCommentBlkOpen_Cnt[x] = 0;
    _COpenCommentBlkClose_Cnt[x] = 0;
    _CCloseCommentBlkOpen_Cnt[x] = 0;
    _CCloseCommentBlkClose_Cnt[x] = 0;
    _CppCommentLineOpen_Cnt[x] = 0;
    _CppCommentLineClose_Cnt[x] = 0;
  }

  return *this;
}

/****************************************************************************/
SFTagCountData& SFTagCountData::ResetTagCounts()
{
  int x;
  
  for (x = 0; x < TAGELEMENTS; x++)
  {
    if (x == TAGATTR)
      continue;
  
    _DocTypeOpen_Cnt[x] = 0;
    _DocTypeClose_Cnt[x] = 0;
    _CommentOpen_Cnt[x] = 0;
    _CommentClose_Cnt[x] = 0;
    _NestedComment1Open_Cnt[x] = 0;
    _NestedComment1Close_Cnt[x] = 0;
    _NestedComment2Open_Cnt[x] = 0;
    _NestedComment2Close_Cnt[x] = 0;
    _StdTagOpen_Cnt[x] = 0;
    _StdTagClose_Cnt[x] = 0;
    _EndTagOpen_Cnt[x] = 0;
    _EndTagClose_Cnt[x] = 0;
    _EmptyOpen_Cnt[x] = 0;
    _EmptyClose_Cnt[x] = 0;
    _ScriptOpen_Cnt[x] = 0;
    _ScriptClose_Cnt[x] = 0;
    _COpenCommentBlkOpen_Cnt[x] = 0;
    _COpenCommentBlkClose_Cnt[x] = 0;
    _CCloseCommentBlkOpen_Cnt[x] = 0;
    _CCloseCommentBlkClose_Cnt[x] = 0;
    _CppCommentLineOpen_Cnt[x] = 0;
    _CppCommentLineClose_Cnt[x] = 0;
  }

  return *this;
}

/****************************************************************************/
void SFTagCountData::ResetHtmlTags()
{
  int x = SFTagEnums::VALIDITY;

  _DocTypeOpen_Cnt[x] = ACTIVE;
  _DocTypeClose_Cnt[x] = ACTIVE;

  _CommentOpen_Cnt[x] = ACTIVE;
  _CommentClose_Cnt[x] = ACTIVE;
      
  _NestedComment1Open_Cnt[x] = ACTIVE;
  _NestedComment1Close_Cnt[x] = ACTIVE;
      
  _NestedComment2Open_Cnt[x] = ACTIVE;
  _NestedComment2Close_Cnt[x] = ACTIVE;

  _StdTagOpen_Cnt[x] = ACTIVE;
  _StdTagClose_Cnt[x] = ACTIVE;
    
  _EndTagOpen_Cnt[x] = ACTIVE;
  _EndTagClose_Cnt[x] = ACTIVE;

  _EmptyOpen_Cnt[x] = ACTIVE;
  _EmptyClose_Cnt[x] = ACTIVE;
      
  _ScriptOpen_Cnt[x] = ACTIVE;
  _ScriptClose_Cnt[x] = ACTIVE;
}

/****************************************************************************/
void SFTagCountData::ResetXHtmlTags()
{
  int x = SFTagEnums::VALIDITY;

  _DocTypeOpen_Cnt[x] = ACTIVE;
  _DocTypeClose_Cnt[x] = ACTIVE;

  _CommentOpen_Cnt[x] = ACTIVE;
  _CommentClose_Cnt[x] = ACTIVE;

  _StdTagOpen_Cnt[x] = ACTIVE;
  _StdTagClose_Cnt[x] = ACTIVE;
    
  _EndTagOpen_Cnt[x] = ACTIVE;
  _EndTagClose_Cnt[x] = ACTIVE;

  _EmptyOpen_Cnt[x] = ACTIVE;
  _EmptyClose_Cnt[x] = ACTIVE;
      
  _ScriptOpen_Cnt[x] = ACTIVE;
  _ScriptClose_Cnt[x] = ACTIVE;
}

/****************************************************************************/
void SFTagCountData::ResetXmlTags()
{
  int x = SFTagEnums::VALIDITY;

  _StdTagOpen_Cnt[x] = ACTIVE;
  _StdTagClose_Cnt[x] = ACTIVE;
    
  _EndTagOpen_Cnt[x] = ACTIVE;
  _EndTagClose_Cnt[x] = ACTIVE;

  _EmptyOpen_Cnt[x] = ACTIVE;
  _EmptyClose_Cnt[x] = ACTIVE;      
}

/****************************************************************************/
void SFTagCountData::ResetCppTags()
{
  int x = SFTagEnums::VALIDITY;

  _COpenCommentBlkOpen_Cnt[x] = ACTIVE;
  _COpenCommentBlkClose_Cnt[x] = ACTIVE;

  _CCloseCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[x] = ACTIVE;
    
  _CppCommentLineOpen_Cnt[x] = ACTIVE;
  _CppCommentLineClose_Cnt[x] = ACTIVE;
    
  x = SFTagEnums::TAGATTR;
  _CppCommentLineOpen_Cnt[x] = SINGLETON_TAGATTR;
  _CppCommentLineClose_Cnt[x] = SINGLETON_TAGATTR;
}

/****************************************************************************/
void SFTagCountData::ResetCTags()
{
  int x = SFTagEnums::VALIDITY;

  _COpenCommentBlkOpen_Cnt[x] = ACTIVE;
  _COpenCommentBlkClose_Cnt[x] = ACTIVE;
    
  _CCloseCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[x] = ACTIVE;
}

/****************************************************************************/
SFTagElement* SFTagCountData::GiveFirstSFTagElement()
{
  int SavedIndex_ = 0;
  SFTagElement* ElementNode_ = NULL;

  int ListIndex_;
  int TagIndex_;
  int Max_ = SFTagEnums::TAGLIST_LENGTH;

  for (TagIndex_ = 0; TagIndex_ < Max_; TagIndex_+=2)
    if (_TagCntMatrix[TagIndex_])
    {
      ListIndex_ = _TagCntMatrix[TagIndex_][SFTagEnums::LISTINDEX];

      if (_TagCntMatrix[TagIndex_][SFTagEnums::TAGELEMENTS] > 0)
        if (ListIndex_ >= 0 && _TagMatrix[ListIndex_] &&
            _TagMatrix[ListIndex_]->Size() > 0)
        {
          SavedIndex_ = _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX];
          ResetTagListIndex(TagIndex_);
          ElementNode_ = GetNextSFTagElement(TagIndex_);
          _TagCntMatrix[TagIndex_][SFTagEnums::TAGINDEX] = SavedIndex_;

          if (ElementNode_)
            break;
        }
    }

  return ElementNode_;
}

/****************************************************************************/
MEMORYOPS_DEFN(SFTagCountData)

/****************************************************************************/
/****************************************************************************/
SFTagFoundData::SFTagFoundData():
_RowCnt(0),
_ColCnt(0),

_EndPt(0),
_StartPt(0),
_StartTagRow(0),
_StartTagEndPt(0),
_StartTagStartPt(0),
_EndTagRow(0),
_EndTagEndPt(0),
_EndTagStartPt(0),
    
_IsHtmlTag(false),
_IsXHtmlTag(false),
_IsXmlTag(false),
_IsCppTag(false),
_IsCTag(false),
_IsNonStdTag(false),
_IsSingletonTag(false),
_IsEmptyTag(false),
_SingletonTagAllowed(false),
_EmptyTagAllowed(false),
_SimplifySpaces(false),

_StartTag(NULL),
_StartTagEnd(NULL),
_EndTag(NULL),
_EndTagEnd(NULL),
_TagEsc(0),

_SeqNo(0),
_NestingNo(0),
_TagListIndex(0),
_Parent(NULL)
{}

/****************************************************************************/
SFTagFoundData::SFTagFoundData(const SFTagFoundData& Obj_):
_RowCnt(Obj_._RowCnt),
_ColCnt(Obj_._ColCnt),

_EndPt(Obj_._EndPt),
_StartPt(Obj_._StartPt),
_StartTagRow(Obj_._StartTagRow),
_StartTagEndPt(Obj_._StartTagEndPt),
_StartTagStartPt(Obj_._StartTagStartPt),
_EndTagRow(Obj_._EndTagRow),
_EndTagEndPt(Obj_._EndTagEndPt),
_EndTagStartPt(Obj_._EndTagStartPt),
    
_IsHtmlTag(Obj_._IsHtmlTag),
_IsXHtmlTag(Obj_._IsXHtmlTag),
_IsXmlTag(Obj_._IsXmlTag),
_IsCppTag(Obj_._IsCppTag),
_IsCTag(Obj_._IsCTag),
_IsNonStdTag(Obj_._IsNonStdTag),
_IsSingletonTag(Obj_._IsSingletonTag),
_IsEmptyTag(Obj_._IsEmptyTag),
_SingletonTagAllowed(Obj_._SingletonTagAllowed),
_EmptyTagAllowed(Obj_._EmptyTagAllowed),
_SimplifySpaces(Obj_._SimplifySpaces),

_StartTag(new_char_string(Obj_._StartTag)),
_StartTagEnd(new_char_string(Obj_._StartTagEnd)),
_EndTag(new_char_string(Obj_._EndTag)),
_EndTagEnd(new_char_string(Obj_._EndTagEnd)),
_TagEsc(Obj_._TagEsc),

_SeqNo(Obj_._SeqNo),
_NestingNo(Obj_._NestingNo),
_TagListIndex(Obj_._TagListIndex),
_Parent(Obj_._Parent)
{}

/****************************************************************************/
SFTagFoundData::SFTagFoundData(StringFilter* Parent_, int SeqNo_):
_RowCnt(Parent_ ? Parent_->_RowCnt:0),
_ColCnt(Parent_ ? Parent_->_ColCnt:0),

_EndPt(Parent_ ? Parent_->_EndPt:0),
_StartPt(Parent_ ? Parent_->_StartPt:0),
_StartTagRow(Parent_ ? Parent_->_StartTagRow:0),
_StartTagEndPt(Parent_ ? Parent_->_StartTagEndPt:0),
_StartTagStartPt(Parent_ ? Parent_->_StartTagStartPt:0),
_EndTagRow(Parent_ ? Parent_->_EndTagRow:0),
_EndTagEndPt(Parent_ ? Parent_->_EndTagEndPt:0),
_EndTagStartPt(Parent_ ? Parent_->_EndTagStartPt:0),
    
_IsHtmlTag(Parent_ ? Parent_->_IsHtmlTag:false),
_IsXHtmlTag(Parent_ ? Parent_->_IsXHtmlTag:false),
_IsXmlTag(Parent_ ? Parent_->_IsXmlTag:false),
_IsCppTag(Parent_ ? Parent_->_IsCppTag:false),
_IsCTag(Parent_ ? Parent_->_IsCTag:false),
_IsNonStdTag(Parent_ ? Parent_->_IsNonStdTag:false),
_IsSingletonTag(Parent_ ? Parent_->_IsSingletonTag:false),
_IsEmptyTag(Parent_ ? Parent_->_IsEmptyTag:false),
_SingletonTagAllowed(Parent_ ? Parent_->_SingletonTagAllowed:false),
_EmptyTagAllowed(Parent_ ? Parent_->_EmptyTagAllowed:false),
_SimplifySpaces(Parent_ ? Parent_->_SimplifySpaces:false),

_StartTag(Parent_ ? new_char_string(Parent_->_StartTag):NULL),
_StartTagEnd(Parent_ ? new_char_string(Parent_->_StartTagEnd):NULL),
_EndTag(Parent_ ? new_char_string(Parent_->_EndTag):NULL),
_EndTagEnd(Parent_ ? new_char_string(Parent_->_EndTagEnd):NULL),
_TagEsc(Parent_ ? Parent_->_TagEsc:0),

_SeqNo(Parent_ ? SeqNo_:0),
_NestingNo(Parent_ ? Parent_->_NestingNo:0),
_TagListIndex(Parent_ ? Parent_->_TagListIndex:0),
_Parent(Parent_)
{}

/****************************************************************************/
SFTagFoundData::~SFTagFoundData()
{
  ::RawDeleteArray(_StartTag);
  ::RawDeleteArray(_StartTagEnd);
  ::RawDeleteArray(_EndTag);
  ::RawDeleteArray(_EndTagEnd);

  _StartTag = NULL;
  _StartTagEnd = NULL;
  _EndTag = NULL;
  _EndTagEnd = NULL;
}

/****************************************************************************/
SFTagFoundData* SFTagFoundData::Restore(StringFilter* Ptr_)
{
  Ptr_->_RowCnt = _RowCnt;
  Ptr_->_ColCnt = _ColCnt;

  Ptr_->_EndPt = _EndPt;
  Ptr_->_StartPt = _StartPt;
  Ptr_->_StartTagRow = _StartTagRow;
  Ptr_->_StartTagEndPt = _StartTagEndPt;
  Ptr_->_StartTagStartPt = _StartTagStartPt;
  Ptr_->_EndTagRow = _EndTagRow;
  Ptr_->_EndTagEndPt = _EndTagEndPt;
  Ptr_->_EndTagStartPt = _EndTagStartPt;
    
  Ptr_->_IsHtmlTag = _IsHtmlTag;
  Ptr_->_IsXHtmlTag = _IsXHtmlTag;
  Ptr_->_IsXmlTag = _IsXmlTag;
  Ptr_->_IsCppTag = _IsCppTag;
  Ptr_->_IsCTag = _IsCTag;
  Ptr_->_IsNonStdTag = _IsNonStdTag;
  Ptr_->_IsSingletonTag = _IsSingletonTag;
  Ptr_->_IsEmptyTag = _IsEmptyTag;
  Ptr_->_SingletonTagAllowed = _SingletonTagAllowed;
  Ptr_->_EmptyTagAllowed = _EmptyTagAllowed;
  Ptr_->_SimplifySpaces = _SimplifySpaces;

  if (_StartTag)
  {
    ::DeleteArray(Ptr_->_StartTag);
    Ptr_->_StartTag = _StartTag;
  }

  if (_StartTagEnd)
  {
    ::DeleteArray(Ptr_->_StartTagEnd);
    Ptr_->_StartTagEnd = _StartTagEnd;
  }

  if (_EndTag)
  {
    ::DeleteArray(Ptr_->_EndTag);
    Ptr_->_EndTag = _EndTag;
  }

  if (_EndTagEnd)
  {
    ::DeleteArray(Ptr_->_EndTagEnd);
    Ptr_->_EndTagEnd = _EndTagEnd;
  }

  Ptr_->_TagEsc = _TagEsc;
  Ptr_->_NestingNo = _NestingNo;
  Ptr_->_TagListIndex = _TagListIndex;

  return this;
}

/****************************************************************************/
MEMORYOPS_DEFN(SFTagFoundData)

/****************************************************************************/
/****************************************************************************/
SFStringFoundData::SFStringFoundData():
_Index(0),
_TagEscCnt(0),
_NonEscCnt(0),
_BufIndex(0),
_Cnt(0),
_Total(0),
_Diff(0),

_StartPt(0),
_EndPt(0),
_EndTagRow(0),
_EndTagStartPt(0),
_EndTagEndPt(0),
_StartTagRow(0),
_StartTagStartPt(0),
_StartTagEndPt(0),

_HaveTagEsc(false),
_HaveTag(false),
_BreakonStartTag(false),
_BreakonEndTag(false),
_InTag(false)
{
  ::memset(_len, 0, sizeof(long) * 5);
}

/****************************************************************************/
SFStringFoundData::SFStringFoundData(const SFStringFoundData& Obj_):
_Index(Obj_._Index),
_TagEscCnt(Obj_._TagEscCnt),
_NonEscCnt(Obj_._NonEscCnt),
_BufIndex(Obj_._BufIndex),
_Cnt(Obj_._Cnt),
_Total(Obj_._Total),
_Diff(Obj_._Diff),

_StartPt(Obj_._StartPt),
_EndPt(Obj_._EndPt),
_EndTagRow(Obj_._EndTagRow),
_EndTagStartPt(Obj_._EndTagStartPt),
_EndTagEndPt(Obj_._EndTagEndPt),
_StartTagRow(Obj_._StartTagRow),
_StartTagStartPt(Obj_._StartTagStartPt),
_StartTagEndPt(Obj_._StartTagEndPt),

_HaveTagEsc(Obj_._HaveTagEsc),
_HaveTag(Obj_._HaveTag),
_BreakonStartTag(Obj_._BreakonStartTag),
_BreakonEndTag(Obj_._BreakonEndTag),
_InTag(Obj_._InTag)
{
  _Buffer = Obj_._Buffer;
  ::memmove(_len, Obj_._len, sizeof(long) * 4);
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::Save(StringFilter* Ptr_, long Index_, long* len)
{
  _Buffer = Ptr_->_Buffer;
  ::memmove(_len, len, sizeof(long) * 4);
  
  _Index = Index_;
  _TagEscCnt = Ptr_->_TagEscCnt;
  _NonEscCnt = Ptr_->_NonEscCnt;
  _StartPt = Ptr_->_StartPt;
  _EndPt = Ptr_->_EndPt;
  _EndTagRow = Ptr_->_EndTagRow;
  _EndTagStartPt = Ptr_->_EndTagStartPt;
  _EndTagEndPt = Ptr_->_EndTagEndPt;
  _StartTagRow = Ptr_->_StartTagRow;
  _StartTagStartPt = Ptr_->_StartTagStartPt;
  _StartTagEndPt = Ptr_->_StartTagEndPt;

  _HaveTagEsc = Ptr_->_HaveTagEsc;
  _HaveTag = Ptr_->_HaveTag;
  _BreakonStartTag = Ptr_->_BreakonStartTag;
  _BreakonEndTag = Ptr_->_BreakonEndTag;
  _InTag = Ptr_->_InTag;

  return this;
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::Restore(StringFilter* Ptr_, long& Index_, long* len)
{
  Ptr_->_Buffer = _Buffer;
  Index_ = _Index;

  ::memmove(len, _len, sizeof(long) * 4);
  Ptr_->_TagEscCnt = _TagEscCnt;
  Ptr_->_NonEscCnt = _NonEscCnt;
  Ptr_->_StartPt = _StartPt;
  Ptr_->_EndPt = _EndPt;
  Ptr_->_EndTagRow = _EndTagRow;
  Ptr_->_EndTagStartPt = _EndTagStartPt;
  Ptr_->_EndTagEndPt = _EndTagEndPt;
  Ptr_->_StartTagRow = _StartTagRow;
  Ptr_->_StartTagStartPt = _StartTagStartPt;
  Ptr_->_StartTagEndPt = _StartTagEndPt;

  Ptr_->_HaveTagEsc = _HaveTagEsc;
  Ptr_->_HaveTag = _HaveTag;
  Ptr_->_BreakonStartTag = _BreakonStartTag;
  Ptr_->_BreakonEndTag = _BreakonEndTag;
  Ptr_->_InTag = _InTag;

  return this;
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::Save(StringFilter* Ptr_)
{
  _StartPt = Ptr_->_StartPt;
  _EndPt = Ptr_->_EndPt;
  _EndTagRow = Ptr_->_EndTagRow;
  _EndTagStartPt = Ptr_->_EndTagStartPt;
  _EndTagEndPt = Ptr_->_EndTagEndPt;
  _StartTagRow = Ptr_->_StartTagRow;
  _StartTagStartPt = Ptr_->_StartTagStartPt;
  _StartTagEndPt = Ptr_->_StartTagEndPt;

  return this;
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::Restore(StringFilter* Ptr_)
{
  Ptr_->_StartPt = _StartPt;
  Ptr_->_EndPt = _EndPt;
  Ptr_->_EndTagRow = _EndTagRow;
  Ptr_->_EndTagStartPt = _EndTagStartPt;
  Ptr_->_EndTagEndPt = _EndTagEndPt;
  Ptr_->_StartTagRow = _StartTagRow;
  Ptr_->_StartTagStartPt = _StartTagStartPt;
  Ptr_->_StartTagEndPt = _StartTagEndPt;

  return this;
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::AddData(StringFilter* Ptr_, long& BufIndex_, long& cnt,
                                          long& Total_, long* len, bool Cont_,
                                          short LenVectIndex_, SFTagStringData& Data_)
{
  short x;
  short y = LenVectIndex_;

  long TagDiff_ = Data_.oldlen[y] - Data_.len[y];
  long ReadDiff_ = Data_.oldlen[1] - Data_.len[1];

  _Diff = ((TagDiff_ > 0 && Data_._RevTagLen) ||
           (ReadDiff_ > 0 && Data_._RevReadLen)) ? 1:0;

  if (_Diff > 0)
  {
    _BufIndex = BufIndex_;
    _Cnt = cnt;
    _Total = Total_;

    if (len[3] && Data_._RevTagLen)
      _len[4] = len[3];
    else
      _len[4] = 0;

    if (Data_._RevTagLen)
    {
      if (LenVectIndex_ > 0)
        len[3] = TagDiff_;
      else
      {
        if (len[3] > 0)
          len[3] += TagDiff_;
        else
          len[3] = len[y] + TagDiff_;
      }
    }

    if (Data_._RevReadLen)
    {
      if (BufIndex_ + ReadDiff_ <= Total_)
      {
        cnt += ReadDiff_;
        BufIndex_ += ReadDiff_;
      }
      else
      {
        ReadDiff_ = Total_ - BufIndex_;
        cnt += ReadDiff_;
        BufIndex_ += ReadDiff_;
      }
    }
  }
  else
    _Diff = 0;

  return this;
}

/****************************************************************************/
SFStringFoundData* SFStringFoundData::ReturnData(StringFilter* Ptr_, long& BufIndex_, long& cnt, long& Total_,
                                             long& SavedLen_, long* len, SFTagStringData& Data_)
{
  if (_Diff > 0)
  {
    Total_ = _Total;
    cnt = _Cnt;
    BufIndex_ = _BufIndex;
    
    _Diff = 0;

    if (_len[4])
    {
      len[3] = _len[4];
      _len[4] = 0;
    }
    else
      len[3] = 0;

    Data_._RevTagLen = false;
    Data_._RevReadLen = false;
  }
  else
    _Diff = 0;

  return this;
}

/****************************************************************************/
MEMORYOPS_DEFN(SFStringFoundData)

/****************************************************************************/
/****************************************************************************/
SFTagStringData::SFTagStringData():
pIs_(NULL),
TagType_(0),
SeqType_(0),
pBufIndex_(NULL),
LenVectIndex_(0),
pIndex_(NULL),
pTotal_(NULL),
pAdded_(NULL),
len(NULL),
Delim_(NULL),
Csense_(false),
Ptr_(NULL),
sPtr_(NULL),
ePtr_(NULL),
Continued_(false),
SvOver_(false),
IndexSpecified_(false),
_RewindedLen(0),
_RevTagLen(false),
_RevReadLen(false),
_Eof(false),
_FindingTag(false),
_TagFound(false),
_NewLine(false),
_TagType(0),
_TagBrkType(0),

StrDataNode_(NULL),
ElementNode_(NULL),
StartPoint_(0),
EndPoint_(0),
TagIndex_(0),
pDataAdded_(NULL),

oldlen(NULL),
Cont_(false)
{}

/****************************************************************************/
/****************************************************************************/
StringFilter::StringFilter():
_Frp(NULL),
_GetchFromTemp(FALSE),
_Buffer(char(0), BUFSIZE),
_MainFileName(NULL),
_EndReadMark(NULL),
_NestingMax(0),
_NestingLevel(0),
_NestingNo(0),
_Next(NULL),
_Prev(NULL),

_SavedIndex(0),
_SavedLen(0),
_SavedOver(0),
_SavedStream(NULL),
_LineFound(false),
_EndLineDelim(' '),
_RowCnt(0),
_ColCnt(0),
_EndPt(0),
_StartPt(0),
_StartTagRow(0),
_StartTagEndPt(0),
_StartTagStartPt(0),
_EndTagRow(0),
_EndTagEndPt(0),
_EndTagStartPt(0),

_IsHtmlTag(false),
_IsXHtmlTag(false),
_IsXmlTag(false),
_IsCppTag(false),
_IsCTag(false),
_IsNonStdTag(false),
_IsSingletonTag(false),
_IsEmptyTag(false),
_SingletonTagAllowed(false),
_EmptyTagAllowed(false),
_SimplifySpaces(false),

_TempRec((char*)RawAllocateWith(MEMMATRIX, sizeof(char) * FLDSIZE)),
_Tindex(0),
_Tlength(0),

_ColStk(new SimpleStack<long>),
_StrFoundStk(new SimpleStack<SFStringFoundData>),
_TagFoundQue(new SimpleQueue<SFTagFoundData>),
_StartTag(NULL),
_StartTagEnd(NULL),
_EndTag(NULL),
_EndTagEnd(NULL),
_TagEsc(0),

_TagCntData(NULL),
_SavedTagCntData(NULL),
_UseTagList(false),
_TagType(0),
_EndTagType(0),
_InputMethod(USE_FUNCTIONARGS),
_TagList(NULL),
_TagCount(NULL),
_TagListMax(TAGLIST_MAX_ENTRIES),
_TagListIndex(0),
_TagSeqType(OPENING),

_InTag(false),
_TagEscCnt(0),
_NonEscCnt(0),
_BreakonStartTag(false),
_BreakonEndTag(false),
_HaveTag(false),
_HaveTagEsc(false)
{
  // Initializing character string buffer
  _Buffer.SetCountNulls(TRUE);
  _Buffer.SetAutoAppend(TRUE);
  _Buffer.StrFill(0, BUFSIZE);

  if (!m_StaticCreate)
  {
    if (!m_This)
      Instance();

    ++m_ObjectCnt;
    m_AutoRelease = true;
  }

  if (_TagListMax &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    InitTagList();
}

/****************************************************************************/
StringFilter::StringFilter(const StringFilter& Stok_, StringFilter* Next_):
_Frp(NULL),
_GetchFromTemp(Stok_._GetchFromTemp),
_Buffer(char(0), BUFSIZE),
_MainFileName(new_char_string(Stok_._MainFileName)),
_EndReadMark(new_char_string(Stok_._EndReadMark)),
_NestingMax(Stok_._NestingMax),
_NestingLevel(Stok_._NestingLevel),
_NestingNo(Stok_._NestingNo),
_Next(Next_),
_Prev(NULL),

_SavedIndex(Stok_._SavedIndex),
_SavedLen(0),
_SavedOver(0),
_SavedStream(Stok_._SavedStream),
_LineFound(Stok_._LineFound),
_EndLineDelim(Stok_._EndLineDelim),
_RowCnt(Stok_._RowCnt),
_ColCnt(Stok_._ColCnt),
_EndPt(Stok_._EndPt),
_StartPt(Stok_._StartPt),
_StartTagRow(Stok_._StartTagRow),
_StartTagEndPt(Stok_._StartTagEndPt),
_StartTagStartPt(Stok_._StartTagStartPt),
_EndTagRow(Stok_._EndTagRow),
_EndTagEndPt(Stok_._EndTagEndPt),
_EndTagStartPt(Stok_._EndTagStartPt),

_IsHtmlTag(Stok_._IsHtmlTag),
_IsXHtmlTag(Stok_._IsXHtmlTag),
_IsXmlTag(Stok_._IsXmlTag),
_IsNonStdTag(Stok_._IsNonStdTag),
_IsCppTag(Stok_._IsCppTag),
_IsCTag(Stok_._IsCTag),
_IsSingletonTag(Stok_._IsSingletonTag),
_IsEmptyTag(Stok_._IsEmptyTag),
_SingletonTagAllowed(Stok_._SingletonTagAllowed),
_EmptyTagAllowed(Stok_._EmptyTagAllowed),
_SimplifySpaces(Stok_._SimplifySpaces),

_TempRec((char*)RawAllocateWith(MEMMATRIX, sizeof(char) * FLDSIZE)),
_Tindex(Stok_._Tindex),
_Tlength(Stok_._Tlength),

_ColStk(new SimpleStack<long>),
_StrFoundStk(new SimpleStack<SFStringFoundData>),
_TagFoundQue(new SimpleQueue<SFTagFoundData>),
_StartTag(new_char_string(Stok_._StartTag)),
_StartTagEnd(new_char_string(Stok_._StartTagEnd)),
_EndTag(new_char_string(Stok_._EndTag)),
_EndTagEnd(new_char_string(Stok_._EndTagEnd)),
_TagEsc(Stok_._TagEsc),

_TagCntData(NULL),
_SavedTagCntData(NULL),
_UseTagList(false),
_TagType(0),
_EndTagType(0),
_InputMethod(Stok_._InputMethod),
_TagList(NULL),
_TagCount(NULL),
_TagListMax(TAGLIST_MAX_ENTRIES),
_TagListIndex(Stok_._TagListIndex),
_TagSeqType(Stok_._TagSeqType),

_InTag(Stok_._InTag),
_TagEscCnt(Stok_._TagEscCnt),
_NonEscCnt(Stok_._TagEscCnt),
_BreakonStartTag(Stok_._BreakonStartTag),
_BreakonEndTag(Stok_._BreakonEndTag),
_HaveTag(Stok_._HaveTag),
_HaveTagEsc(Stok_._HaveTagEsc)
{
  if (_MainFileName)
  {
    _Frp = new FileReader();
    _Frp->Open(_MainFileName, ios::in);
  }

  _Buffer.SetCountNulls(TRUE);
  _Buffer.SetAutoAppend(TRUE);
  _Buffer = Stok_._Buffer;
  strcpy(_TempRec, Stok_._TempRec);

  if (!m_StaticCreate)
  {
    if (!m_This)
      Instance();

    ++m_ObjectCnt;
    m_AutoRelease = true;
  }

  if (_TagListMax &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
  {
    InitTagList();
    CopyTagCount(Stok_);
  }
}

/****************************************************************************/
StringFilter::StringFilter(const char* Fname_, int NestingLevel_, StringFilter* Next_):
_Frp(NULL),
_GetchFromTemp(FALSE),
_Buffer(char(0), BUFSIZE),
_MainFileName(NULL),
_EndReadMark(NULL),
_NestingMax(NestingLevel_),
_NestingLevel(NestingLevel_),
_NestingNo(0),
_Next(Next_),
_Prev(NULL),

_SavedIndex(0),
_SavedLen(0),
_SavedOver(0),
_SavedStream(NULL),
_LineFound(false),
_EndLineDelim(' '),
_RowCnt(0),
_ColCnt(0),
_EndPt(0),
_StartPt(0),
_StartTagRow(0),
_StartTagEndPt(0),
_StartTagStartPt(0),
_EndTagRow(0),
_EndTagEndPt(0),
_EndTagStartPt(0),

_IsHtmlTag(false),
_IsXHtmlTag(false),
_IsXmlTag(false),
_IsCppTag(false),
_IsCTag(false),
_IsNonStdTag(false),
_IsSingletonTag(false),
_IsEmptyTag(false),
_SingletonTagAllowed(false),
_EmptyTagAllowed(false),
_SimplifySpaces(false),

_TempRec((char*)RawAllocateWith(MEMMATRIX, sizeof(char) * FLDSIZE)),
_Tindex(0),
_Tlength(0),

_ColStk(new SimpleStack<long>),
_StrFoundStk(new SimpleStack<SFStringFoundData>),
_TagFoundQue(new SimpleQueue<SFTagFoundData>),
_StartTag(NULL),
_StartTagEnd(NULL),
_EndTag(NULL),
_EndTagEnd(NULL),
_TagEsc(0),

_TagCntData(NULL),
_SavedTagCntData(NULL),
_UseTagList(false),
_TagType(0),
_EndTagType(0),
_InputMethod(USE_FUNCTIONARGS),
_TagList(NULL),
_TagCount(NULL),
_TagListMax(TAGLIST_MAX_ENTRIES),
_TagListIndex(0),
_TagSeqType(OPENING),

_InTag(false),
_TagEscCnt(0),
_NonEscCnt(0),
_BreakonStartTag(false),
_BreakonEndTag(false),
_HaveTag(false),
_HaveTagEsc(false)
{
  if (Fname_)
  {
    _Frp = new FileReader();
    _Frp->Open(Fname_, ios::in);
    _MainFileName = new_char_string(Fname_);
  }

  _Buffer.SetCountNulls(TRUE);
  _Buffer.SetAutoAppend(TRUE);
  _Buffer.StrFill(0, BUFSIZE);

  if (!m_StaticCreate)
  {
    if (!m_This)
      Instance();

    ++m_ObjectCnt;
    m_AutoRelease = true;
  }

  if (_TagListMax &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    InitTagList();
}

/****************************************************************************/
StringFilter::~StringFilter()
{
  ::DeleteArray(_TempRec);
  ::DeleteArray(_MainFileName);
  ::DeleteArray(_StartTag);
  ::DeleteArray(_StartTagEnd);
  ::DeleteArray(_EndTag);
  ::DeleteArray(_EndTagEnd);
  ::DeleteArray(_EndReadMark);

  StringFilter* Old_ = Pop();

  while (Old_)
  {
    delete Old_;
    Old_ = Pop();
  }

  if (_Frp)
  {
    _Frp->Close();
    delete _Frp;
  }

  delete _ColStk;
  delete _StrFoundStk;
  delete _TagFoundQue;
  delete _Next;

  if (!m_StaticDestroy && m_ObjectCnt > 1)
  {
    --m_ObjectCnt;

    if (m_AutoRelease && m_ObjectCnt == 1 && m_This)
    {
      m_StaticDestroy = true;
      m_AutoRelease = false;
      Release();
    }
  }

  if (_TagListMax && _TagList)
    DestroyTagList();
}

/****************************************************************************/
void StringFilter::Init()
{
  if (!_DocTypeOpen_Str)
    _DocTypeOpen_Str = NewString(DOCTYPEOPEN_STR, MEMMATRIX);

  if (!_DocTypeClose_Str)
    _DocTypeClose_Str = NewString(DOCTYPECLOSE_STR, MEMMATRIX);

  if (!_CommentOpen_Str)
    _CommentOpen_Str = NewString(COMMENTOPEN_STR, MEMMATRIX);

  if (!_CommentClose_Str)
    _CommentClose_Str = NewString(COMMENTCLOSE_STR, MEMMATRIX);

  if (!_NestedComment1Open_Str)
    _NestedComment1Open_Str = NewString(NESTEDCOMMENT1OPEN_STR, MEMMATRIX);

  if (!_NestedComment1Close_Str)
    _NestedComment1Close_Str = NewString(NESTEDCOMMENT1CLOSE_STR, MEMMATRIX);

  if (!_NestedComment2Open_Str)
    _NestedComment2Open_Str = NewString(NESTEDCOMMENT2OPEN_STR, MEMMATRIX);

  if (!_NestedComment2Close_Str)
    _NestedComment2Close_Str = NewString(NESTEDCOMMENT2CLOSE_STR, MEMMATRIX);

  if (!_StdTagOpen_Str)
    _StdTagOpen_Str = NewString(STDTAGOPEN_STR, MEMMATRIX);

  if (!_StdTagClose_Str)
    _StdTagClose_Str = NewString(STDTAGCLOSE_STR, MEMMATRIX);

  if (!_EndTagOpen_Str)
    _EndTagOpen_Str = NewString(ENDTAGOPEN_STR, MEMMATRIX);

  if (!_EndTagClose_Str)
    _EndTagClose_Str = NewString(ENDTAGCLOSE_STR, MEMMATRIX);

  if (!_EmptyOpen_Str)
    _EmptyOpen_Str = NewString(EMPTYOPEN_STR, MEMMATRIX);

  if (!_EmptyClose_Str)
    _EmptyClose_Str = NewString(EMPTYCLOSE_STR, MEMMATRIX);

  if (!_ScriptOpen_Str)
    _ScriptOpen_Str = NewString(SCRIPTOPEN_STR, MEMMATRIX);

  if (!_ScriptClose_Str)
    _ScriptClose_Str = NewString(SCRIPTCLOSE_STR, MEMMATRIX);

  if (!_COpenCommentBlkOpen_Str)
    _COpenCommentBlkOpen_Str = NewString(COPENCOMMENTBLKOPEN_STR, MEMMATRIX);

  if (!_COpenCommentBlkClose_Str)
    _COpenCommentBlkClose_Str = NewString(COPENCOMMENTBLKCLOSE_STR, MEMMATRIX);

  if (!_CCloseCommentBlkOpen_Str)
    _CCloseCommentBlkOpen_Str = NewString(CCLOSECOMMENTBLKOPEN_STR, MEMMATRIX);

  if (!_CCloseCommentBlkClose_Str)
    _CCloseCommentBlkClose_Str = NewString(CCLOSECOMMENTBLKCLOSE_STR, MEMMATRIX);

  if (!_CppCommentLineOpen_Str)
    _CppCommentLineOpen_Str = NewString(CPPCOMMENTLINEOPEN_STR, MEMMATRIX);

  if (!_CppCommentLineClose_Str)
    _CppCommentLineClose_Str = NewString(CPPCOMMENTLINECLOSE_STR, MEMMATRIX);
}

/****************************************************************************/
StringFilter* StringFilter::Instance()
{
  if (!m_This)
  {
    m_StaticCreate = true;
    m_This = new StringFilter();
    ++m_ObjectCnt;
    Init();
    m_StaticCreate = false;
  }

  return m_This;
}

/****************************************************************************/
void StringFilter::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && m_This)
  {
    m_StaticDestroy = true;
    delete m_This;
    m_This = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
void StringFilter::ResetTagList()
{
  int x;

  if (!_TagList)
    InitTagList();
  else
    _TagCntData->ResetTagCounts();

  if (_IsHtmlTag)
  {
    _TagCntData->ResetHtmlTags();

    // <tag /> allowed or <tag> allowed if _EmptyTagAllowed is true
    _SingletonTagAllowed = true;

    // <tag> form allowed without requiring </tag> or <tag />
    _EmptyTagAllowed = true;
  }
  else if (_IsXmlTag || _IsXHtmlTag)
  {
    if (_IsXHtmlTag)
      _TagCntData->ResetXHtmlTags();
    else
      _TagCntData->ResetXmlTags();

    // <tag /> allowed or <tag> allowed if _EmptyTagAllowed is true
    _SingletonTagAllowed = true;

    // <tag> form allowed without requiring </tag> or <tag />
    _EmptyTagAllowed = false;
  }

  if (_IsCppTag)
  {
    // // comments => allowed, /* -> without matching <- */ NOT allowed
    _SingletonTagAllowed = true;

    // /* -> tag must have matching <- */ tag, empty /* -> NOT allowed
    _EmptyTagAllowed = false;

    _TagCntData->ResetCppTags();
  }
  else if (_IsCTag)
  {
    // // comments => NOT allowed, /* -> without matching <- */ NOT allowed
    _SingletonTagAllowed = false;

    // /* -> tag must have matching <- */ tag, empty /* -> NOT allowed
    _EmptyTagAllowed = false;

    _TagCntData->ResetCTags();
  }
}

/****************************************************************************/
void StringFilter::SetupTagData()
{
  if (!_TagCntData)
  {
    _TagCntData = new SFTagCountData();
    _TagList = _TagCntData->GiveTagBrkMatrix();
    _TagCount = _TagCntData->GiveTagCntMatrix();
  }
}

/****************************************************************************/
void StringFilter::CopyTagListData(StringFilter* Ptr_,
                                   const ChrString& StartStr_, const ChrString& EndStr_)
{
  if (Ptr_ && Ptr_->_UseTagList)
  {
    _SavedTagCntData = Ptr_->_TagCntData;
    _SavedStartTag   = StartStr_;
    _SavedEndTag     = EndStr_;
    
    _UseTagList      = Ptr_->_UseTagList;
    _TagType         = Ptr_->_TagType;
    _EndTagType      = Ptr_->_EndTagType;

    _TagList         = _TagCntData->GiveTagBrkMatrix();
    _TagCount        = _TagCntData->GiveTagCntMatrix();
  }
}

/****************************************************************************/
void StringFilter::InitTagList()
{
  // setup tag data structures if they haven't already been allocated
  SetupTagData();

  // first array element is tag current nesting level
  // second array element is tag sequential count value
  _TagCntData->InitTagCounts();

  // Initializing tag list
  _TagCntData->AddTagBrk(_DocTypeOpen_Str);
  _TagCntData->AddTagBrk(_DocTypeClose_Str);
  _TagCntData->AddTagBrk(_CommentOpen_Str);
  _TagCntData->AddTagBrk(_CommentClose_Str);
  _TagCntData->AddTagBrk(_NestedComment1Open_Str);
  _TagCntData->AddTagBrk(_NestedComment1Close_Str);
  _TagCntData->AddTagBrk(_NestedComment2Open_Str);
  _TagCntData->AddTagBrk(_NestedComment2Close_Str);
  _TagCntData->AddTagBrk(_StdTagOpen_Str);
  _TagCntData->AddTagBrk(_StdTagClose_Str);
  _TagCntData->AddTagBrk(_EndTagOpen_Str);
  _TagCntData->AddTagBrk(_EndTagClose_Str);
  _TagCntData->AddTagBrk(_EmptyOpen_Str);
  _TagCntData->AddTagBrk(_EmptyClose_Str);
  _TagCntData->AddTagBrk(_ScriptOpen_Str);
  _TagCntData->AddTagBrk(_ScriptClose_Str);
  _TagCntData->AddTagBrk(_COpenCommentBlkOpen_Str);
  _TagCntData->AddTagBrk(_COpenCommentBlkClose_Str);
  _TagCntData->AddTagBrk(_CCloseCommentBlkOpen_Str);
  _TagCntData->AddTagBrk(_CCloseCommentBlkClose_Str);
  _TagCntData->AddTagBrk(_CppCommentLineOpen_Str);
  _TagCntData->AddTagBrk(_CppCommentLineClose_Str);

  _TagList = _TagCntData->GiveTagBrkMatrix();
  _TagCount = _TagCntData->GiveTagCntMatrix();
}

/****************************************************************************/
void StringFilter::DestroyTagList()
{
  if (!_UseTagList)
    delete _TagCntData;
}

/****************************************************************************/
void StringFilter::CopyTagCount(const StringFilter& Stok_)
{
  if (_TagCntData && Stok_._TagCntData)
    _TagCntData->CopyTagCount(Stok_._TagCntData);
}

/****************************************************************************/
void StringFilter::DecrTagNesting()
{
  if (_TagCount && _TagCount[_TagListIndex][VALIDITY] == ACTIVE)
  {
    _TagCount[_TagListIndex][NESTING]--;
    _TagCount[_TagListIndex+1][NESTING]--;
  }
}

/****************************************************************************/
void StringFilter::ResetFilter(bool ResetNesting_)
{
  if (ResetNesting_)
  {
    _NestingLevel = _NestingMax;
    _NestingNo = 0;
    _Next = NULL;
  }

  _EndPt = 0;
  _StartPt = 0;

  _StartTagRow = 0;
  _StartTagEndPt = 0;
  _StartTagStartPt = 0;

  _EndTagRow = 0;
  _EndTagEndPt = 0;
  _EndTagStartPt = 0;

  _SavedIndex = 0;
  _SavedStream = NULL;

  _Buffer.StrFill(0, BUFSIZE);
}

/****************************************************************************/
StringFilter& StringFilter::operator = (const StringFilter& Stok_)
{
  if (this != &Stok_)
  {
    if (_MainFileName != Stok_._MainFileName)
    {
      ::DeleteArray(_MainFileName);
      _MainFileName = NULL;
    }

    if (_StartTag != Stok_._StartTag)
    {
      ::DeleteArray(_StartTag);
      _StartTag = NULL;
    }

    if (_StartTagEnd != Stok_._StartTagEnd)
    {
      ::DeleteArray(_StartTagEnd);
      _StartTagEnd = NULL;
    }

    if (_EndTag != Stok_._EndTag)
    {
      ::DeleteArray(_EndTag);
      _EndTag = NULL;
    }

    if (_EndTagEnd != Stok_._EndTagEnd)
    {
      ::DeleteArray(_EndTagEnd);
      _EndTagEnd = NULL;
    }

    if (_TempRec != Stok_._TempRec)
    {
      ::DeleteArray(_TempRec);
      _TempRec = NULL;
    }

    if (_Buffer.c_str() == Stok_._Buffer.c_str())
      _Buffer.StrFill(0, BUFSIZE);

    const char* Str_ = Stok_._StartTag;
    _StartTag = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_._StartTagEnd;
    _StartTagEnd = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_._MainFileName;
    _MainFileName = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_._EndTag;
    _EndTag = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_._EndTagEnd;
    _EndTagEnd = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_._TempRec;
    _TempRec = Str_ ? new_char_string(Str_):NULL;

    _InputMethod     = Stok_._InputMethod;
    _NestingLevel    = Stok_._NestingLevel;
    _NestingNo       = Stok_._NestingNo;
    _NestingMax      = Stok_._NestingMax;
    _TagEsc          = Stok_._TagEsc;
    _InTag           = Stok_._InTag;
    _TagEscCnt       = Stok_._TagEscCnt;
    _NonEscCnt       = Stok_._NonEscCnt;
    _BreakonStartTag = Stok_._BreakonStartTag;
    _BreakonEndTag   = Stok_._BreakonEndTag;
    _HaveTag         = Stok_._HaveTag;
    _HaveTagEsc      = Stok_._HaveTagEsc;

    _RowCnt          = Stok_._RowCnt;
    _ColCnt          = Stok_._ColCnt;
    _EndPt           = Stok_._EndPt;
    _StartPt         = Stok_._StartPt;
    _StartTagRow     = Stok_._StartTagRow;
    _StartTagEndPt   = Stok_._StartTagEndPt;
    _StartTagStartPt = Stok_._StartTagStartPt;
    _EndTagRow       = Stok_._EndTagRow;
    _EndTagEndPt     = Stok_._EndTagEndPt;
    _EndTagStartPt   = Stok_._EndTagStartPt;
    _IsHtmlTag       = Stok_._IsHtmlTag;
    _IsXHtmlTag      = Stok_._IsXHtmlTag;
    _IsXmlTag        = Stok_._IsXmlTag;
    _IsCppTag        = Stok_._IsCppTag;
    _IsCTag          = Stok_._IsCTag;
    _IsNonStdTag     = Stok_._IsNonStdTag;
    _IsSingletonTag  = Stok_._IsSingletonTag;
    _IsEmptyTag      = Stok_._IsEmptyTag;
    
    CopyTagCount(Stok_);

    if (_ColStk && Stok_._ColStk)
      *_ColStk = *Stok_._ColStk;

    if (_StrFoundStk && Stok_._StrFoundStk)
      *_StrFoundStk = *Stok_._StrFoundStk;
    
    _Buffer = Stok_._Buffer;    
    _Frp->Open(_MainFileName, ios::in);
  }

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetNestingLevel(int Level_)
{
  ClearNesting();
  _NestingLevel = Level_;  
  _NestingMax = Level_;
  _NestingNo = 0;

  int x;
  for (x = 0; x < TAGLIST_MAX_ENTRIES; x++)
    _TagCount[x][NESTING] = Level_;
  
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseHtmlTag(bool IsTag_)
{
  _IsHtmlTag = IsTag_;

  if (!_TagList &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    ResetTagList();

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseXHtmlTag(bool IsTag_)
{
  _IsXHtmlTag = IsTag_;

  if (!_TagList &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    ResetTagList();

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseXmlTag(bool IsTag_)
{
  _IsXmlTag = IsTag_;

  if (!_TagList &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    ResetTagList();

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseCppTag(bool IsTag_)
{
  _IsCppTag = IsTag_;

  if (!_TagList &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    ResetTagList();

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseCTag(bool IsTag_)
{
  _IsCTag = IsTag_;

  if (!_TagList &&
     (_IsHtmlTag || _IsXHtmlTag || _IsXmlTag || _IsCppTag || _IsCTag))
    ResetTagList();

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetParseNonStdTag(bool IsTag_)
{
  _IsNonStdTag = IsTag_;
  
  if (!_TagList && _IsNonStdTag)
    ResetTagList();
  
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetSingletonTag(bool IsSingle_, bool IsEmpty_)
{
  _IsSingletonTag = IsSingle_;
  _IsEmptyTag = IsEmpty_;

  return *this;
}

/****************************************************************************/
void StringFilter::SetTagType(int TagIndex_)
{
  if (TagIndex_ == NO_TAGTYPE)
    _IsNonStdTag = true;
  else
  {
    if (STD_DEX <= TagIndex_ && TagIndex_ <= SCRIPT_DEX && (TagIndex_ % 2) == 0)
      _IsXmlTag = true;

    if (DOCTYPE_DEX <= TagIndex_ && TagIndex_ <= SCRIPT_DEX && (TagIndex_ % 2) == 0)
    {
      _IsHtmlTag = _IsXHtmlTag = true;

      if (DOCTYPE_DEX <= TagIndex_ && TagIndex_ <= NESTEDCOMMENT2_DEX)
        _IsXmlTag = false;
    }

    if (!_IsXmlTag && !_IsHtmlTag)
    {
      if (COPENCOMMENTBLK_DEX <= TagIndex_ && TagIndex_ <= CCLOSECOMMENTBLK_DEX && (TagIndex_ % 2) == 0)
        _IsCTag = true;

      if (COPENCOMMENTBLK_DEX <= TagIndex_ && TagIndex_ <= CPPCOMMENTLINEOPEN_DEX && (TagIndex_ % 2) == 0)
      {
        _IsCppTag = true;

        if (TagIndex_ == CPPCOMMENTLINEOPEN_DEX)
          _IsCTag = false;
      }
    }
    else
      _IsCTag =
      _IsCppTag = false;
  }
}

/****************************************************************************/
StringFilter& StringFilter::SetStdTagSet(int TagSet_)
{
  if (TagSet_ == -1)
  {
    if (_IsNonStdTag)
      return *this;

    if (_IsHtmlTag || _IsXHtmlTag)
      TagSet_ = _IsHtmlTag ? HTML_TAGSET:XHTML_TAGSET;
    else if (_IsXmlTag)
      TagSet_ = XML_TAGSET;

    if (TagSet_ == -1)
    {
      if (_IsCppTag)
        TagSet_ = CPP_TAGSET;
      else if (_IsCTag)
        TagSet_ = C_TAGSET;
    }

    if (TagSet_ == -1)
      return *this;
  }

  if (TagSet_ == HTML_TAGSET || TagSet_ == XHTML_TAGSET)
    SetStdTagTypeHelper(DOCTYPE_TAG |
                        COMMENT_TAG |
                        NESTEDCOMMENT1_TAG |
                        NESTEDCOMMENT2_TAG |
                        STD_TAG |
                        END_TAG |
                        EMPTY_TAG |
                        SCRIPT_TAG, ACTIVE, DOCTYPE_TAG, SCRIPT_TAG);
  else if (TagSet_ == XML_TAGSET)
    SetStdTagTypeHelper(STD_TAG |
                        END_TAG |
                        EMPTY_TAG |
                        SCRIPT_TAG, ACTIVE, STD_TAG, SCRIPT_TAG);
  else if (TagSet_ == CPP_TAGSET)
    SetStdTagTypeHelper(COPENCOMMENTBLK_TAG |
                        CCLOSECOMMENTBLK_TAG |
                        CPPCOMMENTLINEOPEN_TAG, ACTIVE,
                        COPENCOMMENTBLK_TAG, CPPCOMMENTLINEOPEN_TAG);
  else if (TagSet_ == C_TAGSET)
    SetStdTagTypeHelper(COPENCOMMENTBLK_TAG |
                        CCLOSECOMMENTBLK_TAG, ACTIVE,
                        COPENCOMMENTBLK_TAG, CCLOSECOMMENTBLK_TAG);

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetStdTagType(int TagTypeBit_, int Active_)
{
  SetStdTagTypeHelper(TagTypeBit_, Active_, DOCTYPE_TAG, CPPCOMMENTLINEOPEN_TAG);
  return *this;
}

/****************************************************************************/
void StringFilter::SetStdTagTypeHelper(int TagTypeBit_, int Active_, int Lower_, int Upper_)
{
  int x;
  int TagIndex_;
  int EndBit_ = END_TAG;
  
  for (x = Lower_; x <= Upper_; x *= 2)
    if (x & TagTypeBit_)
    {
      if (TagTypeBit_ & CPPCOMMENTLINEOPEN_TAG)
      {      
        SetSingletonTag(true, false);
        EndBit_ = CPPCOMMENTLINEOPEN_TAG;
      }
      else if (TagTypeBit_ & COPENCOMMENTBLK_TAG)
      {
        SetSingletonTag(false, false);
        EndBit_ = CCLOSECOMMENTBLK_TAG;
      }
      else
      {
        if (TagTypeBit_ & STD_TAG)
        {
          SetSingletonTag(false, false);
          EndBit_ = END_TAG;
        }
        else
        {
          SetSingletonTag(true, x == EMPTY_TAG);
          EndBit_ = x;
        }
      }
      
      SetStringTagsHelper(NULL, NULL, NULL, NULL,
                          x, EndBit_, false);

      if (_IsNonStdTag)
        SetParseNonStdTag(true);
      else
      {
        if (_IsHtmlTag || _IsXHtmlTag)
        {
          if (_IsHtmlTag)
            SetParseHtmlTag(true);

          if (_IsXHtmlTag)
            SetParseXHtmlTag(true);
        }
        else if (_IsXmlTag)
          SetParseXmlTag(true);

        if (!_IsHtmlTag && !_IsXHtmlTag)
        {
          if (_IsCppTag)
            SetParseCppTag(true);
          else if (_IsCTag)
            SetParseCTag(true);
        }
      }

      TagIndex_ = TagTypeBitToIndex(x);
      _TagCount[TagIndex_][SFTagEnums::VALIDITY] =
      _TagCount[TagIndex_+1][SFTagEnums::VALIDITY] = Active_;

      if ((TagTypeBit_ & CPPCOMMENTLINEOPEN_TAG) || !(TagTypeBit_ & STD_TAG))
      {
        _TagCount[TagIndex_][SFTagEnums::TAGATTR] =
        _TagCount[TagIndex_+1][SFTagEnums::TAGATTR] = SINGLETON_TAGATTR;
      }
    }
}

/****************************************************************************/
StringFilter& StringFilter::DeleteTagList(int TagTypeBit_)
{
  int TagIndex_ = TagTypeBitToIndex(TagTypeBit_);

  if (!_TagList)
    ResetTagList();

  _TagCntData->DeleteTagList(TagIndex_);
  return *this;
}

/****************************************************************************/
SFTagElement* StringFilter::AddStringTag(int TagPos_, const char* Tag_, const char* TagEnder_,
                                       SFTagElement* MatchingTag_, int TagTypeBit_)
{
  if (TagPos_ == 0 && Tag_)
  {
    if (TagTypeBit_ == MATCH_TAGTYPE)
    {
      if (_TagType & CPPCOMMENTLINEOPEN_TAG)
        _EndTagType = CPPCOMMENTLINEOPEN_TAG;
      else if (_TagType & COPENCOMMENTBLK_TAG)
        _EndTagType = CCLOSECOMMENTBLK_TAG;
      else
      {
        if (_TagType & STD_TAG)
          _EndTagType = END_TAG;
        else
          _EndTagType = TagTypeBit_;
      }
    }
    else
    {
      if (TagTypeBit_ == NO_TAGTYPE)
        _EndTagType = NO_TAGTYPE;
      else
        _EndTagType = TagTypeBit_;
    }
  }

  int x;
  int TagIndex_ = (TagPos_ == 1) ? TagTypeBitToIndex(TagTypeBit_):0;
  int EndTagIndex_ = (TagPos_ == 0) ?
                        ((TagTypeBit_ == MATCH_TAGTYPE) ?
                            TagTypeBitToIndex(_EndTagType):
                            TagTypeBitToIndex(TagTypeBit_)):0;

  if (!_TagList)
    ResetTagList();

  SFTagElement* ElementNode_ = NULL;
    
  if (TagPos_ == 1 && Tag_)
  {
    SetTagType(TagIndex_);
    SetStdTagSet();

    ElementNode_ = _TagCntData->AddToTagList(TagPos_, Tag_, TagEnder_, MatchingTag_, TagIndex_);
  }
  else if (TagPos_ == 0 && Tag_ && MatchingTag_)
    ElementNode_ = _TagCntData->AddToTagList(TagPos_, Tag_, TagEnder_, MatchingTag_, EndTagIndex_);

  return ElementNode_;
}

/****************************************************************************/
StringFilter& StringFilter::SetStringTags(const char* Start_, const char* StartEnder_,
                                          const char* End_, const char* EndEnder_,
                                          int TagTypeBit_, int EndTagTypeBit_)
{
  int TagIndex_ = Start_ ? TagTypeBitToIndex(TagTypeBit_):0;

  if (Start_)
    SetTagType(TagIndex_);

  if (_IsNonStdTag)
    SetParseNonStdTag(true);
  else
  {
    if (_IsHtmlTag || _IsXHtmlTag)
    {
      if (_IsHtmlTag)
        SetParseHtmlTag(true);

      if (_IsXHtmlTag)
        SetParseXHtmlTag(true);
    }
    else if (_IsXmlTag)
      SetParseXmlTag(true);

    if (!_IsHtmlTag && !_IsXHtmlTag)
    {
      if (_IsCppTag)
        SetParseCppTag(true);
      else if (_IsCTag)
        SetParseCTag(true);
    }
  }

  SetStringTagsHelper(Start_, StartEnder_, End_, EndEnder_,
                      TagTypeBit_, EndTagTypeBit_, true);
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::ClearTagType(bool ClearParseFlags_)
{
  _TagType = NO_TAGTYPE;

  if (ClearParseFlags_)
    _IsHtmlTag =
    _IsXHtmlTag =
    _IsXmlTag =
    _IsCppTag =
    _IsCTag =
    _IsNonStdTag =
    _IsSingletonTag =
    _IsEmptyTag =
    _SingletonTagAllowed =
    _EmptyTagAllowed = false;

  return *this;
}

/****************************************************************************/
int StringFilter::TagTypeBitToIndex(int TagTypeBit_)
{
  return
  (
    (TagTypeBit_ & DOCTYPE_TAG)            ? DOCTYPE_DEX:
    (TagTypeBit_ & COMMENT_TAG)            ? COMMENT_DEX:
    (TagTypeBit_ & NESTEDCOMMENT1_TAG)     ? NESTEDCOMMENT1_DEX:
    (TagTypeBit_ & NESTEDCOMMENT2_TAG)     ? NESTEDCOMMENT2_DEX:
    (TagTypeBit_ & STD_TAG)                ? STD_DEX:
    (TagTypeBit_ & END_TAG)                ? END_DEX:
    (TagTypeBit_ & EMPTY_TAG)              ? EMPTY_DEX:
    (TagTypeBit_ & SCRIPT_TAG)             ? SCRIPT_DEX:
    (TagTypeBit_ & COPENCOMMENTBLK_TAG)    ? COPENCOMMENTBLK_DEX:
    (TagTypeBit_ & CCLOSECOMMENTBLK_TAG)   ? CCLOSECOMMENTBLK_DEX:
    (TagTypeBit_ & CPPCOMMENTLINEOPEN_TAG) ? CPPCOMMENTLINEOPEN_DEX:
                                             NO_TAGTYPE
  );
}

/****************************************************************************/
bool StringFilter::SetStringTagsHelper(const char* Start_, const char* StartEnder_,
                                       const char* End_, const char* EndEnder_,
                                       int TagTypeBit_, int EndTagTypeBit_,
                                       bool SetTagStrings_)
{
  if (Start_)
  {
    if (TagTypeBit_ == NO_TAGTYPE)
      _TagType = NO_TAGTYPE;
    else if (TagTypeBit_ != MATCH_TAGTYPE)
      _TagType |= TagTypeBit_;
  }

  if (End_)
    if (EndTagTypeBit_ == MATCH_TAGTYPE)
    {
      if (_TagType & CPPCOMMENTLINEOPEN_TAG)
        _EndTagType = CPPCOMMENTLINEOPEN_TAG;
      else if (_TagType & COPENCOMMENTBLK_TAG)
        _EndTagType = CCLOSECOMMENTBLK_TAG;
      else
      {
        if (_TagType & STD_TAG)
          _EndTagType = END_TAG;
        else
          _EndTagType = EndTagTypeBit_;
      }
    }
    else
    {
      if (EndTagTypeBit_ == NO_TAGTYPE)
        _EndTagType = NO_TAGTYPE;
      else
        _EndTagType = EndTagTypeBit_;
    }
    
  int TagIndex_ = Start_ ? TagTypeBitToIndex(TagTypeBit_):0;
  int EndTagIndex_ = End_ ?
                     ((EndTagTypeBit_ == MATCH_TAGTYPE) ?
                         TagTypeBitToIndex(_EndTagType):
                         TagTypeBitToIndex(EndTagTypeBit_)):0;

  // Tag types are determined by the starting tag
  if (Start_)
    SetTagType(TagIndex_);

  if (SetTagStrings_)
  {
    if (Start_ && _StartTag != Start_)
    {
      ::DeleteArray(_StartTag);
      _StartTag = NULL;
    }

    if (StartEnder_ && _StartTagEnd != StartEnder_)
    {
      ::DeleteArray(_StartTagEnd);
      _StartTagEnd = NULL;
    }

    if (End_ && _EndTag != End_)
    {
      ::DeleteArray(_EndTag);
      _EndTag = NULL;
    }

    if ((_IsNonStdTag || _IsCppTag || _IsCTag) &&
        EndEnder_ && _EndTagEnd != EndEnder_)
    {
      ::DeleteArray(_EndTagEnd);
      _EndTagEnd = NULL;
    }

    if (TagIndex_ == NO_TAGTYPE)
    {
      // No standard form tag type:
      //   for starting tags:  <startag,  startender>
      //   for ending tags:  <endtag,  endender>
      //
      _StartTag = Start_ ? new_char_string(Start_):NULL;
      _EndTag = End_ ? new_char_string(End_):NULL;

      _StartTagEnd = StartEnder_ ? new_char_string(StartEnder_):NULL;
      _EndTagEnd = ((_IsNonStdTag || _IsCppTag || _IsCTag) && EndEnder_) ? new_char_string(EndEnder_):NULL;
    }
    else if (DOCTYPE_DEX <= TagIndex_ && TagIndex_ <= SCRIPT_DEX && (TagIndex_ % 2) == 0)
    {
      ChrString Temp_;

      if (Start_)
      {
        // predefined tag types:
        //   for starting tags:
        //     As start tag beginning indicator: <_TagList[TagIndex_]>
        //     As start tag name: <Start_>
        //     As start tag ending indicator: <_TagList[TagIndex_+1]>
        //
        //   final form: Starttag:    <_TagList[TagIndex_]><Start_> ...
        //               StarttagEnd: ... <_TagList[TagIndex_+1]>
        //      
        Temp_ = _TagList[TagIndex_];
        Temp_ += ChrString(Start_);
      
        _StartTag = new_char_string(Temp_.c_str());
        _StartTagEnd = new_char_string(_TagList[TagIndex_+1]);
      }

      if (!_IsSingletonTag && End_)
        if (_IsNonStdTag || _IsCppTag || _IsCTag)
        {
          // non-standard or C/C++ tag types:
          //   for ending tags:
          //     As end tag beginning indicator: <_TagList[EndTagIndex_]>
          //     As end tag name: <End_>
          //     As end tag ending indicator: <_TagList[TagIndex_+1]>
          //
          //   final form: Endtag:    <_TagList[EndTagIndex_]><End_> ...
          //               EndtagEnd: ... <_TagList[EndTagIndex_+1]>
          //          
          Temp_ = _TagList[EndTagIndex_];
          Temp_ += ChrString(End_);
        
          _EndTag = new_char_string(Temp_.c_str());
          _EndTagEnd = new_char_string(_TagList[EndTagIndex_+1]);
        }
        else
        {
          // predefined tag types:
          //   for ending tags:
          //     As end tag beginning indicator: <_TagList[EndTagIndex_]>
          //     As end tag name: <End_>
          //     As end tag ending indicator: <_TagList[TagIndex_+1]>
          //
          //   final form: Endtag:    <_TagList[EndTagIndex_]><End_>
          //                          <_TagList[EndTagIndex_+1]>
          //               EndtagEnd: NULL
          //
          Temp_ = _TagList[EndTagIndex_];
          Temp_ += ChrString(End_);
          Temp_ += ChrString(_TagList[EndTagIndex_+1]);
        
          _EndTag = new_char_string(Temp_.c_str());
          _EndTagEnd = NULL;
        }
    }
  }

  return true;
}

/****************************************************************************/
StringFilter& StringFilter::SetTagsEscChar(char Ch_)
{
  // The string tag escape char cannot be included within
  // the set of the start tag characters specified
  if (_TagEsc && (InCharSet(_TagEsc, _StartTag) ||
                 (_StartTagEnd && InCharSet(_TagEsc, _StartTagEnd))))
    return *this;

  // The string tag escape char cannot be included within
  // the set of the end tag characters specified
  if (_TagEsc && (InCharSet(_TagEsc, _EndTag) ||
                 (_EndTagEnd && InCharSet(_TagEsc, _EndTagEnd))))
    return *this;

  _TagEsc = Ch_;
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetTempString(const char* Str_, Boolean Erase_, long len)
{
  if (_TempRec == Str_)
    return *this;

  if (Str_)
  {
    if (Erase_ || !_TempRec || (len && len > FLDSIZE - 2))
    {
      ::DeleteArray(_TempRec);
      if (!len || len <= FLDSIZE - 2)
        len = FLDSIZE;
      else
        len += 2;

      _TempRec = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * len);
    }
    else
      len = FLDSIZE;

    strncpy(_TempRec, Str_, len-1);
    _TempRec[len-1] = 0;
    RemovePadding(_TempRec, " \t\n");

    _Tindex = 0;
    _Tlength = ::SafeStrLen(_TempRec);
  }
  else
  {
    ::DeleteArray(_TempRec);
    _TempRec = NULL;
    _Tindex = _Tlength = 0;
  }

  return *this;
}

/****************************************************************************/
int StringFilter::GetchTempStr()
{
  if (_Tindex < _Tlength)
  {
    int ret_ = _TempRec[_Tindex++];
    return ret_;
  }

  return 0;
}

/****************************************************************************/
int StringFilter::PeekchTempStr()
{
  if (_Tindex < _Tlength)
  {
    int ret_ = _TempRec[_Tindex];
    return ret_;
  }

  return 0;
}

/****************************************************************************/
int StringFilter::PutBackTempStr()
{
  int ret_ = 0;
  if (_Tindex)
    ret_ = _TempRec[--_Tindex];

  return ret_;
}

/****************************************************************************/
int StringFilter::ExtractUntil(char* InputStr_, short InputLen_,
                              const char* CharSet_, Boolean InSet_,
                              Boolean PutBack_)
{
  if (InputStr_ && CharSet_)
  {
    // The tag escape char cannot be included within
    // the set of the tag characters specified
    if (_TagEsc && InCharSet(_TagEsc, CharSet_))
      return false;

    short x, len;
    bool StopCond_ = false;
    bool Found_ = false;
    len = InputLen_ - 1;

    _TagEscCnt =
    _NonEscCnt = 0;

    for (x = 0; x < len; x++)
    {
      InputStr_[x] = GetchTempStr();
      if (!InputStr_[x])
        break;

      if (_TagEsc)
        if (InputStr_[x] == _TagEsc)
        {
          if (_NonEscCnt)
            _TagEscCnt = 1;
          else
            ++_TagEscCnt;

          _NonEscCnt = 0;
        }
        else
        {
          if (_NonEscCnt >= 1)
            _NonEscCnt =
            _TagEscCnt = 0;
          else
            ++_NonEscCnt;
        }

      Found_ = (InSet_ && InCharSet(InputStr_[x], CharSet_)) ||
               (!InSet_ && !InCharSet(InputStr_[x], CharSet_));

      if (InSet_)
      {
        _HaveTagEsc = _HaveTag = false;
        StopCond_ = (_TagEsc && x > 0 && _TagEscCnt % 2) ?
           !(_HaveTagEsc=(InputStr_[x-1] == _TagEsc)):true;
        _HaveTag = Found_;
        StopCond_ = StopCond_ && _HaveTag;
      }
      else
        StopCond_ = Found_;

      if (StopCond_)
      {
        if (PutBack_)
          PutBackTempStr();
        break;
      }
    }

    InputStr_[x] = 0;
    return strlen(InputStr_);
  }

  return 0;
}

/****************************************************************************/
int StringFilter::ExtractUntil(char* InputStr_, short InputLen_,
                              int(*iscsetfn)(int), Boolean InSet_,
                              Boolean PutBack_)
{
  if (InputStr_ && iscsetfn)
  {
    // The tag escape char cannot be included within
    // the set of the tag characters specified
    if (_TagEsc && (*iscsetfn)(_TagEsc))
      return false;

    short x, len;
    bool StopCond_ = false;
    bool Found_ = false;
    len = InputLen_ - 1;

    _TagEscCnt =
    _NonEscCnt = 0;

    for (x = 0; x < len; x++)
    {
      InputStr_[x] = GetchTempStr();
      if (!InputStr_[x])
        break;

      if (_TagEsc)
        if (InputStr_[x] == _TagEsc)
        {
          if (_NonEscCnt)
            _TagEscCnt = 1;
          else
            ++_TagEscCnt;

          _NonEscCnt = 0;
        }
        else
        {
          if (_NonEscCnt >= 1)
            _NonEscCnt =
            _TagEscCnt = 0;
          else
            ++_NonEscCnt;
        }

      Found_ = (InSet_ && (*iscsetfn)(InputStr_[x])) ||
               (!InSet_ && !(*iscsetfn)(InputStr_[x]));

      if (InSet_)
      {
        _HaveTagEsc = _HaveTag = false;
        StopCond_ = (_TagEsc && x > 0 && _TagEscCnt % 2) ?
           !(_HaveTagEsc=(InputStr_[x-1] == _TagEsc)):true;
        _HaveTag = Found_;
        StopCond_ = StopCond_ && _HaveTag;
      }
      else
        StopCond_ = Found_;

      if (StopCond_)
      {
        if (PutBack_)
          PutBackTempStr();
        break;
      }
    }

    InputStr_[x] = 0;
    return strlen(InputStr_);
  }

  return 0;
}

/****************************************************************************/
void StringFilter::CountColsRows(const char* Buf_, long Len_, const char* Delim_)
{
  int x;
  for (x = 0; x < Len_; x++)
    CountColsRows(Buf_[x]);

  if (Delim_)
    CountColsRows(*Delim_);
}

/****************************************************************************/
void StringFilter::CountColsRows(const char* Buf_, const char* Delim_)
{
  if (Buf_ && Delim_)
  {
    size_t x;
    size_t len = strlen(Buf_);
  
    if (*Delim_ == '\n')
    {
      if (_ColCnt || _RowCnt)
      {
        _RowCnt++;
        _ColStk->Push(new long(_ColCnt));
        _ColCnt = 0;
      }
        
      for (_ColCnt = 0; _ColCnt < len; _ColCnt++)
        CountColsRows(Buf_[_ColCnt]);
    }
    else
    {
      for (x = 0; x < len; x++)
        CountColsRows(Buf_[x]);

      CountColsRows(*Delim_);
    }
  }
}

/****************************************************************************/
char StringFilter::CountColsRows(char ch)
{
  if (ch != 0)
    if (ch == '\n')
    {
      _RowCnt++;
      _ColStk->Push(new long(_ColCnt));
      _ColCnt = 0;
    }
    else
      _ColCnt++;

  return ch;
}

/****************************************************************************/
char StringFilter::UnCountColsRows(char ch)
{
  long* valp_ = NULL;
  
  if (ch != 0)
    if (ch == '\n')
    {
      _RowCnt--;
      valp_ = _ColStk->Pop();
      
      if (valp_)
      {
        _ColCnt = *valp_;
        ::Delete(valp_);
      }
    }
    else
      _ColCnt--;

  return ch;
}

/****************************************************************************/
int StringFilter::GetTxtLine(const char* Delim_, FileReader* FileRp_, char* StrBuf_, int StrBufSz_)
{
  char* Buffer_ = StrBuf_ ? StrBuf_:_Buffer.c_str();
  int BufSz_ = StrBuf_ ? StrBufSz_:(_Buffer.TotalSize() - 1);
  FileReader* Frp_ = FileRp_ ? FileRp_:_Frp;

  if (!Frp_)
    return 0;

  if (Frp_->EndOfFile())
    return 0;

  int ret_ = Frp_->ReadLine(Buffer_, BufSz_, Delim_).GetCount() != 0;
  long x, len;

  // we don't care about overruning delimiters as long as it fits
  // into the buffer we can ignore the rest of the input.
  if (!Frp_->EndOfFile())
  {
    Frp_->ClearState();
    Frp_->GetInStream().clear(ios::goodbit);
  }

  ret_ = Frp_->GetCount();

  if (!StrBuf_)
  {
    ::RemoveTrailing(Buffer_, " \t");
    len = strlen(Buffer_);
  }
  else
  {
    _Buffer = Buffer_;
    _Buffer.RemoveTrailing(" \t");
    len = _Buffer.strlen();
  }

  // skipping trailing spaces
  for (x = len-1; x >= 0; x--)
    if (!isspace(Buffer_[x]))
      break;

  if (!StrBuf_)
  {
    Fallible<Subscript> Index_ = _Buffer.findprevious(x, _EndLineDelim);

    if (Index_.valid())
    {
      _EndLine = _Buffer.subString(Index_ + 1);
      _EndLine.RemoveTrailing(" \t");
    }

    if (_LineToFind.strlen())
      _LineFound = _Buffer.StrniComp(_LineToFind, _LineToFind.strlen()) == 0;
  }

  return ret_;
}

/****************************************************************************/
bool StringFilter::FindStringTag(SFTagElement* ElementNode_, int SeqType_, bool IndexSpecified_,
                                 long StartPoint_, long EndPoint_, int TagIndex_)
{
  if (!ElementNode_)
    return false;

  SFStringFoundData* StrDataNode_ = NULL;
  ChrString TagStr_ = ElementNode_->TagName();
  long EndPt_;
  bool Found_ = false;  
  bool NotFound_ = true;

  size_t xpt = 0;
  size_t min = 0;
  size_t slen;
  size_t tlen = TagStr_.strlen();

  if (SeqType_ == SFTagEnums::OPENING)
  {
    if (EndPoint_)
    {
      if (NotFound_)
      {
        xpt = TagIndex_ - 1;
        slen = ::SafeStrLen(_TagList[xpt]);

        for (_StartPt = EndPoint_;
             _StartPt >= 0 && tlen <= ::strlen(_Buffer(_StartPt)) &&
             (NotFound_ = strncmp(_Buffer(_StartPt), TagStr_.c_str(), tlen) != 0) &&
             strncmp(_Buffer(_StartPt), _TagList[xpt], slen) != 0;
             _StartPt--);

        Found_ = !NotFound_;

        if (Found_)
        {
          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
        }
      }
    }
    else if (StartPoint_)
    {
      while (NotFound_)
      {
        xpt = TagIndex_ + 1;
        slen = ::SafeStrLen(_TagList[xpt]);

        for (_EndTagStartPt = StartPoint_;
             _Buffer[_EndTagStartPt] && tlen <= ::strlen(_Buffer(_EndTagStartPt)) &&
             (NotFound_ = strncmp(_Buffer(_EndTagStartPt), TagStr_.c_str(), tlen) != 0);
             _EndTagStartPt++);

        Found_ = !NotFound_;

        if (Found_)
        {
          if (strncmp(_Buffer(_EndTagStartPt+tlen-slen), _TagList[xpt], slen) == 0)
          {
            _EndTagEndPt = _EndTagStartPt + tlen;
            NotFound_ = false;
          }
          else
          {
            for (_EndTagEndPt = _EndTagStartPt;
                 _Buffer[_EndTagEndPt] && slen <= ::strlen(_Buffer(_EndTagEndPt)) &&
                 (NotFound_ = strncmp(_Buffer(_EndTagEndPt), _TagList[xpt], slen) != 0);
                 _EndTagEndPt++);
          }

          Found_ = !NotFound_;

          if (Found_)
          {
            ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
            Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
            break;
          }
        }

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);
          
          if (ElementNode_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            TagStr_ = ElementNode_->TagName();
            tlen = TagStr_.strlen();

            delete StrDataNode_;
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          }
          else
            break;
        }
        else
          break;
      }
    }
  }
  else if (SeqType_ == SFTagEnums::CLOSING)
  {
    if (EndPoint_)
    {
      while (NotFound_)
      {
        EndPt_ = _StartTagEndPt;
        --EndPoint_;
        xpt = TagIndex_ - 1;
        slen = ::SafeStrLen(_TagList[xpt]);

        for (;_StartTagEndPt >= EndPoint_ &&
            (NotFound_ = strncmp(_Buffer(_StartTagEndPt), TagStr_.c_str(), tlen) != 0) &&
            strncmp(_Buffer(_StartTagEndPt), _TagList[xpt], slen) != 0;
            _StartTagEndPt--);

        Found_ = !NotFound_ && _StartTagEndPt == _StartTagStartPt;
        _StartTagEndPt = EndPt_;

        if (Found_)
        {
          _EndPt = _StartTagEndPt;
          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
          break;
        }
        else if (IndexSpecified_)
          break;

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);

          if (ElementNode_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            TagStr_ = ElementNode_->TagName();
            tlen = TagStr_.strlen();

            delete StrDataNode_;
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          }
          else
            break;
        }
        else
          break;
      }
    }
    else if (StartPoint_)
    {
      while (NotFound_)
      {
        for (_EndTagStartPt = StartPoint_; _EndTagStartPt >= 0 &&
             (NotFound_ = strncmp(_Buffer(_EndTagStartPt), TagStr_.c_str(), tlen) != 0);
             _EndTagStartPt--);

        _StartPt = (_EndTagStartPt >= 0) ? _EndTagStartPt:0;
        Found_ = !NotFound_;

        if (Found_)
        {
          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
          break;
        }
        else if (IndexSpecified_)
          break;

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);

          if (ElementNode_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            TagStr_ = ElementNode_->TagName();
            tlen = TagStr_.strlen();

            delete StrDataNode_;
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          }
          else
            break;
        }
        else
          break;
      }
    }
  }

  return Found_;
}

/****************************************************************************/
// PURPOSE:
//   Method to execute tag find procedures according to specified paramenters
//   relating to the procedure number, tag type and sequence type.
//
//   All specified tag types are searched for including html, xml, meta and
//   other kinds of tags.
//
// PRE:
//   long pos : Position in the text line where the starting tag is found.
//   int TagType_ : Tag type whether starting or closing: 1. open, 0. close
//   int SeqType_ : Tag Search sequence type: 1. initial search
//                                            0. final search
//   int SpecIndex_ : Specified tag index (not used if -1)
//
// POST:
//   returns if the specified active/inactive tag types were found
//
bool StringFilter::FindTagPoints(long pos, int TagType_, int SeqType_, int SpecIndex_)
{
  ///////////////////////////////////
  // Used By ReadUntilFound method //
  ///////////////////////////////////

  int x;
  int StartTagx_ = -1;
  size_t len, tlen, slen;
  ChrString TagStr_;
  SFStringFoundData* StrDataNode_;
  SFTagFoundData* TagDataNode_;
  SFTagElement* ElementNode_;
  long SavedEndTagStart_ = 0;
  long SavedEndTagEnd_ = 0;

  long EndPoint_;
  long StartPoint_;
  bool IndexSpecified_ = SpecIndex_ >= 0;
  bool Found_ = false;
  bool NotFound_ = true;
  bool HasStrTag_ = false;
  bool StdTags_ = IsStdTagType();
  bool IsStartTag_ = false;

  if (StdTags_)
  {
    if (SeqType_ == SFTagEnums::OPENING)
    {
      if (TagType_ == SFTagEnums::CLOSING)
      {
        x = SpecIndex_;
        if (x % 2)
          --x;

        if (x < 0)
          x = 0;

        for (HasStrTag_ = false; x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          // Find indicated active and inactive tag start/end points
          IsStartTag_ = false;
          slen = ::SafeStrLen(_TagList[x]);
          tlen = 0;

          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
            continue;
          else
            _TagCntData->ResetTagListIndex(x);

          // Find indicated active and inactive tag start/end points
          SavedEndTagStart_ = _EndTagStartPt;
          SavedEndTagEnd_ = _EndTagEndPt;
          
          _EndTagStartPt = pos;
          _EndTagEndPt = _EndPt;

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = _TagCntData->GetNextSFTagElement(x);

            if (ElementNode_)
            {
              ElementNode_ = ElementNode_->GiveMatchingTag();

              if (ElementNode_)
                if (!ElementNode_->IsStartTag())
                {
                  TagStr_ = ElementNode_->TagName();
                  tlen = TagStr_.strlen();
                  HasStrTag_ = true;
                }
                else
                {
                  TagStr_ = _TagList[x];
                  ElementNode_ = NULL;
                  tlen = 0;
                  IsStartTag_ = true;
                }
            }

            if ((!IsStartTag_ || IndexSpecified_) && (!tlen || !ElementNode_))
              break;
            else if (IndexSpecified_ || HasStrTag_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::CLOSING) - 1;
              slen = ::SafeStrLen(_TagList[x]);
            }
          }
          else
            TagStr_ = _TagList[x];

          if (slen <= ::strlen(_Buffer(_EndTagStartPt)) &&
              tlen <= ::strlen(_Buffer(_EndTagStartPt)) &&
             (NotFound_ = strncmp(_Buffer(_EndTagStartPt), _TagList[x], slen) != 0))  // '<'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
            StartPoint_ = _EndTagStartPt;

            for (_EndTagStartPt = _EndTagEndPt-slen; _EndTagStartPt >= 0 &&
                 _Buffer[_EndTagStartPt] && slen <= ::strlen(_Buffer(_EndTagStartPt)) &&
                (NotFound_ = strncmp(_Buffer(_EndTagStartPt), _TagList[x], slen) != 0);
                _EndTagStartPt--);

            Found_ = !NotFound_;
            
            if (Found_)
            {
              StartPoint_ = _EndTagStartPt;
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, StartPoint_, 0, x);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            StartPoint_ = _EndTagStartPt;
            Found_ = !NotFound_;

            if (Found_)
            {
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, StartPoint_, 0, x);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if ((_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 || IsStartTag_) && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (Found_)
          {
            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
            _TagSeqType = CLOSING;
            StrDataNode_ = NULL;
            break;
          }
          else
          {
            StrDataNode_ = _StrFoundStk->Pop();
            StrDataNode_->Restore(this);
            delete StrDataNode_;

            _EndTagStartPt = SavedEndTagStart_;
            _EndTagEndPt = SavedEndTagEnd_;

            if (_EndTagStartPt < 0)
              _EndTagStartPt = 0;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = _StrFoundStk->Pop();
          delete StrDataNode_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        return Found_;
      }

      if (TagType_ == SFTagEnums::OPENING)
      {
        HasStrTag_ = false;
        for (x = 0; x < TAGLIST_LENGTH && _TagList[x+1]; x+=2)
        {
          // Find indicated active and inactive tag start/end points
          slen = ::SafeStrLen(_TagList[x+1]);
          tlen = 0;

          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen ||
              x == SFTagEnums::END_DEX)
            continue;
          else
            _TagCntData->ResetTagListIndex(x);
            
          // Find indicated active and inactive tag start/end points
          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = _TagCntData->GetNextSFTagElement(x);

            if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;
            }
            else
              break;
          }
          else
            TagStr_ = _TagList[x+1];

          if (slen <= ::strlen(_Buffer(_EndPt-1)) &&
              tlen <= ::strlen(_Buffer(_EndPt-1)) &&
             (NotFound_ = strncmp(_Buffer(_EndPt-1), _TagList[x+1], slen) != 0))  // '>'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            for (EndPoint_ = _EndPt; _Buffer[_EndPt] && slen <= ::strlen(_Buffer(_EndPt)) &&
                (NotFound_ = strncmp(_Buffer(_EndPt), _TagList[x+1], slen) != 0);
                _EndPt++);

            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, 0, _EndPt-tlen, x+1);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            EndPoint_ = _EndPt-tlen;
            Found_ = !NotFound_;

            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, 0, EndPoint_, x+1);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (Found_)
          {
            _StartTagStartPt = _StartPt;
            _StartTagEndPt = _EndPt;

            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            _TagListIndex = x;
            _TagSeqType = OPENING;
            StrDataNode_ = NULL;
            break;
          }
          else
          {
            StrDataNode_ = _StrFoundStk->Pop();
            StrDataNode_->Restore(this);
            delete StrDataNode_;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = _StrFoundStk->Pop();
          delete StrDataNode_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        return Found_;
      }
    }

    if (SeqType_ == SFTagEnums::CLOSING)
    {
      if (TagType_ == SFTagEnums::OPENING)
      {
        HasStrTag_ = false;
        for (x = IndexSpecified_ ? ((SpecIndex_ % 2) ? SpecIndex_-1:SpecIndex_):0;
             x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          IsStartTag_ = false;
          slen = ::SafeStrLen(_TagList[x]);
          tlen = 0;
          
          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
          {
            if (IndexSpecified_)
              break;
            else
              continue;
          }
          else
          {
            if (IndexSpecified_)
              _TagCntData->SetTagListIndex(x, _TagCount[x][SFTagEnums::TAGINDEX]);
            else
              _TagCntData->ResetTagListIndex(x);
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = IndexSpecified_ ? _TagCntData->GetCurrentSFTagElement(x):
                                             _TagCntData->GetNextSFTagElement(x);

            if (IndexSpecified_ && ElementNode_)
            {
              ElementNode_ = ElementNode_->GiveMatchingTag();

              if (ElementNode_)
                if (!ElementNode_->IsStartTag())
                {
                  TagStr_ = ElementNode_->TagName();
                  tlen = TagStr_.strlen();
                  HasStrTag_ = true;
                }
                else
                {
                  TagStr_ = _TagList[x];
                  ElementNode_ = NULL;
                  tlen = 0;
                  IsStartTag_ = true;
                }
            }
            else if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;
            }

            if ((!IsStartTag_ || IndexSpecified_) && (!tlen || !ElementNode_))
              break;
            else if (IndexSpecified_ || HasStrTag_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::OPENING);
              slen = ::SafeStrLen(_TagList[x]);
            }
          }
          else
            TagStr_ = _TagList[x];

          if (slen <= ::strlen(_Buffer(_StartPt)) &&
              tlen <= ::strlen(_Buffer(_StartPt)) &&
              (NotFound_ = strncmp(_Buffer(_StartPt), _TagList[x], slen) != 0))  // '<'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _EndTagStartPt = _EndTagEndPt - 1;
            if (_EndTagStartPt < 0)
              break;
            
            for (StartPoint_ = _EndTagStartPt; _EndTagStartPt >= 0 &&
                 (NotFound_ = strncmp(_Buffer(_EndTagStartPt), _TagList[x], slen) != 0);
                 _EndTagStartPt--);

            _StartPt = (_EndTagStartPt >= 0) ? _EndTagStartPt:0;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, StartPoint_, 0, x);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _EndTagStartPt = _StartPt;
            StartPoint_ = _StartPt;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, StartPoint_, 0, x);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if ((_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 || IsStartTag_) && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (!Found_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            StrDataNode_->Restore(this);
            delete StrDataNode_;

            if (IndexSpecified_)
              break;
          }
          else
          {
            if (!IndexSpecified_)
            {
              _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
              _TagSeqType = OPENING;
            }

            break;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = _StrFoundStk->Pop();
          delete StrDataNode_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        return Found_;
      }

      if (TagType_ == SFTagEnums::CLOSING)
      {
        HasStrTag_ = false;
        for (x = IndexSpecified_ ? ((SpecIndex_ % 2) ? SpecIndex_-1:SpecIndex_):0;
             x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          slen = ::SafeStrLen(_TagList[x+1]);
          tlen = 0;
          
          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
          {
            if (IndexSpecified_)
              break;
            else
              continue;
          }
          else
          {
            if (IndexSpecified_)
              _TagCntData->SetTagListIndex(x, _TagCount[x][SFTagEnums::TAGINDEX]);
            else
              _TagCntData->ResetTagListIndex(x);
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = IndexSpecified_ ? _TagCntData->GetCurrentSFTagElement(x):
                                             _TagCntData->GetNextSFTagElement(x);

            if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;
            }

            if (!tlen || !ElementNode_)
              break;
            else if (IndexSpecified_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::CLOSING) - 1;
              slen = ::SafeStrLen(_TagList[x+1]);
            }
          }
          else
            TagStr_ = _TagList[x+1];

          if (_EndPt >= slen && slen <= ::strlen(_Buffer(_EndPt-slen)) &&
              tlen <= ::strlen(_Buffer(_EndPt-slen)) &&
              (NotFound_ = strncmp(_Buffer(_EndPt-slen), _TagList[x+1], slen) != 0))  // '>'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _StartTagEndPt = _StartTagStartPt + 1;
            if (!_Buffer[_StartTagStartPt])
              break;

            for (EndPoint_ = _StartTagEndPt; _Buffer[_StartTagEndPt] && slen <= ::strlen(_Buffer(_StartTagEndPt)) &&
                (NotFound_ = strncmp(_Buffer(_StartTagEndPt), _TagList[x+1], slen) != 0);
                _StartTagEndPt++);

            Found_ = !NotFound_;
            if (Found_)
              ++_StartTagEndPt;

            _EndPt = _StartTagEndPt;

            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, 0, EndPoint_, x+1);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _StartTagEndPt = _EndPt;
            EndPoint_ = _StartTagStartPt + 1;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
                Found_ = FindStringTag(ElementNode_, SeqType_, IndexSpecified_, 0, EndPoint_, x+1);
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (!Found_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            StrDataNode_->Restore(this);
            delete StrDataNode_;

            if (IndexSpecified_)
              break;
          }
          else
          {
            if (!IndexSpecified_)
            {
              _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
              _TagSeqType = CLOSING;
            }

            break;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = _StrFoundStk->Pop();
          delete StrDataNode_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        return Found_;
      }
    }
  }

  return Found_;
}

/****************************************************************************/
// PURPOSE:
//   Method to keep reading lines of text from file with lines delimited by
//   the Delim_ string until the Mark_ string is found. When the specified
//   Mark_ string token is found within the line that's terminated by the
//   Delim_ terminating character then the string is either returned if no
//   other parameters are specified or is search for the EndLine_ string
//   token if the Endline_ argument is non-null.
//
//   If the EndLine_ string token is non-null then the EndLine token is
//   searched for within the determined return string for an occurence.
//   The first occurence of the EndLine_ string token will terminate the
//   search. If any tag specifier flags are set:
//
//   _IsHtmlTag, _IsXmlTag, _IsNonStdTag, _IsSingletonTag, _IsEmptyTag
//
//   then the string will be searched for matching tag start point and end
//   point indicator strings such as "<", ">" or "</", ">" or other specified
//   start and end tag pairs for the specified tag type.
//
// PRE:
//   const char* Mark_ : Terminating string token to end string extraction
//                       from the input file. Input file strings are extracted
//                       by looking for the Delim_ line delimiter character
//                       which by default is '\n' a newline character.
//   const char* EndLine_ : End of line or end tag string token corresponding
//                          to the Mark_ string token to search for in case
//                          the search operation requires an enclosing pair of
//                          string tokens such as when searching for html or
//                          xml tag pairs around surrounded text.
//   const char* Delim_ : The end of line character delimiter to indicate the
//                        cut-off point in text extraction from the file.
//                        Defaults to the '\n' the standard newline character.
//   Boolean Rws : Remove white space from the extracted text.
//   bool Csense : case sensitive string token comparison for the specified
//                 read terminination token: Mark_. And end of line token:
//                 EndLine_
//
// POST:
//   Returns if the specified file read termination token or end line string
//   tokens was found within the input file. If EndLine_ is set NULL then
//   only Mark_ needs to be found for the function to return true otherwise
//   both the Mark_ and EndLine_ tokens must be found for the function to
//   return true.
//
//   Also, the start point and end point tag positions of the specified
//   string tokens are determined and saved in class data members:
//
//   _StartTagStartPt, _StartTagEndPt, _EndTagStartPt, _EndTagEndPt
//
//   respective to the positions where the start and end point indicator
//   strings are found within the extracted text buffer. For the positions
//   within the inpu file in which these are found, call the Column() and
//   Row() methods.
//
int StringFilter::ReadUntilFound(const char* Mark_, const char* EndLine_,
                                 const char* Delim_, Boolean Rws_, bool Csense_)
{
  if (_Frp->EndOfFile() || !Mark_)
    return 0;

  int Found_ = 0;
  long len;
  long pos;
  long x, y, slen;
  SFStringFoundData* StrDataNode_;
  const char* Ptr_ = NULL;
  const char* Ws_ = " \t\n\r\f\v";
  bool StdTags_ = IsStdTagType();
  bool FoundTp_ = false;
  size_t Skipped_ = 0;

  len = strlen(Mark_);
  ::DeleteArray(_EndReadMark);
  _EndReadMark = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (len + 1));
  strcpy(_EndReadMark, Mark_);
  if (_SimplifySpaces)
    _EndReadMark = ::AllowLenOnlyOfChar(_EndReadMark, 1, " ");

  len = SafeStrLen(EndLine_);

  while (!_Frp->EndOfFile())
  {
    GetTxtLine(Delim_);
    if (_SimplifySpaces)
      _Buffer.AllowLenOnlyOfChar(1, " ");
    CountColsRows(_Buffer.c_str(), Delim_);

    Ptr_ = (_UseTagList && StdTags_) ? strchr(_Buffer.c_str(), _EndReadMark[0]):
                                       strstr(_Buffer.c_str(), _EndReadMark);

    if (!Found_ && Ptr_)
    {
      _StartPt = Ptr_ - _Buffer.c_str();
      _EndPt = _StartPt + ((_UseTagList && StdTags_) ? 1:strlen(_EndReadMark));

      if (StdTags_)
      {
        if (_UseTagList)
        {
          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this);
          _StrFoundStk->Push(StrDataNode_);

          // initial search of opening tag body and tag end point '>'
          _StartTagStartPt = _StartPt;
          _StartTagEndPt = _EndPt;
          FoundTp_ = FindTagPoints(pos, SFTagEnums::OPENING,
                                        SFTagEnums::OPENING);

          if (!FoundTp_)
          {
            StrDataNode_ = _StrFoundStk->Pop();
            StrDataNode_->Restore(this);
            delete StrDataNode_;
            Found_ = 0;
          }
          else
          {
            _StartTagRow = _RowCnt;
            Found_ = 1;
          }
        }
        else
        {
          // Find indicated active and inactive tag start/end points
          if (!MatchTagBrk(_Buffer.c_str(), _EndPt-1, SFTagEnums::CLOSING, SFTagEnums::OPENING))
            while (_Buffer[_EndPt])
            {
              if (MatchTagBrk(_Buffer.c_str(), _EndPt, SFTagEnums::CLOSING, SFTagEnums::OPENING))
              {
                _EndPt++;
                break;
              }
              else
                _EndPt++;
            }

          _StartTagStartPt = _StartPt;
          _StartTagEndPt = _EndPt;
          _StartTagRow = _RowCnt;
          
          Found_ = 1;
        }
      }
      else
        Found_ = 1;
    }

    if (Found_)
      if (!EndLine_ || (_EndLine.strlen() && strncmp(EndLine_, _EndLine.c_str(), len) == 0))
      {
        ++Found_;

        if (EndLine_)
        {
          Ptr_ = _Buffer.StrStr(_EndLine.c_str());
          _EndPt = pos = Ptr_ - _Buffer.c_str();
          _EndPt += _EndLine.strlen();

          if (StdTags_)
          {
            if (_UseTagList)
            {
              StrDataNode_ = new SFStringFoundData;
              StrDataNode_->Save(this);
              _StrFoundStk->Push(StrDataNode_);

              // initial search of closing tag body and tag start point '<'
              _EndTagStartPt = pos;
              _EndTagEndPt = _EndPt;
              FoundTp_ = FindTagPoints(pos, SFTagEnums::CLOSING,
                                            SFTagEnums::OPENING);

              if (!FoundTp_)
              {
                StrDataNode_ = _StrFoundStk->Pop();
                StrDataNode_->Restore(this);
                delete StrDataNode_;
              }
              else
                _EndTagRow = _RowCnt;
            }
            else
            {
              // Find indicated active and inactive tag start/end points
              _EndTagStartPt = pos;
              _EndTagEndPt = _EndPt;
              _EndTagRow = _RowCnt;

              if (!MatchTagBrk(_Buffer.c_str(), _EndTagStartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
                while (_EndTagStartPt)
                {
                  --_EndTagStartPt;
                  if (MatchTagBrk(_Buffer.c_str(), _EndTagStartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
                    break;
                }
            }
          }
        }

        break;
      }
  }

  if (Found_ > 1 && Rws_)
  {
    size_t Skipped_ = 0;
    _Buffer.RemoveTrailing(Ws_);
    for (y = 0; _Buffer[y] && InCharSet(_Buffer[y], Ws_); y++);
    _StartPt -= y;
    _EndPt -= y;

    if (StdTags_)
    {
      _StartTagStartPt -= y;
      _StartTagEndPt -= y;

      if (EndLine_)
      {
        _EndTagStartPt -= y;
        _EndTagEndPt -= y;
      }
      else
      {
        _EndTagStartPt = _StartTagStartPt;
        _EndTagEndPt = _StartTagEndPt;
      }
    }

    if (0 < y)
      for (x = 0; (_Buffer[x] = _Buffer[y]); x++, y++);

    // allow only 1 intervening space for text enclosed within HTML tags
    if (StdTags_)
    {
      char* sSaved_ = NULL;
      char* eSaved_ = NULL;
      bool Match_;

      if (Mark_ && EndLine_)
      {
        slen = _StartTagEndPt - _StartTagStartPt;

        if (slen)
        {
          sSaved_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (slen+1));
          strncpy(sSaved_, _Buffer.c_str() + _StartTagStartPt, slen);
          sSaved_[slen] = 0;
        }
      }

      if (Mark_)
      {
        slen = _EndTagEndPt - _EndTagStartPt;

        if (slen)
        {
          eSaved_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (slen+1));
          strncpy(eSaved_, _Buffer.c_str() + _EndTagStartPt, slen);
          eSaved_[slen] = 0;
        }
      }

      if (_SimplifySpaces)
      {
        _Buffer.AllowLenOnlyOfChar(1, Ws_, &Skipped_);
        _ColCnt -= Skipped_;
      }

      if (Mark_ && eSaved_)
      {
        _StartPt = _EndTagStartPt;
        _EndPt = _EndTagEndPt;

        if (_SimplifySpaces)
        {
          _EndPt -= Skipped_;
          _EndTagEndPt -= Skipped_;
        }

        Match_ = Csense_ ? (strncmp(_Buffer.c_str()+_StartPt-Skipped_, eSaved_, slen) == 0):
                           (StrniComp(_Buffer.c_str()+_StartPt-Skipped_, eSaved_, slen) == 0);

        if (_SimplifySpaces)
        {
          if (Match_)
          {
            _StartPt -= Skipped_;
            Skipped_ = -Skipped_;
          }
          else
          {
            slen = -Skipped_;
            Skipped_ = 0;
            ::AllowLenOnlyOfChar(eSaved_, 1, Ws_, &Skipped_);
            slen += Skipped_ * 2;
            _StartPt += slen;
            Skipped_ = slen;
          }

          _EndTagStartPt += Skipped_;
        }

        // Find indicated active and inactive tag start/end points
        if (StdTags_)
        {
          if (_UseTagList)
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          
            FoundTp_ = FindTagPoints(0, SFTagEnums::OPENING,
                                        SFTagEnums::CLOSING, _TagListIndex);

            if (!FoundTp_)
            {
              StrDataNode_ = _StrFoundStk->Pop();
              StrDataNode_->Restore(this);
              delete StrDataNode_;
            }
          }
          else if (!MatchTagBrk(_Buffer.c_str(), _StartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
          {
            _EndTagStartPt = _EndTagEndPt - 1;
            if (_EndTagStartPt > 0)
              while (_EndTagStartPt)
              {
                --_EndTagStartPt;
                if (MatchTagBrk(_Buffer.c_str(), _EndTagStartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
                  break;
              }
              
            _StartPt = _EndTagStartPt;
          }
        }
      }

      /// with start tags: start
      if (Mark_ && EndLine_ && sSaved_)
      {
        _StartPt = _StartTagStartPt;
        _EndPt = _StartTagEndPt;

        slen = _StartTagEndPt - _StartTagStartPt;
        Match_ = Csense_ ? (strncmp(_Buffer.c_str()+_StartPt, sSaved_, slen) == 0):
                           (StrniComp(_Buffer.c_str()+_StartPt, sSaved_, slen) == 0);

        if (!Match_ && _SimplifySpaces)
        {
          Skipped_ = 0;
          ::AllowLenOnlyOfChar(sSaved_, 1, Ws_, &Skipped_);
          _EndPt -= Skipped_;
          _StartTagEndPt -= Skipped_;
        }

        // Find indicated active and inactive tag start/end points
        if (StdTags_)
        {
          if (_UseTagList)
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            FoundTp_ = FindTagPoints(0, SFTagEnums::CLOSING,
                                        SFTagEnums::CLOSING, _TagListIndex);

            if (!FoundTp_)
            {
              StrDataNode_ = _StrFoundStk->Pop();
              StrDataNode_->Restore(this);
              delete StrDataNode_;
            }
          }
          else if (!MatchTagBrk(_Buffer.c_str(), _EndPt-1, SFTagEnums::CLOSING, SFTagEnums::OPENING))
          {
            _StartTagEndPt = _StartTagStartPt + 1;
            if (_Buffer[_StartTagStartPt])
              while (_Buffer[_StartTagEndPt])
              {
                if (MatchTagBrk(_Buffer.c_str(), _StartTagEndPt, SFTagEnums::CLOSING, SFTagEnums::OPENING))
                {
                  _StartTagEndPt++;
                  break;
                }
                else
                  _StartTagEndPt++;
              }
            
            _EndPt = _StartTagEndPt;
          }
        }

        _StartPt = _StartTagStartPt;
        _EndPt = EndLine_ ? _EndTagEndPt:_StartTagEndPt;
      }
      /// with start tags: end

      if (Mark_)
      {
        ::DeleteArray(eSaved_);
        if (EndLine_)
          ::DeleteArray(sSaved_);
      }
    }
  }

  _StrFoundStk->DeleteAll();
  return (Found_ > 1);
}

/****************************************************************************/
// PURPOSE:
//   Method is same as ReadUntilFound method, but with explicitly specified
//   start and end tags replaced with the list of prespecified tags which are
//   cycled through from beginning to end to find any matching tag pairs.
//
// PRE:
//   const char* Delim_ : The end of line character delimiter to indicate the
//                        cut-off point in text extraction from the file.
//                        Defaults to the '\n' the standard newline character.
//   Boolean Rws : Remove white space from the extracted text.
//   bool Csense : case sensitive string token comparison for the specified
//                 read terminination token: Mark_. And end of line token:
//                 EndLine_
//
// POST:
//   Returns if the specified file read termination token or end line string
//   tokens was found within the input file. If EndLine_ is set NULL then
//   only Mark_ needs to be found for the function to return true otherwise
//   both the Mark_ and EndLine_ tokens must be found for the function to
//   return true.
//
//   Also, the start point and end point tag positions of the specified
//   string tokens are determined and saved in class data members:
//
//   _StartTagStartPt, _StartTagEndPt, _EndTagStartPt, _EndTagEndPt
//
//   respective to the positions where the start and end point indicator
//   strings are found within the extracted text buffer. For the positions
//   within the inpu file in which these are found, call the Column() and
//   Row() methods.
//
int StringFilter::ReadUntilFound(const char* Delim_, Boolean Rws_, bool Csense_)
{
  // typical call to ReadUntilFound method:
  //   ReadUntilFound("<span class", "</span>", "\n", TRUE);
  //
  int ret = 0;
  int lvl;

  if (_InputMethod == USE_SETSTRINGTAGS)
  {
    if (_Next)
    {
      lvl = _NestingLevel;
      ClearNesting();
      SetNestingLevel(lvl);
    }

    return ReadUntilFound(_StartTag, _EndTag,
                          Delim_, Rws_, Csense_);
  }
  else if (_InputMethod == USE_TAGLIST)
  {
    if (_Next)
    {
      lvl = _NestingLevel;
      ClearNesting();
      SetNestingLevel(lvl);
    }

    _UseTagList = true;
    SFTagElement* Node_ = _TagCntData->GiveFirstSFTagElement();
    SFTagElement* MatchNode_ = NULL;

    if (Node_)
    {
      if (Node_->IsStartTag())
        MatchNode_ = Node_->GiveMatchingTag();

      ret = ReadUntilFound(Node_->TagName().c_str(),
                           (MatchNode_ ? MatchNode_->TagName().c_str():NULL),
                           Delim_, Rws_, Csense_);
    }
    else
    {
      if (_StartTag)
        ret = ReadUntilFound(_StartTag, _EndTag,
                             Delim_, Rws_, Csense_);
      else
        ret = ReadUntilFound(_TagList[SFTagEnums::STD_DEX],
                             _TagList[SFTagEnums::END_DEX],
                             Delim_, Rws_, Csense_);
    }

    _UseTagList = false;
  }

  return ret;
}

/****************************************************************************/
int StringFilter::TestRead(Boolean Find_, const char* Mark_, int Spec_,
                          int Len_, Boolean SkipNl_, Boolean SkipWs_)
{
  if (_Frp->EndOfFile() || !(Mark_ || Spec_))
    return 0;

  istream& Is_ = _Frp->GetInStream();

  int Found_;
  short y;
  short x = 0;
  short len = Mark_ ? strlen(Mark_):Len_;
  const char* Nl_ = "\n\r\f\v";
  const char* Ws_ = " \t\n\r\f\v";
  const char* Wsxnl_ = " \t";
  const char* Cset_;
  const char* nlptr_;
  long nlpos_;
  long fndpos_;

  if (Len_ < len)
    Len_ = len;

  if (SkipNl_ || SkipWs_)
  {
    Cset_ = (SkipWs_ && SkipNl_) ? Ws_:
            (SkipNl_) ? Nl_:Wsxnl_;

    while (!_Frp->EndOfFile())
      if (_GetchFromTemp)
      {
        if (!InCharSet(PeekchTempStr(), Cset_))
          break;
        else
          GetchTempStr();
      }
      else
      {
        if (!InCharSet(Is_.peek(), Cset_))
          break;
        else
          Is_.get();
      }
  }

  if (_Frp->EndOfFile())
    return 0;

  if (Mark_ && len)
  {
    y = _GetchFromTemp ?
            toupper(PeekchTempStr()):
            toupper(Is_.peek());
    Found_ = toupper(*Mark_) == y;

    if (Find_ && !Found_)
      return 0;
  }

  for (x = 0; x < Len_; x++)
  {
    if (_GetchFromTemp)
      _Buffer[x] = GetchTempStr();
    else
      Is_.get(_Buffer[x]);

    if (_Frp->EndOfFile())
    {
      for (;x >= 0; x--)
        if (_GetchFromTemp)
          PutBackTempStr();
        else
          Is_.putback(_Buffer[x]);

      return 0;
    }
  }

  _Buffer[x] = 0;
  Found_ = 0;
  nlptr_ = (Cset_ == Wsxnl_) ? _Buffer.StrChr('\n'):NULL;
  nlpos_ = nlptr_ ? (nlptr_ - _Buffer.c_str()):CHARNOTFOUND;

  if (Mark_)
    Found_ = StrniComp(_Buffer.c_str(), Mark_, len) == 0;
  else
  {
    if (Spec_ == DATE)
      Found_ = IsDateStr(_Buffer.c_str());
    else if (Spec_ == TENS_DIGIT)
    {
      len = _Buffer.strlen();
      char* NmeSet_ = MakeCharSet(isdigit);
      fndpos_ = StrHasChar(_Buffer.c_str(), NmeSet_, 1, 1);
      Found_ = fndpos_ != CHARNOTFOUND &&
               (nlptr_ ? (fndpos_ < nlpos_):TRUE);

      if (Found_)
        for (y = fndpos_; y < len && !isspace(_Buffer[y]); y++)
          if (!isdigit(_Buffer[y]) && !isspace(_Buffer[y]))
          {
            Found_ = FALSE;
            break;
          }

      ::DeleteArray(NmeSet_);
    }
    else if (Spec_ == INT_FIELD)
    {
      len = _Buffer.strlen();
      char* NmeSet_ = MakeCharSet(isdigit);
      fndpos_ = StrHasChar(_Buffer.c_str(), NmeSet_, 1, 0);
      Found_ = fndpos_ != CHARNOTFOUND &&
               (nlptr_ ? (fndpos_ < nlpos_):TRUE);

      if (Found_)
        for (y = fndpos_; y < len && !isspace(_Buffer[y]); y++)
          if (!isdigit(_Buffer[y]) && !isspace(_Buffer[y]))
          {
            Found_ = FALSE;
            break;
          }

      ::DeleteArray(NmeSet_);
    }
    else if (Spec_ == FLOAT_FIELD)
    {
      len = _Buffer.strlen();
      char* NmeSet_ = MakeCharSet(isdigit);
      strcat(NmeSet_, ",.");

      fndpos_ = StrHasChar(_Buffer.c_str(), NmeSet_, 1, 1);
      Found_ = fndpos_ != CHARNOTFOUND &&
               (nlptr_ ? (fndpos_ < nlpos_):TRUE);

      if (Found_)
        for (y = fndpos_; y < len && !isspace(_Buffer[y]); y++)
          if (!isdigit(_Buffer[y]) && _Buffer[y] != '.' &&
              _Buffer[y] != ',' && !isspace(_Buffer[y]))
          {
            Found_ = FALSE;
            break;
          }

      ::DeleteArray(NmeSet_);
    }
  }

  for (--x; x >= 0; x--)
    if (_GetchFromTemp)
      PutBackTempStr();
    else
      Is_.putback(_Buffer[x]);

  if (!_GetchFromTemp && !_Frp->EndOfFile())
  {
    _Frp->ClearState();
    _Frp->GetInStream().clear(ios::goodbit);
  }

  if (Find_)
    return Found_;

  return (!Found_);
}

/****************************************************************************/
StringFilter* StringFilter::Push(const ChrString& StartStr_,
                                 const ChrString& EndStr_)
{
  if (_NestingLevel)
  {
    StringFilter* Old_ = new StringFilter(*this, _Next);
    --_NestingLevel;

    _Next = Old_;
    _Next->CopyTagListData(this, StartStr_, EndStr_);
    Old_->_Prev = this;

    ResetFilter(false);
    DecrTagNesting();
    
    return Old_;
  }

  return NULL;
}

/****************************************************************************/
StringFilter* StringFilter::Pop()
{
  if (_Next)
  {
    StringFilter* Old_ = _Next;
    _Next = Old_->_Next;
    _Prev = NULL;
    Old_->_Next = NULL;

    return Old_;
  }

  return NULL;
}

/****************************************************************************/
void StringFilter::FindTagEscCount(char* BufStr_, long Start_,
                                   long OffSet_, const char* TagStr_)
{
  long z;
  if (!BufStr_)
    BufStr_ = _Buffer.c_str();

  for (z = Start_; z < OffSet_; z++)
  {
    if (BufStr_[z] == _TagEsc)
    {
      if (_NonEscCnt)
        _TagEscCnt = 1;
      else
        ++_TagEscCnt;

      _NonEscCnt = 0;
    }
    else
    {
      if (_NonEscCnt >= strlen(TagStr_))
        _NonEscCnt = _TagEscCnt = 0;
      else
        ++_NonEscCnt;
    }
  }
}

/****************************************************************************/
bool StringFilter::IsTagFound(const char* Str_, const char* sPtr_,
                             const char* ePtr_, long Index_, int Found_)
{
  bool StopCond_ = false;

  if (sPtr_)
  {
    // The tag escape char cannot be included within
    // the set of the start tag characters specified
    if (_TagEsc && InCharSet(_TagEsc, sPtr_))
      return false;

    _HaveTagEsc = _HaveTag = false;
    StopCond_ = (_TagEsc && Index_ > 0 && _TagEscCnt % 2) ?
       !(_HaveTagEsc=(*(Str_-1) == _TagEsc)):true;
    _HaveTag = sPtr_ && Found_;
    StopCond_ = StopCond_ && _HaveTag;

    if (StopCond_)
    {
      // break on start tag
      _BreakonStartTag = true;

      // Set within string tag status flag
      _InTag = true;
      return true;
    }
  }
  else if (ePtr_)
  {
    // The tag escape char cannot be included within
    // the set of the end tag characters specified
    if (_TagEsc && InCharSet(_TagEsc, ePtr_))
      return false;

    _HaveTagEsc = _HaveTag = false;
    StopCond_ = (_TagEsc && Index_ > 0 && _TagEscCnt % 2) ?
       !(_HaveTagEsc=(*(Str_-1) == _TagEsc)):true;
    _HaveTag = ePtr_ && Found_;
    StopCond_ = StopCond_ && _HaveTag;

    if (StopCond_)
    {
      // break on end tag
      _BreakonEndTag = true;

      // Unset within string tag status flag
      _InTag = false;
      return true;
    }
  }

  return false;
}

/****************************************************************************/
int StringFilter::IsStringFound(short LenVectIndex_, long& Index_, long Total_,
                                long Added_, long* len, const char* Ptr_,
                                const char* sPtr_, const char* ePtr_, bool Csense_,
                                SFTagStringData* Data_)
{
  SFStringFoundData* StrDataNode_ = NULL;

  int Found_;
  long slen = _Buffer.strlen();
  long tlen = 0;
  long ovlen = 0;
  long Diff_ = 0;
  char* Test_;
  short x, z, off;
  short y = LenVectIndex_;
  long Base_ = Total_ - Added_;
  long* oldlen = NULL;
  long stlen;
  long stpt;
  bool Fit_;
  bool LenCond_ = false;

  // NULL search string is not allowed
  if (!Ptr_)
    return 0;

  if (_UseTagList && Data_)
  {
    oldlen = Data_->oldlen;
    StrDataNode_ = Data_->StrDataNode_;
    LenCond_ = len[3] > 0 && StrDataNode_ &&
               StrDataNode_->TagLengthDiff() > 0;
  }

  if (LenVectIndex_ > 0)
  {
    if (_UseTagList)
      Fit_ = len[1] == oldlen[0] + len[2];
    else
      Fit_ = len[1] == len[0] + len[2];

    if (_UseTagList && Fit_)
      stpt = (len[3] == 0) ? oldlen[0]:(oldlen[0] + len[3]);
    else
      stpt = _UseTagList ? oldlen[0]:len[0];

    if (Fit_)
    {
      Index_ = _TagEscCnt = _NonEscCnt = 0;
      stlen = stpt;

      do
      {
        Found_ = Csense_ ? (strncmp(_Buffer.c_str()+stpt, Ptr_, len[2]) == 0):
                           (StrniComp(_Buffer.c_str()+stpt, Ptr_, len[2]) == 0);
        stpt--;
      }
      while (!Found_ && stpt >= stlen);

      if (_TagEsc && Found_)
      {
        stpt = stlen;
        FindTagEscCount(NULL, 0, stpt, Ptr_);
        Index_ = stpt;
        Found_ = IsTagFound(_Buffer.c_str()+stpt, sPtr_, ePtr_, stpt, Found_);
      }

      if (Found_)
      {
        _TagEscCnt = 0;
        _StartPt = stpt;
        _EndPt = _StartPt + len[2];
        _EndTagStartPt = _StartPt;
        _EndTagEndPt = _EndPt;
        _EndTagRow = _RowCnt;

        if (Data_)
        {
          Data_->ePtr_ = ePtr_;
          Data_->_TagFound = true;
          Data_->_TagType = SFTagEnums::CLOSING;
        }
      }
    }
    else
    {
      // using oldlen instead of len
      //
      stlen = (_UseTagList && oldlen &&
               oldlen[2] <= len[2]) ? oldlen[2]:len[2];

      if (_UseTagList && stlen == oldlen[2] && oldlen[2] < len[2])
        Diff_ = len[2] - oldlen[2];
      else
        Diff_ = 0;

      ovlen = stlen;
      off = (_UseTagList && Diff_ > stlen) ? (len[1] - stlen - Diff_):
                                             (len[1] - (2 * stlen));

      if (LenCond_)
        off -= len[3];

      if (off < 0)
        off += stlen;

      if (LenCond_ && off < 0)
      {
        off += len[3];

        if (oldlen[2] > len[2])
          ovlen = len[2] + len[3];
        else
          ovlen = oldlen[2];
      }

      if (off < 0)
        off += (_UseTagList && Diff_ > stlen) ? Diff_:stlen;

      if (Data_)
        if (Data_->_NewLine && off > 0 && stlen > 1)
          ++off;
        else if (stlen > 1)
        {
          if (Data_->_TagBrkType == SFTagEnums::NO_TAGTYPE)
          {
            ++off;
            if ((!LenCond_ && !Diff_) && slen > 0 && isspace(_Buffer[slen-1]))
              --off;
          }
          else if (off > 0)
          {
            ++off;
            if (Data_->_TagBrkType == SFTagEnums::CLOSING)
              for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--)
                --off;
          }
        }
        
      Test_ = _Buffer.c_str() + off;
      tlen = strlen(Test_);

      if (tlen < 2 * ::SafeStrLen(Ptr_) - 1)
      {
        for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--);
        z = slen - z;
        off = slen - z - (2 * ::SafeStrLen(Ptr_) - 1);
      }

      if (off < 0)
        off = 0;

      Found_ = 0;
      Test_ = _Buffer.c_str() + off;
      slen = strlen(Test_);

      if (Base_ < off || Index_ < off)
      {
        Added_ = off - Index_;

        if (Added_ > 0 && _TagEsc)
        {
          FindTagEscCount(NULL, Index_, Index_ + Added_, Ptr_);
          Index_ += Added_;
        }
      }

      Added_ = slen + off - stlen;
      if (LenCond_)
        Added_ -= len[3];

      if (Data_->_TagBrkType == SFTagEnums::CLOSING ||
          Data_->_TagBrkType == SFTagEnums::NO_TAGTYPE)
      {
        for (z = slen - len[2]; !Found_ && z >= 0; z--)
        {
          Found_ = Csense_ ? (strncmp(Test_+z, Ptr_, len[2]) == 0):
                             (StrniComp(Test_+z, Ptr_, len[2]) == 0);

          if (_TagEsc && Found_)
            Found_ = IsTagFound(Test_+z, sPtr_, ePtr_, off+z, Found_);

          if (Found_)
          {
            _TagEscCnt = 0;
            _StartPt = off + z;
            _EndPt = _StartPt + len[2];
            _EndTagStartPt = _StartPt;
            _EndTagEndPt = _EndPt;
            _EndTagRow = _RowCnt;

            if (Data_)
            {
              Data_->ePtr_ = ePtr_;
              Data_->_TagFound = true;
              Data_->_TagType = SFTagEnums::CLOSING;
            }
          }
          else if (Index_ <= Added_ && _TagEsc)
          {
            FindTagEscCount(Test_+z, 0, 1, Ptr_);
            ++Index_;
          }
        }
      }
      else
      {
        for (z = 0; !Found_ && slen >= len[2]; z++)
        {
          Found_ = Csense_ ? (strncmp(Test_+z, Ptr_, len[2]) == 0):
                             (StrniComp(Test_+z, Ptr_, len[2]) == 0);

          if (_TagEsc && Found_)
            Found_ = IsTagFound(Test_+z, sPtr_, ePtr_, off+z, Found_);

          slen = strlen(Test_+z+1);

          if (Found_)
          {
            _TagEscCnt = 0;
            _StartPt = off + z;
            _EndPt = _StartPt + len[2];
            _EndTagStartPt = _StartPt;
            _EndTagEndPt = _EndPt;
            _EndTagRow = _RowCnt;

            if (Data_)
            {
              Data_->ePtr_ = ePtr_;
              Data_->_TagFound = true;
              Data_->_TagType = SFTagEnums::CLOSING;
            }
          }
          else if (Index_ <= Added_ && _TagEsc)
          {
            FindTagEscCount(Test_+z, 0, 1, Ptr_);
            ++Index_;
          }
        }
      }
    }
  }
  else
  {
    if (slen <= len[0])
    {
      if (slen < len[0])
      {
        Found_ = FALSE;
        return Found_;
      }

      Index_ = _TagEscCnt = _NonEscCnt = 0;
      Found_ = Csense_ ? (strncmp(_Buffer.c_str(), Ptr_, len[0]) == 0):
                         (StrniComp(_Buffer.c_str(), Ptr_, len[0]) == 0);

      if (Found_)
      {
        _StartPt = 0;
        _EndPt = len[0];
        _StartTagStartPt = _StartPt;
        _StartTagEndPt = _EndPt;
        _StartTagRow = _RowCnt;

        if (Data_)
        {
          Data_->sPtr_ = sPtr_;
          Data_->_TagFound = true;
          Data_->_TagType = SFTagEnums::OPENING;
        }
      }
    }
    else
    {
      // using oldlen instead of len
      //
      stlen = (_UseTagList && oldlen &&
               oldlen[0] <= len[0]) ? oldlen[0]:len[0];

      if (_UseTagList && stlen == oldlen[0] && oldlen[0] < len[0])
        Diff_ = len[0] - oldlen[0];
      else
        Diff_ = 0;

      if (len[3] > 0)
      {
        ovlen = stlen;
        off = (_UseTagList && Diff_ > stlen) ? (slen - stlen - Diff_):
                                               (slen - stlen - len[3]);

        if (off < 0)
          off += stlen;

        if (off < 0)
          if (oldlen && LenCond_)
          {
            off += oldlen[3];

            if (oldlen[0] > len[0])
              ovlen = len[0] + len[3];
            else
              ovlen = oldlen[0] + oldlen[3];
          }
          else if (_UseTagList && Diff_ > 0)
          {
            off += Diff_;
            ovlen = Diff_;
          }
          else
          {
            off += len[3];
            ovlen = len[3];
          }

        if (off < 0 && oldlen && LenCond_ && oldlen[3] > 0)
          off += (len[3] - oldlen[3]);

        if (Data_)
          if (Data_->_NewLine && off > 0 && stlen > 1)
            ++off;
          else if (stlen > 1)
          {
            if (Data_->_TagBrkType == SFTagEnums::NO_TAGTYPE)
            {
              ++off;
              if ((!LenCond_ && !Diff_) && slen > 0 && isspace(_Buffer[slen-1]))
                --off;
            }
            else if (off > 0)
            {
              ++off;
              if (Data_->_TagBrkType == SFTagEnums::CLOSING)
                for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--)
                  --off;
            }
          }

        Test_ = _Buffer.c_str() + off;
        tlen = strlen(Test_);

        if (tlen < 2 * ::SafeStrLen(Ptr_) - 1)
        {
          for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--);
          z = slen - z;
          off = slen - z - (2 * ::SafeStrLen(Ptr_) - 1);
        }

        if (off < 0)
          off = 0;
      }
      else
      {
        ovlen = stlen;
        off = (_UseTagList && Diff_ > stlen) ? (slen - stlen - Diff_):
                                               (slen - (2 * stlen));

        if (off < 0)
          off += stlen;

        if (off < 0)
          off += (_UseTagList && Diff_ > stlen) ? Diff_:stlen;

        if (Data_)
          if (Data_->_NewLine && off > 0 && stlen > 1)
            ++off;
          else if (stlen > 1)
          {
            if (Data_->_TagBrkType == SFTagEnums::NO_TAGTYPE)
            {
              ++off;
              if ((!LenCond_ && !Diff_) && slen > 0 && isspace(_Buffer[slen-1]))
                --off;
            }
            else if (off > 0)
            {
              ++off;
              if (Data_->_TagBrkType == SFTagEnums::CLOSING)
                for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--)
                  --off;
            }
          }

        Test_ = _Buffer.c_str() + off;
        tlen = strlen(Test_);

        if (tlen < 2 * ::SafeStrLen(Ptr_) - 1)
        {
          for (z = slen; z > 0 && isspace(_Buffer[z-1]); z--);
          z = slen - z;
          off = slen - z - (2 * ::SafeStrLen(Ptr_) - 1);
        }

        if (off < 0)
          off = 0;
      }

      Found_ = 0;
      Test_ = _Buffer.c_str() + off;
      slen = strlen(Test_);

      if (Base_ < off || Index_ < off)
      {
        Added_ = off - Index_;

        if (Added_ > 0 && _TagEsc)
        {
          FindTagEscCount(NULL, Index_, Index_ + Added_, Ptr_);
          Index_ += Added_;
        }
      }

      Added_ = slen + off - stlen;
      if (_UseTagList && oldlen && oldlen[3] > 0)
        Added_ -= (len[3] - oldlen[3]);

      if (Data_->_TagBrkType == SFTagEnums::CLOSING ||
          Data_->_TagBrkType == SFTagEnums::NO_TAGTYPE)
      {
        for (z = slen - len[0]; !Found_ && z >= 0; z--)
        {
          Found_ = Csense_ ? (strncmp(Test_+z, Ptr_, len[0]) == 0):
                             (StrniComp(Test_+z, Ptr_, len[0]) == 0);

          if (_TagEsc && Found_)
            Found_ = IsTagFound(Test_+z, sPtr_, ePtr_, off+z, Found_);

          if (Found_)
          {
            _TagEscCnt = 0;
            _StartPt = off + z;
            _EndPt = _StartPt + len[0];
            _StartTagStartPt = _StartPt;
            _StartTagEndPt = _EndPt;
            _StartTagRow = _RowCnt;

            if (Data_)
            {
              Data_->sPtr_ = sPtr_;
              Data_->_TagFound = true;
              Data_->_TagType = SFTagEnums::OPENING;
            }
          }
          else if (Index_ <= Added_ && _TagEsc)
          {
            FindTagEscCount(Test_+z, 0, 1, Ptr_);
            ++Index_;
          }
        }
      }
      else
      {
        for (z = 0; !Found_ && slen >= len[0]; z++)
        {
          Found_ = Csense_ ? (strncmp(Test_+z, Ptr_, len[0]) == 0):
                             (StrniComp(Test_+z, Ptr_, len[0]) == 0);

          if (_TagEsc && Found_)
            Found_ = IsTagFound(Test_+z, sPtr_, ePtr_, off+z, Found_);

          slen = strlen(Test_+z+1);

          if (Found_)
          {
            _TagEscCnt = 0;
            _StartPt = off + z;
            _EndPt = _StartPt + len[0];
            _StartTagStartPt = _StartPt;
            _StartTagEndPt = _EndPt;
            _StartTagRow = _RowCnt;

            if (Data_)
            {
              Data_->sPtr_ = sPtr_;
              Data_->_TagFound = true;
              Data_->_TagType = SFTagEnums::OPENING;
            }
          }
          else if (Index_ <= Added_ && _TagEsc)
          {
            FindTagEscCount(Test_+z, 0, 1, Ptr_);
            ++Index_;
          }
        }
      }
    }
  }

  return Found_;
}

/****************************************************************************/
long* StringFilter::RestoreLenVector(SFTagStringData& Data_, bool Found_)
{
  const char* sPtr_             = Data_.sPtr_;
  const char* ePtr_             = Data_.ePtr_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;

  if (ePtr_)
    len[0] = oldlen[0];
  else if (sPtr_)
  {
    len[1] = oldlen[1];
    len[2] = oldlen[2];
  }

  return len;
}

/****************************************************************************/
long* StringFilter::AdjustLenVector(SFTagStringData& Data_, size_t xpt, size_t tlen)
{
  const char* sPtr_             = Data_.sPtr_;
  const char* ePtr_             = Data_.ePtr_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;
  size_t etagadd_;
  size_t etagrem_;

  oldlen[0] = len[0];
  oldlen[1] = len[1];
  oldlen[2] = len[2];
  oldlen[3] = len[3];

  if (ePtr_)
  {
    len[0] = strlen(_TagList[xpt]);
    len[1] = oldlen[0] + tlen;
    len[2] = tlen;
    etagadd_ = (oldlen[1] - len[1]) / len[2];
    len[1] = oldlen[0] + len[2] + (etagadd_ * len[2]);
  }
  else if (sPtr_)
  {
    len[0] = tlen;
    len[1] = tlen;
    etagadd_ = (oldlen[1] - len[1]) / len[0];
    len[1] = len[0] + (etagadd_ * len[0]);
    len[2] = strlen(_TagList[xpt]);
  }

  return len;
}

/****************************************************************************/
bool StringFilter::FindStringTag2(SFTagStringData& Data_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_                 = Data_.pIs_;
  SFStringFoundData* StrDataNode_ = Data_.StrDataNode_;
  SFTagElement* ElementNode_      = Data_.ElementNode_;
  int TagType_                  = Data_.TagType_;
  int SeqType_                  = Data_.SeqType_;
  long StartPoint_              = Data_.StartPoint_;
  long EndPoint_                = Data_.EndPoint_;
  int TagIndex_                 = Data_.TagIndex_;
  short LenVectIndex_           = Data_.LenVectIndex_;
  long* BufIndex_               = Data_.pBufIndex_;
  long* pIndex_                 = Data_.pIndex_;
  long* Total_                  = Data_.pTotal_;
  long* cnt                     = Data_.pAdded_;
  long* DataAdded_              = Data_.pDataAdded_;
  const char* Delim_            = Data_.Delim_;
  bool Continued_               = Data_.Continued_;
  bool SvOver_                  = Data_.SvOver_;
  long* len                     = Data_.len;
  const char* Ptr_              = Data_.Ptr_;
  const char* sPtr_             = Data_.sPtr_;
  const char* ePtr_             = Data_.ePtr_;
  bool Csense_                  = Data_.Csense_;
  long Index_;
  long Added_;
  long EndPt_;

  if (!ElementNode_)
    return false;

  ChrString TagStr_ = ElementNode_->TagName();
  bool Found_ = false;
  bool NotFound_ = true;
  bool Cont_ = false;
  bool ret;

  size_t xpt = 0;
  size_t min = 0;
  size_t slen;
  size_t tlen = TagStr_.strlen();

  if (SeqType_ == SFTagEnums::OPENING)
  {
    if (TagType_ == SFTagEnums::CLOSING && ePtr_)
    {
      if (!Found_)
      {
        xpt = TagIndex_ - 1;
        len = AdjustLenVector(Data_, xpt, tlen);
        Cont_ = false;

        Data_.Cont_ = Cont_;
        Data_.SvOver_ = SvOver_;
        Data_.len = len;
        Data_.StrDataNode_ = StrDataNode_;

        ret = AdjustReadBufferLength(Data_);
        Cont_ = Data_.Cont_;

        if (!ret)
        {
          Data_.pAdded_ = cnt;
          Data_.StrDataNode_ = NULL;
          delete StrDataNode_;
          StrDataNode_ = NULL;
          return false;
        }
        else if (Cont_)
        {
          Data_.StrDataNode_ = NULL;
          delete StrDataNode_;
          StrDataNode_ = NULL;
          return false;
        }

        sPtr_ = NULL;
        ePtr_ = Ptr_ = TagStr_.c_str();
        Index_ = *pIndex_;
        Added_ = *cnt + 1;
        Data_._TagBrkType = SFTagEnums::CLOSING;
        Found_ = IsStringFound(LenVectIndex_, Index_, *Total_, Added_,
                               len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
        *pIndex_ = Index_;

        if (Found_)
        {
          if (DataAdded_)
          {
            StrDataNode_->ReturnData(this, *BufIndex_, *cnt, *Total_,
                                     _SavedLen, len, Data_);
            DataAdded_--;
          }

          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
        }
      }
    }
    else if (TagType_ == SFTagEnums::OPENING && sPtr_)
    {
      while (!Found_)
      {
        xpt = TagIndex_ + 1;
        len = AdjustLenVector(Data_, xpt, tlen);
        Cont_ = false;

        Data_.Cont_ = Cont_;
        Data_.SvOver_ = SvOver_;
        Data_.len = len;
        Data_.StrDataNode_ = StrDataNode_;

        ret = AdjustReadBufferLength(Data_);
        Cont_ = Data_.Cont_;

        if (!ret)
        {
          Data_.pAdded_ = cnt;
          Data_.StrDataNode_ = NULL;
          delete StrDataNode_;
          StrDataNode_ = NULL;
          return false;
        }
        else if (Cont_)
          continue;

        ePtr_ = NULL;
        sPtr_ = Ptr_ = TagStr_.c_str();
        Index_ = *pIndex_;
        Added_ = *cnt + 1;
        Data_._TagBrkType = SFTagEnums::OPENING;
        Found_ = IsStringFound(LenVectIndex_, Index_, *Total_, Added_,
                               len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
        *pIndex_ = Index_;

        if (Found_)
        {
          if (DataAdded_)
          {
            StrDataNode_->ReturnData(this, *BufIndex_, *cnt, *Total_,
                                     _SavedLen, len, Data_);
            DataAdded_--;
          }

          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
          break;
        }

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);

          while (ElementNode_)
          {
            if (ElementNode_ && ElementNode_->IsStartTag())
            {
              StrDataNode_ = PopStrFoundStack(Data_, Found_);
              SvOver_ = Continued_ && _SavedLen < 0;
              Data_.SvOver_ = SvOver_;

              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();

              StrDataNode_ = new SFStringFoundData;
              StrDataNode_->Save(this, *pIndex_, len);
              _StrFoundStk->Push(StrDataNode_);
              break;
            }
            else
            {
              if (!ElementNode_)
                break;
              else
              {
                ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);
                continue;
              }
            }
          }

          if (!ElementNode_)
            break;
        }
        else
          break;
      }
    }
  }
  else if (SeqType_ == SFTagEnums::CLOSING)
  {
    if (TagType_ == SFTagEnums::CLOSING && EndPoint_)
    {
      while (NotFound_)
      {
        EndPt_ = _StartTagEndPt;
        --EndPoint_;
        xpt = TagIndex_ - 1;
        slen = ::SafeStrLen(_TagList[xpt]);

        for (;_StartTagEndPt >= EndPoint_ &&
            (NotFound_ = strncmp(_Buffer(_StartTagEndPt), TagStr_.c_str(), tlen) != 0) &&
            strncmp(_Buffer(_StartTagEndPt), _TagList[xpt], slen) != 0;
            _StartTagEndPt--);

        Found_ = !NotFound_ && _StartTagEndPt == _StartTagStartPt;
        _StartTagEndPt = EndPt_;

        if (Found_)
        {
          _EndPt = _StartTagEndPt;
          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
          if (!Data_.IndexSpecified_)
            Data_.ePtr_ = TagStr_.c_str();

          break;
        }
        else if (Data_.IndexSpecified_)
          break;

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);

          if (ElementNode_)
          {
            StrDataNode_ = PopStrFoundStack(Data_, Found_);
            TagStr_ = ElementNode_->TagName();
            tlen = TagStr_.strlen();

            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          }
          else
            break;
        }
        else
          break;
      }
    }
    else if (TagType_ == SFTagEnums::OPENING && StartPoint_)
    {
      while (NotFound_)
      {
        for (_EndTagStartPt = StartPoint_; _EndTagStartPt >= 0 &&
             (NotFound_ = strncmp(_Buffer(_EndTagStartPt), TagStr_.c_str(), tlen) != 0);
             _EndTagStartPt--);

        _StartPt = (_EndTagStartPt >= 0) ? _EndTagStartPt:0;
        Found_ = !NotFound_;

        if (Found_)
        {
          ElementNode_->IncrTagAttrib(SFTagEnums::TAGCOUNT);
          Found_ = ElementNode_->TagAttrib(SFTagEnums::VALIDITY) == ACTIVE;
          if (!Data_.IndexSpecified_)
            Data_.sPtr_ = TagStr_.c_str();

          break;
        }
        else if (Data_.IndexSpecified_)
          break;

        if (_TagCount[TagIndex_][SFTagEnums::TAGINDEX] >= min)
        {
          ElementNode_ = _TagCntData->GetNextSFTagElement(TagIndex_);

          if (ElementNode_)
          {
            StrDataNode_ = PopStrFoundStack(Data_, Found_);
            TagStr_ = ElementNode_->TagName();
            tlen = TagStr_.strlen();

            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);
          }
          else
            break;
        }
        else
          break;
      }
    }
  }

  return Found_;
}

/****************************************************************************/
bool StringFilter::RewindReadPos(SFTagStringData& Data_, long Diff_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_                 = Data_.pIs_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;
  long* BufIndex_               = Data_.pBufIndex_;
  long* Total_                  = Data_.pTotal_;
  long* cnt                     = Data_.pAdded_;
  const char* Delim_            = Data_.Delim_;
  bool Continued_               = Data_.Continued_;
  bool SvOver_                  = Data_.SvOver_;
  short y                       = Data_.LenVectIndex_;

  if (Diff_ >= *BufIndex_ || Diff_ >= *cnt)
    return false;

  long x;
  long len3 = oldlen[3];
  bool DelimFnd_ = len3 != 0;
  Data_._RewindedLen = Diff_;

  if (_Frp->EndOfFile())
    Data_._Eof = true;

  // Last buffer character input count is less than required tag length
  // string so read some more characters into the buffer
  for (x = 0; x < Diff_ && *BufIndex_ && *cnt; (*BufIndex_)--, (*cnt)--, x++)
  {
    if (Continued_)
      if (SvOver_ && _SavedOver > 0 && _SavedLen == 0)
        --_SavedOver;
      else if (_SavedLen <= 0)
        --_SavedLen;
  }

  if (*Total_ > 0 && _Buffer[*Total_-1] == *Delim_ && DelimFnd_)
    len[3] = 0;

  return (x == Diff_ && *BufIndex_ > 0 && *cnt > 0);
}

/****************************************************************************/
bool StringFilter::RestoreReadPos(SFTagStringData& Data_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_                 = Data_.pIs_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;
  long* BufIndex_               = Data_.pBufIndex_;
  long* Total_                  = Data_.pTotal_;
  long* cnt                     = Data_.pAdded_;
  const char* Delim_            = Data_.Delim_;
  bool Continued_               = Data_.Continued_;
  bool SvOver_                  = Data_.SvOver_;
  short y                       = Data_.LenVectIndex_;
  long Diff_                    = Data_._RewindedLen;

  long x;
  long len3 = oldlen[3];
  bool DelimFnd_ = len3 != 0;
  Data_._RewindedLen = 0;

  // Last buffer character input count is less than required tag length
  // string so read some more characters into the buffer
  for (x = 0; x < Diff_; (*BufIndex_)++, (*cnt)++, x++)
  {
    if (Continued_)
      if (_SavedLen < 0)
        _SavedLen++;
      else if (SvOver_)
        _SavedOver++;
  }

  if (*Total_ > 0 && _Buffer[*Total_-1] == *Delim_)
    len[3] = *cnt;
  else
    len[3] = 0;

  if (Data_._Eof)
  {
    _Buffer[*Total_] = 0;
    Data_._Eof = false;
    return false;
  }

  return true;
}

/****************************************************************************/
bool StringFilter::ReadForward(SFTagStringData& Data_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_                 = Data_.pIs_;
  long* pIndex_                 = Data_.pIndex_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;
  long* BufIndex_               = Data_.pBufIndex_;
  long* Total_                  = Data_.pTotal_;
  long* cnt                     = Data_.pAdded_;
  const char* Delim_            = Data_.Delim_;
  bool Continued_               = Data_.Continued_;
  bool SvOver_                  = Data_.SvOver_;
  short y                       = Data_.LenVectIndex_;
  SFStringFoundData* StrDataNode_ = Data_.StrDataNode_;

  long len3 = oldlen[3];
  bool DelimFnd_ = len3 != 0;
  bool StartLoop_ = *BufIndex_ < len[y];

  // Last buffer character input count is less than required tag length
  // string so read some more characters into the buffer
  for (;*BufIndex_ < len[y]; (*BufIndex_)++, (*cnt)++)
  {
    if (_GetchFromTemp)
      _Buffer[(*Total_)++] = CountColsRows(GetchTempStr());
    else
    {
      pIs_->get(_Buffer[*Total_]);
      CountColsRows(_Buffer[(*Total_)++]);
    }

    if (Continued_)
      if (_SavedLen < 0)
        _SavedLen++;
      else if (SvOver_)
        _SavedOver++;

    if (*Total_ > 0 && _Buffer[*Total_-1] == *Delim_)
    {
      len[3] = *cnt+1;
      DelimFnd_ = true;
      break;
    }
    else
      len[3] = 0;

    if (_Frp->EndOfFile())
    {
      _Buffer[*Total_] = 0;
      return false;
    }
  }

  if (StartLoop_ && (*BufIndex_ == len[y] || DelimFnd_))
  {
    _Buffer[*Total_] = 0;
    StrDataNode_->Save(this, *pIndex_, len);
  }

  return true;
}

/****************************************************************************/
bool StringFilter::AdjustReadBufferLength(SFTagStringData& Data_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_                 = Data_.pIs_;
  long* len                     = Data_.len;
  long* oldlen                  = Data_.oldlen;
  long* BufIndex_               = Data_.pBufIndex_;
  long* Total_                  = Data_.pTotal_;
  long* cnt                     = Data_.pAdded_;
  long* DataAdded_              = Data_.pDataAdded_;
  bool Continued_               = Data_.Continued_;
  bool Cont_                    = Data_.Cont_;

  short y                       = Data_.LenVectIndex_;
  SFStringFoundData* StrDataNode_ = Data_.StrDataNode_;

  long len3 = oldlen[3];
  bool DelimFnd_ = len3 != 0;

  // if current required tag string length is greater than the previous
  // tag string length and the character input count is less than this...
  if (len[y] > oldlen[y] && *BufIndex_ < len[y])
  {
    // end of line reached on last read line command,
    // so pop old buffer node
    if (DelimFnd_)
    {
      StrDataNode_ = PopStrFoundStack(Data_, false);
      Cont_ = true;
      Data_.Cont_ = Cont_;
      len[3] = len3;
      return true;
    }

    // Last buffer character input count is less than required tag length
    // string so read some more characters into the buffer
    if (!ReadForward(Data_))
      return false;

    y = (y == 1) ? 2:0;
    Data_._RevTagLen = len[y] < oldlen[y];
    Data_._RevReadLen = false;

    if (Data_._RevTagLen)
    {
      StrDataNode_->AddData(this, *BufIndex_, *cnt, *Total_, len,
                            Continued_, y, Data_);
      (*DataAdded_)++;
    }
  }
  else if ((len[1] < oldlen[1]) ||
           (len[0] < oldlen[0] && y == 0) ||
           (len[2] < oldlen[2] && y == 1))
  {
    Data_._RevReadLen = len[1] < oldlen[1];

    if (Data_._RevReadLen)
      RewindReadPos(Data_, oldlen[1] - len[1]);

    y = (y == 1) ? 2:0;
    Data_._RevTagLen = len[y] < oldlen[y];

    if (Data_._RevTagLen)
    {
      StrDataNode_->AddData(this, *BufIndex_, *cnt, *Total_, len,
                            Continued_, y, Data_);
      (*DataAdded_)++;
    }
  }

  return true;
}

/****************************************************************************/
SFStringFoundData* StringFilter::PopStrFoundStack(SFTagStringData& Data_, bool Found_)
{
  SFStringFoundData* StrDataNode_ = Data_.StrDataNode_;

  int SeqType_      = Data_.SeqType_;
  long* pDataAdded_ = Data_.pDataAdded_;
  long* BufIndex_   = Data_.pBufIndex_;
  long* pIndex_     = Data_.pIndex_;
  long* Total_      = Data_.pTotal_;
  long* cnt         = Data_.pAdded_;
  long* len         = Data_.len;

  if (SeqType_ == SFTagEnums::OPENING)
  {
    if (_StrFoundStk->Size() > 0)
    {
      if (!_StrFoundStk->HasThis(StrDataNode_))
        delete StrDataNode_;

      StrDataNode_ = _StrFoundStk->Pop();

      if (*pDataAdded_)
      {
        StrDataNode_->ReturnData(this, *BufIndex_, *cnt, *Total_,
                                 _SavedLen, len, Data_);
        (*pDataAdded_)--;
      }

      if (Data_._RewindedLen > 0)
        RestoreReadPos(Data_);

      if (!Found_)
        StrDataNode_->Restore(this, *pIndex_, len);
      else
        RestoreLenVector(Data_, Found_);

      delete StrDataNode_;
      Data_.StrDataNode_ = StrDataNode_ = NULL;
    }
  }
  else if (SeqType_ == SFTagEnums::CLOSING)
  {
    if (_StrFoundStk->Size() > 0)
    {
      if (!_StrFoundStk->HasThis(StrDataNode_))
        delete StrDataNode_;

      StrDataNode_ = _StrFoundStk->Pop();

      if (!Found_)
        StrDataNode_->Restore(this);
      else
        RestoreLenVector(Data_, Found_);

      delete StrDataNode_;
      Data_.StrDataNode_ = StrDataNode_ = NULL;
    }
  }

  return StrDataNode_;
}

/****************************************************************************/
bool StringFilter::FindTagStrings(SFTagStringData& Data_, long SpecIndex_)
{
  // Initializing local vars with function argument data structure
  istream* pIs_       = Data_.pIs_;
  int TagType_        = Data_.TagType_;
  int SeqType_        = Data_.SeqType_;
  long* BufIndex_     = Data_.pBufIndex_;
  short LenVectIndex_ = Data_.LenVectIndex_;
  long* pIndex_       = Data_.pIndex_;
  long* Total_        = Data_.pTotal_;
  long* cnt           = Data_.pAdded_;
  long* len           = Data_.len;
  const char* Delim_  = Data_.Delim_;
  bool Csense_        = Data_.Csense_;
  const char* Ptr_    = Data_.Ptr_;
  const char* sPtr_   = Data_.sPtr_;
  const char* ePtr_   = Data_.ePtr_;
  bool Continued_     = Data_.Continued_;
  bool SvOver_        = Data_.SvOver_;
  long Added_;
  long Index_;

  ///////////////////////////////////
  // Use By ReadUntilString method //
  ///////////////////////////////////
  int x = 0;
  int StartTagx_ = -1;
  size_t slen, tlen;
  ChrString TagStr_;
  SFTagElement* ElementNode_;
  SFTagElement* MatchingNode_;
  SFStringFoundData* StrDataNode_ = NULL;
  SFTagFoundData* TagDataNode_;
  long oldlen[4];
  long EndPoint_ = 0;
  long StartPoint_ = 0;
  long DataAdded_ = 0;

  bool ret;
  bool IndexSpecified_ = SpecIndex_ >= 0;
  bool Found_ = false;
  bool NotFound_ = true;
  bool DelimFnd_ = len[3] != 0;
  bool Cont_ = false;
  bool HasStrTag_ = false;
  bool HasEndTag_ = false;
  bool StdTags_ = IsStdTagType();
  bool IsStartTag_ = false;

  // Initializing function argument data structure with local vars
  Data_.ElementNode_ = ElementNode_;
  Data_.StartPoint_ = StartPoint_;
  Data_.EndPoint_ = EndPoint_;
  Data_.TagIndex_ = x;
  Data_.pDataAdded_ = &DataAdded_;
  Data_.oldlen = oldlen;
  Data_.Cont_ = Cont_;
  Data_.StrDataNode_ = StrDataNode_;
  Data_.IndexSpecified_ = IndexSpecified_;
  ::memmove(oldlen, len, sizeof(int) * 4);

  if (StdTags_)
  {
    if (SeqType_ == SFTagEnums::OPENING)
    {
      // Cycle through list of active/inactive tags
      if (TagType_ == SFTagEnums::CLOSING && ePtr_)
      {
        HasStrTag_ = false;
        x = SpecIndex_;
        if (x % 2)
          --x;

        while (x >= 0 && _TagList[x])
        {
          // Find indicated active and inactive tag start/end points
          IsStartTag_ = false;
          slen = ::SafeStrLen(_TagList[x+1]);
          tlen = 0;

          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
            break;
          else
            _TagCntData->SetTagListIndex(x, _TagCount[x][SFTagEnums::TAGINDEX]);

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = _TagCntData->GetCurrentSFTagElement(x);

            if (ElementNode_)
            {
              MatchingNode_ = ElementNode_->GiveMatchingTag();

              if (MatchingNode_)
              {
                if (!MatchingNode_->IsStartTag())
                {
                  SFTagElement* TempNode_ = MatchingNode_;
                  MatchingNode_ = ElementNode_;
                  ElementNode_ = TempNode_;
                  
                  TagStr_ = ElementNode_->TagName();
                  tlen = TagStr_.strlen();
                  HasStrTag_ = true;
                  HasEndTag_ = true;
                }
                else
                {
                  TagStr_ = _TagList[x];
                  ElementNode_ = NULL;
                  MatchingNode_ = NULL;
                  tlen = 0;
                  IsStartTag_ = true;
                }
              }
              else
                ElementNode_ = NULL;
            }

            if ((!IsStartTag_ || IndexSpecified_) && (!tlen || !ElementNode_))
              break;
            else if (IndexSpecified_ || HasStrTag_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::CLOSING) - 1;
              slen = ::SafeStrLen(_TagList[x+1]);
            }
          }
          else
            TagStr_ = _TagList[x+1];

          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this, *pIndex_, len);
          _StrFoundStk->Push(StrDataNode_);
          len = AdjustLenVector(Data_, x, slen);
          Cont_ = false;

          Data_.pAdded_ = cnt;
          Data_.Cont_ = Cont_;
          Data_.SvOver_ = SvOver_;
          Data_.oldlen = oldlen;
          Data_.len = len;
          Data_.StrDataNode_ = StrDataNode_;

          ret = AdjustReadBufferLength(Data_);
          Cont_ = Data_.Cont_;

          if (!ret)
          {
            Data_.pAdded_ = cnt;
            Data_.StrDataNode_ = NULL;

            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            StrDataNode_ = NULL;
            break;
          }
          else if (Cont_)
            break;
          
          ePtr_ = Ptr_ = _TagList[x+1];
          Added_ = *cnt + 1;
          Index_ = *pIndex_;
          Data_._TagBrkType = SFTagEnums::NO_TAGTYPE;
          Found_ = IsStringFound(LenVectIndex_, Index_, *Total_, Added_,
                                 len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
          *pIndex_ = Index_;

          if (Found_)
          {
            _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
            Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

            if (Found_ && tlen)
            {
              if (DataAdded_)
              {
                StrDataNode_->ReturnData(this, *BufIndex_, *cnt, *Total_,
                                         _SavedLen, len, Data_);
                DataAdded_--;
              }

              Data_.StrDataNode_ = StrDataNode_;
              Data_.ElementNode_ = ElementNode_;
              Data_.StartPoint_ = StartPoint_;
              Data_.EndPoint_ = EndPoint_;
              Data_.TagIndex_ = x+1;
              Data_.pAdded_ = cnt;
              Data_.Cont_ = Cont_;
              Data_.SvOver_ = SvOver_;
              Data_.oldlen = oldlen;
              Data_.len = len;

              ::memmove(len, oldlen, sizeof(long) * 4);
              Found_ = FindStringTag2(Data_);
            }
            else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
              Found_ = false;
          }

          if ((_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 || IsStartTag_) && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (Found_)
          {
            _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
            _TagSeqType = CLOSING;

            if (HasEndTag_ && MatchingNode_)
            {
              TagStr_ = MatchingNode_->TagName();
              Data_.sPtr_ = TagStr_.c_str();
            }
            else
              Data_.sPtr_ = NULL;

            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            StrDataNode_ = NULL;
            break;
          }
          else
          {
            StrDataNode_ = PopStrFoundStack(Data_, false);
            SvOver_ = Continued_ && _SavedLen < 0;
            Data_.SvOver_ = SvOver_;
            break;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = PopStrFoundStack(Data_, Found_);
          SvOver_ = Continued_ && _SavedLen < 0;
          Data_.SvOver_ = SvOver_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        Data_.pAdded_ = cnt;
        return Found_;
      }

      // Cycle through list of active/inactive tags
      if (TagType_ == SFTagEnums::OPENING && sPtr_)
      {
        HasStrTag_ = false;
        for (x = 0; x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          // Find indicated active and inactive tag start/end points
          slen = ::SafeStrLen(_TagList[x]);
          tlen = 0;

          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen ||
              x == SFTagEnums::END_DEX)
            continue;
          else
            _TagCntData->ResetTagListIndex(x);

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = _TagCntData->GetNextSFTagElement(x);

            if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;

              MatchingNode_ = ElementNode_->GiveMatchingTag();

              if (MatchingNode_)
                if (!MatchingNode_->IsStartTag())
                  HasEndTag_ = true;
            }
            else
              break;
          }
          else
            TagStr_ = _TagList[x];

          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this, *pIndex_, len);
          _StrFoundStk->Push(StrDataNode_);
          len = AdjustLenVector(Data_, x+1, slen);
          Cont_ = false;

          Data_.pAdded_ = cnt;
          Data_.Cont_ = Cont_;
          Data_.SvOver_ = SvOver_;
          Data_.oldlen = oldlen;
          Data_.len = len;
          Data_.StrDataNode_ = StrDataNode_;

          ret = AdjustReadBufferLength(Data_);
          Cont_ = Data_.Cont_;

          if (!ret)
          {
            Data_.pAdded_ = cnt;
            Data_.StrDataNode_ = NULL;

            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            StrDataNode_ = NULL;
            break;
          }
          else if (Cont_)
            continue;

          sPtr_ = Ptr_ = _TagList[x];
          Added_ = *cnt + 1;
          Index_ = *pIndex_;
          Data_._TagBrkType = SFTagEnums::OPENING;
          Found_ = IsStringFound(LenVectIndex_, Index_, *Total_, Added_,
                                 len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
          *pIndex_ = Index_;

          if (Found_)
          {
            _TagCount[x][SFTagEnums::TAGCOUNT]++;
            Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

            if (Found_ && tlen)
            {
              if (DataAdded_)
              {
                StrDataNode_->ReturnData(this, *BufIndex_, *cnt, *Total_,
                                         _SavedLen, len, Data_);
                DataAdded_--;
              }

              Data_.StrDataNode_ = StrDataNode_;
              Data_.ElementNode_ = ElementNode_;
              Data_.StartPoint_ = StartPoint_;
              Data_.EndPoint_ = EndPoint_;
              Data_.TagIndex_ = x;
              Data_.pAdded_ = cnt;
              Data_.Cont_ = Cont_;
              Data_.SvOver_ = SvOver_;
              Data_.oldlen = oldlen;
              Data_.len = len;

              ::memmove(len, oldlen, sizeof(long) * 4);
              Found_ = FindStringTag2(Data_);
            }
            else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
              Found_ = false;
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (Found_)
          {
            _TagListIndex = x;
            _TagSeqType = OPENING;

            if (HasEndTag_ && MatchingNode_)
            {
              TagStr_ = MatchingNode_->TagName();
              Data_.ePtr_ = TagStr_.c_str();
            }
            else
              Data_.ePtr_ = NULL;

            if (_StrFoundStk->Size() > 0 &&
                !_StrFoundStk->HasThis(StrDataNode_))
              delete StrDataNode_;

            StrDataNode_ = NULL;
            break;
          }
          else
          {
            StrDataNode_ = PopStrFoundStack(Data_, false);
            SvOver_ = Continued_ && _SavedLen < 0;
            Data_.SvOver_ = SvOver_;
          }
        }

        if (!_StrFoundStk->IsPopped())
        {
          StrDataNode_ = PopStrFoundStack(Data_, Found_);
          SvOver_ = Continued_ && _SavedLen < 0;
          Data_.SvOver_ = SvOver_;
        }

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        Data_.pAdded_ = cnt;
        return Found_;
      }
    }

    if (SeqType_ == SFTagEnums::CLOSING)
    {
      if (TagType_ == SFTagEnums::OPENING)
      {
        HasStrTag_ = false;
        for (x = IndexSpecified_ ? ((SpecIndex_ % 2) ? SpecIndex_-1:SpecIndex_):0;
             x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          IsStartTag_ = false;
          slen = ::SafeStrLen(_TagList[x]);
          tlen = 0;
          
          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
          {
            if (IndexSpecified_)
              break;
            else
              continue;
          }
          else
          {
            if (IndexSpecified_)
              _TagCntData->SetTagListIndex(x, _TagCount[x][SFTagEnums::TAGINDEX]);
            else
              _TagCntData->ResetTagListIndex(x);
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = IndexSpecified_ ? _TagCntData->GetCurrentSFTagElement(x):
                                             _TagCntData->GetNextSFTagElement(x);

            if (IndexSpecified_ && ElementNode_)
            {
              ElementNode_ = ElementNode_->GiveMatchingTag();

              if (ElementNode_)
                if (!ElementNode_->IsStartTag())
                {
                  TagStr_ = ElementNode_->TagName();
                  tlen = TagStr_.strlen();
                  HasStrTag_ = true;
                  HasEndTag_ = true;
                }
                else
                {
                  TagStr_ = _TagList[x];
                  ElementNode_ = NULL;
                  tlen = 0;
                  IsStartTag_ = true;
                }
            }
            else if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;
            }

            if ((!IsStartTag_ || IndexSpecified_) && (!tlen || !ElementNode_))
              break;
            else if (IndexSpecified_ || HasStrTag_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::OPENING);
              slen = ::SafeStrLen(_TagList[x]);
            }
          }
          else
            TagStr_ = _TagList[x];

          if (slen <= ::strlen(_Buffer(_StartPt)) &&
              tlen <= ::strlen(_Buffer(_StartPt)) &&
              (NotFound_ = strncmp(_Buffer(_StartPt), _TagList[x], slen) != 0))  // '<'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _EndTagStartPt = _EndTagEndPt - 1;
            if (_EndTagStartPt < 0)
              break;
            
            for (StartPoint_ = _EndTagStartPt; _EndTagStartPt >= 0 &&
                 (NotFound_ = strncmp(_Buffer(_EndTagStartPt), _TagList[x], slen) != 0);
                 _EndTagStartPt--);

            _StartPt = (_EndTagStartPt >= 0) ? _EndTagStartPt:0;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
              {
                Data_.StrDataNode_ = StrDataNode_;
                Data_.ElementNode_ = ElementNode_;
                Data_.StartPoint_ = StartPoint_;
                Data_.EndPoint_ = EndPoint_;
                Data_.TagIndex_ = x;
                Data_.pAdded_ = cnt;
                Data_.Cont_ = Cont_;
                Data_.SvOver_ = SvOver_;
                Data_.oldlen = oldlen;
                Data_.len = len;

                Found_ = FindStringTag2(Data_);
              }
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _EndTagStartPt = _StartPt;
            StartPoint_ = _StartPt;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
              {
                Data_.StrDataNode_ = StrDataNode_;
                Data_.ElementNode_ = ElementNode_;
                Data_.StartPoint_ = StartPoint_;
                Data_.EndPoint_ = EndPoint_;
                Data_.TagIndex_ = x;
                Data_.pAdded_ = cnt;
                Data_.Cont_ = Cont_;
                Data_.SvOver_ = SvOver_;
                Data_.oldlen = oldlen;
                Data_.len = len;

                Found_ = FindStringTag2(Data_);
              }
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if ((_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 || IsStartTag_) && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (!Found_)
          {
            StrDataNode_ = PopStrFoundStack(Data_, false);
            if (IndexSpecified_)
              break;
          }
          else
          {
            if (!IndexSpecified_)
            {
              _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
              _TagSeqType = OPENING;
            }

            break;
          }
        }

        if (!_StrFoundStk->IsPopped())
          StrDataNode_ = PopStrFoundStack(Data_, Found_);

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        Data_.pAdded_ = cnt;
        return Found_;
      }

      if (TagType_ == SFTagEnums::CLOSING)
      {
        HasStrTag_ = false;
        for (x = IndexSpecified_ ? ((SpecIndex_ % 2) ? SpecIndex_-1:SpecIndex_):0;
             x < TAGLIST_LENGTH && _TagList[x]; x+=2)
        {
          slen = ::SafeStrLen(_TagList[x+1]);
          tlen = 0;
          
          if (!_TagCount[x][SFTagEnums::VALIDITY] || !slen)
          {
            if (IndexSpecified_)
              break;
            else
              continue;
          }
          else
          {
            if (IndexSpecified_)
              _TagCntData->SetTagListIndex(x, _TagCount[x][SFTagEnums::TAGINDEX]);
            else
              _TagCntData->ResetTagListIndex(x);
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS])
          {
            ElementNode_ = IndexSpecified_ ? _TagCntData->GetCurrentSFTagElement(x):
                                             _TagCntData->GetNextSFTagElement(x);

            if (ElementNode_)
            {
              TagStr_ = ElementNode_->TagName();
              tlen = TagStr_.strlen();
              HasStrTag_ = true;
            }

            if (!tlen || !ElementNode_)
              break;
            else if (IndexSpecified_)
            {
              StartTagx_ = x;
              x = ElementNode_->TagBrkIndex(SFTagEnums::CLOSING) - 1;
              slen = ::SafeStrLen(_TagList[x+1]);
            }
          }
          else
            TagStr_ = _TagList[x+1];

          if (_EndPt >= slen && slen <= ::strlen(_Buffer(_EndPt-slen)) &&
              tlen <= ::strlen(_Buffer(_EndPt-slen)) &&
              (NotFound_ = strncmp(_Buffer(_EndPt-slen), _TagList[x+1], slen) != 0))  // '>'
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _StartTagEndPt = _StartTagStartPt + 1;
            if (!_Buffer[_StartTagStartPt])
              break;
            
            for (EndPoint_ = _StartTagEndPt; _Buffer[_StartTagEndPt] && slen <= ::strlen(_Buffer(_StartTagEndPt)) &&
                (NotFound_ = strncmp(_Buffer(_StartTagEndPt), _TagList[x+1], slen) != 0);
                _StartTagEndPt++);

            Found_ = !NotFound_;
            if (Found_)
              ++_StartTagEndPt;

            _EndPt = _StartTagEndPt;
            
            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
              {
                Data_.StrDataNode_ = StrDataNode_;
                Data_.ElementNode_ = ElementNode_;
                Data_.StartPoint_ = StartPoint_;
                Data_.EndPoint_ = EndPoint_;
                Data_.TagIndex_ = x+1;
                Data_.pAdded_ = cnt;
                Data_.Cont_ = Cont_;
                Data_.SvOver_ = SvOver_;
                Data_.oldlen = oldlen;
                Data_.len = len;

                Found_ = FindStringTag2(Data_);
              }
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }
          else
          {
            StrDataNode_ = new SFStringFoundData;
            StrDataNode_->Save(this);
            _StrFoundStk->Push(StrDataNode_);

            _StartTagEndPt = _EndPt;
            EndPoint_ = _StartTagStartPt + 1;
            Found_ = !NotFound_;
            
            if (Found_)
            {
              _TagCount[x+1][SFTagEnums::TAGCOUNT]++;
              Found_ = _TagCount[x+1][SFTagEnums::VALIDITY] == ACTIVE;

              if (Found_ && tlen)
              {
                Data_.StrDataNode_ = StrDataNode_;
                Data_.ElementNode_ = ElementNode_;
                Data_.StartPoint_ = StartPoint_;
                Data_.EndPoint_ = EndPoint_;
                Data_.TagIndex_ = x+1;
                Data_.pAdded_ = cnt;
                Data_.Cont_ = Cont_;
                Data_.SvOver_ = SvOver_;
                Data_.oldlen = oldlen;
                Data_.len = len;

                Found_ = FindStringTag2(Data_);
              }
              else if (_TagCount[x][SFTagEnums::TAGELEMENTS] && !tlen)
                Found_ = false;
            }
          }

          if (_TagCount[x][SFTagEnums::TAGELEMENTS] == 0 && Found_ && !tlen)
          {
            TagDataNode_ = new SFTagFoundData(this, x / 2);
            _TagFoundQue->Enqueue(TagDataNode_);
            Found_ = false;
          }

          if (!Found_)
          {
            StrDataNode_ = PopStrFoundStack(Data_, false);
            if (IndexSpecified_)
              break;
          }
          else
          {
            if (!IndexSpecified_)
            {
              _TagListIndex = (StartTagx_ != -1) ? StartTagx_:x;
              _TagSeqType = CLOSING;
            }

            break;
          }
        }

        if (!_StrFoundStk->IsPopped())
          StrDataNode_ = PopStrFoundStack(Data_, Found_);

        if (!Found_ && !HasStrTag_ && !_TagFoundQue->Empty())
        {
          TagDataNode_ = _TagFoundQue->Dequeue();
          TagDataNode_->Restore(this);
          _TagFoundQue->DeleteAll();
          Found_ = true;
          delete TagDataNode_;
        }

        _StrFoundStk->DeleteAll();
        Data_.pAdded_ = cnt;
        return Found_;
      }
    }
  }

  return Found_;
}

/****************************************************************************/
// PURPOSE:
//   Method to extract from file or a block or pre-read text a section of text
//   starting with the Start_ string and Ending with the End_ string.
//   The starting and ending tags can also be escaped by a specified tag
//   escape character that is set by the SetTagsEscChar(char) method.
//   String tags prepended with a single or odd number of escape characters
//   will be treated as ordinary non-tag strings.
//
// PRE:
//   const char* StartOrStop_ : The starting tag to read up to and extract
//                              text from if there is no ending tag specified
//                              or is the position of the first tag after
//                              which string extraction is performed.
//   const char* End_ : The ending tag to indicate the position in the file
//                      or text section to stop string extraction.
//   Boolean SkipNl_ : Skip newlines if encountered in string extraction.
//   Boolean SkipWs_ : Skip whitespace if encountered in string extraction.
//   Boolean HasStart_ : Specify that there should be a starting tag
//                       somewhere within the text section being extracted
//                       from rather than the presence of the starting tag
//                       being indeterminate.
//   int TestLen_ : The sample length of text to examine for the presence of
//                  the starting tag in the case of an indeterminate string
//                  before quitting the method and returning *Not Found*
//   const char* Delim_ : In the case of a delimited string, the character
//                        either in the file stream or text section that
//                        splits up the text into separate text items. In the
//                        case of a text file this usually is the newline
//                        character. This is important to indicate if the tail
//                        section of text string or text file should always
//                        end with the specified Start_ or End_ tag strings.
//   bool Csense_ : Should string comparison of speficied tags be case
//                  sensitive.
//
// POST:
//   Extracts a section of text either ending in the specified string Start_
//   or surrounded by the specified strings Start_ and End_.
//
//   If only the Start_ string is given the _StartPt would indicate the
//   starting point in the extracted text section of where the Start_ string
//   begins and _EndPt would indicate where the Start_ string ends.
//   If both the Start_ and End_ string is given then _StartPt would indicate
//   the starting poin in the extracted text section of where the End_ string
//   begins and _EndPt would indicate where teh End_ string ends.
//
//   Note: The starting and ending tags can also be escaped by a specified
//   tag escape character that is set by the SetTagsEscChar(char) method.
//   String tags prepended with a single or odd number of escape characters
//   will be treated as ordinary non-tag strings.
//
int StringFilter::ReadUntilString(const char* StartOrStop_, const char* End_,
                                  Boolean SkipNl_, Boolean SkipWs_, Boolean HasStart_,
                                  int TestLen_, const char* Delim_,
                                  bool Csense_, bool Continued_)
{
  if (_Frp->EndOfFile() || !StartOrStop_)
    return 0;

  istream& Is_ = Continued_ ? *_SavedStream:_Frp->GetInStream();

  bool SvOver_ = false;
  bool StdTags_ = IsStdTagType();
  bool NewLine_ = false;

  int ch;
  int Found_;
  long stsp;       // start tag start point
  long y = 0;      // index into length array
  long cnt = 0;    // number of additional characters retrieved per read cycle
                   // excluding specified line break character
  long z = 0;      // total characters retrieved per nested tag level
  long x = 0;      // read cycle character count index before set accumulated
                   // string length to read per cycle reached.
  long len[4];     // length array
  long slen = 0;   // string length
  long plen = 0;   // unappended string length
  long tlen;       // tag length
  long Index_ = 0; // start point offset into string to use before seach done
                   // for the html tag escape character or escape string.

  SFStringFoundData* StrDataNode_;
  SFTagStringData Data_;
  ChrString Temps_;
  ChrString sChrStr_ = StartOrStop_ ? StartOrStop_:"";
  ChrString eChrStr_ = End_ ? End_:"";
  ChrString ConstStart_ = sChrStr_;
  ChrString ConstEnd_ = eChrStr_;

  const char* Ptr_ = StartOrStop_;
  const char* sPtr_ = Ptr_;        // start tag pointer
  const char* ePtr_ = NULL;        // end tag pointer
  const char* Nl_ = "\n\r\f\v";    // newline characters
  const char* Ws_ = " \t\n\r\f\v"; // whitespace characters
  const char* Wsxnl_ = " \t";      // whitespace characters excluding newlines
  const char* Cset_;               // pointer to character set array

  if (!Continued_)
  {
    _InTag = false;                // parse pointer within HTML tag
    _TagEscCnt = 0;                // escaped HTML tag counts
    _BreakonStartTag = false;      // parse process interrupted on start tag
    _BreakonEndTag = false;        // parse process interrupted on end tag
    _HaveTag = false;              // have specific html tag string set
    _HaveTagEsc = false;           // have tag escape characters or string
    _TagEscCnt = _NonEscCnt = 0;   // html tag escape counts
    Data_._NewLine = true;
  }

  len[0] = strlen(StartOrStop_);   // string length of start tag
  len[1] = End_ ? strlen(End_):0;  // continuous accumulating string length
                                   // to process per read cycle for finding
                                   // the end tag.
  len[2] = len[1];                 // string length of end tag.
                                   // len[3], addition characters retrieved
                                   // per read cycle before line break
                                   // character encountered.

  if (SkipNl_ || SkipWs_)
  {
    Cset_ = (SkipWs_ && SkipNl_) ? Ws_:
            (SkipNl_) ? Nl_:Wsxnl_;

    while (!_Frp->EndOfFile())
      if (_GetchFromTemp)
      {
        if (!InCharSet(PeekchTempStr(), Cset_))
          break;
        else
          CountColsRows(GetchTempStr());
      }
      else
      {
        if (!InCharSet(Is_.peek(), Cset_))
          break;
        else
          CountColsRows(Is_.get());
      }
  }

  if (_Frp->EndOfFile())
    return 0;

  Found_ = 0;
  z = x;

  if (Continued_)
  {
    Index_ = _SavedIndex;
    x = cnt = len[0];
    z = _Buffer.strlen();
    len[3] = (_Buffer[z-1] == *Delim_) ? (cnt+1):0;
    SvOver_ = _SavedLen < 0;

    if (len[3] == 0)
      --cnt;

    goto DoCont;
  }

  for (y = 0; Ptr_; y++)
  {
    Data_._FindingTag = false;
    for (cnt = 0; x < len[y]; x++, cnt++)
    {
      if (_GetchFromTemp)
        _Buffer[z++] = CountColsRows(GetchTempStr());
      else
      {
        Is_.get(_Buffer[z]);
        CountColsRows(_Buffer[z++]);
      }

      if (Continued_)
        if (_SavedLen < 0)
          _SavedLen++;
        else if (SvOver_)
          _SavedOver++;

      if (_Buffer[z-1] == *Delim_)
      {
        len[3] = cnt+1;
        NewLine_ = true;
        break;
      }
      else
        len[3] = 0;

      if (_Frp->EndOfFile())
      {
        _Buffer[z] = 0;
        
        // Find indicated active and inactive tag start/end points: call function
        // Index_ is changed, so push to stack to save old value
        if (_UseTagList)
        {
          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this, Index_, len);
          _StrFoundStk->Push(StrDataNode_);

          Data_.pIs_ = &Is_;
          Data_.TagType_ = (sPtr_ != NULL) ? SFTagEnums::OPENING:SFTagEnums::CLOSING;
          Data_.SeqType_ = SFTagEnums::OPENING;
          Data_.pBufIndex_ = &x;
          Data_.LenVectIndex_ = y;
          Data_.pIndex_ = &Index_;
          Data_.pTotal_ = &z;
          Data_.pAdded_ = &cnt;
          Data_.len = len;
          Data_.Delim_ = Delim_;
          Data_.Ptr_ = Ptr_;
          Data_.sPtr_ = sPtr_;
          Data_.ePtr_ = ePtr_;
          Data_.Continued_ = Continued_;
          Data_.SvOver_ = SvOver_;
          Data_.Csense_ = Csense_;
          Data_._FindingTag = true;
          Data_._TagFound = false;

          if (Data_.TagType_ == SFTagEnums::CLOSING &&
              _TagSeqType == OPENING)
            Found_ = FindTagStrings(Data_, _TagListIndex);
          else
            Found_ = FindTagStrings(Data_, -1);

          SvOver_ = Data_.SvOver_;
          Data_._NewLine = NewLine_;
          
          if (Data_.TagType_ == SFTagEnums::OPENING && Data_.sPtr_)
          {
            sChrStr_ = Data_.sPtr_;
            sPtr_ = sChrStr_.c_str();

            if (Data_.ePtr_)
              eChrStr_ = Data_.ePtr_;
          }
          else if (Data_.TagType_ == SFTagEnums::CLOSING && Data_.ePtr_)
          {
            eChrStr_ = Data_.ePtr_;
            ePtr_ = eChrStr_.c_str();

            if (Data_.sPtr_)
              sChrStr_ = Data_.sPtr_;
          }
        }
        else
        {
          Found_ = IsStringFound(y, Index_, z, cnt+1, len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
          Data_._NewLine = NewLine_;
        }

        if (!Found_)
          for (--z; z >= 0; z--)
            if (_GetchFromTemp)
              UnCountColsRows(PutBackTempStr());
            else
            {
              UnCountColsRows(_Buffer[z]);
              Is_.putback(_Buffer[z]);
            }

        goto DoBrk;
      }
    }

    _Buffer[z] = 0;
    if (len[3] == 0)
    {
      --cnt;
      NewLine_ = false;
    }

    // Find indicated active and inactive tag start/end points: call function
    // Index_ is changed, so push to stack to save old value
    if (_UseTagList)
    {
      StrDataNode_ = new SFStringFoundData;
      StrDataNode_->Save(this, Index_, len);
      _StrFoundStk->Push(StrDataNode_);

      Data_.pIs_ = &Is_;
      Data_.TagType_ = (sPtr_ != NULL) ? SFTagEnums::OPENING:SFTagEnums::CLOSING;
      Data_.SeqType_ = SFTagEnums::OPENING;
      Data_.pBufIndex_ = &x;
      Data_.LenVectIndex_ = y;
      Data_.pIndex_ = &Index_;
      Data_.pTotal_ = &z;
      Data_.pAdded_ = &cnt;
      Data_.len = len;
      Data_.Delim_ = Delim_;
      Data_.Ptr_ = Ptr_;
      Data_.sPtr_ = sPtr_;
      Data_.ePtr_ = ePtr_;
      Data_.Continued_ = Continued_;
      Data_.SvOver_ = SvOver_;
      Data_.Csense_ = Csense_;
      Data_._FindingTag = true;
      Data_._TagFound = false;

      if (Data_.TagType_ == SFTagEnums::CLOSING &&
          _TagSeqType == OPENING)
        Found_ = FindTagStrings(Data_, _TagListIndex);
      else
        Found_ = FindTagStrings(Data_, -1);

      SvOver_ = Data_.SvOver_;
      Data_._NewLine = NewLine_;
      
      if (Data_.TagType_ == SFTagEnums::OPENING && Data_.sPtr_)
      {
        sChrStr_ = Data_.sPtr_;
        sPtr_ = sChrStr_.c_str();

        if (Data_.ePtr_)
          eChrStr_ = Data_.ePtr_;
      }
      else if (Data_.TagType_ == SFTagEnums::CLOSING && Data_.ePtr_)
      {
        eChrStr_ = Data_.ePtr_;
        ePtr_ = eChrStr_.c_str();

        if (Data_.sPtr_)
          sChrStr_ = Data_.sPtr_;
      }
    }
    else
    {
      Found_ = IsStringFound(y, Index_, z, cnt+1, len, Ptr_, sPtr_, ePtr_, Csense_, &Data_);
      Data_._NewLine = NewLine_;
    }

    if (!Found_)
    {
      if (y > 0)
      {
        y = 0;

        if (len[3] == 0 || len[3] == len[2])
          len[1] += len[2];
      }
      else
      {
        if (HasStart_)
        {
          x = 0;
          y = -1;
          SvOver_ = Continued_ && _SavedLen < 0;
        }
        else
        {
          if (TestLen_ > 0 && z < TestLen_)
          {
            x = 0;
            y = -1;
            SvOver_ = Continued_ && _SavedLen < 0;
          }
          else
          {
            for (--z; z >= 0; z--)
              if (_GetchFromTemp)
                UnCountColsRows(PutBackTempStr());
              else
              {
                UnCountColsRows(_Buffer[z]);
                Is_.putback(_Buffer[z]);
              }

            break;
          }
        }
      }
    }
    else
    {
DoCont:

      if (y == 0 && End_)
      {
        if (_NestingLevel && !Continued_)
        {
          SvOver_ = false;
          _SavedIndex = Index_;
          _SavedStream = &Is_;
          Push(sChrStr_, eChrStr_);  // tag found so clear/reset input string for next level

          if (HasStart_)
          {
            z = x = 0;
            y = -1;
          }
          else
          {
            if (TestLen_ > 0 && z < TestLen_)
            {
              z = x = 0;
              y = -1;
            }
            else
            {
              for (--z; z >= 0; z--)
                if (_GetchFromTemp)                
                  UnCountColsRows(PutBackTempStr());
                else
                {
                  UnCountColsRows(_Buffer[z]);
                  Is_.putback(_Buffer[z]);
                }

              break;
            }
          }
        }
        else
        {
          y = 0;
          len[1] += len[0];
          Ptr_ = End_;
          sPtr_ = NULL;
          ePtr_ = Ptr_;
          slen = ::SafeStrLen(_Buffer(_StartPt));
          stsp = _StartTagStartPt;

          if (_Next && !Continued_)
          {
            SvOver_ = false;
            AppendMalJoinedTagStr(Temps_, _Next->SavedTagCntData() ? _Next->SavedStartTag():sChrStr_,
                                  Data_, (y == 0 && End_), plen, slen, stsp);
          }
          else if (Continued_ && _SavedLen > 0)
          {
            if (_Next)
              AppendMalJoinedTagStr(Temps_, _Next->SavedTagCntData() ? _Next->SavedStartTag():sChrStr_,
                                    Data_, (y == 0 && End_), plen, slen, stsp);

            while (_SavedLen > 0)
            {
              len[1] += len[2];
              _SavedLen -= len[2];
              _SavedOver -= len[2];

              if (_SavedLen <= 0 || _SavedOver <= 0)
              {
                _SavedOver = 0;
                SvOver_ = Continued_ && _SavedLen < 0;
              }
            }
          }

          if (_StartPt)
          {
            _Buffer.MemMove(_Buffer.c_str() + _StartPt, slen + 1);
            _StartTagStartPt -= _StartPt;
            _StartTagEndPt -= _StartPt;
          }
          
          Temps_ = _Buffer;
          plen = slen;
          z = _Buffer.strlen();
        }
      }
      else
      {
        slen = ::SafeStrLen(_Buffer(_EndPt));
        stsp = _StartTagStartPt;
        tlen = plen;
        plen = z - slen;

        for (--z; z >= 0 && slen > 0; z--, slen--)
          if (_GetchFromTemp)
            UnCountColsRows(PutBackTempStr());
          else
          {
            UnCountColsRows(_Buffer[z]);
            Is_.putback(_Buffer[z]);
          }

        _Buffer[_EndPt] = 0;

        if (_Next)
        {
          slen = plen;
          plen = tlen;

          AppendMalJoinedTagStr(Temps_, _Next->SavedTagCntData() ? _Next->SavedStartTag():sChrStr_,
                                Data_, (y == 0 && End_), plen, slen, stsp);

          if (_Next->SavedTagCntData())
            _Next->ReadUntilString(ConstStart_.c_str(), ConstEnd_.c_str(), SkipNl_, SkipWs_,
                                   HasStart_, TestLen_, Delim_, Csense_, true);

          plen = slen;
          Temps_ = _Buffer;
        }
        else
        {
          Temps_ = _Buffer;
          Temps_.Left(plen);
        }

        break;
      }
    }
  }

DoBrk:

  if (!Found_)
  {
    if (!_GetchFromTemp && !_Frp->EndOfFile())
    {
      _Frp->ClearState();
      _Frp->GetInStream().clear(ios::goodbit);
    }

    _StrFoundStk->DeleteAll();
    return Found_;
  }

  // Removing trailing spaces and adjusting start tag found start/end points
  size_t Skipped_ = 0;
  ::RemoveTrailing(_Buffer.c_str(), Ws_);
  for (y = 0; _Buffer[y] && InCharSet(_Buffer[y], Ws_); y++);
  _StartPt -= y;
  _EndPt -= y;

  _StartTagStartPt -= y;
  _StartTagEndPt -= y;

  if (End_)
  {
    _EndTagStartPt -= y;
    _EndTagEndPt -= y;
  }
  else
  {
    _EndTagStartPt = _StartTagStartPt;
    _EndTagEndPt = _StartTagEndPt;
  }

  if (0 < y)
    for (x = 0; (_Buffer[x] = _Buffer[y]); x++, y++);

  // if search specified for html tags then adjusting position of start
  // tag start/end points and end tag start/end points to match with html
  // starting character for tags "<" and html closing character for tags ">"
  // allow only 1 intervening space for text enclosed within HTML tags
  if (StdTags_)
  {
    char* sSaved_ = NULL;
    char* eSaved_ = NULL;
    bool Match_;

    if (StartOrStop_ && End_)
    {
      slen = _StartTagEndPt - _StartTagStartPt;

      if (slen)
      {
        sSaved_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (slen+1));
        strncpy(sSaved_, _Buffer.c_str() + _StartTagStartPt, slen);
        sSaved_[slen] = 0;
      }
    }

    if (StartOrStop_)
    {
      slen = _EndTagEndPt - _EndTagStartPt;

      if (slen)
      {
        eSaved_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (slen+1));
        strncpy(eSaved_, _Buffer.c_str() + _EndTagStartPt, slen);
        eSaved_[slen] = 0;
      }
    }

    if (_SimplifySpaces)
    {
      _Buffer.AllowLenOnlyOfChar(1, Ws_, &Skipped_);
      _ColCnt -= Skipped_;
    }

    if (StartOrStop_ && eSaved_)
    {
      _StartPt = _EndTagStartPt;
      _EndPt = _EndTagEndPt;

      if (_SimplifySpaces)
      {
        _EndPt -= Skipped_;
        _EndTagEndPt -= Skipped_;
      }

      Match_ = Csense_ ? (strncmp(_Buffer.c_str()+_StartPt-Skipped_, eSaved_, slen) == 0):
                         (StrniComp(_Buffer.c_str()+_StartPt-Skipped_, eSaved_, slen) == 0);

      if (_SimplifySpaces)
      {
        if (Match_)
        {
          _StartPt -= Skipped_;
          Skipped_ = -Skipped_;
        }
        else
        {
          slen = -Skipped_;
          Skipped_ = 0;
          ::AllowLenOnlyOfChar(eSaved_, 1, Ws_, &Skipped_);
          slen += Skipped_ * 2;
          _StartPt += slen;
          Skipped_ = slen;
        }

        _EndTagStartPt += Skipped_;
      }

      if (StdTags_)
      {
        if (_UseTagList)
        {
          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this);
          _StrFoundStk->Push(StrDataNode_);

          Data_.pIs_ = &Is_;
          Data_.TagType_ = SFTagEnums::OPENING;
          Data_.SeqType_ = SFTagEnums::CLOSING;
          Data_.pBufIndex_ = &x;
          Data_.LenVectIndex_ = Index_;
          Data_.pIndex_ = &x;
          Data_.pTotal_ = &x;
          Data_.pAdded_ = &cnt;
          Data_.len = len;
          Data_.Delim_ = NULL;
          Data_.Ptr_ = NULL;
          Data_.sPtr_ = NULL;
          Data_.ePtr_ = NULL;
          Data_.Continued_ = Continued_;
          Data_.SvOver_ = false;
          Data_.Csense_ = Csense_;
          Data_._TagFound = false;

          Found_ = FindTagStrings(Data_, _TagListIndex);
          SvOver_ = Data_.SvOver_;
        }
        else if (!MatchTagBrk(_Buffer.c_str(), _StartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
        {
          _EndTagStartPt = _EndTagEndPt - 1;
          if (_EndTagStartPt > 0)
            while (_EndTagStartPt)
            {
              --_EndTagStartPt;
              if (MatchTagBrk(_Buffer.c_str(), _EndTagStartPt, SFTagEnums::OPENING, SFTagEnums::CLOSING))
                break;
            }
            
          _StartPt = _EndTagStartPt;
        }
      }
    }

    /// with start tags: start
    if (StartOrStop_ && End_ && sSaved_)
    {
      _StartPt = _StartTagStartPt;
      _EndPt = _StartTagEndPt;

      slen = _StartTagEndPt - _StartTagStartPt;
      Match_ = Csense_ ? (strncmp(_Buffer.c_str()+_StartPt, sSaved_, slen) == 0):
                         (StrniComp(_Buffer.c_str()+_StartPt, sSaved_, slen) == 0);

      if (!Match_ && _SimplifySpaces)
      {
        Skipped_ = 0;
        ::AllowLenOnlyOfChar(sSaved_, 1, Ws_, &Skipped_);
        _EndPt -= Skipped_;
        _StartTagEndPt -= Skipped_;
      }

      if (StdTags_)
      {
        if (_UseTagList)
        {
          StrDataNode_ = new SFStringFoundData;
          StrDataNode_->Save(this);
          _StrFoundStk->Push(StrDataNode_);

          Data_.pIs_ = &Is_;
          Data_.TagType_ = SFTagEnums::CLOSING;
          Data_.SeqType_ = SFTagEnums::CLOSING;
          Data_.pBufIndex_ = &x;
          Data_.LenVectIndex_ = Index_;
          Data_.pIndex_ = &x;
          Data_.pTotal_ = &x;
          Data_.pAdded_ = &cnt;
          Data_.len = len;
          Data_.Delim_ = NULL;
          Data_.Ptr_ = NULL;
          Data_.sPtr_ = NULL;
          Data_.ePtr_ = NULL;
          Data_.Continued_ = Continued_;
          Data_.SvOver_ = false;
          Data_.Csense_ = Csense_;
          Data_._TagFound = false;

          Found_ = FindTagStrings(Data_, _TagListIndex);
          SvOver_ = Data_.SvOver_;
        }
        else if (!MatchTagBrk(_Buffer.c_str(), _EndPt-1, SFTagEnums::CLOSING, SFTagEnums::OPENING))
        {
          _StartTagEndPt = _StartTagStartPt + 1;
          if (_Buffer[_StartTagStartPt])
            while (_Buffer[_StartTagEndPt])
            {
              if (MatchTagBrk(_Buffer.c_str(), _StartTagEndPt, SFTagEnums::CLOSING, SFTagEnums::OPENING))
              {
                _StartTagEndPt++;
                break;
              }              
              else
                _StartTagEndPt++;
            }
            
          _EndPt = _StartTagEndPt;
        }
      }

      _StartPt = _StartTagStartPt;
      _EndPt = End_ ? _EndTagEndPt:_StartTagEndPt;
    }
    /// with start tags: end

    if (StartOrStop_)
    {
      ::DeleteArray(eSaved_);
      if (End_)
        ::DeleteArray(sSaved_);
    }
  }

  if (!_GetchFromTemp && !_Frp->EndOfFile())
  {
    _Frp->ClearState();
    _Frp->GetInStream().clear(ios::goodbit);
  }

  _StrFoundStk->DeleteAll();
  return Found_;
}

/****************************************************************************/
// PURPOSE:
//   Method is same as ReadUntilFound method, but with explicitly specified
//   start and end tags replaced with the list of prespecified tags which are
//   cycled through from beginning to end to find any matching tag pairs.
//
// PRE:
//   Boolean SkipNl_ : Skip newlines if encountered in string extraction.
//   Boolean SkipWs_ : Skip whitespace if encountered in string extraction.
//   Boolean HasStart_ : Specify that there should be a starting tag
//                       somewhere within the text section being extracted
//                       from rather than the presence of the starting tag
//                       being indeterminate.
//   int TestLen_ : The sample length of text to examine for the presence of
//                  the starting tag in the case of an indeterminate string
//                  before quitting the method and returning *Not Found*
//   const char* Delim_ : In the case of a delimited string, the character
//                        either in the file stream or text section that
//                        splits up the text into separate text items. In the
//                        case of a text file this usually is the newline
//                        character. This is important to indicate if the tail
//                        section of text string or text file should always
//                        end with the specified Start_ or End_ tag strings.
//   bool Csense_ : Should string comparison of speficied tags be case
//                  sensitive.
//
// POST:
//   Extracts a section of text either ending in the specified string Start_
//   or surrounded by the specified strings Start_ and End_.
//
//   If only the Start_ string is given the _StartPt would indicate the
//   starting point in the extracted text section of where the Start_ string
//   begins and _EndPt would indicate where the Start_ string ends.
//   If both the Start_ and End_ string is given then _StartPt would indicate
//   the starting poin in the extracted text section of where the End_ string
//   begins and _EndPt would indicate where teh End_ string ends.
//
//   Note: The starting and ending tags can also be escaped by a specified
//   tag escape character that is set by the SetTagsEscChar(char) method.
//   String tags prepended with a single or odd number of escape characters
//   will be treated as ordinary non-tag strings.
//
int StringFilter::ReadUntilString(Boolean SkipNl_, Boolean SkipWs_, Boolean HasStart_,
                                  int TestLen_, const char* Delim_,
                                  bool Csense_, bool Continued_)
{
  // typical call to ReadUntilString method:
  //   ReadUntilString("<span", "</span>", 1, 1, 1);
  //
  int ret = 0;
  int lvl;

  if (_InputMethod == USE_SETSTRINGTAGS)
  {
    if (_Next)
    {
      lvl = _NestingLevel;
      ClearNesting();
      SetNestingLevel(lvl);
    }

    return ReadUntilString(_StartTag, _EndTag, SkipNl_, SkipWs_,
                           HasStart_, TestLen_, Delim_, Csense_, Continued_);
  }
  else if (_InputMethod == USE_TAGLIST)
  {
    if (_Next)
    {
      lvl = _NestingLevel;
      ClearNesting();
      SetNestingLevel(lvl);
    }

    _UseTagList = true;
    SFTagElement* Node_ = _TagCntData->GiveFirstSFTagElement();
    SFTagElement* MatchNode_ = NULL;

    if (Node_)
    {
      if (Node_->IsStartTag())
        MatchNode_ = Node_->GiveMatchingTag();

      ret = ReadUntilString(Node_->TagName().c_str(),
                            (MatchNode_ ? MatchNode_->TagName().c_str():NULL),
                            SkipNl_, SkipWs_, HasStart_, TestLen_, Delim_, Csense_, Continued_);
    }
    else
    {
      if (_StartTag)
        ret = ReadUntilString(_StartTag, _EndTag,
                              SkipNl_, SkipWs_, HasStart_,
                              TestLen_, Delim_, Csense_, Continued_);
      else
        ret = ReadUntilString(_TagList[SFTagEnums::STD_DEX],
                              _TagList[SFTagEnums::END_DEX],
                              SkipNl_, SkipWs_, HasStart_,
                              TestLen_, Delim_, Csense_, Continued_);
    }

    _UseTagList = false;
  }

  return ret;
}

/****************************************************************************/
StringFilter& StringFilter::UseInputMethod(int InputType_)
{
  _InputMethod = InputType_;
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SimplifySpaces(bool Flag_)
{
  _SimplifySpaces = Flag_;
  return *this;
}

/****************************************************************************/
char** StringFilter::GiveTagBrkMatrix()
{
  return _TagCntData->GiveTagBrkMatrix();
}

/****************************************************************************/
const char* StringFilter::NextKeyValuePair(const char* Str_, int& Index_, ChrString& Key_, ChrString& Val_)
{
  const char* pos = strchr(Str_, '=');
  const char* kpos = NULL;
  const char* vpos = NULL;
  int qtcnt = 0;
  int done = 0;

  if (pos)
  {
    for (kpos = pos-1; kpos && !isspace(*kpos); kpos--);
    if (kpos)
    {
      Key_ = ChrString(kpos+1, pos-kpos);
      ++done;
    }

    for (vpos = pos+1; *vpos && *vpos != '/' && qtcnt < 2; vpos++)
      if (*vpos == '\"')
        ++qtcnt;
      else if (qtcnt == 0)
        break;

    if (qtcnt == 2)
    {
      ++pos;
      ++done;
      Val_ = ChrString(pos, vpos-pos);
    }

    if (done == 2)
    {
      ++Index_;
      return pos;
    }
  }
  else
    Index_ = -1;

  return NULL;
}

/****************************************************************************/
bool StringFilter::MatchTagBrk(const char* Str_, long Index_, int TagEnd_, int TagType_)
{
  const char* TagStr_ =
  (Str_ && strlen(Str_) >= Index_) ? (Str_ + Index_):NULL;

  if (TagStr_)
    if (TagEnd_ == SFTagEnums::OPENING)
    {
      return
      (
        IsStdTagType() ? (*TagStr_ == '<'):
        _IsCppTag ? (strlen(TagStr_) >= 2 && strncmp(TagStr_, CPPCOMMENTLINEOPEN_STR, 2)):
        (_IsCTag &&
         TagType_ == SFTagEnums::OPENING) ? (strlen(TagStr_) >= 2 && strncmp(TagStr_, COPENCOMMENTBLKOPEN_STR, 2)):
                                          (*TagStr_ == '<')
      );
    }
    else if (TagEnd_ == SFTagEnums::CLOSING)
    {
      return
      (
        IsStdTagType() ? (*TagStr_ == '>'):
        (_IsCTag &&
         TagType_ == SFTagEnums::CLOSING) ? (strlen(TagStr_) >= 2 && strncmp(TagStr_, CCLOSECOMMENTBLKCLOSE_STR, 2)):
                                          (*TagStr_ == '>')
      );
    }

  return false;
}

/****************************************************************************/
void StringFilter::AppendMalJoinedTagStr(ChrString& Temps_, ChrString& sChrStr_, SFTagStringData& Data_, bool OpeningTag_, long plen, long& slen, long& stsp)
{
  long wsp, wsn, wse;
  long tlen = ::SafeStrLen(sChrStr_.c_str());
  const char* Ws_ = " \t\n\r\f\v";
  ChrString Works_;
  
  for (wsp = 0; isspace(_Buffer[wsp]); wsp++);
  for (wsn = 0; isspace(_Next->_Buffer[wsn]); wsn++);
  for (wse = _Next->_Buffer.strlen();
       wse > 0 && isspace(_Next->_Buffer[wse-1]); wse--);
  for (;wse > 0 && !isspace(_Next->_Buffer[wse-1]); wse--);
  if (wsn < wse)
    wsn = wse;

  Temps_.RemoveLeading(Ws_);
  long tglen = strlen(_Buffer(wsp));
  long stslen = OpeningTag_ ? 0:strlen(_Buffer(stsp));
  long wsnlen = strlen(_Next->_Buffer(wsn));
  
  if (plen > tglen)
    plen = tglen;
  
  bool nTag_ = Temps_.strlen() >= tlen && plen <= tglen && tlen > 1 &&
               (isalpha(_Buffer[wsp+plen]) || !_Buffer[wsp+plen]) &&
               strncmp(sChrStr_.c_str(), Temps_.c_str(), tlen) == 0 &&
               strncmp(sChrStr_.c_str(), _Buffer(wsp), tlen) == 0 &&
               (Temps_.strlen() == tlen || isalpha(Temps_[tlen]));
  bool cTag_ = OpeningTag_ ?
                 (strlen(_Buffer(wsp)) >= tlen && tlen <= tglen && tlen > 1 &&
                  (isalpha(_Buffer[wsp+tlen]) || !_Buffer[wsp+tlen]) &&
                  strncmp(sChrStr_.c_str(), _Buffer(wsp), tlen) == 0):
                 (strlen(_Buffer(stsp)) >= tlen && tlen <= stslen && tlen > 1 &&
                  (isalpha(_Buffer[stsp+tlen]) || !_Buffer[stsp+tlen]) &&
                  strncmp(sChrStr_.c_str(), _Buffer(stsp), tlen) == 0);
  bool pTag_ = OpeningTag_ ?
                 (strncmp(sChrStr_.c_str(), _Buffer.c_str(), tlen) != 0 &&
                  tlen <= wsnlen && isalpha(_Buffer[0]) &&
                  strncmp(sChrStr_.c_str(), _Next->_Buffer(wsn), tlen) == 0 &&
                  (strlen(_Next->_Buffer(wsn)) == tlen || isalpha(_Next->_Buffer[wsn+tlen]))):
                 ((strlen(_Buffer(stsp)) < tlen || (strlen(_Buffer(stsp)) >= tlen &&
                   strncmp(sChrStr_.c_str(), _Buffer(stsp), tlen) != 0)) &&
                  tlen <= wsnlen && isalpha(_Buffer[stsp]) &&
                  strncmp(sChrStr_.c_str(), _Next->_Buffer(wsn), tlen) == 0 &&
                  (strlen(_Next->_Buffer(wsn)) == tlen || isalpha(_Next->_Buffer[wsn+tlen])));

  if ((nTag_ || cTag_ || pTag_) && Data_._FindingTag && Data_._TagFound)
  {
    // Pad leading space in case input skipped
    if (OpeningTag_)
    {
      if (Data_._TagType == SFTagEnums::OPENING && (!cTag_ || nTag_))
      {
        ++_StartPt;
        ++_EndPt;
        ++_StartTagStartPt;
        ++_StartTagEndPt;
      }
    }
    else
    {
      if (Data_._TagType == SFTagEnums::CLOSING)
      {
        ++_StartPt;
        ++_EndPt;
        ++_EndTagStartPt;
        ++_EndTagEndPt;
        ++slen;
      }
      else if (Data_._TagType == SFTagEnums::OPENING && (!cTag_ || nTag_))
      {
        ++_StartPt;
        ++_EndPt;
        ++_StartTagStartPt;
        ++_StartTagEndPt;
        ++slen;
      }
    }
    
    if (pTag_)
    {
      if (OpeningTag_)
      {
        Temps_ = ChrString(" ");
        Temps_ += _Buffer;
      }
      else
      {
        Temps_ = ChrString(" ");
        Temps_ += ChrString(_Buffer(stsp));
        Works_ = ChrString(_Buffer.c_str(), stsp);
      }
      
      if (Data_._TagType != SFTagEnums::OPENING)
      {
        ++_StartTagStartPt;
        ++_StartTagEndPt;

        if (!OpeningTag_)
          ++slen;
      }
    }
    else if (cTag_ && !nTag_)
    {
      if (OpeningTag_)
      {
        Temps_ = ChrString(_Buffer.c_str(), wsp+tlen);
        Temps_ += ChrString(" ");
        Temps_ += ChrString(_Buffer(wsp+tlen));
      }
      else
      {
        Temps_ = ChrString(_Buffer(stsp), tlen);
        Temps_ += ChrString(" ");
        Temps_ += ChrString(_Buffer(stsp+tlen));
        Works_ = ChrString(_Buffer.c_str(), stsp);
      }
    }
    else if (nTag_)
    {    
      Works_ = _Buffer;
      Temps_ = Works_.Left(wsp) + Temps_;
      Temps_ += ChrString(" ");
      Works_ = _Buffer;
      Temps_ += Works_.Mid(wsp+plen, Works_.strlen() - (wsp+plen));
            
      if (plen <= stsp && Data_._TagType != SFTagEnums::OPENING)
      {
        ++_StartTagStartPt;
        ++_StartTagEndPt;

        if (!OpeningTag_)
          ++slen;
      }
    }

    if (OpeningTag_)
    {
      _Next->CountColsRows(Temps_.c_str(), _StartPt, 0);
      _Next->AppendToInput(Temps_.c_str(), _StartPt);
      _Buffer = Temps_;
      slen = ::SafeStrLen(_Buffer(_StartPt));
    }
    else
    {
      stsp = _StartTagStartPt;
      _Next->CountColsRows(Temps_.c_str(), _EndPt-stsp, 0);
      _Next->AppendToInput(Temps_.c_str(), _EndPt-stsp);
      
      if (pTag_ || (cTag_ && !nTag_))
        _Buffer = stsp ? (Works_ + Temps_):Temps_;
      else if (nTag_)
        _Buffer = Temps_;
    }
  }
  else
  {
    if (OpeningTag_)
    {
      _Next->CountColsRows(_Buffer.c_str(), _StartPt, 0);
      _Next->AppendToInput(_Buffer.c_str(), _StartPt);
    }
    else
    {
      _Next->CountColsRows(_Buffer(stsp), _EndPt-stsp, 0);
      _Next->AppendToInput(_Buffer(stsp), _EndPt-stsp);
    }
  }
}

/****************************************************************************/
void StringFilter::AppendToInput(char* Buffer_, long Len_)
{
  long len = _Buffer.strlen();
  _Buffer += ChrString(Buffer_, Len_);
  len += Len_;
  _Buffer[len] = 0;
  _SavedLen += Len_;
}

/****************************************************************************/
StringFilter* StringFilter::Next(int x)
{
  StringFilter* Old_ = _Next;
  StringFilter* Cur_ = this;

  while (Old_ && x)
  {
    --x;
    Cur_ = Old_;
    Old_ = Old_->_Next;
  }

  return Cur_;
}

/****************************************************************************/
StringFilter& StringFilter::ClearNesting()
{
  StringFilter* Old_ = Pop();

  while (Old_)
  {
    delete Old_;
    Old_ = Pop();
  }

  _Next = NULL;
  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::SetInputFile(const char* Fname_, int NestingLevel_)
{
  if (Fname_)
  {
    _Frp = new FileReader();
    _Frp->Open(Fname_, ios::in);

    _MainFileName = new_char_string(Fname_);
    _NestingMax = NestingLevel_;
    _NestingLevel = NestingLevel_;
    _NestingNo = 0;
    _Buffer.StrFill(0, BUFSIZE);
  }

  return *this;
}

/****************************************************************************/
StringFilter& StringFilter::ResetStreams()
{
  _Frp->ClearState();
  _Frp->GetInStream().clear(ios::goodbit);
  _Frp->ResetStreams();

  return *this;
}

/****************************************************************************/
int StringFilter::IsMonth(const char* Str_)
{
  if (!Str_)
    return 0;

  return
  (
    (StrniComp(Str_, "sep", 3) == 0) ||
    (StrniComp(Str_, "oct", 3) == 0) ||
    (StrniComp(Str_, "nov", 3) == 0) ||
    (StrniComp(Str_, "dec", 3) == 0) ||

    (StrniComp(Str_, "jan", 3) == 0) ||
    (StrniComp(Str_, "feb", 3) == 0) ||
    (StrniComp(Str_, "mar", 3) == 0) ||
    (StrniComp(Str_, "apr", 3) == 0) ||

    (StrniComp(Str_, "may", 3) == 0) ||
    (StrniComp(Str_, "jun", 3) == 0) ||
    (StrniComp(Str_, "jul", 3) == 0) ||
    (StrniComp(Str_, "aug", 3) == 0)
  );
}

/****************************************************************************/
int StringFilter::IsDateStr(const char* Str_)
{
  char TestStr_[32];
  strncpy(TestStr_, Str_, 31);
  TestStr_[31] = 0;
  RemovePadding(TestStr_, " \t\n");

  if (isdigit(TestStr_[0]))
  {
    if (isdigit(TestStr_[1]))
    {
      if (IsMonth(TestStr_ + 2))
        return (strlen(TestStr_+2) >= 5 &&
                isdigit(TestStr_[5]) &&
                isdigit(TestStr_[6]));
      else
        return FALSE;
    }
    else
    {
      if (IsMonth(TestStr_ + 1))
        return (strlen(TestStr_+1) >= 5 &&
                isdigit(TestStr_[4]) &&
                isdigit(TestStr_[5]));
      else
        return FALSE;
    }
  }

  return FALSE;
}

/****************************************************************************/
MEMORYOPS_DEFN(StringFilter)

}; // end: namespace Testing

/****************************************************************************/
/****************************************************************************/
#if STRFILTER_DEBUG
using namespace Testing;

char** GrowTokArray(char** TokArray_, int Incr_)
{
  int x, oldsz;
  int Size_ = (int)TokArray_[0][0];
  char** OldArr_ = TokArray_;

  ++Size_;
  oldsz = Size_;
  Size_ += Incr_;
  TokArray_ = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * Size_);

  for (x = 0; x < oldsz; x++)
    TokArray_[x] = OldArr_[x];

  for (;x < Size_; x++)
    TokArray_[x] = NULL;

  TokArray_[0][0] = Size_ - 1;
  TokArray_[0][1] = 0;
  ::DeleteArray(OldArr_);

  return TokArray_;
}

/****************************************************************************/
char** InitTokArray(char** TokArray_)
{
  int x, max;

  max = 11;
  TokArray_ = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * max);
  TokArray_[0] = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 2);
  TokArray_[0][0] = max - 1;
  TokArray_[0][1] = 0;

  for (x = 1; x < max; x++)
    TokArray_[x] = NULL;

  return TokArray_;
}

/****************************************************************************/
char** ClearTokArray(char** TokArray_)
{
  int x, max;

  max = (int)TokArray_[0][0];
  ++max;

  for (x = 0; x < max; x++)
    ::DeleteArray(TokArray_[x]);

  ::DeleteArray(TokArray_);
  TokArray_ = NULL;

  return TokArray_;
}

/****************************************************************************/
void ShowTokArray(char** TokArray_, int& st, int sz)
{
  for (;st < sz; st++)
    cout <<TokArray_[st] <<endl;

  cout <<endl;
}

/****************************************************************************/
// -<symbolname:Symbol_Type:symattr:datatype:structtype;>
// -<symbolname:Operator_Type:symattr:datatype:structtype:optype;>
// -<symbolname:Sequence_Type:seqtype:
//    {decltype if seqtype==declaration |
//     defntype if seqtype==definition}
//   structtype:symattr:datatype:Continue=n|End;>
// -<symbolname:BracketedSymbol_Type:LeftBracket:datatype:structtype:Delim=c|NoDelim:pushblk:pushfnc>
// <BracketedSymbol_Type:Data:datatype:Delim=c|NoDelim:Continue=n|End>
// <BracketedSymbol_Type:LeftBracket:datatype:structtype:Delim=c|NoDelim:pushblk:pushfnc>
// <BracketedSymbol_Type:RightBracket:datatype:structtype:Delim=c|NoDelim:pushblk:pushfnc;>
//
char** ReadTextFile(StringFilter* sfilter_, int& sz, char** TokArray_)
{
  int len, max;
  char* RetStr_ = NULL;
  const char* RdStr_;
  ChrString RealStr_;
  char StartTag_[3];
  bool EndRead_ = false;

  max = (int)TokArray_[0][0] + 1;
  strcpy(StartTag_, "-<");

  while (!EndRead_)
  {
    if (sfilter_->ReadUntilString(StartTag_, ">", 1, 1, 1, 0, 0))
    {
      RdStr_ = sfilter_->GetBuffer();
      RealStr_ += RdStr_;
      len = strlen(RdStr_);

      if (strcmp(RdStr_+len-2, ";>") == 0)
      {
        RetStr_ = new_char_string(RealStr_.c_str());
        TokArray_[sz++] = RetStr_;
        EndRead_ = true;
      }
      else
      {
        RetStr_ = new_char_string(RealStr_.c_str());
        TokArray_[sz++] = RetStr_;
        RealStr_ = "";
        strcpy(StartTag_, "<");
      }

      if (sz == max)
      {
        TokArray_ = GrowTokArray(TokArray_, 10);
        max = (int)TokArray_[0][0] + 1;
      }
    }

    if (sfilter_->GetFileReader()->EndOfFile())
      EndRead_ = true;
  }

  return TokArray_;
}

/****************************************************************************/
bool HasThisElement(ChrString& Key_, int ElmIndex_, int ElmMax_, int argc, char* argv[])
{
  int max = ElmIndex_ + ElmMax_;
  if (max > argc)
    return false;

  int x;
  for (x = ElmIndex_; x < max; x++)
    if (StriComp(Key_.c_str(), argv[x]) == 0)
      return true;

  return false;
}

/****************************************************************************/
int main(int argc, char* argv[])
{
#if STRFILTER_DEBUG1
  StringFilter* sfilter_ = new StringFilter("symtestdata.txt");
  system("cls");
  sfilter_->SetTagsEscChar('\\');

  int sz = 1;
  int st = 1;
  char** TokArray_;
  TokArray_ = InitTokArray(TokArray_);

  while (!sfilter_->GetFileReader()->EndOfFile())
  {
    TokArray_ = ReadTextFile(sfilter_, sz, TokArray_);
    ShowTokArray(TokArray_, st, sz);
  }

  TokArray_ = ClearTokArray(TokArray_);

  delete sfilter_;
  return 0;
#endif

#if STRFILTER_DEBUG2
  long strow;
  long stsp;
  long step;
  long etrow;
  long etsp;
  long etep;
  const char* Bufp;
  char Buffer[1024];
  int Nest_ = 1;
  int x;

  system("cls");
  StringFilter* sfilter_ = new StringFilter("nestedsymtest.html", Nest_);
  sfilter_->SimplifySpaces(true);
  
  sfilter_->SetParseHtmlTag(true);
  sfilter_->ReadUntilString("<span", "</span>", 1, 1, 1);
  cout <<"col: " <<sfilter_->Column() <<"\trow: " <<sfilter_->Row() <<endl;
  x = 0;

    strow = sfilter_->Next(x)->GetStartTagRow();
    stsp = sfilter_->Next(x)->GetStartTagStartPt();
    step = sfilter_->Next(x)->GetStartTagEndPt();
    etrow = sfilter_->Next(x)->GetEndTagRow();
    etsp = sfilter_->Next(x)->GetEndTagStartPt();
    etep = sfilter_->Next(x)->GetEndTagEndPt();    
    Bufp = sfilter_->Next(x)->GetBuffer();

    cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
         <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
    strncpy(Buffer, &Bufp[stsp], step-stsp);
    Buffer[step-stsp] = 0;
    cout <<"Start Tag: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[step], etsp-step);
    Buffer[etsp-step] = 0;
    cout <<"Content: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[etsp], etep-etsp);
    Buffer[etep-etsp] = 0;
    cout <<"End Tag: " <<Buffer <<endl;

  Nest_ = 2;
  sfilter_->SetNestingLevel(Nest_);
  sfilter_->ReadUntilString("<div", "</div>", 1, 1, 1);
  cout <<endl
       <<"--------------------------------------------------------------------------------"
       <<endl;
  cout <<"col: " <<sfilter_->Column() <<"\trow: " <<sfilter_->Row() <<endl;
  x = 0;

    strow = sfilter_->Next(x)->GetStartTagRow();  
    stsp = sfilter_->Next(x)->GetStartTagStartPt();
    step = sfilter_->Next(x)->GetStartTagEndPt();
    etrow = sfilter_->Next(x)->GetEndTagRow();    
    etsp = sfilter_->Next(x)->GetEndTagStartPt();
    etep = sfilter_->Next(x)->GetEndTagEndPt();
    Bufp = sfilter_->Next(x)->GetBuffer();

    cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
         <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
    strncpy(Buffer, &Bufp[stsp], step-stsp);
    Buffer[step-stsp] = 0;
    cout <<"Start Tag: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[step], etsp-step);
    Buffer[etsp-step] = 0;
    cout <<"Content: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[etsp], etep-etsp);
    Buffer[etep-etsp] = 0;
    cout <<"End Tag: " <<Buffer <<endl;

  cout <<endl
       <<"--------------------------------------------------------------------------------"
       <<endl;
  sfilter_->SetParseHtmlTag(false);
  sfilter_->ReadUntilFound("<div style=", NULL, "\n", TRUE);
  cout <<"col: " <<sfilter_->Column() <<"\trow: " <<sfilter_->Row() <<endl;
  strow = sfilter_->GetStartTagRow();
  stsp = sfilter_->GetStartPt();
  step = sfilter_->GetEndPt();
  Bufp = sfilter_->GetBuffer();

  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl;
  cout <<"Buffer: " <<Bufp <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;

  sfilter_->ReadUntilFound("\"css-gen3\">Weather:", NULL, "\n", TRUE);
  cout <<"col: " <<sfilter_->Column() <<"\trow: " <<sfilter_->Row() <<endl;
  strow = sfilter_->GetStartTagRow();
  stsp = sfilter_->GetStartTagStartPt();
  step = sfilter_->GetStartTagEndPt();
  Bufp = sfilter_->GetBuffer();

  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl;
  cout <<"Buffer: " <<Bufp <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;

  sfilter_->SetParseHtmlTag(true);
  sfilter_->ReadUntilFound("<span class", "</span>", "\n", TRUE);
  cout <<"col: " <<sfilter_->Column() <<"\trow: " <<sfilter_->Row() <<endl;
  strow = sfilter_->GetStartTagRow();
  stsp = sfilter_->GetStartTagStartPt();
  step = sfilter_->GetStartTagEndPt();
  etrow = sfilter_->GetEndTagRow();
  etsp = sfilter_->GetEndTagStartPt();
  etep = sfilter_->GetEndTagEndPt();
  Bufp = sfilter_->GetBuffer();

  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
       <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;
  strncpy(Buffer, &Bufp[etep], etsp-step);
  Buffer[etsp-step] = 0;
  cout <<"Content: " <<Buffer <<endl;
  strncpy(Buffer, &Bufp[etsp], etep-etsp);
  Buffer[etep-etsp] = 0;
  cout <<"End Tag: " <<Buffer <<endl;

  delete sfilter_;
#endif

#if STRFILTER_DEBUG3
  long stsp;
  long step;
  long strow;
  long etsp;
  long etep;
  long etrow;
  const char* Bufp;
  char Buffer[1024];
  SFTagElement* Nodep_;
  int Nest_;
  int x;

  #if STRFILTER_DEBUG3b
    Nest_ = 2;
  #else
    Nest_ = 1;
  #endif

  system("cls");
  StringFilter* sf_ = new StringFilter("nestedsymtest.html", Nest_);
  sf_->SimplifySpaces(true);
  
  sf_->SetStdTagSet(SFTagEnums::HTML_TAGSET);
  sf_->SetStringTags("span", NULL, "span", NULL, SFTagEnums::STD_TAG);
  Nodep_ = sf_->AddStringTag(SFTagEnums::OPENING, sf_->StartTag(), sf_->StartTagEnd(),
                             NULL, SFTagEnums::STD_TAG);
  sf_->AddStringTag(SFTagEnums::CLOSING, sf_->EndTag(), sf_->EndTagEnd(), Nodep_);

  #if STRFILTER_DEBUG3b
    sf_->SetStringTags("div", NULL, "div", NULL, SFTagEnums::STD_TAG);
    Nodep_ = sf_->AddStringTag(SFTagEnums::OPENING, sf_->StartTag(), sf_->StartTagEnd(),
                               NULL, SFTagEnums::STD_TAG);
    sf_->AddStringTag(SFTagEnums::CLOSING, sf_->EndTag(), sf_->EndTagEnd(), Nodep_);
  #endif

  sf_->UseInputMethod(SFTagEnums::USE_TAGLIST);
  sf_->ReadUntilString(1, 1, 1);
  cout <<"col: " <<sf_->Column() <<"\trow: " <<sf_->Row() <<endl;

  for (x = 0; x <= Nest_; x++)
  {
    strow = sf_->Next(x)->GetStartTagRow();
    stsp = sf_->Next(x)->GetStartTagStartPt();
    step = sf_->Next(x)->GetStartTagEndPt();
    etrow = sf_->Next(x)->GetEndTagRow();
    etsp = sf_->Next(x)->GetEndTagStartPt();
    etep = sf_->Next(x)->GetEndTagEndPt();    
    Bufp = sf_->Next(x)->GetBuffer();

    cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
         <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
    strncpy(Buffer, &Bufp[stsp], step-stsp);
    Buffer[step-stsp] = 0;
    cout <<"Start Tag: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[step], etsp-step);
    Buffer[etsp-step] = 0;
    cout <<"Content: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[etsp], etep-etsp);
    Buffer[etep-etsp] = 0;
    cout <<"End Tag: " <<Buffer <<endl;
  }

  #if STRFILTER_DEBUG3b
    Nest_ = 4;
  #else
    Nest_ = 2;
  #endif
  
  sf_->SetNestingLevel(Nest_);

  #if STRFILTER_DEBUG3a
    sf_->DeleteTagList(SFTagEnums::STD_TAG);
    sf_->SetStringTags("div", NULL, "div", NULL, SFTagEnums::STD_TAG);
    Nodep_ = sf_->AddStringTag(SFTagEnums::OPENING, sf_->StartTag(), sf_->StartTagEnd(),
                               NULL, SFTagEnums::STD_TAG);
    sf_->AddStringTag(SFTagEnums::CLOSING, sf_->EndTag(), sf_->EndTagEnd(), Nodep_);
  #endif

  sf_->UseInputMethod(SFTagEnums::USE_TAGLIST);
  sf_->ReadUntilString(1, 1, 1);  
  cout <<endl
       <<"--------------------------------------------------------------------------------"
       <<endl;
  cout <<"col: " <<sf_->Column() <<"\trow: " <<sf_->Row() <<endl;       

  for (x = 0; x <= Nest_; x++)
  {
    strow = sf_->Next(x)->GetStartTagRow();  
    stsp = sf_->Next(x)->GetStartTagStartPt();
    step = sf_->Next(x)->GetStartTagEndPt();
    etrow = sf_->Next(x)->GetEndTagRow();    
    etsp = sf_->Next(x)->GetEndTagStartPt();
    etep = sf_->Next(x)->GetEndTagEndPt();
    Bufp = sf_->Next(x)->GetBuffer();

    cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
         <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
    strncpy(Buffer, &Bufp[stsp], step-stsp);
    Buffer[step-stsp] = 0;
    cout <<"Start Tag: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[step], etsp-step);
    Buffer[etsp-step] = 0;
    cout <<"Content: " <<Buffer <<endl;
    strncpy(Buffer, &Bufp[etsp], etep-etsp);
    Buffer[etep-etsp] = 0;
    cout <<"End Tag: " <<Buffer <<endl;
  }

  cout <<endl
       <<"--------------------------------------------------------------------------------"
       <<endl;

  sf_->UseInputMethod(SFTagEnums::USE_SETSTRINGTAGS);
  sf_->ClearTagType(true);
  sf_->ReadUntilFound("<div style=", NULL, "\n", TRUE);
  cout <<"col: " <<sf_->Column() <<"\trow: " <<sf_->Row() <<endl;
  strow = sf_->GetStartTagRow();
  stsp = sf_->GetStartPt();
  step = sf_->GetEndPt();
  Bufp = sf_->GetBuffer();
  
  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl;
  cout <<"Buffer: " <<Bufp <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;

  sf_->ReadUntilFound("\"css-gen3\">Weather:", NULL, "\n", TRUE);
  cout <<"col: " <<sf_->Column() <<"\trow: " <<sf_->Row() <<endl;
  strow = sf_->GetStartTagRow();  
  stsp = sf_->GetStartTagStartPt();
  step = sf_->GetStartTagEndPt();
  Bufp = sf_->GetBuffer();
  
  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl;
  cout <<"Buffer: " <<Bufp <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;

  #if STRFILTER_DEBUG3b
    sf_->SetStdTagSet(SFTagEnums::HTML_TAGSET);
    sf_->SetStringTags("span class", NULL, "span", NULL, SFTagEnums::STD_TAG);
    Nodep_ = sf_->AddStringTag(SFTagEnums::OPENING, sf_->StartTag(), sf_->StartTagEnd(),
                               NULL, SFTagEnums::STD_TAG);
    sf_->AddStringTag(SFTagEnums::CLOSING, sf_->EndTag(), sf_->EndTagEnd(), Nodep_);
  #elif STRFILTER_DEBUG3a1
    sf_->DeleteTagList(SFTagEnums::STD_TAG);
    sf_->SetStdTagSet(SFTagEnums::HTML_TAGSET);

    sf_->SetStringTags("span class", NULL, "span", NULL, SFTagEnums::STD_TAG);
    Nodep_ = sf_->AddStringTag(SFTagEnums::OPENING, sf_->StartTag(), sf_->StartTagEnd(),
                               NULL, SFTagEnums::STD_TAG);
    sf_->AddStringTag(SFTagEnums::CLOSING, sf_->EndTag(), sf_->EndTagEnd(), Nodep_);
    sf_->UseInputMethod(SFTagEnums::USE_TAGLIST);
  #endif

  #if STRFILTER_DEBUG3a1
    sf_->ReadUntilFound("\n", TRUE);
  #elif STRFILTER_DEBUG3b
    sf_->ReadUntilFound("\n", TRUE);
  #elif STRFILTER_DEBUG3a2
    sf_->SetParseHtmlTag(true);
    sf_->ReadUntilFound("<span class", "</span>", "\n", TRUE);
  #endif

  cout <<"col: " <<sf_->Column() <<"\trow: " <<sf_->Row() <<endl;
  strow = sf_->GetStartTagRow();  
  stsp = sf_->GetStartTagStartPt();
  step = sf_->GetStartTagEndPt();
  etrow = sf_->GetEndTagRow();
  etsp = sf_->GetEndTagStartPt();
  etep = sf_->GetEndTagEndPt();
  Bufp = sf_->GetBuffer();

  cout <<" strow: " <<strow <<" stsp: " <<stsp <<" step: " <<step <<endl
       <<" etrow: " <<etrow <<" etsp: " <<etsp <<" etep: " <<etep <<endl;
  strncpy(Buffer, &Bufp[stsp], step-stsp);
  Buffer[step-stsp] = 0;
  cout <<"Start Tag: " <<Buffer <<endl;
  strncpy(Buffer, &Bufp[etep], etsp-step);
  Buffer[etsp-step] = 0;
  cout <<"Content: " <<Buffer <<endl;
  strncpy(Buffer, &Bufp[etsp], etep-etsp);
  Buffer[etep-etsp] = 0;
  cout <<"End Tag: " <<Buffer <<endl;

  delete sf_;
#endif
}

#endif
/****************************************************************************/
#endif
