#ifndef STRFILTER_H
#define STRFILTER_H

#ifndef FILEREADER_H
  #include "filereader.h"
#endif
#ifndef FULLDATE_H
  #include "fulldate.h"
#endif
#ifndef SIMPLELIST_CPP
  #include "simplelist.cpp"
#endif
#ifndef TAGELEMENT_H
  #include "tagelement.h"
#endif

#define STRFILTER_DEBUG         0
#define STRFILTER_DEBUG1        0
#define STRFILTER_DEBUG2        0
#define STRFILTER_DEBUG3        0
#define STRFILTER_DEBUG3a       0
#define STRFILTER_DEBUG3a1      0
#define STRFILTER_DEBUG3a2      0
#define STRFILTER_DEBUG3b       0

/****************************************************************************/
// Start: namespace Testing
namespace Testing
{

struct SFTagEnums
{
  enum
  {
    VALIDITY       = 0,    // active, inactive or ignored during search
    NESTING        = 1,    // nesting level of found tag
    TAGCOUNT       = 2,    // times tag was found in search string
    TAGATTR        = 3,    // tag attributes permission and status
    TAGINDEX       = 4,    // index into tag list
    TAGELEMENTS    = 5,    // number of elements in specific tag list
    LISTINDEX      = 6,    // index into tag matrix
    MAX_FIELD_DATA = 7,

    CLOSING = 0,           // Closing tag
    OPENING = 1,           // Opening tag

    TAGLISTMATRIX_SIZE = 7,

    DOCTYPE_DEX            = 0,  // +1 for ending tag of tag pair entry
    COMMENT_DEX            = 2,
    NESTEDCOMMENT1_DEX     = 4,
    NESTEDCOMMENT2_DEX     = 6,
    STD_DEX                = 8,
    END_DEX                = 10,
    EMPTY_DEX              = 12,
    SCRIPT_DEX             = 14,
    COPENCOMMENTBLK_DEX    = 16,
    CCLOSECOMMENTBLK_DEX   = 18,
    CPPCOMMENTLINEOPEN_DEX = 20,

    DOCTYPE_TAG            = 1,
    COMMENT_TAG            = 2,
    NESTEDCOMMENT1_TAG     = 4,
    NESTEDCOMMENT2_TAG     = 8,
    STD_TAG                = 16,
    END_TAG                = 32,
    EMPTY_TAG              = 64,
    SCRIPT_TAG             = 128,
    COPENCOMMENTBLK_TAG    = 256,
    CCLOSECOMMENTBLK_TAG   = 512,
    CPPCOMMENTLINEOPEN_TAG = 1024,

    TAGLIST_LENGTH        = 24,  // 2 extra entries
    TAGLIST_MAX_ENTRIES   = 22,  // 11 start + end pairs

    HTML_TAGSET           = 1,
    XHTML_TAGSET          = 2,
    XML_TAGSET            = 3,
    CPP_TAGSET            = 4,
    C_TAGSET              = 5,

    IGNORED               = 0,   // or inapplicable
    ACTIVE                = 1,
    INACTIVE              = 2,

    ROWCOL_DATA           = 1,
    TAGPOS_DATA           = 2,
    CONTENT_DATA          = 4,
    TAGATTR_DATA          = 8,
    SEQNO_DATA            = 16,
    NESTINGNO_DATA        = 32,
    TAGTYPE_DATA          = 64,
    PARSE_FILE            = 128,
    PARSE_LINE            = 256,

    SINGLETON_TAGATTR     = 1,
    EMPTY_TAGATTR         = 2,
    ALLOW_SINGLETON_TAG   = 4,
    ALLOW_EMPTY_TAG       = 8,
    TAG_SPECIFIC          = 16,

    USE_FUNCTIONARGS      = 100,
    USE_SETSTRINGTAGS     = 200,
    USE_TAGLIST           = 300,

    MATCH_TAGTYPE         = 8192,
    NO_TAGTYPE            = 16384
  };
};

/****************************************************************************/
// 0th element: valid tag = { 0 = ignore, 1 = active, 2 = inactive }
// 1st element: nesting level = unsigned integer
// 2nd element: tag element counter = unsigned integer
// 3rd element: tag attrib bits =
//                { 0 = normal,
//                  1 = singleton,
//                  2 = empty,
//                  4 = allow singleton,
//                  8 = allow empty }
//
// 4th element: index into individual tag element list for each element type
//
// For int TagAttrib[] :
//   VALIDITY = 0,
//   NESTING  = 1,
//   TAGCOUNT = 2,
//   TAGATTR  = 3,
//   TAGINDEX = 4,
//   LISTSEQ  = 5
//
class SFTagElement : public SFTagEnums
{
  protected:
    int _TagAttrib[5];
    ChrString _TagName;
    ChrString _TagEnder;
    bool _StartTag;
    SFTagElement* _MatchTag;

  public:
    SFTagElement(bool Starter_, int ElementIndex_, int* ParentAttr_=NULL);
    SFTagElement(const SFTagElement& Obj_);

    SFTagElement& IncrTagAttrib(int Attr_);
    SFTagElement& SetTagAttrib(int Attr_, int Value_);
    SFTagElement& SetSFTagElement(const char* Tag_, const char* TagEnder_);
    SFTagElement& SetMatchingTag(SFTagElement* MatchTag_, bool Terminate_=false);
    SFTagElement& operator = (const SFTagElement& Obj_);

    inline int TagAttrib(int Attr_) const
        { return _TagAttrib[Attr_]; }
    inline const ChrString& TagName() const
        { return _TagName; }
    inline const ChrString& TagEnder() const
        { return _TagEnder; }
    inline bool IsStartTag() const
        { return _StartTag; }
    inline SFTagElement* GiveMatchingTag()
        { return _MatchTag; }
    int TagBrkIndex(int BrkType_) const;

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif

    EXTERNALCLASSFNCS_STUB(SFTagElement, SFTagElement)
    CLONEFNCS_INLINE_DEFN(SFTagElement)
};

/****************************************************************************/
// 0th element: valid tag = { 0 = ignore, 1 = active, 2 = inactive }
// 1st element: nesting level = unsigned integer
// 2nd element: tag opener / tag closer counter = unsigned integer
// 3rd element: tag attrib bits =
//                { 0  = normal,
//                  1  = singleton,
//                  2  = empty,
//                  4  = allow singleton,
//                  8  = allow empty,
//                  16 = tag element specific }
// 4th element: index into individual tag element list for each element type
// 5th element: number of individual tag elements using tag opener / closer,
//              0 for none specified -- only tag opener / closer searched
//

class StringFilter;     // String filter class forward declaration

class SFTagCountData : public SFTagEnums
{
  typedef SearchableList<SFTagElement>* TAGLISTPTR;
  typedef SearchableList<SFTagElement>** TAGLISTMATRIX;
  typedef SimpleListModifier<SFTagElement>* TAGLISTMODIFIER;

  // Tag list indexes
  protected:
    int _TagCntIndex;
    int _TagBrkIndex;
    int _TagLstIndex;

    // Tag list counters
    int _DocTypeOpen_Cnt[MAX_FIELD_DATA];
    int _DocTypeClose_Cnt[MAX_FIELD_DATA];
    int _CommentOpen_Cnt[MAX_FIELD_DATA];
    int _CommentClose_Cnt[MAX_FIELD_DATA];
    int _NestedComment1Open_Cnt[MAX_FIELD_DATA];
    int _NestedComment1Close_Cnt[MAX_FIELD_DATA];
    int _NestedComment2Open_Cnt[MAX_FIELD_DATA];
    int _NestedComment2Close_Cnt[MAX_FIELD_DATA];
    int _StdTagOpen_Cnt[MAX_FIELD_DATA];
    int _StdTagClose_Cnt[MAX_FIELD_DATA];
    int _EndTagOpen_Cnt[MAX_FIELD_DATA];
    int _EndTagClose_Cnt[MAX_FIELD_DATA];
    int _EmptyOpen_Cnt[MAX_FIELD_DATA];
    int _EmptyClose_Cnt[MAX_FIELD_DATA];
    int _ScriptOpen_Cnt[MAX_FIELD_DATA];
    int _ScriptClose_Cnt[MAX_FIELD_DATA];
    int _COpenCommentBlkOpen_Cnt[MAX_FIELD_DATA];
    int _COpenCommentBlkClose_Cnt[MAX_FIELD_DATA];
    int _CCloseCommentBlkOpen_Cnt[MAX_FIELD_DATA];
    int _CCloseCommentBlkClose_Cnt[MAX_FIELD_DATA];
    int _CppCommentLineOpen_Cnt[MAX_FIELD_DATA];
    int _CppCommentLineClose_Cnt[MAX_FIELD_DATA];

    TAGLISTPTR _DocTypeTagList;
    TAGLISTPTR _StdTagList;
    TAGLISTPTR _EndTagList;
    TAGLISTPTR _EmptyTagList;
    TAGLISTPTR _COpenCommentTagList;
    TAGLISTPTR _CCloseCommentTagList;
    TAGLISTPTR _CppCommentTagList;

    int** _TagCntMatrix;
    char** _TagBrkMatrix;
    TAGLISTMATRIX _TagMatrix;
    TAGLISTMODIFIER _TagListBrowser;
    
  public:    
    SFTagCountData();
    ~SFTagCountData();

    SFTagCountData& CopyTagCount(const SFTagCountData* TagCnt_);
    SFTagCountData& AddTagBrk(const char* Str_);
    SFTagCountData& DeleteTagList(int TagIndex_);
    SFTagElement* AddToTagList(int TagPos_, const char* Tag_, const char* TagEnder_,
                             SFTagElement* MatchingTag_, int TagIndex_);
    SFTagElement* GetNextSFTagElement(int TagIndex_);
    SFTagElement* GetCurrentSFTagElement(int TagIndex_);
    SFTagCountData& ResetTagListIndex(int TagIndex_);
    SFTagCountData& SetTagListIndex(int TagIndex_, int ElementIndex_);
    SFTagElement* GiveFirstSFTagElement();

    SFTagCountData& InitTagCounts();
    SFTagCountData& ResetTagCounts();
    void ResetHtmlTags();
    void ResetXHtmlTags();
    void ResetXmlTags();
    void ResetCppTags();
    void ResetCTags();

    inline int** GiveTagCntMatrix()
        { return _TagCntMatrix; }
    inline char** GiveTagBrkMatrix()
        { return _TagBrkMatrix; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif

    EXTERNALCLASSFNCS_STUB(SFTagCountData, SFTagCountData)
    CLONEFNCS_INLINE_DEFN(SFTagCountData)
};

/****************************************************************************/
class SFTagFoundData
{
  public:
    long _RowCnt;
    long _ColCnt;

    long _EndPt;
    long _StartPt;
    long _StartTagRow;
    long _StartTagEndPt;
    long _StartTagStartPt;
    long _EndTagRow;
    long _EndTagEndPt;
    long _EndTagStartPt;
    
    bool _IsHtmlTag;
    bool _IsXHtmlTag;
    bool _IsXmlTag;
    bool _IsCppTag;
    bool _IsCTag;
    bool _IsNonStdTag;
    bool _IsSingletonTag;
    bool _IsEmptyTag;
    bool _SingletonTagAllowed;
    bool _EmptyTagAllowed;
    bool _SimplifySpaces;

    char* _StartTag;
    char* _StartTagEnd;
    char* _EndTag;
    char* _EndTagEnd;
    char _TagEsc;

    int _SeqNo;
    int _NestingNo;
    int _TagListIndex;
    StringFilter* _Parent;

  public:
    SFTagFoundData();
    SFTagFoundData(const SFTagFoundData& Obj_);
    SFTagFoundData(StringFilter* Parent_, int SeqNo_);
    ~SFTagFoundData();

    SFTagFoundData* Restore(StringFilter* Ptr_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif

    EXTERNALCLASSFNCS_STUB(SFTagFoundData, SFTagFoundData)
    CLONEFNCS_INLINE_DEFN(SFTagFoundData)
};

/****************************************************************************/
class SFStringFoundData;
struct SFTagStringData
{
  istream* pIs_;
  int TagType_;
  int SeqType_;
  long* pBufIndex_;
  short LenVectIndex_;
  long* pIndex_;
  long* pTotal_;
  long* pAdded_;  
  long* len;
  const char* Delim_;
  bool Csense_;
  const char* Ptr_;
  const char* sPtr_;
  const char* ePtr_;
  bool Continued_;
  bool SvOver_;
  bool IndexSpecified_;
  long _RewindedLen;
  bool _RevTagLen;
  bool _RevReadLen;
  bool _Eof;
  bool _FindingTag;
  bool _TagFound;
  bool _NewLine;
  int _TagType;
  int _TagBrkType;

  SFStringFoundData* StrDataNode_;
  SFTagElement* ElementNode_;
  long StartPoint_;
  long EndPoint_;
  int TagIndex_;
  long* pDataAdded_;

  long* oldlen;
  bool Cont_;

  SFTagStringData();
};

/****************************************************************************/
class StringFilter;
class SFStringFoundData
{
  private:
    ChrString _Buffer;

    long _len[5];
    long _Index;
    long _TagEscCnt;
    long _NonEscCnt;
    long _BufIndex;
    long _Cnt;
    long _Total;
    long _Diff;    

    long _StartPt;
    long _EndPt;
    long _EndTagRow;
    long _EndTagStartPt;
    long _EndTagEndPt;
    long _StartTagRow;
    long _StartTagStartPt;
    long _StartTagEndPt;

    bool _HaveTagEsc;
    bool _HaveTag;
    bool _BreakonStartTag;
    bool _BreakonEndTag;
    bool _InTag;

  public:
    SFStringFoundData();
    SFStringFoundData(const SFStringFoundData& Obj_);

    SFStringFoundData* Save(StringFilter* Ptr_);
    SFStringFoundData* Restore(StringFilter* Ptr_);
    SFStringFoundData* Save(StringFilter* Ptr_, long Index_, long* len);
    SFStringFoundData* Restore(StringFilter* Ptr_, long& Index_, long* len);
    SFStringFoundData* AddData(StringFilter* Ptr_, long& BufIndex_, long& cnt,
                             long& Total_, long* len, bool Cont_,
                             short LenVectIndex_, SFTagStringData& Data_);
    SFStringFoundData* ReturnData(StringFilter* Ptr_, long& BufIndex_, long& cnt, long& Total_,
                                long& SavedLen_, long* len, SFTagStringData& Data_);

    inline long SavedLength() const
        { return _len[4]; }
    inline long TagLengthDiff() const
        { return _Diff; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif

    EXTERNALCLASSFNCS_STUB(SFStringFoundData, SFStringFoundData)
    CLONEFNCS_INLINE_DEFN(SFStringFoundData)
};

/****************************************************************************/
class StringFilter : public SFTagEnums
{
  friend class SFTagFoundData;
  friend class SFStringFoundData;
  
  private:
    FileReader* _Frp;
    Boolean _GetchFromTemp;
    ChrString _Buffer;
    ChrString _EndLine;
    ChrString _LineToFind;
    char* _MainFileName;
    char* _EndReadMark;
    int _NestingMax;
    int _NestingLevel;
    int _NestingNo;

    StringFilter* _Next;
    StringFilter* _Prev;

    long _SavedIndex;
    long _SavedLen;
    long _SavedOver;
    istream* _SavedStream;
    bool _LineFound;
    char _EndLineDelim;

    long _RowCnt;
    long _ColCnt;

    long _EndPt;
    long _StartPt;
    long _StartTagRow;
    long _StartTagEndPt;
    long _StartTagStartPt;
    long _EndTagRow;
    long _EndTagEndPt;
    long _EndTagStartPt;
    bool _IsHtmlTag;
    bool _IsXHtmlTag;
    bool _IsXmlTag;
    bool _IsCppTag;
    bool _IsCTag;
    bool _IsNonStdTag;
    bool _IsSingletonTag;
    bool _IsEmptyTag;
    bool _SingletonTagAllowed;
    bool _EmptyTagAllowed;
    bool _SimplifySpaces;
    char* _TempRec;
    long _Tindex;
    long _Tlength;

    SimpleStack<long>* _ColStk;
    SimpleStack<SFStringFoundData>* _StrFoundStk;
    SimpleQueue<SFTagFoundData>* _TagFoundQue;

    char* _StartTag;
    char* _StartTagEnd;
    char* _EndTag;
    char* _EndTagEnd;
    char _TagEsc;

    // tag found indicators for various tag types
    static const char* _DocTypeOpen_Str;
    static const char* _DocTypeClose_Str;
    static const char* _CommentOpen_Str;
    static const char* _CommentClose_Str;
    static const char* _NestedComment1Open_Str;
    static const char* _NestedComment1Close_Str;
    static const char* _NestedComment2Open_Str;
    static const char* _NestedComment2Close_Str;
    static const char* _StdTagOpen_Str;
    static const char* _StdTagClose_Str;
    static const char* _EndTagOpen_Str;
    static const char* _EndTagClose_Str;
    static const char* _EmptyOpen_Str;
    static const char* _EmptyClose_Str;
    static const char* _ScriptOpen_Str;
    static const char* _ScriptClose_Str;
    static const char* _COpenCommentBlkOpen_Str;
    static const char* _COpenCommentBlkClose_Str;
    static const char* _CCloseCommentBlkOpen_Str;
    static const char* _CCloseCommentBlkClose_Str;
    static const char* _CppCommentLineOpen_Str;
    static const char* _CppCommentLineClose_Str;    

    // Tag list counters
    SFTagCountData* _TagCntData;

    // saved stack node data
    SFTagCountData* _SavedTagCntData;
    ChrString _SavedStartTag;
    ChrString _SavedEndTag;

    // Valid tag list
    bool _UseTagList;
    int _TagType;
    int _EndTagType;
    int _InputMethod;
    char** _TagList;
    int** _TagCount;
    int _TagListMax;
    int _TagListIndex;
    int _TagSeqType;

    // Tag count and in tag status flag
    bool _InTag;

    // contiguous counts of escape and non-escape characters.
    // contiguous even counts indicate cancelling out of escape sequences.
    long _TagEscCnt;
    long _NonEscCnt;

    // Stoping conditions and escape character detection flags and counts
    bool _BreakonStartTag;
    bool _BreakonEndTag;
    bool _HaveTag;
    bool _HaveTagEsc;

    int GetchTempStr();
    int PeekchTempStr();
    int PutBackTempStr();
    StringFilter* Push(const ChrString& StartStr_, const ChrString& EndStr_);
    StringFilter* Pop();

    int IsMonth(const char* Str_);
    int IsDateStr(const char* Str_);

    // Saved stack node data accessors
    inline ChrString& SavedStartTag()
        { return _SavedStartTag; }
    inline ChrString& SavedEndTag()
        { return _SavedEndTag; }
    inline SFTagCountData* SavedTagCntData()
        { return _SavedTagCntData; }

    // Find tag points and find tag strings        
    bool MatchTagBrk(const char* Str_, long Index_, int TagEnd_, int TagType_);
    bool FindStringTag(SFTagElement* ElementNode_, int SeqType_, bool IndexSpecified_,
                       long StartPoint_, long EndPoint_, int TagIndex_);
    bool FindStringTag2(SFTagStringData& Data_);

    bool FindTagPoints(long pos, int TagType_, int SeqType_, int SpecIndex_=-1);
    bool FindTagStrings(SFTagStringData& Data_, long SpecIndex_);

    void CopyTagListData(StringFilter* Ptr_, const ChrString& StartStr_, const ChrString& EndStr_);
    long* RestoreLenVector(SFTagStringData& Data_, bool Found_);
    long* AdjustLenVector(SFTagStringData& Data_, size_t xpt, size_t tlen);
    bool AdjustReadBufferLength(SFTagStringData& Data_);
    SFStringFoundData* PopStrFoundStack(SFTagStringData& Data_, bool Found_);
    bool RewindReadPos(SFTagStringData& Data_, long Diff_);
    bool RestoreReadPos(SFTagStringData& Data_);
    bool ReadForward(SFTagStringData& Data_);

    int TagTypeBitToIndex(int TagTypeBit_);
    void SetTagType(int TagIndex_);
    void SetStdTagTypeHelper(int TagType_, int Active_, int Lower_, int Upper_);
    void AppendMalJoinedTagStr(ChrString& Temps_, ChrString& sChrStr_, SFTagStringData& Data_,
                               bool OpeningTag_, long plen, long& slen, long& stsp);
    void AppendToInput(char* Buffer_, long Len_);
    void ResetFilter(bool ResetNesting_);
    void FindTagEscCount(char* BufStr_, long Start_,
                         long OffSet_, const char* TagStr_);
    bool IsTagFound(const char* Str_, const char* sPtr_,
                    const char* ePtr_, long Index_, int Found_);
    int IsStringFound(short LenVectIndex_, long& Index_, long Total_, long Added_, long* len,
                      const char* Ptr_, const char* sPtr_, const char* ePtr_,
                      bool Csense_, SFTagStringData* Data_=NULL);
    bool SetStringTagsHelper(const char* Start_, const char* StartEnder_,
                             const char* End_, const char* EndEnder_,
                             int TagTypeBit_, int EndTagTypeBit_, bool SetStringTags_);

    void SetupTagData();
    void ResetTagList();
    void InitTagList();
    void DestroyTagList();
    void CopyTagCount(const StringFilter& Stok_);
    void DecrTagNesting();

    char CountColsRows(char ch);
    char UnCountColsRows(char ch);
    void CountColsRows(const char* Buf_, const char* Delim_);
    void CountColsRows(const char* Buf_, long Len_, const char* Delim_);

  private:
    // static members for single instance object creation
    static StringFilter* m_This;
    static size_t m_ObjectCnt;
    static bool m_AutoRelease;
    static bool m_StaticCreate;
    static bool m_StaticDestroy;
    static void Init();

  public:
    // static members for single instance object creation  
    static StringFilter* Instance();
    static void Release();

  public:
    enum
    {
      DATE                  = 19,
      INT_FIELD             = 29,
      FLOAT_FIELD           = 39,
      TENS_DIGIT            = 49,
      FLDSIZE               = 256,
      BUFSIZE               = 256
    };

    StringFilter();
    StringFilter(const StringFilter& Stok_, StringFilter* Next_=NULL);
    StringFilter(const char* Fname_, int NestingLevel_=0, StringFilter* Next_=NULL);
    ~StringFilter();

    StringFilter& operator = (const StringFilter& Stok_);

    inline const char* GetBuffer() const
        { return _Buffer.c_str(); }
    inline const char* GetTempString() const
        { return _TempRec; }
    inline const char* StartTag() const
        { return _StartTag; }
    inline const char* StartTagEnd() const
        { return _StartTagEnd; }        
    inline const char* EndTag() const
        { return _EndTag; }
    inline const char* EndTagEnd() const
        { return _EndTagEnd; }
    inline char TagsEscChar() const
        { return _TagEsc; }

    inline bool IsSimplifiedSpaces() const
        { return _SimplifySpaces; }
    inline bool IsStdTagType() const
        { return ((_TagType != NO_TAGTYPE || _InputMethod != USE_TAGLIST) &&
                    (_IsHtmlTag || _IsXHtmlTag ||
                     _IsXmlTag || _IsCppTag || _IsCTag)); }
    inline long GetStartPt() const
        { return _StartPt; }
    inline long GetEndPt() const
        { return _EndPt; }
        
    inline long GetStartTagRow() const
        { return _StartTagRow; }
    inline long GetStartTagStartPt(bool StrictTags_=true) const
        { return (StrictTags_ ? (IsStdTagType() ?
                                    _StartTagStartPt:_StartPt):_StartTagStartPt); }
    inline long GetStartTagEndPt(bool StrictTags_=true) const
        { return (StrictTags_ ? (IsStdTagType() ?
                                    _StartTagEndPt:_EndPt):_StartTagEndPt); }

    inline long GetEndTagRow() const
        { return _EndTagRow; }
    inline long GetEndTagStartPt() const
        { return _EndTagStartPt; }
    inline long GetEndTagEndPt() const
        { return _EndTagEndPt; }

    FileReader* GetFileReader()
        { return _Frp; }
    inline bool InTag() const
        { return _InTag; }
    inline bool BreakonStartTag() const
        { return _BreakonStartTag; }
    inline bool BreakonEndTag() const
        { return _BreakonEndTag; }
    inline bool HaveTag() const
        { return _HaveTag; }
    inline bool HaveTagsEscChar() const
        { return _HaveTagEsc; }
    inline long Column() const
        { return _ColCnt; }
    inline long Row() const
        { return _RowCnt; }

    StringFilter* Next(int x);
    StringFilter& ClearNesting();
    StringFilter& SetInputFile(const char* Fname_, int NestingLevel_=0);
    StringFilter& SetParseHtmlTag(bool IsTag_);
    StringFilter& SetParseXHtmlTag(bool IsTag_);
    StringFilter& SetParseXmlTag(bool IsTag_);
    StringFilter& SetParseCppTag(bool IsTag_);
    StringFilter& SetParseCTag(bool IsTag_);
    StringFilter& SetParseNonStdTag(bool IsTag_);
    StringFilter& SetSingletonTag(bool IsSingle_, bool IsEmpty_);
    StringFilter& SetNestingLevel(int Level_);

    // new
    StringFilter& SetStringTags(const char* Start_, const char* StartEnder_,
                                const char* End_, const char* EndEnder_=NULL,
                                int TagTypeBit_=NO_TAGTYPE,
                                int EndTagTypeBit_=MATCH_TAGTYPE);
    SFTagElement* AddStringTag(int TagPos_, const char* Tag_, const char* TagEnder_,
                             SFTagElement* MatchingTag_, int TagTypeBit_=MATCH_TAGTYPE);

    // new
    StringFilter& DeleteTagList(int TagTypeBit_);
    StringFilter& ClearTagType(bool ClearParseFlags_);
    StringFilter& SetStdTagSet(int TagSet_=-1);
    StringFilter& SetStdTagType(int TagType_, int Active_);
    
    StringFilter& SetTagsEscChar(char Ch_);
    StringFilter& SetTempString(const char* Str_, Boolean Erase_, long len);
    StringFilter& ResetStreams();

    int GetTxtLine(const char* Delim_, FileReader* FileRp_=NULL,
                   char* StrBuf_=NULL, int StrBufSz_=0);
    int ReadUntilFound(const char* Delim_="\n", Boolean Rws_=1,
                       bool Csense_=false);
    int ReadUntilFound(const char* Mark_, const char* EndLine_,
                       const char* Delim_="\n", Boolean Rws_=1,
                       bool Csense_=false);

    int ExtractUntil(char* InputStr_, short InputLen_,
                     const char* CharSet_, Boolean InSet_,
                     Boolean PutBack_);
    int ExtractUntil(char* InputStr_, short InputLen_,
                     int(*iscsetfn)(int), Boolean InSet_,
                     Boolean PutBack_);

    int TestRead(Boolean Find_, const char* Mark_, int Spec_,
                 int Len_, Boolean SkipNl_, Boolean SkipWs_);
    int ReadUntilString(Boolean SkipNl_, Boolean SkipWs_, Boolean HasStart_,
                        int TestLen_=0, const char* Delim_="\n",
                        bool Csense_=false, bool Continued_=false);
    int ReadUntilString(const char* StartOrStop_, const char* End_,
                        Boolean SkipNl_, Boolean SkipWs_, Boolean HasStart_,
                        int TestLen_=0, const char* Delim_="\n",
                        bool Csense_=false, bool Continued_=false);

    const char* NextKeyValuePair(const char* Str_, int& Index_, ChrString& Key_, ChrString& Val_);

    // new
    StringFilter& SetOutputFile(const char* Fname_, int Include_);
    StringFilter& UseInputMethod(int InputType_);
    StringFilter& SimplifySpaces(bool Flag_);
    char** GiveTagBrkMatrix();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

}; // end: namespace Testing
/****************************************************************************/
#endif

