#ifndef STRTOKEN_CPP
#define STRTOKEN_CPP
#ifndef STRTOKEN_H
  #include "strtoken.h"
#endif

/****************************************************************************/
/*************************** Key Word Token Class ***************************/
/****************************************************************************/
StringToken::StringToken():
_SearchStr(NULL),
_Delims(NULL),
_StrQuote(NULL),
_WhiteSpace(NULL),
_Start(0),
_Index(0),
_Eos(FALSE),
_SkipEmptyFlds(FALSE),
_DelimsEsc(0),
_StrQuoteEsc(0)
{}

/****************************************************************************/
StringToken::StringToken(const StringToken& Stok_):
_SearchStr(new_char_string(Stok_.GetString())),
_Delims(new_char_string(Stok_.GetDelimiters())),
_StrQuote(new_char_string(Stok_.GetStringQuote())),
_WhiteSpace(new_char_string(Stok_.GetWhiteSpace())),
_Start(Stok_.GetStartIndex()),
_Index(Stok_.GetIndex()),
_Eos(FALSE),
_SkipEmptyFlds(Stok_.SkipEmptyFields()),
_DelimsEsc(Stok_.GetDelimitersEscChar()),
_StrQuoteEsc(Stok_.GetStringQuoteEscChar())
{}

/****************************************************************************/
StringToken::StringToken(const char* Str_, size_t Start_, const char* Delims_,
                         const char* Wspc_, const char* StrQuote_,
                         Boolean Skip_, char DelimsEsc_, char StrQuoteEsc_):
_SearchStr(new_char_string(Str_)),
_Delims(new_char_string(Delims_)),
_StrQuote(new_char_string(StrQuote_)),
_WhiteSpace(new_char_string(Wspc_)),
_Start(Start_),
_Index(Start_),
_Eos(FALSE),
_SkipEmptyFlds(Skip_),
_DelimsEsc(DelimsEsc_),
_StrQuoteEsc(StrQuoteEsc_)
{}

/****************************************************************************/
StringToken::~StringToken()
{
  ::DeleteArray(_SearchStr);
  ::DeleteArray(_Delims);
  ::DeleteArray(_StrQuote);
  ::DeleteArray(_WhiteSpace);

  _SearchStr =
  _Delims =
  _StrQuote =
  _WhiteSpace = NULL;  
}

/****************************************************************************/
StringToken& StringToken::operator = (const StringToken& Stok_)
{
  if (&Stok_ != this)
  {
    if (_SearchStr != Stok_.GetString())
    {
      ::DeleteArray(_SearchStr);
      _SearchStr = NULL;
    }

    if (_Delims != Stok_.GetDelimiters())
    {
      ::DeleteArray(_Delims);
      _Delims = NULL;
    }

    if (_StrQuote != Stok_.GetStringQuote())
    {
      ::DeleteArray(_StrQuote);
      _StrQuote = NULL;
    }

    if (_WhiteSpace != Stok_.GetWhiteSpace())
    {
      ::DeleteArray(_WhiteSpace);
      _WhiteSpace = NULL;
    }

    const char* Str_ = Stok_.GetString();
    _SearchStr = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_.GetDelimiters();
    _Delims = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_.GetStringQuote();
    _StrQuote = Str_ ? new_char_string(Str_):NULL;

    Str_ = Stok_.GetWhiteSpace();
    _WhiteSpace = Str_ ? new_char_string(Str_):NULL;
    
    _Start = Stok_.GetStartIndex();    
    _Index = Stok_.GetIndex();
    _Eos = Stok_.EndOfString();
    _SkipEmptyFlds = Stok_.SkipEmptyFields();
    _DelimsEsc = Stok_.GetDelimitersEscChar();
    _StrQuoteEsc = Stok_.GetStringQuoteEscChar();
  }

  return *this;
}

/****************************************************************************/
size_t StringToken::FindToken(char* Token_)
{
  const char* Delimiters_ = (_Delims == NULL) ? " ":_Delims;

  size_t NextPos_;
  size_t CopyLen_ = FindNextWord(_SearchStr, Delimiters_, _Index, NextPos_,
                                 _StrQuote, _SkipEmptyFlds, _DelimsEsc,
                                 _StrQuoteEsc);

  if (CopyLen_)
  {
    strncpy(Token_, &_SearchStr[_Index], CopyLen_);
    Token_[CopyLen_] = 0;

    if (_WhiteSpace)
    {
      RemovePadding(Token_, _WhiteSpace);
      CopyLen_ = strlen(Token_);
    }

    _Index = NextPos_;
  }
  else
  {
    _Eos = _SearchStr[_Index] == 0 || _Index >= strlen(_SearchStr);
    if (!_Eos)
      Token_[0] = 0;
  }

  return CopyLen_;
}

/****************************************************************************/
size_t StringToken::FindToken(char*& Token_, Boolean AllocMemory_)
{
  const char* Delimiters_ = (_Delims == NULL) ? " ":_Delims;

  size_t NextPos_;
  size_t CopyLen_ = FindNextWord(_SearchStr, Delimiters_, _Index, NextPos_,
                                 _StrQuote, _SkipEmptyFlds, _DelimsEsc,
                                 _StrQuoteEsc);

  if (CopyLen_)
  {
    if (AllocMemory_)
#     if OVERLOAD_NEW
        Token_ = (char*)RawAllocateWith(MEMMATRIX, CopyLen_ + 1);
#     else
        Token_ = (char*)RawAllocateWith(STD_NEW, CopyLen_ + 1);
#     endif

    strncpy(Token_, &_SearchStr[_Index], CopyLen_);
    Token_[CopyLen_] = 0;

    if (_WhiteSpace)
    {
      RemovePadding(Token_, _WhiteSpace);
      CopyLen_ = strlen(Token_);
    }

    _Index = NextPos_;
  }
  else
  {
    _Eos = _SearchStr[_Index] == 0 || _Index >= strlen(_SearchStr);
    if (!_Eos)
    {
#     if OVERLOAD_NEW    
        Token_ = (char*)RawAllocateWith(MEMMATRIX, 3);
#     else
        Token_ = (char*)RawAllocateWith(STD_NEW, 3);
#     endif
      Token_[0] = 0;
    }
  }

  return CopyLen_;
}

/****************************************************************************/
char* StringToken::SplitStr(char* Token_, const char* SrcStr_, size_t OrderPos_)
{
  size_t cplen_ = 0;
  SetString(SrcStr_);
  ResetIndex();
  
  for (++OrderPos_; OrderPos_ > 0; OrderPos_--)
    if (!(cplen_=FindToken(Token_)))
      break;
  
  return (cplen_ ? Token_:NULL);
}

/****************************************************************************/
char* StringToken::SplitStr(char* Token_, const char* SrcStr_,
                            const char* Delims_, const char* Wspc_,
                            size_t OrderPos_)
{
  size_t cplen_ = 0;
  SetString(SrcStr_);
  ResetIndex();
  
  SetDelimiters(Delims_);
  SetWhiteSpace(Wspc_);
  
  for (++OrderPos_; OrderPos_ > 0; OrderPos_--)
    if (!(cplen_=FindToken(Token_)))
      break;
    
  return (cplen_ ? Token_:NULL);
}

/****************************************************************************/
StringToken& StringToken::SetStartIndex(size_t Index_)
{
  _Start = Index_;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::ResetIndex()
{
  _Index = _Start;
  _Eos = FALSE;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetDelimiters(const char* Str_)
{
  if (_Delims != Str_)
  {
    ::DeleteArray(_Delims);
    _Delims = NULL;
  }
  
  _Delims = Str_ ? new_char_string(Str_):NULL;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetStringQuote(const char* Str_)
{
  if (_StrQuote != Str_)
  {
    ::DeleteArray(_StrQuote);
    _StrQuote = NULL;
  }
  
  _StrQuote = Str_ ? new_char_string(Str_):NULL;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetWhiteSpace(const char* Str_)
{
  if (_WhiteSpace != Str_)
  {
    ::DeleteArray(_WhiteSpace);
    _WhiteSpace = NULL;
  }
  
  _WhiteSpace = Str_ ? new_char_string(Str_):NULL;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetString(const char* Str_)
{
  if (_SearchStr != Str_)
  {
    ::DeleteArray(_SearchStr);
    _SearchStr = NULL;
  }
  
  _SearchStr = Str_ ? new_char_string(Str_):NULL;
  _Eos = FALSE;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetSkipEmptyFields(Boolean Skip_)
{
  _SkipEmptyFlds = Skip_;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::SetDelimitersEscChar(char Ch_)
{
  _DelimsEsc = Ch_;
  return *this;
}

/****************************************************************************/    
StringToken& StringToken::SetStringQuoteEscChar(char Ch_)
{
  _StrQuoteEsc = Ch_;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::ClearEscChars()
{
  _DelimsEsc = _StrQuoteEsc = 0;
  return *this;
}

/****************************************************************************/
StringToken& StringToken::ClearStringQuote()
{
  ::DeleteArray(_StrQuote);
  _StrQuote = NULL;
  return *this;
}

/****************************************************************************/
#if OVERLOAD_NEW
void* StringToken::operator new (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}

/****************************************************************************/
void StringToken::operator delete (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}

/****************************************************************************/
#if	HAS_ARRAY_NEW
void* StringToken::operator new[] (size_t Bytes_)
{
  return MemMatrix::Matrix().Allocate(Bytes_);
}
#endif

/****************************************************************************/
#if	HAS_ARRAY_NEW
void StringToken::operator delete[] (void* Space_)
{
  MemMatrix::Matrix().Deallocate(Space_);
}
#endif
#endif
/****************************************************************************/
/****************************************************************************/
#endif




