#ifndef STRTOKEN_H
#define STRTOKEN_H
#ifndef STRUTIL_H
  #include "strutil.h"
#endif

/****************************************************************************/
class StringToken
{
  private:
    char* _SearchStr;   // The character string to search on
    char* _Delims;      // Delimiters in the search string
    char* _StrQuote;    // Special character indicating string literal
    char* _WhiteSpace;  // whitespace in the search string
    char _DelimsEsc;
    char _StrQuoteEsc;

    size_t _Start;
    size_t _Index;
    Boolean _Eos;
    Boolean _SkipEmptyFlds;

  public:
    StringToken();
    StringToken(const StringToken& Stok_);
    StringToken(const char* Str_, size_t Start_, const char* Delims_,
                const char* Wspc_, const char* StrQuote_=NULL,
                Boolean Skip_=FALSE, char DelimsEsc_=0,
                char StrQuoteEsc_=0);
    ~StringToken();

    StringToken& operator = (const StringToken& Stok_);

    inline const char* GetString() const
        { return _SearchStr; }
    inline size_t GetStartIndex() const
        { return _Start; }
    inline size_t GetIndex() const
        { return _Index; }
    inline const char* GetDelimiters() const
        { return _Delims; }
    inline const char* GetStringQuote() const
        { return _StrQuote; }
    inline const char* GetWhiteSpace() const
        { return _WhiteSpace; }
    inline Boolean EndOfString() const
        { return _Eos; }
    inline Boolean SkipEmptyFields() const
        { return _SkipEmptyFlds; }        
    inline char GetDelimitersEscChar() const
        { return _DelimsEsc; }
    inline char GetStringQuoteEscChar() const
        { return _StrQuoteEsc; }

    StringToken& SetStartIndex(size_t Index_);
    StringToken& ResetIndex();
    StringToken& SetDelimiters(const char* Str_);
    StringToken& SetStringQuote(const char* Str_);
    StringToken& SetWhiteSpace(const char* Str_);
    StringToken& SetString(const char* Str_);
    StringToken& SetSkipEmptyFields(Boolean Skip_);
    StringToken& SetDelimitersEscChar(char Ch_);
    StringToken& SetStringQuoteEscChar(char Ch_);
    
    StringToken& ClearEscChars();
    StringToken& ClearStringQuote();

    size_t FindToken(char* Token_);
    size_t FindToken(char*& Token_, Boolean AllocMemory_);

    char* SplitStr(char* Token_, const char* SrcStr_, size_t OrderPos_);
    char* SplitStr(char* Token_, const char* SrcStr_,
                   const char* Delims_, const char* Wspc_, size_t OrderPos_);

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if     HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

/****************************************************************************/
#endif




