#ifndef SYMBOLS_CPP
#define SYMBOLS_CPP
#ifndef SYMBOLS_H
  #include "symbols.h"
#endif

SymbolParserData* SymbolSet::_ParserData = NULL;

/****************************************************************************/
// LevelData Class Definition
/****************************************************************************/
LevelData::LevelData():
_Level(0),
_SubLevel(0),
_Count(0),
_Size(0),
_Max(0),
_StackIndex(0),
_ScopeLevel(0),
_SizeArray(NULL),
_Refer(NULL),
_From(NULL),
_LevelPtr(NULL),
_Elements(NULL),
_Copied(false)
{}

/****************************************************************************/
LevelData::LevelData(const LevelData& Obj_):
_Level(Obj_._Level),
_SubLevel(Obj_._SubLevel),
_Count(Obj_._Count),
_Size(Obj_._Size),
_Max(Obj_._Max),
_StackIndex(Obj_._StackIndex),
_ScopeLevel(Obj_._ScopeLevel),
_SizeArray(Obj_._SizeArray),
_Refer(Obj_._Refer),
_From(Obj_._From),
_LevelPtr(Obj_._LevelPtr),
_Elements(NULL)
_Copied(true)
{
  if (_Level == STATEMENT_LEVEL || _Level == SEQUENCE_LEVEL)
    _Statement = Obj_._Statement;
  else
    _Elements = Obj_._Elements;
}

/****************************************************************************/
LevelData::~LevelData()
{
  if (_Next && !_Copied)
  {
    int x;
    for (x = 0; x < _Max; x++)
      delete _Next[x];

    ::DeleteArray(_Next);    
  }

  if (!_Copied)
    if (_Level > _SizeArray[0])
    {
      ::DeleteArray(_SizeArray);
      _SizeArray = NULL;
      ::Delete(_ArrayActive);
    }
    else
    {
      _SizeArray = NULL;
      *_ArrayActive = false;
    }
}

/****************************************************************************/
void LevelData::Clear()
{
  if (_Copied)
  {
    _From = NULL;
    _Refer = NULL;
    _Next = NULL;
    _Copied = false;
  }
  else if (_Next)
  {
    int x;
    for (x = 0; x < _Max; x++)
      delete _Next[x];

    ::DeleteArray(_Next);

    if (!_Copied)
      if (_Level > _SizeArray[0])
      {
        ::DeleteArray(_SizeArray);
        _SizeArray = NULL;
        ::Delete(_ArrayActive);
      }
      else
      {
        _SizeArray = NULL;
        *_ArrayActive = false;
      }
  }  
}

/****************************************************************************/
LevelData* LevelData::Clone() const
{
  LevelData* RetPtr_ = new LevelData(*this);
  return RetPtr_;
}

/****************************************************************************/
LevelData& LevelData::operator = (const LevelData& Obj_)
{
  if (&Obj_ != this)
  {
    _Count = Obj_._Count;
    _Level = Obj_._Level;
    _Size = Obj_._Size;
    _Max = Obj_._Max;
    _SizeArray = Obj_._SizeArray;
    _ArrayActive = Obj_._ArrayActive;    
    _From = Obj_._From;
    _Refer = Obj_._Refer;
    _Next = Obj_._Next;
    
    _Copied = true;
  }

  return *this;
}

/****************************************************************************/
void LevelData::ShowData(ostream& os) const
{
  int x, lvl;
  lvl = _Level;
  char* Tab_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (lvl+1));
  
  for (x = 0; x < lvl; x++)
    Tab_[x] = '\t';
  Tab_[x] = 0;
    
  os <<Tab_ <<"count : " <<_Count <<endl
     <<Tab_ <<"level : " <<_Level <<endl
     <<Tab_ <<"size  : " <<_Size <<endl
     <<Tab_ <<"max   : " <<_Max <<endl;

  if (lvl)
  {
    x = GiveIndexForLevel(lvl-1);
    int Max_ = _SizeArray[x+1];
  
    for (x = 0; x < Max_; x++)
      if (_Next[x]->_Count)
        _Next[x]->ShowData(os);
  }

  ::DeleteArray(Tab_);
}

/****************************************************************************/
int LevelData::GetLevelEnum() const
{
  return
  (
    (_Level == 3) ? ScopeInfo::ClassSCOPE:
    (_Level == 2) ? ScopeInfo::FunctionSCOPE:
    (_Level == 1) ? ScopeInfo::BlockSCOPE:
    (_Level == 0) ? ScopeInfo::StatementSCOPE:0
  );
}

/****************************************************************************/
LevelData& LevelData::SetLevelEnum(int LvlEnum_)
{
  int Saved_ = _Level;
  _Level = (LvlEnum_ == ScopeInfo::ClassSCOPE)     ? 3:
           (LvlEnum_ == ScopeInfo::FunctionSCOPE)  ? 2:
           (LvlEnum_ == ScopeInfo::BlockSCOPE)     ? 1:
           (LvlEnum_ == ScopeInfo::StatementSCOPE) ? 0:Saved_;
           
  return *this;
}

/****************************************************************************/
LevelData& LevelData::SetCount(int Cnt_)
{
  _Count = Cnt_;
  return *this;  
}

/****************************************************************************/
LevelData& LevelData::SetLevel(int Lvl_)
{
  _Level = Lvl_;
  return *this;  
}

/****************************************************************************/
LevelData& LevelData::SetSize(int Sz_)
{
  _Size = Sz_;
  return *this;  
}

/****************************************************************************/
LevelData& LevelData::SetMax(int Max_)
{
  _Max = Max_;
  return *this;  
}

/****************************************************************************/
LevelData& LevelData::SetFrom(LevelData* From_)
{
  if (!_Copied)
    _From = From_;
  return *this;
}

/****************************************************************************/
LevelData& LevelData::SetRefer(LevelData* Refer_)
{
  if (!_Copied)
    _Refer = Refer_;
  return *this;
}

/****************************************************************************/
LevelData** LevelData::GrowNextArray(bool MakeNode_)
{
  if (_Copied)
    return _Next;

  LevelData** Array_ = _Next;
  int OldSz_ = _Max;
  bool Done_ = true;
  int x;

  _Max *= 2;
  _Next = (LevelData**)RawAllocateWith(MEMMATRIX, sizeof(LevelData*) * _Max);
  
  for (x = 0; x < OldSz_; x++)
    _Next[x] = Array_[x];

  ::DeleteArray(Array_);

  if (MakeNode_)
  {
    while (x < _Max && Done_)
      CreateNext(x, Done_);  
  }
  else
  {
    for (;x < _Max; x++)
      _Next[x] = NULL;
  }
  
  return _Next;
}

/****************************************************************************/
LevelData** LevelData::AppendNextArray(int Sz_, int Lv_, bool MakeNode_)
{
  int x = 0;
  LevelData** OldArr_ = _Next;
  int OldMax_ = _Max;

  if (_Copied)
    return _Next;

  _Max = Sz_;
  _Level = Lv_;
  _Next = (LevelData**)RawAllocateWith(MEMMATRIX, sizeof(LevelData*) * _Max);
  bool Done_ = true;

  if (OldArr_ && OldMax_)
    for (x = 0; x < OldMax_; x++)
      _Next[x] = OldArr_[x];

  if (MakeNode_)
  {
    while (x < _Max && Done_)
      CreateNext(x, Done_);
  }
  else
  {
    for (x = 0; x < _Max; x++)
      _Next[x] = NULL;
  }

  if (OldArr_)
    ::DeleteArray(OldArr_);
  
  return _Next;
}

/****************************************************************************/
LevelData** LevelData::CreateNextArray(int Sz_, int Lv_, bool MakeNode_)
{
  int x;

  if (_Copied)
    return _Next;
  else if (_Next)
  {
    for (x = 0; x < _Max; x++)
      delete _Next[x];

    ::DeleteArray(_Next);  
  }

  x = 0;
  _Max = Sz_;
  _Level = Lv_;
  _Next = (LevelData**)RawAllocateWith(MEMMATRIX, sizeof(LevelData*) * _Max);
  bool Done_ = true;

  if (MakeNode_)
  {
    while (x < _Max && Done_)
      CreateNext(x, Done_);
  }
  else
  {
    for (x = 0; x < _Max; x++)
      _Next[x] = NULL;
  }
  
  return _Next;
}

/****************************************************************************/
LevelData* LevelData::CreateNext(int& Index_, bool& Done_)
{
  if (Index_ >= 0 && Index_ < _Max)
  {
    _Next[Index_] = new LevelData();
    _Next[Index_]->SetLevel(_Level-1);
    _Next[Index_]->SetSizeArray(0, _SizeArray, _ArrayActive);
    ++Index_;    
    Done_ = true;
    
    if (Index_ > _Size)
      _Size = Index_;

    return _Next[Index_-1];
  }
  
  Done_ = false;
  return NULL;
}

/****************************************************************************/
LevelData* LevelData::GetCoord(int* Coord_, int sz_, bool& Done_)
{
  int x, y;
  int Lsz_ = _Size;
  int Lvl_ = _Level;
  LevelData** Lptr_ = _Next;
  LevelData* Dptr_;
  
  for (x = 0; x < sz_; x++)
  {
    y = Coord_[x];
    
    if (y >= 0 && y < Lsz_)
    {
      Lptr_ += y;
      Dptr_ = *Lptr_;

      if (x == sz_-1)
      {
        Done_ = true;
        return Dptr_;
      }
      else if (Lvl_ > 0)
      {
        if (!Dptr_->_Count)
          Dptr_->_Count = y + 1;
      
        Lptr_ = Dptr_->_Next;
        Lvl_ = Dptr_->_Level;
        Lsz_ = Dptr_->_Size;
      }
    }
  }

  Done_ = false;
  return NULL;
}

/****************************************************************************/
LevelData* LevelData::GetNext(int Index_, bool& Done_)
{
  if (Index_ >= 0 && Index_ < _Size)
  {
    Done_ = true;
    return _Next[Index_];    
  }
  
  Done_ = false;
  return NULL;
}

/****************************************************************************/
// ScopeInfo Class Definition
/****************************************************************************/
// array[1] = int***, classes:
//            contains int** number of dereffed functions in elements.
// array[1][2] = int**, functions:
//               contains int* number of dereffed blocks in elements.
// array[1][2][3] = int*, blocks:
//                  contains int number of dereffed statements in elements.
//
// array[2] = int***
// array[3] = int***
// array[4] = int***
// ...
//
// array[0] = Class array size index.
// array[1] = 1st starting class length element.
//
// array[0][0] = Function array size index.
// array[n][0] = copy of array[0][0] with n being any non-zero index number.
// array[1][1] = parent reference index,
//               function referencing parent class element.
// array[1][2] = 1st starting function length element.
//
// array[0][0][0] = Block array size index.
// array[n][n][0] = copy of array[0][0][0] with n being any non-zero index number.
// array[1][2][1] = grandparent reference index,
//                  block referencing grandparent class element.
// array[1][2][2] = parent refernce index,
//                  block referencing parent function element.
// array[1][2][3] = 1st starting block length element.
//
ScopeInfo::ScopeInfo(int Levels_, int LeafSz_, int Classes_,
                     SymbolParserData* Pdata_):
_TopLevel(Levels_),
_Classes(Classes_),
_LeafSize(LeafSz_),
_Leveldata(new LevelData()),
_Parserdata(Pdata_)
{
  if (_TopLevel <= 0 || _TopLevel > 4)
    _TopLevel = 4;

  if (_Classes < 0)
    _Classes = 4;

  if (_LeafSize <= 0)
    _LeafSize = 2;
    
  _Leveldata->SetLevel(_TopLevel);
  InitSizeArray();
}

/****************************************************************************/
ScopeInfo::ScopeInfo(const ScopeInfo& Obj_):
_TopLevel(Obj_._TopLevel),
_Classes(Obj_._Classes),
_LeafSize(Obj_._LeafSize),
_Leveldata(Obj_._Leveldata ? Obj_._Leveldata->Clone():NULL),
_Parserdata(Obj_._Parserdata)
{
  if (_TopLevel <= 0 || _TopLevel > 4)
    _TopLevel = 4;

  if (_Classes < 0)
    _Classes = 4;

  if (_LeafSize <= 0)
    _LeafSize = 2;

  _Leveldata->SetLevel(_TopLevel);
  InitSizeArray();
}

/****************************************************************************/
ScopeInfo::~ScopeInfo()
{
  delete _Leveldata;
}

/****************************************************************************/
ScopeInfo& ScopeInfo::operator = (const ScopeInfo& Obj_)
{
  if (this != &Obj_)
  {
    _TopLevel = Obj_._TopLevel;
    _Classes = Obj_._Classes;
    _LeafSize = Obj_._LeafSize;
    _Leveldata = Obj_._Leveldata ? Obj_._Leveldata->Clone():NULL;
    _Parserdata = Obj_._Parserdata;
  
    _Leveldata->SetLevel(_TopLevel);
    InitSizeArray();
  }

  return *this;
}

/****************************************************************************/
ScopeInfo& ScopeInfo::InitSizeArray()
{
  if (_Classes > 0 && _TopLevel == 4)
  {
    int cls, fnc, blk;    
    _SizeArray = (int***)RawAllocateWith(MEMMATRIX, sizeof(int**) * (_Classes+1));
    cls = fnc = blk = 0;    
    
    _SizeArray[cls] = (int**)RawAllocateWith(MEMMATRIX, sizeof(int*));
    _SizeArray[cls][0] = (int*)RawAllocateWith(MEMMATRIX, sizeof(int));
    _SizeArray[cls][0][0] = _Classes;

    for (cls = ClassINDEX + 1; cls <= _Classes; cls++)
    {
      _SizeArray[cls] = (int**)RawAllocateWith(MEMMATRIX, sizeof(int*) * (_LeafSize+1));

      for (fnc = 0; fnc < FunctionINDEX; fnc++)
      {
        _SizeArray[cls][fnc] = (int*)RawAllocateWith(MEMMATRIX, sizeof(int) * (_LeafSize+1));
        _SizeArray[cls][fnc][0] = _LeafSize;

        for (fnc = 0; fnc < BlockINDEX; fnc++)
          _SizeArray[cls][fnc][blk] = _LeafSize;
      }
    }
  }
}

/****************************************************************************/
void ScopeInfo::ShowSizeArray(ostream& os) const
{
  int Max_ = _SizeArray[0];

  os <<"sizearray : ";
  int x;

  for (x = 1; x < Max_; x++)
    os <<_SizeArray[x] <<"-";
  os <<_SizeArray[x] <<endl;
}

/****************************************************************************/
LevelData& ScopeInfo::SetSizeIndex(int Index_, int Sz_)
{
  int Max_ = _SizeArray[0];

  if (0 <= Index_ && Index_ < Max_ &&
      _SizeArray[Index_+1] < Sz_)
    _SizeArray[Index_+1] = Sz_;

  return *this;
}

/****************************************************************************/
LevelData& ScopeInfo::SetSizeArray(int Sz_, int* Ptr_)
{
  if (!_Copied)
    if ((!Ptr_ && !_SizeArray) ||
        (Sz_ > _SizeArray[0] && _Level >= _SizeArray[0] && Sz_ < _Level))
    {
      bool SetNext_ = false;
    
      if (_SizeArray)
        ::DeleteArray(_SizeArray);

      _SizeArray = (int*)RawAllocateWith(MEMMATRIX, sizeof(int) * (Sz_+1));
      _SizeArray[0] = Sz_;

    }
    
  return *this;  
}

/****************************************************************************/
LevelData& ScopeInfo::InitSizeArray(int Sz_)
{
  int x;
  int Max_ = _SizeArray[0];

  if (!_Copied)
    for (x = 1; x <= Max_; x++)
      _SizeArray[x] = Sz_;

  return *this;
}

/****************************************************************************/
int ScopeInfo::GiveLevelForIndex(int Index_) const
{
  int Max_ = _SizeArray[0];

  if (0 <= Index_ && Index_ < Max_)
    return (Max_ - (Index_+1));

  return 0;
}

/****************************************************************************/
int ScopeInfo::GiveIndexForLevel(int Level_) const
{
  int Max_ = _SizeArray[0];
  int x;

  for (x = 1; x <= Max_; x++)
    if (Max_ - x == Level_)
      return (x-1);

  return 0;
}

/****************************************************************************/
int ScopeInfo::GiveSizeForIndex(int Index_) const
{
  int Max_ = _SizeArray[0];

  if (0 <= Index_ && Index_ < Max_)
    return _SizeArray[Index_+1];

  return 0;
}

/****************************************************************************/
// SymbolParserData Class Definition
/****************************************************************************/
SymbolParserData::SymbolParserData():
_PgrmIndex(0),
_Scope(0),
_ScopeLevel(NULL),
_BrackBal(0),
_DelimCnt(NULL),
_ArgCnt(NULL),
_CdefExists(false),
_CdefLimit(0),
_BlkStkLevel(0),
_FncStkLevel(0),
_OrBranchOut(false),
_BranchFound(false),
_OrBranchNum(0),
_BranchBlocked(false),
_LeafSize(2),
_RefCount(0)
{
  _ScopeLevel = new LevelData();
  _ScopeLevel->SetLevel(4);
  _ScopeLevel->SetSizeArray(4);
  _ScopeLevel->InitSizeArray(_LeafSize);
  
  _ScopeLevel = CreateLevelTree(_ScopeLevel, 4, _LeafSize);
  _ScopeLevel->SetCount(1);

  _DelimCnt = new LevelData();
  _DelimCnt->SetLevel(2);
  _DelimCnt->SetSizeArray(2);
  _DelimCnt->InitSizeArray(_LeafSize);
  
  _DelimCnt = CreateLevelTree(_DelimCnt, 2, _LeafSize);
  _DelimCnt->SetCount(1);

  _ArgCnt = new LevelData();
  _ArgCnt->SetLevel(2);
  _ArgCnt->SetSizeArray(2);
  _ArgCnt->InitSizeArray(_LeafSize);
  
  _ArgCnt = CreateLevelTree(_ArgCnt, 2, _LeafSize);
  _ArgCnt->SetCount(1);
}

/****************************************************************************/
SymbolParserData::SymbolParserData(const SymbolParserData& Obj_):
_PgrmIndex(Obj_._PgrmIndex),
_Scope(Obj_._Scope),
_ScopeLevel(NULL),
_BrackBal(Obj_._BrackBal),
_DelimCnt(NULL),
_ArgCnt(NULL),
_CdefExists(Obj_._CdefExists),
_CdefLimit(Obj_._CdefLimit),
_BlkStkLevel(Obj_._BlkStkLevel),
_FncStkLevel(Obj_._FncStkLevel),
_OrBranchOut(Obj_._OrBranchOut),
_BranchFound(Obj_._BranchFound),
_OrBranchNum(Obj_._OrBranchNum),
_BranchBlocked(Obj_._BranchBlocked),
_LeafSize(Obj_._LeafSize),
_RefCount(0)
{
  _ScopeLevel = new LevelData();
  if (Obj_._ScopeLevel)
    *_ScopeLevel = *Obj_._ScopeLevel;

  _DelimCnt = new LevelData();
  if (Obj_._DelimCnt)
    *_DelimCnt = *Obj_._DelimCnt;

  _ArgCnt = new LevelData();
  if (Obj_._ArgCnt)
    *_ArgCnt = *Obj_._ArgCnt;
}

/****************************************************************************/
SymbolParserData::~SymbolParserData()
{
  delete _ScopeLevel;
  delete _DelimCnt;
  delete _ArgCnt;

  _ScopeLevel =
  _DelimCnt =
  _ArgCnt = NULL;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::operator = (const SymbolParserData& Obj_)
{
  if (&Obj_ != this)
  {
    _PgrmIndex = Obj_._PgrmIndex;
    _Scope = Obj_._Scope;
    _ScopeLevel = NULL;
    _BrackBal = Obj_._BrackBal;
    _DelimCnt = NULL;
    _ArgCnt = NULL;
    _CdefExists = Obj_._CdefExists;
    _CdefLimit = Obj_._CdefLimit;
    _BlkStkLevel = Obj_._BlkStkLevel;
    _FncStkLevel = Obj_._FncStkLevel;
    _OrBranchOut = Obj_._OrBranchOut;
    _BranchFound = Obj_._BranchFound;
    _OrBranchNum = Obj_._OrBranchNum;
    _BranchBlocked = Obj_._BranchBlocked;
    _LeafSize = Obj_._LeafSize;
    _RefCount = 0;

    _ScopeLevel = new LevelData();
    if (Obj_._ScopeLevel)
      *_ScopeLevel = *Obj_._ScopeLevel;

    _DelimCnt = new LevelData();
    if (Obj_._DelimCnt)
      *_DelimCnt = *Obj_._DelimCnt;

    _ArgCnt = new LevelData();
    if (Obj_._ArgCnt)
      *_ArgCnt = *Obj_._ArgCnt;
  }

  return *this;
}

/****************************************************************************/
LevelData* SymbolParserData::AppendLevelTreeRecFnc(LevelData* Ldp_, int LvIndex_, int SzIndex_,
                                                   int LeafSz_, int Remain_, int Index_, int LvDecr_)
{
  if ((LvIndex_-1 == Ldp_->GiveLevelForIndex(Index_) && LvIndex_ > 0) &&
      (LeafSz_ && SzIndex_ < LeafSz_ && Remain_ == 0))
  {
    Ldp_->AppendNextArray(LeafSz_, LvIndex_, true);
    AppendLevelTreeRecFnc(Ldp_, LvIndex_, SzIndex_, LeafSz_, LeafSz_ - SzIndex_, Index_, LvDecr_+1);
    return Ldp_;
  }
  else if (LvIndex_ > 0 && (SzIndex_ < LeafSz_ && SzIndex_ >= 0 && Remain_ > 0))
  {
    LevelData* Root_ = Ldp_;
    bool Done_;
      
    Ldp_ = Ldp_->GetNext(SzIndex_, Done_);
      
    if (Ldp_ && Done_ && Ldp_->_Level > 0)
      Ldp_->AppendNextArray(Ldp_->GiveSizeForIndex(Index_+LvDecr_), Ldp_->_Level, true);

    if (Remain_)
      AppendLevelTreeRecFnc(Root_, LvIndex_, SzIndex_+1, LeafSz_, Remain_-1, Index_, LvDecr_);

    if (LvIndex_)
      AppendLevelTreeRecFnc(Ldp_, LvIndex_-1, 0,
                            Ldp_->GiveSizeForIndex(Index_+LvDecr_),
                            Ldp_->GiveSizeForIndex(Index_+LvDecr_), Index_, LvDecr_+1);
  }

  return Ldp_;
}

/****************************************************************************/
LevelData* SymbolParserData::CreateLevelTreeRecFnc(LevelData* Ldp_, int LvIndex_, int SzIndex_, int Deepest_, int LeafSz_)
{
  if (Deepest_ && LvIndex_ == Deepest_)
  {
    CreateLevelTreeRecFnc(Ldp_, Deepest_-1, LeafSz_, Deepest_, LeafSz_);
    return Ldp_;
  }
  else if (LvIndex_ < Deepest_ && LvIndex_ >= 0)
  {
    if (LeafSz_ && SzIndex_ == LeafSz_)
    {
      Ldp_->CreateNextArray(LeafSz_, LvIndex_+1, true);
      
      if (LvIndex_)
        CreateLevelTreeRecFnc(Ldp_, LvIndex_-1, LeafSz_-1, Deepest_, LeafSz_);
    }
    else if (SzIndex_ < LeafSz_ && SzIndex_ >= 0)
    {    
      LevelData* Root_ = Ldp_;
      bool Done_;
      
      Ldp_ = Ldp_->GetNext(SzIndex_, Done_);
      
      if (Ldp_ && Done_ && LvIndex_ >= 0)
        Ldp_->CreateNextArray(LeafSz_, LvIndex_+1, true);

      if (SzIndex_)
        CreateLevelTreeRecFnc(Root_, LvIndex_, SzIndex_-1, Deepest_, LeafSz_);

      if (LvIndex_)
        CreateLevelTreeRecFnc(Ldp_, LvIndex_-1, LeafSz_-1, Deepest_, LeafSz_);
    }  
  }

  return Ldp_;
}

/****************************************************************************/
LevelData* SymbolParserData::CreateLevelTree(LevelData* Ldp_, int Deepest_, int LeafSz_)
{
  Ldp_ = CreateLevelTreeRecFnc(Ldp_, Deepest_, LeafSz_, Deepest_, LeafSz_);
  return Ldp_;
}

/****************************************************************************/
LevelData* SymbolParserData::AppendLevelTree(LevelData* Ldp_, LevelData* Prv_,
                                             int Deepest_, int LeafSz_, int Index_)
{
  if (Deepest_ <= 0)
    return NULL;

  bool Done_;
  LevelData* Next_ = Ldp_->GetNext(0, Done_);

  if (!Next_)
    return NULL;

  if (Ldp_->GiveLevelForIndex(Index_) == Next_->_Level)
  {
    int x = 0;
    int max = Prv_ ? Prv_->_Size:1;

    while (x < max)
    {
      AppendLevelTreeRecFnc(Ldp_, Ldp_->_Level, Ldp_->_Size,
                            LeafSz_, 0, Index_, 0);

      ++x;
      if (x < max)
        Ldp_ = Prv_->GetNext(x, Done_);

      /*
      int CurLvl_ = Ldp_->_Level;
      int x = FindCurrentIndex(CurLvl_);
    
      Ldp_ = Prv_->GetNext(x, Done_);
      AppendLevelTreeRecFnc(Ldp_, Ldp_->_Level, Ldp_->_Size,
                            LeafSz_, 0, Index_, 0);
      */
    }
  }
  else
    AppendLevelTree(Next_, Ldp_, Deepest_-1, LeafSz_, Index_);

  return Ldp_;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetScopeLevel(int Pgrm_, int Fnc_,
                                                  int Blk_, int Seq_, int Sz_, int Cnt_)
{
  if (_ScopeLevel)
  {
    int Coord_[4];
    int x;

    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Pgrm_:
                  (x == 1) ? Fnc_:
                  (x == 2) ? Blk_:
                  (x == 3) ? Seq_:0;

      if (Coord_[x] >= _ScopeLevel->GiveSizeForIndex(x))
      {
        _ScopeLevel->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_ScopeLevel, NULL, 4, _ScopeLevel->GiveSizeForIndex(x), x);
      }
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _ScopeLevel->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
    {
      Dptr_->_Count = Cnt_;

      #if SYMBOLSET_DEBUG3
        _ScopeLevel->ShowSizeArray(cout);
      #endif
    }
  }

  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetDelimiterCnt(int Blk_, int Seq_, int Sz_, int Cnt_)
{
  if (_DelimCnt)
  {
    int Coord_[2];
    int x;
    
    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Blk_:
                  (x == 1) ? Seq_:0;

      if (Coord_[x] >= _DelimCnt->GiveSizeForIndex(x))
      {
        _DelimCnt->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_DelimCnt, NULL, 2, _DelimCnt->GiveSizeForIndex(x), x);
      }                  
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _DelimCnt->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
    {
      Dptr_->_Count = Cnt_;

      #if SYMBOLSET_DEBUG3
        _DelimCnt->ShowSizeArray(cout);
      #endif      
    }
  }

  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetArgumentCnt(int Blk_, int Seq_, int Sz_, int Cnt_)
{
  if (_ArgCnt)
  {
    int Coord_[2];
    int x;
    
    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Blk_:
                  (x == 1) ? Seq_:0;

      if (Coord_[x] >= _ArgCnt->GiveSizeForIndex(x))
      {
        _ArgCnt->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_ArgCnt, NULL, 2, _ArgCnt->GiveSizeForIndex(x), x);
      }
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _ArgCnt->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
    {
      Dptr_->_Count = Cnt_;

      #if SYMBOLSET_DEBUG3
        _ArgCnt->ShowSizeArray(cout);
      #endif      
    }
  }

  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::ClearDelimiterCnt(int Blk_, int Seq_)
{
  if (_DelimCnt)
  {
    bool Done_;
    LevelData* Dptr_;
    int Coord_[2];
    int x;
    int Lim_ = _DelimCnt->GiveSizeForIndex(1);
        
    for (x = 0; x <= Seq_; x++)
    {
      Coord_[0] = Blk_;
      Coord_[1] = x;
      Done_ = false;

      if (Coord_[1] < Lim_)
      {
        Dptr_ = _DelimCnt->GetCoord(Coord_, 2, Done_);

        if (Done_)
          Dptr_->_Count = 0;
      }
    }      
  }

  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::ClearArgumentCnt(int Blk_, int Seq_)
{
  if (_ArgCnt)
  {
    bool Done_;
    LevelData* Dptr_;
    int Coord_[2];
    int x;
    int Lim_ = _ArgCnt->GiveSizeForIndex(1);
        
    for (x = 0; x <= Seq_; x++)
    {
      Coord_[0] = Blk_;
      Coord_[1] = x;
      Done_ = false;

      if (Coord_[1] < Lim_)
      {
        Dptr_ = _ArgCnt->GetCoord(Coord_, 2, Done_);

        if (Done_)
          Dptr_->_Count = 0;
      }
    }      
  }

  return *this;
}

/****************************************************************************/
LevelData* SymbolParserData::ScopeLevel(int Pgrm_, int Fnc_,
                                        int Blk_, int Seq_, int Sz_)
{
  if (_ScopeLevel)
  {
    int Coord_[4];
    int x;
    
    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Pgrm_:
                  (x == 1) ? Fnc_:
                  (x == 2) ? Blk_:
                  (x == 3) ? Seq_:0;

      if (Coord_[x] >= _ScopeLevel->GiveSizeForIndex(x))
      {
        _ScopeLevel->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_ScopeLevel, NULL, 4, _ScopeLevel->GiveSizeForIndex(x), x);
      }                  
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _ScopeLevel->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
      return Dptr_;
  }

  return NULL;
}

/****************************************************************************/
LevelData* SymbolParserData::DelimiterCnt(int Blk_, int Seq_, int Sz_)
{
  if (_DelimCnt)
  {
    int Coord_[2];
    int x;
    
    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Blk_:
                  (x == 1) ? Seq_:0;

      if (Coord_[x] >= _DelimCnt->GiveSizeForIndex(x))
      {
        _DelimCnt->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_DelimCnt, NULL, 2, _DelimCnt->GiveSizeForIndex(x), x);
      }
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _DelimCnt->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
      return Dptr_;
  }

  return NULL;
}

/****************************************************************************/
LevelData* SymbolParserData::ArgumentCnt(int Blk_, int Seq_, int Sz_)
{
  if (_ArgCnt)
  {
    int Coord_[2];
    int x;
    
    for (x = 0; x < Sz_; x++)
    {
      Coord_[x] = (x == 0) ? Blk_:
                  (x == 1) ? Seq_:0;

      if (Coord_[x] >= _ArgCnt->GiveSizeForIndex(x))
      {
        _ArgCnt->SetSizeIndex(x, Coord_[x]+1);
        AppendLevelTree(_ArgCnt, NULL, 2, _ArgCnt->GiveSizeForIndex(x), x);
      }                                    
    }
  
    bool Done_ = false;
    LevelData* Dptr_ = _ArgCnt->GetCoord(Coord_, Sz_, Done_);
    if (Done_)
      return Dptr_;
  }

  return NULL;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetPgrmIndex(int Index_)
{
  _PgrmIndex = Index_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::IncPgrmIndex()
{
  _PgrmIndex++;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetScope(int Scope_)
{
  _Scope = Scope_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetBrackBal(int Bal_)
{
  _BrackBal = Bal_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::IncBrackBal()
{
  _BrackBal++;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::DecBrackBal()
{
  _BrackBal--;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetCdefExists(bool Val_)
{
  _CdefExists = Val_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetCdefLimit(int Val_)
{
  _CdefLimit = Val_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetBlkStkLevel(int Lvl_)
{
  _BlkStkLevel = Lvl_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::IncBlkStkLevel()
{
  _BlkStkLevel++;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::DecBlkStkLevel()
{
  _BlkStkLevel--;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetFncStkLevel(int Lvl_)
{
  _FncStkLevel = Lvl_;
  return *this;  
}

/****************************************************************************/
SymbolParserData& SymbolParserData::IncFncStkLevel()
{
  _FncStkLevel++;
  return *this;  
}

/****************************************************************************/
SymbolParserData& SymbolParserData::DecFncStkLevel()
{
  _FncStkLevel--;
  return *this;  
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetOrBranchOut(bool Val_)
{
  _OrBranchOut = Val_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetBranchFound(bool Val_)
{
  _BranchFound = Val_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetOrBranchNum(int Num_)
{
  _OrBranchNum = Num_;
  return *this;
}

/****************************************************************************/
SymbolParserData& SymbolParserData::SetBranchBlocked(bool Blk_)
{
  _BranchBlocked = Blk_;
  return *this;
}

/****************************************************************************/
void SymbolParserData::ShowData(ostream& os) const
{
  os <<"PgrmIndex     : " <<_PgrmIndex <<endl
     <<"Scope         : " <<_Scope <<endl
     <<"BrackBal      : " <<_BrackBal <<endl
     <<"CdefExists    : " <<_CdefExists <<endl;

  os <<"CdefLimit     : " <<_CdefLimit <<endl
     <<"BlkStkLevel   : " <<_BlkStkLevel <<endl
     <<"FncStkLevel   : " <<_FncStkLevel <<endl;

  os <<"OrBranchOut   : " <<_OrBranchOut <<endl
     <<"BranchFound   : " <<_BranchFound <<endl
     <<"OrBranchNum   : " <<_OrBranchNum <<endl
     <<"BranchBlocked : " <<_BranchBlocked <<endl;

  os <<"LeafSize      : " <<_LeafSize <<endl
     <<"RefCount      : " <<_RefCount <<endl;

  #if SYMBOLSET_DEBUG2
    os <<"Scope Level Data: " <<endl;
    _ScopeLevel->ShowData(os);
  #endif

  os <<"Delimiter Count Data: " <<endl;
  _DelimCnt->ShowData(os);

  os <<"Argument Count Data: " <<endl;
  _ArgCnt->ShowData(os);
}

/****************************************************************************/
// SymbolTokenArray Class Definition
/****************************************************************************/
SymbolTagArray::SymbolTagArray(const char* Fname_):
_FileName(new_char_string(Fname_)),
_Filter(new StringFilter(Fname_)),
_TagArray(NULL),
_TagArrayLimit(0),
_TagArraySize(0),
_TokenArray(NULL),
_TokenArraySize(0)
{}

/****************************************************************************/
SymbolTagArray::~SymbolTagArray()
{
  ::DeleteArray(_FileName);
  delete _Filter;
  
  ClearTagArray();
  
  ::DeleteArray(_TagArray[0]);
  ::DeleteArray(_TagArray);
  _TagArray = NULL;
  _TagArraySize = _TagArrayLimit = 0;
}

/****************************************************************************/
char** SymbolTagArray::GrowTagArray(int Incr_)
{
  int x, oldsz;
  int Size_ = _TagArrayLimit;
  char** OldArr_ = _TagArray;

  ++Size_;
  oldsz = Size_;
  Size_ += Incr_;
  _TagArray = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * Size_);

  for (x = 0; x < oldsz; x++)
    _TagArray[x] = OldArr_[x];

  for (;x < Size_; x++)
    _TagArray[x] = NULL;

  _TagArrayLimit = Size_ - 1;
  _TagArray[0] = LongToStr(_TagArrayLimit, _TagArray[0]);
  ::DeleteArray(OldArr_);
  
  return _TagArray;
}

/****************************************************************************/
char** SymbolTagArray::InitTagArray()
{
  int x, max;

  max = TAGARRAYSIZE_INCR + 1;
  _TagArray = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * max);
  _TagArray[0] = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 64);
  
  _TagArrayLimit = max - 1;
  _TagArraySize = 1;
  _TagArray[0] = LongToStr(_TagArrayLimit, _TagArray[0]);

  for (x = 1; x < max; x++)
    _TagArray[x] = NULL;

  return _TagArray;
}

/****************************************************************************/
char** SymbolTagArray::ClearTagArray()
{
  int x, max;  
  max = _TagArraySize;
  
  for (x = 1; x < max; x++)
  {
    ::DeleteArray(_TagArray[x]);
    _TagArray[x] = NULL;
  }

  _TagArraySize = 1;
  return _TagArray;
}

/****************************************************************************/
void SymbolTagArray::ShowTagArray(int& st)
{
  for (;st < _TagArraySize; st++)
    cout <<_TagArray[st] <<endl;

  cout <<endl;
}

/****************************************************************************/
char** SymbolTagArray::ReadSymbolFileHelper(int& sz)
{
  int len, max;
  char* RetStr_ = NULL;
  const char* RdStr_;
  ChrString RealStr_;
  char StartTag_[3];
  bool EndRead_ = false;

  max = _TagArrayLimit + 1;
  strcpy(StartTag_, "-<");

  while (!EndRead_)
  {
    if (_Filter->ReadUntilString(StartTag_, ">", 1, 1, 1, 0, 0))
    {
      RdStr_ = _Filter->GetBuffer();
      RealStr_ += RdStr_;
      len = strlen(RdStr_);      

      if (strcmp(RdStr_+len-2, ";>") == 0)
      {
        RetStr_ = new_char_string(RealStr_.c_str());
        _TagArray[sz++] = RetStr_;
        EndRead_ = true;
      }
      else
      {
        RetStr_ = new_char_string(RealStr_.c_str());
        _TagArray[sz++] = RetStr_;
        RealStr_ = "";
        strcpy(StartTag_, "<");
      }

      if (sz == max)
      {
        _TagArray = GrowTagArray(TAGARRAYSIZE_INCR);
        max = _TagArrayLimit + 1;        
      }
    }

    if (_Filter->GetFileReader()->EndOfFile())
      EndRead_ = true;
  }

  return _TagArray;
}

/****************************************************************************/
char** SymbolTagArray::ReadSymbolFile()
{
  int sz = 1;
  _Filter->SetTagsEscChar('\\');
  _Filter->ResetStreams();
  
  if (_TagArraySize > 1)
    ClearTagArray();
  else if (_TagArraySize == 0)
    InitTagArray();

  while (!_Filter->GetFileReader()->EndOfFile())
    _TagArray = ReadSymbolFileHelper(sz);

  _TagArraySize = sz;
  return _TagArray;
}

/****************************************************************************/
char** SymbolTagArray::RemoveEndBrackets()
{
  int len = _TokenArraySize;
  int x = ::SafeStrLen(_TokenArray[len-1]) - 1;
  
  if (_TokenArray[len-1][x] == '>')
  {
    _TokenArray[len-1][x--] = 0;
    if (_TokenArray[len-1][x] == ';')
      _TokenArray[len-1][x--] = 0;    
  }

  x = (_TokenArray[0][0] == '-' && _TokenArray[0][1] == '<') ? 2:
      (_TokenArray[0][0] == '<') ? 1:0;
  
  if (x)
    memmove(_TokenArray[0], _TokenArray[0]+x, strlen(_TokenArray[0]+x)+1);

  return _TokenArray;
}

/****************************************************************************/
//
// (internal data)
//   (program specific data)
//     programindex 0:
//     currentscope 0:
//     scope level 1-0-1-3: /* pgrm-fnc-blk-seq */
//     brackbal 0:
//     delimcnt 0-0:        /* blk-seq */
//     argumentcnt 0-0:     /* blk-seq */
//     CdefExists 0:
//     CdefLimit 0:
//     branchblocked 0:
//     blkstklevel 0:
//     fncstklevel 0:
//     OrBranchOut 0:
//     BranchFound 0:
//     orbranchnum 0:
//
//   (symbol specific data)
//     name ccc:
//     symtype enum:
//     symattr enum:
//     datatype enum:
//     seqtype enum:
//     structtype enum:
//     decltype enum:
//     defntype enum:
//     CdefExists 0:
//     CdefLimit 0:
//     CdeChkBlock:
//     optype enum:
//     opstate 0:
//     sestate 0:
//     brksymtype 0:
//     brksymstate 0:
//
// char** TagArr_ : tag array containing strings indicating symbol tags.
// int& Index_ : Index indicating the position within the tag array that has
//               been parsed. Starts from 1 since TagArr_[0] indicates size
//               of char* matrix.
//
SymbolSet* SymbolTagArray::MakeFromTagText(int& Index_)
{
  int sz = _TagArraySize;
  if (Index_ >= sz)
    return NULL;

  if (Index_ <= 0)
    Index_ = 1;

  int x, len;
  int Max_ = TOKENARRAY_LIMIT;
  int tindex = 0;
  char* Ptr_ = strchr(_TagArray[Index_], '<');
  char tok[TOKENSTRING_LIMIT];
  StringToken Tokner_;
  SymbolSet* RetSym_ = NULL;
  SymbolSet* BasePtr_ = NULL;
  bool Done_ = false;
  int BrkLvl_ = 0;
  int CallIter_ = 0;

  if (!Ptr_)
    return NULL;
  
  _TokenArray = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * Max_);
  Tokner_.SetDelimiters(":");
  Tokner_.SetWhiteSpace(" \t\n\r");
  Tokner_.SetString(Ptr_);
  Tokner_.SetDelimitersEscChar('\\');
  Tokner_.ResetIndex();

  for (x = 0; Tokner_.FindToken(tok);)
    _TokenArray[x++] = new_char_string(tok);
  
  _TokenArraySize = len = x;
  RemoveEndBrackets();

  if (StriComp(_TokenArray[1], "Symbol_Type") == 0)
    RetSym_ = MakeSymbolSetType(_TokenArray, len);
  else if (StriComp(_TokenArray[1], "OperatorSet_Type") == 0)
    RetSym_ = MakeOperatorSetType(_TokenArray, len);
  else if (StriComp(_TokenArray[1], "Sequence_Type") == 0)
    RetSym_ = MakeSequenceType(_TokenArray, len);
  else if (StriComp(_TokenArray[1], "BranchOut_Type") == 0)
    RetSym_ = MakeBranchOutType(_TokenArray, len);
  else if (StriComp(_TokenArray[1], "BracketedSymbol_Type") == 0)
  {
    Done_ = false;
    CallIter_ = 0;
    
    for (tindex = Index_ + 1; !Done_; tindex++)
    {
      RetSym_ = MakeBracketedSymbolType(_TokenArray, len, BrkLvl_,
                                        CallIter_, RetSym_, Done_);

      if (CallIter_ == 1)
        BasePtr_ = RetSym_;
      
      if (Done_)
      {
        RetSym_ = BasePtr_;
        break;
      }
      else
      {      
        Ptr_ = strchr(_TagArray[tindex], '<');
        Tokner_.SetString(Ptr_);
        Tokner_.SetDelimitersEscChar('\\');        
        Tokner_.ResetIndex();

        for (x = 0; x < len; x++)
        {
          ::DeleteArray(_TokenArray[x]);
          _TokenArray[x] = NULL;
        }

        for (x = 0; Tokner_.FindToken(tok);)
          _TokenArray[x++] = new_char_string(tok);
          
        _TokenArraySize = len = x;
        RemoveEndBrackets();
      }
    }
  }

  for (x = 0; x < len; x++)
    ::DeleteArray(_TokenArray[x]);
  ::DeleteArray(_TokenArray);
  _TokenArray = NULL;
  _TokenArraySize = 0;
  
  if (tindex)
    Index_ = tindex;
  else
    Index_++;
    
  return RetSym_;
}

/****************************************************************************/
// -<symbolname:Symbol_Type:symattr:datatype:
//    [:Recur=n|Recur|End][:LeftSpace|RightSpace];>
//
SymbolSet* SymbolTagArray::MakeSymbolSetType(char** Args_, int len)
{
  if (len < 4 || len > 6)
    return NULL;

  char* Name_ = new_char_string(Args_[0]);
  char* SymStr_ = NULL;
  char* Ptr_;
  char* RecurStr_;
  int SymType_ = SymbolSet::Symbol_Type;
  int IoType_ = SymbolSet::INPUT;
  int DataType_;
  int Recur_ = 0;
  int SymAttr_;
  bool Csense_ = false;
  int WspaceArg_ = SymbolSet::NoPaddingSpaces;
  bool WspaceDone_ = false;
  bool RecurDone_ = false;

  SymAttr_ = (StriComp(Args_[2], "Starter") == 0)      ? SymbolSet::Starter:
             (StriComp(Args_[2], "Ender") == 0)        ? SymbolSet::Ender:
             (StriComp(Args_[2], "WhiteSpace") == 0)   ? SymbolSet::WhiteSpace:
             (StriComp(Args_[2], "LeftBracket") == 0)  ? SymbolSet::LeftBracket:
             (StriComp(Args_[2], "RightBracket") == 0) ? SymbolSet::RightBracket:
             (StriComp(Args_[2], "DelimiterSymbol") == 0)  ? SymbolSet::DelimiterSymbol:
             (StriComp(Args_[2], "AssignmentSymbol") == 0) ? SymbolSet::AssignmentSymbol:
             (StriComp(Args_[2], "OperatorSymbol") == 0)   ? SymbolSet::OperatorSymbol:
             (StriComp(Args_[2], "SymbolData") == 0)   ? SymbolSet::SymbolData:0;
  
  DataType_ = (StrniComp(Args_[3], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
              (StrniComp(Args_[3], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
              (StriComp(Args_[3], "CHAR") == 0)              ? (SymbolSet::SIGNED|SymbolSet::CHAR):
              (StriComp(Args_[3], "INT") == 0)               ? (SymbolSet::SIGNED|SymbolSet::INT):
              (StriComp(Args_[3], "FLOAT") == 0)             ? SymbolSet::FLOAT:
              (StriComp(Args_[3], "DOUBLE") == 0)            ? SymbolSet::DOUBLE:
              (StriComp(Args_[3], "LONGDOUBLE") == 0)        ? SymbolSet::LONGDOUBLE:
              (StriComp(Args_[3], "STRING") == 0)            ? SymbolSet::STRING:
              (StriComp(Args_[3], "SIGNED_CHAR") == 0)       ? (SymbolSet::SIGNED|SymbolSet::CHAR):
              (StriComp(Args_[3], "SIGNED_INT") == 0)        ? (SymbolSet::SIGNED|SymbolSet::INT):
              (StriComp(Args_[3], "UNSIGNED_CHAR") == 0)     ? (SymbolSet::UNSIGNED|SymbolSet::CHAR):
              (StriComp(Args_[3], "UNSIGNED_INT") == 0)      ? (SymbolSet::UNSIGNED|SymbolSet::INT):
              (StrniComp(Args_[3], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

  if (!DataType_)
  {
    ::DeleteArray(Name_);
    return NULL;
  }            

  if (DataType_ == SymbolSet::DEFINED ||
      DataType_ == SymbolSet::ICASEDEFINED ||
      DataType_ == SymbolSet::REGEXPR)
  {
    SymStr_ = strchr(Args_[3], '=');

    if (SymStr_)
    {
      ++SymStr_;
      Ptr_ = SymStr_;

      SymStr_ = new_char_string(Ptr_);
      SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
      Csense_ = (DataType_ == SymbolSet::DEFINED ||
                 DataType_ == SymbolSet::REGEXPR) ? true:false;
    }
  }

  if (len - 1 >= 4)
    if (StrniComp(Args_[4], "Recur", 5) == 0)
    {
      RecurDone_ = true;    
      RecurStr_ = strchr(Args_[4], '=');
      ++RecurStr_;
      Recur_ = atoi(RecurStr_);
    }
    else
    {
      WspaceDone_ = true;
      WspaceArg_ =
      (StriComp(Args_[4], "LeftSpace") == 0) ? SymbolSet::MatchLeadingSpaces:
      (StriComp(Args_[4], "RightSpace") == 0) ? SymbolSet::MatchTrailingSpaces:
                                                SymbolSet::NoPaddingSpaces;
    }

  if (len - 1 == 5)
    if (!RecurDone_ && StrniComp(Args_[5], "Recur", 5) == 0)
    {
      RecurStr_ = strchr(Args_[5], '=');
      ++RecurStr_;
      Recur_ = atoi(RecurStr_);
    }
    else if (!WspaceDone_)
    {
      WspaceArg_ =
      (StriComp(Args_[5], "LeftSpace") == 0) ? SymbolSet::MatchLeadingSpaces:
      (StriComp(Args_[5], "RightSpace") == 0) ? SymbolSet::MatchTrailingSpaces:
                                                SymbolSet::NoPaddingSpaces;
    }

  SymbolSet* Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                                   DataType_, SymAttr_,
                                   SymType_, WspaceArg_, true,
                                   true, Csense_, true);

  if (RecurDone_)
    Setp_->SetRecurTimes(Recur_);
    
  Setp_->SetName(Name_);
  ::DeleteArray(SymStr_);
  ::DeleteArray(Name_);
  
  return Setp_;
}

/****************************************************************************/
// -<symbolname:OperatorSet_Type:OperatorSymbol:datatype:
//   opType[:Separator=c {if opType==TrinaryOp}]:
//   opPos[:ResultPreOp|ResultPostOp]
//   [:Resultant:defined_datatype=c[:AssignStr=c]]
//   [:Operand1:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand2:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand3:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]];>
//
SymbolSet* SymbolTagArray::MakeOperatorSetType(char** Args_, int len)
{
  if (len < 6 || len > 17)
    return NULL;

  char* Name_ = new_char_string(Args_[0]);
  char* SymStr_ = NULL;
  char* opSymStr_ = NULL;
  char* sepSymStr_ = NULL;
  char* opString_ = new_char_string("Operand1");
  char* Ptr_;
  int SymType_ = SymbolSet::OperatorSet_Type;
  int IoType_ = SymbolSet::INPUT;
  int DataType_;
  int opDataType_;
  int SymAttr_;
  int OpType_ = 0;
  int OpPos_ = 0;
  int OpResultOrder_ = 0;
  bool Csense_ = false;
  bool opCsense_ = false;
  int idex;
  size_t slen;
  SymbolSet* Setp_ = NULL;
  SymbolSet* Setop_ = NULL;
  SymAttr_ = SymbolSet::OperatorSymbol;
  
  DataType_ = (StrniComp(Args_[3], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
              (StrniComp(Args_[3], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
              (StrniComp(Args_[3], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

  if (DataType_ == SymbolSet::DEFINED ||
      DataType_ == SymbolSet::ICASEDEFINED ||
      DataType_ == SymbolSet::REGEXPR)
  {
    SymStr_ = strchr(Args_[3], '=');

    if (SymStr_)
    {
      ++SymStr_;
      Ptr_ = SymStr_;

      SymStr_ = new_char_string(Ptr_);
      SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
      Csense_ = (DataType_ == SymbolSet::DEFINED ||
                 DataType_ == SymbolSet::REGEXPR) ? true:false;
    }
  }

  idex = 4;
  OpType_ = (StriComp(Args_[idex], "UnaryOp") == 0)      ? SymbolSet::UnaryOp:
            (StriComp(Args_[idex], "BinaryOp") == 0)     ? SymbolSet::BinaryOp:
            (StriComp(Args_[idex], "TrinaryOp") == 0)    ? SymbolSet::TrinaryOp:
            (StriComp(Args_[idex], "FreeStanding") == 0) ? SymbolSet::FreeStanding:0;
  idex++;            

  if (idex < len && OpType_ == SymbolSet::TrinaryOp &&
      StrniComp(Args_[idex], "Separator", 9) == 0)
  {
    sepSymStr_ = strchr(Args_[idex], '=');
    idex++;

    if (sepSymStr_)
    {
      ++sepSymStr_;
      Ptr_ = sepSymStr_;

      sepSymStr_ = new_char_string(Ptr_);
      sepSymStr_ = UnEscapeChars(sepSymStr_, '\\', "=\\:>", "=\\:>");
    }
  }

  if (OpType_ == SymbolSet::TrinaryOp && !sepSymStr_)
    sepSymStr_ = new_char_string(":");   // default separator is ":"  

  if (idex < len)
  {
    OpPos_ = (StriComp(Args_[idex], "PreFixed") == 0)  ? SymbolSet::PreFixed:
             (StriComp(Args_[idex], "PostFixed") == 0) ? SymbolSet::PostFixed:
             (StriComp(Args_[idex], "InFixed") == 0)   ? SymbolSet::InFixed:0;

    if (OpPos_)
      idex++;
  }

  if (idex < len)
  {  
    OpResultOrder_ = (StriComp(Args_[idex], "ResultPreOp") == 0)  ? SymbolSet::ResultPreOp:
                     (StriComp(Args_[idex], "ResultPostOp") == 0) ? SymbolSet::ResultPostOp:0;
                     
    if (OpResultOrder_)
      idex++;
  }

  if (DataType_)
  {
    Setp_ = new OperatorSet(SymStr_, " \t\n\r", IoType_,
                         DataType_, SymAttr_,
                         SymType_, 0, OpType_, OpPos_,
                         OpResultOrder_, true, true,
                         Csense_, true);

    Setp_->SetName(Name_);
    ::DeleteArray(SymStr_);
    ::DeleteArray(Name_);

    if (sepSymStr_ && strlen(sepSymStr_))
    {
      Setop_ = new SymbolSet(sepSymStr_, " \t\n\r", IoType_,
                             SymbolSet::DEFINED,
                             SymbolSet::DelimiterSymbol,
                             SymbolSet::Symbol_Type,
                             SymbolSet::NoPaddingSpaces,
                             true, true, true, true);
  
      Setp_->SetSeparator(Setop_, false);
      ::DeleteArray(sepSymStr_);
    }
  }
  else
  {
    ::DeleteArray(SymStr_);
    ::DeleteArray(Name_);  
    ::DeleteArray(sepSymStr_);
    ::DeleteArray(opString_);
    SymStr_ = Name_ =
    sepSymStr_ = opString_ = NULL;
  
    return NULL;
  }

  if (idex+1 < len && StriComp(Args_[idex], "Resultant") == 0)
  {
    idex++;
    opSymStr_ = SymStr_ = NULL;
    opCsense_ = true;
    
    opDataType_ = (StrniComp(Args_[idex], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
                  (StrniComp(Args_[idex], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
                  (StrniComp(Args_[idex], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

    if (opDataType_ == SymbolSet::DEFINED ||
        opDataType_ == SymbolSet::ICASEDEFINED ||
        opDataType_ == SymbolSet::REGEXPR)
    {
      opSymStr_ = strchr(Args_[idex], '=');

      if (opSymStr_)
      {
        ++opSymStr_;
        Ptr_ = opSymStr_;

        opSymStr_ = new_char_string(Ptr_);
        opSymStr_ = UnEscapeChars(opSymStr_, '\\', "=\\:>", "=\\:>");
        opCsense_ = (opDataType_ == SymbolSet::DEFINED ||
                     opDataType_ == SymbolSet::REGEXPR) ? true:false;
      }
    }

    idex++;

    if (idex < len && StrniComp(Args_[idex], "AssignStr", 9) == 0)
    {
      SymStr_ = strchr(Args_[idex], '=');
      idex++;

      if (SymStr_)
      {
        ++SymStr_;
        Ptr_ = SymStr_;

        SymStr_ = new_char_string(Ptr_);
        SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
      }      
    }

    if (opDataType_ && !SymStr_)
      SymStr_ = new_char_string("=");   // default assignment is "="

    if (opDataType_)
    {
      Setop_ = new SymbolSet(opSymStr_, " \t\n\r", IoType_,
                             opDataType_,
                             SymbolSet::SymbolData,
                             SymbolSet::Symbol_Type,
                             SymbolSet::NoPaddingSpaces, true,
                             true, opCsense_, true);

      Setp_->SetResultant(Setop_, false);
      ::DeleteArray(opSymStr_);

      if (SymStr_ && strlen(SymStr_))
      {
        Setop_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                               SymbolSet::DEFINED,
                               SymbolSet::AssignmentSymbol,
                               SymbolSet::Symbol_Type, 0,
                               true, true, true, true);
      
        Setp_->SetAssignment(Setop_, false);
        ::DeleteArray(SymStr_);
      }
    }
    else
    {
      ::DeleteArray(SymStr_);
      ::DeleteArray(Name_);
      ::DeleteArray(sepSymStr_);
      ::DeleteArray(opSymStr_);      
      ::DeleteArray(opString_);
      SymStr_ = Name_ = sepSymStr_ =
      opSymStr_ = opString_ = NULL;

      if (Setp_)
        delete Setp_;

      return NULL;
    }
  }    

  slen = strlen(opString_);
  int x;
  
  for (x = 0; x < 3 && idex+1 < len && StriComp(Args_[idex], opString_) == 0; x++)
  {
    idex++;
    opSymStr_ = NULL;
    opCsense_ = true;
    
    opDataType_ = (StrniComp(Args_[idex], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
                  (StrniComp(Args_[idex], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
                  (StriComp(Args_[idex], "INT") == 0)               ? (SymbolSet::SIGNED|SymbolSet::INT):
                  (StriComp(Args_[idex], "FLOAT") == 0)             ? SymbolSet::FLOAT:
                  (StriComp(Args_[idex], "DOUBLE") == 0)            ? SymbolSet::DOUBLE:
                  (StriComp(Args_[idex], "LONGDOUBLE") == 0)        ? SymbolSet::LONGDOUBLE:
                  (StriComp(Args_[idex], "SIGNED_INT") == 0)        ? (SymbolSet::SIGNED|SymbolSet::INT):
                  (StriComp(Args_[idex], "UNSIGNED_INT") == 0)      ? (SymbolSet::UNSIGNED|SymbolSet::INT):
                  (StrniComp(Args_[idex], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

    if (opDataType_ == SymbolSet::DEFINED ||
        opDataType_ == SymbolSet::ICASEDEFINED ||
        opDataType_ == SymbolSet::REGEXPR)
    {
      opSymStr_ = strchr(Args_[idex], '=');

      if (opSymStr_)
      {
        ++opSymStr_;
        Ptr_ = opSymStr_;

        opSymStr_ = new_char_string(Ptr_);
        opSymStr_ = UnEscapeChars(opSymStr_, '\\', "=\\:>", "=\\:>");
        opCsense_ = (opDataType_ == SymbolSet::DEFINED ||
                     opDataType_ == SymbolSet::REGEXPR) ? true:false;
      }
    }

    idex++;

    if (opDataType_)
    {
      Setop_ = new SymbolSet(opSymStr_, " \t\n\r", IoType_,
                             opDataType_,
                             SymbolSet::SymbolData,
                             SymbolSet::Symbol_Type,
                             SymbolSet::NoPaddingSpaces, true,
                             true, opCsense_, true);

      if (x == 0)
        Setp_->SetOperand1(Setop_, false);
      else if (x == 1)
        Setp_->SetOperand2(Setop_, false);
      else if (x == 2)
        Setp_->SetOperand3(Setop_, false);

      if (opSymStr_)
        ::DeleteArray(opSymStr_);
    }
    else
    {
      ::DeleteArray(SymStr_);
      ::DeleteArray(Name_);
      ::DeleteArray(sepSymStr_);
      ::DeleteArray(opSymStr_);      
      ::DeleteArray(opString_);
      SymStr_ = Name_ = sepSymStr_ =
      opSymStr_ = opString_ = NULL;

      if (Setp_)
        delete Setp_;      

      return NULL;
    }    
      
    opString_[slen-1]++;
  }
  
  return Setp_;
}

/****************************************************************************/
// -<symbolname:Sequence_Type:
//   seqtype[=F,N,S {if seqtype!=0}]:
//    [decltype: {if seqtype==declaration} |
//     defntype: {if seqtype==definition}]
//   structtype[=F,N {if structtype!=NotStruct}]:
//   symattr:datatype:Continue=n|Recur=n|Recur|End
//    [:LeftSpace|RightSpace];>
//
SymbolSet* SymbolTagArray::MakeSequenceType(char** Args_, int len)
{
  if (len < 7)
    return NULL;

  char* Name_ = new_char_string(Args_[0]);
  char* SymStr_ = NULL;
  char* SepStr_ = NULL;
  char* CntNumStr_;
  char* RecurLimStr_;
  char* Ptr_;
  int CntNum_;
  int RecurLim_;
  int WspaceArg_;
  int SymType_ = SymbolSet::Sequence_Type;
  int ElmType_ = SymbolSet::Symbol_Type;
  int IoType_ = SymbolSet::INPUT;
  int DataType_;
  int SeqType_;
  int TypeExt_;
  int Struct_;  
  int SymAttr_;
  int sdex = 2;  
  int adex = 4;
  int ddex = 5;
  int x, y;
  bool Continue_ = false;
  bool End_ = false;
  bool Recur_ = false;
  bool Csense_ = false;
  Sequence* Seqp_ = NULL;
  SymbolSet* Setp_ = NULL;

  SeqType_ = (StriComp(Args_[sdex], "Reserved") == 0)        ? SymbolSet::Reserved:
             (StriComp(Args_[sdex], "Constant") == 0)        ? SymbolSet::Constant:
             (StriComp(Args_[sdex], "Statement") == 0)       ? SymbolSet::Statement:
             (StriComp(Args_[sdex], "Expression") == 0)      ? SymbolSet::Expression:
             (StriComp(Args_[sdex], "Label") == 0)           ? SymbolSet::Label:
             (StriComp(Args_[sdex], "LabelJump") == 0)       ? SymbolSet::LabelJump:
             (StriComp(Args_[sdex], "Declaration") == 0)     ? SymbolSet::Declaration:
             (StriComp(Args_[sdex], "Definition") == 0)      ? SymbolSet::Definition:
             (StriComp(Args_[sdex], "FncCall") == 0)         ? SymbolSet::FncCall:
             (StriComp(Args_[sdex], "FncName") == 0)         ? SymbolSet::FncName:
             (StriComp(Args_[sdex], "Directive") == 0)       ? SymbolSet::Directive:
             (StriComp(Args_[sdex], "ParserDirective") == 0) ? SymbolSet::ParserDirective:0;

  if (SeqType_ & SymbolSet::Declaration)
  {
    ++adex;
    ++ddex;
    ++sdex;
    
    TypeExt_ = (StriComp(Args_[sdex], "ConstDecl") == 0)    ? SymbolSet::ConstDecl:
               (StriComp(Args_[sdex], "VarDecl") == 0)      ? SymbolSet::VarDecl:
               (StriComp(Args_[sdex], "ListDecl") == 0)     ? SymbolSet::ListDecl:
               (StriComp(Args_[sdex], "FncDecl") == 0)      ? SymbolSet::FncDecl:
               (StriComp(Args_[sdex], "StructDecl") == 0)   ? SymbolSet::StructDecl:
               (StriComp(Args_[sdex], "ClassDecl") == 0)    ? SymbolSet::ClassDecl:
               (StriComp(Args_[sdex], "MemberDecl") == 0)   ? SymbolSet::MemberDecl:
               (StriComp(Args_[sdex], "MethodDecl") == 0)   ? SymbolSet::MethodDecl:0;
  }
  else if (SeqType_ & SymbolSet::Definition)
  {
    ++adex;
    ++ddex;
    ++sdex;
  
    TypeExt_ = (StriComp(Args_[sdex], "FncDefn") == 0)      ? SymbolSet::FncDefn:
               (StriComp(Args_[sdex], "ClassDefn") == 0)    ? SymbolSet::ClassDefn:
               (StriComp(Args_[sdex], "MethodDefn") == 0)   ? SymbolSet::MethodDefn:0;
  }

  ++sdex;
  Struct_ = (StriComp(Args_[sdex], "NotStruct") == 0)         ? SymbolSet::NotStruct:
            (StriComp(Args_[sdex], "ReservedStruct") == 0)    ? SymbolSet::ReservedStruct:
            (StriComp(Args_[sdex], "CtrlStruct") == 0)        ? SymbolSet::CtrlStruct:
            (StriComp(Args_[sdex], "BranchStruct") == 0)      ? SymbolSet::BranchStruct:
            (StriComp(Args_[sdex], "ListStruct") == 0)        ? SymbolSet::ListStruct:
            (StriComp(Args_[sdex], "AltElseDef") == 0)        ? SymbolSet::AltElseDef:
            (StriComp(Args_[sdex], "SwitchStruct") == 0)      ? SymbolSet::SwitchStruct:
            (StriComp(Args_[sdex], "CondTestStruct") == 0)    ? SymbolSet::CondTestStruct:
            (StriComp(Args_[sdex], "LoopStruct") == 0)        ? SymbolSet::LoopStruct:
            (StriComp(Args_[sdex], "LabelStruct") == 0)       ? SymbolSet::LabelStruct:
            (StriComp(Args_[sdex], "IterStruct") == 0)        ? SymbolSet::IterStruct:
            (StriComp(Args_[sdex], "FunctionStruct") == 0)    ? SymbolSet::FunctionStruct:0;
  
  for (x = 0; !End_; x++)
  {
    SymAttr_ = (StriComp(Args_[adex], "Starter") == 0)      ? SymbolSet::Starter:
               (StriComp(Args_[adex], "Ender") == 0)        ? SymbolSet::Ender:
               (StriComp(Args_[adex], "WhiteSpace") == 0)   ? SymbolSet::WhiteSpace:
               (StriComp(Args_[adex], "LeftBracket") == 0)  ? SymbolSet::LeftBracket:
               (StriComp(Args_[adex], "RightBracket") == 0) ? SymbolSet::RightBracket:
               (StriComp(Args_[adex], "DelimiterSymbol") == 0)  ? SymbolSet::DelimiterSymbol:
               (StriComp(Args_[adex], "AssignmentSymbol") == 0) ? SymbolSet::AssignmentSymbol:
               (StriComp(Args_[adex], "OperatorSymbol") == 0)   ? SymbolSet::OperatorSymbol:
               (StriComp(Args_[adex], "SymbolData") == 0)   ? SymbolSet::SymbolData:0;
  
    DataType_ = (StrniComp(Args_[ddex], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
                (StrniComp(Args_[ddex], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
                (StriComp(Args_[ddex], "CHAR") == 0)              ? (SymbolSet::SIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "INT") == 0)               ? (SymbolSet::SIGNED|SymbolSet::INT):
                (StriComp(Args_[ddex], "FLOAT") == 0)             ? SymbolSet::FLOAT:
                (StriComp(Args_[ddex], "DOUBLE") == 0)            ? SymbolSet::DOUBLE:
                (StriComp(Args_[ddex], "LONGDOUBLE") == 0)        ? SymbolSet::LONGDOUBLE:
                (StriComp(Args_[ddex], "STRING") == 0)            ? SymbolSet::STRING:
                (StriComp(Args_[ddex], "SIGNED_CHAR") == 0)       ? (SymbolSet::SIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "SIGNED_INT") == 0)        ? (SymbolSet::SIGNED|SymbolSet::INT):
                (StriComp(Args_[ddex], "UNSIGNED_CHAR") == 0)     ? (SymbolSet::UNSIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "UNSIGNED_INT") == 0)      ? (SymbolSet::UNSIGNED|SymbolSet::INT):
                (StrniComp(Args_[ddex], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

    if (!DataType_)
    {
      ::DeleteArray(Name_);

      if (Seqp_)
        delete Seqp_;
      
      return NULL;
    }                

    if (DataType_ == SymbolSet::DEFINED ||
        DataType_ == SymbolSet::ICASEDEFINED ||
        DataType_ == SymbolSet::REGEXPR)
    {
      SymStr_ = strchr(Args_[ddex], '=');

      if (SymStr_)
      {
        ++SymStr_;
        Ptr_ = SymStr_;

        SymStr_ = new_char_string(Ptr_);
        SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
        Csense_ = (DataType_ == SymbolSet::DEFINED ||
                   DataType_ == SymbolSet::REGEXPR) ? true:false;
      }
    }

    if (x == 0)
    {
      Seqp_ = new Sequence(SymStr_, " \t\n\r", IoType_,
                           DataType_, Struct_, SymAttr_,
                           SymType_, SeqType_, TypeExt_,
                           0, true, true, Csense_, true);

      // Argument Summary:
      // 1st: SymStr_   : SymbolSet Characater, string if defined
      // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
      // 3rd: IoType_   : IO Type, set to INPUT
      // 4th: DataType_ : Data Type, parsed from sequence tags
      // 6th: SymAttr_  : Symbol Attributes, parsed from sequence tags
      // 7th: ElmType_  : Symbol Type, set as Symbol_Type
      // 8th: 0         : Match leading or trailing whitespaces, none
      // 9th: true      : Skip whitespaces, true
      // 10th: true     : Required and not optional, true
      // 11th: Csense_  : Case Sensitive, parsed from sequence tags
      // 12th: true     : Ordered Symbol Set, true
      //
      Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                            DataType_, SymAttr_,
                            ElmType_, 0, true,
                            true, Csense_, true);

      Seqp_->SetNext(Setp_);
    }
    else
    {
      // Argument Summary:
      // 1st: SymStr_   : SymbolSet Characater, string if defined
      // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
      // 3rd: IoType_   : IO Type, set to INPUT
      // 4th: DataType_ : Data Type, parsed from sequence tags
      // 6th: SymAttr_  : Symbol Attributes, parsed from sequence tags
      // 7th: ElmType_  : Symbol Type, set as Symbol_Type
      // 8th: 0         : Match leading or trailing whitespaces, none
      // 9th: true      : Skip whitespaces, true
      // 10th: true     : Required and not optional, true
      // 11th: Csense_  : Case Sensitive, parsed from sequence tags
      // 12th: true     : Ordered Symbol Set, true
      //    
      Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                            DataType_, SymAttr_,
                            ElmType_, 0, true,
                            true, Csense_, true);

      Seqp_->SetNext(Setp_);    
    }

    adex += 2;
    ddex += 2;

    while (StrniComp(Args_[adex], "Continue", 8) == 0)
    {
      CntNumStr_ = strchr(Args_[adex], '=');

      if (CntNumStr_)
      {
        ++CntNumStr_;
        CntNum_ = atoi(CntNumStr_);
      
        if (x)
        {
          for (y = 0; y < CntNum_; y++)
          {
            Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                                  DataType_, SymAttr_,
                                  SymType_, 0, true,
                                  true, Csense_, true);

            Seqp_->SetNext(Setp_);
          }

          ++x;
        }
      }

      ++adex;
      ++ddex;      
    }

    ::DeleteArray(SymStr_);
    SymStr_ = NULL;
    Recur_ = (StrniComp(Args_[adex], "Recur", 5) == 0);
    End_ = !Recur_ &&
           (StrniComp(Args_[adex], "End", 3) == 0) || (adex >= len-1);

    if (Recur_)
    {
      RecurLimStr_ = strchr(Args_[adex], '=');
      if (RecurLimStr_)
      {
        ++RecurLimStr_;        
        RecurLim_ = atoi(RecurLimStr_);
      }
      else
        RecurLim_ = Sequence::CIRCDEFLIMIT;

      End_ = Recur_;
    }
  }

  if (adex < len-1 && StrniComp(Args_[adex+1], "Separator", 9) == 0)
  {
    SepStr_ = strchr(Args_[adex+1], '=');

    if (SepStr_)
    {
      ++SepStr_;
      Ptr_ = SepStr_;
    
      SepStr_ = new_char_string(Ptr_);
      SepStr_ = UnEscapeChars(SepStr_, '\\', "=\\:>", "=\\:>");

      if (strlen(SepStr_))
      {
        Setp_ = new SymbolSet(SepStr_, " \t\n\r", IoType_,
                              SymbolSet::DEFINED,
                              SymbolSet::DelimiterSymbol,
                              SymbolSet::Symbol_Type, 0,
                              true, true, true, true);
      
        Seqp_->SetSeparator(Setp_);
      }
    }
  }

  sdex = len - 1;
  WspaceArg_ =
  (StriComp(Args_[sdex], "LeftSpace") == 0) ? SymbolSet::MatchLeadingSpaces:
  (StriComp(Args_[sdex], "RightSpace") == 0) ? SymbolSet::MatchTrailingSpaces:
                                               SymbolSet::NoPaddingSpaces;

  if (WspaceArg_ == SymbolSet::MatchLeadingSpaces)
    Seqp_->NextSymbol(0, true)->SetWspace(WspaceArg_);
  else if (WspaceArg_ == SymbolSet::MatchTrailingSpaces)
    Seqp_->NextSymbol(Seqp_->Length()-1, true)->SetWspace(WspaceArg_);  
  
  if (Recur_)
  {
    Seqp_->ConvertToCircSeq();
    Seqp_->SetCircDefLimitValue(RecurLim_);
    Seqp_ = (Sequence*)Seqp_->NextSymbol(Seqp_->Length()-1, true);
  }
  
  Seqp_->SetName(Name_);
  ::DeleteArray(Name_);
  ::DeleteArray(SepStr_);
  
  return Seqp_;
}

/****************************************************************************/
// -<symbolname:BranchOut_Type:
//   seqtype[=F,N,S {if seqtype!=0}]:
//    [decltype: {if seqtype==declaration} |
//     defntype: {if seqtype==definition}]
//   structtype[=F,N {if structtype!=NotStruct}]:
//   symattr:datatype:Continue=n|End
//    [:Separator=c][:LeftSpace|RightSpace];>
//
SymbolSet* SymbolTagArray::MakeBranchOutType(char** Args_, int len)
{
  if (len < 7)
    return NULL;

  char* Name_ = new_char_string(Args_[0]);
  char* SymStr_ = NULL;
  char* SepStr_ = NULL;
  char* CntNumStr_;
  char* Ptr_;
  int CntNum_;
  int WspaceArg_;  
  int SymType_ = SymbolSet::BranchOut_Type;
  int ElmType_ = SymbolSet::Symbol_Type;  
  int IoType_ = SymbolSet::INPUT;
  int DataType_;
  int SeqType_;
  int TypeExt_;  
  int Struct_;  
  int SymAttr_;
  int sdex = 2;  
  int adex = 4;
  int ddex = 5;
  int x, y;
  bool Continue_ = false;
  bool End_ = false;
  bool Csense_ = false;
  BranchOut* Seqp_ = NULL;
  SymbolSet* Setp_ = NULL;

  SeqType_ = (StriComp(Args_[sdex], "Reserved") == 0)        ? SymbolSet::Reserved:
             (StriComp(Args_[sdex], "Constant") == 0)        ? SymbolSet::Constant:
             (StriComp(Args_[sdex], "Statement") == 0)       ? SymbolSet::Statement:
             (StriComp(Args_[sdex], "Expression") == 0)      ? SymbolSet::Expression:
             (StriComp(Args_[sdex], "Label") == 0)           ? SymbolSet::Label:
             (StriComp(Args_[sdex], "LabelJump") == 0)       ? SymbolSet::LabelJump:
             (StriComp(Args_[sdex], "Declaration") == 0)     ? SymbolSet::Declaration:
             (StriComp(Args_[sdex], "Definition") == 0)      ? SymbolSet::Definition:
             (StriComp(Args_[sdex], "FncCall") == 0)         ? SymbolSet::FncCall:
             (StriComp(Args_[sdex], "FncName") == 0)         ? SymbolSet::FncName:
             (StriComp(Args_[sdex], "Directive") == 0)       ? SymbolSet::Directive:
             (StriComp(Args_[sdex], "ParserDirective") == 0) ? SymbolSet::ParserDirective:0;

  if (SeqType_ & SymbolSet::Declaration)
  {
    ++adex;
    ++ddex;
    ++sdex;
    
    TypeExt_ = (StriComp(Args_[sdex], "ConstDecl") == 0)    ? SymbolSet::ConstDecl:
               (StriComp(Args_[sdex], "VarDecl") == 0)      ? SymbolSet::VarDecl:
               (StriComp(Args_[sdex], "ListDecl") == 0)     ? SymbolSet::ListDecl:
               (StriComp(Args_[sdex], "FncDecl") == 0)      ? SymbolSet::FncDecl:
               (StriComp(Args_[sdex], "StructDecl") == 0)   ? SymbolSet::StructDecl:
               (StriComp(Args_[sdex], "ClassDecl") == 0)    ? SymbolSet::ClassDecl:
               (StriComp(Args_[sdex], "MemberDecl") == 0)   ? SymbolSet::MemberDecl:
               (StriComp(Args_[sdex], "MethodDecl") == 0)   ? SymbolSet::MethodDecl:0;
  }
  else if (SeqType_ & SymbolSet::Definition)
  {
    ++adex;
    ++ddex;
    ++sdex;
  
    TypeExt_ = (StriComp(Args_[sdex], "FncDefn") == 0)      ? SymbolSet::FncDefn:
               (StriComp(Args_[sdex], "ClassDefn") == 0)    ? SymbolSet::ClassDefn:
               (StriComp(Args_[sdex], "MethodDefn") == 0)   ? SymbolSet::MethodDefn:0;
  }

  ++sdex;
  Struct_ = (StriComp(Args_[sdex], "NotStruct") == 0)         ? SymbolSet::NotStruct:
            (StriComp(Args_[sdex], "ReservedStruct") == 0)    ? SymbolSet::ReservedStruct:
            (StriComp(Args_[sdex], "CtrlStruct") == 0)        ? SymbolSet::CtrlStruct:
            (StriComp(Args_[sdex], "BranchStruct") == 0)      ? SymbolSet::BranchStruct:
            (StriComp(Args_[sdex], "ListStruct") == 0)        ? SymbolSet::ListStruct:
            (StriComp(Args_[sdex], "AltElseDef") == 0)        ? SymbolSet::AltElseDef:
            (StriComp(Args_[sdex], "SwitchStruct") == 0)      ? SymbolSet::SwitchStruct:
            (StriComp(Args_[sdex], "CondTestStruct") == 0)    ? SymbolSet::CondTestStruct:
            (StriComp(Args_[sdex], "LoopStruct") == 0)        ? SymbolSet::LoopStruct:
            (StriComp(Args_[sdex], "LabelStruct") == 0)       ? SymbolSet::LabelStruct:
            (StriComp(Args_[sdex], "IterStruct") == 0)        ? SymbolSet::IterStruct:
            (StriComp(Args_[sdex], "FunctionStruct") == 0)    ? SymbolSet::FunctionStruct:0;
  
  for (x = 0; !End_; x++)
  {
    SymAttr_ = (StriComp(Args_[adex], "Starter") == 0)      ? SymbolSet::Starter:
               (StriComp(Args_[adex], "Ender") == 0)        ? SymbolSet::Ender:
               (StriComp(Args_[adex], "WhiteSpace") == 0)   ? SymbolSet::WhiteSpace:
               (StriComp(Args_[adex], "LeftBracket") == 0)  ? SymbolSet::LeftBracket:
               (StriComp(Args_[adex], "RightBracket") == 0) ? SymbolSet::RightBracket:
               (StriComp(Args_[adex], "DelimiterSymbol") == 0)  ? SymbolSet::DelimiterSymbol:
               (StriComp(Args_[adex], "AssignmentSymbol") == 0) ? SymbolSet::AssignmentSymbol:
               (StriComp(Args_[adex], "OperatorSymbol") == 0)   ? SymbolSet::OperatorSymbol:
               (StriComp(Args_[adex], "SymbolData") == 0)   ? SymbolSet::SymbolData:0;
                 
    DataType_ = (StrniComp(Args_[ddex], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
                (StrniComp(Args_[ddex], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
                (StriComp(Args_[ddex], "CHAR") == 0)              ? (SymbolSet::SIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "INT") == 0)               ? (SymbolSet::SIGNED|SymbolSet::INT):
                (StriComp(Args_[ddex], "FLOAT") == 0)             ? SymbolSet::FLOAT:
                (StriComp(Args_[ddex], "DOUBLE") == 0)            ? SymbolSet::DOUBLE:
                (StriComp(Args_[ddex], "LONGDOUBLE") == 0)        ? SymbolSet::LONGDOUBLE:
                (StriComp(Args_[ddex], "STRING") == 0)            ? SymbolSet::STRING:
                (StriComp(Args_[ddex], "SIGNED_CHAR") == 0)       ? (SymbolSet::SIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "SIGNED_INT") == 0)        ? (SymbolSet::SIGNED|SymbolSet::INT):
                (StriComp(Args_[ddex], "UNSIGNED_CHAR") == 0)     ? (SymbolSet::UNSIGNED|SymbolSet::CHAR):
                (StriComp(Args_[ddex], "UNSIGNED_INT") == 0)      ? (SymbolSet::UNSIGNED|SymbolSet::INT):
                (StrniComp(Args_[ddex], "REGEXPR", 7) == 0)       ? SymbolSet::REGEXPR:0;

    if (!DataType_)
    {
      ::DeleteArray(Name_);

      if (Seqp_)
        delete Seqp_;
      
      return NULL;
    }

    if (DataType_ == SymbolSet::DEFINED ||
        DataType_ == SymbolSet::ICASEDEFINED ||
        DataType_ == SymbolSet::REGEXPR)
    {
      SymStr_ = strchr(Args_[ddex], '=');

      if (SymStr_)
      {
        ++SymStr_;
        Ptr_ = SymStr_;

        SymStr_ = new_char_string(Ptr_);
        SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
        Csense_ = (DataType_ == SymbolSet::DEFINED ||
                   DataType_ == SymbolSet::REGEXPR) ? true:false;
      }
    }

    if (x == 0)
    {
      Seqp_ = new BranchOut(SymStr_, " \t\n\r", IoType_,
                            DataType_, Struct_, SymAttr_,
                            SymType_, 0, SeqType_, TypeExt_,
                            true, true, Csense_, true);

      // Argument Summary:
      // 1st: SymStr_   : SymbolSet Characater, string if defined
      // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
      // 3rd: IoType_   : IO Type, set to INPUT
      // 4th: DataType_ : Data Type, parsed from branchout tags
      // 6th: SymAttr_  : Symbol Attributes, parsed from branchout tags
      // 7th: ElmType_  : Symbol Type, set as Symbol_Type
      // 8th: 0         : Match leading or trailing whitespaces, none
      // 9th: true      : Skip whitespaces, true
      // 10th: true     : Required and not optional, true
      // 11th: Csense_  : Case Sensitive, parsed from branchout tags
      // 12th: true     : Ordered Symbol Set, true
      //
      Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                            DataType_, SymAttr_,
                            ElmType_, 0, true,
                            true, Csense_, true);

      Seqp_->SetNext(Setp_);
    }
    else
    {
      // Argument Summary:
      // 1st: SymStr_   : SymbolSet Characater, string if defined
      // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
      // 3rd: IoType_   : IO Type, set to INPUT
      // 4th: DataType_ : Data Type, parsed from branchout tags
      // 6th: SymAttr_  : Symbol Attributes, parsed from branchout tags
      // 7th: ElmType_  : Symbol Type, set as Symbol_Type
      // 8th: 0         : Match leading or trailing whitespaces, none
      // 9th: true      : Skip whitespaces, true
      // 10th: true     : Required and not optional, true
      // 11th: Csense_  : Case Sensitive, parsed from branchout tags
      // 12th: true     : Ordered Symbol Set, true
      //    
      Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                            DataType_, SymAttr_,
                            ElmType_, 0, true,
                            true, Csense_, true);

      Seqp_->SetNext(Setp_);    
    }

    adex += 2;
    ddex += 2;

    while (StrniComp(Args_[adex], "Continue", 8) == 0)
    {
      CntNumStr_ = strchr(Args_[adex], '=');

      if (CntNumStr_)
      {
        ++CntNumStr_;
        CntNum_ = atoi(CntNumStr_);
      
        if (x)
        {
          for (y = 0; y < CntNum_; y++)
          {
            Setp_ = new SymbolSet(SymStr_, " \t\n\r", IoType_,
                                  DataType_, SymAttr_,
                                  SymType_, 0, true,
                                  true, Csense_, true);

            Seqp_->SetNext(Setp_);
          }

          ++x;
        }
      }
      
      ++adex;
      ++ddex;
    }

    ::DeleteArray(SymStr_);
    SymStr_ = NULL;
    End_ = (StrniComp(Args_[adex], "End", 3) == 0) || (adex >= len-1);
  }

  if (StrniComp(Args_[adex+1], "Separator", 9) == 0)
  {
    SepStr_ = strchr(Args_[adex+1], '=');

    if (SepStr_)
    {
      ++SepStr_;
      Ptr_ = SepStr_;
    
      SepStr_ = new_char_string(Ptr_);
      SepStr_ = UnEscapeChars(SepStr_, '\\', "=\\:>", "=\\:>");

      if (strlen(SepStr_))
      {
        Setp_ = new SymbolSet(SepStr_, " \t\n\r", IoType_,
                              SymbolSet::DEFINED,
                              SymbolSet::DelimiterSymbol,
                              SymbolSet::Symbol_Type, 0,
                              true, true, true, true);
      
        Seqp_->SetSeparator(Setp_);
      }
    }
  }

  sdex = len - 1;
  WspaceArg_ =
  (StriComp(Args_[sdex], "LeftSpace") == 0) ? SymbolSet::MatchLeadingSpaces:
  (StriComp(Args_[sdex], "RightSpace") == 0) ? SymbolSet::MatchTrailingSpaces:
                                               SymbolSet::NoPaddingSpaces;

  if (WspaceArg_ == SymbolSet::MatchLeadingSpaces)
    Seqp_->NextSymbol(0, true)->SetWspace(WspaceArg_);
  else if (WspaceArg_ == SymbolSet::MatchTrailingSpaces)
    Seqp_->NextSymbol(Seqp_->Length()-1, true)->SetWspace(WspaceArg_);

  Seqp_->SetName(Name_);
  ::DeleteArray(Name_);
  ::DeleteArray(SepStr_);
  
  return Seqp_;
}

/****************************************************************************/
// -<symbolname:BracketedSymbol_Type:LeftBracket:datatype:
//   Delim=c|NoDelim:pushblk:pushfnc>
// (<BracketedSymbol_Type:Data:datatype:
//   Delim=c|NoDelim:Continue=n|End> |
//  <BracketedSymbol_Type:LeftBracket:datatype:
//   Delim=c|NoDelim:pushblk:pushfnc>)
// <BracketedSymbol_Type:RightBracket:datatype:
//  Delim=c|NoDelim:pushblk:pushfnc;>
//
SymbolSet* SymbolTagArray::MakeBracketedSymbolType(char** Args_, int len, int& BrkLvl_,
                                              int& CallIter_, SymbolSet* RetSym_,
                                              bool& Done_)
{
  int adex = 2;
  int ddex = 3;
  int sdex = 4;
  int ndex = 5;
  int DataType_;
  int SymAttr_;
  int PushBlk_;
  int PushFnc_;

  char* Name_ = NULL;
  char* SymStr_ = NULL;
  char* Delim_;
  char* Ptr_;
  int SymType_ = SymbolSet::BracketedSymbol_Type;
  int ElmType_ = SymbolSet::Symbol_Type;
  int IoType_ = SymbolSet::INPUT;
  int x, y;
  bool Continue_ = false;
  bool End_ = false;
  bool Csense_ = false;
  bool HasDelim_ = false;
  SymbolSet* Setp_ = NULL;
  SymbolSet* Delimp_ = NULL;
  BracketedSymbol* Bsymp_;  

  char* CntNumStr_;  
  int CntNum_;

  if (CallIter_ > 0)
  {
    --adex;
    --ddex;
    --sdex;
    --ndex;
  }

  SymAttr_ = (StriComp(Args_[adex], "LeftBracket") == 0)  ? SymbolSet::LeftBracket:
             (StriComp(Args_[adex], "RightBracket") == 0) ? SymbolSet::RightBracket:
             (StriComp(Args_[adex], "Data") == 0)         ? SymbolSet::SymbolData:0;

  DataType_ = (StrniComp(Args_[ddex], "DEFINED", 7) == 0)       ? SymbolSet::DEFINED:
              (StrniComp(Args_[ddex], "ICASEDEFINED", 12) == 0) ? SymbolSet::ICASEDEFINED:
              (StriComp(Args_[ddex], "CHAR") == 0)              ? (SymbolSet::SIGNED|SymbolSet::CHAR):
              (StriComp(Args_[ddex], "INT") == 0)               ? (SymbolSet::SIGNED|SymbolSet::INT):
              (StriComp(Args_[ddex], "FLOAT") == 0)             ? SymbolSet::FLOAT:
              (StriComp(Args_[ddex], "DOUBLE") == 0)            ? SymbolSet::DOUBLE:
              (StriComp(Args_[ddex], "LONGDOUBLE") == 0)        ? SymbolSet::LONGDOUBLE:
              (StriComp(Args_[ddex], "STRING") == 0)            ? SymbolSet::STRING:
              (StriComp(Args_[ddex], "SIGNED_CHAR") == 0)       ? (SymbolSet::SIGNED|SymbolSet::CHAR):
              (StriComp(Args_[ddex], "SIGNED_INT") == 0)        ? (SymbolSet::SIGNED|SymbolSet::INT):
              (StriComp(Args_[ddex], "UNSIGNED_CHAR") == 0)     ? (SymbolSet::UNSIGNED|SymbolSet::CHAR):
              (StriComp(Args_[ddex], "UNSIGNED_INT") == 0)      ? (SymbolSet::UNSIGNED|SymbolSet::INT):
              (StrniComp(Args_[ddex], "REGEXRP", 7) == 0)       ? SymbolSet::REGEXPR:
              ((StriComp(Args_[ddex], "NO_DATA") == 0) ||
               (StriComp(Args_[ddex], "NONE") == 0))            ? SymbolSet::NO_DATA:0;

  if (StrniComp(Args_[sdex], "Delim", 5) == 0)
  {
    Delim_ = strchr(Args_[sdex], '=');

    if (Delim_)
    {
      HasDelim_ = true;    
      ++Delim_;
      Ptr_ = Delim_;

      Delim_ = new_char_string(Ptr_);
      Delim_ = UnEscapeChars(Delim_, '\\', "=\\:>", "=\\:>");
    }

    ++sdex;    
  }
  else if (StriComp(Args_[sdex], "NoDelim") == 0)
  {
    HasDelim_ = false;
    ++sdex;    
  }

  if (HasDelim_)
    Delimp_ = new SymbolSet(Delim_, " \t\n\r", IoType_,
                            SymbolSet::DEFINED,
                            SymbolSet::DelimiterSymbol,
                            SymbolSet::Symbol_Type, 0,
                            true, true, true, true);

  if (DataType_ == SymbolSet::DEFINED ||
      DataType_ == SymbolSet::ICASEDEFINED ||
      DataType_ == SymbolSet::REGEXPR)
  {
    SymStr_ = strchr(Args_[ddex], '=');

    if (SymStr_)
    {
      ++SymStr_;
      Ptr_ = SymStr_;

      SymStr_ = new_char_string(Ptr_);
      SymStr_ = UnEscapeChars(SymStr_, '\\', "=\\:>", "=\\:>");
      Csense_ = (DataType_ == SymbolSet::DEFINED ||
                 DataType_ == SymbolSet::REGEXPR) ? true:false;
    }
  }

  if (SymAttr_ == SymbolSet::LeftBracket &&
     (DataType_ == SymbolSet::DEFINED ||
      DataType_ == SymbolSet::ICASEDEFINED ||
      DataType_ == SymbolSet::REGEXPR ||
      DataType_ == SymbolSet::NO_DATA))
  {  
    PushBlk_ = atoi(Args_[ndex]);
    ndex++;
    PushFnc_ = atoi(Args_[ndex]);
    BrkLvl_++;
    CallIter_++;

    if (CallIter_ == 1 && len != 7)
    {
      ::DeleteArray(Delim_);
      ::DeleteArray(SymStr_);
      Done_ = true;

      if (HasDelim_)
        delete Delimp_;

      if (RetSym_)
        delete RetSym_;
      
      return NULL;
    }
    else if (CallIter_ > 1 && len != 6)
    {
      ::DeleteArray(Delim_);
      ::DeleteArray(SymStr_);
      Done_ = true;

      if (HasDelim_)
        delete Delimp_;

      if (RetSym_)
        delete RetSym_;
        
      return NULL;
    }

    if (DataType_ == SymbolSet::NO_DATA)
      Setp_ = NULL;
    else
      Setp_ = new SymbolSet(SymStr_, " \t\n\r",
                            IoType_, DataType_,
                            SymbolSet::LeftBracket,
                            SymbolSet::Symbol_Type, 0,
                            true, true, Csense_, true);

    // change: SymStr, DataType, Csense on
    // next iteration to data information
    Bsymp_ = new BracketedSymbol("s", " \t\n\r",
                                 IoType_, DataType_,
                                 SymbolSet::SymbolData,
                                 SymType_, 0, true,
                                 true, Csense_, true);

    Bsymp_->SetSymbol(NULL);
    Bsymp_->SetDataType(SymbolSet::NO_DATA);

    if (!RetSym_)
    {
      Bsymp_->SetLeftBracket(Setp_, false);
      Bsymp_->IncBlockCount(PushBlk_);
      Bsymp_->IncFunctionCount(PushFnc_);
      
      if (Setp_)
        Setp_->SetEnclosing(Bsymp_);

      if (HasDelim_)
      {
        Bsymp_->SetDelimiter(Delimp_, false);
        Delimp_->SetEnclosing(Bsymp_);
      }
      else
        Bsymp_->SetDelimiter(NULL);
      
      RetSym_ = Bsymp_;
    }
    else
    {
      Bsymp_->SetLeftBracket(Setp_, false);
      Bsymp_->IncBlockCount(PushBlk_);
      Bsymp_->IncFunctionCount(PushFnc_);
      
      if (Setp_)      
        Setp_->SetEnclosing(Bsymp_);

      if (HasDelim_)
      {      
        Bsymp_->SetDelimiter(Delimp_, true);
        Delimp_->SetEnclosing(Bsymp_);
      }
      else
        Bsymp_->SetDelimiter(NULL);      
      
      RetSym_->SetNext(Bsymp_, false);
      Bsymp_->SetEnclosing(RetSym_);
      
      RetSym_->SetSymbol(NULL);
      RetSym_->SetDataType(SymbolSet::NO_DATA);

      if (HasDelim_)
      {      
        RetSym_->SetDelimiter(Delimp_, false);
        Delimp_->SetEnclosing(RetSym_);
      }
      else
        RetSym_->SetDelimiter(NULL);

      RetSym_ = Bsymp_;
    }
    
    Done_ = (BrkLvl_ == 0);
  }
  else if (SymAttr_ == SymbolSet::RightBracket && RetSym_ &&
          (DataType_ == SymbolSet::DEFINED ||
           DataType_ == SymbolSet::ICASEDEFINED ||
           DataType_ == SymbolSet::REGEXPR ||
           DataType_ == SymbolSet::NO_DATA))
  {  
    PushBlk_ = atoi(Args_[ndex]);
    ndex++;
    PushFnc_ = atoi(Args_[ndex]);
    BrkLvl_--;
    CallIter_++;

    if (CallIter_ > 1 && len != 6)
    {
      ::DeleteArray(Delim_);
      ::DeleteArray(SymStr_);
      Done_ = true;

      if (HasDelim_)
        delete Delimp_;

      if (RetSym_)
        delete RetSym_;
      
      return NULL;
    }

    if (DataType_ == SymbolSet::NO_DATA)
      Setp_ = NULL;
    else
      Setp_ = new SymbolSet(SymStr_, " \t\n\r",
                            IoType_, DataType_,
                            SymbolSet::RightBracket,
                            SymbolSet::Symbol_Type, 0,
                            true, true, Csense_, true);

    RetSym_->SetRightBracket(Setp_, false);
    RetSym_->IncBlockCount(PushBlk_);
    RetSym_->IncFunctionCount(PushFnc_);

    if (Setp_)
      Setp_->SetEnclosing(RetSym_);

    if (HasDelim_)
    {
      RetSym_->SetDelimiter(Delimp_, false);
      Delimp_->SetEnclosing(RetSym_);
    }
    else
      RetSym_->SetDelimiter(NULL);
    
    RetSym_ = RetSym_->GetEnclosing();
    Done_ = (BrkLvl_ == 0);
  }
  else if (SymAttr_ == SymbolSet::SymbolData)
  {
    CallIter_++;

    if (CallIter_ > 1 && len != 5)
    {
      ::DeleteArray(Delim_);
      ::DeleteArray(SymStr_);
      Done_ = true;

      if (HasDelim_)
        delete Delimp_;

      if (RetSym_)
        delete RetSym_;
      
      return NULL;
    }

    if (StrniComp(Args_[sdex], "continue", 8) == 0)
    {
      CntNumStr_ = strchr(Args_[sdex], '=');

      if (CntNumStr_)
      {
        ++CntNumStr_;
        CntNum_ = atoi(CntNumStr_);
        Continue_ = true;
      }
    }
    else if (StriComp(Args_[sdex], "end") == 0)
    {
      CntNumStr_ = NULL;
      CntNum_ = 0;
      End_ = true;
    }

    if (Continue_)
    {
      if (RetSym_->GetDataType() == SymbolSet::NO_DATA)
      {
        RetSym_->SetSymbol(SymStr_);
        RetSym_->SetDataType(DataType_);
        RetSym_->SetCaseSensitive(Csense_);
        x = 1;
      }
      else
        x = 0;
        
      if (HasDelim_ &&
          (CntNum_ > 1 ||
          RetSym_->GetEnclosing() && BrkLvl_))
      {
        RetSym_->SetDelimiter(Delimp_, true);
        Delimp_->SetEnclosing(RetSym_);
      }
      else
        RetSym_->SetDelimiter(NULL);
    
      for (;x < CntNum_; x++)
      {
        // Argument Summary:
        // 1st: SymStr_   : SymbolSet Characater, string if defined
        // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
        // 3rd: IoType_   : IO Type, set to INPUT
        // 4th: DataType_ : Data Type, parsed from bracketedsymbol tags
        // 6th: SymAttr_  : Symbol Attributes, set as SymbolData
        // 7th: ElmType_  : Symbol Type, set as Symbol_Type
        // 8th: 0         : Match leading or trailing whitespaces, none
        // 9th: true      : Skip whitespaces, true
        // 10th: true     : Required and not optional, true
        // 11th: Csense_  : Case Sensitive, parsed from sequence tags
        // 12th: true     : Ordered Symbol Set, true
        //
        Bsymp_ = new BracketedSymbol(SymStr_, " \t\n\r",
                                     IoType_, DataType_,
                                     SymbolSet::SymbolData,
                                     ElmType_, 0, true,
                                     true, Csense_, true);

        Bsymp_->SetLeftBracket(NULL);
        Bsymp_->SetRightBracket(NULL);

        if (HasDelim_ &&
            (x < CntNum_ - 1 && CntNum_ > 1 ||
            RetSym_->GetEnclosing() && BrkLvl_))
        {
          Bsymp_->SetDelimiter(Delimp_, true);
          Delimp_->SetEnclosing(Bsymp_);
        }
        else
          Bsymp_->SetDelimiter(NULL);

        RetSym_->SetNext(Bsymp_, false);
        Bsymp_->SetEnclosing(RetSym_);
        
        RetSym_ = Bsymp_;
      }

      if (HasDelim_)
        delete Delimp_;

      Done_ = (BrkLvl_ == 0);      
    }
    else
    {
      if (RetSym_->GetDataType() == SymbolSet::NO_DATA)
      {
        RetSym_->SetSymbol(SymStr_);
        RetSym_->SetDataType(DataType_);
        RetSym_->SetCaseSensitive(Csense_);

        if (HasDelim_ && BrkLvl_)
        {
          RetSym_->SetDelimiter(Delimp_, false);
          Delimp_->SetEnclosing(RetSym_);
        }
        else
          RetSym_->SetDelimiter(NULL);
      }
      else
      {
        // Argument Summary:
        // 1st: SymStr_   : SymbolSet Characater, string if defined
        // 2nd: " \t\n\r" : Whitespace Characters, set to " \t\n\r"
        // 3rd: IoType_   : IO Type, set to INPUT
        // 4th: DataType_ : Data Type, parsed from bracketedsymbol tags
        // 6th: SymAttr_  : Symbol Attributes, set as SymbolData
        // 7th: ElmType_  : Symbol Type, set as Symbol_Type
        // 8th: 0         : Match leading or trailing whitespaces, none
        // 9th: true      : Skip whitespaces, true
        // 10th: true     : Required and not optional, true
        // 11th: Csense_  : Case Sensitive, parsed from sequence tags
        // 12th: true     : Ordered Symbol Set, true
        //      
        Bsymp_ = new BracketedSymbol(SymStr_, " \t\n\r",
                                     IoType_, DataType_,
                                     SymbolSet::SymbolData,
                                     ElmType_, 0, true,
                                     true, Csense_, true);

        Bsymp_->SetLeftBracket(NULL);
        Bsymp_->SetRightBracket(NULL);

        if (HasDelim_ && BrkLvl_)
        {
          Bsymp_->SetDelimiter(Delimp_, false);
          Delimp_->SetEnclosing(Bsymp_);
        }
        else
          Bsymp_->SetDelimiter(NULL);

        RetSym_->SetNext(Bsymp_);
        Bsymp_->SetEnclosing(RetSym_);
        
        RetSym_ = Bsymp_;
      }

      Done_ = (BrkLvl_ == 0);
    }
  }

  if (CallIter_ == 1)
  {
    Name_ = new_char_string(Args_[0]);
    RetSym_->SetName(Name_);
    ::DeleteArray(Name_);  
  }

  ::DeleteArray(Delim_);
  ::DeleteArray(SymStr_);
  
  return RetSym_;
}

/****************************************************************************/
// SymbolSet Class Definition
/****************************************************************************/
//   (symbol specific data)
//     name ccc:
//     symtype enum:
//     symattr enum:
//     datatype enum:
//     seqtype enum:
//     structtype enum:
//     decltype enum:
//     defntype enum:
//     optype enum:
//     opstate 0:
//     sestate 0:
//     brksymtype 0:
//     brksymstate 0:
//
SymbolSet::SymbolSet():
_IoType(INPUT),
_DataType(DEFINED),
_Slen(0),
_Sterm(' '),
_SymAttrib(0),
_SymType(0),
_RetCode(0),
_Wspace(0),
_Name(NULL),
_WspaceChar(NULL),
_RegExpr(NULL),
_Char(NULL),
_Transferred(false),
_SkipSpaces(false),
_Required(false),
_CaseSensitive(false),
_Ordered(false),
_ParseValid(false),
_ParseDone(false),
_SoloSymbol(true),
_HasSymData(false),
_IsRegExpr(false),
_ParseState(OPTIONAL | FRESH),
_Enclosing(NULL),
_TriggerState(OPTIONAL | FRESH),
_StateChangeState(OPTIONAL | FRESH),
_RecurTimes(0)
{
  _TriggerObj = NULL;
  _TriggerData = NULL;

  _StateChangeObj = NULL;
  _StateChangeData = NULL;

  CreateParserData();
  ParserData()->SetScope(ScopeInfo::ClassSCOPE);
}

/****************************************************************************/
SymbolSet::SymbolSet(const char* Str_, const char* WsChar_,
                     int IoType_, int DataType_,
                     int Attrib_, int Type_, int Ws_,
                     bool SkipSpaces_, bool Required_,
                     bool CaseSensitive_, bool Ordered_):
_IoType(IoType_),
_DataType(DataType_),
_Slen(0),
_Sterm(' '),
_SymAttrib(Attrib_),
_SymType(Type_),
_RetCode(0),
_Wspace(Ws_),
_Name(NULL),
_WspaceChar(new_char_string(WsChar_)),
_RegExpr(DataType_ == REGEXPR && Str_ ? new_char_string(Str_):NULL),
_Char(DataType_ != REGEXPR && Str_ ? new_char_string(Str_):NULL),
_Transferred(false),
_SkipSpaces(SkipSpaces_),
_Required(Required_),
_CaseSensitive(CaseSensitive_),
_Ordered(Ordered_),
_ParseValid(false),
_ParseDone(false),
_SoloSymbol(true),
_HasSymData(false),
_IsRegExpr(DataType_ == REGEXPR),
_ParseState(Required_ ? (NOT_OPTIONAL | FRESH):
                        (OPTIONAL | FRESH)),
_Enclosing(NULL),
_TriggerState(OPTIONAL | FRESH),
_StateChangeState(OPTIONAL | FRESH),
_RecurTimes(0)
{
  _TriggerObj = NULL;
  _TriggerData = NULL;

  _StateChangeObj = NULL;
  _StateChangeData = NULL;

  CreateParserData();
  ParserData()->SetScope(ScopeInfo::ClassSCOPE);  
}

/****************************************************************************/
SymbolSet::SymbolSet(SymbolSet* SymData_, const char* WsChar_,
                     int IoType_, int DataType_,
                     int Attrib_, int Type_, int Ws_,
                     bool SkipSpaces_, bool Required_,
                     bool CaseSensitive_, bool Ordered_):
_IoType(IoType_),
_DataType(DataType_),
_Slen(0),
_Sterm(' '),
_SymAttrib(Attrib_),
_SymType(Type_),
_RetCode(0),
_Wspace(Ws_),
_Name(NULL),
_WspaceChar(new_char_string(WsChar_)),
_RegExpr(DataType_ == REGEXPR && SymData_ ?
         new_char_string(SymData_->GetRegExpr()):NULL),
_SymData(SymData_ ? SymData_->Clone():NULL),
_Transferred(false),
_SkipSpaces(SkipSpaces_),
_Required(Required_),
_CaseSensitive(CaseSensitive_),
_Ordered(Ordered_),
_ParseValid(false),
_ParseDone(false),
_SoloSymbol(true),
_HasSymData(true),
_IsRegExpr(DataType_ == REGEXPR),
_ParseState(Required_ ? (NOT_OPTIONAL | FRESH):
                        (OPTIONAL | FRESH)),
_Enclosing(NULL),
_TriggerState(OPTIONAL | FRESH),
_StateChangeState(OPTIONAL | FRESH),
_RecurTimes(0)
{
  _TriggerObj = NULL;
  _TriggerData = NULL;

  _StateChangeObj = NULL;
  _StateChangeData = NULL;

  CreateParserData();
  ParserData()->SetScope(ScopeInfo::ClassSCOPE);  
}

/****************************************************************************/
SymbolSet::SymbolSet(const SymbolSet& Obj_):
_IoType(Obj_._IoType),
_DataType(Obj_._DataType),
_Slen(Obj_._Slen),
_Sterm(Obj_._Sterm),
_SymAttrib(Obj_._SymAttrib),
_SymType(Obj_._SymType),
_RetCode(0),
_Wspace(Obj_._Wspace),
_Name(new_char_string(Obj_._Name)),
_WspaceChar(new_char_string(Obj_._WspaceChar)),
_RegExpr(NULL),
_Char(NULL),
_Transferred(false),
_SkipSpaces(Obj_._SkipSpaces),
_Required(Obj_._Required),
_CaseSensitive(Obj_._CaseSensitive),
_Ordered(Obj_._Ordered),
_ParseValid(Obj_._ParseValid),
_ParseDone(Obj_._ParseDone),
_SoloSymbol(Obj_._SoloSymbol),
_HasSymData(Obj_._HasSymData),
_IsRegExpr(Obj_._IsRegExpr),
_ParseState(Obj_._ParseState),
_Enclosing(Obj_._Enclosing),
_TriggerState(Obj_._TriggerState),
_StateChangeState(Obj_._StateChangeState),
_RecurTimes(Obj_._RecurTimes)
{
  if (_HasSymData)
  {
    _SymData = Obj_._SymData ? Obj_._SymData->Clone():NULL;
    _IsRegExpr = _SymData ? (_SymData->_DataType == REGEXPR):false;
    _RegExpr = _IsRegExpr ?
               new_char_string(_SymData->GetRegExpr()):NULL;
  }
  else
  {
    _Char = (_DataType != REGEXPR && Obj_.GetSymbol(false)) ?
            new_char_string(Obj_.GetSymbol(false)):NULL;
    _IsRegExpr = _DataType == REGEXPR && Obj_.GetRegExpr();
    _RegExpr = _IsRegExpr ?
               new_char_string(Obj_.GetRegExpr()):NULL;
  }

  if ((_TriggerState & TRIGGER_OBJECT_SET) && Obj_._TriggerObj)
  {
    if (Obj_._TriggerObj->ShouldDelete())
      _TriggerObj = (ObjectFunctor*)(Obj_._TriggerObj->Clone());
    else
      _TriggerObj = Obj_._TriggerObj;
  }
  else if ((_TriggerState & TRIGGER_FUNCTION_SET) && Obj_._TriggerData)
  {
    _TriggerData = new TriggerFncData();        
    *_TriggerData = *Obj_._TriggerData;
  }

  if ((_StateChangeState & STATECHANGE_OBJECT_SET) && Obj_._StateChangeObj)
  {
    if (Obj_._StateChangeObj->ShouldDelete())
      _StateChangeObj = (ObjectFunctor*)(Obj_._StateChangeObj->Clone());
    else
      _StateChangeObj = Obj_._StateChangeObj;
  }
  else if ((_StateChangeState & STATECHANGE_FUNCTION_SET) && Obj_._StateChangeData)
  {
    _StateChangeData = new StateChangeFncData();
    *_StateChangeData = *Obj_._StateChangeData;
  }  

  CreateParserData();
  ParserData()->SetScope(ScopeInfo::ClassSCOPE);
}

/****************************************************************************/
SymbolSet::~SymbolSet()
{
  if (_HasSymData)
  {
    if (!_Transferred)  
      delete _SymData;
  }
  else
  {
    if (!_Transferred)
      ::DeleteArray(_Char);
  }

  ::DeleteArray(_Name);
  ::DeleteArray(_WspaceChar);
  ::DeleteArray(_RegExpr);
  _Char =
  _Name =
  _WspaceChar =
  _RegExpr = NULL;
  _Enclosing = NULL;
  
  DestroyParserData();
  ParserData()->SetScope(ScopeInfo::ClassSCOPE);
  int Max_, x;

  if (_StateChangeData && _StateChangeData->_DesArgs)
  {
    Max_ = _StateChangeData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_StateChangeData->_FncArgv[x]);

    ::DeleteArray(_StateChangeData->_FncArgv);
  }    

  if (_TriggerData && _TriggerData->_DesArgs)
  {
    Max_ = _TriggerData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_TriggerData->_FncArgv[x]);

    ::DeleteArray(_TriggerData->_FncArgv);
  }  

  delete _TriggerData;
  if (_TriggerObj && _TriggerObj->ShouldDelete())
    delete _TriggerObj;

  delete _StateChangeData;
  if (_StateChangeObj && _StateChangeObj->ShouldDelete())
    delete _StateChangeObj;
}

/****************************************************************************/
bool SymbolSet::SymTransferred() const
{
  return _Transferred;
}

/****************************************************************************/
SymbolSet* SymbolSet::Clone() const
{
  SymbolSet* Retval_ = new SymbolSet(*this);
  return Retval_;
}

/****************************************************************************/
SymbolSet& SymbolSet::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {  
    _IoType = Obj_._IoType;
    _DataType = Obj_._DataType;
    _Slen = Obj_._Slen;
    _Sterm = Obj_._Sterm;
    _SymAttrib = Obj_._SymAttrib;
    _SymType = Obj_._SymType;
    _RetCode = 0;
    _Wspace = Obj_._Wspace;
    _SkipSpaces = Obj_._SkipSpaces;
    _Required = Obj_._Required;
    _CaseSensitive = Obj_._CaseSensitive;
    _Ordered = Obj_._Ordered;
    _ParseValid = Obj_._ParseValid;
    _ParseDone = Obj_._ParseDone;
    _SoloSymbol = Obj_._SoloSymbol;
    _IsRegExpr = Obj_._IsRegExpr;
    _ParseState = Obj_._ParseState;
    _Enclosing = Obj_._Enclosing;
    _TriggerState = Obj_._TriggerState;
    _StateChangeState = Obj_._StateChangeState;
    _RecurTimes = Obj_._RecurTimes;

    if (_Name != Obj_._Name)
      ::DeleteArray(_Name);

    if (_WspaceChar != Obj_._WspaceChar)
      ::DeleteArray(_WspaceChar);

    _Name = new_char_string(Obj_._Name);
    _WspaceChar = new_char_string(Obj_._WspaceChar);

    if (_HasSymData)
    {
      if (_SymData != Obj_._SymData && !_Transferred)
        delete _SymData;
    }
    else
    {
      if (_Char != Obj_._Char && !_Transferred)
        ::DeleteArray(_Char);
    }

    _HasSymData = Obj_._HasSymData;
    
    if (_HasSymData)
    {
      _SymData = Obj_._SymData ? Obj_._SymData->Clone():NULL;
      _IsRegExpr = _SymData ? (_SymData->_DataType == REGEXPR):false;
      _RegExpr = _IsRegExpr ?
                 new_char_string(_SymData->GetRegExpr()):NULL;
    }
    else
    {
      _Char = (_DataType != REGEXPR && Obj_.GetSymbol(false)) ?
              new_char_string(Obj_.GetSymbol(false)):NULL;
      _IsRegExpr = _DataType == REGEXPR && Obj_.GetRegExpr();
      _RegExpr = _IsRegExpr ?
                 new_char_string(Obj_.GetRegExpr()):NULL;                 
    }      

    if ((_TriggerState & TRIGGER_OBJECT_SET) && Obj_._TriggerObj)
    {
      if (Obj_._TriggerObj->ShouldDelete())
        _TriggerObj = (ObjectFunctor*)(Obj_._TriggerObj->Clone());
      else
        _TriggerObj = Obj_._TriggerObj;
    }
    else if ((_TriggerState & TRIGGER_FUNCTION_SET) && Obj_._TriggerData)
    {
      if (!_TriggerData)
        _TriggerData = new TriggerFncData();
        
      *_TriggerData = *Obj_._TriggerData;    
    }

    if ((_StateChangeState & STATECHANGE_OBJECT_SET) && Obj_._StateChangeObj)
    {
      if (Obj_._StateChangeObj->ShouldDelete())
        _StateChangeObj = (ObjectFunctor*)(Obj_._StateChangeObj->Clone());
      else
        _StateChangeObj = Obj_._StateChangeObj;
    }
    else if ((_StateChangeState & STATECHANGE_FUNCTION_SET) && Obj_._StateChangeData)
    {
      if (!_StateChangeData)
        _StateChangeData = new StateChangeFncData();
        
      *_StateChangeData = *Obj_._StateChangeData;
    }

    _Transferred = false;
  }

  return *this;
}

/****************************************************************************/
bool SymbolSet::ChangeState(SymbolSet* Operator_, int OperandNum_, int State_, char* RetStr_)
{
  _StateChangeState &= ~FRESH;
  _StateChangeState |= STARTED;

  if (_ParseDone)
  {
    if (_StateChangeObj && (_StateChangeState & STATECHANGE_OBJECT_SET))
      ExecStateChangeObject(Operator_, OperandNum_, State_);
    else if (_StateChangeData && (_StateChangeState & STATECHANGE_FUNCTION_SET))
    {
      if (_StateChangeData->_FncArgr)
        strcpy(_StateChangeData->_FncArgv[_StateChangeData->_FncArgc-1], RetStr_);
    
      ExecStateChangeFunction(Operator_, OperandNum_, State_);
    }

    _StateChangeState |= STATECHANGE_DONE;
    _StateChangeState &= ~STATECHANGE_FAIL;
  }
  else
  {
    _StateChangeState |= STATECHANGE_FAIL;  
    _StateChangeState &= ~STATECHANGE_DONE;
  }

  return false;
}

/****************************************************************************/
int SymbolSet::ExecStateChangeObject(SymbolSet* Operator_, int OperandNum_, int State_)
{
  (*_StateChangeObj)();
}

/****************************************************************************/
SymbolSet::TriggerFncData* SymbolSet::GiveTriggerFncData()
{
  return (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET)) ?
             _TriggerData:NULL;
}

/****************************************************************************/
SymbolSet::StateChangeFncData* SymbolSet::GiveStateChangeFncData()
{
  return (_StateChangeData && (_StateChangeState & STATECHANGE_FUNCTION_SET)) ?
             _StateChangeData:NULL;
}

/****************************************************************************/
ObjectFunctor* SymbolSet::GiveTriggerObject()
{
  return (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET)) ?
             _TriggerObj:NULL;
}

/****************************************************************************/
ObjectFunctor* SymbolSet::GiveStateChangeObject()
{
  return (_StateChangeObj && (_StateChangeState & STATECHANGE_OBJECT_SET)) ?
             _StateChangeObj:NULL;
}

/****************************************************************************/
int SymbolSet::ExecStateChangeFunction(SymbolSet* Operator_, int OperandNum_, int State_)
{
  if (_StateChangeData->_StateChangeFnc)
    return (*_StateChangeData->_StateChangeFnc)
             (_StateChangeData->_FncArgc,
              _StateChangeData->_FncArgv,
              _StateChangeData->_FncArgi);

  return 0;
}

/****************************************************************************/
int SymbolSet::ExecTriggerFunction()
{
  if (_TriggerData->_TriggerFnc)
    return (*_TriggerData->_TriggerFnc)
             (_TriggerData->_FncArgc,
              _TriggerData->_FncArgv,
              _TriggerData->_FncArgi);

  return 0;
}

/****************************************************************************/
SymbolSet& SymbolSet::ClearStateChangeData()
{
  if (!_StateChangeData)
  {
    _StateChangeData = new StateChangeFncData();
    _StateChangeData->_DesArgs = false;
  }

  if (_StateChangeData->_DesArgs)
  {
    int Max_, x;
    Max_ = _StateChangeData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_StateChangeData->_FncArgv[x]);

    ::DeleteArray(_StateChangeData->_FncArgv);
  }    

  _StateChangeData->_StateChangeFnc = NULL;
  _StateChangeData->_FncArgc = 0;
  _StateChangeData->_FncArgv = NULL;
  _StateChangeData->_FncArgi = NULL;
  _StateChangeData->_FncArgr = false;
  _StateChangeData->_FncArgx = false;
  _StateChangeData->_DesArgs = false;

  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::ClearTriggerData()
{
  if (!_TriggerData)
  {
    _TriggerData = new TriggerFncData();
    _TriggerData->_DesArgs = false;
  }

  if (_TriggerData->_DesArgs)
  {
    int Max_, x;
    Max_ = _TriggerData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_TriggerData->_FncArgv[x]);

    ::DeleteArray(_TriggerData->_FncArgv);
  }

  _TriggerData->_TriggerFnc = NULL;
  _TriggerData->_FncArgc = 0;
  _TriggerData->_FncArgv = NULL;
  _TriggerData->_FncArgi = NULL;
  _TriggerData->_FncArgr = false;
  _TriggerData->_FncArgx = false;
  _TriggerData->_DesArgs = false;

  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStateChangeObject(ObjectFunctor* Obj_)
{
  _StateChangeState &= ~OPTIONAL;
  _StateChangeState &= ~STATECHANGE_FUNCTION_SET;
  _StateChangeState |= STATECHANGE_OBJECT_SET;

  _StateChangeObj = Obj_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStateChangeFunction(int(*Fnc_)(int, char**, void*),
                                             int FncArgc_, char** FncArgv_,
                                             bool ResultArg_, bool BranchArg_,
                                             void* FncArgi_)
{
  if (!_StateChangeData)
  {
    _StateChangeData = new StateChangeFncData();
    _StateChangeData->_DesArgs = false;
    _StateChangeData->_FncArgv = NULL;
  }

  _StateChangeState &= ~OPTIONAL;
  _StateChangeState &= ~STATECHANGE_OBJECT_SET;
  _StateChangeState |= STATECHANGE_FUNCTION_SET;

  if (Fnc_)
    _StateChangeData->_StateChangeFnc = Fnc_;

  int Max_, x;
  int Extra_ = 0;
  bool DesArgv_ = _StateChangeData->_DesArgs;

  // Include result string as an argument, add 1 extra to arg count  
  if (ResultArg_)
    ++Extra_;

  // Include result string as an argument, add 1 extra to arg count    
  if (BranchArg_)
    ++Extra_;

  if (!FncArgv_)
  {
    Max_ = FncArgc_ + Extra_;
    FncArgv_ = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * Max_);

    for (x = 0; x < Max_; x++)
      FncArgv_[x] = new_char_string("12345678901234567890");

    DesArgv_ = true;
  }
  else if (FncArgv_ != _StateChangeData->_FncArgv)
    DesArgv_ = false;

  if (_StateChangeData->_DesArgs && FncArgv_ != _StateChangeData->_FncArgv)
  {
    Max_ = _StateChangeData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_StateChangeData->_FncArgv[x]);

    ::DeleteArray(_StateChangeData->_FncArgv);
  }    

  // Total argument count is the original passed in count + extras:
  // (branch number and result string)
  _StateChangeData->_FncArgc = FncArgc_ + Extra_;
  _StateChangeData->_FncArgv = FncArgv_;
  _StateChangeData->_FncArgr = ResultArg_;
  _StateChangeData->_FncArgx = BranchArg_;

  // void* argument included for increased flexibility
  _StateChangeData->_FncArgi = FncArgi_;

  // indicate whether argument data array should be destroyed
  _StateChangeData->_DesArgs = DesArgv_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetTriggerObject(ObjectFunctor* Obj_)
{
  _TriggerState &= ~OPTIONAL;
  _TriggerState &= ~TRIGGER_FUNCTION_SET;
  _TriggerState |= TRIGGER_OBJECT_SET;

  _TriggerObj = Obj_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetTriggerFunction(int(*Fnc_)(int, char**, void*),
                                         int FncArgc_, char** FncArgv_,
                                         bool ResultArg_, bool BranchArg_,
                                         void* FncArgi_)
{
  if (!_TriggerData)
  {
    _TriggerData = new TriggerFncData();
    _TriggerData->_DesArgs = false;
    _TriggerData->_FncArgv = NULL;
  }

  _TriggerState &= ~OPTIONAL;
  _TriggerState &= ~TRIGGER_OBJECT_SET;
  _TriggerState |= TRIGGER_FUNCTION_SET;

  if (Fnc_)
    _TriggerData->_TriggerFnc = Fnc_;

  int Max_, x;
  int Extra_ = 0;
  bool DesArgv_ = _TriggerData->_DesArgs;

  // Include result string as an argument, add 1 extra to arg count
  if (ResultArg_)
    ++Extra_;

  // Include branch number as an argument, add 1 extra to arg count
  if (BranchArg_)
    ++Extra_;

  if (!FncArgv_)
  {
    Max_ = FncArgc_ + Extra_;
    FncArgv_ = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * Max_);

    for (x = 0; x < Max_; x++)
      FncArgv_[x] = new_char_string("12345678901234567890");

    DesArgv_ = true;
  }
  else if (FncArgv_ != _TriggerData->_FncArgv)
    DesArgv_ = false;

  if (_TriggerData->_DesArgs && FncArgv_ != _TriggerData->_FncArgv)
  {
    Max_ = _TriggerData->_FncArgc;
    for (x = 0; x < Max_; x++)
      ::DeleteArray(_TriggerData->_FncArgv[x]);

    ::DeleteArray(_TriggerData->_FncArgv);
  }

  // Total argument count is the original passed in count + extras:
  // (branch number and result string)    
  _TriggerData->_FncArgc = FncArgc_ + Extra_;
  _TriggerData->_FncArgv = FncArgv_;
  _TriggerData->_FncArgr = ResultArg_;
  _TriggerData->_FncArgx = BranchArg_;

  // void* argument included for increased flexibility  
  _TriggerData->_FncArgi = FncArgi_;

  // indicate whether argument data array should be destroyed  
  _TriggerData->_DesArgs = DesArgv_;
  return *this;
}

/****************************************************************************/
void SymbolSet::Reset()
{
  _ParseValid = false;
  _ParseDone = false;
  _ParseState = _Required ? (NOT_OPTIONAL | FRESH):
                            (OPTIONAL | FRESH);

  if (_StateChangeObj && (_StateChangeState & STATECHANGE_OBJECT_SET))
    _StateChangeState = NOT_OPTIONAL | FRESH | STATECHANGE_OBJECT_SET;
  else if (_StateChangeData && (_StateChangeState & STATECHANGE_FUNCTION_SET))
    _StateChangeState = NOT_OPTIONAL | FRESH | STATECHANGE_FUNCTION_SET;
  else
    _StateChangeState = OPTIONAL | FRESH;

  if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
    _TriggerState = NOT_OPTIONAL | FRESH | TRIGGER_OBJECT_SET;
  else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
    _TriggerState = NOT_OPTIONAL | FRESH | TRIGGER_FUNCTION_SET;
  else
    _TriggerState = OPTIONAL | FRESH;    
}

/****************************************************************************/
int SymbolSet::DecPoints(double Val_, int Pts_)
{
  int x;
  long Dval_ = (long)Val_;
  
  for (x = 0; Dval_; x++)
    Dval_ /= 10;

  Pts_ += x;
  return Pts_;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetEnclosing(SymbolSet* Enclosing_)
{
  _Enclosing = Enclosing_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetName(const char* Name_)
{
  if (Name_ != _Name)
  {
    ::DeleteArray(_Name);
    _Name = NULL;
  }

  _Name = new_char_string(Name_);
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSymbol(const char* NewSymbol_)
{
  if (NewSymbol_)
  {
    if (NewSymbol_ != _Char && !_Transferred)
      if (_HasSymData)
        delete _SymData;
      else
        ::DeleteArray(_Char);
      
    _Char = new_char_string(NewSymbol_);
    _Transferred = false;
    _HasSymData = false;
  }
  else if (_HasSymData)
  {
    if (!_Transferred)  
      delete _SymData;
      
    _SymData = NULL;  
  }
  else
  {
    if (!_Transferred)
      ::DeleteArray(_Char);
  
    _Char = NULL;  
  }

  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetRegExpr(const char* NewSymbol_)
{
  SetSymbol(NewSymbol_);
  _IsRegExpr = true;
  _DataType = REGEXPR;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSymbolSet(SymbolSet* NewSymbol_, bool Overwrite_)
{
  if (NewSymbol_)
  {
    if (NewSymbol_ != _SymData && !_Transferred)
      if (_HasSymData)
        delete _SymData;
      else
        ::DeleteArray(_Char);
    
    _SymData = Overwrite_ ? NewSymbol_->Clone():NewSymbol_;
    _Transferred = Overwrite_ ? false:NewSymbol_->SymTransferred();
    _HasSymData = true;
  }
  else if (_HasSymData)
  {
    if (!_Transferred)  
      delete _SymData;
      
    _SymData = NULL;
  }
  else
  {
    if (!_Transferred)
      ::DeleteArray(_Char);
  
    _Char = NULL;
  }

  return *this;
}

/****************************************************************************/
char* SymbolSet::GetSymbol(bool Transfer_) const
{
  if (!_HasSymData)
  {
    _Transferred = Transfer_;
    return _Char;
  }

  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::GetSymbolSet(bool Transfer_) const
{
  if (_HasSymData)
  {
    _Transferred = Transfer_;
    return _SymData;
  }

  return NULL;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetWspaceChar(const char* WsChar_)
{
  if (_WspaceChar != WsChar_)
  {
    ::DeleteArray(_WspaceChar);
    _WspaceChar = NULL;
  }

  _WspaceChar = new_char_string(WsChar_);
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::RemoveWhiteSpace(const char* Wspace_)
{
  char* Temp_ = _WspaceChar;
  size_t len = ::SafeStrLen(Temp_);

  if (len && Wspace_ && strlen(Wspace_))
  {
    char* Pos_ = strstr(Temp_, Wspace_);
    char* Next_ = Pos_ ? (Pos_ + strlen(Wspace_)):NULL;
    
    if (Pos_)
      if (*Next_)
        memmove(Pos_, Next_, strlen(Next_)+1);
      else
        *Pos_ = 0;
  }

  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::AppendWhiteSpace(const char* WsChar_)
{
  char* Temp_ = _WspaceChar;
  size_t len = ::SafeStrLen(Temp_);
  bool HasWs_;
  int WsLen_;

  if (len && WsChar_ && strstr(Temp_, WsChar_) != NULL)
    return *this;

  HasWs_ = WsChar_ ? (strstr(WsChar_, " \t\r\n") != NULL ||
                     (len && strstr(Temp_, " \t\n\r") != NULL)):
           Temp_ ? (len && strstr(Temp_, " \t\n\r") != NULL):false;
  WsLen_ = HasWs_ ? 1:5;

  if (_WspaceChar != WsChar_)
    if (WsChar_ || !HasWs_)
    {
      ::DeleteArray(_WspaceChar);
      _WspaceChar = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (len+strlen(WsChar_)+WsLen_));
      *_WspaceChar = 0;

      if (len)
        strcpy(_WspaceChar, Temp_);

      if (WsChar_)
        strcat(_WspaceChar, WsChar_);

      if (!HasWs_)
        strcat(_WspaceChar, " \t\n\r");
    }
  
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetWspace(int Ws_)
{
  _Wspace = Ws_;
  return *this;
}

/****************************************************************************/
SymbolBaseData* SymbolSet::ConvertToBaseData(SymbolBaseData* SymData_)
{
  char* CharData_ = _HasSymData ?
                      (_SymData ? _SymData->GetSymbol(false):NULL):_Char;

  if (!CharData_)
    return SymData_;

  char* ucv_;

  if (_DataType == DEFINED ||
      _DataType == ICASEDEFINED ||
      _DataType == REGEXPR ||
      _DataType == STRING)
    SymData_->StrValue = CharData_;
  else if (_DataType == CHAR ||
           _DataType == (SIGNED|CHAR))
    SymData_->CharValue = CharData_[0];
  else if (_DataType == (UNSIGNED|CHAR))
    SymData_->UcharValue = Uchar(CharData_[0]);
  else if (_DataType == INT ||
           _DataType == (SIGNED|INT))
    SymData_->IntValue = strtol(CharData_, &ucv_, 0);
  else if (_DataType == (UNSIGNED|INT))
    SymData_->UintValue = strtoul(CharData_, &ucv_, 0);
  else if (_DataType == FLOAT)
    SymData_->FloatValue = strtod(CharData_, &ucv_);
  else if (_DataType == DOUBLE)
    SymData_->DoubleValue = strtod(CharData_, &ucv_);
  else if (_DataType == LONGDOUBLE)
    SymData_->LdoubleValue = _strtold(CharData_, &ucv_);

  return SymData_;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetRetCode(int RetCode_)
{
  _RetCode = RetCode_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSymbolAttrib(int Attrib_)
{
  _SymAttrib = Attrib_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSymbolType(int Type_)
{
  _SymType = Type_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetRequired(bool Req_)
{
  _Required = Req_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetCaseSensitive(bool Sensitive_)
{
  _CaseSensitive = Sensitive_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSkipSpaces(bool Skip_)
{
  _SkipSpaces = Skip_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSoloSymbol(bool Val_)
{
  _SoloSymbol = Val_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStructType(int StructType_)
{
  return *this;
}

/****************************************************************************/
int SymbolSet::GetStructType() const
{
  return 0;
}

/****************************************************************************/
const char* SymbolSet::GetSeparatorString() const
{
  return NULL;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSeparatorString(const char* SepChar_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::ClearSeparatorString()
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetIoType(int ioType_)
{
  _IoType = ioType_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetDataType(int dataType_)
{
  _DataType = dataType_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStringLength(int Length_)
{
  _Slen = Length_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStringTerminator(int Term_)
{
  _Sterm = Term_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetRecurTimes(int Recur_)
{
  _RecurTimes = Recur_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOrdered(bool Ordered_)
{
  _Ordered = Ordered_;
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetNext(SymbolSet* Set_, bool SeqTerm_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetCircSeqTerm(SymbolSet* Set_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::UnlinkSeqTerm(SymbolSet* Set_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetCircSeqWrap(SymbolSet* Set_)
{
  return *this;
}

/****************************************************************************/
bool SymbolSet::IsErrorSet() const
{
  return false;
}

/****************************************************************************/
SymbolSet& SymbolSet::ResetErrorFlag()
{
  return *this;
}

/****************************************************************************/
int SymbolSet::BranchNum() const
{
  return 0;
}

/****************************************************************************/
bool SymbolSet::BranchFound() const
{
  return false;
}

/****************************************************************************/
bool SymbolSet::SepTransferred() const
{
  return true;
}

/****************************************************************************/
bool SymbolSet::OpTransferred(int Index_) const
{
  return true;
}

/****************************************************************************/
bool SymbolSet::BrkSymTransferred(int Index_) const
{
  return true;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSeparator(SymbolSet* Delim_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetAssignment(SymbolSet* Assign_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet* SymbolSet::Separator(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::Assignment(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::Operand1(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::Operand2(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::Operand3(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::Resultant(bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetDelimiter(SymbolSet* Delim_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet* SymbolSet::NextSymbol(int Index_, bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::NextDelimiter(int Index_, bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::NextLeftBracket(int Index_, bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
SymbolSet* SymbolSet::NextRightBracket(int Index_, bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
int SymbolSet::Length() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetIndex() const
{
  return 0;
}

/****************************************************************************/
bool SymbolSet::HasSymbol(const SymbolSet* SymPtr_, bool NoChain_)
{
  return (this == SymPtr_);
}

/****************************************************************************/
int SymbolSet::AggregateType() const
{
  return 0;
}

/****************************************************************************/    
SymbolSet& SymbolSet::SetNestingSymbol(int Index_, SymbolSet* SymPtr_)
{
  return *this;
}

/****************************************************************************/    
SymbolSet& SymbolSet::SetAggsState(int EnumIndex_)
{
  return *this;
}

/****************************************************************************/    
SymbolSet& SymbolSet::SetAggsRequired()
{
  return *this;
}

/****************************************************************************/    
SymbolSet* SymbolSet::SetAggs(int EnumIndex_, int NestLevel_,
                              SymbolSet* Sym_, bool Overwrite_)
{
  return NULL;
}

/****************************************************************************/                                     
int SymbolSet::GetAggsState() const
{
  return 0;
}

/****************************************************************************/    
int SymbolSet::GetAggsRequired() const
{
  return 0;
}

/****************************************************************************/                               
SymbolSet* SymbolSet::GetAggs(int EnumIndex_, int NestLevel_,
                              bool Transfer_)
{
  return NULL;
}

/****************************************************************************/
bool SymbolSet::AggsTransferred(int Index_) const
{
  return false;
}

/****************************************************************************/    
bool SymbolSet::HasAggs(int EnumIndex_)
{
  return false;
}

/****************************************************************************/
bool SymbolSet::IsSingleChain(bool& EndSeq_) const
{
  EndSeq_ = false;
  return false;
}

/****************************************************************************/
bool SymbolSet::GetOrBranchOut() const
{
  return false;
}

/****************************************************************************/
bool SymbolSet::GetCdeChkBlock() const
{
  return false;
}

/****************************************************************************/
int SymbolSet::GetSequenceType() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetDeclType() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetDefnType() const
{
  return 0;
}

/****************************************************************************/
bool SymbolSet::CheckForCde()
{
  return false;
}

/****************************************************************************/
SymbolSet& SymbolSet::HaltOnCircSeqEnd()
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::ConvertToCircSeq()
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetCircDefLimitValue(int Limit_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::ResetCdefLimit()
{
  return *this;
}

/****************************************************************************/
bool SymbolSet::CdefExists() const
{
  return false;
}

/****************************************************************************/
int SymbolSet::CdefLimit() const
{
  return 0;
}

/****************************************************************************/
SymbolSet& SymbolSet::CheckForCdeBlock()
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOrBranchOut(bool Branch_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetCdeChkBlock(bool Block_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetSequenceType(int Type_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetDeclType(int Type_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetDefnType(int Type_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOperand1(SymbolSet* Operand_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOperand2(SymbolSet* Operand_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOperand3(SymbolSet* Operand_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetResultant(SymbolSet* Result_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
int SymbolSet::GetOperatorState() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetOperatorRequired() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetOperatorType() const
{
  return 0;
}

/****************************************************************************/
int SymbolSet::GetResultOrder() const
{
  return 0;
}

/****************************************************************************/
int* SymbolSet::GetResultantState()
{
  return NULL;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetOperatorType(int Type_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetResultOrder(int Order_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetStartDelim(const char* Start_, bool Cs_, bool Ord_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetEndDelim(const char* End_, bool Cs_, bool Ord_)
{
  return *this;
}

/****************************************************************************/
char* SymbolSet::GetStartDelim() const
{
  return NULL;
}

/****************************************************************************/
char* SymbolSet::GetEndDelim() const
{
  return NULL;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetLeftBracket(SymbolSet* Left_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetRightBracket(SymbolSet* Right_, bool Overwrite_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::IncBlockCount(int Val_)
{
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::IncFunctionCount(int Val_)
{
  return *this;
}

/****************************************************************************/
bool SymbolSet::HasLeftBracket() const
{
  return false;
}

/****************************************************************************/
bool SymbolSet::HasDelimiter() const
{
  return false;
}

/****************************************************************************/
bool SymbolSet::HasNext() const
{
  return false;
}

/****************************************************************************/
bool SymbolSet::HasRightBracket() const
{
  return false;
}

/****************************************************************************/
int SymbolSet::GetBrkSymRequired() const
{
  return
  (
    NO_LEFTBRK_REQ |
    NO_RIGHTBRK_REQ |
    NO_SYMDELIM_REQ |
    NO_NEXTSYM_REQ
  );  
}

/****************************************************************************/
int SymbolSet::GetBrkSymState() const
{
  return NO_BRKSYM_DONE;
}

/****************************************************************************/
bool SymbolSet::IsSequence(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsSequence(FollowEnclosing_);
    
  return false;
}

/****************************************************************************/
bool SymbolSet::IsBranchOut(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsBranchOut(FollowEnclosing_);

  return false;
}

/****************************************************************************/
bool SymbolSet::IsOperatorSet(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsOperatorSet(FollowEnclosing_);

  return false;
}

/****************************************************************************/
bool SymbolSet::IsBracketedSymbol(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsBracketedSymbol(FollowEnclosing_);

  return false;
}

/****************************************************************************/
bool SymbolSet::IsAggregateSymbol(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsAggregateSymbol(FollowEnclosing_);

  return false;
}

/****************************************************************************/
bool SymbolSet::IsParseValid() const
{
  return _ParseValid;
}

/****************************************************************************/
bool SymbolSet::IsParseDone() const
{
  return _ParseDone;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetGroupValid(bool Valid_)
{
  SetParseValid(Valid_);
  return *this;
}

/****************************************************************************/
SymbolSet& SymbolSet::SetGroupDone(bool Done_)
{
  SetParseDone(Done_);
  return *this;
}

/****************************************************************************/
bool SymbolSet::IsGroupValid() const
{
  return IsParseValid();
}

/****************************************************************************/
bool SymbolSet::IsGroupDone() const
{
  return IsParseDone();
}

/****************************************************************************/
SymbolSet& SymbolSet::SetParseValid(bool Valid_)
{
  _ParseValid = Valid_;

  if (!_Required)
    _ParseState |= OPTION_VALID;
  
  return *this;  
}

/****************************************************************************/
SymbolSet& SymbolSet::SetParseDone(bool Done_)
{
  _ParseDone = Done_;

  if (_ParseDone)
  {
    _ParseState |= PARSE_DONE;
    _ParseState &= ~PARSE_FAIL;
  }
  else
  {
    _ParseState &= ~PARSE_DONE;
    _ParseState |= PARSE_FAIL;
  }
  
  return *this;
}

/****************************************************************************/
char* SymbolSet::ParseSymbolStep(char* Text_, bool& Done_)
{
  Done_ = true;
  return ParseSymbol(Text_);
}

/****************************************************************************/
char* SymbolSet::ParseSymbol(char* Text_)
{
  if (!Text_)
    return Text_;

  _ParseValid = false;
  _ParseState &= ~FRESH;
  _ParseState |= STARTED;
  int x, Max_;
  char* Saved_ = NULL;
  Regexpr RexprLook_;  
  char* CharData_ = _HasSymData ?
                      (_SymData ? _SymData->GetSymbol(false):NULL):_Char;

  if (_RecurTimes < 0)
    Max_ = INT_MAX;
  else
    Max_ = _RecurTimes ? _RecurTimes:1;
  
  for (x = 0; x < Max_ && (x == 0 || _ParseValid); x++)
  {  
    if (_IoType == INPUT)
    {
      if (CharData_ && !(_DataType == DEFINED ||
                         _DataType == ICASEDEFINED))
      {
        // For repeated parse of SymbolData as indicated
        // by the recur times argument specified in the tag.      
        if (x > 0)
        {
          if (CharData_)
          {
            if (Saved_)
              ::DeleteArray(Saved_);

            Saved_ = CharData_;            
          }
          
          CharData_ = NULL;
          _ParseValid = false;
        }
        else
        {
          ::DeleteArray(CharData_);
          CharData_ = NULL;
        }
      }

      if (_Wspace == NoPaddingSpaces)
      {
        if (_SkipSpaces && isspace(*Text_))
        {
          if (_WspaceChar)
            Text_ += strspn(Text_, _WspaceChar);
          else
            Text_ += strspn(Text_, " \t\n\r");
        }
      }
      else if (_Wspace == MatchLeadingSpaces)
      {
        if (!isspace(*Text_))
        {
          _ParseValid = false;
          continue;
        }
        else if (isspace(*Text_))
        {
          if (_WspaceChar)
            Text_ += strspn(Text_, _WspaceChar);
          else
            Text_ += strspn(Text_, " \t\n\r");
        }
      }
  
      if (_DataType == STRING && Max_ == 1)
      {
        if (_Slen)
        {
          CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_Slen+1));
          strncpy(CharData_, Text_, _Slen);
          CharData_[_Slen] = 0;
          Text_ += _Slen;
          _ParseValid = true;
        }
        else
        {
          int x;
          char Buf_[3];
          Buf_[0] = _Sterm;
          Buf_[1] = 0;
        
          if (_Sterm == ' ' || isspace(_Sterm))
          {
            if (GetSeparatorString())
              x = strcspn(Text_, GetSeparatorString());
            else
            {          
              if (_WspaceChar)
                x = strcspn(Text_, _WspaceChar);
              else
                x = strcspn(Text_, " \t\n\r");
            }
          }
          else
            x = strcspn(Text_, Buf_);

          CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (x+1));
          strncpy(CharData_, Text_, x);
          CharData_[x] = 0;
          Text_ += x;
          _ParseValid = true;
        }
      }
      else if (_DataType == REGEXPR && _RegExpr && *_RegExpr)
      {
        const char* s = "";
        const char* e = "";
        const char* LinePtr_ = NULL;

        RexprLook_.set_pattern(_RegExpr);
        RexprLook_.set_line(Text_);
        LinePtr_ = RexprLook_.get_line();
        RexprLook_.find_first(&s, &e);

        // start of matching regexpr should also be at
        // the start of the input text line
        if (s == LinePtr_)
        {
          int len = e - LinePtr_ + 1;
          CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (len+1));
          strncpy(CharData_, LinePtr_, len);
          CharData_[len] = 0;
        }        
      }
      else if (_DataType == DEFINED && _CaseSensitive)
      {
        _Slen = ::SafeStrLen(CharData_);

        if (_Ordered)
        {
          if (strncmp(CharData_, Text_, _Slen) == 0)
          {
            Text_ += _Slen;
            _ParseValid = true;
          }
        }
        else if (_Slen)
        {
          char* Test_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_Slen+1));
          strncpy(Test_, Text_, _Slen);
          Test_[_Slen] = 0;
          int x = strspn(Test_, CharData_);
        
          if (!Test_[x])
          {
            Text_ += _Slen;
            _ParseValid = true;
          }

          ::DeleteArray(Test_);
          Test_ = NULL;
        }
      }
      else if (_DataType == ICASEDEFINED ||
                (_DataType == DEFINED && !_CaseSensitive))
      {
        _Slen = ::SafeStrLen(CharData_);

        if (_Ordered)
        {
          if (StrniComp(CharData_, Text_, _Slen) == 0)
          {
            strncpy(CharData_, Text_, _Slen);
            CharData_[_Slen] = 0;
        
            Text_ += _Slen;
            _ParseValid = true;
          }
        }
        else if (_Slen)
        {
          int x;
          char* Test1_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_Slen+1));
          char* Test2_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_Slen+1));

          strncpy(Test1_, Text_, _Slen);
          Test1_[_Slen] = 0;
          strncpy(Test2_, CharData_, _Slen);
          Test2_[_Slen] = 0;
                
          for (x = 0; x < _Slen; x++)
          {
            Test1_[x] = tolower(Test1_[x]);
            Test2_[x] = tolower(Test2_[x]);
          }
        
          x = strspn(Test1_, Test2_);
      
          if (!Test1_[x])
          {
            CharData_[_Slen] = 0;
            Text_ += _Slen;
            _ParseValid = true;
          }

          ::DeleteArray(Test1_);
          ::DeleteArray(Test2_);
          Test1_ = Test2_ = NULL;
        }
      }
      else
      {
        int pdif;
        char* newbptr;
        char* ucv_;
          
        if (_DataType == FLOAT)
        {
          newbptr = ExtractFloat(Text_, pdif);

          if (newbptr)
          {
            float fval_;
            errno = 0;
            fval_ = strtod(newbptr, &ucv_);

            if (errno != ERANGE)
            {
              Text_ += pdif;
              _ParseValid = true;
              CharData_ = newbptr;
            }
          }
        }
        else if (_DataType == DOUBLE)
        {
          newbptr = ExtractFloat(Text_, pdif);

          if (newbptr)
          {
            double fval_;
            errno = 0;
            fval_ = strtod(newbptr, &ucv_);

            if (errno != ERANGE)
            {
              Text_ += pdif;
              _ParseValid = true;
              CharData_ = newbptr;
            }
          }
        }
        else if (_DataType == LONGDOUBLE)
        {
          newbptr = ExtractFloat(Text_, pdif);

          if (newbptr)
          {
            Ldouble fval_;
            errno = 0;
            fval_ = _strtold(newbptr, &ucv_);

            if (errno != ERANGE)
            {
              Text_ += pdif;
              _ParseValid = true;
              CharData_ = newbptr;
            }
          }
        }
        else
        {
          if (_DataType & UNSIGNED)
          {
            if (_DataType & CHAR)
            {
              CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 2);
              CharData_[0] = Text_[0];
              CharData_[1] = 0;
              ++Text_;
              _ParseValid = true;
            }
            else
            {
              newbptr = ExtractUnsignedNum(Text_, pdif);

              if (newbptr)
              {
                Ulong ulval_;
                errno = 0;
                ulval_ = strtoul(Text_, &ucv_, 0);

                if (errno != ERANGE)
                {
                  Text_ += pdif;
                  _ParseValid = true;
                  CharData_ = newbptr;
                }
              }
            }
          }
          else if (_DataType & SIGNED)
          {
            if (_DataType & CHAR)
            {
              CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 2);
              CharData_[0] = Text_[0];
              CharData_[1] = 0;

              ++Text_;
              _ParseValid = true;
            }
            else
            {
              newbptr = ExtractSignedNum(Text_, pdif);

              if (newbptr)
              {
                long lval_;
                errno = 0;
                lval_ = strtol(Text_, &ucv_, 0);

                if (errno != ERANGE)
                {
                  Text_ += pdif;
                  _ParseValid = true;
                  CharData_ = newbptr;
                }
              }
            }
          }
          else if (_DataType & CHAR)
          {
            CharData_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * 2);
            CharData_[0] = Text_[0];
            CharData_[1] = 0;
            
            ++Text_;
            _ParseValid = true;
          }
          else if (_DataType & INT)
          {
            newbptr = ExtractSignedNum(Text_, pdif);

            if (newbptr)
            {
              long lval_;
              errno = 0;
              lval_ = strtol(Text_, &ucv_, 0);

              if (errno != ERANGE)
              {
                Text_ += pdif;
                _ParseValid = true;
                CharData_ = newbptr;
              }
            }
          }
        }
      }

      if (_Wspace == MatchTrailingSpaces)
        if (!isspace(*Text_))
          _ParseValid = false;
        else if (isspace(*Text_))
        {
          if (_WspaceChar)
            Text_ += strspn(Text_, _WspaceChar);
          else
            Text_ += strspn(Text_, " \t\n\r");
        }      
    }
  }

  // For repeated parse of SymbolData as indicated
  // by the recur times argument specified in the tag.
  if (Max_ > 1)
  {
    if (Max_ == INT_MAX)
    {
      if (x > 1)
      {
        _ParseValid = true;
        
        if (Saved_)
          CharData_ = Saved_;
      }
    }
    else if (Saved_)
    {
      ::DeleteArray(Saved_);
      Saved_ = NULL;
    }
  }

  if (_HasSymData)
  {
    if (_SymData && _SymData->GetSymbol(false) != CharData_)
      _SymData->SetSymbol(CharData_);
  }
  else
  {
    if (_Char != CharData_)
      _Char = CharData_;
  }

  SetParseDone(_ParseValid);
  SetParseValid(_ParseValid || !_Required);

  if (IsSoloSymbol())
  {
    _TriggerState &= ~FRESH;
    _TriggerState |= STARTED;

    if (_ParseDone)
    {
      ParserData()->IncPgrmIndex();
      // debug
      // ParserData()->SetScopeLevel
      //   (0, ParserData()->GetFncStkLevel(),
      //    ParserData()->GetBlkStkLevel(),
      //    ParserData()->GetPgrmIndex(), 4,
      //    ParserData()->GetPgrmIndex());

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif

      if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
        (*_TriggerObj)();
      else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
      {
        if (_TriggerData->_FncArgr)
          strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);
      
        ExecTriggerFunction();
      }

      _TriggerState |= TRIGGER_DONE;
      _TriggerState &= ~TRIGGER_FAIL;
    }
    else
    {
      _TriggerState |= TRIGGER_FAIL;    
      _TriggerState &= ~TRIGGER_DONE;
    }
  }

  return Text_;
}

/****************************************************************************/
void SymbolSet::CreateParserData()
{
  if (!_ParserData)
  {
    _ParserData = new SymbolParserData();
    _ParserData->IncRefObjects();
  }
  else
    _ParserData->IncRefObjects();
}

/****************************************************************************/
void SymbolSet::DestroyParserData()
{
  if (_ParserData)
  {
    if (_ParserData->RefCount() > 1)
      _ParserData->DecRefObjects();
    else
    {
      _ParserData->DecRefObjects();
      delete _ParserData;
      _ParserData = NULL;
    }
  }
}

/****************************************************************************/
SymbolParserData* SymbolSet::ParserData()
{
  return _ParserData;
}

/****************************************************************************/
// Aggregate Class Definition
/****************************************************************************/
AggregateSymbol::AggregateSymbol(int MaxAggs_, int AggType_):
SymbolSet(),
_MaxAggs(MaxAggs_),
_AggsArray((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * MaxAggs_)),
_AggsTransferred((bool*)RawAllocateWith(MEMMATRIX, sizeof(bool) * MaxAggs_)),
_StatesArray((int*)RawAllocateWith(MEMMATRIX, sizeof(int) * MaxAggs_ * 3)),
_SepChar(NULL),
_NestingSymIndex(-1),
_AggType(AggType_),
_AggsRequired(0),
_AggsState(0),
_GroupValid(false),
_GroupDone(false)
{
  int x;
  int Base_ = _MaxAggs;
  
  for (x = 0; x < _MaxAggs; x++)
  {
    _AggsArray[x] = NULL;
    _AggsTransferred[x] = false;
    
    _StatesArray[x] =
    _StatesArray[Base_ + x] =
    _StatesArray[(Base_ * 2) + x] = 0;
  }

  SetSoloSymbol(false);  
}

/****************************************************************************/
AggregateSymbol::AggregateSymbol(int MaxAggs_, int AggType_,
                                 const char* Str_, const char* WsChar_,
                                 int IoType_, int DataType_,
                                 int Attrib_, int Type_, int Ws_,
                                 bool SkipSpaces_, bool Required_,
                                 bool CaseSensitive_, bool Ordered_):
SymbolSet
(
  Str_, WsChar_, IoType_,
  DataType_, Attrib_, Type_,
  Ws_, SkipSpaces_, Required_,
  CaseSensitive_, Ordered_
),
_MaxAggs(MaxAggs_),
_AggsArray((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * MaxAggs_)),
_AggsTransferred((bool*)RawAllocateWith(MEMMATRIX, sizeof(bool) * MaxAggs_)),
_StatesArray((int*)RawAllocateWith(MEMMATRIX, sizeof(int) * MaxAggs_ * 3)),
_SepChar(NULL),
_NestingSymIndex(-1),
_AggType(AggType_),
_AggsRequired(0),
_AggsState(0),
_GroupValid(false),
_GroupDone(false)                                 
{
  int x;
  int Base_ = _MaxAggs;
  
  for (x = 0; x < _MaxAggs; x++)
  {
    _AggsArray[x] = NULL;
    _AggsTransferred[x] = false;

    _StatesArray[x] =
    _StatesArray[Base_ + x] =
    _StatesArray[(Base_ * 2) + x] = 0;    
  }

  SetSoloSymbol(false);  
}

/****************************************************************************/
AggregateSymbol::AggregateSymbol(int MaxAggs_, int AggType_,
                                 SymbolSet* SymData_, const char* WsChar_,
                                 int IoType_, int DataType_,
                                 int Attrib_, int Type_, int Ws_,
                                 bool SkipSpaces_, bool Required_,
                                 bool CaseSensitive_, bool Ordered_):
SymbolSet
(
  SymData_, WsChar_, IoType_,
  DataType_, Attrib_, Type_,
  Ws_, SkipSpaces_, Required_,
  CaseSensitive_, Ordered_
),
_MaxAggs(MaxAggs_),
_AggsArray((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * MaxAggs_)),
_AggsTransferred((bool*)RawAllocateWith(MEMMATRIX, sizeof(bool) * MaxAggs_)),
_StatesArray((int*)RawAllocateWith(MEMMATRIX, sizeof(int) * MaxAggs_ * 3)),
_SepChar(NULL),
_NestingSymIndex(-1),
_AggType(AggType_),
_AggsRequired(0),
_AggsState(0),
_GroupValid(false),
_GroupDone(false)                                 
{
  // Aggregate symbol states:
  //   index = NOT_REQUIRED
  //   Array Limit + index = REQUIRED
  //   (Array Limie * 2) + index = DONE
  //
  //  _StatesArray[Index_] = NotReqEnum_;
  //  _StatesArray[Base_ + Index_] = ReqEnum_;
  //  _StatesArray[(Base_ * 2) + Index_] = DoneEnum_;
  //

  int x;
  int Base_ = _MaxAggs;
  
  for (x = 0; x < _MaxAggs; x++)
  {
    _AggsArray[x] = NULL;
    _AggsTransferred[x] = false;

    _StatesArray[x] =
    _StatesArray[Base_ + x] =
    _StatesArray[(Base_ * 2) + x] = 0;
  }

  SetSoloSymbol(false);  
}

/****************************************************************************/
AggregateSymbol::AggregateSymbol(int MaxAggs_, int AggType_,
                                 const AggregateSymbol& Obj_):
SymbolSet(Obj_),
_MaxAggs(MaxAggs_),
_AggsArray((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * MaxAggs_)),
_AggsTransferred((bool*)RawAllocateWith(MEMMATRIX, sizeof(bool) * MaxAggs_)),
_StatesArray((int*)RawAllocateWith(MEMMATRIX, sizeof(int) * MaxAggs_ * 3)),
_SepChar(new_char_string(Obj_._SepChar)),
_NestingSymIndex(-1),
_AggType(AggType_),
_AggsRequired(Obj_._AggsRequired),
_AggsState(Obj_._AggsState),
_GroupValid(Obj_._GroupValid),
_GroupDone(Obj_._GroupDone)
{
  // Aggregate symbol states:
  //   index = NOT_REQUIRED
  //   Array Limit + index = REQUIRED
  //   (Array Limie * 2) + index = DONE
  //
  //  _StatesArray[Index_] = NotReqEnum_;
  //  _StatesArray[Base_ + Index_] = ReqEnum_;
  //  _StatesArray[(Base_ * 2) + Index_] = DoneEnum_;
  //

  int x;
  int Base_ = _MaxAggs;
  
  for (x = 0; x < _MaxAggs; x++)
  {
    _AggsArray[x] = NULL;
    _AggsTransferred[x] = false;

    _StatesArray[x] =
    _StatesArray[Base_ + x] =
    _StatesArray[(Base_ * 2) + x] = 0;
  }

  SetSoloSymbol(false);

  if (!_Enclosing || !_Enclosing->IsSequence(true))
  {
    ParserData()->SetCdefExists(false);
    ParserData()->SetCdefLimit(0);
    ParserData()->SetBranchBlocked(false);
    ParserData()->SetOrBranchOut(false);
    ParserData()->SetBranchFound(false);
    ParserData()->SetOrBranchNum(0);
  }

  for (x = 0; x < _MaxAggs; x++)
  {
    _AggsArray[x] =
    Obj_._AggsArray[x] ? Obj_._AggsArray[x]->Clone():NULL;
    _AggsTransferred[x] = false;
  }
}

/****************************************************************************/
AggregateSymbol::~AggregateSymbol()
{
  int x;
  for (x = 0; x < _MaxAggs; x++)
    if (!_AggsTransferred[0])
      delete _AggsArray[x];

  ::DeleteArray(_SepChar);
  ::DeleteArray(_AggsArray);
  ::DeleteArray(_AggsTransferred);
  ::DeleteArray(_StatesArray);

  if (!_Enclosing || !_Enclosing->IsSequence(true))
  {
    ParserData()->SetCdefExists(false);
    ParserData()->SetCdefLimit(0);
    ParserData()->SetBranchBlocked(false);
    ParserData()->SetOrBranchOut(false);
    ParserData()->SetBranchFound(false);
    ParserData()->SetOrBranchNum(0);
  }  
}

/****************************************************************************/
bool AggregateSymbol::IsAggregateSymbol(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsAggregateSymbol(FollowEnclosing_);

  return true;
}

/****************************************************************************/
SymbolSet& AggregateSymbol::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {
    SymbolSet::operator = (Obj_);
    SetSoloSymbol(false);    
    AggregateSymbol* sObj_ = ((AggregateSymbol*)(&Obj_));
    
    _AggsRequired = sObj_->_AggsRequired;
    _AggsState = sObj_->_AggsState;
    _GroupValid = sObj_->_GroupValid;
    _GroupDone = sObj_->_GroupDone;

    if (!_Enclosing || !_Enclosing->IsSequence(true))
    {
      ParserData()->SetCdefExists(false);
      ParserData()->SetCdefLimit(0);
      ParserData()->SetBranchBlocked(false);
      ParserData()->SetOrBranchOut(false);
      ParserData()->SetBranchFound(false);
      ParserData()->SetOrBranchNum(0);
    }    

    if (_SepChar != sObj_->_SepChar)
      ::DeleteArray(_SepChar);

    _SepChar = new_char_string(sObj_->_SepChar);    

    int x;
    int Base_ = _MaxAggs;

    for (x = 0; x < _MaxAggs; x++)
    {
      if (_AggsArray[x] != sObj_->_AggsArray[x] &&
          !_AggsTransferred[x])
        delete _AggsArray[x];

      _AggsArray[x] =
      sObj_->_AggsArray[x] ? sObj_->_AggsArray[x]->Clone():NULL;
      _AggsTransferred[x] = false;
    }

    SetAggsRequired();
  }

  return *this;
}

/****************************************************************************/  
int AggregateSymbol::AggregateType() const
{
  return 0;
}

/****************************************************************************/
const char* AggregateSymbol::GetSeparatorString() const
{
  return _SepChar;
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetSeparatorString(const char* SepChar_)
{
  if (_SepChar != SepChar_)
  {
    ::DeleteArray(_SepChar);
    _SepChar = NULL;
  }

  _SepChar = new_char_string(SepChar_);
  return *this;
}

/****************************************************************************/
SymbolSet& AggregateSymbol::ClearSeparatorString()
{
  ::DeleteArray(_SepChar);
  _SepChar = NULL;
  return *this;
}

/****************************************************************************/  
SymbolSet& AggregateSymbol::SetNestingSymbol(int Index_, SymbolSet* SymPtr_)
{
  if (SymPtr_)
  {
    int x;
    for (x = 0; x < _MaxAggs; x++)
      if (_AggsArray[x] && SymPtr_ == _AggsArray[x])
      {
        _NestingSymIndex = x;
        break;
      }
  }
  else
    _NestingSymIndex = Index_;

  return *this;
}

/****************************************************************************/  
void AggregateSymbol::SetAggsStates(int Index_, int NotReqEnum_,
                                    int ReqEnum_, int DoneEnum_)
{
  // Aggregate symbol states:
  //   index = NOT_REQUIRED
  //   Array Limit + index = REQUIRED
  //   (Array Limie * 2) + index = DONE
  //
  //  _StatesArray[Index_] = NotReqEnum_;
  //  _StatesArray[Base_ + Index_] = ReqEnum_;
  //  _StatesArray[(Base_ * 2) + Index_] = DoneEnum_;
  //

  if (0 <= Index_ && Index_ < _MaxAggs)
  {
    int Base_ = _MaxAggs;  
    _StatesArray[Index_] = NotReqEnum_;
    _StatesArray[Base_ + Index_] = ReqEnum_;
    _StatesArray[(Base_ * 2) + Index_] = DoneEnum_;
  }
}

/****************************************************************************/  
SymbolSet& AggregateSymbol::SetAggsState(int EnumIndex_)
{
  if (0 <= EnumIndex_ && EnumIndex_ < _MaxAggs)
    _AggsState |= _StatesArray[(_MaxAggs * 2) + EnumIndex_];
    
  return *this;
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetAggsRequired()
{
  int x;
  int Base_ = _MaxAggs;

  for (x = 0; x < _MaxAggs; x++)
  {
    if (_AggsArray[x])
    {
      _AggsRequired |= _StatesArray[Base_ + x];
      _AggsRequired &= ~_StatesArray[x];
      _AggsArray[x]->SetSoloSymbol(false);
    }
    else
    {
      _AggsRequired |= _StatesArray[x];
      _AggsRequired &= ~_StatesArray[Base_ + x];
    }
  }

  return *this;
}

/****************************************************************************/   
SymbolSet* AggregateSymbol::SetAggs(int EnumIndex_, int NestLevel_,
                                    SymbolSet* Sym_, bool Overwrite_)
{
  if (NestLevel_ == 0)
  {
    if (Sym_)
    {
      if (Sym_ != _AggsArray[EnumIndex_] && !_AggsTransferred[EnumIndex_])
        delete _AggsArray[EnumIndex_];
    
      _AggsArray[EnumIndex_] = Overwrite_ ? Sym_->Clone():Sym_;
      _AggsTransferred[EnumIndex_] = Overwrite_ ? false:Sym_->AggsTransferred(EnumIndex_);
      _AggsArray[EnumIndex_]->SetSoloSymbol(false);
      
      _AggsRequired |= _StatesArray[_MaxAggs + EnumIndex_];
      _AggsRequired &= ~_StatesArray[EnumIndex_];
    }
    else
    {
      if (!_AggsTransferred[EnumIndex_])
        delete _AggsArray[EnumIndex_];
      
      _AggsArray[EnumIndex_] = NULL;
      _AggsRequired |= _StatesArray[EnumIndex_];
      _AggsRequired &= ~_StatesArray[_MaxAggs + EnumIndex_];
    }

    return _AggsArray[EnumIndex_];    
  }
  else if (NestLevel_ > 0 && _NestingSymIndex >= 0 &&
           _AggsArray[_NestingSymIndex] &&
           _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
  {
    _AggsArray[_NestingSymIndex]->SetNestingSymbol(_NestingSymIndex);
    return _AggsArray[_NestingSymIndex]->SetAggs(
                EnumIndex_, NestLevel_-1, Sym_, Overwrite_);
  }

  return NULL;
}

/****************************************************************************/  
int AggregateSymbol::GetAggsState() const
{
  return _AggsState;
}

/****************************************************************************/    
int AggregateSymbol::GetAggsRequired() const
{
  return _AggsRequired;
}

/****************************************************************************/
SymbolSet* AggregateSymbol::GetAggs(int EnumIndex_, int NestLevel_,
                                    bool Transfer_)
{
  if (NestLevel_ == 0)
  {
    _AggsTransferred[EnumIndex_] = Transfer_;
    return _AggsArray[EnumIndex_];
  }
  else if (NestLevel_ > 0 && _NestingSymIndex >= 0 &&
           _AggsArray[_NestingSymIndex] &&
           _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
  {
    _AggsArray[_NestingSymIndex]->SetNestingSymbol(_NestingSymIndex);  
    return _AggsArray[_NestingSymIndex]->GetAggs(
                EnumIndex_, NestLevel_-1, Transfer_);
  }

  return NULL;
}

/****************************************************************************/
bool AggregateSymbol::AggsTransferred(int Index_) const
{
  if (0 <= Index_ && Index_ < _MaxAggs)
    return _AggsTransferred[Index_];

  return true;
}

/****************************************************************************/   
void AggregateSymbol::Reset()
{
  _AggsState = 0;
  _AggsRequired = 0;
  _GroupValid = false;
  _GroupDone = false;  

  SymbolSet::Reset();

  if (!_Enclosing || !_Enclosing->IsSequence(true))
  {
    ParserData()->SetCdefExists(false);
    ParserData()->SetCdefLimit(0);
    ParserData()->SetBranchBlocked(false);
    ParserData()->SetOrBranchOut(false);
    ParserData()->SetBranchFound(false);
    ParserData()->SetOrBranchNum(0);
  }

  int x;
  int Base_ = _MaxAggs;

  for (x = 0; x < _MaxAggs; x++)
  {
    if (_AggsArray[x])
    {
      _AggsArray[x]->Reset();
      _AggsRequired |= _StatesArray[Base_ + x];
      _AggsRequired &= ~_StatesArray[x];
    }
    else
    {
      _AggsRequired |= _StatesArray[x];
      _AggsRequired &= ~_StatesArray[Base_ + x];
    }
  }
}

/****************************************************************************/
bool AggregateSymbol::HasSymbol(const SymbolSet* SymPtr_, bool NoChain_)
{
  int x;
  SymbolSet* tPtr_ = ((SymbolSet*)this);

  if (tPtr_ == SymPtr_)
    return true;

  for (x = 0; x < _MaxAggs; x++)
    if (_AggsArray[x] && _AggsArray[x]->HasSymbol(SymPtr_))
      return true;

  return false;      
}

/****************************************************************************/    
bool AggregateSymbol::HasAggs(int EnumIndex_)
{
  return
  (
    _AggsArray[EnumIndex_] != NULL &&
    (_AggsRequired & _StatesArray[_MaxAggs + EnumIndex_])
  );
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetGroupValid(bool Valid_)
{
  _GroupValid = Valid_;
  SymbolSet::SetParseValid(Valid_);

  int x;
  for (x = 0; x < _MaxAggs; x++)
    if (_AggsArray[x])
      _AggsArray[x]->SetGroupValid(Valid_);
  
  return *this;
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetGroupDone(bool Done_)
{
  _GroupDone = Done_;
  SymbolSet::SetParseDone(Done_);

  int x;
  for (x = 0; x < _MaxAggs; x++)
    if (_AggsArray[x])
      _AggsArray[x]->SetGroupDone(Done_);
  
  return *this;
}

/****************************************************************************/
bool AggregateSymbol::IsGroupValid() const
{
  bool Valid_ = _GroupValid && SymbolSet::IsGroupValid();

  int x;
  for (x = 0; x < _MaxAggs && Valid_; x++)
    if (_AggsArray[x] && Valid_)
      Valid_ = Valid_ && _AggsArray[x]->IsGroupValid();

  return Valid_;
}

/****************************************************************************/
bool AggregateSymbol::IsGroupDone() const
{
  bool Done_ = _GroupDone && SymbolSet::IsGroupDone();

  int x;
  for (x = 0; x < _MaxAggs && Done_; x++)
    if (_AggsArray[x] && Done_)
      Done_ = Done_ && _AggsArray[x]->IsGroupDone();

  return Done_;
}

/****************************************************************************/
SymbolSet::TriggerFncData* AggregateSymbol::GiveTriggerFncData()
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->GiveTriggerFncData();

  return SymbolSet::GiveTriggerFncData();
}

/****************************************************************************/
SymbolSet::StateChangeFncData* AggregateSymbol::GiveStateChangeFncData()
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->GiveStateChangeFncData();

  return SymbolSet::GiveStateChangeFncData();
}

/****************************************************************************/
ObjectFunctor* AggregateSymbol::GiveTriggerObject()
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->GiveTriggerObject();

  return SymbolSet::GiveTriggerObject();
}

/****************************************************************************/
ObjectFunctor* AggregateSymbol::GiveStateChangeObject()
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->GiveStateChangeObject();

  return SymbolSet::GiveStateChangeObject();
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetStateChangeObject(ObjectFunctor* Obj_)
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->SetStateChangeObject(Obj_);

  return SymbolSet::SetStateChangeObject(Obj_);
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetStateChangeFunction(int(*Fnc_)(int, char**, void*),
                                                   int FncArgc_, char** FncArgv_,
                                                   bool ResultArg_, bool BranchArg_,
                                                   void* FncArgi_)
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    _AggsArray[_NestingSymIndex]->
        SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                               ResultArg_, BranchArg_, FncArgi_);

  return SymbolSet::SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                           ResultArg_, BranchArg_, FncArgi_);
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetTriggerObject(ObjectFunctor* Obj_)
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    return _AggsArray[_NestingSymIndex]->SetTriggerObject(Obj_);

  return SymbolSet::SetTriggerObject(Obj_);
}

/****************************************************************************/
SymbolSet& AggregateSymbol::SetTriggerFunction(int(*Fnc_)(int, char**, void*),
                                               int FncArgc_, char** FncArgv_,
                                               bool ResultArg_, bool BranchArg_,
                                               void* FncArgi_)
{
  if (_NestingSymIndex >= 0 && _AggsArray[_NestingSymIndex] &&
      _AggsArray[_NestingSymIndex]->AggregateType() == _AggType)
    _AggsArray[_NestingSymIndex]->
        SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                           ResultArg_, BranchArg_, FncArgi_);

  return SymbolSet::SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                       ResultArg_, BranchArg_, FncArgi_);
}

/****************************************************************************/
// Sequence Class Definition
/****************************************************************************/
Sequence::Sequence():
_SetLen(0),
_Limit(SETLENINCR),
_Index(0),
_StructType(0),
_SeqType(0),
_SeqRequired(0),
_SeqState(0),
_DeclType(0),
_DefnType(0),
_CdefLimit(0),
_CdefExists(false),
_CdeChkBlock(false),
_OrBranchOut(false),
_Set((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * SETLENINCR)),
_NullSet(NULL),
_Intersect(NULL),
_CircSeqTerm(NULL),
_CdefLimitValue(0),
_CdefLimitExplicit(false),
_ErrorSet(false),
_SepChar(NULL),
_Separator(NULL),
_SepTransferred(false)
{
  int x;
  for (x = 0; x < _Limit; x++)
    _Set[x] = NULL;

  ParserData()->SetCdefExists(false);
  ParserData()->SetCdefLimit(0);
  ParserData()->SetBranchBlocked(false);
  SetOrBranchOut(false);
  SetSoloSymbol(false);  
}

/****************************************************************************/
Sequence::Sequence(const char* Str_, const char* WsChar_,
                   int IoType_, int DataType_, int Struct_,
                   int Attrib_, int Type_, int Ws_,
                   int SeqType_, int TypeExt_, bool SkipSpaces_,
                   bool Required_, bool CaseSensitive_, bool Ordered_):
SymbolSet
(
  Str_, WsChar_, IoType_,
  DataType_, Attrib_, Type_,
  Ws_, SkipSpaces_, Required_,
  CaseSensitive_, Ordered_
),
_SetLen(0),
_Limit(SETLENINCR),
_Index(0),
_StructType(Struct_),
_SeqType(SeqType_),
_SeqRequired(0),
_SeqState(0),
_DeclType(SeqType_ == SymbolSet::Declaration ? TypeExt_:0),
_DefnType(SeqType_ == SymbolSet::Definition ? TypeExt_:0),
_CdefLimit(0),
_CdefExists(false),
_CdeChkBlock(false),
_OrBranchOut(false),
_Set((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * SETLENINCR)),
_NullSet(NULL),
_Intersect(NULL),
_CircSeqTerm(NULL),
_CdefLimitValue(0),
_CdefLimitExplicit(false),
_ErrorSet(false),
_SepChar(NULL),
_Separator(NULL),
_SepTransferred(false)
{
  int x;
  for (x = 0; x < _Limit; x++)
    _Set[x] = NULL;

  ParserData()->SetCdefExists(false);
  ParserData()->SetCdefLimit(0);
  ParserData()->SetBranchBlocked(false);
  SetOrBranchOut(false);  
  SetSoloSymbol(false);    
}

/****************************************************************************/
Sequence::Sequence(const Sequence& Obj_):
SymbolSet(Obj_),
_SetLen(Obj_._SetLen),
_Limit(Obj_._Limit),
_Index(Obj_._Index),
_StructType(Obj_._StructType),
_SeqType(Obj_._SeqType),
_SeqRequired(Obj_._SeqRequired),
_SeqState(Obj_._SeqState),
_DeclType(Obj_._DeclType),
_DefnType(Obj_._DefnType),
_CdefLimit(Obj_._CdefLimit),
_CdefExists(Obj_._CdefExists),
_CdeChkBlock(Obj_._CdeChkBlock),
_OrBranchOut(Obj_._OrBranchOut),
_Set((SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * SETLENINCR)),
_NullSet(NULL),
_Intersect(NULL),
_CircSeqTerm(NULL),
_CdefLimitValue(Obj_._CdefLimitValue),
_CdefLimitExplicit(Obj_._CdefLimitExplicit),
_ErrorSet(Obj_._ErrorSet),
_SepChar(new_char_string(Obj_._SepChar)),
_Separator(Obj_._Separator),
_SepTransferred(false)
{
  int x;
  int lim = Obj_._SetLen - 1;
  Sequence* sObj_ = ((Sequence*)(&Obj_));  
  SymbolSet* Term_ = (SymbolSet*)sObj_->_CircSeqTerm;
  SymbolSet* Next_;
  Term_->UnlinkSeqTerm(sObj_);
  sObj_->_CircSeqTerm = NULL;

  SymbolSet* Delim_ = _Separator;
  _Separator = NULL;
  
  if (Delim_)
    SetSeparator(Delim_);  
    
  if (Term_)
  {
    for (x = 0; x < lim; x++)
      if (sObj_->_Set[x])
        _Set[x] = sObj_->_Set[x]->Clone();

    Next_ = sObj_->_Set[x]->Clone();
    _Set[lim] = Next_;
  }
  else
  {
    for (x = 0; x < _SetLen; x++)
      if (sObj_->_Set[x])
        _Set[x] = sObj_->_Set[x]->Clone();
  }

  for (;x < _Limit; x++)
    _Set[x] = NULL;

  if (Term_)
  {
    sObj_->_CircSeqTerm = Term_;
    Term_->SetNext(sObj_, true);
    SetCircSeqWrap(this);
  }

  ParserData()->SetCdefExists(_CdefExists);
  ParserData()->SetCdefLimit(_CdefLimit);
  ParserData()->SetBranchBlocked(_CdeChkBlock);
  SetOrBranchOut(false);
  SetSoloSymbol(false);
}

/****************************************************************************/
Sequence::~Sequence()
{
  if (_CircSeqTerm)
    _CircSeqTerm->UnlinkSeqTerm(this);

  int x;
  for (x = 0; x < _Limit; x++)
  {
    delete _Set[x];
    _Set[x] = NULL;
  }

  ::DeleteArray(_Set);
  ::DeleteArray(_SepChar);

  if (!_SepTransferred)
    delete _Separator;

  ParserData()->SetCdefExists(false);
  ParserData()->SetCdefLimit(0);
  ParserData()->SetBranchBlocked(false);
  SetOrBranchOut(false);  
}

/****************************************************************************/
bool Sequence::SepTransferred() const
{
  return _SepTransferred;
}

/****************************************************************************/
SymbolSet* Sequence::Clone() const
{
  Sequence* Retval_ = new Sequence(*this);
  return Retval_;
}

/****************************************************************************/
SymbolSet& Sequence::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {  
    SymbolSet::operator = (Obj_);

    if (Obj_.IsSequence())
    {
      Sequence* sObj_ = ((Sequence*)(&Obj_));
      int x, NewSz_, NewLim_;
      int lim = sObj_->_SetLen - 1;
      SymbolSet* Term_ = (SymbolSet*)sObj_->_CircSeqTerm;
      SymbolSet* Next_;
      Term_->UnlinkSeqTerm(sObj_);
      sObj_->_CircSeqTerm = _CircSeqTerm = NULL;

      _Index = sObj_->_Index;
      _StructType = sObj_->_StructType;
      _SeqType = sObj_->_SeqType;
      _DeclType = sObj_->_DeclType;
      _DefnType = sObj_->_DefnType;
      _CdefLimit = sObj_->_CdefLimit;
      _CdefExists = sObj_->_CdefExists;
      _CdeChkBlock = sObj_->_CdeChkBlock;
      _OrBranchOut = sObj_->_OrBranchOut;
      _Intersect = sObj_->_Intersect;
      _CdefLimitValue = sObj_->_CdefLimitValue;
      _CdefLimitExplicit = sObj_->_CdefLimitExplicit;
      _ErrorSet = sObj_->_ErrorSet;
      SetSeparator(sObj_->_Separator);

      if (_SepChar != sObj_->_SepChar)
        ::DeleteArray(_SepChar);

      _SepChar = new_char_string(sObj_->_SepChar);
                    
      for (x = 0; x < _Limit; x++)
      {
        delete _Set[x];
        _Set[x] = NULL;
      }
      
      NewSz_ = sObj_->_SetLen;
      NewLim_ = sObj_->_Limit;

      if (NewSz_ >= _SetLen || NewLim_ >= _Limit)
      {
        SymbolSet** OldSet_ = _Set;
        
        _Limit = NewLim_;
        _SetLen = NewSz_;
        _Set = (SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * _Limit);

        ::DeleteArray(OldSet_);
        OldSet_ = NULL;
      }      

      if (Term_)
      {
        for (x = 0; x < lim; x++)
          if (sObj_->_Set[x])
            _Set[x] = sObj_->_Set[x]->Clone();

        Next_ = sObj_->_Set[x]->Clone();
        _Set[lim] = Next_;
      }
      else
      {
        for (x = 0; x < _SetLen; x++)
          if (sObj_->_Set[x])
            _Set[x] = sObj_->_Set[x]->Clone();
      }

      for (;x < _Limit; x++)
        _Set[x] = NULL;

      if (Term_)
      {
        sObj_->_CircSeqTerm = Term_;
        Term_->SetNext(sObj_, true);
        SetCircSeqWrap(this);        
      }

      ParserData()->SetCdefExists(_CdefExists);
      ParserData()->SetCdefLimit(_CdefLimit);
      ParserData()->SetBranchBlocked(_CdeChkBlock);
      SetOrBranchOut(false);      
    }
  }

  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetSymbolAttrib(int Attrib_)
{
  _SymAttrib = Attrib_;

  if (!_Intersect && !_CircSeqTerm && !IsBranchOut())
  {  
    _SeqRequired |= (_SymAttrib & Starter) ? STARTER_REQ:NO_STARTER_REQ;
    _SeqRequired &= (_SymAttrib & Starter) ? ~NO_STARTER_REQ:~STARTER_REQ;
    _SeqRequired |= (_SymAttrib & Ender) ? ENDER_REQ:NO_ENDER_REQ;
    _SeqRequired &= (_SymAttrib & Ender) ? ~NO_ENDER_REQ:~ENDER_REQ;
  }
  else
  {
    _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
    _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);
  }  
  
  return *this;
}

/****************************************************************************/
const char* Sequence::GetSeparatorString() const
{
  return _SepChar;
}

/****************************************************************************/
SymbolSet& Sequence::SetSeparatorString(const char* SepChar_)
{
  if (_SepChar != SepChar_)
  {
    ::DeleteArray(_SepChar);
    _SepChar = NULL;
  }

  _SepChar = new_char_string(SepChar_);  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::ClearSeparatorString()
{
  ::DeleteArray(_SepChar);
  _SepChar = NULL;

  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetStructType(int StructType_)
{
  _StructType = StructType_;
  return *this;
}

/****************************************************************************/
int Sequence::GetStructType() const
{
  return _StructType;
}

/****************************************************************************/
SymbolSet& Sequence::SetSeparator(SymbolSet* Delim_, bool Overwrite_)
{
  int len = 0;
  int x;

  if (Delim_)
  {
    if (Delim_ != _Separator)
    {
      len = _Separator ? ::SafeStrLen(_Separator->GetSymbol(false)):0;
      if (len > 1)
      {
        ClearSeparatorString();        
        for (x = 0; x < _SetLen; x++)
          _Set[x]->ClearSeparatorString();
      }

      if (!_SepTransferred)
        delete _Separator;
    }

    len = ::SafeStrLen(Delim_->GetSymbol(false));
    _Separator = Overwrite_ ? Delim_->Clone():Delim_;
    _SepTransferred = Overwrite_ ? false:Delim_->SepTransferred();
    _Separator->SetSoloSymbol(false);
    _SeqRequired &= ~NO_BRANCHSEP_REQ;
    _SeqRequired |= BRANCHSEP_REQ;
    
    if (len == 1)
    {
      SetStringTerminator(*_Separator->GetSymbol(false));
      for (x = 0; x < _SetLen; x++)
        _Set[x]->SetStringTerminator(*_Separator->GetSymbol(false));
    }
    else
    {
      SetStringTerminator(' ');
      for (x = 0; x < _SetLen; x++)
        _Set[x]->SetStringTerminator(' ');

      if (len)
      {
        SetSeparatorString(_Separator->GetSymbol(false));
        for (x = 0; x < _SetLen; x++)
          _Set[x]->SetSeparatorString(_Separator->GetSymbol(false));
      }
    }
  }
  else
  {
    len = _Separator ? ::SafeStrLen(_Separator->GetSymbol(false)):0;
    if (len > 1)
    {
      ClearSeparatorString();
      for (x = 0; x < _SetLen; x++)
        _Set[x]->ClearSeparatorString();
    }

    if (!_SepTransferred)
      delete _Separator;
      
    _Separator = NULL;
    _SeqRequired |= NO_BRANCHSEP_REQ;
    _SeqRequired &= ~BRANCHSEP_REQ;
  }
  
  return *this;
}

/****************************************************************************/
SymbolSet* Sequence::Separator(bool Transfer_)
{
  _SepTransferred = Transfer_;
  return _Separator;
}

/****************************************************************************/
bool Sequence::GetOrBranchOut() const
{
  return _OrBranchOut;
}

/****************************************************************************/
bool Sequence::GetCdeChkBlock() const
{
  return _CdeChkBlock;
}

/****************************************************************************/
int Sequence::GetSequenceType() const
{
  return _SeqType;
}

/****************************************************************************/
int Sequence::GetDeclType() const
{
  return _DeclType;
}

/****************************************************************************/
int Sequence::GetDefnType() const
{
  return _DefnType;
}

/****************************************************************************/
bool Sequence::CheckForCde()
{
  int x, y, z, len;
  int x1, y1;
  int lim = _Limit * 2;
  SymbolSet** Hold_ = (SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * lim);
  SymbolSet* Lptr_ = this;
  bool EndSeq_;
  bool SingleChain_;
  bool SameFound_ = false;

  for (x = 0; x < lim; x++)
    Hold_[x] = NULL;

  for (x = z = 0; !SameFound_ && Lptr_;)
  {
    while (Lptr_)    
    {
      x = z;
      y = 0;
      SingleChain_ = Lptr_->IsSingleChain(EndSeq_);
    
      if (Lptr_ != this && (SingleChain_ || EndSeq_))
      {
        Hold_[x++] = Lptr_->NextSymbol(y);
        y++;
        
        for (x1 = 0; x1 < len; x1++)
        {
          for (y1 = x1 + 1; y1 < len+1; y1++)
            if (Hold_[x1] == Hold_[y1])
            {
              SameFound_ = true;
              _Intersect = Hold_[x1];
              break;
            }

          if (SameFound_)
            break;
        }

        x1 = 1;
      }
      else
        x1 = 0;

      if (SameFound_)
        break;

      if (SingleChain_ || EndSeq_)
      {
        z = len = Lptr_->Length();
        len += (x - x1);
      
        if (EndSeq_)
          --z;

        for (;x < len; x++, y++)
          Hold_[x] = Lptr_->NextSymbol(y);

        Lptr_ = EndSeq_ ? Lptr_->NextSymbol(z, true):NULL;
      }

      if (x >= lim-1)
      {
        SymbolSet** OldSet_ = Hold_;
        int OldLen_ = lim;
        lim += SETLENINCR;
        Hold_ = (SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * lim);

        for (x = 0; x < OldLen_; x++)
          Hold_[x] = OldSet_[x];

        for (z = x; x < lim; x++)
          Hold_[x] = NULL;

        ::DeleteArray(OldSet_);
        OldSet_ = NULL;
      }
    }

    if (!Lptr_ && !SameFound_)
    {
      for (x1 = 0; x1 < len-1; x1++)
      {
        for (y1 = x1 + 1; y1 < len; y1++)
          if (Hold_[x1] == Hold_[y1])
          {
            SameFound_ = true;
            _Intersect = Hold_[x1];            
            break;
          }

        if (SameFound_)
          break;
      }
    }
  }

  if (SameFound_ && _Intersect)
  {
    _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
    _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);  
  }

  _CdefExists = SameFound_;
  _CdefLimit = _CdefExists ? (_CdefLimitExplicit ?
                                  _CdefLimitValue:CIRCDEFLIMIT):0;

  ParserData()->SetCdefExists(_CdefExists);
  ParserData()->SetCdefLimit(_CdefLimit);
  ParserData()->SetBranchBlocked(_CdeChkBlock);  
                                    
  ::DeleteArray(Hold_);
  return SameFound_;
}

/****************************************************************************/
SymbolSet& Sequence::CheckForCdeBlock()
{
  if (!_OrBranchOut && !GetCdeChkBlock())
  {
    int x;
    bool Blocked_ = _CdeChkBlock;
  
    if (_Set)
      for (x = 0; x < _SetLen; x++)
      {
        Blocked_ = _Set[x]->IsSequence() &&
                   _Set[x]->GetCdeChkBlock();

        if (Blocked_)
        {
          _CdefExists = _Set[x]->CdefExists();
          _CdefLimit = _Set[x]->CdefLimit();

          ParserData()->SetCdefExists(_CdefExists);
          ParserData()->SetCdefLimit(_CdefLimit);          
          break;
        }
      }

    if (Blocked_)
    {
      _CdeChkBlock = Blocked_;
      ParserData()->SetBranchBlocked(_CdeChkBlock);
    }
  }

  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetOrBranchOut(bool Branch_)
{
  _OrBranchOut = Branch_;
  ParserData()->SetOrBranchOut(_OrBranchOut);

  if (!Branch_)
  {
    ParserData()->SetBranchFound(false);
    ParserData()->SetOrBranchNum(0);
  }
  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetCdeChkBlock(bool Block_)
{
  if (!_OrBranchOut && !GetCdeChkBlock())
  {
    bool EndSeq_;
    bool SingleChain_ = IsSingleChain(EndSeq_);
  
    if (SingleChain_)
      _CdeChkBlock = Block_;
    else if (EndSeq_)
    {
      _CdeChkBlock = Block_ &&
                       (_Set[_SetLen-1]->GetCdeChkBlock() ||
                        _Set[_SetLen-1]->HasSymbol(_Intersect));

      if (_CdeChkBlock)
      {
        _CdefExists = _Set[_SetLen-1]->CdefExists();
        _CdefLimit = _Set[_SetLen-1]->CdefLimit();
      }
    }

    ParserData()->SetCdefExists(_CdefExists);
    ParserData()->SetCdefLimit(_CdefLimit);
    ParserData()->SetBranchBlocked(_CdeChkBlock);    
  }

  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::HaltOnCircSeqEnd()
{
  _CdefLimit = _CdefExists ? 1:0;
  ParserData()->SetCdefLimit(_CdefLimit);  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::ConvertToCircSeq()
{
  Sequence* Seqp_ = NULL;
  SymbolSet** OldSet_ = _Set;
  int x, y, len, newlim;
  int TypeExt_;
  
  len = _SetLen / 2;
  bool Csense_ = (_DataType == DEFINED || _DataType == REGEXPR) ? true:false;

  TypeExt_ = (_SeqType == SymbolSet::Declaration ? _DeclType:0);
  if (!TypeExt_)
    TypeExt_ = (_SeqType == SymbolSet::Definition ? _DefnType:0);

  Seqp_ = new Sequence(_Char, " \t\n\r", _IoType,
                       _DataType, _StructType, _SymAttrib,
                       _SymType, _SeqType, TypeExt_,
                       0, true, true, Csense_, true);

  for (x = 0; x < len; x++)
    Seqp_->SetNext(_Set[x]);

  newlim = _SetLen - len;
  len = _SetLen;
  
  if (_Limit >= newlim)
    newlim = _Limit;
  else
  {
    for (y = 0; y < newlim; y += SETLENINCR);
    newlim = y;
  }
  
  _Set = (SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * newlim);
  _Limit = newlim;
  _SetLen = 0;
  _Index = 0;
  _CdefLimit = 0;
  _CdefExists = false;
  _CdeChkBlock = false;
  _Intersect = NULL;
  _CircSeqTerm = NULL;
    
  for (;x < len; x++)
    SetNext(OldSet_[x]);

  ::DeleteArray(OldSet_);
  Seqp_->SetNext(this);
  SetNext(Seqp_, true);
  CheckForCde();
    
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetCircDefLimitValue(int Limit_)
{
  _CdefLimitValue = Limit_ ? Limit_:CIRCDEFLIMIT;
  _CdefLimitExplicit = _CdefLimitValue != CIRCDEFLIMIT;

  if (!_CdefLimitExplicit)
    _CdefLimitValue = 0;

  ResetCdefLimit();  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::ResetCdefLimit()
{
  _CdefLimit = _CdefExists ? (_CdefLimitExplicit ?
                                  _CdefLimitValue:CIRCDEFLIMIT):0;
  _CdeChkBlock = false;

  ParserData()->SetCdefExists(_CdefExists);
  ParserData()->SetCdefLimit(_CdefLimit);
  ParserData()->SetBranchBlocked(_CdeChkBlock);

  
  return *this;
}

/****************************************************************************/
bool Sequence::CdefExists() const
{
  return _CdefExists;
}

/****************************************************************************/
int Sequence::CdefLimit() const
{
  return _CdefLimit;
}

/****************************************************************************/
bool Sequence::IsSingleChain(bool& EndSeq_) const
{
  int x;
  bool SingleChain_ = true;
  
  if (_Set)
    for (x = 0; x < _SetLen; x++)
    {
      if (SingleChain_)
        SingleChain_ = !(_Set[x]->IsSequence() ||
                         _Set[x]->IsBracketedSymbol());
      else
        break;
    }

  if (SingleChain_)
  {
    EndSeq_ = false;
    return true;
  }
  else if (x == _SetLen && _Set[_SetLen-1]->IsSequence())
    EndSeq_ = true;
    
  return false;
}

/****************************************************************************/
SymbolSet& Sequence::SetSequenceType(int Type_)
{
  _SeqType = Type_;
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetDeclType(int Type_)
{
  _DeclType = Type_;
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetDefnType(int Type_)
{
  _DefnType = Type_;
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetNext(SymbolSet* Set_, bool SeqTerm_)
{
  int x;  

  if (_SetLen >= _Limit)
  {
    SymbolSet** OldSet_ = _Set;
    int OldLen_ = _Limit;
    _Limit += SETLENINCR;
    _Set = (SymbolSet**)RawAllocateWith(MEMMATRIX, sizeof(SymbolSet*) * _Limit);

    for (x = 0; x < OldLen_; x++)
      _Set[x] = OldSet_[x];

    for (;x < _Limit; x++)
      _Set[x] = NULL;

    ::DeleteArray(OldSet_);
    OldSet_ = NULL;
  }

  Set_->SetSoloSymbol(false);
  _Set[_SetLen++] = Set_;

  // SymbolSet objects added into a sequence should set the sequence
  // object which it is added into as the enclosing object.
  if (Set_)
    Set_->SetEnclosing(this);

  if (SeqTerm_)
    _Set[_SetLen-1]->SetCircSeqTerm(this);
  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetCircSeqTerm(SymbolSet* Set_)
{
  _CircSeqTerm = Set_;
  _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
  _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);  
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::UnlinkSeqTerm(SymbolSet* Set_)
{
  int x;
  bool NonNullFound_ = false;

  if (!Set_)
    return *this;
  
  for (x = _SetLen-1; x >= 0; x--)
    if (_Set[x])
    {
      NonNullFound_ = true;
    
      if (_Set[x] == Set_)
      {
        _Set[x] = NULL;
        
        if (x == _SetLen - 1 || NonNullFound_)
          _SetLen = x;
      }
    }

  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetCircSeqWrap(SymbolSet* Set_)
{
  int x = _SetLen - 1;
  
  if (_Set[x] && _Set[x] != Set_)
  {
    if (_Set[x]->IsSequence())
      _Set[x]->SetCircSeqWrap(Set_);
    else
      SetNext(Set_, true);
  }
  else
    _Set[x] = Set_;
}

/****************************************************************************/
bool Sequence::HasSymbol(const SymbolSet* SymPtr_, bool NoChain_)
{
  int x;
  int lim = _SetLen - 1;
  
  for (x = 0; x < lim; x++)
    if (_Set[x] && _Set[x] == SymPtr_)
      return true;

  if (_Set[lim])
    if (_Set[lim]->IsSequence() && !NoChain_)
      return (_Set[lim]->HasSymbol(SymPtr_, NoChain_));
    else if (_Set[lim] == SymPtr_)
      return true;

  return false;
}

/****************************************************************************/
SymbolSet* Sequence::NextSymbol(int Index_, bool RawSym_)
{
  int lim = _SetLen - 1;

  if (0 <= Index_ && Index_ < lim)
    return _Set[Index_];

  if (Index_ == lim && _Set[lim])
    if (!RawSym_ && _Set[lim]->IsSequence())
      return (_Set[lim]->NextSymbol(0));
    else
      return _Set[lim];

  return _NullSet;
}

/****************************************************************************/
int Sequence::Length() const
{
  return _SetLen;
}

/****************************************************************************/
int Sequence::GetIndex() const
{
  return _Index;
}

/****************************************************************************/
void Sequence::Reset()
{
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;
  _ErrorSet = false;  
  _Index = 0;
  int x;
  
  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x])
      {        
        if (_Set[x]->IsSequence())
          _Set[x]->Reset();
      }

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }
  }
  
  ResetCdefLimit();
  SetOrBranchOut(_OrBranchOut);

  _SeqState = 0;

  if (!_Separator)
  {
    _SeqRequired |= NO_BRANCHSEP_REQ;
    _SeqRequired &= ~BRANCHSEP_REQ;
  }

  if (_Intersect || _CircSeqTerm)
  {
    _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
    _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);
  }

  SymbolSet::Reset();  
}

/****************************************************************************/
bool Sequence::IsErrorSet() const
{
  return _ErrorSet;
}

/****************************************************************************/
SymbolSet& Sequence::ResetErrorFlag()
{
  int x;
  _ErrorSet = false;
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;  
  
  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x] && _Set[x]->IsSequence())
        _Set[x]->ResetErrorFlag();

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }        
  }

  return *this;
}

/****************************************************************************/
bool Sequence::IsSequence(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsSequence(FollowEnclosing_);
    
  return true;
}

/****************************************************************************/
SymbolSet& Sequence::SetStateChangeObject(ObjectFunctor* Obj_)
{
  int x;
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;  

  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x] && _Set[x]->IsSequence())
        _Set[x]->SetStateChangeObject(Obj_);

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }
  }
  
  SymbolSet::SetStateChangeObject(Obj_);
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetStateChangeFunction(int(*Fnc_)(int, char**, void*),
                                             int FncArgc_, char** FncArgv_,
                                             bool ResultArg_, bool BranchArg_,
                                             void* FncArgi_)
{
  int x;
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;  

  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x] && _Set[x]->IsSequence())
        _Set[x]->SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                        ResultArg_, BranchArg_, FncArgi_);

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }
  }
  
  SymbolSet::SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                    ResultArg_, BranchArg_, FncArgi_);
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetTriggerObject(ObjectFunctor* Obj_)
{
  int x;
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;  

  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x] && _Set[x]->IsSequence())
        _Set[x]->SetTriggerObject(Obj_);

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }
  }
  
  SymbolSet::SetTriggerObject(Obj_);
  return *this;
}

/****************************************************************************/
SymbolSet& Sequence::SetTriggerFunction(int(*Fnc_)(int, char**, void*),
                                         int FncArgc_, char** FncArgv_,
                                         bool ResultArg_, bool BranchArg_,
                                         void* FncArgi_)
{
  int x;
  SymbolSet* Term_ = _CircSeqTerm ? (SymbolSet*)_CircSeqTerm:NULL;  

  if (_Set)
  {
    if (Term_)
    {
      Term_->UnlinkSeqTerm(this);
      _CircSeqTerm = NULL;
    }
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x] && _Set[x]->IsSequence())
        _Set[x]->SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                    ResultArg_, BranchArg_, FncArgi_);

    if (Term_)
    {
      _CircSeqTerm = Term_;
      Term_->SetNext(this, true);
    }
  }

  SymbolSet::SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                ResultArg_, BranchArg_, FncArgi_);
  return *this;
}

/****************************************************************************/
char* Sequence::ParseSymbolStep(char* Text_, bool& Done_)
{
  if (!Done_)
  {  
    if (_CdeChkBlock)
    {
      Done_ = true;
      return Text_;
    }
  
    if (_Set && _Index < _SetLen && _Set[_Index])
    {
      int lim = _SetLen-1;
      bool DecCdefCnt_ = false;
      
      if (_Index == 0)
      {
        ResetErrorFlag();

        _ParseValid = false;
        _ParseState &= ~FRESH;
        _ParseState |= STARTED;
      }
      else if (_Index == lim && _Intersect)
        DecCdefCnt_ = _Set[_Index]->IsSequence() &&
                      _Set[_Index]->HasSymbol(_Intersect);
    
      ParserData()->SetScope(ScopeInfo::StatementSCOPE);
      Text_ = _Set[_Index]->ParseSymbol(Text_);
      _ParseDone = _Set[_Index]->IsParseValid();

      if (_ParseDone)
      {
        if (_Index == 0 &&
            SeqRequiredState_Check(_Set[0], STARTER_REQ, STARTER_DONE))
          _SeqState |= STARTER_DONE;
      }      

      if (!_Set[_Index]->IsParseValid())
      {
        if (_Index < lim)
          _ErrorSet = true;

        if (!_Intersect && !_ErrorSet)
        {          
          Done_ = true;

          #if SYMBOLSET_DEBUG
            ParserData()->ShowData(cout);
          #endif
          return Text_;
        }
        else if (DecCdefCnt_)
        {
          // decrement circular definition recursion limit
          --_CdefLimit;
          ParserData()->SetCdefLimit(_CdefLimit);
          
          if (!_CdefLimit)
          {
            SetCdeChkBlock(true);
            SetGroupDone(false);
            SetGroupValid(!_Required);              
            ParserData()->SetBranchBlocked(_CdeChkBlock);
          }
          else
          {
            int Ceiling_ = _CdefExists ? (_CdefLimitExplicit ?
                                  _CdefLimitValue:CIRCDEFLIMIT):0;

            if (_CdefLimit < Ceiling_)
            {
              goto PsDone2;
            }
            else
            {
              SetCdeChkBlock(true);
              SetGroupDone(false);
              SetGroupValid(!_Required);
              ParserData()->SetBranchBlocked(_CdeChkBlock);            
            }
          }
        }        
      }
      else if (_Index == lim)
      {
        PsDone2:

        if (_ParseDone)
        {
          if (_Index == lim &&
              SeqRequiredState_Check(_Set[lim], ENDER_REQ, ENDER_DONE))
            _SeqState |= ENDER_DONE;
        }

        if (!IsBranchOut() && !_CircSeqTerm)
        {
          SetGroupDone(true);
          SetGroupValid(true);
          _SeqState |= SEQUENCE_DONE;
      
          ParserData()->IncPgrmIndex();
          // debug
          // ParserData()->SetScopeLevel
          //   (0, ParserData()->GetFncStkLevel(),
          //    ParserData()->GetBlkStkLevel(),
          //    ParserData()->GetPgrmIndex(), 4,
          //    ParserData()->GetPgrmIndex());

          _TriggerState &= ~FRESH;
          _TriggerState |= STARTED;

          if (_ParseDone)
          {
            if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
              (*_TriggerObj)();
            else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
            {
              if (_TriggerData->_FncArgr)
                strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);
          
              ExecTriggerFunction();
            }

            _TriggerState |= TRIGGER_DONE;
            _TriggerState &= ~TRIGGER_FAIL;
          }
          else
          {
            _TriggerState |= TRIGGER_FAIL;
            _TriggerState &= ~TRIGGER_DONE;
          }
        }
      }
      else if (_Separator)
      {      
        Text_ = _Separator->ParseSymbol(Text_);
        _ParseDone = _Separator->IsParseValid();
        _Separator->Reset();
        _SeqState |= BRANCHSEP_DONE;        
      }

      ++_Index;

      if (_Index == _SetLen)
      {
        Done_ = true;

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
      }
    }
  }

  return Text_;
}

/****************************************************************************/
char* Sequence::ParseSymbol(char* Text_)
{
  int x;
  
  if (_Set)
  {
    int lim = _SetLen-1;
    if (_CdeChkBlock)
      return Text_;

    ResetErrorFlag();

    _ParseValid = false;
    _ParseState &= ~FRESH;
    _ParseState |= STARTED;
  
    for (x = 0; x < lim; x++)
      if (_Set[x])
      {
        ParserData()->SetScope(ScopeInfo::StatementSCOPE);      
        Text_ = _Set[x]->ParseSymbol(Text_);
        _ParseDone = _Set[x]->IsParseValid();

        if (_ParseDone)
        {
          if (x == 0 &&
              SeqRequiredState_Check(_Set[0], STARTER_REQ, STARTER_DONE))
            _SeqState |= STARTER_DONE;
        }        

        if (!_Set[x]->IsParseValid())
        {
          _Index = x;
          _ErrorSet = true;

          #if SYMBOLSET_DEBUG
            ParserData()->ShowData(cout);
          #endif          
          return Text_;
        }
        else if (_Separator)
        {
          Text_ = _Separator->ParseSymbol(Text_);
          _ParseDone = _Separator->IsParseValid();
          _Separator->Reset();
          _SeqState |= BRANCHSEP_DONE;
        }
      }

    if (x == lim)
    {
      bool DecCdefCnt_ = false;
      if (_Intersect)
        DecCdefCnt_ = _Set[x]->IsSequence() &&
                      _Set[x]->HasSymbol(_Intersect);

      ParserData()->SetScope(ScopeInfo::StatementSCOPE);
      Text_ = _Set[x]->ParseSymbol(Text_);
      _ParseDone = _Set[x]->IsParseValid();

      if (!_Set[x]->IsParseValid())
      {      
        if (!_Intersect && !_ErrorSet)
        {
          _Index = x;

          #if SYMBOLSET_DEBUG
            ParserData()->ShowData(cout);
          #endif          
          return Text_;
        }
        else if (DecCdefCnt_)
        {
          // decrement circular definition recursion limit
          --_CdefLimit;
          ParserData()->SetCdefLimit(_CdefLimit);
          
          if (!_CdefLimit)
          {
            SetCdeChkBlock(true);
            SetGroupDone(false);
            SetGroupValid(!_Required);
            ParserData()->SetBranchBlocked(_CdeChkBlock);
          }
          else
          {
            int Ceiling_ = _CdefExists ? (_CdefLimitExplicit ?
                                  _CdefLimitValue:CIRCDEFLIMIT):0;

            if (_CdefLimit < Ceiling_)
            {
              goto PsDone1;
            }
            else
            {
              SetCdeChkBlock(true);
              SetGroupDone(false);
              SetGroupValid(!_Required);
              ParserData()->SetBranchBlocked(_CdeChkBlock);            
            }
          }
        }
      }
      else
      {
        PsDone1:

        if (_ParseDone)
        {
          if (x == lim &&
              SeqRequiredState_Check(_Set[lim], ENDER_REQ, ENDER_DONE))
            _SeqState |= ENDER_DONE;
        }        

        if (!IsBranchOut() && !_CircSeqTerm)
        {
          SetGroupDone(true);
          SetGroupValid(true);      
          _SeqState |= SEQUENCE_DONE;

          ParserData()->IncPgrmIndex();
          // debug
          // ParserData()->SetScopeLevel
          //   (0, ParserData()->GetFncStkLevel(),
          //    ParserData()->GetBlkStkLevel(),
          //    ParserData()->GetPgrmIndex(), 4,
          //    ParserData()->GetPgrmIndex());

          _TriggerState &= ~FRESH;
          _TriggerState |= STARTED;

          if (_ParseDone)
          {
            if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
              (*_TriggerObj)();
            else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
            {
              if (_TriggerData->_FncArgr)
                strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

              ExecTriggerFunction();
            }

            _TriggerState |= TRIGGER_DONE;
            _TriggerState &= ~TRIGGER_FAIL;
          }
          else
          {
            _TriggerState |= TRIGGER_FAIL;
            _TriggerState &= ~TRIGGER_DONE;
          }
        }
      }
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
// BranchOut Class Definition
/****************************************************************************/
BranchOut::BranchOut():
_BranchNum(0),
_BranchFound(false)
{
  _OrBranchOut = true;
  SetSoloSymbol(false);  
  SetOrBranchOut(_OrBranchOut);

  _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
  _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);
}

/****************************************************************************/
BranchOut::BranchOut(const char* Str_, const char* WsChar_,
                     int IoType_, int DataType_, int Struct_,
                     int Attrib_, int Type_, int Ws_,
                     int SeqType_, int TypeExt_, bool SkipSpaces_,
                     bool Required_, bool CaseSensitive_, bool Ordered_):
_BranchNum(0),
_BranchFound(false),
Sequence
(
  Str_, WsChar_,
  IoType_, DataType_, Struct_,
  Attrib_, Type_, Ws_,
  SeqType_, TypeExt_, SkipSpaces_,
  Required_, CaseSensitive_, Ordered_
)
{
  _OrBranchOut = true;
  SetSoloSymbol(false);  
  SetOrBranchOut(_OrBranchOut);

  _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
  _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);    
}

/****************************************************************************/
BranchOut::BranchOut(const BranchOut& Obj_):
_BranchNum(Obj_._BranchNum),
_BranchFound(Obj_._BranchFound),
Sequence(Obj_)
{
  _OrBranchOut = true;
  SetSoloSymbol(false);
  SetOrBranchOut(_OrBranchOut);

  _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
  _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);    

  ParserData()->SetOrBranchNum(_BranchNum);
  ParserData()->SetBranchFound(_BranchFound);  
}

/****************************************************************************/
void BranchOut::Reset()
{
  Sequence::Reset();

  _BranchNum = 0;
  _BranchFound = false;
  
  _OrBranchOut = true;  
  SetSoloSymbol(false);
  SetOrBranchOut(_OrBranchOut);

  _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
  _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);

  ParserData()->SetOrBranchNum(_BranchNum);
  ParserData()->SetBranchFound(_BranchFound);
}

/****************************************************************************/
bool BranchOut::IsBranchOut(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsBranchOut(FollowEnclosing_);

  return true;
}

/****************************************************************************/
SymbolSet* BranchOut::Clone() const
{
  BranchOut* Retval_ = new BranchOut(*this);
  return Retval_;
}

/****************************************************************************/
int BranchOut::BranchNum() const
{
  return _BranchNum;
}

/****************************************************************************/
bool BranchOut::BranchFound() const
{
  return _BranchFound;
}

/****************************************************************************/
SymbolSet& BranchOut::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {
    Sequence::operator = (Obj_);
    
    _OrBranchOut = true;
    SetSoloSymbol(false);    
    SetOrBranchOut(_OrBranchOut);

    _SeqRequired |= (NO_STARTER_REQ | NO_ENDER_REQ);
    _SeqRequired &= ~(STARTER_REQ | ENDER_REQ);    

    if (Obj_.IsBranchOut())
    {
      BranchOut* sObj_ = ((BranchOut*)(&Obj_));

      _BranchNum = sObj_->_BranchNum;
      _BranchFound = sObj_->_BranchFound;

      ParserData()->SetOrBranchNum(_BranchNum);
      ParserData()->SetBranchFound(_BranchFound);
    }
  }
  
  return *this;
}

/****************************************************************************/
char* BranchOut::ParseSymbolStep(char* Text_, bool& Done_)
{
  if (!Done_)
    if (_Set && _Index < _SetLen && _Set[_Index])
    {
      if (_Index == 0)
      {
        _ParseValid = false;
        _ParseState &= ~FRESH;
        _ParseState |= STARTED;
      }
    
      ParserData()->SetScope(ScopeInfo::StatementSCOPE);
      Text_ = _Set[_Index]->ParseSymbol(Text_);
      _ParseDone = _Set[_Index]->IsParseValid();

      if (_Set[_Index]->IsParseValid())
      {
        _BranchNum = _Index;
        _BranchFound = true;

        ParserData()->SetOrBranchNum(_BranchNum);
        ParserData()->SetBranchFound(_BranchFound);
        Done_ = true;
      }
      else      
        ++_Index;

      if (_Index == _SetLen || Done_)
      {
        ParserData()->IncPgrmIndex();
        // debug
        // ParserData()->SetScopeLevel
        //   (0, ParserData()->GetFncStkLevel(),
        //    ParserData()->GetBlkStkLevel(),
        //    ParserData()->GetPgrmIndex(), 4,
        //    ParserData()->GetPgrmIndex());

        SetGroupDone(_BranchFound);
        if (_BranchFound)
          SetGroupValid(true);
        else
          SetGroupValid(!_Required);

        if (_Separator && Done_)
        {
          Text_ = _Separator->ParseSymbol(Text_);          
          _Separator->Reset();
          _SeqState |= BRANCHSEP_DONE;          
        }

        _TriggerState &= ~FRESH;
        _TriggerState |= STARTED;

        if (!_Intersect && !_CircSeqTerm)
          if (_ParseDone)
          {
            _SeqState |= SEQUENCE_DONE;

            if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
              (*_TriggerObj)();
            else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
            {
              char Buffer_[32];
              if (_TriggerData->_FncArgr)
                strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

              if (_TriggerData->_FncArgx)
                strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-2],
                       IntToStr(_BranchNum, Buffer_));
                     
              ExecTriggerFunction();
            }

            _TriggerState |= TRIGGER_DONE;
            _TriggerState &= ~TRIGGER_FAIL;
          }
          else
          {
            _TriggerState |= TRIGGER_FAIL;
            _TriggerState &= ~TRIGGER_DONE;
          }
        
        Done_ = true;
      }
      else if (_Separator)      
      {
        Text_ = _Separator->ParseSymbol(Text_);
        _Separator->Reset();
        _SeqState |= BRANCHSEP_DONE;        
      }
    }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
char* BranchOut::ParseSymbol(char* Text_)
{
  int x;
  int lim = _SetLen - 1;
  bool Valid_;
  
  if (_Set)
  {
    _ParseValid = false;
    _ParseState &= ~FRESH;
    _ParseState |= STARTED;
  
    for (x = 0; x < _SetLen; x++)
      if (_Set[x])
      {
        ParserData()->SetScope(ScopeInfo::StatementSCOPE);
        Text_ = _Set[x]->ParseSymbol(Text_);
        Valid_ =
        _ParseDone = _Set[x]->IsParseValid();

        if (Valid_ || x == lim)
        {
          if (Valid_)
          {
            _BranchNum = x;
            _BranchFound = true;

            ParserData()->SetOrBranchNum(_BranchNum);
            ParserData()->SetBranchFound(_BranchFound);
          }
          
          ParserData()->IncPgrmIndex();
          // debug
          // ParserData()->SetScopeLevel
          //   (0, ParserData()->GetFncStkLevel(),
          //    ParserData()->GetBlkStkLevel(),
          //    ParserData()->GetPgrmIndex(), 4,
          //    ParserData()->GetPgrmIndex());

          SetGroupDone(_BranchFound);
          if (_BranchFound)
            SetGroupValid(true);
          else
            SetGroupValid(!_Required);

          if (_Separator && Valid_)
          {
            Text_ = _Separator->ParseSymbol(Text_);
            _Separator->Reset();
            _SeqState |= BRANCHSEP_DONE;            
          }

          _TriggerState &= ~FRESH;
          _TriggerState |= STARTED;
          
          if (!_Intersect && !_CircSeqTerm)
            if (_ParseDone)
            {
              _SeqState |= SEQUENCE_DONE;
          
              if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
                (*_TriggerObj)();
              else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
              {
                char Buffer_[32];
                if (_TriggerData->_FncArgr)
                  strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

                if (_TriggerData->_FncArgx)
                  strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-2],
                         IntToStr(_BranchNum, Buffer_));

                ExecTriggerFunction();
              }

              _TriggerState |= TRIGGER_DONE;
              _TriggerState &= ~TRIGGER_FAIL;
            }
            else
            {
              _TriggerState |= TRIGGER_FAIL;
              _TriggerState &= ~TRIGGER_DONE;
            }
                                                
          break;
        }
        else if (_Separator)
        {
          Text_ = _Separator->ParseSymbol(Text_);
          _Separator->Reset();
          _SeqState |= BRANCHSEP_DONE;          
        }          
      }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
// Operator Class Definition
/****************************************************************************/
OperatorSet::OperatorSet():
AggregateSymbol(6, OperatorSet_Type),
_Operand1(NULL),
_Operand2(NULL),
_Operand3(NULL),
_Resultant(NULL),
_Separator(NULL),
_Assignment(NULL),
_OpTransferred(NULL),
_OpType(0),
_OpPos(0),
_ResultOrder(0),
_ResultantState(0)
{
  InitAggSymbolStates();
}

/****************************************************************************/
OperatorSet::OperatorSet(const char* Str_, const char* WsChar_,
                         int IoType_, int DataType_, int SymAttrib_,
                         int SymType_, int Ws_, int OpType_, int OpPos_,
                         int ResultOrder_, bool SkipSpaces_, bool Required_,
                         bool CaseSensitive_, bool Ordered_):
AggregateSymbol
(
  6, OperatorSet_Type,
  Str_, WsChar_, IoType_,
  DataType_, SymAttrib_, SymType_,
  Ws_, SkipSpaces_, Required_,
  CaseSensitive_, Ordered_
),
_Operand1(NULL),
_Operand2(NULL),
_Operand3(NULL),
_Resultant(NULL),
_Separator(NULL),
_Assignment(NULL),
_OpTransferred(NULL),
_OpType(OpType_),
_OpPos(OpPos_),
_ResultOrder(ResultOrder_),
_ResultantState(0)
{
  InitAggSymbolStates();
}

/****************************************************************************/
OperatorSet::OperatorSet(const OperatorSet& Obj_):
AggregateSymbol(6, OperatorSet_Type, Obj_),
_Operand1(Obj_._Operand1 ? Obj_._Operand1->Clone():NULL),
_Operand2(Obj_._Operand2 ? Obj_._Operand2->Clone():NULL),
_Operand3(Obj_._Operand3 ? Obj_._Operand3->Clone():NULL),
_Resultant(Obj_._Resultant ? Obj_._Resultant->Clone():NULL),
_Separator(Obj_._Separator),
_Assignment(Obj_._Assignment ? Obj_._Assignment->Clone():NULL),
_OpType(Obj_._OpType),
_OpPos(Obj_._OpPos),
_ResultOrder(Obj_._ResultOrder),
_ResultantState(Obj_._ResultantState)
{
  InitAggSymbolStates();

  SymbolSet* Delim_ = _AggsArray[OPERANDSEP_INDEX];
  _AggsArray[OPERANDSEP_INDEX] = _Separator = NULL;
  
  if (Delim_)
    SetDelimiter(Delim_, false);
}

/****************************************************************************/
void OperatorSet::InitAggSymbolStates()
{
  SetAggsStates(RESULTANT_INDEX, NO_RESULTANT_REQ, RESULTANT_REQ, RESULTANT_DONE);
  SetAggsStates(OPERAND1_INDEX, NO_OPERAND1_REQ, OPERAND1_REQ, OPERAND1_DONE);
  SetAggsStates(OPERAND2_INDEX, NO_OPERAND2_REQ, OPERAND2_REQ, OPERAND2_DONE);
  SetAggsStates(OPERAND3_INDEX, NO_OPERAND3_REQ, OPERAND3_REQ, OPERAND3_DONE);
  SetAggsStates(OPERANDSEP_INDEX, NO_OPERANDSEP_REQ, OPERANDSEP_REQ, OPERANDSEP_DONE);
  SetAggsStates(ASSIGNMENT_INDEX, NO_ASSIGNMENT_REQ, ASSIGNMENT_REQ, ASSIGNMENT_DONE);

  SetAggsRequired();
  
  _Resultant = _AggsArray[RESULTANT_INDEX];
  _Operand1 = _AggsArray[OPERAND1_INDEX];
  _Operand2 = _AggsArray[OPERAND2_INDEX];
  _Operand3 = _AggsArray[OPERAND3_INDEX];
  _Separator = _AggsArray[OPERANDSEP_INDEX];
  _Assignment = _AggsArray[ASSIGNMENT_INDEX];  
  _OpTransferred = _AggsTransferred;  
}

/****************************************************************************/
bool OperatorSet::OpTransferred(int Index_) const
{
  if (RESULTANT_INDEX <= Index_ && Index_ < ASSIGNMENT_INDEX)
    return _AggsTransferred[Index_];  

  return true;
}

/****************************************************************************/
SymbolSet* OperatorSet::Clone() const
{
  OperatorSet* Retval_ = new OperatorSet(*this);
  return Retval_;
}

/****************************************************************************/
SymbolSet& OperatorSet::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {
    if (Obj_.IsOperatorSet())
    {
      SymbolSet* Delim_ = _Separator;
      bool DelimTrans_ = _OpTransferred[OPERANDSEP_INDEX];
      OperatorSet* sObj_ = ((OperatorSet*)(&Obj_));

      if (_Separator != sObj_->_Separator)
        _AggsArray[OPERANDSEP_INDEX] = _Separator = NULL;

      AggregateSymbol::operator = (Obj_);

      _OpType = sObj_->_OpType;
      _ResultantState = sObj_->_ResultantState;
      _ResultOrder = sObj_->_ResultOrder;      
      
      _Separator = Delim_;
      SymbolSet* DelimPtr_ = _AggsArray[OPERANDSEP_INDEX];
      _AggsArray[OPERANDSEP_INDEX] = NULL;

      if (_Separator != DelimPtr_)
      {
        _OpTransferred[OPERANDSEP_INDEX] = DelimTrans_;
        if (_OpTransferred[OPERANDSEP_INDEX])
          _Separator = NULL;
        
        SetSeparator(DelimPtr_, false);
      }
      else
        _AggsArray[OPERANDSEP_INDEX] = DelimPtr_;

      _Resultant = _AggsArray[RESULTANT_INDEX];
      _Operand1 = _AggsArray[OPERAND1_INDEX];
      _Operand2 = _AggsArray[OPERAND2_INDEX];
      _Operand3 = _AggsArray[OPERAND3_INDEX];
      _Separator = _AggsArray[OPERANDSEP_INDEX];
      _Assignment = _AggsArray[ASSIGNMENT_INDEX];
    }
    else
      SymbolSet::operator = (Obj_);
  }
  
  return *this;
}

/****************************************************************************/
int OperatorSet::GetOperatorRequired() const
{
  return GetAggsRequired();
}

/****************************************************************************/
int OperatorSet::GetOperatorState() const
{
  return GetAggsState();
}

/****************************************************************************/
int* OperatorSet::GetResultantState()
{
  return &_ResultantState;
}

/****************************************************************************/
int OperatorSet::GetOperatorType() const
{
  return _OpType;
}

/****************************************************************************/
int OperatorSet::GetResultOrder() const
{
  return _ResultOrder;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetOperatorType(int Type_)
{
  _OpType = Type_;
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetResultOrder(int Order_)
{
  _ResultOrder = Order_;
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetSeparator(SymbolSet* Delim_, bool Overwrite_)
{
  int len = 0;
  int x;

  if (Delim_)
  {
    if (Delim_ != _Separator)
    {
      len = _Separator ? ::SafeStrLen(_Separator->GetSymbol(false)):0;
      if (len > 1)
      {
        if (_Operand2)
          _Operand2->ClearSeparatorString();
      }

      if (Delim_ != _Separator && !_OpTransferred[OPERANDSEP_INDEX])
        delete _Separator;
    }

    len = ::SafeStrLen(Delim_->GetSymbol(false));
    _Separator = Overwrite_ ? Delim_->Clone():Delim_;
    _OpTransferred[OPERANDSEP_INDEX] = Overwrite_ ? false:Delim_->OpTransferred(OPERANDSEP_INDEX);
    _Separator->SetSoloSymbol(false);
    
    if (len == 1)
    {
      if (_Operand2)
        _Operand2->SetStringTerminator(*_Separator->GetSymbol(false));
    }
    else
    {
      if (_Operand2)
      {
        _Operand2->SetStringTerminator(' ');
        if (len)
          _Operand2->SetSeparatorString(_Separator->GetSymbol(false));
      }
    }

    _AggsRequired |= OPERANDSEP_REQ;
    _AggsRequired &= ~NO_OPERANDSEP_REQ;
    _AggsArray[OPERANDSEP_INDEX] = _Separator;
  }
  else
  {
    len = _Separator ? ::SafeStrLen(_Separator->GetSymbol(false)):0;    
    if (len > 1)
    {
      if (_Operand2)
        _Operand2->ClearSeparatorString();
    }

    if (!_OpTransferred[OPERANDSEP_INDEX])
      delete _Separator;
      
    _Separator = NULL;
    _AggsRequired |= NO_OPERANDSEP_REQ;
    _AggsRequired &= ~OPERANDSEP_REQ;
    _AggsArray[OPERANDSEP_INDEX] = _Separator;    
  }
  
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetAssignment(SymbolSet* Assign_, bool Overwrite_)
{
  SetAggs(ASSIGNMENT_INDEX, 0, Assign_, Overwrite_);
  _Assignment = _AggsArray[ASSIGNMENT_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetOperand1(SymbolSet* Operand_, bool Overwrite_)
{
  SetAggs(OPERAND1_INDEX, 0, Operand_, Overwrite_);
  _Operand1 = _AggsArray[OPERAND1_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetOperand2(SymbolSet* Operand_, bool Overwrite_)
{
  SetAggs(OPERAND2_INDEX, 0, Operand_, Overwrite_);
  _Operand2 = _AggsArray[OPERAND2_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetOperand3(SymbolSet* Operand_, bool Overwrite_)
{
  SetAggs(OPERAND3_INDEX, 0, Operand_, Overwrite_);
  _Operand3 = _AggsArray[OPERAND3_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetResultant(SymbolSet* Result_, bool Overwrite_)
{
  SetAggs(RESULTANT_INDEX, 0, Result_, Overwrite_);
  _Resultant = _AggsArray[RESULTANT_INDEX];
  
  return *this;
}

/****************************************************************************/
bool OperatorSet::HasResultant() const
{
  return
  (
    _Resultant != NULL &&
    (_AggsRequired & RESULTANT_REQ)
  );
}

/****************************************************************************/
bool OperatorSet::HasOperand1() const
{
  return
  (
    _Operand1 != NULL &&
    (_AggsRequired & OPERAND1_REQ)
  );  
}

/****************************************************************************/
bool OperatorSet::HasOperand2() const
{
  return
  (
    _Operand2 != NULL &&
    (_AggsRequired & OPERAND2_REQ)
  );  
}

/****************************************************************************/
bool OperatorSet::HasOperand3() const
{
  return
  (
    _Operand3 != NULL &&
    (_AggsRequired & OPERAND3_REQ)
  );  
}

/****************************************************************************/
bool OperatorSet::HasSeparator() const
{
  return
  (
    _Separator != NULL &&
    (_AggsRequired & OPERANDSEP_REQ)
  );  
}

/****************************************************************************/
bool OperatorSet::HasAssignment() const
{
  return
  (
    _Assignment != NULL &&
    (_AggsRequired & ASSIGNMENT_REQ)
  );  
}

/****************************************************************************/
SymbolSet* OperatorSet::Separator(bool Transfer_)
{
  return GetAggs(OPERANDSEP_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet* OperatorSet::Assignment(bool Transfer_)
{
  return GetAggs(ASSIGNMENT_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet* OperatorSet::Operand1(bool Transfer_)
{
  return GetAggs(OPERAND1_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet* OperatorSet::Operand2(bool Transfer_)
{
  return GetAggs(OPERAND2_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet* OperatorSet::Operand3(bool Transfer_)
{
  return GetAggs(OPERAND3_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet* OperatorSet::Resultant(bool Transfer_)
{
  return GetAggs(RESULTANT_INDEX, 0, Transfer_);
}

/****************************************************************************/
SymbolSet& OperatorSet::SetStateChangeObject(ObjectFunctor* Obj_)
{
  SymbolSet::SetStateChangeObject(Obj_);    
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetStateChangeFunction(int(*Fnc_)(int, char**, void*),
                                             int FncArgc_, char** FncArgv_,
                                             bool ResultArg_, bool BranchArg_,
                                             void* FncArgi_)
{
  SymbolSet::SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                    ResultArg_, BranchArg_, FncArgi_);
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetTriggerObject(ObjectFunctor* Obj_)
{
  SymbolSet::SetTriggerObject(Obj_);    
  return *this;
}

/****************************************************************************/
SymbolSet& OperatorSet::SetTriggerFunction(int(*Fnc_)(int, char**, void*),
                                         int FncArgc_, char** FncArgv_,
                                         bool ResultArg_, bool BranchArg_,
                                         void* FncArgi_)
{
  SymbolSet::SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                ResultArg_, BranchArg_, FncArgi_);
  return *this;
}

/****************************************************************************/
SymbolSet::TriggerFncData* OperatorSet::GiveTriggerFncData()
{
  return SymbolSet::GiveTriggerFncData();
}

/****************************************************************************/
SymbolSet::StateChangeFncData* OperatorSet::GiveStateChangeFncData()
{
  return SymbolSet::GiveStateChangeFncData();
}

/****************************************************************************/
ObjectFunctor* OperatorSet::GiveTriggerObject()
{
  return SymbolSet::GiveTriggerObject();
}

/****************************************************************************/
ObjectFunctor* OperatorSet::GiveStateChangeObject()
{
  return SymbolSet::GiveStateChangeObject();
}

/****************************************************************************/
char* OperatorSet::ParseOperandSymbol(int OpNumber_, bool OperatorDone_, char* Text_)
{
  bool Cont_ = false;
  SymbolSet* OpPtr_ = OpNumber_ == 1 ? _Operand1:
                      OpNumber_ == 2 ? _Operand2:
                      OpNumber_ == 3 ? _Operand3:NULL;

  int OpReq_ = OpNumber_ == 1 ? OPERAND1_REQ:
               OpNumber_ == 2 ? OPERAND2_REQ:
               OpNumber_ == 3 ? OPERAND3_REQ:NULL;

  int OpDone_ = OpNumber_ == 1 ? OPERAND1_DONE:
                OpNumber_ == 2 ? OPERAND2_DONE:
                OpNumber_ == 3 ? OPERAND3_DONE:NULL;

  if (!OpPtr_ || OpNumber_ == 3 && !_Separator)
    return Text_;

  if (SymRequiredState_Check(OpPtr_, OpReq_, OpDone_))
  {
    if (OpNumber_ == 3)    
    {
      Text_ = _Separator->ParseSymbol(Text_);
      Text_ = OpPtr_->ParseSymbol(Text_);    
    }
    else
      Text_ = OpPtr_->ParseSymbol(Text_);
    
    if (OpPtr_->IsParseValid())
    {
      _AggsState |= OpDone_;

      if (OpNumber_ != 3)
      {
        Cont_ =
        (!OperatorDone_ && SymState_Check(_Char, OPERATOR_DONE)) ||        
        (OpNumber_ == 1 && _OpType != UnaryOp &&
           SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE)) ||
        (OpNumber_ == 2 && _OpType == TrinaryOp &&
          (SymRequiredState_Check(_Separator, OPERANDSEP_REQ, OPERANDSEP_DONE) ||
           SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE)));

        if (!Cont_)
        {
          if ((OpNumber_ == 1 && _OpType == UnaryOp) ||
              (OpNumber_ == 2 && _OpType == BinaryOp))
          {
            SetGroupValid(true);
            SetGroupDone(true);
          }
          else
          {
            SetGroupDone(false);
            SetGroupValid(!_Required);
          }

          #if SYMBOLSET_DEBUG
            ParserData()->ShowData(cout);
          #endif
          return Text_;
        }                                 
      }
      else
      {
        Cont_ =
        _OpPos == PostFixed &&
        (!OperatorDone_ && SymState_Check(_Char, OPERATOR_DONE));

        if (!Cont_)
        {
          if (_OpPos != PostFixed)
          {
            SetGroupValid(true);
            SetGroupDone(true);
          }
          else
          {
            SetGroupDone(false);
            SetGroupValid(!_Required);
          }          
        }
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;  
}

/****************************************************************************/
char* OperatorSet::ParseOperatorSymbol(char* Text_, bool& OperatorDone_)
{
  bool Cont_ = false;

  if ((_Char || _DataType != NO_DATA) && !(_AggsState & OPERATOR_DONE))
  {
    Text_ = SymbolSet::ParseSymbol(Text_);
    
    if (IsParseValid())
    {
      _AggsState |= OPERATOR_DONE;
      OperatorDone_ = true;

      Cont_ =
      _OpPos != PostFixed &&      
      (_OpType != UnaryOp &&
       SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE));


      if (!Cont_)
      {
        if (_OpPos == PostFixed || _OpType == UnaryOp)
        {
          SetGroupValid(true);
          SetGroupDone(true);
        }
        else
        {
          SetGroupDone(false);
          SetGroupValid(!_Required);
        }

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif
        return Text_;
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;  
}

/****************************************************************************/
// -<symbolname:OperatorSet_Type:OperatorSymbol:datatype:
//   opType[:Separator=c {if opType==TrinaryOp}]:
//   opPos[:ResultPreOp|ResultPostOp]
//   [:Resultant:defined_datatype=c[:AssignStr=c]]
//   [:Operand1:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand2:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand3:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]];>
//
char* OperatorSet::ParseSymbolStep(char* Text_, bool& Done_)
{
  if (!Done_)
  {
    bool OperatorDone_ = false;
    bool Cont_ = false;
    _ParseState &= ~FRESH;
    _ParseState |= STARTED;

    if (SymRequiredState_Check(_Resultant, RESULTANT_REQ, RESULTANT_DONE) &&
        SymRequiredState_Check(_Assignment, ASSIGNMENT_REQ, ASSIGNMENT_DONE))
    {
      Text_ = _Resultant->ParseSymbol(Text_);
      Text_ = _Assignment->ParseSymbol(Text_);

      if (_Resultant->IsParseValid() && _Assignment->IsParseValid())
      {
        _AggsState |= RESULTANT_DONE;
        _AggsState |= ASSIGNMENT_DONE;
      
        Cont_ =
        SymState_Check(_Char, OPERATOR_DONE) ||
        SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE) ||
        (_OpType != UnaryOp &&
          SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE)) ||
        (_OpType == TrinaryOp &&
          (SymRequiredState_Check(_Separator, OPERANDSEP_REQ, OPERANDSEP_DONE) ||
           SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE)));

        if (!Cont_)
        {
          Done_ = true;
        
          if (_Operand1)
          {
            SetGroupValid(true);
            SetGroupDone(true);
          }
          else
          {
            SetGroupDone(false);
            SetGroupValid(!_Required);
          }
        }
      }
      else
      {
        Done_ = true;      
        SetGroupDone(false);
        SetGroupValid(!_Required);
      }

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;      
    }

    if (_Resultant && _Assignment &&
        !_Resultant->IsParseDone() &&
        !_Assignment->IsParseDone())
      return Text_;

    if (_OpPos == PreFixed)
    {
      if (SymState_Check(_Char, OPERATOR_DONE))
      {
        Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
        return Text_;
      }
      else if (_Resultant &&
               SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
      {
        Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
        Done_ = true;
        goto CheckTrigger1;
      }
      else if (!_Operand1)
      {
        Done_ = true;
        goto CheckTrigger1;
      }
    
      if (IsParseDone())
      {
        if (SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
        {
          Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
          if (!_Operand2)
          {
            Done_ = true;
            goto CheckTrigger1;
          }
            
          return Text_;
        }
        else if (!_Operand1)
        {
          Done_ = true;
          goto CheckTrigger1;          
        }

        if (_Operand1->IsParseDone() && _OpType != UnaryOp &&
            SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
        {
          Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
          if (!_Operand3 || _OpType == BinaryOp)
          {
            Done_ = true;
            goto CheckTrigger1;            
          }
          
          return Text_;
        }
        else if (!_Operand2)
        {
          Done_ = true;
          goto CheckTrigger1;
        }

        if (_Operand2->IsParseDone() && _OpType == TrinaryOp &&
            SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
        {
          Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
          Done_ = true;
          goto CheckTrigger1;
        }
        else if (!_Operand3)
        {
          Done_ = true;
          goto CheckTrigger1;
        }
      }
    }
    else
    {
      if (SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
      {
        Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
        if (!_Char)
        {
          Done_ = true;
          goto CheckTrigger1;
        }
        
        return Text_;
      }
      else if (!_Operand1)
      {
        Done_ = true;
        goto CheckTrigger1;
      }
    
      if (_Operand1->IsParseDone())
      {
        if (_OpPos == InFixed)
        {
          if (SymState_Check(_Char, OPERATOR_DONE))
          {
            Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
            if (!_Operand2 || _OpType == UnaryOp)
            {
              Done_ = true;
              goto CheckTrigger1;              
            }
            
            return Text_;
          }
          else if (!_Char)
          {
            Done_ = true;
            goto CheckTrigger1;            
          }

          if (IsParseDone() && _OpType != UnaryOp &&
              SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
          {
            Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
            if (!_Operand3 || _OpType == BinaryOp)
            {
              Done_ = true;
              goto CheckTrigger1;
            }
            
            return Text_;
          }
          else if (!_Operand2)
          {
            Done_ = true;
            goto CheckTrigger1;            
          }

          if (_Operand2->IsParseDone() && _OpType == TrinaryOp &&
              SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
          {
            Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
            Done_ = true;
            goto CheckTrigger1;            
          }
          else if (!_Operand3)
          {
            Done_ = true;
            goto CheckTrigger1;            
          }
        }
        else
        {
          if (_OpType == UnaryOp)
          {
            if (SymState_Check(_Char, OPERATOR_DONE))
            {
              Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
              Done_ = true;
              goto CheckTrigger1;
            }
            else if (!_Char)
            {
              Done_ = true;
              goto CheckTrigger1;
            }
          }
          else
          {
            if (SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
            {
              Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
              if (_OpType == BinaryOp && !_Char ||
                  _OpType == TrinaryOp && !_Operand3)
              {
                Done_ = true;
                goto CheckTrigger1;
              }
              
              return Text_;
            }
            else if (!_Operand2)
            {
              Done_ = true;
              goto CheckTrigger1;
            }

            if (_Operand2->IsParseDone())
            {
              if (_OpType == BinaryOp &&
                  SymState_Check(_Char, OPERATOR_DONE))
              {
                Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
                if (!_Operand3 || _OpType == BinaryOp)
                {
                  Done_ = true;
                  goto CheckTrigger1;
                }
                
                return Text_;
              }
              else
              {
                if (_OpType == TrinaryOp &&
                    SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
                {
                  Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
                  if (!_Char)
                  {
                    Done_ = true;
                    goto CheckTrigger1;
                  }

                  return Text_;
                }
                else if (!_Operand3)
                {
                  Done_ = true;
                  goto CheckTrigger1;
                }

                if (_Operand3->IsParseDone() &&
                    SymState_Check(_Char, OPERATOR_DONE))
                {
                  Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
                  Done_ = true;
                }
                else
                  Done_ = true;
              }
            }
          }
        }
      }
    }

CheckTrigger1:
    _TriggerState &= ~FRESH;
    _TriggerState |= STARTED;
    
    if (_ParseDone && _GroupDone)
    {
      if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
        (*_TriggerObj)();
      else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
      {
        if (_TriggerData->_FncArgr)
          strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

        ExecTriggerFunction();
      }

      _TriggerState |= TRIGGER_DONE;
      _TriggerState &= ~TRIGGER_FAIL;
    }
    else
    {
      _TriggerState |= TRIGGER_FAIL;
      _TriggerState &= ~TRIGGER_DONE;
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
// -<symbolname:OperatorSet_Type:OperatorSymbol:datatype:
//   opType[:Separator=c {if opType==TrinaryOp}]:
//   opPos[:ResultPreOp|ResultPostOp]
//   [:Resultant:defined_datatype=c[:AssignStr=c]]
//   [:Operand1:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand2:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]]
//   [:Operand3:operand_datatype[=c {if opdt==defined | opdt==icasedefined}]];>
//
char* OperatorSet::ParseSymbol(char* Text_)
{
  bool OperatorDone_ = false;
  bool Cont_ = false;
  _ParseState &= ~FRESH;
  _ParseState |= STARTED;

  if (SymRequiredState_Check(_Resultant, RESULTANT_REQ, RESULTANT_DONE) &&
      SymRequiredState_Check(_Assignment, ASSIGNMENT_REQ, ASSIGNMENT_DONE))
  {
    Text_ = _Resultant->ParseSymbol(Text_);
    Text_ = _Assignment->ParseSymbol(Text_);

    if (_Resultant->IsParseValid() && _Assignment->IsParseValid())
    {
      _AggsState |= RESULTANT_DONE;
      _AggsState |= ASSIGNMENT_DONE;
      
      Cont_ =
      SymState_Check(_Char, OPERATOR_DONE) ||
      SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE) ||
      (_OpType != UnaryOp &&
        SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE)) ||
      (_OpType == TrinaryOp &&
        (SymRequiredState_Check(_Separator, OPERANDSEP_REQ, OPERANDSEP_DONE) ||
         SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE)));

      if (!Cont_)
      {        
        if (_Operand1)
        {
          SetGroupValid(true);
          SetGroupDone(true);
        }
        else
        {
          SetGroupDone(false);
          SetGroupValid(!_Required);
        }

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif
        return Text_;
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif
      return Text_;
    }
  }

  if (_Resultant && _Assignment &&
      !_Resultant->IsParseDone() &&
      !_Assignment->IsParseDone())
    return Text_;

  if (_OpPos == PreFixed)
  {
    if (SymState_Check(_Char, OPERATOR_DONE))
      Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
    else if (_Resultant &&
             SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
    {
      Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
      goto CheckTrigger2;
    }
    else if (!_Operand1)
      goto CheckTrigger2;    
    
    if (IsParseDone())
    {
      if (SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
      {
        Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
        if (!_Operand2)
          goto CheckTrigger2;
      }
      else if (!_Operand1)
        goto CheckTrigger2;

      if (_Operand1->IsParseDone() && _OpType != UnaryOp &&
          SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
      {
        Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
        if (!_Operand3 || _OpType == BinaryOp)
          goto CheckTrigger2;
      }
      else if (!_Operand2)
        goto CheckTrigger2;

      if (_Operand2->IsParseDone() && _OpType == TrinaryOp &&
          SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
      {
        Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
        goto CheckTrigger2;
      }
      else if (!_Operand3)
        goto CheckTrigger2;
    }
  }
  else
  {
    if (SymRequiredState_Check(_Operand1, OPERAND1_REQ, OPERAND1_DONE))
    {
      Text_ = ParseOperandSymbol(1, OperatorDone_, Text_);
      if (!_Char)
        goto CheckTrigger2;
    }
    else if (!_Operand1)
      goto CheckTrigger2;    
    
    if (_Operand1->IsParseDone())
    {
      if (_OpPos == InFixed)
      {
        if (SymState_Check(_Char, OPERATOR_DONE))
        {
          Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
          if (!_Operand2 || _OpType == UnaryOp)
            goto CheckTrigger2;
        }
        else if (!_Char)
          goto CheckTrigger2;

        if (IsParseDone() && _OpType != UnaryOp &&
            SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
        {
          Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
          if (!_Operand3 || _OpType == BinaryOp)
            goto CheckTrigger2;
        }
        else if (!_Operand2)
          goto CheckTrigger2;

        if (_Operand2->IsParseDone() && _OpType == TrinaryOp &&
            SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
        {
          Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
          goto CheckTrigger2;
        }
        else if (!_Operand3)
          goto CheckTrigger2;
      }
      else
      {
        if (_OpType == UnaryOp)
        {
          if (SymState_Check(_Char, OPERATOR_DONE))
          {
            Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
            goto CheckTrigger2;            
          }
          else if (!_Char)
            goto CheckTrigger2;          
        }
        else
        {
          if (SymRequiredState_Check(_Operand2, OPERAND2_REQ, OPERAND2_DONE))
          {
            Text_ = ParseOperandSymbol(2, OperatorDone_, Text_);
            if (_OpType == BinaryOp && !_Char ||
                _OpType == TrinaryOp && !_Operand3)
              goto CheckTrigger2;
          }
          else if (!_Operand2)
            goto CheckTrigger2;          
          
          if (_Operand2->IsParseDone())
          {
            if (_OpType == BinaryOp &&
                SymState_Check(_Char, OPERATOR_DONE))
            {
              Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
              if (!_Operand3 || _OpType == BinaryOp)
                goto CheckTrigger2;
            }
            else
            {
              if (_OpType == TrinaryOp &&
                  SymRequiredState_Check(_Operand3, OPERAND3_REQ, OPERAND3_DONE))
              {
                Text_ = ParseOperandSymbol(3, OperatorDone_, Text_);
                if (!_Char)
                  goto CheckTrigger2;
              }
              else if (!_Operand3)
                goto CheckTrigger2;              
              
              if (_Operand3->IsParseDone() &&
                  SymState_Check(_Char, OPERATOR_DONE))
                Text_ = ParseOperatorSymbol(Text_, OperatorDone_);
            }
          }
        }
      }
    }
  }

CheckTrigger2:
  _TriggerState &= ~FRESH;
  _TriggerState |= STARTED;
    
  if (_ParseDone && _GroupDone)
  {
    if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
      (*_TriggerObj)();
    else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
    {
      if (_TriggerData->_FncArgr)
        strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

      ExecTriggerFunction();
    }

    _TriggerState |= TRIGGER_DONE;
    _TriggerState &= ~TRIGGER_FAIL;
  }
  else
  {
    _TriggerState |= TRIGGER_FAIL;
    _TriggerState &= ~TRIGGER_DONE;
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
int OperatorSet::AggregateType() const
{
  return OperatorSet_Type;
}

/****************************************************************************/
bool OperatorSet::IsOperatorSet(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsOperatorSet(FollowEnclosing_);

  return true;
}

/****************************************************************************/
// BracketedSymbol class definition
/****************************************************************************/
BracketedSymbol::BracketedSymbol():
AggregateSymbol(4, BracketedSymbol_Type),
_Left(NULL),
_Delimiter(NULL),
_Next(NULL),
_Right(NULL),
_BlockInc(0),
_FunctionInc(0),
_BlockDec(0),
_FunctionDec(0),
_ArgCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_DelimCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_SharedCnt(false)
{
  *_ArgCounter = *_DelimCounter = 0;
  InitAggSymbolStates();
}

/****************************************************************************/
BracketedSymbol::BracketedSymbol(const char* Str_, const char* WsChar_,
                                 int IoType_, int DataType_, int Attrib_,
                                 int Type_, int Ws_, bool SkipSpaces_,
                                 bool Required_, bool CaseSensitive_,
                                 bool Ordered_):
AggregateSymbol
(
  4, BracketedSymbol_Type,
  Str_, WsChar_, IoType_,
  DataType_, Attrib_, Type_,
  Ws_, SkipSpaces_, Required_,
  CaseSensitive_, Ordered_
),
_Left(NULL),
_Delimiter(NULL),
_Next(NULL),
_Right(NULL),
_BlockInc(0),
_FunctionInc(0),
_BlockDec(0),
_FunctionDec(0),
_ArgCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_DelimCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_SharedCnt(false)
{
  *_ArgCounter = *_DelimCounter = 0;
  InitAggSymbolStates();  
}

/****************************************************************************/
BracketedSymbol::BracketedSymbol(const BracketedSymbol& Obj_):
AggregateSymbol(4, BracketedSymbol_Type, Obj_),
_Left(NULL),
_Delimiter(NULL),
_Next(NULL),
_Right(NULL),
_BlockInc(Obj_._BlockInc),
_FunctionInc(Obj_._FunctionInc),
_BlockDec(Obj_._BlockDec),
_FunctionDec(Obj_._FunctionDec),
_ArgCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_DelimCounter((int*)RawAllocateWith(MEMMATRIX, sizeof(int))),
_SharedCnt(false)
{
  InitAggSymbolStates();  
  
  SymbolSet* Delim_ = _AggsArray[SYMDELIM_INDEX];
  _AggsArray[SYMDELIM_INDEX] = _Delimiter = NULL;
  
  if (Delim_)
    SetDelimiter(Delim_, false);

  if (_Next)
    _Next->SetEnclosing(this);

  if (_Enclosing)
  {
    ::Delete(_ArgCounter);
    ::Delete(_DelimCounter);
    _ArgCounter = Obj_._ArgCounter;
    _DelimCounter = Obj_._DelimCounter;
    _SharedCnt = true;
  }
  else
  {
    *_ArgCounter = *Obj_._ArgCounter;
    *_DelimCounter = *Obj_._DelimCounter;
  }
}

/****************************************************************************/
BracketedSymbol::~BracketedSymbol()
{
  if (!_SharedCnt)
  {
    delete _ArgCounter;
    delete _DelimCounter;
  }
}

/****************************************************************************/
void BracketedSymbol::InitAggSymbolStates()
{
  SetAggsStates(LEFTBRK_INDEX, NO_LEFTBRK_REQ, LEFTBRK_REQ, LEFTBRK_DONE);
  SetAggsStates(SYMDELIM_INDEX, NO_SYMDELIM_REQ, SYMDELIM_REQ, SYMDELIM_DONE);
  SetAggsStates(NEXTSYM_INDEX, NO_NEXTSYM_REQ, NEXTSYM_REQ, NEXTSYM_DONE);
  SetAggsStates(RIGHTBRK_INDEX, NO_RIGHTBRK_REQ, RIGHTBRK_REQ, RIGHTBRK_DONE);
  
  SetAggsRequired();
  SetNestingSymbol(NEXTSYM_INDEX);

  _Left = _AggsArray[LEFTBRK_INDEX];
  _Right = _AggsArray[RIGHTBRK_INDEX];
  _Next = _AggsArray[NEXTSYM_INDEX];
  _Delimiter = _AggsArray[SYMDELIM_INDEX];
  _BrkSymTransferred = _AggsTransferred;  
}

/****************************************************************************/
bool BracketedSymbol::BrkSymTransferred(int Index_) const
{
  if (LEFTBRK_INDEX <= Index_ && Index_ < RIGHTBRK_INDEX)
    return _AggsTransferred[Index_];

  return true;
}

/****************************************************************************/
SymbolSet* BracketedSymbol::Clone() const
{
  BracketedSymbol* Retval_ = new BracketedSymbol(*this);
  return Retval_;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::operator = (const SymbolSet& Obj_)
{
  if (this != &Obj_)
  {
    if (Obj_.IsBracketedSymbol())
    {
      SymbolSet* SymPtr_ = _Enclosing;    
      SymbolSet* Delim_ = _Delimiter;
      bool DelimTrans_ = _BrkSymTransferred[SYMDELIM_INDEX];      
      BracketedSymbol* sObj_ = ((BracketedSymbol*)(&Obj_));      

      if (_Delimiter != sObj_->_Delimiter)
        _AggsArray[SYMDELIM_INDEX] = _Delimiter = NULL;

      AggregateSymbol::operator = (Obj_);

      _BlockInc = sObj_->_BlockInc;
      _FunctionInc = sObj_->_FunctionInc;
      _BlockDec = sObj_->_BlockDec;
      _FunctionDec = sObj_->_FunctionDec;
      
      _Delimiter = Delim_;
      SymbolSet* DelimPtr_ = _AggsArray[SYMDELIM_INDEX];
      _AggsArray[SYMDELIM_INDEX] = NULL;

      if (_Delimiter != DelimPtr_)
      {
        _BrkSymTransferred[SYMDELIM_INDEX] = DelimTrans_;
        if (_BrkSymTransferred[SYMDELIM_INDEX])
          _Delimiter = NULL;
        
        SetDelimiter(DelimPtr_, false);
      }
      else
        _AggsArray[SYMDELIM_INDEX] = DelimPtr_;

      _Left = _AggsArray[LEFTBRK_INDEX];
      _Right = _AggsArray[RIGHTBRK_INDEX];
      _Next = _AggsArray[NEXTSYM_INDEX];
      _Delimiter = _AggsArray[SYMDELIM_INDEX];
            
      if (_Next)
        _Next->SetEnclosing(this);

      if (SymPtr_)
      {
        if (_Enclosing)
        {
          _ArgCounter = sObj_->_ArgCounter;
          _DelimCounter = sObj_->_DelimCounter;
          _SharedCnt = true;
        }
        else
        {
          _ArgCounter = (int*)RawAllocateWith(MEMMATRIX, sizeof(int));
          _DelimCounter = (int*)RawAllocateWith(MEMMATRIX, sizeof(int));
          *_ArgCounter = *sObj_->_ArgCounter;
          *_DelimCounter = *sObj_->_DelimCounter;
          _SharedCnt = false;
        }
      }
      else
      {
        if (_Enclosing)
        {
          if (!_SharedCnt)
          {
            ::Delete(_ArgCounter);
            ::Delete(_DelimCounter);
          }
          
          _ArgCounter = sObj_->_ArgCounter;
          _DelimCounter = sObj_->_DelimCounter;
          _SharedCnt = true;
        }
        else
        {
          *_ArgCounter = *sObj_->_ArgCounter;
          *_DelimCounter = *sObj_->_DelimCounter;
          _SharedCnt = false;
        }
      }
    }
    else
      SymbolSet::operator = (Obj_);
  }
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetEnclosing(SymbolSet* Enclosing_)
{
  if (!Enclosing_)
    return *this;

  _Enclosing = Enclosing_;  

  if (Enclosing_->HasLeftBracket() &&
      Enclosing_->HasNext() &&
      HasLeftBracket() && _BlockInc)
  {
    // Reset argument and delimiter count for bracketed symbols enclosed
    // within another set of bracketed symbols, so you start off with zero
    // instead of inheriting the args and delims count from the parent symbol
    if (_SharedCnt)
    {
      _ArgCounter = (int*)RawAllocateWith(MEMMATRIX, sizeof(int));
      _DelimCounter = (int*)RawAllocateWith(MEMMATRIX, sizeof(int));
      *_ArgCounter = *_DelimCounter = 0;
      _SharedCnt = false;
    }
    else
      *_ArgCounter = *_DelimCounter = 0;
  }
  else if (Enclosing_->IsBracketedSymbol())
  {
    BracketedSymbol* sObj_ = (BracketedSymbol*)Enclosing_;

    if (!_SharedCnt)
    {
      ::Delete(_ArgCounter);
      ::Delete(_DelimCounter);
    }

    // if the parent symbol is not bracketed then we're assuming that what
    // is enclosed is the next argument within the bracketed symbol argument
    // list which means the next link in the argument chain should share the
    // same argument and delimter count as the enclosing symbol.
    _ArgCounter = sObj_->_ArgCounter;
    _DelimCounter = sObj_->_DelimCounter;
    _SharedCnt = true;
  }
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetLeftBracket(SymbolSet* Left_, bool Overwrite_)
{
  SetAggs(LEFTBRK_INDEX, 0, Left_, Overwrite_);
  _Left = _AggsArray[LEFTBRK_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetRightBracket(SymbolSet* Right_, bool Overwrite_)
{
  SetAggs(RIGHTBRK_INDEX, 0, Right_, Overwrite_);
  _Right = _AggsArray[RIGHTBRK_INDEX];
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetStartDelim(const char* Start_, bool Cs_, bool Ord_)
{
  SymbolSet* StartSym_ =
  new SymbolSet(Start_, GetWspaceChar(), SymbolSet::INPUT,
                SymbolSet::DEFINED, LeftBracket, BracketedSymbol_Type,
                GetWspace(), GetSkipSpaces(), true, Cs_, Ord_);

  return SetLeftBracket(StartSym_);
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetEndDelim(const char* End_, bool Cs_, bool Ord_)
{
  SymbolSet* EndSym_ =
  new SymbolSet(End_, GetWspaceChar(), SymbolSet::INPUT,
                SymbolSet::DEFINED, RightBracket, BracketedSymbol_Type,
                GetWspace(), GetSkipSpaces(), true, Cs_, Ord_);

  return SetRightBracket(EndSym_);
}

/****************************************************************************/
char* BracketedSymbol::GetStartDelim() const
{
  return _Left->GetSymbol(false);
}

/****************************************************************************/
char* BracketedSymbol::GetEndDelim() const
{
  return _Right->GetSymbol(false);
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetNext(SymbolSet* Next_, bool Overwrite_)
{
  SetAggs(NEXTSYM_INDEX, 0, Next_, Overwrite_);
  _Next = _AggsArray[NEXTSYM_INDEX];
  _Next->SetEnclosing(this);
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetDelimiter(SymbolSet* Delim_, bool Overwrite_)
{
  int len = 0;

  if (Delim_)
  {    
    if (Delim_ != _Delimiter)
    {
      len = _Delimiter ? ::SafeStrLen(_Delimiter->GetSymbol(false)):0;
      if (len > 1)
        ClearSeparatorString();

      if (!_BrkSymTransferred[SYMDELIM_INDEX])
        delete _Delimiter;
    }

    len = ::SafeStrLen(Delim_->GetSymbol(false));
    _Delimiter = Overwrite_ ? Delim_->Clone():Delim_;
    _BrkSymTransferred[SYMDELIM_INDEX] = Overwrite_ ? false:Delim_->BrkSymTransferred(SYMDELIM_INDEX);
    _Delimiter->SetSoloSymbol(false);
    
    if (len == 1)
      SetStringTerminator(*_Delimiter->GetSymbol(false));
    else
    {
      SetStringTerminator(' ');      
      if (len)
        SetSeparatorString(_Delimiter->GetSymbol(false));
    }
      
    _AggsRequired |= SYMDELIM_REQ;
    _AggsRequired &= ~NO_SYMDELIM_REQ;
    _AggsArray[SYMDELIM_INDEX] = _Delimiter;
  }
  else
  {
    len = _Delimiter ? ::SafeStrLen(_Delimiter->GetSymbol(false)):0;
    if (len > 1)
      ClearSeparatorString();

    if (!_BrkSymTransferred[SYMDELIM_INDEX])
      delete _Delimiter;
      
    _Delimiter = NULL;
    _AggsRequired |= NO_SYMDELIM_REQ;
    _AggsRequired &= ~SYMDELIM_REQ;
    _AggsArray[SYMDELIM_INDEX] = _Delimiter;    
  }
  
  return *this;
}

/****************************************************************************/
bool BracketedSymbol::HasSymbol(const SymbolSet* SymPtr_, bool NoChain_)
{
  SymbolSet* tPtr_ = ((SymbolSet*)this);

  if (NoChain_)
  {
    if ((_Left && _Left->HasSymbol(SymPtr_)) ||
        (_Right && _Right->HasSymbol(SymPtr_)) ||
        (_Delimiter && _Delimiter->HasSymbol(SymPtr_)) ||
        (tPtr_ == SymPtr_))
      return true;
  }
  else if (_Next && (_Next->IsSequence() || _Next->IsBracketedSymbol()))
  {
    if ((_Left && _Left->HasSymbol(SymPtr_)) ||
        (_Right && _Right->HasSymbol(SymPtr_)) ||
        (_Delimiter && _Delimiter->HasSymbol(SymPtr_)) ||
        (tPtr_ == SymPtr_) ||
        (_Next && _Next->HasSymbol(SymPtr_, NoChain_)))
      return true;  
  }

  return false;
}

/****************************************************************************/
SymbolSet* BracketedSymbol::NextLeftBracket(int Index_, bool Transfer_)
{
  return GetAggs(LEFTBRK_INDEX, Index_, Transfer_);
}

/****************************************************************************/
SymbolSet* BracketedSymbol::NextDelimiter(int Index_, bool Transfer_)
{
  return GetAggs(SYMDELIM_INDEX, Index_, Transfer_);
}

/****************************************************************************/
SymbolSet* BracketedSymbol::NextSymbol(int Index_, bool Transfer_)
{
  return GetAggs(NEXTSYM_INDEX, Index_, Transfer_);
}

/****************************************************************************/
SymbolSet* BracketedSymbol::NextRightBracket(int Index_, bool Transfer_)
{
  return GetAggs(RIGHTBRK_INDEX, Index_, Transfer_);
}

/****************************************************************************/
bool BracketedSymbol::IsBracketedSymbol(bool FollowEnclosing_) const
{
  if (FollowEnclosing_ && _Enclosing)
    return _Enclosing->IsBracketedSymbol(FollowEnclosing_);

  return true;
}

/****************************************************************************/
int BracketedSymbol::AggregateType() const
{
  return BracketedSymbol_Type;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::IncBlockCount(int Val_)
{
  if (Val_ > 0)
    _BlockInc += Val_;
  else
    _BlockDec += Val_;
    
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::IncFunctionCount(int Val_)
{
  if (Val_ > 0)
    _FunctionInc += Val_;
  else
    _FunctionDec += Val_;
  
  return *this;
}

/****************************************************************************/
bool BracketedSymbol::HasLeftBracket() const
{
  return
  (
    _Left != NULL &&
    (_AggsRequired & LEFTBRK_REQ)
  );  
}

/****************************************************************************/
bool BracketedSymbol::HasDelimiter() const
{
  return
  (
    _Delimiter != NULL &&
    (_AggsRequired & SYMDELIM_REQ)
  );
}

/****************************************************************************/
bool BracketedSymbol::HasNext() const
{
  return
  (
    _Next != NULL &&
    (_AggsRequired & NEXTSYM_REQ)
  );
}

/****************************************************************************/
bool BracketedSymbol::HasRightBracket() const
{
  return
  (
    _Right != NULL &&
    (_AggsRequired & RIGHTBRK_REQ)
  );
}

/****************************************************************************/
SymbolSet::TriggerFncData* BracketedSymbol::GiveTriggerFncData()
{
  if (_Next && !_Right)
    return _Next->GiveTriggerFncData();

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())
      return _Right->NextSymbol()->GiveTriggerFncData();
    else
      return SymbolSet::GiveTriggerFncData();
  }
  else if (!_Next)
    return SymbolSet::GiveTriggerFncData();  

  return NULL;
}

/****************************************************************************/
SymbolSet::StateChangeFncData* BracketedSymbol::GiveStateChangeFncData()
{
  if (_Next && !_Right)
    return _Next->GiveStateChangeFncData();

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())  
      return _Right->NextSymbol()->GiveStateChangeFncData();
    else
      return SymbolSet::GiveStateChangeFncData();
  }
  else if (!_Next)
    return SymbolSet::GiveStateChangeFncData();
                                    
  return NULL;
}

/****************************************************************************/
ObjectFunctor* BracketedSymbol::GiveTriggerObject()
{
  if (_Next && !_Right)
    return _Next->GiveTriggerObject();

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())  
      return _Right->NextSymbol()->GiveTriggerObject();
    else
      return SymbolSet::GiveTriggerObject();
  }
  else if (!_Next)
    return SymbolSet::GiveTriggerObject();

  return NULL;
}

/****************************************************************************/
ObjectFunctor* BracketedSymbol::GiveStateChangeObject()
{
  if (_Next && !_Right)
    return _Next->GiveStateChangeObject();

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())    
      return _Right->NextSymbol()->GiveStateChangeObject();
    else
      return SymbolSet::GiveStateChangeObject();
  }
  else if (!_Next)
    return SymbolSet::GiveStateChangeObject();

  return NULL;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetStateChangeObject(ObjectFunctor* Obj_)
{
  if (_Next && !_Right)
    _Next->SetStateChangeObject(Obj_);

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())
      _Right->NextSymbol()->SetStateChangeObject(Obj_);
    else
      SymbolSet::SetStateChangeObject(Obj_);
  }
  else if (!_Next)
    SymbolSet::SetStateChangeObject(Obj_);
  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetStateChangeFunction(int(*Fnc_)(int, char**, void*),
                                                   int FncArgc_, char** FncArgv_,
                                                   bool ResultArg_, bool BranchArg_,
                                                   void* FncArgi_)
{
  if (_Next && !_Right)
    _Next->SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                  ResultArg_, BranchArg_, FncArgi_);

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())
      _Right->NextSymbol()->SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                     ResultArg_, BranchArg_, FncArgi_);
    else
      SymbolSet::SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                        ResultArg_, BranchArg_, FncArgi_);
  }
  else if (!_Next)
    SymbolSet::SetStateChangeFunction(Fnc_, FncArgc_, FncArgv_,
                                      ResultArg_, BranchArg_, FncArgi_);
                                  
  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetTriggerObject(ObjectFunctor* Obj_)
{
  if (_Next && !_Right)
    _Next->SetTriggerObject(Obj_);

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())
      _Right->NextSymbol()->SetTriggerObject(Obj_);
    else
      SymbolSet::SetTriggerObject(Obj_);
  }
  else if (!_Next)
    SymbolSet::SetTriggerObject(Obj_);

  return *this;
}

/****************************************************************************/
SymbolSet& BracketedSymbol::SetTriggerFunction(int(*Fnc_)(int, char**, void*),
                                               int FncArgc_, char** FncArgv_,
                                               bool ResultArg_, bool BranchArg_,
                                               void* FncArgi_)
{
  if (_Next && !_Right)
    _Next->SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                              ResultArg_, BranchArg_, FncArgi_);

  if (_Right)
  {
    if (_Right->IsBracketedSymbol() && _Right->HasNext())
      _Right->NextSymbol()->SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                 ResultArg_, BranchArg_, FncArgi_);
    else
      SymbolSet::SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                    ResultArg_, BranchArg_, FncArgi_);
  }
  else if (!_Next)
    SymbolSet::SetTriggerFunction(Fnc_, FncArgc_, FncArgv_,
                                  ResultArg_, BranchArg_, FncArgi_);

  return *this;
}

/****************************************************************************/
char* BracketedSymbol::ParseSymbolStep(char* Text_, bool& Done_)
{
  if (!Done_)
  {
    bool Cont_ = false;
    _ParseState &= ~FRESH;
    _ParseState |= STARTED;    
  
    if (SymRequiredState_Check(_Left, LEFTBRK_REQ, LEFTBRK_DONE))
    {
      Text_ = _Left->ParseSymbol(Text_);
      _Left->ParserData()->IncBrackBal();

      // debug
      /*
      if (_FunctionInc)
      {
        ParserData()->IncFncStkLevel();
        ParserData()->SetScope(ScopeInfo::FunctionSCOPE);
        ParserData()->SetScopeLevel(
           0, ParserData()->GetFncStkLevel(),
           0, 0, 2, ParserData()->GetFncStkLevel());
        --_FunctionInc;
      }

      if (_BlockInc)
      {
        ParserData()->IncBlkStkLevel();
        ParserData()->SetScope(ScopeInfo::BlockSCOPE);
        ParserData()->SetScopeLevel(
           0, ParserData()->GetFncStkLevel(),
           ParserData()->GetBlkStkLevel(),
           0, 3, ParserData()->GetBlkStkLevel());
        --_BlockInc;
      }
      */
      
      if (_Left->IsParseValid())
      {
        _AggsState |= LEFTBRK_DONE;
        Cont_ =        
        SymState_Check(_Char, SYMBOLS_DONE) ||
        SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE) ||
        SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
        SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);

        if (!Cont_)
        {
          Done_ = true;
          SetGroupValid(true);
          SetGroupDone(true);
        }
      }
      else
      {
        Done_ = true;
        SetGroupDone(false);
        SetGroupValid(!_Required);
      }

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;
    }

    if (SymDataState_Check(_Char, NO_DATA, SYMBOLS_DONE))
    {
      Text_ = SymbolSet::ParseSymbol(Text_);
      if (IsParseValid())
      {
        ++(*_ArgCounter);
        // debug
        // ParserData()->SetArgumentCnt(
        //    ParserData()->GetBlkStkLevel(),
        //    *_ArgCounter, 2, ParserData()->GetPgrmIndex());
      
        _AggsState |= SYMBOLS_DONE;
        Cont_ =
        SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE) ||
        SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
        SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);        

        if (!Cont_)
        {
          Done_ = true;
          SetGroupValid(true);
          SetGroupDone(true);
        }
      }
      else
      {
        Done_ = true;
        SetGroupDone(false);
        SetGroupValid(!_Required);        
      }

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;      
    }

    if (SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE))
    {
      Text_ = _Delimiter->ParseSymbol(Text_);
      if (_Delimiter->IsParseValid())
      {
        ++(*_DelimCounter);
        // debug
        // ParserData()->SetDelimiterCnt(
        //    ParserData()->GetBlkStkLevel(),
        //    *_DelimCounter, 2, ParserData()->GetPgrmIndex());
      
        _AggsState |= SYMDELIM_DONE;
        Cont_ =
        SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
        SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);                

        if (!Cont_)
        {
          Done_ = true;
          SetGroupValid(true);
          SetGroupDone(true);
        }
      }
      else
      {
        Cont_ =
        SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);        
                                
        if (Cont_ || !_Next)
        {
          _Delimiter->SetGroupValid(true);
          
          if (!Cont_)
          {
            Done_ = true;
            SetGroupValid(true);
            SetGroupDone(true);          
          }
        }
        else
        {
          Done_ = true;
          SetGroupDone(false);
          SetGroupValid(!_Required);          
        }
      }

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;      
    }

    if (SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE))
    {
      Text_ = _Next->ParseSymbol(Text_);
      if (_Next->IsParseValid())
      {
        _AggsState |= NEXTSYM_DONE;
        Cont_ =
        SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);

        if (!Cont_)
        {
          Done_ = true;
          SetGroupValid(true);
          SetGroupDone(true);
        }          
      }
      else
      {
        Done_ = true;
        SetGroupDone(false);
        SetGroupValid(!_Required);        
      }

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;      
    }

    if (SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE))
    {
      Text_ = _Right->ParseSymbol(Text_);
      _Right->ParserData()->DecBrackBal();
      int OldFncStkLvl_ = ParserData()->GetFncStkLevel();
      int OldBlkStkLvl_ = ParserData()->GetBlkStkLevel();      

      // debug
      /*
      if (_FunctionDec)
      {
        ParserData()->DecFncStkLevel();
        ParserData()->SetScopeLevel(
           0, OldFncStkLvl_,
           0, 0, 2, ParserData()->GetFncStkLevel());
        
        if (!ParserData()->GetFncStkLevel())
          if (!ParserData()->GetBlkStkLevel())
            ParserData()->SetScope(ScopeInfo::ClassSCOPE);
          else
            ParserData()->SetScope(ScopeInfo::BlockSCOPE);

        ++_FunctionDec;
      }

      if (_BlockDec)
      {
        ParserData()->ClearArgumentCnt(OldBlkStkLvl_, *_ArgCounter);
        ParserData()->ClearDelimiterCnt(OldBlkStkLvl_, *_DelimCounter);
        *_ArgCounter = *_DelimCounter = 0;        

        ParserData()->DecBlkStkLevel();
        ParserData()->SetScopeLevel(
           0, OldFncStkLvl_, OldBlkStkLvl_,
           0, 3, ParserData()->GetBlkStkLevel());
        
        if (!ParserData()->GetBlkStkLevel())
          if (!ParserData()->GetFncStkLevel())
            ParserData()->SetScope(ScopeInfo::ClassSCOPE);
          else
            ParserData()->SetScope(ScopeInfo::FunctionSCOPE);

        ++_BlockDec;
      }
      */

      _TriggerState &= ~FRESH;
      _TriggerState |= STARTED;      

      ParserData()->IncPgrmIndex();
      // debug
      // ParserData()->SetScopeLevel(
      //    0, ParserData()->GetFncStkLevel(),
      //    ParserData()->GetBlkStkLevel(),
      //    ParserData()->GetPgrmIndex(), 4,
      //    ParserData()->GetPgrmIndex());
        
      if (_Right->IsParseValid())
      {
        _AggsState |= RIGHTBRK_DONE;
        Done_ = true;
        SetGroupValid(true);
        SetGroupDone(true);
      }
      else
      {
        Done_ = true;
        SetGroupDone(false);
        SetGroupValid(!_Required);        
      }

      if (Done_)
      {
        if (_ParseDone)
        {
          if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
            (*_TriggerObj)();
          else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
          {
            if (_TriggerData->_FncArgr)
              strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);

            ExecTriggerFunction();
          }

          _TriggerState |= TRIGGER_DONE;
          _TriggerState &= ~TRIGGER_FAIL;
        }
        else
        {
          _TriggerState |= TRIGGER_FAIL;
          _TriggerState &= ~TRIGGER_DONE;
        }
      }
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
char* BracketedSymbol::ParseSymbol(char* Text_)
{
  bool Cont_ = false;
  _ParseState &= ~FRESH;
  _ParseState |= STARTED;  

  if (SymRequiredState_Check(_Left, LEFTBRK_REQ, LEFTBRK_DONE))
  {
    Text_ = _Left->ParseSymbol(Text_);
    _Left->ParserData()->IncBrackBal();

    // debug
    /*
    if (_FunctionInc)
    {
      ParserData()->IncFncStkLevel();
      ParserData()->SetScope(ScopeInfo::FunctionSCOPE);
      ParserData()->SetScopeLevel(
         0, ParserData()->GetFncStkLevel(),
         0, 0, 2, ParserData()->GetFncStkLevel());

      --_FunctionInc;
    }

    if (_BlockInc)
    {
      ParserData()->IncBlkStkLevel();
      ParserData()->SetScope(ScopeInfo::BlockSCOPE);
      ParserData()->SetScopeLevel(
         0, ParserData()->GetFncStkLevel(),
         ParserData()->GetBlkStkLevel(),
         0, 3, ParserData()->GetBlkStkLevel());

      --_BlockInc;
    }
    */
    
    if (_Left->IsParseValid())
    {
      _AggsState |= LEFTBRK_DONE;
      Cont_ =
      SymState_Check(_Char, SYMBOLS_DONE) ||
      SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE) ||
      SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
      SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);
      
      if (!Cont_)
      {
        SetGroupValid(true);
        SetGroupDone(true);

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
        return Text_;
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);      

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;      
    }
  }

  if (SymDataState_Check(_Char, NO_DATA, SYMBOLS_DONE))
  {
    Text_ = SymbolSet::ParseSymbol(Text_);
    if (IsParseValid())
    {
      ++(*_ArgCounter);
      // debug
      // ParserData()->SetArgumentCnt(
      //    ParserData()->GetBlkStkLevel(),
      //    *_ArgCounter, 2, ParserData()->GetPgrmIndex());
    
      _AggsState |= SYMBOLS_DONE;
      Cont_ =
      SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE) ||
      SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
      SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);
      
      if (!Cont_)
      {
        SetGroupValid(true);
        SetGroupDone(true);

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
        return Text_;
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);      

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;
    }
  }

  if (SymRequiredState_Check(_Delimiter, SYMDELIM_REQ, SYMDELIM_DONE))
  {
    Text_ = _Delimiter->ParseSymbol(Text_);    
    if (_Delimiter->IsParseValid())
    {
      ++(*_DelimCounter);
      // debug
      // ParserData()->SetDelimiterCnt(
      //    ParserData()->GetBlkStkLevel(),
      //    *_DelimCounter, 2, ParserData()->GetPgrmIndex());
    
      _AggsState |= SYMDELIM_DONE;
      Cont_ =
      SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE) ||
      SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);
      
      if (!Cont_)
      {
        SetGroupValid(true);
        SetGroupDone(true);

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
        return Text_;
      }
    }
    else
    {
      Cont_ =
      SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);
                                
      if (Cont_ || !_Next)
      {
        _Delimiter->SetGroupValid(true);
          
        if (!Cont_)
        {
          SetGroupValid(true);
          SetGroupDone(true);

          #if SYMBOLSET_DEBUG
            ParserData()->ShowData(cout);
          #endif
          return Text_;          
        }
      }    
      else
      {
        SetGroupDone(false);
        SetGroupValid(!_Required);

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
        return Text_;        
      }      
    }
  }

  if (SymRequiredState_Check(_Next, NEXTSYM_REQ, NEXTSYM_DONE))
  {
    Text_ = _Next->ParseSymbol(Text_);
    if (_Next->IsParseValid())
    {
      _AggsState |= NEXTSYM_DONE;
      Cont_ =
      SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE);

      if (!Cont_)
      {
        SetGroupValid(true);
        SetGroupDone(true);

        #if SYMBOLSET_DEBUG
          ParserData()->ShowData(cout);
        #endif        
        return Text_;        
      }
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);      

      #if SYMBOLSET_DEBUG
        ParserData()->ShowData(cout);
      #endif      
      return Text_;
    }
  }

  if (SymRequiredState_Check(_Right, RIGHTBRK_REQ, RIGHTBRK_DONE))
  {
    Text_ = _Right->ParseSymbol(Text_);
    _Right->ParserData()->DecBrackBal();
    int OldFncStkLvl_ = ParserData()->GetFncStkLevel();
    int OldBlkStkLvl_ = ParserData()->GetBlkStkLevel();

    // debug
    /*
    if (_FunctionDec)
    {    
      ParserData()->DecFncStkLevel();              
      ParserData()->SetScopeLevel(
         0, OldFncStkLvl_,
         0, 0, 2, ParserData()->GetFncStkLevel());
      
      if (!ParserData()->GetFncStkLevel())
        if (!ParserData()->GetBlkStkLevel())
          ParserData()->SetScope(ScopeInfo::ClassSCOPE);
        else
          ParserData()->SetScope(ScopeInfo::BlockSCOPE);

      ++_FunctionDec;
    }

    if (_BlockDec)
    {      
      ParserData()->ClearArgumentCnt(OldBlkStkLvl_, *_ArgCounter);
      ParserData()->ClearDelimiterCnt(OldBlkStkLvl_, *_DelimCounter);
      *_ArgCounter = *_DelimCounter = 0;      

      ParserData()->DecBlkStkLevel();
      ParserData()->SetScopeLevel(
         0, OldFncStkLvl_, OldBlkStkLvl_,
         0, 3, ParserData()->GetBlkStkLevel());
      
      if (!ParserData()->GetBlkStkLevel())
        if (!ParserData()->GetFncStkLevel())
          ParserData()->SetScope(ScopeInfo::ClassSCOPE);
        else
          ParserData()->SetScope(ScopeInfo::FunctionSCOPE);

      ++_BlockDec;          
    }
    */

    ParserData()->IncPgrmIndex();
    // debug
    // ParserData()->SetScopeLevel(
    //    0, ParserData()->GetFncStkLevel(),
    //    ParserData()->GetBlkStkLevel(),
    //    ParserData()->GetPgrmIndex(), 4,
    //    ParserData()->GetPgrmIndex());

    _TriggerState &= ~FRESH;
    _TriggerState |= STARTED;       
    
    if (_Right->IsParseValid())
    {
      _AggsState |= RIGHTBRK_DONE;
      SetGroupValid(true);
      SetGroupDone(true);
    }
    else
    {
      SetGroupDone(false);
      SetGroupValid(!_Required);
    }

    if (_ParseDone)
    {
      if (_TriggerObj && (_TriggerState & TRIGGER_OBJECT_SET))
        (*_TriggerObj)();
      else if (_TriggerData && (_TriggerState & TRIGGER_FUNCTION_SET))
      {
        if (_TriggerData->_FncArgr)
          strcpy(_TriggerData->_FncArgv[_TriggerData->_FncArgc-1], Text_);
      
        ExecTriggerFunction();
      }

      _TriggerState |= TRIGGER_DONE;           
      _TriggerState &= ~TRIGGER_FAIL;
    }
    else
    {
      _TriggerState |= TRIGGER_FAIL;
      _TriggerState &= ~TRIGGER_DONE;    
    }
  }

  #if SYMBOLSET_DEBUG
    ParserData()->ShowData(cout);
  #endif
  return Text_;
}

/****************************************************************************/
int BracketedSymbol::GetBrkSymRequired() const
{
  return GetAggsRequired();
}

/****************************************************************************/
int BracketedSymbol::GetBrkSymState() const
{
  return GetAggsState();
}

/****************************************************************************/
MEMORYOPS_DEFN(LevelData)
MEMORYOPS_DEFN(SymbolParserData)

MEMORYOPS_DEFN(SymbolSet)
MEMORYOPS_DEFN(SymbolSet::TriggerFncData)
MEMORYOPS_DEFN(SymbolSet::StateChangeFncData)
MEMORYOPS_DEFN(Sequence)
MEMORYOPS_DEFN(BranchOut)
MEMORYOPS_DEFN(OperatorSet)
MEMORYOPS_DEFN(BracketedSymbol)

/****************************************************************************/
#endif
