#ifndef SYMBOLTEST_CPP
#define SYMBOLTEST_CPP
#ifndef SYMBOLS_H
  #include "symbols.h"
#endif

//
//    SymbolSet(const char* Str_, const char* WsChar_,
//              int IoType_, int DataType_, int Struct_,
//              int Attrib_, int Type_, int Ws_,
//              bool SkipSpaces_, bool Required_,
//              bool CaseSensitive_, bool Ordered_);
//
//    Sequence(const char* Str_, const char* WsChar_,
//             int IoType_, int DataType_, int Struct_,
//             int Attrib_, int Type_, int Ws_,
//             int SeqType_, int TypeExt_, bool SkipSpaces_,
//             bool Required_, bool CaseSensitive_, bool Ordered_);
//
//    BranchOut(const char* Str_, const char* WsChar_,
//              int IoType_, int DataType_, int Struct_,
//              int Attrib_, int Type_, int Ws_,
//              bool SkipSpaces_, bool Required_,
//              bool CaseSensitive_, bool Ordered_);
//
//    Operator(const char* Str_, const char* WsChar_,
//             int IoType_, int DataType_, int Struct_,
//             int SymAttrib_, int SymType_, int Ws_,
//             int OpType_, bool SkipSpaces_, bool Required_,
//             bool CaseSensitive_, bool Ordered_);
//
//    BracketedSymbol(const char* Str_, const char* WsChar_,
//                    int IoType_, int DataType_, int Struct_,
//                    int Attrib_, int Type_, int Ws_,
//                    bool SkipSpaces_, bool Required_,
//                    bool CaseSensitive_, bool Ordered_);
//
/****************************************************************************/
#define SYMBOLTEST_DEBUG1       0  // test: parse symbol steps
#define SYMBOLTEST_DEBUG2       0  // test: parse whole symbol
#define SYMBOLTEST_DEBUG3       0  // test: set trigger functions
#define SYMBOLTEST_DEBUG4       0  // test: self allocated array memory

#define SYMBOLTEST_DEBUG5       1  // test: symbol storage structures

char* DoParseStep(SymbolSet* Ptr_, char* Text_)
{
  #if SYMBOLTEST_DEBUG1
    bool Done_ = false;

    if (Ptr_->IsBranchOut())
      Ptr_->Reset();
    
    while (!Done_)
      Text_ = Ptr_->ParseSymbolStep(Text_, Done_);
  #endif

  #if SYMBOLTEST_DEBUG2
    Text_ = Ptr_->ParseSymbol(Text_);
  #endif

  return Text_;
}

/****************************************************************************/
int ShowFunc(int argc, char** argv, void* argi)
{
  if (argc == 2)
  {
    cout <<argv[0] <<argv[1];
    cout <<endl;
    return 0;
  }

  return 1;
}

/****************************************************************************/
int ShowFunc2(int argc, char** argv, void* argi)
{
  if (argc == 4)
  {
    cout <<argv[0] <<argv[2] <<argv[1] <<argv[3];
    cout <<endl;
    return 0;
  }

  return 1;
}

/****************************************************************************/
int main()
{
  // SymbolSet test data
  char* Text2_ = new_char_string("0123456789abcdef0123456789abcdef0123456789abcdef --test2");

  // Sequence test data
  char* Text3_ = new_char_string("0123456789abcdef"
                                 "howdy1 doody2"
                                 "yabba3 dabba4"
                                 "captain5 kirk6 --test3");
  char* Text4_ = new_char_string("0123456789abcdef"
                                 "howdy1 doody2"
                                 "yabba3 dabba4"
                                 "captain5 kirk6"
                                 "Hollywood Doggy"
                                 "0123456789abcdef --test4");
  char* Text4s_ = new_char_string("0123456789abcdef|"
                                  "howdy1 doody2|"
                                  "yabba3 dabba4|"
                                  "captain5 kirk6 --test4s");

  // OperatorSet test data
  char* Text5_ = new_char_string("R = ++x --test5");
  char* Text5a_ = new_char_string("Res1 = y-- --test5a");
  char* Text5b_ = new_char_string("Result := OpVal1 * OpVal2 --test5b");
  char* Text5c_ = new_char_string("Condition ? DefaultV:AlternateV --test5c");
  char* Text5d_ = new_char_string("Resultant += (value>>10) ? val_x:val_y --test5d");
  char* Text5e_ = new_char_string("/ SchV1 SchV2 --test5e");

  // BranchOut test data
  char* Text6a_ = new_char_string("0123456789abcdef|"
                                  "howdy1 doody2| --test6a");
  char* Text6b_ = new_char_string("yabba3 dabba4|"
                                  "captain5 kirk6| --test6b");
  char* Text6c_ = new_char_string("Hollywood Doggy|"
                                  "0123456789abcdef| --test6c");

  // BracketedSymbol test data
  char* Text7_ = new_char_string("(Zeitgeist,~ 123, 3.1416,~ Abracadabra) --test7");

  char* Saved_;
  char* Result2_;
  char* Result3_;
  char* Result4_;
  char* Result4s_;
  char* Result5_;
  char* Result6a1_;
  char* Result6a2_;
  char* Result6b1_;
  char* Result6b2_;
  char* Result6c1_;
  char* Result6c2_;
  char* Result7_;

  int ARRAY_SIZE = 20;
  #if SYMBOLTEST_DEBUG4
    char** Array_ = NULL;
    char** ArrayBak_ = NULL;
  #else
    char* Array_[ARRAY_SIZE];
  #endif

  int Index6a1_;
  int Index6a2_;
  int Index6b1_;
  int Index6b2_;
  int Index6c1_;
  int Index6c2_;

  system("cls");  

  int sz = 0;
  int index = 0;
  char** TokArray_;
  SymbolSet* SymPtr;
  char* Text_;
  char* Result_;
  int x;
  SymbolSet::TriggerFncData* FncData;
  SymbolTagArray SymTags_("symtestdata.txt");

  TokArray_ = SymTags_.ReadSymbolFile();
  sz = SymTags_.TagArraySize();

  #if ((SYMBOLTEST_DEBUG3) & (!SYMBOLTEST_DEBUG4))
    for (x = 0; x < ARRAY_SIZE; x++)
      Array_[x] = new_char_string("12345678901234567890");
  #endif

  while (index < sz)
  {
    SymPtr = SymTags_.MakeFromTagText(index);
    #if SYMBOLTEST_DEBUG3
      if (index == 17)
      {
        #if SYMBOLTEST_DEBUG4
          ArrayBak_ = Array_;
          Array_ = NULL;
        #endif
        SymPtr->SetTriggerFunction(ShowFunc2, 2, Array_, true, true, NULL);
      }
      else
        SymPtr->SetTriggerFunction(ShowFunc, 1, Array_, true, false, NULL);
    #endif

    if (index == 2)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif
        strcpy(Array_[0], "Result2: ");        
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result2_ = DoParseStep(SymPtr, Text2_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2: " <<Result2_ <<endl;
      #endif
      Text_ = new_char_string("0123456789abcdef=zx200 --test2a");
    }
    else if (index == 3)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result2a: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result_ = DoParseStep(SymPtr, Text_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2a: " <<Result_ <<endl;
      #endif
      strcpy(Text_, "howdy1 doody2 --test2b");
    }
    else if (index == 4)
    {    
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result2b: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result_ = DoParseStep(SymPtr, Text_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2b: " <<Result_ <<endl;
      #endif
      strcpy(Text_, "yabba3 dabba4 --test2c");
    }
    else if (index == 5)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result2c: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result_ = DoParseStep(SymPtr, Text_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2c: " <<Result_ <<endl;
      #endif
      strcpy(Text_, "captain5 kirk6 --test2d");
    }
    else if (index == 6)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result2d: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result_ = DoParseStep(SymPtr, Text_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2d: " <<Result_ <<endl;
      #endif
      strcpy(Text_, "Hollywood Doggy --test2e");
    }
    else if (index == 7)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result2e: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result_ = DoParseStep(SymPtr, Text_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result2e: " <<Result_ <<endl;
      #endif
    }
    else if (index == 8)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result3: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result3_ = DoParseStep(SymPtr, Text3_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result3: " <<Result3_ <<endl;
      #endif
    }
    else if (index == 9)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result4: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result4_ = DoParseStep(SymPtr, Text4_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result4: " <<Result4_ <<endl;
      #endif
    }
    else if (index == 10)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result4s: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result4s_ = DoParseStep(SymPtr, Text4s_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result3: " <<Result4s_ <<endl;
      #endif
    }    
    
    else if (index == 11)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5: " <<Result5_ <<endl;
      #endif
    }
    else if (index == 12)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5a: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5a_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5a: " <<Result5_ <<endl;
      #endif
    }
    else if (index == 13)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5b: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5b_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5b: " <<Result5_ <<endl;
      #endif
    }
    else if (index == 14)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5c: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5c_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5c: " <<Result5_ <<endl;
      #endif
    }
    else if (index == 15)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5d: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5d_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5d: " <<Result5_ <<endl;
      #endif
    }
    else if (index == 16)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Result5e: ");
        SymPtr->SetTriggerFunction(NULL, 1, Array_, true, false, NULL);
      #endif
      Result5_ = DoParseStep(SymPtr, Text5e_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result5e: " <<Result5_ <<endl;
      #endif
    }

    else if (index == 17)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif      
        strcpy(Array_[0], "Index6a1 = ");
        strcpy(Array_[1], "\tResult6a1: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Saved_ = Text6a_;
      Text6a_ = Result6a1_ = DoParseStep(SymPtr, Text6a_);
      Index6a1_ = SymPtr->BranchNum();

      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif
        strcpy(Array_[0], "Index6a2 = ");
        strcpy(Array_[1], "\tResult6a2: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Result6a2_ = DoParseStep(SymPtr, Text6a_);
      Index6a2_ = SymPtr->BranchNum();
      Text6a_ = Saved_;

      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif            
        strcpy(Array_[0], "Index6b1 = ");
        strcpy(Array_[1], "\tResult6b1: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Saved_ = Text6b_;
      Text6b_ = Result6b1_ = DoParseStep(SymPtr, Text6b_);
      Index6b1_ = SymPtr->BranchNum();

      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif            
        strcpy(Array_[0], "Index6b2 = ");
        strcpy(Array_[1], "\tResult6b2: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Result6b2_ = DoParseStep(SymPtr, Text6b_);
      Index6b2_ = SymPtr->BranchNum();
      Text6b_ = Saved_;

      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif            
        strcpy(Array_[0], "Index6c1 = ");
        strcpy(Array_[1], "\tResult6c1: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Saved_ = Text6c_;
      Text6c_ = Result6c1_ = DoParseStep(SymPtr, Text6c_);
      Index6c1_ = SymPtr->BranchNum();

      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif            
        strcpy(Array_[0], "Index6c2 = ");
        strcpy(Array_[1], "\tResult6c2: ");
        SymPtr->SetTriggerFunction(NULL, 2, Array_, true, true, NULL);
      #endif
      Result6c2_ = DoParseStep(SymPtr, Text6c_);
      Index6c2_ = SymPtr->BranchNum();
      Text6c_ = Saved_;

      #if !SYMBOLTEST_DEBUG3
        cout <<"Index6a1 = " <<Index6a1_ <<"\tResult6a1: " <<Result6a1_ <<endl;
        cout <<"Index6a2 = " <<Index6a2_ <<"\tResult6a2: " <<Result6a2_ <<endl;
        cout <<"Index6b1 = " <<Index6b1_ <<"\tResult6b1: " <<Result6b1_ <<endl;
        cout <<"Index6b2 = " <<Index6b2_ <<"\tResult6b2: " <<Result6b2_ <<endl;
        cout <<"Index6c1 = " <<Index6c1_ <<"\tResult6c1: " <<Result6c1_ <<endl;
        cout <<"Index6c2 = " <<Index6c2_ <<"\tResult6c2: " <<Result6c2_ <<endl;
      #endif

      #if SYMBOLTEST_DEBUG4
        Array_ = ArrayBak_;
      #endif
    }
    else if (index > 18)
    {
      #if SYMBOLTEST_DEBUG3
        #if SYMBOLTEST_DEBUG4
          FncData = SymPtr->GiveTriggerFncData();
          Array_ = FncData->_FncArgv;
        #endif
        strcpy(Array_[0], "Result7: ");
        SymPtr->SetTriggerFunction(ShowFunc, 1, Array_, true, false, NULL);
      #endif
      Result7_ = DoParseStep(SymPtr, Text7_);

      #if !SYMBOLTEST_DEBUG3
        cout <<"Result7: " <<Result7_ <<endl;
      #endif
    }
  }

  ::DeleteArray(Text_);
  ::DeleteArray(Text2_);
  ::DeleteArray(Text3_);
  ::DeleteArray(Text4_);
  ::DeleteArray(Text5_);
  ::DeleteArray(Text5a_);
  ::DeleteArray(Text5b_);
  ::DeleteArray(Text5c_);
  ::DeleteArray(Text5d_);
  ::DeleteArray(Text5e_);  
  ::DeleteArray(Text6a_);
  ::DeleteArray(Text6b_);
  ::DeleteArray(Text6c_);
  ::DeleteArray(Text7_);

  #if ((SYMBOLTEST_DEBUG3) & (!SYMBOLTEST_DEBUG4))  
    for (x = 0; x < ARRAY_SIZE; x++)
      ::DeleteArray(Array_[x]);
  #endif

  return 0;
}

/****************************************************************************/
#endif
