#ifndef SYMSTATUS_CPP
#define SYMSTATUS_CPP
#ifndef SYMSTATUS_H
  #include "symstatus.h"
#endif

/****************************************************************************/
// ParserStatus class definition
/****************************************************************************/
ParserStatus::ParserStatus():
ParseError(0),
NestingLevel(0),
ScopeLevel(0),
CurrentToken(0),
GroupLevel(0),
ParseGroup(0),
InGroup(32),
OptionLevel(0),
ParseOption(0),
InOption(32),
ParseSymbol(0),
InSymbol(32),
InBracket(32),
DelimCount(0),
ParseLiteral(0),
InLiteral(32),
InParserOption(0),
Repeatable(0),
TokenType(0),
_ScopeToken(NULL),
_Enclosing(NULL),
_Copied(false),
FoundIndex(0),
OpFoundArray(384),
SymFoundArray(384),
ScopeArray(384),
StackDisplayLevel(0),
DeepestLevel(0),
ParserFlags(32),
_SyntaxStr(NULL),
_SyntaxStrIndex(0),
_SyntaxStrLen(0),
OldSyntaxStr(NULL),
NewSyntaxStr(NULL),
NewInputStr(NULL)
{
  ParserFlags.SetBit(CASE_SENSITIVE);
  GrowSyntaxStr(STACK_INCR);
}

/****************************************************************************/
ParserStatus::ParserStatus(ParserStatus* Head_, FieldInfo* ScopeToken_):
ParseError(0),
NestingLevel(Head_->NestingLevel),
ScopeLevel(Head_->ScopeLevel+1),
CurrentToken(0),
GroupLevel(Head_->GroupLevel),
ParseGroup(0),
InGroup(32),
OptionLevel(Head_->OptionLevel),
ParseOption(0),
InOption(32),
ParseSymbol(0),
InSymbol(32),
InBracket(32),
DelimCount(0),
ParseLiteral(0),
InLiteral(32),
InParserOption(0),
Repeatable(0),
TokenType(0),
_ScopeToken(ScopeToken_),
_Enclosing(Head_),
_Copied(false),
FoundIndex(0),
OpFoundArray(384),
SymFoundArray(384),
ScopeArray(384),
StackDisplayLevel(Head_->StackDisplayLevel),
DeepestLevel(Head_->DeepestLevel),
ParserFlags(32),
_SyntaxStr(NULL),
_SyntaxStrIndex(0),
_SyntaxStrLen(0),
OldSyntaxStr(NULL),
NewSyntaxStr(NULL),
NewInputStr(NULL)
{
  ParserFlags.SetBit(CASE_SENSITIVE);
  GrowSyntaxStr(STACK_INCR);

  InGroup = Head_->InGroup;
  InOption = Head_->InOption;
  InSymbol = Head_->InSymbol;
  InBracket = Head_->InBracket;
  InLiteral = Head_->InLiteral;
}

/****************************************************************************/
ParserStatus::~ParserStatus()
{
  ClearSyntaxStr();
}

/****************************************************************************/
int ParserStatus::CalcNestingLevel()
{
  return (StackDisplayLevel + GroupLevel + OptionLevel + ScopeLevel);
}

/****************************************************************************/
void ParserStatus::Assign(ParserStatus* Status_)
{
   ParseError = Status_->ParseError;
   NestingLevel = Status_->NestingLevel;
   ScopeLevel = Status_->ScopeLevel;
   CurrentToken = Status_->CurrentToken;
   GroupLevel = Status_->GroupLevel;
   ParseGroup = Status_->ParseGroup;
   InGroup = Status_->InGroup;
   OptionLevel = Status_->OptionLevel;
   ParseOption = Status_->ParseOption;
   InOption = Status_->InOption;
   ParseSymbol = Status_->ParseSymbol;
   InSymbol = Status_->InSymbol;
   InBracket = Status_->InBracket;
   DelimCount = Status_->DelimCount;
   ParseLiteral = Status_->ParseLiteral;
   InLiteral = Status_->InLiteral;
   InParserOption = Status_->InParserOption;
   Repeatable = Status_->Repeatable;
   TokenType = Status_->TokenType;
   FoundIndex = Status_->FoundIndex;
   OpFoundArray = Status_->OpFoundArray;
   SymFoundArray = Status_->SymFoundArray;
   ScopeArray = Status_->ScopeArray;
   StackDisplayLevel = Status_->StackDisplayLevel;
   DeepestLevel = Status_->DeepestLevel;
   ParserFlags = Status_->ParserFlags;

   _Copied = true;
   _ScopeToken = Status_->_ScopeToken;
   _Enclosing = Status_->_Enclosing;
   
   _SyntaxStr = Status_->_SyntaxStr;
   _SyntaxStrIndex = Status_->_SyntaxStrIndex;
   _SyntaxStrLen = Status_->_SyntaxStrLen;

   OldSyntaxStr = Status_->OldSyntaxStr;
   NewSyntaxStr = Status_->NewSyntaxStr;
   NewInputStr = Status_->NewInputStr;
}

/****************************************************************************/
void ParserStatus::ResetParseFlags()
{
   ParseError = 0;
   ParseLiteral = 0;
   ParseSymbol = 0;
   ParseGroup = 0;
   ParseOption = 0;
   Repeatable = 0;
   InParserOption = 0;
}

/****************************************************************************/
int ParserStatus::ResetStatusFlag()
{
  if (!NestingLevel || ParseError || InParserOption)
  {
    ResetParseFlags();
    return CurrentToken;
  }

  NestingLevel--;
  Ulong Val_;
  BitVector Mask_;
  const int Brackval_ = ParserSymbolType::BRACKETED | ParserSymbolType::SYMBOL_SYM;
  const int Symval_ = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_SYM;
  const int Opval_ = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_OP;

  switch (CurrentToken)
  {
    case ParserSymbolType::LITERAL:
      Val_ = ~(1UL << Ulong(NestingLevel));
      Mask_.FromIntValue(Val_);
      InLiteral &= Mask_;
      break;

    case Brackval_:
      DelimCount = 0;
      Val_ = ~(1UL << Ulong(NestingLevel));
      Mask_.FromIntValue(Val_);      
      InBracket &= Mask_;
      InSymbol &= Mask_;      
      break;
    
    case ParserSymbolType::SYMBOL:
    case Symval_:
    case Opval_:
      Val_ = ~(1UL << Ulong(NestingLevel));
      Mask_.FromIntValue(Val_);      
      InSymbol &= Mask_;
      break;
    
    case ParserSymbolType::GROUP:
      Val_ = ~(1UL << Ulong(NestingLevel));
      Mask_.FromIntValue(Val_);      
      InGroup &= Mask_;
      break;
    
    case ParserSymbolType::OPTION:
      Val_ = ~(1UL << Ulong(NestingLevel));
      Mask_.FromIntValue(Val_);      
      InOption &= Mask_;
      break;
  }

  if (CurrentToken == Symval_ ||
      CurrentToken == Brackval_)
  {
    ScopeArray = 0;
    SymFoundArray = 0;
  }
  
  if (CurrentToken == Opval_)
  {
    ScopeArray = 0;
    OpFoundArray = 0;  
  }

  Ulong Index_ = NestingLevel;
  if (Index_)
    --Index_;

  CurrentToken = (InLiteral.GetBit(Index_)) ? ParserSymbolType::LITERAL:
                 (InBracket.GetBit(Index_)) ? ParserSymbolType::BRACKETED:
                 (InSymbol.GetBit(Index_)) ? ParserSymbolType::SYMBOL:
                 (InGroup.GetBit(Index_)) ? ParserSymbolType::GROUP:
                 (InOption.GetBit(Index_)) ? ParserSymbolType::OPTION:0;
                 
  ResetParseFlags();
  return CurrentToken;
}

/****************************************************************************/
void ParserStatus::SetError()
{
  ResetParseFlags();
  ParseError = 1;
}

/****************************************************************************/
void ParserStatus::SetInParserOption()
{
  ResetParseFlags();
  InParserOption = 1;
}

/****************************************************************************/
void ParserStatus::SetParseLiteral()
{
  ResetParseFlags();
  ParseLiteral = 1;
}

/****************************************************************************/
void ParserStatus::SetParseSymbol()
{
  ResetParseFlags();
  ParseSymbol = 1;
}

/****************************************************************************/
void ParserStatus::SetParseGroup()
{
  ResetParseFlags();
  ParseGroup = 1;
}

/****************************************************************************/
void ParserStatus::SetParseOption()
{
  ResetParseFlags();
  ParseOption = 1;
}

/****************************************************************************/
void ParserStatus::SetParseRepOption()
{
  ResetParseFlags();
  ParseOption = 1;
  Repeatable = 1;
}

/****************************************************************************/
void ParserStatus::SetInLiteral()
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InLiteral |= Mask_;
    NestingLevel++;
    CurrentToken = ParserSymbolType::LITERAL;
  }
}

/****************************************************************************/
void ParserStatus::SetInBracket()
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);    
    InSymbol |= Mask_;
    InBracket |= Mask_;
    NestingLevel++;
    CurrentToken = ParserSymbolType::BRACKETED;
  }
}

/****************************************************************************/
void ParserStatus::SetInSymbol()
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);    
    InSymbol |= Mask_;
    NestingLevel++;
    CurrentToken = ParserSymbolType::SYMBOL;
  }
}

/****************************************************************************/
void ParserStatus::SetInGroup()
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);    
    InGroup |= Mask_;
    NestingLevel++;
    CurrentToken = ParserSymbolType::GROUP;
  }
}

/****************************************************************************/
void ParserStatus::SetInOption()
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InOption |= Mask_;
    NestingLevel++;
    CurrentToken = ParserSymbolType::OPTION;
  }
}

/****************************************************************************/
void ParserStatus::SetCaseSensitive(int BoolVal_)
{
  if (BoolVal_)
    ParserFlags.SetBit(CASE_SENSITIVE);
  else  
    ParserFlags.UnSetBit(CASE_SENSITIVE);
}

/****************************************************************************/
void ParserStatus::Reset()
{
    ParseError = 0;
    NestingLevel = 0;
    CurrentToken = 0;
    GroupLevel = 0;
    ParseGroup = 0;
    InGroup.UnSetAllBits();
    OptionLevel = 0;
    ParseOption = 0;
    InOption.UnSetAllBits();
    ParseSymbol = 0;
    InSymbol.UnSetAllBits();
    InBracket.UnSetAllBits();
    DelimCount = 0;
    ParseLiteral = 0;
    InLiteral.UnSetAllBits();
    InParserOption = 0;
    Repeatable = 0;
    TokenType = 0;
    FoundIndex = 0;    
    OpFoundArray.UnSetAllBits();
    SymFoundArray.UnSetAllBits();
    ScopeArray.UnSetAllBits();
    DeepestLevel = 0;
    ParserFlags.SetBit(CASE_SENSITIVE);

    ClearSyntaxStr();
    OldSyntaxStr = NULL;
    NewSyntaxStr = NULL;
    NewInputStr = NULL;
}

/****************************************************************************/
void ParserStatus::GrowSyntaxStr(int Size_)
{
  if (_SyntaxStrLen >= Size_)
    return;

  int x = 0;
  int OldSize_ = _SyntaxStrLen;
  
  _SyntaxStrLen = Size_;
  _SyntaxStrIndex = 0;
  
  char** Saved_ = _SyntaxStr;
  _SyntaxStr = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * _SyntaxStrLen);

  if (OldSize_)
  {
    for (x = 0; x < OldSize_; x++)
      _SyntaxStr[x] = Saved_[x];

    ::DeleteArray(Saved_);
  }

  for (;x < _SyntaxStrLen; x++)
    _SyntaxStr[x] = NULL;
}

/****************************************************************************/
void ParserStatus::PushSyntaxStr(const char* Str_)
{
  if (_SyntaxStrIndex >= _SyntaxStrLen)
    GrowSyntaxStr(_SyntaxStrLen + STACK_INCR);
  
  _SyntaxStr[_SyntaxStrIndex++] = new_char_string(Str_);
  OldSyntaxStr = _SyntaxStr[_SyntaxStrIndex - 1];
}

/****************************************************************************/
char* ParserStatus::CurrentSyntaxStr()
{
  char* RetStr_ = _SyntaxStr[_SyntaxStrIndex - 1];
  return RetStr_;
}

/****************************************************************************/
char* ParserStatus::PopSyntaxStr()
{
  char* RetStr_ = _SyntaxStr[--_SyntaxStrIndex];
  NewSyntaxStr = RetStr_;
  return RetStr_;
}

/****************************************************************************/
void ParserStatus::ClearSyntaxStr()
{
  int x;
  for (x = 0; x < _SyntaxStrLen; x++)
    ::DeleteArray(_SyntaxStr[x]);

  ::DeleteArray(_SyntaxStr);
}

/****************************************************************************/
ParserStatus* ParserStatus::Push(ParserStatus* Head_, FieldInfo* ScopeToken_)
{
  if (!Head_->_Copied)
  {
    ParserStatus* Node_ = new ParserStatus(Head_, ScopeToken_);
    Head_ = Node_;
  }

  return Head_;
}

/****************************************************************************/
ParserStatus* ParserStatus::Pop(ParserStatus** Head_, bool PopScope_)
{
  if (Head_ && !(*Head_)->_Copied)
  {
    ParserStatus* Node_ = *Head_;
    *Head_ = (*Head_)->_Enclosing;
    Node_->_Enclosing = NULL;
    Node_->ScopeLevel--;

    if (PopScope_)
      Node_->_ScopeToken = NULL;

    return Node_;
  }

  return NULL;
}

/****************************************************************************/
void ParserStatus::SetTerminatorFound(int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);    
    InSymbol |= Mask_;
    NestingLevel++;

    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    Val_ = SymbolSet::Ender | SymbolSet::Symbol_Type | SymbolSet::Found;
    SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    OpFoundArray = 0;
    CurrentToken = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_SYM;
    FoundIndex++;    
  }
}

/****************************************************************************/  
void ParserStatus::SetStarterFound(int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InSymbol |= Mask_;
    NestingLevel++;

    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    Val_ = SymbolSet::Starter | SymbolSet::Symbol_Type | SymbolSet::Found;
    SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    OpFoundArray = 0;
    CurrentToken = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_SYM;
    FoundIndex++;
  }
}

/****************************************************************************/  
void ParserStatus::SetBracketFound(int Left_, int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InSymbol |= Mask_;
    InBracket |= Mask_;
    NestingLevel++;
    
    if (Left_)
    {
      Val_ = SymbolSet::LeftBracket | SymbolSet::Symbol_Type | SymbolSet::Found;
      SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    }
    else
    {
      Val_ = SymbolSet::RightBracket | SymbolSet::Symbol_Type | SymbolSet::Found;
      SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    }

    OpFoundArray = 0;
    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    CurrentToken = ParserSymbolType::BRACKETED | ParserSymbolType::SYMBOL_SYM;
    FoundIndex++;
  }
}

/****************************************************************************/  
void ParserStatus::SetStateSwitchFound(int Type_, int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InSymbol |= Mask_;
    NestingLevel++;

    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    Val_ = SymbolSet::StateSwitch | SymbolSet::Operator_Type | SymbolSet::Found;
    SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    Val_ = (Type_ << Ulong(FoundIndex * SYMARRAY_INCR));
    OpFoundArray = Val_;
    CurrentToken = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_OP;
    FoundIndex++;
  }
}

/****************************************************************************/  
void ParserStatus::SetSymbolsFound(int Type_, int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InSymbol |= Mask_;
    NestingLevel++;

    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    Val_ = Type_ | SymbolSet::Symbol_Type | SymbolSet::Found;
    SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    OpFoundArray = 0;
    CurrentToken = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_SYM;
    FoundIndex++;
  }
}

/****************************************************************************/  
void ParserStatus::SetOperatorFound(int Type_, int ScopeLevel_)
{
  if (!ParseError)
  {
    Ulong Val_ = (1UL << Ulong(NestingLevel));
    BitVector Mask_(0, NULL, Val_);
    InSymbol |= Mask_;
    NestingLevel++;

    Val_ = (ScopeLevel_ << Ulong(FoundIndex * SYMARRAY_INCR));
    ScopeArray = Val_;
    Val_ = SymbolSet::Operator_Type | SymbolSet::Found;
    SymFoundArray = (Val_ << Ulong(FoundIndex * SYMARRAY_INCR));
    Val_ = (Type_ << Ulong(FoundIndex * SYMARRAY_INCR));
    OpFoundArray = Val_;
    CurrentToken = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_OP;
    FoundIndex++;
  }
}

/****************************************************************************/
void ParserStatus::ResetOpSymFlags()
{
  const int Brackval_ = ParserSymbolType::BRACKETED | ParserSymbolType::SYMBOL_SYM;
  const int Symval_ = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_SYM;
  const int Opval_ = ParserSymbolType::SYMBOL | ParserSymbolType::SYMBOL_OP;

  if (CurrentToken == Brackval_ ||
      CurrentToken == Symval_ ||
      CurrentToken == Opval_)
    ResetStatusFlag();
}

/****************************************************************************/
void ParserStatus::AssignOpSymFlags(ParserStatus* Status_)
{
  if (Status_)
  {
    Status_->InSymbol = InSymbol;
    Status_->InBracket = InBracket;
    Status_->DelimCount = DelimCount;
    Status_->NestingLevel = NestingLevel;
    
    Status_->FoundIndex = FoundIndex;
    Status_->SymFoundArray = SymFoundArray;
    Status_->OpFoundArray = OpFoundArray;
    Status_->ScopeArray = ScopeArray;
    Status_->CurrentToken = CurrentToken;
  }
}

/****************************************************************************/
bool ParserStatus::TerminatorFound(int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong val_ = SymbolSet::Ender | SymbolSet::Symbol_Type | SymbolSet::Found;
  
  return
  (
    InSymbol.Any() &&
    SymFoundArray == (val_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::SYMBOL |
                     ParserSymbolType::SYMBOL_SYM)
  );
}

/****************************************************************************/
bool ParserStatus::StarterFound(int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong val_ = SymbolSet::Starter | SymbolSet::Symbol_Type | SymbolSet::Found;
  
  return
  (
    InSymbol.Any() &&
    SymFoundArray == (val_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::SYMBOL |
                     ParserSymbolType::SYMBOL_SYM)
  );
}

/****************************************************************************/
bool ParserStatus::BracketFound(int Left_, int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong val_ = Left_ ? (SymbolSet::LeftBracket | SymbolSet::Symbol_Type | SymbolSet::Found):
                       (SymbolSet::RightBracket | SymbolSet::Symbol_Type | SymbolSet::Found);

  return
  (
    InBracket.Any() &&
    SymFoundArray == (val_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::BRACKETED |
                     ParserSymbolType::SYMBOL_SYM)
  );
}

/****************************************************************************/
bool ParserStatus::StateSwitchFound(int Type_, int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong Symval_ = SymbolSet::StateSwitch | SymbolSet::Operator_Type | SymbolSet::Found;
  Ulong Opval_ = Type_;
  
  return
  (
    InSymbol.Any() &&
    SymFoundArray == (Symval_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    OpFoundArray == (Opval_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::SYMBOL |
                     ParserSymbolType::SYMBOL_OP)
  );
}

/****************************************************************************/
bool ParserStatus::SymbolsFound(int Type_, int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong Symval_ = Type_ | SymbolSet::Symbol_Type | SymbolSet::Found;
  
  return
  (
    InSymbol.Any() &&
    SymFoundArray == (Symval_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::SYMBOL |
                     ParserSymbolType::SYMBOL_SYM)
  );
}

/****************************************************************************/
bool ParserStatus::OperatorFound(int Type_, int ScopeLevel_)
{
  int Index_ = FoundIndex - 1;
  Ulong Symval_ = SymbolSet::Operator_Type | SymbolSet::Found;
  Ulong Opval_ = Type_;
  
  return
  (
    InSymbol.Any() &&
    SymFoundArray == (Symval_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    OpFoundArray == (Opval_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    ScopeArray == (ScopeLevel_ << Ulong(Index_ * SYMARRAY_INCR)) &&
    CurrentToken == (ParserSymbolType::SYMBOL |
                     ParserSymbolType::SYMBOL_OP)
  );
}

/****************************************************************************/
#endif
