#ifndef SYMSTATUS_H
#define SYMSTATUS_H
#ifndef TOKEN_H
  #include "token.h"
#endif

struct ParserStatus
{
  // According to bit number in
  // ParserFlags bit vector
  enum
  {
    CASE_SENSITIVE = 1,
    SYMARRAY_INCR = 12,
    STACK_INCR = 16    
  };

  ParserStatus();
  ParserStatus(const ParserStatus& Stk_);
  ParserStatus(ParserStatus* Head_, FieldInfo* ScopeToken_);
  ~ParserStatus();  

  int CalcNestingLevel();
  void Assign(ParserStatus* Status_);
  void ResetParseFlags();
  int ResetStatusFlag();
  void Reset();
  void SetError();

  void SetInLiteral();
  void SetInSymbol();
  void SetInBracket();  
  void SetInGroup();
  void SetInOption();

  void SetParseLiteral();
  void SetParseSymbol();
  void SetParseGroup();
  void SetParseOption();
  void SetParseRepOption();
  void SetInParserOption();
  void SetCaseSensitive(int BoolVal_);

  // Symbols found set methods
  void SetTerminatorFound(int ScopeLevel_);
  void SetStarterFound(int ScopeLevel_);
  void SetBracketFound(int Left_, int ScopeLevel_);
  void SetStateSwitchFound(int Type_, int ScopeLevel_);
  void SetSymbolsFound(int Type_, int ScopeLevel_);
  void SetOperatorFound(int Type_, int ScopeLevel_);
  
  void ResetOpSymFlags();
  void AssignOpSymFlags(ParserStatus* Status_);

  // Symbols found convenience methods
  bool TerminatorFound(int ScopeLevel_);
  bool StarterFound(int ScopeLevel_);
  bool BracketFound(int Left_, int ScopeLevel_);
  bool StateSwitchFound(int Type_, int ScopeLevel_);
  bool SymbolsFound(int Type_, int ScopeLevel_);
  bool OperatorFound(int Type_, int ScopeLevel_);  

  static ParserStatus* Push(ParserStatus* Head_, FieldInfo* ScopeToken_);
  static ParserStatus* Pop(ParserStatus** Head_, bool PopScope_);

  void GrowSyntaxStr(int Size_);
  void PushSyntaxStr(const char* Str_);
  char* CurrentSyntaxStr();
  char* PopSyntaxStr();
  void ClearSyntaxStr();

  int ParseError;
  int NestingLevel;
  int ScopeLevel;
  int CurrentToken;
  int GroupLevel;
  int ParseGroup;
  BitVector InGroup;
  int OptionLevel;
  int ParseOption;
  BitVector InOption;
  int ParseSymbol;
  BitVector InSymbol;
  BitVector InBracket;
  int DelimCount;
  
  int ParseLiteral;
  BitVector InLiteral;
  int InParserOption;
  int Repeatable;
  int TokenType;

  // Scope separators
  FieldInfo* _ScopeToken;
  ParserStatus* _Enclosing;
  bool _Copied;

  /// Symbols/operators currently found
  int FoundIndex;
  BitVector OpFoundArray;
  BitVector SymFoundArray;
  BitVector ScopeArray;
  ///
  
  int StackDisplayLevel;
  int DeepestLevel;
  BitVector ParserFlags;

  char** _SyntaxStr;
  int _SyntaxStrIndex;
  int _SyntaxStrLen;

  // old data members
  char* OldSyntaxStr;
  char* NewSyntaxStr;
  char* NewInputStr;  

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

#endif
