#ifndef SYMTABLE_CPP
#define SYMTABLE_CPP
#ifndef SYMTABLE_H
  #include "symtable.h"
#endif

/****************************************************************************/
// ParseSymbolType class definition
/****************************************************************************/
ParserSymbolType::ParserSymbolType():
_Symbol(NULL),
_Definition(NULL)
{}

/****************************************************************************/
ParserSymbolType::~ParserSymbolType()
{
  ::DeleteArray(_Symbol);
  ::DeleteArray(_Definition);
}

/****************************************************************************/
void ParserSymbolType::DefineSymbol(const char* Symbol_, const char* Def_)
{
  _Symbol = new_char_string(Symbol_);
  _Definition = new_char_string(Def_);
}

/****************************************************************************/
// ParserSymbolTable class definition
/****************************************************************************/
ParserSymbolTable::ParserSymbolTable():
_NumSymbols(0),
_MaxParseSymbols(PARSE_SYMBOLS_INCR),
_ParseSymbols(NULL)
{
  int i;
  int Max_;

  // Array limit for storage of user defined symbols
  Max_ = _MaxParseSymbols;  
  _ParseSymbols = (ParserSymbolType**)RawAllocateWith(MEMMATRIX, sizeof(ParserSymbolType*) * Max_);
  
  for (i = 0; i < Max_; i++)
    _ParseSymbols[i] = NULL;
}

/****************************************************************************/
ParserSymbolTable::~ParserSymbolTable()
{
  int i;
  int Max_ = _NumSymbols;
  
  for (i = 0; i < Max_; i++)
    delete _ParseSymbols[i];

  ::DeleteArray(_ParseSymbols);
}

/****************************************************************************/
void ParserSymbolTable::ReadDefinitionFile(const char* FileName_)
{
  size_t Len_, Max_;
  int LineBufSize_ = LINE_BUFFER_SIZE;
  char *Ptr_, *SymPtr_, *DefBuf_;  
  char* LineBuf_ = new_char_array(LineBufSize_, NULL);
  ifstream Fin_;

  PATHTOKENIZER(Pathtok_, "PATH");
  Max_ = Pathtok_.Max();
  size_t i;

  char* AbsPath_ = new_char_array(LINE_BUFFER_SIZE + strlen(FileName_), FileName_);
  Fin_.open(AbsPath_, ios::in);
  
  for (i = 0; !Fin_.good() && i < Max_; i++)
  {
    strcpy(AbsPath_, Pathtok_[i]);
    strcat(AbsPath_, Pathtok_.DirSeparator());
    strcat(AbsPath_, FileName_);
    Fin_.clear();
    Fin_.open(AbsPath_, ios::in);
  }
  
  Max_ = LINE_BUFFER_SIZE;

  if (Fin_.good())
  {
    DefBuf_ = new_char_array(Max_, NULL);
  
    while (!Fin_.eof())
    {
      Ptr_ = LineBuf_;
      DefBuf_[0] = 0;
      Len_ = 0;
      
      for (;;)
      {        
        LineBuf_ = ReadStringUntil(Fin_, LineBuf_, LineBufSize_, '\n');
        Ptr_ = LineBuf_;
        Ptr_ = RemovePadding(Ptr_, " \t\n");

        if (!strlen(Ptr_) || strncmp(Ptr_, "//", 2) == 0)
        {
          if (Fin_.eof())
            break;
        
          Ptr_ = LineBuf_;
          continue;
        }

        Len_ += strlen(Ptr_);

        if (Len_ >= Max_)
        {
          while (Len_ >= Max_)
            Max_ += LINE_BUFFER_SIZE;
            
          DefBuf_ = ResizeString(DefBuf_, Max_);
        }

        strcat(DefBuf_, Ptr_);

        if (Ptr_[strlen(Ptr_) - 1] == ';')
        {
          DefBuf_[strlen(DefBuf_) - 1] = 0;
          break;
        }
        else
          Ptr_ = LineBuf_;

        if (Fin_.eof())
          break;                    
      }

      if (Ptr_ = strstr(DefBuf_, "::="))
      {
        --Ptr_;
        *Ptr_ = 0;
        Ptr_ += 4;
        
        SymPtr_ = DefBuf_;        
        SymPtr_ = RemovePadding(SymPtr_, " \t\n");
        Ptr_ = RemovePadding(Ptr_, " \t\n");
        
        DefineSymbol(SymPtr_, Ptr_);
      }
    }

    ::DeleteArray(DefBuf_);
  }

  ::DeleteArray(AbsPath_);
  ::DeleteArray(LineBuf_);
  Fin_.close();
}

/****************************************************************************/
void ParserSymbolTable::GrowSymbolTable()
{
  ParserSymbolType** OldTable_ = _ParseSymbols;
  int OldMax_ = _MaxParseSymbols;
  int i = 0;
  
  _MaxParseSymbols += PARSE_SYMBOLS_INCR;
  _ParseSymbols = (ParserSymbolType**)RawAllocateWith(MEMMATRIX, sizeof(ParserSymbolType*) * _MaxParseSymbols);

  for (;i < OldMax_; i++)
    _ParseSymbols[i] = OldTable_[i];

  for (;i < _MaxParseSymbols; i++)
    _ParseSymbols[i] = NULL;

  ::DeleteArray(OldTable_);
}

/****************************************************************************/
void ParserSymbolTable::DefineSymbol(char* Symbol_, char* Definition_)
{
  if (_NumSymbols < _MaxParseSymbols)
  {
    if (!_NumSymbols)
    {
      _ParseSymbols[0] = new ParserSymbolType;
      _ParseSymbols[0]->DefineSymbol(Symbol_, Definition_);
      _NumSymbols++;          
    }
    else
    {
      int Pos_ = _NumSymbols - 1;
      int Result_ = 0;
      int Found_ = 0;
      
      while (Pos_ > 0 && (Result_ = strcmp(Symbol_, _ParseSymbols[Pos_]->_Symbol)) < 0)
        Pos_--;

      if (Pos_ > 0)
      {
        if (Result_ > 0)
          Pos_++;
        else
          Found_ = 1;
      }
      else if (Pos_ == 0)
      {
        Result_ = strcmp(Symbol_, _ParseSymbols[0]->_Symbol);
        
        if (Result_ < 0)
          Pos_ = 0;
        else if (Result_ > 0)
          Pos_ = 1;
        else
          Found_ = 1;
      }

      if (!Found_)
      {
        if (Pos_ < _NumSymbols)
          memmove(&_ParseSymbols[Pos_+1], &_ParseSymbols[Pos_], (_NumSymbols - Pos_) * sizeof(ParserSymbolType*));
          
        _ParseSymbols[Pos_] = new ParserSymbolType;
        _ParseSymbols[Pos_]->DefineSymbol(Symbol_, Definition_);
        _NumSymbols++;
      }
    }
  }
  else
  {
    GrowSymbolTable();
    DefineSymbol(Symbol_, Definition_);
  }
}

/****************************************************************************/
char* ParserSymbolTable::FindDefinition(const char* Symbol_)
{
  int Low_ = 0;
  int High_ = _NumSymbols;
  int Mid_;  
  int Result_;

  while (Low_ <= High_ && (Result_ = strcmp(Symbol_, _ParseSymbols[Mid_=(Low_+High_)/2]->_Symbol)))
  {    
    if (Result_ < 0)
      High_ = Mid_ - 1;
    else if (Result_ > 0)
      Low_ = Mid_ + 1;
  }

  if (Result_)
    return NULL;

  return _ParseSymbols[Mid_]->_Definition;
}

/****************************************************************************/
MEMORYOPS_DEFN(ParserSymbolType)
MEMORYOPS_DEFN(ParserSymbolTable)

/****************************************************************************/
#endif
