#ifndef SYMTABLE_H
#define SYMTABLE_H
#ifndef SYMBOLS_H
  #include "symbols.h"
#endif

// BEGIN: classes for BNF quick parser
struct ParserSymbolType
{
  // Token Types
  enum
  {
    NO_TOKEN = 0,
    LITERAL = 1,
    SYMBOL = 2,
    OPTION = 4,
    GROUP = 8,
    OR_BRANCH = 16,
    REPEATABLE = 32,
    PARSER_OPTION = 64,
    
    SYM_BRACKETED = 128,
    SYM_SYMBOL = 256,
    SYM_OPERATOR = 512,
    SYM_SEQUENCE = 1024,
    SYM_BRANCHOUT = 2048
  };

  ParserSymbolType();
  ~ParserSymbolType();

  char* _Symbol;
  char* _Definition;

  void DefineSymbol(const char* Symbol_, const char* Def_);
  
#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class ParserSymbolTable
{
  protected:
    int _NumSymbols;
    int _MaxParseSymbols;
    ParserSymbolType** _ParseSymbols;

  public:
    enum
    {
      PARSE_SYMBOLS_INCR = 256,
      LINE_BUFFER_SIZE   = 512
    };
  
    ParserSymbolTable();
    ~ParserSymbolTable();

    void ReadDefinitionFile(const char* FileName_);
    void GrowSymbolTable();
    
    void DefineSymbol(char* Symbol_, char* Definition_);
    char* FindDefinition(const char* Symbol_);    

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif    
};

#endif
