#ifndef TAGELEMENT_CPP
#define TAGELEMENT_CPP
#ifndef TAGELEMENT_H
  #include "tagelement.h"
#endif

/****************************************************************************/
// Static and global variable declarations
/****************************************************************************/
// For TagBracketList class
//
const char* TagBracketList::_DocTypeOpen_Str = NULL;
const char* TagBracketList::_DocTypeClose_Str = NULL;
const char* TagBracketList::_CommentOpen_Str = NULL;
const char* TagBracketList::_CommentClose_Str = NULL;
const char* TagBracketList::_NestedComment1Open_Str = NULL;
const char* TagBracketList::_NestedComment1Close_Str = NULL;
const char* TagBracketList::_NestedComment2Open_Str = NULL;
const char* TagBracketList::_NestedComment2Close_Str = NULL;
const char* TagBracketList::_StdTagOpen_Str = NULL;
const char* TagBracketList::_StdTagClose_Str = NULL;
const char* TagBracketList::_EndTagOpen_Str = NULL;
const char* TagBracketList::_EndTagClose_Str = NULL;
const char* TagBracketList::_EmptyOpen_Str = NULL;
const char* TagBracketList::_EmptyClose_Str = NULL;
const char* TagBracketList::_ScriptOpen_Str = NULL;
const char* TagBracketList::_ScriptClose_Str = NULL;

const char* TagBracketList::_CCommentBlkOpen_Str = NULL;
const char* TagBracketList::_CCommentBlkClose_Str = NULL;
const char* TagBracketList::_COpenCommentBlkOpen_Str = NULL;
const char* TagBracketList::_COpenCommentBlkClose_Str = NULL;
const char* TagBracketList::_CCloseCommentBlkOpen_Str = NULL;
const char* TagBracketList::_CCloseCommentBlkClose_Str = NULL;
const char* TagBracketList::_CppCommentLineOpen_Str = NULL;
const char* TagBracketList::_CppCommentLineClose_Str = NULL;
char** TagBracketList::_GlobalTagBrkList = NULL;

// Static class instance data member initializations
//
STATICCLASSINSTANCE_VARS_INIT(TagBracketList)
STATICCLASSINSTANCE_VARS_INIT(TagCountData)
STATICCLASSINSTANCE_VARS_INIT(TagElementComparer)
STATICCLASSINSTANCE_VARS_INIT(TagElementMatchTagComparer)

bool TagCountData::_DestroyLists = true;

/****************************************************************************/
// TagElementStates class definitions
/****************************************************************************/
TagElementStates::TagElementStates(StackNodeInfo* Parent_, size_t NodeID_):
_Parent(Parent_),
_StackNodeID(NodeID_),

_Validity(0),
_NestingLevel(0),
_TagCount(0),
_HtmlContTagType(0),

_ReqTagCond(0),
_ImpliedEndCond(0),
_ValidityState(0),

_ReqTagFoundIndex(0),
_ImpliedTagFound(false),
_ReqTagDirFound(0),
_EndTag(NULL),
_EndTagCond(0),

_TagCountsSet(0),
_ReqTagCondChanged(0),
_ImpliedEndCondChanged(0),
_ValidityStateChanged(0)
{}

/****************************************************************************/
void TagElementStates::ResetState(bool States_, bool Conds_,
                                  bool Counts_, bool TagConsts_,
                                  bool ReqTagSrch_)
{
  if (TagConsts_)
  {
    _Validity = 0;
    _HtmlContTagType = 0;
  }

  if (States_)
  {
    _ReqTagCondChanged = 0;
    _ImpliedEndCondChanged = 0;
    _ValidityStateChanged = 0;
  }

  if (Conds_)
  {
    SetTagValidityState(TagEnums::INACTIVE);
    _ReqTagCond = TagEnums::TAG_NOT_FOUND;
    _ImpliedEndCond = TagEnums::TNF_IMPLIEDEND_NOT_MET;
  }

  if (Counts_)
  {
    _TagCountsSet = 0;
    _NestingLevel = 0;
    _TagCount = 0;
  }

  if (ReqTagSrch_)
  {
    _ReqTagFoundIndex = 0;
    _ImpliedTagFound = false;
    _ReqTagDirFound = 0;
    _EndTag = NULL;
    _EndTagCond = 0;
  }
}

/****************************************************************************/
bool TagElementStates::SetTagValidityState(int Val_)
{
  if ((Val_ == TagEnums::IGNORED) ||
      (Val_ == TagEnums::INACTIVE &&
       _Validity == TagEnums::INACTIVE &&
       _ValidityState == TagEnums::ACTIVE) ||
      (Val_ == TagEnums::ACTIVE &&
       _Validity != TagEnums::IGNORED &&
       _ValidityState == TagEnums::INACTIVE))
  {
    _ValidityStateChanged = 0;
    int Saved_ = _ValidityState;
    _ValidityState = Val_;

    if (Saved_ != Val_)
      _ValidityStateChanged = 1;

    return true;
  }

  return false;
}

/****************************************************************************/
void TagElementStates::CopyFromTagStates(const TagElement* TagPtr_,
                                         bool States_, bool Conds_)
{
  if (TagPtr_)
  {
    if (States_)
    {
      TagPtr_->_ReqTagCondChanged = _ReqTagCondChanged;
      TagPtr_->_ImpliedEndCondChanged = _ImpliedEndCondChanged;
      TagPtr_->_ValidityStateChanged = _ValidityStateChanged;
    }

    if (Conds_)
    {
      TagPtr_->_TagAttrib[TagEnums::REQTAGCOND] = _ReqTagCond;
      TagPtr_->_TagAttrib[TagEnums::IMPLIEDENDCOND] = _ImpliedEndCond;
      TagPtr_->_TagAttrib[TagEnums::VALIDITYSTATE] = _ValidityState;
    }
  }
}

/****************************************************************************/
void TagElementStates::CopyToTagStates(const TagElement* TagPtr_,
                                       bool States_, bool Conds_,
                                       bool Counts_, bool TagConsts_)
{
  if (TagPtr_)
  {
    if (TagConsts_)
    {
      _Validity = TagPtr_->_TagAttrib[TagEnums::VALIDITY];
      _HtmlContTagType = TagPtr_->_TagAttrib[TagEnums::HTMLCONTTAGTYPE];
    }

    if (States_)
    {
      _ReqTagCondChanged = TagPtr_->_ReqTagCondChanged;
      _ImpliedEndCondChanged = TagPtr_->_ImpliedEndCondChanged;
      _ValidityStateChanged = TagPtr_->_ValidityStateChanged;
    }

    if (Conds_)
    {
      _ReqTagCond = TagPtr_->_TagAttrib[TagEnums::REQTAGCOND];
      _ImpliedEndCond = TagPtr_->_TagAttrib[TagEnums::IMPLIEDENDCOND];
      _ValidityState = TagPtr_->_TagAttrib[TagEnums::VALIDITYSTATE];
    }

    if (Counts_ && !TagCountsSet())
    {
      _TagCountsSet = 1;
      _NestingLevel = TagPtr_->TagNesting(false);
      _TagCount = TagPtr_->_TagAttrib[TagEnums::TAGCOUNT];
    }
  }
}

/****************************************************************************/
MEMORYOPS_DEFN(TagElementStates)

/****************************************************************************/
// TagElement class definitions
/****************************************************************************/
TagElement::TagElement(int ListSeq_, int TagAttr_,
                       const TagCountData* Parent_, int* ParentAttr_,
                       bool DefnOnly_, TagElementStates* TagStates_):
_Parent(Parent_),
_MatchTag(NULL),

_BefRequiredTags(NULL),
_MatchingEndTags(NULL),
_EnclosingPairTags(NULL),
_MaxBefReqTags(0),
_NumBefReqTags(0),

_AftRequiredTags(NULL),
_MaxAftReqTags(0),
_NumAftReqTags(0),

_TagStates(TagStates_),
_SrcTagStates(NULL)
{
  // Reset all conditions and change states
  ResetState(true, true, true, false, false);

  // Erase all tag attributes to 0 then inherit with parent's tag attributes
  ::memset(_TagAttrib, 0, sizeof(int) * MAX_FIELDS);
  if (ParentAttr_)
    ::memmove(_TagAttrib, ParentAttr_, sizeof(int) * MAX_FIELDS);

  // assign list sequence position in tag list where this object is stored
  _TagAttrib[TagEnums::LISTSEQ] = ListSeq_;

  // assign tag element specific attribute setting
  if (TagAttr_)
  {
    _TagAttrib[TagEnums::TAGATTR] = TagAttr_;

    // Insure TAG_SPECIFIC attribute is set for standard starting pair tag
    if (!(TagAttr_ & TagEnums::PAIR_ENDER) &&
        !(TagAttr_ & TagEnums::SINGLETON_TAGATTR) &&
        !(TagAttr_ & TagEnums::EMPTY_TAGATTR) &&
       _TagAttrib[TagEnums::TAGINDEX] == TagEnums::STD_DEX)
      _TagAttrib[TagEnums::TAGATTR] |= TAG_SPECIFIC;
  }

  // If tag element definition only the set transient tag properties like
  // tag count and tag nesting to zero.
  if (DefnOnly_)
  {
    _TagAttrib[TagEnums::TAGCOUNT] = 0;
    _TagAttrib[TagEnums::NESTING] = 0;
  }
  else
  {
    // Set tag count and nesting for this tag element to it's initial value
    // The tag count is always incremented for Non-PairEnder type tags
    if (!IsPairEndTag())
      IncrTagAttrib(TagEnums::TAGCOUNT);

    if (IsPairStartTag())
      IncrTagAttrib(TagEnums::NESTING);

    if (_TagStates && !_TagStates->TagCountsSet())
      CopyToTagStates(false, false, true, true);
  }

  GrowVector(TagEnums::BEFORE_REQTAG);
  GrowVector(TagEnums::AFTER_REQTAG);
}

/****************************************************************************/
TagElement::TagElement(const TagElement& Obj_):
_Parent(Obj_._Parent),
_TagName(Obj_._TagName),
_MatchTag(NULL),

_BefRequiredTags(NULL),
_MatchingEndTags(NULL),
_EnclosingPairTags(NULL),
_MaxBefReqTags(0),
_NumBefReqTags(0),

_AftRequiredTags(NULL),
_MaxAftReqTags(0),
_NumAftReqTags(0),

_TagStates(Obj_._TagStates),
_SrcTagStates(Obj_._SrcTagStates)
{
  // Reset all conditions and change states
  ResetState(true, true, true, false, false);

  SetMatchingTag(Obj_._MatchTag);
  ::memmove(_TagAttrib, Obj_._TagAttrib, sizeof(int) * MAX_FIELDS);
  ResetTagFoundCond();

  GrowVector(TagEnums::BEFORE_REQTAG, Obj_._MaxBefReqTags);
  GrowVector(TagEnums::AFTER_REQTAG, Obj_._MaxAftReqTags);
  CopyVectors(Obj_);
}

/****************************************************************************/
TagElement::~TagElement()
{
  ResetRequiredTags();
  RawDeleteArray(_BefRequiredTags);
  RawDeleteArray(_MatchingEndTags);
  RawDeleteArray(_EnclosingPairTags);
  RawDeleteArray(_AftRequiredTags);
}

/****************************************************************************/
//
//   VALIDITY        = 0,  // Inherits parent's tag validity
//   NESTING         = 1,  // Tag element specific nesting, overwrites parent
//   TAGCOUNT        = 2,  // Tag element specific tag count. overwrites parent
//   TAGATTR         = 3,  // Tag element's attribute is set upon object creation
//   TAGINDEX        = 4,  // Inherits parent's tag index
//   MATCHINDEX      = 5,  // Inherits parent's matching tag index
//   TAGPOS          = 6,  // Tag position: opening, forbidden, closing
//   LISTSEQ         = 7,  // List seq. position is set upon object creation
//   OPTREQTAGORDER  = 8,  // Required tag order for start+end optional tags
//   IMPLIEDEND      = 9,  // Implied end of tag at specific condition met
//   REQTAGCOND      = 10, // Required tag for s+e optional tag found: { false/true }
//   IMPLIEDENDCOND  = 11, // Implied end state for tags with specific implied end conditions
//   VALIDITYSTATE   = 12, // Tag validity state correlating with 0th element valid tag
//   HTMLCONTTAGTYPE = 13, // Html content tag type for html tags
//
bool TagElement::UpdateTagElement(const TagElement& Obj_)
{
  bool Updated_ = false;

  // TagElement object properties specific to a particular tag matches?
  //
  // If yes then
  //   update tag count and nesting for this tag element if the same
  //   tag was encountered during the tag search.
  if (TestReqTagCond(Obj_, 0))
  {
    // The tag count is always incremented for Non-PairEnder type tags
    if (!IsPairEndTag())
      IncrTagAttrib(TagEnums::TAGCOUNT);

    // Increment nesting if tag attribute indicates a pair or standard tag,
    // otherwise decrement nesting if the argument tag is same as this
    // TagElement object matching end tag object
    if (IsPairStartTag())
      IncrTagAttrib(TagEnums::NESTING);

    // update tag nesting value in tag states structure
    if (_TagStates && !_TagStates->TagCountsSet())
      CopyToTagStates(false, false, true, true);

    // set updated flag true as function return value
    Updated_ = true;
  }
  else if (Obj_.IsPairEndTag() &&
           _MatchTag && IsMatchingTag(&Obj_))
  {
    // Making sure nothing goes wrong with unexpected mismatched attributes
    if (_MatchTag->IsPairEndTag())
    {
      // The tag count is incremented for matching end tags of this tag
      _MatchTag->IncrTagAttrib(TagEnums::TAGCOUNT);

      // Ending tag of PairTag is assigned the same nesting level as start tag
      _MatchTag->SetTagAttrib(TagEnums::NESTING, TagNesting());
    }

    // Decrement nesting if the found tag is the pair ender tag for
    // this tag object
    DecrTagAttrib(TagEnums::NESTING);

    // update tag nesting value in tag states structure
    if (_TagStates && !_TagStates->TagCountsSet())
      CopyToTagStates(false, false, true, true);

    // set updated flag true as function return value
    Updated_ = true;
  }

  return Updated_;
}

/****************************************************************************/
void TagElement::DestroyMatchingTag()
{
  delete _MatchTag;
  _MatchTag = NULL;
}

/****************************************************************************/
void TagElement::SetTagListSeq(int ListSeq_)
{
  // assign list sequence position in tag list where this object is stored
  _TagAttrib[TagEnums::LISTSEQ] = ListSeq_;
}

/****************************************************************************/
TagElement& TagElement::IncrTagAttrib(int Attr_, int Incr_)
{
  if (Incr_ && (Attr_ == TagEnums::NESTING || Attr_ == TagEnums::TAGCOUNT))
    if (Incr_ > 0)
      _TagAttrib[Attr_] += Incr_;

  return *this;
}

/****************************************************************************/
TagElement& TagElement::DecrTagAttrib(int Attr_, int Decr_)
{
  if (Decr_ && (Attr_ == TagEnums::NESTING || Attr_ == TagEnums::TAGCOUNT))
    if (Decr_ > 0 && _TagAttrib[Attr_] >= Decr_)
      _TagAttrib[Attr_] -= Decr_;

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetTagAttrib(int Attr_, int Value_)
{
  _TagAttrib[Attr_] = Value_;
  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetSingletonAllowed(bool Set_)
{
  bool Opt_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR);
  int Mask_ = ~TagEnums::ALLOW_SINGLETON_TAG;

  if (Opt_)
  {
    if (Set_)
      Mask_ |= TagEnums::ALLOW_SINGLETON_TAG;

    _TagAttrib[TagEnums::TAGATTR] = (_TagAttrib[TagEnums::TAGATTR] & Mask_);
  }

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetEmptyAllowed(bool Set_)
{
  bool Opt_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR);
  int Mask_ = ~TagEnums::ALLOW_EMPTY_TAG;

  if (Opt_)
  {
    if (Set_)
      Mask_ |= TagEnums::ALLOW_EMPTY_TAG;

    _TagAttrib[TagEnums::TAGATTR] = (_TagAttrib[TagEnums::TAGATTR] & Mask_);
  }

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetPairEnderTag(bool PairEnder_)
{
  if (PairEnder_)
    _TagAttrib[TagEnums::TAGATTR] |= TagEnums::PAIR_ENDER;
  else if (!PairEnder_)
    _TagAttrib[TagEnums::TAGATTR] &= ~TagEnums::PAIR_ENDER;

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetSingletonTag(bool Single_)
{
  bool Opt_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR);
  bool SingletonAllowed_ = false;

  SingletonAllowed_ = Opt_ &&
    (_TagAttrib[TagEnums::TAGATTR] & TagEnums::ALLOW_SINGLETON_TAG);

  if (Single_ && SingletonAllowed_)
    _TagAttrib[TagEnums::TAGATTR] |= TagEnums::SINGLETON_TAGATTR;
  else if (!Single_)
    _TagAttrib[TagEnums::TAGATTR] &= ~TagEnums::SINGLETON_TAGATTR;

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetEmptyTag(bool Empty_)
{
  bool Opt_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR);
  bool EmptyAllowed_ = false;

  EmptyAllowed_ = Opt_ &&
    (_TagAttrib[TagEnums::TAGATTR] & TagEnums::ALLOW_EMPTY_TAG);

  if (Empty_ && EmptyAllowed_)
    _TagAttrib[TagEnums::TAGATTR] |= TagEnums::EMPTY_TAGATTR;
  else if (!Empty_)
    _TagAttrib[TagEnums::TAGATTR] &= ~TagEnums::EMPTY_TAGATTR;

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetContainerTag(bool Contain_)
{
  bool Opt_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR);
  bool Pair_ = (_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR);
  bool ContainerAllowed_ = (Opt_ || Pair_);

  if (Contain_ && ContainerAllowed_)
    _TagAttrib[TagEnums::TAGATTR] |= TagEnums::TAG_CONTAINER;
  else if (!Contain_)
    _TagAttrib[TagEnums::TAGATTR] &= ~TagEnums::TAG_CONTAINER;

  return *this;
}

/****************************************************************************/
void TagElement::CopyToTagStates(bool States_, bool Conds_,
                                 bool Counts_, bool TagConsts_) const
{
  if (_TagStates)
    _TagStates->CopyToTagStates(this, States_, Conds_, Counts_, TagConsts_);
}

/****************************************************************************/
void TagElement::CopyFromTagStates(bool States_, bool Conds_) const
{
  if (_TagStates)
  {
    if (States_)
    {
      _ReqTagCondChanged = _TagStates->_ReqTagCondChanged;
      _ImpliedEndCondChanged = _TagStates->_ImpliedEndCondChanged;
      _ValidityStateChanged = _TagStates->_ValidityStateChanged;
    }

    if (Conds_)
    {
      _TagAttrib[TagEnums::REQTAGCOND] = _TagStates->_ReqTagCond;
      _TagAttrib[TagEnums::IMPLIEDENDCOND] = _TagStates->_ImpliedEndCond;
      _TagAttrib[TagEnums::VALIDITYSTATE] = _TagStates->_ValidityState;
    }
  }
}

/****************************************************************************/
void TagElement::RenewTagElementState()
{
  if (_TagStates)
  {
    bool SetCounts_ = !_TagStates->TagCountsSet();
    CopyToTagStates(false, false, SetCounts_, true);
  }
}

/****************************************************************************/
void TagElement::SetTagElementState(TagElementStates* Ptr_)
{
  _TagStatesChanged = 0;
  TagElementStates* Saved_ = _TagStates;
  _TagStates = Ptr_;

  if (_TagStates && Saved_ != _TagStates)
    _TagStatesChanged = 1;

  if (_TagStatesChanged && _TagStates)
  {
    bool SetCounts_ = !_TagStates->TagCountsSet();
    CopyFromTagStates(true, true);
    CopyToTagStates(false, false, SetCounts_, true);
  }
}

/****************************************************************************/
void TagElement::ResetState(bool States_, bool Conds_,
                            bool Counts_, bool TagConsts_,
                            bool ReqTagSrch_)
{
  if (States_)
  {
    _TagStatesChanged = 0;
    _ReqTagCondChanged = 0;
    _ImpliedEndCondChanged = 0;
    _ValidityStateChanged = 0;
  }

  if (Conds_)
  {
    SetTagValidityState(TagEnums::INACTIVE);
    _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::TAG_NOT_FOUND;
    _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::TNF_IMPLIEDEND_NOT_MET;
  }

  if (Counts_)
  {
    _TagAttrib[TagEnums::NESTING] = 0;
    _TagAttrib[TagEnums::TAGCOUNT] = 0;
  }

  if (_TagStates)
    _TagStates->ResetState(States_, Conds_, Counts_, TagConsts_, ReqTagSrch_);
}

/****************************************************************************/
bool TagElement::SetTagValidityState(int Val_) const
{
  if ((Val_ == TagEnums::IGNORED) ||
      (Val_ == TagEnums::INACTIVE &&
       _TagAttrib[TagEnums::VALIDITY] == TagEnums::INACTIVE &&
       _TagAttrib[TagEnums::VALIDITYSTATE] == TagEnums::ACTIVE) ||
      (Val_ == TagEnums::ACTIVE &&
       _TagAttrib[TagEnums::VALIDITY] != TagEnums::IGNORED &&
       _TagAttrib[TagEnums::VALIDITYSTATE] == TagEnums::INACTIVE))
  {
    _ValidityStateChanged = 0;
    int Saved_ = _TagAttrib[TagEnums::VALIDITYSTATE];
    _TagAttrib[TagEnums::VALIDITYSTATE] = Val_;

    if (Saved_ != Val_)
      _ValidityStateChanged = 1;

    return true;
  }

  return false;
}

/****************************************************************************/
TagElement& TagElement::SetTagPos(int TagPos_)
{
  _TagAttrib[TagEnums::TAGPOS] = TagPos_;
  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetTagName(const ChrString& Tag_)
{
  _TagName = Tag_;
  _TagName.SetCaseSensitive(FALSE);
  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetMatchingTag(TagElement* MatchTag_, bool Terminate_)
{
  if (MatchTag_)
  {
    _MatchTag = MatchTag_;
  
    if (!Terminate_)
      _MatchTag->SetMatchingTag(this, true);
  }
  
  return *this;
}

/****************************************************************************/
TagElement** TagElement::InitTagElementArray(TagElement** ArrPtr_, size_t max)
{
  size_t x;
  if (ArrPtr_)
    for (x = 0; x < max; x++)
      ArrPtr_[x] = NULL;

  return ArrPtr_;
}

/****************************************************************************/
void TagElement::CopyVectors(const TagElement& Obj_)
{
  TagElement* TagPtr_ = NULL;
  TagElement* NewPtr_ = NULL;
  long x;

  long tIndex_ = 0;
  long xTagMax_ = _MaxBefReqTags;
  long TagMax_ = Obj_._MaxBefReqTags;
  long TagLen_ = Obj_._NumBefReqTags;
  bool HasEntries_ = TagLen_ && Obj_._BefRequiredTags[TagLen_-1] &&
                     (Obj_._TagAttrib[TagEnums::OPTREQTAGORDER] == BEFORE_REQTAG ||
                      Obj_._TagAttrib[TagEnums::OPTREQTAGORDER] == SURROUND_REQTAG);

  _TagAttrib[TagEnums::OPTREQTAGORDER] = Obj_._TagAttrib[TagEnums::OPTREQTAGORDER];
  _TagAttrib[TagEnums::IMPLIEDEND] = Obj_._TagAttrib[TagEnums::IMPLIEDEND];
  _TagAttrib[TagEnums::REQTAGCOND] = Obj_._TagAttrib[TagEnums::REQTAGCOND];
  _TagAttrib[TagEnums::IMPLIEDENDCOND] = Obj_._TagAttrib[TagEnums::IMPLIEDENDCOND];
  _TagAttrib[TagEnums::VALIDITYSTATE] = Obj_._TagAttrib[TagEnums::VALIDITYSTATE];

  if (HasEntries_)
    for (_NumBefReqTags = x = 0; x < TagLen_; x++)
    {
      if (x == xTagMax_ ||
          _NumBefReqTags == xTagMax_)
        GrowVector(TagEnums::BEFORE_REQTAG);

      TagPtr_ = Obj_._BefRequiredTags[x];
      
      if (TagPtr_)
      {
        tIndex_ = _NumBefReqTags;
        NewPtr_ = new TagElement(*TagPtr_);
        _BefRequiredTags[_NumBefReqTags++] = NewPtr_;
        _MatchingEndTags[tIndex_] = Obj_._MatchingEndTags[x];
        _EnclosingPairTags[tIndex_] = Obj_._EnclosingPairTags[x];
      }
    }

  xTagMax_ = _MaxAftReqTags;
  TagMax_ = Obj_._MaxAftReqTags;
  TagLen_ = Obj_._NumAftReqTags;
  HasEntries_ = TagLen_ && Obj_._AftRequiredTags[TagLen_-1] &&
                (Obj_._TagAttrib[TagEnums::OPTREQTAGORDER] == AFTER_REQTAG ||
                 Obj_._TagAttrib[TagEnums::OPTREQTAGORDER] == SURROUND_REQTAG);

  if (HasEntries_)
    for (_NumAftReqTags = x = 0; x < TagLen_; x++)
    {
      if (x == xTagMax_ ||
          _NumAftReqTags == xTagMax_)
        GrowVector(TagEnums::AFTER_REQTAG);
    
      TagPtr_ = Obj_._AftRequiredTags[x];
      
      if (TagPtr_)
      {
        NewPtr_ = new TagElement(*TagPtr_);
        _AftRequiredTags[_NumAftReqTags++] = NewPtr_;
      }
    }
}

/****************************************************************************/
TagElement** TagElement::EraseVector(int ReqTagOrder_)
{
  long x;
  long max = 0;
  long Index_ = 0;
  long* TagMax_ = NULL;

  TagElement** TagElmMatrix_[2];

  TagElmMatrix_[0] = _BefRequiredTags;
  TagElmMatrix_[1] = _AftRequiredTags;

  if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
  {
    Index_ = 0;
    TagMax_ = &_MaxBefReqTags;
    _NumBefReqTags = 0;
    ::memset(_MatchingEndTags, 0, sizeof(bool) * _MaxBefReqTags);
    ::memset(_EnclosingPairTags, 0, sizeof(bool) * _MaxBefReqTags);
  }
  else if (ReqTagOrder_ == TagEnums::AFTER_REQTAG)
  {
    Index_ = 1;
    TagMax_ = &_MaxAftReqTags;
    _NumAftReqTags = 0;
  }

  if (TagMax_)
    for (x = 0; x < *TagMax_; x++)
      TagElmMatrix_[Index_][x] = NULL;  // no deletion for Req. Tags

  if (Index_ == 0)
    _BefRequiredTags = TagElmMatrix_[Index_];
  else if (Index_ == 1)
    _AftRequiredTags = TagElmMatrix_[Index_];

  return TagElmMatrix_[Index_];
}

/****************************************************************************/
TagElement** TagElement::GrowVector(int ReqTagOrder_, long Incr_)
{
  long max = 0;
  long tmax = 0;
  long Index_ = 0;
  long* MaxTags_ = NULL;
  bool* MatchArray_ = NULL;
  TagElement** TagArray_ = NULL;
  TagElement** TagElmMatrix_[2];

  TagElmMatrix_[0] = _BefRequiredTags;
  TagElmMatrix_[1] = _AftRequiredTags;

  if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
  {
    Index_ = 0;
    TagArray_ = _BefRequiredTags;
    MaxTags_ = &_MaxBefReqTags;
  }
  else if (ReqTagOrder_ == TagEnums::AFTER_REQTAG)
  {
    Index_ = 1;
    TagArray_ = _AftRequiredTags;
    MaxTags_ = &_MaxAftReqTags;
  }

  if (!TagElmMatrix_[Index_] || !(*MaxTags_))
  {
    tmax = max = Incr_ + 1;
    max *= sizeof(TagElement*);
    TagArray_ = (TagElement**)RawAllocateWith(MEMMATRIX, max);
    TagArray_ = InitTagElementArray(TagArray_, tmax);
    TagElmMatrix_[Index_] = TagArray_;
    tmax *= sizeof(bool);

    if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
    {
      MatchArray_ = (bool*)RawAllocateWith(MEMMATRIX, tmax);
      ::memset(MatchArray_, 0, tmax);
      _MatchingEndTags = MatchArray_;

      MatchArray_ = (bool*)RawAllocateWith(MEMMATRIX, tmax);
      ::memset(MatchArray_, 0, tmax);
      _EnclosingPairTags = MatchArray_;
    }

    *MaxTags_ = Incr_;
    TagArray_ = NULL;
    MatchArray_ = NULL;
  }
  else
  {
    tmax = max = *MaxTags_ + Incr_ + 1;
    max *= sizeof(TagElement*);
    TagArray_ = TagElmMatrix_[Index_];
    TagElmMatrix_[Index_] = (TagElement**)RawAllocateWith(MEMMATRIX, max);
    TagElmMatrix_[Index_] = InitTagElementArray(TagElmMatrix_[Index_], tmax);
    max = *MaxTags_ * sizeof(TagElement*);
    ::memmove(TagElmMatrix_[Index_], TagArray_, max);
    tmax *= sizeof(bool);

    if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
    {
      MatchArray_ = _MatchingEndTags;
      _MatchingEndTags = (bool*)RawAllocateWith(MEMMATRIX, tmax);
      ::memset(_MatchingEndTags, 0, tmax);
      tmax = *MaxTags_ * sizeof(bool);
      ::memmove(_MatchingEndTags, MatchArray_, tmax);
      RawDeleteArray(MatchArray_);

      MatchArray_ = _EnclosingPairTags;
      _EnclosingPairTags = (bool*)RawAllocateWith(MEMMATRIX, tmax);
      ::memset(_EnclosingPairTags, 0, tmax);
      tmax = *MaxTags_ * sizeof(bool);
      ::memmove(_EnclosingPairTags, MatchArray_, tmax);
      RawDeleteArray(MatchArray_);
    }

    *MaxTags_ += Incr_;
    RawDeleteArray(TagArray_);
  }

  if (Index_ == 0)
    _BefRequiredTags = TagElmMatrix_[Index_];
  else if (Index_ == 1)
    _AftRequiredTags = TagElmMatrix_[Index_];

  return TagElmMatrix_[Index_];
}

/****************************************************************************/
TagElement& TagElement::ResetRequiredTags()
{
  EraseVector(BEFORE_REQTAG);
  EraseVector(AFTER_REQTAG);

  if (_TagStates)
    ResetState(false, false, false, false, true);

  _TagAttrib[TagEnums::OPTREQTAGORDER] = 0;
  _TagAttrib[TagEnums::IMPLIEDEND] = 0;

  _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::TAG_NOT_FOUND;
  _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::TNF_IMPLIEDEND_NOT_MET;
  _TagAttrib[TagEnums::VALIDITYSTATE] = _TagAttrib[TagEnums::VALIDITY];

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetRequiredCond(int ReqTagOrder_, int ImpliedEnd_,
                                        int TagCond_, int ImpliedEndCond_)
{
  if (ReqTagOrder_ >= 0)
    _TagAttrib[TagEnums::OPTREQTAGORDER] = ReqTagOrder_;

  if (ImpliedEnd_ >= 0)
    _TagAttrib[TagEnums::IMPLIEDEND] = ImpliedEnd_;

  if (TagCond_ >= 0)
    _TagAttrib[TagEnums::REQTAGCOND] = TagCond_;

  if (ImpliedEndCond_ >= 0)
    _TagAttrib[TagEnums::IMPLIEDENDCOND] = ImpliedEndCond_;

  _TagAttrib[TagEnums::VALIDITYSTATE] = _TagAttrib[TagEnums::VALIDITY];
  return *this;
}

/****************************************************************************/
TagElement& TagElement::AddRequiredTag(TagElement* ReqTag_,
                                       int ReqTagOrder_, bool MatchingEnd_)
{
  // Tags should be added in order from least important (earliest added) to
  // most important (most recently added) to the reqtag stack
  //
  bool HasEntries_ = false;
  long tIndex_ = 0;

  if (ReqTagOrder_ == BEFORE_REQTAG)
  {
    if (_NumBefReqTags == _MaxBefReqTags)
      GrowVector(ReqTagOrder_);

    HasEntries_ = _MaxBefReqTags && ReqTag_;

    if (HasEntries_)
    {
      tIndex_ = _NumBefReqTags;
      _BefRequiredTags[_NumBefReqTags++] = ReqTag_;
      _MatchingEndTags[tIndex_] = MatchingEnd_;

      if (_BefRequiredTags[tIndex_] && _AftRequiredTags[tIndex_])
        _EnclosingPairTags[tIndex_] =
        _AftRequiredTags[tIndex_]->IsMatchingTag(_BefRequiredTags[tIndex_]);
    }
  }
  else if (ReqTagOrder_ == AFTER_REQTAG)
  {
    if (_NumAftReqTags == _MaxAftReqTags)
      GrowVector(ReqTagOrder_);

    HasEntries_ = _MaxAftReqTags && ReqTag_;

    if (HasEntries_)
      _AftRequiredTags[_NumAftReqTags++] = ReqTag_;
  }

  if (ReqTagOrder_ && HasEntries_ &&
      _TagAttrib[TagEnums::OPTREQTAGORDER] != SURROUND_REQTAG)
  {
    _TagAttrib[TagEnums::OPTREQTAGORDER] = ReqTagOrder_;

    if (_BefRequiredTags[0] && _NumBefReqTags &&
        _AftRequiredTags[0] && _NumAftReqTags)
      _TagAttrib[TagEnums::OPTREQTAGORDER] = SURROUND_REQTAG;
  }
  else if (!HasEntries_)
    return *this;

  _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::TAG_NOT_FOUND;
  _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::TNF_IMPLIEDEND_NOT_MET;
  _TagAttrib[TagEnums::VALIDITYSTATE] = _TagAttrib[TagEnums::VALIDITY];

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetRequiredTags(TagElement** Vect_,
                                        int ReqTagOrder_, bool MatchingEnd_)
{
  long x;
  long tIndex_ = 0;
  long Index_ = 0;
  long* TagLen_ = 0;
  long* TagMax_ = 0;
  bool HasEntries_ = false;

  TagElement* TagPtr_ = NULL;
  TagElement* NewPtr_ = NULL;
  TagElement** TagElmMatrix_[2];

  TagElmMatrix_[0] = _BefRequiredTags;
  TagElmMatrix_[1] = _AftRequiredTags;

  if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
  {
    Index_ = 0;
    TagLen_ = &_NumBefReqTags;
    TagMax_ = &_MaxBefReqTags;
    HasEntries_ = *TagMax_ && Vect_ && Vect_[0];
  }
  else if (ReqTagOrder_ == TagEnums::AFTER_REQTAG)
  {
    Index_ = 1;
    TagLen_ = &_NumAftReqTags;
    TagMax_ = &_MaxAftReqTags;
    HasEntries_ = *TagMax_ && Vect_ && Vect_[0];
  }

  if (HasEntries_)
  {
    for (*TagLen_ = x = 0; Vect_[x]; x++)
    {
      if (x == *TagMax_ ||
          *TagLen_ == *TagMax_)
        GrowVector(ReqTagOrder_);

      TagPtr_ = Vect_[x];

      if (TagPtr_)
      {
        tIndex_ = *TagLen_;
        NewPtr_ = new TagElement(*TagPtr_);
        TagElmMatrix_[Index_][(*TagLen_)++] = NewPtr_;

        if (ReqTagOrder_ == TagEnums::BEFORE_REQTAG)
        {
          _MatchingEndTags[tIndex_] = MatchingEnd_;

          if (_BefRequiredTags[tIndex_] && _AftRequiredTags[tIndex_])
            _EnclosingPairTags[tIndex_] =
            _AftRequiredTags[tIndex_]->IsMatchingTag(_BefRequiredTags[tIndex_]);
        }
      }
    }

    if (Index_ == 0)
      _BefRequiredTags = TagElmMatrix_[Index_];
    else if (Index_ == 1)
      _AftRequiredTags = TagElmMatrix_[Index_];
  }

  if (ReqTagOrder_ && HasEntries_ &&
      _TagAttrib[TagEnums::OPTREQTAGORDER] != SURROUND_REQTAG)
  {
    _TagAttrib[TagEnums::OPTREQTAGORDER] = ReqTagOrder_;

    if (TagElmMatrix_[0][0] && _NumBefReqTags &&
        TagElmMatrix_[1][0] && _NumAftReqTags)
      _TagAttrib[TagEnums::OPTREQTAGORDER] = SURROUND_REQTAG;
  }
  else if (!HasEntries_)
    return *this;

  _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::TAG_NOT_FOUND;
  _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::TNF_IMPLIEDEND_NOT_MET;
  _TagAttrib[TagEnums::VALIDITYSTATE] = _TagAttrib[TagEnums::VALIDITY];

  return *this;
}

/****************************************************************************/
TagElement& TagElement::SetHtmlContentTagType(int ContentType_)
{
  if (ContentType_ >= 0)
    _TagAttrib[TagEnums::HTMLCONTTAGTYPE] = ContentType_;

  return *this;
}

/****************************************************************************/
bool TagElement::NestedTagAllowed() const
{
  // SetupHtmlContentTag(
  //   TagPtr_,
  //   if (Tag Type == Singleton OR
  //       Tag Type == Empty)
  //     TagEnums::AT_NEXTTAG,
  //     NestedTags = false
  //   else if (Tag Type == Pair OR
  //            End Tag == required)
  //     TagEnums::NO_IMPLIEDEND,
  //     NestedTags = true
  //   else if (Tag Type == OptionalPair OR
  //            End Tag == optional)
  //   {
  //     if (Container Tag == yes)
  //     {
  //       if (Duplicate Tags == yes AND
  //           Nested Tags == no)
  //         TagEnums::AT_BEFORE_REQTAG | TagEnums::AT_IMPLIEDTAG,
  //         NestedTags = false
  //       else if (ContentTagType != HtmlSpecial AND
  //                Nested Tags == no)
  //         TagEnums::AT_BEFORE_REQTAG,
  //         NestedTags = false
  //       else if (ContentTagType == HtmlSpecial AND
  //                Nested Tags == no)
  //         TagEnums::AT_EOF,
  //         NestedTags = false
  //       else
  //         TagEnums:NO_IMPLIEDEND,
  //         NestedTags = true
  //     }
  //     else
  //     {
  //       if (Duplicate Tags == yes AND
  //           Nested Tags == no)
  //         TagEnums::AT_IMPLIEDTAG,
  //         NestedTags = false
  //       else if (Nested Tags == no)
  //         TagEnums::AT_NEXTTAG,
  //         NestedTags = false
  //       else if (Duplicate Tags == yes AND
  //                Nested Tags == yes)
  //         TagEnums::NO_IMPLIEDEND,
  //         NestedTags = true
  //     }
  //   }
  // );

  // new
  return
  (
    ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::EMPTY_TAGATTR) ||
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::SINGLETON_TAGATTR))    ? false:
    ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR) &&
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_CONTAINER))        ? true:
    (_TagAttrib[TagEnums::IMPLIEDEND] &&
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR)) ? false:false
  );
}

/****************************************************************************/
bool TagElement::DuplicateTagAllowed() const
{
  // SetupHtmlContentTag(
  //   TagPtr_,
  //   if (Tag Type == Singleton OR
  //       Tag Type == Empty)
  //     TagEnums::AT_NEXTTAG,
  //     DuplicateTags = true
  //   else if (Tag Type == Pair OR
  //            End Tag == required)
  //     TagEnums::NO_IMPLIEDEND
  //     DuplicateTags = true
  //   else if (Tag Type == OptionalPair OR
  //            End Tag == optional)
  //   {
  //     if (Container Tag == yes)
  //     {
  //       if (Duplicate Tags == yes AND
  //           Nested Tags == no)
  //         TagEnums::AT_BEFORE_REQTAG | TagEnums::AT_IMPLIEDTAG,
  //         DuplicateTags = true
  //       else if (ContentTagType != HtmlSpecial AND
  //                Nested Tags == no)
  //         TagEnums::AT_BEFORE_REQTAG,
  //         DuplicateTags = false
  //       else if (ContentTagType == HtmlSpecial AND
  //                Nested Tags == no)
  //         TagEnums::AT_EOF,
  //         DuplicateTags = false
  //       else
  //         TagEnums:NO_IMPLIEDEND,
  //         DuplicateTags = true
  //     }
  //     else
  //     {
  //       if (Duplicate Tags == yes AND
  //           Nested Tags == no)
  //         TagEnums::AT_IMPLIEDTAG,
  //         DuplicateTags = true
  //       else if (Nested Tags == no)
  //         TagEnums::AT_NEXTTAG,
  //         DuplicateTags = false
  //       else if (Duplicate Tags == yes AND
  //                Nested Tags == yes)
  //         TagEnums::NO_IMPLIEDEND,
  //         DuplicateTags = true
  //     }
  //   }
  // );

  // new
  return
  (
    ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::EMPTY_TAGATTR) ||
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::SINGLETON_TAGATTR))    ? true:
    ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR) &&
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_CONTAINER))        ? true:
    (((_TagAttrib[TagEnums::IMPLIEDEND] == 0) ||
      (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_IMPLIEDTAG)) &&
     (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR)) ? true:false
  );
}

/****************************************************************************/
long TagElement::NumEnclosingPairs() const
{
  // new
  long x;
  long TagCnt_ = 0;

  for (x = 0; x < _NumBefReqTags; x++)
    if (_EnclosingPairTags[x])
      ++TagCnt_;

  return TagCnt_;
}

/****************************************************************************/
TagElement* TagElement::EnclosingPair(long Index_)
{
  // new
  long x;
  long TagCnt_ = 0;

  for (x = 0; x < _NumBefReqTags; x++)
    if (_EnclosingPairTags[x])
    {
      ++TagCnt_;

      if (TagCnt_ == Index_+1)
        return ((_AftRequiredTags[x] && _BefRequiredTags[x]) ?
                    _AftRequiredTags[x]:
                    NULL);
    }

  return NULL;
}

/****************************************************************************/
TagElement* TagElement::MoreRequiredBeforeTags(int& Index_, bool& Reset_)
{
  // new
  long x;

  if (Reset_)
  {
    Reset_ = false;
    for (x = Index_ = 0; x < _NumBefReqTags; x++)
      if (!_EnclosingPairTags[x] && _BefRequiredTags[x])
      {
        Index_ = x;
        return _BefRequiredTags[x];
      }
  }
  else
  {
    for (x = Index_ + 1; x < _NumBefReqTags; x++)
      if (!_EnclosingPairTags[x] && _BefRequiredTags[x])
      {
        Index_ = x;
        return _BefRequiredTags[x];
      }
  }

  Index_ = _NumBefReqTags;
  return NULL;
}

/****************************************************************************/
TagElement* TagElement::MoreRequiredAfterTags(int& Index_, bool& Reset_)
{
  // new
  long x;

  if (Reset_)
  {
    Reset_ = false;
    for (x = Index_ = 0; x < _NumAftReqTags; x++)
      if (!_EnclosingPairTags[x] && _AftRequiredTags[x])
      {
        Index_ = x;
        return _AftRequiredTags[x];
      }
  }
  else
  {
    for (x = Index_ + 1; x < _NumAftReqTags; x++)
      if (!_EnclosingPairTags[x] && _AftRequiredTags[x])
      {
        Index_ = x;
        return _AftRequiredTags[x];
      }
  }

  Index_ = _NumAftReqTags;
  return NULL;
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsContainerTag(bool Optional_, bool Both_) const
{
  return
  (
    Optional_ ?
      (Both_ ?
         (((_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) ||
           (_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR)) &&
          (_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_CONTAINER)):
         ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) &&
          (_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_CONTAINER))):
      ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR) &&
       (_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_CONTAINER))
  );
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsOptionalTag() const
{
  // new
  // Is optional tag pair type?
  return ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) &&
          (_TagAttrib[TagEnums::TAGINDEX] % 2 == 0));
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsSingleTag(bool ExcludeEmpty_) const
{
  // new
  // Is singleton or empty tag type?
  return (((_TagAttrib[TagEnums::TAGATTR] & SINGLETON_TAGATTR) ||
           (!ExcludeEmpty_ && (_TagAttrib[TagEnums::TAGATTR] & EMPTY_TAGATTR))) &&
          (_TagAttrib[TagEnums::TAGINDEX] % 2 == 0));
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsPairStartTag() const
{
  // Is the starting tag of a tag pair sequence?
  return (((_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) ||
           (_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_TAGATTR)) &&
          (_TagAttrib[TagEnums::TAGINDEX] % 2 == 0));
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsPairEndTag() const
{
  // Is the ending tag of a tag pair sequence?
  return ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::PAIR_ENDER) &&
          (_TagAttrib[TagEnums::TAGINDEX] % 2 == 0));
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
bool TagElement::IsPairTag(bool* Optional_, bool* Single_, bool* Empty_,
                           bool* Ender_, bool* Container_, bool* TagSpecific_) const
{
  return IsPairTagAttr(_TagAttrib[TagEnums::TAGATTR],
                       Optional_, Single_, Empty_,
                       Ender_, Container_, TagSpecific_);
}

/****************************************************************************/
// 3rd element: tag attrib bits =
//                { 0   = none,
//                  1   = singleton,
//                  2   = empty,
//                  4   = pair,               // matches with pair ender
//                  8   = optional pair,
//                  16  =   allow singleton,  // only set if optional pair
//                  32  =   allow empty,      // only set if optional pair
//                  64  = pair ender,         // single tag to match tag pair
//                  128 = tag container,      // specifies container type tag
//                  256 = tag specific }      // specific to tag element
//
// if Optional tag attribute is set true then
//   Single_ argument is set to the (allow singleton) tag attribute bit pos
//   Empty_ argument is set to the (allow empty) tag attribute bit pos
//
bool TagElement::IsPairTagAttr(int TagAttr_, bool* Optional_, bool* Single_,
                               bool* Empty_, bool* Ender_, bool* Container_,
                               bool* TagSpecific_)
{
  bool Opt_ = (TagAttr_ & TagEnums::OPTIONALPAIR_TAGATTR);
  bool Pair_ = (TagAttr_ & TagEnums::PAIR_TAGATTR);

  if (TagSpecific_)
    *TagSpecific_ = (TagAttr_ & TagEnums::TAG_SPECIFIC);

  if (Pair_ || Opt_)
  {
    if (Optional_)
      *Optional_ = Opt_;

    if (Single_)
      *Single_ = Opt_ &&
        (TagAttr_ & TagEnums::ALLOW_SINGLETON_TAG);

    if (Empty_)
      *Empty_ = Opt_ &&
        (TagAttr_ & TagEnums::ALLOW_EMPTY_TAG);

    if (Ender_)
      *Ender_ = false;

    if (Container_)
      *Container_ = (TagAttr_ & TagEnums::TAG_CONTAINER);

    return true;
  }

  bool SglFound_ = (TagAttr_ & TagEnums::SINGLETON_TAGATTR);
  bool EmpFound_ = (TagAttr_ & TagEnums::EMPTY_TAGATTR);
  bool PendFound_ = (TagAttr_ & TagEnums::PAIR_ENDER);

  if (Optional_)
    *Optional_ = false;

  if (Single_)
    *Single_ = SglFound_;

  if (Empty_)
    *Empty_ = EmpFound_;

  if (Ender_)
    *Ender_ = PendFound_;

  if (Container_)
    *Container_ = !(SglFound_ || EmpFound_ || PendFound_) &&
                  (TagAttr_ & TagEnums::TAG_CONTAINER);

  return false;
}

/****************************************************************************/
TagElement& TagElement::operator = (const TagElement& Obj_)
{
  if (this != &Obj_)
  {
    SetTagElementState(Obj_._TagStates);
    SetSourceTagElementState(Obj_._SrcTagStates);
    ResetState(true, true, true, false, false);
    SetMatchingTag(Obj_._MatchTag);
    ::memmove(_TagAttrib, Obj_._TagAttrib, sizeof(int) * MAX_FIELDS);
    ResetTagFoundCond();

    _TagName = Obj_._TagName;
    _TagName.SetCaseSensitive(FALSE);

    ResetRequiredTags();
    GrowVector(TagEnums::BEFORE_REQTAG, Obj_._MaxBefReqTags);
    GrowVector(TagEnums::AFTER_REQTAG, Obj_._MaxAftReqTags);
    CopyVectors(Obj_);
  }

  return *this;
}

/****************************************************************************/
bool TagElement::NonContainerOptTagMatch(const TagElement* Ptr_) const
{
  if (!Ptr_)
    return false;

  return
  (
    (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_IMPLIEDTAG) &&
    (_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) &&
    (Ptr_->_TagAttrib[TagEnums::TAGATTR] & TagEnums::OPTIONALPAIR_TAGATTR) &&
    (TagName() == Ptr_->TagName()) &&
    (_TagAttrib[TAGPOS] == TagEnums::OPENING) &&
    (_TagAttrib[TAGPOS] == Ptr_->_TagAttrib[TAGPOS])
  );
}

/****************************************************************************/
bool TagElement::HasRequiredTagAddr(const TagElement* Ptr_) const
{
  long x;
  long max;

  if (Ptr_)
  {
    max = _NumBefReqTags;
    for (x = 0; x < max && _BefRequiredTags[x]; x++)
      if (Ptr_ == _BefRequiredTags[x])
        return true;

    max = _NumAftReqTags;
    for (x = 0; x < max && _AftRequiredTags[x]; x++)
      if (Ptr_ == _AftRequiredTags[x])
        return true;
  }

  return false;
}

/****************************************************************************/
// Required Tag sequence check:
// if (_TagAttrib[OPTREQTAGORDER] == AFTER_REQTAG)
//   if (*this == Obj_)
//     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
//   else
//   {
//     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
//       2.1 TAG_NOT_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
//       if (AftReqTagFound_)
//         2.2 REQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
//         2.3 REQTAG_COND_MET
//   }}
//
// if (_TagAttrib[OPTREQTAGORDER] == BEFORE_REQTAG)
//   if (BefTagNotFound_ && *_BefRequiredTag == Obj_)
//     1.0 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
//   else
//   {
//     if (BefTagNotFound_ && *this == Obj_) {
//       2.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
//       if (CurTagFound_)
//         2.2 CURTAG_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
//         2.3 REQTAG_COND_MET
//   }}
//
// if (_TagAttrib[OPTREQTAGORDER] == SURROUND_REQTAG)
//   if (*this == Obj_)
//     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
//   else
//   {
//     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
//       2.1 TAG_NOT_FOUND-->AFTREQTAG_FOUND : from IsRequiredTag(&Obj_)
//       if (AftReqTagFound_)
//         2.1.1 AFTREQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
//         2.1.2 CurTagFound_ = true
//         if (CurTagFound_ &&
//             BefTagNotFound_ && *_BefRequiredTag == Obj_) {
//           3.1 CURTAG_FOUND-->BEFREQTAG_FOUND
//           3.2 REQTAG_COND_MET
//
//     if (CurTagNotFound_ &&
//         BefTagNotFound_ && *_BefRequiredTag == Obj_) {
//       2.2 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
//   }}
//
// if (_TagAttrib[OPTREQTAGORDER] == NO_REQTAG)
//   if (*this == Obj_)
//     1.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
//     1.2 REQTAG_COND_MET
//
bool TagElement::MatchesRequiredTags(const TagElement* Ptr_,
                                     bool* BefTagFndPtr_,
                                     bool* AftTagFndPtr_) const
{
  // Required tags should be searched in order from most important
  // (most recently added) to least important (earliest added)
  // to the reqtag stack
  //
  bool aft = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::AFTER_REQTAG;
  bool bef = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::BEFORE_REQTAG;
  bool sur = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::SURROUND_REQTAG;
  bool noreq = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::NO_REQTAG;

  bool CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
  bool AftTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);
  bool BefTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::BEFREQTAG_FOUND);
  bool ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);
  bool ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);

  long x;
  long max;
  long Index_ = 0;
  bool MatchingEndTag_ = false;

  TagElement* TagElmPtr_;
  TagElement** TagElmMatrix_[2];

  TagElmMatrix_[0] = _BefRequiredTags;
  TagElmMatrix_[1] = _AftRequiredTags;

  if (ReqCondMet_)
    return true;

  if (_TagStates)
    _TagStates->ResetState(false, false, false, false, true);

  if (!noreq && !ReqCondNotMet_ && Ptr_)
  {
    if (bef || (sur && AftTagFound_ && CurTagFound_ && !BefTagFound_))
    {
      max = _NumBefReqTags;
      Index_ = 0;

      if (BefTagFndPtr_)
        *BefTagFndPtr_ = false;

      for (x = max-1; x >= 0 && TagElmMatrix_[Index_][x]; x--)
      {
        TagElmPtr_ = TagElmMatrix_[Index_][x];
        MatchingEndTag_ = _MatchingEndTags[x];

        if (Ptr_->TagName() == TagElmPtr_->TagName() &&
            Ptr_->_TagAttrib[TAGPOS] == TagElmPtr_->_TagAttrib[TAGPOS] &&
            (!MatchingEndTag_ ||
               (TagNesting(false) == TagElmPtr_->TagNesting(false) &&
                TagCount() >= TagElmPtr_->TagCount() &&
                IsMatchingTag(TagElmPtr_))))
        {
          if (BefTagFndPtr_)
            *BefTagFndPtr_ = true;

          SetReqTagDirFound(TagEnums::BEFORE_REQTAG);
          SetReqTagFoundIndex(x);
          return true;
        }
      }

      if (NonContainerOptTagMatch(Ptr_))
      {
        SetImpliedTagFound(true);
        return true;
      }
    }
    else if (aft || (sur && !AftTagFound_ && !CurTagFound_ && !BefTagFound_))
    {
      max = _NumAftReqTags;
      Index_ = 1;

      if (AftTagFndPtr_)
        *AftTagFndPtr_ = false;

      for (x = max-1; x >= 0 && TagElmMatrix_[Index_][x]; x--)
      {
        TagElmPtr_ = TagElmMatrix_[Index_][x];

        if (Ptr_->TagName() == TagElmPtr_->TagName() &&
            Ptr_->_TagAttrib[TAGPOS] == TagElmPtr_->_TagAttrib[TAGPOS])
        {
          if (AftTagFndPtr_)
            *AftTagFndPtr_ = true;

          SetReqTagDirFound(TagEnums::AFTER_REQTAG);
          SetReqTagFoundIndex(x);
          return true;
        }
      }

      if (NonContainerOptTagMatch(Ptr_))
      {
        SetImpliedTagFound(true);
        return true;
      }
    }
  }

  return false;
}

/****************************************************************************/
// Raw tag lookup equality method
//
bool TagElement::TagLookupEqual(const TagElement& Obj_) const
{
  if (&Obj_ != this)
  {
    // tag name element must match
    bool TagNameEqual_ = _TagName == Obj_._TagName;

    // comparing matching tags if present
    bool MatchTagEqual_ = false;

    if ((Obj_._MatchTag == _MatchTag) || (!_MatchTag && !Obj_._MatchTag))
    {
      MatchTagEqual_ = true;
      return (TagNameEqual_ && MatchTagEqual_);
    }

    if ((!_MatchTag && Obj_._MatchTag) ||
        (_MatchTag && !Obj_._MatchTag))
    {
      MatchTagEqual_ = false;
      return (TagNameEqual_ && MatchTagEqual_);
    }

    // tag name elements must match
    MatchTagEqual_ = _MatchTag->TagName() == Obj_._MatchTag->TagName();
    return (TagNameEqual_ && MatchTagEqual_);
  }

  return true;
}

/****************************************************************************/
bool TagElement::IsEqual(const TagElement& Obj_) const
{
  return TestReqTagCond(Obj_, 0);
}

/****************************************************************************/
//
//   VALIDITY        = 0,  // Inherits parent's tag validity
//   NESTING         = 1,  // Tag element specific nesting, overwrites parent
//   TAGCOUNT        = 2,  // Tag element specific tag count. overwrites parent
//   TAGATTR         = 3,  // Tag element's attribute is set upon object creation
//   TAGINDEX        = 4,  // Inherits parent's tag index
//   MATCHINDEX      = 5,  // Inherits parent's matching tag index
//   TAGPOS          = 6,  // Tag position: opening, forbidden, closing
//   LISTSEQ         = 7,  // List seq. position is set upon object creation
//   OPTREQTAGORDER  = 8,  // Required tag order for start+end optional tags
//   IMPLIEDEND      = 9,  // Implied end of tag at specific condition met
//   REQTAGCOND      = 10, // Required tag for s+e optional tag found: { false/true }
//   IMPLIEDENDCOND  = 11, // Implied end state for tags with specific implied end conditions
//   VALIDITYSTATE   = 12, // Tag validity state correlating with 0th element valid tag
//   HTMLCONTTAGTYPE = 13, // Html content tag type for html tags
//
bool TagElement::TestReqTagCond(const TagElement& Obj_, int TestingCond_) const
{
  int TagCntMask_ = ~TagEnums::TAG_CONTAINER;

  // Checking for changes in tag element states
  int SavedReqTagCond_  = _TagAttrib[TagEnums::REQTAGCOND];
  int SavedImpliedEndCond_ = _TagAttrib[TagEnums::IMPLIEDENDCOND];

  bool ReqCondNotMet_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);
  bool ReqCondMet_      = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
  bool TagCondMetNoReq_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::TAG_COND_MET_NOREQ);
  bool CurTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
  bool AftTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);
  bool BefTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::BEFREQTAG_FOUND);
  bool ReqTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);
  bool TestCurrentTag_  = !TagCondMetNoReq_ && !ReqCondNotMet_ && !ReqCondMet_;

  bool aft = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::AFTER_REQTAG;
  bool bef = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::BEFORE_REQTAG;
  bool sur = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::SURROUND_REQTAG;
  bool noreq = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::NO_REQTAG;
  bool ret = false;

  bool ImpliedEndReached_ =
         _TagAttrib[TagEnums::IMPLIEDENDCOND] == TagEnums::REQTAG_IMPLIEDEND_MET;
  bool AtNextTag_ = (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_NEXTTAG);
  bool AtImpliedTag_ = (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_IMPLIEDTAG);
  bool NonCntMatchFound_ = false;
  bool NonCntMatch_ = false;

  if (!TestingCond_ || TestingCond_ == TagEnums::CURRENT_REQTAG)
    ret = (&Obj_ == this) ? true:
    (
      // tag name element must match
      _TagName.StriComp(Obj_._TagName) == 0 &&

      // comparing 3rd, 4th and 5th tag attribute elements only:
      //   tagattrib, brk index, matching brk index
      ((((_TagAttrib[TagEnums::TAGATTR] & TagEnums::TAG_SPECIFIC) ||
         ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::SINGLETON_TAGATTR) &&
          (Obj_._TagAttrib[TagEnums::TAGATTR] & TagEnums::ALLOW_SINGLETON_TAG)) ||
         ((_TagAttrib[TagEnums::TAGATTR] & TagEnums::EMPTY_TAGATTR) &&
          (Obj_._TagAttrib[TagEnums::TAGATTR] & TagEnums::ALLOW_EMPTY_TAG)) ||
         (((_TagAttrib[TagEnums::TAGATTR] & TagEnums::SINGLETON_TAGATTR) ||
           (_TagAttrib[TagEnums::TAGATTR] & TagEnums::EMPTY_TAGATTR)) &&
          ((Obj_._TagAttrib[TagEnums::TAGATTR] & TagEnums::SINGLETON_TAGATTR) ||
           (Obj_._TagAttrib[TagEnums::TAGATTR] & TagEnums::EMPTY_TAGATTR)))) &&
        ::memcmp(&_TagAttrib[4], &Obj_._TagAttrib[4], sizeof(int) * 3) == 0) ||

       ((_TagAttrib[TagEnums::TAGATTR] & TagCntMask_) ==
        (Obj_._TagAttrib[TagEnums::TAGATTR] & TagCntMask_) &&
        ::memcmp(&_TagAttrib[4], &Obj_._TagAttrib[4], sizeof(int) * 3) == 0)) &&

      // comparing matching tags if present
      CompareMatchingTags(Obj_)
    );

  // exit from function if have no specified testing condition
  if (!TestingCond_ || !_TagStates)
    return ret;

  if (ret)
  {
    NonCntMatch_ = NonContainerOptTagMatch(&Obj_);
    NonCntMatchFound_ = (TestingCond_ && !noreq) &&
      ((aft && ReqTagFound_ && CurTagFound_ && NonCntMatch_ && ReqCondMet_) ||
       (bef && !ReqTagFound_ && CurTagFound_ && NonCntMatch_ && !ReqCondMet_) ||
       (sur && AftTagFound_ && !BefTagFound_ && CurTagFound_ && NonCntMatch_ && !ReqCondMet_));
  }

  // Required Tag sequence check:
  // if (_TagAttrib[OPTREQTAGORDER] == AFTER_REQTAG)
  //   if (*this == Obj_)
  //     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
  //       2.1 TAG_NOT_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
  //       if (AftReqTagFound_)
  //         2.2 REQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //         2.3 REQTAG_COND_MET
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == BEFORE_REQTAG)
  //   if (BefTagNotFound_ && *_BefRequiredTag == Obj_)
  //     1.0 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (BefTagNotFound_ && *this == Obj_) {
  //       2.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //       if (CurTagFound_)
  //         2.2 CURTAG_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
  //         2.3 REQTAG_COND_MET
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == SURROUND_REQTAG)
  //   if (*this == Obj_)
  //     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
  //       2.1 TAG_NOT_FOUND-->AFTREQTAG_FOUND : from IsRequiredTag(&Obj_)
  //       if (AftReqTagFound_)
  //         2.1.1 AFTREQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //         2.1.2 CurTagFound_ = true
  //         if (CurTagFound_ &&
  //             BefTagNotFound_ && *_BefRequiredTag == Obj_) {
  //           3.1 CURTAG_FOUND-->BEFREQTAG_FOUND
  //           3.2 REQTAG_COND_MET
  //
  //     if (CurTagNotFound_ &&
  //         BefTagNotFound_ && *_BefRequiredTag == Obj_) {
  //       2.2 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == NO_REQTAG)
  //   if (*this == Obj_)
  //     1.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //     1.2 REQTAG_COND_MET

  _ReqTagCondChanged = 0;
  _ImpliedEndCondChanged = 0;

  ReqTagFound_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);

  if (ret &&
      (TestingCond_ == TagEnums::CURRENT_REQTAG || NonCntMatchFound_))
  {
    if (_TagStates && (aft || bef || sur))
      _TagStates->ResetState(false, false, false, false, true);

    if (aft)
    {
      if (_TagAttrib[TagEnums::REQTAGCOND] == TagEnums::TAG_NOT_FOUND)
        _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
      else if (TestCurrentTag_ || NonCntMatchFound_)
      {
        if (ReqTagFound_)
        {
          if (!CurTagFound_)
            _TagAttrib[TagEnums::REQTAGCOND] |= (TagEnums::CURTAG_FOUND |
                                                 TagEnums::REQTAG_COND_MET);
          else if (CurTagFound_ && NonCntMatch_)
            SetImpliedTagFound(true);
        }
      }

      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && AtImpliedTag_)
      {
        if (ImpliedTagFound() && (CurTagFound_ && ReqCondMet_))
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
        else if (ReqCondNotMet_)
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
      }
      else if (CurTagFound_ && ReqCondMet_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (TagAtReqTagCondNIE() && IsSingleTag() &&
                 TagImpliedEnd() != TagEnums::AT_NEXTTAG)
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_CURRENTTAG);
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
    else if (bef)
    {
      if (_TagAttrib[TagEnums::REQTAGCOND] == TagEnums::TAG_NOT_FOUND)
        _TagAttrib[TagEnums::REQTAGCOND] |= TagEnums::CURTAG_FOUND;
      else if (TestCurrentTag_)
      {
        if (ReqTagFound_)
          _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
        else if (CurTagFound_ && NonCntMatch_)
        {
          SetImpliedTagFound(true);
          _TagAttrib[TagEnums::REQTAGCOND] |= (TagEnums::REQTAG_FOUND |
                                               TagEnums::REQTAG_COND_MET);
        }
      }

      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      ReqTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && AtImpliedTag_)
      {
        if (ImpliedTagFound() && (CurTagFound_ && ReqTagFound_ && ReqCondMet_))
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
        else if (ReqCondNotMet_)
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
      }
      else if (ReqCondMet_ && AtNextTag_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (CurTagFound_ && AtNextTag_)
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_NEXTTAG);
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
    else if (sur)
    {
      if (AftTagFound_)
      {
        if (!CurTagFound_ && !BefTagFound_)
          _TagAttrib[TagEnums::REQTAGCOND] |= TagEnums::CURTAG_FOUND;
        else if (TestCurrentTag_)
        {
          if (BefTagFound_)
            _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
          else if (CurTagFound_ && NonCntMatch_)
          {
            SetImpliedTagFound(true);
            _TagAttrib[TagEnums::REQTAGCOND] |= (TagEnums::BEFREQTAG_FOUND |
                                                 TagEnums::REQTAG_COND_MET);
          }
        }
      }
      else
        _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;

      AftTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);
      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      BefTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::BEFREQTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && AtImpliedTag_)
      {
        if (ImpliedTagFound() && (AftTagFound_ && CurTagFound_ && BefTagFound_ && ReqCondMet_))
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
        else if (ReqCondNotMet_)
          _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
      }
      else if (ReqCondMet_ && AtNextTag_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (CurTagFound_ && AtNextTag_)
        {
          SetEndTag(Obj_.SourceTagElementState());
          SetEndTagCond(TagEnums::AT_NEXTTAG);
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
    else if (noreq)
    {
      _TagAttrib[TagEnums::REQTAGCOND] = (TagEnums::CURTAG_FOUND |
                                          TagEnums::TAG_COND_MET_NOREQ);

      if (!AtNextTag_ && !AtImpliedTag_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;
    }

    if (SavedReqTagCond_ != _TagAttrib[TagEnums::REQTAGCOND])
      _ReqTagCondChanged = 1;

    if (SavedImpliedEndCond_ != _TagAttrib[TagEnums::IMPLIEDENDCOND])
      _ImpliedEndCondChanged = 1;

    if (_ReqTagCondChanged || _ImpliedEndCondChanged)
      CopyToTagStates(true,
                      (_ReqTagCondChanged || _ImpliedEndCondChanged),
                      false,
                      false);
  }
  else if (TestingCond_ && TestingCond_ != TagEnums::CURRENT_REQTAG &&
           (_BefRequiredTags || _AftRequiredTags || noreq))
    return IsRequiredTag(&Obj_, TestingCond_);

  return ret;
}

/****************************************************************************/
bool TagElement::IsMatchingTag(const TagElement* Ptr_) const
{
  if ((Ptr_ == _MatchTag) || (!_MatchTag && !Ptr_))
    return true;

  if ((!_MatchTag && Ptr_) ||
      (_MatchTag && !Ptr_))
    return false;

  int TagCntMask_ = ~TagEnums::TAG_CONTAINER;
  return
  (
    // tag name elements must match
    _MatchTag->TagName() == Ptr_->TagName() &&

    // comparing 3rd, 4th and 5th tag attribute elements only:
    //   tagattrib, brk index, matching brk index
    ((((*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::TAG_SPECIFIC) ||
       ((*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::SINGLETON_TAGATTR) &&
        (*Ptr_->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::ALLOW_SINGLETON_TAG)) ||
       ((*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::EMPTY_TAGATTR) &&
        (*Ptr_->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::ALLOW_EMPTY_TAG)) ||
       (((*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::SINGLETON_TAGATTR) ||
         (*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::EMPTY_TAGATTR)) &&
        ((*Ptr_->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::SINGLETON_TAGATTR) ||
         (*Ptr_->TagAttribPtr(TagEnums::TAGATTR) & TagEnums::EMPTY_TAGATTR)))) &&
      ::memcmp(_MatchTag->TagAttribPtr(4), Ptr_->TagAttribPtr(4), sizeof(int) * 3) == 0) ||

     ((*_MatchTag->TagAttribPtr(TagEnums::TAGATTR) & TagCntMask_) ==
      (*Ptr_->TagAttribPtr(TagEnums::TAGATTR) & TagCntMask_) &&
      ::memcmp(_MatchTag->TagAttribPtr(4), Ptr_->TagAttribPtr(4), sizeof(int) * 3) == 0))
  );
}

/****************************************************************************/
bool TagElement::IsRequiredTag(const TagElement* Ptr_, int TestingCond_) const
{
  if (HasRequiredTagAddr(Ptr_) ||
      ((!_AftRequiredTags || !_NumAftReqTags) &&
       (!_BefRequiredTags || !_NumBefReqTags) && !Ptr_))
    return true;

  if (!_TagStates ||
      ((!_AftRequiredTags || !_NumAftReqTags) &&
       (!_BefRequiredTags || !_NumBefReqTags) && Ptr_) ||
      ((_AftRequiredTags && _NumAftReqTags) &&
       (_BefRequiredTags && _NumAftReqTags) && !Ptr_))
    return false;

  // tag name elements must match
  // Checking for changes in tag element states
  int SavedValidityState_  = _TagAttrib[TagEnums::VALIDITYSTATE];
  int SavedReqTagCond_     = _TagAttrib[TagEnums::REQTAGCOND];
  int SavedImpliedEndCond_ = _TagAttrib[TagEnums::IMPLIEDENDCOND];

  bool ReqCondNotMet_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);
  bool ReqCondMet_      = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
  bool TagCondMetNoReq_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::TAG_COND_MET_NOREQ);
  bool CurTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
  bool AftTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);
  bool BefTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::BEFREQTAG_FOUND);
  bool ReqTagFound_     = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);
  bool TestPassedTag_   = !TagCondMetNoReq_ && !ReqCondNotMet_ && !ReqCondMet_;

  bool aft = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::AFTER_REQTAG;
  bool bef = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::BEFORE_REQTAG;
  bool sur = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::SURROUND_REQTAG;
  bool noreq = _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::NO_REQTAG;

  bool ImpliedEndReached_ =
         _TagAttrib[TagEnums::IMPLIEDENDCOND] == TagEnums::REQTAG_IMPLIEDEND_MET;
  bool AtNextTag_ = (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_NEXTTAG);
  bool AtImpliedTag_ = (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_IMPLIEDTAG);
  bool AtBeforeReqTag_ = (_TagAttrib[TagEnums::IMPLIEDEND] & TagEnums::AT_BEFORE_REQTAG);

  bool AftTagFnd_ = false;
  bool BefTagFnd_ = false;
  bool ret = false;

  if (ReqCondMet_)
    return true;

  _ReqTagCondChanged = 0;
  _ImpliedEndCondChanged = 0;
  _ValidityStateChanged = 0;

  if (!ReqCondNotMet_ && !noreq)
    ret = MatchesRequiredTags(Ptr_, &BefTagFnd_, &AftTagFnd_);

  CurTagFound_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);

  // Required Tag sequence check:
  // if (_TagAttrib[OPTREQTAGORDER] == AFTER_REQTAG)
  //   if (*this == Obj_)
  //     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
  //       2.1 TAG_NOT_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
  //       if (AftReqTagFound_)
  //         2.2 REQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //         2.3 REQTAG_COND_MET
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == BEFORE_REQTAG)
  //   if (BefTagNotFound_ && *_BefRequiredTag == Obj_)
  //     1.0 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (BefTagNotFound_ && *this == Obj_) {
  //       2.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //       if (CurTagFound_)
  //         2.2 CURTAG_FOUND-->REQTAG_FOUND : from IsRequiredTag(&Obj_)
  //         2.3 REQTAG_COND_MET
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == SURROUND_REQTAG)
  //   if (*this == Obj_)
  //     1.0 CURTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   else
  //   {
  //     if (AftTagNotFound_ && *_AftRequiredTag == Obj_) {
  //       2.1 TAG_NOT_FOUND-->AFTREQTAG_FOUND : from IsRequiredTag(&Obj_)
  //       if (AftReqTagFound_)
  //         2.1.1 AFTREQTAG_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //         2.1.2 CurTagFound_ = true
  //         if (CurTagFound_ &&
  //             BefTagNotFound_ && *_BefRequiredTag == Obj_) {
  //           3.1 CURTAG_FOUND-->BEFREQTAG_FOUND
  //           3.2 REQTAG_COND_MET
  //
  //     if (CurTagNotFound_ &&
  //         BefTagNotFound_ && *_BefRequiredTag == Obj_) {
  //       2.2 REQTAG_FOUND-->REQTAG_COND_NOT_MET : (No further assignments)
  //   }}
  //
  // if (_TagAttrib[OPTREQTAGORDER] == NO_REQTAG)
  //   if (*this == Obj_)
  //     1.1 TAG_NOT_FOUND-->CURTAG_FOUND : from IsEqual(Obj_)
  //     1.2 REQTAG_COND_MET
  //
  if (ret && !ReqCondNotMet_ && !noreq)
  {
    if (aft && (AftTagFnd_ || ImpliedTagFound()) &&
          (TestingCond_ == AFTER_REQTAG ||
           TestingCond_ == SURROUND_REQTAG))
    {
      if (AftTagFnd_)
      {
        if (_TagAttrib[TagEnums::REQTAGCOND] == TagEnums::TAG_NOT_FOUND)
          _TagAttrib[TagEnums::REQTAGCOND] |= TagEnums::REQTAG_FOUND;
        else if (TestPassedTag_ && CurTagFound_)
          _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
      }

      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      ReqTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && (AtNextTag_ || AtImpliedTag_))
      {
        if (!ReqCondMet_ || ReqCondNotMet_)
        {
          if (TestPassedTag_ && CurTagFound_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
        }
        else if (ReqTagFound_)
        {
          if (ImpliedTagFound() || AtNextTag_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
          else if (ReqCondMet_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_NOT_MET;
        }
      }
      else if (CurTagFound_ && ReqCondMet_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (TagAtImpliedEnd() && AtNextTag_)
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_NEXTTAG);
        }
        else if (TagAtReqTagCondNIE() && IsSingleTag() &&
                 TagImpliedEnd() != TagEnums::AT_NEXTTAG)
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_CURRENTTAG);
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
    else if (bef && (BefTagFnd_ || ImpliedTagFound()) &&
               (TestingCond_ == BEFORE_REQTAG ||
                TestingCond_ == SURROUND_REQTAG))
    {
      if (BefTagFnd_ || ImpliedTagFound())
      {
        if (_TagAttrib[TagEnums::REQTAGCOND] == TagEnums::TAG_NOT_FOUND)
          _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
        else if (TestPassedTag_ && CurTagFound_)
          _TagAttrib[TagEnums::REQTAGCOND] |= (TagEnums::REQTAG_FOUND |
                                               TagEnums::REQTAG_COND_MET);
      }

      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      ReqTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && (AtNextTag_ || AtBeforeReqTag_ || AtImpliedTag_))
      {
        if (ReqTagFound_ && ReqCondMet_)
        {
          if (ImpliedTagFound() || AtNextTag_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;
        }
        else if ((TestPassedTag_ && CurTagFound_ && (!ReqTagFound_ || !ReqCondMet_)) || ReqCondNotMet_)
        {
          if (ImpliedTagFound() || AtNextTag_ || ReqTagFound_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
        }
      }
      else if (CurTagFound_ && ReqTagFound_ && ReqCondMet_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (CurTagFound_ && BefTagFnd_ &&
                 ReqTagDirFound() == TagEnums::BEFORE_REQTAG)
        {
          long x = ReqTagFoundIndex();

          if (_BefRequiredTags[x])
          {
            if (_MatchingEndTags[x])
            {
              SetEndTag(Ptr_->SourceTagElementState());
              SetEndTagCond(TagEnums::AT_MATCHENDTAG);
            }
            else
            {
              SetEndTag(Ptr_->SourceTagElementState());
              SetEndTagCond(TagEnums::AT_BEFORE_REQTAG);
            }
          }
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
    else if (sur &&
             ((!AftTagFound_ && AftTagFnd_) ||
              (AftTagFound_ && !AftTagFnd_ &&
               !BefTagFound_ && (BefTagFnd_ || ImpliedTagFound()))) &&
                  (TestingCond_ == AFTER_REQTAG ||
                   TestingCond_ == SURROUND_REQTAG))
    {
      if (!AftTagFound_ && AftTagFnd_ &&
            (TestingCond_ == AFTER_REQTAG ||
             TestingCond_ == SURROUND_REQTAG))
      {
        if (_TagAttrib[TagEnums::REQTAGCOND] == TagEnums::TAG_NOT_FOUND)
        {
          _TagAttrib[TagEnums::REQTAGCOND] |= TagEnums::AFTREQTAG_FOUND;
          SetTagValidityState(TagEnums::ACTIVE);
        }
        else if (TestPassedTag_ && (CurTagFound_ || BefTagFound_))
          _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
      }
      else if (AftTagFound_ && !AftTagFnd_ &&
               !BefTagFound_ && (BefTagFnd_ || ImpliedTagFound()) &&
                 (TestingCond_ == BEFORE_REQTAG ||
                  TestingCond_ == SURROUND_REQTAG))
      {
        if (CurTagFound_)
        {
          _TagAttrib[TagEnums::REQTAGCOND] |= (TagEnums::BEFREQTAG_FOUND |
                                               TagEnums::REQTAG_COND_MET);
          SetTagValidityState(TagEnums::INACTIVE);
        }
        else if (TestPassedTag_)
          _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;
      }
      else if (AftTagFound_ && BefTagFound_ &&
               !CurTagFound_ && TestPassedTag_)
        _TagAttrib[TagEnums::REQTAGCOND] = TagEnums::REQTAG_COND_NOT_MET;

      AftTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);
      CurTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::CURTAG_FOUND);
      BefTagFound_   = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::BEFREQTAG_FOUND);
      ReqCondMet_    = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_MET);
      ReqCondNotMet_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::REQTAG_COND_NOT_MET);

      if (!ImpliedEndReached_ && (AtNextTag_ || AtBeforeReqTag_ || AtImpliedTag_))
      {
        if (AftTagFound_ && BefTagFound_ && ReqCondMet_)
        {
          if (ImpliedTagFound() || AtNextTag_)
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;
        }
        else if (ReqCondNotMet_)
        {
          if (!AftTagFound_ && AftTagFnd_)
          {
            if (TestPassedTag_ && CurTagFound_ && (BefTagFound_ || AtNextTag_))
              _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;
            else
              _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
          }
          else if (!BefTagFound_ && (BefTagFnd_ || ImpliedTagFound() || AtNextTag_))
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;
          else
            _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_NOT_MET;
        }
      }
      else if (AftTagFound_ && CurTagFound_ && BefTagFound_ && ReqCondMet_)
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;

      if (ReqCondMet_)
      {
        if (ImpliedTagFound() && TagAtImpliedEnd())
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
        else if (AftTagFound_ && CurTagFound_ && BefTagFnd_ &&
                 ReqTagDirFound() == TagEnums::BEFORE_REQTAG)
        {
          long x = ReqTagFoundIndex();

          if (_BefRequiredTags[x])
          {
            if (_MatchingEndTags[x])
            {
              SetEndTag(Ptr_->SourceTagElementState());
              SetEndTagCond(TagEnums::AT_MATCHENDTAG);
            }
            else
            {
              SetEndTag(Ptr_->SourceTagElementState());
              SetEndTagCond(TagEnums::AT_BEFORE_REQTAG);
            }
          }
        }
        else
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
      else if (ReqCondNotMet_)
      {
        SetEndTag(NULL);
        SetEndTagCond(TagEnums::NO_MATCHINGTAG);
      }
    }
  }
  else if (aft && (TestingCond_ == AFTER_REQTAG ||
                   TestingCond_ == SURROUND_REQTAG))
  {
    if (!ImpliedEndReached_ && (AtNextTag_ || AtImpliedTag_))
    {
      if ((AtNextTag_ || ImpliedTagFound()) &&
          (ReqTagFound_ && ReqCondMet_ && CurTagFound_))
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;

        if (AtNextTag_)
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_NEXTTAG);
        }
        else
        {
          SetEndTag(Ptr_->SourceTagElementState());
          SetEndTagCond(TagEnums::AT_IMPLIEDTAG);
        }
      }
      else if (!ReqCondMet_ || ReqCondNotMet_)
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;

        if (ReqCondNotMet_)
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
    }
  }
  else if (bef && (TestingCond_ == BEFORE_REQTAG ||
                   TestingCond_ == SURROUND_REQTAG))
  {
    if (!ImpliedEndReached_ && AtNextTag_)
    {
      if (ReqTagFound_ && ReqCondMet_ && CurTagFound_)
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;

        SetEndTag(Ptr_->SourceTagElementState());
        SetEndTagCond(TagEnums::AT_NEXTTAG);
      }
      else if (!ReqCondMet_ || ReqCondNotMet_)
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;

        if (ReqCondNotMet_)
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
    }
  }
  else if (sur && (TestingCond_ == BEFORE_REQTAG ||
                   TestingCond_ == SURROUND_REQTAG))
  {
    if (!ImpliedEndReached_ && AtNextTag_)
    {
      if (BefTagFound_ && ReqCondMet_ && CurTagFound_)
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;

        SetEndTag(Ptr_->SourceTagElementState());
        SetEndTagCond(TagEnums::AT_NEXTTAG);
      }
      else if (!ReqCondMet_ || ReqCondNotMet_)
      {
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::NFREQTAG_IMPLIEDEND_MET;

        if (ReqCondNotMet_)
        {
          SetEndTag(NULL);
          SetEndTagCond(TagEnums::NO_MATCHINGTAG);
        }
      }
    }
  }
  else if (noreq)
  {
    if (CurTagFound_ && TagCondMetNoReq_)
    {
      if (!ImpliedEndReached_ && (AtNextTag_ || AtImpliedTag_))
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_IMPLIEDEND_MET;
      else
        _TagAttrib[TagEnums::IMPLIEDENDCOND] = TagEnums::REQTAG_NO_IMPLIEDEND;
    }
  }

  if (SavedReqTagCond_ != _TagAttrib[TagEnums::REQTAGCOND])
    _ReqTagCondChanged = 1;

  if (SavedImpliedEndCond_ != _TagAttrib[TagEnums::IMPLIEDENDCOND])
    _ImpliedEndCondChanged = 1;

  if (SavedValidityState_ != _TagAttrib[TagEnums::VALIDITYSTATE])
    _ValidityStateChanged = 1;

  if (_ReqTagCondChanged || _ImpliedEndCondChanged || _ValidityStateChanged)
    CopyToTagStates(true,
                    (_ReqTagCondChanged ||
                     _ImpliedEndCondChanged || _ValidityStateChanged),
                    false,
                    false);

  return ret;
}

/****************************************************************************/
bool TagElement::AtReqTagCondStopState(bool PartialMet_, bool FailOnly_) const
{
  bool ExtraCond_ = false;

  if (PartialMet_ &&
      _TagAttrib[TagEnums::OPTREQTAGORDER] == TagEnums::SURROUND_REQTAG)
    ExtraCond_ = (_TagAttrib[TagEnums::REQTAGCOND] & TagEnums::AFTREQTAG_FOUND);

  return
  (
    FailOnly_ ?
      ((RequiredTagCondNotMet() &&
         !(ExtraCond_ ||
           RequiredTagCondMet() ||
           (NoRequiredTag() && CurrentTagCondMet())))):
      (ExtraCond_ ||
       RequiredTagCondNotMet() ||
       RequiredTagCondMet() ||
       (NoRequiredTag() && CurrentTagCondMet()))
  );
}

/****************************************************************************/
int TagElement::TagNesting(bool PairOnly_) const
{
  return (PairOnly_ ? (IsPairEndTag() ? 0:_TagAttrib[TagEnums::NESTING]):
                      _TagAttrib[TagEnums::NESTING]);
}

/****************************************************************************/
int TagElement::GiveBrkNesting(const char* TagBrkStr_) const
{
  return _Parent ? _Parent->GiveBrkNesting(TagBrkStr_):NULL;
}

/****************************************************************************/
int TagElement::GiveTagCount(const char* TagBrkStr_) const
{
  return _Parent ? _Parent->GiveTagCount(TagBrkStr_):NULL;
}

/****************************************************************************/
const char* TagElement::GiveTagBrk(int Ender_) const
{
  Ender_ = (Ender_ == 0) ? 0:1;
  return _Parent ? _Parent->GiveTagBrk(TagBrkIndex()+Ender_):NULL;  
}

/****************************************************************************/
const char* TagElement::GiveTagMatchBrk(int Ender_) const
{
  Ender_ = (Ender_ == 0) ? 0:1;
  return _Parent ? _Parent->GiveTagBrk(TagMatchIndex()+Ender_):NULL;
}

/****************************************************************************/
void TagElement::DumpTagAttrib(ostream& os_, size_t fw_) const
{
  char Buffer_[256];

  os_.width(fw_); os_ <<std::left <<"Tag Validity: "
                      <<TagBracketList::TagValidityToStr(_TagAttrib[TagEnums::VALIDITY])
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Html Content Tag Type: "
                      <<TagBracketList::TagHtmlContentTagTypeToStr(_TagAttrib[TagEnums::HTMLCONTTAGTYPE])
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Nesting: "
                      <<TagNesting() <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Count: "
                      <<_TagAttrib[TagEnums::TAGCOUNT] <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Attributes: "
                      <<TagBracketList::TagAttributesToStr(_TagAttrib[TagEnums::TAGATTR], Buffer_)
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Index: "
                      <<_TagAttrib[TagEnums::TAGINDEX] <<endl;

  os_.width(fw_); os_ <<std::left <<"Matching Index: "
                      <<_TagAttrib[TagEnums::MATCHINDEX] <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Position: "
                      <<TagBracketList::TagPositionToStr(_TagAttrib[TagEnums::TAGPOS])
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag List Seq.: "
                      <<_TagAttrib[TagEnums::LISTSEQ] <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Opt Tag Order: "
                      <<TagBracketList::TagOptReqTagOrderToStr(_TagAttrib[TagEnums::OPTREQTAGORDER])
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Tag Implied End: "
                      <<TagBracketList::TagImpliedEndToStr(_TagAttrib[TagEnums::IMPLIEDEND])
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Required Tag Cond: "
                      <<TagBracketList::TagReqTagCondToStr(_TagAttrib[TagEnums::REQTAGCOND], Buffer_)
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Implied End Cond: "
                      <<TagBracketList::TagImpliedEndCondToStr(_TagAttrib[TagEnums::IMPLIEDENDCOND], Buffer_)
                      <<endl;

  os_.width(fw_); os_ <<std::left <<"Validity State: "
                      <<TagBracketList::TagValidityToStr(_TagAttrib[TagEnums::VALIDITYSTATE])
                      <<endl;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagElement)

/****************************************************************************/
// TagElementComparer class definitions
/****************************************************************************/
TagElementComparer::TagElementComparer()
{
  STATICCLASSINSTANCE_CREATE_IMPL(TagElementComparer, STCIDummyFnc);
}

/****************************************************************************/
TagElementComparer::~TagElementComparer()
{
  STATICCLASSINSTANCE_DESTROY_IMPL(TagElementComparer, STCIDummyFnc);
}

/****************************************************************************/
MatchableTraits<TagElement>* TagElementComparer::Clone() const
{
  return (new TagElementComparer());
}

/****************************************************************************/
Boolean TagElementComparer::Equal(const TagElement& x, const TagElement& y) const
{
  return
  (
    (x.TagListSeq() < 0) ? y.IsEqual(x):
                           x.IsEqual(y)
  );
}

/****************************************************************************/
Boolean TagElementComparer::NotEqual(const TagElement& x, const TagElement& y) const
{
  return
  (
    (x.TagListSeq() < 0) ? !y.IsEqual(x):
                           !x.IsEqual(y)
  );
}

/****************************************************************************/
STATICCLASSINSTANCE_METHOD_DEFN(TagElementComparer, STCIDummyFnc, STCIDummyFnc)
MEMORYOPS_DEFN(TagElementComparer)

/****************************************************************************/
// TagElementMatchTagComparer class definitions
/****************************************************************************/
TagElementMatchTagComparer::TagElementMatchTagComparer()
{
  STATICCLASSINSTANCE_CREATE_IMPL(TagElementMatchTagComparer, STCIDummyFnc);
}

/****************************************************************************/
TagElementMatchTagComparer::~TagElementMatchTagComparer()
{
  STATICCLASSINSTANCE_DESTROY_IMPL(TagElementMatchTagComparer, STCIDummyFnc);
}

/****************************************************************************/
MatchableTraits<TagElement>* TagElementMatchTagComparer::Clone() const
{
  return (new TagElementMatchTagComparer());
}

/****************************************************************************/
Boolean TagElementMatchTagComparer::Equal(const TagElement& x, const TagElement& y) const
{
  return
  (
    (x.TagListSeq() < 0) ? y.IsEqualToMatchTag(x):
                           x.IsEqualToMatchTag(y)
  );
}

/****************************************************************************/
Boolean TagElementMatchTagComparer::NotEqual(const TagElement& x, const TagElement& y) const
{
  return
  (
    (x.TagListSeq() < 0) ? !y.IsEqualToMatchTag(x):
                           !x.IsEqualToMatchTag(y)
  );
}

/****************************************************************************/
STATICCLASSINSTANCE_METHOD_DEFN(TagElementMatchTagComparer, STCIDummyFnc, STCIDummyFnc)
MEMORYOPS_DEFN(TagElementMatchTagComparer)

/****************************************************************************/
// TagBracketList class definitions
/****************************************************************************/
TagBracketList::TagBracketList():
_ObjectID(0),
_ManualCreate(false),

_TagBrkMatrix(NULL),
_TagBrkIndex(0),
_TagBrkMax(TagEnums::TAGLIST_MAX_ENTRIES)
{
  if (!m_StaticCreate)
  {
    if (!TagBracketList::m_This)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (_TagBrkMax && !_TagBrkIndex)
    InitTagList();
}

/****************************************************************************/
TagBracketList::TagBracketList(int ManualCreate_):
_ObjectID(0),
_ManualCreate(true),

_TagBrkMatrix((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TagEnums::TAGLIST_LENGTH)),
_TagBrkIndex(0),
_TagBrkMax(TagEnums::TAGLIST_MAX_ENTRIES)
{
  SetupTagData(false);
  TagBracketList::InitStrings();  
  InitTagList();
}

/****************************************************************************/
TagBracketList::~TagBracketList()
{
  if (!_ManualCreate)
  {
    if (!m_StaticDestroy && m_ObjectCnt > 1)
    {
      --m_ObjectCnt;

      if (m_AutoRelease && m_ObjectCnt == 1 && m_This)
      {
        m_StaticDestroy = true;
        m_AutoRelease = false;
        Release();
      }
    }

    if (_TagBrkMax && _TagBrkMatrix)
      DestroyTagList();
  }
  else
  {
    m_StaticDestroy = true;
    m_ObjectCnt = 1;
    DestroyTagList();

    _TagBrkIndex = 0;
  }
}

/****************************************************************************/
void TagBracketList::AddTagBrk(const char* Str_)
{
  if (!_GlobalTagBrkList)
  {
    if (_TagBrkIndex < _TagBrkMax)
      _TagBrkMatrix[_TagBrkIndex++] = ::NewString(Str_, MEMMATRIX);
  }
  else
  {
    _TagBrkMatrix = _GlobalTagBrkList;

    if (_TagBrkIndex < _TagBrkMax)
      if (_TagBrkMatrix[_TagBrkIndex])
        _TagBrkIndex++;
      else
        _TagBrkMatrix[_TagBrkIndex++] = ::NewString(Str_, MEMMATRIX);
  }
}

/****************************************************************************/
void TagBracketList::Init()
{
  if (!TagBracketList::m_This)
  {
    TagBracketList::m_This = new TagBracketList();
    TagBracketList::InitStrings();

    if (!m_This->_TagBrkMatrix || m_This->GiveTagBrkIndex() == 0)
      m_This->InitTagList();
  }
}

/****************************************************************************/
TagBracketList* TagBracketList::Instance()
{
  if (!m_This)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;
  }

  return m_This;
}

/****************************************************************************/
void TagBracketList::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && m_This)
  {
    m_StaticDestroy = true;
    delete m_This;
    m_This = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
void TagBracketList::AssignGlobalTagBrkList(char** TagBrkList_)
{
  if (!_GlobalTagBrkList)
  {
    if (TagBrkList_)
      _GlobalTagBrkList = TagBrkList_;
    else
    {
      _TagBrkIndex = 0;
      _TagBrkMatrix = NULL;
    }
  }
}

/****************************************************************************/
void TagBracketList::InitStrings()
{
  if (!_DocTypeOpen_Str)
    _DocTypeOpen_Str = NewString(DOCTYPEOPEN_STR, MEMMATRIX);

  if (!_DocTypeClose_Str)
    _DocTypeClose_Str = NewString(DOCTYPECLOSE_STR, MEMMATRIX);

  if (!_CommentOpen_Str)
    _CommentOpen_Str = NewString(COMMENTOPEN_STR, MEMMATRIX);

  if (!_CommentClose_Str)
    _CommentClose_Str = NewString(COMMENTCLOSE_STR, MEMMATRIX);

  if (!_NestedComment1Open_Str)
    _NestedComment1Open_Str = NewString(NESTEDCOMMENT1OPEN_STR, MEMMATRIX);

  if (!_NestedComment1Close_Str)
    _NestedComment1Close_Str = NewString(NESTEDCOMMENT1CLOSE_STR, MEMMATRIX);

  if (!_NestedComment2Open_Str)
    _NestedComment2Open_Str = NewString(NESTEDCOMMENT2OPEN_STR, MEMMATRIX);

  if (!_NestedComment2Close_Str)
    _NestedComment2Close_Str = NewString(NESTEDCOMMENT2CLOSE_STR, MEMMATRIX);

  if (!_StdTagOpen_Str)
    _StdTagOpen_Str = NewString(STDTAGOPEN_STR, MEMMATRIX);

  if (!_StdTagClose_Str)
    _StdTagClose_Str = NewString(STDTAGCLOSE_STR, MEMMATRIX);

  if (!_EndTagOpen_Str)
    _EndTagOpen_Str = NewString(ENDTAGOPEN_STR, MEMMATRIX);

  if (!_EndTagClose_Str)
    _EndTagClose_Str = NewString(ENDTAGCLOSE_STR, MEMMATRIX);

  if (!_EmptyOpen_Str)
    _EmptyOpen_Str = NewString(EMPTYOPEN_STR, MEMMATRIX);

  if (!_EmptyClose_Str)
    _EmptyClose_Str = NewString(EMPTYCLOSE_STR, MEMMATRIX);

  if (!_ScriptOpen_Str)
    _ScriptOpen_Str = NewString(SCRIPTOPEN_STR, MEMMATRIX);

  if (!_ScriptClose_Str)
    _ScriptClose_Str = NewString(SCRIPTCLOSE_STR, MEMMATRIX);

  if (!_CCommentBlkOpen_Str)
    _CCommentBlkOpen_Str = NewString(CCOMMENTBLKOPEN_STR, MEMMATRIX);

  if (!_CCommentBlkClose_Str)
    _CCommentBlkClose_Str = NewString(CCOMMENTBLKCLOSE_STR, MEMMATRIX);

  if (!_COpenCommentBlkOpen_Str)
    _COpenCommentBlkOpen_Str = NewString(COPENCOMMENTBLKOPEN_STR, MEMMATRIX);

  if (!_COpenCommentBlkClose_Str)
    _COpenCommentBlkClose_Str = NewString(COPENCOMMENTBLKCLOSE_STR, MEMMATRIX);

  if (!_CCloseCommentBlkOpen_Str)
    _CCloseCommentBlkOpen_Str = NewString(CCLOSECOMMENTBLKOPEN_STR, MEMMATRIX);

  if (!_CCloseCommentBlkClose_Str)
    _CCloseCommentBlkClose_Str = NewString(CCLOSECOMMENTBLKCLOSE_STR, MEMMATRIX);

  if (!_CppCommentLineOpen_Str)
    _CppCommentLineOpen_Str = NewString(CPPCOMMENTLINEOPEN_STR, MEMMATRIX);

  if (!_CppCommentLineClose_Str)
    _CppCommentLineClose_Str = NewString(CPPCOMMENTLINECLOSE_STR, MEMMATRIX);
}

/****************************************************************************/
void TagBracketList::InitTagList()
{
  // setup tag data structures if they haven't already been allocated
  if (!_ManualCreate)
    SetupTagData(true);

  // Initializing tag list
  if (_DocTypeOpen_Str)
    AddTagBrk(_DocTypeOpen_Str);

  if (_DocTypeClose_Str)
    AddTagBrk(_DocTypeClose_Str);

  if (_CommentOpen_Str)
    AddTagBrk(_CommentOpen_Str);

  if (_CommentClose_Str)
    AddTagBrk(_CommentClose_Str);

  if (_NestedComment1Open_Str)
    AddTagBrk(_NestedComment1Open_Str);

  if (_NestedComment1Close_Str)
    AddTagBrk(_NestedComment1Close_Str);

  if (_NestedComment2Open_Str)
    AddTagBrk(_NestedComment2Open_Str);

  if (_NestedComment2Close_Str)
    AddTagBrk(_NestedComment2Close_Str);

  if (_StdTagOpen_Str)
    AddTagBrk(_StdTagOpen_Str);

  if (_StdTagClose_Str)
    AddTagBrk(_StdTagClose_Str);

  if (_EndTagOpen_Str)
    AddTagBrk(_EndTagOpen_Str);

  if (_EndTagClose_Str)
    AddTagBrk(_EndTagClose_Str);

  if (_EmptyOpen_Str)
    AddTagBrk(_EmptyOpen_Str);

  if (_EmptyClose_Str)
    AddTagBrk(_EmptyClose_Str);

  if (_ScriptOpen_Str)
    AddTagBrk(_ScriptOpen_Str);

  if (_ScriptClose_Str)
    AddTagBrk(_ScriptClose_Str);

  if (_CCommentBlkOpen_Str)
    AddTagBrk(_CCommentBlkOpen_Str);

  if (_CCommentBlkClose_Str)
    AddTagBrk(_CCommentBlkClose_Str);

  if (_COpenCommentBlkOpen_Str)
    AddTagBrk(_COpenCommentBlkOpen_Str);

  if (_COpenCommentBlkClose_Str)
    AddTagBrk(_COpenCommentBlkClose_Str);

  if (_CCloseCommentBlkOpen_Str)
    AddTagBrk(_CCloseCommentBlkOpen_Str);

  if (_CCloseCommentBlkClose_Str)
    AddTagBrk(_CCloseCommentBlkClose_Str);

  if (_CppCommentLineOpen_Str)
    AddTagBrk(_CppCommentLineOpen_Str);

  if (_CppCommentLineClose_Str)
    AddTagBrk(_CppCommentLineClose_Str);

  AssignGlobalTagBrkList(_TagBrkMatrix);
}

/****************************************************************************/
void TagBracketList::DestroyTagList()
{
  if (!_GlobalTagBrkList)
    AssignGlobalTagBrkList(NULL);
  else if (m_StaticDestroy && m_ObjectCnt == 1)
  {
    int x;
    for (x = 0; x < TagEnums::TAGLIST_LENGTH; x++)
    {
      ::RawDeleteArray(_TagBrkMatrix[x]);
      _TagBrkMatrix[x] = NULL;
    }

    _TagBrkIndex = 0;
    ::RawDeleteArray(_TagBrkMatrix);
    _GlobalTagBrkList = _TagBrkMatrix = NULL;
  }
}

/****************************************************************************/
void TagBracketList::SetupTagData(bool DoAlloc_)
{
  if (!_TagBrkMatrix)
  {
    if (DoAlloc_)
      _TagBrkMatrix = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TagEnums::TAGLIST_LENGTH);

    int ArrSz_ = sizeof(char*) * TagEnums::TAGLIST_LENGTH;
    memset(_TagBrkMatrix, 0, ArrSz_);
  }
  else if (!DoAlloc_ && !_TagBrkIndex)
  {
    int ArrSz_ = sizeof(char*) * TagEnums::TAGLIST_LENGTH;
    memset(_TagBrkMatrix, 0, ArrSz_);
  }
}

/****************************************************************************/
const char* TagBracketList::GiveNestedCommentStr(int Index_)
{
  if (Index_ >= 0)
    return ((Index_ == CCOMMENTBLK_DEX ||
             Index_ == COPENCOMMENTBLK_DEX) ?
                 CCOMMENTBLOCKSTART_STR:
            (Index_ == COPENCOMMENTBLK_DEX+1) ?
                 INTCCOMMENTBLOCKEND_STR:
            (Index_ == CCLOSECOMMENTBLK_DEX) ?
                 INTCCOMMENTBLOCKSTART_STR:
            (Index_ == CCOMMENTBLK_DEX+1 ||
             Index_ == CCLOSECOMMENTBLK_DEX+1) ?
                 CCOMMENTBLOCKEND_STR:
            (Index_ == COMMENT_DEX ||
             Index_ == NESTEDCOMMENT1_DEX) ?
                 NESTEDCOMMENTSTART_STR:
            (Index_ == NESTEDCOMMENT1_DEX+1) ?
                 INTNESTEDCOMMENTEND_STR:
            (Index_ == NESTEDCOMMENT2_DEX) ?
                 INTNESTEDCOMMENTSTART_STR:
            (Index_ == COMMENT_DEX+1 ||
             Index_ == NESTEDCOMMENT2_DEX+1) ?
                 NESTEDCOMMENTEND_STR:
                 NULL);

  return NULL;
}

/****************************************************************************/
const char* TagBracketList::GiveNestedCommentChar(int Index_, char* chp)
{
  const char* ret = NULL;
  if (Index_ >= 0)
    ret =  ((Index_ == CCOMMENTBLK_DEX ||
             Index_ == COPENCOMMENTBLK_DEX) ?
                 INTCCOMMENTBLOCKOPEN_STR:
            (Index_ == COPENCOMMENTBLK_DEX+1) ?
                 INTCCOMMENTBLOCKCLOSE_STR:
            (Index_ == CCLOSECOMMENTBLK_DEX) ?
                 INTCCOMMENTBLOCKOPEN_STR:
            (Index_ == CCOMMENTBLK_DEX+1 ||
             Index_ == CCLOSECOMMENTBLK_DEX+1) ?
                 INTCCOMMENTBLOCKCLOSE_STR:
            (Index_ == COMMENT_DEX ||
             Index_ == NESTEDCOMMENT1_DEX) ?
                 INTNESTEDCOMMENTOPEN_STR:
            (Index_ == NESTEDCOMMENT1_DEX+1) ?
                 INTNESTEDCOMMENTCLOSE_STR:
            (Index_ == NESTEDCOMMENT2_DEX) ?
                 INTNESTEDCOMMENTOPEN_STR:
            (Index_ == COMMENT_DEX+1 ||
             Index_ == NESTEDCOMMENT2_DEX+1) ?
                 INTNESTEDCOMMENTCLOSE_STR:
                 NULL);

  if (chp && ret)
    *chp = *ret;

  return ret;
}

/****************************************************************************/
int TagBracketList::GiveTagBrkIndexForStr(const char* Str_) const
{
  int x;
  int len;

  if (Str_)
  {
    len = strlen(Str_);
    for (x = 0; x < _TagBrkMax; x++)
      if (_TagBrkMatrix[x] &&
          strlen(_TagBrkMatrix[x]) == len &&
          strncmp(Str_, _TagBrkMatrix[x], len) == 0)
        return x;
  }

  return -1;
}

/****************************************************************************/
const char* TagBracketList::GiveTagBrk(int Index_) const
{
  return ((0 <= Index_ && Index_ < _TagBrkMax) ? _TagBrkMatrix[Index_]:NULL);
}

/****************************************************************************/
bool TagBracketList::IsScriptTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? !strcmp(start_, SCRIPTOPEN_STR):false);

  return (!strcmp(start_, SCRIPTOPEN_STR) &&
          !strcmp(end_, SCRIPTCLOSE_STR));
}

/****************************************************************************/
bool TagBracketList::IsEmptyTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, EMPTYOPEN_STR) &&
               !strcmp(end_, EMPTYCLOSE_STR)));
}

/****************************************************************************/
bool TagBracketList::IsNestedCommentTag(const char* start_, const char* end_, int Type_)
{
  bool ret = false;

  if (Type_ == 1 || Type_ == 3)
  {
    ret = ((!start_ || !end_) ? false:
                (!strcmp(start_, NESTEDCOMMENTSTART_STR) &&
                 !strcmp(end_, INTNESTEDCOMMENTEND_STR)));

    if (Type_ == 1 || ret)
      return ret;
  }
  
  if (Type_ == 2 || Type_ == 3)
  {
    ret = ((!start_ || !end_) ? false:
                (!strcmp(start_, INTNESTEDCOMMENTSTART_STR) &&
                 !strcmp(end_, NESTEDCOMMENTEND_STR)));

    if (Type_ == 2 || ret)
      return ret;
  }

  return ret;
}

/****************************************************************************/
bool TagBracketList::IsNestedCommentOpenTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, NESTEDCOMMENTSTART_STR) &&
               !strcmp(end_, INTNESTEDCOMMENTEND_STR)));
}

/****************************************************************************/
bool TagBracketList::IsNestedCommentCloseTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, INTNESTEDCOMMENTSTART_STR) &&
               !strcmp(end_, NESTEDCOMMENTEND_STR)));
}

/****************************************************************************/
bool TagBracketList::IsCommentTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? !strcmp(start_, COMMENTOPEN_STR):false);

  return (!strcmp(start_, COMMENTOPEN_STR) &&
          !strcmp(end_, COMMENTCLOSE_STR));
}

/****************************************************************************/
bool TagBracketList::IsDocTypeTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, DOCTYPEOPEN_STR) &&
               !strcmp(end_, DOCTYPECLOSE_STR)));
}

/****************************************************************************/
bool TagBracketList::IsStdTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? !strcmp(start_, STDTAGOPEN_STR):false);

  return (!strcmp(start_, STDTAGOPEN_STR) &&
          !strcmp(end_, STDTAGCLOSE_STR));
}

/****************************************************************************/
bool TagBracketList::IsEndTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? !strcmp(start_, ENDTAGOPEN_STR):false);

  return (!strcmp(start_, ENDTAGOPEN_STR) &&
          !strcmp(end_, ENDTAGCLOSE_STR));
}

/****************************************************************************/
bool TagBracketList::IsCCommentBlkTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, CCOMMENTBLKOPEN_STR) &&
               !strcmp(end_, CCOMMENTBLKCLOSE_STR)));
}

/****************************************************************************/
bool TagBracketList::IsNestedCBlkTag(const char* start_, const char* end_, int Type_)
{
  bool ret = false;

  if (Type_ == 1 || Type_ == 3)
  {
    ret = ((!start_ || !end_) ? false:
                (!strcmp(start_, CCOMMENTBLOCKSTART_STR) &&
                 !strcmp(end_, INTCCOMMENTBLOCKEND_STR)));

    if (Type_ == 1 || ret)
      return ret;
  }
  
  if (Type_ == 2 || Type_ == 3)
  {
    ret = ((!start_ || !end_) ? false:
                (!strcmp(start_, INTCCOMMENTBLOCKSTART_STR) &&
                 !strcmp(end_, CCOMMENTBLOCKEND_STR)));

    if (Type_ == 2 || ret)
      return ret;
  }

  return ret;
}

/****************************************************************************/
bool TagBracketList::IsCOpenTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, CCOMMENTBLOCKSTART_STR) &&
               !strcmp(end_, INTCCOMMENTBLOCKEND_STR)));
}

/****************************************************************************/
bool TagBracketList::IsCCloseTag(const char* start_, const char* end_)
{
  return ((!start_ || !end_) ? false:
              (!strcmp(start_, INTCCOMMENTBLOCKSTART_STR) &&
               !strcmp(end_, CCOMMENTBLOCKEND_STR)));
}

/****************************************************************************/
bool TagBracketList::IsCppTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? !strcmp(start_, CPPCOMMENTLINEOPEN_STR):false);

  return (!strcmp(start_, CPPCOMMENTLINEOPEN_STR) &&
          !strcmp(end_, CPPCOMMENTLINECLOSE_STR));
}

/****************************************************************************/
bool TagBracketList::IsLangTag(const char* start_, const char* end_)
{
  if (!end_)
    return (start_ ? (!strcmp(start_, CCOMMENTBLOCKSTART_STR) ||
                      !strcmp(start_, INTCCOMMENTBLOCKSTART_STR) ||
                      !strcmp(start_, CCOMMENTBLKOPEN_STR) ||
                      !strcmp(start_, CPPCOMMENTLINEOPEN_STR)):false);

  return ((!strcmp(start_, CCOMMENTBLOCKSTART_STR) &&
           !strcmp(end_, INTCCOMMENTBLOCKEND_STR)) ||
          (!strcmp(start_, INTCCOMMENTBLOCKSTART_STR) &&
           !strcmp(end_, CCOMMENTBLOCKEND_STR)) ||
          (!strcmp(start_, CCOMMENTBLKOPEN_STR) &&
           !strcmp(end_, CCOMMENTBLKCLOSE_STR)) ||
          (!strcmp(start_, CPPCOMMENTLINEOPEN_STR) &&
           !strcmp(end_, CPPCOMMENTLINECLOSE_STR)));
}

/****************************************************************************/
int TagBracketList::GiveTagType(const ChrString& tagstr_)
{
  int x;
  int ret = 0;
  int ret2 = 0;
  int len = tagstr_.strlen();
  int elen;
  int slen;
  char* str = NULL;

  if (!len)
    return 0;

  if (!ret && len > (slen=strlen(COMMENTOPEN_STR)) +
                    (elen=strlen(COMMENTCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsCommentTag(str, &str[len] - elen))
    {
      ret2 = TagEnums::COMMENT_TAG;
      ret = 0;

      if (!ret && len > (slen=strlen(NESTEDCOMMENTSTART_STR)) +
                        (elen=strlen(INTNESTEDCOMMENTEND_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsNestedCommentOpenTag(str, &str[len] - elen))
          ret = TagEnums::NESTEDCOMMENT1_TAG;
      }

      if (!ret && len > (slen=strlen(INTNESTEDCOMMENTSTART_STR)) +
                        (elen=strlen(NESTEDCOMMENTEND_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsNestedCommentCloseTag(str, &str[len] - elen))
          ret = TagEnums::NESTEDCOMMENT2_TAG;
      }

      if (!ret)
        ret = ret2;
    }
  }

  if (!ret && len > (slen=strlen(NESTEDCOMMENTSTART_STR)) +
                    (elen=strlen(INTNESTEDCOMMENTEND_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsNestedCommentOpenTag(str, &str[len] - elen))
      ret = TagEnums::NESTEDCOMMENT1_TAG;
  }

  if (!ret && len > (slen=strlen(INTNESTEDCOMMENTSTART_STR)) +
                    (elen=strlen(NESTEDCOMMENTEND_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsNestedCommentCloseTag(str, &str[len] - elen))
      ret = TagEnums::NESTEDCOMMENT2_TAG;
  }

  if (!ret && len > (slen=strlen(DOCTYPEOPEN_STR)) +
                    (elen=strlen(DOCTYPECLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsDocTypeTag(str, &str[len] - elen))
      ret = TagEnums::DOCTYPE_TAG;
  }

  if (!ret && len > (slen=strlen(SCRIPTOPEN_STR)) +
                    (elen=strlen(SCRIPTCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsScriptTag(str, &str[len] - elen))
      ret = TagEnums::SCRIPT_TAG;
  }

  if (!ret && len > (slen=strlen(STDTAGOPEN_STR)) +
                    (elen=strlen(STDTAGCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsStdTag(str, &str[len] - elen))
    {
      ret2 = TagEnums::STD_TAG;
      ret = 0;

      if (!ret && len > (slen=strlen(ENDTAGOPEN_STR)) +
                        (elen=strlen(ENDTAGCLOSE_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsEndTag(str, &str[len] - elen))
          ret = TagEnums::END_TAG;
      }

      if (!ret && len > (slen=strlen(EMPTYOPEN_STR)) +
                        (elen=strlen(EMPTYCLOSE_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsEmptyTag(str, &str[len] - elen))
          ret = TagEnums::EMPTY_TAG;
      }

      if (!ret)
        ret = ret2;
    }
  }

  if (!ret && len > (slen=strlen(ENDTAGOPEN_STR)) +
                    (elen=strlen(ENDTAGCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsEndTag(str, &str[len] - elen))
      ret = TagEnums::END_TAG;
  }

  if (!ret && len > (slen=strlen(EMPTYOPEN_STR)) +
                    (elen=strlen(EMPTYCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsEmptyTag(str, &str[len] - elen))
      ret = TagEnums::EMPTY_TAG;
  }

  if (!ret && len > (slen=strlen(CCOMMENTBLKOPEN_STR)) +
                    (elen=strlen(CCOMMENTBLKCLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsCCommentBlkTag(str, &str[len] - elen))
    {
      ret2 = TagEnums::CCOMMENTBLK_TAG;
      ret = 0;

      if (!ret && len > (slen=strlen(CCOMMENTBLOCKSTART_STR)) +
                        (elen=strlen(INTCCOMMENTBLOCKEND_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsCOpenTag(str, &str[len] - elen))
          ret = TagEnums::COPENCOMMENTBLK_TAG;
      }

      if (!ret && len > (slen=strlen(INTCCOMMENTBLOCKSTART_STR)) +
                        (elen=strlen(CCOMMENTBLOCKEND_STR)))
      {
        strcpy(str, tagstr_.c_str());
        str[slen] = 0;

        if (IsCCloseTag(str, &str[len] - elen))
          ret = TagEnums::CCLOSECOMMENTBLK_TAG;
      }

      if (!ret)
        ret = ret2;
    }
  }

  if (!ret && len > (slen=strlen(CCOMMENTBLOCKSTART_STR)) +
                    (elen=strlen(INTCCOMMENTBLOCKEND_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsCOpenTag(str, &str[len] - elen))
      ret = TagEnums::COPENCOMMENTBLK_TAG;
  }

  if (!ret && len > (slen=strlen(INTCCOMMENTBLOCKSTART_STR)) +
                    (elen=strlen(CCOMMENTBLOCKEND_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsCCloseTag(str, &str[len] - elen))
      ret = TagEnums::CCLOSECOMMENTBLK_TAG;
  }

  if (!ret && len > (slen=strlen(CPPCOMMENTLINEOPEN_STR)) +
                    (elen=strlen(CPPCOMMENTLINECLOSE_STR)))
  {
    ::RawDeleteArray(str);
    str = ::NewString(tagstr_.c_str());
    str[slen] = 0;

    if (IsCppTag(str, &str[len] - elen))
      ret = TagEnums::CPPCOMMENTLINE_TAG;
  }

  ::RawDeleteArray(str);
  return ret;
}

/****************************************************************************/
ChrString TagBracketList::StripTagBrackets(const ChrString& tagstr_, int tagtype_,
                                           ChrString* StartBrk_, ChrString* EndBrk_)
{
  ChrString res = tagstr_;
  Subscript len = tagstr_.strlen();

  if (!len)
    return ChrString();

  if (tagtype_ == DOCTYPE_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(2);
    }

    res.Right(len-2);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(1);
    }

    res.Left(len-1);
  }
  else if (tagtype_ == COMMENT_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(4);
    }

    res.Right(len-4);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(3);
    }

    res.Left(len-3);
  }
  else if (tagtype_ == NESTEDCOMMENT1_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(5);
    }

    res.Right(len-5);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(2);
    }

    res.Left(len-2);
  }
  else if (tagtype_ == NESTEDCOMMENT2_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(3);
    }

    res.Right(len-3);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(4);
    }

    res.Left(len-4);
  }
  else if (tagtype_ == STD_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(1);
    }

    res.Right(len-1);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(1);
    }

    res.Left(len-1);
  }
  else if (tagtype_ == EMPTY_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(1);
    }

    res.Right(len-1);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(2);
    }

    res.Left(len-2);
  }
  else if (tagtype_ == END_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(2);
    }

    res.Right(len-2);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(1);
    }

    res.Left(len-1);
  }
  else if (tagtype_ == SCRIPT_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(2);
    }

    res.Right(len-2);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(2);
    }

    res.Left(len-2);
  }
  else if (tagtype_ == CCOMMENTBLK_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(2);
    }

    res.Right(len-2);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(2);
    }

    res.Left(len-2);
  }
  else if (tagtype_ == COPENCOMMENTBLK_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(3);
    }

    res.Right(len-3);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(3);
    }

    res.Left(len-3);
  }
  else if (tagtype_ == CCLOSECOMMENTBLK_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(3);
    }

    res.Right(len-3);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(3);
    }

    res.Left(len-3);
  }
  else if (tagtype_ == CPPCOMMENTLINE_TAG)
  {
    if (StartBrk_)
    {
      *StartBrk_ = res;
      StartBrk_->Left(2);
    }

    res.Right(len-2);
    len = res.strlen();

    if (EndBrk_)
    {
      *EndBrk_ = res;
      EndBrk_->Right(2);
    }

    res.Left(len-2);
  }

  return res;
}

/****************************************************************************/
ChrString TagBracketList::FilterTagElementStr(const ChrString& tagstr_)
{
  ChrString str = tagstr_;
  Subscript i1, i2;
  char *p1, *p2;

  p1 = str.StrChr(' ', &i1);
  p2 = str.StrChr('\t', &i2);

  if ((!p1 && p2) || (p2 && i2 < i1))
    i1 = i2;

  return (p1 ? str.Left(i1):tagstr_);
}

/****************************************************************************/
const char* TagBracketList::TagArrayFieldsToStr(int Field_)
{
  return
  (
    (Field_ == VALIDITY)        ? "VALIDITY":
    (Field_ == NESTING)         ? "NESTING":
    (Field_ == TAGCOUNT)        ? "TAGCOUNT":
    (Field_ == TAGATTR)         ? "TAGATTR":
    (Field_ == TAGINDEX)        ? "TAGINDEX":
    (Field_ == MATCHINDEX)      ? "MATCHINDEX":
    (Field_ == TAGPOS)          ? "TAGPOS":
    (Field_ == LISTSEQ)         ? "LISTSEQ":
    (Field_ == OPTREQTAGORDER)  ? "OPTREQTAGORDER":
    (Field_ == IMPLIEDEND)      ? "IMPLIEDEND":
    (Field_ == REQTAGCOND)      ? "REQTAGCOND":
    (Field_ == IMPLIEDENDCOND)  ? "IMPLIEDENDCOND":
    (Field_ == VALIDITYSTATE)   ? "VALIDITYSTATE":
    (Field_ == HTMLCONTTAGTYPE) ? "HTMLCONTTAGTYPE":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagPositionToStr(int Pos_)
{
  return
  (
    (Pos_ == CLOSING)       ? "CLOSING":
    (Pos_ == OPENING)       ? "OPENING":
    (Pos_ == FORBIDDEN)     ? "FORBIDDEN":
    (Pos_ == INDETERMINATE) ? "INDETERMINATE":
    (Pos_ == NO_TAGPOS)     ? "NO_TAGPOS":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagErrorsToStr(int Error_)
{
  return
  (
    (Error_ == PENDING)                ? "PENDING":
    (Error_ == TAGVALID)               ? "TAGVALID":
    (Error_ == TAG_NOTFOUND)           ? "TAG_NOTFOUND":
    (Error_ == ENDTAG_EXPECTED)        ? "ENDTAG_EXPECTED":
    (Error_ == NESTEDCMNTTAG_EXPECTED) ? "NESTEDCMNTTAG_EXPECTED":
    (Error_ == CCLOSECMNTTAG_EXPECTED) ? "CCLOSECMNTTAG_EXPECTED":
    (Error_ == EMPTYTAG_EXPECTED)      ? "EMPTYTAG_EXPECTED":
    (Error_ == ENDTAG_FORBIDDEN)       ? "ENDTAG_FORBIDDEN":
    (Error_ == NESTEDCMNTTAG_MISMATCH) ? "NESTEDCMNTTAG_MISMATCH":
    (Error_ == CCLOSECMNTTAG_MISMATCH) ? "CCLOSECMNTTAG_MISMATCH":
    (Error_ == ENDBRK_MISSING)         ? "ENDBRK_MISSING":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagTypeToStr(int Type_)
{
  return
  (
    (Type_ == DOCTYPE_TAG)            ? "DOCTYPE_TAG":
    (Type_ == COMMENT_TAG)            ? "COMMENT_TAG":
    (Type_ == NESTEDCOMMENT1_TAG)     ? "NESTEDCOMMENT1_TAG":
    (Type_ == NESTEDCOMMENT2_TAG)     ? "NESTEDCOMMENT2_TAG":
    (Type_ == STD_TAG)                ? "STD_TAG":
    (Type_ == END_TAG)                ? "END_TAG":
    (Type_ == EMPTY_TAG)              ? "EMPTY_TAG":
    (Type_ == SCRIPT_TAG)             ? "SCRIPT_TAG":
    (Type_ == CCOMMENTBLK_TAG)        ? "CCOMMENTBLK_TAG":
    (Type_ == COPENCOMMENTBLK_TAG)    ? "COPENCOMMENTBLK_TAG":
    (Type_ == CCLOSECOMMENTBLK_TAG)   ? "CCLOSECOMMENTBLK_TAG":
    (Type_ == CPPCOMMENTLINE_TAG)     ? "CPPCOMMENTLINE_TAG":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagArrayIndexToStr(int Index_)
{
  return
  (
    (Index_ == DOCTYPE_DEX)            ? "DOCTYPE_DEX":
    (Index_ == COMMENT_DEX)            ? "COMMENT_DEX":
    (Index_ == NESTEDCOMMENT1_DEX)     ? "NESTEDCOMMENT1_DEX":
    (Index_ == NESTEDCOMMENT2_DEX)     ? "NESTEDCOMMENT2_DEX":
    (Index_ == STD_DEX)                ? "STD_DEX":
    (Index_ == END_DEX)                ? "END_DEX":
    (Index_ == EMPTY_DEX)              ? "EMPTY_DEX":
    (Index_ == SCRIPT_DEX)             ? "SCRIPT_DEX":
    (Index_ == CCOMMENTBLK_DEX)        ? "CCOMMENTBLK_DEX":
    (Index_ == COPENCOMMENTBLK_DEX)    ? "COPENCOMMENTBLK_DEX":
    (Index_ == CCLOSECOMMENTBLK_DEX)   ? "CCLOSECOMMENTBLK_DEX":
    (Index_ == CPPCOMMENTLINEOPEN_DEX) ? "CPPCOMMENTLINEOPEN_DEX":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagAllowFlagValuesToStr(int Flag_, char* Buf_)
{
  int AccVal_ = 0;
  if (Buf_)
    strcpy(Buf_, "");
  else
    return "";

  if (Flag_ & ALLOW_NESTEDCOMMENT_TAG)
  {
    strcpy(Buf_, "ALLOW_NESTEDCOMMENT_TAG");
    AccVal_ |= (ALLOW_NESTEDCOMMENT_TAG+1);
  }

  if (Flag_ & ALLOW_END_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nALLOW_END_TAG");
    else
      strcpy(Buf_, "ALLOW_END_TAG");

    AccVal_ |= ALLOW_END_TAG;
  }

  if (Flag_ & ALLOW_CCOMMENTBLK_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nALLOW_CCOMMENTBLK_TAG");
    else
      strcpy(Buf_, "ALLOW_CCOMMENTBLK_TAG");

    AccVal_ |= ALLOW_CCOMMENTBLK_TAG;
  }

  return Buf_;
}

/****************************************************************************/
const char* TagBracketList::TagRetrContFlagValuesToStr(int Flag_, char* Buf_)
{
  int AccVal_ = 0;
  if (Buf_)
    strcpy(Buf_, "");
  else
    return "";

  if (Flag_ & RETRIEVE_COMMENT_TAG)
  {
    strcpy(Buf_, "RETRIEVE_COMMENT_TAG");
    AccVal_ |= (RETRIEVE_COMMENT_TAG+1);
  }

  if (Flag_ & RETRIEVE_NESTEDCOMMENT_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nRETRIEVE_NESTEDCOMMENT_TAG");
    else
      strcpy(Buf_, "RETRIEVE_NESTEDCOMMENT_TAG");

    AccVal_ |= RETRIEVE_NESTEDCOMMENT_TAG;
  }

  if (Flag_ & RETRIEVE_SCRIPT_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nRETRIEVE_SCRIPT_TAG");
    else
      strcpy(Buf_, "RETRIEVE_SCRIPT_TAG");

    AccVal_ |= RETRIEVE_SCRIPT_TAG;
  }

  if (Flag_ & RETRIEVE_CCOMMENTBLK_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nRETRIEVE_CCOMMENTBLK_TAG");
    else
      strcpy(Buf_, "RETRIEVE_CCOMMENTBLK_TAG");

    AccVal_ |= RETRIEVE_CCOMMENTBLK_TAG;
  }

  if (Flag_ & RETRIEVE_CPPCOMMENTLINE_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nRETRIEVE_CPPCOMMENTLINE_TAG");
    else
      strcpy(Buf_, "RETRIEVE_CPPCOMMENTLINE_TAG");

    AccVal_ |= RETRIEVE_CPPCOMMENTLINE_TAG;
  }

  return Buf_;
}

/****************************************************************************/
const char* TagBracketList::TagHtmlContentTagTypeToStr(int HtmlContTagType_)
{
  return
  (
    (HtmlContTagType_ == 0)                      ? "NONE":
    (HtmlContTagType_ == HTMLCONTENT_SPECIAL)    ? "HTMLCONTENT_SPECIAL":
    (HtmlContTagType_ == HTMLCONTENT_HTML)       ? "HTMLCONTENT_HTML":
    (HtmlContTagType_ == HTMLCONTENT_HEAD)       ? "HTMLCONTENT_HEAD":
    (HtmlContTagType_ == HTMLCONTENT_BODY)       ? "HTMLCONTENT_BODY":
    (HtmlContTagType_ == HTMLCONTENT_STDTAGPAIR) ? "HTMLCONTENT_STDTAGPAIR":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagValidityToStr(int Validity_)
{
  return
  (
    (Validity_ == IGNORED)  ? "IGNORED":
    (Validity_ == ACTIVE)   ? "ACTIVE":
    (Validity_ == INACTIVE) ? "INACTIVE":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagAttributesToStr(int Attrib_, char* Buf_)
{
  int AccVal_ = 0;
  if (Buf_)
    strcpy(Buf_, "");
  else
    return "";

  if (Attrib_ & SINGLETON_TAGATTR)
  {
    strcpy(Buf_, "SINGLETON_TAGATTR");
    AccVal_ |= (SINGLETON_TAGATTR+1);
  }

  if (Attrib_ & EMPTY_TAGATTR)
  {
    if (AccVal_)
      strcat(Buf_, "+\nEMPTY_TAGATTR");
    else
      strcpy(Buf_, "EMPTY_TAGATTR");

    AccVal_ |= EMPTY_TAGATTR;
  }

  if (Attrib_ & PAIR_TAGATTR)
  {
    if (AccVal_)
      strcat(Buf_, "+\nPAIR_TAGATTR");
    else
      strcpy(Buf_, "PAIR_TAGATTR");

    AccVal_ |= PAIR_TAGATTR;
  }

  if (Attrib_ & OPTIONALPAIR_TAGATTR)
  {
    if (AccVal_)
      strcat(Buf_, "+\nOPTIONALPAIR_TAGATTR");
    else
      strcpy(Buf_, "OPTIONALPAIR_TAGATTR");

    AccVal_ |= OPTIONALPAIR_TAGATTR;
  }

  if (Attrib_ & ALLOW_SINGLETON_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nALLOW_SINGLETON_TAG");
    else
      strcpy(Buf_, "ALLOW_SINGLETON_TAG");

    AccVal_ |= ALLOW_SINGLETON_TAG;
  }

  if (Attrib_ & ALLOW_EMPTY_TAG)
  {
    if (AccVal_)
      strcat(Buf_, "+\nALLOW_EMPTY_TAG");
    else
      strcpy(Buf_, "ALLOW_EMPTY_TAG");

    AccVal_ |= ALLOW_EMPTY_TAG;
  }

  if (Attrib_ & PAIR_ENDER)
  {
    if (AccVal_)
      strcat(Buf_, "+\nPAIR_ENDER");
    else
      strcpy(Buf_, "PAIR_ENDER");

    AccVal_ |= PAIR_ENDER;
  }

  if (Attrib_ & TAG_SPECIFIC)
  {
    if (AccVal_)
      strcat(Buf_, "+\nTAG_SPECIFIC");
    else
      strcpy(Buf_, "TAG_SPECIFIC");

    AccVal_ |= TAG_SPECIFIC;
  }

  return Buf_;
}

/****************************************************************************/
const char* TagBracketList::TagOptReqTagOrderToStr(int ReqOrder_)
{
  return
  (
    (ReqOrder_ == NO_REQTAG)             ? "NO_REQTAG":
    (ReqOrder_ == BEFORE_REQTAG)         ? "BEFORE_REQTAG":
    (ReqOrder_ == AFTER_REQTAG)          ? "AFTER_REQTAG":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagImpliedEndToStr(int Implied_)
{
  return
  (
    (Implied_ == NO_IMPLIEDEND)         ? "NO_IMPLIEDEND":
    (Implied_ == AT_EOF)                ? "AT_EOF":
    (Implied_ == AT_BEFORE_REQTAG)      ? "AT_BEFORE_REQTAG":
    (Implied_ == AT_NEXTTAG)            ? "AT_NEXTTAG":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagImpliedEndCondToStr(int ImpliedCond_, char* Buf_)
{
  int AccVal_ = 0;
  if (Buf_)
    strcpy(Buf_, "");
  else
    return "";

  if (ImpliedCond_ & TNF_IMPLIEDEND_NOT_MET)
  {
    strcpy(Buf_, "TNF_IMPLIEDEND_NOT_MET");
    AccVal_ |= (TNF_IMPLIEDEND_NOT_MET+1);
  }

  if (ImpliedCond_ & NFREQTAG_IMPLIEDEND_NOT_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nNFREQTAG_IMPLIEDEND_NOT_MET");
    else
      strcpy(Buf_, "NFREQTAG_IMPLIEDEND_NOT_MET");

    AccVal_ |= NFREQTAG_IMPLIEDEND_NOT_MET;
  }

  if (ImpliedCond_ & REQTAG_IMPLIEDEND_NOT_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nREQTAG_IMPLIEDEND_NOT_MET");
    else
      strcpy(Buf_, "REQTAG_IMPLIEDEND_NOT_MET");

    AccVal_ |= REQTAG_IMPLIEDEND_NOT_MET;
  }

  if (ImpliedCond_ & NFREQTAG_IMPLIEDEND_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nNFREQTAG_IMPLIEDEND_MET");
    else
      strcpy(Buf_, "NFREQTAG_IMPLIEDEND_MET");

    AccVal_ |= NFREQTAG_IMPLIEDEND_MET;
  }

  if (ImpliedCond_ & REQTAG_IMPLIEDEND_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nREQTAG_IMPLIEDEND_MET");
    else
      strcpy(Buf_, "REQTAG_IMPLIEDEND_MET");

    AccVal_ |= REQTAG_IMPLIEDEND_MET;
  }

  return Buf_;
}

/****************************************************************************/
const char* TagBracketList::TagReqTagCondToStr(int ReqCond_, char* Buf_)
{
  int AccVal_ = 0;
  if (Buf_)
    strcpy(Buf_, "");
  else
    return "";

  if (ReqCond_ & TAG_NOT_FOUND)
  {
    strcpy(Buf_, "TAG_NOT_FOUND");
    AccVal_ |= (TAG_NOT_FOUND+1);
  }

  if (ReqCond_ & REQTAG_FOUND)
  {
    if (AccVal_)
      strcat(Buf_, "+\nREQTAG_FOUND");
    else
      strcpy(Buf_, "REQTAG_FOUND");

    AccVal_ |= REQTAG_FOUND;
  }

  if (ReqCond_ & CURTAG_FOUND)
  {
    if (AccVal_)
      strcat(Buf_, "+\nCURTAG_FOUND");
    else
      strcpy(Buf_, "CURTAG_FOUND");

    AccVal_ |= CURTAG_FOUND;
  }

  if (ReqCond_ & REQTAG_COND_NOT_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nREQTAG_COND_NOT_MET");
    else
      strcpy(Buf_, "REQTAG_COND_NOT_MET");

    AccVal_ |= REQTAG_COND_NOT_MET;
  }

  if (ReqCond_ & REQTAG_COND_MET)
  {
    if (AccVal_)
      strcat(Buf_, "+\nREQTAG_COND_MET");
    else
      strcpy(Buf_, "REQTAG_COND_MET");

    AccVal_ |= REQTAG_COND_MET;
  }

  if (ReqCond_ & TAG_COND_MET_NOREQ)
  {
    if (AccVal_)
      strcat(Buf_, "+\nTAG_COND_MET_NOREQ");
    else
      strcpy(Buf_, "TAG_COND_MET_NOREQ");

    AccVal_ |= TAG_COND_MET_NOREQ;
  }

  return Buf_;
}

/****************************************************************************/
const char* TagBracketList::TagDocStyleTypeToStr(int DocStyle_)
{
  return
  (
    (DocStyle_ == CSTYLE)                ? "CSTYLE":
    (DocStyle_ == CPPSTYLE)              ? "CPPSTYLE":
    (DocStyle_ == XMLSTYLE)              ? "XMLSTYLE":
    (DocStyle_ == HTMLSTYLE)             ? "HTMLSTYLE":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagDocFileTypeToStr(int DocFile_)
{
  return
  (
    (DocFile_ == C_FILE)                ? "C_FILE":
    (DocFile_ == CPP_FILE)              ? "CPP_FILE":
    (DocFile_ == XML_FILE)              ? "XML_FILE":
    (DocFile_ == HTML_FILE)             ? "HTML_FILE":
    (DocFile_ == XHTML_FILE)            ? "XHTML_FILE":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagScanModeToStr(int Mode_)
{
  return
  (
    (Mode_ == TAGREAD)  ? "TAGREAD":
    (Mode_ == TAGCHECK) ? "TAGCHECK":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagSearchParameterToStr(int Param_)
{
  return
  (
    (Param_ == MATCH_TAGBRACKET)      ? "MATCH_TAGBRACKET":
    (Param_ == MATCH_TAGTYPE)         ? "MATCH_TAGTYPE":
    (Param_ == MATCH_TAGDELIMS)       ? "MATCH_TAGDELIMS":
    (Param_ == MATCH_TAGENDBRACKET)   ? "MATCH_TAGENDBRACKET":
    (Param_ == NO_TAGTYPE)            ? "NO_TAGTYPE":""
  );
}

/****************************************************************************/
const char* TagBracketList::TagSearchTypeToStr(int SearchType_)
{
  return
  (
    (SearchType_ == GENERAL_SEARCH)  ? "GENERAL_SEARCH":
    (SearchType_ == SPECIFIC_SEARCH) ? "SPECIFIC_SEARCH":""
  );
}

/****************************************************************************/
int TagBracketList::TagAttribToTagPos(int TagAttrib_)
{
  return
  (
    ((TagAttrib_ & SINGLETON_TAGATTR) ||
     (TagAttrib_ & EMPTY_TAGATTR))          ? FORBIDDEN:
    (TagAttrib_ & PAIR_TAGATTR)             ? OPENING:
    ((TagAttrib_ & OPTIONALPAIR_TAGATTR) &&
     ((TagAttrib_ & ALLOW_SINGLETON_TAG) ||
      (TagAttrib_ & ALLOW_EMPTY_TAG)))      ? INDETERMINATE:
    (TagAttrib_ & PAIR_ENDER)               ? CLOSING:
                                              NO_TAGPOS
  );
}

/****************************************************************************/
int TagBracketList::TagPosToTagAttrib(int TagPos_)
{
  return
  (
    (TagPos_ & FORBIDDEN)     ? SINGLETON_TAGATTR:
    (TagPos_ & OPENING)       ? PAIR_TAGATTR:
    (TagPos_ & INDETERMINATE) ? OPTIONALPAIR_TAGATTR:
    (TagPos_ & PAIR_ENDER)    ? CLOSING:
                                NO_TAGPOS
  );
}

/****************************************************************************/
MEMORYOPS_DEFN(TagBracketList)

/****************************************************************************/
// HtmlSpecialCaseData class definition
/****************************************************************************/
HtmlSpecialCaseData::HtmlSpecialCaseData():
_HtmlTagFound(false),
_HeadTagFound(false),
_HeadEndTagFound(false),
_BodyTagFound(false),

_HtmlTagOmitted(false),
_HeadTagOmitted(false),
_HeadEndTagOmitted(false),
_BodyTagOmitted(false),

_HtmlTagError(false),
_HeadTagError(false),
_HeadEndTagError(false),
_BodyTagError(false)
{}

/****************************************************************************/
void HtmlSpecialCaseData::Reset()
{
  _HtmlTagFound = false;
  _HeadTagFound = false;
  _HeadEndTagFound = false;
  _BodyTagFound = false;

  _HtmlTagOmitted = false;
  _HeadTagOmitted = false;
  _HeadEndTagOmitted = false;
  _BodyTagOmitted = false;

  _HtmlTagError = false;
  _HeadTagError = false;
  _HeadEndTagError = false;
  _BodyTagError = false;
}

/****************************************************************************/
int HtmlSpecialCaseData::GiveTagErrors() const
{
  int TagError_ = 0;

  if (_HtmlTagError)
    TagError_ |= TagEnums::HTML_TAG_MISPLACED;

  if (_HeadTagError || _HeadEndTagError)
    TagError_ |= TagEnums::HEAD_TAG_MISPLACED;

  if (_BodyTagError)
    TagError_ |= TagEnums::BODY_TAG_MISPLACED;

  return TagError_;
}

/****************************************************************************/
void HtmlSpecialCaseData::CheckForSpecialHtmlTags(const ChrString& TagStr_)
{
  ChrString Html_("<HTML>");
  ChrString Head_("<HEAD>");
  ChrString HeadEnd_("</HEAD>");
  ChrString Body_("<BODY>");

  if (TagStr_ == Html_)
  {
    if (!_HtmlTagOmitted && !_HtmlTagFound && !_HtmlTagError)
    {
      // <html>
      // ...

      _HtmlTagFound = true;
      _HtmlTagOmitted = false;
    }
    else
      _HtmlTagError = true;
  }
  else if (TagStr_ == Head_)
  {
    if (!_HeadTagOmitted && !_HeadTagFound && !_HeadTagError)
    {
      // <head>
      // ...

      if (!_HtmlTagFound)
        _HtmlTagOmitted = true;

      // <html>
      // <head>
      // ...

      _HeadTagFound = true;
      _HeadTagOmitted = false;
    }
    else
      _HeadTagError = true;
  }
  else if (TagStr_ == HeadEnd_)
  {
    if (!_HeadEndTagOmitted && !_HeadEndTagFound && !_HeadEndTagError)
    {
      // ...
      // </head>

      if (!_HtmlTagFound)
        _HtmlTagOmitted = true;

      // <html>
      // ...
      // </head>

      if (!_HeadTagFound)
        _HeadTagOmitted = true;

      // <html>
      // <head>
      // ...
      // </head>

      _HeadEndTagFound = true;
      _HeadEndTagOmitted = false;
    }
    else
      _HeadEndTagError = true;
  }
  else if (TagStr_ == Body_)
  {
    if (!_BodyTagOmitted && !_BodyTagFound && !_BodyTagError)
    {
      // ...
      // <body>
      // ...
      // </body>

      if (!_HtmlTagFound)
        _HtmlTagOmitted = true;

      // <html>
      // <head>
      // ...
      // <body>
      // ...
      // </body>

      if (!_HeadTagFound)
        _HeadTagOmitted = true;

      // <html>
      // ...
      // <body>
      // ...
      // </body>

      if (!_HeadEndTagFound)
        _HeadEndTagOmitted = true;

      // <html>
      // <head>
      // ...
      // </head>
      // <body>
      // ...
      // </body>

      _BodyTagFound = true;
      _BodyTagOmitted = false;
    }
    else
      _BodyTagError = true;
  }
  else if (_HeadTagOmitted && _HeadTagFound &&
           _HeadEndTagOmitted && _HeadEndTagFound)
  {
    if (!_BodyTagOmitted && !_BodyTagFound && !_BodyTagError)
    {
      // <head>
      // ...
      // </head>
      // <sometag>
      // ...

      if (!_BodyTagFound)
        _BodyTagOmitted = true;
    }
    else
      _BodyTagError = true;
  }
}

/****************************************************************************/
MEMORYOPS_DEFN(HtmlSpecialCaseData)

/****************************************************************************/
// TagCountData class definitions
/****************************************************************************/
TagCountData::TagCountData():
TagBracketList(),
_ObjectID(0),
_StdTagList(NULL),
_EndTagList(NULL),
_ElementSeqList(NULL),
_SeqListIndex(0),
_SeqIndexIncr(0),

_HtmlSpecialCase(NULL),
_TagCntMatrix(NULL),
_TagCntIndex(0),
_TagCntMax(TagEnums::TAGLIST_MAX_ENTRIES),

_ListIter(NULL),
_TagIterIndex(0),
_DocType(0),
_EofFound(false),
_TagDataUpdated(false),
_SeqListUpdateIndex(0)
{
  if (!m_StaticCreate)
  {
    if (!m_This)
      Instance();

    _ObjectID = ++m_ObjectCnt;
    m_AutoRelease = true;
  }
  else if (!m_ObjectCnt)
    _ObjectID = ++m_ObjectCnt;

  if (_TagCntMax && !_TagCntIndex)
    InitTagList();
}

/****************************************************************************/
TagCountData::TagCountData(int ManualCreate_):
TagBracketList(ManualCreate_),
_ObjectID(0),
_StdTagList(new SearchableList<TagElement>),
_EndTagList(new SearchableList<TagElement>),
_ElementSeqList(NULL),
_SeqListIndex(0),
_SeqIndexIncr(0),

_HtmlSpecialCase(NULL),
_TagCntMatrix((int**)RawAllocateWith(MEMMATRIX, sizeof(int*) * TagEnums::TAGLIST_LENGTH)),
_TagCntIndex(0),
_TagCntMax(TagEnums::TAGLIST_MAX_ENTRIES),

_ListIter(NULL),
_TagIterIndex(0),
_DocType(0),
_EofFound(false),
_TagDataUpdated(false),
_SeqListUpdateIndex(0)
{
  SetupElementSeqList();
  SetupTagData(false);
  TagCountData::InitStrings();
  InitTagList();
}

/****************************************************************************/
TagCountData::~TagCountData()
{
  if (!_ManualCreate)
  {
    if (!m_StaticDestroy && m_ObjectCnt > 1)
    {
      --m_ObjectCnt;

      if (m_AutoRelease && m_ObjectCnt == 1 && m_This)
      {
        m_StaticDestroy = true;
        m_AutoRelease = false;
        Release();
      }
    }

    if (_StdTagList || _EndTagList)
    {
      if (_GlobalTagBrkList)
        DestroyTagList();

      if (_TagCntMatrix)
        DestroyObjectData();
    }
  }
  else
  {
    m_StaticDestroy = true;
    m_ObjectCnt = 1;

    if (_GlobalTagBrkList)
      DestroyTagList();

    if (_TagCntMatrix)
      DestroyObjectData();
  
    _TagCntIndex = 0;
  }
}

/****************************************************************************/
void TagCountData::Init()
{
  if (!TagCountData::m_This)
  {
    TagCountData::m_This = new TagCountData();
    TagCountData::InitStrings();

    if (!m_This->_TagCntMatrix || m_This->GiveTagCntIndex() == 0)
      m_This->InitTagList();
  }
}

/****************************************************************************/
TagCountData* TagCountData::Instance()
{
  if (!m_This)
  {
    m_StaticCreate = true;
    Init();
    m_StaticCreate = false;
  }

  return m_This;
}

/****************************************************************************/
void TagCountData::Release()
{
  if (!m_AutoRelease && m_ObjectCnt <= 1 && m_This)
  {
    m_StaticDestroy = true;
    delete m_This;
    m_This = NULL;
    m_ObjectCnt = 0;
    m_StaticDestroy = false;
  }
}

/****************************************************************************/
void TagCountData::InitTagList()
{
  // setup tag data structures if they haven't already been allocated
  if (!_ManualCreate)
    SetupTagData(true);

  // Initializing tag list
  if (_DocTypeOpen_Str)
    AddTagBrk(_DocTypeOpen_Str);

  if (_DocTypeClose_Str)
    AddTagBrk(_DocTypeClose_Str);

  if (_CommentOpen_Str)
    AddTagBrk(_CommentOpen_Str);

  if (_CommentClose_Str)
    AddTagBrk(_CommentClose_Str);

  if (_NestedComment1Open_Str)
    AddTagBrk(_NestedComment1Open_Str);

  if (_NestedComment1Close_Str)
    AddTagBrk(_NestedComment1Close_Str);

  if (_NestedComment2Open_Str)
    AddTagBrk(_NestedComment2Open_Str);

  if (_NestedComment2Close_Str)
    AddTagBrk(_NestedComment2Close_Str);

  if (_StdTagOpen_Str)
    AddTagBrk(_StdTagOpen_Str);

  if (_StdTagClose_Str)
    AddTagBrk(_StdTagClose_Str);

  if (_EndTagOpen_Str)
    AddTagBrk(_EndTagOpen_Str);

  if (_EndTagClose_Str)
    AddTagBrk(_EndTagClose_Str);

  if (_EmptyOpen_Str)
    AddTagBrk(_EmptyOpen_Str);

  if (_EmptyClose_Str)
    AddTagBrk(_EmptyClose_Str);

  if (_ScriptOpen_Str)
    AddTagBrk(_ScriptOpen_Str);

  if (_ScriptClose_Str)
    AddTagBrk(_ScriptClose_Str);

  // C/C++ language tags
  if (_CCommentBlkOpen_Str)
    AddTagBrk(_CCommentBlkOpen_Str);

  if (_CCommentBlkClose_Str)
    AddTagBrk(_CCommentBlkClose_Str);

  if (_COpenCommentBlkOpen_Str)
    AddTagBrk(_COpenCommentBlkOpen_Str);

  if (_COpenCommentBlkClose_Str)
    AddTagBrk(_COpenCommentBlkClose_Str);

  if (_CCloseCommentBlkOpen_Str)
    AddTagBrk(_CCloseCommentBlkOpen_Str);

  if (_CCloseCommentBlkClose_Str)
    AddTagBrk(_CCloseCommentBlkClose_Str);

  if (_CppCommentLineOpen_Str)
    AddTagBrk(_CppCommentLineOpen_Str);

  if (_CppCommentLineClose_Str)
    AddTagBrk(_CppCommentLineClose_Str);

  AssignGlobalTagBrkList(_TagBrkMatrix);

  // first array element is tag current nesting level
  // second array element is tag sequential count value
  if (!GiveTagCntIndex())
    InitTagCounts();
}

/****************************************************************************/
void TagCountData::DestroyObjectData()
{
  if (_DestroyLists)
    delete _StdTagList;
  else if (_StdTagList)
  {
    #if TAGELEMENT_DEBUG1
      int x;
      for (x=0; _StdTagList->Size(); x++)
      {
        printf("%d: _StdTagList->Head() = %p\n", x, _StdTagList->Head()->Value());
        ::Delete(_StdTagList->PopNode());
      }
    #else
      _StdTagList->SetKeepValue(true);
      _StdTagList->DeleteAllAndData(1);
    #endif
    delete _StdTagList;
  }
  _StdTagList = NULL;

  if (_DestroyLists)
    delete _EndTagList;
  else
  {
    #if TAGELEMENT_DEBUG1
      int x;
      for (x=0; _EndTagList->Size(); x++)
      {
        printf("%d: _EndTagList->Head() = %p\n", x, _EndTagList->Head()->Value());
        ::Delete(_EndTagList->PopNode());
      }
    #else
      _EndTagList->SetKeepValue(true);
      _EndTagList->DeleteAllAndData(1);
    #endif
    delete _EndTagList;
  }
  _EndTagList = NULL;

  ::RawDeleteArray(_TagCntMatrix);
  _TagCntMatrix = NULL;

  delete _ListIter;
  _ListIter = NULL;
}

/****************************************************************************/
void TagCountData::SetDestroyLists(bool dls_)
{
  _DestroyLists = dls_;
}

/****************************************************************************/
char** TagCountData::InitTagBrkArray(char** ArrPtr_, size_t max)
{
  size_t x;
  if (ArrPtr_)
    for (x = 0; x < max; x++)
      ArrPtr_[x] = NULL;

  return ArrPtr_;
}

/****************************************************************************/
int** TagCountData::InitTagCntMatrix(int** ArrPtr_, size_t max)
{
  size_t x;
  if (ArrPtr_)
    for (x = 0; x < max; x++)
      ArrPtr_[x] = NULL;

  return ArrPtr_;
}

/****************************************************************************/
int* TagCountData::SetupElementSeqList()
{
  if (!_ElementSeqList)
  {
    int LsDataSz_ = LISTSIZEDATA_SIZE;
    int TotalSz_ = LsDataSz_ + (SEQLISTGROUP_SIZE * GROWINCR);
    _ElementSeqList = (int*)RawAllocateWith(MEMMATRIX, sizeof(int) * TotalSz_);
    _ElementSeqList[TOTALSIZE_OFFSET] = TotalSz_;
    _ElementSeqList[DATACOUNT_OFFSET] = GROWINCR;

    ::memset(&_ElementSeqList[LsDataSz_], 0, (TotalSz_ - LsDataSz_) * sizeof(int));
  }

  return _ElementSeqList;
}

/****************************************************************************/
int* TagCountData::GrowElementSeqList(int Incr_)
{
  if (_ElementSeqList)
  {
    int OldSz_ = _ElementSeqList[TOTALSIZE_OFFSET];
    int OldDataCnt_ = _ElementSeqList[DATACOUNT_OFFSET];
    int* OldLst_ = _ElementSeqList;

    int LsDataSz_ = LISTSIZEDATA_SIZE;
    int TotalSz_ = LsDataSz_ + (SEQLISTGROUP_SIZE * (OldDataCnt_ + Incr_));

    _ElementSeqList = (int*)RawAllocateWith(MEMMATRIX, sizeof(int) * TotalSz_);
    _ElementSeqList[TOTALSIZE_OFFSET] = TotalSz_;
    _ElementSeqList[DATACOUNT_OFFSET] = OldDataCnt_ + Incr_;

    ::memmove(&_ElementSeqList[LsDataSz_], &OldLst_[LsDataSz_], (OldSz_ - LsDataSz_) * sizeof(int));
    RawDeleteArray(OldLst_);
    return _ElementSeqList;
  }

  return SetupElementSeqList();
}

/****************************************************************************/
void TagCountData::SetupTagData(bool DoAlloc_)
{
  if (!_TagCntMatrix || !DoAlloc_)
  {
    int ArrSz_ = 0;
  
    if (DoAlloc_)
    {
      _StdTagList = new SearchableList<TagElement>;
      _EndTagList = new SearchableList<TagElement>;
      SetupElementSeqList();

      if (!_TagBrkMatrix)
        _TagBrkMatrix = (char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TagEnums::TAGLIST_LENGTH);

      if (!_TagCntMatrix)
        _TagCntMatrix = (int**)RawAllocateWith(MEMMATRIX, sizeof(int*) * TagEnums::TAGLIST_LENGTH);

      _ListIter = new SimpleListIterator<TagElement>(_StdTagList);
    }

    if (_TagBrkMatrix && !_TagBrkIndex)
    {
      ArrSz_ = sizeof(char*) * TagEnums::TAGLIST_LENGTH;
      InitTagBrkArray(_TagBrkMatrix, TagEnums::TAGLIST_LENGTH);
    }

    if (_TagCntMatrix && !_TagCntIndex)
    {
      ArrSz_ = sizeof(int*) * TagEnums::TAGLIST_LENGTH;
      InitTagCntMatrix(_TagCntMatrix, TagEnums::TAGLIST_LENGTH);

      InitTagCounts();
      _TagCntIndex = 0;
    
      _TagCntMatrix[_TagCntIndex++] = _DocTypeOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _DocTypeClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _CommentOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _CommentClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _NestedComment1Open_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _NestedComment1Close_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _NestedComment2Open_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _NestedComment2Close_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _StdTagOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _StdTagClose_Cnt;
    
      _TagCntMatrix[_TagCntIndex++] = _EndTagOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _EndTagClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _EmptyOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _EmptyClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _ScriptOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _ScriptClose_Cnt;

      // C/C++ language tags
      _TagCntMatrix[_TagCntIndex++] = _CCommentBlkOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _CCommentBlkClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _COpenCommentBlkOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _COpenCommentBlkClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _CCloseCommentBlkOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _CCloseCommentBlkClose_Cnt;

      _TagCntMatrix[_TagCntIndex++] = _CppCommentLineOpen_Cnt;
      _TagCntMatrix[_TagCntIndex++] = _CppCommentLineClose_Cnt;
    }
  }
}

/****************************************************************************/
TagCountData& TagCountData::SetHtmlSpecialCase(HtmlSpecialCaseData* Ptr_)
{
  _HtmlSpecialCase = Ptr_;
  return *this;
}

/****************************************************************************/
TagCountData& TagCountData::CopyTagCount(const TagCountData* TagCnt_)
{
  if (!TagCnt_)
    return *this;

  int x;
  int Max_ = MAX_FIELDS;
  int ArrSz_ = sizeof(int) * Max_;
  
  ChrString Src_;
  ChrString Trg_;

  memmove(_DocTypeOpen_Cnt, TagCnt_->_DocTypeOpen_Cnt, ArrSz_);
  memmove(_DocTypeClose_Cnt, TagCnt_->_DocTypeClose_Cnt, ArrSz_);
  memmove(_CommentOpen_Cnt, TagCnt_->_CommentOpen_Cnt, ArrSz_);
  memmove(_CommentClose_Cnt, TagCnt_->_CommentClose_Cnt, ArrSz_);
  memmove(_NestedComment1Open_Cnt, TagCnt_->_NestedComment1Open_Cnt, ArrSz_);
  memmove(_NestedComment1Close_Cnt, TagCnt_->_NestedComment1Close_Cnt, ArrSz_);
  memmove(_NestedComment2Open_Cnt, TagCnt_->_NestedComment2Open_Cnt, ArrSz_);
  memmove(_NestedComment2Close_Cnt, TagCnt_->_NestedComment2Close_Cnt, ArrSz_);
  memmove(_StdTagOpen_Cnt, TagCnt_->_StdTagOpen_Cnt, ArrSz_);
  memmove(_StdTagClose_Cnt, TagCnt_->_StdTagClose_Cnt, ArrSz_);
  memmove(_EndTagOpen_Cnt, TagCnt_->_EndTagOpen_Cnt, ArrSz_);
  memmove(_EndTagClose_Cnt, TagCnt_->_EndTagClose_Cnt, ArrSz_);
  memmove(_EmptyOpen_Cnt, TagCnt_->_EmptyOpen_Cnt, ArrSz_);
  memmove(_EmptyClose_Cnt, TagCnt_->_EmptyClose_Cnt, ArrSz_);
  memmove(_ScriptOpen_Cnt, TagCnt_->_ScriptOpen_Cnt, ArrSz_);
  memmove(_ScriptClose_Cnt, TagCnt_->_ScriptClose_Cnt, ArrSz_);

  // C/C++ language tags
  memmove(_CCommentBlkOpen_Cnt, TagCnt_->_CCommentBlkOpen_Cnt, ArrSz_);
  memmove(_CCommentBlkClose_Cnt, TagCnt_->_CCommentBlkClose_Cnt, ArrSz_);
  memmove(_COpenCommentBlkOpen_Cnt, TagCnt_->_COpenCommentBlkOpen_Cnt, ArrSz_);
  memmove(_COpenCommentBlkClose_Cnt, TagCnt_->_COpenCommentBlkClose_Cnt, ArrSz_);
  memmove(_CCloseCommentBlkOpen_Cnt, TagCnt_->_CCloseCommentBlkOpen_Cnt, ArrSz_);
  memmove(_CCloseCommentBlkClose_Cnt, TagCnt_->_CCloseCommentBlkClose_Cnt, ArrSz_);
  memmove(_CppCommentLineOpen_Cnt, TagCnt_->_CppCommentLineOpen_Cnt, ArrSz_);
  memmove(_CppCommentLineClose_Cnt, TagCnt_->_CppCommentLineClose_Cnt, ArrSz_);

  Max_ = TagEnums::TAGLIST_MAX_ENTRIES;
  for (x = 0; x < Max_; x++)
    if (TagCnt_->_TagBrkMatrix[x])
      if (_TagBrkMatrix[x])
      {
        Trg_ = _TagBrkMatrix[x];
        Src_ = TagCnt_->_TagBrkMatrix[x];

        if (Src_ != Trg_)
        {
          Trg_ = Src_;
          ::RawDeleteArray(_TagBrkMatrix[x]);
          _TagBrkMatrix[x] = ::NewString(Trg_.c_str());
        }
      }
      else
        _TagBrkMatrix[x] = ::NewString(Src_.c_str());

  return *this;
}

/****************************************************************************/
const int* TagCountData::GiveTagCountArray(int Index_) const
{
  return ((0 <= Index_ && Index_ < _TagCntMax) ? _TagCntMatrix[Index_]:NULL);
}

/****************************************************************************/
TagCountData& TagCountData::InitTagCounts()
{
  Reset(true);
}

/****************************************************************************/
TagCountData& TagCountData::Reset(bool ResetCounts_)
{
  int x = 0;
  int y = 0;
  int Max_ = MAX_FIELDS;
  int ArrSz_ = sizeof(int) * Max_;

  if (ResetCounts_)
  {
    memset(_DocTypeOpen_Cnt, 0, ArrSz_);
    memset(_DocTypeClose_Cnt, 0, ArrSz_);
    memset(_CommentOpen_Cnt, 0, ArrSz_);
    memset(_CommentClose_Cnt, 0, ArrSz_);
    memset(_NestedComment1Open_Cnt, 0, ArrSz_);
    memset(_NestedComment1Close_Cnt, 0, ArrSz_);
    memset(_NestedComment2Open_Cnt, 0, ArrSz_);
    memset(_NestedComment2Close_Cnt, 0, ArrSz_);
    memset(_StdTagOpen_Cnt, 0, ArrSz_);
    memset(_StdTagClose_Cnt, 0, ArrSz_);
    memset(_EndTagOpen_Cnt, 0, ArrSz_);
    memset(_EndTagClose_Cnt, 0, ArrSz_);
    memset(_EmptyOpen_Cnt, 0, ArrSz_);
    memset(_EmptyClose_Cnt, 0, ArrSz_);
    memset(_ScriptOpen_Cnt, 0, ArrSz_);
    memset(_ScriptClose_Cnt, 0, ArrSz_);

    // C/C++ language tags
    memset(_CCommentBlkOpen_Cnt, 0, ArrSz_);
    memset(_CCommentBlkClose_Cnt, 0, ArrSz_);
    memset(_COpenCommentBlkOpen_Cnt, 0, ArrSz_);
    memset(_COpenCommentBlkClose_Cnt, 0, ArrSz_);
    memset(_CCloseCommentBlkOpen_Cnt, 0, ArrSz_);
    memset(_CCloseCommentBlkClose_Cnt, 0, ArrSz_);
    memset(_CppCommentLineOpen_Cnt, 0, ArrSz_);
    memset(_CppCommentLineClose_Cnt, 0, ArrSz_);
  }

  // 3rd element: tag attrib bits:
  x = TagEnums::TAGATTR;
  _DocTypeOpen_Cnt[x] = SINGLETON_TAGATTR;
  _DocTypeClose_Cnt[x] = SINGLETON_TAGATTR;
  _CommentOpen_Cnt[x] = SINGLETON_TAGATTR;
  _CommentClose_Cnt[x] = SINGLETON_TAGATTR;
  _NestedComment1Open_Cnt[x] = PAIR_TAGATTR;
  _NestedComment1Close_Cnt[x] = PAIR_TAGATTR;
  _NestedComment2Open_Cnt[x] = PAIR_ENDER;
  _NestedComment2Close_Cnt[x] = PAIR_ENDER;
  _StdTagOpen_Cnt[x] = TAG_SPECIFIC;
  _StdTagClose_Cnt[x] = TAG_SPECIFIC;
  _EndTagOpen_Cnt[x] = PAIR_ENDER;
  _EndTagClose_Cnt[x] = PAIR_ENDER;
  _EmptyOpen_Cnt[x] = SINGLETON_TAGATTR | EMPTY_TAGATTR;
  _EmptyClose_Cnt[x] = SINGLETON_TAGATTR | EMPTY_TAGATTR;
  _ScriptOpen_Cnt[x] = SINGLETON_TAGATTR;
  _ScriptClose_Cnt[x] = SINGLETON_TAGATTR;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = SINGLETON_TAGATTR;
  _CCommentBlkClose_Cnt[x] = SINGLETON_TAGATTR;
  _COpenCommentBlkOpen_Cnt[x] = PAIR_TAGATTR;
  _COpenCommentBlkClose_Cnt[x] = PAIR_TAGATTR;
  _CCloseCommentBlkOpen_Cnt[x] = PAIR_ENDER;
  _CCloseCommentBlkClose_Cnt[x] = PAIR_ENDER;
  _CppCommentLineOpen_Cnt[x] = SINGLETON_TAGATTR;
  _CppCommentLineClose_Cnt[x] = SINGLETON_TAGATTR;

  // 4th element: index into individual tag element list -- TagCnt, TagBrk
  x = TagEnums::TAGINDEX;
  y = 0;
  
  _DocTypeOpen_Cnt[x] = y++;
  _DocTypeClose_Cnt[x] = y++;
  _CommentOpen_Cnt[x] = y++;
  _CommentClose_Cnt[x] = y++;
  _NestedComment1Open_Cnt[x] = y++;
  _NestedComment1Close_Cnt[x] = y++;
  _NestedComment2Open_Cnt[x] = y++;
  _NestedComment2Close_Cnt[x] = y++;
  _StdTagOpen_Cnt[x] = y++;
  _StdTagClose_Cnt[x] = y++;
  _EndTagOpen_Cnt[x] = y++;
  _EndTagClose_Cnt[x] = y++;
  _EmptyOpen_Cnt[x] = y++;
  _EmptyClose_Cnt[x] = y++;
  _ScriptOpen_Cnt[x] = y++;
  _ScriptClose_Cnt[x] = y++;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = y++;
  _CCommentBlkClose_Cnt[x] = y++;
  _COpenCommentBlkOpen_Cnt[x] = y++;
  _COpenCommentBlkClose_Cnt[x] = y++;
  _CCloseCommentBlkOpen_Cnt[x] = y++;
  _CCloseCommentBlkClose_Cnt[x] = y++;
  _CppCommentLineOpen_Cnt[x] = y++;
  _CppCommentLineClose_Cnt[x] = y++;

  // 5th element: index of matching tag in pair sequence if tag attrib is pair
  x = TagEnums::MATCHINDEX;
  _NestedComment1Open_Cnt[x] = _NestedComment2Open_Cnt[TagEnums::TAGINDEX];
  _NestedComment1Close_Cnt[x] = _NestedComment2Close_Cnt[TagEnums::TAGINDEX];
  _StdTagOpen_Cnt[x] = _EndTagOpen_Cnt[TagEnums::TAGINDEX];
  _StdTagClose_Cnt[x] = _EndTagClose_Cnt[TagEnums::TAGINDEX];
  _COpenCommentBlkOpen_Cnt[x] = _CCloseCommentBlkOpen_Cnt[TagEnums::TAGINDEX];
  _COpenCommentBlkClose_Cnt[x] = _CCloseCommentBlkClose_Cnt[TagEnums::TAGINDEX];

  // 6th element: tag position of tag : opening/closing/forbidden
  x = TagEnums::TAGPOS;
  _DocTypeOpen_Cnt[x] = FORBIDDEN;
  _DocTypeClose_Cnt[x] = FORBIDDEN;
  _CommentOpen_Cnt[x] = FORBIDDEN;
  _CommentClose_Cnt[x] = FORBIDDEN;
  _NestedComment1Open_Cnt[x] = OPENING;
  _NestedComment1Close_Cnt[x] = OPENING;
  _NestedComment2Open_Cnt[x] = CLOSING;
  _NestedComment2Close_Cnt[x] = CLOSING;
  _StdTagOpen_Cnt[x] = INDETERMINATE;
  _StdTagClose_Cnt[x] = INDETERMINATE;
  _EndTagOpen_Cnt[x] = CLOSING;
  _EndTagClose_Cnt[x] = CLOSING;
  _EmptyOpen_Cnt[x] = FORBIDDEN;
  _EmptyClose_Cnt[x] = FORBIDDEN;
  _ScriptOpen_Cnt[x] = FORBIDDEN;
  _ScriptClose_Cnt[x] = FORBIDDEN;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = FORBIDDEN;
  _CCommentBlkClose_Cnt[x] = FORBIDDEN;
  _COpenCommentBlkOpen_Cnt[x] = OPENING;
  _COpenCommentBlkClose_Cnt[x] = OPENING;
  _CCloseCommentBlkOpen_Cnt[x] = CLOSING;
  _CCloseCommentBlkClose_Cnt[x] = CLOSING;
  _CppCommentLineOpen_Cnt[x] = FORBIDDEN;
  _CppCommentLineClose_Cnt[x] = FORBIDDEN;

  // 8th element: Required tag order for start+end optional tags
  x = TagEnums::OPTREQTAGORDER;
  _DocTypeOpen_Cnt[x] = NO_REQTAG;
  _DocTypeClose_Cnt[x] = NO_REQTAG;
  _CommentOpen_Cnt[x] = NO_REQTAG;
  _CommentClose_Cnt[x] = NO_REQTAG;
  _NestedComment1Open_Cnt[x] = NO_REQTAG;
  _NestedComment1Close_Cnt[x] = NO_REQTAG;
  _NestedComment2Open_Cnt[x] = NO_REQTAG;
  _NestedComment2Close_Cnt[x] = NO_REQTAG;
  _StdTagOpen_Cnt[x] = NO_REQTAG;
  _StdTagClose_Cnt[x] = NO_REQTAG;
  _EndTagOpen_Cnt[x] = NO_REQTAG;
  _EndTagClose_Cnt[x] = NO_REQTAG;
  _EmptyOpen_Cnt[x] = NO_REQTAG;
  _EmptyClose_Cnt[x] = NO_REQTAG;
  _ScriptOpen_Cnt[x] = NO_REQTAG;
  _ScriptClose_Cnt[x] = NO_REQTAG;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = NO_REQTAG;
  _CCommentBlkClose_Cnt[x] = NO_REQTAG;
  _COpenCommentBlkOpen_Cnt[x] = NO_REQTAG;
  _COpenCommentBlkClose_Cnt[x] = NO_REQTAG;
  _CCloseCommentBlkOpen_Cnt[x] = NO_REQTAG;
  _CCloseCommentBlkClose_Cnt[x] = NO_REQTAG;
  _CppCommentLineOpen_Cnt[x] = NO_REQTAG;
  _CppCommentLineClose_Cnt[x] = NO_REQTAG;

  // 9th element: Implied end of tag at specific condition met
  x = TagEnums::IMPLIEDEND;
  _DocTypeOpen_Cnt[x] = AT_NEXTTAG;
  _DocTypeClose_Cnt[x] = AT_NEXTTAG;
  _CommentOpen_Cnt[x] = AT_NEXTTAG;
  _CommentClose_Cnt[x] = AT_NEXTTAG;
  _NestedComment1Open_Cnt[x] = NO_IMPLIEDEND;
  _NestedComment1Close_Cnt[x] = NO_IMPLIEDEND;
  _NestedComment2Open_Cnt[x] = NO_IMPLIEDEND;
  _NestedComment2Close_Cnt[x] = NO_IMPLIEDEND;
  _StdTagOpen_Cnt[x] = NO_IMPLIEDEND;
  _StdTagClose_Cnt[x] = NO_IMPLIEDEND;
  _EndTagOpen_Cnt[x] = NO_IMPLIEDEND;
  _EndTagClose_Cnt[x] = NO_IMPLIEDEND;
  _EmptyOpen_Cnt[x] = AT_NEXTTAG;
  _EmptyClose_Cnt[x] = AT_NEXTTAG;
  _ScriptOpen_Cnt[x] = AT_NEXTTAG;
  _ScriptClose_Cnt[x] = AT_NEXTTAG;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = AT_NEXTTAG;
  _CCommentBlkClose_Cnt[x] = AT_NEXTTAG;
  _COpenCommentBlkOpen_Cnt[x] = NO_IMPLIEDEND;
  _COpenCommentBlkClose_Cnt[x] = NO_IMPLIEDEND;
  _CCloseCommentBlkOpen_Cnt[x] = NO_IMPLIEDEND;
  _CCloseCommentBlkClose_Cnt[x] = NO_IMPLIEDEND;
  _CppCommentLineOpen_Cnt[x] = AT_NEXTTAG;
  _CppCommentLineClose_Cnt[x] = AT_NEXTTAG;

  // 10th element: Required tag for s+e optional tag found and condition met
  x = TagEnums::REQTAGCOND;
  _DocTypeOpen_Cnt[x] = TAG_NOT_FOUND;
  _DocTypeClose_Cnt[x] = TAG_NOT_FOUND;
  _CommentOpen_Cnt[x] = TAG_NOT_FOUND;
  _CommentClose_Cnt[x] = TAG_NOT_FOUND;
  _NestedComment1Open_Cnt[x] = TAG_NOT_FOUND;
  _NestedComment1Close_Cnt[x] = TAG_NOT_FOUND;
  _NestedComment2Open_Cnt[x] = TAG_NOT_FOUND;
  _NestedComment2Close_Cnt[x] = TAG_NOT_FOUND;
  _StdTagOpen_Cnt[x] = TAG_NOT_FOUND;
  _StdTagClose_Cnt[x] = TAG_NOT_FOUND;
  _EndTagOpen_Cnt[x] = TAG_NOT_FOUND;
  _EndTagClose_Cnt[x] = TAG_NOT_FOUND;
  _EmptyOpen_Cnt[x] = TAG_NOT_FOUND;
  _EmptyClose_Cnt[x] = TAG_NOT_FOUND;
  _ScriptOpen_Cnt[x] = TAG_NOT_FOUND;
  _ScriptClose_Cnt[x] = TAG_NOT_FOUND;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = TAG_NOT_FOUND;
  _CCommentBlkClose_Cnt[x] = TAG_NOT_FOUND;
  _COpenCommentBlkOpen_Cnt[x] = TAG_NOT_FOUND;
  _COpenCommentBlkClose_Cnt[x] = TAG_NOT_FOUND;
  _CCloseCommentBlkOpen_Cnt[x] = TAG_NOT_FOUND;
  _CCloseCommentBlkClose_Cnt[x] = TAG_NOT_FOUND;
  _CppCommentLineOpen_Cnt[x] = TAG_NOT_FOUND;
  _CppCommentLineClose_Cnt[x] = TAG_NOT_FOUND;

  // 11th element: Implied end state for tags with specific implied end conditions
  x = TagEnums::IMPLIEDENDCOND;
  _DocTypeOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _DocTypeClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CommentOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CommentClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _NestedComment1Open_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _NestedComment1Close_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _NestedComment2Open_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _NestedComment2Close_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _StdTagOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _StdTagClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _EndTagOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _EndTagClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _EmptyOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _EmptyClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _ScriptOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _ScriptClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;

  // C/C++ language tags
  _CCommentBlkOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CCommentBlkClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _COpenCommentBlkOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _COpenCommentBlkClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CCloseCommentBlkOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CCloseCommentBlkClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CppCommentLineOpen_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;
  _CppCommentLineClose_Cnt[x] = TNF_IMPLIEDEND_NOT_MET;

  if (_DocType)
    SetDocType(0);

  _TagDataUpdated = false;
  return *this;  
}

/****************************************************************************/
TagCountData& TagCountData::DeleteTagLists()
{
  _ListIter->IndexNode(0);
  _StdTagList->DeleteAllAndData();
  _EndTagList->DeleteAllAndData();
  _TagIterIndex = 0;
}

/****************************************************************************/
TagCountData& TagCountData::ResetTagDataUpdate()
{
  _TagDataUpdated = false;
  _SeqListUpdateIndex = 0;
}

/****************************************************************************/
TagCountData& TagCountData::ResetTagIterIndex()
{
  _TagIterIndex = 0;
  return *this;
}

/****************************************************************************/
bool TagCountData::SetTagIterIndex(int TagIndex_)
{
  if (0 <= TagIndex_ && TagIndex_ < _StdTagList->Size())
  {
    _TagIterIndex = TagIndex_;
    return true;
  }

  return false;
}

/****************************************************************************/
bool TagCountData::AdvanceTagIter()
{
  if ((_TagIterIndex+1) < _StdTagList->Size())
  {
    ++_TagIterIndex;
    return true;
  }

  return false;
}

/****************************************************************************/
TagElement* TagCountData::GetCurrentTagElement()
{
  SimpleNode<TagElement>* Node_ = _ListIter->IndexNode(_TagIterIndex);
  return (Node_ ? Node_->Value():NULL);
}

/****************************************************************************/
TagCountData& TagCountData::SetEofFound(bool Eof_)
{
  _EofFound = Eof_;
  return *this;
}

/****************************************************************************/
TagCountData& TagCountData::SetDocType(int DocType_)
{
  if (DocType_ > 0)
    _DocType = DocType_;

  bool CStyle_ = _DocType == TagEnums::C_FILE;
  bool CppStyle_ = _DocType == TagEnums::CPP_FILE;
  bool XmlStyle_ = _DocType == TagEnums::XML_FILE;
  bool HtmlStyle_ = !_DocType ||
                    _DocType == TagEnums::HTML_FILE ||
                    _DocType == TagEnums::XHTML_FILE;

  if (CppStyle_ || CStyle_)
  {
    if (CStyle_)
      ResetCTags();
    else
      ResetCppTags();
  }
  else if (XmlStyle_)
    ResetXmlTags();
  else if (HtmlStyle_)
    ResetHtmlTags();

  return *this;
}

/****************************************************************************/
int TagCountData::BrkStringToIndex(const char* Brk_, int& BrkEnder_, bool Substr_) const
{
  int x = 0;
  int MaxLen_ = 0;
  int MaxIndex_ = -1;

  int Max_ = TagEnums::TAGLIST_MAX_ENTRIES;
  int BrkArr_[TagEnums::TAGLIST_MAX_ENTRIES];

  ::memset(BrkArr_, 0, sizeof(int) * Max_);
  BrkEnder_ = 0;

  ChrString Src_ = Brk_ ? Brk_:"";
  ChrString Trg_;

  if (Brk_)
    for (x = 0; x < Max_; x++)
      if (_TagBrkMatrix[x])
      {
        Trg_ = _TagBrkMatrix[x];

        if (Src_ == Trg_)
        {
          BrkEnder_ = x % 2;
          x -= BrkEnder_;
          BrkArr_[x] = 1;
          BrkArr_[x+1] = Trg_.strlen();
          x += BrkEnder_;
        }
        else if (Substr_ && strlen(Brk_) > Trg_.strlen())
        {
          Src_ = Brk_;
          Src_.Left(Trg_.strlen());

          if (Src_ == Trg_)
          {
            BrkEnder_ = x % 2;
            x -= BrkEnder_;
            BrkArr_[x] = 1;
            BrkArr_[x+1] = Trg_.strlen();
            x += BrkEnder_;
          }
        }
      }

  for (x = 0; x < Max_; x+=2)
    if (BrkArr_[x] && MaxLen_ < BrkArr_[x+1])
    {
      MaxIndex_ = x;
      MaxLen_ = BrkArr_[x+1];
    }

  return MaxIndex_;
}

/****************************************************************************/
int TagCountData::BrkStringToIndex(const char* StartBrk_, const char* EndBrk_,
                                   int& PairEnder_, bool Substr_) const
{
  int x = 0;
  int MaxLen_ = 0;
  int MaxIndex_ = -1;

  int attr = 0;
  int Max_ = TagEnums::TAGLIST_MAX_ENTRIES;
  int StartBrkArr_[TagEnums::TAGLIST_MAX_ENTRIES];
  int EndBrkArr_[TagEnums::TAGLIST_MAX_ENTRIES];

  ::memset(StartBrkArr_, 0, sizeof(int) * Max_);
  ::memset(EndBrkArr_, 0, sizeof(int) * Max_);
  PairEnder_ = 0;

  ChrString SrcStart_ = StartBrk_ ? StartBrk_:"";
  ChrString SrcEnd_ = EndBrk_ ? EndBrk_:"";
  
  ChrString TrgStart_;
  ChrString TrgEnd_;

  if (StartBrk_ && EndBrk_)
    for (x = 0; x < Max_; x+=2)
      if (_TagBrkMatrix[x] && _TagBrkMatrix[x+1])
      {
        TrgStart_ = _TagBrkMatrix[x];
        TrgEnd_ = _TagBrkMatrix[x+1];

        if (SrcStart_ == TrgStart_ &&
            SrcEnd_ == TrgEnd_)
        {
          attr = _TagCntMatrix[x][TagEnums::TAGATTR];
          PairEnder_ = (attr == TagEnums::PAIR_ENDER) ? 1:0;

          StartBrkArr_[x] = 1;
          StartBrkArr_[x+1] = TrgStart_.strlen();
          EndBrkArr_[x] = 1;
          EndBrkArr_[x+1] = TrgEnd_.strlen();
        }
        else if (Substr_ && (strlen(StartBrk_) > TrgStart_.strlen() ||
                             strlen(EndBrk_) > TrgEnd_.strlen()))
        {
          SrcStart_ = StartBrk_;
          SrcStart_.Left(TrgStart_.strlen());

          SrcEnd_ = EndBrk_;
          SrcEnd_.Left(TrgEnd_.strlen());

          if (SrcStart_ == TrgStart_ &&
              SrcEnd_ == TrgEnd_)
          {
            attr = _TagCntMatrix[x][TagEnums::TAGATTR];
            PairEnder_ = (attr == TagEnums::PAIR_ENDER) ? 1:0;

            StartBrkArr_[x] = 1;
            StartBrkArr_[x+1] = TrgStart_.strlen();
            EndBrkArr_[x] = 1;
            EndBrkArr_[x+1] = TrgEnd_.strlen();
          }
        }
      }

  for (x = 0; x < Max_; x+=2)
    if (StartBrkArr_[x] && EndBrkArr_[x] &&
        MaxLen_ < (StartBrkArr_[x+1] + EndBrkArr_[x+1]))
    {
      MaxIndex_ = x;
      MaxLen_ = StartBrkArr_[x+1] + EndBrkArr_[x+1];
    }

  return MaxIndex_;
}

/****************************************************************************/
int TagCountData::GiveBrkNesting(const char* TxtFndBrk_) const
{
  int Ender_ = 0;
  int Index_ = BrkStringToIndex(TxtFndBrk_, Ender_);
  return ((Index_ >= 0) ? _TagCntMatrix[Index_][TagEnums::NESTING]:-1);
}

/****************************************************************************/
int TagCountData::GiveTagCount(const char* TxtFndBrk_) const
{
  int Ender_ = 0;
  int Index_ = BrkStringToIndex(TxtFndBrk_, Ender_);
  return ((Index_ >= 0) ? _TagCntMatrix[Index_][TagEnums::TAGCOUNT]:-1);
}

/****************************************************************************/
bool TagCountData::IsParentOf(const TagElement* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
bool TagCountData::IsElementTagStr(const char* SrcStartTagBrk_, const ChrString& SrcTagElement_, const char* SrcEndTagBrk_,
                                   const char* TrgStartTagBrk_, const ChrString& TrgTagElement_, const char* TrgEndTagBrk_)
{
  if (SrcStartTagBrk_ && !SrcTagElement_.IsEmpty() && SrcEndTagBrk_ &&
      TrgStartTagBrk_ && !TrgTagElement_.IsEmpty() && TrgEndTagBrk_)
    return
    (
      StriComp(SrcStartTagBrk_, TrgStartTagBrk_) == 0 &&
      StriComp(SrcEndTagBrk_, TrgEndTagBrk_) == 0 &&
      SrcTagElement_ == TrgTagElement_
    );

  return false;
}

/****************************************************************************/
int TagCountData::PushBrkNesting(const char* UpdateBrk_, const char* TxtFndBrk_, int Nest_)
{
  int Ender_ = 0;
  int Index_ = BrkStringToIndex(UpdateBrk_, Ender_);
  int FndIndex_ = (SafeStrCmp(UpdateBrk_, TxtFndBrk_) != 0) ?
                       BrkStringToIndex(TxtFndBrk_, Ender_):
                       Index_;

  if (Index_ >= 0)
  {
    // Nest_ == 0 if counting TxtFndBrk only
    _TagCntMatrix[Index_][TagEnums::NESTING] += Nest_;
    
    if (FndIndex_ >= 0)
      _TagCntMatrix[FndIndex_+Ender_][TagEnums::TAGCOUNT]++;

    return _TagCntMatrix[Index_][TagEnums::NESTING];
  }

  return -1;
}

/****************************************************************************/
int TagCountData::PopBrkNesting(const char* UpdateBrk_, const char* TxtFndBrk_, int Nest_)
{
  int Ender_ = 0;
  int Index_ = BrkStringToIndex(UpdateBrk_, Ender_);
  int FndIndex_ = (SafeStrCmp(UpdateBrk_, TxtFndBrk_) != 0) ?
                       BrkStringToIndex(TxtFndBrk_, Ender_):
                       Index_;

  if (Index_ >= 0)
  {
    // Nest_ == 0 if counting TxtFndBrk only
    _TagCntMatrix[Index_][TagEnums::NESTING] -= Nest_;
    
    if (FndIndex_ >= 0)
      _TagCntMatrix[FndIndex_+Ender_][TagEnums::TAGCOUNT]++;

    return _TagCntMatrix[Index_][TagEnums::NESTING];
  }

  return -1;
}

/****************************************************************************/
// Format of cumulative element sequence list:
//   [AbsSize.] [listsize.] [listseq][attrib][tagcount][nesting]
//
// AbsSize: absolute size of list in number of ints allocated
// listsize: the size of the int list in (listseq+attrib+tagcount+nesting) groups
// listseq: list sequence of referred TagElement node
// attrib: attributes of the tag in the TagElement node
// tagcount: running tag count with specific value for each encountered tag
// nesting: running nesting with specific value for each encountered tag
//
// The cumulative element sequence list is specific to the parent object
// which holds only one single instance.
//
void TagCountData::UpdateSeqList(TagElement* Element_, int PairEnder_,
                                 bool FindAndUpdate_)
{
  if (!Element_)
    return;

  int Max_ = 0;
  int Index_ = 0;
  int HighElm_ = ELEMENTLIST_OFFSET_SIZE - 1;
  int LsDataSz_ = LISTSIZEDATA_SIZE;
  int TotalSz_ = _ElementSeqList[TOTALSIZE_OFFSET];
  int DataCnt_ = _ElementSeqList[DATACOUNT_OFFSET];

  if (_SeqListIndex >= DataCnt_)
  {
    GrowElementSeqList();
    TotalSz_ = _ElementSeqList[TOTALSIZE_OFFSET];
    DataCnt_ = _ElementSeqList[DATACOUNT_OFFSET];
  }

  Max_ = Index_ = LsDataSz_ + (SEQLISTGROUP_SIZE * _SeqListIndex);
  _SeqIndexIncr = 0;

  if (FindAndUpdate_)
  {
    for (Index_ = ELEMENTLIST_BASE_OFFSET;
         Index_ < Max_; Index_ += ELEMENTLIST_OFFSET_SIZE)
      if (Index_ + HighElm_ < TotalSz_ &&
          Element_->TagAttrib() == _ElementSeqList[Index_+TAGATTRIB_OFFSET] &&
          Element_->TagListSeq() == _ElementSeqList[Index_+TAGLISTSEQ_OFFSET])
      {
        _ElementSeqList[Index_+TAGCOUNT_OFFSET] = Element_->TagCount();
        _ElementSeqList[Index_+TAGNESTING_OFFSET] = Element_->TagNesting();
        _SeqListUpdateIndex = Index_;
        _TagDataUpdated = true;
        break;
      }
  }
  else
  {
    // Add ending tag sequence (tag counts) first before de-nesting tag pair
    if (PairEnder_)
    {
      TagElement* MatchingTag_ = Element_->GiveMatchingTag();

      if (Index_ + HighElm_ < TotalSz_)
      {
        _ElementSeqList[Index_++] = MatchingTag_->TagListSeq();
        _ElementSeqList[Index_++] = MatchingTag_->TagAttrib();
        _ElementSeqList[Index_++] = MatchingTag_->TagCount();
        _ElementSeqList[Index_++] = MatchingTag_->TagNesting();
        _SeqListIndex++;
        _SeqIndexIncr++;
      
        if (_SeqListIndex >= DataCnt_)
        {
          GrowElementSeqList();
          TotalSz_ = _ElementSeqList[TOTALSIZE_OFFSET];
          DataCnt_ = _ElementSeqList[DATACOUNT_OFFSET];
        }
      
        Index_ = LsDataSz_ + (SEQLISTGROUP_SIZE * _SeqListIndex);
      }
    }

    // The tag pair nesting value whether incrementing or decrementing
    // will be recorded from the starting tag sequence only
    if (Index_ + HighElm_ < TotalSz_)
    {
      _ElementSeqList[Index_++] = Element_->TagListSeq();
      _ElementSeqList[Index_++] = Element_->TagAttrib();
      _ElementSeqList[Index_++] = Element_->TagCount();
      _ElementSeqList[Index_++] = Element_->TagNesting();
      _SeqListIndex++;
      _SeqIndexIncr++;
    }
  }
}

/****************************************************************************/
TagElement* TagCountData::MakeMatchTag(TagElement* TagPtr_, bool& CreatedTag_) const
{
  size_t sz = 0;
  bool Found_ = false;
  bool Forbidden_ = TagPtr_ ? (TagPtr_->TagPosition() == TagEnums::FORBIDDEN):true;
  int PairEnder_ = TagPtr_ ? (TagPtr_->IsPairStartTag() ? 1:
                              TagPtr_->IsPairEndTag()   ? 0:-1):-1;
  int MatchIndex_ = TagPtr_ ? TagPtr_->TagMatchIndex():-1;
  int attr = (MatchIndex_ >= 0) ? _TagCntMatrix[MatchIndex_][TagEnums::TAGATTR]:-1;
  int TagPos_ = TagPtr_ ? ((TagPtr_->TagPosition() == TagEnums::CLOSING) ? TagEnums::OPENING:
                           (TagPtr_->TagPosition() == TagEnums::OPENING) ? TagEnums::CLOSING:-1):-1;
  TagElement* vptr = NULL;
  CreatedTag_ = false;

  if (MatchIndex_ >= 0 && PairEnder_ >= 0 && attr > 0 && TagPos_ >= 0 && !Forbidden_)
  {
    sz = PairEnder_ ? TagListSize(TagEnums::CLOSING):
                      TagListSize(TagEnums::OPENING);

    PtrEqual<TagElement> TagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementComparer::Instance()));

    SimpleNode<TagElement>* NodePtr_ = NULL;
    TagElement vobj(sz, attr, this, _TagCntMatrix[MatchIndex_], true);
      vobj.SetTagName(TagPtr_->TagName());
      vobj.SetTagPos(TagPos_);
      vobj.ResetRequiredTags();
    
    if (PairEnder_)
      Found_ = _EndTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);
    else
      Found_ = _StdTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);

    if (!TagPtr_->GiveMatchingTag())
    {
      CreatedTag_ = (!Found_ || !NodePtr_ || !NodePtr_->Value());
      vptr = CreatedTag_ ?
                  Clone(vobj):
                  NodePtr_->Value();

      if (vptr)
        TagPtr_->SetMatchingTag(vptr);
      else
        CreatedTag_ = false;
    }

    if (Found_ && NodePtr_ && NodePtr_->Value())
      vptr = NULL;
  }

  return vptr;
}

/****************************************************************************/
TagElement* TagCountData::SearchForTag(int TagPos_, bool Empty_, bool Container_,
                                       const char* StartTagBrk_, const ChrString& TagElement_,
                                       const char* EndTagBrk_, int& PairEnder_, bool Update_)
{
  size_t sz = 0;
  bool Found_ = false;
  bool OptSingle_ = false;
  bool TagEndAtEof_ = false;
  int Index_ = BrkStringToIndex(StartTagBrk_, EndTagBrk_, PairEnder_);
  int attr = (Index_ >= 0) ? _TagCntMatrix[Index_][TagEnums::TAGATTR]:-1;
  int AppAttr_ = attr;
  TagElement* vptr = NULL;
  bool CreatedTag_ = false;
  bool Updated_ = false;
  bool HtmlStyle_ = !_DocType ||
                    _DocType == TagEnums::HTML_FILE ||
                    _DocType == TagEnums::XHTML_FILE;
  bool AppAttrSpec_ = ((TagPos_ == TagEnums::FORBIDDEN ||
                        TagPos_ == TagEnums::OPENING) &&
                       ((AppAttr_ & TagEnums::SINGLETON_TAGATTR) ||
                        (AppAttr_ & TagEnums::EMPTY_TAGATTR)));

  if ((attr == TagEnums::TAG_SPECIFIC) || AppAttrSpec_)
  {
    PairEnder_ = 0;
    attr = (TagPos_ == TagEnums::OPENING)   ?
               (TagEnums::OPTIONALPAIR_TAGATTR |
                TagEnums::ALLOW_SINGLETON_TAG |
                TagEnums::ALLOW_EMPTY_TAG |
                TagEnums::TAG_SPECIFIC):
           (TagPos_ == TagEnums::CLOSING)   ?
                TagEnums::PAIR_ENDER:
           (TagPos_ == TagEnums::FORBIDDEN) ?
                TagEnums::SINGLETON_TAGATTR:-1;

    if (AppAttrSpec_)
      attr |= AppAttr_;

    if (Empty_ && attr == TagEnums::SINGLETON_TAGATTR)
    {
      if (_DocType == TagEnums::XML_FILE)
        attr = TagEnums::EMPTY_TAGATTR;
      else if (!_DocType ||
               _DocType == TagEnums::HTML_FILE ||
               _DocType == TagEnums::XHTML_FILE)
        attr |= TagEnums::EMPTY_TAGATTR;
    }
    else if (!Empty_ && Container_ &&
                 ((attr & TagEnums::OPTIONALPAIR_TAGATTR) ||
                  (attr & TagEnums::PAIR_TAGATTR)))
      attr |= TagEnums::TAG_CONTAINER;
  }
  else if (attr == (TagEnums::PAIR_TAGATTR | TagEnums::TAG_CONTAINER) ||
           attr == TagEnums::PAIR_TAGATTR)
  {
    attr = (TagPos_ == TagEnums::OPENING)   ?
               TagEnums::PAIR_TAGATTR:
           (TagPos_ == TagEnums::CLOSING)   ?
               TagEnums::PAIR_ENDER:
           (TagPos_ == TagEnums::FORBIDDEN) ?
               TagEnums::SINGLETON_TAGATTR:-1;

    if (!Empty_ && Container_)
      attr |= TagEnums::TAG_CONTAINER;
  }
  else if ((PairEnder_ && attr > 0) ||
           (attr == TagEnums::PAIR_ENDER))
    attr = TagEnums::PAIR_ENDER;

  if (Index_ >= 0 && attr > 0)
  {
    OptSingle_ = ((attr & TagEnums::OPTIONALPAIR_TAGATTR) &&
                  (attr & TagEnums::ALLOW_SINGLETON_TAG)) ||
                 (attr & TagEnums::SINGLETON_TAGATTR);
    TagEndAtEof_ = HtmlStyle_ &&
                   ((attr & TagEnums::OPTIONALPAIR_TAGATTR) &&
                    (attr & TagEnums::ALLOW_SINGLETON_TAG));

    if (TagEndAtEof_)
    {
      bool DblOptTag_ =
        IsElementTagStr("<", ChrString("HTML"), ">",
                        StartTagBrk_, TagElement_, EndTagBrk_);

      if (!DblOptTag_)
      {
        DblOptTag_ =
          IsElementTagStr("<", ChrString("HEAD"), ">",
                          StartTagBrk_, TagElement_, EndTagBrk_);

        if (!DblOptTag_)
        {
          DblOptTag_ =
            IsElementTagStr("<", ChrString("BODY"), ">",
                            StartTagBrk_, TagElement_, EndTagBrk_);

          if (!DblOptTag_)
            TagEndAtEof_ = false;
        }
      }
    }

    PtrEqual<TagElement> TagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementComparer::Instance()));
    PtrEqual<TagElement> MatchTagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementMatchTagComparer::Instance()));

    SimpleNode<TagElement>* NodePtr_ = NULL;
    TagElement vobj(-1, attr, this, _TagCntMatrix[Index_], true);
      vobj.SetTagName(TagElement_);
      vobj.SetTagPos(TagPos_);
      vobj.SetRequiredCond(0, TagEndAtEof_ ? TagEnums::AT_EOF:
                              OptSingle_ ? TagEnums::AT_NEXTTAG:0);

    if (vobj.IsPairStartTag() || vobj.IsPairEndTag())
      MakeMatchTag(&vobj, CreatedTag_);

    if (PairEnder_)
      Found_ = _StdTagList->HasThis(&vobj, &MatchTagEqFnc_, &NodePtr_);
    else
      Found_ = _StdTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);

    if (Found_ && NodePtr_)
    {
      vptr = NodePtr_->Value();
      
      if (Update_ && vptr)
        if (vptr->UpdateTagElement(vobj))
          return vptr;
        else
          return NULL;
    }
    else
      vptr = NULL;

    if (CreatedTag_)
      vobj.DestroyMatchingTag();
  }

  return vptr;
}

/****************************************************************************/
// Appended attributes contained in AppAttr_ can be:
//   TagEnums::TAG_SPECIFIC
//   TagEnums::SINGLETON_TAGATTR
//   TagEnums::EMPTY_TAGATTR
//   TagEnums::PAIR_TAGATTR
//   TagEnums::PAIR_ENDER
//
//   or
//
//   0 for none specified
//
TagElement* TagCountData::AddToTagList(int TagPos_, bool Empty_, bool Container_, int AppAttr_,
                                       const char* StartTagBrk_, const ChrString& TagElement_,
                                       const char* EndTagBrk_, TagElement* MatchingTag_)
{
  size_t sz = 0;
  bool Found_ = false;
  bool OptSingle_ = false;
  bool TagEndAtEof_ = false;
  int PairEnder_ = 0;
  int Index_ = BrkStringToIndex(StartTagBrk_, EndTagBrk_, PairEnder_);
  int attr = (Index_ >= 0) ? _TagCntMatrix[Index_][TagEnums::TAGATTR]:-1;
  TagElement* vptr = NULL;
  bool HtmlStyle_ = !_DocType ||
                    _DocType == TagEnums::HTML_FILE ||
                    _DocType == TagEnums::XHTML_FILE;
  bool AppAttrSpec_ = ((TagPos_ == TagEnums::FORBIDDEN ||
                        TagPos_ == TagEnums::OPENING) &&
                       ((AppAttr_ & TagEnums::SINGLETON_TAGATTR) ||
                        (AppAttr_ & TagEnums::EMPTY_TAGATTR)));

  if ((!AppAttr_ && (attr & TagEnums::TAG_SPECIFIC)) ||
      (AppAttr_ & TagEnums::TAG_SPECIFIC) || AppAttrSpec_)
  {
    PairEnder_ = 0;
    attr = (TagPos_ == TagEnums::OPENING)   ?
               (TagEnums::OPTIONALPAIR_TAGATTR |
                TagEnums::ALLOW_SINGLETON_TAG |
                TagEnums::ALLOW_EMPTY_TAG |
                TagEnums::TAG_SPECIFIC):
           (TagPos_ == TagEnums::CLOSING)   ?
                TagEnums::PAIR_ENDER:
           (TagPos_ == TagEnums::FORBIDDEN) ?
                TagEnums::SINGLETON_TAGATTR:-1;

    if (AppAttrSpec_)
      attr |= AppAttr_;

    if (Empty_ && attr == TagEnums::SINGLETON_TAGATTR)
    {
      if (_DocType == TagEnums::XML_FILE)
        attr = TagEnums::EMPTY_TAGATTR;
      else if (!_DocType ||
               _DocType == TagEnums::HTML_FILE ||
               _DocType == TagEnums::XHTML_FILE)
        attr |= TagEnums::EMPTY_TAGATTR;
    }
    else if (!Empty_ && Container_ &&
                 ((attr & TagEnums::OPTIONALPAIR_TAGATTR) ||
                  (attr & TagEnums::PAIR_TAGATTR)))
      attr |= TagEnums::TAG_CONTAINER;
  }
  else if ((!AppAttr_ &&
            (attr == (TagEnums::PAIR_TAGATTR | TagEnums::TAG_CONTAINER) ||
             attr == TagEnums::PAIR_TAGATTR)) ||
           AppAttr_ == (TagEnums::PAIR_TAGATTR | TagEnums::TAG_CONTAINER) ||
           AppAttr_ == TagEnums::PAIR_TAGATTR)
  {
    attr = (TagPos_ == TagEnums::OPENING)   ?
               TagEnums::PAIR_TAGATTR:
           (TagPos_ == TagEnums::CLOSING)   ?
               TagEnums::PAIR_ENDER:
           (TagPos_ == TagEnums::FORBIDDEN) ?
               TagEnums::SINGLETON_TAGATTR:-1;

    if (!Empty_ && Container_)
      attr |= TagEnums::TAG_CONTAINER;
  }
  else if ((!AppAttr_ && PairEnder_ && attr > 0) ||
           (AppAttr_ == TagEnums::PAIR_ENDER))
    attr = TagEnums::PAIR_ENDER;

  if (Index_ >= 0 && attr > 0)
  {
    OptSingle_ = ((attr & TagEnums::OPTIONALPAIR_TAGATTR) &&
                  (attr & TagEnums::ALLOW_SINGLETON_TAG)) ||
                 (attr & TagEnums::SINGLETON_TAGATTR);
    TagEndAtEof_ = HtmlStyle_ &&
                   ((attr & TagEnums::OPTIONALPAIR_TAGATTR) &&
                    (attr & TagEnums::ALLOW_SINGLETON_TAG));

    if (TagEndAtEof_)
    {
      bool DblOptTag_ =
        IsElementTagStr("<", ChrString("HTML"), ">",
                        StartTagBrk_, TagElement_, EndTagBrk_);

      if (!DblOptTag_)
      {
        DblOptTag_ =
          IsElementTagStr("<", ChrString("HEAD"), ">",
                          StartTagBrk_, TagElement_, EndTagBrk_);

        if (!DblOptTag_)
        {
          DblOptTag_ =
            IsElementTagStr("<", ChrString("BODY"), ">",
                            StartTagBrk_, TagElement_, EndTagBrk_);

          if (!DblOptTag_)
            TagEndAtEof_ = false;
        }
      }
    }

    sz = PairEnder_ ? TagListSize(TagEnums::CLOSING):
                      TagListSize(TagEnums::OPENING);

    PtrEqual<TagElement> TagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementComparer::Instance()));
    PtrEqual<TagElement> MatchTagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementMatchTagComparer::Instance()));

    SimpleNode<TagElement>* NodePtr_ = NULL;
    TagElement vobj(-1, attr, this, _TagCntMatrix[Index_], true);
      vobj.SetTagName(TagElement_);
      vobj.SetTagPos(TagPos_);
      vobj.SetRequiredCond(0, TagEndAtEof_ ? TagEnums::AT_EOF:
                              OptSingle_ ? TagEnums::AT_NEXTTAG:0);

    if (PairEnder_)
      Found_ = _StdTagList->HasThis(&vobj, &MatchTagEqFnc_, &NodePtr_);
    else
      Found_ = _StdTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);

    if (!Found_ || !NodePtr_ || !NodePtr_->Value())
    {
      vobj.SetTagListSeq(sz);
      vptr = Clone(vobj);

      if (vptr)
      {
        vptr->SetMatchingTag(MatchingTag_);
      
        if (PairEnder_)
        {
          #if TAGELEMENT_DEBUG1
            printf("EndTag[%d]: TagCountData::AddToTagList vptr = %p\n", _EndTagList->Size(), vptr);
          #endif

          _EndTagList->AppendHead(vptr);
          if (MatchingTag_)
          {
            #if TAGELEMENT_DEBUG1
              printf("StdTag[%d]: TagCountData::AddToTagList MatchingTag = %p\n", _StdTagList->Size(), MatchingTag_);
            #endif

            _StdTagList->AppendHead(MatchingTag_);
          }

        }
        else
        {
          #if TAGELEMENT_DEBUG1
            printf("StdTag[%d]: TagCountData::AddToTagList vptr = %p\n", _StdTagList->Size(), vptr);
          #endif

          _StdTagList->AppendHead(vptr);
          if (MatchingTag_)
          {
            #if TAGELEMENT_DEBUG1
              printf("EndTag[%d]: TagCountData::AddToTagList MatchingTag = %p\n", _EndTagList->Size(), MatchingTag_);
            #endif

            _EndTagList->AppendHead(MatchingTag_);
          }
        }
      }
    }
    else
      vptr = NULL;
  }

  if (vptr && PairEnder_ >= 0)
    UpdateSeqList(vptr, PairEnder_, false);

  return vptr;
}

/****************************************************************************/
TagElement* TagCountData::MakeMatchTag(TagElement* TagPtr_,
                                       bool SetMatchTag_, bool AddToList_)
{
  size_t sz = 0;
  bool Found_ = false;
  bool Forbidden_ = TagPtr_ ? (TagPtr_->TagPosition() == TagEnums::FORBIDDEN):true;
  int PairEnder_ = TagPtr_ ? (TagPtr_->IsPairStartTag() ? 1:
                              TagPtr_->IsPairEndTag()   ? 0:-1):-1;
  int MatchIndex_ = TagPtr_ ? TagPtr_->TagMatchIndex():-1;
  int attr = (MatchIndex_ >= 0) ? _TagCntMatrix[MatchIndex_][TagEnums::TAGATTR]:-1;
  int TagPos_ = TagPtr_ ? ((TagPtr_->TagPosition() == TagEnums::CLOSING) ? TagEnums::OPENING:
                           (TagPtr_->TagPosition() == TagEnums::OPENING) ? TagEnums::CLOSING:-1):-1;
  TagElement* vptr = NULL;

  if (MatchIndex_ >= 0 && PairEnder_ >= 0 && attr > 0 && TagPos_ >= 0 && !Forbidden_)
  {
    sz = PairEnder_ ? TagListSize(TagEnums::CLOSING):
                      TagListSize(TagEnums::OPENING);

    PtrEqual<TagElement> TagEqFnc_(MatchUsingUserDefinedFunctor<TagElement>::Trait(TagElementComparer::Instance()));

    SimpleNode<TagElement>* NodePtr_ = NULL;
    TagElement vobj(sz, attr, this, _TagCntMatrix[MatchIndex_], true);
      vobj.SetTagName(TagPtr_->TagName());
      vobj.SetTagPos(TagPos_);
      vobj.ResetRequiredTags();
    
    if (PairEnder_)
      Found_ = _EndTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);
    else
      Found_ = _StdTagList->HasThis(&vobj, &TagEqFnc_, &NodePtr_);

    if (!TagPtr_->GiveMatchingTag())
    {
      vptr = (!Found_ || !NodePtr_ || !NodePtr_->Value()) ?
                  Clone(vobj):
                  NodePtr_->Value();

      if (vptr && SetMatchTag_)
        TagPtr_->SetMatchingTag(vptr);
    }

    if (!Found_ || !NodePtr_ || !NodePtr_->Value())
    {
      if (!vptr && AddToList_)
        vptr = TagPtr_->GiveMatchingTag() ?
                   TagPtr_->GiveMatchingTag():
                   Clone(vobj);

      if (vptr && AddToList_)
        if (PairEnder_)
        {
          #if TAGELEMENT_DEBUG1
            printf("EndTag[%d]: TagCountData::MakeMatchTag vptr = %p\n", _EndTagList->Size(), vptr);
          #endif

          _EndTagList->AppendHead(vptr);
        }
        else
        {
          #if TAGELEMENT_DEBUG1
            printf("StdTag[%d]: TagCountData::MakeMatchTag vptr = %p\n", _StdTagList->Size(), vptr);
          #endif

          _StdTagList->AppendHead(vptr);
        }
    }
    else
      vptr = NULL;
  }

  if (vptr && PairEnder_ >= 0)
    UpdateSeqList(vptr, PairEnder_, false);

  return vptr;
}

/****************************************************************************/
TagElement* TagCountData::ResetRequiredTags(TagElement* TagPtr_)
{
  if (TagPtr_)
  {
    TagPtr_->ResetRequiredTags();
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetHtmlContentTagType(TagElement* TagPtr_, int ContentType_)
{
  if (TagPtr_)
  {
    TagPtr_->SetHtmlContentTagType(ContentType_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetRequiredCond(TagElement* TagPtr_,
                                          int ReqTagOrder_, int ImpliedEnd_,
                                          int TagCond_, int ImpliedEndCond_)
{
  if (TagPtr_)
  {
    TagPtr_->SetRequiredCond(ReqTagOrder_, ImpliedEnd_,
                             TagCond_, ImpliedEndCond_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::AddRequiredTag(TagElement* TagPtr_, TagElement* ReqTag_,
                                         int ReqTagOrder_, bool MatchingEnd_)
{
  if (TagPtr_)
  {
    TagPtr_->AddRequiredTag(ReqTag_, ReqTagOrder_, MatchingEnd_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetRequiredTags(TagElement* TagPtr_, TagElement** Vect_,
                                          int ReqTagOrder_, bool MatchingEnd_)
{
  if (TagPtr_)
  {
    TagPtr_->SetRequiredTags(Vect_, ReqTagOrder_, MatchingEnd_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetPairEnderTag(TagElement* TagPtr_, bool PairEnder_)
{
  if (TagPtr_)
  {
    TagPtr_->SetPairEnderTag(PairEnder_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetSingletonAllowed(TagElement* TagPtr_, bool Set_)
{
  if (TagPtr_)
  {
    TagPtr_->SetSingletonAllowed(Set_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetEmptyAllowed(TagElement* TagPtr_, bool Set_)
{
  if (TagPtr_)
  {
    TagPtr_->SetEmptyAllowed(Set_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetSingletonTag(TagElement* TagPtr_, bool Single_)
{
  if (TagPtr_)
  {
    TagPtr_->SetSingletonTag(Single_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetEmptyTag(TagElement* TagPtr_, bool Empty_)
{
  if (TagPtr_)
  {
    TagPtr_->SetEmptyTag(Empty_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::SetContainerTag(TagElement* TagPtr_, bool Contain_)
{
  if (TagPtr_)
  {
    TagPtr_->SetContainerTag(Contain_);
    return TagPtr_;
  }

  return NULL;
}

/****************************************************************************/
TagElement* TagCountData::UpdateTag(int TagPos_, bool Empty_, bool Container_,
                                    const char* StartTagBrk_, const ChrString& TagElement_,
                                    const char* EndTagBrk_)
{
  int PairEnder_ = 0;
  TagElement* vptr = SearchForTag(TagPos_, Empty_, Container_, StartTagBrk_,
                                  TagElement_, EndTagBrk_, PairEnder_, true);

  if (vptr)
    UpdateSeqList(vptr, PairEnder_, true);

  return vptr;
}

/****************************************************************************/
TagElement* TagCountData::SearchForTag(int TagPos_, bool Empty_, bool Container_,
                                       const char* StartTagBrk_, const ChrString& TagElement_,
                                       const char* EndTagBrk_)
{
  int PairEnder_ = 0;
  return SearchForTag(TagPos_, Empty_, Container_, StartTagBrk_,
                      TagElement_, EndTagBrk_, PairEnder_, false);
}

/****************************************************************************/
void TagCountData::ResetHtmlTags()
{
  int x = TagEnums::VALIDITY;
  int y = TagEnums::VALIDITYSTATE;

  // Standard HTML document tags are active
  _DocTypeOpen_Cnt[x] = ACTIVE;
  _DocTypeClose_Cnt[x] = ACTIVE;
  _DocTypeOpen_Cnt[y] = ACTIVE;
  _DocTypeClose_Cnt[y] = ACTIVE;

  _CommentOpen_Cnt[x] = ACTIVE;
  _CommentClose_Cnt[x] = ACTIVE;
  _CommentOpen_Cnt[y] = ACTIVE;
  _CommentClose_Cnt[y] = ACTIVE;
      
  _NestedComment1Open_Cnt[x] = ACTIVE;
  _NestedComment1Close_Cnt[x] = ACTIVE;
  _NestedComment1Open_Cnt[y] = ACTIVE;
  _NestedComment1Close_Cnt[y] = ACTIVE;
      
  _NestedComment2Open_Cnt[x] = ACTIVE;
  _NestedComment2Close_Cnt[x] = ACTIVE;
  _NestedComment2Open_Cnt[y] = ACTIVE;
  _NestedComment2Close_Cnt[y] = ACTIVE;

  _StdTagOpen_Cnt[x] = ACTIVE;
  _StdTagClose_Cnt[x] = ACTIVE;
  _StdTagOpen_Cnt[y] = ACTIVE;
  _StdTagClose_Cnt[y] = ACTIVE;
    
  _EndTagOpen_Cnt[x] = ACTIVE;
  _EndTagClose_Cnt[x] = ACTIVE;
  _EndTagOpen_Cnt[y] = ACTIVE;
  _EndTagClose_Cnt[y] = ACTIVE;

  _EmptyOpen_Cnt[x] = ACTIVE;
  _EmptyClose_Cnt[x] = ACTIVE;
  _EmptyOpen_Cnt[y] = ACTIVE;
  _EmptyClose_Cnt[y] = ACTIVE;
      
  _ScriptOpen_Cnt[x] = ACTIVE;
  _ScriptClose_Cnt[x] = ACTIVE;
  _ScriptOpen_Cnt[y] = ACTIVE;
  _ScriptClose_Cnt[y] = ACTIVE;

  // Language tags are ignored
  _CCommentBlkOpen_Cnt[x] = IGNORED;
  _CCommentBlkClose_Cnt[x] = IGNORED;
  _CCommentBlkOpen_Cnt[y] = IGNORED;
  _CCommentBlkClose_Cnt[y] = IGNORED;

  _COpenCommentBlkOpen_Cnt[x] = IGNORED;
  _COpenCommentBlkClose_Cnt[x] = IGNORED;
  _COpenCommentBlkOpen_Cnt[y] = IGNORED;
  _COpenCommentBlkClose_Cnt[y] = IGNORED;

  _CCloseCommentBlkOpen_Cnt[x] = IGNORED;
  _CCloseCommentBlkClose_Cnt[x] = IGNORED;
  _CCloseCommentBlkOpen_Cnt[y] = IGNORED;
  _CCloseCommentBlkClose_Cnt[y] = IGNORED;
    
  _CppCommentLineOpen_Cnt[x] = IGNORED;
  _CppCommentLineClose_Cnt[x] = IGNORED;
  _CppCommentLineOpen_Cnt[y] = IGNORED;
  _CppCommentLineClose_Cnt[y] = IGNORED;
}

/****************************************************************************/
void TagCountData::ResetXmlTags()
{
  int x = TagEnums::VALIDITY;
  int y = TagEnums::VALIDITYSTATE;

  // Document type tags are ignored
  _DocTypeOpen_Cnt[x] = ACTIVE;
  _DocTypeClose_Cnt[x] = ACTIVE;
  _DocTypeOpen_Cnt[y] = ACTIVE;
  _DocTypeClose_Cnt[y] = ACTIVE;

  // Standard XML document tags are active  
  _StdTagOpen_Cnt[x] = ACTIVE;
  _StdTagClose_Cnt[x] = ACTIVE;
  _StdTagOpen_Cnt[y] = ACTIVE;
  _StdTagClose_Cnt[y] = ACTIVE;
    
  _EndTagOpen_Cnt[x] = ACTIVE;
  _EndTagClose_Cnt[x] = ACTIVE;
  _EndTagOpen_Cnt[y] = ACTIVE;
  _EndTagClose_Cnt[y] = ACTIVE;

  _EmptyOpen_Cnt[x] = ACTIVE;
  _EmptyClose_Cnt[x] = ACTIVE;
  _EmptyOpen_Cnt[y] = ACTIVE;
  _EmptyClose_Cnt[y] = ACTIVE;

  // Comment tags are ignored
  _CommentOpen_Cnt[x] = IGNORED;
  _CommentClose_Cnt[x] = IGNORED;
  _CommentOpen_Cnt[y] = IGNORED;
  _CommentClose_Cnt[y] = IGNORED;
      
  _NestedComment1Open_Cnt[x] = IGNORED;
  _NestedComment1Close_Cnt[x] = IGNORED;
  _NestedComment1Open_Cnt[y] = IGNORED;
  _NestedComment1Close_Cnt[y] = IGNORED;
      
  _NestedComment2Open_Cnt[x] = IGNORED;
  _NestedComment2Close_Cnt[x] = IGNORED;
  _NestedComment2Open_Cnt[y] = IGNORED;
  _NestedComment2Close_Cnt[y] = IGNORED;

  // Script tags are active
  _ScriptOpen_Cnt[x] = ACTIVE;
  _ScriptClose_Cnt[x] = ACTIVE;
  _ScriptOpen_Cnt[y] = ACTIVE;
  _ScriptClose_Cnt[y] = ACTIVE;

  // Language tags are ignored
  _CCommentBlkOpen_Cnt[x] = IGNORED;
  _CCommentBlkClose_Cnt[x] = IGNORED;
  _CCommentBlkOpen_Cnt[y] = IGNORED;
  _CCommentBlkClose_Cnt[y] = IGNORED;

  _COpenCommentBlkOpen_Cnt[x] = IGNORED;
  _COpenCommentBlkClose_Cnt[x] = IGNORED;
  _COpenCommentBlkOpen_Cnt[y] = IGNORED;
  _COpenCommentBlkClose_Cnt[y] = IGNORED;

  _CCloseCommentBlkOpen_Cnt[x] = IGNORED;
  _CCloseCommentBlkClose_Cnt[x] = IGNORED;
  _CCloseCommentBlkOpen_Cnt[y] = IGNORED;
  _CCloseCommentBlkClose_Cnt[y] = IGNORED;
    
  _CppCommentLineOpen_Cnt[x] = IGNORED;
  _CppCommentLineClose_Cnt[x] = IGNORED;
  _CppCommentLineOpen_Cnt[y] = IGNORED;
  _CppCommentLineClose_Cnt[y] = IGNORED;
}

/****************************************************************************/
void TagCountData::ResetCppTags()
{
  int x = TagEnums::VALIDITY;
  int y = TagEnums::VALIDITYSTATE;

  // Document type tags are ignored
  _DocTypeOpen_Cnt[x] = IGNORED;
  _DocTypeClose_Cnt[x] = IGNORED;
  _DocTypeOpen_Cnt[y] = IGNORED;
  _DocTypeClose_Cnt[y] = IGNORED;

  // Standard XML document tags are ignored
  _StdTagOpen_Cnt[x] = IGNORED;
  _StdTagClose_Cnt[x] = IGNORED;
  _StdTagOpen_Cnt[y] = IGNORED;
  _StdTagClose_Cnt[y] = IGNORED;
    
  _EndTagOpen_Cnt[x] = IGNORED;
  _EndTagClose_Cnt[x] = IGNORED;
  _EndTagOpen_Cnt[y] = IGNORED;
  _EndTagClose_Cnt[y] = IGNORED;

  _EmptyOpen_Cnt[x] = IGNORED;
  _EmptyClose_Cnt[x] = IGNORED;
  _EmptyOpen_Cnt[y] = IGNORED;
  _EmptyClose_Cnt[y] = IGNORED;

  // Comment tags are ignored
  _CommentOpen_Cnt[x] = IGNORED;
  _CommentClose_Cnt[x] = IGNORED;
  _CommentOpen_Cnt[y] = IGNORED;
  _CommentClose_Cnt[y] = IGNORED;
      
  _NestedComment1Open_Cnt[x] = IGNORED;
  _NestedComment1Close_Cnt[x] = IGNORED;
  _NestedComment1Open_Cnt[y] = IGNORED;
  _NestedComment1Close_Cnt[y] = IGNORED;
      
  _NestedComment2Open_Cnt[x] = IGNORED;
  _NestedComment2Close_Cnt[x] = IGNORED;
  _NestedComment2Open_Cnt[y] = IGNORED;
  _NestedComment2Close_Cnt[y] = IGNORED;

  // Script tags are ignored
  _ScriptOpen_Cnt[x] = IGNORED;
  _ScriptClose_Cnt[x] = IGNORED;
  _ScriptOpen_Cnt[y] = IGNORED;
  _ScriptClose_Cnt[y] = IGNORED;

  // C/C++ languange tags are active
  _CCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCommentBlkClose_Cnt[x] = ACTIVE;
  _CCommentBlkOpen_Cnt[y] = ACTIVE;
  _CCommentBlkClose_Cnt[y] = ACTIVE;

  _COpenCommentBlkOpen_Cnt[x] = ACTIVE;
  _COpenCommentBlkClose_Cnt[x] = ACTIVE;
  _COpenCommentBlkOpen_Cnt[y] = ACTIVE;
  _COpenCommentBlkClose_Cnt[y] = ACTIVE;

  _CCloseCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[x] = ACTIVE;
  _CCloseCommentBlkOpen_Cnt[y] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[y] = ACTIVE;
    
  _CppCommentLineOpen_Cnt[x] = ACTIVE;
  _CppCommentLineClose_Cnt[x] = ACTIVE;
  _CppCommentLineOpen_Cnt[y] = ACTIVE;
  _CppCommentLineClose_Cnt[y] = ACTIVE;
}

/****************************************************************************/
void TagCountData::ResetCTags()
{
  int x = TagEnums::VALIDITY;
  int y = TagEnums::VALIDITYSTATE;

  // Document type tags are ignored
  _DocTypeOpen_Cnt[x] = IGNORED;
  _DocTypeClose_Cnt[x] = IGNORED;
  _DocTypeOpen_Cnt[y] = IGNORED;
  _DocTypeClose_Cnt[y] = IGNORED;

  // Standard XML document tags are ignored
  _StdTagOpen_Cnt[x] = IGNORED;
  _StdTagClose_Cnt[x] = IGNORED;
  _StdTagOpen_Cnt[y] = IGNORED;
  _StdTagClose_Cnt[y] = IGNORED;

  _EndTagOpen_Cnt[x] = IGNORED;
  _EndTagClose_Cnt[x] = IGNORED;
  _EndTagOpen_Cnt[y] = IGNORED;
  _EndTagClose_Cnt[y] = IGNORED;

  _EmptyOpen_Cnt[x] = IGNORED;
  _EmptyClose_Cnt[x] = IGNORED;
  _EmptyOpen_Cnt[y] = IGNORED;
  _EmptyClose_Cnt[y] = IGNORED;

  // Comment tags are ignored
  _CommentOpen_Cnt[x] = IGNORED;
  _CommentClose_Cnt[x] = IGNORED;
  _CommentOpen_Cnt[y] = IGNORED;
  _CommentClose_Cnt[y] = IGNORED;
      
  _NestedComment1Open_Cnt[x] = IGNORED;
  _NestedComment1Close_Cnt[x] = IGNORED;
  _NestedComment1Open_Cnt[y] = IGNORED;
  _NestedComment1Close_Cnt[y] = IGNORED;
      
  _NestedComment2Open_Cnt[x] = IGNORED;
  _NestedComment2Close_Cnt[x] = IGNORED;
  _NestedComment2Open_Cnt[y] = IGNORED;
  _NestedComment2Close_Cnt[y] = IGNORED;

  // Script tags are ignored
  _ScriptOpen_Cnt[x] = IGNORED;
  _ScriptClose_Cnt[x] = IGNORED;
  _ScriptOpen_Cnt[y] = IGNORED;
  _ScriptClose_Cnt[y] = IGNORED;

  // C languange tags are active
  _CCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCommentBlkClose_Cnt[x] = ACTIVE;
  _CCommentBlkOpen_Cnt[y] = ACTIVE;
  _CCommentBlkClose_Cnt[y] = ACTIVE;

  _COpenCommentBlkOpen_Cnt[x] = ACTIVE;
  _COpenCommentBlkClose_Cnt[x] = ACTIVE;
  _COpenCommentBlkOpen_Cnt[y] = ACTIVE;
  _COpenCommentBlkClose_Cnt[y] = ACTIVE;
    
  _CCloseCommentBlkOpen_Cnt[x] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[x] = ACTIVE;
  _CCloseCommentBlkOpen_Cnt[y] = ACTIVE;
  _CCloseCommentBlkClose_Cnt[y] = ACTIVE;

  // C++ language tags are ignored
  _CppCommentLineOpen_Cnt[x] = IGNORED;
  _CppCommentLineClose_Cnt[x] = IGNORED;
  _CppCommentLineOpen_Cnt[y] = IGNORED;
  _CppCommentLineClose_Cnt[y] = IGNORED;
}

/****************************************************************************/
const int* TagCountData::GiveCurrentSeqListNode(int* IndexPtr_) const
{
  if (!_SeqListIndex)
    return NULL;

  int Index_ = 0;
  int LsDataSz_ = LISTSIZEDATA_SIZE;
  int TotalSz_ = _ElementSeqList[TOTALSIZE_OFFSET];
  int DataCnt_ = _ElementSeqList[DATACOUNT_OFFSET];

  if (_TagDataUpdated && _SeqListUpdateIndex > 0)
    Index_ = _SeqListUpdateIndex;
  else
    Index_ = LsDataSz_ +
             (SEQLISTGROUP_SIZE * (_SeqListIndex - _SeqIndexIncr));

  if (IndexPtr_)
    *IndexPtr_ = Index_;

  return &_ElementSeqList[Index_];
}

/****************************************************************************/
void TagCountData::DumpElementSeqListNode(ostream& os_, size_t fw_) const
{
  const int* Node_ = GiveCurrentSeqListNode();
  bool TagUpdated_ = TagDataUpdated();
  char Buffer_[256];

  if (_ElementSeqList)
  {
    os_ <<"******** Start : ElementSeqListNode Dump ********" <<endl;
    os_.width(fw_); os_ <<std::left <<"Seq. List Size: " <<_ElementSeqList[TOTALSIZE_OFFSET] <<endl;
    os_.width(fw_); os_ <<std::left <<"Seq. List Data Cnt: " <<_ElementSeqList[DATACOUNT_OFFSET] <<endl;

    if (_SeqIndexIncr >= 1 || TagUpdated_)
    {
      // os_ <<"SeqListNode[0]:" <<endl;
      os_.width(fw_); os_ <<std::left <<"Tag List Seq.: "
                          <<Node_[TAGLISTSEQ_OFFSET] <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Attributes: "
                          <<TagBracketList::TagAttributesToStr(Node_[TAGATTRIB_OFFSET], Buffer_)
                          <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Nesting: "
                          <<Node_[TAGNESTING_OFFSET] <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Count: "
                          <<Node_[TAGCOUNT_OFFSET] <<endl;
    }

    if (_SeqIndexIncr == 2 && !TagUpdated_)
    {
      // os_ <<"SeqListNode[1]:" <<endl;
      os_.width(fw_); os_ <<std::left <<"Tag List Seq.: "
                          <<Node_[TAGLISTSEQ_OFFSET] <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Attributes: "
                          <<TagBracketList::TagAttributesToStr(Node_[TAGATTRIB_OFFSET], Buffer_)
                          <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Nesting: "
                          <<Node_[TAGNESTING_OFFSET] <<endl;

      os_.width(fw_); os_ <<std::left <<"Tag Count: "
                          <<Node_[TAGCOUNT_OFFSET] <<endl;
    }

    os_ <<"******** End : ElementSeqListNode Dump ********" <<endl;
  }
}

/****************************************************************************/
MEMORYOPS_DEFN(TagCountData)

/****************************************************************************/
/****************************************************************************/
#if TAGELEMENT_DEBUG
int main()
{
// Sample html document segment
/*
<HTML>
<HEAD>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html">
<TITLE>Software Projects</TITLE>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="author" content="Joseph Wong">
<link rel="Prev"
      title="Cybernadian Computer Services" type="text/html"
      href="http://www.cybernadian.net/index.html">
</head>
<BODY bgcolor="#000080" text="#FFFF00" vlink="#FF0000">
<U><FONT SIZE=4>
<H1 ALIGN="CENTER">Software Projects</H1>
</FONT></U>
<FONT SIZE=4>
<p>
Here are some commercial and freeware software projects that I have completed.
Right click on the link and choose
&quot;Save As&quot; from your browser to download.
<br><br>
If you need an unzip utility to uncompress the following files you can get a free one from here:
<br>
<a href="http://www.7-zip.org/"><FONT COLOR="#00FF00">www.7-zip.org</FONT></a>
</p>
</font>
</body>
</html>
*/

  // Methods tested:
  //
  //   TagElement* AddToTagList(int TagPos_, bool Empty_, int AppAttr_,
  //                            const char* StartTagBrk_, const ChrString& TagElement_,
  //                            const char* EndTagBrk_, TagElement* MatchingTag_,
  //                            bool& Updated_);
  //   TagElement* MakeMatchTag(TagElement* StartTag_,
  //                            bool SetMatchTag_, bool AddToList_);
  //
  //   TagCountData& SetDocType(int DocType_);  
  //
  int x;
  TagElement* vptr = NULL;
  TagCountData* TagData_ = TagCountData::Instance();

  // Setting document type to html
  TagData_->SetDocType(TagEnums::HTML_FILE);

  // Adding html tag definitions
  // html tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true, 0,
                                "<", ChrString("HTML"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // html tag definition end

  // head tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true, 0,
                                "<", ChrString("HEAD"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // head tag definition end

  // link tag definition start
  vptr = TagData_->AddToTagList(TagEnums::FORBIDDEN, true, false, 0,
                                "<", ChrString("LINK"), ">", NULL);
  // link tag definition end

  // meta tag definition start
  vptr = TagData_->AddToTagList(TagEnums::FORBIDDEN, true, false, 0,
                                "<", ChrString("META"), ">", NULL);
  // meta tag definition start

  // title tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, false,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("TITLE"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // title tag definition end

  // body tag defintion start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true, 0,
                                "<", ChrString("BODY"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // body tag defintion end

  // a tag defintion start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("A"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // a tag defintion end

  // b tag defintion start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, false,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("B"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // b tag defintion end

  // br tag definition start
  vptr = TagData_->AddToTagList(TagEnums::FORBIDDEN, true, false, 0,
                                "<", ChrString("BR"), ">", NULL);
  // br tag definition end

  // u tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("U"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // u tag definition end

  // font tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("FONT"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // font tag definition end

  // H1 tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("H1"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // H1 tag definition end

  // p tag defintion start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true, 0,
                                "<", ChrString("P"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // p tag defintion end

  // applet tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("APPLET"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // applet tag definition end

  // big tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("BIG"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // big tag definition end

  // blockquote tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("BLOCKQUOTE"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // blockquot tag definition end
  
  // button tag definition start
  vptr = TagData_->AddToTagList(TagEnums::OPENING, false, true,
                                TagEnums::PAIR_TAGATTR,
                                "<", ChrString("BUTTON"), ">", NULL);

  if (vptr)
    TagData_->MakeMatchTag(vptr, true, true);
  // button tag definition end  

  // Methods tested:
  //
  //   TagElement* SearchForTag(int TagPos_, bool Empty_, const char* StartTagBrk_,
  //                            const ChrString& TagElement_, const char* EndTagBrk_,
  //                            int& PairEnder_, bool Update_) const;
  //
  //   int PushBrkNesting(const char* UpdateBrk_, const char* TxtFndBrk_, int Nest_);
  //   int PopBrkNesting(const char* UpdateBrk_, const char* TxtFndBrk_, int Nest_);
  //
  //   TagElement* UpdateTag(int TagPos_, bool Empty_, const char* StartTagBrk_,
  //                         const ChrString& TagElement_, const char* EndTagBrk_);
  //
  system("cls");

  // <HTML> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("HTML"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <HTML> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <HEAD> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("HEAD"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <HEAD> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <META> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("META"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <META> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <TITLE> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, false,
                             STDTAGOPEN_STR, ChrString("TITLE"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <TITLE> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // </TITLE> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, false,
                             ENDTAGOPEN_STR, ChrString("TITLE"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </TITLE> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // <META> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("META"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <META> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <META> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("META"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <META> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <LINK> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("LINK"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <LINK> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // </HEAD> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("HEAD"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </HEAD> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // <BODY> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("BODY"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <BODY> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <U> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("U"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <U> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <FONT> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("FONT"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <H1> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("H1"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <H1> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // </H1> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("H1"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </H1> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </FONT> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("FONT"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </U> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("U"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </U> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // <FONT> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("FONT"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <P> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("P"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <P> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <BR> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("BR"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <BR> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <BR> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("BR"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <BR> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <BR> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::FORBIDDEN, true, false,
                             STDTAGOPEN_STR, ChrString("BR"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <BR> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 1) <<endl <<endl;

  // <A> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("A"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <A> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // <FONT> found
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PushBrkNesting(STDTAGOPEN_STR, STDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::OPENING, false, true,
                             STDTAGOPEN_STR, ChrString("FONT"), STDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: <FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl;
  cout <<STDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, STDTAGCLOSE_STR, 0) <<endl <<endl;

  // </FONT> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("FONT"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </A> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("A"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </A> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </P> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("P"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </P> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </FONT> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("FONT"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </FONT> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </BODY> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("BODY"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </BODY> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // </HTML> found
  cout <<ENDTAGOPEN_STR <<" nesting: "
       <<TagData_->PopBrkNesting(STDTAGOPEN_STR, ENDTAGOPEN_STR, 1) <<endl;
  vptr = TagData_->UpdateTag(TagEnums::CLOSING, false, true,
                             ENDTAGOPEN_STR, ChrString("HTML"), ENDTAGCLOSE_STR);
  if (vptr)
    cout <<"tag: </HTML> found and updated:"
         <<" tagnest = " <<vptr->TagNesting() <<" : "
         <<" tagcount = " <<vptr->TagCount() <<endl <<endl;

  // Methods tested:
  //
  //   TagCountData& ResetTagIterIndex();
  //   bool SetTagIterIndex(int TagIndex_);
  //   bool AdvanceTagIter();
  //   TagElement* GetCurrentTagElement();
  //
  //   size_t TagListSize(int TagPos_) const;
  //   bool AtFirstTag() const;
  //   bool AtLastTag() const;
  //
  cout <<"Std TagList Size: " <<TagData_->TagListSize(TagEnums::OPENING) <<endl;
  cout <<"End TagList Size: " <<TagData_->TagListSize(TagEnums::CLOSING) <<endl;

  TagData_->SetTagIterIndex(10);
  if (!TagData_->AtFirstTag())
    TagData_->ResetTagIterIndex();
  
  for (;;)
  {
    vptr = TagData_->GetCurrentTagElement();
    x = vptr->TagBrkIndex();

    cout <<"Html Tag: "
         <<TagData_->GiveTagBrk(x) <<vptr->TagName()
         <<TagData_->GiveTagBrk(x+1) <<endl;

    if (vptr->GiveMatchingTag())
    {
      x = vptr->TagMatchIndex();
      vptr = vptr->GiveMatchingTag();
      
      cout <<"Matching Tag: "
           <<TagData_->GiveTagBrk(x) <<vptr->TagName()
           <<TagData_->GiveTagBrk(x+1) <<endl;
    }

    if (!TagData_->AtLastTag())
      TagData_->AdvanceTagIter();
    else
      break;
  }

  cout <<endl;
  TagData_->SetTagIterIndex(10);
  vptr = TagData_->GetCurrentTagElement();
  x = vptr->TagBrkIndex();
  
  cout <<"At Index 10: " <<endl;
  cout <<"  Html Tag: "
       <<TagData_->GiveTagBrk(x) <<vptr->TagName()
       <<TagData_->GiveTagBrk(x+1) <<endl;

  if (vptr->GiveMatchingTag())
  {
    x = vptr->TagMatchIndex();
    vptr = vptr->GiveMatchingTag();
      
    cout <<"  Matching Tag: "
         <<TagData_->GiveTagBrk(x) <<vptr->TagName()
         <<TagData_->GiveTagBrk(x+1) <<endl;
  }

  TagCountData::Release();

  // testing GiveTagType(const char*); method
  assert(
    TagBracketList::GiveTagType("<!DOCTYPE html PUBLIC-//W3C//DTD HTML 4.01//EN http://www.w3.org/TR/html4/strict.dtd>")
    == TagEnums::DOCTYPE_TAG);
  assert(
    TagBracketList::GiveTagType("<!-- This Is A Comment -->")
    == TagEnums::COMMENT_TAG);
  assert(
    TagBracketList::GiveTagType("<!--[if lt IE 7]>")
    == TagEnums::NESTEDCOMMENT1_TAG);
  assert(
    TagBracketList::GiveTagType("<![endif]-->")
    == TagEnums::NESTEDCOMMENT2_TAG);
  assert(
    TagBracketList::GiveTagType("<FONT SIZE=4>")
    == TagEnums::STD_TAG);
  assert(
    TagBracketList::GiveTagType("</FONT>")
    == TagEnums::END_TAG);
  assert(
    TagBracketList::GiveTagType("<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\"/>")
    == TagEnums::EMPTY_TAG);
  assert(
    TagBracketList::GiveTagType("<? phpinfo(); ?>")
    == TagEnums::SCRIPT_TAG);
  assert(
    TagBracketList::GiveTagType("/* C comment */")
    == TagEnums::CCOMMENTBLK_TAG);
  assert(
    TagBracketList::GiveTagType("/*[C comment, 2015-06-28, start: Notes:]->")
    == TagEnums::COPENCOMMENTBLK_TAG);
  assert(
    TagBracketList::GiveTagType("<-[C comment, 2015-06-28, end:]*/")
    == TagEnums::CCLOSECOMMENTBLK_TAG);
  assert(
    TagBracketList::GiveTagType("// Cpp comment, 2015-06-28, Notes: =>")
    == TagEnums::CPPCOMMENTLINE_TAG);

  // testing StripTagBrackets(const ChrString&, int); method
  assert(
    TagBracketList::StripTagBrackets("<!DOCTYPE html PUBLIC-//W3C//DTD HTML 4.01//EN http://www.w3.org/TR/html4/strict.dtd>",
                                     TagEnums::DOCTYPE_TAG)
    == ChrString("DOCTYPE html PUBLIC-//W3C//DTD HTML 4.01//EN http://www.w3.org/TR/html4/strict.dtd"));
  assert(
    TagBracketList::StripTagBrackets("<!-- This Is A Comment -->",
                                     TagEnums::COMMENT_TAG)
    == ChrString(" This Is A Comment "));
  assert(
    TagBracketList::StripTagBrackets("<!--[if lt IE 7]>",
                                     TagEnums::NESTEDCOMMENT1_TAG)
    == ChrString("if lt IE 7"));
  assert(
    TagBracketList::StripTagBrackets("<![endif]-->",
                                     TagEnums::NESTEDCOMMENT2_TAG)
    == ChrString("endif"));
  assert(
    TagBracketList::StripTagBrackets("<FONT SIZE=4>",
                                     TagEnums::STD_TAG)
    == ChrString("FONT SIZE=4"));
  assert(
    TagBracketList::StripTagBrackets("</FONT>",
                                     TagEnums::END_TAG)
    == ChrString("FONT"));
  assert(
    TagBracketList::StripTagBrackets("<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\"/>",
                                     TagEnums::EMPTY_TAG)
    == ChrString("img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\""));
  assert(
    TagBracketList::StripTagBrackets("<? phpinfo(); ?>",
                                     TagEnums::SCRIPT_TAG)
    == ChrString(" phpinfo(); "));
  assert(
    TagBracketList::StripTagBrackets("/* C comment */",
                                TagEnums::CCOMMENTBLK_TAG)
    == ChrString(" C comment "));
  assert(
    TagBracketList::StripTagBrackets("/*[C comment, 2015-06-28, start: Notes:]->",
                                     TagEnums::COPENCOMMENTBLK_TAG)
    == ChrString("C comment, 2015-06-28, start: Notes:"));
  assert(
    TagBracketList::StripTagBrackets("<-[C comment, 2015-06-28, end:]*/",
                                     TagEnums::CCLOSECOMMENTBLK_TAG)
    == ChrString("C comment, 2015-06-28, end:"));
  assert(
    TagBracketList::StripTagBrackets("// Cpp comment, 2015-06-28, Notes: =>",
                                     TagEnums::CPPCOMMENTLINE_TAG)
    == ChrString(" Cpp comment, 2015-06-28, Notes: "));

  return 0;
}
#endif
/****************************************************************************/
#endif

