#ifndef TAGINFO_H
#define TAGINFO_H

// valid for html, xhtml and xml tags
#define DOCTYPEOPEN_STR                 "<!"   // valid for html, xhtml docs
#define DOCTYPECLOSE_STR                ">"
#define COMMENTOPEN_STR                 "<!--" // valid for html, xhtml comments
#define COMMENTCLOSE_STR                "-->"
#define NESTEDCOMMENT1OPEN_STR          "<!--" // valid for html comments
#define NESTEDCOMMENT1CLOSE_STR         ">"
#define NESTEDCOMMENT2OPEN_STR          "<!"   // valid for html comments
#define NESTEDCOMMENT2CLOSE_STR         "-->"
#define STDTAGOPEN_STR                  "<"    // valid for html, xml, xhtml
#define STDTAGCLOSE_STR                 ">"
#define ENDTAGOPEN_STR                  "</"   // valid for html, xml, xhtml
#define ENDTAGCLOSE_STR                 ">"
#define EMPTYOPEN_STR                   "<"    // valid for html, xml, xhtml
#define EMPTYCLOSE_STR                  "/>"
#define SCRIPTOPEN_STR                  "<?"   // valid for html, xml, xhtml
#define SCRIPTCLOSE_STR                 "?>"

// nested html comment strings                  // nested comment start bracket, html
#define NESTEDCOMMENTSTART_STR          "<!--["

#define INTNESTEDCOMMENTEND_STR         "]>"    // nested comment, html
                                                // internal comment end bracket
#define INTNESTEDCOMMENTSTART_STR       "<!["   // nested comment, html
                                                // internal comment start bracket
                                                // nested comment end bracket, html
#define NESTEDCOMMENTEND_STR            "]-->"

// nested html comment characters
#define INTNESTEDCOMMENTOPEN_STR        "["     // nested comment, html
                                                // internal comment open indicator char
#define INTNESTEDCOMMENTCLOSE_STR       "]"     // nested comment, html
                                                // internal comment close indicator char

// nested C comment block strings               // nested comment start bracket, C comment block
#define CCOMMENTBLOCKSTART_STR          "/*["

#define INTCCOMMENTBLOCKEND_STR         "]->"   // nested comment, C comment block
                                                // internal comment end bracket
#define INTCCOMMENTBLOCKSTART_STR       "<-["   // nested comment, C comment block
                                                // internal comment start bracket
                                                // nested comment end bracket, C comment block
#define CCOMMENTBLOCKEND_STR            "]*/"

// nested C comment block characters
#define INTCCOMMENTBLOCKOPEN_STR        "["     // nested comment, C comment block
                                                // internal comment open indicator char
#define INTCCOMMENTBLOCKCLOSE_STR       "]"     // nested comment, C comment block
                                                // internal comment close indicator char

// valid only for C tags
#define COPENCOMMENTBLKOPEN_STR         "/*"
#define COPENCOMMENTBLKCLOSE_STR        "->"
#define CCLOSECOMMENTBLKOPEN_STR        "<-"
#define CCLOSECOMMENTBLKCLOSE_STR       "*/"

// Used to check for C comment endpoints only
// C comments are always enclosed in nested blocks
// following the above definitions: COPENCOMMENTBLK ... CCLOSECOMMENTBLK ...
#define CCOMMENTBLKOPEN_STR             "/*"
#define CCOMMENTBLKCLOSE_STR            "*/"

// valid only for Cpp tags
#define CPPCOMMENTLINEOPEN_STR          "//"
#define CPPCOMMENTLINECLOSE_STR         "=>"

/****************************************************************************/
struct TagEnums
{
  enum
  {
    // Tag attributes
    VALIDITY        = 0,    // active, inactive or ignored during search
    NESTING         = 1,    // nesting level of found tag
    TAGCOUNT        = 2,    // times tag was found in search string
    TAGATTR         = 3,    // tag attributes permission and status
    TAGINDEX        = 4,    // index into tag bracket list
    MATCHINDEX      = 5,    // index into brk list of matching tag in pair sequence
    TAGPOS          = 6,    // Tag position: opening, forbidden, closing
    LISTSEQ         = 7,    // list sequence number of tag element node object
    OPTREQTAGORDER  = 8,    // Required tag order for start+end optional tags
    IMPLIEDEND      = 9,    // Implied end of tag at specific condition met
    REQTAGCOND      = 10,   // Required tag for s+e optional tag found and condition met
    IMPLIEDENDCOND  = 11,   // Implied end state for tags with specific implied end conditions
    VALIDITYSTATE   = 12,   // Tag validity state correlating with 0th element valid tag
    HTMLCONTTAGTYPE = 13,   // Html content tag type for html tags
    MAX_FIELDS      = 14,

    // Tag positions
    CLOSING       = 0,     // Closing tag
    OPENING       = 1,     // Opening tag
    FORBIDDEN     = 2,     // Closing tag forbidden
    INDETERMINATE = 4,     // Indeterminate tag
    NO_TAGPOS     = 8,     // None specified

    // Tag Search Type
    GENERAL_SEARCH  = 1,
    SPECIFIC_SEARCH = 2,

    // Tag characters
    STDTAG_OPEN_CH         = '<', // Standard tag open character
    STDTAG_CLOSE_CH        = '>', // Standard tag close character
    NESTEDCOMMENT_OPEN_CH  = '[', // Nested comment open charactor indicator
    NESTEDCOMMENT_CLOSE_CH = ']', // Nested comment close charactor indicator
    CCOMMENTBLOCK_OPEN_CH  = '[', // C comment block open charactor indicator
    CCOMMENTBLOCK_CLOSE_CH = ']', // C comment block close charactor indicator

    // Tag errors
    PENDING                 = 4L,     // Pending tag discovery
    TAGVALID                = 8L,     // Tags found valid
    TAG_NOTFOUND            = 16L,    // Tags parsing error, tag not found
    ENDTAG_EXPECTED         = 32L,    // End tag expected tag error
    NESTEDCMNTTAG_EXPECTED  = 64L,    // Nested comment end tag expected tag error
    CCLOSECMNTTAG_EXPECTED  = 128L,   // Close C comment tag expected tag error
    EMPTYTAG_EXPECTED       = 256L,   // Empty tag expected tag error
    ENDTAG_FORBIDDEN        = 512L,   // End tag forbidden tag error
    NESTEDCMNTTAG_FORBIDDEN = 1024L,  // Nested comment end tag forbidden tag error
    CCLOSECMNTTAG_FORBIDDEN = 2048L,  // Close C comment tag forbidden tag error
    STDTAGENDPAIR_MISMATCH  = 4096L,  // Standard tag end pair mismatched tag error
    NESTEDCMNTTAG_MISMATCH  = 8192L,  // Nested comment end tag mismatched tag error
    CCLOSECMNTTAG_MISMATCH  = 16384L, // Close C comment tag mismatched tag error
    ENDBRK_MISSING          = 32768L, // End bracket of tag missing
    TAGPAIR_OVERLAP         = 65536L, // Tag pair overlapping start/end tags error
    SINGLETON_UNMATCHED     = 131072L,  // Singleton tag with unmatched end tag error
    SINGLETON_MATCHED       = 262144L,  // Singleton tag with matched end tag error
    HTML_TAG_MISPLACED      = 524288L,  // Misplaced html tag error
    HEAD_TAG_MISPLACED      = 1048576L, // Misplaced head tag error
    BODY_TAG_MISPLACED      = 2097152L, // Misplaced body tag error
    REQUIRED_TAG_NOT_FOUND  = 4194304L, // Required prerequisite tag not found
    POPAPPCONTSTR_CHKNODE   = 8388608L, // ChkNode in PopAppContStr method failed

    // Tag content errors
    TAGCONTENT_VALID        = 0L,
    TAGCONTENT_NOTINCLUDED  = 1L,
    TAGCONTENT_NESTINGERROR = 2L,

    // excluded tags in tagmatrix are:
    //   COMMENT, NESTEDCOMMENT1, NESTEDCOMMENT2, SCRIPT
    TAGLISTMATRIX_SIZE     = 7,

    // Tag array index positions
    DOCTYPE_DEX            = 0,  // +1 for ending tag of tag pair entry
    COMMENT_DEX            = 2,
    NESTEDCOMMENT1_DEX     = 4,
    NESTEDCOMMENT2_DEX     = 6,
    STD_DEX                = 8,
    END_DEX                = 10,
    EMPTY_DEX              = 12,
    SCRIPT_DEX             = 14,
    CCOMMENTBLK_DEX        = 16,
    COPENCOMMENTBLK_DEX    = 18,
    CCLOSECOMMENTBLK_DEX   = 20,
    CPPCOMMENTLINEOPEN_DEX = 22,

    // Tag types
    DOCTYPE_TAG            = 1,
    COMMENT_TAG            = 2,
    NESTEDCOMMENT1_TAG     = 4,
    NESTEDCOMMENT2_TAG     = 8,
    STD_TAG                = 16,
    END_TAG                = 32,
    EMPTY_TAG              = 64,
    SCRIPT_TAG             = 128,
    CCOMMENTBLK_TAG        = 256,
    COPENCOMMENTBLK_TAG    = 512,
    CCLOSECOMMENTBLK_TAG   = 1024,
    CPPCOMMENTLINE_TAG     = 2048,

    // Tag allow flag values
    ALLOW_NESTEDCOMMENT_TAG = 12,
    ALLOW_END_TAG           = 32,
    ALLOW_CCOMMENTBLK_TAG   = 256,

    // Retrieve tag contents flag values
    RETRIEVE_COMMENT_TAG        = 2,
    RETRIEVE_NESTEDCOMMENT_TAG  = 12,
    RETRIEVE_SCRIPT_TAG         = 128,
    RETRIEVE_CCOMMENTBLK_TAG    = 256,
    RETRIEVE_CPPCOMMENTLINE_TAG = 2048,
    RETRIEVE_END_TAG            = 4096,

    // Tag list length
    TAGLIST_LENGTH        = 32,  // 8 extra entries
    TAGLIST_MAX_ENTRIES   = 24,  // 12 start + 12 end pairs
    TAGTERM_MAX           = 12,  // 12 end tag terminators

    // Tag validity values
    IGNORED               = 0,   // or inapplicable
    ACTIVE                = 1,
    INACTIVE              = 2,

    // tag attributes permission and status
    SINGLETON_TAGATTR     = 1,
    EMPTY_TAGATTR         = 2,
    PAIR_TAGATTR          = 4,   // matches with pair ender
    OPTIONALPAIR_TAGATTR  = 8,
    ALLOW_SINGLETON_TAG   = 16,  // only set if optional pair
    ALLOW_EMPTY_TAG       = 32,  // only set if optional pair
    PAIR_ENDER            = 64,  // single tag to match tag pair
    TAG_CONTAINER         = 128, // specifies container type tag
    TAG_SPECIFIC          = 256, // specific to tag element

    // Required tag order for start+end optional tags
    NO_REQTAG             = 0,   // no required tag
    BEFORE_REQTAG         = 1,   // before required tag
    AFTER_REQTAG          = 2,   // after required tag
    SURROUND_REQTAG       = 4,   // both before and after required tags
    CURRENT_REQTAG        = 8,   // test for required current condition

    // Implied end of tag at specific condition met OR
    // End tag termination condition corresponding to tag pair or singleton
    NO_IMPLIEDEND         = 0,   // no implied end OR
    NO_MATCHINGTAG        = 0,   // no matching end
    AT_EOF                = 1,   // at end of file
    AT_BEFORE_REQTAG      = 2,   // at required BEFORE tag
    AT_NEXTTAG            = 4,   // at next encountered tag
    AT_IMPLIEDTAG         = 8,   // at optional implied end tag
    AT_MATCHENDTAG        = 16,  // at matching pair ender tag
    AT_CURRENTTAG         = 32,  // at current tag (singleton or empty)

    // Required tag for s+e optional tag found and condition met
    TAG_NOT_FOUND         = 0,   // tags (cur+req) not found
    REQTAG_FOUND          = 1,   // required tag found
    CURTAG_FOUND          = 2,   // current tag found
    REQTAG_COND_NOT_MET   = 4,   // required tag condition not met
    REQTAG_COND_MET       = 8,   // required tag condition met
    AFTREQTAG_FOUND       = 16,  // required AFTER tag found
    BEFREQTAG_FOUND       = 32,  // required BEFORE tag found
    TAG_COND_MET_NOREQ    = 64,  // tag condition met no required tag

    // Implied end state for tags with specific implied end conditions
    TNF_IMPLIEDEND_NOT_MET      = 0,  // searching for req. tags, implied end cond NOT met
    NFREQTAG_IMPLIEDEND_NOT_MET = 1,  // req. tags cond NOT met, implied end cond NOT met
    REQTAG_IMPLIEDEND_NOT_MET   = 2,  // req. tags cond met, implied end cond NOT met
    NFREQTAG_IMPLIEDEND_MET     = 4,  // req. tags cond NOT met, implied end cond met
    REQTAG_IMPLIEDEND_MET       = 8,  // req. tags cond met, implied end cond met
    REQTAG_NO_IMPLIEDEND        = 16, // req. tags cond met, no implied end cond specified

    // Html content tag type
    HTMLCONTENT_SPECIAL    = 1,
    HTMLCONTENT_HTML       = 2,
    HTMLCONTENT_HEAD       = 4,
    HTMLCONTENT_BODY       = 8,
    HTMLCONTENT_STDTAGPAIR = 16,

    // Tag document style types
    CSTYLE                = 1,
    CPPSTYLE              = 2,
    XMLSTYLE              = 4,
    HTMLSTYLE             = 8,

    // Document file types
    C_FILE                = 1,
    CPP_FILE              = 2,
    XML_FILE              = 4,
    HTML_FILE             = 8,
    XHTML_FILE            = 16,

    // TagReader scan modes
    TAGREAD               = 1,
    TAGCHECK              = 2,

    // Tag search parameters
    MATCH_TAGBRACKET      = 2048,    
    MATCH_TAGTYPE         = 4096,
    MATCH_TAGDELIMS       = 8192,
    MATCH_TAGENDBRACKET   = 16384,
    NO_TAGTYPE            = 32768,

    // Tag nesting conditons
    NO_NESTCOND           = 0,   // no nesting condition
    SGL_NESTCOND          = 91,  // singleton: <single>
    ST_NESTCOND           = 92,  // start: <pair>
    OPTST_NESTCOND        = 93,  // optional start: <opt-pair>
    NCTAG_NESTCOND        = 94,

    SGLSGL_NESTCOND       = 101, // singleton-singleton tags: <single>...<single>
    SGLST_NESTCOND        = 102, // singleton-start tags: <single>...<pair>
    SGLOPTST_NESTCOND     = 103, // singleton-optstart tags: <single>...<optpair>
    SGLMEND_NESTCOND      = 104, // singleton-matching-end tags: <single>...</single>
    SGLUMEND_NESTCOND     = 105, // singleton-unmatched-end tags: <single>...</pair>

    STSGL_NESTCOND        = 201, // start-singleton tags: <pair>...<single>
    STST_NESTCOND         = 202, // start-start tags: <pair>...<new-pair>
    STOPTST_NESTCOND      = 203, // start-optstart tags: <pair>...<new-optpair>
    STMEND_NESTCOND       = 204, // start-matching-end tags: <pair>...</pair>
    STUMEND_NESTCOND      = 205, // start-unmatched-end tags: <pair>...</new-pair>

    OPTSTSGL_NESTCOND     = 301, // optional start-singleton tags: <opt-pair>...<single>
    OPTSTST_NESTCOND      = 302, // optional start-start tags: <opt-pair>...<pair>
    OPTSTOPTST_NESTCOND   = 303, // optional start-optstart tags: <opt-pair>...<optpair>
    OPTSTMEND_NESTCOND    = 304, // optional start-matching-end tags: <opt-pair>...</opt-pair>
    OPTSTUMEND_NESTCOND   = 305, // optional start-unmatched-end tags: <opt-pair>...</pair>

    SGLENDUMEND_NESTCOND  = 401, // singleton-end-unmatched-end tags: </single>...</newpair> OR
                                 //                                   </single>...</single>
    SGLENDSGL_NESTCOND    = 402, // singleton-end-singleton tags: </single>...<single>
    SGLENDST_NESTCOND     = 403, // singleton-end-start tags: </single>...<pair>
    SGLENDOPTST_NESTCOND  = 404, // singleton-end-optpair tags: </single>...<optpair>

    PAIRENDUMEND_NESTCOND = 501, // pair-end-unmatched-end tags: </pair>...</newpair> OR
                                 //                              </pair>...</pair>
    PAIRENDSGL_NESTCOND   = 502, // pair-end-singleton tags: </pair>...<single>
    PAIRENDST_NESTCOND    = 503, // pair-end-start tags: </pair>...<pair>
    PAIRENDOPTST_NESTCOND = 504, // pair-end-optpair tags: </pair>...<optpair>

    OPTENDUMEND_NESTCOND  = 601, // optpair-end-unmatched-end tags: </optpair>...</newpair> OR
                                 //                                 </optpair>...</optpair>
    OPTENDSGL_NESTCOND    = 602, // optpair-end-singleton tags: </optpair>...<single>
    OPTENDST_NESTCOND     = 603, // optpair-end-start tags: </optpair>...<pair>
    OPTENDOPTST_NESTCOND  = 604, // optpair-end-optpair tags: </optpair>...<optpair>

    GROWINCR              = 10,
    LISTSIZEDATA_SIZE     = 2,
    SEQLISTGROUP_SIZE     = 4
  };
};

/* old enums
enum
{
    // Old tag data types
    ROWCOL_DATA           = 1,
    TAGPOS_DATA           = 2,
    CONTENT_DATA          = 4,
    TAGATTR_DATA          = 8,
    SEQNO_DATA            = 16,
    NESTINGNO_DATA        = 32,
    TAGTYPE_DATA          = 64,
    PARSE_FILE            = 128,
    PARSE_LINE            = 256,

    // Old search using data type
    USE_FUNCTIONARGS      = 100,
    USE_SETSTRINGTAGS     = 200,
    USE_TAGLIST           = 300,
};
*/

/****************************************************************************/
#endif
