#ifndef TAGREADER_CPP
#define TAGREADER_CPP
#ifndef TAGREADER_H
  #include "tagreader.h"
#endif

/****************************************************************************/
// TagStringData class definition
/****************************************************************************/
TagStringData::TagStringData(TagParseInfo* Ptr_, TagDictionary* Dict_,
                             TagStack* TstkPtr_, StackNodeInfo* StknPtr_):
_TagParse(Ptr_ ? (new TagParseInfo(*Ptr_)):
                 (new TagParseInfo(this))),
_TagCommentData((StknPtr_ && StknPtr_->HasCommentData()) ?
                             StknPtr_->GiveCommentData():NULL),
_KeyValueData((StknPtr_ && StknPtr_->HasKVPairData()) ?
                           StknPtr_->GiveKeyValuePairData():NULL),

_Dictionary(Dict_),
_StartTagBrkStr(NULL),
_EndTagBrkStr(NULL),
_ElementPtr(NULL),
_RefTagStk(TstkPtr_),
_RefStkNode(StknPtr_)
{
  int x;

  _HasTagContents =
  _HasIntraTagContents =
  _HasKvPairs =
  _InComment =
  _InScript =
  _SingletonTag =
  _DocTypeTag =
  _EndingTag = 0;

  Dict_ = _RefTagStk ? _RefTagStk->GiveTagDictionary():
          _TagParse ? _TagParse->GiveTagDictionary():NULL;

  if (_TagParse && _RefStkNode)
  {
    _TagParse->SetParent(this);
    _TagParse->SetTagDictionary(_Dictionary);
    _TagParse->SetKeyValuePairData(_KeyValueData);
    _TagParse->SetCommentData(_TagCommentData);

    x = _RefStkNode->TagBrkIndex();
    _StartTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                              NULL;
    x = _RefStkNode->EndBrkIndex();
    _EndTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                            NULL;

    _ElementPtr = _RefStkNode->GiveTagElementPtr();
    _TagString = _RefStkNode->GiveTagStr();

    _HasTagContents = _RefStkNode->HasTagContents();
    _HasIntraTagContents = _RefStkNode->HasIntraTagContents();
    _HasKvPairs = _RefStkNode->HasKVPairData();
    _HasCommentData = _RefStkNode->HasCommentData();
    _InComment = _RefStkNode->InComment();
    _InScript = _RefStkNode->InScript();
    _SingletonTag = _RefStkNode->IsSingleton();
    _DocTypeTag = _RefStkNode->IsDocTypeTag();
    _EndingTag = _RefStkNode->IsEndTag();
  }
}

/****************************************************************************/
TagStringData::TagStringData(const TagStringData& Obj_):
_TagParse(new TagParseInfo(this)),
_TagCommentData((Obj_._RefStkNode && Obj_._RefStkNode->HasCommentData()) ?
                                     Obj_._RefStkNode->GiveCommentData():NULL),
_KeyValueData((Obj_._HasKvPairs && Obj_._RefStkNode->HasKVPairData()) ?
                                   Obj_._RefStkNode->GiveKeyValuePairData():NULL),

_Dictionary(Obj_._Dictionary),
_StartTagBrkStr(Obj_._StartTagBrkStr),
_EndTagBrkStr(Obj_._EndTagBrkStr),
_ElementPtr(Obj_._ElementPtr),
_RefTagStk(Obj_._RefTagStk),
_RefStkNode(Obj_._RefStkNode),
_TagString(Obj_._TagString)
{
  int x;
  TagDictionary* Dict_ = _RefTagStk ? _RefTagStk->GiveTagDictionary():
                         _TagParse ? _TagParse->GiveTagDictionary():NULL;

  _HasTagContents      = Obj_._HasTagContents;
  _HasIntraTagContents = Obj_._HasIntraTagContents;
  _HasKvPairs          = Obj_._HasKvPairs;
  _HasCommentData      = Obj_._HasCommentData;
  _InComment           = Obj_._InComment;
  _InScript            = Obj_._InScript;
  _SingletonTag        = Obj_._SingletonTag;
  _DocTypeTag          = Obj_._DocTypeTag;
  _EndingTag           = Obj_._EndingTag;

  if (Obj_._TagParse)
    *_TagParse = *Obj_._TagParse;

  if (Obj_._TagCommentData)
    *_TagCommentData = *Obj_._TagCommentData;

  if (Obj_._KeyValueData)
    *_KeyValueData = *Obj_._KeyValueData;

  if (_TagParse && _RefStkNode)
  {
    _TagParse->SetTagDictionary(_Dictionary);
    _TagParse->SetKeyValuePairData(_KeyValueData);
    _TagParse->SetCommentData(_TagCommentData);

    x = _RefStkNode->TagBrkIndex();
    _StartTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                              NULL;
    x = _RefStkNode->EndBrkIndex();
    _EndTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                            NULL;

    _ElementPtr = _RefStkNode->GiveTagElementPtr();
    _TagString = _RefStkNode->GiveTagStr();

    _HasTagContents = _RefStkNode->HasTagContents();
    _HasIntraTagContents = _RefStkNode->HasIntraTagContents();
    _HasKvPairs = _RefStkNode->HasKVPairData();
    _HasCommentData = _RefStkNode->HasCommentData();
    _InComment = _RefStkNode->InComment();
    _InScript = _RefStkNode->InScript();
    _SingletonTag = _RefStkNode->IsSingleton();
    _DocTypeTag = _RefStkNode->IsDocTypeTag();
    _EndingTag = _RefStkNode->IsEndTag();
  }
}

/****************************************************************************/
TagStringData::~TagStringData()
{
  delete _TagParse;

  _TagParse = NULL;
  _TagCommentData = NULL;
  _KeyValueData = NULL;
  _RefStkNode = NULL;
}

/****************************************************************************/
TagStringData& TagStringData::SetTagDictionary(TagDictionary* Ptr_)
{
  _Dictionary = Ptr_;

  if (_TagParse)
    _TagParse->SetTagDictionary(_Dictionary);
  else
  {
    _TagParse = new TagParseInfo(this);

    if (_TagCommentData)
      _TagParse->SetCommentData(_TagCommentData);

    if (_KeyValueData)
      _TagParse->SetKeyValuePairData(_KeyValueData);
  }

  return *this;
}

/****************************************************************************/
TagStringData& TagStringData::SetRefStkNode(StackNodeInfo* Ptr_)
{
  int x;
  TagDictionary* Dict_ = _RefTagStk ? _RefTagStk->GiveTagDictionary():
                         _TagParse ? _TagParse->GiveTagDictionary():NULL;

  _RefStkNode = Ptr_;

  if (!_TagParse)
  {
    _TagParse = new TagParseInfo(this);

    if (_TagCommentData)
      _TagParse->SetCommentData(_TagCommentData);

    if (_KeyValueData)
      _TagParse->SetKeyValuePairData(_KeyValueData);
  }

  if (!_TagCommentData)
  {
    _TagCommentData = (Ptr_ && Ptr_->HasCommentData()) ?
                               Ptr_->GiveCommentData():NULL;
    _TagParse->SetCommentData(_TagCommentData);
  }

  if (!_KeyValueData)
  {
    _KeyValueData = (Ptr_ && Ptr_->HasKVPairData()) ?
                             Ptr_->GiveKeyValuePairData():NULL;
    _TagParse->SetKeyValuePairData(_KeyValueData);
  }

  if (_TagCommentData && Ptr_)
    _TagCommentData->SetTextBufferPtr(_TagParse->TextBufferPtr());

  if (_KeyValueData && Ptr_)
    _KeyValueData->SetTextBufferPtr(_TagParse->TextBufferPtr());

  if (_TagParse && _RefStkNode)
  {
    x = _RefStkNode->TagBrkIndex();
    _StartTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                              NULL;
    x = _RefStkNode->EndBrkIndex();
    _EndTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                            NULL;

    _ElementPtr = _RefStkNode->GiveTagElementPtr();
    _TagString = _RefStkNode->GiveTagStr();
  }

  HasCommentData();
  HasKvPairs();

  return *this;
}

/****************************************************************************/
TagStringData& TagStringData::SetRefTagStk(TagStack* Ptr_)
{
  _RefTagStk = Ptr_;

  int x;
  TagDictionary* Dict_ = _RefTagStk ? _RefTagStk->GiveTagDictionary():
                         _TagParse ? _TagParse->GiveTagDictionary():NULL;

  if (_TagParse && _RefStkNode)
  {
    x = _RefStkNode->TagBrkIndex();
    _StartTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                              NULL;
    x = _RefStkNode->EndBrkIndex();
    _EndTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                            NULL;

    _ElementPtr = _RefStkNode->GiveTagElementPtr();
    _TagString = _RefStkNode->GiveTagStr();
  }

  HasCommentData();
  HasKvPairs();

  return *this;
}

/****************************************************************************/
TagStringData& TagStringData::operator = (const TagStringData& Obj_)
{
  if (&Obj_ != this)
  {
    int x;
    TagDictionary* Dict_ = _RefTagStk ? _RefTagStk->GiveTagDictionary():
                           _TagParse ? _TagParse->GiveTagDictionary():NULL;

    _Dictionary = Obj_._Dictionary;
    _StartTagBrkStr = Obj_._StartTagBrkStr;
    _EndTagBrkStr = Obj_._EndTagBrkStr;
    _ElementPtr = Obj_._ElementPtr;
    _TagString = Obj_._TagString;

    _HasTagContents      = Obj_._HasTagContents;
    _HasIntraTagContents = Obj_._HasIntraTagContents;
    _HasKvPairs          = Obj_._HasKvPairs;
    _HasCommentData      = Obj_._HasCommentData;
    _InComment           = Obj_._InComment;
    _InScript            = Obj_._InScript;
    _SingletonTag        = Obj_._SingletonTag;
    _DocTypeTag          = Obj_._DocTypeTag;
    _EndingTag           = Obj_._EndingTag;

    if (Obj_._TagParse)
      if (_TagParse)
        *_TagParse = *Obj_._TagParse;
      else
        _TagParse = new TagParseInfo(this);

    _TagCommentData = _HasCommentData ? Obj_._TagCommentData:NULL;
    _KeyValueData = _HasKvPairs ? Obj_._KeyValueData:NULL;

    if (_TagParse)
    {
      _TagParse->SetTagDictionary(_Dictionary);
      _TagParse->SetKeyValuePairData(_KeyValueData);
      _TagParse->SetCommentData(_TagCommentData);
    }

    if (_TagParse && _RefStkNode)
    {
      x = _RefStkNode->TagBrkIndex();
      _StartTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                                NULL;
      x = _RefStkNode->EndBrkIndex();
      _EndTagBrkStr = Dict_ ? Dict_->GiveTagCountData(false)->GiveTagBrk(x):
                              NULL;

      _ElementPtr = _RefStkNode->GiveTagElementPtr();
      _TagString = _RefStkNode->GiveTagStr();

      _HasTagContents = _RefStkNode->HasTagContents();
      _HasIntraTagContents = _RefStkNode->HasIntraTagContents();
      _HasKvPairs = _RefStkNode->HasKVPairData();
      _HasCommentData = _RefStkNode->HasCommentData();
      _InComment = _RefStkNode->InComment();
      _InScript = _RefStkNode->InScript();
      _SingletonTag = _RefStkNode->IsSingleton();
      _DocTypeTag = _RefStkNode->IsDocTypeTag();
      _EndingTag = _RefStkNode->IsEndTag();
    }

    HasCommentData();
    HasKvPairs();
  }

  return *this;
}

/****************************************************************************/
bool TagStringData::HasTagContents() const
{
  if (_TagParse && _RefStkNode)
    _HasTagContents = _RefStkNode->HasTagContents();

  return _HasTagContents;
}

/****************************************************************************/
bool TagStringData::HasIntraTagContents() const
{
  if (_TagParse && _RefStkNode)
    _HasIntraTagContents = _RefStkNode->HasIntraTagContents();

  return _HasIntraTagContents;
}

/****************************************************************************/
bool TagStringData::HasKvPairs() const
{
  if (_TagParse && _RefStkNode)
    _HasKvPairs = _RefStkNode->HasKVPairData();

  if (_KeyValueData && _HasKvPairs)
    _HasKvPairs = _KeyValueData->TagFound() && _KeyValueData->NumPairs();

  return _HasKvPairs;
}

/****************************************************************************/
bool TagStringData::HasCommentData() const
{
  if (_TagParse && _RefStkNode)
    _HasCommentData = _RefStkNode->HasCommentData();

  if (_TagCommentData && _HasCommentData)
    _HasCommentData = InComment();

  return _HasCommentData;
}

/****************************************************************************/
bool TagStringData::InComment() const
{
  if (_TagParse && _RefStkNode)
    _InComment = _RefStkNode->InComment();

  if (_TagCommentData && _InComment)
    _InComment = _TagCommentData->InComment();

  return _InComment;
}

/****************************************************************************/
bool TagStringData::InScript() const
{
  if (_TagParse && _RefStkNode)
    _InScript = _RefStkNode->InScript();

  return _InScript;
}

/****************************************************************************/
bool TagStringData::SingletonTag() const
{
  if (_TagParse && _RefStkNode)
    _SingletonTag = _RefStkNode->IsSingleton();

  return _SingletonTag;
}

/****************************************************************************/
bool TagStringData::DocTypeTag() const
{
  if (_TagParse && _RefStkNode)
    _DocTypeTag = _RefStkNode->IsDocTypeTag();

  return _DocTypeTag;
}

/****************************************************************************/
bool TagStringData::EndingTag() const
{
  if (_TagParse && _RefStkNode)
    _EndingTag = _RefStkNode->IsEndTag();

  return _EndingTag;
}

/****************************************************************************/
bool TagStringData::IsParentOf(const TagParseInfo* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
bool TagStringData::IsParentOf(const TagCommentData* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
bool TagStringData::IsParentOf(const KeyValuePairData* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
TagStringData& TagStringData::SetTextBufferPtr(const ChrString* Ptr_)
{
  if (_TagParse)
    _TagParse->SetTextBufferPtr(Ptr_);

  if (_TagCommentData)
    _TagCommentData->SetTextBufferPtr(Ptr_);

  if (_KeyValueData)
    _KeyValueData->SetTextBufferPtr(Ptr_);

  return *this;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagStringData)

/****************************************************************************/
// TagString class definition
/****************************************************************************/
TagString::TagString(TagLineInfo* Parent_, TagStack* TstkPtr_,
                     StackNodeInfo* StknPtr_):
TagStringData((!TstkPtr_ && Parent_ && Parent_->GiveTagStack()) ?
                   Parent_->GiveTagStack()->GiveTagParseInfo():
              TstkPtr_ ? TstkPtr_->GiveTagParseInfo():NULL,
              (!TstkPtr_ && Parent_ && Parent_->GiveTagStack()) ?
                   Parent_->GiveTagStack()->GiveTagDictionary():
              TstkPtr_ ? TstkPtr_->GiveTagDictionary():NULL,
              TstkPtr_, StknPtr_),
_Parent(Parent_),
_FilePosRec(new FilePosition(true)),
_NestLevel(Parent_ ? Parent_->NestLevel():0),
_SequenceNum(Parent_ ? Parent_->SequenceNum():0)
{
  if (!_RefTagStk && _Parent && _Parent->GiveTagDictionary())
    SetTagDictionary(_Parent->GiveTagDictionary());
  else
    SetTagDictionary(_RefTagStk->GiveTagDictionary());
}

/****************************************************************************/
TagString::TagString(const TagString& Obj_):
TagStringData(Obj_),
_Parent(Obj_._Parent),
_FilePosRec(new FilePosition(true)),
_NestLevel(Obj_.GiveParent() ? Obj_.GiveParent()->NestLevel():0),
_SequenceNum(Obj_.GiveParent() ? Obj_.GiveParent()->SequenceNum():0)
{
  if (Obj_._FilePosRec)
    *_FilePosRec = *Obj_._FilePosRec;

  if (!_RefTagStk && _Parent && _Parent->GiveTagDictionary())
    SetTagDictionary(_Parent->GiveTagDictionary());
  else
    SetTagDictionary(_RefTagStk->GiveTagDictionary());
}

/****************************************************************************/
TagString::~TagString()
{
  delete _FilePosRec;
  _FilePosRec = NULL;
}

/****************************************************************************/
TagString* TagString::Make(TagLineInfo* Parent_,
                           TagStack* TstkPtr_, StackNodeInfo* StknPtr_)
{
  return (new TagString(Parent_, TstkPtr_, StknPtr_));
}

/****************************************************************************/
TagString* TagString::Make(const TagString& Obj_)
{
  return (new TagString(Obj_));
}

/****************************************************************************/
TagString& TagString::operator = (const TagString& Obj_)
{
  if (&Obj_ != this)
  {
    _Parent = Obj_._Parent;
    _NestLevel = Obj_.GiveParent() ? Obj_.GiveParent()->NestLevel():0;
    _SequenceNum = Obj_.GiveParent() ? Obj_.GiveParent()->SequenceNum():0;

    if (Obj_._FilePosRec)
    {
      if (!_FilePosRec)
        _FilePosRec = new FilePosition(true);

      *_FilePosRec = *Obj_._FilePosRec;
    }

    if (!_RefTagStk && _Parent && _Parent->GiveTagDictionary())
      SetTagDictionary(_Parent->GiveTagDictionary());
    else
      SetTagDictionary(_RefTagStk->GiveTagDictionary());

    TagStringData::operator = (Obj_);
  }

  return *this;
}

/****************************************************************************/
void TagString::ShowTagString(const ChrString& Header_, bool AppTab_)
{
  // new
  if (AppTab_) cout <<"\t";
  cout <<Header_ <<endl;

  if (_StartTagBrkStr)
  {
    if (AppTab_) cout <<"\t";
    cout <<"\tStartTagBrkStr: " <<_StartTagBrkStr <<endl;
  }
  else
  {
    if (AppTab_) cout <<"\t";
    cout <<"\tStartTagBrkStr: (null)\n";
  }

  if (_EndTagBrkStr)
  {
    if (AppTab_) cout <<"\t";
    cout <<"\tEndTagBrkStr: " <<_EndTagBrkStr <<endl;
  }
  else
  {
    if (AppTab_) cout <<"\t";
    cout <<"\tEndTagBrkStr: (null)\n";
  }

  if (AppTab_)
  {
    cout <<"\t\tTagString: " <<_TagString <<endl;
    cout <<"\t\tNestLevel: " <<_NestLevel <<endl
         <<"\t\tSequenceNum: " <<_SequenceNum <<endl
         <<"\t\tRefStkNode: " <<_RefStkNode <<endl;
    cout <<"\t\tHasTagContents: " <<_HasTagContents <<endl
         <<"\t\tHasIntraTagContents: " <<_HasIntraTagContents <<endl
         <<"\t\tHasKvPairs: " <<_HasKvPairs <<endl
         <<"\t\tHasCommentData: " <<_HasCommentData <<endl
         <<"\t\tInComment: " <<_InComment <<endl
         <<"\t\tInScript: " <<_InScript <<endl
         <<"\t\tSingletonTag: " <<_SingletonTag <<endl
         <<"\t\tDocTypeTag: " <<_DocTypeTag <<endl
         <<"\t\tEndingTag: " <<_EndingTag <<endl;
  }
  else
  {
    cout <<"\tTagString: " <<_TagString <<endl;
    cout <<"\tNestLevel: " <<_NestLevel <<endl
         <<"\tSequenceNum: " <<_SequenceNum <<endl
         <<"\tRefStkNode: " <<_RefStkNode <<endl;
    cout <<"\tHasTagContents: " <<_HasTagContents <<endl
         <<"\tHasIntraTagContents: " <<_HasIntraTagContents <<endl
         <<"\tHasKvPairs: " <<_HasKvPairs <<endl
         <<"\tHasCommentData: " <<_HasCommentData <<endl
         <<"\tInComment: " <<_InComment <<endl
         <<"\tInScript: " <<_InScript <<endl
         <<"\tSingletonTag: " <<_SingletonTag <<endl
         <<"\tDocTypeTag: " <<_DocTypeTag <<endl
         <<"\tEndingTag: " <<_EndingTag <<endl;
  }
}

/****************************************************************************/
TagLineInfo* TagString::GiveParent()
{
  return _Parent;
}

/****************************************************************************/
const TagLineInfo* TagString::GiveParent() const
{
  return _Parent;
}

/****************************************************************************/
FilePosition* TagString::GiveFilePosition()
{
  return _FilePosRec;
}

/****************************************************************************/
long TagString::NestLevel() const
{
  _NestLevel = _Parent ? _Parent->NestLevel():0;
  return _NestLevel;
}

/****************************************************************************/
long TagString::SequenceNum() const
{
  _SequenceNum = _Parent ? _Parent->SequenceNum():0;
  return _SequenceNum;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagString)

/****************************************************************************/
// TagCoordData class definition
/****************************************************************************/
TagCoordData::TagCoordData(TagStack* StkPtr_,
                           TagVector* VectPtr_, long Offset_):
_ReadOnly(false),
_StackOffset(Offset_),

_StackNestLevel(-1),
_VectorIndexPos(-1),

_PrevData(NULL),
_NextData(NULL),

_Parent(VectPtr_),
_Next(StkPtr_)
{
  if (_Next)
    _Next->SetFromCoordData(this);
}

/****************************************************************************/
TagCoordData::TagCoordData(const TagCoordData& Obj_):
_ReadOnly(true),
_StackOffset(Obj_._StackOffset),

_StackNestLevel(Obj_._StackNestLevel),
_VectorIndexPos(Obj_._VectorIndexPos),

_PrevData(Obj_._PrevData),
_NextData(Obj_._NextData),

_Parent(Obj_._Parent),
_Next(Obj_._Next)
{}

/****************************************************************************/
TagCoordData::~TagCoordData()
{
  if (_Next)
    _Next->SetFromCoordData(NULL);

  if (!_ReadOnly)
    delete _Next;

  _Next = NULL;
}

/****************************************************************************/
TagCoordData* TagCoordData::Make(TagStack* StkPtr_,
                                 TagVector* VectPtr_, long Offset_)
{
  return (new TagCoordData(StkPtr_, VectPtr_, Offset_));
}

/****************************************************************************/
TagCoordData* TagCoordData::Make(const TagCoordData& Obj_)
{
  return (new TagCoordData(Obj_));
}

/****************************************************************************/
TagCoordData& TagCoordData::operator = (const TagCoordData& Obj_)
{
  if (this != &Obj_)
  {
    _ReadOnly = true;
    _StackOffset = Obj_._StackOffset;

    _StackNestLevel = Obj_._StackNestLevel;
    _VectorIndexPos = Obj_._VectorIndexPos;

    _PrevData = Obj_._PrevData;
    _NextData = Obj_._NextData;

    _Parent = Obj_._Parent;
    _Next = Obj_._Next;
  }

  return *this;
}

/****************************************************************************/
void TagCoordData::SetStackNestLevel(long lvl, bool Spec_)
{
  if (Spec_)
    _StackNestLevel = lvl;
  else
    _StackNestLevel = -1;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordData::SetStackNestLevel:" <<endl;
    cout <<"\tlvl: " <<lvl <<endl;
  #endif
}

/****************************************************************************/
void TagCoordData::SetVectorIndexPos(long pos, bool Spec_)
{
  if (Spec_)
    _VectorIndexPos = pos;
  else
    _VectorIndexPos = -1;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordData::SetVectorIndexPos:" <<endl;
    cout <<"\tpos: " <<pos <<endl;
  #endif
}

/****************************************************************************/
long TagCoordData::StackNestLevel(bool Offset_) const
{
  if (!StackNestLevelSpec())
    return -1;

  return ((_StackOffset && Offset_) ? (_StackNestLevel - _StackOffset):
                                      _StackNestLevel);
}

/****************************************************************************/
long TagCoordData::VectorIndexPos() const
{
  return (VectorIndexPosSpec() ? _VectorIndexPos:-1);
}

/****************************************************************************/
TagCoordData* TagCoordData::SetNext(TagStack* Next_)
{
  if (!_ReadOnly)
  {
    _Next = Next_;

    if (_Next)
      _Next->SetFromCoordData(this);
  }

  return this;
}

/****************************************************************************/
TagCoordData* TagCoordData::SetParent(TagVector* Parent_, TagCoordData* Child_)
{
  if (!_ReadOnly)
  {
    _Parent = Parent_;

    if (Child_)
    {
      Child_->SetPrevData(this);
      SetNextData(Child_);
    }
  }

  return
  (
    (!_ReadOnly && _Parent) ?
        _Parent->SetChildStack(Child_, this):
        this
  );
}

/****************************************************************************/
MEMORYOPS_DEFN(TagCoordData)

/****************************************************************************/
// TagCoordSpecifier class definition
/****************************************************************************/
TagCoordSpecifier::TagCoordSpecifier(long Offset_):
_StackOffset(Offset_),
_ReadOnly(true),
_CoordData(NULL)
{
  ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
  ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
  ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
  ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));
}

/****************************************************************************/
TagCoordSpecifier::TagCoordSpecifier(TagCoordData* Ptr_):
_StackOffset(Ptr_ ? Ptr_->StackOffset():0),
_ReadOnly(true),
_CoordData(Ptr_)
{
  ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
  ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
  ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
  ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));

  if (Ptr_ && Ptr_->StackNestLevelSpec())
    SetStackNestLevel(Ptr_->StackNestLevel(false), true);

  if (Ptr_ && Ptr_->VectorIndexPosSpec())
    SetVectorIndexPos(Ptr_->VectorIndexPos(), true);
}

/****************************************************************************/
TagCoordSpecifier::TagCoordSpecifier(TagVector* Ptr_):
_StackOffset((Ptr_ && Ptr_->NextCoordData()) ?
                 Ptr_->NextCoordData()->StackOffset():0),
_ReadOnly(true),
_CoordData(Ptr_ ? Ptr_->NextCoordData():NULL)
{
  ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
  ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
  ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
  ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));

  if (Ptr_ && _CoordData)
  {
    long seqno = Ptr_->SequenceNum();

    if (_CoordData->StackNestLevelSpec())
      SetStackNestLevel(_CoordData->StackNestLevel(false), true);

    SetVectorIndexPos(seqno, true);
  }
}

/****************************************************************************/
TagCoordSpecifier::TagCoordSpecifier(const TagCoordSpecifier& Obj_):
_StackOffset(Obj_._StackOffset),
_ReadOnly(true),
_CoordData(Obj_._CoordData)
{
  ::memmove(_ValueSpec,  Obj_._ValueSpec,  MAXVALUES * sizeof(bool));
  ::memmove(_ValueSet,   Obj_._ValueSet,   MAXVALUES * sizeof(bool));
  ::memmove(_PrevValues, Obj_._PrevValues, MAXVALUES * sizeof(long));
  ::memmove(_CurrValues, Obj_._CurrValues, MAXVALUES * sizeof(long));
}

/****************************************************************************/
TagCoordSpecifier::~TagCoordSpecifier()
{
  if (!_ReadOnly)
  {
    delete _CoordData;
    _CoordData = NULL;
  }
}

/****************************************************************************/
TagCoordSpecifier* TagCoordSpecifier::Make(long Offset_)
{
  return (new TagCoordSpecifier(Offset_));
}

/****************************************************************************/
TagCoordSpecifier* TagCoordSpecifier::Make(TagCoordData* Ptr_)
{
  return (new TagCoordSpecifier(Ptr_));
}

/****************************************************************************/
TagCoordSpecifier* TagCoordSpecifier::Make(TagVector* Ptr_)
{
  return (new TagCoordSpecifier(Ptr_));
}

/****************************************************************************/
TagCoordSpecifier* TagCoordSpecifier::Make(const TagCoordSpecifier& Obj_)
{
  return (new TagCoordSpecifier(Obj_));
}

/****************************************************************************/
TagCoordSpecifier& TagCoordSpecifier::operator = (TagCoordData* Ptr_)
{
  _StackOffset = Ptr_ ? Ptr_->StackOffset():0;
  _ReadOnly = true;

  if (!Ptr_)
  {
    _CoordData = Ptr_;

    ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
    ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
    ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
    ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));
  }
  else if (Ptr_ && (!_CoordData || Ptr_ != _CoordData))
  {
    _CoordData = Ptr_;

    ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
    ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
    ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
    ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));

    if (Ptr_->StackNestLevelSpec())
      SetStackNestLevel(Ptr_->StackNestLevel(false), true);

    if (Ptr_->VectorIndexPosSpec())
      SetVectorIndexPos(Ptr_->VectorIndexPos(), true);
  }
  else if (Ptr_ && Ptr_ == _CoordData)
  {
    if (Ptr_->StackNestLevelSpec() &&
        Ptr_->StackNestLevel() != NewStackNestLevel())
      SetStackNestLevel(Ptr_->StackNestLevel(false), true);

    if (Ptr_->VectorIndexPosSpec() &&
        Ptr_->VectorIndexPos() != NewVectorIndexPos())
      SetVectorIndexPos(Ptr_->VectorIndexPos(), true);
  }

  return *this;
}

/****************************************************************************/
TagCoordSpecifier& TagCoordSpecifier::operator = (TagVector* Ptr_)
{
  _StackOffset = (Ptr_ && Ptr_->NextCoordData()) ?
                      Ptr_->NextCoordData()->StackOffset():0;
  _ReadOnly = true;

  if (!Ptr_)
  {
    _CoordData = NULL;

    ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
    ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
    ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
    ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));
  }
  else if (Ptr_ && Ptr_->NextCoordData() &&
           (!_CoordData || Ptr_->NextCoordData() != _CoordData))
  {
    _CoordData = Ptr_->NextCoordData();
    long seqno = Ptr_->SequenceNum();

    ::memset(_ValueSpec, 0, MAXVALUES * sizeof(bool));
    ::memset(_ValueSet, 0, MAXVALUES * sizeof(bool));
    ::memset(_PrevValues, 0, MAXVALUES * sizeof(long));
    ::memset(_CurrValues, 0, MAXVALUES * sizeof(long));

    if (_CoordData->StackNestLevelSpec())
      SetStackNestLevel(_CoordData->StackNestLevel(false), true);

    SetVectorIndexPos(seqno, true);
  }
  else if (Ptr_ && Ptr_->NextCoordData() &&
           Ptr_->NextCoordData() == _CoordData)
  {
    long seqno = Ptr_->SequenceNum();

    if (_CoordData->StackNestLevelSpec() &&
        _CoordData->StackNestLevel() != NewStackNestLevel())
      SetStackNestLevel(_CoordData->StackNestLevel(false), true);

    SetVectorIndexPos(seqno, true);
  }

  return *this;
}

/****************************************************************************/
TagCoordSpecifier& TagCoordSpecifier::operator = (const TagCoordSpecifier& Obj_)
{
  if (this != &Obj_)
  {
    _StackOffset = Obj_._StackOffset;
    _ReadOnly = true;
    _CoordData = Obj_._CoordData;

    ::memmove(_ValueSpec,  Obj_._ValueSpec,  MAXVALUES * sizeof(bool));
    ::memmove(_ValueSet,   Obj_._ValueSet,   MAXVALUES * sizeof(bool));
    ::memmove(_PrevValues, Obj_._PrevValues, MAXVALUES * sizeof(long));
    ::memmove(_CurrValues, Obj_._CurrValues, MAXVALUES * sizeof(long));
  }

  return *this;
}

/****************************************************************************/
void TagCoordSpecifier::SetReadOnly(bool rd)
{
  _ReadOnly = rd;

  if (_CoordData)
    _CoordData->SetReadOnly(rd);
}

/****************************************************************************/
void TagCoordSpecifier::SetStackNestLevel(long lvl,
                                          bool Spec_, bool AllowUpdate_)
{
  int x = TAGSTK;
  _ValueSpec[x] = Spec_;

  if (!_ValueSet[x] && _ValueSpec[x])
  {
    _PrevValues[x] = _CurrValues[x];
    _CurrValues[x] = lvl;
    _ValueSet[x] = true;
  }
  else if (!_ValueSpec[x])
  {
    if (_ValueSet[x])
      _CurrValues[x] = _PrevValues[x];

    _ValueSet[x] = false;
  }
  else if (_ValueSet[x] && _ValueSpec[x] && AllowUpdate_)
    _CurrValues[x] = lvl;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordSpecifier::SetStackNestLevel:" <<endl;
    cout <<"\t_PrevValues[x]: " <<_PrevValues[x] <<endl
         <<"\tSpec: " <<Spec_ <<endl
         <<"\tlvl: " <<lvl <<endl;
  #endif
}

/****************************************************************************/
void TagCoordSpecifier::SetChildStackLevel(long lvl,
                                           bool Spec_, bool AllowUpdate_)
{
  int x = CHILDSTK;
  _ValueSpec[x] = Spec_;

  if (!_ValueSet[x] && _ValueSpec[x])
  {
    _PrevValues[x] = _CurrValues[x];
    _CurrValues[x] = lvl;
    _ValueSet[x] = true;
  }
  else if (!_ValueSpec[x])
  {
    if (_ValueSet[x])
      _CurrValues[x] = _PrevValues[x];

    _ValueSet[x] = false;
  }
  else if (_ValueSet[x] && _ValueSpec[x] && AllowUpdate_)
    _CurrValues[x] = lvl;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordSpecifier::SetChildStackLevel:" <<endl;
    cout <<"\t_PrevValues[x]: " <<_PrevValues[x] <<endl
         <<"\tSpec: " <<Spec_ <<endl
         <<"\tlvl: " <<lvl <<endl;
  #endif
}

/****************************************************************************/
void TagCoordSpecifier::SetVectorIndexPos(long pos,
                                          bool Spec_, bool AllowUpdate_)
{
  int x = TAGVECT;
  _ValueSpec[x] = Spec_;

  if (!_ValueSet[x] && _ValueSpec[x])
  {
    _PrevValues[x] = _CurrValues[x];
    _CurrValues[x] = pos;
    _ValueSet[x] = true;
  }
  else if (!_ValueSpec[x])
  {
    if (_ValueSet[x])
      _CurrValues[x] = _PrevValues[x];

    _ValueSet[x] = false;
  }
  else if (_ValueSet[x] && _ValueSpec[x] && AllowUpdate_)
    _CurrValues[x] = pos;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordSpecifier::SetVectorIndexPos:" <<endl;
    cout <<"\t_PrevValues[x]: " <<_PrevValues[x] <<endl
         <<"\tSpec: " <<Spec_ <<endl
         <<"\tpos: " <<pos <<endl;
  #endif
}

/****************************************************************************/
void TagCoordSpecifier::SetChildVectorIndex(long pos,
                                            bool Spec_, bool AllowUpdate_)
{
  int x = CHILDVECT;
  _ValueSpec[x] = Spec_;

  if (!_ValueSet[x] && _ValueSpec[x])
  {
    _PrevValues[x] = _CurrValues[x];
    _CurrValues[x] = pos;
    _ValueSet[x] = true;
  }
  else if (!_ValueSpec[x])
  {
    if (_ValueSet[x])
      _CurrValues[x] = _PrevValues[x];

    _ValueSet[x] = false;
  }
  else if (_ValueSet[x] && _ValueSpec[x] && AllowUpdate_)
    _CurrValues[x] = pos;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordSpecifier::SetChildVectorIndex:" <<endl;
    cout <<"\t_PrevValues[x]: " <<_PrevValues[x] <<endl
         <<"\tSpec: " <<Spec_ <<endl
         <<"\tpos: " <<pos <<endl;
  #endif
}

/****************************************************************************/
void TagCoordSpecifier::SetMaxChildren(long max,
                                       bool Spec_, bool AllowUpdate_)
{
  int x = CHILDVECT;
  _ValueSpec[x] = Spec_;

  if (!_ValueSet[x] && _ValueSpec[x])
  {
    // decrement to index value of end tag from max num tags
    _PrevValues[x] = _CurrValues[x];
    _CurrValues[x] = (max > 0) ? (max-1):0;
    _ValueSet[x] = true;

  }
  else if (!_ValueSpec[x])
  {
    if (_ValueSet[x])
      _CurrValues[x] = _PrevValues[x];

    _ValueSet[x] = false;
  }
  else if (_ValueSet[x] && _ValueSpec[x] && AllowUpdate_)
    _CurrValues[x] = (max > 0) ? (max-1):0;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagCoordSpecifier::SetMaxChildren:" <<endl;
    cout <<"\t_PrevValues[x]: " <<_PrevValues[x] <<endl
         <<"\tSpec: " <<Spec_ <<endl
         <<"\tmax: " <<((max > 0) ? (max-1):0); <<endl;
  #endif
}

/****************************************************************************/
long TagCoordSpecifier::StackNestLevel(bool Offset_) const
{
  int x = TAGSTK;
  if (!_ValueSpec[x])
    return -1;

  if (_ValueSet[x])
    return ((_StackOffset && Offset_) ?
                (_PrevValues[x] - _StackOffset):
                _PrevValues[x]);

  return ((_StackOffset && Offset_) ?
              (_CurrValues[x] - _StackOffset):
              _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::ChildStackLevel(bool Offset_) const
{
  int x = CHILDSTK;
  if (!_ValueSpec[x])
    return -1;

  if (_ValueSet[x])
    return ((_StackOffset && Offset_) ?
                (_PrevValues[x] - _StackOffset):
                _PrevValues[x]);

  return ((_StackOffset && Offset_) ?
              (_CurrValues[x] - _StackOffset):
              _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::VectorIndexPos() const
{
  int x = TAGVECT;
  if (!_ValueSpec[x])
    return -1;

  return (_ValueSet[x] ? _PrevValues[x]:
                         _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::ChildVectorIndex() const
{
  int x = CHILDVECT;
  if (!_ValueSpec[x])
    return -1;

  return (_ValueSet[x] ? _PrevValues[x]:
                         _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::NewStackNestLevel(bool Offset_) const
{
  int x = TAGSTK;
  if (!_ValueSpec[x])
    return -1;

  return ((_StackOffset && Offset_) ? (_CurrValues[x] - _StackOffset):
                                      _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::NewChildStackLevel(bool Offset_) const
{
  int x = CHILDSTK;
  if (!_ValueSpec[x])
    return -1;

  return ((_StackOffset && Offset_) ? (_CurrValues[x] - _StackOffset):
                                      _CurrValues[x]);
}

/****************************************************************************/
long TagCoordSpecifier::NewVectorIndexPos() const
{
  int x = TAGVECT;
  if (!_ValueSpec[x])
    return -1;

  return _CurrValues[x];
}

/****************************************************************************/
long TagCoordSpecifier::NewChildVectorIndex() const
{
  int x = CHILDVECT;
  if (!_ValueSpec[x])
    return -1;

  return _CurrValues[x];
}

/****************************************************************************/
void TagCoordSpecifier::CommitNewPos()
{
  int x;

  for (x = 0; x < MAXVALUES; x++)
    if (_ValueSpec[x])
    {
      _ValueSet[x] = false;
      _PrevValues[x] = 0;
    }
}

/****************************************************************************/
void TagCoordSpecifier::RollbackPos()
{
  int x;

  for (x = 0; x < MAXVALUES; x++)
    if (_ValueSpec[x])
    {
      _CurrValues[x] = _PrevValues[x];
      _ValueSet[x] = false;
    }
}

/****************************************************************************/
void TagCoordSpecifier::RestoreFrom(TagCoordSpecifier* Ptr_)
{
  if (!Ptr_)
    return;

  _StackOffset = Ptr_->_StackOffset;
  _ReadOnly = Ptr_->_ReadOnly;
  _CoordData = Ptr_->_CoordData;

  ::memmove(_ValueSpec,  Ptr_->_ValueSpec,  MAXVALUES * sizeof(bool));
  ::memmove(_ValueSet,   Ptr_->_ValueSet,   MAXVALUES * sizeof(bool));
  ::memmove(_PrevValues, Ptr_->_PrevValues, MAXVALUES * sizeof(long));
  ::memmove(_CurrValues, Ptr_->_CurrValues, MAXVALUES * sizeof(long));
}

/****************************************************************************/
MEMORYOPS_DEFN(TagCoordSpecifier)

/****************************************************************************/
// TagCoordDataWrapper class definition
/****************************************************************************/
TagCoordWrapper::TagCoordWrapper(const TagCoordSpecifier& Obj_,
                                 TagReader* Reader_, bool NewPos_):
TagCoordSpecifier(Obj_),

_NewPos(NewPos_),
_TagReader(Reader_)
{}

/****************************************************************************/
TagCoordWrapper& TagCoordWrapper::operator = (const TagCoordWrapper& Obj_)
{
  if (this != &Obj_)
  {
    TagCoordSpecifier::operator = (Obj_);

    _NewPos = Obj_._NewPos;
    _TagReader = Obj_._TagReader;
  }

  return *this;
}

/****************************************************************************/
long TagCoordWrapper::GiveCoordVectLen() const
{
  return (_TagReader->MaxNestLevel() - StackOffset());
}

/****************************************************************************/
long TagCoordWrapper::GiveTagStkLevel(long VectLen_, bool Create_) const
{
  return (Create_ ? VectLen_:
                    (_NewPos ? NewStackNestLevel():
                               StackNestLevel()));
}

/****************************************************************************/
long TagCoordWrapper::GiveNextTagStkLevel(bool Create_) const
{
  return (Create_ ? (_NewPos ? NewChildStackLevel():
                               ChildStackLevel()):0);
}

/****************************************************************************/
long TagCoordWrapper::GiveNextTagVectIndex(bool Create_) const
{
  return (Create_ ? (_NewPos ? NewChildVectorIndex():
                               ChildVectorIndex()):0);
}

/****************************************************************************/
bool TagCoordWrapper::IsTagStkLevelSpec(long VectLen_, long StkLvl_) const
{
  return (StackNestLevelSpec() &&
          0 <= StkLvl_ && StkLvl_ < VectLen_);
}

/****************************************************************************/
bool TagCoordWrapper::IsNextTagStkLevelSpec(long VectLen_,
                                            bool Create_, long NextStkLvl_) const
{
  return (ChildStackLevelSpec() &&
          0 <= NextStkLvl_ && (Create_ || NextStkLvl_ < VectLen_));
}

/****************************************************************************/
bool TagCoordWrapper::IsNextTagVectIndexSpec(bool Create_,
                                             long NextVectIndex_, long VectorLen_) const
{
  return (ChildVectorIndexSpec() &&
          0 <= NextVectIndex_ && (Create_ || NextVectIndex_ < VectorLen_));
}

/****************************************************************************/
MEMORYOPS_DEFN(TagCoordWrapper)

/****************************************************************************/
// TagVector class definition
/****************************************************************************/
TagVector::TagVector(TagStack* Parent_, TagParseInfo* TagParse_):
_ReadOnly(false),
_Parent(Parent_),
_NextLevel(NULL),
_ParentStack(NULL),
_ChildStack(NULL),
_Dictionary(TagParse_ ? TagParse_->GiveTagDictionary():NULL),

_TagLine(new TagLineInfo(this)),
_TagParse(TagParse_),

_SequenceNum(0),
_MatchingNum(0)
{}

/****************************************************************************/
TagVector::TagVector(const TagVector& Obj_):
_ReadOnly(true),
_Parent(Obj_._Parent),
_NextLevel(Obj_._NextLevel),
_ParentStack(Obj_._ParentStack),
_ChildStack(Obj_._ChildStack),
_Dictionary(Obj_._Dictionary),

_TagLine(Obj_._TagLine ? (new TagLineInfo(*Obj_._TagLine)):NULL),
_TagParse(Obj_._TagParse),

_SequenceNum(Obj_._SequenceNum),
_MatchingNum(Obj_._MatchingNum)
{}

/****************************************************************************/
TagVector::~TagVector()
{
  TagCoordData* ParStk_ = NULL;

  if (!_ReadOnly)
  {
    delete _TagLine;
    _TagLine = NULL;

    ParStk_ = PopStack();
    EraseNextLevel(ParStk_, _ReadOnly);
  }

  _NextLevel = NULL;
  _ChildStack = NULL;
}

/****************************************************************************/
TagVector& TagVector::operator = (const TagVector& Obj_)
{
  if (&Obj_ != this)
  {
    _Parent = Obj_._Parent;
    _NextLevel = Obj_._NextLevel;
    _ParentStack = Obj_._ParentStack;
    _ChildStack = Obj_._ChildStack;
    _Dictionary = Obj_._Dictionary;

    _TagLine = Obj_._TagLine;
    _TagParse = Obj_._TagParse;

    _SequenceNum = Obj_._SequenceNum;
    _MatchingNum = Obj_._MatchingNum;

    SetReadOnly(true);
  }

  return *this;
}

/****************************************************************************/
TagVector* TagVector::Make(TagStack* Parent_, TagParseInfo* TagParse_)
{
  return (new TagVector(Parent_, TagParse_));
}

/****************************************************************************/
TagVector* TagVector::Make(const TagVector& Obj_)
{
  return (new TagVector(Obj_));
}

/****************************************************************************/
TagVector& TagVector::SetTagDictionary(TagDictionary* Ptr_)
{
  _Dictionary = Ptr_;
  return *this;
}

/****************************************************************************/
TagVector& TagVector::SetTagParseInfo(TagParseInfo* TagParse_)
{
  _TagParse = TagParse_;

  if (_TagParse && _TagParse->GiveTagDictionary())
    SetTagDictionary(_TagParse->GiveTagDictionary());

  return *this;
}

/****************************************************************************/
TagVector& TagVector::SetSequenceNum(long SeqNum_)
{
  _SequenceNum = SeqNum_;
  return *this;
}

/****************************************************************************/
TagVector& TagVector::SetMatchingNum(long MatchNum_)
{
  _MatchingNum = MatchNum_;
  return *this;
}

/****************************************************************************/
bool TagVector::IsRootCoordData(TagCoordData* Ptr_)
{
  return ((Ptr_ && Ptr_->Next()) ?
              Ptr_->Next()->IsRootCoordData(Ptr_):
              false);
}

/****************************************************************************/
TagCoordData* TagVector::SetNextLevel(TagStack* NextLevel_)
{
  _NextLevel = NextLevel_;

  if (_TagLine)
    _TagLine->SetTagStack(_NextLevel);

  return (_NextLevel ? PushStack(_NextLevel):NULL);
}

/****************************************************************************/
TagCoordData* TagVector::EraseNextLevel(TagCoordData* ParStk_, bool RdOnly_)
{
  TagCoordData* StkHead_ = NULL;

  if (ParStk_ && ParStk_->Next() == _NextLevel)
  {
    if (!_ReadOnly)
    {
      ParStk_->SetReadOnly(RdOnly_ || IsRootCoordData(ParStk_));
      delete ParStk_;
    }

    _NextLevel = NULL;
    StkHead_ = _ChildStack;
    _ChildStack = NULL;
  }

  return StkHead_;
}

/****************************************************************************/
TagCoordData* TagVector::CreateNextLevel(long NestLevel_)
{
  return (_Parent ? SetNextLevel(TagStack::Make(NULL, NestLevel_, _Parent->GiveTagReader())):
                    NULL);
}

/****************************************************************************/
TagCoordData* TagVector::SetParentStack(TagCoordData* Ptr_)
{
  _ParentStack = Ptr_;
  return (_ParentStack ? _ParentStack:_ChildStack);
}

/****************************************************************************/
TagCoordData* TagVector::SetChildStack(TagCoordData* Child_, TagCoordData* Coord_)
{
  // new
  _ChildStack = Child_;
  return SetParentStack(Coord_);
}

/****************************************************************************/
TagCoordData* TagVector::PushStack(TagStack* NewStk_)
{
  // new
  bool RdOnly_ = false;
  long NewNest_ = NewStk_ ? NewStk_->NestLevel():0;

  TagCoordData* NewData_ = TagCoordData::Make(NewStk_, this, NewNest_);
  TagCoordData* ParData_ = NULL;

  if (NewData_)
  {
    if (NewNest_ >= 0)
      NewData_->SetStackNestLevel(NewNest_, true);

    if (_SequenceNum >= 0)
      NewData_->SetVectorIndexPos(_SequenceNum, true);
  }
  else
    return NULL;

  if (!_ChildStack)
  {
    if (!_Parent->FromCoordData())
    {
      ParData_ = TagCoordData::Make(_Parent, _Parent->FromVect(), NestLevel());
      ParData_->SetReadOnly(true);
      _Parent->SetFromCoordData(ParData_, NestLevel());
      RdOnly_ = true;
    }

    SetChildStack(_Parent->FromCoordData(), NULL);
    _ChildStack->SetReadOnly(RdOnly_ ||
                             _Parent->FromCoordData()->ReadOnly());

    return (NewData_ ? NewData_->SetParent(this, _ChildStack):NULL);
  }
  else if (_ParentStack)
  {
    _ParentStack->SetNextData(_ChildStack);
    return (NewData_ ? NewData_->SetParent(this, _ParentStack):NULL);
  }
  else if (NewData_)
    return NewData_->SetParent(this, _ChildStack);

  return NULL;
}

/****************************************************************************/
TagCoordData* TagVector::PushStack(long NestLevel_)
{
  // new
  CreateNextLevel(NestLevel_);
  return (_ParentStack ? _ParentStack:_ChildStack);
}

/****************************************************************************/
TagCoordData* TagVector::PopStack()
{
  // new
  bool err = false;
  TagCoordData* Prev_ = _ChildStack;
  TagCoordData* Curr_ = _ParentStack;

  TagStack* NextStk_ = (Prev_ && Curr_) ? Curr_->Next():NULL;
  TagVector* CurrVect_ = (Prev_ && Curr_) ? Curr_->Parent():NULL;

  if (NextStk_ && CurrVect_)
  {
    err = CurrVect_ != this ||
          NextStk_ != _NextLevel;

    if (!err)
    {
      Prev_->SetPrevData(NULL);
      Curr_->SetNextData(NULL);
      CurrVect_->SetParentStack(NULL);
    }

    #if TAGREADER_CREATEFROM_DEBUG
      else
      {
        cout <<"TagVector::PopStack(): ** TagStack Creation Error **" <<endl
             <<"  Object Address : " <<this <<endl;
      }
    #endif
  }

  return Curr_;
}

/****************************************************************************/
void TagVector::ShowVectorEntry(long slvl, long vlvl, long nlvl)
{
  // new
  long seqn = _SequenceNum;

  cout <<"   TagVector::ShowVectorEntry (start): " <<this <<endl;
  cout <<"\tCoordinate: [slvl:" <<slvl <<"/vlvl:" <<vlvl <<"]" <<endl
       <<"\t            [nlvl:" <<nlvl <<"/seqn:" <<seqn <<"]" <<endl
       <<"\tSequenceNum: " <<_SequenceNum <<endl
       <<"\tMatchingNum: " <<_MatchingNum <<endl;

  if (_TagLine)
    _TagLine->ShowTagLineInfo();

  if (_NextLevel)
    _NextLevel->WalkTagStack(slvl+1);

  cout <<"   TagVector::ShowVectorEntry (end): " <<this <<endl;
}

/****************************************************************************/
const TagStack* TagVector::Parent() const
{
  return _Parent;
}

/****************************************************************************/
const TagStack* TagVector::NextLevel() const
{
  return _NextLevel;
}

/****************************************************************************/
long TagVector::NestLevel() const
{
  return (_Parent ? _Parent->NestLevel():0);
}

/****************************************************************************/
const TagLineInfo* TagVector::GiveTagLineInfo() const
{
  return _TagLine;
}

/****************************************************************************/
const TagParseInfo* TagVector::GiveTagParseInfo() const
{
  return _TagParse;
}

/****************************************************************************/
const TagDictionary* TagVector::GiveTagDictionary() const
{
  return (_Dictionary ? _Dictionary:
          _Parent     ? _Parent->GiveTagDictionary():NULL);
}

/****************************************************************************/
bool TagVector::IsParentOf(const TagLineInfo* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
// NestLevel_ : Parent stack nesting level
// SeqNum_ : Current TagVector object sequence number
//
void TagVector::GiveCoordinate(long& NestLevel_, long& SeqNum_) const
{
  if (_Parent)
    NestLevel_ = _Parent->NestLevel();

  SeqNum_ = _SequenceNum;
}

/****************************************************************************/
TagStack* TagVector::Parent()
{
  return _Parent;
}

/****************************************************************************/
TagStack* TagVector::NextLevel()
{
  return _NextLevel;
}

/****************************************************************************/
TagLineInfo* TagVector::GiveTagLineInfo()
{
  return _TagLine;
}

/****************************************************************************/
TagParseInfo* TagVector::GiveTagParseInfo()
{
  return _TagParse;
}

/****************************************************************************/
TagDictionary* TagVector::GiveTagDictionary()
{
  return _Dictionary;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagVector)

/****************************************************************************/
// TagStack class definition
/****************************************************************************/
TagStack::TagStack(long NestLevel_,
                   TagReader* TrdPtr_, TagCoordData* CoordPtr_):
_ScanMode(TagEnums::TAGREAD),
_ReadOnly(false),
_NestLevel(NestLevel_ < 0 ? 0:NestLevel_),

_VectorLen(0),
_VectorMax(0),

_TagReader(TrdPtr_),
_TagVector(NULL),
_FromCoord(CoordPtr_)
{
  GrowVector();
}

/****************************************************************************/
TagStack::TagStack(const TagStack& Obj_):
_ScanMode(Obj_._ScanMode),
_ReadOnly(true),
_NestLevel(Obj_._NestLevel),

_VectorLen(Obj_._VectorLen),
_VectorMax(Obj_._VectorMax),

_TagReader(Obj_._TagReader),
_TagVector(NULL),
_FromCoord(Obj_._FromCoord)
{
  Subscript x;
  Subscript max = Obj_._VectorMax;

  if (max)
  {
    max *= sizeof(TagVector*);
    TagVector** TagVect_ = (TagVector**)RawAllocateWith(MEMMATRIX, max);
    _TagVector = (TagVector**)::memmove(TagVect_, Obj_._TagVector, max);
  }
}

/****************************************************************************/
TagStack::~TagStack()
{
  Subscript x;
  Subscript max = _VectorLen;

  if (FromCoordData())
    SetFromCoordData(NULL);

  if (!_ReadOnly)
    for (x = 0; x < max; x++)
    {
      delete _TagVector[x];
      _TagVector[x] = NULL;
    }

  RawDeleteArray(_TagVector);
  _TagVector = NULL;
}

/****************************************************************************/
TagStack* TagStack::Make(TagCoordSpecifier* TCspec_, long NestLevel_,
                         TagReader* TrdPtr_, TagCoordData* CoordPtr_)
{
  if (TCspec_)
  {
    NestLevel_ += TCspec_->StackOffset();
    return (new TagStack(NestLevel_, TrdPtr_, CoordPtr_));
  }

  return (new TagStack(NestLevel_, TrdPtr_, CoordPtr_));
}

/****************************************************************************/
TagStack* TagStack::Make(const TagStack& Obj_)
{
  return (new TagStack(Obj_));
}

/****************************************************************************/
TagVector** TagStack::GrowVector(long Incr_)
{
  Subscript max = 0;
  TagVector** TagVector_ = NULL;

  if (!_TagVector || !_VectorMax)
  {
    max = Incr_;
    max *= sizeof(TagVector*);
    TagVector_ = (TagVector**)RawAllocateWith(MEMMATRIX, max);
    _TagVector = TagVector_;
    _VectorMax = Incr_;
  }
  else
  {
    max = _VectorMax + Incr_;
    max *= sizeof(TagVector*);
    TagVector_ = _TagVector;
    _TagVector = (TagVector**)RawAllocateWith(MEMMATRIX, max);
    max = _VectorMax * sizeof(TagVector*);
    ::memmove(_TagVector, TagVector_, max);
    _VectorMax += Incr_;
    RawDeleteArray(TagVector_);
  }

  return _TagVector;
}

/****************************************************************************/
bool TagStack::IsRootCoordData(TagCoordData* Ptr_) const
{
  return (_TagReader && Ptr_ &&
          _FromCoord == Ptr_ &&
          _FromCoord->Next() == this &&
          _FromCoord->Parent() == NULL &&
          _TagReader->GiveRootTagStack() == this);
}

/****************************************************************************/
TagStack& TagStack::EraseTagVectors()
{
  Subscript x;
  Subscript max = _VectorLen;

  if (!_ReadOnly)
  {
    for (x = 0; x < max; x++)
    {
      delete _TagVector[x];
      _TagVector[x] = NULL;
    }

    _VectorLen = 0;
  }

  return *this;
}

/****************************************************************************/
void TagStack::ShowCoordVect(long* CoordVect_, long VectLen_) const
{
  int i;
  for (i = 0; i < VectLen_ && CoordVect_[i] >= 0; i++)
    cout <<"\tCoordVect[" <<i <<"]: " <<CoordVect_[i] <<endl;
}

/****************************************************************************/
bool TagStack::HasVector(TagVector* Ptr_)
{
  if (!Ptr_)
    return false;

  Subscript x;
  Subscript max = _VectorLen;

  for (x = 0; x < max; x++)
    if (_TagVector[x] &&
        _TagVector[x] == Ptr_)
      return true;

  return false;
}

/****************************************************************************/
TagStack& TagStack::operator = (const TagStack& Obj_)
{
  if (this != &Obj_)
  {
    _VectorMax = Obj_._VectorMax;
    _VectorLen = Obj_._VectorLen;

    Subscript x;
    Subscript max = _VectorLen;

    if (!_ReadOnly)
      for (x = 0; x < max; x++)
      {
        delete _TagVector[x];
        _TagVector[x] = NULL;
      }

    RawDeleteArray(_TagVector);
    _TagVector = NULL;
    max = _VectorMax;

    if (max)
    {
      max *= sizeof(TagVector*);
      TagVector** TagVect_ = (TagVector**)RawAllocateWith(MEMMATRIX, max);
      _TagVector = (TagVector**)::memmove(TagVect_, Obj_._TagVector, max);
    }

    _TagReader = Obj_._TagReader;
    _ScanMode = Obj_._ScanMode;
    _NestLevel = Obj_._NestLevel;

    SetReadOnly(true);
  }

  return *this;
}

/****************************************************************************/
TagStack& TagStack::SetScanMode(int Mode_)
{
  _ScanMode = Mode_;
  return *this;
}

/****************************************************************************/
TagStack& TagStack::SetNestLevel(long Level_)
{
  _NestLevel = Level_;
  return *this;
}

/****************************************************************************/
TagStack& TagStack::SetTagReader(TagReader* Ptr_)
{
  _TagReader = Ptr_;
  return *this;
}

/****************************************************************************/
TagVector* TagStack::SetTagVectorChild(TagVector* TVect_,
                                       long StkLvl_, long Index_)
{
  if (!TVect_)
    return NULL;

  bool RdOnly_ = FromCoordData() == NULL || _ReadOnly;
  TagCoordData* ParData_ = NULL;
  TagCoordData* CurrCoord_ = TVect_->CurrCoordData();

  if (!FromCoordData())
  {
    ParData_ = TagCoordData::Make(this, NULL, NestLevel());
    ParData_->SetReadOnly(RdOnly_);
    SetFromCoordData(ParData_, StkLvl_);
  }

  if (StkLvl_ >= 0 && !FromCoordData()->StackNestLevelSpec())
    FromCoordData()->SetStackNestLevel(StkLvl_, true);

  if (Index_ >= 0)
    TVect_->SetSequenceNum(Index_);

  TVect_->SetChildStack(FromCoordData(), CurrCoord_);
  return TVect_;
}

/****************************************************************************/
TagVector* TagStack::ResetTagVectorChild(TagVector* TVect_)
{
  if (!TVect_)
    return NULL;

  TagCoordData* CurrCoord_ = TVect_->CurrCoordData();
  TVect_->SetChildStack(NULL, CurrCoord_);
  return TVect_;
}

/****************************************************************************/
TagVector* TagStack::AddTagVector(TagVector* Ptr_, bool KeepPtr_)
{
  if (Ptr_ && _VectorLen < _VectorMax && !_ReadOnly)
  {
    long Index_ = _VectorLen++;

    _TagVector[Index_] =
      KeepPtr_ ? Ptr_:
                 SetTagVectorChild(TagVector::Make(*Ptr_), NestLevel(), Index_);

    if (_VectorLen == _VectorMax)
      GrowVector();

    return _TagVector[Index_];
  }

  return NULL;
}

/****************************************************************************/
TagVector* TagStack::CreateTagVector(TagParseInfo* Ptr_, long StkLvl_, long Index_)
{
  if (_ReadOnly)
    return NULL;

  if (_VectorLen < _VectorMax &&
      ((_TagReader && _TagReader->GiveTagDictionary()) || Ptr_))
  {
    long SavedIndex_ = _VectorLen;
    TagParseInfo* TagParse_ = _TagReader ? _TagReader:NULL;
    TagDictionary* Dict_ = Ptr_ ? Ptr_->GiveTagDictionary():
                           _TagReader ? _TagReader->GiveTagDictionary():NULL;

    if (Index_ >= 0 && Index_ < _VectorLen)
    {
      if (!_TagVector[Index_])
      {
        _TagVector[Index_] = SetTagVectorChild(TagVector::Make(this, TagParse_), StkLvl_, Index_);

        if (!_TagReader)
          _TagVector[Index_]->SetTagDictionary(Dict_);
      }

      return _TagVector[Index_];
    }
    else
    {
      _TagVector[_VectorLen] = SetTagVectorChild(TagVector::Make(this, TagParse_), StkLvl_, _VectorLen);

      if (!_TagReader)
        _TagVector[_VectorLen]->SetTagDictionary(Dict_);
    }

    _VectorLen++;

    if (_VectorLen == _VectorMax)
      GrowVector();

    if (Index_ >= 0 && Index_ >= _VectorLen)
      return CreateTagVector(Ptr_, StkLvl_, Index_);
    else
      return (Index_ >= 0 ||
              SavedIndex_ == Index_) ? _TagVector[Index_]:NULL;
  }

  return NULL;
}

/****************************************************************************/
TagVector* TagStack::CreateTagVector(TagDictionary* Ptr_, long StkLvl_, long Index_)
{
  if (_ReadOnly)
    return NULL;

  if (_VectorLen < _VectorMax &&
      ((_TagReader && _TagReader->GiveTagDictionary()) || Ptr_))
  {
    long SavedIndex_ = _VectorLen;
    TagParseInfo* TagParse_ = _TagReader ? _TagReader:NULL;
    TagDictionary* Dict_ = Ptr_ ? Ptr_:
                           _TagReader ? _TagReader->GiveTagDictionary():NULL;

    if (Index_ >= 0 && Index_ < _VectorLen)
    {
      if (!_TagVector[Index_])
      {
        _TagVector[Index_] = SetTagVectorChild(TagVector::Make(this, TagParse_), StkLvl_, Index_);

        if (!_TagReader)
          _TagVector[Index_]->SetTagDictionary(Dict_);
      }

      return _TagVector[Index_];
    }
    else
    {
      _TagVector[_VectorLen] = SetTagVectorChild(TagVector::Make(this, TagParse_), StkLvl_, _VectorLen);

      if (!_TagReader)
        _TagVector[_VectorLen]->SetTagDictionary(Dict_);
    }

    _VectorLen++;

    if (_VectorLen == _VectorMax)
      GrowVector();

    if (Index_ >= 0 && Index_ >= _VectorLen)
      return CreateTagVector(Ptr_, StkLvl_, Index_);
    else
      return (Index_ >= 0 ||
              SavedIndex_ == Index_) ? _TagVector[Index_]:NULL;
  }

  return NULL;
}

/****************************************************************************/
TagVector* TagStack::GiveTagVector(long Index_, bool* Found_)
{
  if (0 <= Index_ && Index_ < _VectorLen)
  {
    if (Found_)
      *Found_ = _TagVector[Index_] != NULL;

    return _TagVector[Index_];
  }

  if (Found_)
    *Found_ = false;

  return NULL;
}

/****************************************************************************/
const TagVector* TagStack::GiveTagVector(long Index_, bool* Found_) const
{
  if (0 <= Index_ && Index_ < _VectorLen)
  {
    if (Found_)
      *Found_ = _TagVector[Index_] != NULL;

    return _TagVector[Index_];
  }

  if (Found_)
    *Found_ = false;

  return NULL;
}

/****************************************************************************/
TagVector* TagStack::GiveTFCoordHelper(bool Create_, long* CoordVect_,
                                       long Index_, TagCoordWrapper* Tcw,
                                       TagVector* FoundVectPtr_, bool* Found_)
{
  long VectLen_ = Tcw->GiveCoordVectLen();
  long StkLvl_ = Tcw->GiveTagStkLevel(VectLen_, Create_);
  long NextStkLvl_ = Tcw->GiveNextTagStkLevel(Create_);
  long NextVectIndex_ = Tcw->GiveNextTagVectIndex(Create_);

  bool StkLvlSpec_ = Tcw->IsTagStkLevelSpec(VectLen_, StkLvl_);
  bool StkLvlMatched_ = StkLvlSpec_ && StkLvl_ == Index_;
  bool StkLvlAfterMatched_ = StkLvlSpec_ && StkLvl_ == Index_-1;

  bool NextStkLvlSpec_ = Tcw->IsNextTagStkLevelSpec(VectLen_, Create_, NextStkLvl_);
  bool NextVectIndexSpec_ = Tcw->IsNextTagVectIndexSpec(Create_, NextVectIndex_, _VectorLen);

  TagCoordData* CoordPtr_ = NULL;
  TagStack* NextLevelPtr_ = NULL;

  // At end of tag coordinate vector or at
  // specified stack level (array index)
  if (Index_ == VectLen_ || StkLvlAfterMatched_)
  {
    if (Found_)
      *Found_ = FoundVectPtr_ != NULL;

    if (FoundVectPtr_ && NextStkLvlSpec_)
    {
      NextLevelPtr_ = FoundVectPtr_->NextLevel();

      if (!NextLevelPtr_ && !_ReadOnly)
      {
        CoordPtr_ = FoundVectPtr_->SetNextLevel(TagStack::Make(Tcw, NextStkLvl_, GiveTagReader()));

        if (CoordPtr_)
        {
          CoordPtr_->SetStackNestLevel(NextStkLvl_, true);
          NextLevelPtr_ = CoordPtr_->Next();
        }
      }

      if (NextLevelPtr_ && NextVectIndexSpec_)
      {
        FoundVectPtr_ = NextLevelPtr_->GiveTagVector(NextVectIndex_, Found_);

        // Tag vectors for both the start and end tag pair needs to exist
        if (!FoundVectPtr_)
          FoundVectPtr_ = NextLevelPtr_->CreateTagVector(GiveTagDictionary(), NextStkLvl_, NextVectIndex_);

        if (Found_)
          *Found_ = FoundVectPtr_ != NULL;
      }
    }

    return FoundVectPtr_;
  }

  long seqno = CoordVect_[Index_];
  FoundVectPtr_ = GiveTagVector(seqno, Found_);

  if (FoundVectPtr_ && seqno == FoundVectPtr_->SequenceNum())
  {
    // retrieve next stack level if index value
    // has not reached the maximum vector length
    NextLevelPtr_ = ((Index_+1 < VectLen_) && !StkLvlMatched_) ?
                        FoundVectPtr_->NextLevel():
                        this;

    if (!NextLevelPtr_)
    {
      CoordPtr_ = (!_ReadOnly &&
                   (Create_ || StkLvlSpec_)) ? FoundVectPtr_->SetNextLevel(TagStack::Make(Tcw, Index_+1, GiveTagReader())):
                                               NULL;

      if (CoordPtr_)
        NextLevelPtr_ = CoordPtr_->Next();
    }

    if (NextLevelPtr_)
    {
      if (StkLvlMatched_)
      {
        if (Found_)
          *Found_ = FoundVectPtr_ != NULL;

        // Retrieve or create child stack object
        if (FoundVectPtr_ && NextStkLvlSpec_)
        {
          NextLevelPtr_ = FoundVectPtr_->NextLevel();

          if (!NextLevelPtr_ && !_ReadOnly)
          {
            CoordPtr_ = FoundVectPtr_->SetNextLevel(TagStack::Make(Tcw, NextStkLvl_, GiveTagReader()));

            if (CoordPtr_)
            {
              CoordPtr_->SetStackNestLevel(NextStkLvl_, true);
              NextLevelPtr_ = CoordPtr_->Next();
            }
          }

          if (NextLevelPtr_ && NextVectIndexSpec_)
          {
            FoundVectPtr_ = NextLevelPtr_->GiveTagVector(NextVectIndex_, Found_);

            // Tag vectors for both the start and end tag pair needs to exist
            if (!FoundVectPtr_)
              FoundVectPtr_ = NextLevelPtr_->CreateTagVector(GiveTagDictionary(), NextStkLvl_, NextVectIndex_);

            if (Found_)
              *Found_ = FoundVectPtr_ != NULL;
          }
        }

        return FoundVectPtr_;
      }
      else
        return NextLevelPtr_->GiveTFCoordHelper(Create_, CoordVect_, Index_+1,
                                                Tcw, FoundVectPtr_, Found_);
    }
    else if (Found_)
      *Found_ = false;

    FoundVectPtr_ = NULL;
  }
  else if (Create_ && !_ReadOnly)
  {
    if (seqno >= _VectorLen)
      FoundVectPtr_ = CreateTagVector(GiveTagDictionary(), Index_, seqno);
    else
      FoundVectPtr_ = GiveTagVector(seqno, Found_);

    if (FoundVectPtr_)
      return GiveTFCoordHelper(Create_, CoordVect_, Index_,
                               Tcw, FoundVectPtr_, Found_);
    else if (Found_)
      *Found_ = false;
  }
  else if (!_ReadOnly && !FoundVectPtr_ && StkLvlSpec_ &&
           (StkLvlMatched_ || Index_ < StkLvl_))
  {
    FoundVectPtr_ = CreateTagVector(GiveTagDictionary(), Index_, seqno);

    if (FoundVectPtr_)
      return GiveTFCoordHelper(Create_, CoordVect_, Index_,
                               Tcw, FoundVectPtr_, Found_);
    else if (Found_)
      *Found_ = false;
  }
  else
    FoundVectPtr_ = NULL;

  return FoundVectPtr_;
}

/****************************************************************************/
const TagVector* TagStack::GiveTFCoordHelper(long* CoordVect_, long Index_,
                                             TagCoordWrapper* Tcw,
                                             const TagVector* FoundVectPtr_,
                                             bool* Found_) const
{
  long VectLen_ = Tcw->GiveCoordVectLen();
  long StkLvl_ = Tcw->GiveTagStkLevel(VectLen_, false);

  bool StkLvlSpec_ = Tcw->IsTagStkLevelSpec(VectLen_, StkLvl_);
  bool StkLvlMatched_ = StkLvlSpec_ && StkLvl_ == Index_;
  bool StkLvlAfterMatched_ = StkLvlSpec_ && StkLvl_ == Index_-1;

  const TagStack* NextLevelPtr_ = NULL;

  if (Index_ == VectLen_ || StkLvlAfterMatched_)
  {
    if (Found_)
      *Found_ = FoundVectPtr_ != NULL;

    return FoundVectPtr_;
  }

  long seqno = CoordVect_[Index_];
  FoundVectPtr_ = GiveTagVector(seqno, Found_);

  if (FoundVectPtr_ && seqno == FoundVectPtr_->SequenceNum())
  {
    NextLevelPtr_ = ((Index_+1 < VectLen_) && !StkLvlMatched_) ?
                        FoundVectPtr_->NextLevel():
                        this;

    if (!NextLevelPtr_)
      NextLevelPtr_ = NULL;

    if (NextLevelPtr_)
    {
      if (StkLvlMatched_)
      {
        if (Found_)
          *Found_ = FoundVectPtr_ != NULL;

        return FoundVectPtr_;
      }
      else
        return NextLevelPtr_->GiveTFCoordHelper(CoordVect_, Index_+1,
                                                Tcw, FoundVectPtr_, Found_);
    }
    else if (Found_)
      *Found_ = false;

    FoundVectPtr_ = NULL;
  }
  else
    FoundVectPtr_ = NULL;

  return FoundVectPtr_;
}

/****************************************************************************/
// PURPOSE:
//   Give specified TagVector object at given nesting level and sequence
//   number coordinate. if Create_ variable is specified true then create
//   each TagStack and TagVector object that does not yet exists.
//
// Format of coordinate vector:
//     Coord[0][1][2] ... [n]
//     index n into Coord array represents nesting level of TagStack object
//     value of dereference Coord array element represents sequence number
//     of TagVector object.
//
// PRE:
//   bool Create_ : if set to true then create each TagStack and TagVector
//                  object specified by the CoordVect array that does not
//                  yet exists.
//   long* CoordVect_ : Coordinate vector array.
//   long VectLen_ : Coordinate vector array length.
//   long StkLvl_ : Stack Level of vector array entry specified for retrieval
//   bool* Found_ : set to result of search if passed as non-null value
//                  always set to true if Create_ is specified as true.
//
// POST:
//   If the Found_ parameter is passed as an address to a non-null bool
//   variable then it will be set according to whether the specified
//   TagVector object is found or not.
//
// RETURN:
//   Returns the created TagVector object if it doesn't yet exist if the
//   Create_ parameter is set to true, otherwise returns the TagVector
//   object as specified by the the coordinate vector array parameter
//   CoordVect_.
//
//
TagVector* TagStack::GiveTagFromCoordinate(bool Create_,long* CoordVect_, bool New_,
                                           TagCoordSpecifier* TCoord_, bool* Found_)
{
  TagVector* retv = NULL;
  TagCoordWrapper* Tcw = NULL;
  long VectLen_, StkLvl_;

  if (CoordVect_ && VectLen_ && TCoord_)
  {
    VectLen_ = _TagReader->MaxNestLevel() - TCoord_->StackOffset();
    Tcw = new TagCoordWrapper(*TCoord_, _TagReader, New_);
    retv = GiveTFCoordHelper(Create_, CoordVect_, 0, Tcw, NULL, Found_);
    delete Tcw;

    #if TAGREADER_CREATEFROMSNI_DEBUG
      StkLvl_ = Create_ ? VectLen_:
                          TCoord_->NewStackNestLevel();

      cout <<"TagStack::GiveTagFromCoordinate: " <<endl;
      ShowCoordVect(CoordVect_, VectLen_);
      cout <<"\tCreate: "       <<Create_ <<endl
           <<"\tVectLen_: "     <<VectLen_ <<endl
           <<"\tStkLvl_: "      <<StkLvl_ <<endl
           <<"\tFound: "        <<*Found_ <<endl;
      cout <<"\tretv: "         <<retv <<endl;
    #endif
  }

  return retv;
}

/****************************************************************************/
// PURPOSE:
//   Give specified TagVector object at given nesting level and sequence
//   number coordinate. if Create_ variable is specified true then create
//   each TagStack and TagVector object that does not yet exists.
//
// Format of coordinate vector:
//     Coord[0][1][2] ... [n]
//     index n into Coord array represents nesting level of TagStack object
//     value of dereference Coord array element represents sequence number
//     of TagVector object.
//
// PRE:
//   bool Create_ : if set to true then create each TagStack and TagVector
//                  object specified by the CoordVect array that does not
//                  yet exists.
//   long* CoordVect_ : Coordinate vector array.
//   long VectLen_ : Coordinate vector array length.
//   long StkLvl_ : Stack Level of vector array entry specified for retrieval
//   bool* Found_ : set to result of search if passed as non-null value
//                  always set to true if Create_ is specified as true.
//
// POST:
//   If the Found_ parameter is passed as an address to a non-null bool
//   variable then it will be set according to whether the specified
//   TagVector object is found or not.
//
// RETURN:
//   Returns the created TagVector object if it doesn't yet exist if the
//   Create_ parameter is set to true, otherwise returns the TagVector
//   object as specified by the the coordinate vector array parameter
//   CoordVect_.
//
const TagVector* TagStack::GiveTagFromCoordinate(long* CoordVect_, bool New_,
                                                 TagCoordSpecifier* TCoord_, bool* Found_) const
{
  const TagVector* retv = NULL;
  TagCoordWrapper* Tcw = NULL;
  long VectLen_, StkLvl_;

  if (CoordVect_ && VectLen_ && TCoord_)
  {
    VectLen_ = _TagReader->MaxNestLevel() - TCoord_->StackOffset();
    Tcw = new TagCoordWrapper(*TCoord_, _TagReader, New_);
    retv = GiveTFCoordHelper(CoordVect_, 0, Tcw, NULL, Found_);
    delete Tcw;

    #if TAGREADER_CREATEFROMSNI_DEBUG
      StkLvl_ = Create_ ? VectLen_:
                           TCoord_->NewStackNestLevel();

      cout <<"TagStack::GiveTagFromCoordinate: " <<endl;
      ShowCoordVect(CoordVect_, VectLen_);
      cout <<"\tVectLen_: " <<VectLen_ <<endl
           <<"\tStkLvl_: " <<StkLvl_ <<endl
           <<"\tFound: " <<*Found_ <<endl;
      cout <<"\tretv: " <<retv <<endl;
    #endif
  }

  return retv;
}

/****************************************************************************/
void TagStack::ShowStackData()
{
  cout <<"\tScanMode: " <<_ScanMode <<endl
       <<"\tNestLevel: " <<_NestLevel <<endl
       <<"\tVectorLen: " <<_VectorLen <<endl
       <<"\tVectorMax: " <<_VectorMax <<endl;
}

/****************************************************************************/
void TagStack::ShowVectorData(long slvl, long x)
{
  if (!_TagVector)
    return;

  if (x >= 0)
  {
    if (_TagVector[x])
      _TagVector[x]->ShowVectorEntry(slvl, x, _NestLevel);
  }
  else
  {
    for (x = 0; x < _VectorLen && _TagVector[x]; x++)
      _TagVector[x]->ShowVectorEntry(slvl, x, _NestLevel);
  }
}

/****************************************************************************/
// Method to walk TagStack tree structure
//
void TagStack::WalkTagStack(long slvl)
{
  // new
  cout <<"  TagStack::WalkTagStack (start): " <<this <<endl;
  ShowStackData();
  ShowVectorData(slvl);
  cout <<"  TagStack::WalkTagStack (end): " <<this <<endl;
}

/****************************************************************************/
void TagStack::SetFromCoordData(TagCoordData* From_, long StkLvl_)
{
  long x;
  TagCoordData* OldCoord_ = _FromCoord;
  _FromCoord = From_;

  if (_FromCoord)
  {
    if (StkLvl_ >= 0 && !_FromCoord->StackNestLevelSpec())
      _FromCoord->SetStackNestLevel(StkLvl_, true);
  }
  else if (OldCoord_ && _TagVector)
  {
    for (x = 0; x < _VectorLen; x++)
      if (_TagVector[x])
        ResetTagVectorChild(_TagVector[x]);
  }
}

/****************************************************************************/
TagDictionary* TagStack::GiveTagDictionary()
{
  return (_TagReader ? _TagReader->GiveTagDictionary():NULL);
}

/****************************************************************************/
TagParseInfo* TagStack::GiveTagParseInfo()
{
  return (_TagReader ? _TagReader:NULL);
}

/****************************************************************************/
bool TagStack::IsParentOf(const TagVector* Child_) const
{
  return (Child_ ? Child_->HasThisParent(this):false);
}

/****************************************************************************/
MEMORYOPS_DEFN(TagStack)

/****************************************************************************/
// TagLineInfo class definition
/****************************************************************************/
TagLineInfo::TagLineInfo(TagVector* Parent_, TagLineInfo* MatchTag_):
_StartTag(NULL),
_EndTag(NULL),

_UnorderedTag(false),
_ImpliedEnd(false),
_Singleton(false),
_MatchingTag(MatchTag_),
_TerminalTag(NULL),
    
_TagContent(NULL),

_Parent(Parent_),
_TagStack(Parent_ ? Parent_->NextLevel():NULL)
{
  _Matched =
  _Shown =
  _Modified =
  _Saved = 0;

  if (MatchTag_)
    MatchTag_->SetTerminalTag(this);
}

/****************************************************************************/
TagLineInfo::TagLineInfo(const TagLineInfo& Obj_):
_StartTag(Obj_._StartTag ? (new TagString(*Obj_._StartTag)):NULL),
_EndTag(Obj_._EndTag ? (new TagString(*Obj_._EndTag)):NULL),

_UnorderedTag(Obj_._UnorderedTag),
_ImpliedEnd(Obj_._ImpliedEnd),
_Singleton(Obj_._Singleton),
_MatchingTag(Obj_._MatchingTag),
_TerminalTag(Obj_._TerminalTag),
    
_TagContent(Obj_._TagContent ? (new ChrString(*Obj_._TagContent)):NULL),

_Parent(Obj_._Parent),
_TagStack(Obj_._Parent ? Obj_._Parent->NextLevel():NULL)
{
  _Matched  = Obj_._Matched;
  _Shown    = Obj_._Shown;
  _Modified = Obj_._Modified;
  _Saved    = Obj_._Saved;

  if (_MatchingTag)
    _MatchingTag->SetTerminalTag(this);
  else if (_TerminalTag)
    _TerminalTag->SetMatchingTag(this);
}

/****************************************************************************/
TagLineInfo::~TagLineInfo()
{
  // retain ownership of _StartTag and _EndTag pointer to TagString objects
  delete _StartTag;
  delete _EndTag;
  delete _TagContent;

  _StartTag =
  _EndTag = NULL;
  _TagContent = NULL;
}

/****************************************************************************/
TagLineInfo* TagLineInfo::Make(TagVector* Parent_, TagLineInfo* MatchTag_)
{
  return (new TagLineInfo(Parent_, MatchTag_));
}

/****************************************************************************/
TagLineInfo* TagLineInfo::Make(const TagLineInfo& Obj_)
{
  return (new TagLineInfo(Obj_));
}

/****************************************************************************/
TagLineInfo& TagLineInfo::operator = (const TagLineInfo& Obj_)
{
  if (&Obj_ != this)
  {
    _Matched  = Obj_._Matched;
    _Shown    = Obj_._Shown;
    _Modified = Obj_._Modified;
    _Saved    = Obj_._Saved;

    _StartTag = Obj_._StartTag ? (new TagString(*Obj_._StartTag)):NULL;
    _EndTag = Obj_._EndTag ? (new TagString(*Obj_._EndTag)):NULL;

    _UnorderedTag = Obj_._UnorderedTag;
    _ImpliedEnd = Obj_._ImpliedEnd;
    _Singleton = Obj_._Singleton;
    _MatchingTag = Obj_._MatchingTag;
    _TerminalTag = Obj_._TerminalTag;
    
    _TagContent = Obj_._TagContent ? (new ChrString(*Obj_._TagContent)):NULL;

    _Parent = Obj_._Parent;
    _TagStack = Obj_._Parent ? Obj_._Parent->NextLevel():NULL;

    if (_MatchingTag)
      _MatchingTag->SetTerminalTag(this);
    else if (_TerminalTag)
      _TerminalTag->SetMatchingTag(this);
  }

  return *this;
}

/****************************************************************************/
TagLineInfo* TagLineInfo::CreateFromStackNodeInfo(TagReader* Trd_,
                                                  StackNodeInfo* Ptr_, bool ChildCreated_)
{
  if (!Ptr_ || !Trd_)
    return NULL;

  ChrString ContentStr_;
  ChrString sTagStr_;
  ChrString eTagStr_;

  NodeNestingData* Nodep_ = NULL;
  TagStack* RootStk_ = Trd_->GiveRootTagStack();
  TagParseData* Tpd_ = Trd_ ? Trd_->GiveTagParseData():NULL;
  TagCoordSpecifier* Tcd_ = Trd_ ? Trd_->GiveTagCoordSpecifier():NULL;

  int chdlvl = Ptr_->ChildNestLevel() + Tcd_->StackOffset();
  int snl = Tcd_->NewStackNestLevel();
  int sn = Tcd_->NewVectorIndexPos();
  int stsn = 0;
  int etsn = 0;
  int stsnl = 0;
  int etsnl = 0;

  bool EndTagImplied_ = false;
  bool SingletonTag_ = false;
  bool UnorderedTag_ = false;

  StackNodeInfo* StPtr_ = NULL;
  StackNodeInfo* EtPtr_ = NULL;

  TagVector* stv = NULL;       // starting tag vector pointer
  TagVector* etv = NULL;       // ending tag vector pointer
  TagLineInfo* stlip = NULL;   // TagLineInfo pointer
  TagLineInfo* etlip = NULL;   // TagLineInfo pointer

  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    cout <<"   TagLineInfo::CreateFromStackNodeInfo (start):" <<endl;
    cout <<"      IsEndTag(): "            <<Ptr_->IsEndTag() <<endl
         <<"      StdTagFound(): "         <<Ptr_->StdTagFound() <<endl
         <<"      SingletonTagFound(): "   <<Ptr_->SingletonTagFound() <<endl
         <<"      EmptyTagFound(): "       <<Ptr_->EmptyTagFound() <<endl
         <<"      InComment(): "           <<Ptr_->InComment() <<endl
         <<"      InNestedComment(): "     <<Ptr_->InNestedComment() <<endl
         <<"      InScript(): "            <<Ptr_->InScript() <<endl
         <<"      IsDocTypeTag(): "        <<Ptr_->IsDocTypeTag() <<endl
         <<"      IsContentTypeTag(): "    <<Ptr_->IsContentTypeTag() <<endl
         <<"      IsNonContentTypeTag(): " <<Ptr_->IsNonContentTypeTag() <<endl
         <<"      PairEnderFound(): "      <<Ptr_->PairEnderFound() <<endl
         <<"      IsEndTag(): "            <<Ptr_->IsEndTag() <<endl
         <<"      HasTagFwdLink(): "       <<Tpd_->HasTagFwdLink() <<endl;
  #endif

  if (!Tpd_->HasTagFwdLink() && !Ptr_->IsEndTag() &&
      (Ptr_->StdTagFound() || Ptr_->SingletonTagFound() ||
       Ptr_->EmptyTagFound() || Ptr_->InComment() ||
       Ptr_->InNestedComment() || Ptr_->InScript() ||
       Ptr_->IsDocTypeTag() ||
       (!Ptr_->IsContentTypeTag() || Ptr_->IsNonContentTypeTag())))
  {
    EndTagImplied_ = Ptr_->EndImplied();
    SingletonTag_ = Ptr_->IsSingleton();
    UnorderedTag_ = Ptr_->UnorderedTag();

    sTagStr_ = Ptr_->GiveTagStr();
    stv = _Parent;
    stlip = this;

    stlip->SetStartTag(TagString::Make(stlip, RootStk_, Ptr_),
                       EndTagImplied_, SingletonTag_, UnorderedTag_);
    stlip->SetTerminalTag(NULL);

    if (Ptr_->HasTagContents())
    {
      ContentStr_ = Ptr_->GiveTagContent();
      stlip->SetTagContent(&ContentStr_);
    }
    else
      stlip->SetTagContent(NULL);

    snl = Tcd_->NewStackNestLevel();
    sn = Tcd_->NewVectorIndexPos();
    Trd_->SetTagCreated(snl, sn);
    Tpd_->SetCreatedStartLine(stlip);

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"      sn: "               <<sn <<endl
           <<"      snl: "              <<snl <<endl
           <<"      SingleTon: "        <<SingletonTag_ <<endl
           <<"      EndTagImplied: "    <<EndTagImplied_ <<endl
           <<"      UnorderedTag: "     <<UnorderedTag_ <<endl
           <<"      stv: "              <<stv <<endl
           <<"      stlip: "            <<stlip <<endl
           <<"      StartTag: "         <<stlip->StartTag() <<endl
           <<"      TerminalTag: "      <<stlip->TerminalTag() <<endl
           <<"      Start TagStr: "     <<sTagStr_ <<endl
           <<"      ContentStr: "       <<ContentStr_ <<endl
           <<"      HasTagContents(): " <<Ptr_->HasTagContents() <<endl;
      cout <<"   TagLineInfo::CreateFromStackNodeInfo (end):" <<endl;
    #endif

    return stlip;
  }
  else if (Ptr_->PairEnderFound() && Ptr_->IsEndTag())
  {
    eTagStr_ = Ptr_->GiveTagStr();
    etv = _Parent;
    etlip = this;

    if (!etlip->EndTag() || !etlip->MatchingTag())
    {
      if (!_EndTag)
      {
        etlip->SetEndTag(TagString::Make(etlip, RootStk_, Ptr_));
        snl = ChildCreated_ ? Tcd_->NewStackNestLevel():chdlvl;
        sn = Ptr_->SequenceNumber();
        Trd_->SetTagCreated(snl, sn);
        Tpd_->SetCreatedEndLine(etlip);
      }

      #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
           (TAGREADER_CREATEFROMSNI3_DEBUG))
        cout <<"      sn: "         <<sn <<endl
             <<"      snl: "        <<snl <<endl
             <<"      stv: "        <<stv <<endl
             <<"      etlip: "      <<etlip <<endl
             <<"      EndTag: "     <<etlip->EndTag() <<endl
             <<"      End TagStr: " <<eTagStr_ <<endl;

        if (!etlip->MatchingTag())
          cout <<"      MatchingTag: TAG CREATION ERROR" <<endl;
        else
          cout <<"      MatchingTag: " <<etlip->MatchingTag() <<endl;

        cout <<"   TagLineInfo::CreateFromStackNodeInfo (end):" <<endl;
      #endif

      return etlip;
    }
  }
  else if (Tpd_->HasTagFwdLink())
  {
    if (Tpd_->GiveStkNodeFwdLink() &&
        Ptr_->ForwardLink() == Tpd_->GiveStkNodeFwdLink())
    {
      StPtr_ = Tpd_->GiveStkNodeBackLink();
      EtPtr_ = Tpd_->GiveStkNodeFwdLink();
    }
    else if (Tpd_->GiveTagFwdLink())
    {
      Nodep_ = Tpd_->GiveTagFwdLink();
      StPtr_ = Nodep_->GiveStartTag();
      EtPtr_ = Nodep_->GiveEndTag();
    }

    ChildCreated_ = ChildCreated_ &&
                    Tpd_->HasTagFwdLink() && Tpd_->ChildVisited();
    EndTagImplied_ = StPtr_->EndImplied();
    SingletonTag_ = StPtr_->IsSingleton();
    UnorderedTag_ = StPtr_->UnorderedTag();
    sTagStr_ = StPtr_->GiveTagStr();
    eTagStr_ = EtPtr_->GiveTagStr();

    stv = Tpd_->GiveStartTagVector();
    etv = Tpd_->GiveEndTagVector();
    stlip = stv->GiveTagLineInfo();
    etlip = etv->GiveTagLineInfo();

    stv->SetMatchingNum(etv->SequenceNum());
    stlip->SetStartTag(TagString::Make(stlip, RootStk_, StPtr_),
                       EndTagImplied_, SingletonTag_, UnorderedTag_);
    stlip->SetTerminalTag(etlip);

    if (StPtr_->HasTagContents())
    {
      ContentStr_ = StPtr_->GiveTagContent();
      stlip->SetTagContent(&ContentStr_);
    }
    else
      stlip->SetTagContent(NULL);

    stsn = StPtr_->SequenceNumber();
    stsnl = ChildCreated_ ? Tcd_->NewStackNestLevel():
                            StPtr_->NestLevel();
    Trd_->SetTagCreated(stsnl, stsn);
    Tpd_->SetCreatedStartLine(stlip);

    etlip->SetEndTag(TagString::Make(etlip, RootStk_, EtPtr_));
    etlip->SetMatchingTag(stlip);
    etlip->SetTagContent(NULL);
    etsn = EtPtr_->SequenceNumber();
    etsnl = ChildCreated_ ? Tcd_->NewStackNestLevel():
                            EtPtr_->ChildNestLevel();
    Trd_->SetTagCreated(etsnl, etsn);
    Tpd_->SetCreatedEndLine(etlip);

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"      stsn: "             <<stsn <<endl
           <<"      etsn: "             <<etsn <<endl
           <<"      snl: "              <<snl <<endl
           <<"      StPtr_: "           <<StPtr_ <<endl
           <<"      EtPtr_: "           <<EtPtr_ <<endl
           <<"      Nodep_: "           <<Nodep_ <<endl
           <<"      SingleTon: "        <<SingletonTag_ <<endl
           <<"      EndTagImplied: "    <<EndTagImplied_ <<endl
           <<"      UnorderedTag: "     <<UnorderedTag_ <<endl
           <<"      stv: "              <<stv <<endl
           <<"      stlip: "            <<stlip <<endl
           <<"      etv: "              <<etv <<endl
           <<"      etlip: "            <<etlip <<endl
           <<"      StartTag: "         <<stlip->StartTag() <<endl
           <<"      TerminalTag: "      <<stlip->TerminalTag() <<endl
           <<"      Start TagStr: "     <<sTagStr_ <<endl
           <<"      ContentStr: "       <<ContentStr_ <<endl
           <<"      HasTagContents(): " <<StPtr_->HasTagContents() <<endl
           <<"      End TagStr: "       <<eTagStr_ <<endl
           <<"      EndTag: "           <<etlip->EndTag() <<endl
           <<"      MatchingTag: "      <<etlip->MatchingTag() <<endl;
      cout <<"   TagLineInfo::CreateFromStackNodeInfo (end):" <<endl;

      ASSERT(stlip != NULL, "NULL starting TagLineInfo pointer");
      ASSERT(etlip != NULL, "NULL ending TagLineInfo pointer");
      ASSERT(etlip == stlip->TerminalTag(), "Terminal Tag mismatched\n");
      ASSERT(stlip == etlip->MatchingTag(), "Matching Tag mismatched\n");
      ASSERT(stlip->StartTag()->GiveRefStkNode() == StPtr_, "Start Tag mismatched\n");
      ASSERT(etlip->EndTag()->GiveRefStkNode() == EtPtr_, "End Tag mismatched\n");
    #endif

    return stlip;
  }

  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    cout <<"      StartTag, EndTag: NOT CREATED" <<endl
         <<"      HasTagFwdLink: " <<Tpd_->HasTagFwdLink() <<endl
         <<"      TagTypeFound: " <<Ptr_->TagTypeFound() <<endl;
    cout <<"   TagLineInfo::CreateFromStackNodeInfo (end):" <<endl;
  #endif

  return NULL;
}

/****************************************************************************/
void TagLineInfo::ShowTagLineInfo(bool Terminate_)
{
  // new
  ChrString Header_;

  if (Terminate_)
  {
    cout <<"\t    TagLineInfo::ShowTagLineInfo (start): " <<this <<endl;
    cout <<"\t\tUnorderedTag: " <<_UnorderedTag <<endl
         <<"\t\tSingleTon: " <<_Singleton <<endl
         <<"\t\tImpliedEnd: " <<_ImpliedEnd <<endl;
  }
  else
  {
    cout <<"    TagLineInfo::ShowTagLineInfo (start): " <<this <<endl;
    cout <<"\tUnorderedTag: " <<_UnorderedTag <<endl
         <<"\tSingleTon: " <<_Singleton <<endl
         <<"\tImpliedEnd: " <<_ImpliedEnd <<endl;
  }

  if (_StartTag)
  {
    Header_ = "     StartTag: ";
    _StartTag->ShowTagString(Header_, Terminate_);

    if (Terminate_) cout <<"\t";
    cout <<"     EndTag: (null)\n";
    if (Terminate_) cout <<"\t";
  }
  else if (_EndTag)
  {
    if (Terminate_) cout <<"\t";
    cout <<"     StartTag: (null)\n";

    Header_ = "     EndTag: ";
    _EndTag->ShowTagString(Header_, Terminate_);
    if (Terminate_) cout <<"\t";
  }

  if (_TagContent && _TagContent->strlen())
    cout <<"     TagContent: " <<*_TagContent <<endl;
  else
    cout <<"     TagContent: (null)\n";

  if (_MatchingTag)
  {
    if (!Terminate_)
    {
      cout <<"     MatchingTag:\n";
      _MatchingTag->ShowTagLineInfo(_EndTag != NULL);
    }
    else
    {
      cout <<"\t\tMatchingTag: " <<_MatchingTag <<endl;
      cout <<"\t\tTerminalTag: (null)\n";
    }
  }
  else if (_TerminalTag)
  {
    if (!Terminate_)
    {
      cout <<"     TerminalTag:\n";
      _TerminalTag->ShowTagLineInfo(_StartTag != NULL);
    }
    else
    {
      cout <<"\t\tMatchingTag: (null)\n";
      cout <<"\t\tTerminalTag: " <<_TerminalTag <<endl;
    }
  }

  if (Terminate_) cout <<"\t";
  cout <<"    TagLineInfo::ShowTagLineInfo (end): " <<this <<endl;
}

/****************************************************************************/
TagString* TagLineInfo::SetStartTag(TagString* StartTag_, bool EndTagImplied_,
                                    bool SingletonTag_, bool UnorderedTag_, bool KeepPtr_)
{
  TagString* Ptr_ = (!KeepPtr_ && StartTag_) ?
                        (new TagString(*StartTag_)):
                        StartTag_;

  delete _StartTag;
  _StartTag = Ptr_;
  _StartTag->SetTagDictionary(_TagStack->GiveTagDictionary());

  _ImpliedEnd = EndTagImplied_;
  _Singleton = SingletonTag_;
  _UnorderedTag = UnorderedTag_;

  // Set Parent's dictionary
  if (!_Parent->GiveTagDictionary())
    _Parent->SetTagDictionary(_TagStack->GiveTagDictionary());

  // Set Parent's TagParseInfo
  if (!_Parent->GiveTagParseInfo())
    _Parent->SetTagParseInfo(_StartTag->GiveTagParseInfo());

  if (_StartTag && _EndTag)
  {
    delete _EndTag;
    _EndTag = NULL;
  }

  return _StartTag;
}

/****************************************************************************/
TagString* TagLineInfo::SetEndTag(TagString* EndTag_, bool KeepPtr_)
{
  TagString* Ptr_ = (!KeepPtr_ && EndTag_) ?
                        (new TagString(*EndTag_)):
                        EndTag_;

  delete _EndTag;
  _EndTag = Ptr_;
  _EndTag->SetTagDictionary(_TagStack->GiveTagDictionary());

  // Set Parent's TagDictionary
  if (!_Parent->GiveTagDictionary())
    _Parent->SetTagDictionary(_TagStack->GiveTagDictionary());

  // Set Parent's TagParseInfo
  if (!_Parent->GiveTagParseInfo())
    _Parent->SetTagParseInfo(_EndTag->GiveTagParseInfo());

  if (_EndTag && _StartTag)
  {
    delete _StartTag;
    _StartTag = NULL;
  }

  return _EndTag;
}

/****************************************************************************/
TagLineInfo* TagLineInfo::SetMatchingTag(TagLineInfo* MatchTag_)
{
  _MatchingTag = MatchTag_;
  _Singleton = false;
  return _MatchingTag;
}

/****************************************************************************/
TagLineInfo* TagLineInfo::SetTerminalTag(TagLineInfo* TermTag_)
{
  _TerminalTag = TermTag_;
  _Singleton = false;
  return _TerminalTag;
}

/****************************************************************************/
TagLineInfo& TagLineInfo::SetTagContent(ChrString* Ptr_, bool KeepPtr_)
{
  ChrString* Str_ = (!KeepPtr_ && Ptr_) ?
                        (new ChrString(*Ptr_)):
                        Ptr_;

  delete _TagContent;
  _TagContent = Str_;

  return *this;
}

/****************************************************************************/
TagDictionary* TagLineInfo::GiveTagDictionary()
{
  return (_TagStack ? _TagStack->GiveTagDictionary():NULL);
}

/****************************************************************************/
TagParseInfo* TagLineInfo::GiveTagParseInfo()
{
  return (_TagStack ? _TagStack->GiveTagParseInfo():NULL);
}

/****************************************************************************/
MEMORYOPS_DEFN(TagLineInfo)

/****************************************************************************/
// TagErrorTracker class definition
/****************************************************************************/
TagErrorTracker::TagErrorTracker(TagReader* Trd_):
_TagReader(Trd_),

_FilePosRec(NULL),
_Dictionary(NULL),
_TagCommentData(NULL),
_KeyValueData(NULL)
{
  if (_TagReader)
  {
    _FilePosRec = _TagReader->GiveFilePosition();
    _Dictionary = _TagReader->GiveTagDictionary();
    _TagCommentData = _TagReader->GiveCommentData();
    _KeyValueData = _TagReader->GiveKeyValuePairData();
  }
}

/****************************************************************************/
TagErrorTracker::~TagErrorTracker()
{}

/****************************************************************************/
TagErrorTracker* TagErrorTracker::Make(TagReader* Trd_)
{
  return (new TagErrorTracker(Trd_));
}

/****************************************************************************/
bool TagErrorTracker::HasError() const
{
  if (_TagReader)
    return (_TagReader->TagParseError() != 0);

  return false;
}

/****************************************************************************/
int TagErrorTracker::TagParseError() const
{
  if (_TagReader)
    return _TagReader->TagParseError();

  return 0;
}

/****************************************************************************/
FilePosition* TagErrorTracker::GiveFilePosition()
{
  return _FilePosRec;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagErrorTracker)

/****************************************************************************/
// TagReader::TagParseData class definition
/****************************************************************************/
TagParseData::TagParseData():
_TagLinkedFwd(false),
_ChildrenCreated(false),
_ChildVisited(false),
_PairEndingTag(false),
_EndingTagPopped(false),

_MaxTags(0),
_TagFwdLink(NULL),
_StkNodeFwdLink(NULL),
_StartTagVector(NULL),
_EndTagVector(NULL),
_CreatedStartLine(NULL),
_CreatedEndLine(NULL)
{
  ::memset(_CreatedTags, 0, sizeof(long) * 10);
}

/****************************************************************************/
bool TagParseData::TagCreated(long snl, long sn)
{
  // new
  int x;
  for (x = 0; x < _MaxTags; x+=2)
    if (_CreatedTags[x] == snl+1 &&
        _CreatedTags[x] == sn+1)
      return true;

  return false;
}

/****************************************************************************/
void TagParseData::ClearTags()
{
  ::memset(_CreatedTags, 0, sizeof(long) * 10);
  _MaxTags = 0;
}

/****************************************************************************/
void TagParseData::Reset()
{
  ClearTags();

  _TagLinkedFwd = false;
  _ChildrenCreated = false;
  _ChildVisited = false;
  _PairEndingTag = false;
  _EndingTagPopped = false;

  _TagFwdLink = NULL;
  _StkNodeFwdLink = NULL;
  _StartTagVector = NULL;
  _EndTagVector = NULL;
  _CreatedStartLine = NULL;
  _CreatedEndLine = NULL;
}

/****************************************************************************/
void TagParseData::CreateTag(long snl, long sn)
{
  if (_MaxTags < 10)
  {
    _CreatedTags[_MaxTags++] = snl+1;
    _CreatedTags[_MaxTags++] = sn+1;
  }
}

/****************************************************************************/
// TagReader class definition
/****************************************************************************/
TagReader::TagReader(int DocType_):
TagParseInfo(NULL),

_LineBuf(NULL),
_File(new FileReader),

_ParseByParts(false),
_TagBalance(0),
_TagSetsFound(0),
_TagPosAdvCnt(0),
_NumUnorderedTags(0),

_Coords(NULL),
_CoordsSize(0),
_MaxNestLevel(0),

_AtNewPos(false),
_AtCurrentPos(false),

_TPData(NULL),
_TCoord(NULL),
_OldTCoord(NULL),
_RootStack(NULL),
_TagStack(TagStack::Make(NULL, 0, NULL, NULL)),
_TagVect(NULL),
_TagError(NULL),
_Nodep(NULL),

_FilePosRec(NULL)
{
  int IoMode_ = TextLineEnums::FILE_INPUT;
  TagCoordData* TCdata_ = NULL;

  _LineBuf = new TextFileLineBuffer(_File, IoMode_);
  InitLineBuffer();
  _FilePosRec = _LineBuf->GetFilePosition();

  #if TAGREADER_TAGSTACK_DEBUG
    TagTypeInfo::SetShowDebugDump(true, true);
  #endif
  TagDictionary* TagDict_ = new TagDictionary;
  TagDict_->InitAllHtmlTagSwitches();

  _Nodep = NodeNestingData::MakeNode();
  CreateCoords();

  SetTagDictionary(TagDict_);
  SetDocType(DocType_);

  _RootStack = _TagStack;
  _TagStack->SetTagReader(this);

  _TPData = new TagParseData();
  TCdata_ = TagCoordData::Make(_RootStack, NULL, 0);
  TCdata_->SetReadOnly(true);

  _RootStack->SetFromCoordData(TCdata_, 0);
  _TCoord = TagCoordSpecifier::Make(TCdata_);
}

/****************************************************************************/
TagReader::~TagReader()
{
  SeekRootPos(false);

  _LineBuf->Close();
  delete _LineBuf;
  _LineBuf = NULL;

  if (_RootStack)
  {
    if (_TCoord)
    {
      *_TCoord = _RootStack->FromCoordData();
      _TCoord->SetReadOnly(false);
    }

    _RootStack->SetFromCoordData(NULL);
    delete _TCoord;
    _TCoord = NULL;
  }

  delete _TagStack;
  _TagStack = NULL;
  _RootStack = NULL;

  delete _File;
  _File = NULL;

  delete _Dictionary;
  _Dictionary = NULL;

  delete _Nodep;
  _Nodep = NULL;

  delete _TPData;
  _TPData = NULL;
}

/****************************************************************************/
void TagReader::InitLineBuffer()
{
  if (!_LineBuf)
    return;

  _LineBuf->InitStdHtmlTags();
  _LineBuf->SetDefaultToDelims(TextFileLineBuffer::LAST_SET);
}

/****************************************************************************/
void TagReader::SetTextBuffer()
{
  SetTextBufferPtr(&_Buffer);
  ResetReadPos();
}

/****************************************************************************/
int TagReader::CountUnorderedTags()
{
  if (!_OrderedTagsFound)
  {
    if (PrevUnorderedTag())
      _NumUnorderedTags++;
    else
      _OrderedTagsFound = PrevTagInfoSet();
  }

  return _NumUnorderedTags;
}

/****************************************************************************/
TagReader& TagReader::SetInputFile(const ChrString& Fname_)
{
  _MainFileName = Fname_;
  if (_File && _LineBuf->FileOpened())
    _LineBuf->Close();

  return *this;
}

/****************************************************************************/
TagCoordSpecifier* TagReader::MakeTagCoordCopy(TagCoordSpecifier* TCoord_, bool Swap_)
{
  if (TCoord_)
  {
    TagCoordSpecifier* NewCopy_ = TagCoordSpecifier::Make(*TCoord_);
    _OldTCoord = TCoord_;

    if (Swap_)
      _OldTCoord = NewCopy_;
    else
      TCoord_ = NewCopy_;
  }

  return TCoord_;
}

/****************************************************************************/
TagCoordSpecifier* TagReader::RestoreTagCoordCopy(TagCoordSpecifier* TCoord_)
{
  TagCoordSpecifier* RetPtr_ = NULL;

  bool HasNewCopy_ = _OldTCoord && _OldTCoord != TCoord_;
  bool HasOldCopy_ = _OldTCoord && _OldTCoord != _TCoord;
  bool NotUpdated_ = !_TagVect ||
                     _TCoord->GiveCoordData() != _TagVect->NextCoordData();

  if (HasNewCopy_)
  {
    if (TCoord_)
    {
      delete TCoord_;
      RetPtr_ = _OldTCoord;
      _OldTCoord = NULL;
    }
    else if (_TCoord && HasOldCopy_)
    {
      if (NotUpdated_)
        _TCoord->RestoreFrom(_OldTCoord);

      delete _OldTCoord;
      _OldTCoord = NULL;
      RetPtr_ = _TCoord;
    }
  }

  return RetPtr_;
}

/****************************************************************************/
void TagReader::CreateCoords(int sz)
{
  if (_Coords)
    return;

  _CoordsSize = sz ? sz:TagEnums::GROWINCR;
  _Coords = new_long_array(_CoordsSize, NULL);
  ::memset(_Coords, -1, _CoordsSize);
  _Coords[_MaxNestLevel++] = 0;
}

/****************************************************************************/
void TagReader::GrowCoords(int sz)
{
  long* oldv = _Coords;
  long oldsz = _CoordsSize;
  long incr = sz ? sz:TagEnums::GROWINCR;

  _CoordsSize += incr;
  _Coords = new_long_array(_CoordsSize, _Coords);
  ::RawDeleteArray(oldv);
  ::memset(&_Coords[oldsz], -1, incr);
}

/****************************************************************************/
TagVector* TagReader::SeekPos(bool Create_, bool NewPos_,
                              TagCoordSpecifier* NewCopy_)
{
  // Format of coordinate vector:
  //     Coord[0][1][2] ... [n]
  //     index n into Coord array represents nesting level of TagStack object
  //     value of dereference Coord array element represents sequence number
  //     of TagVector object.
  //
  if (!_TCoord)
    return _TagVect;

  long slvl;
  long vind;
  long rslvl;
  long rcslvl;

  if (NewPos_)
  {
    slvl = _TCoord->NewStackNestLevel();
    vind = _TCoord->NewVectorIndexPos();
    rslvl = _TCoord->NewStackNestLevel(false);
    rcslvl = _TCoord->NewChildStackLevel(false);
  }
  else
  {
    slvl = _TCoord->StackNestLevel();
    vind = _TCoord->VectorIndexPos();
    rslvl = _TCoord->StackNestLevel(false);
    rcslvl = _TCoord->ChildStackLevel(false);
  }

  if (slvl < 0 || vind < 0)
    return _TagVect;

  bool Found_ = false;
  TagVector* NewVect_ = NULL;

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<(NewPos_ ? "TagReader::SetNewPos:":
                      "TagReader::SetCurrentPos:") <<endl;
    cout <<"\tslvl: " <<slvl <<endl
         <<"\tvind: " <<vind <<endl;
  #endif

  if (_MaxNestLevel <= rslvl || _MaxNestLevel <= rcslvl)
  {
    if (_TCoord->ChildStackLevelSpec())
      while (_MaxNestLevel <= rslvl &&
             _MaxNestLevel < _CoordsSize)
        _Coords[_MaxNestLevel++] = 0;

    if (_TCoord->StackNestLevelSpec())
      while (_MaxNestLevel <= rcslvl &&
             _MaxNestLevel < _CoordsSize)
        _Coords[_MaxNestLevel++] = 0;

    if (_MaxNestLevel >= _CoordsSize)
    {
      #if TAGREADER_CREATEFROMSNI_DEBUG
        cout <<"\tGrowCoords() ..." <<endl;
      #endif

      GrowCoords();
    }

    return SeekPos(Create_, NewPos_, NewCopy_);
  }
  else
  {
    _Coords[slvl] = vind;

    NewVect_ =
    _TagStack->GiveTagFromCoordinate(Create_, _Coords, NewPos_, _TCoord, &Found_);

    if (NewPos_)
      _AtNewPos = Found_ && NewVect_;
    else
      _AtCurrentPos = Found_ && NewVect_;

    if (NewVect_)
    {
      _TagVect = NewVect_;

      if (NewVect_->NextCoordData())
      {
        NewCopy_ = NULL;
        *_TCoord = _TagVect;
        _TagStack = _TCoord->GiveCoordData()->Next();
      }
    }
  }

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<(NewPos_ ? "TagReader::SetNewPos:":
                      "TagReader::SetCurrentPos:") <<endl;
    cout <<"\t_TagVect: " <<_TagVect <<endl
         <<"\t_TagStack: " <<_TagStack <<endl;

    if (NewPos_)
      cout <<"\t_AtNewPos: " <<_AtNewPos <<endl;
    else
      cout <<"\t_AtCurrentPos: " <<_AtCurrentPos <<endl;
  #endif

  _TCoord = RestoreTagCoordCopy(NewCopy_);
  return _TagVect;
}

/****************************************************************************/
TagVector* TagReader::SeekRootPos(bool Create_)
{
  if (!_TCoord)
    return _TagVect;

  bool Found_ = false;
  bool AtRootPos_ = false;

  TagVector* NewVect_ = NULL;
  long oldv = _Coords[0];

  TagCoordSpecifier* NewCopy_ = MakeTagCoordCopy(_TCoord, false);
  _TCoord = NewCopy_;

  _TCoord->SetChildStackLevel(0, false);
  _TCoord->SetChildVectorIndex(0, false);
  _TCoord->SetStackNestLevel(0, true);
  _TCoord->SetVectorIndexPos(0, true);

  _Coords[0] = 0;
  _TagStack = _RootStack;

  NewVect_ =
  _TagStack->GiveTagFromCoordinate(Create_, _Coords, true, _TCoord, &Found_);
  AtRootPos_ = Found_ && NewVect_;

  _AtNewPos = false;
  _AtCurrentPos = false;
  _Coords[0] = oldv;

  if (NewVect_)
  {
    _TagVect = NewVect_;

    if (NewVect_->NextCoordData())
    {
      NewCopy_ = NULL;
      *_TCoord = _TagVect;
      _TagStack = _TCoord->GiveCoordData()->Next();
    }
  }

  _TCoord = RestoreTagCoordCopy(NewCopy_);
  return _TagVect;
}

/****************************************************************************/
TagCoordSpecifier* TagReader::PopChildStack()
{
  // new
  if (_TPData->IsPairEndingTag() && !_TPData->EndingTagPopped() && _TagVect)
  {
    TagCoordData* PoppedNode_ = NULL;
    TagVector* ParVect_ = _TagVect;
    TagVector* OldVect_ = NULL;

    while (ParVect_ && OldVect_ != ParVect_ &&
           !(ParVect_->CurrCoordData() && ParVect_->NextCoordData()))
    {
      OldVect_ = ParVect_;
      ParVect_ = ParVect_->CurrCoordData() ? ParVect_:
                 ParVect_->NextCoordData() ?
                     ParVect_->NextCoordData()->Parent():
                     NULL;
    }

    if (ParVect_)
    {
      _TagVect = ParVect_;
      PoppedNode_ = _TagVect->PopStack();
      *_TCoord = _TagVect->EraseNextLevel(PoppedNode_);
      _TPData->SetEndingTagPopped(true);
    }
  }

  return _TCoord;
}

/****************************************************************************/
bool TagReader::HasChildTags(StackNodeInfo* Ptr_)
{
  if (!_Nodep->ThisTag() && !_Nodep->StartTag() && !Ptr_)
    return false;

  long psn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->ParentSequenceNumber():
             Ptr_              ? Ptr_->ParentSequenceNumber():0;
  long sn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->SequenceNumber():
            Ptr_              ? Ptr_->SequenceNumber():0;

  return (psn > sn || (psn == 0 && psn == sn && !Ptr_->Next()));
}

/****************************************************************************/
bool TagReader::IsEnclosedTag(StackNodeInfo* Ptr_,
                              NodeNestingData* NestNode_, int pnc)
{
  if (!_Nodep->EndTag() && !Ptr_)
    return false;

  long psn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->ParentSequenceNumber():
             Ptr_              ? Ptr_->ParentSequenceNumber():0;
  long sn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->SequenceNumber():
            Ptr_              ? Ptr_->SequenceNumber():0;
  long nc = (_Nodep->EndTag() || !_Nodep->GiveThisTag()) ?
                (Ptr_ ? Ptr_->NumChildren():0):
                _Nodep->GiveThisTag()->NumChildren();

  bool EnclosedTag_ = !(Ptr_ && Ptr_->PairEnderFound()) &&
                      (psn < sn && nc == 0 && pnc > 0);

  return EnclosedTag_;
}

/****************************************************************************/
bool TagReader::IsParentTag(StackNodeInfo* Ptr_, NodeNestingData* NestNode_)
{
  if (!_Nodep->EndTag() && !Ptr_)
    return false;

  // Next Sequence Number:
  int nxsn = Ptr_->NextSequenceNumber();
  long psn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->ParentSequenceNumber():
             Ptr_              ? Ptr_->ParentSequenceNumber():0;
  long sn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->SequenceNumber():
            Ptr_              ? Ptr_->SequenceNumber():0;
  long nc = (_Nodep->EndTag() || !_Nodep->ThisTag()) ?
                (Ptr_ ? Ptr_->NumChildren():0):
                _Nodep->GiveThisTag()->NumChildren();

  return
  (
    Ptr_->ContainerTagFound() ||
    Ptr_->StdTagFound() ||
    (Ptr_->IsOptionalOrNoContentTag() &&
    !Ptr_->SingletonTagFound() && !Ptr_->EmptyTagFound()) &&

    sn == 0 && sn == nxsn && psn > nxsn  &&
    Ptr_->NestLevel() < Ptr_->NextNestLevel() &&
    (Ptr_->NumChildren() > 0 || _TPData->HasTagFwdLink())
  );
}

/****************************************************************************/
NodeNestingData* TagReader::FindParentSequenceNumber(StackNodeInfo* Ptr_, int& psn)
{
  // 0     (HEAD-103:11),1x2,11: </head>
  // from: (HEAD-103:10)++
  // Parent Sequence Number:
  psn = Ptr_->ParentSequenceNumber();
  StackNodeFinder* Finder_ = new StackNodeFinder(Ptr_);
  NodeNestingData* NestNode_ = Finder_->FindThisNestingNode();

  if (!NestNode_)
  {
    // no nesting node found so assign to null
    _Nodep->SetThisTag(NULL);
    _Nodep->SetTagParent(NULL);
  }
  else
  {
    _Nodep->SetThisTag(NestNode_->GiveThisTag());
    _Nodep->SetTagParent(NestNode_->GiveTagParent());
  }

  if (!_Nodep->ThisTag())
  {
    NestNode_ = Finder_->FindEndTagNestingNode();

    if (NestNode_)
    {
      _Nodep->SetStartTag(NestNode_->GiveStartTag());
      _Nodep->SetEndTag(NestNode_->GiveEndTag());
    }
    else
      _Nodep->SetStartTag(NULL);
      _Nodep->SetEndTag(NULL);
  }
  else
    _Nodep->SetStartTag(NULL);
    _Nodep->SetEndTag(NULL);

  psn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->ParentSequenceNumber():
        Ptr_              ? Ptr_->ParentSequenceNumber():0;

  HasTagLinkForward(Ptr_, NestNode_);

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindParentSequenceNumber:" <<endl;
    cout <<"\tpsn: " <<psn <<endl;
    cout <<"\tNestNode_: " <<NestNode_ <<endl;
    cout <<"\t_Nodep->ThisTag(): " <<_Nodep->ThisTag() <<endl
         <<"\t_Nodep->TagParent(): " <<_Nodep->TagParent() <<endl;
    cout <<"\t_Nodep->StartTag(): " <<_Nodep->StartTag() <<endl
         <<"\t_Nodep->EndTag(): " <<_Nodep->EndTag() <<endl;
  #endif

  delete Finder_;
  return NestNode_;
}

/****************************************************************************/
int TagReader::FindNextSequenceNumber(StackNodeInfo* Ptr_)
{
  // 0    1039,1,2-0L2: <BODY bgcolor="#000080" text="#FFFF00" vlink="#FF0000">
  // (HTML-97:1)++
  // Next Sequence Number:
  int nxsn = Ptr_->NextSequenceNumber();

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindNextSequenceNumber:" <<endl;
    cout <<"\tnxsn: " <<nxsn <<endl;
  #endif

  return nxsn;
}

/****************************************************************************/
void TagReader::FindNumChildren(StackNodeInfo* Ptr_, NodeNestingData* NestNode_,
                                int& pnc, int& nc)
{
  // 2         (HTML-97:2)
  // Parent Num Children:
  pnc = 0;
  nc = 0;

  if (_Nodep->TagParent())
    pnc = _Nodep->GiveTagParent()->NumChildren(); // pnc == 2
  else if (_Nodep->EndTag())
  {
    _Nodep->SetTagParent(NestNode_->GiveThisTag());

    if (_Nodep->TagParent())
      pnc = _Nodep->GiveTagParent()->NumChildren(); // pnc == 2

    _Nodep->SetTagParent(NULL);

  }
  else if (Ptr_)
    pnc = Ptr_->ParentNumChildren();

  nc = (_Nodep->EndTag() || !_Nodep->ThisTag()) ?
          (Ptr_ ? Ptr_->NumChildren():0):
          _Nodep->GiveThisTag()->NumChildren(); // nc == 0

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindNumChildren:" <<endl;
    cout <<"\tpnc: " <<pnc <<endl
         <<"\tnc: " <<nc <<endl
         <<"\t_Nodep->TagParent(): " <<_Nodep->TagParent() <<endl;
  #endif
}

/****************************************************************************/
int TagReader::FindCurrentLevel(StackNodeInfo* Ptr_, int& clvl, int& chdlvl)
{
  // 1        1031,1x2,x:
  // Current Level:
  clvl = 0;
  chdlvl = 0;

  int parlvl = 0;
  int snl = -1;

  if (_Nodep->TagParent() || _Nodep->ThisTag())
  {
    clvl = Ptr_->NestLevel();
    if (_Nodep->TagParent())
      parlvl = _Nodep->GiveTagParent()->NestLevel();

    if (_Nodep->TagParent() && parlvl < clvl)
    {
      snl = _Nodep->GiveTagParent()->NestLevel()+1;
      chdlvl = Ptr_ ? Ptr_->ChildNestLevel():
               _Nodep->ThisTag() ? _Nodep->GiveThisTag()->ChildNestLevel():0;
    }
    else if (_Nodep->ThisTag())
    {
      snl = _Nodep->GiveThisTag()->NestLevel();
      chdlvl = _Nodep->GiveThisTag()->ChildNestLevel();
    }
    else if (_Nodep->TagParent())
    {
      snl = _Nodep->GiveTagParent()->NextNestLevel();
      chdlvl = Ptr_ ? Ptr_->ChildNestLevel():0;
    }

    if (snl >= 0)
    {
      if (snl < _TCoord->StackOffset())
        snl = _TCoord->StackOffset();

      if (chdlvl < _TCoord->StackOffset())
        chdlvl = _TCoord->StackOffset();

      clvl = snl;
    }
  }
  else if (_Nodep->EndTag() &&
           _Nodep->GiveEndTag()->ChildNestLevel() == _Nodep->GiveEndTag()->NestLevel()+1)
  {
    snl = _Nodep->GiveEndTag()->NestLevel();
    chdlvl = _Nodep->GiveEndTag()->ChildNestLevel();

    if (snl >= 0)
    {
      if (snl < _TCoord->StackOffset())
        snl = _TCoord->StackOffset();

      if (chdlvl < _TCoord->StackOffset())
        chdlvl = _TCoord->StackOffset();

      clvl = snl;
    }
  }
  else if (Ptr_)
  {
    snl = Ptr_->NestLevel();
    chdlvl = Ptr_->ChildNestLevel();

    if (snl >= 0)
    {
      if (snl < _TCoord->StackOffset())
        snl = _TCoord->StackOffset();

      if (chdlvl < _TCoord->StackOffset())
        chdlvl = _TCoord->StackOffset();

      clvl = snl;
    }
  }

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindCurrentLevel:" <<endl;
    cout <<"\tclvl: " <<clvl <<endl
         <<"\tchdlvl: " <<chdlvl <<endl;
    if (snl >= 0)
      cout <<"\tsnl: " <<snl <<endl;
    else
      cout <<"\tsnl: NA" <<endl;
  #endif

  return snl;
}

/****************************************************************************/
void TagReader::FindChildLevel(StackNodeInfo* Ptr_, int& chdlvl)
{
  // 3       1031,1x2,11: </head>
  // from: (HEAD-103:10)++
  // Child Level:
  if (_Nodep->EndTag() &&
      _Nodep->GiveEndTag()->ChildNestLevel() == _Nodep->GiveEndTag()->NestLevel()+1)
  {
    chdlvl = _Nodep->GiveEndTag()->ChildNestLevel();

    if (chdlvl < _TCoord->StackOffset())
      chdlvl = _TCoord->StackOffset();
  }
  else if (Ptr_)
  {
    chdlvl = Ptr_->ChildNestLevel();

    if (chdlvl < _TCoord->StackOffset())
      chdlvl = _TCoord->StackOffset();
  }

  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindChildLevel:" <<endl;
    cout <<"\tchdlvl: " <<chdlvl <<endl;
  #endif
}

/****************************************************************************/
int TagReader::FindSequenceNumber(StackNodeInfo* Ptr_)
{
  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindSequenceNumber: (Start)" <<endl;
  #endif

  #if TAGREADER_CREATEFROMSNI3_DEBUG
    cout <<"TagReader::FindSequenceNumber: (Start)\n"
         <<"  Ptr_->TagStr: " <<Ptr_->GiveTagStr() <<endl;
  #endif

  // 11      1031,1x2,11: </head>
  // from: (HEAD-103:10)++
  // Sequence Number:
  int sn = _Nodep->GiveThisTag() ? _Nodep->GiveThisTag()->SequenceNumber():
           Ptr_                  ? Ptr_->SequenceNumber():0;
  bool EndTagFound_ = (_Nodep && _Nodep->EndTag()) &&
                      (Ptr_ && Ptr_->PairEnderFound());

  if (EndTagFound_)
    sn = (_Nodep && _Nodep->EndTag()) ?
              _Nodep->GiveEndTag()->SequenceNumber():
              Ptr_->SequenceNumber();

  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    cout <<"\tsn: "  <<sn <<endl;
    cout <<"TagReader::FindSequenceNumber: (End)"
         <<endl <<endl;
  #endif

  return sn;
}

/****************************************************************************/
int TagReader::FindEncounteredLevel(StackNodeInfo* Ptr_)
{
  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindEncounteredLevel: (Start)" <<endl;
  #endif

  #if TAGREADER_CREATEFROMSNI3_DEBUG
    cout <<"TagReader::FindEncounteredLevel: (Start)\n"
         <<"  Ptr_->TagStr: " <<Ptr_->GiveTagStr() <<endl;
  #endif

  int nlvl = Ptr_->NextNestLevel();

  if (nlvl < _TCoord->StackOffset())
    nlvl = _TCoord->StackOffset();

  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    cout <<"\tnlvl: " <<nlvl <<endl;
    cout <<"TagReader::FindEncounteredLevel: (End)"
         <<endl <<endl;
  #endif

  return nlvl;
}

/****************************************************************************/
bool TagReader::SetNestedTags(StackNodeInfo* Ptr_, int psn,
                              int pnc, int nc, int nlvl,
                              int& snl, int& chdlvl,
                              bool& SnlSet_, bool& ChdlvlSet_)
{
  #if TAGREADER_CREATEFROMSNI_DEBUG
    cout <<"TagReader::FindNestedTags: (Start)" <<endl;
  #endif

  #if TAGREADER_CREATEFROMSNI3_DEBUG
    cout <<"TagReader::FindNestedTags: (Start)\n"
         <<"  Ptr_->TagStr: " <<Ptr_->GiveTagStr() <<endl;
  #endif

  // 11      1031,1x2,11: </head>
  // from: (HEAD-103:10)++
  // Sequence Number:
  TagVector* tv = NULL;   // tag vector pointer

  int Offset_ = 0;
  int sn = _Nodep->ThisTag() ? _Nodep->GiveThisTag()->SequenceNumber():
           Ptr_              ? Ptr_->SequenceNumber():0;

  bool CoordCreated_ = false;
  bool EnclosedTag_ = IsEnclosedTag(Ptr_, _Nodep, pnc);
  bool IsParent_ = IsParentTag(Ptr_, _Nodep);
  bool HasChildren_ = HasChildTags(Ptr_);

  TagCoordSpecifier* NewCopy_ = MakeTagCoordCopy(_TCoord, false);
  _TCoord = NewCopy_;
  SnlSet_ = ChdlvlSet_ = false;

  if (_Nodep->EndTag() &&
      _Nodep->GiveEndTag()->ChildNestLevel() == _Nodep->GiveEndTag()->NestLevel()+1)
    _TCoord->SetStackNestLevel(chdlvl, true);
  else
    _TCoord->SetStackNestLevel(snl, true);

  if (_Nodep->ThisTag() || !_Nodep->EndTag() || IsParent_ || EnclosedTag_)
  {
    // This tag has childred <std-tag> so create children vector indexes
    if (_TPData->HasTagFwdLink() && !ChildVectorCreated() && IsParent_ && HasChildren_)
    {
      if (!_TPData->ChildrenCreated())
      {
        _TPData->SetChildrenCreated(true);
        _TCoord->SetChildStackLevel(nlvl, true);
        _TCoord->SetMaxChildren(nc+2, true);
        _TCoord->SetStackNestLevel(snl, true);
        _TCoord->SetVectorIndexPos(psn, true);
        tv = SeekNewPos(true, NewCopy_);

        if (tv)
        {
          CommitNewPos();
          CoordCreated_ = true;

          snl = _TCoord->StackNestLevel(false);
          SnlSet_ = true;
        }
      }

      if (tv && !_TPData->ChildVisited())
      {
        if (CoordCreated_)
        {
          _TCoord =
          NewCopy_ = MakeTagCoordCopy(_TCoord, false);
          CoordCreated_ = false;
          SnlSet_ = false;
        }

        _TCoord->SetStackNestLevel(nlvl, true);
        _TCoord->SetVectorIndexPos(0, true);
        _TCoord->SetChildStackLevel(0, false);
        _TCoord->SetChildVectorIndex(0, false);

        if (SeekNewPos(false, NewCopy_) && _TPData)
        {
          CommitNewPos();
          CoordCreated_ = true;

          _TPData->SetChildVisited(true);
          chdlvl = nlvl;
          snl = _TCoord->StackNestLevel(false);

          SnlSet_ = true;
          ChdlvlSet_ = true;
        }
      }
    }
    else if (EnclosedTag_)
    {
      // This tag is an enclosed tag of a parent tag so create child tag.
      // Child vector indexes should already exist.
      _TCoord->SetStackNestLevel(snl, true);
      _TCoord->SetVectorIndexPos(sn, true);
      _TCoord->SetChildStackLevel(0, false);
      _TCoord->SetChildVectorIndex(0, false);
      tv = SeekNewPos(false, NewCopy_);

      if (tv && _TPData)
      {
        CommitNewPos();
        CoordCreated_ = true;

        _TPData->SetChildVisited(true);
        snl = _TCoord->StackNestLevel(false);
        Offset_ = snl - _TCoord->StackOffset();
        SnlSet_ = true;

        if (!_TPData->HasTagFwdLink() && !_TPData->TagCreated(Offset_, sn))
        {
          #if TAGREADER_CREATEFROMSNI3_DEBUG
            cout <<" TagReader::FindEncounteredLevel:\n"
                 <<"  TagLineInfo::CreateFromStackNodeInfo(Ptr_) Called" <<endl;
          #endif

          tv->GiveTagLineInfo()->CreateFromStackNodeInfo(this, Ptr_, CoordCreated_);
        }
      }
    }
    else if (Ptr_->UnorderedTag() && !ChildVectorCreated())
    {
      if (!_TPData->ChildrenCreated())
      {
        int MaxTags_ = (_NumUnorderedTags >= MAXTAG_MARGIN) ?
                            (_NumUnorderedTags + MAXTAG_MARGIN):
                            MAXTAG_MARGIN;

        _TPData->SetChildrenCreated(true);
        _TCoord->SetChildStackLevel(nlvl, true);
        _TCoord->SetMaxChildren(MaxTags_, true);
        _TCoord->SetStackNestLevel(snl, true);
        _TCoord->SetVectorIndexPos(sn, true);
        tv = SeekNewPos(true, NewCopy_);

        if (tv)
        {
          CommitNewPos();
          CoordCreated_ = true;

          snl = _TCoord->StackNestLevel(false);
          SnlSet_ = true;
        }
      }

      if (tv && !_TPData->ChildVisited())
      {
        if (CoordCreated_)
        {
          _TCoord =
          NewCopy_ = MakeTagCoordCopy(_TCoord, false);
          CoordCreated_ = false;
          SnlSet_ = false;
        }

        _TCoord->SetStackNestLevel(nlvl, true);
        _TCoord->SetVectorIndexPos(0, true);
        _TCoord->SetChildStackLevel(0, false);
        _TCoord->SetChildVectorIndex(0, false);
        tv = SeekNewPos(false, NewCopy_);

        if (tv && _TPData)
        {
          CommitNewPos();
          CoordCreated_ = true;

          _TPData->SetChildVisited(true);
          chdlvl = nlvl;
          snl = _TCoord->StackNestLevel(false);
          Offset_ = snl - _TCoord->StackOffset();

          SnlSet_ = true;
          ChdlvlSet_ = true;

          if (!_TPData->TagCreated(Offset_, sn))
          {
            #if TAGREADER_CREATEFROMSNI3_DEBUG
              cout <<" TagReader::FindEncounteredLevel:\n"
                   <<"  TagLineInfo::CreateFromStackNodeInfo(Ptr_) Called" <<endl;
            #endif

            tv->GiveTagLineInfo()->CreateFromStackNodeInfo(this, Ptr_, CoordCreated_);
          }
        }
      }
    }
  }
  else if (_Nodep && _Nodep->EndTag() && _Nodep->StartTag() ||
           (Ptr_ && (Ptr_->StdTagFound() || Ptr_->PairEnderFound())))
  {
    sn = ((_Nodep && _Nodep->EndTag()) ||
          (Ptr_ && Ptr_->PairEnderFound())) ?
              (_Nodep->EndTag() ? _Nodep->GiveEndTag()->SequenceNumber():
                                  Ptr_->SequenceNumber()):
         ((_Nodep && _Nodep->StartTag()) ||
          (Ptr_ && Ptr_->StdTagFound())) ?
              (_Nodep->StartTag() ? _Nodep->GiveStartTag()->SequenceNumber():
                                    Ptr_->SequenceNumber()):0;

    _TCoord->SetStackNestLevel(chdlvl, true);
    _TCoord->SetVectorIndexPos(sn, true);
    _TCoord->SetChildStackLevel(0, false);
    _TCoord->SetChildVectorIndex(0, false);
    tv = SeekNewPos(false, NewCopy_);

    if (tv && _TPData)
    {
      CommitNewPos();
      CoordCreated_ = true;

      _TPData->SetChildVisited(true);
      _TPData->SetPairEndingTag(true);
      _TPData->SetEndingTagPopped(false);
      snl = _TCoord->StackNestLevel(false);
      Offset_ = snl - _TCoord->StackOffset();
      SnlSet_ = true;

      if (!_TPData->HasTagFwdLink() && !_TPData->TagCreated(Offset_, sn))
      {
        #if TAGREADER_CREATEFROMSNI3_DEBUG
          cout <<" TagReader::FindNestedTags:\n"
               <<"  TagLineInfo::CreateFromStackNodeInfo(Ptr_) Called" <<endl;
        #endif

        tv->GiveTagLineInfo()->CreateFromStackNodeInfo(this, Ptr_, CoordCreated_);
      }
    }
  }

  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    cout <<"\tpsn: " <<psn <<endl
         <<"\tsn: "  <<sn <<endl
         <<"\tnc: "  <<nc <<endl;
    cout <<"TagReader::FindNestedTags: (End)"
         <<endl <<endl;
  #endif

  return CoordCreated_;
}

/****************************************************************************/
bool TagReader::HasTagLinkForward(StackNodeInfo* Ptr_, NodeNestingData* NestNode_)
{
  if (!Ptr_ || !NestNode_ || !_TPData)
    return false;

  bool fnd = false;
  StackNodeInfo* TpPtr_ = NestNode_->GiveTagParent();
  StackNodeInfo* ThPtr_ = NestNode_->GiveThisTag();
  StackNodeInfo* StPtr_ = NestNode_->GiveStartTag();
  StackNodeInfo* EtPtr_ = NestNode_->GiveEndTag();
  StackNodeFinder* Finder_ = new StackNodeFinder(TpPtr_);

  NodeNestingData* Nodep_ = (StPtr_ && EtPtr_ && Ptr_ == StPtr_) ? NestNode_:
                            (ThPtr_ && TpPtr_ && Ptr_ == ThPtr_) ?
                                Finder_->FindStartTagNodeMatchingPtr(ThPtr_, &fnd):
                                NULL;

  _TPData->SetTagLinkedFwd(Nodep_ &&
                           Nodep_->StartTag() && Nodep_->EndTag());

  if (_TPData->TagLinkedFwd())
  {
    _TPData->SetTagFwdLink(Nodep_);
    _TPData->SetStkNodeFwdLink(NULL);
  }
  else if (Ptr_->ForwardLink())
  {
    _TPData->SetTagFwdLink(NULL);
    _TPData->SetStkNodeFwdLink(Ptr_->ForwardLink());
    _TPData->SetTagLinkedFwd(true);
  }
  else
  {
    _TPData->SetTagFwdLink(NULL);
    _TPData->SetStkNodeFwdLink(NULL);
  }

  delete Finder_;
  return _TPData->HasTagFwdLink();
}

/****************************************************************************/
void TagReader::SetTagLinkForward(StackNodeInfo* Ptr_, NodeNestingData* NestNode_,
                                  bool ChildCreated_, int snl, int chdlvl,
                                  bool SnlSet_, bool ChdlvlSet_)
{
  if (!Ptr_ || !NestNode_ || !_TPData || !_TPData->HasTagFwdLink())
    return;

  int sn = 0;
  bool EndTagImplied_ = false;
  bool SingletonTag_ = false;
  bool UnorderedTag_ = false;
  bool CoordCreated_ = false;

  TagCoordSpecifier* NewCopy_ = MakeTagCoordCopy(_TCoord, false);
  _TCoord = NewCopy_;

  ChrString ContentStr_;
  NodeNestingData* Nodep_ = NULL;
  TagVector* stv = NULL;   // starting tag vector pointer
  TagVector* etv = NULL;   // ending tag vector pointer

  StackNodeInfo* TpPtr_ = NestNode_->GiveTagParent();
  StackNodeInfo* ThPtr_ = NestNode_->GiveThisTag();
  StackNodeInfo* StPtr_ = NestNode_->GiveStartTag();
  StackNodeInfo* EtPtr_ = NestNode_->GiveEndTag();  
  
  #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
       (TAGREADER_CREATEFROMSNI3_DEBUG))
    Nodep_ = _TPData->GiveTagFwdLink();
    cout <<"TagReader::SetTagLinkForward: (Start)" <<endl
         <<"\tGiveTagFwdLink(): "       <<_TPData->GiveTagFwdLink() <<endl;
    cout <<"\tNodep_->StartTag(): " <<Nodep_->StartTag() <<endl
         <<"\tNodep_->EndTag(): "   <<Nodep_->EndTag() <<endl;
    cout <<"\tGiveStkNodeBackLink(): "  <<_TPData->GiveStkNodeBackLink() <<endl
         <<"\tGiveStkNodeFwdLink(): "   <<_TPData->GiveStkNodeFwdLink() <<endl;
    Nodep_ = NULL;
  #endif

  if (_TPData->TagLinkedFwd() && _TPData->ChildrenCreated())
  {
    if (_TPData->GiveTagFwdLink())
    {
      Nodep_ = _TPData->GiveTagFwdLink();
      StPtr_ = Nodep_->GiveStartTag();
      EtPtr_ = Nodep_->GiveEndTag();
    }
    else if (_TPData->GiveStkNodeFwdLink() &&
             Ptr_->ForwardLink() == _TPData->GiveStkNodeFwdLink())
    {
      StPtr_ = _TPData->GiveStkNodeBackLink();
      EtPtr_ = _TPData->GiveStkNodeFwdLink();
    }

    if (ChdlvlSet_)
      snl = chdlvl;
    else if (!SnlSet_)
      snl = _TCoord->StackOffset();

    sn = EtPtr_->SequenceNumber();
    _TCoord->SetStackNestLevel(snl, true);
    _TCoord->SetVectorIndexPos(sn, true);
    etv = SeekNewPos(false, NewCopy_);

    if (etv)
    {
      CommitNewPos();
      CoordCreated_ = true;
      snl = _TCoord->StackNestLevel(false);
    }

    if (CoordCreated_)
    {
      _TCoord =
      NewCopy_ = MakeTagCoordCopy(_TCoord, false);
      CoordCreated_ = false;
    }

    sn = StPtr_->SequenceNumber();
    _TCoord->SetStackNestLevel(snl, true);
    _TCoord->SetVectorIndexPos(sn, true);
    stv = SeekNewPos(false, NewCopy_);

    if (stv)
    {
      CommitNewPos();
      CoordCreated_ = true;
      snl = _TCoord->StackNestLevel(false);
    }

    if (stv && etv)
    {
      _TPData->SetStartTagVector(stv);
      _TPData->SetEndTagVector(etv);

      #if TAGREADER_CREATEFROMSNI3_DEBUG
        cout <<" TagReader::SetTagLinkForward:\n"
             <<"  TagLineInfo::CreateFromStackNodeInfo(Ptr_) Called" <<endl;
      #endif

      stv->GiveTagLineInfo()->CreateFromStackNodeInfo(this, Ptr_, ChildCreated_);
    }

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"\tsn: "  <<sn <<endl
           <<"\tstv: " <<stv <<endl
           <<"\tetv: " <<etv <<endl;
      cout <<"TagReader::SetTagLinkForward: (End)"
           <<endl <<endl;
    #endif
  }
}

/****************************************************************************/
TagLineInfo* TagReader::CreateFromStackNodeInfo(StackNodeInfo* Ptr_)
{
  if (!_TPData)
    return NULL;

  int psn = 0;      // parent sequence number
  int pnc = 0;      // parent num children
  int nc = 0;       // num children
  int clvl = 0;     // current level
  int chdlvl = 0;   // child level
  int nlvl = 0;     // nest level
  int snl = 0;      // stack nesting level

  bool ChildCreated_ = false;  // new stack and vector coordinate created
  bool SnlSet_ = false;
  bool ChdlvlSet_ = false;

  _TPData->Reset();

  NodeNestingData* NestNode_ = FindParentSequenceNumber(Ptr_, psn);
  FindNumChildren(Ptr_, NestNode_, pnc, nc);
  snl = FindCurrentLevel(Ptr_, clvl, chdlvl);
  FindChildLevel(Ptr_, chdlvl);
  nlvl = FindEncounteredLevel(Ptr_);

  ChildCreated_ = SetNestedTags(Ptr_, psn, pnc, nc, nlvl,
                                snl, chdlvl, SnlSet_, ChdlvlSet_);
  SetTagLinkForward(Ptr_, NestNode_, ChildCreated_,
                    snl, chdlvl, SnlSet_, ChdlvlSet_);
  PopChildStack();

  return _TPData->GiveCreatedStartLine();
}

/****************************************************************************/
// Method to walk TagStack tree structure
//
void TagReader::WalkTagStack()
{
  // new
  _TPData->Reset();
  SeekRootPos(true);
  cout <<" TagReader::WalkTagStack (start): " <<this <<endl;
  _TagStack->WalkTagStack(0);
  cout <<" TagReader::WalkTagStack (endl): " <<this <<endl;
}

/****************************************************************************/
bool TagReader::PosAdvCntAtMax() const
{
  return (!_TagSetsFound || _TagPosAdvCnt >= _TagSetsFound);
}

/****************************************************************************/
TagParseInfo& TagReader::AdvanceReadPos()
{
  if (!_ParseByParts || (!PosAdvCntAtMax() && _TagSetsFound))
  {
    _TagPosAdvCnt++;

    if (_Dictionary)
    {
      _Dictionary->AdvanceReadPos();
      _EofFound = _Dictionary->EofFound();
      _DocType = _Dictionary->DocTypeSpecified();
      _TagInfo = _Dictionary->GeneralSearchTag();
    }

    if (_TagPosAdvCnt > _TagSetsFound)
      _TagPosAdvCnt = _TagSetsFound;
  }

  return *this;
}

/****************************************************************************/
TagParseInfo& TagReader::ResetReadPos()
{
  if (!_ParseByParts || _TagSetsFound)
  {
    _TagPosAdvCnt = 0;

    if (_Dictionary)
    {
      _Dictionary->ResetReadPos();
      _EofFound = _Dictionary->EofFound();
      _DocType = _Dictionary->DocTypeSpecified();
      _TagInfo = _Dictionary->GeneralSearchTag();

      if (_TagInfo)
        _TagInfo->ResetReadPos();
    }
  }

  return *this;
}

/****************************************************************************/
TagTypeInfo* TagReader::GiveReadTagEntry(bool& NoContent_)
{
  ChrString TagStr_;
  ChrString StartBrk_;
  ChrString EndBrk_;
  TagTypeInfo* TagPtr_ = NULL;

  int TagPos_ = 0;
  int TagType_ = 0;
  bool TagFound_ = false;

  TagStr_ = _LineBuf->TagBuffer();
  TagType_ = TagBracketList::GiveTagType(TagStr_);
  TagStr_ = TagBracketList::StripTagBrackets(TagStr_, TagType_,
                                             &StartBrk_, &EndBrk_);
  TagStr_ = TagBracketList::FilterTagElementStr(TagStr_);
  TagPos_ = TagTypeInfo::GiveTagPosForTagType(TagType_);
  TagFound_ = GiveTagDictionary()->TagStrLookupEqual(TagPos_, TagStr_,
                                                     &StartBrk_, &EndBrk_);
  TagPtr_ = TagFound_ ? GiveTagDictionary()->DictionarySearchTag():NULL;
  NoContent_ = GiveTagDictionary()->NonContentTypeTagFound();

  return TagPtr_;
}

/****************************************************************************/
TagReader& TagReader::ReadAllTags()
{
  TagTypeInfo* TagPtr_ = NULL;

  bool TagIncr_ = false;
  bool LegalTag_ = false;
  bool NoContent_ = false;
  bool DoBreak_ = false;
  bool TextRead_ = false;
  bool StartTagFound_ = false;
  bool EndTagFound_ = false;
  bool TermTagFound_ = false;
  bool NoDictTag_ = _DocType != TagEnums::HTML_FILE &&
                    _DocType != TagEnums::XHTML_FILE;

  int brkcon_ = 0;
  int SavedSet_;
  int cnt = 0;
  int max = 10000;
  int taglim_ = 0;
  int PrevTagBal_ = _TagBalance;

  _LineBuf->SetXmlTypeTag(true);
  _LineBuf->SetQuitReadOnFirstDelimSetFound(true, true);
  _LineBuf->SetQuitReadOnLastDelimSetFound(true, true);
  _ParseByParts = false;
  _Buffer.SetEmpty();

  SavedSet_ = _TagSetsFound;
  _TagSetsFound = 0;

  while (!DoBreak_ &&
         !_LineBuf->EofFound() &&
         _LineBuf->While_ReadLine())
  {
    // break at EOF when nothing is read
    if (_LineBuf->EofFound() && _LineBuf->ReadBufferLen() == 0)
    {
      brkcon_ = _LineBuf->EofFound() ? 0:1;
      break;
    }

    if (_LineBuf->TagStrAvailable())
    {
      TagIncr_ = false;
      TextRead_ = true;
      TagPtr_ = GiveReadTagEntry(NoContent_);
      _Buffer += _LineBuf->TotalTextRead();

      if (_LineBuf->DelimSetsFound())
      {
        TagIncr_ = true;
        _TagSetsFound++;

        if (!NoContent_ && TagPtr_)
        {
          PrevTagBal_ = _TagBalance;

          if (TagPtr_->IsContainerTag() &&
              !TagPtr_->IsOptionalPairTag())
            _TagBalance++;
          else if (TagPtr_->IsPairEnderTag())
            _TagBalance--;
          else
            LegalTag_ = TagPtr_->IsOptionalPairTag() ||
                        TagPtr_->IsSingletonTag() ||
                        TagPtr_->IsEmptyTag();
        }
      }

      if (_LineBuf->EolFound())
        _Buffer += ChrString("\n");
    }

    // reset line data after first tag read
    _LineBuf->ResetLineData();

    StartTagFound_ = _TagSetsFound > taglim_ &&
                     _TagBalance > 0 && PrevTagBal_ < _TagBalance &&
                     (TagPtr_ != NULL || NoDictTag_);
    EndTagFound_ = _TagSetsFound > 1 &&
                   _TagBalance > 0 && PrevTagBal_ > _TagBalance &&
                   (TagPtr_ != NULL || NoDictTag_);
    TermTagFound_ = _TagSetsFound > 1 &&
                    _TagBalance == 0 && PrevTagBal_ > _TagBalance &&
                    (TagPtr_ != NULL || NoDictTag_);

    if (_LineBuf->EofFound())
    {
      DoBreak_ = true;
      break;
    }
    else
    {
      DoBreak_ = cnt >= max;

      if (!DoBreak_)
      {
        if (!NoDictTag_ && !NoContent_)
        {
          LegalTag_ = LegalTag_ || StartTagFound_ ||
                      EndTagFound_ || TermTagFound_;

          if (StartTagFound_ && taglim_ == 0)
            ++taglim_;

          if (TagPtr_ == NULL)
          {
            if (TagIncr_)
              cnt = 0;
            else
              cnt++;
          }
          else if (!LegalTag_)
          {
            brkcon_ = 3;
            break;
          }
        }
      }
      else
      {
        brkcon_ = 2;
        break;
      }
    }
  }

  // if no tag sets found or read operation not done then
  // restore previously saved number of sets
  if (!_TagSetsFound && !NoDictTag_ && !TextRead_)
    _TagSetsFound = SavedSet_;
  else
  {
    if ((_TagSetsFound || NoDictTag_) && !SavedSet_)
      SetTextBuffer();
    else if ((SavedSet_ || NoDictTag_) && TextRead_)
      ResetReadPos();
  }

  return *this;
}

/****************************************************************************/
TagReader& TagReader::ReadNextTag()
{
  TagTypeInfo* TagPtr_ = NULL;

  bool TagIncr_ = false;
  bool LegalTag_ = false;
  bool NoContent_ = false;
  bool DoBreak_ = false;
  bool TextRead_ = false;
  bool StartTagFound_ = false;
  bool EndTagFound_ = false;
  bool TermTagFound_ = false;
  bool NoDictTag_ = _DocType != TagEnums::HTML_FILE &&
                    _DocType != TagEnums::XHTML_FILE;

  int brkcon_ = 0;
  int SavedSet_;
  int cnt = 0;
  int max = 10000;
  int taglim_ = 0;
  int PrevTagBal_ = _TagBalance;

  _LineBuf->SetXmlTypeTag(true);
  _LineBuf->SetQuitReadOnFirstDelimSetFound(true, true);
  _LineBuf->SetQuitReadOnLastDelimSetFound(true, true);
  _ParseByParts = true;
  _Buffer.SetEmpty();

  SavedSet_ = _TagSetsFound;
  _TagSetsFound = 0;

  while (!DoBreak_ &&
         !_LineBuf->EofFound() &&
         _LineBuf->While_ReadLine())
  {
    // break at EOF when nothing is read
    if (_LineBuf->EofFound() && _LineBuf->ReadBufferLen() == 0)
    {
      brkcon_ = _LineBuf->EofFound() ? 0:1;
      break;
    }

    if (_LineBuf->TagStrAvailable())
    {
      TagIncr_ = false;
      TextRead_ = true;
      TagPtr_ = GiveReadTagEntry(NoContent_);
      _Buffer += _LineBuf->TotalTextRead();

      if (_LineBuf->DelimSetsFound())
      {
        TagIncr_ = true;
        _TagSetsFound++;

        if (!NoContent_ && TagPtr_)
        {
          PrevTagBal_ = _TagBalance;

          if (TagPtr_->IsContainerTag() &&
              !TagPtr_->IsOptionalPairTag())
            _TagBalance++;
          else if (TagPtr_->IsPairEnderTag())
            _TagBalance--;
          else
            LegalTag_ = TagPtr_->IsOptionalPairTag() ||
                        TagPtr_->IsSingletonTag() ||
                        TagPtr_->IsEmptyTag();
        }
      }

      if (_LineBuf->EolFound())
        _Buffer += ChrString("\n");
    }

    // reset line data after first tag read
    _LineBuf->ResetLineData();

    StartTagFound_ = _TagSetsFound > 0 &&
                     _TagBalance > 0 && PrevTagBal_ < _TagBalance &&
                     (TagPtr_ != NULL || NoDictTag_);
    EndTagFound_ = _TagSetsFound > 1 &&
                   _TagBalance > 0 && PrevTagBal_ > _TagBalance &&
                   (TagPtr_ != NULL || NoDictTag_);
    TermTagFound_ = _TagSetsFound > 1 &&
                    _TagBalance == 0 && PrevTagBal_ > _TagBalance &&
                    (TagPtr_ != NULL || NoDictTag_);

    // do another read operation to find tag after first tag is extracted
    if (StartTagFound_ && !_LineBuf->EofFound())
    {
      cnt = 0;
      DoBreak_ = false;
      StartTagFound_ = false;
      EndTagFound_ = false;

      if (taglim_ == 0)
        ++taglim_;

      while (!DoBreak_ &&
             !_LineBuf->EofFound() &&
             _LineBuf->While_ReadLine())
      {
        if (_LineBuf->EofFound() && _LineBuf->ReadBufferLen() == 0)
        {
          brkcon_ = _LineBuf->EofFound() ? 0:1;
          break;
        }

        if (_LineBuf->TagStrAvailable())
        {
          TagIncr_ = false;
          TextRead_ = true;
          TagPtr_ = GiveReadTagEntry(NoContent_);
          _Buffer += _LineBuf->TotalTextRead();

          if (_LineBuf->DelimSetsFound())
          {
            TagIncr_ = true;
            _TagSetsFound++;

            if (!NoContent_ && TagPtr_)
            {
              PrevTagBal_ = _TagBalance;

              if (TagPtr_->IsContainerTag() &&
                  !TagPtr_->IsOptionalPairTag())
                _TagBalance++;
              else if (TagPtr_->IsPairEnderTag())
                _TagBalance--;
              else
                LegalTag_ = TagPtr_->IsOptionalPairTag() ||
                            TagPtr_->IsSingletonTag() ||
                            TagPtr_->IsEmptyTag();
            }
          }

          if (_LineBuf->EolFound())
            _Buffer += ChrString("\n");
        }

        // reset line data after next tag read
        _LineBuf->ResetLineData();

        StartTagFound_ = _TagSetsFound > 1 &&
                         _TagBalance > 0 && PrevTagBal_ < _TagBalance &&
                         (TagPtr_ != NULL || NoDictTag_);
        EndTagFound_ = _TagSetsFound > 1 &&
                       _TagBalance > 0 && PrevTagBal_ > _TagBalance &&
                       (TagPtr_ != NULL || NoDictTag_);
        TermTagFound_ = _TagSetsFound > 1 &&
                        _TagBalance == 0 && PrevTagBal_ > _TagBalance &&
                        (TagPtr_ != NULL || NoDictTag_);

        // break from method after total tag balance value reaches zero
        // when previously the tag balance value is non-zero.
        if (_LineBuf->EofFound())
        {
          DoBreak_ = true;
          break;
        }
        else
        {
          DoBreak_ = TermTagFound_ || cnt >= max;

          if (!DoBreak_)
          {
            if (!NoDictTag_ && !NoContent_)
            {
              LegalTag_ = LegalTag_ || StartTagFound_ || EndTagFound_;

              if (TagPtr_ == NULL)
              {
                if (TagIncr_)
                  cnt = 0;
                else
                  cnt++;
              }
              else if (!LegalTag_)
              {
                brkcon_ = 3;
                break;
              }
            }
          }
          else
          {
            brkcon_ = 2;
            break;
          }
        }
      }
    }
    else
    {

      DoBreak_ = StartTagFound_ || cnt >= max;

      if (!DoBreak_)
      {
        if (!NoDictTag_ && !NoContent_)
        {
          LegalTag_ = LegalTag_ || EndTagFound_ || TermTagFound_;

          if (TagPtr_ == NULL)
          {
            if (TagIncr_)
              cnt = 0;
            else
              cnt++;
          }
          else if (!LegalTag_)
          {
            brkcon_ = 3;
            break;
          }
        }
      }
      else
      {
        brkcon_ = 2;
        break;
      }
    }
  }

  // if no tag sets found or read operation not done then
  // restore previously saved number of sets
  if (!_TagSetsFound && !NoDictTag_ && !TextRead_)
    _TagSetsFound = SavedSet_;
  else
  {
    if ((_TagSetsFound || NoDictTag_) && !SavedSet_)
      SetTextBuffer();
    else if ((SavedSet_ || NoDictTag_) && TextRead_)
      ResetReadPos();
  }

  return *this;
}

/****************************************************************************/
TagReader& TagReader::ParseTextStr()
{
  int x = 0;
  bool Found_ = true;
  const TagSearchResult* SrchRes_;
  TagDictionary* TagDict_;

  _ParseByParts = false;
  _OrderedTagsFound = false;

  while (Found_)
  {
    SrchRes_ = SearchForTag();
    TagDict_ = GiveTagDictionary();

    if (SrchRes_ && TagDict_)
    {
      #if TAGREADER_PARSESTR_DEBUG
        TagDict_->DumpSearchResults(cout);
      #endif

      CountUnorderedTags();
      AdvanceReadPos();
    }
    else
      Found_ = false;
  }

  #if TAGREADER_TAGINFOLISTWALKDUMP
    TagInfoListWalkDump(cout);
  #endif

  StackNodeInfo* StkInfop = ResetStackPtr(TagLinksSequencer::INFO_STACK,
                                          TagLinksSequencer::TAIL);
  SeekRootPos(true);

  do
  {
    #if TAGREADER_CREATEFROMSNI_DEBUG
      cout <<"** TagReader::CreateFromStackNodeInfo **" <<endl;
    #endif

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"--ITER#=" <<x <<" : " <<endl;
    #endif

    CreateFromStackNodeInfo(StkInfop);
    x++;
  }
  while (StkInfop = PrevStackPtr(TagLinksSequencer::INFO_STACK));

  #if TAGREADER_CREATEFROMSNI2_DEBUG
    WalkTagStack();
  #endif

  return *this;
}

/****************************************************************************/
TagReader& TagReader::ParseDocument()
{
  int x = 0;
  bool Found_ = true;
  const TagSearchResult* SrchRes_;
  TagDictionary* TagDict_;

  _ParseByParts = false;
  _OrderedTagsFound = false;

  if (!_LineBuf || !_File || !_MainFileName.strlen())
    return *this;

  if (!_LineBuf->FileOpened())
    _LineBuf->Open(_MainFileName.c_str(), ios::in);

  ReadAllTags();

  if (_TagSetsFound)
    while (Found_)
    {
      SrchRes_ = SearchForTag();
      TagDict_ = GiveTagDictionary();

      if (SrchRes_ && TagDict_)
      {
        #if TAGREADER_PARSEDOC_DEBUG
          TagDict_->DumpSearchResults(cout);
        #endif

        CountUnorderedTags();
        AdvanceReadPos();
      }
      else
        Found_ = false;
    }

  #if TAGREADER_TAGINFOLISTWALKDUMP
    TagInfoListWalkDump(cout);
  #endif

  StackNodeInfo* StkInfop = ResetStackPtr(TagLinksSequencer::INFO_STACK,
                                          TagLinksSequencer::TAIL);
  SeekRootPos(true);

  do
  {
    #if TAGREADER_CREATEFROMSNI_DEBUG
      cout <<"** TagReader::CreateFromStackNodeInfo **" <<endl;
    #endif

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"--ITER#=" <<x <<" : " <<endl;
    #endif

    CreateFromStackNodeInfo(StkInfop);
    x++;
  }
  while (StkInfop = PrevStackPtr(TagLinksSequencer::INFO_STACK));

  #if TAGREADER_CREATEFROMSNI2_DEBUG
    WalkTagStack();
  #endif

  return *this;
}

/****************************************************************************/
TagReader& TagReader::ParseDocumentByParts()
{
  int x = 0;
  bool Found_ = true;
  const TagSearchResult* SrchRes_;
  TagDictionary* TagDict_;

  _ParseByParts = true;
  _OrderedTagsFound = false;

  if (!_LineBuf || !_File || !_MainFileName.strlen())
    return *this;

  if (!_LineBuf->FileOpened())
    _LineBuf->Open(_MainFileName.c_str(), ios::in);

  ReadNextTag();

  while (_TagSetsFound && !_LineBuf->EofFound())
  {
    while (Found_ && !PosAdvCntAtMax())
    {
      SrchRes_ = SearchForTag();
      TagDict_ = GiveTagDictionary();

      if (SrchRes_ && TagDict_)
      {
        #if TAGREADER_PARSEDOC2_DEBUG
          TagDict_->DumpSearchResults(cout);
        #endif

        CountUnorderedTags();
        AdvanceReadPos();
      }
      else
        Found_ = false;
    }

    ReadNextTag();
    Found_ = true;
  }

  #if TAGREADER_TAGINFOLISTWALKDUMP
    TagInfoListWalkDump(cout);
  #endif

  StackNodeInfo* StkInfop = ResetStackPtr(TagLinksSequencer::INFO_STACK,
                                          TagLinksSequencer::TAIL);
  SeekRootPos(true);

  do
  {
    #if TAGREADER_CREATEFROMSNI_DEBUG
      cout <<"** TagReader::CreateFromStackNodeInfo **" <<endl;
    #endif

    #if ((TAGREADER_CREATEFROMSNI_DEBUG) | \
         (TAGREADER_CREATEFROMSNI3_DEBUG))
      cout <<"--ITER#=" <<x <<" : " <<endl;
    #endif

    CreateFromStackNodeInfo(StkInfop);
    x++;
  }
  while (StkInfop = PrevStackPtr(TagLinksSequencer::INFO_STACK));

  #if TAGREADER_CREATEFROMSNI2_DEBUG
    WalkTagStack();
  #endif

  return *this;
}

/****************************************************************************/
NodeNestingData* TagReader::GiveNodeNestingData()
{
  return _Nodep;
}

/****************************************************************************/
FilePosition* TagReader::GiveFilePosition()
{
  return _FilePosRec;
}

/****************************************************************************/
MEMORYOPS_DEFN(TagReader)

/****************************************************************************/
/****************************************************************************/
#if TAGREADER_DEBUG
int main(int argc, char* argv[])
{
  #if TAGREADER_TAGTYPE_DEBUG

  // Sample html document segment
  /*
  <sample>xxx<sample>yyy</sample>zzz</sample>
  <nestedtag>xxxxxoooooxxxxxooooo <tag1 key1=val1 key2=val2>xxxxxoooooxxxxxooooo</tag1>"
  xxxxxoooooxxxxxooooo <tag2 key1=val1 key2=val2>xxxxxoooooxxxxxooooo</tag2></nestedtag>";
  */

    const char* Str_ =
      "<sample>xxx<sample>yyy</sample>zzz</sample>"
      "<nestedtag>xxxxxoooooxxxxxooooo <tag1 key1=\"val1\" key2=\"val2\">xxxxxoooooxxxxxooooo</tag1>"
      "xxxxxoooooxxxxxooooo <tag2 key1=\"val1\" key2=\"val2\">xxxxxoooooxxxxxooooo</tag2></nestedtag>";

    const char* SpecStr_ =
      "<TITLE>Software Projects</TITLE>"
      "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">"
      "<meta name=\"author\" content=\"Joseph Wong\">"
      "<link rel=\"Prev\""
      "      title=\"Cybernadian Computer Services\" type=\"text/html\""
      "      href=\"http://www.cybernadian.net/index.html\">";

    TagTypeInfo::SetShowDebugDump(true, false);
    int TagBits_[TagTypeInfo::MAX_TAGINDEXES];
    bool Found_ = true;

    ::memset(TagBits_, 0, TagTypeInfo::MAX_TAGINDEXES);
    ChrString* pCStr_ = new ChrString(Str_);
    ChrString* spCStr_ = new ChrString(SpecStr_);
    TagTypeInfo* TagType_ = new TagTypeInfo();
    TagTypeInfo::TagSwitch TagSwitch_;
    TagType_->SetDocType(TagEnums::HTML_FILE);
    TagType_->InitAllHtmlTagSwitches(TagSwitch_);
    system("cls");

    // Methods tested:
    //
    //   int SetTagSwitches(TagSwitch& Switch_);
    //   int GiveExcludedTags(bool IsHtml_, bool IsEnd_, bool IsScript_,
    //                        bool IsDoc_, bool IsComment_, bool IsNestedComment_,
    //                        bool IsSingle_, bool IsCLang_, bool IsCppLang_);
    //
    //   bool GiveNextSwitches(TagSwitch& Switch_);
    //   bool SearchForTag(int& ExcludedTags_, long* Index_=NULL);
    //
    //   TagTypeInfo& SetDocType(int DocType_);
    //   TagTypeInfo& SetTextBufferPtr(ChrString* Ptr_);
    //   TagTypeInfo& AdvanceReadPos();
    //
    //   void InitAllHtmlTagSwitches(TagSwitch& Switch_);
    //
    //   void DumpSearchResults(ostream& os_, size_t fw_=20) const;
    //   Subscript ReadPos() const;
    //   bool ElementStr_Specified() const;
    //   const ChrString& ElementStr() const;
    //
    TagType_->SetTextBufferPtr(pCStr_);
    TagType_->ShouldDumpContents(true);
    cout <<"No tag specified -- general tag search:" <<endl;

    while (Found_)
    {
      TagType_->SetTagSwitches(TagSwitch_, TagBits_);
      Found_ = TagType_->SearchForTag(TagBits_);

      if (Found_)
      {
        TagType_->DumpSearchResults(cout);
        TagType_->AdvanceReadPos();

        TagType_->GiveNextSwitches(TagSwitch_);
      }
    }

    // Methods tested:
    //
    //   TagTypeInfo& Reset(int Spec_=ALL);
    //   TagTypeInfo& SetElementStr(bool Specified_, ChrString* Ptr_=NULL, bool KeepPtr_=false);
    //   TagTypeInfo& SetTagBrk(const char* Start_, const char* End_, long* Index_=NULL);
    //   TagTypeInfo& SetTagAttr(int TagAttr_);
    //
    //   void DumpSearchResults(ostream& os_, size_t fw_=20) const;
    //   Subscript ReadPos() const;
    //   bool ElementStr_Specified() const;
    //   const ChrString& ElementStr() const;
    //
    cout <<"Tag specified -- search for specific tag:" <<endl;
    TagType_->Reset();
    TagType_->ShouldDumpContents(false);
    TagType_->SetDocType(TagEnums::HTML_FILE);
    TagType_->SetTextBufferPtr(spCStr_);

    ::memset(TagBits_, 0, TagTypeInfo::MAX_TAGINDEXES);
    TagType_->SetTagBrk("<", ">");
    TagType_->SetElementStr(true, new ChrString("meta"), true);
    TagType_->SetTagAttr(TagEnums::SINGLETON_TAGATTR);
    Found_ = TagType_->SearchForTag(TagBits_);

    if (Found_)
      TagType_->DumpSearchResults(cout);
    else
      cout <<"*** Tag Element Not Found ***" <<endl;

    ::memset(TagBits_, 0, TagTypeInfo::MAX_TAGINDEXES);
    TagType_->AdvanceReadPos();
    TagType_->SetTagBrk("<", ">");
    TagType_->SetElementStr(true, new ChrString("link"), true);
    TagType_->SetTagAttr(TagEnums::SINGLETON_TAGATTR);
    Found_ = TagType_->SearchForTag(TagBits_);

    if (Found_)
      TagType_->DumpSearchResults(cout);
    else
      cout <<"*** Tag Element Not Found ***" <<endl;

    delete TagType_;
    delete pCStr_;
    delete spCStr_;
  #endif

  #if TAGREADER_TAGPARSE_DEBUG
    #if (!(TAGREADER_TAGSTACK_DEBUG))
      TagTypeInfo::SetShowDebugDump(true, true);
      TagDictionary* TagDict_ = new TagDictionary();
      TagDict_->InitAllHtmlTagSwitches();
      TagTypeInfo* vptr;
      TagTypeInfo* tinfo;
    #endif

    // Methods tested:
    //
    //   bool HasEntries(int TagPos_, TagTypeInfo* TagInfop_) const;
    //   TagDictionary& SetDocType(int DocType_);
    //   TagDictionary& SetTextBufferPtr(const ChrString* Ptr_);
    //   TagTypeInfo* CreateTag(int TagPos_, bool Empty_, int AppAttr_,
    //                          const ChrString& StartBrk_, const ChrString& Element_,
    //                          const ChrString& EndBrk_, TagTypeInfo* MatchingTag_);
    //   TagTypeInfo* MakeMatchTag(TagTypeInfo* StartTag_, bool SetMatchTag_, bool AddToList_);
    //

    #if TAGREADER_TAGDICTDUMP_DEBUG
      system("cls");
      TagDict_->DumpDictionary(cout);
    #else
      system("cls");
    #endif

    // Methods tested:
    //
    //   TagTypeInfo* GeneralSearchTag();
    //   TagTypeInfo* DictionarySearchTag();
    //   TagDictionary& SetEofFound(bool Eof_);
    //   TagDictionary& Reset(bool ReadPos_, bool TagSwitch_);
    //   bool HasEntries(int TagPos_, TagTypeInfo* TagInfop_) const;
    //
    //   const TagSearchResult* SearchForTag(int TagType_=0);
    //   const TagSearchResult* SearchForTag(int TagPos_, bool Empty_, bool Container_,
    //                                       int AppAttr_, const ChrString& StartBrk_,
    //                                       const ChrString& Element_, const ChrString& EndBrk_);
    //

  #if TAGREADER_USELONGSTR
    const char* HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<!--[if lt IE 7]>\n"
       "<style>div.page img.alpha{display:none}</style>\n"
       "<![endif]-->\n"
       "<TITLE>Software Projects</TITLE>\n"
       "<? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "<!-- This Is A Comment -->\n"
       "<meta name=\"author\" content=\"Joseph Wong\">\n"
       "<meta name=\"keywords\" lang=\"en-us\""
       "      content=\"computer,software,freeware,shareware,programs,programming,libraries,"
       "                CyberStar,cyber cafe,networks,networking,e-commerce,timers,remote,control,systems,"
       "                mcalc,qmcalc,math,arithmetic,mathematics,calculators,data structures,CardShark,"
       "                Card Shark,card games,gambling,black jack,BlackJack,casino\">"
       "    <link rel=\"Prev\""
       "     title=\"Cybernadian Computer Services\" type=\"text/html\""
       "     href=\"http://www.cybernadian.net/index.html\">\n"
       "</head><BODY bgcolor=\"#000080\" text=\"#FFFF00\" vlink=\"#FF0000\">\n"
       "<U><FONT SIZE=4><H1 ALIGN=\"CENTER\">Software Projects</H1>\n"
       "</FONT></U><FONT SIZE=4><p>\n"
       "   Here are some commercial and freeware software projects that I have completed."
       "   Right click on the link and choose"
       "   &quot;Save As&quot; from your browser to download."
       "<br><br>If you need an unzip utility to uncompress the following files you can get a free one from here:"
       "<br><a href=\"http://www.7-zip.org/\"><FONT COLOR=\"#00FF00\">www.7-zip.org</FONT></a>\n"
       "</p></font>\n"
       "<p>Click on the following links below to jump to the specific program section:\n"
       "<br><br>\n"
       "<h3 align=\"left\">\n"
       "<A HREF=\"software.html#CyberStar\"><FONT COLOR=\"#00FF00\" SIZE=4>CyberStar Online Timer &amp; Remote System Manager</FONT></a><br><br>\n"
       "<a HREF=\"software.html#Qmcalc\"><FONT COLOR=\"#00FF00\" SIZE=4>Qmcalc Graphic Scientific Calculator</FONT></a><br><br>\n"
       "<a href=\"#CardShark\"><font color=\"#00FF00\" SIZE=4>Card Shark Casino Card Games Analyzer</font></a><br><br>\n"
       "<a href=\"../index.html\"><FONT COLOR=\"#00FF00\" SIZE=4>Go Back To My Home Page</FONT></a>\n"
       "</h3>\n"
       "<p align=\"left\">\n"
       "<b><font color=\"#00FF00\"><a href=\"software2.html\">\n"
       "<span style=\"font-family: Times New Roman\"><font color=\"#00FF00\">Ch</font></span><font color=\"#00FF00\"><span lang=\"ZH-CN\" style=\"font-family: Times New Roman\">i</span><span style=\"font-family: Times New Roman\">nese\n"
       "Translation Of This Page</span><span lang=\"ZH-CN\" style=\"font-family: Times New Roman\">\n"
       "</span></font><span lang=\"EN-CA\" style=\"font-family: Times New Roman\">\n"
       "<font color=\"#00FF00\">(</font></span><font color=\"#00FF00\"><span lang=\"ZH-CN\" style=\"font-size: 12.0pt; font-family: SimSun\">&#20013;&#25991;&#32763;&#35695;</span><span style=\"font-family: Times New Roman\">)</span></font></a></font></b></p>\n"
       "</p><HR>\n"
       "<TABLE CellPadding=\"10\" Border=\"1\">\n"
       "<THEAD>\n"
       "<TR><TD ColSpan=\"7\"><H2 ALIGN=\"CENTER\"><a name=\"CyberStar\">CyberStar Online Timer &amp; Remote System Manager, For Windows NT/2000/XP Systems</a></h2>\n"
       "<TR><TH><FONT SIZE=4>Description\n"
       "<TH><FONT SIZE=4>Version\n"
       "<TH><FONT SIZE=4>Instruction Manual\n"
       "<TH><FONT SIZE=4>Screen Shots\n"
       "<TH><FONT SIZE=4>Zipped File\n"
       "<TH><FONT SIZE=4>Price\n"
       "<TH><FONT SIZE=4>Add To Cart\n"
       "</THEAD><TBODY>\n"
       "<TR><TD><FONT SIZE=4>Net cafe timer and remote computer manager.<br>\n"
       "    The Windows 95/98 timer client is also bundled with this file.<br>\n"
       "    Execute <b>CyberStar Timer.exe</b> from the zip file to install for XP systems.\n"
       "<TD><FONT SIZE=4>2.7.2\n"
       "<TD><A HREF=\"timerman/contents.html\"><FONT COLOR=\"#00FF00\" SIZE=4>Manual</FONT></A>\n"
       "<TD><A HREF=\"xptimershots.html\"><FONT COLOR=\"#00FF00\" SIZE=4>Screen Shots</FONT></A>\n"
       "<TD><A HREF=\"CyberStar-2.7.2.zip\"><FONT COLOR=\"#00FF00\" SIZE=4>CyberStar Timer (Zipped)</FONT></A>\n"
       "<TD>$25.00 for each client station, server is free.<br>\n"
       "    For quantity, enter the total number of clients you need to support on the next page.\n"
       "<TD><form target=\"paypal\" action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">\n"
       "<input type=\"hidden\" name=\"cmd\" value=\"_s-xclick\">\n"
       "<input type=\"hidden\" name=\"hosted_button_id\" value=\"BDZHPU8SY72CQ\">\n"
       "<table>\n"
       "<tr><td><input type=\"hidden\" name=\"on0\" value=\"software serial number\">software serial number</td></tr><tr><td>\n"
       "<input type=\"text\" name=\"os0\" maxlength=\"200\" size=\"20\"></td></tr>\n"
       "</table>\n"
       "<input type=\"image\" src=\"https://www.paypalobjects.com/en_US/i/btn/btn_cart_LG.gif\" border=\"0\" name=\"submit\" alt=\"PayPal - The safer, easier way to pay online!\" width=\"120\" height=\"26\">\n"
       "<img alt=\"\" border=\"0\" src=\"https://www.paypalobjects.com/en_US/i/scr/pixel.gif\" width=\"1\" height=\"1\">\n"
       "</form></TBODY></TABLE>\n"
       "<P><BR></P></body></html>";
  #elif TAGREADER_USENESTEDTABLESTR
    const char* HtmlStr_ =
       "<TABLE CellPadding=\"10\" Border=\"1\">\n"
       "<THEAD>\n"
       "<TR><TD ColSpan=\"7\"><H2 ALIGN=\"CENTER\"><a name=\"CyberStar\">CyberStar Online Timer &amp; Remote System Manager, For Windows NT/2000/XP Systems</a></h2>\n"
       "<TR><TH><FONT SIZE=4>Description\n"
       "<TH><FONT SIZE=4>Version\n"
       "<TH><FONT SIZE=4>Instruction Manual\n"
       "<TH><FONT SIZE=4>Screen Shots\n"
       "<TH><FONT SIZE=4>Zipped File\n"
       "<TH><FONT SIZE=4>Price\n"
       "<TH><FONT SIZE=4>Add To Cart\n"
       "</THEAD><TBODY>\n"
       "<TR><TD><FONT SIZE=4>Net cafe timer and remote computer manager.<br>\n"
       "    The Windows 95/98 timer client is also bundled with this file.<br>\n"
       "    Execute <b>CyberStar Timer.exe</b> from the zip file to install for XP systems.\n"
       "<TD><FONT SIZE=4>2.7.2\n"
       "<TD><A HREF=\"timerman/contents.html\"><FONT COLOR=\"#00FF00\" SIZE=4>Manual</FONT></A>\n"
       "<TD><A HREF=\"xptimershots.html\"><FONT COLOR=\"#00FF00\" SIZE=4>Screen Shots</FONT></A>\n"
       "<TD><A HREF=\"CyberStar-2.7.2.zip\"><FONT COLOR=\"#00FF00\" SIZE=4>CyberStar Timer (Zipped)</FONT></A>\n"
       "<TD>$25.00 for each client station, server is free.<br>\n"
       "    For quantity, enter the total number of clients you need to support on the next page.\n"
       "<TD><form target=\"paypal\" action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">\n"
       "<input type=\"hidden\" name=\"cmd\" value=\"_s-xclick\">\n"
       "<input type=\"hidden\" name=\"hosted_button_id\" value=\"BDZHPU8SY72CQ\">\n"
       "<table>\n"
       "<tr><td><input type=\"hidden\" name=\"on0\" value=\"software serial number\">software serial number</td></tr><tr><td>\n"
       "<input type=\"text\" name=\"os0\" maxlength=\"200\" size=\"20\"></td></tr>\n"
       "</table>\n"
       "<input type=\"image\" src=\"https://www.paypalobjects.com/en_US/i/btn/btn_cart_LG.gif\" border=\"0\" name=\"submit\" alt=\"PayPal - The safer, easier way to pay online!\" width=\"120\" height=\"26\">\n"
       "<img alt=\"\" border=\"0\" src=\"https://www.paypalobjects.com/en_US/i/scr/pixel.gif\" width=\"1\" height=\"1\">\n"
       "</form></TBODY></TABLE>\n";
  #elif TAGREADER_USESHORTSTR
    const char* HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<TITLE>Software Projects</TITLE>\n"
       "</head><BODY bgcolor=\"#000080\" text=\"#FFFF00\" vlink=\"#FF0000\">\n"
       "<br><a href=\"http://www.7-zip.org/\"><FONT COLOR=\"#00FF00\">www.7-zip.org</FONT></a>\n"
       "</body></html>\n";
  #else
    const char* HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<!--[if lt IE 7]>\n"
       "<style>div.page img.alpha{display:none}</style>\n"
       "<![endif]-->\n"
       "<TITLE>Software Projects</TITLE>\n"
       "<? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "<!-- This Is A Comment -->\n"
       "<meta name=\"author\" content=\"Joseph Wong\">\n"
       "<meta name=\"keywords\" lang=\"en-us\"\n"
       "      content=\"computer,software,freeware,shareware,programs,programming,libraries,\n"
       "               CyberStar,cyber cafe,networks,networking,e-commerce,timers,remote,control,systems,\n"
       "               mcalc,qmcalc,math,arithmetic,mathematics,calculators,data structures,CardShark,\n"
       "               Card Shark,card games,gambling,black jack,BlackJack,casino\">\n"
       "    <link rel=\"Prev\"\n"
       "     title=\"Cybernadian Computer Services\" type=\"text/html\"\n"
       "     href=\"http://www.cybernadian.net/index.html\">\n"
       "</head><BODY bgcolor=\"#000080\" text=\"#FFFF00\" vlink=\"#FF0000\">\n"
       "<U><FONT SIZE=4><H1 ALIGN=\"CENTER\">Software Projects</H1>\n"
       "</FONT></U><FONT SIZE=4><p>\n"
       "   Here are some commercial and freeware software projects that I have completed.\n"
       "   Right click on the link and choose\n"
       "   &quot;Save As&quot; from your browser to download.\n"
       "<br><br>If you need an unzip utility to uncompress the following files you can get a free one from here:\n"
       "<br><a href=\"http://www.7-zip.org/\"><FONT COLOR=\"#00FF00\">www.7-zip.org</FONT></a>\n"
       "</p></font></body></html>\n";
  #endif

    // Error case 1 : mismatched std-end pair
    const char* Err1HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<TITLE>Software Projects</P>\n"
       "<? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "</head></html>";

    // Error case 2 : overlapped std-end pairs
    const char* Err2HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<TITLE>Software <P>Projects</TITLE>\n"
       "</P><? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "</head></html>";

    // Error case 3 : unmatched std-end pairs
    const char* Err3HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "</TITLE>Software Projects<A href=\"http://www.7-zip.org/\">\n"
       "<? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "<img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "</head></html>";

    // Error case 4 : unmatched singleton end tag
    const char* Err4HtmlStr_ =
       "<!DOCTYPE html PUBLIC\n"
       "\"-//W3C//DTD HTML 4.01//EN\"\n"
       "\"http://www.w3.org/TR/html4/strict.dtd\">\n"
       "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">\n"
       "<TITLE>Software Projects</TITLE>\n"
       "<? phpinfo(); ?>\n"
       "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
       "</meta><img src=\"1aug2007open_images/img-gen6.png\" class=\"alpha\" style=\"left:479pt;top:25pt\"/>\n"
       "</head></html>";

    const char* CppStr_ =
       "// Cpp comment, 2015-06-28, Notes: =>\n"
       "int main(int argc, char* argv[])\n"
       "{\n"
       "  FunctionCall_A();\n"
       "/*[C comment, 2015-06-28, start:\n"
       "   Notes:]->\n"
       "  FunctionCall_B();\n"
       "   C comment block contents\n"
       "<-[C comment, 2015-06-28, end:]*/\n"
       "}\n";

    int Excl_ = 0;
    bool Found_ = true;

    ChrString* pHtmlStr_ = new ChrString(HtmlStr_);
    ChrString* pCppStr_ = new ChrString(CppStr_);
    const TagSearchResult* SrchRes_ = NULL;

    #if TAGREADER_TAGDICTIONARY_DEBUG
      // Setting document type to html
      // General tag search
      cout <<"No tag specified -- general tag search:" <<endl;
      TagDict_->Reset(true, true, TagEnums::HTML_FILE);
      TagDict_->SetTextBufferPtr(pHtmlStr_);
      TagDict_->ShouldDumpContents(true);
      Found_ = true;

      while (Found_)
      {
        SrchRes_ = TagDict_->SearchForTag(TagEnums::HTML_FILE);

        if (SrchRes_)
        {
          TagDict_->DumpSearchResults(cout);
          TagDict_->AdvanceReadPos();
        }
        else
          Found_ = false;
      }

      // Specified tag search
      cout <<"Tag specified -- search for specific tag:" <<endl;
      TagDict_->Reset(true, true, TagEnums::HTML_FILE);
    
      SrchRes_ = TagDict_->SearchForTag(TagEnums::FORBIDDEN, false, false, TagEnums::SINGLETON_TAGATTR,
                                        STDTAGOPEN_STR, ChrString("LINK"), STDTAGCLOSE_STR);

      if (SrchRes_)
      {
        TagDict_->DumpSearchResults(cout);
        TagDict_->AdvanceReadPos();
      }
      else
        cout <<"*** Tag Element Not Found ***" <<endl;

      SrchRes_ = TagDict_->SearchForTag(TagEnums::OPENING, false, false, TagEnums::PAIR_TAGATTR,
                                        STDTAGOPEN_STR, ChrString("FONT"), STDTAGCLOSE_STR);

      if (SrchRes_)
      {
        TagDict_->DumpSearchResults(cout);
        TagDict_->AdvanceReadPos();
      }
      else
        cout <<"*** Tag Element Not Found ***" <<endl;

      cout <<"Customized C/C++ Comment Tag Search -- search for C/C++ comment tags:" <<endl;
      TagDict_->Reset(true, true, TagEnums::CPP_FILE);
      TagDict_->InitCppLangTagSwitches();
      TagDict_->SetTextBufferPtr(pCppStr_);
      Found_ = true;

      while (Found_)
      {
        SrchRes_ = TagDict_->SearchForTag(TagEnums::CPP_FILE);

        if (SrchRes_)
        {
          TagDict_->DumpSearchResults(cout);
          TagDict_->AdvanceReadPos();
        }
        else
          Found_ = false;
      }
    #endif

    #if TAGREADER_TAGPARSEINFO_DEBUG
      // Methods tested:
      //
      //   int TagParseError() const;
      //   int TagTypeFound() const;
      //   int AnchorTypeFound() const;
      //
      //   TagStringData* Parent();
      //   TagTypeInfo* GetTagInfo();
      //
      //   TagParseInfo& SetParseHtmlTag(bool IsTag_);
      //   TagParseInfo& SetParseXHtmlTag(bool IsTag_);
      //   TagParseInfo& SetParseXmlTag(bool IsTag_);
      //   TagParseInfo& SetParseCppTag(bool IsTag_);
      //   TagParseInfo& SetParseCTag(bool IsTag_);
      //   TagParseInfo& SetParseNonStdTag(bool IsTag_);
      //   TagParseInfo& SetEofFound(bool Eof_);
      //
      //   TagParseInfo& SetTagDictionary(TagDictionary* Ptr_);
      //   TagParseInfo& SetKeyValuePairData(KeyValuePairData* Ptr_);
      //   TagParseInfo& SetCommentData(TagCommentData* Ptr_);
      //   TagParseInfo& SetTextBufferPtr(ChrString* Ptr_);
      //
      //   const TagSearchResult* SearchForTag();
      //   const TagSearchResult* SearchForTag(int TagPos_, bool Empty_, bool Container_,
      //                                       int AppAttr_, const char* StartBrk_,
      //                                       const ChrString& Element_, const char* EndBrk_);
      //
      TagParseInfo* TagParse_ = new TagParseInfo(NULL);
      TagParse_->SetTagDictionary(TagDict_);

      // Setting document type to html
      // General tag search
      #if TAGREADER_TAGGENSEARCH_DEBUG
        cout <<"TagParseInfo : No tag specified -- general tag search:" <<endl;
        TagParse_->SetTextBufferPtr(pHtmlStr_);
        TagParse_->Reset(true, true, TagEnums::HTML_FILE);
        TagParse_->SetParseHtmlTag(true);
        TagParse_->SetShowTagDump(true, true, true);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        #if TAGREADER_TAGINFOLISTWALKDUMP
          TagParse_->TagInfoListWalkDump(cout);
        #endif
      #else
        TagParse_->SetParseHtmlTag(true);
        TagParse_->SetShowTagDump(true, true, true);
      #endif

      #if TAGREADER_TAGLNKSEQUENCER_DEBUG
        ChrString* pErr1HtmlStr_ = new ChrString(Err1HtmlStr_);
        ChrString* pErr2HtmlStr_ = new ChrString(Err2HtmlStr_);
        ChrString* pErr3HtmlStr_ = new ChrString(Err3HtmlStr_);
        ChrString* pErr4HtmlStr_ = new ChrString(Err4HtmlStr_);

        // Error case 1 : mismatched std-end pair : <title>...</p>
        // Error : "<TITLE>Software Projects</P>"
        cout <<"Error case 1 : mismatched std-end pair : <title>...</p>" <<endl;
        TagParse_->Reset(true, true);
        TagParse_->SetTextBufferPtr(pErr1HtmlStr_);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        // Error case 2 : overlapped std-end pairs : <title><p>...</title></p>
        // Error : "<TITLE>Software <P>Projects</TITLE></P>"
        cout <<"Error case 2 : overlapped std-end pairs : <title><p>...</title></p>" <<endl;
        TagParse_->Reset(true, true);
        TagParse_->SetTextBufferPtr(pErr2HtmlStr_);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        // Error case 3 : unmatched std-end pairs : </title>...<a>
        // Error : "</TITLE>Software Projects<A href=\"http://www.7-zip.org/\">"
        cout <<"Error case 3 : unmatched std-end pairs : </title>...<a>" <<endl;
        TagParse_->Reset(true, true);
        TagParse_->SetTextBufferPtr(pErr3HtmlStr_);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        // Error case 4 : unmatched singleton end tag : <meta>...</meta>
        // Error : "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"></meta>"
        cout <<"Error case 4 : unmatched singleton end tag : <meta>...</meta>" <<endl;
        TagParse_->Reset(true, true);
        TagParse_->SetTextBufferPtr(pErr4HtmlStr_);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }
      #endif

      // Specified tag search
      #if TAGREADER_TAGSPECSEARCH_DEBUG
        cout <<"TagParseInfo : Tag specified -- search for specific tag:" <<endl;
        TagParse_->SetTextBufferPtr(pHtmlStr_);
        TagParse_->Reset(true, true, TagEnums::HTML_FILE);
        TagParse_->SetParseHtmlTag(true);
        TagParse_->SetShowTagDump(true, true, true);
    
        SrchRes_ = TagParse_->SearchForTag(TagEnums::FORBIDDEN, false, false, TagEnums::SINGLETON_TAGATTR,
                                         STDTAGOPEN_STR, ChrString("LINK"), STDTAGCLOSE_STR);
        TagDict_ = TagParse_->GiveTagDictionary();

        if (SrchRes_ && TagDict_)
        {
          TagDict_->DumpSearchResults(cout);
          TagParse_->AdvanceReadPos();
        }
        else
          cout <<"*** Tag Element Not Found ***" <<endl;

        SrchRes_ = TagParse_->SearchForTag(TagEnums::OPENING, false, false, TagEnums::PAIR_TAGATTR,
                                         STDTAGOPEN_STR, ChrString("FONT"), STDTAGCLOSE_STR);
        TagDict_ = TagParse_->GiveTagDictionary();

        if (SrchRes_ && TagDict_)
        {
          TagDict_->DumpSearchResults(cout);
          TagParse_->AdvanceReadPos();
        }
        else
          cout <<"*** Tag Element Not Found ***" <<endl;

        #if TAGREADER_TAGINFOLISTWALKDUMP
          TagParse_->TagInfoListWalkDump(cout);
        #endif

        cout <<"TagParseInfo : Customized C/C++ Comment Tag Search -- search for C/C++ comment tags:" <<endl;
        TagParse_->Reset(true, true, TagEnums::CPP_FILE);
        TagParse_->SetParseCppTag(true);
        TagParse_->SetTextBufferPtr(pCppStr_);
        Found_ = true;

        while (Found_)
        {
          SrchRes_ = TagParse_->SearchForTag();
          TagDict_ = TagParse_->GiveTagDictionary();

          if (SrchRes_ && TagDict_)
          {
            TagDict_->DumpSearchResults(cout);
            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        #if TAGREADER_TAGINFOLISTWALKDUMP
          TagParse_->TagInfoListWalkDump(cout);
        #endif
      #endif

      #if TAGREADER_TAGCOMMENT_DEBUG
        int cnt = 0;
        TagCommentData* TagComment_ = new TagCommentData(NULL);

        cout <<"Comment class parsing : parsing html comments tags" <<endl;
        TagComment_->SetCommentType(TagEnums::HTMLSTYLE);
        TagParse_->Reset(true, true, TagEnums::HTML_FILE);
        TagParse_->InitAllHtmlTagSwitches();
        TagParse_->SetParseHtmlTag(true);
        TagParse_->SetTextBufferPtr(pHtmlStr_);
        TagParse_->SetCommentData(TagComment_);
        TagParse_->SetShowTagDump(false, false, false);
        TagComment_->SetShowCommentDataDump(true);

        // Methods tested:
        //
        //   long ParseComment();
        //   long EncounterOpen(bool IntraCmnt_, bool BlockStart_);
        //   long EncounterClose(bool IntraCmnt_, bool BlockEnd_);
        //
        //   TagCommentData& SetSearchResult(const TagSearchResult* SrchRes_);
        //   TagCommentData& SetTextBufferPtr(ChrString* Ptr_);
        //
        //   void DumpParseResults(ostream& os_, size_t fw_=20) const;
        //
        Found_ = true;
        for (cnt = 0; Found_;)
        {
          SrchRes_ = TagParse_->SearchForTag();
          tinfo = TagParse_->GetTagInfo();

          if (SrchRes_ && tinfo)
          {
            if (tinfo->TagTypeFound() == TagEnums::COMMENT_TAG ||
                tinfo->TagTypeFound() == TagEnums::SCRIPT_TAG)
            {
              TagComment_->SetSearchResult(TagParse_->SearchResult());

              if (TagComment_->ParseComment() > 0)
              {
                TagComment_->DumpParseResults(cout);
                ++cnt;
                Found_ = cnt < 3;
              }
            }

            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        cout <<"Comment class parsing : parsing C/C++ comments tags" <<endl;
        TagComment_->SetCommentType(TagEnums::CPPSTYLE);
        TagParse_->Reset(true, true, TagEnums::CPP_FILE);
        TagParse_->InitCppLangTagSwitches();
        TagParse_->SetParseCppTag(true);
        TagParse_->SetTextBufferPtr(pCppStr_);
        TagParse_->SetCommentData(TagComment_);
        TagParse_->SetShowTagDump(false, false, false);
        TagComment_->SetShowCommentDataDump(true);

        Found_ = true;
        for (cnt = 0; Found_;)
        {
          SrchRes_ = TagParse_->SearchForTag();
          tinfo = TagParse_->GetTagInfo();

          if (SrchRes_ && tinfo)
          {
            if (tinfo->TagTypeFound() == TagEnums::CCOMMENTBLK_TAG ||
                tinfo->TagTypeFound() == TagEnums::CPPCOMMENTLINE_TAG)
            {
              TagComment_->SetSearchResult(TagParse_->SearchResult());

              if (TagComment_->ParseComment() > 0)
              {
                TagComment_->DumpParseResults(cout);
                ++cnt;
                Found_ = cnt < 2;
              }
            }

            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        delete TagComment_;
      #endif

      #if TAGREADER_KEYVALUEPAIR_DEBUG
        // Methods tested:
        //
        //   long ParseKVpair();
        //   bool TagFound(ChrString* Str_, long Pos_);
        //   bool EncounterTagOpen(Subscript* Index_, Subscript* Length_);
        //   bool EncounterTagClose(Subscript* Index_, Subscript* Length_);
        //
        //   KeyValuePairData& SetKVDelimiter(ChrString* Ptr_, bool KeepPtr_=false);
        //   KeyValuePairData& SetWspace(ChrString* Ptr_, bool KeepPtr_=false);
        //   KeyValuePairData& AddTagTerminator(ChrString* Ptr_, bool KeepPtr_=false);
        //   KeyValuePairData& ClearTagTerminators();
        //   KeyValuePairData& SetSearchResult(const TagSearchResult* SrchRes_);
        //   KeyValuePairData& SetTextBufferPtr(ChrString* Ptr_);
        //
        //   KeyValuePairData& AddPair(ChrString* Key_, ChrString* Value_, bool KeepPtr_=false);
        //   KeyValuePairNode* GiveKvPair(long Index_, bool* Found_=NULL);
        //

        int cnt = 0;
        KeyValuePairData* KvPairData_ =
            new KeyValuePairData(NULL,
                                 new ChrString("="),
                                 new ChrString(" \t"),
                                 new ChrString(">"), true);

        cout <<"Key-Value pair class parsing : parsing html comments tags" <<endl;
        TagParse_->Reset(true, true, TagEnums::HTML_FILE);
        TagParse_->InitAllHtmlTagSwitches();
        TagParse_->SetParseHtmlTag(true);
        TagParse_->SetTextBufferPtr(pHtmlStr_);
        TagParse_->SetKeyValuePairData(KvPairData_);
        TagParse_->SetShowTagDump(false, false, false);
        KvPairData_->SetShowKeyValuePairDump(true);

        Found_ = true;
        for (cnt = 0; Found_;)
        {
          SrchRes_ = TagParse_->SearchForTag();
          tinfo = TagParse_->GetTagInfo();

          if (SrchRes_ && tinfo)
          {
            if (tinfo->TagTypeFound() == TagEnums::STD_TAG ||
                tinfo->TagTypeFound() == TagEnums::EMPTY_TAG)
            {
              KvPairData_->SetSearchResult(TagParse_->SearchResult());

              if (KvPairData_->ParseKVpair() > 0)
              {
                KvPairData_->DumpParseResults(cout);
                ++cnt;
              }
            }

            TagParse_->AdvanceReadPos();
          }
          else
            Found_ = false;
        }

        delete KvPairData_;
      #endif

      delete TagParse_;
    #endif

    #if TAGREADER_TAGSTACK_DEBUG
      TagDictionary* TagDict_;
      const char* ParseStr_ =
        "<html>ooo<h1>xxx<h2>yyy</h2>zzz</h1>\n"
        "<applet>xxxxxoooooxxxxxooooo <font key1=val1 key2=val2>xxxxxoooooxxxxxooooo</font>\n"
        "xxxxxoooooxxxxxooooo <font key1=val1 key2=val2>xxxxxoooooxxxxxooooo</font>\n"
        "<head><title>Page Title</title></head>\n"
        "<body>\n"
        "<ul>\n"
        "<li>list item1\n"
        "<li>list item2\n"
        "<li>list item3\n"
        "</ul>\n"
        "</body>\n"
        "</applet>\n"
        "</html>";

      ChrString InFname_;
      ChrString* pParseStr_ = new ChrString(HtmlStr_);
      TagReader* Tread_ = new TagReader;
      TagDict_ = Tread_->GiveTagDictionary();
      TagErrorTracker* Terror_ = new TagErrorTracker(Tread_);

      // TO DO: Before coding for tag stack logic,
      //        should build linked list to be filled with relevant
      //        tag stack helper information.

      // Setting document type to html
      // General tag search
      cout <<"TagParseInfo : No tag specified -- general tag search:" <<endl;
      Tread_->Reset(true, true, TagEnums::HTML_FILE);
      Tread_->SetParseHtmlTag(true);
      TagDict_->ShouldDumpContents(true);

      #if TAGREADER_PARSESTR_DEBUG
        Tread_->SetTextBufferPtr(pParseStr_);
        Tread_->ParseTextStr();
      #elif TAGREADER_PARSEDOC_DEBUG
        InFname_ = "htmltxtstr3.html";
        Tread_->SetInputFile(InFname_);
        Tread_->ParseDocument();
      #elif TAGREADER_PARSEDOC2_DEBUG
        InFname_ = "htmltxtstr3.html";
        Tread_->SetInputFile(InFname_);
        Tread_->ParseDocumentByParts();
      #endif

      TagDict_ = NULL;
      delete pParseStr_;
      delete Tread_;
      delete Terror_;
    #endif

    delete pHtmlStr_;
    delete pCppStr_;
    delete TagDict_;
  #endif
}

#endif
/****************************************************************************/
#endif
