// File reader ADT class
//
#ifndef TEXTFILELINE_CPP
#define TEXTFILELINE_CPP
#ifndef TEXTFILELINE_H
  #include "textfileline.h"
#endif

// Static class instance data member initializations
//
STATICCLASSINSTANCE_VARS_INIT(DelimInfoComparer)
STATICCLASSINSTANCE_VARS_INIT(DelimTxtBufComparer)

/****************************************************************************/
//                      File Position Class
/****************************************************************************/
FilePosition::FilePosition(bool TextType_):
_BytesRead(0),
_TextFileType(false),
_RowPos(0),
_ColPos(0)
{}

/****************************************************************************/
FilePosition& FilePosition::SetTextFileType(bool TextType_)
{
  _TextFileType = TextType_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::IncBytesRead(long Bytes_)
{
  _BytesRead += Bytes_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::IncColPos(long ColPos_)
{
  _ColPos += ColPos_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::IncRowPos(long RowPos_)
{
  _RowPos += RowPos_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::DecColPos(long ColPos_)
{
  _ColPos -= ColPos_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::DecRowPos(long RowPos_)
{
  _RowPos -= RowPos_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::SetColPos(long Row_)
{
  _RowPos = Row_;
  return *this;
}

/****************************************************************************/    
FilePosition& FilePosition::SetRowPos(long Col_)
{
  _ColPos = Col_;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::ResetColPos()
{
  _ColPos = 0;
  return *this;
}

/****************************************************************************/
FilePosition& FilePosition::ResetRowPos()
{
  _RowPos = 0;
  return *this;
}

/****************************************************************************/
//			Delim Info Class
/****************************************************************************/
DelimInfo::DelimInfo():
_DelimType(0),
_DelimIndex(0),
_Delims((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_DelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_TextBuffer(NULL),
_EraseBuf(false)
{
  memset(_Delims, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
  memset(_DelimPtr, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
  memset(_DelimFound, 0, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
  memset(_DelimPos, 0, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
}

/****************************************************************************/
DelimInfo::DelimInfo(bool EraseBuf_, char* TextBuf_):
_DelimType(0),
_DelimIndex(0),
_Delims(NULL),
_DelimPtr(NULL),
_TextBuffer(TextBuf_),
_EraseBuf(EraseBuf_)
{
}

/****************************************************************************/
DelimInfo::DelimInfo(int DelimType_, int DelimIndex_, char** DelimPtr_, long* DelimPos_):
_DelimType(DelimType_),
_DelimIndex(DelimIndex_),
_Delims(NULL),
_DelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_TextBuffer(NULL),
_EraseBuf(false)
{
  if (DelimPtr_)
  {
    int x;
    
    if (DelimPtr_)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (DelimPtr_[x])
          _DelimPtr[x] = DelimPtr_[x];
        else
          _DelimPtr[x] = NULL;
      }

    memmove(_DelimPos, DelimPos_, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
  else
  {
    memset(_DelimPtr, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimPos, 0, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
}

/****************************************************************************/
DelimInfo::DelimInfo(int DelimType_, char** Delims_, char** DelimPtr_,
                     bool EraseBuf_, char* TextBuf_, bool* DelimFound_, long* DelimPos_):
_DelimType(DelimType_),
_DelimIndex(0),
_Delims((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_DelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_TextBuffer(TextBuf_),
_EraseBuf(EraseBuf_)
{
  if (Delims_ || DelimPtr_)
  {
    int x;
    
    if (Delims_)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (Delims_[x])
          _Delims[x] = NewString(Delims_[x]);
        else
          _Delims[x] = NULL;
      }

    if (DelimPtr_)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (DelimPtr_[x])
          _DelimPtr[x] = DelimPtr_[x];
        else
          _DelimPtr[x] = NULL;
      }

    memmove(_DelimFound, DelimFound_, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memmove(_DelimPos, DelimPos_, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
  else
  {
    memset(_Delims, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimPtr, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimFound, 0, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimPos, 0, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
}

/****************************************************************************/
DelimInfo::DelimInfo(const DelimInfo& Obj_):
_DelimType(Obj_._DelimType),
_DelimIndex(Obj_._DelimIndex),
_Delims((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_DelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * TextFileLineBuffer::MAXDELIMS)),
_TextBuffer(Obj_._TextBuffer),
_EraseBuf(Obj_._EraseBuf)
{
  if (Obj_._Delims || Obj_._DelimPtr)
  {
    int x;

    if (Obj_._Delims)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (Obj_._Delims[x])
          _Delims[x] = NewString(Obj_._Delims[x]);
        else
          _Delims[x] = NULL;
      }

    if (Obj_._DelimPtr)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (Obj_._DelimPtr[x])
          _DelimPtr[x] = Obj_._DelimPtr[x];
        else
          _DelimPtr[x] = NULL;
      }

    memmove(_DelimFound, Obj_._DelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memmove(_DelimPos, Obj_._DelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
  else
  {
    memset(_Delims, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimPtr, 0, sizeof(char*) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimFound, 0, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memset(_DelimPos, 0, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
}

/****************************************************************************/
DelimInfo::~DelimInfo()
{
  int x;

  if (_Delims)
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      ::RawDeleteArray(_Delims[x]);
      _Delims[x] = NULL;
    }

    ::RawDeleteArray(_Delims);
  }

  if (_DelimPtr)
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      _DelimPtr[x] = NULL;

    ::RawDeleteArray(_DelimPtr);
  }

  if (_EraseBuf)
    ::RawDeleteArray(_TextBuffer);
  
  _Delims = NULL;
  _DelimPtr = NULL;
  _TextBuffer = NULL;
}

/****************************************************************************/
char** DelimInfo::InitDelimsArray(char** ArrPtr_, size_t max)
{
  size_t x;
  if (ArrPtr_)
    for (x = 0; x < max; x++)
      ArrPtr_[x] = NULL;

  return ArrPtr_;
}

/****************************************************************************/
bool DelimInfo::IsEqual(const DelimInfo& Obj_) const
{
  return
  (
    ((_DelimType == Obj_._DelimType || _DelimIndex == 0) &&
     _DelimPtr[_DelimIndex] == Obj_._DelimPtr[_DelimIndex] &&
     _DelimPos[_DelimIndex] == Obj_._DelimPos[_DelimIndex]) ||

    (_DelimIndex == 2 &&
     _DelimType == TextLineEnums::FIRST_SET &&
     Obj_._DelimType == TextLineEnums::LAST_SET &&
     _DelimPtr[_DelimIndex] == Obj_._DelimPtr[_DelimIndex-1] &&
     _DelimPos[_DelimIndex] == Obj_._DelimPos[_DelimIndex-1]) ||
    (Obj_._DelimIndex == 2 &&
     Obj_._DelimType == TextLineEnums::FIRST_SET &&
     _DelimType == TextLineEnums::LAST_SET &&
     Obj_._DelimPtr[_DelimIndex] == _DelimPtr[_DelimIndex-1] &&
     Obj_._DelimPos[_DelimIndex] == _DelimPos[_DelimIndex-1]) ||

    (_DelimIndex == 1 &&
     _DelimType == TextLineEnums::LAST_SET &&
     Obj_._DelimType == TextLineEnums::FIRST_SET &&
     _DelimPtr[_DelimIndex] == Obj_._DelimPtr[_DelimIndex+1] &&
     _DelimPos[_DelimIndex] == Obj_._DelimPos[_DelimIndex+1]) ||
    (Obj_._DelimIndex == 1 &&
     Obj_._DelimType == TextLineEnums::LAST_SET &&
     _DelimType == TextLineEnums::FIRST_SET &&
     Obj_._DelimPtr[_DelimIndex] == _DelimPtr[_DelimIndex+1] &&
     Obj_._DelimPos[_DelimIndex] == _DelimPos[_DelimIndex+1])
  );
}

/****************************************************************************/
bool DelimInfo::IsTxtBufEqual(const DelimInfo& Obj_) const
{
  return
  (
    _TextBuffer && Obj_._TextBuffer &&
    strcmp(_TextBuffer, Obj_._TextBuffer) == 0
  );
}

/****************************************************************************/
bool DelimInfo::Matches(int DelimType_, int Ends_, int Test_,
                        char** Delims_, char** DelimPtr_,
                        bool* DelimFound_, bool* DelimOptional_)
{
  size_t len = 0;
  size_t xlen = 0;
  size_t x = 0;
  
  bool Result_ = false;
  bool Found_ = false;

  if (_DelimType == DelimType_)
  {
    Result_ = true;

    if (Result_ && (Ends_ & TextLineEnums::STARTING))
    {
      if (Test_ & TextLineEnums::STARTING)
        Found_ = _DelimFound[x] && DelimFound_[x];
      else
        Found_ = !_DelimFound[x] && !DelimFound_[x];

      Result_ = Result_ && Found_;

      if (Result_ && Delims_)
      {
        len = ::SafeStrLen(_Delims[x]);
        Found_ = ::SafeStrLen(Delims_[x]) == len &&
                 strncmp(_Delims[x], Delims_[x], len) == 0;

        Result_ = Result_ && Found_;

        if (Result_ && DelimPtr_)
        {
          xlen = ::SafeStrLen(_DelimPtr[x]);
          Found_ = len == xlen &&
                   ::SafeStrLen(DelimPtr_[x]) == xlen &&
                   strncmp(_DelimPtr[x], DelimPtr_[x], xlen) == 0;

          Result_ = Result_ && Found_;
        }
      }
    }

    x = Delims_[2] ? 2:1;
    if (Result_ && (Ends_ & TextLineEnums::ENDING))
    {
      if (Test_ & TextLineEnums::ENDING)
        Found_ = _DelimFound[x] && DelimFound_[x];
      else
        Found_ = !_DelimFound[x] && !DelimFound_[x];

      Result_ = Result_ && Found_;

      if (Result_ && Delims_)
      {
        len = ::SafeStrLen(_Delims[x]);
        Found_ = ::SafeStrLen(Delims_[x]) == len &&
                 strncmp(_Delims[x], Delims_[x], len) == 0;

        Result_ = Result_ && Found_;

        if (Result_ && DelimPtr_)
        {
          xlen = ::SafeStrLen(_DelimPtr[x]);
          Found_ = len == xlen &&
                   ::SafeStrLen(DelimPtr_[x]) == xlen &&
                   strncmp(_DelimPtr[x], DelimPtr_[x], xlen) == 0;

          Result_ = Result_ && Found_;
        }
      }
    }

    if (x == 2 && Delims_[1] && !DelimOptional_[1] &&
        Result_ && (Ends_ & TextLineEnums::ENDING))
    {
      x = 1;

      if (Test_ & TextLineEnums::ENDING)
        Found_ = _DelimFound[x] && DelimFound_[x];
      else
        Found_ = !_DelimFound[x] && !DelimFound_[x];

      Result_ = Result_ && Found_;

      if (Result_ && Delims_)
      {
        len = ::SafeStrLen(_Delims[x]);
        Found_ = ::SafeStrLen(Delims_[x]) == len &&
                 strncmp(_Delims[x], Delims_[x], len) == 0;

        Result_ = Result_ && Found_;

        if (Result_ && DelimPtr_)
        {
          xlen = ::SafeStrLen(_DelimPtr[x]);
          Found_ = len == xlen &&
                   ::SafeStrLen(DelimPtr_[x]) == xlen &&
                   strncmp(_DelimPtr[x], DelimPtr_[x], xlen) == 0;

          Result_ = Result_ && Found_;
        }
      }
    }
  }
  
  return Result_;
}

/****************************************************************************/
DelimInfo& DelimInfo::AssignTo(int DelimType_, char** Delims_, char** DelimPtr_, bool* DelimFound_, long* DelimPos_)
{
  if (DelimType_ != _DelimType)
    return *this;

  if (_Delims || _DelimPtr)
  {  
    int x;

    if (_Delims)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        ::RawDeleteArray(Delims_[x]);

        if (_Delims[x])
          Delims_[x] = NewString(_Delims[x]);
        else
          Delims_[x] = NULL;
      }

    if (_DelimPtr)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      {
        if (_DelimPtr[x])
          DelimPtr_[x] = _DelimPtr[x];
        else
          DelimPtr_[x] = NULL;
      }

    memmove(DelimFound_, _DelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memmove(DelimPos_, _DelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }
  else
  {
    Delims_ = InitDelimsArray(Delims_, TextFileLineBuffer::MAXDELIMS);
    DelimPtr_ = InitDelimsArray(DelimPtr_, TextFileLineBuffer::MAXDELIMS);
    memset(DelimFound_, 0, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
    memset(DelimPos_, 0, sizeof(long) * TextFileLineBuffer::MAXDELIMS);
  }

  return *this;
}

/****************************************************************************/
MEMORYOPS_DEFN(DelimInfo)

/****************************************************************************/
// DelimInfoComparer class definitions
/****************************************************************************/
DelimInfoComparer::DelimInfoComparer()
{
  STATICCLASSINSTANCE_CREATE_IMPL(DelimInfoComparer, STCIDummyFnc);
}

/****************************************************************************/
DelimInfoComparer::~DelimInfoComparer()
{
  STATICCLASSINSTANCE_DESTROY_IMPL(DelimInfoComparer, STCIDummyFnc);
}

/****************************************************************************/
MatchableTraits<DelimInfo>* DelimInfoComparer::Clone() const
{
  return (new DelimInfoComparer());
}

/****************************************************************************/
Boolean DelimInfoComparer::Equal(const DelimInfo& x, const DelimInfo& y) const
{
  return (x.IsEqual(y));
}

/****************************************************************************/
Boolean DelimInfoComparer::NotEqual(const DelimInfo& x, const DelimInfo& y) const
{
  return (!x.IsEqual(y));
}

/****************************************************************************/
STATICCLASSINSTANCE_METHOD_DEFN(DelimInfoComparer, STCIDummyFnc, STCIDummyFnc)
MEMORYOPS_DEFN(DelimInfoComparer)

/****************************************************************************/
// DelimInfoComparer class definitions
/****************************************************************************/
DelimTxtBufComparer::DelimTxtBufComparer()
{
  STATICCLASSINSTANCE_CREATE_IMPL(DelimTxtBufComparer, STCIDummyFnc);
}

/****************************************************************************/
DelimTxtBufComparer::~DelimTxtBufComparer()
{
  STATICCLASSINSTANCE_DESTROY_IMPL(DelimTxtBufComparer, STCIDummyFnc);
}

/****************************************************************************/
MatchableTraits<DelimInfo>* DelimTxtBufComparer::Clone() const
{
  return (new DelimTxtBufComparer());
}

/****************************************************************************/
Boolean DelimTxtBufComparer::Equal(const DelimInfo& x, const DelimInfo& y) const
{
  return (x.IsTxtBufEqual(y));
}

/****************************************************************************/
Boolean DelimTxtBufComparer::NotEqual(const DelimInfo& x, const DelimInfo& y) const
{
  return (!x.IsTxtBufEqual(y));
}

/****************************************************************************/
STATICCLASSINSTANCE_METHOD_DEFN(DelimTxtBufComparer, STCIDummyFnc, STCIDummyFnc)
MEMORYOPS_DEFN(DelimTxtBufComparer)

/****************************************************************************/
//			Line Data Record Class
/****************************************************************************/
TextFileLineData::TextFileLineData(TextFileLineBuffer& Obj_):
_RowPos(Obj_.GetFilePosition()->RowPos()),
_LineFitInBuffer(Obj_.LineFitInBuffer()),
_SingleDelimSetFound(Obj_.SingleDelimSetFound()),
_TimesLimitReached(Obj_.TimesLimitReached()),
_ReadTimesRequired(Obj_.ReadTimesRequired()),
_DelimSetTypeFound(Obj_.DelimSetTypeFound()),
_EolFound(Obj_.EolFound()),
_EofFound(Obj_.EofFound()),
_EndLinePos(Obj_.EolPosition()),
_EndFilePos(Obj_.EofPosition()),
_FirstDelims(Obj_._FirstDelims),
_FirstDelimPtr(Obj_._FirstDelimPtr),
_LastDelims(Obj_._LastDelims),
_LastDelimPtr(Obj_._LastDelimPtr),
_TextBuffer(Obj_._TextBuffer),
_TagBuffer(NULL),
_SplitTag(Obj_._SplitTag),
_MultiLineTag(Obj_._MultiLineTag),
_ReadBufQueue(Obj_._ReadBufQueue),
_DelimStk(Obj_._DelimStk),
_PartialDStk(Obj_._PartialDStk),
_SrchList(new SearchableList<DelimInfo>)
{
  memmove(_FirstDelimFound, Obj_._FirstDelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
  memmove(_FirstDelimPos, Obj_._FirstDelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);

  memmove(_LastDelimFound, Obj_._LastDelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
  memmove(_LastDelimPos, Obj_._LastDelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);

  *_SrchList = _PartialDStk;
  _TotalTextRead = Obj_.TotalTextRead();
}

/****************************************************************************/
TextFileLineData::~TextFileLineData()
{
  delete _SrchList;
  _SrchList = NULL;
}

/****************************************************************************/
TextFileLineData& TextFileLineData::operator = (TextFileLineBuffer& Obj_)
{
  _RowPos = Obj_.GetFilePosition()->RowPos();
  _LineFitInBuffer = Obj_.LineFitInBuffer();
  _SingleDelimSetFound = Obj_.SingleDelimSetFound();
  _TimesLimitReached = Obj_.TimesLimitReached();
  _ReadTimesRequired = Obj_.ReadTimesRequired();
  _DelimSetTypeFound = Obj_.DelimSetTypeFound();
  _EolFound = Obj_.EolFound();
  _EofFound = Obj_.EofFound();
  _EndLinePos = Obj_.EolPosition();
  _EndFilePos = Obj_.EofPosition();
  _FirstDelims = Obj_._FirstDelims;
  _FirstDelimPtr = Obj_._FirstDelimPtr;
  _LastDelims = Obj_._LastDelims;
  _LastDelimPtr = Obj_._LastDelimPtr;
  _TextBuffer = Obj_._TextBuffer;
  _TagBuffer = NULL;
  _SplitTag = Obj_._SplitTag;
  _MultiLineTag = Obj_._MultiLineTag;
  _ReadBufQueue = Obj_._ReadBufQueue;
  _DelimStk = Obj_._DelimStk;
  _PartialDStk = Obj_._PartialDStk;

  memmove(_FirstDelimFound, Obj_._FirstDelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
  memmove(_FirstDelimPos, Obj_._FirstDelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);

  memmove(_LastDelimFound, Obj_._LastDelimFound, sizeof(bool) * TextFileLineBuffer::MAXDELIMS);
  memmove(_LastDelimPos, Obj_._LastDelimPos, sizeof(long) * TextFileLineBuffer::MAXDELIMS);

  *_SrchList = _PartialDStk;
  _TotalTextRead = Obj_.TotalTextRead();

  return *this;
}

/****************************************************************************/
char* TextFileLineData::FillTagBuffer(char* TagBuffer_, char** DelimPtr_,
                                      long* DelimPos_, long fpos, long lpos)
{
  long flen;
  long llen;
  long plen;
  long slen;
  long olen;
  long maxlen;

  char* DelimStr_;
  bool HasPartial_ = false;
  bool AddSpc_ = false;
  int Type_ = DelimPtr_ == _LastDelimPtr ?
                  TextLineEnums::LAST_SET:
                  TextLineEnums::FIRST_SET;
  
  flen = ::SafeStrLen(DelimPtr_[fpos]);
  slen = _MultiLineTag ?
             (flen + DelimPos_[lpos] + 1):
             (DelimPos_[lpos] - DelimPos_[fpos] + 1);
  
  maxlen = DelimPtr_[lpos] - _TextBuffer;
  DelimInfo* DelimInfoPtr_ = NULL;
  DelimInfo* StartDelimPtr_ = NULL;
  DelimInfo* EndDelimPtr_ = NULL;
  
  SimpleNode<DelimInfo>* StartNodep_ = NULL;
  SimpleNode<DelimInfo>* EndNodep_ = NULL;

  PtrEqual<DelimInfo> DelimEqFnc_(MatchUsingUserDefinedFunctor<DelimInfo>::Trait(DelimInfoComparer::Instance()));
  PtrEqual<DelimInfo> DelimTxtBufEqFnc_(MatchUsingUserDefinedFunctor<DelimInfo>::Trait(DelimTxtBufComparer::Instance()));

  if (_MultiLineTag)
    llen = DelimPos_[lpos] + 1;
  else if (flen < slen)
    llen = slen - flen;
  else
    llen = 0;

  if (_MultiLineTag || (flen > 0 && llen > 0))
  {
    DelimInfoPtr_ = new DelimInfo(Type_, lpos, DelimPtr_, DelimPos_);
    
    if (_MultiLineTag)
    {
      StartDelimPtr_ = new DelimInfo(false, DelimPtr_[fpos]-DelimPos_[fpos]);
      EndDelimPtr_ = new DelimInfo(false, DelimPtr_[lpos]-DelimPos_[lpos]);
    }

    strncpy(TagBuffer_, DelimPtr_[fpos], flen);
    TagBuffer_[flen] = 0;
    HasPartial_ = _PartialDStk->HasThis(DelimInfoPtr_, &DelimEqFnc_);

    if (HasPartial_ || llen <= maxlen+1)
    {
      if (_MultiLineTag)
      {
        StartNodep_ = _SrchList->Find(StartDelimPtr_, &DelimTxtBufEqFnc_);
        EndNodep_ = _SrchList->Find(EndDelimPtr_, &DelimTxtBufEqFnc_);

        if (StartNodep_ == EndNodep_)
          StartNodep_ = _SrchList->Tail();
        else
          StartNodep_ = StartNodep_->Prev();
          
        olen = slen;
        slen = flen;

        if (EndNodep_)
        {
          while (StartNodep_ && StartNodep_ != EndNodep_)
          {
            DelimStr_ = StartNodep_->Value()->_TextBuffer;

            if (!DelimStr_)
            {
              StartNodep_ = StartNodep_->Prev();
              continue;
            }

            AddSpc_ = !isspace(DelimStr_[0]);
            if (!AddSpc_)
              ::RemoveLeading(DelimStr_, " \n\r\t");

            plen = ::SafeStrLen(DelimStr_);
            slen += plen + 2;

            if (slen > olen)
            {
              TagBuffer_ = (char*)RawReallocateWith(MEMMATRIX, TagBuffer_, sizeof(char) * (slen+2));
              olen = slen;
            }

            strcat(TagBuffer_, " ");
            strncat(TagBuffer_, DelimStr_, plen);
            TagBuffer_[slen] = 0;
            StartNodep_ = StartNodep_->Prev();
          }

          DelimStr_ = DelimPtr_[lpos] - llen + 1;

          if (!DelimStr_)
          {
            delete DelimInfoPtr_;
            delete StartDelimPtr_;
            delete EndDelimPtr_;

            DelimInfoPtr_ = NULL;
            StartDelimPtr_ = NULL;
            EndDelimPtr_ = NULL;

            ::RemovePadding(TagBuffer_, " \n\r\t");
            return TagBuffer_;
          }

          AddSpc_ = !isspace(DelimStr_[0]);
          if (!AddSpc_)
            ::RemoveLeading(DelimStr_, " \n\r\t");

          plen = ::SafeStrLen(DelimStr_);
          slen += plen + 2;
          
          if (slen > olen)
            TagBuffer_ = (char*)RawReallocateWith(MEMMATRIX, TagBuffer_, sizeof(char) * (slen+2));

          strcat(TagBuffer_, " ");
          strncat(TagBuffer_, DelimStr_, plen);
          TagBuffer_[slen] = 0;
        }
        else
          TagBuffer_[0] = 0;
      }
      else
      {
        strncat(TagBuffer_, DelimPtr_[lpos]-llen+1, llen);
        TagBuffer_[slen] = 0;
      }
    }
    else
      TagBuffer_[slen] = 0;

    delete DelimInfoPtr_;
    DelimInfoPtr_ = NULL;

    if (_MultiLineTag)
    {
      delete StartDelimPtr_;
      delete EndDelimPtr_;
      
      StartDelimPtr_ = NULL;
      EndDelimPtr_ = NULL;
    }
  }
  else
  {
    strncpy(TagBuffer_, DelimPtr_[fpos], slen);
    TagBuffer_[slen] = 0;
  }

  ::RemovePadding(TagBuffer_, " \n\r\t");
  return TagBuffer_;
}

/****************************************************************************/
void TextFileLineData::SetTagBuffer(char* TagBuffer_)
{
  _TagBuffer = TagBuffer_;
}

/****************************************************************************/
void TextFileLineData::DumpData(ostream& Out_, bool ColHead_)
{
  long x, y;
  long FirstPos_;
  long LastPos_;
  long StrLen_;
  long len;
  long max = _ReadBufQueue->Size();
  char sep[4] = ",,:";
  
  long* vect;
  DelimInfo* info;

  if (ColHead_)
    Out_ <<"(rpos)"   <<_RowPos <<":"
         <<"(lfit)"   <<_LineFitInBuffer <<":"
         <<"(sdsfnd)" <<_SingleDelimSetFound <<":"
         <<"(dstfnd)" <<_DelimSetTypeFound <<":"
         <<"(tlimr)"  <<_TimesLimitReached <<":"
         <<"(rdtreq)" <<_ReadTimesRequired <<":"
         <<"(eolfnd)" <<_EolFound <<":"
         <<"(eolpos)" <<_EndLinePos <<":"
         <<"(eoffnd)" <<_EofFound <<":"
         <<"(eofpos)" <<_EndFilePos <<";"
         <<endl;
  else
    Out_ <<_RowPos <<":"
         <<_LineFitInBuffer <<":"
         <<_SingleDelimSetFound <<":"
         <<_DelimSetTypeFound <<":"
         <<_TimesLimitReached <<":"
         <<_ReadTimesRequired <<":"
         <<_EolFound <<":"
         <<_EndLinePos <<":"
         <<_EofFound <<":"
         <<_EndFilePos <<";"
         <<endl;

  if (ColHead_)
    Out_ <<"(rbqmax)" <<max <<";"
         <<endl;
  else
    Out_ <<max <<";"
         <<endl;

  for (x = 0; x < max; x++)
  {
    vect = _ReadBufQueue->Dequeue();

    if (vect)
    {
      len = vect[0];

      if (ColHead_)
      {
        Out_ <<"(rbql[" <<x <<"])" <<len;
        for (y = 1; y <= len; y++)
          Out_ <<":(rbqv[" <<x <<"][" <<y <<"])" <<vect[y];
      }
      else
      {
        Out_ <<len;
        for (y = 1; y <= len; y++)
          Out_ <<":" <<vect[y];
      }

      Out_ <<";"
           <<endl;
    }

    ::RawDeleteArray(vect);
    vect = NULL;
  }

  max = _DelimStk->Size();
  if (ColHead_)
    Out_ <<"(dstkmax)" <<max <<";"
         <<endl;
  else
    Out_ <<max <<";"
         <<endl;

  max = _PartialDStk->Size();
  if (ColHead_)
    Out_ <<"(partdstkmax)" <<max <<";"
         <<endl;
  else
    Out_ <<max <<";"
         <<endl;

  sep[2] = ':';
  FirstPos_ =
  LastPos_ = -1;

  if (ColHead_)
  {  
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      Out_ <<"(fdfnd[" <<x <<"])" <<(_FirstDelimFound[x] ? 1:0) <<sep[x];

      if (_FirstDelimFound[x])
        if (FirstPos_ < 0)
          FirstPos_ = x;
        else
          LastPos_ = x;
    }
    
    Out_ <<endl;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<"(fdpos[" <<x <<"])" <<(_FirstDelimFound[x] ? _FirstDelimPos[x]:0) <<sep[x];
    Out_ <<endl;    

    sep[2] = ';';
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<"(fdstr[" <<x <<"])" <<(_FirstDelimFound[x] ? _FirstDelims[x]:"-") <<sep[x];
    Out_ <<endl;

    if (::SafeStrLen(_TagBuffer) && FirstPos_ >= 0 && LastPos_ >= 0 && !_SplitTag)
    {
      Out_ <<"TAGSTR: " <<_TagBuffer <<endl;
      Out_ <<"TOTALTXT: " <<_TotalTextRead;
    }
  }
  else
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      Out_ <<(_FirstDelimFound[x] ? 1:0) <<sep[x];

      if (_FirstDelimFound[x])
        if (FirstPos_ < 0)
          FirstPos_ = x;
        else
          LastPos_ = x;
    }
    
    Out_ <<endl;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<(_FirstDelimFound[x] ? _FirstDelimPos[x]:0) <<sep[x];
    Out_ <<endl;

    sep[2] = ';';
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<(_FirstDelimFound[x] ? _FirstDelims[x]:"-") <<sep[x];
    Out_ <<endl;

    if (::SafeStrLen(_TagBuffer) && FirstPos_ >= 0 && LastPos_ >= 0 &&  !_SplitTag)
    {
      Out_ <<"TAGSTR: " <<_TagBuffer <<endl;;
      Out_ <<"TOTALTXT: " <<_TotalTextRead;
    }
  }

  Out_ <<endl;

  for (x = 0; x < max; x++)
  {  
    info = _DelimStk->Dequeue();

    if (info)
    {
      sep[2] = ':';

      if (ColHead_)
      {
        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<"(dlmfnd[" <<x <<"][" <<y <<"])" <<(info->_DelimFound[y] ? 1:0) <<sep[y];
        Out_ <<endl;

        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<"(dlmpos[" <<x <<"][" <<y <<"])" <<(info->_DelimFound[y] ? info->_DelimPos[y]:0) <<sep[y];
        Out_ <<endl;

        sep[2] = ';';
        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<"(dlmstr[" <<x <<"][" <<y <<"])" <<(info->_DelimFound[y] ? info->_Delims[y]:"-") <<sep[y];
      }
      else
      {
        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<(info->_DelimFound[y] ? 1:0) <<sep[y];
        Out_ <<endl;

        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<(info->_DelimFound[y] ? info->_DelimPos[y]:0) <<sep[y];
        Out_ <<endl;

        sep[2] = ';';
        for (y = 0; y < TextFileLineBuffer::MAXDELIMS; y++)
          Out_ <<(info->_DelimFound[y] ? info->_Delims[y]:"-") <<sep[y];
      }

      Out_ <<endl;
    }

    delete info;
    info = NULL;
  }

  sep[2] = ':';
  FirstPos_ =
  LastPos_ = -1;

  if (ColHead_)
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      Out_ <<"(ldfnd[" <<x <<"])" <<(_LastDelimFound[x] ? 1:0) <<sep[x];

      if (_LastDelimFound[x])
        if (FirstPos_ < 0)
          FirstPos_ = x;
        else
          LastPos_ = x;
    }
    
    Out_ <<endl;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<"(ldpos[" <<x <<"])" <<(_LastDelimFound[x] ? _LastDelimPos[x]:0) <<sep[x];
    Out_ <<endl;

    sep[2] = ';';
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<"(ldstr[" <<x <<"])" <<(_LastDelimFound[x] ? _LastDelims[x]:"-") <<sep[x];
    Out_ <<endl;

    if (::SafeStrLen(_TagBuffer) && FirstPos_ >= 0 && LastPos_ >= 0 && !_SplitTag)
    {
      Out_ <<"TAGSTR: " <<_TagBuffer <<endl;;
      Out_ <<"TOTALTXT: " <<_TotalTextRead;
    }
  }
  else
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      Out_ <<(_LastDelimFound[x] ? 1:0) <<sep[x];

      if (_LastDelimFound[x])
        if (FirstPos_ < 0)
          FirstPos_ = x;
        else
          LastPos_ = x;
    }

    Out_ <<endl;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<(_LastDelimFound[x] ? _LastDelimPos[x]:0) <<sep[x];
    Out_ <<endl;

    sep[2] = ';';
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      Out_ <<(_LastDelimFound[x] ? _LastDelims[x]:"-") <<sep[x];
    Out_ <<endl;

    if (::SafeStrLen(_TagBuffer) && FirstPos_ >= 0 && LastPos_ >= 0 && !_SplitTag)
    {
      Out_ <<"TAGSTR: " <<_TagBuffer <<endl;;
      Out_ <<"TOTALTXT: " <<_TotalTextRead;
    }
  }
    
  Out_ <<endl;
  if (ColHead_)
    Out_ <<endl;
}

/****************************************************************************/
MEMORYOPS_DEFN(TextFileLineData)

/****************************************************************************/
//			Line Data Record Class
/****************************************************************************/
TextFileSearchData::TextFileSearchData(int ArrayIndex_, int StringIndex_, int DelimType_):
_ArrayIndex(ArrayIndex_),
_StringIndex(StringIndex_),
_DelimType(DelimType_)
{}

/****************************************************************************/
TextFileSearchData::~TextFileSearchData()
{}

/****************************************************************************/
MEMORYOPS_DEFN(TextFileSearchData)

/****************************************************************************/
//			Text File Line Reader Class
/****************************************************************************/
TextFileLineBuffer::TextFileLineBuffer(FileReader* Freader_,
                                       short IoMode_, short BufLen_):
_CurPosPtr(NULL),
_TextBuffer(BufLen_ ? (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (BufLen_+1)):
                      (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (MAXTEXTBUFFER+1))),
_TagBuffer(NULL),
_BufferFull(false),
_LineFitInBuffer(true),
_SingleDelimSetFound(false),
_FreaderCreated(Freader_ ? false:true),

_QuitReadOnFirstDelimSetFound(false),
_QuitReadOnLastDelimSetFound(false),
_ReadUntilFirstDelimSetFound(false),
_ReadUntilLastDelimSetFound(false),
_FirstDelimSetFound(false),
_LastDelimSetFound(false),
_SimplifyTagSpaces(true),
_SuppressSimplify(false),

_IoMode(IoMode_),
_DefaultDelim(TextFileLineBuffer::LAST_SET),
_LineEmpty(0),
_CharsRead(0),
_BufSize(BufLen_ ? BufLen_:MAXTEXTBUFFER),
_ReadAttemptNumber(0),
_TimesLimitReached(0),
_ReadTimesRequired(0),

_NlChars(NewString("\n\r\f\v")),
_WsChars(NewString(" \t\n\r\f\v")),
_WsxNlChars(NewString(" \t")),

_GivenInputLine(NULL),
_GivenLineSet(false),

_FileOpened(false),
_BrkChFound(false),
_WsFound(false),
_EolFound(false),
_EofFound(false),
_WsLinePos(0),
_EndLinePos(0),
_EndFilePos(0),

_FirstDelims((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * MAXDELIMS)),
_FirstDelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * MAXDELIMS)),
_LastDelims((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * MAXDELIMS)),
_LastDelimPtr((char**)RawAllocateWith(MEMMATRIX, sizeof(char*) * MAXDELIMS)),

_CmmntSegIndex(0),
_ResetCmmntSeg(false),
_TestCmmntSeg(0),
_DelimsToTest(0),
_XmlTypeTag(true),
_InComment(false),
_SplitTag(false),
_MultiLineTag(false),
_TagBufferComplete(false),

_File(Freader_ ? Freader_:(new FileReader)),
_LineData(NULL),
_SearchData(NULL),
_FilePos(new FilePosition),
_ColStk(new SimpleStack<long>),
_ReadLenQueue(new SimpleQueue<long>),
_ReadBufQueue(new SimpleQueue<long>),
_DelimStk(new SimpleDeque<DelimInfo>),
_PartialDStk(new SimpleDeque<DelimInfo>)
{
  _CurPosPtr = _TextBuffer;
  
  _LastDelims = DelimInfo::InitDelimsArray(_LastDelims, MAXDELIMS);
  _LastDelimPtr = DelimInfo::InitDelimsArray(_LastDelimPtr, MAXDELIMS);
  memset(_LastDelimFound, 0, sizeof(bool) * MAXDELIMS);
  memset(_LastDelimOptional, 0, sizeof(bool) * MAXDELIMS);
  memset(_LastDelimPos, 0, sizeof(long) * MAXDELIMS);
  memset(_LastDelimPtr, 0, sizeof(char*) * MAXDELIMS);

  _FirstDelims = DelimInfo::InitDelimsArray(_FirstDelims, MAXDELIMS);
  _FirstDelimPtr = DelimInfo::InitDelimsArray(_FirstDelimPtr, MAXDELIMS);
  memset(_FirstDelimFound, 0, sizeof(bool) * MAXDELIMS);
  memset(_FirstDelimOptional, 0, sizeof(bool) * MAXDELIMS);
  memset(_FirstDelimPos, 0, sizeof(long) * MAXDELIMS);
  memset(_FirstDelimPtr, 0, sizeof(char*) * MAXDELIMS);
  
  memset(_CommentSeg, 0, sizeof(char) * (MAXCMMNTSTR+1));
  strcpy(_StartCmmntStr, "<!--");
  strcpy(_EndCmmntStr, "-->");

  _TotalTextRead = " ";
  _TotalTextRead.SetEmpty();
}

/****************************************************************************/
TextFileLineBuffer::~TextFileLineBuffer()
{
  ::RawDeleteArray(_TextBuffer);
  ::RawDeleteArray(_TagBuffer);
  _CurPosPtr =
  _TextBuffer = NULL;

  if (_GivenLineSet)
  {
    ::RawDeleteArray(_GivenInputLine);
    _GivenInputLine = NULL;
    _GivenLineSet = false;
  }

  int x;
  for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
  {
    ::RawDeleteArray(_FirstDelims[x]);
    ::RawDeleteArray(_LastDelims[x]);

    _FirstDelims[x] = NULL;
    _LastDelims[x] = NULL;
  }

  ::RawDeleteArray(_FirstDelims);
  ::RawDeleteArray(_LastDelims);
  ::RawDeleteArray(_FirstDelimPtr);
  ::RawDeleteArray(_LastDelimPtr);
  
  _FirstDelims = NULL;
  _LastDelims = NULL;
  _FirstDelimPtr = NULL;
  _LastDelimPtr = NULL;

  ::RawDeleteArray(_NlChars);
  ::RawDeleteArray(_WsChars);
  ::RawDeleteArray(_WsxNlChars);
  _NlChars = NULL;
  _WsChars = NULL;
  _WsxNlChars = NULL;

  if (_FreaderCreated)
    delete _File;

  _ReadLenQueue->DeleteAllAndData();
  _ReadBufQueue->DeleteAllAndData();
  _DelimStk->DeleteAllAndData();
  _PartialDStk->DeleteAllAndData();

  delete _LineData;
  delete _SearchData;
  delete _FilePos;
  delete _ColStk;  
  delete _ReadLenQueue;
  delete _ReadBufQueue;
  delete _DelimStk;
  delete _PartialDStk;
}

/****************************************************************************/
const char* TextFileLineBuffer::TagTypeStr(const char* EscStr_)
{
  if (!EscStr_)
    return NULL;

  return
  (
    (StriComp(EscStr_, "&amp;") == 0)          ? "&":
    (StriComp(EscStr_, "&lt;") == 0)           ? "<":
    (StriComp(EscStr_, "&gt;") == 0)           ? ">":
    (StriComp(EscStr_, "&quot;") == 0)         ? "\"":
    (StriComp(EscStr_, "&tagop;") == 0)        ? "<":
    (StriComp(EscStr_, "&tagcl;") == 0)        ? ">":
    (StriComp(EscStr_, "&endtagop;") == 0)     ? "</":
    (StriComp(EscStr_, "&endtagcl;") == 0)     ? ">":
    (StriComp(EscStr_, "&emptytagop;") == 0)   ? "<":
    (StriComp(EscStr_, "&emptytagcl;") == 0)   ? "/>":
    (StriComp(EscStr_, "&scriptop;") == 0)     ? "<?":
    (StriComp(EscStr_, "&scriptcl;") == 0)     ? "?>":
    (StriComp(EscStr_, "&doctypeop;") == 0)    ? "<!":
    (StriComp(EscStr_, "&doctypecl;") == 0)    ? ">":
    (StriComp(EscStr_, "&commentop;") == 0)    ? "<!--":
    (StriComp(EscStr_, "&commentcl;") == 0)    ? "-->":
    (StriComp(EscStr_, "&nestedcmt1op;") == 0) ? "<!--":
    (StriComp(EscStr_, "&nestedcmt1cl;") == 0) ? ">":
    (StriComp(EscStr_, "&nestedcmt2op;") == 0) ? "<!":
    (StriComp(EscStr_, "&nestedcmt2cl;") == 0) ? "-->":
    (StriComp(EscStr_, "&copcmtblkop;") == 0)  ? "/*":
    (StriComp(EscStr_, "&copcmtblkcl;") == 0)  ? "->":
    (StriComp(EscStr_, "&cclcmtblkop;") == 0)  ? "<-":
    (StriComp(EscStr_, "&cclcmtblkcl;") == 0)  ? "*/":
    (StriComp(EscStr_, "&cppcmtlnop;") == 0)   ? "//":
    (StriComp(EscStr_, "&cppcmtlncl;") == 0)   ? "=>":EscStr_
  );  
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetFileReader(FileReader* Freader_)
{
  if (Freader_)
  {
    if (_FreaderCreated)
      delete _File;

    _File = Freader_;
    _FreaderCreated = false;
  }
  
  return *this;
}

/****************************************************************************/
void TextFileLineBuffer::SetXmlTypeTag(bool Flag_)
{
  bool PrevSet_ = _XmlTypeTag;
  _XmlTypeTag = Flag_;

  if (PrevSet_ != Flag_ && Flag_)
  {
    _CmmntSegIndex = 0;    
    memset(_CommentSeg, 0, sizeof(char) * (MAXCMMNTSTR+1));    
  }
}

/****************************************************************************/
void TextFileLineBuffer::ResetCmmntSeg(bool Shift_)
{
  if (_XmlTypeTag && _ResetCmmntSeg)
  {
    if (Shift_)
    {
      _CmmntSegIndex = MAXCMMNTSTR-1;
      memmove(_CommentSeg, _CommentSeg+1, sizeof(char) * MAXCMMNTSTR);
    }
    else
    {
      _CmmntSegIndex = 0;
      memset(_CommentSeg, 0, sizeof(char) * (MAXCMMNTSTR+1));
    }
    
    _ResetCmmntSeg = false;
  }
}

/****************************************************************************/
void TextFileLineBuffer::ResetDelimFound()
{
  int x;
  
  if (_XmlTypeTag)
  {
    if (_DelimsToTest == STARTING)
    {
      if (_TestCmmntSeg == STARTING)
      {
        _FirstDelimPtr[0] = NULL;
        _FirstDelimFound[0] = false;
        _FirstDelimPos[0] = 0;
      }
      else if (_TestCmmntSeg == ENDING)
      {
        x = _FirstDelims[2] ? 2:
            _FirstDelims[1] ? 1:0;
            
        _FirstDelimPtr[x] = NULL;
        _FirstDelimFound[x] = false;
        _FirstDelimPos[x] = 0;
      }
    }
    else if (_DelimsToTest == ENDING)
    {
      if (_TestCmmntSeg == STARTING)
      {
        _LastDelimPtr[0] = NULL;
        _LastDelimFound[0] = false;
        _LastDelimPos[0] = 0;
      }
      else if (_TestCmmntSeg == ENDING)
      {
        x = _LastDelims[2] ? 2:
            _LastDelims[2] ? 1:0;

        _LastDelimPtr[x] = NULL;
        _LastDelimFound[x] = false;
        _LastDelimPos[x] = 0;
      }
    }
  }
}

/****************************************************************************/
void TextFileLineBuffer::TestCmmntSeg(char ch, bool Test_)
{
  int slen = 0;
  int off = 0;
  bool Shift_ = false;

  if (_XmlTypeTag)
  {
    if (_TestCmmntSeg == STARTING)
    {
      if (_CmmntSegIndex == MAXCMMNTSTR)
      {
        _CommentSeg[_CmmntSegIndex] = 0;
        slen = strlen(_StartCmmntStr);
        off = _CmmntSegIndex - slen;
        _ResetCmmntSeg = true;

        if (!_InComment && strcmp(_CommentSeg+off, _StartCmmntStr) == 0)
        {
          ResetDelimFound();
          _InComment = true;
        }
        else
          Shift_ = true;
        
        ResetCmmntSeg(Shift_);
        _TestCmmntSeg = 0;
      }
      else if (Test_)
      {
        _CommentSeg[_CmmntSegIndex++] = ch;
        TestCmmntSeg(ch, false);
      }
    }
    else if (_TestCmmntSeg == ENDING)
    {
      if (_CmmntSegIndex == MAXCMMNTSTR)
      {
        _CommentSeg[_CmmntSegIndex] = 0;
        slen = strlen(_EndCmmntStr);
        off = _CmmntSegIndex - slen;
        _ResetCmmntSeg = true;

        if (_InComment && strcmp(_CommentSeg+off, _EndCmmntStr) == 0)
        {
          ResetDelimFound();
          _InComment = false;
        }

        ResetCmmntSeg(Shift_);
        _TestCmmntSeg = 0;
      }
      else if (Test_)
      {
        _CommentSeg[_CmmntSegIndex++] = ch;
        TestCmmntSeg(ch, false);
      }
    }
    else if (!_TestCmmntSeg)
    {
      _CommentSeg[_CmmntSegIndex++] = ch;
      
      if (_CmmntSegIndex == MAXCMMNTSTR)
      {
        _CommentSeg[_CmmntSegIndex] = 0;
        _ResetCmmntSeg = true;
        ResetCmmntSeg(true);
        _TestCmmntSeg = 0;
      }
    }
  }
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetInputLine(const char* Input_)
{
  if (Input_)
  {
    _GivenInputLine = NewString(Input_);
    _GivenLineSet = true;
  }

  return *this;
}

/****************************************************************************/
bool TextFileLineBuffer::IsEmptyLine(const char* InputStr_, int len)
{
  if (len == 0 || !InputStr_)
  {
    _LineEmpty = COMPLETE;
    return true;
  }

  int x;
  bool spc = false;
  for (x = 0; x < len && InputStr_[x] && (spc=isspace(InputStr_[x])); x++);

  _LineEmpty = spc          ? INCOMPLETE:
               InputStr_[x] ? NONE:COMPLETE;

  return (_LineEmpty != NONE);
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetNewLineChars(const char* Sep_)
{
  if (Sep_)
  {
    ::RawDeleteArray(_NlChars);
    _NlChars = NewString(Sep_);
  }
    
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetWhiteSpaceChars(const char* Sep_)
{
  if (Sep_)
  {
    ::RawDeleteArray(_WsChars);
    _WsChars = NewString(Sep_);
  }
    
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetDefaultToDelims(int Set_)
{
  _DefaultDelim = (Set_ == FIRST_SET) ? FIRST_SET:
                  (Set_ == LAST_SET)  ? LAST_SET:0;

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetFirstDelims(long Pos_, const char* Str_, bool Optional_)
{
  if (0 <= Pos_ && Pos_ <= 2 && Str_)
  {
    _FirstDelims[Pos_] = NewString(Str_);
    _FirstDelimOptional[Pos_] = Optional_;
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::SetLastDelims(long Pos_, const char* Str_, bool Optional_)
{
  if (0 <= Pos_ && Pos_ <= 2 && Str_)
  {
    _LastDelims[Pos_] = NewString(Str_);
    _LastDelimOptional[Pos_] = Optional_;
  }

  return *this;
}

/****************************************************************************/
int TextFileLineBuffer::FirstDelimFound(long Pos_, bool All_) const
{
  int ret = 0;

  if (!All_ && 0 <= Pos_ && Pos_ <= 2)
    ret = _FirstDelimFound[Pos_] ? COMPLETE:NONE;
  else if (All_)
    ret = DelimSetComplete(_FirstDelims);

  return ret;
}

/****************************************************************************/
int TextFileLineBuffer::LastDelimFound(long Pos_, bool All_) const
{
  int ret = 0;

  if (!All_ && 0 <= Pos_ && Pos_ <= 2)
    ret = _LastDelimFound[Pos_] ? COMPLETE:NONE;
  else if (All_)
    ret = DelimSetComplete(_LastDelims);

  return ret;
}

/****************************************************************************/
long TextFileLineBuffer::FirstDelimPos(long Pos_)
{
  if (0 <= Pos_ && Pos_ <= 2)
    return _FirstDelimPos[Pos_];
}

/****************************************************************************/
long TextFileLineBuffer::LastDelimPos(long Pos_)
{
  if (0 <= Pos_ && Pos_ <= 2)
    return _LastDelimPos[Pos_];
}

/****************************************************************************/
TextFileLineBuffer&
TextFileLineBuffer::SetQuitReadOnFirstDelimSetFound(bool Flag_, bool UntilFound_)
{
  _QuitReadOnFirstDelimSetFound = Flag_;
  _ReadUntilFirstDelimSetFound = UntilFound_;
  
  return *this;
}

/****************************************************************************/
TextFileLineBuffer&
TextFileLineBuffer::SetQuitReadOnLastDelimSetFound(bool Flag_, bool UntilFound_)
{
  _QuitReadOnLastDelimSetFound = Flag_;
  _ReadUntilLastDelimSetFound = UntilFound_;
  
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ClearFirstDelims(long Pos_, bool All_)
{
  if (!All_ && 0 <= Pos_ && Pos_ <= 2)
  {
    ::RawDeleteArray(_FirstDelims[Pos_]);
    _FirstDelims[Pos_] = NULL;
  }
  else if (All_)
  {
    long x;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      ::RawDeleteArray(_FirstDelims[x]);
      _FirstDelims[x] = NULL;
    }
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ClearLastDelims(long Pos_, bool All_)
{
  if (!All_ && 0 <= Pos_ && Pos_ <= 2)
  {
    ::RawDeleteArray(_LastDelims[Pos_]);
    _LastDelims[Pos_] = NULL;
  }
  else if (All_)
  {
    long x;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
    {
      ::RawDeleteArray(_LastDelims[x]);
      _LastDelims[x] = NULL;
    }
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ClearAllDelims()
{
  ClearFirstDelims(0, true);
  ClearLastDelims(0, true);
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ResetFirstDelims(long Pos_, bool All_)
{
  if (!_XmlTypeTag || _FirstDelimSetFound ||
      (!_QuitReadOnFirstDelimSetFound || (!_FirstDelimFound[0] || !_SplitTag)))
  {
    if (!All_ && 0 <= Pos_ && Pos_ <= 2)
    {
      _FirstDelimFound[Pos_] = false;
      _FirstDelimPtr[Pos_] = NULL;
      _FirstDelimPos[Pos_] = 0;
    }
    else if (All_)
    {
      memset(_FirstDelimFound, 0, sizeof(bool) * MAXDELIMS);
      memset(_FirstDelimPtr, 0, sizeof(char*) * MAXDELIMS);
      memset(_FirstDelimPos, 0, sizeof(long) * MAXDELIMS);
    }
  }
  
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ResetLastDelims(long Pos_, bool All_)
{
  if (!_XmlTypeTag || _LastDelimSetFound ||
      (!_QuitReadOnLastDelimSetFound || (!_LastDelimFound[0] || !_SplitTag)))
  {
    if (!All_ && 0 <= Pos_ && Pos_ <= 2)
    {
      _LastDelimFound[Pos_] = false;
      _LastDelimPtr[Pos_] = NULL;
      _LastDelimPos[Pos_] = 0;
    }
    else if (All_)
    {
      memset(_LastDelimFound, 0, sizeof(bool) * MAXDELIMS);
      memset(_LastDelimPtr, 0, sizeof(char*) * MAXDELIMS);
      memset(_LastDelimPos, 0, sizeof(long) * MAXDELIMS);
    }
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ResetAllDelims()
{
  ResetFirstDelims(0, true);
  ResetLastDelims(0, true);
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ResetLineData(bool ResetTextRead_, bool ForceReset_)
{
  bool BufferReset_ = false;
  bool QuitRead_ = false;
  bool QuitLine_ = false;
  bool FirstSetCmp_ = false;
  bool LastSetCmp_ = false;
  bool ResetFirstDlm_ = (!_XmlTypeTag || _FirstDelimSetFound ||
                        (!_QuitReadOnFirstDelimSetFound || (!_FirstDelimFound[0] || !_SplitTag)));
  bool ResetLastDlm_ = (!_XmlTypeTag || _LastDelimSetFound ||
                       (!_QuitReadOnLastDelimSetFound || (!_LastDelimFound[0] || !_SplitTag)));

  if (_EolFound || ForceReset_)
  {
    FirstSetCmp_ = _XmlTypeTag && _FirstDelimSetFound && _QuitReadOnFirstDelimSetFound;
    LastSetCmp_ = _XmlTypeTag && _LastDelimSetFound && _QuitReadOnLastDelimSetFound;
  
    if (ResetFirstDlm_ || ResetLastDlm_)
      ResetAllDelims();

    if (ResetTextRead_ && (FirstSetCmp_ || LastSetCmp_))
      ResetTotalTextRead();

    QuitRead_ = QuitReadDelimFound();
    QuitLine_ = (_EolFound || _LineEmpty) && !ReadUntilDelimFound();
    BufferReset_ = _BufferFull || ForceReset_ || QuitLine_;

    if (_FirstDelimSetFound || _LastDelimSetFound || QuitLine_ || QuitRead_)
    {
      _DelimStk->DeleteAllAndData();
      _PartialDStk->DeleteAllAndData();
      _ReadBufQueue->DeleteAllAndData();
    }

    if (BufferReset_)
      _ReadLenQueue->DeleteAllAndData();

    if (_EofFound || QuitLine_ || QuitRead_)
    {
      delete _LineData;      
      _LineData = NULL;
    }

    _FirstDelimSetFound = false;
    _LastDelimSetFound = false;
    _BrkChFound = false;
    _WsFound = false;
    _EolFound = false;
    _BufferFull = false;
    _SingleDelimSetFound = false;    
    _LineFitInBuffer = true;
    
    _LineEmpty = 0;
    _CharsRead = 0;
    _ReadAttemptNumber = 0;
    _TimesLimitReached = 0;
    _ReadTimesRequired = 0;
    _DelimSetTypeFound = 0;
    _TextBuffer[0] = 0;
  }
  else
  {
    FirstSetCmp_ = _XmlTypeTag && _FirstDelimSetFound && _QuitReadOnFirstDelimSetFound;
    ResetFirstDlm_ = FirstSetCmp_ || !(_FirstDelimFound[0] && _SplitTag);
    LastSetCmp_ = _XmlTypeTag && _LastDelimSetFound && _QuitReadOnLastDelimSetFound;
    ResetLastDlm_ = LastSetCmp_ || !(_LastDelimFound[0] && _SplitTag);

    if (ResetFirstDlm_ || ResetLastDlm_)
      ResetAllDelims();
      
    if (ResetTextRead_ && (FirstSetCmp_ || LastSetCmp_))
      ResetTotalTextRead();
  }
  
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ResetBufferStatus(bool ForceReset_)
{
  if (_BufferFull || _EolFound || ForceReset_)
  {
    size_t x = 0;
    size_t sz = _ReadLenQueue->Size();
    long* Vect_ = (long*)RawAllocateWith(MEMMATRIX, sizeof(long) * (sz+1));
    long* Val_;
  
    Vect_[x++] = sz;

    while (!_ReadLenQueue->Empty())
    {
      Val_ = _ReadLenQueue->Dequeue();

      if (Val_)
      {
        Vect_[x++] = *Val_;
        delete Val_;
      }
    }

    _ReadAttemptNumber = 0;
    _ReadLenQueue->DeleteAllAndData();
    _ReadBufQueue->Enqueue(Vect_);
    _BufferFull = false;

    // defaulting to last delims
    if (_EolFound)
      DetermineDelimSet((_LastDelims && _DefaultDelim != FIRST_SET) ? _LastDelims:_FirstDelims);
  }

  return *this;
}

/****************************************************************************/
int TextFileLineBuffer::DetermineDelimSet(char** Delims_)
{
  int DsComp1_ = DelimSetComplete(_FirstDelims);
  int DsComp2_ = DelimSetComplete(_LastDelims);
  
  _SingleDelimSetFound = (DsComp2_ && DsComp2_ > DsComp1_) ||
                         (DsComp1_ && DsComp1_ > DsComp2_);
  _DelimSetTypeFound = _SingleDelimSetFound ?
                          ((DsComp2_ > DsComp1_) ? LAST_SET:FIRST_SET):NONE;

  if (_DelimSetTypeFound == FIRST_SET)
  {
    if (Delims_ == _LastDelims && _DefaultDelim == LAST_SET)
      SetMatchingDelims(_FirstDelims);
    else
    {
      _SingleDelimSetFound = !(DsComp1_ && DsComp2_) &&
                              (DsComp1_ || DsComp2_);
      _DelimSetTypeFound = _SingleDelimSetFound ?
                              (DsComp2_ ? LAST_SET:FIRST_SET):NONE;
    }
  }
  else if (_DelimSetTypeFound == LAST_SET)
  {
    if (Delims_ == _FirstDelims && _DefaultDelim == FIRST_SET)
      SetMatchingDelims(_LastDelims);
    else
    {
      _SingleDelimSetFound = !(DsComp1_ && DsComp2_) &&
                              (DsComp1_ || DsComp2_);
      _DelimSetTypeFound = _SingleDelimSetFound ?
                              (DsComp2_ ? LAST_SET:FIRST_SET):NONE;
    }
  }

  return _DelimSetTypeFound;
}

/****************************************************************************/
int TextFileLineBuffer::NumDelims(char** Delims_, bool SkipOptional_)
{
  int x;
  int num = 0;
  
  if (Delims_ == _LastDelims)
  {
    for (x = num = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      if (_LastDelims[x] && (!SkipOptional_ || !_LastDelimOptional[x]))
        ++num;
  }
  else if (Delims_ == _FirstDelims)
  {
    for (x = num = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
      if (_FirstDelims[x] && (!SkipOptional_ || !_FirstDelimOptional[x]))
        ++num;
  }

  return num;
}

/****************************************************************************/
bool TextFileLineBuffer::TransferDelims()
{
  int x, y, z;
  int DelimMatch_[3];
  int dlmval;
  int preval;

  size_t len = 0;
  size_t len1 = NumDelims(_FirstDelims);
  size_t len2 = NumDelims(_LastDelims);

  bool Match1_ = false;
  bool Match2_ = false;
  bool mm1 = false;
  bool mm2 = false;
  bool mm3 = false;
  bool same = false;
  bool fnd;

  ::memset(DelimMatch_, 0, sizeof(int) * 3);

  if (NumDelims(_FirstDelims, true) == NumDelims(_LastDelims, true))
  {
    for (x = y = z = 0; x < TextFileLineBuffer::MAXDELIMS &&
                        y < TextFileLineBuffer::MAXDELIMS &&
                        _FirstDelims[x] && _LastDelims[y];)
    {
      len1 = ::SafeStrLen(_FirstDelims[x]);
      len2 = ::SafeStrLen(_LastDelims[y]);
      len = (len1 == len2) ? len1:0;
      same = len > 0 && ::strcmp(_FirstDelims[x], _LastDelims[y]) == 0;

      fnd = (_FirstDelimFound[x] || _LastDelimFound[y]) && same;

      if (!fnd)
      {
        mm1 = _LastDelimPtr[y] && _FirstDelims[x] &&
              strncmp(_LastDelimPtr[y], _FirstDelims[x], len1) == 0;
        Match1_ = _FirstDelimFound[x] ?
                      (_FirstDelimPtr[x] && _FirstDelims[x] &&
                       strncmp(_FirstDelimPtr[x], _FirstDelims[x], len1) == 0):
                  _LastDelimFound[y]  ? mm1:false;

        mm2 = _FirstDelimPtr[x] && _LastDelims[y] &&
              strncmp(_FirstDelimPtr[x], _LastDelims[y], len2) == 0;
        Match2_ = _LastDelimFound[y]  ?
                      (_LastDelimPtr[y] && _LastDelims[y] &&
                       strncmp(_LastDelimPtr[y], _LastDelims[y], len2) == 0):
                  _FirstDelimFound[x] ? mm2:false;

        DelimMatch_[z] = (Match1_ && !Match2_) ? 1:
                         (Match1_ && Match2_)  ?
                             ((len2 > len1) ?
                              (_LastDelimFound[y]  ? 2:
                               _FirstDelimFound[x] ? (mm2 ? 2:1):1):
                              (_FirstDelimFound[x] ? 1:
                               _LastDelimFound[y]  ? (mm1 ? 1:2):2)):
                         (!Match1_ && Match2_) ? 2:0;
      }
      else if (_FirstDelims[x] && _FirstDelimFound[x])
      {
        if (_DelimSetTypeFound == FIRST_SET)
          DelimMatch_[z] = 1;
        else if (_LastDelims[y])
        {
          mm1 = _LastDelimPtr[y] && _FirstDelims[x] &&
                strncmp(_LastDelimPtr[y], _FirstDelims[x], len1) == 0;
          mm2 = _FirstDelimPtr[x] && _FirstDelims[x] &&
                strncmp(_FirstDelimPtr[x], _FirstDelims[x], len1) == 0;
          mm3 = strncmp(_FirstDelimPtr[x], _LastDelims[y], len2) == 0;
          
          DelimMatch_[z] =
            (!mm3 &&
             strncmp(_LastDelimPtr[y], _LastDelims[y], len2) == 0) ?
              ((len2 > len1) ? 2:
               (mm1 || mm2)  ? 1:2):
            (strncmp(_FirstDelimPtr[x], _LastDelims[y], len2) == 0) ?
              ((len2 > len1 ||
                (z > 0 && len2 == len1 && DelimMatch_[z-1] == 2)) ? 2:
               (mm1 || mm2)  ? 1:2):1;
        }
        else
          DelimMatch_[z] = 1;
      }
      else if (_LastDelims[y] && _LastDelimFound[y])
      {
        if (_DelimSetTypeFound == LAST_SET)
          DelimMatch_[z] = 2;
        else if (_FirstDelims[x])
        {
          mm1 = _FirstDelimPtr[x] && _LastDelims[y] &&
                strncmp(_FirstDelimPtr[x], _LastDelims[y], len2) == 0;
          mm2 = _LastDelimPtr[y] && _LastDelims[y] &&
                strncmp(_LastDelimPtr[y], _LastDelims[y], len2) == 0;
          mm3 = strncmp(_LastDelimPtr[y], _FirstDelims[x], len1) == 0;
          
          DelimMatch_[z] =
            (!mm3 &&
             strncmp(_FirstDelimPtr[x], _FirstDelims[x], len1) == 0) ?
              ((len1 > len2) ? 1:
               (mm1 || mm2)  ? 2:1):
            (strncmp(_LastDelimPtr[y], _FirstDelims[x], len1) == 0) ?
              ((len1 > len2 ||
                (z > 0 && len2 == len1 && DelimMatch_[z-1] == 1)) ? 1:
               (mm1 || mm2)  ? 2:1):2;
        }
        else
          DelimMatch_[z] = 2;
      }

      if ((DelimMatch_[z] == 0 || DelimMatch_[z] == 2) && x < TextFileLineBuffer::MAXDELIMS-1 &&
          _FirstDelimOptional[x] && !_LastDelimOptional[y] && !_FirstDelimOptional[x+1])
        x++;
      else if ((DelimMatch_[z] == 0 || DelimMatch_[z] == 1) && y < TextFileLineBuffer::MAXDELIMS-1 &&
               _LastDelimOptional[y] && !_FirstDelimOptional[x] && !_LastDelimOptional[y+1])
        y++;
      else
      {
        x++;
        y++;
        z++;
      }
    }

    dlmval = 0;
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS && dlmval >= 0; x++)
    {
      preval = dlmval;
      dlmval = (DelimMatch_[x] == 1) ?
                  ((!dlmval || dlmval == 1)                ? 1:
                   (dlmval == 2 && _FirstDelimOptional[x]) ? 2:-1):
               (DelimMatch_[x] == 2) ?
                  ((!dlmval || dlmval == 2)                ? 2:
                   (dlmval == 1 && _LastDelimOptional[x])  ? 1:-1):
               (DelimMatch_[x] == 0) ?
                  ((preval == 1) ?
                      ((_FirstDelimOptional[x] || !_FirstDelims[x]) ? 1:
                       (!_LastDelimOptional[x] && _LastDelims[x])   ? 2:
                       preval):
                   (preval == 2) ?
                      ((_LastDelimOptional[x] || !_LastDelims[x])   ? 2:
                       (!_FirstDelimOptional[x] && _FirstDelims[x]) ? 1:
                       preval):0):DelimMatch_[x];
    }

    if (dlmval > 0)
    {
      Match1_ = false;
      Match2_ = false;
    
      for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS;)
      {
        DelimMatch_[x] = dlmval;

        if ((Match2_ || _FirstDelimFound[x]) && DelimMatch_[x] == 2)
        {
          len1 = ::SafeStrLen(_FirstDelims[x]);
          len2 = ::SafeStrLen(_LastDelims[y]);

          if (_LastDelims[y] && _FirstDelims[x] &&
              (strncmp(_FirstDelims[x], _LastDelims[y], len1) != 0 &&
               strncmp(_LastDelims[y], _FirstDelims[x], len2) != 0))
          {
            if (_FirstDelimOptional[x])
              x++;
            else if (_LastDelimOptional[y])
              y++;

            if (_FirstDelimOptional[x] || _LastDelimOptional[y])
              continue;
          }

          Match2_ = true;
          _LastDelimPos[y] = _FirstDelimPos[x];
          _FirstDelimPos[x] = 0;
          _LastDelimPtr[y] = _FirstDelimPtr[x];
          _FirstDelimPtr[x] = NULL;
          
          _LastDelimFound[y++] = _FirstDelimFound[x];
          _FirstDelimFound[x++] = false;
        }
        else if ((Match1_ || _LastDelimFound[x]) && DelimMatch_[x] == 1)
        {
          len1 = ::SafeStrLen(_FirstDelims[x]);
          len2 = ::SafeStrLen(_LastDelims[y]);

          if (_LastDelims[y] && _FirstDelims[x] &&
              (strncmp(_FirstDelims[x], _LastDelims[y], len1) != 0 &&
               strncmp(_LastDelims[y], _FirstDelims[x], len2) != 0))
          {
            if (_FirstDelimOptional[x])
              x++;
            else if (_LastDelimOptional[y])
              y++;

            if (_FirstDelimOptional[x] || _LastDelimOptional[y])
              continue;
          }
        
          Match1_ = true;
          _FirstDelimPos[y] = _LastDelimPos[x];
          _LastDelimPos[x] = 0;
          _FirstDelimPtr[y] = _LastDelimPtr[x];
          _LastDelimPtr[x] = NULL;
          
          _FirstDelimFound[y++] = _LastDelimFound[x];
          _LastDelimFound[x++] = false;
        }
        else
        {
          x++;
          y++;
        }
      }

      for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS;)
      {
        if (Match2_ && DelimMatch_[x] == 2 && _FirstDelimFound[x])
        {
          len1 = ::SafeStrLen(_FirstDelims[x]);
          len2 = ::SafeStrLen(_LastDelims[y]);

          if (_LastDelims[y] && _FirstDelims[x] &&
              (strncmp(_FirstDelims[x], _LastDelims[y], len1) != 0 &&
               strncmp(_LastDelims[y], _FirstDelims[x], len2) != 0))
          {
            if (_FirstDelimOptional[x])
              x++;
            else if (_LastDelimOptional[y])
              y++;

            if (_FirstDelimOptional[x] || _LastDelimOptional[y])
              continue;
          }

          _LastDelimPos[y] = _FirstDelimPos[x];
          _FirstDelimPos[x] = 0;
          _LastDelimPtr[y] = _FirstDelimPtr[x];
          _FirstDelimPtr[x] = NULL;
          
          _LastDelimFound[y++] = _FirstDelimFound[x];
          _FirstDelimFound[x++] = false;
        }
        else if (Match1_ && DelimMatch_[x] == 1 && _LastDelimFound[x])
        {
          len1 = ::SafeStrLen(_FirstDelims[x]);
          len2 = ::SafeStrLen(_LastDelims[y]);

          if (_LastDelims[y] && _FirstDelims[x] &&
              (strncmp(_FirstDelims[x], _LastDelims[y], len1) != 0 &&
               strncmp(_LastDelims[y], _FirstDelims[x], len2) != 0))
          {
            if (_FirstDelimOptional[x])
              x++;
            else if (_LastDelimOptional[y])
              y++;

            if (_FirstDelimOptional[x] || _LastDelimOptional[y])
              continue;
          }
        
          _FirstDelimPos[y] = _LastDelimPos[x];
          _LastDelimPos[x] = 0;
          _FirstDelimPtr[y] = _LastDelimPtr[x];
          _LastDelimPtr[x] = NULL;
          
          _FirstDelimFound[y++] = _LastDelimFound[x];
          _LastDelimFound[x++] = false;
        }
        else
        {
          x++;
          y++;
        }
      }
    }

    if (_DelimSetTypeFound == FIRST_SET && dlmval == 2)
      _DelimSetTypeFound = LAST_SET;
    else if (_DelimSetTypeFound == LAST_SET && dlmval == 1)
      _DelimSetTypeFound = FIRST_SET;

    fnd = Match1_ || Match2_;
    return fnd;
  }

  return false;
}

/****************************************************************************/
bool TextFileLineBuffer::SetMatchingDelims(char** Delims_)
{
  int x, y;
  size_t len = 0;
  size_t len1;
  size_t len2;
  bool ret = false;
  bool fnd = false;
  bool match = false;
  bool dlmfnd = true;

  if (Delims_ == _FirstDelims)
  {
    for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS &&
         _FirstDelims[x] && _LastDelims[y] && (x == 0 || ret);)
    {
      len1 = ::SafeStrLen(_FirstDelims[x]);
      len2 = ::SafeStrLen(_LastDelims[y]);
      len = (len1 == len2) ? len1:0;

      dlmfnd = dlmfnd && _FirstDelimFound[x];
      fnd = (x == 0 || ret) && len > 0 &&
            ((_FirstDelimFound[x] && ::strcmp(_FirstDelims[x], _LastDelims[y]) == 0));
      ret = fnd || _FirstDelimOptional[x];

      if (!fnd)
      {
        if (_FirstDelimOptional[x])
          x++;
        else
        {
          x++;
          y++;
        }
      }
      else
      {
        x++;
        y++;
      }
    }

    if (ret && (!dlmfnd || (NumDelims(_FirstDelims) == NumDelims(_LastDelims))))
    {
      for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS &&
           _FirstDelims[x] && _LastDelims[y] && (x == 0 || ret);)
      {
        len1 = ::SafeStrLen(_FirstDelims[x]);
        len2 = ::SafeStrLen(_LastDelims[y]);
        len = (len1 == len2) ? len1:0;

        fnd = (x == 0 || ret) && len > 0 &&
              ((_FirstDelimFound[x] && ::strcmp(_FirstDelims[x], _LastDelims[y]) == 0));
        ret = fnd || _FirstDelimOptional[x];

        if (!fnd)
        {
          if (_FirstDelimOptional[x])
            x++;
          else
          {
            x++;
            y++;
          }
        }
        else if (_FirstDelims[x] && _FirstDelimFound[x])
        {
          _LastDelimPos[y] = _FirstDelimPos[x];
          _FirstDelimPos[x] = 0;
          _LastDelimPtr[y] = _FirstDelimPtr[x];
          _FirstDelimPtr[x] = NULL;
          
          _LastDelimFound[y++] = _FirstDelimFound[x];
          _FirstDelimFound[x++] = false;
        }
      }

      if (_DelimSetTypeFound == FIRST_SET)
        _DelimSetTypeFound = LAST_SET;
    }
  }
  else if (Delims_ == _LastDelims)
  {
    for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS &&
         _LastDelims[x] && _FirstDelims[y] && (x == 0 || ret);)
    {
      len1 = ::SafeStrLen(_FirstDelims[y]);
      len2 = ::SafeStrLen(_LastDelims[x]);
      len = (len1 == len2) ? len1:0;

      dlmfnd = dlmfnd && _LastDelimFound[x];
      fnd = (x == 0 || ret) && len > 0 &&
            ((_LastDelimFound[x] && ::strcmp(_LastDelims[x], _FirstDelims[y]) == 0));
      ret = fnd || _LastDelimOptional[x];

      if (!fnd)
      {
        if (_LastDelimOptional[x])
          x++;
        else
        {
          x++;
          y++;
        }
      }
      else
      {
        x++;
        y++;
      }
    }

    if (ret && (!dlmfnd || (NumDelims(_FirstDelims) == NumDelims(_LastDelims))))
    {
      for (x = y = 0; x < TextFileLineBuffer::MAXDELIMS &&
           _LastDelims[x] && _FirstDelims[y] && (x == 0 || ret);)
      {
        len1 = ::SafeStrLen(_FirstDelims[y]);
        len2 = ::SafeStrLen(_LastDelims[x]);
        len = (len1 == len2) ? len1:0;

        fnd = (x == 0 || ret) && len > 0 &&
              ((_LastDelimFound[x] && ::strcmp(_LastDelims[x], _FirstDelims[y]) == 0));
        ret = fnd || _LastDelimOptional[x];

        if (!fnd)
        {
          if (_LastDelimOptional[x])
            x++;
          else
          {
            x++;
            y++;
          }
        }
        else if (_LastDelims[x] && _LastDelimFound[x])
        {
          _FirstDelimPos[y] = _LastDelimPos[x];
          _LastDelimPos[x] = 0;
          _FirstDelimPtr[y] = _LastDelimPtr[x];
          _LastDelimPtr[x] = 0;
          
          _FirstDelimFound[y++] = _LastDelimFound[x];
          _LastDelimFound[x++] = false;
        }
      }

      if (_DelimSetTypeFound == LAST_SET)
        _DelimSetTypeFound = FIRST_SET;
    }
  }

  return ret;
}

/****************************************************************************/
void TextFileLineBuffer::CountColsRows(const char* Buf_, long Len_, const char* Delim_)
{
  long x;
  for (x = 0; x < Len_; x++)
    CountColsRows(Buf_[x]);

  if (Delim_)
    CountColsRows(*Delim_);
}

/****************************************************************************/
void TextFileLineBuffer::CountColsRows(const char* Buf_, const char* Delim_)
{
  if (Buf_ && Delim_)
  {
    size_t x;
    size_t len = strlen(Buf_);
  
    if (*Delim_ == '\n')
    {
      if (_FilePos->ColPos() || _FilePos->RowPos())
      {
        _FilePos->IncRowPos();
        _ColStk->Push(new long(_FilePos->ColPos()));
        _FilePos->ResetColPos();
      }
        
      for (_FilePos->ResetColPos(); _FilePos->ColPos() < len; _FilePos->IncColPos())
        CountColsRows(Buf_[_FilePos->ColPos()]);
    }
    else
    {
      for (x = 0; x < len; x++)
        CountColsRows(Buf_[x]);

      CountColsRows(*Delim_);
    }
  }
}

/****************************************************************************/
char TextFileLineBuffer::CountColsRows(char ch)
{
  if (ch != 0)
    if (ch == '\n')
    {
      _FilePos->IncRowPos();
      _ColStk->Push(new long(_FilePos->ColPos()));
      _FilePos->ResetColPos();
    }
    else
      _FilePos->IncColPos();

  return ch;
}

/****************************************************************************/
char TextFileLineBuffer::UnCountColsRows(char ch)
{
  long* valp_ = NULL;
  
  if (ch != 0)
    if (ch == '\n')
    {
      _FilePos->DecRowPos();
      valp_ = _ColStk->Pop();
      
      if (valp_)
      {
        _FilePos->SetColPos(*valp_);
        ::Delete(valp_);
      }
    }
    else    
      _FilePos->DecColPos();

  return ch;
}

/****************************************************************************/
bool TextFileLineBuffer::ReadUntilDelimFound() const
{
  bool RdFirst_ = _QuitReadOnFirstDelimSetFound && _ReadUntilFirstDelimSetFound;
  bool RdLast_ = _QuitReadOnLastDelimSetFound && _ReadUntilLastDelimSetFound;

  return
  (
    (RdFirst_ && RdLast_) ? !(_LastDelimSetFound || _FirstDelimSetFound):
    RdLast_ ? !_LastDelimSetFound:
    RdFirst_ ? !_FirstDelimSetFound:
               false
  );
}

/****************************************************************************/
bool TextFileLineBuffer::QuitReadDelimFound() const
{
  return
  (
    (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
    (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true))
  );
}

/****************************************************************************/
int TextFileLineBuffer::DelimSetComplete(char** Delims_,
                                         bool* PartialMatch_, int* TxtBufMatch_) const
{
  if (!_TextBuffer)
    return 0;

  int x;
  int len;
  
  bool ret = false;
  bool match = false;
  bool error = false;
  bool partial = false;
  bool txtpartial = false;
  bool txtbufmatch = false;

  bool txtfnd[3];
  txtfnd[0] = txtfnd[1] = txtfnd[2] = false;

  if (Delims_ == _FirstDelims)
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS &&
         (_FirstDelims[x] || _FirstDelimOptional[x]) && (x == 0 || ret); x++)
    {
      match = (x == 0 || match) && _FirstDelimFound[x];
      ret = (x == 0 || ret) && (_FirstDelimFound[x] || _FirstDelimOptional[x]);
    }

    len = strlen(_TextBuffer);
    for (x = len-1; x >= 0 && !(txtfnd[0] && txtfnd[1] && txtfnd[2]); x--)
    {
      if (_FirstDelims[0] &&
          strncmp(&_TextBuffer[x], _FirstDelims[0], strlen(_FirstDelims[0])) == 0)
      {
        if (!txtfnd[0])
          txtfnd[0] = true;
        else
        {
          error = true;
          break;
        }
      }
      else if (_FirstDelims[1] &&
               strncmp(&_TextBuffer[x], _FirstDelims[1], strlen(_FirstDelims[1])) == 0)
      {
        if (!txtfnd[1])
          txtfnd[1] = true;
        else
        {
          error = true;
          break;
        }
      }
      else if (_FirstDelims[2] &&
               strncmp(&_TextBuffer[x], _FirstDelims[2], strlen(_FirstDelims[2])) == 0)
      {
        if (!txtfnd[2])
          txtfnd[2] = true;
        else
        {
          error = true;
          break;
        }
      }
    }

    if (PartialMatch_)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
        partial = partial || (_FirstDelimFound[x] && !_FirstDelimOptional[x]);

    if (TxtBufMatch_)
    {
      if (error)
        txtpartial = txtbufmatch = false;
      else
        for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
        {
          txtpartial = txtpartial ||
                       ((txtfnd[x] &&
                         (_FirstDelimPtr[x] || _LastDelimPtr[x])) &&
                        !_FirstDelimOptional[x]);
          txtbufmatch = (x == 0 || txtbufmatch) &&
                        ((txtfnd[x] &&
                          (_FirstDelimPtr[x] || _LastDelimPtr[x])) ||
                         _FirstDelimOptional[x]);
        }
    }
  }
  else if (Delims_ == _LastDelims)
  {
    for (x = 0; x < TextFileLineBuffer::MAXDELIMS &&
         (_LastDelims[x] || _LastDelimOptional[x]) && (x == 0 || ret); x++)
    {
      match = (x == 0 || match) && _LastDelimFound[x];
      ret = (x == 0 || ret) && (_LastDelimFound[x] || _LastDelimOptional[x]);
    }

    len = strlen(_TextBuffer);
    for (x = len-1; x >= 0 && !(txtfnd[0] && txtfnd[1] && txtfnd[2]); x--)
    {
      if (_LastDelims[0] &&
          strncmp(&_TextBuffer[x], _LastDelims[0], strlen(_LastDelims[0])) == 0)
      {
        if (!txtfnd[0])
          txtfnd[0] = true;
        else
        {
          error = true;
          break;
        }
      }
      else if (_LastDelims[1] &&
               strncmp(&_TextBuffer[x], _LastDelims[1], strlen(_LastDelims[1])) == 0)
      {
        if (!txtfnd[1])
          txtfnd[1] = true;
        else
        {
          error = true;
          break;
        }
      }
      else if (_LastDelims[2] &&
               strncmp(&_TextBuffer[x], _LastDelims[2], strlen(_LastDelims[2])) == 0)
      {
        if (!txtfnd[2])
          txtfnd[2] = true;
        else
        {
          error = true;
          break;
        }
      }
    }

    if (PartialMatch_)
      for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
        partial = partial || (_LastDelimFound[x] && !_LastDelimOptional[x]);

    if (TxtBufMatch_)
    {
      if (error)
        txtpartial = txtbufmatch = false;
      else
        for (x = 0; x < TextFileLineBuffer::MAXDELIMS; x++)
        {
          txtpartial = txtpartial ||
                       ((txtfnd[x] &&
                         (_FirstDelimPtr[x] || _LastDelimPtr[x])) &&
                        !_LastDelimOptional[x]);
          txtbufmatch = (x == 0 || txtbufmatch) &&
                        ((txtfnd[x] &&
                          (_FirstDelimPtr[x] || _LastDelimPtr[x])) ||
                         _LastDelimOptional[x]);
        }
    }
  }

  if (PartialMatch_)
    *PartialMatch_ = (partial && !(match || ret));

  if (TxtBufMatch_)
  {
    partial = (txtpartial && !(match || ret));
    txtbufmatch = txtbufmatch && (match || ret);
    *TxtBufMatch_ = txtbufmatch ? COMPLETE:
                    partial     ? INCOMPLETE:NONE;
  }

  return (match ? COMPLETE:
          ret   ? INCOMPLETE:NONE);
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::DumpLineRecord(bool ColHead_)
{
  if (_LineData)
    _LineData->DumpData((_IoMode & FILE_OUTPUT) ?
                            _File->GetOutStream():cout, ColHead_);

  return *this;
}

/****************************************************************************/
int TextFileLineBuffer::SearchForFirstDelims(char ch, long PrevCol_, int& ArrayIndex_,
                                             int& StringIndex_, int& DelimType_, bool& Found_)
{
  if (!_FirstDelimFound[0] &&
      _FirstDelims[0] && _FirstDelims[0][0] == ch &&
        ((PrevCol_ < _FirstDelimPos[1] || !_FirstDelimFound[1]) &&
         (PrevCol_ < _FirstDelimPos[2] || !_FirstDelimFound[2])))
  {
    if (strlen(_FirstDelims[0]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 0;
      DelimType_ = STARTING;
    }
    else
    {
      StringIndex_ = 0;

      if (!_InComment || !_XmlTypeTag)
      {
        _FirstDelimFound[0] = true;
        _FirstDelimPtr[0] = _CurPosPtr;
        _FirstDelimPos[0] = PrevCol_;
      }

      if (_XmlTypeTag)
      {
        _ResetCmmntSeg = true;
        _TestCmmntSeg = STARTING;
        _DelimsToTest = STARTING;
      }
    }

    Found_ = true;
  }
  else if (_FirstDelimFound[0] &&
           _FirstDelims[0] && _FirstDelims[0][0] == ch &&
             ((!_FirstDelimFound[1] && !_FirstDelimOptional[1]) ||
              (!_FirstDelimFound[2] && !_FirstDelimOptional[2])))
  {
    if (strlen(_FirstDelims[0]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 0;
      DelimType_ = STARTING;
    }
    else
      StringIndex_ = 0;

    Found_ = true;
    return FIRST_SET;
  }
  else if (!_FirstDelimFound[1] &&
           _FirstDelims[1] && _FirstDelims[1][0] == ch &&
             ((_FirstDelimPos[0] < PrevCol_ && _FirstDelimFound[0]) ||
              (!_FirstDelimFound[0] && (_FirstDelimOptional[0] || _InComment))) &&
             (PrevCol_ < _FirstDelimPos[2] || !_FirstDelimFound[2]))
  {
    if (strlen(_FirstDelims[1]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 1;
      DelimType_ = STARTING;
    }
    else
    {
      StringIndex_ = 0;

      if ((_FirstDelimOptional[0] || _FirstDelimFound[0] || _InComment) || !_XmlTypeTag)
      {
        _FirstDelimFound[1] = true;
        _FirstDelimPtr[1] = _CurPosPtr;
        _FirstDelimPos[1] = PrevCol_;
      }

      if (_XmlTypeTag && !_FirstDelims[2])
      {
        _TestCmmntSeg = ENDING;
        _DelimsToTest = STARTING;
      }
    }

    Found_ = true;
  }
  else if (!_FirstDelimFound[2] &&
           _FirstDelims[2] && _FirstDelims[2][0] == ch &&
             ((_FirstDelimPos[0] < PrevCol_ && _FirstDelimFound[0]) ||
              (!_FirstDelimFound[0] && (_FirstDelimOptional[0] || _InComment))) &&
             ((_FirstDelimPos[1] < PrevCol_ && _FirstDelimFound[1]) ||
              (!_FirstDelimFound[1] && (_FirstDelimOptional[1] || _InComment))))
  {
    if (strlen(_FirstDelims[2]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 2;
      DelimType_ = STARTING;
    }
    else
    {
      StringIndex_ = 0;

      if ((_FirstDelimOptional[0] || _FirstDelimFound[0] ||
           _FirstDelimOptional[1] || _FirstDelimFound[1] || _InComment) || !_XmlTypeTag)
      {
        _FirstDelimFound[2] = true;
        _FirstDelimPtr[2] = _CurPosPtr;
        _FirstDelimPos[2] = PrevCol_;
      }

      if (_XmlTypeTag)
      {
        _TestCmmntSeg = ENDING;
        _DelimsToTest = STARTING;
      }
    }

    Found_ = true;
  }
  else
    Found_ = false;

  return NONE;
}

/****************************************************************************/
int TextFileLineBuffer::SearchForLastDelims(char ch, long PrevCol_, int& ArrayIndex_,
                                            int& StringIndex_, int& DelimType_, bool& Found_)
{
  if (!_LastDelimFound[0] &&
      _LastDelims[0] && _LastDelims[0][0] == ch &&
        ((PrevCol_ < _LastDelimPos[1] || !_LastDelimFound[1]) &&
         (PrevCol_ < _LastDelimPos[2] || !_LastDelimFound[2])))
  {
    if (strlen(_LastDelims[0]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 0;
      DelimType_ = ENDING;
    }
    else
    {
      StringIndex_ = 0;

      if (!_InComment || !_XmlTypeTag)
      {
        _LastDelimFound[0] = true;
        _LastDelimPtr[0] = _CurPosPtr;
        _LastDelimPos[0] = PrevCol_;
      }

      if (_XmlTypeTag)
      {
        _ResetCmmntSeg = true;
        _TestCmmntSeg = STARTING;
        _DelimsToTest = ENDING;
      }
    }

    Found_ = true;
  }
  else if (_LastDelimFound[0] &&
           _LastDelims[0] && _LastDelims[0][0] == ch &&
             ((!_LastDelimFound[1] && !_LastDelimOptional[1]) ||
              (!_LastDelimFound[2] && !_LastDelimOptional[2])))
  {
    if (strlen(_LastDelims[0]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 0;
      DelimType_ = ENDING;
    }
    else
      StringIndex_ = 0;

    Found_ = true;
    return LAST_SET;
  }
  else if (!_LastDelimFound[1] &&
           _LastDelims[1] && _LastDelims[1][0] == ch &&
             ((_LastDelimPos[0] < PrevCol_ && _LastDelimFound[0]) ||
              (!_LastDelimFound[0] && (_LastDelimOptional[0] || _InComment))) &&
             (PrevCol_ < _LastDelimPos[2] || !_LastDelimFound[2]))
  {
    if (strlen(_LastDelims[1]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 1;
      DelimType_ = ENDING;
    }
    else
    {
      StringIndex_ = 0;

      if ((_LastDelimOptional[0] || _LastDelimFound[0] || _InComment) || !_XmlTypeTag)
      {
        _LastDelimFound[1] = true;
        _LastDelimPtr[1] = _CurPosPtr;
        _LastDelimPos[1] = PrevCol_;
      }

      if (_XmlTypeTag && !_LastDelims[2])
      {
        _TestCmmntSeg = ENDING;
        _DelimsToTest = ENDING;
      }
    }

    Found_ = true;
  }
  else if (!_LastDelimFound[2] &&
           _LastDelims[2] && _LastDelims[2][0] == ch &&
             ((_LastDelimPos[0] < PrevCol_ && _LastDelimFound[0]) ||
              (!_LastDelimFound[0] && (_LastDelimOptional[0] || _InComment))) &&
             ((_LastDelimPos[1] < PrevCol_ && _LastDelimFound[1]) ||
              (!_LastDelimFound[1] && (_LastDelimOptional[1] || _InComment))))
  {
    if (strlen(_LastDelims[2]) > 1)
    {
      StringIndex_ = 1;
      ArrayIndex_ = 2;
      DelimType_ = ENDING;
    }
    else
    {
      StringIndex_ = 0;

      if ((_LastDelimOptional[0] || _LastDelimFound[0] ||
           _LastDelimOptional[1] || _LastDelimFound[1] || _InComment) || !_XmlTypeTag)
      {
        _LastDelimFound[2] = true;
        _LastDelimPtr[2] = _CurPosPtr;
        _LastDelimPos[2] = PrevCol_;
      }

      if (_XmlTypeTag)
      {
        _TestCmmntSeg = ENDING;
        _DelimsToTest = ENDING;
      }
    }

    Found_ = true;
  }
  else
    Found_ = false;

  return NONE;
}

/****************************************************************************/
int TextFileLineBuffer::SearchForDelims(char** Delims_, char ch, long PrevCol_,
                                        int& ArrayIndex_, int& StringIndex_, int& DelimType_)
{
  int x, y;
  int ret = NONE;
  int len1 = ::SafeStrLen(_FirstDelims[0]);
  int len2 = ::SafeStrLen(_LastDelims[0]);
  
  bool Found_ = false;
  bool done = false;  
  bool fnd;

  if (StringIndex_ > 0)
  {
    if (DelimType_ == STARTING)
    {
      if (_FirstDelims[ArrayIndex_] && _FirstDelims[ArrayIndex_][StringIndex_] == ch)
      {
        if (strlen(_FirstDelims[ArrayIndex_]+StringIndex_) > 1)
          ++StringIndex_;
        else
        {
          long DelimStart_ = PrevCol_ - StringIndex_;

          if (((!_InComment && ArrayIndex_ == 0) ||
               (ArrayIndex_ != 0 &&
               (_FirstDelimOptional[ArrayIndex_] || _FirstDelimFound[ArrayIndex_] || _InComment))) ||
               !_XmlTypeTag)
          {
            _FirstDelimFound[ArrayIndex_] = true;
            _FirstDelimPtr[ArrayIndex_] = _CurPosPtr;
            _FirstDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
          }
          
          StringIndex_ = ArrayIndex_ = 0;
          DelimType_ = NONE;

          if (_XmlTypeTag)
          {
            if (ArrayIndex_ == 0)
            {
              _ResetCmmntSeg = true;
              _TestCmmntSeg = STARTING;
              _DelimsToTest = STARTING;
            }
            else if ((ArrayIndex_ == 1 && !_FirstDelims[2]) || ArrayIndex_ == 2)
            {
              _TestCmmntSeg = ENDING;
              _DelimsToTest = STARTING;
            }
          }
        }

        done = true;
      }
      else if (DelimSetComplete(_LastDelims) == 0)
      {
        fnd = false;
        for (x = y = ArrayIndex_; y >= 0 && !_LastDelims[y] ||
             !(fnd=strncmp(_FirstDelims[x], _LastDelims[y], StringIndex_) == 0);)
          if (_FirstDelimOptional[x])
            --y;
          else
            break;

        if (fnd && _LastDelims[y])
        {
          ArrayIndex_ = y;
          DelimType_ == ENDING;

          if (strlen(_LastDelims[y]) > StringIndex_ &&
              _LastDelims[y][StringIndex_] == ch)
          {
            if (strlen(_LastDelims[ArrayIndex_]+StringIndex_) > 1)
              ++StringIndex_;
            else
            {
              long DelimStart_ = PrevCol_ - StringIndex_;

              if (((!_InComment && ArrayIndex_ == 0) ||
                   (ArrayIndex_ != 0 &&
                   (_LastDelimOptional[ArrayIndex_] || _LastDelimFound[ArrayIndex_] || _InComment))) ||
                   !_XmlTypeTag)
              {
                _LastDelimFound[ArrayIndex_] = true;
                _LastDelimPtr[ArrayIndex_] = _CurPosPtr;
                _LastDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
              }
              
              StringIndex_ = ArrayIndex_ = 0;
              DelimType_ = NONE;

              if (_XmlTypeTag)
              {
                if (ArrayIndex_ == 0)
                {
                  _ResetCmmntSeg = true;
                  _TestCmmntSeg = STARTING;
                  _DelimsToTest = ENDING;
                }
                else if ((ArrayIndex_ == 1 && !_LastDelims[2]) || ArrayIndex_ == 2)
                {
                  _TestCmmntSeg = ENDING;
                  _DelimsToTest = ENDING;
                }
              }
            }

            done = true;
          }
          else if (strlen(_LastDelims[y]) == StringIndex_)
          {
            long DelimStart_ = PrevCol_ - StringIndex_;

            if (((!_InComment && ArrayIndex_ == 0) ||
                 (ArrayIndex_ != 0 &&
                 (_LastDelimOptional[ArrayIndex_] || _LastDelimFound[ArrayIndex_] || _InComment))) ||
                 !_XmlTypeTag)
            {
              _LastDelimFound[ArrayIndex_] = true;
              _LastDelimPtr[ArrayIndex_] = _CurPosPtr;
              _LastDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
            }

            StringIndex_ = ArrayIndex_ = 0;
            DelimType_ = NONE;
            done = true;

            if (_XmlTypeTag)
            {
              if (ArrayIndex_ == 0)
              {
                _ResetCmmntSeg = true;
                _TestCmmntSeg = STARTING;
                _DelimsToTest = ENDING;
              }
              else if ((ArrayIndex_ == 1 && !_LastDelims[2]) || ArrayIndex_ == 2)
              {
                _TestCmmntSeg = ENDING;
                _DelimsToTest = ENDING;
              }
            }
          }
        }
      }

      if (!done)
      {
        StringIndex_ = ArrayIndex_ = 0;
        DelimType_ = NONE;
      }
    }
    else if (DelimType_ == ENDING)
    {
      if (_LastDelims[ArrayIndex_] && _LastDelims[ArrayIndex_][StringIndex_] == ch)
      {
        if (strlen(_LastDelims[ArrayIndex_]+StringIndex_) > 1)
          ++StringIndex_;
        else
        {
          long DelimStart_ = PrevCol_ - StringIndex_;

          if (((!_InComment && ArrayIndex_ == 0) ||
               (ArrayIndex_ != 0 &&
               (_LastDelimOptional[ArrayIndex_] || _LastDelimFound[ArrayIndex_] || _InComment))) ||
               !_XmlTypeTag)
          {
            _LastDelimFound[ArrayIndex_] = true;
            _LastDelimPtr[ArrayIndex_] = _CurPosPtr;
            _LastDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
          }

          StringIndex_ = ArrayIndex_ = 0;
          DelimType_ = NONE;

          if (_XmlTypeTag)
          {
            if (ArrayIndex_ == 0)
            {
              _ResetCmmntSeg = true;
              _TestCmmntSeg = STARTING;
              _DelimsToTest = ENDING;
            }
            else if ((ArrayIndex_ == 1 && !_LastDelims[2]) || ArrayIndex_ == 2)
            {
              _TestCmmntSeg = ENDING;
              _DelimsToTest = ENDING;
            }
          }
        }

        done = true;
      }
      else if (DelimSetComplete(_FirstDelims) == 0)
      {
        fnd = false;
        for (x = y = ArrayIndex_; y >= 0 && !_FirstDelims[y] ||
             !(fnd=strncmp(_LastDelims[x], _FirstDelims[y], StringIndex_) == 0);)
          if (_LastDelimOptional[x])
            --y;
          else
            break;
        
        if (fnd && _FirstDelims[y])
        {
          ArrayIndex_ = y;
          DelimType_ == STARTING;

          if (strlen(_FirstDelims[y]) > StringIndex_ &&
              _FirstDelims[y][StringIndex_] == ch)
          {
            if (strlen(_FirstDelims[ArrayIndex_]+StringIndex_) > 1)
              ++StringIndex_;
            else
            {
              long DelimStart_ = PrevCol_ - StringIndex_;

              if (((!_InComment && ArrayIndex_ == 0) ||
                   (ArrayIndex_ != 0 &&
                   (_FirstDelimOptional[ArrayIndex_] || _FirstDelimFound[ArrayIndex_] || _InComment))) ||
                   !_XmlTypeTag)
              {
                _FirstDelimFound[ArrayIndex_] = true;
                _FirstDelimPtr[ArrayIndex_] = _CurPosPtr;
                _FirstDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
              }

              StringIndex_ = ArrayIndex_ = 0;
              DelimType_ = NONE;

              if (_XmlTypeTag)
              {
                if (ArrayIndex_ == 0)
                {
                  _ResetCmmntSeg = true;
                  _TestCmmntSeg = STARTING;
                  _DelimsToTest = STARTING;
                }
                else if ((ArrayIndex_ == 1 && !_FirstDelims[2]) || ArrayIndex_ == 2)
                {
                  _TestCmmntSeg = ENDING;
                  _DelimsToTest = STARTING;
                }
              }
            }

            done = true;
          }
          else if (strlen(_FirstDelims[y]) == StringIndex_)
          {
            long DelimStart_ = PrevCol_ - StringIndex_;

            if (((!_InComment && ArrayIndex_ == 0) ||
                 (ArrayIndex_ != 0 &&
                 (_FirstDelimOptional[ArrayIndex_] || _FirstDelimFound[ArrayIndex_] || _InComment))) ||
                 !_XmlTypeTag)
            {
              _FirstDelimFound[ArrayIndex_] = true;
              _FirstDelimPtr[ArrayIndex_] = _CurPosPtr;
              _FirstDelimPos[ArrayIndex_] = (DelimStart_ >= 0) ? DelimStart_:PrevCol_;
            }

            StringIndex_ = ArrayIndex_ = 0;
            DelimType_ = NONE;
            done = true;

            if (_XmlTypeTag)
            {
              if (ArrayIndex_ == 0)
              {
                _ResetCmmntSeg = true;
                _TestCmmntSeg = STARTING;
                _DelimsToTest = STARTING;
              }
              else if ((ArrayIndex_ == 1 && !_FirstDelims[2]) || ArrayIndex_ == 2)
              {
                _TestCmmntSeg = ENDING;
                _DelimsToTest = STARTING;
              }
            }
          }
        }
      }

      if (!done)
      {
        StringIndex_ = ArrayIndex_ = 0;
        DelimType_ = NONE;
      }
    }
  }
  else if (Delims_ == _LastDelims)
  {
    if (_FirstDelimFound[0] || !(len2 > len1 || strncmp(_LastDelims[0], _FirstDelims[0], len2)))
    {
      ret = SearchForFirstDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
      if (!Found_ || !_FirstDelimFound[ArrayIndex_])
        ret = SearchForLastDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
    }
    else
    {
      ret = SearchForLastDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
      if (!Found_ || !_LastDelimFound[ArrayIndex_])
        ret = SearchForFirstDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
    }
  }
  else if (Delims_ == _FirstDelims)
  {
    if (_LastDelimFound[0] || !(len1 > len2 || strncmp(_FirstDelims[0], _LastDelims[0], len1)))
    {
      ret = SearchForLastDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
      if (!Found_ || !_LastDelimFound[ArrayIndex_])
        ret = SearchForFirstDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
    }
    else
    {
      ret = SearchForFirstDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
      if (!Found_ || !_FirstDelimFound[ArrayIndex_])
        ret = SearchForLastDelims(ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_, Found_);
    }  
  }

  return ret;
}

/****************************************************************************/
//  Text file line record format:
//
//    <RowPos>,<LineFitInBuffer>:<SingleDelimSetFound>,<DelimSetTypeFound>:
//    <TimesLimitReached>:<ReadTimesRequired>:<EolFound>,<EolPos>:
//    <EofFound>,<EofPos>:
//    <LenQueueSize>:<va1_size><va1_len0>:<va1_len1>...:<va1_len...x>:
//                   <va2_size><va2_len0>:<va2_len1>...:<va2_len...x>:
//                   ...
//                   <vax_size><vax_len0>:<vax_len1>...:<vax_len...x>:
//    <DelimQueueSize>:<FirstDelimFound>[0],[1],[2]:
//                     <FirstDelimPos>[0],[1],[2]:
//                     <FirstDelims>[0],[1],[2]:
//    ...
//    <MidDelimFound...>[0],[1],[2]:
//    <MidDelimPos...>[0],[1],[2]:
//    <MidDelims...>[0],[1],[2]:
//    ...
//    <LastDelimFound>[0],[1],[2]:
//    <LastDelimPos>[0],[1],[2]:
//    <LastDelims>[0],[1],[2]
//
bool TextFileLineBuffer::While_Read(char* Input_)
{
  bool InputArg_ = Input_ != NULL;
  bool ReadDone_ = false;
  bool ReadOk_ = false;
  bool FirstSetCmp_ = false;
  bool LastSetCmp_ = false;
  
  int x = 0;
  int max = 3;

  if (_File && Input_ && !_EolFound && !_EofFound)
  {
    FirstSetCmp_ = !_XmlTypeTag || !_QuitReadOnFirstDelimSetFound;
    LastSetCmp_ = !_XmlTypeTag || !_QuitReadOnLastDelimSetFound;
  
    if (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true))
      ResetFirstDelims(0, true);

    if (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true))
      ResetLastDelims(0, true);

    if (FirstSetCmp_ || LastSetCmp_)
      ResetTotalTextRead();
      
    while ((!_EolFound || ReadUntilDelimFound()) && !_EofFound)
    {
      _SuppressSimplify = true;
      if (InputArg_)
        *this >>Input_;
      else
        Read();

      if (!ReadDone_)
      {
        ReadDone_ = _CharsRead != 0;
        ReadOk_ = ReadOk_ || ReadDone_;
      }
        
      if (ReadDone_ &&
          (_BufferFull || ((_WsFound || _EolFound) && !ReadUntilDelimFound())))
      {
        ResetBufferStatus();
        ReadDone_ = false;
      }
      else if (_EolFound)
      {
        ++x;
        
        if (x == max)
        {
          ResetBufferStatus();
          ReadDone_ = false;
          break;
        }
      }

      if (!_EolFound && !_EofFound)
        if ((_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
            (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
          break;

      if (_WsFound)
        break;
    }

    if (ReadOk_)
    {
      if (!_TotalTextRead.IsEmpty() && _SimplifyTagSpaces &&
          DelimSetsFound() && !_SplitTag)
        _TotalTextRead.SimplifySpaces(false);
    
      if (_LineData)
        *_LineData = *this;
      else
        _LineData = new TextFileLineData(*this);

      _LineData->SetTagBuffer(FillTagBuffer());
    }
    else if (_LineEmpty)
    {
      delete _LineData;
      _LineData = NULL;
    }
  }

  return (!_EofFound);
}

/****************************************************************************/
bool TextFileLineBuffer::While_ReadUntil(const char* CharSet_, bool InSet_, bool PutBack_)
{
  bool ReadDone_ = false;
  bool ReadOk_ = false;
  bool FirstSetCmp_ = false;
  bool LastSetCmp_ = false;

  int x = 0;
  int max = 3;

  if (_File && !_EolFound && !_EofFound)
  {
    FirstSetCmp_ = !_XmlTypeTag || !_QuitReadOnFirstDelimSetFound;
    LastSetCmp_ = !_XmlTypeTag || !_QuitReadOnLastDelimSetFound;

    if (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true))
      ResetFirstDelims(0, true);

    if (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true))
      ResetLastDelims(0, true);

    if (FirstSetCmp_ || LastSetCmp_)
      ResetTotalTextRead();

    while ((!_EolFound || ReadUntilDelimFound()) && !_EofFound)
    {
      _SuppressSimplify = true;
      ReadUntil(CharSet_, InSet_, PutBack_);

      if (!ReadDone_)
      {
        ReadDone_ = _CharsRead != 0;
        ReadOk_ = ReadOk_ || ReadDone_;
      }

      if (ReadDone_ &&
          (_BufferFull || ((_BrkChFound || _EolFound) && !ReadUntilDelimFound())))
      {
        ResetBufferStatus();
        ReadDone_ = false;
      }
      else if (_EofFound)
      {
        ++x;

        if (x == max)
        {
          ResetBufferStatus();
          ReadDone_ = false;
          break;
        }
      }

      if (!_EolFound && !_EofFound)
        if ((_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
            (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
          break;

      if (_BrkChFound)
        break;
    }

    if (ReadOk_)
    {
      if (!_TotalTextRead.IsEmpty() && _SimplifyTagSpaces &&
          DelimSetsFound() && !_SplitTag)
        _TotalTextRead.SimplifySpaces(false);
    
      if (_LineData)
        *_LineData = *this;
      else
        _LineData = new TextFileLineData(*this);

      _LineData->SetTagBuffer(FillTagBuffer());
    }
    else if (_LineEmpty)
    {
      delete _LineData;
      _LineData = NULL;
    }
  }

  return (!_EofFound);
}

/****************************************************************************/
bool TextFileLineBuffer::While_ReadLine()
{
  bool ReadDone_ = false;
  bool ReadOk_ = false;
  bool FirstSetCmp_ = false;
  bool LastSetCmp_ = false;

  int x = 0;
  int max = 3;

  if (_File && !_EolFound && !_EofFound)
  {
    FirstSetCmp_ = !_XmlTypeTag || !_QuitReadOnFirstDelimSetFound;
    LastSetCmp_ = !_XmlTypeTag || !_QuitReadOnLastDelimSetFound;

    if (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true))
      ResetFirstDelims(0, true);

    if (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true))
      ResetLastDelims(0, true);

    if (FirstSetCmp_ || LastSetCmp_)
      ResetTotalTextRead();

    while ((!_EolFound || ReadUntilDelimFound()) && !_EofFound)
    {
      _SuppressSimplify = true;
      ReadLine();

      if (!ReadDone_)
      {
        ReadDone_ = _CharsRead != 0;
        ReadOk_ = ReadOk_ || ReadDone_;
      }

      if (ReadDone_ &&
          (_BufferFull || (_EolFound && !ReadUntilDelimFound())))
      {
        ResetBufferStatus();
        ReadDone_ = false;
      }
      else if (_EolFound)
      {
        ++x;

        if (x == max)
        {
          ResetBufferStatus();
          ReadDone_ = false;
          break;
        }
      }

      if (!_EolFound && !_EofFound)
        if ((_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
            (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
          break;
    }

    if (ReadOk_)
    {
      if (!_TotalTextRead.IsEmpty() && _SimplifyTagSpaces &&
          DelimSetsFound() && !_SplitTag)
        _TotalTextRead.SimplifySpaces(false);
    
      if (_LineData)
        *_LineData = *this;
      else
        _LineData = new TextFileLineData(*this);

      _LineData->SetTagBuffer(FillTagBuffer());
    }
    else if (_LineEmpty)
    {
      delete _LineData;
      _LineData = NULL;
    }
  }

  return (!_EofFound);
}

/****************************************************************************/
ChrString TextFileLineBuffer::TotalTextRead()
{
  ChrString RetStr_;
  bool DoSimp_ = (_SimplifyTagSpaces && !_SuppressSimplify &&
                  DelimSetsFound() && !_SplitTag);

  if (DoSimp_)
  {
    RetStr_ = _TotalTextRead;
    RetStr_.SimplifySpaces(false);
  }

  return (DoSimp_ ? RetStr_:_TotalTextRead);
}

/****************************************************************************/
char* TextFileLineBuffer::AppendTextRead(char* TxtBuf_)
{
  if (!_TextAppended && TxtBuf_)
  {
    _TextAppended = true;
    _TotalTextRead += TxtBuf_;

    if (_SimplifyTagSpaces && !_SuppressSimplify &&
        DelimSetsFound() && !_SplitTag)
      _TotalTextRead.SimplifySpaces(false);
  }

  return _TotalTextRead.c_str();
}

/****************************************************************************/
void TextFileLineBuffer::ResetTotalTextRead()
{
  _TotalTextRead.SetEmpty();
  _TextAppended = false;
}

/****************************************************************************/
char* TextFileLineBuffer::TerminateTextBuf(char* TxtBuf_, int x, bool AppendTxt_,
                                           bool AppendWs_, bool AppendNl_)
{
  if (AppendWs_)
    TxtBuf_[x++] = AppendNl_ ? '\n':' ';
    
  TxtBuf_[x] = 0;
    
  if (AppendTxt_)
    AppendTextRead(TxtBuf_);

  return TxtBuf_;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::operator >> (char* InputStr_)
{
  if (_File && InputStr_ && !(_EolFound || _BufferFull) && !_EofFound)
  {
    int ArrayIndex_;
    int StringIndex_;
    int DelimType_;
    
    char ch;
    long PrevCol_;

    int x;
    int Dsc1_ = NONE;
    int Dsc2_ = NONE;
    int Collide_ = NONE;
    bool PartialMatch1_ = false;
    bool PartialMatch2_ = false;
    int TxtBufMatch1_ = 0;
    int TxtBufMatch2_ = 0;
    bool WsFound_ = false;
    bool NlFound_ = false;
    bool DelimQuit_ = false;
    bool DelimSetCmp_ = false;
    char* SavedBuffer_ = NULL;
    const char* Cset_ = _WsChars;
    const char* Nlset_ = _NlChars;
    DelimInfo* Delimp_ = NULL;
    istream& Is_ = (_IoMode & FILE_INPUT) ? _File->GetInStream():cin;

    // defaulting to last delims search
    char** Delims_ = (_LastDelims && _DefaultDelim != FIRST_SET) ?
                         _LastDelims:_FirstDelims;

    if (_SearchData)
    {
      ArrayIndex_ = _SearchData->ArrayIndex();
      StringIndex_ = _SearchData->StringIndex();
      DelimType_ = _SearchData->DelimType();

      delete _SearchData;
      _SearchData = NULL;
    }
    else
      ArrayIndex_ =
      StringIndex_ =
      DelimType_ = 0;

    // End of line not found, so next repeated occurrence
    // of last delim possible. Push latest occurrence onto stack
    // just in case next occurence of last delim is found.
    if (!_EolFound && DelimSetComplete(_LastDelims) > 0)
    {
      _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                    InputStr_, _LastDelimFound, _LastDelimPos));
      InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
      memset(InputStr_, 0, _BufSize+1);
      ResetLastDelims(0, true);
    }

    _TextAppended = false;
    for (x = 0; !WsFound_ && !_EofFound && x < _BufSize;)
    {
      ch = Is_.get();
      WsFound_ = InCharSet(ch, Cset_);

      if (!WsFound_)
      {
        _CurPosPtr = &InputStr_[x];
        InputStr_[x++] = ch;
        PrevCol_ = _FilePos->ColPos();
        CountColsRows(ch);
        Collide_ = SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
        else if (!_EolFound)
        {
          _BufferFull = (x == _BufSize);
          if (_BufferFull)
            TerminateTextBuf(InputStr_, _BufSize, false, false);

          if ((Dsc2_=DelimSetComplete(_LastDelims)) || Collide_ == LAST_SET)
          {
            if (Dsc2_)
            {
              _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, x == _BufSize,
                                            InputStr_, _LastDelimFound, _LastDelimPos));

              ResetLastDelims(0, true);
            }
            else
            {
              ResetLastDelims(0, true);
              SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
            }
          }
          else if (Collide_ == FIRST_SET && !DelimSetComplete(_FirstDelims))
          {
            ResetFirstDelims(0, true);
            SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
          }
        }

        ResetCmmntSeg(false);
        TestCmmntSeg(ch);
      }
      else
      {
        _WsFound = true;
        _WsLinePos = x;
        CountColsRows(ch);
        
        if (InCharSet(ch, Nlset_))
        {
          NlFound_ = true;
          _EolFound = true;
          _EndLinePos = _FilePos->ColPos();
        }

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
      }

      if (DelimQuit_ ||
          (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
          (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
      {
        DelimQuit_ = true;
        
        if (!_EolFound && !_EofFound)
        {
          ch = Is_.peek();
          
          if (ch == EOF || InCharSet(ch, Cset_))
            continue;
          else if (!_File->EndOfFile())
            _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
        }

        if (!WsFound_ && !_EofFound && x < _BufSize)
        {
          if (!_EolFound && !_BufferFull)
            TerminateTextBuf(InputStr_, x, false, false);
        
          break;
        }
      }
    }

    _BufferFull = (x == _BufSize);
    _ReadAttemptNumber++;
    _ReadLenQueue->Enqueue(new long(x));

    Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
    Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
    SavedBuffer_ = InputStr_;
    _LastDelimSetFound = Dsc2_;
    _FirstDelimSetFound = Dsc1_;
    _MultiLineTag = _SplitTag;
    _SplitTag = _XmlTypeTag &&
                (_QuitReadOnFirstDelimSetFound &&
                 (!_FirstDelimSetFound && _FirstDelimFound[0] &&
                  (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE))) ||
                (_QuitReadOnLastDelimSetFound &&
                 (!_LastDelimSetFound && _LastDelimFound[0] &&
                  (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)));
    DelimSetCmp_ = !_SplitTag &&
                   ((_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound) ||
                    (_QuitReadOnLastDelimSetFound && _LastDelimSetFound));
    _MultiLineTag = _MultiLineTag && DelimSetCmp_;

    if (_MultiLineTag)
    {
      TerminateTextBuf(InputStr_, _BufSize, false, false);

      if (_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                         InputStr_, _FirstDelimFound, _FirstDelimPos));

        InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(InputStr_, 0, _BufSize+1);
      }
      else if (_QuitReadOnLastDelimSetFound && _LastDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                         InputStr_, _LastDelimFound, _LastDelimPos));

        InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(InputStr_, 0, _BufSize+1);
      }
    }
    else if (_BufferFull || DelimQuit_ || _SplitTag)
    {
      TerminateTextBuf(InputStr_, _BufSize, false, false);

      // End of line not found, so next repeated occurrence
      // of last delim possible. Push latest occurrence onto stack
      // just in case next occurence of last delim is found.
      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)) &&
          (!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)))
      {
        if (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           InputStr_, _LastDelimFound, _LastDelimPos));

          InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(InputStr_, 0, _BufSize+1);
        }
        else if (Dsc1_ == COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           InputStr_, _FirstDelimFound, _FirstDelimPos));

          InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(InputStr_, 0, _BufSize+1);
        }
      }

      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)) &&
          (!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)))
      {
        if (Dsc2_ != COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           InputStr_, _FirstDelimFound, _FirstDelimPos));

          InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(InputStr_, 0, _BufSize+1);
        }
        else if (Dsc2_ == COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           InputStr_, _LastDelimFound, _LastDelimPos));

          InputStr_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(InputStr_, 0, _BufSize+1);
        }
      }
    }

    if (x == 0)
    {
      _LineEmpty = COMPLETE;
      _SuppressSimplify = false;
      return *this;
    }
    else
      _CharsRead = x;

    if (_BufferFull && !_EolFound)
    {
      _LineFitInBuffer = false;
      TerminateTextBuf(SavedBuffer_, _BufSize, true, false);
      IsEmptyLine(SavedBuffer_, _BufSize);
      if (!DelimQuit_ || !_SearchData)
        _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
      
      _TimesLimitReached++;
      _ReadTimesRequired++;
    }
    else if (_EolFound || DelimSetCmp_)
    {
      TerminateTextBuf(SavedBuffer_, x, true, (_SplitTag || _MultiLineTag) && WsFound_); //, NlFound_);
      _ReadTimesRequired++;
      if (_EolFound)
        _LineFitInBuffer = _TimesLimitReached == 0;

      if (_LineFitInBuffer || x > 0 || DelimSetCmp_)
        IsEmptyLine(SavedBuffer_, x);

      // If next occurrence of last delim is not found and delim stack
      // is not empty then pop most recent occurrence of last delim before
      // deleting the stack contents
      Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
      Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
      
      if (!_DelimStk->Empty() && !Dsc2_ &&
          (!PartialMatch2_ ||
           ((PartialMatch2_ || TxtBufMatch2_==INCOMPLETE) &&
            (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2])) &&
            _DelimStk->Head()->Value()->Matches(LAST_SET, (STARTING|ENDING), ENDING, _LastDelims,
                                                _LastDelimPtr, _LastDelimFound, _LastDelimOptional))))
      {
        Delimp_ = _DelimStk->Pop();
        
        if (Delimp_)
        {
          Delimp_->AssignTo(LAST_SET, _LastDelims, _LastDelimPtr, _LastDelimFound, _LastDelimPos);
          delete Delimp_;
        }
      }
    }

    if (FirstDelimFound(0, true) || LastDelimFound(0, true))
      TransferDelims();

    // defaulting to last delims if found
    if (_EolFound)
      DetermineDelimSet((_LastDelims && _DefaultDelim != FIRST_SET) ? _LastDelims:_FirstDelims);
  }

  _SuppressSimplify = false;
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ReadUntil(const char* CharSet_, bool InSet_, bool PutBack_)
{
  if (_File && !(_EolFound || _BufferFull) && !_EofFound)
  {
    int ArrayIndex_;
    int StringIndex_;
    int DelimType_;
    
    char ch;    
    long PrevCol_;

    int x;
    int Dsc1_ = NONE;
    int Dsc2_ = NONE;
    int Collide_ = NONE;
    bool PartialMatch1_ = false;
    bool PartialMatch2_ = false;
    int TxtBufMatch1_ = 0;
    int TxtBufMatch2_ = 0;
    bool DelimQuit_ = false;
    bool DelimSetCmp_ = false;
    bool NlFound_ = false;
    char* SavedBuffer_ = NULL;
    const char* Cset_ = CharSet_;
    const char* Wsset_ = _WsChars;
    const char* Nlset_ = _NlChars;
    DelimInfo* Delimp_ = NULL;
    istream& Is_ = (_IoMode & FILE_INPUT) ? _File->GetInStream():cin;

    // defaulting to last delims search
    char** Delims_ = (_LastDelims && _DefaultDelim != FIRST_SET) ?
                         _LastDelims:_FirstDelims;

    if (_SearchData)
    {
      ArrayIndex_ = _SearchData->ArrayIndex();
      StringIndex_ = _SearchData->StringIndex();
      DelimType_ = _SearchData->DelimType();

      delete _SearchData;
      _SearchData = NULL;
    }
    else
      ArrayIndex_ =
      StringIndex_ =
      DelimType_ = 0;

    // End of line not found, so next repeated occurrence
    // of last delim possible. Push latest occurrence onto stack
    // just in case next occurence of last delim is found.
    if (!_EolFound && DelimSetComplete(_LastDelims) > 0)
    {
      _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                    _TextBuffer, _LastDelimFound, _LastDelimPos));
      _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
      memset(_TextBuffer, 0, _BufSize+1);
      ResetLastDelims(0, true);
    }

    _TextAppended = false;
    for (x = 0; !_BrkChFound && !_EofFound && x < _BufSize;)
    {
      ch = Is_.get();

      if ((InSet_ && InCharSet(ch, Cset_)) ||
          (!InSet_ && !InCharSet(ch, Cset_)))
      {
        if (PutBack_)
          Is_.putback(ch);
          
        _BrkChFound = true;
      }
      else
        _BrkChFound = false;

      if (!_BrkChFound)
      {
        _CurPosPtr = &_TextBuffer[x];
        _TextBuffer[x++] = ch;
        PrevCol_ = _FilePos->ColPos();
        CountColsRows(ch);
        Collide_ = SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
        else if (!_EolFound)
        {
          _BufferFull = (x == _BufSize);
          if (_BufferFull)
            TerminateTextBuf(_TextBuffer, _BufSize, false, false);
        
          if ((Dsc2_=DelimSetComplete(_LastDelims)) || Collide_ == LAST_SET)
          {
            if (Dsc2_)
            {
              _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, x == _BufSize,
                                            _TextBuffer, _LastDelimFound, _LastDelimPos));

              ResetLastDelims(0, true);
            }
            else
            {
              ResetLastDelims(0, true);
              SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
            }
          }
          else if (Collide_ == FIRST_SET && !DelimSetComplete(_FirstDelims))
          {
            ResetFirstDelims(0, true);
            SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
          }
        }

        ResetCmmntSeg(false);
        TestCmmntSeg(ch);        
      }
      else
      {
        CountColsRows(ch);
      
        if (InCharSet(ch, Wsset_))
        {
          _WsFound = true;
          _WsLinePos = _FilePos->ColPos();
        }
          
        if (InCharSet(ch, Nlset_))
        {
          NlFound_ = true;
          _EolFound = true;
          _EndLinePos = _FilePos->ColPos();
        }

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
      }

      if (DelimQuit_ ||
          (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
          (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
      {
        DelimQuit_ = true;
        
        if (!_EolFound && !_EofFound)
        {
          ch = Is_.peek();
          
          if (ch == EOF ||
              (InSet_ && InCharSet(ch, Cset_)) ||
              (!InSet_ && !InCharSet(ch, Cset_)))
            continue;
          else if (!_File->EndOfFile())
            _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
        }

        if (!_BrkChFound && !_EofFound && x < _BufSize)
        {
          if (!_EolFound && !_BufferFull)
            TerminateTextBuf(_TextBuffer, x, false, false);
        
          break;
        }
      }
    }

    _BufferFull = (x == _BufSize);
    _ReadAttemptNumber++;
    _ReadLenQueue->Enqueue(new long(x));

    Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
    Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
    SavedBuffer_ = _TextBuffer;
    _LastDelimSetFound = Dsc2_;
    _FirstDelimSetFound = Dsc1_;
    _MultiLineTag = _SplitTag;
    _SplitTag = _XmlTypeTag &&
                (_QuitReadOnFirstDelimSetFound &&
                 (!_FirstDelimSetFound && _FirstDelimFound[0] &&
                  (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE))) ||
                (_QuitReadOnLastDelimSetFound &&
                 (!_LastDelimSetFound && _LastDelimFound[0] &&
                  (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)));
    DelimSetCmp_ = !_SplitTag &&
                   ((_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound) ||
                    (_QuitReadOnLastDelimSetFound && _LastDelimSetFound));
    _MultiLineTag = _MultiLineTag && DelimSetCmp_;

    if (_MultiLineTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      if (_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                         _TextBuffer, _FirstDelimFound, _FirstDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
      else if (_QuitReadOnLastDelimSetFound && _LastDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                         _TextBuffer, _LastDelimFound, _LastDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
    }
    else if (_BufferFull || DelimQuit_ || _SplitTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      // End of line not found, so next repeated occurrence
      // of last delim possible. Push latest occurrence onto stack
      // just in case next occurence of last delim is found.
      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)) &&
          (!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)))
      {
        if (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc1_ == COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }

      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)) &&
          (!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)))
      {
        if (Dsc2_ != COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc2_ == COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }
    }

    if (x == 0)
    {
      _LineEmpty = COMPLETE;
      _SuppressSimplify = false;
      return *this;
    }
    else
      _CharsRead = x;

    if (_BufferFull && !_EolFound)
    {
      _LineFitInBuffer = false;
      TerminateTextBuf(SavedBuffer_, _BufSize, true, false);
      IsEmptyLine(SavedBuffer_, _BufSize);
      if (!DelimQuit_ || !_SearchData)
        _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
      
      _TimesLimitReached++;
      _ReadTimesRequired++;
    }
    else if (_EolFound || DelimSetCmp_)
    {
      TerminateTextBuf(SavedBuffer_, x, true, (_SplitTag || _MultiLineTag) && _WsFound); //, NlFound_);
      _ReadTimesRequired++;
      if (_EolFound)
        _LineFitInBuffer = _TimesLimitReached == 0;

      if (_LineFitInBuffer || x > 0 || DelimSetCmp_)
        IsEmptyLine(SavedBuffer_, x);

      // If next occurrence of last delim is not found and delim stack
      // is not empty then pop most recent occurrence of last delim before
      // deleting the stack contents
      Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
      Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
      
      if (!_DelimStk->Empty() && !Dsc2_ &&
          (!PartialMatch2_ ||
           ((PartialMatch2_ || TxtBufMatch2_==INCOMPLETE) &&
            (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2])) &&
            _DelimStk->Head()->Value()->Matches(LAST_SET, (STARTING|ENDING), ENDING, _LastDelims,
                                                _LastDelimPtr, _LastDelimFound, _LastDelimOptional))))
      {
        Delimp_ = _DelimStk->Pop();
        
        if (Delimp_)
        {
          Delimp_->AssignTo(LAST_SET, _LastDelims, _LastDelimPtr, _LastDelimFound, _LastDelimPos);
          delete Delimp_;
        }
      }
    }

    if (FirstDelimFound(0, true) || LastDelimFound(0, true))
      TransferDelims();

    // defaulting to last delims if found
    if (_EolFound)
      DetermineDelimSet((_LastDelims && _DefaultDelim != FIRST_SET) ? _LastDelims:_FirstDelims);
  }

  _SuppressSimplify = false;
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::Read()
{
  if (_File && !(_EolFound || _BufferFull) && !_EofFound)
  {
    int ArrayIndex_;
    int StringIndex_;
    int DelimType_;

    char ch;
    long PrevCol_;

    int x;
    int Dsc1_ = NONE;
    int Dsc2_ = NONE;
    int Collide_ = NONE;
    bool PartialMatch1_ = false;
    bool PartialMatch2_ = false;
    int TxtBufMatch1_ = 0;
    int TxtBufMatch2_ = 0;
    bool WsFound_ = false;
    bool DelimQuit_ = false;
    bool DelimSetCmp_ = false;
    bool NlFound_ = false;
    char* SavedBuffer_ = NULL;
    const char* Cset_ = _WsChars;
    const char* Nlset_ = _NlChars;
    DelimInfo* Delimp_ = NULL;
    istream& Is_ = (_IoMode & FILE_INPUT) ? _File->GetInStream():cin;

    // defaulting to last delims search
    char** Delims_ = (_LastDelims && _DefaultDelim != FIRST_SET) ?
                         _LastDelims:_FirstDelims;

    if (_SearchData)
    {
      ArrayIndex_ = _SearchData->ArrayIndex();
      StringIndex_ = _SearchData->StringIndex();
      DelimType_ = _SearchData->DelimType();

      delete _SearchData;
      _SearchData = NULL;
    }
    else
      ArrayIndex_ =
      StringIndex_ =
      DelimType_ = 0;

    // End of line not found, so next repeated occurrence
    // of last delim possible. Push latest occurrence onto stack
    // just in case next occurence of last delim is found.
    if (!_EolFound && DelimSetComplete(_LastDelims) > 0)
    {
      _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                    _TextBuffer, _LastDelimFound, _LastDelimPos));
      _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
      memset(_TextBuffer, 0, _BufSize+1);
      ResetLastDelims(0, true);
    }

    _TextAppended = false;
    for (x = 0; !WsFound_ && !_EofFound && x < _BufSize;)
    {
      ch = Is_.get();
      WsFound_ = InCharSet(ch, Cset_);

      if (!WsFound_)
      {
        _CurPosPtr = &_TextBuffer[x];
        _TextBuffer[x++] = ch;
        PrevCol_ = _FilePos->ColPos();
        CountColsRows(ch);
        Collide_ = SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
        else if (!_EolFound)
        {
          _BufferFull = (x == _BufSize);
          if (_BufferFull)
            TerminateTextBuf(_TextBuffer, _BufSize, false, false);
        
          if ((Dsc2_=DelimSetComplete(_LastDelims)) || Collide_ == LAST_SET)
          {
            if (Dsc2_)
            {
              _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, x == _BufSize,
                                            _TextBuffer, _LastDelimFound, _LastDelimPos));

              ResetLastDelims(0, true);
            }
            else
            {
              ResetLastDelims(0, true);
              SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
            }
          }
          else if (Collide_ == FIRST_SET && !DelimSetComplete(_FirstDelims))
          {
            ResetFirstDelims(0, true);
            SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
          }
        }

        ResetCmmntSeg(false);
        TestCmmntSeg(ch);
      }
      else
      {
        _WsFound = true;
        _WsLinePos = _FilePos->ColPos();
        CountColsRows(ch);
        
        if (InCharSet(ch, Nlset_))
        {
          NlFound_ = true;
          _EolFound = true;
          _EndLinePos = _FilePos->ColPos();
        }

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
      }

      if (DelimQuit_ ||
          (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
          (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
      {
        DelimQuit_ = true;
        
        if (!_EolFound && !_EofFound)
        {
          ch = Is_.peek();
          
          if (ch == EOF || InCharSet(ch, Cset_))
            continue;
          else if (!_File->EndOfFile())
            _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
        }

        if (!WsFound_ && !_EofFound && x < _BufSize)
        {
          if (!_EolFound && !_BufferFull)
            TerminateTextBuf(_TextBuffer, x, false, false);
        
          break;
        }
      }
    }

    _BufferFull = (x == _BufSize);
    _ReadAttemptNumber++;
    _ReadLenQueue->Enqueue(new long(x));

    Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
    Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
    SavedBuffer_ = _TextBuffer;
    _LastDelimSetFound = Dsc2_;
    _FirstDelimSetFound = Dsc1_;
    _MultiLineTag = _SplitTag;
    _SplitTag = _XmlTypeTag &&
                (_QuitReadOnFirstDelimSetFound &&
                 (!_FirstDelimSetFound && _FirstDelimFound[0] &&
                  (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE))) ||
                (_QuitReadOnLastDelimSetFound &&
                 (!_LastDelimSetFound && _LastDelimFound[0] &&
                  (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)));
    DelimSetCmp_ = !_SplitTag &&
                   ((_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound) ||
                    (_QuitReadOnLastDelimSetFound && _LastDelimSetFound));
    _MultiLineTag = _MultiLineTag && DelimSetCmp_;

    if (_MultiLineTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      if (_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                         _TextBuffer, _FirstDelimFound, _FirstDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
      else if (_QuitReadOnLastDelimSetFound && _LastDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                         _TextBuffer, _LastDelimFound, _LastDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
    }
    else if (_BufferFull || DelimQuit_ || _SplitTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      // End of line not found, so next repeated occurrence
      // of last delim possible. Push latest occurrence onto stack
      // just in case next occurence of last delim is found.
      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)) &&
          (!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)))
      {
        if (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc1_ == COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }

      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)) &&
          (!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)))
      {
        if (Dsc2_ != COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc2_ == COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }
    }

    if (x == 0)
    {
      _LineEmpty = COMPLETE;
      _SuppressSimplify = false;
      return *this;
    }
    else
      _CharsRead = x;

    if (_BufferFull && !_EolFound)
    {
      _LineFitInBuffer = false;
      TerminateTextBuf(SavedBuffer_, _BufSize, true, false);
      IsEmptyLine(SavedBuffer_, _BufSize);
      if (!DelimQuit_ || !_SearchData)
        _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);

      _TimesLimitReached++;
      _ReadTimesRequired++;
    }
    else if (_EolFound || DelimSetCmp_)
    {
      TerminateTextBuf(SavedBuffer_, x, true, (_SplitTag || _MultiLineTag) && WsFound_); //, NlFound_);
      _ReadTimesRequired++;
      if (_EolFound)
        _LineFitInBuffer = _TimesLimitReached == 0;

      if (_LineFitInBuffer || x > 0 || DelimSetCmp_)
        IsEmptyLine(SavedBuffer_, x);

      // If next occurrence of last delim is not found and delim stack
      // is not empty then pop most recent occurrence of last delim before
      // deleting the stack contents
      Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
      Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
      
      if (!_DelimStk->Empty() && !Dsc2_ &&
          (!PartialMatch2_ ||
           ((PartialMatch2_ || TxtBufMatch2_==INCOMPLETE) &&
            (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2])) &&
            _DelimStk->Head()->Value()->Matches(LAST_SET, (STARTING|ENDING), ENDING, _LastDelims,
                                                _LastDelimPtr, _LastDelimFound, _LastDelimOptional))))
      {
        Delimp_ = _DelimStk->Pop();
        
        if (Delimp_)
        {
          Delimp_->AssignTo(LAST_SET, _LastDelims, _LastDelimPtr, _LastDelimFound, _LastDelimPos);
          delete Delimp_;
        }
      }
    }

    if (FirstDelimFound(0, true) || LastDelimFound(0, true))
      TransferDelims();

    // defaulting to last delims if found
    if (_EolFound)
      DetermineDelimSet((_LastDelims && _DefaultDelim != FIRST_SET) ? _LastDelims:_FirstDelims);
  }

  _SuppressSimplify = false;
  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ReadLine()
{
  if (_File && !(_EolFound || _BufferFull) && !_EofFound)
  {
    int ArrayIndex_;
    int StringIndex_;
    int DelimType_;
    
    char ch;
    long PrevCol_;

    int x;
    int Dsc1_ = NONE;
    int Dsc2_ = NONE;
    int Collide_ = NONE;
    bool PartialMatch1_ = false;
    bool PartialMatch2_ = false;
    int TxtBufMatch1_ = 0;
    int TxtBufMatch2_ = 0;
    bool NlFound_ = false;
    bool DelimQuit_ = false;
    bool DelimSetCmp_ = false;
    char* SavedBuffer_ = NULL;
    const char* Cset_ = _NlChars;
    DelimInfo* Delimp_ = NULL;
    istream& Is_ = (_IoMode & FILE_INPUT) ? _File->GetInStream():cin;

    // defaulting to last delims search
    char** Delims_ = (_LastDelims && _DefaultDelim != FIRST_SET) ?
                         _LastDelims:_FirstDelims;

    if (_SearchData)
    {
      ArrayIndex_ = _SearchData->ArrayIndex();
      StringIndex_ = _SearchData->StringIndex();
      DelimType_ = _SearchData->DelimType();

      delete _SearchData;
      _SearchData = NULL;
    }
    else
      ArrayIndex_ =
      StringIndex_ =
      DelimType_ = 0;

    // End of line not found, so next repeated occurrence
    // of last delim possible. Push latest occurrence onto stack
    // just in case next occurence of last delim is found.
    if (!_EolFound && DelimSetComplete(_LastDelims) > 0)
    {
      _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                    _TextBuffer, _LastDelimFound, _LastDelimPos));
      _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
      memset(_TextBuffer, 0, _BufSize+1);
      ResetLastDelims(0, true);
    }

    _TextAppended = false;
    for (x = 0; !NlFound_ && !_EofFound && x < _BufSize;)
    {
      ch = Is_.get();
      NlFound_ = InCharSet(ch, Cset_);

      if (!NlFound_)
      {
        _CurPosPtr = &_TextBuffer[x];
        _TextBuffer[x++] = ch;
        PrevCol_ = _FilePos->ColPos();
        CountColsRows(ch);
        Collide_ = SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }
        else if (!_EolFound)
        {
          _BufferFull = (x == _BufSize);
          if (_BufferFull)
            TerminateTextBuf(_TextBuffer, _BufSize, false, false);
        
          if ((Dsc2_=DelimSetComplete(_LastDelims)) || Collide_ == LAST_SET)
          {
            if (Dsc2_)
            {              
              _DelimStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, x == _BufSize,
                                            _TextBuffer, _LastDelimFound, _LastDelimPos));

              ResetLastDelims(0, true);
            }
            else
            {
              ResetLastDelims(0, true);
              SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
            }
          }
          else if (Collide_ == FIRST_SET && !DelimSetComplete(_FirstDelims))
          {
            ResetFirstDelims(0, true);
            SearchForDelims(Delims_, ch, PrevCol_, ArrayIndex_, StringIndex_, DelimType_);
          }
        }

        ResetCmmntSeg(false);
        TestCmmntSeg(ch);
      }
      else
      {
        NlFound_ = true;
        _WsFound = true;
        _EolFound = true;
        _WsLinePos =
        _EndLinePos = _FilePos->ColPos();
        CountColsRows(ch);

        if (_File->EndOfFile() || ch == EOF)
        {
          _EofFound = true;
          _EndFilePos = _FilePos->ColPos();
        }        
      }

      if (DelimQuit_ ||
          (_QuitReadOnFirstDelimSetFound && FirstDelimFound(0, true)) ||
          (_QuitReadOnLastDelimSetFound && LastDelimFound(0, true)))
      {
        DelimQuit_ = true;
        
        if (!_EolFound && !_EofFound)
        {
          ch = Is_.peek();
          
          if (ch == EOF || InCharSet(ch, Cset_))
            continue;
          else if (!_File->EndOfFile())
            _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);
        }

        if (!NlFound_ && !_EofFound && x < _BufSize)
        {
          if (!_EolFound && !_BufferFull)
            TerminateTextBuf(_TextBuffer, x, false, false);

          break;
        }
      }
    }

    _BufferFull = (x == _BufSize);
    _ReadAttemptNumber++;
    _ReadLenQueue->Enqueue(new long(x));

    Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
    Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
    SavedBuffer_ = _TextBuffer;
    _LastDelimSetFound = Dsc2_;
    _FirstDelimSetFound = Dsc1_;
    _MultiLineTag = _SplitTag;
    _SplitTag = _XmlTypeTag &&
                (_QuitReadOnFirstDelimSetFound &&
                 (!_FirstDelimSetFound && _FirstDelimFound[0] &&
                  (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE))) ||
                (_QuitReadOnLastDelimSetFound &&
                 (!_LastDelimSetFound && _LastDelimFound[0] &&
                  (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)));
    DelimSetCmp_ = !_SplitTag &&
                   ((_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound) ||
                    (_QuitReadOnLastDelimSetFound && _LastDelimSetFound));
    _MultiLineTag = _MultiLineTag && DelimSetCmp_;

    if (_MultiLineTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      if (_QuitReadOnFirstDelimSetFound && _FirstDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                         _TextBuffer, _FirstDelimFound, _FirstDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
      else if (_QuitReadOnLastDelimSetFound && _LastDelimSetFound)
      {
        _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                         _TextBuffer, _LastDelimFound, _LastDelimPos));

        _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
        memset(_TextBuffer, 0, _BufSize+1);
      }
    }
    else if (_BufferFull || DelimQuit_ || _SplitTag)
    {
      TerminateTextBuf(_TextBuffer, _BufSize, false, false);

      // End of line not found, so next repeated occurrence
      // of last delim possible. Push latest occurrence onto stack
      // just in case next occurence of last delim is found.
      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)) &&
          (!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)))
      {
        if (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc1_ == COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }

      if ((!_EolFound || DelimQuit_ || _SplitTag) &&
          !(!Dsc2_ && (PartialMatch2_ || TxtBufMatch2_==INCOMPLETE)) &&
          (!Dsc1_ && (PartialMatch1_ || TxtBufMatch1_==INCOMPLETE)))
      {
        if (Dsc2_ != COMPLETE && (_FirstDelimPtr[0] || _FirstDelimPtr[1] || _FirstDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(FIRST_SET, _FirstDelims, _FirstDelimPtr, true,
                                           _TextBuffer, _FirstDelimFound, _FirstDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
        else if (Dsc2_ == COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2]))
        {
          _PartialDStk->Push(new DelimInfo(LAST_SET, _LastDelims, _LastDelimPtr, true,
                                           _TextBuffer, _LastDelimFound, _LastDelimPos));

          _TextBuffer = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (_BufSize+1));
          memset(_TextBuffer, 0, _BufSize+1);
        }
      }
    }

    if (x == 0)
    {
      _LineEmpty = COMPLETE;
      _SuppressSimplify = false;
      return *this;
    }
    else
      _CharsRead = x;

    if (_BufferFull && !_EolFound)
    {
      _LineFitInBuffer = false;
      TerminateTextBuf(SavedBuffer_, _BufSize, true, false);
      IsEmptyLine(SavedBuffer_, _BufSize);
      if (!DelimQuit_ || !_SearchData)
        _SearchData = new TextFileSearchData(ArrayIndex_, StringIndex_, DelimType_);

      _TimesLimitReached++;
      _ReadTimesRequired++;
    }
    else if (_EolFound || DelimSetCmp_)
    {
      TerminateTextBuf(SavedBuffer_, x, true, (_SplitTag || _MultiLineTag) && NlFound_); //, true);
      _ReadTimesRequired++;
      if (_EolFound)
        _LineFitInBuffer = _TimesLimitReached == 0;

      if (_LineFitInBuffer || x > 0 || DelimSetCmp_)
        IsEmptyLine(SavedBuffer_, x);

      // If next occurrence of last delim is not found and delim stack
      // is not empty then pop most recent occurrence of last delim before
      // deleting the stack contents
      Dsc2_ = DelimSetComplete(_LastDelims, &PartialMatch2_, &TxtBufMatch2_);
      Dsc1_ = DelimSetComplete(_FirstDelims, &PartialMatch1_, &TxtBufMatch1_);
      
      if (!_DelimStk->Empty() && !Dsc2_ &&
          (!PartialMatch2_ ||
           ((PartialMatch2_ || TxtBufMatch2_==INCOMPLETE) &&
            (Dsc1_ != COMPLETE && (_LastDelimPtr[0] || _LastDelimPtr[1] || _LastDelimPtr[2])) &&
            _DelimStk->Head()->Value()->Matches(LAST_SET, (STARTING|ENDING), ENDING, _LastDelims,
                                                _LastDelimPtr, _LastDelimFound, _LastDelimOptional))))
      {
        Delimp_ = _DelimStk->Pop();
        
        if (Delimp_)
        {
          Delimp_->AssignTo(LAST_SET, _LastDelims, _LastDelimPtr, _LastDelimFound, _LastDelimPos);
          delete Delimp_;
        }
      }
    }

    if (FirstDelimFound(0, true) || LastDelimFound(0, true))
      TransferDelims();

    // defaulting to last delims if found
    if (_EolFound)
      DetermineDelimSet((_LastDelims && _DefaultDelim != FIRST_SET) ? _LastDelims:_FirstDelims);
  }

  _SuppressSimplify = false;
  return *this;
}

/****************************************************************************/
char* TextFileLineBuffer::FillTagBuffer()
{
  long x, y;
  long FirstPos_ = -1;
  long LastPos_ = -1;
  long StrLen_;
  ChrString RetStr_;

  char* TagBuffer_ = NULL;
  bool DoSimp_ = (_SimplifyTagSpaces && !_SuppressSimplify &&
                  DelimSetsFound() && !_SplitTag);

  for (x = 0; x < MAXDELIMS; x++)
  {
    if (_FirstDelimFound[x])
      if (FirstPos_ < 0)
        FirstPos_ = x;
      else
        LastPos_ = x;
  }

  if (_LineData && FirstPos_ >= 0 && LastPos_ >= 0 && !_SplitTag)
  {
    StrLen_ = _MultiLineTag ?
                 (::SafeStrLen(_FirstDelimPtr[FirstPos_]) + _FirstDelimPos[LastPos_] + 1):
                 (_FirstDelimPos[LastPos_] - _FirstDelimPos[FirstPos_] + 1);

    TagBuffer_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (StrLen_+2));
    TagBuffer_ = _LineData->FillTagBuffer(TagBuffer_, _FirstDelimPtr, _FirstDelimPos, FirstPos_, LastPos_);
  }

  if (!TagBuffer_)
  {
    FirstPos_ =
    LastPos_ = -1;
  
    for (x = 0; x < MAXDELIMS; x++)
    {
      if (_LastDelimFound[x])
        if (FirstPos_ < 0)
          FirstPos_ = x;
        else
          LastPos_ = x;
    }

    if (_LineData && FirstPos_ >= 0 && LastPos_ >= 0 && !_SplitTag)
    {
      StrLen_ = _MultiLineTag ?
                   (::SafeStrLen(_LastDelimPtr[FirstPos_]) + _LastDelimPos[LastPos_] + 1):
                   (_LastDelimPos[LastPos_] - _LastDelimPos[FirstPos_] + 1);

      TagBuffer_ = (char*)RawAllocateWith(MEMMATRIX, sizeof(char) * (StrLen_+2));
      TagBuffer_ = _LineData->FillTagBuffer(TagBuffer_, _LastDelimPtr, _LastDelimPos, FirstPos_, LastPos_);
    }
  }

  if (_TagBufferComplete)
  {
    ::RawDeleteArray(_TagBuffer);
    _TagBufferComplete = false;
    _TagBuffer = NULL;
  }

  if (::SafeStrLen(TagBuffer_))
  {
    if (DoSimp_)
    {
      RetStr_ = TagBuffer_;
      RetStr_.SimplifySpaces(false);
      strcpy(TagBuffer_, RetStr_.c_str());
    }
    
    _TagBuffer = TagBuffer_;
    _TagBufferComplete = true;
  }
  else if (TagBuffer_)
    ::RawDeleteArray(TagBuffer_);

  return _TagBuffer;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ReadLineOrToEobuf()
{
  if (_File)
  {
    const char* Cset_ = _NlChars;
    _File->ReadLine(_TextBuffer, _BufSize, Cset_);
    int Ret_ = _File->GetIOResult();
    
    _BufferFull = (Ret_ == StreamReader::IO_NODELIM);
    _LineFitInBuffer = (Ret_ == StreamReader::IO_DONE);
    _EolFound = !_BufferFull && _LineFitInBuffer;    
    _EofFound = _File->EndOfFile();

    if (_BufferFull && !_EolFound)
    {    
      _TimesLimitReached++;
      _ReadTimesRequired++;
    }
    else if (_EolFound)
      _ReadTimesRequired++;
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::TruncLine()
{
  if (_File)
  {
    const char* Cset_ = _NlChars;
    _File->TruncLine(_TextBuffer, _BufSize, Cset_);
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::Ignore()
{
  if (_File)
  {
    const char* Cset_ = _NlChars;
    _File->Ignore(Cset_);
  }

  return *this;
}

/****************************************************************************/
TextFileLineBuffer& TextFileLineBuffer::ReadBuffer(streambuf* Sb_)
{
  if (_File)
  {
    const char* Cset_ = _NlChars;
    _File->ReadBuffer(Sb_, Cset_);
  }

  return *this;
}

/****************************************************************************/
bool TextFileLineBuffer::EndOfFile()
{
  return (_File ? _File->EndOfFile():FALSE);
}

/****************************************************************************/
bool TextFileLineBuffer::Good()
{
  return (_File ? _File->Good():FALSE);
}

/****************************************************************************/
bool TextFileLineBuffer::Bad()
{
  return (_File ? _File->Bad():FALSE);
}

/****************************************************************************/
bool TextFileLineBuffer::Fail()
{
  return (_File ? _File->Fail():FALSE);
}

/****************************************************************************/
bool TextFileLineBuffer::Open(const char* Fname_, int Mode_)
{
  _FileOpened = (_File ? _File->Open(Fname_, Mode_):FALSE);
  return _FileOpened;
}

/****************************************************************************/
bool TextFileLineBuffer::Close()
{
  bool Fclosed_ = false;

  if (_FileOpened)
  {
    Fclosed_ = (_File ? _File->Close():FALSE);

    if (Fclosed_)
      _FileOpened = false;
  }

  return Fclosed_;
}

/****************************************************************************/
long TextFileLineBuffer::FileSize(int Mode_)
{
  return (_File ? _File->FileSize(Mode_):0);
}

/****************************************************************************/
void TextFileLineBuffer::InitStdHtmlTags()
{
  char* Fd[3];
  bool Fo[] = {false, true, false};
  Fd[0] = new_char_string("<");
  Fd[1] = new_char_string("=");
  Fd[2] = new_char_string(">");

  char* Ld[3];
  bool Lo[] = {false, false, false};
  Ld[0] = new_char_string("</");
  Ld[1] = new_char_string(">");
  Ld[2] = NULL;

  if (Fd[0])
    SetFirstDelims(0, Fd[0], Fo[0]);
  if (Fd[1])
    SetFirstDelims(1, Fd[1], Fo[1]);
  if (Fd[2])
    SetFirstDelims(2, Fd[2], Fo[2]);

  if (Ld[0])
    SetLastDelims(0, Ld[0], Lo[0]);
  if (Ld[1])
    SetLastDelims(1, Ld[1], Lo[1]);
  if (Ld[2])
    SetLastDelims(2, Ld[2], Lo[2]);

  int x;
  for (x = 0; x < TextLineEnums::MAXDELIMS; x++)
  {
    ::RawDeleteArray(Fd[x]);
    ::RawDeleteArray(Ld[x]);
  }
}

/****************************************************************************/
void TextFileLineBuffer::InitSingleTagDelim()
{
  char* Fd[3];
  bool Fo[] = {false, true, false};
  Fd[0] = NULL;
  Fd[1] = NULL;
  Fd[2] = NULL;

  char* Ld[3];
  bool Lo[] = {false, false, false};
  Ld[0] = new_char_string("<");
  Ld[1] = new_char_string(">");
  Ld[2] = NULL;

  if (Fd[0])
    SetFirstDelims(0, Fd[0], Fo[0]);
  if (Fd[1])
    SetFirstDelims(1, Fd[1], Fo[1]);
  if (Fd[2])
    SetFirstDelims(2, Fd[2], Fo[2]);

  if (Ld[0])
    SetLastDelims(0, Ld[0], Lo[0]);
  if (Ld[1])
    SetLastDelims(1, Ld[1], Lo[1]);
  if (Ld[2])
    SetLastDelims(2, Ld[2], Lo[2]);

  int x;
  for (x = 0; x < TextLineEnums::MAXDELIMS; x++)
  {
    ::RawDeleteArray(Fd[x]);
    ::RawDeleteArray(Ld[x]);
  }
}

/****************************************************************************/
/****************************************************************************/
#if TEXTFILELINE_DEBUG
int main(int argc, char* argv[])
{
  static int IoMode_ = 0;
  static bool ShowColHead_ = true;

  #if TEXTFILELINE_DEBUG1
    int x;
    static char* TESTIN 	= new_char_string("textfiledata.html");
    static char* TESTOUT	= new_char_string("textfile.out1");
    IoMode_ = TextLineEnums::FILE_OUTPUT | TextLineEnums::FILE_INPUT;

    static char* Fd[3];
    static bool Fo[] = {false, true, false};
    Fd[0] = new_char_string("<");
    Fd[1] = new_char_string("=");
    Fd[2] = new_char_string(">");

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = new_char_string("<");
    Ld[1] = new_char_string(">");
    Ld[2] = NULL;

  #elif TEXTFILELINE_DEBUG2
    int x;
    static char* TESTIN 	= new_char_string("textfiledata.html");
    static char* TESTOUT	= new_char_string("textfile.out2");
    IoMode_ = TextLineEnums::FILE_OUTPUT | TextLineEnums::FILE_INPUT;

    static char* Fd[3];
    static bool Fo[] = {false, true, false};
    Fd[0] = new_char_string("<");
    Fd[1] = new_char_string("=");
    Fd[2] = new_char_string(">");

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = new_char_string("</");
    Ld[1] = new_char_string(">");
    Ld[2] = NULL;

  #elif TEXTFILELINE_DEBUG2b
    int x;
    static char* TESTIN 	= new_char_string("htmltxtstr3.html");
    static char* TESTOUT	= new_char_string("textfile.out2b");
    IoMode_ = TextLineEnums::FILE_OUTPUT | TextLineEnums::FILE_INPUT;

    static char* Fd[3];
    static bool Fo[] = {false, true, false};
    Fd[0] = new_char_string("<");
    Fd[1] = new_char_string("=");
    Fd[2] = new_char_string(">");

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = new_char_string("</");
    Ld[1] = new_char_string(">");
    Ld[2] = NULL;

  #elif TEXTFILELINE_DEBUG3
    int x;
    static char* TESTIN 	= new_char_string("textfiledata.html");
    static char* TESTOUT	= new_char_string("textfile.out3");
    IoMode_ = TextLineEnums::FILE_OUTPUT | TextLineEnums::FILE_INPUT;

    static char* Fd[3];
    static bool Fo[] = {false, false, false};
    Fd[0] = NULL;
    Fd[1] = NULL;
    Fd[2] = NULL;

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = NULL;
    Ld[1] = NULL;
    Ld[2] = NULL;

  #elif TEXTFILELINE_DEBUG4
    int x;
    static char* TESTIN 	= new_char_string("textfiledata.html");
    static char* TESTOUT	= new_char_string("textfile.dat");
    IoMode_ = TextLineEnums::FILE_OUTPUT | TextLineEnums::FILE_INPUT;
    // ShowColHead_ = false;
    ShowColHead_ = true;

    static char* Fd[3];
    static bool Fo[] = {false, false, false};
    Fd[0] = NULL;
    Fd[1] = NULL;
    Fd[2] = NULL;

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = new_char_string("<");
    Ld[1] = new_char_string(">");
    Ld[2] = NULL;

  #elif TEXTFILELINE_DEBUG5
    int x, i;
    static char* TESTIN = NULL;
    static char* TESTOUT = NULL;

    static char* Fd[3];
    static bool Fo[] = {false, true, false};
    Fd[0] = NULL;
    Fd[1] = NULL;
    Fd[2] = NULL;

    static char* Ld[3];
    static bool Lo[] = {false, false, false};
    Ld[0] = NULL;
    Ld[1] = NULL;
    Ld[2] = NULL;

    if (argc == 1)
    {
      cout <<"Usage: textfileline -i=<infile> -o=<outfile> -fd=n:f1,f2,f3 -ld=n:l1,l2,l3" <<endl;
      cout <<endl
           <<"infile : input text file with delimiters" <<endl
           <<"outfile : output text file with line record data" <<endl;
      cout <<"-fd=n:f1,f2,f3 : first starting delimiters, n in range [1...3]" <<endl
           <<"                 indicating number of delimiters specified in starting set" <<endl
           <<"f1...f3        : delimiters specified in starting delimiter set," <<endl
           <<"                 append f1(1)...f3(1) to indicate optional delimiter" <<endl;
      cout <<"-ld=n:f1,f2,f3 : last ending delimiters, n in range [1...3]" <<endl
           <<"                 indicating number of delimiters specified in ending set" <<endl
           <<"f1...f3        : delimiters specified in ending delimiter set," <<endl
           <<"                 append f1(1)...f3(1) to indicate optional delimiter" <<endl;
      cout <<"delimiter string escape sequences : " <<endl
           <<"\t&amp;          : ampersand" <<endl
           <<"\t&lt;           : less than" <<endl
           <<"\t&gt;           : greater than" <<endl
           <<"\t&quot;         : quotation" <<endl
           <<"\t&tagop;        : tag open" <<endl
           <<"\t&tagcl;        : tag close" <<endl
           <<"\t&endtagop;     : end tag open" <<endl
           <<"\t&endtagcl;     : end tag close" <<endl
           <<"\t&emptytagop;   : empty tag open" <<endl
           <<"\t&emptytagcl;   : empty tag close" <<endl
           <<"\t&scriptop;     : script tag open" <<endl
           <<"\t&scriptcl;     : script tag close" <<endl
           <<"\t&doctypeop;    : document type tag open" <<endl
           <<"\t&doctypecl;    : document type tag close" <<endl
           <<"\t&commentop;    : comment tag open" <<endl
           <<"\t&commentcl;    : comment tag open" <<endl
           <<"\t&nestedcmt1op; : nested comment1 tag open" <<endl
           <<"\t&nestedcmt1cl; : nested comment1 tag close" <<endl
           <<"\t&nestedcmt2op; : nested comment2 tag open" <<endl
           <<"\t&nestedcmt2cl; : nested comment2 tag close" <<endl
           <<"\t&copcmtblkop;  : C open comment block open" <<endl
           <<"\t&copcmtblkcl;  : C open comment block close" <<endl
           <<"\t&cclcmtblkop;  : C close comment block open" <<endl
           <<"\t&cclcmtblkcl;  : C close comment block close" <<endl
           <<"\t&cppcmtlnop;   : Cpp comment line open" <<endl
           <<"\t&cppcmtlncl;   : Cpp comment line close" <<endl;

      return 1;
    }
    else if (argc > 3)
    {
      int ifpos = 0;
      int ofpos = 0;
      int iflen = 0;
      int oflen = 0;
      int ifoffset = 0;
      int ofoffset = 0;
      int fdlm = 0;
      int ldlm = 0;
      int fdpos = 0;
      int ldpos = 0;
      int fdlen = 0;
      int ldlen = 0;
      int fdcnt = 0;
      int ldcnt = 0;

      if (argc == 2 && strcmp(argv[1], "-ver") == 0)
      {
        fprintf(stderr,
                "Text File Line Parser\n"
                "version: 1.0\n");
        return 0;
      }
    
      for (x = 1; x < argc; x++)
      {
        if (strncmp(argv[x], "-fd=", 4) == 0 &&
            strlen(argv[x]) > 4)
        {
          fdlm = 4;
          fdpos = x;
          fdlen = strlen(argv[x]+4);
        }

        if (strncmp(argv[x], "-ld=", 4) == 0 &&
            strlen(argv[x]) > 4)
        {
          ldlm = 4;
          ldpos = x;
          ldlen = strlen(argv[x]+4);
        }
    
        if (strncmp(argv[x], "-i=", 3) == 0 &&
            strlen(argv[x]) > 3)
        {
          ifpos = x;
          iflen = strlen(argv[x]+3);
          ifoffset = 3;
        }

        if (strncmp(argv[x], "-o=", 3) == 0 &&
            strlen(argv[x]) > 3)
        {
          ofpos = x;
          oflen = strlen(argv[x]+3);
          ofoffset = 3;
        }
      }
      
      if (ifpos && iflen)
      {
        char* ofname = NULL;
        char* ifname = NULL;

        if (oflen && ofpos)
          ofname = new_char_string(argv[ofpos]+ofoffset);

        if (iflen && ifpos)
          ifname = new_char_string(argv[ifpos]+ifoffset);

        if (ofname)
        {
          RemovePadding(ofname, " \t");
          TESTOUT = ofname;
          ofname = NULL;
          IoMode_ |= TextLineEnums::FILE_OUTPUT;
        }

        if (ifname)
        {
          RemovePadding(ifname, " \t");
          TESTIN = ifname;
          ifname = NULL;
          IoMode_ |= TextLineEnums::FILE_INPUT;
        }
      }

      if (fdlen || ldlen)
      {
        char* ldstr = NULL;
        char* fdstr = NULL;
        const char* cpos = NULL;
        char* pos;

        if (fdlen && fdpos)
        {
          fdstr = new_char_string(argv[fdpos]+fdlm);
          cpos = strchr(fdstr, ':');
          
          if (cpos)
          {
            x = cpos - fdstr;
            fdstr[x] = 0;
            fdcnt = atoi(fdstr);
            fdstr[x] = ':';
            i = 0;

            for (pos=strtok(fdstr+x+1, ","); pos && i < fdcnt;
                 pos=strtok(NULL, ","), i++)
            {
              cpos = strchr(pos, '(');
              
              if (cpos)
              {
                x = cpos - pos;
                pos[x] = 0;
                Fd[i] = new_char_string(TextFileLineBuffer::TagTypeStr(pos));
                pos[x] = '(';
                
                if (pos[x+2] == ')')
                {
                  pos[x+2] = 0;
                  Fo[i] = (bool)atoi(pos+x+1);
                  pos[x+2] = ')';
                }
              }
              else
                Fd[i] = new_char_string(TextFileLineBuffer::TagTypeStr(pos));
            }
          }
        }

        if (ldlen && ldpos)
        {        
          ldstr = new_char_string(argv[ldpos]+ldlm);
          cpos = strchr(ldstr, ':');

          if (cpos)
          {
            x = cpos - ldstr;
            ldstr[x] = 0;
            ldcnt = atoi(ldstr);
            ldstr[x] = ':';
            i = 0;

            for (pos=strtok(ldstr+x+1, ","); pos && i < ldcnt;
                 pos=strtok(NULL, ","), i++)
            {
              cpos = strchr(pos, '(');
              
              if (cpos)
              {
                x = cpos - pos;
                pos[x] = 0;
                Ld[i] = new_char_string(TextFileLineBuffer::TagTypeStr(pos));
                pos[x] = '(';
                
                if (pos[x+2] == ')')
                {
                  pos[x+2] = 0;
                  Lo[i] = (bool)atoi(pos+x+1);
                  pos[x+2] = ')';
                }
              }
              else
                Ld[i] = new_char_string(TextFileLineBuffer::TagTypeStr(pos));
            }
          }
        }
      }
    }
  #endif

  TextFileLineBuffer* TxtBuf_ = NULL;
  FileReader* Fr_ = new FileReader;
  
  if (Fr_ &&
      (!(IoMode_ & TextLineEnums::FILE_INPUT) ||
         Fr_->Open(TESTIN, ios::in)) &&
      (!(IoMode_ & TextLineEnums::FILE_OUTPUT) ||
         Fr_->Open(TESTOUT, ios::out)))
  {
    #if TEXTFILELINE_DEBUG3
      TxtBuf_ = new TextFileLineBuffer(Fr_, IoMode_, 32);
    #else
      TxtBuf_ = new TextFileLineBuffer(Fr_, IoMode_);
    #endif

    if (TxtBuf_)
    {
      if (Fd[0])
        TxtBuf_->SetFirstDelims(0, Fd[0], Fo[0]);
      if (Fd[1])
        TxtBuf_->SetFirstDelims(1, Fd[1], Fo[1]);
      if (Fd[2])
        TxtBuf_->SetFirstDelims(2, Fd[2], Fo[2]);

      if (Ld[0])
        TxtBuf_->SetLastDelims(0, Ld[0], Lo[0]);
      if (Ld[1])
        TxtBuf_->SetLastDelims(1, Ld[1], Lo[1]);
      if (Ld[2])
        TxtBuf_->SetLastDelims(2, Ld[2], Lo[2]);

      TxtBuf_->SetDefaultToDelims(TextFileLineBuffer::LAST_SET);

      #if ((TEXTFILELINE_DEBUG2b)|(TEXTFILELINE_DEBUG2))
        TxtBuf_->SetXmlTypeTag(true);
      #else
        TxtBuf_->SetXmlTypeTag(false);
      #endif

      #if ((TEXTFILELINE_DEBUG1)|(TEXTFILELINE_DEBUG2)|(TEXTFILELINE_DEBUG2b))
        TxtBuf_->SetQuitReadOnFirstDelimSetFound(true, true);
        TxtBuf_->SetQuitReadOnLastDelimSetFound(true, true);
      #endif
      
      while (TxtBuf_->While_ReadLine())
      {      
        TxtBuf_->DumpLineRecord(ShowColHead_);
        TxtBuf_->ResetLineData();
      }

      TxtBuf_->Close();
    }
  }

  for (x = 0; x < TextLineEnums::MAXDELIMS; x++)
  {
    ::RawDeleteArray(Fd[x]);
    ::RawDeleteArray(Ld[x]);
  }

  ::RawDeleteArray(TESTIN);
  ::RawDeleteArray(TESTOUT);

  delete Fr_;
  delete TxtBuf_;  
}
#endif
/****************************************************************************/
#endif

