#ifndef TOKENS_CPP
#define TOKENS_CPP
#ifndef TOKENS_H
  #include "tokens.h"
#endif

/****************************************************************************/
// ParseTokenValue class definition
/****************************************************************************/
ParserTokenValue::ParserTokenValue():
TokenType(0),
DataType(0),
Validity(0, NumberSign::PLUS),
Token(NULL),
Next(NULL)
{
  _SymData.StrValue = NULL;
}

/****************************************************************************/
ParserTokenValue::~ParserTokenValue()
{
  ::DeleteArray(Token);
  delete Next;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetToken(const char* Str_)
{
  Token = new_char_string(Str_);
  return SetValidity(SafeStrLen(Str_) != 0, NumberSign::PLUS);
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetTokenType(int Val_)
{
  TokenType = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetValidity(Ulong Val_, int Sign_)
{
  LongNumber NewVal_(Val_, Sign_);
  Validity = NewVal_;
  if (!Validity)
    DataType = NO_TYPE;
  
  return *this;  
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetValidity(LongNumber Val_)
{
  Validity = Val_;
  if (!Validity)
    DataType = NO_TYPE;
  
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetCharValue(char Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = CHAR_TYPE;
  _SymData.CharValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetUcharValue(Uchar Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = UCHAR_TYPE;
  _SymData.UcharValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetIntValue(long Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = INT_TYPE;
  _SymData.IntValue = Val_;  
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetUintValue(Ulong Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = UINT_TYPE;
  _SymData.UintValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetFloatValue(float Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = FLOAT_TYPE;
  _SymData.FloatValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetDoubleValue(double Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = DOUBLE_TYPE;
  _SymData.DoubleValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetLdoubleValue(Ldouble Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = LDOUBLE_TYPE;
  _SymData.LdoubleValue = Val_;
  return *this;
}

/****************************************************************************/  
ParserTokenValue& ParserTokenValue::SetStrValue(const char* Val_)
{
  Validity.SetValue(1UL, NumberSign::PLUS);
  DataType = STRING_TYPE;
  _SymData.StrValue = new_char_string(Val_);
  return *this;
}

/****************************************************************************/  
ParserResultInfo* ParserTokenValue::CreateNext()
{
  if (!Next)
    Next = new ParserResultInfo();
    
  return Next;
}

/****************************************************************************/
int ParserTokenValue::HasToken() const
{
  return (Token != ((char*)NULL));
}

/****************************************************************************/
const char* ParserTokenValue::TokenTypeAsString() const
{
  if (TokenType == ParserSymbolType::LITERAL)
    return "LITERAL";
  else if (TokenType == ParserSymbolType::SYMBOL)
    return "SYMBOL";
  else if (TokenType == ParserSymbolType::OPTION)
    return "OPTION";
  else if (TokenType == ParserSymbolType::GROUP)
    return "GROUP";
  else if (TokenType == ParserSymbolType::REPEATABLE)
    return "REPEATABLE";
  else if (TokenType == ParserSymbolType::PARSER_OPTION)
    return "PARSER_OPTION";
  else if (TokenType == ParserSymbolType::SYM_BRACKETED)
    return "SYM_BRACKETED";
  else if (TokenType == ParserSymbolType::SYM_SYMBOL)
    return "SYM_SYMBOL";
  else if (TokenType == ParserSymbolType::SYM_OPERATOR)
    return "SYM_OPERATOR";
  else if (TokenType == ParserSymbolType::SYM_SEQUENCE)
    return "SYM_SEQUENCE";
  else if (TokenType == ParserSymbolType::SYM_BRANCHOUT)
    return "SYM_BRANCHOUT";

  return "NO_TOKEN";
}

/****************************************************************************/
const char* ParserTokenValue::GiveToken() const
{
  return Token;
}

/****************************************************************************/
ostream& ParserTokenValue::ShowData(ostream& os) const
{
  if (DataType == CHAR_TYPE)
    os <<_SymData.CharValue;
  else if (DataType == UCHAR_TYPE)
    os <<_SymData.UcharValue;
  else if (DataType == INT_TYPE)
    os <<_SymData.IntValue;
  else if (DataType == UINT_TYPE)
    os <<_SymData.UintValue;
  else if (DataType == STRING_TYPE)
    os <<_SymData.StrValue;
  else if (DataType == FLOAT_TYPE)
    os <<_SymData.FloatValue;
  else if (DataType == DOUBLE_TYPE)
    os <<_SymData.DoubleValue;
  else if (DataType == LDOUBLE_TYPE)
    os <<_SymData.LdoubleValue;

  return os;
}

/****************************************************************************/
// ParseResultInfo class definition
/****************************************************************************/
ParserResultInfo::ParserResultInfo():
_Index(0),
_Current(0),
_Size(10),
_Branches(0),
Tokens((ParserTokenValue**)RawAllocateWith(MEMMATRIX, sizeof(ParserTokenValue*) * 10)),
OrBranch(NULL)
{
  int i;
  for (i = 0; i < _Size; i++)
    Tokens[i] = new ParserTokenValue();
}

/****************************************************************************/
void ParserResultInfo::Clear()
{
  int i;
  for (i = 0; i < _Size; i++)
    delete Tokens[i];
    
  ::DeleteArray(Tokens);
  delete OrBranch;
}

/****************************************************************************/
ParserResultInfo::~ParserResultInfo()
{
  Clear();
}

/****************************************************************************/
void ParserResultInfo::Reset()
{
  Clear();
  
  _Index = 0;
  _Current = 0;
  _Size = 10;
  Tokens = (ParserTokenValue**)RawAllocateWith(MEMMATRIX, sizeof(ParserTokenValue*) * 10);
  OrBranch = NULL;

  int i;
  for (i = 0; i < _Size; i++)
    Tokens[i] = new ParserTokenValue();
}

/****************************************************************************/
void ParserResultInfo::Grow()
{
  int i;
  int OldSize_ = _Size;
  ParserTokenValue** OldPtr_ = Tokens;

  _Size += 10;
  Tokens = (ParserTokenValue**)RawAllocateWith(MEMMATRIX, sizeof(ParserTokenValue*) * _Size);

  for (i = 0; i < OldSize_; i++)
    Tokens[i] = OldPtr_[i];

  for (;i < _Size; i++)
    Tokens[i] = new ParserTokenValue();

  ::DeleteArray(OldPtr_);
}

/****************************************************************************/
int ParserResultInfo::Branches() const
{
  return _Branches;
}

/****************************************************************************/
int ParserResultInfo::Size() const
{
  return _Size;
}

/****************************************************************************/
int ParserResultInfo::Index() const
{
  return _Index;
}

/****************************************************************************/
int ParserResultInfo::HasTokens() const
{
  return (Tokens[0] != ((ParserTokenValue*)NULL));
}

/****************************************************************************/
void ParserResultInfo::IncrementTokenCount()
{
  _Current = _Index;
  _Index++;
}

/****************************************************************************/
void ParserResultInfo::InsertToken(const char* Str_)
{
  if (_Index >= _Size)
    Grow();

  Tokens[_Index]->SetToken(Str_);
  IncrementTokenCount();
}

/****************************************************************************/    
ParserTokenValue* ParserResultInfo::GetCurrent()
{  
  return Tokens[_Current];
}

/****************************************************************************/    
ParserTokenValue* ParserResultInfo::GetNext()
{
  if (_Index >= _Size)
    Grow();

  return Tokens[_Index];
}

/****************************************************************************/
void ParserResultInfo::SetNumBranches(int Branches_)
{
  _Branches = Branches_;
}

/****************************************************************************/
ParserResultInfo* ParserResultInfo::SetBranch()
{
  if (!OrBranch)
    OrBranch = new ParserResultInfo();

  return OrBranch;
}

/****************************************************************************/
MEMORYOPS_DEFN(ParserTokenValue)
MEMORYOPS_DEFN(ParserResultInfo)

#endif
