#ifndef TOKENS_H
#define TOKENS_H
#ifndef SYMTABLE_H
  #include "symtable.h"
#endif

class ParserResultInfo;

struct ParserTokenValue
{
  // Data Types
  enum
  {
    NO_TYPE,
    CHAR_TYPE,
    UCHAR_TYPE,
    SHORT_TYPE,
    USHORT_TYPE,
    LONG_TYPE,
    ULONG_TYPE,
    INT_TYPE,
    UINT_TYPE,
    STRING_TYPE,
    FLOAT_TYPE,
    DOUBLE_TYPE,
    LDOUBLE_TYPE
  };

  int TokenType;  // for storing token type enum
                  // from enum in ParserSymbolType class
  int DataType;   // for storing data type enum

  SymbolBaseData _SymData;
  LongNumber Validity;     // longnumber validity member
  char* Token;
  ParserResultInfo* Next;
  SymbolSet* _Symbol;  

  ParserTokenValue();
  ~ParserTokenValue();

  ParserTokenValue& SetTokenType(int Val_);  
  ParserTokenValue& SetToken(const char* Str_);
  ParserTokenValue& SetSymbol(SymbolSet* Sym_);
  
  ParserTokenValue& SetValidity(Ulong Val_, int Sign_);
  ParserTokenValue& SetValidity(LongNumber Val_);

  ParserTokenValue& SetCharValue(char Val_);
  ParserTokenValue& SetUcharValue(Uchar Val_);
  ParserTokenValue& SetIntValue(long Val_);
  ParserTokenValue& SetUintValue(Ulong Val_);
  
  ParserTokenValue& SetFloatValue(float Val_);
  ParserTokenValue& SetDoubleValue(double Val_);
  ParserTokenValue& SetLdoubleValue(Ldouble Val_);
  ParserTokenValue& SetStrValue(const char* Val_);
  
  int HasToken() const;
  const char* TokenTypeAsString() const;
  const char* GiveToken() const;

  ostream& ShowData(ostream& os) const;
  ParserResultInfo* CreateNext();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

class ParserResultInfo
{
  protected:
    int _Current;
    int _Index;
    int _Size;
    int _Branches;

    void Clear();
    void IncrementTokenCount();
    
  public:
    ParserTokenValue** Tokens;
    ParserResultInfo* OrBranch;

    ParserResultInfo();
    ~ParserResultInfo();

    void Reset();
    void Grow();
    int Branches() const;
    int Size() const;
    int Index() const;
    int HasTokens() const;

    void InsertToken(const char* Str_);
    void SetNumBranches(int Branches_);
    ParserTokenValue* GetCurrent();
    ParserTokenValue* GetNext();
    ParserResultInfo* SetBranch();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if	HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif
};

#endif
