//
// Program to test the array version of a binary tree.
//
#ifndef CHRSTRING_H
  #include "chrstring.h"
#endif
#ifndef ARRAYBINTREE_CPP
  #include "arraybintree.cpp"
#endif

/****************************************************************************/
void showTree(ArrayBinTree<ChrString>& t, ChrString msg)
{
  ChrString str;
  Boolean ok = t.getFirstNode(str);

  cout << msg << "\n\n";
  while (ok) {
    cout << str << '\n';
    ok = t.getNextNode(str);
  }
  
  cout << "Press any key ... ";
}

/****************************************************************************/
void searchNode(ArrayBinTree<ChrString>& t, ChrString& s)
{
  cout << "Press any key to search for " << s;
  if (t.search(s))
    cout << "Found " << s << " in tree\n";
  else
    cout << "No match for " << s << '\n';
  cout << "Press any key to continue ... ";
}

/****************************************************************************/
int main()
{
  ArrayBinTree<ChrString> tree(25, "!");
  ChrString country[] = { "France",
                        "Germany",
                        "Sweden",
                        "Ireland",
                        "Italy",
                        "Spain",
                        "Portugal",
                        "Switzerland",
                        "Belgium",
                        "England",
                        "Greece",   // not inserted in tree
                        "Denmark"   // not inserted in tree
                       };
  unsigned count = sizeof(country) / sizeof(ChrString);
  unsigned testSize = count - 2;
  unsigned i;

  // insert the names of the countries
  for (i = 0; i < testSize; i++)
    tree.insert(country[i]);

  // display AVL-tree
  showTree(tree, "Complete binary tree is:");

  for (i = 0; i < count; i++)
    searchNode(tree, country[i]);

  for (i = 0; i < count / 2; i++)
    tree.remove(country[i]);

   // display AVL-tree
  tree.TextWrite(cout);
//  showTree(tree, "Trimmed binary tree is:");

  for (i = 0; i < count; i++)
    searchNode(tree, country[i]);

  return 0;
}
