#ifndef TEXTFRAME_CPP
#define TEXTFRAME_CPP
#ifndef TEXTFRAME_H
  #include "txtframe.h"
#endif

/****************************************************************************/
/****************************************************************************/
TextFrame::TextFrame(char* msg, int x0, int y0, int x1, int y1):
_Owner(NULL),
_msg(msg ? strcpy(new char[strlen(msg)+1], msg):NULL),
_Type(TextGraphics::DOUBLE),
_x0pos(x0),
_y0pos(y0),
_x1pos(x1),
_y1pos(y1),
_TextWidgetActive(TRUE),
_InFocus(FALSE),
_Hidden(TRUE),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_hidden_monitor(NULL),
_active_monitor(NULL),
_infocus_monitor(NULL),

// Handles to external objects, used by data monitors
_hidden_handle(NULL),
_active_handle(NULL),
_infocus_handle(NULL)
{
  TextGraphics::RetrieveScreenDimensions();
}

/****************************************************************************/
TextFrame::TextFrame(TextFrame& tl):
_Owner(NULL),
_msg(tl._msg ? strcpy(new char[strlen(tl._msg)+1], tl._msg):NULL),
_Type(tl._Type),
_x0pos(tl._x0pos),
_y0pos(tl._y0pos),
_x1pos(tl._x1pos),
_y1pos(tl._y1pos),
_TextWidgetActive(TRUE),
_InFocus(FALSE),
_Hidden(TRUE),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_hidden_monitor(NULL),
_active_monitor(NULL),
_infocus_monitor(NULL),

// Handles to external objects, used by data monitors
_hidden_handle(NULL),
_active_handle(NULL),
_infocus_handle(NULL)
{
  TextGraphics::RetrieveScreenDimensions();
}

/****************************************************************************/
const int* TextFrame::Monitor(const int*(*monptr_)(void*, TextFrame*, const int*), void* This_, const int* ptr_)
{
  if (monptr_ != NULL)
  {
    SaveCursorPosition();
    const int* RetVal_ = (*monptr_)(This_, this, ptr_);
    RestoreCursorPosition();

    return RetVal_;
  }

  return ptr_;
}

/****************************************************************************/
void TextFrame::SaveCursorPosition()
{
  _SavedCursX = WHEREX();
  _SavedCursY = WHEREY();
}

/****************************************************************************/
void TextFrame::RestoreCursorPosition()
{
  GOTOXY(_SavedCursX, _SavedCursY);
}

/****************************************************************************/
const int* TextFrame::MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*))
{
  _hidden_handle = This_;
  _hidden_monitor = FnPtr_;
  return &_Hidden;
}

/****************************************************************************/
const int* TextFrame::MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*))
{
  _active_handle = This_;
  _active_monitor = FnPtr_;
  return &_TextWidgetActive;
}

/****************************************************************************/
const int* TextFrame::MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*))
{
  _infocus_handle = This_;
  _infocus_monitor = FnPtr_;
  return &_InFocus;
}

/****************************************************************************/
void TextFrame::Clear()
{
  delete[] _msg;
  _msg = NULL;
}

/****************************************************************************/
Boolean TextFrame::ValidCoordinates(int x0, int y0, int x1, int y1)
{
  return
  (
    (x0 > 0) &&
    (x1 < TextGraphics::SCREENLEN) &&
    (y0 > 0) &&
    (y1 < TextGraphics::SCREENHT) &&
    (x0 < x1) &&
    (y0 < y1)
  );
}

/****************************************************************************/
/****************************************************************************/
TextFrame& TextFrame::operator = (TextFrame& tl)
{
  if (this != &tl)
  {
    Clear();

    _msg = tl._msg ? strcpy(new char[strlen(tl._msg)+1], tl._msg):NULL;
    _x0pos = tl._x0pos;
    _y0pos = tl._y0pos;
    _x1pos = tl._x1pos;
    _y1pos = tl._y1pos;
  }

  return *this;
}

/****************************************************************************/
TextFrame* TextFrame::Make(TextFrame& Tlabel_)
{
  TextFrame* tl;
  tl = new TextFrame(Tlabel_);
  return tl;
}

/****************************************************************************/
TextFrame* TextFrame::Make(char* msg, int x0, int y0, int x1, int y1)
{
  TextFrame* tl = NULL;

  if (ValidCoordinates(x0, y0, x1, y1))
    tl = new TextFrame(msg, x0, y0, x1, y1);

  return tl;
}

/****************************************************************************/
/****************************************************************************/
void TextFrame::PrintCorners(Boolean Visible_)
{
  TextGraphics::ExtChar_t ltc_, rtc_, lbc_, rbc_;

  if (Visible_)
  {
    ltc_ = TextGraphics::GRAPHTABLE(_Type, TextGraphics::LTC);
    rtc_ = TextGraphics::GRAPHTABLE(_Type, TextGraphics::RTC);
    lbc_ = TextGraphics::GRAPHTABLE(_Type, TextGraphics::LBC);
    rbc_ = TextGraphics::GRAPHTABLE(_Type, TextGraphics::RBC);
  }
  else
    ltc_ = rtc_ = lbc_ = rbc_ = ' ';

  GOTOXY(_x0pos, _y0pos);
  PUTCH(ltc_);
  GOTOXY(_x1pos, _y0pos);
  PUTCH(rtc_);
  GOTOXY(_x0pos, _y1pos);
  PUTCH(lbc_);
  GOTOXY(_x1pos, _y1pos);
  PUTCH(rbc_);
}

/****************************************************************************/
void TextFrame::PrintHorzLine(int Xpos_, int Ypos_, int EndPos_, TextGraphics::ExtChar_t Char_)
{
  for (; Xpos_ < EndPos_; Xpos_++)
  {
    GOTOXY(Xpos_, Ypos_);
    PUTCH(Char_);
  }
}

/****************************************************************************/
void TextFrame::PrintHorzLines(Boolean Visible_)
{
  if (Visible_)
  {
    PrintHorzLine(_x0pos + 1, _y0pos, _x1pos, TextGraphics::GRAPHTABLE(_Type, TextGraphics::HL));
    PrintHorzLine(_x0pos + 1, _y1pos, _x1pos, TextGraphics::GRAPHTABLE(_Type, TextGraphics::HL));
  }
  else
  {
    PrintHorzLine(_x0pos + 1, _y0pos, _x1pos, ' ');
    PrintHorzLine(_x0pos + 1, _y1pos, _x1pos, ' ');
  }
}

/****************************************************************************/
void TextFrame::PrintVertLine(int Xpos_, int Ypos_, int EndPos_, TextGraphics::ExtChar_t Char_)
{
  for (; Ypos_ < EndPos_; Ypos_++)
  {
    GOTOXY(Xpos_, Ypos_);
    PUTCH(Char_);
  }
}

/****************************************************************************/
void TextFrame::PrintVertLines(Boolean Visible_)
{
  if (Visible_)
  {
    PrintVertLine(_x0pos, _y0pos + 1, _y1pos, TextGraphics::GRAPHTABLE(_Type, TextGraphics::VL));
    PrintVertLine(_x1pos, _y0pos + 1, _y1pos, TextGraphics::GRAPHTABLE(_Type, TextGraphics::VL));
  }
  else
  {
    PrintVertLine(_x0pos, _y0pos + 1, _y1pos, ' ');
    PrintVertLine(_x1pos, _y0pos + 1, _y1pos, ' ');
  }
}

/****************************************************************************/
void TextFrame::PrintFrame()
{
  Boolean Visible_ = _Type != TextGraphics::NONE;

  PrintCorners(Visible_);
  PrintHorzLines(Visible_);
  PrintVertLines(Visible_);
}

/****************************************************************************/
void TextFrame::EraseFrame()
{
  PrintCorners(0);
  PrintHorzLines(0);
  PrintVertLines(0);
}

/****************************************************************************/
void TextFrame::PrintMessage()
{
  if ((_x1pos - 1) - _x0pos >= strlen(_msg) + 2)
  {
    int Len_ = strlen(_msg) + 2;
    int OffSet_;
    int SideLen_ = (_x1pos - 1) - _x0pos;

    OffSet_ = (SideLen_ - Len_) / 2;
    GOTOXY(_x0pos + 1 + OffSet_, _y0pos);
    CPUTS(" ");
    CPUTS(_msg);
    CPUTS(" ");
  }
}

/****************************************************************************/
// PURPOSE:
//   Set Label message method
//
// PRE:
//   The original value of the message data member
//
// POST:
//   The message data member is assigned new memory copied from the argument
//   string.
//
void TextFrame::SetMessage(const char* str)
{
  if (str != _msg)
  {
    delete[] _msg;
    _msg = str ?
    strcpy(new char[strlen(str)+1], str):NULL;
  }
}

/****************************************************************************/
void TextFrame::SetXYpos(int x0, int y0, int x1, int y1)
{
  _x0pos = x0;
  _y0pos = y0;
  _x1pos = x1;
  _y1pos = y1;
}

/****************************************************************************/
/****************************************************************************/
// PURPOSE:
//   Shows Label method
//
// POST:
//   Shows Label message
//
void TextFrame::Show()
{
  if (!IsActive())
    return;

  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  if (_Type != TextGraphics::NONE)
  {
    _InFocus = TRUE;
    Monitor(_infocus_monitor, _infocus_handle, &_InFocus);

    SetupColors(ColorInfo::NORMAL_COLORS);
    PrintFrame();
    PrintMessage();

    _InFocus = FALSE;
    Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  }

  _Hidden = FALSE;
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
}

/****************************************************************************/
// PURPOSE:
//   Hide Label method
//
// POST:
//   goes to the specified coordinates of the Label then Clears the
//   line containing the Label.
//
void TextFrame::IntHide()
{
  if (!IsActive())
    return;

  if (UsesColor())
    SetupColors(ColorInfo::BACKGROUND_COLOR);
  else
    UseColor(FALSE);
  
  EraseFrame();
}

/****************************************************************************/
// PURPOSE:
//   Hide Label method
//
// POST:
//   goes to the specified coordinates of the Label then Clears the
//   line containing the Label.
//
void TextFrame::Hide()
{
  if (!IsActive())
    return;

  _InFocus = TRUE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  SetupColors(ColorInfo::BACKGROUND_COLOR);
  EraseFrame();

  _InFocus = FALSE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  _Hidden = TRUE;
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
}

/****************************************************************************/
void TextFrame::Erase()
{
  if (!IsActive())
    return;

  _InFocus = TRUE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  if (!_Hidden)
  {
    IntHide();
    _Hidden = TRUE;
    Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
  }

  SetMessage("");

  _InFocus = FALSE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
}

/****************************************************************************/
Boolean TextFrame::IsOwner(ControlWindow* Pwin_) const
{
  return (_Owner == Pwin_);
}

/****************************************************************************/
Boolean TextFrame::IsActive() const
{
  return _TextWidgetActive;
}

/****************************************************************************/
Boolean TextFrame::IsInFocus() const
{
  return _InFocus;
}

/****************************************************************************/
void TextFrame::Activate()
{
  _TextWidgetActive = TRUE;
  Monitor(_active_monitor, _active_handle, &_TextWidgetActive);
}

/****************************************************************************/
void TextFrame::Deactivate()
{
  _TextWidgetActive = FALSE;
  Monitor(_active_monitor, _active_handle, &_TextWidgetActive);
}

/****************************************************************************/
void TextFrame::SetOwner(ControlWindow* Pwin_, TextControl* TxtCtrl_)
{
  if (_Owner && _Owner != Pwin_)
    _Owner->RemoveControl(TxtCtrl_);
  _Owner = Pwin_;
}

/****************************************************************************/
void TextFrame::SetupColors(int Mode_)
{
  if (!_ColorInfo.SetupColors(Mode_))
    GetDefaultColorInfo().SetupColors(Mode_);
}

/****************************************************************************/
void TextFrame::UseColor(Boolean Flag_)
{
  if (_ColorInfo._UseColor)
    *_ColorInfo._UseColor = Flag_;
  else
    _ColorInfo._UseColor = new Boolean(Flag_);

  GetDefaultColorInfo().UseColor(Flag_);
}

/****************************************************************************/
void TextFrame::SetNormalColors(int FgCol_, int BgCol_)
{
  if (_ColorInfo._NormalColors)
  {
    _ColorInfo._NormalColors[0] = FgCol_;
    _ColorInfo._NormalColors[1] = BgCol_;
  }
  else
  {
    _ColorInfo._NormalColors = new int[2];
    SetNormalColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void TextFrame::SetHighLightColors(int FgCol_, int BgCol_)
{
  if (_ColorInfo._HighLightColors)
  {
    _ColorInfo._HighLightColors[0] = FgCol_;
    _ColorInfo._HighLightColors[1] = BgCol_;
  }
  else
  {
    _ColorInfo._HighLightColors = new int[2];
    SetHighLightColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void TextFrame::SetHotKeyColor(int Col_)
{
  if (_ColorInfo._HkColor)
    *_ColorInfo._HkColor = Col_;
  else
    _ColorInfo._HkColor = new int(Col_);
}

/****************************************************************************/
void TextFrame::SetBackGroundColor(int Col_)
{
  if (_ColorInfo._BackGroundColor)
    *_ColorInfo._BackGroundColor = Col_;
  else
    _ColorInfo._BackGroundColor = new int(Col_);
}

/****************************************************************************/
void TextFrame::UseDefaultColors()
{
  _ColorInfo.ClearColors();
  UseColor();
}

/****************************************************************************/
Boolean TextFrame::UsesColor() const
{
  return
  (
    _ColorInfo._UseColor ?
      *(_ColorInfo._UseColor):
      *(GetDefaultColorInfo()._UseColor)
  );
}

/****************************************************************************/
int* TextFrame::NormalColors() const
{
  return
  (
    _ColorInfo._NormalColors ?
      _ColorInfo._NormalColors:
      GetDefaultColorInfo()._NormalColors
  );
}

/****************************************************************************/
int* TextFrame::HighLightColors() const
{
  return
  (
    _ColorInfo._HighLightColors ?
      _ColorInfo._HighLightColors:
      GetDefaultColorInfo()._HighLightColors
  );
}

/****************************************************************************/
int TextFrame::HotKeyColor() const
{
  return
  (
    _ColorInfo._HkColor ?
      *(_ColorInfo._HkColor):
      *(GetDefaultColorInfo()._HkColor)
  );
}

/****************************************************************************/
int TextFrame::BackGroundColor() const
{
  return
  (
    _ColorInfo._BackGroundColor ?
      *(_ColorInfo._BackGroundColor):
      *(GetDefaultColorInfo()._BackGroundColor)
  );
}

/****************************************************************************/
/****************************************************************************/
// PURPOSE:
//   Prompt window default constructor
//
// PRE:
//   an uninitialize Prompt window
//
// POST:
//   a Prompt window is constructed and assigned the default values
//   specified.
//
FrameWindow::FrameWindow(int Max_):
PromptWindow(Max_)
{}

/****************************************************************************/
// PURPOSE:
//   Prompt window copy construcor
//
// PRE:
//   An uninitialized Prompt window.
//
// POST:
//   a Prompt window is constructed and assigned the corresponding values
//   in the Prompt window argument passed to the constructor.
//
FrameWindow::FrameWindow(FrameWindow& Lwin_):
PromptWindow(Lwin_._maxbox)
{
  _pbox = new TextControl*[_maxbox];

  for (int index = 0; index < _maxbox; index++)
    if (Lwin_[index])
    {
      _pbox[index] = TextFrame::Make(*Lwin_[index]);
      SetControlData(_pbox, _Info, index);
    }
    else
      RemoveControlData(_pbox, _Info, index);
}

/****************************************************************************/
Boolean FrameWindow::ValidityCheck()
{
  return TRUE;
}

/****************************************************************************/
// PURPOSE:
//   Method to Grow the size of the array by some number passed as an
//   argument to the method. The array contents are preserved.
//
// PRE:
//   The old size of the Prompt box array and its contents
//
// POST:
//   The array size is Grown by the extra size given and the original
//   contents of the array are preserved in the new array.
//
void FrameWindow::Grow(int extra)
{
  int index;
  int newlen = _maxbox + extra;
  
  TextControl** newp = new TextControl*[newlen];
  ControlInfo* newi = new ControlInfo(newlen);

  for (index = 0; index < _maxbox; index++)
  {
    newp[index] = TextFrame::Make(*((TextFrame*)_pbox[index]));
    SetControlData(newp, newi, index);
  }

  for (;index < newlen; index++)
    RemoveControlData(newp, newi, index);
  
  Clear();

  _maxbox = newlen;
  _pbox = newp;
  _Info = newi;
}

/****************************************************************************/
int FrameWindow::Prompt(int StartIndex_)
{
  return 1;
}

/****************************************************************************/
// PURPOSE:
//   Prompt box Index operator. To index individual Prompt boxes from the
//   Prompt window given the position of the Prompt box within the array.
//
// PRE:
//   int index : the index position of the Prompt box in the array
//
// POST:
//   Go into the specified index position in the Prompt box array and
//   Retrieve its element.
//
FrameWindowRef FrameWindow::operator [] (int index)
{
  ASSERT((index >= 0 && index < _maxbox), USER_Message_t::ERRMSG_INDEXRANGE);

  FrameWindowRef PboxRef(this, index);
  return PboxRef;
}

/****************************************************************************/
/****************************************************************************/
FrameWindowRef::FrameWindowRef(FrameWindow* Boss_, int Index_):
_BossPtr(Boss_),
_Index(Index_)
{}

/****************************************************************************/
FrameWindowRef& FrameWindowRef::operator = (TextFrame* Tlabel_)
{
  _BossPtr->Control(_Index, Tlabel_);
  return *this;
}

/****************************************************************************/
FrameWindowRef::operator TextFrame* ()
{
  return CastToTextFrame(_BossPtr->Control(_Index));
}

/****************************************************************************/
TextFrame* FrameWindowRef::operator -> ()
{
  return CastToTextFrame(_BossPtr->Control(_Index));
}

/****************************************************************************/
/****************************************************************************/
#if TEXTFRAME_DEBUG
int main()
{
  CLRSCR();

  TextFrame* tl;
  FrameWindow pw;

  pw.MaxControl(1);

  tl = TextFrame::Make("This is Label #1");
  tl->SetXYpos(3, 3, 60, 5);
  pw[0] = tl;

  pw.Grow(3);

  tl = TextFrame::Make("This is Label #2");
  tl->SetXYpos(3, 7, 60, 9);
  pw[1] = tl;

  tl = TextFrame::Make("This is Label #3");
  tl->SetXYpos(3, 11, 60, 13);
  pw[2] = tl;

  tl = TextFrame::Make("This is Label #4");
  tl->SetXYpos(3, 15, 60, 17);
  pw[3] = tl;

  pw.UseColor();
  pw.Show();
  GETCH();
  pw.UseColor(FALSE);
  pw.Hide();

  int index;
  pw.UseColor();
  
  for (index = 0; index < pw.MaxControl(); index++)
  {
    tl = pw[index];
    GETCH();
    tl->Show();
  }

  pw.UseColor(FALSE);

  for (index = 0; index < pw.MaxControl(); index++)
  {
    tl = pw[index];
    GETCH();
    tl->Hide();
  }

  return 0;
}

#endif
/****************************************************************************/
#endif

