#ifndef TEXTFRAME_H
#define TEXTFRAME_H
#ifndef TEXTGRAPHICS_H
  #include "txtgraph.h"
#endif
#ifndef TEXTDRAWING_H
  #include "txtdraw.h"
#endif
#ifndef PROMPTBOX_H
  #include "promptbox.h"
#endif

#define TEXTFRAME_DEBUG		0

/****************************************************************************/
class LabelWindow;

class TextFrame : public TextDrawing
{
  protected:
    ControlWindow* _Owner;
    ColorInfo _ColorInfo;

    char* _msg;

    TextGraphics::GraphType_t _Type;	// Type of window frame
    int _x0pos;				// horizontal coordinate position
    int _y0pos;				// vertical coordinate position
    int _x1pos;				// horizontal coordinate position
    int _y1pos;				// vertical coordinate position

    int _Hidden;			// Dialog hidden flag
    int _InFocus;			// Text widget in focus flag
    int _TextWidgetActive;		// Active flag for this text widget

    int _SavedCursX;			// Saved cursor x position
    int _SavedCursY;			// Saved cursor y position

    // Internal data monitoring function pointers
    const int*(*_hidden_monitor)(void*, TextFrame*, const int*);
    const int*(*_active_monitor)(void*, TextFrame*, const int*);
    const int*(*_infocus_monitor)(void*, TextFrame*, const int*);

    // Handles to external objects, used by data monitors
    void* _hidden_handle;
    void* _active_handle;
    void* _infocus_handle;

    // Monitor functions execution and management methods
    const int* Monitor(const int*(*monptr_)(void*, TextFrame*, const int*), void* This_, const int* ptr_);
    void SaveCursorPosition();
    void RestoreCursorPosition();

    // internal hide method
    void IntHide();

    // Coordinate Validation method
    static Boolean ValidCoordinates(int x0, int y0, int x1, int y1);

    // Frame Printing methods
    void PrintHorzLine(int Xpos_, int Ypos_, int Endpos_, TextGraphics::ExtChar_t Char_);
    void PrintHorzLines(Boolean Visible_);
    void PrintVertLine(int Xpos_, int Ypos_, int Endpos_, TextGraphics::ExtChar_t Char_);
    void PrintVertLines(Boolean Visible_);
    void PrintCorners(Boolean Visible_);
    void PrintFrame();
    void EraseFrame();

    // Message Printing method
    void PrintMessage();

    // data member destruction method
    void Clear();

    // Text color methods
    void SetupColors(int Mode_);

    // promptbox constructors
    TextFrame(char* msg, int x0, int y0, int x1, int y1);
    TextFrame(TextFrame& pb);

  public:
    virtual ~TextFrame()
	{ Clear(); }

    // promptbox assignment operator
    TextFrame& operator = (TextFrame& pb);
    static TextFrame* Make(char* msg=NULL,
			   int x0=1, int y0=1, int x1=2, int y1=2);
    static TextFrame* Make(TextFrame& pbox);

    // prompt box properties mutators
    void SetMessage(const char* str);
    inline char* GetMessage()
	{ return _msg; }
    void SetXYpos(int x0, int y0, int x1, int y1);

    // prompt box manipulators
    virtual void Show();
    virtual void Hide();
    virtual void Erase();

    // Activation/Deactivation for this text widget
    virtual Boolean IsActive() const;
    virtual void Activate();
    virtual void Deactivate();

    // Text widget in focus method
    virtual Boolean IsInFocus() const;

    // Control Ownership methods
    virtual void SetOwner(ControlWindow* Pwin_, TextControl* TxtCtrl_);
    virtual Boolean IsOwner(ControlWindow* Pwin_) const;

    // Text color methods
    virtual void UseColor(Boolean Flag_=TRUE);
    virtual void SetNormalColors(int FgCol_, int BgCol_);
    virtual void SetHighLightColors(int FgCol_, int BgCol_);
    virtual void SetHotKeyColor(int Col_);
    virtual void SetBackGroundColor(int Col_);
    virtual void UseDefaultColors();

    virtual Boolean UsesColor() const;
    virtual int* NormalColors() const;
    virtual int* HighLightColors() const;
    virtual int BackGroundColor() const;
    virtual int HotKeyColor() const;

    // Internal data monitoring methods
    const int* MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*));
    const int* MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*));
    const int* MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, TextFrame*, const int*));
};

/****************************************************************************/
/****************************************************************************/
class FrameWindowRef;

class FrameWindow : public PromptWindow
{
  friend class FrameWindowRef;

  protected:
    virtual Boolean ValidityCheck();

  public:
    // prompt window constructors
    FrameWindow(int Max_=0);
    FrameWindow(FrameWindow& pw);
    virtual ~FrameWindow()
	{ Clear(); }

    // prompt window data mutators
    virtual void Grow(int extra);

    // Text label specific accessors
    FrameWindowRef operator [] (int index);
    TextFrame* NextSelected(int& Start_);

    // prompt window manipulators
    virtual int Prompt(int StartIndex_=0);
};

/****************************************************************************/
class FrameWindowRef
{
  friend class FrameWindow;
  private:
    FrameWindow* _BossPtr;
    int _Index;

    FrameWindowRef(FrameWindow* Boss_, int Index_);
    static TextFrame* CastToTextFrame(TextControl* TxtCtrl_)
	{ return ((TextFrame*)TxtCtrl_); }

  public:
    FrameWindowRef& operator = (TextFrame* Tlabel_);
    operator TextFrame* ();
    TextFrame* operator -> ();
};

/****************************************************************************/
#endif

